/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor.rmi;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import net.sourceforge.glsof.common.lsof.LsofExecutor;
import net.sourceforge.glsof.common.lsof.LsofExecutorImpl;
import net.sourceforge.glsof.common.lsof.LsofExecutorObserver;
import net.sourceforge.glsof.common.rmi.RmiService;

public class RmiServiceImpl
implements RmiService {
    private LsofExecutorObserver _observer;
    private LsofExecutor _lsofExecutor;

    @Override
    public void addObserver(LsofExecutorObserver observer) throws RemoteException {
        this._observer = observer;
        this._lsofExecutor = new LsofExecutorImpl(observer);
    }

    @Override
    public void fetch(String lsofParameters) throws RemoteException {
        try {
            Process process = Runtime.getRuntime().exec(lsofParameters);
            this._lsofExecutor.fetch(process.getInputStream());
            this.checkErrors(this._lsofExecutor.parseErrors(process.getErrorStream()));
            process.destroy();
        }
        catch (IOException e) {
            this.checkErrors("Lsof not found");
        }
    }

    @Override
    public void stop() throws RemoteException {
        this._lsofExecutor.stop();
    }

    private void checkErrors(String errors) {
        if (errors.isEmpty()) {
            return;
        }
        try {
            this._observer.displayErrorMessage(errors);
            this.stop();
            this._observer.stop();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            int port = RmiServiceImpl.findPort(args);
            Registry rmiRegistry = LocateRegistry.createRegistry(port);
            RmiService rmiService = (RmiService)UnicastRemoteObject.exportObject((Remote)new RmiServiceImpl(), port);
            rmiRegistry.bind("lsofExecutor", rmiService);
        }
        catch (NumberFormatException e) {
            RmiServiceImpl.usage();
        }
        catch (AccessException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (AlreadyBoundException e) {
            e.printStackTrace();
        }
        System.out.println("RMI Lsof Executor service started.");
    }

    private static int findPort(String[] args) throws NumberFormatException {
        int port;
        int n = port = args.length < 1 ? 1099 : Integer.parseInt(args[0]);
        if (port < 0 || port > 65535) {
            throw new NumberFormatException();
        }
        return port;
    }

    private static void usage() {
        System.out.println("Usage: java -Djava.security.policy=path/server-policy.txt -jar remote-lsof.jar <service-port>");
        System.out.println("<service-port> = 2000, etc. 1099 is default.");
        System.out.println("Example: java -Djava.rmi.server.hostname=192.168.1.20 -Djava.security.policy=path/server-policy.txt -jar remote-lsof.jar 2000");
        System.exit(1);
    }
}

