/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;

class Slice {
    final P4 leftPlane = new P4();
    final P4 middle = new P4();
    final P4 rightPlane = new P4();
    float angleXY;
    float anglefromZ;
    float position;
    float thickness;
    final P3 boundBoxNegCorner = new P3();
    final P3 boundBoxPosCorner = new P3();
    final P3 boundBoxCenter = new P3();
    float diagonal;

    Slice() {
    }

    static void makePlane(float f, float f2, float f3, P4 p4) {
        p4.set4((float)(Math.cos(f2) * Math.sin(f3)), (float)(Math.sin(f2) * Math.sin(f3)), (float)Math.cos(f3), -f);
    }

    void setSlice(float f, float f2, float f3, float f4, P3 p3, V3 v3, boolean bl) {
        if (f >= 0.0f && (double)f < Math.PI) {
            this.angleXY = f;
        } else {
            float f5 = (float)Math.floor((double)f / Math.PI);
            this.angleXY = (float)((double)f - (double)f5 * Math.PI);
        }
        if (f2 >= 0.0f && (double)f2 < Math.PI) {
            this.anglefromZ = f2;
        } else {
            double d = Math.floor((double)f2 / Math.PI);
            this.anglefromZ = (float)((double)f2 - d * Math.PI);
        }
        this.position = f3;
        this.thickness = f4;
        this.boundBoxCenter.setT(p3);
        this.boundBoxNegCorner.sub2(p3, v3);
        this.boundBoxPosCorner.add2(p3, v3);
        this.diagonal = this.boundBoxPosCorner.distance(this.boundBoxNegCorner);
        Slice.makePlane(f3, f, f2, this.middle);
        if (!bl) {
            P3 p32 = P3.new3(this.middle.x, this.middle.y, this.middle.z);
            p32.scaleAdd2(-this.middle.w, p32, p3);
            Measure.getPlaneThroughPoint(p32, V3.new3(this.middle.x, this.middle.y, this.middle.z), this.middle);
        }
        this.leftPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.leftPlane.w += f4 / 2.0f;
        this.rightPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.rightPlane.w -= f4 / 2.0f;
        System.out.println(f4 + " left:" + this.leftPlane + " right:" + this.rightPlane);
    }

    Slice getSlice() {
        return this;
    }

    P4 getMiddle() {
        return this.middle;
    }
}

