/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ZapToggleButton;

public class MainToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MainToolbarPanel.class);
    private JToolBar toolbar = null;
    private JComboBox<String> modeSelect = null;
    private JButton btnNew = null;
    private JButton btnOpen = null;
    private JButton btnSave = null;
    private JButton btnSnapshot = null;
    private JButton btnSession = null;
    private JButton btnOptions = null;
    private ButtonGroup expandButtons;
    private JToggleButton btnExpandSites = null;
    private JToggleButton btnExpandReports = null;
    private JToggleButton btnExpandFull = null;
    private boolean showtabiconnames = false;
    private ZapToggleButton btnShowTabIconNames = null;
    private JButton btnShowAllTabs = null;
    private JButton btnHideAllTabs = null;

    public MainToolbarPanel() {
        this.initialise();
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 25));
        this.setMaximumSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 25));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.expandButtons = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 2;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setEnabled(true);
        jToolBar.setPreferredSize(new Dimension(80000, 25));
        jToolBar.setMaximumSize(new Dimension(80000, 25));
        this.add((Component)this.getToolbar(), gridBagConstraints);
        this.add((Component)jToolBar, gridBagConstraints2);
        this.toolbar.add(this.getModeSelect());
        this.toolbar.add(this.getBtnNew());
        this.toolbar.add(this.getBtnOpen());
        this.toolbar.add(this.getBtnSave());
        this.toolbar.add(this.getBtnSnapshot());
        this.toolbar.add(this.getBtnSession());
        this.toolbar.add(this.getBtnOptions());
        this.toolbar.addSeparator();
        this.toolbar.add(this.getShowAllTabs());
        this.toolbar.add(this.getHideAllTabs());
        this.toolbar.add(this.getShowTabIconNames());
        this.toolbar.addSeparator();
        this.toolbar.add(this.getBtnExpandSites());
        this.toolbar.add(this.getBtnExpandReports());
        this.toolbar.add(this.getBtnExpandFull());
        this.toolbar.addSeparator();
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setEnabled(true);
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setName("Main Toolbar");
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.toolbar;
    }

    public void addButton(JButton jButton) {
        DisplayUtils.scaleIcon(jButton);
        this.getToolbar().add(jButton);
    }

    public void removeButton(JButton jButton) {
        this.getToolbar().remove(jButton);
    }

    public void addButton(JToggleButton jToggleButton) {
        DisplayUtils.scaleIcon(jToggleButton);
        this.getToolbar().add(jToggleButton);
    }

    public void removeButton(JToggleButton jToggleButton) {
        this.getToolbar().remove(jToggleButton);
    }

    public void addSeparator() {
        this.getToolbar().addSeparator();
    }

    public void addSeparator(JToolBar.Separator separator) {
        this.getToolbar().add(separator);
    }

    public void removeSeparator(JToolBar.Separator separator) {
        this.getToolbar().remove(separator);
    }

    private JComboBox<String> getModeSelect() {
        if (this.modeSelect == null) {
            this.modeSelect = new JComboBox();
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.safe.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.protect.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.standard.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.attack.select"));
            this.modeSelect.setToolTipText(Constant.messages.getString("view.toolbar.mode.tooltip"));
            ToolTipManager.sharedInstance().setDismissDelay(12000);
            ToolTipManager.sharedInstance().registerComponent(this.modeSelect);
            Control.Mode mode = Control.Mode.valueOf(Model.getSingleton().getOptionsParam().getViewParam().getMode());
            switch (mode) {
                case safe: {
                    this.modeSelect.setSelectedIndex(0);
                    break;
                }
                case protect: {
                    this.modeSelect.setSelectedIndex(1);
                    break;
                }
                case standard: {
                    this.modeSelect.setSelectedIndex(2);
                    break;
                }
                case attack: {
                    this.modeSelect.setSelectedIndex(3);
                }
            }
            this.modeSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.Mode mode = null;
                    switch (MainToolbarPanel.this.modeSelect.getSelectedIndex()) {
                        case 0: {
                            mode = Control.Mode.safe;
                            break;
                        }
                        case 1: {
                            mode = Control.Mode.protect;
                            break;
                        }
                        case 2: {
                            mode = Control.Mode.standard;
                            break;
                        }
                        case 3: {
                            mode = Control.Mode.attack;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Control.getSingleton().setMode(mode);
                }
            });
        }
        return this.modeSelect;
    }

    public void setMode(Control.Mode mode) {
        this.getModeSelect().setSelectedItem(Constant.messages.getString("view.toolbar.mode." + mode.name() + ".select"));
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/021.png"))));
            this.btnNew.setToolTipText(Constant.messages.getString("menu.file.newSession"));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Control.getSingleton().getMenuFileControl().newSession(true);
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                    }
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnOpen() {
        if (this.btnOpen == null) {
            this.btnOpen = new JButton();
            this.btnOpen.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/047.png"))));
            this.btnOpen.setToolTipText(Constant.messages.getString("menu.file.openSession"));
            this.btnOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Control.getSingleton().getMenuFileControl().openSession();
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.openSession.error"));
                    }
                }
            });
        }
        return this.btnOpen;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/096.png"))));
            this.btnSave.setToolTipText(Constant.messages.getString("menu.file.persistSession"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (Model.getSingleton().getSession().isNewState()) {
                            Control.getSingleton().getMenuFileControl().saveAsSession();
                        } else {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionExists.error"));
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.persistSession.error"));
                    }
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnSnapshot() {
        if (this.btnSnapshot == null) {
            this.btnSnapshot = new JButton();
            this.btnSnapshot.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/fugue/camera.png"))));
            this.btnSnapshot.setToolTipText(Constant.messages.getString("menu.file.snapshotSession"));
            this.btnSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (Model.getSingleton().getSession().isNewState()) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionNotExist.error"));
                        } else {
                            Control.getSingleton().getMenuFileControl().saveSnapshot();
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.persistSession.error"));
                    }
                }
            });
        }
        return this.btnSnapshot;
    }

    private JButton getBtnSession() {
        if (this.btnSession == null) {
            this.btnSession = new JButton();
            this.btnSession.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/024.png"))));
            this.btnSession.setToolTipText(Constant.messages.getString("menu.file.sessionProperties"));
            this.btnSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuFileControl().properties();
                }
            });
        }
        return this.btnSession;
    }

    private JButton getBtnOptions() {
        if (this.btnOptions == null) {
            this.btnOptions = new JButton();
            this.btnOptions.setToolTipText(Constant.messages.getString("menu.tools.options"));
            this.btnOptions.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/041.png"))));
            this.btnOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuToolsControl().options();
                }
            });
        }
        return this.btnOptions;
    }

    private JToggleButton getBtnExpandSites() {
        if (this.btnExpandSites == null) {
            this.btnExpandSites = new JToggleButton(new ChangeDisplayOptionAction(MainToolbarPanel.class.getResource("/resource/icon/expand_sites.png"), 0));
            this.btnExpandSites.setToolTipText(Constant.messages.getString("view.toolbar.expandSites"));
            this.expandButtons.add(this.btnExpandSites);
        }
        return this.btnExpandSites;
    }

    private JToggleButton getBtnExpandReports() {
        if (this.btnExpandReports == null) {
            this.btnExpandReports = new JToggleButton(new ChangeDisplayOptionAction(MainToolbarPanel.class.getResource("/resource/icon/expand_info.png"), 1));
            this.btnExpandReports.setToolTipText(Constant.messages.getString("view.toolbar.expandInfo"));
            this.expandButtons.add(this.btnExpandReports);
        }
        return this.btnExpandReports;
    }

    private JToggleButton getBtnExpandFull() {
        if (this.btnExpandFull == null) {
            this.btnExpandFull = new JToggleButton(new ChangeDisplayOptionAction(MainToolbarPanel.class.getResource("/resource/icon/expand_full.png"), 2));
            this.btnExpandFull.setToolTipText(Constant.messages.getString("view.toolbar.expandFull"));
            this.expandButtons.add(this.btnExpandFull);
        }
        return this.btnExpandFull;
    }

    private void setShowTabIconNames(boolean bl) {
        this.showtabiconnames = bl;
        this.btnShowTabIconNames.setSelected(bl);
    }

    private JToggleButton getShowTabIconNames() {
        if (this.btnShowTabIconNames == null) {
            this.btnShowTabIconNames = new ZapToggleButton();
            this.btnShowTabIconNames.setIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/ui_tab_icon.png")));
            this.btnShowTabIconNames.setToolTipText(Constant.messages.getString("view.toolbar.showNames"));
            this.btnShowTabIconNames.setSelectedIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/ui_tab_text.png")));
            this.btnShowTabIconNames.setSelectedToolTipText(Constant.messages.getString("view.toolbar.showIcons"));
            this.setShowTabIconNames(Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames());
            DisplayUtils.scaleIcon(this.btnShowTabIconNames);
            this.btnShowTabIconNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainToolbarPanel.this.setShowTabIconNames(MainToolbarPanel.this.getShowTabIconNames().isSelected());
                    Model.getSingleton().getOptionsParam().getViewParam().setShowTabNames(MainToolbarPanel.this.showtabiconnames);
                    try {
                        Model.getSingleton().getOptionsParam().getViewParam().getConfig().save();
                    }
                    catch (ConfigurationException configurationException) {
                        logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                    }
                }
            });
        }
        return this.btnShowTabIconNames;
    }

    private JButton getShowAllTabs() {
        if (this.btnShowAllTabs == null) {
            this.btnShowAllTabs = new JButton();
            this.btnShowAllTabs.setIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/fugue/ui-tab-show.png")));
            this.btnShowAllTabs.setToolTipText(Constant.messages.getString("menu.view.tabs.show"));
            DisplayUtils.scaleIcon(this.btnShowAllTabs);
            this.btnShowAllTabs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    View.getSingleton().showAllTabs();
                }
            });
        }
        return this.btnShowAllTabs;
    }

    private JButton getHideAllTabs() {
        if (this.btnHideAllTabs == null) {
            this.btnHideAllTabs = new JButton();
            this.btnHideAllTabs.setIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/fugue/ui-tab-hide.png")));
            this.btnHideAllTabs.setToolTipText(Constant.messages.getString("menu.view.tabs.hide"));
            DisplayUtils.scaleIcon(this.btnHideAllTabs);
            this.btnHideAllTabs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    View.getSingleton().hideAllTabs();
                }
            });
        }
        return this.btnHideAllTabs;
    }

    public void setDisplayOption(int n) {
        if (n == 1) {
            this.btnExpandReports.setSelected(true);
        } else if (n == 0) {
            this.btnExpandSites.setSelected(true);
        } else if (n == 2) {
            this.btnExpandFull.setSelected(true);
        }
    }

    public void sessionChanged(Session session) {
        if (session != null) {
            this.getBtnSave().setEnabled(session.isNewState());
            this.getBtnSnapshot().setEnabled(!session.isNewState());
        }
    }

    private static class ChangeDisplayOptionAction
    extends AbstractAction {
        private static final long serialVersionUID = 8323387638733162321L;
        private final int displayOption;

        public ChangeDisplayOptionAction(URL uRL, int n) {
            super("", DisplayUtils.getScaledIcon(new ImageIcon(uRL)));
            this.displayOption = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Model.getSingleton().getOptionsParam().getViewParam().getDisplayOption() != this.displayOption) {
                View.getSingleton().getMainFrame().changeDisplayOption(this.displayOption);
                try {
                    Model.getSingleton().getOptionsParam().getConfig().save();
                }
                catch (ConfigurationException configurationException) {
                    logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                }
            }
        }
    }
}

