/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;

public class MappingMetaData
extends AbstractDiffable<MappingMetaData> {
    public static final MappingMetaData PROTO = new MappingMetaData();
    private final String type;
    private final CompressedXContent source;
    private Id id;
    private Routing routing;
    private Timestamp timestamp;
    private boolean hasParentField;

    public MappingMetaData(DocumentMapper docMapper) {
        this.type = docMapper.type();
        this.source = docMapper.mappingSource();
        this.id = new Id(docMapper.idFieldMapper().path());
        this.routing = new Routing(docMapper.routingFieldMapper().required(), docMapper.routingFieldMapper().path());
        this.timestamp = new Timestamp(docMapper.timestampFieldMapper().enabled(), docMapper.timestampFieldMapper().path(), docMapper.timestampFieldMapper().fieldType().dateTimeFormatter().format(), docMapper.timestampFieldMapper().defaultTimestamp(), docMapper.timestampFieldMapper().ignoreMissing());
        this.hasParentField = docMapper.parentFieldMapper().active();
    }

    public MappingMetaData(CompressedXContent mapping) throws IOException {
        Map<String, Object> mappingMap;
        this.source = mapping;
        try (XContentParser parser = XContentHelper.createParser(mapping.compressedReference());){
            mappingMap = parser.mapOrdered();
        }
        if (mappingMap.size() != 1) {
            throw new IllegalStateException("Can't derive type from mapping, no root type: " + mapping.string());
        }
        this.type = mappingMap.keySet().iterator().next();
        this.initMappers((Map)mappingMap.get(this.type));
    }

    public MappingMetaData(Map<String, Object> mapping) throws IOException {
        this(mapping.keySet().iterator().next(), mapping);
    }

    public MappingMetaData(String type, Map<String, Object> mapping) throws IOException {
        this.type = type;
        XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().map(mapping);
        this.source = new CompressedXContent(mappingBuilder.bytes());
        Map withoutType = mapping;
        if (mapping.size() == 1 && mapping.containsKey(type)) {
            withoutType = (Map)mapping.get(type);
        }
        this.initMappers(withoutType);
    }

    private MappingMetaData() {
        this.type = "";
        try {
            this.source = new CompressedXContent("{}");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create MappingMetaData prototype", ex);
        }
    }

    private void initMappers(Map<String, Object> withoutType) {
        String path;
        if (withoutType.containsKey("_id")) {
            String path2 = null;
            Map routingNode = (Map)withoutType.get("_id");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("path")) continue;
                path2 = fieldNode.toString();
            }
            this.id = new Id(path2);
        } else {
            this.id = Id.EMPTY;
        }
        if (withoutType.containsKey("_routing")) {
            boolean required = false;
            path = null;
            Map routingNode = (Map)withoutType.get("_routing");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("required")) {
                    required = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (!fieldName.equals("path")) continue;
                path = fieldNode.toString();
            }
            this.routing = new Routing(required, path);
        } else {
            this.routing = Routing.EMPTY;
        }
        if (withoutType.containsKey("_timestamp")) {
            boolean enabled = false;
            path = null;
            String format = "epoch_millis||strictDateOptionalTime";
            String defaultTimestamp = "now";
            Boolean ignoreMissing = null;
            Map timestampNode = (Map)withoutType.get("_timestamp");
            for (Map.Entry entry : timestampNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    enabled = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("path")) {
                    path = fieldNode.toString();
                    continue;
                }
                if (fieldName.equals("format")) {
                    format = fieldNode.toString();
                    continue;
                }
                if (fieldName.equals("default") && fieldNode != null) {
                    defaultTimestamp = fieldNode.toString();
                    continue;
                }
                if (!fieldName.equals("ignore_missing")) continue;
                ignoreMissing = XContentMapValues.nodeBooleanValue(fieldNode);
            }
            this.timestamp = new Timestamp(enabled, path, format, defaultTimestamp, ignoreMissing);
        } else {
            this.timestamp = Timestamp.EMPTY;
        }
        this.hasParentField = withoutType.containsKey("_parent");
    }

    public MappingMetaData(String type, CompressedXContent source, Id id, Routing routing, Timestamp timestamp, boolean hasParentField) {
        this.type = type;
        this.source = source;
        this.id = id;
        this.routing = routing;
        this.timestamp = timestamp;
        this.hasParentField = hasParentField;
    }

    void updateDefaultMapping(MappingMetaData defaultMapping) {
        if (this.id == Id.EMPTY) {
            this.id = defaultMapping.id();
        }
        if (this.routing == Routing.EMPTY) {
            this.routing = defaultMapping.routing();
        }
        if (this.timestamp == Timestamp.EMPTY) {
            this.timestamp = defaultMapping.timestamp();
        }
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent source() {
        return this.source;
    }

    public boolean hasParentField() {
        return this.hasParentField;
    }

    public Map<String, Object> sourceAsMap() throws IOException {
        Map mapping = XContentHelper.convertToMap(this.source.compressedReference(), true).v2();
        if (mapping.size() == 1 && mapping.containsKey(this.type())) {
            mapping = (Map)mapping.get(this.type());
        }
        return mapping;
    }

    public Map<String, Object> getSourceAsMap() throws IOException {
        return this.sourceAsMap();
    }

    public Id id() {
        return this.id;
    }

    public Routing routing() {
        return this.routing;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public ParseContext createParseContext(@Nullable String id, @Nullable String routing, @Nullable String timestamp) {
        return new ParseContext(id == null && this.id().hasPath(), this.routing().hasPath(), timestamp == null && this.timestamp().hasPath());
    }

    public void parse(XContentParser parser, ParseContext parseContext) throws IOException {
        this.innerParse(parser, parseContext);
    }

    private void innerParse(XContentParser parser, ParseContext context) throws IOException {
        String timestampPart;
        if (!context.parsingStillNeeded()) {
            return;
        }
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        String idPart = context.idParsingStillNeeded() ? this.id().pathElements()[context.locationId] : null;
        String routingPart = context.routingParsingStillNeeded() ? this.routing().pathElements()[context.locationRouting] : null;
        String string = timestampPart = context.timestampParsingStillNeeded() ? this.timestamp().pathElements()[context.locationTimestamp] : null;
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            token = parser.nextToken();
            boolean incLocationId = false;
            boolean incLocationRouting = false;
            boolean incLocationTimestamp = false;
            if (context.idParsingStillNeeded() && fieldName.equals(idPart)) {
                if (context.locationId + 1 == this.id.pathElements().length) {
                    if (!token.isValue()) {
                        throw new MapperParsingException("id field must be a value but was either an object or an array");
                    }
                    context.id = parser.textOrNull();
                    context.idResolved = true;
                } else {
                    incLocationId = true;
                }
            }
            if (context.routingParsingStillNeeded() && fieldName.equals(routingPart)) {
                if (context.locationRouting + 1 == this.routing.pathElements().length) {
                    context.routing = parser.textOrNull();
                    context.routingResolved = true;
                } else {
                    incLocationRouting = true;
                }
            }
            if (context.timestampParsingStillNeeded() && fieldName.equals(timestampPart)) {
                if (context.locationTimestamp + 1 == this.timestamp.pathElements().length) {
                    context.timestamp = parser.textOrNull();
                    context.timestampResolved = true;
                } else {
                    incLocationTimestamp = true;
                }
            }
            if (incLocationId || incLocationRouting || incLocationTimestamp) {
                if (token == XContentParser.Token.START_OBJECT) {
                    context.locationId = context.locationId + (incLocationId ? 1 : 0);
                    context.locationRouting = context.locationRouting + (incLocationRouting ? 1 : 0);
                    context.locationTimestamp = context.locationTimestamp + (incLocationTimestamp ? 1 : 0);
                    this.innerParse(parser, context);
                    context.locationId = context.locationId - (incLocationId ? 1 : 0);
                    context.locationRouting = context.locationRouting - (incLocationRouting ? 1 : 0);
                    context.locationTimestamp = context.locationTimestamp - (incLocationTimestamp ? 1 : 0);
                }
            } else {
                parser.skipChildren();
            }
            if (!context.parsingStillNeeded()) {
                return;
            }
            token = parser.nextToken();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type());
        this.source().writeTo(out);
        if (this.id().hasPath()) {
            out.writeBoolean(true);
            out.writeString(this.id().path());
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.routing().required());
        if (this.routing().hasPath()) {
            out.writeBoolean(true);
            out.writeString(this.routing().path());
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.timestamp().enabled());
        out.writeOptionalString(this.timestamp().path());
        out.writeString(this.timestamp().format());
        out.writeOptionalString(this.timestamp().defaultTimestamp());
        out.writeOptionalBoolean(this.timestamp().ignoreMissing());
        out.writeBoolean(this.hasParentField());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingMetaData that = (MappingMetaData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.routing.equals(that.routing)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.routing.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        return result;
    }

    @Override
    public MappingMetaData readFrom(StreamInput in) throws IOException {
        String type = in.readString();
        CompressedXContent source = CompressedXContent.readCompressedString(in);
        Id id = new Id(in.readBoolean() ? in.readString() : null);
        Routing routing = new Routing(in.readBoolean(), in.readBoolean() ? in.readString() : null);
        boolean enabled = in.readBoolean();
        String path = in.readOptionalString();
        String format = in.readString();
        String defaultTimestamp = in.readOptionalString();
        Boolean ignoreMissing = null;
        ignoreMissing = in.readOptionalBoolean();
        Timestamp timestamp = new Timestamp(enabled, path, format, defaultTimestamp, ignoreMissing);
        boolean hasParentField = in.readBoolean();
        return new MappingMetaData(type, source, id, routing, timestamp, hasParentField);
    }

    public static class ParseContext {
        final boolean shouldParseId;
        final boolean shouldParseRouting;
        final boolean shouldParseTimestamp;
        int locationId = 0;
        int locationRouting = 0;
        int locationTimestamp = 0;
        boolean idResolved;
        boolean routingResolved;
        boolean timestampResolved;
        String id;
        String routing;
        String timestamp;

        public ParseContext(boolean shouldParseId, boolean shouldParseRouting, boolean shouldParseTimestamp) {
            this.shouldParseId = shouldParseId;
            this.shouldParseRouting = shouldParseRouting;
            this.shouldParseTimestamp = shouldParseTimestamp;
        }

        public String id() {
            return this.id;
        }

        public boolean shouldParseId() {
            return this.shouldParseId;
        }

        public boolean idResolved() {
            return this.idResolved;
        }

        public boolean idParsingStillNeeded() {
            return this.shouldParseId && !this.idResolved;
        }

        public String routing() {
            return this.routing;
        }

        public boolean shouldParseRouting() {
            return this.shouldParseRouting;
        }

        public boolean routingResolved() {
            return this.routingResolved;
        }

        public boolean routingParsingStillNeeded() {
            return this.shouldParseRouting && !this.routingResolved;
        }

        public String timestamp() {
            return this.timestamp;
        }

        public boolean shouldParseTimestamp() {
            return this.shouldParseTimestamp;
        }

        public boolean timestampResolved() {
            return this.timestampResolved;
        }

        public boolean timestampParsingStillNeeded() {
            return this.shouldParseTimestamp && !this.timestampResolved;
        }

        public boolean shouldParse() {
            return this.shouldParseId || this.shouldParseRouting || this.shouldParseTimestamp;
        }

        public boolean parsingStillNeeded() {
            return this.idParsingStillNeeded() || this.routingParsingStillNeeded() || this.timestampParsingStillNeeded();
        }
    }

    public static class Timestamp {
        private static final FormatDateTimeFormatter EPOCH_MILLIS_PARSER = Joda.forPattern("epoch_millis");
        public static final Timestamp EMPTY = new Timestamp(false, null, "epoch_millis||strictDateOptionalTime", "now", null);
        private final boolean enabled;
        private final String path;
        private final String format;
        private final String[] pathElements;
        private final FormatDateTimeFormatter dateTimeFormatter;
        private final String defaultTimestamp;
        private final Boolean ignoreMissing;

        public static String parseStringTimestamp(String timestampAsString, FormatDateTimeFormatter dateTimeFormatter, Version version) throws TimestampParsingException {
            try {
                FormatDateTimeFormatter formatter = version.onOrAfter(Version.V_2_0_0_beta1) ? dateTimeFormatter : EPOCH_MILLIS_PARSER;
                return Long.toString(formatter.parser().parseMillis(timestampAsString));
            }
            catch (RuntimeException e) {
                if (version.before(Version.V_2_0_0_beta1)) {
                    try {
                        return Long.toString(dateTimeFormatter.parser().parseMillis(timestampAsString));
                    }
                    catch (RuntimeException e1) {
                        throw new TimestampParsingException(timestampAsString, e1);
                    }
                }
                throw new TimestampParsingException(timestampAsString, e);
            }
        }

        public Timestamp(boolean enabled, String path, String format, String defaultTimestamp, Boolean ignoreMissing) {
            this.enabled = enabled;
            this.path = path;
            this.pathElements = path == null ? Strings.EMPTY_ARRAY : Strings.delimitedListToStringArray(path, ".");
            this.format = format;
            this.dateTimeFormatter = Joda.forPattern(format);
            this.defaultTimestamp = defaultTimestamp;
            this.ignoreMissing = ignoreMissing;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean hasPath() {
            return this.path != null;
        }

        public String path() {
            return this.path;
        }

        public String[] pathElements() {
            return this.pathElements;
        }

        public String format() {
            return this.format;
        }

        public String defaultTimestamp() {
            return this.defaultTimestamp;
        }

        public boolean hasDefaultTimestamp() {
            return this.defaultTimestamp != null;
        }

        public Boolean ignoreMissing() {
            return this.ignoreMissing;
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timestamp timestamp = (Timestamp)o;
            if (this.enabled != timestamp.enabled) {
                return false;
            }
            if (this.format != null ? !this.format.equals(timestamp.format) : timestamp.format != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(timestamp.path) : timestamp.path != null) {
                return false;
            }
            if (this.defaultTimestamp != null ? !this.defaultTimestamp.equals(timestamp.defaultTimestamp) : timestamp.defaultTimestamp != null) {
                return false;
            }
            if (this.ignoreMissing != null ? !this.ignoreMissing.equals(timestamp.ignoreMissing) : timestamp.ignoreMissing != null) {
                return false;
            }
            return Arrays.equals(this.pathElements, timestamp.pathElements);
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.pathElements != null ? Arrays.hashCode(this.pathElements) : 0);
            result = 31 * result + (this.dateTimeFormatter != null ? this.dateTimeFormatter.hashCode() : 0);
            result = 31 * result + (this.defaultTimestamp != null ? this.defaultTimestamp.hashCode() : 0);
            result = 31 * result + (this.ignoreMissing != null ? this.ignoreMissing.hashCode() : 0);
            return result;
        }
    }

    public static class Routing {
        public static final Routing EMPTY = new Routing(false, null);
        private final boolean required;
        private final String path;
        private final String[] pathElements;

        public Routing(boolean required, String path) {
            this.required = required;
            this.path = path;
            this.pathElements = path == null ? Strings.EMPTY_ARRAY : Strings.delimitedListToStringArray(path, ".");
        }

        public boolean required() {
            return this.required;
        }

        public boolean hasPath() {
            return this.path != null;
        }

        public String path() {
            return this.path;
        }

        public String[] pathElements() {
            return this.pathElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Routing routing = (Routing)o;
            if (this.required != routing.required) {
                return false;
            }
            if (this.path != null ? !this.path.equals(routing.path) : routing.path != null) {
                return false;
            }
            return Arrays.equals(this.pathElements, routing.pathElements);
        }

        public int hashCode() {
            int result = this.required ? 1 : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.pathElements != null ? Arrays.hashCode(this.pathElements) : 0);
            return result;
        }
    }

    public static class Id {
        public static final Id EMPTY = new Id(null);
        private final String path;
        private final String[] pathElements;

        public Id(String path) {
            this.path = path;
            this.pathElements = path == null ? Strings.EMPTY_ARRAY : Strings.delimitedListToStringArray(path, ".");
        }

        public boolean hasPath() {
            return this.path != null;
        }

        public String path() {
            return this.path;
        }

        public String[] pathElements() {
            return this.pathElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            if (this.path != null ? !this.path.equals(id.path) : id.path != null) {
                return false;
            }
            return Arrays.equals(this.pathElements, id.pathElements);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.pathElements != null ? Arrays.hashCode(this.pathElements) : 0);
            return result;
        }
    }
}

