/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.PercentageScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ScriptHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;

public class SignificanceHeuristicParserMapper {
    protected final Map<String, SignificanceHeuristicParser> significanceHeuristicParsers;

    @Inject
    public SignificanceHeuristicParserMapper(Set<SignificanceHeuristicParser> parsers, ScriptService scriptService) {
        HashMap<String, SignificanceHeuristicParser> map = new HashMap<String, SignificanceHeuristicParser>();
        this.add(map, new JLHScore.JLHScoreParser());
        this.add(map, new PercentageScore.PercentageScoreParser());
        this.add(map, new MutualInformation.MutualInformationParser());
        this.add(map, new ChiSquare.ChiSquareParser());
        this.add(map, new GND.GNDParser());
        this.add(map, new ScriptHeuristic.ScriptHeuristicParser(scriptService));
        for (SignificanceHeuristicParser parser : parsers) {
            this.add(map, parser);
        }
        this.significanceHeuristicParsers = Collections.unmodifiableMap(map);
    }

    public SignificanceHeuristicParser get(String parserName) {
        return this.significanceHeuristicParsers.get(parserName);
    }

    private void add(Map<String, SignificanceHeuristicParser> map, SignificanceHeuristicParser parser) {
        for (String type : parser.getNames()) {
            map.put(type, parser);
        }
    }
}

