#############################################################################
##
#W  3ctsgrp-conjugacyclasses.g        GAP4 Package `RCWA'         Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of indices
##  of groups which are conjugate in RCWA(Z).
##
##  The list 'conjugacyclasses' below contains lists of indices of conjugate
##  groups in the list grps. Here 'conjugate' means 'conjugate in RCWA(Z)'.
##  Due to the computational difficulty of conjugacy tests for the groups
##  in question it is not guaranteed that grps[i] and grps[j] are not
##  conjugate if i and j do not lie in the same list in 'conjugacyclasses'.
##
#############################################################################

return [[1,2,68],
 [3,7,69,73,219,220,222,223,226,227,237,239,465,466,468,469,
   472,473,483,485,2413,2450,2696,4558,4579,4825,8917,8918,
   8920,8921,8924,8925,8935,8937,11043,11045,11046,11047,11052,
   11061,11062,12819,12820,12822,12824,12827,12829,12837,12840,
   12844,13608,13654,13738,13889,13920,14083,18909,18953,19032,
   19146,19545,19696],[4,10,70,76],
 [5,8,71,74,2539,4684,15607,15608,16252,23936,23938,24046],
 [6,12,75,77],[9,11,72,78],[13,14,16,19,79,80,82,85],
 [15,17,20,81,83,86],[18,21,84,87],[22,88],
 [23,31,44,90,94,107,1296,1297,1307,1309,1349,1391,1424,1426,
   1437,1439,1472,1511,3686,3725,3905,3970,5858,5859,5870,5872,
   7860,7939,8130,8134,13772,14175,14198,19010,19278,19376,
   42528,42571,42711,42800,43373,44353,45930,45955,45987,46669,
   47631,48470],
 [24,25,27,28,33,35,46,48,97,98,99,101,108,110,112,114,154,
   155,159,162,172,175,2303,2304,2309,2312,2323,2325,2368,
   2369,2374,2377,2388,2390,4513,4514,4519,4522,4533,4535],
 [26,32,41,42,89,91,92,93,1289,1290,1292,1293,1298,1300,1311,
   1313,1333,1334,1335,1376,1378,1418,1419,1422,1423,1433,1435,
   1459,1613,1622,1623,1657,1660,1685,1691,1696,1756,1763,1928,
   1930,1932,1934,1955,2049,3563,3565,3567,3605,3607,3609,3643,
   3644,3646,3868,3869,3871,4141,4166,4215,4217,5647,5648,5649,
   5732,5733,5734,5775,5815,5857,5861,5868,5874,5972,5985,6113,
   6315,7733,7734,7736,7776,7777,7779,7898,7900,7908,8050,8063,
   8085,8121,8127,8132,8368,38606,38607,38669,38670,39326,39332,
   39363,39369,40459,40462,40488,40491,40814,40815,40822,40823,
   41249,41254,41279,41284,41969,41970,42091,42092,42272,42273,
   42277,42278,43268,43274,43339,43347,43406,43414,43468,43469,
   43528,43533,43634,43663,43976,43977,44110,44113,44168,44169,
   44396,44416,44454,44456,44830,44831,45297,45305,45774,45776,
   45781,45782,46477,46483,46597,46732,46786,46803,46951,46954,
   47348,47349,47354,47356,47444,47449,47584,47608,47731,47764,
   47908,47911,47989,48104,48447,48552,48570,48588,48897,48903,
   48904,48905,49060,49104,49159,49163,49165,49166,49421,49450,
   49588,49803,50182,50789,50834,50856,51986,52030,52073,52107,
   52131,52172],
 [29,37,43,47,102,104,116,118,1545,1796,1857,1982],
 [30,38,109,115],[34,36,103,117],[39,54,105,120],
 [40,55,111,119],[45,53,106,121],[49,50,95,96],
 [51,52,100,113,14065,19486],[56,59,62,67,126,129,130,131],
 [57,58,60,61,63,64,65,66,122,123,124,125,127,128,132,133],
 [134,138,6638],[135,141],[136,139],[137,140,142,143],
 [144,145,147,150],[146,148,151],[149,152],[153],
 [156,158,163,166,173,177,1339,1340,1341,1343,1350,1352,1354,
   1356,1381,1382,1383,1385,1392,1394,1396,1398,1462,1463,1464,
   1466,1473,1475,1477,1479,1501,1502,1503,1505,1512,1514,1516,
   1518,1614,1616,1627,1629,1649,1651,1662,1664,1692,1694,1757,
   1759,1957,1959,2004,2006],
 [157,164,179,2305,2310,2321,2370,2375,2386,4515,4520,4531,
   12685,12686,12805,12807,12808,18290],[160,178,181,183],
 [161,165,180,182,1596,1732],[167,168,169,174],[170,185],
 [171,176,184,186],[187,190,191,193,194,195,196,198],
 [188,189,192,197],
 [199,200,203,205,263,265,266,327,330,449,451,510,3762,3763,
   3766,4030,4031,4034,4190,4216,5862,5864,5876,5878,6140,6154,
   6211,6483,8014,8015,8030,8120,8135,8137,8170,8545,8717,8718,
   8720,8779,8780,8782,8901,8903,10732,10733,10735,10856,10915,
   12745,12806,16406,40305,40306,40307,40404,40405,40406,40810,
   40811,42111,42114,42115,42138,42141,42142,42192,42262,42773,
   42775,42832,42834,43499,43500,43503,43659,43662,44045,44047,
   44078,44080,44455,45339,45340,45341,45746,45759,45864,45866,
   46769,47330,47344,47476,47478,47748,48038,48061,48589,48742,
   48745,48746,48797,48866,49147,49148,49842,50097,51940],
 [201,204,206,207,388,450,452,453,3805,3806,3945,3946,4008,
   4009,4065,4066,5907,5913,5944,5950,6076,6090,6179,6428,7980,
   7987,8234,8259,8262,8288,8291,8423,8840,8902,8904,8905,
   10796,10973,11031,11032],[202],
 [208,209,211,214,454,455,457,460,8906,8907,8909,8912],
 [210,212,215,456,458,461,8908,8910,8913,12809,12810,12812,
   12815],
 [213,216,459,462,8911,8914,29895,33490,35670,36759,37329,37828]
  ,[217,463,8915],[218,221,236,464,467,482,8916,8919,8934],
 [224,225,233,238,244,245,470,471,479,484,490,491,8922,8923,
   8931,8936,8942,8943],
 [228,230,241,243,474,476,487,489,8926,8928,8939,8941,11055,
   11066],
 [229,231,232,242,246,247,475,477,478,488,492,493,8927,8929,
   8930,8940,8944,8945],[234,249,480,495,8932,8947],
 [235,240,248,250,481,486,494,496,8933,8938,8946,8948],
 [251,252,253,254,255,256,257,258,259,260,261,262,497,498,
   499,500,501,502,503,504,505,506,507,508,8949,8950,8951,
   8952,8953,8954,8955,8956,8957,8958,8959,8960,11076,11077,
   11078,11079,11080,11081,11082,11083,11084,11085,11086,11087],
 [264,267,269,270,391,568,626,627],[268,328],
 [271,272,274,277,628,629,631,634],[273,275,278,630,632,635]
  ,[276,279,633,636],[280,637],
 [281,284,299,343,346,361,523,526,541,638,641,656,2575,2755,
   4704,4884,6727,11808,11881,12076,12307,22259,22332,22527,
   22758],[282,286,289,302,639,643,646,659],
 [283,285,290,300,344,348,351,364,524,528,531,544,640,642,
   647,657],[287,296,301,308,644,653,658,665],
 [288,307,645,664],[291,306,648,663],
 [292,294,295,305,309,310,649,651,652,662,666,667],
 [293,304,650,661],[297,312,654,669],
 [298,303,311,313,655,660,668,670],
 [314,315,316,317,318,319,320,321,322,323,324,325,671,672,
   673,674,675,676,677,678,679,680,681,682],
 [326,329,331,332,389,390,392,509,511,512,570,683],
 [333,334,336,339,513,514,516,519],[335,337,340,515,517,520]
  ,[338,341,518,521],[342,522],
 [345,347,352,362,525,527,532,542],
 [349,358,363,370,529,538,543,550],[350,369,530,549],
 [353,368,533,548],
 [354,356,357,367,371,372,534,536,537,547,551,552],
 [355,366,535,546],[359,374,539,554],
 [360,365,373,375,540,545,553,555],
 [376,377,378,379,380,381,382,383,384,385,386,387,556,557,
   558,559,560,561,562,563,564,565,566,567,2218,2223,2227,
   2232,2236,2241,2245,2250,2253,2255,2269,2273],[393,569],
 [394,577,690,739],[395,574,687,740],[396,578,691,741],
 [397,400,571,572,684,685,742,745],[398,575,688,743],
 [399,579,692,744],[401,573,686,746],[402,576,689,747],
 [403,580,693,748],[404,599,712,749],
 [405,409,589,602,702,715,750,754],
 [406,408,590,600,703,713,751,753],
 [407,422,581,584,694,697,752,767],[410,608,721,755],
 [411,419,601,607,714,720,756,764],
 [412,425,582,586,695,699,757,770],
 [413,423,583,585,696,698,758,768],
 [414,429,591,606,704,719,759,774],[415,609,722,760],
 [416,427,593,604,706,717,761,772],[417,595,708,762],
 [418,594,707,763],[420,435,597,612,710,725,765,780],
 [421,436,603,611,716,724,766,781],[424,596,709,769],
 [426,434,598,613,711,726,771,779],[428,610,723,773],
 [430,431,587,588,700,701,775,776],[432,592,705,777],
 [433,605,718,778],[437,440,621,623,734,736,782,785],
 [438,439,619,624,732,737,783,784],
 [441,445,620,625,733,738,786,790],
 [442,444,446,447,614,615,616,617,727,728,729,730,787,789,
   791,792],[443,448,618,622,731,735,788,793],
 [794,795,848,849,850,953,955,956,1103],[796,799,852],
 [797,798,853,854,901,903,954,1004,1005,1007,1104,1151],
 [800,904],[801,802,1054,1057,1105,1198],
 [803,806,821,856,859,874,959,962,977,1106,1109,1124],
 [804,808,811,824,857,861,864,877,960,964,967,980,1107,1111,
   1114,1127],
 [805,807,812,822,858,860,865,875,961,963,968,978,1108,1110,
   1115,1125],[809,863,985,1133],
 [810,818,862,986,1126,1132],
 [813,828,866,881,969,984,1116,1131],[814,827,1134,1135],
 [815,826,868,879,971,982,1118,1129],[816,880,988,1120],
 [817,867,987,1119],[819,834,1122,1137],[820,835,1128,1136],
 [823,882,966,1121],[825,833,878,886,976,991,1123,1138],
 [829,830,876,974,1112,1113],[831,869,885,973,983,1117],
 [832,870,884,970,972,1130],
 [836,839,890,891,895,900,996,997,1000,1002,1146,1148],
 [837,838,842,847,889,892,893,894,897,899,993,994,998,999,
   1001,1003,1143,1144,1147,1149],
 [840,841,843,844,845,846,896,898,992,995,1139,1140,1141,1142,
   1145,1150],[851,957],[855,958],[871,883,965,979],
 [872,887,975,990],[873,888,981,989],[902,1006],
 [905,907,1152],[906,1055,1056],
 [908,911,926,1009,1012,1027,1058,1061,1076,1153,1156,1171,
   1199,1202,1217],
 [909,913,916,929,1010,1014,1017,1030,1154,1158,1161,1174],
 [910,912,917,927,1011,1013,1018,1028,1155,1157,1162,1172],
 [914,915,1179,1180],[918,933,1019,1034,1163,1178],
 [919,1181],[920,931,1021,1032,1165,1176],
 [921,1033,1038,1167],[922,1020,1037,1166],
 [923,1015,1036,1173],[924,939,1169,1184],
 [925,940,1175,1183],[928,934,1160,1168],
 [930,938,1170,1185],[932,1182],[935,1024,1029,1159],
 [936,937,1022,1023,1164,1177],
 [941,942,943,944,947,952,1043,1044,1046,1047,1048,1050,1052,
   1053,1190,1191,1193,1194,1195,1196],
 [945,946,949,951,1042,1045,1049,1051,1187,1188,1192,1197],
 [948,950,1186,1189],[1008],[1016,1035],[1025,1040],
 [1026,1031,1039,1041],
 [1059,1063,1066,1079,1200,1204,1207,1220],
 [1060,1062,1067,1077,1201,1203,1208,1218],[1064,1226],
 [1065,1225],[1068,1083,1209,1224],[1069,1227],
 [1070,1081,1211,1222],[1071,1087,1213,1223],
 [1072,1086,1210,1212],[1073,1085,1205,1219],
 [1074,1089,1215,1230],[1075,1090,1221,1229],[1078,1214],
 [1080,1088,1216,1231],[1082,1228],[1084,1206],
 [1091,1094,1095,1096,1099,1101,1233,1234,1238,1239,1241,1243],
 [1092,1093,1097,1102,1236,1237,1240,1242],
 [1098,1100,1232,1235],[1244,1247,1262],
 [1245,1249,1252,1265],[1246,1248,1253,1263],[1250,1271],
 [1251,1270],[1254,1269],[1255,1272],[1256,1267],
 [1257,1258],[1259,1264],[1260,1275],[1261,1266,1274,1276],
 [1268,1273],[1277,1280,1284,1286],
 [1278,1279,1281,1282,1283,1285,1287,1288],
 [1291,1306,1432,3520,3836,5692,5867,7819,8128,38304,38497,
   38530,39286,39404,39532,40108,40263,40328,41154,41217,41900,
   41995,42639,42671],[1294,1308,1421,1440,1846,1936],
 [1295,1303,1420,1441,1929,1935],
 [1299,1301,1302,1312,1425,1438,1442,1443,1787,1817,1937,1938,
   7754,7797,8057,8337],[1304,1319,1874,1940],
 [1305,1320,1931,1939],
 [1310,1318,1431,1436,1444,1446,1901,1941],
 [1314,1315,1429,1434,1549,1586],
 [1316,1317,1427,1428,1724,1730,1783,1933,2143],
 [1321,1324,1327,1332,1448,1449,1452,1457,1946,1949,1950,1951],
 [1322,1323,1325,1326,1328,1329,1330,1331,1447,1450,1451,1453,
   1454,1455,1456,1458,1942,1943,1944,1945,1947,1948,1952,1953]
  ,[1336,1377,1625,1658,1698,1761],
 [1337,1338,1499,1500,1538,1630,1631,1688,1693,1848,1853,1983,
   2007,2008,2108],
 [1342,1355,1504,1517,1632,1633,1686,1687,1794,1824,2009,2010],
 [1344,1346,1358,1360,1387,1388,1400,1401,1468,1469,1481,1482,
   1506,1508,1520,1522,1539,1540,1542,1544,1550,1552,1555,1578,
   1579,1580,1591,1592,1593,1618,1624,1628,1650,1652,1659,1684,
   1699,1701,1725,1726,1731,1762,1764,1767,1784,1788,1789,1814,
   1819,1820,1826,1856,1954,1979,2005,2048,2050,2053,2089,2091,
   2109,2110,2126,2127],
 [1345,1359,1386,1402,1467,1483,1507,1521,1615,1617,1653,1663,
   1697,1702,1718,1727,1729,1766,1790,1818,1958,2052,2069,2092]
  ,[1347,1362,1509,1524,1620,1635,1877,2012],
 [1348,1363,1510,1525,1626,1634,2003,2011],
 [1351,1357,1393,1399,1474,1480,1513,1519,1541,1543,1554,1556,
   1576,1577,1587,1589,1619,1654,1700,1765,1847,1849,2051,2090]
  ,[1353,1361,1515,1523,1621,1636,1904,2013],
 [1364,1365,1366,1367,1369,1370,1374,1375,1526,1527,1528,1529,
   1531,1532,1536,1537,1638,1639,1641,1642,1644,1645,1646,1647,
   2015,2016,2018,2019,2021,2022,2023,2024],
 [1368,1371,1372,1373,1530,1533,1534,1535,1637,1640,1643,1648,
   2014,2017,2020,2025],
 [1379,1380,1460,1461,1665,1666,1753,1758,1851,1960,1961,1981],
 [1384,1397,1465,1478,1667,1668,1751,1752,1792,1822,1962,1963],
 [1389,1390,1404,1405,1470,1471,1485,1486,1655,1661,1669,1670,
   1873,1875,1878,1886,1888,1914,1956,1964,1965,2034,2174,2188]
  ,[1395,1403,1476,1484,1656,1671,1902,1966],
 [1406,1407,1408,1409,1411,1412,1416,1417,1487,1488,1489,1490,
   1492,1493,1497,1498,1673,1674,1676,1677,1679,1680,1681,1682,
   1968,1969,1971,1972,1974,1975,1976,1977,2213,2214,2225,2226,
   2230,2234,2235,2239,2258,2259,2261,2263,2267,2271,2276,2278]
  ,[1410,1413,1414,1415,1491,1494,1495,1496,1672,1675,1678,
   1683,1967,1970,1973,1978],[1430,1445],
 [1546,1557,1588,1595,1854,1985],[1547,1562,1883,2129],
 [1548,1563,2030,2128],[1551,1594,1855],
 [1553,1561,1590,1598,1909,1910,2113,2130],[1558],
 [1559,1733],[1560,2071],
 [1564,1567,1602,1603,2119,2124,2138,2140],
 [1565,1566,1601,1604,1861,1864,1998,2000,2121,2123,2136,2141],
 [1568,1572,1862,1863,1996,2001,2137,2142],
 [1569,1574,1867,1872,1995,1999,2132,2133],
 [1570,1575,2135,2139],
 [1571,1573,1608,1610,1866,1871,1992,1993,2114,2117,2131,2134],
 [1581,1721,1825,1986],[1582,1795,1852,1987],[1583,1984],
 [1584,1599,1882,2112],
 [1585,1600,1845,1860,1980,1988,2029,2111],[1597,2070],
 [1605,1609,2120,2125],
 [1606,1611,1868,1870,1991,1994,2115,2116],
 [1607,1612,2118,2122],[1689,1704,1881,2094],
 [1690,1695,1703,1705,1908,2028,2093,2095],
 [1706,1709,1710,1712,1713,1714,1715,1717,2096,2099,2100,2102,
   2103,2104,2105,2107],
 [1707,1708,1711,1716,2097,2098,2101,2106],[1719,1827],
 [1720,1793,1797,1828],[1722,1737,1884,2145],
 [1723,1738,2031,2144],[1728,1736,1911,2146],[1734],
 [1735,2072],[1739,1742,2154,2156],
 [1740,1741,1809,1811,1832,1835,2152,2157],
 [1743,1747,1807,1812,1833,1834,2084,2086,2153,2158,2162,2165],
 [1744,1749,1806,1810,1838,1843,2148,2149],
 [1745,1750,2151,2155],
 [1746,1748,1803,1804,1837,1842,2081,2085,2147,2150,2168,2173],
 [1754,1769,1879,2055],
 [1755,1760,1768,1770,1905,1906,1913,2026,2035,2054,2056,2175],
 [1771,1774,1775,1777,1778,1779,1780,1782,2057,2060,2061,2063,
   2064,2065,2066,2068,2216,2220,2243,2247,2264,2266,2272,2277]
  ,[1772,1773,1776,1781,2058,2059,2062,2067],
 [1785,1800,1815,1830],[1786,1801,1821,1829],
 [1791,1799,1816,1831],[1798,1823],
 [1802,1805,1839,1841,2078,2079,2167,2172],
 [1808,1813,1836,1840,2082,2087,2163,2164],
 [1844,1859,1876,1989],[1850,1858,1903,1990],
 [1865,1869,1997,2002],[1880,1885,2075,2160],[1887],
 [1889,1892,1896,1898,2189,2192,2196,2198],
 [1890,1891,1894,1899,2190,2191,2194,2199],
 [1893,1895,1897,1900,2193,2195,2197,2200],
 [1907,2032,2076,2159],[1912,2027,2074,2161],[1915,2033],
 [1916,1919,2043,2045,2183,2185,2201,2204],
 [1917,1918,2041,2046,2181,2186,2202,2203],
 [1920,1924,2042,2047,2182,2187,2205,2209],
 [1921,1923,1925,1926,2036,2037,2038,2039,2176,2177,2178,2179,
   2206,2208,2210,2211],
 [1922,1927,2040,2044,2180,2184,2207,2212],[2073],
 [2077,2080,2169,2171],[2083,2088,2166,2170],
 [2215,2224,2254,2262,2268,2270],
 [2217,2219,2221,2222,2229,2231,2238,2240,2244,2246,2248,2249],
 [2228,2233,2237,2242,2251,2256,2260,2274],
 [2252,2257,2265,2275],[2279,12979,14635],
 [2280,2281,2284,2345,2346,2349,4490,4491,4494],
 [2282,2285,2347,2350,4492,4495],
 [2283,2286,2288,2289,2348,2351,2353,2354,4493,4496,4498,4499],
 [2287,2352,4497],
 [2290,2291,2293,2296,2355,2356,2358,2361,4500,4501,4503,4506],
 [2292,2294,2297,2357,2359,2362,4502,4504,4507],
 [2295,2298,2360,2363,4505,4508,12989,13044,14648,14706,18187,
   23144],[2299,2364,4509],
 [2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3560,3561,3602,3603,3648,3650,3873,3875,4510,4511,4512,4518,
   4528,4529,5652,5663,5737,5748,5782,5795,5822,5835,7732,7742,
   7775,7785,7899,7902,8098,8197,38605,38667,39501,39845,40429,
   40621,41308,41443,41971,42090,43474,43527,43617,43730,43979,
   44005,44111,44163,44832,45643,46482,46953,48019,48146,49059,
   49105,49420,49451,50793,50804,51994,52001,52078,52087,52136,
   52152],
 [2306,2307,2311,2313,2314,2315,2320,2324,2326,2327,2328,2329,
   2371,2372,2376,2378,2379,2380,2385,2389,2391,2392,2393,2394,
   3807,3808,3943,3944,4006,4007,4067,4068,4516,4517,4521,4523,
   4524,4525,4530,4534,4536,4537,4538,4539,5901,5915,5938,5952,
   6082,6088,6338,6426,7981,7982,8229,8232,8264,8293,8418,8421,
   8721,8722,8783,8784,8841,8842,8843,8961,9020,9135,10736,
   10737,10793,10794,10795,10855,10914,11088,12748,12749,12922,
   12923,14575,14576,14636,14694,16405,16522,16523,16579,18175,
   21539],
 [2316,2322,2331,2332,2381,2387,2396,2397,4526,4532,4541,4542],
 [2317,2330,2382,2395,4527,4540],
 [2333,2337,2339,2342,2398,2402,2404,2407,4543,4547,4549,4552],
 [2334,2335,2336,2338,2340,2341,2343,2344,2399,2400,2401,2403,
   2405,2406,2408,2409,4544,4545,4546,4548,4550,4551,4553,4554]
  ,[2410,2411,2474,2476,2477,2660,4555,4556,4619,4621,4622,
   4805],[2412,2418,2475,4625,4806,4808],
 [2414,2416,2538,2541,2662,2721,2852,2858,2867,2868,4559,4561,
   4683,4686,4807,4866,4994,4996,4997,4998,6721,6726,6729,6740,
   16063,23695],[2415,4809],[2417,2478,4626,4744],
 [2419,2420,2422,2425,2482,2483,2485,2488,2665,2666,2668,2671,
   4564,4565,4567,4570,4627,4628,4630,4633,4810,4811,4813,4816]
  ,[2421,2423,2426,2484,2486,2489,2667,2669,2672,4566,4568,
   4571,4629,4631,4634,4812,4814,4817],
 [2424,2427,2487,2490,2670,2673,4569,4572,4632,4635,4815,4818],
 [2428,2491,2674,4573,4636,4819],
 [2429,2437,2492,2500,2675,2683,4575,4592,4638,4655,4821,4838,
   7842,7846,7848,7851,8403,8407,8409,8412,9748,9749,9759,9761,
   9801,9843,9924,9963,11701,11754,11755,11786,17192,17193,
   17203,17205,17245,17287,17368,17407,22165,22331,22358,22367,
   40127,40130,40131,40132,40603,40607,40609,40612,40694,40698,
   41911,41915,41916,41919,42009,42017,45538,45541,45544,45549,
   45629,45633,47125,47133],
 [2430,2431,2452,2454,2495,2501,2510,2511,2676,2677,2698,2700,
   4582,4586,4593,4599,4637,4639,4640,4641,4828,4832,4839,4845,
   6654,6655,6662,6672,6717,6718,6725,6735,6900,6901,6908,6918]
  ,[2432,2438,2447,2448,2493,2494,2678,2684,2693,2694,4574,
   4576,4577,4578,4645,4656,4820,4822,4823,4824],
 [2433,2434,2439,2441,2496,2497,2502,2504,2679,2680,2685,2687,
   4583,4584,4595,4597,4646,4647,4658,4660,4829,4830,4841,4843]
  ,[2435,2443,2498,2506,2512,2516,2695,2699,4589,4603,4650,
   4652,4664,4666,4833,4847,9997,10309,11950,12201,12262,12387,
   17692,17878],[2436,2444,2503,2505,4651,4665,4840,4846],
 [2440,2442,2499,2507,2686,2688,4588,4602,4657,4663,4834,4848],
 [2445,2509,4667,4851],[2446,2461,2508,4668,4842,4850],
 [2449,2453,2681,2689,4587,4601,4835,4849,10248,10434,17441,
   17753],[2451,4852],[2455,2456,4826,4827],
 [2457,2458,2518,2519,2703,2704,4585,4598,4643,4644,4831,4844],
 [2459,4837],[2460,2514,2706,4590,4669,4836],
 [2462,2465,2529,2530,2714,2719,4611,4615,4672,4676,4860,4862],
 [2463,2466,2528,2531,2713,2717,4607,4609,4674,4677,4859,4863],
 [2464,2470,2527,2532,2715,2718,4608,4610,4673,4675,4858,4864],
 [2467,2471,2525,2536,2709,2712,4613,4617,4678,4679,4853,4855],
 [2468,2473,2526,2534,2708,2711,4614,4616,4670,4680,4857,4861],
 [2469,2472,2533,2535,2710,2716,4612,4618,4671,4681,4854,4856],
 [2479,4624],[2480,2661,4563,4620],
 [2481,2599,2664,4560,4562,4623],[2513,4642],
 [2515,2517,4649,4662],
 [2520,2521,2701,2702,4580,4581,4648,4661],[2522,4654],
 [2523,2697,4606,4653],[2524,2691,4605,4659],[2537,4867],
 [2540,4868],
 [2542,2543,2600,2601,2720,2894,4687,4688,4745,4746,4865,5039],
 [2544,2545,2547,2550,2724,2725,2727,2730,4689,4690,4692,4695,
   4869,4870,4872,4875],
 [2546,2548,2551,2726,2728,2731,4691,4693,4696,4871,4873,4876],
 [2549,2552,2729,2732,4694,4697,4874,4877],
 [2553,2733,4698,4878],
 [2554,2562,2734,2742,4700,4717,4880,4897,6656,6673,6719,6736,
   6902,6919,9791,9802,9833,9844,9915,9927,9954,9966,11696,
   11702,11711,11712,11782,11788,11796,11797,11837,11877,12063,
   12097,13587,13592,13602,13605,13632,13635,13645,13652,13720,
   13728,13735,13799,13807,13810,13921,13925,13990,13994,15477,
   17235,17246,17277,17288,17359,17371,17398,17410,18898,18903,
   18913,18916,18943,18946,18956,18963,19031,19039,19046,19110,
   19118,19121,19232,19236,19301,19305,20561,22147,22153,22162,
   22163,22233,22247,22288,22319,22328,22335,22514,22520,24015,
   25698],
 [2555,2556,2557,2563,2752,2753,4699,4701,4882,4883,4887,4898,
   15526,15884,20657,20840,20912,23946,24247,25349,25844,25931,
   40220,40516,40666,40667,41799,41974,42065,42094,43646,44100,
   45357,45474,45601,45602,46626,46942,47036,47059,48110,48516,
   49928,49976,50898,50946],[2558,2566,4888,4902,6720,6742],
 [2559,2564,2757,2759,4711,4724,4889,4900,6722,6738],
 [2560,2568,2754,2758,4714,4728,4892,4906,13841,14153,19403,
   19589],
 [2561,2565,2567,2569,2745,2747,4713,4727,4893,4899,4905,4907],
 [2570,2571,4909,4910],
 [2572,2573,2577,2579,2735,2736,2737,2743,4702,4703,4707,4718,
   4879,4881,4891,4904,15476,15598,15605,15818,16198,20567,
   20735,20739,20952,23693,23777,23779,24060,24131,25264,25272,
   25383,25545],
 [2574,2578,2740,2748,4712,4726,4894,4908,14092,14278,19152,
   19464],[2576,2765,4715,4911],[2580,2581,4885,4886],
 [2582,2583,2760,2761,2762,2763,4705,4706,4710,4723,4890,4903],
 [2584,4896],[2585,2756,4731,4895],[2586,2750,4730,4901],
 [2587,2588,2592,2593,2770,2771,2776,2778,4429,4438,4461,4466,
   4732,4738,4739,4740,4914,4916,4921,4922,6574,6597,6611,6625]
  ,[2589,2774,4735,4917],
 [2590,2591,2772,2773,4734,4736,4918,4919],
 [2594,2595,2769,2777,4452,4480,4733,4737,4915,4923,6583,6606],
 [2596,2598,2767,2768,4741,4742,4912,4920],
 [2597,2775,4743,4913],[2602,4982],[2603,4748],[2604,4925],
 [2605,2608,2950,2956,4927,4933,5041,5046],[2606,5043],
 [2607,2609,5044,5047],[2610,5048],
 [2611,2951,2953,4928,4930,5040],
 [2612,2952,2957,4929,4934,5042],[2613,5045],[2614,5049],
 [2615,2623,2960,2968,4938,4955,5051,5068,15422,15435,15751,
   20596,20609,20771,23732,23745,23907,25177,25190,25506],
 [2616,2617,2618,2624,2978,2979,2983,2985,4937,4939,4949,4962,
   5053,5054,5058,5069],[2619,2627,5059,5073],
 [2620,2625,5060,5071],[2621,2629,5063,5077,15671,24192],
 [2622,2626,2628,2630,2967,2975,4957,4963,5064,5070,5076,5078],
 [2631,2632,2992,4959,5080,5081],
 [2633,2634,2961,2962,2963,2969,4940,4941,4945,4956,5050,5052],
 [2635,2639,2966,2974,4950,4964,5065,5079,16108,21056,24253,
   25426],[2636,2981,4942,5055],[2637,2991,4953,5082],
 [2638,2640,5062,5075],
 [2641,2642,2986,2987,2988,2989,4943,4944,4948,4961,5056,5057],
 [2643,2644,5061,5074],[2645,5067],[2646,5066],
 [2647,2977,4967,5072],
 [2648,2653,2996,3002,4970,4977,5085,5092],
 [2649,2654,5087,5093],[2650,5088],
 [2651,2652,2993,4979,5089,5090],
 [2655,2995,3003,4971,4975,5086],[2656,5094],
 [2657,2998,2999,4972,4974,5083],[2658,3000,4973,5084],
 [2659,5091],[2663,4557],[2682,2690,4594,4600],
 [2692,2707,4596,4604],[2705,4591],[2722,4682],[2723,4685],
 [2738,2746,4708,4722,6657,6679,6903,6925],
 [2739,2744,4709,4720,6659,6675,6782,6784,6800,6804,6905,6921,
   6962,6964,6980,6984,8738,8743,8754,8800,8805,8816,8976,8983,
   9000,9091,9098,9115,10753,10758,10769,10874,10879,10890,
   10933,10938,10949,12761,12768,12785,12935,12942,12959,16424,
   16429,16440,16535,16542,16559,18246,18253,18270],
 [2741,2749,4719,4725],[2751,4729],[2764,4716],[2766,4721],
 [2779,4983],[2780,4749],[2781,4926],[2782,2901,4750,5101],
 [2783,5098],[2784,5102],[2785,2895,4756,5096],[2786,5099],
 [2787,5103],[2788,2896,4753,5095],[2789,2897,4757,5097],
 [2790,5100],[2791,5104],
 [2792,2800,2905,2913,4761,4778,5106,5123,15462,15475,15550,
   15565,15637,15824,20556,20569,20684,20699,20885,20958,23692,
   23705,23820,23835,24021,24094,25217,25230,25305,25320,25392,
   25579],[2793,2794,2923,2924,4760,4762,5113,5124],
 [2795,2801,5108,5109],[2796,2804,5114,5128],
 [2797,2802,5115,5126],[2798,2806,5118,5132,20805,25677],
 [2799,2807,5125,5131],
 [2803,2805,2912,2920,4780,4786,5119,5133],
 [2808,2937,4782,5136],[2809,5135],
 [2810,2811,2906,2907,4768,4779,5105,5107],
 [2812,2816,2911,2919,4773,4787,5120,5134,15922,21242,23941,
   25738],[2813,5110],[2814,2936,4776,5137],
 [2815,2817,5117,5130],
 [2818,2819,2933,2934,4771,4784,5111,5112],
 [2820,2821,5116,5129],[2822,5122],[2823,5121],[2824,5127],
 [2825,2947,4793,5147],[2826,5148],[2827,2946,4804,5143],
 [2828,5145],[2829,2938,4802,5144],[2830,2941,4800,5140],
 [2831,5142],[2832,2940,4798,5141],[2833,5149],
 [2834,2944,4797,5138],[2835,5139],[2836,5146],[2837,4747],
 [2838,4924],[2839,2840,2842,2845,4984,4985,4987,4990],
 [2841,2843,2846,4986,4988,4991],[2844,2847,4989,4992],
 [2848,4993],
 [2849,2857,4995,5012,11714,11801,11916,12162,13682,13689,13873,
   13959,19087,19090,19425,19454,22152,22205,22322,22518],
 [2850,2851,2872,2874,5002,5006,5013,5019],
 [2853,2861,5003,5017],[2854,2859,5004,5015],
 [2855,2863,2869,2873,5007,5009,5021,5023,22401,22652,22713,
   22838],[2856,2864,5014,5020],[2860,2862,5008,5022],
 [2865,5025],[2866,5024],[2870,4999],[2871,5026],
 [2875,2876,5000,5001],[2877,2878,5005,5018],[2879,5011],
 [2880,5010],[2881,5016],[2882,2893,5035,5036],
 [2883,2891,5027,5037],[2884,2889,5030,5032],
 [2885,2888,5031,5034],[2886,2887,5029,5033],
 [2890,2892,5028,5038],[2898,4751],[2899,4754],[2900,4758],
 [2902,4752],[2903,4755],[2904,4759],[2908,2914,4763,4764],
 [2909,2917,4769,4783],[2910,2915,4770,4781],
 [2916,2918,4774,4788],[2921,4791],[2922,4790],
 [2925,2929,4775,4789,15983,24378],[2926,4765],[2927,4792],
 [2928,2930,4772,4785],[2931,2932,4766,4767],[2935,4777],
 [2939,4803],[2942,4799],[2943,4795],[2945,4796],
 [2948,4794],[2949,4801],[2954,4931],[2955,2958,4932,4935],
 [2959,4936],[2964,2972,4946,4960],[2965,2970,4947,4958],
 [2971,2973,4951,4965],[2976,4968],
 [2980,2984,4952,4966,21117,25863],[2982,4969],[2990,4954],
 [2994,4980],[2997,3004,4976,4978],[3001,4981],
 [3005,3006,3059,3060,3061,3164,3166,3167,3314,5150,5151,5204,
   5205,5206,5309,5311,5312,5459,7341,7343,7588],
 [3007,3010,3063,5152,5155,5208,7338,7442],
 [3008,3009,3064,3065,3112,3114,3165,3215,3216,3218,3315,3362,
   5153,5154,5209,5210,5257,5259,5310,5360,5361,5363,5460,5507,
   15463,15464,15553,15554,15664,15909,21108,21113,21243,23823,
   23824,24026,24027,24179,24504,25729,25734,25864,40469,40473,
   40475,40476,40498,40502,40504,40505,42370,42371,42376,42378,
   42386,42387,42392,42394,43352,43358,43359,43360,43419,43425,
   43426,43427,45310,45316,45317,45318,47590,47591,47598,47599,
   47614,47615,47622,47623,47918,47922,47924,47925,49809,49810,
   49817,49818,51586,51587,51592,51594],
 [3011,3115,5156,5260,7444],
 [3012,3013,3265,3268,3316,3409,5157,5158,5410,5413,5461,5554],
 [3014,3022,3067,3075,3170,3178,3317,3325,5160,5177,5213,5230,
   5316,5333,5463,5480,7346,7363,7447,7464,7591,7608,26608,
   26661,27986,28039,29393,29408,29479,29674,30587,30640,31893,
   31908,31979,32174,34116,34169,35278,35293,35364,35559,37687],
 [3015,3016,3017,3023,3032,3033,3068,3069,3070,3076,3085,3086,
   3171,3172,3173,3179,3188,3189,3318,3319,3320,3326,3335,3336,
   5159,5161,5162,5163,5167,5178,5212,5214,5215,5216,5220,5231,
   5315,5317,5318,5319,5323,5334,5462,5464,5465,5466,5470,5481]
  ,[3018,3026,3071,3079,3174,3182,3321,3329,5168,5182,5221,
   5235,5324,5338,5471,5485],
 [3019,3024,3072,3077,3175,3180,3322,3327,5169,5180,5222,5233,
   5325,5336,5472,5483],
 [3020,3028,3176,3184,3190,3194,5225,5227,5239,5241,5475,5489,
   7355,7370,7596,7617,26857,28486,28547,29748,30836,31273,
   34616,35497],[3021,3029,3181,3183,5226,5240,5482,5488],
 [3025,3027,3177,3185,3324,3332,5179,5185,5232,5238,5476,5490],
 [3030,3187,3349,5181,5242,5493],
 [3031,3046,3186,5243,5484,5492],
 [3034,3038,3087,3091,3323,3331,5172,5186,5330,5344,5477,5491,
   7452,7456,7471,7473,27108,27294,28672,31148,32112,32248,
   34365,34677],[3035,3088,3191,3338,5164,5217,5320,5467],
 [3036,3201,3348,5175,5228,5494],
 [3037,3039,3090,3092,3193,3195,3340,3342,5171,5184,5224,5237,
   5327,5340,5474,5487],
 [3040,3041,3345,3346,5170,5183,5468,5469],
 [3042,3043,3095,3096,3196,3197,3343,3344,5165,5166,5218,5219,
   5326,5339,5473,5486],[3044,5479],[3045,3192,5244,5478],
 [3047,3050,3101,3106,3111,3207,3208,3359,5192,5247,5251,5352,
   5356,5358,5502,5504],
 [3048,3058,3100,3105,3209,3354,5198,5249,5350,5357,5503,5505],
 [3049,3108,3110,3205,3210,3358,3360,5193,5203,5248,5250,5349,
   5359,5500],
 [3051,3109,3206,3350,3351,3361,5200,5201,5202,5252,5348,5501],
 [3052,3056,3203,3353,3356,5196,5199,5254,5495,5497],
 [3053,3103,3104,3204,3212,3214,3355,5194,5245,5253,5255,5354,
   5355,5499],
 [3054,3055,3057,3107,3352,5197,5351,5496,5498,5506],
 [3062,3168,5207,5313],[3066,3169,5211,5314],
 [3073,3081,3337,3341,5174,5188,5328,5342,27169,28235,31087,
   34802],
 [3074,3078,3080,3082,3328,3330,5173,5187,5329,5335,5341,5343],
 [3083,3084,5345,5346],[3089,5347],
 [3093,3094,3198,3199,5223,5236,5321,5322,7357,7364,7603,7604],
 [3097,5332],[3098,3339,5191,5331],[3099,3333,5190,5337],
 [3102,3211,3213,3357,5195,5246,5256,5353],
 [3113,3217,5258,5362,13898,13902,14098,14104,14287,14293,14374,
   14378,14434,14435,14450,14451,19174,19182,19349,19357,19443,
   19448,19472,19477,19723,19731,19771,19779,43930,44573,46910,
   47839,48311,48717,50310,51203,51541,51705,51825,51902],
 [3116,3118,3363,5261,5263,5508,20165,20167,20412,24786,24788,
   25033],[3117,3266,5262,5411],
 [3119,3127,3220,3228,3364,3372,5265,5282,5366,5383,5510,5527,
   7241,7258,7294,7311,7397,7414,7544,7561,26695,26704,26787,
   26814,26815,26826,27004,27006,28073,28082,28165,28192,28193,
   28204,28382,28384,29307,29312,29322,29355,29365,29448,30674,
   30683,30766,30793,30794,30805,30983,30985,31807,31812,31822,
   31855,31865,31948,32983,32998,33031,33035,33118,33124,33129,
   33319,33453,34203,34212,34295,34322,34323,34334,34512,34514,
   35192,35197,35207,35240,35250,35333,36227,36242,36275,36279,
   36362,36368,36373,36563,36697,37429,37440,37620],
 [3120,3121,3122,3128,3137,3138,3221,3222,3223,3229,3238,3239,
   3365,3366,3367,3373,3382,3383,5264,5266,5267,5268,5272,5283,
   5365,5367,5368,5369,5373,5384,5509,5511,5512,5513,5517,5528]
  ,[3123,3131,3224,3232,3368,3376,5273,5287,5374,5388,5518,
   5532,7242,7264,7295,7317,7398,7420,7545,7567],
 [3124,3129,3225,3230,3369,3374,5274,5285,5375,5386,5519,5530,
   7244,7260,7297,7313,7400,7416,7547,7563],
 [3125,3133,3226,3234,3384,3388,5279,5293,5378,5392,5522,5536,
   29561,29873,32061,32312,35697,35883],
 [3126,3134,3231,3233,3375,3377,5278,5292,5379,5393,5529,5535],
 [3130,3132,3227,3235,5385,5391,5523,5537],
 [3135,3237,5395,5540],[3136,3236,5396,5539],
 [3139,3143,5524,5538,29998,35758],
 [3140,3241,3385,5269,5370,5514],[3141,3251,5381,5541],
 [3142,3144,3243,3245,3387,3389,5276,5289,5377,5390,5521,5534],
 [3145,3146,3392,3393,5275,5288,5515,5516],
 [3147,3148,3390,3391,5270,5271,5520,5533],[3149,5526],
 [3150,3386,5296,5525],[3151,3380,5295,5531],
 [3152,3153,3163,3258,3259,3401,5303,5400,5402,5550,5551,5552],
 [3154,3255,3261,3263,3404,3405,3407,5298,5300,5308,5399,5403,
   5409,5547],
 [3155,3158,3254,3257,3264,3402,3406,5297,5299,5404,5406,5408,
   5546,5549],
 [3156,3256,3262,3398,3408,5305,5307,5398,5405,5548],
 [3157,3253,3403,5301,5407,5544],[3159,5545],
 [3160,3162,3260,3399,5302,5401,5543,5553],
 [3161,3397,3400,5304,5306,5542],[3200,5229],
 [3202,3334,5189,5234],[3219,5364],
 [3240,3244,3370,3378,5277,5291,5380,5394,29812,32373,32498,
   35446],[3242,5397],
 [3246,3247,3248,3249,5371,5372,5376,5389],[3250,5382],
 [3252,5387],[3267,5412],
 [3269,3277,3410,3418,5415,5432,5556,5573,29059,29060,29064,
   29069,31706,31707,31710,31712,32988,33041,36232,36285],
 [3270,3271,3272,3278,3287,3288,3411,3412,3413,3419,3428,3429,
   5414,5416,5417,5418,5422,5433,5555,5557,5558,5559,5563,5574]
  ,[3273,3281,3414,3422,5423,5437,5564,5578],
 [3274,3279,3415,3420,5424,5435,5565,5576],
 [3275,3283,3289,3293,5568,5570,5582,5584,33237,33674,36732,
   36793],[3276,3280,3282,3284,5569,5575,5581,5583],
 [3285,3286,5585,5586],[3290,3431,5419,5560],
 [3291,3300,5571,5587],
 [3292,3294,3433,3435,5426,5439,5567,5580],
 [3295,3296,3438,3439,5425,5438,5561,5562],
 [3297,3298,3436,3437,5420,5421,5566,5579],[3299,5572],
 [3301,5577],[3302,3307,3449,5451,5590,5597],
 [3303,3308,3313,3447,3448,5449,5453,5592,5596,5598],
 [3304,3451,3453,5448,5458,5593],
 [3305,3306,3444,3452,3454,5447,5455,5457,5594,5595],
 [3309,5591],[3310,3312,3445,3450,5450,5452,5589,5599],
 [3311,3446,5454,5588],[3347,5176],[3371,3379,5284,5290],
 [3381,3396,5286,5294],[3394,5281],[3395,5280],
 [3416,3424,3430,3434,5427,5429,5441,5443,33488,33549,36481,
   36918],[3417,3425,5434,5440],[3421,3423,5428,5442],
 [3426,5445],[3427,5444],[3432,5446],[3440,5431],
 [3441,5430],[3442,5436],[3443,5456],
 [3455,3463,5601,5618,37222,37275],
 [3456,3457,3458,3464,3473,3474,5600,5602,5603,5604,5608,5619],
 [3459,3467,5609,5623],[3460,3465,5610,5621],
 [3461,3469,5613,5627,37471,37722],[3462,3470,5620,5626],
 [3466,3468,5614,5628],[3471,5631],[3472,5630],
 [3475,3479,5615,5629,37783,37908],[3476,5605],[3477,5632],
 [3478,3480,5612,5625],
 [3481,3482,3483,3484,5606,5607,5611,5624],[3485,5617],
 [3486,5616],[3487,5622],[3488,5642],
 [3489,3492,3499,5639,5641,5643],
 [3490,3496,3498,5634,5638,5644],[3491,3497,5633,5640],
 [3493,3494,5635,5637],[3495,5636],
 [3500,3501,3502,3508,3517,3518,3522,3524,3544,3550,3592,3633,
   3634,3824,3833,3834,3838,3840,4139,4260,5645,5646,5662,5689,
   5690,5691,5695,5699,5706,5712,5747,5774,5788,5828,5978,5979,
   6112,6119,6284,6290,7725,7726,7743,7769,7786,7813,7817,7818,
   7821,7827,7832,7909,7913,8058,8059,8087,8094,8193,8364,8393,
   38211,38221,38222,38253,38263,38264,38294,38295,38296,38298,
   38305,38307,38309,38311,38335,38344,38347,38374,38383,38386,
   38485,38494,38495,38499,38501,38529,38532,38534,38536,38564,
   38566,38629,38631,38800,38802,38827,39156,39166,39167,39201,
   39207,39214,39241,39247,39254,39276,39277,39278,39280,39287,
   39289,39291,39293,39391,39397,39398,39400,39402,39433,39439,
   39467,39473,39531,39534,39536,39538,39703,39709,39734,40060,
   40068,40073,40098,40099,40100,40102,40109,40111,40113,40115,
   40139,40147,40152,40250,40258,40259,40261,40265,40294,40298,
   40327,40330,40332,40334,40393,40397,40564,40568,40593,40922,
   40928,40935,40959,40967,40972,41083,41085,41118,41120,41141,
   41147,41148,41150,41152,41212,41213,41215,41219,41388,41390,
   41505,41738,41747,41750,41861,41865,41887,41893,41894,41896,
   41898,41930,41934,41992,41993,41997,41999,42166,42170,42242,
   42602,42604,42626,42634,42635,42637,42641,42668,42669,42673,
   42675,42736,42738,42907,42909,42981,44638,44640,44670,44674,
   44735,44737,44980,44982,45025,45263,45269,45328,45332,45528,
   45530,45620,45889,45891,46087,46091,46138,47111,47113,47160],
 [3503,3504,3509,3511,3670,3673,3675,3712,3716,3825,3827,3896,
   5696,5697,5708,5710,6005,6013,6016,6047,6052,6286,6288,6360,
   7812,7814,7830,7834,7855,7869,7871,7948,7954,8391,8395,8442,
   13783,13784,13788,13789,14264,14268,14270,14271,14353,14359,
   14360,14361,14509,14513,14515,14516,14524,14525,14526,14554,
   14555,14556,14560,14561,19015,19016,19023,19024,19281,19283,
   19288,19289,19381,19382,19387,19389,19841,19842,19847,19849,
   19850,19855,19856,19863,19864,19883,19884,19885,26161,26162,
   26163,26165,26166,26167,26213,26214,26215,26217,26218,26219,
   26265,26266,26317,26319,26320,26366,26368,26369,26416,26417,
   26463,26464,27591,27592,27593,27595,27596,27597,27644,27645,
   27646,27647,27694,27695,27696,27697,27793,27794,27842,27888,
   28969,28971,28972,28974,29020,29070,29071,29073,29119,29121,
   29167,29214,30295,30296,30297,30298,30345,30346,30348,30395,
   30396,30442,30443,31570,31572,31573,31619,31621,31667,31714,
   32795,32796,32844,32890,33971,33972,34018,35099,38206,38207,
   38208,38212,38213,38215,38224,38226,38228,38248,38249,38250,
   38254,38255,38257,38266,38268,38270,38290,38291,38334,38336,
   38338,38345,38349,38351,38353,38354,38355,38373,38375,38377,
   38384,38388,38390,38392,38393,38394,38486,38488,38521,38523,
   38563,38568,38570,38571,38573,38574,38628,38633,38635,38636,
   38638,38639,38804,38806,38829,38831,38876,38878,38981,38982,
   38998,38999,39151,39152,39153,39157,39158,39160,39169,39171,
   39173,39194,39197,39198,39199,39208,39210,39212,39234,39237,
   39238,39239,39248,39250,39252,39315,39316,39317,39327,39329,
   39330,39352,39353,39354,39364,39366,39367,39388,39389,39425,
   39426,39432,39435,39437,39459,39460,39466,39469,39471,39705,
   39707,39730,39732,39780,39781,39823,39824,40054,40058,40059,
   40062,40063,40064,40065,40069,40071,40075,40095,40137,40138,
   40141,40142,40143,40144,40148,40150,40154,40249,40252,40285,
   40293,40296,40300,40310,40311,40312,40317,40318,40319,40321,
   40392,40395,40399,40409,40410,40411,40416,40417,40418,40419,
   40420,40455,40456,40460,40484,40485,40489,40566,40570,40591,
   40595,40615,40619,40640,40685,40871,40877,40878,40879,40885,
   40886,40912,40913,40915,40918,40919,40920,40929,40931,40933,
   40957,40958,40961,40962,40963,40964,40968,40970,40974,41070,
   41072,41078,41079,41081,41105,41107,41113,41114,41116,41240,
   41244,41245,41246,41270,41274,41275,41276,41384,41386,41410,
   41413,41415,41435,41460,41462,41737,41739,41741,41748,41752,
   41754,41756,41757,41758,41849,41852,41858,41859,41863,41866,
   41867,41868,41885,41921,41927,41928,41932,41935,41936,41937,
   42164,42168,42191,42195,42203,42204,42208,42209,42210,42211,
   42240,42285,42293,42294,42298,42299,42300,42301,42344,42345,
   42363,42379,42453,42454,42456,42463,42464,42466,42495,42500,
   42590,42591,42599,42600,42606,42607,42608,42610,42628,42662,
   42733,42734,42740,42741,42742,42744,42760,42765,42766,42771,
   42791,42824,42825,42830,42905,42911,42931,42932,42934,42960,
   42983,43026,43085,43087,43103,43120,43257,43258,43259,43269,
   43271,43272,43329,43337,43340,43343,43364,43404,43407,43410,
   43610,43613,43684,43728,43995,43996,44037,44042,44043,44070,
   44075,44076,44278,44279,44350,44351,44625,44627,44633,44634,
   44636,44661,44667,44668,44672,44675,44676,44677,44732,44733,
   44739,44740,44741,44743,44906,44908,44910,44931,44933,44935,
   45085,45086,45102,45103,45255,45256,45262,45265,45267,45295,
   45298,45301,45327,45330,45334,45344,45345,45346,45351,45352,
   45353,45499,45503,45504,45505,45526,45575,45576,45577,45805,
   45811,45812,45814,45826,45827,45848,45849,45856,45861,45862,
   45888,45893,45895,45896,45898,45899,46060,46062,46065,46066,
   46089,46136,46180,46181,46240,46242,46258,46275,46590,46592,
   46665,46708,47084,47086,47088,47115,47162,47205,47264,47265,
   47283,47299,47390,47391,47404,47406,47411,47413,47432,47434,
   47435,47439,47440,47441,47468,47469,47474,47576,47580,47600,
   47604,47904,47905,47909,48010,48011,48039,48062,48416,48421,
   48441,48468,49471,49473,49475,49520,49521,49522,49564,49565,
   49795,49799,49820,49822,49865,49873,49874,49878,49879,49880,
   49881,50029,50036,50043,50045,50074,50076,50080,50085,50098,
   50393,50394,50999,51004,51005,51016,51044,51045,51051,51055,
   51426,51427,51443,51579,52178,52179,52181,52209,52215,52216,
   52220,52254,52255,52256,52265,52275,52281,52282,52287,52288,
   52308,52310,52315,52317,52337,52338,52357,52358,52360,52365,
   52375,52394],
 [3505,3513,3519,3523,3750,3829,3835,3839,5700,5702,5714,5716,
   6143,6202,6292,6294,7816,7820,7835,7837,8023,8161,8396,8398,
   38297,38310,38411,38417,38422,38490,38496,38500,38524,38531,
   38597,38659,38689,38854,39394,39399,39526,39533,39562,39571,
   39621,39632,39711,39713,39735,39738,39864,39865,40101,40114,
   40212,40223,40232,40264,40361,40368,40572,40573,40596,40598,
   40686,40687,41036,41049,41187,41218,41393,41394,41506,41509,
   41545,41547,41779,41792,41890,41895,41967,41988,41994,41998,
   42053,42082,43298,43309,43437,43975,44103,44308,44798,44827,
   44958,45363,45422,45533,45534,45622,45624,45661,45662,46620,
   46948,46978,47557,48400],
 [3506,3510,3512,3514,3553,3555,3595,3597,3632,3640,3787,3788,
   3797,3798,3826,3828,3830,3865,3940,3942,4003,4005,4057,4058,
   5664,5670,5701,5707,5713,5715,5749,5755,5790,5796,5830,5836,
   5974,5988,6108,6122,6173,6174,6180,6285,6291,6293,6318,6447,
   7748,7751,7791,7794,7815,7833,7836,7838,7896,7919,7975,7985,
   7986,7990,8069,8099,8102,8198,8201,8374,8394,8397,8399,8489,
   38292,38293,38448,38459,38467,38487,38489,38491,38525,38526,
   38718,38726,38801,38830,39392,39393,39495,39527,39528,39592,
   39704,39710,39712,39736,39737,39847,39866,39867,40096,40097,
   40175,40180,40186,40251,40571,40574,40594,40597,40599,40623,
   40688,40689,40999,41002,41012,41174,41391,41392,41441,41507,
   41508,41525,41546,41548,41816,41829,41833,41888,41889,41954,
   41987,41989,42023,42031,42165,42305,43615,43732,43999,44275,
   44707,44711,44768,44773,44957,45045,45393,45531,45532,45552,
   45621,45623,45641,45660,45663,46417,46425,46641,47007,47012,
   47114,47137,47690,48017,48148,48420,49057,49068,49069,49100,
   49408,49410,49419,49456,50795,50805,50836,50841,51992,52000,
   52008,52009,52070,52072,52079,52086,52138,52144,52145,52153],
 [3507,5705,7828],
 [3515,3516,3531,3831,3832,3847,5709,5717,5718,6287,6295,6296,
   38303,38318,38492,38493,38508,38773,38776,38803,38811,38813,
   38884,38885,39284,39299,39395,39410,39706,39714,39715,39803,
   39869,39870,41146,41159,41387,41395,41484,41551,42666,42667,
   42680,42851,42854,42908,42916,42989,44853,44857,44988,45004,
   45071,46036,46040,46143,46144,46160,46225,46227],
 [3521,3530,3837,3846,5703,5719,6230,6297,38308,38316,38498,
   38507,38746,38749,38812,38883,39290,39298,39401,39411,39649,
   39656,39716,39868,41151,41161,41357,41364,41397,41549,42672,
   42681,42878,42881,42917,42988,44880,44884,44989,45070,46009,
   46013,46145,46226],
 [3525,3526,3527,3528,3841,3842,3843,3844,4319,4354,5693,5694,
   5698,5711,5894,5905,5942,6080,6086,6289,7822,7823,7824,7829,
   8224,8225,8250,8254,8283,8390,13769,13773,13790,13791,14253,
   14263,14269,14354,14358,18989,18992,19017,19022,19258,19282,
   19290,19380,19388,26164,26216,26267,26268,26269,26270,26318,
   26367,26415,27594,27648,27698,27744,27745,27746,27747,27795,
   28973,29021,29022,29023,29024,29072,29120,30299,30347,30489,
   31571,31668,32843,38352,38391,38502,38503,38504,38505,38572,
   38637,38980,39324,39361,39438,39472,39499,39502,39504,39505,
   39708,40070,40149,40424,40425,40426,40430,40454,40483,40590,
   40876,40884,40891,40892,40893,40969,41250,41280,41303,41304,
   41305,41309,41439,41755,41869,41938,42000,42001,42002,42003,
   42346,42455,42465,42496,42501,42505,42609,42676,42677,42678,
   42679,42743,42767,42795,42796,42797,42801,42826,42956,43086,
   43266,43342,43371,43374,43376,43377,43409,43612,44003,44006,
   44008,44009,44040,44073,44276,44678,44742,45119,45268,45300,
   45619,45813,45819,45820,45821,45828,45859,45897,46137,46259,
   46664,47282,47396,47397,47398,47405,47412,47445,47470,47627,
   47903,48015,48417,50033,50034,50035,50044,50081,51003,51013,
   51014,51015,51046,52180,52210,52211,52260,52261,52280,52289,
   52309,52316,52336,52359,52361],
 [3529,3845,5704,6257,38302,38317,38506,38875,39285,39300,39396,
   39409,39676,39683,41145,41160,41330,41337,41396,41550,42682,
   42918,42980,42990,44979,44987,45069,46135],
 [3532,3533,3535,3536,3537,3538,3541,3543,3848,3849,3851,3852,
   3853,3854,3857,3859,5720,5722,5724,5726,5727,5728,5729,5730,
   6298,6300,6302,6304,6305,6306,6307,6308,38319,38320,38321,
   38322,38324,38325,38329,38330,38509,38510,38512,38513,38514,
   38515,38518,38520,38814,38817,38818,38820,38821,38822,38823,
   38825,38886,38888,38889,38892,38893,38894,38896,38897,39301,
   39302,39303,39304,39306,39307,39311,39312,39412,39413,39414,
   39416,39417,39418,39421,39422,39717,39719,39721,39723,39724,
   39725,39726,39727,39871,39873,39874,39877,39878,39879,39881,
   39882,41162,41163,41164,41166,41167,41168,41171,41172,41399,
   41400,41402,41403,41405,41406,41407,41408,41553,41554,41555,
   41557,41559,41560,41562,41563,42683,42684,42686,42687,42688,
   42689,42692,42694,42920,42922,42923,42924,42926,42927,42928,
   42930,42992,42993,42994,42996,42998,42999,43001,43002,44991,
   44992,44994,44995,44997,44998,44999,45000,45073,45075,45076,
   45077,45079,45080,45081,45083,46146,46148,46150,46152,46153,
   46154,46155,46156,46228,46231,46232,46234,46235,46236,46237,
   46239],
 [3534,3539,3540,3542,3850,3855,3856,3858,5721,5723,5725,5731,
   6299,6301,6303,6309,38323,38326,38327,38328,38511,38516,
   38517,38519,38815,38816,38819,38824,38887,38890,38891,38895,
   39305,39308,39309,39310,39415,39419,39420,39423,39718,39720,
   39722,39728,39872,39875,39876,39880,41165,41169,41170,41173,
   41398,41401,41404,41409,41552,41556,41558,41561,42685,42690,
   42691,42693,42919,42921,42925,42929,42991,42995,42997,43000,
   44990,44993,44996,45001,45072,45074,45078,45082,46147,46149,
   46151,46157,46229,46230,46233,46238],
 [3545,3546,3547,3551,3552,3554,3587,3588,3589,3593,3594,3596,
   3629,3630,3635,3637,3674,3683,3684,3688,3690,3713,3722,3723,
   3727,3729,3860,3862,3902,3903,3907,3909,3967,3968,3972,3974,
   4143,4145,4168,4170,5653,5654,5656,5665,5667,5669,5738,5739,
   5741,5750,5752,5754,5778,5779,5780,5789,5791,5793,5818,5819,
   5820,5829,5831,5833,5969,5970,5981,5983,6007,6014,6020,6041,
   6048,6054,6115,6117,6311,6313,6362,6405,7727,7728,7729,7745,
   7747,7749,7770,7771,7772,7788,7790,7792,7854,7858,7859,7862,
   7868,7873,7895,7911,7915,7937,7938,7941,7947,7952,8049,8052,
   8061,8065,8093,8096,8100,8192,8195,8199,8366,8370,8440,8485,
   14185,14191,14192,14193,14213,14217,14219,14220,14332,14333,
   14337,14338,19785,19786,19793,19794,19799,19800,19805,19807,
   19810,19812,19817,19818,38332,38337,38350,38371,38376,38389,
   38558,38559,38565,38623,38624,38630,39427,39429,39434,39461,
   39463,39468,39782,39783,39785,39825,39826,39828,40057,40061,
   40074,40136,40140,40153,40643,40644,40645,40725,40726,40727,
   40956,40960,40973,41416,41418,41419,41463,41465,41466,41735,
   41740,41753,41854,41855,41860,41923,41924,41929,42516,42520,
   42521,42523,42527,42533,42553,42557,42564,42570,42572,42574,
   42605,42702,42708,42710,42712,42739,42770,42829,43296,43464,
   43639,43687,43689,43750,43752,43962,44033,44039,44066,44072,
   44305,44473,44663,44664,44669,44738,45257,45259,45264,45507,
   45508,45509,45579,45580,45581,45852,45858,45883,45884,45890,
   45919,45924,45927,45929,45949,45954,45978,45983,45986,45988,
   46619,46787,47473,47553,47730,47988,48041,48043,48064,48066,
   48394,48571,49058,49109,49418,49460,49524,49525,49526,49823,
   49825,49826,50100,50102,50395,50396,50398,50415,50417,50434,
   50435,50436,50794,50803,51993,52002,52080,52085,52137,52151],
 [3548,3549,3556,3557,3590,3591,3598,3599,3631,3636,3638,3639,
   3749,3751,3753,3755,3757,3793,3799,3802,3803,3804,3861,3863,
   3864,3931,3935,3936,3937,3941,3994,3998,3999,4000,4004,4025,
   4059,4062,4063,4064,4140,4144,4165,4169,4192,4194,4259,4280,
   5658,5659,5672,5673,5743,5744,5757,5758,5783,5784,5797,5798,
   5823,5824,5837,5838,5973,5980,5986,5987,6109,6114,6120,6123,
   6139,6144,6145,6151,6153,6170,6182,6184,6204,6209,6210,6212,
   6310,6316,6317,6339,6341,6343,6445,6448,6464,6466,6482,6499,
   7730,7731,7752,7753,7773,7774,7795,7796,7897,7914,7917,7918,
   7974,7976,7978,7979,7993,7995,8027,8028,8031,8033,8051,8064,
   8066,8067,8086,8101,8104,8154,8160,8166,8169,8171,8200,8203,
   8369,8371,8372,8484,8487,8488,8506,8508,8544,8546,8562,8579,
   38209,38210,38217,38218,38231,38232,38251,38252,38259,38260,
   38273,38274,38339,38341,38378,38380,38410,38450,38451,38452,
   38463,38464,38465,38468,38469,38556,38590,38656,38686,38720,
   38723,38725,38728,38729,38853,38855,38920,38924,38925,38941,
   38963,38964,39154,39155,39162,39163,39176,39177,39195,39196,
   39202,39203,39216,39217,39235,39236,39242,39243,39256,39257,
   39320,39334,39357,39371,39440,39442,39474,39476,39558,39589,
   39594,39595,39597,39754,39756,39884,39901,39918,40077,40079,
   40156,40158,40174,40176,40178,40179,40181,40182,40188,40191,
   40192,40286,40289,40290,40301,40304,40354,40388,40389,40400,
   40403,40464,40493,40641,40705,40746,40763,40779,40827,40828,
   40835,40836,40839,40840,40847,40848,40916,40917,40923,40924,
   40937,40938,40976,40978,40994,40995,40996,40998,41000,41001,
   41006,41008,41011,41071,41073,41074,41086,41087,41106,41108,
   41109,41121,41122,41252,41282,41414,41461,41564,41582,41583,
   41742,41744,41774,41812,41814,41815,41823,41827,41828,41831,
   41832,41851,41920,42019,42020,42024,42025,42028,42032,42033,
   42125,42126,42130,42131,42152,42153,42157,42158,42190,42194,
   42197,42198,42217,42284,42287,42288,42594,42596,42728,42730,
   42938,42940,43067,43069,43262,43276,43293,43295,43331,43333,
   43345,43398,43400,43412,43463,43494,43635,43638,43686,43749,
   43960,43961,44031,44064,44303,44304,44327,44328,44395,44398,
   44415,44418,44472,44489,44626,44628,44629,44641,44642,44660,
   44700,44701,44706,44708,44709,44727,44729,44759,44760,44763,
   44764,44765,44771,44772,44905,44909,44911,44912,44930,44934,
   44936,44937,45270,45272,45289,45291,45303,45323,45324,45335,
   45338,45354,45385,45388,45390,45391,45500,45550,45679,45680,
   45681,45749,45751,45756,45757,45762,45764,45769,45770,45850,
   46067,46069,46182,46184,46416,46422,46423,46424,46427,46588,
   46589,46594,46595,46618,46642,46729,46730,46768,46770,46940,
   46970,47002,47004,47009,47010,47013,47085,47089,47091,47094,
   47139,47225,47245,47248,47335,47336,47341,47343,47360,47361,
   47366,47368,47447,47549,47550,47578,47579,47582,47602,47603,
   47606,47729,47747,47913,47985,47986,48037,48060,48391,48396,
   48443,48444,48449,48511,48531,48554,48572,48605,48756,48757,
   48761,48762,48808,48812,48814,48815,48877,48881,48883,48884,
   49053,49070,49098,49099,49227,49233,49234,49235,49248,49254,
   49255,49256,49404,49411,49449,49455,49470,49474,49476,49477,
   49495,49498,49499,49566,49568,49585,49586,49605,49608,49624,
   49625,49626,49797,49798,49801,49821,49853,49857,49859,49860,
   49864,49867,49868,49906,49908,49924,49942,49943,50096,50140,
   50141,50161,50184,50414,50633,50639,50640,50641,50796,50806,
   50835,50840,50855,50858,50877,50878,50895,50912,50929,51257,
   51274,51290,51943,51945,51950,51951,51956,51957,51962,51964,
   51987,51995,52028,52029,52033,52034,52041,52042,52064,52065,
   52106,52108,52130,52139,52173,52174],
 [3558,3600,3642,3867,4152,4177,5666,5751,5800,5840,5991,6321],
 [3559,3601,3641,3866,5801,5841,5990,6320],
 [3562,3566,3604,3608,3645,3649,3760,3761,3765,3767,3870,3874,
   4028,4029,4033,4035,5657,5671,5742,5756,5785,5799,5825,5839,
   5975,5989,6107,6121,6150,6203,6319,6446,7735,7750,7778,7793,
   7901,7916,8012,8013,8016,8022,8068,8103,8165,8202,8373,8486,
   38604,38668,39507,39757,40432,40618,40829,40834,40841,40846,
   41313,41438,41968,42093,42132,42133,42159,42160,42772,42774,
   42803,42805,42831,42833,42962,42964,43379,43381,43470,43473,
   43497,43498,43502,43504,43529,43532,43789,43978,44013,44046,
   44048,44079,44081,44112,44165,44166,44283,44325,44833,45553,
   45750,45758,45763,45771,45865,45867,46202,46204,46479,46480,
   46639,46710,46952,47334,47342,47359,47367,47475,47477,47626,
   47711,48183,48425,48467,48763,48764,48807,48813,48876,48882,
   49228,49232,49249,49253,49852,49858,50219,50634,50638,51085,
   51944,51952,51955,51963,52035,52040],
 [3564,3568,3569,3606,3610,3611,3647,3653,3654,3872,3878,3879,
   4148,4149,4151,4173,4174,4176,4261,4262,4266,4300,4301,4305,
   5655,5660,5668,5740,5745,5753,5781,5794,5802,5821,5834,5842,
   5895,5899,5906,5912,5932,5936,5943,5949,5992,6110,6237,6322,
   7737,7744,7780,7787,7904,7905,8054,8055,8088,8095,8187,8194,
   8253,8258,8282,8287,13700,13701,13965,13966,14470,14484,
   19077,19078,19480,19482,19485,19563],
 [3570,3571,3612,3613,3651,3652,3876,3877,4146,4147,4171,4172,
   4263,4264,4302,4303,5650,5651,5735,5736,5776,5777,5816,5817,
   5971,5984,6074,6081,6087,6118,6314,6425,7738,7739,7781,7782,
   7903,7910,8053,8060,8089,8090,8188,8189,8223,8228,8365,8417]
  ,[3572,3614,5977,6258],
 [3573,3574,3615,3616,4085,4086,4089,4116,4117,4119,4142,4167,
   4237,4239,4399,5675,5676,5760,5761,5976,5982,6124,6126,6231,
   6234,6312,6449,6451,6531,6544],
 [3575,3581,3617,3623,3659,3663,3884,3888,4157,4162,4182,4187,
   5677,5683,5762,5768,5805,5813,5845,5853,5997,6002,6327,6332]
  ,[3576,3580,3618,3622,3658,3664,3883,3889,4156,4164,4181,
   4189,5684,5685,5769,5770,5807,5812,5847,5852,5995,6003,6325,
   6333],
 [3577,3578,3585,3586,3619,3620,3627,3628,3660,3662,3667,3668,
   3885,3887,3892,3893,4154,4158,4160,4161,4179,4183,4185,4186,
   4268,4274,4275,4276,4307,4313,4314,4315,4431,4441,4445,4446,
   4470,4475,4487,4489,5679,5680,5687,5688,5764,5765,5772,5773,
   5803,5804,5808,5809,5843,5844,5848,5849,5994,5998,6000,6001,
   6130,6131,6136,6138,6324,6328,6330,6331,6455,6456,6461,6463,
   6569,6586,6590,6599,6614,6615,6633,6634],
 [3579,3584,3621,3626,3661,3669,3886,3894,4153,4159,4178,4184,
   4269,4273,4308,4312,5681,5686,5766,5771,5810,5811,5850,5851,
   5993,5999,6129,6137,6323,6329,6454,6462],
 [3582,3583,3624,3625,3665,3666,3890,3891,4155,4163,4180,4188,
   5678,5682,5763,5767,5806,5814,5846,5854,5996,6004,6326,6334]
  ,[3655,3656,3880,3881,4385,5786,5787,5826,5827,6229],
 [3657,3882,4090,4092,4112,4113,5674,5759,5792,5832,6125,6450],
 [3671,3679,3685,3689,3754,3963,3969,3973,6008,6010,6022,6024,
   6148,6207,6407,6409,7857,7861,7876,7878,8029,8167,8525,8527,
   41052,41188,41781,42218,43432,44437,45367,45428,46749,47138,
   47672,48515],
 [3672,3676,3678,3680,3791,3929,3962,3964,6009,6015,6021,6023,
   6178,6337,6406,6408,7856,7874,7877,7879,7992,8505,8526,8528]
  ,[3677,3714,6018,6050,7875,7950],
 [3681,3682,3965,3966,4084,6025,6026,6410,6411,6530],
 [3687,3696,3971,3980,4218,4219,4220,4221,5855,5856,5860,5873,
   6011,6027,6235,6412,8122,8123,8124,8129,12835,12836,12841,
   12849,12850,12851,13699,13967,19083,19509],
 [3691,3692,3693,3694,3730,3731,3732,3733,3910,3911,3912,3913,
   3975,3976,3977,3978,4320,4321,4337,4338,5896,5897,5898,5908,
   5910,5911,5933,5934,5935,5945,5947,5948,6006,6019,6040,6053,
   6083,6085,6361,6404,7863,7864,7865,7870,7942,7943,7944,7949,
   8219,8220,8226,8230,8255,8256,8260,8284,8285,8289,8415,8419,
   8719,8781,8963,9078,10734,10858,10917,12684,12687,14577,
   16408,18233],
 [3695,3697,3979,3981,4386,6012,6017,6261,6262,6382],
 [3698,3699,3703,3704,3982,3983,3987,3988,4424,4469,6030,6032,
   6037,6038,6415,6417,6422,6423,6591,6632],
 [3700,3708,3984,3992,6029,6033,6414,6418,13796,13813,13982,
   13989,14304,14305,19106,19111,19294,19295,19614,19617],
 [3701,3702,3707,3709,3985,3986,3991,3993,4454,4488,6028,6034,
   6035,6036,6413,6419,6420,6421,6576,6620],
 [3705,3706,3989,3990,6031,6039,6416,6424],
 [3710,3718,3724,3728,3752,3898,3904,3908,6042,6044,6056,6058,
   6146,6205,6364,6366,7936,7940,7955,7957,8025,8163,8443,8445,
   13766,13767,14169,14171,14174,14201,14202,14252,14322,19011,
   19012,19276,19277,19375,19377,19781,19782,19795,38881,38882,
   39274,39275,40323,40324,41142,41143,42244,42245,42515,42517,
   42519,42522,42529,42532,42555,42556,42568,42569,42573,42627,
   42661,42663,42665,42701,42707,42709,42910,42959,42982,42985,
   42987,43025,43367,44355,44983,44984,45915,45916,45920,45921,
   45928,45946,45951,45952,45980,45985,45989,46086,46111,46114,
   46115,46139,46141,46667,47163,47166,47629,48472,50453,50454,
   50455,50471,50472,50488],
 [3711,3715,3717,3719,3789,3790,3792,3895,3897,3899,3932,3995,
   6043,6049,6055,6057,6175,6176,6181,6335,6342,6363,6365,6465,
   7935,7953,7956,7958,7988,7991,7994,8441,8444,8446,8509,8563,
   8716,8778,8964,9079,10731,10857,10916,12746,12864,14186,
   14190,14212,14218,14339,14340,16407,16464,18234,19787,19792,
   19798,19806,19811,19819,38333,38372,38560,38625,39428,39462,
   39784,39827,40056,40135,40646,40728,40955,41417,41464,41736,
   41853,41922,42592,42695,42935,43046,44662,44694,45258,45506,
   45578,45885,46061,46113,49067,49409,49497,49523,49824,49885,
   50397,50437,50845,52007,52071,52146],
 [3720,3721,3900,3901,6059,6060,6367,6368],
 [3726,3735,3906,3915,6045,6061,6233,6369,7867,7880,7946,7959,
   8340,8344,8447,8529],[3734,3914,6046,6260],
 [3736,3916,6051,6359],
 [3737,3738,3742,3743,3917,3918,3922,3923,6064,6066,6071,6072,
   6372,6374,6379,6380],
 [3739,3747,3919,3927,6063,6067,6371,6375,7883,7887,7889,7892,
   7962,7966,7968,7971,8450,8454,8456,8459,8532,8536,8538,8541,
   22355,22356,22360,22373,22863,22864,22865,22866,40375,40383,
   40750,40751,42229,42230,42322,42323,44322,44323,45437,45439,
   45733,45734,49972,49974],
 [3740,3741,3746,3748,3920,3921,3926,3928,6062,6068,6069,6070,
   6370,6376,6377,6378],
 [3744,3745,3924,3925,6065,6073,6373,6381],
 [3756,4193,6152,6213,8032,8168,8715,8962,10854,12747,14514,
   14523,14565,19848,19857,19862,26160,26316,26510,27643,27841,
   28970,29168,30394,31620,32797,38205,38331,38557,38921,39015,
   39193,39313,39424,39779,40055,40287,40450,40642,40824,40870,
   40914,41069,41239,41411,41850,42109,42193,42362,42449,42494,
   42593,42761,42936,43104,43330,43685,44030,44394,44904,45084,
   45501,45745,45806,45847,46064,46241,46593,47090,47266,47331,
   47399,47433,47575,48035,48445,48796,49217,50046,50075,51006,
   51050],
 [3758,3759,4026,4027,6155,6156,6484,6485,43495,43496,47749,
   47750],
 [3764,4032,4200,4286,6157,6200,6241,6486,43501,47751,48347,
   50167],
 [3768,3769,4036,4037,4197,4198,4283,4284,5900,5914,5937,5951,
   6077,6091,6208,6429,8017,8024,8156,8157,8233,8261,8290,8422,
   43476,43505,43506,44142,44143,44332,46485,46514,46517,48535,
   50164,50165],
 [3770,3771,4038,4039,4195,4196,4281,4282,5902,5916,5939,5953,
   6075,6089,6149,6427,8018,8019,8155,8162,8231,8263,8292,8420,
   43507,43508,43537,44173,44202,44203,46455,46456,46644,47692,
   50162,50163],[3772,4040,6142,6266,43509,47531],
 [3773,4041,4191,4238,6141,6216,6239,6517,43510,47504,48623,
   50119],
 [3774,4042,4087,4091,4114,4118,6147,6214,6215,6386,6515,6516,
   43511,47651,48621,48622,48822,49173],
 [3775,3780,4043,4048,4206,4292,6160,6167,6223,6489,6496,6524,
   43512,43517,47754,47761,48630,50173],
 [3776,3781,4044,4049,4211,4297,6162,6168,6217,6491,6497,6518,
   43513,43518,47756,47762,48624,50178],
 [3777,3785,4045,4053,4209,4210,4295,4296,6159,6163,6220,6228,
   6488,6492,6521,6529,43514,43522,47753,47757,48627,48635,
   50176,50177],
 [3778,3779,3784,4046,4047,4052,4202,4203,4207,4208,4288,4289,
   4293,4294,6158,6164,6165,6219,6221,6226,6227,6487,6493,6494,
   6520,6522,6527,6528,43515,43516,43521,47752,47758,47759,
   48626,48628,48633,48634,50169,50170,50174,50175],
 [3782,3783,4050,4051,4204,4212,4290,4298,6161,6169,6218,6222,
   6490,6498,6519,6523,43519,43520,47755,47763,48625,48629,
   50171,50179],[3786,4054,6166,6495,43523,47760],
 [3794,3930,6183,6340,7996,8507],
 [3795,3934,3997,4055,6185,6345,6468,6500],
 [3796,3811,3933,3996,4056,4071,6186,6336,6344,6385,6467,6501],
 [3800,3938,4001,4060,5863,5869,5875,5877,7977,8133,8136,8138,
   38466,38727,39509,39598,40187,40434,41007,41311,41830,42034,
   43609,43661,44011,44281,44710,44774,45394,46426,46712,47011,
   47713,48014,48125,48423],
 [3801,3810,3939,4002,4061,4070,6187,6232,6238,6346,6469,6502],
 [3809,4069,6259,6265],
 [3812,3815,3954,3955,4017,4018,4072,4075,6190,6194,6354,6356,
   6477,6479,6505,6509],
 [3813,3956,4019,4073,6192,6357,6480,6507],
 [3814,3820,3952,3957,4015,4020,4074,4080,6191,6193,6352,6358,
   6475,6481,6506,6508],
 [3816,3953,4016,4076,6195,6353,6476,6510],
 [3817,3821,3950,4013,4077,4081,6197,6347,6349,6470,6472,6512],
 [3818,3951,3959,4014,4022,4078,6188,6198,6351,6474,6503,6513],
 [3819,3822,3958,3960,4021,4023,4079,4082,6189,6199,6348,6350,
   6471,6473,6504,6514],[3823,4083,6355,6478],
 [3947,4010,6172,6267],[3948,4011,6171,6240],
 [3949,4012,6177,6387],[3961,4024,6196,6511],
 [4088,4115,4224,5871,5879,5880],
 [4093,4094,4357,4372,5918,5955,6084,6383],
 [4095,4096,6093,6431],[4097,6270],[4098,6243],[4099,6390],
 [4100,4132,4421,6392,6534,6554],[4101,4133,6536,6555],
 [4102,4129,6537,6550],[4103,4131,6538,6552],
 [4104,4130,4412,6401,6539,6551],
 [4105,4127,4415,6399,6541,6547],[4106,4128,6542,6549],
 [4107,4135,4414,6397,6543,6548],
 [4108,4134,4422,6393,6535,6556],[4109,4418,6396,6545],
 [4110,6546],[4111,6553],
 [4120,4121,4324,4341,5909,5917,5946,5954],
 [4122,4123,6092,6430],[4124,6269],[4125,6242],[4126,6389],
 [4136,4417,6394,6532],[4137,4419,6395,6533],[4138,6540],
 [4150,4175,5661,5746],[4199,4285,6201,6268,48374,50166],
 [4201,4287,6206,6388,48494,50168],
 [4205,4291,6224,6525,48631,50172],
 [4213,4299,6225,6526,48632,50180],[4214,5881],[4222,5866],
 [4223,5865],
 [4225,4226,4228,4229,4230,4231,4234,4236,5882,5884,5886,5888,
   5889,5890,5891,5892],
 [4227,4232,4233,4235,5883,5885,5887,5893],
 [4240,4241,4356,4371,5919,5956,6078,6236],
 [4242,4243,6094,6432],[4244,6271],[4245,6244],[4246,6391],
 [4247,4252,4403,4409,6245,6252,6559,6566],
 [4248,4253,6561,6567],[4249,6562],[4250,6564],
 [4251,4400,6254,6563],[4254,4255,4402,6250,6560,6568],
 [4256,4406,6249,6557],[4257,6558],[4258,6565],
 [4265,4304,6111,6264],[4267,4306,6116,6384],
 [4270,4278,4309,4317,6128,6132,6453,6457],
 [4271,4279,4310,4318,6134,6135,6459,6460],
 [4272,4277,4311,4316,6127,6133,6452,6458],
 [4322,4339,5904,5941],[4323,4340,5903,5940],
 [4325,4328,4342,4345,4367,4382,5927,5929,5964,5966,6095,6433],
 [4326,4343,5930,5967],
 [4327,4333,4344,4350,4366,4368,4381,4383,5925,5931,5962,5968,
   6096,6106,6434,6444],
 [4329,4346,4358,4369,4373,4384,5926,5963,6103,6104,6441,6442],
 [4330,4334,4347,4351,4361,4364,4376,4379,5920,5922,5957,5959,
   6099,6102,6437,6440],
 [4331,4348,4363,4378,5924,5961,6097,6435],
 [4332,4335,4349,4352,4360,4375,5921,5923,5958,5960,6100,6438],
 [4336,4353,4362,4377,5928,5965,6101,6439],
 [4355,4370,6079,6263],[4359,4374,6105,6443],
 [4365,4380,6098,6436],[4387,6281],[4388,6282],[4389,6277],
 [4390,6279],[4391,6278],[4392,6274],[4393,6276],
 [4394,6275],[4395,6283],[4396,6272],[4397,6273],
 [4398,6280],[4401,6255],[4404,6251],[4405,6247],
 [4407,6248],[4408,6256],[4410,6246],[4411,6253],
 [4413,6402],[4416,6398],[4420,6403],[4423,6400],
 [4425,4447,4464,4478,6582,6592,6601,6617],
 [4426,4462,4479,6593,6610,6626],
 [4427,4432,4455,4477,6572,6577,6594,6622],
 [4428,4459,6575,6596],
 [4430,4440,4451,4453,4460,4467,4471,4476,6573,6584,6585,6598,
   6604,6605,6613,6616],[4433,4457,6587,6602],[4434,6629],
 [4435,4448,4465,4473,4481,6571,6580,6607,6618,6624],
 [4436,4463,4474,6595,6608,6627],
 [4437,4456,4472,6570,6609,6623],[4439,6612],[4442,6578],
 [4443,4484,6579,6588],[4444,6630],[4449,6600],
 [4450,4482,6581,6619],[4458,4483,6603,6628],[4468,6621],
 [4485,6589],[4486,6631],[6635,6636,6699,6701,6702,6885],
 [6637,6888],[6639,6641,6763,6766,6887,6946],[6640,6889],
 [6642,6703,6706,6824],[6643,6700,6705,6886],
 [6644,6645,6647,6650,6707,6708,6710,6713,6890,6891,6893,6896],
 [6646,6648,6651,6709,6711,6714,6892,6894,6897],
 [6649,6652,6712,6715,6895,6898],[6653,6716,6899],
 [6658,6663,6666,6677,6904,6909,6912,6923,7074,7075,7078,7082,
   7083,7086,7092,7097,13653,13736,19028,19183],
 [6660,6683,6723,6741,6744,6746,6924,6927],
 [6661,6682,6724,6728,6743,6745,6911,6926,10048,12001,12137,
   17628],[6664,6910,10221,10331,17665,17775],
 [6665,6680,6907,6928,10184,17492],[6667,6674,6914,6915],
 [6668,6669,6730,6731,6732,6737,6913,6920],[6670,6931],
 [6671,6930],[6676,6932],[6678,6681,6906,6929],[6684,6917],
 [6685,6739,6749,6916],[6686,6733,6748,6922],
 [6687,6691,6754,6756,6939,6942],
 [6688,6689,6753,6757,6938,6943],
 [6690,6695,6752,6755,6940,6944],
 [6692,6697,6758,6761,6934,6935],
 [6693,6696,6750,6759,6933,6937],
 [6694,6698,6751,6760,6936,6941],[6704],[6734,6747],
 [6762,6765,6947,6948],[6764],[6767,6768,6825,6826,6945,7119]
  ,[6769,6770,6772,6775,6949,6950,6952,6955],
 [6771,6773,6776,6951,6953,6956],[6774,6777,6954,6957],
 [6778,6958],
 [6779,6780,6967,6977,38425,38600,38672,38861,39576,39657,39660,
   39765,41054,41365,41368,41530,43588,43981,44797,44826,45051,
   46568,47930,48336,49646,49662,51275,51291],
 [6781,6798,6961,6978,13673,13688,13692,13759,13954,13958,18984,
   18999,19070,19073,19265,19364],[6783,6802,6968,6971],
 [6785,6808,6983,6986],[6786,6807,6970,6985,13892,19339],
 [6787,6797,6959,6960,14061,14062,19161,19336],
 [6788,6791,6963,6982],[6789,6969],
 [6790,6805,6966,6987,14028,19203],[6792,6799,6973,6974],
 [6793,6794,6972,6979],[6795,6801,6990,6991],[6796,6989],
 [6803,6806,6965,6988],[6809,6976],[6810,6811,6975,6981],
 [6812,6818,6996,7001,8654,8691],
 [6813,6817,6819,6820,6994,6995,7002,7003,8663,8677,8686,8705],
 [6814,6815,6822,6823,6993,6997,6999,7000],
 [6816,6821,6992,6998],[6827,7062],[6828],[6829,7005],
 [6830,7007,7126,7181],[6831,7123],[6832,7127],
 [6833,7013,7121,7175],[6834,7124],[6835,7128],
 [6836,7010,7120,7176],[6837,7014,7122,7177],[6838,7125],
 [6839,7129],[6840,6841,7017,7018,7138,7148,7193,7203],
 [6842,6859,7019,7036,7132,7149,7187,7204,13585,13586,13629,
   13636,13637,13672,13674,13690,13694,13704,13705,13712,13713,
   13715,13718,13719,13909,13945,13953,13956,13970,13972,13977,
   13978,14226,14302,14530,14531,14572,14574,15503,15518,15589,
   15883,18899,18900,18941,18942,19025,19040,19042,19066,19069,
   19071,19094,19095,19099,19100,19119,19125,19221,19229,19230,
   19535,19562,19566,19575,19579,19581,19582,19820,19837,19865,
   19866,20652,20723,20726,20918,23788,23792,23859,24054,25258,
   25273,25344,25543,38416,38592,38598,38665,39570,39629,39760,
   39762,40231,40369,40706,40708,41053,41191,41526,41528,41782,
   41956,41962,42088,43299,43431,43640,43642,43769,43771,43964,
   43970,44098,44104,44309,44436,44828,45368,45427,45556,45558,
   46623,46750,46949,47558,47671,47992,47994,48107,48109,48399,
   48512],[6843,6865,7133,7155],
 [6844,6863,7139,7142,15599,15603,16083,20733,20737,21217,23778,
   23781,24047,25263,25266,25532],[6845,6861,7135,7151],
 [6846,6869,7154,7157],[6847,6868,7141,7156,15722,24128],
 [6848,6858,7025,7035,7130,7131,7185,7186],
 [6849,6852,7026,7029,7134,7153,7189,7208,13594,13596,13797,
   13801,13912,13981,14052,14059,14070,14071,14076,14078,14230,
   14539,14573,18918,18920,18959,18961,19298,19303,19539,19611,
   19656,19664,19670,19671,19672,19827,19871],
 [6850,7027,7140,7195],
 [6851,6866,7028,7043,7137,7158,7192,7213,15858,20992,23992,
   25477],[6853,6860,7030,7037,7144,7145,7199,7200],
 [6854,6855,7143,7150],[6856,7039,7161,7217],[6857,7160],
 [6862,7033,7162,7216],
 [6864,6867,7041,7044,7136,7159,7191,7214],[6870,7147],
 [6871,7146],[6872,7152],[6873,7050,7172,7227],[6874,7173],
 [6875,7168],[6876,7170],[6877,7059,7169,7218],
 [6878,7057,7165,7221],[6879,7167],[6880,7055,7166,7220],
 [6881,7174],[6882,7054,7163,7224],[6883,7164],[6884,7171],
 [7004,7063],[7006],[7008,7178],[7009,7182],[7011,7179],
 [7012,7183],[7015,7180],[7016,7184],[7020,7042,7188,7210],
 [7021,7040,7194,7197],[7022,7038,7190,7206],
 [7023,7046,7209,7212],[7024,7045,7196,7211,20856,25613],
 [7031,7032,7198,7205],[7034,7215],[7047,7202],[7048,7201],
 [7049,7207],[7051,7228],[7052,7223],[7053,7225],
 [7056,7222],[7058,7229],[7060,7219],[7061,7226],
 [7064,7065,7067,7070],[7066,7068,7071],[7069,7072],[7073],
 [7076,7077,7093,7099,9788,9829,10077,10110,11829,11868,13588,
   13589,13607,13609,13630,13631,13648,13650,13714,13729,13731,
   13755,13758,13760,13808,13814,13910,13918,13919,13987,13992,
   14224,14228,14251,14255,14300,14345,17232,17273,17521,17554,
   18896,18897,18905,18907,18940,18947,18948,18983,18985,19001,
   19005,19026,19029,19030,19108,19112,19220,19223,19256,19264,
   19267,19292,19363,19370,19537,19541,19613,22248,22295],
 [7079,7095],[7080,7098,7101,7103],
 [7081,7085,7100,7102,22452,22588],[7084],
 [7087,7088,7089,7094],[7090,7105],[7091,7104],[7096,7106],
 [7107,7116],[7108,7117],[7109,7112],[7110,7114],
 [7111,7113],[7115,7118],
 [7230,7231,7284,7285,7286,7389,7391,7392,7539,7758,7762,7764,
   7765,7801,7805,7807,7808,8075,8076,8083,8084,8380,8381,8388,
   8389,40238,40242,40714,40718,40774,40775,40790,40791,41803,
   41811,41978,41986,42072,42077,42101,42106,43650,43658,45373,
   45379,45562,45568,45709,45710,45725,45726,46630,46638,49932,
   49940,49980,49988],[7232,7235,7288],
 [7233,7234,7289,7290,7337,7339,7390,7440,7441,7443,7540,7587,
   15031,15033,15278,23301,23303,23548],[7236,7340],
 [7237,7238,7490,7493,7541,7634,15825,15827,16235,23974,23975,
   24080],
 [7239,7240,7247,7257,7292,7293,7300,7310,7395,7396,7403,7413,
   7542,7543,7550,7560],
 [7243,7248,7251,7262,7296,7301,7304,7315,7399,7404,7407,7418,
   7546,7551,7554,7565],
 [7245,7268,7298,7321,7419,7422,7566,7569],
 [7246,7267,7299,7320,7406,7421,7553,7568,26908,28286,31023,
   34552],[7249,7302,7405,7552,7690],
 [7250,7265,7549,7570,27044,34416],[7252,7259,7556,7557],
 [7253,7254,7306,7307,7408,7415,7555,7562],
 [7255,7261,7573,7574],[7256,7572],[7263,7266,7548,7571],
 [7269,7559],[7270,7324,7417,7558],[7271,7323,7411,7564],
 [7272,7331,7432,7584],[7273,7283,7330,7430,7583,7585],
 [7274,7328,7333,7335,7429,7435,7439,7580],
 [7275,7326,7327,7336,7433,7436,7438,7582],
 [7276,7281,7334,7428,7575,7581],[7277,7279,7577,7578],
 [7278,7325,7329,7434,7437,7579],
 [7280,7282,7332,7431,7576,7586],[7287,7393],[7291,7394],
 [7303,7318,7402,7423,28422,30887],[7305,7312,7409,7410],
 [7308,7426],[7309,7425],[7314,7427],[7316,7319,7401,7424],
 [7322,7412],[7342,7491],
 [7344,7345,7352,7362,7445,7446,7453,7463,7589,7590,7597,7607],
 [7347,7369,7448,7470,7592,7614],
 [7348,7353,7356,7367,7449,7454,7457,7468,7593,7598,7601,7612],
 [7349,7365,7450,7466,7594,7610],[7350,7373,7613,7616],
 [7351,7372,7600,7615,29612,35633],[7354,7455,7599],
 [7358,7359,7602,7609],[7360,7366,7620,7621],
 [7361,7374,7606,7619],[7368,7371,7595,7618],
 [7375,7376,7605,7611],[7377,7383,7482,7484,7626,7631],
 [7378,7388,7480,7483,7630,7632],
 [7379,7380,7479,7486,7488,7489,7627,7629],
 [7381,7478,7487,7628],[7382,7624],[7384,7625],
 [7385,7387,7481,7485,7623,7633],[7386,7622],
 [7451,7469,7472,7474],[7458,7459,7460,7465],
 [7461,7467,7476,7477],[7462,7475],[7492],
 [7494,7495,7502,7512,7635,7636,7643,7653],
 [7496,7513,7637,7654,33084,36328],[7497,7519,7638,7660],
 [7498,7503,7506,7517,7639,7644,7647,7658],
 [7499,7515,7640,7656,12699,18300],[7500,7523,7659,7662],
 [7501,7505,7520,7522,7642,7646,7661,7663,29784,29786,30191,
   33288,33424,35806,35807,35927,36532,36668,37330,37331,37801,
   37804,37882,38114],[7504,7645],
 [7507,7514,7649,7650,9145,14589],
 [7508,7509,7648,7655,14763,21549],[7510,7666],[7511,7665],
 [7516,7667],[7518,7521,7641,7664],[7524,7652],[7525,7651],
 [7526,7657],[7527,7531,7674,7677],
 [7528,7529,7538,7673,7676,7678],
 [7530,7535,7537,7669,7675,7679],[7532,7670],[7533,7672],
 [7534,7671],[7536,7668],[7680,7681,7688,7698],
 [7682,7699,29777,32277,35662,37303,37318,37389,37584],
 [7683,7705],[7684,7689,7692,7703],[7685,7701],
 [7686,7704,7707,7709],[7687,7691,7706,7708,37522,37658],
 [7693,7694,7695,7700],[7696,7702,7711,7712],[7697,7710],
 [7713,7722],[7714,7721,7723,7724],[7715,7716,7718,7720],
 [7717,7719],
 [7740,7746,7783,7789,8071,8072,8376,8377,21311,25424],
 [7741,7784,8070,8375],
 [7755,7756,7798,7799,8056,8062,8310,8367],
 [7757,7763,7800,7806,8077,8082,8382,8387],
 [7759,7760,7767,7768,7802,7803,7810,7811,8074,8078,8080,8081,
   8379,8383,8385,8386],
 [7761,7766,7804,7809,8073,8079,8378,8384],
 [7825,7831,7840,7841,8311,8314,8392,8401,8402,8624,40106,40107,
   40121,40122,40509,40511,40514,40541,40542,40592,40601,40602,
   40662,40691,40692,41891,41892,41905,41906,41990,41991,42004,
   42006,42410,42411,42424,45444,45446,45449,45476,45477,45527,
   45535,45536,45597,45625,45626,47029,47031,47034,47061,47062,
   47112,47120,47122,47182,47210,47212,49990,49991,50004,50960,
   50961,50974],
 [7826,7839,8338,8400,40112,40120,40515,40538,40600,40690,41897,
   41907,41996,42005,45450,45473,45537,45627,47035,47058,47121,
   47211],
 [7843,7844,7845,7847,7849,7850,7852,7853,8404,8405,8406,8408,
   8410,8411,8413,8414,8666,8670,8695,8714,8737,8752,8799,8814,
   8977,8984,9092,9099,10752,10767,10871,10878,10930,10937,
   12764,12779,12938,12953,16421,16428,16538,16553,18247,18254,
   40123,40124,40125,40126,40128,40129,40133,40134,40604,40605,
   40606,40608,40610,40611,40613,40614,40693,40699,40700,40701,
   40849,40856,40866,40894,40895,40900,41908,41909,41910,41912,
   41913,41914,41917,41918,42010,42011,42016,42018,42470,42471,
   42479,42512,42513,42514,45539,45540,45542,45543,45545,45546,
   45547,45548,45628,45634,45635,45636,45784,45791,45801,45829,
   45830,45835,47126,47127,47132,47134,50050,50051,50059,50092,
   50093,50094],[7866,7881,7951,7961,8317,8439,8449,8530],
 [7872,7882,7945,7960,8313,8448,8464,8531],
 [7884,7885,7888,7893,7965,7969,7970,7973,8453,8457,8458,8461,
   8533,8534,8537,8542],
 [7886,7890,7891,7894,7963,7964,7967,7972,8451,8452,8455,8460,
   8535,8539,8540,8543],
 [7906,7907,7912,8105,8106,8107,8204,8205,8206,8309,8315,8341,
   8342,8462,8610,8611],[7920,8092,8191,8490],
 [7921,7922,8091,8097,8190,8196,8491,8492],
 [7923,7924,7928,7929,7930,7931,8110,8111,8112,8117,8118,8119,
   8209,8210,8211,8216,8217,8218,8493,8494,8498,8499,8500,8501,
   8649,8656,8671,8679,8694,8700,8712,8713],
 [7925,7926,7933,7934,8109,8113,8115,8116,8208,8212,8214,8215,
   8495,8496,8503,8504,15586,15594,15891,16089,16216,20698,
   20725,20810,20836,20837,20923,23793,23950,23952,24048,24062,
   25238,25281,25324,25361,25364,25548],
 [7927,7932,8108,8114,8207,8213,8497,8502],
 [7983,8321,8511,8565],[7984,8348,8510,8564],
 [7989,8468,8512,8566],[7997,8343,8346,8595],
 [7998,7999,8316,8319,8463,8466,8596,8597],
 [8000,8006,8517,8522,8571,8576,8598,8604],
 [8001,8523,8577,8599],
 [8002,8003,8518,8520,8572,8574,8600,8601],
 [8004,8519,8573,8602],[8005,8515,8569,8603],
 [8007,8516,8570,8605],[8008,8524,8578,8606],
 [8009,8513,8567,8607],[8010,8514,8568,8608],
 [8011,8521,8575,8609],
 [8020,8026,8173,8174,8320,8467,8548,8549,44230,44377,46772,
   46773],[8021,8172,8347,8547,44257,46771],
 [8034,8159,8345,8580,44490,46569],
 [8035,8036,8158,8164,8318,8465,8581,8582,44491,44492,46542,
   46689],
 [8037,8043,8179,8184,8554,8559,8583,8589,44493,44499,46778,
   46783],
 [8038,8042,8044,8045,8177,8178,8185,8186,8552,8553,8560,8561,
   8584,8588,8590,8591,44494,44498,44500,44501,46776,46777,
   46784,46785],
 [8039,8040,8180,8182,8555,8557,8585,8586,44495,44496,46779,
   46781],[8041,8181,8556,8587,44497,46780],
 [8046,8175,8550,8592,44502,46774],
 [8047,8048,8176,8183,8551,8558,8593,8594,44503,44504,46775,
   46782],[8125,8131,8140,8141],[8126,8139],
 [8142,8146,8148,8151],
 [8143,8144,8145,8147,8149,8150,8152,8153],
 [8221,8227,8266,8267,8295,8296,8312,8416],
 [8222,8265,8294,8339],[8235,8252,8281,8424],
 [8236,8237,8251,8257,8280,8286,8425,8426],
 [8238,8244,8272,8277,8301,8306,8427,8433],
 [8239,8246,8278,8279,8307,8308,8428,8435],
 [8240,8241,8248,8249,8269,8273,8275,8276,8298,8302,8304,8305,
   8429,8430,8437,8438],
 [8242,8247,8268,8274,8297,8303,8431,8436],
 [8243,8245,8270,8271,8299,8300,8432,8434],[8322,8350],
 [8323],[8324,8470],[8325,8331,8472,8478,8629,8634,8641,8646]
  ,[8326,8480,8635,8648],[8327,8630],[8328,8632],
 [8329,8481,8631,8637],[8330,8479,8627,8640],
 [8332,8477,8628,8639],[8333,8473,8636,8647],
 [8334,8476,8625,8643],[8335,8626],[8336,8633],[8349],
 [8351,8469],[8352,8621],
 [8353,8357,8359,8360,8614,8615,8622,8623],[8354,8617],
 [8355,8619],[8356,8618],[8358,8616],[8361,8612],
 [8362,8613],[8363,8620],[8471],[8474,8642],[8475,8644],
 [8482,8638],[8483,8645],[8650,8662,8681,8689,8697,8703],
 [8651,8673,8687,8690,8704,8706],[8652,8657,8702],
 [8653,8655,8664,8676,8684,8692,8693,8701,9035,9042,9150,9165,
   10988,10995,11158,11173,14592,14599,14766,14773,16649,16664,
   21554,21569],[8658,8667],[8659,8709],[8660,8698],
 [8661,8675,8699,8707],[8665,8678,8685,8696],[8668],
 [8669,8710],[8672],[8674,8680],[8682],[8683,8708],
 [8688],[8711],
 [8723,8724,8726,8729,8785,8786,8788,8791,10738,10739,10741,
   10744,10859,10860,10862,10865,10918,10919,10921,10924,16409,
   16410,16412,16415],
 [8725,8727,8730,8787,8789,8792,10740,10742,10745,10861,10863,
   10866,10920,10922,10925,16411,16413,16416],
 [8728,8731,8790,8793,10743,10746,10864,10867,10923,10926,16414,
   16417,37396,37397,37595,37596,37799,38100],
 [8732,8794,10747,10868,10927,16418],
 [8733,8734,8736,8741,8751,8795,8796,8798,8803,8813,8975,8978,
   8980,8993,8996,9090,9093,9095,9108,9111,10748,10749,10751,
   10756,10766,10869,10870,10872,10877,10887,10928,10929,10931,
   10936,10946,12760,12763,12765,12778,12781,12934,12937,12939,
   12952,12955,16419,16420,16422,16427,16437,16534,16537,16539,
   16552,16555,18245,18248,18250,18263,18266],
 [8735,8742,8797,8804,8979,8994,9094,9109,10750,10757,10873,
   10888,10932,10947,12762,12769,12936,12943,13702,13703,13707,
   13708,13709,13710,13968,13969,13973,13974,13975,13976,16423,
   16438,16536,16543,18249,18264,19096,19097,19098,19103,19104,
   19105,19576,19577,19578,19583,19584,19585,40854,40863,40905,
   42477,42486,42491,45789,45798,45840,50057,50066,50071],
 [8739,8744,8747,8748,8762,8801,8806,8809,8810,8824,10754,10759,
   10762,10763,10777,10882,10889,10893,10896,10897,10941,10948,
   10952,10955,10956,16432,16439,16443,16446,16447],
 [8740,8746,8757,8761,8802,8808,8819,8823,10755,10761,10772,
   10776,10880,10883,10895,10898,10939,10942,10954,10957,16430,
   16433,16445,16448],
 [8745,8807,8998,9113,10760,10892,10951,12772,12946,14067,14068,
   14072,14073,14074,14075,16442,16546,18268,19666,19667,19668,
   19673,19674,19675,47374,47383,47425,51027,51036,51041],
 [8749,8750,8811,8812,9006,9007,9121,9122,10764,10765,10899,
   10900,10958,10959,12776,12782,12950,12956,16449,16450,16550,
   16556,18276,18277],
 [8753,8760,8815,8822,10768,10775,10875,10884,10934,10943,16425,
   16434],
 [8755,8817,9005,9120,10770,10901,10960,12777,12951,16451,16551,
   18275],
 [8756,8818,8987,9102,10771,10881,10940,12783,12957,16431,16557,
   18257,40695,40696,40703,40704,42007,42008,42012,42013,45630,
   45632,45637,45638,47124,47128,47130,47131,47213,47216,47217,
   47219,47220,47221,47222,47224,47369,47376,47386,47414,47415,
   47420,51020,51021,51029,51062,51063,51064],
 [8758,8820,8985,9100,10773,10894,10953,12770,12944,16444,16544,
   18255],[8759,8821,10774,10876,10935,16426],
 [8763,8825,8997,9112,10778,10886,10945,12792,12966,16436,16566,
   18267],
 [8764,8765,8826,8827,8991,8992,9106,9107,10779,10780,10885,
   10891,10944,10950,12790,12791,12964,12965,16435,16441,16564,
   16565,18261,18262],
 [8766,8767,8771,8772,8773,8774,8828,8829,8833,8834,8835,8836,
   9010,9011,9012,9017,9018,9019,9125,9126,9127,9132,9133,9134,
   10670,10679,10693,10702,10707,10721,10781,10782,10786,10787,
   10788,10789,10904,10905,10906,10911,10912,10913,10963,10964,
   10965,10970,10971,10972,12623,12632,12646,12655,12660,12674,
   12793,12794,12798,12799,12800,12801,12967,12968,12972,12973,
   12974,12975,16454,16455,16456,16461,16462,16463,16567,16568,
   16572,16573,16574,16575,18114,18123,18137,18146,18151,18165,
   18280,18281,18282,18287,18288,18289,23074,23083,23097,23106,
   23111,23125],
 [8768,8769,8770,8830,8831,8832,9008,9009,9016,9123,9124,9131,
   10783,10784,10785,10907,10908,10909,10966,10967,10968,12802,
   12803,12804,12976,12977,12978,13617,13623,13660,13666,13744,
   13748,13823,13827,13934,13938,14002,14008,14245,14246,14317,
   14318,14399,14400,16457,16458,16459,16576,16577,16578,18278,
   18279,18286,18931,18939,18973,18981,19056,19064,19136,19144,
   19248,19253,19317,19322,19553,19558,19623,19631,19706,19714,
   39090,39122,39993,40016,41683,41697,43204,43227,45203,45231,
   46350,46387,49771,49785,50586,50614,51397,51416],
 [8775,8776,8777,8837,8838,8839,9013,9014,9015,9128,9129,9130,
   10790,10791,10792,10902,10903,10910,10961,10962,10969,12795,
   12796,12797,12969,12970,12971,16452,16453,16460,16569,16570,
   16571,18283,18284,18285],[8844,9022,14578,16466],
 [8845,16465],[8846,9191,10802,11090,16473,16586],
 [8847,10800,11092,16583],[8848,10803,11093,16587],
 [8849,9197,10799,11095,16467,16581],[8850,10801,11096,16584],
 [8851,10804,11097,16588],[8852,9194,16468,16580],
 [8853,9198,16469,16582],[8854,16585],[8855,16589],
 [8856,9201,10817,11100,16495,16608,19903,21626],
 [8857,9206,10812,11102,16498,16598,19901,21608],
 [8858,9205,10818,11103,16486,16609,19900,21624,40526,40552,
   40680,42416,42427,42440,45465,45493,45614,50001,50015,50028],
 [8859,8874,9204,9219,10810,11107,16477,16480,16590,16593,19919,
   21610],
 [8860,9203,10813,10828,11101,11108,16496,16599,19902,19917,
   21607,21614],
 [8861,9202,10819,10827,11099,11109,16485,16611,19898,19923,
   21623,21630],[8862,10823,11112,16617],
 [8863,9216,10822,11113,16497,16616],
 [8864,8877,9209,9222,10809,11117,16478,16482,16591,16595,19916,
   21605],
 [8865,9220,10811,11118,16479,16594,19907,21609,40530,40558,
   40679,42421,42435,42448,45461,45487,45615,49996,50007,50020],
 [8866,9226,10814,11120,16502,16600,19906,21606],
 [8867,10824,11119,16618],
 [8868,9224,10821,11122,16489,16613,19910,21628,47046,47050,
   47072,47078,47199,47200,50966,50971,50977,50985,50990,50998],
 [8869,10816,11125,16604],[8870,10815,11126,16603],
 [8871,9208,10820,11127,16503,16610],
 [8872,9232,10826,10831,11129,11131,16493,16621,19915,19920,
   21635,21637],[8873,9233,10825,11130,16499,16620,19914,21636]
  ,[8875,9210,16481,16592],[8876,16605],
 [8878,9231,16494,16622],[8879,9213,16500,16602],[8880,16619],
 [8881,9211,16487,16615],[8882,9228,16483,16597],
 [8883,9227,16484,16596],[8884,16601],[8885,16614],
 [8886,9223,16509,16607],[8887,9217,16508,16606],
 [8888,9218,16507,16612],
 [8889,9237,10847,11134,16517,16632,19932,21648],
 [8890,9236,10848,10849,11135,11136,16515,16633,19931,19939,
   21647,21649],
 [8891,9235,10844,11137,16520,16628,19941,21639,39691,39697,
   41346,41350,41647,41655,43181,43189,45156,45161,50388,50389],
 [8892,9234,10846,11138,16519,16630,19942,21646,38788,39076,
   39966,42867,44870,46054,46312,49559,49701,50544,50680,51359],
 [8893,9242,10845,11139,16521,16629,19940,21638,38794,39084,
   39974,42871,44866,46048,46317,49560,49696,50536,50679,51351],
 [8894,8896,9243,9244,10842,11141,16510,16511,16625,16626,19938,
   21641],[8895,9245,10843,11142,16518,16627,19936,21640],
 [8897,9238,16516,16634],
 [8898,8899,9239,9241,10852,10853,11133,11140,16512,16513,16623,
   16624,19933,19935,21643,21644],
 [8900,9240,10851,11132,16514,16631,19934,21645],
 [8965,8966,8968,8971,9080,9081,9083,9086,12750,12751,12753,
   12756,12924,12925,12927,12930,16524,16525,16527,16530,18235,
   18236,18238,18241],
 [8967,8969,8972,9082,9084,9087,12752,12754,12757,12926,12928,
   12931,16526,16528,16531,18237,18239,18242],
 [8970,8973,9085,9088,12755,12758,12929,12932,16529,16532,18240,
   18243],[8974,9089,12759,12933,16533,18244],
 [8981,8990,9096,9105,12780,12787,12954,12961,16554,16561,18251,
   18260],[8982,9097,12786,12960,16560,18252],
 [8986,8989,9004,9101,9104,9119,12773,12784,12788,12947,12958,
   12962,16547,16558,16562,18256,18259,18274],
 [8988,8999,9003,9103,9114,9118,12771,12774,12789,12945,12948,
   12963,16545,16548,16563,18258,18269,18273],
 [8995,9002,9110,9117,12766,12775,12940,12949,16540,16549,18265,
   18272],
 [9001,9116,12767,12941,16541,18271,22193,22194,22394,22447,
   22448,22486,22487,22620,22623,22904,22964,22966],
 [9021,14579],[9023,9137,10982,11144,14583,16641],
 [9024,9136,10979,11145,14586,14762,16638,21545],
 [9025,9138,10983,11146,14587,16642],[9026,10977,11147,16636],
 [9027,10980,11148,16639],[9028,10984,11149,16643],
 [9029,9142,10976,11150,14580,16635],
 [9030,9140,10978,11151,14584,16637],[9031,10981,11152,16640],
 [9032,10985,11153,16644],
 [9033,9036,9146,9149,10994,11155,14593,14608,14769,16648,16663,
   21571],
 [9034,9038,9147,9151,11004,11154,14598,14611,14764,16653,16666,
   21568],[9037,9148,11005,11156,14609,14768,16654,21559],
 [9039,9153,10997,11182,14616,16672],
 [9040,9152,11010,11183,14617,16671],
 [9041,9167,10989,11157,14595,14767,16646,21553],
 [9043,9171,11007,11159,14615,14765,16655,21558],
 [9044,10992,11181,16673],
 [9045,9169,10998,11177,14602,14776,16668,21573],[9046,16659],
 [9047,16658],[9048,16665],
 [9049,9177,11008,11186,14606,14781,16676,21580],
 [9050,9178,11002,11185,14612,14780,16675,21581],
 [9051,9164,10987,11162,14590,14785,16645,21555],
 [9052,9155,10990,11163,14594,14783,16647,21552],
 [9053,9172,14597,16660],
 [9054,9154,10986,10996,11164,11172,14591,14782,14789,16650,
   21550,21575],[9055,9176,14607,16677],
 [9056,9158,11009,11166,14613,14787,16657,21562],
 [9057,10993,11180,16674],[9058,9156,14600,16670],
 [9059,9166,14605,16652],[9060,16651],[9061,16656],
 [9062,11001,11174,16669],[9063,9168,14622,16662],
 [9064,9162,14621,16661],[9065,9163,14620,16667],
 [9066,9067,9181,9182,11024,11026,11189,11190,14628,14630,14797,
   14798,16687,16688,21592,21593],
 [9068,9069,9070,9179,9180,9187,11021,11022,11023,11192,11193,
   11194,14632,14633,14634,14806,14807,14808,16683,16684,16685,
   21583,21584,21591],
 [9071,9189,11020,11197,14624,14802,16680,21585],
 [9072,9190,11027,11198,14631,14803,16682,21587],
 [9073,9188,11019,11196,14623,14804,16681,21586],
 [9074,9183,11025,11191,14629,14805,16689,21594],
 [9075,9186,11030,11195,14626,14801,16678,21589],
 [9076,9184,11029,11188,14625,14799,16679,21588],
 [9077,9185,11028,11187,14627,14800,16686,21590],
 [9139,14581,14759,21548],[9141,14588],[9143,14582],
 [9144,14585],[9157,14618],[9159,14604],
 [9160,11006,11169,14603],[9161,10999,11168,14610],
 [9170,14619],[9173,14596],[9174,11012,11161,14601],
 [9175,11013,11160,14614],[9192,10805,11089,16470],
 [9193,10806,11091,16474],[9195,16471],[9196,16475],
 [9199,16472],[9200,16476],[9207,10833,11128,16504],
 [9212,16505],[9214,16491],[9215,10829,11114,16490],
 [9221,16492],[9225,16506],[9229,10835,11106,16488],
 [9230,10836,11105,16501],
 [9246,9247,9300,9301,9302,9405,9407,9408,9555,11199,11200,
   11253,11254,11255,11358,11360,11361,11508,16690,16691,16744,
   16745,16746,16849,16851,16852,16999],
 [9248,9251,9304,11201,11204,11257,16692,16695,16748,21912,29027,
   29029,29034,29044,31671,31673,31678,31688],
 [9249,9250,9305,9306,9353,9355,9406,9456,9457,9459,9556,9603,
   11202,11203,11258,11259,11306,11308,11359,11409,11410,11412,
   11509,11556,16693,16694,16749,16750,16797,16799,16850,16900,
   16901,16903,17000,17047],[9252,9356,11205,11309,16696,16800]
  ,[9253,9254,9506,9509,9557,9650,11206,11207,11459,11462,
   11510,11603,16697,16698,16950,16953,17001,17094],
 [9255,9258,9273,9308,9311,9326,9411,9414,9429,9558,9561,9576,
   11209,11216,11262,11269,11365,11372,11512,11519,16699,16702,
   16717,16752,16755,16770,16855,16858,16873,17002,17005,17020],
 [9256,9263,9309,9316,9412,9419,9559,9566,11208,11211,11226,
   11261,11264,11279,11364,11367,11382,11511,11514,11529,16700,
   16707,16753,16760,16856,16863,17003,17010],
 [9257,9259,9264,9274,9310,9312,9317,9327,9413,9415,9420,9430,
   9560,9562,9567,9577,11210,11212,11217,11227,11263,11265,
   11270,11280,11366,11368,11373,11383,11513,11515,11520,11530,
   16701,16703,16708,16718,16754,16756,16761,16771,16857,16859,
   16864,16874,17004,17006,17011,17021],
 [9260,9276,9313,9329,9416,9432,9563,9579,11218,11271,11374,
   11521,16704,16720,16757,16773,16860,16876,17007,17023],
 [9261,9315,11236,11274,11290,11378,11388,11522,16881,17029],
 [9262,9270,9314,11237,11275,11289,11375,11377,11535,16882,17022,
   17028],
 [9265,9318,9421,9568,11213,11229,11266,11282,11369,11385,11516,
   11532,16709,16762,16865,17012],
 [9266,9587,11235,11281,11379,11517,16723,17030],
 [9267,9278,9320,9331,9423,9434,9570,9581,11220,11231,11273,
   11284,11376,11387,11523,11534,16711,16722,16764,16775,16867,
   16878,17014,17025],[9268,9332,11287,11371,16884,17016],
 [9269,9319,11276,11288,11370,11384,16883,17015],
 [9271,9589,11230,11291,11381,11543,16715,17033],
 [9272,9287,11292,11380,17024,17032],[9275,9334,16862,17017],
 [9277,9338,16872,17034],[9279,9586,11234,11518,16710,17031],
 [9280,9333,9436,9583,16724,16777,16880,17027],
 [9281,9282,9328,16870,17008,17009],
 [9283,9321,9435,11268,11390,16781,16869,17013],
 [9284,9322,9422,11223,11267,11391,11531,16780,16868,17026],
 [9285,9330,16887,17019],[9286,9574,11293,11386,16730,17018],
 [9288,9291,9342,9343,9448,9452,11244,11296,11300,11401,11402,
   11551,16791,16796,16893,16898,17042,17044],
 [9289,9344,9349,9446,9595,11243,11298,11403,11549,16738,16790,
   16895,16899,17045],
 [9290,9341,9345,9445,9599,11247,11297,11299,11399,11404,11548,
   16743,16795,16894,16897,17040],
 [9292,9444,9592,9594,11246,11301,11400,11546,16739,16742,16794,
   17041],
 [9293,9297,9348,9602,11251,11303,11397,11545,16740,16891,17035,
   17037],
 [9294,9346,9451,9455,9601,11252,11294,11304,11398,11406,11552,
   16733,16788,16793,16890,17039],
 [9295,9298,9350,9597,11249,11250,11544,11555,16736,16888,17036,
   17038],
 [9296,9447,9591,9593,11245,11248,11547,11550,16737,16741,16792,
   17046],
 [9299,9351,9450,9453,9596,11242,11302,11408,11554,16734,16785,
   16789,16889,17043],
 [9303,9409,11256,11362,16747,16853,31772,31783],
 [9307,9410,11260,11363,16751,16854],
 [9323,9417,11222,11272,11392,11524,16779,16875],
 [9324,11278,11394,16886],[9325,11277,11395,16885],
 [9335,9431,16767,16861],
 [9336,9424,9582,11215,11537,16728,16766,16866],
 [9337,9425,9569,11214,11538,16727,16765,16879],
 [9339,11240,11533,16871],[9340,11239,11527,16877],
 [9347,9352,9449,9454,9598,9600,11241,11295,11305,11405,11407,
   11553,16732,16735,16786,16787,16892,16896],
 [9354,9458,11307,11411,13092,13095,13148,16798,16902,18403,
   18406,18459],
 [9357,9359,9604,11310,11312,11557,16801,16803,17048],
 [9358,9507,11311,11460,16802,16951],
 [9360,9363,9378,9461,9464,9479,9605,9608,9623,11314,11321,
   11415,11422,11559,11566,16804,16807,16822,16905,16908,16923,
   17049,17052,17067],
 [9361,9368,9462,9469,9606,9613,11313,11316,11331,11414,11417,
   11432,11558,11561,11576,16805,16812,16906,16913,17050,17057],
 [9362,9364,9369,9379,9463,9465,9470,9480,9607,9609,9614,9624,
   11315,11317,11322,11332,11416,11418,11423,11433,11560,11562,
   11567,11577,16806,16808,16813,16823,16907,16909,16914,16924,
   17051,17053,17058,17068],
 [9365,9381,9466,9482,9610,9626,11323,11424,11568,16809,16825,
   16910,16926,17054,17070],
 [9366,9367,11341,11342,11427,11428,11569,11582,17075,17076],
 [9370,9471,9615,11318,11334,11419,11435,11563,11579,16814,16915,
   17059],[9371,11340,11429,11434,11564,17077],
 [9372,9383,9473,9484,9617,9628,11325,11336,11426,11437,11570,
   11581,16816,16827,16917,16928,17061,17072],
 [9373,9485,11421,11440,16934,17063],
 [9374,9472,11328,11420,11441,11578,16933,17062],
 [9375,9467,11327,11425,11442,11571,16932,17069],
 [9376,11431,11444,17080],[9377,11430,11445,17079],
 [9380,9386,17056,17064],[9382,9390,17066,17081],
 [9384,11339,11565,17078],[9385,9486,9630,16829,16930,17074],
 [9387,9481,16920,17055],
 [9388,9474,9629,11320,11584,16833,16919,17060],
 [9389,9475,9616,11319,11585,16832,16918,17073],
 [9391,11345,11580,17065],[9392,11344,11574,17071],
 [9393,9395,9495,9498,9646,11349,11352,11449,11452,11595,11598,
   16848,16944,16948,17087,17091],
 [9394,9396,9496,9502,9642,11348,11451,11453,11596,16843,16943,
   16949,17089,17092],
 [9397,9494,9639,11351,11450,11454,11593,16847,16947,17088],
 [9398,9501,9649,11356,11447,11456,11592,16845,16941,17084],
 [9399,9499,9505,9645,9648,11346,11357,11448,11457,11599,11600,
   16838,16840,16940,16946,17086],
 [9400,9402,11355,11591,17082,17085],
 [9401,9497,9640,11350,11597,16842,16945,17093],
 [9403,9503,9644,11354,11602,16841,16938,17083],
 [9404,9500,9504,9643,9647,11347,11455,11458,11601,16837,16839,
   16939,16942,17090],
 [9418,9573,11221,11285,11393,11525,16719,16778],
 [9426,9564,9565,11219,11232,11539,11540,16725,16726,16772],
 [9427,11225,11541,16783],[9428,9590,11224,11542,16721,16782],
 [9433,16784],[9437,9585,16705,16759],
 [9438,9578,9584,16706,16714,16758],[9439,9571,16713,16763],
 [9440,9572,11228,11526,16712,16776],[9441,16769],
 [9442,16768],[9443,9575,16729,16774],[9460,11413,16904],
 [9468,11326,11438,11443,11572,16931],
 [9476,9611,11324,11586,16831,16925],[9477,11330,11588,16936],
 [9478,11329,11589,16935],[9483,16937],[9487,16912],
 [9488,9625,16819,16911],[9489,9618,16818,16916],
 [9490,9619,16817,16929],[9491,16922],[9492,16921],
 [9493,16927],[9508,11461,16952,29037,29048,31681,31692],
 [9510,9513,9528,9651,9654,9669,11464,11471,11605,11612,16954,
   16957,16972,17095,17098,17113,21664,21680,21717,21733,21820,
   21836,21967,21983],
 [9511,9518,9652,9659,11463,11466,11481,11604,11607,11622,16955,
   16962,17096,17103],
 [9512,9514,9519,9529,9653,9655,9660,9670,11465,11467,11472,
   11482,11606,11608,11613,11623,16956,16958,16963,16973,17097,
   17099,17104,17114],
 [9515,9531,9656,9672,11473,11614,16959,16975,17100,17116],
 [9516,11477,11491,11615,11617,17122],
 [9517,11476,11492,11618,11628,17121],
 [9520,9661,11468,11484,11609,11625,16964,17105],
 [9521,11478,11490,11610,11624,17123],
 [9522,9533,9663,9674,11475,11486,11616,11627,16966,16977,17107,
   17118],[9523,9675,11470,11630,16983,17109],
 [9524,9662,11469,11631,16982,17108],
 [9525,9657,11474,11632,16981,17115],[9526,11480,11634,17126],
 [9527,11479,11635,17125],[9530,17110],[9532,17127],
 [9534,11489,11611,17124],[9535,9676,16979,17120],
 [9536,17102],[9537,9671,16969,17101],[9538,9664,16968,17106],
 [9539,9665,16967,17119],[9540,17112],[9541,9667,16985,17111],
 [9542,17117],
 [9543,9547,9685,11499,11501,11639,11644,16997,17134,17137],
 [9544,9545,9688,9692,11498,11502,11641,11642,16993,16998,17133,
   17138],[9546,9551,9686,11500,11643,16992,17135,17139],
 [9548,9691,9695,11496,11506,11638,11646,16990,16995,17130],
 [9549,9554,9689,9694,11497,11507,11645,11647,16988,16989,17132,
   17136],[9550,11505,11637,17131],
 [9552,17128,21694,21749,21854,22000],
 [9553,9690,9693,11504,11648,16987,16991,17129],
 [9580,9588,16716,16731],[9612,9620,11337,11587,16824,16830],
 [9621,16835],[9622,9637,16826,16834],[9627,16836],
 [9631,9632,16810,16811],[9633,16815],
 [9634,11333,11573,16828],[9635,16821],[9636,16820],
 [9638,9641,11353,11594,16844,16846],[9658,11487,11633,16980],
 [9666,16974],[9668,16984],[9673,16986],[9677,16961],
 [9678,16960],[9679,16965],[9680,16978],[9681,16971],
 [9682,16970],[9683,16976],[9684,11503,11640,16996],
 [9687,16994],[9696,9699,9714,11650,11657,17140,17143,17158],
 [9697,9704,11649,11652,11667,17141,17148],
 [9698,9700,9705,9715,11651,11653,11658,11668,17142,17144,17149,
   17159],[9701,9717,11659,17145,17161],
 [9702,11660,11677,17167],[9703,11673,11678,17166],
 [9706,11654,11670,17150],[9707,11655,11676,17168],
 [9708,9719,11661,11672,17152,17163],[9709,17154],
 [9710,17153],[9711,17160],[9712,9727,11671,11681,17156,17171]
  ,[9713,17170],[9716,17155],[9718,17172],
 [9720,11656,11675,17169],[9721,17165],[9722,17147],
 [9723,17146],[9724,17151],[9725,17164],[9726,17157],
 [9728,17162],[9729,11685,11689,17182],
 [9730,9733,11684,11687,17179,17183],
 [9731,9737,11686,11688,17178,17184],[9732,17180],
 [9734,9740,11683,11692,17175,17181],
 [9735,9739,11690,11693,17174,17177],[9736,11682,11691,17176],
 [9738,17173],
 [9741,9742,9744,9745,9750,9752,9763,9765,9785,9786,9787,9828,
   9830,9870,9871,9874,9875,9885,9887,9911,10065,10074,10075,
   10109,10112,10137,10143,10148,10208,10215,10380,10382,10384,
   10386,10407,10501,11694,11695,11738,11739,11740,11745,11746,
   11757,11759,11823,11827,11828,11867,11869,11906,11910,12018,
   12019,12021,12027,12028,12054,12333,12409,17185,17186,17188,
   17189,17194,17196,17207,17209,17229,17230,17231,17272,17274,
   17314,17315,17318,17319,17329,17331,17355,17509,17518,17519,
   17553,17556,17581,17587,17592,17652,17659,17824,17826,17828,
   17830,17851,17945,22148,22149,22208,22210,22232,22234,22250,
   22254,22275,22289,22291,22315,22357,22361,22368,22374,22472,
   22513,22516,22786,22811,22815,22860,22862],
 [9743,9758,9884,11744,17187,17202,17328,22370],
 [9746,9873,10298,11749,11765,12023,12033,17204,17336,17832],
 [9747,9755,9872,11750,11764,12020,12022,17337,17825,17831],
 [9751,9764,9894,9895,10239,10269,11756,12024,17197,17198,17321,
   17334,17833,17834],
 [9753,9754,9877,9890,10389,10390,11751,11762,11763,11944,11981,
   12029,17195,17208,17338,17339,17683,17713],
 [9756,9771,10326,10392,11758,11766,11768,12026,12031,12041,
   17200,17215,17770,17836,22366,22371,22379,22760,22867,22869,
   26516,26521,26532,26561,26566,26577,32803,32808,32819,32941,
   32946,32957,34069,34074,34085,36185,36190,36201],
 [9757,9772,11767,12025,17827,17835,22365,22868],
 [9760,9892,10388,17190,17317,17742],
 [9762,9770,9888,9896,17327,17342,17797,17837],
 [9766,9767,9886,17325,17445,17482],
 [9768,9769,9879,9880,10176,10182,10235,10385,10595,11742,11743,
   11943,12035,12036,12513,17212,17213,17323,17324,17620,17626,
   17679,17829,18039],
 [9773,9776,9900,9901,10398,10402,11771,11775,12046,12047,17223,
   17228,17348,17353,17845,17847,22383,22393,22878,22880],
 [9774,9775,9777,9781,9899,9902,9903,9907,10394,10395,10396,
   10397,11772,11773,11774,11776,12044,12045,12048,12049,17222,
   17224,17226,17227,17349,17350,17352,17354,17843,17844,17848,
   17849,22382,22390,22391,22392,22870,22871,22879,22881],
 [9778,9780,9782,9783,9905,9906,9908,9910,10399,10400,10404,
   10405,11770,11777,11778,11780,12042,12050,12052,12053,17218,
   17219,17221,17225,17343,17346,17347,17351,17838,17839,17840,
   17841,22384,22386,22388,22389,22873,22874,22875,22876],
 [9779,9784,9904,9909,10401,10403,11769,11779,12043,12051,17217,
   17220,17344,17345,17842,17846,22385,22387,22872,22877],
 [9789,9790,9990,11721,11722,11832,11833,12129,12135,12188,12338,
   12548,17526,17527,18004],
 [9792,9793,9804,9806,9834,9837,9846,9850,9914,9916,9925,9929,
   9953,9957,9964,9970,10066,10068,10101,10103,10409,10411,
   10456,10458,11697,11698,11703,11705,11781,11783,11787,11790,
   11824,11838,11840,11864,11878,11882,12056,12062,12065,12090,
   12096,12101,12335,12337,12360,12362,17236,17237,17248,17250,
   17278,17281,17290,17294,17358,17360,17369,17373,17397,17401,
   17408,17414,17510,17512,17545,17547,17853,17855,17900,17902,
   22145,22146,22167,22169,22189,22190,22191,22238,22241,22274,
   22278,22279,22329,22333,22469,22478,22479,22507,22612,22619,
   22784,22790,22813,22905,40308,40309,40313,40314,40315,40316,
   40407,40408,40412,40413,40414,40415,42205,42206,42207,42212,
   42213,42214,42295,42296,42297,42302,42303,42304,45342,45343,
   45347,45348,45349,45350,49875,49876,49877,49882,49883,49884],
 [9794,9807,10084,10085,11719,11720,11834,11839,11954,11991,
   17238,17251,17528,17529,38709,38711,38951,38953,39637,39644,
   39915,39917,41201,41202,41606,41607,43317,43325,44444,44446,
   44977,44978,47565,47566,49683,49684,51266,51267],
 [9795,9808,9835,9848,9918,9931,9955,9968,10079,10081,10114,
   10116,10144,10146,10209,10211,11831,11842,11871,11880,11907,
   11908,12067,12099,13676,13693,13696,13697,13948,13955,13962,
   13963,16062,17239,17252,17279,17292,17362,17375,17399,17412,
   17523,17525,17558,17560,17588,17590,17653,17655,19067,19072,
   19075,19076,19157,19332,19567,19570,20681,20888,22206,22212,
   22237,22252,22282,22293,22485,22613,23690,25241,25321],
 [9796,9810,9852,9920,10076,10080,10111,10177,11826,11845,11865,
   12071,17242,17256,17297,17365,17435,17446,17514,17548],
 [9797,9919,10067,10410,11708,11825,11846,11866,12070,12334,
   17255,17298,17513,17549],
 [9798,9921,9991,10002,11707,11717,11802,11830,11847,11870,12072,
   12192,12343,12368,17254,17296,17520,17555],
 [9799,9976,10087,10329,11715,11836,11849,12346,17243,17420,
   17531,17773,22174,22292,22302,22757],
 [9800,9977,11835,11850,17530,17899,22286,22301],
 [9803,9809,9851,9926,17472,17483,17515,17550],
 [9805,9813,9967,9975,17517,17532,17800,17909],
 [9811,9854,10069,10105,11700,11784,12340,12366,17241,17363,
   17511,17854],
 [9812,9853,10070,10104,11699,11713,11785,12251,12341,12365,
   17240,17364,17524,17621],
 [9814,9961,11725,12095,12108,12336,17516,17908,22161,22795,
   22884,22951],
 [9815,9962,11724,12094,12109,12279,17522,17907,22160,22737,
   22796,22950],
 [9816,9818,9979,9981,10090,10093,10468,10474,11729,11732,11854,
   11857,12115,12117,12351,12354,17266,17270,17427,17433,17538,
   17542,17917,17920,22177,22188,22304,22313,22806,22807,22960,
   22963],
 [9817,9819,9978,9980,10091,10097,10467,10470,11728,11733,11856,
   11858,12113,12116,12350,12352,17265,17271,17428,17432,17540,
   17543,17915,17919,22178,22186,22311,22314,22798,22808,22953,
   22962],
 [9820,9824,9982,9986,10089,10092,10466,10469,11730,11731,11855,
   11859,12114,12118,12349,12353,17267,17269,17429,17431,17539,
   17544,17916,17921,22185,22187,22303,22312,22799,22809,22952,
   22961],
 [9821,9827,9984,9988,10096,10099,10471,10475,11734,11736,11852,
   11861,12112,12121,12348,12358,17261,17263,17422,17424,17535,
   17541,17911,17914,22181,22182,22306,22310,22800,22804,22954,
   22957],
 [9822,9826,9983,9989,10094,10098,10473,10476,11726,11737,11853,
   11862,12111,12120,12355,12356,17260,17262,17423,17425,17534,
   17537,17912,17918,22180,22183,22305,22308,22802,22805,22955,
   22959],
 [9823,9825,9985,9987,10095,10100,10472,10477,11727,11735,11860,
   11863,12119,12122,12347,12357,17264,17268,17426,17430,17533,
   17536,17910,17913,22179,22184,22307,22309,22801,22803,22956,
   22958],[9831,9913,11807,11872,12058,12363,17561,17857],
 [9832,9912,11806,11873,12057,12130,17562,17856],
 [9836,9849,10119,10120,11879,12059,17361,17374,17858,17859,
   22240,22255,22277,22296,22316,22334,22443,22522,22524,22587,
   22818,22947,42541,42547,42548,42549,42580,42582,42587,42588,
   42716,42722,42723,42724,43056,43058,43063,43064,45936,45937,
   45944,45945,45965,45969,45971,45972,45994,45998,46000,46001,
   46125,46126,46133,46134,50459,50460,50464,50465,50479,50480,
   50485,50487,50495,50496,50501,50503,50507,50508,50512,50513],
 [9838,9959,10115,10179,11885,11946,11982,12105,17379,17417,
   17686,17714],
 [9839,9840,9958,9960,9992,9994,10004,10007,10102,10236,10266,
   10457,11792,11793,11886,11887,11945,11947,11983,11984,12055,
   12089,12104,12106,12193,12194,12219,12359,12514,12531,17377,
   17378,17416,17418,17684,17685,17715,17716,17850,17875,18022,
   18023],[9841,9937,11889,12061,17551,17861,22251,22822],
 [9842,9938,11890,12060,17557,17860,22245,22821],
 [9845,9932,9965,9971,17473,17485,17743,17745],
 [9847,9936,17552,17862],[9855,9928,17567,17798],
 [9856,9857,9922,9923,10325,10640,11809,11810,11875,11876,12074,
   12075,12278,12280,12283,12361,12579,12593,17565,17566,17771,
   17774,17852,18070,22260,22261,22326,22327,22525,22526,22729,
   22731,22734,22812,23030,23044],
 [9858,9859,9941,9942,10125,10132,10421,10423,11817,11818,11894,
   11896,12082,12083,12375,12376,17307,17308,17393,17394,17573,
   17575,17872,17873,22263,22270,22352,22354,22528,22536,22833,
   22834],
 [9860,9861,9939,9940,10126,10128,10420,10427,10665,10682,10686,
   10687,11813,11814,11897,11898,12079,12081,12377,12379,12639,
   12640,12663,12664,17312,17313,17388,17389,17577,17578,17868,
   17870,18154,18155,18172,18174,22272,22273,22343,22344,22537,
   22538,22824,22831,23069,23086,23132,23134,38236,38242,38278,
   38284,38362,38370,38401,38409,39181,39187,39224,39232,39264,
   39272,39447,39453,39481,39487,40084,40088,40163,40167,40657,
   40658,40739,40740,40945,40953,40983,40987,41094,41098,41129,
   41133,41425,41433,41472,41480,41765,41773,41877,41882,41946,
   41951,42947,42955,43076,43084,44649,44653,44686,44691,44922,
   44927,44947,44952,45277,45283,45520,45521,45592,45593,49487,
   49492,49537,49538,49832,49840,49915,49923,50448,50449],
 [9862,9947,10127,10419,11815,11899,12080,12378,17311,17390,
   17579,17869,22271,22351,22539,22823,38544,38550,38842,38850,
   39744,39752,40274,40278,40342,40348,40585,40586,42182,42187,
   42252,42260,42335,42343,42650,42654,45674,45675,46103,46108],
 [9863,9864,9949,9950,10129,10131,10428,10429,11811,11819,11901,
   11902,12077,12078,12381,12383,17302,17303,17385,17386,17569,
   17576,17865,17867,22267,22269,22346,22347,22534,22535,22825,
   22826],
 [9865,9948,10130,10430,11812,11903,12085,12382,17310,17387,
   17568,17866,22268,22345,22533,22827],
 [9866,9943,10124,10422,11816,11895,12084,12374,17309,17392,
   17574,17874,22262,22353,22529,22832],
 [9867,9946,10135,10425,11820,11900,12088,12372,13770,13774,
   13883,14088,14258,14347,17306,17391,17571,17863,18991,19006,
   19150,19261,19275,19359,22266,22350,22531,22829],
 [9868,9869,9944,9945,10133,10134,10424,10426,10710,10711,10728,
   10730,11821,11822,11892,11893,12086,12087,12373,12380,12618,
   12635,12681,12683,17304,17305,17383,17384,17570,17572,17864,
   17871,18109,18126,18130,18131,22264,22265,22348,22349,22530,
   22532,22828,22830,23090,23091,23114,23115,38237,38241,38243,
   38244,38279,38283,38285,38286,38361,38363,38368,38369,38400,
   38402,38407,38408,39182,39186,39188,39189,39225,39226,39231,
   39233,39265,39266,39271,39273,39448,39452,39454,39455,39482,
   39486,39488,39489,40083,40089,40090,40091,40162,40168,40169,
   40170,40650,40651,40655,40656,40732,40733,40737,40738,40946,
   40947,40952,40954,40982,40988,40989,40990,41093,41099,41100,
   41101,41128,41134,41135,41136,41426,41427,41432,41434,41473,
   41474,41479,41481,41764,41766,41771,41772,41875,41876,41883,
   41884,41944,41945,41952,41953,42946,42948,42953,42954,43075,
   43077,43082,43083,44648,44654,44655,44656,44684,44685,44692,
   44693,44920,44921,44928,44929,44945,44946,44953,44954,45278,
   45282,45284,45285,45513,45514,45518,45519,45585,45586,45590,
   45591,49485,49486,49493,49494,49530,49531,49535,49536,49833,
   49834,49839,49841,49914,49916,49921,49922,50441,50442,50446,
   50447],
 [9876,9878,9889,9891,11741,11748,12030,12032,17320,17322,17333,
   17335,22192,22372,22481,22615,40697,40702,42014,42015,45631,
   45639,47123,47129,47214,47215,47218,47223],
 [9881,10001,10038,11747,11760,12037,12038,17210,17211,17330],
 [9882,9897,11753,12039,17326,17341,22381,22859],
 [9883,9898,10353,10393,11752,12040,17206,17214,17332,17340,
   22380,22733],[9893,10381,10387,17191,17199,17316],
 [9917,9930,10414,10415,11804,11805,11874,11955,11992,12064,
   17280,17293,17563,17564,22150,22158,22164,22168,22236,22257,
   22281,22298,22324,22330,22449,22508,22510,22581,22643,22702,
   22792,22794,22816,22945],
 [9933,9934,9972,9974,10240,10241,10271,10272,10406,10431,10578,
   10579,17283,17284,17402,17404,17436,17438,17448,17451,17546,
   17680,17710,17901],
 [9935,9973,10242,10270,11798,12252,17282,17403,17559,17623],
 [9951,9952,12091,12092,17903,17904],
 [9956,9969,10461,10462,12093,12098,17400,17413,17905,17906],
 [9993,10006,11912,11926,12132,12134,12171,12195,17596,17661],
 [9995,10008,12157,12197,17947,17986],
 [9996,10308,11987,12200,17622,17722],
 [9998,12125,12198,12202,12233,17881],[9999,12204,12221,18025],
 [10000,12205,12220,18024],[10003,10046,10307,17447,17490,17751]
  ,[10005,10050,17805,18026],[10009,10040,17491,17750],
 [10010,17454],[10011,12002,12475,17629],
 [10012,11965,12476,17967],[10013,10042,17806,18009],
 [10014,12432,12566,17779],[10015,12285,12565,17926],
 [10016,10055,12151,12209,12242,12486,12555,12573,18015,18036],
 [10017,10056,10313,12149,12211,12243,12554,17896,18017,18037],
 [10018,10053,10316,12148,12212,12239,12489,12558,12570,17894,
   18019,18032],
 [10019,10054,12213,12241,12487,12569,18020,18034],
 [10020,10315,12146,12214,12240,12557,17892,18033],
 [10021,10319,12145,12216,12237,12562,17891,18029],
 [10022,12152,12217,12238,12491,12563,12567,18031],
 [10023,10062,10318,12144,12561,17889,18010,18030],
 [10024,10314,12150,12556,17897,18038],
 [10025,10060,10323,12482,12576,17888,18013,18027],
 [10026,10324,17895,18028],[10027,18035],
 [10028,10039,10071,10106,11704,11706,11789,11843,11848,11883,
   12073,12222,12342,12367,17247,17253,17295,17370],
 [10029,10041,10299,10301,11791,11888,12068,12102,12107,12223,
   17289,17376,17409,17415],
 [10030,10031,10043,10044,10136,10500,11911,11913,11925,11927,
   11957,11960,11996,11997,12169,12172,12189,12224,12225,12384,
   12410,12453,12515,12532,17595,17597,17660,17663,18005,18006],
 [10032,10045,12156,12227,17946,17985],
 [10033,11986,12230,17721],[10034,11949,12131,12231,12261,17691]
  ,[10035,12124,12232,17880],[10036,12191,12234,18008],
 [10037,10312,12190,12235,17876,18007],
 [10047,10306,17453,17484],[10049,11964,12138,17966],
 [10051,12133,12551,17778],[10052,10297,12127,12550,17884,17925]
  ,[10057,12210,12244,12484,12572,18016],
 [10058,10322,12207,12246,12483,12577,17887,18012],
 [10059,12153,12208,12247,12490,12552,12578,18014],
 [10061,12488,12571,18021],[10063,10320,17890,18011],
 [10064,18018],[10072,10464,11710,12344,17258,17405,22176,22787]
  ,[10073,10088,10356,10465,11709,12345,17249,17257,17411,17419,
   22175,22730],[10078,10463,17259,17406],
 [10082,10083,10560,17233,17234,17434],
 [10086,10455,17244,17421],
 [10107,10417,11795,11800,12369,12371,17285,17381,22340,22342,
   22512,22517],
 [10108,10418,11794,12370,17291,17380,22341,22511],
 [10113,10416,17286,17382],[10117,10413,17275,17357],
 [10118,10412,17276,17356,22253,22321,22412,22523,22819,22946],
 [10121,10122,10327,10330,10408,10626,17300,17301,17366,17367,
   17769,18084],[10123,10354,17299,17372],
 [10138,10139,11904,11905,12412,12413,13926,13927,13995,13997,
   14404,14405,17582,17583,18944,18945,19145,19185,19186,19291],
 [10140,11909,11922,12414,12415,17589],
 [10141,10156,10333,10546,11915,12416,17585,17600,17777,17990,
   22219,22482],
 [10142,10547,11914,12417,17599,17924,22218,22476],
 [10145,17584],[10147,10545,17601,17804],
 [10149,10181,11924,11959,11994,12170,17598,17662],
 [10150,10213,17594,17657],
 [10151,10153,10216,10219,10561,10562,17474,17475,17487,17488,
   17580,17944],[10152,10217,17437,17450],
 [10154,10218,11918,12254,17593,17625],
 [10155,10480,17586,17991],[10157,10360,17591,17989],
 [10158,10162,10551,10556,11934,11936,12421,12426,17608,17611,
   17999,18003,22220,22230,22494,22502],
 [10159,10160,10549,10550,11933,11937,12423,12424,17607,17612,
   17997,18002,22221,22231,22501,22503],
 [10161,10166,10548,10552,11935,11938,12422,12425,17609,17613,
   17998,18001,22228,22229,22493,22504],
 [10163,10168,10553,10558,11931,11941,12420,12428,17603,17604,
   17993,17994,22223,22225,22495,22500,26601,26602,26645,26646,
   26647,26730,26734,26735,26925,26934,26935,27240,27979,27980,
   28023,28024,28025,28108,28112,28113,28303,28312,28313,28618,
   30580,30581,30624,30625,30626,30709,30713,30714,30904,30913,
   30914,31219,34109,34110,34153,34154,34155,34238,34242,34243,
   34433,34442,34443,34748],
 [10164,10167,10555,10559,11932,11942,12427,12429,17602,17606,
   17995,18000,22222,22226,22497,22498],
 [10165,10169,10554,10557,11939,11940,12419,12430,17605,17610,
   17992,17996,22224,22227,22496,22499],
 [10170,10521,12158,12386,17948,17988],
 [10171,10279,11988,12389,17615,17723],
 [10172,10280,11951,12390,17689,17693],
 [10173,12126,12391,17882],[10174,12250,12393,18041],
 [10175,12249,12394,18040],[10178,10278,17440,17752],
 [10180,18042],[10183,10214,17949,17987],
 [10185,10439,17455,17748],[10186,10250,10275,17630,17694,17719]
  ,[10187,17968],[10188,17807],[10189,11966,12315,17780],
 [10190,17927],[10191,11976,12271,12398,12539,18052],
 [10192,10284,11974,12272,12400,12538,17707,18053],
 [10193,10287,11973,12268,12401,12542,17705,18048],
 [10194,12270,12402,18050],
 [10195,10286,10617,11971,12269,12403,12541,17703,17980,18049],
 [10196,10290,11970,12266,12405,12546,17702,18045],
 [10197,11977,12267,12406,12547,18047],
 [10198,10289,10620,11969,12545,17700,17977,18046],
 [10199,10285,10614,11975,12540,17708,17982,18054],
 [10200,10294,10625,17699,17981,18043],
 [10201,10295,10623,11978,12276,12397,12536,17706,17973,18044],
 [10202,10293,10624,11980,12275,12396,12544,17698,17974,18051],
 [10203,10204,11948,11985,12455,12456,17688,17718,22200,22202,
   22214,22216,22395,22474,22480,22484,22608,22614,22648,22707],
 [10205,12123,12457,17877],
 [10206,10507,12160,12459,17650,17951,22616,22912],
 [10207,10508,12159,12460,17656,17950,22610,22911],
 [10210,17747],[10212,10506,17651,17952],
 [10220,10222,10357,10358,10478,10627,17664,17666,17801,17802,
   17922,18071],
 [10223,10231,10512,10513,12181,12183,12464,12465,17673,17674,
   17962,17964,22627,22628,22922,22923],
 [10224,10511,12182,12466,17672,17963,22635,22924],
 [10225,10510,12178,12467,17677,17958,22637,22914,39546,39552,
   41228,41232,41515,41523,43037,43045,45037,45042,47177,47178],
 [10226,10227,10509,10517,10672,10695,12179,12180,12468,12469,
   12648,12669,17676,17678,17959,17960,18160,18173,22636,22638,
   22913,22921,23076,23133,38578,38584,38643,38649,38932,38940,
   38971,38979,39791,39799,39834,39842,42615,42619,42749,42753,
   44748,44752,45903,45909,46078,46083,46193,46198,47105,47106,
   47259,47260,49577,49582,49619,49620,50404,50412,50885,50893],
 [10228,10519,12176,12471,17668,17955,22634,22916],
 [10229,10230,10518,10520,12177,12184,12472,12473,17667,17675,
   17956,17957,22632,22633,22915,22917],
 [10232,10234,10515,10516,10716,10729,12185,12187,12462,12470,
   12625,12682,17670,17671,17953,17961,18116,18139,22630,22631,
   22919,22920,23099,23120,38579,38583,38585,38586,38644,38648,
   38650,38651,38931,38933,38938,38939,38970,38972,38977,38978,
   39792,39793,39798,39800,39835,39836,39841,39843,42614,42620,
   42621,42622,42748,42754,42755,42756,44747,44753,44754,44755,
   45904,45908,45910,45911,46076,46077,46084,46085,46191,46192,
   46199,46200,47098,47099,47103,47104,47252,47253,47257,47258,
   49575,49576,49583,49584,49612,49613,49617,49618,50405,50406,
   50411,50413,50884,50886,50891,50892],
 [10233,10514,12186,12463,17669,17954,22629,22918],
 [10237,11990,12516,17726],[10238,11989,12517,17725],
 [10243,17727],[10244,10274,17647,17648,22399,22618,22907,22909]
  ,[10245,10249,10524,17616,17631,17724],
 [10246,10276,17690,17720],[10247,17478],[10251,17712],
 [10252,17711],[10253,17717],
 [10254,10530,12011,12521,17737,18068],
 [10255,10537,10599,12012,12523,17644,17738,18069],
 [10256,10533,10602,12008,12524,17642,17733,18064],
 [10257,10531,12010,12525,17735,18063],
 [10258,10601,12009,12526,17640,17734],
 [10259,10536,10605,12006,12528,17639,17730,18061],
 [10260,10534,10606,12007,12529,17638,17732,18060],
 [10261,10535,10604,12014,12530,17637,17731,18062],
 [10262,10600,17645,17739],[10263,10609,17636,17728],
 [10264,10538,10610,17643,17729,18058],
 [10265,10539,17736,18059],[10267,11953,12533,17696],
 [10268,11952,12534,17695],[10273,17697],[10277,17477],
 [10281,17682],[10282,12265,12385,17681],
 [10283,12264,12281,17687],[10288,10616,11972,12543,17704,17978]
  ,[10291,10619,17701,17975],[10292,10615,17709,17983],
 [10296,12128,12549,17885],[10300,10305,10435,17744,17749,17879]
  ,[10302,17886],[10303,12167,12458,17654],[10304,17883],
 [10310,17799],[10311,12196,12236,17772],
 [10317,12147,12559,17893],[10321,17898],[10328,17755],
 [10332,18056],[10334,17495],[10335,17458],
 [10336,11995,12518,17633],[10337,11958,12535,17971],
 [10338,10486,17784,17810],[10339,17783],
 [10340,10366,17782,17930],
 [10341,10644,12326,12446,12583,12608,17792,18094,22773,22893,
   23042,23067],
 [10342,10643,12327,12448,12585,12609,17790,18095,22772,22900,
   23041,23068],
 [10343,10642,12323,12586,17795,18090,22902,23058],
 [10344,10641,12325,12445,12587,12612,17794,18092,22783,22903,
   23040,23065],
 [10345,10649,12324,12588,17796,18091,22901,23057],
 [10346,10651,12321,12590,17786,18087,22899,23060],
 [10347,10348,10650,10652,12322,12329,12441,12442,12591,12592,
   12615,12616,17785,17793,18088,18089,22777,22779,22897,22898,
   23034,23035,23059,23061,38441,38612,38683,38867,39586,39770,
   39897,39945,41068,41544,41578,41626,43781,43994,44808,44843,
   45064,46757,47998,48410,49649,49673,51280,51304],
 [10349,10645,17791,18096],[10350,10648,17788,18085],
 [10351,10646,17787,18086],
 [10352,10647,12450,12606,17789,18093,22775,23039],
 [10355,17754],[10359,18055],[10361,10582,17449,17494],
 [10362,10565,17457,17486],[10363,17632],[10364,17970],
 [10365,10487,17809,17931],[10367,17929],
 [10368,10656,12299,12596,17939,18081,22746,23055],
 [10369,10655,12300,12301,12597,12598,17937,18082,22745,22753,
   23054,23056],
 [10370,10654,12296,12599,17942,18077,22755,23046],
 [10371,10653,12298,12600,17941,18079,22756,23053],
 [10372,10661,12297,12601,17943,18078,22754,23045],
 [10373,10375,10662,10663,12294,12603,17932,17933,18074,18075,
   22752,23048],
 [10374,10664,12295,12604,17940,18076,22750,23047],
 [10376,10657,17938,18083],
 [10377,10378,10658,10660,17934,17935,18072,18073],
 [10379,10659,12303,12594,17936,18080,22748,23052],
 [10383,10391,17201,17216],[10432,10563,17481,17756],
 [10433,17649],[10436,17479],[10437,17442],[10438,17617],
 [10440,10481,17496,17741],[10441,17740],[10442,17746],
 [10443,10568,17502,17766],[10444,10569,10583,17469,17504,17767]
  ,[10445,10566,10586,17467,17506,17762],
 [10446,10567,17507,17764],[10447,10585,17465,17763],
 [10448,10577,10589,17464,17505,17759],
 [10449,10576,10590,17463,17498,17761],
 [10450,10575,10588,17462,17497,17760],
 [10451,10584,17470,17768],[10452,10573,10593,17461,17500,17757]
  ,[10453,10594,17468,17758],[10454,17765],
 [10459,10460,17395,17396],[10479,18057],[10482,17459],
 [10483,17634],[10484,17972],[10485,17811],
 [10488,10489,10630,10631,17817,17819,18106,18107],
 [10490,10491,10628,10629,17821,17822,18102,18104],
 [10492,10636,17823,18103],[10493,10638,17813,18099],
 [10494,10639,17820,18101],[10495,10637,17812,18100],
 [10496,10632,17818,18108],[10497,10635,17815,18097],
 [10498,10633,17814,18098],[10499,10634,17816,18105],
 [10502,10505,10541,10543,12163,12256,17476,17489,17627,17658],
 [10503,10542,17439,17452],[10504,10544,17614,17965],
 [10522,17493],[10523,17456],[10525,17969],[10526,17808],
 [10527,17781],[10528,17928],[10529,12013,12522,18067],
 [10532,18065],[10540,12017,12527,18066],[10564,17480],
 [10570,17503],[10571,10592,17460,17499],[10572,17501],
 [10574,17508],[10580,17444],[10581,17443],[10587,17466],
 [10591,17471],[10596,17619],[10597,12005,12434,17618],
 [10598,12004,12287,17624],[10603,17641],[10607,17646],
 [10608,12015,12519,17635],[10611,17803],
 [10612,11968,12435,17776],[10613,11967,12288,17923],
 [10618,17979],[10621,17976],[10622,17984],
 [10666,10677,10678,10691,12641,12650,12657,12658,18157,18159,
   18163,18167,23079,23088,23129,23131],
 [10667,10676,10706,12642,12656,18158,18164,18166,23089,23130],
 [10668,10699,12643,12649,18162,18168,23078,23087],
 [10669,10671,10680,10681,10692,10694,10700,10701,10708,10709,
   10712,10717,12622,12624,12633,12634,12645,12647,12653,12654,
   12661,12662,12665,12670,18113,18115,18124,18125,18136,18138,
   18144,18145,18152,18153,18156,18161,23073,23075,23084,23085,
   23096,23098,23104,23105,23112,23113,23116,23121],
 [10673,10674,10683,10690,10696,10698,12621,12671,18117,18118,
   18127,18134,18140,18142,23103,23128],
 [10675,10684,10688,10697,10705,10725,12619,12631,12666,12672,
   18119,18128,18132,18141,18149,18169,23081,23095,23119,23127],
 [10685,10689,10703,10726,12620,12629,12659,12667,12673,12675,
   18129,18133,18147,18170,23071,23080,23110,23118,23124,23126],
 [10704,10727,12630,12644,12668,12676,18148,18171,23070,23082,
   23117,23123],
 [10713,10715,10719,10723,18110,18121,18122,18135],
 [10714,10720,10722,18111,18120,18150],
 [10718,10724,12626,18112,18143,23102],[10797,19887],
 [10798,10974,14753,19886],[10807,11094],[10808,11098],
 [10830,11104,19899,21613],[10832,11111,19921,21617],
 [10834,11124,19908,21615],[10837,11110],[10838,11123],
 [10839,11116,19930,21627],[10840,11115,19929,21621],
 [10841,11121,19928,21622],[10850,11143,19937,21642],
 [10975,14752],[10991,11175,14772,21551],[11000,11167],
 [11003,11184,14786,21582],[11011,11179,14774,21560],
 [11014,11165],[11015,11178],[11016,11171,14796,21572],
 [11017,11170,14795,21566],[11018,11176,14794,21567],
 [11033,11034,11036,11038,11039,11041,31919,32418],
 [11035,11037,11040],[11042],[11044,11048,11051,11064],
 [11049,11050,11058,11063,11069,11070],[11053,11068],
 [11054,11056,11057,11067,11071,11072],[11059,11074],
 [11060,11065,11073,11075],[11233,11286,11389,11536],
 [11238,11528],[11283,11396],[11335,11343,11575,11590],
 [11338,11439,11583],[11436,11446],[11483,11619],
 [11485,11636],[11488,11629],[11493,11621],[11494,11620],
 [11495,11626],[11662,11663],[11664,11669],[11665,11680],
 [11666,11679],[11674],
 [11716,11718,11799,11803,11917,11923,12161,12168,12339,12364,
   12411,12454,22154,22156,22196,22197,22318,22320,22470,22505,
   22541,22547,22552,22788],
 [11723,11841,11851,12100,12110,12306,22166,22287,22300,22764,
   22797,22949],[11761,12034,22359,22550],
 [11844,11884,12069,12103,22239,22280,22548,22554],
 [11891,12066,22246,22820],
 [11919,11921,12164,12166,22195,22199,22483,22617],
 [11920,11928,12309,12418,22209,22217,22477,22492],
 [11929,12282,22203,22491],[11930,12408,22204,22490],
 [11956,12260],[11961,11998,12494,12495],[11962,12000],
 [11963],[11979,12277,12404,12537],[11993,12259],[11999],
 [12003,12314],[12016,12520],[12136,12496],[12139],
 [12140,12477],[12141,12316],[12142,12289],[12143,12436],
 [12154,12215,12248,12553],[12155,12560],
 [12165,12461,22611,22910],
 [12173,12175,12310,12311,12431,12580,22624,22626,22761,22762,
   22882,23031],[12174,12284,22625,22735],[12199,12229],
 [12203,12228],[12206,12226],[12218,12245,12492,12568],
 [12253,12258,12388],[12255,12395],[12257,12392],
 [12263,12308],[12273,12399],[12274,12407],
 [12286,12499,22545,22560],[12290,12480],
 [12291,12319,22744,22890],[12292,22743],
 [12293,12439,22742,22770],[12302,12605,22751,23049],
 [12304,12595,22747,23050],[12305,12602,22749,23051],
 [12312,12564],[12313,12498,22551,22561],[12317,12479],
 [12318,22891],[12320,12438,22771,22889],
 [12328,12584,22892,23066],[12330,12581,22895,23064],
 [12331,12582,22894,23062],[12332,12589,22896,23063],
 [12433,12500,22546,22559],[12437,12481],[12440,22769],
 [12443,12611,22782,23033],[12444,12613,22781,23032],
 [12447,12610,22780,23043],[12449,12617,22778,23036],
 [12451,12607,22774,23037],[12452,12614,22776,23038],
 [12474,12497],[12478],[12485,12574],[12493,12575],
 [12501,12502,12510,12511,22564,22565,22567,22569],
 [12503,12506,22563,22572],[12504,12508,22562,22571],
 [12505,12507,22570,22573],[12509,12512,22566,22568],
 [12627,12636,23094,23100],[12628,12637,12678,23092,23101,23109]
  ,[12638,12679,23093,23107],[12651,23077],
 [12652,12677,23072,23122],[12680,23108],
 [12688,12689,12865,12866,14637,14638,14695,14696,14809,18176,
   18177,19943],[12690,12693,18292,18297],[12691,18294],
 [12692,12694,18295,18298],[12695,18299],[12696,18291],
 [12697,12869,12874,18293,18348,18353],[12698,18296],
 [12700,12708,12721,12878,12882,12895,18302,18306,18319,18356,
   18364,18377],
 [12701,12703,12705,12710,12725,12880,12885,12887,12898,12902,
   18304,18309,18311,18322,18326,18357,18359,18361,18366,18381],
 [12702,12709,12879,12886,13685,13686,13691,13951,13952,13957,
   18305,18320,18360,18375,19091,19092,19093,19571,19572,19573],
 [12704,12719,12881,12896,18303,18310,18358,18365],
 [12706,12714,18314,18328],[12707,12713,12897,18315,18327,18371]
  ,[12711,12715,18321,18329],
 [12712,12889,14050,14051,14056,18324,18379,19661,19662,19663],
 [12716,12717,12893,12899,18331,18332,18387,18388],
 [12718,12877,18301,18374],[12720,18316],
 [12722,12894,18333,18386],[12723,12900,18313,18368],
 [12724,12904,18330,18362,29185,29191,29200,29201,29276,29282,
   29291,29292,35161,35167,35176,35177],[12726,18308],
 [12727,18307],[12728,18312],[12729,18325],
 [12730,12909,18318,18378],[12731,12908,18317,18372],
 [12732,12907,18323,18373],
 [12733,12734,12738,12739,12740,12741,12910,12911,12915,12916,
   12917,12918,16344,16353,16395,18336,18337,18338,18343,18344,
   18345,18391,18392,18393,18398,18399,18400,21478,21487,21529,
   24637,24646,24651,26122,26131,26136],
 [12735,12920,13644,13726,14299,18339,18390,19052,19132,19241],
 [12736,12737,12919,12921,13601,13805,13916,13986,14227,14324,
   18340,18341,18389,18397,18927,18969,19310,19546,19619,19702],
 [12742,12743,12744,12912,12913,12914,18334,18335,18342,18394,
   18395,18396],[12811,12813,12816],
 [12814,12817,33426,33547,36487,36670],[12818],
 [12821,12823,12828,12838],[12825,12834,12839,12846],
 [12826,12845],[12830,12832,12833,12843,12847,12848],
 [12831,12842],
 [12852,12853,12854,12855,12856,12857,12858,12859,12860,12861,
   12862,12863,14537,14546,14551,19825,19834,19876],
 [12867,12873,18346,18352],[12868,12870,18347,18349],
 [12871,18350],[12872,12875,18351,18354],[12876,18355],
 [12883,12888,18383,18384],[12884,12901,18382,18385],
 [12890,18370],[12891,18369],[12892,18376],[12903,18363],
 [12905,18367],[12906,18380],
 [12980,12981,13035,13036,14642,14645,14700,14703,18181,18184,
   23135,23136],[12982,13037,14646,14704,18185,23137],
 [12983,13038,14640,14698,18179,23138],
 [12984,13039,14643,14701,18182,23139],
 [12985,13040,14647,14705,18186,23140],
 [12986,13041,14639,14697,18178,23141],
 [12987,13042,14641,14699,18180,23142],
 [12988,13043,14644,14702,18183,23143],
 [12990,12991,12995,12998,13008,13011,13045,13046,13050,13053,
   13063,13066,14649,14650,14654,14657,14667,14670,14707,14708,
   14712,14715,14725,14728,18188,18189,18193,18196,18206,18209,
   23145,23146,23150,23153,23163,23166],
 [12992,12999,13047,13054,14653,14668,14711,14726,18192,18207,
   23147,23154],
 [12993,13000,13015,13048,13055,13070,14652,14659,14674,14710,
   14717,14732,18191,18198,18213,20702,21222,23148,23155,23170,
   25265,25306],
 [12994,13009,13013,13049,13064,13068,14651,14658,14661,14709,
   14716,14719,18190,18197,18200,23149,23164,23168],
 [12996,13019,13051,13074,14673,14676,14731,14734,18212,18215,
   23151,23174],
 [12997,13018,13052,13073,14660,14675,14718,14733,18199,18214,
   23152,23173],[13001,13056,14677,14735,18216,23156],
 [13002,13057,14672,14730,18211,23157],
 [13003,13058,14663,14721,18202,23158],
 [13004,13005,13059,13060,14662,14669,14720,14727,18201,18208,
   23159,23160],[13006,13061,14680,14738,18219,23161],
 [13007,13012,13062,13067,14679,14681,14737,14739,18218,18220,
   23162,23167],[13010,13065,14664,14722,18203,23165],
 [13014,13017,13069,13072,14655,14678,14713,14736,18194,18217,
   23169,23172],[13016,13071,14656,14714,18195,23171],
 [13020,13021,13022,13075,13076,13077,14665,14666,14671,14723,
   14724,14729,18204,18205,18210,23175,23176,23177],
 [13023,13029,13030,13031,13078,13084,13085,13086,14685,14686,
   14691,14693,14743,14744,14749,14751,16376,16381,18224,18225,
   18230,18232,21510,21515,23178,23184,23185,23186,24614,24665,
   26099,26150],
 [13024,13028,13079,13083,14684,14692,14742,14750,16367,18223,
   18231,21501,23179,23183,24623,26108],
 [13025,13026,13032,13033,13080,13081,13087,13088,14682,14683,
   14687,14689,14740,14741,14745,14747,18221,18222,18226,18228,
   23180,23181,23187,23188],
 [13027,13034,13082,13089,14688,14690,14746,14748,18227,18229,
   23182,23189],
 [13090,13091,13144,13145,13146,13249,13251,13252,13399,18401,
   18402,18455,18456,18457,18560,18562,18563,18710],
 [13093,13094,13149,13150,13197,13199,13250,13300,13301,13303,
   13400,13447,18404,18405,18460,18461,18508,18510,18561,18611,
   18612,18614,18711,18758],[13096,13200,18407,18511],
 [13097,13098,13350,13353,13401,13494,18408,18409,18661,18664,
   18712,18805],
 [13099,13100,13102,13107,13117,13152,13153,13155,13160,13170,
   13255,13256,13258,13263,13273,13402,13403,13405,13410,13420,
   18410,18411,18413,18418,18428,18463,18464,18466,18471,18481,
   18566,18567,18569,18574,18584,18713,18714,18716,18721,18731],
 [13101,13108,13154,13161,13257,13264,13404,13411,18414,18429,
   18467,18482,18570,18585,18717,18732],
 [13103,13118,13156,13171,13259,13274,13406,13421,18412,18419,
   18465,18472,18568,18575,18715,18722],
 [13104,13109,13120,13157,13162,13173,13260,13265,13276,13407,
   13412,13423,18415,18420,18431,18468,18473,18484,18571,18576,
   18587,18718,18723,18734],
 [13105,13181,13269,13413,18438,18476,18590,18740],
 [13106,13180,13268,13426,18439,18477,18577,18739],
 [13110,13270,13408,13431,18434,18437,18483,18741],
 [13111,13164,13267,13366,13414,13507,18433,18486,18589,18688,
   18736,18829],[13112,13176,13262,18489,18595,18727],
 [13113,13163,13167,13261,18490,18586,18594,18726],
 [13114,13128,13158,13166,13266,18491,18579,18593,18733,18737],
 [13115,13121,13272,18493,18744,18745],
 [13116,13271,18494,18743],[13119,18728],
 [13122,13175,13278,13425,18422,18475,18578,18725],
 [13123,13409,13430,18421,18436,18742],
 [13124,13177,13280,13427,18435,18488,18591,18738],
 [13125,18720],[13126,13172,18581,18719],
 [13127,13159,13165,13279,18492,18580,18592,18724],
 [13129,18730],[13130,13184,18588,18729],
 [13131,13183,18582,18735],
 [13132,13138,13185,13186,13190,13191,13289,13293,13295,13296,
   13442,13443,18446,18454,18498,18499,18506,18507,18601,18603,
   18608,18609,18750,18755,27530,27562,28908,28917,28931,28940,
   31518,31532,31546,31560,35075,35089],
 [13133,13137,13192,13193,13288,13294,13436,13440,18445,18453,
   18500,18505,18602,18610,18748,18756,27539,27553,28945,28959,
   31509,31541,35047,35061],
 [13134,13188,13189,13290,13439,18449,18501,18605,18606,18751],
 [13135,13187,13292,18502,18604,18753],
 [13136,13291,13437,13438,18448,18450,18503,18752],
 [13139,13140,13435,13441,18447,18452,18749,18757,27567,27581,
   35038,35070],
 [13141,13142,13194,13446,18451,18599,18746,18747],
 [13143,13195,13297,13299,13445,18444,18496,18504,18600,18754],
 [13147,13253,18458,18564],[13151,13254,18462,18565],
 [13168,13169,18596,18597],[13174,18598],[13178,18573],
 [13179,13275,18478,18572],[13182,18583],
 [13196,13298,13444,18443,18497,18607],
 [13198,13302,18509,18613],[13201,13203,13448,18512,18514,18759]
  ,[13202,13351,18513,18662],
 [13204,13205,13207,13212,13222,13305,13306,13308,13313,13323,
   13449,13450,13452,13457,13467,18515,18516,18518,18523,18533,
   18616,18617,18619,18624,18634,18760,18761,18763,18768,18778],
 [13206,13213,13307,13314,13451,13458,18519,18534,18620,18635,
   18764,18779],
 [13208,13223,13309,13324,13453,13468,18517,18524,18618,18625,
   18762,18769],
 [13209,13214,13225,13310,13315,13326,13454,13459,13470,18520,
   18525,18536,18621,18626,18637,18765,18770,18781],
 [13210,13233,13319,13460,18543,18629,18784,18787],
 [13211,13232,13318,13473,18544,18630,18771,18786],
 [13215,13320,13455,18542,18636,18788],
 [13216,13317,13461,18538,18639,18783],
 [13217,13312,13329,18642,18645,18774],
 [13218,13219,13311,13316,18643,18644,18773,18780],
 [13220,13322,18646,18791,33192,33378,33702,36453,36623,36943],
 [13221,13226,13321,13466,18545,18647,18790,18792,33196,33380,
   33385,33700,36435,36624,36629,36945],
 [13224,13228,13456,18541,18775,18789],
 [13227,13328,13472,18527,18628,18772,33281,33394,33482,36443,
   36455,36633],[13229,13330,13474,18540,18641,18785],
 [13230,18767],[13231,13325,13477,18526,18631,18766],
 [13234,13336,13479,13481,18532,18537,18632,18777],
 [13235,13236,13337,18638,18776,18782],
 [13237,13243,13339,13343,13489,13490,18551,18559,18651,18659,
   18797,18802,30234,30266,32743,32757,32990,32992,33044,33046,
   33193,33197,33308,33377,33383,33388,33624,33696,36156,36170,
   36234,36236,36288,36290,36437,36441,36552,36621,36627,36632,
   36868,36940],
 [13238,13242,13338,13344,13345,13346,13483,13487,18550,18558,
   18652,18653,18658,18660,18795,18803,26326,26331,26342,26375,
   26380,26391,27848,27853,27864,27894,27899,27910,28980,28985,
   28996,29079,29084,29095,30243,30257,30354,30359,30370,31579,
   31584,31595,31627,31632,31643,31720,31725,31736,32734,32766,
   32771,32785,32984,32985,33032,33033,33068,33070,33111,33125,
   33127,33151,33154,33156,33306,33341,33349,33352,33622,33647,
   34024,34029,34040,35105,35110,35121,36128,36142,36228,36229,
   36276,36277,36312,36314,36355,36369,36371,36395,36398,36400,
   36550,36585,36593,36596,36866,36891],
 [13239,13240,13248,13340,13342,13348,13349,13486,13491,13492,
   18548,18549,18554,18650,18654,18655,18657,18798,18800,18801],
 [13241,13247,13341,13347,13484,13493,18553,18556,18649,18656,
   18794,18799],
 [13244,13245,13482,13488,18552,18557,18796,18804,30271,30285,
   33086,33090,33204,33210,33651,33698,36119,36151,36330,36334,
   36448,36454,36895,36942],[13246,13485,18555,18793],
 [13277,13418,18441,18495],[13281,18470],
 [13282,13422,18425,18469],[13283,13415,18424,18474],
 [13284,13416,13417,18423,18430,18487],[13285,18480],
 [13286,18479],[13287,18485],[13304,18615],
 [13327,13465,13471,18546,18547,18648,33191,33209,33379,33699,
   33701,36436,36440,36622,36944,36946],[13331,18623],
 [13332,13333,13462,13469,18529,18530,18622,18627],
 [13334,13463,18528,18640],[13335,13480,18531,18633],
 [13352,18663,21758,21862],
 [13354,13355,13357,13362,13372,13495,13496,13498,13503,13513,
   18665,18666,18668,18673,18683,18806,18807,18809,18814,18824],
 [13356,13363,13497,13504,18669,18684,18810,18825],
 [13358,13373,13499,13514,18667,18674,18808,18815],
 [13359,13364,13375,13500,13505,13516,18670,18675,18686,18811,
   18816,18827],[13360,13368,13506,18693,18819,18833],
 [13361,13367,13519,18694,18820,18832],
 [13365,13369,13501,18692,18826,18834],
 [13370,13371,18836,18837],[13374,18821],[13376,18838],
 [13377,13518,18677,18818],[13378,13502,18691,18835],
 [13379,13520,18690,18831],[13380,18813],
 [13381,13515,18680,18812],[13382,13508,18679,18817],
 [13383,13509,18678,18830],[13384,18823],[13385,18822],
 [13386,18828],
 [13387,13388,13392,13393,13529,13533,13535,13536,18700,18701,
   18708,18709,18841,18843,18848,18849,33910,33919,33933,33942,
   37163,37177,37191,37205],[13389,13532,18704,18844],
 [13390,13391,13530,18703,18845,18846],
 [13394,13395,13528,13534,18702,18707,18842,18850,33947,33961,
   37154,37186],[13396,18839],
 [13397,13537,13539,18698,18706,18840],
 [13398,13538,18699,18847],[13419,18440],[13424,18442],
 [13428,18417],[13429,18416],[13432,18427],
 [13433,13434,18426,18432],[13464,13478,18535,18539],
 [13475,18522],[13476,18521],[13510,18685],[13511,18696],
 [13512,18695],[13517,18697],[13521,18672],[13522,18671],
 [13523,18676],[13524,18689],[13525,18682],[13526,18681],
 [13527,18687],[13531,18705],
 [13540,13541,13543,13548,13558,18851,18852,18854,18859,18869],
 [13542,13549,18855,18870],
 [13544,13559,18853,18860,29065,29067,31702,31705],
 [13545,13550,13561,18856,18861,18872],
 [13546,13551,18878,18879],[13547,13564,18877,18880],
 [13552,18874],[13553,18865],[13554,18864],[13555,18871],
 [13556,18882],[13557,18881],[13560,18866],[13562,18883],
 [13563,18863],[13565,18876],[13566,18858],[13567,18857],
 [13568,18862],[13569,18875],[13570,18868],[13571,18867],
 [13572,18873],
 [13573,13579,13580,13581,18887,18888,18893,18895,38144,38176,
   38181,38195],[13574,13578,18886,18894,38153,38167],
 [13575,13577,13583,13584,18885,18889,18890,18892],
 [13576,13582,18884,18891],
 [13590,13595,13656,13739,13852,13914,13915,14027,14113,14142,
   18908,18915,18951,18958,19045,19235,19543,19544,19697,19698],
 [13591,13655,13737,13913,14225,14365,18910,18952,19027,19222,
   19542,19699],
 [13593,13677,13679,13687,13706,13711,13798,13960,13971,13979,
   15592,15784,18914,18957,19079,19082,19086,19101,19102,19299,
   19574,19580,20637,21017,23773,24058,25277,25539,42534,42536,
   42559,42565,42697,42703,43047,43049,43366,43368,44354,44356,
   45925,45958,45960,45984,46117,46119,46668,46670,47628,47630,
   48469,48471],
 [13597,13604,13640,13647,13717,13734,13872,13924,14232,14233,
   14386,14387,18901,18906,18964,18967,19047,19050,19163,19225,
   19226,19338,19424,19453],
 [13598,13642,13721,13835,14234,18919,18965,19049,19231,19394],
 [13599,13641,13716,13911,18966,19048,19224,19536],
 [13600,13606,13643,13649,13727,13732,13806,13811,13917,13922,
   13985,13991,14170,14173,14177,14197,14200,14204,18925,18926,
   18968,18970,19051,19053,19130,19131,19242,19243,19311,19312,
   19547,19548,19618,19620,19700,19701],
 [13603,13646,13733,13768,13771,13775,13812,13923,13988,18904,
   18950,18988,18990,18998,19033,19109,19271,19366],
 [13610,13815,19193,19196],
 [13611,13651,13730,13809,13817,13882,13885,13928,13993,13996,
   14086,14090,18921,18949,19036,19114,19126,19148,19156,19240,
   19309,19334,19431,19456],
 [13612,13613,13633,13634,13723,13724,13802,13804,13816,13818,
   13834,13848,13851,13874,13875,13980,14020,14026,14079,14080,
   14115,14116,14144,14149,14229,14275,14279,14301,14423,14439,
   18923,18924,19034,19035,19113,19115,19127,19129,19159,19162,
   19237,19238,19306,19308,19331,19337,19390,19391,19426,19427,
   19455,19460,19540,19586,19590,19612,19715,19716,19734,19750],
 [13614,13740,13742,13820,13931,14001,14237,14389,18917,18954,
   19038,19043,19302,19484,19508,19515],
 [13615,13659,13819,13932,14236,14307,18911,18960,19117,19233,
   19481,19511],
 [13616,13658,13999,14235,14308,14391,18912,19116,19227,19297,
   19538,19635],
 [13618,13622,13624,13625,13661,13665,13667,13668,13743,13749,
   13750,13751,13822,13828,13829,13830,13933,13939,13940,13941,
   14003,14007,14009,14010,14238,14239,14243,14244,14310,14311,
   14315,14316,14392,14393,14397,14398,18930,18932,18937,18938,
   18974,18975,18980,18982,19057,19058,19063,19065,19135,19137,
   19142,19143,19246,19247,19254,19255,19315,19316,19323,19324,
   19551,19552,19559,19560,19624,19625,19630,19632,19705,19707,
   19712,19713,39099,39113,39127,39141,40002,40025,40030,40044,
   40381,40382,40755,40756,41674,41706,41711,41725,42237,42238,
   42315,42317,43195,43218,43232,43246,44315,44317,45194,45217,
   45226,45245,45433,45440,45738,45739,46359,46373,46382,46401,
   49734,49743,49757,49766,49966,49967,50563,50572,50595,50600,
   51365,51374,51388,51402],
 [13619,13626,13663,13669,13747,13754,13826,13832,13935,13944,
   14005,14012,14241,14248,14313,14319,14394,14401,18929,18935,
   18976,18979,19060,19062,19133,19140,19244,19251,19314,19320,
   19549,19554,19622,19627,19703,19708],
 [13620,13628,13662,13670,13745,13753,13825,13833,13937,13942,
   14006,14011,14242,14247,14312,14320,14395,14403,18928,18934,
   18971,18977,19055,19059,19134,19138,19245,19249,19313,19319,
   19556,19557,19628,19629,19710,19711],
 [13621,13627,13664,13671,13746,13752,13824,13831,13936,13943,
   14004,14013,14240,14249,14314,14321,14396,14402,18933,18936,
   18972,18978,19054,19061,19139,19141,19250,19252,19318,19321,
   19550,19555,19621,19626,19704,19709],
 [13638,13725,13803,13837,13845,13929,13998,14023,14120,14145,
   18922,18962,19041,19120,19128,19239,19304,19307,19397,19401],
 [13639,13722,14055,14069,14077,19044,19123,19234,19665,19669],
 [13657,14309,19122,19228],[13675,13698,13949,19074,19565,19568]
  ,[13678,13681,13947,19080,19084,19564],
 [13680,13950,13964,19081,19085,19569],
 [13683,13684,13836,13838,13946,14110,19088,19089,19395,19396,
   19561,19733],[13695,19194],[13741,19037],
 [13756,13761,13764,13765,13846,14021,14118,14147,14259,14349,
   19004,19007,19008,19259,19266,19273,19274,19358,19365,19369],
 [13757,13763,14254,14277,19009,19260,19272,19360],
 [13762,14053,14057,19003,19269,19368],[13776,19184],
 [13777,13778,13887,13888,14084,14085,14250,14344,14422,18994,
   18995,19147,19149,19257,19371,19374,19421,19717],
 [13779,13850,14025,14114,14143,18993,19000,19270,19372,19373],
 [13780,13781,13782,14260,14261,14262,14350,14351,14352,18996,
   18997,19002,19262,19263,19268,19361,19362,19367],
 [13785,13786,13787,13792,13793,13794,14265,14266,14267,14272,
   14273,14274,19013,19014,19018,19019,19020,19021,19279,19280,
   19284,19285,19286,19287],[13795,13983,19293,19615],
 [13800,13984,14306,19124,19300,19616],
 [13821,13930,18955,19610],[13839,14048,19399,19658],
 [13840,13878,14152,19333,19402,19433],
 [13842,14016,14124,19400,19404,19592],
 [13843,14112,19406,19736],
 [13844,13849,14111,14117,19407,19408,19735,19737],
 [13847,14094,14119,14151,19158,19405,19430,19462],
 [13853,19202],[13854,19165],[13855,13893,19340,19677],
 [13856,19678],[13857,19517],[13858,14457,19490,19634],
 [13859,14456,19487,19637],
 [13860,13866,13867,13868,14035,14041,14042,14043,14129,14133,
   14135,14136,14158,14162,14164,14165,14458,14459,14463,14464,
   19411,19412,19419,19420,19600,19601,19608,19609,19686,19688,
   19693,19694,19741,19742,19747,19749,19757,19758,19763,19765,
   43898,43949,46878,46929,47862,47871,48283,48325,48689,48731,
   50333,50342,51217,51231,51686,51691,51806,51811,51879,51888],
 [13861,13865,14036,14040,14128,14134,14157,14163,19413,19418,
   19602,19607,19740,19748,19756,19764,43907,46887,47876,48274,
   48680,50347,51677,51797],
 [13862,14039,14130,14160,14461,19414,19605,19691,19743,19760],
 [13863,14132,14460,19415,19689,19745],
 [13864,14037,14131,14159,19416,19603,19744,19759],
 [13869,14167,14467,19599,19684,19738],
 [13870,14168,19606,19739],[13871,19746],
 [13876,14047,14054,14058,19429,19458,19657,19660],
 [13877,19432],[13879,14015,14123,19326,19434,19591],
 [13880,14082,14176,14199,14326,14327,19170,19345,19436,19465,
   19719,19767],
 [13881,14081,14276,14323,19437,19467,19718,19768,42562,43004,
   45917,45962,45992,46112,50456,50506],
 [13884,13891,14089,14093,14281,14368,19153,19164,19327,19342,
   19435,19461],
 [13886,14087,14172,14180,14203,14206,19168,19344,19438,19466,
   19720,19766],[13890,19201],[13894,19516],
 [13895,14442,19335,19489],[13896,14441,19329,19636],
 [13897,13903,14099,14103,14294,14295,14380,14381,14428,14432,
   14443,14449,19173,19181,19350,19355,19441,19449,19471,19479,
   19725,19730,19772,19780,43921,44564,46915,47848,48297,48712,
   50361,51245,51555,51663,51774,51911],
 [13899,14100,14377,14446,19353,19444,19726,19775],
 [13900,14102,14445,19351,19445,19728],
 [13901,14101,14298,14375,19446,19476,19727,19774],
 [13904,13905,14105,14106,14288,14292,14373,14379,14427,14433,
   14444,14448,19175,19180,19348,19356,19442,19450,19470,19478,
   19724,19732,19773,19778,43935,44615,46901,47890,48306,48703,
   50319,51194,51550,51654,51783,51916],
 [13906,13907,14431,14452,19177,19346,19721,19722],
 [13908,14107,14291,14384,14429,14453,19176,19347,19439,19474,
   19729,19777],[13961,19068],[14000,14390,19296,19488],
 [14014,14049,19588,19659],[14017,19593],
 [14018,14141,19595,19752],
 [14019,14024,14140,14146,19596,19597,19751,19753],
 [14022,14122,14148,19151,19463,19594],[14029,19166],
 [14030,19341],[14031,19679],[14032,19518],[14033,19491],
 [14034,19638],[14038,14161,19604,19761],
 [14044,14138,14469,19410,19692,19754],
 [14045,14139,19417,19755],[14046,19762],
 [14060,14063,14406,19198,19199,19655],
 [14064,14066,14471,19512,19513,19633],[14091,19189],
 [14095,19423],[14096,14097,14426,14440,19160,19330,19422,19428]
  ,[14108,14109,14289,14290,14382,14383,14430,14454,19178,19354,
   19440,19447,19473,19475,19769,19770],[14121,19188],
 [14125,19393],[14126,14156,19392,19587],
 [14127,14155,19398,19483],[14137,14166,14468,19409,19598,19685]
  ,[14150,19195],[14154,19510],[14178,14205,19205,19206],
 [14179,14207,19169,19343,42539,42713,48848,49200],
 [14181,14208,19681,19682],[14182,14184,19521,19641],
 [14183,19494],[14187,14195,14214,14342,19788,19797,19801,19809]
  ,[14188,14194,14216,14343,19789,19796,19803,19816],
 [14189,14196,14215,14341,19790,19802,19804,19808],
 [14209,14331,19520,19642],[14210,14330,19493,19495],
 [14211,14329,19522,19640],[14221,14335,19783,19815],
 [14222,14334,19784,19813],[14223,14336,19791,19814],
 [14231,18902],[14256,14346,18987,19187],
 [14257,14348,18986,19325],[14280,19190],[14282,19328],
 [14283,19459],[14284,19452],[14285,19451],[14286,19457],
 [14296,14437,19172,19468],[14297,14438,19179,19469],
 [14303,19107],[14325,19207],[14328,19683],
 [14355,14356,14357,14362,14363,14364,19378,19379,19383,19384,
   19385,19386],[14366,19204],[14367,19167],[14369,19680],
 [14370,19519],[14371,19492],[14372,19639],[14376,19776],
 [14385,19200],[14388,19676],[14407,19192],[14408,19191],
 [14409,19197],
 [14410,14411,14415,14416,19210,19212,19217,19218,44587,44601,
   51518,51527],[14412,19213],[14413,19215],[14414,19214],
 [14417,14418,19211,19219,44596,51569],[14419,19208],
 [14420,19209],[14421,19216],[14424,19155],[14425,19154],
 [14436,19171],[14447,19352],[14455,19514],[14462,19690],
 [14465,14466,19687,19695,51226,51930],
 [14472,14478,14504,14505,19527,19532,19646,19654,49446,50826,
   51970,52165],
 [14473,14477,14498,14502,19525,19533,19645,19653,49432,50817,
   51979,52123],
 [14474,14483,14489,14496,14501,14507,15600,19502,19504,19528,
   19531,19644,19649,20738,20847,20849,20957,24050,25280,25400,
   25549,25583],
 [14475,14488,14494,14506,19496,19503,19530,19643],
 [14476,14481,14487,14495,14500,14508,19497,19501,19523,19529,
   19650,19651],
 [14479,14480,14485,14491,14492,14493,14497,14503,19499,19500,
   19505,19507,19526,19534,19647,19652,49090,49095,49441,50831,
   52021,52048,52099,52114],[14482,14499,19524,19648],
 [14486,14490,19498,19506,49081,52057],
 [14510,14511,14519,14520,14522,14528,14529,14532,14533,14541,
   14547,14549,14550,14558,14559,14564,14566,14567,14569,14570,
   19822,19830,19831,19832,19839,19840,19843,19844,19846,19852,
   19858,19860,19861,19868,19869,19874,19875,19877,19880,19881,
   52188,52196,52201,52219,52232,52237,52246,52247,52258,52259,
   52294,52299,52306,52328,52342,52350,52351,52354,52385,52386],
 [14512,14518,14521,14527,14534,14535,14540,14548,14557,14563,
   14568,14571,19821,19829,19833,19838,19845,19851,19854,19859,
   19870,19873,19878,19882,52192,52203,52218,52240,52251,52257,
   52301,52303,52323,52335,52347,52387],
 [14517,14542,14543,14562,19823,19828,19853,19879,52206,52217,
   52329,52332],
 [14536,14538,14544,14545,14552,14553,19824,19826,19835,19836,
   19867,19872],[14754,21546],[14755,21543],[14756,21547],
 [14757,21541],[14758,21544],[14760,21540],[14761,21542],
 [14770,21577],[14771,21576],[14775,21578],[14777,21564],
 [14778,21563],[14779,21570],[14784,21565],[14788,21579],
 [14790,14793,21557,21574],[14791,14792,21556,21561],
 [14810,14816],[14811,14813],[14812,14817],[14814],
 [14815,14818],[14819],[14820,14838,20009,20027],
 [14821,14828,20014,20030],[14822,14839,20013,20018],
 [14823,20012],[14824,14829,20011,20028],
 [14825,14841,20010,20017],[14826,14847],[14827,14846],
 [14830,20034],[14831,14848],[14832,14843,20021,20032],
 [14833,14834],[14835,14840],[14836,14851,20025,20040],
 [14837,14850,20031,20041],[14842,14852,20026,20039],
 [14844,14849],[14845,20019],[14853,14862,20045,20049],
 [14854,14863,20044,20047],[14855,14858,20043,20052],
 [14856,14860,20042,20051],[14857,14859,20050,20053],
 [14861,14864,20046,20048],[14865,19950],[14866,19947],
 [14867,19951],[14868,14871,19944,19945],[14869,19948],
 [14870,19952],[14872,19946],[14873,19949],[14874,19953],
 [14875,19972],[14876,14880,19962,19975],
 [14877,14879,19963,19973],[14878,14893,19954,19957],
 [14881,19981],[14882,14890,19974,19980],
 [14883,14896,19955,19959],[14884,14894,19956,19958],
 [14885,14900,19964,19979],[14886,19982],
 [14887,14898,19966,19977],[14888,19968],[14889,19967],
 [14891,14906,19970,19985],[14892,14907,19976,19984],
 [14895,19969],[14897,14905,19971,19986],[14899,19983],
 [14901,14902,19960,19961],[14903,19965],[14904,19978],
 [14908,14911,19994,19996],[14909,14910,19992,19997],
 [14912,14916,19993,19998],
 [14913,14915,14917,14918,19987,19988,19989,19990],
 [14914,14919,19991,19995],
 [14920,14921,14974,14975,14976,15079,23245,23246,23349,23351,
   23352,23499],[14922,20059,23248,24680],
 [14923,14924,15027,15029,15080,15130,23249,23250,23401,23403,
   23500,23547],[14925,20056,20112,23195,24677,24733],
 [14926,20060,20164,23300,24681,24785],
 [14927,14928,15324,23450,23453,23501],
 [14929,15093,20064,20384,23253,23520,24684,24995],
 [14930,15088,20063,23255,23510,25005],
 [14931,15094,20065,23256,23521,25006],
 [14932,15086,20366,23260,23505,24702],
 [14933,15089,23261,23511],[14934,15095,23262,23523],
 [14935,15099,23265,23529],[14936,15098,20386,23266,23528,24699]
  ,[14937,15085,20081,20367,23270,23503,24692,24987],
 [14938,15087,20368,23271,23506,24703],
 [14939,15090,23273,23512],[14940,15100,20089,23272,23530,24994]
  ,[14941,15097,23275,23525],
 [14942,15092,20083,23278,23516,25002],
 [14943,15091,23279,23515],[14944,15096,20392,23280,23522,24691]
  ,[14945,15102,20085,23282,23533,25019],
 [14946,15101,20388,23283,23532,24716],
 [14947,20071,20369,23502,24687,24988],
 [14948,20082,20370,23504,24693,24989],
 [14949,20076,23517,25001],[14950,20371,23507,24705],
 [14951,20079,23534,25018],[14952,23514],
 [14953,20090,23531,24993],[14954,23527],
 [14955,20074,20372,23509,24711,25015],
 [14956,20087,20373,23508,24710,25016],[14957,23513],
 [14958,23526],[14959,23519],[14960,23518],
 [14961,20396,23524,24701],
 [14962,15123,20096,20406,23287,23544,24720,25029],
 [14963,15124,23289,23545],[14964,15120,23290,23540],
 [14965,15122,20408,23291,23542,24717],
 [14966,15121,20105,23292,23541,25020],
 [14967,15118,20103,20399,23294,23537,24726,25023],
 [14968,15119,23295,23539],[14969,20101,20400,23538,24727,25022]
  ,[14970,23546],[14971,20100,20401,23535,24722,25026],
 [14972,20402,23536,24724],[14973,23543],[14977,23353],
 [14978,23192],[14979,14980,15277,23297,23299,23350],
 [14981,23354],[14982,14990,23356,23373],
 [14983,14985,23358,23363],[14984,14991,23359,23374],
 [14986,23364],[14987,14992,23365,23376],
 [14988,14996,23368,23382],[14989,14995,23369,23381],
 [14993,14997,23375,23383],[14994,23378],
 [14998,14999,23385,23386],[15000,23355],[15001,23357],
 [15002,23370],[15003,23360],[15004,23387],[15005,23367],
 [15006,23384],[15007,23380],[15008,23362],[15009,23361],
 [15010,23366],[15011,23379],[15012,23372],[15013,23371],
 [15014,23377],[15015,15020,23390,23397],
 [15016,15021,23392,23398],[15017,23393],
 [15018,15019,23394,23395],[15022,23391],[15023,23399],
 [15024,23388],[15025,15226,23389,23628],[15026,23396],
 [15028,23402],[15030,23196],[15032,23451],
 [15034,15143,23406,23567],[15035,15138,23408,23557],
 [15036,15043,15137,15144,23409,23424,23553,23568],
 [15037,15136,23413,23552],
 [15038,15053,15139,15154,23407,23414,23551,23558],
 [15039,15145,23415,23570],[15040,15149,23418,23576],
 [15041,15148,23419,23575],[15042,15135,23423,23550],
 [15044,15140,23426,23559],[15045,15150,23425,23577],
 [15046,15147,23428,23572],[15047,15142,23431,23563],
 [15048,15141,23432,23562],[15049,15146,23433,23569],
 [15050,15152,23435,23580],[15051,15151,23436,23579],
 [15052,23549],[15054,23564],[15055,23554],[15056,23581],
 [15057,15158,23417,23561],[15058,23578],[15059,23574],
 [15060,23556],[15061,23555],[15062,23560],[15063,23573],
 [15064,23566],[15065,23565],[15066,23571],
 [15067,15173,23440,23591],[15068,15174,23442,23592],
 [15069,15170,23443,23587],[15070,15172,23444,23589],
 [15071,15171,23445,23588],[15072,15168,23447,23584],
 [15073,15169,23448,23586],[15074,23585],[15075,23593],
 [15076,23582],[15077,23583],[15078,23590],
 [15081,15082,15229,20054,20055,20108,20215,20216,20363,23190,
   23191,23244,24675,24676,24729,24836,24837,24984],
 [15083,23247],[15084,23251],
 [15103,20066,20374,23252,24685,24990],
 [15104,20067,20385,23254,24686,24996],
 [15105,20379,23267,24698],[15106,20068,23257,25008],
 [15107,20382,23284,24715],[15108,23264],
 [15109,20393,23281,24690],[15110,23277],
 [15111,20069,20377,23259,24712,25014],
 [15112,20070,20390,23258,24713,25013],[15113,23263],
 [15114,23276],[15115,23269],[15116,23268],
 [15117,20093,23274,25004],[15125,20097,20404,23288,24719,25030]
  ,[15126,23296],[15127,20098,20403,23285,24723,25025],
 [15128,20099,23286,25027],[15129,23293],
 [15131,15133,15230,23193,23194,23400],[15132,23298],
 [15134,23404],[15153,23405],[15155,23420],[15156,23410],
 [15157,23437],[15159,23434],[15160,23430],[15161,23412],
 [15162,23411],[15163,23416],[15164,23429],[15165,23422],
 [15166,23421],[15167,23427],[15175,23441],[15176,23449],
 [15177,23438],[15178,23439],[15179,23446],
 [15180,15183,15231,23197,23198,23594],[15181,23302],
 [15182,23452],[15184,15192,23596,23613],
 [15185,15187,23598,23603],[15186,15193,23599,23614],
 [15188,23604],[15189,15194,23605,23616],
 [15190,15198,23608,23622],[15191,15197,23609,23621],
 [15195,15199,23615,23623],[15196,23618],
 [15200,15201,23625,23626],[15202,23595],[15203,23597],
 [15204,23610],[15205,23600],[15206,23627],[15207,23607],
 [15208,23624],[15209,23620],[15210,23602],[15211,23601],
 [15212,23606],[15213,23619],[15214,23612],[15215,23611],
 [15216,23617],[15217,15222,23630,23637],
 [15218,15223,23632,23638],[15219,23633],
 [15220,15221,23634,23635],[15224,23631],[15225,23639],
 [15227,23629],[15228,23636],
 [15232,20134,20220,23217,24745,24840],
 [15233,20219,23207,24755],[15234,20221,23218,24756],
 [15235,20116,23202,24858],[15236,23208],[15237,23220],
 [15238,23226],[15239,20136,23225,24855],
 [15240,20117,20237,23200,24737,24848],
 [15241,20118,23203,24859],[15242,23209],
 [15243,20245,23227,24744],[15244,23222],
 [15245,20239,23213,24752],[15246,23212],
 [15247,20142,23219,24847],[15248,20241,23230,24769],
 [15249,20138,23229,24872],[15250,20119,20227,23199,24738,24843]
  ,[15251,20120,20238,23201,24739,24849],
 [15252,20232,23214,24751],[15253,20121,23204,24861],
 [15254,20235,23231,24768],[15255,23211],
 [15256,20246,23228,24743],[15257,23224],
 [15258,20122,20230,23206,24765,24867],
 [15259,20123,20243,23205,24766,24866],[15260,23210],
 [15261,23223],[15262,23216],[15263,23215],
 [15264,20146,23221,24857],[15265,20156,20252,23241,24779,24876]
  ,[15266,23242],[15267,23237],[15268,20158,23239,24873],
 [15269,20261,23238,24770],[15270,20149,20259,23234,24773,24882]
  ,[15271,23236],[15272,20150,20257,23235,24772,24883],
 [15273,23243],[15274,20151,20256,23232,24776,24878],
 [15275,20152,23233,24880],[15276,23240],
 [15279,20186,20414,23322,24797,25034],
 [15280,20413,23312,24807],
 [15281,15288,20170,20177,20415,20422,23308,23323,24793,24808,
   25038,25053],[15282,20168,23307,25052],
 [15283,15298,20172,20187,20417,20432,23306,23313,24791,24798,
   25036,25043],[15284,23325],[15285,23331],
 [15286,20188,23330,25049],[15287,20169,20431,23305,24789,25042]
  ,[15289,23314],[15290,20439,23332,24796],
 [15291,20180,20425,23327,24812,25057],
 [15292,20433,23318,24804],[15293,23317],
 [15294,20194,23324,25041],[15295,20435,23335,24821],
 [15296,20190,23334,25066],[15297,20171,20421,23304,24790,25037]
  ,[15299,20426,23319,24803],[15300,20173,23309,25055],
 [15301,20429,23336,24820],[15302,20191,20436,23316,24801,25046]
  ,[15303,20440,23333,24795],[15304,23329],
 [15305,20174,20424,23311,24817,25061],
 [15306,20175,20437,23310,24818,25060],[15307,23315],
 [15308,23328],[15309,23321],[15310,23320],
 [15311,20198,23326,25051],[15312,20208,20446,23346,24831,25070]
  ,[15313,23347],[15314,23342],[15315,20210,23344,25067],
 [15316,20455,23343,24822],[15317,20201,20453,23339,24825,25076]
  ,[15318,23341],[15319,20202,20451,23340,24824,25077],
 [15320,23348],[15321,20203,20450,23337,24828,25072],
 [15322,20204,23338,25074],[15323,23345],[15325,23472],
 [15326,23462],[15327,23473],[15328,23457],[15329,23463],
 [15330,23475],[15331,23481],[15332,15338,23468,23480],
 [15333,23455],[15334,23458],[15335,23464],[15336,23482],
 [15337,23477],[15339,23467],[15340,23474],[15341,23485],
 [15342,23484],[15343,23454],[15344,23456],[15345,23469],
 [15346,23459],[15347,23486],[15348,23466],[15349,23483],
 [15350,23479],[15351,23461],[15352,23460],[15353,23465],
 [15354,23478],[15355,23471],[15356,23470],[15357,23476],
 [15358,23496],[15359,23497],[15360,23492],[15361,23494],
 [15362,23493],[15363,23489],[15364,23491],[15365,23490],
 [15366,23498],[15367,23487],[15368,23488],[15369,23495],
 [15370,23658],[15371,23648],[15372,15379,23644,23659],
 [15373,23643],[15374,15389,23642,23649],[15375,23661],
 [15376,23667],[15377,23666],[15378,23641],[15380,23650],
 [15381,23668],[15382,23663],[15383,23654],[15384,23653],
 [15385,23660],[15386,23671],[15387,23670],[15388,23640],
 [15390,23655],[15391,23645],[15392,23672],[15393,23652],
 [15394,23669],[15395,23665],[15396,23647],[15397,23646],
 [15398,23651],[15399,23664],[15400,23657],[15401,23656],
 [15402,23662],[15403,23682],[15404,23683],[15405,23678],
 [15406,23680],[15407,23679],[15408,23675],[15409,23677],
 [15410,23676],[15411,23684],
 [15412,15413,15414,23673,23674,23681],
 [15415,15416,15424,15426,15459,15520,15524,15548,15549,15627,
   15631,15739,15742,15783,15786,15811,16056,16132,20549,20550,
   20593,20600,20601,20636,20638,20679,20761,20765,20876,20909,
   20917,20920,21016,21023,21190,21194,23688,23689,23730,23731,
   23748,23750,23814,23855,23908,23914,24018,24019,24087,24092,
   24324,24328,24355,24400,25173,25174,25192,25194,25233,25235,
   25314,25316,25340,25343,25345,25495,25503,25504,25809,25836,
   25885,25930],
 [15417,15432,15465,15640,15755,15820,20566,20599,20616,20692,
   20763,20774,23702,23735,23752,23828,23899,23910,25172,25187,
   25220,25395,25510,25575],
 [15418,15419,15559,15561,15585,15588,15590,15740,15748,15749,
   16054,16081,20552,20553,20594,20595,20678,20719,20772,20778,
   20882,20883,21188,21219,23685,23686,23729,23736,23737,23772,
   23774,23815,24045,24053,24056,24326,25170,25171,25214,25275,
   25279,25303,25304,25494,25538,25541,25811,25887],
 [15420,15744,23740,24332],[15421,15743,21189,23741,24331,25184]
  ,[15423,15507,15885,20603,20651,20762,23746,23868,23912,25188,
   25356,25508],[15425,15745,20617,23747,24333,25457],
 [15427,15702,20611,23753,24213,25500],
 [15428,15665,23754,24183],[15429,15741,21195,23755,24325,25176]
  ,[15430,15747,15752,16030,20613,20770,20775,21134,23757,23759,
   23919,24336,25200,25517,25892,25894],
 [15431,15746,20769,21191,23758,24335,25201,25893],
 [15433,15601,20610,20732,23787,23898,25178,25262],
 [15434,20604,24242,25499],
 [15436,16003,20607,21161,23920,24337,25199,25516],
 [15437,15439,15478,15480,16130,16175,20612,20614,20951,20956,
   21192,21264,23897,23901,24012,24152,24159,24330,25179,25181,
   25382,25386,25497,25566],[15438,20618,24334,25420],
 [15440,20602,20809,23982,25196,25513],
 [15441,20615,20846,23945,25195,25514],
 [15442,15443,16269,24120,24126,24329],
 [15444,21201,24297,25191],[15445,21200,24270,25185],
 [15446,21199,24327,25186],
 [15447,15768,16147,20624,20787,21209,23762,23925,24347,25205,
   25527,25905],
 [15448,15769,15770,16145,20625,20786,20794,21207,23763,23764,
   23924,24348,25204,25528,25904,25906],
 [15449,15765,20796,21212,23765,24343,25203,25896],
 [15450,15767,20797,21211,23766,24345,25202,25903],
 [15451,15766,16143,20633,20795,21213,23767,23929,24344,25210,
   25518,25895],
 [15452,15454,15763,16140,16141,20629,20631,20793,21202,21203,
   23769,23931,23932,24340,24341,25211,25212,25520,25521,25898],
 [15453,15764,16148,20630,20791,21210,23770,23933,24342,25213,
   25522,25897],
 [15455,16146,20632,21208,23926,24349,25206,25529],
 [15456,15457,16151,20628,21204,21205,23930,24338,24339,25207,
   25209,25524],
 [15458,15772,16150,20626,20789,21206,23760,23923,24346,25208,
   25523,25902],
 [15460,15461,15544,15638,15644,16085,20693,20695,20722,20724,
   20874,21215,23790,23794,23818,23819,24009,24402,25221,25222,
   25257,25259,25300,25530],
 [15466,15467,15502,15504,15545,15775,15882,15889,16060,20558,
   20560,20654,20658,20682,20683,20873,20945,21266,23707,23709,
   23829,23831,23858,23860,24010,24351,24445,25215,25216,25299,
   25393,25399,25572,25577,25813,25840,40451,40457,40480,40486,
   42364,42366,42380,42382,43336,43341,43403,43408,44400,44401,
   44420,44421,45294,45299,47038,47041,47065,47068,47586,47587,
   47610,47611,47900,47906,48950,49301,49805,49806,50860,50861,
   51580,51582],[15468,15555,20574,23830,24028,25467],
 [15469,15509,15517,15552,15628,15790,20557,20641,20643,20686,
   20924,21019,23703,23833,23871,23875,24023,24088,25231,25318,
   25353,25360,25397,25573,40359,40364,40518,40545,42225,42226,
   42310,42311,43435,43440,44310,44311,45415,45421,45456,45483,
   46971,46977,47676,47677,49960,49962,50914,50916],
 [15470,15547,20568,23836,24014,25727],
 [15471,15546,23837,24013],[15472,15551,23838,24020],
 [15473,15557,16027,20570,20696,21137,23714,23840,24031,25327,
   25405,25822],
 [15474,15556,20690,21263,23841,24030,25326,25406],
 [15479,16000,20564,21164,23715,24032,25404,25821],
 [15481,20575,24029,25430],[15482,20954,24025,25384],
 [15483,15569,20559,20816,23834,23972,25818,25971],
 [15484,20572,20853,23935,25819,25970],[15485,24011],
 [15486,24024],[15487,21273,24017,25396],
 [15488,21272,24016,25390],[15489,21271,24022,25391],
 [15490,15578,15653,15838,16075,16229,20581,20708,20902,20966,
   21281,21364,23720,23845,24042,24106,24420,24495,25247,25338,
   25410,25596,25832,25988],
 [15491,15579,15660,16227,20715,20903,20967,21279,23847,24043,
   24421,24494,25249,25339,25409,25597],
 [15492,15575,20717,21284,23848,24038,25329,25408],
 [15493,15577,20718,21283,23849,24040,25336,25407],
 [15494,15576,16071,20590,20716,21285,23724,23850,24039,25328,
   25415,25823],
 [15495,15573,15659,16068,16223,20588,20714,20897,20971,21275,
   23726,23852,24035,24413,24502,25254,25331,25417,25589,25826],
 [15496,15574,15657,15832,16230,20712,20898,20972,21282,21363,
   23853,24037,24111,24412,24503,25255,25330,25418,25591,25980],
 [15497,16069,16222,20586,20973,21274,23727,24036,24501,25416,
   25590,25825],
 [15498,16228,20974,21280,24044,24496,25411,25598],
 [15499,15584,15662,15842,16079,16231,20585,20711,20899,20969,
   21277,21358,23725,23851,24033,24103,24411,24492,25250,25334,
   25414,25594,25829,25982],
 [15500,16233,20970,21276,24034,24500,25412,25593],
 [15501,15582,15661,15843,16078,16232,20583,20710,20900,20968,
   21278,21360,23718,23843,24041,24110,24410,24493,25252,25335,
   25413,25592,25828,25983],[15505,15779,23863,24357],
 [15506,15523,15778,20660,21018,23864,24356,24359,25431,25732],
 [15508,15511,15777,20642,20645,20911,23869,23873,24353,25354,
   25358,25838,40291,40292,40297,40390,40391,40396,42200,42201,
   42202,42290,42291,42292,45325,45326,45331,49870,49871,49872],
 [15510,15780,20659,23870,24358,25468],
 [15512,15527,15703,15706,15877,20653,20919,23876,24121,24214,
   24218,24446,25350,25728],
 [15513,15514,15666,15668,15776,15940,23877,23878,24184,24185,
   24350,24522],
 [15515,15782,20655,20915,23880,24361,25366,25847],
 [15516,15521,15781,20649,20916,20921,23881,24360,24362,25365,
   25367,25846],[15519,20646,24243,25699],
 [15522,20922,24153,25347],
 [15525,15669,15794,15878,20644,20803,20914,20928,23874,23983,
   24188,24447,25355,25359,25843,25932],[15528,24354],
 [15529,20931,24298,25357],
 [15530,15531,16314,20929,20930,21434,24271,24274,24352,25351,
   25352,25754],
 [15532,15538,15539,15799,15803,15805,20666,20667,20671,20932,
   20939,20940,23885,23886,23893,24366,24367,24372,25371,25377,
   25379,25850,25857,25858],
 [15533,15537,15798,15804,20673,20674,20933,20937,23887,23892,
   24365,24373,25370,25378,25851,25859],
 [15534,15535,15800,15802,16360,16361,20676,20677,20941,20942,
   21536,21538,23888,23889,24368,24370,24654,24655,25368,25369,
   25849,25856,26094,26111,38220,38262,38358,38397,39165,39220,
   39260,39431,39465,40066,40145,40639,40664,40941,40965,41076,
   41111,41421,41468,41761,41870,41939,42943,43072,44631,44679,
   44915,44940,45261,45502,45574,49480,49519,49828,49911,50373],
 [15536,15801,20675,20943,23890,24369,25376,25848,38528,38838,
   39740,40256,40326,40567,42175,42248,42331,42632,45599,46096],
 [15540,20938,24374,25372],
 [15541,15809,15907,20670,20935,21033,23891,24363,24454,25375,
   25854,25943],
 [15542,15543,15807,15808,15906,15908,16402,16403,16404,20668,
   20669,20934,20936,21034,21035,21494,21495,21503,23883,23884,
   24364,24371,24453,24461,24609,24616,24626,25373,25374,25853,
   25855,25944,25945,26139,26140,26145],
 [15558,15629,20551,20889,23687,24090,25237,25313],
 [15560,23825],[15562,20691,23842,25325],
 [15563,15642,20697,20887,23822,24155,25224,25307],
 [15564,15643,15785,15819,20661,20946,21011,21268,21350,21351,
   23839,23865,24084,24406,25380,25437,25568,25606,25612,25703],
 [15566,20554,20991,23817,25817,25972],
 [15567,20555,21329,23816,25816,25973],
 [15568,15647,23821,24123],[15570,20706,23827,25317],
 [15571,20705,23826,25311],
 [15572,16067,20578,20704,23706,23832,25312,25782],
 [15580,15652,15837,16073,20582,20707,20904,21357,23719,23846,
   24104,24419,25248,25337,25833,25987],
 [15581,15658,15833,20713,20905,21361,23854,24112,24414,25256,
   25332,25979],
 [15583,15663,16077,20584,20709,20901,23717,23844,24418,25251,
   25333,25830],[15587,15593,24049,24061],
 [15591,15595,24055,24063],
 [15596,15597,15999,16001,16004,16082,20730,20731,21133,21135,
   21138,21216,23800,23801,24065,24066,24570,24584,25285,25286,
   25550,25551,26055,26069],[15602,21162,24067,25284],
 [15604,16088,23780,24064],[15606,15609,23973,24059],
 [15610,21226,24052,25276],[15611,21225,24051,25270],
 [15612,21224,24057,25271],
 [15613,15614,15618,15619,16094,16098,16100,16101,16339,16356,
   16384,16385,20747,20748,20752,20753,21228,21232,21234,21235,
   21473,21490,21518,21519,23804,23805,23812,23813,24070,24072,
   24077,24078,24630,24631,24672,24674,25289,25290,25297,25298,
   25555,25557,25562,25563,26115,26116,26157,26159],
 [15615,21237,24073,25288],
 [15616,15617,16097,20758,21236,21238,23808,24074,24075,25287,
   25295,25561],
 [15620,16093,20754,21227,23811,24071,25296,25556],
 [15621,16099,20755,21233,23806,24079,25291,25564],
 [15622,21230,24068,25294],
 [15623,16104,20751,21229,23810,24069,25292,25559],
 [15624,16102,16103,20749,20750,21231,23802,23803,24076,25293,
   25558,25560],
 [15625,15813,20948,21270,24082,24404,25398,25574],
 [15626,15812,20953,21269,24083,24403,25385,25569],
 [15630,15814,24089,24405],
 [15632,15634,15704,15705,15810,15910,24095,24097,24215,24216,
   24375,24505],
 [15633,15667,20962,21109,24096,24186,25394,25578],
 [15635,15816,16057,20565,20880,21288,23716,24099,24408,25243,
   25820,25976],
 [15636,15815,20886,21141,24100,24407,25244,25975],
 [15639,21050,24245,25388,43481,43711,44175,44231,46563,46790,
   47530,48086,48342,48606,50252,51088],
 [15641,20881,24409,25242],
 [15645,15828,20801,20987,23985,24093,25402,25581],
 [15646,15648,16253,20812,20815,20838,20839,20944,21265,23948,
   23951,24401,25401,25403,25580,25582,25990,26008],
 [15649,20896,24300,25234],[15650,20895,24273,25228],
 [15651,20894,24399,25229],
 [15654,15834,20907,21366,24107,24415,25246,25978],
 [15655,15836,16072,20592,20906,21367,23723,24108,24417,25245,
   25831,25985],
 [15656,15835,20908,21365,24109,24416,25253,25977],
 [15670,15708,21247,24191,24222,25733],
 [15672,15846,24193,24381],[15673,15942,24195,24525],
 [15674,15941,24196,24524],[15675,23711],[15676,23796],
 [15677,24251],[15678,15681,16131,23916,23918,24523],
 [15679,24526],[15680,24161],[15682,24486],[15683,23991],
 [15684,23954],[15685,24129],[15686,24467],[15687,24306],
 [15688,24279],[15689,24426],[15690,15963,24200,24536],
 [15691,15964,24202,24537],[15692,15960,24203,24532],
 [15693,15962,24204,24534],[15694,15961,24205,24533],
 [15695,15958,24207,24529],[15696,15959,24208,24531],
 [15697,24530],[15698,24538],
 [15699,15701,15967,15969,21123,21125,21424,21426,24198,24206,
   24527,24535,25877,25878,25963,25964],[15700,24528],
 [15707,24221],[15709,15845,21244,24223,24380,25464],
 [15710,15912,24225,24508],[15711,15911,21240,24226,24507,25741]
  ,[15712,15920,20694,23710,24220,25310],
 [15713,20734,23795,25535],[15714,24250],
 [15715,20773,23915,25730],[15716,24509],
 [15717,15718,16174,24160,24163,24506],
 [15719,15913,20884,23698,24485,25227],
 [15720,15924,20811,23990,24219,25736],
 [15721,20848,23953,25735],[15723,15921,20986,23978,24466,25737]
  ,[15724,24305],[15725,24278],[15726,21248,24425,25726],
 [15727,15933,21258,24230,24519,25745],
 [15728,15934,24232,24520],[15729,15930,24233,24515],
 [15730,15932,21260,24234,24517,25742],
 [15731,15931,24235,24516],[15732,15928,21251,24237,24512,25751]
  ,[15733,15929,24238,24514],[15734,21252,24513,25752],
 [15735,24521],[15736,21253,24510,25747],
 [15737,15938,21254,24229,24511,25749],
 [15738,15937,21255,24228,24518,25748],
 [15750,21047,23742,25183],[15753,20776,23739,25640],
 [15754,21196,23756,25175],
 [15756,15757,16234,20597,20598,20798,20984,20990,21193,23733,
   23734,23934,25197,25198,25511,25512,25989,26024],
 [15758,23738],[15759,23751],[15760,20785,23744,25884],
 [15761,20784,23743,25758],
 [15762,16139,20621,20783,23749,23911,25502,25785],
 [15771,20792,23771,25899],
 [15773,16149,20627,20788,23761,23922,25525,25900],
 [15774,20790,23768,25901],[15787,20650,23882,25845],
 [15788,15887,20656,21021,23862,24157,25638,25642],
 [15789,15793,15888,15892,20926,21025,23861,23879,24125,24449,
   25341,25435,42525,42530,42575,42576,42700,42705,43051,43052,
   45932,45933,45947,45953,45976,45982,46121,46122,48847,48850,
   49198,49201,50473,50475,50489,50491],
 [15791,20639,20978,23857,25842,25933],
 [15792,16134,20640,20760,20777,21022,23856,23895,25841,25888,
   25891,25934],
 [15795,15796,16300,20664,20665,21448,23866,23867,24269,25756,
   25759,25837],[15797,20663,23872,25783],
 [15806,20672,23894,25852],
 [15817,15822,16058,20571,20573,21309,23694,23696,24081,25637,
   25644,25815],[15821,21168,24101,25974],
 [15823,20960,24098,25422],
 [15826,16177,21052,21054,23937,23939,25633,25705],
 [15829,21355,24086,25909],[15830,21354,24085,25762],
 [15831,21353,24091,25789],[15839,21356,24105,25986],
 [15840,21362,24113,25981],[15841,21359,24102,25984],
 [15844,15879,24377,24448],[15847,24382],
 [15848,15971,21289,24384,24541,25481],
 [15849,15970,24385,24540],
 [15850,15856,16059,20890,20891,21368,23712,23713,24539,25218,
   25219,25419],[15851,21220,23797,25261],
 [15852,21055,24252,25463],[15853,23917],
 [15854,21142,24542,25480],[15855,24162],[15857,24487],
 [15859,21330,23955,25478],[15860,24130],[15861,24468],
 [15862,24307],[15863,24280],[15864,24427],
 [15865,15992,21374,24389,24552,25491],
 [15866,15993,24391,24553],[15867,15989,24392,24548],
 [15868,15991,24393,24550],[15869,15990,21383,24394,24549,25482]
  ,[15870,15987,21381,24396,24545,25485],
 [15871,15988,24397,24547],[15872,21379,24546,25484],
 [15873,24554],[15874,21378,24543,25488],[15875,24544],
 [15876,24551],[15880,15881,21014,21020,24450,24451,25936,25937]
  ,[15886,21015,24452,25935],
 [15890,15893,16236,20800,20802,20910,23987,23988,24444,25362,
   25363,26007],
 [15894,15896,16301,21028,21030,21435,24301,24302,24422,25786,
   25787,25907],[15895,21029,24275,25760],
 [15897,15902,21032,21038,24455,24462,25941,25948],
 [15898,15903,21036,21039,24457,24463,25940,25949],
 [15899,21041,24458,25939,39530,41210,41511,43033,45030,47159],
 [15900,15901,16369,21040,21042,21537,24459,24460,24660,25938,
   25946,26101,38562,38627,38928,38967,39787,39830,42597,42731,
   44730,45887,46071,46186,47087,47184,49544,49570,50400,50881],
 [15904,21031,24456,25947],[15905,21037,24464,25942],
 [15914,15915,16080,21048,21049,21214,23783,23784,24210,25268,
   25269,25695],[15916,23903],[15917,21136,24227,25740],
 [15918,24148],[15919,21245,24224,25427],[15923,24116],
 [15925,24212],[15926,24211],[15927,24217],
 [15935,21256,24231,25744],[15936,24239],[15939,24236],
 [15943,23697],
 [15944,20743,21107,23782,25274,25544,43538,43793,44222,44376,
   46491,46820,47528,47652,48215,48574,48912,49176],
 [15945,15946,16105,23902,23904,24180],[15947,24197],
 [15948,24147],[15949,24194],[15950,24190],[15951,23977],
 [15952,23940],[15953,24115],[15954,24189],[15955,24182],
 [15956,24181],[15957,24187],[15965,24201],[15966,24209],
 [15968,24199],[15972,20700,23704,25302],
 [15973,20740,23789,25458],[15974,15979,16109,24244,24249,24379]
  ,[15975,20779,23909,25470],[15976,24386],[15977,24154],
 [15978,24383],[15980,20817,23984,25476],
 [15981,20854,23947,25475],[15982,24122],[15984,24299],
 [15985,24272],[15986,21371,24376,25466],
 [15994,21375,24390,25492],[15995,24398],
 [15996,21376,24387,25487],[15997,21377,24388,25489],
 [15998,24395],[16002,21051,24255,25712],
 [16005,21139,24165,25650],[16006,21290,24556,25444],
 [16007,20949,24490,25585],[16008,20988,23995,26027],
 [16009,21287,23958,26042],[16010,24133],[16011,24471],
 [16012,21148,24310,25915],[16013,21147,24283,25768],
 [16014,21146,24430,25795],
 [16015,16047,16049,16167,21156,21177,21296,21297,24574,24575,
   24594,24599,26067,26073,26091,26092],
 [16016,16048,16169,21154,21176,21304,24576,24595,24600,26066,
   26072,26093],
 [16017,16044,21159,21306,24577,24590,26071,26083],
 [16018,16046,16166,21158,21187,21307,24578,24592,24603,26065,
   26070,26090],
 [16019,16020,16042,16045,21150,21160,21303,21305,24579,24581,
   24587,24591,26078,26080,26082,26085],
 [16021,16022,16043,21149,21157,21301,24582,24588,24589,26079,
   26081,26084],[16023,21155,24596,26074],
 [16024,16053,21152,21300,24580,24585,26077,26088],
 [16025,21151,24586,26075],
 [16026,16171,21153,21179,24593,24597,26064,26076],
 [16028,20736,23799,25552],[16029,24254],
 [16031,16032,16152,21165,21166,21286,24164,24166,24571,25649,
   25651,26056],[16033,24555],[16034,20955,24489,25586],
 [16035,20813,23994,26011],[16036,20850,23957,25994],
 [16037,24132],[16038,24470],[16039,21295,24309,25916],
 [16040,21294,24282,25769],[16041,21293,24429,25796],
 [16050,21302,24583,26086],
 [16051,16052,21298,21299,24572,24573,26087,26089],
 [16055,20877,23699,25226],[16061,20680,20875,23691,25240,25322]
  ,[16064,16215,20685,20799,23708,23989,25239,25323],
 [16065,20580,23701,25812],[16066,20579,23700,25755],
 [16070,20591,23722,25824],[16074,20589,23721,25834],
 [16076,20587,23728,25827],[16084,21221,23798,25260],
 [16086,20720,20985,23776,25282,25547],
 [16087,20721,21218,23775,25283,25546],
 [16090,20746,23786,25542],[16091,20745,23785,25536],
 [16092,20744,23791,25537],[16095,20757,23807,25554],
 [16096,20756,23809,25553],[16106,21045,24256,25711],
 [16107,24149],[16110,20979,23979,25708],
 [16111,21053,23942,25709],[16112,24117],[16113,24248],
 [16114,24241],[16115,24240],[16116,24246],
 [16117,21062,24266,25722],[16118,24267],[16119,24262],
 [16120,24264],[16121,21071,24263,25713],
 [16122,21069,24259,25716],[16123,24261],
 [16124,21067,24260,25715],[16125,24268],
 [16126,21066,24257,25719],[16127,24258],
 [16128,21064,24265,25718],[16129,20608,23921,25515],
 [16133,20759,20764,23896,25889,25890],
 [16135,16217,23900,24127],[16136,23913],
 [16137,20623,23906,25507],[16138,20622,23905,25501],
 [16142,20634,23927,25519],[16144,20635,23928,25526],
 [16153,21143,24557,25443],[16154,20950,24491,25584],
 [16155,20982,23996,26026],[16156,21140,23959,26041],
 [16157,24134],[16158,24472],[16159,21175,24311,25914],
 [16160,21174,24284,25767],[16161,21173,24431,25794],
 [16162,21183,24606,26060],[16163,21181,24607,26059],
 [16164,16170,21182,21186,24602,24608,26058,26061],
 [16165,21185,24604,26057],[16168,21184,24601,26068],
 [16172,21178,24598,26062],[16173,21180,24605,26063],
 [16176,21111,21313,23976,25639,25643],[16178,24114],
 [16179,24158],[16180,21316,24151,25641],
 [16181,21315,24150,25635],[16182,21314,24156,25636],
 [16183,16189,16190,16191,16346,16390,21317,21323,21324,21325,
   21480,21524,24170,24171,24176,24178,24639,24673,25655,25656,
   25661,25663,26124,26158],
 [16184,16188,21318,21322,24169,24177,25654,25662],
 [16185,16186,21326,21327,24172,24174,25652,25653],
 [16187,21328,24173,25660],[16192,21320,24167,25659],
 [16193,16194,21319,21321,24168,24175,25657,25658],
 [16195,24488],[16196,20993,23993,25440],
 [16197,21331,23956,25441],[16199,24469],[16200,24308],
 [16201,24281],[16202,24428],[16203,21391,24567,25454],
 [16204,24568],[16205,24563],[16206,24565],
 [16207,21400,24564,25445],[16208,21398,24560,25448],
 [16209,24562],[16210,21396,24561,25447],[16211,24569],
 [16212,21395,24558,25451],
 [16213,16214,21393,21394,24559,24566,25450,25452],
 [16218,24465],[16219,20965,24304,25576],
 [16220,20964,24277,25570],[16221,20963,24424,25571],
 [16224,20976,24497,25588],[16225,20975,24499,25587],
 [16226,20977,24498,25595],[16237,23981],[16238,23980],
 [16239,20821,23986,25791],[16240,20831,20999,24006,26015,26037]
  ,[16241,24007],[16242,24002],[16243,20833,24004,26012],
 [16244,21008,24003,26028],[16245,20824,21006,23999,26021,26031]
  ,[16246,24001],[16247,20825,21004,24000,26022,26030],
 [16248,24008],[16249,20826,21003,23997,26017,26034],
 [16250,16298,20827,21002,23998,24474,26019,26035],
 [16251,16297,20828,21001,24005,24473,26018,26033],
 [16254,23944],[16255,23943],[16256,20858,23949,25790],
 [16257,20868,21337,23969,25998,26052],[16258,23970],
 [16259,23965],[16260,20870,23967,25995],
 [16261,21346,23966,26043],[16262,20861,21344,23962,26004,26046]
  ,[16263,23964],[16264,20862,21342,23963,26005,26045],
 [16265,23971],[16266,20863,21341,23960,26000,26049],
 [16267,20864,23961,26002],[16268,20865,21339,23968,26001,26048]
  ,[16270,24119],[16271,24118],[16272,24124],[16273,24144],
 [16274,24145],[16275,24140],[16276,24142],[16277,24141],
 [16278,24137],[16279,24139],[16280,24138],[16281,24146],
 [16282,24135],[16283,24136],[16284,24143],[16285,24303],
 [16286,24276],[16287,24423],[16288,24482],[16289,24483],
 [16290,24478],[16291,24480],[16292,24479],[16293,24475],
 [16294,24477],[16295,24476],[16296,24484],[16299,24481],
 [16302,21468,24321,25920],[16303,21466,24322,25919],
 [16304,21471,24317,25918],[16305,21470,24319,25917],
 [16306,21472,24318,25925],[16307,21462,24314,25927],
 [16308,21469,24316,25928],[16309,21461,24315,25926],
 [16310,21467,24323,25921],[16311,21464,24312,25924],
 [16312,21463,24313,25922],[16313,21465,24320,25923],
 [16315,21456,24294,25773],[16316,21454,24295,25772],
 [16317,21459,24290,25771],[16318,21458,24292,25770],
 [16319,21460,24291,25778],[16320,21450,24287,25780],
 [16321,21457,24289,25781],[16322,21449,24288,25779],
 [16323,21455,24296,25774],[16324,21452,24285,25777],
 [16325,21451,24286,25775],[16326,21453,24293,25776],
 [16327,21443,24441,25800],[16328,21441,24442,25799],
 [16329,21446,24437,25798],[16330,21445,24439,25797],
 [16331,21447,24438,25805],
 [16332,16334,21436,21437,24434,24435,25806,25807],
 [16333,21444,24436,25808],[16335,21442,24443,25801],
 [16336,16337,21438,21439,24432,24433,25802,25804],
 [16338,21440,24440,25803],
 [16340,16362,21492,21531,24632,24657,26106,26113],
 [16341,16377,21493,21530,24633,24666,26096,26155],
 [16342,16370,16372,21481,21491,21532,24634,24642,24662,26102,
   26103,26128],
 [16343,16345,16355,21477,21479,21489,24636,24644,24645,26121,
   26129,26130],
 [16347,16348,16398,21476,21498,21506,24617,24627,24643,26125,
   26127,26147],
 [16349,16387,16397,21474,21485,21513,24610,24621,24669,26126,
   26142,26152],
 [16350,16363,21522,21534,24647,24658,26105,26114],
 [16351,16378,16379,21483,21521,21535,24641,24648,24667,26095,
   26154,26156],
 [16352,16371,21523,21533,24649,24663,26104,26120],
 [16354,16386,21488,21520,24638,24652,26123,26137],
 [16357,21504,24618,26119],
 [16358,16389,21486,21496,24628,24635,26117,26148],
 [16359,16388,16396,21475,21484,21511,24611,24620,24670,26118,
   26143,26151],[16364,21482,24640,26112],
 [16365,21527,24659,26107],
 [16366,16368,21509,21516,24613,24656,26109,26110],
 [16373,21526,24668,26097],
 [16374,16375,16382,16383,21500,21502,21508,21517,24615,24624,
   24625,24661,26098,26100,26141,26146],
 [16380,21528,24664,26135],[16391,21525,24653,26138],
 [16392,21507,24612,26153],
 [16393,16401,21499,21512,24622,24671,26133,26144],
 [16394,16400,21497,21514,24629,24650,26132,26149],
 [16399,21505,24619,26134],[19888,21601],[19889,21598],
 [19890,21602],[19891,21596],[19892,21599],[19893,21603],
 [19894,21595],[19895,21597],[19896,21600],[19897,21604],
 [19904,21632],[19905,21631],[19909,21633],[19911,21619],
 [19912,21618],[19913,21625],[19918,21620],[19922,21634],
 [19924,21612],[19925,21611],[19926,21616],[19927,21629],
 [19999,20005],[20000,20002],[20001,20006],[20003],
 [20004,20007],[20008],[20015,20036],[20016,20035],
 [20020,20037],[20022,20023],[20024,20029],[20033,20038],
 [20057,20058,20264,20265,20267,20364,24678,24679,24885,24886,
   24888,24985],
 [20061,20062,20314,20317,20365,20458,24682,24683,24935,24938,
   24986,25079],[20072,20375,24688,24991],
 [20073,20387,24689,24997],[20075,25010],[20077,25000],
 [20078,25007],[20080,25017],[20084,20376,24694,24992],
 [20086,20389,24696,24999],[20088,25012],[20091,24998],
 [20092,25011],[20094,25003],[20095,25009],
 [20102,20407,24728,25024],[20104,20405,24721,25031],
 [20106,25021],[20107,25028],
 [20109,20110,20213,24730,24731,24834],
 [20111,20217,24732,24838],
 [20113,20114,20161,20163,20214,20411,24734,24735,24782,24784,
   24835,25032],[20115,20218,24736,24839],
 [20124,20222,24740,24841],[20125,20228,24741,24844],
 [20126,20240,24742,24850],[20127,20225,24764,24868],
 [20128,24863],[20129,24854],[20130,24853],[20131,24860],
 [20132,24871],[20133,24870],[20135,20223,24746,24842],
 [20137,20229,24747,24845],[20139,20242,24749,24852],
 [20140,20226,24763,24869],[20141,24865],[20143,24846],
 [20144,24851],[20145,24864],[20147,24856],[20148,24862],
 [20153,20254,24775,24879],[20154,20253,24780,24875],
 [20155,20260,24781,24877],[20157,20258,24774,24884],
 [20159,24874],[20160,24881],[20162,20266,24783,24887],
 [20166,20315,24787,24936],[20176,20416,24792,25035],
 [20178,20434,24794,25044],[20179,20419,24816,25062],
 [20181,25048],[20182,25047],[20183,25054],[20184,25065],
 [20185,25064],[20189,20423,24799,25039],
 [20192,20420,24815,25063],[20193,25059],[20195,25040],
 [20196,25045],[20197,25058],[20199,25050],[20200,25056],
 [20205,20448,24827,25073],[20206,20447,24832,25069],
 [20207,20454,24833,25071],[20209,20452,24826,25078],
 [20211,25068],[20212,25075],[20224,24758],[20231,24760],
 [20233,24750],[20234,24757],[20236,24767],[20244,24762],
 [20247,24748],[20248,24761],[20249,24754],[20250,24753],
 [20251,24759],[20255,24777],[20262,24771],[20263,24778],
 [20268,24889],[20269,24908],[20270,20287,24890,24898],
 [20271,20278,24894,24909],[20272,20277,24891,24893],
 [20273,20288,24892,24899],[20274,24911],
 [20275,20280,24917,24918],[20276,20293,24916,24919],
 [20279,20290,24895,24900],[20281,24913],[20282,24904],
 [20283,24903],[20284,24910],[20285,24921],[20286,24920],
 [20289,24905],[20291,24922],[20292,24902],[20294,24915],
 [20295,24897],[20296,24896],[20297,24901],[20298,24914],
 [20299,24907],[20300,24906],[20301,24912],
 [20302,20309,24926,24932],[20303,20307,24925,24933],
 [20304,20306,24928,24929],[20305,24930],
 [20308,20310,24927,24934],[20311,24923],[20312,24924],
 [20313,24931],[20316,24937],[20318,25098],
 [20319,20477,24939,25088],[20320,25099],
 [20321,20467,24940,25083],[20322,20478,24941,25089],
 [20323,25101],[20324,20470,24967,25107],
 [20325,20483,24968,25106],[20326,20462,24942,25081],
 [20327,20468,24943,25084],[20328,20480,24944,25090],
 [20329,20465,24966,25108],[20330,25103],[20331,25094],
 [20332,25093],[20333,25100],[20334,25111],[20335,25110],
 [20336,20460,24947,25080],[20337,20463,24948,25082],
 [20338,25095],[20339,20469,24949,25085],[20340,25112],
 [20341,20482,24951,25092],[20342,20466,24965,25109],
 [20343,25105],[20344,25087],[20345,25086],[20346,25091],
 [20347,25104],[20348,25097],[20349,25096],[20350,25102],
 [20351,20499,24975,25122],[20352,20497,24974,25123],
 [20353,20496,24978,25118],[20354,25120],
 [20355,20494,24977,25119],[20356,20493,24982,25115],
 [20357,20500,24983,25117],[20358,20492,24981,25116],
 [20359,20498,24976,25124],[20360,25113],[20361,25114],
 [20362,25121],[20378,24707],[20380,24697],[20381,24704],
 [20383,24714],[20391,24709],[20394,24695],[20395,24708],
 [20397,24700],[20398,24706],[20409,24718],[20410,24725],
 [20418,24810],[20427,24802],[20428,24809],[20430,24819],
 [20438,24814],[20441,24800],[20442,24813],[20443,24806],
 [20444,24805],[20445,24811],[20449,24829],[20456,24823],
 [20457,24830],[20459,24957],[20461,24958],[20464,24960],
 [20471,24962],[20472,24953],[20473,24952],[20474,24959],
 [20475,24970],[20476,24969],[20479,24954],[20481,24971],
 [20484,24964],[20485,24946],[20486,24945],[20487,24950],
 [20488,24963],[20489,24956],[20490,24955],[20491,24961],
 [20495,24979],[20501,24972],[20502,24973],[20503,24980],
 [20504,25143],[20505,20522,25125,25133],
 [20506,20513,25129,25144],[20507,20512,25126,25128],
 [20508,20523,25127,25134],[20509,25146],
 [20510,20515,25152,25153],[20511,20528,25151,25154],
 [20514,20525,25130,25135],[20516,25148],[20517,25139],
 [20518,25138],[20519,25145],[20520,25156],[20521,25155],
 [20524,25140],[20526,25157],[20527,25137],[20529,25150],
 [20530,25132],[20531,25131],[20532,25136],[20533,25149],
 [20534,25142],[20535,25141],[20536,25147],
 [20537,20544,25161,25167],[20538,20542,25160,25168],
 [20539,20541,25163,25164],[20540,25165],
 [20543,20545,25162,25169],[20546,25158],[20547,25159],
 [20548,25166],[20562,25668],[20563,25810],
 [20576,20577,21403,25605,25611,25814],[20605,25498],
 [20606,25505],[20619,25496],[20620,25509],
 [20647,20648,21074,25669,25670,25835],[20662,25839],
 [20687,20688,21043,25308,25309,25664],[20689,25315],
 [20701,25301],[20703,25319],[20727,25534],[20728,25533],
 [20729,25540],[20741,20742,21386,25421,25423,25531],
 [20766,20768,21044,25700,25701,25860],[20767,25671],
 [20780,20782,21387,25433,25436,25886],[20781,25608],
 [20804,25707],[20806,25866],[20807,26010],[20808,26009],
 [20814,20989,25646,25647],[20818,25439],
 [20819,21332,25614,25616],[20820,25952],[20822,25764],
 [20823,25911],[20829,21000,26014,26038],
 [20830,21007,26016,26039],[20832,21005,26023,26032],
 [20834,26013],[20835,26020],[20841,25706],[20842,25676],
 [20843,25865],[20844,25993],[20845,25992],
 [20851,20852,21308,25645,25648,25991],[20855,25438],
 [20857,25951],[20859,25763],[20860,25910],
 [20866,21338,25997,26053],[20867,21345,25999,26054],
 [20869,21343,26006,26047],[20871,25996],[20872,26003],
 [20878,25225],[20879,25232],[20892,25223],[20893,25236],
 [20913,25348],[20925,25342],[20927,21197,25180,25346],
 [20947,25567],[20959,20961,21369,25459,25460,25565],
 [20980,25678],[20981,25867],[20983,26025],[20994,25615],
 [20995,25953],[20996,25792],[20997,25765],[20998,25912],
 [21009,26029],[21010,26036],[21012,25673],[21013,25862],
 [21024,21027,21370,25472,25473,25929],[21026,25610],
 [21046,25710],[21057,25601],[21058,25704],[21059,25697],
 [21060,25696],[21061,25702],[21063,25723],[21065,25720],
 [21068,25717],[21070,25724],[21072,25714],[21073,25721],
 [21075,25681],[21076,25680],[21077,25182],[21078,25267],
 [21079,21080,21239,25387,25389,25665],[21081,25682],
 [21082,25632],[21083,25679],[21084,25675],[21085,25462],
 [21086,25425],[21087,25600],[21088,25674],[21089,25667],
 [21090,25666],[21091,25672],[21092,25692],[21093,25693],
 [21094,25688],[21095,25690],[21096,25689],[21097,25685],
 [21098,25687],[21099,25686],[21100,25694],[21101,25683],
 [21102,25684],[21103,25691],[21104,25870],[21105,25869],
 [21106,25189],[21110,25871],[21112,25868],[21114,25469],
 [21115,25432],[21116,25607],[21118,25784],[21119,25757],
 [21120,25861],[21121,25881],[21122,25882],[21124,25879],
 [21126,25874],[21127,25876],[21128,25875],[21129,25883],
 [21130,25872],[21131,25873],[21132,25880],[21144,25618],
 [21145,25956],[21163,25739],[21167,26040],[21169,25479],
 [21170,25442],[21171,25617],[21172,25955],[21198,25193],
 [21223,25278],[21241,25634],[21246,25602],[21249,25725],
 [21250,25731],[21257,25746],[21259,25753],[21261,25743],
 [21262,25750],[21267,25381],[21291,25619],[21292,25957],
 [21310,25461],[21312,25599],[21333,25954],[21334,25793],
 [21335,25766],[21336,25913],[21340,26050],[21347,26044],
 [21348,26051],[21349,25474],[21352,25950],[21372,25465],
 [21373,25471],[21380,25486],[21382,25493],[21384,25483],
 [21385,25490],[21388,25429],[21389,25428],[21390,25434],
 [21392,25455],[21397,25449],[21399,25456],[21401,25446],
 [21402,25453],[21404,25604],[21405,25603],[21406,25609],
 [21407,25629],[21408,25630],[21409,25625],[21410,25627],
 [21411,25626],[21412,25622],[21413,25624],[21414,25623],
 [21415,25631],[21416,25620],[21417,25621],[21418,25628],
 [21419,25788],[21420,25761],[21421,25908],[21422,25967],
 [21423,25968],[21425,25965],[21427,25960],[21428,25962],
 [21429,25961],[21430,25969],[21431,25958],[21432,25959],
 [21433,25966],
 [21650,21651,21704,21705,21706,21809,21811,21812,21959,22172,
   22173,22243,22244,22283,22284,22337,22338,22396,22398,22506,
   22580,22586,22639,22644,22645,22670,22704,22709,22789,22810,
   22839,22982,22999,29186,29199,29277,29290,35162,35175],
 [21652,21655,21708],
 [21653,21654,21709,21710,21757,21759,21810,21860,21861,21863,
   21960,22007],[21656,21760],
 [21657,21658,21910,21913,21961,22054],
 [21659,21662,21677,21712,21715,21730,21815,21818,21833,21962,
   21965,21980],
 [21660,21667,21713,21720,21816,21823,21963,21970],
 [21661,21663,21668,21678,21714,21716,21721,21731,21817,21819,
   21824,21834,21964,21966,21971,21981],[21665,21989],
 [21666,21988],[21669,21722,21825,21972],
 [21670,21683,21990,21991],
 [21671,21682,21724,21735,21827,21838,21974,21985],
 [21672,21736,21844,21976],[21673,21723,21843,21975],
 [21674,21718,21842,21982],[21675,21993],[21676,21992],
 [21679,21977],[21681,21994],[21684,21737,21840,21987],
 [21685,21969],[21686,21732,21830,21968],
 [21687,21725,21741,21829,21839,21973],
 [21688,21726,21740,21826,21828,21986],[21689,21979],
 [21690,21978],[21691,21984],
 [21692,21746,21756,21856,21858,22004],
 [21693,21753,21859,22005],[21695,21747,21751,21852,21853,22002]
  ,[21696,21699,21998,22001],[21697,21752,21851,21997],
 [21698,21748,21750,21850,21855,21999],
 [21700,21701,21995,22006],[21702,21754,21848,21996],
 [21703,21745,21755,21849,21857,22003],
 [21707,21813,31762,31764,31769,31779],[21711,21814],
 [21719,21841],[21727,21739,21821,21835],[21728,21846],
 [21729,21845],[21734,21847],[21738,21822],[21742,21832],
 [21743,21831],[21744,21837],[21761,21763,22008],
 [21762,21911],
 [21764,21767,21782,21865,21868,21883,22009,22012,22027],
 [21765,21772,21866,21873,22010,22017],
 [21766,21768,21773,21783,21867,21869,21874,21884,22011,22013,
   22018,22028],[21769,21785,21870,21886,22014,22030],
 [21770,22036],[21771,22035],[21774,21875,22019],
 [21775,22037],[21776,21787,21877,21888,22021,22032],
 [21777,21889,21894,22023],[21778,21876,21893,22022],
 [21779,21871,21892,22029],[21780,22040],[21781,22039],
 [21784,22024],[21786,22041],[21788,22038],
 [21789,21890,22034],[21790,22016],[21791,21880,21885,22015],
 [21792,21793,21878,21879,22020,22033],[21794,22026],
 [21795,22025],[21796,22031],
 [21797,21808,21899,21908,22050,22051],
 [21798,21906,21909,22052],[21799,21902,21904,22047],
 [21800,21803,21900,21903,22046,22049],[21801,22048],
 [21802,21901,21905,22044],[21804,22045],[21805,22053],
 [21806,22042],[21807,21898,21907,22043],[21864],
 [21872,21891],[21881,21896],[21882,21895],[21887,21897],
 [21914,21917,21932,22055,22058,22073],
 [21915,21922,22056,22063],
 [21916,21918,21923,21933,22057,22059,22064,22074],
 [21919,21935,22060,22076],[21920,22082],
 [21921,21927,21943,22069,22079,22081],[21924,22065],
 [21925,22083],[21926,21937,22067,22078],
 [21928,21940,21942,22062,22066,22068],
 [21929,21941,22061,22075],[21930,22086],[21931,22085],
 [21934,22070],[21936,22087],[21938,22084],[21939,22080],
 [21944,22072],[21945,22071],[21946,22077],
 [21947,21957,22089,22097],[21948,21958,22096,22098],
 [21949,21953,22092,22093],[21950,21952,22090,22095],
 [21951,22094],[21954,22091],[21955,22099],[21956,22088],
 [22100,22103,22118],[22101,22108],[22102,22104,22109,22119],
 [22105,22121],[22106,22127],[22107,22126],[22110],
 [22111,22128],[22112,22123],[22113,22114],[22115,22120],
 [22116,22131],[22117,22130],[22122,22132],[22124,22129],
 [22125],[22133,22142],[22134,22143],[22135,22138],
 [22136,22140],[22137,22139],[22141,22144],[22151,22791],
 [22155,22157,22256,22294,22299,22325,22406,22515,22673,22793],
 [22159,22258,22276,22297,22323,22509,22785,22814],
 [22170,22171,22242,22249,22285,22290,22336,22339,22405,22433,
   22442,22519,22650,22674,22680,22703],
 [22198,22211,22410,22488,22489,22585,22621,22622],
 [22201,22215,22471,22473,22609,22837],
 [22207,22475,22607,22678],[22213,22432],
 [22235,22817,22925,22948],[22317,22521],
 [22362,22364,22376,22378,22408,22411,22640,22675,22676,22835,
   22861,22983],
 [22363,22369,22375,22377,22445,22583,22646,22705],
 [22397,22553,22556,22558],
 [22400,22413,22451,22576,22582,22591,22649,22653,22682,22684,
   22712,22928],
 [22402,22415,22438,22444,22453,22589,22651,22708,22710,22841,
   22843,22926],[22403,22985],[22404,22706,22846,22984],
 [22407,22654,22679,22711],[22409,22986],[22414],
 [22416,22927],[22417,22766],[22418,22739],
 [22419,22714,22759,22886],[22420,22996],
 [22421,22717,22856,22997],[22422,22720,22854,22992],
 [22423,22721,22853,22994],[22424,22719,22852,22993],
 [22425,22723,22851,22989],[22426,22991],
 [22427,22722,22849,22990],[22428,22718,22857,22998],
 [22429,22727,22848,22987],[22430,22728,22855,22988],
 [22431,22995],[22434,22435,22540,22555,22557,22965],
 [22436,22906],[22437,22681],[22439,22840],[22440,22968],
 [22441,22967],[22446,22647,22687,22763,22969,23015],
 [22450,22590],[22454,22765],[22455,22738],[22456,22885],
 [22457,22979],[22458,22980],
 [22459,22602,22660,22693,22937,22975,23006,23024],
 [22460,22977],[22461,22976],
 [22462,22598,22664,22692,22938,22972,23010,23020],
 [22463,22974],[22464,22597,22665,22691,22939,22973,23008,23022]
  ,[22465,22981],[22466,22970],[22467,22971],[22468,22978],
 [22542,22543,22544,22549],[22574,22908],[22575,22683],
 [22577,22842],[22578,23001],[22579,23000],
 [22584,22768,22930,23002],[22592,22767],[22593,22740],
 [22594,22887],[22595,23012],[22596,22667,22688,23013],
 [22599,22663,22690,22940,23009,23021],
 [22600,22662,22694,23005],[22601,23007],
 [22603,22668,22689,22942,23014,23018],
 [22604,22659,22698,22941,23003,23029],
 [22605,22666,22699,23004],[22606,23011],[22641,22686],
 [22642,22685],[22655,22672],[22656,22671],[22657,22677],
 [22658,22697,22934,23028],[22661,22695,22935,23023],
 [22669,22696,22943,23019],[22700,22845],[22701,22844],
 [22715,22732],[22716,22836],[22724,22850],[22725,22858],
 [22726,22847],[22736,23016],[22741,22931],[22883,23017],
 [22888,22932],[22929],[22933,23027],[22936,23025],
 [22944,23026],
 [26168,26169,26171,26176,26186,26220,26221,26223,26228,26238,
   27598,27599,27601,27606,27616,27649,27650,27652,27657,27667,
   27699,27700,27702,27707,27717,30300,30301,30303,30308,30318,
   30397,30398,30400,30405,30415,30444,30445,30447,30452,30462,
   33973,33974,33976,33981,33991],
 [26170,26172,26177,26187,26222,26224,26229,26239,26321,26322,
   26324,26329,26339,26370,26371,26373,26378,26388,27600,27602,
   27607,27617,27651,27653,27658,27668,27701,27703,27708,27718,
   27843,27844,27846,27851,27861,27889,27890,27892,27897,27907,
   28975,28976,28978,28983,28993,29074,29075,29077,29082,29092,
   30302,30304,30309,30319,30349,30350,30352,30357,30367,30399,
   30401,30406,30416,30446,30448,30453,30463,31574,31575,31577,
   31582,31592,31622,31623,31625,31630,31640,31715,31716,31718,
   31723,31733,33975,33977,33982,33992,34019,34020,34022,34027,
   34037,35100,35101,35103,35108,35118],
 [26173,26178,26189,26225,26230,26241,27603,27608,27619,27654,
   27659,27670,27704,27709,27720,29169,29170,29172,29177,29187,
   29260,29261,29263,29268,29278,30305,30310,30321,30402,30407,
   30418,30449,30454,30465,33978,33983,33994,35145,35146,35148,
   35153,35163],
 [26174,26175,26196,26197,26226,26227,26248,26249,27604,27605,
   27626,27627,27662,27663,27712,27713,30313,30314,30408,30421,
   30423,30424,30455,30468,30470,30471,33984,33997,33999,34000],
 [26179,26195,26231,26247,27609,27625,27664,27669,27714,27719,
   29184,29189,29275,29280,30315,30320,30403,30425,30450,30472,
   33979,34001,35160,35165],
 [26180,26191,26232,26243,27610,27621,27661,27672,27711,27722,
   30312,30323,30409,30420,30456,30467,33985,33996],
 [26181,26233,27611,27656,27673,27675,27678,27706,27723,27725,
   27728,30307,30324,30326,30329,30411,30458,33987],
 [26182,26183,26234,26235,27612,27613,27655,27660,27676,27677,
   27705,27710,27726,27727,30306,30311,30327,30328,30410,30417,
   30457,30464,33986,33993],
 [26184,26236,27614,27666,27679,27716,27729,30317,30330,30428,
   30475,34004],
 [26185,26237,27615,27665,27680,27715,27730,30316,30331,30427,
   30474,34003],
 [26188,26192,26194,26240,26244,26246,27618,27622,27624,30404,
   30412,30426,30451,30459,30473,33980,33988,34002],
 [26190,26198,26242,26250,27620,27628,30414,30429,30461,30476,
   33990,34005],
 [26193,26245,27623,27674,27724,30325,30422,30469,33998],
 [26199,26200,26251,26252,27629,27630,30413,30419,30460,30466,
   33989,33995],
 [26201,26202,26203,26204,26207,26212,26253,26254,26255,26256,
   26259,26264,27631,27632,27633,27634,27637,27642,27683,27684,
   27686,27687,27688,27690,27692,27693,27733,27734,27736,27737,
   27738,27740,27742,27743,30334,30335,30337,30338,30339,30341,
   30343,30344,30434,30435,30437,30438,30439,30440,30481,30482,
   30484,30485,30486,30487,34010,34011,34013,34014,34015,34016],
 [26205,26206,26209,26211,26257,26258,26261,26263,26361,26363,
   26410,26412,27635,27636,27639,27641,27682,27685,27689,27691,
   27732,27735,27739,27741,30333,30336,30340,30342,30431,30432,
   30436,30441,30478,30479,30483,30488,31614,31616,31655,31658,
   31748,31751,34007,34008,34012,34017,34052,34055],
 [26208,26210,26260,26262,27638,27640,30430,30433,30477,30480,
   34006,34009],
 [26271,26272,26274,26279,26289,26418,26419,26421,26426,26436,
   27796,27797,27799,27804,27814],
 [26273,26275,26280,26290,26420,26422,26427,26437,27798,27800,
   27805,27815,29025,29026,29028,29033,29043,31669,31670,31672,
   31677,31687],
 [26276,26281,26292,26423,26428,26439,27801,27806,27817,27939,
   27944,27955,30244,30258,30540,30545,30556,32744,32758,32772,
   32773,32776,32781,32891,32892,32894,32899,32903,32909,32914,
   36157,36161],
 [26277,26285,26299,27807,27809,27823,29045,31684],
 [26278,26284,26300,26433,26438,27810,27820,27822],
 [26282,26286,26298,26425,26442,26444,26447,27802,27816,27824],
 [26283,26294,26430,26441,27808,27819],
 [26287,26288,26440,26450,27826,27827],
 [26291,26431,26432,27811,29049,29051,31676,31698],
 [26293,26434,26449,27828],
 [26295,26297,26424,26429,26445,26446,27803,27825,29036,29040,
   29052,31675,31689,31697],[26296,26443,27821],[26301,27813],
 [26302,27812],[26303,26435,26448,27818],
 [26304,26307,26308,26309,26312,26314,26451,26454,26458,26460,
   27830,27831,27835,27836,27838,27840],
 [26305,26306,26310,26315,27833,27834,27837,27839],
 [26311,26313,26452,26453,26455,26456,26457,26459,26461,26462,
   27781,27784,27785,27786,27788,27789,27790,27791,27829,27832,
   30523,30524,30525,30526,30529,30530,30532,30534,32924,32927,
   32931,32933],
 [26323,26325,26330,26340,26372,26374,26379,26389,26511,26512,
   26514,26519,26523,26529,26534,26556,26557,26559,26564,26568,
   26574,26579,27845,27847,27852,27862,27891,27893,27898,27908,
   28977,28979,28984,28994,29076,29078,29083,29093,30351,30353,
   30358,30368,31576,31578,31583,31593,31624,31626,31631,31641,
   31717,31719,31724,31734,32798,32799,32801,32806,32810,32816,
   32821,32936,32937,32939,32944,32948,32954,32959,34021,34023,
   34028,34038,34064,34065,34067,34072,34076,34082,34087,35102,
   35104,35109,35119,36180,36181,36183,36188,36192,36198,36203],
 [26327,26349,26376,26398,27856,27902,28989,29088,30363,31580,
   31602,31633,31649,31726,31742,34030,34046,35113],
 [26328,26350,26377,26399,27857,27903,28988,29087,30362,31581,
   31603,31646,31648,31739,31741,34043,34045,35114],
 [26332,26348,26381,26397,27863,27909,28990,29089,30364,31585,
   31601,31628,31650,31721,31743,34025,34047,35120],
 [26333,26344,26382,26393,27855,27866,27901,27912,28987,28998,
   29086,29097,30361,30372,31586,31597,31634,31645,31727,31738,
   34031,34042,35112,35123],
 [26334,26383,27867,27869,27913,27915,28982,29004,29081,29103,
   30356,30378,31587,31636,31729,34033,35124,35126],
 [26335,26384,27854,27870,27900,27916,28981,29003,29080,29102,
   30355,30377,31588,31635,31728,34032,35111,35127],
 [26336,26385,27849,27871,27895,27917,28986,29002,29085,29101,
   30360,30376,31589,31642,31735,34039,35106,35128],
 [26337,26386,27873,27919,28992,29091,30366,31590,31653,31746,
   34050,35130],
 [26338,26387,27874,27920,28991,29090,30365,31591,31652,31745,
   34049,35131],
 [26341,26390,26524,26569,31594,31637,31730,32812,32950,34034,
   34078,36193],[26343,26392,31596,31654,31747,34051],
 [26345,26347,26394,26396,26531,26576,31598,31600,31629,31651,
   31722,31744,32813,32951,34026,34048,34079,36200],
 [26346,26395,26536,26581,27868,27914,29000,29099,30374,31599,
   31647,31740,32823,32961,34044,34089,35125,36205],
 [26351,26400,31604,31639,31732,34036],
 [26352,26401,26533,26578,27875,27921,28997,29096,30371,31605,
   31638,31731,32830,32968,34035,34096,35132,36202],
 [26353,26402,31606,31644,31737,34041],
 [26354,26357,26403,26406,27877,27878,27882,27887,27923,27924,
   27928,27933,29012,29013,29016,29018,29111,29112,29115,29117,
   30386,30387,30390,30392,31607,31610,31662,31664,31755,31757,
   34059,34061,35134,35135,35139,35144],
 [26355,26356,26360,26365,26404,26405,26409,26414,27880,27881,
   27884,27886,27926,27927,27930,27932,29009,29010,29014,29019,
   29108,29109,29113,29118,30383,30384,30388,30393,31608,31609,
   31613,31618,31659,31660,31663,31665,31752,31753,31756,31758,
   34056,34057,34060,34062,35137,35138,35141,35143],
 [26358,26359,26362,26364,26407,26408,26411,26413,27883,27885,
   27929,27931,29008,29011,29107,29110,30382,30385,31611,31612,
   31615,31617,31656,31657,31661,31666,31749,31750,31754,31759,
   34053,34054,34058,34063,35140,35142],
 [26465,26466,26468,26473,26483,29122,29123,29125,29130,29140],
 [26467,26469,26474,26484,29124,29126,29131,29141,29691,29699,
   29983,29989,31926,32011,32199,32489,35311,35316,35395,35396],
 [26470,26475,26486,29058,29061,29062,29063,29066,29068,29127,
   29132,29143,29789,30074,31703,31704,31708,31709,31711,31713,
   31765,31770,31781,32289,32297,32574,32578,33278,33325,35682,
   35963,36250,36291],[26471,26493,29133,29149,31775,31780],
 [26472,26480,26494,29142,29146,29148],
 [26476,26489,26491,26492,29128,29129,29150,29151],
 [26477,26488,29134,29145,37341,37420,37601,37893],
 [26478,26485,29136,29137,31767,31784,31786,31789],
 [26479,29135],[26481,26487,29153,29154],
 [26482,26497,29144,29152],[26490,27959,29147,30560],
 [26495,29139],[26496,29138],[26498,26501,29162,29164],
 [26499,26500,26504,26509,29159,29160,29163,29165],
 [26502,26503,26505,26506,26507,26508,29155,29156,29157,29158,
   29161,29166,29249,29250,29254,29259,32882,32883,32886,32888],
 [26513,26515,26520,26530,26558,26560,26565,26575,32800,32802,
   32807,32817,32938,32940,32945,32955,34066,34068,34073,34083,
   36182,36184,36189,36199],
 [26517,26539,26562,26584,32809,32825,32947,32963,34075,34091,
   36186,36208],
 [26518,26540,26563,26585,32822,32824,32960,32962,34088,34090,
   36187,36209],
 [26522,26538,26567,26583,32804,32826,32942,32964,34070,34092,
   36191,36207],[26525,26570,32811,32949,34077,36194],
 [26526,26571,32818,32956,34084,36195],
 [26527,26572,32829,32967,34095,36196],
 [26528,26573,32828,32966,34094,36197],
 [26535,26537,26580,26582,32805,32827,32943,32965,34071,34093,
   36204,36206],[26541,26586,32815,32953,34081,36210],
 [26542,26587,32814,32952,34080,36211],
 [26543,26588,32820,32958,34086,36212],
 [26544,26547,26589,26592,32838,32840,32976,32978,34104,34106,
   36213,36216],
 [26545,26546,26550,26555,26590,26591,26595,26600,32835,32836,
   32839,32841,32973,32974,32977,32979,34101,34102,34105,34107,
   36214,36215,36219,36224],
 [26548,26549,26552,26554,26593,26594,26597,26599,32832,32833,
   32837,32842,32970,32971,32975,32980,34098,34099,34103,34108,
   36217,36218,36221,36223],
 [26551,26553,26596,26598,32831,32834,32969,32972,34097,34100,
   36220,36222],
 [26603,26618,26651,26744,27981,27996,28029,28122,30582,30597,
   30630,30723,34111,34126,34159,34252],
 [26604,26605,26652,26653,26688,26690,26731,26745,26747,26771,
   26774,26776,26926,26961,26969,26972,27242,27267,27982,27983,
   28030,28031,28066,28068,28109,28123,28125,28149,28152,28154,
   28304,28339,28347,28350,28620,28645,29305,29306,29349,29350,
   29351,29434,29438,29439,29629,29638,29639,29944,30583,30584,
   30631,30632,30667,30669,30710,30724,30726,30750,30753,30755,
   30905,30940,30948,30951,31221,31246,31805,31806,31849,31850,
   31851,31934,31938,31939,32129,32138,32139,32444,34112,34113,
   34160,34161,34196,34198,34239,34253,34255,34279,34282,34284,
   34434,34469,34477,34480,34750,34775,35190,35191,35234,35235,
   35236,35319,35323,35324,35514,35523,35524,35829],
 [26606,28034,28050,28111,30731,30909,30919,34756],
 [26607,26615,28035,28049,28110,30732,30906,30908,34749,34755],
 [26609,26619,26662,26693,26703,26784,27987,27997,28040,28071,
   28081,28162,30588,30598,30641,30672,30682,30763,34117,34127,
   34170,34201,34211,34292],
 [26610,26612,26664,26666,26813,26817,26928,26997,27003,27008,
   27244,27316,27988,27990,28042,28044,28191,28195,28306,28375,
   28381,28386,28622,28694,29308,29309,29356,29357,29392,29394,
   29435,29449,29451,29475,29478,29480,29630,29665,29673,29676,
   29946,29971,30589,30591,30643,30645,30792,30796,30907,30976,
   30982,30987,31223,31295,31808,31809,31856,31857,31892,31894,
   31935,31949,31951,31975,31978,31980,32130,32165,32173,32176,
   32446,32471,34118,34120,34172,34174,34321,34325,34436,34505,
   34511,34516,34752,34824,35193,35194,35241,35242,35277,35279,
   35320,35334,35336,35360,35363,35365,35515,35550,35558,35561,
   35831,35856,37224,37226,37278,37280,37427,37431,37542,37611,
   37617,37622,37858,37930],
 [26611,26669,26750,28041,29485,30910,31916,31981,32066,32183,
   34263,34396,34757,35560,37506,37976],
 [26613,26663,28047,28128,30734,30867,31913,32479,34439,34637],
 [26614,28036,28048,28115,30733,30830,30915,34607],
 [26616,26665,28051,28591,30609,30912,34456,34760],
 [26617,26632,28052,30911,34751,34759],
 [26620,26656,28130,28318,30651,30712,34438,34666],
 [26621,26648,26736,26823,26937,27748,27749,27751,27756,27766,
   27999,28026,28114,28201,28315,29313,29323,29366,29397,29407,
   29488,30490,30491,30493,30498,30508,30600,30627,30715,30802,
   30916,31813,31823,31866,31897,31907,31988,34129,34156,34244,
   34331,34445,35198,35208,35251,35282,35292,35373,37442,37685],
 [26622,26659,28134,28564,30610,30722,34455,34761],
 [26623,26625,27068,27075,27246,27361,27772,27774,28001,28003,
   28446,28453,28624,28739,30497,30519,30602,30604,31047,31054,
   31225,31340,34131,34133,34576,34583,34754,34869],
 [26624,26670,26737,28314,30637,34262,34359,34758],
 [26626,26627,26654,26667,28124,29834,29863,30720,34369,34406,
   34452,34453,35287,35294],
 [26628,26629,26649,26650,26850,27455,28006,28007,28027,28028,
   28117,28118,28228,28473,28833,30718,30719,30921,30922,31015,
   31021,31074,31224,31399,34450,34451,34544,34550,34753,34928],
 [26630,28126,30737,34721],
 [26631,26947,28053,28631,30601,30917,34167,34694],
 [26633,26636,26676,28017,28022,28056,28060,28138,28139,28328,
   30665,30743,30748,30932,30933,31237,31241,34466,34769,34771],
 [26634,26960,27260,28016,28058,28140,28145,28327,30664,30745,
   30749,30934,31235,34145,34192,34772],
 [26635,26677,27265,28021,28057,28059,28137,28141,28335,30666,
   30744,30747,30930,30935,31234,34149,34467,34767],
 [26637,26684,26685,26766,27264,28020,28061,30931,31233,34142,
   34270,34457,34468,34768],
 [26638,26642,26680,26683,26767,28063,28144,30741,30928,34278,
   34460,34463,34762,34764],
 [26639,26678,26760,28014,28054,28064,28142,28331,28640,30623,
   30661,30740,30929,30937,31240,34277,34462,34766],
 [26640,26643,26681,26763,26957,28146,28334,30658,30738,34195,
   34273,34459,34763,34765],
 [26641,26768,26956,26959,27259,28018,31236,34143,34185,34187,
   34267,34773],
 [26644,26682,26761,26950,28011,28147,28332,28636,30618,30657,
   30739,31242,34194,34272,34461,34770],
 [26655,26738,26749,26939,28033,28116,28127,28317,30634,30717,
   30728,30918,34163,34246,34257,34447],
 [26657,27993,28131,28305,30650,30711,31220,34437],
 [26658,27250,27992,28132,28229,30649,30716,31078,34132,34444],
 [26660,28135,30721,34454],
 [26668,26941,28046,28319,30647,30920,34176,34449],
 [26671,26732,27985,28307,30636,31226,34261,34435],
 [26672,26733,27158,27984,28308,30635,31227,34128,34260,34448],
 [26673,28043,30927,34441],[26674,28010,31222,34440],
 [26675,28009,31165,34446],
 [26679,26759,27257,28013,28055,28065,28143,28329,28633,28643,
   30620,30622,30660,30742,30936,30938,31238,34148,34276,34464],
 [26686,26764,26953,27262,27263,28336,28639,30615,30655,34141,
   34152,34190,34269,34458],
 [26687,26765,26951,27255,28019,28337,28635,28637,30614,30619,
   30656,31244,34151,34189,34271,34465],
 [26689,26775,26970,28067,28153,28348,29215,29216,29218,29223,
   29233,30668,30754,30949,32845,32846,32848,32853,32863,34197,
   34283,34478],
 [26691,28092,28151,28157,30944,30956,31249,34781],
 [26692,28091,28150,28158,30943,30957,31016,34780],
 [26694,26697,26785,26789,26963,27269,28072,28075,28163,28167,
   28341,28647,30673,30676,30764,30768,30942,31248,32981,32982,
   33025,33026,33027,33110,33114,33115,33305,33314,33315,33620,
   34202,34205,34293,34297,34471,34777,36225,36226,36269,36270,
   36271,36354,36358,36359,36549,36558,36559,36864],
 [26696,26711,26790,28164,30945,34407,34488,34782],
 [26698,26705,28170,28353,30774,30868,31830,31871,32102,32149,
   34638,34667],
 [26699,26700,27126,28077,28078,28171,28172,28230,28232,28340,
   28504,28816,30772,30773,30831,30833,30941,31079,31080,31245,
   31417,34608,34609,34774],
 [26701,26707,28174,30947,34785,34786],
 [26702,28175,30946,34784],
 [26706,26710,26824,26830,27271,27318,28084,28088,28202,28208,
   28649,28696,30685,30689,30803,30809,31250,31297,34214,34218,
   34332,34338,34779,34826],
 [26708,27069,28086,28447,30687,31048,34216,34577],
 [26709,26712,26777,28349,30760,34370,34487,34783],
 [26713,26772,28070,28342,30759,31251,34486,34545],
 [26714,26773,28069,28343,30758,31252,34485,34778],
 [26715,28166,30962,34722],
 [26716,26717,27500,28094,28095,28878,31166,31169,31247,34695,
   34698,34776],
 [26718,28102,28179,28363,30788,30968,31262,34796],
 [26719,27290,28101,28180,28181,28362,28370,30787,30789,30969,
   30970,31260,34234,34797],
 [26720,26721,26799,26800,27525,27546,28098,28099,28106,28107,
   28177,28178,28182,28183,28364,28366,28658,28665,28903,28920,
   28924,28925,28948,28968,30707,30708,30783,30784,30965,30967,
   30972,30973,31259,31263,31265,31266,31521,31526,31549,31550,
   31567,31569,34501,34502,34792,34794,35079,35096],
 [26722,26727,26806,26807,28105,28184,30966,31258,33473,33754,
   34495,34503,34787,34793,36709,36994],
 [26723,26725,26803,26992,28186,28369,30781,30963,34318,34498,
   34789,34790],
 [26724,26801,26985,28096,28187,28367,28661,30703,30780,30964,
   31267,34317,34497,34791],
 [26726,26808,26991,27289,28103,31261,34227,34310,34492,34798],
 [26728,26729,26804,26805,26986,26988,27280,27287,27542,27547,
   27570,27590,28371,28372,28662,28664,28949,28966,30699,30700,
   30778,30779,31504,31525,34236,34237,34312,34313,34494,34496,
   34788,34795,35050,35055,35078,35098],
 [26739,26740,27095,28320,28321,28414,28420,28623,28798,29804,
   29805,29970,30607,30608,30628,30629,30829,31434,34247,34248,
   34603,35288,35289,35715],
 [26741,26898,26945,28239,28322,30606,30633,34134,34175,34254],
 [26742,28324,30639,34265],[26743,27253,28325,30638,34130,34264]
  ,[26746,28004,28045,29402,30877,30924,31996,31999,32093,32179,
   34249,35719],
 [26748,27994,28008,28311,30652,31192,31231,34266],
 [26751,28129,30730,34259],
 [26752,26940,27248,27998,31137,34114,34180,34241],
 [26753,26927,27247,28619,30594,34115,34179,34240],
 [26754,26851,28477,28628,30593,30603,34178,34245],
 [26755,26888,26931,28507,28627,30590,30592,34171,34177,34258],
 [26756,28000,31232,34251],[26757,34250],
 [26758,27213,34138,34256],
 [26762,26949,26952,27254,28012,28148,28333,28338,28634,28638,
   30616,30617,30659,30663,30746,31243,34150,34191,34193,34274],
 [26769,26954,26958,27258,27261,28641,30612,34144,34147,34184,
   34186,34268],
 [26770,26955,27256,28015,28062,28330,28632,28642,30613,30621,
   30662,30939,31239,34146,34188,34275],
 [26778,26974,27750,27752,27757,27760,27767,27771,28156,28352,
   29352,29359,29440,29442,29453,29641,29643,30492,30494,30499,
   30502,30509,30513,30757,30953,31852,31859,31940,31942,31953,
   32141,32143,34286,34482,35237,35244,35325,35327,35338,35526,
   35528,37309,37401,37428,37618],
 [26779,28355,28648,30693,30752,34473],
 [26780,28356,28415,30692,30751,34472],
 [26781,27275,28240,28357,30691,30756,34217,34479],
 [26782,26783,27185,28359,28360,28864,30761,30762,31164,34489,
   34490,34994],[26786,28089,28168,30878,30959,34474],
 [26788,28093,28592,30694,31193,33461,34491,36815],
 [26791,26976,28169,28354,30770,30955,34299,34484],
 [26792,26975,28083,29445,31138,31831,31858,32065,32148,34303,
   34397,35335],
 [26793,26794,26852,26854,26962,27438,28478,28479,28644,30678,
   30679,31105,34301,34302,34360,34362,34470,34946],
 [26795,26889,27159,28508,30677,34213,34300,34483],
 [26796,28085,31257,34476],[26797,34475],[26798,34481],
 [26802,26984,27282,28097,28188,28368,28659,28668,30702,30705,
   30782,30971,31268,34233,34316,34499],
 [26809,26989,27283,27288,28666,30697,34226,34232,34309,34493],
 [26810,26990,27281,28104,28660,28667,30698,30704,31269,34231,
   34311,34500],[26811,28190,28376,30978,31298,34828],
 [26812,28189,28377,30977,31299,34827],
 [26816,26829,28383,30979,34829,34830,37443,37936],
 [26818,26820,27096,28242,28245,28389,28391,28695,28799,30811,
   30813,30869,30870,30975,31418,34639,34640,34799],
 [26819,28390,28417,28539,30804,30812,30832,34610,37433,37716],
 [26821,28393,30981,34832],[26822,28394,30980,34831],
 [26825,27102,28209,28387,30880,30993,34327,34669],
 [26827,28213,31195,34833],
 [26828,27071,28206,28449,29325,29527,30807,31050,31825,32027,
   34336,34579,35210,35412,37235,37262,37350,37437,37551],
 [26831,27009,27012,27039,28203,31140,34341,34361,34409,34522,
   37445,37515,37623,37628],
 [26832,26834,26890,26891,26996,27439,28509,28510,28669,30797,
   30799,31075,34372,34375,34519,34521,34825,34929],
 [26833,26853,28076,28173,28267,28279,28392,28480,29331,29358,
   30771,30798,30810,30954,30988,31109,31945,31950,34520,34547,
   35450,35533,37439,37775],[26835,28205,31304,34724],
 [26836,27016,34509,34697],[26837,34823],
 [26838,28218,28222,28397,28398,28705,30827,31002,31007,31309,
   31310,34843],
 [26839,28219,28221,28396,28400,28712,30828,31003,31006,31307,
   31312,34844],
 [26840,27019,28216,28226,28401,28708,30823,30999,31306,31314,
   34536,34839],
 [26841,27018,28217,28227,28402,28706,30822,31001,31313,31315,
   34535,34841],
 [26842,26845,27026,28225,28403,31000,31305,34537,34837,34840],
 [26843,27022,27334,28405,28711,30820,30997,34357,34532,34836],
 [26844,27020,27327,28406,28709,30819,30998,34356,34531,34838],
 [26846,26847,27025,28223,31308,34529,34834,34845],
 [26848,27023,27330,28713,30817,34352,34528,34835],
 [26849,27024,27328,28714,30818,34351,34530,34842],
 [26855,28482,31043,34871],[26856,28485,30873,34646],
 [26858,28487,28518,31011,31084,34805],
 [26859,28489,31107,34949],[26860,28490,31106,34948],
 [26861,26944,28276,28323,30605,30646,31909,32363,34135,34162],
 [26862,26979,28653,30688,34220,34285],
 [26863,28284,30885,34675],
 [26864,26867,27011,27013,27317,27421,34340,34342,34398,34399,
   34504,34947],[26865,28288,31200,34950],
 [26866,27078,32029,32365,34549,34585,37355,37360],
 [26868,34910],[26869,28278,31145,34415,37778,37913],
 [26870,34378],[26871,28287,31361,34553],
 [26872,28250,31362,34891],[26873,28280,31404,34730],
 [26874,28851,31318,34703],[26875,28850,31171,34850],
 [26876,27462,28293,28494,28858,31128,31372,31410,34566,34960],
 [26877,27461,28294,28496,31129,31412,34564,34961],
 [26878,27465,28291,28497,28855,31125,31375,31414,34563,34956],
 [26879,28292,28498,28854,31127,31373,31415,34958],
 [26880,27464,28499,31126,34561,34957],
 [26881,27469,28501,31123,34560,34953],
 [26882,27470,28502,28852,31124,31377,34567,34955],
 [26883,27468,28300,31405,34559,34954],
 [26884,27463,34565,34962],[26885,28298,28861,31368,31408,34951]
  ,[26886,34952],[26887,34959],[26892,28512,31042,34870],
 [26893,28515,30872,34645],[26894,28516,28546,30835,31017,34615]
  ,[26895,28517,31010,34804],[26896,28519,31077,34932],
 [26897,27172,28520,31076,34800,34931],
 [26899,26966,26980,28652,30675,34219,34294,34298],
 [26900,28247,30886,34674],[26901,27014,27161,34333,34339,34517]
  ,[26902,28251,31201,34933],
 [26903,26904,27076,27079,27360,27422,34411,34412,34584,34587,
   34868,34930],[26905,34909],
 [26906,27167,28241,31146,34371,34414],
 [26907,27166,34377,34408],[26909,28249,31024,34890],
 [26910,28243,31421,34729],[26911,28836,31019,34702],
 [26912,27157,28835,31013,34808,34849],
 [26913,27176,27477,28256,28524,28843,31034,31098,31427,34818,
   34904,34943],
 [26914,27476,28257,28526,31099,31429,34902,34944],
 [26915,27480,28254,28527,28840,31037,31095,31431,34901,34939],
 [26916,27173,28255,28528,28839,31035,31097,31432,34820,34941],
 [26917,27479,28529,31096,34899,34940],
 [26918,27182,27484,28531,31093,34811,34898,34936],
 [26919,27485,28532,28837,31039,31094,34905,34938],
 [26920,27183,27483,28263,31422,34812,34897,34937],
 [26921,27478,34903,34945],
 [26922,27178,28261,28846,31030,31425,34813,34934],
 [26923,27180,34814,34935],[26924,34942],
 [26929,27241,28625,30586,34123,34165],
 [26930,28536,28626,30585,30599,34164],
 [26932,27243,28629,30596,34140,34182],
 [26933,26948,28630,30595,34173,34181],
 [26936,27099,28002,31229,34122,34166],
 [26938,27186,28037,28121,30735,30926,34139,34183],
 [26942,26943,27036,27042,27245,27420,34136,34137,34157,34158,
   34358,34963],[26946,34168],[26964,28650,30671,34288],
 [26965,28651,30670,34287],[26967,28654,30681,34305],
 [26968,27278,28655,30680,34215,34304],
 [26971,28087,31254,34289],[26973,28079,28346,30775,31256,34306]
  ,[26977,27270,27273,34199,34222,34281],
 [26978,27037,27272,34200,34221,34280],
 [26981,26982,27486,34290,34291,34693],
 [26983,27214,34223,34296],
 [26987,27279,28373,28663,30701,30786,34235,34314],
 [26993,26994,27284,27286,27571,27588,34228,34229,34307,34308,
   35033,35054],
 [26995,27285,28100,28185,28365,28657,30706,30785,30974,31264,
   34230,34315],
 [26998,27005,28207,28697,30791,31301,34507,34508],
 [26999,28698,30790,34506],[27000,27322,28699,30795,34337,34513]
  ,[27001,28567,28701,30801,30815,34524],
 [27002,28702,30800,34523],[27007,28594,30814,34525],
 [27010,28388,30989,34518],[27015,34510],[27017,34515],
 [27021,27326,27329,28407,28710,28715,30821,30825,31005,34353,
   34355,34533],[27027,27333,27336,34347,34349,34526],
 [27028,27331,27335,34346,34348,34527],
 [27029,27332,28224,28707,30824,31316,34350,34534],
 [27030,28671,31044,34872],[27031,27296,28674,30874,34403,34647]
  ,[27032,28675,29868,30837,34617,35888,37508,37721],
 [27033,28676,31012,34806],[27034,27341,28678,31136,34420,34965]
  ,[27035,28679,31135,34964],[27038,27107,34402,34676],
 [27040,27194,34419,34966],
 [27041,27077,34374,34586,37240,37281,37512,37559],
 [27043,34911],[27045,27382,34379,34417],
 [27046,29871,32067,32371,34554,35452],[27047,34892],
 [27048,34731],[27049,34704],[27050,34851],
 [27051,27426,27446,28683,31157,34391,34430,34976],
 [27052,27445,28685,31158,34389,34977],
 [27053,27449,28686,31154,34388,34972],
 [27054,28687,31156,34974],
 [27055,27396,27435,27448,28688,31155,34386,34421,34973,34985],
 [27056,27433,27453,28690,31152,34385,34424,34969],
 [27057,27454,28691,31153,34392,34971],
 [27058,27393,27431,27452,34384,34423,34970,34988],
 [27059,27398,27447,34390,34978,34982],
 [27060,27397,27430,34427,34967,34993],[27061,34968],
 [27062,34975],[27063,28740,30871,34642],
 [27064,28741,30834,34612],[27065,28742,31009,34801],
 [27066,28744,31046,34875],[27067,28745,31045,34874],
 [27070,28452,31344,34671],[27072,34876],
 [27073,28451,31052,34581],[27074,28448,31142,34873],
 [27080,27082,27487,34725,34726,34846],
 [27081,33363,34699,36412],
 [27083,28462,28467,28749,31067,31352,31358,34886],
 [27084,28461,28466,28751,31068,31350,31357,34887],
 [27085,27370,28471,28752,31064,31349,34601,34882],
 [27086,27087,27369,27377,27532,27555,28470,28472,28753,28754,
   28954,28967,31065,31066,31348,31356,31511,31534,34600,34602,
   34883,34884,35084,35097],
 [27088,27373,28756,31062,34597,34879],
 [27089,27371,28757,31063,34596,34881],
 [27090,27091,28468,31351,34880,34888],
 [27092,27094,27375,27376,27576,27589,34594,34595,34877,34885,
   35040,35063],[27093,27374,34593,34878],
 [27097,27292,28801,30876,34650,34680],
 [27098,28802,30875,34649],[27100,27101,27266,34207,34208,34634]
  ,[27103,27188,34651,34679],[27104,34572],
 [27105,27297,34366,34648],[27106,34644],
 [27109,28483,31119,32368,32503,34540],
 [27110,28513,31089,34643],[27111,34636],[27112,34635],
 [27113,34641],[27114,27303,28768,28806,30897,31463,34661,34690]
  ,[27115,28775,28808,30898,31464,34662],
 [27116,28771,28809,30894,31459,34657],
 [27117,28769,28810,30896,31458,34659],
 [27118,27312,28811,30895,34658,34681],
 [27119,27310,28774,28813,30892,31456,34654,34684],
 [27120,28772,28814,30893,31455,34656],
 [27121,27308,34655,34683],[27122,34663],
 [27123,27307,34652,34687],[27124,28776,31453,34653],
 [27125,28777,31454,34660],[27127,28818,30839,34620],
 [27128,28819,30838,34619],
 [27129,27989,28309,29413,29675,30642,31228,34121,35370,35864,
   37677,37748],
 [27130,28537,29330,29371,29450,30684,34206,35330,35487,35534],
 [27131,27132,27291,34326,34328,34604],[27133,34621],
 [27134,34571,37227,37743],[27135,29839,34618,35699,37724,37749]
  ,[27136,34614],[27137,34401],
 [27138,28416,29870,31147,34364,35489,37719,37754],
 [27139,28273,28409,31118,31275,34539],
 [27140,28236,28410,31088,31276,34613],[27141,34606],
 [27142,28550,31271,34605],[27143,28549,31167,34611],
 [27144,28430,28557,28823,30860,31286,31448,34631],
 [27145,28437,28825,30861,31449,34632],
 [27146,28433,28554,28826,30857,31289,31444,34627],
 [27147,28431,28553,28827,30859,31287,31443,34629],
 [27148,28828,30858,34628],[27149,28436,28830,30855,31441,34624]
  ,[27150,28434,28551,28831,30856,31291,31440,34626],
 [27151,34625],[27152,34633],[27153,28560,31282,34622],
 [27154,28438,31438,34623],[27155,28439,31439,34630],
 [27156,28834,31014,34809],[27160,27165,27295,34668,34673,34803]
  ,[27162,34810],[27163,27365,34578,34582],[27164,34807],
 [27168,28234,28272,31086,31117,34546],[27170,34723],
 [27171,28521,31082,34696],[27174,28262,28841,31036,31433,34821]
  ,[27175,28258,28525,28842,31032,31100,31428,34816],
 [27177,28844,31033,34817],
 [27179,28259,28522,28847,31031,31102,31424,34815],
 [27181,34822],[27184,28264,31423,34819],
 [27187,27190,27268,34224,34225,35008],
 [27189,28200,28379,30995,31302,34344],
 [27191,28569,31060,33168,34589,36607],
 [27192,27342,34383,34980],[27193,34914],
 [27195,27339,34382,34981],[27196,34557],[27197,34895],
 [27198,34734],[27199,34707],[27200,34854],
 [27201,27348,28868,31212,35018,35030],
 [27202,28870,31213,35019],[27203,28871,31209,35014],
 [27204,28872,31211,35016],[27205,27357,28873,31210,35015,35021]
  ,[27206,27355,28875,31207,35011,35024],
 [27207,28876,31208,35013],[27208,27353,33884,35012,35023,36832]
  ,[27209,35020],[27210,27352,35009,35027],[27211,35010],
 [27212,35017],[27215,34678],[27216,27325,34335,34343],
 [27217,27218,27338,34588,34590,34995],[27219,34979],
 [27220,34913],[27221,27442,34373,34418],
 [27222,27425,34381,34410],[27223,34556],[27224,34894],
 [27225,34733],[27226,34706],[27227,34853],
 [27228,27516,28881,31185,34863,35005],
 [27229,28883,31186,35006],[27230,28884,31182,35001],
 [27231,27513,28885,31184,34865,35003],
 [27232,28886,31183,35002],[27233,27522,28888,31180,34856,34998]
  ,[27234,28889,31181,35000],[27235,27523,34857,34999],
 [27236,35007],[27237,27518,34858,34996],
 [27238,27520,34859,34997],[27239,35004],
 [27249,27991,28133,28266,29416,29481,30648,30729,31108,31985,
   32175,34119,35451,35568],[27251,28621,30611,34125],
 [27252,28136,28326,30644,30727,34124],
 [27274,28277,28358,30690,30769,34204],[27276,34210],
 [27277,28176,28656,30686,30952,34209],[27293,34573],
 [27298,34541],[27299,34672],[27300,28719,30891,34665],
 [27301,34664],[27302,34670],
 [27304,28767,28807,30899,31462,34691],
 [27305,28804,30901,34686],[27306,28805,30902,34688],
 [27309,34685],[27311,34692],[27313,34682],[27314,34689],
 [27315,34345],
 [27319,27320,28194,28378,30984,31300,34319,34320,37426,37933],
 [27321,28700,30808,34324],[27323,34330],[27324,34329],
 [27337,28220,28399,28404,28704,30826,31004,31008,31311,34354],
 [27340,34915],[27343,34558],[27344,34896],
 [27345,28723,31206,34735],[27346,34708],[27347,34855],
 [27349,27354,28869,31214,33890,35025,35031,36825],
 [27350,28866,31216,35026],[27351,28867,31217,35028],
 [27356,35032],[27358,35022],[27359,35029],
 [27362,34400,37283,37364,37369,37502],[27363,34363],
 [27364,34538],[27366,34575],[27367,34574],[27368,34580],
 [27372,28758,31070,34598],[27378,27379,34591,34592],
 [27380,28469,28750,31069,31359,34599],[27381,34912],
 [27383,34380],[27384,34555],[27385,34893],[27386,34732],
 [27387,34705],[27388,34852],
 [27389,27429,27443,28682,31162,34393,34428,34991],
 [27390,27428,28681,31161,34426,34992],
 [27391,27432,34425,34987],[27392,34989],
 [27394,27436,27450,34387,34422,34984],
 [27395,27437,34429,34986],[27399,34983],[27400,34990],
 [27401,34413],[27402,34376],[27403,34551],[27404,34889],
 [27405,34728],[27406,34701],[27407,34848],
 [27408,28792,31391,34925],
 [27409,27410,28791,28796,31388,31389,34921,34926],
 [27411,28797,31395,34923],[27412,28795,31387,34922],
 [27413,34918],[27414,28786,28790,31393,31396,34920],
 [27415,34919],[27416,28793,31390,34927],[27417,34916],
 [27418,34917],[27419,34924],[27423,28670,31151,34405],
 [27424,34404],[27427,28684,31159,34431],[27434,34432],
 [27440,34368],[27441,34367],[27444,28689,31163,34394],
 [27451,34395],[27456,34543],[27457,28290,31320,34542],
 [27458,28289,31173,34548],
 [27459,28297,28493,28863,31133,31376,31409,34568],
 [27460,28500,31134,34569],[27466,34562],[27467,34570],
 [27471,34727],[27472,28253,31321,34700],
 [27473,28252,31174,34847],
 [27474,28260,28523,28848,31038,31103,31426,34906],
 [27475,28530,31104,34907],[27481,34900],[27482,34908],
 [27488,28728,31497,34745],[27489,28729,31499,34746],
 [27490,28726,31501,34741],[27491,28727,31502,34743],
 [27492,34742],[27493,34738],[27494,34740],
 [27495,28735,31492,34739],[27496,34747],
 [27497,28733,31495,34736],[27498,34737],[27499,34744],
 [27501,28897,31331,34718],[27502,34719],
 [27503,28894,31334,34714],[27504,28893,31332,34716],
 [27505,33903,34715,36973],[27506,34711],
 [27507,28891,31336,34713],[27508,34712],[27509,34720],
 [27510,28900,31327,34709],[27511,34710],[27512,34717],
 [27514,34866],[27515,28882,31187,34861],[27517,34862],
 [27519,28879,31189,34860],[27521,34867],[27524,34864],
 [27526,27557,28904,28916,28926,28935,28957,31517,31527,31544,
   31552,31558,35073,35081],
 [27527,28914,28927,28958,31542,31545,31553,35090],
 [27528,27533,27556,28928,28956,31507,31535,35041,35058,35086],
 [27529,27531,27560,27561,28919,28930,31508,31540,35039,35049,
   35060,35068],[27534,27558,28921,31513,35051,35066],
 [27535,28913,28922,31523,31564,35093],
 [27536,27549,27580,28905,28941,28944,28952,31515,31528,31559,
   31561,35071,35074,35082],
 [27537,28915,28929,28942,28953,31530,31543,31554,31562,35091],
 [27538,27548,27579,28943,28951,31505,31536,35046,35056,35087],
 [27540,27554,28907,28939,28946,28950,31519,31520,31531,31533,
   35076,35080],
 [27541,27552,27569,27577,28909,28938,31510,31539,33911,33940,
   35037,35069,35077,35085,37155,37184],
 [27543,28936,31537,35042],[27544,28963,31514,35052],
 [27545,28964,31524,35094],[27550,27578,28911,31512,35036,35064]
  ,[27551,27564,27575,28961,31516,35059,35072,35083],
 [27559,28962,31538,35092],
 [27563,27566,27574,27582,28960,31506,35035,35044,35057,35088],
 [27565,27573,35034,35065],
 [27568,27572,33948,33952,35048,35062,37164,37178],
 [27583,35045],[27584,35067],[27585,35043],[27586,35053],
 [27587,35095],[27671,27681,27721,27731,30322,30332],
 [27753,27758,27769,30495,30500,30511],
 [27754,27762,27776,30501,30503,30517],
 [27755,27761,27777,30504,30514,30516],
 [27759,27763,27775,30496,30510,30518],
 [27764,27765,30520,30521],[27768,30505],[27770,30522],
 [27773,30515],[27778,30507],[27779,30506],[27780,30512],
 [27782,27783,27787,27792,30527,30528,30531,30533],
 [27850,27872,27896,27918,28999,29001,29098,29100,30373,30375,
   35107,35129],[27858,27904,28995,29094,30369,35115],
 [27859,27905,29006,29105,30380,35116],
 [27860,27906,29005,29104,30379,35117],
 [27865,27911,29007,29106,30381,35122],
 [27876,27879,27922,27925,29015,29017,29114,29116,30389,30391,
   35133,35136],
 [27934,27935,27937,27942,27952,30535,30536,30538,30543,30553],
 [27936,27938,27943,27953,30233,30265,30537,30539,30544,30554,
   32733,32745,32756,32765,36130,36141],
 [27940,27962,30546,30562],[27941,27954,27963,30550,30559,30561]
  ,[27945,27961,30541,30563],
 [27946,27957,30547,30558,32735,32764],
 [27947,27949,30549,30555],[27948,30548],
 [27950,29247,30566,32867],[27951,27964,29231,30552,30565,32876]
  ,[27956,30567],[27958,27960,30542,30564],[27965,30551],
 [27966,29237,30557,32877],[27967,27970,30575,30577],
 [27968,27969,27973,27978,30572,30573,30576,30578],
 [27971,27972,27975,27977,30569,30570,30574,30579],
 [27974,27976,30568,30571],[27995,28310,30653,31230],
 [28005,28032,28119,29409,29496,29679,30725,30840,30923,35384,
   35478,35748],[28038,28120,30736,30925],
 [28074,28344,30765,31253],[28080,28345,30776,31255],
 [28090,28155,28159,30841,30950,30958],
 [28160,28161,28563,30960,30961,31465],
 [28196,28198,28210,28212,28268,28269,28374,28474,28817,30843,
   30846,30990,30992,31110,31111,31270,31296,31400,37432,37434,
   37710,37745,37746,37905],
 [28197,28211,28231,30991,31018,31081],
 [28199,28380,30994,31303],[28214,31168],[28215,31294],
 [28233,28442,31083,31342],[28237,28506,31090,31420],
 [28238,28505,31091,31419],[28244,28456,31020,31056],
 [28246,31381],[28248,30849],[28265,31430],
 [28270,28441,31113,31341,37277,37545],[28271,31116],
 [28274,28476,31120,31403],[28275,28475,31121,31402],
 [28281,28282,28454,28457,28738,28800,30882,30883,31055,31058,
   31339,31401],[28283,31380],[28285,30848],
 [28295,28495,28857,31130,31370,31411],
 [28296,28492,28862,31132,31369,31407],
 [28299,28856,31374,31416],[28301,31406],[28302,31413],
 [28316,30654],[28351,30777],[28361,30767],[28385,30996],
 [28395,28703,30806,30986],[28408,28443,31272,31343],
 [28411,31277],[28412,28535,31279,31436],
 [28413,28534,31280,31435],[28418,31437],
 [28419,28455,29865,30845,31057,35414],[28421,31382],
 [28423,30850],[28424,31025],[28425,29742,31363,35757],
 [28426,31202],[28427,31175],[28428,31322],
 [28429,28556,28824,30862,31284,31447],
 [28432,28555,31288,31445],[28435,28552,28832,30863,31292,31442]
  ,[28440,31446],[28444,28445,31345,31346],[28450,31347],
 [28458,28460,28865,31196,31197,31317,33096,33097,33880,36811,
   36814,36892],[28459,31170],[28463,28748,31072,31353],
 [28464,28465,28747,28755,28910,28933,31071,31073,31354,31355,
   31555,31568],[28481,31122],[28484,31115],[28488,31114],
 [28491,31112],[28503,28853,31131,31378],[28511,31092],
 [28514,31085],[28533,28838,31040,31101],
 [28538,28543,28673,31139,31144,31274],[28540,31281],
 [28541,31049],[28542,31278],[28544,30879],[28545,30842],
 [28548,31194],[28558,31285],[28559,31293],
 [28561,28821,30864,31283],[28562,28822,30865,31290],
 [28565,28568,28646,30695,30696,31479],[28566,31150],
 [28570,31451],[28571,31385],[28572,30890],[28573,30853],
 [28574,31028],[28575,31366],[28576,31205],[28577,31178],
 [28578,31325],[28579,28611,28614,31469,31478,31489],
 [28580,28612,31471,31490],[28581,28608,31472,31485],
 [28582,28610,31473,31487],[28583,28609,31474,31486],
 [28584,28606,31476,31482],[28585,28607,31477,31484],
 [28586,31483,33733,37139],[28587,31491],[28588,31480],
 [28589,31481],[28590,31488],[28593,31149],
 [28595,28596,28716,31059,31061,31466],[28597,31450],
 [28598,31384],[28599,30889],[28600,30852],[28601,31027],
 [28602,31365],[28603,31204],[28604,31177],[28605,31324],
 [28613,31470],[28615,31467],[28616,31468],[28617,31475],
 [28677,31143],[28680,31141],[28692,31160],[28693,30816],
 [28717,31452],[28718,31386],[28720,30854],[28721,31029],
 [28722,31367],[28724,31179],[28725,31326],[28730,31498],
 [28731,31494],[28732,31496],[28734,31503],[28736,31493],
 [28737,31500],[28743,31053,37815,38124],[28746,31051],
 [28759,31383],[28760,30888],[28761,30851],[28762,31026],
 [28763,31364],[28764,31203],[28765,31176],[28766,31323],
 [28770,31460],[28773,28815,30900,31457],[28778,31461],
 [28779,30884],[28780,30847],[28781,31022],[28782,31360],
 [28783,31199],[28784,31172],[28785,31319],
 [28787,28788,31392,31397],[28789,28794,31394,31398],
 [28803,30881],[28812,30903],[28820,30844],[28829,30866],
 [28845,31041],[28849,31198],[28859,31371],[28860,31379],
 [28874,31218],[28877,31215],[28880,31190],[28887,31191],
 [28890,31188],[28892,31337],
 [28895,28901,31328,31333,33902,36972],[28896,31329],
 [28898,31330],[28899,31338],[28902,31335],
 [28906,28934,31529,31557],[28912,31522],
 [28918,28932,31547,31551],[28923,31565],[28937,31563],
 [28947,28955,31548,31556],[28965,31566],
 [29030,29035,29046,31674,31679,31690,32893,32895,32900,32910,
   38145,38174],[29031,29039,29053,31680,31682,31696],
 [29032,29038,29054,31683,31693,31695],
 [29041,29042,29055,31686,31699,31700,32898,32904,32905,32915,
   32917,32920],
 [29047,29056,31685,31701,31776,31782,31791,31792,32897,32902,
   32918,32919],[29050,31694,31785],[29057,31691,32906,32911],
 [29171,29173,29178,29188,29262,29264,29269,29279,35147,35149,
   35154,35164],
 [29174,29179,29190,29265,29270,29281,35150,35155,35166],
 [29175,29180,29196,29197,29266,29271,29287,29288,35151,35156,
   35172,35173],
 [29176,29193,29195,29198,29267,29284,29286,29289,35152,35169,
   35171,35174],
 [29181,29192,29272,29283,35157,35168,43485,43835,44182,44513,
   46657,46802,47741,48194,48540,48613,50264,51092],
 [29182,29183,29273,29274,35158,35159],[29194,29285,35170],
 [29202,29205,29209,29211,29293,29296,29300,29302,35178,35181,
   35185,35187],
 [29203,29204,29206,29207,29208,29210,29212,29213,29294,29295,
   29297,29298,29299,29301,29303,29304,33008,33009,33029,33030,
   33119,33120,33230,33283,33284,33456,33459,33475,33740,33802,
   33835,35179,35180,35182,35183,35184,35186,35188,35189,36363,
   36364,36527,36528,36566,36567,36660,36666,36700,36703,36719,
   36869,36984,37044,37046],
 [29217,29219,29224,29234,32847,32849,32854,32864],
 [29220,29225,29236,32850,32855,32866],
 [29221,29243,32856,32872],[29222,29244,32869,32871],
 [29226,29242,32851,32873],[29227,29238,32857,32868],
 [29228,32859],[29229,32858],[29230,32865],[29232,32875],
 [29235,32860],[29239,29241,32852,32874],[29240,32870],
 [29245,32862],[29246,32861],[29248,29251,32885,32887],
 [29252,29253,29256,29258,32879,32880,32884,32889],
 [29255,29257,32878,32881],
 [29310,29376,29437,31860,32134,35341,35529,35837],
 [29311,29375,29436,31861,32133,35342,35516,35836],
 [29314,29316,29368,29370,29517,29521,29632,29701,29707,29712,
   29948,30020,31814,31816,31868,31870,32017,32021,32132,32201,
   32207,32212,32448,32520,35199,35201,35253,35255,35402,35406,
   35517,35586,35592,35597,35833,35905],
 [29315,31867,32135,35838],[29317,31873,31954,31959,32092,35718]
  ,[29318,29362,31874,31941,31958,32055,35525,35688],
 [29319,29361,31875,31936,31957,32131,35518,35830],
 [29320,31834,31877,32137,32417,35841,37449,37830],
 [29321,31878,32136,35840],[29324,29456,29644,35261,35322,35747]
  ,[29326,29460,29652,29956,31835,31952,31962,32390,35205,35254,
   35332,35842],
 [29327,29329,29772,29779,29950,30065,31827,31829,32272,32279,
   32450,32565,35212,35214,35657,35664,35835,35950,37320,37324,
   37438,37444,37885,37932],[29328,29640,35247,35839],
 [29332,29333,29353,29354,29554,30159,31943,31944,32299,35531,
   35532,35625,35631,35834,36009],[29334,29452,35347,35802],
 [29335,29379,35527,35775],[29336,29378,35521,35832],
 [29337,29348,29386,29465,29654,31843,31882,31964,31973,32158,
   32462,35275,35353,35542,35851,35852],
 [29338,29466,29653,29664,29964,31842,31884,31971,31974,32159,
   32460,35226,35273,35274,35355,35853],
 [29339,29381,29383,29463,29969,31847,31885,31891,31967,31969,
   32155,32161,32459,35230,35357,35545,35548,35848],
 [29340,29343,29380,29382,29464,31848,31886,31890,31965,31968,
   32154,32157,32466,35358,35543,35547,35847,35850],
 [29341,29388,29968,31846,31887,32156,32458,35223,35549,35849],
 [29342,29384,29471,31889,31966,31970,32153,35359,35544,35845],
 [29344,29346,29387,29389,29470,29472,29660,35268,35348,35351,
   35538,35541,35843,35846],
 [29345,29663,29963,31844,32461,35224,35266,35854],
 [29347,29385,29467,29661,31883,31963,31972,32160,35276,35354,
   35540,35844],[29360,31876,31937,31956,32144,35519],
 [29363,29890,31947,31960,35220,35536,37436,37937],
 [29364,31946,31961,35535],[29367,29373,29454,35344,35477,35520]
  ,[29369,29377,29917,35219,35522,35537,37441,37939],
 [29372,29645,31872,32145,35257,35530],
 [29374,29441,31862,32140,35343,35440],
 [29390,29468,29657,29966,31840,31880,32162,32465,35233,35271,
   35350,35539],
 [29391,29469,29655,29959,29961,31839,31845,31881,32163,32463,
   32469,35229,35232,35270,35352,35546],
 [29395,29418,29477,31983,32169,35566,35859,35862],
 [29396,29417,29476,31984,32168,35567,35626,35861],
 [29398,29401,29489,29493,29667,29973,31898,31901,31989,31993,
   32167,32473,35283,35286,35374,35378,35552,35858],
 [29399,29491,29518,29708,31899,31991,32018,32208,35284,35376,
   35403,35593,37269,37352,37363,37553],
 [29400,31990,32170,35863],
 [29403,29404,29830,31997,31998,32056,32058,32166,32642,35689,
   35690,35855],
 [29405,29671,31906,32000,32172,32480,35386,35866,37681,37980],
 [29406,29411,29500,29672,29677,29980,31905,32001,32171,32481,
   35291,35385,35387,35557,35865,35867,37686,37982],
 [29410,29414,29528,29534,29975,30022,31910,31914,32028,32034,
   32475,32522,35295,35299,35413,35419,35860,35907,37237,37239,
   37682,37689,37860,37975],
 [29412,29482,29678,29773,31912,31982,32178,32273,35297,35367,
   35563,35658,37322,37392,37588,37683],
 [29415,29490,29494,35488,35555,35569,37678,37718],
 [29419,29492,29687,29918,31992,32187,35304,35377,35572,35803,
   37695,37805],[29420,29421,30204,35776,35779,35857],
 [29422,29423,29428,29505,29506,29514,29688,29689,29694,29985,
   29986,29994,31923,31927,31928,31930,32005,32007,32013,32014,
   32189,32193,32194,32196,32485,32487,32493,32494,35312,35314,
   35315,35392,35397,35398,35578,35580,35581,35872,35877,35878],
 [29424,29425,29503,29504,30229,30250,31932,31933,32008,32009,
   32190,32192,32484,32491,32746,32751,32774,32794,35582,35583,
   35873,35875,36160,36177],
 [29426,29511,31931,32010,32191,32483,35584,35874],
 [29427,29430,29507,29513,29693,29696,29987,29993,31922,31929,
   32006,32012,32188,32195,32486,32492,35308,35313,35390,35399,
   35574,35579,35870,35879],
 [29429,29512,29695,29992,35307,35391,35573,35871],
 [29431,29510,35576,35868],
 [29432,29433,29508,29509,29690,29692,29984,29991,30246,30251,
   30274,30294,31924,31925,32003,32004,32197,32198,32488,32490,
   32729,32750,32775,32792,35317,35318,35393,35394,35575,35577,
   35869,35876,36131,36136,36159,36179],
 [29443,29444,29799,31832,31833,31853,31854,32054,32146,32147,
   32240,32246,32449,32624,32659,35328,35329,35684],
 [29446,31864,32150,35346],[29447,29642,31863,32151,35264,35345]
  ,[29455,31955,33048,33321,35340,36292,36565,37624],
 [29457,29631,31819,32445,35260,35321],
 [29458,29555,29954,31818,32303,35213,35259,35326],
 [29459,29592,29953,31817,32333,35200,35258,35339],
 [29461,35331],[29462,31869,32152,35337],
 [29473,29658,29962,31837,32467,35228,35267,35349],
 [29474,29656,29659,29958,29960,31838,31841,31888,32164,32464,
   32468,35227,35231,35269,35272,35356],
 [29483,31918,31977,32181,32474,35554],
 [29484,31917,31976,32182,32241,35553,37688,37979],
 [29486,29487,29889,29891,29894,29972,31986,31987,32185,32186,
   32389,32690,35305,35306,35570,35571,36075,36089,37694,37696,
   37831,37832,37952,38101],
 [29495,29680,31995,32180,35380,35565],
 [29497,29498,29556,29558,29666,30142,31903,31904,32304,32305,
   32330,32470,35382,35383,35441,35443,35551,36027],
 [29499,29593,31902,32334,35381,35564],
 [29501,29502,29981,29982,31911,32002,32177,32482,35290,35296,
   35556,35562,37680,37981],
 [29515,29516,32202,32203,35908,35909],
 [29519,29710,32019,32210,33069,33155,33350,35404,35595,36313,
   36399,36594],[29520,32204,32209,35910],
 [29522,29524,29800,32036,32038,32068,32071,32094,32095,32200,
   32215,32217,32521,32625,32643,35720,35721,35880],
 [29523,32037,32057,32216,32243,35691],
 [29525,32206,32219,35913],
 [29526,29540,32205,32220,35778,35912,37279,37562],
 [29529,29535,29713,35490,35603,35750],
 [29530,32030,35415,37217,37232,37265,37358],
 [29531,29539,35805,35914,37236,37867],
 [29532,29775,32032,32275,35417,35660,37223,37233,37276,37307,
   37317,37398],[29533,29709,35589,35911],
 [29536,29538,29594,29595,29700,30143,32022,32024,32300,32335,
   32336,32495,35453,35456,35600,35602,35906,36010],
 [29537,29557,32023,32306,35601,35628],[29541,35904],
 [29542,29544,29723,32048,32052,32224,32227,32531,32534,35617,
   35920,35924],
 [29543,29545,29722,32047,32053,32226,32228,32532,32538,35616,
   35922,35925],
 [29546,29730,32051,32225,32229,32530,35618,35921],
 [29547,29726,30038,32045,32222,32231,32537,35438,35613,35917],
 [29548,29724,30031,32044,32223,32232,32535,35437,35612,35919],
 [29549,29551,29729,35610,35915,35918],
 [29550,32049,32533,35926],
 [29552,29727,30034,32042,32539,35433,35609,35916],
 [29553,29728,30032,32043,32540,35432,35611,35923],
 [29559,32268,32308,35952],[29560,32098,32311,35727],
 [29562,29844,32236,32313,35694,35886],
 [29563,32315,32332,36030],[29564,32316,32331,36029],
 [29565,29602,29648,29649,35215,35216,35243,35256],
 [29566,29683,29979,35298,35301,35366],
 [29567,29610,35495,35756],
 [29568,29571,29715,29717,30021,30125,35421,35423,35479,35480,
   35585,36028],[29569,29614,35810,36031],
 [29570,29782,35630,35666],[29572,35991],
 [29573,29604,35496,35755],[29574,35459],
 [29575,29613,35634,35971],[29576,35972],
 [29577,29606,35811,36014],[29578,30177,35784,35928],
 [29579,30176,35781,35931],
 [29580,29619,30166,30184,32320,32353,35647,35982,36020,36041],
 [29581,29620,30165,32322,32354,35645,36022,36042],
 [29582,29617,30169,30181,32323,32350,35644,35985,36024,36037],
 [29583,29618,30180,32324,32352,35983,36025,36039],
 [29584,30168,32325,32351,35642,36038],
 [29585,30173,32327,32348,35641,36034],
 [29586,30174,30178,32328,32349,35648,35987,36036],
 [29587,29626,30172,35640,36015,36035],
 [29588,30167,35646,36043],[29589,29624,30187,35978,36018,36032]
  ,[29590,36033],[29591,36040],[29596,32267,32338,35951],
 [29597,32097,32341,35726],[29598,29872,32060,32342,35627,35696]
  ,[29599,29843,32235,32343,35620,35885],
 [29600,32302,32345,36013],[29601,32301,32346,36012],
 [29603,29684,29978,35285,35300,35379],
 [29605,29718,35420,35598],
 [29607,29608,29780,29783,30064,30126,35492,35493,35665,35668,
   35949,36011],[29609,35990],[29611,35458],
 [29615,30162,35629,35783],[29616,30161,35623,35930],
 [29621,30183,32321,32355,35980,36021],
 [29622,30188,32318,32357,35979,36017],
 [29623,30163,30189,32319,32358,35649,35986,36019],
 [29625,30182,35984,36026],[29627,36016],[29628,36023],
 [29633,31811,32451,35246],[29634,29862,31810,32452,35209,35245]
  ,[29635,29833,31815,32453,35202,35252],
 [29636,31821,32455,35263],[29637,31820,32456,35262],
 [29646,29647,29740,29746,29949,30124,35217,35218,35238,35239,
   35439,36044],[29650,35249],
 [29651,29957,31879,32142,35211,35248,37615,37630],
 [29662,29965,29967,35222,35225,35265],
 [29668,31896,32476,35369],[29669,31895,32477,35368],
 [29670,31900,31915,31994,32103,32184,32478,35375],
 [29681,29974,35303,35362],[29682,29741,35302,35361,37684,37777]
  ,[29685,29686,30190,31920,31921,32391,32394,32472,32704,35371,
   35372,35774],
 [29697,29698,29988,29990,30275,30292,35309,35310,35388,35389,
   36114,36135],[29702,32016,32523,35588],
 [29703,32015,32524,35587],[29704,32020,32525,35594],
 [29705,32026,32527,35605],[29706,32025,32528,35604],
 [29711,35606],[29714,32214,35599],[29716,29743,35422,35442],
 [29719,35591],[29720,35590,37230,37866],[29721,35596],
 [29725,30030,30041,32046,32230,32233,32536,35435,35436,35614],
 [29731,30037,35430,35607],[29732,30035,35429,35608],
 [29733,30033,30036,32050,32541,35431,35434,35615],
 [29734,32269,32497,35953],[29735,32099,32500,35728],
 [29736,32062,32501,35698],[29737,32237,32502,35887],
 [29738,32361,32504,36046],[29739,32360,32505,36045],
 [29744,36047],[29745,29781,35455,35667,37319,37773],
 [29747,35992],[29749,35460],[29750,35635],[29751,35973],
 [29752,35812],[29753,35785],[29754,35932],
 [29755,30150,32382,32509,35472,36057],
 [29756,30149,32383,32511,35470,36058],
 [29757,30153,32379,32512,35469,36053],
 [29758,32381,32513,36055],[29759,30152,32380,32514,35467,36054]
  ,[29760,30157,32377,32516,35466,36050],
 [29761,30158,32378,32517,35473,36052],
 [29762,30156,35465,36051],[29763,30151,35471,36059],
 [29764,36048],[29765,36049],[29766,36056],
 [29767,32096,32566,35723],[29768,32059,32567,35693],
 [29769,32234,32568,35882],[29770,32271,32570,35956],
 [29771,29776,30070,32270,32571,35656,35955,35957],
 [29774,29778,35752,35954],
 [29785,32285,32395,33286,35780,36530,37402,37597],
 [29787,29788,29793,30075,30076,30084,32288,32292,32293,32295,
   32575,32577,32583,32584,35677,35679,35680,35962,35967,35968],
 [29790,29791,30073,30081,30236,30259,32290,32291,32296,32298,
   32573,32579,32580,32581,32736,32759,32780,32793,35681,35683,
   35964,35965,36165,36178],
 [29792,29795,30077,30083,32287,32294,32576,32582,35673,35678,
   35960,35969],[29794,30082,35672,35961],
 [29796,29798,30079,30080,30280,30293,35675,35676,35958,35966,
   36121,36144],
 [29797,30078,31793,31796,31800,31802,33078,33175,33269,35674,
   35959,36416,36599,36754],[29801,32101,32627,35731],
 [29802,32100,32628,35730],[29803,31828,32454,35203],
 [29806,35408],[29807,35732],[29808,35653],[29809,35729],
 [29810,35725],[29811,35483],[29813,32309,32344,35621],
 [29814,32314,32339,35724],[29815,35717],[29816,35716],
 [29817,35722],[29818,32122,32594,32632,32688,35742],
 [29819,32123,32601,32634,32689,35743],
 [29820,32119,32597,32635,32684,35738],
 [29821,32121,32595,32636,32683,35740],
 [29822,32120,32637,35739],[29823,32117,32600,32639,32681,35735]
  ,[29824,32118,32598,32640,32680,35737],[29825,35736],
 [29826,35744],[29827,35733],[29828,32602,32678,35734],
 [29829,32603,32679,35741],[29831,32064,32644,35701,37838,38000]
  ,[29832,32063,32645,35700],
 [29835,29836,29995,35407,35409,35685],[29837,35702],
 [29838,35652],[29840,35695],[29841,35482],
 [29842,32242,32372,35445],[29845,35687],
 [29846,29876,35686,35881],[29847,29875,35692,35777],
 [29848,29883,32085,32256,32649,32673,35712,35896],
 [29849,32086,32263,32651,32674,35713],
 [29850,29880,32082,32259,32652,32669,35708,35899],
 [29851,29879,32084,32257,32653,32668,35710,35897],
 [29852,32083,32654,35709],[29853,32080,32262,32656,32666,35705]
  ,[29854,29877,32081,32260,32657,32665,35707,35901],
 [29855,35706],[29856,35714],[29857,29886,35703,35892],
 [29858,32264,32663,35704],[29859,32265,32664,35711],
 [29860,32239,32660,35890],[29861,32238,32661,35889],
 [29864,29869,29999,35749,35754,35884],[29866,35891],
 [29867,35659],[29874,35804],
 [29878,32088,32261,32658,32667,35902],
 [29881,32258,32670,35898],[29882,32087,32255,32650,32672,35894]
  ,[29884,35895],[29885,35903],[29887,32089,32647,35893],
 [29888,32090,32648,35900],[29892,35760],[29893,35425],
 [29896,36061],[29897,32424,32609,35995,37834,38019],
 [29898,35500],[29899,35463],[29900,35638],[29901,35976],
 [29902,35815],[29903,35788],[29904,35935],
 [29905,32437,32694,36099],[29906,32438,32696,36100],
 [29907,32434,32697,36095],[29908,32436,32698,36097],
 [29909,32435,32699,36096],[29910,32432,32701,36092],
 [29911,32433,32702,36094],[29912,36093],[29913,36101],
 [29914,36090],[29915,36091],[29916,36098],[29919,35759],
 [29920,35424],[29921,29922,30042,35669,35671,36076],
 [29923,36060],[29924,35994],[29925,35499],[29926,35462],
 [29927,35637],[29928,35975],[29929,35814],[29930,35787],
 [29931,35934],[29932,32410,32707,36086],
 [29933,30203,30216,32411,32558,32709,32721,35798,35825,36087],
 [29934,32407,32710,36082],[29935,32409,32711,36084],
 [29936,32408,32712,36083],[29937,32405,32714,36079],
 [29938,32406,32715,36081],[29939,36080],[29940,36088],
 [29941,36077],[29942,36078],[29943,36085],
 [29945,29951,35196,35204],[29947,29955,35206,35221],
 [29952,31824,32362,35195],[29976,35281],[29977,35280],
 [29996,30127,35486,35761],[29997,35654],[30000,35484],
 [30001,35447],[30002,35622],[30003,35753],
 [30004,30045,35501,35746],[30005,35745],
 [30006,35751,37726,37741],[30007,30094,30132,35507,35771,36073]
  ,[30008,30093,30133,35509,35772,36072],
 [30009,30130,35511,35767],[30010,30131,35512,35769],
 [30011,35768],[30012,35764],[30013,35766],
 [30014,30100,30139,35502,35765,36066],[30015,35773],
 [30016,30137,35505,35762],[30017,35763],[30018,35770],
 [30019,35426],[30023,35401],[30024,35400],
 [30025,30026,35405,35418],[30027,32040,32393,35411,37362,37372]
  ,[30028,35410],[30029,32211,32221,35416,37245,37800],
 [30039,35427],[30040,35428],[30043,36062],[30044,35996],
 [30046,35464],[30047,35639],[30048,35977],[30049,35816],
 [30050,35789],[30051,35936],
 [30052,30194,32553,32727,35822,36111],
 [30053,30195,35824,36112],[30054,30192,35826,36107],
 [30055,30193,35827,36109],[30056,36108],
 [30057,32552,32726,36104],[30058,32413,32716,36106],
 [30059,30201,35817,36105],[30060,36113],
 [30061,30199,35820,36102],[30062,36103],[30063,36110],
 [30066,35481],[30067,35444],[30068,35619],[30069,35663],
 [30071,30072,32276,32572,35655,35661],[30085,35993],
 [30086,35498],[30087,35461],[30088,35636],[30089,35974],
 [30090,35813],[30091,35786],[30092,35933],
 [30095,30136,35506,36068],[30096,36070],
 [30097,30135,35504,36069],[30098,30140,35503,36065],
 [30099,30141,35510,36067],[30101,30134,35508,36074],
 [30102,36063],[30103,36064],[30104,36071],[30105,35494],
 [30106,35457,37234,37772],[30107,35632],[30108,35970],
 [30109,30110,35782,35809,37807,38020],[30111,35929],
 [30112,30113,30114,30118,32613,32614,32616,32617,32618,32622,
   36001,36002,36006,36007],[30115,32620,32623,36004],
 [30116,32612,32621,36003],[30117,35999],[30119,36000],
 [30120,32615,32619,36008],[30121,35997],[30122,35998],
 [30123,36005],[30128,35485],[30129,35491],[30138,35513],
 [30144,35449],[30145,35448],[30146,32366,32506,35454],
 [30147,32387,32508,35474],[30148,32388,32515,35475],
 [30154,35468],[30155,35476],[30160,35624],
 [30164,32326,32359,35650],[30170,35643],[30171,35651],
 [30175,35808],[30179,32329,32356,35988],[30185,35981],
 [30186,35989],[30196,35823],[30197,35819],[30198,35821],
 [30200,35828],[30202,35818],[30205,30223,35799,35941],
 [30206,35800],[30207,30220,35795,35944],
 [30208,30219,35797,35942],[30209,32412,32708,35796],
 [30210,35792],[30211,30217,35794,35946],[30212,35793],
 [30213,35801],[30214,30226,35790,35937],[30215,35791],
 [30218,35947],[30221,35943],[30222,35939],[30224,35940],
 [30225,35948],[30227,35938],[30228,35945],
 [30230,30261,32742,32752,32783,36154,36162],
 [30231,30240,30253,30284,32740,32753,32767,32770,32778,32784,
   36152,36155,36163,36171],
 [30232,30260,32732,32754,32760,32782,36139,36167],
 [30235,30245,30256,30264,36118,36120,36149,36150],
 [30237,30254,30282,36117,36122,36145],
 [30238,32738,32747,36132],[30239,32748,36174],
 [30241,32755,32768,32779,36172],
 [30242,30252,30283,32730,32761,32769,32777,36127,36137,36168],
 [30247,30262,36123,36147],[30248,32739,32789,36133],
 [30249,32749,32790,36175],
 [30255,30268,30279,32741,32787,36140,36153,36164],
 [30263,32763,32788,36173],
 [30267,30270,30278,32731,32786,36125,36138,36169],
 [30269,30277,36115,36146],[30272,30276,36129,36143],
 [30273,30281,36158,36166],[30286,36116],[30287,36126],
 [30288,36148],[30289,36124],[30290,36134],[30291,36176],
 [31760,31761,31763,31768,31778],[31766,31771,31787,31788],
 [31773,31774],[31777,31790],
 [31794,31795,31797,31798,31799,31801,31803,31804,33006,33007,
   33034,33047,33121,33126,33241,33246,33324,33421,33457,33458,
   36251,36278,36365,36370,36485,36490,36522,36568,36569,36665,
   36701,36702],[31826,32457],[31836,32447],[32031,32529],
 [32033,32526],[32035,32105,32213,32218],
 [32039,32420,37357,37370],[32041,32519],[32069,32646],
 [32070,32245,32281,32282,37406,37409,37503,37589],
 [32072,32606],[32073,32111],[32074],
 [32075,32249,37523,37996],[32076,32587],
 [32077,32426,37833,38085],[32078,32399],[32079,32546],
 [32091,32655],[32104,32370],[32106,32629],
 [32107,32108,32280,32283,32564,32626],[32109,32605],[32110],
 [32113,32586],[32114,32425],[32115,32398],[32116,32545],
 [32124,32593,32633,32687],[32125,32599,32641,32682],
 [32126,32630],[32127,32631],[32128,32638],[32244,32662],
 [32247,32607],[32250,37520],[32251,32588],[32252,32427],
 [32253,32400,37516,38039],[32254,32547],[32266,32671],
 [32274,32367],[32278,32569],
 [32284,32286,32421,32422,32542,32691],[32307,32347],
 [32310,32340],[32317,32337],
 [32364,32369,32499,37774,37779,37909],[32374,32419],
 [32375,32392],[32376,32496],[32384,32510],[32385,32518],
 [32386,32507],[32396,32676],[32397,32610],[32401,32591],
 [32402,32430],[32403],[32404,32550],[32414,32705],
 [32415,32706],[32416,32713],[32423,32675],[32428,32590],
 [32429],[32431,32549],[32439,32695],[32440,32703],
 [32441,32692],[32442,32693],[32443,32700],[32543,32677],
 [32544,32611],[32548,32592],[32551],[32554,32722],
 [32555,32724],[32556,32723],[32557,32719],[32559,32720],
 [32560,32728],[32561,32717],[32562,32718],[32563,32725],
 [32585,32608],[32589],[32596,32685],[32604,32686],[32737],
 [32762],[32791],[32896,32901,32912],[32907,32922],
 [32908,32921],[32913,32923],[32916],
 [32925,32926,32928,32929,32930,32932,32934,32935],
 [32986,32994,33000,33004,33132,33134,33231,33235,33310,33316,
   33320,33444,33454,33543,33743,36280,36282,36294,36296,36357,
   36361,36479,36694,36723,36728,36782,36872,36874,36987,36989],
 [32987,33309,36281,36871],
 [32989,32999,33042,33073,33083,33088,33164,33449,36233,36243,
   36286,36317,36327,36332,36408,36693],
 [32991,33049,33130,33311,33514,36287,36379,36512,36687,36873],
 [32993,33135,33268,36293,36374,36753],
 [32995,33133,33307,36295,36356,36865],
 [32996,33313,36297,36876],[32997,33312,36298,36875],
 [33001,33028,33116,33203,33208,33317,33451,36245,36272,36360,
   36447,36452,36561,36695],[33002,33011,36810,36877],
 [33003,33005,33448,33455,33626,33741,36247,36249,36692,36699,
   36870,36985],[33010,36837],[33012,36867],
 [33013,33149,33334,33638,36263,36302,36384,36887],
 [33014,33150,33335,33340,33636,33640,36261,36262,36304,36308,
   36391,36888],
 [33015,33057,33067,33145,33331,33635,33645,36265,36267,36305,
   36387,36581,36583,36883],
 [33016,33056,33066,33144,33333,33642,36268,36306,36385,36574,
   36582,36885],
 [33017,33064,33332,33634,33644,36258,36266,36307,36584,36884],
 [33018,33060,33142,33147,33329,36309,36390,36394,36579,36880],
 [33019,33024,33058,33062,33140,33141,33330,36310,36388,36393,
   36577,36578,36882,36886],[33020,36881],
 [33021,33339,33637,33639,36259,36264,36301,36889],
 [33022,33063,36576,36878],
 [33023,33059,33061,33139,33143,33337,36311,36389,36392,36575,
   36580,36879],
 [33036,33052,33113,33479,33484,33630,33745,36238,36248,36376,
   36554,36564,36688,36698],
 [33037,33051,33112,36377,36551,36553],
 [33038,33050,33117,33450,33538,33628,36230,36244,36378,36475,
   36560,36787],[33039,33123,36380,36571],
 [33040,33122,36381,36570],[33043,36555],[33045,36572],
 [33053,36557],[33054,36556],[33055,33633,36246,36562],
 [33065,33146,36386,36573],[33071,33345,36403,36897],
 [33072,33279,33344,33360,36335,36404,36414,36896],
 [33074,33077,33165,33169,33343,33649,36318,36321,36409,36413,
   36587,36893],
 [33075,33167,33194,33384,36319,36411,36438,36628],
 [33076,33091,33093,33152,33160,33170,33346,33358,33417,33652,
   33654,36316,36320,36337,36396,36410,36523,36588,36602,36604,
   36661,36898],
 [33079,33080,33173,33174,33232,33234,33322,33323,33342,33416,
   33422,33506,33625,33800,33818,36252,36253,36273,36274,36417,
   36418,36474,36476,36478,36586,36724,36725,36890,37062,37079],
 [33081,33348,36420,36901],[33082,33347,36421,36900],
 [33085,33172,33355,36419,36513,36783],[33087,36902],
 [33089,33351,36405,36899],[33092,33157,33161,36486,36595,36603]
  ,[33094,33153,33159,36589,36601,36894],[33095,36838],
 [33098,33189,33369,33663,36348,36425,36609,36912],
 [33099,33190,33370,33661,33670,36347,36350,36427,36616,36913],
 [33100,33101,33108,33109,33179,33180,33184,33185,33366,33368,
   33660,33667,33905,33922,33926,33927,33950,33970,36352,36353,
   36428,36429,36610,36612,36617,36618,36904,36908,36910,36911,
   37166,37171,37194,37195,37212,37214],
 [33102,33187,33367,33659,36351,36430,36619,36909],
 [33103,33182,33183,33364,33372,36432,36434,36614,36615,36905],
 [33104,33181,33365,36433,36613,36907],[33105,36906],
 [33106,33662,33669,36343,36349,36914],
 [33107,33186,36611,36903],[33128,33632,36240,36382],
 [33131,36375],[33136,36367],[33137,36366],
 [33138,33328,36289,36372],[33148,33336,36303,36383],
 [33158,33354,36402,36598],[33162,33163,33565,36605,36606,37110]
  ,[33166,36590],[33171,33356,36415,36600],[33176,36592],
 [33177,36591],[33178,36597],[33188,33371,36426,36608],
 [33195,33206,33386,36439,36450,36630],
 [33198,33200,33212,33214,33270,33271,33376,33476,33819,36488,
   36491,36635,36637,36755,36756,36915,36941,37045],
 [33199,33205,33211,33213,33233,33389,33392,33419,33541,36449,
   36457,36477,36525,36636,36638,36663,36726,36785],
 [33201,33382,36639,36948],[33202,33381,36640,36947],
 [33207,33216,36813,36949],[33215,36840],[33217,36939],
 [33218,33222,33228,33401,33403,33406,33706,33710,36468,36471,
   36644,36649,36653,36951,36956,36959],
 [33219,33229,33404,33708,36467,36646,36958,36960],
 [33220,33224,33399,33400,33707,36472,36647,36652,36954,36955],
 [33221,33223,33398,33402,33714,36473,36648,36651,36952,36957],
 [33225,36953],[33226,33408,33709,33711,36464,36469,36643,36961]
  ,[33227,33405,33715,36462,36645,36950],
 [33236,33274,33485,36731,36762,36764],
 [33238,33412,33544,33546,36524,36733,36921,36923],
 [33239,33508,36735,37065],[33240,33507,36736,37064],
 [33242,33359,36336,36401],[33243,33515,36734,36791],
 [33244,33247,33391,33393,33697,33801,36456,36458,36514,36515,
   36620,37063],[33245,37066],[33248,37026],
 [33249,33251,33418,33425,33518,33548,33677,33762,33764,36480,
   36482,36495,36531,36533,36662,36669,36671,36792],
 [33250,36494],[33252,37007],[33253,36846],[33254,36819],
 [33255,36966],
 [33256,33529,33773,33811,33842,36539,36682,36740,37076,37104],
 [33257,33530,33841,36680,36742,37077],
 [33258,33526,33845,36679,36743,37072],
 [33259,33528,36744,37074],
 [33260,33527,33769,33809,33844,36544,36677,36745,37073,37107],
 [33261,33524,33849,36676,36747,37069],
 [33262,33525,33850,36683,36748,37071],
 [33263,33848,36675,37070],[33264,33843,36681,37078],
 [33265,37067],[33266,37068],[33267,37075],
 [33272,33443,36758,36986],[33273,36761],
 [33275,33411,36763,36920],[33276,33478,36765,37048],
 [33277,33477,36766,37047],[33280,33427,36790,37008],
 [33282,33483,36767,37049],[33285,37025],
 [33287,33679,36493,36788],[33289,37006],[33290,36845],
 [33291,33492,36751,36818],[33292,36965],
 [33293,33499,33857,36770,37020,37059],
 [33294,33500,33856,36772,37018,37060],
 [33295,33496,33860,36773,37017,37055],
 [33296,33498,36774,37057],[33297,33497,33859,36775,37015,37056]
  ,[33298,33494,33864,36777,37014,37052],
 [33299,33495,33865,36778,37021,37054],
 [33300,33501,33863,36771,37013,37053],
 [33301,33502,33858,36779,37019,37061],[33302,37050],
 [33303,33504,33854,36769,37022,37051],[33304,37058],
 [33318,33327,36283,36299],[33326,36284],
 [33338,33641,36260,36300],[33353,36422],
 [33357,33650,36338,36397],[33361,33362,33866,36406,36407,36809]
  ,[33373,33374,33664,33666,33951,33968,36344,36345,36423,36424,
   37149,37170],[33375,33665,36346,36431],
 [33387,33396,36625,36641],[33390,36634],[33395,36626],
 [33397,33705,36451,36631],[33407,33713,36465,36642],
 [33409,33712,33717,36466,36470,36650],
 [33410,33445,36917,36988],[33413,36922],
 [33414,33537,36924,37081],[33415,33536,36925,37080],
 [33420,37082],[33423,33781,33783,36529,36667,37027],
 [33428,36847],[33429,36820],[33430,36967],
 [33431,33558,33826,36507,36929,37092],
 [33432,33559,33825,36505,36931,37093],
 [33433,33555,33829,36504,36932,37088],
 [33434,33557,36933,37090],[33435,33556,33828,36502,36934,37089]
  ,[33436,33553,33833,36501,36936,37085],
 [33437,33554,33834,36508,36937,37087],
 [33438,33832,36500,37086],[33439,33686,33827,36506,36804,37094]
  ,[33440,37083],[33441,37084],[33442,37091],
 [33446,33447,36990,36991],[33452,36992],
 [33460,33462,33867,36841,36842,36962],
 [33463,33468,33753,36713,36995,37002],
 [33464,33469,33751,36712,36997,37003],
 [33465,33750,36717,36998],
 [33466,33467,33749,33757,33912,33935,36716,36718,36999,37000,
   37200,37213],[33470,36996],[33471,33752,36714,37004],
 [33472,33474,33755,33756,33956,33969,36710,36711,36993,37001,
   37156,37179],[33480,33481,33646,36323,36324,36750],
 [33486,36760],[33487,33489,33520,36518,36656,36729],
 [33491,36752],[33493,36757],[33503,36768],
 [33505,33855,36776,37023],[33509,33629,36235,36237],
 [33510,33539,36322,36329],[33511,33512,33671,36442,36444,36720]
  ,[33513,36737],[33516,36730],[33517,36517],[33519,36655],
 [33521,36722],[33522,36721],[33523,33805,36526,36727],
 [33531,36741],[33532,36749],[33533,36738],
 [33534,33839,36684,36739],[33535,33840,36685,36746],
 [33540,33545,33675,36784,36789,36919],[33542,36926],
 [33550,36839],[33551,36812],[33552,36916],[33560,36930],
 [33561,36938],[33562,36927],
 [33563,33688,33823,36509,36799,36928],
 [33564,33824,36510,36935],[33566,36255],
 [33567,33570,33648,36340,36341,37124],[33568,36795],
 [33569,36460],[33571,36705],[33572,37096],[33573,37030],
 [33574,36535],[33575,36498],[33576,36673],[33577,37011],
 [33578,36850],[33579,36823],[33580,36970],
 [33581,33613,37114,37134],[33582,33614,37116,37135],
 [33583,33610,37117,37130],[33584,33612,37118,37132],
 [33585,33611,37119,37131],[33586,33608,37121,37127],
 [33587,33609,37122,37129],[33588,37128],[33589,37136],
 [33590,37125],[33591,37126],[33592,37133],[33593,36254],
 [33594,36339],[33595,36794],[33596,36459],
 [33597,33598,33718,36704,36706,37111],[33599,37095],
 [33600,37029],[33601,36534],[33602,36497],[33603,36672],
 [33604,37010],[33605,36849],[33606,36822],[33607,36969],
 [33615,37115],[33616,37123],[33617,37112],[33618,37113],
 [33619,37120],[33621,36239],[33623,36256],[33627,36231],
 [33631,36241],[33643,36257],[33653,36315],[33655,36333],
 [33656,36326],[33657,36325],[33658,36331],[33668,36342],
 [33672,36796],[33673,36689],[33676,36519],[33678,36657],
 [33680,36781],[33681,36780],[33682,36786],[33683,36806],
 [33684,36807],[33685,36802],[33687,36803],[33689,36801],
 [33690,36800],[33691,36808],[33692,36797],[33693,36798],
 [33694,36805],[33695,36461],[33703,36446],[33704,36445],
 [33716,36463],[33719,37097],[33720,37031],[33721,36536],
 [33722,36499],[33723,36674],[33724,37012],[33725,36851],
 [33726,36824],[33727,36971],[33728,37146],[33729,37147],
 [33730,37142],[33731,37144],[33732,37143],[33734,37141],
 [33735,37140],[33736,37148],[33737,37137],[33738,37138],
 [33739,37145],[33742,36516],[33744,36654],[33746,36691],
 [33747,36690],[33748,36696],[33758,36707],[33759,36708],
 [33760,36715],[33761,37028],[33763,36496],[33765,37009],
 [33766,36848],[33767,36821],[33768,36968],
 [33770,33808,36542,37108],[33771,33812,36541,37103],
 [33772,37105],[33774,33816,36538,37100],
 [33775,33817,36545,37102],[33776,33815,36537,37101],
 [33777,33810,36543,37109],[33778,37098],[33779,37099],
 [33780,37106],[33782,36492],[33784,37005],[33785,36844],
 [33786,36817],[33787,36964],[33788,33792,37038,37041],
 [33789,33790,37037,37042],[33791,33796,37039,37043],
 [33793,37034],[33794,37036],[33795,37035],[33797,37032],
 [33798,37033],[33799,37040],[33803,36521],[33804,36520],
 [33806,36546],[33807,36547],[33813,36540],[33814,36548],
 [33820,36484],[33821,36483],[33822,36489],[33830,36503],
 [33831,36511],[33836,36659],[33837,36658],[33838,36664],
 [33846,36678],[33847,36686],[33851,36843],[33852,36816],
 [33853,36963],[33861,37016],[33862,37024],[33868,36861],
 [33869,36862],[33870,36857],[33871,36859],[33872,36858],
 [33873,36854],[33874,36856],[33875,36855],[33876,36863],
 [33877,36852],[33878,36853],[33879,36860],[33881,36834],
 [33882,36835],[33883,36830],[33885,36831],[33886,36827],
 [33887,36829],[33888,36828],[33889,36836],[33891,36826],
 [33892,36833],[33893,36981],[33894,36982],[33895,36977],
 [33896,36979],[33897,36978],[33898,36974],[33899,36976],
 [33900,36975],[33901,36983],[33904,36980],
 [33906,33918,33928,33937,33959,37162,37172,37189,37197,37203],
 [33907,33943,33946,33954,37160,37173,37204,37206],
 [33908,33936,37174,37202],[33909,33941,37165,37176],
 [33913,37157],[33914,37167],[33915,33924,37168,37209],
 [33916,33929,33960,37187,37190,37198],
 [33917,33931,33944,33955,37175,37188,37199,37207],
 [33920,33934,37192,37196],[33921,33932,37153,37185],
 [33923,37158],[33925,37210],[33930,33958,37152,37180],
 [33938,37182],[33939,37208],[33945,33953,37150,37181],
 [33949,33957,37193,37201],[33962,37151],[33963,37161],
 [33964,37183],[33965,37159],[33966,37169],[33967,37211],
 [37215,37216,37259,37260,37261,37344,37348,37349,37539,37548,
   37549,37854],
 [37218,37219,37266,37267,37302,37304,37345,37359,37361,37385,
   37388,37390,37540,37575,37583,37586,37856,37881],
 [37220,37862],[37221,37861],[37225,37863],[37228,37713],
 [37229,37855],[37231,37865],[37238,37864],
 [37241,37268,37475,37558],
 [37242,37243,37263,37264,37464,37556,37557,37650,37656,37859,
   38034,38069],[37244,37827],[37246,37857],[37247,37877],
 [37248,37251,37298,37574,37874,37878],
 [37249,37255,37291,37573,37873,37879],
 [37250,37290,37572,37875],[37252,37294,37381,37384,37569,37870]
  ,[37253,37292,37374,37383,37568,37872],[37254,37871],
 [37256,37297,37566,37868],
 [37257,37295,37301,37377,37379,37565,37571,37869],
 [37258,37296,37300,37375,37378,37564,37567,37876],
 [37270,37544],[37271,37543],[37272,37550],[37273,37561],
 [37274,37560],[37282,37555],[37284,37351,37368,37465],
 [37285,37346,37367,37541],[37286,37347,37366,37554],
 [37287,37547],[37288,37546],[37289,37552],
 [37293,37373,37382,37570],[37299,37376,37380,37563],
 [37305,37887],[37306,37886],
 [37308,37311,37399,37403,37577,37883],[37310,37888],
 [37312,37744],[37313,37314,37714,37715,37740,37880],
 [37315,37411,37581,37891],[37316,37410,37582,37890],
 [37321,37412,37587,37892],[37323,37889],
 [37325,37404,37513,37594],[37326,37391,37476,37593],
 [37327,37386,37592,37651],[37328,37387,37591,37884],
 [37332,37339,37416,37422,37598,37605,37896,37902],
 [37333,37337,37338,37340,37415,37417,37423,37424,37599,37603,
   37604,37606,37895,37897,37903,37904],
 [37334,37335,37413,37414,37607,37608,37898,37900,38139,38160,
   38185,38202],[37336,37421,37609,37899],
 [37342,37343,37418,37419,37600,37602,37894,37901,38156,38161,
   38184,38204],[37353,37354,37709],[37356,37371],
 [37365,37405,37590],[37393,37579],[37394,37578],
 [37395,37585],[37400,37580],
 [37407,37408,37466,37468,37576,38052],[37425,37934],
 [37430,37935],[37435,37938],
 [37446,37448,37478,37481,37504,37505,37610,37625,37627,37931,
   38035,38053],[37447,37467,37626,37653],[37450,37803],
 [37451,37929],[37452,37949],[37453,37950],
 [37454,37633,37642,37945],[37455,37632,37641,37947],
 [37456,37640,37643,37946],[37457,37463,37636,37638,37942,37948]
  ,[37458,37462,37634,37637,37941,37944],[37459,37943],
 [37460,37951],[37461,37635,37639,37940],[37469,37977],
 [37470,37752],[37472,37911],[37473,38055],[37474,38054],
 [37477,37781],[37479,38056],[37480,37655,37691,37692],
 [37482,38016],[37483,37521],[37484],[37485,37659],
 [37486,37997],[37487,37836],[37488,37809],[37489,37956],
 [37490,37672,38066,38076],[37491,37670,38067,38075],
 [37492,37669,38062,38079],[37493,38064],
 [37494,37667,38063,38078],[37495,37666,38059,38083],
 [37496,37673,38061,38084],[37497,37665,38060,38082],
 [37498,37671,38068,38077],[37499,38057],[37500,38058],
 [37501,38065],[37507,37751],[37509,37910],[37510,38038],
 [37511,38037],[37514,37780],
 [37517,37518,37690,37693,37974,38036],[37519,38015],
 [37524,37835],[37525,37808],[37526,37955],
 [37527,38010,38049,38091],[37528,38008,38050,38090],
 [37529,38007,38045,38094],[37530,38047],
 [37531,38005,38046,38093],[37532,38004,38042,38098],
 [37533,38011,38044,38099],[37534,38003,38043,38097],
 [37535,38009,38051,38092],[37536,38040],[37537,38041],
 [37538,38048],[37612,37613],[37614,37619],[37616,37629],
 [37621,37631],[37644,37978],[37645,37753],[37646,37723],
 [37647,37912],[37648,38071],[37649,38070],[37652,37782],
 [37654,38072],[37657,38017],[37660],[37661,37998],
 [37662,37837],[37663,37810],[37664,37957],[37668,38080],
 [37674,38073],[37675,38074],[37676,38081],[37679,37907],
 [37697,37704,37986,37992],
 [37698,37702,37703,37705,37985,37987,37993,37994],
 [37699,37707,37984,37988],
 [37700,37701,37706,37708,37983,37989,37990,37991,38146,38169,
   38190,38203],[37711,37756],[37712,37755],[37717,37757],
 [37720,37750],[37725,37742],[37727,37747],[37728,37767],
 [37729,37768],[37730,37763],[37731,37765],[37732,37764],
 [37733,37760],[37734,37762],[37735,37761],[37736,37769],
 [37737,37758],[37738,37759],[37739,37766],[37770,37915],
 [37771,37914],[37776,37916],[37784,37829],[37785,37802],
 [37786,37906],[37787,37926],[37788,37927],[37789,37922],
 [37790,37924],[37791,37923],[37792,37919],[37793,37921],
 [37794,37920],[37795,37928],[37796,37917],[37797,37918],
 [37798,37925],[37806,38086],[37811,38001],[37812,37840],
 [37813],[37814,37960],[37816,38125],[37817,38120],
 [37818,38122],[37819,38121],[37820,38117],[37821,38119],
 [37822,38118],[37823,38126],[37824,38115],[37825,38116],
 [37826,38123],[37839],[37841,37959],[37842,38111],
 [37843,37850,38112,38113],[37844,38107],[37845,38109],
 [37846,38108],[37847,38104],[37848,38106],[37849,38105],
 [37851,38102],[37852,38103],[37853,38110],[37953,38087],
 [37954,38021],[37958,38002],[37961],[37962,38136],
 [37963,38137],[37964,38132],[37965,38134],[37966,38133],
 [37967,38129],[37968,38131],[37969,38130],[37970,38138],
 [37971,38127],[37972,38128],[37973,38135],[37995,38018],
 [37999],[38006,38095],[38012,38088],[38013,38089],
 [38014,38096],[38022,38031],[38023,38032],
 [38024,38026,38027,38028],[38025,38029],[38030,38033],
 [38140,38171,38179,38187],[38141,38196],
 [38142,38164,38170,38192],[38143,38155,38166,38175],[38147],
 [38148,38157],[38149,38199],
 [38150,38163,38177,38180,38188,38194],[38151,38197],
 [38152,38162,38193],[38154,38168,38182,38186],[38158],
 [38159,38200],[38165,38178,38189],[38172],[38173,38198],
 [38183,38191],[38201],
 [38214,38216,38223,38227,38229,38230,38256,38258,38265,38269,
   38271,38272,38340,38346,38379,38385,38413,38415,38426,38428,
   38569,38601,38603,38634,38664,38666,38694,38696,38922,38923,
   38961,38962,39159,39161,39168,39172,39174,39175,39200,39204,
   39209,39213,39215,39218,39240,39244,39249,39253,39255,39258,
   39441,39443,39475,39477,39565,39567,39624,39626,40076,40078,
   40155,40157,40213,40216,40225,40229,40288,40295,40299,40302,
   40303,40363,40367,40387,40394,40398,40401,40402,40921,40925,
   40930,40934,40936,40939,40975,40977,41032,41033,41043,41045,
   41075,41080,41084,41088,41089,41110,41115,41119,41123,41124,
   41181,41183,41743,41749,41775,41777,41786,41790,41864,41933,
   41961,41965,42054,42058,42083,42087,42196,42199,42286,42289,
   42595,42601,42729,42735,42937,42939,43066,43068,43294,43302,
   43303,43365,43436,43443,43608,43614,43637,43729,43959,43968,
   43969,43997,44102,44109,44274,44280,44301,44352,44630,44635,
   44639,44643,44644,44673,44728,44734,44793,44794,44822,44823,
   44913,44914,44938,44939,45271,45273,45322,45329,45333,45336,
   45337,45358,45361,45417,45420,45894,46068,46070,46183,46185,
   46615,46617,46666,46709,46943,46950,46973,46980,47092,47093,
   47246,47247,47551,47555,47625,47670,47984,47990,48013,48105,
   48390,48392,48419,48466,49478,49479,49567,49569,49606,49607,
   49866,49869,49905,49907,50875,50876],
 [38219,38225,38261,38267,38356,38357,38395,38396,38561,38567,
   38626,38632,38926,38927,38965,38966,39164,39170,39219,39221,
   39259,39261,39430,39436,39464,39470,39786,39788,39829,39831,
   40067,40072,40146,40151,40513,40517,40540,40544,40940,40942,
   40966,40971,41077,41082,41112,41117,41420,41422,41467,41469,
   41759,41760,41871,41872,41940,41941,42598,42603,42732,42737,
   42941,42942,43070,43071,44632,44637,44680,44681,44731,44736,
   44916,44917,44941,44942,45260,45266,45445,45448,45472,45475,
   45886,45892,46072,46073,46187,46188,47030,47037,47057,47064,
   48770,48774,48846,49121,49125,49197,49481,49482,49571,49572,
   49827,49829,49909,49910,50399,50401,50879,50880],
 [38233,38275,38348,38387,38576,38641,38751,38753,39178,39211,
   39251,39446,39480,39652,39654,40080,40159,40647,40729,40932,
   40979,41092,41127,41358,41360,41751,41862,41931,42612,42746,
   42879,42885,44647,44671,44745,44877,44878,45276,45512,45584,
   45901,46006,46011,47096,47250,48772,48844,48889,49119,49146,
   49150,49529,49610,50438],
 [38234,38235,38276,38277,38342,38343,38381,38382,38575,38577,
   38640,38642,38745,38777,38778,38780,38898,38900,39047,39060,
   39179,39180,39444,39445,39478,39479,39949,39963,40648,40649,
   40730,40731,41745,41746,41856,41857,41925,41926,42850,42852,
   42855,42858,42933,43005,44665,44666,44849,44850,44851,44854,
   44907,44932,45274,45275,45510,45511,45582,45583,45900,45902,
   46005,46033,46037,46038,46063,46158,46306,46307,47095,47097,
   47249,47251,48768,48771,48799,48868,49122,49123,49219,49240,
   49472,49527,49528,49542,49609,49611,49690,49691,49844,50439,
   50440,50519,50533,50625,51322,51335],
 [38238,38239,38246,38247,38280,38281,38288,38289,38359,38360,
   38364,38365,38398,38399,38403,38404,38581,38582,38587,38589,
   38646,38647,38652,38654,38929,38935,38936,38937,38968,38974,
   38975,38976,39085,39092,39106,39115,39130,39136,39149,39150,
   39183,39184,39191,39192,39222,39223,39227,39228,39262,39263,
   39267,39268,39449,39451,39456,39457,39483,39485,39490,39491,
   39789,39795,39796,39797,39832,39838,39839,39840,39988,39995,
   40009,40010,40033,40039,40051,40053,40085,40086,40093,40094,
   40164,40165,40172,40173,40652,40653,40660,40661,40734,40735,
   40742,40743,40943,40944,40948,40949,40984,40985,40992,40993,
   41095,41097,41102,41103,41130,41132,41137,41138,41424,41428,
   41430,41431,41471,41475,41477,41478,41669,41686,41690,41691,
   41714,41715,41732,41734,41762,41763,41767,41768,41873,41874,
   41878,41879,41942,41943,41947,41948,42617,42618,42623,42625,
   42751,42752,42757,42759,42945,42949,42951,42952,43074,43078,
   43080,43081,43190,43207,43211,43220,43235,43236,43254,43255,
   44650,44652,44657,44658,44682,44683,44687,44688,44750,44751,
   44756,44758,44919,44923,44925,44926,44944,44948,44950,44951,
   45189,45206,45211,45219,45234,45235,45252,45253,45279,45281,
   45286,45287,45515,45517,45522,45523,45587,45589,45594,45595,
   45906,45907,45912,45914,46074,46080,46081,46082,46189,46195,
   46196,46197,46345,46352,46367,46375,46390,46396,46408,46409,
   47101,47102,47107,47109,47255,47256,47261,47263,49484,49488,
   49490,49491,49532,49534,49539,49540,49573,49579,49580,49581,
   49615,49616,49621,49623,49736,49746,49751,49759,49775,49780,
   49792,49793,49831,49835,49837,49838,49913,49917,49919,49920,
   50402,50408,50409,50410,50443,50444,50451,50452,50565,50575,
   50579,50580,50604,50609,50621,50623,50882,50888,50889,50890,
   51367,51377,51381,51390,51406,51411,51424,51425],
 [38240,38245,38282,38287,38366,38367,38405,38406,38580,38588,
   38645,38653,38930,38934,38969,38973,39185,39190,39229,39230,
   39269,39270,39450,39458,39484,39492,39790,39794,39833,39837,
   40087,40092,40166,40171,40654,40659,40736,40741,40950,40951,
   40986,40991,41096,41104,41131,41139,41423,41429,41470,41476,
   41769,41770,41880,41881,41949,41950,42616,42624,42750,42758,
   42944,42950,43073,43079,44651,44659,44689,44690,44749,44757,
   44918,44924,44943,44949,45280,45288,45516,45524,45588,45596,
   45905,45913,46075,46079,46190,46194,47100,47108,47254,47262,
   49483,49489,49533,49541,49574,49578,49614,49622,49830,49836,
   49912,49918,50403,50407,50445,50450,50883,50887],
 [38299,38300,38314,38315,38412,38414,38424,38427,38522,38539,
   38540,38596,38602,38655,38660,38661,38691,38692,38805,38809,
   38810,38826,38834,38835,38851,38877,39281,39283,39295,39297,
   39314,39318,39325,39331,39351,39355,39362,39368,39405,39406,
   39539,39542,39559,39563,39564,39623,39628,39729,39758,39883,
   39885,39902,40104,40105,40117,40118,40214,40215,40227,40228,
   40254,40255,40266,40267,40320,40335,40337,40360,40366,40453,
   40458,40482,40487,40569,40684,40744,40745,40762,41034,41035,
   41047,41048,41140,41155,41157,41180,41186,41207,41208,41220,
   41223,41243,41248,41273,41278,41389,41504,41565,41566,41599,
   41776,41778,41788,41791,41886,41902,41903,41960,41966,42050,
   42055,42056,42084,42089,42169,42172,42173,42215,42219,42241,
   42326,42327,42629,42631,42643,42645,42764,42769,42823,42828,
   42913,42915,43028,43030,43256,43260,43267,43273,43305,43308,
   43338,43344,43405,43411,43439,43442,43973,43974,44038,44044,
   44071,44077,44107,44108,44790,44795,44796,44824,44829,44955,
   44959,44981,45024,45026,45027,45065,45066,45296,45302,45355,
   45359,45360,45419,45424,45525,45554,45697,45698,45714,45857,
   45863,46092,46094,46221,46223,46939,46944,46945,46975,46976,
   47110,47116,47119,47135,47161,47204,47206,47209,47438,47443,
   47467,47472,47902,47907,49642,49643,49659,49925,49926,49959,
   50894,50896,50913,51255,51256,51273],
 [38301,38313,38449,38458,38461,38537,38719,38721,38807,38833,
   39282,39296,39390,39407,39493,39541,39593,39599,39733,39844,
   40103,40119,40177,40185,40190,40253,40269,40338,40565,40617,
   40997,41005,41010,41156,41209,41221,41385,41437,41813,41822,
   41825,41901,42026,42030,42171,42328,42630,42642,42906,42912,
   42958,43029,44703,44705,44766,44770,45028,45068,45389,45395,
   45529,45640,46090,46093,46201,46224,46419,46421,47003,47005,
   47117,47208],
 [38306,38312,38421,38535,38538,38599,38662,38690,38808,38832,
   39288,39294,39403,39408,39500,39506,39537,39540,39569,39622,
   40110,40116,40222,40260,40268,40333,40336,40365,40423,40428,
   41042,41153,41158,41185,41214,41222,41302,41307,41785,41899,
   41904,41963,42060,42085,42174,42325,42636,42644,42794,42799,
   42914,43027,43307,43372,43378,43441,43971,44004,44010,44105,
   44800,44825,45029,45067,45365,45418,46095,46222,46946,46974,
   47118,47207],
 [38418,38454,38460,38724,39572,39601,39603,39631,40193,40195,
   40233,40371,41013,41015,41051,41189,41780,41818,41824,42029,
   43297,43433,44307,44438,44696,44702,44769,45366,45397,45399,
   45425,46412,46418,46621,46752,47008,47556,47673,48397,48514,
   49501,49503,49886,49888,50143,50145,51065,51067],
 [38419,38671,39574,43561,44792,47957,49645,51276],
 [38420,38673,39575,43708,44791,47987,49644,51277],
 [38423,38695,39573,39630,40230,40370,41050,41190,41787,42059,
   43304,43438,44306,44435,44799,45369,45426,46622,46751,46979,
   47559,47674,48398,48513],
 [38429,38433,38609,38663,38698,38748,38857,38942,39508,39510,
   39566,39568,39627,39651,39888,39934,40224,40362,40431,40433,
   41044,41046,41182,41310,41312,41363,41569,41615,41793,42064,
   42223,42306,43312,43446,43467,43472,43526,43531,43773,43972,
   44012,44014,44164,44170,44282,44284,44804,44807,44835,44883,
   44963,45048,45364,45423,46478,46484,46711,46713,46754,46982,
   47141,47228,47710,47712,47997,48402,48422,48424,48777,48931,
   49127,49281],
 [38430,38697,39496,39848,40217,40622,41177,41442,42061,42309,
   43445,43616,43731,43998,44133,44140,44962,45049,45644,46507,
   46511,47142,48016,48145],
 [38431,38432,38699,38700,39321,39335,39358,39372,40218,40219,
   40463,40492,41175,41176,41253,41283,42062,42063,42307,42308,
   43263,43277,43332,43348,43399,43415,43444,43447,43790,43823,
   44160,44194,44197,44198,44199,44329,44397,44417,44960,44961,
   45046,45047,45290,45306,46443,46447,46448,46449,46453,46596,
   46614,46731,47140,47143,47448,47554,47581,47605,47912,48182,
   48199,48446,48510,48551,49587,49800,50181,50200,50202,50857,
   51084,51102],
 [38434,38608,38657,38852,39560,39755,39886,39936,41041,41483,
   41567,41617,43967,44806,44836,45003,47996,48403,48776,49128],
 [38435,38610,38658,38775,39887,39935,43966,44856,47995,48401,
   49546,49547],
 [38436,38677,39579,39895,39943,41059,41535,41575,41623,43784,
   43987,44813,45057,48005,49656,51289],
 [38437,38616,38678,38872,39581,39775,39896,41060,41577,43777,
   43986,44814,44837,46761,48004,48404,49657,49665,51288,51296],
 [38438,38446,38615,38620,38675,38679,38870,38871,39578,39582,
   39773,39774,39893,39898,39940,39948,41057,41063,41540,41541,
   41574,41579,41621,41629,43983,43989,44810,44818,44840,44848,
   45060,45061,48000,48008,48407,48415,49648,49652,49663,49669],
 [38439,38614,38674,38680,38863,38869,39577,39583,39766,39772,
   39891,39899,39939,39947,41058,41062,41534,41538,41572,41580,
   41620,41628,43984,43988,44812,44817,44841,44846,45054,45058,
   48002,48007,48408,48413,49654,49670],
 [38440,38445,38613,38621,38681,38682,38864,38868,39584,39585,
   39767,39771,39892,39900,39941,39946,41064,41065,41533,41539,
   41573,41581,41622,41627,43780,43785,43990,43991,44811,44819,
   44839,44847,45053,45059,46758,46766,48001,48009,48406,48414,
   49647,49653,49664,49668,51278,51284,51295,51299],
 [38442,38685,39587,39937,41543,41619,43783,44809,45062,48006,
   49651,51281],
 [38443,38619,38684,38865,39588,39769,39890,39938,41066,41542,
   41570,41618,43782,43993,44816,44844,45063,46756,47999,48409,
   49650,49674,51282,51303],
 [38444,38618,38676,38873,39580,39777,39894,39942,41061,41537,
   41576,41624,43776,43985,44815,44845,45055,46762,48003,48405,
   49658,49666,51287,51298],[38447,38622,49655,49671],
 [38453,38593,39600,39761,40194,40709,43641,43963,44697,47991,
   49502,49889],[38455,39602,40196,44695,49500,49887],
 [38456,38730,39604,44762,48909,49120,49628,51307],
 [38457,38732,39605,44761,49496,49627,50645,51308],
 [38462,38731,39606,39659,41017,41366,44713,44767,48769,49260,
   49629,51306],
 [38470,38471,38716,38722,39590,39596,39919,39921,41004,41009,
   41584,41586,44699,44704,44776,44777,48775,49126,49505,49506],
 [38472,38717,39920,44698,49504,49545],
 [38473,38736,39609,39928,41022,41592,44719,44783,49514,49639,
   51080,51320],
 [38474,38737,39611,39929,41023,41594,44718,44784,49513,49640,
   51073,51319],
 [38475,38477,38734,38741,39612,39614,39925,39926,41020,41028,
   41596,41598,44721,44722,44780,44781,49517,49518,49635,49636],
 [38476,38733,39613,39924,41021,41597,44720,44782,49516,49637],
 [38478,38742,39616,44778,49507,49632,51077,51311],
 [38479,38744,39617,39922,41030,41588,44724,44779,49515,49634,
   51079,51312],
 [38480,38743,39618,39923,41029,41587,44725,44786,49508,49633,
   51078,51313],
 [38481,38735,39610,39927,41024,41593,44717,44785,49512,49641,
   51072,51318],
 [38482,38483,38738,38740,39608,39615,39931,39933,41026,41027,
   41590,41591,44715,44723,44788,44789,49509,49510,49630,49631],
 [38484,49638],
 [38527,38533,38836,38837,39529,39535,39739,39741,40257,40262,
   40325,40331,40510,40537,41211,41216,41510,41512,42176,42177,
   42247,42249,42329,42330,42633,42638,43031,43032,45031,45032,
   45452,45479,46097,46098,47033,47060],
 [38541,38542,38747,38750,38828,39046,39543,39545,39650,39653,
   39731,39950,40271,40272,40340,40341,40576,40577,41224,41226,
   41361,41362,41482,41631,42110,42113,42117,42137,42140,42144,
   42646,42647,42882,42883,43003,43151,44881,44882,45002,45164,
   45664,45665,46007,46010,46088,46320,47167,47169,48741,48744,
   48748,49704,50520,51321],
 [38543,38774,39544,40339,40575,42167,42264,42856,44855,45666,
   46034,47168],
 [38545,38549,38551,38552,38841,38843,38848,38849,39745,39746,
   39751,39753,40273,40279,40280,40281,40343,40347,40349,40350,
   40578,40579,40583,40584,42180,42181,42188,42189,42253,42254,
   42259,42261,42334,42336,42341,42342,42649,42655,42656,42657,
   45667,45668,45672,45673,46101,46102,46109,46110],
 [38546,38548,38553,38554,38840,38844,38846,38847,39102,39107,
   39131,39148,39549,39550,39555,39557,39743,39747,39749,39750,
   40005,40018,40034,40052,40246,40275,40276,40283,40284,40344,
   40345,40352,40353,40580,40581,40588,40589,40722,40771,40792,
   41230,41231,41236,41238,41513,41519,41520,41521,41676,41699,
   41720,41733,41807,41983,42076,42104,42178,42179,42183,42184,
   42250,42251,42255,42256,42332,42333,42337,42338,42651,42653,
   42658,42659,43034,43040,43041,43042,43197,43212,43241,43253,
   43653,44127,45033,45039,45040,45041,45196,45210,45240,45254,
   45384,45565,45669,45671,45676,45677,45705,45729,46100,46104,
   46106,46107,46362,46366,46391,46410,46627,46968,47149,47173,
   47174,47179,47181,47243,48114,48524,49729,49750,49774,49794,
   49930,49978,50558,50588,50603,50622,50901,50949,51360,51382,
   51405,51423],
 [38547,38555,38839,38845,39548,39556,39742,39748,40277,40282,
   40346,40351,40582,40587,41229,41237,41514,41518,42185,42186,
   42257,42258,42339,42340,42652,42660,43035,43039,45034,45038,
   45670,45678,46099,46105,47172,47180],
 [38591,39759,40707,43643,43965,47993],
 [38594,38860,39763,39804,41056,41485,43982,44821,46541,48363,
   49661,51292],
 [38595,38862,39764,44820,46688,48393,49660,51293],
 [38611,38866,39768,39889,41067,41571,43992,44842,46764,48411,
   49672,51305],
 [38617,38874,39776,44838,46763,48412,49667,51297],
 [38687,38693,38946,38947,39619,39625,39903,39905,41179,41184,
   41600,41602,43301,43306,44439,44440,44965,44966,47561,47562,
   48778,48929,49129,49280],[38688,39904,43300,47560],
 [38701,38752,39633,39805,41194,41487,43316,44227,44879,47522,
   49676,51259],
 [38702,38899,39635,39658,41192,41367,43315,43878,44254,44270,
   44956,46846,47495,47517,48248,48665,48971,49339,49677,50133,
   50653,51258,51487,51871],
 [38703,38779,39634,44374,44852,47552,49675,51260],
 [38704,39642,39908,41196,41613,43322,44971,47572],
 [38705,38712,38958,38959,39641,39643,39909,39910,41195,41203,
   41612,41614,43323,43324,44451,44452,44969,44970,47573,47574,
   49678,49679,51261,51262],
 [38706,38714,38956,38957,39639,39647,39907,39911,41199,41204,
   41603,41609,43319,43327,44442,44448,44974,44975,47564,47568,
   49681,49689,51265,51270],
 [38707,38715,38949,38955,39638,39646,39906,39912,41197,41205,
   41604,41608,43321,43326,44449,44450,44968,44972,47570,47571,
   49682,49687,51264,51272],
 [38708,38713,38950,38954,39640,39645,39913,39914,41198,41206,
   41610,41611,43320,43328,44443,44447,44967,44973,47563,47569,
   49680,49688,51263,51271],
 [38710,39636,39916,41200,41605,43318,44976,47567],
 [38739,39607,39932,41025,41589,44716,44787,49511],
 [38754,39000,39503,39849,41306,41446,42798,42886,42966,43121,
   43375,43581,44286,44357,44888,45122,46017,46207,46262,46564,
   47634,47715,47937,48339],
 [38755,38983,39802,41316,41436,42807,42888,42957,43088,43620,
   44247,44250,45137,46159,46293,46671,47498,47502,48150,48475],
 [38756,38757,39016,39031,39328,39336,39365,39373,41247,41257,
   41277,41287,42768,42777,42827,42836,42887,42889,43105,43136,
   43270,43278,43584,43587,43691,43754,44041,44050,44074,44083,
   44885,44886,45089,45106,45860,45869,46014,46016,46245,46278,
   46561,46567,46600,46735,47442,47452,47471,47480,47932,47933,
   48046,48069,48338,48343,48451,48556,48819,48823,48949,48983,
   49124,49196,49299,49318,49591,50105,50186,50419,51430,51446,
   51595,51715],[38758,38906,48781,49131],[38759,48780],
 [38760,38786,48779,49550],
 [38761,38908,39051,39064,39664,39670,39811,39817,39953,39978,
   41373,41377,41493,41497,41634,41642,41659,41667,42894,43014,
   43156,43164,43169,43177,44897,45017,45169,45174,45181,45186,
   46027,46174,46325,46337,48789,48861,48862,48944,49140,49212,
   49213,49295,49714,49726,50531,50556,51334,51347],
 [38762,38916,39052,39063,39955,39979,42893,43021,44898,45019,
   46026,46175,46323,46336,48787,48937,49139,49287,49715,49728,
   50530,50557,51332,51346],
 [38763,39062,39956,43023,44894,48792,49710,50547],
 [38764,39061,39957,39982,42904,43024,44896,45016,48791,49712,
   50529,50554],
 [38765,39069,39820,39958,43022,43160,44895,45177,48793,49208,
   49711,50546],
 [38766,38915,39057,39071,39665,39669,39818,39819,39960,39987,
   41372,41378,41499,41500,41636,41641,41660,41668,42899,43020,
   43157,43162,43168,43176,44892,45020,45167,45175,45180,45188,
   46022,46176,46331,46344,48783,48855,48859,48941,49133,49205,
   49211,49293,49707,49720,50525,50549,51327,51338],
 [38767,38914,39059,39072,39961,39986,42898,43018,44893,45013,
   46021,46168,46330,46342,48790,48943,49141,49294,49709,49721,
   50523,50548,51326,51339],
 [38768,38769,38909,38913,39050,39058,39065,39070,39671,39672,
   39812,39816,39954,39962,39980,39985,41379,41380,41492,41498,
   41635,41643,41661,41666,42900,42901,43013,43019,43155,43163,
   43170,43175,44899,44900,45012,45018,45168,45176,45179,45187,
   46028,46029,46169,46173,46324,46332,46335,46343,48782,48788,
   48854,48860,48936,48942,49134,49138,49206,49210,49288,49292,
   49708,49716,49719,49727,50524,50532,50550,50555,51325,51333,
   51340,51345],
 [38770,39068,39815,43161,45183,48785,49216,49705],
 [38771,39066,48784,49706],
 [38772,39067,39976,42896,45021,46025,46327,48786,48947,49713,
   50528,51344],
 [38781,39002,42792,42859,43370,43611,44285,44358,46260,47633,
   47716,48084],
 [38782,38985,42853,42861,43619,44277,46039,46291,46672,47649,
   48151,48474],
 [38783,38784,42860,42862,43692,43755,46599,46734,48967,49334,
   49590,50420],[38785,38907,49130,49551],[38787,49549],
 [38789,38796,39075,39077,39967,39968,42866,42874,44871,44872,
   46053,46055,46310,46311,49557,49558,49702,49703,50543,50545,
   50672,50673,51357,51358],
 [38790,39074,39969,42876,44867,49562,49697,50535],
 [38791,39073,39970,42877,44869,49561,49699,50542],
 [38792,39081,39971,42875,44868,49563,49698,50534],
 [38793,38795,39082,39083,39973,39975,42872,42873,44865,44873,
   46049,46056,46318,46319,49552,49553,49694,49695,50537,50538,
   50677,50678,51350,51352],
 [38797,38798,39078,39080,49554,49555,49692,49693],
 [38799,39079,39964,42869,44874,46052,46314,49556,49700,50541,
   50683,51356],
 [38856,38943,39494,39846,40355,40620,41039,41440,41796,42220,
   43313,43618,43733,44000,44192,44193,44803,45642,46452,46454,
   46983,47227,48018,48147],
 [38858,38859,38944,38945,39319,39333,39356,39370,40356,40357,
   40461,40490,41037,41038,41251,41281,41794,41795,42221,42222,
   43261,43275,43310,43311,43334,43346,43401,43413,43788,43806,
   44129,44134,44135,44138,44139,44300,44399,44419,44801,44802,
   45292,45304,46474,46506,46508,46512,46513,46598,46643,46733,
   46981,46984,47226,47229,47446,47583,47607,47669,47910,48164,
   48166,48395,48448,48553,49589,49802,50183,50218,50235,50859,
   51086,51119],
 [38879,38880,39279,39292,40322,40329,41144,41149,42243,42246,
   42518,42526,42531,42554,42563,42566,42640,42664,42670,42674,
   42704,42706,42984,42986,44985,44986,45922,45926,45950,45956,
   45979,45981,46140,46142,47164,47165],
 [38901,39497,41301,41444,42965,43006,43122,44287,44359,45121,
   46537,48366],
 [38902,38984,39513,39655,41314,41359,42806,42880,43008,43089,
   43385,43621,44220,44223,45007,45136,46012,46162,46292,46673,
   47525,47529,48149,48473],
 [38903,38904,43007,43009,43693,43756,46601,46736,49592,50421,
   50703,50719],[38905,41371,41489,49132],
 [38910,39049,41381,41495,41632,41664,49143,49722],
 [38911,39048,41382,41494,41633,41662,49142,49724],
 [38912,39056,39673,43173,45165,48857,49144,49723],
 [38917,39055,39668,41375,41501,41639,41657,43174,45171,48865,
   49136,49717],[38918,39053,49135,49718],
 [38919,39054,49137,49725],[38948,49548],[38952,49685],
 [38960,49686],
 [38986,39006,39514,41322,41449,42810,42971,43092,43135,43392,
   43629,44297,44370,45132,46267,46682,47645,47728,48160,48483],
 [38987,39007,39522,39861,41324,41450,42817,42970,43091,43133,
   43393,43628,44298,44369,45134,45138,46219,46266,46295,46674,
   47646,47727,48153,48481],
 [38988,38996,39010,39011,39517,39525,39853,39857,41321,41326,
   41447,41453,42813,42818,42968,42974,43093,43101,43131,43132,
   43389,43397,43625,43633,44289,44293,44361,44365,45130,45131,
   45140,45148,46210,46214,46270,46271,46296,46304,46677,46685,
   47635,47641,47717,47723,48156,48161,48480,48485],
 [38989,38997,39003,39009,39516,39852,39858,41319,41327,41448,
   41452,42812,42820,42969,42973,43094,43102,43125,43129,43390,
   43626,43631,44295,44296,44367,44368,45128,45142,45147,46209,
   46215,46269,46298,46303,46676,46684,47642,47643,47724,47725,
   48155,48163,48478,48486],
 [38990,38995,39004,39008,39518,39523,39859,39860,41320,41328,
   41454,41455,42811,42819,42975,42976,43095,43100,43124,43130,
   43388,43396,43624,43632,44288,44294,44360,44366,45123,45129,
   45141,45149,46216,46217,46264,46268,46297,46305,46678,46683,
   47636,47640,47718,47722,48154,48162,48479,48487],
 [38991,39012,39521,39856,41325,41458,42816,42978,43097,43128,
   43394,43622,44290,44364,45126,45144,46211,46274,46299,46680,
   47638,47719,48157,48477],
 [38992,39854,43096,44292,44362,45143,46213,46300],
 [38993,39013,39519,41317,41456,42815,42977,43098,43126,43387,
   43623,44291,44363,45125,46273,46679,47639,47721,48158,48476],
 [38994,39005,39515,39863,41323,41451,42809,42972,43099,43134,
   43391,43627,44299,44371,45133,45146,46220,46265,46302,46675,
   47644,47726,48152,48482],
 [39001,42793,43369,43554,46261,47632,47714,47964],
 [39014,39520,41318,41457,42814,42979,43127,43386,43630,45127,
   46272,46681,47637,47720,48159,48484],
 [39017,39032,39338,39375,42763,42822,43280,44035,44051,44068,
   44084,45005,45006,45854,45870,46161,46163,46244,46277,46534,
   46540,47466,48044,48067,48365,48370,48450,48555,48773,49174,
   50103,50185,50684,50685,51445,51716],
 [39018,39033,39337,39374,42762,42821,43279,44036,44049,44069,
   44082,44858,44859,45855,45868,46041,46043,46243,46276,46591,
   46687,47465,48045,48068,48442,48452,48490,48557,48948,49300,
   49543,50104,50120,50187,51444,51717],
 [39019,39030,39034,39045,39345,39382,41259,41268,41289,41298,
   42784,42790,42843,42849,43109,43111,43140,43142,43287,43701,
   43704,43764,43767,44052,44085,45094,45111,45871,46255,46288,
   46610,46611,46745,46746,47454,47463,47487,47493,48049,48055,
   48072,48078,48456,48460,48561,48565,49601,49602,50108,50114,
   50191,50195,50429,50432,51435,51456,51599,51601,51718,51729],
 [39020,39028,39035,39043,39346,39348,39383,39385,41266,41269,
   41296,41299,42786,42789,42845,42848,43108,43112,43139,43143,
   43288,43290,43700,43703,43763,43766,44060,44062,44093,44095,
   45090,45093,45107,45110,45879,45881,46247,46257,46280,46290,
   46602,46612,46737,46747,47461,47464,47489,47492,48048,48050,
   48071,48073,48455,48458,48560,48563,49593,49603,50107,50109,
   50190,50193,50428,50431,51431,51434,51448,51458,51598,51602,
   51719,51727],
 [39021,39036,39340,39342,39377,39379,41262,41264,41292,41294,
   42779,42783,42838,42842,43118,43149,43282,43284,43695,43758,
   44055,44057,44088,44090,45097,45100,45114,45117,45874,45876,
   46248,46253,46281,46286,46607,46742,47457,47459,47482,47486,
   48053,48056,48076,48079,48453,48462,48558,48567,49598,50112,
   50115,50188,50197,50423,51438,51441,51449,51454,51608,51720],
 [39022,39025,39037,39040,39339,39341,39376,39378,41260,41263,
   41290,41293,42780,42782,42839,42841,43113,43119,43144,43150,
   43281,43283,43696,43702,43759,43765,44056,44058,44089,44091,
   45095,45099,45112,45116,45875,45877,46250,46252,46283,46285,
   46606,46609,46741,46744,47455,47458,47483,47485,48054,48057,
   48077,48080,48461,48464,48566,48569,49597,49600,50113,50116,
   50196,50199,50424,50430,51436,51440,51451,51453,51603,51609,
   51721,51724],
 [39023,39024,39038,39039,39343,39347,39380,39384,41261,41265,
   41291,41295,42781,42787,42840,42846,43114,43117,43145,43148,
   43285,43289,43694,43698,43757,43761,44054,44059,44087,44092,
   45096,45101,45113,45118,45873,45878,46249,46251,46282,46284,
   46604,46608,46739,46743,47456,47460,47484,47490,48052,48058,
   48075,48081,48454,48463,48559,48568,49595,49599,50111,50117,
   50189,50198,50422,50426,51437,51442,51450,51452,51604,51607,
   51722,51723],
 [39026,39041,43115,43146,43697,43760,46605,46740,49596,50425,
   51605,51725],
 [39027,39029,39042,39044,39344,39350,39381,39387,41258,41267,
   41288,41297,42785,42788,42844,42847,43110,43116,43141,43147,
   43286,43292,43699,43705,43762,43768,44053,44063,44086,44096,
   45092,45098,45109,45115,45872,45882,46254,46256,46287,46289,
   46603,46613,46738,46748,47453,47462,47488,47491,48047,48051,
   48070,48074,48457,48459,48562,48564,49594,49604,50106,50110,
   50192,50194,50427,50433,51433,51439,51455,51457,51600,51606,
   51726,51728],
 [39086,39097,39135,39139,40011,40020,40027,41670,41681,41682,
   41695,41717,41719,41723,41727,43200,43209,43252,45212,45228,
   45229,49742,49755,49777,49787,50577,50618,50620],
 [39087,39140,40012,41680,41718,43210,45227,49770,49786,50619],
 [39088,39119,39138,39144,39996,40013,43208,43223,45197,45220,
   49732,49763,49782,49788,50567,50591],
 [39089,39091,39100,39114,39120,39121,39129,39137,39992,39994,
   40003,40015,40017,40024,40031,40040,41673,41684,41685,41696,
   41698,41705,41712,41716,43194,43205,43206,43219,43225,43226,
   43234,43237,45193,45204,45205,45216,45224,45232,45233,45236,
   46349,46351,46360,46372,46380,46388,46389,46397,49735,49745,
   49756,49764,49772,49773,49776,49781,50564,50574,50585,50587,
   50594,50601,50605,50610,51366,51376,51389,51395,51396,51404,
   51407,51412],
 [39093,39094,39116,39118,39991,40041,41678,41687,41694,41700,
   43224,43249,45192,45242,49737,49747,49754,49762,50592,50617],
 [39095,39117,39989,40042,41688,41692,43202,43240,45202,45237,
   46384,49769,49789,50584,50616,51422],
 [39096,39126,39134,39142,40026,41671,41710,41724,41726,43251,
   45213,49731,49740,49778,49784,50578],
 [39098,39111,39133,39143,40028,43250,45221,49730,49741,49779,
   49783,50568],
 [39101,39112,39128,39132,40004,40023,40032,40035,41675,41704,
   41713,41721,43196,43217,43233,43242,45195,45218,45225,45241,
   46361,46374,46381,46392,49733,49744,49758,49765,50562,50573,
   50593,50602,51364,51375,51387,51403],
 [39103,39110,41677,41702,49738,49760],
 [39104,39108,39125,39145,40001,40036,41679,41701,41709,41729,
   43216,43248,45190,45243,49739,49748,49752,49761,50570,50608],
 [39105,39109,39990,39999,40037,40043,41689,41693,41707,41730,
   43192,43201,43239,43245,45200,45230,45238,45246,46369,46383,
   49767,49790,50569,50599,50607,50615,51380,51421],
 [39123,39146,40029,40045,43231,43247,45191,45244,49749,49753,
   50560,50613],
 [39124,39147,40014,40046,43203,43238,45201,45239,46377,46385,
   49768,49791,50559,50612,51370,51420],
 [39205,39206,39245,39246,39648,39679,39680,39681,39778,39801,
   40081,40082,40160,40161,40926,40927,40980,40981,41090,41091,
   41125,41126,41329,41331,41333,41334,41412,41459,41630,41644,
   42611,42613,42745,42747,43152,43165,44645,44646,44744,44746,
   45150,45151,48795,48843,49194,49195,49819,50371],
 [39322,39359,41242,41255,41272,41285,42776,42835,43106,43137,
   43264,43557,43560,45088,45105,47437,47450,47479,47959,47960,
   48845,49170,51429,51596],
 [39323,39360,41241,41256,41271,41286,42778,42837,43107,43138,
   43265,43683,43707,45087,45104,47436,47451,47481,48036,48059,
   50095,50372,51428,51597],
 [39349,39386,43291,44061,44094,45091,45108,45880,46246,46279,
   51432,51447],
 [39498,41300,41445,42967,43123,45120,46663,48465],
 [39511,43384,44887,46015],[39512,43383,44860,46042],
 [39524,43395,45124,46263],
 [39547,39551,39553,39554,41227,41233,41234,41235,41516,41517,
   41522,41524,43036,43038,43043,43044,45035,45036,45043,45044,
   47170,47171,47175,47176],
 [39561,39678,41040,41336,41568,41616,44805,44834],
 [39591,41003,41585,44775],[39620,41178,41601,44964],
 [39661,43011,44890,48853],[39662,42864,44863,48852],
 [39663,42891,45010,48851],
 [39666,41374,41502,41637,41658,43167,45170,48864],
 [39667,41376,41503,41638,41665,43166,45172,48863],
 [39674,43171,45166,48856],[39675,43172,45173,48858],
 [39677,40270,41225,41335,42239,42648],
 [39682,41315,41332,42808,43090,44349,45135,47624],
 [39684,41055,41338,43980],[39685,41193,41340,43314],
 [39686,41018,41339,44712],[39687,41341,41531,45050],
 [39688,43012,44889,50380],[39689,42865,44862,50379],
 [39690,42892,45009,50378],
 [39692,39696,39698,39699,41345,41351,41352,41353,41648,41649,
   41654,41656,43180,43182,43187,43188,45154,45155,45162,45163,
   50381,50382,50386,50387],
 [39693,41347,41355,41646,41650,43179,45157,50391],
 [39694,41349,41356,41651,41653,43178,45159,50390],
 [39695,41348,41354,41645,41652,43186,45158,50392],
 [39700,43185,45152,50384],[39701,43183,45153,50383],
 [39702,43184,45160,50385],[39806,41019,41486,44714],
 [39807,41488,41532,45052],[39808,43010,44891,49204],
 [39809,42863,44864,49203],[39810,42890,45011,49202],
 [39813,39951,43016,43154,44901,45182,49215,50553],
 [39814,39952,43015,43153,44902,45184,49214,50551],
 [39821,43158,45178,49207],[39822,43159,45185,49209],
 [39850,44861,46044,46206],[39851,45008,46164,46208],
 [39855,45145,46212,46301],[39862,45139,46218,46294],
 [39930,41031,41595,44726],[39944,41536,41625,45056],
 [39959,43017,44903,50552],
 [39965,42868,44875,46050,46313,50539,50682,51349],
 [39972,42870,44876,46051,46315,50540,50681,51348],
 [39977,42895,45022,46023,46326,48946,50526,51337],
 [39981,42903,45014,50522],[39983,42902,45015,50521],
 [39984,42897,45023,46024,46328,48945,50527,51336],
 [39997,43221,45207,46348,46398,50583,51394,51419],
 [39998,40007,43213,43222,45208,45249,46346,46358,46393,46399,
   50581,50598,51372,51386,51410,51418],
 [40000,40038,41708,41731,43191,43244,45215,45247,46368,50571,
   50606,51379],
 [40006,40021,43198,43215,45198,45222,50566,50589],
 [40008,43214,45250,46356,46394,50596,51371,51409],
 [40019,41672,41703,41722,41728,43199,45214,50576],
 [40022,40047,43193,43243,45223,45248,46370,46376,50561,50611,
   51369,51378],[40048,43230,45199,50590],
 [40049,43228,45209,46347,46386,46400,46402,50582,51362,51401,
   51415,51417],
 [40050,43229,45251,46357,46371,46395,46403,50597,51361,51373,
   51408,51414],[40183,42035,45387,49945],
 [40184,40189,41834,41835,42036,42037,45386,45392,45453,45480,
   49944,49946],
 [40197,40795,41826,42027,45402,45684,46429,47015,48821,48892,
   49149,49152],
 [40198,40199,40796,40797,41820,41821,42021,42022,43868,44219,
   45400,45401,45682,45683,46428,46430,46835,47014,47016,47494,
   48230,48637,48798,48801,48867,48870,49171,49172,49222,49243,
   49843,49846,50118,50628,51474,51849],
 [40200,40208,40803,40804,41839,41841,42040,42041,45408,45410,
   45690,45691,49895,49897,49956,49958],
 [40201,41840,42042,45409,45692,49957],
 [40202,40203,40800,40801,40808,40809,41837,41838,41842,41843,
   42038,42039,42043,42044,43914,44559,44604,45405,45407,45412,
   45413,45687,45689,45694,45695,46434,46435,46903,47020,47021,
   47026,47028,47834,47879,48291,48332,48705,48739,49894,49898,
   49900,49901,49952,49954,50149,50155,50156,50157,50312,50356,
   50939,50940,51206,51235,51535,51576,51695,51820,51895,51939],
 [40204,40209,40802,40807,41844,41845,42045,42046,45406,45414,
   45688,45696,46433,46441,47019,47027,49893,49899,49947,49953,
   50150,50154,50934,50938],[40205,42047,45403,49949],
 [40206,40207,40798,40799,41846,41847,42048,42049,45404,45411,
   45685,45686,49902,49903,49950,49951],
 [40210,40211,43958,46440,46442,46937,49948,49955,50933,50941,
   51666,51776],
 [40221,40519,40547,40663,42066,42096,43645,45356,45551,46624,
   49927,49977],
 [40226,40520,40543,40546,41797,41973,42067,42095,43644,44106,
   45362,45447,45455,45481,46625,46947,47032,47063,48112,48517,
   49929,49975,50899,50945],
 [40234,40710,40764,40780,41789,41964,42057,42086,43582,44115,
   45372,45561,45701,45717,46562,46956,47145,47231,47935,48341,
   48890,48893,49151,49154],
 [40235,40236,40781,40782,41958,41959,42080,42081,44114,44116,
   44521,44534,45559,45560,45715,45716,46533,46535,46538,46616,
   47144,47146,48335,48367,48368,48488,48800,48869,49220,49241,
   49845,50266,50267,50626,51730,51744],
 [40237,40243,40720,40721,40768,40772,40783,40789,41802,41810,
   41979,41984,42070,42078,42100,42108,43649,43657,45374,45378,
   45569,45570,45703,45707,45718,45724,46631,46636,49934,49939,
   49981,49989],
 [40239,40240,40777,40778,40785,40786,41800,41801,41980,41981,
   42073,42074,42097,42098,43648,43655,43893,43910,44120,44121,
   44580,44589,45375,45377,45571,45572,45711,45712,45720,45722,
   46632,46634,46918,46919,46961,46962,47156,47158,47856,47864,
   48119,48120,48314,48320,48519,48527,48675,48682,49935,49937,
   50368,50369,50906,50907,51559,51564,51712,51714,51790,51791],
 [40241,40717,40776,40787,41808,41982,42075,42105,43647,44119,
   45376,45573,45713,45721,46633,46960,47157,47235,48118,48520,
   49936,49984,50905,50953],
 [40244,40245,40713,40719,40767,40773,40784,40788,41804,41809,
   41977,41985,42071,42079,42099,42107,43651,43656,45380,45381,
   45563,45567,45702,45708,45719,45723,46629,46637,49933,49941,
   49982,49987],
 [40247,40248,40723,40724,40769,40770,40793,40794,41805,41806,
   41975,41976,42068,42069,42102,42103,43652,43654,43938,43939,
   44126,44128,44623,44624,45382,45383,45564,45566,45704,45706,
   45727,45728,46628,46635,46873,46890,46967,46969,47150,47151,
   47242,47244,47897,47898,48113,48121,48269,48276,48525,48526,
   48720,48726,49931,49938,49979,49986,50327,50335,50900,50908,
   50948,50956,51253,51254,51520,51530,51670,51671,51832,51834,
   51881,51891],[40358,40665,42224,44312,45416,49961],
 [40372,43449,43873,46838,48891,48977,49153,49343],
 [40373,40374,40748,40749,42112,42116,42139,42143,43448,43450,
   43855,44221,44224,44302,45429,45430,45730,45731,46848,46985,
   46987,47526,47527,47647,48231,48636,48743,48747,48802,48871,
   49221,49242,49847,50627,51488,51835],
 [40376,40758,42231,42324,44324,45438,45741,49973],
 [40377,40378,40385,40386,40752,40753,40760,40761,42227,42228,
   42232,42233,42313,42314,42318,42319,43454,43455,43460,43462,
   43923,43957,44314,44318,44320,44321,44576,44605,45434,45436,
   45441,45442,45735,45737,45742,45743,46894,46938,46991,46992,
   46997,46999,47678,47684,47685,47686,47841,47885,48299,48333,
   48697,48738,49964,49968,49970,49971,50305,50350,50917,50923,
   50924,50925,51189,51234,51534,51578,51656,51700,51786,51815,
   51896,51937],
 [40379,40384,40754,40759,42234,42235,42320,42321,43453,43461,
   44313,44319,45435,45443,45736,45744,46990,46998,47679,47683,
   49963,49969,50918,50922],
 [40380,40757,42236,44316,45432,49965],
 [40421,40616,42347,42397,44002,45598,48021,48428],
 [40422,40539,42348,42396,43736,44001,45451,46716,47186,47187,
   48020,48426],
 [40427,40512,42349,42395,43734,44007,45478,46715,47040,47066,
   48022,48427],[40435,43559,47285,47958],
 [40436,40437,40625,40626,42118,42121,42145,42148,43585,43586,
   43706,44015,44016,44520,45645,45646,46565,46566,46686,47284,
   47286,47300,47302,47809,47931,47934,48012,48337,48340,48418,
   48749,48752,50280,51150,51611,51731],
 [40438,40444,40627,40633,42352,42360,42400,42408,44019,44023,
   45649,45653,48027,48032,48433,48438],
 [40439,40443,40634,40635,42354,42359,42401,42409,44018,44024,
   45655,45656,48025,48033,48432,48440],
 [40440,40441,40637,40638,42355,42356,42403,42404,43737,43745,
   43900,44020,44022,44581,45650,45652,46723,46724,46924,47296,
   47298,47306,47307,47855,48028,48030,48315,48430,48437,48692,
   50370,51211,51558,51713,51799,51919],
 [40442,40636,42357,43738,44021,46722,47297,47305,48029,48429],
 [40445,40446,40628,40632,42353,42361,42402,42407,44025,44026,
   45648,45654,48026,48034,48431,48439],
 [40447,40631,42358,42406,43742,44029,45659,46718,47289,47313,
   48023,48435],
 [40448,40449,40629,40630,42350,42351,42398,42399,43743,43744,
   43944,44027,44028,44622,45657,45658,46717,46725,46880,47290,
   47291,47312,47314,47899,48024,48031,48286,48434,48436,48721,
   50326,51252,51513,51679,51833,51874],
 [40452,40481,42365,42381,43335,43402,45293,47585,47609,47901,
   49804,51581],
 [40465,40494,42266,42267,43351,43418,44225,44226,45309,47268,
   47316,47523,47524,47914,48888,49145,50702,51460],
 [40466,40467,40495,40496,44251,44252,44253,44372,44373,47267,
   47269,47315,47317,47496,47497,47499,47577,47601,47915,47916,
   48244,48650,48794,48820,49218,49239,49796,50624,51459,51461,
   51475,51836],
 [40468,40474,40497,40503,42369,42377,42385,42393,43353,43357,
   43420,43424,45311,45315,47592,47597,47616,47621,47917,47923,
   49811,49816,51585,51593],
 [40470,40471,40478,40479,40499,40500,40507,40508,42367,42368,
   42372,42373,42383,42384,42388,42389,43354,43356,43361,43362,
   43421,43423,43428,43429,43915,43956,44403,44409,44410,44411,
   44423,44429,44430,44431,44566,44610,45312,45314,45319,45320,
   46895,46936,47273,47274,47279,47281,47321,47322,47327,47329,
   47589,47593,47595,47596,47613,47617,47619,47620,47851,47880,
   47919,47920,47927,47928,48290,48334,48696,48740,49808,49812,
   49814,49815,50322,50351,50863,50869,50870,50871,51196,51240,
   51465,51466,51471,51473,51543,51577,51583,51584,51588,51589,
   51649,51694,51769,51814,51904,51938],
 [40472,40477,40501,40506,42374,42375,42390,42391,43355,43363,
   43422,43430,44404,44408,44424,44428,45313,45321,47272,47280,
   47320,47328,47588,47594,47612,47618,47921,47926,49807,49813,
   50864,50868,51464,51472,51590,51591],
 [40521,40548,49890,49891],[40522,42270,45459,49156],
 [40523,40524,42123,42150,45457,45458,48754,48805,48874,49014,
   49028,49850],
 [40525,40531,40532,40533,40553,40557,40559,40560,40672,40673,
   40677,40678,42414,42415,42422,42423,42428,42429,42434,42436,
   42439,42441,42446,42447,45460,45466,45467,45468,45488,45492,
   45494,45495,45607,45608,45612,45613,49994,49995,50002,50003,
   50008,50009,50014,50016,50019,50021,50026,50027],
 [40527,40528,40682,40683,42417,42418,42425,42426,45469,45470,
   45489,45491,49074,49116,49426,50010,50012,50018,50025,50854,
   52010,52043,52089,52126],
 [40529,40681,42419,42433,45471,45490,50011,50017],
 [40534,40556,40676,42420,42432,42445,45463,45498,45618,49998,
   50005,50023],
 [40535,40536,40554,40555,42430,42431,42437,42438,45462,45464,
   45616,45617,49075,49118,49425,49997,49999,50006,50013,50852,
   52011,52060,52088,52109],[40549,42271,45606,49155],
 [40550,40551,42124,42151,45604,45605,48755,48804,48873,49379,
   49849,50750],[40561,42444,45610,49992],
 [40562,40563,42442,42443,45609,45611,49469,49993,50000,50811,
   51982,52154],[40624,42265,44017,46539,47301,48364],
 [40668,49892],[40669,42269,45486,49157],
 [40670,40671,42122,42149,45484,45485,48753,48806,48875,49365,
   49851,50764],
 [40674,40675,42412,42413,45496,45497,49467,50022,50024,50810,
   51965,52155],
 [40711,40712,47230,47232,48803,48872,49223,49244,49848,50629,
   51151,51164],
 [40715,40716,47236,47237,49983,49985,50954,50955,51210,51219,
   51920,51925],
 [40747,42216,42263,44248,44269,45431,45732,46986,47500,47518,
   48256,48673,50129,50659,51479,51866],
 [40765,40766,41783,41784,42051,42052,43553,43555,43558,43636,
   45370,45371,45699,45700,46955,46957,47795,47796,47929,47961,
   47962,48082,51610,51624],[40805,49896],[40806,49904],
 [40812,40813,42274,42275,45777,45779,49167,49168],
 [40816,40821,42279,42280,45775,45783,47347,47355,48898,48902,
   49158,49164],[40817,42282,45773,49160],
 [40818,42283,45780,49162],[40819,42281,45772,49161],
 [40820,42276,45778,49169],
 [40825,40831,40833,40837,40843,40845,42128,42129,42136,42155,
   42156,42163,45753,45754,45755,45766,45767,45768,48759,48760,
   48767,48811,48816,48818,48880,48885,48887,49856,49861,49863,
   51947,51948,51949,52031,52037,52039],
 [40826,40838,42127,42154,45752,45765,48758,48817,48886,49862,
   51946,52032],
 [40830,40842,42135,42162,45748,45761,48766,48809,48878,49854,
   51942,52036],
 [40832,40844,42134,42161,45747,45760,48765,48810,48879,49855,
   51941,52038],
 [40850,40851,40860,40861,40868,40869,40873,40881,40898,40899,
   40903,40904,40910,40911,42450,42451,42459,42460,42461,42469,
   42472,42473,42487,42488,42498,42499,42503,42504,45795,45797,
   45807,45808,45810,45822,45823,45825,45832,45833,45841,45842,
   45844,45845,50040,50042,50048,50049,50055,50067,50069,50070,
   50077,50078,50086,50087,50090,50091,52175,52176,52184,52185,
   52230,52231,52235,52250,52270,52271,52274,52277,52283,52284,
   52286,52290,52339,52340,52363,52364,52366,52367,52372,52374,
   52384,52388,52391,52393],
 [40852,40857,40867,40902,42474,42482,42483,42508,45815,45817,
   45818,45843,50032,50037,50038,50082],
 [40853,40855,40864,40865,40896,40901,42476,42478,42484,42485,
   42492,42493,45788,45790,45799,45800,45831,45836,50056,50058,
   50064,50065,50072,50073],
 [40858,40859,40872,40875,40880,40883,40907,40908,42452,42458,
   42462,42468,42480,42481,42497,42502,45785,45787,45802,45803,
   45809,45824,45837,45838,50041,50047,50052,50054,50063,50079,
   50088,50089,52177,52183,52186,52229,52243,52269,52272,52276,
   52279,52285,52291,52318,52362,52368,52382,52390],
 [40862,40888,40889,40897,40909,42475,42489,42507,42509,42511,
   45794,45796,45816,45834,45846,50030,50039,50061,50068,50083],
 [40874,40882,42457,42467,45792,45793,50060,50062,52182,52227,
   52278,52319],
 [40887,40890,40906,42490,42506,42510,45786,45804,45839,50031,
   50053,50084],[41014,41817,45396,46413,50144,51068],
 [41016,41527,41819,41955,43772,44099,45398,45555,46411,48108,
   50142,51066],[41342,41344,41370,41490],[41343],
 [41369,41491],[41383,41496,41640,41663],
 [41529,41957,43770,44097,45557,48106],
 [41798,41972,45454,45482],[41836,45600],[41848,45693],
 [42119,42120,42146,42147,43349,43350,43416,43417,43854,45307,
   45308,46834,48750,48751,48966,49317],[42268,45647],
 [42312,45603],[42316,45740],[42405,45651],
 [42524,45931,45948,50474],
 [42535,42537,42558,42560,42696,42698,43048,43050,43688,43690,
   43751,43753,43807,44032,44034,44065,44067,44130,45851,45853,
   45957,45959,46116,46118,46444,48040,48042,48063,48065,48165,
   50099,50101,50201,50416,50418,51103],
 [42538,42567,42714,42884,45923,45963,45991,46008,48849,49199,
   50458,50504],[42540,42715,50375,50376],
 [42542,42581,45938,45970,50466,50486],
 [42543,42551,42578,42584,42720,42725,43061,43062,45935,45939,
   45966,45974,45996,46004,46130,46131,50463,50468,50477,50481,
   50492,50498,50510,50518],
 [42544,42579,42583,42719,43055,43059,45934,45940,45968,45973,
   45997,46002,46123,46129,50461,50469,50483,50499,50509,50517],
 [42545,42550,42585,42586,42718,42726,43054,43060,45941,45942,
   45967,45975,45995,46003,46124,46128,50462,50470,50476,50482,
   50493,50497,50511,50516],[42546,45943,45964,50478],
 [42552,42727,50484,50500],
 [42561,42857,45918,45961,45990,46035,50457,50505],
 [42577,50374],[42589,50467],[42699,45977,46120,50490],
 [42717,45999,46127,50502],[42721,45993,46132,50494],
 [42802,42963,43380,44136,46205,46509],
 [42804,42961,43382,44195,46203,46450],[43053,50377],
 [43057,50514],[43065,50515],[43434,46972,47675,50915],
 [43451,43459,46993,46995,47680,47681,50926,50928],
 [43452,46994,47682,50927],[43456,46988,47687,50919],
 [43457,43458,46989,46996,47688,47689,50920,50921],
 [43465,44162,47732,48185],[43466,44161,47733,48184],
 [43471,43824,44167,44505,46570,46649,47734,48186,48346,48537,
   48827,49261],
 [43475,43477,43534,44172,44331,44333,46486,46488,46647,47693,
   48532,48534],
 [43478,43664,43667,44200,44201,44330,46457,46458,46487,48127,
   48128,48533],[43479,47966],[43480,47939],
 [43482,44183,47737,48196],[43483,44184,46660,47739,48197,48609]
  ,[43484,44180,46658,47740,48192,48547,48612,50265],
 [43486,44181,46656,47742,48193,48539,48611,50263],
 [43487,44178,46655,47744,48189,48615],
 [43488,43838,44179,44518,46654,46799,47745,48191,48548,48616,
   50254,51091],
 [43489,43836,44186,44517,46653,46791,47746,48190,48549,48614,
   50255,51090],
 [43490,43831,44185,44512,46661,46797,47738,48198,48541,48610,
   50259,51096],
 [43491,43832,44189,44516,46652,46793,47743,48187,48545,48619,
   50258,51101],[43492,46659,48188,48546,48620,50257],
 [43493,43834,44187,44509,46651,46794,47735,48195,48544,48618,
   50256,51100],[43524,46476,47765,50221],
 [43525,46475,47766,50220],
 [43530,43589,44335,44474,46481,46572,47696,47767,47941,48344,
   50222,51120],
 [43535,43665,43666,44141,44144,44171,46515,46516,46646,47694,
   48126,48129],[43536,44174,46645,47691],
 [43539,43791,44256,44326,47648,48217,48575,48825],
 [43540,44249,47501,48216,48573,50122],
 [43541,46497,47702,47770,48224,50232],
 [43542,46498,47772,50233],
 [43543,44345,46494,47705,47773,48221,48587,50228],
 [43544,43796,44337,44482,46496,47703,47774,48220,48585,50230],
 [43545,43550,43797,43805,44338,44342,44484,44485,46495,46503,
   46824,46832,47698,47704,47775,47776,48222,48227,48578,48586,
   50223,50229,51124,51128],
 [43546,46492,46823,47709,47777,48226,50225,51133],
 [43547,46493,47707,47778,48218,50227],
 [43548,46500,46822,47708,47779,48219,50226,51132],
 [43549,46499,46828,47700,47771,48223,50234,51127],
 [43551,50224],[43552,50231],[43556,47780,47963,48591],
 [43562,44475],[43563,43809],[43564,46789],[43565,51105],
 [43566,49320],[43567,48969],[43568,50705],
 [43569,43577,47799,47800,47977,47979,51634,51636],
 [43570,47801,47978,51635],[43571,47802,47974,51630],
 [43572,47803,47976,51632],[43573,47804,47975,51631],
 [43574,47806,47972,51627],
 [43575,43576,47807,47808,47973,47980,51628,51629],
 [43578,51625],[43579,51626],[43580,51633],
 [43583,43670,44228,44458,46691,46806,47533,47781,47936,48130,
   48492,48590],[43590,43808],[43591,46788],[43592,51104],
 [43593,49319],[43594,48968],[43595,50704],
 [43596,43724,47812,47825,47950,48099,51621,51648],
 [43597,43717,44525,44538,46581,46701,47814,47826,47951,48098,
   48351,48498,48961,49312,50290,50302,51622,51647,51734,51759],
 [43598,47815,47947,51617],[43599,47816,47949,51619],
 [43600,47817,47948,51618],
 [43601,43721,44533,44546,46577,46697,47819,47831,47945,48092,
   48357,48504,48962,49010,49313,49361,50285,50297,51163,51176,
   51614,51639,51742,51767],
 [43602,43723,44531,44545,47820,47833,47946,48100,48955,49305,
   51616,51640],
 [43603,43722,44532,44544,46584,46696,47821,47832,47953,48093,
   48358,48503,48954,49002,49306,49354,50284,50295,51162,51174,
   51615,51641,51743,51766],
 [43604,43716,44524,44539,46583,46702,47813,47824,47952,48097,
   48359,48499,48960,49008,49310,49358,50292,50303,51154,51169,
   51623,51646,51735,51761],[43605,51612],[43606,51613],
 [43607,51620],[43660,44255,44457,47782,48083,48592],
 [43668,44375,44459,48372],[43669,48345],
 [43671,43682,44462,44465,46810,46814,47785,47789,48137,48138,
   48601,48602],
 [43672,43680,44463,44467,47787,48139,48593,48603],
 [43673,43678,44460,44469,47784,47794,48141,48143,48596,48598],
 [43674,43677,44461,44470,46815,46818,47783,47793,48134,48142,
   48597,48600],
 [43675,43676,44468,44471,46808,46817,47791,47792,48133,48144,
   48595,48599],
 [43679,43681,47786,47788,48135,48140,48594,48604],
 [43709,44334,44476,48371],[43710,43810],[43712,51106],
 [43713,44379,49304,49321],[43714,48970],[43715,50706],
 [43718,44522,49314,51642],[43719,44523,49315,51644],
 [43720,51643],[43725,44529,49308,51637],[43726,51638],
 [43727,51645],[43735,46714,47039,47067],
 [43739,46721,47292,47309],
 [43740,43748,46720,46728,47294,47295,47310,47311],
 [43741,43746,46719,46727,47287,47293,47304,47308],
 [43747,46726,47288,47303],[43774,46753,48930,49282],
 [43775,46755,50666,50667],[43778,46760,51283,51300],
 [43779,46759,51285,51301],[43786,46765,51279,51294],
 [43787,46767,51286,51302],[43792,44229],
 [43794,44339,44486,48581],[43795,44340,44487,48583],
 [43798,44483],[43799,44348,44479,48584],
 [43800,44347,44481,48577],[43801,44346,44480,48576],
 [43802,44341,44488,48582],
 [43803,44344,44477,46502,47706,47769,48229,48579],
 [43804,44478],[43811,43820],[43812,43821],[43813,43816],
 [43814,43818],[43815,43817],[43819,43822],
 [43825,44507,46543,50646],[43826,44506,46690,48910],
 [43827,44514,46800,51094],[43828,46801],
 [43829,44511,46796,51097],[43830,44510,46798,51095],
 [43833,44508,46795,51099],[43837,46792],[43839,49262],
 [43840,43841,48911,50647],[43842,43848,51111,51116],
 [43843,51117],[43844,43845,51112,51114],[43846,51113],
 [43847,51109],[43849,51110],[43850,51118],[43851,51107],
 [43852,51108],[43853,51115],[43856,44384,49331,51506],
 [43857,44385,49332,51508],
 [43858,44382,46853,47662,48259,48654,48838,48993,49276,49327,
   51510,51848],
 [43859,43867,44383,44387,46852,46860,47657,47663,48261,48266,
   48655,48660,48831,48837,48994,48995,49269,49273,49329,49330,
   51503,51511,51839,51847],[43860,46851,48992,49328],
 [43861,49324],[43862,49326],[43863,44391,49325,51501],
 [43864,49333],
 [43865,44389,46859,47665,48268,48661,48832,48988,49274,49322,
   51504,51841],[43866,46858,48987,49323],
 [43869,48980,50657,51868],[43870,48981],
 [43871,44268,46840,47511,48255,48674,48976,49344,50136,50660,
   51480,51865],
 [43872,44267,46839,47510,48254,48672,48978,49345,50128,50658,
   51478,51864],[43874,48973],[43875,48975,50662,51862],
 [43876,48974],[43877,48982],[43879,46845,48972,49338],
 [43880,46847,48979,49346],[43881,48921,50716,51856],
 [43882,50717],
 [43883,44241,46865,47538,48242,48649,48924,49190,50712,50729,
   51493,51853],
 [43884,44240,46864,47537,48241,48647,48922,49182,50714,50730,
   51491,51852],
 [43885,43890,44242,44243,46863,46871,47544,47545,48235,48243,
   48640,48648,48917,48923,49183,49187,50707,50713,50724,50728,
   51492,51500,51854,51859],[43886,50709],
 [43887,48926,50711,51850],[43888,50710],[43889,50718],
 [43891,46870,50708,50723],[43892,46872,50715,50731],
 [43894,44560,46913,47857,48292,51229,51561,51697,51801,51906],
 [43895,44570,47858,48307,51227,51562,51706,51898],
 [43896,46898,47859,48300,51702,51800],
 [43897,43940,44588,44603,46888,46889,47861,47869,48273,48275,
   48690,48727,50348,50349,51218,51233,51560,51565,51676,51678,
   51805,51812,51921,51926],
 [43899,43945,44586,44602,46879,46925,47863,47870,48285,48316,
   48691,48722,50334,50341,51216,51232,51517,51528,51684,51693,
   51804,51813,51878,51889],
 [43901,44584,51192,51544,51657,51927],[43902,51667],
 [43903,51709],
 [43904,44561,46911,47872,48293,48677,50362,51570,51698,51793],
 [43905,44571,47873,48308,51571,51707],
 [43906,46896,47874,48301,48676,50353,51703,51792],
 [43908,43909,44594,44595,46877,46920,47877,47878,48284,48321,
   48679,48681,50332,50340,51519,51529,51685,51692,51796,51798],
 [43911,44592,48684,50323,51546,51658],
 [43912,48685,50365,51668],[43913,51710],
 [43916,46886,47882,48270,48707,50345,51672,51823],
 [43917,46914,47883,48280,51246,51687,51824,51876],
 [43918,44567,46876,48706,50330,51521,51680,51822],
 [43919,46912,48687,50363,51699,51808],
 [43920,43936,44565,44611,46900,46916,47850,47881,48298,48305,
   48704,48711,50321,50352,51195,51241,51548,51557,51653,51664,
   51773,51784,51909,51918],[43922,46917,51696,51821],
 [43924,47887,48272,51674],[43925,47888,48282,51237,51689,51875]
  ,[43926,44577,51522,51682],[43927,51708],
 [43928,43937,44575,44606,46902,46909,47840,47886,48304,48313,
   48702,48718,50309,50320,51193,51204,51542,51549,51655,51701,
   51785,51816,51901,51917],[43929,46908,51665,51775],
 [43931,46884,47891,48271,48699,50343,51673,51818],
 [43932,46899,47892,48281,51688,51819],
 [43933,46874,48698,50328,51681,51817],
 [43934,46897,48686,50354,51704,51807],
 [43941,48729,50318,51650],[43942,48730,50346,51660],
 [43943,51675],[43946,51197,51652,51882],[43947,51662],
 [43948,51690],[43950,44616,48724,50316,51515,51651],
 [43951,48725,50331,51661],[43952,51683],
 [43953,48694,50324,51659],[43954,48695,50366,51669],
 [43955,51711],[44101,46941,47136,47183,48111,48518,50897,50947]
  ,[44117,44123,46959,46963,47154,47155,47240,47241,48115,48123,
   48522,48530,50904,50909,50951,50959],
 [44118,44122,46958,46964,47147,47153,47234,47238,48117,48122,
   48523,48528,50902,50910,50950,50958],
 [44124,44125,46965,46966,47148,47152,47233,47239,48116,48124,
   48521,48529,50903,50911,50952,50957],
 [44131,44132,48167,48168],[44137,48169],[44145,47965],
 [44146,47938],[44147,48085],[44148,44153,48172,48179],
 [44149,44154,48174,48180],[44150,48175],
 [44151,44152,48176,48177],[44155,44156,48173,48181],
 [44157,48170],[44158,48171],[44159,48178],
 [44176,46640,47503,48489,48608,50253],
 [44177,46536,47650,48369,48607,50251],[44188,47736],
 [44190,46446,48200,50204],[44191,44206,46445,48201,50121,50203]
  ,[44196,44205,46451,48202,48824,50205],[44204,49175],
 [44207,44210,46466,46467,48205,48209,50213,50215],
 [44208,46468,48207,50216],
 [44209,44215,46464,46469,48206,48208,50211,50217],
 [44211,46465,48210,50212],[44212,44216,46462,48212,50206,50208]
  ,[44213,46463,46471,48203,48213,50210],
 [44214,44217,46470,46472,48204,48214,50207,50209],
 [44218,50214],[44232,49303],[44233,48952],[44234,50688],
 [44235,47542,48234,48641,48925,49189,51498,51861],
 [44236,47543,48236,48642,48918,49188,51499,51860],
 [44237,47539,48237,51494],[44238,47541,48238,51496],
 [44239,47540,48239,51495],[44244,51489],[44245,51490],
 [44246,51497],[44258,51087],[44259,49302],[44260,48951],
 [44261,48377,50125,50687],
 [44262,47515,48247,48666,50135,50661,51485,51873],
 [44263,47516,48249,48667,50134,50654,51486,51872],
 [44264,47512,48250,51481],[44265,47514,48251,48663,50137,51483]
  ,[44266,47513,48252,51482],[44271,48668,50130,51476],
 [44272,48670,50131,51477],[44273,51484],[44336,48491],
 [44343,46501,47699,47768,48228,48580],[44378,51089],
 [44380,48953],[44381,50689],[44386,51507],
 [44388,47658,48267,48662,48839,49275,51505,51840],
 [44390,47664,48260,48653,48836,49268,51512,51846],
 [44392,51502],[44393,51509],
 [44402,44422,47185,47188,50686,50862],
 [44405,44407,44425,44427,47275,47276,47323,47324,50865,50867,
   51467,51468],[44406,44426,47277,47325,50866,51469],
 [44412,44413,44432,44433,47270,47271,47318,47319,50872,50873,
   51462,51463],[44414,44434,47278,47326,50874,51470],
 [44441,50665],[44445,51268],[44453,51269],[44464,44466],
 [44515,51093],[44519,51098],
 [44526,44537,46582,46703,48352,48506,48959,49311,50291,50304,
   51736,51760],[44527,49307],[44528,49309],[44530,49316],
 [44535,46700,48963,51763],[44536,48964],[44540,48956],
 [44541,46705,48958,51757],[44542,48957],[44543,48965],
 [44547,46553,48381,50275,50699,51751],[44548,50700],
 [44549,44551,46555,46556,48379,48386,50278,50279,50695,50696,
   51748,51749],[44550,46554,48378,50277,50697,51747],
 [44552,48387,50268,50692],[44553,46558,50694,51745],
 [44554,48388,50269,50693],[44555,50701],
 [44556,44557,46549,46557,48383,48385,50270,50271,50690,50691,
   51754,51756],[44558,50698],
 [44562,47865,48294,51214,51566,51905],
 [44563,44574,47838,47849,48296,48312,48710,48719,50311,50357,
   51205,51236,51540,51556,51903,51910],
 [44568,48708,50338,51531],[44569,51573],
 [44572,47866,48309,51212,51567,51897],[44578,51532],
 [44579,51574],[44582,47835,48317,51202,51536,51928],
 [44583,46930,47845,48318,51230,51551,51771,51929],
 [44585,51228,51563,51913],[44590,47837,48322,48683,50313,51538]
  ,[44591,46921,47847,48323,51553,51770],[44593,51572],
 [44597,47836,48326,51200,51537,51923],
 [44598,47846,48327,51215,51552,51924],
 [44599,51190,51545,51922],[44600,51213,51568,51912],
 [44607,48723,50306,51514],[44608,48732,50307,51524],
 [44609,51539],[44612,46881,51516,51777],[44613,51526],
 [44614,51554],[44617,48733,50317,51525],[44618,51547],
 [44619,51523],[44620,51533],[44621,51575],
 [46018,46046,48935,50670],[46019,48934],
 [46020,46166,48933,49285],[46030,46321,48939,51343],
 [46031,46322,48938,51341],[46032,46329,48940,51342],
 [46045,50671],[46047,46165,49286,50669],
 [46057,46308,50675,51355],[46058,46309,50674,51353],
 [46059,46316,50676,51354],[46167,49284],
 [46170,46338,49297,51324],[46171,46340,49296,51323],
 [46172,46339,49298,51331],[46177,46333,49290,51330],
 [46178,46334,49289,51328],[46179,46341,49291,51329],
 [46353,51393],[46354,46363,51385,51391],
 [46355,46405,51392,51400],[46364,51383],
 [46365,46406,51384,51398],[46378,51368],
 [46379,46404,51363,51413],[46407,51399],
 [46414,47001,50146,50931],
 [46415,46420,47000,47006,50147,50148,50930,50932],
 [46431,46439,47022,47024,50151,50152,50942,50944],
 [46432,47023,50153,50943],[46436,47017,50158,50935],
 [46437,46438,47018,47025,50159,50160,50936,50937],
 [46459,47967],[46460,47940],[46461,48087],[46473,48211],
 [46489,47532],[46490,47505],[46504,46505,50236,50237],
 [46510,50238],[46518,49177],[46519,48826],[46520,50123],
 [46521,46526,50241,50248],[46522,46527,50243,50249],
 [46523,50244],[46524,46525,50245,50246],
 [46528,46529,50242,50250],[46530,50239],[46531,50240],
 [46532,50247],[46544,46805],[46545,51121],[46546,49336],
 [46547,48985],[46548,50721],[46550,48384,50272,51755],
 [46551,48380,50273,51750],[46552,48382,50274,51752],
 [46559,51746],[46560,51753],[46571,46804],[46573,49335],
 [46574,48984],[46575,50720],
 [46576,46704,48356,48505,50283,50296,51741,51768],
 [46578,48353,50286,51737],[46579,48355,50287,51739],
 [46580,48354,50288,51738],[46585,51732],[46586,51733],
 [46587,51740],[46648,48373],[46650,48493],[46662,48617],
 [46692,51122],[46693,49337],[46694,48986],[46695,50722],
 [46698,51762],[46699,51764],[46706,51758],[46707,51765],
 [46807,46816],[46809,46812],[46811,46813],[46819,49263],
 [46821,50648],[46825,51130],[46826,51129],[46827,51125],
 [46829,51126],[46830,51134],[46831,51123],[46833,51131],
 [46836,49347],[46837,49348],[46841,49340],[46842,49342],
 [46843,49341],[46844,49349],[46849,48996],[46850,48997],
 [46854,48989],[46855,48991],[46856,48990],[46857,48998],
 [46861,50732],[46862,50733],[46866,50725],[46867,50727],
 [46868,50726],[46869,50734],[46875,48713,50329,51826],
 [46882,51787],[46883,51829],[46885,48714,50344,51827],
 [46891,47852,48278,51778],[46892,47894,48279,51788],
 [46893,51830],[46904,48678,50358,51794],
 [46905,48688,50359,51809],[46906,51802],[46907,51828],
 [46922,47875,48324,51780],[46923,51795],[46926,51772],
 [46927,51782],[46928,51810],[46931,47860,48319,51781],
 [46932,51803],[46933,47853,48288,51249,51779,51884],
 [46934,47895,48289,51789],[46935,51831],
 [47042,47044,49015,49225,49246,50631],[47043,48895],
 [47045,47051,47052,47053,47073,47077,47079,47080,47192,47193,
   47197,47198,50964,50965,50972,50973,50978,50979,50984,50986,
   50989,50991,50996,50997],
 [47047,47055,47074,47202,50967,50976,50980,50988],
 [47048,47049,47054,47056,47075,47076,47201,47203,49083,49117,
   49434,50853,50968,50969,50975,50981,50982,50983,50987,50995,
   52016,52050,52094,52116],
 [47069,47071,47189,47191,49224,49226,49245,49247,49366,50630,
   50632,50751],[47070,47190,48894,48896],
 [47081,47083,47195,47196,49468,50819,50962,50970,50993,50994,
   51972,52160],[47082,47194,50963,50992],
 [47332,47339,47357,47364,49230,49236,49251,49257,50636,50642,
   51953,51960],
 [47333,47337,47358,47362,49229,49237,49250,49258,50635,50643,
   51954,51958],
 [47338,47340,47363,47365,49231,49238,49252,49259,50637,50644,
   51959,51961],[47345,47352,48900,48906],
 [47346,47350,48899,48907],[47351,47353,48901,48908],
 [47370,47388,47392,47395,47423,47427,51011,51012,51018,51022,
   51047,51049],
 [47371,47372,47387,47389,47400,47403,47407,47410,47422,47424,
   47426,47428,51001,51002,51008,51023,51024,51033,51040,51052,
   51054,51056,51058,51060,52194,52198,52205,52225,52273,52296,
   52311,52314,52376,52378,52383,52389],
 [47373,47375,47384,47385,47416,47421,51026,51028,51034,51035,
   51042,51043],
 [47377,47379,47402,47409,51007,51031,51032,51059,52224,52228,
   52313,52324],[47378,47394,51017,51030],
 [47380,47393,47418,47430,51010,51019,51037,51048],
 [47381,47382,47401,47408,47417,47419,47429,47431,51000,51009,
   51025,51038,51039,51053,51057,51061,52190,52226,52239,52312,
   52345,52373,52377,52392],[47506,48131],[47507,47970],
 [47508,47943],[47509,48090],[47519,48245,48669,50132],
 [47520,48246],[47521,48253],[47534,47969],[47535,47942],
 [47536,48089],[47546,48232],[47547,48233],[47548,48240],
 [47653,48132],[47654,47971],[47655,47944],[47656,48091],
 [47659,48262],[47660,48264],[47661,48263,48651,48840],
 [47666,48257,48657,48835],[47667,48258],[47668,48265],
 [47695,47968],[47697,48088],[47701,48225],[47790,48136],
 [47797,47981],[47798,47982],[47805,47983],[47810,47954],
 [47811,47955],[47818,47956],[47822,48101],[47823,48102],
 [47827,48094],[47828,48096],[47829,48095],[47830,48103],
 [47842,48277,48728,50308],[47843,48287,51207,51883],
 [47844,48329,51208,51893],[47854,48330,51250,51894],
 [47867,48302],[47868,48328],[47884,48295,51247,51886],
 [47889,48310,51238,51885],[47893,48303],[47896,48331],
 [48348,49180],[48349,48829],[48350,50126],[48360,50281],
 [48361,50282],[48362,50289],[48375,49179],[48376,48828],
 [48389,50276],[48495,49181],[48496,48830],[48497,50127],
 [48500,50298],[48501,50300],[48502,50299],[48507,50293],
 [48508,50294],[48509,50301],[48536,49178],[48538,50124],
 [48542,50261],[48543,50260],[48550,50262],[48638,49191],
 [48639,49192],[48643,49184],[48644,49186],[48645,49185],
 [48646,49193],[48652,48841],[48656,48833],[48658,48834],
 [48659,48842],[48664,50138],[48671,50139],[48693,50314],
 [48700,50336],[48701,50355],[48709,50364],[48715,50337],
 [48716,50360],[48734,50339],[48735,50315],[48736,50325],
 [48737,50367],[48913,51136],[48914,49351],[48915,49000],
 [48916,50736],[48919,51855],[48920,51857],[48927,51851],
 [48928,51858],[48932,49283,51069,51070],[48999,49266],
 [49001,50651],[49003,49353,51161,51175],[49004,51170],
 [49005,51172],[49006,51171],[49007,49359,51156,51167],
 [49009,49360,51155,51168],[49011,51165],[49012,51166],
 [49013,51173],[49016,49048,49389,50768],
 [49017,49046,49390,50767],[49018,49051,49385,50766],
 [49019,49050,49387,50765],[49020,49052,49386,50773],
 [49021,49042,49382,50775],[49022,49049,49384,50776],
 [49023,49041,49383,50774],[49024,49047,49391,50769],
 [49025,49044,49380,50772],[49026,49043,49381,50770],
 [49027,49045,49388,50771],[49029,49032,49036,49038],
 [49030,49031,49034,49039],[49033,49035,49037,49040],
 [49054,49111,49427,50808,51988,52055,52091,52128],
 [49055,49110,49424,49442,50809,50827,51989,52026,52045,52100,
   52133,52170],
 [49056,49112,49435,49437,50797,50807,51990,51998,52077,52096,
   52117,52118],
 [49061,49086,49463,50792,51999,52051,52076,52162],
 [49062,49078,52061,52074],
 [49063,49092,49093,49115,49416,50837,52023,52075,52082,52103,
   52105,52110],
 [49064,49102,49428,50850,52003,52054,52092,52129],
 [49065,49101,49414,49443,50829,50851,52004,52025,52044,52101,
   52141,52171],
 [49066,49103,49436,50849,52005,52069,52097,52119],
 [49071,49084,49407,50848,52018,52052,52068,52143],
 [49072,49076,49405,50847,52013,52062,52066,52121],
 [49073,49091,49406,50846,52022,52067,52104,52111],
 [49077,49114,49415,50838,52014,52063,52081,52120],
 [49079,49107,52056,52093],[49080,49089,52047,52059],
 [49082,49096,52058,52090],
 [49085,49113,49417,50839,52019,52053,52083,52135],
 [49087,49106,52046,52102],[49088,52049],
 [49094,49108,52084,52098],[49097,52095],[49264,51135],
 [49265,49350],[49267,50735],[49270,51842],[49271,51844],
 [49272,51843],[49277,51837],[49278,51838],[49279,51845],
 [49352,50650],[49355,51157],[49356,51159],[49357,51158],
 [49362,51152],[49363,51153],[49364,51160],
 [49367,49376,50780,50784],[49368,49377,50779,50782],
 [49369,49372,50778,50787],[49370,49374,50777,50786],
 [49371,49373,50785,50788],[49375,49378,50781,50783],
 [49392,49395,50759,50761],[49393,49394,50757,50762],
 [49396,49400,50758,50763],
 [49397,49399,49401,49402,50752,50753,50754,50755],
 [49398,49403,50756,50760],
 [49412,49413,50814,50822,51973,51983,52140,52142],
 [49422,50820,51974,52134],[49423,50812,51984,52132],
 [49429,50798,51996,52127],[49430,50843,52015,52122],
 [49431,50825,51969,52125],[49433,50832,52012,52124],
 [49438,50842,52024,52112],
 [49439,49440,50816,50824,51971,51981,52113,52115],
 [49444,50799,51997,52169],[49445,50844,52020,52150],
 [49447,50818,51980,52156],[49448,50833,52017,52161],
 [49452,49462,50790,50801,51966,51977,52157,52167],
 [49453,49461,50791,50800,51967,51976,52158,52166],
 [49454,50802,51991,52163],[49457,50823,51968,52168],
 [49458,50815,51978,52159],[49459,50830,52006,52164],
 [49464,50821,51975,52149],[49465,50813,51985,52147],
 [49466,50828,52027,52148],[50649,51137],[50652,50737],
 [50655,51867],[50656,51869],[50663,51863],[50664,51870],
 [50668,51071],[50738,50739,51186,51187],[50740,51182],
 [50741,51184],[50742,51183],[50743,50744,51179,51181],
 [50745,51180],[50746,51188],[50747,51177],[50748,51178],
 [50749,51185],[51074,51076,51314,51315],[51075,51316],
 [51081,51082,51309,51310],[51083,51317],[51138,51147],
 [51139,51148],[51140,51143],[51141,51145],[51142,51144],
 [51146,51149],[51191,51931],[51198,51892],[51199,51934],
 [51201,51932],[51209,51935],[51220,51899],[51221,51914],
 [51222,51907],[51223,51933],[51224,51225,51880,51890],
 [51239,51900],[51242,51877],[51243,51887],[51244,51915],
 [51248,51908],[51251,51936],
 [52187,52214,52245,52249,52267,52293,52305,52327],
 [52189,52191,52204,52212,52222,52223,52242,52244,52321,52326,
   52331,52333],
 [52193,52241,52248,52252,52263,52292,52295,52307,52348,52352,
   52369,52371],
 [52195,52197,52199,52200,52202,52213,52221,52234,52236,52266,
   52268,52298,52302,52322,52330,52334],
 [52207,52262,52304,52320],[52208,52325,52353,52379],
 [52233,52238,52264,52300,52341,52343,52355,52370],
 [52253,52297,52344,52346,52349,52356,52380,52381]];

#############################################################################
##
#E  3ctsgrp-conjugacyclasses.g . . . . . . . . . . . . . . . . . .  ends here