#############################################################################
##
#W  3ctsgrp-finite-orbits.g          GAP4 Package `RCWA'          Stefan Kohl
##
##  This file contains the part of the data library of groups generated by
##  3 class transpositions which concerns finite orbits of these groups.
##
##  Its contents are a record 'finiteorbits' with the following components:
##
##  - 'exceed' is a list of length 10, and exceed[k] is the list of the
##    indices of those groups which are believed to have only finite orbits,
##    but which have orbits longer than 256 which intersect nontrivially with
##    the interval [-2^k..2^k].
##
##  - 'dontexceed' is a list of length 10, and dontexceed[k] is the list of
##    the indices of those groups which are believed to have not only finite
##    orbits, but all of whose orbits which intersect nontrivially with the
##    interval [-2^k..2^k] have length <= 128.
##
##  - 'maxorbitlengths' is a list of length 10 of lists of length
##    Length(grps) = 52394. maxorbitlengths[k][i] is the length of the lon-
##    gest finite orbit of grps[i] which intersects nontrivially with the
##    interval [-2^k..2^k] if all orbits intersecting with this interval
##    have length <= 256, and unbound otherwise.
##
#############################################################################

return rec(

exceed :=
[ [ 4474,6595,11685,11689,28892,30206,32435,32700,32723,35800,
   36096,38102,38122,49005,50301,51172 ],
 [ 4474,6595,11685,11689,28892,30206,31337,32435,32700,32723,
   35800,36095,36096,36103,37818,37851,38102,38122,48509,49005,
   50300,50301,51172,51617 ],
 [ 1277,1280,1284,1286,4436,4463,4474,6595,6608,9729,11685,11689,
   16635,20096,20185,25064,27204,27212,28581,28608,28872,28892,
   30206,30211,30218,31211,31337,31472,31485,31766,32385,32414,
   32434,32435,32562,32700,32705,32718,32723,35016,35800,36095,
   36096,36103,36916,37496,37818,37851,38102,38122,38133,43598,
   44528,47815,47947,48509,49005,49356,50300,50301,51159,51172,
   51617 ],
 [ 1277,1280,1284,1286,4436,4463,4474,6595,6608,9729,11215,11685,
   11689,16635,20096,20185,20430,23437,24819,25064,26491,27204,
   27212,27508,27754,27802,28521,28581,28608,28872,28892,29039,
   29586,29909,29935,30063,30205,30206,30211,30217,30218,31211,
   31337,31472,31485,31766,31820,32168,32303,32359,32385,32414,
   32415,32434,32435,32562,32699,32700,32705,32711,32718,32723,
   33887,34712,35016,35794,35799,35800,35941,35946,36095,36096,
   36103,36835,36916,37496,37651,37818,37824,37851,37966,37971,
   38102,38107,38122,38133,43598,44528,46585,47811,47815,47827,
   47947,48509,49005,49309,49356,49364,50300,50301,51159,51160,
   51172,51617,51732 ],
 [ 1277,1280,1284,1286,4436,4455,4463,4474,6577,6594,6595,6608,
   6622,9729,11215,11441,11685,11689,14984,15138,15157,16635,
   18592,20096,20185,20236,20430,21839,23437,24767,24819,25064,
   26491,27203,27204,27212,27508,27509,27754,27802,28521,28581,
   28608,28616,28871,28872,28892,28898,29039,29586,29909,29935,
   29943,30054,30062,30063,30192,30205,30206,30211,30217,30218,
   31211,31330,31337,31472,31485,31766,31820,32168,32303,32359,
   32385,32414,32415,32434,32435,32556,32562,32563,32699,32700,
   32705,32706,32711,32718,32723,32725,33789,33790,33887,33899,
   34712,34720,35014,35016,35794,35799,35800,35826,35941,35946,
   36095,36096,36103,36107,36835,36916,36976,37037,37496,37651,
   37818,37824,37851,37852,37965,37966,37971,37972,38046,38102,
   38107,38122,38127,38128,38133,38134,43598,43726,44528,44535,
   46580,46585,46700,46705,47811,47815,47827,47947,48094,48354,
   48509,48963,49005,49013,49309,49356,49364,50288,50300,50301,
   51159,51160,51172,51617,51638,51732 ],
 [ 1277,1280,1284,1286,4436,4444,4455,4463,4474,4477,6572,6577,
   6594,6595,6608,6622,6630,9729,10451,11215,11441,11685,11689,
   14984,15138,15157,16635,17768,18592,20096,20185,20236,20430,
   20808,20830,21007,21839,23437,24767,24819,25064,25999,26016,
   26039,26491,27203,27204,27212,27506,27508,27509,27754,27802,
   28521,28581,28582,28608,28610,28616,28871,28872,28874,28892,
   28898,29039,29586,29909,29916,29935,29943,30054,30056,30062,
   30063,30192,30205,30206,30211,30217,30218,31211,31218,31330,
   31337,31472,31473,31485,31487,31766,31820,32168,32303,32359,
   32385,32414,32415,32434,32435,32443,32554,32556,32562,32563,
   32692,32693,32699,32700,32705,32706,32711,32718,32722,32723,
   32725,33789,33790,33887,33893,33899,33901,34711,34712,34720,
   35014,35016,35017,35794,35799,35800,35826,35941,35946,36084,
   36085,36095,36096,36103,36107,36108,36110,36835,36916,36976,
   36981,36983,37037,37040,37496,37651,37818,37824,37851,37852,
   37853,37965,37966,37971,37972,38046,38102,38103,38107,38122,
   38127,38128,38133,38134,43598,43606,43726,44528,44535,44541,
   46580,46585,46700,46705,47811,47815,47827,47947,48094,48354,
   48509,48963,49005,49013,49309,49356,49364,50288,50300,50301,
   51159,51160,51172,51248,51613,51617,51638,51732,51908 ],
 [ 1098,1100,1232,1235,1277,1280,1284,1286,4436,4444,4455,4463,
   4474,4477,5456,6572,6577,6594,6595,6608,6622,6630,9729,
   10451,11215,11441,11685,11689,14984,15138,15157,15359,15366,
   16635,17768,18592,20096,20185,20236,20285,20430,20520,20526,
   20808,20830,21007,21839,23437,23497,23498,24767,24819,24921,
   25064,25156,25157,25999,26016,26039,26491,27203,27204,27212,
   27415,27506,27508,27509,27754,27802,28521,28581,28582,28608,
   28610,28616,28871,28872,28874,28892,28898,28899,29039,29586,
   29909,29916,29934,29935,29943,30054,30056,30062,30063,30192,
   30198,30205,30206,30211,30217,30218,31211,31218,31329,31330,
   31337,31338,31468,31472,31473,31485,31487,31766,31820,32168,
   32303,32359,32385,32407,32409,32414,32415,32416,32434,32435,
   32436,32441,32443,32554,32556,32562,32563,32692,32693,32699,
   32700,32705,32706,32710,32711,32713,32718,32722,32723,32725,
   33737,33789,33790,33887,33893,33899,33900,33901,34711,34712,
   34720,35014,35016,35017,35794,35799,35800,35821,35826,35941,
   35946,36082,36084,36085,36091,36095,36096,36097,36098,36103,
   36107,36108,36110,36835,36916,36975,36976,36981,36983,37037,
   37040,37137,37496,37651,37818,37824,37845,37851,37852,37853,
   37965,37966,37971,37972,38046,38102,38103,38107,38109,38122,
   38127,38128,38133,38134,43598,43606,43726,43925,43943,44528,
   44535,44541,46580,46585,46700,46705,47811,47815,47827,47844,
   47888,47947,48094,48354,48509,48963,49005,49013,49063,49092,
   49309,49356,49364,50288,50300,50301,50837,51159,51160,51172,
   51208,51237,51248,51613,51617,51638,51732,51908,52023,52075,
   52105 ],
 [ 1091,1094,1095,1096,1098,1099,1100,1101,1232,1233,1234,1235,
   1238,1239,1241,1243,1277,1280,1284,1286,3443,4436,4444,4455,
   4463,4474,4477,5456,6572,6577,6594,6595,6608,6622,6630,9729,
   10451,11215,11441,11685,11689,14984,15138,15157,15206,15359,
   15366,16635,17768,18592,20096,20185,20236,20285,20291,20430,
   20520,20526,20808,20830,21007,21839,23437,23497,23498,23627,
   24767,24819,24921,24922,25064,25156,25157,25999,26016,26039,
   26491,27203,27204,27212,27415,27502,27506,27508,27509,27754,
   27802,28275,28475,28521,28581,28582,28608,28610,28616,28871,
   28872,28874,28892,28896,28898,28899,29039,29586,29907,29908,
   29909,29915,29916,29934,29935,29943,30054,30056,30062,30063,
   30192,30198,30205,30206,30211,30217,30218,31121,31211,31218,
   31329,31330,31337,31338,31402,31468,31472,31473,31485,31487,
   31766,31820,32168,32303,32359,32385,32407,32409,32414,32415,
   32416,32434,32435,32436,32441,32442,32443,32554,32556,32562,
   32563,32692,32693,32697,32698,32699,32700,32705,32706,32710,
   32711,32713,32718,32722,32723,32725,33737,33789,33790,33887,
   33893,33899,33900,33901,34711,34712,34719,34720,35014,35016,
   35017,35794,35799,35800,35821,35826,35941,35946,36082,36084,
   36085,36091,36095,36096,36097,36098,36103,36107,36108,36110,
   36835,36916,36975,36976,36981,36983,37037,37040,37137,37496,
   37651,37818,37824,37844,37845,37851,37852,37853,37965,37966,
   37971,37972,38046,38102,38103,38107,38108,38109,38122,38127,
   38128,38133,38134,43598,43606,43726,43925,43943,44528,44535,
   44541,46580,46585,46700,46705,46891,47811,47815,47827,47844,
   47852,47888,47947,48094,48278,48354,48509,48963,49005,49013,
   49063,49092,49309,49356,49364,50288,50300,50301,50837,50842,
   51159,51160,51172,51208,51237,51248,51613,51617,51638,51732,
   51778,51908,52023,52024,52075,52105 ],
 [ 1091,1094,1095,1096,1098,1099,1100,1101,1232,1233,1234,1235,
   1238,1239,1241,1243,1277,1280,1284,1286,3302,3303,3307,3308,
   3313,3443,3447,3448,3449,4436,4444,4455,4463,4474,4477,5449,
   5451,5453,5456,5590,5592,5596,5597,5598,6572,6577,6594,6595,
   6608,6622,6630,9729,10451,11215,11441,11685,11689,14984,
   14998,14999,15138,15157,15206,15359,15366,16635,17768,18592,
   20096,20185,20236,20285,20291,20430,20520,20526,20808,20830,
   21007,21839,23385,23386,23437,23497,23498,23627,24767,24819,
   24921,24922,25064,25156,25157,25999,26016,26039,26491,27203,
   27204,27212,27351,27415,27502,27506,27508,27509,27754,27802,
   28275,28475,28521,28581,28582,28608,28610,28616,28871,28872,
   28874,28892,28896,28898,28899,29039,29586,29907,29908,29909,
   29915,29916,29934,29935,29943,30043,30054,30055,30056,30062,
   30063,30192,30193,30198,30205,30206,30211,30217,30218,31121,
   31211,31217,31218,31329,31330,31337,31338,31402,31468,31472,
   31473,31485,31487,31766,31820,32168,32303,32359,32385,32407,
   32409,32414,32415,32416,32434,32435,32436,32441,32442,32443,
   32554,32556,32562,32563,32692,32693,32697,32698,32699,32700,
   32705,32706,32710,32711,32713,32718,32722,32723,32725,33737,
   33789,33790,33887,33893,33899,33900,33901,34711,34712,34719,
   34720,35014,35016,35017,35794,35799,35800,35821,35826,35827,
   35941,35946,36062,36082,36084,36085,36091,36095,36096,36097,
   36098,36103,36107,36108,36109,36110,36835,36916,36975,36976,
   36981,36983,37037,37040,37137,37496,37651,37711,37756,37818,
   37824,37844,37845,37846,37851,37852,37853,37965,37966,37971,
   37972,38046,38102,38103,38107,38108,38109,38110,38122,38127,
   38128,38133,38134,43598,43606,43726,43925,43943,44528,44535,
   44541,46580,46585,46700,46705,46891,47811,47815,47827,47844,
   47852,47888,47947,48094,48278,48354,48509,48963,49005,49013,
   49063,49092,49108,49112,49309,49356,49364,49435,50288,50300,
   50301,50797,50837,50842,51159,51160,51172,51208,51237,51248,
   51613,51617,51638,51732,51778,51908,51998,52023,52024,52075,
   52096,52098,52105,52118 ],
 [ 1091,1094,1095,1096,1098,1099,1100,1101,1232,1233,1234,1235,
   1238,1239,1241,1243,1277,1280,1284,1286,3302,3303,3307,3308,
   3311,3313,3443,3446,3447,3448,3449,4436,4444,4455,4463,4474,
   4477,5449,5451,5453,5454,5456,5588,5590,5592,5596,5597,5598,
   6572,6577,6594,6595,6608,6622,6630,9729,10451,11215,11441,
   11685,11689,14984,14998,14999,15138,15157,15206,15347,15359,
   15366,16635,17768,18592,20096,20184,20185,20236,20285,20291,
   20430,20520,20526,20808,20830,21007,21839,23385,23386,23437,
   23486,23497,23498,23627,24767,24819,24921,24922,25064,25065,
   25156,25157,25999,26016,26039,26491,27203,27204,27212,27351,
   27415,27502,27506,27508,27509,27754,27802,28275,28475,28521,
   28581,28582,28608,28610,28616,28867,28871,28872,28874,28892,
   28896,28898,28899,29039,29586,29907,29908,29909,29915,29916,
   29934,29935,29943,30043,30054,30055,30056,30062,30063,30192,
   30193,30198,30205,30206,30211,30217,30218,31121,31211,31217,
   31218,31329,31330,31337,31338,31402,31468,31472,31473,31485,
   31487,31766,31820,32168,32303,32359,32376,32385,32407,32409,
   32414,32415,32416,32434,32435,32436,32441,32442,32443,32496,
   32554,32556,32562,32563,32692,32693,32697,32698,32699,32700,
   32705,32706,32710,32711,32713,32718,32722,32723,32725,33737,
   33789,33790,33887,33893,33899,33900,33901,34711,34712,34719,
   34720,35014,35016,35017,35028,35794,35799,35800,35821,35826,
   35827,35941,35946,36062,36082,36084,36085,36091,36095,36096,
   36097,36098,36103,36107,36108,36109,36110,36835,36916,36975,
   36976,36981,36983,37037,37040,37137,37496,37651,37711,37756,
   37818,37824,37844,37845,37846,37851,37852,37853,37965,37966,
   37971,37972,38046,38102,38103,38107,38108,38109,38110,38122,
   38127,38128,38133,38134,43598,43606,43726,43925,43943,44528,
   44535,44541,46580,46585,46700,46705,46891,47811,47815,47827,
   47844,47852,47888,47947,48094,48278,48354,48509,48963,49005,
   49013,49063,49092,49108,49112,49309,49356,49364,49435,50288,
   50300,50301,50797,50837,50842,51159,51160,51172,51208,51237,
   51248,51613,51617,51638,51732,51778,51908,51998,52023,52024,
   52075,52096,52098,52105,52118 ] ],

dontexceed :=
[ [ 61,63,65,66,122,123,124,125,294,295,315,316,319,324,356,
   357,377,378,381,386,536,537,557,558,561,566,651,652,672,
   673,676,681,831,832,836,839,869,870,884,885,890,891,895,
   900,936,937,941,942,943,944,947,952,970,972,973,983,996,
   997,1000,1002,1022,1023,1043,1044,1046,1047,1048,1050,1052,
   1053,1092,1093,1097,1102,1117,1130,1146,1148,1164,1177,1190,
   1191,1193,1194,1195,1196,1210,1223,1236,1237,1240,1242,1255,
   1257,1258,1268,1278,1279,1282,1287,1364,1365,1366,1367,1406,
   1407,1408,1409,1487,1488,1489,1490,1526,1527,1528,1529,1642,
   1644,1646,1647,1677,1679,1681,1682,1706,1709,1710,1712,1713,
   1714,1715,1717,1743,1744,1746,1747,1748,1749,1771,1774,1775,
   1777,1778,1779,1780,1782,1803,1804,1807,1812,1833,1834,1837,
   1842,1972,1974,1976,1977,2019,2021,2023,2024,2057,2060,2061,
   2063,2064,2065,2066,2068,2081,2082,2084,2085,2086,2087,2096,
   2099,2100,2102,2103,2104,2105,2107,2147,2150,2153,2158,2162,
   2165,2168,2173,2213,2214,2216,2220,2225,2227,2232,2234,2236,
   2241,2243,2247,2259,2261,2264,2266,2271,2272,2276,2277,2333,
   2342,2398,2407,2435,2443,2498,2506,2537,2560,2568,2589,2596,
   2599,2605,2606,2608,2611,2612,2615,2616,2617,2618,2621,2623,
   2624,2629,2633,2634,2635,2637,2639,2641,2642,2648,2653,2655,
   2657,2658,2695,2697,2699,2701,2702,2713,2717,2760,2761,2767,
   2768,2771,2774,2776,2782,2786,2787,2788,2789,2814,2826,2830,
   2883,2886,2888,2891,2896,2897,2899,2901,2923,2924,2936,2941,
   2949,3040,3041,3042,3043,3073,3081,3095,3096,3098,3125,3133,
   3147,3148,3155,3158,3196,3197,3226,3234,3254,3257,3264,3337,
   3339,3341,3343,3344,3384,3386,3388,3390,3391,3402,3406,3441,
   3461,3469,3483,3484,3489,3492,3499,3575,3617,3663,3698,3699,
   3701,3702,3703,3704,3737,3738,3740,3741,3742,3743,3888,3917,
   3918,3920,3921,3922,3923,3982,3983,3985,3986,3987,3988,4146,
   4147,4162,4171,4172,4187,4191,4211,4238,4250,4256,4258,4271,
   4279,4297,4310,4318,4332,4349,4405,4424,4427,4428,4432,4442,
   4454,4466,4469,4472,4543,4552,4580,4581,4607,4609,4650,4664,
   4705,4706,4732,4738,4741,4742,4750,4753,4754,4757,4760,4762,
   4776,4800,4801,4833,4847,4867,4892,4906,4912,4917,5027,5031,
   5033,5037,5040,5043,5051,5058,5063,5065,5068,5069,5077,5079,
   5082,5083,5086,5092,5095,5097,5099,5137,5140,5165,5166,5174,
   5188,5191,5218,5219,5270,5271,5279,5293,5297,5299,5326,5328,
   5331,5339,5342,5378,5392,5404,5406,5408,5430,5468,5469,5473,
   5486,5520,5522,5533,5536,5546,5549,5611,5613,5624,5627,5639,
   5641,5643,5677,5762,5805,5845,6002,6030,6032,6034,6035,6037,
   6038,6064,6066,6068,6069,6071,6072,6134,6135,6217,6247,6332,
   6372,6374,6376,6377,6379,6380,6415,6417,6419,6420,6422,6423,
   6459,6460,6518,6564,6565,6570,6574,6578,6591,6620,6627,6632,
   6642,6668,6669,6689,6690,6724,6728,6730,6731,6732,6734,6737,
   6743,6745,6747,6824,6831,6833,6835,6840,6841,6853,6857,6860,
   6878,6880,6913,6920,6938,6940,7055,7057,7108,7115,7117,7118,
   7121,7123,7128,7138,7144,7145,7148,7160,7165,7166,7220,7221,
   7246,7253,7254,7256,7267,7269,7299,7306,7307,7309,7320,7322,
   7323,7324,7351,7372,7406,7408,7411,7412,7415,7417,7421,7425,
   7458,7459,7460,7465,7529,7530,7553,7555,7559,7562,7568,7572,
   7600,7615,7673,7675,7687,7691,7706,7708,7757,7800,7884,7891,
   7893,7894,7963,7970,7972,7973,8021,8082,8172,8347,8387,8451,
   8458,8460,8461,8533,8540,8542,8543,8547,8668,8669,8710,8711,
   8739,8740,8746,8747,8768,8801,8802,8808,8809,8830,8982,8988,
   8990,9002,9009,9023,9025,9027,9028,9029,9037,9040,9051,9097,
   9103,9105,9117,9124,9137,9138,9142,9148,9152,9161,9164,9261,
   9262,9275,9284,9314,9315,9322,9323,9334,9336,9337,9339,9366,
   9367,9374,9376,9384,9388,9389,9393,9395,9418,9422,9424,9425,
   9426,9431,9438,9468,9472,9474,9475,9476,9477,9495,9498,9517,
   9523,9524,9526,9537,9544,9545,9564,9565,9569,9573,9578,9582,
   9584,9586,9611,9612,9616,9620,9621,9629,9631,9632,9636,9646,
   9657,9658,9662,9666,9671,9675,9678,9682,9688,9692,9703,9707,
   9709,9710,9716,9720,9723,9730,9731,9732,9746,9789,9790,9816,
   9818,9839,9840,9860,9861,9873,9881,9939,9940,9958,9960,9979,
   9981,9990,9991,9992,9993,9994,9995,9997,9998,10001,10002,
   10003,10004,10006,10007,10008,10009,10014,10016,10018,10019,
   10020,10022,10023,10024,10025,10028,10029,10030,10031,10034,
   10036,10038,10039,10040,10041,10043,10044,10046,10047,10053,
   10054,10055,10057,10058,10059,10060,10061,10062,10063,10070,
   10071,10102,10104,10106,10107,10136,10149,10158,10161,10162,
   10166,10181,10195,10196,10210,10223,10226,10227,10231,10236,
   10255,10265,10266,10286,10296,10298,10299,10300,10301,10305,
   10306,10307,10311,10314,10315,10316,10317,10318,10320,10321,
   10322,10323,10324,10417,10435,10457,10460,10500,10509,10512,
   10513,10517,10527,10537,10539,10548,10551,10552,10556,10570,
   10584,10599,10617,10665,10666,10668,10672,10677,10686,10695,
   10699,10754,10755,10761,10762,10783,10882,10883,10895,10896,
   10907,10941,10942,10954,10955,10966,10976,10980,10981,10982,
   10983,10999,11004,11013,11056,11057,11144,11146,11148,11150,
   11152,11154,11160,11168,11214,11219,11221,11223,11234,11238,
   11267,11272,11274,11275,11319,11320,11324,11326,11328,11330,
   11339,11341,11349,11352,11377,11378,11391,11392,11420,11427,
   11428,11431,11444,11449,11452,11469,11470,11476,11480,11491,
   11498,11502,11518,11525,11528,11531,11537,11538,11539,11565,
   11569,11572,11578,11584,11585,11586,11588,11595,11598,11615,
   11618,11630,11631,11634,11641,11642,11655,11656,11660,11675,
   11676,11677,11684,11686,11687,11688,11699,11704,11706,11707,
   11747,11749,11785,11789,11791,11792,11793,11795,11806,11832,
   11833,11854,11857,11886,11887,11897,11898,11911,11912,11913,
   11926,11934,11935,11936,11945,11947,11949,11950,11971,11983,
   11984,12001,12012,12023,12037,12055,12079,12081,12089,12104,
   12106,12115,12117,12125,12128,12130,12131,12132,12134,12136,
   12137,12139,12141,12143,12144,12146,12147,12148,12150,12151,
   12157,12171,12179,12180,12181,12188,12189,12191,12192,12193,
   12194,12195,12196,12197,12199,12201,12202,12206,12207,12208,
   12209,12210,12212,12213,12214,12215,12217,12218,12219,12222,
   12223,12224,12225,12226,12229,12231,12234,12236,12238,12239,
   12240,12241,12242,12244,12245,12246,12247,12248,12261,12266,
   12269,12316,12341,12342,12359,12365,12367,12369,12384,12403,
   12405,12421,12425,12426,12436,12464,12468,12469,12496,12504,
   12508,12514,12523,12531,12541,12549,12555,12556,12557,12558,
   12559,12561,12640,12641,12643,12648,12649,12651,12657,12663,
   12669,12690,12691,12693,12698,12700,12701,12703,12706,12708,
   12714,12720,12722,12766,12774,12780,12786,12803,12825,12832,
   12833,12846,12867,12872,12873,12880,12883,12884,12894,12895,
   12898,12905,12940,12948,12954,12960,12977,13105,13106,13113,
   13116,13127,13130,13158,13159,13165,13166,13168,13169,13178,
   13180,13183,13184,13210,13211,13232,13261,13268,13269,13271,
   13279,13282,13318,13319,13360,13368,13370,13371,13380,13381,
   13382,13389,13408,13416,13419,13422,13424,13426,13473,13475,
   13476,13508,13515,13517,13521,13532,13567,13568,13590,13598,
   13633,13634,13660,13666,13723,13724,13744,13748,13756,13764,
   13834,13835,13841,13844,13845,13846,13847,13848,13849,13850,
   13851,13855,13860,13862,13866,13867,13868,13869,13870,13899,
   13914,14079,14100,14111,14113,14114,14115,14116,14117,14118,
   14119,14122,14129,14130,14133,14135,14136,14137,14138,14179,
   14207,14236,14275,14285,14296,14297,14301,14307,14317,14318,
   14438,14446,14494,14580,14583,14587,14590,14598,14609,14610,
   14616,14617,14639,14649,14662,14665,14667,14675,14697,14707,
   14720,14723,14725,14733,14754,14757,14761,14764,14777,14920,
   14921,14922,14925,14926,14927,14928,14929,14930,14931,14932,
   14933,14934,14935,14936,14937,14938,14939,14941,14942,14945,
   14946,14947,14948,14949,14952,14953,14955,14956,14958,14962,
   14963,14967,14969,14970,14971,14973,14974,14975,14976,14981,
   14982,14988,14990,14991,14994,14996,15005,15006,15007,15015,
   15020,15035,15040,15041,15042,15048,15051,15054,15056,15058,
   15059,15060,15062,15063,15079,15081,15082,15083,15084,15085,
   15086,15087,15088,15089,15090,15092,15093,15094,15095,15097,
   15098,15099,15101,15102,15103,15104,15105,15107,15108,15109,
   15110,15111,15112,15118,15123,15124,15125,15126,15127,15128,
   15129,15135,15141,15148,15149,15151,15160,15179,15188,15190,
   15191,15196,15197,15198,15200,15201,15224,15229,15232,15234,
   15240,15249,15250,15251,15252,15254,15255,15256,15257,15258,
   15259,15260,15265,15270,15271,15279,15287,15289,15295,15296,
   15297,15303,15305,15306,15307,15321,15324,15329,15337,15345,
   15354,15363,15371,15373,15380,15386,15387,15388,15390,15395,
   15396,15397,15398,15399,15415,15416,15417,15420,15422,15423,
   15427,15428,15430,15432,15433,15434,15436,15438,15440,15441,
   15447,15448,15452,15454,15455,15456,15457,15459,15465,15481,
   15507,15516,15519,15521,15548,15549,15596,15597,15665,15671,
   15679,15702,15739,15744,15747,15748,15749,15750,15752,15753,
   15754,15755,15756,15757,15758,15759,15763,15768,15769,15770,
   15772,15773,15781,15880,15881,15947,15999,16008,16031,16032,
   16033,16037,16038,16054,16061,16086,16087,16102,16108,16124,
   16126,16152,16153,16157,16210,16212,16234,16245,16247,16258,
   16262,16266,16279,16288,16294,16432,16433,16445,16446,16457,
   16540,16548,16554,16560,16577,16639,16641,16642,16643,16645,
   16666,16671,16706,16710,16714,16719,16725,16726,16727,16728,
   16729,16758,16765,16766,16767,16772,16778,16780,16810,16811,
   16820,16824,16830,16831,16832,16833,16848,16862,16866,16868,
   16871,16875,16877,16879,16881,16882,16885,16918,16919,16925,
   16931,16933,16944,16948,16960,16969,16970,16974,16980,16981,
   16982,16983,16993,16998,17017,17022,17024,17026,17028,17029,
   17056,17060,17062,17069,17071,17073,17075,17076,17078,17080,
   17087,17091,17101,17108,17109,17117,17121,17125,17126,17133,
   17138,17146,17151,17153,17154,17155,17166,17168,17169,17178,
   17180,17182,17183,17204,17206,17210,17211,17214,17240,17247,
   17253,17254,17285,17289,17295,17296,17330,17332,17336,17340,
   17370,17376,17377,17378,17409,17415,17416,17418,17447,17453,
   17470,17484,17490,17491,17503,17520,17522,17524,17526,17527,
   17538,17542,17555,17557,17577,17578,17595,17596,17597,17598,
   17608,17609,17611,17613,17621,17624,17629,17640,17644,17645,
   17660,17661,17662,17663,17673,17674,17676,17678,17684,17685,
   17691,17692,17703,17715,17716,17736,17738,17744,17747,17749,
   17750,17751,17772,17779,17781,17831,17832,17850,17856,17857,
   17860,17868,17870,17875,17876,17878,17879,17881,17885,17887,
   17888,17889,17890,17892,17893,17894,17895,17896,17897,17898,
   17903,17907,17917,17920,17923,17926,17932,17937,17941,17942,
   17947,17959,17960,17962,17964,17970,17978,17980,17983,17986,
   17998,17999,18001,18003,18004,18005,18006,18008,18010,18011,
   18012,18013,18014,18015,18016,18017,18019,18020,18021,18022,
   18023,18024,18027,18030,18031,18032,18033,18034,18036,18038,
   18049,18059,18069,18077,18079,18082,18155,18157,18160,18162,
   18167,18168,18172,18173,18178,18188,18201,18204,18206,18214,
   18252,18258,18260,18272,18279,18292,18294,18296,18297,18302,
   18304,18309,18314,18316,18319,18328,18333,18346,18352,18354,
   18356,18359,18361,18367,18377,18382,18383,18386,18423,18425,
   18426,18437,18439,18440,18442,18469,18476,18477,18490,18492,
   18494,18521,18522,18544,18573,18577,18579,18580,18582,18588,
   18593,18596,18597,18629,18630,18672,18679,18680,18682,18697,
   18704,18724,18726,18729,18739,18740,18743,18771,18773,18786,
   18787,18812,18813,18817,18819,18833,18836,18837,18844,18857,
   18862,18908,18911,18922,18951,18965,18993,19007,19034,19035,
   19056,19064,19113,19115,19117,19127,19129,19136,19144,19151,
   19169,19179,19233,19237,19238,19248,19253,19259,19273,19340,
   19343,19353,19358,19372,19390,19391,19392,19394,19397,19402,
   19403,19405,19407,19408,19409,19410,19411,19412,19414,19416,
   19419,19420,19444,19451,19462,19468,19469,19481,19489,19496,
   19503,19542,19543,19715,19726,19728,19734,19735,19737,19738,
   19739,19741,19742,19743,19747,19749,20056,20057,20058,20060,
   20063,20065,20066,20067,20069,20070,20071,20072,20073,20074,
   20076,20079,20080,20081,20084,20089,20090,20097,20098,20099,
   20101,20103,20111,20112,20120,20131,20133,20134,20144,20149,
   20161,20163,20164,20171,20174,20175,20189,20190,20193,20196,
   20203,20214,20221,20227,20231,20232,20237,20238,20243,20244,
   20246,20248,20259,20264,20269,20279,20282,20286,20287,20290,
   20297,20305,20314,20315,20317,20318,20320,20321,20322,20324,
   20325,20326,20327,20328,20330,20331,20333,20334,20335,20336,
   20337,20339,20342,20343,20345,20347,20351,20352,20353,20354,
   20355,20356,20357,20358,20359,20365,20366,20368,20369,20370,
   20373,20374,20375,20376,20377,20378,20381,20382,20386,20388,
   20389,20390,20393,20399,20401,20403,20404,20405,20406,20407,
   20421,20423,20429,20431,20435,20437,20439,20440,20450,20507,
   20510,20511,20512,20514,20515,20521,20525,20528,20532,20566,
   20574,20649,20651,20692,20732,20809,20846,20861,20863,20867,
   20916,20917,20920,20921,21014,21020,21045,21047,21055,21104,
   21106,21114,21121,21134,21135,21138,21142,21143,21161,21165,
   21166,21171,21190,21195,21196,21198,21202,21203,21204,21205,
   21207,21208,21209,21216,21286,21345,21374,21377,21381,21396,
   21413,21427,21541,21542,21546,21564,21568,21666,21672,21674,
   21676,21685,21687,21692,21725,21726,21727,21736,21739,21740,
   21741,21746,21756,21770,21771,21778,21791,21793,21807,21821,
   21826,21828,21829,21835,21844,21856,21858,21872,21876,21878,
   21879,21880,21882,21885,21887,21891,21893,21895,21897,21898,
   21907,21931,21969,21973,21976,21982,21984,21988,21992,22004,
   22015,22022,22031,22033,22035,22036,22043,22106,22107,22111,
   22126,22127,22128,22133,22142,22157,22220,22228,22230,22272,
   22273,22304,22313,22409,22425,22430,22454,22457,22494,22502,
   22504,22515,22517,22562,22571,22604,22628,22636,22638,22659,
   22673,22698,22728,22765,22824,22831,22855,22906,22913,22921,
   22923,22941,22960,22963,22977,22979,22986,22988,22989,23003,
   23029,23076,23077,23078,23086,23087,23088,23131,23133,23134,
   23195,23200,23201,23210,23211,23214,23217,23218,23224,23228,
   23229,23231,23234,23236,23241,23245,23246,23247,23251,23252,
   23254,23255,23256,23258,23259,23260,23261,23262,23264,23265,
   23266,23267,23270,23271,23273,23275,23277,23281,23283,23284,
   23285,23286,23287,23288,23289,23293,23294,23296,23300,23304,
   23310,23311,23314,23315,23333,23334,23335,23337,23349,23351,
   23352,23354,23356,23359,23367,23368,23373,23374,23378,23380,
   23382,23384,23390,23397,23408,23418,23419,23423,23430,23432,
   23436,23446,23450,23453,23463,23469,23477,23478,23489,23499,
   23501,23502,23503,23504,23505,23506,23508,23510,23512,23514,
   23516,23517,23521,23523,23526,23528,23529,23531,23532,23535,
   23537,23543,23544,23545,23546,23550,23556,23557,23560,23562,
   23564,23573,23574,23575,23576,23578,23579,23581,23604,23608,
   23609,23618,23621,23622,23626,23631,23640,23643,23646,23647,
   23648,23650,23651,23655,23664,23665,23670,23671,23702,23735,
   23738,23739,23740,23742,23745,23746,23751,23752,23753,23754,
   23756,23757,23759,23760,23763,23764,23769,23787,23828,23868,
   23881,23945,23960,23962,23970,23982,24018,24019,24029,24132,
   24134,24139,24164,24166,24183,24192,24197,24213,24242,24243,
   24253,24257,24260,24324,24332,24334,24336,24337,24338,24339,
   24340,24341,24347,24348,24349,24360,24362,24450,24451,24470,
   24477,24482,24526,24555,24557,24558,24561,24571,24677,24681,
   24682,24683,24685,24687,24688,24690,24694,24696,24699,24702,
   24703,24704,24705,24707,24710,24712,24713,24716,24719,24720,
   24721,24722,24723,24724,24726,24728,24733,24734,24735,24737,
   24738,24739,24743,24751,24756,24760,24761,24762,24766,24773,
   24785,24787,24790,24795,24799,24818,24820,24828,24838,24840,
   24849,24851,24860,24870,24882,24886,24888,24890,24895,24900,
   24901,24908,24911,24920,24930,24985,24987,24988,24990,24991,
   24993,24996,24997,25006,25008,25013,25014,25015,25017,25018,
   25022,25025,25027,25029,25030,25032,25037,25039,25045,25055,
   25059,25060,25061,25066,25072,25079,25080,25081,25082,25083,
   25084,25085,25086,25089,25094,25098,25099,25100,25101,25103,
   25104,25105,25106,25107,25109,25110,25111,25115,25116,25117,
   25118,25119,25120,25122,25123,25124,25126,25128,25130,25135,
   25136,25146,25151,25152,25153,25154,25155,25172,25175,25178,
   25183,25187,25188,25189,25190,25193,25195,25196,25199,25200,
   25204,25206,25207,25209,25212,25314,25316,25356,25365,25367,
   25395,25443,25447,25575,25608,25617,25624,25640,25649,25651,
   25730,25836,25841,25846,25888,25889,25892,25894,25898,25900,
   25902,25904,25905,25906,25936,25937,25960,26000,26002,26004,
   26009,26054,26056,26174,26175,26182,26183,26185,26196,26197,
   26226,26227,26234,26235,26237,26248,26249,26278,26282,26284,
   26286,26287,26288,26298,26300,26301,26328,26334,26335,26338,
   26350,26353,26377,26383,26384,26387,26399,26402,26425,26433,
   26438,26440,26442,26444,26447,26450,26472,26476,26480,26482,
   26489,26492,26494,26495,26497,26517,26518,26522,26526,26539,
   26542,26562,26563,26567,26571,26584,26587,26628,26629,26630,
   26649,26650,26658,26672,26673,26675,26692,26699,26700,26702,
   26713,26715,26733,26741,26743,26755,26758,26772,26781,26795,
   26798,26812,26818,26820,26822,26832,26834,26835,26850,26858,
   26860,26871,26878,26882,26888,26889,26890,26891,26892,26896,
   26898,26899,26900,26901,26902,26903,26904,26905,26906,26907,
   26908,26909,26911,26913,26914,26915,26917,26918,26919,26920,
   26921,26922,26923,26924,26931,26933,26942,26943,26945,26948,
   26966,26967,26968,26980,26983,26996,26999,27000,27014,27017,
   27035,27047,27048,27055,27056,27067,27076,27079,27080,27082,
   27096,27097,27107,27110,27113,27119,27125,27126,27146,27158,
   27159,27160,27161,27162,27163,27164,27165,27166,27167,27168,
   27169,27171,27172,27173,27175,27176,27177,27179,27180,27181,
   27182,27183,27184,27205,27213,27214,27216,27217,27218,27219,
   27221,27229,27231,27233,27235,27236,27237,27247,27250,27253,
   27273,27275,27276,27278,27295,27299,27302,27310,27312,27321,
   27322,27325,27338,27339,27360,27365,27367,27368,27396,27401,
   27408,27411,27416,27420,27422,27425,27433,27435,27439,27440,
   27442,27448,27455,27458,27465,27467,27470,27471,27474,27475,
   27476,27477,27478,27480,27482,27483,27485,27487,27488,27491,
   27493,27495,27499,27507,27513,27515,27517,27522,27527,27604,
   27605,27612,27613,27615,27626,27627,27655,27660,27662,27663,
   27665,27676,27677,27680,27705,27710,27712,27713,27715,27726,
   27727,27730,27762,27764,27765,27776,27779,27810,27813,27816,
   27820,27822,27824,27826,27827,27849,27854,27857,27867,27869,
   27870,27874,27895,27900,27903,27913,27915,27916,27920,27940,
   27945,27948,27961,27962,27965,27984,27992,28006,28007,28009,
   28027,28028,28070,28077,28078,28080,28091,28094,28095,28117,
   28118,28132,28150,28158,28171,28172,28175,28189,28197,28211,
   28214,28228,28229,28230,28231,28232,28233,28234,28235,28236,
   28238,28239,28240,28241,28242,28244,28245,28246,28247,28249,
   28251,28252,28253,28254,28256,28257,28258,28259,28260,28261,
   28262,28263,28265,28272,28286,28287,28289,28291,28308,28322,
   28325,28340,28342,28345,28357,28377,28389,28391,28394,28410,
   28424,28427,28433,28442,28456,28459,28473,28487,28490,28497,
   28502,28504,28505,28507,28508,28509,28510,28512,28513,28514,
   28518,28519,28522,28523,28524,28525,28526,28527,28529,28530,
   28531,28532,28533,28538,28541,28543,28549,28554,28558,28573,
   28574,28588,28602,28627,28630,28652,28654,28655,28669,28673,
   28679,28688,28690,28695,28698,28699,28700,28745,28765,28774,
   28777,28784,28792,28793,28797,28799,28813,28816,28826,28829,
   28833,28836,28837,28838,28840,28842,28843,28844,28845,28847,
   28848,28851,28852,28855,28878,28879,28880,28882,28883,28885,
   28887,28888,28890,28914,28918,28923,28927,28932,28958,28981,
   28982,28988,28991,29002,29003,29004,29031,29032,29038,29053,
   29054,29080,29081,29087,29090,29101,29102,29103,29128,29129,
   29139,29142,29144,29146,29148,29150,29151,29152,29175,29176,
   29180,29193,29195,29196,29197,29198,29221,29222,29243,29244,
   29245,29246,29266,29267,29271,29284,29286,29287,29288,29289,
   29310,29318,29332,29333,29334,29335,29340,29343,29353,29354,
   29362,29376,29379,29380,29382,29396,29417,29437,29452,29458,
   29459,29464,29476,29497,29498,29499,29515,29516,29536,29537,
   29538,29547,29554,29555,29556,29557,29558,29559,29560,29561,
   29562,29564,29565,29566,29568,29569,29570,29571,29572,29575,
   29577,29579,29580,29582,29583,29584,29585,29587,29588,29589,
   29590,29591,29592,29593,29594,29595,29596,29598,29600,29601,
   29602,29603,29605,29606,29607,29608,29609,29610,29611,29612,
   29613,29614,29615,29617,29618,29619,29621,29622,29623,29624,
   29625,29626,29627,29637,29648,29649,29666,29683,29684,29700,
   29702,29704,29705,29715,29717,29718,29726,29739,29749,29750,
   29751,29754,29761,29780,29782,29783,29813,29814,29844,29846,
   29848,29872,29873,29883,29893,29899,29900,29911,29919,29920,
   29924,29927,29928,29937,29939,29940,29953,29954,29978,29979,
   30021,30025,30026,30038,30047,30064,30067,30069,30088,30107,
   30119,30125,30126,30142,30143,30158,30159,30162,30164,30166,
   30167,30168,30169,30170,30171,30174,30175,30176,30177,30178,
   30180,30181,30182,30183,30184,30187,30188,30189,30202,30208,
   30214,30219,30222,30223,30306,30311,30313,30314,30316,30327,
   30328,30331,30355,30356,30362,30365,30376,30377,30378,30404,
   30408,30410,30414,30417,30419,30421,30423,30424,30427,30451,
   30455,30457,30461,30464,30466,30468,30470,30471,30474,30501,
   30503,30506,30517,30520,30521,30541,30546,30548,30551,30562,
   30563,30590,30592,30595,30606,30633,30635,30638,30649,30675,
   30677,30680,30681,30691,30716,30718,30719,30756,30759,30772,
   30773,30776,30790,30795,30797,30799,30808,30811,30813,30831,
   30833,30853,30857,30866,30869,30870,30876,30886,30892,30921,
   30922,30941,30943,30946,30957,30975,30977,30980,30991,31011,
   31015,31016,31017,31018,31019,31020,31021,31023,31024,31025,
   31028,31031,31032,31033,31034,31035,31037,31038,31039,31040,
   31041,31042,31045,31049,31056,31074,31075,31077,31078,31079,
   31080,31081,31082,31083,31084,31085,31086,31087,31088,31089,
   31091,31093,31094,31095,31096,31098,31099,31100,31101,31102,
   31103,31104,31106,31117,31124,31125,31135,31139,31144,31146,
   31152,31155,31165,31166,31167,31168,31169,31170,31172,31173,
   31174,31175,31176,31180,31184,31186,31187,31188,31189,31190,
   31191,31201,31209,31210,31224,31226,31227,31245,31247,31251,
   31252,31255,31271,31274,31276,31285,31289,31291,31299,31318,
   31321,31336,31342,31361,31365,31375,31377,31381,31390,31391,
   31395,31399,31412,31414,31417,31418,31419,31422,31424,31425,
   31426,31427,31428,31429,31430,31431,31433,31444,31454,31456,
   31474,31480,31542,31545,31547,31551,31553,31565,31581,31587,
   31588,31591,31603,31606,31635,31636,31644,31646,31648,31652,
   31680,31682,31683,31693,31695,31696,31728,31729,31737,31739,
   31741,31745,31771,31773,31774,31787,31788,31817,31818,31826,
   31848,31860,31874,31886,31890,31902,31903,31904,31941,31943,
   31944,31958,31965,31968,31984,32016,32020,32022,32023,32024,
   32026,32035,32045,32055,32060,32061,32078,32085,32098,32105,
   32109,32128,32134,32154,32157,32202,32203,32222,32231,32236,
   32247,32252,32256,32267,32268,32299,32300,32301,32302,32304,
   32305,32306,32307,32308,32309,32310,32311,32312,32313,32316,
   32318,32319,32320,32321,32323,32324,32325,32326,32327,32328,
   32329,32330,32331,32333,32334,32335,32336,32338,32340,32342,
   32344,32345,32346,32347,32348,32349,32350,32351,32352,32353,
   32355,32356,32357,32358,32360,32378,32399,32405,32427,32433,
   32440,32456,32466,32470,32495,32505,32517,32518,32523,32525,
   32527,32537,32561,32605,32607,32637,32638,32649,32673,32702,
   32703,32714,32809,32814,32818,32824,32825,32826,32856,32861,
   32862,32869,32871,32872,32907,32922,32947,32952,32956,32962,
   32963,32964,32993,32996,33039,33081,33082,33092,33123,33135,
   33162,33163,33178,33202,33219,33229,33242,33261,33266,33268,
   33272,33276,33277,33298,33313,33347,33348,33359,33381,33404,
   33415,33443,33446,33447,33477,33478,33494,33503,33509,33513,
   33524,33536,33552,33565,33566,33567,33569,33570,33571,33572,
   33574,33576,33577,33581,33583,33587,33588,33589,33592,33593,
   33596,33601,33602,33604,33609,33610,33613,33615,33627,33629,
   33648,33690,33708,33719,33731,33742,33799,33813,33830,33846,
   33849,33864,33898,33916,33920,33925,33929,33960,33980,33984,
   33986,33990,33993,33995,33997,33999,34000,34003,34032,34033,
   34041,34043,34045,34049,34075,34080,34084,34090,34091,34092,
   34128,34130,34132,34134,34138,34157,34158,34171,34173,34175,
   34177,34181,34210,34213,34215,34217,34219,34223,34251,34254,
   34256,34258,34260,34264,34294,34296,34298,34300,34304,34324,
   34333,34335,34337,34339,34343,34358,34368,34371,34372,34373,
   34375,34377,34386,34402,34405,34408,34410,34411,34412,34413,
   34414,34418,34421,34441,34444,34446,34448,34450,34451,34476,
   34479,34481,34483,34486,34506,34513,34515,34517,34519,34521,
   34544,34545,34546,34548,34550,34552,34553,34563,34567,34570,
   34574,34578,34580,34582,34584,34587,34608,34609,34627,34639,
   34640,34641,34643,34654,34660,34668,34670,34672,34673,34674,
   34681,34684,34695,34696,34698,34700,34702,34713,34721,34722,
   34724,34725,34726,34727,34729,34730,34731,34741,34743,34744,
   34745,34753,34755,34774,34776,34780,34781,34784,34799,34800,
   34802,34803,34805,34807,34810,34811,34812,34814,34815,34816,
   34817,34818,34819,34820,34821,34822,34825,34827,34831,34846,
   34847,34856,34861,34862,34865,34868,34870,34874,34890,34892,
   34897,34901,34902,34903,34904,34905,34906,34907,34908,34909,
   34919,34923,34925,34927,34928,34929,34930,34932,34933,34934,
   34935,34936,34937,34938,34939,34940,34941,34942,34943,34944,
   34945,34948,34955,34956,34964,34973,34979,34985,34998,35003,
   35006,35007,35015,35090,35106,35111,35114,35124,35126,35127,
   35131,35151,35152,35156,35169,35171,35172,35173,35174,35200,
   35213,35215,35216,35243,35256,35258,35259,35262,35285,35298,
   35300,35301,35326,35339,35341,35347,35358,35366,35379,35381,
   35382,35383,35405,35418,35420,35421,35423,35424,35425,35438,
   35441,35443,35444,35453,35456,35458,35460,35463,35473,35479,
   35480,35492,35493,35495,35496,35525,35527,35529,35531,35532,
   35543,35547,35551,35564,35567,35585,35588,35594,35598,35600,
   35601,35602,35605,35613,35621,35625,35626,35627,35628,35629,
   35630,35631,35632,35633,35634,35635,35636,35637,35638,35639,
   35642,35643,35644,35646,35647,35648,35650,35651,35663,35665,
   35666,35668,35686,35688,35689,35690,35694,35696,35697,35712,
   35724,35727,35759,35775,35781,35783,35790,35797,35802,35808,
   35810,35811,35818,35834,35836,35837,35847,35850,35855,35861,
   35862,35881,35883,35886,35896,35901,35906,35908,35909,35917,
   35928,35931,35932,35937,35939,35942,35947,35948,35949,35951,
   35952,35971,35973,35975,35978,35979,35980,35982,35983,35984,
   35985,35986,35987,35988,35990,35991,35994,36000,36009,36010,
   36011,36012,36013,36014,36015,36016,36017,36018,36019,36020,
   36021,36022,36023,36024,36025,36026,36027,36028,36029,36031,
   36032,36033,36034,36035,36036,36037,36038,36039,36040,36041,
   36043,36045,36052,36079,36080,36088,36094,36186,36187,36191,
   36195,36208,36211,36235,36237,36254,36255,36293,36297,36336,
   36340,36341,36374,36380,36401,36421,36460,36467,36486,36497,
   36503,36516,36535,36571,36597,36605,36606,36640,36646,36673,
   36676,36678,36680,36705,36737,36747,36753,36758,36768,36777,
   36800,36817,36829,36876,36900,36901,36925,36947,36958,36960,
   36963,36974,36982,36986,36990,36991,37010,37011,37014,37042,
   37047,37048,37052,37068,37069,37080,37097,37110,37114,37117,
   37119,37122,37124,37128,37129,37130,37133,37134,37136,37144,
   37187,37190,37192,37198,37210,37220,37225,37228,37242,37243,
   37244,37258,37263,37264,37268,37284,37287,37296,37300,37310,
   37325,37326,37327,37351,37375,37378,37386,37391,37404,37407,
   37408,37425,37430,37447,37450,37455,37464,37465,37466,37467,
   37468,37469,37471,37472,37474,37476,37483,37485,37487,37488,
   37489,37490,37492,37493,37494,37495,37499,37500,37501,37504,
   37505,37511,37513,37521,37522,37524,37527,37531,37547,37556,
   37557,37558,37564,37567,37576,37592,37593,37594,37610,37612,
   37613,37614,37619,37621,37625,37626,37627,37631,37632,37641,
   37649,37650,37652,37653,37654,37655,37656,37657,37658,37659,
   37660,37661,37663,37664,37665,37666,37667,37668,37669,37670,
   37671,37672,37673,37674,37675,37676,37692,37713,37720,37722,
   37750,37782,37803,37809,37810,37819,37822,37826,37827,37835,
   37836,37849,37859,37862,37863,37876,37887,37888,37911,37934,
   37935,37947,37953,37956,37957,37963,37968,37977,37998,38005,
   38010,38017,38034,38035,38037,38049,38052,38054,38057,38058,
   38059,38061,38062,38063,38064,38065,38066,38069,38070,38072,
   38073,38074,38077,38078,38079,38080,38081,38082,38083,38084,
   38087,38091,38093,38105,38115,38118,38123,38131,38137,38236,
   38278,38362,38401,38578,38584,38616,38643,38649,38657,38807,
   38833,38852,38872,38911,38919,38932,38940,38971,38979,38993,
   39054,39181,39224,39264,39453,39487,39636,39666,39775,39791,
   39799,39834,39842,39937,39989,39993,39997,40084,40163,40221,
   40519,40547,40636,40658,40663,40740,40945,40983,41098,41133,
   41200,41374,41433,41456,41480,41502,41543,41577,41637,41658,
   41683,41688,41692,41697,41765,41877,41946,42066,42096,42171,
   42357,42539,42615,42619,42713,42749,42753,42779,42838,42896,
   42912,42955,43084,43167,43202,43221,43227,43645,43680,43877,
   43880,43898,43949,43967,44057,44090,44101,44257,44281,44307,
   44467,44653,44686,44748,44752,44837,44911,44912,44927,44936,
   44937,44952,44976,45003,45021,45062,45097,45114,45170,45207,
   45231,45237,45283,45356,45520,45551,45571,45572,45592,45616,
   45617,45876,45903,45909,46025,46078,46083,46093,46172,46177,
   46193,46198,46333,46339,46348,46353,46384,46398,46581,46607,
   46621,46624,46632,46634,46656,46679,46701,46722,46742,46771,
   46796,46798,46843,46847,46877,46911,46919,46920,46922,46941,
   47048,47049,47054,47056,47075,47076,47105,47106,47117,47136,
   47183,47201,47203,47259,47260,47339,47364,47482,47556,47742,
   47862,47871,47955,48056,48079,48111,48283,48325,48351,48362,
   48397,48404,48423,48429,48453,48462,48498,48501,48518,48539,
   48558,48567,48576,48593,48624,48677,48679,48681,48683,48685,
   48775,48848,48864,48947,48958,48961,48979,48982,49083,49117,
   49126,49137,49142,49152,49200,49230,49236,49251,49257,49290,
   49298,49312,49314,49346,49434,49476,49477,49492,49537,49577,
   49582,49598,49619,49620,49624,49629,49630,49633,49635,49637,
   49639,49641,49724,49725,49840,49923,49924,49927,49935,49937,
   49944,49946,49947,49950,49951,49952,49954,49956,49977,49997,
   49999,50115,50119,50137,50139,50178,50188,50197,50232,50263,
   50289,50290,50302,50313,50332,50340,50353,50362,50365,50368,
   50404,50412,50449,50466,50528,50583,50614,50616,50636,50642,
   50662,50852,50853,50885,50893,50897,50947,50968,50969,50975,
   50981,50982,50983,50987,50995,51157,51173,51251,51330,51331,
   51344,51393,51394,51419,51422,51438,51519,51529,51559,51570,
   51571,51686,51691,51695,51738,51757,51763,51936,51960,52011,
   52016,52050,52094,52116 ],
 [ 122,123,124,125,831,832,836,839,869,870,884,885,890,891,
   895,900,936,937,941,942,943,944,947,952,970,972,973,983,
   996,997,1000,1002,1022,1023,1043,1044,1046,1047,1048,1050,
   1052,1053,1092,1093,1097,1102,1117,1130,1146,1148,1164,1177,
   1190,1191,1193,1194,1195,1196,1236,1237,1240,1242,1257,1258,
   1278,1279,1282,1287,1364,1365,1366,1367,1406,1407,1408,1409,
   1487,1488,1489,1490,1526,1527,1528,1529,1706,1709,1710,1712,
   1713,1714,1715,1717,1743,1746,1747,1748,1771,1774,1775,1777,
   1778,1779,1780,1782,1803,1804,1807,1812,1833,1834,1837,1842,
   2057,2060,2061,2063,2064,2065,2066,2068,2081,2084,2085,2086,
   2096,2099,2100,2102,2103,2104,2105,2107,2147,2150,2153,2158,
   2162,2165,2168,2173,2213,2214,2216,2220,2225,2234,2243,2247,
   2264,2266,2272,2277,2589,2596,2767,2768,2786,2788,2789,2814,
   2830,2883,2888,2891,2896,2897,2899,2901,2936,2941,2949,3042,
   3043,3073,3081,3095,3096,3098,3125,3133,3147,3148,3155,3158,
   3196,3197,3226,3234,3254,3257,3264,3337,3339,3341,3343,3344,
   3384,3388,3390,3391,3402,3406,3441,3461,3469,3483,3484,3489,
   3492,3499,3698,3699,3701,3702,3703,3704,3737,3738,3740,3741,
   3742,3743,3917,3918,3920,3921,3922,3923,3982,3983,3985,3986,
   3987,3988,4258,4271,4279,4310,4318,4405,4424,4427,4432,4442,
   4454,4469,4607,4609,4650,4664,4705,4706,4732,4738,4741,4742,
   4750,4753,4754,4757,4776,4800,4801,4912,4917,5027,5031,5033,
   5037,5095,5097,5099,5137,5140,5165,5166,5174,5188,5191,5218,
   5219,5270,5271,5279,5293,5297,5299,5326,5328,5331,5339,5342,
   5378,5392,5404,5406,5408,5430,5473,5486,5520,5522,5533,5536,
   5546,5549,5611,5613,5624,5627,5639,5641,5643,5677,5762,5805,
   5845,6030,6032,6034,6035,6037,6038,6064,6066,6068,6069,6071,
   6072,6134,6135,6247,6372,6374,6376,6377,6379,6380,6415,6417,
   6419,6420,6422,6423,6459,6460,6565,6570,6574,6578,6591,6620,
   6627,6632,6730,6737,6831,6835,6857,6878,6880,6913,6920,7055,
   7057,7123,7128,7246,7253,7254,7256,7267,7299,7306,7307,7309,
   7320,7351,7372,7406,7408,7415,7421,7425,7458,7459,7460,7465,
   7529,7530,7553,7555,7562,7568,7572,7600,7615,7673,7675,7687,
   7691,7706,7708,7757,7800,7884,7891,7963,7970,8021,8347,8451,
   8458,8533,8540,8740,8746,8768,8802,8808,8830,8982,9023,9025,
   9027,9028,9029,9040,9051,9097,9137,9138,9142,9164,9262,9275,
   9284,9322,9334,9336,9337,9367,9374,9376,9384,9388,9389,9393,
   9395,9418,9422,9424,9425,9438,9468,9472,9474,9475,9495,9498,
   9517,9523,9524,9526,9537,9544,9545,9565,9569,9578,9582,9584,
   9586,9612,9616,9629,9631,9632,9636,9646,9658,9662,9671,9675,
   9678,9688,9692,9703,9707,9709,9710,9716,9720,9723,9730,9731,
   9732,9816,9818,9860,9861,9873,9939,9940,9979,9981,10028,
   10029,10030,10031,10034,10036,10038,10039,10040,10041,10043,
   10044,10046,10047,10053,10054,10055,10057,10058,10060,10061,
   10062,10063,10136,10149,10158,10161,10162,10166,10181,10195,
   10223,10226,10227,10231,10255,10286,10500,10509,10512,10513,
   10517,10537,10539,10548,10551,10552,10556,10570,10584,10599,
   10617,10665,10666,10668,10672,10677,10686,10695,10699,10755,
   10761,10783,10976,10980,10981,10982,10983,10999,11004,11144,
   11146,11150,11152,11214,11221,11223,11234,11267,11319,11320,
   11326,11328,11349,11352,11377,11391,11420,11427,11431,11444,
   11449,11452,11469,11470,11476,11480,11498,11502,11518,11531,
   11537,11538,11578,11584,11585,11595,11598,11630,11631,11634,
   11641,11642,11655,11656,11675,11676,11684,11686,11687,11688,
   11706,11749,11791,11854,11857,11897,11898,11911,11913,11934,
   11935,11936,11949,11971,12012,12079,12081,12115,12117,12179,
   12180,12181,12189,12191,12192,12193,12194,12195,12196,12197,
   12199,12201,12206,12207,12209,12210,12212,12213,12214,12215,
   12218,12269,12341,12359,12403,12421,12425,12426,12464,12468,
   12469,12504,12508,12523,12541,12640,12641,12643,12648,12649,
   12651,12657,12663,12669,12690,12691,12693,12698,12701,12703,
   12720,12722,12786,12825,12833,12867,12872,12873,12880,12883,
   12884,12894,12895,12898,12905,12960,13105,13106,13113,13116,
   13127,13130,13158,13159,13165,13166,13168,13169,13178,13180,
   13211,13232,13261,13268,13269,13271,13279,13282,13318,13360,
   13368,13370,13371,13380,13381,13382,13389,13422,13426,13473,
   13475,13476,13508,13515,13517,13521,13532,13567,13568,13633,
   13634,13660,13666,13723,13724,13744,13748,13756,13764,13834,
   13844,13845,13846,13847,13848,13849,13850,13851,13855,13860,
   13862,13866,13867,13868,13899,14079,14100,14111,14113,14114,
   14115,14116,14117,14118,14119,14122,14129,14130,14133,14135,
   14136,14138,14179,14207,14275,14297,14301,14317,14318,14446,
   14580,14583,14587,14610,14754,14757,14920,14921,14925,14926,
   14927,14928,14930,14931,14932,14934,14935,14936,14938,14939,
   14946,14947,14949,14952,14962,14963,14967,14970,14973,14974,
   14975,14976,14981,14991,14994,15005,15006,15007,15015,15020,
   15035,15041,15048,15051,15054,15056,15058,15062,15063,15079,
   15083,15084,15086,15087,15088,15090,15094,15095,15098,15099,
   15101,15103,15107,15108,15109,15111,15112,15118,15123,15124,
   15125,15126,15127,15128,15141,15148,15151,15160,15179,15188,
   15190,15191,15196,15197,15198,15224,15234,15251,15252,15255,
   15257,15270,15289,15295,15297,15303,15306,15307,15321,15324,
   15329,15337,15345,15354,15363,15371,15373,15380,15386,15388,
   15390,15395,15398,15399,15516,15521,15781,15880,15881,16031,
   16032,16033,16037,16038,16152,16153,16157,16258,16279,16560,
   16639,16642,16643,16671,16706,16710,16714,16719,16725,16727,
   16728,16758,16765,16766,16767,16772,16778,16780,16810,16811,
   16820,16824,16830,16832,16833,16848,16862,16866,16868,16879,
   16918,16919,16925,16931,16933,16944,16948,16960,16969,16974,
   16980,16982,16983,16993,16998,17017,17026,17060,17062,17073,
   17075,17078,17080,17087,17091,17101,17108,17109,17121,17126,
   17133,17138,17146,17153,17154,17155,17166,17168,17169,17178,
   17180,17182,17183,17204,17210,17247,17253,17289,17295,17330,
   17336,17370,17376,17409,17415,17447,17453,17470,17484,17490,
   17503,17595,17597,17598,17608,17609,17611,17613,17644,17660,
   17662,17663,17673,17674,17676,17678,17684,17685,17691,17703,
   17715,17716,17736,17738,17744,17747,17749,17750,17772,17850,
   17875,17879,17885,17887,17888,17889,17890,17892,17893,17894,
   17897,17898,17959,17960,17962,17964,17980,17998,17999,18001,
   18003,18005,18006,18008,18010,18011,18012,18013,18015,18016,
   18019,18020,18021,18049,18059,18069,18160,18162,18168,18173,
   18252,18292,18294,18296,18297,18346,18425,18439,18469,18477,
   18492,18494,18521,18522,18544,18573,18577,18580,18588,18596,
   18597,18630,18672,18679,18680,18697,18704,18724,18729,18739,
   18743,18771,18786,18812,18813,18817,18837,18844,18857,18862,
   19179,19353,19444,19469,19726,20056,20057,20058,20060,20065,
   20066,20067,20069,20070,20071,20072,20073,20074,20080,20081,
   20090,20097,20098,20099,20101,20111,20112,20120,20131,20133,
   20134,20144,20149,20161,20163,20164,20171,20174,20175,20189,
   20190,20193,20196,20203,20214,20221,20227,20231,20232,20237,
   20238,20243,20244,20246,20259,20264,20269,20279,20286,20287,
   20290,20297,20305,20314,20315,20317,20318,20320,20321,20322,
   20324,20325,20326,20327,20330,20331,20333,20334,20335,20336,
   20337,20339,20342,20343,20345,20347,20351,20352,20353,20354,
   20355,20356,20357,20358,20359,20365,20366,20368,20369,20373,
   20374,20375,20376,20377,20378,20386,20388,20389,20390,20393,
   20399,20401,20403,20404,20405,20406,20407,20421,20423,20437,
   20440,20450,20507,20510,20511,20512,20514,20515,20521,20525,
   20528,20532,20566,20649,20651,20692,20732,20809,20846,20861,
   20863,20867,20916,20921,21014,21020,21047,21106,21134,21143,
   21161,21165,21166,21171,21196,21198,21203,21204,21205,21207,
   21208,21286,21345,21396,21413,21542,21546,21666,21672,21674,
   21676,21685,21687,21692,21725,21727,21736,21739,21740,21741,
   21746,21756,21770,21771,21778,21791,21793,21807,21821,21826,
   21828,21829,21835,21844,21856,21858,21872,21876,21879,21880,
   21882,21885,21887,21891,21893,21895,21897,21898,21907,21969,
   21973,21976,21988,21992,22004,22015,22022,22033,22035,22036,
   22043,22106,22107,22111,22126,22127,22128,22133,22142,22220,
   22228,22230,22409,22425,22430,22454,22457,22494,22502,22504,
   22562,22571,22604,22628,22636,22638,22659,22698,22728,22765,
   22855,22913,22921,22923,22941,22979,22986,22988,22989,23003,
   23029,23076,23077,23078,23087,23133,23195,23201,23211,23214,
   23218,23224,23234,23245,23246,23247,23251,23252,23256,23258,
   23259,23260,23262,23264,23266,23270,23271,23273,23281,23283,
   23285,23286,23287,23288,23289,23293,23296,23300,23304,23310,
   23314,23315,23333,23335,23337,23349,23351,23352,23354,23359,
   23367,23373,23374,23378,23380,23384,23390,23397,23408,23419,
   23423,23430,23432,23436,23446,23450,23453,23463,23469,23477,
   23478,23489,23499,23501,23502,23505,23506,23510,23512,23514,
   23521,23523,23528,23532,23537,23543,23544,23545,23557,23560,
   23562,23564,23573,23575,23578,23579,23604,23608,23609,23618,
   23621,23622,23631,23640,23643,23648,23650,23651,23655,23664,
   23665,23671,23702,23787,23828,23868,23881,23945,23970,23982,
   24139,24183,24197,24213,24332,24336,24337,24338,24339,24348,
   24349,24450,24451,24470,24677,24681,24682,24683,24685,24687,
   24688,24690,24694,24696,24699,24702,24703,24707,24710,24712,
   24713,24716,24719,24720,24721,24722,24723,24726,24728,24733,
   24734,24735,24738,24739,24743,24751,24756,24760,24762,24766,
   24773,24785,24787,24790,24795,24799,24818,24828,24838,24851,
   24860,24870,24882,24895,24900,24901,24908,24920,24930,24988,
   24990,24991,24996,24997,25006,25013,25014,25015,25025,25027,
   25029,25030,25032,25037,25039,25045,25059,25060,25061,25066,
   25072,25079,25081,25082,25083,25084,25085,25086,25089,25094,
   25098,25099,25103,25104,25106,25107,25109,25111,25115,25116,
   25117,25118,25119,25120,25122,25123,25124,25126,25128,25130,
   25135,25136,25151,25152,25153,25154,25155,25365,25367,25649,
   25651,25936,25937,26000,26004,26009,26054,26056,26174,26175,
   26182,26183,26185,26196,26197,26226,26227,26234,26235,26237,
   26248,26249,26278,26282,26284,26286,26287,26288,26298,26300,
   26328,26334,26335,26338,26350,26353,26377,26383,26384,26387,
   26399,26402,26425,26433,26438,26440,26442,26444,26447,26450,
   26472,26476,26480,26482,26489,26492,26494,26497,26517,26518,
   26522,26526,26539,26542,26562,26563,26567,26571,26584,26587,
   26628,26629,26649,26650,26658,26672,26675,26692,26699,26700,
   26702,26713,26733,26741,26743,26755,26758,26772,26781,26795,
   26798,26812,26818,26820,26822,26850,26858,26860,26871,26878,
   26882,26888,26889,26890,26891,26892,26896,26898,26899,26900,
   26901,26902,26903,26904,26905,26906,26907,26908,26909,26911,
   26913,26914,26915,26917,26918,26919,26920,26921,26923,26924,
   26931,26933,26945,26948,26966,26968,26980,26983,26996,26999,
   27000,27014,27017,27055,27067,27076,27079,27096,27119,27125,
   27126,27146,27158,27159,27160,27161,27162,27163,27165,27166,
   27167,27168,27169,27171,27175,27176,27177,27179,27180,27181,
   27182,27183,27184,27213,27214,27216,27221,27229,27231,27233,
   27236,27250,27253,27275,27278,27295,27299,27302,27310,27321,
   27322,27325,27360,27365,27367,27368,27396,27401,27408,27411,
   27416,27422,27435,27448,27455,27458,27465,27467,27470,27474,
   27475,27476,27477,27478,27480,27482,27483,27485,27507,27513,
   27515,27522,27527,27604,27605,27612,27613,27615,27626,27627,
   27655,27660,27662,27663,27665,27676,27677,27680,27705,27710,
   27712,27713,27715,27726,27727,27730,27762,27764,27765,27776,
   27779,27810,27816,27820,27822,27824,27826,27827,27849,27854,
   27857,27869,27870,27895,27900,27903,27915,27916,27940,27945,
   27948,27961,27962,27965,27984,27992,28006,28007,28009,28027,
   28028,28070,28077,28078,28080,28091,28117,28118,28132,28150,
   28158,28171,28172,28175,28189,28197,28211,28214,28228,28229,
   28230,28231,28232,28233,28234,28235,28236,28238,28239,28240,
   28241,28244,28246,28247,28249,28251,28254,28256,28257,28258,
   28259,28260,28261,28262,28263,28265,28272,28286,28287,28289,
   28291,28308,28322,28325,28340,28342,28345,28357,28377,28389,
   28391,28394,28410,28424,28427,28433,28442,28456,28459,28473,
   28487,28497,28502,28504,28505,28507,28508,28509,28510,28512,
   28513,28514,28518,28522,28523,28524,28525,28526,28527,28530,
   28532,28533,28538,28541,28543,28549,28554,28558,28573,28574,
   28588,28602,28627,28630,28652,28655,28669,28673,28679,28688,
   28698,28699,28700,28745,28774,28777,28784,28792,28793,28797,
   28799,28813,28816,28826,28829,28833,28836,28837,28838,28840,
   28842,28843,28844,28845,28847,28848,28852,28855,28879,28880,
   28882,28883,28885,28890,28914,28918,28923,28927,28932,28958,
   28981,28982,28988,28991,29002,29003,29031,29032,29038,29053,
   29054,29080,29081,29087,29090,29101,29102,29128,29129,29142,
   29144,29146,29148,29150,29151,29152,29175,29176,29180,29193,
   29195,29196,29197,29198,29221,29222,29243,29244,29245,29246,
   29266,29267,29271,29284,29286,29287,29288,29289,29310,29318,
   29332,29333,29335,29340,29343,29353,29354,29362,29376,29379,
   29380,29382,29396,29417,29437,29452,29458,29459,29464,29476,
   29497,29498,29499,29515,29516,29536,29537,29538,29547,29554,
   29555,29556,29557,29558,29559,29560,29561,29562,29564,29565,
   29566,29568,29569,29570,29571,29572,29575,29577,29579,29580,
   29582,29583,29584,29585,29587,29589,29590,29591,29592,29593,
   29596,29598,29600,29601,29602,29603,29605,29606,29607,29608,
   29609,29611,29612,29613,29615,29617,29618,29619,29622,29624,
   29625,29627,29637,29648,29649,29666,29683,29684,29702,29704,
   29705,29718,29726,29749,29750,29751,29761,29780,29782,29783,
   29813,29814,29844,29846,29848,29872,29873,29883,29893,29899,
   29900,29911,29919,29920,29924,29927,29928,29937,29939,29940,
   29953,29954,29978,29979,30021,30025,30026,30038,30047,30064,
   30067,30069,30088,30107,30119,30126,30142,30143,30158,30159,
   30162,30164,30166,30167,30168,30169,30170,30171,30174,30175,
   30176,30178,30180,30181,30182,30183,30184,30187,30188,30189,
   30202,30208,30214,30219,30222,30223,30306,30311,30313,30314,
   30316,30327,30328,30331,30355,30356,30362,30365,30376,30377,
   30408,30410,30417,30421,30423,30424,30427,30455,30457,30464,
   30468,30470,30471,30474,30501,30503,30506,30517,30520,30521,
   30541,30546,30548,30551,30562,30563,30590,30592,30595,30606,
   30633,30635,30638,30649,30675,30677,30680,30691,30716,30718,
   30719,30756,30759,30772,30773,30776,30790,30795,30797,30799,
   30808,30831,30833,30853,30857,30866,30869,30870,30886,30892,
   30921,30922,30941,30943,30946,30957,30975,30977,30980,30991,
   31011,31015,31016,31018,31019,31020,31021,31023,31024,31025,
   31028,31031,31032,31033,31034,31037,31038,31039,31040,31041,
   31042,31045,31049,31056,31074,31075,31077,31078,31079,31080,
   31081,31082,31083,31084,31085,31086,31087,31088,31089,31091,
   31093,31094,31095,31096,31098,31099,31100,31101,31102,31103,
   31106,31117,31124,31125,31139,31144,31155,31165,31166,31168,
   31169,31170,31172,31173,31174,31175,31180,31184,31186,31187,
   31188,31190,31201,31209,31224,31227,31245,31247,31251,31255,
   31274,31285,31289,31299,31321,31342,31361,31365,31375,31377,
   31381,31390,31391,31395,31399,31414,31417,31419,31422,31424,
   31425,31426,31427,31428,31429,31430,31431,31444,31454,31456,
   31480,31542,31545,31547,31551,31553,31565,31581,31587,31588,
   31591,31603,31606,31635,31636,31644,31646,31648,31680,31682,
   31683,31693,31695,31696,31728,31729,31737,31739,31741,31771,
   31773,31774,31787,31788,31817,31818,31848,31860,31874,31886,
   31890,31902,31903,31904,31941,31943,31944,31958,31965,31968,
   31984,32016,32020,32023,32026,32035,32045,32055,32060,32061,
   32078,32085,32098,32105,32109,32128,32134,32154,32157,32202,
   32203,32222,32231,32236,32247,32256,32267,32268,32299,32301,
   32302,32304,32305,32306,32307,32308,32309,32312,32313,32316,
   32318,32320,32323,32324,32325,32326,32328,32330,32331,32333,
   32334,32335,32336,32338,32340,32342,32344,32345,32346,32347,
   32348,32349,32350,32351,32352,32353,32355,32356,32357,32358,
   32378,32399,32405,32427,32433,32440,32456,32466,32470,32495,
   32505,32517,32523,32525,32527,32537,32605,32607,32638,32649,
   32673,32702,32703,32714,32809,32814,32818,32824,32825,32826,
   32856,32861,32862,32869,32871,32872,32907,32922,32947,32952,
   32956,32962,32963,32964,32993,32996,33039,33082,33092,33123,
   33135,33162,33163,33178,33202,33219,33229,33242,33261,33266,
   33268,33272,33298,33313,33347,33359,33381,33404,33415,33443,
   33446,33447,33494,33503,33509,33513,33524,33536,33552,33565,
   33566,33569,33571,33574,33576,33577,33581,33583,33587,33588,
   33589,33592,33593,33602,33609,33610,33613,33629,33690,33708,
   33731,33742,33799,33830,33846,33849,33864,33898,33916,33920,
   33925,33929,33960,33984,33986,33993,33997,33999,34000,34003,
   34032,34033,34041,34043,34045,34075,34080,34084,34090,34091,
   34092,34128,34130,34132,34134,34138,34171,34173,34175,34177,
   34181,34213,34215,34217,34219,34223,34254,34256,34258,34260,
   34264,34294,34296,34298,34300,34304,34324,34333,34335,34337,
   34339,34343,34371,34377,34386,34408,34411,34412,34413,34414,
   34418,34421,34444,34446,34448,34450,34451,34479,34481,34483,
   34486,34506,34513,34515,34517,34519,34521,34544,34545,34546,
   34548,34550,34552,34553,34563,34567,34570,34574,34578,34580,
   34582,34584,34587,34608,34609,34627,34639,34640,34654,34660,
   34668,34672,34673,34674,34684,34696,34702,34713,34753,34774,
   34780,34784,34799,34802,34803,34805,34810,34811,34812,34814,
   34815,34816,34817,34818,34822,34827,34831,34856,34861,34865,
   34868,34870,34874,34890,34897,34901,34902,34903,34904,34905,
   34906,34907,34908,34909,34919,34923,34925,34927,34928,34929,
   34930,34933,34935,34936,34937,34938,34939,34940,34942,34943,
   34944,34945,34948,34955,34956,34973,34985,34998,35003,35006,
   35090,35106,35111,35114,35126,35127,35151,35152,35156,35169,
   35171,35172,35173,35174,35200,35213,35215,35216,35243,35256,
   35258,35259,35262,35285,35298,35300,35301,35326,35339,35341,
   35358,35366,35379,35381,35382,35383,35405,35418,35420,35421,
   35423,35424,35438,35441,35443,35444,35453,35456,35458,35460,
   35473,35492,35493,35525,35527,35529,35531,35532,35543,35547,
   35551,35564,35567,35588,35594,35598,35601,35605,35613,35621,
   35625,35626,35627,35628,35629,35630,35631,35632,35633,35634,
   35635,35636,35637,35638,35639,35642,35643,35644,35646,35647,
   35648,35650,35651,35663,35665,35666,35668,35686,35688,35694,
   35696,35697,35712,35724,35759,35775,35781,35783,35790,35797,
   35808,35811,35818,35834,35837,35847,35850,35861,35883,35886,
   35896,35906,35908,35909,35917,35931,35939,35942,35947,35949,
   35951,35952,35971,35973,35975,35978,35979,35980,35982,35983,
   35984,35985,35986,35987,35990,35991,35994,36000,36009,36011,
   36012,36013,36014,36016,36017,36018,36020,36024,36025,36026,
   36027,36028,36029,36032,36033,36034,36035,36036,36037,36038,
   36039,36040,36041,36052,36079,36080,36088,36094,36186,36187,
   36191,36195,36208,36211,36235,36237,36255,36293,36297,36336,
   36374,36380,36401,36421,36460,36467,36486,36497,36503,36516,
   36535,36571,36597,36640,36646,36673,36676,36678,36705,36737,
   36747,36753,36758,36768,36777,36800,36829,36876,36900,36947,
   36958,36960,36974,36986,36990,36991,37011,37014,37042,37052,
   37068,37069,37080,37117,37122,37128,37129,37130,37133,37134,
   37136,37144,37187,37190,37192,37198,37210,37220,37225,37228,
   37242,37243,37244,37258,37263,37264,37268,37284,37296,37300,
   37310,37325,37327,37375,37378,37386,37391,37404,37407,37408,
   37425,37430,37447,37450,37455,37464,37465,37466,37467,37468,
   37469,37471,37472,37474,37483,37485,37487,37488,37489,37490,
   37493,37494,37495,37499,37500,37501,37504,37505,37511,37513,
   37521,37522,37524,37527,37531,37556,37557,37558,37564,37567,
   37576,37592,37593,37594,37610,37612,37613,37614,37619,37621,
   37625,37626,37627,37631,37632,37641,37650,37652,37653,37654,
   37655,37656,37657,37658,37659,37661,37663,37664,37665,37666,
   37667,37668,37669,37673,37674,37675,37676,37692,37713,37720,
   37722,37750,37782,37803,37809,37810,37822,37826,37827,37835,
   37836,37849,37859,37862,37863,37876,37888,37911,37934,37935,
   37947,37953,37956,37957,37963,37968,37977,37998,38005,38010,
   38017,38034,38035,38037,38049,38052,38054,38057,38058,38059,
   38061,38063,38064,38065,38066,38069,38072,38073,38074,38078,
   38079,38080,38081,38082,38083,38084,38087,38091,38093,38105,
   38115,38118,38123,38131,38137,38236,38278,38362,38401,38578,
   38584,38643,38649,38919,38932,38940,38971,38979,39054,39181,
   39224,39264,39453,39487,39666,39791,39799,39834,39842,39989,
   39993,39997,40084,40163,40221,40519,40547,40658,40663,40740,
   40945,40983,41098,41133,41374,41502,41658,41683,41692,41765,
   41877,41946,42066,42096,42615,42619,42749,42753,43202,43221,
   43898,43949,44101,44257,44653,44686,44748,44752,45170,45207,
   45283,45356,45520,45551,45592,45903,45909,46078,46083,46172,
   46177,46193,46198,46333,46339,46348,46353,46384,46398,46941,
   47048,47049,47075,47076,47105,47106,47136,47183,47201,47203,
   47259,47260,47955,48111,48283,48325,48518,48848,48864,48958,
   48979,49083,49137,49200,49290,49298,49346,49434,49537,49577,
   49582,49619,49620,49725,50404,50412,50449,50583,50614,50853,
   50885,50893,50897,50947,50968,50969,50975,50981,50982,50983,
   50987,50995,51251,51330,51331,51393,51394,51419,51738,51757,
   51763,51936,52016,52050,52094,52116 ],
 [ 836,839,869,870,884,885,890,891,941,942,943,944,970,972,
   973,983,997,1002,1022,1023,1043,1044,1047,1052,1092,1093,
   1117,1130,1146,1148,1191,1193,1195,1196,1237,1242,1278,1279,
   1282,1287,1706,1709,1710,1714,1743,1746,1747,1748,1771,1774,
   1775,1779,1803,1804,1807,1812,1833,1834,1837,1842,2057,2060,
   2061,2065,2081,2084,2085,2086,2096,2099,2100,2104,2147,2150,
   2153,2158,2162,2165,2168,2173,2216,2220,2243,2247,2596,2767,
   2768,2786,2788,2789,2814,2830,2883,2888,2891,3073,3081,3095,
   3096,3125,3133,3155,3196,3197,3226,3234,3257,3337,3339,3341,
   3343,3344,3384,3388,3390,3391,3402,3406,3489,3492,3499,3698,
   3699,3703,3704,3737,3738,3742,3743,3917,3918,3922,3923,3982,
   3983,3987,3988,4258,4271,4310,4424,4432,4442,4469,4912,5031,
   5097,5099,5165,5166,5218,5219,5270,5271,5279,5293,5297,5299,
   5326,5328,5339,5342,5378,5392,5404,5522,5536,5549,5639,5641,
   5643,6030,6032,6064,6066,6134,6372,6374,6415,6417,6459,6565,
   6591,6831,6835,7123,7128,7246,7253,7254,7267,7299,7306,7307,
   7309,7320,7406,7408,7415,7421,7425,7458,7459,7460,7465,7553,
   7555,7562,7568,7687,7691,7706,7708,9027,9029,9142,9322,9334,
   9336,9337,9374,9389,9393,9395,9422,9424,9425,9438,9472,9474,
   9475,9495,9523,9524,9537,9544,9545,9569,9578,9582,9584,9629,
   9636,9662,9671,9675,9678,9688,9692,9707,9709,9710,9716,9720,
   9730,9731,10158,10161,10162,10166,10195,10223,10226,10227,
   10231,10255,10286,10509,10512,10513,10517,10537,10548,10551,
   10552,10556,10570,10584,10599,10617,10668,10672,10695,10699,
   10982,10983,11214,11223,11267,11319,11320,11328,11352,11391,
   11420,11449,11452,11469,11470,11498,11502,11531,11537,11538,
   11578,11584,11585,11595,11630,11631,11641,11642,11656,11675,
   11934,11935,11936,11971,12012,12179,12180,12181,12269,12403,
   12421,12425,12426,12464,12468,12469,12504,12508,12523,12541,
   12643,12648,12649,12651,12669,12691,12873,13106,13127,13159,
   13165,13168,13169,13178,13180,13211,13268,13279,13282,13318,
   13380,13381,13382,13389,13422,13426,13473,13475,13476,13508,
   13515,13517,13521,13532,13568,14587,14991,15005,15006,15007,
   15015,15020,15035,15041,15048,15054,15141,15148,15160,15179,
   15188,15196,15224,15234,15255,15270,15289,15297,15303,15306,
   15307,15321,15329,15337,15345,15354,15371,15380,15388,15390,
   15395,15398,15399,15880,15881,16038,16258,16279,16639,16706,
   16714,16727,16758,16765,16766,16780,16820,16833,16862,16866,
   16868,16879,16918,16919,16933,16948,16960,16969,16982,16983,
   16993,16998,17026,17062,17073,17087,17091,17101,17108,17109,
   17133,17138,17153,17154,17155,17168,17169,17178,17183,17470,
   17644,17703,17738,17980,18049,18069,18425,18469,18477,18492,
   18521,18522,18544,18573,18577,18580,18596,18597,18630,18672,
   18679,18680,18697,18704,18724,18739,18812,18813,18817,18844,
   20112,20131,20133,20149,20164,20171,20175,20189,20193,20221,
   20232,20238,20244,20259,20269,20279,20290,20305,20366,20369,
   20374,20375,20377,20386,20388,20390,20403,20406,20421,20423,
   20437,20440,20450,20507,20511,20512,20514,20521,20525,20528,
   20867,21014,21020,21345,21666,21672,21685,21687,21692,21725,
   21727,21736,21739,21740,21741,21746,21756,21778,21791,21793,
   21807,21821,21829,21835,21844,21856,21858,21872,21876,21880,
   21885,21887,21891,21893,21897,21969,21973,21976,21988,22004,
   22015,22022,22035,22036,22043,22107,22126,22133,22142,22430,
   22494,22502,22504,22604,22628,22636,22638,22659,22698,22728,
   22855,22941,22979,22988,23003,23029,23087,23133,23195,23211,
   23218,23234,23300,23304,23310,23315,23333,23359,23367,23374,
   23380,23384,23397,23408,23419,23430,23432,23446,23463,23469,
   23477,23502,23505,23521,23532,23543,23544,23557,23562,23564,
   23575,23604,23618,23631,23640,23648,23650,23651,23655,23665,
   24139,24451,24470,24739,24751,24756,24762,24773,24790,24795,
   24818,24870,24882,24895,24900,24908,24930,25037,25039,25059,
   25060,25126,25128,25130,25135,25151,25154,25155,25937,26009,
   26054,26174,26175,26182,26183,26226,26227,26234,26235,26278,
   26282,26284,26286,26298,26328,26335,26377,26384,26425,26433,
   26438,26440,26442,26444,26472,26480,26489,26492,26526,26539,
   26571,26584,26649,26650,26658,26692,26699,26700,26713,26733,
   26741,26772,26781,26812,26850,26858,26871,26878,26882,26888,
   26889,26892,26898,26899,26900,26901,26902,26903,26904,26905,
   26908,26911,26913,26914,26915,26919,26920,26921,26923,26931,
   26966,26999,27000,27055,27119,27125,27126,27146,27158,27159,
   27160,27161,27162,27165,27168,27171,27175,27177,27180,27181,
   27183,27295,27310,27321,27360,27396,27408,27411,27416,27435,
   27448,27465,27467,27527,27604,27605,27612,27613,27655,27660,
   27662,27663,27676,27677,27705,27710,27712,27713,27726,27727,
   27762,27776,27810,27816,27820,27822,27824,27826,27857,27870,
   27903,27916,27945,27948,27962,27984,27992,28006,28007,28027,
   28028,28070,28077,28078,28080,28091,28117,28118,28132,28150,
   28158,28171,28172,28189,28197,28211,28228,28229,28230,28231,
   28232,28233,28234,28235,28238,28239,28240,28247,28249,28251,
   28254,28256,28257,28258,28259,28260,28263,28272,28286,28287,
   28291,28308,28322,28340,28342,28345,28357,28377,28433,28442,
   28456,28473,28487,28497,28502,28504,28505,28507,28508,28512,
   28518,28522,28523,28524,28525,28526,28527,28532,28533,28554,
   28574,28588,28627,28652,28688,28698,28699,28774,28777,28792,
   28793,28797,28813,28816,28826,28829,28833,28836,28837,28838,
   28840,28842,28844,28845,28848,28852,28855,28914,28918,28923,
   28927,28981,28988,29031,29032,29038,29054,29080,29087,29128,
   29129,29142,29144,29146,29148,29151,29152,29176,29193,29195,
   29198,29221,29222,29244,29267,29284,29286,29289,29310,29318,
   29340,29353,29354,29362,29376,29380,29382,29396,29437,29459,
   29464,29476,29499,29515,29516,29554,29555,29556,29557,29558,
   29559,29561,29562,29564,29565,29566,29570,29572,29577,29580,
   29582,29583,29584,29589,29590,29591,29592,29593,29598,29600,
   29602,29603,29605,29606,29607,29608,29609,29611,29617,29618,
   29619,29622,29624,29625,29627,29637,29649,29666,29702,29705,
   29718,29726,29751,29761,29780,29783,29844,29848,29873,29911,
   29928,29937,29954,29979,30026,30038,30064,30067,30069,30126,
   30158,30175,30178,30180,30184,30188,30306,30311,30313,30314,
   30327,30328,30355,30362,30410,30417,30423,30424,30457,30464,
   30470,30471,30501,30503,30517,30546,30548,30563,30590,30592,
   30606,30633,30635,30649,30675,30677,30691,30716,30718,30719,
   30756,30759,30772,30773,30790,30795,30831,30833,30857,30886,
   30892,30921,30922,30941,30943,30957,30977,30991,31011,31015,
   31016,31018,31019,31020,31021,31023,31024,31028,31032,31033,
   31037,31038,31039,31040,31042,31074,31078,31079,31080,31081,
   31082,31083,31084,31086,31087,31091,31094,31095,31098,31099,
   31100,31101,31102,31103,31117,31124,31125,31155,31201,31224,
   31227,31245,31251,31255,31289,31299,31342,31361,31375,31377,
   31390,31391,31395,31399,31414,31417,31419,31422,31424,31426,
   31427,31428,31429,31431,31444,31454,31456,31480,31542,31547,
   31553,31565,31581,31588,31635,31648,31682,31683,31693,31695,
   31696,31728,31741,31771,31773,31774,31788,31817,31818,31860,
   31874,31886,31902,31903,31904,31941,31943,31944,31958,31965,
   31968,31984,32016,32023,32026,32045,32055,32060,32061,32078,
   32085,32134,32157,32202,32203,32236,32268,32299,32302,32304,
   32305,32306,32307,32308,32309,32312,32313,32316,32318,32320,
   32323,32324,32325,32326,32328,32330,32331,32333,32334,32342,
   32344,32345,32347,32349,32350,32351,32352,32353,32357,32378,
   32399,32405,32433,32456,32470,32517,32523,32527,32537,32649,
   32702,32714,32809,32818,32869,32871,32872,32947,32956,32993,
   33135,33219,33229,33242,33261,33266,33268,33404,33509,33524,
   33629,33690,33708,33731,33742,33799,33846,33849,33864,33916,
   33925,33929,33986,33993,33999,34000,34032,34045,34075,34084,
   34128,34130,34132,34134,34138,34171,34177,34213,34219,34254,
   34256,34258,34260,34264,34294,34300,34324,34333,34339,34386,
   34411,34412,34413,34421,34444,34446,34448,34450,34451,34479,
   34481,34483,34486,34506,34513,34517,34544,34545,34546,34548,
   34550,34552,34553,34563,34570,34582,34584,34587,34608,34609,
   34627,34654,34660,34668,34673,34674,34684,34696,34702,34753,
   34774,34780,34784,34802,34803,34805,34810,34812,34814,34816,
   34817,34822,34827,34831,34865,34868,34870,34890,34897,34901,
   34903,34904,34906,34908,34909,34919,34923,34925,34927,34928,
   34930,34933,34935,34937,34938,34939,34942,34943,34945,34955,
   34956,34973,34985,35003,35090,35114,35127,35152,35169,35171,
   35174,35213,35215,35216,35256,35258,35259,35298,35300,35301,
   35339,35341,35358,35382,35383,35418,35420,35438,35444,35458,
   35473,35492,35493,35525,35527,35529,35531,35532,35543,35547,
   35564,35567,35588,35598,35601,35613,35663,35665,35666,35668,
   35688,35694,35696,35697,35712,35775,35781,35783,35797,35808,
   35811,35837,35850,35861,35883,35886,35908,35909,35931,35942,
   35949,35952,35973,35975,35979,35982,35983,35987,35990,35991,
   36009,36011,36014,36016,36017,36018,36020,36024,36025,36026,
   36027,36029,36032,36033,36036,36037,36038,36039,36040,36041,
   36052,36195,36208,36235,36237,36293,36336,36374,36467,36516,
   36597,36646,36676,36678,36747,36753,36800,36958,36960,36986,
   37014,37042,37068,37069,37144,37187,37198,37210,37225,37242,
   37243,37258,37296,37300,37310,37325,37327,37375,37378,37404,
   37430,37447,37455,37511,37513,37522,37527,37531,37564,37567,
   37593,37594,37614,37619,37621,37632,37641,37650,37652,37653,
   37654,37656,37657,37658,37661,37663,37666,37667,37668,37673,
   37675,37676,37782,37810,37827,37849,37859,37863,37876,37888,
   37935,37947,37953,37957,37968,37998,38005,38010,38017,38037,
   38049,38069,38072,38074,38078,38079,38080,38081,38084,38087,
   38091,38093,38578,38584,38643,38649,38919,38932,38971,39791,
   39834,42615,42619,42749,42753,43221,44101,44748,44752,45207,
   45903,45909,46078,46172,46193,46339,46348,46941,47105,47106,
   47136,47183,47259,47260,47955,48111,48518,48958,49137,49298,
   49577,49619,49620,49725,50404,50583,50885,51251,51331,51393,
   51394,51757,51763,51936 ],
 [ 1743,1747,1807,1812,1837,1842,2081,2085,2153,2158,2168,2173,
   3489,3492,5639,5643,6831,7123,9337,9374,9425,9472,9523,9524,
   9537,9544,9545,9569,9636,9662,9671,9675,9678,9688,9692,9709,
   9710,9720,10195,10537,10584,11214,11328,11420,11469,11470,
   11498,11502,11538,11578,11630,11631,11641,11642,11656,11675,
   12269,12403,13127,13159,13165,13168,13169,13279,13380,13381,
   13382,13389,13508,13515,13517,13521,13532,14991,15005,15006,
   15007,15035,15054,15234,15255,15307,15337,15345,15388,15395,
   16727,16765,16879,16933,16960,16969,16982,16983,16993,16998,
   17062,17101,17108,17109,17133,17138,17153,17154,17169,17470,
   17703,17738,18049,18069,18492,18580,18596,18672,18679,18704,
   18724,18812,18813,18817,18844,20221,20279,20290,20507,20511,
   20512,20514,20525,20528,20867,21345,21672,21685,21687,21692,
   21725,21727,21736,21739,21741,21746,21756,21778,21791,21821,
   21829,21835,21844,21856,21858,21872,21876,21880,21885,21887,
   21891,21893,21969,21973,21976,22004,22015,22022,22107,22126,
   22133,22142,22604,23003,23211,23218,23315,23359,23367,23374,
   23380,23384,23408,23469,23477,23557,23564,23640,23665,24756,
   24895,24900,25126,25128,25130,25135,25151,25154,26054,26878,
   27055,27119,27146,27310,27396,27408,27411,27435,27448,27465,
   28291,28433,28497,28554,28688,28774,28777,28792,28797,28813,
   28826,28855,29761,30857,30892,31125,31155,31289,31375,31391,
   31395,31414,31444,31454,31456,32378,32399,32517,33219,33229,
   33261,33404,33524,33690,33708,33799,33925,34386,34421,34563,
   34627,34654,34660,34684,34919,34923,34925,34956,34973,34985,
   35473,36052,36467,36646,36800,36958,36960,37042,37069,37210,
   37258,37296,37300,37375,37378,37455,37527,37531,37564,37567,
   37632,37641,37876,37947,38010,38049,38091,48958,51757,51763 ],
 [ 10584,17470,20867,21345,26054,33799,34919 ],[ 34919 ],[ ],[ ],
 [ ],[ ] ],

maxorbitlengths := 
[ [ 6,6,4,8,8,,4,8,,8,,,6,6,8,4,6,12,4,4,6,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,6,,,6,,4,8,4,
   ,4,4,8,6,4,8,8,,4,8,,8,,,4,4,4,6,6,6,6,8,12,16,4,
   4,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,
   4,4,8,,,6,8,6,,,6,12,12,,6,12,,12,,,12,6,18,6,6,24,
   12,18,24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,
   ,,,,,,,,,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,2,4,4,6,2,
   4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,
   4,4,4,4,6,4,6,2,6,2,4,6,4,,4,4,,4,,,8,4,12,4,4,16,
   8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,4,4,,,,4,8,,8,,
   12,,12,,,,,,,,,4,4,,,4,,,,,4,,,4,4,,4,,,8,4,12,4,4,16,8,
   12,16,20,4,8,8,4,8,8,,,8,8,12,,12,4,4,,,,4,8,,8,,12,,
   12,,,,,,,,,4,4,,,4,,,,,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,2,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,4,4,4,
   4,6,4,6,2,6,2,4,6,,4,,,8,4,12,4,4,16,8,12,16,20,4,
   8,8,4,8,8,,,8,8,12,,12,4,4,,,,4,8,,8,,12,,12,,,,,,,,,4,
   4,,,4,,,,,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,8,4,12,4,4,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,
   12,4,4,,,,4,8,,8,,12,,12,,,,,,,,,4,4,,,4,,,,,4,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,6,6,6,8,8,8,4,4,4,4,4,4,,
   ,6,6,8,,8,8,8,,,,4,6,,6,,8,,8,,,8,8,,,,4,4,4,4,8,20,
   8,6,8,6,20,8,4,4,4,4,6,6,6,8,4,4,4,4,4,4,,,6,6,6,
   12,6,4,4,,,,4,6,,6,,6,12,6,,,4,4,,,,4,4,4,4,16,4,6,
   6,16,6,4,6,6,6,6,8,10,10,10,4,4,4,4,4,4,,,8,8,16,,
   16,,,,,,4,8,,8,,16,,16,,,8,8,,,,4,4,4,4,22,22,8,,22,,
   22,8,4,6,4,4,4,8,4,6,6,4,6,6,,,4,4,6,4,6,4,4,,,,4,
   4,,4,,6,4,6,,,12,12,,,,6,4,4,6,6,4,16,4,6,4,4,16,6,
   6,6,6,10,4,6,6,4,6,6,,,6,6,6,,6,4,4,,,,4,6,,6,,6,,6,
   ,,,,,,,6,4,4,6,16,4,16,6,16,6,4,16,8,10,10,8,4,6,6,
   4,6,6,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,6,4,
   4,6,46,14,8,30,46,30,14,8,4,6,8,2,6,6,2,6,6,,,4,4,
   8,8,8,8,8,,,,2,4,,4,,8,8,8,,,,,,,,20,20,20,20,8,4,8,
   2,8,2,4,8,6,10,4,8,8,4,8,8,,,4,4,16,8,16,,,,,,4,4,,
   4,,16,8,16,,,,,,,,,22,22,,8,4,22,4,8,4,4,22,8,4,12,12,
   4,12,12,,,6,6,8,4,8,,,,,,4,6,,6,,8,4,8,,,28,28,,,,30,
   14,14,30,8,4,46,6,8,6,4,46,6,16,16,6,16,16,,,16,16,
   6,12,6,8,8,,,,6,16,,16,,6,12,6,,,,,,,,16,14,14,16,,14,,
   16,,16,14,,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,
   4,,,4,4,,,,4,4,4,4,6,4,6,2,6,2,4,6,4,4,4,4,,,6,6,
   6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,6,8,6,,,4,
   4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,
   6,8,6,,,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,
   ,4,4,4,4,6,4,6,2,6,2,4,6,4,,,6,6,6,8,6,,,,,,4,6,,6,
   ,6,8,6,,,,,,,,4,4,4,4,8,,,6,8,6,,,,,6,6,6,8,6,,,,,,4,
   6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,6,8,6,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,
   4,4,,4,,6,,6,,,8,8,,,,6,,,6,,4,8,4,,4,4,8,6,,6,,,,,,4,
   4,,4,,6,,6,,,8,8,,,,6,,,6,,4,8,4,,4,4,8,,4,8,8,,,,4,6,
   ,6,,4,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,10,8,,,,,,,4,,,,,
   ,4,,,,,,,,,,16,16,,8,4,12,12,8,12,4,12,8,8,,,,4,6,,6,,
   4,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,10,8,4,,,,4,,,,,8,,
   8,,,,,,,,8,4,4,8,,4,,8,,8,4,,,,,4,,,,,8,,8,,,,,,,,8,4,4,
   8,,4,,8,,8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,,,4,4,4,4,
   6,4,6,2,6,2,4,6,,4,,6,,6,,,8,8,,,,6,,,6,,4,8,4,,4,4,
   8,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,6,,,6,,4,8,4,,4,4,
   8,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,
   10,8,,,,,,,,,,16,16,,8,4,12,12,8,12,4,12,,,,,,,,8,10,10,
   8,8,10,8,8,8,8,10,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,
   12,,,12,12,16,8,,12,,16,8,,,,12,,,12,12,16,8,,12,,16,8,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,8,,,,8,,,,4,4,,4,,,,
   ,4,,4,,4,,,,,4,,8,,,,8,,,,,,,6,,,,,4,,4,4,,8,,8,,6,,2,4,
   8,,,,4,8,,3,6,3,9,,6,9,,12,,,3,6,6,6,6,9,3,6,9,12,
   3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,3,9,6,
   6,,6,,6,9,3,9,9,6,3,9,,6,9,,12,,,3,6,6,6,6,9,3,6,
   9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,
   3,9,6,6,,6,,6,9,3,9,9,3,3,,4,7,10,7,7,,5,3,5,3,5,
   10,4,4,5,9,3,5,5,3,5,5,3,,3,3,5,,5,,3,,,,4,4,6,4,,
   5,6,5,,,5,5,,5,,5,,3,5,,3,7,4,6,4,4,5,3,,5,5,12,8,,
   ,3,3,5,5,5,10,3,5,5,9,3,3,3,5,5,5,3,,3,5,5,,5,,3,,
   ,,3,3,,6,8,7,,7,5,5,,,,,,3,7,3,,5,5,,7,6,3,5,7,4,7,
   8,,7,,,10,3,10,10,10,7,4,10,10,16,3,7,7,7,10,10,3,,
   3,7,10,,10,,3,,,,4,4,4,4,5,5,4,5,8,8,,,,,,,,3,7,7,,,
   4,4,4,10,,3,,,,,,2,4,,2,,,3,3,,,2,4,4,4,,,4,,2,4,,,,,4,
   ,,,3,3,4,,5,,4,,3,3,,,,,,2,,,,,2,,3,,3,3,,5,,7,,,3,5,
   5,3,5,5,3,3,5,8,3,5,5,4,5,5,6,,3,4,5,,5,,6,,,,3,3,
   3,4,3,5,3,5,3,3,5,5,,8,,3,8,5,5,5,3,7,3,4,3,4,7,,
   7,,,4,5,6,5,4,7,4,5,4,7,4,5,5,5,6,6,6,,4,5,6,,6,,
   6,,,,7,7,,4,,10,,10,5,5,,,,6,,7,7,5,,4,5,10,4,10,4,5,,
   ,,,8,26,,,17,9,5,14,,,5,,,,,,,,5,,,,,,,,,,,,6,,17,,6,,,,,,,,,
   ,9,11,9,5,14,14,,,,,,,,9,7,9,9,14,10,6,9,8,11,6,9,9,
   7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,11,9,10,9,10,10,
   8,8,,,,,8,7,,6,,8,8,10,8,10,,,,7,16,9,9,,12,,,,6,,,,,,7,
   ,6,,,,,,7,,,,6,6,,,,,,,,,,,,8,,7,14,,6,8,,,,9,,,9,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,2,5,5,3,3,7,7,
   2,3,3,5,5,5,9,,2,5,5,,5,,9,,,,3,3,6,4,6,8,6,8,3,3,
   6,6,,6,,2,7,5,5,4,2,7,3,5,3,8,6,5,5,5,5,4,5,5,5,
   3,5,5,5,5,5,3,,3,5,5,,5,,3,,,,4,4,4,4,,4,4,4,6,6,
   5,5,,5,,5,7,3,5,5,5,7,4,4,4,5,5,5,5,5,6,8,7,8,4,
   5,5,5,5,5,9,,4,5,5,,5,,9,,,,5,5,,6,9,7,,7,5,5,5,5,,,
   ,5,14,5,4,5,21,6,7,6,25,8,7,5,5,3,3,5,5,2,5,5,3,
   5,5,9,,2,3,5,,5,,9,,,,3,3,3,2,3,3,3,3,3,3,5,5,,9,,
   2,7,5,4,5,2,7,3,3,3,2,9,5,4,5,4,4,4,5,5,5,5,5,9,
   ,4,5,5,,5,,9,,,,5,5,9,4,,5,9,5,11,11,7,7,,9,,21,6,
   5,5,4,5,14,4,11,4,5,7,7,7,6,7,4,5,5,5,4,4,7,,4,5,
   4,,4,,7,,,,6,6,7,4,8,6,7,6,5,5,5,5,,10,,6,10,5,4,4,
   6,10,8,8,11,6,9,3,4,7,3,3,3,4,6,6,4,,3,4,6,,6,,4,,,
   ,3,3,3,4,3,8,3,8,3,3,,,,5,,3,14,4,11,4,3,8,3,4,3,
   4,8,5,8,3,5,5,4,10,10,6,,3,4,10,,10,,6,,,,3,3,3,4,
   3,7,3,7,3,3,7,7,,6,,3,9,5,7,5,3,10,3,4,3,4,26,7,
   4,6,6,5,12,12,6,,4,5,12,,12,,6,,,,5,5,7,4,6,6,7,6,
   8,8,10,10,,6,,12,8,5,6,4,5,14,4,7,4,5,18,4,9,9,6,
   6,6,6,,4,6,6,,6,,6,,,,9,9,10,6,,8,10,8,,,6,6,,,,6,8,
   5,6,4,14,38,8,9,12,5,8,3,3,3,4,4,3,,2,3,4,,4,,3,,,,
   3,3,3,2,3,3,3,3,3,3,3,3,,3,,2,6,3,4,4,2,6,3,3,3,
   2,5,3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,
   ,3,7,5,5,5,5,,4,4,3,7,7,5,5,5,,,3,5,5,,5,,,,,,3,3,
   4,4,5,4,4,4,5,5,,,,,,3,7,5,5,5,5,,4,4,3,7,7,5,5,,,
   3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,5,,5,5,5,3,7,
   4,4,4,4,5,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,
   5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,6,,4,5,4,,4,,6,,,,5,
   5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,,
   3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,,,,6,,3,6,6,6,,4,4,
   4,10,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,
   3,2,3,3,3,3,3,3,3,3,,3,,2,6,3,4,4,2,6,3,3,3,2,5,
   5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,5,,5,5,5,3,7,4,4,
   4,4,5,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,
   4,4,8,8,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,
   4,6,5,6,5,5,5,5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,6,,3,6,6,6,
   ,4,4,4,10,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,3,3,5,5,,5,,3,8,4,
   5,,3,7,3,8,3,4,7,,4,,5,,5,3,3,5,5,,5,,3,8,4,5,,3,
   7,3,8,3,4,7,4,3,,3,,,,,,,5,,3,9,5,,12,3,9,4,4,3,4,9,
   ,4,4,4,6,6,6,6,,,,4,6,6,4,4,2,6,4,4,4,2,6,,3,,,,,,,,
   ,3,9,11,6,,3,9,,,3,5,12,,3,5,5,,,,5,,4,7,5,6,9,5,8,
   8,4,9,5,6,,,,,,,5,,3,9,5,,12,3,9,4,4,3,4,9,5,5,,,,5,
   ,4,7,5,6,9,5,8,8,4,9,5,6,3,5,5,,,,3,8,6,5,5,3,7,
   3,9,3,,7,5,5,,,,3,8,6,5,5,3,7,3,9,3,,7,3,,,,11,7,,
   5,5,5,8,,9,9,9,6,,,,11,7,,5,5,5,8,,9,9,9,6,,,,,,,,,,,,,
   ,,,,,,6,6,12,,7,5,5,,8,,,,,,,,,,,,,8,5,5,6,2,,3,4,3,5,,
   8,14,,,,7,8,8,7,7,5,5,5,8,5,7,4,5,6,4,6,,11,5,,5,,
   5,14,4,25,4,5,,8,3,3,3,2,,8,7,13,17,7,4,3,4,8,4,3,
   28,4,,7,6,3,9,,6,9,,12,,,3,6,6,6,6,9,3,6,9,12,3,3,
   3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,3,9,6,6,,6,
   ,6,9,3,9,9,5,5,,4,7,,7,,,3,3,3,5,5,5,3,5,5,8,4,3,
   4,4,4,4,3,3,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,,,,
   3,4,3,4,7,5,5,5,7,5,8,6,5,,3,3,,8,,12,3,5,5,3,5,
   5,3,5,10,9,3,3,3,5,5,6,5,5,3,5,5,,7,3,,,,,3,3,,5,,
   5,,7,,3,,,,,8,3,5,5,7,,3,5,,7,3,7,6,,7,8,,7,,,4,5,5,
   5,4,4,4,6,7,7,7,4,7,5,5,4,5,5,5,6,6,,10,6,,,6,,4,
   5,,6,,6,,10,,6,,,,,,4,5,5,,10,5,4,,,7,7,10,7,,,,,,12,9,
   ,7,9,,,16,,,6,6,6,,,,,,,,,,,7,,,8,,6,,,,,,,,,7,,,,,,,,,,,,8,
   6,9,7,14,9,3,,7,,10,4,4,4,3,5,5,5,5,10,9,4,3,4,4,
   4,4,,,5,5,5,5,5,3,,6,5,,3,5,,5,,5,5,5,,3,,6,,,,4,4,
   4,4,7,3,,5,5,5,,6,,7,4,,4,10,10,3,10,10,10,10,7,16,
   4,3,4,7,7,4,8,8,7,10,10,,5,3,,4,,,3,7,,10,,10,,5,,3,
   ,4,,,5,4,10,,4,,3,7,7,,,,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,6,9,9,7,14,8,9,9,10,11,7,6,7,7,
   7,6,10,10,9,8,8,8,9,10,,10,,,6,9,,8,,8,8,9,,10,,10,,,
   11,8,10,,8,8,7,6,,,,8,10,,3,,,4,,,,,,,,2,,,,,,,4,,,,,4,,4,
   ,,2,4,,,,,,,,4,,4,,,5,3,,,3,,,,,,2,,,6,,14,26,17,,,,,,,6,,,
   ,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,,17,,,14,,14,11,10,9,,,,,3,3,
   4,4,4,3,6,7,7,3,3,3,4,4,4,3,3,3,6,6,,8,4,,3,5,,3,
   3,,6,,6,,8,,4,,3,,,3,3,4,3,3,8,4,4,11,8,3,14,4,3,5,
   5,5,3,5,5,5,4,3,4,3,3,4,3,3,5,5,5,5,3,9,,4,9,,3,
   5,,5,,5,5,3,,9,,4,,,8,3,3,3,4,7,5,5,4,9,11,7,4,5,
   5,5,3,8,7,8,4,3,4,4,4,4,3,3,5,10,10,7,7,6,,4,6,,
   3,5,,10,,10,7,7,,6,,4,,,,3,4,3,4,10,5,5,7,26,7,9,4,
   5,5,5,5,5,5,4,3,4,5,5,4,6,6,5,5,5,5,4,3,,4,5,,3,
   5,,5,,5,5,4,,3,,4,,,,4,5,5,4,7,3,5,5,5,5,7,4,4,5,
   5,5,4,5,4,5,5,5,4,11,11,5,5,5,7,5,9,,9,9,,4,5,,5,,
   5,7,5,,9,,9,,,,4,5,5,4,14,5,4,5,7,21,6,11,7,7,6,7,
   5,4,5,5,5,4,8,8,6,12,12,10,6,6,,7,6,,4,6,,12,,12,
   10,6,,6,,7,,,6,4,5,5,4,14,5,4,6,18,12,8,7,5,5,7,3,
   2,3,5,5,4,3,3,3,5,5,6,8,9,,6,6,,2,3,,5,,5,6,8,,9,,
   6,,,8,3,8,3,8,7,5,4,5,6,2,7,5,5,8,5,4,5,5,5,6,5,
   5,5,5,5,5,7,9,,,,,4,5,,5,,5,5,7,,9,,,,,9,25,8,21,7,
   6,5,5,4,7,5,14,6,7,6,4,6,5,5,4,5,5,5,4,4,5,6,7,,
   7,10,,4,5,,4,,4,5,6,,7,,7,,,8,11,6,6,8,10,5,4,4,9,
   6,10,8,9,4,9,6,6,6,,,9,6,6,6,8,6,,10,,,4,9,,6,,6,6,
   8,,6,,10,,,,12,5,14,8,38,5,4,6,8,6,8,9,3,3,4,4,4,,,
   3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,3,4,4,4,7,4,,
   5,7,3,8,8,3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,
   4,3,3,,3,,3,,,3,3,3,3,3,6,3,4,4,5,2,6,3,4,4,4,,,3,
   5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,3,4,4,4,7,4,,5,
   7,3,8,8,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,
   5,4,4,3,4,7,5,5,5,5,5,,4,4,,,5,5,5,5,3,,,4,,,3,5,,
   5,,5,5,3,,,,4,,,5,4,4,3,4,7,5,5,5,5,5,,4,6,6,4,4,
   4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,4,4,4,4,6,6,6,
   4,6,4,6,4,3,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,3,,3,
   ,7,6,5,5,7,5,8,9,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,
   ,3,,3,,7,6,5,5,7,5,8,9,5,5,,4,,,4,,,3,3,,5,,5,,4,,,,
   4,,,5,3,7,5,4,,5,5,5,7,3,7,4,4,5,5,6,,6,6,,4,5,,4,
   ,4,5,5,,6,,6,,,6,,5,8,6,8,5,4,4,,8,8,6,5,5,6,,6,6,
   ,4,5,,4,,4,5,5,,6,,6,,,6,,5,8,6,8,5,4,4,,8,8,6,,,,,,
   ,3,,,5,,5,3,,,,,,,,,9,9,5,,8,,5,5,6,11,7,9,4,,,5,,3,4,
   ,5,,5,,3,,4,,,,,,9,5,5,8,8,5,9,6,6,4,7,4,,4,,,3,,,6,
   ,6,,4,,3,,4,,,5,4,10,6,4,,3,6,6,7,6,,4,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,3,5,4,4,9,5,12,,9,
   3,9,4,,3,,,6,,6,,5,,,,5,,,,5,,12,7,,,6,6,8,,,5,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,3,3,3,3,6,3,4,4,
   5,2,6,3,,5,,5,,4,,,,4,,,5,3,7,5,4,,5,5,5,7,3,7,4,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,6,,,6,,5,8,6,8,5,4,4,,8,
   8,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,8,6,8,5,4,4,,
   8,8,6,,,,,,,,,9,9,5,,8,,5,5,6,11,7,9,,4,,,,,,9,5,5,8,
   8,5,9,6,6,4,7,4,,,,,,,,,,,,,,,,,,,,4,,,5,4,10,6,4,,3,6,
   6,7,6,,4,,,,,,,,,,,,,,,,,,,,3,5,4,4,9,5,12,,9,3,9,4,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,9,5,,9,11,,6,12,3,9,,4,3,3,13,4,4,,
   ,3,8,4,3,4,17,5,5,5,7,11,7,5,4,8,5,5,6,,,,4,8,5,
   9,11,8,3,7,4,8,14,,7,,,7,5,5,6,5,8,7,4,,6,,25,,5,
   14,5,,7,28,8,4,8,8,8,,6,7,,7,5,,5,4,5,6,6,10,8,7,
   7,20,5,5,4,6,6,6,,,5,6,6,9,6,10,5,5,,,5,4,10,6,,6,,
   6,9,,,,,,,5,,4,4,7,8,8,8,,5,6,6,8,,8,8,,10,,,3,8,4,
   8,7,7,3,4,7,4,3,3,3,10,7,10,,4,3,7,4,4,7,7,7,7,,
   4,3,3,7,10,,7,,10,4,,4,,4,,,3,14,,,4,,4,,14,3,14,14,
   11,7,4,11,7,6,6,5,8,6,8,4,9,8,6,9,8,5,5,4,6,4,6,,
   5,8,6,6,,6,8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,6,
   8,6,6,8,8,6,8,8,7,6,6,5,6,6,,,,,14,6,5,8,18,,9,,8,
   5,5,5,,5,,,6,,8,8,,8,5,,,,6,,5,5,,,5,,,,,6,,,,,5,,,,,5,
   5,5,,,,,8,,7,,,8,6,7,4,6,7,5,5,10,20,5,5,4,6,6,6,,
   9,5,6,6,,6,5,10,10,,,5,4,5,6,,6,,6,,,9,,,,,5,6,8,8,
   8,4,7,4,6,5,,,6,7,11,11,8,8,6,8,4,9,5,6,9,8,8,8,
   4,6,6,6,,,5,4,6,5,4,,8,8,8,12,5,4,,6,8,6,,6,5,,,,8,
   12,12,7,6,8,8,6,6,8,6,6,6,8,8,,,,,14,8,,8,,,8,,16,,,
   5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,,,,,,9,,,,,5,19,5,,,,,,,10,
   5,10,5,5,8,10,10,8,10,6,6,4,4,6,4,,7,6,6,4,7,6,5,
   5,5,,8,6,4,5,4,,6,,4,7,,7,,8,,,7,4,,,5,,5,,4,7,4,4,
   6,,5,9,14,8,,,6,18,8,,,5,,8,,,,5,5,8,6,5,,5,5,,,5,5,,,
   ,8,,,6,,,,6,,,,,5,5,5,,,,,5,,,,,8,14,8,,,8,,16,,,5,,8,,,,
   ,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,5,5,19,,,,,9,,,5,5,8,7,7,
   3,4,9,9,3,3,3,10,7,10,,6,3,4,4,4,4,7,8,8,,6,3,3,
   7,10,,7,,10,4,,6,,4,,,3,12,5,5,4,13,5,13,12,3,11,11,
   5,5,5,8,8,7,7,7,5,5,4,5,5,5,,6,5,5,4,12,5,5,5,5,,
   8,5,4,5,5,,5,,5,12,,6,,10,6,6,5,5,4,4,5,8,5,8,5,5,
   5,5,7,4,7,4,3,7,3,5,5,3,5,6,5,,3,4,3,4,4,3,6,,,7,
   6,4,3,6,5,7,6,,5,4,,3,,8,11,11,5,5,5,5,4,5,4,5,5,
   7,8,8,5,7,5,5,8,7,5,5,4,5,5,5,,12,5,5,4,6,5,5,5,
   5,6,10,5,4,5,5,6,5,,5,6,,12,,8,,,5,5,8,8,5,4,5,4,
   5,5,5,5,7,7,4,7,6,5,5,3,5,3,5,,6,5,3,4,6,3,5,5,
   5,9,8,5,3,5,5,9,3,,5,6,,6,,8,9,9,5,5,7,7,5,7,5,7,
   5,5,5,5,9,7,10,9,8,8,6,8,7,8,,10,7,9,6,10,9,11,10,
   10,,,7,6,11,8,,7,,8,10,,10,,,,,9,,7,7,9,8,8,8,,7,,,5,
   7,9,3,3,3,10,4,10,,4,3,7,4,6,7,8,7,7,,4,3,3,8,10,,
   4,,10,6,,4,,6,,,3,11,13,13,5,5,4,5,11,3,12,12,7,3,4,
   4,3,5,3,5,,4,5,6,4,3,6,,6,6,11,8,5,3,,5,11,3,,5,3,
   ,4,,6,7,7,7,8,5,5,4,5,4,5,8,5,5,5,9,7,7,6,8,9,8,
   ,10,8,7,6,10,7,10,11,11,,,8,6,10,8,,9,,8,10,,10,,,,,7,
   ,8,8,8,7,9,7,,9,,,10,10,3,9,6,9,,4,10,6,4,4,6,8,8,
   8,10,6,10,3,8,9,10,6,,9,4,,4,,6,10,10,8,10,9,9,4,9,
   4,9,10,8,10,10,3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,
   5,7,5,,5,4,,,,4,,,3,5,5,5,4,5,,5,5,3,8,8,3,5,5,5,,,
   3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,3,5,5,5,4,
   5,,5,5,3,8,8,4,3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,3,
   4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,
   ,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,4,,
   ,5,,5,,4,5,4,4,5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,
   5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,6,
   5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,4,,,5,,5,,4,5,
   4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,4,,,,9,6,4,
   3,,6,9,,,6,4,,3,,6,,,7,6,,,4,6,4,6,6,5,9,9,5,4,,5,,
   5,5,,4,3,3,,5,,4,,5,,,4,,,7,7,3,8,5,5,,5,4,5,8,3,5,
   5,4,,3,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,
   5,7,5,7,7,5,5,5,4,4,6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,
   ,6,6,6,4,4,4,4,4,4,4,4,6,4,4,,,,,,6,,3,,6,,4,,6,3,,
   4,,6,9,9,5,9,6,6,4,,4,,9,7,6,6,5,,,9,6,5,3,5,5,9,
   3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,5,5,11,8,,
   3,3,5,11,,,5,,,,,,9,9,5,5,7,7,,5,6,5,5,,5,5,3,9,,5,
   3,5,5,9,5,,5,,,,,8,11,11,,5,5,5,6,7,,7,5,5,5,5,9,,
   5,3,5,5,9,5,,5,,,,,8,11,11,,5,5,5,6,7,,7,5,5,5,5,8,
   ,6,11,,6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,6,,
   ,,,,6,,,8,6,,6,6,10,,,3,,5,,4,,5,,,4,,,7,7,3,8,5,5,,
   5,4,5,8,3,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,
   3,4,4,3,4,4,5,11,,,5,,,,,,9,9,5,5,7,7,,5,6,5,5,,5,5,
   ,5,,4,6,,6,,6,,,5,4,,,5,,5,,4,5,4,4,8,,,,,9,,,,,7,,,,,,
   7,,,,,,,5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,
   ,,,,,,,,,,6,,6,,6,,,5,4,,,5,,5,,4,5,4,4,,4,,6,9,9,5,9,
   6,6,4,,4,,9,7,6,6,,,,,,,,,,,,,,,,,,,6,,,7,6,,,4,6,4,6,6,
   5,9,9,,,,,,,,,,,,,,,,8,8,10,,6,6,,,8,,,,6,6,6,,,,,7,,,,,7,,
   ,,,,,7,,,,,7,,,5,5,5,5,5,6,5,5,3,14,14,,,8,8,5,8,4,
   14,4,4,4,5,,8,,,5,8,8,5,,8,,,5,8,8,8,4,8,8,6,5,5,
   5,4,8,5,,,5,5,5,8,8,8,5,,,14,4,4,5,5,4,3,,4,4,5,4,,
   ,4,3,4,4,4,4,4,6,9,12,3,4,6,4,4,6,3,4,3,6,6,,9,
   4,3,,,,4,4,7,6,,6,,7,,5,,,,,,4,4,3,,,4,4,7,7,4,4,4,,
   4,4,5,4,,,4,3,4,4,4,4,4,6,9,12,3,4,6,4,4,6,3,4,3,
   6,6,,9,4,3,,,,4,4,7,6,,6,,7,,5,,,,,,4,4,3,,,4,4,7,7,
   4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   ,4,,,4,4,4,4,4,4,2,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,
   4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,4,4,4,4,6,4,6,2,6,2,
   4,6,,3,5,,6,4,7,4,4,5,6,3,6,9,3,6,4,4,6,4,,6,6,4,
   7,7,6,4,4,3,,,4,6,,3,,9,,6,8,6,,7,,,,,3,4,4,7,4,4,4,
   ,7,4,4,,,,3,7,8,8,5,5,6,5,,11,5,,5,5,3,,,5,6,5,6,
   8,6,7,,,,,3,9,6,5,,8,6,8,,7,14,6,,,,3,3,5,5,8,5,7,
   3,6,,,,5,,6,4,7,4,4,5,6,3,6,9,3,6,4,4,6,4,,6,6,4,
   7,7,6,4,4,3,,,4,6,,3,,9,,6,8,6,,7,,,,,3,4,4,7,4,4,4,
   ,7,4,4,,7,3,8,5,11,7,6,8,7,11,5,,3,5,5,,5,,5,9,8,,
   8,5,5,5,,,3,5,,6,,6,8,6,6,7,,,,,,5,5,3,3,6,,,,8,3,5,
   7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,3,4,4,
   4,3,4,7,7,4,3,4,3,3,4,3,3,4,4,5,9,7,6,6,,9,,3,4,
   8,4,,5,,7,11,7,6,5,,13,,3,3,3,4,7,4,4,3,7,5,9,5,3,
   4,4,4,3,5,5,7,3,3,3,4,4,4,3,3,3,5,5,5,5,4,3,3,,,
   3,3,11,5,,5,5,5,8,,4,4,,4,,3,4,3,3,6,4,3,5,9,3,4,
   4,4,4,4,3,8,6,8,4,3,4,4,4,4,3,3,4,6,12,6,6,5,10,,
   13,,3,4,,6,,7,6,6,,5,6,5,,,,3,4,3,4,13,4,4,6,7,6,7,
   5,4,4,4,4,4,7,3,4,4,3,4,4,,4,3,3,4,4,4,4,4,4,,,4,
   4,5,4,,4,4,4,7,5,7,7,,,,4,4,4,4,5,3,4,4,5,4,4,4,
   4,5,4,5,8,3,4,4,4,4,4,,4,5,3,5,6,5,3,4,4,7,,4,5,
   12,4,,5,11,5,10,10,6,6,,,,4,3,4,4,6,4,4,4,12,5,4,3,
   7,3,8,7,3,4,4,4,4,3,,4,10,4,7,18,7,5,13,,5,,3,8,8,
   3,,7,12,7,10,4,12,11,,14,,4,3,4,3,30,4,4,3,28,7,5,
   6,4,5,7,2,3,5,2,5,5,3,3,4,4,5,6,7,7,4,6,6,,2,4,
   6,4,,5,6,7,6,5,4,6,,5,,3,8,3,8,6,4,3,2,6,2,4,5,5,
   8,3,5,6,3,4,6,5,4,4,4,5,5,7,4,12,7,5,,4,3,6,3,,5,
   5,12,8,4,14,16,,9,,4,3,17,19,6,4,5,4,6,4,3,6,7,4,
   5,5,4,5,8,5,4,5,5,4,4,4,8,8,7,12,,4,5,6,5,,4,4,5,
   9,8,7,10,,10,,5,9,10,10,5,4,5,5,6,5,4,6,6,8,11,6,
   8,8,,9,9,11,6,7,6,7,7,,11,,6,8,7,8,,6,7,6,,8,,21,,
   16,,11,9,9,10,,7,7,7,,7,7,10,4,4,2,4,4,3,,3,3,4,4,
   4,3,3,,4,,2,3,5,3,,4,4,4,5,4,4,4,,4,,4,3,3,4,5,3,
   5,2,5,2,3,5,4,4,4,4,3,3,4,5,5,5,5,5,,,8,,3,4,6,5,
   ,5,5,5,6,5,,,,,,3,4,3,4,6,4,4,5,6,5,7,6,4,4,4,,,4,
   5,5,6,5,4,4,4,,,3,4,6,5,,5,6,5,6,5,,,,,,4,4,3,3,6,
   5,7,5,6,3,4,4,4,4,,3,3,3,4,4,4,4,4,2,,,2,3,5,3,,
   4,4,4,5,,4,4,,,,3,4,4,3,5,3,4,2,5,2,3,4,4,,,5,4,5,
   6,5,,5,,,,3,5,6,4,,5,6,5,6,7,7,6,,,,3,3,4,4,6,4,4,
   3,6,5,5,7,,,5,4,5,6,5,4,4,4,,,3,5,6,4,,5,6,5,6,7,
   6,7,,8,,4,3,4,3,6,7,6,5,6,5,4,4,3,3,5,5,5,5,,3,3,,
   ,3,3,6,5,,5,5,5,6,,,,,5,,3,,3,4,6,,3,5,6,3,,,4,4,4,
   4,,,5,,6,,3,4,6,4,,4,4,,6,6,,,,,,3,4,3,,5,4,4,3,5,5,
   5,,3,5,,5,,3,4,,,4,4,6,4,,5,6,5,,,5,5,,5,,4,,3,4,,3,
   4,4,6,4,4,5,5,5,5,3,,4,4,,4,4,6,4,,5,5,5,,5,6,6,,,
   ,4,3,,4,,3,5,4,6,4,4,3,4,4,7,7,,6,,4,5,,5,,4,4,4,
   8,7,8,7,,6,,6,8,8,5,6,4,5,5,5,7,4,6,,,,,,,4,6,5,5,,
   4,4,,9,9,8,,,6,,5,11,9,,6,4,5,5,5,7,4,6,7,7,,8,,4,
   5,5,5,,4,,4,8,7,7,8,,6,,5,8,8,6,6,5,7,7,5,5,4,5,
   4,4,5,,4,8,8,4,,7,9,7,,6,6,6,,10,,5,3,4,4,,4,5,4,,
   7,4,3,4,10,,4,4,8,8,,7,8,7,,5,,,,,,5,4,3,4,,4,,7,,4,
   4,4,8,,3,3,6,3,,,,6,7,4,,,,4,,,3,3,4,7,5,,7,6,3,3,3,
   ,5,,7,5,,6,8,6,,,10,10,,,,5,,,,,,7,5,7,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,4,,4,,4,4,4,,5,4,4,,5,,3,3,3,3,6,4,3,2,6,2,
   4,3,8,3,,5,,5,8,,6,6,,4,,4,,3,4,6,4,3,4,,4,3,5,8,,,
   6,6,,11,,9,,10,,,9,9,6,7,5,6,7,5,,6,,,5,5,5,,4,6,6,,,
   ,4,3,,4,6,4,5,4,,4,3,4,,,,,,,,,,,,,,,,,,,,,,,4,4,7,7,,7,
   ,8,,6,8,8,5,5,4,5,5,6,7,5,7,,8,,9,,,6,,5,11,9,,5,
   4,5,5,6,9,4,10,7,7,7,,,6,,5,8,8,6,5,4,6,7,6,5,4,5,
   ,8,8,,,,9,6,,9,9,8,8,,8,7,7,5,7,7,,,,5,15,4,5,,6,4,
   5,,6,,6,4,,,,9,,,9,7,5,5,6,8,7,9,7,,,,9,,,9,7,5,6,,
   8,4,6,5,,,,,,,,,,,,,,,,,,,5,7,,,,,5,,7,,,,,,,,,,,,,3,3,4,6,
   4,4,3,6,9,5,9,4,3,,4,4,3,,9,4,3,3,,4,3,9,,3,4,4,
   6,5,9,9,6,3,4,4,6,10,15,6,7,5,6,4,4,5,4,4,6,5,6,
   5,6,6,7,2,4,5,15,6,10,4,5,4,,4,4,5,4,,,4,3,4,4,4,
   4,4,6,9,12,3,4,6,4,4,6,3,4,3,6,6,,9,4,3,,,,4,4,7,
   6,,6,,7,,5,,,,,,4,4,3,,,4,4,7,7,4,4,4,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,3,4,9,
   4,4,4,12,4,3,4,4,6,6,5,,4,4,6,,6,3,4,7,,,3,6,,6,,9,
   ,7,4,3,,,,,,4,4,4,7,4,3,,,4,4,4,7,,4,,5,4,4,6,3,4,
   9,4,4,4,12,4,3,4,4,6,6,5,,4,4,6,,6,3,4,7,,,3,6,,6,
   ,9,,7,4,3,,,,,,4,4,4,7,4,3,,,4,4,4,7,,,,5,6,11,7,5,
   5,4,8,,5,8,,5,5,8,,7,5,4,5,8,,6,8,,7,,,3,,9,6,,8,,8,
   ,5,,,,,,7,5,5,8,5,5,6,8,5,,,,,,4,4,6,4,4,4,4,6,4,4,
   4,4,4,4,4,4,6,6,4,4,6,,4,4,4,4,,,4,4,4,4,,4,,6,6,
   6,,,,,,6,4,4,6,4,4,4,6,4,6,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,4,7,8,6,5,,5,11,5,5,3,4,,5,5,
   6,5,,,8,8,,8,,8,9,,,8,5,7,,,6,,8,5,7,,,,,,,,5,8,6,5,
   5,8,,7,5,5,4,4,4,4,4,3,4,4,4,3,3,3,4,4,4,4,4,3,
   4,4,4,4,4,,4,,,3,3,5,5,14,5,,8,4,4,,,4,,,3,4,4,5,4,
   4,4,14,5,3,7,4,4,3,3,4,4,4,4,3,3,4,5,3,4,5,3,4,
   3,3,4,3,5,3,3,5,,,4,4,9,5,,7,,10,6,6,,,9,,7,4,3,3,
   6,3,3,4,7,4,4,4,3,4,4,4,4,4,4,4,5,4,3,4,4,5,4,3,
   3,4,4,4,5,4,,6,,7,4,4,9,6,8,7,,7,4,4,4,,16,,,4,4,
   4,6,4,4,3,7,6,7,6,4,3,4,4,4,4,3,4,3,4,3,3,5,6,6,
   4,4,4,,7,3,3,9,,9,3,5,5,5,7,5,,10,4,3,3,,,,,4,4,3,
   7,4,3,3,6,3,4,3,4,4,4,4,4,3,4,4,6,3,4,12,10,5,4,
   4,4,,6,3,3,6,,13,4,6,6,12,14,6,,7,5,10,,,13,,14,4,4,
   3,13,4,3,4,13,9,4,4,9,4,4,3,4,10,4,4,4,4,7,13,5,
   3,4,3,,7,4,,18,,5,4,5,10,6,,5,,8,4,4,4,,,,15,4,4,4,
   30,3,4,3,6,8,5,7,6,4,4,4,3,3,3,4,4,5,4,4,3,4,4,,
   5,,4,5,,4,3,3,4,4,,4,,8,4,4,4,,,,14,3,7,4,14,4,4,4,
   5,4,3,4,5,4,4,4,3,4,4,4,6,4,4,4,4,4,4,7,,4,9,,16,
   5,3,6,5,,5,,7,3,4,4,,7,,8,7,6,4,7,3,4,4,6,4,4,4,
   6,4,4,3,5,4,4,6,4,4,4,4,3,4,5,,4,10,,,10,4,18,7,
   15,7,,8,5,13,,,5,,,5,7,4,6,3,4,3,30,6,4,4,8,9,3,4,
   3,4,10,4,4,3,4,4,2,10,,,26,,15,9,4,26,10,16,10,,9,4,
   4,2,,15,,16,5,9,3,,4,3,4,,9,5,9,9,3,3,4,5,5,3,,3,
   4,5,4,5,4,3,,,,3,3,,6,8,7,,7,4,4,,,4,,,3,4,3,,4,4,,
   7,6,3,4,7,3,4,4,4,4,4,2,4,4,2,4,3,,4,,,3,3,4,4,4,
   4,,4,3,3,,,4,,4,3,4,4,5,3,3,4,5,3,3,5,3,5,4,5,,3,
   3,5,4,4,5,4,5,5,,4,3,3,6,7,,6,,7,4,4,3,,4,,,3,5,,,
   4,4,3,7,10,3,4,4,4,5,,5,4,4,4,,5,3,3,5,,8,4,5,5,
   5,7,5,,4,5,,,,8,,7,4,4,3,6,4,3,4,6,4,4,4,4,5,5,,4,
   4,4,,5,,,6,,,4,5,6,5,4,5,,4,4,4,4,,,,7,4,4,4,6,4,3,
   3,6,3,5,7,4,7,7,4,5,5,,4,4,5,4,,6,6,7,7,6,8,6,,7,,
   ,5,,8,,,4,5,8,6,5,6,8,,6,5,4,5,4,3,4,4,4,7,5,3,,,
   10,4,4,,,10,,,8,5,,,,5,,,4,,3,,4,5,4,9,7,4,6,5,3,4,
   4,4,7,,,,,5,4,4,,,10,,,8,4,5,4,,,,,4,5,4,,4,5,3,9,7,
   5,7,9,4,4,,4,,3,4,,4,3,3,4,4,4,4,,4,4,4,2,,,,4,3,
   5,3,5,4,4,3,5,3,3,4,3,4,4,5,,,6,,,5,4,6,5,7,5,,4,,
   5,,,,,4,5,7,3,6,3,4,4,6,4,4,4,3,4,5,,,6,,,5,4,6,5,
   7,5,,4,4,4,4,,,,7,7,6,4,6,3,4,3,6,4,7,6,4,,,3,,,8,,
   3,6,5,,5,,6,4,,2,,8,,6,5,,3,7,4,,3,6,,,,,,5,,,8,7,6,
   7,6,14,6,,7,,,5,,9,,9,5,7,8,6,6,5,8,,7,5,4,5,3,4,,
   6,3,5,5,5,4,5,,4,,3,3,,,,7,4,4,3,5,,3,4,6,3,,3,4,5,
   ,,4,4,4,4,7,,,4,,5,,,6,,4,,3,3,6,4,3,,5,4,4,4,3,,,,
   6,7,7,14,7,,7,,,6,,,,,4,5,9,6,,5,11,7,8,5,4,5,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,4,4,,8,9,9,,8,,5,8,,,,,,7,,,,5,,8,7,,,,
   3,,5,,5,,7,,3,4,,,,8,3,4,4,7,,3,4,,7,3,4,6,5,5,,5,,
   7,3,,4,,4,,,3,4,4,7,3,,4,,4,3,5,10,4,,,,7,,,,,,,14,5,
   4,5,7,11,9,,6,5,4,5,8,,4,,7,7,7,,,6,,8,5,4,6,,8,8,
   5,6,5,4,5,6,9,,,,,6,,,,,7,7,,,,8,5,,,,,,,7,7,7,,,8,,14,
   5,4,5,,8,8,6,6,5,5,7,7,,,,,,,,,,,,,,,,,,,,,8,8,6,,8,,,6,
   6,7,6,7,7,7,6,,6,6,,4,4,,5,,10,5,7,5,9,3,4,4,,9,4,
   5,7,4,,10,,10,4,6,5,9,4,3,4,,5,4,,7,,8,,,,,,6,3,3,4,
   7,,5,,,,,,,,,,,,,,,,,,,9,,,5,8,,,,,,,7,7,,,,,,,,,,,,,,,,8,,5,,,,
   ,7,7,,4,4,6,5,4,4,6,5,3,6,4,3,10,9,4,4,5,4,6,4,3,
   ,3,3,4,6,24,4,4,6,6,6,,6,7,6,5,7,4,3,,21,4,4,4,3,
   ,6,4,3,24,6,4,5,9,21,7,6,10,7,4,3,5,4,5,4,5,6,6,
   5,,,8,4,5,8,5,13,13,9,8,8,4,5,8,5,5,,4,5,4,8,,,12,
   5,4,,,,9,6,6,,5,8,10,,,10,9,,,,,5,5,,,,5,5,9,9,5,5,5,
   4,,3,,,6,4,7,4,4,6,6,7,5,9,4,6,6,4,4,4,6,8,6,6,7,
   ,9,4,4,,,,3,4,3,4,,6,7,6,6,,7,,,,,7,4,4,4,4,4,7,4,
   4,,3,,6,4,6,6,4,4,4,4,2,8,4,4,8,4,4,4,4,4,4,4,4,
   6,4,4,4,,6,4,4,,6,6,4,4,,4,6,6,,4,6,4,,,6,6,6,4,4,
   4,4,4,4,4,4,4,4,4,4,,,,5,,5,,5,4,8,9,,16,9,,8,5,6,,
   8,5,,8,,,12,10,,,,5,4,5,5,5,,8,,,,10,6,,,,,9,5,5,5,5,
   5,9,5,5,,,,,,6,4,7,4,4,6,6,7,5,9,4,6,6,4,4,4,6,8,
   6,6,7,,9,4,4,,,,3,4,3,4,,6,7,6,6,,7,,,,,7,4,4,4,4,
   4,7,4,4,,3,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,
   6,,,,6,9,6,6,9,,,,,,,,6,3,12,,,,,6,6,12,,,6,9,9,,,6,,9,,
   ,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,6,3,12,,,,
   ,6,6,12,4,4,4,4,4,4,6,7,7,5,3,5,4,4,4,4,4,4,6,6,
   ,9,7,6,,9,4,4,3,10,6,17,6,7,9,,7,5,,,9,,3,4,4,3,9,
   4,3,10,10,6,10,9,4,4,4,4,4,7,7,6,3,4,6,4,4,8,3,4,
   3,6,8,,8,4,3,,8,8,4,4,4,4,,4,4,4,7,7,4,,,6,6,4,4,
   3,6,6,4,4,4,4,4,4,7,4,2,4,3,4,4,4,7,4,6,4,2,7,4,
   3,4,4,4,,12,5,,,5,5,3,3,5,4,5,4,4,6,9,3,3,,8,8,9,
   4,4,4,7,4,4,4,4,4,6,6,7,4,4,5,5,4,5,4,4,6,3,4,6,
   6,7,5,5,4,,9,4,4,,4,9,4,4,4,4,13,3,5,10,12,5,4,,,,,
   4,3,4,9,3,3,4,4,4,5,4,4,4,7,6,7,8,4,4,4,4,2,4,,
   5,7,6,7,,12,3,4,,5,5,3,3,3,3,5,3,4,3,9,5,4,,6,8,
   8,4,4,4,4,7,4,4,3,3,7,4,4,5,5,4,5,5,4,5,4,4,3,7,
   5,5,5,3,,9,5,7,,5,5,4,7,10,8,,6,8,7,6,4,5,,,15,15,
   4,4,4,4,4,4,4,8,8,6,8,7,5,7,5,3,4,6,5,4,8,4,3,4,
   5,4,,9,8,3,,20,9,3,4,3,3,8,4,4,9,,5,8,,,,,4,9,4,9,
   4,9,4,3,3,3,5,6,7,4,7,5,6,5,4,7,,6,5,4,5,,6,7,,,
   9,10,5,4,5,5,9,4,7,6,6,5,5,,6,6,6,7,7,5,6,5,7,7,
   6,6,5,5,7,7,7,6,6,6,6,6,,11,7,6,4,,8,5,,,,,5,7,8,
   4,13,5,6,8,6,7,12,,,,,7,4,9,10,7,4,7,8,8,5,4,8,8,
   5,8,5,4,7,,6,5,4,5,,18,6,,,10,9,6,4,5,6,9,4,8,7,,
   5,5,,9,8,11,6,7,5,11,5,7,6,7,7,8,8,6,5,5,4,4,4,3,
   ,3,6,8,,8,4,3,,5,,3,3,4,4,5,4,4,4,6,4,,,8,,,,4,3,
   4,6,4,,4,4,3,4,7,5,4,4,4,4,4,4,5,5,,8,5,,,5,,4,3,
   5,4,5,4,4,4,6,4,,,,,,3,4,4,3,5,4,3,4,4,6,7,6,5,4,
   5,,5,6,6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,5,5,
   6,6,5,5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,4,4,,,5,
   4,4,4,4,5,3,5,4,6,,4,,8,,8,4,3,4,5,3,3,4,4,4,5,4,
   3,4,4,,4,4,4,,6,,4,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,
   6,6,4,4,4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,
   4,4,5,3,5,4,6,,4,,,8,,4,,5,4,9,,4,4,4,6,3,4,4,3,,,,,
   ,3,,,5,4,4,4,4,5,3,4,,,,4,,,,,4,,3,,,,4,4,4,4,6,,4,6,
   ,,8,,,,7,,3,3,4,4,5,4,4,4,6,5,5,,,,,4,5,4,,8,5,4,4,
   4,5,7,8,5,4,,8,,3,,,5,4,4,4,4,5,3,4,4,7,7,4,,,6,,4,
   ,3,6,4,,4,4,4,4,5,9,5,,6,5,,,8,8,5,4,5,5,8,4,6,6,
   ,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,5,5,6,,8,5,,,5,,4,
   3,5,4,5,4,4,4,7,4,7,,,,8,,4,5,9,4,4,,4,4,7,6,6,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,8,6,8,8,12,6,8,8,,8,
   8,,8,8,8,9,9,8,8,8,9,9,9,9,8,8,8,4,,,7,4,4,4,4,5,
   3,4,4,7,6,5,,,9,9,5,4,4,8,,4,5,4,4,5,4,4,,5,,3,3,
   4,4,5,4,4,,,4,,,,,,,4,3,,,4,,4,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,6,5,6,5,5,6,4,7,5,9,5,5,,,,,5,,,,,,5,5,5,,,,5,
   4,7,5,6,6,5,5,9,5,5,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,
   5,5,,,3,8,4,4,4,6,7,4,4,,,3,3,6,4,4,6,3,,4,6,,3,,
   6,6,6,3,4,4,4,4,4,3,4,4,4,4,4,4,,,4,,,5,,,,6,,5,4,
   7,7,8,4,5,4,4,3,3,8,,4,4,5,,5,5,,5,,,4,4,7,6,6,4,
   4,3,3,3,4,5,6,,,,7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,
   6,6,4,3,6,6,6,3,4,4,4,6,6,6,,,,5,,,,,4,5,6,,,5,4,4,
   4,4,8,8,,5,5,,8,,,4,4,6,7,6,4,4,,,6,5,4,7,7,,6,5,
   6,7,7,6,11,13,7,7,,,6,5,6,4,,,,9,4,7,5,4,5,7,4,5,5,
   ,,5,,12,,,7,4,,5,,4,7,5,5,7,8,7,,,,,,,,,,,,,,,,5,8,,,6,,,
   ,,,,,,6,5,,,,,6,,,,,3,,6,,,,,6,,,,,,6,,4,4,7,6,4,3,4,4,
   7,13,9,4,6,7,3,4,4,4,6,4,7,5,5,4,4,13,13,4,4,4,8,
   6,7,7,7,4,4,4,7,6,9,9,4,4,4,4,4,4,6,4,7,4,4,7,
   13,9,3,3,4,6,3,4,6,5,8,5,,,5,,,3,5,8,3,11,7,3,3,7,
   11,3,5,5,5,9,6,7,6,3,5,8,,6,5,5,,,,3,3,5,,,8,,6,3,
   3,,8,,,,3,5,,,,3,6,3,7,3,5,8,3,,,,3,9,6,,9,,,3,,9,3,,
   6,6,6,,9,6,,6,6,,6,3,,,3,,3,6,,,,9,,6,3,,,9,,,,3,6,,,,
   6,12,3,12,,,,,,,3,9,6,,9,,,3,,9,3,,6,6,6,,9,6,,6,6,,
   6,3,,,3,,3,6,,,,9,,6,3,,,9,,,,3,6,,,,6,12,3,12,,,,,,8,
   5,10,6,,8,10,5,8,10,3,6,5,5,,4,8,,,5,8,,6,3,5,,,,8,
   8,,,,8,10,8,10,11,11,10,,,,8,5,,,,5,5,7,6,8,5,5,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,7,2,,,3,3,8,8,2,8,8,5,5,
   4,8,5,2,5,5,,4,3,,,3,8,3,3,8,,,8,8,,3,3,,6,,,,2,5,,,
   ,2,,3,8,3,,3,7,7,7,,,9,9,6,4,5,6,5,5,6,4,5,4,6,6,
   ,6,5,4,,10,10,8,12,6,,,6,7,15,13,8,,,,,,5,5,,,,5,5,7,
   8,5,5,5,,6,,5,7,9,7,,8,5,6,8,6,5,6,5,7,,,7,9,12,,
   22,5,7,6,8,,6,6,5,5,12,8,5,7,,,,7,6,,,,6,17,5,20,,,,
   7,,3,3,8,7,2,5,5,8,5,5,,3,2,8,4,,4,5,8,,8,3,3,3,5,
   ,6,5,6,5,3,3,,,,,,2,,,,,2,5,3,5,3,5,5,,,6,,7,5,6,7,
   8,8,,12,9,,5,6,,7,6,5,,5,22,8,6,7,,19,7,10,10,13,8,
   17,20,,,,6,17,,,,7,6,8,8,,8,7,9,4,,9,,9,11,9,3,5,9,4,
   ,11,5,,5,4,9,,3,3,4,10,10,,13,11,13,11,4,16,13,19,,,,
   7,7,,,,7,7,4,16,8,8,7,3,,9,3,4,4,9,8,20,16,4,3,9,7,
   ,11,7,,,11,4,3,3,4,,5,4,4,9,3,3,5,,,,,3,12,,,,3,4,3,
   12,3,9,10,9,7,3,12,7,5,4,,9,4,3,5,9,,11,3,,,3,4,3,
   3,13,,,8,8,,3,3,7,10,,,,3,5,,,,3,11,3,13,3,5,10,8,,
   15,10,8,9,15,,10,,8,11,,16,8,16,,,,8,18,15,,21,10,,21,
   15,13,,12,,,,9,7,,,,6,55,,86,7,6,10,,6,6,9,8,16,,9,,6,
   6,,10,7,,,9,11,6,8,7,,,6,7,10,16,7,7,12,,,,7,7,,,,9,
   6,6,20,10,10,10,4,4,4,,,4,,2,4,,,,3,4,,3,,3,3,4,,5,,
   4,,3,3,,,,,,2,4,,,,2,,3,5,3,3,,4,5,5,6,5,5,4,6,6,,6,
   5,,,8,,6,5,4,,5,,4,,8,7,,,,,,4,5,,,,5,5,4,6,4,8,5,6,
   5,6,,4,4,6,6,,6,5,,,8,5,6,5,4,,5,4,4,,8,7,5,,,,,4,6,
   ,,,5,4,4,7,4,5,5,5,6,,5,4,4,6,,6,5,5,,,8,,,6,,6,6,
   7,6,,,7,8,,,,5,5,,,,4,5,7,14,5,5,5,,7,,,5,,,6,,7,,3,
   3,4,5,6,,6,5,6,5,4,8,8,8,,,,5,5,,,,5,5,4,6,,5,,8,5,
   ,6,,,,,8,,,8,5,5,7,,6,6,7,5,5,9,7,9,,,,17,6,,,,7,5,
   7,7,7,5,5,5,4,,8,,8,7,4,,,11,,,6,,5,,,,,,,,,,,5,,,,,7,5,
   ,,5,8,7,3,5,,,5,,7,,4,3,4,4,6,,5,4,4,4,4,4,6,6,,,,
   5,5,,,,3,4,4,6,,5,6,4,,,,,4,,,3,3,3,4,,5,4,4,4,3,3,
   5,6,,,,2,,,,,2,4,3,,3,3,,6,,6,4,,,5,8,,6,7,,,6,7,6,,,
   7,8,,,,5,4,,,,4,6,7,15,5,5,4,,,5,8,,8,,6,5,7,,12,6,
   7,6,9,7,9,10,,,,7,5,,,,17,6,4,7,8,5,7,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,5,8,,10,10,6,5,7,,12,6,7,6,10,7,7,10,,,,
   11,6,,,,11,6,7,8,5,4,5,5,,3,4,3,5,5,,6,5,6,5,3,7,
   7,8,,,,3,4,,,,5,5,3,5,5,5,,,11,,,6,,,5,,,,,,,,,,,7,5,,,,
   5,,,,5,5,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,3,,9,,,8,11,8,3,,
   9,15,,,,3,,,,,,8,3,9,,,,4,4,,,6,6,5,14,4,4,5,13,,,,,8,,,
   ,3,,4,14,,,,3,,,,6,,6,3,3,7,8,,,,3,10,,,,3,6,3,9,3,7,
   5,5,,,5,,5,3,3,6,7,,,,3,11,,,,3,5,3,11,3,,5,,,,4,,,,,,,,
   ,4,6,,,,5,6,4,,4,10,7,,,,,,,,,,,,,,,,,,,,,,,,6,6,,,,7,,,,,
   5,6,,,,6,5,,,,,,4,,8,7,,,,,,8,6,,,,5,4,4,8,6,10,10,,,,5,
   ,,,,4,7,,,,6,4,4,,4,10,10,8,7,,,,,,5,9,,,,5,4,9,12,5,
   7,5,3,9,10,,,,3,,,,,3,11,3,11,3,9,5,8,9,,,,3,10,,,,3,
   7,3,10,3,,7,,,,,,7,,,,6,14,5,9,7,,,,,,17,11,,,,9,9,,14,
   6,9,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,,,2,5,3,8,3,6,
   5,,,,5,5,7,11,5,5,4,,,,,,,,,,,,,,,,,,,,,,,,,5,3,11,3,3,11,
   4,5,6,8,7,9,3,7,7,8,5,7,5,5,5,,4,,5,4,4,6,3,4,9,
   4,4,4,12,4,3,4,4,6,6,5,,4,4,6,,6,3,4,7,,,3,6,,6,,9,
   ,7,4,3,,,,,,4,4,4,7,4,3,,,4,4,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,4,7,4,4,6,6,7,5,9,4,6,
   6,4,4,4,6,8,6,6,7,,9,4,4,,,,3,4,3,4,,6,7,6,6,,7,,,,
   ,7,4,4,4,4,4,7,4,4,,3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,6,8,11,7,5,,3,8,5,11,3,6,9,5,5,8,7,,,,
   6,14,8,,7,6,,,4,5,,3,,6,5,8,5,,8,6,,,,,,5,7,7,5,8,3,
   ,5,3,6,4,4,3,5,5,2,3,7,7,2,4,4,4,4,4,7,5,3,5,5,
   3,5,4,7,6,5,,2,3,6,5,,7,6,7,2,3,6,6,3,6,,2,4,4,4,
   3,3,6,2,5,2,8,6,4,4,4,4,4,4,4,7,4,4,4,3,4,4,5,7,
   4,4,4,7,4,4,4,5,,,3,4,4,4,,4,7,4,6,,4,4,,,,4,4,3,
   4,4,4,5,4,4,4,4,5,5,4,5,4,8,6,8,4,4,4,4,4,3,8,8,
   5,4,5,14,5,12,7,6,9,,3,6,7,6,,7,16,12,4,5,5,5,,,,4,
   4,4,4,5,17,6,19,6,19,7,6,4,5,3,3,4,7,3,3,3,4,5,5,
   ,6,3,4,5,3,5,3,4,11,4,,3,3,3,4,3,5,3,5,3,3,5,5,6,
   ,,3,4,4,5,3,3,6,3,4,3,4,9,5,4,4,4,8,4,5,5,4,3,4,
   10,10,4,4,5,6,5,4,3,12,,,3,4,4,4,,5,6,5,4,,6,11,,,,
   5,4,4,4,4,4,6,4,3,4,3,12,7,6,8,7,4,5,5,4,5,5,8,
   9,5,5,4,7,4,8,8,6,10,,4,5,7,8,,4,10,5,4,5,4,4,,12,
   ,5,4,4,5,5,10,5,10,6,5,9,6,3,4,7,2,4,4,2,4,4,7,
   7,3,3,5,6,5,6,6,8,13,,2,3,2,3,2,7,3,7,2,3,9,,,9,,
   2,9,4,9,4,3,7,2,3,2,3,7,4,8,3,4,4,4,6,6,5,9,3,4,
   12,6,7,10,5,,,,3,3,3,4,3,6,3,6,3,3,6,6,,13,,3,7,4,
   6,4,3,13,3,4,3,4,7,7,3,10,8,4,8,6,4,11,4,4,7,4,7,
   13,5,8,14,,3,4,,3,4,7,4,7,4,,18,12,3,11,,7,5,4,5,4,
   4,30,3,6,4,3,28,6,9,8,6,11,8,8,,8,8,6,10,6,7,7,7,
   16,,6,8,,8,,6,10,6,9,,7,7,,11,,7,7,7,7,7,9,,10,10,
   11,9,,4,4,2,4,4,5,,3,3,4,3,4,4,4,,5,,2,3,3,3,3,4,
   3,4,2,3,4,4,3,5,,2,4,4,3,3,3,6,2,3,2,3,6,4,4,4,4,
   ,,4,5,5,5,5,3,,6,5,,3,4,4,5,,5,5,5,4,3,,6,,,,4,4,
   4,4,4,3,,4,5,4,,6,4,4,4,,8,4,5,5,6,5,4,8,8,4,,3,
   4,3,5,,5,6,5,4,3,6,,,,,4,4,4,4,3,3,6,4,5,4,,,4,4,,
   5,4,4,4,4,4,4,4,5,,,2,4,2,4,3,4,4,4,3,,4,4,3,,,4,
   3,3,4,4,4,5,2,4,2,4,5,4,8,,5,4,5,6,5,,,6,,,3,5,4,
   4,,5,6,5,4,5,5,5,,,,4,4,4,4,5,,,4,3,4,7,6,,,5,4,5,
   6,5,8,6,8,,,3,5,4,4,,5,6,5,4,5,5,5,,8,,4,4,4,4,5,,
   6,4,4,4,7,,,5,7,7,7,7,5,6,11,,,4,5,4,7,,7,7,7,6,,9,
   ,,,,8,,6,7,4,4,,5,6,5,15,,6,4,7,7,6,,,,,,4,6,6,4,,7,
   7,6,4,6,9,8,,,,6,7,8,,8,,9,5,4,5,11,8,4,5,,5,,5,6,,
   ,3,3,3,4,3,5,3,5,3,3,5,5,,8,,3,7,4,5,4,3,6,3,4,
   3,4,6,5,7,5,5,,6,,,3,4,3,3,4,5,4,5,,,6,6,,,,5,5,4,
   3,4,4,6,3,3,3,3,6,7,4,7,7,,6,,4,5,,5,,4,6,4,4,5,
   4,4,,6,,7,4,4,5,5,8,6,5,6,6,8,5,,,6,,,,3,3,,4,4,6,
   3,6,,3,8,9,,10,,7,9,5,6,3,3,7,3,7,9,4,8,7,7,,8,,4,
   5,,5,,4,6,4,4,5,4,4,,6,,7,5,4,5,5,8,5,5,7,6,8,6,
   4,8,,,3,4,4,4,,7,,7,5,3,,8,,10,,4,4,4,7,,3,,4,4,5,4,
   ,8,10,,3,4,4,4,,7,6,7,,,,9,,12,,7,4,4,5,5,4,,4,3,5,
   3,,10,,5,6,6,6,,5,8,6,5,6,5,6,,7,,,6,5,7,6,9,7,6,,,
   9,5,,4,,4,8,,6,,6,,5,6,6,,,,5,,,,,,7,5,7,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,3,,3,,4,3,4,2,3,4,4,,4,,2,3,3,3,5,3,5,2,
   5,2,3,5,4,4,,5,,5,3,3,6,6,4,,,3,4,5,5,3,3,6,3,4,
   3,4,6,4,3,,3,6,,3,,,,8,,3,3,5,7,,3,7,4,3,2,3,6,,5,
   7,5,4,,6,6,3,,,5,4,7,3,4,4,6,3,4,3,3,6,,3,,,3,,,,,,
   3,,,,,3,,,,2,4,,7,4,,5,,,,8,,5,4,5,7,7,8,6,6,5,5,8,5,
   ,,,,,4,10,,3,6,5,,6,3,7,9,4,3,4,8,,5,,,,6,,5,4,4,7,
   6,8,5,6,5,5,8,6,3,4,4,,6,,2,7,4,3,4,3,5,2,,2,4,5,
   5,5,4,,,3,,,5,3,3,6,3,,3,,6,4,,,,7,4,,5,5,9,6,,6,5,
   11,5,,8,,9,4,4,5,5,9,5,,10,5,11,6,,,,,,,,4,,2,,,3,,,,,,
   7,7,,,,,8,,11,,,,,,,,,,,,,4,4,4,5,3,7,2,5,2,9,15,4,4,
   6,4,5,4,4,5,4,6,4,4,4,6,5,6,4,4,5,5,9,15,5,5,4,
   6,7,3,10,3,6,4,4,6,,3,4,3,4,,6,6,6,,6,4,2,3,6,3,
   3,10,3,6,,,,,3,9,6,,9,,,3,,9,3,,6,6,6,,9,6,,6,6,,6,3,
   ,,3,,3,6,,,,9,,6,3,,,9,,,,3,6,,,,6,12,3,12,,,,5,,6,4,
   7,4,4,5,6,3,6,9,3,6,4,4,6,4,,6,6,4,7,7,6,4,4,3,,,
   4,6,,3,,9,,6,8,6,,7,,,,,3,4,4,7,4,4,4,,7,4,4,6,13,
   8,9,4,5,8,8,5,13,8,9,4,6,5,8,,10,,5,5,,9,8,4,5,6,,
   ,4,8,,,,12,,,5,4,,10,,,5,5,5,5,9,5,,,,5,5,5,9,8,,9,,
   5,,5,5,4,16,4,,5,5,8,5,10,,,6,,6,8,,10,5,,,9,8,,4,,
   12,,,5,8,,,5,,,,,5,5,9,5,5,5,,9,5,5,5,5,4,7,7,4,3,
   5,5,3,4,4,5,5,3,5,,4,4,4,8,4,3,8,3,3,,3,6,,8,,9,,
   9,3,4,,4,9,20,8,3,5,9,3,4,4,4,3,6,4,9,3,5,4,4,4,
   4,4,4,5,4,5,4,3,5,4,5,12,4,4,4,4,3,4,4,4,,,4,6,,6,
   ,9,,10,7,6,,5,9,4,13,5,4,3,4,4,4,3,9,4,4,3,4,7,6,
   7,6,4,5,4,5,5,4,5,4,5,5,6,5,4,5,5,4,,7,5,6,6,7,6,
   ,7,6,6,,6,6,,,7,10,9,9,5,5,7,6,7,5,5,6,7,7,7,6,4,
   7,4,4,4,6,4,3,4,4,6,4,7,7,4,4,8,4,4,3,4,4,6,,3,6,
   ,8,6,8,,4,4,3,,4,8,8,,4,4,4,4,4,3,6,6,7,4,4,4,7,
   4,2,4,8,3,7,3,4,6,3,5,9,4,2,7,4,3,4,3,3,8,6,4,4,
   ,4,8,12,,3,5,,,4,5,5,5,7,4,4,3,4,4,7,4,4,4,4,3,7,
   4,4,7,5,7,7,6,6,4,7,6,6,6,4,12,5,,5,8,,6,7,6,,4,,
   8,,8,11,,,6,,,13,5,4,4,8,7,9,7,10,8,7,4,8,4,4,7,4,
   4,3,4,6,6,7,,3,4,6,5,6,6,7,10,9,,5,5,,4,,9,,9,4,4,
   ,7,4,9,17,6,10,4,10,3,4,9,3,9,3,4,10,4,4,3,4,3,4,
   4,4,3,9,4,2,4,3,4,3,5,5,3,3,3,6,,3,9,12,,6,3,4,,
   4,5,5,5,3,3,4,4,4,4,4,3,7,4,4,4,5,4,5,7,4,5,8,4,
   6,4,4,3,5,6,7,5,10,15,,5,5,,3,8,9,,7,5,7,,8,5,5,,
   6,8,4,8,4,4,4,4,7,4,4,8,6,5,4,5,4,6,5,,5,4,5,5,4,
   ,6,5,8,9,8,8,,7,11,18,,7,6,,,8,9,10,9,8,8,7,7,6,5,
   5,11,6,6,7,7,4,4,4,5,5,5,,4,3,4,5,4,3,4,,3,,3,6,,
   3,8,8,,8,3,4,,,5,5,,3,3,4,,4,4,7,3,6,4,4,,4,5,5,4,
   7,7,4,4,4,4,3,3,,4,6,,3,6,,8,,8,,4,4,3,,4,5,,5,4,5,
   ,4,4,3,4,6,9,4,,4,4,4,4,,6,3,3,3,3,3,3,4,4,6,6,
   3,4,,4,6,6,,4,3,4,,,4,6,6,4,4,4,4,3,4,4,4,4,3,4,
   4,5,4,,6,4,4,4,4,3,4,4,4,,8,4,5,,5,8,8,,4,5,,,5,5,
   ,5,5,4,3,4,4,4,3,5,3,4,3,4,5,5,,5,4,5,5,4,,5,5,
   5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,5,5,6,6,6,5,5,6,6,
   6,6,6,5,,4,3,4,5,4,4,4,4,,5,4,5,,4,,8,,5,4,4,,4,5,
   5,,3,4,4,3,4,7,6,6,5,4,4,3,7,4,4,4,4,3,4,6,5,,,4,
   5,,,9,8,,5,5,,,,5,5,7,,,7,5,4,5,5,4,5,4,7,5,6,5,7,
   7,6,,7,,5,6,6,,,6,6,,,,6,,,,9,9,,6,5,7,,7,6,13,11,6,
   7,7,,4,5,,4,,5,5,,,5,5,,4,5,8,,4,4,4,,4,,5,5,6,7,4,
   4,3,4,5,3,6,3,4,4,4,4,3,4,,3,6,6,4,4,,4,6,6,,3,,4,
   ,3,6,6,4,4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,6,,
   4,8,8,,4,,,,4,,5,5,7,6,4,4,,5,4,6,6,,4,4,,,5,,,12,,5,
   ,4,,8,,5,5,4,,5,5,5,7,7,8,4,5,7,,,5,7,7,4,5,4,3,,
   6,6,4,4,,3,6,6,,4,4,3,,4,6,4,6,6,6,3,4,4,6,6,6,6,
   4,3,4,4,4,3,,3,,,4,,,,,3,3,,4,,5,5,3,4,4,4,,3,,3,,,
   4,4,4,9,,4,6,,,9,8,,4,,,,4,7,,5,5,4,4,4,5,4,,8,4,5,
   4,4,6,,4,6,,3,,8,,,4,4,,4,7,5,,3,3,4,4,5,7,8,7,8,
   5,4,4,5,3,5,,6,5,8,,,3,,,,,,,3,,,,,,6,3,6,,,,8,6,,,8,8,
   ,8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,3,3,,4,,5,5,3,4,4,4,
   ,3,6,3,7,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,5,6,6,6,5,
   6,5,5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,5,5,,5,6,3,,
   4,4,5,9,4,4,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,
   12,12,8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,
   5,5,,6,5,4,,4,6,6,7,4,4,4,,4,,4,,7,5,3,7,5,4,4,4,
   8,3,8,4,5,4,,4,5,,5,4,6,,4,4,3,,,,4,,4,,,,,,,,,,,,,,,,,
   5,7,,4,8,5,4,4,6,,,8,4,5,4,6,6,,,5,5,,,,,,,5,5,6,,,,
   5,5,,,,,5,,5,,,5,,5,,,,,5,5,,5,6,3,7,4,4,3,8,7,6,3,
   4,4,13,4,4,4,5,13,4,4,4,4,4,7,6,7,4,3,4,4,13,9,7,
   6,4,4,3,4,6,3,9,3,4,4,5,5,4,4,4,13,8,4,6,7,9,4,
   3,6,7,9,7,6,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,4,,3,,,3,,
   5,5,3,,7,5,8,4,9,7,,3,,,3,5,3,,,4,,,,,3,5,,,,,,3,3,5,
   5,,5,,3,,,,,,9,9,7,8,,,10,9,,9,,9,,,,10,13,15,18,15,13,
   ,17,,10,5,9,9,6,,14,12,18,,13,6,,,,,27,7,5,9,11,10,5,
   ,5,,,,7,6,7,7,8,,8,9,,5,5,7,,7,6,7,7,12,16,7,9,,15,
   128,6,,5,9,5,20,8,7,5,,7,6,,,,,8,5,8,11,,5,9,5,5,,,,
   9,7,,,,10,12,,8,7,9,,6,8,8,22,12,,8,12,,18,,10,6,7,
   10,9,20,22,9,7,,8,18,13,,,,,8,8,7,6,6,22,7,10,,,,4,,5,
   ,6,7,,7,5,5,,,5,6,4,10,,7,8,,,9,5,4,5,7,4,21,4,7,
   14,,9,6,19,,,,4,5,5,8,8,5,14,4,4,,,,4,5,,4,6,,6,5,5,
   ,7,5,5,4,4,,6,7,,9,15,5,4,5,,4,,,7,6,,7,,9,,,,4,5,
   5,4,5,5,10,4,6,,,,,,4,5,,6,6,5,,,7,4,6,5,12,5,,,7,7,,
   ,,4,,8,6,5,,,7,,,,,,7,,4,,5,6,5,6,5,,,,,8,3,,7,10,5,,
   12,11,9,5,8,,11,3,,17,3,63,3,3,3,5,3,5,10,,3,9,,10,,,
   ,3,5,,,8,11,8,3,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,10,,12,6,5,,16,7,5,6,5,8,8,11,,,39,6,,6,5,8,9,6,
   10,10,,,9,24,,,,7,6,5,5,5,6,14,8,6,,,,,,,,,,,5,6,6,7,
   6,3,,,3,,3,4,4,6,4,6,6,6,3,,9,9,,,,3,7,7,5,5,10,9,
   3,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,6,6,6,8,
   6,,,,5,,4,5,5,6,8,6,7,6,,4,7,,,,,7,7,5,5,4,4,15,5,6,
   ,,,,,,5,6,6,6,8,6,,,,,6,4,5,5,5,8,6,7,6,,,6,,,,,7,4,
   5,7,5,5,14,5,5,,,,,,,5,5,5,7,5,,,,,,3,5,4,5,4,5,6,5,
   ,8,8,6,,,,3,3,,,5,11,11,3,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,8,10,10,10,8,,,,,23,6,7,8,9,11,10,9,8,,,11,,,,,,
   ,8,9,6,6,17,7,8,,,,7,7,9,9,7,,,,,,5,6,7,6,9,8,8,7,,,
   ,,,,,7,5,5,,7,5,17,6,6,,,,6,5,,,,,,,6,,,4,6,8,6,5,,,,7,
   ,,,,7,7,5,7,5,6,7,17,5,,,,,10,6,7,,8,8,5,4,5,5,4,5,
   4,7,6,,7,,8,,,,4,5,5,4,5,6,7,4,4,,,,9,6,7,,8,8,,,5,
   5,,14,,6,6,,7,,8,,,,9,5,7,5,5,9,12,5,4,,,,,,,,,13,,,6,
   10,,10,,,,,12,,,,,9,9,6,9,8,,10,,52,,,,7,,,10,12,,6,4,6,
   10,6,,,,7,7,,,,,7,11,4,5,5,6,8,11,6,,,,,,3,,3,4,4,7,
   4,7,,7,3,,10,10,,,,3,,7,7,,,10,3,7,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,15,,4,6,4,8,,8,,4,4,,11,,,,,4,,7,5,7,,11,5,13,,,,
   ,3,3,3,8,3,8,,8,3,6,9,,,,,3,,,,,,9,3,8,,,,5,6,7,5,6,
   6,7,12,,,6,21,,,,,6,,,,6,,5,5,,,,,,4,,,,,2,4,,4,,,,3,3,
   3,3,,4,5,2,,,,,4,5,3,5,,,,,6,,,,,4,5,5,,,5,6,5,5,,,,,4,
   ,6,4,,6,,7,,,,4,4,,6,6,5,7,12,9,,,,,,9,6,,7,5,8,,,,4,
   5,8,4,5,5,6,4,5,,,,6,,,,11,,,,,,4,4,,,,8,14,,,,,,8,6,,7,
   ,8,,,,4,5,10,6,10,6,8,8,4,,,,,,,11,,,,,8,8,7,,,7,8,,5,,
   ,,,7,7,,,,,4,17,5,8,7,5,7,7,6,,,,,,,,,,3,,,3,,,,2,,,,,8,,
   ,,,8,,7,7,,4,16,6,7,,,,9,,,,,6,,8,,6,7,5,6,,,,,,,9,,5,
   5,5,5,9,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,7,3,7,
   7,9,3,4,,,,3,7,11,5,11,3,5,,,,5,5,5,5,6,8,,,,5,5,8,
   6,6,,,,4,7,5,7,,,,11,5,5,,,,8,5,,,,5,,,,,,,,,,,10,6,5,5,
   ,8,8,10,8,10,8,,8,5,5,,11,10,6,,8,11,8,5,3,,,,3,5,,
   4,,6,10,8,,8,,10,,,,8,5,5,7,5,,,,5,8,5,6,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,5,5,5,5,6,5,5,5,4,
   5,5,5,4,7,5,7,8,8,8,7,10,10,8,,7,6,5,8,4,,5,9,8,
   5,16,5,,,,,5,10,5,4,5,4,5,5,5,18,10,9,8,4,4,6,5,6,
   6,7,4,7,4,4,8,4,,16,5,5,6,9,6,4,4,4,,12,4,3,4,3,,
   7,12,4,8,7,8,8,,,17,27,3,3,4,5,4,5,4,3,6,4,4,6,4,
   6,6,7,4,7,5,7,6,8,4,5,7,7,7,6,8,13,6,10,7,15,,,5,
   6,16,6,,6,8,6,11,10,,6,,,,7,17,7,5,10,8,10,7,20,14,
   4,14,4,6,8,8,6,7,4,5,3,4,5,3,7,8,7,8,6,8,7,4,4,4,
   ,,4,4,4,4,17,6,8,4,16,,9,12,12,,,6,4,4,4,5,3,5,4,
   4,27,3,3,5,5,4,5,5,3,5,4,4,3,3,9,5,5,3,6,6,5,4,
   4,4,,7,3,4,4,3,12,5,9,4,5,9,6,9,15,,12,6,4,4,3,5,
   4,5,3,4,6,4,4,5,4,3,5,4,5,3,3,4,3,6,5,8,7,8,6,7,
   7,9,8,,4,7,6,9,3,,6,5,6,5,10,6,6,,,15,6,6,3,3,6,4,
   3,5,8,6,5,7,8,5,5,6,7,5,5,8,4,16,5,4,5,8,5,5,10,
   10,8,,,5,5,8,4,11,7,,8,5,7,8,9,7,,,18,10,4,7,5,5,5,
   4,9,5,10,5,6,7,3,7,6,8,6,6,10,11,7,4,8,,6,4,10,16,,
   ,4,3,4,3,5,6,5,6,7,7,13,8,,,,14,3,8,6,10,7,10,4,3,
   7,17,20,5,7,8,6,3,7,4,10,5,5,4,8,6,6,9,7,9,,,4,3,
   8,3,4,7,6,6,5,6,6,5,,,,6,5,4,5,3,3,6,3,7,6,6,8,6,
   6,8,5,7,4,7,5,6,7,7,6,6,16,16,17,,8,6,8,17,4,7,6,
   17,6,5,7,6,17,8,,7,6,9,5,5,5,5,5,5,9,6,9,9,5,5,4,
   4,4,6,,6,3,7,,7,3,4,,,,3,4,4,3,4,5,6,5,6,6,8,8,8,,,
   ,3,4,4,6,4,7,3,4,7,4,,5,5,5,4,8,8,6,7,7,7,6,7,,7,
   ,,6,5,,4,8,4,7,5,,7,,7,8,,6,6,8,5,4,6,4,5,5,5,,6,
   8,4,4,4,,6,5,5,4,6,5,4,4,4,,7,4,4,4,4,,5,8,4,6,,6,
   ,4,,,6,4,4,4,3,7,4,5,4,6,3,3,5,4,,6,5,5,4,6,5,4,
   4,4,,7,4,4,4,4,8,5,,4,6,,6,,7,,8,6,3,4,4,4,4,4,4,
   4,6,3,4,4,6,,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,
   8,6,,,,,,5,4,10,4,4,3,4,7,4,7,5,5,4,3,4,5,4,3,3,3,
   ,5,3,4,3,2,5,4,5,4,5,6,5,6,5,,,5,4,4,3,3,5,3,3,
   3,5,3,4,8,7,8,5,8,7,6,10,6,,10,6,,8,6,7,7,6,8,10,,
   9,,7,,14,7,,7,6,5,5,6,11,9,13,9,,,6,6,6,,,9,,,,6,6,
   9,5,7,8,8,6,6,10,7,9,7,,,7,,6,,5,6,9,5,9,6,9,12,5,
   7,,4,,7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,6,4,5,5,
   5,6,4,8,6,8,5,7,8,5,4,,4,,,3,4,3,3,4,6,6,4,,6,8,6,
   ,,4,7,4,4,3,4,5,10,3,3,,,4,6,7,10,10,10,,,7,4,10,4,
   8,7,5,4,6,5,6,5,,,8,6,7,6,6,,6,,6,7,6,7,7,,,10,,,,
   8,6,10,5,10,7,8,6,7,9,6,10,,,,6,7,5,6,7,,10,6,9,5,
   9,,,7,,,14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,5,4,5,5,
   7,7,5,8,6,8,6,4,3,,,4,4,4,3,5,7,6,4,9,10,10,8,,,,,
   4,4,3,,4,7,4,4,12,4,3,4,,,3,4,3,3,,,8,4,,6,,6,,,5,
   12,4,4,4,7,4,,3,3,,4,4,,,4,4,4,3,8,7,6,4,9,8,10,
   10,14,,13,,3,4,3,8,9,,5,4,12,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,8,4,14,4,9,9,7,7,7,7,,10,,,,,8,,,,7,,7,5,,,,5,,3,,7,
   8,5,,6,,6,,,4,7,4,4,3,7,4,6,3,,,3,4,4,4,,5,,4,6,,6,
   8,7,,,6,3,7,5,4,4,3,4,3,6,4,4,3,13,,10,4,,6,,6,,,8,
   12,4,9,5,,4,8,3,4,,3,4,,4,6,4,5,5,5,5,4,,4,5,3,5,
   3,3,4,3,3,4,5,4,3,9,,,,14,,,,,,8,5,,,,7,7,,,,,,8,5,5,
   7,,7,14,,8,6,8,7,5,7,4,5,5,6,,5,8,,9,,10,,10,,,7,,5,
   ,6,6,5,9,9,13,9,,6,8,6,,7,,,6,4,6,7,4,6,4,7,3,6,
   4,3,8,6,8,,,7,6,9,6,5,9,6,5,5,7,7,,9,8,6,10,,7,13,
   9,5,11,6,7,5,6,,7,,9,8,,,10,5,9,,6,10,5,7,6,,6,7,9,
   7,,,13,9,6,9,5,5,6,,,7,,9,,9,,,7,7,,,,,,,8,8,,,,,,,,,,,,,,
   ,,7,,7,,,,,8,8,,,10,6,7,5,7,6,6,6,6,,3,4,24,4,6,4,
   3,6,3,4,4,4,4,3,6,9,5,4,4,5,6,6,5,5,6,4,4,3,5,4,
   21,7,6,4,4,4,4,10,3,9,5,4,7,24,21,4,6,4,5,,4,3,,6,
   3,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,
   9,,,,,,,,6,3,12,,,,,6,6,12,,,,,,8,5,9,9,,3,9,9,9,,,,4,
   8,7,5,4,,7,4,,,3,4,,20,,11,,9,4,16,,4,4,11,5,3,9,27,
   3,4,,,,10,3,12,12,,7,7,8,,,,7,5,,3,8,8,,5,7,5,5,4,,
   5,8,5,5,,,3,5,,5,,4,,5,,,,6,,8,6,5,5,3,3,5,,,,5,3,,
   5,9,6,9,7,7,8,7,5,,7,9,5,,6,7,12,5,9,7,8,,6,13,,,,
   7,,,,11,10,,9,9,,8,20,6,,8,11,8,5,11,,,,10,5,5,13,7,
   9,7,7,,6,8,4,12,5,6,,8,13,5,5,6,,6,4,5,6,,,4,6,,6,,
   6,,15,5,4,,7,10,10,,5,5,5,7,5,,,,5,5,5,8,,,6,,7,8,,
   6,8,5,,8,13,6,8,6,17,7,5,6,7,,,5,7,,,,7,20,10,9,12,,
   10,22,5,19,,8,7,8,6,,,,7,6,17,8,8,9,,8,8,,18,8,8,,
   13,15,15,9,11,,10,16,8,15,,,,10,,15,,16,12,21,10,,,,,,
   21,7,6,6,,55,,,,10,9,7,86,7,,8,6,4,5,5,6,,7,,8,,7,,8,
   ,5,8,,,,8,,6,,,6,,5,8,,8,8,,,4,,7,,,,,,5,6,5,8,,7,7,
   5,6,6,7,,8,12,8,8,,5,6,12,9,8,,,,5,,6,,7,7,5,6,5,,
   5,5,22,6,,,6,5,17,,,,,7,6,20,9,10,,10,9,11,,16,16,9,
   4,5,13,11,9,4,10,,,,11,,5,,5,19,11,4,9,,13,,16,13,8,
   8,7,9,7,,,,7,8,7,16,6,,8,9,6,,7,16,6,8,6,7,6,,7,7,,,
   ,6,,16,,10,12,10,9,,,7,11,9,,10,10,9,6,6,,,,10,7,7,20,
   ,,,,,5,,6,5,6,7,6,,4,,,,4,6,,6,,6,8,6,5,,,,8,5,,5,7,
   7,4,6,,,,5,5,10,9,,,,,,,4,,,5,4,4,,4,,,2,4,,,,,6,4,3,4,
   ,4,3,,5,3,,,3,4,,,,,2,,,,6,,,,5,5,5,6,5,6,5,5,,,3,5,,
   5,,5,7,5,4,,,,4,,,,,3,3,5,,,,5,3,11,11,,,,,5,5,6,7,6,
   5,5,6,,,4,6,,6,,6,8,6,5,,,7,8,,6,7,5,4,7,5,,,,5,5,
   5,14,,,,6,5,6,7,6,,4,7,,,4,6,,6,,6,8,6,5,,,7,8,5,,5,
   5,7,7,6,,,,4,5,4,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,
   8,7,8,7,,7,,,,5,7,,9,,7,9,7,7,,,,9,,,5,,7,5,7,,,,7,6,
   10,10,8,8,9,9,8,,6,,,,6,8,,10,,10,10,8,8,,,,11,,,8,9,,
   ,11,,,,6,7,,11,5,6,,,,5,4,,,4,4,,6,,6,,,5,5,,4,,8,5,
   4,8,5,4,5,,,,5,4,5,6,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,,,
   6,,5,5,4,5,,,,,5,5,6,9,6,8,5,7,,,,6,,,,,10,6,,8,,7,,
   8,12,8,5,17,4,6,,,,7,7,5,7,,,7,,,,,5,,7,,7,,,6,,,5,5,
   9,7,7,,6,5,14,,,,,,7,9,,5,,,,,4,,6,,6,,,4,,,4,6,8,6,6,
   10,5,4,4,,,,10,8,6,8,5,,,,4,,,8,,8,,,7,4,,,,11,5,5,5,
   5,,,,,,5,7,5,,5,,,3,5,,,,5,8,5,,7,,6,4,6,6,5,5,5,3,5,
   ,,,,3,4,5,,,4,4,,7,,7,,,6,6,,4,,9,,4,10,5,4,6,,,,7,4,
   6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,4,
   ,4,,5,5,3,3,3,3,,,,,,2,4,5,,6,,6,,,4,,,4,5,8,5,4,5,
   5,4,4,,,,5,4,6,7,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,5,8,,7,8,,
   6,7,5,7,7,5,,,,5,17,6,7,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,
   7,10,10,12,5,4,11,7,6,,,,5,11,6,8,,6,,,,13,15,,6,9,9,
   ,9,,,,8,17,11,14,4,,,,14,8,,5,7,5,9,4,,,,5,5,9,12,5,,
   4,4,7,5,,6,4,4,4,,,,6,5,5,6,,,11,,5,5,8,7,,5,,,,7,5,,
   ,,,,,,,,,,,,,,,,,5,11,6,4,10,6,4,4,,,,10,4,7,,,6,,,4,4,,,,
   ,,,8,14,,,,,5,8,,,,,6,,9,,,6,,5,,,,,5,6,,5,7,3,6,,,,5,
   3,5,8,3,7,8,,,,5,6,5,5,3,5,,,,11,3,5,11,4,,,,7,3,7,
   9,,,,7,5,5,5,,,,,,,,,,,,,,,,5,4,7,5,8,11,,,8,,,,7,4,4,,4,
   ,6,6,,7,,,,6,,6,,,4,,,5,6,7,4,,5,,,7,,12,5,,,8,,,6,6,
   5,4,5,5,,7,,5,,9,9,,7,7,7,10,6,8,7,7,22,9,8,,,9,12,
   18,22,,12,10,,,12,8,18,,,8,13,7,8,6,,9,10,,20,,,6,7,
   22,8,6,7,,,8,10,,6,,7,8,5,8,,9,5,10,5,16,9,,,5,8,,5,
   ,7,9,,,7,7,17,,,11,10,,11,12,,10,63,8,,,,11,8,8,,8,,,
   5,5,5,9,,,,7,10,5,10,9,,13,6,13,,,9,15,6,14,,13,9,,,
   7,9,17,,,15,,18,,,18,12,10,,,,,10,,5,5,11,8,,27,7,5,,4,
   6,4,6,4,6,5,5,5,4,9,,,5,10,6,6,,,7,,,10,7,,4,,7,19,
   14,5,,,7,5,9,21,,,5,4,14,5,8,4,,11,5,4,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,3,8,,5,8,,5,,,3,9,,,,,,,,,5,
   ,3,,,,,5,7,7,,5,3,,,,5,,,5,,3,,6,3,,7,8,,7,5,5,7,5,7,
   ,,7,12,6,8,,9,9,,,9,5,15,5,,7,,5,6,7,16,7,6,128,20,,
   ,5,5,9,8,,11,,8,5,5,4,4,5,5,5,4,7,7,,,5,,,,,9,,,,9,
   6,9,4,,6,9,6,5,7,,7,5,15,,,,5,5,10,5,5,4,,4,5,6,,5,
   6,6,6,8,,,,5,10,9,6,,11,5,,,10,12,,4,,8,24,10,7,16,8,
   10,6,39,9,,,6,8,14,5,5,5,,7,6,6,,,4,,,4,,,3,,,,,4,,,,
   4,4,4,2,,,4,,5,6,,,5,3,,,,4,,5,3,,3,,,2,,,6,6,6,,,,5,
   5,7,6,,,4,,,6,6,,,,,,,7,8,,5,6,,8,,,6,17,7,5,5,7,,7,
   7,5,5,5,5,,,,5,5,6,5,,5,5,,,5,5,6,,,6,,,6,7,,,6,,,,,
   5,5,6,5,,,,5,5,5,6,5,,,,,6,6,6,,,5,,,,4,,4,,6,,6,5,,
   8,7,6,,8,,,5,5,14,5,5,5,,7,4,5,,7,,,5,,,4,,7,5,,,6,
   6,8,4,,6,8,6,7,10,10,7,5,8,5,,,6,7,7,5,5,4,,4,5,4,
   7,,,5,,5,,,7,,,,6,6,8,4,,6,8,6,6,9,10,9,5,8,,,,5,4,
   6,8,7,5,,10,5,5,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,6,11,,,
   4,6,16,7,,7,,8,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,6,,
   ,11,4,11,,5,,,5,5,5,,,,7,5,,,6,6,8,4,,6,8,6,9,10,9,
   6,,8,14,,,9,22,12,7,5,5,,9,5,6,,,10,,,,9,7,11,5,,7,9,
   7,,11,12,11,6,9,,,,6,5,7,,,8,,,6,6,,7,,,,6,6,8,4,,6,
   8,6,8,10,10,8,6,8,6,,,6,8,8,10,10,6,,4,5,4,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,15,,,,8,10,7,,7,,7,
   ,7,,,5,5,5,3,,4,7,5,7,8,6,7,7,4,5,,,5,12,7,,6,6,,
   5,3,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,
   9,6,,,8,7,,8,12,,,10,7,9,7,5,5,,6,17,6,,4,,6,,6,5,,
   8,7,,5,8,,,4,5,15,5,4,5,,7,4,6,,,,,5,,,,,,,,,,,5,11,7,
   7,5,,,,13,,,,,5,6,,,5,,5,,,,3,,3,,3,,4,2,4,,,,,,,,,,,,,,,,,,
   ,,,,,,,7,8,,,12,10,10,,,6,11,8,4,5,5,,7,11,6,,,,,,21,,,,
   ,5,,9,5,5,5,,9,,15,7,8,,,12,8,,,,5,7,7,5,7,8,,6,17,
   6,,9,8,,,9,,,5,6,17,5,7,5,,7,5,6,10,9,23,,11,,,6,7,
   17,8,6,7,,,,8,,13,,,,,,,10,6,8,9,,9,9,52,7,,,,,7,,8,7,,,
   ,8,8,5,,6,,,6,5,,,,,,,6,5,,,,,4,9,,,,,8,,8,,,8,,14,,,,,
   5,6,,,,,,,,,,,,,,,,,,,,,,,5,11,5,4,5,,7,5,5,8,6,12,7,,7,
   3,5,5,7,8,,9,11,5,5,5,,7,3,8,5,,7,11,7,,4,3,6,,,,5,
   4,5,3,4,4,4,3,4,4,4,4,3,4,4,4,4,3,3,4,4,4,4,4,
   11,8,4,9,7,3,4,,6,,9,,12,,8,5,4,,,,3,4,3,4,4,4,4,
   12,6,12,8,4,4,4,4,3,4,4,4,4,3,4,4,4,4,3,3,4,4,4,
   4,4,11,8,4,9,7,3,4,,6,,9,,12,,8,5,4,,,,3,4,3,4,4,4,
   4,12,6,12,8,4,4,4,3,3,3,3,2,4,4,4,4,4,6,4,2,4,4,
   3,3,4,6,3,5,5,3,3,4,3,,4,8,6,3,3,4,4,8,,,2,4,4,3,
   3,2,4,3,4,3,6,4,3,4,3,4,4,4,4,4,4,4,3,8,4,4,3,4,
   7,4,7,6,,,4,4,6,7,4,,6,10,9,5,10,5,6,,9,7,3,4,4,3,
   4,4,4,4,7,5,8,6,4,3,4,4,4,4,4,4,4,3,8,4,4,3,4,7,
   4,7,6,,,4,4,6,7,4,,6,10,9,5,10,5,6,,9,7,3,4,4,3,4,
   4,4,4,7,5,8,6,3,4,4,2,3,3,3,4,4,3,3,3,4,4,6,4,6,
   6,4,,,2,3,4,4,7,4,5,6,2,3,6,5,,,8,2,9,3,6,4,3,4,
   2,4,2,9,4,4,4,2,4,4,4,4,4,4,4,3,3,4,4,4,3,5,5,3,
   5,3,2,4,4,5,4,6,6,3,2,8,4,5,10,5,2,4,4,4,4,3,4,
   3,4,3,8,4,3,6,4,7,4,4,5,4,4,4,4,4,3,4,7,7,6,,,6,
   4,10,3,8,6,8,9,5,,6,,,7,,4,7,4,4,3,3,4,4,9,5,9,8,
   6,4,7,4,4,5,4,4,4,4,4,3,4,7,7,6,,,6,4,10,3,8,6,8,
   9,5,,6,,,7,,4,7,4,4,3,3,4,4,9,5,9,8,3,3,4,4,4,7,,
   2,4,4,3,4,3,6,,3,,2,2,6,4,6,7,6,7,2,2,6,6,3,5,,2,
   4,4,4,3,2,6,2,5,2,7,6,3,4,4,4,3,3,3,4,4,4,4,4,,
   3,5,,3,3,5,5,11,5,6,7,4,4,,3,4,,3,3,4,3,3,4,4,3,
   8,5,3,13,4,4,4,4,,5,3,4,4,4,4,4,7,7,5,6,3,3,6,8,
   15,6,7,8,4,4,5,,4,,,3,4,4,4,4,4,5,9,7,3,9,9,4,4,,
   3,4,4,4,4,3,6,6,4,,5,3,4,4,4,5,4,5,6,4,,5,4,,,5,
   3,4,4,4,4,4,4,3,4,4,9,4,4,5,,4,4,4,6,4,,8,4,,,3,
   5,5,4,6,5,8,7,4,9,9,4,,,6,3,3,4,4,4,4,4,3,5,4,8,
   4,9,5,4,3,4,6,4,3,6,3,,4,3,8,6,3,7,6,10,8,3,4,4,
   4,7,6,,3,4,4,3,4,18,4,3,6,4,7,3,3,4,4,4,4,5,8,9,
   5,,5,3,4,6,7,15,6,7,8,4,,5,,,,,3,,3,7,4,5,4,10,6,4,
   8,8,4,4,4,4,3,,,,9,,3,4,6,4,6,6,6,7,4,9,6,5,,10,,
   3,4,3,,4,4,4,3,5,4,9,7,4,4,,4,,8,3,,5,3,3,4,3,5,
   4,5,7,3,3,4,3,,6,3,2,7,4,3,4,2,4,3,4,3,7,4,4,4,
   4,11,,5,9,4,4,3,5,4,5,4,5,7,,7,5,4,,,4,3,4,4,3,4,
   4,4,4,4,10,10,4,4,4,6,5,5,10,,5,3,10,4,7,5,6,8,6,
   6,6,4,,5,4,6,5,4,3,4,4,4,4,8,6,7,4,,,11,,,5,,3,,3,
   12,8,,11,4,3,4,4,5,9,,4,8,4,4,3,3,4,3,12,15,9,8,5,
   6,,11,6,7,3,8,3,,8,9,7,4,3,4,4,3,4,3,4,5,4,3,3,
   10,5,4,7,4,6,4,6,3,3,,3,5,5,6,6,5,11,9,3,4,11,4,,
   9,6,3,19,7,3,,4,8,3,5,5,6,3,7,7,,6,6,7,7,16,6,6,9,
   ,6,,,,,,5,9,7,5,6,11,,10,6,11,8,7,,,3,2,9,4,7,5,6,
   9,3,2,9,3,,5,6,2,,4,3,8,,8,4,8,3,7,3,,3,,8,7,,8,,
   11,3,,8,,,,,3,,100,167,13,,8,3,14,,,15,5,4,,5,6,6,6,,7,
   ,,,,,,,5,,6,,5,,5,5,7,,,3,,4,,5,,7,2,3,5,3,,5,3,2,3,
   3,2,7,3,4,2,7,2,7,3,5,4,,5,,8,3,2,5,3,4,10,4,2,5,
   4,3,3,3,3,3,5,3,8,6,7,,,6,9,,5,,5,,7,6,4,5,6,4,8,
   5,7,12,8,4,8,7,,5,7,8,5,10,6,5,,,5,3,4,8,3,3,3,6,
   4,5,5,11,5,6,8,,,,16,,,,,5,6,,5,,6,13,,,,,,6,7,8,7,,5,
   ,6,6,4,5,6,4,8,5,10,10,4,5,6,9,,10,,,,,,,5,8,10,,10,
   7,7,9,6,5,9,11,7,10,9,,,9,,6,7,8,6,7,9,9,9,7,10,7,
   10,3,6,4,,10,3,2,10,4,2,4,3,5,2,9,2,12,3,9,4,4,,4,
   2,14,13,3,3,3,7,3,7,3,,4,6,,,7,5,5,,5,10,4,6,,6,6,
   12,6,4,,,3,6,4,3,4,,4,,8,3,,4,,3,15,,,3,,4,,3,,,,8,,,
   48,,5,5,20,6,50,25,7,,6,10,,5,,3,,,,,3,,,3,3,2,4,2,3,
   2,4,2,7,3,4,4,9,4,4,3,5,9,11,6,4,4,4,4,18,10,4,9,
   4,3,10,10,4,4,2,6,3,3,4,3,7,4,6,4,4,3,5,3,13,10,
   10,6,5,9,4,10,2,10,4,6,15,13,10,4,9,4,4,4,3,4,4,4,
   4,3,4,4,4,4,3,3,4,4,4,4,4,11,8,4,9,7,3,4,,6,,9,,
   12,,8,5,4,,,,3,4,3,4,4,4,4,12,6,12,8,4,3,4,4,4,4,
   3,4,4,4,3,4,4,8,11,4,4,4,4,4,3,3,4,7,9,4,4,4,4,,
   4,7,3,11,8,4,7,9,7,,4,4,3,4,4,3,4,4,4,4,4,4,4,4,
   4,4,3,4,4,4,3,4,4,8,11,4,4,4,4,4,3,3,4,7,9,4,4,
   4,4,,4,7,3,11,8,4,7,9,7,,4,4,3,4,4,3,4,4,4,4,4,4,
   3,3,3,3,4,4,4,4,4,3,6,8,4,4,3,5,3,8,6,5,7,7,3,4,
   5,6,,4,7,4,4,5,3,4,,8,,4,2,2,4,4,4,2,4,7,10,4,4,
   4,4,3,3,3,4,4,4,4,3,3,4,4,4,4,4,6,4,4,,8,2,4,3,4,
   ,3,4,6,4,6,4,8,7,5,,3,6,2,9,4,4,3,3,4,2,4,4,3,4,
   4,4,6,4,4,7,4,4,4,4,3,4,5,8,4,10,,,4,3,7,4,,4,3,
   6,7,6,,7,,4,8,7,6,3,6,4,4,3,4,7,4,4,9,4,4,4,6,4,
   4,7,4,4,4,4,3,4,5,8,4,10,,,4,3,7,4,,4,3,6,7,6,,7,,
   4,8,7,6,3,6,4,4,3,4,7,4,4,9,4,4,5,3,4,4,4,4,3,4,
   4,3,3,8,4,8,7,9,4,4,4,4,,4,5,4,4,6,4,6,9,8,8,6,
   5,2,4,4,3,3,4,7,9,6,5,4,4,4,4,4,3,,3,4,4,4,4,4,3,
   ,6,,3,3,4,4,,4,4,4,4,5,4,4,5,4,,4,4,3,4,4,4,5,4,
   4,3,4,5,4,3,3,4,3,3,4,4,4,4,3,7,,4,7,,3,4,4,4,,4,
   4,3,5,6,,4,11,,7,3,3,3,4,4,4,4,3,4,8,6,4,4,4,4,,
   5,4,4,4,8,4,4,4,4,8,8,3,4,4,4,,4,5,4,5,6,4,,6,6,
   6,4,4,3,3,4,6,4,4,4,3,4,4,3,4,,7,4,4,4,4,3,3,3,4,
   ,7,3,4,4,4,,4,6,3,6,,3,4,6,,7,4,4,3,4,4,3,3,4,3,
   4,3,4,4,5,,4,4,4,4,3,,5,4,,,3,4,4,4,,4,6,3,6,7,7,
   4,15,6,9,4,4,3,4,4,4,4,4,4,9,5,4,5,9,4,4,3,10,4,
   4,4,4,,8,3,4,3,4,,3,8,4,6,7,4,7,7,5,,4,3,3,4,4,7,
   4,4,4,3,4,4,3,3,4,4,4,4,5,3,3,,8,3,3,4,4,,4,4,4,
   6,,3,,6,5,4,3,,3,4,4,5,3,4,4,3,,5,4,4,4,4,4,,5,,
   14,25,3,4,4,4,,4,4,4,6,7,6,8,15,6,,3,7,3,,4,9,4,4,
   4,10,8,9,4,4,,4,,3,4,,6,4,4,4,4,,3,4,3,6,6,4,4,,5,
   4,4,5,3,4,4,4,4,4,4,4,4,3,4,4,4,5,,8,8,8,4,4,6,4,
   ,4,4,3,,8,4,4,,,4,6,4,3,4,3,4,4,4,6,4,4,3,4,4,9,
   5,10,8,,4,3,6,4,,4,3,3,5,6,5,4,,4,5,7,4,3,4,4,4,
   3,4,6,18,4,3,,,3,,,11,4,4,6,4,,3,4,,12,11,4,8,,5,10,
   9,14,3,8,4,,4,4,12,12,4,13,4,4,,,,3,3,11,3,,3,3,3,
   5,6,3,5,7,4,7,7,4,2,4,4,7,4,4,10,3,3,3,3,4,25,14,
   4,4,4,4,,5,6,3,8,9,5,4,,5,11,9,4,3,4,,3,7,4,4,5,
   4,4,4,8,,4,4,4,4,,3,4,3,,,,4,9,,4,5,3,3,4,4,3,,4,
   4,4,4,3,11,,3,3,4,4,,4,4,4,,,,4,,4,,,4,3,4,8,9,14,
   4,4,3,4,4,,8,,,7,,6,,6,7,19,7,,,,,8,,21,15,,,7,7,8,29,
   ,,6,6,,7,,,10,,8,9,,7,,,,,7,21,,15,8,,12,7,,27,,4,,4,,
   4,4,3,,8,3,3,,5,3,3,2,2,3,7,4,3,4,9,2,4,3,4,4,,4,
   ,4,11,,5,5,9,4,5,4,3,3,4,4,4,3,4,3,4,4,4,4,,,4,4,
   ,11,,,,5,8,4,3,4,10,8,4,4,3,4,3,4,3,,4,4,4,6,5,5,
   6,10,,8,4,3,6,6,5,4,3,4,4,4,4,4,,,,,,,,,,,,,,,,,,,,,,,4,
   4,5,6,,10,11,6,12,4,3,4,9,5,4,3,3,4,10,5,4,,11,,,,,
   4,,4,10,3,,4,6,3,4,3,4,7,6,4,6,,,15,5,,4,3,3,84,3,
   4,3,5,4,3,4,3,6,5,5,,,6,6,4,4,5,19,7,4,,13,12,8,8,
   7,7,7,,8,7,5,5,6,9,7,5,6,7,11,,10,4,,,8,7,3,,8,,4,
   4,8,5,,8,4,6,,3,5,4,3,14,4,4,3,,8,3,5,4,,7,,21,5,6,
   ,100,167,,51,,8,8,6,11,14,,5,5,,6,,4,5,,5,,,3,,4,65,,
   25,12,3,8,,4,3,4,6,4,4,4,4,18,5,6,2,4,11,4,2,3,3,
   4,4,2,3,3,3,2,4,13,2,3,2,4,6,11,9,6,3,4,4,4,4,9,
   6,4,4,3,4,4,4,4,4,7,3,3,10,10,3,4,3,4,4,4,3,4,4,
   3,4,4,3,4,4,3,4,4,4,3,4,4,4,6,7,4,4,3,,4,4,8,7,4,
   ,4,6,10,7,8,5,7,6,4,4,4,3,,,,4,4,4,4,3,3,4,6,9,7,
   6,7,4,3,3,3,3,4,4,3,4,2,4,5,6,4,3,4,6,3,6,5,6,6,
   6,3,4,6,4,6,8,4,4,7,8,4,4,6,6,6,4,4,4,4,4,4,4,4,
   4,4,4,4,4,4,3,4,4,4,3,4,4,4,6,7,4,4,3,,4,4,8,7,4,
   ,4,6,10,7,8,5,7,6,4,4,4,3,,,,4,4,4,4,3,3,4,6,9,7,
   6,7,4,3,4,4,3,2,4,3,4,3,3,4,4,4,8,4,5,7,5,10,5,
   2,4,5,4,5,4,4,6,4,4,4,6,5,9,9,3,8,3,8,4,4,4,4,4,
   4,4,4,4,3,6,4,3,4,3,6,4,4,4,3,4,4,5,,,8,10,8,6,3,
   8,6,10,5,7,6,4,4,4,7,8,10,10,7,7,4,6,4,4,4,6,7,7,
   7,7,4,4,4,4,4,3,5,4,4,3,4,3,4,4,5,6,6,9,,4,4,8,
   4,8,6,4,4,7,6,6,5,7,8,6,6,4,4,4,3,3,4,4,4,4,4,6,
   6,4,3,4,3,6,4,4,4,3,4,4,5,,,8,10,8,6,3,8,6,10,5,
   7,6,4,4,4,7,8,10,10,7,7,4,6,4,4,4,6,7,7,7,7,4,4,
   4,4,4,6,,4,4,4,6,4,5,6,,6,,3,4,8,6,8,7,,7,4,4,4,
   4,6,6,,4,4,4,3,4,5,6,7,6,5,5,6,4,4,4,4,3,3,4,4,
   4,4,4,5,,4,5,,3,4,8,7,8,7,6,6,8,5,,4,8,,6,3,4,3,
   4,4,4,4,6,8,6,7,4,4,2,4,,3,3,3,3,3,3,4,,,4,5,2,3,
   5,4,5,4,4,4,3,3,3,,6,8,8,4,4,4,4,3,3,3,4,4,5,5,
   5,4,4,,6,4,4,4,7,4,10,10,4,,6,3,5,6,5,6,4,6,5,8,,
   5,4,8,,6,4,3,4,4,4,4,4,5,5,7,17,4,4,3,,3,3,3,5,3,
   ,5,4,7,7,2,6,9,5,6,6,6,5,3,4,4,2,5,5,5,4,4,4,4,
   3,4,4,5,5,4,4,4,6,6,4,4,4,10,4,6,6,6,,6,3,5,8,5,
   10,4,6,5,4,4,4,4,10,6,,4,4,4,4,4,6,5,5,5,5,5,17,
   3,4,4,4,4,6,6,9,9,,5,3,4,,4,5,4,4,4,,,5,,7,,8,3,,
   3,6,4,4,4,4,4,6,7,5,3,4,4,4,4,,5,,8,6,3,3,,6,7,7,
   7,6,4,8,3,3,5,5,,3,6,3,,4,6,3,6,6,4,7,,4,3,,4,,8,
   5,,5,4,4,,4,5,4,4,4,4,4,4,3,,9,8,4,12,4,4,3,4,3,
   4,4,19,7,4,4,4,3,5,,5,7,7,5,3,5,5,8,4,5,5,,4,4,3,
   6,6,6,6,5,4,4,4,4,4,5,6,4,4,4,4,4,4,9,5,4,,7,4,
   10,6,,7,7,8,4,4,4,3,,8,,13,4,4,4,3,3,4,8,7,7,6,4,,
   ,8,,,7,5,4,7,5,,4,5,5,4,7,4,6,35,7,7,6,24,4,6,4,,
   4,5,6,10,7,9,5,6,,7,7,5,3,5,5,8,4,5,5,3,4,4,3,10,
   6,10,6,5,4,4,4,5,5,5,6,5,5,5,10,6,10,8,5,6,6,7,9,
   12,,9,5,6,5,4,,,12,5,10,5,5,,5,4,9,7,14,10,8,,12,,6,
   6,8,8,13,7,6,6,,,,7,8,5,11,12,9,12,6,8,9,,7,7,5,6,
   6,,,3,4,11,8,,9,10,11,5,4,4,4,12,9,,,6,4,6,5,6,7,
   11,9,10,8,4,7,4,7,7,6,7,4,8,8,,6,5,,,,,5,,25,14,104,
   ,5,6,6,,60,24,7,6,7,5,6,6,5,5,,7,5,7,,,,,6,16,7,,6,
   ,5,5,,,38,4,,5,,7,5,5,,4,4,3,,7,8,3,3,3,3,7,4,4,5,
   14,5,5,3,6,5,7,6,,5,4,,3,4,7,7,7,4,5,4,4,4,5,4,5,
   5,6,6,6,8,9,,,11,,11,,,,,17,9,6,9,9,12,8,8,11,8,,11,
   7,,7,4,4,9,6,5,5,10,,8,6,5,7,6,6,5,6,4,4,6,20,6,
   6,6,,,8,7,,,,,9,6,61,9,32,6,8,,,,35,27,7,7,10,6,,6,9,
   11,11,7,4,7,7,7,4,7,7,7,7,6,7,,9,,5,,7,8,,6,6,6,,
   8,6,11,4,4,7,8,18,10,6,5,,7,8,,6,5,6,7,9,5,7,5,4,
   10,6,19,4,4,3,9,11,8,9,9,9,4,4,4,4,,26,11,9,4,4,4,
   9,,7,5,12,5,4,4,4,4,6,6,8,,5,4,,,7,,5,,4,4,4,4,5,5,
   ,,5,6,7,10,5,,4,4,3,3,3,,,5,5,4,6,10,61,101,9,6,,,
   37,,,,5,7,8,42,,,6,8,,8,,,5,,6,20,113,6,,,12,24,,,,7,,
   4,3,4,9,4,4,6,7,6,7,9,4,4,9,4,4,5,5,7,10,10,4,4,
   4,4,6,9,6,7,4,4,5,8,7,6,5,5,6,3,4,9,7,7,6,4,4,5,
   5,11,11,6,7,6,21,9,4,4,,8,13,8,20,7,4,5,5,4,4,4,4,
   3,4,4,4,3,4,4,8,11,4,4,4,4,4,3,3,4,7,9,4,4,4,4,,
   4,7,3,11,8,4,7,9,7,,4,4,3,4,4,3,4,4,4,4,4,4,4,4,
   3,4,4,4,3,4,4,4,6,7,4,4,3,,4,4,8,7,4,,4,6,10,7,8,
   5,7,6,4,4,4,3,,,,4,4,4,4,3,3,4,6,9,7,6,7,3,4,4,3,
   4,4,4,4,6,8,4,3,4,4,5,9,8,11,,,4,3,3,3,4,3,4,3,
   12,3,3,4,,7,9,,3,8,4,12,4,3,4,3,4,3,4,6,4,4,3,4,
   4,4,4,6,8,4,3,4,4,5,9,8,11,,,4,3,3,3,4,3,4,3,12,
   3,3,4,,7,9,,3,8,4,12,4,3,4,3,4,3,4,6,3,3,4,4,4,4,
   6,5,3,4,4,3,3,4,6,8,5,8,,4,4,5,2,,3,4,4,8,6,5,7,
   7,7,,10,4,4,4,2,2,4,4,4,4,2,7,4,3,4,3,4,4,6,4,4,
   4,4,2,4,4,8,4,8,9,4,4,8,3,8,3,6,4,4,4,3,5,9,7,,
   9,6,3,4,3,2,4,4,5,6,5,7,4,4,3,4,4,8,,2,3,4,3,4,
   4,4,,5,,3,3,3,2,3,3,3,3,3,3,4,4,6,8,,2,4,4,4,3,2,
   7,3,3,3,2,9,4,4,4,4,6,6,4,4,4,4,3,3,,4,5,,3,4,4,
   4,4,4,4,3,4,3,,4,6,,,4,4,4,4,4,3,4,4,3,4,5,4,4,4,
   4,,11,4,4,3,5,4,4,4,4,4,9,3,4,3,4,5,3,5,4,4,3,4,,
   6,,,4,4,4,4,3,3,4,4,4,4,3,3,4,4,,4,3,3,4,3,4,3,3,
   4,,5,4,4,4,4,7,3,4,3,7,,4,6,7,,,4,3,3,4,3,3,4,4,
   4,4,4,3,4,8,,4,4,4,4,4,,5,6,,,4,4,8,4,4,4,4,3,4,
   4,4,4,8,8,,4,4,4,4,4,3,3,4,3,6,4,6,5,6,4,4,4,5,
   4,4,4,4,,10,4,4,4,4,8,3,6,4,4,4,4,4,7,7,,4,4,4,4,
   3,6,5,6,4,4,3,4,6,6,7,6,7,6,,9,11,,7,5,6,,7,8,6,
   7,6,7,,11,,9,19,,11,,7,6,5,5,9,6,10,7,5,7,3,4,3,3,
   5,,8,,,3,4,4,,3,4,4,4,3,4,4,12,11,8,7,,4,8,7,,3,3,
   19,4,3,6,4,13,3,4,,4,,7,3,,3,3,3,3,2,3,2,3,2,3,3,
   4,4,,7,,2,6,4,3,4,2,4,3,2,3,2,4,4,7,4,5,,4,6,5,4,
   4,4,4,9,3,4,3,,5,4,6,,,,4,5,4,4,4,3,4,4,4,4,4,4,
   3,4,5,9,6,4,,4,4,10,3,5,4,4,3,4,4,4,3,,8,,18,4,4,
   4,3,3,4,4,3,7,4,6,,,5,,,,3,3,3,2,8,2,3,,6,3,4,,,7,,
   ,8,4,8,3,2,,3,4,7,2,5,3,5,,6,11,4,4,4,3,12,3,10,
   4,4,4,3,4,,6,,10,5,4,3,3,4,5,9,4,4,3,4,3,4,,9,3,
   4,4,4,4,4,4,3,5,3,3,4,,8,,4,4,3,4,,3,4,4,3,5,3,4,
   4,5,,4,4,4,4,11,4,4,3,,5,,6,14,25,,5,4,3,4,7,3,,4,
   4,9,4,4,5,,4,4,4,3,8,11,,4,4,4,6,4,,,,3,4,4,3,4,4,
   8,10,3,4,3,4,,4,6,4,5,6,4,,5,6,5,5,4,,,,5,,,,6,,5,
   5,5,11,14,4,4,4,,3,4,4,4,15,4,4,,,,,,,8,100,13,167,3,
   ,4,3,,21,51,3,,4,,4,3,4,3,3,4,4,,6,,3,4,4,4,5,3,4,
   3,5,3,4,4,4,4,6,4,,4,3,3,8,5,8,8,,3,4,6,4,3,3,4,
   3,4,3,4,4,4,3,,3,4,,3,,4,,11,,3,4,9,4,14,3,8,4,4,
   3,4,4,,4,7,4,9,5,10,8,8,,,3,4,7,3,2,2,4,4,4,4,2,
   4,4,3,,,3,10,,,,,3,8,65,25,,3,4,,,3,7,12,4,3,4,4,,3,,,
   ,3,3,7,4,4,2,4,4,3,7,4,10,,3,,8,,7,,,3,5,4,,3,3,4,
   14,4,3,4,8,4,4,,,,6,,3,4,4,5,3,3,3,84,3,4,3,4,3,4,
   4,25,14,,3,8,9,4,4,3,4,3,7,3,7,4,4,4,8,,,3,,5,4,3,
   3,4,3,5,3,,4,4,11,,,12,4,,4,4,3,4,8,13,9,14,12,10,,,
   4,7,6,4,3,3,4,,6,4,10,3,,,,27,8,12,,6,15,7,,,7,7,,29,
   ,,7,7,21,,15,,8,,8,,,,,,,,,,,,,4,4,3,10,2,4,3,3,3,4,4,
   4,4,10,3,4,4,4,5,4,3,4,4,3,4,6,7,4,4,4,3,4,9,9,
   4,4,3,4,2,4,3,3,4,2,3,3,3,2,3,2,13,4,3,6,11,6,4,
   3,4,6,4,2,4,4,4,3,4,3,4,4,4,4,4,4,4,3,8,4,4,3,4,
   7,4,7,6,,,4,4,6,7,4,,6,10,9,5,10,5,6,,9,7,3,4,4,3,
   4,4,4,4,7,5,8,6,4,3,4,4,4,6,4,3,7,10,5,4,4,4,5,
   6,6,7,7,8,,4,4,,3,7,4,6,9,4,8,7,10,4,,,5,8,4,8,4,
   4,4,3,6,3,4,7,4,3,3,4,4,4,3,4,8,7,4,2,4,4,8,4,6,
   6,6,5,4,3,4,4,6,3,4,4,6,5,6,4,6,6,6,3,4,4,4,4,4,
   4,4,4,4,4,4,4,4,4,6,4,3,7,10,5,4,4,4,5,6,6,7,7,8,
   ,4,4,,3,7,4,6,9,4,8,7,10,4,,,5,8,4,8,4,4,4,3,6,3,
   4,7,4,4,6,3,3,4,6,5,4,3,4,4,4,4,4,8,6,6,4,6,8,4,
   6,4,7,4,5,6,4,7,6,6,6,5,6,3,4,4,3,4,4,6,5,6,6,4,
   4,4,3,3,8,,4,3,4,5,4,3,4,,5,,3,4,4,3,5,4,8,4,4,5,
   5,5,5,8,,4,3,4,3,4,4,12,3,4,4,4,6,4,4,4,4,10,10,
   4,4,4,4,4,6,,7,6,,4,4,6,4,7,4,6,3,5,6,,5,6,,9,4,
   4,4,4,4,4,3,4,4,5,6,5,4,3,4,,5,4,3,4,5,3,4,4,4,
   7,7,4,3,4,4,7,3,6,4,5,6,4,,4,6,6,4,4,4,4,4,6,5,
   6,4,4,4,4,4,4,,5,4,4,4,4,4,3,3,4,,5,4,4,4,4,8,4,
   5,3,5,,4,5,5,,8,4,4,3,4,4,3,4,4,4,4,4,4,3,5,,4,2,
   4,4,3,,3,5,7,7,3,3,9,3,6,3,6,2,4,,,4,5,5,5,4,4,4,
   3,4,4,4,3,3,3,3,4,9,4,4,3,4,5,4,4,4,4,,4,3,4,4,3,
   ,4,10,4,4,8,4,8,5,9,,3,4,4,3,4,13,4,8,4,4,4,3,10,
   6,,6,,6,5,9,8,,12,5,6,6,8,11,6,8,7,,,11,,7,8,13,9,,
   12,8,6,12,9,10,6,6,10,8,5,4,6,6,5,,6,,8,10,4,5,9,
   4,8,10,10,5,4,,6,5,7,,,5,4,5,,5,5,10,4,5,6,10,10,4,
   4,,4,,6,6,,6,4,4,7,4,9,4,5,3,10,10,4,6,,6,7,5,6,4,
   4,3,4,4,4,5,4,4,4,4,,3,3,,3,5,4,3,3,3,3,5,3,4,2,,
   5,4,6,7,7,6,3,3,4,3,4,4,4,3,3,4,4,3,6,4,6,6,10,6,
   ,4,4,10,4,6,4,,3,6,6,6,,,6,8,6,5,4,4,4,4,4,4,8,6,
   5,8,,,9,,,,5,4,,4,,4,5,3,6,11,4,,6,9,16,6,7,4,5,6,,
   6,4,5,6,4,5,4,6,,7,7,4,3,5,4,7,3,6,4,10,6,4,10,7,
   6,7,5,5,4,4,4,6,5,6,5,4,4,4,3,4,6,8,4,4,4,4,7,6,
   6,3,6,9,9,,,5,,6,3,3,4,,3,6,4,4,4,4,3,4,5,,3,4,4,
   4,,4,,3,,5,,6,8,6,7,4,4,3,4,6,3,,4,3,6,3,4,7,,4,4,
   4,4,7,5,10,4,6,6,,9,11,7,32,,4,4,4,6,6,24,6,4,6,4,
   4,7,8,6,7,9,6,6,10,,,8,9,14,,,,6,,16,,7,,6,8,8,187,
   25,7,5,4,11,5,7,7,7,8,7,7,6,8,,,,,5,25,,14,5,,5,5,
   74,57,44,4,,3,,4,5,4,,8,5,8,,5,,4,4,4,3,12,4,4,3,6,
   4,3,4,4,4,6,3,,4,5,,5,6,7,7,7,4,4,6,6,5,4,4,4,4,
   4,4,4,4,6,,9,4,,8,,10,,7,7,6,4,6,6,24,4,6,4,4,,4,4,
   ,4,8,4,4,9,5,10,4,,,4,4,13,3,4,4,4,3,3,3,4,4,7,8,,
   ,13,16,,,,,6,9,112,,248,8,7,,,12,17,30,10,4,5,6,,6,7,
   7,7,4,4,6,6,5,4,4,4,4,5,5,5,,5,,,,8,14,,9,6,7,,6,
   5,6,8,5,10,6,11,5,7,3,,8,,,4,4,7,14,3,7,3,14,4,4,
   4,4,10,6,10,10,8,12,6,10,5,4,10,5,5,4,10,5,4,5,,8,
   12,,11,6,10,12,10,9,12,6,8,8,9,,6,5,,,,6,4,,4,6,4,6,
   5,5,6,7,5,7,10,8,10,6,5,8,6,7,6,,11,9,6,5,7,7,74,
   57,5,5,,25,14,6,,,5,5,6,187,25,,8,6,16,68,,7,6,,8,,
   17,8,,7,112,,,30,8,9,,4,4,3,5,4,4,4,4,6,5,8,4,4,8,
   4,4,4,4,5,4,3,4,4,3,4,9,8,4,4,4,4,9,9,16,12,4,4,
   3,4,4,4,6,4,4,4,4,4,4,4,4,8,4,4,5,8,6,3,3,4,12,
   8,3,4,4,4,4,4,4,3,6,4,4,4,4,4,,5,4,4,4,6,6,7,7,
   10,7,,6,7,6,4,,4,,9,4,4,3,8,,,9,5,9,3,9,4,4,3,3,8,
   4,7,9,3,4,4,3,4,4,4,4,6,7,4,3,3,6,6,5,5,8,4,3,4,
   4,6,3,6,4,5,4,4,4,4,4,,9,8,3,3,3,4,4,4,3,4,6,6,
   4,4,4,4,4,4,3,4,6,5,5,4,4,2,6,4,6,6,6,7,,4,4,6,2,
   ,4,6,4,5,5,6,6,,8,,5,4,3,4,3,3,3,4,5,5,4,5,6,4,
   4,4,4,4,,5,4,4,4,6,6,7,7,10,7,,6,7,6,4,,4,,9,4,4,
   3,8,,,9,5,9,3,9,4,4,3,3,8,4,7,9,4,4,4,4,4,6,,4,4,
   4,11,4,5,6,,8,,4,5,6,3,6,5,6,5,4,4,4,4,,7,,4,3,4,
   4,4,5,6,7,6,5,5,7,4,4,4,3,7,7,4,3,3,6,4,5,,6,5,,
   4,5,8,6,11,6,6,5,5,4,,5,,,5,4,4,4,4,4,4,3,5,6,5,
   7,5,3,4,3,,5,4,4,3,6,4,4,8,8,4,5,3,6,7,7,,4,8,7,
   4,3,4,,,12,12,4,3,4,4,3,3,4,7,7,4,6,6,4,3,,5,4,4,
   3,6,4,7,7,6,,5,3,7,6,7,9,4,11,6,4,,4,6,,,6,4,3,4,
   4,4,4,4,6,7,4,8,5,4,6,,4,4,4,,4,,6,,3,3,4,5,6,3,
   6,5,6,5,4,4,4,4,,9,10,4,4,4,4,4,4,4,4,6,5,5,11,5,
   5,4,3,2,5,4,9,5,9,,5,3,4,5,2,5,3,5,4,3,3,3,3,,7,,
   3,3,3,3,4,27,3,5,5,4,4,6,7,6,8,5,8,6,6,7,10,,,6,
   5,6,6,14,6,6,,9,,9,,,,11,8,,6,12,8,5,6,5,6,6,6,,5,
   4,9,9,5,,6,,4,5,4,6,7,4,7,7,7,6,4,5,10,5,,13,,5,4,
   5,,5,5,8,4,7,8,7,10,4,4,,4,,6,11,,8,5,5,6,3,7,4,6,
   5,4,4,4,4,,9,8,5,6,4,4,4,4,3,4,7,9,5,6,3,8,4,5,,
   6,5,4,4,6,10,4,,6,7,6,,4,5,5,,,4,3,4,4,3,4,4,3,4,
   7,7,7,5,9,4,5,5,5,5,,4,4,5,2,5,4,5,4,3,3,3,3,,6,
   5,27,3,3,4,3,3,3,3,5,5,4,4,,,10,,,7,8,7,9,5,12,6,
   8,7,10,6,8,6,,11,,9,7,7,11,12,,5,6,9,6,6,13,5,6,,9,
   9,5,5,6,3,7,4,6,5,4,4,4,4,,6,,5,4,3,4,4,5,4,7,7,
   7,5,7,7,9,5,4,5,7,7,4,6,5,6,5,5,6,5,4,,11,13,5,8,
   5,5,,5,4,5,6,11,7,8,8,,,8,6,6,6,10,11,6,7,,9,,9,,,
   7,5,6,6,8,12,8,,8,9,8,6,7,7,,6,6,8,5,8,6,10,8,6,
   8,6,7,,7,51,,5,7,12,11,9,7,9,6,8,7,6,3,4,6,,3,6,4,
   7,,4,,4,7,,,,5,,17,,,,3,4,6,,,10,3,,,3,,,,,3,5,,5,,,,,3,
   17,,,5,,3,,,,,5,,4,,4,8,5,3,4,3,4,,8,5,4,3,3,3,10,4,
   3,3,15,6,7,6,7,7,6,5,,4,7,,7,7,,,,7,7,4,6,7,5,4,5,
   7,5,6,6,6,,,7,8,,9,,8,,12,8,,5,5,8,15,8,10,8,10,,6,
   8,,6,6,7,5,10,9,10,,,4,4,3,5,3,3,6,5,4,9,5,9,4,,19,
   ,,14,,,,,,11,8,,33,,7,5,,,7,,,7,5,8,6,,5,,10,7,8,5,4,
   6,15,4,4,4,8,4,7,6,,9,,9,,,14,,8,10,5,,8,6,5,10,8,
   7,8,,7,,7,,,,,7,12,4,7,7,5,4,18,14,5,6,6,4,3,4,,,5,
   6,4,3,3,4,4,3,3,18,5,12,6,4,3,,,11,4,5,4,4,4,4,4,
   10,11,5,,8,4,,,5,6,3,,4,4,4,3,9,9,4,12,6,,11,,8,4,
   8,4,3,3,4,,26,5,6,5,,,,,,,,,,,,,,,12,,,,11,11,,26,,,7,,
   12,116,,8,,10,36,20,144,45,6,6,,4,4,3,5,4,4,4,8,9,6,
   12,2,3,5,4,2,3,7,6,4,4,4,4,4,2,4,6,4,4,,4,5,5,8,
   13,4,7,8,3,3,4,20,7,6,10,4,5,6,5,7,23,4,5,4,7,4,
   8,4,28,10,9,7,7,7,7,6,4,4,3,4,4,4,4,6,8,4,3,4,4,
   5,9,8,11,,,4,3,3,3,4,3,4,3,12,3,3,4,,7,9,,3,8,4,
   12,4,3,4,3,4,3,4,6,4,4,4,6,4,3,7,10,5,4,4,4,5,6,
   6,7,7,8,,4,4,,3,7,4,6,9,4,8,7,10,4,,,5,8,4,8,4,4,
   4,3,6,3,4,7,6,4,4,4,4,4,,5,4,4,4,6,6,7,7,10,7,,6,
   7,6,4,,4,,9,4,4,3,8,,,9,5,9,3,9,4,4,3,3,8,4,7,9,
   3,3,2,4,4,3,,3,3,5,5,5,6,3,,5,,2,3,3,3,3,7,3,7,2,
   3,,,5,3,,2,7,3,9,4,3,7,2,3,2,3,7,3,4,4,3,3,3,3,4,
   4,4,4,8,,4,6,,2,3,3,4,3,4,3,7,4,4,,5,5,,7,3,7,3,
   7,4,4,4,3,4,2,7,4,4,3,4,,3,3,5,3,5,5,6,5,5,10,4,
   2,3,2,8,4,3,3,8,4,4,3,,4,,,3,8,10,10,3,4,3,3,6,2,
   5,5,4,4,,3,4,4,4,5,4,6,6,4,,5,2,4,2,4,5,3,4,6,3,,
   4,5,5,,7,3,9,4,7,4,4,4,2,4,2,4,4,4,7,,4,4,4,5,4,,
   11,6,,,4,4,5,3,4,4,4,7,4,4,4,5,4,,10,10,10,4,8,4,
   4,4,3,4,3,4,6,10,10,5,4,4,6,5,7,6,7,,,4,8,4,4,5,
   6,5,8,4,7,6,7,5,8,,5,11,5,11,6,8,6,3,5,3,4,5,3,4,
   9,6,9,7,6,4,5,,10,2,4,2,4,7,3,4,10,9,,12,,,,,3,,3,
   12,7,13,3,3,4,2,14,7,4,3,6,6,8,,3,,7,4,2,4,9,3,3,
   4,4,7,2,4,4,10,7,15,,3,12,3,,5,4,4,2,3,3,3,9,4,4,,
   5,,4,5,,4,3,3,3,4,3,4,3,7,3,3,4,6,,5,11,3,13,4,8,
   3,3,4,3,4,3,4,5,4,9,5,8,,5,,7,3,4,3,3,6,4,4,7,,5,
   6,8,,,6,4,8,4,6,4,4,4,3,3,3,3,5,6,5,5,6,10,5,,4,
   4,5,4,4,4,4,8,4,4,4,6,,10,7,6,7,4,7,4,4,4,3,4,6,
   5,8,,,11,,,,6,5,9,4,7,4,6,9,6,5,4,,,8,16,6,12,4,,6,,
   10,5,6,5,5,6,6,5,,6,,7,6,5,6,6,8,5,7,6,6,8,6,,8,,
   5,6,5,10,10,6,8,4,9,4,5,4,6,7,,,6,7,7,6,,6,,9,,9,
   11,6,,7,16,11,8,11,10,,7,6,5,7,5,9,6,5,9,,3,4,3,3,
   6,5,4,9,,8,,11,,,11,5,6,4,8,8,7,,3,3,3,19,5,7,,6,6,
   9,6,6,8,5,9,6,6,,6,,8,,4,8,5,12,7,6,8,4,7,4,5,8,,
   5,6,5,5,6,4,7,9,10,,9,,,,,6,,20,50,5,,5,4,6,,48,19,
   3,4,,7,3,3,4,,3,4,5,,,,,,,,,,4,,3,8,5,,,3,,3,,4,6,7,
   2,3,3,6,,3,7,2,7,2,7,6,3,3,2,6,2,3,5,7,4,6,4,,8,
   3,3,4,7,6,5,15,3,9,4,9,5,3,4,3,9,3,4,7,3,3,,3,9,,
   5,,6,,,9,3,7,,9,8,3,8,3,3,2,3,8,,4,4,8,4,5,6,10,4,
   ,7,4,7,18,7,4,4,4,3,3,3,3,6,3,3,,,,,,,,,3,,,,,3,3,,,
   2,,,4,7,3,5,,9,6,11,,4,6,10,6,5,4,3,3,4,4,5,7,,3,,
   4,,,,,3,,,,4,3,4,3,4,3,4,8,7,8,11,,,11,,10,7,9,9,9,
   8,7,6,10,6,7,7,3,4,6,,9,7,2,9,4,7,4,3,4,2,7,2,4,
   5,4,7,5,,15,3,8,5,10,4,3,4,3,8,3,,6,,5,,12,15,9,,
   11,4,4,3,4,8,4,8,12,6,,,5,9,9,9,7,10,10,,11,5,8,6,,,
   ,,5,,,,,6,,,5,5,,,,,11,8,100,13,167,15,3,,14,,,10,,13,,,
   60,,12,7,,10,3,13,5,3,4,2,4,2,5,6,13,10,9,9,6,6,9,
   7,11,15,10,4,4,3,10,10,2,4,5,10,18,7,7,8,6,6,10,4,
   4,3,4,3,4,6,4,3,4,3,4,10,3,4,4,9,7,3,2,3,4,3,3,
   13,3,4,5,4,4,4,6,4,4,7,4,4,4,4,3,4,5,8,4,10,,,4,
   3,7,4,,4,3,6,7,6,,7,,4,8,7,6,3,6,4,4,3,4,7,4,4,9,
   6,4,3,4,3,6,4,4,4,3,4,4,5,,,8,10,8,6,3,8,6,10,5,
   7,6,4,4,4,7,8,10,10,7,7,4,6,4,4,4,6,7,7,7,7,4,4,
   3,5,5,4,,3,2,7,4,7,3,5,,3,,3,2,3,3,3,5,3,5,3,2,5,
   5,7,4,,2,3,4,5,4,3,7,3,3,3,3,14,4,4,4,4,4,4,4,3,
   3,4,4,8,,,9,,4,3,5,4,8,4,3,4,3,4,,4,5,,5,19,7,4,4,
   3,4,3,4,4,4,12,4,5,3,5,,4,4,6,4,3,6,6,6,6,7,7,4,
   3,4,5,7,3,4,5,3,4,4,,6,7,7,6,6,5,5,4,4,4,4,6,4,
   5,5,4,5,,4,4,4,4,5,4,10,10,6,,5,4,3,4,3,5,4,3,5,6,
   ,7,6,6,,6,4,17,4,5,4,4,4,4,3,4,3,5,5,4,,4,3,4,4,
   4,,5,5,4,4,4,3,5,4,4,3,3,5,4,4,4,5,7,7,8,4,4,4,
   5,4,4,4,4,4,6,5,6,6,9,7,5,6,5,7,8,7,8,,10,6,4,8,
   5,8,5,5,4,6,4,5,4,5,6,,6,20,5,4,6,7,6,6,6,6,5,4,
   4,5,4,4,4,6,,6,11,,9,4,3,4,4,7,4,4,6,8,,7,,7,6,8,
   8,,4,6,4,5,4,4,5,5,12,6,4,3,4,4,10,,5,,11,4,4,3,5,
   4,4,3,3,10,4,3,4,9,,,,4,9,4,,4,4,4,4,4,9,5,26,4,4,
   ,7,,5,8,,4,3,3,3,4,3,4,3,6,3,3,4,6,,5,8,3,7,4,6,
   4,3,4,3,4,3,4,8,3,4,6,4,,9,5,5,4,2,4,4,5,3,2,5,,
   3,5,6,7,7,6,3,4,4,5,4,4,3,4,4,4,4,5,4,7,9,4,10,8,
   ,4,3,5,4,,4,3,8,4,4,4,7,,4,,7,6,3,8,4,4,3,4,4,13,
   4,7,,,5,,,,4,3,4,4,7,4,4,5,3,5,4,5,5,5,7,,,4,5,4,,
   4,4,5,,5,5,7,12,,11,9,7,4,9,4,11,4,6,7,7,4,4,7,6,
   4,6,7,6,4,7,7,7,7,7,7,7,4,7,10,8,3,5,3,3,3,4,3,
   5,3,6,3,9,8,6,,12,9,3,4,9,7,,12,8,3,4,12,9,6,6,,,
   5,4,6,6,12,5,4,9,,6,,,8,10,9,14,10,5,9,4,5,,5,8,5,
   10,7,,,8,5,11,8,17,5,,11,,,7,,7,7,9,,11,8,11,8,9,12,
   9,7,9,6,8,4,3,3,3,5,3,4,4,8,3,,7,8,,,,3,,,,8,,8,3,
   5,42,,,4,2,5,10,4,4,3,7,4,2,35,7,,,,,5,,,37,4,,4,7,
   61,101,,3,,4,,4,4,7,3,3,6,,,6,8,3,4,5,7,6,3,4,3,6,
   3,4,6,3,3,3,3,,4,3,2,3,4,5,4,5,2,3,3,4,3,3,3,3,
   3,3,3,4,6,3,,3,11,,9,,10,,,,3,4,6,11,7,3,5,6,4,3,4,
   9,,4,4,5,6,4,10,6,6,,6,4,3,6,5,5,4,4,4,17,4,3,5,
   4,3,,,4,7,,,,,3,5,12,,24,3,,,,3,5,10,3,5,4,6,,5,7,7,
   8,4,4,5,5,5,4,4,4,4,6,5,6,,3,,6,,7,,,3,4,3,,3,3,3,
   4,3,3,3,,6,4,5,,5,8,,10,6,5,5,7,6,9,7,19,6,5,4,3,
   4,7,6,8,7,3,7,6,6,3,3,4,3,8,3,6,6,4,4,5,,5,2,7,
   4,4,4,3,4,3,4,3,,4,5,7,,,10,7,,5,4,4,4,6,9,6,24,6,
   5,8,6,7,8,6,4,11,6,8,,18,6,6,4,7,6,,,6,5,,16,,7,38,
   ,6,5,7,,60,,6,5,25,,14,24,5,,6,,13,6,,8,13,32,8,27,
   9,6,,4,11,,21,3,7,3,4,3,5,8,11,6,9,7,6,4,3,7,10,
   20,5,4,4,3,5,6,4,4,5,7,6,9,7,13,6,5,4,4,4,8,4,4,
   4,6,4,3,4,3,4,9,4,4,9,9,7,6,3,4,6,4,3,6,4,7,5,6,
   4,7,4,4,5,4,4,4,4,4,3,4,7,7,6,,,6,4,10,3,8,6,8,9,
   5,,6,,,7,,4,7,4,4,3,3,4,4,9,5,9,8,5,5,3,7,7,4,,4,
   4,4,3,4,8,5,,6,,4,3,6,3,5,5,4,5,4,6,8,8,3,4,,6,7,
   4,4,3,3,10,3,6,4,3,15,5,4,4,4,4,4,4,4,4,4,4,6,,6,
   9,,4,4,11,4,8,4,4,5,5,6,,6,8,,7,9,5,4,4,3,4,4,4,
   6,5,6,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,4,,5,7,
   4,6,5,7,,,6,6,5,6,5,5,4,4,7,6,6,7,7,7,4,7,,4,4,4,
   3,4,4,7,7,6,,,4,3,6,3,5,4,3,6,5,,6,11,5,,8,4,8,4,
   6,4,4,4,4,5,4,3,7,7,4,,3,4,3,5,6,,5,10,,,4,4,6,3,
   4,4,5,6,4,8,8,7,,6,,7,7,4,7,3,4,4,3,5,3,4,7,10,9,
   6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,6,,6,,5,
   9,6,5,5,5,7,5,5,6,6,9,4,4,4,3,4,6,9,6,9,,,4,3,8,
   3,11,4,3,,5,,6,,5,,14,5,,4,10,4,4,4,4,8,4,5,11,5,4,
   3,3,8,,5,,,,4,4,6,3,5,4,4,7,4,9,10,9,,6,,5,12,4,,3,
   3,4,3,6,6,3,18,4,3,,6,,5,8,,,4,4,6,3,5,4,5,5,7,7,
   6,6,,5,11,5,7,4,5,3,4,4,4,5,4,4,6,4,4,5,6,,6,9,,
   4,4,,4,10,4,4,5,,6,,6,3,3,6,5,5,4,4,4,4,4,4,11,4,
   4,6,3,4,5,5,5,5,,4,3,5,2,5,4,3,4,9,5,9,5,,5,5,5,
   4,3,3,3,3,3,4,4,27,3,5,,,5,,,,4,4,6,3,5,4,4,7,10,
   9,8,9,,4,,4,12,4,9,3,3,4,4,6,6,3,9,11,5,,7,,5,4,6,
   3,7,4,5,5,7,6,6,7,,4,,4,7,4,4,4,4,15,6,6,8,5,8,7,
   6,,,6,8,8,5,7,6,9,7,6,7,10,6,,,10,8,6,8,8,,6,12,8,
   7,5,6,9,7,11,,5,4,9,9,13,5,4,5,,6,,6,,,6,11,7,5,5,
   4,5,,5,8,5,8,6,12,,6,7,8,5,8,6,8,8,7,6,9,7,,,,,6,
   8,8,10,5,15,8,8,,5,10,,7,9,7,5,9,6,10,5,13,,11,14,,,
   ,6,,,,7,,11,8,6,,100,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,5,
   ,6,11,6,,8,6,5,5,5,7,6,4,4,4,7,4,3,6,8,3,9,4,,7,
   5,,6,8,5,4,,4,6,3,7,4,4,3,4,6,4,3,7,9,51,,7,8,,10,
   ,10,,7,8,8,7,9,9,7,7,11,12,6,,5,6,,4,3,4,5,5,5,5,
   3,,5,4,4,27,3,2,2,4,3,6,3,2,5,,8,,,10,,,,,,6,6,36,
   144,20,5,10,,,4,4,45,4,5,5,6,,6,9,9,7,7,5,5,7,4,3,
   4,4,7,5,4,7,,5,,6,,5,7,,5,6,3,,4,4,3,4,5,8,3,26,6,
   ,7,,,,,5,6,5,18,4,4,7,7,6,7,12,14,7,9,7,5,4,7,8,7,
   5,4,8,5,5,,10,5,4,7,8,6,,,7,6,6,5,5,6,6,8,8,,8,,6,
   8,7,,12,6,6,,6,5,7,12,11,13,9,7,9,,,19,7,8,6,10,5,
   5,8,,,8,10,8,3,,,,5,,,5,,3,,,3,,6,,,,5,3,17,,,10,5,,6,
   36,,7,,5,,,33,,11,8,,7,5,4,4,4,7,4,7,9,6,9,7,28,7,
   4,6,7,6,6,4,7,5,4,4,3,5,23,4,4,6,4,4,14,5,10,6,6,
   8,2,3,4,4,4,2,5,4,4,,4,2,6,4,10,5,5,20,8,3,3,13,
   12,4,7,4,8,7,8,8,5,5,5,4,,4,5,5,5,5,6,5,,9,,5,5,
   6,6,8,5,6,5,8,,6,6,6,8,,5,6,5,5,4,8,31,7,6,6,5,7,
   8,4,4,6,4,4,3,4,4,3,5,4,,6,,,4,4,5,4,5,4,5,7,5,5,
   ,9,5,,,9,5,4,7,4,3,4,4,5,5,7,8,6,3,6,,4,4,6,4,3,
   6,5,7,7,8,6,5,3,4,7,7,3,6,7,3,4,4,,4,10,10,7,7,6,
   6,4,4,4,5,7,4,6,6,4,6,,4,4,4,3,3,4,5,5,4,,8,5,4,
   4,4,8,4,6,5,4,,,6,4,,8,4,11,3,5,3,3,3,3,7,4,11,7,
   5,4,,4,3,4,4,3,,5,5,9,9,5,6,6,4,6,6,6,5,4,3,3,6,
   6,8,7,7,7,4,5,4,4,4,4,6,5,6,6,5,11,4,4,4,5,4,7,
   5,7,,5,6,7,4,4,8,4,9,7,6,,4,,6,5,,5,6,5,4,4,28,8,
   5,7,4,6,10,4,5,3,4,3,3,,6,9,,6,,4,,,,,,,3,,6,,4,17,
   6,5,,4,4,4,5,4,,,5,6,6,5,4,4,4,6,,10,,11,14,8,3,,4,
   9,,,8,4,3,4,10,6,15,,5,11,4,,4,4,4,4,9,7,11,13,4,4,
   ,4,,4,5,,5,8,8,6,3,,5,9,7,4,4,3,5,,,5,5,7,3,4,4,
   4,4,4,8,9,5,5,4,3,6,5,,6,8,6,5,3,5,5,7,3,6,5,,4,
   4,6,9,9,6,5,6,4,4,4,4,4,5,6,7,7,6,4,5,6,6,6,9,,
   5,4,6,4,6,5,6,5,4,4,4,6,,9,6,6,6,4,3,4,4,4,3,6,
   6,6,6,,,,,,4,6,4,5,3,7,4,6,5,4,4,2,7,,6,7,4,8,3,5,
   3,2,4,4,6,7,6,8,4,6,,7,7,5,3,6,4,8,3,5,5,,,4,,7,
   6,7,4,5,4,4,4,7,8,7,5,7,6,7,5,7,13,8,5,7,7,5,5,
   6,6,5,10,6,,6,,9,13,12,15,9,8,,13,5,5,5,,9,7,7,9,,
   6,5,7,7,13,4,6,5,,,,6,8,13,5,,9,13,5,5,9,,8,7,12,
   15,5,10,,6,4,7,4,,6,8,7,,,5,10,11,7,9,,7,5,8,4,8,
   12,8,7,8,7,8,9,8,10,7,5,10,6,16,8,15,17,6,10,,,,10,,
   ,70,6,,,5,9,37,,26,6,4,11,6,7,7,7,7,6,4,,10,,,,,7,
   55,7,6,4,,4,7,5,60,25,8,,5,,5,6,5,,4,5,6,,9,8,6,5,
   8,7,31,5,4,5,7,5,6,6,7,4,10,6,,7,4,3,3,6,6,8,7,4,
   6,4,5,4,4,4,4,6,7,6,7,7,9,,10,7,,9,,8,,10,,8,7,8,
   8,12,5,4,8,8,,7,7,,4,,7,11,5,5,9,5,,8,4,6,28,5,3,
   3,4,4,10,5,6,7,7,7,,,6,7,,,,,7,6,,51,27,7,5,,,6,36,,,
   5,6,3,,5,7,7,8,7,6,7,7,8,4,4,4,7,4,5,5,,10,,7,,10,
   10,,7,7,8,,9,7,5,12,11,,7,,8,,5,,7,8,,6,5,7,29,8,7,
   8,29,6,6,5,6,4,4,,14,11,9,7,11,4,6,4,4,4,,13,5,11,
   9,3,,6,,,5,6,5,,4,4,4,4,6,5,,,6,4,,7,7,6,,,4,3,3,5,
   8,4,8,6,7,16,7,,7,7,12,5,8,9,,,7,7,11,9,7,,60,4,4,,
   55,6,7,47,,7,7,10,37,,,5,,,,,26,10,,9,6,49,7,,5,,27,51,
   ,7,6,,7,5,4,4,4,6,4,7,7,6,9,10,11,10,7,5,6,6,6,6,
   7,6,4,3,3,14,10,4,7,6,4,14,9,6,9,4,6,7,3,4,4,33,
   6,5,5,4,4,6,5,10,10,4,5,4,10,33,7,4,11,9,9,7,10,7,
   7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,
   4,,,4,,,3,4,4,4,4,4,,4,4,3,7,7,4,4,4,,,3,4,4,4,4,4,
   ,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,3,4,4,4,4,4,,4,4,3,
   7,7,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,3,3,3,3,3,,4,4,
   3,,,4,4,4,4,3,3,5,2,3,2,3,5,3,5,,4,3,4,5,4,,4,,,,
   3,4,4,3,4,4,5,4,3,4,4,4,5,5,,4,4,4,3,4,7,7,4,4,
   4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,
   5,,4,4,4,3,4,7,7,4,4,4,4,,,3,4,4,4,4,5,3,,,,3,3,4,
   4,5,4,4,4,4,,,,4,,,5,,3,5,4,5,,4,4,3,9,7,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,
   3,3,,3,,2,6,3,4,4,2,6,3,3,3,2,5,4,4,4,3,,,4,,3,2,
   3,3,4,3,3,3,,3,4,4,4,4,,4,3,4,3,4,3,6,3,3,3,3,5,,
   3,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,6,5,4,4,4,
   5,6,5,5,7,4,7,,,5,,,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,
   7,4,5,3,3,8,3,5,9,3,7,5,5,,5,,4,3,5,3,5,4,4,4,4,
   3,4,4,,4,,6,5,4,4,4,5,6,5,5,7,4,7,4,,3,,3,4,4,3,
   4,4,5,4,3,4,4,4,,5,,3,3,4,5,,4,8,3,4,5,4,,,5,,3,3,
   4,4,5,4,4,4,,4,,,5,6,,5,4,3,4,5,4,,4,4,3,4,7,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,3,6,5,5,,,,3,,9,,5,
   ,8,3,4,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,4,2,3,4,
   4,,3,,2,3,3,3,6,3,6,2,6,2,3,6,4,3,4,4,,4,3,2,4,4,
   4,4,,2,4,3,4,3,3,5,3,4,3,3,6,4,3,,3,,,4,,,,5,,3,4,
   5,,7,3,8,4,3,3,3,8,,4,4,4,4,4,6,6,3,,,4,3,6,3,3,
   2,5,3,4,3,2,6,,3,,,4,,,,,,3,4,11,6,13,3,8,,,3,4,11,,
   3,4,4,,,5,5,,4,4,5,6,5,4,7,7,4,5,5,6,,4,,,,5,5,,3,
   5,5,,5,3,7,4,3,3,3,8,4,4,,,5,5,,4,4,5,6,5,4,7,7,
   4,5,5,6,3,4,4,4,4,,2,4,4,3,4,3,6,2,6,2,4,6,4,4,4,
   ,,2,5,4,4,3,3,5,3,4,3,,6,3,5,,,10,5,,4,4,4,7,,9,5,
   9,6,5,,,10,5,,4,4,4,7,,9,5,9,6,4,,,11,4,5,,4,11,3,
   13,,3,8,,,9,,5,4,7,,7,5,3,,8,,,,,,,,,,,,,4,4,4,5,2,,2,
   4,2,5,,4,4,7,4,6,3,4,5,4,6,4,4,4,6,5,7,3,4,6,4,5,
   ,9,5,4,4,,3,10,3,6,4,3,6,7,3,3,3,2,16,7,6,7,16,6,
   4,2,3,7,3,3,10,3,7,7,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,
   4,4,5,4,4,4,4,4,,,4,,,3,4,4,4,4,4,,4,4,3,7,7,3,4,,
   ,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,4,4,3,
   4,4,4,4,4,4,4,,4,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,
   4,3,4,,,4,5,,5,4,4,3,4,4,4,4,4,4,4,,4,6,6,3,3,3,
   4,3,4,,4,,,2,3,3,3,3,3,4,3,3,4,,4,3,,,4,4,4,4,3,5,
   6,3,3,3,5,3,3,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,
   5,,,3,,3,,4,6,4,4,4,4,7,9,4,4,4,4,4,,,,,,3,4,4,4,5,
   4,4,4,4,,,,5,,,3,,3,,4,6,4,4,4,4,7,9,4,4,,3,,,3,,,3,
   3,3,3,3,3,3,2,4,4,,3,,,3,3,5,4,3,4,4,4,3,3,3,5,3,
   3,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,4,4,4,
   4,3,4,4,7,7,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,
   4,,4,4,4,4,4,3,4,4,7,7,4,,,,,,,3,3,3,3,4,3,3,3,4,4,
   ,4,5,,4,8,6,4,4,4,,4,3,4,6,5,4,3,,,4,,3,2,3,3,4,
   3,3,3,4,3,,4,4,,4,8,4,3,4,4,4,8,4,4,3,5,3,,4,,,3,
   4,4,4,4,4,4,3,5,3,,4,,,5,4,8,5,4,,3,5,4,4,5,,4,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,3,5,,6,
   3,5,4,3,5,4,11,4,5,3,7,4,,3,4,4,4,4,4,4,3,5,6,,5,,
   ,,5,,12,7,7,,5,4,4,6,,3,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,
   3,3,,3,,3,,,3,3,3,3,3,6,3,4,4,5,2,6,3,4,4,4,4,,3,
   3,,,3,4,,4,3,4,4,3,3,4,3,4,4,3,6,3,,,,4,4,,5,,5,,,
   5,4,4,,5,7,4,5,3,8,3,8,3,,3,4,4,5,5,,5,5,,5,4,4,
   6,5,5,4,4,4,4,5,6,5,,4,,,5,,,,,,5,4,,7,11,4,5,,,5,,
   6,4,4,5,5,,5,5,,5,4,4,6,5,5,4,4,4,4,5,6,5,,3,,,,4,,
   ,4,4,4,,3,4,3,4,4,3,6,6,3,3,,,3,,,4,3,4,6,3,3,6,
   5,4,3,6,3,4,,4,,,4,,5,4,4,3,4,5,,7,4,8,3,,4,5,,5,
   4,6,5,4,4,3,4,5,5,4,,4,,,,,,,,,,,,,,,,,4,,,3,5,4,3,4,
   4,8,,7,3,8,4,,4,,9,5,4,,9,,5,9,,8,3,,,,,,,,,,,,,,,9,5,,
   4,8,,5,7,3,8,,4,3,3,9,4,3,4,4,3,6,4,3,4,6,4,4,3,
   4,6,6,5,4,4,4,4,5,24,4,,4,4,4,9,6,5,3,6,4,4,4,7,
   4,4,6,3,4,4,3,4,6,5,4,4,5,,21,4,3,10,4,6,5,8,7,3,
   7,4,3,,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,
   ,4,,,4,3,4,4,4,,4,4,4,4,4,4,4,,,3,3,3,3,3,,4,4,6,
   6,2,3,3,3,4,3,3,3,3,4,4,,4,6,6,4,4,4,4,3,4,4,3,
   3,3,4,4,,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,
   4,,4,,,4,3,4,4,4,,4,4,4,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,3,4,4,4,4,,,,7,5,3,3,4,4,5,4,4,4,4,5,3,,4,,,
   6,5,,,4,5,3,4,4,3,8,8,4,3,,4,,4,4,,4,3,3,3,3,4,2,
   3,3,4,4,3,,,4,4,3,6,4,4,3,4,3,3,3,3,4,4,4,,3,4,,,
   6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,
   5,4,4,4,4,4,4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,4,4,
   6,3,4,4,3,3,4,3,3,5,4,4,,,,,,6,4,3,4,4,6,3,4,4,3,
   5,4,,6,5,5,5,7,5,5,4,,4,4,5,6,5,5,4,,,6,6,4,3,4,
   4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,
   4,8,6,3,3,3,3,4,3,3,3,4,4,4,,,6,6,4,4,4,4,,4,4,3,
   3,4,4,4,3,6,,4,3,4,4,6,4,4,4,,4,,,6,7,7,,4,4,4,6,
   5,,5,4,4,4,4,6,,4,3,4,4,6,4,4,4,,4,,,6,7,7,,4,4,4,
   6,5,,5,4,4,4,4,6,4,6,4,5,6,4,7,5,6,5,5,,,,,5,,,,6,,
   5,5,5,8,,,4,4,6,5,6,6,5,5,6,5,5,,,,,,5,,,8,5,,5,5,
   10,,,3,,4,,3,4,4,,3,3,,,4,4,3,3,3,3,5,3,3,4,6,2,4,
   4,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,
   4,8,,4,4,,3,,,,6,6,4,3,6,6,6,3,4,4,4,2,4,4,,4,,3,
   5,5,5,,4,,,4,4,7,7,4,4,4,,3,4,4,4,6,5,,,7,7,,,,,5,5,
   ,,9,5,5,,,6,,,4,4,3,3,,,4,6,6,4,3,6,6,4,3,4,4,4,4,
   6,6,,5,,5,,4,,,4,5,,,4,5,4,3,6,3,8,8,5,5,5,,4,,,4,
   4,7,7,4,4,4,,3,4,4,4,4,4,,4,5,5,5,5,4,4,4,4,4,,7,
   4,5,5,4,,4,,,4,6,5,5,3,3,4,5,5,4,,,,4,,,6,4,,,4,4,
   3,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,8,8,4,4,,8,6,4,10,,4,4,
   3,,,,,4,,,,,4,,,,,,,4,,,,,4,,,4,4,4,5,4,6,4,4,3,13,13,
   4,4,5,6,4,4,4,5,4,4,3,4,5,7,7,13,3,4,4,4,5,7,7,
   13,3,4,4,3,4,6,4,3,3,3,4,4,4,4,7,7,4,4,4,8,8,6,
   3,5,5,4,4,4,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,
   4,3,4,,,4,5,,5,4,4,3,4,4,4,4,4,4,4,,4,,5,4,4,3,5,
   4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,3,4,4,4,,4,
   4,4,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,,,
   ,3,4,4,4,4,4,4,3,4,,6,5,5,,,3,5,5,,4,4,8,3,4,4,,
   7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,4,4,4,
   3,4,4,4,4,4,4,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,
   4,4,,4,4,4,3,4,4,4,4,4,4,4,3,6,6,4,,,3,3,4,3,3,3,
   3,2,4,,4,3,,,3,5,6,4,3,4,4,4,3,3,5,6,3,,,,,,5,4,4,
   4,4,5,3,4,3,6,,4,5,6,,5,4,11,4,5,3,3,5,4,4,6,4,5,
   4,4,,,4,3,3,3,3,4,2,3,3,4,,3,4,4,,4,4,8,3,4,4,8,
   4,4,4,4,3,4,3,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,6,4,3,4,
   ,3,,4,4,6,4,4,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,6,4,3,4,
   ,3,,4,4,6,4,4,,,3,3,3,3,4,3,3,3,4,,4,4,4,,6,,4,4,
   4,4,8,6,4,3,3,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,
   4,4,3,5,,6,5,,,,,5,12,7,7,5,,3,4,5,,9,4,,4,,3,4,3,,,
   3,3,,,3,3,3,3,3,5,4,3,2,5,2,4,3,4,3,,4,,4,5,,5,5,
   5,,5,4,4,,4,4,4,4,4,4,4,3,4,4,4,,4,3,,,,3,,,4,4,3,
   8,4,6,4,4,4,4,2,4,3,,4,,4,5,,5,5,5,,5,4,4,,4,4,4,
   4,4,4,4,3,4,4,,,,,5,,,,,4,5,,11,9,5,4,,,3,5,7,4,3,3,,
   ,3,4,,4,4,3,8,4,4,3,4,4,4,4,8,4,,5,,5,,5,,,4,5,8,,
   4,4,4,8,3,4,3,7,3,,3,,3,,,3,4,6,5,3,6,3,5,4,3,4,4,
   ,4,4,,,4,5,,4,4,8,5,4,3,7,4,5,4,,,,,,,,,,,,,,,,,,4,5,,
   5,6,4,,5,5,4,4,5,5,4,11,4,4,,,5,,4,8,4,8,4,,7,4,5,
   4,,4,11,,5,4,,5,7,3,9,,5,4,,,,,,,,,,,,,,7,12,5,,4,,9,5,
   7,3,5,,4,4,4,4,4,4,3,4,5,9,6,4,4,9,3,4,4,4,9,3,
   3,4,4,3,3,9,9,4,3,4,4,9,6,5,4,3,4,4,3,4,4,4,4,4,
   3,4,4,4,4,4,9,4,3,4,9,4,4,2,4,4,4,3,4,4,4,4,5,,
   4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,4,4,
   4,3,4,7,7,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,
   4,3,4,,,,5,,7,,,6,5,4,5,5,3,4,4,12,5,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,
   ,5,5,7,7,4,4,3,4,4,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,
   3,4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,
   4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,7,7,4,4,3,
   4,4,4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,
   8,8,4,5,6,,,4,4,12,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,
   3,3,3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,5,5,5,5,6,4,5,,
   ,4,3,5,3,4,,,3,4,4,3,4,4,5,4,3,4,4,4,7,5,5,,,4,6,
   5,8,8,4,4,5,4,3,3,4,4,5,4,4,4,5,4,4,7,7,6,,,,,,,,,,
   ,4,4,,,,4,4,5,4,4,4,5,4,4,7,7,6,,,,,,,,,,,4,4,,,,4,,3,
   ,4,4,3,2,4,4,3,,4,4,3,3,3,3,6,4,4,2,5,4,3,3,,4,
   4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,4,,
   6,4,,,,4,,6,6,4,4,5,5,7,5,5,4,6,,4,4,,4,4,3,4,6,6,
   4,4,,4,4,4,6,3,3,4,4,3,3,3,4,3,4,4,,,6,6,,,,,4,4,
   8,6,10,4,4,,,4,8,6,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,
   4,5,5,5,,4,,,,6,6,,5,5,4,,4,4,4,6,4,5,5,7,3,4,4,,
   4,4,,4,4,3,6,3,4,4,5,3,3,3,4,4,4,3,8,6,4,6,6,4,
   3,4,4,4,2,6,4,4,3,3,4,6,,6,7,7,,4,4,4,4,6,6,5,,5,
   4,6,,6,7,7,,4,4,4,4,6,6,5,,5,4,6,8,6,6,4,4,3,4,4,
   ,6,3,4,4,6,6,,,5,5,,,,6,9,,5,5,6,,,,5,5,,,8,6,5,,5,,
   ,5,,5,,,10,8,5,5,,3,4,4,13,4,4,3,4,7,5,7,4,4,13,4,
   4,3,4,7,5,7,4,4,4,4,5,5,4,6,4,4,13,13,5,5,4,4,6,
   4,4,4,4,6,4,4,3,4,3,5,7,8,4,3,5,7,8,3,3,6,4,6,3,
   6,4,4,4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,
   6,,5,5,,6,,6,5,5,,6,6,6,5,6,5,5,4,6,6,5,,6,,,,4,5,
   6,4,5,6,6,5,4,5,6,5,7,7,,6,5,6,,6,9,11,5,5,6,6,,
   4,4,,3,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,4,4,
   4,6,5,5,5,4,4,4,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,,4,
   3,4,4,4,,3,4,4,3,4,6,3,3,3,4,4,3,6,4,6,4,6,,,3,3,
   4,2,3,3,4,3,3,3,3,3,,3,,6,4,3,4,4,6,4,3,3,5,3,6,,
   ,6,,,7,6,5,6,4,7,4,6,5,6,5,4,5,5,5,,6,,5,5,6,,6,
   6,6,6,5,5,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,
   4,4,4,6,5,5,5,4,4,4,4,3,,,4,4,4,3,5,4,5,4,4,4,4,
   4,,5,,3,4,4,3,,6,9,5,4,6,4,4,4,,,3,3,3,3,4,3,4,3,,
   4,,4,4,6,,4,4,4,4,4,6,,3,3,4,4,3,,,4,4,4,3,5,4,5,
   4,4,4,4,4,,5,,3,4,4,3,,6,9,5,4,6,4,4,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,3,4,4,3,4,4,5,4,3,5,6,5,,,,,5,9,3,7,8,,4,4,
   7,8,,4,,3,,3,6,4,2,4,3,4,,3,,3,3,3,3,5,6,3,4,6,4,
   3,4,4,4,,4,,3,4,,4,,5,5,,4,4,4,,4,7,4,7,4,4,4,3,3,
   6,,6,4,,4,,4,,4,,4,3,4,8,6,6,4,4,4,,3,4,,3,6,4,4,
   6,4,6,3,,,3,4,5,3,3,5,3,6,4,3,4,4,4,,,,,4,,,,,4,5,9,
   ,9,8,4,,,5,11,,6,4,3,4,,4,4,4,,4,3,4,8,4,5,4,4,4,
   4,4,8,,6,,6,,7,7,,5,5,6,,6,9,5,11,6,6,6,,4,,4,,5,5,
   ,4,4,4,,4,7,4,7,4,4,4,3,4,3,4,6,4,,3,8,4,3,4,6,3,
   ,6,4,4,4,4,3,5,,,4,10,6,4,4,7,4,,9,4,,3,4,4,,,5,4,
   ,4,3,5,4,4,4,4,6,8,5,,,4,10,6,4,4,7,4,,9,4,,3,4,,
   9,,4,5,,,6,5,11,,4,5,,7,12,,5,4,,9,13,7,4,,5,,,,,,,,,,,,
   ,4,4,3,5,6,4,3,4,6,4,3,3,3,24,,4,4,4,5,4,4,4,4,
   6,5,6,6,3,4,4,4,6,8,5,9,4,4,3,5,8,6,4,4,3,4,7,7,
   6,10,6,,4,3,4,5,21,4,3,4,5,7,4,4,4,4,4,4,4,4,4,4,,
   ,,,,3,4,4,4,5,4,4,4,4,,,,5,,,3,,3,,4,6,4,4,4,4,7,9,
   ,4,,5,,3,5,,5,4,4,4,4,5,3,4,3,,,4,,,6,5,4,,3,5,4,
   5,4,4,4,4,6,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,,,4,,7,7,
   6,5,,4,6,4,,4,4,5,7,7,6,4,4,6,6,6,,,3,3,4,3,4,3,
   3,3,4,,4,,,8,4,6,,4,4,4,4,4,3,3,5,6,4,,,,,,6,4,4,4,
   4,6,3,4,4,,,4,,7,7,6,5,,4,6,4,,4,4,5,7,7,6,5,6,,,
   6,4,3,4,4,6,3,4,4,,,4,,5,6,5,5,,4,5,5,9,6,6,5,5,
   6,5,,5,,,4,4,4,4,5,4,4,3,,,,,,6,7,,,6,5,,5,6,4,4,6,
   12,5,,,,4,4,4,4,5,4,4,4,,,,,,,,6,,3,6,6,6,,4,4,4,10,
   7,,,4,3,4,4,6,4,4,4,,,,,6,6,8,,,4,5,6,9,,6,4,4,14,5,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,5,6,6,5,5,6,,5,,,,,,,21,
   11,8,7,,5,5,10,22,,4,,4,,3,4,4,,,3,,,6,4,3,,3,4,5,4,
   3,4,6,2,5,4,4,,,4,,5,5,,5,,5,5,7,4,,3,5,4,5,3,5,,
   4,6,5,4,8,,4,4,,,,,,6,6,4,,6,6,6,4,4,4,4,2,6,4,,4,
   3,,5,,5,,5,,,4,,7,,4,6,4,4,3,4,10,9,6,,,,,7,,,,,5,,,
   19,9,7,5,,,6,21,,4,4,3,,,,4,12,6,4,,6,6,4,4,4,4,4,
   4,8,6,,5,,5,,5,,,4,,7,,4,6,4,4,3,4,10,9,5,,5,,4,,,4,
   ,15,7,4,7,5,,5,4,6,5,,4,,4,8,6,5,,4,6,8,6,4,,7,12,
   7,6,,,,,,,,,,,,,,,,,,,5,,,6,,,,5,6,9,5,5,4,8,8,,,,,,,,,,,,,,,
   ,7,5,11,,4,5,,11,6,4,10,,7,5,,,,,5,6,,,,6,6,,5,10,,,,
   5,,,,10,4,,,,3,5,5,6,4,4,4,5,8,8,,,,,,,,,,,,4,6,3,6,
   10,3,7,6,5,13,10,16,6,4,6,5,4,4,6,4,4,5,4,5,5,6,
   5,5,13,4,4,4,13,37,4,3,6,9,4,7,6,7,5,,4,,,5,,5,,,3,
   4,4,5,3,4,4,4,3,4,4,4,3,,5,,4,8,4,,5,3,3,4,3,,4,
   7,4,4,4,,,,6,8,3,3,3,3,4,3,3,3,,4,4,4,6,6,,4,4,4,,
   4,4,4,3,3,4,4,6,3,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,
   5,,6,9,4,,3,3,4,4,5,7,4,9,,,5,,,,4,4,5,3,5,4,4,4,
   4,4,4,4,,5,,6,9,4,,3,3,4,4,5,7,4,9,,5,,7,10,4,3,5,
   3,5,4,4,4,4,3,4,4,,4,,9,7,4,,,7,5,5,5,8,3,8,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,5,4,4,4,,,,,7,5,,5,6,6,,
   5,,,4,4,5,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,
   5,4,8,9,7,,,,,,13,,7,,,4,5,,,,4,4,5,6,4,4,4,6,4,4,6,
   14,,,,,,,,,3,,4,6,,,,4,,3,,4,4,4,2,4,4,4,,4,,3,4,3,,6,
   4,4,2,6,4,3,6,,4,5,,,5,4,3,3,5,6,6,,4,5,4,,4,4,4,
   4,5,5,5,7,4,4,,,,,,,,,6,,4,6,5,,7,5,5,12,16,,4,9,,4,
   4,4,4,6,6,6,4,,,4,4,6,,3,3,4,3,4,3,4,6,4,4,,,5,9,,,
   ,,4,5,11,,13,4,5,,,4,6,17,3,,4,,,,6,6,,4,6,5,,5,4,4,
   4,4,5,5,12,,4,,,,6,6,,4,6,5,,5,4,4,4,4,5,5,12,4,5,
   6,,5,5,,4,5,5,,5,5,4,7,4,4,4,11,4,4,4,8,6,,6,6,4,,
   4,4,4,2,6,4,4,6,,5,6,,,12,7,6,,4,4,8,4,6,5,,7,,6,,,
   7,6,,,4,6,4,6,6,5,9,9,5,,,21,7,,,4,5,3,,9,4,8,8,6,,
   ,19,5,,,,9,6,13,,5,10,,81,,,,5,13,9,7,6,5,,10,,,,,,,,,,,,
   ,,3,,5,4,4,3,4,6,5,17,5,,10,5,8,4,5,16,16,31,,4,5,
   4,5,7,4,7,8,,,,,,,,,3,4,4,6,7,4,8,,4,3,5,22,23,4,4,
   5,9,8,4,3,6,9,4,3,8,4,8,8,4,,4,,,4,,5,4,4,4,4,5,
   3,4,3,,,4,4,,,4,4,,4,4,4,3,4,4,4,4,4,4,,4,,5,5,,,4,
   4,5,3,4,4,4,3,4,4,4,3,,5,5,7,7,4,4,3,4,4,4,4,,4,
   4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,4,4,3,5,3,5,4,4,
   4,3,4,,4,,5,6,4,4,4,6,5,5,5,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,,4,,,4,5,,3,4,5,5,,4,4,
   4,8,4,,,4,4,4,3,5,3,5,4,4,4,3,4,,4,,3,8,4,3,5,,7,
   5,3,4,3,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,5,3,4,4,4,3,4,
   4,5,4,,,,,8,9,5,,3,,4,3,,9,9,3,,4,,4,,4,3,3,4,4,,5,
   5,3,7,4,4,,3,4,3,7,3,4,4,,4,,4,,4,3,3,4,4,,5,5,3,
   7,4,4,,3,4,3,7,3,4,4,4,3,,3,4,,,,4,,5,5,3,7,4,4,
   11,3,5,3,4,3,4,5,,3,4,3,6,6,4,4,,,3,3,5,5,3,3,2,
   3,4,3,4,2,3,4,3,,,,4,,,,,3,8,8,5,,3,4,,,3,5,7,4,3,
   4,4,,3,,4,4,3,5,4,4,8,2,4,4,3,8,4,4,,,,4,,,5,,3,8,
   4,,8,3,4,3,4,3,4,7,4,4,3,,,3,,3,6,3,5,6,4,3,6,3,
   4,3,4,3,4,4,,,5,3,7,6,4,4,3,4,3,9,3,,4,4,4,,,5,3,
   7,6,4,4,3,4,3,9,3,,4,3,,,4,6,5,,3,4,4,4,4,4,8,6,4,
   ,4,4,3,6,4,4,3,4,3,,6,4,4,4,,,,,,,,,,,,,,,4,6,,,4,5,
   12,7,7,3,5,,4,5,,4,,5,,11,7,6,5,3,,7,4,3,5,2,4,3,
   3,3,4,6,6,10,,,6,6,7,6,6,5,4,4,4,4,4,5,4,4,3,4,5,
   7,6,4,4,3,4,4,4,3,21,3,4,4,4,3,2,3,2,24,4,3,9,6,
   4,4,3,4,5,4,2,8,4,4,4,4,4,5,,5,5,,4,3,5,4,5,4,3,
   3,,4,,4,,,4,,4,4,4,4,4,3,4,4,7,7,4,,,,,,6,4,4,4,4,
   6,3,4,4,,,4,,7,7,6,5,,4,6,4,,4,4,5,7,7,6,4,,,6,6,
   4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,
   4,4,,4,5,7,4,4,4,4,5,3,4,3,,6,5,4,,,4,5,3,,4,,6,5,
   4,4,5,5,3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,4,3,4,4,6,3,4,4,
   ,4,5,6,5,5,6,,4,5,4,5,5,7,5,4,4,4,4,6,5,6,5,5,6,
   4,6,4,,,5,6,,,,5,,,8,,,5,5,5,,,6,5,4,7,5,6,6,4,4,,5,
   ,6,,,,,5,,6,,5,,5,5,,,9,4,,3,,4,4,4,,5,5,5,,,4,4,4,
   7,3,7,4,4,3,,3,3,4,4,4,6,3,,3,,,3,3,6,6,4,3,4,4,
   3,4,4,3,4,4,4,4,3,,5,,4,4,,5,,5,,,4,5,4,8,4,8,4,5,
   6,3,3,3,4,,4,4,4,,5,5,5,,,4,4,4,7,3,7,4,4,3,,3,3,
   4,6,8,,,7,7,,,,,5,5,,10,,5,5,,,4,4,8,3,3,,3,,3,6,6,
   4,4,3,6,4,6,3,4,4,4,6,6,4,,,,3,,6,6,,3,4,4,,4,4,3,
   4,4,4,4,6,,3,3,,4,4,,3,3,4,5,4,3,3,6,4,4,4,3,,,,,,,,
   ,,,,,,,,,,,4,4,,,4,4,12,5,3,5,6,4,5,5,,,4,4,,,4,12,4,,
   4,,4,6,5,5,8,8,4,5,5,4,5,5,4,6,4,4,4,,7,5,5,4,3,
   4,,,,4,,,,,,,,4,4,,,,4,,,,,,,,4,4,8,4,,4,8,10,6,6,4,4,,
   4,5,3,5,4,6,4,4,7,7,6,7,4,7,6,4,4,4,5,5,3,4,3,4,
   4,13,8,4,4,3,4,5,5,4,4,3,3,3,4,4,13,8,4,4,3,4,4,
   4,4,4,5,4,4,13,13,4,6,3,3,5,3,3,4,3,4,4,,,5,,,,4,
   4,5,3,5,4,4,4,4,4,4,4,,5,,6,9,4,,3,3,4,4,5,7,4,9,
   5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,6,5,4,4,4,5,
   6,5,5,7,4,7,6,6,,,5,6,6,4,5,5,6,4,5,6,5,4,,7,7,9,
   11,6,6,,6,5,5,5,,6,6,6,7,,5,4,6,6,7,5,4,4,,6,,6,,,
   5,,6,6,5,5,6,,6,6,9,11,5,7,,5,4,6,4,7,5,6,6,5,4,
   5,6,,5,,,6,5,6,5,6,,6,6,9,5,11,,4,4,5,3,4,4,4,3,5,
   8,5,4,,,,8,,9,7,3,,5,4,4,,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   ,4,,3,4,4,,4,,4,,5,5,7,4,5,5,6,4,4,4,7,6,5,5,6,3,
   4,4,,3,4,2,4,3,,4,4,5,4,3,3,4,4,3,4,4,6,3,3,6,,,
   6,6,,6,,6,,7,7,9,5,6,6,,5,5,6,11,,6,6,,4,3,3,6,4,
   6,4,,,3,5,3,6,3,3,3,4,4,6,6,4,3,,6,,,4,,,,,,8,4,8,
   11,24,4,5,,,6,9,9,4,4,,4,,4,,5,5,7,4,5,5,6,4,4,4,
   7,6,5,5,,4,,4,,,4,,6,4,3,,4,4,3,4,4,6,3,6,4,3,4,,,
   3,,6,3,3,6,4,3,4,6,4,6,3,4,4,3,4,,,5,7,5,,4,4,4,3,
   ,9,6,9,5,4,3,,,4,5,6,4,3,4,4,4,4,4,6,,3,4,,,5,7,5,
   ,4,4,4,3,,9,6,9,5,,4,6,6,4,4,4,3,3,4,,6,6,4,4,,,,,,
   ,,,,,,,,,4,,11,,4,5,9,,7,7,8,,4,6,9,4,,5,8,24,11,9,8,
   4,,7,6,5,6,6,,6,7,6,13,7,5,8,8,4,4,3,4,13,3,4,4,
   4,4,3,5,5,6,4,3,4,5,24,4,6,6,3,4,3,3,4,4,,4,4,4,
   4,3,6,5,5,4,4,6,8,4,4,5,8,6,7,4,6,7,7,4,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,6,3,
   4,4,,,,,7,9,6,9,,4,6,5,,,4,6,8,9,6,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,5,6,4,12,6,,,
   ,,10,14,,31,4,,4,6,20,9,27,,,4,,4,3,,,,4,,,5,,5,9,4,,
   7,3,4,4,6,10,4,9,,4,,4,,5,3,3,4,5,5,5,7,4,8,4,5,
   3,3,4,3,8,6,4,5,4,8,,,,,,,,,5,,7,9,4,8,8,3,5,13,5,,
   4,,,3,4,4,6,6,4,6,6,,4,4,6,5,4,3,2,3,4,8,5,2,4,6,,
   ,,,6,,,,,6,10,12,,29,4,4,,,12,5,11,4,4,4,4,,4,12,4,6,
   6,6,4,6,6,2,4,4,6,8,4,6,,,,4,,,5,,5,9,4,,7,3,4,4,
   6,10,4,9,6,5,4,,,4,,5,7,4,7,15,,4,8,,6,4,5,,4,,6,9,
   9,5,9,6,6,4,,4,,9,7,6,6,4,5,5,,7,4,8,6,5,3,3,5,3,
   8,6,,5,4,12,,6,6,6,,4,4,,4,4,6,6,6,6,5,6,5,5,9,5,
   5,7,,4,,,6,6,5,7,,,,6,5,,,,8,,,6,5,5,12,14,,5,4,,7,7,
   8,7,,5,,,5,,,,16,10,,,4,,8,5,23,4,4,,4,6,6,6,9,7,21,
   14,,8,8,8,11,7,31,5,4,,4,4,7,5,4,4,,,9,8,15,6,4,5,
   3,4,3,7,7,3,6,,3,4,,2,,4,4,9,6,5,,6,4,6,10,5,16,7,
   ,5,4,,10,7,4,4,4,3,5,3,5,4,4,4,3,4,,4,,7,5,4,,,9,
   7,5,5,5,3,5,,6,,4,3,4,4,6,3,4,4,,4,,,5,6,5,9,6,4,
   5,5,5,,5,6,4,6,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,4,6,
   4,7,5,6,12,4,6,,,,6,,14,8,8,,6,6,6,8,14,8,5,4,7,4,
   6,6,5,5,6,4,12,6,,,,,6,14,8,8,6,,6,6,,12,,4,,4,,4,,3,
   ,4,4,,,4,,5,5,4,7,7,5,5,6,6,4,4,4,4,3,6,3,,4,4,2,
   3,4,6,4,6,4,6,3,4,4,6,4,6,6,4,3,4,4,10,,6,,,4,,,,4,
   ,7,5,4,8,8,5,7,9,5,,4,,,3,4,4,6,4,4,6,4,,4,4,4,5,
   3,3,4,4,8,8,4,2,4,6,10,,,6,6,,,,,6,6,12,,,6,6,,,8,
   14,8,4,4,4,3,,4,6,4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,
   4,,,4,,5,7,4,,,7,5,5,9,8,3,8,,4,4,,,4,,5,5,4,7,7,5,
   5,6,6,4,4,4,4,4,3,4,6,4,5,6,4,4,4,5,5,,12,4,6,4,
   3,4,6,,6,4,8,4,4,4,6,4,6,6,4,,4,4,6,,6,8,4,,4,4,
   4,6,6,6,6,6,6,4,6,4,5,6,4,4,4,5,5,,12,4,6,4,4,3,,
   ,4,,,,,6,,,4,,4,12,10,,4,4,10,8,12,8,4,,4,,,4,,,,,6,,,
   4,,6,5,4,4,4,9,4,6,7,6,7,5,11,11,9,4,4,6,4,5,4,4,
   4,5,5,6,7,3,3,3,3,4,11,7,7,4,3,4,4,11,7,7,4,3,4,
   6,6,4,11,5,11,6,4,7,7,7,9,4,5,4,11,5,11,4,3,4,4,,,
   4,4,4,4,5,4,4,3,,,,4,,,5,6,4,3,4,,3,,4,4,6,4,4,,,4,
   4,4,3,5,4,5,4,4,4,4,4,,5,,3,4,4,3,,6,9,5,4,6,4,4,
   ,3,4,4,4,4,4,5,6,3,,9,8,,,,3,,,,,,,3,4,,,,5,6,6,4,5,
   5,6,4,5,,7,6,,,,,,13,7,,,,5,4,,,,,,4,,5,,4,3,3,5,4,,5,
   5,3,4,4,4,,3,5,3,7,5,4,4,3,4,4,,,4,,,,4,,6,6,4,4,
   5,5,,4,6,4,4,,4,4,4,4,,,4,,,,4,,6,6,4,4,5,5,,4,6,4,
   4,,4,4,,4,4,3,6,6,6,4,,,4,4,4,6,3,,4,4,4,3,4,4,3,
   5,4,,,,6,,,,,4,5,8,6,,4,5,,,5,8,7,,4,5,6,,4,,6,6,4,
   6,5,5,,4,5,5,4,9,6,6,,,,,,,6,,5,5,4,,,4,6,16,12,,5,
   7,4,4,4,,,4,,4,4,3,6,,4,4,6,3,4,3,4,,5,4,,,5,3,9,,
   4,,6,5,3,9,5,6,4,,4,,,5,4,10,6,4,,3,6,6,7,6,,4,4,,,
   6,8,9,,4,,4,5,6,6,9,,6,,6,8,4,8,4,4,,4,4,,6,4,4,4,,
   ,,,,,,,,,,,,,6,,44,,5,,21,11,8,6,7,,5,7,,5,,,50,,10,8,7,
   5,,,5,3,,4,5,3,4,11,9,3,4,4,,4,8,4,4,5,4,3,4,,3,5,
   5,5,6,4,4,,5,10,6,5,6,4,4,,,,,,,,,4,3,6,3,11,5,4,13,
   10,38,4,4,4,5,8,3,4,5,5,4,6,,4,3,4,4,6,4,4,4,,4,,,
   6,7,7,,4,4,4,6,5,,5,4,4,4,4,,5,6,5,5,6,4,6,4,,6,,
   6,,,,7,,21,8,11,,,5,5,,44,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,
   5,4,4,,5,,5,,,4,5,4,4,3,8,4,,5,,3,3,4,4,4,6,4,,3,,,
   ,3,6,8,4,4,4,4,3,4,4,,4,4,4,4,3,3,,,4,4,,5,,5,,,5,
   6,4,6,5,9,4,,3,4,3,4,4,,,4,4,,5,,5,,,5,6,4,6,5,9,4,
   ,3,4,3,4,4,,8,,,7,,,,,,7,5,50,10,,5,,,,7,,8,4,4,,5,,
   5,7,10,5,5,3,9,5,7,4,,,5,7,5,5,,,,,,6,8,,4,4,4,,4,4,
   ,4,4,4,8,6,,3,,,4,6,,4,3,4,6,4,3,,6,4,4,4,3,,,,,,,,,,
   ,,,,,,,,,,4,,,5,6,12,5,4,6,6,,5,5,,,4,,,,,,,,,,,,,,,,,6,7,
   4,,5,4,16,6,4,,,7,5,5,12,,5,,,,5,,13,,7,,,,4,7,,,,6,,,,,
   ,5,,6,5,8,4,,5,8,,6,7,4,5,,5,6,4,13,6,,6,5,11,5,8,
   3,4,10,4,,4,4,9,4,3,4,,3,,5,11,4,4,3,5,5,,6,5,3,4,
   4,5,,10,38,5,8,4,,4,4,5,4,5,,,,,,4,3,4,5,3,3,4,,4,4,
   ,5,6,5,4,6,4,7,5,5,6,5,5,,,,4,,14,31,,,10,6,4,11,7,
   5,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,,3,4,5,3,,4,,3,3,3,4,
   8,5,7,,8,3,4,3,4,3,6,4,,4,4,2,4,4,6,4,8,2,4,3,4,
   4,6,6,6,4,4,3,4,4,,,,3,,4,,,,5,,3,4,5,6,9,5,9,6,4,
   3,4,4,,4,4,4,6,4,6,6,4,,5,,3,6,3,4,4,6,8,4,4,2,4,
   ,8,,,6,,,,,,4,4,11,18,23,6,10,,,,14,7,,,5,4,,6,7,5,10,
   ,4,5,9,7,4,8,8,,7,5,5,,,,,,,5,,3,5,5,,,7,9,5,13,5,
   3,11,,4,,,,5,,3,4,5,6,9,5,9,6,4,3,4,4,4,5,,5,6,6,
   3,5,5,4,5,5,7,,9,3,6,3,4,4,6,,8,2,6,4,4,4,6,6,6,
   4,4,,4,,7,,8,,5,,13,5,4,8,8,,7,9,5,,,,3,5,4,4,9,5,
   12,,9,3,9,4,5,,,16,5,,,,,,19,,4,,7,,9,,4,5,10,11,12,5,
   4,,5,,,6,,,,,,,5,6,,,,3,,4,,4,,3,,3,4,4,9,,8,4,4,6,4,
   3,4,5,5,7,6,7,3,4,4,,4,14,7,6,4,3,4,23,21,8,8,5,
   4,8,8,6,4,15,5,8,8,8,21,10,8,,4,5,4,4,3,4,4,,4,4,
   4,5,4,4,4,5,4,4,7,7,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,3,,4,
   5,,,,3,,7,7,,,4,3,8,,9,5,4,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,
   5,4,,,5,,6,,5,,,,4,,10,12,11,,5,4,5,,9,5,,4,,5,7,5,5,
   7,,,,4,,,6,3,,4,5,5,7,12,7,4,,,,,5,,,,,4,,,,,,4,,,,,,6,
   4,4,6,,4,,,,4,,10,12,8,,4,4,4,12,10,8,,,,6,,,,,5,,10,,
   10,,4,,,,,,5,,4,,,,,4,,11,,7,,4,8,5,7,9,3,,5,6,,,,3,,
   13,7,9,,5,3,10,81,,5,7,,,,,6,,,,,,6,5,5,,,6,5,,,,7,,,7,
   7,,4,5,5,12,14,8,,,,5,,19,,6,,5,,10,8,,4,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,10,15,6,,5,3,4,10,11,3,,,,,,,,,,,,,,8,
   11,19,,,,8,,18,10,18,,,,,7,3,8,,,,,,,,,,4,3,18,19,8,5,
   15,10,6,18,8,7,,8,,4,,5,,,5,5,3,4,,5,,,,,3,7,3,11,4,,
   3,8,6,11,13,6,4,4,4,,4,4,2,6,4,,,,,4,8,4,6,4,,4,4,
   6,8,10,,,,,,,6,,,,,,,4,,,,5,,,,,16,19,,,5,5,7,5,5,7,,,,,4,
   ,5,6,3,,5,5,7,,11,3,4,,,4,,,,,,,4,,6,,4,,,,6,,,4,,,4,,,,
   ,,,4,,6,,4,,,,6,,,,5,,5,,,,,,5,9,,9,4,,5,4,6,8,14,5,4,,
   ,,,,,4,9,6,9,4,,8,5,11,8,24,4,,6,,,,,6,,3,9,4,,3,10,
   7,19,13,7,5,,,,,7,11,4,6,4,,4,5,6,,10,,,,,,6,,,,6,,5,5,
   ,,,,,,,6,,4,8,5,,,10,11,14,153,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,8,7,18,5,,3,4,22,22,13,,,10,,11,36,,,,8,
   6,,19,5,,,,15,,7,10,,,,,4,3,6,26,19,,,,,,5,5,18,18,8,9,
   12,,,,,4,,4,,4,3,3,4,4,,5,5,3,7,4,4,,3,4,3,7,3,4,4,,
   ,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,4,7,3,7,4,4,3,
   ,3,3,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,5,5,7,4,5,5,6,4,
   4,4,7,6,5,5,,,,4,,,5,,5,9,4,,7,3,4,4,6,10,4,9,,4,4,,
   ,4,,5,5,4,7,7,5,5,6,6,4,4,4,3,,,,,3,2,,,2,,3,,2,,2,
   ,3,4,4,,,5,3,9,5,4,,3,4,3,7,3,,4,4,,,5,9,3,,3,8,4,
   3,5,7,,7,5,,5,3,3,4,3,4,7,5,5,,8,3,5,3,,,,,,,,,,,,,,,
   4,7,7,,3,8,9,5,,,3,,4,4,7,3,,8,11,13,6,11,3,4,,3,3,
   2,7,3,4,2,7,2,5,3,2,3,16,4,3,2,7,5,4,3,3,7,4,3,
   5,16,2,4,3,7,5,5,5,7,2,3,4,6,10,,6,,6,6,4,3,6,3,
   4,7,4,6,5,7,6,,2,3,5,,6,10,3,4,4,4,4,,,4,,,,4,,6,6,
   4,4,5,5,,4,6,4,4,,4,4,,4,,4,5,,5,5,5,,5,4,4,,4,4,
   4,4,4,4,4,3,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,6,6,6,
   4,4,5,5,5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,,5,5,,
   4,4,4,,4,7,4,7,4,4,4,3,3,4,4,5,7,5,3,8,5,4,3,3,
   4,3,8,3,5,4,,,4,,4,2,,,3,3,3,,3,,3,,,4,6,,6,6,5,,4,
   4,5,4,5,5,5,7,5,5,7,5,3,8,5,3,4,,4,,8,4,5,6,6,6,
   10,,5,5,,4,8,4,,,5,5,6,8,,,5,5,,6,,,5,,5,6,,5,,5,,9,,
   ,5,5,,4,4,3,4,3,3,3,4,3,5,4,7,5,8,4,3,4,3,13,4,
   4,4,4,5,3,5,7,4,6,4,4,7,6,7,5,4,4,6,3,4,3,8,6,4,
   4,4,3,4,3,4,13,4,3,5,5,4,4,3,4,13,13,4,4,4,4,4,,,
   4,4,,5,,5,,,5,6,4,6,5,9,4,,3,4,3,4,4,,3,,,4,,,,,,3,4,
   ,,,3,,,,3,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,9,5,,12,3,9,4,
   4,3,4,9,,4,,,,5,,3,4,5,6,9,5,9,6,4,3,4,4,,,,,,,,,,,,,,,
   ,,,,,4,,,6,4,14,9,6,,4,6,5,5,3,,4,,,,,,,,,,,,,,,,,,7,8,
   5,4,7,5,9,5,,,11,3,5,13,,,,,,,,,,,,,,,6,11,7,,6,10,14,,
   31,5,4,,4,,14,6,,10,11,23,18,,4,4,,4,15,4,21,3,5,4,,
   3,6,4,5,5,10,4,4,3,4,,4,3,6,8,5,23,4,8,4,,4,8,6,
   16,7,4,4,4,,7,21,14,8,,8,8,5,4,4,3,4,7,,8,,9,8,4,
   3,4,6,3,3,4,3,,4,,,,,,,,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,5,
   4,4,6,5,5,4,4,4,4,5,6,5,,5,,5,,5,,,4,,7,,4,6,4,4,
   3,4,10,9,5,5,5,,4,,,4,4,7,7,4,4,4,,3,4,4,4,6,6,6,,
   ,5,6,6,9,4,11,5,6,4,,5,4,5,6,6,7,,7,5,6,,5,5,6,5,
   5,5,6,,6,6,7,,7,6,5,,6,6,5,6,5,5,6,,6,5,,,6,6,9,
   11,5,6,6,,,5,5,6,,4,8,8,8,3,,5,7,3,,,3,4,,,,,,,,,,,,,,
   5,9,8,,3,9,9,,,4,3,,4,10,3,4,3,4,4,4,6,5,7,6,4,5,
   4,3,4,4,4,4,4,7,7,6,5,6,,6,,6,3,4,6,7,5,3,2,4,2,
   8,4,21,4,2,3,4,4,4,4,2,6,4,4,5,24,4,3,3,3,9,3,4,
   4,3,4,4,4,,,4,,,,,,,4,,6,,4,,,,6,,,,,,5,,,,,3,,,,,3,4,,,3,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,,4,,,,,,5,,,3,,10,,,,,
   ,5,,10,16,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,4,18,5,18,3,5,,,3,10,7,26,18,19,5,3,,,6,10,15,,,
   22,9,,,,,,,22,8,,,,,,13,12,,,,,,4,,,3,5,18,,,5,36,10,,,,,,,
   ,4,8,,,4,,,,6,6,,4,6,5,,5,4,4,4,4,5,5,12,4,4,,,5,5,
   ,4,4,5,6,5,4,7,7,4,5,5,6,4,,4,10,7,5,8,4,7,5,5,4,
   ,,8,9,7,5,,4,6,,6,5,6,9,6,6,4,5,5,5,5,,5,,,,,,,,,,,,,,
   ,,,5,7,10,8,4,7,5,5,4,,,8,5,7,9,6,6,,12,6,6,,14,8,
   8,,,6,6,6,8,14,,6,6,14,8,8,8,6,,6,8,14,6,,6,12,,,8,
   6,6,,4,11,4,7,3,4,4,3,7,4,11,5,5,7,3,3,3,4,6,5,5,
   6,6,5,4,4,11,4,9,4,6,6,8,8,4,4,4,9,5,11,11,7,9,4,
   4,4,4,3,5,5,7,3,4,4,11,7,4,4,11,7,7,4,11,6,6,6,,,,,
   ,,,,,,,,,,,,,,,,4,,14,7,,4,8,5,,3,,4,,8,4,5,9,,,,,,,,,,,,,,,
   ,,,,6,,,6,6,,,4,5,7,5,5,5,9,,,,,,,,,,,,,,,,,6,,11,14,5,,,
   4,8,4,153,,5,10,,8,,,,5,19,6,,4,5,,10,,,,,,,,,,,,,5,8,,
   6,3,4,4,4,3,5,11,7,,7,5,4,8,,27,6,10,,4,4,3,5,6,4,
   ,8,,,,,,,,,5,6,9,4,,4,8,4,,4,3,4,21,4,3,5,8,6,4,3,
   12,44,4,3,13,4,8,8,4,4,,6,5,,4,4,5,7,4,5,5,,11,4,
   5,4,4,,5,,,4,6,7,,5,15,4,7,5,4,,5,,5,,,6,4,,8,4,4,
   15,7,5,5,7,,,,,,,,,,,,,,,,,4,,11,8,4,8,,9,9,6,24,,4,5,,
   7,9,,8,4,11,7,,3,4,,5,,,,,,,,,,,,,4,8,5,6,3,4,6,4,3,
   5,4,5,6,5,4,3,6,4,5,4,3,7,4,3,4,13,8,3,4,4,7,13,
   7,6,6,6,6,,4,6,7,4,4,3,4,4,7,4,8,5,8,7,4,6,5,4,,
   5,6,6,4,3,3,4,4,4,4,4,,,5,3,7,6,4,4,3,4,3,9,3,,4,
   4,,,5,7,5,,4,4,4,3,,9,6,9,5,4,6,4,5,6,4,4,4,5,5,,
   12,4,6,4,,4,,,3,4,,,,,,,,6,5,,,,4,,13,7,,,,,5,4,10,4,,
   5,11,13,,17,3,5,,6,15,2,5,3,7,2,8,2,16,3,22,5,9,7,
   4,4,8,7,16,5,4,,5,3,,23,4,5,3,4,5,5,,9,2,4,4,4,4,,
   8,4,8,4,4,3,8,3,5,7,,8,5,10,6,,2,4,,8,6,7,,4,5,4,
   6,,6,7,7,,4,4,4,4,6,6,5,,5,5,,,4,10,6,4,4,7,4,,9,4,
   ,3,,6,10,22,7,5,,4,8,4,,,,5,,,,,,,,,,,,,,6,21,7,,5,,9,9,
   ,5,,,7,5,3,4,3,4,3,5,3,,4,5,6,13,7,5,6,,8,,7,5,5,
   6,4,13,13,6,,6,4,6,6,8,9,4,,4,3,4,3,37,4,,4,4,3,6,
   3,,10,5,4,5,,4,5,3,,6,6,,6,,4,,5,,,10,5,,4,4,4,7,,9,
   5,9,6,,6,20,9,,4,,14,31,,27,,10,6,,,,,,,,,,,,,,81,15,,,4,
   12,29,,11,6,10,,7,,6,9,5,7,6,,6,11,10,,5,6,4,4,4,5,
   6,7,5,,,,,,,,,,4,4,7,8,6,4,8,,4,4,9,5,,8,4,4,5,4,5,
   7,7,,6,4,14,7,5,23,21,15,9,31,16,8,6,8,5,4,8,16,4,
   5,,9,9,,14,,5,4,,,,,,4,10,10,,,5,,,,,3,,4,,,,,3,,,6,5,3,
   5,4,,,8,3,27,4,7,12,8,,4,,8,5,6,5,,4,4,5,,21,3,5,4,
   4,5,9,,44,4,8,4,3,6,,6,4,4,3,4,,8,8,7,6,,8,6,7,4,,,
   ,,11,10,13,5,4,,4,,,,4,,,,,,,,4,,,4,,,,,6,,,4,,,18,26,,,,,,
   ,29,9,26,18,,,,,,,22,9,4,,10,15,6,19,,5,3,,10,19,6,18,
   ,3,5,,,,,,,,,4,,,5,36,8,,,18,10,,,3,5,,15,12,,,4,,,,,4,,,,
   ,4,,,,,15,18,,,,8,10,,18,,10,19,,,,,11,,8,,,,,,,,,,4,11,
   12,18,6,3,,5,8,7,18,8,5,,3,,,,10,,19,8,,19,,14,,15,,
   18,3,,7,,4,,,7,,5,,,,8,5,19,,8,,36,,,,,11,10,,,4,22,13,
   22,18,3,5,,,,,,,,,,9,12,8,10,5,3,,,,,18,26,,,,18,19,,,5,
   6,,8,15,,4,,,4,4,13,4,4,3,4,7,5,7,4,5,4,4,8,11,8,
   6,6,4,4,7,5,4,2,4,3,4,6,4,7,7,7,6,4,3,3,3,5,5,4,
   4,7,13,9,4,2,8,4,7,4,11,7,7,13,4,7,4,2,5,7,5,4,2,
   11,6,6,8,5,8,4,4,7,6,5,8,13,6,10,4,4,4,6,4,7,3,3,
   7,6,4,4,4,4,4,13,4,4,5,4,4,4,5,7,7,13,3,4,4,4,4,
   13,8,4,4,3,4,5,6,4,4,6,4,10,4,7,4,13,4,6,7,5,7,6,
   4,3,4,4,11,7,7,4,3,4,13,7,7,8,5,13,8,6,6,8,9,7,4,
   4,7,4,4,6,3,4,4,4,3,4,4,2,10,11,6,6,6,6,9,3,4,6,
   9,4,6,4,4,3,4,3,5,7,8,4,3,4,13,4,2,6,4,11,7,4,4,
   11,7,6,10,6,13,7,8,3,4,6,3,4,5,3,11,4,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,4,6,12,6,6,6,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,6,,,6,,,8,,,,,
   8,6,4,8,8,,4,8,,8,,,4,4,4,6,6,6,6,8,12,16,4,4,4,4,
   4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,
   6,8,6,,,6,12,12,,6,12,,12,,,12,6,18,6,6,24,12,18,24,
   30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,,,,,
   ,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,
   4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,4,4,4,4,
   6,6,6,4,6,4,6,6,4,,4,4,,4,,,8,8,12,4,12,16,8,12,16,
   20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,
   ,,,,,,,,,,,4,4,,4,,,8,8,12,4,12,16,8,12,16,20,4,8,8,4,
   8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,
   4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,
   4,,4,,4,4,4,,,4,4,,,,4,4,4,4,6,6,6,4,6,4,6,6,,4,,,
   8,8,12,4,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,
   ,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,4,12,16,8,12,16,20,4,
   8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,6,6,6,8,8,8,
   4,4,4,4,4,4,,,6,6,8,,8,8,8,,,,4,6,,6,,8,,8,,,8,8,,,,
   4,4,4,4,8,20,8,20,8,20,20,8,4,4,4,4,6,6,6,8,4,4,
   4,4,4,4,,,6,6,6,12,6,8,8,,,,4,6,,6,,6,12,6,,,4,4,,,,
   4,4,4,4,16,8,6,20,16,20,8,6,6,6,6,8,10,10,10,4,4,
   4,4,4,4,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,8,8,,,,4,4,
   4,4,22,22,8,,22,,22,8,4,6,4,4,4,8,4,6,6,4,6,6,,,4,
   4,6,4,6,4,4,,,,4,4,,4,,6,4,6,,,12,12,,,,6,4,4,6,6,6,
   16,4,6,4,6,16,6,6,6,6,10,4,6,6,4,6,6,,,6,6,6,,6,8,
   8,,,,4,6,,6,,6,,6,,,,,,,,6,4,4,6,16,8,16,22,16,22,8,
   16,8,10,10,8,4,6,6,4,6,6,,,12,12,8,28,8,,,,,,4,12,,12,
   ,8,28,8,,,,,,,,6,4,4,6,46,14,8,30,46,30,14,8,4,6,8,
   4,6,6,4,6,6,,,6,6,8,8,8,12,12,,,,4,6,,6,,8,8,8,,,,,,,
   ,20,20,20,20,8,16,8,4,8,4,16,8,6,10,4,8,8,4,8,8,,,
   6,6,16,8,16,,,,,,4,6,,6,,16,8,16,,,,,,,,,22,22,,8,16,22,
   4,8,4,16,22,8,4,12,12,4,12,12,,,6,6,8,,8,,,,,,4,6,,6,
   ,8,,8,,,28,28,,,,30,14,14,30,8,8,46,14,8,14,8,46,6,
   16,16,6,16,16,,,16,16,6,,6,8,8,,,,6,16,,16,,6,,6,,,,,,,,
   16,14,14,16,,14,,16,,16,14,,4,4,2,4,4,,,4,4,4,4,4,4,
   4,,,,2,4,,4,,4,4,4,,,4,4,,,,4,4,4,4,6,6,6,4,6,4,6,
   6,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,
   4,4,8,,,6,8,6,,,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,
   ,,,,,,,4,4,4,4,8,,,6,8,6,,,4,4,,,4,4,4,4,4,4,4,,,,2,
   4,,4,,4,4,4,,,4,4,,,,4,4,4,4,6,6,6,4,6,4,6,6,4,,,6,
   6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,6,8,6,,,,
   ,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,4,4,4,4,8,,,6,8,
   6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,6,,,6,,,8,,,,,8,
   6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,6,,,6,,,8,,,,,8,,4,8,8,,,
   ,4,6,,6,,4,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,10,8,,,,,,
   ,4,,,,,,4,,,,,,,,,,16,16,,8,,12,12,8,12,,12,8,8,,,,4,6,,
   6,,4,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,10,8,4,,,,4,,,,,
   8,,8,,,,,,,,8,12,12,8,,8,,16,,16,8,,,,,4,,,,,8,,8,,,,,,,,
   8,12,12,8,,8,,16,,16,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,,,
   4,4,4,4,6,6,6,4,6,4,6,6,,4,,6,,6,,,8,8,,,,6,,,6,,,8,,
   ,,,8,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,6,,,6,,,8,,,,,8,,,,
   ,,,,,,,,,,,,,,,,,,,,4,,,,,,,,8,10,10,8,8,10,8,8,8,8,10,8,,,
   ,,,,,,,16,16,,8,,12,12,8,12,,12,,,,,,,,8,10,10,8,8,10,8,
   8,8,8,10,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,12,,,12,12,
   16,8,,12,,16,8,,,,12,,,12,12,16,8,,12,,16,8,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,4,4,4,8,,,,8,,,,4,4,,,,,,,,,4,,,,,,,,,8,
   ,,,8,,,,,,,6,,,,,,,,6,,8,,8,,6,,4,,8,,,,,8,,3,6,6,9,,6,9,
   ,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,
   ,,,,3,3,,6,,6,,6,,,,,,,,,9,6,6,,6,,6,9,,9,9,6,6,9,,6,
   9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,
   6,,,,,,3,3,,6,,6,,6,,,,,,,,,9,6,6,,6,,6,9,,9,9,5,5,,4,
   7,10,7,12,,5,3,5,4,5,10,5,5,5,9,3,5,5,4,5,5,,,3,4,
   5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,5,,7,5,,5,7,5,6,
   8,4,5,5,,5,5,12,8,,,4,3,5,5,5,10,3,5,5,9,3,4,4,5,
   5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,5,7,7,,5,5,
   ,7,6,7,6,7,,7,8,,7,,,10,4,10,10,10,7,5,10,10,16,4,
   7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,6,5,6,5,8,8,,,,,
   ,,,4,7,7,,,5,5,7,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,,7,,,3,5,5,3,5,5,3,5,5,8,3,5,5,4,5,
   5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,5,8,5,5,5,
   ,7,4,6,,6,7,,7,,,4,5,6,10,10,7,4,10,10,7,4,5,5,5,
   6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,,10,,,,,,6,,7,7,5,,,
   7,10,,10,,5,,,,,,26,,,17,,7,16,,,6,,,,,,,,6,,,,,,,,,,,,7,,17,
   ,7,,,,,,,,,,,11,9,10,14,14,,,,,,,,9,7,9,9,14,10,7,14,8,
   11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,11,9,10,
   9,10,10,8,8,,,,,8,8,,,,8,8,10,8,10,,,,7,16,9,9,,12,,,,
   6,,,,,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,17,,7,14,,14,8,,,,11,,,9,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,3,5,5,4,
   6,7,7,3,3,3,5,5,5,9,,3,5,5,,5,,9,,,,5,5,6,4,8,8,6,
   8,,,6,6,,6,,5,7,5,5,4,11,7,8,5,8,8,6,5,5,5,5,4,5,
   5,5,3,5,5,5,5,5,3,,3,5,5,,5,,3,,,,4,4,6,4,,4,6,4,
   6,6,5,5,,5,,5,7,3,5,5,5,7,4,6,14,5,5,5,5,5,6,8,7,
   8,4,5,5,5,5,5,9,,4,5,5,,5,,9,,,,5,5,,6,9,7,,7,8,8,
   5,5,,,,5,14,5,4,5,21,6,7,6,25,8,7,5,5,5,5,5,5,3,5,
   5,3,5,5,9,,3,3,5,,5,,9,,,,4,4,9,4,8,3,9,3,6,6,6,6,
   ,9,,11,7,5,4,5,5,7,5,4,7,3,9,5,5,5,5,4,4,5,5,5,
   5,5,9,,4,5,5,,5,,9,,,,5,5,9,4,,5,9,5,11,11,7,7,,9,,
   21,6,5,5,4,5,14,5,11,9,5,7,7,7,6,7,4,5,5,5,4,4,7,
   ,4,5,4,,4,,7,,,,6,6,7,4,8,6,7,6,5,5,5,5,,10,,6,10,
   5,4,4,6,10,8,8,11,6,9,5,5,7,3,4,4,4,6,6,6,,3,4,6,
   ,6,,6,,,,5,5,3,4,5,8,3,8,5,5,,,,14,,4,14,4,11,5,5,
   8,3,5,7,4,8,5,8,4,5,5,5,10,10,9,,4,5,10,,10,,9,,,,
   5,5,9,4,,7,9,7,5,5,7,7,,12,,25,9,5,7,5,4,10,5,5,6,
   11,26,7,4,6,6,5,12,12,7,,4,5,12,,12,,7,,,,5,5,7,4,8,
   6,7,6,8,8,10,10,,8,,12,8,5,6,5,5,14,5,7,8,7,18,4,
   9,9,6,6,6,6,,4,6,6,,6,,6,,,,9,9,10,6,,8,10,8,,,6,6,,,
   ,6,8,5,6,4,14,38,8,9,12,5,8,3,3,3,4,4,3,,2,3,4,,4,
   ,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,4,6,3,4,4,4,6,
   3,3,6,3,5,3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,
   5,5,,,,,,,7,5,5,5,5,,4,4,7,7,7,5,5,5,,,3,5,5,,5,,,,,,
   3,3,4,4,5,4,4,4,5,5,,,,,,,7,5,5,5,5,,4,4,7,7,7,5,5,
   ,,3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,5,,5,5,5,,
   7,4,4,8,8,5,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,
   5,5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,6,,4,5,4,,4,,6,,,,
   5,5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,
   ,3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,,,,12,,4,6,6,12,,
   5,5,9,10,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,
   3,3,3,2,3,3,3,3,3,3,3,3,,3,,4,6,3,4,4,4,6,3,3,6,
   3,5,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,5,,5,5,5,,7,
   4,4,8,8,5,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,8,
   8,5,4,4,8,8,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,
   5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,4,4,8,8,6,6,,5,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,12,,4,
   6,6,12,,5,5,9,10,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,5,
   8,4,5,,5,7,5,8,,4,7,,4,,5,,5,,,5,5,,5,,5,8,4,5,,5,
   7,5,8,,4,7,4,,,3,,,,,,,5,,6,9,5,,12,6,9,10,10,,5,9,,
   4,4,4,6,6,6,6,,,,4,6,6,4,6,4,6,6,6,6,4,6,,,,,,,,,,,
   6,9,11,,,6,9,,,,15,12,,3,5,5,,,,5,,5,7,5,6,9,5,8,8,
   5,9,5,6,,,,,,,5,,6,9,5,,12,6,9,10,10,,5,9,5,5,,,,5,,
   5,7,5,6,9,5,8,8,5,9,5,6,3,5,5,,,,9,8,6,5,11,5,7,,
   9,8,,9,5,5,,,,9,8,6,5,11,5,7,,9,8,,9,3,,,,11,7,,6,7,
   5,8,,9,9,9,6,,,,11,7,,6,7,5,8,,9,9,9,6,,,,,,,,,,,,,,,,,,
   ,6,6,12,,11,9,9,,8,,,,,,,,,,,,,8,5,5,6,,,5,5,13,11,,8,
   14,,,,7,8,8,7,7,5,5,5,8,5,7,7,5,6,4,6,,11,5,,5,,5,
   14,9,25,,5,,8,5,5,,25,,8,7,13,17,7,5,8,7,8,8,5,28,8,
   ,7,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,
   6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,9,6,6,,6,,6,9,
   ,9,9,5,5,,4,7,,7,,,3,3,3,5,5,5,3,5,5,8,4,3,4,4,4,
   4,,,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,,,,3,4,3,4,
   7,5,5,5,7,5,8,6,5,,5,5,,8,,12,3,5,5,3,5,5,4,5,10,
   9,5,3,5,5,5,6,5,5,4,5,5,,7,3,,,,,3,4,,5,,5,,7,,3,,,,
   ,8,3,5,5,7,,3,5,,7,5,7,6,,7,8,,7,,,4,5,5,5,4,4,4,
   6,7,7,7,4,7,5,5,4,5,5,5,6,6,,10,6,,,6,,4,5,,6,,6,,
   10,,6,,,,,,4,5,5,,10,5,4,,,7,7,10,12,,,,,,12,9,,7,9,,,
   16,,,,6,,,,,,,,,,,,7,,,17,,6,,,,,,,,,7,,,,,,,,,,,,8,14,9,7,
   14,11,5,,7,,10,4,4,4,3,5,5,5,5,10,9,4,3,4,4,4,4,,,
   5,5,5,5,5,,,6,8,,3,5,,5,,5,5,5,,,,6,,,,4,4,4,4,7,7,,
   5,5,5,,6,,7,,,4,10,10,4,10,10,10,10,7,16,5,4,5,7,7,
   4,8,8,7,10,10,,5,,,6,,,4,7,,10,,10,,5,,,,6,,,6,7,10,,5,
   ,4,7,7,,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,6,9,9,7,14,8,9,9,10,11,7,6,7,7,7,6,10,10,9,8,
   8,8,9,10,,10,,,6,9,,8,,8,8,9,,10,,10,,,11,8,10,,8,8,
   7,6,,,,8,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   7,,16,26,17,,,,,,,6,,,,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,,17,,,14,,
   14,11,10,9,,,,,3,3,4,4,4,4,6,7,7,3,3,3,4,4,4,3,3,
   4,6,6,,8,6,,3,6,,3,4,,6,,6,,8,,6,,3,,,5,3,4,3,3,8,
   4,4,11,8,4,14,4,3,5,5,5,3,5,5,5,4,3,4,3,3,4,6,6,
   5,5,5,6,3,9,,4,9,,3,5,,5,,5,6,3,,9,,4,,,8,3,3,3,4,
   7,5,5,4,9,11,7,4,5,5,5,6,8,7,8,4,3,4,4,4,4,5,5,
   5,10,10,7,7,6,,4,6,,3,5,,10,,10,7,7,,6,,4,,,,3,4,3,
   4,10,5,5,7,26,25,9,4,5,5,5,5,5,5,4,3,4,5,5,4,6,6,
   5,5,5,5,4,3,,6,5,,3,5,,5,,5,5,4,,3,,6,,,,4,5,5,4,7,
   3,5,5,5,5,7,6,4,5,5,5,4,5,4,5,5,5,4,11,11,5,5,5,
   7,5,9,,9,9,,4,5,,5,,5,7,5,,9,,9,,,,4,5,5,4,14,5,4,
   5,7,21,6,11,7,7,6,7,5,4,5,5,5,4,8,8,6,12,12,10,6,
   6,,7,6,,4,6,,12,,12,10,6,,6,,7,,,6,4,5,5,4,14,5,4,6,
   18,12,8,7,5,5,7,5,3,5,5,5,4,,,3,5,5,6,8,9,,6,6,,3,
   3,,5,,5,6,8,,9,,6,,,8,8,8,11,8,7,5,4,5,6,5,7,5,5,
   8,5,4,5,5,5,6,8,8,5,5,5,5,7,9,,,,,4,5,,5,,5,5,7,,9,
   ,,,,9,25,8,21,7,6,5,5,4,7,5,14,6,7,6,4,6,5,5,4,5,
   5,5,4,4,5,6,7,,7,10,,4,5,,4,,4,5,6,,7,,7,,,8,11,6,
   6,8,10,5,4,4,9,6,10,8,9,4,9,6,6,6,,,9,6,6,6,8,6,,
   10,,,4,9,,6,,6,6,8,,6,,10,,,,12,5,14,8,38,5,4,6,8,6,
   8,9,3,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,
   ,,,3,4,4,4,7,4,,5,7,5,8,8,3,3,3,2,3,3,3,4,4,3,3,
   3,,3,3,,2,3,,4,,4,3,3,,3,,3,,,3,3,3,3,3,6,3,4,4,5,
   4,6,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,
   ,3,4,4,4,7,4,,5,7,5,8,8,3,4,,,5,5,5,5,3,,,4,,,3,5,
   ,5,,5,5,3,,,,4,,,5,4,4,3,4,7,5,5,5,5,5,,4,4,,,5,5,
   5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,4,4,3,4,7,5,5,5,
   5,5,,4,6,6,4,4,4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,
   4,4,4,4,6,6,6,4,6,4,6,6,3,5,5,5,5,5,,,,,,3,5,,5,,
   5,5,5,,,,,,,,8,,5,,7,6,11,5,9,9,8,9,5,5,5,5,5,,,,,,3,
   5,,5,,5,5,5,,,,,,,,8,,5,,7,6,11,5,9,9,8,9,5,5,,4,,,4,,
   ,3,3,,5,,5,,4,,,,4,,,5,7,7,5,4,,5,5,5,7,,7,4,4,5,5,
   6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,8,6,8,5,4,4,,8,
   8,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,8,6,8,5,
   4,4,,8,8,6,,,,,,,3,,,5,,5,3,,,,,,,,,9,9,5,,8,,7,6,6,11,
   7,9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,9,5,5,8,8,5,9,6,6,5,
   7,5,,4,,,3,,,6,,6,,4,,3,,4,,,5,4,10,6,4,,4,6,6,7,12,,
   5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,,5,4,
   10,9,5,12,,9,6,9,4,,3,,,6,,6,,5,,,,5,,,,5,,12,7,,,6,6,
   8,,,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,3,3,
   3,3,6,3,4,4,5,4,6,3,,5,,5,,4,,,,4,,,5,7,7,5,4,,5,5,
   5,7,,7,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,6,,,6,,5,8,6,
   8,5,4,4,,8,8,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,8,
   6,8,5,4,4,,8,8,6,,,,,,,,,9,9,5,,8,,7,6,6,11,7,9,,4,,,,
   ,,9,5,5,8,8,5,9,6,6,5,7,5,,,,,,,,,,,,,,,,,,,,4,,,5,4,
   10,6,4,,4,6,6,7,12,,5,,,,,,,,,,,,,,,,,,,,,5,4,10,9,5,12,,
   9,6,9,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,,9,11,,,12,6,9,,4,
   3,3,13,4,4,,,13,8,8,3,4,17,5,5,5,7,11,7,5,4,8,5,5,
   6,,,,4,8,5,9,11,8,5,7,5,8,14,,7,,,7,5,5,6,5,8,7,4,,
   6,,25,,5,14,5,,7,28,8,5,8,8,8,,6,7,,7,,,8,4,5,6,6,
   10,8,7,7,20,5,5,4,6,6,6,,,5,6,6,9,6,10,,,,,5,4,10,6,
   ,6,,6,9,,,,,,,5,,,,7,8,8,8,,5,6,6,8,,8,8,,10,,,8,8,5,
   8,7,10,8,5,10,10,5,5,4,10,7,10,,,5,7,4,,7,7,,,,,5,4,
   7,10,,7,,10,,,,,,,,8,14,,,8,,8,,14,8,14,14,11,7,4,11,7,
   6,6,8,8,6,8,4,9,8,6,9,8,5,5,4,6,4,6,,5,8,6,6,,6,
   8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,6,8,6,6,8,8,6,
   8,8,7,6,6,,6,6,,,,,14,6,,8,18,,9,,16,,,5,,5,,,6,,8,8,,
   8,,,,,6,,5,,,,5,,,,,6,,,,,9,,,,,5,5,5,,,,,8,,7,,,8,6,7,4,
   6,7,8,5,10,20,5,5,4,6,6,6,,9,5,6,6,,6,7,10,10,,,5,
   4,7,6,,6,,6,,,9,,,,,5,6,8,8,8,,7,,6,5,,,6,7,11,11,8,
   8,6,8,4,9,8,6,9,8,8,8,4,6,6,6,,,5,4,6,5,4,,8,8,8,
   12,5,4,,6,8,6,,6,5,,,,8,12,12,7,6,8,8,6,6,8,6,6,6,
   8,8,,,,,14,8,,8,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,
   ,,,,,9,,,,,5,19,5,,,,,,,10,6,10,12,5,8,10,10,8,10,6,6,
   4,4,6,4,,7,6,6,4,7,6,10,10,10,,8,6,4,10,4,,6,,4,7,,
   7,,8,,,7,,,,6,,5,,,7,,,6,,,9,19,8,,,6,18,16,,,5,,8,,,,,
   5,8,6,5,,,,,,,5,,,,8,,,6,,,,,,,,,,,5,,,,,9,,,,,9,32,8,,,8,,
   16,,,5,,8,,,,,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,19,,,,,9,,,5,
   5,8,7,7,8,4,9,9,5,5,4,10,7,10,,6,5,7,4,12,7,7,8,8,
   ,10,5,4,7,10,,7,,10,12,,6,,,,,5,12,5,5,11,13,5,13,12,
   5,11,11,5,5,5,8,8,7,7,7,5,5,4,5,5,5,,6,5,5,4,12,
   5,9,5,5,,8,5,4,9,5,,5,,5,12,,6,,,,,5,5,5,5,5,8,5,8,
   5,8,5,5,7,4,7,4,5,7,5,5,5,3,5,6,5,,3,4,3,6,9,3,6,
   ,,7,6,4,3,6,5,7,6,,5,9,,3,,10,11,11,5,5,5,5,6,5,5,
   5,5,7,8,8,5,7,5,5,8,7,5,5,4,5,5,5,,12,5,5,4,6,5,
   8,5,5,,,5,4,8,5,,5,,5,6,,12,,8,,,5,5,8,8,5,5,5,5,5,
   5,8,8,7,7,4,7,6,5,5,3,5,3,5,,6,5,3,4,6,3,5,6,6,
   9,8,5,3,5,5,9,3,,5,6,,6,,8,9,9,5,5,7,7,5,7,5,7,5,
   5,5,5,9,7,10,9,8,8,6,8,7,8,,10,7,9,6,10,9,11,10,10,
   ,,7,6,11,8,,7,,8,10,,10,,,,,9,,7,7,9,8,8,8,,7,,,5,7,
   9,5,5,4,10,7,10,,12,5,7,4,6,7,8,8,8,,,5,4,8,10,,7,,
   10,6,,12,,10,,,5,11,13,13,5,5,11,5,11,5,12,12,7,5,4,
   4,3,5,3,5,,9,5,6,6,3,6,,6,6,11,10,5,3,,5,11,3,,5,3,
   ,9,,6,7,7,7,8,5,5,5,5,6,5,8,5,5,5,9,7,7,6,8,9,8,
   ,10,8,7,6,10,7,10,11,11,,,8,6,10,8,,9,,8,10,,10,,,,,7,
   ,8,8,8,7,9,7,,9,,,10,10,4,9,6,9,,9,10,6,4,9,6,8,8,
   8,17,12,10,4,8,9,17,6,,9,9,,9,,12,17,17,8,10,9,9,8,
   9,8,9,10,8,10,10,3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,
   5,5,7,5,,5,4,,,,4,,,3,5,5,5,4,5,,5,5,4,8,8,3,5,5,5,
   ,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,3,5,5,5,
   4,5,,5,5,4,8,8,4,3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,
   3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,
   4,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,
   4,,,5,,5,,4,5,,,5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,
   5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,6,
   5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,4,,,5,,5,,4,5,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,4,,,,9,6,4,3,,
   6,9,,,6,4,,3,,6,,,7,6,,,4,6,7,6,6,5,9,9,5,4,,5,,5,5,
   ,4,3,3,,5,,4,,5,,,4,,,7,7,4,8,5,5,,5,4,5,8,,5,5,4,,
   3,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,
   7,7,5,5,5,4,4,6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,,6,6,
   6,4,4,4,4,4,4,4,4,6,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,9,
   9,5,9,6,6,7,,4,,9,7,6,6,5,,,9,6,5,3,5,5,9,3,,5,,,4,
   ,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,5,5,11,8,,3,3,5,
   11,,,5,,,,,,9,9,5,8,7,7,,5,6,5,8,,7,7,3,9,,5,3,5,5,
   9,5,,5,,,,,8,11,11,,5,5,5,6,7,,7,5,6,5,5,9,,5,3,5,
   5,9,5,,5,,,,,8,11,11,,5,5,5,6,7,,7,5,6,5,5,8,,6,11,,
   6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,6,,,,,,6,,,
   8,6,,6,6,10,,,3,,5,,4,,5,,,4,,,7,7,4,8,5,5,,5,4,5,8,
   ,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,
   4,4,5,11,,,5,,,,,,9,9,5,8,7,7,,5,6,5,8,,7,7,,5,,4,6,
   ,6,,6,,,5,4,,,5,,5,,4,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,5,4,,
   ,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,,6,,
   6,,6,,,5,4,,,5,,5,,4,5,,,,4,,,9,9,5,9,6,6,7,,4,,9,7,
   6,6,,,,,,,,,,,,,,,,,,,6,,,7,6,,,4,6,7,6,6,5,9,9,,,,,,,,,,,,,
   ,,,8,8,10,,6,6,,,8,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,7,,,
   5,8,8,5,5,6,5,5,5,14,14,,,8,8,5,8,4,14,,,4,5,,8,,,
   5,8,8,5,,8,,,5,8,8,8,6,8,8,6,5,5,5,4,8,8,,,5,5,5,
   8,8,8,8,,,14,,,5,5,4,3,,4,4,5,4,,,4,3,4,4,4,4,4,6,
   9,12,4,4,6,4,4,6,,4,4,6,6,,9,4,,,,,4,4,7,6,,6,,7,,5,
   ,,,,,4,4,3,,,4,4,7,7,4,4,4,,4,4,5,4,,,4,3,4,4,4,4,
   4,6,9,12,4,4,6,4,4,6,,4,4,6,6,,9,4,,,,,4,4,7,6,,6,,
   7,,5,,,,,,4,4,3,,,4,4,7,7,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,
   2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,
   ,,4,4,4,4,6,6,6,4,6,4,6,6,,3,5,,6,6,7,4,7,5,6,7,
   6,9,4,6,4,4,6,4,,6,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,
   ,7,,,,,,4,7,7,4,4,4,,7,4,7,,,,3,7,8,8,5,5,6,11,,11,
   5,,5,5,,,,5,6,5,6,8,6,7,,,,,3,9,6,8,,8,6,8,,7,14,6,,,
   ,5,3,5,5,8,5,7,7,6,,,,5,,6,6,7,4,7,5,6,7,6,9,4,6,
   4,4,6,4,,6,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,4,
   7,7,4,4,4,,7,4,7,,7,4,8,5,11,7,6,8,7,11,5,,,5,5,,,,
   8,9,8,,8,5,5,,,,3,5,,6,,6,8,6,6,7,,,,,,5,5,5,5,6,,,,
   8,7,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,
   3,4,4,4,4,4,7,7,4,3,4,3,3,4,,3,4,4,5,9,7,6,6,,9,,
   3,4,8,4,,5,,7,11,7,6,5,,13,,3,3,3,4,7,4,4,9,7,5,9,
   5,3,4,4,4,3,5,5,7,3,3,3,4,4,4,,,3,5,5,5,5,6,3,,,,
   3,3,11,5,,5,6,5,8,,4,4,,,,3,4,3,3,6,4,3,5,9,9,4,4,
   4,4,4,4,8,6,8,4,3,4,4,4,4,,4,4,6,12,6,6,5,10,,13,,
   3,4,,6,,7,6,6,,5,6,5,,,,3,4,3,4,13,4,4,6,7,7,7,5,
   4,4,4,4,4,7,3,4,4,3,4,4,,6,4,4,4,4,4,4,4,,,,4,4,,
   4,,4,4,4,7,5,7,7,,,,4,4,4,4,5,3,4,4,5,4,4,7,4,5,
   4,5,8,3,4,4,4,4,4,,4,5,3,5,6,5,6,4,,,,4,5,12,4,,5,
   11,5,10,10,6,6,,,,4,3,4,4,6,4,4,4,12,7,4,4,7,6,8,
   7,3,4,4,4,4,3,,4,10,8,7,18,7,5,13,,11,,3,8,8,6,,7,
   12,7,11,4,12,11,,14,,4,3,4,3,30,4,4,5,28,7,5,6,4,5,
   7,4,3,5,4,5,5,,4,4,4,5,6,7,7,5,,6,,3,4,6,4,,5,6,
   7,6,7,4,6,,15,,4,8,14,8,6,4,3,4,6,4,4,5,5,8,4,5,
   6,4,4,6,,7,4,4,5,5,7,7,12,,,,4,4,10,3,,5,5,12,8,8,
   14,16,,14,,19,7,17,19,6,4,5,4,6,4,4,10,7,4,5,5,4,5,
   8,,4,5,5,4,4,4,8,8,,12,,4,5,6,5,,4,4,5,9,8,7,10,,,,
   5,9,10,10,5,4,5,5,6,5,4,6,6,8,11,6,8,8,,9,9,11,6,
   7,6,7,7,,11,,6,8,7,8,,6,7,6,,8,,21,,16,,11,9,9,10,,
   7,7,7,,7,7,10,4,4,2,4,4,,,3,3,4,4,4,3,3,,5,,2,3,5,
   3,,4,4,4,5,4,4,4,,5,,4,3,3,4,5,3,5,4,5,4,3,5,4,4,
   4,4,,,4,5,5,5,5,5,,,8,,3,4,6,5,,5,5,5,6,5,,,,,,3,4,
   3,4,6,4,4,5,6,5,7,6,4,4,4,,,4,5,5,6,5,4,,,,,3,4,6,
   5,,5,6,5,6,5,,,,,,4,4,3,3,6,5,7,5,6,3,4,4,4,4,,3,
   4,4,4,4,4,4,4,,,,2,4,5,4,,4,4,4,5,,4,4,,,,3,4,4,3,
   5,3,4,4,5,4,5,4,4,,,5,4,5,6,5,,5,,,,3,5,6,4,,5,6,
   5,6,7,7,6,,,,3,3,4,4,6,4,4,3,6,5,5,7,,,5,4,5,6,5,,
   4,,,,3,5,6,4,,5,6,5,6,7,6,7,,8,,4,3,4,3,6,7,6,5,6,
   5,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,,,5,,6,,3,
   4,6,4,,4,4,,6,6,,,,,,4,4,3,,5,4,,3,5,5,7,,4,5,,5,,,,,
   ,4,4,6,4,,5,6,5,,,5,5,,8,,4,,7,4,,4,4,4,6,7,4,5,5,
   ,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,4,7,,4,,4,5,4,6,4,
   4,3,4,4,7,7,,6,,4,5,,5,,4,4,4,8,7,8,7,,6,,6,8,8,5,
   6,4,5,5,5,7,4,6,,,,,,,4,6,5,5,,4,4,,9,9,8,,,6,,5,11,
   9,,6,,6,6,5,7,4,6,7,7,,8,,4,5,,5,,4,,4,8,7,7,8,,6,,
   5,8,8,6,6,5,7,7,5,5,4,5,4,,12,,4,8,8,6,,7,9,7,,6,
   6,6,,12,,5,9,4,4,,4,5,5,,9,7,,,12,,4,6,8,8,,7,8,7,,
   5,,,,,,5,4,9,4,,6,,7,,6,4,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,
   7,8,,6,8,6,,,10,10,,,,8,,,,,,7,7,11,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,4,,4,,4,4,4,,5,4,4,,5,,3,3,3,3,6,4,3,3,6,3,4,
   3,8,4,,5,,5,8,,6,6,,,,4,,7,4,6,4,3,4,,5,4,5,8,,,6,,,
   11,,9,,11,,,9,9,11,7,5,6,7,15,,6,,,5,,5,,,6,6,,,,4,7,,
   4,6,4,5,4,,4,4,4,,,,,,,,,,,,,,,,,,,,,,,4,4,7,7,,7,,8,,6,
   8,8,5,5,4,5,5,6,7,5,7,,8,,9,,,,,5,11,9,,5,4,5,6,6,
   9,4,10,7,7,7,,,6,,5,8,8,6,5,4,6,7,6,5,4,5,,8,8,,,,
   9,11,,9,9,8,8,,8,7,7,5,7,7,,,,5,15,4,5,,6,4,7,,8,,
   6,4,,,,9,,,9,7,5,5,6,8,7,9,7,,,,9,,,9,7,5,6,,8,4,6,
   5,,,,,,,,,,,,,,,,,,,11,11,,,,,7,,7,,,,,,,,,,,,,3,3,4,6,4,4,
   4,6,9,5,9,4,3,,4,4,6,,9,4,21,3,,4,3,9,,6,4,6,6,5,
   9,9,6,6,4,7,6,10,15,6,7,5,6,4,4,5,4,6,6,5,6,5,6,
   6,7,4,6,5,15,6,24,4,5,4,,4,4,5,4,,,4,3,4,4,4,4,4,
   6,9,12,4,4,6,4,4,6,,4,4,6,6,,9,4,,,,,4,4,7,6,,6,,7,
   ,5,,,,,,4,4,3,,,4,4,7,7,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,4,6,9,4,4,9,
   12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,
   4,4,7,7,4,,,,4,4,7,7,,4,,5,4,4,6,4,6,9,4,4,9,12,4,
   4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,
   7,7,4,,,,4,4,7,7,,,,5,6,11,7,5,5,4,8,,5,8,,5,5,8,,
   7,5,4,5,8,,6,8,,7,,,3,,9,6,,8,,8,,,,,,,,7,5,5,8,5,5,
   6,8,5,,,,,,4,4,6,4,4,4,4,6,4,4,4,4,4,4,4,4,6,6,4,
   4,6,,4,,,6,,,4,4,6,4,,4,,6,6,6,,,,,,6,6,4,6,4,4,4,6,
   4,6,4,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   7,8,7,,,5,11,5,5,,4,,5,5,6,,,,8,8,,8,,,9,,,8,5,7,,,6,
   ,8,5,7,,,,,,,,5,8,6,5,5,8,,7,5,5,4,4,4,4,4,3,4,4,
   4,4,3,4,4,4,4,4,4,3,4,4,,4,6,,4,,,3,3,5,5,14,5,,8,
   4,6,,,,,,3,4,4,5,4,4,4,14,5,3,7,4,4,3,3,4,4,4,4,3,
   3,4,5,3,4,5,3,6,3,3,4,,5,,,5,,,4,4,9,5,,7,,10,6,6,,
   ,15,,13,4,3,3,6,3,3,4,7,4,7,4,3,4,4,4,4,4,4,4,5,
   4,3,4,4,5,4,6,3,4,4,,5,4,,6,,,4,4,9,6,8,7,,7,,4,,,
   16,,,4,4,4,6,4,4,3,7,6,7,6,4,3,4,4,4,4,3,4,3,4,3,
   3,5,6,6,4,4,4,,7,3,,9,,9,3,5,6,5,13,5,,10,6,3,,,,,,
   4,4,3,7,4,3,3,6,3,4,3,4,4,4,4,4,3,4,4,6,3,4,12,
   10,5,4,4,4,,6,4,,6,,13,4,6,6,12,14,6,,7,5,10,,,13,,
   14,4,4,3,13,4,3,4,13,9,4,4,9,4,4,3,4,10,4,8,4,4,
   7,13,5,3,4,3,,7,4,,18,,11,4,5,10,6,,5,,8,4,4,,,,,15,
   4,4,4,30,3,4,3,6,8,5,7,6,4,4,4,3,3,3,4,4,5,6,4,
   3,4,4,,5,,,5,,,4,4,4,4,,4,,8,4,4,,,,,14,3,7,4,14,4,
   4,4,5,4,3,4,5,4,4,4,3,4,4,4,6,4,,4,4,4,,7,,,9,,16,
   5,3,10,5,,5,,7,6,4,,,,,8,7,6,4,7,3,4,4,6,4,4,9,6,
   4,4,3,5,4,4,6,4,4,4,4,3,,5,,,10,,,10,8,18,7,15,7,,
   8,5,13,,,11,,,5,7,4,6,3,4,3,30,6,4,5,8,9,3,8,3,4,
   10,4,4,3,4,4,,10,,,26,,15,9,8,26,10,16,10,,9,4,4,,,15,
   ,16,5,9,3,,4,3,4,,9,5,9,9,4,4,4,5,5,,,3,4,5,,5,4,,,
   ,,4,4,,6,8,7,,7,5,5,,,7,,,4,4,7,,4,4,,7,6,4,6,7,4,
   4,4,4,4,4,2,4,4,,4,3,,4,,,3,3,4,4,5,4,,4,3,3,,,5,,
   5,3,4,4,5,3,3,4,5,3,3,5,3,5,4,5,,,3,5,4,,5,4,,,,,
   4,4,6,7,,6,,7,6,6,,,4,,,4,5,,,4,4,7,7,10,3,4,4,4,5,
   ,5,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,5,,,,8,,7,4,4,3,
   6,4,3,4,6,4,4,7,4,5,5,,4,4,4,,5,,,6,,,4,5,6,5,4,5,
   ,4,4,,,,,,7,4,4,4,6,4,3,3,6,3,5,7,4,7,7,4,5,5,,4,
   4,,4,,6,6,7,7,6,8,6,,7,,,,,8,,,4,5,8,6,5,6,8,,6,5,
   4,7,4,3,,4,,7,5,,,,12,4,6,,,10,,,8,5,,,,6,,,6,,9,,4,5,
   4,9,7,4,6,5,3,4,,,7,,,,,12,4,6,,,10,,,8,4,5,,,,,,4,5,
   4,,4,5,9,9,7,7,7,9,4,4,,4,,,4,,5,4,4,4,4,5,4,,4,4,
   4,,,,,5,3,5,3,5,4,4,3,5,3,5,4,3,4,,5,,,6,,,5,4,6,5,
   7,5,,4,,5,,,,,4,5,7,3,6,3,4,4,6,4,4,4,3,,5,,,6,,,5,
   4,6,5,7,5,,4,,4,,,,,7,7,6,4,6,3,4,3,6,4,7,6,4,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,6,14,6,,7,,,,,9,,9,5,
   7,8,6,6,5,8,,7,5,4,5,,4,,6,3,5,5,5,4,5,,4,,3,,,,,8,
   4,,3,5,,4,4,6,3,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,
   14,7,,7,,,,,,,,,6,9,6,,5,11,7,8,5,5,5,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,4,4,,8,9,9,,8,,6,,,,,,,7,,,,8,,8,7,,,,4,,5,,5,,7,,
   3,,,,,8,3,4,4,7,,3,4,,7,4,4,6,5,5,,5,,7,,,,,,,,3,4,4,
   7,7,,4,,4,4,5,10,,,,,7,,,,,,,14,5,4,9,7,11,9,,6,6,,7,
   8,,4,,7,7,7,,,6,,8,5,4,6,,8,8,5,6,5,4,5,6,9,,,,,,,,,,
   7,7,,,,8,8,,,,,,,7,7,7,,,8,,14,5,4,5,,8,8,6,6,5,5,7,
   7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,7,6,7,7,7,6,,6,6,,4,,
   ,18,,10,7,7,5,9,9,4,4,,9,4,5,7,,,12,,10,4,6,5,9,4,
   9,4,,5,6,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,11,8,,,,,,,7,7,
   ,,,,,,,,,,,,,,,8,,11,,,,,7,7,,4,4,6,5,4,4,6,5,5,6,6,3,
   10,9,4,4,5,4,6,4,4,,3,3,4,6,24,4,7,6,6,6,,6,7,6,
   8,7,4,3,,21,4,6,4,3,,6,4,21,24,6,4,5,9,21,7,6,24,
   7,6,3,7,4,5,4,5,6,6,5,,,8,4,5,8,5,13,17,9,8,8,,5,
   8,5,5,,,5,,8,,,12,5,,,,,9,6,6,,5,8,10,,,10,9,,,,,5,5,,,
   ,5,5,9,9,5,5,5,4,,3,,,6,6,7,4,4,6,6,7,6,9,4,6,6,
   4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,6,,7,,,,,7,7,
   4,4,4,7,7,4,4,,,,6,4,6,6,4,4,4,4,4,8,4,4,8,4,4,4,
   4,4,4,4,4,6,4,4,4,,6,,4,,6,6,4,4,,4,6,6,,4,6,,,,6,
   6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,,5,,5,,5,4,8,9,,16,9,
   ,8,5,6,,8,5,,8,,,12,10,,,,5,4,5,5,5,,8,,,,10,6,,,,,9,
   5,5,5,5,5,9,5,5,,,,,,6,6,7,4,4,6,6,7,6,9,4,6,6,4,
   4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,6,,7,,,,,7,7,4,
   4,4,7,7,4,4,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,
   ,,6,,,,6,9,6,6,9,,,,,,,,12,6,12,,,,,6,6,12,,,6,9,9,,,6,
   ,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,12,6,
   12,,,,,6,6,12,4,4,4,4,4,4,6,7,7,5,3,5,4,4,4,4,4,4,
   6,6,,9,7,6,,9,4,4,4,10,6,17,6,7,9,,7,5,,,9,,3,4,4,
   3,9,4,3,10,10,6,10,9,4,4,4,4,4,7,7,6,4,4,6,4,4,8,
   3,5,4,6,8,,8,5,3,,8,8,4,4,4,4,,4,5,4,7,7,4,,,,,4,
   4,3,6,6,4,4,4,4,10,4,7,4,2,4,3,4,4,4,7,4,6,4,2,7,
   ,3,4,4,4,,12,5,,,5,5,3,3,5,4,5,4,4,6,9,3,3,,8,9,
   9,4,4,4,7,4,4,4,4,4,6,6,7,4,4,5,5,4,5,4,4,6,3,4,
   6,6,7,5,5,4,,9,4,4,,4,9,4,4,7,4,13,3,5,10,12,5,4,,,
   ,,4,3,4,9,3,3,4,4,4,5,7,7,4,7,6,7,8,4,4,4,4,2,4,
   ,5,7,6,7,,12,3,,,5,5,3,3,3,3,5,3,4,3,9,5,4,,6,8,
   8,4,4,4,4,7,4,4,3,3,7,7,5,5,5,4,5,5,4,5,4,4,3,7,
   5,5,5,3,,9,5,7,,5,5,4,7,10,8,,6,8,7,6,4,5,,,15,15,
   4,4,4,4,4,4,4,8,8,6,8,7,5,7,5,4,4,6,5,4,8,,8,4,
   5,4,,9,8,,,20,,4,4,5,3,,4,5,9,,5,8,,,,,4,9,4,9,4,9,
   4,4,4,4,5,6,7,4,7,5,6,5,4,7,,6,5,4,5,,6,7,,,9,10,
   5,4,5,5,9,4,7,6,6,5,5,,6,6,6,7,7,5,6,5,7,7,6,6,
   5,5,7,7,7,6,6,6,6,6,,11,7,6,4,,8,5,,,,,5,7,8,4,13,
   5,10,8,6,7,12,,,,,7,4,9,10,7,4,7,8,8,8,4,8,8,5,8,
   5,4,7,,6,5,4,5,,18,6,,,10,9,6,4,5,6,9,4,8,7,,5,5,,
   9,12,11,6,7,5,11,5,7,6,7,7,8,8,6,5,5,4,4,4,,,4,6,
   8,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,,4,3,4,6,4,,
   4,4,6,6,7,5,4,4,4,4,4,4,5,5,,8,5,,,5,,4,3,5,4,5,
   4,4,4,6,4,,,,,,3,4,4,3,5,4,3,4,4,6,7,6,5,4,5,,5,6,
   6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,5,5,6,6,5,
   5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,4,4,,,5,4,4,4,
   4,5,3,5,4,6,,4,,8,,8,4,3,4,5,3,3,4,4,4,5,7,6,4,4,
   ,4,4,4,,6,,4,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,6,4,
   4,4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,4,5,
   3,5,4,6,,4,,,8,,4,,5,4,9,,4,4,4,6,6,7,4,,,,,,,,,,5,4,
   4,4,4,5,3,4,,,,4,,,,,4,,4,,,,4,4,4,,,,5,6,,,8,,,,7,,3,
   3,4,4,5,4,4,4,6,5,5,,,,,7,5,4,,8,5,7,4,4,7,7,8,5,
   4,,8,,,,,5,4,4,4,4,5,3,5,4,7,7,4,,,8,,4,,3,6,4,,4,
   4,4,7,5,9,5,,6,5,,,8,8,5,4,5,5,8,4,6,6,,5,5,,5,5,
   6,6,6,5,6,5,6,6,6,6,5,5,6,,8,5,,,5,,4,3,5,4,5,4,
   4,4,7,4,7,,,,8,,4,5,9,4,4,,4,4,7,6,6,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,8,,,12,12,8,6,8,8,12,6,8,8,,8,8,,8,8,8,9,
   9,8,8,8,9,9,9,9,8,8,8,4,,,7,4,4,4,4,5,3,4,4,7,6,
   5,,,12,12,5,7,4,8,,7,5,4,4,8,7,7,,5,,3,3,4,4,5,4,4,
   ,,4,,,,,,,4,4,,,4,,4,4,,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,
   6,5,5,6,4,7,5,9,5,5,,,,,5,,,,,,5,5,5,,,,5,4,7,5,6,6,
   5,5,9,5,5,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,8,4,
   4,4,6,7,4,4,,,4,3,6,4,4,6,3,,4,6,,3,,6,6,6,3,4,4,
   4,4,4,3,4,4,4,4,4,4,,,6,,,5,,,,,,5,4,7,7,8,4,5,7,7,
   ,4,8,,4,4,5,,5,5,,,,,4,4,7,6,6,4,4,3,3,3,4,5,6,,,,
   7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,3,
   4,4,4,6,6,6,,,,5,,,,,4,5,6,,,5,4,7,7,8,8,8,,5,5,,8,,
   ,4,4,6,7,6,4,4,,,9,5,4,7,7,,11,10,6,7,7,6,11,13,7,
   7,,,6,5,6,4,,,,9,4,7,5,4,5,7,4,5,5,,,,,12,,,7,4,,5,,
   4,7,5,5,7,8,7,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,
   ,6,,,,,6,,,,,,6,,4,4,7,6,4,3,4,4,7,13,9,4,6,7,3,4,
   4,4,13,4,7,5,5,4,4,13,13,4,4,4,8,6,7,7,7,4,4,4,7,
   6,9,9,4,4,4,4,4,4,13,4,7,4,4,7,13,9,3,7,7,7,7,7,
   7,5,8,5,,,5,,,6,5,8,4,11,7,7,8,14,11,,8,5,5,9,6,8,
   6,,5,8,,6,9,9,,,,5,,8,,,8,,6,,,,8,,,,7,5,,,,8,6,5,7,5,
   8,8,3,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,
   ,9,,6,,,,9,,,,6,6,,,,6,12,6,12,,,,,,,,9,6,,9,,,6,,9,,,6,
   6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,6,6,,,,6,12,6,
   12,,,,,,8,9,10,6,,8,10,,8,10,,6,5,6,,5,8,,,5,8,,6,,8,,,
   ,8,9,,,,8,10,8,10,11,11,10,,,,8,6,,,,5,5,7,6,8,5,8,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,7,,,,8,7,8,8,,8,8,5,,6,
   8,5,,6,7,,,,,,,8,8,,8,,,8,,,,,,,,,,6,5,,,,7,,,8,,,5,7,7,
   7,,,9,9,6,,5,6,5,5,6,,5,,6,6,,6,5,,,10,10,8,12,6,,,
   6,7,15,13,8,,,,,,5,5,,,,5,5,7,8,12,5,8,,6,,7,7,9,7,,
   8,5,6,8,6,,6,,7,,,7,9,12,,22,5,14,6,8,,6,6,5,,,21,5,
   12,,,,7,6,,,,6,17,5,20,,,,7,,,,8,8,,5,6,8,,7,,,,8,6,,,
   5,8,,8,,5,,,,7,6,7,,12,5,,,,,,7,,,,,6,5,6,5,5,5,,,,6,,
   7,,6,7,8,8,,12,9,,5,6,,7,6,,,5,22,8,6,7,,19,7,10,10,
   13,8,17,20,,,,6,17,,,,7,6,8,8,,8,8,10,8,,10,,9,11,9,
   4,5,9,4,,11,5,,5,4,9,,,,11,10,10,,14,11,18,12,19,16,
   14,19,,,,8,7,,,,8,7,20,16,8,8,7,,,10,,12,13,9,10,20,
   16,9,,9,10,,11,10,,,20,,,9,12,,,13,,9,,,,,,,,,12,,,,27,,7,
   12,6,9,10,9,7,,12,7,9,5,,9,9,,5,9,,11,6,,,6,,9,7,13,,
   ,8,9,,,10,9,24,,,,5,5,,,,8,11,11,13,8,11,11,8,,15,10,
   8,9,15,,10,,8,11,,16,10,16,,,,8,18,15,,21,10,,21,15,13,
   ,12,,,,9,7,,,,6,55,,86,7,15,10,,6,10,9,8,16,,9,,6,6,,
   10,7,,,9,,16,8,7,,,10,13,10,,,13,30,,,,7,7,,,,9,6,11,
   20,10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,6,
   5,5,,6,6,,6,5,,,8,,6,5,4,,5,,,,8,7,,,,,,4,5,,,,5,5,10,
   6,5,8,7,6,5,6,,4,,6,6,,6,5,,,8,5,6,5,,,5,4,4,,8,7,
   5,,,,,7,6,,,,5,4,4,7,4,5,5,5,6,,5,,,6,,6,5,5,,,8,,,6,
   ,6,6,7,6,,,7,8,,,,5,5,,,,4,5,7,14,7,8,5,,7,,,5,,,6,,
   7,,,,5,5,6,,6,5,6,5,8,8,8,8,,,,5,5,,,,5,5,5,6,,5,,8,
   5,,6,,,,,8,,,8,6,5,7,,6,6,7,5,10,9,7,9,,,,17,6,,,,7,
   5,7,7,7,5,8,5,,,8,,8,7,,,,14,,,6,,,,,,,,,,,,,7,,,,,7,5,,,
   7,8,7,,5,,,5,,7,,7,6,5,4,6,,5,4,4,4,8,7,6,6,,,,12,5,
   ,,,4,16,4,6,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,4,,,
   5,8,,6,7,,,6,7,6,,,7,8,,,,5,4,,,,7,6,7,15,5,5,4,,,5,
   8,,8,,6,5,7,,12,6,7,6,9,7,9,10,,,,7,5,,,,17,6,6,7,8,
   5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,10,10,6,5,7,,12,6,
   7,6,10,7,7,10,,,,11,6,,,,11,6,7,8,5,4,5,5,,6,7,4,5,
   5,,6,5,6,5,6,7,7,8,,,,4,16,,,,12,5,5,5,6,6,,,14,,,6,,,
   ,,,,,,,,,,,7,5,,,,7,,,,7,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,9,
   ,,8,11,8,,,9,15,,,,6,,,,,,8,8,9,,,,12,6,,,6,6,5,14,15,
   13,5,13,,,,,8,,,,6,,5,14,,,,,,,,6,,6,,5,7,8,,,,7,10,,,,
   17,6,6,9,5,7,5,5,,,5,,5,,,6,7,,,,4,11,,,,5,5,5,11,,,5,
   ,,,,,,,,,,,,4,6,,,,5,6,,,,10,7,,,,,,,,,,,,,,,,,,,,,,,,6,6,,,,7,
   ,,,,5,6,,,,6,5,,,,,,4,,8,7,,,,,,8,6,,,,5,4,4,8,6,10,10,,
   ,,5,,,,,8,7,,,,6,4,,,,10,10,8,7,,,,,,22,9,,,,5,6,9,12,
   5,7,5,,9,10,,,,9,,,,,,11,,11,8,9,6,8,9,,,,8,10,,,,,7,7,
   10,,,7,,,,,,7,,,,6,14,5,9,7,,,,,,,11,,,,9,,,14,6,9,8,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,,,3,5,7,8,7,6,12,,,,5,5,
   7,11,13,5,8,,,,,,,,,,,,,,,,,,,,,,,,,5,5,11,7,5,11,4,5,6,
   8,7,9,4,13,7,8,8,10,5,5,5,,4,,5,4,4,6,4,6,9,4,4,
   9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,
   ,4,4,7,7,4,,,,4,4,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,6,6,7,4,4,6,6,7,6,9,4,6,6,4,4,4,,8,
   6,6,7,,9,7,,,,,4,4,,4,,6,7,6,6,,7,,,,,7,7,4,4,4,7,7,
   4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,8,
   11,8,6,,,8,6,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,
   ,6,7,8,5,,8,6,,,,,,5,7,7,8,8,5,,5,8,6,4,4,3,5,5,4,
   4,7,7,3,4,4,4,4,4,7,6,3,5,5,4,5,5,7,6,14,,3,5,6,
   5,,7,6,7,4,,6,6,,6,,3,4,4,4,3,14,6,8,5,4,8,6,4,4,
   4,4,4,5,5,7,4,4,4,3,4,4,6,7,4,4,4,7,4,6,6,5,,,3,
   4,4,4,,4,7,4,6,,4,4,,,,4,4,3,4,4,6,5,4,4,8,6,5,5,
   4,5,4,8,6,8,4,4,4,4,4,3,8,8,5,4,5,14,5,12,7,6,14,
   ,3,6,7,6,,7,16,12,7,,5,5,,,,4,4,4,4,5,17,6,19,6,19,
   7,6,4,5,4,4,4,7,3,3,3,4,5,5,,8,3,4,5,4,5,4,4,11,,
   ,3,3,,4,,5,4,5,,,5,6,,,,3,4,4,5,3,5,6,4,4,4,5,9,5,
   5,4,5,8,4,5,5,4,3,4,10,10,4,4,5,6,5,5,5,12,,,3,4,
   5,4,,5,12,5,4,,6,11,,,,5,4,4,4,4,6,6,17,3,4,6,12,7,
   6,8,7,4,5,5,4,5,5,8,9,5,5,4,7,4,8,8,6,,,4,5,7,8,,
   4,10,5,4,,4,4,,12,,5,4,4,5,5,10,5,10,6,5,9,6,4,5,
   7,3,4,4,3,4,4,11,11,3,3,5,6,5,6,6,8,13,,4,5,,5,,7,
   5,7,,,9,,,14,,5,9,5,9,4,6,7,4,5,4,9,7,5,8,3,4,4,4,
   6,6,12,,5,5,12,6,7,10,11,,,,4,4,,4,,6,5,6,4,,6,6,,13,
   ,7,7,4,6,4,6,13,4,5,3,12,7,7,4,10,8,4,8,6,6,11,5,
   5,7,12,7,13,5,8,14,,4,5,,5,,7,11,7,5,,18,12,,11,,7,
   5,5,5,4,5,30,10,6,9,6,28,6,9,8,6,11,8,8,,8,8,6,,6,
   7,7,7,16,,6,11,,8,,6,21,6,9,,7,7,,11,,7,7,7,7,7,9,,
   10,10,11,9,,4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,3,3,
   ,4,4,4,3,,4,4,,5,,3,4,4,3,3,5,6,3,3,3,5,6,4,4,4,
   4,,,4,5,5,5,5,,,6,8,,3,4,4,5,,5,5,5,4,,,6,,,,4,4,4,
   4,4,7,,4,5,4,,6,4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,4,
   5,,5,6,5,4,,6,,,,,4,4,4,4,3,7,6,4,5,4,,,4,4,,5,4,4,
   4,4,4,4,4,5,,,2,4,3,4,,4,4,4,3,,4,4,,,,4,3,3,4,4,
   6,5,3,4,3,6,5,4,8,,5,4,5,6,5,,,6,,,3,5,4,4,,5,6,5,
   4,,,5,,,,4,4,4,4,5,,,4,3,4,7,6,,,5,4,5,6,5,8,6,8,,,
   3,5,4,4,,5,6,5,4,,5,,,8,,4,4,4,4,5,,6,4,4,4,7,,,6,
   8,7,8,7,5,6,11,,,5,6,6,8,,7,8,7,7,,9,,,,,8,,7,7,5,7,
   ,9,6,9,15,,6,6,8,8,7,,,,,,5,6,7,6,,8,8,7,6,,9,8,,,,
   7,7,8,,8,,9,9,5,9,11,8,4,5,,5,,6,6,,,4,4,,4,,5,,5,,,
   5,5,,8,,5,7,4,5,4,,6,4,6,,6,6,5,8,5,6,,6,,,4,4,,4,,
   5,6,5,,,6,6,,,,5,5,4,3,4,6,6,4,7,,,6,8,4,7,7,,6,,4,
   5,,5,,4,7,4,4,,4,4,,6,,7,4,4,5,5,8,6,5,6,6,8,5,,,9,
   ,,,4,,,6,,7,4,7,,,8,9,,10,,7,9,5,6,5,,7,9,7,9,,8,7,
   7,,8,,4,5,,5,,4,7,4,4,,4,4,,6,,7,5,4,5,5,8,5,5,7,
   6,8,6,4,8,,,4,5,5,5,,7,,7,6,,,8,,10,,5,7,5,7,,6,,9,
   4,11,5,,8,10,,4,5,5,5,,7,8,7,,,,9,,12,,7,9,5,5,5,5,,
   9,4,11,6,,10,,5,6,6,6,,5,9,6,6,,5,6,,7,,,6,5,7,6,9,
   7,6,,,9,5,,4,,4,8,,6,,6,,,6,,,,,7,,,,,,11,8,7,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,4,,3,3,3,3,5,5,5,4,
   5,4,5,5,5,4,,5,,5,,,6,6,,,,3,4,5,5,7,,6,,4,4,6,6,5,,
   ,,6,,,,,,8,,4,3,5,7,,6,7,4,,,6,6,,5,8,5,,,6,6,,,,5,4,
   7,5,6,6,6,,4,4,,6,,,,,,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,
   7,7,8,6,6,5,5,8,5,,,,,,,10,,4,6,7,,6,,7,9,5,9,,8,,,,,
   ,6,,5,4,4,7,6,8,5,6,5,5,8,6,,4,4,,6,,5,7,4,3,,6,5,
   ,,4,7,5,,,,,,,,,,,,,,,,,,4,,,,7,4,,6,6,9,6,,6,5,11,5,,8,
   ,9,4,4,6,5,9,5,,10,5,11,6,,,,,,,,,,,,,,,,,,,7,7,,,,,8,,
   11,,,,,,,,,,,,,4,4,4,5,6,7,4,5,9,9,15,4,4,6,7,5,4,4,
   9,15,6,4,4,15,6,9,6,4,7,5,5,9,15,9,5,4,6,7,6,10,
   9,6,4,5,6,,,5,,6,,6,6,6,,6,4,4,,6,9,6,10,,6,,,,,,9,6,
   ,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,
   6,6,,,,6,12,6,12,,,,5,,6,6,7,4,7,5,6,7,6,9,4,6,4,4,
   6,4,,6,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,4,7,7,
   4,4,4,,7,4,7,6,17,8,9,5,10,8,8,5,13,8,9,,6,,8,,10,,
   ,6,,9,8,,5,,,,,8,,,,12,,,5,,,10,,,,5,5,5,9,9,,,,5,9,5,
   9,8,,9,,10,,,5,,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,
   ,,,,,,,,,,9,5,9,5,5,5,,9,9,5,5,5,4,7,7,4,3,5,5,4,4,
   4,5,5,3,5,,4,4,4,8,4,,8,4,,,4,6,,8,,9,,9,8,,,5,,20,,
   3,5,9,4,4,4,4,9,6,4,9,4,5,5,5,4,4,4,4,5,4,5,4,3,
   5,4,5,12,4,4,4,4,3,,4,4,,,5,6,,6,,9,,10,7,,,6,20,4,
   20,5,4,3,4,9,4,3,9,5,9,3,4,7,6,7,6,4,5,4,5,5,4,
   5,4,5,5,6,5,4,5,5,4,,7,5,6,6,7,6,,7,6,6,,6,6,,,7,
   10,9,9,5,5,7,6,7,5,5,6,7,7,7,6,5,7,4,4,4,6,4,4,
   4,4,6,4,7,7,5,4,8,4,6,,5,10,,,3,6,,8,9,8,,10,5,,,
   10,8,9,,6,5,4,7,4,3,6,6,7,4,4,7,7,7,6,7,8,7,7,4,
   5,6,6,5,9,5,4,7,7,4,,7,9,8,6,5,4,,5,8,12,,6,6,,,5,
   10,10,9,7,5,6,7,7,5,7,5,5,7,6,7,7,4,4,7,5,7,7,6,
   6,4,7,6,6,6,4,12,5,,5,8,,,7,6,,6,,8,,8,11,,,10,,,13,
   5,4,4,8,7,9,7,10,8,7,4,8,4,7,7,4,4,4,4,6,6,7,,3,
   4,6,5,6,,7,10,9,,5,6,,4,,9,,9,4,,,7,5,17,17,6,10,4,
   10,4,6,9,3,9,4,4,10,4,4,4,4,3,4,4,4,3,9,4,2,4,3,
   4,,5,5,9,8,7,6,,7,9,12,,6,3,,,6,5,5,5,6,6,4,4,4,4,
   4,7,7,4,4,4,5,7,5,7,4,5,8,4,6,4,4,3,5,6,,5,10,15,
   ,5,6,,3,15,9,,7,6,,,8,,8,,6,8,4,8,4,4,4,9,7,4,4,8,
   6,5,4,5,4,6,5,,5,4,5,5,4,,6,5,12,9,8,8,,7,11,18,,
   7,6,,,8,9,10,9,8,8,7,7,6,5,5,11,6,6,7,7,4,4,4,5,
   5,5,,4,3,4,5,4,,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,4,3,4,,
   4,6,7,6,6,4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,,4,6,,
   8,,8,,4,5,,,5,5,,5,4,5,,4,4,3,4,6,9,4,,4,4,4,4,,6,
   3,3,3,3,3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,6,6,4,4,4,
   4,3,4,4,4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,,8,4,5,,5,
   8,8,,4,5,,,5,5,,5,5,4,,4,4,4,3,5,3,4,,4,5,5,,5,4,
   5,5,4,,5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,5,5,6,6,
   6,5,5,6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,5,,4,,8,,5,4,,,
   ,5,5,,3,4,4,,4,7,6,6,5,4,4,,7,4,4,4,4,3,,6,5,,,4,
   5,,,9,8,,5,5,,,,5,,7,,,7,5,4,5,5,7,5,4,7,5,6,5,7,7,
   6,,7,,10,6,6,,,6,6,,,,6,,,,9,9,,6,5,7,,7,6,13,11,6,7,
   7,,4,5,,4,,5,5,,,5,5,,4,,8,,4,,,,4,,5,5,6,7,4,4,,4,
   5,3,6,,4,4,4,4,3,,,3,6,6,4,4,,4,6,6,,3,,,,3,6,6,4,
   4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,6,,4,8,8,,4,,,
   ,4,,5,5,7,6,4,4,,5,4,9,6,,4,4,,,5,,,12,,5,,4,,8,,5,
   5,,,5,,5,7,7,8,4,5,7,,,5,7,7,4,5,,3,,6,6,4,4,,3,6,
   6,,4,4,,,4,6,4,6,6,6,3,4,4,6,6,6,6,4,3,4,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,4,9,,5,6,,,9,8,,4,,,,5,7,,5,5,4,4,4,5,
   5,,8,8,5,4,4,,,5,6,,4,,8,,,5,,,6,7,5,,,5,4,4,5,7,8,
   7,8,5,4,4,5,,5,,8,5,8,,,,,,,,,,,,,,,,6,,6,,,,8,6,,,8,8,,
   8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,,,,4,,5,5,6,5,4,4,,3,
   6,4,7,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,5,6,6,6,5,6,5,
   5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,5,5,,5,6,3,,4,4,
   6,9,7,4,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,12,12,
   8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,5,5,,9,
   6,4,,4,6,6,7,7,4,4,,,,4,,7,5,7,7,5,4,7,5,8,,8,7,5,
   4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,7,4,8,,,8,4,5,
   7,6,6,,,5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,,5,,,,,5,5,,
   5,6,7,7,4,4,4,8,7,6,7,4,9,13,4,4,4,5,13,4,9,4,4,
   9,7,13,7,4,3,4,4,13,9,7,13,4,4,3,4,6,7,9,3,4,4,5,
   5,4,4,9,13,8,4,6,7,9,4,7,13,7,9,7,13,4,4,4,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,7,4,4,,7,,,,,8,5,3,,7,5,8,8,9,7,,,,,,5,3,
   ,,,,,,,,8,,,,,,6,3,5,5,,5,,,,,,,,9,9,7,8,,,10,9,,9,,9,,,,
   10,13,15,18,15,13,,17,,10,5,9,9,6,,14,12,18,,13,6,,,,,
   27,7,5,9,11,10,5,,5,,,,7,6,7,7,8,,8,9,,5,5,7,,7,6,
   7,7,12,16,7,9,,15,128,6,,5,9,5,20,8,7,5,,7,6,,,,,8,
   5,8,11,,5,9,5,5,,,,9,7,,,,10,12,,8,7,9,,6,8,8,22,12,,
   8,12,,18,,10,6,7,10,9,20,22,9,7,,8,18,,,,,,8,8,7,6,6,
   22,7,10,,,,4,,6,,6,10,,7,5,5,,,5,6,5,10,,7,,,,9,5,4,
   5,7,4,21,6,7,14,,9,6,19,,,,11,5,5,8,8,5,14,4,4,,,,4,
   5,,4,9,,6,5,5,,7,5,5,4,,,6,9,,9,15,5,4,5,,7,,,7,6,,
   7,,9,,,,4,5,5,4,5,5,10,5,6,,,,,,4,5,,6,6,,,,7,4,6,6,
   12,5,,,,,,,,5,,8,6,5,,,7,,,,,,7,,4,,5,6,5,6,5,,,,,8,12,,
   7,10,5,,12,11,9,5,8,,11,13,,17,,63,,5,9,16,,5,10,,,9,,
   10,,,,5,5,,,8,11,8,8,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,10,,12,6,5,,16,7,5,6,10,8,8,11,,,39,6,,6,5,8,
   9,6,10,10,,,9,24,,,,7,6,5,5,5,6,14,8,6,,,,,,,,,,,6,6,
   6,8,6,4,,,8,,4,5,5,6,12,6,7,6,,,9,9,,,,6,17,7,5,5,
   10,9,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,6,6,
   6,8,6,,,,5,,4,5,5,6,8,6,7,6,,4,7,,,,,7,7,5,5,4,4,
   15,5,6,,,,,,,5,6,6,6,8,6,,,,,6,4,5,5,5,8,6,7,6,,,6,,,,
   ,7,4,5,7,5,5,14,5,5,,,,,,,5,5,5,7,5,,,,,,3,5,4,5,6,
   5,6,5,,8,8,6,,,,5,5,,,5,11,11,4,5,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,23,6,7,8,9,11,10,9,8,,,
   11,,,,,,,8,9,6,6,17,7,8,,,,7,7,9,9,7,,,,,,5,6,7,6,9,
   8,8,7,,,,,,,,7,5,5,,7,5,17,6,6,,,,6,5,,,,,,,6,,,4,6,8,
   6,5,,,,7,,,,,7,7,5,7,5,6,7,17,5,,,,,10,6,7,,8,8,5,,5,
   5,,5,4,7,6,,7,,8,,,,4,5,5,4,5,6,7,7,4,,,,9,6,7,,8,8,
   ,,5,5,,14,,6,6,,7,,8,,,,9,5,7,5,5,9,12,22,6,,,,,,,,,13,
   ,,6,10,,10,,,,,12,,,,,9,9,6,9,8,,10,,52,,,,7,,,10,12,,6,
   4,6,10,6,,,,7,7,,,,,7,11,4,5,5,6,8,11,6,,,,,,,,4,5,5,
   7,15,7,,7,,,10,10,,,,7,,7,7,,,10,8,7,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,4,6,5,8,,8,,5,,,11,,,,,,,7,5,7,,11,5,13,,,,,5,
   ,6,8,,8,,8,,6,9,,,,,8,,,,,,9,6,8,,,,5,6,7,5,6,6,7,12,,
   ,6,21,,,,,6,,,,6,,5,5,,,,,,,,,,,,4,,4,,,,,3,3,3,,4,5,,,,,,
   5,5,,5,,,,,6,,,,,5,5,5,,,5,6,5,5,,,,,5,,7,5,,6,,7,,,,5,
   4,,6,6,5,7,12,9,,,,,,9,6,,7,5,8,,,,10,5,8,5,7,5,6,4,
   5,,,,6,,,,11,,,,,,5,6,,,,8,14,,,,,,8,6,,7,,8,,,,4,5,10,6,
   10,6,8,8,4,,,,,,,11,,,,,8,8,7,,,7,8,,5,,,,,7,7,,,,,6,17,
   5,8,7,5,7,7,6,,,,,,,,,,,,,,,,,,,,,,8,,,,,8,,7,7,,4,16,6,7,
   ,,,9,,,,,6,,8,,6,7,5,6,,,,,,,9,,5,8,5,,9,,15,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,4,7,7,9,7,4,,,,3,7,11,5,
   11,3,5,,,,5,5,5,5,6,8,,,,5,5,8,7,6,,,,4,7,12,7,,,,11,
   5,5,,,,8,5,,,,5,,,,,,,,,,,10,,5,5,,8,8,10,8,10,8,,9,6,5,
   ,11,10,6,,8,11,8,8,,,,,,5,,5,,6,10,8,,8,,10,,,,8,8,5,
   7,7,,,,5,8,5,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,8,8,5,5,5,5,6,5,5,5,4,5,5,5,4,7,5,7,8,8,8,7,
   10,10,8,,7,6,5,8,4,,5,9,8,5,16,5,,,,,5,10,5,4,5,4,
   5,7,5,18,10,9,8,8,8,6,5,6,6,7,6,7,5,5,8,4,,16,5,
   5,6,10,6,5,,6,,12,5,5,16,4,,7,12,5,8,7,8,8,,,17,27,
   5,4,5,5,5,5,4,10,10,9,6,6,4,6,6,7,4,7,5,7,6,8,4,
   5,7,7,7,6,8,13,6,10,7,15,,,5,6,16,6,,6,8,6,11,10,,6,
   ,,,7,17,7,5,10,8,10,7,20,14,4,14,8,6,8,8,6,7,4,5,
   3,4,5,3,7,8,7,8,6,8,7,8,8,20,,,4,8,7,4,17,6,8,10,
   16,,9,12,12,,,6,27,4,7,5,3,5,4,4,27,4,31,5,5,4,5,5,
   3,5,4,4,3,3,9,5,7,3,6,6,7,,5,8,,15,8,4,10,3,12,5,
   9,4,5,9,6,9,15,,12,6,7,4,3,7,4,5,3,17,6,4,7,5,4,
   3,5,4,5,3,3,4,3,6,5,8,7,8,6,7,7,9,8,,,7,6,9,4,,6,
   5,6,5,10,6,6,,,15,6,6,3,3,6,4,3,5,8,6,5,7,8,5,5,
   6,7,5,5,8,4,16,5,5,5,8,5,5,10,12,9,,,5,5,,4,,7,,8,
   5,7,8,9,7,,,18,10,4,7,5,5,5,4,9,5,10,6,6,7,5,7,6,
   8,6,6,10,11,7,4,8,,6,7,10,16,,,5,6,15,5,,6,6,6,7,7,
   13,8,,,,14,6,8,7,10,7,10,5,14,7,17,20,5,7,8,6,3,7,
   4,10,5,5,4,8,9,6,9,7,9,,,4,3,10,3,15,7,6,6,5,6,6,
   5,,,,6,6,4,5,3,3,6,3,7,6,6,8,6,6,8,5,7,4,7,5,6,7,
   7,6,6,16,16,17,,8,6,8,17,4,7,6,17,6,5,7,6,17,8,,7,
   6,9,5,5,5,5,5,5,9,6,9,9,5,5,4,4,4,6,,6,4,7,,7,,6,,
   ,,4,4,6,3,7,5,6,5,6,6,8,8,8,,,,7,4,4,6,6,7,4,4,7,
   4,,5,5,5,4,8,8,6,7,7,7,6,7,,7,,,6,5,,4,8,4,7,5,,7,
   ,7,8,,6,6,8,5,4,6,4,5,5,5,,6,8,4,4,4,,6,5,5,4,6,
   5,6,8,8,,7,4,4,6,4,,5,8,4,6,,6,,4,,,6,6,4,4,3,7,4,
   5,4,6,,,5,4,,6,5,5,4,6,5,8,8,6,,7,4,4,6,4,8,5,,4,
   6,,6,,7,,8,6,,4,4,4,4,4,4,4,6,,6,4,6,,7,4,7,8,6,,6,
   ,,,4,5,6,3,4,5,6,4,6,8,8,6,,,,,,5,4,10,4,4,3,4,7,
   4,7,5,5,4,3,4,5,4,6,5,6,,5,3,4,5,2,5,4,5,4,5,6,
   5,6,5,,,5,6,4,3,3,5,3,3,3,5,3,6,8,7,8,5,8,7,10,
   10,9,,10,6,,8,6,7,7,6,8,10,,9,,7,,14,7,,7,6,5,5,6,
   11,9,13,9,,,6,6,6,,,9,,,,6,6,9,5,7,8,8,6,6,10,7,9,7,
   ,,7,,6,,5,6,9,5,9,6,9,12,5,7,,4,,7,,,8,5,5,7,4,6,
   6,7,5,8,8,7,7,,,8,,6,4,5,5,5,6,4,8,6,8,5,7,8,5,6,
   ,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,7,6,4,3,4,5,10,7,7,,,
   6,6,7,10,10,10,,,7,4,10,4,8,7,5,4,6,5,6,5,,,8,6,7,
   6,6,,6,,6,7,6,7,7,,,10,,,,8,6,10,5,10,7,8,6,7,9,6,
   10,,,,6,12,5,6,7,,10,6,9,5,9,,,7,,,14,5,5,7,4,8,6,7,
   5,8,7,7,8,9,,9,,5,4,5,5,7,7,5,8,6,8,6,8,6,,,6,8,
   8,5,7,7,10,6,9,10,10,8,,,,,5,6,10,,7,7,5,9,12,9,6,8,
   ,,,6,6,6,,,8,6,,10,,10,,,7,12,13,9,5,7,6,,5,9,,9,13,,
   ,6,6,8,5,10,7,9,8,9,8,10,10,14,,13,,6,5,10,8,9,,7,
   9,12,9,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,14,5,9,9,7,7,7,7,
   ,10,,,,,8,,,,7,,7,8,,,,5,,4,,7,8,5,,6,,6,,,7,7,6,4,5,
   7,4,6,4,,,4,6,8,4,,5,,4,6,,6,8,7,,,6,,7,5,5,4,3,4,,
   6,4,6,6,13,,10,8,,9,,9,,,10,12,13,11,7,,5,8,7,9,,9,
   13,,4,6,4,5,5,5,5,5,,5,5,5,5,3,4,4,3,3,4,5,4,5,9,,
   ,,14,,,,,,8,8,,,,7,7,,,,,,8,5,,7,,7,14,,8,6,8,7,5,7,4,
   5,5,6,,5,8,,9,,10,,10,,,7,,5,,6,6,5,9,9,13,9,,6,8,6,
   ,7,,,6,6,6,7,5,6,4,7,,6,4,,8,6,8,,,7,6,9,6,5,9,6,
   5,,12,7,,9,8,6,10,,7,13,9,5,11,6,7,5,6,,7,,9,8,,,10,
   5,9,,6,10,5,7,6,,6,7,9,7,,,13,9,6,9,5,5,6,,,7,,9,,9,
   ,,7,7,,,,,,,8,8,,,,,,,,,,,,,,,,7,,7,,,,,8,8,,,10,6,7,5,7,
   6,6,6,6,,6,15,24,7,6,5,,6,,6,4,4,4,3,6,9,5,4,5,5,
   6,6,5,9,6,4,7,3,5,6,21,7,6,6,4,4,4,10,4,9,5,4,7,
   24,21,4,6,9,20,,4,,,6,,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,
   ,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,12,6,12,,,,,6,6,12,,,,,,8,
   7,10,10,,,9,9,9,,,,12,10,10,,13,,10,12,,,,13,,20,,11,,9,
   9,16,,,,20,,6,9,27,7,,,,,10,,12,12,,7,7,8,,,,8,5,,,,8,,
   5,12,5,,6,,6,,5,,,,4,6,,7,,,,,,,,7,,8,,5,5,6,6,5,,,,5,,
   ,5,9,6,9,7,7,8,7,9,,7,9,5,,10,,12,5,9,9,8,,6,13,,,,
   7,,,,11,24,,9,9,,9,,6,,8,11,8,11,11,,,,10,5,5,13,7,9,
   7,7,,6,8,,12,9,6,,8,13,5,6,6,,6,,5,8,,,4,6,,6,,6,,
   15,5,,,7,10,10,,5,5,5,7,5,,,,5,13,5,8,,,6,,7,8,,8,8,
   5,,8,13,6,8,6,17,7,,6,10,,,5,7,,,,7,20,10,9,12,,10,
   135,5,19,,8,7,8,6,,,,7,6,17,8,8,9,,8,8,,18,8,8,,13,
   15,15,9,11,,10,16,8,15,,,,10,,15,,16,12,21,10,,,,,,21,7,
   6,6,,55,,,,10,9,7,86,7,,8,8,,,5,6,,,,8,,7,,8,,,,,,,8,,6,
   ,,,,5,,,,8,,,,,7,,,,,,5,6,5,,,7,14,,6,7,7,,21,,8,8,,5,
   6,12,9,8,,,,5,,6,,7,12,,6,,,5,5,22,,,,6,5,17,,,,,7,6,
   20,10,11,,10,9,11,,16,19,9,4,5,14,11,9,4,10,,,,11,,15,
   ,5,19,12,4,9,,18,,,14,8,8,12,20,7,,,,7,8,7,16,16,,8,
   9,6,,,,6,8,6,13,10,,7,7,,,,10,,16,,10,30,10,9,,,13,,9,,
   10,10,9,11,6,,,,10,7,7,20,,,,,,5,,6,5,6,7,6,,4,,,,4,6,
   ,6,,6,8,6,5,,,,12,8,,5,7,17,6,6,,,,5,7,10,9,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,5,6,5,6,5,5,,,3,5,,
   5,,5,7,5,4,,,,6,,,,,5,5,5,,,,5,4,11,11,,,,,5,5,6,7,6,
   5,5,6,,,4,6,,6,,6,8,6,5,,,7,12,,8,7,5,6,17,5,,,,5,7,
   7,14,,,,6,5,6,7,6,,4,7,,,4,6,,6,,6,8,6,5,,,7,8,5,,5,
   5,7,7,6,,,,4,5,4,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,
   8,7,8,7,,7,,,,5,7,,9,,7,9,7,7,,,,13,,,,,,7,7,,,,7,8,
   10,10,8,8,9,9,8,,6,,,,6,8,,10,,10,10,8,8,,,,15,,,8,9,,
   ,11,,,,6,9,,11,5,6,,,,5,4,,,,,,6,,6,,,5,5,,,,8,11,5,8,
   9,10,5,,,,7,9,5,6,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,,,8,,
   5,11,5,11,,,,,5,5,6,9,6,8,5,7,,,,6,,,,,10,6,,8,,7,,8,
   12,8,5,17,6,6,,,,7,7,5,7,,,7,,,,,5,,7,,7,,,6,,,5,,9,,7,
   ,7,5,14,,,,,,7,9,,5,,,,,4,,6,,6,,,4,,,4,,8,,6,10,6,4,4,
   ,,,10,8,6,8,5,,,,4,,,8,,8,,,7,,,,,11,8,5,8,9,,,,,,5,11,
   5,,5,,,3,5,,,,5,8,5,,7,,6,7,6,7,5,5,10,5,5,,,,,4,4,5,
   ,,,,,7,,7,,,6,6,,,,9,,,10,11,,6,,,,7,10,6,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,7,3,3,,,,,,,,,
   4,5,,6,,6,,,4,,,4,,8,,4,5,6,4,4,,,,5,7,6,7,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,9,5,5,8,,7,8,,10,7,5,7,7,14,,,,5,17,6,7,,,,,
   ,,,,,,,,,,,,,,,,,,10,6,5,8,,7,10,10,12,5,4,11,7,6,,,,5,
   11,6,8,,6,,,,13,15,,6,9,9,,,,,,8,,11,14,4,,,,14,8,,5,7,
   5,9,6,,,,5,22,9,12,5,,4,6,7,8,,6,5,4,16,,,,6,12,5,6,,
   ,16,,,7,8,15,,5,,,,7,7,,,,,,,,,,,,,,,,,,,,11,,,10,7,,4,,,,
   10,8,7,,,,,,6,6,,,,,,,8,14,,,,,8,8,,,,,6,,9,,,14,,8,,,,,
   11,8,,5,7,4,6,,,,5,7,5,8,4,7,8,,,,5,7,5,7,5,11,,,,
   11,7,5,11,4,,,,7,7,7,9,,,,7,9,5,5,,,,,,,,,,,,,,,,12,4,8,
   5,8,11,,,8,,,,7,4,4,,4,,6,6,,7,,,,6,,6,,,5,,,5,6,,,,5,,
   ,7,,12,5,,,8,,,6,6,5,4,5,,,7,,5,,9,9,,8,7,7,10,,8,7,
   7,22,9,8,,,9,12,18,22,,12,10,,,12,8,18,,,8,,7,8,6,,9,
   19,,20,,,6,7,22,8,6,7,,,8,10,,6,,7,8,5,8,,9,5,10,5,
   16,9,,,5,8,,5,,13,9,,,12,7,17,,,11,10,,11,12,,10,63,,,,,
   11,8,8,,8,,,5,5,5,9,,,,8,10,,10,9,,13,9,31,,,,15,11,14,
   ,16,9,,,13,22,17,,,15,,18,,,18,12,19,,,,,10,,20,9,11,9,,
   27,15,8,,,6,,6,,6,5,5,5,7,9,,,10,10,7,6,,,7,,,10,7,,,,
   7,19,14,13,,,7,5,33,21,,,5,7,14,8,8,8,,11,5,4,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,5,8,,,,,4,9,,,,,,,,,
   8,,,,,,,5,7,7,,,,,,,,,,5,,5,,6,5,,7,8,,7,5,5,7,5,7,,,7,
   12,6,8,,9,9,,,9,5,15,,,7,,12,6,7,16,7,6,128,20,,,5,
   12,9,8,,11,,8,5,5,4,,5,5,5,4,7,7,,,5,,,,,9,,,,9,6,,,,
   6,11,,5,7,,7,,15,,,,5,7,10,5,5,4,,4,5,6,,5,6,6,6,8,,,
   ,5,10,9,6,,11,5,,,10,12,,,,8,24,10,7,16,8,10,6,39,9,,
   ,6,8,14,5,5,5,,7,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,6,6,6,,,,5,5,7,6,,,4,,,6,6,,,,,,,7,8,,5,6,,8,,,6,
   17,7,5,5,7,,7,7,5,5,5,5,,,,5,5,6,5,,5,5,,,5,5,6,,,6,
   ,,6,7,,,6,,,,,11,11,6,5,,,,5,5,5,6,5,,,,,6,6,6,,,5,,,,,,
   ,,6,,6,5,,8,7,6,,8,,,5,9,14,5,5,7,,7,9,5,,7,,,5,,,4,
   ,7,5,,,6,6,8,,,6,8,6,7,10,10,7,5,8,5,,,6,7,7,5,5,4,
   ,4,5,4,7,,,5,,5,,,7,,,,6,6,8,,,6,8,6,6,9,10,9,8,12,,,
   ,5,6,23,8,7,5,,10,7,7,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,
   ,11,,,,7,16,7,,7,,8,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,
   ,6,,,11,5,11,,5,,,5,5,5,,,,7,5,,,6,6,8,,,6,8,6,9,10,
   9,6,,8,14,,,9,22,12,7,5,5,,9,5,6,,,10,,,,9,7,11,,,7,
   9,7,,11,12,11,,13,,,,6,7,,,,8,,,8,9,,7,,,,6,6,8,,,6,8,
   6,8,10,10,8,6,8,6,,,6,8,8,10,10,6,,4,5,4,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,15,,,,8,10,7,,10,,7,,
   7,,,5,5,5,,,4,7,5,7,8,6,7,7,6,5,,,5,12,7,,6,6,,5,4,
   9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,6,,
   ,8,7,,8,12,,,10,7,9,7,5,5,,6,17,6,,,,6,,6,,,8,7,,,8,,
   ,4,6,15,5,4,5,,7,7,6,,,,,5,,,,,,,,,,,5,11,7,7,5,,,,13,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,,,12,10,10,,,6,
   11,8,4,5,5,,7,11,6,,,,,,21,,,,,,,9,5,5,8,,9,,15,7,8,,,
   12,8,,,,14,7,7,5,7,8,,6,17,6,,9,8,,,9,,,5,10,17,5,7,,
   ,7,10,6,10,9,23,,11,,,6,11,17,8,6,9,,,,8,,13,,,,,,,10,
   6,8,9,,9,9,52,7,,,,,7,,8,7,,,,8,8,5,,6,,,6,8,,,,,,,6,5,
   ,,,,6,9,,,,,8,,8,,,8,,14,,,,,5,6,,,,,,,,,,,,,,,,,,,,,,,11,11,
   5,4,5,,7,9,5,8,6,12,7,,7,7,5,5,7,8,,9,11,5,5,5,,7,
   5,8,5,,7,11,7,,4,12,6,,,,5,4,5,3,4,4,4,3,4,4,4,4,
   3,4,4,4,4,3,5,4,4,4,5,4,11,8,4,9,7,3,4,,6,,9,,12,,
   8,5,4,,,,3,4,3,4,4,4,4,12,6,12,8,4,4,4,4,3,4,4,4,
   4,3,4,4,4,4,3,5,4,4,4,5,4,11,8,4,9,7,3,4,,6,,9,,
   12,,8,5,4,,,,3,4,3,4,4,4,4,12,6,12,8,4,4,4,3,3,3,
   3,3,4,4,4,4,4,6,4,3,4,4,4,3,4,6,4,7,7,3,4,6,4,,
   4,8,6,6,5,4,6,,,,2,4,4,3,3,2,4,9,4,4,6,8,3,4,3,4,
   4,4,4,4,4,4,3,8,4,4,3,4,7,4,7,6,,,4,4,6,7,7,,6,
   10,9,5,10,5,6,,9,7,3,4,4,3,4,4,4,8,7,5,8,6,4,3,4,
   4,4,4,4,4,4,3,8,4,4,3,4,7,4,7,6,,,4,4,6,7,7,,6,
   10,9,5,10,5,6,,9,7,3,4,4,3,4,4,4,8,7,5,8,6,3,4,4,
   4,3,4,3,4,4,8,3,3,4,4,6,4,6,6,6,,,4,4,6,4,8,4,5,
   6,3,8,6,5,,,8,3,9,3,6,4,3,4,6,4,3,9,4,4,4,4,4,4,
   4,4,4,4,5,3,3,4,4,4,7,5,5,9,5,4,3,5,4,9,4,6,6,4,
   6,8,4,,10,5,4,4,4,4,4,3,4,8,4,4,8,4,3,6,4,7,4,4,
   5,4,4,4,4,4,4,4,7,7,6,,,6,7,10,4,9,6,8,9,5,,6,,,7,
   ,4,7,4,4,3,3,4,9,9,5,9,8,6,4,7,4,4,5,4,4,4,4,4,
   4,4,7,7,6,,,6,7,10,4,9,6,8,9,5,,6,,,7,,4,7,4,4,3,
   3,4,9,9,5,9,8,3,3,4,4,4,7,,3,4,4,4,4,5,6,,11,,3,
   4,6,4,7,7,6,7,4,6,6,6,,5,,3,4,4,4,3,8,6,7,5,4,7,
   6,3,4,4,4,3,3,3,4,4,4,4,6,,3,6,,3,3,5,5,11,5,6,7,
   4,6,,3,,,4,3,4,3,3,4,4,3,8,5,3,13,4,4,4,4,,5,3,4,
   4,4,4,6,7,7,15,6,3,4,6,8,15,6,7,8,4,7,5,,,,,3,4,4,
   4,4,9,5,9,7,4,9,9,4,4,,3,4,4,4,4,3,6,6,4,,5,3,4,
   4,4,7,4,5,6,4,,5,4,,,5,3,4,4,4,4,4,4,7,4,4,9,4,4,
   5,,4,4,4,6,4,,8,4,,,3,5,5,4,6,5,8,7,4,9,9,4,,,6,3,
   3,4,4,4,4,4,6,5,4,8,4,9,5,4,3,4,6,4,5,6,5,,4,3,
   8,6,4,7,6,10,8,3,,4,,,6,,3,4,4,3,4,18,4,7,6,4,7,8,
   3,4,4,4,4,5,8,9,5,,7,3,5,6,7,15,6,7,8,6,,5,,,,,3,,
   14,7,4,5,4,10,6,4,8,8,4,4,4,4,3,,,,9,,3,5,6,4,7,6,
   6,7,4,9,6,5,,10,,3,4,3,,4,4,7,7,5,,9,7,4,4,,4,,8,4,
   ,5,4,4,6,3,7,4,6,7,,,4,3,,6,5,3,7,4,3,4,3,4,7,5,
   7,7,4,4,4,4,11,,5,,4,4,3,6,4,10,4,5,7,,7,5,4,,,4,
   3,4,4,3,4,4,4,8,6,10,10,4,4,4,6,5,5,10,,5,3,10,4,
   7,5,6,8,6,6,6,4,,5,4,6,5,4,3,4,4,4,7,8,6,7,4,,,11,
   ,,,,11,,6,12,8,,11,12,12,4,,,9,,4,8,4,4,39,,4,11,12,
   15,9,8,5,6,,11,6,7,6,8,6,,8,9,7,4,5,4,4,,4,,4,5,4,
   3,3,10,5,6,7,4,6,4,6,5,,,4,5,5,6,11,5,11,9,,6,11,,,
   9,,4,19,7,4,,12,8,8,5,8,6,6,7,7,,6,6,7,7,16,6,6,9,
   ,6,,,,,,5,9,7,5,6,11,,10,6,11,8,7,,,3,4,9,4,9,5,,9,
   9,6,9,3,,5,,,,4,4,8,,8,9,8,5,7,3,,5,,8,8,,8,,11,15,,
   8,,,,,5,,100,167,,,8,11,14,,,28,5,4,,5,,,,,7,,,,,,,,5,,6,,
   5,,,5,,,,4,,4,,5,,7,,5,5,3,,5,5,2,3,3,2,7,3,4,9,7,
   4,7,3,5,4,,5,,8,7,,5,3,,10,4,3,5,4,3,10,10,4,10,5,
   4,8,6,7,,,6,9,,11,,5,,7,10,4,5,6,4,8,5,7,12,8,,8,7,
   ,5,7,8,10,10,6,5,,,5,3,4,8,3,6,5,6,11,5,5,11,5,,,,,
   ,16,,,,,12,7,,60,,10,13,,,,,,6,7,8,7,,5,,6,6,4,5,6,4,
   8,5,10,10,4,5,6,9,,10,,,,,,,5,8,10,,10,9,7,9,6,12,9,
   11,7,10,9,,,9,,6,7,8,6,7,9,9,9,7,10,7,10,,6,4,,10,,
   4,10,4,3,15,3,5,,9,3,12,4,9,,,,,5,14,13,5,5,9,7,12,
   7,10,,8,6,,,7,5,5,,5,10,4,6,,6,6,12,6,,,,4,6,4,6,4,,
   4,,8,4,,4,,,,,,,,,,,,,,,,,48,,5,5,20,6,50,25,7,,6,10,,5,,,
   ,,,,5,,,3,3,2,4,2,3,6,4,10,7,10,4,4,9,4,4,6,5,9,
   11,6,4,4,4,4,18,10,4,9,4,3,10,10,7,4,3,6,4,3,4,7,
   7,4,6,4,4,10,5,3,13,10,10,6,5,9,4,10,13,10,8,9,15,
   13,10,4,9,4,4,4,3,4,4,4,4,3,4,4,4,4,3,5,4,4,4,5,
   4,11,8,4,9,7,3,4,,6,,9,,12,,8,5,4,,,,3,4,3,4,4,4,4,
   12,6,12,8,4,3,4,4,4,4,3,4,4,4,3,4,4,8,11,4,4,4,4,
   4,5,3,5,7,9,4,4,8,4,,4,7,3,11,8,4,7,9,7,,4,4,3,4,
   4,3,4,4,4,8,4,7,4,4,4,4,3,4,4,4,3,4,4,8,11,4,4,
   4,4,4,5,3,5,7,9,4,4,8,4,,4,7,3,11,8,4,7,9,7,,4,4,
   3,4,4,3,4,4,4,8,4,7,3,3,3,3,4,4,4,4,4,3,6,8,4,4,
   3,5,3,8,6,5,7,7,3,4,5,6,,4,7,4,4,5,3,4,,8,,4,2,2,
   4,4,4,2,4,7,10,4,4,4,4,3,3,3,4,4,4,4,5,6,4,4,4,
   4,4,6,4,7,,,3,4,4,4,,3,6,6,4,6,4,8,8,8,,4,6,2,9,
   4,4,3,3,8,6,4,4,3,4,4,4,6,4,4,7,4,8,4,4,3,4,5,8,
   4,10,,,4,3,7,4,,4,,6,7,6,,7,,,9,7,6,3,6,4,4,3,4,7,
   8,4,9,4,4,4,6,4,4,7,4,8,4,4,3,4,5,8,4,10,,,4,3,7,
   4,,4,,6,7,6,,7,,,9,7,6,3,6,4,4,3,4,7,8,4,9,4,4,5,
   3,4,4,4,4,3,4,4,3,3,8,4,8,7,9,4,5,4,4,,4,5,4,4,
   6,4,6,9,8,8,6,5,2,4,4,3,3,4,7,9,6,5,4,4,4,4,4,3,
   ,3,4,4,6,4,5,3,,6,,3,3,4,4,,4,5,4,4,5,4,4,7,4,,4,
   4,3,4,4,4,5,4,4,7,4,5,4,3,3,4,6,6,4,4,4,4,3,7,,
   4,7,,3,4,4,4,,4,4,3,5,6,,4,11,,7,3,3,3,4,4,4,4,3,
   4,8,6,4,4,4,4,,5,4,4,4,8,4,4,4,4,8,8,3,4,4,4,,4,
   5,4,5,6,4,,6,,,4,4,3,3,4,6,4,4,4,6,4,4,3,4,,7,4,
   4,4,4,3,6,6,4,,7,3,4,4,4,,4,6,3,6,,3,4,7,,7,4,4,
   3,4,4,3,3,4,3,7,6,4,4,5,,4,4,4,4,3,,5,4,,,3,4,4,4,
   ,4,6,3,6,7,7,4,15,6,9,4,4,3,4,4,4,4,4,4,9,5,4,5,
   9,4,4,3,10,4,7,4,7,,8,3,4,3,4,,3,8,4,6,7,4,7,7,5,
   ,4,3,3,4,4,7,4,4,4,7,4,7,6,3,4,4,4,4,9,3,3,,8,3,
   3,4,,,4,,4,6,,3,,7,,,3,,3,4,4,5,3,4,5,7,,5,5,4,7,7,
   5,,9,,14,25,4,5,8,4,,10,10,9,6,7,6,8,15,7,,6,7,5,,
   8,9,5,7,4,10,8,9,4,4,,4,,3,6,,6,4,4,4,4,,3,5,3,6,
   6,4,4,,5,5,4,5,3,4,4,4,4,4,5,13,4,3,4,4,4,5,,8,8,
   8,4,4,6,4,,4,4,3,,8,4,4,,,4,6,4,3,4,3,4,4,4,6,9,
   9,3,7,4,9,5,10,8,,4,3,6,4,,4,4,3,5,6,5,4,,4,5,7,
   4,3,4,4,4,3,4,6,18,4,3,,,3,,,11,6,4,6,4,,3,6,,12,
   11,4,8,,5,10,9,14,3,8,4,,4,9,12,12,4,13,5,4,,,,3,3,
   11,3,,3,9,3,5,6,3,5,12,4,12,7,4,2,4,4,7,4,4,10,11,
   3,11,6,7,25,14,5,9,9,4,,5,11,4,8,9,5,4,,,11,9,5,5,
   8,,6,7,4,5,12,6,7,4,8,,4,4,4,4,,3,4,3,,,,6,,,5,5,3,
   3,4,4,3,,,4,,4,3,11,,3,3,4,4,,4,11,4,,,,4,,4,,,4,3,
   4,8,9,14,4,5,11,4,4,,8,,,7,,6,,6,7,19,7,,,,,8,,21,15,,
   ,7,7,8,29,,,6,6,,7,,,10,,8,9,,7,,,,,7,21,,15,8,,12,7,,
   27,,4,,4,,4,6,3,,8,3,3,,5,5,3,2,2,3,7,4,3,4,9,9,4,
   3,9,4,,4,,4,11,,5,5,,4,10,4,3,3,4,4,4,3,4,3,8,4,4,
   4,,,6,4,,11,,,,5,19,4,3,4,10,13,4,4,3,14,,4,3,,4,,4,
   6,5,5,6,10,,8,4,3,6,6,5,4,3,4,4,7,4,4,,,,,,,,,,,,,,,,,,
   ,,,,,10,4,5,6,,10,11,6,12,4,3,4,9,5,4,3,3,4,10,5,4,
   ,12,,,,,,,5,10,5,,10,6,4,31,12,10,7,13,4,6,,,15,5,,4,
   3,3,84,3,4,3,5,4,10,4,3,6,5,5,,,7,6,4,4,5,19,7,4,,
   13,12,8,8,7,7,11,,8,7,5,5,6,9,7,5,6,7,11,,10,4,,,
   10,7,3,,8,,4,4,8,5,,8,4,7,,,5,4,3,14,4,4,3,,8,7,5,
   4,,12,,60,12,7,,100,167,,51,,8,21,,11,17,,5,5,,6,,,,,5,,
   ,7,,5,65,,76,34,11,8,,4,3,4,6,4,4,4,4,18,5,6,2,4,
   11,4,2,3,3,7,4,3,3,3,3,2,4,13,6,3,2,4,6,11,9,6,6,
   4,4,4,4,9,6,9,4,3,4,4,4,9,4,7,3,3,10,10,3,4,13,
   10,4,11,3,7,9,11,4,4,3,4,4,3,4,4,4,3,4,4,4,6,7,4,
   4,3,,4,4,8,7,4,,4,6,10,7,9,5,7,6,8,4,4,,,,,4,4,4,
   4,3,3,4,6,9,7,6,7,4,3,3,3,3,4,4,3,4,2,4,5,6,4,3,
   4,6,3,6,5,6,6,6,3,4,6,4,6,8,4,4,7,8,4,4,6,6,6,4,
   4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,3,4,4,4,6,7,4,
   4,3,,4,4,8,7,4,,4,6,10,7,9,5,7,6,8,4,4,,,,,4,4,4,
   4,3,3,4,6,9,7,6,7,4,3,4,4,3,3,4,3,4,6,4,4,4,4,8,
   4,5,7,5,10,,4,4,5,4,5,4,4,6,5,4,4,6,5,9,9,4,8,3,
   8,4,4,4,4,4,4,4,4,4,3,6,4,5,4,3,6,4,8,4,3,4,5,5,,
   ,8,10,8,6,5,8,6,10,5,7,6,8,4,5,7,8,10,10,7,7,4,6,
   4,4,4,6,7,7,7,7,4,4,4,4,4,3,5,4,4,3,4,3,4,4,5,6,
   6,9,,4,4,8,4,8,6,4,4,7,6,6,5,7,8,7,6,4,4,4,3,3,
   4,4,4,4,4,6,6,4,5,4,3,6,4,8,4,3,4,5,5,,,8,10,8,6,
   5,8,6,10,5,7,6,8,4,5,7,8,10,10,7,7,4,6,4,4,4,6,7,
   7,7,7,4,4,4,4,4,6,,4,4,4,6,4,5,6,,6,,3,4,8,6,8,7,
   ,7,6,4,4,4,,6,,4,4,4,3,4,5,6,7,6,5,5,6,4,4,4,4,
   4,4,4,4,4,4,4,5,,4,5,,3,4,8,7,8,7,6,6,8,5,,4,8,,
   6,3,4,3,4,4,4,4,6,8,6,7,4,4,2,4,,3,3,3,3,9,3,4,,,
   5,5,2,3,5,4,5,4,4,4,9,3,3,,6,8,8,4,4,4,4,3,3,3,
   4,4,5,5,5,4,4,,6,4,4,4,7,4,10,10,4,,6,3,5,6,5,6,
   4,6,5,8,,5,4,8,,6,4,3,4,4,4,4,4,5,5,7,17,4,4,3,,
   3,3,3,5,3,,5,4,7,7,2,6,9,5,6,6,6,5,5,4,4,2,5,5,
   5,4,4,4,4,3,4,4,5,5,4,4,4,6,6,4,4,4,10,4,6,6,6,,
   6,3,5,8,5,10,4,6,5,8,4,4,4,10,6,,4,4,4,4,4,6,5,5,
   5,5,5,17,4,4,6,4,6,6,6,9,9,,6,3,4,,4,5,4,4,4,,,5,,
   7,,8,3,,4,6,4,4,4,4,,6,7,5,4,4,,,4,,5,,8,6,4,3,,6,
   7,7,7,6,,8,3,6,,7,,4,6,4,,,6,,6,6,,7,,4,3,,4,,8,5,,
   5,4,4,,4,6,4,4,4,7,7,4,3,,9,8,4,12,4,4,3,4,3,4,4,
   19,7,4,4,6,3,5,,5,7,7,5,3,5,5,8,4,5,5,,4,4,3,6,6,
   6,6,5,4,4,4,4,4,5,6,4,4,4,,4,4,9,5,4,,7,5,10,6,,
   7,7,8,,4,,3,,8,,13,4,4,4,3,3,4,8,7,7,6,4,,,9,,,,6,
   6,7,5,,4,6,7,9,7,4,6,35,7,,6,24,4,7,12,,5,8,8,10,
   7,9,5,6,,7,7,5,3,5,5,8,4,5,5,9,4,4,9,10,6,10,6,5,
   4,4,4,5,5,5,6,5,5,5,10,6,10,8,5,6,6,7,9,12,,9,10,
   6,5,4,,,12,5,10,5,5,,5,4,9,7,14,10,8,,12,,6,6,8,8,
   13,7,6,6,,,,7,12,5,11,12,9,12,6,8,9,,7,7,5,6,6,,,3,
   6,11,8,,9,10,11,6,4,4,4,16,9,,,6,4,6,5,6,7,11,9,10,
   8,4,7,4,7,7,6,7,4,8,8,,6,5,,,,,5,,25,14,104,,5,6,6,,
   60,42,7,6,7,5,6,6,5,5,,7,5,7,,,,,6,16,68,,6,,5,5,,,
   38,4,,5,,7,6,5,,4,4,3,,7,8,3,3,3,3,7,4,4,5,14,19,
   5,3,6,5,7,6,,5,5,,3,4,8,7,7,4,5,4,4,5,5,4,5,5,6,
   6,6,8,9,,,11,,11,,,,,17,9,6,9,9,12,8,8,11,8,,11,7,,7,
   4,4,9,6,5,5,10,,8,6,5,7,6,6,5,6,4,4,6,20,6,6,48,,,
   8,7,,,,,9,6,61,101,90,6,8,,,,35,27,7,7,10,6,,6,9,11,
   11,7,4,7,7,7,4,7,7,7,7,6,7,,9,,5,,7,10,,6,6,6,,8,
   6,11,15,4,7,8,18,10,6,5,,8,8,,6,5,6,7,9,5,7,5,4,
   10,6,19,7,,9,48,11,8,9,9,9,6,25,10,7,,26,11,9,6,4,
   4,9,,7,5,12,5,4,4,4,4,6,6,8,,5,4,,,7,,5,,4,4,4,4,
   5,5,,,5,6,7,,5,,4,6,3,3,3,,,5,5,4,6,10,61,101,9,6,,,
   37,,,,5,7,8,42,,,6,8,,8,,,5,,6,20,113,6,,,12,42,,,,7,,
   4,3,4,9,4,4,6,7,21,7,9,4,4,9,4,4,5,5,7,10,10,4,4,
   4,4,6,9,6,7,4,4,5,8,7,6,5,5,6,3,4,9,7,7,6,4,4,5,
   5,11,11,6,7,6,21,9,4,4,,8,13,8,20,7,4,5,5,4,4,4,4,
   3,4,4,4,3,4,4,8,11,4,4,4,4,4,5,3,5,7,9,4,4,8,4,,
   4,7,3,11,8,4,7,9,7,,4,4,3,4,4,3,4,4,4,8,4,7,4,4,
   3,4,4,4,3,4,4,4,6,7,4,4,3,,4,4,8,7,4,,4,6,10,7,9,
   5,7,6,8,4,4,,,,,4,4,4,4,3,3,4,6,9,7,6,7,3,4,4,4,
   4,4,4,4,6,8,,3,4,4,5,9,8,11,,,,4,4,8,4,,4,4,12,5,
   3,5,,7,9,,12,8,4,12,4,3,4,4,4,4,4,6,4,4,4,4,4,4,
   4,6,8,,3,4,4,5,9,8,11,,,,4,4,8,4,,4,4,12,5,3,5,,7,
   9,,12,8,4,12,4,3,4,4,4,4,4,6,3,3,4,4,4,4,6,5,4,4,
   4,3,3,4,6,8,5,8,,4,4,5,3,,3,4,4,8,6,5,7,8,8,,10,
   4,4,4,2,2,4,4,4,4,2,7,4,3,5,3,4,4,6,4,4,4,4,4,4,
   4,8,4,8,9,4,5,8,4,8,3,6,4,4,4,3,5,9,7,,9,6,3,4,
   3,2,4,4,5,6,5,7,4,4,3,4,4,8,,3,3,4,4,4,4,4,,5,,3,
   3,8,3,6,3,4,3,4,3,6,6,6,8,,3,4,4,4,3,3,7,4,3,4,
   3,9,4,4,4,4,6,6,4,4,4,4,3,3,,4,5,,3,4,6,4,5,4,4,
   3,5,3,,5,6,,,4,4,4,4,4,3,4,4,3,4,5,5,4,4,4,,11,4,
   4,3,5,4,4,4,4,4,,3,4,6,4,10,3,5,4,5,3,4,,6,,,4,4,
   4,4,3,3,4,4,4,4,7,7,4,4,,6,3,3,4,3,4,3,3,4,,6,4,
   4,5,4,7,3,4,3,7,,4,6,7,,,4,3,3,4,3,3,4,4,4,4,5,4,
   4,8,,4,4,4,4,4,,5,6,,,4,4,8,4,4,4,4,3,4,4,4,4,8,8,
   ,4,4,4,4,4,3,3,4,3,6,4,6,5,6,4,4,4,5,4,4,4,4,,
   10,4,4,6,4,8,3,6,4,4,,4,,7,7,,4,4,4,4,3,6,5,6,4,
   4,3,17,6,6,7,6,7,6,,9,11,,7,5,6,,7,8,6,7,6,7,,11,,
   9,29,,11,,7,6,5,5,9,6,10,7,5,7,5,6,5,5,5,,8,,,,4,5,
   ,6,6,5,5,4,6,6,12,12,8,7,,12,8,7,,4,4,19,5,8,6,4,
   13,3,4,,4,,7,4,,11,4,4,6,4,7,3,4,3,6,6,4,4,,7,,8,
   6,4,3,4,3,4,4,4,6,3,4,4,7,4,5,,4,6,15,4,4,6,4,9,
   3,4,3,,5,4,6,,,,9,5,4,4,4,3,4,4,4,4,4,4,5,4,5,9,
   6,4,,4,4,10,3,5,4,4,3,7,4,7,4,,8,,18,4,4,4,3,3,4,
   4,3,7,4,6,,,5,,,,4,4,,4,10,3,4,,6,3,4,,,7,,,8,4,8,4,,
   ,8,4,7,3,6,3,5,,6,11,4,4,5,3,12,3,10,4,10,4,3,10,,
   6,,10,5,4,3,3,4,5,9,4,7,3,7,3,4,,9,3,7,7,4,5,4,5,
   3,9,3,3,4,,11,,4,7,3,4,,3,4,4,3,8,4,,4,7,,4,4,7,7,
   11,4,4,3,,5,,6,14,25,,5,4,14,4,7,3,,4,4,9,4,5,,,5,
   4,9,4,13,11,,9,8,,6,6,,,,,4,4,39,4,4,8,10,3,13,9,5,,
   4,6,,5,6,4,,5,7,5,5,,,,,5,,,,6,,5,5,5,,25,,5,6,,7,9,
   9,6,15,15,6,,,,,,,8,100,,167,5,,6,8,,21,51,4,,4,,4,4,4,
   ,3,4,5,,6,,3,4,4,4,5,3,4,4,5,4,4,5,7,4,6,4,,4,5,,
   8,5,8,8,,3,4,6,4,4,3,4,3,4,5,4,5,7,,,9,9,,,,11,,13,
   ,11,7,9,5,14,5,8,7,5,,10,6,,4,7,4,9,5,10,8,8,,,3,
   4,7,4,4,3,4,4,4,4,4,5,9,,,,7,10,,,,,6,8,65,25,,4,4,,,
   ,,12,5,3,5,4,,9,,,,3,3,7,4,4,2,4,4,3,7,4,10,,8,,8,,
   7,,,3,5,4,,3,3,4,14,4,5,4,16,9,4,,,,6,,3,4,4,5,3,3,
   3,84,3,9,3,21,6,7,10,25,14,,10,8,9,7,5,5,8,,9,6,7,
   5,4,,8,,,3,,5,4,3,3,4,4,5,4,,,6,11,,,12,4,,9,4,3,4,
   8,13,9,14,12,10,,,10,7,6,31,4,5,10,,6,6,10,12,,,,27,
   8,12,,102,15,,,,7,9,,29,,,7,7,21,,15,,8,,8,,,,,,,,,,,,,4,
   4,3,10,2,4,3,3,18,4,10,4,4,10,3,4,4,4,5,4,15,4,4,
   3,4,6,7,4,4,4,3,4,9,9,4,6,3,7,2,4,11,3,4,2,4,3,
   3,2,3,3,13,4,3,6,11,6,4,4,7,6,6,2,5,4,7,7,4,3,4,
   4,4,4,4,4,4,3,8,4,4,3,4,7,4,7,6,,,4,4,6,7,7,,6,
   10,9,5,10,5,6,,9,7,3,4,4,3,4,4,4,8,7,5,8,6,4,3,4,
   4,4,6,4,3,7,10,5,4,4,4,5,6,6,7,8,9,,4,4,,3,7,4,6,
   9,4,8,7,10,,,,5,8,4,8,4,4,4,3,6,3,4,7,4,3,3,4,4,
   4,3,4,8,7,4,2,4,4,8,5,6,6,6,6,4,3,6,4,6,3,4,4,6,
   5,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,3,
   7,10,5,4,4,4,5,6,6,7,8,9,,4,4,,3,7,4,6,9,4,8,7,10,
   ,,,5,8,4,8,4,4,4,3,6,3,4,7,4,4,6,3,3,4,6,5,4,3,
   4,4,4,4,4,8,6,6,4,6,8,4,6,4,7,4,5,6,4,7,6,6,6,5,
   6,3,4,4,3,4,4,6,5,6,6,4,4,4,3,3,8,,4,3,4,5,4,4,4,
   ,5,,3,4,4,3,,4,8,4,4,5,5,5,7,8,,4,3,4,3,4,4,12,4,
   4,4,4,6,4,4,4,4,10,10,4,4,4,4,4,6,,7,6,,4,4,6,4,
   7,4,6,3,5,6,,5,6,,9,4,4,4,4,4,4,3,4,4,5,6,5,4,3,
   4,,5,4,3,4,5,3,4,6,6,7,7,4,3,4,4,7,3,6,4,5,6,4,,
   4,6,6,4,4,4,4,4,6,5,6,4,4,4,4,4,4,,5,4,4,4,4,4,
   4,4,4,,5,4,4,4,4,8,4,5,3,5,,4,5,5,,8,4,4,3,4,4,3,
   4,4,4,4,6,4,3,5,,4,2,4,4,3,,3,5,7,7,3,3,9,3,6,3,
   6,2,4,,,4,5,5,5,4,4,4,3,4,4,4,3,3,3,3,4,9,4,4,3,
   4,5,4,,4,,,4,3,4,6,3,,4,10,4,4,8,4,8,7,9,,3,4,4,3,
   4,13,4,8,4,4,4,7,10,6,,6,,6,5,9,9,,12,5,6,6,8,11,
   6,8,7,,,11,,7,11,13,9,,12,8,6,12,9,10,6,6,10,8,5,4,
   6,6,5,,6,,8,10,4,5,9,4,12,10,10,5,4,,6,5,7,,,5,4,5,
   ,5,5,10,4,5,6,10,10,4,4,,4,,6,6,,6,4,4,7,4,9,4,5,
   3,10,10,4,6,,6,7,5,6,4,4,3,4,4,4,5,7,4,4,4,,3,3,,
   9,5,5,3,3,5,3,5,3,4,2,,5,4,6,7,7,6,3,3,4,3,4,4,
   4,3,4,4,4,4,6,4,6,6,10,6,,4,4,10,4,8,4,,3,6,6,6,,,
   6,8,6,5,4,4,4,4,4,4,8,6,5,8,,,9,,,,5,4,,4,,4,5,3,
   6,11,4,,,9,16,6,7,4,5,6,,6,4,5,6,4,9,4,6,,7,7,4,3,
   5,4,7,3,6,4,10,6,4,10,7,6,7,5,5,4,4,4,6,5,6,5,7,
   4,7,4,,6,8,5,4,4,4,7,6,6,,,9,9,,,7,,6,,4,,,4,6,4,5,
   ,5,,6,6,,3,4,4,4,,4,,3,,5,,6,8,6,7,4,4,4,4,6,3,,4,
   3,6,3,5,,,5,4,7,4,8,5,11,7,9,6,,9,11,7,32,,5,4,12,
   7,6,24,8,5,8,5,8,7,8,6,7,9,6,6,10,,,8,9,14,,,,6,,16,
   ,68,,6,8,8,187,25,185,5,4,11,5,7,7,7,8,7,7,6,8,,,,,
   5,25,,14,5,,5,5,74,57,160,4,,3,,4,5,4,,8,5,8,,5,,4,
   4,4,3,12,4,4,3,6,17,3,6,4,4,6,3,,4,5,,5,6,7,7,7,
   4,4,6,6,5,4,4,4,4,4,4,4,4,32,,9,7,,8,,10,,7,7,6,5,
   6,6,24,4,6,4,12,,5,,,4,8,4,4,9,5,10,4,,,4,4,13,8,4,
   4,4,3,3,3,17,4,7,8,,,13,16,,,,,8,9,112,,248,8,7,,,,17,
   30,10,4,5,6,,6,7,7,7,4,4,6,6,5,4,4,4,4,5,5,5,,5,,,
   ,8,14,,9,6,7,,6,5,6,8,5,10,6,11,5,7,3,,8,,,4,4,7,
   14,3,7,3,14,4,4,4,19,10,6,10,28,8,12,6,10,5,4,10,5,
   5,,10,5,4,6,,8,12,,11,6,10,12,10,9,12,6,8,8,9,,6,5,,,
   ,6,4,,4,6,4,6,5,5,6,7,5,7,10,44,10,6,5,8,6,7,6,,
   11,9,7,5,7,7,74,57,5,7,,34,14,104,,,5,5,6,187,25,,8,
   6,16,68,,27,6,,8,,17,8,,7,112,,,30,8,9,,4,4,3,5,4,4,
   4,4,6,5,8,4,4,8,4,4,4,4,7,4,4,4,4,3,4,9,8,4,6,4,
   4,9,9,16,12,4,4,7,4,4,9,6,7,4,4,4,4,4,4,4,8,4,4,
   5,8,6,3,3,6,12,10,3,7,4,7,4,4,4,3,6,4,7,4,4,4,,5,
   4,4,4,6,6,7,7,10,7,,6,7,6,5,,4,,9,4,4,4,8,,,9,5,9,
   3,9,4,4,3,4,8,4,7,9,3,4,4,3,4,4,4,4,6,7,4,3,3,6,
   6,6,5,8,8,7,4,4,6,5,7,4,5,4,4,4,4,4,,9,8,4,4,3,
   4,4,4,3,4,6,6,4,4,4,4,4,4,3,4,6,5,5,4,4,2,6,4,6,
   6,6,8,,4,4,6,6,,4,6,4,5,5,6,6,,8,,5,4,3,4,3,3,3,
   4,5,5,4,5,6,4,7,4,4,4,,5,4,4,4,6,6,7,7,10,7,,6,7,
   6,5,,4,,9,4,4,4,8,,,9,5,9,3,9,4,4,3,4,8,4,7,9,4,
   4,4,4,4,6,,4,4,4,11,4,5,6,,8,,4,5,6,4,6,5,6,5,4,
   4,4,4,,7,,4,3,4,4,4,5,6,7,6,5,5,7,4,4,4,3,7,7,4,
   3,3,6,4,5,,6,5,,4,5,8,6,11,6,6,5,5,4,,5,,,5,4,4,4,
   4,4,4,3,5,6,5,7,5,3,4,3,,5,4,4,3,6,4,4,8,8,,6,3,
   6,7,7,,4,11,7,4,3,4,,,12,12,4,3,4,4,3,3,4,7,7,4,6,
   6,4,3,,5,4,4,3,6,4,7,7,6,,5,3,7,6,7,9,4,11,6,4,,
   4,6,,,6,4,3,4,4,4,4,4,6,7,4,8,5,4,6,,4,4,4,,4,,6,,
   3,3,4,5,6,4,6,5,6,5,4,4,4,5,,9,10,4,4,4,4,4,4,4,
   4,6,5,5,11,5,5,4,3,2,5,4,9,5,9,,5,3,4,5,4,6,3,5,
   4,3,9,3,9,,7,,3,3,3,3,4,27,3,5,5,4,4,6,7,6,8,5,8,
   6,6,7,10,,,6,5,6,6,14,6,6,,9,,9,,,,11,8,,6,12,8,5,6,
   5,6,6,6,,5,4,9,9,5,,6,,,,4,6,7,4,7,7,7,6,4,5,10,5,
   ,13,,5,4,5,,5,5,8,4,7,8,7,10,4,4,,4,,6,11,,8,5,5,
   6,4,7,4,6,5,4,4,4,4,,9,8,5,6,4,4,4,4,3,4,7,9,5,
   6,3,8,4,5,,6,6,,7,6,10,7,,6,7,6,,4,5,5,,,4,3,4,4,
   3,4,4,3,7,7,7,7,5,9,4,5,5,5,5,,4,4,5,4,6,4,5,4,
   3,3,3,3,,6,5,27,3,3,4,3,3,3,3,5,5,4,4,,,10,,,7,8,
   7,9,5,12,6,8,7,10,6,8,6,,11,,9,7,7,11,12,,5,6,9,6,
   6,13,5,6,,9,9,5,5,6,4,7,4,6,5,4,4,4,4,,6,,5,4,3,
   4,4,5,4,7,7,7,5,7,7,9,,,5,7,7,4,6,5,6,5,5,6,5,4,,
   11,13,5,8,5,5,,5,4,5,6,11,7,8,8,,,8,6,6,6,10,11,6,
   7,,9,,9,,,7,5,6,6,8,12,8,,8,9,8,6,7,7,,6,6,8,5,8,
   6,10,8,6,8,6,7,,7,51,,5,7,12,11,9,7,9,6,8,7,6,3,4,,
   ,6,,4,,,6,,4,7,,,,5,,17,,,,3,5,6,,,10,3,,,,,,,,,5,,,,,,,
   3,17,,,5,,,,,,,5,,7,,4,8,5,,4,3,4,,8,5,4,3,3,3,10,4,
   3,4,15,6,7,6,7,7,,5,,4,7,,7,10,,,,7,7,4,6,7,5,4,5,
   7,5,6,6,6,,,7,8,,9,,8,,12,8,,5,5,8,15,8,10,8,10,,6,
   8,,6,6,7,9,10,9,10,,,8,6,6,5,5,7,6,5,5,9,5,9,5,,,,,
   18,,,,,,11,8,,55,,10,14,,,41,,,7,5,8,6,,5,,10,7,8,5,4,
   6,15,4,4,4,8,4,7,6,,9,,9,,,14,,8,10,5,,8,6,5,10,8,
   7,8,,7,,7,,,,,7,12,4,7,7,5,4,18,14,5,6,6,4,3,4,,,5,
   6,4,3,3,10,4,3,,18,5,12,6,4,9,,,14,4,5,4,4,4,4,4,
   10,11,5,,8,4,,,5,6,3,,4,4,4,3,9,9,4,12,6,,11,,8,4,
   8,8,5,14,4,,26,5,6,5,,,,,,,,,,,,,,,12,,,,11,11,,26,,,7,,
   12,116,,8,,10,36,20,144,45,6,6,,4,4,3,5,4,4,6,8,9,6,
   12,2,3,5,4,2,6,7,6,4,4,4,4,4,2,4,6,4,4,,4,5,5,8,
   13,4,7,8,3,3,14,20,7,6,10,4,5,6,5,7,23,4,5,4,7,4,
   8,4,28,10,9,7,7,7,7,6,4,4,4,4,4,4,4,6,8,,3,4,4,5,
   9,8,11,,,,4,4,8,4,,4,4,12,5,3,5,,7,9,,12,8,4,12,4,
   3,4,4,4,4,4,6,4,4,4,6,4,3,7,10,5,4,4,4,5,6,6,7,
   8,9,,4,4,,3,7,4,6,9,4,8,7,10,,,,5,8,4,8,4,4,4,3,6,
   3,4,7,6,4,7,4,4,4,,5,4,4,4,6,6,7,7,10,7,,6,7,6,5,
   ,4,,9,4,4,4,8,,,9,5,9,3,9,4,4,3,4,8,4,7,9,4,4,3,
   4,4,5,,3,3,5,5,5,6,4,,5,,4,4,3,4,5,7,3,7,4,4,,,5,
   12,,4,7,4,9,4,4,7,3,4,4,4,7,4,4,4,3,,,3,4,4,4,4,8,
   ,6,6,,3,3,4,4,5,4,3,7,4,4,,6,5,,7,7,7,3,7,4,4,4,
   3,4,3,7,5,4,3,4,,7,3,5,3,5,5,6,7,7,10,,4,4,4,8,4,
   6,3,8,5,5,11,,4,,,4,8,10,10,4,4,10,3,6,3,5,5,4,4,,
   4,4,4,4,5,4,6,6,4,,,4,4,4,4,5,3,4,6,3,,4,5,5,,7,
   4,9,4,7,4,4,4,4,4,3,9,4,4,7,,4,4,4,5,4,,11,6,,,4,
   4,5,3,4,4,4,7,4,4,4,5,4,,10,10,10,4,8,4,4,4,3,4,
   3,4,6,10,10,5,4,4,6,5,7,6,7,,,4,8,4,4,5,6,5,8,4,
   7,6,7,5,8,,5,11,5,11,6,8,6,3,5,3,4,6,,6,9,6,9,7,
   6,6,12,,,6,7,6,,,5,,10,9,,12,,,,,10,,9,12,7,13,5,5,8,
   5,14,11,4,4,6,6,8,,,,10,,4,4,9,3,,4,4,7,4,6,12,10,
   7,15,,3,12,3,,5,4,15,3,4,4,10,9,4,4,,5,,6,5,,,3,3,
   3,4,4,4,3,7,3,3,4,6,,7,11,3,13,4,8,3,3,4,3,4,5,4,
   5,4,9,5,8,,5,,,4,4,4,4,6,4,4,7,,5,6,8,,,6,4,8,4,6,
   4,4,4,4,4,3,3,5,6,5,5,6,10,5,,4,4,5,4,4,4,4,8,4,
   4,4,6,,10,7,6,7,4,7,4,4,4,3,4,6,5,8,,,11,,,,6,5,9,
   4,7,4,6,9,6,5,4,,,8,16,6,12,4,,6,,10,5,6,5,5,6,6,5,
   ,6,,7,6,5,6,6,8,5,7,6,6,8,6,,8,,5,6,5,10,10,6,8,
   4,9,4,5,4,6,7,,,6,7,7,6,,6,,9,,9,11,6,,19,16,11,12,
   11,10,,7,6,5,7,14,12,10,7,9,,5,6,5,5,,5,,9,,8,,11,,,
   11,8,6,12,8,8,7,,4,6,10,19,9,7,,6,6,9,6,,8,6,9,6,6,
   ,6,,15,,,8,8,12,7,6,8,4,12,6,5,8,,5,,5,6,,4,,9,10,,
   9,,,,,7,,20,50,6,,5,5,6,,48,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,
   4,,4,6,7,,7,4,6,,11,7,4,7,8,7,6,4,3,4,6,4,4,5,7,4,
   ,4,,8,5,,4,7,6,15,15,4,9,9,9,5,4,4,4,9,3,4,7,5,,,
   3,9,,5,,,,,9,5,7,,9,8,4,8,4,,,,8,,4,,8,5,9,6,10,4,,
   7,4,7,18,7,4,4,4,3,8,3,4,6,,,,,,,,,,,5,,,,,5,,,,10,,,4,
   7,3,5,,9,6,11,,4,6,10,6,5,4,3,3,4,4,5,7,,5,,,,,,,4,,,
   ,4,4,4,6,4,4,6,8,7,8,11,,,11,,10,7,9,9,9,8,7,6,10,
   6,7,7,3,4,6,,,7,,9,4,7,7,3,4,,7,3,4,5,4,7,7,,15,4,
   8,5,10,4,14,4,7,8,3,,6,,,,12,15,9,,11,4,4,39,4,8,4,
   8,12,,,,12,9,9,9,7,10,10,,11,5,8,6,,,,,5,,,,,10,,,5,,,,,
   ,11,8,165,,167,56,21,,14,,,10,,13,,,60,,12,7,,10,3,13,
   5,4,4,3,4,10,9,9,13,10,9,9,6,6,9,7,11,15,10,4,4,3,
   10,10,2,4,6,10,18,7,7,8,6,6,10,4,4,10,4,4,4,6,4,4,
   4,3,4,10,3,4,4,9,7,4,2,13,4,10,6,13,3,4,5,4,4,4,
   6,4,4,7,4,8,4,4,3,4,5,8,4,10,,,4,3,7,4,,4,,6,7,6,,
   7,,,9,7,6,3,6,4,4,3,4,7,8,4,9,6,4,5,4,3,6,4,8,4,
   3,4,5,5,,,8,10,8,6,5,8,6,10,5,7,6,8,4,5,7,8,10,10,
   7,7,4,6,4,4,4,6,7,7,7,7,4,4,3,5,5,4,,4,4,7,4,7,
   6,8,,8,,4,3,8,3,9,5,4,5,4,3,6,6,7,7,,19,5,4,5,4,
   4,7,4,4,3,4,14,4,4,4,4,7,7,4,3,3,4,4,8,,,9,,4,3,
   5,4,8,4,3,4,4,4,,4,5,,6,19,7,4,4,3,4,3,4,4,4,12,
   4,5,3,5,,5,4,6,5,3,6,6,6,6,7,8,4,3,6,5,7,3,4,5,
   3,4,6,,6,7,7,6,6,5,5,4,4,5,4,6,4,5,5,4,5,,8,4,4,
   4,5,4,10,10,6,,8,4,4,4,4,6,4,4,5,6,,7,6,6,,,7,17,
   4,5,4,4,4,4,4,4,6,5,5,4,,4,3,4,4,4,,5,5,6,6,4,3,
   5,4,6,3,3,5,4,6,6,5,7,7,8,4,4,4,5,4,4,4,4,4,6,5,
   6,6,9,7,5,6,5,7,8,7,8,,10,6,4,8,5,8,5,5,4,6,4,5,
   4,5,,,6,20,5,4,6,7,6,6,6,6,5,6,7,5,4,4,4,6,,9,11,,
   9,4,3,4,4,7,4,4,6,8,,7,,7,,8,8,,4,6,4,5,4,4,5,5,
   12,6,8,5,,,10,,10,,11,48,6,9,6,8,8,9,9,10,,,9,9,,,,
   11,9,10,,7,9,25,6,6,9,9,26,4,4,,7,,5,8,,8,4,4,4,4,
   6,4,4,6,4,4,4,6,,5,8,6,7,4,6,4,3,4,4,4,6,4,8,3,
   4,6,5,,9,5,5,4,2,4,4,5,3,2,5,,3,5,6,7,7,6,4,4,4,
   5,4,4,3,4,4,4,4,5,,7,9,4,10,8,,4,3,5,4,,4,3,8,,4,,
   7,,4,,7,6,3,8,4,4,3,4,4,13,4,7,,,5,,,,4,3,4,4,7,4,
   4,5,3,5,4,5,8,5,7,,,4,5,4,,4,4,5,,5,5,7,12,,11,9,
   7,4,9,4,11,4,6,7,7,4,4,7,6,4,6,7,6,4,7,7,7,7,7,
   7,7,4,7,10,8,5,12,6,,,6,11,6,9,6,5,9,9,6,,13,13,5,
   6,9,7,,12,8,6,6,12,9,7,6,,,5,4,6,6,12,5,4,9,,,,,8,
   10,9,14,10,5,9,4,5,,7,8,6,10,7,,,8,5,11,8,17,5,,11,,
   ,7,,7,7,9,,11,8,11,8,9,12,9,7,9,6,8,6,6,8,9,6,8,
   6,7,8,7,,7,10,,,,5,,,,8,,8,6,6,42,,,,6,16,10,10,10,6,
   8,,7,35,7,,,,,5,,,37,9,,6,7,61,101,,4,,4,,4,4,7,,6,6,,
   ,6,8,5,5,5,7,6,4,4,3,6,4,4,6,,4,8,3,,4,3,,9,4,5,
   5,5,5,5,3,4,3,4,3,4,5,4,4,4,6,,,9,11,,9,,11,,,,10,
   8,6,11,12,4,5,12,10,,6,9,,4,4,5,6,6,10,6,6,,10,5,5,
   6,5,5,4,4,4,17,4,4,5,10,,,,8,,,,,,,7,12,,42,6,,,,20,
   113,,9,5,4,6,,5,7,7,8,5,5,5,5,5,4,4,4,5,6,5,6,,6,,
   6,,7,,,5,5,3,,3,4,3,6,4,5,,,6,4,7,,5,8,,10,6,5,5,7,
   6,9,7,19,6,5,4,4,,7,6,8,7,,7,6,6,,4,,,,4,6,6,6,4,6,
   ,,6,7,4,4,4,4,4,6,5,3,,,6,,,,10,7,,8,5,4,12,7,9,6,
   24,8,5,12,48,7,8,6,15,11,6,8,,18,6,6,4,7,6,,,6,5,,
   21,,68,38,,6,5,7,,60,,7,5,,,14,42,5,,7,,,8,,8,61,90,
   101,27,9,6,,4,11,,21,6,7,5,5,21,7,8,11,8,9,7,6,5,5,
   7,10,20,5,4,4,3,5,6,4,4,5,7,6,9,7,13,6,5,4,4,4,8,
   4,4,4,6,4,4,4,8,4,9,4,4,9,9,7,6,4,8,6,9,10,8,4,
   7,5,6,4,7,4,4,5,4,4,4,4,4,4,4,7,7,6,,,6,7,10,4,9,
   6,8,9,5,,6,,,7,,4,7,4,4,3,3,4,9,9,5,9,8,5,5,4,7,
   7,6,,4,4,4,8,4,8,5,,8,,4,4,6,3,5,5,5,5,4,6,8,8,,7,
   ,6,7,4,4,3,3,10,4,6,7,6,15,5,4,4,4,4,4,4,4,4,4,
   4,6,,6,9,,4,4,11,4,8,4,4,5,5,6,,6,8,,7,9,5,4,4,3,
   4,4,4,6,5,6,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,4,
   ,5,10,4,6,5,7,,,,,5,6,5,5,4,4,7,6,6,7,7,7,4,7,,4,
   4,4,3,4,4,7,7,6,,,4,3,6,3,6,4,6,6,5,,6,11,5,,9,4,
   8,4,6,4,4,4,4,5,4,7,7,7,4,,3,4,3,5,6,,5,10,,,4,4,
   6,3,4,4,5,6,4,8,8,7,,6,,7,7,4,7,3,4,4,3,5,3,4,7,
   10,9,6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,6,,
   6,,5,9,6,5,5,5,7,5,5,6,6,9,4,4,4,3,4,6,9,7,9,,,4,
   3,8,9,14,4,9,,5,,6,,5,,18,5,,4,10,4,4,4,4,8,4,6,11,
   5,4,3,3,8,,5,,,,4,4,6,3,5,4,4,7,4,9,10,9,,6,,5,12,
   4,,3,3,10,3,6,6,4,18,4,3,,6,,5,8,,,4,4,6,3,5,4,5,
   5,7,7,6,6,,5,11,5,7,4,5,3,4,4,4,5,7,4,6,4,4,5,6,,
   6,9,,4,4,,4,10,4,5,5,,6,,6,,,6,5,5,4,4,4,4,4,4,11,
   4,4,6,3,4,5,5,5,6,,4,3,5,2,5,4,3,4,9,5,9,5,,5,6,
   5,4,3,3,3,3,3,4,4,27,3,5,,,5,,,,4,4,6,3,5,4,4,7,
   10,9,8,9,,4,,4,12,4,9,3,,4,4,6,6,3,9,11,5,,10,,5,4,
   6,3,7,4,5,5,7,6,6,7,,4,,4,7,4,4,4,4,15,6,6,8,5,8,
   7,6,,,6,8,8,5,7,6,9,7,6,7,10,6,,,10,8,6,8,8,,6,12,
   8,7,12,6,9,7,11,,5,4,9,9,13,5,4,5,,6,,6,,,6,11,7,5,
   5,4,5,,5,8,5,8,6,12,,6,7,8,5,8,6,8,8,7,6,9,7,,,,,
   6,8,8,10,5,15,8,8,,5,10,,7,12,7,7,12,6,11,,13,,11,14,
   ,,,7,,,,26,,11,11,12,,100,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,
   4,5,,6,11,6,,8,6,5,5,5,7,6,4,4,4,7,4,3,6,8,3,12,4,
   ,7,5,,6,11,6,,,4,6,3,7,4,4,3,4,6,4,3,7,9,51,,7,8,,
   10,,10,,,8,8,7,9,9,7,7,11,12,6,,5,6,,4,9,4,5,5,5,5,
   5,,6,4,4,27,5,3,3,4,3,6,3,3,5,,,,,11,,,,,,6,6,36,144,
   20,8,10,,,116,,45,4,5,5,6,,6,9,9,7,7,5,5,7,4,3,4,4,
   7,5,4,7,,5,,6,,,7,,5,6,14,,4,8,5,8,5,8,4,26,6,,7,,,,
   ,5,6,5,18,4,4,7,7,6,7,12,14,7,9,7,,,7,8,7,5,4,8,
   5,5,,10,5,4,7,8,6,,,14,6,6,5,5,6,6,8,12,,8,,6,8,7,,
   12,6,6,,6,5,7,12,11,13,9,7,9,,,,7,8,6,10,5,5,8,,,8,
   24,8,,,,,,,,25,,,,,5,,,,,,5,7,17,,,10,5,,6,41,,10,,14,,,55,
   ,11,8,,7,5,4,4,4,7,4,7,9,6,9,7,28,7,4,6,7,6,6,4,
   7,5,4,4,3,5,23,4,4,6,4,4,14,8,10,6,6,8,2,3,5,4,4,
   2,5,4,4,,4,3,6,4,10,5,5,20,8,3,23,13,12,4,12,4,8,
   7,8,8,5,5,5,4,,4,5,5,5,5,6,5,,9,,5,5,6,6,8,5,6,5,
   8,,6,6,6,8,,5,6,5,5,4,8,31,7,6,6,5,7,8,4,4,6,4,4,
   3,4,4,4,5,4,,6,,,4,4,5,4,5,4,5,7,5,5,,9,,,,9,5,4,
   7,4,3,4,4,5,5,7,8,6,4,6,,8,4,6,4,9,6,5,7,7,9,10,
   5,4,4,7,10,4,6,7,9,,7,,4,10,10,7,7,6,6,4,7,7,6,7,
   4,6,6,4,6,,4,4,4,3,,4,5,5,4,,8,5,6,4,6,8,4,6,5,4,,
   ,6,8,,8,4,11,3,5,3,3,3,5,7,4,11,7,5,4,,4,3,4,4,3,
   ,5,5,9,9,5,6,6,4,6,6,6,5,4,6,6,6,6,8,7,7,7,4,5,
   4,4,4,4,6,5,6,6,5,11,4,4,4,5,4,7,5,7,,5,6,7,4,4,
   8,4,9,7,6,,4,,6,5,,5,6,5,4,4,28,8,5,7,4,6,10,4,5,
   6,4,6,3,,6,9,,6,,,,,,,,,3,,6,,5,17,6,5,,,4,4,5,4,,,5,
   6,6,5,4,4,4,6,,11,,11,14,8,9,,6,9,,,8,4,3,9,10,6,15,
   ,5,11,4,,4,4,12,6,9,7,11,13,4,4,,4,,4,5,,,8,8,6,6,,
   5,9,7,4,4,4,5,,,5,5,7,3,4,4,4,4,7,8,9,5,5,4,6,6,
   5,,6,8,6,5,4,5,5,7,3,6,5,,4,4,6,9,9,6,5,6,4,4,4,
   4,4,5,6,7,7,6,4,5,6,6,6,9,,5,4,6,4,6,5,6,5,4,4,
   4,6,,9,6,6,6,4,3,4,4,4,3,6,6,6,6,,,,,,,6,7,5,4,8,
   4,6,5,9,6,,9,,8,7,4,8,7,5,9,,,,6,7,6,8,4,6,,7,7,5,
   4,6,4,8,3,5,5,,,4,,7,6,7,4,5,4,4,4,7,8,7,5,7,6,7,
   5,7,13,13,5,7,7,5,5,6,6,5,11,6,,6,,9,13,12,15,9,8,,
   13,5,5,5,,9,7,7,9,,6,5,7,7,13,4,6,5,,,,6,13,13,5,,
   9,13,5,5,9,,8,7,12,15,5,10,,6,4,7,4,,6,8,7,,,5,10,
   11,7,9,,7,5,8,4,8,12,8,7,8,7,8,9,8,10,7,5,10,6,16,
   8,15,17,8,10,,,,10,,,,,,,5,9,37,,26,6,4,11,6,7,7,7,7,
   6,5,,13,,,,,7,55,17,19,8,,4,7,,60,47,8,,5,,5,6,5,,4,
   5,6,,9,8,6,5,8,7,31,5,4,5,7,5,6,6,7,6,10,6,,7,8,,
   9,6,10,9,10,4,6,7,6,7,6,4,6,6,7,7,7,7,9,,10,7,,9,,
   8,,10,,8,7,8,8,12,5,4,8,8,,7,7,,4,,7,11,5,5,9,5,,8,
   4,6,28,5,8,5,4,4,10,5,6,7,7,12,,,6,7,,,,,7,6,,51,27,
   7,5,,,6,49,,,5,6,3,,5,7,7,8,7,6,7,7,8,4,4,4,7,4,5,
   5,,10,,9,,13,10,,7,7,8,,9,7,5,12,11,,7,,8,,5,,7,8,,6,
   5,7,29,8,7,8,29,6,6,5,6,4,4,,14,11,9,7,11,4,6,12,
   4,4,,13,5,11,9,6,,6,,,5,6,5,,4,,4,4,6,5,,,6,,,8,7,6,,
   ,,7,9,5,8,4,8,6,7,16,12,,7,7,12,5,8,9,,,7,7,11,9,7,
   ,60,8,4,,55,19,17,47,,7,7,10,37,,,5,,,,,26,10,,9,6,49,
   7,,5,,27,51,,7,6,,7,5,4,4,4,6,4,7,7,6,9,10,11,10,7,
   5,6,6,6,6,7,6,4,3,3,14,10,4,7,6,4,14,9,6,9,4,6,7,
   3,4,9,33,6,5,5,4,6,6,5,10,10,4,5,4,10,33,7,4,11,9,
   9,7,10,7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,
   4,4,4,4,4,,,4,,,3,4,4,4,4,4,,4,4,4,7,7,4,4,4,,,3,
   4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,3,4,4,4,
   4,4,,4,4,4,7,7,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,3,3,
   3,3,3,,4,4,3,,,4,4,4,4,3,6,5,3,3,3,6,5,3,5,,4,3,
   4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,4,4,4,3,
   4,7,7,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,
   3,4,4,4,5,5,,4,4,4,3,4,7,7,4,4,4,4,,,3,4,4,4,4,5,
   3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,8,,4,5,4,7,,5,4,4,9,7,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,
   3,3,3,3,3,3,3,,3,,4,6,3,4,4,4,6,3,3,6,3,5,4,4,4,
   3,,,4,,3,2,3,3,4,3,3,3,,3,4,4,4,4,,4,3,4,3,4,3,6,
   3,3,4,4,5,,3,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,
   6,5,4,4,4,5,6,5,5,7,4,7,,,5,,,,4,3,5,3,5,4,4,4,4,
   3,4,4,,4,,,7,4,5,4,,8,4,5,9,4,7,5,5,,5,,4,3,5,3,5,
   4,4,4,4,3,4,4,,4,,6,5,4,4,4,5,6,5,5,7,4,7,4,,,,3,
   4,4,3,4,4,5,4,3,4,4,4,,5,,4,9,4,5,,4,8,4,4,7,5,,,
   5,,3,3,4,4,5,4,4,4,,4,,,5,6,,5,4,4,4,5,5,,5,4,5,4,
   7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,6,5,5,,,,
   5,,11,,5,,8,4,4,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,
   4,,3,4,4,,3,,3,3,3,3,6,3,6,4,6,4,3,6,4,3,4,4,,4,3,
   ,4,4,4,4,,3,4,3,4,3,4,5,4,4,3,3,6,4,,,3,,,4,,,,5,,
   4,4,5,,7,4,8,4,9,,4,8,,4,4,4,4,4,6,6,3,,,4,3,6,4,
   3,3,5,6,4,3,4,6,,6,,,4,,,,,,5,4,11,,13,4,8,,,7,15,11,
   ,3,4,4,,,5,5,,4,4,5,6,5,4,7,7,4,5,5,6,,4,,,,5,5,,
   4,5,5,,5,5,7,6,4,4,4,8,4,4,,,5,5,,4,4,5,6,5,4,7,
   7,4,5,5,6,3,4,4,6,4,,8,4,4,3,6,3,6,,6,4,4,6,4,4,
   4,,,4,5,4,4,3,4,5,4,4,3,,8,3,5,,,10,5,,6,4,4,7,,9,
   5,9,6,5,,,10,5,,6,4,4,7,,9,5,9,6,4,,,11,4,5,,15,11,
   7,13,,4,8,,,11,,5,4,7,,11,5,4,,8,,,,,,,,,,,,,4,4,4,5,4,
   ,4,4,9,5,,4,4,7,4,6,3,4,5,4,6,4,4,4,6,5,7,3,4,6,
   4,5,,9,5,4,4,,3,10,5,6,4,3,6,7,4,3,7,6,16,7,6,7,
   16,6,4,4,7,7,5,3,10,4,7,7,4,4,4,,,3,4,4,4,4,4,,,5,
   ,3,3,4,4,5,4,4,4,4,4,,,4,,,3,4,4,4,4,4,,4,4,4,7,
   7,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,
   4,4,3,4,4,4,4,4,4,4,,4,4,,,4,4,4,4,3,,,4,,,3,4,4,
   4,4,4,4,3,4,,,4,5,,5,4,4,3,4,4,4,4,4,4,4,,4,6,6,
   3,3,3,4,3,4,,4,,,2,3,3,3,3,3,4,3,3,4,,4,3,,,4,4,4,
   4,3,5,6,3,3,3,5,6,3,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,
   4,4,,,,5,,,7,,4,,4,6,10,4,4,5,7,9,4,4,4,4,4,,,,,,3,
   4,4,4,5,4,4,4,4,,,,5,,,7,,4,,4,6,10,4,4,5,7,9,4,4,,
   3,,,3,,,3,3,3,3,3,3,3,2,4,4,,3,,,3,6,5,4,3,4,4,4,
   3,3,6,5,3,3,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,
   ,4,4,4,4,4,3,4,4,7,7,4,4,4,5,,5,5,,4,3,5,4,5,4,
   3,3,,4,,4,,,4,,4,4,4,4,4,3,4,4,7,7,4,,,,,,,3,3,3,3,
   4,3,3,3,4,4,,4,8,,4,8,6,4,4,4,,6,3,4,6,5,4,3,,,4,,
   3,2,3,3,4,3,3,3,4,3,,4,4,,4,8,4,3,4,4,4,8,4,4,4,
   5,4,,4,,,3,4,4,4,4,4,4,3,5,3,,4,,,5,4,8,5,4,,4,5,
   4,4,7,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,
   5,4,,3,5,,6,,5,4,4,5,4,11,4,5,5,7,4,,3,4,4,4,4,4,
   4,3,5,6,,5,,,,5,,12,7,7,,5,4,4,13,,9,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,3,,4,,4,3,3,,3,,3,,,3,3,3,3,3,6,3,4,4,5,4,6,3,
   4,4,4,4,,3,3,,,3,4,,4,3,4,4,3,3,4,3,4,4,3,6,3,,,,
   4,4,,5,,5,,,5,4,4,,5,7,4,5,4,8,,8,4,,3,4,4,5,5,,5,
   5,,5,4,4,6,5,5,4,4,4,4,5,6,5,,6,,,5,,,,,,5,4,,9,11,
   4,5,,,5,,6,4,4,5,5,,5,5,,5,4,4,6,5,5,4,4,4,4,5,6,
   5,,3,,,,4,,,4,4,4,,3,4,3,5,4,4,6,6,3,3,,,3,,,4,3,4,
   6,3,3,6,5,4,3,6,4,4,,4,,,4,,5,4,4,9,4,5,,7,4,8,4,,
   4,5,,5,4,6,5,4,4,4,4,5,5,5,,5,,,,,,,,,,,,,,,,,4,,,,5,4,
   9,4,4,8,,7,4,8,4,,4,,9,5,4,,11,,5,9,,8,4,,,,,,,,,,,,,,,
   9,5,,4,8,,8,7,4,8,,4,3,3,9,4,3,4,4,7,6,8,3,4,6,4,
   4,3,4,6,6,5,4,4,4,4,5,24,4,,4,4,4,9,6,5,3,6,4,4,
   4,7,4,4,6,3,4,4,3,4,6,5,4,4,5,,21,4,3,10,4,6,5,8,
   7,4,7,4,3,,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,
   4,,4,,4,,,4,3,4,4,4,,4,4,4,4,7,7,4,,,3,3,3,3,3,,4,
   4,6,6,2,3,3,3,4,3,3,3,3,4,4,,4,6,6,4,4,4,4,3,4,
   4,3,3,3,4,4,,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,
   4,4,,4,,4,,,4,3,4,4,4,,4,4,4,4,7,7,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,3,4,4,4,4,,,,7,5,3,3,4,4,5,4,4,4,4,5,3,
   ,4,,,6,5,,,4,5,6,4,4,4,8,8,4,3,,4,,4,4,,4,3,3,3,3,
   4,2,3,3,4,4,3,,,4,4,3,6,4,4,3,4,3,3,3,5,4,4,4,,3,
   4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,
   5,5,5,4,4,4,4,4,4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,
   4,4,6,3,4,4,3,3,4,3,3,5,4,4,,,,,,6,4,3,4,4,6,3,4,
   4,3,5,4,,8,5,5,5,7,5,5,4,,4,4,5,6,5,5,4,,,6,6,4,
   3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,
   4,4,4,8,6,3,3,3,3,4,3,3,3,4,4,4,,,6,6,4,6,4,4,,4,
   4,3,3,6,6,6,3,6,,4,3,4,4,6,4,4,4,,4,,,6,7,7,,4,4,
   4,6,5,,5,4,6,4,4,6,,4,3,4,4,6,4,4,4,,4,,,6,7,7,,4,
   4,4,6,5,,5,4,6,4,4,6,4,6,4,5,6,4,7,5,6,5,5,,,,,5,,,
   ,6,,5,5,5,9,,,4,4,6,5,6,6,5,5,6,5,5,,,,,,5,,,8,5,,
   5,5,10,,,3,,4,,3,4,4,,3,3,,,4,4,3,3,3,3,5,3,3,4,6,
   3,4,4,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,
   4,4,4,8,,4,4,,3,,,,6,6,4,3,6,6,6,3,4,4,6,,4,4,,4,,
   3,5,5,5,,4,,,4,4,7,7,4,4,4,,3,4,4,4,6,5,,,7,7,,,,,
   5,5,,,9,5,5,,,6,,,4,4,3,3,,,4,6,6,4,3,6,6,4,3,4,4,
   4,4,6,6,,5,,5,,4,,,4,5,,,4,5,4,6,6,4,8,8,5,5,5,,4,,
   ,4,4,7,7,4,4,4,,3,4,4,4,4,4,,6,5,5,5,5,4,4,6,4,4,
   ,7,4,5,5,4,,4,,,4,6,5,5,3,3,4,5,5,4,,,,4,,,6,4,,,4,
   4,3,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,8,8,4,4,,10,6,4,10,,
   4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,,4,4,4,5,4,6,4,4,5,13,
   13,4,4,5,6,4,4,4,5,4,4,3,4,5,7,7,13,3,4,4,4,5,7,
   7,13,3,4,4,3,6,6,4,3,3,3,4,4,4,6,7,7,4,4,4,8,8,
   6,3,7,7,5,7,7,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,
   4,4,3,4,,,4,5,,5,4,4,3,4,4,4,4,4,4,4,,4,,5,4,4,3,
   5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,3,4,4,4,,
   4,4,4,4,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,
   ,,,3,4,4,4,4,4,4,3,4,,6,5,5,,,4,5,5,,4,4,8,4,4,5,,
   7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,4,4,4,
   3,4,4,4,7,7,4,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,
   4,4,,4,4,4,3,4,4,4,7,7,4,4,3,6,6,4,,,3,3,4,3,3,3,
   3,2,4,,4,3,,,3,5,6,4,3,4,4,4,3,3,5,6,3,,,,,,5,4,4,
   4,4,5,3,4,3,6,,4,5,9,,5,4,11,4,5,4,,5,5,4,6,7,5,
   4,4,,,4,3,3,3,3,4,2,3,3,4,,3,4,4,,4,4,8,3,4,4,8,
   4,4,4,4,5,4,3,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,6,10,4,
   4,,7,,4,4,9,6,5,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,6,10,
   4,4,,7,,4,4,9,6,5,,,3,3,3,3,4,3,3,3,4,,4,4,4,,6,,
   6,4,4,4,8,6,4,3,4,6,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,
   4,4,4,4,3,5,,6,5,,,,,5,12,7,7,5,,4,4,11,,9,4,,4,,3,
   4,3,,,3,3,,,3,3,3,3,3,5,4,3,4,5,4,5,3,4,3,,4,,4,5,
   ,5,5,5,,5,4,4,,4,4,4,4,4,4,4,,4,4,6,,4,3,,,,3,,,4,
   4,3,8,4,6,4,4,4,5,,6,3,,4,,4,5,,5,5,5,,5,4,4,,4,4,
   4,4,4,4,4,,4,4,,,,,5,,,,,4,5,,11,9,5,4,,,7,12,7,4,3,
   3,,,3,4,,4,4,3,8,4,4,3,4,4,4,4,8,4,,5,,5,,5,,,4,5,
   8,,4,4,4,8,4,5,,7,3,,3,,3,,,3,4,6,5,3,6,3,5,4,3,5,
   4,,4,4,,,4,5,,4,4,8,5,4,,7,4,7,4,,,,,,,,,,,,,,,,,,4,5,,
   5,6,4,,5,5,4,4,5,5,4,11,4,4,,,5,,4,8,4,8,4,,7,4,7,
   4,,4,11,,5,4,,,7,7,9,,8,4,,,,,,,,,,,,,,7,12,5,,4,,9,11,
   7,4,8,,4,4,4,4,4,4,3,4,5,9,6,4,4,9,3,4,4,4,9,,21,
   4,4,3,3,9,9,4,,4,4,9,6,5,4,3,6,4,3,4,6,4,4,6,3,
   4,4,4,4,6,9,4,3,4,9,4,4,4,16,4,6,6,5,7,4,7,5,,4,
   3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,4,4,4,
   3,4,7,7,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,4,
   3,4,,,,5,,7,,,6,5,4,5,5,3,4,4,12,5,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,
   5,5,7,7,4,4,3,4,4,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,3,
   4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,4,,
   5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,7,7,4,4,3,4,4,
   4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,8,8,
   4,5,6,,,4,4,12,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,3,3,
   3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,5,5,5,5,6,4,5,,,4,
   3,5,3,4,,,3,4,4,3,4,4,5,4,3,4,4,4,7,5,5,,,4,6,5,
   8,8,4,4,5,4,3,3,4,4,5,4,4,4,5,4,6,7,7,6,,,,,,,,,,,
   4,4,,,,4,4,5,4,4,4,5,4,6,7,7,6,,,,,,,,,,,4,4,,,,4,,3,,
   4,4,3,,4,4,3,,4,4,3,3,3,3,6,4,4,3,5,4,3,3,,4,4,3,
   ,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,6,,6,4,,,
   ,4,,6,6,4,4,5,5,7,5,5,4,6,,4,4,,4,4,3,4,6,6,4,4,,
   4,4,4,6,3,3,4,4,3,3,3,4,3,4,6,,,6,6,,,,,4,4,8,8,
   10,4,4,,,4,8,6,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,
   5,5,,4,,,,6,6,,5,5,4,,4,4,4,6,4,5,5,7,3,4,4,,4,4,,
   4,4,3,6,3,4,4,5,3,3,3,4,4,4,3,8,6,4,6,6,4,3,6,4,
   4,,6,4,4,3,3,4,6,,6,7,7,,4,4,4,4,6,6,5,,5,4,6,,6,
   7,7,,4,4,4,4,6,6,5,,5,4,6,8,6,6,4,6,3,4,4,,6,3,4,
   4,6,6,,,5,5,,,,6,9,,5,5,6,,,,5,5,,,8,6,5,,5,,,5,,5,,,
   10,8,5,5,,3,4,4,13,4,4,3,4,7,5,7,4,4,13,4,4,3,4,
   7,5,7,4,4,4,4,5,5,4,6,4,4,13,13,5,5,4,4,6,4,4,5,
   4,6,4,4,3,4,3,5,7,8,4,3,5,7,8,3,3,6,4,6,3,6,4,4,
   4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,6,,5,,,
   6,,6,5,5,,6,6,6,5,6,9,5,4,6,6,5,,6,,,,4,5,6,4,5,6,
   6,5,4,5,6,5,7,7,,6,5,6,,6,9,11,5,5,6,6,,4,4,,3,,4,,
   ,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,4,4,4,6,5,5,
   5,7,4,7,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,,4,3,4,4,4,
   ,3,4,4,3,4,6,3,3,3,4,4,5,6,4,6,4,6,,,3,3,4,2,3,
   3,4,3,3,3,3,3,,3,,6,4,3,4,4,6,4,3,3,5,3,6,,,6,,,7,
   6,5,6,4,7,4,6,5,6,5,4,5,,5,,6,,5,5,6,,6,6,6,6,5,9,
   ,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,4,4,4,6,5,
   5,5,7,4,7,4,3,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,6,4,
   4,,6,9,5,4,9,5,6,4,,,3,3,3,3,4,3,4,3,,4,,4,4,6,,4,
   4,4,4,4,8,,3,3,4,4,6,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,
   ,,6,4,4,,6,9,5,4,9,5,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,
   3,4,4,5,4,4,5,6,5,,,,,5,9,,7,8,,4,4,8,8,,4,,3,,3,6,
   4,,4,3,4,,3,,3,3,3,3,5,6,3,4,6,4,3,5,4,4,,4,,3,4,,
   4,,5,5,,4,4,4,,4,7,4,7,4,4,4,,3,6,,6,4,,4,,4,,4,,4,
   3,4,8,6,6,4,4,6,,3,6,,3,6,4,4,6,4,6,3,,,3,4,5,6,
   3,5,3,6,4,3,4,5,4,,,,,4,,,,,4,5,9,,9,8,4,,,5,11,,6,
   4,3,4,,4,4,4,,4,3,4,8,4,5,4,4,4,4,4,8,,6,,6,,7,7,,
   5,5,6,,6,9,5,11,6,6,6,,4,,4,,5,5,,4,4,4,,4,7,4,7,
   4,4,4,,4,3,4,6,4,,4,8,4,3,5,6,3,,6,4,4,5,4,3,5,,,
   5,10,6,10,4,7,4,,9,4,,7,4,4,,,5,4,,6,3,5,4,4,4,4,
   6,8,5,,,5,10,6,10,4,7,4,,9,4,,7,4,,9,,4,5,,,6,5,11,,
   4,8,,7,,,5,4,,9,13,7,4,,8,,,,,,,,,,,,,4,4,3,5,6,4,3,4,
   6,4,9,3,3,24,,4,4,4,7,4,6,4,4,6,5,6,6,3,4,6,4,6,
   8,7,9,4,4,,5,8,6,4,4,3,6,7,7,6,10,12,,4,3,4,5,21,
   4,3,5,20,7,4,16,4,7,7,4,4,4,4,4,,,,,,3,4,4,4,5,4,
   4,4,4,,,,5,,,7,,4,,4,6,10,4,4,5,7,9,,4,,5,,3,5,,5,4,
   4,4,4,5,3,4,3,,,4,,,9,5,5,,4,5,4,5,4,4,5,7,6,5,4,
   3,,,,,,6,4,4,4,4,6,3,4,4,,,4,,10,10,6,5,,4,6,4,,4,4,
   5,7,7,6,4,4,6,6,6,,,3,3,4,3,4,3,3,3,4,,4,,,8,4,8,,
   4,4,4,4,4,3,3,5,6,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,10,
   10,6,5,,4,6,4,,4,4,5,7,7,6,5,6,,,6,4,3,4,4,6,3,4,
   4,,,4,,5,8,5,5,,4,5,5,9,6,6,5,5,6,5,,5,,,4,4,4,4,
   5,4,4,3,,,,,,8,7,,,13,5,,8,6,4,4,9,12,7,,,,4,4,4,4,
   5,4,4,4,,,,,,,,12,,4,6,6,12,,5,5,9,10,7,,,4,3,4,4,6,
   4,4,4,,,,,6,14,8,,,6,5,6,9,,6,4,6,14,5,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,4,4,6,5,6,6,5,5,6,,11,,,,,,,21,11,13,7,,5,5,
   10,22,,4,,4,,3,4,4,,,3,,,7,4,3,,4,4,5,4,3,4,8,4,5,
   4,4,,,4,,5,5,,5,,5,,7,4,,3,5,4,5,3,5,,4,6,5,4,8,,4,
   4,,,,,,10,6,4,,6,6,6,4,4,6,6,,6,4,,4,3,,5,,5,,5,,,4,,
   7,,4,6,4,10,7,5,10,9,6,,,,,7,,,,,5,,,19,9,7,5,,,6,36,,
   4,4,3,,,,4,12,6,4,,6,6,4,4,4,4,4,4,8,6,,5,,5,,5,,,4,
   ,7,,4,6,4,10,7,5,10,9,5,,5,,4,,,4,,15,7,4,7,5,,8,4,
   6,5,,4,,6,10,6,5,,5,6,8,6,4,,7,12,7,6,,,,,,,,,,,,,,,,,,,
   5,,,6,,,,5,6,9,5,5,4,8,8,,,,,,,,,,,,,,,,10,5,13,,5,5,,
   14,6,5,10,,7,5,,,,,7,8,,,,,9,,,10,,,,5,,,,13,5,,,,9,5,5,
   6,4,4,4,6,8,8,,,,,,,,,,,,4,6,3,6,10,4,7,6,5,13,10,16,
   9,4,6,5,4,4,6,5,4,5,4,5,5,6,5,8,39,4,4,4,13,37,4,
   3,8,9,7,7,7,7,5,,4,,,5,,5,,,,4,4,5,3,4,4,4,3,4,4,
   4,3,,5,,4,8,4,,5,4,9,4,4,,5,7,4,4,4,,,,6,8,3,3,3,
   3,4,3,3,3,,4,4,4,6,6,,4,4,4,,4,4,6,3,3,6,6,6,3,,,
   5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,6,9,4,,4,,6,4,5,
   7,5,9,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,6,9,4,,4,,
   6,4,5,7,5,9,,5,,7,10,4,3,5,3,5,4,4,4,4,3,4,4,,4,,
   9,7,4,,,7,5,5,5,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,
   4,4,5,4,4,4,,,,,7,8,,8,6,13,,5,,,4,4,7,9,9,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,5,6,8,9,7,,,,,,13,,7,,,4,
   5,,,,5,6,7,6,7,7,7,6,12,5,6,14,,,,,,,,,5,,6,6,,,,4,,3,
   ,4,4,4,,4,4,4,,4,,4,4,3,,6,4,6,3,6,8,4,6,,4,5,,,5,
   4,,3,5,6,6,,4,5,4,,4,4,6,4,5,5,5,7,4,6,,,,,,,,,6,,5,
   6,5,,7,5,8,12,16,,5,9,,4,4,4,4,6,6,6,4,,,4,4,6,,3,
   4,5,3,4,4,8,6,7,7,,,6,9,,,,,4,5,11,,13,4,7,,,8,10,
   17,3,,4,,,,6,6,,4,6,5,,5,4,7,7,4,6,6,12,,4,,,,6,6,,
   4,6,5,,5,4,7,7,4,6,6,12,4,5,6,,5,5,,4,5,5,,5,5,6,
   7,4,4,4,11,4,4,4,12,6,,6,6,4,,6,4,6,,6,6,6,6,,5,6,,
   ,12,7,6,,4,5,8,6,6,5,,7,,6,,,7,6,,,4,6,7,6,6,5,9,
   9,5,,,21,7,,,4,5,6,,9,4,8,8,6,,,19,5,,,,46,10,13,,6,
   10,,81,,,,5,13,12,7,10,6,,10,,,,,,,,,,,,,,3,,5,4,7,3,4,
   6,7,17,5,,10,5,8,4,5,16,16,31,,4,5,6,5,7,4,7,8,,,,,,,
   ,,3,9,5,6,7,4,8,,4,3,15,22,23,7,5,6,9,8,4,5,6,9,
   7,5,8,6,8,8,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,
   4,,4,4,4,3,4,4,4,7,7,4,,4,,5,5,,,4,4,5,3,4,4,4,3,
   4,4,4,3,,5,5,7,7,4,4,3,4,4,4,4,,4,4,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,
   4,4,4,6,5,5,5,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,4,4,
   4,4,5,3,4,3,,,,4,,,4,7,,4,4,5,8,,4,5,8,8,4,,,4,4,4,
   3,5,3,5,4,4,4,3,4,,4,,,8,4,4,5,,7,5,4,8,4,8,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,4,4,5,3,4,4,4,3,5,5,8,4,,,,,8,11,5,,
   5,,4,4,,9,9,3,,4,,4,,4,,,4,4,,5,5,4,7,4,4,,4,4,4,7,
   ,4,4,,4,,4,,4,,,4,4,,5,5,4,7,4,4,,4,4,4,7,,4,4,4,6,
   ,3,4,,,,4,,5,5,5,7,4,4,11,4,5,4,6,,5,5,,3,4,3,6,6,
   4,4,,,3,3,5,5,3,6,4,3,4,6,5,4,3,4,,,,,4,,,,,4,8,8,8,
   ,5,4,,,,9,7,4,3,4,4,,3,,4,4,4,5,4,4,8,3,4,4,4,8,
   4,4,,,,4,,,5,,4,8,4,,8,4,4,9,4,,5,7,4,4,3,,,3,,3,6,
   3,5,6,4,3,6,4,5,3,4,3,4,4,,,5,5,7,6,4,10,4,4,,9,7,
   ,4,4,4,,,5,5,7,6,4,10,4,4,,9,7,,4,3,,,4,6,5,,3,6,
   4,4,4,4,8,6,4,,4,6,4,6,4,5,3,4,3,,6,5,4,4,,,,,,,,,,,,
   ,,,4,13,,,4,5,12,7,7,9,8,,4,5,,4,,5,,11,9,6,8,4,,7,
   4,3,5,4,4,3,4,7,6,6,6,10,,,6,6,7,6,6,5,4,4,4,4,4,
   5,6,4,3,4,5,7,6,4,6,3,4,4,4,9,21,,4,4,4,4,4,,21,
   24,4,3,9,6,4,4,6,5,5,8,5,8,7,7,4,4,4,5,,5,5,,4,3,
   5,4,5,4,3,3,,4,,4,,,4,,4,4,4,4,4,3,4,4,7,7,4,,,,,,
   6,4,4,4,4,6,3,4,4,,,4,,10,10,6,5,,4,6,4,,4,4,5,7,
   7,6,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,
   4,5,5,5,5,4,4,4,,4,5,7,4,4,4,4,5,3,4,3,,6,5,4,,,
   4,5,6,,4,,6,5,4,4,8,8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,4,
   3,4,4,6,3,4,4,,4,5,6,5,5,6,,4,5,4,5,5,7,5,4,5,5,
   6,6,5,6,5,5,6,4,6,4,,,5,6,,,,5,,,8,,,5,5,5,,,6,5,4,
   7,5,6,6,4,4,,5,,6,,,,,5,,6,,5,,5,5,,,9,4,,3,,4,4,4,,
   5,5,5,,,4,4,4,7,4,7,4,4,3,,4,4,4,4,4,6,3,,3,,,3,3,
   6,6,4,3,4,4,3,4,4,3,4,4,4,4,3,,5,,4,4,,5,,5,,,4,5,
   4,8,4,8,4,5,6,6,,,4,,4,4,4,,5,5,5,,,4,4,4,7,4,7,4,
   4,3,,4,4,4,6,8,,,7,7,,,,,5,5,,10,,5,5,,,,,8,3,3,,3,,
   3,6,6,4,4,3,6,4,6,3,4,4,4,6,6,4,,,,3,,6,6,,3,4,4,,
   4,4,3,6,4,6,6,6,,3,3,,4,4,,3,3,4,5,4,3,3,6,4,4,4,
   3,,,,,,,,,,,,,,,,,,,4,4,,,4,4,12,5,3,5,6,4,5,5,,,4,4,,,
   4,12,4,,4,,4,6,5,5,8,8,4,5,5,6,5,5,4,6,4,4,4,,7,
   5,5,4,3,4,,,,4,,,,,,,,4,4,,,,4,,,,,,,,4,4,8,4,,4,8,10,
   8,6,4,4,,4,5,3,5,4,6,4,4,7,7,6,7,6,7,6,4,4,4,13,
   13,3,4,3,4,4,13,8,4,4,3,4,5,5,5,4,3,3,3,4,4,13,8,
   4,4,3,4,4,4,4,4,5,4,4,13,13,4,6,7,7,5,7,7,6,3,4,
   4,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,6,9,4,,4,,6,4,
   5,7,5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,6,5,
   4,4,4,5,6,5,5,7,4,7,6,6,,,5,6,6,4,5,5,6,4,5,6,5,
   4,,7,7,9,11,6,6,,6,5,5,5,,6,6,6,7,,5,4,6,6,7,5,4,
   4,,6,,6,,,5,,6,6,5,5,6,,6,6,9,11,5,7,,5,4,6,4,7,5,
   6,6,5,4,5,6,,5,,,6,5,6,5,6,,6,6,9,5,11,,4,4,5,3,4,
   4,4,3,5,8,5,4,,,,8,,9,7,,,5,4,4,,11,7,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,7,4,5,5,6,4,4,4,7,6,
   5,5,6,3,4,4,,3,4,,4,3,,4,4,5,4,3,3,4,4,3,4,4,6,3,
   3,6,,,6,6,,6,,6,,7,7,9,5,6,6,,5,5,6,11,,6,6,,4,3,3,
   6,4,6,4,,,3,5,3,6,3,4,3,4,4,6,6,4,3,,6,,,4,,,,,,8,
   4,8,11,24,4,5,,,6,9,9,4,4,,4,,4,,5,5,7,4,5,5,6,4,
   4,4,7,6,5,5,,4,,4,,,4,,6,4,3,,4,4,3,6,4,6,4,6,4,3,
   4,,,3,,6,3,3,6,4,3,4,6,4,6,3,4,4,3,4,,,5,7,5,,4,6,
   4,4,,9,6,9,5,4,3,,,4,5,6,4,3,4,4,4,4,4,8,,3,4,,,5,
   7,5,,4,6,4,4,,9,6,9,5,,4,6,6,4,4,6,3,3,4,,6,6,4,4,
   ,,,,,,,,,,,,,,4,,11,,4,5,9,,7,7,8,,4,6,9,4,,5,8,24,11,
   9,8,4,,7,6,5,6,6,,6,7,6,13,7,5,8,8,4,4,3,4,13,3,
   4,4,4,4,3,5,5,6,4,3,4,5,24,4,6,6,3,4,3,3,24,4,,4,
   4,4,4,3,6,5,5,4,4,6,8,4,4,5,8,6,7,4,6,7,7,4,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,
   6,3,4,4,,,,,11,9,6,9,,6,6,5,,,4,6,8,9,6,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,5,6,5,
   12,6,,,,,10,14,,31,,,4,6,20,9,27,,,4,,4,3,,,,4,,,5,,5,
   9,4,,7,,4,6,6,10,5,9,,4,,4,,5,3,,4,5,,5,7,4,8,4,5,
   3,,4,,8,6,4,5,4,8,,,,,,,,,5,,7,9,4,8,8,,5,13,27,,5,,,
   3,4,4,6,6,4,6,7,,4,4,6,5,4,4,,3,6,8,5,4,4,6,,,,,6,,
   ,,,6,10,12,,81,,4,,,81,15,11,4,4,4,4,,4,12,4,6,6,6,
   4,6,6,,4,4,6,8,4,6,,,,4,,,5,,5,9,4,,7,,4,6,6,10,5,
   9,6,5,4,,,4,,5,7,4,7,15,,4,8,,6,4,5,,4,,,9,9,5,9,6,
   6,7,,4,,9,7,6,6,4,5,11,,7,4,8,6,5,9,,5,,8,6,,5,4,
   12,,6,6,6,,4,4,,4,4,6,6,6,6,8,6,8,6,9,5,7,15,,4,,,
   10,6,5,10,,,,8,7,,,,,,,9,,5,12,14,,5,5,,7,9,8,7,,5,,,5,
   ,,,16,16,,,5,,8,5,23,4,,,4,6,6,6,16,7,21,14,,8,8,8,
   11,7,31,5,4,,4,7,7,5,4,4,,,9,8,15,6,4,5,,10,7,7,7,
   4,6,,,,,,,4,4,9,6,5,,6,5,6,10,5,26,7,,5,4,,10,7,4,4,
   4,3,5,3,5,4,4,4,3,4,,4,,7,5,4,,,9,7,5,5,8,4,8,,6,,
   4,3,4,4,6,3,4,4,,4,,,5,6,5,9,6,4,5,5,5,,5,6,5,6,5,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,4,6,4,7,5,6,12,4,6,,,
   ,6,,14,8,8,,6,6,6,,14,,5,4,7,4,6,6,5,5,6,4,12,6,,,,
   ,6,14,8,8,6,,6,6,,12,,4,,4,,4,,3,,4,4,,,4,,5,5,4,7,
   7,5,5,6,6,4,4,4,4,3,6,3,,4,4,,3,4,6,4,6,4,6,3,4,
   4,6,4,6,6,4,3,4,4,10,,6,,,4,,,,4,,7,5,4,8,8,5,7,9,
   5,,4,,,3,4,4,6,4,4,6,4,,4,4,4,5,4,4,4,4,8,8,4,3,
   4,6,10,,,6,6,,,,,6,6,12,,,6,6,,,8,14,8,4,4,4,3,,4,6,
   4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,,4,,5,7,4,,,7,5,
   5,9,8,4,8,,4,4,,,4,,5,5,4,7,7,5,5,6,6,4,4,4,4,4,
   3,7,6,7,6,6,4,7,7,5,5,,12,4,6,4,3,4,6,,6,4,8,4,4,
   4,6,4,6,6,4,,4,4,6,,6,8,4,,4,4,4,6,6,6,6,6,6,7,6,
   7,6,6,4,7,7,5,5,,12,4,6,4,4,3,,,4,,,,,,,,4,,4,12,10,,
   4,4,10,8,12,8,4,,4,,,4,,,,,,,,4,,6,5,4,4,4,9,4,6,8,
   6,8,5,11,11,9,4,4,6,7,5,7,4,4,5,5,6,7,3,3,3,3,4,
   11,8,7,4,3,4,4,11,8,7,4,3,4,6,6,4,11,5,11,6,4,7,
   7,7,9,4,5,4,11,5,11,4,3,4,4,,,4,4,4,4,5,4,4,3,,,,4,
   ,,5,6,10,4,4,,7,,4,4,9,6,5,,,4,4,4,3,5,4,5,4,4,4,
   4,4,,5,,,6,4,4,,6,9,5,4,9,5,6,,6,7,7,6,7,6,7,6,8,,
   9,8,,,,5,,,,,,,6,6,,,,5,6,6,4,5,5,6,4,7,,7,6,,,,,,13,7,
   ,,,5,4,,,,,,4,,5,,4,,3,5,4,,5,5,3,6,4,4,,3,5,4,7,11,
   4,4,3,4,7,,,4,,,,4,,6,6,4,7,5,5,,4,6,4,7,,5,5,4,7,,
   ,4,,,,4,,6,6,4,7,5,5,,4,6,4,7,,5,5,,4,4,3,6,6,6,4,,
   ,4,4,5,6,3,,4,4,4,3,6,8,4,5,6,,,,6,,,,,4,7,8,8,,4,
   5,,,11,8,10,,4,5,6,,4,,6,6,4,6,5,5,,4,5,5,4,9,6,6,,,
   ,,,,6,,5,8,4,,,5,6,16,12,,6,9,4,4,4,,,4,,4,6,3,6,,4,
   4,6,3,6,4,8,,5,4,,,5,7,9,,4,,13,5,,9,8,8,4,,4,,,5,
   4,10,6,4,,4,6,6,7,12,,5,4,,,6,8,9,,4,,6,5,6,6,9,,6,
   ,6,12,6,8,4,6,,4,4,,6,6,6,6,,,,,,,,,,,,,,,6,,44,,5,,21,
   11,8,10,10,,6,7,,5,,,50,,10,8,10,6,,,5,3,,4,5,3,4,21,
   9,9,6,9,,7,8,5,7,11,10,6,4,,3,5,5,5,8,,4,,5,10,6,
   5,8,4,,,,,,,,,,4,3,14,7,11,5,4,13,10,38,4,7,7,8,8,5,
   7,8,8,6,6,,4,3,4,4,6,4,4,4,,4,,,6,7,7,,4,4,4,6,5,,
   5,4,6,4,4,,5,6,5,5,6,4,6,4,,14,,6,,,,7,,21,13,11,,,
   5,5,,44,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,5,,5,,,4,5,
   4,8,3,8,4,,8,,5,3,4,4,4,6,4,,3,,,,3,6,8,4,4,4,4,3,
   4,4,,4,4,4,4,3,3,,,4,4,,5,,5,,,5,6,4,6,5,9,4,,7,10,
   ,4,4,,,4,4,,5,,5,,,5,6,4,6,5,9,4,,7,10,,4,4,,8,,,7,,,
   ,,,7,5,50,10,,5,,,,15,,15,4,4,,5,,5,7,10,5,5,3,9,5,
   7,4,,,5,7,5,5,,,,,,6,8,,4,4,4,,4,4,,6,6,6,8,6,,3,,,
   4,6,,4,3,4,6,4,3,,8,4,4,4,4,,,,,,,,,,,,,,,,,,,,4,,,5,6,
   12,11,4,6,12,,5,5,,,5,,,,,,,,,,,,,,,,,6,7,6,,5,5,16,6,4,,
   ,7,6,5,12,,5,,,,5,,19,,13,,,,5,7,,,,6,,,,,,5,,6,5,8,5,,
   5,8,,17,7,5,5,,5,6,4,13,6,,6,5,21,5,8,3,4,10,4,,4,
   4,27,4,4,4,,9,,5,12,8,4,4,5,5,,6,5,4,4,4,5,,10,38,
   5,8,4,,4,4,5,4,5,,,,,,4,7,6,5,9,3,6,,5,4,,5,6,5,4,
   6,4,7,5,6,8,5,5,,,,,,14,31,,,10,6,4,23,11,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,4,,5,,,,4,5,3,,4,,,3,3,8,8,5,7,,8,5,4,
   3,4,3,6,4,,4,4,,4,4,6,4,8,,4,3,4,4,6,6,6,4,4,3,4,
   4,,,,3,,4,,,,5,,,4,5,6,9,5,9,6,6,,4,4,,4,4,4,6,4,6,
   6,4,,6,,3,6,4,4,4,6,8,6,4,4,4,,8,,,6,,,,,,,4,11,,23,
   6,10,,,,14,,,,5,4,,6,7,5,10,,4,5,9,7,4,8,8,,7,5,5,,,,,
   ,,5,,,5,5,,,7,9,27,13,8,4,11,,4,,,,5,,,4,5,6,9,5,9,
   6,6,,4,4,4,5,,8,6,6,,5,5,12,8,5,7,,9,5,6,16,4,4,6,
   ,8,,6,4,8,4,6,6,6,4,4,,4,,7,,8,,5,,13,5,4,8,8,,7,
   9,27,,,,,5,4,10,9,5,12,,9,6,9,4,5,,,19,5,,,,,,19,,5,,7,
   ,13,,5,5,10,11,12,9,5,,5,,,6,,,,,,,5,6,,,,,,,,,,,,,4,10,
   9,,8,4,4,8,4,3,4,5,5,7,6,7,4,4,4,,4,14,7,18,8,4,
   4,23,21,16,8,5,4,8,8,6,4,15,5,8,8,8,21,10,8,,22,6,
   4,11,5,6,5,,4,4,4,5,4,4,4,5,4,6,7,7,6,,,,,,,,,,,4,4,,
   ,,,,5,,4,,5,,,4,5,,,,3,,7,7,,,4,5,8,,9,5,7,,3,4,,,,,5,,
   ,,,4,,,,,,4,,,,,,5,7,,,5,,6,,5,,,,4,,10,12,11,,5,4,7,,9,
   6,,4,,5,7,5,5,7,,,,4,,,13,9,,4,5,5,9,12,7,4,,,,,5,,,,,
   4,,,,,,4,,,,,,6,4,4,6,,4,,,,4,,10,12,8,,4,4,4,12,10,8,,,
   ,6,,,,,5,,10,,10,,4,,,,,,5,,4,,,,,4,,11,,7,,4,8,5,9,9,,,
   5,6,,,,6,,13,7,12,,5,,10,81,,10,7,,,,,6,,,,,,6,5,5,,,,5,,
   ,,7,,,9,7,,5,5,5,12,14,8,,,,6,,19,,6,,5,,10,9,,14,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,15,19,,5,3,4,18,11,12,,,,,
   ,,,,,,,,,8,11,19,,,,8,,18,18,18,,,,,7,12,14,,,,,,,,,,4,3,
   18,19,14,5,15,10,19,19,8,32,,,,4,,5,,,5,5,,4,,5,,,,,3,
   7,4,11,4,,5,8,,11,13,6,4,4,4,,4,4,,6,4,,,,,4,8,4,6,
   4,,4,4,8,8,10,,,,,,,6,,,,,,,4,,,,5,,,,,16,19,,,5,5,7,5,
   5,7,,,,,4,,5,6,4,,5,5,9,,11,3,7,,,5,,,,,,,4,,,,4,,,,,,,7,
   ,,5,,,,,,,4,,,,4,,,,,,,,5,,7,,,,,,5,9,,9,4,,7,4,8,16,14,
   5,4,,,,,,,4,9,6,9,4,,8,5,11,8,24,5,,6,,,,,6,,10,46,5,,
   ,10,,19,13,7,5,,,,,7,11,5,6,5,,5,5,13,,10,,,,,,6,,,,6,,
   5,5,,,,,,,,6,,10,8,5,,,10,11,14,153,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,8,7,18,5,,3,4,29,22,15,,,10,,11,36,,,
   ,8,19,,19,5,,,,15,,19,10,,,,,4,3,18,26,19,,,,,,5,26,18,
   18,9,9,12,,,,,4,,4,,4,,,4,4,,5,5,4,7,4,4,,4,4,4,7,,
   4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,4,7,4,7,
   4,4,3,,4,4,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,5,5,7,4,5,
   5,6,4,4,4,7,6,5,5,,,,4,,,5,,5,9,4,,7,,4,6,6,10,5,9,
   ,4,4,,,4,,5,5,4,7,7,5,5,6,6,4,4,4,,,,,,,,,,,,,,,,,,,4,
   4,,,5,3,9,5,4,,3,4,5,7,8,,4,4,,,5,9,3,,3,8,4,3,5,7,
   ,7,5,,5,6,4,4,3,6,7,5,5,,8,4,5,3,,,,,,,,,,,,,,,4,7,10,
   ,3,8,9,5,,,5,,4,4,7,3,,8,11,13,,11,5,4,,3,3,2,7,3,
   4,4,7,9,5,5,2,3,16,4,3,4,7,9,4,3,3,7,4,3,5,16,4,
   4,3,7,5,5,9,7,4,3,4,6,10,,6,,6,6,4,4,6,4,4,7,4,6,
   5,7,6,,4,9,5,,6,24,4,4,4,4,7,,,4,,,,4,,6,6,4,7,5,5,
   ,4,6,4,7,,5,5,,4,,4,5,,5,5,5,,5,4,4,,4,4,4,4,4,4,
   4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,6,6,6,4,4,5,5,
   5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,,5,5,,4,4,4,,4,
   7,4,7,4,4,4,,,4,4,,7,5,4,8,5,4,6,,4,,8,6,5,4,,,,,,,,,
   ,,,,,,,,,4,6,,6,6,5,,4,4,5,4,5,5,5,7,5,5,7,,4,8,5,
   6,4,,4,,8,4,5,6,6,6,10,,5,5,,,8,,,,5,5,6,8,,,5,5,,6,,
   ,5,,5,6,,5,,5,,9,,,5,5,,4,6,3,4,3,3,3,4,5,5,5,7,5,
   8,4,3,4,3,13,4,8,4,4,5,3,5,7,4,6,4,4,7,6,7,5,4,
   4,6,7,6,7,8,6,4,4,4,3,4,4,8,13,4,3,5,5,4,4,4,8,
   13,13,4,8,4,4,4,,,4,4,,5,,5,,,5,6,4,6,5,9,4,,7,10,,
   4,4,,,,,8,,,,,,5,6,,,,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,6,
   9,5,,12,6,9,10,10,,5,9,,4,,,,5,,,4,5,6,9,5,9,6,6,,4,
   4,,,,,,,,,,,,,,,,,,,,4,,,6,5,14,9,6,,16,6,5,7,,,4,,,,,,,,,,,,
   ,,,,,,7,8,8,4,7,12,9,5,,,11,,5,13,,,,,,,,,,,,,,,6,11,12,,
   6,10,14,,251,,,,5,,14,6,,10,11,23,,,,5,,4,15,22,21,3,5,
   4,,,6,7,5,6,10,4,4,3,7,,4,4,6,8,6,23,6,8,,,4,8,6,
   16,7,5,,4,,7,21,14,8,,8,8,5,4,5,,4,7,,8,,9,8,7,,10,
   6,,7,9,,,4,,,,,,,,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,5,4,4,6,5,
   5,4,4,4,4,5,6,5,,5,,5,,5,,,4,,7,,4,6,4,10,7,5,10,9,
   5,5,5,,4,,,4,4,7,7,4,4,4,,3,4,4,4,6,6,6,,,5,6,6,9,
   5,11,6,6,,,6,5,5,6,6,7,,7,5,6,,6,6,6,5,5,5,6,,6,6,
   7,,7,6,5,,6,6,5,6,5,5,6,,6,5,,,6,6,9,11,5,6,6,,,5,
   5,6,,4,8,8,8,4,,10,7,,,,5,4,,,,,,,,,,,,,,5,11,8,,4,9,9,,
   ,4,5,,4,10,3,4,3,4,4,4,6,5,7,6,4,5,4,3,4,4,4,4,
   4,7,7,6,5,6,,6,,6,4,6,6,7,5,3,4,4,5,8,8,21,4,4,3,
   4,4,4,4,4,6,4,4,5,24,4,3,3,,9,9,4,9,4,4,4,7,,,5,,,,
   ,,,4,,,,4,,,,,,,,,,8,,,,,6,,,,,5,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,6,,,,,5,,,,,,5,,,10,,13,,,,,,5,,16,16,5,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,18,26,18,3,5,,,
   19,11,19,26,18,19,5,3,,,19,12,15,,,22,9,,,,,,,29,9,,,,,,
   15,12,,,,,,4,,,7,8,18,,,5,36,10,,,,,,,,,8,,,4,,,,6,6,,4,
   6,5,,5,4,7,7,4,6,6,12,4,4,,,5,5,,4,4,5,6,5,4,7,7,
   4,5,5,6,4,,4,10,7,5,8,4,7,5,5,4,,,8,9,7,5,,4,6,,6,
   5,6,9,6,6,4,5,5,5,5,,5,,,,,,,,,,,,,,,,,5,7,10,8,4,7,5,
   5,4,,,8,5,7,9,6,6,,12,6,6,,14,8,8,,,6,6,6,8,14,,6,
   6,14,8,8,8,6,,6,8,14,6,,6,12,,,8,6,6,,4,11,4,7,3,4,
   4,3,8,4,11,5,5,7,3,3,3,4,6,5,5,6,6,5,4,4,11,4,9,
   4,6,6,8,8,4,4,4,9,5,11,11,7,9,4,4,4,4,3,5,5,7,3,
   4,4,11,7,4,4,11,7,8,4,11,6,6,6,,,,,,,,,,,,,,,,,,,,,4,,
   14,7,,4,8,5,,6,,4,,8,21,7,9,,,,,,,,,,,,,,,,,,,6,,,10,6,,,
   4,5,15,7,5,6,9,,,,,,,,,,,,,,,,,6,,11,14,5,,,,8,10,153,,6,
   10,,8,,,,5,19,6,,,6,,10,,,,,,,,,,,,,5,8,,6,3,4,5,4,7,5,
   11,7,,7,5,4,8,,27,6,10,,4,4,3,15,6,4,,8,,,,,,,,,5,6,
   9,4,,4,8,4,,4,5,7,21,7,3,5,8,6,7,8,12,44,9,5,13,6,
   8,8,4,4,,6,5,,4,4,5,7,6,5,5,,11,4,5,4,4,,5,,,4,6,7,
   ,5,15,4,7,5,4,,8,,5,,,6,4,,8,4,4,15,7,5,5,7,,,,,,,,,,,
   ,,,,,,4,,11,8,4,8,,10,9,6,24,,4,5,,7,10,,8,4,11,7,,,4,
   ,5,,,,,,,,,,,,,4,8,5,6,3,4,6,4,4,5,24,5,6,5,4,3,6,4,
   5,4,4,7,4,3,4,13,8,3,4,4,7,13,7,6,6,6,6,,4,6,7,4,
   4,3,4,4,7,4,8,5,8,7,4,6,5,4,,5,12,6,24,3,,4,4,4,
   4,4,,,5,5,7,6,4,10,4,4,,9,7,,4,4,,,5,7,5,,4,6,4,4,,
   9,6,9,5,7,6,7,6,6,4,7,7,5,5,,12,4,6,4,,7,,,5,6,,,,,,
   ,,6,5,,,,4,,13,7,,,,,5,8,10,4,,7,11,13,,17,4,5,,6,15,
   5,6,4,7,,8,6,16,7,22,6,9,7,4,,8,7,16,5,4,,5,3,,23,
   4,5,3,7,5,5,,9,3,4,4,6,9,,8,7,8,5,4,,8,3,5,7,,8,
   5,10,6,,,,,17,31,8,,4,5,4,6,,6,7,7,,4,4,4,4,6,6,5,,
   5,5,,,5,10,6,10,4,7,4,,9,4,,7,,6,10,22,7,5,,,13,11,,,
   ,5,,,,,,,,,,,,,,6,21,7,,5,,9,19,,5,,,7,5,3,4,4,4,4,5,6,
   ,7,5,6,13,7,5,6,,8,,7,5,5,6,4,13,13,6,,6,4,6,6,16,
   9,4,,,3,4,10,37,,,4,4,,6,9,,10,5,4,5,,5,5,5,,9,8,,7,
   ,4,,5,,,10,5,,6,4,4,7,,9,5,9,6,,6,20,9,,4,,14,31,,27,
   ,10,6,,,,,,,,,,,,,,81,15,,,4,12,81,,11,6,10,,7,,6,9,5,7,
   6,,6,11,10,,5,6,4,4,4,5,6,7,5,,,,,,,,,,4,7,7,8,6,4,8,
   ,4,10,9,5,,8,4,4,5,4,5,7,7,,6,4,14,7,5,23,21,15,
   16,31,16,8,6,8,5,7,8,16,4,7,,10,9,,14,,5,4,,,,,,4,10,
   10,,,5,,,,,5,,6,,,,,6,,,6,5,8,5,4,,,8,7,27,9,7,12,8,,4,
   ,8,5,8,5,,4,4,5,,21,3,5,4,7,15,9,,44,5,8,7,3,6,,6,
   4,4,3,4,,8,8,7,6,,8,6,7,4,,,,,11,10,13,5,4,,4,,,,4,,,,
   ,,,,4,,,4,,,,,,,,4,,,18,26,,,,,,,29,9,26,18,,,,,,,22,14,4,,
   11,15,19,19,,5,3,,21,19,19,18,,3,5,,,,,,,,,,,,44,48,8,,,
   18,10,,,12,5,,15,19,,,4,,,,,4,,,,,4,,,,,15,18,,,,8,18,,18,
   ,11,19,,,,,31,,44,,,,,,,,,,4,11,12,18,19,3,,5,8,7,18,14,
   5,,3,,,,10,,19,8,,19,,14,,15,,18,12,,12,,4,,,7,,5,,,,8,
   19,19,,8,,36,,,,,11,10,,,4,22,15,29,18,3,5,,,,,,,,,,27,
   12,16,10,5,3,,,,,18,26,,,,18,19,,,26,31,,19,15,,4,,,4,4,
   13,4,4,3,4,7,5,7,4,5,4,4,8,11,8,6,6,4,4,7,5,4,5,
   4,7,4,6,6,7,7,7,6,4,3,3,8,5,8,4,4,7,13,9,4,5,8,
   6,8,4,11,7,8,13,4,7,4,2,5,7,5,4,4,11,6,6,8,5,8,4,
   9,7,6,8,8,13,6,10,4,4,4,13,4,7,3,3,7,6,4,4,5,5,4,
   13,4,8,13,7,4,4,5,7,7,13,3,4,4,4,4,13,8,4,4,3,4,
   5,6,4,9,6,4,10,4,7,4,13,4,13,7,8,7,6,4,3,4,4,11,
   8,7,4,3,4,13,7,7,8,5,13,8,6,6,8,9,7,5,8,7,8,4,13,
   3,4,4,4,7,4,4,4,10,11,6,6,6,6,9,7,6,6,9,4,10,4,4,
   3,4,3,5,7,8,4,4,8,13,6,3,6,4,11,7,4,4,11,7,6,10,
   6,13,7,8,7,7,7,7,4,7,7,11,7,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,6,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,8,,,8,,,10,,,,
   ,10,6,4,8,8,,4,8,,8,,,6,6,6,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,10,,,
   8,10,8,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,6,6,6,
   6,6,6,8,6,6,6,6,8,4,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,
   4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,
   ,2,4,,4,,4,4,4,,,4,4,,,,6,6,6,6,6,6,8,6,6,6,6,8,,4,
   ,,8,8,12,8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,
   12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,8,12,16,8,12,16,20,
   4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,6,6,6,8,8,
   8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,,4,6,,6,,8,,8,,,,,,,,
   6,16,16,6,8,20,8,20,8,20,20,8,4,4,4,4,6,6,6,8,4,6,
   6,4,6,6,,,6,6,8,12,8,8,8,,,,4,6,,6,,8,12,8,,,12,12,,,
   ,16,6,6,16,16,8,,20,16,20,8,,6,6,6,8,10,10,10,4,6,
   6,4,6,6,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,16,16,
   16,16,22,22,,,22,,22,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,6,
   8,12,8,8,8,,,,4,6,,6,,8,12,8,,,12,12,,,,20,8,8,20,,6,
   16,16,,16,6,16,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,
   8,8,,,,4,8,,8,,16,,16,,,,,,,,22,8,8,22,,8,,22,,22,8,,8,
   10,10,8,4,12,12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,,
   8,28,8,,,,,,,,46,8,8,46,46,14,,30,46,30,14,,4,6,8,4,6,
   6,4,6,6,,,6,6,8,8,8,12,12,,,,4,6,,6,,8,8,8,,,,,,,,20,
   20,20,20,8,16,14,6,8,6,16,14,6,10,4,8,8,4,8,8,,,6,
   6,16,,16,,,,,,4,6,,6,,16,,16,,,,,,,,,22,22,,,16,34,16,,16,
   16,34,8,4,12,12,4,12,12,,,12,12,8,,8,,,,,,4,12,,12,,8,,
   8,,,28,28,,,,30,14,14,30,,8,46,46,,46,8,46,6,16,16,6,
   16,16,,,16,16,10,,10,,,,,,6,16,,16,,10,,10,,,,,,,,,14,14,,,
   14,,,,,14,,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,
   4,,,4,4,,,,6,6,6,6,6,6,8,6,6,6,6,8,4,4,4,4,,,6,6,
   6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,10,,,8,10,8,,,4,4,4,,
   ,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,10,,,8,10,8,,,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,6,6,6,
   6,6,6,8,6,6,6,6,8,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,
   ,,,,,,,,,,10,,,8,10,8,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,
   ,,,,,,,,,10,,,8,10,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,
   ,,8,,,8,,,10,,,,,10,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,8,,,
   8,,,10,,,,,10,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,8,10,10,8,8,
   10,,,8,,10,,,,,,,,4,,,,,,4,,,,,,,,,,16,16,,20,,20,12,20,12,,
   20,8,8,,,,4,6,,6,,4,,4,,,,,,,,8,10,10,8,8,10,,,8,,10,,4,
   ,,,4,,,,,8,,8,,,,,,,,24,12,12,24,,12,,24,,24,12,,,,,4,,,,,
   8,,8,,,,,,,,24,12,12,24,,12,,24,,24,12,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,
   4,4,4,,,4,4,,,,6,6,6,6,6,6,8,6,6,6,6,8,,4,,6,,6,,,
   8,8,,,,8,,,8,,,10,,,,,10,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,
   ,8,,,8,,,10,,,,,10,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,8,10,10,8,
   8,10,,,8,,10,,,,,,,,,,,16,16,,20,,20,12,20,12,,20,,,,,,,,8,
   10,10,8,8,10,,,8,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,
   12,,,12,16,16,20,,16,,16,20,,,,12,,,12,16,16,20,,16,,16,
   20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,8,,,,8,,,,6,,,,,,,,,,,
   ,,,,,,,,8,,,,8,,,,,,,6,,,,,,,,6,,,,,,8,,6,,,,,,,,,3,6,6,9,,
   6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,
   ,6,,,,,,3,3,,6,,6,,6,,,,,,,,,12,9,9,,9,,9,12,,12,12,6,
   6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,
   3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,12,9,9,,9,,9,12,,12,
   12,5,5,,4,7,10,7,12,,5,3,5,5,5,10,5,5,5,9,3,5,5,4,
   5,5,,,3,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,7,,7,7,,
   8,7,5,6,8,6,9,5,,5,5,12,8,,,5,3,5,5,5,10,3,5,5,9,
   3,4,4,5,5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,8,
   7,7,,7,7,,7,6,7,6,11,,7,8,,7,,,10,4,10,10,10,7,5,10,
   10,16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,6,5,6,
   5,8,8,,,,,,,,,8,8,,,5,5,7,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,3,5,5,4,5,5,3,5,10,9,3,
   5,5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,
   7,8,5,5,7,,9,7,6,,6,9,,7,,,5,5,6,10,10,7,4,10,10,7,
   4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,,10,,,,,,6,,
   7,7,5,,,10,10,,10,,5,,,,,,26,,,17,,7,16,,,6,,,,,,,,6,,,,,,,,
   ,,,,7,,17,,7,,,,,,,,,,,11,12,10,14,14,,,,,,,,9,7,9,9,14,
   10,7,14,8,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,
   6,11,9,10,9,10,10,8,8,,,,,8,8,,,,8,8,10,8,10,,,,,,17,,,,
   ,,,6,,,,,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,12,14,,,19,,,,11,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,
   6,7,7,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,
   6,8,,,,,,8,,7,7,5,5,8,11,9,8,5,11,8,9,5,5,5,5,4,5,
   5,5,3,5,5,5,5,5,3,,3,5,5,,5,,3,,,,4,4,6,4,,8,6,8,
   6,6,6,6,,,,7,7,3,9,9,7,7,5,6,14,5,17,5,5,5,6,8,7,
   8,4,5,5,5,10,10,9,,4,5,10,,10,,9,,,,5,5,,6,9,7,,7,8,
   8,,,,,,14,14,5,7,26,21,,7,6,25,8,26,5,5,5,5,5,5,3,5,
   5,5,6,6,9,,3,5,6,,6,,9,,,,4,4,9,4,8,8,9,8,6,6,6,6,
   ,14,,11,9,5,8,5,7,7,5,6,7,4,9,5,5,5,5,4,4,5,5,5,
   10,10,9,,4,5,10,,10,,9,,,,5,5,9,6,,7,9,7,11,11,11,11,
   ,9,,21,,5,26,7,14,14,6,11,9,5,,7,7,6,7,4,6,6,6,12,
   12,7,,4,6,12,,12,,7,,,,6,6,7,4,8,6,7,6,10,10,8,8,,10,
   ,94,42,5,18,18,94,42,8,8,11,6,22,5,5,7,3,5,5,4,6,
   6,6,,3,4,6,,6,,6,,,,5,5,3,4,6,8,3,8,6,6,,,,14,,14,
   14,8,11,6,7,8,3,5,7,6,10,5,8,4,5,5,5,10,10,9,,4,5,
   10,,10,,9,,,,5,5,9,4,,7,9,7,5,5,8,8,,12,,25,9,8,25,
   7,6,21,11,5,6,11,26,7,4,6,6,5,12,12,7,,4,5,12,,12,,
   7,,,,6,6,7,4,8,6,7,6,8,8,10,10,,,,12,8,6,43,9,10,14,
   8,7,8,7,18,4,9,9,9,8,8,,,4,9,8,,8,,,,,,9,9,10,6,,8,
   10,8,,,,,,,,8,8,5,29,8,38,38,8,9,12,11,10,3,3,3,4,4,
   3,,2,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,6,6,
   3,5,5,6,6,3,3,6,3,8,3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,
   4,5,4,4,4,5,5,,,,,,,9,7,7,5,7,,4,4,7,11,11,5,5,5,,,
   3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,9,7,7,5,7,,
   4,4,7,11,11,5,5,,,3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,
   5,,,,7,,7,5,7,,9,4,4,8,8,9,4,6,,4,5,4,,4,,6,,,,5,5,
   6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,,,8,8,6,6,,5,,6,,4,
   5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,,,8,
   8,6,6,,5,,,3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,,,,18,,
   10,7,7,18,,5,5,9,10,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,
   4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,6,6,3,5,5,
   6,6,3,3,6,3,8,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,7,,
   7,5,7,,9,4,4,8,8,9,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,
   5,,6,,8,8,5,,,8,8,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,
   ,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,8,8,5,,,8,8,6,6,,5,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,18,,
   10,7,7,18,,5,5,9,10,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,
   7,8,4,7,,8,7,8,8,,4,9,,4,,5,,5,,,5,5,,5,,7,8,4,7,,
   8,7,8,8,,4,9,4,,,3,,,,,,,5,,9,9,5,,12,9,9,10,10,,5,15,
   ,4,4,4,6,6,6,6,,,,6,6,6,6,6,6,8,6,6,6,6,8,,,,,,,,,,,
   9,9,11,,,9,9,,,,15,24,,3,5,5,,,,5,,8,7,5,6,9,7,8,8,
   8,9,5,,,,,,,,5,,9,9,5,,12,9,9,10,10,,5,15,5,5,,,,5,,8,
   7,5,6,9,7,8,8,8,9,5,,3,5,5,,,,9,8,9,13,11,8,7,,9,8,
   ,9,5,5,,,,9,8,9,13,11,8,7,,9,8,,9,3,,,,11,7,,6,7,9,
   17,,9,9,9,14,,,,11,7,,6,7,9,17,,9,9,9,14,,,,,,,,,,,,,,,,,,
   ,8,8,,,11,9,9,,12,,,,,,,,,,,,,8,17,7,,,,7,8,13,29,,12,,,,
   ,7,8,8,13,16,7,7,17,12,5,7,7,5,9,,235,,11,8,,6,,7,,
   9,25,,6,,8,8,7,,25,,8,7,13,17,9,5,25,7,28,8,5,28,8,,
   11,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,
   6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,12,9,9,,9,,9,
   12,,12,12,5,5,,4,7,,7,,,4,4,5,5,5,10,3,5,5,9,4,3,4,
   4,4,4,,,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,,,,,6,,7,
   9,5,7,5,9,7,10,6,5,,5,5,,8,,12,3,5,5,3,5,5,5,5,10,
   9,5,3,5,5,5,6,5,5,4,5,5,,7,,,,,,3,4,,5,,5,,7,,,,,,,8,
   7,6,7,7,,7,7,,11,8,7,6,,7,8,,7,,,4,10,10,5,10,10,5,
   6,7,7,7,4,7,5,5,4,,,5,6,6,,10,6,,,6,,4,5,,6,,6,,10,,
   6,,,,,,,5,10,,10,5,,,,,,10,12,,,,,,,17,,,,,,,,,,6,,,,,,,,,,,,7,
   ,,,,6,,,,,,,,,7,,,,,,,,,,,,19,,,12,17,11,5,,7,,10,5,5,5,3,
   5,5,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,,,6,8,,3,5,,5,
   ,5,5,5,,,,6,,,,8,6,8,6,7,7,,7,9,7,,10,,7,,,5,10,10,
   4,10,10,10,10,7,16,5,4,5,7,7,4,8,8,7,10,10,,5,,,6,,,
   4,7,,10,,10,,5,,,,6,,,6,7,10,,5,,,8,10,,,,5,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,9,14,9,14,8,9,9,
   10,11,7,6,7,7,7,6,10,10,9,8,8,8,9,10,,10,,,6,9,,8,,
   8,8,9,,10,,10,,,11,,10,,8,8,8,,,,,,10,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,16,26,17,,,,,,,6,,,,,,,,,,,,,,7,,
   ,6,,,,,,,,,,,7,,,,,,,,31,11,23,14,,,,,5,5,4,5,5,4,6,7,7,
   5,3,5,4,4,4,6,6,5,6,6,,8,6,,,14,,3,5,,6,,6,,8,,6,,,,,
   ,7,6,7,4,11,8,6,11,10,14,14,5,5,5,5,5,4,5,5,5,4,
   3,4,5,5,4,6,6,5,6,6,6,8,9,,9,14,,3,5,,6,,6,6,8,,9,
   ,9,,,8,7,4,7,5,7,5,5,8,9,11,9,6,5,5,5,6,8,7,8,5,
   4,5,5,5,4,5,5,5,10,10,8,7,9,,9,12,,4,5,,10,,10,8,7,
   ,9,,9,,,,6,11,6,11,21,8,7,25,26,25,9,5,5,5,5,5,5,5,
   4,3,4,5,5,4,6,6,5,5,5,6,8,3,,6,,,3,5,,5,,5,6,8,,3,
   ,6,,,,14,5,7,5,7,3,9,9,17,7,10,6,5,5,5,5,4,5,4,5,
   5,5,6,11,11,5,10,10,11,7,9,,9,9,,4,5,,10,,10,11,7,,9,
   ,9,,,,9,5,14,6,14,5,7,26,,21,,11,7,7,6,7,6,4,6,5,5,
   4,8,8,6,12,12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,8,
   8,7,10,8,14,6,9,43,18,81,17,7,5,5,7,5,3,5,5,5,4,,,
   5,6,6,,8,9,,6,8,,3,5,,6,,6,,8,,9,,6,,,14,11,8,11,8,
   9,5,8,5,9,7,7,5,5,8,5,4,5,5,5,6,8,8,5,10,10,,7,9,,
   ,,,4,5,,10,,10,,7,,9,,,,,9,25,8,21,7,,5,26,7,26,14,23,
   6,7,6,4,6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,6,,12,
   ,12,8,6,,7,,7,,,8,11,6,94,8,42,5,18,18,22,94,42,8,9,
   4,9,9,9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,,,,12,
   11,38,8,38,5,8,29,10,21,17,9,3,3,4,4,4,,,3,5,5,5,5,
   4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,8,8,7,4,,7,9,7,10,10,
   3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,3,3,,3,,3,,
   ,3,6,3,6,3,6,3,5,5,8,6,7,3,4,4,4,,,3,5,5,5,5,4,,,
   5,,3,3,,5,,5,5,5,,4,,,,,,,4,8,8,7,4,,7,9,7,10,10,3,4,
   ,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,8,8,,4,9,7,
   7,7,9,7,,4,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,
   5,8,8,,4,9,7,7,7,9,7,,4,6,6,4,4,4,6,4,4,,4,,,2,4,,
   4,,4,6,4,,4,,4,,,,6,6,6,6,8,6,6,6,8,6,8,6,3,5,5,5,
   5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,8,,8,,7,9,11,13,9,13,9,
   9,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,8,,8,,7,9,11,13,
   9,13,9,9,5,5,,4,,,4,,,3,3,,5,,5,,4,,,,4,,,5,7,11,7,4,
   ,7,5,7,11,,9,4,4,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,
   6,,5,8,6,8,5,,,,,,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,
   ,6,,5,8,6,8,5,,,,,,6,,,,,,,3,,,5,,5,3,,,,,,,,,9,9,9,,17,
   ,9,8,14,11,11,9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,9,5,7,8,
   8,5,9,6,,8,7,8,,4,,,3,,,6,,6,,4,,3,,4,,,5,9,10,18,5,,
   10,7,7,12,18,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,
   ,4,,3,,,,,5,9,10,9,5,12,,15,9,10,10,,3,,,6,,6,,5,,,,5,,
   ,,9,,,11,,,8,8,12,,,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,
   ,3,,3,,,3,6,3,6,3,6,3,5,5,8,6,7,3,,5,,5,,4,,,,4,,,
   5,7,11,7,4,,7,5,7,11,,9,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,5,,
   6,,6,,,6,,5,8,6,8,5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,
   ,6,,5,8,6,8,5,,,,,,6,,,,,,,,,9,9,9,,17,,9,8,14,11,11,9,
   ,4,,,,,,9,5,7,8,8,5,9,6,,8,7,8,,,,,,,,,,,,,,,,,,,,4,,,5,
   9,10,18,5,,10,7,7,12,18,,5,,,,,,,,,,,,,,,,,,,,,5,9,10,9,
   5,12,,15,9,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,15,9,,9,11,,,24,
   9,11,,8,,25,13,7,,,,235,,8,25,7,17,5,6,6,11,29,13,5,
   8,8,17,7,235,,,,7,8,5,9,11,28,7,8,5,12,,,9,,,7,7,7,
   9,17,12,7,,,235,,25,,7,,15,,75,28,,8,10,8,8,,6,7,,7,,,
   8,8,6,6,7,10,8,7,7,20,5,5,4,6,6,6,,,5,6,6,9,6,10,,,
   ,,5,4,10,6,,6,,6,9,,,,,,,8,,,,11,8,8,8,,8,10,10,8,,8,
   8,,10,,,8,8,5,8,7,10,8,5,10,10,5,5,4,10,7,10,,,5,7,
   4,,7,,,,,,5,4,,10,,7,,10,,,,,,,,8,14,,,8,,8,,14,8,14,14,
   11,7,4,11,7,6,6,8,8,6,8,4,9,8,6,9,8,5,5,4,6,4,6,,
   5,8,6,6,,6,8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,6,
   8,6,6,8,8,6,8,8,8,6,6,,6,6,,,,,19,11,,8,18,,9,,16,,,
   5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,,6,,,,,9,,,,,,9,,,,,,8,,7,,
   ,8,6,7,8,7,7,8,6,10,20,5,5,4,6,6,6,,9,5,6,6,,6,,
   10,10,,,5,4,,6,,6,,6,,,9,,,,,8,10,8,8,8,,11,,10,8,,,6,
   7,11,11,8,8,6,8,4,9,8,6,9,8,8,8,4,6,6,6,,,5,4,6,
   5,4,,8,8,8,12,5,4,,6,8,6,,6,5,,,,8,12,12,8,6,8,8,6,
   6,8,6,6,6,8,8,,,,,32,8,,8,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,
   ,,5,,,,9,,,,,,,,,,19,,,,,,19,,,,,,,,10,12,10,12,5,8,10,10,
   8,10,6,6,4,4,6,4,,7,6,6,4,7,6,10,10,10,,8,6,4,10,4,
   ,6,,4,7,,7,,8,,,9,,,,6,,6,,,9,,,6,,,9,19,8,,,11,18,16,,
   ,5,,8,,,,,5,8,6,5,,,,,,,5,,,,8,,,6,,,,,,,,,,,9,,,,,9,,,,,9,
   32,8,,,8,,16,,,5,,8,,,,,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,19,,
   ,,,19,,,5,5,8,7,7,8,4,9,9,5,5,4,10,7,10,,6,5,7,4,
   12,7,8,8,8,,,5,4,8,10,,7,,10,12,,6,,,,,5,12,5,5,11,
   13,5,13,12,11,11,11,5,5,5,8,8,7,7,7,5,5,4,10,7,10,,
   6,5,5,4,12,5,9,8,8,,8,5,4,9,10,,7,,10,12,,6,,,,,5,
   27,5,5,5,12,5,12,27,8,17,17,7,4,7,4,5,7,5,5,5,3,5,
   6,5,,,5,6,6,9,6,6,,,11,10,5,3,6,5,11,6,,5,9,,,,10,
   11,11,5,7,5,5,6,5,5,5,7,7,8,8,5,7,5,5,8,7,5,5,4,
   10,5,10,,12,5,7,4,6,7,8,9,9,,,5,4,8,10,,5,,10,6,,12,
   ,8,,,8,17,12,12,5,5,5,5,17,5,27,27,7,7,4,7,6,5,5,
   3,5,6,5,,6,5,6,4,6,6,6,6,6,9,8,5,3,6,5,9,6,,5,6,,
   6,,8,9,9,5,5,7,7,5,7,5,7,5,5,5,5,9,7,10,9,8,8,6,
   8,9,8,,10,8,9,6,10,9,11,10,10,,,8,6,11,8,,9,,8,10,,
   10,,,,,9,,,,9,8,8,8,,10,,,5,7,9,5,5,4,10,7,10,,12,5,
   7,4,6,7,8,8,8,,,5,4,8,10,,7,,10,6,,12,,,,,11,11,13,
   13,5,5,11,5,11,5,12,12,7,5,5,5,3,5,6,5,,9,5,6,6,,6,
   ,6,6,11,10,5,3,,5,11,6,,5,,,9,,10,11,11,7,8,5,5,5,
   5,6,5,8,5,7,7,9,8,8,6,8,9,8,,10,8,9,6,10,9,10,11,
   11,,,8,6,10,8,,9,,8,10,,10,,,,,10,,8,8,8,,9,,,9,,,10,
   10,4,9,6,9,,9,10,6,4,9,6,9,9,9,17,12,10,4,9,9,17,6,
   ,9,9,,9,,12,17,17,8,10,9,9,8,9,8,9,10,8,10,10,3,3,
   5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,
   8,8,4,5,,5,5,4,11,11,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,
   3,5,5,7,5,,5,4,,,,4,,,,5,8,8,4,5,,5,5,4,11,11,4,3,4,
   ,3,3,3,2,3,3,3,3,3,6,4,3,2,3,4,6,3,,4,3,,3,,4,6,
   6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,,6,5,5,4,6,5,5,5,5,
   ,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,5,,,4,3,4,
   4,3,,5,5,8,8,4,3,,5,8,3,,5,4,,,,6,9,9,5,5,7,7,5,5,
   5,5,5,5,7,7,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,
   ,6,,6,,,5,,,,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   4,4,4,4,,,,9,,4,3,,6,9,,,6,4,,3,,6,,,13,6,,,4,6,7,6,
   6,5,9,9,5,4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,,7,7,4,11,
   5,5,,8,4,8,11,,5,5,4,,3,5,,,9,6,5,3,5,5,9,3,,5,,,4,
   ,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,4,4,6,6,6,6,,4,2,
   6,4,6,4,,4,4,,4,,,6,6,8,4,4,4,6,4,6,4,4,8,4,4,,,,,,
   6,,3,,6,,4,,6,3,,4,,,9,9,5,9,6,6,7,,4,,9,13,6,6,5,,,
   9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,
   5,5,5,5,5,14,8,,3,3,5,14,,,5,,,,,,9,9,6,8,7,7,,8,6,
   8,8,,7,7,3,9,,5,3,5,5,9,5,,5,,,,,8,14,14,,7,8,8,6,7,
   ,7,7,6,8,8,9,,5,3,5,5,9,5,,5,,,,,8,14,14,,7,8,8,6,
   7,,7,7,6,8,8,8,,6,14,,6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,
   8,6,8,8,,6,6,,,,,,,,6,,,14,6,,6,6,12,,,3,,5,,4,,5,,,4,,
   ,7,7,4,11,5,5,,8,4,8,11,,5,5,3,4,6,3,,4,3,,3,,4,6,
   6,3,4,4,4,3,4,3,4,4,3,4,4,5,14,,,5,,,,,,9,9,6,8,7,
   7,,8,6,8,8,,7,7,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,8,,,,,
   9,,,,,7,,,,,,7,,,,,,,5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,
   7,7,,,,,,,,,,,,,,,,,,,,,6,,6,,6,,,5,,,,5,,5,,,5,,,,4,,,9,9,
   5,9,6,6,7,,4,,9,13,6,6,,,,,,,,,,,,,,,,,,,6,,,13,6,,,4,6,
   7,6,6,5,9,9,,,,,,,,,,,,,,,,8,8,12,,6,6,,,14,,,,6,6,6,,,,,
   7,,,,,7,,,,,,,7,,,,,7,,,5,8,8,5,5,6,5,5,5,14,14,,,8,8,
   5,8,4,14,,,4,5,,8,,,5,8,8,5,,8,,,5,8,8,8,6,8,8,6,5,
   5,5,4,8,8,,,5,5,5,8,8,8,8,,,14,,,5,5,4,3,,4,4,5,4,,
   ,4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,
   4,4,7,6,,6,,7,,7,,,,,,7,7,,,,7,7,7,7,4,4,4,,4,4,5,4,,
   ,4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,
   4,4,7,6,,6,,7,,7,,,,,,7,7,,,,7,7,7,7,4,4,4,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,
   4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,
   4,4,4,,,4,4,,,,6,6,6,6,6,6,8,6,6,6,6,8,,3,5,,6,6,
   7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,
   ,4,,9,,6,8,,,7,,,,,,7,7,7,4,4,4,,7,7,7,,,,,8,,8,6,,6,
   11,,11,5,,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,6,8,,13,
   14,7,,,,8,8,8,8,8,7,7,7,6,,,,5,,6,6,7,6,7,6,6,7,6,
   9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,
   ,,,7,7,7,4,4,4,,7,7,7,,8,,,8,11,14,6,8,7,11,5,,,5,5,
   ,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,,,,,8,8,8,8,6,,,
   ,8,7,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   4,4,5,5,4,4,7,7,4,4,5,3,4,5,,,4,4,5,9,7,7,7,,15,,
   3,4,,4,,5,,7,11,11,6,,,13,,5,9,6,5,7,7,4,9,7,7,9,5,
   4,4,4,4,4,5,5,7,3,4,4,4,5,5,,,3,5,5,6,5,6,5,,,,3,
   3,11,5,,7,6,7,8,,4,7,,,,6,5,5,9,6,4,3,5,9,9,5,6,5,
   4,5,4,8,6,8,4,5,5,4,5,4,,,4,6,12,6,7,11,10,,,,3,4,,
   6,,7,,6,,14,,11,,,,6,12,6,12,13,6,4,7,7,7,7,5,4,5,4,
   4,4,7,4,4,4,3,4,4,,,4,4,5,6,5,6,6,,,,4,4,,4,,7,6,
   7,7,11,7,7,,,,8,6,6,14,10,4,4,4,16,4,4,7,5,5,4,5,
   8,4,4,4,4,6,6,,,5,4,12,10,7,6,5,,,,4,6,12,6,,7,13,
   12,10,10,7,12,,,,13,6,6,17,,4,9,6,12,7,5,4,7,6,8,7,
   4,10,8,4,8,6,,,10,8,7,18,7,8,13,,,,4,8,8,6,,7,12,7,
   11,9,12,11,,14,,30,6,5,28,30,7,6,5,28,7,5,6,4,5,7,
   4,3,5,4,5,5,,,4,4,5,6,7,7,7,,12,,3,4,6,4,,5,6,7,6,
   7,,6,,15,,14,8,14,8,6,4,5,4,6,4,7,5,5,8,4,5,6,4,4,
   6,,,4,4,6,,7,7,12,,,,4,4,10,4,,7,6,12,,,14,16,,14,,19,
   7,17,19,10,4,6,4,,4,4,10,7,4,5,5,4,5,8,,,5,5,6,13,
   6,12,11,,13,,4,5,10,8,,5,7,5,9,14,7,10,,,,18,9,10,10,
   16,4,8,6,10,5,6,6,6,9,11,6,8,8,,,9,11,10,7,10,19,19,
   ,16,,6,8,7,8,,10,7,10,,,,21,,16,,,9,9,,,9,9,7,,7,7,
   10,4,4,2,4,4,,,3,3,4,4,4,4,4,,5,,2,3,5,3,,4,4,4,5,
   5,4,4,,5,,6,5,5,6,5,4,5,4,5,4,4,7,4,4,4,4,,,4,5,
   5,5,5,6,,,8,,3,4,6,5,,5,5,5,6,6,,,,,,,6,,7,8,4,7,5,
   8,5,10,6,4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,5,6,
   6,,,,,,7,6,,,8,5,7,5,8,3,4,4,4,4,,,4,4,4,4,4,4,4,,,,
   2,4,5,4,,4,4,4,5,,4,4,,,,5,6,6,5,5,5,4,4,5,4,5,4,
   4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,,,7,7,
   8,4,4,3,8,5,10,7,,,5,4,5,6,5,,5,,,,3,5,6,4,,5,6,5,
   6,8,6,8,,8,,7,,7,,8,7,6,5,8,5,6,7,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,5,,,,,,4,
   4,6,4,,5,6,5,,,5,5,,8,,6,,7,6,,7,4,4,6,7,6,5,5,,5,,,
   ,,,4,4,6,4,,5,5,5,,8,6,6,,,,6,7,,6,,7,5,5,6,4,4,3,,
   4,7,7,,6,,4,5,,5,,4,,4,8,7,8,7,,6,,6,8,8,5,6,4,7,
   6,5,9,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,,,6,,14,11,9,,15,,
   7,6,12,7,5,6,7,7,,8,,4,5,,5,,4,,4,8,7,7,8,,6,,5,8,
   8,6,6,5,7,7,5,5,4,5,4,,29,,4,8,8,6,,7,9,7,,6,9,8,,
   12,,17,9,9,15,,6,5,5,,9,9,,,16,,4,6,8,8,,7,8,7,,5,,,,,
   ,17,9,9,15,,6,,7,,6,7,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,
   8,,6,10,6,,,10,10,,,,11,,,,,,7,7,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,4,4,4,,5,4,4,,5,,5,5,5,5,6,4,3,5,6,5,4,3,
   8,4,,5,,5,8,,6,6,,,,6,,7,6,6,4,3,4,,5,7,5,8,,,6,,,11,
   ,9,,11,,,9,9,17,15,5,6,10,113,,7,,,5,,5,,,6,6,,,,6,7,,
   6,6,6,5,7,,4,7,4,,,,,,,,,,,,,,,,,,,,,,,,4,7,7,,7,,8,,6,8,
   8,5,5,4,5,5,6,7,5,7,,8,,9,,,,,14,11,9,,12,6,7,6,15,
   9,,10,7,7,7,,,6,,5,8,8,6,5,4,6,7,6,6,4,7,,8,8,,,,9,
   11,,9,9,8,8,,8,7,7,5,8,8,,,,13,15,11,13,,11,5,7,,8,,
   6,4,,,,9,,,9,7,5,7,6,8,7,9,7,,,,9,,,9,7,7,6,,8,4,6,
   5,,,,,,,,,,,,,,,,,,,11,11,,,,,7,,7,,,,,,,,,,,,,,,6,6,6,7,6,6,
   9,20,9,6,,,7,6,6,,9,15,21,,,15,21,9,,6,7,6,6,20,9,9,
   6,6,8,7,12,24,15,6,7,8,6,4,4,8,6,6,6,5,6,5,6,8,7,
   6,6,7,15,21,24,4,5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,
   12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,
   7,7,,,,7,7,7,7,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,
   4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,7,10,
   7,,,,4,7,7,10,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,
   6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,7,10,7,,,
   ,4,7,7,10,,,,,8,11,7,,,4,8,,11,8,,5,6,9,,8,6,5,5,8,,
   6,,,7,,,,,9,6,,8,,8,,,,,,,,7,5,8,8,8,6,6,8,7,,,,,,4,4,
   6,4,6,4,4,6,4,6,4,4,4,4,4,4,6,6,4,4,6,,4,,,6,,,4,
   4,6,4,,4,,6,6,6,,,,,,8,6,6,6,6,6,6,6,6,6,6,6,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,8,,,,11,,11,,5,
   ,6,5,6,,,,9,8,,8,,,9,,,8,5,7,,,6,,8,6,8,,,,,,,,6,8,11,
   8,8,8,,11,5,7,4,4,4,5,5,4,4,7,7,4,3,4,4,4,5,6,6,
   4,4,4,,5,,,6,,,3,5,7,5,15,5,,8,,9,,,,,,4,4,6,10,14,8,
   6,14,5,9,7,6,4,4,4,4,4,5,5,7,3,4,5,4,5,5,5,6,3,
   4,5,,5,,,6,,,4,4,9,5,,7,,10,7,7,,,15,,13,4,3,5,6,9,
   6,5,7,4,7,4,4,5,4,5,4,8,6,8,5,4,4,4,6,12,5,6,4,
   4,6,,7,,,10,,,5,4,16,6,15,7,,7,,7,,,16,,,4,9,6,,17,13,
   6,19,6,7,6,4,4,5,4,4,4,7,4,3,4,4,4,5,7,7,4,5,5,,
   7,,,9,,15,3,5,6,5,13,5,,10,6,5,,,,,,7,4,6,7,5,5,9,6,
   4,4,3,6,5,5,4,5,8,4,4,6,5,5,12,10,11,4,5,4,,7,,,6,,
   ,4,6,6,12,14,7,,7,11,10,,,,,14,6,4,6,13,12,6,12,13,
   9,6,4,9,7,6,8,7,10,4,8,10,8,7,13,8,4,8,6,,7,,,18,,,
   5,5,10,6,,5,,8,12,18,,,,,16,7,6,5,30,28,30,6,6,8,5,
   7,6,4,5,7,3,4,5,4,4,5,9,,3,4,4,,5,,,5,,,4,4,6,5,,5,
   ,8,6,6,,,,,15,9,7,8,14,6,6,7,5,4,4,4,5,5,8,5,4,4,
   4,4,6,7,,4,6,6,,7,,,16,,16,5,4,10,12,,7,,7,6,5,,,,,
   16,7,6,13,19,6,6,17,,4,4,9,6,7,5,4,5,10,8,6,18,12,
   4,8,6,,5,,,10,,,10,8,18,7,16,7,,8,8,13,,,,,,5,7,30,6,
   6,5,28,30,6,7,6,8,9,6,8,9,11,10,,9,6,11,8,,10,,,26,,
   15,9,8,26,10,16,10,,9,9,,,,15,,16,7,9,,,,,,,9,7,9,9,4,
   4,4,5,5,,,3,4,5,,5,,,,,,4,4,,6,8,7,,7,5,5,,,7,,,7,4,
   7,,6,6,,7,6,5,6,10,4,4,4,4,4,4,2,4,4,,4,,,4,,,3,3,
   4,4,5,4,,4,4,4,,,5,,5,5,4,6,5,5,5,6,5,4,4,7,4,5,
   4,5,,,3,5,4,,5,,,,,,4,4,6,7,,6,,7,6,6,,,4,,,7,5,,,6,
   6,7,7,10,3,4,4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,
   ,4,6,,,,8,,7,4,7,,8,7,,6,6,4,6,7,5,5,6,,4,4,4,,5,,,
   6,,,4,5,6,5,4,5,,4,5,,,,,,7,4,4,7,8,7,,,8,3,10,7,5,
   7,7,4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,4,7,8,6,5,
   6,8,,6,6,4,7,4,4,,5,,7,,,,,16,5,6,,,10,,,8,9,,,,6,,,6,
   ,9,,15,17,9,9,7,5,6,6,4,5,,,7,,,,,29,5,6,,,10,,,8,8,
   9,,,,,,6,5,9,,15,17,9,9,7,10,7,10,4,4,,4,,,4,,5,4,4,
   4,4,5,4,,4,4,4,,,,,5,4,5,5,5,6,6,5,5,4,5,4,4,4,,5,,
   ,6,,,5,4,6,5,7,5,,4,,6,,,,,4,5,7,,8,,7,6,6,5,4,4,3,
   ,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,7,7,6,7,8,,7,,8,5,10,
   6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,6,14,6,,7,,,,
   ,9,,9,5,7,8,6,6,5,8,,7,5,4,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,14,7,,7,,,,,,,,,7,9,15,
   ,14,11,15,8,6,5,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,,8,9,9,,
   8,,6,,,,,,,7,,,,11,,11,7,,,,4,,5,,5,,7,,,,,,,8,5,6,6,7,,
   7,6,,7,7,4,6,,5,,5,,7,,,,,,,,3,4,6,7,7,,6,,4,7,5,10,,,
   ,,7,,,,,,,15,6,5,14,15,11,9,,15,6,,7,8,,4,,7,7,7,,,6,,
   8,5,4,6,,8,8,5,6,7,4,7,6,9,,,,,,,,,,7,7,,,,11,11,,,,,,,
   7,7,7,,,8,,14,5,4,5,,8,8,6,6,5,5,7,7,,,,,,,,,,,,,,,,,,,,
   ,8,8,,,8,,,6,6,7,6,7,7,7,6,,6,6,,4,,,29,,10,7,7,17,
   9,9,9,15,,9,5,5,7,,,12,,10,4,6,17,9,9,9,15,,5,6,,7,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,11,14,,,,,,,7,7,,,,,,,,,,,,,,,,
   14,,11,,,,,7,7,,4,15,12,20,6,7,6,5,5,6,6,21,24,9,7,
   6,8,4,6,6,4,,,,6,6,24,8,7,6,6,6,,6,7,6,8,10,6,,,21,
   7,6,8,,,6,15,21,24,6,6,20,9,21,7,21,24,15,6,4,7,4,
   5,4,5,6,6,5,,,,5,10,,10,13,17,9,,8,,,8,,6,,,5,,8,,,12,
   5,,,,,9,6,,,,8,10,,,10,9,,,,,9,9,,,,9,9,9,9,5,5,5,4,,3,
   ,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,
   ,,4,4,,4,,6,7,6,,,7,,,,,10,7,4,4,4,7,10,7,7,,,,6,4,
   6,6,4,4,4,4,4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,
   ,6,6,4,4,,4,6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,
   4,4,4,,,,,,9,,10,,8,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,
   ,,8,,,,10,,,,,,9,9,5,5,5,9,9,9,9,,,,,,6,6,7,6,7,6,6,
   7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,
   ,7,,,,,10,7,4,4,4,7,10,7,7,,,,3,,,6,9,9,,,6,,9,,,6,6,
   6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,12,12,12,,,,,12,
   12,12,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,
   6,6,9,,,,,,,,12,12,12,,,,,12,12,12,5,5,4,7,7,4,6,7,7,
   5,4,6,4,4,4,,5,5,6,6,,9,7,,,20,,4,4,10,6,20,6,8,9,,
   7,5,,,,,4,9,6,4,9,9,4,10,10,10,10,9,5,5,5,4,4,7,7,
   6,4,5,6,5,4,8,,5,4,6,8,,8,5,,,9,9,4,4,10,4,,6,10,
   10,12,7,4,,,,,4,4,3,6,6,4,4,7,7,10,9,7,7,6,7,6,4,
   5,4,7,7,6,5,4,7,,7,5,4,6,,12,6,,,10,10,5,4,6,5,10,
   4,6,6,16,5,,,8,9,9,6,7,7,7,6,7,6,7,7,6,7,7,5,7,5,
   5,4,6,5,4,6,4,4,6,,7,5,6,4,,9,5,,,,20,4,4,13,8,20,
   4,6,10,12,5,8,,,,,9,4,6,9,4,4,9,7,7,5,7,9,7,7,6,7,
   8,5,5,4,7,4,6,,6,7,6,7,,12,7,,,10,10,7,4,9,7,9,4,
   5,6,14,5,7,,6,8,9,7,6,7,6,7,6,7,7,7,7,7,5,7,5,4,
   7,6,7,6,7,7,8,,10,6,6,8,,9,10,,,,,7,7,10,8,,6,11,7,
   13,8,8,,,15,15,8,8,7,9,9,8,8,8,8,6,8,8,5,7,7,4,4,
   6,5,4,8,,8,4,6,6,,9,8,,,20,,4,4,5,6,,6,5,9,,5,8,,,,,
   10,9,9,9,7,9,10,4,4,7,7,6,7,4,7,5,6,5,4,7,,6,5,4,
   5,,6,7,,,9,10,5,4,5,5,9,4,7,6,9,5,5,,8,6,8,7,7,5,
   6,5,7,7,6,6,7,5,7,7,7,6,6,6,7,6,,11,7,6,8,,8,5,,,,
   ,5,7,8,4,13,6,10,8,11,7,12,,,,,8,4,9,10,7,4,8,8,8,
   8,7,8,8,6,8,8,4,7,,8,6,4,6,,18,8,,,10,9,6,4,5,6,
   10,4,8,7,,,5,,9,12,11,7,7,6,11,8,7,7,7,7,8,8,6,5,
   5,4,4,4,,,4,6,8,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,
   ,4,6,7,6,4,,4,4,6,6,10,5,4,4,4,,,4,5,5,,8,5,,,5,,
   4,3,5,4,5,4,4,4,6,4,,,,,,,4,7,6,5,4,,4,4,9,10,6,5,
   4,5,,5,6,6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,5,
   5,6,6,5,5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,,,,,5,4,
   4,4,4,5,3,5,4,6,,4,,8,,8,4,,7,5,6,,4,4,4,6,7,6,4,,
   ,4,4,4,,6,,,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,6,4,
   4,4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,4,5,
   3,5,4,6,,4,,,8,,4,,6,7,9,,4,4,4,6,6,7,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,5,6,,,8,,,,7,,4,3,5,4,5,4,4,4,6,5,5,,,
   ,,7,5,,,8,5,7,4,4,7,7,8,5,4,,8,,,,,5,4,4,4,4,5,3,
   5,4,7,7,4,,,8,,4,,6,6,7,,4,4,4,7,6,9,5,,6,5,,,8,8,
   5,4,5,5,8,4,6,6,,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,5,
   5,6,,8,5,,,5,,4,3,5,4,5,4,4,4,7,4,7,,,,8,,4,6,9,7,
   4,,4,4,10,9,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,8,6,
   8,8,12,6,8,8,,8,8,,8,8,8,9,9,8,8,8,9,9,9,9,8,8,8,,
   ,,7,4,4,4,4,5,3,5,4,7,6,5,,,12,12,5,7,,8,,7,5,4,4,
   8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,
   5,6,5,5,6,4,7,5,9,,5,,,,,5,,,,,,5,5,5,,,,5,4,7,5,6,
   6,5,5,9,5,,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,8,4,
   4,6,6,7,4,4,,,7,6,6,4,4,6,3,,4,6,,3,,6,6,6,3,4,4,
   4,4,4,3,4,4,4,4,4,,,,6,,,5,,,,,,5,4,7,7,8,4,5,7,7,,,
   8,,4,,5,,5,5,,,,,4,4,7,6,6,4,4,,,6,7,5,6,,,,7,7,,,,,
   5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,3,4,4,4,
   6,6,6,,,,5,,,,,4,5,8,,,5,4,7,7,8,8,8,,5,5,,8,,,4,4,
   6,7,6,4,4,,,9,6,7,7,7,,17,15,16,7,7,10,16,13,7,7,,,
   13,6,6,4,,,,12,4,13,8,8,7,13,4,5,5,,,,,12,,,13,4,,,,4,
   13,5,5,7,8,7,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,,
   6,,,,,6,,,,,,6,,4,9,7,13,4,3,4,4,7,13,9,9,13,7,3,4,
   4,4,13,9,7,5,5,9,9,13,13,4,4,4,8,13,7,7,7,4,4,4,
   7,13,9,9,4,4,4,4,4,4,13,9,7,4,4,7,13,9,3,7,9,13,
   7,9,13,5,8,5,,,5,,,,8,8,,11,7,8,8,14,11,,8,5,5,9,6,
   8,6,,5,8,,6,9,9,,,,5,,,,,8,,6,,,,8,,,,7,7,,,,8,17,8,7,
   8,8,11,3,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,
   6,,,,9,,6,,,,9,,,,12,12,,,,12,12,12,12,,,,,,,,9,6,,9,,,6,,
   9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,12,12,,,,
   12,12,12,12,,,,,,,9,11,,,8,10,,8,10,,6,5,6,,5,8,,,5,8,,
   6,,8,,,,8,9,,,,8,10,8,10,11,11,10,,,,17,6,,,,5,7,7,11,
   8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,9,7,9,6,12,,7,,7,12,,
   ,7,,,32,32,8,12,10,,,12,12,15,13,8,,,,,,13,10,,,,13,10,
   7,8,12,7,8,,6,,7,7,9,7,,8,8,8,8,15,,6,,7,,,9,9,12,,
   135,,14,6,8,,,10,,,,21,,,,,,7,9,,,,6,17,7,20,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,7,,8,7,8,8,,12,9,,
   8,15,,9,6,,,,135,15,8,10,,19,7,10,10,14,16,18,20,,,,6,
   17,,,,7,9,15,8,,8,8,10,8,,10,,9,11,9,9,15,,,,11,15,,5,,
   ,,,,11,10,17,,60,11,18,12,19,16,14,19,,,,12,30,,,,12,30,
   20,16,8,8,7,,,10,,12,13,13,10,20,19,9,,22,15,,15,10,,,
   43,,,,,,,13,,,,,,,,,,,119,,,,27,,15,29,15,9,10,9,7,,12,7,
   12,7,,14,9,,7,9,,11,9,,,,,9,7,13,,,8,9,,,10,9,24,,,,12,
   16,,,,8,11,11,13,8,11,11,,,15,10,16,12,15,,11,,15,11,,
   16,10,16,,,,8,18,15,,34,14,,21,15,13,,12,,,,9,33,,,,,55,,
   86,13,15,10,,10,10,,11,16,,9,,6,9,,10,8,,,,,16,11,11,,,
   10,13,10,,,13,30,,,,7,9,,,,9,15,11,20,10,10,10,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,6,5,5,,6,6,,6,5,,,16,,
   6,5,4,,11,,,,8,7,,,,,,9,7,,,,9,12,22,23,5,11,7,6,5,6,,
   4,,6,6,,6,5,,,10,,6,5,,,,4,4,,8,7,5,,,,,7,7,,,,6,7,7,
   7,4,5,5,5,6,,5,,,6,,6,5,5,,,16,,,6,,14,6,7,6,,,7,8,,,
   ,9,12,,,,9,7,17,14,7,8,5,,7,,,5,,,6,,7,,,,5,5,6,,8,5,
   6,5,8,8,8,8,,,,11,11,,,,11,11,5,6,,5,,8,5,,6,,,,,8,,,
   8,6,5,7,,10,6,7,5,10,9,7,9,,,,17,7,,,,16,31,7,7,7,5,
   8,5,,,8,,8,7,,,,21,,,6,,,,,,,,,,,,,9,,,,,15,10,,,7,8,7,,5,,
   ,5,,7,,10,14,5,4,6,,8,4,4,4,8,7,6,6,,,,12,7,,,,5,16,
   4,6,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,4,,,,10,,6,7,
   ,,6,7,6,,,7,8,,,,6,7,,,,7,7,15,15,5,5,4,,,5,8,,8,,6,
   5,7,,12,6,7,6,9,7,9,10,,,,16,31,,,,17,7,6,7,11,5,7,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,10,10,6,5,7,,12,6,7,6,
   10,7,7,10,,,,11,11,,,,11,11,7,8,5,4,5,5,,14,10,4,5,5,
   ,7,5,6,5,6,7,7,8,,,,5,16,,,,12,7,5,5,6,6,,,21,,,6,,,,,
   ,,,,,,,,,15,10,,,,9,,,,7,8,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,11,,
   21,,,10,14,8,,,11,15,,,,14,,,,,,8,11,17,,,,12,8,,,,,,14,
   15,13,,13,,,,,8,,,,14,,8,14,,,,,,,,6,,6,,5,7,8,,,,9,10,,,,
   17,6,9,9,8,7,5,5,,,5,,5,,,6,7,,,,5,11,,,,11,6,11,11,,,
   5,,,,,,,,,,,,,10,8,,,,11,13,,,,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,11,14,,,,14,8,,,,,,4,,8,7,,,,,,8,7,,,,6,8,8,8,6,10,
   10,,,,5,,,,,8,9,,,,7,8,,,,10,10,8,7,,,,,,22,9,,,,6,6,9,
   12,5,7,8,,9,10,,,,11,,,,,,11,,11,8,9,6,8,9,,,,10,10,,,,,
   7,10,10,,,7,,,,,,8,,,,7,14,9,9,7,,,,,,,11,,,,10,,,14,6,9,
   8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,11,,,,7,9,7,8,7,18,12,,
   ,,9,11,7,11,13,11,8,,,,,,,,,,,,,,,,,,,,,,,,,11,11,11,13,5,
   11,8,5,6,8,10,9,8,13,9,8,8,10,5,5,5,,4,,5,4,4,6,4,
   6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,
   9,,7,,,,,,,,4,4,7,10,7,,,,4,7,7,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,
   6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,10,7,
   4,4,4,7,10,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,8,11,8,6,,,,,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,
   ,5,5,,,,6,7,8,,,8,6,,,,,,7,7,7,8,11,8,,8,8,17,4,4,4,
   5,5,4,4,7,7,3,4,4,4,4,4,7,11,3,5,5,,5,7,7,6,15,,
   4,5,,5,,7,9,7,,,6,,,12,,4,4,4,4,5,14,7,8,5,14,8,7,
   4,4,4,4,4,5,5,7,4,4,4,3,4,4,11,7,4,4,5,7,7,6,6,,,
   ,4,4,,4,,5,7,7,,,6,6,,,,4,4,4,4,4,6,10,14,7,8,6,16,
   5,4,5,4,8,6,8,4,4,4,4,4,4,,,5,4,6,14,7,12,7,10,14,
   ,4,6,,6,,7,16,12,,,,5,,,,4,4,4,4,6,17,10,19,10,19,7,,
   4,5,4,4,4,7,3,3,5,4,5,5,,8,4,5,5,6,7,5,6,11,,,3,4,
   ,5,,5,7,7,,,7,6,,,,9,5,4,5,3,5,8,9,6,6,5,9,5,5,4,
   5,8,4,5,6,4,4,6,10,10,4,6,12,7,7,5,6,12,,,4,4,,6,,
   7,12,12,,,10,13,,,,7,5,4,6,9,6,,17,4,13,6,12,7,6,8,
   7,4,5,5,4,5,8,14,9,5,5,6,7,5,11,12,10,,,4,5,,8,,6,
   10,5,,,13,7,,13,,5,6,4,6,8,10,16,10,6,18,9,10,4,5,7,
   3,4,4,3,4,4,11,11,3,3,5,6,5,7,7,,13,,4,5,,5,,7,5,7,
   ,,9,,,15,,7,9,7,9,4,6,12,5,5,5,9,8,5,8,3,5,4,4,6,
   6,14,,5,5,12,,7,10,11,,,,4,5,,4,,7,11,6,,,6,,,,,7,7,6,
   7,4,6,13,12,5,6,12,11,7,4,10,8,4,8,6,9,11,10,5,7,
   12,7,13,8,8,14,,4,8,,5,,7,11,7,,,18,12,,,,7,5,7,5,6,
   5,30,28,6,30,6,28,6,9,8,6,11,8,,,9,8,10,,10,19,19,7,
   16,,6,11,,8,,10,21,10,,,7,7,,16,,7,7,9,7,9,9,,,10,,9,,
   4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,4,,,4,4,
   ,5,,5,4,4,5,3,5,8,5,3,5,5,8,4,4,4,4,,,4,5,5,5,5,,
   ,6,8,,3,4,,5,,5,5,5,,,,6,,,,7,6,7,6,5,7,,6,5,6,,10,
   4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,,5,,5,6,5,,,6,,,,,7,
   7,4,4,3,7,10,6,5,6,,,4,4,,5,4,4,4,4,4,4,4,5,,,2,4,
   ,4,,4,4,4,,,4,4,,,,4,5,5,4,4,6,7,5,4,5,6,7,4,8,,5,
   4,5,6,5,,,6,,,3,5,,4,,5,6,5,,,,5,,,,4,4,7,7,5,,,6,3,
   6,7,10,,,5,4,5,6,5,8,6,8,,,3,5,,4,,5,6,5,,,5,,,8,,6,
   7,6,7,5,,10,6,5,6,7,,,6,8,7,8,7,5,6,11,,,5,6,,8,,7,
   8,7,,,9,,,,,8,,11,7,5,11,,13,6,13,15,,6,6,8,8,7,,,,,,
   5,6,,6,,8,8,7,,,9,8,,,,11,7,8,,8,,,13,5,13,11,11,4,5,
   ,5,,6,6,,,4,4,,4,,5,,5,,,5,5,,8,,5,7,4,5,7,,8,7,6,,
   6,8,5,8,5,6,,6,,,4,4,,4,,5,6,5,,,6,6,,,,5,5,4,3,4,
   6,8,7,7,,,8,8,4,7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,7,4,4,
   6,7,8,,,6,,8,,,,9,,,,4,,,6,,7,4,7,,,8,9,,10,,7,9,5,6,
   7,,12,9,9,9,,14,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,5,4,
   5,5,8,,,7,,8,,4,8,,,4,,,5,,7,,7,,,,8,,16,,6,7,6,7,,9,,
   15,5,17,9,,8,12,,4,5,,,,7,8,7,,,,9,,29,,9,9,6,5,5,9,,
   15,,17,9,,11,,5,6,,6,,,9,,,,5,6,,7,,,7,5,10,6,9,15,17,,
   ,9,113,,5,,,8,,6,,6,,,6,,,,,7,,,,,,11,11,7,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,5,,4,4,4,4,5,5,7,6,5,
   6,5,7,,4,,5,,5,,,6,6,,,,3,4,5,5,7,,8,,4,7,6,8,,,,,,,,,,
   ,,,,,,,,,,,,,,,,5,8,5,,,6,6,,,,5,4,7,5,6,6,8,,7,7,,8,,,,,
   ,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,8,,,5,,8,,,,,,,,10,
   ,4,6,7,,6,,12,9,7,9,,14,,,,,,6,,6,4,4,7,6,8,,,7,,8,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,7,4,,6,7,9,15,,6,14,11,
   12,,10,,9,,6,6,7,9,12,,10,14,11,15,,,,,,,,,,,,,,,,,,,7,7,,,
   ,,11,,11,,,,,,,,,,,,,4,6,6,5,6,10,6,5,20,9,15,6,6,6,7,
   8,6,4,20,15,12,4,4,15,12,20,6,6,7,8,5,9,15,20,5,6,
   6,10,21,24,15,6,7,6,7,,,6,,6,,,7,,,8,7,6,,,15,21,24,,,,
   ,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,
   ,,9,,,,12,12,,,,12,12,12,12,,,,5,,6,6,7,6,7,6,6,7,6,
   9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,
   ,,,7,7,7,4,4,4,,7,7,7,6,17,,9,,10,,,10,13,8,9,,6,,8,
   ,10,,,6,,9,8,,5,,,,,8,,,,12,,,5,,,10,,,,5,5,9,9,9,,,,5,
   9,9,9,,,9,,10,,,9,,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,
   12,,,,,,,,,,,,9,9,17,5,5,5,,17,9,9,5,5,4,7,7,4,6,7,7,
   4,4,4,5,6,6,5,,4,4,6,8,6,,8,6,,,4,6,,8,,9,,9,8,,,,,
   20,,4,5,9,4,10,9,7,9,6,10,9,4,5,5,5,4,4,7,7,6,4,
   5,4,4,6,8,5,12,4,4,4,8,4,,5,13,,,5,6,,6,,9,,10,7,,,
   6,20,,20,5,7,4,7,9,6,4,9,7,9,4,7,7,6,7,6,4,5,4,5,
   5,4,5,4,5,5,9,5,4,5,5,4,,7,5,6,8,7,6,,7,8,6,,6,6,,
   ,7,10,9,9,5,5,7,6,7,5,5,6,7,7,7,6,5,7,5,5,4,6,5,
   4,4,5,6,8,7,12,5,4,8,4,6,,6,10,,,4,6,,8,,8,,10,5,,,
   10,12,12,,10,9,4,7,4,3,6,6,7,4,4,7,7,7,6,7,8,7,7,
   4,7,6,7,5,14,5,4,7,7,4,,7,9,8,6,5,4,,6,9,12,,6,6,,
   ,5,10,10,9,7,7,6,7,7,7,7,6,5,7,6,7,7,5,4,7,5,7,
   7,6,6,6,7,11,6,7,8,12,6,,6,8,,,7,6,,6,,8,,8,11,,,10,,
   ,13,8,7,4,8,8,9,7,10,8,8,4,8,5,7,7,4,5,4,4,6,6,
   10,,4,4,6,5,6,,10,10,,,5,6,,4,,9,,9,4,,,7,,20,20,10,
   10,9,10,4,6,9,4,9,4,9,10,7,4,5,5,4,7,6,7,9,16,7,
   4,6,,4,,6,6,9,8,7,6,,7,9,12,,6,,,,6,10,10,10,6,7,7,
   7,6,7,6,7,7,6,7,7,7,7,6,7,7,6,8,8,13,7,7,8,8,6,,
   10,10,15,,6,6,,8,15,9,,7,6,,,11,,,,6,8,8,8,8,7,9,9,
   7,8,8,8,6,6,4,8,6,6,,,6,4,6,,4,,8,5,12,9,8,8,,7,
   11,18,,7,8,,,8,9,10,10,8,8,7,7,7,6,8,11,6,7,7,7,4,
   4,4,5,5,5,,4,3,4,5,4,,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,
   7,6,4,,4,6,7,6,6,4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,
   ,4,6,,8,,8,,4,5,,,5,5,,5,7,6,,4,4,6,7,6,9,4,,4,4,
   4,4,,6,3,3,3,3,3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,6,
   6,4,4,4,4,3,4,4,4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,,
   8,4,5,,5,8,8,,4,5,,,5,5,,5,5,7,,4,4,7,6,6,6,4,,4,
   5,5,,5,4,5,5,4,,5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,
   5,5,6,6,6,5,5,6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,5,,4,
   ,8,,5,4,,,,5,5,,6,7,4,,4,7,6,6,6,4,4,,7,4,4,4,4,3,
   ,6,5,,,4,5,,,12,8,,5,5,,,,5,,7,,,13,5,4,8,7,8,,4,13,
   5,6,5,7,7,6,,7,,15,17,6,,,6,16,,,,6,,,,9,9,,13,6,7,,
   7,10,13,16,6,7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,4,,,,4,,5,
   5,6,7,4,4,,7,5,6,6,,4,4,4,4,3,,,3,6,6,4,4,,4,6,6,,
   3,,,,3,6,6,4,4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,
   6,,4,8,8,,4,,,,4,,5,5,7,6,4,4,,6,7,9,6,,4,4,,,5,,,12,
   ,5,,4,,8,,5,5,,,5,,5,7,7,8,4,5,13,,,,7,13,4,5,,3,,6,
   6,4,4,,3,6,6,,4,4,,,4,6,4,6,6,6,3,4,4,6,6,6,6,4,
   3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,6,,,12,8,,4,,,,5,7,
   ,5,8,8,7,4,5,,,8,8,5,7,4,,,5,6,,4,,8,,,5,,,6,7,5,,,,
   4,7,5,7,8,7,8,5,4,7,5,,5,,8,5,8,,,,,,,,,,,,,,,,6,,6,,,,
   8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,,,,4,,5,5,6,
   6,4,4,,6,6,7,7,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,5,6,6,
   6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,5,5,,5,
   6,6,,4,4,6,9,7,7,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,
   12,12,12,8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,
   ,5,5,,9,6,4,,4,6,6,7,7,4,4,,,,4,,7,5,7,7,5,4,7,,8,
   ,8,7,5,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,7,4,8,,
   ,8,4,5,7,6,6,,,5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,,5,,
   ,,,5,5,,5,13,7,7,4,4,4,8,7,13,7,9,9,13,4,4,4,5,13,
   9,9,4,4,9,7,13,9,4,3,4,4,13,9,9,13,4,4,3,9,13,9,
   9,3,4,4,5,5,4,9,9,13,8,4,13,7,9,4,9,13,9,9,9,13,
   4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,9,9,,8,,,10,13,,22,,,,,,10,22,15,18,15,16,,
   17,,39,,9,9,12,,22,12,18,,31,,,,,,27,15,9,9,11,10,20,,
   22,,,,,6,,7,8,,8,12,,7,9,7,,,10,10,7,16,16,11,13,,16,
   128,,,5,9,8,,8,11,12,,9,,,,,,8,11,,11,,16,9,12,8,,,,9,,,,
   ,10,12,,13,10,9,,18,12,,22,12,,,12,,18,,68,,9,10,15,22,
   22,,13,,,29,,,,,,10,11,7,15,41,22,27,10,,,,,,6,,6,10,,7,
   10,10,,,13,13,7,10,,8,,,,33,,,5,8,10,25,7,17,14,,9,,19,,
   ,,11,5,8,8,9,13,14,11,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,,,8,,,,,5,8,,15,,,,,,,,,5,,20,,5,,,,,,,,,,,,
   ,5,,,6,,,,,,8,12,,7,10,5,,18,11,9,7,8,,11,13,,17,,63,,
   7,9,16,,8,10,,,9,,20,,,,5,5,,,8,11,8,8,9,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,,12,10,6,,,11,12,12,10,,8,
   11,,,39,10,,6,7,10,63,12,14,13,,,,24,,,,8,6,10,8,10,11,
   14,8,14,,,,,,,,,,,6,6,6,8,6,4,,,11,,,5,5,6,12,6,7,6,,,
   9,9,,,,9,17,7,8,5,10,9,9,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,6,,,,6,6,6,8,6,,,,,,,5,5,6,10,6,7,6,,4,7,,,,
   ,15,7,5,5,4,7,15,6,7,,,,,,,5,6,6,6,8,6,,,,,14,,5,5,
   5,16,6,7,6,,,6,,,,,17,9,8,7,5,12,14,9,7,,,,,,,5,5,5,
   7,5,,,,,,,5,4,5,8,5,6,5,,8,8,6,,,,11,11,,,5,11,11,5,6,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,23,,
   7,8,9,19,10,9,8,,,11,,,,,,,14,9,6,14,52,11,10,,,,7,7,
   9,9,7,,,,,,,6,7,6,17,8,8,7,,,,,,,,,10,,,7,13,17,10,8,,,,
   6,5,,,,,,,10,,,4,6,8,6,5,,,,7,,,,,7,16,5,7,8,7,7,17,14,
   ,,,,10,6,7,,8,10,,,5,5,,,4,7,6,,7,,8,,,,7,6,5,4,5,7,
   7,7,7,,,,9,6,7,,8,8,,,5,5,,14,,6,6,,7,,8,,,,9,6,7,5,
   8,9,12,22,6,,,,,,,,,19,,,6,10,,10,,,,,12,,,,,9,20,6,9,14,
   ,10,,52,,,,7,,,10,12,,6,4,6,10,6,,,,7,7,,,,,7,11,4,5,
   5,11,8,11,11,,,,,,,,,5,5,7,15,7,,7,,,10,10,,,,10,,7,13,,
   ,10,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,,
   ,,,,,7,8,7,,11,14,13,,,,,,,7,16,,10,,8,,,17,,,,,11,,,,,,
   17,14,8,,,,,8,10,11,,,11,12,,,,26,,,,,14,,,,14,,11,8,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,5,5,,5,,,,,6,,,,,5,11,5,,,11,6,11,11,,,
   ,,8,,7,5,,6,,7,,,,5,5,,6,6,5,7,12,9,,,,,,9,6,,7,5,8,,,
   ,22,9,8,5,7,7,23,9,12,,,,,,,,14,,,,,,8,14,,,,8,14,,,,,,
   8,6,,7,,8,,,,8,6,10,6,10,7,8,8,8,,,,,,,11,,,,,8,18,7,,,
   8,8,,125,,,,,7,7,,,,,6,17,5,8,7,31,7,16,7,,,,,,,,,,,,,,,,,,
   ,,,,8,,,,,16,,10,10,,,16,7,9,,,,9,,,,,10,,8,,8,,11,15,,,,,,
   ,9,,7,8,7,,9,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,11,
   13,5,7,7,9,7,8,,,,5,13,11,9,11,7,11,,,,5,5,11,8,7,8,,
   ,,5,13,8,7,6,,,,8,10,12,7,,,,11,11,11,,,,8,5,,,,9,,,,,,,,
   ,,,10,,,9,,8,,11,8,10,8,,9,6,5,,11,10,6,,8,11,8,8,,,,,
   ,5,,5,,6,10,8,,8,,10,,,,11,8,5,7,7,,,,8,8,8,6,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,5,6,6,5,6,5,
   5,5,5,5,5,5,4,7,7,7,8,8,12,7,12,10,,,,6,5,9,4,,5,
   9,8,10,16,8,,,,,10,10,5,4,5,10,6,7,18,18,10,9,8,8,8,
   6,5,6,6,7,6,7,8,5,8,4,,16,5,5,6,10,6,8,,7,,13,5,5,
   20,4,,7,12,10,13,7,8,8,,,18,27,5,5,5,5,5,5,7,31,10,
   27,6,6,4,6,6,7,4,7,5,7,6,8,4,5,,,7,6,8,13,7,10,7,
   15,,,5,6,16,6,,6,13,6,11,10,,6,,,,8,17,7,5,10,8,10,7,
   20,14,6,14,8,6,8,8,6,7,5,7,8,6,5,4,7,13,7,8,6,,7,,
   8,20,,,6,8,7,4,18,7,8,10,16,,10,12,13,,,27,27,5,7,5,
   5,5,5,6,27,6,31,6,6,4,6,5,8,7,5,5,6,5,15,8,7,6,8,
   10,7,,,10,,,8,5,10,5,12,7,10,4,8,15,10,10,,,12,,14,10,
   8,7,10,7,8,17,,14,17,5,4,4,5,4,5,5,7,6,4,8,10,8,7,
   8,7,7,7,9,10,,,7,7,9,4,,6,9,6,8,10,9,7,,,15,12,7,7,
   7,6,6,4,5,8,9,13,7,8,6,5,6,7,5,5,8,4,20,10,5,5,8,
   8,5,10,12,9,,,5,5,,4,,7,,8,5,7,12,9,,,,18,10,10,7,5,
   5,5,4,27,5,31,6,6,7,8,7,6,8,6,6,10,11,7,4,8,,6,7,
   10,16,,,5,6,15,5,,7,,6,7,7,13,13,,,,14,6,8,7,10,7,10,
   5,14,7,17,20,5,7,8,7,7,7,4,10,8,5,4,8,9,6,9,7,9,,,
   4,5,10,3,15,7,7,6,5,6,6,5,,,,9,6,6,5,4,3,6,7,7,6,
   7,8,6,6,8,5,8,4,,10,6,7,7,,6,16,16,17,,12,6,8,17,4,
   15,6,17,6,10,,,17,12,,15,10,9,6,7,8,6,8,7,30,6,28,9,
   5,5,4,4,4,6,,6,4,7,,7,,6,,,,4,4,6,3,7,5,6,5,6,6,8,
   8,8,,,,7,5,7,6,6,7,5,6,7,6,,5,5,5,4,8,8,6,7,7,7,
   6,7,,7,,,6,5,,4,8,4,7,5,,7,,7,8,,6,,8,7,4,6,4,7,5,,,
   ,8,4,4,4,,6,5,5,4,6,5,6,8,8,,7,4,4,6,4,,5,8,4,6,,
   6,,4,,,8,7,4,4,3,7,5,10,7,8,,,5,4,,6,5,5,4,6,5,8,
   8,6,,7,4,4,6,4,8,5,,4,6,,6,,7,,8,8,,7,4,4,7,5,6,7,
   6,,6,4,6,,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,8,6,,
   ,,,,5,7,10,4,4,3,6,7,6,7,5,5,4,3,4,5,4,6,5,6,,5,
   3,4,5,2,5,4,5,4,5,6,5,6,5,,,7,6,4,5,4,5,4,4,5,5,
   5,6,8,7,8,5,8,7,10,10,9,,10,6,,8,6,,7,6,8,10,,9,,7,
   ,14,11,,10,6,5,,6,11,9,13,9,,,6,6,6,,,9,,,,6,6,9,5,
   7,8,8,6,6,10,7,9,,,,,,6,,8,7,9,5,13,9,13,12,5,7,,4,,
   7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,6,4,5,7,7,6,4,
   8,6,8,5,7,8,5,6,,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,9,6,
   4,3,4,5,10,7,7,,,6,6,7,10,10,10,,,7,4,10,4,8,7,5,4,
   6,5,6,5,,,8,,7,6,6,,6,,6,7,,7,7,,,10,,,,8,6,10,5,10,
   7,8,6,7,9,6,10,,,,15,19,5,6,9,,10,6,13,16,13,,,7,,,
   14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,5,4,5,5,7,7,5,8,
   6,8,6,8,6,,,6,8,8,5,7,7,10,6,9,10,10,8,,,,,9,6,10,,
   9,7,5,13,12,13,9,8,,,,6,6,6,,,8,6,,10,,10,,,7,18,13,
   9,5,7,6,,10,9,,9,13,,,6,6,8,5,10,7,9,8,9,8,10,10,14,
   ,33,,9,5,10,8,11,,7,13,12,13,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   8,4,14,5,9,9,7,7,,7,,10,,,,,11,,,,7,,7,11,,,,5,,4,,7,
   8,5,,6,,6,,,7,9,6,6,5,7,4,6,7,,,7,6,8,4,,5,,4,6,,6,
   8,7,,,8,,7,5,5,4,3,4,,6,7,6,6,49,,10,8,,9,,9,,,10,
   18,13,11,7,,5,8,10,9,,9,13,,4,6,4,5,5,5,5,5,,5,7,5,
   5,4,4,4,4,5,6,5,6,5,9,,,,14,,,,,,11,11,,,,7,7,,,,,,8,5,
   ,7,,7,14,,8,,8,7,5,7,4,5,5,,,,8,,9,,10,,10,,,11,,10,,
   6,7,5,9,9,13,9,,6,8,6,,7,,,8,7,6,7,5,6,5,7,,8,7,,
   8,6,8,,,7,12,9,7,5,9,6,5,,12,7,,9,8,6,10,,,13,9,,11,
   6,7,5,6,,7,,9,8,,,10,16,9,,6,10,5,7,6,,15,19,9,7,,,
   13,9,7,9,5,5,6,,,7,,9,,9,,,7,7,,,,,,,11,11,,,,,,,,,,,,,,,,
   7,,7,,,,,11,11,,,24,12,25,8,10,7,,,,,21,15,24,7,6,6,,6,
   ,6,4,4,6,4,6,15,8,7,6,5,6,6,5,20,6,6,7,4,7,6,21,
   7,6,6,4,4,6,24,21,9,5,6,7,24,21,7,12,15,20,,6,,,6,,,
   ,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,
   ,,,,,,12,12,12,,,,,12,12,12,,,,,,8,7,10,10,,,,13,22,,,,12,
   10,15,,13,,10,,,,,13,,20,,15,,,9,19,,,,43,,9,9,27,15,,,,,
   10,,119,29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,
   6,9,7,7,8,7,9,,7,12,7,,10,,12,7,,9,8,,9,13,,,,7,,,,
   11,24,,9,14,,9,,,,,11,8,11,13,,,,11,12,16,13,,9,,,,,8,,
   12,9,14,,8,13,9,7,12,,12,,7,10,,,,7,,12,,,,15,7,,,12,
   32,32,,12,7,,9,10,,,,8,13,12,8,,,6,,7,15,,8,8,8,,16,
   14,8,8,15,18,7,,6,10,,,,7,,,,9,20,10,9,12,,10,135,,19,,
   8,7,15,9,,,,8,6,17,8,,9,,,8,,18,16,18,,13,15,15,12,11,
   ,14,16,10,15,,,,10,,15,,16,,21,11,,,,,,34,13,15,,,55,,,,
   10,9,33,86,,,,8,,,10,,,,,,,,,,,,,,,,8,,,,,,,,,,,20,,,,,,,,,,,5,
   6,,,,7,14,,6,8,8,,21,,8,8,,,10,12,9,8,,,,8,,15,,9,,,6,,,
   ,,135,,,,13,8,17,,,,,7,9,20,10,11,,10,9,11,,16,19,9,9,
   15,14,11,,,17,,,,11,,15,,5,19,12,,,,18,,,60,8,8,12,20,30,
   ,,,7,12,30,16,16,,11,,10,,,,10,11,9,13,10,,8,11,,,,10,,
   16,,10,,16,9,,,13,,,,10,10,9,11,15,,,,10,7,9,20,,,,,,5,,
   6,5,6,7,6,,4,,,,,6,,6,,6,8,6,5,,,,16,11,,8,7,17,9,6,,,
   ,5,9,22,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,
   5,6,5,6,5,5,,,,5,,5,,5,7,5,4,,,,8,,,,,11,11,6,,,,5,5,
   11,11,,,,,5,5,6,7,6,5,5,6,,,,6,,6,,6,8,6,5,,,7,16,,
   14,7,8,9,17,7,,,,5,9,12,14,,,,6,5,6,7,6,,4,7,,,,6,,6,
   ,6,8,6,5,,,7,10,,,5,5,15,15,7,,,,4,6,7,15,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,7,8,7,8,7,,7,,,,,7,,9,,7,9,7,7,,,,
   17,,,,,,10,7,,,,7,10,,13,8,8,9,9,8,,6,,,,,8,,10,,10,10,
   8,8,,,,19,,,14,9,,,11,,,,6,11,,15,5,6,,,,5,4,,,,,,6,,6,,,
   5,5,,,,16,11,5,8,9,22,12,,,,7,9,7,23,,8,5,7,,6,,,,5,,,
   ,6,8,5,,7,,6,,,8,,5,11,5,11,,,,,11,11,6,9,6,8,5,7,,,,
   6,,,,,10,6,,8,,7,,8,12,8,5,17,6,7,,,,7,16,31,7,,,7,,,,,
   5,,7,,7,,,6,,,5,,11,,7,,7,9,14,,,,,,8,9,,5,,,,,4,,6,,6,,
   ,4,,,4,,10,,6,10,6,8,8,,,,10,8,7,8,5,,,,,,,8,,8,,,7,,,,
   ,21,,7,8,9,,,,,,7,15,10,,5,,,,5,,,,5,8,5,,7,,6,10,14,
   7,6,6,12,5,7,,,,,5,16,5,,,,,,7,,7,,,6,6,,,,21,,,10,11,,
   13,,,,7,10,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,4,,,4,,10,,4,5,6,7,7,,,,5,
   7,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,5,8,,7,11,,10,7,5,16,
   9,14,,,,8,17,9,7,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,7,,10,12,
   5,4,11,7,11,,,,5,11,11,8,,6,,,,30,17,,6,9,10,,,,,,14,,
   11,14,4,,,,14,8,,5,7,6,9,23,,,,8,22,9,12,5,,4,14,10,8,
   ,6,5,5,16,,,,6,12,7,6,,,21,,,7,8,15,,10,,,,7,9,,,,,,,,,,,
   ,,,,,,,,,14,,,10,7,,8,,,,10,8,9,,,,,,14,14,,,,,,,11,14,,,,,
   11,8,,,,,14,,17,,,14,,8,,,,,11,14,,5,13,5,6,,,,5,7,13,8,
   5,13,8,,,,5,7,11,8,11,11,,,,11,7,9,11,8,,,,7,7,7,9,,,,
   7,9,11,5,,,,,,,,,,,,,,,,12,8,10,11,8,11,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,,,9,10,22,15,,,,9,
   12,29,22,,12,10,,,12,13,18,,,,,13,12,18,,,68,,22,,,41,27,
   22,11,15,7,,,10,10,,6,,,8,,8,,9,7,10,7,16,9,,,5,,,8,,
   13,9,,,12,7,17,,,11,24,,11,18,,10,63,,,,,11,13,20,,,,,14,
   5,9,9,,,,,10,,10,9,,22,12,31,,,,15,,22,,16,9,,,13,22,,,,
   15,,18,,,18,12,39,,,,,10,,20,9,11,9,,27,15,22,,,6,,6,,
   13,5,10,7,10,9,,,10,10,,7,,,8,,,10,7,,,,8,19,14,13,,,17,
   ,33,25,,,13,11,14,8,9,8,,11,5,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   8,,10,5,9,7,8,9,,,7,17,,8,,13,9,,,12,7,16,,,11,,12,10,
   ,16,11,,128,,,,16,12,20,,,11,,13,11,8,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,12,6,10,12,10,,,,6,10,,12,,11,7,,,10,
   12,,,,8,24,13,11,,,14,10,39,63,,,11,8,14,10,10,8,,8,6,
   14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,6,,,,5,5,7,6,
   ,,4,,,6,6,,,,,,,7,8,,5,10,,8,,,7,17,7,5,8,7,,11,16,14,
   5,5,5,,,,5,5,6,5,,5,5,,,5,5,6,,,6,,,6,7,,,8,,,,,11,11,
   7,5,,,,6,11,11,6,5,,,,,6,6,6,,,5,,,,,,,,6,,6,5,,8,7,14,
   ,16,,,12,9,14,8,5,7,,17,9,7,,7,,,5,,,4,,7,5,,,6,6,8,,
   ,6,8,6,7,10,10,7,,10,,,,7,15,15,5,5,4,,7,6,7,7,,,5,,
   5,,,7,,,,6,6,8,,,6,8,6,6,9,10,9,11,16,,,,7,9,23,8,7,
   5,,22,9,12,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,,14,,,,7,16,
   10,,10,,16,,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,8,,,11,
   5,11,,5,,,11,11,6,,,,7,5,,,6,6,8,,,6,8,6,9,10,9,6,,
   10,14,,,9,22,12,7,8,5,,20,6,10,,,10,,,,9,7,11,,,7,9,7,
   ,11,12,11,,17,,,,8,11,,,,8,,,10,15,,7,,,,6,6,8,,,6,8,6,
   8,10,10,8,,10,,,,7,16,16,10,10,6,,8,6,8,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,15,,,,11,21,7,,13,,10,,7,
   ,,5,5,5,,,4,7,5,7,8,6,7,10,8,8,,,5,13,8,,6,6,,7,5,
   9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,6,,
   ,8,7,,11,12,,,19,9,20,7,5,8,,9,17,6,,,,6,,6,,,8,7,,,
   10,,,7,6,15,5,4,5,,15,7,7,,,,,5,,,,,,,,,,,14,15,7,7,8,,,
   ,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,,,12,,10,,,
   11,11,9,4,5,5,,8,11,11,,,,,,26,,,,,,,13,7,7,8,,9,,15,7,
   8,,,12,11,,,,31,16,9,5,7,8,,6,17,9,,9,8,,,17,,,13,10,
   17,,7,,,,10,8,10,9,23,,19,,,14,11,52,14,6,9,,,,10,,19,,,,
   ,,,10,6,14,9,,13,20,52,11,,,,,8,,8,7,,,,12,18,125,,,,,
   14,11,,,,,,,14,8,,,,,14,17,,,,,11,,11,,,8,,14,,,,,8,14,,,,,,,
   ,,,,,,,,,,,,,,,,11,11,11,8,13,,19,9,11,16,7,12,7,,7,7,9,
   8,10,8,,17,11,11,5,5,,13,5,8,5,,7,11,10,,8,13,10,,,,
   11,8,11,3,4,4,4,3,4,4,4,4,4,4,4,4,4,5,5,4,4,6,8,
   9,11,8,8,9,,4,4,,6,,9,,12,,8,,,,,,4,4,4,4,6,8,4,12,
   6,12,8,6,4,4,4,3,4,4,4,4,4,4,4,4,4,5,5,4,4,6,8,
   9,11,8,8,9,,4,4,,6,,9,,12,,8,,,,,,4,4,4,4,6,8,4,12,
   6,12,8,6,4,4,3,3,3,3,4,4,4,4,4,4,6,6,4,4,4,5,4,
   6,6,5,,,3,4,7,4,,4,8,6,8,5,6,,,,,6,8,4,4,4,6,8,9,
   4,9,6,8,3,4,3,4,4,4,4,6,4,4,7,8,6,4,6,7,10,6,,6,,,
   ,4,6,8,7,,6,10,9,10,10,8,,,9,,6,7,4,9,7,8,6,8,7,8,
   8,6,4,3,4,4,4,4,6,4,4,7,8,6,4,6,7,10,6,,6,,,,4,6,
   8,7,,6,10,9,10,10,8,,,9,,6,7,4,9,7,8,6,8,7,8,8,6,
   3,4,4,4,4,4,3,4,4,8,5,3,4,4,8,4,7,7,6,,,4,4,6,4,
   8,4,5,6,5,8,8,,,,,6,9,9,6,4,9,4,6,4,6,9,4,4,4,4,
   4,4,4,4,4,8,5,4,4,4,,4,7,5,5,9,,4,4,7,4,9,4,6,6,
   6,6,8,,,10,,4,4,4,4,4,8,4,8,4,8,8,4,3,6,6,7,4,7,5,
   ,,6,4,5,,6,8,7,6,,,6,7,10,4,9,6,8,9,8,,6,,,,,4,7,7,
   4,9,9,8,9,9,9,9,8,6,6,7,4,7,5,,,6,4,5,,6,8,7,6,,,
   6,7,10,4,9,6,8,9,8,,6,,,,,4,7,7,4,9,9,8,9,9,9,9,8,
   4,4,4,4,4,7,,3,4,5,6,5,6,6,,11,,4,4,6,4,7,7,6,7,
   6,6,,,,7,,5,4,4,5,5,8,8,7,5,8,7,8,4,4,4,4,6,6,4,
   4,4,6,4,6,,5,7,,3,4,6,5,11,5,6,7,6,6,,,,,,5,5,6,4,
   8,7,6,8,5,7,13,4,4,4,4,,5,4,5,4,8,5,6,7,7,15,,4,
   4,6,8,15,6,7,8,8,7,5,,,,,4,6,4,4,5,9,5,9,7,6,9,9,
   4,4,,3,4,4,4,6,4,6,6,4,,,3,4,4,4,7,4,5,6,5,,5,,,,,
   3,9,7,4,4,13,4,7,4,7,9,4,4,6,,4,4,4,7,4,,8,5,,,3,
   5,6,4,6,5,8,7,6,9,9,,,,,4,4,5,4,9,9,9,6,5,8,8,4,
   9,5,5,4,4,10,5,,6,,,,4,8,6,4,8,6,10,8,6,,4,,,7,,4,
   7,5,6,8,18,4,7,6,7,7,8,6,5,9,4,9,5,8,9,6,,,4,5,6,
   7,15,6,7,8,8,,9,,,,,5,,14,7,5,12,6,10,10,7,8,8,4,4,,
   ,5,,,,,,4,5,6,4,7,6,6,7,,,6,,,10,,6,4,8,,,,7,7,5,,9,,
   4,4,,5,,8,4,,,4,4,6,4,12,4,6,7,,,4,,,6,,4,7,4,3,7,
   9,4,7,5,9,7,4,4,9,5,11,,5,,,4,4,6,4,13,4,5,7,,7,5,,
   ,,,4,4,5,3,5,8,4,8,6,10,10,4,,5,10,6,5,10,,5,4,10,
   4,8,5,6,8,7,6,7,,,7,,6,5,4,3,18,7,8,7,8,13,7,6,,,
   11,,,,,11,,6,15,8,,12,12,12,6,,,9,,7,13,7,10,39,,8,11,
   12,15,10,9,6,6,,11,,7,6,8,6,,8,11,7,,8,6,,,6,,4,7,5,
   4,4,10,6,6,7,10,6,10,6,,,,6,7,7,6,15,8,12,9,,6,11,,,
   12,,10,19,11,7,,31,8,8,9,17,10,7,7,26,,6,6,7,7,16,6,
   6,9,,6,,,,,,14,12,15,5,8,11,,10,12,11,12,7,,,3,4,9,4,
   19,,,9,,,9,,,5,,,,4,,8,,,9,8,,7,,,12,,15,8,,8,,11,15,,8,,
   ,,,21,,165,,,,8,11,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,
   ,6,5,,,5,,4,4,4,3,7,7,4,9,7,13,7,4,7,4,,5,,8,11,,5,
   ,,10,,3,5,4,4,10,10,4,10,5,10,8,6,7,,,6,9,,12,,,,8,,
   10,5,9,4,8,8,7,12,8,,8,12,,5,7,8,11,10,6,,,,,3,4,8,
   4,6,7,6,11,6,7,11,5,,,,,,16,,,,,21,13,,60,,11,13,,,,,,6,
   7,8,7,,,,,,4,5,6,4,10,6,10,10,4,6,6,9,,12,,,,,,,5,8,
   10,,10,12,7,9,15,12,9,13,,10,9,,,9,,6,7,8,6,7,9,9,
   14,7,10,7,33,,7,,,10,,7,10,13,9,15,11,10,,17,39,12,7,
   9,,,,,5,14,13,8,12,9,7,12,11,11,,8,,,,,12,5,,5,10,7,7,
   ,6,10,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,48,,7,6,156,,50,39,
   11,,7,,,,,,,,,,,,,4,11,3,10,6,4,6,4,10,7,10,6,13,9,9,
   4,6,5,12,11,6,4,5,9,4,18,10,6,9,4,4,10,10,7,4,7,6,
   4,13,10,7,7,10,6,6,9,10,6,7,13,10,10,6,18,9,8,10,
   13,10,9,9,15,13,10,10,9,4,4,4,3,4,4,4,4,4,4,4,4,4,
   5,5,4,4,6,8,9,11,8,8,9,,4,4,,6,,9,,12,,8,,,,,,4,4,4,
   4,6,8,4,12,6,12,8,6,3,4,4,4,4,3,4,4,4,4,4,6,8,11,
   4,4,4,8,9,5,5,8,,9,4,4,8,6,,9,11,12,11,8,8,11,9,,,
   8,4,4,6,4,4,4,6,7,8,4,7,4,4,4,4,3,4,4,4,4,4,6,8,
   11,4,4,4,8,9,5,5,8,,9,4,4,8,6,,9,11,12,11,8,8,11,9,
   ,,8,4,4,6,4,4,4,6,7,8,4,7,3,3,3,3,4,4,4,4,4,6,6,
   8,4,4,6,5,4,8,6,5,,,4,4,6,6,,4,7,6,7,5,6,8,,,,4,4,
   2,7,7,4,4,10,7,10,4,4,4,4,3,3,4,4,4,4,4,5,8,4,4,
   4,6,4,6,6,7,,,4,4,5,4,,4,6,6,6,6,5,8,8,,,9,6,6,9,
   4,4,4,4,8,6,8,4,3,4,4,4,6,4,6,7,,8,4,4,7,,5,8,6,
   10,,,4,6,10,4,,6,,9,,6,,8,,,9,7,6,6,7,7,4,9,7,7,8,
   6,9,4,4,4,6,4,6,7,,8,4,4,7,,5,8,6,10,,,4,6,10,4,,6,
   ,9,,6,,8,,,9,7,6,6,7,7,4,9,7,7,8,6,9,4,4,5,4,5,4,
   ,6,4,4,4,6,4,8,6,8,7,9,4,5,6,4,,4,5,6,5,,4,6,9,,
   8,6,5,5,6,7,6,5,9,7,9,6,5,4,4,4,4,4,3,,3,4,4,6,
   4,5,3,,6,,3,3,5,4,,7,5,7,4,5,6,6,7,,,7,4,3,9,4,4,
   5,5,5,7,4,17,4,4,4,4,6,6,4,4,4,5,4,7,,6,12,,3,4,
   6,5,,5,5,7,6,6,,7,11,,7,6,4,5,4,4,4,5,5,6,8,8,4,
   4,4,4,,5,4,4,4,8,4,4,7,7,13,8,3,4,6,8,,6,5,8,6,6,
   5,,6,,,5,4,4,4,4,6,4,7,6,6,5,5,4,4,,7,4,4,4,6,4,
   6,6,5,,12,4,4,6,4,,4,6,6,6,,5,5,7,,7,4,5,5,4,4,6,
   4,8,4,7,6,5,4,5,,4,4,4,10,4,,5,10,,,4,5,8,4,,5,6,
   7,6,7,7,4,15,,9,4,4,4,6,6,4,4,5,4,9,5,5,5,9,4,4,
   4,11,4,7,4,7,,8,4,8,6,4,,6,10,8,6,7,4,7,8,,,5,6,4,
   7,6,7,4,6,6,7,4,7,6,3,7,4,7,5,9,3,,,11,4,4,,,,,,,6,
   ,6,,7,,,8,,6,4,4,10,4,,,7,,,5,4,7,7,8,,9,,14,25,4,5,
   8,4,,10,10,10,6,8,6,9,15,,,14,7,5,,8,9,5,7,5,10,8,
   9,4,4,,4,,3,6,,6,4,4,6,4,,4,6,7,6,6,4,4,,,5,4,5,3,
   4,9,7,4,4,5,13,4,4,4,7,4,5,,8,8,13,4,4,7,4,,4,6,7,
   ,8,5,5,,,4,6,4,4,4,4,5,4,9,6,9,9,5,7,4,9,5,11,8,,
   5,4,10,4,,5,6,8,,6,,4,,,5,7,4,4,6,7,5,6,8,6,18,4,5,
   ,,,,,13,6,8,6,6,,8,6,,12,11,,8,,,10,9,14,7,10,16,,10,
   11,12,12,7,13,8,5,,,,7,4,11,3,,8,9,7,10,6,4,10,12,,
   12,7,4,3,4,4,7,4,7,10,11,4,11,6,7,25,14,5,9,9,4,,
   5,11,8,8,9,6,4,,,11,9,5,5,8,,14,7,5,5,12,6,7,7,11,,
   4,4,,,,5,,,,,,6,,,5,10,4,6,4,4,8,,,,,7,5,13,,8,6,,6,,,
   11,,,,,9,,,,,10,7,16,10,9,14,,6,11,7,5,,8,,,7,,8,,13,11,
   ,7,,,,,8,,,205,,,8,9,8,29,,,6,6,,8,,,11,,9,9,,,,,,,8,,,
   205,8,,12,9,,27,,4,,4,,5,6,7,,8,4,7,,,7,4,3,4,4,7,4,
   3,7,9,9,4,6,9,4,,5,,8,11,,5,7,,,10,4,7,4,4,4,5,3,
   5,7,8,4,7,,,,6,,,11,,,,,19,13,9,7,10,13,7,10,39,14,,8,
   15,,5,,8,8,5,5,,10,,8,4,3,6,6,5,4,3,18,17,7,8,5,,,,,,
   ,,,,,,,,,,,,,,,,,10,7,6,6,,10,11,,12,7,6,4,10,7,5,4,4,
   7,10,6,10,,12,,,,,,,6,10,7,,10,8,8,31,19,10,7,13,11,9,,
   ,15,,,9,10,8,84,8,7,6,7,84,10,8,8,6,,10,,,8,6,4,10,
   5,19,11,7,,13,12,8,8,7,7,26,,11,7,5,14,9,12,15,5,8,
   7,11,,10,6,,,15,7,3,,8,,4,,8,6,,,6,12,,,5,4,13,14,7,
   8,8,,18,7,9,16,,12,,60,21,13,,165,,,51,,8,21,,,,,,,,,,,,,,,
   ,8,,8,65,,76,94,11,8,,4,11,6,6,4,4,6,7,18,7,6,3,13,
   11,4,2,7,7,7,10,4,4,4,11,3,10,13,6,4,,4,6,11,9,6,
   6,4,7,6,13,9,6,9,4,6,4,5,4,9,4,7,4,4,10,10,,7,13,
   10,13,11,15,7,9,11,5,4,3,4,4,3,4,4,4,6,4,4,7,6,,4,
   6,7,,6,6,8,10,,,4,6,10,7,9,5,8,9,8,,,,,,,8,6,4,7,9,
   6,7,7,9,7,6,7,4,3,3,3,3,4,4,4,4,3,4,5,6,4,4,4,8,
   8,6,5,8,6,6,4,4,6,4,6,8,7,4,7,8,,6,6,6,6,4,4,4,
   4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,6,4,4,7,6,,4,6,7,,
   6,6,8,10,,,4,6,10,7,9,5,8,9,8,,,,,,,8,6,4,7,9,6,7,
   7,9,7,6,7,4,3,4,4,4,4,4,4,4,6,6,4,4,4,8,4,5,7,7,
   10,,4,4,5,4,5,4,5,6,5,8,,6,5,9,9,8,8,8,8,4,4,4,4,
   4,4,5,4,4,3,6,6,5,4,5,6,,8,6,3,6,,5,,,8,10,8,6,5,
   8,6,10,5,8,6,8,,,8,8,10,10,7,7,7,7,7,7,7,7,7,7,7,
   7,4,4,4,4,4,4,5,6,5,4,4,5,6,6,5,6,6,9,,4,4,8,4,
   8,6,7,4,7,6,,5,,,7,6,4,4,6,4,4,6,5,4,4,4,6,6,6,5,
   4,5,6,,8,6,3,6,,5,,,8,10,8,6,5,8,6,10,5,8,6,8,,,8,
   8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,6,,4,4,
   7,6,7,5,6,,6,,4,4,8,6,8,7,,7,6,4,,,,,,12,4,4,6,8,5,
   ,7,6,6,5,10,4,4,4,4,4,4,4,5,5,4,4,6,,7,7,,4,4,8,
   7,8,7,6,6,8,7,,6,8,,,6,5,6,5,5,5,6,6,8,6,8,4,4,3,
   4,,5,4,6,5,9,6,5,,,7,8,4,3,5,4,7,4,6,4,9,5,,,6,8,
   8,5,6,4,4,5,5,4,5,6,5,5,5,4,4,,6,4,4,4,7,4,10,10,
   6,,6,4,5,6,5,,4,8,5,8,,,4,8,,7,4,6,12,4,4,7,4,6,5,
   7,17,5,4,5,,5,3,5,5,4,,5,6,7,7,4,6,9,5,6,6,9,5,5,,
   ,4,7,7,7,4,4,5,6,6,5,5,5,5,5,4,4,6,6,7,4,6,10,7,
   8,6,8,,6,3,5,8,5,10,4,10,5,8,,,,10,6,,4,13,4,13,7,,
   5,8,8,8,5,17,4,5,6,5,6,6,,9,9,,7,4,4,,,,4,,4,,,,,7,,
   ,4,,6,6,5,,5,,,6,7,5,4,4,,,,,5,,8,,4,3,,6,7,9,9,7,,
   9,,,,,,6,6,4,,,6,,6,6,,7,,4,5,,7,,8,7,,6,4,4,,4,6,4,
   8,4,7,7,,4,,9,8,4,12,4,4,14,17,4,7,4,19,7,7,5,6,6,
   5,,6,7,7,5,3,5,5,8,4,5,5,,4,,,6,6,6,6,5,5,4,5,4,
   4,5,6,5,5,4,,7,7,10,,6,,7,5,10,6,,7,8,8,,5,,6,,9,,
   13,5,5,8,6,6,17,8,7,7,6,6,,,9,,,,7,6,8,5,,4,7,8,9,,
   ,6,35,7,,6,24,4,7,12,,5,8,8,10,7,9,6,12,,8,9,7,4,
   9,5,9,4,9,7,9,4,,9,10,6,10,7,7,4,7,7,7,7,7,6,7,5,
   7,10,8,28,10,8,6,6,7,11,12,,9,10,9,,,,,16,6,10,6,7,,
   8,9,9,7,14,10,8,,13,,6,6,8,8,13,7,6,6,,,,9,12,,11,
   12,9,12,6,10,9,,7,7,10,6,6,,,8,6,11,8,,9,11,11,6,6,,
   9,16,11,,,7,6,12,8,11,,16,12,10,8,26,7,7,7,7,,7,4,
   12,8,,,,,,,,5,,96,38,104,,5,8,7,,75,42,8,6,,,6,6,10,,,7,
   ,9,,,,,6,21,68,,7,,,,,,48,4,,5,,7,7,7,,8,,8,,8,9,4,4,
   4,4,7,7,4,19,14,19,5,4,6,5,7,6,,5,5,,,4,8,7,7,4,5,
   4,4,5,5,4,5,5,6,6,6,8,48,,,11,,11,,,,,17,9,6,9,9,12,
   8,8,11,8,,11,7,,7,,4,9,10,,6,10,,8,6,5,7,6,6,6,6,7,
   6,6,20,6,6,48,,,8,,,,,,9,6,61,135,90,9,8,,,,203,29,9,
   7,10,6,,6,9,11,11,7,4,7,7,7,5,7,7,7,7,6,7,,10,,,,
   12,18,,7,9,7,,10,10,11,15,25,11,9,19,10,7,,,9,9,,6,7,
   6,7,9,7,7,,14,10,6,19,7,,9,48,14,8,9,9,9,6,25,10,7,
   ,26,11,9,11,,,13,,9,5,12,24,7,12,10,4,8,8,8,,5,,,,,,,,,
   ,,,,,,,,7,,,6,,6,,,,4,,,,6,,6,10,61,135,9,6,,,37,,,,,7,8,
   42,,,,9,,,,,,,7,30,,,,,,,,,,7,,4,8,6,9,5,6,6,7,21,7,9,
   6,8,9,7,4,6,5,7,10,10,4,5,9,4,21,9,6,7,4,7,9,8,7,
   12,6,5,6,11,9,11,7,7,6,6,5,5,6,11,11,6,7,6,21,9,
   10,7,,9,13,8,20,8,5,7,5,4,4,4,4,3,4,4,4,4,4,6,8,
   11,4,4,4,8,9,5,5,8,,9,4,4,8,6,,9,11,12,11,8,8,11,9,
   ,,8,4,4,6,4,4,4,6,7,8,4,7,4,4,3,4,4,4,6,4,4,7,6,
   ,4,6,7,,6,6,8,10,,,4,6,10,7,9,5,8,9,8,,,,,,,8,6,4,
   7,9,6,7,7,9,7,6,7,3,4,4,4,4,4,4,4,6,8,,4,4,6,,9,
   8,11,,,,4,4,8,4,,9,,12,5,5,8,,,9,,12,8,8,12,4,4,6,4,
   6,4,7,6,4,4,4,4,4,4,4,6,8,,4,4,6,,9,8,11,,,,4,4,8,
   4,,9,,12,5,5,8,,,9,,12,8,8,12,4,4,6,4,6,4,7,6,3,4,
   4,4,4,4,6,5,7,4,4,6,6,4,6,8,6,,,4,4,5,6,,4,8,6,8,
   6,5,7,,,,10,4,4,10,4,2,7,7,4,4,4,7,4,4,5,4,5,4,,5,
   4,5,4,4,4,6,8,6,,9,4,5,8,4,8,4,6,6,6,,6,5,9,7,,9,
   6,6,9,5,5,7,6,5,6,5,7,4,4,4,4,4,8,,3,4,5,4,5,4,5,
   ,,,3,3,8,4,7,7,7,7,4,4,6,6,6,8,,9,4,4,7,3,4,7,4,
   6,4,3,9,4,4,4,4,6,6,4,4,4,4,4,3,,6,,,3,4,6,4,5,4,
   4,7,5,3,,6,6,,,13,4,7,4,4,3,9,4,4,4,10,5,4,4,4,,
   11,4,5,4,5,5,4,9,9,,,3,4,6,8,10,4,7,8,5,4,8,,6,,,
   8,4,5,5,3,4,4,4,7,4,7,7,4,4,,6,4,4,4,5,4,6,6,6,,
   7,4,4,5,4,7,4,5,6,7,,7,6,12,,,7,6,6,8,4,5,5,4,5,
   4,5,5,4,8,,4,4,4,5,4,,6,7,,,4,4,8,4,4,4,5,7,4,7,
   7,6,13,,,9,9,5,9,4,4,4,4,5,6,4,6,6,10,5,4,4,5,5,,
   4,,,10,4,8,6,4,8,6,,8,4,,6,,8,10,,7,8,4,18,3,6,5,6,
   5,5,6,17,6,6,7,6,7,6,,9,11,,26,5,6,,7,11,6,7,9,8,,
   11,,9,,,11,,15,8,5,14,12,9,10,7,5,,6,6,,,6,,8,,,,4,6,,
   6,8,10,10,11,6,6,12,12,9,16,,31,8,11,,7,10,19,5,8,6,
   17,13,4,4,,5,,7,6,,11,4,4,6,4,7,4,7,7,6,6,5,5,,12,,
   8,8,4,5,5,5,4,4,4,6,4,6,4,7,5,5,,8,,15,4,4,10,4,
   9,4,4,7,,5,10,6,,,,9,5,4,5,4,4,6,6,5,4,4,4,,5,5,9,
   10,,,4,4,11,4,5,4,4,8,7,4,7,6,,8,,18,4,5,8,6,4,7,
   6,5,9,4,6,,,6,,,,6,5,,4,15,4,6,,6,6,,,,8,,,,4,8,,,,8,
   6,7,3,,5,5,,,11,7,6,,6,12,8,10,7,10,,8,10,,8,,10,6,
   5,4,4,4,7,10,10,7,6,7,6,,,,3,7,7,4,5,5,6,,9,3,,,,11,
   ,,7,8,,,6,4,4,5,10,4,,9,,,5,4,7,7,11,8,4,8,,9,,11,
   14,134,,12,6,14,5,7,5,,8,7,9,5,5,,,5,6,,6,19,11,,,8,,
   6,6,,,,,8,7,39,10,7,13,10,15,13,9,14,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,7,6,,8,12,12,12,15,15,7,,,,,,,8,,,,21,,13,21,,60,
   51,4,,4,,4,6,7,,3,6,5,,6,,7,4,4,5,5,3,4,9,17,7,4,
   5,7,4,,4,,8,5,,8,5,8,13,,6,5,6,7,4,4,4,4,5,5,4,6,
   7,,,9,,,,,11,,13,,11,7,9,,14,7,10,16,5,,10,6,,4,7,8,9,
   5,11,10,8,,,7,4,7,6,4,4,6,7,7,5,7,6,12,,,,,10,,,,,11,
   8,65,76,,8,8,,,,,94,10,7,8,5,,9,,,,11,4,7,7,4,3,4,4,
   11,7,4,10,,9,,8,,,,,7,9,8,,8,13,7,14,16,6,7,18,10,,,,,
   13,,10,8,7,7,6,8,8,84,8,9,10,84,6,7,10,29,14,,10,8,
   9,7,5,5,8,,9,14,10,5,7,,11,,,7,,10,,4,6,4,4,,8,,,6,
   13,,,12,7,,11,10,7,16,10,13,9,14,12,11,,,10,7,8,31,8,
   7,10,,13,6,10,19,,,,27,8,12,,,205,,,,8,9,,33,,,11,20,,,
   205,,8,,13,,,,,,,,,,,,,9,9,13,10,6,9,6,11,18,13,11,4,10,
   10,4,4,4,5,7,10,15,5,4,11,6,6,7,4,4,4,4,10,9,9,13,
   6,7,7,3,13,11,,4,2,4,4,4,,11,3,13,4,6,6,11,8,7,6,
   13,9,6,4,7,4,7,7,4,3,4,4,4,4,6,4,4,7,8,6,4,6,7,
   10,6,,6,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,6,7,4,9,7,8,
   6,8,7,8,8,6,4,3,4,4,4,6,4,6,7,10,10,4,4,7,8,6,6,,
   8,9,,4,6,,7,,6,,9,6,8,10,10,,,,8,8,8,8,6,4,7,9,6,6,
   7,7,4,3,4,4,4,4,4,4,8,7,4,3,4,,8,5,6,6,6,6,4,4,
   8,4,6,8,6,4,6,5,8,7,6,6,6,4,4,4,4,4,4,4,4,4,4,4,
   4,4,4,4,6,4,6,7,10,10,4,4,7,8,6,6,,8,9,,4,6,,7,,6,
   ,9,6,8,10,10,,,,8,8,8,8,6,4,7,9,6,6,7,7,4,4,6,4,
   6,4,,7,4,6,4,6,4,5,5,8,6,6,4,6,8,4,6,4,7,4,7,,6,
   7,6,6,6,5,6,6,5,6,6,6,5,6,5,6,6,4,4,4,5,5,8,,4,
   4,7,7,7,4,5,,6,,3,4,5,6,,7,8,7,6,5,10,10,7,8,,17,
   4,4,14,4,4,12,6,6,5,4,,4,4,4,4,10,10,4,4,4,6,4,6,,
   7,6,,4,4,6,7,7,7,6,6,5,6,,5,6,,9,7,4,12,4,4,4,6,
   8,4,5,,5,5,3,5,,5,4,6,4,6,6,4,6,6,7,7,4,3,4,5,7,
   4,6,5,6,6,5,,4,6,6,4,4,5,5,4,6,5,6,4,5,4,4,4,5,,
   6,4,4,4,7,4,4,4,4,,7,4,5,4,5,8,4,8,5,6,,7,8,7,,8,
   5,6,6,5,5,6,5,5,4,5,6,4,5,5,,4,3,4,6,4,,5,5,7,7,
   4,6,9,5,6,6,6,5,5,,,4,7,8,7,5,5,5,6,6,4,4,5,4,5,
   4,4,10,7,7,5,6,,7,,5,,,6,6,5,6,5,,5,11,5,,8,7,8,7,
   10,,6,17,5,6,8,13,5,8,6,4,5,7,10,6,,6,,12,5,9,9,,
   13,5,6,6,8,11,6,8,10,,,11,,7,11,13,9,,12,10,6,12,9,
   10,6,8,10,8,5,5,8,8,6,,,,10,28,6,6,9,,12,10,10,,8,,
   6,10,8,,,8,9,6,,7,6,10,9,6,8,10,,4,4,,7,,6,6,,6,4,
   4,7,4,9,4,5,6,10,10,6,6,,6,7,5,,4,8,6,12,4,4,5,7,
   4,4,4,,6,5,,9,8,7,5,3,5,5,7,4,4,5,,5,6,6,7,7,6,5,
   4,4,5,4,5,6,6,4,5,5,4,8,7,6,6,10,6,,7,4,10,6,9,7,
   ,8,8,6,8,,,6,9,,5,4,7,13,4,13,7,8,,5,8,,,9,,,,10,5,,
   7,,6,10,,6,11,8,,,11,16,11,,6,8,12,,7,9,9,13,6,9,,6,,
   9,8,7,4,6,5,11,4,7,7,10,6,6,10,7,6,7,7,7,4,7,7,7,
   7,7,7,7,4,7,4,,,8,5,6,6,5,7,6,6,,,9,9,,,7,,6,,4,,,
   6,6,5,5,,5,,6,7,,4,4,,,,,,,,5,,6,8,,7,,5,6,5,6,4,,,,6,
   ,5,,,5,4,7,6,10,6,11,7,9,6,,9,11,9,32,,5,4,12,7,6,
   24,8,,9,5,12,7,8,6,9,10,6,6,11,,,11,11,14,,,,7,,21,,
   68,,6,9,8,,67,185,7,4,11,7,7,7,10,8,8,7,,8,,,,,5,,,
   38,5,,9,,74,57,160,4,,5,,7,10,7,,8,7,8,,6,,5,4,4,6,
   12,4,4,14,,17,4,6,6,5,6,6,,5,5,,6,6,7,7,7,5,4,6,6,
   5,5,4,5,4,4,4,4,,32,,9,7,,9,,11,,,10,9,5,6,8,24,4,
   7,12,12,,5,,,7,8,5,7,10,,11,6,,,4,5,13,8,5,5,8,6,7,
   6,17,6,7,44,,,13,16,,,,,9,9,112,,248,8,7,,,,,30,10,7,6,
   12,,7,8,9,11,7,4,7,7,7,4,7,7,7,7,7,7,,10,,,,8,14,,
   9,7,7,,6,8,6,8,10,10,8,11,,10,,,8,,,9,6,7,14,6,7,6,
   14,19,9,6,19,10,8,10,28,10,12,8,10,6,9,10,6,7,,,8,9,
   6,,8,13,,11,8,10,12,10,9,12,6,10,8,9,,6,10,,,,13,6,,
   9,7,6,12,8,9,11,,9,10,11,44,10,8,8,8,6,7,6,,11,9,7,
   10,7,7,74,57,5,9,,96,38,104,,,5,,6,,67,,9,6,21,68,,
   185,7,,8,,,8,,7,112,,,30,9,9,,5,9,11,9,5,7,4,7,7,7,
   10,4,9,8,6,4,5,4,7,9,10,5,4,8,6,9,8,5,6,4,7,9,9,
   16,12,4,5,7,6,8,9,6,7,4,4,4,5,4,9,4,8,7,4,9,8,6,
   7,11,9,12,10,10,7,5,7,4,4,4,3,6,6,7,4,7,5,,8,6,7,
   5,6,6,7,8,10,,,6,7,6,5,,6,,9,,,,8,,,9,9,9,9,9,8,7,
   9,4,8,4,7,9,3,4,4,4,4,4,4,5,6,7,4,4,5,,6,6,5,8,,,
   4,4,6,5,7,6,5,4,5,6,6,7,,9,8,4,4,4,5,6,4,4,6,6,
   6,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,4,6,6,6,,,4,4,6,
   6,,4,6,4,6,6,6,6,,,,5,4,4,6,5,4,5,6,5,5,4,5,6,6,
   7,4,7,5,,8,6,7,5,6,6,7,8,10,,,6,7,6,5,,6,,9,,,,8,,,
   9,9,9,9,9,8,7,9,4,8,4,7,9,5,5,4,7,7,6,,4,5,6,11,
   6,6,6,,,,4,5,6,4,7,5,6,5,6,6,7,7,,7,,10,5,4,15,6,
   5,17,7,6,5,5,10,5,4,4,4,7,7,4,7,7,6,4,5,,6,,,4,5,
   8,6,11,6,6,5,11,6,,5,,,7,7,5,6,7,7,5,7,5,6,6,9,5,
   7,6,7,,6,5,5,4,7,5,5,8,8,,,5,6,7,7,,5,11,7,7,,7,,,
   12,12,7,11,7,7,7,4,6,7,7,4,6,6,4,7,,5,5,5,4,6,4,
   7,7,6,,,4,7,6,7,9,4,11,6,6,,6,6,,,8,5,7,6,7,7,7,5,
   6,7,4,8,5,7,6,,7,6,7,,6,,6,,,,4,5,6,4,6,5,6,6,7,8,
   8,5,,9,,6,6,4,7,7,6,6,4,6,7,5,11,9,10,6,4,4,10,6,
   9,5,9,,,4,7,5,4,7,4,9,7,5,9,5,9,,7,,7,6,6,27,6,27,
   5,7,5,5,5,6,7,6,8,5,8,6,6,7,10,,,6,5,6,6,21,6,6,,
   9,,9,,,,11,8,,7,12,8,12,6,6,6,6,6,,6,5,9,9,,,6,,,,4,
   6,7,4,11,7,7,6,6,8,10,8,,13,,8,8,5,,14,,8,5,7,8,7,
   13,5,7,,6,,6,11,,,5,5,6,4,7,4,6,5,8,8,6,4,,9,8,5,
   17,4,6,15,10,5,4,7,9,5,6,7,8,5,6,,7,,,7,6,10,7,,6,
   7,6,,7,,6,,,6,4,6,7,7,7,7,11,7,7,7,7,5,9,6,10,9,10,
   ,,6,4,10,4,12,6,5,4,6,5,6,4,,12,8,27,5,6,6,27,7,6,
   5,5,20,6,5,,,10,,,,8,7,9,5,12,6,8,7,10,9,8,7,,11,,
   12,21,7,11,12,,8,6,9,6,6,13,,6,,,,5,5,6,4,11,4,6,5,
   7,6,6,7,,6,,15,5,5,8,8,15,5,7,7,7,5,7,7,9,,,5,7,7,
   4,6,5,6,5,9,7,9,4,,11,13,,8,5,14,,8,8,5,6,,8,8,8,,,
   8,6,6,6,,11,6,7,,9,,9,,,7,12,6,7,8,12,8,,9,9,10,6,7,
   ,,6,6,8,5,8,6,10,8,10,8,9,7,,7,,,8,7,12,11,12,21,9,
   6,9,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,
   7,,6,8,5,,6,8,5,,8,5,7,6,3,6,10,5,6,9,15,15,7,6,7,
   7,,5,,7,7,,7,10,,,,7,7,4,7,7,7,5,7,7,5,6,6,6,,,7,8,
   ,9,,8,,28,8,,5,5,8,17,8,10,10,10,,12,8,,6,6,7,9,10,
   9,10,,,8,6,6,5,5,7,6,5,5,9,5,26,5,,,,,18,,,,,,30,20,,
   55,,10,14,,,80,,,7,5,8,6,,5,,12,8,8,5,4,7,15,5,7,7,
   8,6,7,6,,9,,9,,,29,,8,24,5,,8,12,6,10,10,7,13,,7,,7,,,
   ,,7,12,12,14,7,5,6,18,14,5,6,6,8,6,7,,,7,15,8,10,8,
   10,8,6,,18,10,12,7,8,9,,,14,8,8,12,9,9,12,7,,11,7,,
   8,7,,,10,19,7,,9,17,8,6,9,11,9,12,7,,11,,8,8,8,8,7,
   14,7,,26,5,6,10,,,,,,,,,,,,,,,12,,,,11,27,,124,,,13,,21,116,
   ,8,,10,,36,144,45,8,11,,6,7,20,5,7,8,6,8,9,6,12,4,
   23,7,8,,6,7,6,12,4,7,7,7,4,4,6,6,4,,8,5,7,8,13,6,
   7,8,20,23,14,20,8,6,10,6,7,6,14,7,23,7,10,18,7,,8,
   10,28,11,9,7,12,7,7,6,4,4,4,4,4,4,4,6,8,,4,4,6,,9,
   8,11,,,,4,4,8,4,,9,,12,5,5,8,,,9,,12,8,8,12,4,4,6,4,
   6,4,7,6,4,4,4,6,4,6,7,10,10,4,4,7,8,6,6,,8,9,,4,6,
   ,7,,6,,9,6,8,10,10,,,,8,8,8,8,6,4,7,9,6,6,7,7,6,6,
   7,4,7,5,,8,6,7,5,6,6,7,8,10,,,6,7,6,5,,6,,9,,,,8,,,
   9,9,9,9,9,8,7,9,4,8,4,7,9,4,4,3,4,4,6,,3,3,5,5,
   5,6,6,,5,,4,4,3,4,6,7,3,7,4,4,,,5,12,,13,7,7,9,4,
   4,7,3,4,4,5,9,4,4,4,4,,,4,4,4,4,4,8,,6,6,,3,4,4,5,
   ,5,,7,4,5,,6,,,12,9,7,9,7,4,4,7,3,4,4,7,5,4,4,4,,
   11,4,5,4,5,5,6,7,7,10,,4,4,4,8,,6,,8,5,5,11,,,,,10,
   8,10,10,4,4,10,4,6,3,6,6,4,4,,6,4,4,4,5,4,6,6,4,,,
   4,4,4,4,5,4,4,6,3,,6,5,6,,7,7,9,13,7,4,7,5,4,4,3,
   9,4,4,11,,4,4,4,5,4,,11,6,,,4,5,5,4,,5,,7,4,9,9,5,,
   ,13,10,10,10,8,4,5,5,3,4,4,7,6,11,11,5,4,4,6,5,7,
   6,7,,,4,8,4,4,,6,,8,4,7,6,7,,8,,7,11,7,11,6,8,6,4,
   5,4,6,6,,6,9,6,9,7,6,6,12,,,6,7,,,,8,,10,,,12,,,,,11,,
   39,12,7,13,12,8,8,9,14,11,5,5,7,7,8,,,,10,,6,8,,6,,
   6,6,7,,8,12,12,,15,,39,12,11,,10,13,15,9,7,8,10,9,4,
   4,,5,,6,5,,,4,4,3,4,4,4,3,7,6,6,5,6,,7,11,7,13,7,
   8,6,6,4,3,4,5,5,5,4,9,5,8,,5,,,4,4,4,4,6,4,4,7,,
   6,6,8,,,6,8,8,9,6,9,5,6,4,4,7,7,5,7,5,6,10,10,7,,
   5,4,5,4,,5,4,8,,4,,6,,10,8,11,7,7,7,8,4,18,3,6,10,
   5,8,,,11,,,,6,5,9,4,12,6,6,9,6,9,6,,,8,16,10,12,7,,
   14,,10,5,,5,5,6,6,8,,,,7,6,,6,,8,5,7,6,6,8,6,,8,,6,
   6,6,10,10,6,10,4,9,4,5,4,6,7,,,6,7,7,6,,6,,9,,9,11,
   6,,26,16,11,12,11,10,,15,8,5,7,14,12,12,7,12,,6,6,,,,
   6,,9,,8,,12,,,15,17,10,31,8,8,11,,7,7,10,19,9,8,,6,6,
   9,6,,8,,9,6,6,,6,,15,,,8,8,12,7,9,8,4,12,10,7,8,,7,,
   5,7,,6,,9,10,,9,,,,,11,,156,50,,,6,7,7,,48,39,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,,4,,5,6,7,,7,6,6,,11,7,8,7,8,7,6,4,5,
   5,6,5,4,5,7,4,,5,,8,5,,6,7,9,15,15,6,9,9,9,5,4,5,
   4,9,4,6,7,,,,3,9,,6,,,,,19,,7,,9,,4,8,,,,,8,,5,,8,5,9,
   9,10,4,,7,7,7,18,7,4,5,8,6,8,3,17,6,,,,,,,,,,,,,,,,,,,,
   13,,,6,7,5,5,,11,,11,,10,6,10,6,6,5,4,4,10,4,8,7,,6,,
   ,,,,,7,,,,6,,5,6,,4,,8,7,8,12,,,11,,10,7,9,9,9,8,7,6,
   10,6,7,7,6,,6,,,7,,9,,7,7,8,,,7,4,,5,9,7,,,15,7,8,
   12,10,6,14,5,7,8,5,,10,,,,15,15,10,,11,7,7,39,7,9,7,
   13,12,,,,12,9,12,9,7,10,10,,11,5,10,6,,,,,,,,,,13,,,,,,,,,
   11,8,165,,,98,21,,22,,,11,,13,,,60,,21,13,,10,7,13,18,6,
   10,6,10,10,12,9,13,10,9,9,6,6,9,7,11,15,10,9,9,13,
   10,10,6,9,6,10,18,7,7,8,6,6,10,4,10,10,4,4,4,6,5,
   4,4,11,6,10,4,6,10,9,7,4,3,13,17,10,15,13,7,4,6,4,
   4,4,6,4,6,7,,8,4,4,7,,5,8,6,10,,,4,6,10,4,,6,,9,,6,
   ,8,,,9,7,6,6,7,7,4,9,7,7,8,6,9,6,6,5,4,5,6,,8,6,
   3,6,,5,,,8,10,8,6,5,8,6,10,5,8,6,8,,,8,8,10,10,7,7,
   7,7,7,7,7,7,7,7,7,7,4,4,4,5,5,8,,4,4,7,,7,6,8,,8,
   ,4,4,8,3,9,7,8,7,4,4,7,7,8,7,,19,5,7,19,4,4,7,4,
   4,4,6,14,4,4,4,4,7,7,4,5,5,,4,8,,,9,,4,4,7,7,8,7,
   4,4,4,5,,8,,,6,19,7,17,7,4,4,14,4,7,4,12,5,5,3,5,,
   5,4,6,5,,6,6,6,6,7,8,4,3,6,5,7,4,4,5,3,4,6,,6,7,
   7,6,6,5,5,4,4,5,4,6,4,5,5,4,5,,8,4,4,4,,4,10,10,6,
   ,8,4,4,6,4,7,4,4,5,6,,7,8,6,,,7,17,7,6,4,12,4,4,
   5,4,6,5,5,6,,5,3,5,,4,,5,5,6,6,4,6,6,5,6,6,,5,,6,
   6,5,8,7,8,5,5,5,5,4,5,5,4,4,6,6,6,10,9,7,5,6,,7,
   8,7,8,,10,6,4,8,5,9,5,6,4,6,,5,,,,,6,20,6,7,6,7,6,
   6,6,6,5,6,7,7,,5,,6,,9,11,,13,4,5,6,,9,4,,7,9,,,,8,,
   8,8,,12,8,4,24,12,7,5,5,12,8,8,5,,,10,,10,,14,48,6,
   9,6,8,8,9,9,10,,,9,10,,,,15,9,10,,7,9,25,6,11,9,9,
   26,4,5,,7,,6,8,,8,4,4,7,4,6,4,6,6,4,4,4,6,,7,8,6,
   7,5,6,6,6,5,5,4,6,5,8,5,,6,5,,9,7,7,4,3,6,4,7,4,
   4,5,,5,5,8,7,7,6,5,4,5,5,5,5,6,6,4,4,4,5,,7,10,7,
   10,9,,7,5,,6,,7,6,8,,5,,8,,,,7,6,6,8,17,5,6,8,6,13,
   5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,12,,11,9,7,4,9,4,11,
   4,6,7,9,4,4,9,6,4,6,7,6,5,7,7,7,7,7,7,7,4,7,10,8,
   ,12,6,,,6,11,12,9,6,5,9,9,6,,13,13,10,6,9,7,,12,10,
   6,6,12,9,7,6,,,5,5,8,8,16,6,,9,,,,,10,28,11,14,10,8,
   9,9,6,,7,8,7,10,7,,,8,5,11,8,17,9,,11,,,8,,,7,48,,11,
   8,11,8,9,12,9,7,9,6,8,6,6,8,11,6,8,6,8,9,7,,7,11,,,
   ,,,,,46,,9,6,6,42,,,,6,16,10,10,10,7,9,,7,35,11,,,,,,,,
   37,9,,6,7,96,135,,4,,4,,7,,7,,6,6,,,6,8,6,5,5,7,,4,
   8,6,6,12,4,6,,4,8,6,,4,5,,9,6,8,7,7,5,5,5,5,4,4,
   5,4,5,5,6,6,8,,,9,11,,9,,11,,,,10,8,11,16,,6,8,12,26,
   ,7,12,,7,,5,6,6,10,10,6,,10,8,5,,8,5,4,7,13,17,4,
   13,6,10,,,,8,,,,,,,7,,,170,6,,,,46,,,9,7,,6,,9,9,8,9,7,
   5,7,7,7,4,7,7,7,7,7,6,,,,6,,10,,,,6,,,4,6,,,,6,,,7,4,
   8,,,8,,10,6,7,,7,6,9,7,19,6,7,14,4,,9,,,7,,7,6,6,,4,,
   ,,4,6,6,6,,7,,,6,7,,,5,6,5,6,5,4,,,7,,,,10,7,,8,5,4,
   12,7,9,6,24,8,10,12,48,9,9,10,15,11,7,8,,18,7,9,8,
   7,6,,,,,,21,,68,48,,7,,7,,75,,8,,,,38,42,6,,7,,,9,,8,61,
   90,135,27,9,6,,5,11,,21,6,7,6,7,21,7,13,11,9,9,7,6,
   5,5,7,10,20,5,5,9,11,9,6,5,7,6,7,21,11,7,13,6,6,7,
   4,9,8,6,6,4,6,5,4,4,8,6,9,7,6,9,9,12,6,6,8,14,9,
   10,8,4,7,5,6,6,7,4,7,5,,,6,4,5,,6,8,7,6,,,6,7,10,
   4,9,6,8,9,8,,6,,,,,4,7,7,4,9,9,8,9,9,9,9,8,5,5,4,
   7,7,6,,4,4,6,8,6,8,5,,8,,4,5,6,3,5,5,5,5,4,6,8,8,,
   ,,6,7,5,9,6,3,10,6,6,7,6,15,5,5,5,4,8,8,4,7,7,6,
   4,6,,6,9,,4,5,11,6,8,6,4,5,6,6,,6,,,7,9,5,10,4,5,
   4,15,6,6,5,17,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,
   7,,5,10,7,6,5,7,,,,,5,6,7,7,5,4,7,7,6,7,7,7,5,7,,
   6,4,4,4,6,4,7,7,6,,,4,7,6,7,8,4,6,6,5,,6,11,,,9,4,
   8,7,6,5,6,7,7,5,5,7,7,7,7,,7,6,7,,6,,6,10,,,5,5,7,
   4,6,5,6,6,5,8,8,7,,,,7,7,7,7,11,7,7,7,5,4,6,7,10,
   9,6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,6,,,,5,
   9,6,5,5,5,7,5,5,6,6,9,8,6,8,5,8,6,9,7,9,,,6,,8,9,
   14,6,9,,8,,9,,,,18,7,,12,,7,12,9,9,8,8,8,11,11,7,6,
   6,8,,9,,,,6,7,10,5,7,7,7,7,6,9,10,9,,,,10,12,8,,6,
   10,10,8,7,15,8,18,4,7,,6,,5,8,,,5,5,6,3,7,4,5,5,7,
   7,6,6,,,11,6,7,5,5,7,6,7,7,5,7,5,6,7,8,5,6,,6,9,,
   4,6,,4,10,6,5,6,,6,,6,,,6,7,5,6,4,6,4,7,7,11,6,6,
   6,6,6,9,10,10,12,,6,4,10,4,8,6,4,4,9,5,9,5,,,12,5,
   6,7,5,6,6,27,6,5,27,5,5,,,9,,,,7,7,9,5,10,6,7,7,10,
   9,8,9,,,,9,12,8,9,6,,17,9,7,19,7,11,11,5,,12,,5,5,6,
   3,8,4,5,5,7,6,6,7,,,,6,7,5,7,7,4,15,7,6,8,5,8,7,6,
   ,,6,8,8,5,7,6,9,7,6,7,10,6,,,,10,6,8,9,,7,12,8,7,
   12,6,9,7,11,,6,5,9,9,13,,4,5,,6,,6,,,6,,8,8,5,8,5,,
   14,8,,8,6,28,,6,7,8,5,8,6,8,8,7,6,9,7,,,,,12,8,10,
   10,5,17,8,8,,5,10,,7,12,7,7,12,6,11,,13,,11,20,,,,13,,,
   ,,,27,11,21,,100,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,4,,6,7,5,,6,
   11,6,,,7,5,5,5,7,17,4,6,15,7,10,5,6,8,7,12,5,,7,6,,
   7,11,,,,4,6,4,7,6,7,7,7,6,7,11,7,9,,,7,8,,10,,10,,,
   8,9,7,12,9,21,7,11,12,6,,8,6,,6,9,7,5,5,5,5,,,7,4,
   4,27,5,4,3,5,27,6,4,6,5,,,,,11,,,,,,8,11,,144,20,8,10,,
   ,116,,45,7,5,5,6,,6,,,11,7,5,15,7,5,5,8,8,7,15,5,7,
   ,8,,7,,,,,5,6,14,,7,8,7,8,10,8,8,26,6,,7,,,,,5,6,5,
   18,6,12,7,14,6,7,12,14,7,9,7,,,11,8,7,,5,8,5,6,,10,
   5,8,7,8,6,,,21,6,6,12,6,6,7,8,12,,8,,6,8,,,12,6,6,,
   6,8,7,12,11,13,12,21,9,,,,7,8,12,10,6,5,8,,,8,24,8,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,80,,10,,14,,,55,,30,20,,7,14,10,18,
   6,8,6,7,9,6,9,7,28,7,4,6,7,6,6,12,7,7,6,7,20,5,
   23,7,8,6,7,4,14,8,10,6,6,8,4,23,7,,8,,10,7,7,,7,4,
   6,8,10,5,7,20,8,20,23,13,12,4,12,6,8,7,8,8,5,6,6,,,
   4,5,5,5,5,7,,,9,,5,5,6,6,8,5,6,5,8,,6,6,,9,,6,6,5,
   26,5,8,31,7,6,6,5,8,8,8,8,6,,,5,6,6,,5,8,,6,,,4,5,
   5,5,7,5,8,7,8,,,9,,,,9,9,31,7,8,5,7,6,5,5,9,8,6,4,
   6,,8,5,6,4,9,6,5,9,9,9,10,5,4,4,7,10,4,6,7,9,,7,,
   4,10,10,7,7,7,7,6,7,7,6,7,4,6,6,8,6,,9,8,8,6,,5,
   11,11,4,,8,5,6,4,6,9,5,6,5,9,,,6,8,,9,7,11,7,5,8,
   7,8,5,7,7,11,7,6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,
   9,5,6,,,6,10,9,10,7,7,7,6,7,6,6,4,6,7,7,7,,11,5,4,
   4,5,5,7,6,7,,7,6,7,4,4,8,4,9,7,6,,4,,7,,,5,6,6,6,
   6,28,8,5,7,4,6,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,
   6,,11,,11,14,8,9,,6,11,,,8,8,,9,11,,15,,41,11,10,,8,
   11,12,7,9,8,15,18,8,6,,5,,8,5,,,8,8,6,6,,5,9,7,,,,8,,
   ,7,5,7,5,6,7,31,8,7,8,9,9,5,6,,6,7,,6,8,6,5,4,5,
   5,7,3,6,5,,,4,6,9,9,6,5,6,6,4,6,6,6,5,6,7,7,6,,5,,
   ,6,9,,5,4,6,4,6,5,6,5,,,,6,,9,,6,6,8,5,28,8,28,5,
   6,8,6,6,,,,,,,6,7,6,4,9,,6,5,9,,,9,,8,,,8,7,7,,,,,6,,
   6,8,6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,5,5,6,7,7,
   8,8,7,5,7,6,7,11,7,82,13,,9,9,6,9,9,6,,11,,,6,,17,
   13,12,15,10,8,,13,11,11,10,,12,12,9,17,,7,5,7,7,13,6,
   6,,,,,6,13,82,9,,12,13,11,11,10,,8,12,12,15,10,10,,6,
   4,7,4,,6,8,7,,,6,10,11,7,44,,7,6,8,10,8,12,8,7,8,7,
   8,9,9,10,7,,10,6,16,8,15,,8,10,,,,10,,,,,,,,10,37,,,6,
   4,11,6,7,7,7,8,,,,13,,,,,7,72,75,141,10,,6,7,,60,47,8,
   ,5,,5,6,5,,,5,6,,9,8,6,5,8,7,31,5,5,26,7,6,6,6,9,
   6,10,6,,7,8,,9,6,10,9,10,4,6,7,6,7,7,6,7,6,7,7,7,
   7,44,,10,7,,,,8,,10,,8,7,8,8,12,6,10,8,8,,7,7,,5,,7,
   11,,5,9,7,,8,4,6,28,5,8,6,6,6,10,5,6,7,7,12,,,,8,,,,
   ,7,,,51,27,10,8,,,53,49,,,5,6,,,5,7,7,8,7,6,8,7,8,6,
   7,7,7,5,5,5,,11,,9,,13,10,,7,7,8,,9,11,9,12,12,,7,,8,
   ,5,,8,8,,6,5,7,29,8,7,8,29,6,6,5,6,,,,14,11,11,8,
   15,11,7,12,10,8,,18,41,11,9,,,,,,,,,,,,,,,,,,6,,,9,,6,,,,
   7,9,7,8,,,6,7,16,12,,7,11,12,9,8,9,,,7,11,11,9,7,,
   60,10,,,72,141,75,47,,7,7,10,,,,,,,,,,10,,10,53,49,10,,,,,
   51,,7,,,7,19,15,14,6,7,4,7,7,7,9,10,11,10,7,6,6,6,
   6,24,7,7,6,10,33,14,10,6,7,6,7,14,9,6,9,4,6,7,33,
   10,9,33,7,6,5,6,7,6,19,10,10,7,5,14,10,33,7,15,11,
   14,9,19,10,7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,
   4,5,4,4,4,4,4,,,4,,,,4,7,7,4,4,,4,4,4,10,10,4,4,4,,
   ,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,7,
   7,4,4,,4,4,4,10,10,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,
   3,3,3,3,3,,4,4,3,,,5,5,5,5,3,6,8,3,3,3,6,8,3,5,,
   4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,7,7,
   4,,4,7,7,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,
   5,4,3,4,4,4,5,5,,7,7,4,,4,7,7,4,4,4,4,,,3,4,4,4,
   4,5,3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,11,,9,7,4,7,,5,4,
   4,9,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,
   3,2,3,3,3,3,3,3,3,3,,3,,6,6,3,5,5,6,6,3,3,6,3,8,
   4,4,4,3,,,4,,3,2,3,3,4,3,3,3,,3,4,4,4,4,,6,3,4,5,
   4,3,8,3,3,4,4,7,,3,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,
   4,,4,,6,5,4,7,7,5,6,5,5,10,4,10,,,5,,,,4,3,5,3,5,4,
   4,4,4,3,4,4,,4,,,7,4,7,9,,8,4,5,9,4,11,5,5,,5,,4,
   3,5,3,5,4,4,4,4,3,4,4,,4,,6,5,4,7,7,5,6,5,5,10,4,
   10,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,,5,,8,9,4,11,,8,8,
   4,4,7,5,,,5,,3,3,4,4,5,4,4,4,,4,,,5,9,,17,4,6,7,5,
   5,,5,4,5,6,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,
   4,4,7,5,5,,,,8,,11,,7,,8,4,4,11,10,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,3,,3,,4,4,4,,3,4,4,,3,,6,3,3,6,6,3,6,6,6,6,3,7,
   4,3,4,4,,4,3,,4,4,4,4,,5,4,3,6,3,4,5,4,4,3,3,8,4,,
   ,3,,,4,,,,5,,8,4,5,,7,4,8,8,9,,4,10,,4,4,4,4,4,6,6,
   3,,,5,3,6,6,3,3,8,6,5,3,6,7,,9,,,4,,,,,,8,4,11,,13,
   4,8,,,11,15,24,,3,4,4,,,5,5,,7,4,5,6,5,4,7,7,7,5,5,,
   ,4,,,,5,5,,7,5,5,,5,5,7,6,6,4,4,14,4,4,,,5,5,,7,4,
   5,6,5,4,7,7,7,5,5,,3,4,4,8,4,,8,4,4,6,6,3,6,,6,4,
   4,7,4,4,4,,,5,5,6,12,4,5,5,4,4,3,,8,3,5,,,10,5,,6,
   4,4,16,,9,5,9,13,5,,,10,5,,6,4,4,16,,9,5,9,13,4,,,
   11,4,8,,15,,11,13,,4,11,,,11,,8,4,10,,11,7,4,,11,,,,,,,,,
   ,,,,7,16,6,7,6,,6,7,9,20,,4,16,7,4,6,3,4,5,6,12,7,
   4,6,12,5,7,3,4,8,7,20,,9,7,6,6,,4,24,5,6,4,3,8,7,
   4,3,7,6,16,7,6,7,16,8,4,6,7,27,5,4,24,4,10,10,4,4,
   4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,
   7,7,4,4,,4,4,4,10,10,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,
   4,4,4,3,4,,,4,5,,5,7,7,,4,4,7,7,4,4,4,,4,4,,,4,4,
   4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,7,7,,4,4,7,
   7,4,4,4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,3,3,3,3,4,3,
   3,4,,4,3,,,6,6,6,5,3,5,6,3,3,3,8,6,3,4,4,4,4,4,,,,,
   ,3,4,4,4,5,4,4,4,4,,,,5,,,7,,7,,4,9,10,5,4,5,9,9,
   4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,7,,7,,4,9,
   10,5,4,5,9,9,4,4,,3,,,3,,,3,3,3,3,3,3,3,2,4,4,,3,,,
   3,6,8,5,3,5,5,5,3,3,6,8,3,3,4,4,5,,5,5,,4,3,5,4,
   5,4,3,3,,4,,4,,,4,,4,7,4,7,4,,4,4,10,10,4,4,4,5,,5,
   5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,7,4,7,4,,4,4,10,10,
   4,,,,,,,3,3,3,3,4,3,3,3,4,4,,4,8,,4,8,6,5,4,6,,8,3,
   4,6,8,4,3,,,4,,3,2,3,3,4,3,3,3,4,3,,4,4,,4,8,4,5,
   4,4,4,8,4,4,4,7,4,,4,,,3,4,4,4,4,4,4,3,5,3,,4,,,5,
   8,8,11,4,,9,7,4,4,7,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,
   3,4,4,5,4,4,4,5,4,,3,5,,9,,5,7,6,5,4,11,4,5,5,10,
   6,,3,4,4,4,4,4,4,3,5,9,,5,,,,8,,,9,7,,8,4,4,15,,9,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,6,3,6,3,6,
   3,5,5,8,6,7,3,4,4,4,4,,3,3,,,3,4,,4,5,4,6,3,3,4,
   5,4,4,3,8,3,,,,4,4,,5,,5,,,5,8,4,,5,7,4,7,9,8,,10,4,
   ,3,4,4,5,5,,5,5,,5,7,4,6,5,5,4,7,7,7,5,,5,,8,,,5,,,
   ,,,8,4,,9,11,4,8,,,7,,11,4,4,5,5,,5,5,,5,7,4,6,5,5,
   4,7,7,7,5,,5,,3,,,,4,,,5,4,8,,3,4,6,5,6,4,10,6,3,3,,
   ,3,,,6,3,6,6,3,3,6,5,6,3,7,6,4,,4,,,4,,5,8,4,9,4,
   11,,7,8,10,4,,4,5,,5,7,6,17,4,4,6,7,5,5,5,,5,,,,,,,,,,
   ,,,,,,,4,,,,5,8,9,4,4,8,,7,4,10,8,,4,,9,8,4,,11,,7,9,
   ,11,4,,,,,,,,,,,,,,,10,8,,4,8,,8,9,4,11,,7,,21,9,6,,6,
   7,7,,8,21,5,6,4,6,3,4,6,12,5,7,7,16,6,7,24,6,,6,4,
   4,9,6,7,3,8,4,4,16,7,5,4,8,3,7,4,3,6,12,5,7,6,20,
   ,21,4,4,24,6,6,11,8,10,4,10,4,3,,5,4,4,3,5,4,4,4,
   4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,7,7,4,,4,4,4,4,
   7,7,4,,,3,3,3,3,3,,4,4,6,6,2,3,3,3,4,3,3,3,3,4,4,
   ,4,6,6,4,4,4,4,3,4,4,3,3,3,4,4,,5,4,4,3,5,4,4,4,
   4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,7,7,4,,4,4,4,4,
   7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,,,,7,,3,3,
   4,4,5,4,4,4,4,5,3,,4,,,12,5,,,4,5,6,4,4,4,8,8,4,3,
   ,4,,4,4,,4,3,3,3,3,4,2,3,3,4,4,3,,,4,4,3,8,4,4,5,
   6,3,3,3,5,4,4,4,,3,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,
   4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,4,6,6,4,,3,2,
   4,3,4,3,3,3,4,3,4,,,4,4,8,3,4,4,5,3,6,3,3,7,4,4,,,
   ,,,6,4,3,4,4,6,3,4,4,3,5,4,,8,5,5,5,7,5,5,6,,4,4,
   5,6,5,5,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,
   4,4,4,5,5,5,5,4,4,4,4,4,10,6,3,3,3,3,4,3,3,3,4,
   4,4,,,6,6,4,6,4,4,,6,4,3,3,6,6,6,3,6,,4,3,4,4,6,
   4,4,4,,4,,,6,10,10,,5,7,7,6,5,,5,5,6,7,7,6,,4,3,4,
   4,6,4,4,4,,4,,,6,10,10,,5,7,7,6,5,,5,5,6,7,7,6,4,
   6,4,5,6,4,7,5,6,,5,,,,,5,,,,8,,5,5,5,14,,,4,4,6,5,6,
   6,5,5,6,5,,,,,,,5,,,14,5,,5,5,11,,,3,,4,,3,4,4,,3,3,,,
   4,4,3,3,4,4,5,3,3,6,8,5,4,4,3,4,6,3,,4,3,,3,,4,6,
   6,3,4,4,4,3,4,3,4,4,3,4,4,4,10,,4,4,,3,,,,6,6,4,3,
   6,6,6,3,4,6,6,,4,4,,4,,3,5,5,5,,4,,,4,4,7,7,4,4,4,,
   ,4,7,7,6,,,,7,7,,,,,5,5,,,9,5,5,,,8,,,4,4,3,3,,,4,6,
   6,4,3,6,6,4,3,4,4,4,4,6,6,,5,,5,,4,,,4,5,,,4,5,4,
   6,12,4,8,8,5,5,5,,4,,,4,4,7,7,4,4,4,,,4,7,7,4,4,,
   8,5,5,5,5,5,5,6,4,4,,7,6,5,5,4,,4,,,4,12,8,8,4,6,
   4,5,5,4,,,,4,,,12,4,,,4,4,6,5,5,4,8,8,,,,,,,,,,,,,,,,4,
   4,12,8,4,4,,10,12,6,10,,4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,
   ,4,8,8,5,4,6,4,4,5,13,13,8,8,5,6,4,4,4,5,8,8,3,
   4,13,7,7,13,3,4,4,4,13,7,7,13,3,4,4,4,6,6,5,3,3,
   3,4,4,4,6,7,7,4,4,5,8,8,6,4,13,13,5,8,8,4,4,3,4,,
   ,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,7,7,,
   4,4,7,7,4,4,4,,4,,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,
   3,5,4,4,,4,,4,,,4,,7,7,4,,4,4,4,4,7,7,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,,,,3,4,4,4,4,4,4,3,4,,6,
   5,5,,,9,7,11,,4,8,8,4,4,5,,7,3,4,,4,,,4,,5,4,4,4,4,
   5,3,4,3,,,4,4,,,4,4,,7,4,7,,4,4,4,7,7,4,4,,4,,,4,,
   5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,7,4,7,,4,4,4,7,7,4,
   4,3,6,6,4,,,3,3,4,3,3,3,3,2,4,,4,3,,,3,5,6,6,3,5,
   6,6,3,3,8,6,3,,,,,,5,4,4,4,4,5,3,4,3,6,,4,5,9,,5,
   4,11,7,5,6,,5,5,4,6,7,5,4,4,,,4,3,3,3,3,4,2,3,3,4,
   ,3,4,4,,4,4,8,5,4,4,8,4,4,4,4,5,4,3,4,,,4,4,4,4,
   5,4,4,3,,,,4,,,5,9,10,7,4,,7,,4,5,9,10,5,4,,,4,4,4,
   4,5,4,4,3,,,,4,,,5,9,10,7,4,,7,,4,5,9,10,5,,,3,3,3,
   3,4,3,3,3,4,,4,4,4,,7,,8,5,6,4,8,6,4,3,4,6,5,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,9,5,,,,,8,,7,9,8,
   ,4,4,15,,9,4,,4,,3,4,3,,,3,3,,,3,3,6,6,3,5,5,3,6,
   5,6,5,3,4,3,,4,,4,5,,5,5,5,,5,4,7,,4,4,7,4,7,7,4,,
   4,4,8,,4,3,,,,3,,,4,4,6,8,4,6,5,4,6,5,,8,3,,4,,4,5,
   ,5,5,5,,5,4,7,,4,4,7,4,7,7,4,,4,4,,,,,5,,,,,4,8,,11,
   9,8,4,,,11,,19,4,3,3,,,3,4,,4,4,5,8,4,4,5,4,4,4,4,
   8,4,,5,,5,,5,,,4,7,8,,4,8,4,8,9,5,,7,3,,3,,3,,,3,6,
   6,5,3,6,3,8,5,3,6,6,,4,4,,,4,5,,8,4,8,11,4,,7,8,7,
   4,,,,,,,,,,,,,,,,,,4,5,,5,7,7,,5,5,7,6,5,5,4,11,4,4,,,5,
   ,8,8,4,8,4,,7,4,7,8,,4,11,,8,4,,,19,11,9,,8,4,,,,,,,,,
   ,,,,,7,,8,,4,,9,15,9,4,8,,7,16,4,4,6,4,3,4,5,9,6,6,
   16,9,,6,6,7,9,,21,7,7,,21,9,9,6,,6,4,9,6,5,4,3,6,
   4,21,5,6,4,4,6,3,7,7,6,16,6,9,4,3,9,9,8,4,6,16,9,
   6,21,5,7,4,7,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,
   4,4,4,5,5,,7,7,4,,4,7,7,4,4,4,4,,,4,4,4,4,3,,6,5,,
   ,3,4,4,4,4,4,4,3,4,,,,5,,7,,,12,5,4,8,8,4,4,4,12,5,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,
   4,4,3,4,4,4,3,,5,5,7,7,4,4,,7,7,4,4,,4,4,4,4,3,,,
   3,6,6,3,3,3,3,4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,
   4,3,3,4,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,
   5,7,7,4,4,,7,7,4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,
   4,4,3,,5,7,8,8,4,5,12,,,4,4,12,4,5,,3,,6,6,3,3,3,
   2,4,3,3,3,3,3,3,3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,,
   5,8,8,12,4,5,,,4,4,5,6,4,,,3,4,4,3,4,4,5,4,3,4,4,
   4,7,5,,,,4,12,5,8,8,4,4,5,4,6,3,4,4,5,4,4,4,5,4,
   6,10,10,6,,,,,,,,,,,4,4,,,,4,4,5,4,4,4,5,4,6,10,10,6,,,
   ,,,,,,,,4,4,,,,4,,3,,4,4,3,,4,4,3,,4,4,4,4,3,3,8,4,
   4,5,5,6,3,3,,4,4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,
   4,4,5,5,5,4,8,,6,4,,,,4,,6,6,5,5,5,5,7,5,5,6,6,,4,
   4,,4,4,3,4,6,6,4,4,,4,4,4,8,3,3,4,4,5,5,3,6,3,4,
   8,,,6,6,,,,,4,4,12,12,10,4,4,,,6,10,10,,4,4,,,4,6,6,
   6,4,4,5,5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,,4,5,5,
   6,6,5,5,7,3,4,4,,4,4,,4,4,3,8,3,4,4,5,5,3,3,6,4,
   4,3,10,6,4,6,6,4,3,6,4,4,,6,4,4,3,3,4,6,,6,7,7,,
   5,5,7,7,6,6,5,,5,4,6,,6,7,7,,5,5,7,7,6,6,5,,5,4,
   6,10,6,6,4,6,3,4,4,,6,3,4,4,6,6,,,5,5,,,,8,14,,5,5,
   6,,,,5,5,,,14,8,5,,5,,,5,,5,,,10,14,5,5,,3,8,8,13,4,
   4,3,4,7,13,7,8,8,13,4,4,3,4,7,13,7,4,4,8,8,5,6,4,
   6,4,4,13,13,5,5,4,4,6,8,8,6,5,6,4,4,3,4,3,13,7,8,
   4,3,13,7,8,3,4,6,7,6,4,6,4,4,4,6,5,6,4,6,5,5,6,5,
   ,7,4,5,4,6,7,4,6,5,6,,6,,5,,,6,,11,9,5,,6,6,6,5,
   11,9,5,4,6,6,5,,6,,,,4,5,6,4,5,6,6,5,4,5,6,5,7,7,,
   11,9,6,,6,9,11,5,5,6,6,,4,4,,3,,4,,,5,4,4,4,3,5,3,
   5,4,4,4,3,4,,4,,5,6,4,7,7,6,5,5,5,7,4,7,3,6,4,4,,
   4,,4,3,3,3,3,4,2,4,3,,4,3,4,4,4,,3,6,4,5,4,8,3,3,
   3,4,4,5,6,4,6,4,6,,,3,3,4,2,3,3,4,3,3,3,3,3,,3,,
   6,6,3,6,6,6,6,3,3,8,3,6,,,6,,,7,6,5,6,4,7,4,6,5,
   6,5,4,5,,5,,6,,5,9,11,,6,6,6,11,5,9,,4,,,5,4,4,4,3,
   5,3,5,4,4,4,3,4,,4,,5,6,4,7,7,6,5,5,5,7,4,7,4,3,,
   ,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,7,4,7,,13,9,5,4,9,
   5,10,4,,,3,3,3,3,4,3,4,3,,4,,4,4,8,,6,12,6,5,4,8,,
   3,4,4,5,6,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,7,4,7,,
   13,9,5,4,9,5,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,
   4,4,5,8,5,,,,,8,10,,9,8,,4,4,13,8,,4,,3,,3,6,4,,4,3,
   4,,3,,3,6,3,6,8,6,3,6,6,6,3,5,4,4,,4,,3,4,,4,,5,5,
   ,4,7,4,,4,7,4,7,7,4,4,,3,8,,6,4,,4,,4,,4,,4,6,4,8,
   6,6,4,5,6,,3,8,,3,6,4,4,6,4,6,3,,,3,5,8,6,3,8,3,
   6,6,3,6,5,4,,,,,4,,,,,4,8,9,,13,8,4,,,7,11,,6,4,3,4,,
   4,4,4,,4,5,4,8,4,5,4,4,4,4,4,8,,6,,6,,7,7,,5,9,6,,
   6,9,5,11,11,6,6,,4,,4,,5,5,,4,7,4,,4,7,4,7,7,4,4,,
   4,3,4,8,4,,4,8,4,6,5,6,3,,6,4,4,5,4,3,5,,,5,10,9,
   10,5,16,4,,9,4,,7,4,4,,,5,5,,6,3,5,5,4,4,4,6,8,5,,,
   5,10,9,10,5,16,4,,9,4,,7,4,,9,,4,8,,,13,7,11,,4,8,,
   19,,,8,4,,9,15,11,4,,8,,,,,,,,,,,,,7,5,21,7,6,4,3,4,6,
   9,9,21,,24,,6,6,7,7,16,6,7,4,12,5,6,6,3,4,6,7,6,8,
   7,9,6,6,,5,8,6,5,4,3,6,7,7,6,24,12,,4,3,5,5,21,4,
   4,6,20,7,6,16,4,7,7,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,
   4,4,,,,5,,,7,,7,,4,9,10,5,4,5,9,9,,4,,5,,3,5,,5,4,4,
   4,4,5,3,4,3,,,4,,,9,5,5,,6,5,7,17,4,4,5,7,6,5,4,3,,
   ,,,,6,4,4,4,4,6,3,4,4,,,4,,10,10,6,5,,7,6,7,,5,5,5,
   7,7,6,4,4,6,6,6,,,3,3,4,3,4,3,3,3,4,,4,,,8,4,8,,6,
   4,5,6,12,4,3,8,6,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,10,
   10,6,5,,7,6,7,,5,5,5,7,7,6,5,6,,,6,4,3,4,4,6,3,4,
   4,,,4,,5,8,5,5,,6,5,5,9,6,6,5,5,6,5,,5,,,4,4,4,4,
   5,4,4,3,,,,,,14,7,,,13,5,,11,8,4,5,9,27,7,,,,4,4,4,4,
   5,4,4,4,,,,,,,,18,,10,7,7,18,,5,5,9,10,12,,,4,3,4,4,
   6,4,4,4,,,,,6,14,10,,,16,8,6,9,,6,4,6,14,7,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,4,6,5,6,6,5,5,6,,11,,,,,,,,15,13,10,,6,
   5,13,99,,4,,4,,3,4,4,,,3,,,7,4,3,,5,4,5,6,4,12,8,6,
   5,4,4,,,4,,5,5,,5,,5,,7,4,,6,5,4,8,4,8,,4,12,5,4,16,
   ,4,4,,,,,,10,6,4,,10,6,6,6,6,8,6,,6,4,,4,3,,5,,5,,5,,
   ,4,,16,,4,9,5,10,7,5,10,9,6,,,,,7,,,,,5,,,19,9,10,6,,,
   14,36,,4,4,3,,,,4,12,6,4,,8,6,4,6,6,6,4,4,8,6,,5,,5,
   ,5,,,4,,16,,4,9,5,10,7,5,10,9,5,,5,,4,,,4,,15,7,4,7,
   5,,11,4,15,8,,4,,14,10,6,5,,7,6,16,9,5,,7,12,7,6,,,,,,
   ,,,,,,,,,,,,,5,,,19,,,,5,9,21,7,5,4,8,8,,,,,,,,,,,,,,,,10,
   5,13,,7,5,,14,14,12,10,,7,5,,,,,7,8,,,,,9,,,13,,,,5,,,,
   13,5,,,,9,6,7,8,,4,4,6,8,8,,,,,,,,,,,,7,14,8,7,10,5,
   13,6,5,37,28,16,9,4,6,5,10,7,6,5,4,5,4,8,8,8,10,
   12,39,6,4,8,13,37,,7,8,45,7,7,7,7,5,,4,,,5,,5,,,,4,
   4,5,3,4,4,4,3,4,4,4,3,,5,,8,8,4,,11,8,9,4,4,,5,7,
   4,4,4,,,,6,10,3,3,3,3,4,3,3,3,,4,4,4,6,6,,6,4,4,,
   4,4,6,3,3,6,6,6,3,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,
   5,,13,9,4,,7,,7,4,5,9,5,9,,,5,,,,4,4,5,3,5,4,4,4,4,
   4,4,4,,5,,13,9,4,,7,,7,4,5,9,5,9,,5,,7,10,4,3,5,3,
   5,4,4,4,4,3,4,4,,4,,9,7,4,,,7,9,5,5,8,4,8,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,5,4,4,4,,,,,7,11,,11,8,13,,
   5,,,5,4,7,21,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,
   5,6,10,9,7,,,,,,19,,19,,,5,5,,,,8,8,11,7,10,10,10,9,
   12,8,,14,,,,,,,,,7,,8,9,,,,4,,3,,4,4,4,,4,4,4,,4,,5,4,
   3,,6,4,6,6,6,12,4,6,,4,5,,,5,4,,3,5,6,6,,6,5,4,,4,
   5,6,5,5,5,5,7,4,14,,,,,,,,,6,,7,6,5,,7,6,8,12,16,,5,
   9,,4,4,4,4,6,6,6,4,,,6,4,6,,3,4,5,6,5,4,12,6,10,10,
   ,,6,9,,,,,7,5,13,,13,5,7,,,12,11,17,3,,4,,,,6,6,,7,6,
   5,,5,6,7,7,7,6,6,12,,4,,,,6,6,,7,6,5,,5,6,7,7,7,6,
   6,12,4,5,6,,5,5,,6,5,5,,5,5,6,7,7,4,4,17,4,4,4,16,
   6,,10,6,4,,6,4,6,,6,8,6,6,,5,6,,,12,7,9,,5,7,16,6,
   6,5,,7,,6,,,13,6,,,4,6,7,6,6,5,9,9,5,,,21,7,,,5,5,9,
   ,9,4,8,11,6,,,19,5,,,,,14,13,,6,10,,81,,,,5,19,81,13,
   14,6,,10,,,,,,,,,,,,,,9,,15,8,7,5,7,7,17,17,6,,10,5,8,
   4,5,16,26,31,,4,9,6,6,7,4,7,8,,,,,,,,,9,9,8,6,7,4,8,
   ,5,4,27,22,23,7,5,13,9,17,4,7,6,13,7,7,8,6,8,8,4,,
   4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,7,4,7,,4,4,4,
   7,7,4,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,7,7,
   4,4,,7,7,4,4,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,
   4,4,3,5,3,5,4,4,4,3,4,,4,,5,6,4,7,7,6,5,5,5,7,4,
   7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,,4,,,
   4,7,,9,4,7,11,,4,5,8,8,4,,,4,4,4,3,5,3,5,4,4,4,3,
   4,,4,,,8,4,9,7,,7,5,4,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   4,5,3,4,4,4,3,5,5,8,4,,,,,8,11,7,,8,,4,4,,9,9,3,,4,
   ,4,,4,,,4,4,,5,5,4,7,4,4,,7,4,7,7,,4,4,,4,,4,,4,,,
   4,4,,5,5,4,7,4,4,,7,4,7,7,,4,4,4,9,,3,4,,,,4,,5,5,
   5,7,4,4,11,7,5,6,6,,5,5,,3,4,3,6,6,4,4,,,3,3,5,5,
   3,6,6,3,5,6,5,6,3,4,,,,,4,,,,,4,8,8,8,,8,4,,,,10,9,
   4,3,4,4,,3,,4,4,4,5,4,4,8,5,4,4,4,8,4,4,,,,4,,,5,,
   4,8,4,,8,8,4,9,8,,5,7,4,4,3,,,3,,3,6,3,5,6,6,3,6,
   6,6,3,6,3,4,4,,,5,5,7,9,5,10,7,4,,9,7,,4,4,4,,,5,
   5,7,9,5,10,7,4,,9,7,,4,3,,,4,6,5,,3,6,5,6,4,4,8,6,
   4,,4,8,4,6,4,5,6,8,3,,6,5,4,4,,,,,,,,,,,,,,,4,15,,,4,8,
   ,7,9,9,8,,4,7,,4,,8,,11,9,11,8,4,,7,6,4,20,6,4,3,
   4,7,6,6,12,24,,,6,6,7,6,12,5,4,7,16,4,4,5,6,4,3,7,
   7,7,6,5,6,3,4,6,16,9,21,,6,6,7,7,6,,21,24,4,3,9,6,
   5,4,21,5,7,8,5,8,7,7,4,4,4,5,,5,5,,4,3,5,4,5,4,3,
   3,,4,,4,,,4,,4,7,4,7,4,,4,4,10,10,4,,,,,,6,4,4,4,4,
   6,3,4,4,,,4,,10,10,6,5,,7,6,7,,5,5,5,7,7,6,4,,,6,6,
   4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,
   4,4,,4,,7,4,4,4,4,5,3,4,3,,6,5,4,,,4,5,6,,4,,12,5,
   4,4,8,8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,4,3,4,4,6,3,4,4,
   ,4,5,6,5,5,8,,4,5,6,5,5,7,5,4,5,5,6,6,5,6,5,5,6,
   4,6,4,,,5,6,,,,5,,,14,,,5,5,5,,,8,5,4,7,5,6,6,4,4,,5,
   ,6,,,,,5,,8,,5,,5,5,,,9,4,,3,,4,4,4,,5,5,5,,,4,4,4,
   7,4,7,4,4,,,7,7,4,4,4,6,3,,3,,,3,3,6,6,4,3,4,4,3,
   4,4,3,4,4,4,4,3,,,,4,4,,5,,5,,,4,5,4,8,4,8,4,5,12,
   6,,,4,,4,4,4,,5,5,5,,,4,4,4,7,4,7,4,4,,,7,7,4,6,10,,
   ,7,7,,,,,5,5,,10,,5,5,,,,,14,3,3,,3,,3,6,6,4,4,3,6,
   4,6,3,4,4,4,6,6,4,,,,3,,6,6,,3,4,4,,4,4,3,6,6,6,6,
   6,,3,3,,4,4,,3,3,4,5,4,3,3,8,6,4,4,5,,,,,,,,,,,,,,,,,,,
   4,4,,,4,4,12,8,4,8,12,4,5,5,,,4,4,,,4,12,4,,4,,4,12,
   5,5,8,8,4,5,5,8,5,5,5,6,5,4,4,,7,5,5,6,3,4,,,,4,,,,
   ,,,,4,4,,,,4,,,,,,,,4,6,10,4,,4,8,10,12,10,4,4,,4,13,
   4,13,4,6,4,4,7,7,6,7,6,7,6,4,4,4,13,13,4,4,3,8,8,
   13,8,4,4,3,4,5,5,5,5,3,3,3,8,8,13,8,4,4,3,4,4,4,
   8,8,5,4,4,13,13,5,6,8,8,6,7,7,6,3,4,4,,,5,,,,4,4,
   5,3,5,4,4,4,4,4,4,4,,5,,13,9,4,,7,,7,4,5,9,5,9,5,
   5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,6,5,4,7,7,5,6,
   5,5,10,4,10,6,6,,,5,6,6,4,5,5,6,4,5,6,5,4,,7,7,9,
   11,6,6,,11,9,5,5,,6,6,6,7,,5,4,6,6,7,5,4,4,,6,,6,,,
   5,,6,11,5,9,6,,6,6,13,11,5,7,,5,4,6,4,7,5,6,6,5,4,
   5,6,,5,,,6,5,11,9,6,,6,6,13,5,11,,4,4,5,3,4,4,4,3,
   5,8,5,4,,,,8,,10,9,,,8,4,4,,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,4,,3,4,4,,4,,4,,5,5,7,4,5,5,6,4,7,7,7,,5,5,6,3,
   4,4,,3,4,,4,3,,4,4,5,4,3,3,6,4,5,4,4,8,3,3,6,,,6,
   6,,6,,6,,7,7,9,5,6,6,,5,9,11,11,,6,6,,4,3,3,6,4,6,
   4,,,3,5,3,6,3,6,3,6,6,6,7,6,3,,8,,,4,,,,,,8,4,17,11,
   24,4,8,,,,11,13,4,4,,4,,4,,5,5,7,4,5,5,6,4,7,7,7,,
   5,5,,4,,4,,,4,,6,4,3,,8,4,6,6,5,10,4,6,4,3,4,,,3,,
   6,3,3,6,6,3,6,6,6,7,3,6,4,3,4,,,5,7,5,,4,6,4,7,,
   9,13,9,5,4,3,,,4,5,6,6,4,12,6,5,4,4,8,,3,4,,,5,7,5,
   ,4,6,4,7,,9,13,9,5,,4,8,6,4,4,6,6,3,8,,6,7,4,4,,,,,
   ,,,,,,,,,,4,,11,,4,8,10,,9,7,11,,4,,11,4,,8,17,24,11,
   13,11,4,,7,12,5,6,6,,6,7,,13,7,5,8,8,4,6,3,4,13,6,
   4,4,7,5,21,7,8,8,4,3,7,7,24,4,6,8,3,4,21,,24,5,,6,
   6,7,4,3,12,5,8,7,6,,8,34,4,11,8,6,14,4,6,10,10,4,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,
   4,4,6,3,4,4,,,,,11,17,6,9,,16,6,8,,,4,6,8,12,6,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,
   5,6,5,12,6,,,,,10,14,,251,,,5,6,60,9,27,,,4,,4,3,,,,4,,
   ,5,,5,9,4,,16,,4,7,13,10,5,9,,4,,4,,5,3,,4,5,,5,7,
   4,8,4,5,6,,4,,8,12,4,5,4,11,,,,,,,,,5,,7,9,4,8,14,,5,
   13,27,,5,,,3,4,4,6,6,4,6,7,,4,4,6,5,4,5,,3,8,8,5,
   6,4,6,,,,,6,,,,,6,10,16,,81,,5,,,81,15,19,4,4,4,4,,4,
   12,4,6,6,6,4,6,8,,4,4,6,8,4,6,,,,4,,,5,,5,9,4,,16,,
   4,7,13,10,5,9,6,5,4,,,4,,5,7,4,7,15,,4,8,,15,4,8,,4,
   ,,9,9,5,9,6,6,7,,4,,9,13,6,6,4,5,11,,7,4,8,9,7,21,
   ,5,,8,19,,5,4,12,,6,6,6,,4,6,,6,4,6,6,6,6,8,6,11,
   6,9,6,7,15,,4,,,11,6,5,10,,,,8,7,,,,,,,9,,5,13,20,,5,7,
   ,9,10,8,7,,5,,,5,,,,16,16,,,5,,8,6,23,20,,,4,6,6,6,
   16,7,37,14,,8,8,8,81,8,31,5,7,,5,7,7,5,4,4,,,9,9,
   15,6,4,5,,10,9,10,13,5,6,,,,,,,4,4,9,6,8,,6,6,11,10,
   5,26,7,,5,4,,10,7,4,4,4,3,5,3,5,4,4,4,3,4,,4,,7,9,
   4,,,9,7,5,5,8,4,8,,6,,4,3,4,4,6,3,4,4,,4,,,5,8,5,
   9,6,6,5,5,5,,5,6,5,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,
   5,4,6,4,7,5,6,12,4,6,,,,6,,14,,,,6,6,6,,14,,5,4,7,4,
   6,6,5,5,6,4,12,6,,,,,6,14,,,6,,6,6,,12,,4,,4,,4,,3,,
   4,4,,,4,,5,5,4,7,7,5,5,6,6,7,4,7,4,3,6,3,,4,4,,3,
   4,6,4,6,4,6,3,4,4,6,4,6,6,4,3,4,4,10,,6,,,4,,,,4,,
   7,5,4,8,8,5,7,9,9,,4,,,3,4,4,6,4,4,6,4,,4,4,4,5,
   4,4,4,4,8,8,4,5,4,6,10,,,6,6,,,,,6,6,12,,,6,6,,,,14,,
   4,4,4,3,,4,6,4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,,4,
   ,5,7,4,,,7,5,9,9,8,4,8,,4,4,,,4,,5,5,4,7,7,5,5,6,
   6,7,4,7,4,4,3,10,6,10,6,6,6,7,7,5,5,,12,4,6,4,3,
   4,6,,6,4,8,6,6,6,8,4,6,6,4,,4,4,6,,6,8,4,,4,4,4,
   8,6,6,6,6,6,10,6,10,6,6,6,7,7,5,5,,12,4,6,4,4,3,,,
   4,,,,,,,,4,,4,12,10,,4,4,10,8,12,8,4,,4,,,4,,,,,,,,4,,6,
   7,7,7,4,9,4,6,8,8,8,5,11,11,9,4,4,6,7,7,7,4,4,7,
   5,8,7,3,3,3,3,7,11,8,7,4,3,4,7,11,8,7,4,3,4,6,6,
   4,11,5,11,6,4,7,7,7,9,11,7,11,11,5,11,4,3,4,4,,,4,
   4,4,4,5,4,4,3,,,,4,,,5,9,10,7,4,,7,,4,5,9,10,5,,,4,
   4,4,3,5,4,5,4,4,4,4,4,,5,,,7,4,7,,13,9,5,4,9,5,10,
   ,9,10,10,8,10,8,11,8,11,,17,10,,,,7,,,,,,,9,8,,,,5,6,
   6,4,5,5,6,4,7,,11,6,,,,,,19,19,,,,5,5,,,,,,4,,5,,4,,3,
   5,4,,5,5,5,6,5,5,,6,5,7,7,17,4,4,3,4,10,,,4,,,,4,,
   6,6,6,7,5,5,,7,6,7,7,,5,5,4,10,,,4,,,,4,,6,6,6,7,5,
   5,,7,6,7,7,,5,5,,4,4,3,6,6,6,4,,,4,4,5,8,3,,6,4,5,
   6,6,12,4,5,14,,,,6,,,,,5,7,9,17,,7,5,,,17,10,14,,4,5,
   6,,4,,6,6,5,6,5,5,,6,5,5,5,9,6,6,,,,,,,6,,6,8,4,,,7,
   6,16,12,,6,9,4,4,4,,,4,,4,6,3,8,,5,4,6,6,6,4,12,,5,
   4,,,5,7,21,,5,,13,5,,9,11,8,4,,4,,,5,9,10,18,5,,10,7,
   7,12,18,,5,4,,,6,8,12,,4,,16,8,6,6,9,,6,,6,16,6,8,4,
   6,,6,4,,6,6,6,8,,,,,,,,,,,,,,,6,,44,,5,,,15,13,14,10,,6,
   23,,5,,,162,,10,15,10,6,,,9,9,,8,5,4,5,21,27,29,6,9,,
   7,8,5,7,36,10,6,4,,9,6,7,5,8,,4,,15,10,6,10,8,4,,,,,,
   ,,,,7,5,14,8,12,5,4,37,28,38,4,10,7,8,8,7,7,8,8,6,
   6,,4,3,4,4,6,4,4,4,,4,,,6,10,10,,5,7,7,6,5,,5,5,6,
   7,7,,5,6,5,5,6,4,6,4,,14,,6,,,,10,,,13,15,,,5,6,,44,
   14,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,5,,5,,,4,7,5,8,4,
   8,4,,11,,8,9,4,4,4,6,4,,3,,,,3,6,10,4,6,6,6,3,4,4,,
   4,6,4,6,3,3,,,4,4,,5,,5,,,5,9,5,13,5,9,4,,7,10,,7,4,
   ,,4,4,,5,,5,,,5,9,5,13,5,9,4,,7,10,,7,4,,16,,,7,,,,,,
   10,6,162,10,,5,,,,23,,15,4,4,,5,,5,7,10,5,8,4,9,5,7,
   4,,,8,7,9,5,,,,,,6,10,,6,6,6,,4,4,,6,8,6,8,6,,3,,,4,
   8,,6,4,5,6,4,3,,8,12,4,6,6,,,,,,,,,,,,,,,,,,,,4,,,5,9,
   27,11,4,8,13,,5,7,,,5,,,,,,,,,,,,,,,,,6,11,14,,6,7,16,6,
   4,,,9,6,8,12,,5,,,,5,,19,,19,,,,5,10,,,,9,,,,,,7,,8,17,
   10,7,,5,9,,17,14,5,7,,8,14,10,37,8,,8,8,23,36,8,8,7,
   28,,,4,6,27,10,7,7,,9,,15,12,8,7,5,5,7,,6,8,4,5,4,6,
   ,10,38,5,8,4,,4,4,9,6,5,,,,,,,9,9,10,29,6,7,,5,7,,5,
   6,5,4,6,4,7,5,6,10,5,5,,,,,,14,251,,,10,6,5,23,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,,,4,5,3,,4,,,4,4,8,8,5,7,,
   8,8,4,9,4,3,6,4,,4,4,,4,4,6,4,10,,4,3,6,4,6,6,6,
   4,4,3,6,4,,,,3,,4,,,,5,,,4,5,13,9,5,9,13,7,,4,7,,4,
   4,4,6,4,6,6,4,,8,,3,6,5,4,4,6,8,8,4,6,6,,11,,,6,,,,,
   ,,5,11,,23,6,10,,,,14,,,,5,4,,6,7,5,10,,4,5,9,7,4,8,
   8,,7,5,9,,,,,,,5,,,5,5,,,7,9,27,13,8,4,11,,4,,,,5,,,4,
   5,13,9,5,9,13,7,,4,7,4,5,,11,6,14,,5,6,12,8,5,7,,9,
   5,6,16,4,4,6,,16,,6,6,8,6,10,6,6,4,4,,6,,7,,8,,5,,
   13,5,4,14,8,,7,9,27,,,,,5,9,10,9,5,12,,15,9,10,10,5,,
   ,19,5,,,,,,19,,5,,10,,13,,7,5,14,11,12,13,5,,7,,,9,,,,,,
   ,7,8,,,,,,,,,,,,,5,10,9,,8,4,4,8,7,7,7,5,6,7,6,7,4,
   4,5,,20,14,7,18,8,5,7,23,37,16,8,5,4,8,8,6,4,27,5,
   8,8,8,21,10,17,,22,6,9,11,7,9,5,,7,4,4,5,4,4,4,5,
   4,6,10,10,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,,,4,,10,11,,
   ,4,8,8,,11,7,10,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,5,10,,,5,,
   14,,5,,,,5,,14,12,11,,5,7,7,,13,13,,4,,5,7,,5,7,,,,4,,,
   15,9,,4,8,8,9,,7,4,,,,,5,,,,,4,,,,,,4,,,,,,6,4,4,8,,4,,,
   ,4,,10,12,8,,4,4,4,12,10,8,,,,6,,,,,5,,25,,13,,5,,,,,,5,
   ,4,,,,,4,,11,,7,,4,8,8,9,10,,,5,6,,,,6,,19,13,81,,5,,
   10,81,,10,10,,,,,9,,,,,,8,7,,,,,5,,,,7,,,10,7,,7,5,5,12,
   20,8,,,,6,,19,,11,,5,,10,9,,150,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,20,15,19,,5,3,4,18,31,32,,,,,,,,,,,,,,44,31,19,,,,,
   ,19,18,18,,,,,32,32,15,,,,,,,,,,4,3,18,19,15,5,15,20,19,
   19,44,32,,,,4,,5,,,5,5,,4,,5,,,,,4,15,11,24,4,,8,8,,11,
   13,6,4,4,4,,4,4,,8,4,,,,,4,10,6,10,4,,4,4,12,8,10,,,,,
   ,,6,,,,,,,5,,,,5,,,,,19,19,,,5,5,7,5,,7,,,,,4,,7,11,4,,
   8,8,11,,11,3,10,,,5,,,,,,,4,,,,4,,,,,,,10,,,5,,,,,,,4,,,,4,,
   ,,,,,,5,,8,,,,,,5,10,,11,5,,7,7,14,16,14,5,4,,,,,,,4,11,
   ,13,4,,8,8,11,17,24,5,,6,,,,,6,,10,46,5,,,10,,19,13,
   10,5,,,,,7,14,12,14,7,,5,5,13,,10,,,,,,9,,,,8,,7,,,,,,,,,
   6,,,11,5,,,10,11,27,153,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,44,32,19,5,,3,4,29,22,15,,,20,,21,48,,,,,19,,19,
   13,,,,15,,19,13,,,,,4,3,31,26,19,,,,,,5,26,31,18,16,27,
   19,,,,,4,,4,,4,,,4,4,,5,5,4,7,4,4,,7,4,7,7,,4,4,,,,,,,,
   ,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,4,7,4,7,4,4,,,7,7,
   4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,5,5,7,4,5,5,6,4,7,7,7,
   ,5,5,,,,4,,,5,,5,9,4,,16,,4,7,13,10,5,9,,4,4,,,4,,5,
   5,4,7,7,5,5,6,6,7,4,7,,,,,,,,,,,,,,,,,,,4,4,,,5,4,9,7,
   5,,9,4,7,7,8,,4,4,,,5,9,4,,4,8,4,9,7,7,,7,5,,5,9,
   4,4,5,6,7,5,5,,8,7,5,4,,,,,,,,,,,,,,,4,12,10,,4,8,11,7,
   ,,8,,4,11,15,4,,8,11,13,,24,8,4,,4,7,6,7,3,4,6,7,
   20,5,5,6,7,16,4,3,6,7,20,6,4,4,7,6,4,20,16,6,4,3,
   7,5,5,9,7,6,3,4,12,24,,6,,6,6,4,7,6,16,4,7,7,6,7,
   7,6,,6,16,15,,21,24,7,7,4,4,10,,,4,,,,4,,6,6,6,7,5,5,
   ,7,6,7,7,,5,5,,4,,4,5,,5,5,5,,5,4,7,,4,4,7,4,7,7,
   4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,6,6,6,4,4,5,5,
   5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,,5,5,,4,7,4,,4,
   7,4,7,7,4,4,,,4,4,,7,5,4,8,5,4,6,,4,,8,6,5,4,,,,,,,,,
   ,,,,,,,,,4,6,,6,6,5,,4,4,5,6,5,5,5,7,5,5,7,,4,8,5,
   6,4,,4,,8,4,5,6,6,6,10,,5,5,,,14,,,,5,5,6,14,,,5,5,,
   8,,,5,,5,8,,5,,5,,9,,,5,5,,4,6,4,5,3,3,3,4,5,5,5,7,
   13,8,4,3,4,3,13,8,8,4,4,13,4,13,7,4,6,4,4,7,6,7,
   13,4,4,6,7,6,7,8,6,4,4,4,3,4,8,8,13,4,3,5,5,5,4,
   8,8,13,13,8,8,4,4,4,,,4,4,,5,,5,,,5,9,5,13,5,9,4,,
   7,10,,7,4,,,,,10,,,,,,7,8,,,,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   5,,9,9,5,,12,9,9,10,10,,5,15,,4,,,,5,,,4,5,13,9,5,9,
   13,7,,4,7,,,,,,,,,,,,,,,,,,,,4,,,6,6,14,9,6,,16,6,8,7,,,4,
   ,,,,,,,,,,,,,,,,,7,11,8,4,7,27,9,5,,,11,,5,13,,,,,,,,,,,,,,,
   6,23,12,,6,10,14,,251,,,,5,,14,6,,10,11,23,,,,5,,5,27,
   22,21,4,5,8,,,8,11,5,6,10,4,4,5,7,,7,7,6,8,6,23,20,
   8,,,4,8,6,16,7,9,,4,,7,37,14,17,,8,8,5,7,5,,5,7,,8,,
   9,8,7,,10,18,,7,9,,,4,,,,,,,,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,
   5,7,4,6,5,5,4,7,7,7,5,,5,,5,,5,,5,,,4,,16,,4,9,5,
   10,7,5,10,9,5,5,5,,4,,,4,4,7,7,4,4,4,,,4,7,7,6,6,6,
   ,,5,6,6,9,5,11,6,6,,,11,9,5,6,6,7,,7,5,11,,6,6,6,
   5,9,9,6,,6,6,7,,7,11,5,,6,6,5,6,9,9,6,,6,5,,,6,6,
   9,11,5,6,6,,,5,9,11,,4,8,8,8,4,,10,12,,,,8,4,,,,,,,,,,,,
   ,,7,11,8,,4,9,9,,,4,8,,4,24,4,5,3,4,6,7,6,7,7,12,
   6,5,4,3,6,7,4,16,4,7,7,12,5,6,,6,,6,4,6,6,7,20,3,
   6,4,5,8,8,21,4,6,3,4,7,6,5,21,6,7,6,7,24,5,,21,,9,
   9,6,16,7,4,7,10,,,5,,,,,,,4,,,,4,,,,,,,,,,10,,,,,9,,,,,7,8,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,,5,,,,,,5,,,10,,13,,
   ,,,,5,,16,16,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,31,26,18,3,5,,,19,21,22,26,31,19,5,3,,,19,20,
   15,,,22,27,,,,,,,29,16,,,,,,15,19,,,,,,4,,,32,44,19,,,13,
   48,13,,,,,,,,,,,,4,,,,6,6,,7,6,5,,5,6,7,7,7,6,6,12,4,4,
   ,,5,5,,7,4,5,6,5,4,7,7,7,5,5,,4,,4,,7,5,8,4,7,5,
   9,4,,,8,9,7,5,,4,6,,6,5,6,9,6,6,6,5,5,5,5,,5,,,,,,,,,
   ,,,,,,,,5,7,,8,4,7,9,5,4,,,8,5,7,9,6,6,,12,6,6,,14,,,,
   ,6,6,6,,14,,6,6,14,,,,6,,6,,14,6,,6,12,,,,6,6,,4,11,
   7,7,3,4,4,3,8,7,11,5,7,7,3,3,3,4,8,7,5,6,6,7,7,
   7,11,4,9,4,6,8,8,8,7,4,4,9,5,11,11,7,9,4,4,4,4,3,
   7,5,7,3,4,7,11,12,4,7,11,12,8,7,11,6,6,6,,,,,,,,,,,,,,,
   ,,,,,,4,,14,7,,4,8,5,,19,,5,,14,21,7,9,,,,,,,,,,,,,,,,,,,6,
   ,,11,6,,,4,6,16,7,8,6,9,,,,,,,,,,,,,,,,,6,,11,27,5,,,,16,
   ,153,,6,10,,16,,,,5,19,11,,,6,,10,,,,,,,,,,,,,5,8,,6,4,4,
   5,7,8,5,11,7,,7,5,4,8,,27,27,53,,4,11,6,15,9,4,,8,,,,
   ,,,,,6,7,9,7,,4,8,5,,8,27,38,23,7,5,5,8,9,7,8,12,
   44,10,6,13,6,8,8,4,4,,9,5,,4,4,5,7,6,5,5,,11,6,5,
   7,4,,5,,,4,15,7,,5,15,4,7,7,4,,8,,5,,,15,4,,8,4,4,
   15,7,7,5,7,,,,,,,,,,,,,,,,,4,,11,17,4,8,,11,13,,24,,4,8,,
   12,10,,8,4,11,7,,,4,,8,,,,,,,,,,,,,4,8,5,6,3,4,6,7,4,
   7,24,5,12,8,4,3,6,7,7,5,21,7,4,6,4,13,8,3,4,6,7,
   13,7,6,6,6,6,,4,6,7,5,4,3,6,4,7,6,8,5,8,7,6,6,8,
   8,,5,12,,24,21,,4,7,7,4,4,,,5,5,7,9,5,10,7,4,,9,7,,
   4,4,,,5,7,5,,4,6,4,7,,9,13,9,5,10,6,10,6,6,6,7,7,
   5,5,,12,4,6,4,,10,,,7,8,,,,,,,,9,5,,,,5,,19,19,,,,,5,8,
   11,5,,7,13,13,,17,5,5,,6,27,5,6,4,7,,8,6,16,7,22,6,
   9,7,4,,8,7,26,5,5,,9,9,,23,8,5,4,7,6,8,,9,4,4,4,6,
   9,,8,7,8,5,4,,8,9,6,7,,8,5,10,6,,,,,17,31,8,,4,5,4,
   6,,6,7,7,,5,5,7,7,6,6,5,,5,5,,,5,10,9,10,5,16,4,,9,
   4,,7,,6,10,99,10,6,,,13,11,,,,5,,,,,,,,,,,,,,14,36,10,,6,,
   9,19,,5,,,7,10,7,8,5,4,4,5,6,,7,12,8,13,13,5,6,,8,,
   7,8,8,14,10,37,39,8,,8,6,7,6,16,26,4,,,8,7,28,37,,,
   4,7,,6,9,,10,5,4,5,,5,5,5,,9,8,,7,,4,,5,,,10,5,,6,4,
   4,16,,9,5,9,13,,6,20,9,,5,,14,,,27,,10,6,,,,,,,,,,,,,,81,
   15,,,5,16,81,,17,6,10,,7,,6,9,5,13,6,,6,81,10,,6,6,4,
   5,4,5,6,8,5,,,,,,,,,,4,7,7,8,6,4,8,,4,10,9,5,,8,4,7,
   5,4,6,7,7,,6,20,48,10,5,23,37,15,16,31,26,8,6,8,5,
   10,8,16,5,7,,10,12,,14,,5,5,,,,,,5,25,13,,,5,,,,,7,,8,,,,
   ,9,,,6,27,8,5,4,,,8,7,27,9,38,12,8,,4,,8,5,27,5,,5,
   11,6,,23,4,5,8,7,15,9,,44,5,8,7,6,7,,6,4,4,4,4,,8,
   8,7,6,,8,6,7,7,,,,,11,53,13,5,4,,4,,,,4,,,,,,,,4,,,4,,,,,
   ,,,4,,,31,26,,,,,,,29,16,26,31,,,,,,,22,27,4,,20,32,19,19,
   ,5,3,,21,19,19,18,,3,5,,,,,,,,,,,,44,48,,,,35,73,,,32,21,
   ,15,19,,,4,,,,,4,,,,,4,,,,,32,18,,,,,19,,35,,20,19,,,,,31,,
   44,,,,,,,,,,4,31,32,18,19,3,,5,44,32,19,15,5,,3,,,,20,,
   19,,,19,,15,,15,,18,32,,32,,4,,,32,,13,,,,,19,19,,44,,48,,,
   ,,21,20,,,4,22,15,29,19,3,5,,,,,,,,,,27,19,16,13,5,3,,,,
   ,31,26,,,,18,19,,,26,31,,19,15,,4,,,8,8,13,4,4,3,4,7,
   13,7,8,13,8,9,8,11,8,13,6,7,12,7,5,7,5,12,7,12,13,
   8,7,7,8,6,4,3,3,8,5,8,4,4,7,13,9,4,5,8,8,8,7,11,
   7,8,13,8,7,9,4,5,7,5,9,4,11,13,6,8,13,8,8,9,7,6,
   8,8,13,10,10,4,4,4,13,9,7,3,3,7,10,8,4,12,8,12,13,
   8,8,13,7,8,4,13,7,7,13,3,4,4,8,8,13,8,4,4,3,8,13,
   10,8,9,10,7,10,12,7,8,13,12,13,7,8,9,6,4,3,4,7,11,
   8,7,4,3,4,13,7,7,8,5,13,8,6,8,8,9,7,12,8,9,8,12,
   13,3,4,4,8,7,8,9,4,10,11,10,13,6,10,9,9,6,6,9,8,
   10,4,4,3,4,3,13,7,8,4,8,8,13,6,4,6,8,11,7,4,7,11,
   12,6,10,10,13,7,8,7,9,13,8,11,13,7,11,8,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,10,,,10,,,10,,,
   ,,10,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,10,,,
   10,10,10,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,8,8,8,
   8,8,8,8,8,8,8,8,8,4,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,
   4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,
   ,2,4,,4,,4,4,4,,,4,4,,,,8,8,8,8,8,8,8,8,8,8,8,8,,4,
   ,,8,8,12,8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,
   12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,8,12,16,8,12,16,20,
   4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,6,6,6,8,8,
   8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,,4,6,,6,,8,,8,,,,,,,,
   ,16,16,,20,20,38,20,20,20,20,38,4,4,4,4,6,6,6,8,4,
   6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,,8,12,8,,,,,,,,16,,,
   16,16,38,,20,16,20,38,,6,6,6,8,10,10,10,4,8,8,4,8,8,,
   ,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,,,,,34,58,,,34,,58,
   ,4,6,4,4,4,8,4,6,6,4,6,6,,,6,6,8,,8,,,,,,4,6,,6,,8,
   ,8,,,12,12,,,,20,16,16,20,,,16,16,,16,,16,6,6,6,6,10,
   4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,34,,
   ,34,,,,34,,34,,,8,10,10,8,4,12,12,4,12,12,,,12,12,8,
   28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,46,,,46,46,52,,38,46,
   38,52,,4,6,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,,4,6,,6,
   ,8,,8,,,,,,,,20,20,20,20,38,16,20,,38,,16,20,6,10,4,8,
   8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,,22,22,,,
   ,34,,,,,34,8,4,12,12,4,12,12,,,12,12,8,,8,,,,,,4,12,,12,
   ,8,,8,,,28,28,,,,38,46,46,38,,,46,46,,46,,46,6,16,16,6,
   16,16,,,16,16,10,,10,,,,,,6,16,,16,,10,,10,,,,,,,,,,,,,,,,,,,
   ,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,
   ,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,,,6,6,6,8,6,,,,,,
   4,6,,6,,6,8,6,,,,,,,,,,,,10,,,10,10,10,,,4,4,4,,,6,6,6,
   8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,10,,,10,10,10,,,4,4,,,
   4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,8,8,8,8,8,
   8,8,8,8,8,8,8,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,
   ,,,,10,,,10,10,10,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,
   ,,,,,10,,,10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,
   ,10,,,10,,,10,,,,,10,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,10,,
   ,10,,,10,,,,,10,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,12,12,,,12,
   ,,,,12,,,,,,,,4,,,,,,4,,,,,,,,,,32,32,,20,,20,,20,,,20,8,8,,,
   ,4,6,,6,,4,,4,,,,,,,,,12,12,,,12,,,,,12,,4,,,,4,,,,,8,,8,,,
   ,,,,,24,,,24,,20,,32,,32,20,,,,,4,,,,,8,,8,,,,,,,,24,,,24,,
   20,,32,,32,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,,,8,8,8,8,
   8,8,8,8,8,8,8,8,,4,,6,,6,,,8,8,,,,10,,,10,,,10,,,,,10,,,
   ,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,10,,,10,,,10,,,,,10,,,,,,,,
   ,,,,,,,,,,,,,,,,4,,,,,,,,,12,12,,,12,,,,,12,,,,,,,,,,,32,32,,20,
   ,20,,20,,,20,,,,,,,,,12,12,,,12,,,,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,4,,,,,,,,20,32,20,,20,,32,20,,,,,,,,20,32,20,,20,,
   32,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,,,,,,,8,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,8,,,,,,,,8,,,,,,8,,8,,,,,,,,,3,6,6,9,,6,9,
   ,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,
   ,,,,3,3,,6,,6,,6,,,,,,,,,12,12,12,,12,,12,12,,12,12,6,6,
   9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,
   6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,12,12,12,,12,,12,12,,12,
   12,5,5,,4,7,10,7,12,,5,5,5,5,5,10,5,5,10,9,3,5,5,
   4,5,5,,,3,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,9,,9,
   9,,11,7,6,10,10,6,9,5,,5,5,12,8,,,5,5,5,5,5,10,4,5,
   5,9,3,4,4,5,5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,
   ,,11,7,9,,9,9,,9,6,7,6,11,,7,8,,7,,,10,5,10,10,10,7,
   10,10,10,16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,
   6,5,6,5,8,8,,,,,,,,,13,13,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,3,5,5,5,5,10,5,5,
   10,9,3,5,5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,
   5,,8,,9,10,6,9,11,,9,10,6,,10,9,,7,,,10,10,10,10,10,
   10,5,10,10,16,4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,
   10,,10,,,,,,6,,,,5,,,13,11,,10,,5,,,,,,27,,,,,,,,,6,,,,,,,,6,,
   ,,,,,,,,,,7,,,,7,,,,,,,,,,,11,19,23,,31,,,,,,,,9,9,14,9,14,
   10,9,14,8,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,
   6,11,9,10,9,10,10,8,8,,,,,,8,,,,,8,12,,12,,,,,,18,,,,,,,6,
   ,,,,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,23,17,,,25,,,,11,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,6,7,
   7,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,6,8,,,,
   ,,8,,17,7,6,17,14,11,9,8,8,11,8,14,5,5,5,5,4,5,5,
   5,3,5,5,5,6,6,,,3,5,6,,6,,,,,,5,5,6,4,,8,6,8,6,6,,,,,
   ,9,10,6,9,9,9,10,8,6,14,7,17,5,5,5,6,8,7,8,4,5,5,
   5,10,10,,,4,5,10,,10,,,,,,5,5,,6,9,7,,7,8,8,,,,,,26,23,
   11,,26,21,,7,8,25,9,32,5,5,5,5,5,5,3,5,5,5,6,6,9,,
   3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,,6,6,,14,,11,9,6,14,
   17,17,7,6,6,9,6,9,5,5,5,5,4,4,5,5,5,10,10,,,4,5,10,
   ,10,,,,,,5,5,9,6,,7,9,7,11,11,11,11,,9,,21,,11,26,,26,
   23,8,11,49,11,,7,7,6,7,4,6,6,6,12,12,7,,4,6,12,,12,,
   7,,,,6,6,7,4,10,6,7,6,10,10,8,8,,10,,94,42,7,18,18,
   94,42,8,8,43,8,22,5,5,7,3,5,5,5,6,6,6,,3,5,6,,6,,6,
   ,,,5,5,,4,,8,,8,,,,,,14,,14,14,8,11,9,9,11,6,7,10,6,
   14,5,8,4,5,5,5,10,10,9,,4,5,10,,10,,9,,,,5,5,,6,,7,,
   7,,,8,8,,12,,25,49,8,25,26,,21,11,11,,11,26,7,4,6,6,
   6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,8,6,7,6,8,8,10,
   10,,,,81,48,8,43,42,42,94,8,7,48,7,18,4,9,9,9,8,8,,,
   4,9,8,,8,,,,,,9,9,10,6,,8,10,8,,,,,,,,30,17,11,29,10,
   38,38,8,18,29,11,,3,3,3,4,4,3,,2,3,4,,4,,3,,,,3,3,3,
   2,3,3,3,3,3,3,3,3,,3,,8,7,3,8,8,8,7,3,3,7,3,8,3,
   5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,9,11,
   11,9,9,,4,4,7,11,11,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,
   4,4,4,5,5,,,,,,,9,11,11,9,9,,4,4,7,11,11,5,5,,,3,3,5,
   ,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,9,,11,9,11,,9,4,4,
   10,10,9,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,
   5,,6,,,,5,,,,,6,6,,5,,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,
   6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,3,,6,,6,,3,,,,4,4,4,
   4,5,4,4,4,,,,,,,,24,,10,12,12,24,,5,5,10,28,12,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,
   3,3,3,,3,,8,7,3,8,8,8,7,3,3,7,3,8,5,,5,,,,,,4,4,4,
   4,5,3,4,3,,,5,5,,,,9,,11,9,11,,9,4,4,10,10,9,,4,,6,,,
   ,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,
   ,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,
   4,4,,,,,,,,24,,10,12,12,24,,5,5,10,28,12,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,
   ,5,,5,,,5,5,,5,,9,10,4,9,,11,7,11,10,,4,9,,4,,5,,5,,,
   5,5,,5,,9,10,4,9,,11,7,11,10,,4,9,4,,,3,,,,,,,5,,12,
   10,5,,24,12,10,28,28,,5,15,,4,4,4,6,6,6,6,,,,8,8,8,
   8,8,8,8,8,8,8,8,8,,,,,,,,,,,12,11,15,,,12,11,,,,15,,,3,
   5,5,,,,5,,11,7,5,,11,9,10,10,11,11,5,,,,,,,,5,,12,10,5,
   ,24,12,10,28,28,,5,15,5,5,,,,5,,11,7,5,,11,9,10,10,
   11,11,5,,3,5,5,,,,17,17,9,13,14,17,11,,9,17,,9,5,5,,,,
   17,17,9,13,14,17,11,,9,17,,9,3,,,,14,11,,17,11,9,17,,
   9,17,9,14,,,,14,11,,17,11,9,17,,9,17,9,14,,,,,,,,,,,,,,,,,,
   ,12,12,,,19,11,11,,12,,,,,,,,,,,,,,34,9,,,,9,11,,29,,25,,,,
   ,8,10,,13,249,11,11,34,25,9,7,8,5,9,,235,,29,28,,9,,9,
   ,34,25,,9,,,11,9,,25,,10,8,235,17,9,5,25,7,28,13,6,
   28,10,,11,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,
   3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,12,12,12,
   ,12,,12,12,,12,12,5,5,,4,7,,7,,,5,5,5,5,5,10,3,5,5,
   9,4,3,4,4,4,4,,,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,
   ,,,,10,,10,9,6,11,9,9,9,10,6,5,,5,5,,8,,12,4,5,5,5,
   5,5,5,5,10,9,5,3,5,5,5,6,5,5,4,5,5,,7,,,,,,3,4,,5,,
   5,,7,,,,,,,8,7,6,9,9,,9,9,,11,11,7,6,,7,8,,7,,,5,10,
   10,10,10,10,5,10,10,16,7,4,7,5,5,4,,,5,6,6,,10,6,,,6,
   ,4,5,,6,,6,,10,,6,,,,,,,5,11,,11,5,,,,,,10,12,,,,,,,18,,,,,
   ,,,,,6,,,,,,,,,,,,7,,,,,6,,,,,,,,,7,,,,,,,,,,,,25,,,23,17,11,5,
   ,7,,10,5,5,5,4,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,
   5,5,,,6,8,,3,5,,5,,5,5,5,,,,6,,,,10,6,10,6,7,9,,9,9,
   9,,10,,7,,,10,10,10,5,10,10,10,10,7,16,5,4,5,7,7,4,
   8,8,7,10,10,,5,,,6,,,4,7,,10,,10,,5,,,,6,,,6,,10,,5,,,
   13,13,,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,9,9,14,9,14,8,9,9,10,11,7,6,7,7,7,6,10,10,9,8,8,
   8,9,10,,10,,,6,9,,8,,8,8,9,,10,,10,,,11,,12,,8,,8,,,,,,
   12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,
   ,6,,,,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,,,,,,,31,11,23,19,,,,,5,5,
   4,5,5,4,6,7,7,5,3,5,5,5,4,,,5,6,6,,8,6,,,14,,3,5,,
   6,,6,,8,,6,,,,,,10,6,9,6,11,8,9,11,14,14,14,7,5,5,5,
   5,4,5,5,5,5,3,5,5,5,4,,,5,6,6,6,8,9,,9,14,,3,5,,6,
   ,6,6,8,,9,,9,,,8,9,6,10,6,7,6,17,14,9,11,9,6,5,5,
   5,6,8,7,8,5,4,5,5,5,6,,,5,10,10,8,7,9,,,12,,4,5,,10,
   ,10,8,7,,9,,,,,,,11,,11,21,8,26,25,26,25,49,11,5,5,5,
   5,5,5,5,3,5,5,5,4,6,6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,
   ,6,,,,14,5,7,8,10,6,9,9,17,9,10,6,5,5,5,5,4,5,4,5,
   5,5,6,11,11,5,10,10,11,7,,,9,9,,4,5,,10,,10,11,7,,,,9,
   ,,,26,11,23,8,23,11,,26,,21,,11,7,7,6,7,6,4,6,6,6,4,
   8,8,6,12,12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,8,
   18,7,42,8,94,8,42,43,18,81,48,7,5,5,7,5,3,5,5,5,4,,
   ,5,6,6,,8,9,,6,8,,3,5,,6,,6,,8,,9,,6,,,14,11,8,11,8,
   9,6,14,17,14,17,7,8,5,8,5,4,5,5,5,6,8,8,5,10,10,,7,
   ,,,,,4,5,,10,,10,,7,,,,,,,9,25,8,21,7,,11,26,,32,26,23,
   6,7,6,4,6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,6,,12,
   ,12,8,6,,7,,7,,,10,43,8,94,8,42,7,18,18,22,94,42,8,
   9,4,9,9,9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,,,,
   29,11,38,8,38,11,10,29,,30,17,18,3,3,4,4,4,,,3,5,5,
   5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,10,10,7,4,,9,9,9,
   10,10,3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,3,3,
   ,3,,3,,,3,7,3,7,3,7,3,8,8,8,8,7,3,4,4,4,,,3,5,5,
   5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,10,10,7,4,,9,9,9,
   10,10,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,
   10,10,,4,9,11,11,9,9,9,,4,4,,,5,5,5,5,3,,,4,,,3,5,,5,
   ,5,5,3,,,,4,,,5,10,10,,4,9,11,11,9,9,9,,4,6,6,4,4,
   4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,8,8,8,8,8,8,8,
   8,8,8,8,8,3,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,17,,
   17,,11,9,14,13,9,17,17,9,5,5,5,5,5,,,,,,3,5,,5,,5,5,
   5,,,,,,,,17,,17,,11,9,14,13,9,17,17,9,5,5,,4,,,4,,,3,3,
   ,5,,5,,4,,,,4,,,5,7,11,9,4,,11,9,11,11,,9,4,4,5,5,6,
   ,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,5,5,6,,
   6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,3,,,
   5,,5,3,,,,,,,,,17,9,9,,17,,11,17,14,14,11,9,4,,,5,,3,4,
   ,5,,5,,3,,4,,,,,,11,5,9,10,10,5,11,,,11,7,11,,4,,,3,,,
   6,,6,,4,,3,,4,,,5,10,28,18,5,,10,12,12,12,24,,5,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,,5,10,28,10,5,
   24,,15,12,10,10,,3,,,6,,6,,5,,,,5,,,,11,,,19,,,12,12,12,,
   ,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,7,3,7,
   3,7,3,8,8,8,8,7,3,,5,,5,,4,,,,4,,,5,7,11,9,4,,11,9,
   11,11,,9,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,6,,,6,,5,,6,,
   5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,
   ,,,,,,,17,9,9,,17,,11,17,14,14,11,9,,4,,,,,,11,5,9,10,
   10,5,11,,,11,7,11,,,,,,,,,,,,,,,,,,,,4,,,5,10,28,18,5,,10,
   12,12,12,24,,5,,,,,,,,,,,,,,,,,,,,,5,10,28,10,5,24,,15,12,
   10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,15,11,,11,15,,,,12,11,,10,,
   25,235,8,,,,235,,13,25,7,17,5,9,9,11,29,13,6,10,,17,9,
   235,,,,8,10,9,34,29,28,9,8,5,25,,,9,,,8,11,11,9,34,25,
   7,,,235,,25,,9,,28,,249,28,,11,10,8,8,,6,7,,7,,,8,8,7,
   8,7,10,8,7,10,20,5,5,4,6,6,6,,,5,6,6,9,6,10,,,,,5,
   4,10,6,,6,,6,9,,,,,,,11,,,,11,14,8,14,,11,14,14,8,,8,8,
   ,10,,,8,8,7,8,7,10,8,7,10,20,5,5,4,10,7,10,,,5,7,4,
   ,7,,,,,,5,4,,10,,7,,10,,,,,,,,11,14,,,11,,11,,14,11,16,
   16,11,7,4,11,7,6,6,8,8,6,8,6,9,8,6,9,8,5,5,4,6,4,
   6,,5,8,6,6,,6,8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,
   6,8,6,6,8,8,6,8,8,8,6,6,,6,6,,,,,29,11,,10,,,9,,16,,,
   5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,,6,,,,,19,,,,,,19,,,,,,8,,
   7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,6,6,,9,5,6,6,,6,
   ,10,10,,,5,4,,6,,6,,6,,,9,,,,,11,14,14,14,8,,11,,14,11,,
   ,6,7,11,11,8,8,6,8,6,9,8,6,9,8,8,8,4,6,6,6,,,5,4,
   6,5,4,,8,8,8,12,5,4,,6,8,6,,6,5,,,,8,12,12,8,6,8,8,
   6,6,8,6,6,6,8,8,,,,,34,9,,13,,,9,,16,,,5,,9,,,,,8,8,,8,
   ,,,,,,5,,,,9,,,,,,,,,,19,,,,,,19,,,,,,,,12,12,10,12,6,8,10,
   10,8,10,6,6,4,4,6,4,,7,6,6,4,7,6,10,10,10,,8,6,4,
   10,4,,6,,4,7,,7,,8,,,9,,,,6,,6,,,9,,,6,,,9,29,10,,,11,,
   16,,,5,,8,,,,,5,8,6,5,,,,,,,5,,,,8,,,6,,,,,,,,,,,19,,,,,19,,,
   ,,9,34,13,,,9,,16,,,5,,8,,,,,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,
   ,,19,,,,,19,,,5,5,8,7,7,8,4,9,9,5,5,4,10,7,10,,,5,7,
   4,12,7,8,,,,,5,4,8,10,,7,,10,12,,,,,,,7,12,27,27,11,13,
   6,13,12,11,14,14,5,5,5,8,8,7,7,7,5,5,4,10,7,10,,,5,
   7,4,12,7,9,,,,,5,4,9,10,,7,,10,12,,,,,,,8,27,27,27,8,
   12,8,12,27,11,30,30,7,4,7,4,5,7,5,5,5,3,5,6,5,,,5,
   6,6,9,6,6,,,11,10,5,3,6,5,11,6,,5,9,,,,10,11,11,7,8,
   5,5,6,7,5,7,8,7,8,8,5,7,5,5,8,7,5,5,4,10,7,10,,
   12,5,7,4,,7,,9,9,,,5,4,,10,,7,,10,,,12,,,,,11,17,12,12,
   8,27,8,27,17,8,27,27,7,7,4,7,6,5,5,3,5,6,5,,6,5,6,
   6,6,6,,,,10,8,5,3,,5,10,6,,5,6,,6,,8,10,10,6,5,8,8,
   7,8,7,8,5,7,8,8,9,7,10,9,8,8,6,8,9,8,,10,8,9,6,
   10,9,11,10,10,,,8,6,11,8,,9,,8,10,,10,,,,,9,,,,11,19,8,
   19,,10,,,5,7,9,5,5,4,10,7,10,,12,5,7,4,,7,,8,8,,,5,4,
   ,10,,7,,10,,,12,,,,,11,14,13,13,6,27,11,27,14,7,12,12,
   7,5,5,5,3,5,6,5,,9,5,6,6,,6,,6,6,11,10,5,3,,5,11,6,
   ,5,,,9,,10,11,11,7,8,7,7,5,5,6,5,8,7,8,8,9,8,8,6,
   8,9,8,,10,8,9,6,10,9,10,11,11,,,8,6,10,8,,9,,8,10,,
   10,,,,,10,,19,19,8,,11,,,9,,,10,10,4,9,6,9,,,10,6,4,,6,
   9,9,9,17,12,10,4,9,9,17,6,,9,,,,,12,17,17,8,10,9,9,
   8,9,8,9,10,8,10,10,3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,
   3,5,5,7,5,,5,4,,,,4,,,,5,11,11,4,5,,5,5,4,11,11,3,5,
   5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,
   11,11,4,5,,5,5,4,11,11,4,3,4,,3,3,3,2,3,3,3,3,3,6,
   4,3,2,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,
   4,4,5,4,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,
   6,,,5,,,,5,,5,,,5,,,5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,
   3,,5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,
   6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,4,,,,9,,4,3,,6,9,
   ,,6,4,,3,,6,,,13,6,,,4,6,13,6,6,5,9,9,5,4,,5,,5,5,,
   4,3,3,,5,,4,,5,,,4,,,7,7,4,11,5,5,,11,4,11,11,,5,5,4,
   ,3,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,
   5,7,7,5,5,5,4,4,6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,,6,
   6,8,4,4,4,8,4,8,4,4,8,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,
   9,9,5,9,6,6,13,,4,,9,13,6,6,5,,,9,6,5,3,5,5,9,3,,5,
   ,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,5,5,17,8,,3,3,
   5,17,,,5,,,,,,9,9,6,8,7,7,,8,6,8,8,,7,7,3,9,,5,3,5,
   5,9,5,,5,,,,,8,17,17,,7,8,8,6,7,,7,7,6,8,8,9,,5,3,
   5,5,9,5,,5,,,,,8,17,17,,7,8,8,6,7,,7,7,6,8,8,8,,6,
   17,,6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,
   ,,14,6,,6,6,12,,,3,,5,,4,,5,,,4,,,7,7,4,11,5,5,,11,4,
   11,11,,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,
   4,3,4,4,5,17,,,5,,,,,,9,9,6,8,7,7,,8,6,8,8,,7,7,,5,,
   4,6,,6,,6,,,5,,,,5,,5,,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,5,4,
   ,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,,6,
   ,6,,6,,,5,,,,5,,5,,,5,,,,4,,,9,9,5,9,6,6,13,,4,,9,13,
   6,6,,,,,,,,,,,,,,,,,,,6,,,13,6,,,4,6,13,6,6,5,9,9,,,,,,,,,,,
   ,,,,,8,8,12,,6,6,,,14,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,7,,
   ,5,20,20,7,5,6,5,5,7,14,14,,,8,8,5,8,4,14,,,4,5,,20,
   ,,5,8,8,5,,20,,,5,8,8,20,6,20,8,6,5,5,5,4,8,20,,,5,
   5,7,8,8,8,20,,,14,,,5,5,4,3,,4,4,5,4,,,4,4,6,4,6,9,
   4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,
   7,,,,,,10,10,,,,10,10,10,10,4,4,4,,4,4,5,4,,,4,4,6,4,
   6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,
   ,7,,7,,,,,,10,10,,,,10,10,10,10,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,4,4,
   4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,
   4,4,,,,8,8,8,8,8,8,8,8,8,8,8,8,,3,5,,6,6,7,6,7,6,
   6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,
   8,,,7,,,,,,10,10,10,4,4,4,,10,10,10,,,,,8,,8,,,,11,,11,5,
   ,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,6,8,,13,14,7,,,,
   17,17,11,11,11,7,7,11,17,,,,5,,6,6,7,6,7,6,6,7,6,9,
   4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,
   ,10,10,10,4,4,4,,10,10,10,,8,,,8,11,14,,8,7,11,5,,,5,
   5,,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,,,,,11,11,17,
   17,17,,,,11,11,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,4,4,5,9,7,
   7,7,,15,,4,4,,4,,5,,7,11,11,8,,,13,,16,9,8,16,12,7,6,
   9,14,7,9,5,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,,4,5,5,7,
   7,6,,,,,4,5,11,5,,7,7,7,,,,7,,,,8,16,10,9,8,7,4,7,9,
   9,5,6,5,4,5,4,8,6,8,4,5,6,4,6,6,,,5,6,12,7,7,13,
   10,,,,4,4,,6,,7,,12,,14,,,,,,,12,,12,13,10,4,7,17,7,7,
   7,4,5,4,4,4,7,4,4,4,3,4,4,,,4,4,5,,7,,7,,,,4,5,,5,,
   7,6,7,11,,7,7,,,,12,7,9,14,10,4,6,7,16,5,6,7,5,5,4,
   5,8,4,5,4,4,6,6,,,5,6,12,10,7,,,,,,4,6,14,6,,7,13,
   12,20,10,8,12,,,,13,,12,17,,4,9,10,12,7,9,4,7,6,8,7,
   4,10,8,4,8,8,,,10,8,7,18,7,8,13,,,,4,8,19,8,,7,12,7,
   11,12,12,11,,14,,30,16,16,28,30,7,6,6,28,7,8,6,4,5,
   7,4,3,5,4,5,5,,,4,5,5,7,7,7,7,,13,,3,4,,5,,5,,7,,10,
   ,9,,15,,14,9,14,9,9,5,9,6,14,6,7,7,5,8,4,5,6,4,4,
   6,,,4,6,12,,7,9,12,,,,4,6,10,6,,7,,12,,,14,16,,14,,19,
   13,17,19,29,9,7,4,,9,4,10,7,4,5,5,4,5,8,,,10,8,7,
   13,7,12,11,,14,,4,8,10,8,,7,8,7,15,14,16,12,,,,24,30,
   28,26,16,6,8,7,10,8,6,8,6,9,11,6,11,8,,,9,11,10,,10,
   19,19,,16,,6,11,,8,,10,11,10,,,,21,,16,,,,,,,10,9,7,,9,
   9,10,4,4,2,4,4,,,3,3,4,4,4,4,4,,5,,2,3,5,3,,4,4,4,
   5,5,4,4,,5,,8,7,7,8,7,4,7,4,7,4,4,7,4,4,4,4,,,4,
   5,5,5,5,6,,,8,,3,4,6,5,,5,5,5,6,6,,,,,,,10,,10,8,6,
   10,5,8,5,10,6,4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,
   5,6,6,,,,,,10,10,,,8,10,8,5,8,3,4,4,4,4,,,4,4,4,4,4,
   4,4,,,,2,4,5,4,,4,4,4,5,,4,4,,,,7,8,8,7,7,7,4,4,7,
   4,7,4,4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,
   ,,10,10,8,4,4,3,8,5,10,8,,,5,4,5,6,5,,5,,,,3,5,6,4,
   ,5,6,5,6,8,6,8,,8,,10,,10,,8,10,6,5,8,5,6,10,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,
   ,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,8,,9,8,,10,5,6,10,
   10,6,5,5,,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,8,9,,8,,10,
   5,10,10,4,4,3,,4,7,7,,6,,4,5,,5,,4,,4,8,7,8,7,,6,,,
   10,10,,,4,9,6,,9,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,,,6,,14,
   23,21,,15,,7,8,12,7,5,6,7,7,,8,,4,5,,5,,4,,4,8,7,7,
   8,,6,,,10,10,,,5,7,7,,5,4,5,4,,29,,4,8,8,6,,7,9,7,,
   6,9,8,,12,,17,,12,15,,7,6,7,,9,9,,,20,,4,6,8,8,,7,8,
   7,,5,,,,,,17,12,,15,,9,,7,,6,7,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,,7,8,,6,10,6,,,10,10,,,,14,,,,,,7,7,14,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,4,,4,4,4,,5,4,4,,5,,7,7,7,7,8,4,4,7,8,
   7,4,4,8,4,,5,,5,8,,6,6,,,,8,,9,8,10,4,3,4,,10,10,5,
   8,,,6,,,11,,9,,11,,,17,17,23,15,5,7,11,113,,7,,,5,,5,,,
   6,6,,,,8,9,,8,10,6,5,10,,6,10,5,,,,,,,,,,,,,,,,,,,,,,,,4,
   7,7,,7,,8,,,10,10,,,4,5,5,,7,5,7,,8,,9,,,,,14,23,21,,
   12,6,7,8,15,9,,10,7,7,7,,,6,,,10,10,,,4,6,9,,6,4,9,,
   8,8,,,,17,23,,17,,11,8,,19,11,7,5,8,8,,,,13,113,15,13,,
   11,5,7,,11,,7,4,,,,,,,12,13,7,8,6,14,10,9,9,,,,12,,,,
   13,7,9,,14,5,6,7,,,,,,,,,,,,,,,,,,,14,14,,,,,7,,7,,,,,,,,,,,,,
   ,,8,,8,10,8,,21,20,32,8,,,10,8,8,,21,32,21,,,15,21,21,
   ,8,10,8,,20,32,21,,8,8,10,21,24,15,8,10,8,8,4,4,8,
   6,8,6,5,8,7,6,8,10,8,6,7,15,21,24,4,5,4,,4,4,5,4,,
   ,4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,
   4,4,7,6,,6,,7,,7,,,,,,10,10,,,,10,10,10,10,4,4,4,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,
   6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,
   ,6,,9,,7,,,,,,,,4,4,10,10,10,,,,4,10,10,10,,4,,5,4,4,
   6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,
   ,6,,9,,7,,,,,,,,4,4,10,10,10,,,,4,10,10,10,,,,,8,11,8,,,,
   ,,11,8,,5,6,9,,8,6,5,5,8,,6,,,7,,,,,9,6,,8,,8,,,,,,,,
   11,7,11,11,11,11,17,17,7,,,,,,4,4,6,4,6,4,4,6,4,6,4,
   4,4,4,4,4,6,6,4,4,6,,4,,,6,,,4,4,6,4,,4,,6,6,6,,,,,,
   8,8,8,8,8,8,8,8,8,8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,8,,8,,,,11,,11,,5,,6,5,6,,,,9,8,,8,,,9,,
   ,8,5,7,,,6,,8,6,8,,,,,,,,11,17,17,11,11,11,,11,7,7,4,
   4,4,5,5,4,4,7,7,4,3,4,4,4,5,7,,4,4,4,,7,,,,,,4,5,
   7,5,15,5,,10,,9,,,,,,4,6,9,10,14,12,7,14,9,9,7,6,4,
   4,4,4,4,5,5,7,4,4,5,4,5,5,,6,4,5,5,,7,,,7,,,4,4,9,
   5,,7,,10,7,7,,,15,,13,7,4,10,8,9,8,16,12,6,7,6,6,5,
   4,5,4,8,6,8,5,4,6,5,6,12,,,4,4,6,,7,,,10,,,5,4,16,
   6,16,7,,7,,7,,,16,,,4,9,12,,17,13,,19,7,7,9,4,4,5,4,
   4,4,7,4,4,4,4,5,5,7,7,4,5,5,,7,,,9,,15,4,5,7,5,13,
   7,,10,8,,,,,,,7,6,8,12,16,16,9,8,6,7,6,6,5,5,4,5,8,
   5,4,6,5,6,12,10,13,4,6,6,,7,,,7,,,5,6,7,12,14,7,,7,
   13,10,,,,,14,10,4,,13,12,,12,13,9,10,4,9,7,6,8,7,10,
   4,8,10,8,7,13,8,4,8,8,,7,,,18,,,5,5,11,7,,7,,8,12,18,
   ,,,,16,7,6,16,30,28,30,16,24,8,7,8,6,4,5,7,4,4,5,4,
   4,5,9,,3,4,4,,5,,,7,,,4,4,,5,,7,,10,,7,,,,,15,9,7,12,
   14,7,9,14,10,6,4,6,9,5,8,5,4,4,5,4,6,7,,4,6,6,,7,,
   ,16,,16,5,6,10,12,,7,,7,,,,,,,16,7,9,13,19,,12,17,,4,
   4,9,7,7,5,4,5,10,8,7,18,12,4,8,8,,7,,,11,,,10,8,18,
   7,16,7,,8,8,13,,,,,,7,8,30,24,16,16,28,30,6,8,6,8,9,
   6,8,9,11,10,,10,6,11,8,,10,,,26,,15,9,8,26,10,16,10,,
   9,10,,,,15,,16,7,10,,,,,,,9,7,10,9,4,4,4,5,5,,,3,4,5,,
   5,,,,,,4,4,,6,8,7,,7,5,5,,,7,,,10,5,9,,8,8,,9,6,5,6,
   10,4,4,4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,5,4,,4,4,4,,,
   5,,5,7,4,8,7,7,7,8,7,4,4,7,4,5,4,5,,,3,5,4,,5,,,,,,
   4,4,6,7,,6,,7,6,6,,,4,,,10,5,,,8,8,9,9,10,3,4,4,4,5,
   ,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,6,,,,8,,7,6,10,,
   8,10,,10,8,5,6,10,5,5,6,,4,4,4,,5,,,6,,,4,5,6,5,4,5,
   ,4,5,,,,,,7,4,4,10,8,10,,,8,3,10,8,5,7,7,4,5,5,,4,,,,
   ,6,6,7,7,6,8,6,,7,,,,,8,,,4,9,10,,,,10,,6,6,4,9,4,4,
   ,5,,7,,,,,20,5,6,,,10,,,8,9,,,,6,,,9,,,,15,17,12,19,7,
   5,6,6,4,5,,,7,,,,,29,5,6,,,10,,,8,8,9,,,,,,7,6,12,,15,
   17,,19,7,10,7,10,4,4,,4,,,4,,5,4,4,4,4,5,4,,4,4,4,,,,
   ,5,4,7,7,7,8,8,7,7,4,7,4,4,4,,5,,,6,,,5,4,6,5,7,5,
   ,4,,6,,,,,4,10,8,,8,,10,10,8,5,4,4,3,,5,,,6,,,5,4,6,
   5,7,5,,4,,5,,,,,7,10,6,10,8,,10,,8,5,10,6,5,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,6,14,6,,7,,,,,9,,9,5,7,10,,
   ,,10,,7,5,4,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,6,7,7,22,7,,7,,,,,,,,,7,21,15,,14,23,15,8,6,
   5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,,8,9,9,,8,,6,,,,,,,7,,,,
   14,,14,7,,,,4,,5,,5,,7,,,,,,,8,5,6,8,9,,9,8,,10,10,5,6,
   ,5,,5,,7,,,,,,,,3,4,8,9,9,,8,,4,10,5,11,,,,,7,,,,,,,22,
   6,5,19,15,23,21,,15,7,,7,8,,4,,7,7,7,,,6,,8,6,4,,,10,
   10,,,9,4,9,6,9,,,,,,,,,,7,7,,,,14,14,,,,,,,7,7,7,,,8,,14,
   5,4,,,10,10,,,5,5,7,7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,9,
   ,9,9,9,,,6,6,,4,,,29,,10,10,7,17,19,,12,15,,10,7,6,7,,
   ,20,,10,5,6,17,19,12,,15,,6,9,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,9,,,14,14,,,,,,,7,7,,,,,,,,,,,,,,,,14,,14,,,,,7,7,,4,15,
   21,20,8,10,8,5,7,8,6,21,24,32,10,8,8,4,8,6,5,,,,8,,
   24,8,10,10,,,,,25,10,8,10,8,,,21,10,8,8,,,8,32,21,24,,
   8,20,32,21,10,21,24,25,6,5,7,4,5,4,5,6,6,5,,,,,10,,
   10,13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,9,6,,,,8,10,,,10,
   9,,,,,17,17,,,,17,17,17,17,5,5,5,4,,3,,,6,6,7,6,7,6,
   6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,
   6,,,7,,,,,10,10,4,4,4,10,10,10,10,,,,6,4,6,6,4,4,4,4,
   4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,,6,6,4,4,,4,
   6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,,,,9,,
   10,,,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,,,8,,,,10,,,,,,
   17,17,5,5,5,17,17,17,17,,,,,,6,6,7,6,7,6,6,7,6,9,4,
   6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,10,
   10,4,4,4,10,10,10,10,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,,
   6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,12,30,,,,,12,12,30,,
   ,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,
   ,,,,,,30,12,30,,,,,12,12,30,5,5,4,7,7,4,6,7,7,5,4,6,
   5,4,8,,,5,6,6,,9,10,,,20,,4,4,10,6,20,6,11,10,,10,7,,,
   ,,7,9,7,7,9,9,7,10,10,10,10,12,5,5,5,4,4,7,7,6,4,
   5,6,5,4,8,,6,4,6,8,,9,6,,,12,12,5,4,10,8,,6,10,10,,
   13,,,,,,7,7,7,7,7,7,7,9,9,10,12,7,7,6,7,6,4,5,4,7,
   7,6,7,4,7,,,5,6,6,,12,6,,,10,10,5,4,6,7,10,4,6,6,
   16,9,,,8,9,9,6,7,7,7,7,7,6,7,7,6,7,7,5,7,5,5,4,6,
   5,5,6,4,4,6,,10,5,6,8,,9,,,,,20,5,4,13,8,20,6,6,10,
   12,,11,,,,,9,7,7,9,7,7,9,7,7,9,7,9,7,7,6,7,8,5,7,
   6,7,4,6,,6,7,6,7,,12,,,,10,10,7,4,9,7,9,4,6,6,14,6,
   7,,6,8,9,7,6,7,7,7,6,7,7,7,7,7,7,7,5,4,7,6,7,6,
   7,7,8,,10,6,6,8,,9,10,,,,,7,7,10,8,,6,11,7,13,8,8,,,
   15,15,11,11,7,9,9,11,11,9,9,9,12,11,5,7,7,5,4,6,5,
   4,8,,8,4,6,8,,9,11,,,20,,4,4,,6,,6,,9,,7,8,,,,,10,9,
   9,9,7,9,10,7,7,7,9,10,7,4,7,5,6,5,4,7,,6,7,6,7,,
   12,7,,,9,10,7,4,6,6,9,4,,6,,,5,,8,6,8,7,7,7,6,7,7,
   7,6,6,7,7,7,7,7,7,6,6,7,6,,11,7,6,8,,9,8,,,,,7,7,
   8,8,13,6,10,8,11,13,12,,,,,8,11,9,10,7,11,8,8,8,12,
   11,8,8,8,8,8,4,7,,8,8,6,6,,18,8,,,10,9,6,4,7,6,10,
   4,8,7,,,,,9,12,11,7,7,8,11,8,7,7,7,7,11,8,8,5,5,4,
   4,4,,,4,6,8,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,,4,
   9,10,6,4,,4,4,9,6,10,5,4,4,4,,,4,5,5,,8,5,,,5,,4,3,
   5,4,5,4,4,4,6,4,,,,,,,4,10,9,6,4,,4,4,9,10,6,5,4,5,
   ,5,6,6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,5,5,
   6,6,5,5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,,,,,5,4,4,
   4,4,5,3,5,4,6,,4,,8,,8,4,,10,6,9,,4,4,4,6,10,9,4,,,
   4,4,4,,6,,,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,6,4,4,
   4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,4,5,3,
   5,4,6,,4,,,8,,4,,6,10,9,,4,4,4,6,9,10,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,5,6,,,8,,,,7,,4,3,5,4,5,4,4,4,6,5,5,,,,
   ,13,5,,,8,5,13,4,4,7,7,8,5,4,,8,,,,,5,4,4,4,4,5,3,
   5,4,7,7,4,,,8,,4,,9,6,10,,4,4,4,10,6,12,5,,6,5,,,8,
   8,5,4,5,5,8,4,6,6,,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,
   5,5,6,,8,5,,,5,,4,3,5,4,5,4,4,4,7,4,7,,,,8,,4,6,9,
   10,4,,4,4,10,9,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,
   8,6,8,8,12,6,8,8,,8,8,,8,8,8,9,9,8,8,8,9,9,9,9,8,
   8,8,,,,7,4,4,4,4,5,3,5,4,7,6,5,,,12,12,5,13,,8,,13,
   5,4,4,8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,6,5,6,5,5,6,4,7,5,9,,5,,,,,5,,,,,,5,5,5,,,,5,4,7,
   5,6,6,5,5,9,5,,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,
   8,4,4,6,9,10,4,4,,,10,9,6,4,4,6,3,,4,6,,3,,6,6,6,
   3,4,4,4,4,4,3,4,4,4,4,4,,,,6,,,5,,,,,,5,4,8,8,8,4,
   5,13,13,,,8,,4,,5,,5,5,,,,,4,4,10,9,6,4,4,,,9,10,6,6,,
   ,,7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,
   3,4,4,4,6,6,6,,,,5,,,,,4,5,8,,,5,4,13,13,8,8,8,,5,5,
   ,8,,,4,4,9,10,6,4,4,,,9,6,10,7,7,,35,20,16,7,7,11,
   16,29,7,7,,,29,10,16,4,,,,12,4,13,8,8,7,13,4,5,5,,,,,
   12,,,13,4,,,,4,13,5,5,7,8,8,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,
   6,5,,,,,6,,,,,,,6,,,,,6,,,,,,6,,4,9,19,13,4,3,4,4,13,13,
   9,9,13,19,3,4,4,4,13,9,19,5,5,9,9,13,13,4,4,4,8,
   13,19,13,13,4,4,4,19,13,9,9,4,4,4,4,4,4,13,9,19,4,
   4,13,13,9,3,19,19,13,19,19,13,5,8,5,,,5,,,,8,8,,11,7,
   8,,14,11,,8,5,5,9,6,8,6,,5,8,,6,9,9,,,,5,,,,,8,,6,,,,
   8,,,,11,7,,,,17,17,17,7,11,11,11,3,,,,,9,6,,9,,,6,,9,,,
   6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,12,12,,,,12,
   30,12,30,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,
   ,6,,,,9,,6,,,,9,,,,12,12,,,,12,30,12,30,,,,,,,9,11,,,8,10,
   ,8,10,,6,5,6,,5,8,,,5,8,,6,,8,,,,8,9,,,,8,10,8,10,11,
   11,10,,,,17,11,,,,7,7,11,17,11,11,11,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,9,9,,,10,14,10,7,13,,8,,14,13,,,8,,,81,81,9,12,11,,,
   14,19,15,26,15,,,,,,,55,,,,,55,18,13,12,7,8,,6,,7,7,9,7,
   ,8,8,14,8,15,,,,8,,,9,9,,,135,,14,8,8,,,10,,,,21,,,,,,8,
   17,,,,20,17,25,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,,7,,14,8,8,8,,,9,,8,15,,9,,,,,135,15,8,17,,69,
   10,13,,26,16,18,23,,,,20,17,,,,8,17,24,19,,8,,10,8,,10,,
   10,12,10,,15,,,,12,15,,,,,,,,11,10,17,,60,12,18,12,19,16,
   14,19,,,,13,30,,,,13,30,,17,8,12,7,,,10,,13,14,13,10,21,
   20,10,,22,15,,15,10,,,43,,,,,,,14,,,,,,,,,,,119,,,,,,41,46,
   15,10,12,9,7,,12,7,12,7,,14,10,,7,,,11,9,,,,,,7,13,,,8,,
   ,,,11,24,,,,14,17,,,,13,16,11,13,,11,11,,,15,16,17,,15,,
   11,,18,11,,16,11,19,,,,17,18,17,,68,16,,21,26,27,,,,,,10,
   33,,,,,55,,86,13,18,10,,,10,,11,16,,9,,10,,,10,8,,,,,16,
   11,,,,10,13,16,,,,,,,,14,25,,,,20,15,25,20,10,10,10,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,6,5,5,,6,6,,6,5,,,16,
   ,6,5,4,,24,,,,8,7,,,,,,20,7,,,,11,16,22,23,5,11,7,6,5,
   6,,4,,6,6,,6,5,,,12,,6,5,,,,4,4,,8,7,5,,,,,15,8,,,,7,
   15,15,15,4,5,5,5,6,,5,,,6,,6,5,5,,,16,,,6,,19,6,7,6,,
   ,7,8,,,,11,16,,,,20,7,17,31,7,11,5,,7,,,5,,,6,,7,,,,5,
   5,6,,10,5,6,5,8,8,8,8,,,,11,11,,,,11,11,7,7,,5,,8,5,,
   6,,,,,8,,,14,6,5,7,,10,6,7,5,10,9,7,9,,,,17,12,,,,16,
   31,11,7,7,5,11,5,,,8,,8,7,,,,24,,,6,,,,,,,,,,,,,11,,,,,19,
   14,,,7,8,7,,5,,,5,,7,,13,14,5,4,6,,9,4,4,4,8,7,6,6,,,
   ,13,8,,,,7,16,6,6,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,
   6,4,,,,12,,6,7,,,6,7,6,,,7,8,,,,7,15,,,,15,8,15,15,5,
   5,4,,,5,8,,14,,6,5,7,,20,6,7,6,9,7,9,10,,,,16,31,,,,
   17,12,8,9,11,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,,,6,5,
   7,,14,6,7,6,10,7,7,10,,,,21,11,,,,21,11,9,9,5,4,5,5,,
   14,13,4,5,5,,10,5,6,5,6,7,7,8,,,,7,16,,,,13,8,7,7,6,
   6,,,24,,,6,,,,,,,,,,,,,,19,14,,,,11,,,,7,8,7,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,24,,21,,,12,17,12,,,13,19,,,,14,,,,,,14,24,17,,,,
   20,10,,,,,,19,23,21,,,,,,,14,,,,14,,25,19,,,,,,,,6,,6,,5,7,
   8,,,,11,22,,,,17,8,20,20,11,7,5,5,,,5,,5,,,6,7,,,,6,29,,
   ,,11,7,11,29,,,5,,,,,,,,,,,,,21,9,,,,14,17,,,,16,7,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,24,19,,,,14,25,,,,,,4,,8,7,,,,,,16,8,,,
   ,7,16,16,16,6,10,10,,,,5,,,,,16,10,,,,9,16,,,,10,10,8,7,
   ,,,,,22,13,,,,7,23,20,16,5,7,11,,9,10,,,,13,,,,,,13,,26,
   14,9,6,8,9,,,,12,,,,,,9,23,23,,,7,,,,,,9,,,,8,,19,19,7,,,,
   ,,,15,,,,11,,,20,6,9,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   11,,,,19,17,19,16,18,18,13,,,,17,11,19,29,23,11,8,,,,,,,,,
   ,,,,,,,,,,,,,,,,11,11,11,13,11,11,16,11,10,10,10,17,11,
   13,18,8,15,10,5,5,5,,4,,5,4,4,6,4,6,9,4,6,9,12,4,
   4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,
   10,10,10,,,,4,10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,
   6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,10,10,4,4,4,10,
   10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   8,11,8,,,,,,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,,
   6,7,8,,,8,6,,,,,,7,11,7,11,11,11,,17,17,17,4,4,4,5,5,
   4,4,7,7,3,4,4,4,5,5,11,,3,5,5,,5,7,7,,15,,4,5,,5,,
   7,9,7,,,7,,,13,,6,7,5,6,9,14,9,12,7,14,9,14,4,4,4,
   4,4,5,5,7,4,4,5,3,4,5,,11,4,4,5,7,7,7,,,,,4,5,,5,,
   7,7,7,,,,6,,,,5,6,6,7,6,9,10,14,7,12,14,16,5,4,5,4,
   8,6,8,4,4,6,4,6,6,,,5,5,12,14,7,14,14,10,,,4,6,,6,,
   7,16,12,,,,,,,,9,4,9,4,7,17,29,19,10,19,31,,4,5,4,4,
   4,7,4,4,5,4,5,5,,,4,5,5,,7,,6,11,,,3,5,,5,,7,7,7,,,
   7,7,,,,9,5,7,7,4,10,8,9,6,8,16,9,5,5,4,5,8,4,5,6,
   4,5,6,10,20,5,6,12,9,7,,,14,,,4,6,,6,,7,12,12,,,10,13,
   ,,,7,9,4,10,9,29,,17,4,13,,12,7,6,8,7,4,10,8,4,8,8,
   14,15,10,8,7,16,7,11,12,10,,,4,5,,8,,7,12,7,,,13,8,,
   14,,8,6,6,7,8,28,16,26,8,24,30,10,4,5,7,4,4,4,4,4,
   4,11,11,4,5,5,8,5,7,7,,13,,4,5,,5,,7,,7,,,9,,,15,,7,
   9,7,9,6,8,12,16,5,16,9,14,5,8,4,5,4,4,6,6,14,,5,6,
   12,,7,10,13,,,,4,6,,6,,7,,12,,,7,,,,,7,7,10,7,4,,13,12,
   7,,12,17,7,4,10,8,4,8,6,10,11,10,8,7,12,7,13,8,19,
   14,,4,8,,8,,7,11,7,,,18,12,,,,7,8,7,6,6,16,30,28,6,
   30,10,28,6,9,11,6,11,8,,,9,11,10,,10,19,19,,16,,6,11,,
   8,,10,21,10,,,,11,,16,,9,9,10,7,9,,,,10,,,,4,4,2,4,4,5,
   ,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,4,,,4,4,,5,,7,4,4,
   7,4,7,8,7,4,7,7,8,4,4,4,4,,,4,5,5,5,5,,,6,8,,3,4,,
   5,,5,5,5,,,,6,,,,10,6,10,6,5,9,,8,5,8,,10,4,4,4,,8,
   4,5,5,6,5,6,8,8,,,3,4,,5,,5,6,5,,,6,,,,,10,10,4,4,3,
   9,10,8,5,8,,,4,4,,5,4,4,4,4,4,4,4,5,,,2,4,,4,,4,4,
   4,,,4,4,,,,4,7,7,4,4,8,7,7,4,7,8,7,4,8,,5,4,5,6,5,,
   ,6,,,3,5,,4,,5,6,5,,,,5,,,,4,4,10,10,5,,,8,3,8,9,10,,
   ,5,4,5,6,5,8,6,8,,,3,5,,4,,5,6,5,,,5,,,8,,6,10,6,
   10,5,,10,8,5,8,9,,,6,8,7,8,7,5,6,11,,,5,6,,8,,7,8,7,
   ,,9,,,,,11,,11,7,5,15,,17,7,17,113,,6,6,8,8,7,,,,,,5,6,
   ,6,,8,8,7,,,9,8,,,,11,7,11,,8,,,17,5,17,23,19,4,5,,5,
   ,6,6,,,4,4,,4,,5,,5,,,5,5,,8,,5,10,6,5,10,,8,10,6,,
   10,8,5,8,5,6,,6,,,4,4,,4,,5,6,5,,,6,6,,,,5,10,4,3,4,
   10,8,10,8,,,8,8,4,7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,9,4,
   4,6,9,10,,,6,,10,,,,9,,,,4,,,6,,7,4,7,,,8,9,,10,,10,9,
   7,6,8,,13,12,9,,,14,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,
   5,4,5,5,10,,,7,,10,,4,8,,,4,,,5,,7,,7,,,,8,,16,,6,7,8,
   7,,15,,21,5,23,12,,8,12,,4,5,,,,7,8,7,,,,9,,29,,9,9,8,
   7,6,12,,21,,23,15,,11,,5,6,,6,,,9,,,,5,6,,7,,,7,5,11,
   7,17,15,17,,,17,113,,5,,,8,,6,,6,,,6,,,,,7,,,,,,14,14,7,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,5,,4,4,4,4,
   7,7,7,8,7,8,7,7,,4,,5,,5,,,6,6,,,,3,4,10,5,8,,8,,4,
   10,10,8,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,6,6,,,,5,6,10,5,6,
   10,8,,10,10,,8,,,,,,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,
   10,,,5,,10,,,,,,,,10,,5,6,7,,9,,13,,7,12,,14,,,,,,6,,6,4,
   4,9,6,10,,,9,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,7,5,,
   8,7,21,15,,6,14,23,12,,10,,9,,6,8,7,21,12,,10,14,23,
   15,,,,,,,,,,,,,,,,,,,7,7,,,,,14,,14,,,,,,,,,,,,,4,6,8,7,8,10,
   8,5,21,21,15,8,6,6,10,8,8,4,21,15,21,4,4,15,21,21,
   6,8,10,8,5,21,15,21,7,8,8,10,21,24,32,8,10,8,8,,,8,,
   8,,,8,,,8,10,8,,,32,21,24,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,
   9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,12,12,,,,12,30,12,30,,
   ,,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,
   ,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,10,10,10,4,4,4,,10,10,
   10,6,17,,9,,10,,,10,13,8,9,,6,,8,,10,,,6,,9,8,,5,,,,,8,,
   ,,12,,,5,,,10,,,,5,5,17,17,17,,,,5,17,17,17,,,9,,10,,,9,
   ,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,17,17,
   17,5,5,5,,17,17,17,5,5,4,7,7,4,6,7,7,4,4,4,5,6,6,
   7,,5,4,8,8,6,,13,,,,5,6,,8,,9,,10,8,,,,,20,,7,9,9,7,
   10,9,7,9,10,10,9,7,5,5,5,4,4,7,7,6,5,5,4,4,6,8,,
   12,5,4,8,11,6,,,13,,,5,6,,6,,9,,10,10,,,6,20,,20,9,7,
   7,7,9,7,7,9,9,9,7,7,7,6,7,6,4,5,4,7,7,4,5,6,6,,,
   5,4,7,5,4,,7,6,6,8,7,6,,7,8,12,,6,6,,,,10,9,9,7,7,
   7,6,7,7,7,6,7,7,7,6,5,7,5,5,4,6,5,4,4,5,6,8,13,,
   5,4,8,,6,,6,10,,,4,6,,8,,9,,10,7,,,10,12,,,10,9,7,9,
   7,7,7,7,7,7,7,9,7,7,6,7,8,7,7,4,7,6,7,6,14,7,4,
   7,7,4,,,9,8,6,5,6,,6,9,12,,6,6,,,6,10,10,9,7,7,6,7,
   7,7,7,6,5,7,6,7,7,5,4,7,7,7,7,6,6,8,13,11,7,7,8,
   12,6,,8,,,,7,6,,8,,9,,8,11,,,10,,,,8,8,11,15,8,9,7,10,
   8,8,11,15,5,7,7,4,5,4,5,6,6,10,,4,4,6,7,6,,10,10,,,
   5,6,,8,,9,,10,,,,11,,20,20,10,10,9,10,7,7,9,7,12,7,9,
   10,7,4,5,5,4,7,6,7,9,16,7,4,6,,4,,6,6,9,8,7,6,,7,
   9,12,,6,,,,6,10,10,10,6,7,7,7,6,7,7,7,7,6,7,7,7,7,
   6,7,7,6,8,8,13,7,7,8,8,6,,10,10,15,,6,6,,8,15,9,,7,
   10,,,11,,,,9,12,8,9,11,7,9,9,11,11,8,9,6,8,4,8,6,6,,
   ,8,4,6,,4,,8,7,12,9,8,8,,7,11,18,,7,8,,,8,9,10,10,
   11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,5,5,5,,4,3,4,5,4,
   ,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,10,9,4,,4,6,10,9,6,4,
   4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,,4,6,,8,,8,,4,5,,,5,
   5,,5,10,6,,4,4,9,10,6,9,4,,4,4,4,4,,6,3,3,3,3,3,,
   4,4,6,6,3,4,,4,6,6,,4,3,,,,4,6,6,4,4,4,4,3,4,4,4,
   4,3,4,4,5,4,,6,4,4,4,4,3,,,4,,8,4,5,,5,8,8,,4,5,,,
   5,5,,5,6,10,,4,4,10,9,6,9,4,,4,5,5,,5,4,5,5,4,,5,
   5,5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,5,5,6,6,6,5,5,6,
   6,6,6,6,5,,4,3,4,5,4,,4,,,,4,5,,4,,8,,5,4,,,,5,5,,9,
   10,4,,4,10,6,9,6,4,4,,7,4,4,4,4,3,,6,5,,,4,5,,,12,8,
   ,5,5,,,,5,,7,,,13,5,4,8,7,8,,4,13,5,6,5,7,7,6,,7,,
   20,35,6,,,6,16,,,,6,,,,9,9,,29,10,7,,7,11,29,16,16,7,7,
   ,4,5,,4,,5,5,,,5,5,,4,,8,,4,,,,4,,5,5,9,10,4,4,,10,
   6,9,6,,4,4,4,4,3,,,3,6,6,4,4,,4,6,6,,3,,,,3,6,6,4,
   4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,6,,4,8,8,,4,,,
   ,4,,5,5,10,9,4,4,,6,10,9,6,,4,4,,,5,,,12,,5,,4,,8,,
   5,5,,,5,,5,7,7,8,4,5,13,,,,8,13,4,5,,3,,6,6,4,4,,3,
   6,6,,4,4,,,4,6,4,6,6,6,3,4,4,6,6,6,6,4,3,4,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,12,,5,6,,,12,8,,4,,,,5,7,,5,8,8,13,
   4,5,,,8,8,5,13,4,,,5,6,,4,,8,,,5,,,6,7,5,,,,4,13,5,8,
   8,8,8,5,4,13,5,,5,,8,5,8,,,,,,,,,,,,,,,,6,,6,,,,8,6,,,8,
   8,,8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,,,,4,,5,5,9,6,4,4,,
   9,6,10,10,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,5,6,6,6,5,
   6,5,5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,5,5,,5,6,9,,
   4,4,6,9,10,10,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,
   12,12,8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,
   5,5,,9,6,4,,4,9,6,10,10,4,4,,,,4,,7,5,7,7,5,4,13,,8,
   ,8,13,5,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,13,4,
   8,,,8,4,5,13,6,6,,,5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,
   ,5,,,,,5,5,,5,13,19,13,4,4,4,8,13,13,19,9,9,13,4,4,
   4,5,13,9,9,4,4,9,19,13,19,4,3,4,4,13,9,13,13,4,4,
   3,9,13,19,9,3,4,4,5,5,4,9,9,13,8,4,13,19,9,4,19,
   13,13,9,19,13,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,13,,22,,,,,,10,22,
   16,19,15,16,,,,,,10,10,12,,22,12,18,,31,,,,,,,41,15,10,
   13,49,20,,22,,,,,6,,,8,,8,12,,7,,7,,,,10,7,17,18,11,13,,
   26,128,,,7,10,,,8,11,,,15,,,,,,13,11,,11,,16,20,14,20,,,,
   9,,,,,10,13,,14,10,10,,19,12,,22,12,,,,,20,,164,,,10,16,
   43,22,,,,,30,,,,,,13,11,11,15,41,22,,20,,,,,,6,,6,,,7,13,
   10,,,17,13,7,10,,8,,,,37,,,10,8,10,25,7,17,14,,12,,19,,,
   ,16,14,9,,9,14,14,11,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,12,,
   7,10,7,,18,11,,7,,,11,13,,17,,,,7,9,17,,8,,,,,,24,,,,14,
   16,,,,11,20,13,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   10,,12,12,6,,,14,12,12,10,,8,11,,,52,,,6,7,10,63,12,14,
   16,,,,24,,,,19,14,10,8,10,11,14,19,14,,,,,,,,,,,6,6,6,8,
   6,4,,,24,,,5,5,6,20,6,7,6,,,9,9,,,,20,17,7,11,5,22,
   20,11,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,6,6,
   6,8,6,,,,,,,5,5,6,12,6,7,6,,4,7,,,,,15,15,5,5,4,15,
   15,7,8,,,,,,,5,6,6,6,8,6,,,,,19,,5,5,5,16,6,7,6,,,6,,,,
   ,17,20,11,7,5,16,31,11,7,,,,,,,5,5,5,7,5,,,,,,,5,4,5,
   10,5,6,5,,8,8,6,,,,11,11,,,5,29,29,6,7,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,169,,7,8,9,19,10,9,
   8,,,11,,,,,,,14,9,6,20,152,13,10,,,,7,7,9,9,7,,,,,,,6,7,
   6,17,8,8,7,,,,,,,,,23,,,7,18,125,12,8,,,,6,5,,,,,,,10,,,
   4,6,14,6,5,,,,7,,,,,11,16,5,7,11,12,7,17,31,,,,,10,6,7,
   ,8,12,,,5,5,,,4,7,6,,7,,8,,,,15,7,5,4,5,8,15,15,15,,,
   ,9,6,7,,8,12,,,5,5,,19,,6,6,,7,,8,,,,20,7,7,5,11,13,
   16,22,23,,,,,,,,,19,,,6,10,,10,,,,,12,,,,,13,20,6,9,14,,10,
   ,152,,,,7,,,,14,,6,4,6,,6,,,,7,7,,,,,9,21,4,5,5,11,9,
   21,11,,,,,,,,,5,5,7,27,7,,7,,,10,10,,,,21,,7,13,,,21,14,
   10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,,,,,,,7,
   8,7,,15,14,17,,,,,,,10,16,,12,,14,,,17,,,,,24,,,,,,17,14,
   14,,,,,10,13,24,,,11,20,,,,31,,,,,14,,,,19,,24,25,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,5,,5,,,,,6,,,,,7,11,5,,,11,7,11,11,,,,,
   25,,7,5,,6,,7,,,,8,6,,6,6,7,8,13,16,,,,,,9,6,,7,5,8,,,
   ,22,11,11,5,7,7,23,20,16,,,,,,,,17,,,,,,25,14,,,,14,19,,,,
   ,,8,6,,7,,8,,,,16,7,10,6,10,8,16,16,16,,,,,,,11,,,,,12,
   18,7,,,13,8,,125,,,,,7,7,,,,,8,17,5,11,7,31,9,16,12,,,,,,
   ,,,,,,,,,,,,,,,,8,,,,,16,,10,10,,,16,9,10,,,,9,,,,,12,,8,,8,
   ,25,20,,,,,,,23,,7,8,7,,13,,23,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,11,13,11,18,19,17,19,16,,,,11,13,11,17,11,19,11,
   ,,,5,5,11,10,18,10,,,,5,23,8,18,10,,,,8,10,13,10,,,,29,
   11,11,,,,16,11,,,,17,,,,,,,,,,,10,,,9,,8,,11,8,10,8,,9,6,
   5,,11,10,6,,8,11,8,8,,,,,,5,,5,,6,10,8,,8,,10,,,,11,11,
   7,11,7,,,,11,17,17,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,8,8,5,6,6,5,6,5,5,6,7,5,5,8,4,16,,7,8,8,
   12,7,12,11,,,,6,8,15,4,,7,15,10,10,20,8,,,,,10,31,8,6,
   7,10,6,7,23,18,27,27,8,8,8,6,5,6,6,7,6,7,8,6,8,4,,
   16,7,5,8,10,7,8,,8,,13,5,8,20,4,,7,12,10,13,11,,11,,,
   18,27,10,5,7,8,6,6,10,31,27,27,16,6,4,6,6,7,4,7,5,
   7,6,8,6,6,,,7,6,8,13,7,10,10,15,,,8,6,16,6,,6,13,6,
   11,10,,,,,,32,17,7,10,10,8,10,14,20,14,,14,8,6,8,8,6,
   7,5,7,8,6,5,4,11,13,7,8,8,,7,,11,20,,,6,8,11,4,18,
   7,11,10,16,,10,12,13,,,27,27,6,10,6,6,8,7,16,27,16,
   31,6,6,4,6,5,8,7,5,5,6,5,15,9,7,6,8,10,7,,,12,,,8,
   6,10,6,12,7,10,6,9,15,10,10,,,,,32,10,8,7,10,7,8,17,,
   14,17,5,4,4,5,7,5,6,7,6,4,8,10,8,7,8,9,7,7,9,10,,,
   7,7,9,4,,6,9,6,8,10,9,7,,,15,13,7,7,7,6,7,7,5,20,
   9,13,7,8,6,5,6,7,5,5,8,4,20,10,7,8,8,8,7,10,12,15,,
   ,6,5,,4,,7,,8,,16,12,15,,,,18,27,10,7,6,8,7,6,27,10,
   31,23,6,7,8,7,6,8,6,6,10,11,7,6,8,,6,10,10,17,,,5,
   6,15,6,,7,,6,,,13,13,,,,14,,8,11,10,7,10,10,14,32,17,
   20,5,7,8,7,7,7,4,10,8,5,6,8,9,6,9,7,9,,,7,6,10,4,
   15,7,7,6,10,8,9,9,,,,9,13,7,5,7,7,6,7,7,13,7,10,6,
   8,8,6,8,4,,10,8,8,7,,8,16,16,17,,12,6,8,17,4,15,8,
   20,6,10,,,20,12,,15,10,30,7,7,8,7,8,7,31,10,30,31,5,
   5,4,4,4,6,,6,4,7,,7,,6,,,,4,4,6,3,7,5,6,5,6,6,8,8,
   8,,,,9,5,10,6,6,10,5,8,9,8,,5,5,5,4,8,8,6,7,7,7,6,
   7,,7,,,6,5,,4,8,4,7,5,,7,,7,8,,6,,10,9,4,6,4,9,6,,,,
   10,4,4,4,,6,5,5,4,6,5,6,8,8,,7,4,4,6,4,,5,8,4,6,,
   6,,4,,,8,10,4,4,3,8,5,10,10,8,,,5,4,,6,5,5,4,6,5,8,
   8,6,,7,4,4,6,4,8,5,,4,6,,6,,7,,8,8,,10,6,5,10,5,6,
   10,8,,10,4,6,,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,
   8,6,,,,,,5,10,10,4,4,3,8,9,8,9,5,5,4,3,4,5,4,6,5,6,
   ,5,3,4,5,2,5,4,5,4,5,6,5,6,5,,,7,8,4,7,4,7,4,4,
   7,7,7,8,8,7,8,5,8,7,10,10,9,,10,6,,8,6,,7,6,8,10,,
   9,,7,,14,11,,10,8,5,,6,11,12,13,,,,6,6,6,,,9,,,,6,6,9,
   5,7,8,8,6,6,10,7,9,,,,,,6,,10,7,9,5,17,12,17,26,5,7,
   ,4,,7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,,4,6,9,9,6,
   4,10,,10,,7,8,5,6,,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,9,8,
   4,3,4,5,10,10,10,,,8,6,7,10,10,10,,,7,4,10,4,8,7,5,
   4,6,5,6,5,,,8,,9,6,6,,6,,6,9,,9,9,,,10,,,,8,6,10,5,
   10,7,8,6,7,9,6,10,,,,15,19,5,7,9,,10,6,17,16,17,,,7,,
   ,14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,,4,5,5,7,7,5,10,
   ,10,,8,6,,,6,8,8,5,7,7,10,6,9,10,10,8,,,,,,6,21,,9,
   7,5,17,26,17,12,8,,,,6,6,6,,,8,6,,10,,10,,,7,26,13,9,
   5,7,6,,10,12,,,13,,,6,6,8,5,10,7,9,8,9,8,10,10,14,,
   78,,12,5,10,8,11,,7,17,26,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   4,14,5,9,9,7,7,,7,,10,,,,,14,,,,7,,7,14,,,,5,,4,,7,8,5,
   ,6,,6,,,7,9,8,6,5,10,5,6,10,,,10,8,8,4,,5,,4,6,,6,
   8,7,,,8,,8,10,5,4,3,4,,8,10,10,6,78,,10,8,,9,,9,,,10,
   26,13,11,7,,5,8,10,,,12,13,,4,6,4,5,5,5,5,5,,5,7,7,
   7,4,4,4,4,7,8,7,8,7,9,,,,14,,,,,,14,14,,,,7,7,,,,,,8,5,
   ,7,,7,14,,8,,10,7,5,7,4,5,5,,,,10,,9,,10,,10,,,11,,10,
   ,6,7,5,9,,13,12,,6,8,6,,7,,,8,10,6,10,5,6,5,10,,8,
   10,,8,6,8,,,7,12,17,7,5,9,6,10,,26,,,17,8,6,10,,,13,,,
   11,6,10,5,8,,11,,12,8,,,10,16,17,,6,10,5,9,7,,15,19,
   17,7,,,13,12,7,9,5,10,6,,,11,,,,9,,,7,7,,,,,,,14,14,,,,,,,
   ,,,,,,,,,7,,7,,,,,14,14,,,24,21,25,8,10,8,,,,,21,15,24,
   10,8,8,,,,8,4,4,6,5,8,32,8,10,8,5,8,6,7,21,8,8,10,
   5,7,6,21,10,8,8,4,4,8,24,21,32,5,8,25,24,21,10,21,
   32,20,,8,,,,,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,
   ,6,9,6,6,9,,,,,,,,30,12,30,,,,,12,12,30,,,,,,,7,10,10,,,,
   13,22,,,,13,10,15,,14,,10,,,,,14,,21,,15,,,10,20,,,,43,,
   15,10,,41,,,,,12,,119,46,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,9,6,9,,7,8,7,,,7,12,7,,,,12,7,,11,8,,9,13,,,,
   7,,,,11,24,,10,14,,,,,,,11,13,11,16,,,,11,14,17,13,,9,,,,,
   9,,12,10,14,,15,26,10,7,13,,14,,8,11,,,,14,,13,,,,15,8,,
   ,19,81,81,,12,7,,18,55,,,,8,,55,13,,,6,,7,15,,8,8,8,,
   16,26,14,8,15,18,10,,,17,,,,8,,,,9,23,,9,,,13,135,,,,8,
   13,24,17,,,,,20,17,19,,9,,,17,,18,17,18,,27,26,15,,11,,
   16,19,11,17,,,,16,,15,,16,,21,11,,,,,,68,13,18,,,55,,,,10,
   10,33,86,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,14,,8,
   14,8,,21,,8,8,,,10,,9,8,,,,8,,15,,9,,,,,,,,135,,,,20,25,
   17,,,,,8,17,20,10,11,,10,10,12,,16,19,10,,15,14,12,,,17,,
   ,,12,,15,,,19,12,,,,18,,,60,8,12,12,,30,,,,7,13,30,17,16,
   ,11,,10,,,,,11,,,10,,8,,,,,10,,16,,10,,16,9,,,13,,,,10,10,
   25,25,15,,,,10,14,25,20,,,,,,5,,6,5,6,7,6,,4,,,,,6,,6,,
   6,8,6,5,,,,20,24,,11,7,17,20,8,,,,5,11,22,20,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,5,6,5,6,5,5,,,,5,,5,
   ,5,7,5,4,,,,10,,,,,11,11,7,,,,5,6,29,29,,,,,5,5,6,7,6,
   5,5,6,,,,6,,6,,6,8,6,5,,,7,20,,19,7,11,20,17,7,,,,5,
   11,16,31,,,,6,5,6,7,6,,4,7,,,,6,,6,,6,8,6,5,,,7,12,,,
   5,5,15,15,8,,,,4,7,15,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,7,8,7,8,7,,7,,,,,7,,9,,7,9,7,7,,,,21,,,,,,23,9,,,,7,
   12,,23,8,8,9,9,8,,6,,,,,8,,10,,10,10,8,8,,,,23,,,14,9,,
   ,13,,,,6,13,,26,5,6,,,,5,4,,,,,,6,,6,,,5,5,,,,16,24,5,
   11,13,22,16,,,,7,20,7,23,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,
   ,,10,,5,29,7,29,,,,,11,11,7,9,6,8,5,7,,,,6,,,,,10,6,,8,
   ,7,,14,20,11,5,17,8,12,,,,7,16,31,9,,,7,,,,,5,,7,,7,,,
   6,,,5,,13,,7,,9,19,,,,,,,9,19,,5,,,,,4,,6,,6,,,4,,,4,,12,
   ,6,10,8,16,16,,,,10,16,8,16,5,,,,,,,8,,8,,,7,,,,,21,,7,
   8,13,,,,,,7,19,14,,5,,,,5,,,,5,8,5,,7,,6,13,14,10,6,6,
   13,7,8,,,,,7,16,7,,,,,,7,,7,,,6,6,,,,21,,,16,17,,17,,,,7,
   21,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,6,,6,,,4,,,4,,12,,4,5,8,15,15,,,,5,15,8,
   15,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,5,8,,7,24,,10,7,5,16,11,31,
   ,,,11,17,20,7,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,7,,,14,5,4,
   21,9,11,,,,5,21,11,9,,6,,,,,19,,6,9,11,,,,,,14,,15,20,4,,
   ,,19,12,,5,7,7,20,23,,,,11,22,13,16,5,,4,25,13,9,,6,
   8,6,16,,,,6,13,8,6,,,26,,,7,8,23,,14,,,,7,11,,,,,,,,,,,,,,,
   ,,,,,17,,,10,10,,16,,,,10,16,10,,,,,,25,25,,,,,,,24,19,,,,,
   24,14,,,,,14,,17,,,14,,25,,,,,24,19,,5,13,11,10,,,,5,18,
   23,8,11,13,10,,,,5,18,11,10,11,29,,,,11,19,17,11,16,,,,
   18,19,19,17,,,,10,17,11,11,,,,,,,,,,,,,,,,13,11,10,11,16,
   29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,
   ,,,10,22,16,,,,10,12,30,22,,,10,,,13,14,20,,,,,,12,19,,,
   164,,43,,,41,,22,11,15,11,,,13,20,,6,,,8,,8,,,7,10,7,17,,
   ,,7,,,8,,13,9,,,12,7,17,,,11,24,,11,18,,,,,,,,11,13,20,,,,
   ,14,16,20,9,,,,,10,,10,10,,22,12,31,,,,16,,22,,16,10,,,
   13,22,,,,15,,18,,,19,12,,,,,,49,,20,15,13,10,,,41,22,,,6,,
   6,,13,10,13,7,10,12,,,10,10,,7,,,8,,,,7,,,,8,19,14,17,,,
   17,,37,25,,,14,11,14,9,9,,,16,14,14,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,8,,10,7,,7,,15,,,7,17,,8,,13,10,,,12,7,26,,,11,,,,,18,
   11,,128,,,,16,20,20,,,11,,13,11,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,12,6,12,12,10,,,,6,10,,12,,11,7,,,10,12,,,
   ,8,24,16,14,,,14,,52,63,,,11,19,14,10,10,8,,19,14,14,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,6,,,,5,5,7,6,,,4,,
   ,6,6,,,,,,,7,8,,5,10,,14,,,12,17,7,5,11,7,,11,16,31,5,
   5,5,,,,5,5,6,5,,5,5,,,5,5,6,,,6,,,6,7,,,10,,,,,29,29,
   7,5,,,,7,11,11,6,5,,,,,6,6,6,,,5,,,,,,,,6,,6,5,,8,7,19,
   ,16,,,16,13,31,11,5,7,,17,20,7,,7,,,5,,,4,,7,5,,,6,6,
   8,,,6,8,6,7,10,10,7,,12,,,,8,15,15,5,5,4,,15,7,15,7,,
   ,5,,5,,,7,,,,6,6,8,,,6,8,6,6,9,10,9,24,20,,,,7,20,23,
   11,7,5,,22,11,16,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,,17,,,,
   10,16,10,,10,,16,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,
   10,,,29,7,29,,5,,,11,11,7,,,,7,5,,,6,6,8,,,6,8,6,9,10,
   9,6,,12,19,,,13,22,16,7,11,5,,20,7,23,,,10,,,,9,7,11,,,
   7,9,7,,11,12,11,,21,,,,8,25,,,,8,,,12,20,,7,,,,6,6,8,,,
   6,8,6,8,10,10,8,,12,,,,8,16,16,10,10,6,,16,7,16,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,27,,,,14,21,7,,
   16,,21,,10,,,5,5,5,,,4,7,5,7,8,6,7,13,10,25,,,7,13,8,
   ,6,6,,8,6,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,6,9,6,,,8,7,,24,20,,,22,11,20,7,5,11,,20,17,8,,,,
   6,,6,,,8,7,,,12,,,15,8,15,5,4,5,,15,15,8,,,,,5,,,,,,,,,,,
   14,15,7,7,8,,,,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   7,8,,,14,,,,,11,21,9,4,5,5,,9,21,11,,,,,,31,,,,,,,13,7,
   7,8,,23,,23,7,8,,,20,24,,,,31,16,9,5,7,11,,8,17,20,,9,
   8,,,17,,,18,14,125,,7,,,,23,8,10,9,,,19,,,20,15,152,14,
   6,9,,,,10,,19,,,,,,,10,6,14,9,,13,20,152,11,,,,,13,,8,7,,,
   ,12,18,125,,,,,19,24,,,,,,,14,25,,,,,25,17,,,,,24,,24,,,14,
   ,19,,,,,25,14,,,,,,,,,,,,,,,,,,,,,,,29,29,11,8,23,,19,17,11,
   16,18,13,18,,19,19,17,10,10,8,,17,11,11,5,5,,13,11,10,
   5,,18,11,10,,11,13,10,,,,11,16,11,3,4,4,4,3,4,4,4,4,
   4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,
   7,7,7,7,8,8,6,12,8,12,8,10,4,4,4,3,4,4,4,4,4,4,4,
   4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,7,7,7,
   7,8,8,6,12,8,12,8,10,4,4,3,3,3,3,4,4,4,4,4,4,6,,
   4,4,4,,4,,6,,,,4,4,7,4,,4,8,6,8,,6,,,,,6,8,8,6,6,6,
   8,9,6,9,6,8,3,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,
   ,,,4,6,8,7,,6,10,9,10,10,8,,,9,,15,7,7,9,8,8,7,8,8,
   8,8,10,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,
   8,7,,6,10,9,10,10,8,,,9,,15,7,7,9,8,8,7,8,8,8,8,10,
   3,4,4,4,4,4,4,4,4,8,,4,4,4,8,4,7,7,,,,4,4,,4,,4,,6,
   ,8,8,,,,,6,9,9,6,9,9,9,6,9,6,9,9,4,4,4,4,4,4,4,4,
   8,,4,4,4,,4,7,5,,9,,4,4,7,4,9,4,,6,,,8,,,10,,4,5,5,
   4,8,8,5,8,8,8,8,5,3,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,
   6,7,10,5,9,6,8,9,8,,,,,,,7,9,8,7,9,9,8,9,9,9,9,8,
   6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,
   ,,,7,9,8,7,9,9,8,9,9,9,9,8,4,4,4,4,4,8,,3,4,5,6,
   5,6,7,,11,,4,4,6,4,8,7,6,7,6,6,,,,7,,17,5,5,17,7,8,
   9,7,7,8,7,14,4,4,4,4,,,4,4,4,6,4,6,,,8,,3,4,6,5,
   11,5,6,7,6,6,,,,,,10,5,9,4,8,7,8,8,7,7,13,6,4,4,4,,
   ,4,5,4,8,5,6,,,15,,4,4,6,8,15,6,7,8,8,7,,,,,,6,6,7,
   7,6,9,6,9,8,6,9,9,4,4,,,4,4,4,6,4,6,6,,,,4,4,5,4,
   7,4,6,6,6,,7,,,,,6,9,7,5,7,13,4,7,8,7,9,4,4,,,4,4,
   4,7,4,,11,,,,4,5,6,4,6,5,8,7,6,9,9,,,,,7,7,7,5,9,9,
   9,6,6,8,10,7,9,,5,4,4,10,5,,6,,,,4,8,6,4,10,6,10,8,
   6,,4,,,7,,6,17,5,10,8,18,8,8,7,7,7,16,,7,9,4,9,6,8,
   9,,,,4,7,6,7,15,6,7,8,8,,,,,,,8,,14,13,8,22,,10,10,7,
   12,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,,5,,8,,,,4,4,6,
   4,12,4,6,7,,,4,,,7,,4,7,5,4,13,11,4,7,7,11,7,4,4,9,
   5,11,,,,,4,4,6,4,13,4,6,7,,11,7,,,,,7,7,9,5,9,10,4,
   8,9,10,10,4,,5,10,,,10,,5,4,10,4,8,5,6,8,7,6,7,,,7,,
   10,5,6,5,18,7,20,7,8,13,7,7,,,11,,,,,11,,6,15,8,,12,
   12,12,6,,,9,,8,13,8,10,39,,8,11,12,15,10,12,6,6,,11,,
   7,6,9,6,,8,11,7,,8,6,,,6,,6,8,5,11,11,10,9,7,7,10,
   6,10,6,,,,6,7,7,6,15,8,12,9,,6,11,,,21,,13,19,11,7,,
   31,8,8,10,17,11,,,26,,6,6,7,7,16,7,6,9,,6,,,,,,14,12,
   21,9,15,11,,11,12,12,32,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,
   15,8,,8,,11,15,,14,,,,,23,,165,,,,8,11,22,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,4,,4,,5,,7,,6,5,,,7,,5,5,6,6,11,7,4,9,13,13,
   7,7,7,4,,5,,8,11,,5,,,10,,5,9,6,7,10,10,4,10,9,10,8,
   7,7,,,6,,,12,,,,11,,13,7,9,17,17,8,7,31,12,,9,12,,5,7,
   8,11,11,,,,,,5,6,20,5,7,7,6,13,18,7,13,6,,,,,,16,,,,,
   23,13,,60,,11,13,,,,,,,7,8,7,,,,,,11,5,10,10,10,6,10,10,
   11,6,6,9,,12,,,,,,,11,13,10,,12,12,7,39,29,12,14,15,,
   10,10,,,9,,6,7,8,8,10,9,9,14,,12,7,66,,7,,,11,,8,10,
   13,9,29,11,10,,17,39,12,9,9,,,,,9,14,13,8,12,39,7,12,
   15,12,,8,,,,,16,5,,11,10,8,24,,,10,22,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,52,,11,14,165,,,152,11,,8,,,,,,,,,,,,,7,11,,16,8,7,
   11,11,16,19,10,8,13,16,9,4,6,9,12,19,16,7,9,9,8,18,
   15,6,9,4,11,16,11,19,17,8,11,7,13,10,7,13,10,6,6,9,
   10,6,7,13,10,10,6,18,15,16,10,13,10,10,9,15,13,10,10,
   9,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,
   4,,6,,9,,12,,8,,,,,,7,7,7,7,8,8,6,12,8,12,8,10,3,4,
   4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,,
   9,11,12,11,,,11,9,,,8,6,7,8,7,7,7,8,7,8,7,7,4,4,4,
   4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,
   12,11,,,11,9,,,8,6,7,8,7,7,7,8,7,8,7,7,3,3,3,3,4,
   4,4,4,4,6,,8,4,4,6,5,4,8,,5,,,4,4,6,6,,4,7,6,7,5,,
   8,,,,7,4,4,7,7,7,4,10,7,10,8,4,4,4,3,4,4,4,4,4,4,,
   8,4,4,4,6,4,6,,7,,,4,4,,4,,4,,6,,6,,8,,,,9,6,6,9,8,
   8,6,6,8,6,8,6,3,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,
   4,6,10,7,,6,,9,,,,8,,,9,7,15,9,8,7,7,9,8,7,8,10,9,
   4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,
   8,,,9,7,15,9,8,7,7,9,8,7,8,10,9,4,4,5,4,5,4,,6,4,
   5,4,,4,8,,8,7,9,4,5,6,4,,4,5,6,5,,,6,9,,8,10,5,5,
   10,7,7,5,9,7,9,7,5,4,4,4,4,4,,,3,4,5,6,5,5,,,7,,4,
   4,6,4,,7,6,7,5,5,,,7,,,7,5,6,9,6,4,10,7,5,7,7,17,
   4,4,4,4,,,4,4,4,5,4,8,,7,12,,3,4,6,5,,5,5,7,6,7,,
   8,11,,7,9,4,10,5,5,5,17,7,6,8,9,5,4,4,4,,,4,5,4,8,
   5,4,,,13,,4,4,6,8,,6,6,8,6,10,,,6,,,7,5,7,7,4,6,7,
   8,6,6,10,10,4,4,,8,4,4,4,7,4,,,5,,12,4,4,6,4,,4,6,
   6,6,,,5,8,,7,5,17,10,5,5,9,4,8,5,7,14,5,4,,,4,4,4,
   10,4,,,10,,,4,5,8,4,,5,6,7,6,,,4,15,,10,7,7,4,6,6,7,
   7,6,4,9,6,6,,9,5,4,4,11,5,7,,7,,8,4,8,6,4,,6,10,8,
   6,7,,7,10,,,5,10,6,17,6,17,5,7,6,8,5,17,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,4,7,7,8,,,,17,134,4,5,8,4,,10,10,
   10,6,8,,,15,,,24,13,8,,8,10,16,7,7,10,8,19,4,4,,5,,,6,
   ,7,4,4,6,4,,4,6,7,6,6,,4,,,7,4,10,6,6,9,7,5,7,5,
   13,4,5,4,,5,,,8,,13,4,4,7,4,,4,6,7,,11,,5,,,4,6,7,7,
   4,7,7,5,9,6,9,9,5,7,5,9,,11,8,,5,4,10,4,,5,6,8,,6,
   ,4,,,8,17,5,6,6,17,5,10,8,6,18,8,7,,,,,,13,6,11,6,6,
   ,8,6,,12,11,,8,,,18,9,14,8,16,16,,15,11,12,12,7,13,8,,
   ,,,7,6,11,6,,8,9,7,10,8,,10,12,,12,8,9,6,7,7,8,9,7,
   10,11,5,11,,7,134,17,7,9,9,4,,6,11,8,8,9,,4,,,11,10,
   16,8,8,,24,13,8,5,22,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,13,,8,
   6,,6,,,11,,,,,9,,,,,15,8,16,16,9,14,,9,12,7,19,,8,,,10,,
   8,,13,24,,,,,,,9,,,205,,,31,12,13,,,,11,6,,8,,,11,,16,10,,,
   ,,,,31,,,205,9,,26,9,,100,,4,,4,,5,6,7,,8,,7,,,7,4,6,
   4,5,7,5,4,13,9,11,4,6,9,4,,5,,8,11,,,7,,,10,4,7,7,
   6,7,9,5,9,7,10,4,7,,,,6,,,11,,,,,19,13,9,8,10,13,8,
   10,39,14,,8,15,,5,,8,10,,,,10,,8,6,6,10,6,5,6,5,18,
   17,7,20,5,,,,,,,,,,,,,,,,,,,,,,,10,7,6,6,,10,11,,12,7,6,6,
   10,8,5,11,11,7,10,9,10,,12,,,,,,,7,10,7,,11,11,8,31,
   19,22,7,24,11,9,,,15,,,9,10,10,84,9,8,8,,84,10,8,8,6,
   ,10,,,8,9,17,13,7,19,11,7,,13,31,8,8,,7,26,,11,9,19,
   14,9,12,21,9,15,,11,,21,,,,,,,,,,,,,,,,,12,,,,7,13,14,7,8,
   8,,18,7,9,16,,12,,60,23,13,,165,,,103,,8,23,,,,,,,,,,,,,,,,
   11,,9,65,,173,94,11,9,,7,11,8,10,4,7,6,7,18,10,10,,
   13,11,7,,8,7,19,10,,7,7,11,,16,13,8,7,,7,10,11,12,9,
   6,4,7,8,13,16,8,9,4,6,7,9,4,15,16,13,11,6,16,11,,9,
   13,10,17,11,15,7,9,11,10,4,3,4,4,3,4,4,4,6,4,6,7,,,
   4,6,7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,7,7,8,9,
   15,7,8,9,7,15,7,4,3,3,3,3,4,4,4,4,4,4,,,4,4,4,8,8,
   ,,8,6,6,4,4,6,4,6,8,7,4,7,8,,,6,6,6,4,4,4,4,4,4,
   4,4,4,4,4,4,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,
   ,4,6,10,7,9,6,8,9,8,,,,,,,8,7,7,8,9,15,7,8,9,7,15,
   7,4,3,4,4,4,4,4,4,4,,,4,4,4,8,4,5,7,7,10,,4,4,,4,,
   4,,6,,8,,,,9,9,8,8,8,8,5,5,8,4,5,4,5,8,4,3,6,6,5,
   6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,
   10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,5,,,4,4,5,
   6,6,5,6,6,9,,4,4,8,5,8,6,7,4,7,6,,,,,7,6,8,8,6,4,
   4,6,5,4,6,4,6,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,
   8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,
   4,4,5,5,,,4,4,7,6,7,8,,,7,,4,4,8,6,8,7,,7,6,4,,,,,,
   12,4,5,,8,5,,7,7,6,7,29,4,4,4,4,,,4,5,5,4,4,6,,,7,,
   4,4,8,7,8,7,6,6,8,7,,,8,,,,5,,5,5,5,12,6,8,6,32,7,
   5,3,5,,,4,6,5,9,6,5,,,7,8,4,3,5,5,8,4,6,5,9,5,,,6,
   8,8,6,6,4,4,5,6,5,6,6,5,5,5,4,5,,,4,4,4,7,4,10,
   10,6,,6,4,5,6,5,,4,8,5,8,,,,8,,7,5,,12,4,5,14,4,6,
   5,7,17,5,5,,,5,3,5,5,4,,5,6,7,7,4,6,9,5,6,6,9,5,5,
   ,,,8,7,7,4,4,6,6,6,5,5,5,5,6,6,6,,,7,5,6,10,7,8,
   7,8,,7,6,5,8,5,10,5,10,5,8,,,,10,7,,5,13,5,13,7,,5,
   8,8,8,6,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,4,5,,7,,8,7,,,4,4,,4,6,4,8,6,7,7,,,,9,
   8,7,12,6,4,14,17,5,7,5,19,7,7,5,,6,5,,6,7,8,5,3,6,
   5,8,4,5,5,,6,,,6,6,6,6,6,5,4,5,5,4,5,6,5,5,4,,7,,
   10,,,,7,5,10,6,,7,8,8,,5,,,,9,,13,7,5,8,,6,17,8,7,37,
   6,6,,,9,,,,7,6,8,5,,4,7,8,9,,,,35,8,,7,24,5,7,12,,5,
   8,12,13,7,9,6,12,,8,9,7,4,9,5,9,4,9,7,,4,,,10,6,10,
   7,7,4,7,7,7,7,7,7,7,5,7,10,8,32,10,8,6,6,7,11,12,,
   9,10,9,,,,,16,7,34,10,7,,11,9,9,7,15,10,10,,13,,7,6,
   8,8,19,7,6,7,,,,,21,,11,,9,12,7,10,9,,11,10,10,14,6,,,
   8,6,11,8,,9,11,11,6,6,,,17,11,,,7,7,12,10,11,,16,12,
   10,8,26,7,7,7,7,,7,4,12,8,,,,,,,,6,,96,55,,,,8,7,,75,
   57,8,6,,,6,6,10,,,8,,,,,,,7,143,,,,,,,,,141,4,,5,,7,7,7,,
   8,,,,8,9,5,6,4,6,17,7,7,19,14,19,8,4,6,5,7,6,,5,6,,,
   ,8,7,7,4,5,4,4,5,5,4,5,5,6,6,6,8,48,,,11,,11,,,,,
   17,9,7,9,9,18,8,8,15,20,,15,7,,7,,5,9,10,,,10,,9,8,
   5,17,6,6,6,6,15,,7,20,6,6,67,,,10,,,,,,9,6,96,135,126,
   9,8,,,,203,,,7,10,,,,9,11,11,7,4,7,7,7,5,7,7,7,7,6,7,
   ,10,,,,12,18,,7,9,7,,10,10,11,15,25,11,9,19,10,7,,,9,
   9,,6,7,6,19,9,7,7,,14,10,7,19,7,,,48,14,17,9,9,9,7,
   25,10,7,,26,15,10,11,,,13,,10,7,12,24,7,12,19,7,10,8,
   8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,10,96,135,9,6,,,59,,,,,7,
   8,,,,,9,,,,,,,7,,,,,,,,,,,7,,4,8,10,9,5,6,6,7,23,9,9,10,
   8,10,7,4,6,5,8,10,10,4,5,9,10,23,9,6,7,4,7,9,8,8,
   14,6,5,6,12,9,11,12,7,6,6,5,5,6,11,26,9,7,6,23,9,
   16,7,,17,13,18,20,12,5,7,5,4,4,4,4,3,4,4,4,4,4,6,,
   11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,6,
   7,8,7,7,7,8,7,8,7,7,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,
   6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,7,7,8,9,15,7,8,
   9,7,15,7,3,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,
   6,,9,,12,,,8,,,9,,12,8,8,12,6,7,8,7,7,7,7,8,4,4,4,
   4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,
   12,8,8,12,6,7,8,7,7,7,7,8,3,4,4,4,4,4,6,5,7,4,4,
   6,,4,,8,6,,,4,4,5,6,,4,8,6,8,,5,7,,,,10,8,7,10,4,4,
   7,7,4,8,4,7,4,4,5,4,5,4,,5,4,5,4,,4,,8,6,,9,4,5,
   8,4,8,4,6,6,6,,,5,9,7,,9,7,7,9,5,5,7,10,5,10,5,7,
   4,4,4,4,4,8,,3,4,5,,5,,7,,,,4,4,8,4,7,7,7,7,4,,6,
   6,11,8,,11,4,5,13,4,4,7,5,6,4,6,9,4,4,4,4,6,6,4,
   4,4,,4,,,6,,,3,4,6,5,7,5,4,7,5,,,6,7,,,13,4,7,7,5,
   6,9,6,5,4,10,5,4,4,4,,11,4,5,4,,5,,9,9,,,4,4,6,8,
   10,6,7,8,5,,11,,6,,,10,4,9,9,5,7,7,6,7,4,7,7,4,4,,
   6,4,4,4,,4,,,6,,8,4,4,5,4,7,4,5,6,8,,7,6,12,,,7,8,
   9,8,4,10,5,5,5,5,17,5,4,11,,4,4,4,,4,,,7,,,4,5,8,4,
   4,5,5,7,4,,,6,13,,,9,9,7,9,5,7,7,4,5,6,7,6,,10,5,
   4,4,,5,,4,,,10,4,8,6,4,8,6,,8,4,,6,,8,10,,7,20,6,18,
   5,10,5,6,5,6,6,17,6,7,,6,,6,,9,11,,26,5,10,,7,11,8,
   7,9,8,,11,,10,,,11,,21,15,9,14,12,9,21,9,19,,6,6,,,6,,
   8,,,,5,6,,6,8,10,10,11,6,,12,12,16,24,,31,8,11,,7,13,
   19,7,8,9,17,13,4,4,,5,,8,6,,11,4,4,7,4,7,4,8,7,,,5,
   5,,12,,8,9,5,7,17,17,5,5,5,9,5,6,4,,5,,,8,,15,4,4,
   10,4,10,4,4,7,,,10,6,,,,9,6,7,6,7,6,6,6,6,7,7,4,,5,
   ,9,10,,,5,4,11,4,8,5,4,8,7,,7,6,,8,,18,8,5,8,10,6,
   17,6,7,17,5,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,11,7,6,,
   6,12,8,10,7,10,,8,10,,8,,10,9,5,11,11,6,8,10,10,7,6,
   7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,5,4,7,7,11,8,4,8,,,,11,
   17,134,,22,,14,8,13,8,,8,7,10,16,5,,,6,6,,6,19,11,,,8,
   ,6,6,,,,,8,8,39,10,8,13,10,15,13,9,14,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,7,6,,10,12,12,12,15,15,,,,,,,,8,,,,23,,13,23,,60,
   103,4,,4,,5,,7,,,6,6,,7,,7,4,4,7,10,4,6,9,17,8,5,5,,
   4,,5,,8,,,8,6,,13,,6,5,6,8,7,7,4,7,5,7,6,6,7,,,9,,,,
   ,11,,13,,11,7,9,,14,8,16,16,19,,15,9,,5,7,8,9,,11,10,
   8,,,8,5,17,7,5,6,6,17,17,5,17,6,12,,,,,18,,,,,11,8,65,
   173,,11,9,,,,,94,10,7,8,,,9,,,,11,5,8,7,9,6,7,7,11,8,
   9,10,,,,8,,,,,7,9,8,,8,13,7,14,16,,7,18,10,,,,,13,,10,
   8,8,,8,10,9,84,8,9,10,84,,7,10,134,17,,10,8,10,7,16,
   8,8,,19,24,13,7,,,,,,,,,,,,,,,,,,6,13,,,12,7,,11,15,8,16,
   16,13,9,14,12,11,,,22,7,11,31,8,7,11,,24,7,10,19,,,,
   100,9,26,,,205,,,,31,9,,,,,12,31,,,205,,9,,13,,,,,,,,,,,,,9,
   9,13,16,8,9,6,11,18,19,11,8,10,11,7,4,4,5,10,10,15,
   9,7,11,8,10,13,4,7,4,11,16,16,12,17,6,8,9,,13,11,,7,
   ,6,7,7,,11,,13,7,6,10,11,8,7,8,13,9,10,,7,7,7,7,4,
   3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,
   9,10,10,8,,,9,,15,7,7,9,8,8,7,8,8,8,8,10,4,3,4,4,
   4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,
   10,10,,,,8,8,8,8,7,7,8,9,10,15,7,8,4,3,4,4,4,4,4,
   4,8,7,4,4,4,,8,,,6,6,6,4,4,8,4,6,8,,4,,,8,7,6,6,6,
   4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,7,10,10,4,6,
   7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,7,7,8,
   9,10,15,7,8,4,4,6,4,6,4,,7,4,6,4,,4,,,8,6,6,4,6,8,
   4,6,4,7,4,7,,,7,6,6,6,5,6,6,5,6,6,6,5,6,5,6,6,4,
   4,4,5,5,8,,4,4,7,7,7,,,,,,4,4,8,6,,7,8,7,6,6,10,10,
   7,8,,17,5,6,14,4,7,12,7,6,8,4,,4,4,4,4,10,10,4,5,
   5,6,4,,,7,6,,4,4,6,7,7,7,6,6,8,,,6,7,,9,14,4,12,5,
   4,5,,8,4,5,,5,5,3,5,,5,4,6,5,6,6,,,,8,7,4,3,4,5,7,
   4,6,5,6,6,5,,4,6,6,5,4,5,5,4,6,6,6,4,5,4,4,4,5,,
   6,4,4,4,,4,,,4,,7,4,5,4,5,8,4,8,5,6,,,8,7,,8,5,12,,
   5,5,,5,5,5,5,29,5,5,5,,5,3,5,6,4,,,5,7,7,4,6,9,5,
   6,6,6,5,5,,,5,7,8,7,5,5,6,6,6,4,4,5,4,6,5,6,10,,
   7,5,6,,7,,,,,,6,5,6,5,,5,11,5,,8,7,8,8,10,,6,17,5,,
   8,13,7,8,7,7,6,31,10,,,7,,12,,,9,,13,6,6,6,8,16,6,8,
   10,,,11,,7,,17,9,,12,10,7,,9,11,9,8,26,10,8,5,8,8,6,,,
   ,10,32,6,6,9,,12,10,10,,8,,6,10,11,,,11,9,10,,7,7,34,
   9,8,9,11,,4,5,,7,,,6,,7,4,4,7,4,9,4,6,6,10,10,6,6,,
   6,7,5,,5,8,,12,4,5,5,32,4,4,5,,6,,,9,8,7,5,3,5,5,
   7,4,5,5,,5,6,6,7,7,6,6,5,4,5,4,6,6,6,6,5,5,4,8,7,
   ,,10,7,,7,5,10,6,9,7,,8,8,7,8,,,7,9,,5,5,7,13,5,13,
   7,8,,5,8,,,,,,,10,5,,7,,6,10,,6,11,8,,,11,16,11,,7,10,
   12,,7,9,11,14,6,9,,,,9,8,7,4,6,5,11,4,7,7,10,6,6,
   10,7,6,7,7,7,4,7,7,7,7,7,7,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,7,6,10,6,11,7,9,6,
   ,9,15,10,32,,5,5,12,7,7,24,8,,9,5,12,7,8,6,10,10,6,
   6,11,,,28,11,14,,,,,,143,,241,,7,9,8,,,185,7,4,15,8,7,
   7,10,8,11,7,,14,,,,,,,,55,6,,9,,74,57,160,4,,5,,7,10,7,
   ,8,7,8,,,,8,5,4,7,12,6,4,14,,17,5,6,,5,6,6,,5,5,,6,
   6,7,8,7,5,4,6,6,6,5,4,5,4,6,6,5,,32,,9,7,,9,,11,,,
   10,9,5,7,8,24,5,7,12,12,,5,,,7,8,5,,10,,11,,,,7,6,13,
   8,7,5,8,,13,6,17,7,7,44,,,17,16,,,,,9,9,112,,248,8,7,,,
   ,,158,10,7,6,12,,7,8,9,11,7,4,7,7,7,4,7,7,7,7,7,7,
   ,10,,,,14,14,,9,7,7,,10,9,6,11,22,10,8,14,,10,,,8,,,9,
   7,7,14,6,7,6,14,19,9,7,19,10,8,10,32,10,12,9,11,7,
   9,34,10,7,,,11,9,8,,8,13,,16,8,26,,11,9,12,7,10,10,9,
   ,9,10,,,,14,6,,9,7,7,12,10,9,11,,11,10,12,44,10,8,9,
   11,7,7,10,,14,9,7,22,7,7,74,57,6,9,,96,55,,,,,,6,,146,
   ,9,7,143,,,185,,,8,,,8,,7,112,,,158,9,9,,5,9,12,9,5,7,
   4,7,8,9,10,10,9,8,6,4,5,4,9,9,10,5,4,8,10,9,11,5,
   6,4,7,9,10,16,14,4,5,7,10,8,10,10,7,4,4,4,5,4,9,
   10,11,7,4,9,8,10,7,12,9,14,10,10,7,5,7,4,4,4,3,6,
   6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,
   9,9,9,9,9,8,8,9,7,8,7,9,9,3,4,4,4,4,4,4,5,6,7,4,
   4,5,,6,6,5,8,,,4,4,6,5,7,6,,4,,,6,7,,9,8,5,4,4,5,
   6,8,4,6,6,6,8,4,4,4,4,4,4,4,6,6,6,4,4,6,6,4,6,6,
   6,,,4,4,6,6,,4,6,4,6,6,6,6,,,,10,6,5,6,5,5,5,6,5,
   10,6,5,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,
   9,,,,8,,,9,9,9,9,9,8,8,9,7,8,7,9,9,5,5,4,7,7,6,,4,
   5,6,11,6,,6,,,,4,5,6,4,7,5,6,5,6,6,7,7,,7,,20,6,6,
   15,7,10,17,7,7,7,7,10,5,5,5,4,7,7,4,7,7,6,4,5,,6,,
   ,4,5,8,6,11,6,6,5,11,6,,5,,,7,15,6,17,7,7,7,17,7,
   7,6,23,5,7,6,7,,6,5,5,4,7,5,5,8,8,,,5,6,7,7,,5,11,
   7,7,,7,,,12,12,7,11,7,7,7,10,6,7,10,6,18,18,5,7,,5,
   5,5,4,6,4,7,7,6,,,4,7,6,7,9,4,11,6,6,,6,,,,8,7,17,
   17,7,7,15,6,7,7,4,18,5,7,7,,7,6,7,,6,,7,,,,5,5,7,4,
   8,5,7,6,7,8,8,5,,9,,7,7,6,7,7,7,7,6,7,7,7,11,9,
   10,6,4,4,10,6,9,5,9,,,4,7,5,4,7,4,9,7,5,9,5,9,,7,,
   7,7,6,27,6,27,6,7,8,5,7,7,7,6,8,5,8,6,6,7,10,,,6,,
   6,6,35,6,6,,9,,9,,,,11,9,,10,12,8,12,11,9,17,7,,,,5,
   9,9,,,6,,,,4,6,7,4,11,7,7,6,6,8,10,8,,13,,14,22,7,,
   14,,10,5,8,8,8,13,5,7,,6,,6,11,,,5,5,6,4,9,4,6,5,8,
   8,6,4,,9,8,10,17,6,7,15,20,6,4,7,13,6,7,7,8,5,6,,7,
   ,,7,6,11,7,,6,7,6,,7,,6,,,6,10,6,7,7,7,7,11,10,13,
   12,12,10,9,6,10,9,10,,,6,4,10,4,12,6,5,4,6,5,6,4,,
   12,8,27,6,6,6,27,7,7,5,6,20,6,6,,,10,,,,8,7,9,5,12,
   6,8,7,10,9,8,7,,11,,12,50,7,11,12,,22,9,9,20,9,15,,6,
   ,,,5,5,6,4,11,4,6,5,7,6,6,7,,6,,15,7,5,8,8,15,7,7,
   7,7,6,7,7,9,,,5,7,7,4,11,5,6,5,9,7,9,4,,13,29,,10,
   7,14,,14,22,5,6,,8,8,8,,,,6,6,6,,11,6,7,,9,,9,,,7,12,
   11,10,8,12,9,,11,14,12,19,11,,,6,6,8,5,11,6,10,8,10,
   8,9,7,,9,,,22,7,12,11,12,50,9,8,10,8,21,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,8,5,,6,,5,,9,7,
   7,6,6,7,20,6,6,18,15,15,9,6,7,7,,5,,7,7,,7,11,,,,7,
   8,11,7,7,7,5,7,8,6,11,13,6,,,7,8,,9,,8,,28,8,,11,8,
   8,17,8,25,14,15,,12,11,,6,6,7,9,10,9,10,,,8,6,6,7,5,
   7,6,5,20,27,5,26,5,,,,,18,,,,,,30,31,,,,10,14,,,80,,,7,5,
   ,6,,5,,17,8,8,5,7,7,15,6,7,7,8,6,13,6,,9,,9,,,29,,
   8,39,8,,8,12,11,11,15,7,15,,7,,7,,,,,7,12,12,14,7,12,
   6,18,14,6,15,26,8,6,7,,,7,15,8,39,8,17,8,16,,24,10,
   16,7,8,9,,,18,8,8,29,14,9,19,7,,14,7,,8,7,,,10,19,7,,
   9,17,8,26,,18,9,,7,,19,,8,8,8,14,7,14,7,,26,6,,10,,,,,,
   ,,,,,,,,,12,,,,11,27,,,,,13,,23,183,,10,,10,,147,144,45,9,
   14,,7,7,20,9,7,11,6,8,13,22,12,,23,7,11,,6,8,25,14,
   4,7,7,7,,19,23,6,11,,8,9,7,11,13,6,7,15,20,23,14,20,
   8,6,10,7,7,6,14,20,23,7,10,19,10,,9,10,28,11,15,21,
   12,12,7,18,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,
   6,,9,,12,,,8,,,9,,12,8,8,12,6,7,8,7,7,7,7,8,4,4,4,
   6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,
   10,,,,8,8,8,8,7,7,8,9,10,15,7,8,6,6,7,6,7,5,,8,6,
   7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,9,9,9,8,8,9,
   7,8,7,9,9,4,4,4,4,4,6,,3,4,5,5,5,6,6,,7,,4,4,,4,,
   7,,7,,4,,,,12,,13,7,7,9,4,6,11,6,7,5,5,13,4,4,4,4,,,
   4,4,4,4,4,8,,6,7,,3,4,,5,,5,,7,,7,,6,,,12,11,7,11,7,
   4,5,13,4,4,4,7,7,4,4,4,,11,4,5,4,5,5,6,7,7,10,,4,
   4,,8,,6,,8,,7,11,,,,,10,8,10,10,4,6,10,7,7,5,9,9,4,4,
   ,6,4,4,4,7,4,6,6,5,,,4,4,,4,,4,,6,,,6,6,,,7,7,9,13,
   7,4,7,7,5,4,6,9,8,4,11,,4,4,4,7,4,,11,6,,,4,5,,4,,
   5,,7,,9,9,6,,,13,10,10,10,8,4,9,9,5,4,7,7,9,11,11,
   5,4,4,,5,7,6,7,,,4,8,,4,,6,,8,,7,6,7,,8,,7,13,7,13,
   6,20,7,5,6,5,6,18,,6,9,6,9,7,6,6,12,,,6,7,,,,8,,10,,
   ,12,,,,,12,,39,12,7,13,12,8,8,9,14,15,6,6,7,7,8,,,,11,
   ,6,8,,6,,,,,,8,12,12,,15,,39,12,11,,10,13,29,9,9,8,10,
   17,4,4,,5,,6,6,,,4,4,,4,,4,,7,,,6,6,,8,11,7,13,7,8,
   8,9,8,4,6,10,5,7,4,9,5,11,,6,,,4,4,,4,,4,,7,,,7,8,,,
   6,8,10,9,6,9,7,9,5,7,7,7,6,7,5,,10,10,7,,5,4,,4,,5,
   ,8,,4,,6,,10,8,13,7,7,7,20,6,18,5,7,10,5,8,,,11,,,,,,
   ,4,,6,,10,,,6,,,14,16,10,22,8,,24,,10,11,,16,5,,7,8,,,,
   7,6,,6,,8,,7,,6,8,,,8,,6,6,6,10,10,10,10,10,9,11,5,
   11,6,7,,,7,,,6,,6,,9,,9,11,6,,26,16,11,32,11,10,,16,
   15,8,7,14,12,12,7,21,,6,6,,,,6,,9,,8,,12,,,15,17,11,
   31,8,8,11,,7,7,13,19,10,11,,6,6,,6,,9,,,,6,,6,,15,,,9,
   8,31,7,9,17,17,12,13,7,12,,7,,,7,,6,,9,,,9,,,,,11,,165,,
   ,,14,11,8,,52,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,8,6,
   6,,11,8,8,7,8,7,9,5,7,17,14,17,5,7,,4,,5,,8,,,8,7,,
   15,15,6,9,9,9,6,7,6,7,9,6,6,8,,,,,,,,,,,,,,,,,,,,,,,,,,5,
   ,8,,9,10,10,,,10,7,7,18,8,8,5,8,10,12,6,17,7,,,,,,,,,,,
   ,,,,,,,,,,,,,7,,6,,11,,11,,10,6,10,7,9,5,11,11,10,6,8,7,
   ,,,,,,,,,,,,,,,,,,,,,8,12,,,11,,12,7,9,14,9,8,10,8,66,6,7,
   ,,,,,,,,,,,,,,,,,,,9,7,,,15,7,12,22,10,,14,8,13,8,8,,10,,,
   ,15,15,10,,11,8,8,39,10,12,8,13,12,,,,12,14,12,39,7,
   10,12,,15,11,13,29,,,,,,,,,,,,,,,,,,,11,8,165,,,98,23,,22,,,
   11,,13,,,60,,23,13,,10,7,13,18,6,10,8,10,16,12,9,13,
   10,15,9,6,11,9,19,11,15,10,9,9,13,16,10,8,9,6,10,18,
   7,19,10,11,6,10,8,10,11,16,7,4,6,9,7,4,11,8,15,11,
   6,16,16,13,7,,13,17,10,15,13,7,11,9,4,4,4,6,4,6,7,,
   8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,7,15,9,8,
   7,7,9,8,7,8,10,9,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,
   6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,
   7,4,4,4,5,5,8,,4,4,7,,7,7,8,,8,,4,4,8,6,9,7,,7,,,
   7,7,8,7,,19,8,7,19,7,4,17,6,4,5,6,14,4,4,4,4,7,7,
   4,5,5,,4,8,,,9,,4,4,7,7,8,7,,6,,,,8,,,6,19,7,17,7,5,
   6,14,4,7,7,12,5,5,3,5,,6,4,6,5,,6,6,6,6,7,8,4,3,
   6,5,7,4,,5,,,6,,6,7,7,6,6,5,5,4,4,5,4,6,4,5,5,4,5,
   ,8,4,4,4,,4,10,10,6,,8,4,5,6,5,7,4,,5,,,7,8,6,,,7,
   17,14,6,4,12,5,4,5,5,,5,5,6,,5,3,5,,4,,5,6,6,6,4,
   6,6,5,6,6,,5,,,,5,8,7,8,5,5,5,5,4,5,5,4,4,6,6,6,
   10,9,7,5,6,,7,8,7,8,,10,6,5,8,5,9,5,,5,,,5,,,,,7,20,
   6,15,6,17,6,6,6,8,5,,7,7,,5,,,,9,11,,13,4,5,6,,10,4,
   ,7,,,,,8,,10,8,,19,10,7,24,12,7,5,7,12,8,8,5,,,10,,10,
   ,14,48,6,9,6,8,17,,,10,,,9,10,,,,15,10,10,,7,9,25,7,
   11,9,9,26,4,5,,7,,6,8,,8,4,4,,4,,4,,6,,,4,6,,7,8,6,
   32,5,6,12,,5,5,7,,5,8,5,,6,5,,9,7,8,5,3,6,5,7,4,,5,
   ,,5,9,7,7,6,6,6,5,5,5,6,6,6,6,4,4,5,,7,10,,10,9,,
   7,5,,6,,7,,8,,,,8,,,,37,6,6,8,17,5,,8,6,13,7,7,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,7,12,,11,9,7,4,9,5,11,4,,7,,,4,,6,
   4,6,7,6,5,7,7,7,7,7,7,7,4,7,10,8,,20,,,,7,11,12,,7,,
   ,9,6,,13,19,10,14,9,11,,12,10,7,6,,11,10,6,,,8,5,8,
   8,16,6,,9,,,,,10,32,11,15,10,11,9,9,10,,7,8,7,22,7,,,
   8,5,11,8,17,9,,11,,,8,,,7,48,,15,12,21,8,9,18,9,7,9,
   9,20,6,,8,11,7,8,6,,9,,,8,18,,,,,,,,,,9,,7,,,,,6,16,10,
   10,10,,9,,,35,12,,,,,,,,59,9,,6,7,96,135,,4,,5,,7,,7,,,6,
   ,,7,8,6,5,5,7,,5,8,,29,12,5,6,,5,8,6,,5,,,9,6,8,7,
   8,5,5,6,6,5,4,5,4,5,6,6,6,8,,,,11,,,,11,,,,10,8,11,
   16,,7,10,12,26,,9,12,,7,,5,,,10,10,7,,10,8,6,,8,5,5,
   7,13,17,6,13,8,10,,,,,,,,,,,7,,,,,,,,,,,,7,,,,9,9,8,9,7,
   5,7,7,7,4,7,7,7,7,7,7,,,,,,,,,,,,,,,,,,,,,,,8,,,8,,10,6,
   7,,7,6,9,19,19,6,7,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,
   13,7,,8,5,5,12,7,9,7,24,12,10,12,67,11,9,10,15,11,7,
   10,,19,7,9,25,7,6,,,,,,143,,241,141,,7,,7,,75,,8,,,,55,
   57,6,,7,,,9,,8,96,126,135,239,9,6,,5,11,,23,6,7,6,7,
   23,8,18,11,17,9,7,6,5,5,9,10,20,5,5,9,12,9,9,5,7,
   6,7,23,11,8,13,6,6,7,10,9,8,16,6,4,6,5,4,4,8,10,9,
   7,6,9,10,12,6,10,11,19,9,10,8,4,7,5,6,6,7,6,7,5,,,
   6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,7,9,8,7,9,
   9,8,9,9,9,9,8,5,5,4,7,7,6,,4,5,6,,6,,5,,9,,4,5,6,
   4,7,5,5,5,4,6,8,8,,,,15,9,6,18,6,6,20,6,6,9,6,15,
   5,5,5,4,8,8,4,7,7,6,4,6,,6,9,,4,5,11,6,8,6,4,5,,6,
   ,6,,,9,13,6,20,4,6,6,15,7,6,10,17,7,7,6,7,,7,5,5,
   4,7,5,6,7,7,,,5,6,6,7,,5,11,7,6,,7,,,,,6,11,7,7,5,
   11,7,7,6,7,8,8,5,7,,6,5,5,4,6,4,7,7,6,,,4,7,6,7,
   8,4,,6,5,,6,11,,,9,4,18,15,7,6,17,7,7,5,7,10,7,7,7,
   ,7,6,7,,6,,6,11,,,5,5,7,4,6,5,6,6,5,8,8,7,,,,12,12,
   7,10,11,7,7,7,5,10,6,13,10,9,6,4,4,9,6,6,4,6,,,4,
   7,5,4,8,4,10,7,4,6,5,6,,,,5,26,6,20,5,7,7,5,5,6,6,
   27,8,6,8,5,8,6,9,7,9,,,6,,8,9,18,6,9,,8,,9,,,,18,7,,
   19,,7,29,9,14,8,8,8,14,11,7,6,6,,,9,,,,6,7,10,5,7,7,
   7,7,6,9,10,9,,,,10,16,8,,16,39,17,8,7,15,8,24,5,7,,6,
   ,5,8,,,5,5,6,4,7,4,5,5,7,7,6,6,,,11,6,23,7,7,17,
   17,7,7,5,23,6,7,7,8,5,7,,7,9,,7,6,,7,,6,5,6,,7,,7,,
   ,8,7,7,7,6,7,6,7,7,11,18,18,7,6,6,9,10,10,12,,6,4,
   10,4,8,6,4,4,9,5,9,5,,,12,20,6,7,5,7,6,27,6,6,27,
   6,6,,,9,,,,7,7,9,5,10,6,7,7,10,9,8,9,,,,9,,8,,26,,17,
   9,7,19,7,18,11,5,,17,,5,5,6,4,8,4,5,5,7,6,6,7,,,,6,
   13,6,7,7,7,15,7,6,16,5,16,7,6,,,6,8,8,5,7,6,9,7,6,
   7,10,6,,,,12,19,9,9,,7,12,8,7,,7,14,7,13,,,5,9,9,21,,
   4,5,,6,,6,,,11,,8,14,5,22,7,,14,8,,10,6,28,,6,7,8,5,
   8,6,8,8,7,6,9,7,,,,,12,8,30,38,16,17,8,8,,7,15,,7,
   12,9,7,12,6,19,,13,,11,29,,,,13,,,,,,27,11,23,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,5,,7,,6,7,5,,6,11,6,,,7,7,7,7,7,17,6,7,
   15,10,20,5,7,8,7,12,5,,7,6,,7,11,,,,6,18,10,7,6,7,7,
   7,18,7,11,10,9,,,7,8,,10,,10,,,11,10,8,14,9,50,7,11,
   19,21,,22,6,,6,9,7,10,9,10,9,,,7,5,7,27,7,6,6,6,27,
   7,7,7,8,,,,,11,,,,,,9,14,,144,147,10,10,,,183,,45,7,5,,6,
   ,6,,,11,7,6,15,7,7,5,8,8,7,15,5,7,,8,,7,,,,,6,,14,,
   7,8,7,14,10,8,8,26,6,,7,,,,,6,15,12,18,6,12,7,14,12,
   7,12,14,7,9,7,,,11,8,8,,5,10,7,14,,13,14,22,8,8,6,,,
   35,7,,12,9,11,10,8,12,,9,,17,8,,,12,20,9,,9,22,7,12,
   11,15,12,50,9,,,,7,15,12,11,11,8,8,,,8,39,15,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,80,,11,,31,,,,,30,31,,12,14,10,19,6,8,6,7,
   13,25,15,20,28,10,11,6,7,18,22,14,21,7,7,7,20,9,23,
   7,8,6,7,19,14,11,11,6,6,9,,23,7,,11,,10,7,7,,10,,23,
   8,10,9,7,20,8,20,23,13,14,4,12,18,16,8,8,8,5,6,6,,,
   4,5,5,,5,7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,25,6,9,26,
   6,8,31,7,6,6,8,8,8,8,8,6,,,5,6,6,,5,8,,9,,,4,5,8,
   5,7,5,8,7,8,,,9,,,,26,9,31,7,8,8,8,6,7,6,9,8,6,4,6,
   ,8,5,6,4,,6,5,9,9,9,10,5,4,4,7,10,4,6,7,,,,,4,10,
   10,7,7,7,7,6,7,7,6,7,4,6,6,8,6,,9,8,8,6,,5,11,11,
   6,,8,5,6,6,6,10,5,8,5,9,,,8,8,,10,7,31,9,6,8,9,8,
   6,8,7,31,8,6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,,5,6,,
   ,6,10,9,10,7,7,7,7,7,6,6,4,6,7,7,7,,11,5,4,4,,5,
   7,6,7,,7,6,7,4,4,8,4,10,7,6,,,,7,,,5,26,6,8,6,28,8,
   6,8,5,8,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,6,,11,,
   19,,8,,,6,11,,,9,8,,,11,,15,,41,11,10,,8,11,12,7,9,8,
   15,18,8,6,,5,,8,8,,,8,8,9,6,,5,9,7,,,,8,,,7,6,9,8,6,
   8,31,8,7,8,26,9,7,6,,6,7,,9,9,10,6,4,7,6,10,4,6,5,,
   ,,,9,9,6,7,7,6,4,6,7,7,7,7,7,7,6,,5,,,,9,,5,4,,4,,
   5,6,5,,,,6,,9,,8,6,8,5,28,8,28,5,6,8,6,6,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,7,
   7,6,7,7,8,8,7,8,7,6,7,11,7,82,13,,9,9,6,14,9,6,,11,
   ,,6,,17,13,12,15,10,9,,14,13,11,10,,12,12,9,17,,7,5,
   7,7,13,6,6,,,,,6,14,82,14,,12,18,11,13,10,,9,12,12,15,
   10,11,,7,4,7,4,,6,8,7,,,,10,15,7,44,,7,7,17,11,12,14,
   8,7,8,7,13,9,9,10,7,,10,6,16,9,15,,,12,,,,10,,,,,,,,10,,
   ,,,4,15,7,7,7,7,8,,,,13,,,,,7,99,75,141,10,,,7,,84,99,
   8,,6,,5,,5,,,,7,,9,10,6,8,8,7,31,9,6,26,8,25,6,8,9,
   6,10,6,,7,8,,,6,10,9,10,4,6,7,6,7,7,6,7,6,7,7,7,7,
   44,,10,7,,,,8,,11,,8,7,12,8,14,7,11,17,13,,7,8,,5,,7,
   11,,,10,7,,8,5,8,28,6,8,6,6,8,28,5,26,8,7,,,,,,,,,,7,,
   ,51,,10,,,,,49,,,5,6,,,5,7,7,8,7,6,8,7,8,6,7,7,7,7,
   7,8,,11,,,,13,12,,9,11,,,10,11,9,41,12,,14,,9,,,,8,9,,
   6,7,8,29,8,8,8,29,28,7,7,28,,,,,19,11,8,15,11,7,12,
   10,8,,18,41,11,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,16,,,14,
   11,41,9,,10,,,9,11,12,9,7,,84,10,,,,141,75,99,,7,7,10,,,
   ,,,,,,,10,,10,53,49,10,,,,,51,,7,,,7,19,15,14,6,7,4,7,
   13,13,10,33,11,10,7,6,6,6,13,24,19,7,6,10,33,14,10,
   6,7,6,7,14,19,12,14,4,6,7,33,10,19,33,7,6,5,6,7,6,
   19,33,16,7,5,14,10,33,7,15,11,14,10,19,12,7,7,6,3,4,
   4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,
   4,10,10,4,4,,4,4,4,10,10,4,4,4,,,3,4,4,4,4,4,,,5,,
   3,3,4,4,5,4,4,4,4,4,,,4,,,,4,10,10,4,4,,4,4,4,10,
   10,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,3,3,3,3,3,,4,4,3,
   ,,8,8,8,8,3,7,8,3,3,3,7,8,3,5,,4,3,4,5,4,,4,,,,3,
   4,4,3,4,4,5,4,3,4,4,4,5,5,,10,10,4,,4,10,10,4,4,4,
   4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,
   ,10,10,4,,4,10,10,4,4,4,4,,,3,4,4,4,4,5,3,,,,3,3,4,
   4,5,4,4,4,4,,,,4,,,14,,9,11,4,7,,5,4,4,25,11,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,
   3,3,3,,3,,8,7,3,8,8,8,7,3,3,7,3,8,4,4,4,3,,,4,,3,
   2,3,3,4,3,3,3,,3,4,4,4,4,,8,3,4,7,4,3,8,3,3,4,4,
   7,,3,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,10,
   10,5,,5,5,10,4,10,,,5,,,,4,3,5,3,5,4,4,4,4,3,4,4,,4,
   ,,7,4,11,9,,14,4,5,25,4,11,5,5,,5,,4,3,5,3,5,4,4,
   4,4,3,4,4,,4,,,5,4,10,10,5,,5,5,10,4,10,4,,,,3,4,4,
   3,4,4,5,4,3,4,4,4,,5,,10,25,4,11,,9,10,4,4,7,5,,,5,
   ,3,3,4,4,5,4,4,4,,4,,,5,12,,17,4,7,10,5,5,,5,4,5,
   7,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,10,5,
   5,,,,11,,11,,9,,11,4,4,12,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,
   ,4,4,4,,3,4,4,,3,,7,3,3,7,7,3,7,8,7,8,3,7,4,3,4,
   4,,4,3,,4,4,4,4,,7,4,3,8,3,4,7,4,4,3,3,8,4,,,3,,,4,
   ,,,5,,10,4,5,,7,4,10,9,25,,4,14,,4,4,4,4,4,6,6,3,,,
   8,3,7,8,3,3,8,7,8,3,8,7,,12,,,4,,,,,,11,4,15,,15,4,
   11,,,15,15,,,3,4,4,,,5,5,,10,4,5,,5,4,10,10,10,5,5,,,
   4,,,,5,5,,10,5,5,,5,5,10,7,7,4,4,14,4,4,,,5,5,,10,4,
   5,,5,4,10,10,10,5,5,,3,4,4,10,4,,16,4,4,7,6,3,10,,
   6,6,4,7,4,4,4,,,8,6,6,12,4,6,8,4,4,3,,8,3,5,,,13,5,
   ,16,4,4,16,,9,5,9,13,5,,,13,5,,16,4,4,16,,9,5,9,13,
   4,,,15,4,11,,15,,15,15,,4,11,,,11,,11,4,15,,12,9,4,,11,,
   ,,,,,,,,,,,10,16,8,27,8,,8,10,21,20,,8,16,7,4,8,3,4,6,
   6,21,10,4,6,21,6,7,3,4,8,10,20,,21,27,8,8,,5,24,6,
   6,4,3,8,10,4,3,7,6,16,10,8,27,16,8,4,8,7,27,6,5,
   24,4,10,10,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,
   4,4,4,,,4,,,,4,10,10,4,4,,4,4,4,10,10,3,4,,,4,4,4,4,
   3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,10,10,,4,4,10,10,
   4,4,4,,4,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,
   5,,5,10,10,,4,4,10,10,4,4,4,,4,6,6,3,3,3,4,3,4,,4,,
   ,2,3,3,3,3,3,4,3,3,4,,4,3,,,8,8,8,8,3,8,7,3,3,3,
   8,7,3,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,16,,16,
   ,4,9,13,5,4,5,16,9,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,
   4,,,,5,,,16,,16,,4,9,13,5,4,5,16,9,4,4,,3,,,3,,,3,3,
   3,3,3,3,3,2,4,4,,3,,,3,7,8,8,3,8,8,8,3,3,7,8,3,3,
   4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,10,4,10,4,
   ,4,4,10,10,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,
   ,4,10,4,10,4,,4,4,10,10,4,,,,,,,3,3,3,3,4,3,3,3,4,4,
   ,4,9,,4,16,6,8,4,6,,10,3,4,6,8,4,3,,,4,,3,2,3,3,4,
   3,3,3,4,3,,4,4,,4,10,4,7,4,4,4,10,4,4,4,7,4,,4,,,
   3,4,4,4,4,4,4,3,5,3,,4,,,5,10,22,11,4,,9,11,4,4,7,,
   5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,3,
   5,,12,,5,10,7,5,4,23,4,5,5,10,7,,3,4,4,4,4,4,4,3,
   5,12,,5,,,,11,,,19,15,,11,4,4,15,,11,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,3,,4,,4,3,3,,3,,3,,,3,7,3,7,3,7,3,8,8,8,8,7,3,4,
   4,4,4,,3,3,,,3,4,,4,7,4,8,3,3,4,7,4,4,3,8,3,,,,4,4,
   ,5,,5,,,5,10,4,,5,7,4,11,9,22,,14,4,,3,4,4,5,5,,5,5,
   ,5,10,4,,5,5,4,10,10,10,5,,5,,10,,,5,,,,,,11,4,,11,12,
   4,11,,,9,,13,4,4,5,5,,5,5,,5,10,4,,5,5,4,10,10,10,5,
   ,5,,3,,,,4,,,8,4,8,,3,4,7,6,6,4,10,6,3,3,,,3,,,8,3,
   8,7,3,3,7,8,8,3,7,8,4,,4,,,4,,5,10,4,25,4,11,,7,9,
   10,4,,4,5,,5,10,7,17,4,4,7,10,5,5,5,,5,,,,,,,,,,,,,,,,,
   4,,,,5,10,25,4,4,14,,7,4,10,9,,4,,11,11,4,,11,,9,13,,
   11,4,,,,,,,,,,,,,,,10,11,,4,15,,13,12,4,11,,10,,21,21,8,,
   8,10,27,,12,21,5,6,4,8,3,4,8,12,6,10,10,16,8,27,24,
   8,,8,4,9,33,8,7,3,8,4,8,16,7,5,4,8,3,10,4,3,6,21,
   5,10,8,20,,21,4,5,24,7,6,34,8,10,4,10,4,3,,5,4,4,3,
   5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,10,10,4,,
   4,4,4,4,10,10,4,,,3,3,3,3,3,,4,4,6,6,2,3,3,3,4,3,
   3,3,3,4,4,,4,6,6,4,4,4,4,3,4,4,3,3,3,4,4,,5,4,4,
   3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,10,10,
   4,,4,4,4,4,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,
   4,4,,,,7,,3,3,4,4,5,4,4,4,4,5,3,,4,,,12,5,,,4,5,12,
   4,4,4,8,8,4,3,,4,,4,4,,4,3,3,3,3,4,2,3,3,4,4,3,,,
   4,4,3,8,4,4,7,8,3,3,3,7,4,4,4,,3,4,,,6,6,4,3,4,4,
   6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,
   4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,4,4,8,3,4,4,7,3,
   8,3,3,7,4,4,,,,,,6,4,3,4,4,6,3,4,4,3,5,4,,10,5,5,
   5,7,5,5,6,,4,4,5,6,5,5,4,,,6,6,4,3,4,4,6,3,4,4,,
   4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,12,6,3,3,
   3,3,4,3,3,3,4,4,4,,,6,6,4,6,4,4,,6,4,3,3,6,6,6,3,
   6,,4,3,4,4,6,4,4,4,,4,,,6,13,13,,5,7,7,6,5,,5,5,6,
   7,7,6,,4,3,4,4,6,4,4,4,,4,,,6,13,13,,5,7,7,6,5,,5,
   5,6,7,7,6,4,6,4,5,6,4,7,5,6,,5,,,,,5,,,,10,,5,5,5,
   14,,,4,4,6,5,6,6,5,5,6,5,,,,,,,5,,,14,5,,5,5,11,,,3,,
   4,,3,4,4,,3,3,,,4,4,3,3,4,4,7,3,3,8,8,7,4,4,3,4,
   6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,4,12,,
   4,4,,3,,,,6,6,4,3,6,6,6,3,4,6,6,,4,4,,4,,3,5,5,5,,
   4,,,4,4,10,10,4,4,4,,,4,10,10,6,,,,7,7,,,,,5,5,,,14,5,
   5,,,10,,,4,4,3,3,,,4,6,6,4,3,6,6,4,3,4,4,4,4,6,6,,
   5,,5,,4,,,4,5,,,4,5,4,12,12,4,8,8,5,5,5,,4,,,4,4,10,
   10,4,4,4,,,4,10,10,4,4,,10,5,5,5,5,5,5,6,4,4,,7,6,
   5,5,4,,4,,,4,12,8,8,4,12,4,5,5,4,,,,4,,,12,4,,,4,4,
   12,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,12,12,4,4,,10,12,8,12,,
   4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,,4,8,8,7,4,6,4,4,7,13,
   13,8,8,6,6,4,4,4,7,8,8,3,4,13,19,13,13,3,4,4,4,13,
   19,13,13,3,4,4,5,6,6,5,3,3,3,4,4,4,6,19,19,4,4,7,
   8,8,6,5,13,13,6,19,19,4,4,3,4,,,4,4,4,4,3,,,4,,,3,
   4,4,4,4,4,4,3,4,,,4,5,,5,10,10,,4,4,10,10,4,4,4,,4,
   ,5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,
   ,10,10,4,,4,4,4,4,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,4,4,4,3,,,,,,3,4,4,4,4,4,4,3,4,,6,5,5,,,9,11,11,,
   4,10,22,4,4,5,,7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,
   4,,,4,4,,10,4,10,,4,4,4,10,10,4,4,,4,,,4,,5,4,4,4,4,
   5,3,4,3,,,4,4,,,4,4,,10,4,10,,4,4,4,10,10,4,4,3,6,
   6,4,,,3,3,4,3,3,3,3,2,4,,4,3,,,3,8,7,8,3,8,8,8,3,
   3,8,7,3,,,,,,5,4,4,4,4,5,3,4,3,6,,4,5,12,,5,4,23,
   10,5,7,,5,5,4,7,10,5,4,4,,,4,3,3,3,3,4,2,3,3,4,,3,
   4,4,,4,4,10,7,4,4,10,4,4,4,4,7,4,3,4,,,4,4,4,4,5,
   4,4,3,,,,4,,,5,9,13,16,4,,16,,4,5,9,13,5,4,,,4,4,4,
   4,5,4,4,3,,,,4,,,5,9,13,16,4,,16,,4,5,9,13,5,,,3,3,
   3,3,4,3,3,3,4,,4,4,4,,10,,10,8,6,4,16,6,4,3,4,7,6,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,12,5,,,,,11,,
   15,19,11,,4,4,15,,12,4,,4,,3,4,3,,,3,3,,,3,3,7,7,3,
   8,8,3,8,8,8,8,3,4,3,,4,,4,5,,5,5,5,,5,4,10,,4,4,
   10,4,10,10,4,,4,4,10,,4,3,,,,3,,,4,4,7,16,4,6,8,4,6,
   6,,8,3,,4,,4,5,,5,5,5,,5,4,10,,4,4,10,4,10,10,4,,4,
   4,,,,,5,,,,,4,11,,15,12,11,4,,,15,,19,4,3,3,,,3,4,,4,4,
   7,10,4,4,7,4,4,4,4,10,4,,5,,5,,5,,,4,11,14,,4,10,4,
   22,9,5,,7,3,,3,,3,,,3,8,7,8,3,7,3,8,8,3,8,8,,4,4,,,
   4,5,,10,4,22,11,4,,7,9,11,4,,,,,,,,,,,,,,,,,,4,5,,5,7,10,
   ,5,5,10,7,5,5,4,23,4,4,,,5,,10,22,4,14,4,,7,4,11,9,
   ,4,15,,11,4,,,19,15,12,,11,4,,,,,,,,,,,,,,15,,11,,4,,12,
   15,19,4,11,,10,16,8,9,8,4,3,4,6,21,6,8,16,33,,8,8,
   10,21,,21,10,10,,21,21,33,8,,8,4,21,6,6,9,3,8,4,21,
   5,6,8,4,8,3,10,10,8,16,8,33,4,3,9,33,8,4,8,16,9,6,
   21,5,10,4,10,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,
   4,4,4,5,5,,10,10,4,,4,10,10,4,4,4,4,,,4,4,4,4,3,,6,
   5,,,3,4,4,4,4,4,4,3,4,,,,5,,7,,,12,5,4,8,8,4,4,4,
   12,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,
   3,4,4,4,3,4,4,4,3,,5,5,10,10,4,4,,10,10,4,4,,4,4,
   4,4,3,,,3,6,6,3,3,3,3,4,3,3,2,,4,4,3,6,6,4,4,4,4,
   3,4,4,4,3,3,4,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,
   4,3,,5,5,10,10,4,4,,10,10,4,4,,4,4,,,5,,,,4,4,5,3,4,
   4,4,3,4,4,4,3,,5,7,8,8,4,5,12,,,4,4,12,4,5,,3,,6,
   6,3,3,3,2,4,3,3,3,3,3,3,3,6,4,6,6,6,3,4,4,6,6,4,
   4,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,
   ,,4,7,,5,8,8,12,4,5,,,4,4,5,12,4,,,3,4,4,3,4,4,5,
   4,3,4,4,4,7,5,,,,4,12,5,8,8,4,4,5,4,12,3,4,4,5,4,
   4,4,5,4,6,13,13,6,,,,,,,,,,,4,4,,,,4,4,5,4,4,4,5,4,6,
   13,13,6,,,,,,,,,,,4,4,,,,4,,3,,4,4,3,,4,4,3,,4,4,4,4,
   3,3,8,4,4,7,7,8,3,3,,4,4,3,,4,4,,,4,6,6,6,4,4,5,
   5,5,4,4,4,4,5,5,5,4,10,,6,4,,,,4,,6,6,5,5,5,5,7,5,
   5,6,6,,4,4,,4,4,3,4,6,6,4,4,,4,4,4,8,3,3,4,4,7,7,
   3,8,3,4,10,,,6,6,,,,,4,4,12,12,12,4,4,,,8,10,12,,4,4,,
   ,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,
   ,4,5,5,6,6,5,5,7,3,4,4,,4,4,,4,4,3,8,3,4,4,7,7,
   3,3,8,4,4,3,12,6,4,6,6,4,3,6,4,4,,6,6,4,3,3,4,6,,
   6,7,7,,5,5,7,7,6,6,5,,5,4,6,,6,7,7,,5,5,7,7,6,6,5,
   ,5,4,6,12,6,6,4,6,3,4,4,,6,3,4,6,6,6,,,5,5,,,,10,
   14,,5,5,6,,,,5,5,,,14,10,5,,5,,,5,,5,,,11,14,5,5,,3,8,
   8,13,4,4,3,4,13,13,19,8,8,13,4,4,3,4,13,13,19,4,4,
   8,8,7,6,4,6,4,4,13,13,7,7,4,4,6,8,8,6,5,6,4,4,3,
   4,3,13,19,8,4,3,13,19,8,3,5,6,7,6,5,6,4,4,4,6,5,
   6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,6,,5,,,6,,11,
   13,5,,6,6,6,5,11,13,5,4,6,6,5,,6,,,,4,5,6,4,5,6,6,
   5,4,5,6,5,7,7,,11,13,6,,6,13,21,5,5,6,6,,4,4,,3,,4,,
   ,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,10,10,,5,5,5,
   10,4,10,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,,4,3,4,4,4,,
   3,8,4,7,4,8,3,3,3,4,4,7,6,4,6,4,6,,,3,3,4,2,3,3,
   4,3,3,3,3,3,,3,,7,8,3,8,8,7,8,3,3,8,3,7,,,6,,,7,6,
   5,6,4,7,4,6,5,6,5,4,5,,5,,6,,5,13,11,,6,6,6,11,5,
   13,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,10,10,,
   5,5,5,10,4,10,4,3,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,
   16,4,16,,13,9,5,4,9,5,13,4,,,3,3,3,3,4,3,4,3,,4,,4,
   4,10,,6,12,6,8,4,8,,3,4,4,6,7,,,4,4,4,3,5,4,5,4,4,
   4,4,4,,5,,,16,4,16,,13,9,5,4,9,5,13,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,3,4,4,3,4,4,5,4,4,5,10,5,,,,,11,10,,12,11,,4,4,
   13,15,,4,,3,,3,6,4,,4,3,4,,3,,3,7,3,7,8,7,3,8,7,8,
   3,8,4,4,,4,,3,4,,4,,5,5,,4,10,4,,4,10,4,10,10,4,4,,
   3,10,,6,4,,4,,4,,4,,4,7,4,16,6,7,4,6,6,,3,8,,3,6,4,
   4,6,4,6,3,,,3,8,8,7,3,8,3,7,8,3,8,8,4,,,,,4,,,,,4,
   11,11,,13,11,4,,,9,11,,6,4,3,4,,4,4,4,,4,7,4,10,4,7,
   4,4,4,4,4,10,,6,,6,,7,7,,5,13,6,,6,13,5,21,11,6,6,,
   4,,4,,5,5,,4,10,4,,4,10,4,10,10,4,4,,4,3,4,10,4,,4,
   16,4,7,6,10,3,,6,6,4,8,4,3,5,,,5,13,9,13,5,16,4,,9,
   4,,16,4,4,,,6,8,,10,3,8,6,4,4,4,6,16,5,,,5,13,9,13,
   5,16,4,,9,4,,16,4,,11,,4,11,,,13,9,12,,4,11,,19,,,11,4,
   ,11,15,15,4,,11,,,,,,,,,,,,,10,5,21,7,8,4,3,4,8,9,33,
   21,,24,,8,8,10,27,16,8,10,4,12,6,8,6,3,4,8,10,,12,
   27,21,8,8,,34,8,6,5,4,3,8,10,10,8,24,21,,4,3,7,5,
   21,4,5,6,20,7,8,16,4,10,10,4,4,4,4,4,,,,,,3,4,4,4,
   5,4,4,4,4,,,,5,,,16,,16,,4,9,13,5,4,5,16,9,,4,,5,,3,
   5,,5,4,4,4,4,5,3,4,3,,,4,,,12,5,5,,7,5,10,17,4,4,5,
   10,7,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,,,4,,13,13,6,5,,7,
   6,7,,5,5,5,7,7,6,4,4,6,6,6,,,3,3,4,3,4,3,3,3,4,,4,
   ,,9,4,8,,6,4,8,6,12,4,3,8,6,4,,,,,,6,4,4,4,4,6,3,
   4,4,,,4,,13,13,6,5,,7,6,7,,5,5,5,7,7,6,5,6,,,6,4,3,
   4,4,6,3,4,4,,,4,,5,10,5,5,,6,5,5,9,6,6,5,5,6,5,,5,,
   ,4,4,4,4,5,4,4,3,,,,,,19,7,,,13,5,,14,8,4,5,9,27,7,,,
   ,4,4,4,4,5,4,4,4,,,,,,,,24,,10,12,12,24,,5,5,10,28,12,
   ,,4,3,4,4,6,4,4,4,,,,,6,14,14,,,16,8,6,9,,6,4,6,22,
   8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,5,6,6,5,5,6,,24,,,,,,,,
   19,13,10,,6,5,13,99,,4,,4,,3,4,4,,,3,,,10,4,3,,6,4,8,
   6,4,12,8,8,6,4,4,,,4,,5,5,,5,,5,,7,4,,12,5,4,8,4,8,
   ,4,12,5,4,16,,4,4,,,,,,10,6,4,,10,6,6,6,6,10,6,,6,4,
   ,4,3,,5,,5,,5,,,4,,16,,4,9,5,13,16,5,13,9,6,,,,,7,,,,,
   5,,,31,15,10,6,,,14,133,,4,4,3,,,,4,14,6,4,,8,6,4,6,
   6,6,4,4,8,6,,5,,5,,5,,,4,,16,,4,9,5,13,16,5,13,9,5,,
   5,,4,,,4,,15,11,4,7,5,,14,4,15,11,,4,,25,14,6,5,,8,6,
   16,9,5,,7,30,8,6,,,,,,,,,,,,,,,,,,,5,,,19,,,,5,9,22,7,5,
   4,11,8,,,,,,,,,,,,,,,,13,5,13,,8,5,,14,14,12,17,,8,5,,,,,
   9,10,,,,,12,,,16,,,,5,,,,22,5,,,,10,8,8,8,,4,4,7,21,8,,,,
   ,,,,,,,,7,48,10,20,25,6,13,8,5,63,28,30,11,4,8,5,10,
   8,6,6,4,6,4,8,8,8,11,17,39,6,4,8,13,37,,7,8,45,8,
   13,11,7,5,,4,,,5,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,,
   9,10,4,,11,10,25,4,4,,5,7,4,4,4,,,,6,12,3,3,3,3,4,
   3,3,3,,4,4,4,6,6,,6,4,4,,4,4,6,3,3,6,6,6,3,,,5,,,,
   4,4,5,3,5,4,4,4,4,4,4,4,,5,,13,9,4,,16,,16,4,5,16,
   5,9,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,13,9,4,,16,,
   16,4,5,16,5,9,,5,,7,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,
   19,7,4,,,7,9,5,5,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,
   4,4,4,5,4,4,4,,,,,7,24,,14,8,13,,5,,,5,4,7,21,9,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,5,6,14,9,7,,,,,,19,,
   19,,,5,5,,,,9,10,13,10,13,13,13,12,20,25,,19,,,,,,,,,9,,
   10,12,,,,4,,3,,4,4,4,,4,4,4,,4,,6,4,3,,10,4,6,7,7,
   16,4,6,,4,5,,,5,4,,3,5,6,6,,6,5,4,,4,5,6,5,5,5,5,
   7,4,14,,,,,,,,,6,,8,6,5,,7,6,8,30,16,,5,9,,4,4,4,4,6,
   6,6,4,,,6,4,10,,3,4,6,7,8,4,16,6,13,13,,,6,9,,,,,7,
   5,13,,17,5,8,,,16,14,17,3,,4,,,,6,6,,7,6,5,,5,6,7,7,
   7,6,6,12,,4,,,,6,6,,7,6,5,,5,6,7,7,7,6,6,12,4,5,6,,
   5,5,,7,5,5,,5,5,7,10,10,4,4,23,4,4,4,20,6,,10,6,4,,
   6,4,6,,6,10,6,6,,5,6,,,30,8,9,,5,8,16,6,6,5,,7,,6,,,
   13,6,,,4,6,13,6,6,5,9,9,5,,,22,7,,,5,5,19,,9,4,8,14,
   6,,,31,5,,,,,18,13,,6,10,,81,,,,5,19,81,14,18,6,,10,,,,,,,
   ,,,,,,,9,,15,8,13,5,7,20,17,51,8,,11,5,12,4,5,30,26,
   31,,4,11,10,7,7,4,7,8,,,,,,,,,9,34,8,7,7,4,8,,5,4,27,
   22,63,7,6,13,9,20,4,9,6,13,8,9,8,6,8,8,4,,4,,,4,,5,
   4,4,4,4,5,3,4,3,,,4,4,,,4,4,,10,4,10,,4,4,4,10,10,4,
   ,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,10,10,4,4,,
   10,10,4,4,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,4,4,
   3,5,3,5,4,4,4,3,4,,4,,5,,4,10,10,,5,5,5,10,4,10,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,,4,,,4,7,,
   9,4,11,14,,4,5,10,22,4,,,4,4,4,3,5,3,5,4,4,4,3,4,,
   4,,,14,4,9,11,,7,5,4,10,4,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   4,5,3,4,4,4,3,5,5,9,4,,,,,11,11,9,,11,,4,4,,11,13,3,
   ,4,,4,,4,,,4,4,,5,5,4,10,4,4,,10,4,10,10,,4,4,,4,,4,
   ,4,,,4,4,,5,5,4,10,4,4,,10,4,10,10,,4,4,4,12,,3,4,,,
   ,4,,5,5,5,10,4,4,23,10,5,7,7,,5,5,,3,4,3,6,6,4,4,,
   ,3,3,8,8,3,7,8,3,8,7,8,8,3,4,,,,,4,,,,,4,11,15,13,,
   11,4,,,,10,12,4,3,4,4,,3,,4,4,4,7,4,4,10,7,4,4,4,
   10,4,4,,,,4,,,5,,4,10,4,,14,10,4,25,9,,5,7,4,4,3,,,3,
   ,3,7,3,8,7,8,3,7,8,8,3,8,3,4,4,,,5,5,16,9,5,13,
   16,4,,9,16,,4,4,4,,,5,5,16,9,5,13,16,4,,9,16,,4,3,,,
   4,6,8,,3,10,8,6,4,4,16,6,4,,4,10,4,10,4,6,7,8,3,,
   6,8,4,6,,,,,,,,,,,,,,,4,15,,,4,11,,15,19,11,11,,4,9,,4,,
   11,,12,11,13,11,4,,10,6,5,20,8,4,3,4,27,8,6,21,24,,,
   8,8,10,,12,34,4,10,16,8,9,5,8,4,3,10,27,7,8,7,8,3,
   4,8,16,33,21,,8,8,10,10,8,,21,24,4,3,21,6,5,4,21,5,
   7,12,6,8,10,10,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,
   ,,4,,4,10,4,10,4,,4,4,10,10,4,,,,,,6,4,4,4,4,6,3,4,
   4,,,4,,13,13,6,5,,7,6,7,,5,5,5,7,7,6,4,,,6,6,4,3,4,
   4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,,4,
   ,7,4,4,4,4,5,3,4,3,,6,5,4,,,4,5,12,,4,,12,5,4,4,8,
   8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,4,3,4,4,6,3,4,4,,4,5,
   6,5,5,10,,4,5,6,5,5,7,5,4,5,5,6,6,5,6,5,5,6,4,6,
   4,,,5,6,,,,5,,,14,,,5,5,5,,,10,5,4,7,5,6,6,4,4,,5,,6,,
   ,,,5,,10,,5,,5,5,,,14,4,,3,,4,4,4,,5,5,5,,,4,4,4,10,
   4,10,4,4,,,10,10,4,4,4,6,3,,3,,,3,3,6,6,4,3,4,4,3,
   4,4,3,4,4,4,4,3,,,,4,4,,5,,5,,,4,5,4,8,4,8,4,5,12,
   12,,,4,,4,4,4,,5,5,5,,,4,4,4,10,4,10,4,4,,,10,10,4,
   6,12,,,7,7,,,,,5,5,,11,,5,5,,,,,14,3,3,,3,,3,6,6,4,4,
   3,6,4,6,3,4,4,4,6,6,4,,,,3,,6,6,,3,4,4,,4,4,3,6,6,
   6,6,6,,3,3,,4,4,,3,3,4,7,4,3,3,8,8,4,4,7,,,,,,,,,,,,,,
   ,,,,,4,4,,,4,4,12,8,4,8,12,4,5,5,,,4,4,,,4,12,4,,4,,
   4,12,5,5,8,8,4,5,5,10,5,5,5,6,5,4,4,,7,5,5,6,3,4,,
   ,,4,,,,,,,,4,4,,,,4,,,,,,,,4,8,10,4,,4,14,12,12,12,4,4,,
   4,13,5,13,4,6,4,4,13,13,6,19,6,19,6,4,4,4,13,13,5,
   4,3,8,8,13,8,4,4,3,4,7,6,7,7,3,3,3,8,8,13,8,4,4,
   3,4,4,4,8,8,6,4,4,13,13,5,6,19,19,7,19,19,6,3,4,4,,
   ,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,13,9,4,,16,,16,4,
   5,16,5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,
   10,10,5,,5,5,10,4,10,6,6,,,5,6,6,4,5,5,6,4,5,6,5,4,
   ,7,7,13,21,6,6,,11,13,5,5,,6,6,6,7,,5,4,6,6,7,5,4,
   4,,6,,6,,,5,,6,11,5,13,6,,6,6,13,21,5,7,,5,4,6,4,7,
   5,6,6,5,4,5,6,,5,,,6,5,11,13,6,,6,6,13,5,21,,4,4,5,
   3,4,4,4,3,5,9,5,4,,,,11,,10,12,,,11,4,4,,15,9,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,10,4,5,5,,4,10,
   10,10,,5,5,6,3,4,4,,3,4,,4,3,,4,4,7,4,3,3,8,4,7,4,
   4,8,3,3,6,,,6,6,,6,,6,,7,7,13,5,6,6,,5,13,11,21,,6,
   6,,4,3,3,6,4,6,4,,,3,8,3,7,3,8,3,8,8,7,7,8,3,,10,,
   ,4,,,,,,11,4,19,11,,4,11,,,,11,13,4,4,,4,,4,,5,5,10,4,
   5,5,,4,10,10,10,,5,5,,4,,4,,,4,,7,4,3,,8,4,7,6,6,10,
   4,6,4,3,4,,,3,,7,3,3,7,8,3,8,7,8,7,3,8,4,3,4,,,5,
   16,5,,4,16,4,16,,9,13,9,5,4,3,,,4,8,6,6,4,12,6,8,4,
   4,8,,3,4,,,5,16,5,,4,16,4,16,,9,13,9,5,,4,10,10,4,4,
   6,7,3,8,,6,7,4,6,,,,,,,,,,,,,,,4,,15,,4,11,10,,12,9,11,,
   4,,11,4,,11,19,,11,13,11,4,,10,12,34,,8,,8,10,,17,14,
   6,8,12,4,8,3,4,17,6,5,4,10,5,21,7,8,8,4,3,10,7,24,
   7,6,8,3,4,21,,24,34,,8,8,10,4,3,12,6,8,10,8,,12,34,
   4,34,8,6,14,5,6,10,10,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,6,3,4,4,,,,,13,17,6,9,,
   16,6,8,,,4,6,8,13,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,5,4,7,4,6,6,5,5,6,5,20,6,,,,,10,14,,251,,,
   5,6,,11,27,,,4,,4,3,,,,4,,,5,,5,9,4,,16,,4,16,13,13,5,
   9,,4,,4,,5,3,,4,5,,5,7,4,8,4,5,12,,4,,8,12,4,5,4,24,
   ,,,,,,,,5,,7,9,4,8,14,,5,15,27,,5,,,3,4,4,6,6,4,6,10,
   ,4,4,6,8,4,6,,3,10,16,6,8,4,6,,,,,6,,,,,6,10,16,,81,,
   5,,,81,15,22,4,4,4,4,,4,14,4,6,6,6,4,6,8,,4,4,6,8,
   4,6,,,,4,,,5,,5,9,4,,16,,4,16,13,13,5,9,6,5,4,,,4,,5,
   7,4,11,15,,4,14,,15,4,11,,4,,,9,9,5,9,6,6,13,,4,,9,
   13,6,6,4,5,24,,7,4,11,9,7,22,,5,,8,19,,5,4,20,,6,8,
   6,,4,6,,6,4,6,8,6,6,25,6,14,6,9,6,8,16,,4,,,50,6,8,
   13,,,,10,9,,,,,,,12,,5,13,20,,5,8,,11,15,16,8,,5,,,5,,,,
   18,16,,,5,,8,6,23,20,,,4,6,13,9,44,13,37,48,,8,8,8,
   81,8,65,5,7,,6,8,7,6,4,4,,,9,9,29,8,4,5,,10,24,10,
   13,6,8,,,,,,,4,4,13,6,8,,10,8,11,11,9,26,7,,5,4,,,7,
   4,4,4,3,5,3,5,4,4,4,3,4,,4,,7,9,4,,,19,7,5,5,8,4,
   8,,6,,4,3,4,4,6,3,4,4,,4,,,5,10,5,9,6,6,5,5,5,,5,
   6,5,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,4,6,4,7,5,6,
   14,4,6,,,,6,,14,,,,6,6,6,,14,,5,4,7,4,6,6,5,5,6,4,
   14,6,,,,,6,14,,,6,,6,6,,18,,4,,4,,4,,3,,4,4,,,4,,5,5,
   4,10,10,5,5,,,10,4,10,4,3,6,3,,4,4,,3,4,6,4,6,4,6,
   3,4,4,6,4,6,6,4,3,4,4,,,6,,,4,,,,4,,7,5,4,8,8,5,7,
   19,9,,4,,,3,4,4,6,4,4,6,4,,4,4,4,7,4,4,4,4,10,10,
   4,7,4,6,,,,6,6,,,,,6,6,18,,,6,6,,,,14,,4,4,4,3,,4,6,
   4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,,4,,5,7,4,,,7,5,
   9,19,8,4,8,,4,4,,,4,,5,5,4,10,10,5,5,,,10,4,10,4,4,
   3,13,6,13,6,6,6,7,7,5,5,,12,7,6,7,3,4,6,,6,4,8,6,
   6,6,8,4,6,6,4,,4,4,6,,6,8,4,,4,4,4,8,6,6,6,6,6,
   13,6,13,6,6,6,7,7,5,5,,12,7,6,7,4,3,,,4,,,,,,,,4,,4,
   12,16,,4,4,16,10,12,10,4,,4,,,4,,,,,,,,4,,6,7,12,12,4,
   9,4,6,19,8,19,6,11,11,9,4,4,6,12,7,12,4,4,7,6,8,7,
   3,3,3,3,12,11,19,12,4,3,4,12,11,19,12,4,3,4,6,6,4,
   11,6,11,6,4,12,7,12,9,12,7,12,11,6,11,4,3,4,4,,,4,
   4,4,4,5,4,4,3,,,,4,,,5,9,13,16,4,,16,,4,5,9,13,5,,,
   4,4,4,3,5,4,5,4,4,4,4,4,,5,,,16,4,16,,13,9,5,4,9,
   5,13,,12,13,13,10,13,10,13,10,24,,17,12,,,,9,,,,,,,12,10,
   ,,,5,6,6,4,5,5,6,4,7,,13,6,,,,,,19,19,,,,5,5,,,,,,4,,5,
   ,4,,3,5,4,,5,5,5,7,5,5,,6,5,10,10,23,4,4,3,4,13,,,
   4,,,,4,,6,6,6,7,5,5,,7,6,7,7,,5,5,4,13,,,4,,,,4,,6,
   6,6,7,5,5,,7,6,7,7,,5,5,,4,4,3,6,6,6,4,,,4,4,6,8,
   3,,6,4,8,7,6,16,4,5,14,,,,6,,,,,5,8,12,17,,7,5,,,23,
   10,14,,4,5,6,,4,,6,6,5,6,5,5,,6,5,5,5,9,6,6,,,,,,,6,
   ,6,8,4,,,8,6,16,30,,6,9,4,4,4,,,4,,4,6,3,8,,6,4,7,
   7,6,4,16,,5,4,,,5,7,21,,5,,15,5,,9,14,8,4,,4,,,5,10,
   28,18,5,,10,12,12,12,24,,5,4,,,6,8,13,,4,,16,8,6,6,9,
   ,6,,6,20,6,12,4,6,,6,4,,6,6,6,10,,,,,,,,,,,,,,,6,,,,5,,,
   19,13,18,10,,6,23,,5,,,,,11,15,10,6,,,11,9,,8,5,4,5,
   41,44,29,10,34,,13,12,6,7,81,11,10,4,,9,8,8,8,8,,4,,
   15,11,9,10,8,4,,,,,,,,,,7,5,48,10,25,5,4,63,28,38,4,
   13,8,8,8,9,8,8,8,6,6,,4,3,4,4,6,4,4,4,,4,,,6,13,13,
   ,5,7,7,6,5,,5,5,6,7,7,,5,6,5,5,6,4,6,4,,19,,6,,,,
   10,,,13,19,,,5,6,,,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,
   5,,5,,,4,7,5,22,4,10,4,,14,,11,9,4,4,4,6,4,,3,,,,3,
   6,12,4,6,6,6,3,4,4,,4,6,4,6,3,3,,,4,4,,5,,5,,,5,9,
   5,13,5,9,4,,16,13,,16,4,,,4,4,,5,,5,,,5,9,5,13,5,9,4,
   ,16,13,,16,4,,16,,,7,,,,,,10,6,162,11,,5,,,,31,,15,4,4,,
   5,,5,7,,5,8,4,19,5,7,4,,,8,7,9,5,,,,,,6,12,,6,6,6,,
   4,4,,6,10,6,12,6,,3,,,4,10,,6,4,6,7,4,3,,8,12,4,6,8,
   ,,,,,,,,,,,,,,,,,,,4,,,5,9,27,17,4,8,15,,5,7,,,5,,,,,,,,,,,,,
   ,,,,6,13,25,,6,8,16,6,4,,,9,6,8,30,,5,,,,5,,19,,25,,,,
   5,13,,,,12,,,,,,9,,10,17,10,8,,5,17,,17,14,5,8,,8,48,
   10,63,8,,8,8,41,81,8,10,8,28,,,4,6,44,11,7,7,,10,,15,
   12,12,13,6,5,8,,9,8,4,6,4,8,,11,38,5,12,4,,4,4,11,
   10,8,,,,,,,13,34,10,29,10,8,,5,7,,5,6,5,4,6,4,7,5,6,
   12,5,5,,,,,,14,251,,,10,6,5,23,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,4,,5,,,,4,5,3,,4,,,4,4,22,10,5,7,,14,11,4,9,4,3,
   6,4,,4,4,,4,4,6,4,12,,4,3,6,4,6,6,6,4,4,3,6,4,,,,3,
   ,4,,,,5,,,4,5,13,9,5,9,13,16,,4,16,,4,4,4,6,4,6,6,4,
   ,10,,3,7,6,4,4,6,16,10,4,8,6,,24,,,6,,,,,,,5,17,,23,
   6,10,,,,14,,,,5,4,,6,7,5,,,4,5,19,7,4,8,8,,7,5,9,,,,,,
   ,5,,,5,5,,,7,9,27,15,8,4,17,,4,,,,5,,,4,5,13,9,5,9,
   13,16,,4,16,4,5,,14,6,14,,5,6,30,8,5,7,,9,8,6,16,4,
   4,6,,16,,6,6,12,6,10,6,6,4,4,,6,,7,,24,,5,,15,5,4,
   14,8,,7,9,27,,,,,5,10,28,10,5,24,,15,12,10,10,5,,,19,5,
   ,,,,,25,,5,,13,,13,,8,5,14,23,12,17,5,,8,,,12,,,,,,,9,10,
   ,,,,,,,,,,,,6,10,9,,8,4,4,9,8,13,7,5,6,13,9,8,4,4,6,,
   20,48,17,18,12,6,13,23,37,45,10,5,4,12,8,6,4,28,9,8,
   8,8,41,10,17,,22,6,9,11,9,20,5,,7,4,4,5,4,4,4,5,4,
   6,13,13,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,,,4,,10,12,,,
   4,11,11,,13,9,13,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,5,13,,,5,,
   14,,5,,,,5,,14,12,23,,5,7,8,,14,13,,4,,5,7,,5,7,,,,4,,,
   15,11,,4,11,11,19,,15,4,,,,,5,,,,,4,,,,,,4,,,,,,6,4,4,10,
   ,4,,,,4,,16,12,10,,4,4,4,12,16,10,,,,6,,,,,5,,25,,16,,5,
   ,,,,,5,,4,,,,,4,,15,,9,,4,11,11,12,13,,,5,6,,,,6,,19,14,
   81,,5,,10,81,,18,13,,,,,12,,,,,,10,9,,,,,5,,,,8,,,15,11,,
   8,5,5,13,20,16,,,,6,,19,,11,,5,,10,16,,150,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,20,32,20,,5,3,4,34,52,32,,,,,,,,,,,,,,
   44,52,22,,,,,,35,34,18,,,,,32,32,18,,,,,,,,,,4,3,18,22,18,
   5,33,20,20,35,44,32,,,,4,,5,,,5,5,,4,,5,,,,,4,15,11,,4,
   ,11,11,,15,15,6,4,4,4,,4,4,,10,4,,,,,4,10,8,12,4,,4,
   4,12,12,12,,,,,,,6,,,,,,,5,,,,5,,,,,19,25,,,5,5,7,5,,7,,,,
   ,4,,9,13,4,,11,11,11,,12,3,13,,,5,,,,,,,4,,,,4,,,,,,,13,,
   ,5,,,,,,,4,,,,4,,,,,,,,5,,25,,,,,,5,21,,12,5,,8,7,14,16,
   17,5,4,,,,,,,4,11,,13,4,,11,11,11,19,,5,,6,,,,,6,,18,,5,,
   ,10,,31,13,13,5,,,,,8,14,12,14,8,,5,5,13,,17,,,,,,12,,,,
   10,,9,,,,,,,,,6,,,16,5,,,10,17,27,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,44,32,35,5,,3,4,29,30,33,,,20,,46,48,,,,
   ,20,,19,53,,,,32,,26,73,,,,,4,3,31,26,52,,,,,,5,26,31,
   34,20,27,26,,,,,4,,4,,4,,,4,4,,5,5,4,10,4,4,,10,4,10,
   10,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,4,10,
   4,10,4,4,,,10,10,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,5,5,
   10,4,5,5,,4,10,10,10,,5,5,,,,4,,,5,,5,9,4,,16,,4,16,
   13,13,5,9,,4,4,,,4,,5,5,4,10,10,5,5,,,10,4,10,,,,,,,,,,,
   ,,,,,,,,4,4,,,5,4,25,7,5,,9,4,11,11,14,,4,4,,,5,25,4,,
   4,14,4,9,11,11,,7,5,,5,12,4,4,5,7,10,5,5,,14,10,5,6,
   ,,,,,,,,,,,,,,4,12,10,,4,11,11,9,,,11,,4,11,15,4,,11,15,
   15,,,11,4,,4,7,6,27,3,4,8,10,21,6,6,6,7,16,4,3,8,
   10,21,6,5,4,10,6,5,20,16,8,4,3,10,6,6,21,27,8,3,4,
   21,24,,8,,8,8,4,10,8,33,8,7,10,8,27,7,6,,8,16,27,,
   21,24,10,10,4,4,13,,,4,,,,4,,6,6,6,7,5,5,,7,6,7,7,,
   5,5,,4,,4,5,,5,5,5,,5,4,10,,4,4,10,4,10,10,4,,4,4,,,,
   ,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,
   4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,,5,5,,4,10,4,,4,10,4,10,
   10,4,4,,,4,4,,7,5,4,8,5,4,12,,4,,8,12,5,4,,,,,,,,,,,,,,,
   ,,,4,6,,6,6,5,,4,4,5,6,5,5,5,7,5,5,7,,4,8,5,12,4,,
   4,,8,4,5,12,6,6,11,,5,5,,,14,,,,5,5,6,14,,,5,5,,10,,,
   5,,5,10,,5,,5,,14,,,5,5,,4,6,5,7,3,3,3,4,7,7,6,19,
   13,8,4,3,4,3,13,8,8,4,4,13,5,13,19,4,6,4,4,13,6,
   13,13,4,4,6,19,6,19,8,6,4,4,4,3,4,8,8,13,4,3,7,6,
   5,4,8,8,13,13,8,8,4,4,4,,,4,4,,5,,5,,,5,9,5,13,5,9,
   4,,16,13,,16,4,,,,,14,,,,,,9,10,,,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,5,,12,10,5,,24,12,10,28,28,,5,15,,4,,,,5,,,4,5,
   13,9,5,9,13,16,,4,16,,,,,,,,,,,,,,,,,,,,4,,,6,6,22,9,6,,
   16,6,8,8,,,4,,,,,,,,,,,,,,,,,,7,24,8,4,7,27,9,5,,,17,,5,
   15,,,,,,,,,,,,,,,6,23,12,,6,10,14,,251,,,,5,,14,6,,10,17,
   23,,,,5,,5,27,22,41,4,5,8,,,9,11,9,6,11,4,4,5,7,,8,
   7,6,8,6,23,20,8,,,4,8,9,45,17,9,,4,,13,37,48,17,,8,
   8,5,7,6,,6,8,,12,,9,10,13,,10,18,,13,20,,,4,,,,,,,,,,,,,,,
   ,,,,,,,,4,4,5,5,,5,5,,5,10,4,,5,5,4,10,10,10,5,,5,,5,
   ,5,,5,,,4,,16,,4,9,5,13,16,5,13,9,5,5,5,,4,,,4,4,10,
   10,4,4,4,,,4,10,10,6,6,6,,,5,6,6,13,5,21,6,6,,,11,
   13,5,6,6,7,,7,5,11,,6,6,11,5,13,13,6,,6,6,7,,7,11,5,
   ,6,6,5,11,13,13,6,,6,5,,,6,6,13,21,5,6,6,,,5,13,11,,
   4,13,15,11,4,,10,12,,,,11,4,,,,,,,,,,,,,,9,11,11,,4,14,13,
   ,,4,11,,4,24,5,7,3,4,8,10,8,27,7,21,6,5,4,3,8,10,
   9,33,8,10,10,12,34,,,8,,8,4,8,6,27,20,3,8,4,6,8,12,
   21,4,8,3,4,10,8,5,21,6,10,8,7,24,5,,21,,21,33,8,16,
   10,4,10,13,,,5,,,,,,,4,,,,4,,,,,,,,,,14,,,,,12,,,,,9,10,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,,5,,,,,,5,,,16,,22,,,,,,
   5,,16,18,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,4,31,26,34,3,5,,,19,46,26,26,31,52,5,3,,,20,20,32,,,
   30,27,,,,,,,29,20,,,,,,33,26,,,,,,4,,,32,44,35,,,53,48,73,,,
   ,,,,,,,,,4,,,,6,6,,7,6,5,,5,6,7,7,7,6,6,12,4,4,,,5,5,
   ,10,4,5,,5,4,10,10,10,5,5,,4,,4,,7,5,8,4,7,5,9,4,,,
   8,19,7,5,,4,6,,6,5,6,9,6,6,6,5,5,5,5,,5,,,,,,,,,,,,,,,,
   ,5,7,,8,4,7,9,5,4,,,8,5,7,19,6,6,,18,6,6,,14,,,,,6,
   6,6,,14,,6,6,14,,,,6,,6,,14,6,,6,18,,,,6,6,,4,11,12,
   12,3,4,4,3,19,12,11,6,7,7,3,3,3,4,8,7,6,6,6,7,12,
   12,11,4,9,4,6,8,19,19,12,4,4,9,6,11,11,12,9,4,4,4,
   4,3,7,6,7,3,4,12,11,12,4,12,11,12,19,12,11,6,6,6,,,,,
   ,,,,,,,,,,,,,,,,4,,19,7,,4,8,5,,19,,5,,14,22,7,9,,,,,,,,,,,,
   ,,,,,,,6,,,50,6,,,4,6,16,8,8,6,9,,,,,,,,,,,,,,,,,6,,17,27,
   5,,,,16,,,,6,10,,16,,,,5,19,11,,,6,,10,,,,,,,,,,,,,5,8,,7,
   4,4,6,7,8,8,11,13,,9,5,4,12,,44,29,53,,4,11,6,15,10,
   4,,8,,,,,,,,,8,7,10,7,,4,8,5,,8,28,38,43,7,5,8,8,9,
   13,10,12,44,12,10,,6,8,8,4,4,,12,5,,4,4,5,10,7,5,5,,
   23,7,5,10,4,,5,,,4,15,7,,5,15,4,11,11,4,,14,,5,,,15,4,
   ,14,4,4,15,11,11,5,7,,,,,,,,,,,,,,,,,4,,11,19,4,11,,11,
   13,,,,4,11,,12,10,,11,4,15,9,,,4,,11,,,,,,,,,,,,,4,8,34,
   6,3,4,8,10,7,7,24,6,12,8,4,3,8,10,7,5,21,10,4,6,5,
   17,12,3,4,8,10,17,14,,,8,8,,5,6,14,34,4,3,8,4,10,8,
   8,6,12,10,8,6,8,34,,34,12,,24,21,,4,10,10,4,4,,,5,5,
   16,9,5,13,16,4,,9,16,,4,4,,,5,16,5,,4,16,4,16,,9,13,
   9,5,13,6,13,6,6,6,7,7,5,5,,12,7,6,7,,13,,,9,10,,,,,,,
   ,12,5,,,,5,,19,19,,,,,5,16,14,5,,8,14,17,,17,7,5,,6,
   27,9,13,4,7,,8,20,30,8,22,6,9,7,4,,8,17,27,9,5,,11,
   9,,63,8,5,4,7,7,8,,13,5,4,4,10,34,,20,13,12,6,4,,8,
   9,8,7,,8,15,11,7,,,,,51,31,8,,7,5,4,6,,6,7,7,,5,5,7,
   7,6,6,5,,5,5,,,5,13,9,13,5,16,4,,9,4,,16,,6,13,99,
   10,6,,,13,19,,,,5,,,,,,,,,,,,,,14,133,10,,6,,15,31,,5,,,7,
   11,7,8,6,4,4,5,7,,8,17,8,13,13,6,8,,21,,13,8,8,48,
   10,63,39,8,,8,6,20,6,30,45,4,,,10,8,28,37,,,4,7,,8,10,
   ,25,5,4,8,,6,5,8,,11,8,,11,,4,,5,,,13,5,,16,4,4,16,,
   9,5,9,13,,6,,11,,5,,14,,,27,,10,6,,,,,,,,,,,,,,81,15,,,5,
   16,81,,22,6,10,,7,,10,13,6,13,8,,13,81,11,,8,6,4,6,4,
   5,9,8,9,,,,,,,,,,4,8,24,9,11,4,8,,6,10,9,8,,8,4,7,5,
   4,6,13,7,,8,20,48,10,5,23,37,29,44,31,26,8,6,8,5,13,
   14,16,5,8,,21,12,,17,,5,7,,,,,,5,25,16,,,5,,,,,9,,10,,,,,
   12,,,6,28,10,8,4,,,8,8,44,12,38,12,8,,4,,8,8,29,10,,
   5,11,8,,43,4,5,8,7,15,10,,44,6,12,13,6,7,,9,4,4,5,4,
   ,8,8,13,10,,8,7,9,7,,,,,11,53,,5,7,,4,,,,4,,,,,,,,4,,,4,
   ,,,,,,,4,,,31,26,,,,,,,29,20,26,31,,,,,,,30,27,4,,20,32,
   20,52,,5,3,,46,26,20,34,,3,5,,,,,,,,,,,,44,48,,,,35,73,,,
   32,54,,33,26,,,4,,,,,4,,,,,4,,,,,32,18,,,,,34,,35,,20,22,,,,
   ,52,,44,,,,,,,,,,4,52,32,34,20,3,,5,44,32,35,18,5,,3,,,,
   20,,22,,,20,,18,,32,,37,32,,32,,4,,,32,,53,,,,,19,20,,44,,
   48,,,,,46,20,,,4,30,33,67,35,3,5,,,,,,,,,,27,26,20,73,5,
   3,,,,,33,51,,,,34,52,,,26,31,,26,32,,4,,,8,8,13,4,4,3,
   4,13,13,19,8,13,8,9,8,11,8,13,10,12,12,19,13,12,13,
   12,19,12,13,8,12,13,13,9,4,3,3,8,13,8,4,4,13,13,9,
   4,13,8,8,19,12,11,13,19,13,8,19,9,8,13,19,13,9,8,11,
   13,10,8,13,8,8,9,19,10,8,8,13,10,10,4,4,4,13,9,19,
   3,3,13,10,8,4,13,8,12,13,8,8,13,12,8,4,13,19,13,13,
   3,4,4,8,8,13,8,4,4,3,8,13,10,8,9,10,12,10,12,19,8,
   13,12,13,13,8,19,10,4,3,4,12,11,19,12,4,3,4,13,13,
   13,8,13,13,19,9,8,8,9,13,13,8,13,8,12,13,3,4,4,8,
   19,8,9,8,10,11,10,13,10,10,9,19,10,9,9,8,10,4,4,3,
   4,3,13,19,8,4,8,8,13,10,8,10,8,11,19,4,12,11,12,9,
   10,10,13,12,8,19,19,13,19,12,13,19,11,19,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,12,,,12,,,12,,,
   ,,12,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,12,,,
   12,12,12,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,10,10,
   10,10,10,10,10,10,10,10,10,10,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,10,10,10,10,10,10,
   10,10,10,10,10,10,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,38,38,,20,20,38,20,20,20,20,38,4,
   4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,
   ,8,12,8,,,,,,,,38,,,38,40,38,,20,40,20,38,,6,6,6,8,10,
   10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,
   ,,,,,,58,58,,,58,,58,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,6,
   8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,20,38,38,20,,,40,38,,
   38,,40,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,
   8,,16,,16,,,,,,,,58,,,58,,,,58,,58,,,8,10,10,8,4,12,12,4,
   12,12,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,52,,,
   52,58,52,,38,58,38,52,,4,6,8,4,6,6,4,6,6,,,6,6,8,,8,
   12,12,,,,4,6,,6,,8,,8,,,,,,,,20,20,20,20,38,38,20,,38,,
   38,20,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,
   16,,,,,,,,,58,58,,,,58,,,,,58,8,4,12,12,4,12,12,,,12,12,8,
   ,8,,,,,,4,12,,12,,8,,8,,,28,28,,,,38,52,52,38,,,58,52,,
   52,,58,6,16,16,6,16,16,,,16,16,10,,10,,,,,,6,16,,16,,10,
   ,10,,,,,,,,,,,,,,,,,,,,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,
   ,4,,4,4,4,,,4,4,,,,10,10,10,10,10,10,10,10,10,10,10,
   10,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,12,
   ,,12,12,12,,,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,
   ,,,,,,12,,,12,12,12,,,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,
   4,4,4,,,4,4,,,,10,10,10,10,10,10,10,10,10,10,10,10,4,,
   ,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,12,,,12,12,12,,,
   ,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,12,,,12,12,12,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,12,,,12,,,12,,,,,
   12,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,12,,,12,,,12,,,,,12,,
   4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,14,14,,,14,,,,,14,,,,,,,,4,,,,
   ,,4,,,,,,,,,,32,32,,,,20,,,,,20,8,8,,,,4,6,,6,,4,,4,,,,,,,,
   ,14,14,,,14,,,,,14,,4,,,,4,,,,,8,,8,,,,,,,,40,,,40,,,,40,,
   40,,,,,,4,,,,,8,,8,,,,,,,,40,,,40,,,,40,,40,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,
   ,4,4,4,,,4,4,,,,10,10,10,10,10,10,10,10,10,10,10,10,,
   4,,6,,6,,,8,8,,,,12,,,12,,,12,,,,,12,,,,,,,,,,,,,,,,,,,,,,,,,,
   6,,6,,,8,8,,,,12,,,12,,,12,,,,,12,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,
   ,,,14,14,,,14,,,,,14,,,,,,,,,,,32,32,,,,20,,,,,20,,,,,,,,,14,
   14,,,14,,,,,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,24,32,,
   ,24,,32,,,,,,,,,24,32,,,24,,32,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,10,,,,,,,,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,,,,,,,,10,,,,,
   ,10,,10,,,,,,,,,3,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,
   12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,15,
   15,15,,15,,15,15,,15,15,6,6,9,,6,9,,12,,,6,6,6,6,6,9,
   6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,
   ,,,,15,15,15,,15,,15,15,,15,15,5,5,,4,7,10,7,12,,5,5,
   5,5,5,10,5,5,10,9,3,5,5,4,5,5,,,3,4,5,,5,,,,,,4,4,
   6,4,,5,6,5,,,5,5,,8,,11,,13,11,,14,11,6,12,14,6,9,5,,
   5,5,12,8,,,5,5,5,5,5,10,5,5,10,9,3,4,4,5,5,5,,,3,
   5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,14,11,13,,11,11,,13,
   6,11,6,13,,7,8,,7,,,10,10,10,10,10,10,10,10,10,16,4,
   7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,6,5,6,5,8,8,,,,,
   ,,,,14,14,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,5,,7,,,5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,
   5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,11,14,6,9,
   13,,11,13,6,,12,11,,7,,,10,10,10,10,10,10,10,10,10,16,
   4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,,10,,,,,,6,,,
   ,5,,,16,16,,10,,5,,,,,,27,,,,,,,,,6,,,,,,,,6,,,,,,,,,,,,7,,,,
   7,,,,,,,,,,,11,22,25,,42,,,,,,,,9,9,14,9,14,10,9,14,10,
   11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,11,9,10,
   9,10,10,8,8,,,,,,8,,,,,8,14,,14,,,,,,18,,,,,,,6,,,,,,7,,6,,,
   ,,,7,,,,,,,,,,,,,,,,,,,40,24,,,53,,,,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,6,7,7,3,5,5,5,
   6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,6,8,,,,,,8,,17,14,
   7,17,14,12,24,8,9,12,8,14,5,5,5,5,4,5,5,5,3,5,5,5,
   6,6,,,3,5,6,,6,,,,,,5,5,6,4,,8,6,8,6,6,,,,,,14,17,6,
   11,11,14,17,9,7,14,7,17,5,5,5,6,8,7,8,4,5,5,5,10,
   10,,,4,5,10,,10,,,,,,5,5,,6,9,7,,7,8,8,,,,,,32,35,11,,
   49,21,,7,9,25,9,32,5,5,5,5,5,5,3,5,5,5,6,6,9,,3,5,
   6,,6,,9,,,,5,5,9,4,8,8,9,8,,,6,6,,14,,12,24,7,14,17,
   17,14,7,8,24,8,11,5,5,5,5,4,4,5,5,5,10,10,,,4,5,10,
   ,10,,,,,,5,5,9,6,,7,9,7,11,11,11,11,,9,,21,,11,49,,32,
   35,9,11,49,11,,7,7,6,7,4,6,6,6,12,12,7,,4,6,12,,12,,
   7,,,,6,6,7,4,10,6,7,6,10,10,8,8,,10,,94,42,8,59,59,
   94,42,8,8,43,8,46,5,5,7,3,5,5,5,6,6,6,,3,5,6,,6,,6,
   ,,,5,5,,4,,8,,8,,,,,,14,,14,14,8,13,14,24,12,6,7,17,7,
   14,5,8,4,5,5,5,10,10,9,,4,5,10,,10,,9,,,,5,5,,6,,7,,
   7,,,8,8,,12,,25,49,9,25,32,,21,11,11,,11,55,7,4,6,6,
   6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,8,6,7,6,8,8,10,
   10,,,,81,48,8,148,46,46,94,8,8,48,8,90,4,9,9,9,8,8,,,
   4,9,8,,8,,,,,,9,9,10,6,,8,10,8,,,,,,,,30,,18,29,,38,38,
   8,18,29,18,,3,3,3,4,4,3,,2,3,4,,4,,3,,,,3,3,3,2,3,
   3,3,3,3,3,3,3,,3,,10,10,3,9,9,10,10,3,3,10,3,9,3,
   5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,11,
   13,13,9,11,,4,4,11,13,13,5,5,5,,,3,5,5,,5,,,,,,3,3,4,
   4,5,4,4,4,5,5,,,,,,,11,13,13,9,11,,4,4,11,13,13,5,5,,
   ,3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,11,,13,9,13,,
   11,4,4,14,14,9,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,
   5,5,5,5,,6,,,,5,,,,,6,6,,5,,6,,4,5,4,,4,,6,,,,5,5,6,
   4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,3,,6,,6,,3,,,,
   4,4,4,4,5,4,4,4,,,,,,,,30,,28,13,13,30,,5,5,15,28,13,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,
   3,3,3,3,3,3,,3,,10,10,3,9,9,10,10,3,3,10,3,9,5,,5,,,
   ,,,4,4,4,4,5,3,4,3,,,5,5,,,,11,,13,9,13,,11,4,4,14,
   14,9,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,
   6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,4,6,5,6,5,
   5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,4,4,4,5,4,4,4,,,,,,,,30,,28,13,13,30,,5,5,15,28,13,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,11,14,4,11,,14,11,14,14,,
   4,11,,4,,5,,5,,,5,5,,5,,11,14,4,11,,14,11,14,14,,4,11,
   4,,,3,,,,,,,5,,15,15,5,,24,15,15,28,28,,5,15,,4,4,4,6,
   6,6,6,,,,10,10,10,10,10,10,10,10,10,10,10,10,,,,,,,,,,,
   15,15,15,,,15,15,,,,19,,,3,5,5,,,,5,,14,11,5,,13,11,14,
   14,14,13,5,,,,,,,,5,,15,15,5,,24,15,15,28,28,,5,15,5,5,,
   ,,5,,14,11,5,,13,11,14,14,14,13,5,,3,5,5,,,,17,23,9,
   21,29,32,11,,9,32,,13,5,5,,,,17,23,9,21,29,32,11,,9,32,
   ,13,3,,,,29,11,,32,11,13,32,,9,17,9,29,,,,29,11,,32,11,
   13,32,,9,17,9,29,,,,,,,,,,,,,,,,,,,14,14,,,19,13,15,,14,,,,,,
   ,,,,,,,,36,11,,,,11,14,,37,,25,,,,,11,14,,46,249,13,13,36,
   25,9,8,11,5,10,,,,37,28,,10,,11,,34,25,,10,,,14,11,,25,,
   14,11,235,36,11,5,25,8,28,46,7,29,14,,13,6,6,9,,6,9,,
   12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,
   ,,3,3,,6,,6,,6,,,,,,,,,15,15,15,,15,,15,15,,15,15,5,5,,
   4,7,,7,,,5,5,5,5,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,
   5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,,,,,12,,13,11,6,13,9,
   11,11,14,6,5,,5,5,,8,,12,5,5,5,5,5,10,5,5,10,9,5,3,
   5,5,5,6,5,5,4,5,5,,7,,,,,,3,4,,5,,5,,7,,,,,,,8,11,6,
   11,13,,13,11,,13,14,11,6,,7,8,,7,,,10,10,10,10,10,10,
   10,10,10,16,7,4,7,5,5,4,,,5,6,6,,10,6,,,6,,4,5,,6,,6,
   ,10,,6,,,,,,,5,16,,16,5,,,,,,10,12,,,,,,,18,,,,,,,,,,6,,,,,,,,
   ,,,,7,,,,,6,,,,,,,,,7,,,,,,,,,,,,53,,,40,24,11,5,,7,,10,5,
   5,5,5,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,,,6,8,
   ,3,5,,5,,5,5,5,,,,6,,,,14,6,14,6,11,13,,11,9,11,,12,,
   7,,,10,10,10,10,10,10,10,10,10,16,5,4,5,7,7,4,8,8,7,
   10,10,,5,,,6,,,4,7,,10,,10,,5,,,,6,,,6,,10,,5,,,14,16,,,,
   5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,
   14,9,14,10,9,14,10,11,7,6,7,7,7,6,10,10,9,8,8,8,9,
   10,,10,,,6,9,,8,,8,8,9,,10,,10,,,11,,14,,8,,8,,,,,,14,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,,6,,,,
   ,,,,,,,,,,7,,,6,,,,,,,,,,,7,,,,,,,,42,11,25,22,,,,,5,5,4,5,
   5,4,6,7,7,5,3,5,5,5,4,,,5,6,6,,8,6,,,14,,3,5,,6,,6,
   ,8,,6,,,,,,17,7,24,6,12,8,14,13,14,14,14,7,5,5,5,5,
   4,5,5,5,5,3,5,5,5,4,,,5,6,6,6,8,9,,9,14,,3,5,,6,,
   6,6,8,,9,,9,,,8,24,8,17,7,14,7,17,14,11,13,24,9,5,5,
   5,6,8,7,8,5,4,5,5,5,6,,,5,10,10,8,7,9,,,12,,4,5,,10,
   ,10,8,7,,9,,,,,,,11,,11,21,9,32,25,55,25,49,11,5,5,5,
   5,5,5,5,3,5,5,5,4,6,6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,
   ,6,,,,14,7,14,9,17,6,11,11,17,14,17,7,5,5,5,5,4,5,
   4,5,5,5,6,11,11,5,10,10,11,7,,,9,9,,4,5,,10,,10,11,7,
   ,,,9,,,,49,11,32,9,35,11,,49,,21,,11,7,7,6,7,6,4,6,6,
   6,4,8,8,6,12,12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,
   8,48,8,46,8,94,8,46,148,90,81,48,8,5,5,7,5,3,5,5,5,
   4,,,5,6,6,,8,9,,6,8,,3,5,,6,,6,,8,,9,,6,,,14,12,8,12,
   8,24,7,14,17,14,17,14,9,5,8,5,4,5,5,5,6,8,8,5,10,
   10,,7,,,,,,4,5,,10,,10,,7,,,,,,,9,25,9,21,7,,11,49,,32,
   32,35,9,7,6,4,6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,
   6,,12,,12,8,6,,7,,7,,,10,43,8,94,8,42,8,59,59,46,101,
   42,8,9,4,9,9,9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,
   ,,,29,18,38,8,38,18,,29,,30,,18,3,3,4,4,4,,,3,5,5,5,
   5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,14,14,11,4,,11,11,
   11,14,14,3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,
   3,3,,3,,3,,,3,10,3,10,3,10,3,9,9,9,10,10,3,4,4,4,,,
   3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,14,14,11,4,
   ,11,11,11,14,14,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,
   ,,4,,,5,14,14,,4,11,13,13,11,9,11,,4,4,,,5,5,5,5,3,,,
   4,,,3,5,,5,,5,5,3,,,,4,,,5,14,14,,4,11,13,13,11,9,11,,
   4,6,6,4,4,4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,10,10,
   10,10,10,10,10,10,10,10,10,10,3,5,5,5,5,5,,,,,,3,5,,5,
   ,5,5,5,,,,,,,,32,,32,,11,9,29,21,13,21,23,9,5,5,5,5,5,
   ,,,,,3,5,,5,,5,5,5,,,,,,,,32,,32,,11,9,29,21,13,21,23,
   9,5,5,,4,,,4,,,3,3,,5,,5,,4,,,,4,,,5,11,13,11,4,,13,9,
   13,13,,11,4,4,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,
   ,6,,5,,,,,,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,
   6,,5,,,,,,6,,,,,,,3,,,5,,5,3,,,,,,,,,17,9,13,,32,,13,32,
   29,29,11,9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,13,5,11,14,14,
   5,13,,,14,11,14,,4,,,3,,,6,,6,,4,,3,,4,,,5,15,28,30,5,,
   28,13,13,13,30,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,
   ,,4,,3,,,,,5,15,28,15,5,24,,15,15,15,28,,3,,,6,,6,,5,,,
   ,5,,,,15,,,19,,,14,14,14,,,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,
   ,4,3,3,,3,,3,,,3,10,3,10,3,10,3,9,9,9,10,10,3,,5,,5,
   ,4,,,,4,,,5,11,13,11,4,,13,9,13,13,,11,4,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,
   5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,17,9,13,,32,,13,32,
   29,29,11,9,,4,,,,,,13,5,11,14,14,5,13,,,14,11,14,,,,,,,,,,
   ,,,,,,,,,,4,,,5,15,28,30,5,,28,13,13,13,30,,5,,,,,,,,,,,,,,,
   ,,,,,,5,15,28,15,5,24,,15,15,15,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,19,15,,15,15,,,,15,15,,14,,25,235,11,,,,,,46,25,8,36,5,
   10,10,13,37,46,7,14,,36,11,,,,,11,14,9,34,37,28,11,11,
   5,25,,,11,,,11,13,13,10,36,25,8,,,,,25,,11,,28,,249,29,,
   14,14,8,8,,6,7,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,
   6,6,,,5,6,6,9,6,10,,,,,5,4,10,6,,6,,6,9,,,,,,,14,,,,13,
   16,14,16,,14,18,18,8,,8,8,,10,,,8,8,7,8,7,10,8,7,10,
   20,5,5,4,10,7,10,,,5,7,4,,7,,,,,,5,4,,10,,7,,10,,,,,,,,
   14,16,,,14,,14,,16,14,16,16,11,7,4,11,7,6,6,8,8,6,8,
   6,9,8,6,9,8,5,5,4,6,4,6,,5,8,6,6,,6,8,,,12,8,8,4,
   8,6,12,4,,6,,,5,,12,8,8,6,8,6,6,8,8,6,8,8,8,6,6,,
   6,6,,,,,,11,,10,,,9,,16,,,5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,
   ,6,,,,,19,,,,,,19,,,,,,8,,7,,,8,8,7,8,7,10,8,7,10,20,5,
   5,4,6,6,6,,9,5,6,6,,6,,10,10,,,5,4,,6,,6,,6,,,9,,,,,
   14,18,16,16,14,,13,,18,14,,,6,7,11,11,8,8,6,8,6,9,8,
   6,9,8,8,8,4,6,6,6,,,5,4,6,5,4,,8,8,8,12,5,4,,6,8,
   6,,6,5,,,,8,12,12,8,6,8,8,6,6,8,6,6,6,8,8,,,,,34,9,,
   13,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,,,,,,49,,,,,,
   49,,,,,,,,12,12,10,12,10,8,12,10,8,10,6,6,4,4,6,4,,7,
   6,6,4,7,6,10,10,10,,8,6,4,10,4,,6,,4,7,,7,,8,,,11,,,,
   6,,6,,,11,,,6,,,9,,10,,,11,,16,,,5,,8,,,,,5,8,6,5,,,,,,,5,
   ,,,8,,,6,,,,,,,,,,,19,,,,,19,,,,,9,34,13,,,9,,16,,,5,,8,,,,,
   9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,49,,,,,49,,,5,5,8,7,7,8,
   4,9,9,5,5,4,10,7,10,,,5,7,4,12,7,8,,,,,5,4,8,10,,7,,
   10,12,,,,,,,8,14,30,30,15,15,8,15,14,16,14,14,5,5,5,8,
   8,7,7,7,5,5,4,10,7,10,,,5,7,4,12,7,9,,,,,5,4,9,10,,
   7,,10,12,,,,,,,8,30,30,30,8,14,11,14,30,16,30,30,7,4,
   7,4,5,7,5,5,5,3,5,6,5,,,5,6,6,9,6,6,,,11,10,5,3,6,
   5,11,6,,5,9,,,,10,11,11,7,8,8,8,7,9,7,9,8,7,8,8,5,
   7,5,5,8,7,5,5,4,10,7,10,,12,5,7,4,,7,,9,9,,,5,4,,10,
   ,7,,10,,,12,,,,,16,30,14,14,11,30,8,30,30,8,30,30,7,7,
   4,7,6,5,5,3,5,6,5,,6,5,6,6,6,6,,,,10,8,5,3,,5,10,6,
   ,5,6,,6,,8,10,10,7,8,8,8,7,8,7,8,8,7,8,8,9,7,10,
   9,8,8,6,8,9,8,,10,8,9,6,10,9,11,10,10,,,8,6,11,8,,9,
   ,8,10,,10,,,,,11,,,,11,26,12,26,,10,,,5,7,9,5,5,4,10,
   7,10,,12,5,7,4,,7,,8,8,,,5,4,,10,,7,,10,,,12,,,,,16,14,
   15,15,8,30,15,30,14,8,14,14,7,5,5,5,3,5,6,5,,9,5,6,
   6,,6,,6,6,11,10,5,3,,5,11,6,,5,,,9,,10,11,11,7,8,9,
   9,7,8,7,8,8,7,8,8,9,8,8,6,8,9,8,,10,8,9,6,10,9,
   10,11,11,,,8,6,10,8,,9,,8,10,,10,,,,,10,,26,26,12,,11,,,
   11,,,10,10,4,9,6,9,,,10,6,4,,6,9,9,9,17,12,10,4,9,9,
   17,6,,9,,,,,12,17,17,8,10,12,12,8,12,8,12,10,8,10,10,
   3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,
   ,,5,14,14,4,5,,5,5,4,14,14,3,5,5,5,,,3,4,4,4,4,5,,,
   7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,14,14,4,5,,5,5,4,14,
   14,4,3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,3,4,6,3,,4,3,
   ,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,,6,5,5,4,
   6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,
   5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,5,4,,,,6,9,9,5,
   5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,6,5,5,5,5,,6,5,4,
   5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,4,4,4,4,,,,9,,4,3,,6,9,,,6,4,,3,,6,,,31,6,
   ,,4,6,31,6,6,5,9,9,5,4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,
   ,7,7,4,14,5,5,,14,4,14,14,,5,5,4,,3,5,,,9,6,5,3,5,
   5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,4,4,
   6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,,6,6,10,4,4,4,10,4,
   10,4,4,10,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,9,9,5,9,6,6,
   31,,4,,9,31,6,6,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,
   5,7,5,5,5,7,5,7,7,5,5,5,5,5,20,8,,3,3,5,20,,,5,,,,,
   ,9,9,6,11,7,7,,11,6,11,11,,7,7,3,9,,5,3,5,5,9,5,,5,
   ,,,,8,20,20,,7,11,11,6,7,,7,7,6,11,11,9,,5,3,5,5,9,
   5,,5,,,,,8,20,20,,7,11,11,6,7,,7,7,6,11,11,8,,6,20,,
   6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,,,
   14,6,,6,6,16,,,3,,5,,4,,5,,,4,,,7,7,4,14,5,5,,14,4,
   14,14,,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,
   4,3,4,4,5,20,,,5,,,,,,9,9,6,11,7,7,,11,6,11,11,,7,7,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,
   5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,
   ,6,,6,,6,,,5,,,,5,,5,,,5,,,,4,,,9,9,5,9,6,6,31,,4,,9,
   31,6,6,,,,,,,,,,,,,,,,,,,6,,,31,6,,,4,6,31,6,6,5,9,9,,,,,,,
   ,,,,,,,,,8,8,16,,6,6,,,14,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,
   7,,,5,20,20,7,5,6,5,5,7,14,14,,,20,8,5,8,4,14,,,4,5,
   ,20,,,5,8,8,5,,20,,,5,8,8,20,8,20,20,6,5,5,5,4,8,20,
   ,,5,5,7,20,20,8,20,,,14,,,5,5,4,3,,4,4,5,4,,,4,4,6,
   4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,
   ,6,,7,,7,,,,,,13,13,,,,13,13,13,13,4,4,4,,4,4,5,4,,,4,
   4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,
   7,6,,6,,7,,7,,,,,,13,13,,,,13,13,13,13,4,4,4,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,
   4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,
   4,4,4,,,4,4,,,,10,10,10,10,10,10,10,10,10,10,10,10,,3,
   5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,
   ,,,4,6,,4,,9,,6,8,,,7,,,,,,13,13,13,4,4,4,,13,13,13,,,,
   ,8,,8,,,,11,,11,5,,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,
   6,8,,13,14,7,,,,17,17,14,14,14,9,9,11,35,,,,5,,6,6,7,
   6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,
   ,9,,6,8,,,7,,,,,,13,13,13,4,4,4,,13,13,13,,8,,,8,11,14,
   ,8,7,11,5,,,5,5,,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,
   ,,,,14,14,17,17,35,,,,14,11,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,
   4,5,5,9,7,8,7,,15,,4,5,,5,,7,,7,11,11,8,,,13,,16,11,
   14,16,12,7,7,9,14,7,9,6,4,4,4,4,4,5,5,7,4,4,5,4,
   5,5,,,4,5,5,7,7,8,,,,,4,5,11,5,,7,8,7,,,,,,,,14,16,16,
   23,14,7,6,7,11,9,6,9,5,4,5,4,8,6,8,4,5,6,4,6,6,,,
   5,6,12,11,7,13,,,,,4,6,,6,,7,,12,,14,,,,,,,29,,29,34,10,
   7,7,17,7,7,9,4,5,4,4,4,7,4,4,5,4,5,5,,,4,5,5,,7,,,,
   ,,4,5,,5,,7,8,7,11,,7,7,,,,12,14,23,14,16,6,6,7,16,
   6,9,7,5,5,4,5,8,4,5,6,4,6,6,,,5,6,12,,7,,,,,,4,6,
   14,6,,7,13,12,20,18,14,14,,,,31,,29,17,,7,9,10,31,7,9,
   7,7,6,8,7,4,10,8,4,8,8,,,10,8,7,18,7,,,,,,4,8,19,8,,
   7,12,7,13,,12,11,,14,,32,,,28,30,8,9,7,28,8,8,8,4,5,
   7,4,4,5,4,5,5,,,4,5,5,,7,7,7,,13,,4,5,,5,,7,,7,,11,,
   9,,15,,14,12,14,12,23,6,9,6,14,6,7,7,5,8,4,5,6,4,6,
   6,,,5,6,12,,7,14,14,,,,4,6,18,6,,7,,12,,,14,16,,,,19,
   31,17,19,29,9,7,4,,9,7,10,7,4,10,8,4,8,8,,,10,8,7,,
   7,12,11,,14,,4,8,,8,,7,,7,18,,16,12,,,,24,32,28,26,,9,
   8,8,,8,8,8,6,9,11,6,11,8,,,9,11,10,,10,,,,16,,6,11,,8,
   ,10,,10,,,,21,,16,,,,,,,10,9,7,,9,9,10,4,4,2,4,4,,,3,
   3,4,4,4,4,4,,5,,2,3,5,3,,4,4,4,5,5,4,4,,5,,10,9,9,
   10,9,4,9,4,9,4,4,9,4,4,4,4,,,4,5,5,5,5,6,,,8,,3,4,
   6,5,,5,5,5,6,6,,,,,,,12,,13,10,6,13,5,10,5,13,6,4,4,
   4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,5,6,6,,,,,,13,12,,,
   10,11,13,5,10,3,4,4,4,4,,,4,4,4,4,4,4,4,,,,2,4,5,4,
   ,4,4,4,5,,4,4,,,,9,10,10,9,9,9,4,4,9,4,9,4,4,,,5,
   4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,,,13,13,10,
   4,4,3,10,5,11,13,,,5,4,5,6,5,,5,,,,3,5,6,4,,5,6,5,
   6,8,6,8,,8,,13,,13,,10,13,6,5,10,5,6,13,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,5,,,,,
   ,4,4,6,4,,5,6,5,,,5,5,,8,,10,,13,10,,13,5,6,12,13,6,
   5,5,,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,10,13,,10,,13,5,
   11,12,4,4,3,,4,7,7,,6,,4,5,,5,,4,,4,8,7,8,7,,6,,,12,
   12,,,4,11,6,,11,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,,,6,,24,
   23,21,,,,7,9,25,8,5,6,7,7,,8,,4,5,,5,,4,,4,8,7,7,8,,
   6,,,12,12,,,5,7,7,,5,4,5,4,,45,,4,8,8,6,,7,9,7,,6,9,
   8,,12,,29,,25,27,,10,6,7,,9,9,,,24,,4,6,8,8,,7,8,7,,5,
   ,,,,,29,25,,27,,9,,7,,6,9,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,
   7,8,,6,10,6,,,10,10,,,,17,,,,,,7,7,17,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,4,,4,,4,4,4,,5,4,4,,5,,9,9,9,9,10,4,4,9,10,9,
   4,4,8,4,,5,,5,8,,6,6,,,,10,,13,10,12,4,3,4,,11,13,5,
   8,,,6,,,11,,9,,11,,,17,17,29,33,5,7,15,113,,7,,,5,,5,,,
   6,6,,,,10,13,,10,12,6,5,13,,6,13,5,,,,,,,,,,,,,,,,,,,,,,,,
   4,7,7,,7,,8,,,12,12,,,4,5,5,,7,5,7,,8,,9,,,,,24,23,21,
   ,25,6,7,10,,9,,10,7,7,7,,,6,,,12,12,,,4,6,11,,6,4,11,
   ,8,8,,,,17,23,,17,,11,8,,26,15,7,5,8,8,,,,21,113,33,21,
   ,15,5,7,,11,,7,4,,,,,,,25,13,7,10,6,14,10,9,9,,,,25,,,,
   13,7,9,,14,5,6,9,,,,,,,,,,,,,,,,,,,17,17,,,,,7,,7,,,,,,,,,,,,,
   ,,10,,10,13,10,,37,37,32,10,,,13,10,10,,37,34,21,,,34,
   21,37,,10,13,10,,37,32,37,,10,10,13,21,24,34,10,13,10,
   10,4,4,10,8,10,8,5,10,7,8,10,13,10,8,7,34,21,24,4,
   5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,
   4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,13,13,,,,13,13,13,
   13,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,
   6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,13,13,13,,,,4,13,13,
   13,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,
   6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,13,13,13,,,,4,13,13,
   13,,,,,8,11,8,,,,,,11,8,,5,6,9,,8,6,5,5,8,,6,,,7,,,,,9,
   6,,8,,8,,,,,,,,11,7,14,14,14,32,35,17,9,,,,,,4,4,6,4,6,
   4,4,6,4,6,4,4,4,4,4,4,6,6,4,4,6,,4,,,6,,,4,4,6,4,,
   4,,6,6,6,,,,,,10,10,10,10,10,10,10,10,10,10,10,10,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,8,,,,11,,11,,
   5,,6,5,6,,,,9,8,,8,,,9,,,8,5,7,,,6,,8,6,8,,,,,,,,32,17,
   35,14,14,14,,15,7,9,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,
   ,4,5,5,,7,,,,,,4,5,7,5,15,7,,10,,9,,,,,,6,6,23,16,14,
   12,14,14,9,9,7,7,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,8,
   4,5,5,,7,,,7,,,4,5,9,5,,7,,10,8,7,,,15,,13,7,6,16,14,
   23,14,16,12,6,7,7,9,5,4,5,4,8,6,8,5,4,6,5,6,12,,,
   4,6,6,,7,,,,,,5,6,16,12,16,7,,7,,11,,,16,,,7,9,29,,17,
   31,,19,7,7,10,7,4,5,4,4,4,7,4,4,5,4,5,5,7,8,4,5,5,
   ,7,,,9,,15,4,5,7,5,13,7,,10,8,,,,,,,7,7,14,12,16,16,
   11,14,6,7,6,6,5,5,4,5,8,5,4,6,5,6,12,,13,4,6,6,,7,,
   ,11,,,5,6,11,12,14,7,,7,13,,,,,,14,10,7,,34,29,,29,34,
   9,10,7,9,7,6,8,7,10,4,8,10,8,7,,,4,8,8,,7,,,18,,,10,
   8,11,7,,7,,8,12,18,,,,,16,8,9,,30,28,32,,24,8,7,8,9,
   4,5,7,4,4,5,4,5,5,9,,4,5,5,,7,,,7,,,4,5,,5,,7,,10,,,,
   ,,,15,9,7,12,14,14,23,14,16,7,6,6,9,5,8,5,4,6,5,6,
   12,11,,4,6,6,,7,,,16,,16,5,6,,12,,7,,7,,,,,,,16,7,10,
   31,19,,29,17,,7,7,9,7,7,10,4,8,10,8,7,18,12,4,8,8,,
   7,,,11,,,10,8,18,7,16,7,,8,,,,,,,,7,8,32,24,,,28,30,9,
   8,9,8,9,6,11,9,11,10,,,6,11,8,,10,,,26,,15,9,11,26,
   10,16,10,,10,,,,,15,,16,7,10,,,,,,,9,7,10,9,4,4,4,5,5,,
   ,3,4,5,,5,,,,,,4,4,,6,8,7,,7,5,5,,,7,,,13,5,13,,10,10,
   ,13,6,5,6,13,4,4,4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,5,
   4,,4,4,4,,,5,,5,9,4,10,9,9,9,10,9,4,4,9,4,5,4,5,,,
   3,5,4,,5,,,,,,4,4,6,7,,6,,7,6,6,,,4,,,13,5,,,10,10,13,
   13,11,3,4,4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,
   6,,,,8,,7,6,13,,10,13,,12,10,5,6,13,5,5,6,,4,4,4,,5,,
   ,6,,,4,5,6,5,4,5,,4,5,,,,,,7,4,4,13,10,13,,,10,3,11,
   13,5,7,7,4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,4,11,
   12,,,,12,,6,6,4,11,4,4,,5,,7,,,,,24,5,6,,,10,,,8,9,,,,6,
   ,,9,,,,27,29,25,19,7,5,9,6,4,5,,,7,,,,,45,5,6,,,10,,,
   8,8,9,,,,,,10,6,25,,27,29,,19,7,10,7,10,4,4,,4,,,4,,5,
   4,4,4,4,5,4,,4,4,4,,,,,5,4,9,9,9,10,10,9,9,4,9,4,
   4,4,,5,,,6,,,5,4,6,5,7,5,,4,,6,,,,,4,11,13,,10,,13,12,
   10,5,4,4,3,,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,7,13,6,13,
   10,,13,,10,5,13,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,
   6,7,6,14,6,,7,,,,,9,,9,5,7,12,,,,12,,7,5,4,5,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,22,7,,7,
   ,,,,,,,,7,21,,,24,23,20,10,6,5,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   7,4,,8,9,9,,8,,6,,,,,,,7,,,,17,,17,7,,,,4,,5,,5,,7,,,,,,,
   8,5,6,10,13,,13,10,,13,13,5,6,,5,,5,,7,,,,,,,,3,4,10,
   13,13,,10,,4,13,5,11,,,,,7,,,,,,,22,6,5,24,20,23,21,,,9,
   ,7,10,,4,,7,7,7,,,6,,8,6,4,,,12,12,,,11,4,11,6,9,,,,,,,
   ,,,7,7,,,,17,17,,,,,,,7,7,7,,,8,,14,5,4,,,12,12,,,5,5,
   7,7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,11,,11,11,11,,,6,6,,
   4,,,45,,10,10,7,29,19,,25,27,,10,10,6,7,,,20,,10,5,9,
   29,19,25,,27,,6,9,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,17,17,
   ,,,,,,7,7,,,,,,,,,,,,,,,,17,,17,,,,,7,7,,4,34,21,37,10,13,
   10,5,7,8,8,21,24,32,13,10,10,4,8,8,6,,,,10,,24,10,13,
   10,,,,,25,10,10,13,10,,,21,13,10,10,,,10,34,21,24,,10,
   37,32,21,13,21,24,53,8,6,9,4,5,4,5,6,6,5,,,,,10,,10,
   13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,9,6,,,,8,10,,,10,9,,,
   ,,17,17,,,,17,17,17,17,5,5,5,4,,3,,,6,6,7,6,7,6,6,7,
   6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,
   ,,,,13,13,4,4,4,13,13,13,13,,,,6,4,6,6,4,4,4,4,4,8,
   4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,,6,6,4,4,,4,6,6,
   ,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,,,,9,,10,,,
   9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,,,8,,,,10,,,,,,17,17,
   5,5,5,17,17,17,17,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,
   4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,13,13,4,
   4,4,13,13,13,13,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,
   ,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,,,6,9,
   9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,
   30,30,30,,,,,30,30,30,5,5,4,7,7,4,6,7,7,5,5,6,5,4,8,
   ,,5,6,8,,9,10,,,20,,5,4,11,8,20,6,11,10,,10,,,,,,7,9,
   9,10,16,9,7,16,16,10,10,12,5,5,5,4,4,7,7,6,5,5,6,
   5,4,8,,,5,6,8,,9,,,,,,5,4,10,8,,6,10,10,,13,,,,,,10,10,
   10,9,9,10,10,9,9,10,12,10,7,6,7,6,4,5,4,7,7,6,7,4,
   7,,,7,6,7,,12,8,,,10,10,7,4,6,7,10,4,6,6,16,9,,,8,9,
   9,6,7,7,7,7,7,6,7,7,6,7,7,5,7,5,5,4,6,5,5,6,5,4,
   8,,10,5,6,8,,9,,,,,20,5,4,13,8,20,6,,10,12,,13,,,,,9,
   7,9,16,10,7,9,10,10,12,10,12,7,7,6,7,8,7,7,6,7,4,7,
   ,8,7,6,7,,12,,,,10,10,7,4,9,7,9,4,8,6,14,7,7,,6,8,
   9,7,6,7,7,7,6,7,7,7,7,7,7,7,5,4,7,7,7,6,7,7,8,,
   10,7,6,8,,9,10,,,,,7,7,10,8,,6,11,8,,,,,,15,15,15,15,,
   17,17,15,15,10,10,9,12,11,5,7,7,5,5,6,5,4,8,,11,5,
   6,8,,9,13,,,20,,5,4,,8,,6,,10,,7,11,,,,,16,9,16,16,9,
   9,16,7,7,10,12,10,7,4,7,7,6,7,4,7,,6,7,6,7,,12,7,,,
   9,10,7,4,7,7,9,4,,6,,,9,,8,6,8,7,7,7,6,7,7,7,6,6,
   7,7,7,7,7,7,6,7,7,8,,11,7,6,8,,9,,,,,,7,7,,8,,6,10,
   8,,13,13,,,,,10,22,17,10,,22,10,15,15,12,11,15,8,8,8,
   8,4,7,,8,8,8,7,,18,8,,,10,9,8,4,8,7,10,4,8,7,,,,,9,
   12,11,7,7,8,11,8,7,7,7,7,11,8,8,5,5,4,4,4,,,4,6,8,
   ,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,,4,12,13,6,4,,
   4,4,12,6,13,5,4,4,4,,,4,5,5,,8,5,,,5,,4,3,5,4,5,4,
   4,4,6,4,,,,,,,4,13,12,6,4,,4,4,12,13,6,5,4,5,,5,6,6,
   6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,5,5,6,6,5,5,
   6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,,,,,5,4,4,4,4,5,3,
   5,4,6,,4,,8,,8,4,,13,6,12,,4,4,4,6,13,12,4,,,4,4,4,,
   6,,,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,6,4,4,4,4,4,
   4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,4,5,3,5,4,6,
   ,4,,,8,,4,,6,13,12,,4,4,4,6,12,13,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,5,6,,,8,,,,7,,4,3,5,4,5,4,4,4,6,5,5,,,,,31,
   5,,,8,5,31,4,4,7,7,8,5,4,,8,,,,,5,4,4,4,4,5,3,5,4,
   7,7,4,,,8,,4,,12,6,13,,4,4,4,13,6,12,5,,6,5,,,8,8,5,
   4,5,5,8,4,6,6,,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,5,5,
   6,,8,5,,,5,,4,3,5,4,5,4,4,4,7,4,7,,,,8,,4,6,12,13,4,
   ,4,4,13,12,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,8,6,
   8,8,12,6,8,8,,8,8,,8,8,8,9,9,8,8,8,9,9,9,9,8,8,8,,
   ,,7,4,4,4,4,5,3,5,4,7,6,5,,,12,12,5,31,,8,,31,5,4,
   4,8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   6,5,6,5,5,6,4,7,5,9,,5,,,,,5,,,,,,5,5,5,,,,5,4,7,5,
   6,6,5,5,9,5,,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,8,
   4,4,6,12,13,4,4,,,13,12,6,4,4,6,3,,4,6,,3,,6,6,6,3,
   4,4,4,4,4,3,4,4,4,4,4,,,,6,,,5,,,,,,5,4,8,8,8,4,5,
   31,31,,,8,,4,,5,,5,5,,,,,4,4,13,12,6,4,4,,,12,13,6,6,,,
   ,7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,
   3,4,4,4,6,6,6,,,,5,,,,,4,5,8,,,5,4,31,31,8,8,8,,5,5,
   ,8,,,4,4,12,13,6,4,4,,,12,6,13,7,7,,65,25,26,7,7,15,
   21,29,7,7,,,31,11,16,4,,,,12,4,31,8,8,7,31,4,5,5,,,,,
   12,,,31,4,,,,4,31,5,5,7,8,8,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,
   6,5,,,,,6,,,,,,,6,,,,,6,,,,,,6,,4,21,19,13,4,3,4,4,13,
   13,21,21,13,19,3,4,4,4,13,21,19,5,5,21,21,13,13,4,4,
   4,8,13,19,13,13,4,4,4,19,13,21,21,4,4,4,4,4,4,13,
   21,19,4,4,13,13,21,3,19,21,13,19,21,13,5,8,5,,,5,,,,
   8,8,,11,7,8,,14,11,,8,5,5,9,6,8,6,,5,8,,6,9,9,,,,5,,,
   ,,8,,6,,,,8,,,,11,9,,,,17,35,32,9,14,14,14,3,,,,,9,6,,9,
   ,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,
   30,,,,30,30,30,30,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,
   6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,,,,9,
   11,,,8,10,,8,10,,6,5,6,,5,8,,,5,8,,6,,8,,,,8,9,,,,8,
   10,8,10,11,11,10,,,,17,32,,,,7,9,11,35,14,14,14,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,9,9,,,10,,10,7,13,,8,,,13,,,8,,,81,81,9,
   12,11,,,,,,26,15,,,,,,,55,,,,,55,18,26,12,8,11,,6,,7,7,9,
   7,,,8,14,8,15,,,,8,,,9,9,,,135,,14,8,,,,10,,,,21,,,,,,20,
   17,,,,39,21,25,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,,7,,14,8,,8,,,9,,8,15,,9,,,,,135,15,8,17,,,10,13,
   ,26,16,18,23,,,,39,21,,,,20,17,24,19,,8,,10,8,,10,,10,
   12,10,,15,,,,12,15,,,,,,,,11,10,17,,135,12,18,12,19,16,
   14,19,,,,13,30,,,,13,30,,18,8,12,10,,,10,,13,,13,10,21,
   20,10,,22,15,,15,10,,,55,,,,,,,,,,,,,,,,,,119,,,,,,41,46,23,
   10,12,9,7,,12,7,12,7,,14,10,,7,,,11,9,,,,,,7,13,,,8,,,,,
   ,24,,,,20,17,,,,13,17,20,15,,11,11,,,15,16,17,,15,,11,,
   18,11,,,11,19,,,,17,18,,,143,16,,21,26,27,,,,,,29,111,,,,,
   55,,247,18,26,11,,,10,,11,16,,9,,10,,,10,8,,,,,,11,,,,10,
   13,,,,,,,,,24,69,,,,25,25,25,31,10,10,10,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,5,5,6,5,5,,6,6,,6,5,,,24,,6,5,4,,
   24,,,,8,7,,,,,,20,9,,,,13,34,24,23,5,14,7,6,5,6,,4,,6,
   6,,6,5,,,14,,6,5,,,,4,4,,8,7,5,,,,,15,9,,,,8,15,15,15,
   4,5,5,5,6,,5,,,6,,6,5,5,,,24,,,6,,40,6,7,6,,,7,8,,,,
   13,34,,,,20,9,42,31,7,14,5,,7,,,5,,,6,,7,,,,5,5,6,,12,
   5,6,5,8,8,8,8,,,,29,29,,,,29,29,7,8,,5,,8,5,,6,,,,,8,,
   ,41,6,5,7,,14,6,7,5,10,9,7,9,,,,42,36,,,,34,33,13,9,
   7,5,14,5,,,8,,8,7,,,,31,,,6,,,,,,,,,,,,,13,,,,,23,28,,,7,
   11,7,,5,,,5,,7,,16,44,5,4,6,,12,4,4,4,8,7,6,6,,,,31,
   10,,,,8,37,7,8,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,4,
   ,,,14,,6,7,,,6,7,6,,,7,8,,,,8,15,,,,15,9,39,39,5,5,4,,
   ,5,8,,41,,6,5,7,,20,6,7,6,9,7,9,10,,,,34,33,,,,42,36,
   8,9,14,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,,,6,5,7,,16,
   6,7,6,10,7,7,10,,,,21,21,,,,21,21,9,10,5,4,5,5,,44,
   16,4,5,5,,11,5,6,5,6,7,7,8,,,,8,37,,,,31,10,7,7,6,6,,
   ,31,,,6,,,,,,,,,,,,,,23,28,,,,13,,,,7,11,7,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,24,,33,,,14,20,12,,,15,19,,,,44,,,,,,41,24,20,,,,
   20,12,,,,,,40,23,21,,,,,,,41,,,,44,,44,40,,,,,,,,6,,6,,5,7,
   8,,,,13,22,,,,42,8,20,27,14,7,5,5,,,5,,5,,,6,7,,,,7,29,,
   ,,29,8,29,29,,,5,,,,,,,,,,,,,21,11,,,,17,35,,,,16,7,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,24,40,,,,44,44,,,,,,4,,8,7,,,,,,16,9,,,
   ,8,16,16,16,6,10,10,,,,5,,,,,16,12,,,,10,16,,,,10,10,8,
   7,,,,,,24,13,,,,8,23,20,34,5,7,14,,9,10,,,,15,,,,,,13,,
   35,20,9,6,8,9,,,,14,,,,,,9,23,31,,,7,,,,,,10,,,,9,,19,19,
   7,,,,,,,15,,,,12,,,44,6,9,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,29,,,,19,17,19,16,18,18,31,,,,17,17,19,29,23,11,13,,,,,
   ,,,,,,,,,,,,,,,,,,,,29,29,17,31,11,11,16,11,10,15,19,17,
   13,31,18,14,19,15,5,5,5,,4,,5,4,4,6,4,6,9,4,6,9,12,
   4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,
   4,13,13,13,,,,4,13,13,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,
   8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,13,13,4,4,4,
   13,13,13,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,8,11,8,,,,,,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,
   ,6,7,8,,,8,6,,,,,,9,11,9,14,14,14,,32,17,35,4,4,4,5,
   5,4,4,7,7,4,4,5,4,5,5,11,,4,5,5,,7,7,7,,15,,4,5,,5,
   ,7,9,7,,,,,,13,,6,7,6,9,9,14,23,12,7,14,12,14,4,4,4,
   4,4,5,5,7,4,4,5,4,5,5,,11,4,5,5,7,7,,,,,,4,5,,5,,7,
   7,7,,,,8,,,,6,9,6,7,6,23,16,14,7,12,14,16,5,4,5,4,8,
   6,8,4,5,6,4,6,6,,,5,6,12,14,7,14,14,18,,,4,6,,6,,7,
   16,12,,,,,,,,9,7,9,7,7,17,29,19,10,19,31,,4,5,4,4,4,
   7,4,4,5,4,5,5,,,4,5,5,,7,,8,11,,,4,5,,5,,7,,7,,,7,8,,
   ,,9,6,7,7,6,16,14,23,9,14,16,11,5,5,4,5,8,4,5,6,4,
   6,6,18,20,5,6,12,14,7,,,14,,,4,6,,6,,7,14,12,,,,13,,,,
   7,9,7,10,9,29,,17,7,31,,31,7,6,8,7,4,10,8,4,8,8,,
   18,10,8,7,16,7,11,12,,,,4,8,,8,,7,12,7,,,,,,14,,8,8,9,
   8,8,28,,26,8,24,32,,4,5,7,4,4,5,4,5,5,11,11,4,5,5,
   8,7,7,8,,13,,4,5,,5,,7,,7,,,9,,,15,,7,9,7,9,7,14,12,
   16,6,16,11,14,5,8,4,5,6,4,6,6,14,,5,6,12,,7,,13,,,,
   4,6,,6,,7,,12,,,11,,,,,7,7,10,7,7,,34,29,9,,29,17,7,4,
   10,8,4,8,8,,13,10,8,7,12,7,,,19,14,,4,8,,8,,7,11,7,,,
   18,12,,,,8,8,8,7,9,,30,28,8,32,,28,6,9,11,6,11,8,,,9,
   11,10,,10,,,,16,,6,11,,8,,10,21,10,,,,,,16,,9,9,10,7,9,,,
   ,10,,,,4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,
   4,,,4,4,,5,,9,4,4,9,4,9,10,9,4,9,9,10,4,4,4,4,,,4,
   5,5,5,5,,,6,8,,3,4,,5,,5,5,5,,,,6,,,,13,6,13,6,5,13,,
   10,5,10,,12,4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,,5,,5,6,
   5,,,6,,,,,13,13,4,4,3,13,12,10,5,10,,,4,4,,5,4,4,4,4,
   4,4,4,5,,,2,4,,4,,4,4,4,,,4,4,,,,4,9,9,4,4,10,9,9,
   4,9,10,9,4,8,,5,4,5,6,5,,,6,,,3,5,,4,,5,6,5,,,,5,,,,
   4,4,13,13,5,,,10,3,10,13,12,,,5,4,5,6,5,8,6,8,,,3,5,
   ,4,,5,6,5,,,5,,,8,,6,13,6,13,5,,12,10,5,10,13,,,6,8,
   7,8,7,5,6,11,,,5,6,,8,,7,8,7,,,9,,,,,11,,15,7,5,33,,
   21,7,21,113,,6,6,8,8,7,,,,,,5,6,,6,,8,8,7,,,9,8,,,,15,
   7,11,,8,,,21,5,21,23,26,4,5,,5,,6,6,,,4,4,,4,,5,,5,,,
   5,5,,8,,5,13,6,5,13,,10,13,6,,12,10,5,8,5,6,,6,,,4,4,
   ,4,,5,6,5,,,6,6,,,,5,11,4,3,4,12,10,13,13,,,10,8,4,
   7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,11,4,4,6,11,12,,,6,,12,,,
   ,9,,,,4,,,6,,7,4,7,,,8,9,,10,,10,9,7,6,10,,13,25,9,,,
   14,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,5,4,5,5,12,,,7,,12,
   ,4,8,,,4,,,5,,7,,7,,,,8,,24,,6,9,9,7,,,,27,5,29,25,,8,
   12,,4,5,,,,7,8,7,,,,9,,45,,9,9,10,7,6,25,,27,,29,,,11,,
   5,6,,6,,,9,,,,5,6,,7,,,7,5,15,7,17,33,29,,,17,113,,5,,,
   8,,6,,6,,,6,,,,,7,,,,,,17,17,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   ,4,,4,4,4,,,4,4,,5,,4,4,4,4,9,9,9,10,9,10,9,9,,4,,
   5,,5,,,6,6,,,,3,4,11,5,13,,10,,4,13,12,10,,,,,,,,,,,,,,,,,,
   ,,,,,,,,5,8,5,,,6,6,,,,5,6,13,5,6,12,10,,13,13,,10,,,,,,,
   ,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,12,,,5,,12,,,,,,,,10,
   ,5,6,7,,9,,13,,9,25,,14,,,,,,6,,6,4,4,11,6,12,,,11,,12,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,8,5,,9,7,21,,,6,24,
   23,25,,10,,9,,6,10,7,21,25,,10,24,23,,,,,,,,,,,,,,,,,,,,7,
   7,,,,,17,,17,,,,,,,,,,,,,4,8,10,7,10,13,10,5,37,37,34,10,
   8,8,13,10,10,4,37,34,21,4,4,34,21,37,8,10,13,10,5,
   37,34,37,7,10,10,13,21,24,34,10,13,10,10,,,10,,10,,,10,,
   ,10,13,10,,,34,21,24,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,
   ,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,5,
   ,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,
   ,4,6,,4,,9,,6,8,,,7,,,,,,13,13,13,4,4,4,,13,13,13,6,
   17,,9,,10,,,10,13,8,9,,6,,8,,10,,,6,,9,8,,5,,,,,8,,,,12,,
   ,5,,,10,,,,5,5,17,17,17,,,,5,17,17,17,,,9,,10,,,9,,16,,,
   6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,17,17,41,5,
   5,5,,41,17,17,5,5,4,7,7,4,6,7,7,5,5,4,5,6,8,7,,5,
   4,8,11,6,,13,,,,5,6,,8,,9,,10,11,,,,,20,,10,12,9,10,16,
   16,9,16,10,16,9,10,5,5,5,4,4,7,7,6,5,5,4,5,6,8,,
   12,5,4,8,13,6,,,13,,,5,6,,8,,9,,10,10,,,,20,,20,12,10,
   7,10,9,9,10,16,12,9,7,10,7,6,7,6,4,5,4,7,7,4,7,6,
   7,,,7,4,7,9,4,,7,7,6,8,7,6,,7,8,12,,6,6,,,,10,9,9,
   7,7,7,6,7,7,7,6,7,7,7,6,5,7,5,5,4,6,5,5,4,5,6,8,
   13,,5,4,8,,6,,,10,,,5,6,,8,,9,,10,,,,10,,,,10,12,10,9,
   7,10,9,9,10,7,10,9,7,7,6,7,8,7,7,4,7,6,7,7,14,7,
   4,7,7,4,,,9,8,6,7,6,,7,9,12,,6,8,,,8,10,10,9,7,7,6,
   7,7,7,7,7,7,7,6,7,7,5,4,7,7,7,7,7,6,8,13,,7,7,8,
   13,6,,,,,,7,6,,8,,9,,8,11,,,10,,,,12,11,22,15,10,17,,10,
   15,10,22,15,5,7,7,5,5,4,5,6,8,10,,5,4,8,,6,,10,11,,,
   5,6,,8,,9,,10,,,,11,,20,20,10,10,9,16,7,9,16,10,12,7,
   9,16,7,4,7,7,4,7,6,7,9,16,7,4,7,,4,,8,6,9,8,7,6,,
   7,9,12,,6,,,,6,10,10,10,6,7,7,7,6,7,7,7,7,6,7,7,7,
   7,7,7,7,6,8,,,7,7,8,,6,,10,10,15,,7,6,,8,15,9,,8,10,,
   ,11,,,,9,12,15,10,15,,17,17,11,15,15,10,8,8,4,8,8,7,,
   ,8,4,7,,4,,8,8,12,9,8,8,,7,11,18,,7,8,,,8,9,10,10,
   11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,5,5,5,,4,3,4,5,4,
   ,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,13,12,4,,4,6,13,12,6,
   4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,,4,6,,8,,8,,4,5,,,
   5,5,,5,13,6,,4,4,12,13,6,12,4,,4,4,4,4,,6,3,3,3,3,
   3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,6,6,4,4,4,4,3,4,4,
   4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,,8,4,5,,5,8,8,,4,5,,
   ,5,5,,5,6,13,,4,4,13,12,6,12,4,,4,5,5,,5,4,5,5,4,,
   5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,5,5,6,6,6,5,5,
   6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,5,,4,,8,,5,4,,,,5,5,,
   12,13,4,,4,13,6,12,6,4,4,,7,4,4,4,4,3,,6,5,,,4,5,,,
   12,8,,5,5,,,,5,,7,,,31,5,4,8,7,8,,4,31,5,6,5,7,7,6,,
   7,,25,35,6,,,6,26,,,,6,,,,9,9,,31,11,7,,7,15,29,21,16,
   7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,4,,,,4,,5,5,12,13,4,4,,
   13,6,12,6,,4,4,4,4,3,,,3,6,6,4,4,,4,6,6,,3,,,,3,6,
   6,4,4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,6,,4,8,8,
   ,4,,,,4,,5,5,13,12,4,4,,6,13,12,6,,4,4,,,5,,,12,,5,,4,
   ,8,,5,5,,,5,,5,7,7,8,4,5,31,,,,8,31,4,5,,3,,6,6,4,4,
   ,3,6,6,,4,4,,,4,6,4,6,6,6,3,4,4,6,6,6,6,4,3,4,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,6,,,12,8,,4,,,,5,7,,5,8,
   8,31,4,5,,,8,8,5,31,4,,,5,6,,4,,8,,,5,,,6,7,5,,,,4,
   31,5,8,8,8,8,5,4,31,5,,5,,8,5,8,,,,,,,,,,,,,,,,6,,6,,,,
   8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,,,,4,,5,5,
   12,6,4,4,,12,6,13,13,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,
   5,6,6,6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,
   5,5,,5,6,12,,4,4,6,12,13,13,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,
   ,,8,8,,,8,12,12,12,8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,
   ,,,,,,,,,4,,,,5,5,,12,6,4,,4,12,6,13,13,4,4,,,,4,,7,5,
   7,7,5,4,31,,8,,8,31,5,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,
   ,8,8,5,31,4,8,,,8,4,5,31,6,6,,,5,5,,,,,,,5,5,6,,,,5,
   5,,,,,5,,5,,,5,,5,,,,,5,5,,5,13,19,13,4,4,4,8,13,13,
   19,21,21,13,4,4,4,5,13,21,21,4,4,21,19,13,21,4,3,4,
   4,13,21,13,13,4,4,3,21,13,21,21,3,4,4,5,5,4,21,21,
   13,8,4,13,19,21,4,21,13,13,21,21,13,4,4,4,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,
   ,,10,13,,22,,,,,,10,22,16,19,15,16,,,,,,10,10,12,,22,12,
   18,,31,,,,,,,41,23,10,13,49,20,,22,,,,,6,,,8,,8,12,,7,,7,,
   ,,10,7,17,18,11,13,,26,209,,,7,10,,,8,11,,,15,,,,,,15,20,
   ,11,,20,20,20,56,,,,9,,,,,10,13,,,10,10,,19,12,,22,12,,,,
   ,20,,,,,10,16,55,22,,,,,30,,,,,,49,13,12,17,41,22,,20,,,,,
   ,6,,6,,,7,13,10,,,17,13,7,,,8,,,,129,,,10,8,,109,7,17,
   14,,12,,19,,,,16,14,9,,9,14,14,16,14,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,8,12,,7,10,7,,18,11,,7,,,11,13,,17,,,,7,9,17,,8,,,,,
   ,24,,,,20,56,,,,20,56,13,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,10,,12,,6,,,,,12,,,8,11,,,52,,,6,7,,70,12,,16,,,
   ,24,,,,19,16,10,8,10,16,22,19,22,,,,,,,,,,,6,6,6,8,6,4,,
   ,24,,,5,5,6,20,6,7,6,,,9,9,,,,20,42,7,14,5,22,27,13,
   8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,6,6,6,8,6,,,
   ,,,,5,5,6,14,6,7,6,,4,7,,,,,39,15,5,5,4,15,39,8,9,,,,,
   ,,5,6,6,6,8,6,,,,,40,,5,5,5,24,6,7,6,,,6,,,,,42,20,
   14,7,5,34,31,13,9,,,,,,,5,5,5,7,5,,,,,,,5,4,5,12,5,6,
   5,,8,8,6,,,,29,29,,,5,29,29,7,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,8,10,10,10,8,,,,,169,,7,8,9,27,10,9,8,,,11,,,
   ,,,,20,9,6,44,159,15,12,,,,7,7,9,9,7,,,,,,,6,7,6,25,8,
   8,7,,,,,,,,,23,,,7,39,125,14,10,,,,6,5,,,,,,,14,,,4,6,41,
   6,5,,,,7,,,,,13,34,5,7,14,36,9,42,33,,,,,10,6,7,,8,14,,
   ,5,5,,,4,7,6,,7,,8,,,,15,8,5,4,5,9,15,15,15,,,,9,6,7,
   ,8,12,,,5,5,,40,,6,6,,7,,8,,,,20,8,7,5,14,13,34,24,23,
   ,,,,,,,,23,,,6,10,,10,,,,,12,,,,,15,44,6,9,20,,12,,159,,,,
   7,,,,16,,6,4,6,,6,,,,7,7,,,,,9,21,4,5,5,21,10,21,21,,,,,
   ,,,,5,5,7,27,7,,7,,,10,10,,,,21,,7,19,,,28,17,10,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,,,,,,,7,11,7,,15,
   28,17,,,,,,,11,24,,14,,41,,,25,,,,,24,,,,,,20,44,41,,,,,12,
   16,24,,,15,20,,,,36,,,,,44,,,,40,,24,44,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,5,5,,5,,,,,6,,,,,7,29,5,,,29,8,29,29,,,,,44,,7,5,,6,
   ,7,,,,8,7,,6,6,7,10,31,18,,,,,,9,6,,7,5,8,,,,24,13,14,
   5,7,9,23,20,34,,,,,,,,20,,,,,,44,44,,,,41,40,,,,,,8,6,,7,,
   8,,,,16,8,10,6,10,9,16,16,16,,,,,,,11,,,,,14,39,7,,,40,
   10,,125,,,,,7,7,,,,,8,42,5,14,7,33,9,34,36,,,,,,,,,,,,,,,,,,
   ,,,,8,,,,,40,,10,10,,,40,10,12,,,,9,,,,,14,,8,,10,,25,43,,,
   ,,,,23,,7,11,7,,13,,23,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   29,31,11,18,19,17,19,16,,,,11,31,11,17,17,19,29,,,,5,5,
   11,19,18,15,,,,5,23,14,18,10,,,,13,15,31,19,,,,29,29,17,,
   ,,16,11,,,,17,,,,,,,,,,,10,,,9,,8,,11,8,10,8,,9,6,5,,11,
   10,6,,8,11,8,8,,,,,,5,,5,,6,10,8,,8,,10,,,,14,14,7,11,
   9,,,,14,17,32,35,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,8,8,5,6,6,5,6,5,5,6,7,8,6,8,4,16,,7,8,8,15,7,,
   13,,,,6,8,15,4,,7,15,10,,20,,,,,,,31,8,6,7,10,7,7,23,
   23,27,27,8,8,8,6,5,6,6,7,6,7,8,6,8,4,,17,7,8,8,13,
   7,,,,,13,6,8,20,4,,7,,10,16,,,,,,18,27,,6,7,8,7,9,10,
   31,27,27,,6,4,6,6,7,4,7,8,7,6,8,6,6,,,7,6,8,13,7,
   14,,15,,,8,6,19,6,,7,17,6,17,,,,,,,32,17,7,10,10,11,10,
   14,20,38,,32,8,6,8,8,6,7,6,7,8,6,8,4,,16,7,8,8,,7,,
   ,20,,,6,8,,4,18,7,,10,17,,13,,13,,,27,27,7,10,6,6,8,7,
   ,27,,31,6,6,4,6,5,8,7,6,8,6,6,15,,7,6,8,,7,,,,,,8,6,
   ,6,,7,14,6,,15,,14,,,,,32,10,11,7,10,7,11,17,,32,17,5,
   4,4,5,7,8,7,7,7,4,8,10,8,7,8,9,7,10,9,10,,,7,7,11,
   4,,7,9,6,9,10,9,10,,,15,17,28,10,7,10,7,7,6,20,14,
   17,28,8,6,5,6,7,8,6,8,4,20,,7,8,8,,7,13,,15,,,6,8,,
   4,,7,,10,,16,15,15,,,,51,27,10,7,7,8,7,6,27,,31,23,6,
   7,8,7,6,8,6,6,,17,7,6,8,,7,,14,19,,,8,6,15,6,,7,,6,,
   ,13,17,,,,38,,11,14,10,7,10,10,32,32,17,20,5,7,8,7,7,
   7,4,10,9,8,7,8,9,7,9,10,11,,,7,7,10,4,15,7,10,6,10,
   8,9,9,,,,14,17,7,6,10,10,10,7,28,17,28,20,6,8,8,6,8,
   4,,,8,8,7,,8,18,18,20,,12,6,8,20,4,15,8,20,7,,,,20,12,
   ,15,,46,7,7,8,7,8,7,45,,46,45,5,5,4,4,4,6,,6,4,7,,
   7,,6,,,,4,4,6,3,7,5,6,5,6,6,8,8,8,,,,13,5,13,6,6,
   13,5,10,13,10,,5,5,5,4,8,8,6,7,7,7,6,7,,7,,,6,5,,4,
   8,4,7,5,,7,,7,8,,6,,12,11,4,6,4,11,6,,,,12,4,4,4,,6,
   5,5,4,6,5,6,8,8,,7,4,4,6,4,,5,8,4,6,,6,,4,,,10,13,
   4,4,3,13,5,11,13,10,,,5,4,,6,5,5,4,6,5,8,8,6,,7,4,
   4,6,4,8,5,,4,6,,6,,7,,8,10,,13,6,5,13,5,6,13,10,,12,
   4,6,,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,8,6,,,,,,
   5,13,11,4,4,3,10,13,10,13,5,5,4,3,4,5,4,6,5,6,,5,
   3,4,5,2,5,4,5,4,5,6,5,6,5,,,9,10,4,9,4,9,4,4,9,9,
   9,10,8,7,8,5,8,7,10,10,9,,10,6,,8,6,,7,6,8,10,,9,,7,
   ,14,11,,13,8,5,,6,11,27,21,,,,6,6,6,,,9,,,,6,6,9,5,7,
   8,8,6,6,10,7,9,,,,,,6,,21,7,11,5,21,27,21,26,5,7,,4,,
   7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,,4,6,11,11,6,4,
   12,,12,,7,8,5,6,,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,13,10,
   4,3,4,5,11,13,13,,,10,6,7,10,10,10,,,7,4,10,4,8,7,5,
   4,6,5,6,5,,,8,,11,6,6,,6,,6,11,,11,11,,,10,,,,8,6,10,
   5,10,7,8,6,7,9,6,10,,,,21,33,5,7,11,,11,6,21,,21,,,7,,
   ,14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,,4,5,5,7,7,5,12,
   ,12,,8,6,,,6,8,8,5,7,7,10,6,9,10,10,8,,,,,,6,21,,11,
   7,5,21,26,21,27,8,,,,6,6,6,,,8,6,,10,,10,,,7,26,21,11,
   5,7,6,,21,27,,,21,,,6,6,8,5,10,7,9,8,9,8,10,10,14,,
   78,,27,5,13,8,11,,7,21,26,21,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   4,14,5,9,9,7,7,,7,,10,,,,,17,,,,7,,7,17,,,,5,,4,,7,8,5,
   ,6,,6,,,7,13,10,6,5,13,5,6,13,,,13,10,8,4,,5,,4,6,,
   6,8,7,,,10,,13,11,5,4,3,4,,10,13,12,6,78,,10,8,,9,,9,,
   ,10,26,21,11,7,,5,8,13,,,27,21,,4,6,4,5,5,5,5,5,,5,
   9,9,9,4,4,4,4,9,10,9,10,9,9,,,,14,,,,,,17,17,,,,7,7,,,,
   ,,8,5,,7,,7,14,,8,,12,7,5,7,4,5,5,,,,12,,9,,10,,10,,,
   11,,21,,6,7,5,11,,21,27,,6,8,6,,7,,,10,13,6,13,5,6,5,
   13,,10,13,,8,6,8,,,7,27,17,7,5,9,6,21,,26,,,17,8,6,10,
   ,,21,,,11,6,13,5,8,,11,,27,8,,,10,,17,,6,11,5,11,7,,
   21,33,17,7,,,21,27,7,9,5,21,6,,,11,,,,9,,,7,7,,,,,,,17,
   17,,,,,,,,,,,,,,,,7,,7,,,,,17,17,,,24,21,25,10,13,10,,,,,21,
   34,24,13,10,10,,,,10,4,4,8,6,8,34,10,13,10,5,8,8,7,
   37,10,10,13,6,9,8,21,13,10,10,4,4,10,24,21,32,5,10,
   53,24,21,13,21,34,37,,10,,,,,,,6,9,9,,,6,,9,,,6,6,6,,,,,
   6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,,
   ,,,,,7,10,10,,,,13,22,,,,13,10,15,,,,10,,,,,,,21,,15,,,10,
   20,,,,94,,23,10,,41,,,,,12,,119,46,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,9,6,9,,7,8,7,,,7,12,7,,,,12,7,,,8,,
   9,13,,,,7,,,,11,24,,10,14,,,,,,,11,15,20,17,,,,11,20,17,
   15,,9,,,,,9,,12,10,,,15,26,10,7,13,,,,8,11,,,,,,13,,,,,8,,,
   ,81,81,,12,8,,18,55,,,,11,,55,26,,,6,,7,15,,8,,8,,16,
   26,14,8,15,18,10,,,17,,,,8,,,,9,23,,9,,,13,135,,,,8,20,
   24,17,,,,,39,21,19,,9,,,17,,18,17,18,,27,26,15,,11,,16,
   19,11,,,,,16,,15,,,,21,11,,,,,,143,18,26,,,55,,,,11,29,111,
   247,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,14,,8,14,8,
   ,21,,,8,,,10,,9,,,,,8,,15,,9,,,,,,,,135,,,,39,25,21,,,,,20,
   17,56,10,11,,10,10,12,,16,19,10,,15,14,12,,,17,,,,12,,15,
   ,,19,12,,,,18,,,135,8,12,13,,30,,,,10,13,30,18,,,11,,10,,,
   ,,11,,,10,,8,,,,,10,,16,,10,,,9,,,13,,,,10,10,25,25,25,,,,
   10,24,69,31,,,,,,5,,6,5,6,7,6,,4,,,,,6,,6,,6,8,6,5,,,,
   24,24,,14,7,42,20,8,,,,5,13,22,27,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,6,,,,5,5,5,6,5,6,5,5,,,,5,,5,,5,7,5,4,,,
   ,12,,,,,29,29,8,,,,5,7,29,29,,,,,5,5,6,7,6,5,5,6,,,,6,
   ,6,,6,8,6,5,,,7,24,,40,7,14,20,42,9,,,,5,13,34,31,,,,
   6,5,6,7,6,,4,7,,,,6,,6,,6,8,6,5,,,7,14,,,5,5,39,39,9,
   ,,,4,8,15,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,7,8,7,
   ,7,,,,,7,,9,,7,9,7,7,,,,25,,,,,,23,9,,,,7,14,,31,8,8,9,
   9,8,,6,,,,,8,,10,,10,10,8,8,,,,27,,,20,9,,,13,,,,6,15,,
   35,5,6,,,,5,4,,,,,,6,,6,,,5,5,,,,24,24,5,14,13,24,34,,,,
   7,20,9,23,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,,,12,,5,29,7,
   29,,,,,29,29,8,9,6,8,5,7,,,,6,,,,,10,6,,8,,7,,41,20,14,
   5,42,8,36,,,,7,34,33,9,,,7,,,,,5,,7,,7,,,6,,,5,,15,,7,,
   9,19,,,,,,,10,19,,5,,,,,4,,6,,6,,,4,,,4,,14,,6,10,8,16,
   16,,,,10,16,9,16,5,,,,,,,8,,8,,,7,,,,,31,,7,11,13,,,,,,7,
   23,28,,5,,,,5,,,,5,8,5,,7,,6,16,44,11,6,6,31,7,10,,,,,
   8,37,7,,,,,,7,,7,,,6,6,,,,33,,,16,17,,35,,,,7,21,11,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,6,,6,,,4,,,4,,14,,4,5,8,15,15,,,,5,15,9,15,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,9,5,5,8,,7,41,,14,7,5,34,13,33,,,,14,42,
   36,9,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,7,,,16,5,4,21,9,21,,,,
   5,21,21,10,,6,,,,,21,,6,9,12,,,,,,20,,15,44,4,,,,40,12,,
   5,7,8,20,23,,,,14,24,13,34,5,,4,44,16,12,,6,8,7,37,,,,
   6,31,10,8,,,31,,,7,11,23,,28,,,,7,13,,,,,,,,,,,,,,,,,,,,20,,
   ,10,10,,16,,,,10,16,12,,,,,,44,44,,,,,,,41,40,,,,,24,41,,,,
   ,44,,20,,,44,,44,,,,,24,40,,5,31,11,10,,,,5,18,23,14,11,
   31,15,,,,5,18,11,19,29,29,,,,11,19,17,17,16,,,,18,19,19,
   17,,,,19,17,17,11,,,,,,,,,,,,,,,,31,13,15,29,16,29,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,,,,10,22,
   16,,,,10,12,30,22,,,10,,,13,,20,,,,,,12,19,,,,,55,,,41,,22,
   13,17,12,,,49,20,,6,,,8,,8,,,7,10,7,17,,,,7,,,8,,13,9,,,
   12,7,17,,,11,24,,11,18,,,,,,,,20,15,56,,,,,20,56,20,9,,,,,
   10,,10,10,,22,12,31,,,,16,,22,,16,10,,,13,22,,,,15,,18,,,
   19,12,,,,,,49,,20,23,13,10,,,41,22,,,6,,6,,13,10,13,7,,
   12,,,10,,,7,,,8,,,,7,,,,8,19,14,17,,,17,,129,206,,,14,16,
   14,9,9,,,16,14,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,10,7,,7,,15,,,
   7,17,,8,,13,10,,,12,7,26,,,11,,,,,18,11,,209,,,,20,20,20,,
   ,11,,15,20,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,
   12,,,,,6,,,12,,11,7,,,10,12,,,,8,24,16,,,,,,52,70,,,16,19,
   22,10,10,8,,19,16,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,6,6,6,,,,5,5,7,6,,,4,,,6,6,,,,,,,7,8,,5,14,,41,,,36,
   42,9,5,14,7,,15,34,33,5,5,5,,,,5,5,6,5,,5,5,,,5,5,6,,
   ,6,,,6,7,,,12,,,,,29,29,8,5,,,,8,29,29,6,5,,,,,6,6,6,,,
   5,,,,,,,,6,,6,5,,8,7,40,,24,,,34,13,31,14,5,7,,42,20,9,
   ,7,,,5,,,4,,7,5,,,6,6,8,,,6,8,6,7,10,10,7,,14,,,,9,
   39,39,5,5,4,,15,8,15,7,,,5,,5,,,7,,,,6,6,8,,,6,8,6,6,
   9,10,9,24,24,,,,9,20,23,14,7,5,,24,13,34,,,8,7,8,7,,,
   6,,,,4,,,,7,,7,,,,,,,20,,,,10,40,10,,10,,40,,12,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,
   4,,,,6,,,,5,6,5,,,7,6,,,12,,,29,7,29,,5,,,29,29,8,,,,7,
   5,,,6,6,8,,,6,8,6,9,10,9,6,,14,40,,,13,24,34,7,14,5,,
   20,8,23,,,10,,,,9,7,11,,,7,9,7,,11,12,11,,25,,,,10,25,,,
   ,8,,,14,43,,7,,,,6,6,8,,,6,8,6,8,10,10,8,,14,,,,9,40,
   40,10,10,6,,16,8,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,,4,,,,,
   7,10,7,,,,,,,27,,,,17,28,7,,19,,37,,10,,,5,5,5,,,4,7,5,
   7,8,6,7,16,12,44,,,7,31,10,,6,6,,10,7,18,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,6,,,8,7,,41,20,,,
   22,13,27,7,5,14,,36,42,8,,,,6,,6,,,8,7,,,14,,,15,8,39,
   5,4,5,,39,15,9,,,,,5,,,,,,,,,,,28,15,7,7,11,,,,17,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,,,16,,,,,21,21,10,4,5,
   5,,10,21,21,,,,,,36,,,,,,,13,7,7,11,,23,,23,7,8,,,20,41,,,
   ,33,34,9,5,7,14,,8,42,36,,9,8,,,25,,,39,14,125,,7,,,,
   23,10,10,9,,,27,,,44,15,159,20,6,9,,,,12,,23,,,,,,,12,6,
   20,9,,17,44,159,15,,,,,40,,10,7,,,,16,39,125,,,,,40,24,,,,,
   ,,44,44,,,,,44,20,,,,,41,,41,,,41,,40,,,,,44,44,,,,,,,,,,,,,,,
   ,,,,,,,,29,29,11,13,23,,19,17,17,40,18,31,18,,19,19,17,
   19,15,14,,41,17,11,5,5,,31,11,15,5,,18,11,19,,13,31,10,
   ,,,29,16,29,3,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,
   9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,10,10,10,10,8,8,10,24,
   8,24,8,10,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,
   11,,,9,,4,4,,6,,9,,12,,8,,,,,,10,10,10,10,8,8,10,24,8,
   24,8,10,4,4,3,3,3,3,4,4,4,4,4,4,6,,4,4,4,,4,,6,,,,
   4,4,7,4,,4,8,6,8,,6,,,,,6,8,8,6,6,6,8,9,6,9,6,8,3,
   4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,
   10,9,10,10,8,,,9,,15,10,10,15,8,8,10,8,8,8,8,10,4,3,
   4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,
   10,10,8,,,9,,15,10,10,15,8,8,10,8,8,8,8,10,3,4,4,4,
   4,4,4,4,4,8,,4,4,4,8,4,7,7,,,,4,4,,4,,4,,6,,8,8,,,,,
   6,9,9,6,9,9,9,6,9,6,9,9,4,4,4,4,4,4,4,4,8,,4,4,4,
   ,4,7,5,,9,,4,4,7,4,9,4,,6,,,8,,,10,,4,5,5,4,8,8,5,
   8,8,8,8,5,3,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,
   5,9,6,8,9,8,,,,,,,10,9,9,11,21,21,9,9,21,9,9,9,6,6,
   7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,
   10,9,9,11,21,21,9,9,21,9,9,9,4,4,4,4,4,8,,3,4,5,6,
   5,6,7,,11,,4,4,6,4,8,7,6,7,6,6,,,,7,,17,5,7,17,7,8,
   23,7,8,8,7,14,4,4,4,4,,,4,4,4,6,4,6,,,8,,3,4,6,5,
   11,5,6,7,6,6,,,,,,17,7,23,6,8,7,14,8,7,7,13,6,4,4,4,
   ,,4,5,4,8,5,6,,,15,,4,4,6,8,15,6,7,8,8,7,,,,,,7,9,
   10,10,6,9,7,9,9,6,9,9,4,4,,,4,4,4,6,4,6,6,,,,4,4,
   5,4,7,4,6,6,6,,7,,,,,6,11,14,7,7,13,6,7,8,8,12,6,4,,
   ,4,4,4,7,4,,11,,,,4,5,6,4,6,5,8,7,6,9,9,,,,,10,10,
   7,7,9,9,9,6,6,9,15,7,9,,5,4,4,10,5,,6,,,,4,8,6,4,
   10,6,10,8,6,,4,,,7,,6,32,7,17,8,18,8,8,7,7,8,20,,7,
   9,4,9,6,8,9,,,,4,7,6,7,15,6,7,8,8,,,,,,,11,,,13,8,22,
   ,10,14,9,21,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,,5,,8,,
   ,,4,4,6,4,12,4,6,7,,,4,,,7,,5,14,6,5,13,12,6,7,7,
   12,7,5,4,9,5,11,,,,,4,4,6,4,13,4,6,7,,11,7,,,,,7,7,
   9,7,9,15,7,8,9,14,14,4,,5,10,,,10,,5,4,10,4,8,5,6,
   8,7,6,7,,,7,,17,7,8,7,18,12,20,7,8,13,7,7,,,11,,,,,11,
   ,6,15,8,,12,12,12,6,,,9,,11,18,10,18,,,8,12,14,29,16,
   13,6,6,,11,,7,6,9,6,,8,11,7,,8,6,,,6,,9,9,5,15,15,
   13,10,9,15,10,6,10,6,,,,6,7,7,6,15,8,12,9,,6,11,,,21,
   ,17,28,16,13,,,13,11,10,18,22,,,31,,6,6,7,7,16,7,6,9,
   ,6,,,,,,15,15,,13,15,11,,11,12,12,36,10,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,12,,15,8,,8,,11,15,,14,,,,,34,,,,,,8,11,36,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,6,5,,,7,,5,6,6,6,12,7,5,
   12,13,13,7,7,7,4,,5,,8,11,,5,,,10,,5,9,7,7,15,14,4,
   14,9,15,8,8,7,,,6,,,12,,,,11,,17,8,14,20,21,11,10,,25,,
   9,12,,5,7,8,11,11,,,,,,7,8,20,10,12,7,7,13,18,7,13,6,,
   ,,,,16,,,,,34,13,,85,,11,13,,,,,,,7,8,7,,,,,,15,5,10,14,
   13,7,10,10,15,9,8,10,,12,,,,,,,13,13,10,,12,14,9,,29,
   12,14,15,,10,10,,,9,,,8,8,,18,9,9,50,,12,10,66,,7,,,11,
   ,11,10,13,13,29,12,10,,25,,12,9,9,,,,,13,25,18,11,12,,
   10,12,15,12,,8,,,,,24,8,,11,14,8,,,,10,22,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,117,,14,14,165,,,,11,,8,,,,,,,,,,,,,10,13,,16,
   11,7,11,15,16,19,24,16,20,16,9,4,6,9,12,19,16,10,9,
   16,16,18,15,6,9,4,15,16,13,19,17,12,11,10,14,15,10,
   14,16,6,6,9,14,6,10,13,15,10,6,18,16,16,16,14,10,10,
   15,15,16,14,10,9,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,
   6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,10,10,10,10,8,8,
   10,24,8,24,8,10,3,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,
   ,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,10,10,8,10,
   10,10,8,10,8,10,10,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,
   ,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,10,10,8,10,
   10,10,8,10,8,10,10,3,3,3,3,4,4,4,4,4,6,,8,4,4,6,5,
   4,8,,5,,,4,4,6,6,,4,7,6,7,5,,8,,,,8,6,6,8,8,8,6,10,
   8,10,8,6,4,4,3,4,4,4,4,4,4,,8,4,4,4,6,4,6,,7,,,4,
   4,,4,,4,,6,,6,,8,,,,9,6,6,9,8,8,6,6,8,6,8,6,3,4,4,
   4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,
   9,8,15,15,8,10,10,15,8,10,8,10,15,4,4,4,6,4,6,7,,8,
   4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,15,15,8,
   10,10,15,8,10,8,10,15,4,4,5,4,5,4,,6,4,5,4,,4,8,,8,
   7,9,4,5,6,4,,4,5,6,5,,,6,9,,8,10,6,5,10,7,7,6,9,7,
   9,7,6,4,4,4,4,4,,,3,4,5,6,5,5,,,7,,4,4,6,4,,7,6,7,
   5,5,,,7,,,14,7,6,11,6,5,17,8,5,7,7,17,4,4,4,4,,,4,
   4,4,5,4,8,,7,12,,3,4,6,5,,5,5,7,6,7,,8,11,,7,23,6,
   17,7,5,7,17,7,6,8,23,9,4,4,4,,,4,5,4,8,5,4,,,13,,4,
   4,6,8,,6,6,8,6,10,,,6,,,7,7,10,10,4,7,10,9,10,6,10,
   10,4,4,,8,4,4,4,7,4,,,5,,12,4,4,6,4,,4,6,6,6,,,5,8,
   ,7,7,17,17,5,7,23,6,8,5,7,14,7,4,,,4,4,4,10,4,,,10,,
   ,4,5,8,4,,5,6,7,6,,,4,15,,10,10,10,7,9,9,10,10,6,4,
   9,7,10,,9,5,4,4,11,5,7,,7,,8,4,8,6,4,,6,10,8,6,7,,
   7,10,,,7,29,6,32,6,32,9,7,7,8,7,29,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,5,4,7,7,8,,,,17,134,4,5,8,4,,10,10,10,6,8,
   ,,15,,,,13,11,,12,12,16,9,7,10,11,19,4,4,,5,,,6,,7,4,
   4,6,4,,4,6,7,6,6,,4,,,7,5,17,6,6,11,14,7,7,7,13,6,
   7,4,,5,,,8,,13,4,4,7,4,,4,6,7,,11,,5,,,4,7,10,10,4,
   10,7,7,9,9,9,9,7,7,5,9,,11,8,,5,4,10,4,,5,6,8,,6,,
   4,,,8,32,9,6,6,32,7,29,8,6,18,8,8,,,,,,13,6,11,6,6,,
   8,6,,12,11,,8,,,18,12,14,13,16,,,21,11,15,36,10,35,8,,,,
   ,7,6,11,6,,8,9,7,10,8,,10,12,,12,9,9,6,7,7,9,9,15,
   10,19,5,19,,7,134,17,7,9,9,4,,6,11,8,8,9,,4,,,11,12,
   16,11,12,,,13,8,8,22,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,13,,8,
   6,,6,,,11,,,,,9,,,,,21,13,,16,12,14,,9,12,9,30,,8,,,10,,
   8,,13,31,,,,,,,9,,,252,,,36,12,13,,,,11,6,,8,,,11,,16,10,,,
   ,,,,36,,,252,9,,29,9,,,,4,,4,,5,6,7,,8,,7,,,7,6,8,5,6,
   14,6,6,13,11,12,6,8,9,4,,5,,8,11,,,7,,,10,4,10,7,10,
   7,9,7,9,10,15,7,9,,,,6,,,11,,,,,19,13,13,11,10,18,10,
   18,,25,,8,18,,5,,8,10,,,,10,,8,6,7,17,7,7,8,7,18,17,
   12,20,10,,,,,,,,,,,,,,,,,,,,,,,10,7,6,6,,10,11,,12,7,7,9,
   10,9,5,19,19,7,13,10,14,,12,,,,,,,8,17,13,,16,13,14,,
   28,22,,24,11,9,,,15,,,10,10,10,84,10,8,,,84,18,8,,6,,10,
   ,,8,14,20,17,8,28,16,13,,29,,13,20,,7,31,,11,9,30,15,
   12,15,,13,15,,11,,21,,,,,,,,,,,,,,,,,12,,,,12,13,,7,12,11,,
   18,8,12,16,,12,,85,34,13,,,,,103,,8,34,,,,,,,,,,,,,,,,14,,
   9,86,,,94,11,9,,10,13,16,10,4,10,6,7,18,10,24,,20,13,
   10,,12,10,24,24,,10,10,13,,16,20,11,7,,7,10,13,12,9,6,
   4,10,16,20,16,18,9,4,8,10,9,4,16,16,20,19,8,16,13,,
   9,14,15,17,19,16,50,9,19,10,4,3,4,4,3,4,4,4,6,4,6,
   7,,,4,6,7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,10,
   10,8,15,15,10,8,15,8,15,10,4,3,3,3,3,4,4,4,4,4,4,,,
   4,4,4,8,8,,,8,6,6,4,4,6,4,6,8,7,4,7,8,,,6,6,6,4,
   4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,6,4,6,7,,,4,6,
   7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,10,10,8,15,
   15,10,8,15,8,15,10,4,3,4,4,4,4,4,4,4,,,4,4,4,8,4,
   5,7,7,10,,4,4,,4,,4,,6,,8,,,,9,9,8,8,8,8,5,5,8,4,5,
   4,5,8,4,3,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,
   10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,
   4,4,4,5,,,4,4,5,6,6,5,6,6,9,,4,4,8,5,8,6,7,4,7,6,,
   ,,,7,6,8,8,6,6,6,8,6,6,6,6,8,6,6,5,6,5,6,,,6,5,6,
   ,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,
   7,7,7,7,7,7,7,4,4,4,5,5,,,4,4,7,6,7,8,,,7,,4,4,8,
   6,8,7,,7,6,4,,,,,,29,7,5,,8,5,,7,7,7,7,29,4,4,4,4,,,
   4,5,5,4,4,6,,,7,,4,4,8,7,8,7,6,6,8,7,,,8,,,,5,,5,5,
   7,29,7,8,7,32,7,5,3,5,,,4,6,5,9,6,5,,,7,8,4,3,5,5,
   8,4,6,5,9,5,,,6,8,8,6,6,4,4,5,6,6,6,6,5,5,5,4,5,,
   ,4,4,4,7,4,10,10,6,,6,4,5,6,5,,4,8,5,8,,,,8,,7,5,,
   29,7,7,32,7,7,5,7,17,5,5,,,5,3,5,5,4,,5,6,7,7,4,6,
   9,5,6,6,9,5,5,,,,8,7,7,4,4,6,6,6,5,5,5,5,6,6,6,,,
   7,5,6,10,7,8,7,8,,7,6,5,8,5,10,5,10,5,8,,,,10,7,,7,
   31,7,31,12,,5,13,8,13,6,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,7,,8,7,,,4,4,,4,6,
   4,8,6,7,7,,,,9,8,7,31,7,7,32,17,5,7,7,19,7,7,5,,6,
   5,,6,7,8,5,3,6,5,8,4,5,5,,6,,,6,6,6,6,6,5,4,5,6,
   6,6,6,5,5,4,,7,,10,,,,7,5,10,6,,7,8,8,,5,,,,9,,34,7,
   5,8,,6,17,13,12,37,8,7,,,9,,,,7,6,8,5,,4,7,8,9,,,,35,
   8,,8,24,7,12,19,,,8,12,15,7,9,6,12,,8,9,7,4,9,5,9,
   4,9,7,,4,,,10,6,10,7,7,4,7,7,7,7,7,7,7,5,7,10,8,
   32,10,8,6,6,7,12,12,,9,10,9,,,,,16,11,34,10,7,,11,11,
   17,13,28,14,10,,13,,7,6,8,8,19,7,6,7,,,,,21,,11,,11,
   17,7,13,9,,13,12,20,14,10,,,8,6,11,8,,9,11,11,6,6,,,
   17,11,,,9,7,17,13,11,,22,17,20,10,32,7,7,7,8,,7,4,13,
   8,,,,,,,,6,,96,55,,,,8,7,,75,57,8,6,,,6,6,15,,,8,,,,,,,7,
   143,,,,,,,,,,4,,5,,7,7,7,,8,,,,8,9,5,7,5,7,17,7,7,19,
   35,19,8,7,6,5,7,6,,5,6,,,,8,7,7,4,5,6,6,6,5,4,5,5,
   6,6,6,8,64,,,11,,11,,,,,17,10,9,9,9,18,12,15,21,20,,
   15,12,,7,,5,9,10,,,10,,9,8,5,17,7,6,8,7,37,,8,20,8,
   6,105,,,10,,,,,,9,6,,135,128,9,8,,,,,,,7,10,,,,9,11,11,7,
   4,7,7,7,5,7,7,7,7,7,7,,10,,,,12,18,,9,10,12,,11,10,
   16,21,25,11,9,19,10,7,,,9,9,,7,7,7,19,11,13,7,,36,12,
   8,19,7,,,64,14,18,9,9,10,9,25,11,12,,26,21,10,16,,,13,
   ,10,7,15,24,8,12,19,7,10,12,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,6,10,,135,9,6,,,70,,,,,7,8,,,,,9,,,,,,,7,,,,,,,,,,,7,,4,
   11,16,12,5,6,6,7,23,18,9,16,11,10,7,4,6,5,12,14,16,
   4,5,10,16,23,18,6,7,4,7,18,11,12,19,6,5,6,26,18,20,
   26,7,6,6,5,5,6,20,26,18,7,6,23,10,16,7,,17,13,30,20,
   12,5,7,5,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,
   9,4,4,8,6,,9,11,12,11,,,11,9,,,8,10,10,8,10,10,10,8,
   10,8,10,10,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,
   4,6,10,7,9,6,8,9,8,,,,,,,8,10,10,8,15,15,10,8,15,8,
   15,10,3,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,
   9,,12,,,8,,,9,,15,8,8,24,10,10,8,10,10,10,10,8,4,4,4,
   4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,
   15,8,8,24,10,10,8,10,10,10,10,8,3,4,4,4,4,4,6,5,7,
   4,4,6,,4,,8,6,,,4,4,5,6,,4,8,6,8,,5,7,,,,10,8,8,10,
   6,6,8,8,6,8,6,8,4,4,5,4,5,4,,5,4,5,4,,4,,8,6,,9,
   4,5,8,4,8,4,6,6,6,,,5,9,7,,9,7,7,9,5,5,7,10,6,10,
   6,7,4,4,4,4,4,8,,3,4,5,,5,,7,,,,4,4,8,4,7,7,7,7,4,
   ,6,6,11,8,,12,6,6,13,5,5,14,6,8,6,8,11,4,4,4,4,6,
   6,4,4,4,,4,,,6,,,3,4,6,5,7,5,4,7,5,,,6,7,,,13,6,14,
   7,7,6,11,6,7,5,17,7,4,4,4,,11,4,5,4,,5,,9,9,,,4,4,
   6,8,10,6,7,8,5,,11,,6,,,15,7,9,9,7,7,7,10,9,4,10,
   10,4,4,,6,4,4,4,,4,,,6,,8,4,4,5,4,7,4,5,6,8,,7,6,
   12,,,7,14,23,8,6,17,7,5,7,7,17,5,4,11,,4,4,4,,4,,,7,,
   ,4,5,8,4,4,5,5,7,4,,,6,13,,,9,9,7,9,7,10,10,4,7,7,
   10,9,,10,5,4,4,,5,,4,,,10,4,8,6,4,8,6,,8,4,,6,,8,10,
   ,12,20,8,18,7,17,7,7,10,6,7,17,6,7,,6,,6,,9,11,,31,
   5,10,,7,11,8,7,9,8,,11,,10,,,11,,,15,13,15,15,12,21,9,
   30,,6,6,,,6,,8,,,,5,6,,6,8,10,10,11,6,,12,12,16,31,,,
   13,16,,13,17,28,8,14,14,20,29,4,4,,5,,8,6,,11,4,4,7,
   4,7,4,8,7,,,5,5,,12,,8,23,7,7,17,17,5,7,6,23,6,6,4,
   ,5,,,8,,15,4,4,10,4,10,4,4,7,,,10,6,,,,9,7,10,6,10,
   7,9,7,7,10,10,4,,5,,9,10,,,5,4,11,4,8,5,4,8,7,,7,6,
   ,8,,18,8,7,8,17,6,32,6,7,32,9,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,6,,,11,7,6,,6,12,8,10,7,10,,8,10,,8,,13,10,5,
   15,15,9,9,10,14,7,7,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,5,
   4,7,7,11,8,4,8,,,,11,17,134,,22,,,8,13,11,,12,12,12,
   16,8,,,6,6,,6,19,11,,,8,,6,6,,,,,8,10,,18,11,18,10,18,
   13,13,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,6,,10,12,12,12,15,15,,,
   ,,,,,8,,,,34,,13,34,,85,103,4,,4,,5,,7,,,6,6,,7,,7,7,5,
   8,17,6,6,11,17,14,7,5,,4,,5,,8,,,8,6,,13,,6,10,7,9,
   7,10,4,10,10,7,7,10,7,,,9,,,,,11,,13,,12,9,12,,14,13,
   16,,30,,21,9,,5,7,8,9,,11,10,8,,,8,7,32,7,6,6,6,32,
   29,7,29,6,12,,,,,18,,,,,11,9,86,,,14,9,,,,,94,10,7,8,,,9,
   ,,,19,5,9,15,9,6,7,7,19,9,9,10,,,,8,,,,,8,12,12,,11,
   13,7,,16,,12,18,10,,,,,13,,18,8,8,,,10,10,84,,10,10,84,,
   7,10,134,17,,10,11,12,9,16,11,12,,19,,13,7,,,,,,,,,,,,,,,,,
   ,6,13,,,36,10,,11,21,13,,16,35,12,14,15,11,,,22,,13,,
   14,13,16,,24,8,17,28,,,,208,9,29,,,252,,,,36,9,,,,,12,36,,
   ,252,,9,,13,,,,,,,,,,,,,9,16,14,16,11,9,6,19,18,24,19,
   16,15,13,7,4,4,10,10,24,16,9,10,13,16,10,20,4,10,4,
   15,16,16,12,17,6,12,9,,20,13,,7,,8,10,10,,13,,20,7,8,
   10,13,18,10,16,20,9,24,,50,10,7,10,4,3,4,4,4,4,6,4,
   6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,
   15,10,10,15,8,8,10,8,8,8,8,10,4,3,4,4,4,6,4,6,7,
   10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,
   8,8,10,10,8,15,10,15,10,8,4,3,4,4,4,4,4,4,8,7,4,4,
   4,,8,,,6,6,6,4,4,8,4,6,8,,4,,,8,7,6,6,6,4,4,4,4,4,
   4,4,4,4,4,4,4,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,
   ,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,10,10,8,15,10,15,
   10,8,4,4,6,4,6,4,,7,4,6,4,,4,,,8,6,6,4,6,8,4,6,4,
   7,4,7,,,7,6,6,6,5,6,6,5,6,6,6,5,6,5,6,6,4,4,4,5,
   5,8,,4,4,7,7,7,,,,,,4,4,8,6,,7,8,7,6,6,10,10,7,8,,
   17,5,7,32,7,7,31,7,6,8,7,,4,4,4,4,10,10,4,5,5,6,4,,
   ,7,6,,4,4,6,7,7,7,6,6,8,,,6,7,,9,32,7,29,7,7,5,,8,
   7,5,,7,5,3,5,,5,4,6,5,6,6,,,,8,7,4,3,4,5,7,4,6,5,
   6,6,5,,4,6,6,6,6,5,5,4,6,6,6,6,5,4,4,4,5,,6,4,4,
   4,,4,,,4,,7,4,5,4,5,8,4,8,5,6,,,8,7,,8,7,29,,5,5,,
   5,5,7,7,29,7,5,5,,5,3,5,6,4,,,5,7,7,4,6,9,5,6,6,
   6,5,5,,,5,7,8,7,5,5,6,6,6,4,4,5,4,6,6,6,10,,7,5,6,
   ,7,,,,,,6,5,6,5,,5,11,5,,8,7,8,8,10,,6,17,5,,8,34,7,
   8,7,12,7,31,10,,,7,,12,,,9,,13,6,6,6,8,16,6,8,10,,,11,
   ,7,,18,9,,17,13,7,,11,11,9,10,26,11,8,5,8,8,6,,,,10,
   32,6,6,9,,13,10,10,,8,,6,10,11,,,11,11,10,,7,11,34,12,
   8,9,11,,4,5,,7,,,6,,7,4,4,7,4,9,4,6,6,10,10,6,6,,6,
   7,5,,5,8,,29,7,7,5,32,7,7,5,,6,,,9,8,7,5,3,5,5,7,
   4,5,5,,5,6,6,7,7,6,6,6,4,5,4,6,6,6,6,5,5,4,8,7,,,
   10,7,,7,5,10,6,9,7,,8,8,7,8,,,7,9,,5,7,12,31,7,31,
   12,8,,5,8,,,,,,,10,5,,7,,6,10,,6,11,8,,,11,16,11,,7,13,
   17,,9,9,11,14,10,9,,,,9,8,7,4,6,5,11,4,7,7,10,6,6,
   10,7,6,7,7,7,4,7,7,7,7,7,7,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,7,6,10,6,11,7,9,6,
   ,9,15,10,68,,,7,19,12,8,24,8,,9,7,15,7,8,6,10,10,6,
   6,12,,,,11,14,,,,,,143,,241,,7,9,8,,,185,7,4,15,8,7,7,
   10,8,11,7,,14,,,,,,,,55,6,,9,,74,86,160,4,,5,,7,10,7,,
   8,7,8,,,,8,5,7,7,31,7,7,32,,17,5,6,,5,6,6,,5,5,,6,
   6,7,8,7,5,4,6,6,6,5,4,5,4,6,6,6,,68,,9,7,,9,,11,,,
   10,9,7,8,8,24,7,12,19,15,,,,,7,8,5,,10,,11,,,,12,7,34,
   8,7,5,8,,31,6,17,7,7,62,,,18,16,,,,,9,9,112,,,8,7,,,,,,
   10,7,6,12,,7,8,9,11,7,4,7,7,7,4,7,7,7,7,7,7,,10,,,,
   14,14,,12,10,7,,10,11,8,14,34,14,10,18,,10,,,8,,,11,7,
   7,38,7,7,7,38,19,11,7,19,10,8,10,35,10,13,9,11,11,
   12,34,10,7,,,11,11,8,,8,13,,16,10,26,,11,11,17,7,13,
   11,9,,9,10,,,,14,10,,9,9,7,17,13,9,11,,11,10,12,62,14,
   10,11,14,8,7,10,,18,12,10,34,7,7,74,86,6,9,,96,55,,,,,
   ,6,,,,9,7,143,,,185,,,8,,,8,,7,112,,,,9,9,,5,10,26,18,
   5,7,4,7,14,18,14,16,18,11,6,4,5,4,18,9,16,5,4,11,
   16,12,11,5,6,4,7,12,10,16,19,4,5,7,16,11,10,18,7,4,
   4,4,5,4,10,16,11,7,4,18,11,18,7,26,18,19,14,16,17,5,
   7,4,4,4,3,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,
   ,6,,9,,,,8,,,9,9,9,21,9,9,9,21,11,9,10,9,21,3,4,4,
   4,4,4,4,5,6,7,4,4,5,,6,6,5,8,,,4,4,6,5,7,6,,4,,,6,
   7,,9,8,6,6,6,6,8,8,6,6,8,6,8,6,4,4,4,4,4,4,6,6,
   6,4,4,6,6,4,6,6,6,,,4,4,6,6,,4,6,4,6,6,6,6,,,,10,
   6,6,10,6,6,6,10,6,10,6,6,6,6,7,6,7,5,,8,6,7,5,,6,
   7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,9,21,9,9,9,21,11,9,
   10,9,21,5,5,4,7,7,6,,4,5,6,11,6,,6,,,,4,5,6,4,7,5,
   6,5,6,6,7,7,,7,,20,10,7,23,9,10,17,7,7,7,7,29,5,5,
   5,4,7,7,4,7,7,6,4,5,,6,,,4,5,8,6,11,6,6,5,11,6,,5,,
   ,7,23,7,29,7,10,7,29,7,9,7,23,7,7,6,7,,6,5,5,4,7,
   5,5,8,8,,,5,6,7,7,,5,11,7,7,,7,,,12,12,7,20,18,18,7,
   13,7,7,11,6,18,18,5,7,,5,5,5,4,6,4,7,7,6,,,4,7,6,
   7,9,4,11,6,6,,6,,,,8,7,29,29,10,7,23,7,7,10,6,25,10,
   7,7,,7,6,7,,6,,7,,,,5,5,7,4,8,5,7,6,7,8,8,5,,9,,18,
   18,7,13,13,18,18,6,7,10,7,20,9,10,6,4,4,10,6,9,5,9,,
   ,4,7,5,4,7,4,9,7,5,9,5,9,,7,,7,,6,27,6,27,6,7,8,
   5,7,,7,6,8,5,8,6,6,7,10,,,6,,6,6,35,6,6,,9,,9,,,,11,
   9,,26,16,8,,11,15,17,7,,,,5,9,9,,,6,,,,4,6,7,4,11,7,
   7,6,6,8,10,8,,13,,20,22,9,,14,,22,6,8,14,10,27,5,7,,
   6,,6,11,,,5,5,6,4,9,4,6,5,8,8,6,4,,9,8,10,17,7,9,
   23,20,10,7,7,18,7,8,7,8,5,6,,7,,,7,6,11,7,,6,7,6,,7,
   ,6,,,6,13,7,18,7,18,7,20,10,13,12,12,10,9,6,10,9,10,,
   ,6,4,10,4,12,6,5,4,6,5,6,4,,12,8,27,6,6,6,27,7,,5,
   6,20,6,6,,,10,,,,8,7,9,5,12,6,8,7,10,9,8,7,,11,,14,
   50,15,21,19,,22,9,9,20,10,60,,6,,,,5,5,6,4,11,4,6,5,
   7,6,6,7,,6,,15,11,7,16,16,15,11,7,7,10,6,10,7,9,,,5,
   7,7,4,11,5,6,5,9,7,9,4,,13,29,,22,9,14,,20,22,6,6,,
   8,12,8,,,,6,6,6,,11,6,7,,9,,9,,,7,,11,26,8,16,9,,11,
   14,12,35,11,,,6,6,8,5,11,6,10,8,10,8,9,7,,9,,,22,15,
   19,21,14,50,9,8,10,8,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,5,,7,,6,8,5,,6,,5,,9,7,9,7,10,7,20,7,8,
   18,23,15,9,7,7,7,,5,,7,7,,7,11,,,,7,18,20,11,7,12,10,
   12,18,6,11,13,6,,,7,8,,9,,8,,28,8,,11,17,8,26,8,38,,
   16,,12,11,,6,6,7,9,10,9,10,,,8,6,6,,8,7,6,6,20,27,5,
   26,8,,,,,18,,,,,,30,36,,,,12,45,,,112,,,7,5,,6,,5,,17,8,
   16,7,11,7,15,6,10,10,16,8,13,8,,9,,9,,,36,,8,46,17,,
   8,16,11,16,30,7,15,,7,,7,,,,,7,,,64,7,15,10,25,64,6,
   15,26,8,6,7,,,7,15,11,46,8,17,8,17,,29,16,16,11,8,9,,
   ,18,8,22,50,14,9,19,11,,24,9,,22,7,,,10,35,11,,9,17,
   8,26,,21,14,,11,,19,,8,12,22,20,8,14,7,,55,6,,22,,,,,,,,,
   ,,,,,,12,,,,11,27,,,,,13,,34,183,,14,,15,,,144,236,9,14,,
   18,36,23,9,12,15,6,16,13,22,27,,28,36,15,,8,18,25,27,,
   18,18,36,,19,28,8,22,,16,9,36,14,13,6,12,15,23,28,15,
   27,10,6,10,18,12,6,15,23,28,10,10,19,36,,10,10,28,11,
   20,21,17,12,10,18,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,
   ,4,4,,6,,9,,12,,,8,,,9,,15,8,8,24,10,10,8,10,10,10,
   10,8,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,
   6,,9,,8,10,10,,,,8,8,8,8,10,10,8,15,10,15,10,8,6,6,
   7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,
   9,9,21,9,9,9,21,11,9,10,9,21,4,4,4,4,4,6,,3,4,5,5,
   5,6,6,,7,,4,4,,4,,7,,7,,4,,,,12,,13,7,7,12,5,6,12,6,
   7,5,6,13,4,4,4,4,,,4,4,4,4,4,8,,6,7,,3,4,,5,,5,,7,,
   7,,6,,,12,12,7,12,7,6,6,13,5,5,5,14,7,4,4,4,,11,4,
   5,4,5,5,6,7,7,10,,4,4,,8,,6,,8,,7,11,,,,,15,8,14,14,
   4,7,15,7,8,5,9,9,4,4,,6,4,4,4,7,4,6,6,5,,,4,4,,4,,
   4,,6,,,6,6,,,7,7,12,13,7,6,14,7,5,6,6,11,8,4,11,,4,
   4,4,7,4,,11,6,,,4,5,,4,,5,,7,,9,9,6,,,13,14,14,15,8,
   7,9,9,7,4,7,9,9,11,11,5,4,4,,5,7,6,7,,,4,8,,4,,6,,
   8,,7,6,7,,8,,7,13,7,13,7,20,12,10,6,10,8,18,,6,9,6,
   9,7,6,6,12,,,6,7,,,,8,,10,,,12,,,,,12,,,12,10,18,12,11,
   8,13,25,15,6,6,7,7,8,,,,11,,6,8,,6,,,,,,8,12,12,,15,,,
   12,12,,10,13,29,13,9,11,10,25,4,4,,5,,6,6,,,4,4,,4,,4,
   ,7,,,6,6,,8,11,7,13,7,8,14,23,8,6,6,17,7,7,4,9,5,
   11,,6,,,4,4,,4,,4,,7,,,7,8,,,6,8,15,9,6,9,7,9,7,7,
   10,10,6,7,5,,10,10,7,,5,4,,4,,5,,8,,4,,6,,10,8,13,7,
   12,7,20,8,18,7,7,17,7,8,,,11,,,,,,,4,,6,,10,,,6,,,14,
   16,10,22,8,,,,14,11,,24,8,,7,8,,,,7,6,,6,,8,,7,,6,8,,,
   8,,8,8,7,10,10,10,13,14,10,15,5,15,6,7,,,7,,,6,,6,,9,
   ,9,11,6,,31,16,12,36,11,11,,,15,13,10,15,15,12,7,21,,
   6,6,,,,6,,9,,8,,12,,,15,18,22,,11,13,16,,13,,17,28,10,
   11,,6,6,,6,,9,,,,6,,6,,15,,,9,11,,10,14,21,20,12,17,8,
   25,,7,,,7,,6,,9,,,9,,,,,11,,165,,,,14,14,8,,117,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,4,,4,,5,,7,,8,6,6,,11,8,8,7,8,7,23,7,7,
   17,14,17,5,8,,4,,5,,8,,,8,7,,15,15,6,9,9,9,7,10,6,
   10,9,7,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,5,,8,,9,10,10,,,10,7,8,
   18,8,8,7,8,17,20,6,32,7,,,,,,,,,,,,,,,,,,,,,,,,7,,6,,11,,
   11,,10,6,13,9,10,5,15,15,10,9,9,15,,,,,,,,,,,,,,,,,,,,,,8,
   12,,,11,,12,10,9,50,9,8,18,,66,,8,,,,,,,,,,,,,,,,,,,,9,7,,,
   15,8,21,22,10,,,8,13,11,11,,14,,,,15,29,16,,12,8,10,,
   18,13,11,18,14,,,,12,14,14,,9,10,12,,15,13,13,29,,,,,,,,,,
   ,,,,,,,,,11,8,,,,111,34,,36,,,11,,13,,,85,,34,13,,14,10,
   13,18,6,16,11,10,16,18,15,13,10,16,9,6,11,9,19,19,15,
   14,9,16,14,16,15,11,9,6,10,18,10,19,10,11,6,16,16,15,
   13,16,7,4,6,9,10,4,13,16,15,15,6,24,16,14,7,,20,17,
   24,16,16,10,15,9,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,
   4,6,10,7,,6,,9,,,,8,,,9,8,15,15,8,10,10,15,8,10,8,10,
   15,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,
   ,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,5,5,8,,
   4,4,7,,7,7,8,,8,,4,4,8,6,9,7,,7,,,7,7,8,7,,19,8,7,
   19,7,5,17,7,7,5,7,35,4,4,4,4,7,7,4,5,5,,4,8,,,9,,
   4,4,7,7,8,7,,6,,,,8,,,6,19,7,17,7,5,7,32,7,7,7,31,
   7,5,3,5,,6,4,6,5,,6,6,6,6,7,8,4,3,6,5,7,4,,5,,,6,,
   6,7,7,6,6,5,5,4,6,6,6,6,4,5,5,4,5,,8,4,4,4,,4,10,
   10,6,,8,4,5,6,5,7,4,,5,,,7,8,6,,,7,17,32,7,7,29,7,
   7,5,5,,5,5,6,,5,3,5,,4,,5,6,6,6,4,6,6,5,6,6,,5,,,,
   5,8,7,8,5,5,6,6,6,5,5,4,4,6,6,6,10,9,7,5,6,,7,8,
   7,8,,10,6,5,8,5,9,5,,5,,,5,,,,,8,20,8,37,7,17,6,7,8,
   8,5,,7,7,,5,,,,9,11,,13,4,5,6,,10,4,,7,,,,,8,,10,8,,
   19,10,7,24,12,8,,7,15,12,8,5,,,10,,10,,14,64,6,9,6,8,
   17,,,10,,,9,10,,,,21,10,11,,12,10,25,9,16,9,9,26,4,5,,
   7,,6,8,,8,4,4,,4,,4,,6,,,4,6,,7,8,7,32,7,7,29,,5,5,
   7,,5,8,5,,6,5,,9,7,8,5,3,6,5,7,4,,5,,,5,9,7,7,6,6,
   6,5,5,5,6,6,6,6,4,4,5,,7,10,,10,9,,7,5,,6,,7,,8,,,,
   8,,,,37,8,6,13,17,5,,8,7,34,7,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,7,12,,11,9,7,4,9,5,11,4,,7,,,4,,6,4,6,7,7,5,7,
   7,7,7,7,7,7,4,7,10,8,,21,,,,7,11,12,,7,,,9,6,,13,19,
   20,14,9,13,,17,12,7,10,,11,12,6,,,8,5,8,8,16,6,,9,,,,,
   10,32,12,28,14,11,17,11,10,,7,10,11,34,13,,,8,5,11,8,
   17,9,,11,,,8,,,8,64,,15,12,21,15,9,18,9,12,10,9,20,6,,
   8,11,7,8,6,,9,,,8,18,,,,,,,,,,9,,7,,,,,6,17,10,10,10,,9,,
   ,35,12,,,,,,,,70,9,,6,7,,135,,4,,5,,7,,7,,,6,,,7,8,7,7,
   5,7,,5,8,,29,29,7,7,,5,8,6,,5,,,9,6,8,7,8,5,5,6,6,
   6,4,5,4,5,6,6,6,8,,,,11,,,,11,,,,20,10,11,22,,7,13,17,
   32,,9,17,,7,,5,,,10,10,7,,10,13,6,,13,5,7,12,31,17,7,
   31,8,10,,,,,,,,,,,7,,,,,,,,,,,,7,,,,9,9,8,9,7,5,7,7,7,4,
   7,7,7,7,7,7,,,,,,,,,,,,,,,,,,,,,,,8,,,8,,12,8,13,,7,7,11,
   19,19,7,7,36,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,15,7,,8,,
   7,19,12,9,8,24,12,15,13,105,11,9,10,21,16,12,11,,19,
   9,10,25,7,6,,,,,,143,,241,152,,7,,7,,75,,8,,,,55,57,6,,7,
   ,,9,,8,,128,135,239,9,6,,5,20,,23,6,7,6,7,23,12,30,
   26,17,10,7,6,5,5,18,14,20,5,5,10,26,18,18,5,7,6,7,
   23,20,12,13,6,6,7,16,18,11,16,6,4,6,5,4,4,11,16,18,
   7,6,12,10,26,6,16,11,19,9,16,12,4,7,5,6,6,7,6,7,5,,
   ,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,10,9,9,11,
   21,21,9,9,21,9,9,9,5,5,4,7,7,6,,4,5,6,,6,,5,,9,,4,
   5,6,4,7,5,5,5,4,6,8,8,,,,15,9,7,18,8,10,20,7,7,9,
   7,23,5,5,5,4,8,8,4,7,7,6,4,6,,6,9,,4,5,11,6,8,6,
   4,5,,6,,6,,,9,18,7,20,7,10,7,23,9,8,10,17,7,7,6,7,,
   7,5,5,4,7,5,6,7,7,,,5,6,6,7,,5,11,7,6,,7,,,,,6,11,
   12,12,10,20,7,11,13,7,18,18,5,7,,6,5,5,4,6,4,7,7,6,,
   ,4,7,6,7,8,4,,6,5,,6,11,,,9,6,25,23,7,7,29,7,10,10,
   7,29,10,7,7,,7,6,7,,6,,6,11,,,5,5,7,4,6,5,6,6,5,8,
   8,7,,,,12,12,7,10,20,18,18,7,10,13,7,13,10,9,6,4,4,
   9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,6,,,,5,26,6,20,
   8,,7,8,8,6,6,27,8,6,8,5,8,6,9,7,9,,,6,,8,9,18,6,9,
   ,8,,9,,,,18,9,,19,,11,50,9,14,22,8,22,24,11,7,6,6,,,9,
   ,,,6,7,10,5,7,7,7,7,6,9,10,9,,,,16,16,8,,17,46,30,8,
   11,15,11,29,5,7,,6,,5,8,,,5,5,6,4,7,4,5,5,7,7,6,6,,
   ,11,7,23,7,7,29,29,10,7,7,23,7,9,7,8,5,7,,7,9,,7,6,
   ,7,,6,5,6,,7,,7,,,8,10,7,18,6,18,7,13,13,20,18,18,7,
   6,6,9,10,10,12,,6,4,10,4,8,6,4,4,9,5,9,5,,,12,20,6,
   7,5,,6,27,6,6,27,6,6,,,9,,,,7,7,9,5,10,6,7,7,10,9,
   8,9,,,,14,,8,,26,,17,9,11,35,11,21,11,5,,17,,5,5,6,4,
   8,4,5,5,7,6,6,7,,,,8,13,6,10,10,11,15,7,8,16,7,16,
   7,6,,,6,8,8,5,7,6,9,7,6,7,10,6,,,,12,35,9,11,,26,16,
   8,11,,11,14,7,13,,,5,9,9,29,,4,5,,6,,6,,,11,,8,20,6,
   22,9,,14,12,,22,6,28,,6,7,8,5,8,6,8,8,7,6,9,7,,,,,
   12,8,,38,17,26,8,11,,11,16,,7,12,9,7,12,6,19,,13,,11,
   36,,,,13,,,,,,27,11,34,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,7,
   5,,6,11,6,,,7,7,7,10,7,17,7,9,23,29,25,10,7,8,7,12,
   5,,7,6,,7,11,,,,6,18,13,7,7,18,7,18,18,7,20,11,9,,,7,
   8,,10,,10,,,11,10,8,14,9,50,15,21,19,22,,22,8,,6,9,7,
   10,9,10,9,,,7,5,7,27,7,6,6,6,27,,7,,8,,,,,11,,,,,,9,14,
   ,144,,14,15,,,183,,236,7,5,,6,,6,,,11,10,6,15,7,11,7,
   16,16,10,15,11,7,,8,,7,,,,,6,,14,,7,22,8,20,22,8,12,
   55,6,,7,,,,,6,15,15,25,10,,7,64,26,7,,64,7,9,7,,,11,
   14,10,,6,16,9,14,,20,20,22,8,8,6,,,35,7,,,15,11,26,8,
   16,,9,,17,8,,,12,20,10,,9,22,15,19,21,40,14,50,9,,,,7,
   15,16,12,11,17,8,,,8,46,30,,,,,,,,,,,,,,,,,,,,,,,,,,,,112,,12,
   ,45,,,,,30,36,,12,15,10,19,8,10,6,10,13,25,20,23,28,
   36,22,6,12,18,22,27,21,12,18,36,23,9,28,12,15,6,10,
   19,15,14,11,6,8,10,,28,36,,15,,18,18,18,,36,,28,16,10,
   9,36,27,15,23,28,13,27,,17,18,16,18,8,8,5,6,6,,,4,5,
   5,,5,7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,25,7,9,26,7,8,
   31,7,9,6,8,,8,8,8,6,,,5,6,6,,5,8,,9,,,4,5,8,5,7,5,
   8,7,8,,,9,,,,26,9,31,7,8,12,,6,7,6,,12,6,4,6,,8,5,6,
   4,,6,5,9,9,9,10,5,4,4,7,10,4,6,7,,,,,4,10,10,7,7,7,
   7,6,7,7,7,7,4,6,6,8,6,,9,8,8,6,,5,11,11,6,,8,5,6,
   6,6,10,5,8,5,9,,,8,8,,10,7,31,,6,12,,12,6,8,8,31,8,
   6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,,5,6,,,6,10,9,10,
   7,7,7,7,7,6,6,4,6,7,7,7,,11,5,4,4,,5,7,6,7,,7,6,
   7,4,4,8,4,10,7,6,,,,7,,,7,26,7,,6,28,8,6,9,5,8,28,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,6,,11,,27,,8,,,6,11,,,
   9,8,,,11,,15,,,15,10,,,17,28,9,11,10,23,28,8,6,,5,,8,8,
   ,,8,8,9,6,,5,9,7,,,,8,,,7,6,,12,6,,31,8,7,12,26,9,7,
   6,,6,7,,9,9,10,6,4,7,6,10,4,6,5,,,,,9,9,6,7,7,6,4,
   6,7,7,7,7,7,7,6,,5,,,,9,,5,4,,4,,5,6,5,,,,6,,9,,,7,
   8,5,28,8,28,5,6,,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,,
   7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,7,8,6,7,7,8,8,7,8,
   7,6,7,11,7,82,14,,9,9,6,14,9,6,,11,,,6,,17,13,15,19,
   10,9,,24,13,17,14,,12,12,9,17,,7,5,7,7,13,6,6,,,,,6,
   14,82,14,,12,24,17,13,10,,9,12,15,19,14,11,,7,4,7,4,,
   6,8,7,,,,10,15,7,44,,7,7,17,15,12,14,8,8,12,7,23,9,
   9,10,7,,10,6,18,9,15,,,12,,,,10,,,,,,,,10,,,,,4,15,7,7,
   7,7,8,,,,13,,,,,7,203,103,141,10,,,7,,,99,8,,6,,5,,5,,,,
   7,,9,10,6,8,8,7,31,9,7,26,,25,7,9,9,6,10,6,,7,8,,,
   6,10,9,10,4,6,7,7,7,7,6,7,6,7,7,7,7,44,,10,7,,,,8,,
   11,,12,7,12,8,14,7,15,17,23,,7,8,,5,,7,11,,,10,7,,8,
   5,8,28,6,8,7,6,,28,7,26,9,7,,,,,,,,,,7,,,,,10,,,,,,,,5,6,
   ,,5,7,7,8,7,6,8,7,8,6,7,7,7,7,8,8,,11,,,,13,12,,9,
   18,,,10,15,11,,28,,14,,9,,,,8,9,,8,14,8,29,8,8,8,29,
   28,8,14,28,,,,,27,11,10,23,17,9,15,10,,,28,,15,11,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,7,18,,,14,15,,11,,10,,,9,18,28,9,7,
   ,217,10,,,,141,103,99,,7,7,10,,,,,,,,,,10,,10,,,10,,,,,,,7,,
   ,7,20,15,14,6,7,4,7,13,13,14,33,13,28,7,6,6,6,13,
   24,21,7,6,28,33,14,16,6,7,6,7,14,20,12,14,4,6,7,33,
   16,20,33,7,6,5,6,7,6,20,33,16,7,5,14,28,33,7,15,13,
   14,14,21,12,7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,
   4,5,4,4,4,4,4,,,4,,,,4,13,13,4,4,,4,4,4,13,13,4,4,4,
   ,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,13,
   13,4,4,,4,4,4,13,13,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,
   3,3,3,3,3,,4,4,3,,,9,9,9,9,3,10,9,3,3,3,10,9,3,5,,
   4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,13,
   13,4,,4,13,13,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,
   4,4,5,4,3,4,4,4,5,5,,13,13,4,,4,13,13,4,4,4,4,,,3,
   4,4,4,4,5,3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,17,,25,13,4,
   7,,5,4,4,25,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,
   ,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,10,10,3,9,9,10,10,3,
   3,10,3,9,4,4,4,3,,,4,,3,2,3,3,4,3,3,3,,3,4,4,4,4,,
   10,3,4,9,4,3,10,3,3,4,4,9,,3,5,5,,5,,4,3,5,3,5,4,
   4,4,4,3,4,4,,4,,,5,4,13,13,5,,5,5,13,4,13,,,5,,,,4,
   3,5,3,5,4,4,4,4,3,4,4,,4,,,7,4,13,25,,14,4,5,25,4,
   13,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,13,13,
   5,,5,5,13,4,13,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,,5,,14,
   25,4,17,,25,14,4,4,7,5,,,5,,3,3,4,4,5,4,4,4,,4,,,5,
   15,,29,4,9,13,5,5,,5,4,5,9,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   3,4,4,3,4,4,5,4,4,11,5,5,,,,14,,13,,11,,14,4,4,12,15,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,4,,3,4,4,,3,,10,3,3,
   10,10,3,10,10,10,10,3,10,4,3,4,4,,4,3,,4,4,4,4,,9,
   4,3,10,3,4,9,4,4,3,3,10,4,,,3,,,4,,,,5,,14,4,5,,7,4,
   14,25,25,,4,14,,4,4,4,4,4,6,6,3,,,9,3,10,10,3,3,9,
   10,9,3,10,10,,15,,,4,,,,,,14,4,15,,15,4,14,,,19,19,,,3,
   4,4,,,5,5,,13,4,5,,5,4,13,13,13,5,5,,,4,,,,5,5,,13,5,
   5,,5,5,13,9,9,4,4,14,4,4,,,5,5,,13,4,5,,5,4,13,13,
   13,5,5,,3,4,4,12,4,,16,4,4,10,8,3,10,,6,8,4,10,4,4,
   4,,,9,7,6,20,4,8,9,4,4,3,,12,3,5,,,28,5,,31,4,4,31,,
   9,5,9,28,5,,,28,5,,31,4,4,31,,9,5,9,28,4,,,15,4,14,,
   19,,19,15,,4,14,,,13,,14,4,15,,12,11,4,,14,,,,,,,,,,,,,13,
   35,10,27,10,,10,13,37,37,,8,35,7,4,10,3,4,6,8,21,13,
   4,8,21,6,7,3,4,10,13,37,,37,27,10,10,,6,24,8,10,4,3,
   10,13,4,3,7,10,35,13,10,27,35,10,4,10,7,27,8,6,24,4,
   13,13,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,
   ,,4,,,,4,13,13,4,4,,4,4,4,13,13,3,4,,,4,4,4,4,3,,,4,,
   ,3,4,4,4,4,4,4,3,4,,,4,5,,5,13,13,,4,4,13,13,4,4,4,
   ,4,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,
   13,13,,4,4,13,13,4,4,4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,
   3,3,3,3,4,3,3,4,,4,3,,,10,10,10,9,3,9,10,3,3,3,9,
   10,3,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,31,,31,,
   4,9,28,5,4,5,22,9,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,
   ,,,5,,,31,,31,,4,9,28,5,4,5,22,9,4,4,,3,,,3,,,3,3,3,
   3,3,3,3,2,4,4,,3,,,3,10,9,9,3,9,9,9,3,3,10,9,3,3,
   4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,13,4,13,4,
   ,4,4,13,13,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,
   ,4,13,4,13,4,,4,4,13,13,4,,,,,,,3,3,3,3,4,3,3,3,4,4,
   ,4,12,,4,16,6,9,4,8,,12,3,4,8,9,4,3,,,4,,3,2,3,3,
   4,3,3,3,4,3,,4,4,,4,12,4,9,4,4,4,12,4,4,4,9,4,,4,,
   ,3,4,4,4,4,4,4,3,5,3,,4,,,5,14,25,17,4,,25,13,4,4,
   7,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,
   3,5,,15,,5,13,9,5,4,23,4,5,5,13,9,,3,4,4,4,4,4,4,
   3,5,15,,5,,,,14,,,19,15,,14,4,4,15,,13,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,3,,4,,4,3,3,,3,,3,,,3,10,3,10,3,10,3,9,9,9,10,
   10,3,4,4,4,4,,3,3,,,3,4,,4,9,4,10,3,3,4,9,4,4,3,
   10,3,,,,4,4,,5,,5,,,5,14,4,,5,7,4,13,25,25,,14,4,,3,
   4,4,5,5,,5,5,,5,13,4,,5,5,4,13,13,13,5,,5,,12,,,5,,,,,
   ,14,4,,14,12,4,14,,,11,,13,4,4,5,5,,5,5,,5,13,4,,5,
   5,4,13,13,13,5,,5,,3,,,,4,,,9,4,12,,3,4,10,8,8,4,10,
   6,3,3,,,3,,,10,3,10,10,3,3,10,9,10,3,10,10,4,,4,,,4,,
   5,14,4,25,4,17,,7,25,14,4,,4,5,,5,13,9,29,4,4,9,13,
   5,5,5,,5,,,,,,,,,,,,,,,,,4,,,,5,14,25,4,4,14,,7,4,14,25,,
   4,,14,14,4,,13,,11,17,,14,4,,,,,,,,,,,,,,,13,14,,4,15,,15,
   12,4,14,,13,,21,37,10,,10,13,27,,45,21,8,8,4,10,3,4,
   8,45,7,13,13,35,10,27,24,10,,10,4,9,33,8,7,3,10,4,8,
   35,7,6,4,10,3,13,4,3,8,21,8,13,10,37,,21,4,6,24,7,
   11,34,10,13,4,13,4,3,,5,4,4,3,5,4,4,4,4,,5,3,4,3,
   4,5,3,5,4,4,,4,,4,,,4,,13,13,4,,4,4,4,4,13,13,4,,,3,
   3,3,3,3,,4,4,6,6,2,3,3,3,4,3,3,3,3,4,4,,4,6,6,4,
   4,4,4,3,4,4,3,3,3,4,4,,5,4,4,3,5,4,4,4,4,,5,3,4,
   3,4,5,3,5,4,4,,4,,4,,,4,,13,13,4,,4,4,4,4,13,13,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,,,,7,,3,3,4,4,5,
   4,4,4,4,5,3,,4,,,30,5,,,4,5,30,4,4,4,8,8,4,3,,4,,4,
   4,,4,3,3,3,3,4,2,3,3,4,4,3,,,4,4,3,10,4,4,9,10,3,
   3,3,9,4,4,4,,3,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,
   4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,4,6,6,4,,3,2,4,3,
   4,3,3,3,4,3,4,,,4,4,10,3,4,4,9,3,10,3,3,9,4,4,,,,,,
   6,4,3,4,4,6,3,4,4,3,5,4,,12,5,5,5,7,5,5,8,,4,4,5,
   8,5,5,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,
   4,4,5,5,5,5,4,4,4,4,4,14,6,3,3,3,3,4,3,3,3,4,4,4,
   ,,6,6,4,8,4,4,,8,4,3,3,6,6,6,3,6,,4,3,4,4,6,4,4,
   4,,4,,,6,16,16,,5,10,10,6,5,,5,5,6,10,10,6,,4,3,4,4,
   6,4,4,4,,4,,,6,16,16,,5,10,10,6,5,,5,5,6,10,10,6,4,
   6,4,5,6,4,7,5,6,,5,,,,,5,,,,12,,5,5,5,14,,,4,4,6,5,
   6,6,5,5,6,5,,,,,,,5,,,14,5,,5,5,16,,,3,,4,,3,4,4,,3,3,
   ,,4,4,3,3,4,4,9,3,3,10,10,9,4,4,3,4,6,3,,4,3,,3,,
   4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,4,14,,4,4,,3,,,,6,6,
   4,3,6,6,6,3,4,8,8,,4,4,,4,,3,5,5,5,,4,,,4,4,13,13,
   4,4,4,,,4,13,13,6,,,,7,7,,,,,5,5,,,14,5,5,,,12,,,4,4,
   3,3,,,4,6,6,4,3,6,6,4,3,4,4,4,4,6,6,,5,,5,,4,,,4,5,
   ,,4,5,4,30,30,4,8,8,5,5,5,,4,,,4,4,13,13,4,4,4,,,4,
   13,13,4,4,,12,5,5,5,5,5,5,8,4,4,,7,8,5,5,4,,4,,,4,
   30,8,8,4,30,4,5,5,4,,,,4,,,30,4,,,4,4,30,5,5,4,8,8,,,
   ,,,,,,,,,,,,,4,4,14,14,4,4,,14,12,10,16,,4,4,3,,,,,4,,,,,
   4,,,,,,,4,,,,,4,,,4,20,20,7,4,6,4,4,7,13,13,20,20,8,6,
   4,4,4,7,20,20,3,4,13,19,13,13,3,4,4,4,13,19,13,13,
   3,4,4,6,8,8,6,3,3,3,4,4,4,8,19,19,4,4,7,20,20,6,
   6,13,13,8,20,20,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,
   4,4,4,3,4,,,4,5,,5,13,13,,4,4,13,13,4,4,4,,4,,5,4,
   4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,13,
   13,4,,4,4,4,4,13,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,
   4,4,3,,,,,,3,4,4,4,4,4,4,3,4,,6,5,5,,,25,13,17,,4,
   14,25,4,4,5,,7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,
   ,4,4,,13,4,13,,4,4,4,13,13,4,4,,4,,,4,,5,4,4,4,4,5,
   3,4,3,,,4,4,,,4,4,,13,4,13,,4,4,4,13,13,4,4,3,6,6,4,
   ,,3,3,4,3,3,3,3,2,4,,4,3,,,3,9,10,10,3,9,10,10,3,
   3,9,10,3,,,,,,5,4,4,4,4,5,3,4,3,6,,4,5,15,,5,4,23,
   13,5,9,,5,5,4,9,13,5,4,4,,,4,3,3,3,3,4,2,3,3,4,,3,
   4,4,,4,4,12,9,4,4,12,4,4,4,4,9,4,3,4,,,4,4,4,4,5,
   4,4,3,,,,4,,,5,9,28,31,4,,31,,4,5,9,28,5,4,,,4,4,4,
   4,5,4,4,3,,,,4,,,5,9,28,31,4,,31,,4,5,9,28,5,,,3,3,
   3,3,4,3,3,3,4,,4,4,4,,11,,12,9,8,4,16,6,4,3,4,10,8,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,15,5,,,,,14,
   ,15,19,14,,4,4,15,,19,4,,4,,3,4,3,,,3,3,,,3,3,10,10,
   3,9,9,3,10,9,10,9,3,4,3,,4,,4,5,,5,5,5,,5,4,13,,4,
   4,13,4,13,13,4,,4,4,12,,4,3,,,,3,,,4,4,10,16,4,6,9,
   4,8,8,,12,3,,4,,4,5,,5,5,5,,5,4,13,,4,4,13,4,13,13,
   4,,4,4,,,,,5,,,,,4,14,,15,13,14,4,,,19,,19,4,3,3,,,3,4,
   ,4,4,9,12,4,4,9,4,4,4,4,12,4,,5,,5,,5,,,4,13,14,,4,
   14,4,25,25,5,,7,3,,3,,3,,,3,10,10,9,3,10,3,9,9,3,10,
   10,,4,4,,,4,5,,14,4,25,17,4,,7,25,13,4,,,,,,,,,,,,,,,,,,
   4,5,,5,9,13,,5,5,13,9,5,5,4,23,4,4,,,5,,14,25,4,14,
   4,,7,4,13,25,,4,15,,14,4,,,19,19,13,,14,4,,,,,,,,,,,,,,15,
   ,14,,4,,19,15,19,4,14,,13,35,8,9,10,4,3,4,6,37,8,10,
   35,33,,10,10,13,37,,21,13,13,,21,37,33,10,,10,4,37,8,
   6,9,3,10,4,21,8,8,8,4,10,3,13,13,10,35,10,33,4,3,9,
   33,8,4,10,35,9,8,21,8,13,4,13,5,,4,3,4,5,4,,4,,,,3,
   4,4,3,4,4,5,4,3,4,4,4,5,5,,13,13,4,,4,13,13,4,4,4,
   4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,4,3,4,,,,5,,7,,,30,
   5,4,8,8,4,4,4,30,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,3,,
   4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,13,13,4,4,,
   13,13,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,3,4,3,3,2,,4,4,
   3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,4,,5,5,,,4,4,5,
   3,4,4,4,3,4,4,4,3,,5,5,13,13,4,4,,13,13,4,4,,4,4,,,
   5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,8,8,4,5,30,,,4,
   4,30,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,3,3,3,6,4,6,6,
   6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,3,
   4,4,4,4,4,4,3,,,,4,7,,5,8,8,30,4,5,,,4,4,5,30,4,,,
   3,4,4,3,4,4,5,4,3,4,4,4,7,5,,,,4,30,5,8,8,4,4,5,
   4,30,3,4,4,5,4,4,4,5,4,6,16,16,6,,,,,,,,,,,4,4,,,,4,
   4,5,4,4,4,5,4,6,16,16,6,,,,,,,,,,,4,4,,,,4,,3,,4,4,3,,
   4,4,3,,4,4,4,4,3,3,10,4,4,9,9,10,3,3,,4,4,3,,4,4,,
   ,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,12,,6,4,,,,4,,
   6,6,5,5,5,5,7,5,5,8,8,,4,4,,4,4,3,4,6,6,4,4,,4,4,
   4,10,3,3,4,4,9,9,3,10,3,4,12,,,6,6,,,,,4,4,14,14,16,
   4,4,,,10,14,12,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,
   5,5,,4,,,,6,6,,5,5,4,,4,5,5,8,8,5,5,7,3,4,4,,4,4,,
   4,4,3,10,3,4,4,9,9,3,3,10,4,4,3,14,6,4,6,6,4,3,8,
   4,4,,6,8,4,3,3,4,6,,6,10,10,,5,5,10,10,6,6,5,,5,4,
   6,,6,10,10,,5,5,10,10,6,6,5,,5,4,6,14,6,6,4,8,3,4,
   4,,6,3,4,8,6,6,,,5,5,,,,12,14,,5,5,6,,,,5,5,,,14,12,5,
   ,5,,,5,,5,,,16,14,5,5,,3,20,20,13,4,4,3,4,13,13,19,
   20,20,13,4,4,3,4,13,13,19,4,4,20,20,7,8,4,6,4,4,13,
   13,7,7,4,4,6,20,20,8,6,6,4,4,3,4,3,13,19,20,4,3,
   13,19,20,3,6,8,7,8,6,8,4,4,4,6,5,6,4,6,5,5,6,5,,
   7,4,5,4,6,7,4,6,5,6,,6,,5,,,6,,21,17,5,,6,6,6,5,21,
   17,5,4,6,6,5,,6,,,,4,5,6,4,5,6,6,5,4,5,6,5,7,7,,
   21,17,6,,6,17,21,5,5,6,6,,4,4,,3,,4,,,5,4,4,4,3,5,
   3,5,4,4,4,3,4,,4,,5,,4,13,13,,5,5,5,13,4,13,3,6,4,
   4,,4,,4,3,3,3,3,4,2,4,3,,4,3,4,4,4,,3,10,4,9,4,10,
   3,3,3,4,4,9,6,4,6,4,6,,,3,3,4,2,3,3,4,3,3,3,3,3,,
   3,,10,10,3,10,10,10,10,3,3,9,3,10,,,6,,,7,6,5,6,4,7,
   4,6,5,6,5,4,5,,5,,6,,5,17,21,,6,6,6,21,5,17,,4,,,5,
   4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,13,13,,5,5,5,13,
   4,13,4,3,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,31,4,31,,
   28,9,5,4,9,5,28,4,,,3,3,3,3,4,3,4,3,,4,,4,4,12,,6,
   20,8,9,4,12,,3,4,4,8,10,,,4,4,4,3,5,4,5,4,4,4,4,4,
   ,5,,,31,4,31,,28,9,5,4,9,5,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   3,4,4,3,4,4,5,4,4,5,12,5,,,,,14,13,,12,14,,4,4,15,15,
   ,4,,3,,3,6,4,,4,3,4,,3,,3,10,3,10,9,10,3,10,10,10,
   3,9,4,4,,4,,3,4,,4,,5,5,,4,13,4,,4,13,4,13,13,4,4,,
   3,12,,6,4,,4,,4,,4,,4,10,4,16,6,10,4,8,8,,3,12,,3,6,
   4,4,6,4,6,3,,,3,9,9,10,3,9,3,10,10,3,10,9,4,,,,,4,,,,
   ,4,14,14,,17,14,4,,,11,13,,6,4,3,4,,4,4,4,,4,9,4,12,
   4,9,4,4,4,4,4,12,,6,,6,,7,7,,5,17,6,,6,17,5,21,21,
   6,6,,4,,4,,5,5,,4,13,4,,4,13,4,13,13,4,4,,4,3,4,12,
   4,,4,16,4,10,7,10,3,,6,8,4,9,4,3,5,,,5,28,9,28,5,
   31,4,,9,4,,31,4,4,,,7,9,,10,3,9,8,4,4,4,6,16,5,,,5,
   28,9,28,5,31,4,,9,4,,31,4,,14,,4,14,,,13,11,12,,4,14,,
   19,,,14,4,,13,15,19,4,,14,,,,,,,,,,,,,13,8,21,7,10,4,3,
   4,8,9,33,21,,24,,10,10,13,27,35,10,13,4,45,7,8,8,3,
   4,10,13,,45,27,37,10,10,,34,10,11,6,4,3,10,13,13,10,
   24,21,,4,3,7,8,21,4,6,8,37,7,10,35,4,13,13,4,4,4,4,
   4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,31,,31,,4,9,28,5,4,5,
   22,9,,4,,5,,3,5,,5,4,4,4,4,5,3,4,3,,,4,,,15,5,5,,9,
   5,13,29,4,4,5,13,9,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,,,4,
   ,16,16,6,5,,10,6,10,,5,5,5,10,10,6,4,4,6,6,6,,,3,3,
   4,3,4,3,3,3,4,,4,,,12,4,12,,8,4,9,6,20,4,3,9,8,4,,,,
   ,,6,4,4,4,4,6,3,4,4,,,4,,16,16,6,5,,10,6,10,,5,5,5,
   10,10,6,5,6,,,6,4,3,4,4,6,3,4,4,,,4,,5,12,5,5,,8,5,
   5,9,6,6,5,5,8,5,,5,,,4,4,4,4,5,4,4,3,,,,,,40,7,,,39,
   5,,20,8,4,5,9,27,7,,,,4,4,4,4,5,4,4,4,,,,,,,,30,,28,
   13,13,30,,5,5,15,28,13,,,4,3,4,4,6,4,4,4,,,,,6,44,16,,
   ,36,11,6,9,,6,4,6,22,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,
   5,6,6,5,5,6,,41,,,,,,,,23,13,10,,6,5,18,175,,4,,4,,3,
   4,4,,,3,,,11,4,3,,8,4,9,6,4,20,12,10,7,4,4,,,4,,5,5,
   ,5,,5,,7,4,,30,5,4,8,4,8,,4,30,5,4,24,,4,4,,,,,,14,
   6,4,,14,6,6,6,6,14,8,,8,4,,4,3,,5,,5,,5,,,4,,31,,4,
   9,5,28,31,5,28,9,6,,,,,7,,,,,5,,,31,15,10,6,,,22,,,4,4,
   3,,,,4,16,6,4,,10,6,4,6,6,6,4,4,10,6,,5,,5,,5,,,4,,
   31,,4,9,5,28,31,5,28,9,5,,5,,4,,,4,,15,13,4,7,5,,17,
   4,15,14,,4,,44,16,6,5,,11,6,18,9,5,,7,30,10,6,,,,,,,,,,,
   ,,,,,,,,5,,,21,,,,5,9,22,7,5,4,11,8,,,,,,,,,,,,,,,,16,5,14,
   ,10,5,,23,18,20,17,,10,5,,,,,11,12,,,,,15,,,19,,,,5,,,,
   25,5,,,,24,9,8,8,,4,4,9,21,12,,,,,,,,,,,,10,48,24,20,25,
   7,31,8,5,63,29,30,11,4,8,5,16,8,9,7,4,7,4,8,8,8,
   11,38,41,6,4,8,19,71,,11,16,45,8,28,12,10,5,,4,,,5,,5,
   ,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,,25,14,4,,17,14,25,4,
   4,,5,7,4,4,4,,,,6,14,3,3,3,3,4,3,3,3,,4,4,4,6,6,,
   8,4,4,,4,4,8,3,3,6,6,6,3,,,5,,,,4,4,5,3,5,4,4,4,4,
   4,4,4,,5,,28,9,4,,31,,31,4,5,22,5,9,,,5,,,,4,4,5,3,
   5,4,4,4,4,4,4,4,,5,,28,9,4,,31,,31,4,5,22,5,9,,5,,7,
   ,4,3,5,3,5,4,4,4,4,3,4,4,,4,,19,7,4,,,7,19,5,5,8,
   4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,5,4,4,4,,,,,7,
   41,,20,8,39,,5,,,5,4,7,22,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   5,6,4,5,6,6,5,6,16,9,7,,,,,,19,,31,,,5,5,,,,12,12,17,
   11,16,16,16,15,20,44,,40,,,,,,,,,11,,12,15,,,,4,,3,,4,4,
   4,,4,4,4,,4,,8,4,3,,10,4,8,10,10,20,4,6,,4,5,,,5,4,,
   3,5,6,6,,8,5,4,,4,5,8,5,5,5,5,7,4,44,,,,,,,,,6,,11,
   6,5,,7,6,11,30,36,,5,9,,4,4,4,4,6,6,6,4,,,8,4,10,,
   3,4,8,10,9,4,20,6,16,16,,,6,9,,,,,10,5,14,,17,5,10,,,
   20,14,17,3,,4,,,,6,6,,10,6,5,,5,6,10,10,10,6,6,12,,4,,
   ,,6,6,,10,6,5,,5,6,10,10,10,6,6,12,4,5,6,,5,5,,9,5,
   5,,5,5,9,13,13,4,4,29,4,4,4,24,6,,14,6,4,,8,4,8,,6,
   14,6,6,,5,6,,,30,10,9,,5,11,17,6,6,5,,7,,6,,,31,6,,,
   4,6,31,6,6,5,9,9,5,,,22,7,,,5,5,21,,9,4,8,20,6,,,31,
   5,,,,,22,13,,6,10,,,,,,5,35,147,14,22,6,,10,,,,,,,,,,,,,,24,
   ,39,12,31,7,10,20,17,54,9,,11,5,12,4,5,30,48,65,,4,
   11,15,9,8,4,7,8,,,,,,,,,15,34,11,8,7,4,8,,5,4,49,49,
   105,10,7,45,17,20,4,11,9,15,8,11,13,6,8,8,4,,4,,,4,,
   5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,13,4,13,,4,4,4,13,
   13,4,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,13,13,
   4,4,,13,13,4,4,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,
   4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,13,13,,5,5,5,13,
   4,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,,4,
   ,,4,7,,25,4,13,17,,4,5,14,25,4,,,4,4,4,3,5,3,5,4,4,
   4,3,4,,4,,,14,4,25,13,,7,5,4,14,4,25,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,4,4,5,3,4,4,4,3,5,5,12,4,,,,,14,13,11,,14,,4,4,
   ,14,17,3,,4,,4,,4,,,4,4,,5,5,4,13,4,4,,13,4,13,13,,
   4,4,,4,,4,,4,,,4,4,,5,5,4,13,4,4,,13,4,13,13,,4,4,4,
   15,,3,4,,,,4,,5,5,5,13,4,4,23,13,5,9,9,,5,5,,3,4,3,
   6,6,4,4,,,3,3,9,9,3,10,10,3,9,10,9,10,3,4,,,,,4,,,,,
   4,14,15,15,,14,4,,,,13,12,4,3,4,4,,3,,4,4,4,9,4,4,
   12,9,4,4,4,12,4,4,,,,4,,,5,,4,14,4,,14,14,4,25,25,,5,
   7,4,4,3,,,3,,3,10,3,9,10,10,3,10,10,10,3,10,3,4,4,,,
   5,5,22,9,5,28,31,4,,9,31,,4,4,4,,,5,5,22,9,5,28,31,
   4,,9,31,,4,3,,,4,8,9,,3,10,9,8,4,4,16,6,4,,4,12,4,
   10,4,7,10,12,3,,6,9,4,8,,,,,,,,,,,,,,,4,15,,,4,14,,15,
   19,13,14,,4,11,,4,,14,,12,14,13,14,4,,13,8,6,37,10,4,
   3,4,27,8,11,21,24,,,10,10,13,,45,34,4,13,35,8,9,8,10,
   4,3,13,27,7,8,7,10,3,4,10,35,33,21,,10,10,13,13,10,,
   21,24,4,3,37,8,6,4,21,8,7,45,7,10,13,13,4,4,4,5,,5,
   5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,13,4,13,4,,4,4,13,
   13,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,16,16,6,5,,10,6,10,,
   5,5,5,10,10,6,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,
   5,5,4,4,4,5,5,5,5,4,4,4,,4,,7,4,4,4,4,5,3,4,3,,6,
   5,4,,,4,5,30,,4,,30,5,4,4,8,8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,6,,4,3,4,4,6,3,4,4,,4,5,6,5,5,12,,4,5,8,5,5,7,
   5,4,5,5,8,6,5,6,5,5,6,4,6,4,,,5,6,,,,5,,,14,,,5,5,5,
   ,,12,5,4,7,5,6,6,4,4,,5,,6,,,,,5,,12,,5,,5,5,,,15,4,,
   3,,4,4,4,,5,5,5,,,4,4,4,13,4,13,4,4,,,13,13,4,4,4,
   6,3,,3,,,3,3,6,6,4,3,4,4,3,4,4,3,4,4,4,4,3,,,,4,4,
   ,5,,5,,,4,5,4,8,4,8,4,5,30,30,,,4,,4,4,4,,5,5,5,,,
   4,4,4,13,4,13,4,4,,,13,13,4,6,14,,,7,7,,,,,5,5,,16,,
   5,5,,,,,14,3,3,,3,,3,6,6,4,4,3,6,4,6,3,4,4,4,6,6,4,
   ,,,3,,6,6,,3,4,4,,4,4,3,8,8,6,6,6,,3,3,,4,4,,3,3,
   4,9,4,3,3,10,10,4,4,9,,,,,,,,,,,,,,,,,,,4,4,,,4,4,30,8,
   4,8,30,4,5,5,,,4,4,,,4,30,4,,4,,4,30,5,5,8,8,4,5,5,
   12,5,5,5,8,5,4,4,,7,5,5,8,3,4,,,,4,,,,,,,,4,4,,,,4,,,,,
   ,,,4,10,14,4,,4,14,16,14,12,4,4,,4,13,6,13,4,6,4,4,
   13,13,8,19,8,19,6,4,4,4,13,13,6,4,3,20,20,13,20,4,
   4,3,4,7,8,7,7,3,3,3,20,20,13,20,4,4,3,4,4,4,20,20,
   8,4,4,13,13,6,6,20,20,7,19,19,8,3,4,4,,,5,,,,4,4,5,
   3,5,4,4,4,4,4,4,4,,5,,28,9,4,,31,,31,4,5,22,5,9,5,
   5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,13,13,5,,5,
   5,13,4,13,6,6,,,5,6,6,4,5,5,6,4,5,6,5,4,,7,7,17,
   21,6,6,,21,17,5,5,,6,6,6,7,,5,4,6,6,7,5,4,4,,6,,6,,
   ,5,,6,21,5,17,6,,6,6,17,21,5,7,,5,4,6,4,7,5,6,6,5,
   4,5,6,,5,,,6,5,21,17,6,,6,6,17,5,21,,4,4,5,3,4,4,4,
   3,5,12,5,4,,,,14,,13,12,,,14,4,4,,15,11,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,13,4,5,5,,4,13,13,13,,
   5,5,6,3,4,4,,3,4,,4,3,,4,4,9,4,3,3,10,4,9,4,4,10,
   3,3,6,,,6,6,,6,,6,,7,7,17,5,6,6,,5,17,21,21,,6,6,,4,
   3,3,6,4,6,4,,,3,9,3,10,3,10,3,10,10,10,10,10,3,,12,,
   ,4,,,,,,14,4,19,23,,4,14,,,,17,13,4,4,,4,,4,,5,5,13,4,
   5,5,,4,13,13,13,,5,5,,4,,4,,,4,,10,4,3,,12,4,10,8,8,
   10,4,6,4,3,4,,,3,,10,3,3,10,10,3,10,10,10,10,3,10,4,
   3,4,,,5,22,5,,4,31,4,31,,9,28,9,5,4,3,,,4,9,8,6,4,
   20,8,9,4,4,12,,3,4,,,5,22,5,,4,31,4,31,,9,28,9,5,,4,
   12,10,4,4,8,10,3,12,,6,10,4,8,,,,,,,,,,,,,,,4,,15,,4,14,
   13,,12,11,14,,4,,17,4,,14,19,,23,13,14,4,,13,45,34,,10,
   ,10,13,,20,14,7,10,45,4,10,3,4,20,7,6,4,13,8,21,7,
   10,10,4,3,13,7,24,7,6,10,3,4,21,,24,34,,10,10,13,4,
   3,45,7,10,13,10,,45,34,4,34,10,6,14,6,7,13,13,4,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,
   6,3,4,4,,,,,17,20,6,9,,36,6,11,,,4,6,11,30,6,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,5,
   6,5,20,6,,,,,10,14,,,,,5,6,,16,39,,,4,,4,3,,,,4,,,5,,5,
   9,4,,31,,4,31,28,28,5,9,,4,,4,,5,3,,4,5,,5,7,4,8,4,
   5,30,,4,,8,30,4,5,4,41,,,,,,,,,5,,7,9,4,8,20,,5,39,29,
   ,5,,,3,4,4,6,6,4,6,11,,4,4,6,9,4,8,,3,12,16,7,10,
   4,6,,,,,6,,,,,6,10,16,,,,5,,,,21,22,4,4,4,4,,4,16,4,6,
   6,6,4,6,10,,4,4,6,10,4,6,,,,4,,,5,,5,9,4,,31,,4,31,
   28,28,5,9,6,5,4,,,4,,5,7,4,13,15,,4,14,,15,4,14,,4,,,
   9,9,5,9,6,6,31,,4,,9,31,6,6,4,5,41,,7,4,11,9,7,22,,
   5,,8,21,,5,4,20,,6,8,6,,4,8,,8,4,6,8,6,6,44,6,17,6,
   9,6,10,17,,4,,,50,6,11,16,,,,12,11,,,,,,,15,,5,13,20,,5,
   10,,13,17,16,10,,5,,,5,,,,19,21,,,5,,8,9,48,20,,,4,6,
   45,10,74,13,69,48,,8,8,8,81,13,65,5,10,,7,8,8,7,4,4,,
   ,10,9,29,8,4,5,,25,24,24,31,7,8,,,,,,,4,4,13,9,8,,24,
   9,12,14,9,48,10,,5,4,,,7,4,4,4,3,5,3,5,4,4,4,3,4,,
   4,,7,19,4,,,19,7,5,5,8,4,8,,6,,4,3,4,4,6,3,4,4,,4,,
   ,5,12,5,9,6,8,5,5,5,,5,6,5,8,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,6,5,6,5,4,6,4,7,5,6,16,4,6,,,,6,,14,,,,6,6,6,,14,,
   5,4,7,4,6,6,5,5,6,4,16,6,,,,,6,14,,,6,,6,6,,18,,4,,4,
   ,4,,3,,4,4,,,4,,5,5,4,13,13,5,5,,,13,4,13,4,3,6,3,,
   4,4,,3,4,6,4,6,4,6,3,4,4,6,4,6,6,4,3,4,4,,,6,,,4,,,
   ,4,,7,5,4,8,8,5,7,19,19,,4,,,3,4,4,6,4,4,6,4,,4,4,
   4,9,4,4,4,4,12,12,4,9,4,6,,,,6,6,,,,,6,6,18,,,6,6,,,,
   14,,4,4,4,3,,4,6,4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,
   ,4,,5,7,4,,,7,5,19,19,8,4,8,,4,4,,,4,,5,5,4,13,13,
   5,5,,,13,4,13,4,4,3,16,6,16,6,6,6,10,10,5,5,,12,10,
   6,10,3,4,6,,6,4,10,6,6,6,10,4,6,6,4,,4,4,6,,6,10,4,
   ,4,4,4,10,6,6,6,6,6,16,6,16,6,6,6,10,10,5,5,,12,
   10,6,10,4,3,,,4,,,,,,,,4,,4,12,16,,4,4,16,12,12,12,4,,
   4,,,4,,,,,,,,4,,6,9,12,12,4,9,4,6,19,8,19,7,19,19,9,
   4,4,6,12,9,12,4,4,9,7,8,9,3,3,3,3,12,19,19,12,4,3,
   4,12,19,19,12,4,3,4,6,6,4,19,7,19,6,4,12,9,12,9,27,
   9,27,19,7,19,4,3,4,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,9,
   28,31,4,,31,,4,5,9,28,5,,,4,4,4,3,5,4,5,4,4,4,4,4,,
   5,,,31,4,31,,28,9,5,4,9,5,28,,15,16,16,12,16,12,17,
   12,41,,20,14,,,,11,,,,,,,15,12,,,,5,6,6,4,5,5,6,4,7,,
   17,6,,,,,,19,31,,,,5,5,,,,,,4,,5,,4,,3,5,4,,5,5,5,9,5,
   5,,9,5,13,13,29,4,4,3,4,16,,,4,,,,4,,6,6,6,10,5,5,,
   10,6,10,10,,5,5,4,16,,,4,,,,4,,6,6,6,10,5,5,,10,6,10,
   10,,5,5,,4,4,3,6,6,6,4,,,4,4,8,12,3,,8,4,9,10,6,20,
   4,5,44,,,,6,,,,,5,10,17,21,,10,5,,,29,16,18,,4,5,6,,4,,
   6,6,5,8,5,5,,8,5,5,5,9,6,6,,,,,,,6,,6,11,4,,,11,6,
   36,30,,6,9,4,4,4,,,4,,4,8,3,12,,8,4,10,10,6,4,20,,5,
   4,,,5,7,22,,5,,39,5,,9,20,8,4,,4,,,5,15,28,30,5,,28,
   13,13,13,30,,5,4,,,6,11,30,,4,,18,11,6,6,9,,6,,6,24,
   6,14,4,8,,8,4,,6,6,6,14,,,,,,,,,,,,,,,6,,,,5,,,23,13,22,
   10,,6,39,,5,,,,,18,15,10,6,,,11,15,,12,5,4,5,41,44,30,
   15,34,,31,12,7,10,81,14,15,4,,24,9,8,9,8,,4,,39,11,
   10,10,8,4,,,,,,,,,,10,7,48,24,25,5,4,63,29,38,4,16,8,
   8,13,11,8,8,8,6,6,,4,3,4,4,6,4,4,4,,4,,,6,16,16,,5,
   10,10,6,5,,5,5,6,10,10,,5,6,5,5,6,4,6,4,,40,,6,,,,10,
   ,,13,23,,,5,6,,,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,5,,
   5,,,4,7,5,25,4,14,4,,17,,14,25,4,4,4,6,4,,3,,,,3,6,
   14,4,6,6,8,3,4,4,,4,6,4,8,3,3,,,4,4,,5,,5,,,5,9,5,
   28,5,9,4,,31,28,,31,4,,,4,4,,5,,5,,,5,9,5,28,5,9,4,,
   31,28,,31,4,,24,,,7,,,,,,10,6,,18,,5,,,,39,,15,4,4,,5,,
   5,7,,5,8,4,19,5,7,4,,,8,7,19,5,,,,,,6,14,,6,6,8,,4,4,
   ,8,14,6,14,6,,3,,,4,12,,6,4,8,10,4,3,,12,20,4,8,10,,,
   ,,,,,,,,,,,,,,,,,4,,,5,9,27,20,4,8,39,,5,7,,,5,,,,,,,,,,,,,,,
   ,,6,17,44,,6,11,36,6,4,,,9,6,11,30,,5,,,,5,,19,,31,,,,
   5,16,,,,15,,,,,,11,,12,29,16,10,,5,17,,21,18,5,10,,8,48,
   16,63,8,,8,8,41,81,13,24,8,29,,,4,6,44,14,11,10,,24,,
   39,25,12,31,7,5,8,,10,8,4,7,4,9,,11,38,5,12,4,,4,4,
   11,15,9,,,,,,,15,34,10,30,15,8,,5,10,,5,6,5,4,6,4,7,
   5,6,14,5,5,,,,,,14,,,,10,6,5,23,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,,4,,5,,,,4,5,3,,4,,,4,4,25,14,5,7,,14,14,4,25,4,
   3,6,4,,4,4,,4,4,6,4,14,,4,3,8,4,6,6,6,4,4,3,8,4,,,
   ,3,,4,,,,5,,,4,5,28,9,5,9,28,31,,4,31,,4,4,4,6,4,6,
   6,4,,12,,3,10,8,4,4,6,16,12,4,10,8,,41,,,6,,,,,,,5,17,
   ,23,6,10,,,,15,,,,5,4,,6,7,5,,,4,5,19,7,4,8,8,,7,5,
   19,,,,,,,5,,,5,5,,,7,9,29,39,8,4,20,,4,,,,5,,,4,5,28,9,
   5,9,28,31,,4,31,4,5,,17,6,44,,5,6,30,11,5,7,,9,11,6,
   36,4,4,6,,24,,8,6,14,6,14,6,6,4,4,,8,,7,,41,,5,,39,
   5,4,20,8,,7,9,29,,,,,5,15,28,15,5,24,,15,15,15,28,5,,,
   21,5,,,,,,25,,5,,16,,14,,10,5,14,23,12,21,5,,10,,,15,,,,,,
   ,11,12,,,,,,,,,,,,,7,25,10,,8,4,4,12,8,28,10,5,9,13,10,
   8,4,4,7,,20,48,17,65,12,7,31,48,69,73,11,5,4,12,8,6,
   4,49,9,16,8,8,41,11,38,,49,9,14,15,11,59,5,,10,4,4,
   5,4,4,4,5,4,6,16,16,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,
   ,,4,,15,12,,,4,14,14,,13,11,16,,3,4,,,,,5,,,,,4,,,,,,4,,,,
   ,,5,16,,,5,,44,,5,,,,5,,14,12,23,,5,10,10,,14,21,,4,,5,
   7,,5,7,,,,4,,,15,13,,4,14,14,19,,15,4,,,,,5,,,,,4,,,,,,4,,
   ,,,,6,4,4,12,,4,,,,4,,16,12,12,,4,4,4,12,16,12,,,,6,,,,
   ,5,,25,,19,,5,,,,,,5,,4,,,,,4,,15,,11,,4,14,14,12,13,,,
   5,6,,,,6,,35,14,,,5,,10,,,18,16,,,,,15,,,,,,12,11,,,,,5,,,,
   10,,,17,11,,10,5,5,13,20,16,,,,6,,31,,15,,5,,10,16,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,21,33,24,,5,3,4,34,52,34,,,,
   ,,,,,,,,,,44,52,45,,,,,,76,34,37,,,,,32,34,19,,,,,,,,,,4,3,
   37,45,19,5,33,21,24,76,44,32,,,,4,,5,,,5,5,,4,,5,,,,,4,
   19,19,,4,,14,14,,15,15,6,4,4,4,,4,4,,12,4,,,,,4,14,10,
   12,4,,4,4,14,14,16,,,,,,,6,,,,,,,5,,,,5,,,,,21,25,,,5,5,
   7,5,,7,,,,,4,,11,13,4,,14,14,14,,15,3,16,,,5,,,,,,,4,,,,
   4,,,,,,,16,,,5,,,,,,,4,,,,4,,,,,,,,5,,44,,,,,,5,21,,13,5,,
   10,10,15,16,26,5,4,,,,,,,4,17,,13,4,,14,14,23,19,,5,,6,,
   ,,,6,,18,,5,,,10,,31,15,16,5,,,,,10,23,20,18,10,,5,5,14,
   ,17,,,,,,15,,,,12,,11,,,,,,,,,6,,,16,5,,,10,17,27,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,44,32,76,5,,3,4,67,41,
   33,,,21,,46,48,,,,,24,,24,54,,,,33,,32,73,,,,,4,3,57,51,
   86,,,,,,5,53,57,34,33,27,32,,,,,4,,4,,4,,,4,4,,5,5,4,
   13,4,4,,13,4,13,13,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,
   5,5,,,4,4,4,13,4,13,4,4,,,13,13,4,,,,,,,,,,,,,,,,,,,,,,,4,
   4,,4,,4,,5,5,13,4,5,5,,4,13,13,13,,5,5,,,,4,,,5,,5,9,
   4,,31,,4,31,28,28,5,9,,4,4,,,4,,5,5,4,13,13,5,5,,,13,
   4,13,,,,,,,,,,,,,,,,,,,4,4,,,5,4,25,7,5,,25,4,13,13,14,,
   4,4,,,5,25,4,,4,14,4,25,13,13,,7,5,,5,15,4,4,5,9,13,
   5,5,,14,13,5,9,,,,,,,,,,,,,,,4,12,15,,4,14,13,11,,,14,,4,
   19,19,4,,14,15,15,,,14,4,,4,7,10,27,3,4,10,13,37,6,8,
   10,7,35,4,3,10,13,37,8,6,4,13,8,6,37,35,10,4,3,13,
   6,8,37,27,10,3,4,21,24,,10,,10,10,4,13,10,35,8,7,13,
   10,55,7,10,,10,35,27,,21,24,13,13,4,4,16,,,4,,,,4,,6,
   6,6,10,5,5,,10,6,10,10,,5,5,,4,,4,5,,5,5,5,,5,4,13,,
   4,4,13,4,13,13,4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,
   6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,
   ,5,5,,4,13,4,,4,13,4,13,13,4,4,,,4,4,,7,5,4,8,5,4,
   30,,4,,8,30,5,4,,,,,,,,,,,,,,,,,,4,6,,6,8,5,,4,4,5,8,5,
   5,5,7,5,5,7,,4,8,5,30,4,,4,,8,4,5,30,6,6,16,,5,5,,,
   14,,,,5,5,6,14,,,5,5,,12,,,5,,5,12,,5,,5,,14,,,5,5,,4,
   8,6,7,3,3,3,4,7,7,8,19,13,20,4,3,4,3,13,20,20,4,4,
   13,6,13,19,4,6,4,4,13,8,13,13,4,4,6,19,8,19,20,6,4,
   4,4,3,4,20,20,13,4,3,7,8,6,4,20,20,13,13,20,20,4,4,
   4,,,4,4,,5,,5,,,5,9,5,28,5,9,4,,31,28,,31,4,,,,,16,,,,,
   ,11,12,,,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,15,15,5,,24,
   15,15,28,28,,5,15,,4,,,,5,,,4,5,28,9,5,9,28,31,,4,31,,,
   ,,,,,,,,,,,,,,,,,4,,,6,6,22,9,6,,36,6,11,11,,,4,,,,,,,,,,,,,,
   ,,,,7,41,8,4,7,29,9,5,,,20,,5,39,,,,,,,,,,,,,,,6,23,19,,
   6,10,14,,,,,,5,,15,6,,10,17,23,,,,5,,5,49,49,41,4,5,12,,
   ,12,15,9,9,11,4,4,7,10,,8,11,6,8,9,48,20,16,,,4,8,
   10,73,17,14,,4,,13,69,48,38,,8,8,5,10,7,,7,8,,12,,10,
   11,31,,25,65,,28,59,,,4,,,,,,,,,,,,,,,,,,,,,,,4,4,5,5,,5,5,
   ,5,13,4,,5,5,4,13,13,13,5,,5,,5,,5,,5,,,4,,31,,4,9,
   5,28,31,5,28,9,5,5,5,,4,,,4,4,13,13,4,4,4,,,4,13,13,
   6,6,6,,,5,6,6,17,5,21,6,6,,,21,17,5,6,6,7,,7,5,21,,
   6,6,21,5,17,17,6,,6,6,7,,7,21,5,,6,6,5,21,17,17,6,,
   6,5,,,6,6,17,21,5,6,6,,,5,17,21,,4,15,15,14,4,,13,12,,
   ,,14,4,,,,,,,,,,,,,,11,13,14,,4,14,17,,,4,14,,4,24,6,7,
   3,4,10,13,8,55,7,21,8,8,4,3,10,13,9,35,8,13,13,45,
   34,,,10,,10,4,8,11,27,37,3,10,4,7,10,45,21,4,10,3,4,
   13,10,8,21,8,13,10,7,24,6,,21,,37,33,10,35,13,4,13,16,
   ,,5,,,,,,,4,,,,4,,,,,,,,,,16,,,,,15,,,,,11,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,6,,,,,5,,,,,,5,,,16,,25,,,,,,5,,21,19,5,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,57,51,
   34,3,5,,,24,46,32,51,57,86,5,3,,,24,21,33,,,41,27,,,,,,,
   67,33,,,,,,33,32,,,,,,4,,,32,44,76,,,54,48,73,,,,,,,,,,,,4,,,
   ,6,6,,10,6,5,,5,6,10,10,10,6,6,12,4,4,,,5,5,,13,4,5,
   ,5,4,13,13,13,5,5,,4,,4,,7,5,8,4,7,5,19,4,,,8,19,7,
   5,,4,6,,6,5,8,9,6,6,8,5,5,5,5,,5,,,,,,,,,,,,,,,,,5,7,,
   8,4,7,19,5,4,,,8,5,7,19,6,6,,18,6,6,,14,,,,,6,6,6,,
   14,,6,6,14,,,,6,,6,,14,6,,6,18,,,,6,6,,4,19,12,12,3,4,
   4,3,19,12,19,7,9,9,3,3,3,4,8,9,7,6,6,9,12,12,19,4,
   9,4,6,8,19,19,12,4,4,9,7,19,19,12,9,4,4,4,4,3,9,7,
   9,3,4,12,19,12,4,12,19,12,19,12,19,6,6,6,,,,,,,,,,,,,,,,,
   ,,,,4,,40,7,,4,8,5,,21,,5,,20,22,7,9,,,,,,,,,,,,,,,,,,,6,,
   ,50,6,,,4,6,17,11,11,6,9,,,,,,,,,,,,,,,,,6,,17,27,5,,,,16,
   ,,,6,10,,16,,,,5,31,15,,,6,,10,,,,,,,,,,,,,5,11,,9,4,4,7,
   10,8,9,16,13,,11,5,4,12,,44,29,53,,4,11,8,39,34,4,,8,,
   ,,,,,,,9,8,24,15,,4,8,5,,12,28,38,93,10,7,9,11,9,31,
   24,25,44,14,15,,6,8,8,4,4,,15,5,,4,4,5,13,9,5,5,,23,
   9,5,13,4,,5,,,4,15,7,,5,15,4,13,13,4,,14,,5,,,15,4,,
   14,4,4,15,13,13,5,7,,,,,,,,,,,,,,,,,4,,23,19,4,14,,17,13,,
   ,,4,14,,12,13,,14,4,15,11,,,4,,14,,,,,,,,,,,,,4,10,34,6,
   3,4,10,13,7,7,24,7,45,10,4,3,10,13,7,8,21,13,4,7,6,
   20,45,3,4,10,13,20,14,,,10,10,,6,7,14,34,4,3,10,4,13,
   10,10,7,45,13,10,6,10,34,,34,45,,24,21,,4,13,13,4,4,,,
   5,5,22,9,5,28,31,4,,9,31,,4,4,,,5,22,5,,4,31,4,31,,
   9,28,9,5,16,6,16,6,6,6,10,10,5,5,,12,10,6,10,,16,,,
   11,12,,,,,,,,15,5,,,,5,,19,31,,,,,5,16,14,5,,10,14,17,,
   17,10,5,,6,49,9,45,4,7,,8,20,30,8,49,9,17,7,4,,8,17,
   48,9,5,,11,15,,105,12,5,4,10,9,11,,15,7,4,4,15,34,,
   20,31,12,7,4,,8,24,9,8,,8,39,11,8,,,,,54,65,13,,10,5,
   4,6,,6,10,10,,5,5,10,10,6,6,5,,5,5,,,5,28,9,28,5,31,
   4,,9,4,,31,,6,18,175,10,6,,,13,19,,,,5,,,,,,,,,,,,,,22,,10,
   ,6,,15,31,,5,,,10,11,11,8,7,4,4,5,9,,8,38,16,19,31,
   7,8,,21,,28,8,8,48,16,63,41,8,,8,6,20,9,30,45,4,,,24,
   8,29,37,,,4,10,,8,24,,25,5,4,8,,7,5,8,,11,12,,12,,4,,
   5,,,28,5,,31,4,4,31,,9,5,9,28,,6,,16,,5,,14,,,27,,10,6,
   ,,,,,,,,,,,,,,21,,,5,16,,,22,6,10,,10,,24,13,7,31,8,,45,
   81,14,,9,9,4,7,4,5,10,13,9,,,,,,,,,,4,8,24,9,12,4,8,,
   6,25,10,8,,8,4,10,5,4,9,13,8,,8,20,48,24,5,48,69,29,
   74,67,48,8,6,8,5,16,15,16,5,10,,21,13,,17,,5,10,,,,,,
   5,25,19,,,5,,,,,11,,12,,,,,15,,,6,28,24,9,4,,,8,8,47,14,
   38,25,11,,4,,8,9,29,15,,5,11,9,,93,4,5,12,10,15,24,,
   44,7,12,31,8,8,,9,4,4,7,4,,8,11,13,34,,8,9,11,15,,,,,
   16,53,,5,10,,4,,,,4,,,,,,,,4,,,4,,,,,,,,4,,,57,51,,,,,,,67,
   33,51,57,,,,,,,41,27,4,,21,33,24,86,,5,3,,46,32,24,34,,
   3,5,,,,,,,,,,,,44,48,,,,76,73,,,34,54,,33,32,,,4,,,,,4,,,,,
   4,,,,,33,37,,,,,34,,76,,21,45,,,,,52,,44,,,,,,,,,,4,52,34,
   34,24,3,,5,44,32,76,19,5,,3,,,,21,,45,,,24,,34,,33,,37,
   34,,34,,4,,,32,,54,,,,,24,24,,44,,48,,,,,46,21,,,4,41,33,
   67,76,3,5,,,,,,,,,,27,32,33,73,5,3,,,,,57,51,,,,34,86,,,
   51,57,,32,33,,4,,,20,20,13,4,4,3,4,13,13,19,20,13,8,
   21,13,19,13,13,10,12,13,19,13,12,13,13,19,13,13,13,12,
   13,13,10,4,3,3,13,13,8,4,4,13,13,21,4,13,13,13,19,
   12,19,13,19,13,20,19,21,8,13,19,13,21,8,19,13,10,13,
   13,13,8,21,19,10,8,20,13,10,12,4,4,4,13,21,19,3,3,
   13,10,8,4,13,8,13,13,20,20,13,12,20,4,13,19,13,13,3,
   4,4,20,20,13,20,4,4,3,20,13,10,8,21,10,12,12,13,19,
   8,13,13,13,13,8,21,10,4,3,4,12,19,19,12,4,3,4,13,13,
   13,13,13,13,19,10,13,8,21,13,13,13,13,13,13,13,3,4,4,
   20,19,8,21,8,12,19,12,13,10,12,21,21,10,10,21,8,12,4,
   4,3,4,3,13,19,20,4,20,20,13,10,8,10,20,19,19,4,12,
   19,12,10,12,12,13,12,20,19,21,13,20,27,13,19,19,20,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,14,,,14,,,14,,,
   ,,14,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,14,,,
   14,14,14,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,12,12,
   12,12,12,12,12,12,12,12,12,12,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,12,12,12,12,12,12,
   12,12,12,12,12,12,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,40,40,,36,36,72,36,36,36,36,72,4,
   4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,
   ,8,12,8,,,,,,,,40,,,40,40,72,,36,40,36,72,,6,6,6,8,10,
   10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,
   ,,,,,,118,118,,,118,,118,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,
   6,8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,36,40,40,36,,,40,40,
   ,40,,40,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,
   ,8,,16,,16,,,,,,,,118,,,118,,,,118,,118,,,8,10,10,8,4,12,
   12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,
   68,,,68,68,174,,152,68,152,174,,4,6,8,4,6,6,4,6,6,,,6,
   6,8,,8,12,12,,,,4,6,,6,,8,,8,,,,,,,,36,36,36,36,72,40,
   36,,72,,40,36,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,
   8,,16,,16,,,,,,,,,118,118,,,,118,,,,,118,8,4,12,12,4,12,12,
   ,,12,12,8,,8,,,,,,4,12,,12,,8,,8,,,28,28,,,,152,174,174,
   152,,,68,174,,174,,68,6,16,16,6,16,16,,,16,16,10,,10,,,,,
   ,6,16,,16,,10,,10,,,,,,,,,,,,,,,,,,,,4,4,2,4,4,,,4,4,4,4,
   4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,12,12,12,12,12,12,12,
   12,12,12,12,12,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,
   6,,,,,,,,,,,,14,,,14,14,14,,,4,4,4,,,6,6,6,8,6,,,,,,4,6,,
   6,,6,8,6,,,,,,,,,,,,14,,,14,14,14,,,4,4,,,4,4,4,4,4,4,4,
   ,,,2,4,,4,,4,4,4,,,4,4,,,,12,12,12,12,12,12,12,12,12,
   12,12,12,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,14,,
   ,14,14,14,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,14,
   ,,14,14,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,14,,,
   14,,,14,,,,,14,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,14,,,14,,,
   14,,,,,14,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,16,16,,,16,,,,,16,
   ,,,,,,,4,,,,,,4,,,,,,,,,,48,48,,,,28,,,,,28,8,8,,,,4,6,,6,,
   4,,4,,,,,,,,,16,16,,,16,,,,,16,,4,,,,4,,,,,8,,8,,,,,,,,40,,,
   40,,,,48,,48,,,,,,4,,,,,8,,8,,,,,,,,40,,,40,,,,48,,48,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,4,,4,,4,4,4,,,4,4,,,,12,12,12,12,12,12,12,12,12,
   12,12,12,,4,,6,,6,,,8,8,,,,14,,,14,,,14,,,,,14,,,,,,,,,,,,,,,
   ,,,,,,,,,,,6,,6,,,8,8,,,,14,,,14,,,14,,,,,14,,,,,,,,,,,,,,,,,,,,
   ,,,,4,,,,,,,,,16,16,,,16,,,,,16,,,,,,,,,,,48,48,,,,28,,,,,28,,,
   ,,,,,,16,16,,,16,,,,,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,
   ,,28,48,,,28,,48,,,,,,,,,28,48,,,28,,48,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,12,,,,,,,,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,,,,,
   ,,12,,,,,,12,,12,,,,,,,,,3,6,6,9,,6,9,,12,,,6,6,6,6,6,
   9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,
   ,,,,,,,18,18,18,,18,,18,18,,18,18,6,6,9,,6,9,,12,,,6,6,
   6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,
   ,6,,6,,,,,,,,,18,18,18,,18,,18,18,,18,18,5,5,,4,7,10,7,
   12,,5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,5,,,3,4,5,,5,,,,
   ,,4,4,6,4,,5,6,5,,,5,5,,8,,13,,15,13,,17,11,6,16,16,
   6,13,5,,5,5,12,8,,,5,5,5,5,5,10,5,5,10,9,3,4,4,5,
   5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,17,11,15,,
   13,13,,15,6,11,6,17,,7,8,,7,,,10,10,10,10,10,10,10,10,
   10,16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,6,5,6,
   5,8,8,,,,,,,,,19,19,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,5,5,5,5,5,10,5,5,10,9,3,
   5,5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,
   13,16,6,13,17,,13,16,6,,16,13,,7,,,10,10,10,10,10,10,
   10,10,10,16,4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,
   ,10,,,,,,6,,,,5,,,19,17,,10,,5,,,,,,27,,,,,,,,,6,,,,,,,,6,,,,,
   ,,,,,,,7,,,,7,,,,,,,,,,,11,29,70,,87,,,,,,,,9,9,14,9,14,10,
   9,14,10,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,
   11,9,10,9,10,10,8,8,,,,,,8,,,,,8,16,,16,,,,,,18,,,,,,,6,,,,
   ,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,70,27,,,88,,,,11,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,6,7,7,
   3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,6,8,,,,,,
   8,,35,14,7,35,14,21,24,9,9,21,9,14,5,5,5,5,4,5,5,5,
   3,5,5,5,6,6,,,3,5,6,,6,,,,,,5,5,6,4,,8,6,8,6,6,,,,,,
   14,35,9,24,24,14,35,9,7,14,7,35,5,5,5,6,8,7,8,4,5,
   5,5,10,10,,,4,5,10,,10,,,,,,5,5,,6,9,7,,7,8,8,,,,,,55,
   55,13,,55,38,,8,9,54,9,64,5,5,5,5,5,5,3,5,5,5,6,6,
   9,,3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,,6,6,,14,,21,24,
   7,14,35,35,14,7,9,24,9,24,5,5,5,5,4,4,5,5,5,10,10,,
   ,4,5,10,,10,,,,,,5,5,9,6,,7,9,7,11,11,11,11,,9,,38,,
   13,55,,55,55,9,13,106,13,,7,7,6,7,4,6,6,6,12,12,7,,
   4,6,12,,12,,7,,,,6,6,7,4,10,6,7,6,10,10,8,8,,10,,101,
   60,9,90,90,101,60,8,8,148,8,60,5,5,7,3,5,5,5,6,6,6,
   ,3,5,6,,6,,6,,,,5,5,,4,,8,,8,,,,,,14,,14,14,9,21,14,
   24,21,9,7,35,7,14,5,8,4,5,5,5,10,10,9,,4,5,10,,10,,
   9,,,,5,5,,6,,7,,7,,,8,8,,12,,54,106,9,49,35,,38,13,13,,
   13,55,7,4,6,6,6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,8,
   6,7,6,8,8,10,10,,,,81,90,8,148,60,60,101,8,11,90,11,
   90,4,9,9,9,8,8,,,4,9,8,,8,,,,,,9,9,10,6,,8,10,8,,,,,,,
   ,64,,20,29,,38,38,10,20,29,20,,3,3,3,4,4,3,,2,3,4,,4,
   ,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,12,11,3,12,12,12,
   11,3,3,11,3,12,3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,
   4,4,5,5,,,,,,,13,17,17,13,13,,4,4,11,17,17,5,5,5,,,3,
   5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,13,17,17,13,13,,
   4,4,11,17,17,5,5,,,3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,
   5,5,,,,13,,17,13,17,,13,4,4,16,16,13,4,6,,4,5,4,,4,,6,
   ,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,6,,4,
   5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,
   ,5,,,3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,,,,36,,28,18,
   18,36,,5,5,16,28,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,
   4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,12,11,3,12,12,
   12,11,3,3,11,3,12,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,
   13,,17,13,17,,13,4,4,16,16,13,,4,,6,,,,5,5,6,4,6,5,6,
   5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,36,,28,
   18,18,36,,5,5,16,28,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,
   13,16,4,13,,17,11,17,16,,4,13,,4,,5,,5,,,5,5,,5,,13,
   16,4,13,,17,11,17,16,,4,13,4,,,3,,,,,,,5,,18,16,5,,36,
   18,16,28,28,,5,21,,4,4,4,6,6,6,6,,,,12,12,12,12,12,
   12,12,12,12,12,12,12,,,,,,,,,,,18,17,15,,,18,17,,,,19,,,3,
   5,5,,,,5,,17,11,5,,15,13,16,16,17,15,5,,,,,,,,5,,18,16,
   5,,36,18,16,28,28,,5,21,5,5,,,,5,,17,11,5,,15,13,16,
   16,17,15,5,,3,5,5,,,,25,47,9,21,47,56,15,,9,56,,13,5,
   5,,,,25,47,9,21,47,56,15,,9,56,,13,3,,,,47,15,,56,15,
   13,56,,9,25,9,47,,,,47,15,,56,15,13,56,,9,25,9,47,,,,,,,,
   ,,,,,,,,,,,18,18,,,23,15,17,,18,,,,,,,,,,,,,,60,13,,,,13,17,,
   49,,31,,,,,12,16,,46,,17,17,60,31,9,8,12,5,13,,,,49,59,,
   13,,13,,60,31,,13,,,17,13,,31,,16,12,,60,13,5,31,8,59,
   46,8,29,16,,17,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,
   12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,18,
   18,18,,18,,18,18,,18,18,5,5,,4,7,,7,,,5,5,5,5,5,10,5,
   5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,
   5,,6,,,,,,,16,,16,13,6,17,13,13,13,16,6,5,,5,5,,8,,12,
   5,5,5,5,5,10,5,5,10,9,5,3,5,5,5,6,5,5,4,5,5,,7,,,,,
   ,3,4,,5,,5,,7,,,,,,,8,11,6,13,15,,15,13,,17,17,11,6,,
   7,8,,7,,,10,10,10,10,10,10,10,10,10,16,7,4,7,5,5,4,,,
   5,6,6,,10,6,,,6,,4,5,,6,,6,,10,,6,,,,,,,5,17,,17,5,,,,,,
   10,12,,,,,,,18,,,,,,,,,,6,,,,,,,,,,,,7,,,,,6,,,,,,,,,7,,,,,,,,,,,
   ,88,,,70,27,11,5,,7,,10,5,5,5,5,5,10,5,5,10,9,4,3,
   4,4,4,4,,,5,5,5,5,5,,,6,8,,3,5,,5,,5,5,5,,,,6,,,,16,
   6,16,6,11,15,,13,13,13,,16,,7,,,10,10,10,10,10,10,10,
   10,10,16,5,4,5,7,7,4,8,8,7,10,10,,5,,,6,,,4,7,,10,,
   10,,5,,,,6,,,6,,10,,5,,,19,19,,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,14,9,14,10,9,14,10,11,7,
   6,7,7,7,6,10,10,9,8,8,8,9,10,,10,,,6,9,,8,,8,8,9,,
   10,,10,,,11,,16,,8,,8,,,,,,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,,6,,,,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,
   ,,,,,,87,11,70,29,,,,,5,5,4,5,5,4,6,7,7,5,3,5,5,5,4,,
   ,5,6,6,,8,6,,,14,,3,5,,6,,6,,8,,6,,,,,,35,7,24,9,21,
   9,14,21,14,14,14,7,5,5,5,5,4,5,5,5,5,3,5,5,5,4,,,
   5,6,6,6,8,9,,9,14,,3,5,,6,,6,6,8,,9,,9,,,8,24,9,35,
   7,14,7,35,14,24,21,24,9,5,5,5,6,8,7,8,5,4,5,5,5,6,,
   ,5,10,10,8,7,9,,,12,,4,5,,10,,10,8,7,,9,,,,,,,13,,13,
   38,9,35,49,55,54,106,13,5,5,5,5,5,5,5,3,5,5,5,4,6,
   6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,,6,,,,14,7,14,9,35,9,
   24,24,35,14,35,7,5,5,5,5,4,5,4,5,5,5,6,11,11,5,10,
   10,11,7,,,9,9,,4,5,,10,,10,11,7,,,,9,,,,55,13,55,9,55,
   13,,55,,38,,13,7,7,6,7,6,4,6,6,6,4,8,8,6,12,12,10,
   6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,8,90,9,60,8,101,8,
   60,148,90,81,90,11,5,5,7,5,3,5,5,5,4,,,5,6,6,,8,9,,
   6,8,,3,5,,6,,6,,8,,9,,6,,,14,21,9,21,9,24,7,14,35,14,
   35,14,9,5,8,5,4,5,5,5,6,8,8,5,10,10,,7,,,,,,4,5,,10,
   ,10,,7,,,,,,,9,54,9,38,8,,13,55,,64,55,55,9,7,6,4,6,
   6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,6,,12,,12,8,6,,7,
   ,7,,,10,148,8,101,8,60,9,90,90,60,101,60,8,9,4,9,9,
   9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,,,,29,20,38,
   10,38,20,,29,,64,,20,3,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,
   3,,5,,5,5,5,,4,,,,,,,4,16,16,11,4,,13,13,13,16,16,3,3,
   3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,3,3,,3,,3,,,3,
   11,3,11,3,11,3,12,12,12,12,11,3,4,4,4,,,3,5,5,5,5,4,
   ,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,16,16,11,4,,13,13,13,16,
   16,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,16,16,
   ,4,13,17,17,13,13,13,,4,4,,,5,5,5,5,3,,,4,,,3,5,,5,,
   5,5,3,,,,4,,,5,16,16,,4,13,17,17,13,13,13,,4,6,6,4,4,
   4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,12,12,12,12,12,
   12,12,12,12,12,12,12,3,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,
   ,,,,,56,,56,,15,9,47,21,13,25,47,9,5,5,5,5,5,,,,,,3,5,
   ,5,,5,5,5,,,,,,,,56,,56,,15,9,47,21,13,25,47,9,5,5,,4,,
   ,4,,,3,3,,5,,5,,4,,,,4,,,5,11,17,13,4,,17,13,17,17,,
   13,4,4,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,
   ,,,,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,
   ,,6,,,,,,,3,,,5,,5,3,,,,,,,,,25,9,13,,56,,15,56,47,47,15,
   9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,15,5,13,16,16,5,15,,,17,
   11,17,,4,,,3,,,6,,6,,4,,3,,4,,,5,16,28,30,5,,28,18,18,
   18,36,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,
   ,5,16,28,16,5,36,,21,18,16,28,,3,,,6,,6,,5,,,,5,,,,17,,
   ,23,,,18,18,18,,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,
   3,,3,,,3,11,3,11,3,11,3,12,12,12,12,11,3,,5,,5,,4,,,,
   4,,,5,11,17,13,4,,17,13,17,17,,13,4,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,5,5,
   ,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,25,9,13,,56,,15,56,47,
   47,15,9,,4,,,,,,15,5,13,16,16,5,15,,,17,11,17,,,,,,,,,,,,,,
   ,,,,,,4,,,5,16,28,30,5,,28,18,18,18,36,,5,,,,,,,,,,,,,,,,,,,
   ,,5,16,28,16,5,36,,21,18,16,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   19,17,,17,15,,,,18,17,,16,,31,,12,,,,,,46,31,8,60,5,13,
   13,17,49,46,8,16,,60,13,,,,,12,16,9,60,49,59,13,12,5,
   31,,,13,,,12,17,17,13,60,31,8,,,,,31,,13,,59,,,29,,17,16,
   8,8,,6,7,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,6,6,,,
   5,6,6,9,6,10,,,,,5,4,10,6,,6,,6,9,,,,,,,17,,,,17,22,14,
   22,,17,22,22,8,,8,8,,10,,,8,8,7,8,7,10,8,7,10,20,5,
   5,4,10,7,10,,,5,7,4,,7,,,,,,5,4,,10,,7,,10,,,,,,,,17,22,,
   ,17,,17,,22,17,22,22,11,7,4,11,7,6,6,8,8,6,8,6,9,8,
   6,9,8,5,5,4,6,4,6,,5,8,6,6,,6,8,,,12,8,8,4,8,6,12,
   4,,6,,,5,,12,8,8,6,8,6,6,8,8,6,8,8,8,6,6,,6,6,,,,,,
   11,,10,,,9,,16,,,5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,,6,,,,,
   49,,,,,,49,,,,,,8,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,
   6,6,,9,5,6,6,,6,,10,10,,,5,4,,6,,6,,6,,,9,,,,,17,22,
   22,22,14,,17,,22,17,,,6,7,11,11,8,8,6,8,6,9,8,6,9,8,
   8,8,4,6,6,6,,,5,4,6,5,4,,8,8,8,12,5,4,,6,8,6,,6,5,,
   ,,8,12,12,8,6,8,8,6,6,8,6,6,6,8,8,,,,,34,9,,13,,,9,,
   16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,,,,,,49,,,,,,49,,,,,,,,
   12,12,10,12,10,8,12,10,8,10,6,6,4,4,6,4,,7,6,6,4,7,
   6,10,10,10,,8,6,4,10,4,,6,,4,7,,7,,8,,,13,,,,6,,6,,,13,
   ,,6,,,9,,10,,,11,,16,,,5,,8,,,,,5,8,6,5,,,,,,,5,,,,8,,,6,,
   ,,,,,,,,,49,,,,,49,,,,,9,34,13,,,9,,16,,,5,,8,,,,,9,8,,9,,,,
   ,,,5,,,,8,,,,,,,,,,,,,,49,,,,,49,,,5,5,8,7,7,8,4,9,9,5,
   5,4,10,7,10,,,5,7,4,12,7,8,,,,,5,4,8,10,,7,,10,12,,,,,,
   ,11,14,30,30,16,15,9,15,14,16,14,14,5,5,5,8,8,7,7,
   7,5,5,4,10,7,10,,,5,7,4,12,7,9,,,,,5,4,9,10,,7,,10,
   12,,,,,,,9,30,30,30,9,14,11,14,30,16,30,30,7,4,7,4,5,
   7,5,5,5,3,5,6,5,,,5,6,6,9,6,6,,,11,10,5,3,6,5,11,6,
   ,5,9,,,,10,11,11,7,8,8,8,7,9,7,9,8,7,8,8,5,7,5,5,
   8,7,5,5,4,10,7,10,,12,5,7,4,,7,,9,9,,,5,4,,10,,7,,10,
   ,,12,,,,,16,30,14,14,11,30,9,30,30,9,30,30,7,7,4,7,6,
   5,5,3,5,6,5,,6,5,6,6,6,6,,,,10,8,5,3,,5,10,6,,5,6,,
   6,,8,10,10,7,8,8,8,7,8,7,8,8,7,8,8,9,7,10,9,8,8,
   6,8,9,8,,10,8,9,6,10,9,11,10,10,,,8,6,11,8,,9,,8,10,
   ,10,,,,,11,,,,11,42,12,42,,10,,,5,7,9,5,5,4,10,7,10,,
   12,5,7,4,,7,,8,8,,,5,4,,10,,7,,10,,,12,,,,,16,14,15,15,
   9,30,16,30,14,11,14,14,7,5,5,5,3,5,6,5,,9,5,6,6,,6,
   ,6,6,11,10,5,3,,5,11,6,,5,,,9,,10,11,11,7,8,9,9,7,
   8,7,8,8,7,8,8,9,8,8,6,8,9,8,,10,8,9,6,10,9,10,11,
   11,,,8,6,10,8,,9,,8,10,,10,,,,,10,,42,42,12,,11,,,11,,,
   10,10,4,9,6,9,,,10,6,4,,6,9,9,9,17,12,10,4,9,9,17,6,
   ,9,,,,,12,17,17,8,10,12,12,8,12,8,12,10,8,10,10,3,3,
   5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,
   17,17,4,5,,5,5,4,17,17,3,5,5,5,,,3,4,4,4,4,5,,,7,,
   3,3,5,5,7,5,,5,4,,,,4,,,,5,17,17,4,5,,5,5,4,17,17,4,
   3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,3,4,6,3,,4,3,,3,,
   4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,,6,5,5,4,6,5,
   5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,5,,,
   4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,5,4,,,,6,9,9,5,5,7,
   7,5,5,5,5,5,5,7,7,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,4,4,4,4,4,,,,9,,4,3,,6,9,,,6,4,,3,,6,,,31,6,,,4,
   6,31,6,6,5,9,9,5,4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,,7,
   7,4,17,5,5,,17,4,17,17,,5,5,4,,3,5,,,9,6,5,3,5,5,9,
   3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,4,4,6,6,
   6,6,,4,2,6,4,6,4,,4,4,,4,,,6,6,12,4,4,4,12,4,12,4,
   4,12,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,9,9,5,9,6,6,31,,4,
   ,9,31,6,6,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,
   5,5,7,5,7,7,5,5,5,5,5,23,8,,3,3,5,23,,,5,,,,,,9,9,
   6,11,7,7,,11,6,11,11,,7,7,3,9,,5,3,5,5,9,5,,5,,,,,8,
   23,23,,7,11,11,6,7,,7,7,6,11,11,9,,5,3,5,5,9,5,,5,,,,
   ,8,23,23,,7,11,11,6,7,,7,7,6,11,11,8,,6,23,,6,8,,,,,
   9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,,,16,6,,6,
   6,16,,,3,,5,,4,,5,,,4,,,7,7,4,17,5,5,,17,4,17,17,,5,
   5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,
   5,23,,,5,,,,,,9,9,6,11,7,7,,11,6,11,11,,7,7,,5,,4,6,,
   6,,6,,,5,,,,5,,5,,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,5,4,,,,6,
   9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,,6,,6,,6,
   ,,5,,,,5,,5,,,5,,,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,,,,,
   ,,,,,,,,,,,,,,6,,,31,6,,,4,6,31,6,6,5,9,9,,,,,,,,,,,,,,,,8,
   8,16,,6,6,,,16,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,7,,,5,20,
   20,9,5,6,5,5,9,20,20,,,20,8,5,8,4,20,,,4,5,,20,,,5,
   8,8,5,,20,,,5,8,8,20,8,20,20,6,5,5,5,4,8,20,,,5,5,
   9,20,20,8,20,,,20,,,5,5,4,3,,4,4,5,4,,,4,4,6,4,6,9,
   4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,
   7,,,,,,16,16,,,,16,16,16,16,4,4,4,,4,4,5,4,,,4,4,6,4,
   6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,
   ,7,,7,,,,,,16,16,,,,16,16,16,16,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,4,4,
   4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,
   4,4,,,,12,12,12,12,12,12,12,12,12,12,12,12,,3,5,,6,6,
   7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,
   ,4,,9,,6,8,,,7,,,,,,16,16,16,4,4,4,,16,16,16,,,,,8,,8,,,
   ,11,,11,5,,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,6,8,,13,
   14,7,,,,56,56,17,17,17,9,9,15,35,,,,5,,6,6,7,6,7,6,6,
   7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,
   ,7,,,,,,16,16,16,4,4,4,,16,16,16,,8,,,8,11,14,,8,7,11,
   5,,,5,5,,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,,,,,17,
   17,56,56,35,,,,17,15,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,4,5,5,
   9,7,8,7,,15,,4,5,,5,,7,,7,11,11,8,,,13,,34,23,14,34,
   21,7,7,9,14,7,9,6,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,,
   4,5,5,7,7,8,,,,,4,5,11,5,,7,8,7,,,,,,,,14,34,34,23,14,
   7,9,7,23,9,6,9,5,4,5,4,8,6,8,4,5,6,4,6,6,,,5,6,
   12,11,7,13,,,,,4,6,,6,,7,,12,,14,,,,,,,31,,31,34,10,7,7,
   32,7,7,9,4,5,4,4,4,7,4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,
   5,,5,,7,8,7,11,,7,7,,,,21,14,23,14,34,9,6,7,34,6,9,
   7,5,5,4,5,8,4,5,6,4,6,6,,,5,6,12,,7,,,,,,4,6,14,6,,
   7,13,12,20,18,14,14,,,,34,,31,32,,7,9,10,31,7,9,7,7,
   6,8,7,4,10,8,4,8,8,,,10,8,7,18,7,,,,,,4,8,19,8,,7,
   12,7,13,,12,11,,14,,36,,,28,36,8,9,7,28,8,8,10,4,5,7,
   4,4,5,4,5,5,,,4,5,5,,7,7,7,,13,,4,5,,5,,7,,7,,11,,9,
   ,15,,14,21,14,21,23,6,9,9,14,9,7,8,5,8,4,5,6,4,6,6,
   ,,5,6,12,,7,14,14,,,,4,6,18,6,,7,,12,,,14,16,,,,34,64,
   32,34,57,9,7,7,,9,7,10,7,4,10,8,4,8,8,,,10,8,7,,7,
   12,11,,14,,4,8,,8,,7,,7,18,,16,12,,,,53,32,28,80,,9,9,
   8,,9,9,8,6,9,11,6,11,8,,,9,11,10,,10,,,,16,,6,11,,8,,
   10,,10,,,,21,,16,,,,,,,10,9,7,,9,9,10,4,4,2,4,4,,,3,3,
   4,4,4,4,4,,5,,2,3,5,3,,4,4,4,5,5,4,4,,5,,12,11,11,
   12,11,4,11,4,11,4,4,11,4,4,4,4,,,4,5,5,5,5,6,,,8,,
   3,4,6,5,,5,5,5,6,6,,,,,,,16,,16,12,6,16,5,12,5,16,6,
   4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,5,6,6,,,,,,16,
   16,,,12,16,14,5,12,3,4,4,4,4,,,4,4,4,4,4,4,4,,,,2,4,
   5,4,,4,4,4,5,,4,4,,,,11,12,12,11,11,11,4,4,11,4,11,
   4,4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,,,
   16,16,12,4,4,3,12,5,16,14,,,5,4,5,6,5,,5,,,,3,5,6,4,
   ,5,6,5,6,8,6,8,,8,,16,,16,,12,16,6,5,12,5,6,16,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,12,,15,12,,16,5,6,
   16,16,6,5,5,,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,12,15,,
   12,,16,5,16,16,4,4,3,,4,7,7,,6,,4,5,,5,,4,,4,8,7,8,
   7,,6,,,14,14,,,4,13,6,,13,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,
   ,,6,,24,35,33,,,,7,12,42,9,5,6,7,7,,8,,4,5,,5,,4,,4,
   8,7,7,8,,6,,,14,14,,,5,7,7,,5,4,5,4,,47,,4,8,8,6,,7,
   9,7,,6,9,8,,12,,29,,42,27,,11,6,7,,9,9,,,28,,4,6,8,8,
   ,7,8,7,,5,,,,,,29,42,,27,,12,,7,,6,9,5,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,5,,7,8,,6,10,6,,,10,10,,,,20,,,,,,7,7,20,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,5,4,4,,5,,11,11,11,11,
   12,4,4,11,12,11,4,4,8,4,,5,,5,8,,6,6,,,,12,,15,12,16,
   4,3,4,,16,16,5,8,,,6,,,11,,9,,11,,,25,25,35,56,5,7,15,,
   ,7,,,5,,5,,,6,6,,,,12,15,,12,16,6,5,16,,6,16,5,,,,,,,,,,,
   ,,,,,,,,,,,,,4,7,7,,7,,8,,,14,14,,,4,5,5,,7,5,7,,8,,9,,,,
   ,24,35,33,,42,6,7,11,,9,,10,7,7,7,,,6,,,14,14,,,4,6,
   13,,6,4,13,,8,8,,,,25,35,,25,,11,8,,55,15,7,5,8,8,,,,
   21,,56,21,,15,5,7,,11,,7,4,,,,,,,42,19,7,11,6,20,10,9,
   9,,,,42,,,,19,7,12,,20,5,6,9,,,,,,,,,,,,,,,,,,,20,20,,,,,7,,
   7,,,,,,,,,,,,,,,12,,12,16,12,,44,37,60,12,,,16,12,12,,44,
   60,27,,,60,27,44,,12,16,12,,37,60,44,,12,12,16,27,25,
   60,12,16,12,12,4,4,12,8,12,8,5,12,9,8,12,16,12,8,9,
   60,27,25,4,5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,4,
   4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,16,16,,
   ,,16,16,16,16,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,
   6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,16,16,16,
   ,,,4,16,16,16,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,
   6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,16,16,16,
   ,,,4,16,16,16,,,,,8,11,8,,,,,,11,8,,5,6,9,,8,6,5,5,8,,
   6,,,7,,,,,9,6,,8,,8,,,,,,,,15,9,17,17,17,56,35,56,9,,,,,,
   4,4,6,4,6,4,4,6,4,6,4,4,4,4,4,4,6,6,4,4,6,,4,,,6,,
   ,4,4,6,4,,4,,6,6,6,,,,,,12,12,12,12,12,12,12,12,12,
   12,12,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   ,8,,,,11,,11,,5,,6,5,6,,,,9,8,,8,,,9,,,8,5,7,,,6,,8,6,
   8,,,,,,,,56,56,35,17,17,17,,15,9,9,4,4,4,5,5,4,4,7,7,
   4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,7,5,15,7,,10,,9,,,,,,
   9,6,23,34,14,21,14,14,9,9,7,7,4,4,4,4,4,5,5,7,4,4,
   5,4,5,5,,8,4,5,5,,7,,,7,,,4,5,9,5,,7,,10,8,7,,,15,,
   13,7,9,34,14,23,14,34,21,6,7,7,9,5,4,5,4,8,6,8,5,
   4,6,5,6,12,,,4,6,6,,7,,,,,,5,6,16,12,16,7,,7,,11,,,16,,
   ,7,9,31,,32,34,,34,7,7,10,10,4,5,4,4,4,7,4,4,5,4,
   5,5,7,8,4,5,5,,7,,,9,,15,4,5,7,5,13,7,,10,8,,,,,,,7,
   7,14,21,34,34,23,14,9,7,9,6,5,5,4,5,8,5,4,6,5,6,12,
   ,13,4,6,6,,7,,,11,,,5,6,11,12,14,7,,7,13,,,,,,14,10,7,
   ,34,31,,31,34,9,10,7,9,7,6,8,7,10,4,8,10,8,7,,,4,8,
   8,,7,,,18,,,10,8,11,7,,7,,8,12,18,,,,,16,8,9,,36,28,36,
   ,53,9,7,8,12,4,5,7,4,4,5,4,5,5,9,,4,5,5,,7,,,7,,,
   4,5,,5,,7,,10,,,,,,,15,9,7,21,14,14,23,14,34,7,9,6,9,
   5,8,5,4,6,5,6,12,11,,4,6,6,,7,,,16,,16,5,6,,12,,7,,7,
   ,,,,,,16,7,10,34,34,,31,32,,10,7,9,7,7,10,4,8,10,8,7,
   18,12,4,8,8,,7,,,11,,,10,8,18,7,16,7,,8,,,,,,,,7,8,36,
   53,,,28,36,12,8,9,9,9,6,11,9,11,10,,,6,11,8,,10,,,26,,
   15,9,11,26,10,16,10,,10,,,,,15,,16,7,10,,,,,,,9,7,10,9,
   4,4,4,5,5,,,3,4,5,,5,,,,,,4,4,,6,8,7,,7,5,5,,,7,,,16,
   5,15,,12,12,,15,6,5,6,16,4,4,4,4,4,4,2,4,4,,4,,,4,,,
   3,3,4,4,5,4,,4,4,4,,,5,,5,11,4,12,11,11,11,12,11,4,
   4,11,4,5,4,5,,,3,5,4,,5,,,,,,4,4,6,7,,6,,7,6,6,,,4,,,
   16,5,,,12,12,15,15,16,3,4,4,4,5,,6,4,4,4,,5,,,5,,8,
   4,5,5,5,7,5,,4,6,,,,8,,7,6,16,,12,16,,16,12,5,6,16,
   5,5,6,,4,4,4,,5,,,6,,,4,5,6,5,4,5,,4,5,,,,,,7,4,4,
   16,12,16,,,12,3,16,14,5,7,7,4,5,5,,4,,,,,6,6,7,7,6,
   8,6,,7,,,,,8,,,4,13,14,,,,14,,6,6,4,13,4,4,,5,,7,,,,,
   28,5,6,,,10,,,8,9,,,,6,,,12,,,,27,29,42,29,7,5,9,6,4,5,
   ,,7,,,,,47,5,6,,,10,,,8,8,9,,,,,,11,6,42,,27,29,,29,7,
   10,7,10,4,4,,4,,,4,,5,4,4,4,4,5,4,,4,4,4,,,,,5,4,11,
   11,11,12,12,11,11,4,11,4,4,4,,5,,,6,,,5,4,6,5,7,5,,4,
   ,6,,,,,4,16,14,,12,,16,16,12,5,4,4,3,,5,,,6,,,5,4,6,
   5,7,5,,4,,5,,,,,7,16,6,16,12,,16,,12,5,16,6,5,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,6,14,6,,7,,,,,9,,9,5,7,
   14,,,,14,,7,5,4,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,6,7,7,30,7,,7,,,,,,,,,7,33,,,24,35,41,11,6,
   5,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,,8,9,9,,8,,6,,,,,,,7,,,,
   20,,20,7,,,,4,,5,,5,,7,,,,,,,8,5,6,12,15,,15,12,,16,16,
   5,6,,5,,5,,7,,,,,,,,3,4,12,15,15,,12,,4,16,5,16,,,,,7,,,,
   ,,,30,6,5,29,41,35,33,,,9,,7,11,,4,,7,7,7,,,6,,8,6,4,,
   ,14,14,,,13,4,13,6,9,,,,,,,,,,7,7,,,,20,20,,,,,,,7,7,7,,,
   8,,14,5,4,,,14,14,,,5,5,7,7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,
   6,6,13,,13,13,13,,,6,6,,4,,,47,,10,10,7,29,29,,42,27,,
   10,11,6,7,,,28,,10,5,9,29,29,42,,27,,6,12,,7,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,9,,,20,20,,,,,,,7,7,,,,,,,,,,,,,,,,20,,20,,,,
   ,7,7,,4,60,27,37,12,16,12,5,9,10,8,27,25,60,16,12,
   12,4,10,8,7,,,,12,,25,12,16,12,,,,,56,12,12,16,12,,,27,
   16,12,12,,,12,60,27,25,,12,37,60,27,16,27,25,56,8,7,9,
   4,5,4,5,6,6,5,,,,,10,,10,13,17,9,,8,,,8,,6,,,5,,8,,,
   12,5,,,,,9,6,,,,8,10,,,10,9,,,,,41,41,,,,41,41,41,41,5,
   5,5,4,,3,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,
   6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,16,16,4,4,4,16,16,
   16,16,,,,6,4,6,6,4,4,4,4,4,8,4,4,8,4,4,4,4,4,4,4,,
   6,4,4,4,,6,,,,6,6,4,4,,4,6,6,,4,6,,,,6,6,6,4,4,4,4,
   4,4,4,4,4,4,4,4,,,,,,9,,10,,,9,,16,9,,8,,6,,,,,8,,,12,
   10,,,,,,6,5,,,8,,,,10,,,,,,41,41,5,5,5,41,41,41,41,,,,,,
   6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,
   4,4,,4,,6,7,6,,,7,,,,,16,16,4,4,4,16,16,16,16,,,,3,,,
   6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,
   ,,,,30,30,30,,,,,30,30,30,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,
   6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,5,
   5,4,7,7,4,6,7,7,5,5,6,5,4,8,,,5,6,8,,9,10,,,20,,5,
   4,11,8,20,6,11,10,,10,,,,,,10,9,12,13,16,9,10,16,16,
   10,10,15,5,5,5,4,4,7,7,6,5,5,6,5,4,8,,,5,6,8,,9,,,,,
   ,5,4,10,8,,6,10,10,,13,,,,,,10,10,13,12,12,10,10,9,9,
   10,15,13,7,6,7,6,4,5,4,7,7,6,7,4,7,,,7,6,7,,12,8,,,
   10,10,7,4,6,7,10,4,6,6,16,9,,,8,9,9,6,7,7,7,7,7,6,
   7,7,6,7,7,5,7,5,5,4,6,5,5,6,5,4,8,,10,5,6,8,,9,,,,
   ,20,5,4,13,8,20,6,,10,12,,13,,,,,9,10,12,16,13,10,9,
   10,10,15,13,15,7,7,6,7,8,7,7,6,7,4,7,,8,7,6,7,,12,,,
   ,10,10,7,4,9,7,9,4,8,6,14,7,7,,6,8,9,7,6,7,7,7,6,
   7,7,7,7,7,7,7,5,4,7,7,7,6,7,7,8,,10,7,6,8,,9,10,,,,
   ,7,7,10,8,,6,11,8,,,,,,15,15,22,22,,24,24,22,22,10,10,
   9,15,14,5,7,7,5,5,6,5,4,8,,11,5,6,8,,9,13,,,20,,5,4,
   ,8,,6,,10,,7,11,,,,,16,9,16,16,12,9,16,10,10,13,15,10,
   7,4,7,7,6,7,4,7,,6,7,6,7,,12,7,,,9,10,7,4,7,7,9,4,
   ,6,,,9,,8,6,8,7,7,7,6,7,7,7,6,6,7,7,7,7,7,7,6,7,
   7,8,,11,7,6,8,,9,,,,,,7,7,,8,,6,10,8,,13,13,,,,,10,22,
   24,10,,22,10,22,22,15,14,15,8,8,8,8,4,7,,8,8,8,7,,
   18,8,,,10,9,8,4,8,7,10,4,8,7,,,,,9,12,11,7,7,8,11,8,
   7,7,7,7,11,8,8,5,5,4,4,4,,,4,6,8,,8,5,,,5,,4,3,5,
   4,5,4,4,4,6,4,,,8,,,,4,15,16,6,4,,4,4,15,6,16,5,4,
   4,4,,,4,5,5,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,,,,,4,
   16,15,6,4,,4,4,15,16,6,5,4,5,,5,6,6,6,,6,6,,,8,8,6,
   4,6,5,8,4,5,5,,5,5,,6,5,5,6,6,5,5,6,6,6,6,6,6,5,
   5,4,5,,5,5,5,4,,8,,,,,5,4,4,4,4,5,3,5,4,6,,4,,8,,8,
   4,,16,6,15,,4,4,4,6,16,15,4,,,4,4,4,,6,,,,6,6,3,3,3,
   3,4,3,3,3,5,4,4,,6,6,6,4,4,4,4,4,4,4,3,3,4,4,4,,
   5,8,6,4,,8,,,,,5,4,4,4,4,5,3,5,4,6,,4,,,8,,4,,6,16,
   15,,4,4,4,6,15,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,6,,,
   8,,,,7,,4,3,5,4,5,4,4,4,6,5,5,,,,,31,5,,,8,5,31,4,4,
   7,7,8,5,4,,8,,,,,5,4,4,4,4,5,3,5,4,7,7,4,,,8,,4,,
   15,6,16,,4,4,4,16,6,15,5,,6,5,,,8,8,5,4,5,5,8,4,6,
   6,,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,5,5,6,,8,5,,,5,,4,
   3,5,4,5,4,4,4,7,4,7,,,,8,,4,6,15,16,4,,4,4,16,15,6,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,8,6,8,8,12,6,8,8,,
   8,8,,8,8,8,9,9,8,8,8,9,9,9,9,8,8,8,,,,7,4,4,4,4,
   5,3,5,4,7,6,5,,,12,12,5,31,,8,,31,5,4,4,8,8,8,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,5,6,
   4,7,5,9,,5,,,,,5,,,,,,5,5,5,,,,5,4,7,5,6,6,5,5,9,5,,,,
   ,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,8,4,4,6,15,16,4,
   4,,,16,15,6,4,4,6,3,,4,6,,3,,6,6,6,3,4,4,4,4,4,3,
   4,4,4,4,4,,,,6,,,5,,,,,,5,4,8,8,8,4,5,31,31,,,8,,4,,5,
   ,5,5,,,,,4,4,16,15,6,4,4,,,15,16,6,6,,,,7,7,,,,,5,5,,,
   ,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,3,4,4,4,6,6,6,,
   ,,5,,,,,4,5,8,,,5,4,31,31,8,8,8,,5,5,,8,,,4,4,15,16,
   6,4,4,,,15,6,16,7,7,,113,30,36,7,7,16,21,31,7,7,,,31,
   16,26,4,,,,12,4,31,8,8,7,31,4,5,5,,,,,12,,,31,4,,,,4,
   31,5,5,7,8,8,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,,
   6,,,,,6,,,,,,6,,4,21,21,21,4,3,4,4,13,21,21,21,21,21,
   3,4,4,4,21,21,21,5,5,21,21,21,21,4,4,4,8,21,21,13,
   13,4,4,4,21,21,21,21,4,4,4,4,4,4,21,21,21,4,4,13,
   21,21,3,21,21,21,21,21,21,5,8,5,,,5,,,,8,8,,11,7,8,,
   14,11,,8,5,5,9,6,8,6,,5,8,,6,9,9,,,,5,,,,,8,,6,,,,8,,,
   ,15,9,,,,56,35,56,9,17,17,17,3,,,,,9,6,,9,,,6,,9,,,6,
   6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,
   30,30,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,
   ,,9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,,,,9,11,,,8,10,,8,
   10,,6,5,6,,5,8,,,5,8,,6,,8,,,,8,9,,,,8,10,8,10,11,11,
   10,,,,56,56,,,,9,9,15,65,17,17,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   9,9,,,10,,10,7,13,,8,,,13,,,8,,,141,141,9,12,11,,,,,,26,
   15,,,,,,,55,,,,,55,19,26,12,8,11,,6,,7,7,9,7,,,8,14,8,
   15,,,,8,,,9,9,,,135,,14,8,,,,10,,,,21,,,,,,20,32,,,,56,32,
   75,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,7,,
   14,8,,8,,,9,,8,15,,9,,,,,135,15,8,17,,,10,13,,26,16,18,
   23,,,,56,32,,,,20,32,37,20,,8,,10,8,,10,,10,12,10,,15,,,,
   12,15,,,,,,,,11,10,17,,140,12,18,12,19,16,14,19,,,,32,30,,
   ,,32,30,,34,8,12,13,,,10,,13,,13,10,21,20,10,,22,15,,
   15,10,,,94,,,,,,,,,,,,,,,,,,119,,,,,,41,103,23,10,12,9,7,,
   12,7,12,7,,14,10,,7,,,11,9,,,,,,7,13,,,8,,,,,,24,,,,81,35,
   ,,,29,35,23,29,,11,11,,,15,16,17,,15,,11,,18,11,,,11,19,,
   ,,17,18,,,143,16,,21,26,27,,,,,,40,111,,,,,92,,247,18,26,
   11,,,10,,11,16,,9,,10,,,10,8,,,,,,11,,,,10,13,,,,,,,,,68,69,
   ,,,84,97,47,84,10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,5,5,6,5,5,,6,6,,6,5,,,24,,6,5,4,,71,,,,8,7,,,,,,
   63,10,,,,17,57,58,51,5,17,7,6,5,6,,4,,6,6,,6,5,,,16,,
   6,5,,,,4,4,,8,7,5,,,,,39,10,,,,10,39,39,39,4,5,5,5,6,,
   5,,,6,,6,5,5,,,24,,,6,,68,6,7,6,,,7,8,,,,17,57,,,,63,
   10,44,33,7,17,5,,7,,,5,,,6,,7,,,,5,5,6,,14,5,6,5,8,8,
   8,8,,,,29,29,,,,29,29,9,9,,5,,8,5,,6,,,,,8,,,71,6,5,7,,
   14,6,7,5,10,9,7,9,,,,44,63,,,,57,33,17,10,7,5,17,5,,,
   8,,8,7,,,,34,,,6,,,,,,,,,,,,,17,,,,,31,49,,,7,11,7,,5,,,5,,
   7,,19,44,5,4,6,,13,4,4,4,8,7,6,6,,,,31,11,,,,11,37,9,
   9,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,4,,,,16,,6,7,,,
   6,7,6,,,7,8,,,,10,39,,,,39,10,39,39,5,5,4,,,5,8,,71,,
   6,5,7,,28,6,7,6,9,7,9,10,,,,57,33,,,,44,63,10,11,17,
   5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,,,6,5,7,,18,6,7,6,
   10,7,7,10,,,,51,51,,,,51,51,11,11,5,4,5,5,,44,19,4,5,
   5,,14,5,6,5,6,7,7,8,,,,11,37,,,,31,11,9,9,6,6,,,34,,,
   6,,,,,,,,,,,,,,31,49,,,,17,,,,7,11,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,71,,33,,,16,23,16,,,17,23,,,,44,,,,,,71,71,25,,,,28,14,,,,
   ,,68,31,29,,,,,,,71,,,,44,,44,68,,,,,,,,6,,6,,5,7,8,,,,17,
   58,,,,44,10,63,56,17,7,5,5,,,5,,5,,,6,7,,,,9,29,,,,29,
   9,29,29,,,5,,,,,,,,,,,,,64,13,,,,23,58,,,,22,7,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,71,68,,,,44,44,,,,,,4,,8,7,,,,,,40,10,,,,10,
   40,40,40,6,10,10,,,,5,,,,,40,13,,,,13,40,,,,10,10,8,7,,,,,
   ,58,17,,,,10,51,63,57,5,7,17,,9,10,,,,19,,,,,,15,,74,20,
   9,6,8,9,,,,18,,,,,,11,70,65,,,7,,,,,,11,,,,11,,49,49,7,,,,,
   ,,19,,,,14,,,77,6,9,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,29,
   ,,,19,41,19,40,18,18,31,,,,41,17,19,29,52,14,18,,,,,,,,,,,
   ,,,,,,,,,,,,,,29,29,19,31,18,14,40,15,24,15,19,41,18,31,
   18,14,23,15,5,5,5,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,
   4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,16,
   16,16,,,,4,16,16,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,
   7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,16,16,4,4,4,16,16,16,
   16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,11,
   8,,,,,,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,,6,7,8,,
   ,8,6,,,,,,9,15,9,17,17,17,,56,56,35,4,4,4,5,5,4,4,7,
   7,4,4,5,4,5,5,11,,4,5,5,,7,7,7,,15,,4,5,,5,,7,9,7,,,
   ,,,13,,9,7,6,9,9,14,23,21,7,14,21,14,4,4,4,4,4,5,5,
   7,4,4,5,4,5,5,,11,4,5,5,7,7,,,,,,4,5,,5,,7,7,7,,,,8,,
   ,,6,9,9,7,6,23,34,14,7,21,14,34,5,4,5,4,8,6,8,4,5,
   6,4,6,6,,,5,6,12,14,7,14,14,18,,,4,6,,6,,7,16,12,,,,,,,
   ,9,7,9,7,7,32,57,34,10,34,64,,4,5,4,4,4,7,4,4,5,4,
   5,5,,,4,5,5,,7,,8,11,,,4,5,,5,,7,,7,,,7,8,,,,9,6,7,7,
   9,34,14,23,9,14,34,23,5,5,4,5,8,4,5,6,4,6,6,18,20,
   5,6,12,14,7,,,14,,,4,6,,6,,7,14,12,,,,13,,,,7,9,7,10,
   9,57,,32,7,34,,31,7,6,8,7,4,10,8,4,8,8,,18,10,8,7,
   16,7,11,12,,,,4,8,,8,,7,12,7,,,,,,14,,9,9,9,8,9,28,,
   80,8,53,32,,4,5,7,4,4,5,4,5,5,11,11,4,5,5,8,7,7,8,
   ,13,,4,5,,5,,7,,7,,,9,,,15,,7,9,7,9,7,14,21,34,6,34,
   23,14,5,8,4,5,6,4,6,6,14,,5,6,12,,7,,13,,,,4,6,,6,,7,
   ,12,,,11,,,,,7,7,10,7,7,,34,31,9,,31,32,7,4,10,8,4,8,
   8,,13,10,8,7,12,7,,,19,14,,4,8,,8,,7,11,7,,,18,12,,,,
   8,8,8,7,9,,36,28,10,36,,28,6,9,11,6,11,8,,,9,11,10,,
   10,,,,16,,6,11,,8,,10,21,10,,,,,,16,,9,9,10,7,9,,,,10,,,,
   4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,4,,,4,4,
   ,5,,11,4,4,11,4,11,12,11,4,11,11,12,4,4,4,4,,,4,5,
   5,5,5,,,6,8,,3,4,,5,,5,5,5,,,,6,,,,16,6,16,6,5,15,,
   12,5,12,,16,4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,,5,,5,6,
   5,,,6,,,,,16,16,4,4,3,15,16,12,5,12,,,4,4,,5,4,4,4,4,
   4,4,4,5,,,2,4,,4,,4,4,4,,,4,4,,,,4,11,11,4,4,12,11,
   11,4,11,12,11,4,8,,5,4,5,6,5,,,6,,,3,5,,4,,5,6,5,,,,
   5,,,,4,4,16,16,5,,,12,3,12,15,16,,,5,4,5,6,5,8,6,8,,,
   3,5,,4,,5,6,5,,,5,,,8,,6,16,6,16,5,,16,12,5,12,15,,,
   6,8,7,8,7,5,6,11,,,5,6,,8,,7,8,7,,,9,,,,,11,,15,7,5,
   56,,25,7,25,,,6,6,8,8,7,,,,,,5,6,,6,,8,8,7,,,9,8,,,,
   15,7,11,,8,,,25,5,25,35,55,4,5,,5,,6,6,,,4,4,,4,,5,,5,
   ,,5,5,,8,,5,16,6,5,16,,12,16,6,,16,12,5,8,5,6,,6,,,
   4,4,,4,,5,6,5,,,6,6,,,,5,16,4,3,4,16,12,16,14,,,12,8,
   4,7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,13,4,4,6,13,14,,,6,,
   14,,,,9,,,,4,,,6,,7,4,7,,,8,9,,10,,10,9,7,6,11,,19,42,
   9,,,20,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,5,4,5,5,14,,,7,
   ,14,,4,8,,,4,,,5,,7,,7,,,,8,,24,,6,9,12,7,,,,33,5,35,
   42,,8,12,,4,5,,,,7,8,7,,,,9,,47,,9,9,11,7,6,42,,33,,35,
   ,,11,,5,6,,6,,,9,,,,5,6,,7,,,7,5,15,7,25,56,29,,,25,,,
   5,,,8,,6,,6,,,6,,,,,7,,,,,,20,20,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,,4,,4,4,4,,,4,4,,5,,4,4,4,4,11,11,11,12,11,12,11,
   11,,4,,5,,5,,,6,6,,,,3,4,16,5,14,,12,,4,16,16,12,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,8,5,,,6,6,,,,5,6,16,5,6,16,12,,16,16,,
   12,,,,,,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,14,,,5,,14,,,,
   ,,,,10,,5,6,7,,12,,19,,9,42,,20,,,,,,6,,6,4,4,13,6,14,,
   ,13,,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,9,5,,12,7,33,,
   ,6,24,35,42,,10,,9,,6,11,7,33,42,,10,24,35,,,,,,,,,,,,,,,,
   ,,,,7,7,,,,,20,,20,,,,,,,,,,,,,4,8,12,9,12,16,12,5,44,44,
   60,12,8,8,16,12,12,4,44,60,27,4,4,60,27,44,8,12,16,
   12,5,44,60,44,9,12,12,16,27,25,60,12,16,12,12,,,12,,12,
   ,,12,,,12,16,12,,,60,27,25,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,
   ,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,30,
   30,,,,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,
   7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,16,16,16,4,4,4,,16,
   16,16,6,17,,9,,10,,,10,13,8,9,,6,,8,,10,,,6,,9,8,,5,,,,
   ,8,,,,12,,,5,,,10,,,,5,5,41,41,41,,,,5,41,41,41,,,9,,10,,
   ,9,,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,41,
   41,41,5,5,5,,41,41,41,5,5,4,7,7,4,6,7,7,5,5,4,5,6,
   8,7,,5,4,8,11,6,,13,,,,5,6,,8,,9,,10,11,,,,,20,,13,15,
   9,10,16,16,12,16,10,16,9,10,5,5,5,4,4,7,7,6,5,5,4,
   5,6,8,,12,5,4,8,13,6,,,13,,,5,6,,8,,9,,10,10,,,,20,,
   20,15,13,10,10,9,12,13,16,15,9,10,10,7,6,7,6,4,5,4,
   7,7,4,7,6,7,,,7,4,7,9,4,,7,7,6,8,7,6,,7,8,12,,6,6,,
   ,,10,9,9,7,7,7,6,7,7,7,6,7,7,7,6,5,7,5,5,4,6,5,
   5,4,5,6,8,13,,5,4,8,,6,,,10,,,5,6,,8,,9,,10,,,,10,,,,
   10,15,10,9,10,13,12,12,13,10,10,9,7,7,6,7,8,7,7,4,
   7,6,7,7,14,7,4,7,7,4,,,9,8,6,7,6,,7,9,12,,6,8,,,8,
   10,10,9,7,7,6,7,7,7,7,7,7,7,6,7,7,5,4,7,7,7,7,7,
   6,8,13,,7,7,8,13,6,,,,,,7,6,,8,,9,,8,11,,,10,,,,15,14,
   22,22,10,24,,10,15,10,22,22,5,7,7,5,5,4,5,6,8,10,,5,
   4,8,,6,,10,11,,,5,6,,8,,9,,10,,,,11,,20,20,10,10,9,16,
   10,12,16,13,15,10,9,16,7,4,7,7,4,7,6,7,9,16,7,4,7,,
   4,,8,6,9,8,7,6,,7,9,12,,6,,,,6,10,10,10,6,7,7,7,6,
   7,7,7,7,6,7,7,7,7,7,7,7,6,8,,,7,7,8,,6,,10,10,15,,
   7,6,,8,15,9,,8,10,,,11,,,,9,15,22,10,22,,24,24,14,22,
   22,10,8,8,4,8,8,7,,,8,4,7,,4,,8,8,12,9,8,8,,7,11,18,
   ,7,8,,,8,9,10,10,11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,
   5,5,5,,4,3,4,5,4,,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,16,
   15,4,,4,6,16,15,6,4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,
   ,4,6,,8,,8,,4,5,,,5,5,,5,16,6,,4,4,15,16,6,15,4,,4,
   4,4,4,,6,3,3,3,3,3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,
   6,6,4,4,4,4,3,4,4,4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,
   ,8,4,5,,5,8,8,,4,5,,,5,5,,5,6,16,,4,4,16,15,6,15,4,
   ,4,5,5,,5,4,5,5,4,,5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,
   8,8,5,5,6,6,6,5,5,6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,
   5,,4,,8,,5,4,,,,5,5,,15,16,4,,4,16,6,15,6,4,4,,7,4,
   4,4,4,3,,6,5,,,4,5,,,12,8,,5,5,,,,5,,7,,,31,5,4,8,7,
   8,,4,31,5,6,5,7,7,6,,7,,30,113,6,,,6,36,,,,6,,,,9,9,,
   31,16,7,,7,16,31,21,26,7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,
   4,,,,4,,5,5,15,16,4,4,,16,6,15,6,,4,4,4,4,3,,,3,6,6,
   4,4,,4,6,6,,3,,,,3,6,6,4,4,4,4,3,4,4,4,4,4,4,4,3,
   7,4,,5,5,,,8,6,,4,8,8,,4,,,,4,,5,5,16,15,4,4,,6,16,
   15,6,,4,4,,,5,,,12,,5,,4,,8,,5,5,,,5,,5,7,7,8,4,5,31,,
   ,,8,31,4,5,,3,,6,6,4,4,,3,6,6,,4,4,,,4,6,4,6,6,6,
   3,4,4,6,6,6,6,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,
   6,,,12,8,,4,,,,5,7,,5,8,8,31,4,5,,,8,8,5,31,4,,,5,6,,
   4,,8,,,5,,,6,7,5,,,,4,31,5,8,8,8,8,5,4,31,5,,5,,8,5,
   8,,,,,,,,,,,,,,,,6,,6,,,,8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,
   ,4,,8,,4,,,,4,,5,5,15,6,4,4,,15,6,16,16,,4,4,,5,5,6,
   ,5,5,,,5,8,8,8,6,5,6,6,6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,
   ,,,,,,,,,,8,,4,5,,,5,5,,5,6,15,,4,4,6,15,16,16,4,,4,8,,
   ,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,12,12,8,8,9,9,9,8,8,
   8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,5,5,,15,6,4,,4,15,6,
   16,16,4,4,,,,4,,7,5,7,7,5,4,31,,8,,8,31,5,4,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,31,4,8,,,8,4,5,31,6,6,,,
   5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,,5,,,,,5,5,,5,21,21,
   13,4,4,4,8,13,21,21,21,21,21,4,4,4,5,21,21,21,4,4,
   21,21,21,21,4,3,4,4,21,21,13,21,4,4,3,21,21,21,21,3,
   4,4,5,5,4,21,21,21,8,4,21,21,21,4,21,21,13,21,21,21,
   4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,9,9,,,,,10,13,,22,,,,,,10,22,16,19,15,16,,,,,
   ,10,10,12,,22,12,18,,31,,,,,,,41,23,10,13,49,21,,51,,,,,
   6,,,8,,8,12,,7,,7,,,,10,7,17,18,11,13,,26,209,,,7,10,,,
   8,11,,,15,,,,,,29,23,,11,,78,23,81,56,,,,9,,,,,10,13,,,10,
   10,,19,12,,22,12,,,,,20,,,,,10,16,94,22,,,,,30,,,,,,105,13,
   17,23,41,51,,21,,,,,,6,,6,,,7,13,10,,,17,13,7,,,8,,,,148,,
   ,10,8,,223,7,17,14,,12,,19,,,,16,28,9,,9,28,28,16,28,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,8,12,,7,10,7,,18,11,,7,,,11,13,,17,
   ,,,7,9,17,,8,,,,,,24,,,,81,56,,,,20,56,29,23,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,,12,,6,,,,,12,,,8,11,,,199,,
   ,6,7,,90,12,,16,,,,24,,,,19,23,10,8,10,23,23,19,23,,,,,,,
   ,,,,6,6,6,8,6,4,,,71,,,5,5,6,28,6,7,6,,,9,9,,,,63,44,
   7,17,5,58,56,17,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,6,,,,6,6,6,8,6,,,,,,,5,5,6,16,6,7,6,,4,7,,,,,39,39,
   5,5,4,39,39,10,10,,,,,,,5,6,6,6,8,6,,,,,68,,5,5,5,24,
   6,7,6,,,6,,,,,44,63,17,7,5,57,33,17,10,,,,,,,5,5,5,7,5,
   ,,,,,,5,4,5,14,5,6,5,,8,8,6,,,,29,29,,,5,29,29,9,9,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,,,7,8,
   9,27,10,9,8,,,11,,,,,,,20,9,6,77,,19,13,,,,7,7,9,9,7,,,,
   ,,,6,7,6,25,8,8,7,,,,,,,,,70,,,7,67,,18,11,,,,6,5,,,,,,,
   14,,,4,6,71,6,5,,,,7,,,,,17,57,5,7,17,63,10,44,33,,,,,
   10,6,7,,8,16,,,5,5,,,4,7,6,,7,,8,,,,39,10,5,4,5,10,
   39,39,39,,,,9,6,7,,8,16,,,5,5,,68,,6,6,,7,,8,,,,63,10,
   7,5,17,17,57,58,51,,,,,,,,,23,,,6,10,,10,,,,,12,,,,,19,77,
   6,9,20,,13,,,,,,7,,,,18,,6,4,6,,6,,,,7,7,,,,,11,51,4,5,
   5,51,11,51,51,,,,,,,,,5,5,7,39,7,,7,,,10,10,,,,64,,7,19,,
   ,57,23,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,
   ,,,,,,7,11,7,,19,49,21,,,,,,,14,24,,16,,71,,,25,,,,,71,,,,,
   ,25,44,71,,,,,14,19,71,,,15,28,,,,41,,,,,44,,,,68,,71,44,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,,5,,,,,6,,,,,9,29,5,,,29,9,29,
   29,,,,,44,,7,5,,6,,7,,,,11,9,,6,6,9,11,31,19,,,,,,9,6,,
   7,5,8,,,,58,17,17,5,7,10,51,63,57,,,,,,,,23,,,,,,44,44,,,
   ,71,68,,,,,,8,6,,7,,8,,,,40,10,10,6,10,10,40,40,40,,,,,,
   ,11,,,,,18,67,7,,,70,11,,,,,,,7,7,,,,,10,44,5,17,7,33,
   11,57,63,,,,,,,,,,,,,,,,,,,,,,8,,,,,40,,10,10,,,40,13,13,,,,9,
   ,,,,18,,8,,11,,81,72,,,,,,,46,,7,11,7,,17,,31,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,29,31,18,18,19,41,19,40,,,,18,31,
   14,41,19,19,29,,,,5,5,14,19,18,15,,,,5,52,14,18,24,,,,
   18,15,31,19,,,,29,29,17,,,,40,15,,,,41,,,,,,,,,,,10,,,9,,8,
   ,11,8,10,8,,9,6,5,,11,10,6,,8,11,8,8,,,,,,5,,5,,6,10,
   8,,8,,10,,,,17,17,9,15,9,,,,17,56,56,35,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,5,6,6,5,6,5,5,6,7,8,
   6,8,4,16,,7,8,8,15,7,,13,,,,6,8,15,4,,7,15,10,,20,,,,,,
   ,31,8,9,7,10,7,7,51,51,82,27,8,8,8,6,5,6,6,7,6,7,
   8,6,8,4,,17,7,8,8,13,7,,,,,13,6,8,20,4,,7,,10,16,,,,,,
   18,27,,9,7,8,7,9,10,35,82,27,,6,4,6,6,7,4,7,8,7,6,
   8,6,6,,,7,6,8,13,7,14,,15,,,8,6,19,6,,7,17,6,17,,,,,,,
   64,32,7,10,10,16,10,18,34,38,,35,8,6,8,8,6,7,6,7,8,
   6,8,4,,16,7,8,8,,7,,,20,,,6,8,,4,18,7,,10,17,,13,,13,,
   ,82,27,7,10,9,9,8,7,,27,,35,6,6,4,6,5,8,7,6,8,6,6,
   15,,7,6,8,,7,,,,,,8,6,,6,,7,14,6,,15,,14,,,,,64,10,16,
   7,10,7,16,32,,35,32,5,4,4,5,7,8,7,7,7,4,8,10,8,7,
   8,9,7,10,9,10,,,7,7,11,4,,7,9,6,9,10,9,10,,,15,17,
   28,10,8,10,8,10,6,20,34,19,28,8,6,5,6,7,8,6,8,4,20,
   ,7,8,8,,7,13,,15,,,6,8,,4,,7,,10,,16,15,15,,,,51,82,
   10,7,7,8,7,9,27,,35,51,6,7,8,7,6,8,6,6,,17,7,6,8,,
   7,,14,19,,,8,6,15,6,,7,,6,,,13,17,,,,38,,16,18,10,7,10,
   10,35,64,32,34,5,7,8,7,7,7,4,10,9,8,7,8,9,7,9,10,
   11,,,7,7,10,4,15,7,10,6,10,8,9,9,,,,34,19,8,6,10,10,
   10,8,28,17,28,20,6,8,8,6,8,4,,,8,8,7,,8,18,18,20,,
   12,6,8,20,4,15,8,20,7,,,,20,12,,15,,78,7,7,8,7,8,7,
   78,,78,78,5,5,4,4,4,6,,6,4,7,,7,,6,,,,4,4,6,3,7,5,
   6,5,6,6,8,8,8,,,,15,5,16,6,6,16,5,12,15,12,,5,5,5,
   4,8,8,6,7,7,7,6,7,,7,,,6,5,,4,8,4,7,5,,7,,7,8,,6,,
   14,13,4,6,4,13,6,,,,14,4,4,4,,6,5,5,4,6,5,6,8,8,,7,
   4,4,6,4,,5,8,4,6,,6,,4,,,12,16,4,4,3,14,5,16,16,12,,
   ,5,4,,6,5,5,4,6,5,8,8,6,,7,4,4,6,4,8,5,,4,6,,6,,7,
   ,8,12,,16,6,5,16,5,6,16,12,,16,4,6,,7,4,7,8,6,,6,,,,
   4,5,6,3,4,5,6,4,6,8,8,6,,,,,,5,16,16,4,4,3,12,15,
   12,15,5,5,4,3,4,5,4,6,5,6,,5,3,4,5,2,5,4,5,4,5,6,
   5,6,5,,,11,12,4,11,4,11,4,4,11,11,11,12,8,7,8,5,8,
   7,10,10,9,,10,6,,8,6,,7,6,8,10,,9,,7,,14,15,,13,8,5,,
   6,11,45,21,,,,6,6,6,,,9,,,,6,6,9,5,7,8,8,6,6,10,7,9,,
   ,,,,6,,44,7,11,5,25,45,25,40,5,7,,4,,7,,,8,5,5,7,4,
   6,6,7,5,8,8,7,7,,,8,,,4,6,13,13,6,4,14,,14,,7,8,5,6,
   ,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,15,12,4,3,4,5,16,16,
   16,,,12,6,7,10,10,10,,,7,4,10,4,8,7,5,4,6,5,6,5,,,8,
   ,13,6,6,,6,,6,13,,13,13,,,10,,,,8,6,10,5,10,7,8,6,7,
   9,6,10,,,,45,33,5,7,11,,13,6,25,,25,,,7,,,14,5,5,7,4,
   8,6,7,5,8,7,7,8,9,,9,,,4,5,5,7,7,5,14,,14,,8,6,,,6,
   8,8,5,7,7,10,6,9,10,10,8,,,,,,6,44,,11,7,5,25,40,25,
   45,8,,,,6,6,6,,,8,6,,10,,10,,,7,40,21,11,5,7,6,,44,45,,
   ,21,,,6,6,8,5,10,7,9,8,9,8,10,10,14,,120,,45,5,13,8,
   11,,7,25,40,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,14,5,9,9,7,
   7,,7,,10,,,,,20,,,,7,,7,20,,,,5,,4,,7,8,5,,6,,6,,,7,15,
   12,6,5,16,5,6,16,,,16,12,8,4,,5,,4,6,,6,8,7,,,12,,14,
   16,5,4,3,4,,12,16,16,6,120,,10,8,,9,,9,,,10,40,21,11,
   7,,5,8,13,,,45,21,,4,6,4,5,5,5,5,5,,5,11,11,11,4,4,
   4,4,11,12,11,12,11,9,,,,14,,,,,,20,20,,,,7,7,,,,,,8,5,,7,
   ,7,14,,8,,14,7,5,7,4,5,5,,,,14,,9,,10,,10,,,15,,44,,6,
   7,5,11,,21,45,,6,8,6,,7,,,12,16,6,16,5,6,5,16,,12,16,
   ,8,6,8,,,7,45,25,7,5,11,6,44,,40,,,25,8,6,10,,,21,,,
   11,6,13,5,8,,15,,45,8,,,10,,25,,6,13,5,11,7,,45,33,25,
   7,,,21,45,7,11,5,44,6,,,15,,,,9,,,7,7,,,,,,,20,20,,,,,,,,,,
   ,,,,,,7,,7,,,,,20,20,,,25,27,56,12,16,12,,,,,27,60,25,16,
   12,12,,,,12,4,4,8,7,10,60,12,16,12,5,10,8,9,44,12,12,
   16,7,9,8,27,16,12,12,4,4,12,25,27,60,5,12,56,25,27,
   16,27,60,37,,12,,,,,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,
   ,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,,,,,,,7,
   10,10,,,,13,22,,,,13,10,15,,,,10,,,,,,,21,,15,,,10,20,,,,94,
   ,23,10,,41,,,,,12,,119,103,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,9,6,9,,7,8,7,,,7,12,7,,,,12,7,,,8,,9,13,,,,
   7,,,,11,24,,10,14,,,,,,,11,29,23,35,,,,11,81,35,29,,9,,,,,
   9,,12,10,,,15,26,10,7,13,,,,8,11,,,,,,13,,,,,8,,,,141,141,
   ,12,8,,19,55,,,,11,,55,26,,,6,,7,15,,8,,8,,16,26,14,8,
   15,18,10,,,17,,,,8,,,,9,23,,9,,,13,135,,,,8,38,37,32,,,,,
   56,32,20,,9,,,17,,18,17,18,,27,26,15,,11,,16,19,11,,,,,
   16,,15,,,,21,11,,,,,,143,18,26,,,92,,,,11,40,111,247,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,14,,8,14,8,,21,,,8,,,
   10,,9,,,,,8,,15,,9,,,,,,,,135,,,,56,75,32,,,,,20,32,56,10,
   11,,10,10,12,,16,19,10,,15,14,12,,,17,,,,12,,15,,,19,12,,,
   ,18,,,140,8,12,32,,30,,,,13,32,30,34,,,11,,10,,,,,11,,,10,
   ,8,,,,,10,,16,,10,,,9,,,13,,,,10,10,84,47,97,,,,10,68,69,
   84,,,,,,5,,6,5,6,7,6,,4,,,,,6,,6,,6,8,6,5,,,,28,71,,17,
   7,44,63,10,,,,5,17,58,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,6,,,,5,5,5,6,5,6,5,5,,,,5,,5,,5,7,5,4,,,,14,,,,,
   29,29,9,,,,5,9,29,29,,,,,5,5,6,7,6,5,5,6,,,,6,,6,,6,
   8,6,5,,,7,28,,68,7,17,63,44,10,,,,5,17,57,33,,,,6,5,6,
   7,6,,4,7,,,,6,,6,,6,8,6,5,,,7,16,,,5,5,39,39,10,,,,4,
   10,39,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,7,8,7,,7,,,
   ,,7,,9,,7,9,7,7,,,,29,,,,,,70,11,,,,7,18,,65,8,8,9,9,8,
   ,6,,,,,8,,10,,10,10,8,8,,,,31,,,20,9,,,15,,,,6,19,,74,5,
   6,,,,5,4,,,,,,6,,6,,,5,5,,,,24,71,5,17,17,58,57,,,,7,63,
   10,51,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,,,14,,5,29,9,29,,,,
   ,29,29,9,9,6,8,5,7,,,,6,,,,,10,6,,8,,7,,71,28,17,5,
   44,10,63,,,,7,57,33,11,,,7,,,,,5,,7,,7,,,6,,,5,,17,,7,,
   11,49,,,,,,,11,49,,5,,,,,4,,6,,6,,,4,,,4,,16,,6,10,10,40,
   40,,,,10,40,10,40,5,,,,,,,8,,8,,,7,,,,,31,,7,11,17,,,,,,7,
   31,49,,5,,,,5,,,,5,8,5,,7,,6,19,44,14,6,6,31,9,11,,,,,
   11,37,9,,,,,,7,,7,,,6,6,,,,33,,,22,23,,58,,,,7,64,13,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,6,,6,,,4,,,4,,16,,4,5,10,39,39,,,,5,39,10,39,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,9,5,5,8,,7,71,,14,7,5,57,17,33,,,,17,
   44,63,10,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,7,,,18,5,4,51,11,
   51,,,,5,51,51,11,,6,,,,,23,,6,9,14,,,,,,20,,19,77,4,,,,
   68,16,,5,7,10,63,51,,,,17,58,17,57,5,,4,44,19,13,,6,
   11,9,37,,,,6,31,11,9,,,36,,,7,11,31,,49,,,,7,17,,,,,,,,,,,,
   ,,,,,,,,23,,,10,13,,40,,,,10,40,13,,,,,,44,44,,,,,,,71,68,,,,
   ,71,71,,,,,44,,25,,,44,,44,,,,,71,68,,5,31,18,24,,,,5,18,
   52,14,18,31,15,,,,5,18,14,19,29,29,,,,14,19,41,19,40,,,,
   18,19,19,41,,,,19,41,19,15,,,,,,,,,,,,,,,,31,18,15,29,40,
   29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,
   ,,,10,22,16,,,,10,12,30,22,,,10,,,13,,20,,,,,,12,19,,,,,94,
   ,,41,,51,13,23,17,,,105,21,,6,,,8,,8,,,7,10,7,17,,,,7,,,
   8,,13,9,,,12,7,17,,,11,24,,11,18,,,,,,,,20,29,56,,,,,81,
   56,23,9,,,,,10,,10,10,,22,12,31,,,,16,,22,,16,10,,,13,22,,
   ,,15,,18,,,19,12,,,,,,49,,21,23,13,10,,,41,51,,,6,,6,,13,
   10,13,7,,12,,,10,,,7,,,8,,,,7,,,,8,19,14,17,,,17,,148,223,
   ,,28,16,28,9,9,,,32,28,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,10,7,
   ,7,,15,,,7,17,,8,,13,10,,,12,7,26,,,11,,,,,18,11,,209,,,,
   78,81,23,,,11,,29,23,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,,12,,,,,6,,,12,,11,7,,,10,12,,,,8,24,16,,,,,,199,
   90,,,23,19,23,10,10,8,,19,23,23,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,6,6,6,,,,5,5,7,6,,,4,,,6,6,,,,,,,7,8,,5,14,
   ,71,,,63,44,10,5,17,7,,17,57,33,5,5,5,,,,5,5,6,5,,5,
   5,,,5,5,6,,,6,,,6,7,,,14,,,,,29,29,9,5,,,,9,29,29,6,5,,,
   ,,6,6,6,,,5,,,,,,,,6,,6,5,,8,7,68,,24,,,57,17,33,17,5,
   7,,44,63,10,,7,,,5,,,4,,7,5,,,6,6,8,,,6,8,6,7,10,10,7,
   ,16,,,,10,39,39,5,5,4,,39,10,39,7,,,5,,5,,,7,,,,6,6,8,,
   ,6,8,6,6,9,10,9,71,28,,,,10,63,51,17,7,5,,58,17,57,,,
   8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,,23,,,,13,40,10,,10,,40,,13,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,14,,,29,9,29,,5,,,29,
   29,9,,,,7,5,,,6,6,8,,,6,8,6,9,10,9,6,,16,68,,,17,58,
   57,7,17,5,,63,10,51,,,10,,,,9,7,11,,,7,9,7,,11,12,11,,
   29,,,,11,81,,,,8,,,18,72,,7,,,,6,6,8,,,6,8,6,8,10,10,8,
   ,16,,,,10,40,40,10,10,6,,40,10,40,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,5,,,4,,,,,7,10,7,,,,,,,39,,,,23,57,7,,22,,64,,13,,,5,
   5,5,,,4,7,5,7,8,6,7,19,14,44,,,9,31,11,,6,6,,11,9,19,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,6,,,
   8,7,,71,28,,,58,17,56,7,5,17,,63,44,10,,,,6,,6,,,8,7,,,
   16,,,39,10,39,5,4,5,,39,39,10,,,,,5,,,,,,,,,,,49,19,7,7,
   11,,,,21,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,,,18,,,,
   ,51,51,11,4,5,5,,11,51,51,,,,,,41,,,,,,,17,7,7,11,,46,,
   31,7,8,,,28,71,,,,33,57,11,5,7,17,,10,44,63,,9,8,,,25,,
   ,67,18,,,7,,,,70,11,10,9,,,27,,,77,19,,20,6,9,,,,13,,23,,
   ,,,,,13,6,20,9,,19,77,,15,,,,,70,,11,7,,,,18,67,,,,,,68,
   71,,,,,,,44,44,,,,,44,25,,,,,71,,71,,,71,,68,,,,,44,44,,,,,,,,
   ,,,,,,,,,,,,,,,29,29,14,18,52,,19,41,19,40,18,31,18,,19,
   19,41,19,15,14,,41,19,15,5,5,,31,18,15,5,,18,14,19,,
   18,31,24,,,,29,40,29,3,4,4,4,3,4,4,4,4,4,4,4,4,6,,,
   4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,13,13,13,13,8,
   8,13,24,8,24,8,13,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,
   6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,13,13,13,13,8,8,
   13,24,8,24,8,13,4,4,3,3,3,3,4,4,4,4,4,4,6,,4,4,4,,
   4,,6,,,,4,4,7,4,,4,8,6,8,,6,,,,,6,12,12,6,6,6,12,9,
   6,9,6,12,3,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,
   4,6,8,7,,6,10,9,10,10,8,,,9,,15,13,13,15,8,8,13,8,8,
   8,8,12,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,
   8,7,,6,10,9,10,10,8,,,9,,15,13,13,15,8,8,13,8,8,8,8,
   12,3,4,4,4,4,4,4,4,4,8,,4,4,4,8,4,7,7,,,,4,4,,4,,4,
   ,6,,8,8,,,,,6,9,9,6,9,9,9,6,9,6,9,9,4,4,4,4,4,4,
   4,4,8,,4,4,4,,4,7,5,,9,,4,4,7,4,9,4,,6,,,8,,,10,,6,
   5,5,6,8,8,5,8,8,8,8,5,3,6,6,7,6,7,5,,,6,7,5,,6,8,
   7,,,,6,7,10,5,9,6,8,9,8,,,,,,,13,9,9,13,24,24,9,9,36,
   9,24,9,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,
   8,9,8,,,,,,,13,9,9,13,24,24,9,9,36,9,24,9,4,4,4,4,4,
   8,,3,4,5,6,5,6,7,,11,,4,4,6,4,8,7,6,7,6,6,,,,7,,35,
   5,7,35,7,8,23,7,8,8,7,14,4,4,4,4,,,4,4,4,6,4,6,,,8,
   ,3,4,6,5,11,5,6,7,6,6,,,,,,35,7,23,9,8,7,14,8,7,7,
   14,6,4,4,4,,,4,5,4,8,5,6,,,15,,4,4,6,8,15,6,7,8,8,
   7,,,,,,10,9,13,13,6,9,9,9,9,6,9,9,4,4,,,4,4,4,6,4,
   6,6,,,,4,4,5,4,7,4,6,6,6,,7,,,,,9,23,14,7,7,14,6,7,
   8,8,21,6,4,,,4,4,4,7,4,,11,,,,4,5,6,4,6,5,8,7,6,9,
   9,,,,,13,13,9,10,9,9,9,6,6,9,15,10,9,,5,4,4,10,5,,6,,
   ,,4,8,6,4,10,6,10,8,6,,4,,,7,,9,32,7,35,11,34,8,11,
   7,7,12,22,,7,9,4,9,6,8,9,,,,4,7,6,7,15,6,7,8,8,,,,,,
   ,14,,,22,10,36,,12,14,9,96,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,4,4,,5,,8,,,,4,4,6,4,12,4,6,7,,,4,,,7,,7,14,6,7,
   14,21,6,8,8,21,8,5,4,9,5,11,,,,,4,4,6,4,13,4,6,7,,
   11,7,,,,,10,9,9,7,9,15,10,9,9,14,14,4,,5,10,,,10,,5,
   4,10,4,8,5,6,8,7,6,7,,,7,,35,7,8,10,34,12,20,7,12,
   27,7,7,,,11,,,,,11,,6,15,8,,12,12,12,6,,,9,,15,18,10,26,
   ,,8,12,14,47,17,13,6,6,,11,,7,6,9,6,,8,11,7,,8,6,,,6,
   ,15,11,5,19,19,13,10,15,19,10,7,10,6,,,,6,7,7,6,15,
   8,12,9,,6,11,,,21,,22,90,16,19,,,13,15,10,21,35,,,47,,
   6,6,7,7,16,7,6,9,,6,,,,,,20,15,,19,15,12,,11,12,12,36,
   10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,15,8,,8,,11,15,,14,,,,,34,,
   ,,,,8,11,36,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,6,5,,,7,
   ,7,6,6,9,21,8,5,21,14,14,7,7,7,4,,5,,8,11,,5,,,10,,
   7,9,10,10,15,14,4,14,9,15,9,9,7,,,6,,,12,,,,11,,22,8,
   14,53,21,15,10,,25,,10,12,,5,7,8,11,11,,,,,,10,8,20,10,
   12,7,7,27,23,7,27,6,,,,,,16,,,,,34,13,,97,,11,13,,,,,,,7,
   8,7,,,,,,19,5,10,14,13,7,10,10,19,11,11,11,,12,,,,,,,18,
   15,10,,12,14,9,,47,14,15,16,,10,10,,,9,,,8,8,,24,10,10,
   124,,12,10,66,,7,,,11,,15,10,15,18,47,12,10,,25,,14,9,9,
   ,,,,18,25,18,15,14,,10,14,15,12,,8,,,,,61,8,,14,14,10,,,
   ,12,36,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,170,,17,14,,,,,11,,8,,,,,,
   ,,,,,,,13,14,,24,12,10,12,19,24,27,24,18,20,17,9,4,6,
   9,23,19,18,13,9,17,18,18,21,6,9,4,19,24,14,27,20,12,
   12,10,25,15,10,25,16,6,6,9,14,6,10,25,15,10,6,18,17,
   18,16,25,15,16,15,46,22,14,10,9,4,4,4,3,4,4,4,4,4,
   4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,13,
   13,13,13,8,8,13,24,8,24,8,13,3,4,4,4,4,3,4,4,4,4,
   4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,
   8,13,13,8,13,13,13,8,13,8,13,13,4,4,4,4,3,4,4,4,4,
   4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,
   8,13,13,8,13,13,13,8,13,8,13,13,3,3,3,3,4,4,4,4,4,
   6,,8,4,4,6,5,4,8,,5,,,4,4,6,6,,4,7,6,7,5,,8,,,,9,6,
   6,9,9,9,6,10,9,10,10,8,4,4,3,4,4,4,4,4,4,,8,4,4,
   4,6,4,6,,7,,,4,4,,4,,4,,6,,6,,8,,,,9,6,6,9,12,12,6,
   6,12,6,12,6,3,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,
   6,10,7,,6,,9,,,,8,,,9,8,15,15,8,13,13,15,8,13,8,13,
   15,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,
   ,,,8,,,9,8,15,15,8,13,13,15,8,13,8,13,15,4,4,5,4,5,
   4,,6,4,5,4,,4,8,,8,7,9,4,5,6,4,,4,5,6,5,,,6,9,,8,
   10,6,6,10,7,7,6,9,7,9,7,6,4,4,4,4,4,,,3,4,5,6,5,5,
   ,,7,,4,4,6,4,,7,6,7,5,5,,,7,,,14,7,9,23,6,5,35,8,6,
   7,7,35,4,4,4,4,,,4,4,4,5,4,8,,7,12,,3,4,6,5,,5,5,
   7,6,7,,8,11,,7,23,9,35,7,5,7,35,7,6,8,23,9,4,4,4,,,
   4,5,4,8,5,4,,,13,,4,4,6,8,,6,6,8,6,10,,,6,,,9,10,13,
   13,4,9,10,9,10,6,13,13,4,4,,8,4,4,4,7,4,,,5,,12,4,
   4,6,4,,4,6,6,6,,,5,8,,7,7,35,35,5,7,23,9,8,5,7,14,
   7,4,,,4,4,4,10,4,,,10,,,4,5,8,4,,5,6,7,6,,,4,15,,10,
   13,13,10,9,9,13,13,6,4,9,9,10,,9,5,4,4,11,5,7,,7,,
   8,4,8,6,4,,6,10,8,6,7,,7,10,,,7,35,9,32,6,32,9,7,7,
   11,7,35,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,7,8,,,,17,
   163,4,5,8,4,,10,10,10,6,8,,,15,,,,22,14,,12,12,61,9,8,
   12,11,25,4,4,,5,,,6,,7,4,4,6,4,,4,6,7,6,6,,4,,,7,5,
   35,9,6,23,14,7,7,7,14,6,7,4,,5,,,8,,13,4,4,7,4,,4,
   6,7,,11,,5,,,4,9,10,13,4,13,9,10,9,9,9,9,7,7,5,9,,
   11,8,,5,4,10,4,,5,6,8,,6,,4,,,8,32,9,9,6,32,7,35,11,
   6,34,8,10,,,,,,13,6,11,6,6,,8,6,,12,11,,8,,,18,12,20,
   19,16,,,27,12,22,36,10,35,8,,,,,7,6,11,6,,8,9,7,10,8,,
   10,12,,12,12,15,8,7,7,12,15,15,11,19,5,19,,7,163,17,
   7,9,9,4,,6,11,8,8,9,,4,,,11,12,61,14,12,,,22,10,8,36,
   ,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,13,,8,6,,6,,,11,,,,,9,,,,,27,
   19,,16,12,20,,15,12,9,168,,8,,,10,,8,,13,38,,,,,,,9,,,,,,
   50,12,13,,,,11,6,,8,,,11,,16,10,,,,,,,50,,,,9,,48,9,,,,4,,
   4,,5,6,7,,8,,7,,,7,6,9,7,6,14,6,7,14,23,21,6,9,9,4,
   ,5,,8,11,,,7,,,10,4,13,10,10,9,9,7,9,13,15,10,10,,,,6,
   ,,11,,,,,19,15,18,15,10,18,10,26,,25,,8,24,,5,,8,10,,,,
   10,,8,6,9,35,7,7,8,10,34,32,12,22,10,,,,,,,,,,,,,,,,,,,,,,
   ,10,7,6,6,,10,11,,12,7,8,15,11,11,5,19,19,7,13,10,14,
   ,12,,,,,,,8,22,19,,16,13,20,,90,35,,30,11,9,,,15,,,10,
   14,14,117,10,8,,,117,24,8,,6,,10,,,8,14,53,22,8,90,16,
   19,,29,,13,20,,7,47,,11,9,168,20,12,15,,19,15,,12,,27,,,,
   ,,,,,,,,,,,,,12,,,,16,22,,8,12,14,,30,9,12,61,,12,,97,34,
   13,,,,,,,8,34,,,,,,,,,,,,,,,,17,,9,86,,,147,11,9,,13,14,18,
   27,4,10,6,7,18,27,24,,20,14,10,,12,13,27,24,,13,13,14,
   ,24,20,12,10,,7,27,14,23,13,6,4,10,18,20,17,18,9,4,
   10,13,9,4,17,18,23,19,10,24,14,,9,25,15,20,19,18,50,
   9,19,13,4,3,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,
   4,6,10,7,9,6,8,9,8,,,,,,,8,13,13,8,15,15,13,8,15,8,
   15,13,4,3,3,3,3,4,4,4,4,4,4,,,4,4,4,8,8,,,8,6,6,4,
   4,6,4,6,8,7,4,7,8,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,
   4,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,4,6,10,7,
   9,6,8,9,8,,,,,,,8,13,13,8,15,15,13,8,15,8,15,13,4,3,
   4,4,4,4,4,4,4,,,4,4,4,8,4,5,7,7,10,,4,4,,4,,4,,6,,
   8,,,,9,9,8,8,8,8,5,5,8,6,5,6,5,8,4,3,6,6,5,6,5,6,,
   ,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,10,7,7,
   7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,5,,,4,4,5,6,6,5,
   6,6,9,,4,4,8,5,8,6,7,4,7,6,,,,,7,6,8,8,6,6,6,8,6,
   8,6,6,8,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,
   10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,
   5,5,,,4,4,7,6,7,8,,,7,,4,4,8,6,8,7,,7,6,4,,,,,,31,7,
   7,,8,6,,7,7,7,7,57,4,4,4,4,,,4,5,5,4,4,6,,,7,,4,4,
   8,7,8,7,6,6,8,7,,,8,,,,7,,7,6,7,31,7,8,7,64,7,5,3,
   5,,,4,6,5,9,6,5,,,7,8,4,3,5,5,8,4,6,5,9,5,,,6,8,8,
   6,6,4,4,5,6,6,6,6,5,5,5,4,5,,,4,4,4,7,4,10,10,6,,
   6,4,5,6,5,,4,8,5,8,,,,8,,7,7,,31,7,7,35,7,7,6,7,32,
   7,5,,,5,3,5,5,4,,5,6,7,7,4,6,9,5,6,6,9,5,5,,,,8,7,
   7,4,4,6,6,6,5,5,5,5,6,6,6,,,7,5,6,10,7,8,7,8,,7,
   6,5,8,5,10,5,10,5,8,,,,10,7,,7,34,7,34,12,,6,13,8,
   13,7,32,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,4,5,,7,,8,7,,,4,4,,4,6,4,8,6,7,7,,,,9,8,
   7,31,7,7,35,32,7,7,7,35,7,7,5,,6,5,,6,7,8,5,3,6,5,
   8,4,5,5,,6,,,6,6,6,6,6,5,4,5,6,6,6,6,5,5,4,,7,,10,,
   ,,7,5,10,6,,7,8,8,,5,,,,9,,34,7,6,8,,7,32,16,15,71,
   8,7,,,9,,,,7,6,8,5,,4,7,8,9,,,,68,8,,8,24,7,12,22,,,
   8,12,29,7,9,6,12,,8,9,7,4,9,5,9,4,9,7,,4,,,10,6,10,
   7,7,4,7,7,7,7,7,7,7,5,7,10,8,47,14,8,6,6,7,12,12,,
   9,10,9,,,,,16,11,34,10,7,,16,11,17,13,28,14,10,,13,,7,
   6,8,8,19,7,6,7,,,,,29,,11,,11,22,7,13,9,,13,12,20,17,
   10,,,8,6,11,8,,9,11,11,6,6,,,17,11,,,9,7,22,14,11,,22,
   17,20,10,32,7,7,7,8,,7,4,13,8,,,,,,,,6,,96,55,,,,8,7,,
   85,,8,6,,,6,6,20,,,8,,,,,,,7,197,,,,,,,,,,4,,5,,7,7,7,,8,,
   ,,8,9,7,7,7,7,32,7,7,35,35,35,8,7,6,5,7,6,,5,6,,,,
   8,7,7,4,5,6,6,6,5,4,5,5,6,6,6,8,133,,,11,,11,,,,,17,
   10,9,9,9,18,16,15,29,21,,15,12,,7,,5,9,10,,,10,,9,8,
   6,32,7,7,8,7,39,,8,34,8,6,105,,,10,,,,,,9,6,,135,,9,8,,
   ,,,,,7,10,,,,9,11,11,7,4,7,7,7,5,7,7,7,7,7,7,,10,,,,
   12,18,,9,10,12,,11,10,16,29,25,11,9,19,10,7,,,9,9,,7,
   7,7,34,17,13,7,,38,18,8,34,7,,,133,14,22,9,9,10,9,25,
   11,12,,26,29,10,16,,,13,,10,8,23,24,8,12,19,7,10,12,8,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,10,,135,9,6,,,200,,,,,7,8,,,,
   ,9,,,,,,,7,,,,,,,,,,,7,,4,11,18,18,5,6,6,7,23,18,14,18,
   17,18,7,4,6,5,16,14,18,4,5,18,18,23,18,6,7,4,7,18,
   11,16,19,6,5,6,26,18,20,26,7,6,6,5,5,6,20,26,18,7,
   6,23,18,18,7,,17,13,30,40,18,5,7,5,4,4,4,4,3,4,4,4,
   4,4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,
   ,,8,13,13,8,13,13,13,8,13,8,13,13,4,4,3,4,4,4,6,4,
   6,7,,,4,6,7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,13,
   13,8,15,15,13,8,15,8,15,13,3,4,4,4,4,4,4,4,6,8,,4,
   4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,24,8,8,24,13,13,
   8,13,13,13,13,8,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,
   4,4,,6,,9,,12,,,8,,,9,,24,8,8,24,13,13,8,13,13,13,13,
   8,3,4,4,4,4,4,6,5,7,4,4,6,,4,,8,6,,,4,4,5,6,,4,8,
   6,8,,5,7,,,,10,10,9,10,6,6,9,9,8,10,6,9,4,4,5,4,5,
   4,,5,4,5,4,,4,,8,6,,9,4,5,8,4,8,4,6,6,6,,,5,9,7,,
   9,7,7,9,6,6,7,10,6,10,6,7,4,4,4,4,4,8,,3,4,5,,5,,
   7,,,,4,4,8,4,7,7,7,7,4,,6,6,11,8,,21,6,6,14,7,7,14,
   6,9,6,9,23,4,4,4,4,6,6,4,4,4,,4,,,6,,,3,4,6,5,7,5,
   4,7,5,,,6,7,,,14,6,14,7,7,9,23,6,7,5,35,7,4,4,4,,
   11,4,5,4,,5,,9,9,,,4,4,6,8,10,6,7,8,5,,11,,6,,,15,
   10,9,9,7,10,9,10,10,4,13,13,4,4,,6,4,4,4,,4,,,6,,8,
   4,4,5,4,7,4,5,6,8,,7,6,12,,,7,14,23,8,9,35,7,5,7,
   7,35,5,4,11,,4,4,4,,4,,,7,,,4,5,8,4,4,5,5,7,4,,,6,
   13,,,9,9,9,9,10,13,13,4,7,9,10,9,,10,5,4,4,,5,,4,,,
   10,4,8,6,4,8,6,,8,4,,6,,8,10,,12,20,8,34,10,35,7,7,
   10,6,9,32,6,7,,6,,6,,9,11,,47,5,10,,7,11,8,7,9,8,,11,
   ,10,,,12,,,15,19,20,15,12,27,9,168,,6,6,,,6,,8,,,,5,6,,
   6,8,10,10,11,6,,12,12,16,38,,,13,16,,19,22,90,8,20,14,
   53,29,4,4,,5,,8,6,,11,4,4,7,4,7,4,8,7,,,5,5,,12,,8,
   23,7,7,35,35,5,7,9,23,9,6,4,,5,,,8,,15,4,4,10,4,10,
   4,4,7,,,10,6,,,,9,9,13,6,13,10,9,9,10,13,13,4,,5,,9,
   10,,,5,4,11,4,8,5,4,8,7,,7,6,,8,,34,8,7,11,35,9,32,
   6,10,32,9,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,11,7,6,,6,
   12,8,10,7,10,,8,10,,8,,13,10,5,19,19,15,11,11,14,7,8,
   7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,5,4,7,7,11,8,4,8,,,,11,
   17,163,,36,,,10,22,14,,12,16,12,61,8,,,6,6,,6,19,11,,,8,
   ,6,6,,,,,8,10,,26,15,18,10,24,15,18,25,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,7,6,,10,12,12,12,15,15,,,,,,,,8,,,,34,,13,34,,97,,
   4,,4,,5,,7,,,6,6,,7,,7,7,5,8,35,9,6,23,35,14,7,6,,4,
   ,5,,8,,,8,6,,13,,6,13,9,9,10,13,4,13,13,9,10,11,7,,,
   9,,,,,11,,13,,12,9,12,,20,19,16,,168,,27,15,,5,7,8,9,,
   11,10,8,,,11,7,32,7,9,9,6,32,35,7,35,7,12,,,,,18,,,,,
   11,9,86,,,17,9,,,,,147,10,7,8,,,9,,,,19,5,12,15,15,8,7,
   7,19,12,15,11,,,,8,,,,,9,12,12,,14,22,8,,61,,16,30,10,,,,
   ,13,,24,8,8,,,14,10,117,,10,14,117,,7,10,163,17,,12,11,
   12,9,61,14,12,,25,,22,8,,,,,,,,,,,,,,,,,,6,13,,,36,10,,12,
   27,19,,16,35,12,20,22,11,,,35,,13,,20,19,16,,30,8,22,90,
   ,,,208,9,48,,,,,,,50,9,,,,,12,50,,,,,9,,13,,,,,,,,,,,,,9,17,
   25,24,12,9,6,19,18,27,19,18,15,14,10,4,4,13,27,24,18,
   9,13,14,18,27,20,4,10,4,19,24,17,23,20,6,12,9,,20,14,
   ,10,,10,13,13,,14,,20,7,10,27,14,18,10,18,20,13,24,,
   50,13,7,13,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,
   4,6,8,7,,6,10,9,10,10,8,,,9,,15,13,13,15,8,8,13,8,8,
   8,8,12,4,3,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,
   6,,7,,6,,9,,8,10,10,,,,8,8,8,8,13,13,8,15,12,15,13,8,
   4,3,4,4,4,4,4,4,8,7,4,4,4,,8,,,6,6,6,4,4,8,4,6,8,
   ,4,,,8,7,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,
   4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,
   ,8,8,8,8,13,13,8,15,12,15,13,8,4,4,6,4,6,4,,7,4,6,
   4,,4,,,8,6,6,4,6,8,4,6,4,7,4,7,,,7,6,6,6,5,6,6,5,
   6,6,6,5,6,5,6,6,4,4,4,5,5,8,,4,4,7,7,7,,,,,,4,4,8,
   6,,7,8,7,6,6,10,10,7,8,,32,7,7,35,7,7,31,7,7,8,7,,
   4,4,4,4,10,10,4,5,5,6,4,,,7,6,,4,4,6,7,7,7,6,6,8,,
   ,6,7,,9,35,7,31,7,7,7,,8,7,6,,7,5,3,5,,5,4,6,5,6,
   6,,,,8,7,4,3,4,5,7,4,6,5,6,6,5,,4,6,6,6,6,5,5,4,
   6,6,6,6,5,4,4,4,5,,6,4,4,4,,4,,,4,,7,4,5,4,5,8,4,
   8,5,6,,,8,7,,8,7,31,,6,7,,7,6,7,7,57,7,5,5,,5,3,5,
   6,4,,,5,7,7,4,6,9,5,6,6,6,5,5,,,5,7,8,7,5,5,6,6,
   6,4,4,5,4,6,6,6,10,,7,5,6,,7,,,,,,6,5,6,5,,5,11,5,,
   8,7,8,8,10,,7,32,6,,8,34,7,8,7,12,7,64,10,,,7,,12,,,
   9,,13,6,6,6,8,16,6,8,10,,,11,,7,,25,9,,22,13,7,,11,
   11,9,10,32,11,8,5,8,8,6,,,,14,47,6,6,9,,13,10,10,,8,,
   6,10,11,,,16,11,10,,7,11,34,12,8,9,11,,4,5,,7,,,6,,7,
   4,4,7,4,9,4,6,6,10,10,6,6,,6,7,6,,7,8,,31,7,7,7,
   64,7,10,5,,6,,,9,8,7,5,3,5,5,7,4,5,5,,5,6,6,7,7,6,
   6,6,4,5,4,6,6,6,6,5,5,4,8,7,,,10,7,,7,5,10,6,9,7,,
   8,8,7,8,,,7,9,,6,7,12,34,7,34,12,8,,6,8,,,,,,,10,5,,7,
   ,6,10,,6,11,8,,,11,16,11,,7,14,22,,9,9,11,35,10,10,,,,
   9,8,7,4,6,5,11,4,7,7,10,6,6,10,7,6,7,7,7,4,7,7,7,
   7,7,7,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,8,4,7,6,10,6,11,7,9,6,,9,19,10,91,,,7,22,12,
   8,24,8,,9,8,23,7,8,6,10,10,6,6,12,,,,11,14,,,,,,197,,
   241,,7,9,8,,,185,7,4,19,8,7,7,10,8,11,7,,14,,,,,,,,55,
   6,,9,,160,183,,4,,5,,7,10,7,,8,7,8,,,,8,7,7,7,31,7,7,
   35,,32,7,7,,5,6,6,,5,5,,6,6,7,8,7,5,4,6,6,6,5,4,5,
   4,6,6,6,,91,,9,7,,9,,11,,,10,9,8,8,8,24,7,12,19,23,,,,
   ,7,8,5,,10,,11,,,,12,7,34,8,7,6,8,,34,7,32,7,7,125,,,
   25,16,,,,,9,9,,,,8,7,,,,,,10,7,6,12,,7,8,9,11,7,4,7,7,
   7,4,7,7,7,7,7,7,,10,,,,14,14,,12,11,7,,10,11,8,16,34,
   14,10,18,,10,,,8,,,13,7,7,38,7,7,7,38,34,13,7,34,10,
   8,10,47,14,13,9,11,11,12,34,10,7,,,16,11,8,,8,13,,16,
   10,32,,11,11,22,7,13,11,9,,9,10,,,,35,10,,9,9,7,22,14,
   10,11,,11,10,12,125,14,10,11,16,8,7,10,,18,12,11,34,7,
   7,,,6,9,,96,55,,,,,,6,,,,9,7,197,,,185,,,8,,,8,,7,,,,,9,9,
   ,5,18,26,18,5,7,4,7,14,18,14,18,18,11,6,4,5,4,18,
   11,18,5,4,11,18,18,17,5,6,4,7,18,18,16,19,4,5,7,18,
   17,18,18,7,4,4,4,5,4,18,18,17,7,4,18,11,18,7,26,18,
   19,14,18,17,5,7,4,4,4,3,6,6,7,6,7,5,,8,6,7,5,,6,7,
   8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,24,24,9,9,9,24,13,9,
   13,9,36,3,4,4,4,4,4,4,5,6,7,4,4,5,,6,6,5,8,,,4,4,
   6,5,7,6,,4,,,6,7,,9,8,6,6,6,6,8,8,6,6,8,6,8,8,4,
   4,4,4,4,4,6,6,6,4,4,6,6,4,6,6,6,,,4,4,6,6,,4,6,4,
   6,6,6,6,,,,10,6,6,10,6,6,6,10,8,10,6,8,6,6,7,6,7,5,
   ,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,24,24,
   9,9,9,24,13,9,13,9,36,5,5,4,7,7,6,,4,5,6,11,6,,6,,,
   ,4,5,6,4,7,5,6,5,6,6,7,7,,7,,38,10,8,23,9,10,35,7,
   7,8,7,35,5,5,5,4,7,7,4,7,7,6,4,5,,6,,,4,5,8,6,11,
   6,6,5,11,6,,5,,,7,23,8,35,7,10,7,35,8,9,8,23,9,7,6,
   7,,6,5,5,4,7,5,5,8,8,,,5,6,7,7,,5,11,7,7,,7,,,12,
   12,7,20,25,25,8,20,8,7,11,6,29,29,5,7,,5,5,5,4,6,4,
   7,7,6,,,4,7,6,7,9,4,11,6,6,,6,,,,8,7,35,35,10,7,23,
   8,8,10,7,25,11,7,7,,7,6,7,,6,,7,,,,5,5,7,4,8,5,7,6,
   7,8,8,5,,9,,25,25,8,20,20,25,25,6,8,10,7,20,9,10,6,
   4,4,10,6,9,5,9,,,4,7,5,4,7,4,9,7,5,9,5,9,,7,,7,,8,
   27,7,27,8,7,8,5,7,,7,6,8,5,8,6,6,7,10,,,6,,6,6,42,
   6,6,,9,,9,,,,11,9,,43,16,8,,15,20,49,7,,,,5,9,9,,,6,,,,
   4,6,7,4,11,7,7,6,6,8,10,8,,13,,21,22,9,,15,,55,6,8,
   14,10,27,5,7,,6,,6,11,,,5,5,6,4,9,4,6,5,8,8,6,4,,9,
   8,10,35,8,9,23,38,10,7,7,39,7,12,7,8,5,6,,7,,,7,6,
   11,7,,6,7,6,,7,,6,,,6,20,8,25,8,25,7,20,10,20,12,12,
   10,9,6,10,9,10,,,6,4,10,4,12,6,5,4,6,5,6,4,,12,8,
   27,8,8,7,27,7,,5,7,47,8,8,,,10,,,,8,7,9,5,12,6,8,7,
   10,9,8,7,,11,,18,55,15,21,23,,24,9,9,39,10,60,,6,,,,5,
   5,6,4,11,4,6,5,7,6,6,7,,6,,20,11,7,16,16,20,11,7,9,
   13,6,13,7,9,,,5,7,7,4,11,5,6,5,9,7,9,4,,13,37,,55,
   9,15,,21,22,6,9,,10,15,8,,,,6,6,6,,11,6,7,,9,,9,,,7,,
   15,43,8,16,9,,12,17,13,35,15,,,6,6,8,5,11,6,10,8,10,
   8,9,7,,9,,,24,15,23,21,18,55,9,9,11,8,47,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,8,5,,6,,5,,9,7,
   9,8,10,7,38,7,10,31,23,22,9,10,7,7,,5,,7,7,,7,11,,,,
   8,25,20,11,7,12,10,12,25,6,11,20,6,,,7,8,,9,,8,,29,8,
   ,15,40,9,26,8,43,,57,,17,15,,6,6,7,9,10,9,10,,,8,7,
   10,,8,7,9,8,47,27,5,26,8,,,,,18,,,,,,44,50,,,,12,53,,,
   112,,,7,5,,6,,5,,17,8,16,9,11,9,20,6,13,13,16,11,13,
   10,,9,,9,,,50,,8,64,39,,9,16,15,27,30,7,15,,7,,7,,,,,8,,
   ,64,8,19,10,33,64,6,16,,8,6,7,,,7,40,15,64,8,30,9,39,
   ,29,28,16,15,8,9,,,18,8,47,55,18,9,23,15,,24,9,,24,7,,
   ,10,35,15,,9,49,8,43,,21,20,,15,,19,,11,15,22,21,8,15,
   9,,64,6,,55,,,,,,,,,,,,,,,12,,,,11,41,,,,,13,,34,,,17,,15,,,
   144,,9,14,,25,36,27,13,12,22,6,16,23,22,27,,28,36,22,,
   10,25,25,27,,25,25,36,,22,28,10,22,,16,13,36,19,19,6,
   12,22,27,28,26,27,10,6,18,25,12,6,26,27,28,13,18,22,
   36,,10,23,28,23,20,21,21,12,13,29,4,4,4,4,4,4,4,6,8,
   ,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,24,8,8,24,13,
   13,8,13,13,13,13,8,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,
   8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,13,13,8,15,12,
   15,13,8,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,
   ,9,,,,8,,,9,9,24,24,9,9,9,24,13,9,13,9,36,4,4,4,4,
   4,6,,3,4,5,5,5,6,6,,7,,4,4,,4,,7,,7,,4,,,,12,,14,7,
   8,21,5,6,21,9,7,7,6,14,4,4,4,4,,,4,4,4,4,4,8,,6,7,
   ,3,4,,5,,5,,7,,7,,6,,,12,21,8,21,8,6,6,14,7,5,7,14,
   8,4,4,4,,11,4,5,4,5,5,6,7,7,10,,4,4,,8,,6,,8,,7,11,,
   ,,,15,9,14,14,4,10,15,10,9,7,9,9,4,4,,6,4,4,4,7,4,
   6,6,5,,,4,4,,4,,4,,6,,,6,6,,,7,8,21,14,7,6,14,7,7,6,
   9,23,8,4,11,,4,4,4,7,4,,11,6,,,4,5,,4,,5,,7,,9,9,6,,
   ,13,14,14,15,9,10,9,9,7,4,10,9,9,11,11,5,4,4,,5,7,
   6,7,,,4,8,,4,,6,,8,,7,6,7,,8,,7,27,7,27,7,20,12,10,
   6,10,8,23,,6,9,6,9,7,6,6,12,,,6,7,,,,8,,10,,,12,,,,,12,
   ,,14,10,18,14,15,8,18,25,15,6,6,7,7,8,,,,11,,6,8,,6,,,
   ,,,8,12,12,,15,,,14,12,,10,15,47,18,9,15,10,25,4,4,,5,
   ,6,6,,,4,4,,4,,4,,7,,,6,6,,8,11,7,14,7,8,14,23,8,9,
   6,35,7,7,4,9,5,11,,6,,,4,4,,4,,4,,7,,,7,8,,,6,9,15,
   9,6,9,9,9,10,10,13,13,6,7,5,,10,10,7,,5,4,,4,,5,,8,,
   4,,6,,10,8,27,7,12,7,20,8,34,10,7,35,7,12,,,11,,,,,,,4,
   ,6,,10,,,6,,,14,16,12,36,10,,,,14,14,,61,8,,7,8,,,,7,6,
   ,6,,8,,7,,6,8,,,8,,11,11,7,10,10,10,13,14,11,20,5,20,
   6,7,,,7,,,6,,6,,9,,9,11,6,,47,16,12,36,12,11,,,15,19,
   10,20,22,12,7,21,,6,6,,,,6,,9,,8,,12,,,15,21,35,,15,13,
   16,,19,,22,90,11,11,,6,6,,6,,9,,,,6,,6,,15,,,10,15,,10,
   14,21,53,12,22,8,25,,7,,,7,,6,,9,,,9,,,,,11,,,,,,14,17,8,
   ,170,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,8,6,6,,11,8,8,
   7,8,7,23,7,7,35,14,35,5,8,,4,,5,,8,,,8,7,,15,15,6,9,
   9,9,9,13,6,13,9,10,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,5,,8,,9,
   10,10,,,10,7,12,34,11,8,7,11,35,22,9,32,7,,,,,,,,,,,,,,,,,
   ,,,,,,,7,,6,,11,,11,,10,7,13,15,10,5,19,19,10,15,11,19,,
   ,,,,,,,,,,,,,,,,,,,,8,12,,,11,,12,10,10,124,10,8,24,,66,,8,,
   ,,,,,,,,,,,,,,,,,,9,7,,,15,9,96,36,12,,,10,22,11,14,,14,,,,
   15,47,17,,12,8,10,,26,13,15,18,14,,,,14,15,14,,9,10,12,
   ,16,18,15,47,,,,,,,,,,,,,,,,,,,11,8,,,,,34,,36,,,11,,13,,,97,
   ,34,13,,14,10,25,18,6,16,12,10,24,23,15,25,15,17,9,6,
   12,9,27,19,46,14,9,17,25,24,15,12,9,6,10,18,10,27,16,
   12,6,16,18,15,14,18,10,4,6,9,13,4,14,18,21,19,6,24,
   17,25,10,,20,20,24,18,23,13,20,9,4,4,4,6,4,6,7,,8,4,
   6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,15,15,8,13,
   13,15,8,13,8,13,15,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,
   6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,
   7,4,4,4,5,5,8,,4,4,7,,7,7,8,,8,,4,4,8,6,9,7,,7,,,
   7,7,8,7,,35,8,7,35,7,7,32,7,7,7,7,35,4,4,4,4,7,7,
   4,5,5,,4,8,,,9,,4,4,7,7,8,7,,6,,,,8,,,6,35,7,32,7,7,
   7,35,7,7,7,31,7,5,3,5,,6,4,6,5,,6,6,6,6,7,8,4,3,
   6,5,7,4,,5,,,6,,6,7,7,6,6,5,5,4,6,6,6,6,4,5,5,4,5,
   ,8,4,4,4,,4,10,10,6,,8,4,5,6,5,7,4,,5,,,7,8,6,,,7,
   32,35,7,7,31,7,7,7,7,,6,5,6,,5,3,5,,4,,5,6,6,6,4,
   6,6,5,6,6,,5,,,,5,8,7,8,5,5,6,6,6,5,5,4,4,6,6,6,
   10,9,7,5,6,,7,8,7,8,,10,6,5,8,5,9,5,,5,,,5,,,,,8,34,
   8,39,7,32,7,7,8,8,6,,7,7,,5,,,,9,11,,13,4,5,6,,10,4,
   ,7,,,,,8,,10,8,,19,10,7,24,12,8,,8,23,12,8,5,,,10,,10,
   ,14,133,6,9,6,8,22,,,10,,,9,10,,,,29,10,11,,12,10,25,
   9,16,9,9,26,4,5,,7,,6,8,,8,4,4,,4,,4,,6,,,4,6,,7,8,
   7,64,7,7,31,,6,7,7,,7,8,5,,6,5,,9,7,8,5,3,6,5,7,4,
   ,5,,,5,9,7,7,6,6,6,5,5,5,6,6,6,6,4,4,5,,7,10,,10,
   9,,7,5,,6,,7,,8,,,,8,,,,71,8,7,16,32,6,,8,7,34,7,15,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,12,,11,9,7,4,9,5,11,4,,7,,,
   4,,6,4,6,7,7,5,7,7,7,7,7,7,7,4,7,10,8,,29,,,,7,11,
   12,,7,,,9,6,,13,19,20,35,9,13,,22,13,7,10,,11,12,6,,,
   8,5,8,8,16,6,,9,,,,,14,47,12,28,14,16,17,11,10,,7,10,
   11,34,13,,,8,5,11,8,17,9,,11,,,8,,,8,133,,15,16,29,15,
   9,18,9,12,10,9,21,6,,8,11,7,8,6,,9,,,8,18,,,,,,,,,,9,,
   7,,,,,6,17,10,10,10,,9,,,68,12,,,,,,,,200,9,,6,7,,135,,4,
   ,5,,7,,7,,,6,,,7,8,7,7,6,7,,7,8,,57,31,7,7,,5,8,6,,
   5,,,9,6,8,7,8,5,5,6,6,6,4,5,4,5,6,6,6,8,,,,11,,,,11,
   ,,,20,10,11,22,,7,14,22,32,,9,17,,7,,5,,,10,10,7,,10,
   13,7,,13,6,7,12,34,32,7,34,8,10,,,,,,,,,,,7,,,,,,,,,,,,7,,,
   ,9,9,8,9,7,5,7,7,7,4,7,7,7,7,7,7,,,,,,,,,,,,,,,,,,,,,,,
   8,,,8,,18,8,13,,7,7,17,34,34,7,7,38,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,7,,,,29,7,,8,,7,22,12,9,8,24,12,20,13,105,11,
   9,10,29,16,12,11,,19,9,10,25,7,6,,,,,,197,,,,,7,,7,,85,,
   8,,,,55,91,6,,7,,,9,,8,,,135,,9,6,,5,20,,23,6,7,6,7,
   23,16,30,26,17,18,7,6,5,5,18,14,40,5,5,18,26,18,18,
   5,7,6,7,23,20,16,13,6,6,7,18,18,11,18,6,4,6,5,4,4,
   11,18,18,7,6,18,18,26,6,18,17,19,14,18,18,4,7,5,6,6,
   7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,
   13,9,9,13,24,24,9,9,36,9,24,9,5,5,4,7,7,6,,4,5,6,,
   6,,5,,9,,4,5,6,4,7,5,5,5,4,6,8,8,,,,22,9,7,31,10,
   10,38,7,10,9,10,23,5,5,5,4,8,8,4,7,7,6,4,6,,6,9,,
   4,5,11,6,8,6,4,5,,6,,6,,,9,39,7,38,7,10,8,23,9,12,
   10,35,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,7,,5,11,
   7,6,,7,,,,,6,11,12,12,10,20,7,11,20,8,25,25,5,7,,6,5,
   5,4,6,4,7,7,6,,,4,7,6,7,8,4,,6,5,,6,11,,,9,7,25,23,
   8,8,35,7,10,11,7,35,10,7,7,,7,6,7,,6,,6,11,,,5,5,7,
   4,6,5,6,6,5,8,8,7,,,,12,12,7,10,20,25,25,8,10,20,8,
   20,10,9,6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,
   6,,,,5,26,9,47,8,,7,8,8,7,10,27,8,6,8,5,8,6,9,7,9,,
   ,6,,8,9,18,6,9,,8,,9,,,,18,9,,23,,15,55,9,18,24,8,47,
   24,11,7,6,6,,,9,,,,6,7,10,5,7,7,7,7,6,9,10,9,,,,28,
   16,9,,39,64,30,8,15,40,15,29,5,7,,6,,5,8,,,5,5,6,4,
   7,4,5,5,7,7,6,6,,,11,8,23,7,8,35,35,10,7,9,23,8,9,
   7,8,5,7,,7,9,,7,6,,7,,6,5,6,,7,,7,,,8,10,7,25,6,25,
   8,20,20,20,25,25,8,6,6,9,10,10,12,,6,4,10,4,8,6,4,
   4,9,5,9,5,,,12,47,8,7,5,,8,27,7,8,27,8,7,,,9,,,,7,7,
   9,5,10,6,7,7,10,9,8,9,,,,20,,8,,43,,49,9,15,35,15,21,
   11,5,,17,,5,5,6,4,8,4,5,5,7,6,6,7,,,,11,13,6,13,13,
   11,20,9,10,16,9,16,7,6,,,6,8,8,5,7,6,9,7,6,7,10,6,,,
   ,13,35,9,12,,43,16,8,15,,15,17,7,13,,,5,9,9,37,,4,5,,
   6,,6,,,11,,10,21,6,22,9,,15,15,,55,9,29,,6,7,8,5,8,6,
   8,8,7,6,9,7,,,,,17,8,,43,40,26,9,15,,15,57,,7,12,9,7,
   12,6,19,,13,,11,50,,,,13,,,,,,41,11,34,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,5,,7,,6,7,5,,6,11,6,,,7,8,7,10,7,35,8,9,23,35,
   38,10,7,8,7,12,5,,7,6,,7,11,,,,6,29,20,7,8,25,8,25,
   29,7,20,11,9,,,7,8,,10,,10,,,11,11,8,18,9,55,15,21,23,
   47,,24,9,,6,9,7,10,9,10,9,,,7,5,7,27,7,8,8,7,27,,7,,
   8,,,,,11,,,,,,9,14,,144,,17,15,,,,,,7,5,,6,,6,,,11,13,6,
   20,7,11,7,16,16,13,20,11,9,,8,,7,,,,,6,,15,,9,22,8,21,
   55,11,15,64,6,,7,,,,,6,16,19,33,10,,8,64,,8,,64,7,9,7,,
   ,11,14,10,,6,55,9,15,,27,21,22,8,8,6,,,42,7,,,20,15,
   43,8,16,,9,,49,8,,,12,39,10,,9,24,15,23,21,60,18,55,9,,
   ,,7,15,16,27,15,39,9,,,8,64,30,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   112,,12,,53,,,,,44,50,,12,26,23,22,10,10,6,13,23,25,20,
   27,28,36,22,6,12,29,22,27,21,12,25,36,27,13,28,12,22,
   6,13,22,26,19,23,6,10,10,,28,36,,22,,18,25,25,,36,,40,
   16,18,13,36,27,22,27,28,19,27,,21,25,16,25,8,8,5,6,6,,
   ,4,5,5,,5,7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,54,7,9,
   26,7,9,31,9,9,6,13,,8,8,8,6,,,5,6,6,,5,8,,9,,,4,5,
   8,5,7,5,8,7,8,,,9,,,,26,9,31,8,9,13,,6,7,7,,18,6,4,
   6,,8,5,6,4,,6,5,9,9,9,10,5,4,4,7,10,4,6,7,,,,,4,10,
   10,7,7,7,7,6,7,7,7,7,4,6,6,8,6,,9,8,8,6,,5,11,11,
   6,,8,5,6,6,6,10,5,8,5,9,,,8,8,,10,8,31,,7,13,,13,7,
   9,8,31,9,6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,,5,6,,,
   6,10,9,10,7,7,7,7,7,6,6,4,6,7,7,7,,11,5,4,4,,5,7,
   6,7,,7,6,7,4,4,8,4,10,7,6,,,,7,,,7,59,7,,6,28,8,7,
   9,7,8,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,6,,11,,27,
   ,8,,,6,11,,,9,8,,,11,,15,,,15,10,,,18,32,9,11,10,23,28,
   8,6,,5,,8,8,,,8,8,9,6,,5,9,7,,,,8,,,7,7,,13,6,,31,9,
   8,18,26,9,7,6,,6,7,,9,9,10,6,4,7,6,10,4,6,5,,,,,9,
   9,6,7,7,6,4,6,7,7,7,7,7,7,6,,5,,,,9,,5,4,,4,,5,6,5,
   ,,,6,,9,,,7,8,7,28,8,28,7,6,,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,7,8,6,7,7,
   8,8,7,8,7,6,7,11,7,118,14,,9,9,6,19,9,6,,11,,,6,,17,
   13,15,65,10,9,,44,13,17,14,,12,12,9,17,,7,5,7,7,13,6,
   6,,,,,6,14,118,19,,12,44,17,13,10,,9,12,15,65,14,11,,7,
   4,7,4,,6,8,7,,,,10,19,7,55,,7,7,33,15,12,14,8,8,12,
   8,23,9,9,10,7,,10,6,18,9,15,,,12,,,,10,,,,,,,,10,,,,,4,
   19,7,7,7,7,8,,,,13,,,,,7,203,103,141,10,,,7,,,,8,,6,,5,,
   5,,,,7,,9,10,6,13,9,9,31,9,7,26,,54,7,9,9,6,10,6,,7,
   8,,,6,10,9,10,4,6,7,7,7,7,6,7,6,7,7,7,7,55,,10,7,,,
   ,8,,11,,12,8,12,8,14,7,15,33,23,,7,8,,5,,7,11,,,10,7,
   ,8,7,8,28,7,8,7,6,,28,7,59,9,7,,,,,,,,,,7,,,,,10,,,,,,,,
   5,6,,,5,7,7,8,7,6,8,7,8,6,7,7,7,7,8,8,,11,,,,13,12,
   ,9,18,,,10,15,11,,32,,14,,9,,,,8,9,,8,14,9,29,9,9,9,
   29,62,8,14,62,,,,,27,11,10,23,18,9,32,10,,,28,,15,11,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,18,,,14,15,,11,,10,,,9,18,32,
   9,7,,,10,,,,141,103,160,,7,7,10,,,,,,,,,,10,,10,,,10,,,,,,,
   7,,,7,26,23,21,6,7,4,7,13,26,25,33,16,28,7,6,6,6,26,
   24,43,7,6,28,33,21,16,6,7,6,7,21,26,16,18,4,6,7,33,
   16,26,33,7,6,5,6,7,6,26,33,16,7,5,21,28,33,7,23,16,
   18,25,43,22,7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,
   4,5,4,4,4,4,4,,,4,,,,4,16,16,4,4,,4,4,4,16,16,4,4,4,
   ,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,16,
   16,4,4,,4,4,4,16,16,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,
   3,3,3,3,3,,4,4,3,,,12,12,12,12,3,11,12,3,3,3,11,12,
   3,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,
   16,16,4,,4,16,16,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,
   3,4,4,5,4,3,4,4,4,5,5,,16,16,4,,4,16,16,4,4,4,4,,,
   3,4,4,4,4,5,3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,20,,25,17,
   4,7,,5,4,4,25,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,
   3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,12,11,3,12,12,12,
   11,3,3,11,3,12,4,4,4,3,,,4,,3,2,3,3,4,3,3,3,,3,4,
   4,4,4,,12,3,4,11,4,3,12,3,3,4,4,11,,3,5,5,,5,,4,3,
   5,3,5,4,4,4,4,3,4,4,,4,,,5,4,16,16,5,,5,5,16,4,16,,
   ,5,,,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,7,4,17,25,,20,4,
   5,25,4,17,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,
   4,16,16,5,,5,5,16,4,16,4,,,,3,4,4,3,4,4,5,4,3,4,4,
   4,,5,,16,25,4,17,,25,16,4,4,7,5,,,5,,3,3,4,4,5,4,4,
   4,,4,,,5,18,,29,4,10,16,5,5,,5,4,5,10,16,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,14,5,5,,,,17,,16,,13,,
   17,4,4,15,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,4,,3,4,4,
   ,3,,11,3,3,11,11,3,11,12,11,12,3,11,4,3,4,4,,4,3,,
   4,4,4,4,,11,4,3,12,3,4,11,4,4,3,3,12,4,,,3,,,4,,,,5,
   ,16,4,5,,7,4,16,25,25,,4,20,,4,4,4,4,4,6,6,3,,,12,
   3,11,12,3,3,12,11,12,3,12,11,,18,,,4,,,,,,17,4,15,,15,
   4,17,,,23,19,,,3,4,4,,,5,5,,16,4,5,,5,4,16,16,16,5,5,,
   ,4,,,,5,5,,16,5,5,,5,5,16,10,10,4,4,20,4,4,,,5,5,,
   16,4,5,,5,4,16,16,16,5,5,,3,4,4,14,4,,24,4,4,11,8,
   3,14,,6,8,4,11,4,4,4,,,12,8,6,20,4,8,12,4,4,3,,12,
   3,5,,,46,5,,55,4,4,55,,9,5,9,46,5,,,46,5,,55,4,4,55,,
   9,5,9,46,4,,,15,4,17,,19,,23,15,,4,17,,,16,,17,4,17,,
   15,13,4,,17,,,,,,,,,,,,,16,60,12,58,12,,12,16,44,37,,12,
   60,7,4,12,3,4,9,8,27,16,4,8,27,9,7,3,4,12,16,37,,
   44,58,12,12,,7,25,8,10,4,3,12,16,4,3,7,10,60,16,12,
   58,60,12,4,12,7,58,8,7,25,4,16,16,4,4,4,,,3,4,4,4,
   4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,16,16,4,4,,4,
   4,4,16,16,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,
   ,4,5,,5,16,16,,4,4,16,16,4,4,4,,4,4,,,4,4,4,4,3,,,4,
   ,,3,4,4,4,4,4,4,3,4,,,4,5,,5,16,16,,4,4,16,16,4,4,
   4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,3,3,3,3,4,3,3,4,,4,
   3,,,12,12,12,12,3,12,11,3,3,3,12,11,3,4,4,4,4,4,,,,,,
   3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,4,9,46,5,4,5,46,9,
   4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,4,9,
   46,5,4,5,46,9,4,4,,3,,,3,,,3,3,3,3,3,3,3,2,4,4,,3,,
   ,3,11,12,12,3,12,12,12,3,3,11,12,3,3,4,4,5,,5,5,,4,
   3,5,4,5,4,3,3,,4,,4,,,4,,4,16,4,16,4,,4,4,16,16,4,
   4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,16,4,16,4,
   ,4,4,16,16,4,,,,,,,3,3,3,3,4,3,3,3,4,4,,4,13,,4,24,
   6,12,4,8,,14,3,4,8,12,4,3,,,4,,3,2,3,3,4,3,3,3,4,3,
   ,4,4,,4,14,4,11,4,4,4,14,4,4,4,11,4,,4,,,3,4,4,4,
   4,4,4,3,5,3,,4,,,5,16,25,17,4,,25,17,4,4,7,,5,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,3,5,,18,,5,
   16,10,5,4,35,4,5,5,16,10,,3,4,4,4,4,4,4,3,5,18,,5,,,
   ,17,,,23,23,,17,4,4,15,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,
   4,3,3,,3,,3,,,3,11,3,11,3,11,3,12,12,12,12,11,3,4,4,
   4,4,,3,3,,,3,4,,4,11,4,12,3,3,4,11,4,4,3,12,3,,,,4,
   4,,5,,5,,,5,16,4,,5,7,4,17,25,25,,20,4,,3,4,4,5,5,,
   5,5,,5,16,4,,5,5,4,16,16,16,5,,5,,14,,,5,,,,,,17,4,,
   14,15,4,17,,,13,,15,4,4,5,5,,5,5,,5,16,4,,5,5,4,16,
   16,16,5,,5,,3,,,,4,,,12,4,12,,3,4,11,8,8,4,14,6,3,3,,
   ,3,,,12,3,12,11,3,3,11,12,12,3,11,12,4,,4,,,4,,5,16,
   4,25,4,17,,7,25,16,4,,4,5,,5,16,10,29,4,4,10,16,5,5,
   5,,5,,,,,,,,,,,,,,,,,4,,,,5,16,25,4,4,20,,7,4,16,25,,4,,
   14,17,4,,16,,13,17,,17,4,,,,,,,,,,,,,,,17,17,,4,15,,15,17,
   4,17,,16,,27,44,12,,12,16,58,,45,27,8,8,4,12,3,4,10,
   45,8,16,16,60,12,58,25,12,,12,4,9,60,10,9,3,12,4,12,
   60,7,7,4,12,3,16,4,3,8,27,8,16,12,37,,27,4,7,25,9,
   11,34,10,16,4,16,4,3,,5,4,4,3,5,4,4,4,4,,5,3,4,3,
   4,5,3,5,4,4,,4,,4,,,4,,16,16,4,,4,4,4,4,16,16,4,,,3,
   3,3,3,3,,4,4,6,6,2,3,3,3,4,3,3,3,3,4,4,,4,6,6,4,
   4,4,4,3,4,4,3,3,3,4,4,,5,4,4,3,5,4,4,4,4,,5,3,4,
   3,4,5,3,5,4,4,,4,,4,,,4,,16,16,4,,4,4,4,4,16,16,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,,,,7,,3,3,4,4,5,
   4,4,4,4,5,3,,4,,,30,5,,,4,5,30,4,4,4,8,8,4,3,,4,,4,
   4,,4,3,3,3,3,4,2,3,3,4,4,3,,,4,4,3,12,4,4,11,12,3,
   3,3,11,4,4,4,,3,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,
   4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,4,6,6,4,,3,2,4,3,
   4,3,3,3,4,3,4,,,4,4,12,3,4,4,11,3,12,3,3,11,4,4,,,,,
   ,6,4,3,4,4,6,3,4,4,3,5,4,,14,5,5,5,7,5,5,8,,4,4,
   5,8,5,5,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,
   4,4,4,5,5,5,5,4,4,4,4,4,16,6,3,3,3,3,4,3,3,3,4,
   4,4,,,6,6,4,8,4,4,,8,4,3,3,6,6,6,3,6,,4,3,4,4,6,
   4,4,4,,4,,,6,19,19,,5,10,10,6,5,,5,5,6,10,10,6,,4,3,
   4,4,6,4,4,4,,4,,,6,19,19,,5,10,10,6,5,,5,5,6,10,10,
   6,4,6,4,5,6,4,7,5,6,,5,,,,,5,,,,14,,5,5,5,15,,,4,4,
   6,5,6,6,5,5,6,5,,,,,,,5,,,15,5,,5,5,16,,,3,,4,,3,4,4,
   ,3,3,,,4,4,3,3,4,4,11,3,3,12,12,11,4,4,3,4,6,3,,4,
   3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,4,16,,4,4,,3,,,
   ,6,6,4,3,6,6,6,3,4,8,8,,4,4,,4,,3,5,5,5,,4,,,4,4,
   16,16,4,4,4,,,4,16,16,6,,,,7,7,,,,,5,5,,,15,5,5,,,14,,,
   4,4,3,3,,,4,6,6,4,3,6,6,4,3,4,4,4,4,6,6,,5,,5,,4,,
   ,4,5,,,4,5,4,30,30,4,8,8,5,5,5,,4,,,4,4,16,16,4,4,
   4,,,4,16,16,4,4,,14,5,5,5,5,5,5,8,4,4,,7,8,5,5,4,,
   4,,,4,30,8,8,4,30,4,5,5,4,,,,4,,,30,4,,,4,4,30,5,5,
   4,8,8,,,,,,,,,,,,,,,,4,4,14,14,4,4,,16,16,12,16,,4,4,3,,,
   ,,4,,,,,4,,,,,,,4,,,,,4,,,4,20,20,9,4,6,4,4,9,20,20,20,
   20,8,6,4,4,4,9,20,20,3,4,20,20,13,20,3,4,4,4,20,20,
   13,20,3,4,4,7,8,8,7,3,3,3,4,4,4,8,20,20,4,4,9,20,
   20,6,7,20,20,8,20,20,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,
   4,4,4,4,4,3,4,,,4,5,,5,16,16,,4,4,16,16,4,4,4,,4,,
   5,4,4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,
   16,16,4,,4,4,4,4,16,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,4,4,4,3,,,,,,3,4,4,4,4,4,4,3,4,,6,5,5,,,25,17,17,,
   4,16,25,4,4,5,,7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,
   4,,,4,4,,16,4,16,,4,4,4,16,16,4,4,,4,,,4,,5,4,4,4,4,
   5,3,4,3,,,4,4,,,4,4,,16,4,16,,4,4,4,16,16,4,4,3,6,
   6,4,,,3,3,4,3,3,3,3,2,4,,4,3,,,3,12,11,12,3,12,12,
   12,3,3,12,11,3,,,,,,5,4,4,4,4,5,3,4,3,6,,4,5,18,,5,
   4,35,16,5,10,,5,5,4,10,16,5,4,4,,,4,3,3,3,3,4,2,3,
   3,4,,3,4,4,,4,4,14,11,4,4,14,4,4,4,4,11,4,3,4,,,4,
   4,4,4,5,4,4,3,,,,4,,,5,9,46,55,4,,55,,4,5,9,46,5,4,,
   ,4,4,4,4,5,4,4,3,,,,4,,,5,9,46,55,4,,55,,4,5,9,46,5,
   ,,3,3,3,3,4,3,3,3,4,,4,4,4,,14,,14,12,8,4,24,6,4,
   3,4,11,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,
   18,5,,,,,17,,23,23,17,,4,4,15,,19,4,,4,,3,4,3,,,3,3,,,
   3,3,11,11,3,12,12,3,12,12,12,12,3,4,3,,4,,4,5,,5,5,
   5,,5,4,16,,4,4,16,4,16,16,4,,4,4,14,,4,3,,,,3,,,4,4,
   11,24,4,6,12,4,8,8,,12,3,,4,,4,5,,5,5,5,,5,4,16,,4,
   4,16,4,16,16,4,,4,4,,,,,5,,,,,4,17,,15,19,17,4,,,23,,
   23,4,3,3,,,3,4,,4,4,11,14,4,4,11,4,4,4,4,14,4,,5,,5,
   ,5,,,4,17,20,,4,16,4,25,25,5,,7,3,,3,,3,,,3,12,11,12,
   3,11,3,12,12,3,12,12,,4,4,,,4,5,,16,4,25,17,4,,7,25,
   17,4,,,,,,,,,,,,,,,,,,4,5,,5,10,16,,5,5,16,10,5,5,4,35,
   4,4,,,5,,16,25,4,20,4,,7,4,17,25,,4,15,,17,4,,,23,23,
   19,,17,4,,,,,,,,,,,,,,23,,17,,4,,19,15,23,4,17,,16,60,12,
   9,12,4,3,4,9,44,8,12,60,60,,12,12,16,44,,27,16,16,,
   27,44,60,12,,12,4,44,8,9,9,3,12,4,27,8,8,12,4,12,3,
   16,16,12,60,12,60,4,3,9,60,12,4,12,60,9,8,27,8,16,4,
   16,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,
   ,16,16,4,,4,16,16,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,
   4,4,4,4,3,4,,,,5,,7,,,30,5,4,8,8,4,4,4,30,5,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,
   4,4,4,3,,5,5,16,16,4,4,,16,16,4,4,,4,4,4,4,3,,,3,6,
   6,3,3,3,3,4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,
   3,4,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,16,
   16,4,4,,16,16,4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,
   4,3,,5,7,8,8,4,5,30,,,4,4,30,4,5,,3,,6,6,3,3,3,2,
   4,3,3,3,3,3,3,3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,,5,
   8,8,30,4,5,,,4,4,5,30,4,,,3,4,4,3,4,4,5,4,3,4,4,4,
   7,5,,,,4,30,5,8,8,4,4,5,4,30,3,4,4,5,4,4,4,5,4,6,
   19,19,6,,,,,,,,,,,4,4,,,,4,4,5,4,4,4,5,4,6,19,19,6,,,,,,
   ,,,,,4,4,,,,4,,3,,4,4,3,,4,4,3,,4,4,4,4,3,3,12,4,4,
   11,11,12,3,3,,4,4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,
   4,4,5,5,5,4,14,,6,4,,,,4,,6,6,5,5,5,5,7,5,5,8,8,,
   4,4,,4,4,3,4,6,6,4,4,,4,4,4,12,3,3,4,4,11,11,3,12,
   3,4,14,,,6,6,,,,,4,4,14,14,16,4,4,,,12,16,16,,4,4,,,4,
   6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,,4,
   5,5,8,8,5,5,7,3,4,4,,4,4,,4,4,3,12,3,4,4,11,11,3,
   3,12,4,4,3,16,6,4,6,6,4,3,8,4,4,,6,8,4,3,3,4,6,,
   6,10,10,,5,5,10,10,6,6,5,,5,4,6,,6,10,10,,5,5,10,10,
   6,6,5,,5,4,6,16,6,6,4,8,3,4,4,,6,3,4,8,6,6,,,5,5,,,
   ,14,15,,5,5,6,,,,5,5,,,15,14,5,,5,,,5,,5,,,16,15,5,5,,
   3,20,20,20,4,4,3,4,13,20,20,20,20,20,4,4,3,4,13,20,
   20,4,4,20,20,9,8,4,6,4,4,20,20,9,9,4,4,6,20,20,8,
   7,6,4,4,3,4,3,20,20,20,4,3,20,20,20,3,7,8,9,8,7,8,
   4,4,4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,6,,
   5,,,6,,51,21,5,,6,6,6,5,51,21,5,4,6,6,5,,6,,,,4,5,6,
   4,5,6,6,5,4,5,6,5,7,7,,51,21,6,,6,21,51,5,5,6,6,,
   4,4,,3,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,16,
   16,,5,5,5,16,4,16,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,,
   4,3,4,4,4,,3,12,4,11,4,12,3,3,3,4,4,11,6,4,6,4,6,,
   ,3,3,4,2,3,3,4,3,3,3,3,3,,3,,11,12,3,12,12,11,12,
   3,3,12,3,11,,,6,,,7,6,5,6,4,7,4,6,5,6,5,4,5,,5,,6,,
   5,21,51,,6,6,6,51,5,21,,4,,,5,4,4,4,3,5,3,5,4,4,4,
   3,4,,4,,5,,4,16,16,,5,5,5,16,4,16,4,3,,,4,4,4,3,5,
   4,5,4,4,4,4,4,,5,,,55,4,55,,46,9,5,4,9,5,46,4,,,3,
   3,3,3,4,3,4,3,,4,,4,4,14,,6,20,8,12,4,12,,3,4,4,8,
   11,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,55,4,55,,46,9,5,
   4,9,5,46,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,5,
   14,5,,,,,17,17,,17,17,,4,4,15,15,,4,,3,,3,6,4,,4,3,4,,
   3,,3,11,3,11,12,11,3,12,11,12,3,12,4,4,,4,,3,4,,4,,
   5,5,,4,16,4,,4,16,4,16,16,4,4,,3,14,,6,4,,4,,4,,4,,
   4,11,4,24,6,11,4,8,8,,3,12,,3,6,4,4,6,4,6,3,,,3,12,
   12,11,3,12,3,11,12,3,12,12,4,,,,,4,,,,,4,17,14,,17,17,
   4,,,13,16,,6,4,3,4,,4,4,4,,4,11,4,14,4,11,4,4,4,4,
   4,14,,6,,6,,7,7,,5,21,6,,6,21,5,51,51,6,6,,4,,4,,5,5,
   ,4,16,4,,4,16,4,16,16,4,4,,4,3,4,14,4,,4,24,4,11,8,
   14,3,,6,8,4,12,4,3,5,,,5,46,9,46,5,55,4,,9,4,,55,4,
   4,,,8,12,,14,3,12,8,4,4,4,6,24,5,,,5,46,9,46,5,55,4,
   ,9,4,,55,4,,14,,4,17,,,15,13,15,,4,17,,23,,,17,4,,15,
   15,23,4,,17,,,,,,,,,,,,,16,8,27,9,12,4,3,4,10,9,60,27,,
   25,,12,12,16,58,60,12,16,4,45,8,10,8,3,4,12,16,,45,
   58,44,12,12,,34,10,11,7,4,3,12,16,16,12,25,27,,4,3,9,
   8,27,4,7,8,37,7,12,60,4,16,16,4,4,4,4,4,,,,,,3,4,4,
   4,5,4,4,4,4,,,,5,,,55,,55,,4,9,46,5,4,5,46,9,,4,,5,,
   3,5,,5,4,4,4,4,5,3,4,3,,,4,,,18,5,5,,10,5,16,29,4,
   4,5,16,10,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,,,4,,19,19,6,
   5,,10,6,10,,5,5,5,10,10,6,4,4,6,6,6,,,3,3,4,3,4,3,
   3,3,4,,4,,,13,4,12,,8,4,12,6,20,4,3,12,8,4,,,,,,6,4,
   4,4,4,6,3,4,4,,,4,,19,19,6,5,,10,6,10,,5,5,5,10,10,
   6,5,6,,,6,4,3,4,4,6,3,4,4,,,4,,5,14,5,5,,8,5,5,9,
   6,6,5,5,8,5,,5,,,4,4,4,4,5,4,4,3,,,,,,68,7,,,39,5,,
   23,8,4,5,9,66,7,,,,4,4,4,4,5,4,4,4,,,,,,,,36,,28,18,
   18,36,,5,5,16,28,18,,,4,3,4,4,6,4,4,4,,,,,6,44,20,,,
   36,11,6,9,,6,4,6,29,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,6,5,
   6,6,5,5,6,,71,,,,,,,,27,19,10,,6,5,18,,,4,,4,,3,4,4,,,
   3,,,14,4,3,,8,4,12,6,4,20,12,12,8,4,4,,,4,,5,5,,5,,5,
   ,7,4,,30,5,4,8,4,8,,4,30,5,4,24,,4,4,,,,,,14,6,4,,
   16,6,6,6,6,16,8,,8,4,,4,3,,5,,5,,5,,,4,,55,,4,9,5,
   46,55,5,46,9,6,,,,,7,,,,,5,,,31,23,10,6,,,22,,,4,4,3,,,,
   4,18,6,4,,10,6,4,6,6,6,4,4,10,6,,5,,5,,5,,,4,,55,,4,
   9,5,46,55,5,46,9,5,,5,,4,,,4,,21,17,4,7,5,,20,4,21,
   17,,4,,44,20,6,5,,11,6,18,9,5,,7,30,11,6,,,,,,,,,,,,,,,,,,
   ,5,,,42,,,,5,9,50,7,5,4,14,8,,,,,,,,,,,,,,,,19,5,15,,11,
   5,,23,18,20,17,,11,5,,,,,13,14,,,,,18,,,22,,,,5,,,,25,5,,,
   ,24,11,9,8,,4,4,10,26,14,,,,,,,,,,,,10,48,24,20,27,8,
   31,10,5,115,36,30,12,4,10,5,16,8,10,8,4,8,4,8,8,8,
   11,66,49,6,4,11,20,71,,11,19,81,8,28,12,10,5,,4,,,5,,
   5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,,25,16,4,,17,16,25,
   4,4,,5,7,4,4,4,,,,6,16,3,3,3,3,4,3,3,3,,4,4,4,6,6,
   ,8,4,4,,4,4,8,3,3,6,6,6,3,,,5,,,,4,4,5,3,5,4,4,4,
   4,4,4,4,,5,,46,9,4,,55,,55,4,5,46,5,9,,,5,,,,4,4,5,
   3,5,4,4,4,4,4,4,4,,5,,46,9,4,,55,,55,4,5,46,5,9,,5,
   ,7,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,49,7,4,,,7,49,5,5,
   8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,5,4,4,4,,,,,
   7,71,,23,8,39,,5,,,5,4,7,50,9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,5,6,4,5,6,6,5,6,20,9,7,,,,,,24,,31,,,5,5,,,,13,14,
   19,14,19,19,19,18,28,44,,68,,,,,,,,,13,,14,18,,,,4,,3,,4,
   4,4,,4,4,4,,4,,8,4,3,,14,4,8,11,11,24,4,6,,4,5,,,5,
   4,,3,5,6,6,,8,5,4,,4,5,8,5,5,5,5,7,4,44,,,,,,,,,6,,
   11,6,5,,7,6,11,30,36,,5,9,,4,4,4,4,6,6,6,4,,,8,4,14,
   ,3,4,8,11,12,4,24,6,19,19,,,6,9,,,,,11,5,15,,17,5,11,,
   ,24,16,29,3,,4,,,,6,6,,10,6,5,,5,6,10,10,10,6,6,12,,
   4,,,,6,6,,10,6,5,,5,6,10,10,10,6,6,12,4,5,6,,5,5,,
   10,5,5,,5,5,10,16,16,4,4,35,4,4,4,28,6,,16,6,4,,8,
   4,8,,6,16,6,6,,5,6,,,30,11,9,,5,11,18,6,6,5,,7,,6,,,
   31,6,,,4,6,31,6,6,5,9,9,5,,,50,7,,,5,5,42,,9,4,8,23,
   6,,,31,5,,,,,26,15,,6,10,,,,,,5,35,,19,26,6,,10,,,,,,,,,,,,,
   ,24,,39,16,31,8,10,20,23,54,11,,16,5,16,4,5,30,48,67,
   ,4,11,24,10,10,4,7,8,,,,,,,,,15,47,12,9,7,4,8,,5,4,
   49,49,105,10,8,45,24,48,4,13,10,15,8,13,14,6,8,8,4,,
   4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,16,4,16,,4,4,
   4,16,16,4,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,
   16,16,4,4,,16,16,4,4,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   ,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,16,16,,5,5,5,
   16,4,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,
   ,4,,,4,7,,25,4,17,20,,4,5,16,25,4,,,4,4,4,3,5,3,5,
   4,4,4,3,4,,4,,,20,4,25,17,,7,5,4,16,4,25,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,4,5,3,4,4,4,3,5,5,13,4,,,,,17,16,13,,17,,
   4,4,,14,17,3,,4,,4,,4,,,4,4,,5,5,4,16,4,4,,16,4,16,
   16,,4,4,,4,,4,,4,,,4,4,,5,5,4,16,4,4,,16,4,16,16,,4,
   4,4,18,,3,4,,,,4,,5,5,5,16,4,4,35,16,5,10,10,,5,5,,
   3,4,3,6,6,4,4,,,3,3,12,12,3,11,12,3,12,11,12,12,3,4,
   ,,,,4,,,,,4,17,15,15,,17,4,,,,17,17,4,3,4,4,,3,,4,4,4,
   11,4,4,14,11,4,4,4,14,4,4,,,,4,,,5,,4,16,4,,20,16,4,
   25,25,,5,7,4,4,3,,,3,,3,11,3,12,11,12,3,11,12,12,3,
   12,3,4,4,,,5,5,46,9,5,46,55,4,,9,55,,4,4,4,,,5,5,46,
   9,5,46,55,4,,9,55,,4,3,,,4,8,12,,3,14,12,8,4,4,24,6,
   4,,4,14,4,14,4,8,11,12,3,,6,12,4,8,,,,,,,,,,,,,,,4,15,,,
   4,17,,23,23,15,17,,4,13,,4,,17,,15,14,15,17,4,,16,8,7,
   37,12,4,3,4,58,10,11,27,25,,,12,12,16,,45,34,4,16,60,
   12,9,8,12,4,3,16,58,7,10,9,12,3,4,12,60,60,27,,12,
   12,16,16,12,,27,25,4,3,44,8,7,4,27,8,9,45,8,10,16,
   16,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,16,4,
   16,4,,4,4,16,16,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,19,19,
   6,5,,10,6,10,,5,5,5,10,10,6,4,,,6,6,4,3,4,4,6,3,4,
   4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,,4,,7,4,4,
   4,4,5,3,4,3,,6,5,4,,,4,5,30,,4,,30,5,4,4,8,8,4,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,6,,4,3,4,4,6,3,4,4,,4,5,6,5,5,14,
   ,4,5,8,5,5,7,5,4,5,5,8,6,5,6,5,5,6,4,6,4,,,5,6,,,
   ,5,,,15,,,5,5,5,,,14,5,4,7,5,6,6,4,4,,5,,6,,,,,5,,14,
   ,5,,5,5,,,15,4,,3,,4,4,4,,5,5,5,,,4,4,4,16,4,16,4,4,
   ,,16,16,4,4,4,6,3,,3,,,3,3,6,6,4,3,4,4,3,4,4,3,4,
   4,4,4,3,,,,4,4,,5,,5,,,4,5,4,8,4,8,4,5,30,30,,,4,,4,
   4,4,,5,5,5,,,4,4,4,16,4,16,4,4,,,16,16,4,6,16,,,7,7,,
   ,,,5,5,,16,,5,5,,,,,15,3,3,,3,,3,6,6,4,4,3,6,4,6,3,
   4,4,4,6,6,4,,,,3,,6,6,,3,4,4,,4,4,3,8,8,6,6,6,,3,3,
   ,4,4,,3,3,4,11,4,3,3,12,12,4,4,11,,,,,,,,,,,,,,,,,,,4,4,
   ,,4,4,30,8,4,8,30,4,5,5,,,4,4,,,4,30,4,,4,,4,30,5,
   5,8,8,4,5,5,14,5,5,5,8,5,4,4,,7,5,5,8,3,4,,,,4,,,,,,
   ,,4,4,,,,4,,,,,,,,4,12,16,4,,4,14,16,14,16,4,4,,4,20,
   7,20,4,6,4,4,13,13,8,20,8,20,6,4,4,4,20,20,7,4,3,
   20,20,20,20,4,4,3,4,9,8,9,9,3,3,3,20,20,20,20,4,4,
   3,4,4,4,20,20,8,4,4,20,20,7,6,20,20,9,20,20,8,3,4,
   4,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,46,9,4,,55,,55,
   4,5,46,5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,
   4,16,16,5,,5,5,16,4,16,6,6,,,5,6,6,4,5,5,6,4,5,6,
   5,4,,7,7,21,51,6,6,,51,21,5,5,,6,6,6,7,,5,4,6,6,7,
   5,4,4,,6,,6,,,5,,6,51,5,21,6,,6,6,21,51,5,7,,5,4,6,
   4,7,5,6,6,5,4,5,6,,5,,,6,5,51,21,6,,6,6,21,5,51,,4,
   4,5,3,4,4,4,3,5,13,5,4,,,,17,,17,17,,,17,4,4,,16,13,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,16,4,5,5,,
   4,16,16,16,,5,5,6,3,4,4,,3,4,,4,3,,4,4,11,4,3,3,12,
   4,11,4,4,12,3,3,6,,,6,6,,6,,6,,7,7,21,5,6,6,,5,21,
   51,51,,6,6,,4,3,3,6,4,6,4,,,3,12,3,11,3,12,3,12,12,
   11,11,12,3,,14,,,4,,,,,,17,4,19,23,,4,17,,,,19,15,4,4,,
   4,,4,,5,5,16,4,5,5,,4,16,16,16,,5,5,,4,,4,,,4,,11,4,
   3,,12,4,11,8,8,14,4,6,4,3,4,,,3,,11,3,3,11,12,3,12,
   11,12,11,3,12,4,3,4,,,5,46,5,,4,55,4,55,,9,46,9,5,4,
   3,,,4,12,8,6,4,20,8,12,4,4,12,,3,4,,,5,46,5,,4,55,4,
   55,,9,46,9,5,,4,14,14,4,4,8,11,3,12,,6,11,4,8,,,,,,,,,,
   ,,,,,4,,16,,4,17,17,,17,13,17,,4,,19,4,,17,19,,23,15,
   17,4,,16,45,34,,12,,12,16,,20,25,8,10,45,4,12,3,4,20,
   7,7,4,16,8,27,9,10,12,4,3,16,9,25,8,10,12,3,4,27,,
   25,34,,12,12,16,4,3,45,8,10,16,12,,45,34,4,34,10,10,
   25,7,7,16,16,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,4,4,4,6,3,4,4,,,,,19,25,6,9,,36,6,11,,,
   4,6,11,30,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,4,7,4,6,6,5,5,6,5,28,6,,,,,10,22,,,,,5,6,,16,39,,,
   4,,4,3,,,,4,,,5,,5,9,4,,55,,4,55,46,46,5,9,,4,,4,,5,3,
   ,4,5,,5,7,4,8,4,5,30,,4,,8,30,4,5,4,71,,,,,,,,,5,,7,
   9,4,8,23,,5,39,66,,5,,,3,4,4,6,6,4,6,14,,4,4,6,12,
   4,8,,3,14,24,8,12,4,6,,,,,6,,,,,6,10,16,,,,5,,,,21,35,
   4,4,4,4,,4,18,4,6,6,6,4,6,10,,4,4,6,10,4,6,,,,4,,,5,
   ,5,9,4,,55,,4,55,46,46,5,9,6,5,4,,,4,,5,7,4,17,21,,
   4,20,,21,4,17,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,4,5,
   71,,7,4,14,9,7,50,,5,,8,42,,5,4,28,,6,10,6,,4,8,,8,
   4,6,10,6,6,44,6,20,6,9,6,11,18,,4,,,50,6,11,19,,,,14,
   13,,,,,,,18,,5,20,23,,5,11,,15,17,24,11,,5,,,5,,,,22,28,,
   ,5,,8,10,48,20,,,4,6,45,10,74,19,69,48,,8,8,8,175,14,
   67,5,10,,8,9,8,8,4,4,,,14,14,30,10,4,5,,25,24,24,31,
   8,10,,,,,,,4,4,30,10,11,,25,9,12,17,13,48,10,,5,4,,,7,
   4,4,4,3,5,3,5,4,4,4,3,4,,4,,7,49,4,,,49,7,5,5,8,4,
   8,,6,,4,3,4,4,6,3,4,4,,4,,,5,14,5,9,6,8,5,5,5,,5,
   6,5,8,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,4,6,4,7,5,6,
   18,4,6,,,,6,,20,,,,6,6,6,,20,,5,4,7,4,6,6,5,5,6,4,
   18,6,,,,,6,20,,,6,,6,6,,18,,4,,4,,4,,3,,4,4,,,4,,5,5,
   4,16,16,5,5,,,16,4,16,4,3,6,3,,4,4,,3,4,6,4,6,4,6,
   3,4,4,6,4,6,6,4,3,4,4,,,6,,,4,,,,4,,7,5,4,8,8,5,7,
   49,49,,4,,,3,4,4,6,4,4,6,4,,4,4,4,11,4,4,4,4,14,14,
   4,11,4,6,,,,6,6,,,,,6,6,18,,,6,6,,,,20,,4,4,4,3,,4,6,
   4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,,4,,5,7,4,,,7,5,
   49,49,8,4,8,,4,4,,,4,,5,5,4,16,16,5,5,,,16,4,16,4,4,
   3,19,6,19,6,6,6,10,10,5,5,,12,10,6,10,3,4,6,,6,4,
   10,6,6,6,10,4,6,6,4,,4,4,6,,6,10,4,,4,4,4,10,6,6,
   6,6,6,19,6,19,6,6,6,10,10,5,5,,12,10,6,10,4,3,,,4,,,,
   ,,,,4,,4,18,16,,4,4,16,14,18,14,4,,4,,,4,,,,,,,,4,,6,9,
   28,28,4,9,4,6,19,10,19,8,19,19,9,4,4,6,28,9,28,4,4,
   9,8,10,9,3,3,3,3,28,19,19,28,4,3,4,28,19,19,28,4,3,
   4,6,6,4,19,8,19,6,4,28,9,28,9,28,9,28,19,8,19,4,3,
   4,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,9,46,55,4,,55,,4,5,9,
   46,5,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,55,4,55,,46,9,
   5,4,9,5,46,,18,19,19,14,19,14,19,14,71,,25,16,,,,13,,,,,
   ,,18,14,,,,5,6,6,4,5,5,6,4,7,,19,6,,,,,,24,31,,,,5,5,,,
   ,,,4,,5,,4,,3,5,4,,5,5,5,10,5,5,,10,5,16,16,35,4,4,
   3,4,19,,,4,,,,4,,6,6,6,10,5,5,,10,6,10,10,,5,5,4,19,,
   ,4,,,,4,,6,6,6,10,5,5,,10,6,10,10,,5,5,,4,4,3,6,6,
   6,4,,,4,4,8,12,3,,8,4,12,11,6,24,4,5,44,,,,6,,,,,5,
   11,19,21,,11,5,,,35,17,18,,4,5,6,,4,,6,6,5,8,5,5,,8,
   5,5,5,9,6,6,,,,,,,6,,6,11,4,,,11,6,36,30,,6,9,4,4,4,,
   ,4,,4,8,3,12,,8,4,11,11,6,4,24,,5,4,,,5,7,50,,5,,39,
   5,,9,23,8,4,,4,,,5,16,28,30,5,,28,18,18,18,36,,5,4,,,
   6,11,30,,4,,36,11,6,6,9,,6,,6,28,6,16,4,8,,8,4,,6,6,
   6,16,,,,,,,,,,,,,,,6,,,,5,,,27,19,26,10,,6,39,,5,,,,,18,15,
   10,6,,,11,15,,16,5,4,5,43,80,35,24,47,,31,16,8,10,202,
   17,20,4,,24,11,9,9,8,,4,,39,16,10,13,8,4,,,,,,,,,,10,8,
   48,24,25,5,4,115,36,70,4,19,8,11,14,13,8,8,8,6,6,,4,
   3,4,4,6,4,4,4,,4,,,6,19,19,,5,10,10,6,5,,5,5,6,10,
   10,,5,6,5,5,6,4,6,4,,68,,6,,,,10,,,19,27,,,5,6,,,22,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,5,,5,,,4,7,5,25,4,16,4,
   ,20,,17,25,4,4,4,6,4,,3,,,,3,6,16,4,6,6,8,3,4,4,,4,
   6,4,8,3,3,,,4,4,,5,,5,,,5,9,5,46,5,9,4,,55,46,,55,4,,
   ,4,4,,5,,5,,,5,9,5,46,5,9,4,,55,46,,55,4,,24,,,7,,,,,,
   10,6,,18,,5,,,,47,,15,4,4,,5,,5,7,,5,8,4,49,5,7,4,,,
   8,7,49,5,,,,,,6,16,,6,6,8,,4,4,,8,16,6,16,6,,3,,,4,14,
   ,6,4,8,11,4,3,,12,20,4,8,12,,,,,,,,,,,,,,,,,,,,4,,,5,9,
   66,23,4,8,39,,5,7,,,5,,,,,,,,,,,,,,,,,6,19,44,,6,11,36,6,
   4,,,9,6,11,30,,5,,,,5,,24,,37,,,,5,19,,,,18,,,,,,13,,14,
   29,17,11,,5,19,,21,18,5,11,,8,48,16,115,8,,8,8,43,202,
   14,24,8,36,,,4,6,80,17,11,10,,24,,39,25,16,31,8,5,9,,
   10,11,4,8,4,11,,16,70,5,16,4,,4,4,11,24,9,,,,,,,19,47,
   13,35,20,8,,5,10,,5,6,5,4,6,4,7,5,6,16,5,5,,,,,,22,,,
   ,10,6,5,35,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,,,4,5,3,,
   4,,,4,4,25,16,5,7,,20,17,4,25,4,3,6,4,,4,4,,4,4,6,
   4,16,,4,3,8,4,6,6,6,4,4,3,8,4,,,,3,,4,,,,5,,,4,5,46,
   9,5,9,46,55,,4,55,,4,4,4,6,4,6,6,4,,14,,3,11,8,4,4,
   6,24,14,4,12,8,,71,,,6,,,,,,,5,17,,29,6,10,,,,22,,,,5,4,
   ,6,7,5,,,4,5,49,7,4,8,8,,7,5,49,,,,,,,5,,,5,5,,,7,9,
   66,39,8,4,23,,4,,,,5,,,4,5,46,9,5,9,46,55,,4,55,4,5,,
   20,6,44,,5,6,30,11,5,7,,9,11,6,36,4,4,6,,24,,8,6,16,
   6,16,6,6,4,4,,8,,7,,71,,5,,39,5,4,23,8,,7,9,66,,,,,5,
   16,28,16,5,36,,21,18,16,28,5,,,22,5,,,,,,25,,5,,19,,16,,
   11,5,17,35,20,25,5,,11,,,18,,,,,,,13,14,,,,,,,,,,,,,8,25,
   14,,8,4,4,14,8,28,10,5,10,19,10,11,4,4,8,,20,48,23,
   65,16,8,31,48,69,73,13,5,4,16,8,6,4,49,13,19,8,8,43,
   11,66,,49,10,26,17,13,59,5,,10,4,4,5,4,4,4,5,4,6,19,
   19,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,,,4,,17,15,,,4,17,
   17,,16,13,19,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,5,19,,,5,,44,,5,,
   ,,5,,17,20,35,,5,11,11,,16,21,,4,,5,7,,5,7,,,,4,,,15,
   15,,4,17,17,23,,23,4,,,,,5,,,,,4,,,,,,4,,,,,,6,4,4,14,,4,,
   ,,4,,16,18,14,,4,4,4,18,16,14,,,,6,,,,,5,,25,,22,,5,,,,,
   ,5,,4,,,,,4,,16,,13,,4,17,17,17,17,,,5,6,,,,6,,35,19,,,
   5,,10,,,26,19,,,,,18,,,,,,14,13,,,,,5,,,,11,,,17,15,,11,5,
   5,20,23,24,,,,6,,31,,15,,5,,10,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,28,33,74,,5,3,4,35,94,40,,,,,,,,,,,,,,86,94,45,
   ,,,,,76,35,37,,,,,40,40,34,,,,,,,,,,4,3,37,45,34,5,33,28,
   74,76,88,40,,,,4,,5,,,5,5,,4,,5,,,,,4,19,19,,4,,17,17,,
   15,15,6,4,4,4,,4,4,,14,4,,,,,4,16,12,16,4,,4,4,14,14,
   16,,,,,,,6,,,,,,,5,,,,5,,,,,22,25,,,5,5,7,5,,7,,,,,4,,13,
   15,4,,17,17,14,,15,3,19,,,5,,,,,,,4,,,,4,,,,,,,19,,,5,,,,,,
   ,4,,,,4,,,,,,,,5,,44,,,,,,5,25,,16,5,,11,11,18,16,26,5,4,
   ,,,,,,4,19,,15,4,,17,17,23,19,,5,,6,,,,,6,,26,,5,,,10,,
   31,15,19,5,,,,,11,23,20,18,11,,5,5,15,,17,,,,,,18,,,,14,,
   13,,,,,,,,,6,,,20,5,,,10,17,27,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,86,40,76,5,,3,4,67,41,33,,,28,,46,107,,,,,
   74,,74,54,,,,33,,32,73,,,,,4,3,57,53,86,,,,,,5,53,57,35,
   45,55,32,,,,,4,,4,,4,,,4,4,,5,5,4,16,4,4,,16,4,16,16,,
   4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,4,16,4,16,
   4,4,,,16,16,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,5,5,16,4,5,
   5,,4,16,16,16,,5,5,,,,4,,,5,,5,9,4,,55,,4,55,46,46,5,
   9,,4,4,,,4,,5,5,4,16,16,5,5,,,16,4,16,,,,,,,,,,,,,,,,,,,
   4,4,,,5,4,25,7,5,,25,4,17,17,20,,4,4,,,5,25,4,,4,20,
   4,25,17,17,,7,5,,5,18,4,4,5,10,16,5,5,,20,16,5,10,,,,,
   ,,,,,,,,,,4,15,17,,4,17,16,13,,,17,,4,19,19,4,,17,15,15,,
   ,17,4,,4,7,10,58,3,4,12,16,44,9,8,10,7,60,4,3,12,
   16,44,8,7,4,16,8,7,37,60,12,4,3,16,9,8,44,58,12,3,
   4,27,25,,12,,12,12,4,16,12,60,12,7,16,12,58,7,10,,12,
   60,58,,27,25,16,16,4,4,19,,,4,,,,4,,6,6,6,10,5,5,,10,
   6,10,10,,5,5,,4,,4,5,,5,5,5,,5,4,16,,4,4,16,4,16,16,
   4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,,,4,6,6,6,4,4,5,5,
   5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,4,,4,,5,5,,4,16,4,,
   4,16,4,16,16,4,4,,,4,4,,7,5,4,8,5,4,30,,4,,8,30,5,4,
   ,,,,,,,,,,,,,,,,,4,6,,6,8,5,,4,4,5,8,5,5,5,7,5,5,7,,4,
   8,5,30,4,,4,,8,4,5,30,6,6,16,,5,5,,,15,,,,5,5,6,15,,,
   5,5,,14,,,5,,5,14,,5,,5,,15,,,5,5,,4,8,7,9,3,3,3,4,
   9,9,8,20,20,20,4,3,4,3,20,20,20,4,4,20,7,20,20,4,6,
   4,4,13,8,13,20,4,4,6,20,8,20,20,6,4,4,4,3,4,20,20,
   20,4,3,9,8,7,4,20,20,20,20,20,20,4,4,4,,,4,4,,5,,5,,
   ,5,9,5,46,5,9,4,,55,46,,55,4,,,,,20,,,,,,13,14,,,,18,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,18,16,5,,36,18,16,28,28,,5,
   21,,4,,,,5,,,4,5,46,9,5,9,46,55,,4,55,,,,,,,,,,,,,,,,,,,,4,
   ,,6,6,29,9,6,,36,6,11,11,,,4,,,,,,,,,,,,,,,,,,7,71,8,4,
   7,66,9,5,,,23,,5,39,,,,,,,,,,,,,,,6,35,19,,6,10,22,,,,,,5,
   ,22,6,,10,17,29,,,,5,,5,49,49,43,4,5,16,,,14,17,13,10,
   11,4,4,8,10,,8,11,6,8,10,48,20,19,,,4,8,10,73,23,26,,
   4,,19,69,48,66,,8,8,5,10,8,,8,11,,16,,14,13,31,,25,65,
   ,28,59,,,4,,,,,,,,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,5,16,4,,5,
   5,4,16,16,16,5,,5,,5,,5,,5,,,4,,55,,4,9,5,46,55,5,46,
   9,5,5,5,,4,,,4,4,16,16,4,4,4,,,4,16,16,6,6,6,,,5,6,
   6,21,5,51,6,6,,,51,21,5,6,6,7,,7,5,51,,6,6,51,5,21,
   21,6,,6,6,7,,7,51,5,,6,6,5,51,21,21,6,,6,5,,,6,6,21,
   51,5,6,6,,,5,21,51,,4,15,15,17,4,,17,17,,,,17,4,,,,,,,,,,
   ,,,,13,16,17,,4,14,17,,,4,17,,4,25,7,9,3,4,12,16,10,
   58,7,27,8,8,4,3,12,16,9,60,12,16,16,45,34,,,12,,12,4,
   10,11,58,37,3,12,4,8,10,45,27,4,12,3,4,16,12,8,27,8,
   16,12,9,25,7,,27,,44,60,12,60,16,4,16,19,,,5,,,,,,,4,,,,
   4,,,,,,,,,,20,,,,,18,,,,,13,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,6,,,,,5,,,,,,5,,,22,,25,,,,,,5,,28,22,5,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,57,53,35,3,5,,,74,
   46,32,53,57,86,5,3,,,74,28,33,,,41,55,,,,,,,67,45,,,,,,
   33,32,,,,,,4,,,40,86,76,,,54,107,73,,,,,,,,,,,,4,,,,6,6,,
   10,6,5,,5,6,10,10,10,6,6,12,4,4,,,5,5,,16,4,5,,5,4,
   16,16,16,5,5,,4,,4,,7,5,8,4,7,5,49,4,,,8,49,7,5,,4,
   6,,6,5,8,9,6,6,8,5,5,5,5,,5,,,,,,,,,,,,,,,,,5,7,,8,4,
   7,49,5,4,,,8,5,7,49,6,6,,18,6,6,,20,,,,,6,6,6,,20,,6,
   6,20,,,,6,,6,,20,6,,6,18,,,,6,6,,4,19,28,28,3,4,4,3,
   19,28,19,8,9,9,3,3,3,4,10,9,8,6,6,9,28,28,19,4,9,
   4,6,10,19,19,28,4,4,9,8,19,19,28,9,4,4,4,4,3,9,8,
   9,3,4,28,19,28,4,28,19,28,19,28,19,6,6,6,,,,,,,,,,,,,,,,,
   ,,,,4,,68,7,,4,8,5,,42,,5,,23,50,7,9,,,,,,,,,,,,,,,,,,,6,,
   ,50,6,,,4,6,18,11,11,6,9,,,,,,,,,,,,,,,,,6,,17,27,5,,,,20,
   ,,,6,10,,20,,,,5,31,15,,,6,,10,,,,,,,,,,,,,5,12,,10,4,4,
   8,10,11,9,17,19,,11,5,4,16,,80,35,103,,4,16,8,39,47,4,
   ,8,,,,,,,,,11,10,24,24,,4,8,5,,16,36,70,93,10,8,9,12,
   12,31,24,25,,28,20,,6,8,8,4,4,,18,5,,4,4,5,16,10,5,5,
   ,35,10,5,16,4,,5,,,4,21,7,,5,21,4,17,17,4,,20,,5,,,
   21,4,,20,4,4,21,17,17,5,7,,,,,,,,,,,,,,,,,4,,23,19,4,17,,
   19,15,,,,4,17,,17,17,,17,4,16,13,,,4,,17,,,,,,,,,,,,,4,10,
   34,10,3,4,12,16,8,9,25,8,45,10,4,3,12,16,9,8,27,16,
   4,7,7,20,45,3,4,12,16,20,25,,,12,12,,7,7,25,34,4,3,
   12,4,16,12,10,8,90,16,12,10,10,34,,34,45,,25,27,,4,16,
   16,4,4,,,5,5,46,9,5,46,55,4,,9,55,,4,4,,,5,46,5,,4,
   55,4,55,,9,46,9,5,19,6,19,6,6,6,10,10,5,5,,12,10,6,
   10,,19,,,13,14,,,,,,,,18,5,,,,5,,24,31,,,,,5,24,16,5,,11,
   15,17,,29,11,5,,6,49,13,45,4,7,,8,20,30,8,49,10,24,7,
   4,,8,23,48,13,5,,11,15,,105,16,5,4,10,10,12,,15,8,4,
   4,24,47,,48,31,16,8,4,,8,24,11,10,,8,39,16,9,,,,,54,
   67,14,,10,5,4,6,,6,10,10,,5,5,10,10,6,6,5,,5,5,,,5,
   46,9,46,5,55,4,,9,4,,55,,6,18,,10,6,,,19,27,,,,5,,,,,,,,,
   ,,,,,22,,10,,6,,23,31,,5,,,10,11,11,11,8,4,4,5,10,,8,
   66,19,20,31,8,10,,26,,28,8,8,48,16,115,49,8,,8,6,20,
   10,30,81,4,,,24,8,36,71,,,4,10,,10,24,,27,5,4,9,,8,5,
   11,,12,14,,12,,4,,5,,,46,5,,55,4,4,55,,9,5,9,46,,6,,16,
   ,5,,22,,,39,,10,6,,,,,,,,,,,,,,,21,,,5,16,,,35,6,10,,10,,
   25,30,8,31,10,,45,175,17,,9,10,4,8,4,5,10,14,13,,,,,,,,,
   ,4,9,24,14,12,4,8,,8,25,14,11,,8,4,10,5,4,10,19,8,,
   10,20,48,24,5,48,69,30,74,67,48,8,6,8,5,19,18,16,5,
   11,,25,16,,26,,5,11,,,,,,5,25,22,,,5,,,,,13,,14,,,,,18,,,
   6,36,24,9,4,,,8,11,80,28,70,25,12,,4,,8,9,35,20,,5,
   16,11,,93,4,5,16,10,39,24,,,8,16,31,8,10,,12,4,4,8,4,
   ,8,12,19,47,,8,10,11,24,,,,,17,103,,5,10,,4,,,,4,,,,,,,,
   4,,,4,,,,,,,,4,,,57,53,,,,,,,67,45,53,57,,,,,,,41,55,4,,28,
   33,74,86,,5,3,,46,32,74,35,,3,5,,,,,,,,,,,,86,107,,,,76,
   73,,,40,57,,33,32,,,4,,,,,4,,,,,4,,,,,33,37,,,,,35,,76,,28,
   45,,,,,94,,86,,,,,,,,,,4,94,40,35,74,3,,5,86,40,76,34,5,,
   3,,,,28,,45,,,74,,34,,33,,37,40,,40,,4,,,40,,54,,,,,74,74,
   ,86,,107,,,,,46,28,,,4,41,33,67,76,3,5,,,,,,,,,,55,32,45,
   73,5,3,,,,,57,53,,,,35,86,,,53,57,,32,33,,4,,,20,20,20,
   4,4,3,4,13,20,20,20,20,28,21,13,19,13,21,11,28,13,21,
   13,28,13,13,21,13,21,13,28,13,14,13,4,3,3,13,13,28,4,
   4,13,21,21,4,13,13,13,19,28,19,13,19,20,20,20,21,12,
   13,20,13,21,12,19,21,11,13,20,13,28,21,21,11,28,20,21,
   11,12,4,4,4,21,21,21,3,3,14,11,12,4,13,28,13,20,20,
   20,20,28,20,4,20,20,13,20,3,4,4,20,20,20,20,4,4,3,
   20,20,11,28,21,11,28,12,13,21,12,21,13,21,14,28,21,11,
   4,3,4,28,19,19,28,4,3,4,20,13,14,13,13,21,19,13,13,
   28,21,13,13,13,13,13,13,21,3,4,4,20,20,12,21,12,12,
   19,12,21,11,12,21,21,11,13,21,12,12,4,4,3,4,3,20,20,
   20,4,20,20,20,11,12,11,20,19,20,4,28,19,28,13,12,12,
   20,28,20,21,21,21,20,28,20,20,19,20,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,16,,,16,,,16,,,
   ,,16,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,16,,,
   16,16,16,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,14,14,
   14,14,14,14,14,14,14,14,14,14,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,14,14,14,14,14,14,
   14,14,14,14,14,14,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,72,72,,36,36,72,36,36,36,36,72,4,
   4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,
   ,8,12,8,,,,,,,,72,,,72,72,72,,36,72,36,72,,6,6,6,8,10,
   10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,
   ,,,,,,118,118,,,118,,118,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,
   6,8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,36,72,72,36,,,72,72,
   ,72,,72,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,
   ,8,,16,,16,,,,,,,,118,,,118,,,,118,,118,,,8,10,10,8,4,12,
   12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,
   200,,,200,200,200,,,200,,200,,4,6,8,4,6,6,4,6,6,,,6,6,
   8,,8,12,12,,,,4,6,,6,,8,,8,,,,,,,,36,36,36,36,72,72,36,,
   72,,72,36,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,
   16,,16,,,,,,,,,118,118,,,,118,,,,,118,8,4,12,12,4,12,12,,,
   12,12,8,,8,,,,,,4,12,,12,,8,,8,,,28,28,,,,,200,200,,,,200,
   200,,200,,200,6,16,16,6,16,16,,,16,16,10,,10,,,,,,6,16,,
   16,,10,,10,,,,,,,,,,,,,,,,,,,,4,4,2,4,4,,,4,4,4,4,4,4,4,,,
   ,2,4,,4,,4,4,4,,,4,4,,,,14,14,14,14,14,14,14,14,14,
   14,14,14,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,
   ,,,,16,,,16,16,16,,,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,
   8,6,,,,,,,,,,,,16,,,16,16,16,,,4,4,,,4,4,4,4,4,4,4,,,,2,
   4,,4,,4,4,4,,,4,4,,,,14,14,14,14,14,14,14,14,14,14,14,
   14,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,16,,,16,
   16,16,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,16,,,
   16,16,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,16,,,16,,
   ,16,,,,,16,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,16,,,16,,,16,,,
   ,,16,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,18,18,,,18,,,,,18,,,,,,
   ,,4,,,,,,4,,,,,,,,,,48,48,,,,28,,,,,28,8,8,,,,4,6,,6,,4,,4,
   ,,,,,,,,18,18,,,18,,,,,18,,4,,,,4,,,,,8,,8,,,,,,,,56,,,56,,,,
   56,,56,,,,,,4,,,,,8,,8,,,,,,,,56,,,56,,,,56,,56,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,4,,4,4,4,,,4,4,,,,14,14,14,14,14,14,14,14,14,14,14,
   14,,4,,6,,6,,,8,8,,,,16,,,16,,,16,,,,,16,,,,,,,,,,,,,,,,,,,,,,,
   ,,,6,,6,,,8,8,,,,16,,,16,,,16,,,,,16,,,,,,,,,,,,,,,,,,,,,,,,4,,
   ,,,,,,,18,18,,,18,,,,,18,,,,,,,,,,,48,48,,,,28,,,,,28,,,,,,,,,
   18,18,,,18,,,,,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,32,
   48,,,32,,48,,,,,,,,,32,48,,,32,,48,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,14,,,,,,,,,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,14,,,,,,,,14,,
   ,,,,14,,14,,,,,,,,,3,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,
   9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,
   21,21,21,,21,,21,21,,21,21,6,6,9,,6,9,,12,,,6,6,6,6,
   6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,
   6,,,,,,,,,21,21,21,,21,,21,21,,21,21,5,5,,4,7,10,7,12,,
   5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,5,,,3,4,5,,5,,,,,,
   4,4,6,4,,5,6,5,,,5,5,,8,,15,,19,15,,20,15,6,18,20,6,
   13,5,,5,5,12,8,,,5,5,5,5,5,10,5,5,10,9,3,4,4,5,5,5,
   ,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,20,15,19,,15,15,
   ,19,6,15,6,19,,7,8,,7,,,10,10,10,10,10,10,10,10,10,
   16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,6,4,6,5,6,5,
   8,8,,,,,,,,,20,20,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,5,5,5,5,5,10,5,5,10,9,3,5,
   5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,15,
   20,6,13,19,,15,19,6,,18,15,,7,,,10,10,10,10,10,10,10,
   10,10,16,4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,,
   10,,,,,,6,,,,5,,,22,22,,10,,5,,,,,,27,,,,,,,,,6,,,,,,,,6,,,,,,,
   ,,,,,7,,,,7,,,,,,,,,,,11,32,70,,148,,,,,,,,9,9,14,9,14,10,
   9,14,10,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,
   11,9,10,9,10,10,8,8,,,,,,8,,,,,8,18,,18,,,,,,18,,,,,,,6,,,,
   ,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,70,34,,,151,,,,11,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,6,7,7,
   3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,6,8,,,,,,
   8,,38,17,7,38,18,21,24,10,10,21,10,17,5,5,5,5,4,5,5,
   5,3,5,5,5,6,6,,,3,5,6,,6,,,,,,5,5,6,4,,8,6,8,6,6,,,,,
   ,17,38,12,24,24,17,38,10,7,24,7,38,5,5,5,6,8,7,8,4,
   5,5,5,10,10,,,4,5,10,,10,,,,,,5,5,,6,9,7,,7,8,8,,,,,,
   64,64,20,,106,38,,8,9,54,9,64,5,5,5,5,5,5,3,5,5,5,
   6,6,9,,3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,,6,6,,14,,21,
   24,7,18,38,38,17,7,12,24,12,24,5,5,5,5,4,4,5,5,5,
   10,10,,,4,5,10,,10,,,,,,5,5,9,6,,7,9,7,11,11,11,11,,9,
   ,38,,20,106,,64,64,9,20,106,20,,7,7,6,7,4,6,6,6,12,
   12,7,,4,6,12,,12,,7,,,,6,6,7,4,10,6,7,6,10,10,8,8,,
   10,,101,98,11,204,204,101,98,8,9,148,9,216,5,5,7,3,5,
   5,5,6,6,6,,3,5,6,,6,,6,,,,5,5,,4,,8,,8,,,,,,14,,24,24,
   10,21,17,24,21,12,7,38,7,18,5,8,4,5,5,5,10,10,9,,4,
   5,10,,10,,9,,,,5,5,,6,,7,,7,,,8,8,,12,,54,106,9,54,64,,
   38,20,20,,20,106,7,4,6,6,6,12,12,7,,4,6,12,,12,,7,,,,
   6,6,7,4,8,6,7,6,8,8,10,10,,,,256,204,9,148,98,98,101,
   9,11,204,11,204,4,9,9,9,8,8,,,4,9,8,,8,,,,,,9,9,10,6,
   ,8,10,8,,,,,,,,121,,26,52,,70,70,10,26,52,26,,3,3,3,4,
   4,3,,2,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,14,
   14,3,13,13,14,14,3,3,14,3,13,3,5,5,5,,,3,5,5,,5,,,,,,
   3,3,4,4,5,4,4,4,5,5,,,,,,,15,19,19,13,15,,4,4,15,19,
   19,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,
   15,19,19,13,15,,4,4,15,19,19,5,5,,,3,3,5,,5,,,,,,4,4,
   4,4,5,3,4,3,,,5,5,,,,15,,19,13,19,,15,4,4,20,20,13,4,
   6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,
   ,6,6,,5,,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,
   ,6,,,,5,,,,,6,6,,5,,,3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,
   ,,,42,,28,19,19,42,,5,5,21,28,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,14,
   14,3,13,13,14,14,3,3,14,3,13,5,,5,,,,,,4,4,4,4,5,3,
   4,3,,,5,5,,,,15,,19,13,19,,15,4,4,20,20,13,,4,,6,,,,5,
   5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,
   ,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,
   ,,,,,,,42,,28,19,19,42,,5,5,21,28,19,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,
   5,,,5,5,,5,,15,20,4,15,,20,15,20,20,,4,15,,4,,5,,5,,,
   5,5,,5,,15,20,4,15,,20,15,20,20,,4,15,4,,,3,,,,,,,5,,
   21,21,5,,36,21,21,28,28,,5,21,,4,4,4,6,6,6,6,,,,14,
   14,14,14,14,14,14,14,14,14,14,14,,,,,,,,,,,21,21,19,,,21,
   21,,,,19,,,3,5,5,,,,5,,20,15,5,,17,15,20,20,20,17,5,,,,,,
   ,,5,,21,21,5,,36,21,21,28,28,,5,21,5,5,,,,5,,20,15,5,,
   17,15,20,20,20,17,5,,3,5,5,,,,25,137,9,29,80,56,15,,9,
   56,,17,5,5,,,,25,137,9,29,80,56,15,,9,56,,17,3,,,,80,15,
   ,56,15,17,56,,9,25,9,80,,,,80,15,,56,15,17,56,,9,25,9,
   80,,,,,,,,,,,,,,,,,,,20,20,,,23,17,21,,20,,,,,,,,,,,,,,72,15,,,
   ,15,20,,58,,31,,,,,15,20,,96,,19,19,72,31,9,11,15,5,14,,
   ,,58,98,,14,,15,,60,51,,14,,,20,15,,51,,20,15,,72,15,5,
   51,11,98,96,9,32,20,,19,6,6,9,,6,9,,12,,,6,6,6,6,6,
   9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,
   ,,,,,,,21,21,21,,21,,21,21,,21,21,5,5,,4,7,,7,,,5,5,5,
   5,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,6,,,8,,3,5,
   ,5,,5,5,5,,6,,,,,,,18,,19,15,6,19,13,15,15,20,6,5,,5,
   5,,8,,12,5,5,5,5,5,10,5,5,10,9,5,3,5,5,5,6,5,5,4,
   5,5,,7,,,,,,3,4,,5,,5,,7,,,,,,,8,15,6,15,19,,19,15,,19,
   20,15,6,,7,8,,7,,,10,10,10,10,10,10,10,10,10,16,7,4,
   7,5,5,4,,,5,6,6,,10,6,,,6,,4,5,,6,,6,,10,,6,,,,,,,5,22,
   ,22,5,,,,,,10,12,,,,,,,18,,,,,,,,,,6,,,,,,,,,,,,7,,,,,6,,,,,,,,
   ,7,,,,,,,,,,,,151,,,70,34,11,5,,7,,10,5,5,5,5,5,10,5,5,
   10,9,4,3,4,4,4,4,,,5,5,5,5,5,,,6,8,,3,5,,5,,5,5,5,,,
   ,6,,,,20,6,20,6,15,19,,15,13,15,,18,,7,,,10,10,10,10,
   10,10,10,10,10,16,5,4,5,7,7,4,8,8,7,10,10,,5,,,6,,,
   4,7,,10,,10,,5,,,,6,,,6,,10,,5,,,20,22,,,,5,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,14,9,14,10,9,14,
   10,11,7,6,7,7,7,6,10,10,9,8,8,8,9,10,,10,,,6,9,,8,,
   8,8,9,,10,,10,,,11,,18,,8,,8,,,,,,18,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,,6,,,,,,,,,,,,,,7,,,6,,,,,
   ,,,,,,7,,,,,,,,148,11,70,32,,,,,5,5,4,5,5,4,6,7,7,5,3,
   5,5,5,4,,,5,6,6,,8,6,,,14,,3,5,,6,,6,,8,,6,,,,,,38,7,
   24,12,21,10,17,21,18,24,24,7,5,5,5,5,4,5,5,5,5,3,5,
   5,5,4,,,5,6,6,6,8,9,,9,14,,3,5,,6,,6,6,8,,9,,9,,,8,
   24,12,38,7,17,7,38,18,24,21,24,12,5,5,5,6,8,7,8,5,
   4,5,5,5,6,,,5,10,10,8,7,9,,,12,,4,5,,10,,10,8,7,,9,,,,
   ,,,20,,20,38,9,64,54,106,54,106,20,5,5,5,5,5,5,5,3,
   5,5,5,4,6,6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,,6,,,,24,7,
   17,10,38,12,24,24,38,17,67,7,5,5,5,5,4,5,4,5,5,5,6,
   11,11,5,10,10,11,7,,,9,9,,4,5,,10,,10,11,7,,,,9,,,,106,
   20,64,9,64,20,,106,,38,,20,7,7,6,7,6,4,6,6,6,4,8,8,
   6,12,12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,8,204,11,
   98,9,101,9,98,148,204,,204,11,5,5,7,5,3,5,5,5,4,,,5,
   6,6,,8,9,,6,8,,3,5,,6,,6,,8,,9,,6,,,14,21,10,21,10,
   24,7,18,38,17,38,17,10,5,8,5,4,5,5,5,6,8,8,5,10,10,
   ,7,,,,,,4,5,,10,,10,,7,,,,,,,9,54,9,38,8,,20,106,,64,64,
   64,9,7,6,4,6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,6,,
   12,,12,8,6,,7,,7,,,10,148,9,101,8,98,11,204,204,216,
   101,98,9,9,4,9,9,9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,
   ,10,,,,52,26,70,10,70,26,,52,,121,,26,3,3,4,4,4,,,3,5,
   5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,20,20,15,4,,15,
   15,15,20,20,3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,
   4,3,3,,3,,3,,,3,14,3,14,3,14,3,13,13,13,14,14,3,4,4,
   4,,,3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,20,20,
   15,4,,15,15,15,20,20,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,
   5,3,,,,4,,,5,20,20,,4,15,19,19,15,13,15,,4,4,,,5,5,5,
   5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,20,20,,4,15,19,19,15,
   13,15,,4,6,6,4,4,4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,
   ,14,14,14,14,14,14,14,14,14,14,14,14,3,5,5,5,5,5,,,,,
   ,3,5,,5,,5,5,5,,,,,,,,56,,56,,15,9,80,29,17,29,137,9,
   5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,56,,56,,15,9,80,29,
   17,29,137,9,5,5,,4,,,4,,,3,3,,5,,5,,4,,,,4,,,5,15,19,
   15,4,,19,13,19,19,,15,4,4,5,5,6,,6,6,,4,5,,4,,4,5,5,
   ,6,,6,,,6,,5,,6,,5,,,,,,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,
   6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,3,,,5,,5,3,,,,,,,,,25,9,17,
   ,56,,17,56,80,80,15,9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,17,
   5,15,20,20,5,17,,,20,15,20,,4,,,3,,,6,,6,,4,,3,,4,,,5,
   21,28,42,5,,28,19,19,19,42,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,
   ,3,4,,6,,6,,,,4,,3,,,,,5,21,28,21,5,36,,21,21,21,28,,3,
   ,,6,,6,,5,,,,5,,,,21,,,23,,,20,20,20,,,17,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,3,,4,,4,3,3,,3,,3,,,3,14,3,14,3,14,3,13,13,13,
   14,14,3,,5,,5,,4,,,,4,,,5,15,19,15,4,,19,13,19,19,,15,
   4,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,
   ,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,25,
   9,17,,56,,17,56,80,80,15,9,,4,,,,,,17,5,15,20,20,5,17,,
   ,20,15,20,,,,,,,,,,,,,,,,,,,,4,,,5,21,28,42,5,,28,19,19,
   19,42,,5,,,,,,,,,,,,,,,,,,,,,5,21,28,21,5,36,,21,21,21,28,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,19,21,,21,19,,,,21,21,,20,,51,,15,,,,
   ,,96,51,11,72,5,14,14,19,58,96,9,20,,72,15,,,,,15,20,
   9,60,58,98,15,15,5,31,,,15,,,15,19,19,14,72,31,11,,,,,
   51,,15,,98,,,32,,20,20,8,8,,6,7,,7,,,8,8,7,8,7,10,8,
   7,10,20,5,5,4,6,6,6,,,5,6,6,9,6,10,,,,,5,4,10,6,,6,,
   6,9,,,,,,,20,,,,19,24,20,24,,20,26,26,8,,8,8,,10,,,8,8,
   7,8,7,10,8,7,10,20,5,5,4,10,7,10,,,5,7,4,,7,,,,,,5,4,
   ,10,,7,,10,,,,,,,,20,24,,,20,,20,,24,20,24,24,11,7,4,11,
   7,6,6,8,8,6,8,6,9,8,6,9,8,5,5,4,6,4,6,,5,8,6,6,,
   6,8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,6,8,6,6,8,8,
   6,8,8,8,6,6,,6,6,,,,,,11,,10,,,9,,16,,,5,,5,,,6,,8,8,,
   8,,,,,,,5,,,,5,,,,,6,,,,,49,,,,,,49,,,,,,8,,7,,,8,8,7,8,7,
   10,8,7,10,20,5,5,4,6,6,6,,9,5,6,6,,6,,10,10,,,5,4,,
   6,,6,,6,,,9,,,,,20,26,24,24,20,,19,,26,20,,,6,7,11,11,
   8,8,6,8,6,9,8,6,9,8,8,8,4,6,6,6,,,5,4,6,5,4,,8,8,
   8,12,5,4,,6,8,6,,6,5,,,,8,12,12,8,6,8,8,6,6,8,6,6,
   6,8,8,,,,,34,9,,13,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,
   ,,,,,,,,,49,,,,,,49,,,,,,,,12,12,10,12,10,8,12,10,8,10,6,
   6,4,4,6,4,,7,6,6,4,7,6,10,10,10,,8,6,4,10,4,,6,,4,
   7,,7,,8,,,15,,,,6,,6,,,15,,,6,,,9,,10,,,11,,16,,,5,,8,,,,,
   5,8,6,5,,,,,,,5,,,,8,,,6,,,,,,,,,,,49,,,,,49,,,,,9,34,13,,,
   9,,16,,,5,,8,,,,,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,49,,,,,49,,
   ,5,5,8,7,7,8,4,9,9,5,5,4,10,7,10,,,5,7,4,12,7,8,,,,
   ,5,4,8,10,,7,,10,12,,,,,,,14,15,41,41,23,23,12,23,15,
   23,15,15,5,5,5,8,8,7,7,7,5,5,4,10,7,10,,,5,7,4,12,
   7,9,,,,,5,4,9,10,,7,,10,12,,,,,,,12,41,41,41,12,15,14,
   15,41,20,41,41,7,4,7,4,5,7,5,5,5,3,5,6,5,,,5,6,6,
   9,6,6,,,11,10,5,3,6,5,11,6,,5,9,,,,10,11,11,7,8,8,8,
   7,9,7,9,8,7,8,8,5,7,5,5,8,7,5,5,4,10,7,10,,12,5,
   7,4,,7,,9,9,,,5,4,,10,,7,,10,,,12,,,,,20,41,15,15,14,
   41,12,41,41,12,41,41,7,7,4,7,6,5,5,3,5,6,5,,6,5,6,
   6,6,6,,,,10,8,5,3,,5,10,6,,5,6,,6,,8,10,10,7,8,8,8,
   7,8,7,8,8,7,8,8,9,7,10,9,8,8,6,8,9,8,,10,8,9,6,
   10,9,11,10,10,,,8,6,11,8,,9,,8,10,,10,,,,,12,,,,12,43,
   14,43,,10,,,5,7,9,5,5,4,10,7,10,,12,5,7,4,,7,,8,8,,,
   5,4,,10,,7,,10,,,12,,,,,23,15,23,23,12,41,23,41,15,14,
   15,15,7,5,5,5,3,5,6,5,,9,5,6,6,,6,,6,6,11,10,5,3,,
   5,11,6,,5,,,9,,10,11,11,7,8,9,9,7,8,7,8,8,7,8,8,9,
   8,8,6,8,9,8,,10,8,9,6,10,9,10,11,11,,,8,6,10,8,,9,,
   8,10,,10,,,,,10,,43,43,14,,12,,,12,,,10,10,4,9,6,9,,,10,
   6,4,,6,9,9,9,17,12,10,4,9,9,17,6,,9,,,,,12,17,17,8,
   10,12,12,8,12,8,12,10,8,10,10,3,3,5,5,5,,,3,4,4,4,
   4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,20,20,4,5,,5,5,
   4,20,20,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,
   4,,,,4,,,,5,20,20,4,5,,5,5,4,20,20,4,3,4,,3,3,3,2,3,
   3,3,3,3,6,4,3,2,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,
   4,3,4,4,3,4,4,5,4,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,5,,,4,3,4,4,3,,5,5,8,
   8,4,3,,5,8,3,,5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,
   7,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,
   ,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,4,,,,
   9,,4,3,,6,9,,,6,4,,3,,6,,,31,6,,,4,6,31,6,6,5,9,9,5,
   4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,,7,7,4,20,5,5,,20,4,
   20,20,,5,5,4,,3,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,
   5,7,5,5,5,7,5,7,7,5,5,5,4,4,6,6,6,6,,4,2,6,4,6,4,
   ,4,4,,4,,,6,6,14,4,4,4,14,4,14,4,4,14,4,4,,,,,,6,,3,
   ,6,,4,,6,3,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,5,,,9,
   6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,
   5,5,5,5,26,8,,3,3,5,26,,,5,,,,,,9,9,6,14,7,7,,14,6,
   14,14,,7,7,3,9,,5,3,5,5,9,5,,5,,,,,8,26,26,,7,14,14,
   6,7,,7,7,6,14,14,9,,5,3,5,5,9,5,,5,,,,,8,26,26,,7,
   14,14,6,7,,7,7,6,14,14,8,,6,26,,6,8,,,,,9,,,,,7,,,,,,7,,
   ,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,,,20,6,,6,6,18,,,3,,5,,4,
   ,5,,,4,,,7,7,4,20,5,5,,20,4,20,20,,5,5,3,4,6,3,,4,3,
   ,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,26,,,5,,,,,,9,
   9,6,14,7,7,,14,6,14,14,,7,7,,5,,4,6,,6,,6,,,5,,,,5,,5,
   ,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,5,4,,,,6,9,9,5,5,7,7,5,
   5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,,6,,6,,6,,,5,,,,5,,5,,,5,,
   ,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,,,,,,,,,,,,,,,,,,,6,,,
   31,6,,,4,6,31,6,6,5,9,9,,,,,,,,,,,,,,,,8,8,18,,6,6,,,20,,
   ,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,7,,,5,20,20,9,5,6,5,5,
   9,20,20,,,20,8,5,8,4,20,,,4,5,,20,,,5,8,8,5,,20,,,5,
   8,8,20,10,20,20,6,5,5,5,4,8,20,,,5,5,9,20,20,8,20,,,
   20,,,5,5,4,3,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,4,4,
   6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,19,19,,,,
   19,19,19,19,4,4,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,
   4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,19,
   19,,,,19,19,19,19,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,14,14,
   14,14,14,14,14,14,14,14,14,14,,3,5,,6,6,7,6,7,6,6,7,
   6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,
   7,,,,,,19,19,19,4,4,4,,19,19,19,,,,,8,,8,,,,11,,11,5,,5,
   5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,6,8,,13,14,7,,,,56,56,
   20,20,20,11,11,19,113,,,,5,,6,6,7,6,7,6,6,7,6,9,4,6,
   4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,19,
   19,19,4,4,4,,19,19,19,,8,,,8,11,14,,8,7,11,5,,,5,5,,,,
   8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,,,,,20,20,56,56,113,,
   ,,20,19,11,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,4,5,5,9,7,8,7,,
   15,,4,5,,5,,7,,7,11,11,8,,,13,,37,23,18,37,21,8,7,9,
   17,8,9,6,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,,4,5,5,7,7,
   8,,,,,4,5,11,5,,7,8,7,,,,,,,,18,37,37,23,18,7,12,8,23,
   9,6,12,5,4,5,4,8,6,8,4,5,6,4,6,6,,,5,6,12,11,7,13,,
   ,,,4,6,,6,,7,,12,,14,,,,,,,57,,57,64,10,10,7,32,7,7,9,
   4,5,4,4,4,7,4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,,5,,7,
   8,7,11,,7,7,,,,21,18,23,24,67,12,6,7,37,6,12,7,5,5,
   4,5,8,4,5,6,4,6,6,,,5,6,12,,7,,,,,,4,6,14,6,,7,13,
   12,20,18,14,14,,,,64,,57,32,,10,9,10,57,7,9,10,7,6,8,
   7,4,10,8,4,8,8,,,10,8,7,18,7,,,,,,4,8,19,8,,7,12,7,
   13,,12,11,,14,,55,,,47,55,8,12,7,47,8,9,12,4,5,7,4,4,
   5,4,5,5,,,4,5,5,,7,7,7,,13,,4,5,,5,,7,,7,,11,,9,,15,,
   24,21,24,21,23,6,9,12,18,12,7,8,5,8,4,5,6,4,6,6,,,
   5,6,12,,7,14,14,,,,4,6,18,6,,7,,12,,,14,16,,,,34,64,32,
   34,57,9,7,10,,9,10,10,7,4,10,8,4,8,8,,,10,8,7,,7,12,
   11,,14,,4,8,,8,,7,,7,18,,16,12,,,,104,55,47,80,,12,9,8,
   ,9,12,8,6,9,11,6,11,8,,,9,11,10,,10,,,,16,,6,11,,8,,
   10,,10,,,,21,,16,,,,,,,10,9,7,,9,9,10,4,4,2,4,4,,,3,3,
   4,4,4,4,4,,5,,2,3,5,3,,4,4,4,5,5,4,4,,5,,14,13,13,
   14,13,4,13,4,13,4,4,13,4,4,4,4,,,4,5,5,5,5,6,,,8,,
   3,4,6,5,,5,5,5,6,6,,,,,,,18,,19,14,6,19,5,14,5,19,6,
   4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,5,6,6,,,,,,19,
   18,,,14,17,19,5,14,3,4,4,4,4,,,4,4,4,4,4,4,4,,,,2,4,
   5,4,,4,4,4,5,,4,4,,,,13,14,14,13,13,13,4,4,13,4,13,
   4,4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,,,
   19,19,14,4,4,3,14,5,17,19,,,5,4,5,6,5,,5,,,,3,5,6,4,
   ,5,6,5,6,8,6,8,,8,,19,,19,,14,19,6,5,14,5,6,19,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,14,,19,14,,19,5,6,
   18,19,6,5,5,,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,14,19,,
   14,,19,5,17,18,4,4,3,,4,7,7,,6,,4,5,,5,,4,,4,8,7,8,
   7,,6,,,16,16,,,4,15,6,,15,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,
   ,,6,,34,35,33,,,,7,12,72,11,5,6,7,7,,8,,4,5,,5,,4,,4,
   8,7,7,8,,6,,,16,16,,,5,7,7,,5,4,5,4,,49,,4,8,8,6,,7,
   9,7,,6,9,8,,12,,41,,72,39,,13,6,7,,9,9,,,32,,4,6,8,8,
   ,7,8,7,,5,,,,,,41,72,,39,,12,,7,,6,11,5,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,5,,7,8,,6,10,6,,,10,10,,,,23,,,,,,7,7,23,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,5,4,4,,5,,13,13,13,13,
   14,4,4,13,14,13,4,4,8,4,,5,,5,8,,6,6,,,,14,,19,14,18,
   4,3,4,,17,19,5,8,,,6,,,11,,9,,11,,,25,25,41,97,5,7,19,,
   ,7,,,5,,5,,,6,6,,,,14,19,,14,18,6,5,19,,6,19,5,,,,,,,,,,,
   ,,,,,,,,,,,,,4,7,7,,7,,8,,,16,16,,,4,5,5,,7,5,7,,8,,9,,,,
   ,34,35,33,,72,6,7,13,,9,,10,7,7,7,,,6,,,16,16,,,4,6,
   15,,6,4,15,,8,8,,,,25,35,,25,,11,8,,94,19,7,5,8,8,,,,
   29,,97,29,,19,5,7,,11,,7,4,,,,,,,72,19,7,13,6,20,10,9,
   9,,,,72,,,,19,7,12,,20,5,6,11,,,,,,,,,,,,,,,,,,,23,23,,,,,7,
   ,7,,,,,,,,,,,,,,,14,,14,19,14,,44,44,60,14,,,19,14,14,,44,
   70,41,,,70,41,44,,14,19,14,,44,60,44,,14,14,19,27,28,
   70,14,19,14,14,4,4,14,10,14,10,5,14,9,10,14,19,14,10,
   9,70,41,28,4,5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,
   4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,19,
   19,,,,19,19,19,19,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,
   4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,19,19,
   19,,,,4,19,19,19,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,
   4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,19,19,
   19,,,,4,19,19,19,,,,,8,11,8,,,,,,11,8,,5,6,9,,8,6,5,5,
   8,,6,,,7,,,,,9,6,,8,,8,,,,,,,,19,11,20,20,20,56,113,56,
   11,,,,,,4,4,6,4,6,4,4,6,4,6,4,4,4,4,4,4,6,6,4,4,6,
   ,4,,,6,,,4,4,6,4,,4,,6,6,6,,,,,,14,14,14,14,14,14,14,
   14,14,14,14,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,8,,8,,,,11,,11,,5,,6,5,6,,,,9,8,,8,,,9,,,8,5,7,,,6,
   ,8,6,8,,,,,,,,56,56,113,20,20,20,,19,11,11,4,4,4,5,5,
   4,4,7,7,4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,7,5,15,7,,
   10,,9,,,,,,12,6,23,67,24,21,18,24,9,9,8,7,4,4,4,4,4,
   5,5,7,4,4,5,4,5,5,,8,4,5,5,,7,,,7,,,4,5,9,5,,7,,10,
   8,7,,,15,,13,7,12,37,18,23,18,37,21,6,8,7,12,5,4,5,
   4,8,6,8,5,4,6,5,6,12,,,4,6,6,,7,,,,,,5,6,16,12,16,7,
   ,7,,11,,,16,,,10,9,57,,32,64,,34,7,7,10,10,4,5,4,4,4,
   7,4,4,5,4,5,5,7,8,4,5,5,,7,,,9,,15,4,5,7,5,13,7,,
   10,8,,,,,,,8,7,18,21,37,37,23,18,12,7,12,6,5,5,4,5,8,
   5,4,6,5,6,12,,13,4,6,6,,7,,,11,,,5,6,11,12,14,7,,7,
   13,,,,,,14,10,10,,64,57,,57,64,9,10,10,9,7,6,8,7,10,4,
   8,10,8,7,,,4,8,8,,7,,,18,,,10,8,11,7,,7,,8,12,18,,,,,
   16,8,12,,55,47,55,,104,9,7,8,12,4,5,7,4,4,5,4,5,5,9,
   ,4,5,5,,7,,,7,,,4,5,,5,,7,,10,,,,,,,15,9,8,21,24,18,
   23,17,37,7,12,6,9,5,8,5,4,6,5,6,12,11,,4,6,6,,7,,,
   16,,16,5,6,,12,,7,,7,,,,,,,16,7,10,64,34,,57,32,,10,10,
   9,7,7,10,4,8,10,8,7,18,12,4,8,8,,7,,,11,,,10,8,18,7,
   16,7,,8,,,,,,,,7,8,55,104,,,47,55,12,8,12,9,9,6,11,9,
   11,10,,,6,11,8,,10,,,26,,15,9,11,26,10,16,10,,10,,,,,15,
   ,16,7,10,,,,,,,9,7,10,9,4,4,4,5,5,,,3,4,5,,5,,,,,,4,4,
   ,6,8,7,,7,5,5,,,7,,,19,5,19,,14,14,,19,6,5,6,19,4,4,
   4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,5,4,,4,4,4,,,5,,5,
   13,4,14,13,13,13,14,13,4,4,13,4,5,4,5,,,3,5,4,,5,,,,,
   ,4,4,6,7,,6,,7,6,6,,,4,,,19,5,,,14,14,19,19,17,3,4,
   4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,6,,,,8,,7,
   6,19,,14,19,,18,14,5,6,19,5,5,6,,4,4,4,,5,,,6,,,4,5,
   6,5,4,5,,4,5,,,,,,7,4,4,19,14,19,,,14,3,17,19,5,7,7,
   4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,4,15,16,,,,16,,
   6,6,4,15,4,4,,5,,7,,,,,32,5,6,,,10,,,8,9,,,,6,,,12,,,,
   39,41,72,29,7,5,11,6,4,5,,,7,,,,,49,5,6,,,10,,,8,8,9,,,
   ,,,13,6,72,,39,41,,29,7,10,7,10,4,4,,4,,,4,,5,4,4,4,
   4,5,4,,4,4,4,,,,,5,4,13,13,13,14,14,13,13,4,13,4,4,4,
   ,5,,,6,,,5,4,6,5,7,5,,4,,6,,,,,4,17,19,,14,,19,18,14,
   5,4,4,3,,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,7,19,6,19,14,,
   19,,14,5,19,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,
   6,14,6,,7,,,,,9,,9,5,7,16,,,,16,,7,5,4,5,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,30,7,,7,,,,,,,
   ,,7,33,,,34,35,69,13,6,5,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,
   ,8,9,9,,8,,6,,,,,,,7,,,,23,,23,7,,,,4,,5,,5,,7,,,,,,,8,
   5,6,14,19,,19,14,,19,19,5,6,,5,,5,,7,,,,,,,,3,4,14,19,
   19,,14,,4,19,5,17,,,,,7,,,,,,,30,6,5,34,69,35,33,,,11,,
   7,13,,4,,7,7,7,,,6,,8,6,4,,,16,16,,,15,4,15,6,9,,,,,,,,,
   ,7,7,,,,23,23,,,,,,,7,7,7,,,8,,14,5,4,,,16,16,,,5,5,7,
   7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,15,,15,15,15,,,6,6,,4,,
   ,49,,10,10,7,41,29,,72,39,,10,13,6,7,,,28,,10,5,11,41,
   29,72,,39,,6,12,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,23,23,,,,
   ,,,7,7,,,,,,,,,,,,,,,,23,,23,,,,,7,7,,4,70,27,44,14,19,14,
   5,9,10,10,41,28,60,19,14,14,4,10,10,8,,,,14,,28,14,19,
   14,,,,,98,14,14,19,14,,,41,19,14,14,,,14,70,41,28,,14,
   44,60,41,19,41,28,98,10,8,11,4,5,4,5,6,6,5,,,,,10,,
   10,13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,9,6,,,,8,10,,,10,
   9,,,,,41,41,,,,41,41,41,41,5,5,5,4,,3,,,6,6,7,6,7,6,
   6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,
   6,,,7,,,,,19,19,4,4,4,19,19,19,19,,,,6,4,6,6,4,4,4,4,
   4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,,6,6,4,4,,4,
   6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,,,,9,,
   10,,,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,,,8,,,,10,,,,,,
   41,41,5,5,5,41,41,41,41,,,,,,6,6,7,6,7,6,6,7,6,9,4,
   6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,19,
   19,4,4,4,19,19,19,19,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,,
   6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,,
   ,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,
   ,,,,,,30,30,30,,,,,30,30,30,5,5,4,7,7,4,6,7,7,5,5,6,
   5,4,8,,,5,6,8,,9,10,,,20,,5,4,11,8,20,6,11,10,,10,,,,,
   ,13,9,15,16,21,9,13,22,22,10,10,18,5,5,5,4,4,7,7,6,
   5,5,6,5,4,8,,,5,6,8,,9,,,,,,5,4,10,8,,6,10,10,,13,,,,,
   ,13,13,16,15,15,13,13,9,9,10,18,16,7,6,7,6,4,5,4,7,
   7,6,7,4,7,,,7,6,7,,12,8,,,10,10,7,4,6,7,10,4,6,6,
   16,9,,,8,9,9,6,7,7,7,7,7,6,7,7,6,7,7,5,7,5,5,4,6,
   5,5,6,5,4,8,,10,5,6,8,,9,,,,,20,5,4,13,8,20,6,,10,12,
   ,13,,,,,9,13,15,21,16,13,9,13,13,18,16,18,7,7,6,7,8,
   7,7,6,7,4,7,,8,7,6,7,,12,,,,10,10,7,4,9,7,9,4,8,6,
   14,7,7,,6,8,9,7,6,7,7,7,6,7,7,7,7,7,7,7,5,4,7,7,
   7,6,7,7,8,,10,7,6,8,,9,10,,,,,7,7,10,8,,6,11,8,,,,,,
   15,15,23,23,,31,31,23,23,10,10,9,17,17,5,7,7,5,5,6,
   5,4,8,,11,5,6,8,,9,13,,,20,,5,4,,8,,6,,10,,7,11,,,,,
   22,9,21,21,15,9,22,13,13,16,18,10,7,4,7,7,6,7,4,7,,
   6,7,6,7,,12,7,,,9,10,7,4,7,7,9,4,,6,,,9,,8,6,8,7,7,
   7,6,7,7,7,6,6,7,7,7,7,7,7,6,7,7,8,,11,7,6,8,,9,,,,,
   ,7,7,,8,,6,10,8,,13,13,,,,,10,23,31,10,,23,10,23,23,
   17,17,17,8,8,8,8,4,7,,8,8,8,7,,18,8,,,10,9,8,4,8,7,
   10,4,8,7,,,,,9,12,11,7,7,8,11,8,7,7,7,7,11,8,8,5,5,
   4,4,4,,,4,6,8,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,,
   4,18,19,6,4,,4,4,18,6,19,5,4,4,4,,,4,5,5,,8,5,,,5,,
   4,3,5,4,5,4,4,4,6,4,,,,,,,4,19,18,6,4,,4,4,18,19,6,
   5,4,5,,5,6,6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,
   5,5,6,6,5,5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,,,,,5,
   4,4,4,4,5,3,5,4,6,,4,,8,,8,4,,19,6,18,,4,4,4,6,19,
   18,4,,,4,4,4,,6,,,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,
   6,4,4,4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,
   4,5,3,5,4,6,,4,,,8,,4,,6,19,18,,4,4,4,6,18,19,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,6,,,8,,,,7,,4,3,5,4,5,4,4,4,
   6,5,5,,,,,31,5,,,8,5,31,4,4,7,7,8,5,4,,8,,,,,5,4,4,
   4,4,5,3,5,4,7,7,4,,,8,,4,,18,6,19,,4,4,4,19,6,18,5,
   ,6,5,,,8,8,5,4,5,5,8,4,6,6,,5,5,,5,5,6,6,6,5,6,5,
   6,6,6,6,5,5,6,,8,5,,,5,,4,3,5,4,5,4,4,4,7,4,7,,,,8,
   ,4,6,18,19,4,,4,4,19,18,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   ,,12,12,8,6,8,8,12,6,8,8,,8,8,,8,8,8,9,9,8,8,8,9,
   9,9,9,8,8,8,,,,7,4,4,4,4,5,3,5,4,7,6,5,,,12,12,5,
   31,,8,,31,5,4,4,8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,6,5,6,5,5,6,4,7,5,9,,5,,,,,5,,,,,,5,5,5,
   ,,,5,4,7,5,6,6,5,5,9,5,,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,
   8,,5,5,,,,8,4,4,6,18,19,4,4,,,19,18,6,4,4,6,3,,4,6,,
   3,,6,6,6,3,4,4,4,4,4,3,4,4,4,4,4,,,,6,,,5,,,,,,5,4,
   8,8,8,4,5,31,31,,,8,,4,,5,,5,5,,,,,4,4,19,18,6,4,4,,,
   18,19,6,6,,,,7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,
   4,3,6,6,6,3,4,4,4,6,6,6,,,,5,,,,,4,5,8,,,5,4,31,31,
   8,8,8,,5,5,,8,,,4,4,18,19,6,4,4,,,18,6,19,7,7,,113,
   35,36,7,7,20,26,79,7,7,,,79,20,36,4,,,,12,4,31,8,8,7,
   31,4,5,5,,,,,12,,,31,4,,,,4,31,5,5,7,8,8,,,,,,,,,,,,,,,,
   5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,,6,,,,,6,,,,,,6,,4,21,21,21,
   4,3,4,4,43,21,21,21,21,21,3,4,4,4,21,21,21,5,5,21,
   21,21,21,4,4,4,8,21,21,43,43,4,4,4,21,21,21,21,4,4,
   4,4,4,4,21,21,21,4,4,43,21,21,3,21,21,21,21,21,21,5,
   8,5,,,5,,,,8,8,,11,7,8,,14,11,,8,5,5,9,6,8,6,,5,8,,
   6,9,9,,,,5,,,,,8,,6,,,,8,,,,19,11,,,,56,113,56,11,20,20,
   20,3,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,
   9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,,,,,9,6,,9,,,6,,9,,,
   6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,
   30,30,30,,,,,,,9,11,,,8,10,,8,10,,6,5,6,,5,8,,,5,8,,6,,
   8,,,,8,9,,,,8,10,8,10,11,11,10,,,,56,56,,,,11,11,19,113,
   20,20,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,10,,10,7,13,,8,,,13,,
   ,8,,,177,177,9,12,11,,,,,,26,15,,,,,,,55,,,,,55,41,34,12,
   8,14,,6,,7,7,9,7,,,8,14,8,15,,,,8,,,9,9,,,136,,14,8,,,,
   10,,,,21,,,,,,46,39,,,,56,36,75,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,6,,7,,14,8,,8,,,9,,8,15,,9,,,,,136,
   15,8,17,,,10,13,,26,16,18,23,,,,56,36,,,,46,39,37,46,,8,
   ,10,8,,10,,10,12,10,,15,,,,12,15,,,,,,,,11,10,17,,244,12,
   18,12,19,16,14,19,,,,32,74,,,,32,74,,39,8,12,13,,,10,,13,
   ,13,10,21,20,10,,22,15,,15,10,,,94,,,,,,,,,,,,,,,,,,140,,,,,
   ,47,103,25,10,12,9,7,,12,7,12,7,,14,10,,7,,,11,9,,,,,,
   7,13,,,8,,,,,,24,,,,81,35,,,,29,35,35,29,,11,11,,,15,16,
   17,,15,,11,,18,11,,,11,19,,,,17,18,,,143,16,,21,26,27,,,,,
   ,95,,,,,,120,,,23,37,11,,,10,,11,16,,9,,10,,,10,8,,,,,,11,,
   ,,10,13,,,,,,,,,97,97,,,,125,97,47,125,10,10,10,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,6,5,5,,6,6,,6,5,,,32,,6,
   5,4,,71,,,,8,7,,,,,,63,11,,,,19,98,58,51,5,20,7,6,5,6,,
   4,,6,6,,6,5,,,18,,6,5,,,,4,4,,8,7,5,,,,,39,11,,,,11,39,
   39,39,4,5,5,5,6,,5,,,6,,6,5,5,,,32,,,6,,117,6,7,6,,,
   7,8,,,,19,98,,,,63,11,44,77,7,20,5,,7,,,5,,,6,,7,,,,5,
   5,6,,16,5,6,5,8,8,8,8,,,,29,29,,,,29,29,10,10,,5,,8,5,
   ,6,,,,,8,,,71,6,5,7,,18,6,7,5,10,9,7,9,,,,44,63,,,,98,
   77,19,11,7,5,20,5,,,8,,8,7,,,,41,,,6,,,,,,,,,,,,,18,,,,,
   35,84,,,7,14,7,,5,,,5,,7,,22,44,5,4,6,,16,4,4,4,8,7,
   6,6,,,,31,13,,,,13,37,10,10,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,,6,4,,,,18,,6,7,,,6,7,6,,,7,8,,,,11,39,,,,39,11,
   39,39,5,5,4,,,5,8,,71,,6,5,7,,28,6,7,6,9,7,9,10,,,,
   98,77,,,,44,63,11,12,20,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   5,8,,,,6,5,7,,20,6,7,6,10,7,7,10,,,,51,51,,,,51,51,12,
   12,5,4,5,5,,44,22,4,5,5,,15,5,6,5,6,7,7,8,,,,13,37,,,
   ,31,13,10,10,6,6,,,41,,,6,,,,,,,,,,,,,,35,84,,,,18,,,,7,
   14,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,71,,45,,,18,26,16,,,19,23,,,
   ,44,,,,,,71,71,44,,,,28,16,,,,,,117,31,29,,,,,,,71,,,,44,,
   44,117,,,,,,,,6,,6,,5,7,8,,,,19,58,,,,44,11,63,95,20,7,
   5,5,,,5,,5,,,6,7,,,,10,29,,,,29,10,29,29,,,5,,,,,,,,,,,,,
   64,14,,,,26,99,,,,22,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,71,117,,,
   ,44,44,,,,,,4,,8,7,,,,,,40,11,,,,11,40,40,40,6,10,10,,,,
   5,,,,,40,15,,,,15,40,,,,10,10,8,7,,,,,,58,19,,,,11,51,63,
   98,5,7,20,,9,10,,,,21,,,,,,16,,125,26,9,6,8,9,,,,20,,,,,,
   12,70,110,,,7,,,,,,12,,,,12,,49,49,7,,,,,,,21,,,,15,,,134,
   6,9,26,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,29,,,,19,41,19,40,
   18,18,31,,,,41,19,19,29,52,20,18,,,,,,,,,,,,,,,,,,,,,,,,,29,
   29,19,31,18,20,40,19,24,16,31,41,18,31,18,14,31,16,5,
   5,5,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,
   4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,19,19,19,,,,4,19,
   19,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,
   6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,
   4,,4,,6,7,6,,,7,,,,,19,19,4,4,4,19,19,19,19,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,11,8,,,,,,11,,6,
   9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,,6,7,8,,,8,6,,,,,,
   11,19,11,20,20,20,,56,56,113,4,4,4,5,5,4,4,7,7,4,4,
   5,4,5,5,11,,4,5,5,,7,7,7,,15,,4,5,,5,,7,9,7,,,,,,13,,
   12,7,6,12,9,24,23,21,8,24,21,18,4,4,4,4,4,5,5,7,4,
   4,5,4,5,5,,11,4,5,5,7,7,,,,,,4,5,,5,,7,7,7,,,,8,,,,6,
   12,12,7,6,23,67,24,7,21,18,37,5,4,5,4,8,6,8,4,5,6,
   4,6,6,,,5,6,12,14,7,14,14,18,,,4,6,,6,,7,16,12,,,,,,,,
   9,10,9,10,7,32,57,34,10,34,64,,4,5,4,4,4,7,4,4,5,4,
   5,5,,,4,5,5,,7,,8,11,,,4,5,,5,,7,,7,,,7,8,,,,9,6,7,8,
   12,37,18,23,12,18,37,23,5,5,4,5,8,4,5,6,4,6,6,18,
   20,5,6,12,14,7,,,14,,,4,6,,6,,7,14,12,,,,13,,,,7,9,10,
   10,9,57,,32,10,64,,57,7,6,8,7,4,10,8,4,8,8,,18,10,8,
   7,16,7,11,12,,,,4,8,,8,,7,12,7,,,,,,14,,9,12,12,8,9,47,
   ,80,8,104,55,,4,5,7,4,4,5,4,5,5,11,11,4,5,5,8,7,7,
   8,,13,,4,5,,5,,7,,7,,,9,,,15,,8,9,8,9,7,18,21,37,6,
   37,23,17,5,8,4,5,6,4,6,6,14,,5,6,12,,7,,13,,,,4,6,,6,
   ,7,,12,,,11,,,,,7,7,10,7,10,,64,57,9,,57,32,7,4,10,8,
   4,8,8,,13,10,8,7,12,7,,,19,14,,4,8,,8,,7,11,7,,,18,12,
   ,,,8,9,8,7,12,,55,47,12,55,,47,6,9,11,6,11,8,,,9,11,
   10,,10,,,,16,,6,11,,8,,10,21,10,,,,,,16,,9,9,10,7,9,,,,
   10,,,,4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,4,,
   ,4,4,,5,,13,4,4,13,4,13,14,13,4,13,13,14,4,4,4,4,,,
   4,5,5,5,5,,,6,8,,3,4,,5,,5,5,5,,,,6,,,,19,6,19,6,5,
   19,,14,5,14,,18,4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,,5,,
   5,6,5,,,6,,,,,19,19,4,4,3,19,18,14,5,14,,,4,4,,5,4,4,
   4,4,4,4,4,5,,,2,4,,4,,4,4,4,,,4,4,,,,4,13,13,4,4,14,
   13,13,4,13,14,13,4,8,,5,4,5,6,5,,,6,,,3,5,,4,,5,6,5,,
   ,,5,,,,4,4,19,19,5,,,14,3,14,19,18,,,5,4,5,6,5,8,6,8,
   ,,3,5,,4,,5,6,5,,,5,,,8,,6,19,6,19,5,,18,14,5,14,19,,
   ,6,8,7,8,7,5,6,11,,,5,6,,8,,7,8,7,,,9,,,,,11,,19,7,
   5,97,,29,7,29,,,6,6,8,8,7,,,,,,5,6,,6,,8,8,7,,,9,8,,,,
   19,7,11,,8,,,29,5,29,35,94,4,5,,5,,6,6,,,4,4,,4,,5,,5,
   ,,5,5,,8,,5,19,6,5,19,,14,19,6,,18,14,5,8,5,6,,6,,,
   4,4,,4,,5,6,5,,,6,6,,,,5,17,4,3,4,18,14,19,19,,,14,8,
   4,7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,15,4,4,6,15,16,,,6,,
   16,,,,9,,,,4,,,6,,7,4,7,,,8,9,,10,,10,9,7,6,13,,19,72,
   9,,,20,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,5,4,5,5,16,,,7,
   ,16,,4,8,,,4,,,5,,7,,7,,,,8,,32,,6,11,12,7,,,,39,5,41,
   72,,8,12,,4,5,,,,7,8,7,,,,9,,49,,9,9,13,7,6,72,,39,,41,
   ,,11,,5,6,,6,,,9,,,,5,6,,7,,,7,5,19,7,25,97,41,,,25,,,
   5,,,8,,6,,6,,,6,,,,,7,,,,,,23,23,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,,4,,4,4,4,,,4,4,,5,,4,4,4,4,13,13,13,14,13,14,13,
   13,,4,,5,,5,,,6,6,,,,3,4,17,5,19,,14,,4,19,18,14,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,8,5,,,6,6,,,,5,6,19,5,6,18,14,,19,19,,
   14,,,,,,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,16,,,5,,16,,,,
   ,,,,10,,5,6,7,,12,,19,,11,72,,20,,,,,,6,,6,4,4,15,6,16,,
   ,15,,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,11,5,,12,7,33,,
   ,6,34,35,72,,10,,9,,6,13,7,33,72,,10,34,35,,,,,,,,,,,,,,,,
   ,,,,7,7,,,,,23,,23,,,,,,,,,,,,,4,10,14,9,14,19,14,5,44,
   44,70,14,10,10,19,14,14,4,44,70,27,4,4,70,27,44,10,
   14,19,14,5,44,70,44,9,14,14,19,41,28,70,14,19,14,14,,,
   14,,14,,,14,,,14,19,14,,,70,41,28,,,,,,,,9,6,,9,,,6,,9,,,
   6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,
   30,30,30,,,,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,
   4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,19,19,19,4,4,4,,
   19,19,19,6,17,,9,,10,,,10,13,8,9,,6,,8,,10,,,6,,9,8,,5,
   ,,,,8,,,,12,,,5,,,10,,,,5,5,41,41,41,,,,5,41,41,41,,,9,,
   10,,,9,,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,
   41,41,41,5,5,5,,41,41,41,5,5,4,7,7,4,6,7,7,5,5,4,
   5,6,8,7,,5,4,8,11,6,,13,,,,5,6,,8,,9,,10,11,,,,,20,,
   16,18,9,13,22,21,15,21,10,22,9,13,5,5,5,4,4,7,7,6,
   5,5,4,5,6,8,,12,5,4,8,13,6,,,13,,,5,6,,8,,9,,10,10,,,
   ,20,,20,18,16,13,13,9,15,16,21,18,9,13,13,7,6,7,6,4,
   5,4,7,7,4,7,6,7,,,7,4,7,9,4,,7,7,6,8,7,6,,7,8,12,,
   6,6,,,,10,9,9,7,7,7,6,7,7,7,6,7,7,7,6,5,7,5,5,4,
   6,5,5,4,5,6,8,13,,5,4,8,,6,,,10,,,5,6,,8,,9,,10,,,,10,
   ,,,10,18,13,9,13,16,15,15,16,13,13,9,7,7,6,7,8,7,7,
   4,7,6,7,7,14,7,4,7,7,4,,,9,8,6,7,6,,7,9,12,,6,8,,,
   8,10,10,9,7,7,6,7,7,7,7,7,7,7,6,7,7,5,4,7,7,7,7,
   7,6,8,13,,7,7,8,13,6,,,,,,7,6,,8,,9,,8,11,,,10,,,,17,
   17,23,23,10,31,,10,17,10,23,23,5,7,7,5,5,4,5,6,8,10,
   ,5,4,8,,6,,10,11,,,5,6,,8,,9,,10,,,,11,,20,20,10,10,9,
   22,13,15,21,16,18,13,9,22,7,4,7,7,4,7,6,7,9,16,7,4,
   7,,4,,8,6,9,8,7,6,,7,9,12,,6,,,,6,10,10,10,6,7,7,7,
   6,7,7,7,7,6,7,7,7,7,7,7,7,6,8,,,7,7,8,,6,,10,10,15,
   ,7,6,,8,15,9,,8,10,,,11,,,,9,17,23,10,23,,31,31,17,23,
   23,10,8,8,4,8,8,7,,,8,4,7,,4,,8,8,12,9,8,8,,7,11,18,
   ,7,8,,,8,9,10,10,11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,
   5,5,5,,4,3,4,5,4,,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,19,
   18,4,,4,6,19,18,6,4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,
   ,4,6,,8,,8,,4,5,,,5,5,,5,19,6,,4,4,18,19,6,18,4,,4,
   4,4,4,,6,3,3,3,3,3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,
   6,6,4,4,4,4,3,4,4,4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,
   ,8,4,5,,5,8,8,,4,5,,,5,5,,5,6,19,,4,4,19,18,6,18,4,
   ,4,5,5,,5,4,5,5,4,,5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,
   8,8,5,5,6,6,6,5,5,6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,
   5,,4,,8,,5,4,,,,5,5,,18,19,4,,4,19,6,18,6,4,4,,7,4,
   4,4,4,3,,6,5,,,4,5,,,12,8,,5,5,,,,5,,7,,,31,5,4,8,7,
   8,,4,31,5,6,5,7,7,6,,7,,35,113,6,,,6,36,,,,6,,,,9,9,,
   79,20,7,,7,20,79,26,36,7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,
   4,,,,4,,5,5,18,19,4,4,,19,6,18,6,,4,4,4,4,3,,,3,6,6,
   4,4,,4,6,6,,3,,,,3,6,6,4,4,4,4,3,4,4,4,4,4,4,4,3,
   7,4,,5,5,,,8,6,,4,8,8,,4,,,,4,,5,5,19,18,4,4,,6,19,
   18,6,,4,4,,,5,,,12,,5,,4,,8,,5,5,,,5,,5,7,7,8,4,5,31,,
   ,,8,31,4,5,,3,,6,6,4,4,,3,6,6,,4,4,,,4,6,4,6,6,6,
   3,4,4,6,6,6,6,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,
   6,,,12,8,,4,,,,5,7,,5,8,8,31,4,5,,,8,8,5,31,4,,,5,6,,
   4,,8,,,5,,,6,7,5,,,,4,31,5,8,8,8,8,5,4,31,5,,5,,8,5,
   8,,,,,,,,,,,,,,,,6,,6,,,,8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,
   ,4,,8,,4,,,,4,,5,5,18,6,4,4,,18,6,19,19,,4,4,,5,5,6,
   ,5,5,,,5,8,8,8,6,5,6,6,6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,
   ,,,,,,,,,,8,,4,5,,,5,5,,5,6,18,,4,4,6,18,19,19,4,,4,8,,
   ,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,12,12,8,8,9,9,9,8,8,
   8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,5,5,,18,6,4,,4,18,6,
   19,19,4,4,,,,4,,7,5,7,7,5,4,31,,8,,8,31,5,4,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,31,4,8,,,8,4,5,31,6,6,,,
   5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,,5,,,,,5,5,,5,21,21,
   43,4,4,4,8,43,21,21,21,21,21,4,4,4,5,21,21,21,4,4,
   21,21,21,21,4,3,4,4,21,21,43,21,4,4,3,21,21,21,21,3,
   4,4,5,5,4,21,21,21,8,4,21,21,21,4,21,21,43,21,21,21,
   4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,9,9,,,,,10,13,,22,,,,,,10,22,16,19,15,16,,,,,
   ,10,10,12,,22,12,18,,31,,,,,,,47,25,10,13,105,46,,51,,,,,
   6,,,8,,8,12,,7,,7,,,,10,7,17,18,11,13,,26,209,,,7,10,,,
   8,11,,,15,,,,,,29,35,,11,,78,35,81,78,,,,9,,,,,10,13,,,10,
   10,,19,12,,22,12,,,,,20,,,,,10,16,94,22,,,,,30,,,,,,105,13,
   17,25,47,51,,46,,,,,,6,,6,,,7,13,10,,,17,13,7,,,8,,,,,,,
   10,8,,254,7,17,14,,12,,19,,,,36,45,9,,9,45,45,36,45,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,8,12,,7,10,7,,18,11,,7,,,11,13,,17,,,
   ,7,9,17,,8,,,,,,24,,,,81,78,,,,35,78,29,35,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,,12,,6,,,,,12,,,8,11,,,,,,6,7,
   ,,12,,16,,,,24,,,,36,49,10,8,10,49,44,36,44,,,,,,,,,,,6,
   6,6,8,6,4,,,71,,,5,5,6,28,6,7,6,,,9,9,,,,63,44,7,20,
   5,58,95,19,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,
   6,6,6,8,6,,,,,,,5,5,6,18,6,7,6,,4,7,,,,,39,39,5,5,4,
   39,39,11,11,,,,,,,5,6,6,6,8,6,,,,,117,,5,5,5,32,6,7,6,,
   ,6,,,,,44,63,20,7,5,98,77,19,11,,,,,,,5,5,5,7,5,,,,,,,
   5,4,5,16,5,6,5,,8,8,6,,,,29,29,,,5,29,29,10,10,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,,,7,8,9,35,
   10,9,8,,,11,,,,,,,26,9,6,134,,21,14,,,,7,7,9,9,7,,,,,,,
   6,7,6,33,8,8,7,,,,,,,,,70,,,7,116,,20,12,,,,6,5,,,,,,,18,,
   ,4,6,71,6,5,,,,7,,,,,19,98,5,7,20,63,11,44,77,,,,,10,
   6,7,,8,18,,,5,5,,,4,7,6,,7,,8,,,,39,11,5,4,5,11,39,
   39,39,,,,9,6,7,,8,16,,,5,5,,117,,6,6,,7,,8,,,,63,11,7,
   5,20,19,98,58,51,,,,,,,,,27,,,6,10,,10,,,,,12,,,,,21,134,
   6,9,26,,14,,,,,,7,,,,20,,6,4,6,,6,,,,7,7,,,,,12,51,4,5,
   5,51,12,51,51,,,,,,,,,5,5,7,39,7,,7,,,10,10,,,,64,,7,25,,
   ,96,26,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,
   ,,,,,,7,14,7,,22,84,22,,,,,,,15,32,,18,,71,,,33,,,,,71,,,,,
   ,44,44,71,,,,,16,22,71,,,19,28,,,,46,,,,,44,,,,117,,71,44,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,,5,,,,,6,,,,,10,29,5,,,29,10,
   29,29,,,,,44,,7,5,,6,,7,,,,13,10,,6,6,10,13,31,31,,,,,,
   9,6,,7,5,8,,,,58,19,20,5,7,11,51,63,98,,,,,,,,26,,,,,,
   44,44,,,,71,117,,,,,,8,6,,7,,8,,,,40,11,10,6,10,11,40,
   40,40,,,,,,,11,,,,,20,116,7,,,70,12,,,,,,,7,7,,,,,11,44,5,
   20,7,77,12,98,63,,,,,,,,,,,,,,,,,,,,,,8,,,,,40,,10,10,,,40,
   15,15,,,,9,,,,,20,,8,,12,,81,124,,,,,,,75,,7,14,7,,18,,35,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,29,31,18,18,19,41,19,
   40,,,,18,31,20,41,19,19,29,,,,5,5,20,31,18,16,,,,5,52,
   14,18,24,,,,18,16,31,31,,,,29,29,19,,,,40,19,,,,41,,,,,,,,,,
   ,10,,,9,,8,,11,8,10,8,,9,6,5,,11,10,6,,8,11,8,8,,,,,,
   5,,5,,6,10,8,,8,,10,,,,20,20,11,19,11,,,,20,56,56,113,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,5,6,6,5,
   6,5,5,6,7,8,6,8,4,16,,7,8,8,15,7,,13,,,,6,8,15,4,,
   7,15,10,,20,,,,,,,56,8,12,8,10,7,8,98,98,82,46,8,8,8,
   6,5,6,6,7,6,7,8,6,8,4,,17,7,8,8,13,7,,,,,13,6,8,20,
   4,,7,,10,16,,,,,,18,46,,12,7,8,7,12,10,56,82,46,,6,4,
   6,6,7,4,7,8,7,6,8,6,6,,,7,6,8,13,7,14,,15,,,8,6,19,
   6,,7,17,6,17,,,,,,,64,32,7,10,10,20,10,23,34,71,,64,8,
   6,8,8,6,7,6,7,8,6,8,4,,16,7,8,8,,7,,,20,,,6,8,,4,
   18,7,,10,17,,13,,13,,,82,46,7,10,12,12,8,7,,46,,56,6,
   6,4,6,5,8,7,6,8,6,6,15,,7,6,8,,7,,,,,,8,6,,6,,7,14,
   6,,15,,14,,,,,64,10,20,7,10,7,20,32,,64,32,5,4,4,5,7,
   8,7,7,7,4,8,10,8,7,8,9,7,10,9,10,,,7,7,11,4,,7,9,
   6,9,10,9,10,,,15,29,61,13,8,10,8,13,6,22,34,29,61,8,
   6,5,6,7,8,6,8,4,20,,7,8,8,,7,13,,15,,,6,8,,4,,7,,10,
   ,16,15,15,,,,98,82,10,8,7,8,8,12,46,,56,98,6,7,8,7,
   6,8,6,6,,17,7,6,8,,7,,14,19,,,8,6,15,6,,7,,6,,,13,17,,
   ,,71,,20,23,10,7,10,10,64,64,32,34,5,7,8,7,7,7,4,10,
   9,8,7,8,9,7,9,10,11,,,7,7,10,4,15,7,10,6,10,8,9,9,,,
   ,34,29,8,6,13,13,10,8,61,29,61,22,6,8,8,6,8,4,,,8,
   8,7,,8,18,18,20,,12,6,8,20,4,15,8,20,7,,,,20,12,,15,,
   154,7,7,8,7,8,7,158,,154,158,5,5,4,4,4,6,,6,4,7,,7,,
   6,,,,4,4,6,3,7,5,6,5,6,6,8,8,8,,,,19,5,19,6,6,19,5,
   14,19,14,,5,5,5,4,8,8,6,7,7,7,6,7,,7,,,6,5,,4,8,4,
   7,5,,7,,7,8,,6,,16,15,4,6,4,15,6,,,,16,4,4,4,,6,5,5,
   4,6,5,6,8,8,,7,4,4,6,4,,5,8,4,6,,6,,4,,,14,19,4,4,
   3,19,5,17,19,14,,,5,4,,6,5,5,4,6,5,8,8,6,,7,4,4,6,
   4,8,5,,4,6,,6,,7,,8,14,,19,6,5,19,5,6,19,14,,18,4,6,
   ,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,8,6,,,,,,5,19,
   17,4,4,3,14,19,14,19,5,5,4,3,4,5,4,6,5,6,,5,3,4,5,
   2,5,4,5,4,5,6,5,6,5,,,13,14,4,13,4,13,4,4,13,13,13,
   14,8,7,8,5,8,7,10,10,9,,10,6,,8,6,,7,6,8,10,,9,,7,,
   14,15,,16,8,5,,6,11,78,29,,,,6,6,6,,,9,,,,6,6,9,5,7,
   8,8,6,6,10,7,9,,,,,,6,,78,7,13,5,29,78,29,40,5,7,,4,,
   7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,,4,6,15,15,6,4,
   16,,16,,7,8,5,6,,6,,,4,4,,4,,6,6,4,,6,8,6,,,4,19,14,
   4,3,4,5,17,19,19,,,14,6,7,10,10,10,,,7,4,10,4,8,7,5,
   4,6,5,6,5,,,8,,15,6,6,,6,,6,15,,15,15,,,10,,,,8,6,10,
   5,10,7,8,6,7,9,6,10,,,,78,47,5,7,13,,14,6,29,,29,,,7,,
   ,14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,,4,5,5,7,7,5,16,
   ,16,,8,6,,,6,8,8,5,7,7,10,6,9,10,10,8,,,,,,6,78,,13,
   7,5,29,40,29,78,8,,,,6,6,6,,,8,6,,10,,10,,,7,40,29,13,
   5,7,6,,78,78,,,29,,,6,6,8,5,10,7,9,8,9,8,10,10,14,,
   126,,78,5,16,8,11,,7,29,40,29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   4,14,5,9,9,7,7,,7,,10,,,,,23,,,,7,,7,23,,,,5,,4,,7,8,5,
   ,6,,6,,,7,19,14,6,5,19,5,6,19,,,19,14,8,4,,5,,4,6,,
   6,8,7,,,14,,19,17,5,4,3,4,,14,19,18,6,126,,10,8,,9,,9,
   ,,10,40,29,11,7,,5,8,16,,,78,29,,4,6,4,5,5,5,5,5,,5,
   13,13,13,4,4,4,4,13,14,13,14,13,9,,,,14,,,,,,23,23,,,,
   7,7,,,,,,8,5,,7,,7,14,,8,,16,7,5,7,4,5,5,,,,16,,9,,10,
   ,10,,,15,,78,,6,7,5,13,,29,78,,6,8,6,,7,,,14,19,6,19,
   5,6,5,19,,14,19,,8,6,8,,,7,78,25,7,5,13,6,78,,40,,,
   25,8,6,10,,,29,,,11,6,16,5,8,,15,,78,8,,,10,,25,,6,14,
   5,13,7,,78,47,25,7,,,29,78,7,13,5,78,6,,,15,,,,9,,,7,7,
   ,,,,,,23,23,,,,,,,,,,,,,,,,7,,7,,,,,23,23,,,28,27,98,14,19,
   14,,,,,41,70,28,19,14,14,,,,14,4,4,10,8,10,70,14,19,14,
   5,10,10,9,44,14,14,19,8,11,10,41,19,14,14,4,4,14,28,
   41,60,5,14,98,28,41,19,27,70,44,,14,,,,,,,6,9,9,,,6,,9,,
   ,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,
   ,,30,30,30,,,,,,,7,10,10,,,,13,22,,,,13,10,15,,,,10,,,,,,,
   21,,15,,,10,20,,,,94,,25,10,,47,,,,,12,,140,103,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,6,9,,7,8,7,,,7,12,7,,,
   ,12,7,,,8,,9,13,,,,7,,,,11,24,,10,14,,,,,,,11,29,35,35,,,
   ,11,81,35,29,,9,,,,,9,,12,10,,,15,26,10,7,13,,,,8,11,,,,,
   ,13,,,,,8,,,,177,177,,12,8,,41,55,,,,14,,55,34,,,6,,7,15,
   ,8,,8,,16,26,14,8,15,18,10,,,17,,,,8,,,,9,23,,9,,,13,
   136,,,,8,46,37,39,,,,,56,36,46,,9,,,17,,18,17,18,,27,26,
   15,,11,,16,19,11,,,,,16,,15,,,,21,11,,,,,,143,23,37,,,120,,,
   ,11,95,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,14,,8,
   14,8,,21,,,8,,,10,,9,,,,,8,,15,,9,,,,,,,,136,,,,56,75,36,,,,
   ,46,39,56,10,11,,10,10,12,,16,19,10,,15,14,12,,,17,,,,
   12,,15,,,19,12,,,,18,,,244,8,12,32,,74,,,,13,32,74,39,,,
   11,,10,,,,,11,,,10,,8,,,,,10,,16,,10,,,9,,,13,,,,10,10,125,
   47,97,,,,10,97,97,125,,,,,,5,,6,5,6,7,6,,4,,,,,6,,6,,6,
   8,6,5,,,,32,71,,20,7,44,63,11,,,,5,19,58,95,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,5,6,5,6,5,5,,,,5,,5,,
   5,7,5,4,,,,16,,,,,29,29,10,,,,5,10,29,29,,,,,5,5,6,7,6,
   5,5,6,,,,6,,6,,6,8,6,5,,,7,32,,117,7,20,63,44,11,,,,5,
   19,98,77,,,,6,5,6,7,6,,4,7,,,,6,,6,,6,8,6,5,,,7,18,,,
   5,5,39,39,11,,,,4,11,39,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,7,8,7,8,7,,7,,,,,7,,9,,7,9,7,7,,,,33,,,,,,70,12,,,,
   7,20,,110,8,8,9,9,8,,6,,,,,8,,10,,10,10,8,8,,,,35,,,26,
   9,,,16,,,,6,21,,125,5,6,,,,5,4,,,,,,6,,6,,,5,5,,,,32,71,
   5,20,19,58,98,,,,7,63,11,51,,8,5,7,,6,,,,5,,,,6,8,5,,7,
   ,6,,,16,,5,29,10,29,,,,,29,29,10,9,6,8,5,7,,,,6,,,,,10,
   6,,8,,7,,71,28,20,5,44,11,63,,,,7,98,77,12,,,7,,,,,5,,7,
   ,7,,,6,,,5,,19,,7,,12,49,,,,,,,12,49,,5,,,,,4,,6,,6,,,4,,
   ,4,,18,,6,10,11,40,40,,,,10,40,11,40,5,,,,,,,8,,8,,,7,,,,
   ,41,,7,14,18,,,,,,7,35,84,,5,,,,5,,,,5,8,5,,7,,6,22,44,
   15,6,6,31,10,13,,,,,13,37,10,,,,,,7,,7,,,6,6,,,,45,,,22,
   26,,99,,,,7,64,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,4,,,4,,18,,4,5,11,39,
   39,,,,5,39,11,39,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,5,8,,7,71,,
   18,7,5,98,19,77,,,,20,44,63,11,,,,,,,,,,,,,,,,,,,,,,,10,6,
   5,8,,7,,,20,5,4,51,12,51,,,,5,51,51,12,,6,,,,,25,,6,9,
   15,,,,,,26,,21,134,4,,,,117,16,,5,7,11,63,51,,,,20,58,19,
   98,5,,4,44,22,16,,6,13,10,37,,,,6,31,13,10,,,41,,,7,14,
   35,,84,,,,7,18,,,,,,,,,,,,,,,,,,,,26,,,10,15,,40,,,,10,40,15,,
   ,,,,44,44,,,,,,,71,117,,,,,71,71,,,,,44,,44,,,44,,44,,,,,71,
   117,,5,31,18,24,,,,5,18,52,14,18,31,16,,,,5,18,20,31,
   29,29,,,,20,19,41,19,40,,,,18,19,19,41,,,,31,41,19,19,,,,,
   ,,,,,,,,,,,31,18,16,29,40,29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,9,9,,,,,10,,,,10,22,16,,,,10,12,30,22,,,10,
   ,,13,,20,,,,,,12,19,,,,,94,,,47,,51,13,25,17,,,105,46,,6,,
   ,8,,8,,,7,10,7,17,,,,7,,,8,,13,9,,,12,7,17,,,11,24,,11,
   18,,,,,,,,35,29,78,,,,,81,78,35,9,,,,,10,,10,10,,22,12,31,,
   ,,16,,22,,16,10,,,13,22,,,,15,,18,,,19,12,,,,,,105,,46,25,
   13,10,,,47,51,,,6,,6,,13,10,13,7,,12,,,10,,,7,,,8,,,,7,,,
   ,8,19,14,17,,,17,,,254,,,45,36,45,9,9,,,36,45,45,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,8,,10,7,,7,,15,,,7,17,,8,,13,10,,,12,7,26,
   ,,11,,,,,18,11,,209,,,,78,81,35,,,11,,29,35,78,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,12,,,,,6,,,12,,11,7,,,10,
   12,,,,8,24,16,,,,,,,,,,49,36,44,10,10,8,,36,49,44,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,6,,,,5,5,7,6,,,4,,,6,6,
   ,,,,,,7,8,,5,18,,71,,,63,44,11,5,20,7,,19,98,77,5,5,5,,
   ,,5,5,6,5,,5,5,,,5,5,6,,,6,,,6,7,,,16,,,,,29,29,10,5,,,
   ,10,29,29,6,5,,,,,6,6,6,,,5,,,,,,,,6,,6,5,,8,7,117,,32,,
   ,98,19,77,20,5,7,,44,63,11,,7,,,5,,,4,,7,5,,,6,6,8,,,
   6,8,6,7,10,10,7,,18,,,,11,39,39,5,5,4,,39,11,39,7,,,5,
   ,5,,,7,,,,6,6,8,,,6,8,6,6,9,10,9,71,32,,,,11,63,51,
   20,7,5,,58,19,98,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,,26,,,,
   15,40,10,,10,,40,,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,
   16,,,29,10,29,,5,,,29,29,10,,,,7,5,,,6,6,8,,,6,8,6,9,
   10,9,6,,18,117,,,19,58,98,7,20,5,,63,11,51,,,10,,,,9,7,
   11,,,7,9,7,,11,12,11,,33,,,,12,81,,,,8,,,20,124,,7,,,,6,
   6,8,,,6,8,6,8,10,10,8,,18,,,,11,40,40,10,10,6,,40,11,
   40,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,39,,,,
   26,96,7,,25,,64,,14,,,5,5,5,,,4,7,5,7,8,6,7,22,16,44,,
   ,10,31,13,,6,6,,13,10,31,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,6,9,6,,,8,7,,71,28,,,58,19,95,7,5,20,,
   63,44,11,,,,6,,6,,,8,7,,,18,,,39,11,39,5,4,5,,39,39,11,,
   ,,,5,,,,,,,,,,,84,22,7,7,14,,,,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,7,8,,,20,,,,,51,51,12,4,5,5,,12,51,51,,,,,,
   46,,,,,,,18,7,7,14,,75,,35,7,8,,,28,71,,,,77,98,12,5,7,
   20,,11,44,63,,9,8,,,33,,,116,20,,,7,,,,70,12,10,9,,,35,,,
   134,21,,26,6,9,,,,14,,27,,,,,,,14,6,26,9,,21,134,,19,,,,,
   70,,12,7,,,,20,116,,,,,,117,71,,,,,,,44,44,,,,,44,44,,,,,71,
   ,71,,,71,,117,,,,,44,44,,,,,,,,,,,,,,,,,,,,,,,29,29,20,18,52,
   ,19,41,19,40,18,31,18,,19,19,41,31,16,14,,41,19,19,5,
   5,,31,18,16,5,,18,20,31,,18,31,24,,,,29,40,29,3,4,4,4,
   3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,
   12,,8,,,,,,16,16,16,16,8,8,16,24,8,24,8,16,4,4,4,3,4,
   4,4,4,4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,
   8,,,,,,16,16,16,16,8,8,16,24,8,24,8,16,4,4,3,3,3,3,
   4,4,4,4,4,4,6,,4,4,4,,4,,6,,,,4,4,7,4,,4,8,6,8,,6,,,
   ,,8,12,12,8,8,8,12,10,8,10,8,12,3,4,3,4,4,4,4,6,4,
   6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,
   24,16,16,24,8,8,16,8,8,8,8,16,4,3,4,4,4,4,6,4,6,7,
   8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,24,
   16,16,24,8,8,16,8,8,8,8,16,3,4,4,4,4,4,4,4,4,8,,4,
   4,4,8,4,7,7,,,,4,4,,4,,4,,6,,8,8,,,,,8,10,10,8,10,10,
   10,8,10,8,10,10,4,4,4,4,4,4,4,4,8,,4,4,4,,4,7,5,,9,
   ,4,4,7,4,9,4,,6,,,8,,,10,,8,5,5,8,8,8,5,8,8,8,8,5,
   3,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,
   ,,,,,,16,9,9,16,36,36,9,9,36,9,36,9,6,6,7,6,7,5,,,6,
   7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,16,9,9,16,36,
   36,9,9,36,9,36,9,4,4,4,4,4,8,,3,4,5,6,5,6,7,,11,,
   4,4,6,4,8,7,6,7,6,6,,,,7,,38,5,7,38,7,8,23,8,9,8,
   8,17,4,4,4,4,,,4,4,4,6,4,6,,,8,,3,4,6,5,11,5,6,7,
   6,6,,,,,,38,7,23,12,8,8,17,8,7,7,23,6,4,4,4,,,4,5,4,
   8,5,6,,,15,,4,4,6,8,15,6,7,8,8,7,,,,,,13,9,16,16,6,
   9,12,9,9,6,9,9,4,4,,,4,4,4,6,4,6,6,,,,4,4,5,4,7,4,
   6,6,6,,7,,,,,12,23,17,9,8,23,6,7,8,9,21,6,4,,,4,4,4,
   7,4,,11,,,,4,5,6,4,6,5,8,7,6,9,9,,,,,16,16,12,13,9,
   9,9,6,6,9,20,13,9,,5,4,4,10,5,,6,,,,4,8,6,4,10,6,
   10,8,6,,4,,,7,,12,32,7,62,12,34,8,12,8,8,13,22,,7,9,
   4,9,6,8,9,,,,4,7,6,7,15,6,7,8,8,,,,,,,17,,,22,11,36,,
   13,15,10,96,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,,5,,8,,,
   ,4,4,6,4,12,4,6,7,,,4,,,7,,9,17,6,9,17,21,6,9,8,21,
   9,5,4,9,5,11,,,,,4,4,6,4,13,4,6,7,,11,7,,,,,13,12,9,
   9,9,20,13,9,9,22,22,4,,5,10,,,10,,5,4,10,4,8,5,6,8,
   7,6,7,,,7,,62,7,8,13,34,13,22,8,12,31,8,7,,,11,,,,,11,
   ,6,15,8,,12,12,12,6,,,9,,19,18,10,34,,,8,12,14,63,17,
   13,6,6,,11,,7,6,9,6,,8,11,7,,8,6,,,6,,21,12,5,23,23,
   15,10,21,21,10,7,10,6,,,,6,7,7,6,15,8,12,9,,6,11,,,21,
   ,25,90,16,25,,,13,16,11,28,40,,,47,,6,6,7,7,16,7,6,9,
   ,6,,,,,,25,22,,25,15,12,,11,12,12,58,10,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,12,,15,8,,8,,11,15,,14,,,,,41,,,,,,8,11,36,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,6,5,,,7,,9,6,6,12,21,9,
   5,21,17,23,7,7,7,4,,5,,8,11,,5,,,10,,9,9,13,13,22,22,
   4,22,9,22,9,9,7,,,6,,,12,,,,11,,25,8,14,89,28,16,10,,
   27,,11,12,,5,7,8,11,11,,,,,,13,8,22,13,13,8,7,31,34,8,
   31,6,,,,,,16,,,,,41,13,,97,,11,13,,,,,,,7,8,7,,,,,,23,5,
   10,18,15,7,10,10,23,17,17,11,,12,,,,,,,23,15,10,,12,14,
   9,,63,14,15,16,,10,10,,,9,,,8,8,,31,10,10,,,12,10,66,,7,
   ,,11,,19,12,15,23,63,12,10,,27,,14,9,9,,,,,23,53,18,19,
   14,,10,14,15,12,,8,,,,,61,8,,17,15,11,,,,13,36,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,196,,20,14,,,,,11,,8,,,,,,,,,,,,,16,33,,24,
   18,13,18,23,24,34,32,18,23,17,9,4,6,9,23,35,26,16,9,
   17,18,18,30,6,9,4,23,24,33,34,23,18,18,13,25,30,19,
   25,22,6,6,9,22,6,19,25,30,10,6,18,17,18,22,25,22,16,
   35,46,23,22,10,9,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,
   6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,16,16,16,16,8,8,
   16,24,8,24,8,16,3,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,
   ,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,16,16,8,16,
   16,16,8,16,8,16,16,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,
   ,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,16,16,8,16,
   16,16,8,16,8,16,16,3,3,3,3,4,4,4,4,4,6,,8,4,4,6,5,
   4,8,,5,,,4,4,6,6,,4,7,6,7,5,,8,,,,10,8,8,10,10,10,8,
   10,10,10,10,8,4,4,3,4,4,4,4,4,4,,8,4,4,4,6,4,6,,7,,
   ,4,4,,4,,4,,6,,6,,8,,,,10,8,8,10,12,12,8,8,12,8,12,
   8,3,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,
   9,,,,8,,,9,8,24,24,8,16,16,24,8,16,8,16,24,4,4,4,6,
   4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,
   24,24,8,16,16,24,8,16,8,16,24,4,4,5,4,5,4,,6,4,5,4,
   ,4,8,,8,7,9,4,5,6,4,,4,5,6,5,,,6,9,,8,10,8,8,10,7,
   7,8,9,7,9,7,8,4,4,4,4,4,,,3,4,5,6,5,5,,,7,,4,4,6,
   4,,7,6,7,5,5,,,7,,,17,9,12,23,6,5,38,9,6,7,7,38,4,
   4,4,4,,,4,4,4,5,4,8,,7,12,,3,4,6,5,,5,5,7,6,7,,8,
   11,,7,23,12,38,7,5,7,38,7,6,8,23,12,4,4,4,,,4,5,4,
   8,5,4,,,13,,4,4,6,8,,6,6,8,6,10,,,6,,,12,13,16,16,4,
   9,13,9,13,6,16,16,4,4,,8,4,4,4,7,4,,,5,,12,4,4,6,4,
   ,4,6,6,6,,,5,8,,7,7,38,38,5,7,23,12,8,5,8,17,9,4,,,
   4,4,4,10,4,,,10,,,4,5,8,4,,5,6,7,6,,,4,15,,10,16,16,
   13,9,9,16,16,6,4,9,12,13,,9,5,4,4,11,5,7,,7,,8,4,8,
   6,4,,6,10,8,6,7,,7,10,,,7,62,12,32,6,32,12,8,7,12,7,
   62,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,7,8,,,,17,163,4,
   5,8,4,,10,10,10,6,8,,,15,,,,22,17,,12,12,61,10,8,13,
   11,32,4,4,,5,,,6,,7,4,4,6,4,,4,6,7,6,6,,4,,,7,5,38,
   12,6,23,17,9,8,7,23,6,9,4,,5,,,8,,13,4,4,7,4,,4,6,7,
   ,11,,5,,,4,9,13,16,4,16,12,13,9,9,9,9,9,7,5,9,,11,8,
   ,5,4,10,4,,5,6,8,,6,,4,,,8,32,12,12,6,32,7,62,12,6,
   34,8,13,,,,,,13,6,11,6,6,,8,6,,12,11,,8,,,18,12,25,25,
   16,,,33,12,22,58,10,37,8,,,,,7,6,11,6,,8,9,7,10,8,,10,
   12,,12,12,21,10,7,7,12,21,21,11,23,5,23,,7,163,17,7,
   9,9,4,,6,11,8,8,9,,4,,,11,12,61,17,12,,,22,11,8,36,,
   20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,13,,8,6,,6,,,11,,,,,9,,,,,33,
   25,,16,12,25,,18,12,9,168,,8,,,10,,8,,13,45,,,,,,,9,,,,,,
   52,12,13,,,,11,6,,8,,,11,,16,10,,,,,,,52,,,,9,,48,9,,,,4,,
   4,,5,6,7,,8,,7,,,7,6,12,9,6,17,6,9,17,23,21,6,12,9,
   4,,5,,8,11,,,7,,,10,4,16,13,13,12,9,9,9,16,20,13,13,,,
   ,6,,,11,,,,,19,15,23,19,12,18,10,34,,53,,8,30,,5,,8,10,,
   ,,10,,8,6,12,62,7,7,8,13,34,33,13,22,13,,,,,,,,,,,,,,,,,,,
   ,,,,10,7,6,6,,10,11,,12,7,10,21,11,12,5,23,23,7,15,
   10,18,,12,,,,,,,8,25,25,,16,13,26,,90,40,,36,11,9,,,15,,,
   10,18,18,143,10,8,,,143,31,8,,6,,10,,,8,14,89,25,8,90,
   16,25,,35,,13,26,,7,47,,11,9,168,25,12,22,,25,15,,12,,
   33,,,,,,,,,,,,,,,,,12,,,,20,22,,8,12,17,,30,10,12,61,,12,,
   97,41,13,,,,,,,8,41,,,,,,,,,,,,,,,,20,,9,168,,,,11,9,,16,33,
   18,27,4,13,6,7,18,27,32,,23,33,13,,18,16,34,32,,16,16,
   33,,24,23,18,13,,7,27,33,23,13,6,4,13,18,23,17,18,9,
   4,12,16,9,4,17,18,23,23,12,24,33,,9,25,30,23,35,26,
   50,9,23,16,4,3,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,
   10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,16,16,8,24,24,16,8,
   24,8,24,16,4,3,3,3,3,4,4,4,4,4,4,,,4,4,4,8,8,,,8,
   6,6,4,4,6,4,6,8,7,4,7,8,,,6,6,6,4,4,4,4,4,4,4,4,
   4,4,4,4,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,4,
   6,10,7,9,6,8,9,8,,,,,,,8,16,16,8,24,24,16,8,24,8,24,
   16,4,3,4,4,4,4,4,4,4,,,4,4,4,8,4,5,7,7,10,,4,4,,4,
   ,4,,6,,8,,,,9,9,8,8,8,8,5,5,8,8,5,8,5,8,4,3,6,6,
   5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,
   10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,5,,,4,
   4,5,6,6,5,6,6,9,,4,4,8,5,8,6,7,4,7,6,,,,,7,6,8,8,
   6,8,8,8,6,8,6,8,8,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,
   6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,
   7,4,4,4,5,5,,,4,4,7,6,7,8,,,7,,4,4,8,6,8,7,,7,6,4,,
   ,,,,57,7,10,,8,6,,7,7,7,7,57,4,4,4,4,,,4,5,5,4,4,6,,
   ,7,,4,4,8,7,8,7,6,6,8,7,,,8,,,,10,,10,6,7,57,7,8,7,
   64,7,5,3,5,,,4,6,5,9,6,5,,,7,8,4,3,5,5,8,4,6,5,9,
   5,,,6,8,8,6,6,4,4,5,6,6,6,6,5,5,5,4,5,,,4,4,4,7,
   4,10,10,6,,6,4,5,6,5,,4,8,5,8,,,,8,,7,10,,57,7,7,64,
   7,7,6,7,32,10,5,,,5,3,5,5,4,,5,6,7,7,4,6,9,5,6,6,
   9,5,5,,,,8,7,7,4,4,6,6,6,5,5,5,5,6,6,6,,,7,5,6,10,
   7,8,7,8,,7,6,5,8,5,10,5,10,5,8,,,,10,7,,7,64,7,64,
   16,,6,17,8,17,10,32,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,7,,8,7,,,4,4,,4,6,4,8,6,
   7,7,,,,9,8,7,57,7,10,64,32,10,7,7,35,7,7,5,,6,5,,6,
   7,8,5,3,6,5,8,4,5,5,,6,,,6,6,6,6,6,5,4,5,6,6,6,6,
   5,5,4,,7,,10,,,,7,5,10,6,,7,8,8,,5,,,,9,,64,7,6,8,,
   10,32,17,16,71,8,7,,,9,,,,7,6,8,5,,4,7,8,9,,,,68,8,,
   8,24,8,14,42,,,8,12,29,7,9,6,12,,8,9,7,4,9,5,9,4,9,
   7,,4,,,10,6,10,7,7,4,7,7,7,7,7,7,7,5,7,10,8,47,18,
   8,6,6,7,12,12,,9,10,9,,,,,16,11,34,10,7,,22,15,25,13,
   28,14,10,,13,,7,6,8,8,19,7,6,7,,,,,37,,13,,11,28,7,13,
   9,,13,12,30,35,10,,,8,6,11,8,,9,11,11,6,6,,,17,13,,,9,
   7,28,19,11,,22,17,30,10,68,7,7,7,8,,7,4,13,8,,,,,,,,6,
   ,96,124,,,,8,7,,111,,8,6,,,6,6,25,,,8,,,,,,,7,,,,,,,,,,,4,
   ,5,,7,7,7,,8,,,,8,9,10,7,10,7,32,7,7,35,64,35,8,10,
   6,5,7,6,,5,6,,,,8,7,7,4,5,6,6,6,5,4,5,5,6,6,6,8,
   133,,,11,,11,,,,,17,10,10,9,9,18,16,20,31,46,,15,12,,7,,
   5,9,10,,,10,,9,8,6,32,7,10,8,7,71,,8,34,8,6,235,,,10,,
   ,,,,9,6,,231,,9,8,,,,,,,7,10,,,,9,11,11,7,4,7,7,7,5,7,
   7,7,7,7,7,,10,,,,12,18,,10,10,12,,11,11,21,31,32,11,9,
   19,10,7,,,9,9,,7,7,7,34,17,17,7,,71,18,8,34,7,,,133,
   14,27,9,9,10,10,32,11,12,,26,31,11,21,,,13,,10,8,26,
   24,8,12,42,8,10,16,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,10,,
   231,9,6,,,,,,,,7,8,,,,,9,,,,,,,7,,,,,,,,,,,7,,4,21,40,18,5,
   6,6,7,23,18,14,40,17,18,7,4,6,5,16,20,18,4,5,18,40,
   23,18,6,7,4,7,18,21,16,19,6,5,6,26,18,20,26,7,6,6,
   5,5,6,20,26,18,7,6,23,18,40,7,,42,14,30,54,18,5,7,5,
   4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,9,4,4,8,6,
   ,9,11,12,11,,,11,9,,,8,16,16,8,16,16,16,8,16,8,16,16,
   4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,4,6,10,7,9,
   6,8,9,8,,,,,,,8,16,16,8,24,24,16,8,24,8,24,16,3,4,4,
   4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,
   ,24,8,8,24,16,16,8,16,16,16,16,8,4,4,4,4,4,4,4,6,8,
   ,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,24,8,8,24,16,
   16,8,16,16,16,16,8,3,4,4,4,4,4,6,5,7,4,4,6,,4,,8,6,
   ,,4,4,5,6,,4,8,6,8,,5,7,,,,10,10,10,10,8,8,10,10,8,
   10,8,10,4,4,5,4,5,4,,5,4,5,4,,4,,8,6,,9,4,5,8,4,8,
   4,6,6,6,,,5,9,7,,9,7,7,9,8,8,7,10,8,10,8,7,4,4,4,
   4,4,8,,3,4,5,,5,,7,,,,4,4,8,4,7,7,7,7,4,,6,6,11,8,,
   21,6,6,17,9,9,17,6,12,6,12,23,4,4,4,4,6,6,4,4,4,,4,
   ,,6,,,3,4,6,5,7,5,4,7,5,,,6,7,,,23,6,17,8,9,12,23,
   6,9,5,67,7,4,4,4,,11,4,5,4,,5,,9,9,,,4,4,6,8,10,6,
   7,8,5,,11,,6,,,20,13,9,9,9,13,12,13,13,4,16,16,4,4,,
   6,4,4,4,,4,,,6,,8,4,4,5,4,7,4,5,6,8,,7,6,12,,,8,17,
   23,8,12,38,7,5,9,7,38,5,4,11,,4,4,4,,4,,,7,,,4,5,8,
   4,4,5,5,7,4,,,6,13,,,9,9,12,9,13,16,16,4,9,9,13,9,,
   10,5,4,4,,5,,4,,,10,4,8,6,4,8,6,,8,4,,6,,8,10,,13,
   22,8,34,13,62,7,7,13,6,12,33,6,7,,6,,6,,9,11,,47,5,
   10,,7,11,8,7,9,8,,11,,10,,,12,,,15,25,25,22,12,33,9,
   168,,6,6,,,6,,8,,,,5,6,,6,8,10,10,11,6,,12,12,16,45,,,
   13,16,,25,25,90,8,26,14,89,35,4,4,,5,,8,6,,11,4,4,7,
   4,7,4,8,7,,,5,5,,12,,8,23,7,7,38,38,5,7,12,23,12,6,
   4,,5,,,8,,15,4,4,10,4,10,4,4,7,,,10,6,,,,9,12,16,6,
   16,13,9,9,13,16,16,4,,5,,9,10,,,5,4,11,4,8,5,4,8,7,,
   7,6,,8,,34,8,7,12,62,12,32,6,13,32,12,6,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,6,,,11,7,6,,6,12,8,10,7,10,,8,10,,8,,15,
   10,5,23,23,21,12,11,18,7,10,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   9,,,5,4,7,7,11,8,4,8,,,,11,17,163,,36,,,11,22,17,,12,
   20,12,61,8,,,6,6,,6,19,11,,,8,,6,6,,,,,8,10,,34,19,18,
   12,30,15,23,53,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,6,,10,12,12,12,
   15,15,,,,,,,,8,,,,41,,13,41,,97,,4,,4,,5,,7,,,6,6,,7,,7,
   7,5,9,38,12,6,23,38,17,9,6,,4,,5,,8,,,8,6,,13,,6,16,
   9,9,13,16,4,16,16,12,13,13,7,,,9,,,,,11,,13,,12,9,12,,
   25,25,16,,168,,33,18,,5,7,8,9,,11,10,8,,,12,7,32,8,12,
   12,6,32,62,7,62,7,12,,,,,18,,,,,11,9,,,,20,9,,,,,,10,7,8,
   ,,9,,,,23,5,12,21,21,10,7,7,23,12,21,11,,,,8,,,,,10,12,
   12,,17,22,8,,61,,20,32,10,,,,,13,,31,8,8,,,18,10,143,,
   10,18,143,,7,10,163,17,,13,11,12,10,61,17,12,,32,,22,8,,
   ,,,,,,,,,,,,,,,,6,13,,,58,10,,12,33,25,,16,37,12,25,22,11,,
   ,40,,13,,26,25,16,,36,8,25,90,,,,,9,48,,,,,,,52,9,,,,,12,
   52,,,,,9,,13,,,,,,,,,,,,,9,17,25,24,18,9,6,23,18,34,35,
   18,30,33,13,4,4,16,27,32,26,9,16,33,18,27,23,4,13,4,
   23,24,17,23,23,6,18,9,,23,33,,13,,12,16,16,,33,,23,7,
   12,27,33,18,13,18,23,13,32,,50,16,7,16,4,3,4,4,4,4,
   6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,
   ,9,,24,16,16,24,8,8,16,8,8,8,8,16,4,3,4,4,4,6,4,6,
   7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,
   8,8,8,16,16,8,24,16,24,16,8,4,3,4,4,4,4,4,4,8,7,4,
   4,4,,8,,,6,6,6,4,4,8,4,6,8,,4,,,8,7,6,6,6,4,4,4,4,
   4,4,4,4,4,4,4,4,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,
   8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,16,16,8,24,16,
   24,16,8,4,4,6,4,6,4,,7,4,6,4,,4,,,8,6,6,4,6,8,4,6,
   4,7,4,7,,,7,6,6,6,5,6,6,5,6,6,6,5,6,5,6,6,4,4,4,
   5,5,8,,4,4,7,7,7,,,,,,4,4,8,6,,7,8,7,6,6,10,10,7,8,
   ,32,10,7,64,10,7,57,7,7,8,10,,4,4,4,4,10,10,4,5,5,
   6,4,,,7,6,,4,4,6,7,7,7,6,6,8,,,6,7,,9,64,7,57,7,7,
   10,,8,10,6,,10,5,3,5,,5,4,6,5,6,6,,,,8,7,4,3,4,5,7,
   4,6,5,6,6,5,,4,6,6,6,6,5,5,4,6,6,6,6,5,4,4,4,5,,
   6,4,4,4,,4,,,4,,7,4,5,4,5,8,4,8,5,6,,,8,7,,8,7,57,,
   6,10,,10,6,7,7,57,7,5,5,,5,3,5,6,4,,,5,7,7,4,6,9,
   5,6,6,6,5,5,,,5,7,8,7,5,5,6,6,6,4,4,5,4,6,6,6,10,
   ,7,5,6,,7,,,,,,6,5,6,5,,5,11,5,,8,7,8,8,10,,10,32,6,
   ,8,64,7,8,7,16,7,64,10,,,7,,12,,,9,,13,6,6,6,8,16,6,
   8,10,,,11,,7,,32,9,,28,13,7,,11,11,9,10,68,11,8,5,8,
   8,6,,,,18,47,6,6,9,,13,10,10,,8,,6,10,11,,,22,15,10,,
   7,11,34,16,8,9,11,,4,5,,7,,,6,,7,4,4,7,4,9,4,6,6,
   10,10,6,6,,6,7,6,,10,8,,57,7,7,10,64,7,10,5,,6,,,9,
   8,7,5,3,5,5,7,4,5,5,,5,6,6,7,7,6,6,6,4,5,4,6,6,
   6,6,5,5,4,8,7,,,10,7,,7,5,10,6,9,7,,8,8,7,8,,,7,9,,
   6,7,16,64,7,64,16,8,,6,8,,,,,,,10,5,,7,,6,10,,6,11,8,,
   ,11,16,11,,7,19,28,,9,9,11,35,10,10,,,,9,8,7,4,6,5,
   11,4,7,7,10,6,6,10,7,6,7,7,7,4,7,7,7,7,7,7,7,4,7,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,7,
   6,10,6,11,7,9,6,,9,23,10,131,,,8,42,14,8,24,8,,9,8,
   23,7,8,6,10,10,6,6,12,,,,11,14,,,,,,,,,,7,9,8,,,,7,4,
   23,8,7,7,10,8,11,7,,14,,,,,,,,,6,,9,,,183,,4,,5,,7,10,7,
   ,8,7,8,,,,8,10,7,7,57,7,10,64,,32,10,7,,5,6,6,,5,5,,
   6,6,7,8,7,5,4,6,6,6,5,4,5,4,6,6,6,,131,,9,7,,9,,11,
   ,,10,9,8,8,8,24,8,14,42,23,,,,,7,8,5,,10,,11,,,,16,7,
   64,8,7,6,8,,64,10,32,7,7,125,,,32,16,,,,,9,9,,,,8,7,,,,,
   ,10,7,6,12,,7,8,9,11,7,4,7,7,7,4,7,7,7,7,7,7,,10,,,
   ,14,14,,16,11,7,,10,15,8,22,34,14,10,18,,10,,,8,,,17,
   7,7,71,7,7,7,71,34,17,7,34,10,8,10,47,18,13,9,11,11,
   16,34,10,7,,,22,15,8,,8,13,,16,10,68,,11,11,28,7,13,
   11,9,,9,10,,,,35,10,,9,9,7,28,19,10,11,,11,10,12,125,
   14,10,15,22,8,7,10,,18,16,11,34,7,7,,,6,9,,96,124,,,,,,
   6,,,,9,7,,,,,,,8,,,8,,7,,,,,9,9,,5,18,26,18,5,7,4,7,18,
   18,20,40,18,21,6,4,5,4,18,14,18,5,4,21,40,18,17,5,6,
   4,7,18,18,23,19,4,5,7,40,17,18,40,7,4,4,4,5,4,18,
   40,17,7,4,18,21,40,7,26,18,19,20,18,17,5,7,4,4,4,3,
   6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,
   ,9,9,36,36,9,9,9,36,16,9,16,9,36,3,4,4,4,4,4,4,5,
   6,7,4,4,5,,6,6,5,8,,,4,4,6,5,7,6,,4,,,6,7,,9,8,6,
   8,8,6,8,8,8,6,8,6,8,8,4,4,4,4,4,4,6,6,6,4,4,6,6,
   4,6,6,6,,,4,4,6,6,,4,6,4,6,6,6,6,,,,10,8,8,10,8,8,
   8,10,8,10,8,8,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,
   ,5,,6,,9,,,,8,,,9,9,36,36,9,9,9,36,16,9,16,9,36,5,5,
   4,7,7,6,,4,5,6,11,6,,6,,,,4,5,6,4,7,5,6,5,6,6,7,7,
   ,7,,38,13,10,31,9,10,62,7,8,8,7,67,5,5,5,4,7,7,4,
   7,7,6,4,5,,6,,,4,5,8,6,11,6,6,5,11,6,,5,,,7,27,10,
   62,7,10,7,62,8,9,8,27,10,7,6,7,,6,5,5,4,7,5,5,8,8,,
   ,5,6,7,7,,5,11,7,7,,7,,,12,12,8,21,32,32,8,22,10,7,
   11,6,32,32,5,7,,5,5,5,4,6,4,7,7,6,,,4,7,6,7,9,4,
   11,6,6,,6,,,,8,7,62,62,10,7,27,10,8,10,7,38,13,7,7,,
   7,6,7,,6,,7,,,,5,5,7,4,8,5,7,6,7,8,8,5,,9,,32,32,
   10,22,22,32,32,6,8,10,8,21,9,10,6,4,4,10,6,9,5,9,,,
   4,7,5,4,7,4,9,7,5,9,5,9,,7,,7,,10,46,7,46,10,7,9,
   5,7,,7,6,8,5,8,6,6,7,10,,,6,,6,6,56,6,6,,9,,9,,,,11,
   9,,87,16,8,,19,25,49,7,,,,5,9,9,,,6,,,,4,6,7,4,11,7,
   7,6,6,8,10,8,,13,,44,34,11,,15,,55,6,9,14,11,34,5,7,,
   6,,6,11,,,5,5,6,4,9,4,6,5,8,8,6,4,,9,8,10,62,10,9,
   31,38,13,7,7,39,8,13,7,8,5,6,,7,,,7,6,11,7,,6,7,6,,
   7,,6,,,6,22,10,32,8,32,8,21,10,22,12,12,12,9,6,10,9,
   10,,,6,4,10,4,12,6,5,4,6,5,6,4,,12,8,46,10,10,7,46,
   7,,5,7,49,9,10,,,10,,,,8,7,9,5,12,6,8,7,10,9,8,7,,11,
   ,24,81,19,21,39,,76,9,9,78,11,70,,6,,,,5,5,6,4,11,4,
   6,5,7,6,6,7,,6,,21,15,9,20,20,21,15,7,9,16,6,16,7,9,
   ,,5,7,7,4,11,5,6,5,9,7,9,4,,13,45,,55,11,15,,44,34,
   6,9,,11,19,8,,,,6,6,6,,11,6,7,,9,,9,,,7,,19,87,8,16,9,
   ,12,17,13,41,19,,,6,6,8,5,11,6,10,8,10,8,9,7,,9,,,
   76,19,39,21,24,81,9,9,11,8,205,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,8,5,,6,,5,,9,7,9,10,13,8,
   38,8,13,39,31,25,9,10,7,7,,5,,7,7,,7,11,,,,8,32,21,
   11,8,12,12,12,32,6,11,21,6,,,7,8,,9,,8,,29,8,,19,79,
   9,26,8,63,,57,,17,19,,6,6,7,9,10,9,10,,,8,7,10,,9,7,
   9,10,49,46,5,46,10,,,,,18,,,,,,44,52,,,,12,70,,,,,,7,5,,6,
   ,5,,17,8,20,9,15,9,21,6,16,16,20,15,13,10,,9,,9,,,50,
   ,8,64,78,,9,16,19,28,34,7,16,,7,,7,,,,,8,,,64,8,24,12,
   33,64,6,24,,8,6,7,,,7,40,19,64,8,34,9,78,,29,28,16,
   19,8,9,,,18,8,205,81,24,9,39,19,,24,9,,76,7,,,10,73,19,
   ,9,49,8,87,,21,25,,19,,19,,11,19,34,44,9,15,11,,64,6,,
   55,,,,,,,,,,,,,,,12,,,,11,41,,,,,13,,41,,,20,,15,,,,,9,14,,
   32,36,56,13,15,23,6,20,24,22,27,,40,36,23,,12,32,25,27,
   ,32,32,36,,22,40,12,23,,20,13,36,19,19,6,15,23,56,40,
   26,56,10,6,18,32,12,6,26,35,40,16,18,22,36,,10,26,28,
   23,27,37,30,12,16,32,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,
   11,,,,4,4,,6,,9,,12,,,8,,,9,,24,8,8,24,16,16,8,16,16,
   16,16,8,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,
   7,,6,,9,,8,10,10,,,,8,8,8,8,16,16,8,24,16,24,16,8,6,
   6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,
   9,9,36,36,9,9,9,36,16,9,16,9,36,4,4,4,4,4,6,,3,4,
   5,5,5,6,6,,7,,4,4,,4,,7,,7,,4,,,,12,,23,7,9,21,5,6,
   21,12,7,9,6,17,4,4,4,4,,,4,4,4,4,4,8,,6,7,,3,4,,5,,
   5,,7,,7,,6,,,12,21,9,21,9,6,6,17,9,5,9,17,8,4,4,4,,
   11,4,5,4,5,5,6,7,7,10,,4,4,,8,,6,,8,,7,11,,,,,22,9,
   22,22,4,13,22,13,9,9,9,9,4,4,,6,4,4,4,7,4,6,6,5,,,
   4,4,,4,,4,,6,,,6,6,,,7,9,21,23,7,6,17,8,9,6,12,23,8,
   4,11,,4,4,4,7,4,,11,6,,,4,5,,4,,5,,7,,9,9,6,,,13,22,
   22,22,9,13,9,9,9,4,13,12,9,11,11,5,4,4,,5,7,6,7,,,
   4,8,,4,,6,,8,,7,6,7,,8,,8,31,8,31,7,22,13,13,6,13,8,
   34,,6,9,6,9,7,6,6,12,,,6,7,,,,8,,10,,,12,,,,,12,,,14,
   10,18,14,19,8,23,53,15,6,6,7,7,8,,,,11,,6,8,,6,,,,,,8,
   12,12,,15,,,14,12,,10,15,63,23,9,19,12,27,4,4,,5,,6,6,,
   ,4,4,,4,,4,,7,,,6,6,,8,11,7,23,8,8,17,23,8,12,6,38,
   7,7,4,9,5,11,,6,,,4,4,,4,,4,,7,,,7,8,,,6,9,20,9,6,9,
   12,9,13,13,16,16,6,7,5,,10,10,7,,5,4,,4,,5,,8,,4,,6,,
   10,8,31,8,13,8,22,8,34,13,7,67,7,12,,,11,,,,,,,4,,6,,
   10,,,6,,,14,16,13,36,11,,,,15,17,,61,8,,7,8,,,,7,6,,6,,
   8,,7,,6,8,,,8,,17,17,7,10,10,10,15,18,11,23,5,23,6,7,,
   ,7,,,6,,6,,9,,9,11,6,,47,16,12,58,12,11,,,15,25,10,25,
   22,12,7,21,,6,6,,,,6,,9,,8,,12,,,15,28,40,,16,13,16,,25,
   ,25,90,11,11,,6,6,,6,,9,,,,6,,6,,15,,,11,16,,10,14,28,
   89,12,25,8,27,,7,,,7,,6,,9,,,9,,,,,11,,,,,,14,20,8,,196,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,8,6,6,,11,8,8,8,8,8,
   23,7,7,38,17,38,5,9,,4,,5,,8,,,8,7,,15,15,6,9,9,9,
   12,16,6,16,9,13,9,9,,,,,,,,,,,,,,,,,,,,,,,,,,5,,8,,9,10,10,,
   ,10,8,13,34,12,8,7,12,62,22,12,33,8,,,,,,,,,,,,,,,,,,,,,,,
   ,7,,6,,11,,11,,10,7,15,21,10,5,23,23,10,21,12,21,,,,,,,,
   ,,,,,,,,,,,,,,8,12,,,11,,12,10,10,,10,8,31,,66,,8,,,,,,,,,,,,
   ,,,,,,,,9,7,,,15,10,96,36,13,,,11,22,11,17,,15,,,,15,63,
   17,,12,8,10,,34,13,19,18,14,,,,14,15,14,,9,10,12,,16,
   23,15,63,,,,,,,,,,,,,,,,,,,11,8,,,,,41,,36,,,11,,13,,,97,,41,
   13,,22,19,25,18,6,22,18,10,24,23,35,25,22,17,9,6,18,
   9,34,35,46,22,9,17,25,24,30,18,9,6,10,18,19,34,16,18,
   6,22,18,30,33,18,13,4,6,9,16,4,33,18,30,23,6,24,17,
   25,13,,23,23,32,26,23,16,23,9,4,4,4,6,4,6,7,,8,4,6,
   7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,24,24,8,16,16,
   24,8,16,8,16,24,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,
   5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,
   4,4,4,5,5,8,,4,4,7,,7,7,8,,8,,4,4,8,6,9,7,,7,,,7,
   7,8,7,,35,8,7,35,7,10,32,7,10,10,7,64,4,4,4,4,7,7,
   4,5,5,,4,8,,,9,,4,4,7,7,8,7,,6,,,,8,,,6,35,7,32,7,
   10,7,64,10,7,7,57,7,5,3,5,,6,4,6,5,,6,6,6,6,7,8,4,
   3,6,5,7,4,,5,,,6,,6,7,7,6,6,5,5,4,6,6,6,6,4,5,5,
   4,5,,8,4,4,4,,4,10,10,6,,8,4,5,6,5,7,4,,5,,,7,8,6,,
   ,7,32,64,7,7,57,7,7,10,10,,6,5,6,,5,3,5,,4,,5,6,6,
   6,4,6,6,5,6,6,,5,,,,5,8,7,8,5,5,6,6,6,5,5,4,4,6,
   6,6,10,9,7,5,6,,7,8,7,8,,10,6,5,8,5,9,5,,5,,,5,,,,,
   8,34,8,71,7,32,10,7,8,8,6,,7,7,,5,,,,9,11,,13,4,5,6,
   ,10,4,,7,,,,,8,,10,8,,42,10,8,24,12,8,,8,26,16,8,5,,,
   10,,10,,14,133,6,9,6,8,27,,,10,,,9,10,,,,31,11,11,,12,
   10,32,10,21,9,9,26,4,5,,7,,6,8,,8,4,4,,4,,4,,6,,,4,6,
   ,7,8,7,64,7,7,57,,6,10,7,,10,8,5,,6,5,,9,7,8,5,3,
   6,5,7,4,,5,,,5,9,7,7,6,6,6,5,5,5,6,6,6,6,4,4,5,,
   7,10,,10,9,,7,5,,6,,7,,8,,,,8,,,,71,8,10,17,32,6,,8,7,
   64,7,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,12,,11,9,7,4,9,5,
   11,4,,7,,,4,,6,4,6,7,7,5,7,7,7,7,7,7,7,4,7,10,8,,
   37,,,,7,13,12,,7,,,9,6,,13,19,30,35,9,13,,28,13,7,10,,
   11,12,6,,,8,5,8,8,16,6,,9,,,,,18,47,12,28,14,22,25,15,
   10,,7,10,11,34,13,,,8,5,11,8,17,9,,11,,,8,,,8,133,,15,
   16,31,20,9,18,9,12,10,10,46,6,,8,13,7,8,6,,9,,,8,18,,,
   ,,,,,,,9,,7,,,,,6,17,10,10,10,,9,,,68,12,,,,,,,,,9,,6,7,,
   231,,4,,5,,7,,7,,,6,,,7,8,7,7,6,7,,10,8,,57,57,7,7,,
   5,8,6,,5,,,9,6,8,7,8,5,5,6,6,6,4,5,4,5,6,6,6,8,,,,
   11,,,,11,,,,30,10,11,22,,7,19,28,68,,9,17,,7,,5,,,10,10,
   7,,10,17,10,,17,6,7,16,64,32,7,64,8,10,,,,,,,,,,,7,,,,,,,,
   ,,,,7,,,,9,9,8,9,7,5,7,7,7,4,7,7,7,7,7,7,,,,,,,,,,,,,,,
   ,,,,,,,,8,,,8,,18,8,17,,7,7,17,34,34,7,7,71,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,7,,,,29,7,,8,,8,42,14,9,8,24,12,25,13,
   235,11,9,11,29,21,12,11,,19,10,10,32,7,6,,,,,,,,,,,7,,7,,
   ,,8,,,,,,6,,7,,,9,,8,,,231,,9,6,,5,20,,23,6,7,6,7,23,
   16,30,26,42,18,7,6,5,5,18,20,54,5,5,18,26,18,18,5,7,
   6,7,23,20,16,14,6,6,7,40,18,21,40,6,4,6,5,4,4,21,
   40,18,7,6,18,18,26,6,40,17,19,14,18,18,4,7,5,6,6,7,
   6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,16,
   9,9,16,36,36,9,9,36,9,36,9,5,5,4,7,7,6,,4,5,6,,6,,
   5,,9,,4,5,6,4,7,5,5,5,4,6,8,8,,,,22,9,8,39,13,13,
   38,8,10,9,10,31,5,5,5,4,8,8,4,7,7,6,4,6,,6,9,,4,5,
   11,6,8,6,4,5,,6,,6,,,9,39,8,38,7,13,10,31,9,13,10,
   62,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,7,,5,11,7,6,
   ,7,,,,,6,11,12,12,12,21,8,11,21,8,32,32,5,7,,6,5,5,
   4,6,4,7,7,6,,,4,7,6,7,8,4,,6,5,,6,11,,,9,7,38,27,8,
   10,62,7,10,13,7,62,10,7,7,,7,6,7,,6,,6,11,,,5,5,7,4,
   6,5,6,6,5,8,8,7,,,,12,12,8,10,21,32,32,8,12,22,10,
   22,10,9,6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,7,4,6,5,
   6,,,,5,46,9,49,10,,7,9,10,7,10,46,8,6,8,5,8,6,9,7,9,
   ,,6,,8,9,18,6,9,,8,,9,,,,18,9,,39,,19,81,9,24,76,8,
   205,24,11,7,6,6,,,9,,,,6,7,10,5,7,7,7,7,6,9,10,9,,,,
   28,16,9,,78,64,34,8,19,40,19,29,5,7,,6,,5,8,,,5,5,6,
   4,7,4,5,5,7,7,6,6,,,11,8,27,7,8,62,62,10,7,10,27,
   10,9,7,8,5,7,,7,9,,7,6,,7,,6,5,6,,7,,7,,,8,10,8,32,
   6,32,10,22,22,21,32,32,8,6,6,9,10,10,12,,6,4,10,4,8,
   6,4,4,9,5,9,5,,,12,49,9,7,5,,10,46,7,10,46,10,7,,,9,,
   ,,7,7,9,5,10,6,7,7,10,9,8,9,,,,25,,8,,87,,49,9,19,
   73,19,21,11,5,,17,,5,5,6,4,8,4,5,5,7,6,6,7,,,,15,13,
   6,16,16,15,21,9,10,20,9,20,7,6,,,6,8,8,5,7,6,9,7,6,
   7,10,6,,,,13,41,9,12,,87,16,8,19,,19,17,7,13,,,5,9,9,
   45,,4,5,,6,,6,,,11,,11,44,6,34,11,,15,19,,55,9,29,,6,
   7,8,5,8,6,8,8,7,6,9,7,,,,,17,8,,63,79,26,9,19,,19,57,
   ,7,12,9,7,12,6,19,,13,,11,50,,,,13,,,,,,41,11,41,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,,7,,6,7,5,,6,11,6,,,7,8,7,10,7,62,
   10,9,31,62,38,13,8,8,7,12,5,,7,6,,7,11,,,,6,32,22,7,
   10,32,8,32,32,8,21,11,9,,,7,8,,10,,10,,,11,11,8,24,9,
   81,19,21,39,205,,76,9,,6,9,7,10,9,10,9,,,7,5,7,46,7,
   10,10,7,46,,7,,9,,,,,11,,,,,,9,14,,,,20,15,,,,,,7,5,,6,,6,
   ,,11,16,6,21,7,15,9,20,20,16,21,15,9,,8,,7,,,,,6,,15,,
   11,34,9,44,55,11,19,64,6,,7,,,,,6,24,24,33,12,,8,64,,8,
   ,64,7,9,7,,,11,14,11,,6,55,11,15,,34,44,34,9,8,6,,,
   56,7,,,25,19,87,8,16,,9,,49,8,,,12,78,11,,9,76,19,39,
   21,70,24,81,9,,,,7,16,16,28,19,78,9,,,8,64,34,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,12,,70,,,,,44,52,,12,26,26,22,12,10,6,16,
   24,25,27,35,28,36,23,6,15,32,22,27,37,12,32,36,56,13,
   40,15,23,6,16,22,26,19,23,6,12,10,,40,36,,23,,18,32,32,
   ,36,,40,20,18,13,36,56,23,56,40,19,27,,30,32,20,32,8,
   8,5,6,6,,,4,5,5,,5,7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,
   58,10,9,47,10,9,53,9,9,6,18,,8,8,8,6,,,5,6,6,,5,8,,
   9,,,4,5,8,5,7,5,8,7,8,,,9,,,,47,9,53,8,9,18,,6,10,7,
   ,18,6,4,6,,8,5,6,4,,6,5,9,9,9,10,5,4,4,7,10,4,6,7,
   ,,,,4,10,10,7,7,7,7,6,7,7,7,7,4,6,6,8,6,,9,8,8,6,,
   5,11,11,6,,8,5,6,6,6,10,5,8,5,9,,,8,8,,10,8,53,,7,
   18,,18,7,9,8,53,9,6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,
   6,,5,6,,,6,10,9,10,7,7,7,7,7,6,6,4,6,7,7,7,,11,5,
   4,4,,5,7,6,7,,7,6,7,4,4,8,4,10,7,6,,,,7,,,10,62,7,,
   6,50,8,7,9,10,8,50,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,
   ,6,,11,,34,,8,,,6,11,,,9,8,,,11,,15,,,16,10,,,25,36,10,
   11,10,23,28,8,6,,5,,8,8,,,8,8,9,6,,5,9,7,,,,8,,,7,7,,
   18,6,,53,9,8,18,47,9,10,6,,6,7,,9,9,10,6,4,7,6,10,
   4,6,5,,,,,9,9,6,7,7,6,4,6,7,7,7,7,7,7,6,,5,,,,9,,5,
   4,,4,,5,6,5,,,,6,,9,,,7,8,10,50,8,50,10,6,,7,6,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,
   7,7,8,6,7,7,8,8,7,8,7,6,7,11,7,223,14,,9,9,6,24,9,
   6,,11,,,6,,17,13,20,65,10,9,,44,13,21,20,,12,12,9,17,,
   7,5,7,7,13,6,6,,,,,6,14,223,24,,12,44,21,13,10,,9,12,
   20,65,20,11,,7,4,7,4,,6,8,7,,,,10,23,7,79,,7,10,35,
   19,12,14,8,8,12,8,25,9,9,10,7,,10,6,18,9,15,,,12,,,,
   10,,,,,,,,10,,,,,4,23,7,7,7,7,8,,,,13,,,,,7,203,,148,10,,,
   7,,,,8,,6,,5,,5,,,,7,,9,10,6,18,9,9,53,9,10,47,,58,10,
   9,9,6,10,6,,7,8,,,6,10,9,10,4,6,7,7,7,7,6,7,6,7,7,
   7,7,79,,10,7,,,,8,,11,,12,8,12,8,14,10,19,35,25,,7,8,,
   5,,7,11,,,10,7,,8,10,8,50,7,8,7,6,,50,10,62,9,7,,,,,,,,
   ,,7,,,,,10,,,,,,,,5,6,,,5,7,7,8,7,6,8,7,8,6,7,7,7,7,
   8,8,,11,,,,13,12,,10,25,,,10,16,11,,36,,14,,9,,,,8,9,,8,
   19,9,50,9,9,9,50,66,8,19,66,,,,,34,11,10,23,25,10,36,
   10,,,28,,16,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,18,,,14,16,,
   11,,10,,,10,25,36,9,7,,,10,,,,148,,160,,7,7,10,,,,,,,,,,10,
   ,10,,,10,,,,,,,7,,,7,26,26,21,6,7,4,7,16,26,25,37,37,
   28,7,6,6,6,26,24,43,7,6,28,66,21,26,6,7,6,7,21,26,
   23,25,4,6,7,66,26,26,66,7,6,5,6,7,6,26,37,26,7,5,
   21,28,66,7,26,37,25,25,43,22,7,7,6,3,4,4,4,,,3,4,4,
   4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,19,19,4,4,,
   4,4,4,19,19,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,
   4,4,4,4,,,4,,,,4,19,19,4,4,,4,4,4,19,19,4,4,,,3,3,3,
   3,3,4,4,,,,2,3,3,3,3,3,3,3,3,,4,4,3,,,13,13,13,13,
   3,14,13,3,3,3,14,13,3,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,
   4,5,4,3,4,4,4,5,5,,19,19,4,,4,19,19,4,4,4,4,,5,,4,
   3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,19,19,4,
   ,4,19,19,4,4,4,4,,,3,4,4,4,4,5,3,,,,3,3,4,4,5,4,4,
   4,4,,,,4,,,23,,25,19,4,7,,5,4,4,25,19,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,
   ,14,14,3,13,13,14,14,3,3,14,3,13,4,4,4,3,,,4,,3,2,
   3,3,4,3,3,3,,3,4,4,4,4,,14,3,4,13,4,3,14,3,3,4,4,
   13,,3,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,19,
   19,5,,5,5,19,4,19,,,5,,,,4,3,5,3,5,4,4,4,4,3,4,4,,4,
   ,,7,4,19,25,,20,4,5,25,4,19,5,5,,5,,4,3,5,3,5,4,4,
   4,4,3,4,4,,4,,,5,4,19,19,5,,5,5,19,4,19,4,,,,3,4,4,
   3,4,4,5,4,3,4,4,4,,5,,20,25,4,23,,25,20,4,4,7,5,,,5,
   ,3,3,4,4,5,4,4,4,,4,,,5,21,,41,4,12,19,5,5,,5,4,5,
   12,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,15,5,
   5,,,,20,,16,,15,,20,4,4,19,17,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,
   3,,4,4,4,,3,4,4,,3,,14,3,3,14,14,3,14,14,14,14,3,14,
   4,3,4,4,,4,3,,4,4,4,4,,13,4,3,14,3,4,13,4,4,3,3,
   14,4,,,3,,,4,,,,5,,20,4,5,,7,4,20,25,25,,4,20,,4,4,4,
   4,4,6,6,3,,,13,3,14,14,3,3,13,14,13,3,14,14,,21,,,4,,,
   ,,,20,4,17,,18,4,20,,,27,19,,,3,4,4,,,5,5,,19,4,5,,5,
   4,19,19,19,5,5,,,4,,,,5,5,,19,5,5,,5,5,19,12,12,4,4,
   20,4,4,,,5,5,,19,4,5,,5,4,19,19,19,5,5,,3,4,4,16,4,,
   24,4,4,14,10,3,14,,6,10,4,14,4,4,4,,,13,10,6,28,4,
   10,13,4,4,3,,16,3,5,,,79,5,,55,4,4,55,,9,5,9,79,5,,,
   79,5,,55,4,4,55,,9,5,9,79,4,,,17,4,20,,19,,27,18,,4,
   20,,,16,,20,4,17,,19,15,4,,20,,,,,,,,,,,,,19,71,14,98,14,,
   14,19,44,44,,12,71,11,4,14,3,4,9,10,27,19,4,10,27,9,
   11,3,4,14,19,44,,44,98,14,14,,8,28,10,14,4,3,14,19,4,
   3,11,14,71,19,14,98,71,14,4,14,11,98,10,8,28,4,19,19,
   4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,
   ,4,19,19,4,4,,4,4,4,19,19,3,4,,,4,4,4,4,3,,,4,,,3,
   4,4,4,4,4,4,3,4,,,4,5,,5,19,19,,4,4,19,19,4,4,4,,4,
   4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,19,
   19,,4,4,19,19,4,4,4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,3,
   3,3,3,4,3,3,4,,4,3,,,14,14,14,13,3,13,14,3,3,3,13,
   14,3,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,
   4,9,79,5,4,5,136,9,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,
   4,,,,5,,,55,,55,,4,9,79,5,4,5,136,9,4,4,,3,,,3,,,3,3,
   3,3,3,3,3,2,4,4,,3,,,3,14,13,13,3,13,13,13,3,3,14,
   13,3,3,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,19,
   4,19,4,,4,4,19,19,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,
   ,4,,,4,,4,19,4,19,4,,4,4,19,19,4,,,,,,,3,3,3,3,4,3,
   3,3,4,4,,4,16,,4,24,6,13,4,10,,16,3,4,10,13,4,3,,,4,
   ,3,2,3,3,4,3,3,3,4,3,,4,4,,4,16,4,13,4,4,4,16,4,
   4,4,13,4,,4,,,3,4,4,4,4,4,4,3,5,3,,4,,,5,20,25,23,4,
   ,25,19,4,4,7,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,
   4,4,4,5,4,,3,5,,21,,5,19,12,5,4,35,4,5,5,19,12,,3,
   4,4,4,4,4,4,3,5,21,,5,,,,20,,,23,23,,20,4,4,18,,17,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,14,3,14,3,14,
   3,13,13,13,14,14,3,4,4,4,4,,3,3,,,3,4,,4,13,4,14,3,
   3,4,13,4,4,3,14,3,,,,4,4,,5,,5,,,5,20,4,,5,7,4,19,
   25,25,,20,4,,3,4,4,5,5,,5,5,,5,19,4,,5,5,4,19,19,19,
   5,,5,,16,,,5,,,,,,20,4,,19,19,4,20,,,15,,18,4,4,5,5,,5,
   5,,5,19,4,,5,5,4,19,19,19,5,,5,,3,,,,4,,,13,4,16,,3,
   4,14,10,10,4,14,6,3,3,,,3,,,14,3,14,14,3,3,14,13,14,
   3,14,14,4,,4,,,4,,5,20,4,25,4,23,,7,25,20,4,,4,5,,5,
   19,12,41,4,4,12,19,5,5,5,,5,,,,,,,,,,,,,,,,,4,,,,5,20,25,
   4,4,20,,7,4,20,25,,4,,19,20,4,,16,,15,18,,20,4,,,,,,,,,,,
   ,,,,17,20,,4,19,,17,19,4,20,,19,,41,44,14,,14,19,98,,
   95,41,9,10,4,14,3,4,10,95,9,19,19,71,14,98,28,14,,14,
   4,9,60,10,9,3,14,4,12,71,11,8,4,14,3,19,4,3,10,27,
   9,19,14,44,,41,4,8,28,9,11,44,12,19,4,19,4,3,,5,4,4,
   3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,19,19,
   4,,4,4,4,4,19,19,4,,,3,3,3,3,3,,4,4,6,6,2,3,3,3,4,
   3,3,3,3,4,4,,4,6,6,4,4,4,4,3,4,4,3,3,3,4,4,,5,4,
   4,3,5,4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,19,
   19,4,,4,4,4,4,19,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,
   4,4,4,,,,7,,3,3,4,4,5,4,4,4,4,5,3,,4,,,30,5,,,4,5,
   30,4,4,4,8,8,4,3,,4,,4,4,,4,3,3,3,3,4,2,3,3,4,4,3,
   ,,4,4,3,14,4,4,13,14,3,3,3,13,4,4,4,,3,4,,,6,6,4,
   3,4,4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,
   4,4,4,4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,4,4,14,3,
   4,4,13,3,14,3,3,13,4,4,,,,,,6,4,3,4,4,6,3,4,4,3,5,
   4,,16,5,5,5,7,5,5,10,,4,4,5,10,5,5,4,,,6,6,4,3,4,
   4,6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,
   4,18,6,3,3,3,3,4,3,3,3,4,4,4,,,6,6,4,10,4,4,,10,4,
   3,3,6,6,6,3,6,,4,3,4,4,6,4,4,4,,4,,,6,22,22,,5,13,
   13,6,5,,5,5,6,13,13,6,,4,3,4,4,6,4,4,4,,4,,,6,22,22,
   ,5,13,13,6,5,,5,5,6,13,13,6,4,6,4,5,6,4,7,5,6,,5,,,
   ,,5,,,,16,,5,5,5,20,,,4,4,6,5,6,6,5,5,6,5,,,,,,,5,,,
   20,5,,5,5,17,,,3,,4,,3,4,4,,3,3,,,4,4,3,3,4,4,13,3,
   3,14,14,13,4,4,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,
   3,4,4,3,4,4,4,18,,4,4,,3,,,,6,6,4,3,6,6,6,3,4,10,
   10,,4,4,,4,,3,5,5,5,,4,,,4,4,19,19,4,4,4,,,4,19,19,6,
   ,,,7,7,,,,,5,5,,,20,5,5,,,16,,,4,4,3,3,,,4,6,6,4,3,6,
   6,4,3,4,4,4,4,6,6,,5,,5,,4,,,4,5,,,4,5,4,30,30,4,8,
   8,5,5,5,,4,,,4,4,19,19,4,4,4,,,4,19,19,4,4,,16,5,5,
   5,5,5,5,10,4,4,,7,10,5,5,4,,4,,,4,30,8,8,4,30,4,5,
   5,4,,,,4,,,30,4,,,4,4,30,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,
   18,18,4,4,,16,18,14,18,,4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,
   ,4,20,20,9,4,6,4,4,9,20,20,20,20,10,6,4,4,4,9,20,
   20,3,4,20,20,43,20,3,4,4,4,20,20,43,20,3,4,4,8,10,
   10,8,3,3,3,4,4,4,10,20,20,4,4,9,20,20,6,8,20,20,10,
   20,20,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,
   ,4,5,,5,19,19,,4,4,19,19,4,4,4,,4,,5,4,4,3,5,4,4,
   4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,19,19,4,,4,4,4,
   4,19,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,,,,3,
   4,4,4,4,4,4,3,4,,6,5,5,,,25,19,23,,4,20,25,4,4,5,,
   7,3,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,19,4,
   19,,4,4,4,19,19,4,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,
   ,,4,4,,19,4,19,,4,4,4,19,19,4,4,3,6,6,4,,,3,3,4,3,
   3,3,3,2,4,,4,3,,,3,13,14,14,3,13,14,14,3,3,13,14,3,,,
   ,,,5,4,4,4,4,5,3,4,3,6,,4,5,21,,5,4,35,19,5,12,,5,
   5,4,12,19,5,4,4,,,4,3,3,3,3,4,2,3,3,4,,3,4,4,,4,4,
   16,13,4,4,16,4,4,4,4,13,4,3,4,,,4,4,4,4,5,4,4,3,,,,
   4,,,5,9,79,55,4,,55,,4,5,9,79,5,4,,,4,4,4,4,5,4,4,3,
   ,,,4,,,5,9,79,55,4,,55,,4,5,9,79,5,,,3,3,3,3,4,3,3,
   3,4,,4,4,4,,15,,16,13,10,4,24,6,4,3,4,14,10,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,21,5,,,,,20,,23,23,20,
   ,4,4,17,,21,4,,4,,3,4,3,,,3,3,,,3,3,14,14,3,13,13,3,
   14,13,14,13,3,4,3,,4,,4,5,,5,5,5,,5,4,19,,4,4,19,4,
   19,19,4,,4,4,16,,4,3,,,,3,,,4,4,14,24,4,6,13,4,10,10,
   ,16,3,,4,,4,5,,5,5,5,,5,4,19,,4,4,19,4,19,19,4,,4,4,
   ,,,,5,,,,,4,20,,17,21,20,4,,,27,,23,4,3,3,,,3,4,,4,4,
   13,16,4,4,13,4,4,4,4,16,4,,5,,5,,5,,,4,19,20,,4,20,
   4,25,25,5,,7,3,,3,,3,,,3,14,14,13,3,14,3,13,13,3,14,
   14,,4,4,,,4,5,,20,4,25,23,4,,7,25,19,4,,,,,,,,,,,,,,,,,,
   4,5,,5,12,19,,5,5,19,12,5,5,4,35,4,4,,,5,,20,25,4,
   20,4,,7,4,19,25,,4,17,,20,4,,,23,27,21,,20,4,,,,,,,,,,,,,
   ,23,,20,,4,,21,17,23,4,20,,19,71,12,9,14,4,3,4,9,44,
   10,14,71,60,,14,14,19,44,,41,19,19,,41,44,60,14,,14,4,
   44,10,9,9,3,14,4,41,9,10,12,4,14,3,19,19,14,71,14,
   60,4,3,9,60,12,4,14,71,9,10,41,9,19,4,19,5,,4,3,4,
   5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,19,19,4,,4,
   19,19,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,4,3,4,
   ,,,5,,7,,,30,5,4,8,8,4,4,4,30,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,
   19,19,4,4,,19,19,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,3,4,
   3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,4,,5,
   5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,19,19,4,4,,19,19,
   4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,8,8,
   4,5,30,,,4,4,30,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,3,3,
   3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,,5,8,8,30,4,5,,,4,
   4,5,30,4,,,3,4,4,3,4,4,5,4,3,4,4,4,7,5,,,,4,30,5,
   8,8,4,4,5,4,30,3,4,4,5,4,4,4,5,4,6,22,22,6,,,,,,,,,,
   ,4,4,,,,4,4,5,4,4,4,5,4,6,22,22,6,,,,,,,,,,,4,4,,,,4,,
   3,,4,4,3,,4,4,3,,4,4,4,4,3,3,14,4,4,13,13,14,3,3,,
   4,4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,16,
   ,6,4,,,,4,,6,6,5,5,5,5,7,5,5,10,10,,4,4,,4,4,3,4,
   6,6,4,4,,4,4,4,14,3,3,4,4,13,13,3,14,3,4,16,,,6,6,,,
   ,,4,4,18,18,18,4,4,,,14,16,18,,4,4,,,4,6,6,6,4,4,5,
   5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,,4,5,5,10,10,5,
   5,7,3,4,4,,4,4,,4,4,3,14,3,4,4,13,13,3,3,14,4,4,3,
   18,6,4,6,6,4,3,10,4,4,,6,10,4,3,3,4,6,,6,13,13,,5,
   5,13,13,6,6,5,,5,4,6,,6,13,13,,5,5,13,13,6,6,5,,5,
   4,6,18,6,6,4,10,3,4,4,,6,3,4,10,6,6,,,5,5,,,,16,20,,
   5,5,6,,,,5,5,,,20,16,5,,5,,,5,,5,,,17,20,5,5,,3,20,20,
   20,4,4,3,4,43,20,20,20,20,20,4,4,3,4,43,20,20,4,4,
   20,20,9,10,4,6,4,4,20,20,9,9,4,4,6,20,20,10,8,6,4,
   4,3,4,3,20,20,20,4,3,20,20,20,3,8,10,9,10,8,10,4,4,
   4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,6,,5,,,
   6,,51,25,5,,6,6,6,5,51,25,5,4,6,6,5,,6,,,,4,5,6,4,
   5,6,6,5,4,5,6,5,7,7,,51,25,6,,6,25,51,5,5,6,6,,4,4,
   ,3,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,19,19,,
   5,5,5,19,4,19,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,,4,3,
   4,4,4,,3,14,4,13,4,14,3,3,3,4,4,13,6,4,6,4,6,,,3,
   3,4,2,3,3,4,3,3,3,3,3,,3,,14,14,3,14,14,14,14,3,3,
   13,3,14,,,6,,,7,6,5,6,4,7,4,6,5,6,5,4,5,,5,,6,,5,
   25,51,,6,6,6,51,5,25,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,
   4,,4,,5,,4,19,19,,5,5,5,19,4,19,4,3,,,4,4,4,3,5,4,
   5,4,4,4,4,4,,5,,,55,4,55,,79,9,5,4,9,5,79,4,,,3,3,
   3,3,4,3,4,3,,4,,4,4,16,,6,28,10,13,4,16,,3,4,4,10,
   14,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,55,4,55,,79,9,5,
   4,9,5,79,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,5,
   16,5,,,,,20,17,,19,20,,4,4,17,19,,4,,3,,3,6,4,,4,3,4,,
   3,,3,14,3,14,13,14,3,14,14,14,3,13,4,4,,4,,3,4,,4,,
   5,5,,4,19,4,,4,19,4,19,19,4,4,,3,16,,6,4,,4,,4,,4,,
   4,14,4,24,6,14,4,10,10,,3,16,,3,6,4,4,6,4,6,3,,,3,
   13,13,14,3,13,3,14,14,3,14,13,4,,,,,4,,,,,4,20,19,,18,
   20,4,,,15,16,,6,4,3,4,,4,4,4,,4,13,4,16,4,13,4,4,4,
   4,4,16,,6,,6,,7,7,,5,25,6,,6,25,5,51,51,6,6,,4,,4,,
   5,5,,4,19,4,,4,19,4,19,19,4,4,,4,3,4,16,4,,4,24,4,
   14,10,14,3,,6,10,4,13,4,3,5,,,5,79,9,79,5,55,4,,9,4,
   ,55,4,4,,,10,13,,14,3,13,10,4,4,4,6,24,5,,,5,79,9,
   79,5,55,4,,9,4,,55,4,,19,,4,20,,,18,15,19,,4,20,,23,,,
   20,4,,17,18,27,4,,20,,,,,,,,,,,,,19,9,41,9,14,4,3,4,10,
   9,60,41,,28,,14,14,19,98,71,14,19,4,95,9,10,10,3,4,
   14,19,,95,98,44,14,14,,44,12,11,8,4,3,14,19,19,14,28,
   27,,4,3,9,9,41,4,8,10,44,11,14,71,4,19,19,4,4,4,4,4,
   ,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,4,9,79,5,4,5,
   136,9,,4,,5,,3,5,,5,4,4,4,4,5,3,4,3,,,4,,,21,5,5,,
   12,5,19,41,4,4,5,19,12,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,
   ,,4,,22,22,6,5,,13,6,13,,5,5,5,13,13,6,4,4,6,6,6,,,
   3,3,4,3,4,3,3,3,4,,4,,,16,4,16,,10,4,13,6,28,4,3,
   13,10,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,22,22,6,5,,13,6,
   13,,5,5,5,13,13,6,5,6,,,6,4,3,4,4,6,3,4,4,,,4,,5,
   16,5,5,,10,5,5,9,6,6,5,5,10,5,,5,,,4,4,4,4,5,4,4,3,
   ,,,,,117,7,,,39,5,,26,8,4,5,9,71,7,,,,4,4,4,4,5,4,4,
   4,,,,,,,,42,,28,19,19,42,,5,5,21,28,19,,,4,3,4,4,6,4,
   4,4,,,,,6,44,22,,,36,14,6,9,,6,4,6,29,14,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,4,4,6,5,6,6,5,5,6,,71,,,,,,,,31,20,10,,6,5,22,
   ,,4,,4,,3,4,4,,,3,,,15,4,3,,10,4,13,6,4,28,16,14,10,
   4,4,,,4,,5,5,,5,,5,,7,4,,30,5,4,8,4,8,,4,30,5,4,32,,
   4,4,,,,,,18,6,4,,18,6,6,6,6,18,10,,10,4,,4,3,,5,,5,,5,
   ,,4,,55,,4,9,5,79,55,5,79,9,6,,,,,7,,,,,5,,,43,23,10,6,
   ,,30,,,4,4,3,,,,4,20,6,4,,12,6,4,6,6,6,4,4,12,6,,5,,
   5,,5,,,4,,55,,4,9,5,79,55,5,79,9,5,,5,,4,,,4,,25,19,
   4,7,5,,23,4,25,20,,4,,44,22,6,5,,14,6,30,9,5,,7,30,
   14,6,,,,,,,,,,,,,,,,,,,5,,,42,,,,5,9,50,7,5,4,17,8,,,,,,,,,,,
   ,,,,,22,5,18,,13,5,,29,18,28,21,,13,5,,,,,15,16,,,,,21,,,
   25,,,,5,,,,27,5,,,,24,12,11,8,,4,4,10,26,14,,,,,,,,,,,,13,
   58,24,21,27,9,31,10,5,115,,39,15,4,10,5,22,11,10,9,4,
   9,4,8,8,8,16,115,,6,4,12,27,73,,15,43,81,11,28,13,13,
   5,,4,,,5,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,,25,20,4,,
   23,20,25,4,4,,5,7,4,4,4,,,,6,18,3,3,3,3,4,3,3,3,,4,
   4,4,6,6,,10,4,4,,4,4,10,3,3,6,6,6,3,,,5,,,,4,4,5,3,
   5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,55,4,5,136,5,9,,,5,,,
   ,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,55,4,5,
   136,5,9,,5,,7,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,49,7,4,,
   ,7,49,5,5,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,
   5,4,4,4,,,,,7,71,,26,8,39,,5,,,5,4,7,50,9,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,5,6,4,5,6,6,5,6,22,9,7,,,,,,31,,43,,,5,
   5,,,,16,16,23,15,22,22,22,21,28,44,,117,,,,,,,,,15,,16,21,
   ,,,4,,3,,4,4,4,,4,4,4,,4,,10,4,3,,14,4,10,14,14,28,
   4,6,,4,5,,,5,4,,3,5,6,6,,10,5,4,,4,5,10,5,5,5,5,7,
   4,44,,,,,,,,,6,,14,6,5,,7,6,14,30,36,,5,9,,4,4,4,4,6,
   6,6,4,,,10,4,14,,3,4,10,14,13,4,28,6,22,22,,,6,9,,,,,
   13,5,18,,18,5,13,,,28,16,29,3,,4,,,,6,6,,13,6,5,,5,6,
   13,13,13,6,6,12,,4,,,,6,6,,13,6,5,,5,6,13,13,13,6,6,
   12,4,5,6,,5,5,,12,5,5,,5,5,12,19,19,4,4,41,4,4,4,
   32,6,,18,6,4,,10,4,10,,6,18,6,6,,5,6,,,30,14,9,,5,14,
   30,6,6,5,,7,,6,,,31,6,,,4,6,31,6,6,5,9,9,5,,,50,7,,,
   5,5,42,,9,4,8,26,6,,,43,5,,,,,30,20,,6,10,,,,,,5,35,,
   19,30,6,,10,,,,,,,,,,,,,,24,,39,16,31,9,13,21,50,54,12,,
   17,5,16,4,5,39,49,67,,4,15,25,10,11,4,7,8,,,,,,,,,21,
   47,12,10,7,4,8,,5,4,49,49,189,13,9,45,43,48,4,15,10,
   15,11,15,14,6,8,8,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,
   ,,4,4,,19,4,19,,4,4,4,19,19,4,,4,,5,5,,,4,4,5,3,4,
   4,4,3,4,4,4,3,,5,5,19,19,4,4,,19,19,4,4,,4,4,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,
   4,,5,,4,19,19,,5,5,5,19,4,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,,4,4,4,4,5,3,4,3,,,,4,,,4,7,,25,4,19,23,,4,5,20,
   25,4,,,4,4,4,3,5,3,5,4,4,4,3,4,,4,,,20,4,25,19,,7,
   5,4,20,4,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,5,3,4,4,4,3,5,
   5,16,4,,,,,20,16,15,,20,,4,4,,19,18,3,,4,,4,,4,,,4,4,,
   5,5,4,19,4,4,,19,4,19,19,,4,4,,4,,4,,4,,,4,4,,5,5,4,
   19,4,4,,19,4,19,19,,4,4,4,21,,3,4,,,,4,,5,5,5,19,4,
   4,35,19,5,12,12,,5,5,,3,4,3,6,6,4,4,,,3,3,13,13,3,
   14,14,3,13,14,13,14,3,4,,,,,4,,,,,4,20,19,17,,20,4,,,,
   17,19,4,3,4,4,,3,,4,4,4,13,4,4,16,13,4,4,4,16,4,4,,,
   ,4,,,5,,4,20,4,,20,20,4,25,25,,5,7,4,4,3,,,3,,3,14,
   3,13,14,14,3,14,14,14,3,14,3,4,4,,,5,5,136,9,5,79,
   55,4,,9,55,,4,4,4,,,5,5,136,9,5,79,55,4,,9,55,,4,3,,,
   4,10,13,,3,14,13,10,4,4,24,6,4,,4,16,4,14,4,10,14,
   16,3,,6,13,4,10,,,,,,,,,,,,,,,4,18,,,4,20,,23,23,17,20,,
   4,15,,4,,20,,19,19,18,20,4,,19,10,8,44,14,4,3,4,98,
   10,11,27,28,,,14,14,19,,95,44,4,19,71,12,9,9,14,4,3,
   19,98,11,10,9,14,3,4,14,71,60,41,,14,14,19,19,14,,41,
   28,4,3,44,10,8,4,41,9,9,95,9,12,19,19,4,4,4,5,,5,5,
   ,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,19,4,19,4,,4,4,19,19,
   4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,22,22,6,5,,13,6,13,,5,
   5,5,13,13,6,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,4,4,5,
   5,4,4,4,5,5,5,5,4,4,4,,4,,7,4,4,4,4,5,3,4,3,,6,5,
   4,,,4,5,30,,4,,30,5,4,4,8,8,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   6,,4,3,4,4,6,3,4,4,,4,5,6,5,5,16,,4,5,10,5,5,7,5,
   4,5,5,10,6,5,6,5,5,6,4,6,4,,,5,6,,,,5,,,20,,,5,5,5,,
   ,16,5,4,7,5,6,6,4,4,,5,,6,,,,,5,,16,,5,,5,5,,,20,4,,
   3,,4,4,4,,5,5,5,,,4,4,4,19,4,19,4,4,,,19,19,4,4,4,
   6,3,,3,,,3,3,6,6,4,3,4,4,3,4,4,3,4,4,4,4,3,,,,4,4,
   ,5,,5,,,4,5,4,8,4,8,4,5,30,30,,,4,,4,4,4,,5,5,5,,,
   4,4,4,19,4,19,4,4,,,19,19,4,6,18,,,7,7,,,,,5,5,,17,,
   5,5,,,,,20,3,3,,3,,3,6,6,4,4,3,6,4,6,3,4,4,4,6,6,4,
   ,,,3,,6,6,,3,4,4,,4,4,3,10,10,6,6,6,,3,3,,4,4,,3,3,
   4,13,4,3,3,14,14,4,4,13,,,,,,,,,,,,,,,,,,,4,4,,,4,4,30,
   8,4,8,30,4,5,5,,,4,4,,,4,30,4,,4,,4,30,5,5,8,8,4,5,
   5,16,5,5,5,10,5,4,4,,7,5,5,10,3,4,,,,4,,,,,,,,4,4,,,,
   4,,,,,,,,4,14,16,4,,4,18,18,18,18,4,4,,4,20,8,20,4,6,
   4,4,43,43,10,20,10,20,6,4,4,4,20,20,8,4,3,20,20,20,
   20,4,4,3,4,9,10,9,9,3,3,3,20,20,20,20,4,4,3,4,4,4,
   20,20,10,4,4,20,20,8,6,20,20,9,20,20,10,3,4,4,,,5,,,,
   4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,55,4,5,136,
   5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,19,
   19,5,,5,5,19,4,19,6,6,,,5,6,6,4,5,5,6,4,5,6,5,4,,
   7,7,25,51,6,6,,51,25,5,5,,6,6,6,7,,5,4,6,6,7,5,4,4,
   ,6,,6,,,5,,6,51,5,25,6,,6,6,25,51,5,7,,5,4,6,4,7,5,
   6,6,5,4,5,6,,5,,,6,5,51,25,6,,6,6,25,5,51,,4,4,5,3,
   4,4,4,3,5,16,5,4,,,,20,,17,19,,,20,4,4,,16,15,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,19,4,5,5,,4,19,
   19,19,,5,5,6,3,4,4,,3,4,,4,3,,4,4,13,4,3,3,14,4,13,
   4,4,14,3,3,6,,,6,6,,6,,6,,7,7,25,5,6,6,,5,25,51,51,,
   6,6,,4,3,3,6,4,6,4,,,3,13,3,14,3,14,3,14,14,14,14,
   14,3,,16,,,4,,,,,,20,4,19,27,,4,20,,,,19,21,4,4,,4,,4,,
   5,5,19,4,5,5,,4,19,19,19,,5,5,,4,,4,,,4,,14,4,3,,16,
   4,14,10,10,14,4,6,4,3,4,,,3,,14,3,3,14,14,3,14,14,
   14,14,3,14,4,3,4,,,5,136,5,,4,55,4,55,,9,79,9,5,4,3,,
   ,4,13,10,6,4,28,10,13,4,4,16,,3,4,,,5,136,5,,4,55,4,
   55,,9,79,9,5,,4,16,14,4,4,10,14,3,16,,6,14,4,10,,,,,,,,
   ,,,,,,,4,,16,,4,20,17,,19,15,20,,4,,19,4,,20,19,,27,21,
   20,4,,19,95,44,,14,,14,19,,39,29,9,12,95,4,14,3,4,39,
   10,8,4,19,9,41,9,12,14,4,3,19,9,28,8,10,14,3,4,41,,
   28,44,,14,14,19,4,3,95,9,12,19,14,,95,44,4,44,12,10,
   29,8,10,19,19,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,4,4,4,4,6,3,4,4,,,,,23,44,6,9,,36,6,14,,,
   4,6,14,30,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,4,7,4,6,6,5,5,6,5,28,6,,,,,10,22,,,,,5,6,,21,39,,,
   4,,4,3,,,,4,,,5,,5,9,4,,55,,4,55,79,79,5,9,,4,,4,,5,3,
   ,4,5,,5,7,4,8,4,5,30,,4,,8,30,4,5,4,71,,,,,,,,,5,,7,
   9,4,8,26,,5,39,71,,5,,,3,4,4,6,6,4,6,15,,4,4,6,13,
   4,10,,3,16,24,10,14,4,6,,,,,6,,,,,6,10,19,,,,5,,,,21,35,
   4,4,4,4,,4,20,4,6,6,6,4,6,12,,4,4,6,12,4,6,,,,4,,,5,
   ,5,9,4,,55,,4,55,79,79,5,9,6,5,4,,,4,,5,7,4,19,25,,
   4,20,,25,4,20,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,4,5,
   71,,7,4,17,9,7,50,,5,,8,42,,5,4,28,,6,12,6,,4,10,,10,
   4,6,12,6,6,44,6,23,6,9,6,14,30,,4,,,50,6,14,22,,,,16,
   15,,,,,,,21,,5,20,23,,5,13,,17,18,24,13,,5,,,5,,,,31,28,,
   ,5,,8,10,48,21,,,4,6,45,10,132,19,71,58,,8,8,8,202,
   14,67,5,13,,9,11,11,9,4,4,,,15,15,39,10,4,5,,27,24,
   24,31,9,10,,,,,,,4,4,30,10,11,,25,10,12,52,13,49,13,,5,
   4,,,7,4,4,4,3,5,3,5,4,4,4,3,4,,4,,7,49,4,,,49,7,5,
   5,8,4,8,,6,,4,3,4,4,6,3,4,4,,4,,,5,16,5,9,6,10,5,
   5,5,,5,6,5,10,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,4,6,
   4,7,5,6,20,4,6,,,,6,,20,,,,6,6,6,,20,,5,4,7,4,6,6,5,
   5,6,4,20,6,,,,,6,20,,,6,,6,6,,18,,4,,4,,4,,3,,4,4,,,4,
   ,5,5,4,19,19,5,5,,,19,4,19,4,3,6,3,,4,4,,3,4,6,4,
   6,4,6,3,4,4,6,4,6,6,4,3,4,4,,,6,,,4,,,,4,,7,5,4,8,
   8,5,7,49,49,,4,,,3,4,4,6,4,4,6,4,,4,4,4,13,4,4,4,
   4,16,16,4,13,4,6,,,,6,6,,,,,6,6,18,,,6,6,,,,20,,4,4,4,
   3,,4,6,4,6,6,4,4,6,6,4,6,6,6,6,4,6,,,,4,,,4,,5,7,4,
   ,,7,5,49,49,8,4,8,,4,4,,,4,,5,5,4,19,19,5,5,,,19,4,
   19,4,4,3,22,6,22,6,6,6,13,13,5,5,,12,13,6,13,3,4,6,
   ,6,4,12,6,6,6,12,4,6,6,4,,4,4,6,,6,12,4,,4,4,4,12,
   6,6,6,6,6,22,6,22,6,6,6,13,13,5,5,,12,13,6,13,4,3,,
   ,4,,,,,,,,4,,4,18,16,,4,4,16,16,18,16,4,,4,,,4,,,,,,,,4,
   ,6,11,28,28,4,9,4,6,28,10,28,9,19,19,9,4,4,6,28,11,
   28,4,4,11,9,10,11,3,3,3,3,28,19,28,28,4,3,4,28,19,
   28,28,4,3,4,6,6,4,19,9,19,6,4,28,11,28,9,28,11,28,
   19,9,19,4,3,4,4,,,4,4,4,4,5,4,4,3,,,,4,,,5,9,79,55,
   4,,55,,4,5,9,79,5,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,
   55,4,55,,79,9,5,4,9,5,79,,21,22,22,16,22,16,23,16,71,
   ,44,18,,,,15,,,,,,,21,16,,,,5,6,6,4,5,5,6,4,7,,23,6,,,,,
   ,31,43,,,,5,5,,,,,,4,,5,,4,,3,5,4,,5,5,5,12,5,5,,12,
   5,19,19,41,4,4,3,4,22,,,4,,,,4,,6,6,6,13,5,5,,13,6,
   13,13,,5,5,4,22,,,4,,,,4,,6,6,6,13,5,5,,13,6,13,13,,
   5,5,,4,4,3,6,6,6,4,,,4,4,10,16,3,,10,4,13,14,6,28,
   4,5,44,,,,6,,,,,5,13,19,21,,13,5,,,41,20,19,,4,5,6,,4,,
   6,6,5,10,5,5,,10,5,5,5,9,6,6,,,,,,,6,,6,14,4,,,14,6,
   36,30,,6,9,4,4,4,,,4,,4,10,3,16,,10,4,14,14,6,4,28,,
   5,4,,,5,7,50,,5,,39,5,,9,26,8,4,,4,,,5,21,28,42,5,,
   28,19,19,19,42,,5,4,,,6,14,30,,4,,36,14,6,6,9,,6,,6,
   32,6,18,4,10,,10,4,,6,6,6,18,,,,,,,,,,,,,,,6,,,,5,,,31,
   20,30,10,,6,55,,5,,,,,22,20,10,6,,,15,21,,16,5,4,5,57,
   80,,25,47,,31,16,9,13,203,52,20,4,,24,12,11,10,8,,4,,
   39,17,10,14,8,4,,,,,,,,,,13,9,58,24,77,5,4,115,,73,4,
   22,11,12,14,15,11,8,8,6,6,,4,3,4,4,6,4,4,4,,4,,,6,
   22,22,,5,13,13,6,5,,5,5,6,13,13,,5,6,5,5,6,4,6,4,,
   117,,6,,,,10,,,20,31,,,5,6,,,30,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,
   ,5,4,4,,5,,5,,,4,7,5,25,4,20,4,,23,,20,25,4,4,4,6,4,
   ,3,,,,3,6,18,4,6,6,10,3,4,4,,4,6,4,10,3,3,,,4,4,,5,
   ,5,,,5,9,5,79,5,9,4,,55,79,,55,4,,,4,4,,5,,5,,,5,9,
   5,79,5,9,4,,55,79,,55,4,,32,,,7,,,,,,10,6,,22,,5,,,,55,,
   20,4,4,,5,,5,7,,5,8,4,49,5,7,4,,,8,7,49,5,,,,,,6,18,,
   6,6,10,,4,4,,10,18,6,18,6,,3,,,4,16,,6,4,10,14,4,3,,
   16,28,4,10,14,,,,,,,,,,,,,,,,,,,,4,,,5,9,71,26,4,8,39,,5,
   7,,,5,,,,,,,,,,,,,,,,,6,23,44,,6,14,36,6,4,,,9,6,14,30,,5,
   ,,,5,,31,,43,,,,5,22,,,,21,,,,,,15,,16,41,20,13,,5,19,,
   21,19,5,13,,8,58,22,115,8,,8,8,57,203,14,24,11,106,,,
   4,6,80,52,15,13,,24,,39,77,16,31,9,5,11,,10,12,4,9,4,
   12,,17,73,5,16,4,,4,4,15,25,10,,,,,,,21,47,14,106,20,11,
   ,5,13,,5,6,5,4,6,4,7,5,6,18,5,5,,,,,,22,,,,10,6,5,
   35,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,,,4,5,3,,4,,,4,4,
   25,20,5,7,,20,20,4,25,4,3,6,4,,4,4,,4,4,6,4,18,,4,
   3,10,4,6,6,6,4,4,3,10,4,,,,3,,4,,,,5,,,4,5,79,9,5,9,
   79,55,,4,55,,4,4,4,6,4,6,6,4,,16,,3,14,10,4,4,6,24,
   16,4,14,10,,71,,,6,,,,,,,5,23,,34,6,10,,,,22,,,,5,4,,6,
   7,5,,,4,5,49,7,4,8,8,,7,5,49,,,,,,,5,,,5,5,,,7,9,71,
   39,8,4,26,,4,,,,5,,,4,5,79,9,5,9,79,55,,4,55,4,5,,23,
   6,44,,5,6,30,14,5,7,,9,14,6,36,4,4,6,,32,,10,6,18,6,
   18,6,6,4,4,,10,,7,,71,,5,,39,5,4,26,8,,7,9,71,,,,,5,
   21,28,21,5,36,,21,21,21,28,5,,,25,5,,,,,,27,,5,,22,,21,,
   13,5,17,35,20,29,5,,13,,,21,,,,,,,15,16,,,,,,,,,,,,,9,27,
   15,,8,4,4,14,11,28,13,5,10,19,10,12,4,4,9,,21,58,50,
   65,16,9,31,48,71,131,14,5,4,16,8,6,4,49,13,43,8,8,
   57,16,115,,49,10,26,17,15,59,5,,13,4,4,5,4,4,4,5,4,
   6,22,22,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,,,4,,17,19,,,
   4,20,20,,16,15,22,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,5,22,,,5,,
   44,,5,,,,5,,17,20,35,,5,13,13,,21,29,,4,,5,7,,5,7,,,,4,,
   ,18,17,,4,20,20,23,,23,4,,,,,5,,,,,4,,,,,,4,,,,,,6,4,4,
   16,,4,,,,4,,16,18,16,,4,4,4,18,16,16,,,,6,,,,,5,,28,,25,
   ,5,,,,,,5,,4,,,,,4,,16,,15,,4,20,20,19,17,,,5,6,,,,6,,
   35,19,,,5,,10,,,26,22,,,,,21,,,,,,16,15,,,,,5,,,,13,,,18,15,
   ,13,5,5,20,23,24,,,,6,,31,,19,,5,,10,20,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,36,37,74,,5,3,4,47,94,,,,,,,,,,,,,,,88,
   94,45,,,,,,76,47,51,,,,,,118,44,,,,,,,,,,4,3,51,45,44,5,
   37,36,74,76,88,118,,,,4,,5,,,5,5,,4,,5,,,,,4,19,27,,4,,
   20,20,,17,18,6,4,4,4,,4,4,,16,4,,,,,4,16,14,18,4,,4,
   4,18,18,18,,,,,,,6,,,,,,,5,,,,5,,,,,25,27,,,5,5,7,5,,7,,,,
   ,4,,15,18,4,,20,20,19,,19,3,22,,,5,,,,,,,4,,,,4,,,,,,,22,,
   ,5,,,,,,,4,,,,4,,,,,,,,5,,44,,,,,,5,25,,21,5,,13,13,18,24,
   26,5,4,,,,,,,4,19,,21,4,,20,20,27,19,,5,,6,,,,,6,,26,,5,,
   ,10,,43,20,22,5,,,,,13,29,28,18,13,,5,5,18,,21,,,,,,21,,,
   ,16,,15,,,,,,,,,6,,,20,5,,,10,23,33,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,88,118,76,5,,3,4,67,41,37,,,36,,46,
   107,,,,,74,,74,67,,,,37,,39,140,,,,,4,3,58,53,154,,,,,,5,
   53,58,47,50,55,39,,,,,4,,4,,4,,,4,4,,5,5,4,19,4,4,,19,
   4,19,19,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,4,4,
   4,19,4,19,4,4,,,19,19,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,4,,
   5,5,19,4,5,5,,4,19,19,19,,5,5,,,,4,,,5,,5,9,4,,55,,4,
   55,79,79,5,9,,4,4,,,4,,5,5,4,19,19,5,5,,,19,4,19,,,,,,,
   ,,,,,,,,,,,,4,4,,,5,4,25,7,5,,25,4,19,19,20,,4,4,,,5,
   25,4,,4,20,4,25,19,19,,7,5,,5,21,4,4,5,12,19,5,5,,
   20,19,5,12,,,,,,,,,,,,,,,4,19,17,,4,20,16,15,,,20,,4,27,
   19,4,,20,17,18,,,20,4,,4,11,14,98,3,4,14,19,44,9,10,
   14,11,71,4,3,14,19,44,10,8,4,19,10,8,44,71,14,4,3,
   19,9,10,44,98,14,3,4,27,28,,14,,14,14,4,19,14,71,12,
   11,19,14,98,11,14,,14,71,98,,41,28,19,19,4,4,22,,,4,,,,
   4,,6,6,6,13,5,5,,13,6,13,13,,5,5,,4,,4,5,,5,5,5,,5,
   4,19,,4,4,19,4,19,19,4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,4,4,
   ,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,,,,
   4,,4,,5,5,,4,19,4,,4,19,4,19,19,4,4,,,4,4,,7,5,4,8,
   5,4,30,,4,,8,30,5,4,,,,,,,,,,,,,,,,,,4,6,,6,10,5,,4,4,5,
   10,5,5,5,7,5,5,7,,4,8,5,30,4,,4,,8,4,5,30,6,6,17,,
   5,5,,,20,,,,5,5,6,20,,,5,5,,16,,,5,,5,16,,5,,5,,20,,,5,
   5,,4,10,8,9,3,3,3,4,9,9,10,20,20,20,4,3,4,3,20,20,
   20,4,4,20,8,20,20,4,6,4,4,43,10,43,20,4,4,6,20,10,
   20,20,6,4,4,4,3,4,20,20,20,4,3,9,10,8,4,20,20,20,
   20,20,20,4,4,4,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,55,79,,
   55,4,,,,,22,,,,,,15,16,,,,21,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,
   21,21,5,,36,21,21,28,28,,5,21,,4,,,,5,,,4,5,79,9,5,9,
   79,55,,4,55,,,,,,,,,,,,,,,,,,,,4,,,6,6,29,9,6,,36,6,14,14,,
   ,4,,,,,,,,,,,,,,,,,,7,71,8,4,7,71,9,5,,,26,,5,39,,,,,,,,,,,,
   ,,,6,35,19,,6,10,22,,,,,,5,,22,6,,10,23,34,,,,5,,5,49,
   49,57,4,5,16,,,14,17,13,10,16,4,4,9,13,,11,15,6,8,10,
   48,21,43,,,4,8,10,131,50,26,,4,,19,71,58,115,,8,8,5,
   13,9,,9,12,,16,,15,14,31,,27,65,,28,59,,,4,,,,,,,,,,,,,,,,,,
   ,,,,,4,4,5,5,,5,5,,5,19,4,,5,5,4,19,19,19,5,,5,,5,,5,
   ,5,,,4,,55,,4,9,5,79,55,5,79,9,5,5,5,,4,,,4,4,19,19,
   4,4,4,,,4,19,19,6,6,6,,,5,6,6,25,5,51,6,6,,,51,25,5,
   6,6,7,,7,5,51,,6,6,51,5,25,25,6,,6,6,7,,7,51,5,,6,
   6,5,51,25,25,6,,6,5,,,6,6,25,51,5,6,6,,,5,25,51,,4,
   17,19,20,4,,17,19,,,,20,4,,,,,,,,,,,,,,15,16,20,,4,19,18,,
   ,4,20,,4,28,8,9,3,4,14,19,10,98,11,27,10,9,4,3,14,
   19,9,71,12,19,19,95,44,,,14,,14,4,10,11,98,44,3,14,4,
   9,12,95,41,4,14,3,4,19,14,9,41,10,19,14,9,28,8,,41,,
   44,60,14,71,19,4,19,22,,,5,,,,,,,4,,,,4,,,,,,,,,,22,,,,,21,,
   ,,,15,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,,5,,,,,,5,,
   ,22,,27,,,,,,5,,28,31,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,4,58,53,47,3,5,,,74,46,39,53,58,154,5,3,
   ,,74,36,37,,,41,55,,,,,,,67,50,,,,,,37,39,,,,,,4,,,,88,76,,
   ,67,107,140,,,,,,,,,,,,4,,,,6,6,,13,6,5,,5,6,13,13,13,6,
   6,12,4,4,,,5,5,,19,4,5,,5,4,19,19,19,5,5,,4,,4,,7,5,
   8,4,7,5,49,4,,,8,49,7,5,,4,6,,6,5,10,9,6,6,10,5,5,
   5,5,,5,,,,,,,,,,,,,,,,,5,7,,8,4,7,49,5,4,,,8,5,7,49,6,6,
   ,18,6,6,,20,,,,,6,6,6,,20,,6,6,20,,,,6,,6,,20,6,,6,18,,
   ,,6,6,,4,19,28,28,3,4,4,3,28,28,19,9,11,11,3,3,3,4,
   10,11,9,6,6,11,28,28,19,4,9,4,6,10,28,28,28,4,4,9,
   9,19,19,28,9,4,4,4,4,3,11,9,11,3,4,28,19,28,4,28,
   19,28,28,28,19,6,6,6,,,,,,,,,,,,,,,,,,,,,4,,117,7,,4,8,5,,
   42,,5,,26,50,7,9,,,,,,,,,,,,,,,,,,,6,,,50,6,,,4,6,30,14,
   14,6,9,,,,,,,,,,,,,,,,,6,,23,33,5,,,,20,,,,6,10,,20,,,,5,
   31,19,,,6,,10,,,,,,,,,,,,,5,12,,10,4,4,9,13,12,9,17,19,,
   15,5,4,16,,80,,107,,4,17,10,39,47,4,,8,,,,,,,,,12,11,24,
   25,,4,8,5,,16,,73,93,13,9,9,12,12,31,34,77,,52,20,,6,
   8,8,4,4,,21,5,,4,4,5,19,12,5,5,,35,12,5,19,4,,5,,,4,
   25,7,,5,25,4,19,19,4,,20,,5,,,25,4,,20,4,4,25,19,19,
   5,7,,,,,,,,,,,,,,,,,4,,27,19,4,20,,19,21,,,,4,20,,19,17,,
   20,4,16,15,,,4,,20,,,,,,,,,,,,,4,12,44,10,3,4,14,19,8,9,
   28,9,95,12,4,3,14,19,9,9,41,19,4,10,8,39,95,3,4,14,
   19,39,29,,,14,14,,8,10,29,44,4,3,14,4,19,14,12,9,95,
   19,14,10,12,44,,44,95,,28,41,,4,19,19,4,4,,,5,5,136,9,
   5,79,55,4,,9,55,,4,4,,,5,136,5,,4,55,4,55,,9,79,9,5,
   22,6,22,6,6,6,13,13,5,5,,12,13,6,13,,22,,,15,16,,,,,,,,
   21,5,,,,5,,31,43,,,,,5,24,16,5,,13,18,18,,29,13,5,,6,
   49,13,45,4,7,,8,21,39,11,49,10,43,7,4,,8,50,49,13,5,,
   15,21,,189,16,5,4,13,10,12,,15,9,4,4,25,47,,48,31,16,
   9,4,,8,24,12,11,,8,39,17,10,,,,,54,67,14,,13,5,4,6,,6,
   13,13,,5,5,13,13,6,6,5,,5,5,,,5,79,9,79,5,55,4,,9,4,
   ,55,,6,22,,10,6,,,20,27,,,,5,,,,,,,,,,,,,,30,,10,,6,,23,43,
   ,5,,,13,16,15,12,9,4,4,5,10,,11,115,43,27,31,9,10,,26,
   ,28,8,8,58,22,115,149,8,,8,6,21,10,39,81,4,,,24,11,
   106,73,,,4,13,,10,24,,27,5,4,11,,9,5,11,,15,14,,13,,4,,
   5,,,79,5,,55,4,4,55,,9,5,9,79,,6,,21,,5,,22,,,39,,10,6,
   ,,,,,,,,,,,,,,21,,,5,19,,,35,6,10,,13,,25,30,9,31,10,,45,
   202,52,,10,10,4,9,4,5,10,14,13,,,,,,,,,,4,11,24,15,12,
   4,8,,8,27,15,11,,8,4,13,5,4,10,19,11,,10,21,58,24,5,
   48,71,39,132,67,49,8,6,8,5,22,18,24,5,13,,25,21,,26,,
   5,13,,,,,,5,28,25,,,5,,,,,15,,16,,,,,21,,,6,106,34,9,4,,,
   8,12,80,52,73,77,12,,4,,8,9,106,20,,5,17,12,,93,4,5,
   16,13,39,24,,,9,16,31,10,11,,12,4,4,9,4,,8,12,19,47,,
   8,10,15,25,,,,,17,107,,5,13,,4,,,,4,,,,,,,,4,,,4,,,,,,,,4,,
   ,58,53,,,,,,,67,50,53,58,,,,,,,41,55,4,,36,37,74,154,,5,
   3,,46,39,74,47,,3,5,,,,,,,,,,,,88,107,,,,76,140,,,,67,,37,
   39,,,4,,,,,4,,,,,4,,,,,37,51,,,,,47,,76,,36,45,,,,,94,,88,,,,
   ,,,,,,4,94,,47,74,3,,5,88,118,76,44,5,,3,,,,36,,45,,,74,
   ,44,,37,,51,118,,,,4,,,118,,67,,,,,74,74,,88,,107,,,,,46,
   36,,,4,41,37,67,76,3,5,,,,,,,,,,55,39,50,140,5,3,,,,,58,
   53,,,,47,154,,,53,58,,39,37,,4,,,20,20,20,4,4,3,4,43,
   20,20,20,20,28,21,14,19,14,21,16,28,14,21,13,28,13,14,
   21,14,21,14,28,43,14,18,4,3,3,14,13,28,4,4,43,21,21,
   4,13,14,14,28,28,19,43,28,20,20,20,21,13,13,20,13,21,
   13,19,21,16,14,20,14,28,21,21,16,28,20,21,16,18,4,4,
   4,21,21,21,3,3,14,16,13,4,14,28,14,20,20,20,20,28,20,
   4,20,20,43,20,3,4,4,20,20,20,20,4,4,3,20,20,16,28,
   21,16,28,18,14,21,13,21,14,21,14,28,21,16,4,3,4,28,
   19,28,28,4,3,4,20,43,14,14,13,21,28,18,14,28,21,43,
   14,14,43,14,14,21,3,4,4,20,20,13,21,13,18,19,18,21,
   16,18,21,21,16,18,21,13,18,4,4,3,4,3,20,20,20,4,20,
   20,20,16,13,16,20,19,20,4,28,19,28,18,18,18,20,28,20,
   21,21,21,20,28,20,20,19,20,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,18,,,18,,,18,,,
   ,,18,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,18,,,
   18,18,18,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,16,16,
   16,16,16,16,16,16,16,16,16,16,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,16,16,16,16,16,16,
   16,16,16,16,16,16,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,86,86,,36,36,86,36,36,36,36,86,4,
   4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,
   ,8,12,8,,,,,,,,86,,,86,86,86,,36,86,36,86,,6,6,6,8,10,
   10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,
   ,,,,,,118,118,,,118,,118,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,
   6,8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,36,86,86,36,,,86,86,
   ,86,,86,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,
   ,8,,16,,16,,,,,,,,118,,,118,,,,118,,118,,,8,10,10,8,4,12,
   12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,,,,
   ,,,,,,,,,4,6,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,,4,6,,6,
   ,8,,8,,,,,,,,36,36,36,36,86,86,36,,86,,86,36,6,10,4,8,
   8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,,118,118,,
   ,,118,,,,,118,8,4,12,12,4,12,12,,,12,12,8,,8,,,,,,4,12,,
   12,,8,,8,,,28,28,,,,,,,,,,,,,,,,6,16,16,6,16,16,,,16,16,10,
   ,10,,,,,,6,16,,16,,10,,10,,,,,,,,,,,,,,,,,,,,4,4,2,4,4,,,4,
   4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,16,16,16,16,16,
   16,16,16,16,16,16,16,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,
   ,6,8,6,,,,,,,,,,,,18,,,18,18,18,,,4,4,4,,,6,6,6,8,6,,,,,
   ,4,6,,6,,6,8,6,,,,,,,,,,,,18,,,18,18,18,,,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,16,16,16,16,16,16,
   16,16,16,16,16,16,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,
   ,,,,,,,18,,,18,18,18,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,
   ,,,,,,,,18,,,18,18,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,
   ,,,18,,,18,,,18,,,,,18,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,18,
   ,,18,,,18,,,,,18,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,20,20,,,
   20,,,,,20,,,,,,,,4,,,,,,4,,,,,,,,,,64,64,,,,36,,,,,36,8,8,,,,
   4,6,,6,,4,,4,,,,,,,,,20,20,,,20,,,,,20,,4,,,,4,,,,,8,,8,,,,,
   ,,,56,,,56,,,,64,,64,,,,,,4,,,,,8,,8,,,,,,,,56,,,56,,,,64,,
   64,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,,,16,16,16,16,16,16,
   16,16,16,16,16,16,,4,,6,,6,,,8,8,,,,18,,,18,,,18,,,,,18,,,
   ,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,18,,,18,,,18,,,,,18,,,,,,,,
   ,,,,,,,,,,,,,,,,4,,,,,,,,,20,20,,,20,,,,,20,,,,,,,,,,,64,64,,,,
   36,,,,,36,,,,,,,,,20,20,,,20,,,,,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,4,,,,,,,,36,64,,,36,,64,,,,,,,,,36,64,,,36,,64,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,16,,,,,,,,,16,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,16,,,,,,,,16,,,,,,16,,16,,,,,,,,,3,6,6,9,,6,9,,12,,,6,
   6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,
   ,6,,6,,6,,,,,,,,,24,24,24,,24,,24,24,,24,24,6,6,9,,6,9,
   ,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,
   ,,,,3,3,,6,,6,,6,,,,,,,,,24,24,24,,24,,24,24,,24,24,5,5,
   ,4,7,10,7,12,,5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,5,,,
   3,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,17,,21,17,,23,
   15,6,22,22,6,17,5,,5,5,12,8,,,5,5,5,5,5,10,5,5,10,
   9,3,4,4,5,5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,
   23,15,21,,17,17,,21,6,15,6,23,,7,8,,7,,,10,10,10,10,
   10,10,10,10,10,16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,
   6,4,6,5,6,5,8,8,,,,,,,,,25,25,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,5,5,5,5,5,10,
   5,5,10,9,3,5,5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,
   ,,5,5,,8,,17,22,6,17,23,,17,22,6,,22,17,,7,,,10,10,10,
   10,10,10,10,10,10,16,4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,
   7,7,,4,,10,,10,,,,,,6,,,,5,,,25,23,,10,,5,,,,,,27,,,,,,,,,6,
   ,,,,,,,6,,,,,,,,,,,,7,,,,7,,,,,,,,,,,11,39,70,,254,,,,,,,,9,9,
   14,9,14,10,9,14,10,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,
   ,7,7,10,6,11,9,10,9,10,10,8,8,,,,,,8,,,,,8,20,,20,,,,,,
   18,,,,,,,6,,,,,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,70,37,,,151,,,,11,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,
   5,4,6,7,7,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,
   14,8,6,8,,,,,,8,,67,20,7,67,24,21,24,10,10,21,10,20,5,
   5,5,5,4,5,5,5,3,5,5,5,6,6,,,3,5,6,,6,,,,,,5,5,6,4,,
   8,6,8,6,6,,,,,,20,67,15,24,24,20,67,10,7,24,7,67,5,5,
   5,6,8,7,8,4,5,5,5,10,10,,,4,5,10,,10,,,,,,5,5,,6,9,7,
   ,7,8,8,,,,,,112,81,20,,165,53,,8,9,54,9,112,5,5,5,5,
   5,5,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,
   ,6,6,,14,,21,24,7,24,67,67,20,7,15,24,15,24,5,5,5,5,
   4,4,5,5,5,10,10,,,4,5,10,,10,,,,,,5,5,9,6,,7,9,7,11,
   11,11,11,,9,,53,,20,165,,112,81,9,20,165,20,,7,7,6,7,
   4,6,6,6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,10,6,7,6,
   10,10,8,8,,10,,101,216,13,204,204,101,216,8,9,196,9,
   216,5,5,7,3,5,5,5,6,6,6,,3,5,6,,6,,6,,,,5,5,,4,,8,,
   8,,,,,,14,,24,24,10,21,20,24,21,15,7,67,7,24,5,8,4,5,
   5,5,10,10,9,,4,5,10,,10,,9,,,,5,5,,6,,7,,7,,,8,8,,12,,
   54,165,9,54,112,,53,20,20,,20,165,7,4,6,6,6,12,12,7,,
   4,6,12,,12,,7,,,,6,6,7,4,8,6,7,6,8,8,10,10,,,,,204,9,
   196,216,216,101,9,13,204,13,204,4,9,9,9,8,8,,,4,9,8,,
   8,,,,,,9,9,10,6,,8,10,8,,,,,,,,121,,33,52,,70,70,10,33,
   52,33,,3,3,3,4,4,3,,2,3,4,,4,,3,,,,3,3,3,2,3,3,3,3,
   3,3,3,3,,3,,16,15,3,16,16,16,15,3,3,15,3,16,3,5,5,5,
   ,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,17,23,23,
   17,17,,4,4,15,23,23,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,
   4,4,4,5,5,,,,,,,17,23,23,17,17,,4,4,15,23,23,5,5,,,3,
   3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,17,,23,17,23,,17,
   4,4,22,22,17,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,
   5,5,5,,6,,,,5,,,,,6,6,,5,,6,,4,5,4,,4,,6,,,,5,5,6,4,
   6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,3,,6,,6,,3,,,,4,
   4,4,4,5,4,4,4,,,,,,,,48,,28,24,24,48,,5,5,22,28,24,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,2,3,3,3,
   3,3,3,3,3,,3,,16,15,3,16,16,16,15,3,3,15,3,16,5,,5,,,
   ,,,4,4,4,4,5,3,4,3,,,5,5,,,,17,,23,17,23,,17,4,4,22,
   22,17,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,
   6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,4,6,5,6,5,
   5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,4,4,4,5,4,4,4,,,,,,,,48,,28,24,24,48,,5,5,22,28,24,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,17,22,4,17,,23,15,23,22,,
   4,17,,4,,5,,5,,,5,5,,5,,17,22,4,17,,23,15,23,22,,4,17,
   4,,,3,,,,,,,5,,24,22,5,,48,24,22,28,28,,5,27,,4,4,4,6,
   6,6,6,,,,16,16,16,16,16,16,16,16,16,16,16,16,,,,,,,,,,,
   24,23,23,,,24,23,,,,21,,,3,5,5,,,,5,,23,15,5,,19,17,22,
   22,23,19,5,,,,,,,,5,,24,22,5,,48,24,22,28,28,,5,27,5,5,,
   ,,5,,23,15,5,,19,17,22,22,23,19,5,,3,5,5,,,,33,137,9,
   29,80,56,19,,9,56,,17,5,5,,,,33,137,9,29,80,56,19,,9,
   56,,17,3,,,,80,19,,56,19,17,56,,9,33,9,80,,,,80,19,,56,
   19,17,56,,9,33,9,80,,,,,,,,,,,,,,,,,,,24,24,,,23,19,23,,24,,
   ,,,,,,,,,,,,72,17,,,,17,23,,58,,59,,,,,16,22,,159,,23,23,
   72,59,13,11,16,5,17,,,,58,118,,17,,17,,72,59,,17,,,23,17,
   ,59,,22,16,,72,17,5,59,11,118,159,10,40,22,,23,6,6,9,,
   6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,
   ,6,,,,,,3,3,,6,,6,,6,,,,,,,,,24,24,24,,24,,24,24,,24,24,
   5,5,,4,7,,7,,,5,5,5,5,5,10,5,5,10,9,4,3,4,4,4,4,,,
   5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,6,,,,,,,22,,22,17,6,
   23,17,17,17,22,6,5,,5,5,,8,,12,5,5,5,5,5,10,5,5,10,
   9,5,3,5,5,5,6,5,5,4,5,5,,7,,,,,,3,4,,5,,5,,7,,,,,,,8,
   15,6,17,21,,21,17,,23,23,15,6,,7,8,,7,,,10,10,10,10,
   10,10,10,10,10,16,7,4,7,5,5,4,,,5,6,6,,10,6,,,6,,4,5,
   ,6,,6,,10,,6,,,,,,,5,23,,23,5,,,,,,10,12,,,,,,,18,,,,,,,,,,
   6,,,,,,,,,,,,7,,,,,6,,,,,,,,,7,,,,,,,,,,,,151,,,70,37,11,5,,7,
   ,10,5,5,5,5,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,
   ,,6,8,,3,5,,5,,5,5,5,,,,6,,,,22,6,22,6,15,21,,17,17,
   17,,22,,7,,,10,10,10,10,10,10,10,10,10,16,5,4,5,7,7,
   4,8,8,7,10,10,,5,,,6,,,4,7,,10,,10,,5,,,,6,,,6,,10,,5,,
   ,25,25,,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,9,9,14,9,14,10,9,14,10,11,7,6,7,7,7,6,10,10,9,8,
   8,8,9,10,,10,,,6,9,,8,,8,8,9,,10,,10,,,11,,20,,8,,8,,,,,
   ,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,,
   ,,,6,,,,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,,,,,,,254,11,70,39,,,,,5,
   5,4,5,5,4,6,7,7,5,3,5,5,5,4,,,5,6,6,,8,6,,,14,,3,5,
   ,6,,6,,8,,6,,,,,,67,7,24,15,21,10,20,21,24,24,24,7,5,
   5,5,5,4,5,5,5,5,3,5,5,5,4,,,5,6,6,6,8,9,,9,14,,3,
   5,,6,,6,6,8,,9,,9,,,8,24,15,67,7,20,7,67,24,24,21,24,
   15,5,5,5,6,8,7,8,5,4,5,5,5,6,,,5,10,10,8,7,9,,,12,,
   4,5,,10,,10,8,7,,9,,,,,,,20,,20,53,9,112,54,165,54,165,
   20,5,5,5,5,5,5,5,3,5,5,5,4,6,6,5,6,6,,8,,,6,,,3,5,
   ,6,,6,,8,,,,6,,,,24,7,20,10,67,15,24,24,67,20,67,7,5,
   5,5,5,4,5,4,5,5,5,6,11,11,5,10,10,11,7,,,9,9,,4,5,,
   10,,10,11,7,,,,9,,,,165,20,81,9,81,20,,165,,53,,20,7,7,
   6,7,6,4,6,6,6,4,8,8,6,12,12,10,6,7,,7,,,4,6,,12,,
   12,10,6,,7,,7,,,8,204,13,216,9,101,9,216,196,204,,204,
   13,5,5,7,5,3,5,5,5,4,,,5,6,6,,8,9,,6,8,,3,5,,6,,6,,
   8,,9,,6,,,14,21,10,21,10,24,7,24,67,20,67,20,10,5,8,
   5,4,5,5,5,6,8,8,5,10,10,,7,,,,,,4,5,,10,,10,,7,,,,,,,
   9,54,9,53,8,,20,165,,112,112,81,9,7,6,4,6,6,6,4,10,
   10,6,12,12,8,6,7,,7,10,,4,6,,12,,12,8,6,,7,,7,,,10,
   196,9,101,8,216,13,204,204,216,101,216,9,9,4,9,9,9,6,,
   ,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,,,,52,33,70,10,70,
   33,,52,,121,,33,3,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,3,,5,,
   5,5,5,,4,,,,,,,4,22,22,15,4,,17,17,17,22,22,3,3,3,2,
   3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,3,3,,3,,3,,,3,15,3,
   15,3,15,3,16,16,16,16,15,3,4,4,4,,,3,5,5,5,5,4,,,5,,
   3,3,,5,,5,5,5,,4,,,,,,,4,22,22,15,4,,17,17,17,22,22,3,
   4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,22,22,,4,
   17,23,23,17,17,17,,4,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,
   3,,,,4,,,5,22,22,,4,17,23,23,17,17,17,,4,6,6,4,4,4,6,
   4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,16,16,16,16,16,16,16,
   16,16,16,16,16,3,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,
   56,,56,,19,9,80,29,17,33,137,9,5,5,5,5,5,,,,,,3,5,,5,,
   5,5,5,,,,,,,,56,,56,,19,9,80,29,17,33,137,9,5,5,,4,,,4,,
   ,3,3,,5,,5,,4,,,,4,,,5,15,23,17,4,,23,17,23,23,,17,4,
   4,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,
   6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,
   ,,,,,,3,,,5,,5,3,,,,,,,,,33,9,17,,56,,19,56,80,80,19,9,4,
   ,,5,,3,4,,5,,5,,3,,4,,,,,,19,5,17,22,22,5,19,,,23,15,
   23,,4,,,3,,,6,,6,,4,,3,,4,,,5,22,28,42,5,,28,24,24,24,
   48,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,,
   5,22,28,22,5,48,,27,24,22,28,,3,,,6,,6,,5,,,,5,,,,23,,,
   23,,,24,24,24,,,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,
   ,3,,,3,15,3,15,3,15,3,16,16,16,16,15,3,,5,,5,,4,,,,4,,
   ,5,15,23,17,4,,23,17,23,23,,17,4,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,
   6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,33,9,17,,56,,19,56,80,
   80,19,9,,4,,,,,,19,5,17,22,22,5,19,,,23,15,23,,,,,,,,,,,,,,
   ,,,,,,4,,,5,22,28,42,5,,28,24,24,24,48,,5,,,,,,,,,,,,,,,,,,,
   ,,5,22,28,22,5,48,,27,24,22,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   21,23,,23,23,,,,24,23,,22,,59,,16,,,,,,159,59,11,72,5,17,
   17,23,58,159,10,22,,72,17,,,,,16,22,13,72,58,118,17,16,
   5,59,,,17,,,16,23,23,17,72,59,11,,,,,59,,17,,118,,,40,,
   23,22,8,8,,6,7,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,
   6,6,,,5,6,6,9,6,10,,,,,5,4,10,6,,6,,6,9,,,,,,,23,,,,23,
   30,20,30,,23,30,30,8,,8,8,,10,,,8,8,7,8,7,10,8,7,10,
   20,5,5,4,10,7,10,,,5,7,4,,7,,,,,,5,4,,10,,7,,10,,,,,,,,
   23,30,,,23,,23,,30,23,30,30,11,7,4,11,7,6,6,8,8,6,8,
   6,9,8,6,9,8,5,5,4,6,4,6,,5,8,6,6,,6,8,,,12,8,8,4,
   8,6,12,4,,6,,,5,,12,8,8,6,8,6,6,8,8,6,8,8,8,6,6,,
   6,6,,,,,,11,,10,,,9,,16,,,5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,
   ,6,,,,,49,,,,,,49,,,,,,8,,7,,,8,8,7,8,7,10,8,7,10,20,5,
   5,4,6,6,6,,9,5,6,6,,6,,10,10,,,5,4,,6,,6,,6,,,9,,,,,
   23,30,30,30,20,,23,,30,23,,,6,7,11,11,8,8,6,8,6,9,8,
   6,9,8,8,8,4,6,6,6,,,5,4,6,5,4,,8,8,8,12,5,4,,6,8,
   6,,6,5,,,,8,12,12,8,6,8,8,6,6,8,6,6,6,8,8,,,,,34,9,,
   13,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,,,,,,49,,,,,,
   49,,,,,,,,12,12,10,12,10,8,12,10,8,10,6,6,4,4,6,4,,7,
   6,6,4,7,6,10,10,10,,8,6,4,10,4,,6,,4,7,,7,,8,,,17,,,,
   6,,6,,,17,,,6,,,9,,10,,,11,,16,,,5,,8,,,,,5,8,6,5,,,,,,,5,
   ,,,8,,,6,,,,,,,,,,,49,,,,,49,,,,,9,34,13,,,9,,16,,,5,,8,,,,,
   9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,49,,,,,49,,,5,5,8,7,7,8,
   4,9,9,5,5,4,10,7,10,,,5,7,4,12,7,8,,,,,5,4,8,10,,7,,
   10,12,,,,,,,17,16,41,41,23,23,15,23,16,23,16,16,5,5,5,
   8,8,7,7,7,5,5,4,10,7,10,,,5,7,4,12,7,9,,,,,5,4,9,10,
   ,7,,10,12,,,,,,,15,41,41,41,15,16,17,16,41,23,41,41,7,
   4,7,4,5,7,5,5,5,3,5,6,5,,,5,6,6,9,6,6,,,11,10,5,3,
   6,5,11,6,,5,9,,,,10,11,11,7,8,8,8,7,9,7,9,8,7,8,8,
   5,7,5,5,8,7,5,5,4,10,7,10,,12,5,7,4,,7,,9,9,,,5,4,,
   10,,7,,10,,,12,,,,,23,41,16,16,17,41,15,41,41,15,41,41,
   7,7,4,7,6,5,5,3,5,6,5,,6,5,6,6,6,6,,,,10,8,5,3,,5,
   10,6,,5,6,,6,,8,10,10,7,8,8,8,7,8,7,8,8,7,8,8,9,7,
   10,9,8,8,6,8,9,8,,10,8,9,6,10,9,11,10,10,,,8,6,11,8,
   ,9,,8,10,,10,,,,,12,,,,12,66,16,66,,10,,,5,7,9,5,5,4,
   10,7,10,,12,5,7,4,,7,,8,8,,,5,4,,10,,7,,10,,,12,,,,,23,
   16,23,23,15,41,23,41,16,17,16,16,7,5,5,5,3,5,6,5,,9,
   5,6,6,,6,,6,6,11,10,5,3,,5,11,6,,5,,,9,,10,11,11,7,
   8,9,9,7,8,7,8,8,7,8,8,9,8,8,6,8,9,8,,10,8,9,6,10,
   9,10,11,11,,,8,6,10,8,,9,,8,10,,10,,,,,10,,66,66,16,,12,
   ,,12,,,10,10,4,9,6,9,,,10,6,4,,6,9,9,9,17,12,10,4,9,
   9,17,6,,9,,,,,12,17,17,8,10,12,12,8,12,8,12,10,8,10,
   10,3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,
   ,4,,,,5,23,23,4,5,,5,5,4,23,23,3,5,5,5,,,3,4,4,4,4,
   5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,23,23,4,5,,5,5,4,
   23,23,4,3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,3,4,6,3,,
   4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,,6,5,5,
   4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,
   ,,5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,5,4,,,,6,9,9,
   5,5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,6,5,5,5,5,,6,5,
   4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,4,4,4,4,4,,,,9,,4,3,,6,9,,,6,4,,3,,6,,,
   31,6,,,4,6,31,6,6,5,9,9,5,4,,5,,5,5,,4,3,3,,5,,4,,5,
   ,,4,,,7,7,4,23,5,5,,23,4,23,23,,5,5,4,,3,5,,,9,6,5,
   3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,
   4,4,6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,,6,6,16,4,4,4,
   16,4,16,4,4,16,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,9,9,5,9,
   6,6,31,,4,,9,31,6,6,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,
   8,8,5,7,5,5,5,7,5,7,7,5,5,5,5,5,29,8,,3,3,5,29,,,
   5,,,,,,9,9,6,17,7,7,,17,6,17,17,,7,7,3,9,,5,3,5,5,9,
   5,,5,,,,,8,29,29,,7,17,17,6,7,,7,7,6,17,17,9,,5,3,5,
   5,9,5,,5,,,,,8,29,29,,7,17,17,6,7,,7,7,6,17,17,8,,6,
   29,,6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,
   ,,20,6,,6,6,22,,,3,,5,,4,,5,,,4,,,7,7,4,23,5,5,,23,4,
   23,23,,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,
   4,3,4,4,5,29,,,5,,,,,,9,9,6,17,7,7,,17,6,17,17,,7,7,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,
   5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,
   ,6,,6,,6,,,5,,,,5,,5,,,5,,,,4,,,9,9,5,9,6,6,31,,4,,9,
   31,6,6,,,,,,,,,,,,,,,,,,,6,,,31,6,,,4,6,31,6,6,5,9,9,,,,,,,
   ,,,,,,,,,8,8,22,,6,6,,,20,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,
   7,,,5,23,23,11,5,6,5,5,11,23,23,,,20,8,5,8,4,23,,,4,
   5,,23,,,5,8,8,5,,23,,,5,8,8,23,10,23,20,6,5,5,5,4,8,
   23,,,5,5,11,20,20,8,23,,,23,,,5,5,4,3,,4,4,5,4,,,4,4,
   6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,
   6,,6,,7,,7,,,,,,22,22,,,,22,22,22,22,4,4,4,,4,4,5,4,,,
   4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,
   4,7,6,,6,,7,,7,,,,,,22,22,,,,22,22,22,22,4,4,4,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,
   4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,
   ,4,4,4,,,4,4,,,,16,16,16,16,16,16,16,16,16,16,16,16,,
   3,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,
   ,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,22,22,22,4,4,4,,22,22,22,
   ,,,,8,,8,,,,11,,11,5,,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,
   8,6,8,,13,14,7,,,,56,56,23,23,23,11,11,19,113,,,,5,,6,
   6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,
   6,,4,,9,,6,8,,,7,,,,,,22,22,22,4,4,4,,22,22,22,,8,,,8,
   11,14,,8,7,11,5,,,5,5,,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,
   6,6,8,,,,,,23,23,56,56,113,,,,23,19,11,11,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,5,5,4,4,7,7,4,4,
   5,4,5,5,,,4,5,5,9,7,8,7,,15,,4,5,,5,,7,,7,11,11,8,,,
   13,,67,23,20,67,22,8,7,9,24,8,9,6,4,4,4,4,4,5,5,7,
   4,4,5,4,5,5,,,4,5,5,7,7,8,,,,,4,5,11,5,,7,8,7,,,,,,,,
   20,67,67,23,20,7,15,8,23,9,6,15,5,4,5,4,8,6,8,4,5,
   6,4,6,6,,,5,6,12,11,7,13,,,,,4,6,,6,,7,,12,,14,,,,,,,67,
   ,67,73,10,13,7,32,7,7,9,4,5,4,4,4,7,4,4,5,4,5,5,,,
   4,5,5,,7,,,,,,4,5,,5,,7,8,7,11,,7,7,,,,22,20,23,24,67,
   15,6,7,67,6,15,7,5,5,4,5,8,4,5,6,4,6,6,,,5,6,12,,7,
   ,,,,,4,6,14,6,,7,13,12,20,18,14,14,,,,73,,67,32,,13,9,
   10,67,7,9,13,7,6,8,7,4,10,8,4,8,8,,,10,8,7,18,7,,,,,
   ,4,8,19,8,,7,12,7,13,,12,11,,14,,55,,,47,55,8,15,7,
   47,8,9,15,4,5,7,4,4,5,4,5,5,,,4,5,5,,7,7,7,,13,,4,
   5,,5,,7,,7,,11,,9,,15,,24,21,24,21,23,6,9,15,20,15,7,
   8,5,8,4,5,6,4,6,6,,,5,6,12,,7,14,14,,,,4,6,18,6,,7,,
   12,,,14,16,,,,34,73,32,34,67,9,7,13,,9,13,10,7,4,10,8,
   4,8,8,,,10,8,7,,7,12,11,,14,,4,8,,8,,7,,7,18,,16,12,,,
   ,104,55,47,128,,15,9,8,,9,15,8,6,9,11,6,11,8,,,9,11,
   10,,10,,,,16,,6,11,,8,,10,,10,,,,21,,16,,,,,,,10,9,7,,9,
   9,10,4,4,2,4,4,,,3,3,4,4,4,4,4,,5,,2,3,5,3,,4,4,4,
   5,5,4,4,,5,,16,15,15,16,15,4,15,4,15,4,4,15,4,4,4,4,
   ,,4,5,5,5,5,6,,,8,,3,4,6,5,,5,5,5,6,6,,,,,,,22,,22,
   16,6,22,5,16,5,22,6,4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,
   ,5,6,5,6,6,,,,,,22,22,,,16,22,20,5,16,3,4,4,4,4,,,4,
   4,4,4,4,4,4,,,,2,4,5,4,,4,4,4,5,,4,4,,,,15,16,16,15,
   15,15,4,4,15,4,15,4,4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,
   6,5,6,8,8,6,,,,,,22,22,16,4,4,3,16,5,22,20,,,5,4,5,
   6,5,,5,,,,3,5,6,4,,5,6,5,6,8,6,8,,8,,22,,22,,16,22,
   6,5,16,5,6,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,
   ,16,,21,16,,22,5,6,22,22,6,5,5,,5,,,,,,4,4,6,4,,5,5,
   5,,8,6,6,,,,16,21,,16,,22,5,22,22,4,4,3,,4,7,7,,6,,4,
   5,,5,,4,,4,8,7,8,7,,6,,,18,18,,,4,17,6,,17,4,6,,,,,,,
   4,6,5,5,,,4,,9,9,8,,,6,,34,47,45,,,,7,15,72,13,5,6,7,
   7,,8,,4,5,,5,,4,,4,8,7,7,8,,6,,,18,18,,,5,7,7,,5,4,
   5,4,,49,,4,8,8,6,,7,9,7,,6,9,8,,12,,41,,72,39,,16,6,
   7,,9,9,,,36,,4,6,8,8,,7,8,7,,5,,,,,,41,72,,39,,15,,7,,
   6,13,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,8,,6,10,6,,,10,10,,,
   ,26,,,,,,7,7,26,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,5,
   4,4,,5,,15,15,15,15,16,4,4,15,16,15,4,4,8,4,,5,,5,8,
   ,6,6,,,,16,,21,16,22,4,3,4,,22,22,5,8,,,6,,,11,,9,,11,,
   ,33,33,47,97,5,7,23,,,7,,,5,,5,,,6,6,,,,16,21,,16,22,
   6,5,22,,6,22,5,,,,,,,,,,,,,,,,,,,,,,,,4,7,7,,7,,8,,,18,18,,
   ,4,5,5,,7,5,7,,8,,9,,,,,34,47,45,,72,6,7,16,,9,,10,7,
   7,7,,,6,,,18,18,,,4,6,17,,6,4,17,,8,8,,,,33,47,,33,,11,
   8,,162,23,7,5,8,8,,,,29,,97,29,,23,5,7,,11,,7,4,,,,,,,
   72,25,7,16,6,26,10,9,9,,,,72,,,,25,7,15,,26,5,6,13,,,,,,
   ,,,,,,,,,,,,,26,26,,,,,7,,7,,,,,,,,,,,,,,,16,,16,22,16,,44,
   44,70,16,,,22,16,16,,44,70,55,,,70,55,44,,16,22,16,,44,
   70,44,,16,16,22,55,40,70,16,22,16,16,4,4,16,10,16,10,
   5,16,11,10,16,22,16,10,11,70,55,40,4,5,4,,4,4,5,4,,,
   4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,
   4,7,6,,6,,7,,7,,,,,,22,22,,,,22,22,22,22,4,4,4,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,
   4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,
   6,,9,,7,,,,,,,,4,4,22,22,22,,,,4,22,22,22,,4,,5,4,4,6,
   4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,
   6,,9,,7,,,,,,,,4,4,22,22,22,,,,4,22,22,22,,,,,8,11,8,,,,,
   ,11,8,,5,6,9,,8,6,5,5,8,,6,,,7,,,,,9,6,,8,,8,,,,,,,,
   19,11,23,23,23,56,113,56,11,,,,,,4,4,6,4,6,4,4,6,4,6,
   4,4,4,4,4,4,6,6,4,4,6,,4,,,6,,,4,4,6,4,,4,,6,6,6,,,,
   ,,16,16,16,16,16,16,16,16,16,16,16,16,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,8,,,,11,,11,,5,,6,5,6,,,,
   9,8,,8,,,9,,,8,5,7,,,6,,8,6,8,,,,,,,,56,56,113,23,23,23,
   ,19,11,11,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,4,5,5,,
   7,,,,,,4,5,7,5,15,7,,10,,9,,,,,,15,6,23,67,24,22,20,24,
   9,9,8,7,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,8,4,5,5,,7,,
   ,7,,,4,5,9,5,,7,,10,8,7,,,15,,13,7,15,67,20,23,20,67,
   22,6,8,7,15,5,4,5,4,8,6,8,5,4,6,5,6,12,,,4,6,6,,7,,
   ,,,,5,6,16,12,16,7,,7,,11,,,16,,,13,9,67,,32,73,,34,7,
   7,10,13,4,5,4,4,4,7,4,4,5,4,5,5,7,8,4,5,5,,7,,,9,,
   15,4,5,7,5,13,7,,10,8,,,,,,,8,7,20,22,67,67,23,20,15,
   7,15,6,5,5,4,5,8,5,4,6,5,6,12,,13,4,6,6,,7,,,11,,,
   5,6,11,12,14,7,,7,13,,,,,,14,10,13,,73,67,,67,73,9,10,
   13,9,7,6,8,7,10,4,8,10,8,7,,,4,8,8,,7,,,18,,,10,8,
   11,7,,7,,8,12,18,,,,,16,8,15,,55,47,55,,104,9,7,8,15,
   4,5,7,4,4,5,4,5,5,9,,4,5,5,,7,,,7,,,4,5,,5,,7,,10,,,,
   ,,,15,9,8,22,24,20,23,24,67,7,15,6,9,5,8,5,4,6,5,6,
   12,11,,4,6,6,,7,,,16,,16,5,6,,12,,7,,7,,,,,,,16,7,10,
   73,34,,67,32,,13,13,9,7,7,10,4,8,10,8,7,18,12,4,8,8,
   ,7,,,11,,,10,8,18,7,16,7,,8,,,,,,,,7,8,55,104,,,47,55,
   15,8,15,9,9,6,11,9,11,10,,,6,11,8,,10,,,26,,15,9,11,
   26,10,16,10,,10,,,,,15,,16,7,10,,,,,,,9,7,10,9,4,4,4,5,
   5,,,3,4,5,,5,,,,,,4,4,,6,8,7,,7,5,5,,,7,,,22,5,21,,16,
   16,,21,6,5,6,22,4,4,4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,
   5,4,,4,4,4,,,5,,5,15,4,16,15,15,15,16,15,4,4,15,4,5,
   4,5,,,3,5,4,,5,,,,,,4,4,6,7,,6,,7,6,6,,,4,,,22,5,,,16,
   16,21,21,22,3,4,4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,
   5,,4,6,,,,8,,7,6,22,,16,22,,22,16,5,6,22,5,5,6,,4,4,
   4,,5,,,6,,,4,5,6,5,4,5,,4,5,,,,,,7,4,4,22,16,22,,,16,
   3,22,20,5,7,7,4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,
   4,17,18,,,,18,,6,6,4,17,4,4,,5,,7,,,,,36,5,6,,,10,,,8,
   9,,,,6,,,15,,,,39,41,72,39,7,5,13,6,4,5,,,7,,,,,49,5,6,,
   ,10,,,8,8,9,,,,,,16,6,72,,39,41,,39,7,10,7,10,4,4,,4,,
   ,4,,5,4,4,4,4,5,4,,4,4,4,,,,,5,4,15,15,15,16,16,15,
   15,4,15,4,4,4,,5,,,6,,,5,4,6,5,7,5,,4,,6,,,,,4,22,20,
   ,16,,22,22,16,5,4,4,3,,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,
   7,22,6,22,16,,22,,16,5,22,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,8,7,6,7,6,14,6,,7,,,,,9,,9,5,7,18,,,,18,,7,5,4,5,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,
   7,38,7,,7,,,,,,,,,7,45,,,34,47,118,16,6,5,13,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,7,4,,8,9,9,,8,,6,,,,,,,7,,,,26,,26,7,,,,4,,5,
   ,5,,7,,,,,,,8,5,6,16,21,,21,16,,22,22,5,6,,5,,5,,7,,,,,,
   ,,3,4,16,21,21,,16,,4,22,5,22,,,,,7,,,,,,,38,6,5,39,
   118,47,45,,,13,,7,16,,4,,7,7,7,,,6,,8,6,4,,,18,18,,,17,
   4,17,6,9,,,,,,,,,,7,7,,,,26,26,,,,,,,7,7,7,,,8,,14,5,4,,,
   18,18,,,5,5,7,7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,17,,17,
   17,17,,,6,6,,4,,,49,,10,10,7,41,39,,72,39,,10,16,6,7,,,
   36,,10,5,13,41,39,72,,39,,6,15,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,9,,,26,26,,,,,,,7,7,,,,,,,,,,,,,,,,26,,26,,,,,7,7,,4,70,
   55,44,16,22,16,5,11,12,10,55,40,70,22,16,16,4,12,10,9,
   ,,,16,,40,16,22,16,,,,,115,16,16,22,16,,,55,22,16,16,,,
   16,70,55,40,,16,44,70,55,22,55,40,115,10,9,11,4,5,4,
   5,6,6,5,,,,,10,,10,13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,
   9,6,,,,8,10,,,10,9,,,,,41,41,,,,41,41,41,41,5,5,5,4,,3,,
   ,6,6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,
   ,4,4,,4,,6,7,6,,,7,,,,,22,22,4,4,4,22,22,22,22,,,,6,
   4,6,6,4,4,4,4,4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,
   6,,,,6,6,4,4,,4,6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,
   4,4,4,4,,,,,,9,,10,,,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,
   5,,,8,,,,10,,,,,,41,41,5,5,5,41,41,41,41,,,,,,6,6,7,6,
   7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,
   6,7,6,,,7,,,,,22,22,4,4,4,22,22,22,22,,,,3,,,6,9,9,,,6,
   ,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,
   30,,,,,30,30,30,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,
   6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,30,5,5,4,7,7,
   4,6,7,7,5,5,6,5,4,8,,,5,6,8,,9,10,,,20,,5,4,11,8,
   20,6,11,10,,10,,,,,,16,9,18,19,21,9,16,22,22,10,10,21,
   5,5,5,4,4,7,7,6,5,5,6,5,4,8,,,5,6,8,,9,,,,,,5,4,10,
   8,,6,10,10,,13,,,,,,16,16,19,18,18,16,16,9,9,10,21,19,
   7,6,7,6,4,5,4,7,7,6,7,4,7,,,7,6,7,,12,8,,,10,10,7,
   4,6,7,10,4,6,6,16,9,,,8,9,9,6,7,7,7,7,7,6,7,7,6,
   7,7,5,7,5,5,4,6,5,5,6,5,4,8,,10,5,6,8,,9,,,,,20,5,
   4,13,8,20,6,,10,12,,13,,,,,9,16,18,21,19,16,9,16,16,
   21,19,21,7,7,6,7,8,7,7,6,7,4,7,,8,7,6,7,,12,,,,10,
   10,7,4,9,7,9,4,8,6,14,7,7,,6,8,9,7,6,7,7,7,6,7,7,
   7,7,7,7,7,5,4,7,7,7,6,7,7,8,,10,7,6,8,,9,10,,,,,7,
   7,10,8,,6,11,8,,,,,,15,15,32,32,,38,38,32,32,10,10,9,
   21,20,5,7,7,5,5,6,5,4,8,,11,5,6,8,,9,13,,,20,,5,4,,
   8,,6,,10,,7,11,,,,,22,9,21,21,18,9,22,16,16,19,21,10,
   7,4,7,7,6,7,4,7,,6,7,6,7,,12,7,,,9,10,7,4,7,7,9,4,
   ,6,,,9,,8,6,8,7,7,7,6,7,7,7,6,6,7,7,7,7,7,7,6,7,
   7,8,,11,7,6,8,,9,,,,,,7,7,,8,,6,10,8,,13,13,,,,,10,32,
   38,10,,32,10,32,32,21,20,21,8,8,8,8,4,7,,8,8,8,7,,
   18,8,,,10,9,8,4,8,7,10,4,8,7,,,,,9,12,11,7,7,8,11,8,
   7,7,7,7,11,8,8,5,5,4,4,4,,,4,6,8,,8,5,,,5,,4,3,5,
   4,5,4,4,4,6,4,,,8,,,,4,21,22,6,4,,4,4,21,6,22,5,4,
   4,4,,,4,5,5,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,,,,,4,
   22,21,6,4,,4,4,21,22,6,5,4,5,,5,6,6,6,,6,6,,,8,8,6,
   4,6,5,8,4,5,5,,5,5,,6,5,5,6,6,5,5,6,6,6,6,6,6,5,
   5,4,5,,5,5,5,4,,8,,,,,5,4,4,4,4,5,3,5,4,6,,4,,8,,8,
   4,,22,6,21,,4,4,4,6,22,21,4,,,4,4,4,,6,,,,6,6,3,3,3,
   3,4,3,3,3,5,4,4,,6,6,6,4,4,4,4,4,4,4,3,3,4,4,4,,
   5,8,6,4,,8,,,,,5,4,4,4,4,5,3,5,4,6,,4,,,8,,4,,6,22,
   21,,4,4,4,6,21,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,6,,,
   8,,,,7,,4,3,5,4,5,4,4,4,6,5,5,,,,,31,5,,,8,5,31,4,4,
   7,7,8,5,4,,8,,,,,5,4,4,4,4,5,3,5,4,7,7,4,,,8,,4,,
   21,6,22,,4,4,4,22,6,21,5,,6,5,,,8,8,5,4,5,5,8,4,6,
   6,,5,5,,5,5,6,6,6,5,6,5,6,6,6,6,5,5,6,,8,5,,,5,,4,
   3,5,4,5,4,4,4,7,4,7,,,,8,,4,6,21,22,4,,4,4,22,21,6,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,,12,12,8,6,8,8,12,6,8,8,,
   8,8,,8,8,8,9,9,8,8,8,9,9,9,9,8,8,8,,,,7,4,4,4,4,
   5,3,5,4,7,6,5,,,12,12,5,31,,8,,31,5,4,4,8,8,8,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,6,5,5,6,
   4,7,5,9,,5,,,,,5,,,,,,5,5,5,,,,5,4,7,5,6,6,5,5,9,5,,,,
   ,,,5,,,,5,,5,5,,,,4,,5,,4,,8,,5,5,,,,8,4,4,6,21,22,4,
   4,,,22,21,6,4,4,6,3,,4,6,,3,,6,6,6,3,4,4,4,4,4,3,
   4,4,4,4,4,,,,6,,,5,,,,,,5,4,8,8,8,4,5,31,31,,,8,,4,,5,
   ,5,5,,,,,4,4,22,21,6,4,4,,,21,22,6,6,,,,7,7,,,,,5,5,,,
   ,5,5,,,,,,4,4,6,3,,,6,6,6,4,3,6,6,6,3,4,4,4,6,6,6,,
   ,,5,,,,,4,5,8,,,5,4,31,31,8,8,8,,5,5,,8,,,4,4,21,22,
   6,4,4,,,21,6,22,7,7,,113,40,46,7,7,21,31,79,7,7,,,79,
   21,36,4,,,,12,4,31,8,8,7,31,4,5,5,,,,,12,,,31,4,,,,4,
   31,5,5,7,8,8,,,,,,,,,,,,,,,,5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,,
   6,,,,,6,,,,,,6,,4,21,22,22,4,3,4,4,43,22,21,21,22,22,
   3,4,4,4,22,21,22,5,5,21,21,22,22,4,4,4,8,22,22,43,
   43,4,4,4,22,22,21,21,4,4,4,4,4,4,22,21,22,4,4,43,
   22,21,3,22,22,22,22,22,22,5,8,5,,,5,,,,8,8,,11,7,8,,
   14,11,,8,5,5,9,6,8,6,,5,8,,6,9,9,,,,5,,,,,8,,6,,,,8,,,
   ,19,11,,,,56,113,56,11,23,23,23,3,,,,,9,6,,9,,,6,,9,,,
   6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,30,30,,,,30,
   30,30,30,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,
   ,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,,,,9,11,,,8,10,
   ,8,10,,6,5,6,,5,8,,,5,8,,6,,8,,,,8,9,,,,8,10,8,10,11,
   11,10,,,,56,56,,,,11,11,19,113,23,23,23,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,9,9,,,10,,10,7,13,,8,,,13,,,8,,,183,183,9,12,11,,,,,,
   26,15,,,,,,,64,,,,,64,44,49,12,8,17,,6,,7,7,9,7,,,8,14,
   8,15,,,,8,,,9,9,,,187,,14,8,,,,10,,,,21,,,,,,46,67,,,,56,
   67,75,56,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,
   7,,14,8,,8,,,9,,8,15,,9,,,,,187,15,8,17,,,10,13,,26,16,
   18,23,,,,56,67,,,,46,67,77,46,,8,,10,8,,10,,10,12,10,,15,
   ,,,12,15,,,,,,,,11,10,17,,,12,18,12,19,16,14,19,,,,45,74,,
   ,,45,74,,39,8,12,16,,,10,,13,,13,10,21,20,10,,22,15,,
   15,10,,,101,,,,,,,,,,,,,,,,,,140,,,,,,53,103,34,10,12,9,7,,
   12,7,12,7,,14,10,,7,,,11,9,,,,,,7,13,,,8,,,,,,24,,,,81,40,
   ,,,46,40,35,46,,11,11,,,15,16,17,,15,,11,,18,11,,,11,19,,
   ,,17,18,,,158,16,,21,26,27,,,,,,95,,,,,,120,,,23,42,11,,,
   10,,11,16,,9,,10,,,10,8,,,,,,11,,,,10,13,,,,,,,,,97,97,,,,
   125,97,47,125,10,10,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,5,5,6,5,5,,6,6,,6,5,,,32,,6,5,4,,71,,,,8,7,,,,,,63,
   12,,,,21,98,58,51,5,23,7,6,5,6,,4,,6,6,,6,5,,,20,,6,5,
   ,,,4,4,,8,7,5,,,,,39,12,,,,12,39,39,39,4,5,5,5,6,,5,,,
   6,,6,5,5,,,32,,,6,,117,6,7,6,,,7,8,,,,21,98,,,,63,12,
   44,77,7,23,5,,7,,,5,,,6,,7,,,,5,5,6,,18,5,6,5,8,8,8,
   8,,,,29,29,,,,29,29,11,11,,5,,8,5,,6,,,,,8,,,71,6,5,7,,
   18,6,7,5,10,9,7,9,,,,44,63,,,,98,77,21,12,7,5,23,5,,,
   8,,8,7,,,,44,,,6,,,,,,,,,,,,,21,,,,,39,84,,,7,17,7,,5,,,5,,
   7,,25,44,5,4,6,,17,4,4,4,8,7,6,6,,,,31,14,,,,14,37,
   11,11,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,4,,,,20,,6,
   7,,,6,7,6,,,7,8,,,,12,39,,,,39,12,39,39,5,5,4,,,5,8,,
   71,,6,5,7,,36,6,7,6,9,7,9,10,,,,98,77,,,,44,63,12,13,
   23,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,,,,6,5,7,,22,6,7,
   6,10,7,7,10,,,,51,51,,,,51,51,13,13,5,4,5,5,,44,25,4,
   5,5,,18,5,6,5,6,7,7,8,,,,14,37,,,,31,14,11,11,6,6,,,
   44,,,6,,,,,,,,,,,,,,39,84,,,,21,,,,7,17,7,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,71,,45,,,20,29,20,,,21,27,,,,44,,,,,,71,71,44,,,,36,
   18,,,,,,117,39,37,,,,,,,71,,,,44,,44,117,,,,,,,,6,,6,,5,7,8,
   ,,,21,58,,,,44,12,63,163,23,7,5,5,,,5,,5,,,6,7,,,,11,29,
   ,,,29,11,29,29,,,5,,,,,,,,,,,,,64,16,,,,29,99,,,,28,7,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,71,117,,,,44,44,,,,,,4,,8,7,,,,,,40,
   12,,,,12,40,40,40,6,10,10,,,,5,,,,,40,16,,,,16,40,,,,10,
   10,8,7,,,,,,58,21,,,,12,51,63,98,5,7,23,,9,10,,,,23,,,,,,
   17,,215,32,9,6,8,9,,,,22,,,,,,13,70,189,,,7,,,,,,13,,,,13,
   ,49,49,7,,,,,,,23,,,,16,,,134,6,9,32,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,29,,,,19,41,19,40,22,22,31,,,,41,21,19,29,52,
   23,18,,,,,,,,,,,,,,,,,,,,,,,,,29,29,21,31,19,23,40,31,24,18,
   31,41,19,31,22,32,31,18,5,5,5,,4,,5,4,4,6,4,6,9,4,
   6,9,12,4,4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,
   ,,,,4,4,22,22,22,,,,4,22,22,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,7,6,7,6,6,7,6,9,4,6,6,4,
   4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,22,22,4,
   4,4,22,22,22,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,8,11,8,,,,,,11,,6,9,5,5,8,13,,,,6,14,8,,8,6,,,
   5,5,,,,6,7,8,,,8,6,,,,,,11,19,11,23,23,23,,56,56,113,4,
   4,4,5,5,4,4,7,7,4,4,5,4,5,5,11,,4,5,5,,7,7,7,,15,,
   4,5,,5,,7,9,7,,,,,,13,,15,7,6,15,9,24,23,22,8,24,21,
   20,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,11,4,5,5,7,7,,,,,,
   4,5,,5,,7,7,7,,,,8,,,,6,15,15,7,6,23,67,24,7,22,20,
   67,5,4,5,4,8,6,8,4,5,6,4,6,6,,,5,6,12,14,7,14,14,
   18,,,4,6,,6,,7,16,12,,,,,,,,9,13,9,13,7,32,67,34,10,34,
   73,,4,5,4,4,4,7,4,4,5,4,5,5,,,4,5,5,,7,,8,11,,,4,5,
   ,5,,7,,7,,,7,8,,,,9,6,7,8,15,67,20,23,15,20,67,23,5,
   5,4,5,8,4,5,6,4,6,6,18,20,5,6,12,14,7,,,14,,,4,6,,6,
   ,7,14,12,,,,13,,,,7,9,13,10,9,67,,32,13,73,,67,7,6,8,
   7,4,10,8,4,8,8,,18,10,8,7,16,7,11,12,,,,4,8,,8,,7,
   12,7,,,,,,14,,9,15,15,8,9,47,,128,8,104,55,,4,5,7,4,4,
   5,4,5,5,11,11,4,5,5,8,7,7,8,,13,,4,5,,5,,7,,7,,,9,,,
   15,,8,9,8,9,7,20,22,67,6,67,23,24,5,8,4,5,6,4,6,6,
   14,,5,6,12,,7,,13,,,,4,6,,6,,7,,12,,,11,,,,,7,7,10,7,13,
   ,73,67,9,,67,32,7,4,10,8,4,8,8,,13,10,8,7,12,7,,,19,
   14,,4,8,,8,,7,11,7,,,18,12,,,,8,9,8,7,15,,55,47,15,55,
   ,47,6,9,11,6,11,8,,,9,11,10,,10,,,,16,,6,11,,8,,10,21,
   10,,,,,,16,,9,9,10,7,9,,,,10,,,,4,4,2,4,4,5,,3,3,4,4,
   4,4,4,,5,,2,3,,3,,4,4,4,,,4,4,,5,,15,4,4,15,4,15,16,
   15,4,15,15,16,4,4,4,4,,,4,5,5,5,5,,,6,8,,3,4,,5,,5,
   5,5,,,,6,,,,22,6,22,6,5,21,,16,5,16,,22,4,4,4,,8,4,5,
   5,6,5,6,8,8,,,3,4,,5,,5,6,5,,,6,,,,,22,22,4,4,3,21,
   22,16,5,16,,,4,4,,5,4,4,4,4,4,4,4,5,,,2,4,,4,,4,4,4,
   ,,4,4,,,,4,15,15,4,4,16,15,15,4,15,16,15,4,8,,5,4,5,
   6,5,,,6,,,3,5,,4,,5,6,5,,,,5,,,,4,4,22,22,5,,,16,3,16,
   21,22,,,5,4,5,6,5,8,6,8,,,3,5,,4,,5,6,5,,,5,,,8,,6,
   22,6,22,5,,22,16,5,16,21,,,6,8,7,8,7,5,6,11,,,5,6,,8,
   ,7,8,7,,,9,,,,,11,,23,7,5,97,,33,7,33,,,6,6,8,8,7,,,,,
   ,5,6,,6,,8,8,7,,,9,8,,,,23,7,11,,8,,,33,5,33,47,162,
   4,5,,5,,6,6,,,4,4,,4,,5,,5,,,5,5,,8,,5,22,6,5,22,,16,
   22,6,,22,16,5,8,5,6,,6,,,4,4,,4,,5,6,5,,,6,6,,,,5,22,
   4,3,4,22,16,22,20,,,16,8,4,7,7,,6,,4,5,,5,,4,7,4,,,,,
   ,6,,17,4,4,6,17,18,,,6,,18,,,,9,,,,4,,,6,,7,4,7,,,8,9,
   ,10,,10,9,7,6,16,,25,72,9,,,26,7,7,,8,,4,5,,5,,4,7,4,
   ,,,,,6,,7,5,4,5,5,18,,,7,,18,,4,8,,,4,,,5,,7,,7,,,,8,,
   32,,6,13,15,7,,,,45,5,47,72,,8,12,,4,5,,,,7,8,7,,,,9,,
   49,,9,9,16,7,6,72,,45,,47,,,11,,5,6,,6,,,9,,,,5,6,,7,,,
   7,5,23,7,33,97,41,,,33,,,5,,,8,,6,,6,,,6,,,,,7,,,,,,26,
   26,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,5,,4,
   4,4,4,15,15,15,16,15,16,15,15,,4,,5,,5,,,6,6,,,,3,4,
   22,5,20,,16,,4,22,22,16,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,6,
   6,,,,5,6,22,5,6,22,16,,22,22,,16,,,,,,,,,,,,,,,,,,,,,,,8,4,,
   ,,,,8,,5,4,5,7,7,18,,,5,,18,,,,,,,,10,,5,6,7,,15,,25,,
   13,72,,26,,,,,,6,,6,4,4,17,6,18,,,17,,18,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,4,,,,13,5,,15,7,45,,,6,34,47,72,,10,,9,,6,
   16,7,45,72,,10,34,47,,,,,,,,,,,,,,,,,,,,7,7,,,,,26,,26,,,,,,,,
   ,,,,,4,10,16,11,16,22,16,5,44,44,70,16,10,10,22,16,16,
   4,44,70,55,4,4,70,55,44,10,16,22,16,5,44,70,44,11,16,
   16,22,55,40,70,16,22,16,16,,,16,,16,,,16,,,16,22,16,,,
   70,55,40,,,,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,
   ,6,,,,9,,6,,,,9,,,,30,30,,,,30,30,30,30,,,,5,,6,6,7,6,
   7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,
   9,,6,8,,,7,,,,,,22,22,22,4,4,4,,22,22,22,6,17,,9,,10,,,
   10,13,8,9,,6,,8,,10,,,6,,9,8,,5,,,,,8,,,,12,,,5,,,10,,,,
   5,5,41,41,41,,,,5,41,41,41,,,9,,10,,,9,,16,,,6,,8,,10,,,
   6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,41,41,41,5,5,5,,41,41,
   41,5,5,4,7,7,4,6,7,7,5,5,4,5,6,8,7,,5,4,8,11,6,,
   13,,,,5,6,,8,,9,,10,11,,,,,20,,19,21,9,16,22,21,18,21,
   10,22,9,16,5,5,5,4,4,7,7,6,5,5,4,5,6,8,,12,5,4,8,
   13,6,,,13,,,5,6,,8,,9,,10,10,,,,20,,20,21,19,16,16,9,
   18,19,21,21,9,16,16,7,6,7,6,4,5,4,7,7,4,7,6,7,,,7,
   4,7,9,4,,7,7,6,8,7,6,,7,8,12,,6,6,,,,10,9,9,7,7,7,
   6,7,7,7,6,7,7,7,6,5,7,5,5,4,6,5,5,4,5,6,8,13,,5,
   4,8,,6,,,10,,,5,6,,8,,9,,10,,,,10,,,,10,21,16,9,16,19,
   18,18,19,16,16,9,7,7,6,7,8,7,7,4,7,6,7,7,14,7,4,7,
   7,4,,,9,8,6,7,6,,7,9,12,,6,8,,,8,10,10,9,7,7,6,7,7,
   7,7,7,7,7,6,7,7,5,4,7,7,7,7,7,6,8,13,,7,7,8,13,6,,
   ,,,,7,6,,8,,9,,8,11,,,10,,,,21,20,32,32,10,38,,10,21,
   10,32,32,5,7,7,5,5,4,5,6,8,10,,5,4,8,,6,,10,11,,,5,
   6,,8,,9,,10,,,,11,,20,20,10,10,9,22,16,18,21,19,21,16,
   9,22,7,4,7,7,4,7,6,7,9,16,7,4,7,,4,,8,6,9,8,7,6,,
   7,9,12,,6,,,,6,10,10,10,6,7,7,7,6,7,7,7,7,6,7,7,7,
   7,7,7,7,6,8,,,7,7,8,,6,,10,10,15,,7,6,,8,15,9,,8,10,,
   ,11,,,,9,21,32,10,32,,38,38,20,32,32,10,8,8,4,8,8,7,,
   ,8,4,7,,4,,8,8,12,9,8,8,,7,11,18,,7,8,,,8,9,10,10,
   11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,5,5,5,,4,3,4,5,4,
   ,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,22,21,4,,4,6,22,21,6,
   4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,,4,6,,8,,8,,4,5,,,
   5,5,,5,22,6,,4,4,21,22,6,21,4,,4,4,4,4,,6,3,3,3,3,
   3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,6,6,4,4,4,4,3,4,4,
   4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,,8,4,5,,5,8,8,,4,5,,
   ,5,5,,5,6,22,,4,4,22,21,6,21,4,,4,5,5,,5,4,5,5,4,,
   5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,8,8,5,5,6,6,6,5,5,
   6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,5,,4,,8,,5,4,,,,5,5,,
   21,22,4,,4,22,6,21,6,4,4,,7,4,4,4,4,3,,6,5,,,4,5,,,
   12,8,,5,5,,,,5,,7,,,31,5,4,8,7,8,,4,31,5,6,5,7,7,6,,
   7,,40,113,6,,,6,46,,,,6,,,,9,9,,79,21,7,,7,21,79,31,36,
   7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,4,,,,4,,5,5,21,22,4,4,,
   22,6,21,6,,4,4,4,4,3,,,3,6,6,4,4,,4,6,6,,3,,,,3,6,
   6,4,4,4,4,3,4,4,4,4,4,4,4,3,7,4,,5,5,,,8,6,,4,8,8,
   ,4,,,,4,,5,5,22,21,4,4,,6,22,21,6,,4,4,,,5,,,12,,5,,4,
   ,8,,5,5,,,5,,5,7,7,8,4,5,31,,,,8,31,4,5,,3,,6,6,4,4,
   ,3,6,6,,4,4,,,4,6,4,6,6,6,3,4,4,6,6,6,6,4,3,4,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,6,,,12,8,,4,,,,5,7,,5,8,
   8,31,4,5,,,8,8,5,31,4,,,5,6,,4,,8,,,5,,,6,7,5,,,,4,
   31,5,8,8,8,8,5,4,31,5,,5,,8,5,8,,,,,,,,,,,,,,,,6,,6,,,,
   8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,,4,,8,,4,,,,4,,5,5,
   21,6,4,4,,21,6,22,22,,4,4,,5,5,6,,5,5,,,5,8,8,8,6,
   5,6,6,6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,8,,4,5,,,
   5,5,,5,6,21,,4,4,6,21,22,22,4,,4,8,,,,,,,,,,,6,,,,,6,,,,,
   ,,8,8,,,8,12,12,12,8,8,9,9,9,8,8,8,8,9,9,9,,,,,,,,,,,,
   ,,,,,,,,,4,,,,5,5,,21,6,4,,4,21,6,22,22,4,4,,,,4,,7,5,
   7,7,5,4,31,,8,,8,31,5,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,7,
   ,8,8,5,31,4,8,,,8,4,5,31,6,6,,,5,5,,,,,,,5,5,6,,,,5,
   5,,,,,5,,5,,,5,,5,,,,,5,5,,5,22,22,43,4,4,4,8,43,22,
   22,21,21,22,4,4,4,5,22,21,21,4,4,21,22,22,22,4,3,4,
   4,22,21,43,22,4,4,3,21,22,22,21,3,4,4,5,5,4,21,21,
   22,8,4,22,22,21,4,22,22,43,21,22,22,4,4,4,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,
   ,,10,13,,22,,,,,,10,22,16,19,15,16,,,,,,10,10,12,,22,12,
   18,,31,,,,,,,53,34,10,13,105,46,,60,,,,,6,,,8,,8,12,,7,,7,
   ,,,10,7,17,18,11,13,,26,209,,,7,10,,,8,11,,,15,,,,,,46,
   35,,11,,78,35,81,78,,,,9,,,,,10,13,,,10,10,,19,12,,22,12,,
   ,,,20,,,,,10,16,101,22,,,,,30,,,,,,105,13,22,34,53,60,,46,,
   ,,,,6,,6,,,7,13,10,,,17,13,7,,,8,,,,,,,10,8,,,7,17,14,,
   12,,19,,,,36,45,9,,9,45,45,36,45,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   8,12,,7,10,7,,18,11,,7,,,11,13,,17,,,,7,9,17,,8,,,,,,24,,
   ,,81,78,,,,35,78,46,35,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,10,,12,,6,,,,,12,,,8,11,,,,,,6,7,,,12,,16,,,,24,,,,
   59,49,10,8,10,49,49,59,49,,,,,,,,,,,6,6,6,8,6,4,,,71,,,
   5,5,6,36,6,7,6,,,9,9,,,,63,44,7,23,5,58,163,21,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,6,6,6,8,6,,,,,,,
   5,5,6,20,6,7,6,,4,7,,,,,39,39,5,5,4,39,39,12,12,,,,,,,
   5,6,6,6,8,6,,,,,117,,5,5,5,32,6,7,6,,,6,,,,,44,63,23,
   7,5,98,77,21,12,,,,,,,5,5,5,7,5,,,,,,,5,4,5,18,5,6,5,,
   8,8,6,,,,29,29,,,5,29,29,11,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,8,10,10,10,8,,,,,,,7,8,9,35,10,9,8,,,11,,,,,,,
   32,9,6,134,,23,15,,,,7,7,9,9,7,,,,,,,6,7,6,33,8,8,7,,,,
   ,,,,,70,,,7,116,,22,13,,,,6,5,,,,,,,18,,,4,6,71,6,5,,,,7,,
   ,,,21,98,5,7,23,63,12,44,77,,,,,10,6,7,,8,20,,,5,5,,,
   4,7,6,,7,,8,,,,39,12,5,4,5,12,39,39,39,,,,9,6,7,,8,20,
   ,,5,5,,117,,6,6,,7,,8,,,,63,12,7,5,23,21,98,58,51,,,,,,,
   ,,27,,,6,10,,10,,,,,12,,,,,23,134,6,9,32,,15,,,,,,7,,,,22,
   ,6,4,6,,6,,,,7,7,,,,,13,51,4,5,5,51,13,51,51,,,,,,,,,5,
   5,7,51,7,,7,,,10,10,,,,64,,7,25,,,164,29,16,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,11,,,,,,,7,17,7,,23,84,25,
   ,,,,,,18,32,,20,,71,,,33,,,,,71,,,,,,44,44,71,,,,,18,25,71,,
   ,19,36,,,,51,,,,,44,,,,117,,71,44,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   5,5,,5,,,,,6,,,,,11,29,5,,,29,11,29,29,,,,,44,,7,5,,6,,7,
   ,,,14,11,,6,6,11,14,31,31,,,,,,9,6,,7,5,8,,,,58,21,23,
   5,7,12,51,63,98,,,,,,,,29,,,,,,44,44,,,,71,117,,,,,,8,6,,7,
   ,8,,,,40,12,10,6,10,12,40,40,40,,,,,,,11,,,,,22,116,7,,,
   70,13,,,,,,,7,7,,,,,12,44,5,23,7,77,13,98,63,,,,,,,,,,,,,,,,
   ,,,,,,8,,,,,40,,10,10,,,40,16,16,,,,9,,,,,22,,8,,13,,81,
   124,,,,,,,127,,7,17,7,,21,,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,29,31,19,22,19,41,19,40,,,,19,31,23,41,21,19,29,,,
   ,5,5,23,31,22,18,,,,5,52,32,22,24,,,,18,18,31,31,,,,29,
   29,21,,,,40,31,,,,41,,,,,,,,,,,10,,,9,,8,,11,8,10,8,,9,6,
   5,,11,10,6,,8,11,8,8,,,,,,5,,5,,6,10,8,,8,,10,,,,23,23,
   11,19,11,,,,23,56,56,113,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,8,8,5,6,6,5,6,5,5,6,7,8,6,8,4,16,,7,8,
   8,15,7,,13,,,,6,8,15,4,,7,15,10,,20,,,,,,,56,8,15,8,10,
   7,8,98,98,134,46,8,8,8,6,5,6,6,7,6,7,8,6,8,4,,17,
   7,8,8,13,7,,,,,13,6,8,20,4,,7,,10,16,,,,,,18,46,,15,7,
   8,7,15,10,56,134,46,,6,4,6,6,7,4,7,8,7,6,8,6,6,,,7,
   6,8,13,7,14,,15,,,8,6,19,6,,7,17,6,17,,,,,,,74,32,7,
   10,10,24,10,26,34,84,,74,8,6,8,8,6,7,6,7,8,6,8,4,,
   16,7,8,8,,7,,,20,,,6,8,,4,18,7,,10,17,,13,,13,,,134,46,
   7,10,15,15,8,7,,46,,56,6,6,4,6,5,8,7,6,8,6,6,15,,7,
   6,8,,7,,,,,,8,6,,6,,7,14,6,,15,,14,,,,,74,10,24,7,10,7,
   24,32,,74,32,5,4,4,5,7,8,7,7,7,4,8,10,8,7,8,9,7,
   10,9,10,,,7,7,11,4,,7,9,6,9,10,9,10,,,15,29,64,16,8,
   10,8,16,6,30,34,29,64,8,6,5,6,7,8,6,8,4,20,,7,8,8,,
   7,13,,15,,,6,8,,4,,7,,10,,16,15,15,,,,98,134,10,8,7,8,
   8,15,46,,56,98,6,7,8,7,6,8,6,6,,17,7,6,8,,7,,14,19,,
   ,8,6,15,6,,7,,6,,,13,17,,,,84,,24,26,10,7,10,10,74,74,
   32,34,5,7,8,7,7,7,4,10,9,8,7,8,9,7,9,10,11,,,7,7,
   10,4,15,7,10,6,10,8,9,9,,,,34,29,8,6,16,16,10,8,64,
   29,64,22,6,8,8,6,8,4,,,8,8,7,,8,18,18,20,,12,6,8,20,
   4,15,8,20,7,,,,20,12,,15,,154,7,7,8,7,8,7,158,,154,
   158,5,5,4,4,4,6,,6,4,7,,7,,6,,,,4,4,6,3,7,5,6,5,6,
   6,8,8,8,,,,21,5,22,6,6,22,5,16,21,16,,5,5,5,4,8,8,
   6,7,7,7,6,7,,7,,,6,5,,4,8,4,7,5,,7,,7,8,,6,,18,17,
   4,6,4,17,6,,,,18,4,4,4,,6,5,5,4,6,5,6,8,8,,7,4,4,
   6,4,,5,8,4,6,,6,,4,,,16,22,4,4,3,20,5,22,22,16,,,5,4,
   ,6,5,5,4,6,5,8,8,6,,7,4,4,6,4,8,5,,4,6,,6,,7,,8,
   16,,22,6,5,22,5,6,22,16,,22,4,6,,7,4,7,8,6,,6,,,,4,
   5,6,3,4,5,6,4,6,8,8,6,,,,,,5,22,22,4,4,3,16,21,16,
   21,5,5,4,3,4,5,4,6,5,6,,5,3,4,5,2,5,4,5,4,5,6,5,
   6,5,,,15,16,4,15,4,15,4,4,15,15,15,16,8,7,8,5,8,7,
   10,10,9,,10,6,,8,6,,7,6,8,10,,9,,7,,14,19,,19,8,5,,6,
   11,78,29,,,,6,6,6,,,9,,,,6,6,9,5,7,8,8,6,6,10,7,9,,,,,
   ,6,,78,7,15,5,33,78,33,54,5,7,,4,,7,,,8,5,5,7,4,6,
   6,7,5,8,8,7,7,,,8,,,4,6,17,17,6,4,18,,18,,7,8,5,6,,
   6,,,4,4,,4,,6,6,4,,6,8,6,,,4,21,16,4,3,4,5,22,22,22,,
   ,16,6,7,10,10,10,,,7,4,10,4,8,7,5,4,6,5,6,5,,,8,,
   17,6,6,,6,,6,17,,17,17,,,10,,,,8,6,10,5,10,7,8,6,7,9,
   6,10,,,,135,47,5,7,15,,17,6,33,,33,,,7,,,14,5,5,7,4,8,
   6,7,5,8,7,7,8,9,,9,,,4,5,5,7,7,5,18,,18,,8,6,,,6,8,
   8,5,7,7,10,6,9,10,10,8,,,,,,6,78,,15,7,5,33,54,33,78,
   8,,,,6,6,6,,,8,6,,10,,10,,,7,54,29,15,5,7,6,,78,78,,,
   29,,,6,6,8,5,10,7,9,8,9,8,10,10,14,,130,,78,5,19,8,
   11,,7,33,54,33,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,14,5,9,9,7,
   7,,7,,10,,,,,26,,,,7,,7,26,,,,5,,4,,7,8,5,,6,,6,,,7,21,
   16,6,5,22,5,6,22,,,22,16,8,4,,5,,4,6,,6,8,7,,,16,,20,
   22,5,4,3,4,,16,22,22,6,130,,10,8,,9,,9,,,10,54,29,11,
   7,,5,8,19,,,78,29,,4,6,4,5,5,5,5,5,,5,15,15,15,4,4,
   4,4,15,16,15,16,15,9,,,,14,,,,,,26,26,,,,7,7,,,,,,8,5,,7,
   ,7,14,,8,,18,7,5,7,4,5,5,,,,18,,9,,10,,10,,,19,,78,,6,
   7,5,15,,29,78,,6,8,6,,7,,,16,22,6,22,5,6,5,22,,16,22,
   ,8,6,8,,,7,78,33,7,5,15,6,78,,54,,,33,8,6,10,,,29,,,
   11,6,19,5,8,,19,,78,8,,,10,,33,,6,17,5,15,7,,135,47,
   33,7,,,29,78,7,15,5,78,6,,,19,,,,9,,,7,7,,,,,,,26,26,,,,,,
   ,,,,,,,,,,7,,7,,,,,26,26,,,40,55,115,16,22,16,,,,,55,70,
   40,22,16,16,,,,16,4,4,10,9,12,70,16,22,16,5,12,10,11,
   44,16,16,22,9,11,10,55,22,16,16,4,4,16,40,55,70,5,16,
   115,40,55,22,55,70,44,,16,,,,,,,6,9,9,,,6,,9,,,6,6,6,,,,
   ,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,30,30,30,,,,,30,30,
   30,,,,,,,7,10,10,,,,13,22,,,,13,10,15,,,,10,,,,,,,21,,15,,,
   10,20,,,,101,,34,10,,53,,,,,12,,140,103,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,6,9,,7,8,7,,,7,12,7,,,,12,7,,
   ,8,,9,13,,,,7,,,,11,24,,10,14,,,,,,,11,46,35,40,,,,11,81,
   40,46,,9,,,,,9,,12,10,,,15,26,10,7,13,,,,8,11,,,,,,13,,,,,
   8,,,,183,183,,12,8,,44,64,,,,17,,64,49,,,6,,7,15,,8,,8,,
   16,26,14,8,15,18,10,,,17,,,,8,,,,9,23,,9,,,13,187,,,,8,
   46,77,67,,,,,56,67,46,,9,,,17,,18,17,18,,27,26,15,,11,,
   16,19,11,,,,,16,,15,,,,21,11,,,,,,158,23,42,,,120,,,,11,95,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,14,,8,14,8,,
   21,,,8,,,10,,9,,,,,8,,15,,9,,,,,,,,187,,,,56,75,67,,,,,46,
   67,56,10,11,,10,10,12,,16,19,10,,15,14,12,,,17,,,,12,,15,
   ,,19,12,,,,18,,,,8,12,45,,74,,,,16,45,74,39,,,11,,10,,,,,
   11,,,10,,8,,,,,10,,16,,10,,,9,,,13,,,,10,10,125,47,97,,,,
   10,97,97,125,,,,,,5,,6,5,6,7,6,,4,,,,,6,,6,,6,8,6,5,,,,
   36,71,,23,7,44,63,12,,,,5,21,58,163,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,6,,,,5,5,5,6,5,6,5,5,,,,5,,5,,5,7,5,4,,
   ,,18,,,,,29,29,11,,,,5,11,29,29,,,,,5,5,6,7,6,5,5,6,,,,
   6,,6,,6,8,6,5,,,7,36,,117,7,23,63,44,12,,,,5,21,98,77,,
   ,,6,5,6,7,6,,4,7,,,,6,,6,,6,8,6,5,,,7,20,,,5,5,39,
   39,12,,,,4,12,39,39,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,
   7,8,7,,7,,,,,7,,9,,7,9,7,7,,,,37,,,,,,70,13,,,,7,22,,
   189,8,8,9,9,8,,6,,,,,8,,10,,10,10,8,8,,,,39,,,32,9,,,17,
   ,,,6,23,,215,5,6,,,,5,4,,,,,,6,,6,,,5,5,,,,32,71,5,23,
   21,58,98,,,,7,63,12,51,,8,5,7,,6,,,,5,,,,6,8,5,,7,,6,,,
   18,,5,29,11,29,,,,,29,29,11,9,6,8,5,7,,,,6,,,,,10,6,,8,
   ,7,,71,36,23,5,44,12,63,,,,7,98,77,13,,,7,,,,,5,,7,,7,,
   ,6,,,5,,21,,7,,13,49,,,,,,,13,49,,5,,,,,4,,6,,6,,,4,,,4,,
   20,,6,10,12,40,40,,,,10,40,12,40,5,,,,,,,8,,8,,,7,,,,,41,
   ,7,17,21,,,,,,7,39,84,,5,,,,5,,,,5,8,5,,7,,6,25,44,18,
   6,6,31,11,14,,,,,14,37,11,,,,,,7,,7,,,6,6,,,,45,,,28,29,,
   99,,,,7,64,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,4,,,4,,20,,4,5,12,39,39,,,
   ,5,39,12,39,,,,,,,,,,,,,,,,,,,,,,,,,,,9,5,5,8,,7,71,,18,7,
   5,98,21,77,,,,23,44,63,12,,,,,,,,,,,,,,,,,,,,,,,10,6,5,8,,7,
   ,,22,5,4,51,13,51,,,,5,51,51,13,,6,,,,,27,,6,9,16,,,,,,
   32,,23,134,4,,,,117,20,,5,7,12,63,51,,,,23,58,21,98,5,,
   4,44,25,17,,6,14,11,37,,,,6,31,14,11,,,46,,,7,17,39,,84,
   ,,,7,21,,,,,,,,,,,,,,,,,,,,29,,,10,16,,40,,,,10,40,16,,,,,,
   44,44,,,,,,,71,117,,,,,71,71,,,,,44,,44,,,44,,44,,,,,71,117,
   ,5,31,19,24,,,,5,22,52,32,19,31,18,,,,5,22,23,31,29,29,
   ,,,23,19,41,21,40,,,,22,19,19,41,,,,31,41,21,31,,,,,,,,,,,,
   ,,,,31,19,18,29,40,29,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,9,9,,,,,10,,,,10,22,16,,,,10,12,30,22,,,10,,,13,
   ,20,,,,,,12,19,,,,,101,,,53,,60,13,34,22,,,105,46,,6,,,8,,
   8,,,7,10,7,17,,,,7,,,8,,13,9,,,12,7,17,,,11,24,,11,18,,,,
   ,,,,35,46,78,,,,,81,78,35,9,,,,,10,,10,10,,22,12,31,,,,16,
   ,22,,16,10,,,13,22,,,,15,,18,,,19,12,,,,,,105,,46,34,13,
   10,,,53,60,,,6,,6,,13,10,13,7,,12,,,10,,,7,,,8,,,,7,,,,8,
   19,14,17,,,17,,,,,,45,36,45,9,9,,,36,45,45,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,8,,10,7,,7,,15,,,7,17,,8,,13,10,,,12,7,26,,,11,,,,
   ,18,11,,209,,,,78,81,35,,,11,,46,35,78,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,6,,12,,,,,6,,,12,,11,7,,,10,12,,,,8,
   24,16,,,,,,,,,,49,59,49,10,10,8,,59,49,49,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,6,6,6,,,,5,5,7,6,,,4,,,6,6,,,,,,,7,
   8,,5,18,,71,,,63,44,12,5,23,7,,21,98,77,5,5,5,,,,5,5,
   6,5,,5,5,,,5,5,6,,,6,,,6,7,,,18,,,,,29,29,11,5,,,,11,
   29,29,6,5,,,,,6,6,6,,,5,,,,,,,,6,,6,5,,8,7,117,,32,,,98,
   21,77,23,5,7,,44,63,12,,7,,,5,,,4,,7,5,,,6,6,8,,,6,8,
   6,7,10,10,7,,20,,,,12,39,39,5,5,4,,39,12,39,7,,,5,,5,,
   ,7,,,,6,6,8,,,6,8,6,6,9,10,9,71,36,,,,12,63,51,23,7,
   5,,58,21,98,,,8,7,8,7,,,6,,,,4,,,,7,,7,,,,,,,29,,,,16,40,
   10,,10,,40,,16,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,,5,6,5,,,7,6,,,18,,,29,
   11,29,,5,,,29,29,11,,,,7,5,,,6,6,8,,,6,8,6,9,10,9,6,,
   20,117,,,21,58,98,7,23,5,,63,12,51,,,10,,,,9,7,11,,,7,
   9,7,,11,12,11,,37,,,,13,81,,,,8,,,22,124,,7,,,,6,6,8,,,
   6,8,6,8,10,10,8,,20,,,,12,40,40,10,10,6,,40,12,40,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,5,,,4,,,,,7,10,7,,,,,,,51,,,,29,164,7,
   ,28,,64,,16,,,5,5,5,,,4,7,5,7,8,6,7,25,18,44,,,11,31,
   14,,6,6,,14,11,31,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,6,9,6,,,8,7,,71,36,,,58,21,163,7,5,23,,63,44,
   12,,,,6,,6,,,8,7,,,20,,,39,12,39,5,4,5,,39,39,12,,,,,5,,,
   ,,,,,,,,84,23,7,7,17,,,,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,7,8,,,22,,,,,51,51,13,4,5,5,,13,51,51,,,,,,51,,,,,,
   ,21,7,7,17,,127,,39,7,8,,,36,71,,,,77,98,13,5,7,23,,
   12,44,63,,9,8,,,33,,,116,22,,,7,,,,70,13,10,9,,,35,,,134,
   23,,32,6,9,,,,15,,27,,,,,,,15,6,32,9,,23,134,,19,,,,,70,,
   13,7,,,,22,116,,,,,,117,71,,,,,,,44,44,,,,,44,44,,,,,71,,71,,
   ,71,,117,,,,,44,44,,,,,,,,,,,,,,,,,,,,,,,29,29,23,18,52,,19,
   41,21,40,22,31,22,,19,19,41,31,18,32,,41,21,31,5,5,,
   31,19,18,5,,22,23,31,,19,31,24,,,,29,40,29,3,4,4,4,3,
   4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,
   ,8,,,,,,19,19,19,19,8,8,19,84,8,84,8,19,4,4,4,3,4,4,
   4,4,4,4,4,4,6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,
   ,,,19,19,19,19,8,8,19,84,8,84,8,19,4,4,3,3,3,3,4,4,
   4,4,4,4,6,,4,4,4,,4,,6,,,,4,4,7,4,,4,8,6,8,,6,,,,,
   10,16,16,10,10,10,16,10,10,10,10,16,3,4,3,4,4,4,4,6,
   4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,
   ,24,19,19,24,8,8,19,8,8,8,8,19,4,3,4,4,4,4,6,4,6,
   7,8,,4,6,7,10,6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,24,
   19,19,24,8,8,19,8,8,8,8,19,3,4,4,4,4,4,4,4,4,8,,4,
   4,4,8,4,7,7,,,,4,4,,4,,4,,6,,8,8,,,,,10,10,10,10,10,
   10,10,10,10,10,10,10,4,4,4,4,4,4,4,4,8,,4,4,4,,4,7,
   5,,9,,4,4,7,4,9,4,,6,,,8,,,10,,10,5,5,10,8,8,5,8,8,
   8,8,5,3,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,
   6,8,9,8,,,,,,,19,9,9,19,42,42,9,9,42,9,42,9,6,6,7,6,
   7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,19,9,
   9,19,42,42,9,9,42,9,42,9,4,4,4,4,4,8,,3,4,5,6,5,6,
   7,,11,,4,4,6,4,8,7,6,7,6,6,,,,7,,67,5,7,67,7,8,23,
   8,9,8,8,19,4,4,4,4,,,4,4,4,6,4,6,,,8,,3,4,6,5,11,
   5,6,7,6,6,,,,,,67,7,23,15,8,8,19,8,7,7,23,6,4,4,4,,,
   4,5,4,8,5,6,,,15,,4,4,6,8,15,6,7,8,8,7,,,,,,16,9,19,
   19,6,9,15,9,9,6,9,9,4,4,,,4,4,4,6,4,6,6,,,,4,4,5,
   4,7,4,6,6,6,,7,,,,,15,23,19,11,8,23,6,7,8,9,21,6,4,,
   ,4,4,4,7,4,,11,,,,4,5,6,4,6,5,8,7,6,9,9,,,,,19,19,
   15,16,9,9,9,6,6,9,22,16,9,,5,4,4,10,5,,6,,,,4,8,6,
   4,10,6,10,8,6,,4,,,7,,15,33,7,67,12,34,8,12,8,8,13,
   28,,7,9,4,9,6,8,9,,,,4,7,6,7,15,6,7,8,8,,,,,,,20,,,
   22,11,46,,13,15,10,137,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,4,,5,,8,,,,4,4,6,4,12,4,6,7,,,4,,,7,,11,19,6,11,23,
   21,6,9,8,21,9,5,4,9,5,11,,,,,4,4,6,4,13,4,6,7,,11,7,
   ,,,,16,15,9,11,9,22,16,9,9,22,22,4,,5,10,,,10,,5,4,
   10,4,8,5,6,8,7,6,7,,,7,,67,7,8,16,34,13,36,8,12,40,
   8,7,,,11,,,,,11,,6,15,8,,12,12,12,6,,,9,,23,18,10,42,,,
   8,12,14,63,17,13,6,6,,11,,7,6,9,6,,8,11,7,,8,6,,,6,,
   27,12,5,30,30,15,10,27,27,10,7,10,6,,,,6,7,7,6,15,8,
   12,9,,6,11,,,21,,31,90,16,31,,,13,16,11,35,46,,,52,,6,
   6,7,7,16,7,6,9,,6,,,,,,31,22,,31,15,12,,11,12,12,58,10,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,15,8,,8,,11,15,,14,,,,,43,,,,,
   ,8,11,52,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,6,5,,,7,,
   11,6,6,15,21,9,5,21,23,23,7,7,7,4,,5,,8,11,,5,,,10,,
   11,9,16,16,22,22,4,22,9,22,9,9,7,,,6,,,12,,,,11,,31,8,
   14,89,35,16,10,,40,,11,12,,5,7,8,11,11,,,,,,16,8,36,16,
   13,8,7,40,34,8,40,6,,,,,,16,,,,,43,13,,99,,11,13,,,,,,,7,
   8,7,,,,,,30,5,10,22,15,7,10,10,30,23,23,11,,12,,,,,,,28,
   15,10,,12,14,9,,63,14,15,16,,10,10,,,9,,,8,8,,39,10,10,,
   ,12,10,190,,7,,,11,,23,14,15,28,63,12,10,,27,,14,9,9,,,,
   ,28,53,18,23,14,,10,14,15,12,,8,,,,,61,8,,20,15,11,,,,
   13,46,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,23,14,,,,,11,,8,,,,,,,,,,,,
   ,19,33,,41,18,16,18,30,41,44,45,18,46,17,9,4,6,9,26,
   35,26,19,9,17,18,24,30,6,9,4,30,41,33,44,31,18,18,16,
   25,30,19,25,22,6,6,9,22,6,19,25,30,10,6,24,17,18,22,
   25,22,21,35,46,23,22,10,9,4,4,4,3,4,4,4,4,4,4,4,4,
   6,,,4,4,6,8,9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,19,19,19,
   19,8,8,19,84,8,84,8,19,3,4,4,4,4,3,4,4,4,4,4,6,,
   11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,19,
   19,8,19,19,19,8,19,8,19,19,4,4,4,4,3,4,4,4,4,4,6,,
   11,4,4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,19,
   19,8,19,19,19,8,19,8,19,19,3,3,3,3,4,4,4,4,4,6,,8,
   4,4,6,5,4,8,,5,,,4,4,6,6,,4,7,6,7,5,,8,,,,10,10,10,
   10,10,10,10,10,10,10,10,10,4,4,3,4,4,4,4,4,4,,8,4,
   4,4,6,4,6,,7,,,4,4,,4,,4,,6,,6,,8,,,,10,10,10,10,16,
   16,10,10,16,10,16,10,3,4,4,4,6,4,6,7,,8,4,6,7,,6,8,
   ,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,24,24,8,19,19,24,8,
   19,8,19,24,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,
   10,7,,6,,9,,,,8,,,9,8,24,24,8,19,19,24,8,19,8,19,24,
   4,4,5,4,5,4,,6,4,5,4,,4,8,,8,7,9,4,5,6,4,,4,5,6,5,
   ,,6,9,,8,10,10,10,10,7,7,10,9,7,9,7,10,4,4,4,4,4,,,
   3,4,5,6,5,5,,,7,,4,4,6,4,,7,6,7,5,5,,,7,,,19,11,15,
   23,6,5,67,9,6,7,7,67,4,4,4,4,,,4,4,4,5,4,8,,7,12,,
   3,4,6,5,,5,5,7,6,7,,8,11,,7,23,15,67,7,5,7,67,7,6,
   8,23,15,4,4,4,,,4,5,4,8,5,4,,,13,,4,4,6,8,,6,6,8,6,
   10,,,6,,,15,16,19,19,4,9,16,9,16,6,19,19,4,4,,8,4,4,
   4,7,4,,,5,,12,4,4,6,4,,4,6,6,6,,,5,8,,7,7,67,67,5,
   7,23,15,8,5,8,19,11,4,,,4,4,4,10,4,,,10,,,4,5,8,4,,
   5,6,7,6,,,4,15,,10,19,19,16,9,9,19,19,6,4,9,15,16,,
   9,5,4,4,11,5,7,,7,,8,4,8,6,4,,6,10,8,6,7,,7,10,,,7,
   67,15,33,6,33,15,8,7,12,7,67,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,5,4,7,7,8,,,,17,,4,5,8,4,,10,10,10,6,8,,,15,,,,
   22,20,,12,12,61,10,8,13,11,39,4,4,,5,,,6,,7,4,4,6,4,,
   4,6,7,6,6,,4,,,7,5,67,15,6,23,19,11,8,7,23,6,11,4,,
   5,,,8,,13,4,4,7,4,,4,6,7,,11,,5,,,4,9,16,19,4,19,15,
   16,9,9,9,9,11,7,5,9,,11,8,,5,4,10,4,,5,6,8,,6,,4,,,
   8,33,15,15,6,33,7,67,12,6,34,8,16,,,,,,13,6,11,6,6,,
   8,6,,12,11,,8,,,18,12,31,31,16,,,39,12,22,58,10,44,8,,,,
   ,7,6,11,6,,8,9,7,10,8,,10,12,,12,12,27,12,7,7,12,27,
   27,11,30,5,30,,7,,17,7,9,9,4,,6,11,8,8,9,,4,,,11,12,
   61,20,12,,,22,11,8,46,,24,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,13,,8,
   6,,6,,,11,,,,,9,,,,,39,31,,16,12,31,,21,12,9,168,,8,,,10,
   ,8,,13,52,,,,,,,9,,,,,,63,12,13,,,,11,6,,8,,,11,,16,10,,,,,
   ,,63,,,,9,,48,9,,,,4,,4,,5,6,7,,8,,7,,,7,6,15,11,6,19,
   6,11,23,23,21,6,15,9,4,,5,,8,11,,,7,,,10,4,19,16,16,
   15,9,11,9,19,22,16,16,,,,6,,,11,,,,,19,15,28,23,14,18,
   10,42,,53,,8,36,,5,,8,10,,,,10,,8,6,15,67,7,7,8,16,34,
   33,13,36,16,,,,,,,,,,,,,,,,,,,,,,,10,7,6,6,,10,11,,12,7,12,
   27,11,12,5,30,30,7,15,10,22,,12,,,,,,,8,31,31,,16,13,32,
   ,90,46,,42,11,9,,,15,,,10,22,22,143,10,8,,,143,39,8,,6,
   ,10,,,8,14,89,31,8,90,16,31,,35,,13,32,,7,52,,11,9,
   168,31,12,22,,31,15,,12,,39,,,,,,,,,,,,,,,,,12,,,,24,22,,8,
   12,20,,32,10,12,61,,12,,99,43,13,,,,,,,8,43,,,,,,,,,,,,,,,,
   23,,9,,,,,11,9,,19,33,18,27,4,16,6,7,24,27,45,,46,33,
   16,,18,19,44,45,,19,19,33,,41,46,18,16,,7,27,33,26,24,
   6,4,16,18,46,17,18,9,4,14,19,9,4,17,18,46,30,14,41,
   33,,9,25,30,31,35,26,50,9,30,19,4,3,4,4,3,4,4,4,6,
   4,6,7,,,4,6,7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,
   19,19,8,24,24,19,8,24,8,24,19,4,3,3,3,3,4,4,4,4,4,
   4,,,4,4,4,8,8,,,8,6,6,4,4,6,4,6,8,7,4,7,8,,,6,6,6,
   4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,6,4,6,7,,,4,
   6,7,,6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,19,19,8,24,
   24,19,8,24,8,24,19,4,3,4,4,4,4,4,4,4,,,4,4,4,8,4,
   5,7,7,10,,4,4,,4,,4,,6,,8,,,,9,9,8,8,8,8,5,5,8,10,
   5,10,5,8,4,3,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,
   8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,
   4,4,4,4,4,5,,,4,4,5,6,6,5,6,6,9,,4,4,8,5,8,6,7,4,
   7,6,,,,,7,6,8,8,6,10,10,8,6,10,6,10,8,6,6,5,6,5,6,,
   ,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,10,7,7,
   7,7,7,7,7,7,7,7,7,7,4,4,4,5,5,,,4,4,7,6,7,8,,,7,,
   4,4,8,6,8,7,,7,6,4,,,,,,67,7,13,,8,6,,7,7,7,7,67,4,
   4,4,4,,,4,5,5,4,4,6,,,7,,4,4,8,7,8,7,6,6,8,7,,,8,,,
   ,13,,13,6,7,67,7,8,7,74,7,5,3,5,,,4,6,5,9,6,5,,,7,
   8,4,3,5,5,8,4,6,5,9,5,,,6,8,8,6,6,4,4,5,6,6,6,6,
   5,5,5,4,5,,,4,4,4,7,4,10,10,6,,6,4,5,6,5,,4,8,5,8,,
   ,,8,,7,13,,67,7,7,74,7,7,6,7,32,13,5,,,5,3,5,5,4,,
   5,6,7,7,4,6,9,5,6,6,9,5,5,,,,8,7,7,4,4,6,6,6,5,5,
   5,5,6,6,6,,,7,5,6,10,7,8,7,8,,7,6,5,8,5,10,5,10,5,
   8,,,,10,7,,7,73,7,73,20,,6,21,8,21,13,32,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,7,,8,
   7,,,4,4,,4,6,4,8,6,7,7,,,,9,8,7,67,7,13,74,32,13,7,
   7,35,7,7,5,,6,5,,6,7,8,5,3,6,5,8,4,5,5,,6,,,6,6,6,
   6,6,5,4,5,6,6,6,6,5,5,4,,7,,10,,,,7,5,10,6,,7,8,8,,
   5,,,,9,,73,7,6,8,,13,32,21,20,85,8,7,,,9,,,,7,6,8,5,,
   4,7,8,9,,,,68,8,,8,24,8,14,42,,,8,12,49,7,9,6,12,,8,
   9,7,4,9,5,9,4,9,7,,4,,,10,6,10,7,7,4,7,7,7,7,7,7,
   7,5,7,10,8,53,22,8,6,6,7,12,12,,9,10,9,,,,,16,11,43,
   10,7,,31,15,25,13,28,14,10,,13,,7,6,8,8,19,7,6,7,,,,,
   45,,16,,11,28,10,13,9,,13,12,30,35,10,,,8,6,11,8,,9,
   11,11,6,6,,,17,16,,,9,10,28,19,11,,22,17,30,10,68,7,7,
   7,8,,7,4,13,8,,,,,,,,6,,,,,,,8,7,,,,8,6,,,6,6,30,,,8,,,,,,
   ,7,,,,,,,,,,,4,,5,,7,7,7,,8,,,,8,9,13,7,13,7,32,7,7,
   35,74,35,8,13,6,5,7,6,,5,6,,,,8,7,7,4,5,6,6,6,5,4,
   5,5,6,6,6,8,157,,,11,,11,,,,,17,10,10,9,9,18,20,20,63,
   46,,15,12,,7,,5,9,10,,,10,,9,8,6,32,7,13,8,7,85,,8,
   34,8,6,235,,,10,,,,,,9,6,,231,,9,8,,,,,,,7,10,,,,9,11,11,
   7,4,7,7,7,5,7,7,7,7,7,7,,10,,,,12,18,,10,10,12,,11,
   11,26,63,36,11,9,19,10,7,,,9,9,,7,7,7,34,21,21,7,,84,
   22,8,34,7,,,157,14,32,9,9,10,10,36,11,12,,26,63,11,26,,
   ,13,,10,8,27,24,8,12,42,8,10,16,8,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,6,10,,231,9,6,,,,,,,,7,8,,,,,9,,,,,,,7,,,,,,,,,,,7,,
   4,21,40,20,5,6,6,7,23,28,14,40,17,19,7,4,6,5,24,20,
   18,4,5,18,40,23,18,6,7,4,7,20,21,24,19,6,5,6,33,18,
   58,33,7,6,6,5,5,6,58,26,18,7,6,23,18,40,7,,42,17,30,
   54,20,5,7,5,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,
   ,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,19,19,8,19,19,19,
   8,19,8,19,19,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,
   ,4,6,10,7,9,6,8,9,8,,,,,,,8,19,19,8,24,24,19,8,24,8,
   24,19,3,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,
   9,,12,,,8,,,9,,84,8,8,84,19,19,8,19,19,19,19,8,4,4,4,
   4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,
   84,8,8,84,19,19,8,19,19,19,19,8,3,4,4,4,4,4,6,5,7,
   4,4,6,,4,,8,6,,,4,4,5,6,,4,8,6,8,,5,7,,,,10,10,10,
   10,10,10,10,10,10,10,10,10,4,4,5,4,5,4,,5,4,5,4,,4,,
   8,6,,9,4,5,8,4,8,4,6,6,6,,,5,9,7,,9,7,7,9,10,10,7,
   10,10,10,10,7,4,4,4,4,4,8,,3,4,5,,5,,7,,,,4,4,8,4,
   7,7,7,7,4,,6,6,11,8,,21,6,6,23,11,11,19,6,15,6,15,
   23,4,4,4,4,6,6,4,4,4,,4,,,6,,,3,4,6,5,7,5,4,7,5,,,
   6,7,,,23,6,19,8,11,15,23,6,11,5,67,7,4,4,4,,11,4,5,
   4,,5,,9,9,,,4,4,6,8,10,6,7,8,5,,11,,6,,,22,16,9,9,
   11,16,15,16,16,4,19,19,4,4,,6,4,4,4,,4,,,6,,8,4,4,5,
   4,7,4,5,6,8,,7,6,12,,,8,19,23,8,15,67,7,5,11,7,67,
   5,4,11,,4,4,4,,4,,,7,,,4,5,8,4,4,5,5,7,4,,,6,13,,,9,
   9,15,9,16,19,19,4,11,9,16,9,,10,5,4,4,,5,,4,,,10,4,
   8,6,4,8,6,,8,4,,6,,8,10,,13,36,8,34,16,67,7,7,16,6,
   15,33,6,7,,6,,6,,9,11,,52,5,10,,7,11,8,7,9,8,,11,,10,,
   ,12,,,15,31,31,22,12,39,9,168,,6,6,,,6,,8,,,,5,6,,6,8,
   10,10,11,6,,12,12,16,52,,,13,16,,31,31,90,8,32,14,89,
   35,4,4,,5,,8,6,,11,4,4,7,4,7,4,8,7,,,5,5,,12,,8,23,
   7,7,67,67,5,7,15,23,15,6,4,,5,,,8,,15,4,4,10,4,10,4,
   4,7,,,10,6,,,,9,15,19,6,19,16,9,9,16,19,19,4,,5,,9,10,
   ,,5,4,11,4,8,5,4,8,7,,7,6,,8,,34,8,7,12,67,15,33,6,
   16,33,15,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,11,7,6,,6,12,
   8,10,7,10,,8,10,,8,,15,10,5,30,30,27,12,11,22,7,12,7,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,5,4,7,7,11,8,4,8,,,,11,17,,
   ,46,,,11,22,20,,12,24,12,61,8,,,6,6,,6,19,11,,,8,,6,6,,
   ,,,8,10,,42,23,18,14,36,15,28,53,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   7,6,,10,12,12,12,15,15,,,,,,,,8,,,,43,,13,43,,99,,4,,4,,
   5,,7,,,6,6,,7,,7,7,5,9,67,15,6,23,67,19,11,6,,4,,5,,
   8,,,8,6,,13,,6,19,9,9,16,19,4,19,19,15,16,16,7,,,9,,,,
   ,11,,13,,12,9,12,,31,31,16,,168,,39,21,,5,7,8,9,,11,
   10,8,,,12,7,33,8,15,15,6,33,67,7,67,7,12,,,,,18,,,,,11,
   9,,,,23,9,,,,,,10,7,8,,,9,,,,30,5,12,27,27,12,7,7,30,
   12,27,11,,,,8,,,,,10,12,12,,20,22,8,,61,,24,32,10,,,,,13,
   ,39,8,8,,,22,10,143,,10,22,143,,7,10,,17,,13,11,12,10,
   61,20,12,,39,,22,8,,,,,,,,,,,,,,,,,,6,13,,,58,10,,12,39,31,
   ,16,44,12,31,22,11,,,46,,13,,32,31,16,,42,8,31,90,,,,,
   9,48,,,,,,,63,9,,,,,12,63,,,,,9,,13,,,,,,,,,,,,,9,17,25,41,
   18,9,6,30,24,44,35,18,30,33,16,4,4,19,27,45,26,9,19,
   33,18,27,46,4,16,4,30,41,17,26,31,6,18,9,,46,33,,16,,
   14,19,19,,33,,46,7,14,27,33,18,16,18,46,24,45,,50,19,
   7,19,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,8,
   7,,6,10,9,10,10,8,,,9,,24,19,19,24,8,8,19,8,8,8,8,
   19,4,3,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,
   ,6,,9,,8,10,10,,,,8,8,8,8,19,19,8,24,19,24,19,8,4,3,
   4,4,4,4,4,4,8,7,4,4,4,,8,,,6,6,6,4,4,8,4,6,8,,4,,,
   8,7,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,7,
   10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,
   8,8,19,19,8,24,19,24,19,8,4,4,6,4,6,4,,7,4,6,4,,4,,
   ,8,6,6,4,6,8,4,6,4,7,4,7,,,7,6,6,6,5,6,6,5,6,6,
   6,5,6,5,6,6,4,4,4,5,5,8,,4,4,7,7,7,,,,,,4,4,8,6,,
   7,8,7,6,6,10,10,7,8,,32,13,7,74,13,7,67,7,7,8,13,,
   4,4,4,4,10,10,4,5,5,6,4,,,7,6,,4,4,6,7,7,7,6,6,8,,
   ,6,7,,9,74,7,67,7,7,13,,8,13,6,,13,5,3,5,,5,4,6,5,
   6,6,,,,8,7,4,3,4,5,7,4,6,5,6,6,5,,4,6,6,6,6,5,5,
   4,6,6,6,6,5,4,4,4,5,,6,4,4,4,,4,,,4,,7,4,5,4,5,8,
   4,8,5,6,,,8,7,,8,7,67,,6,13,,13,6,7,7,67,7,5,5,,5,
   3,5,6,4,,,5,7,7,4,6,9,5,6,6,6,5,5,,,5,7,8,7,5,5,
   6,6,6,4,4,5,4,6,6,6,10,,7,5,6,,7,,,,,,6,5,6,5,,5,
   11,5,,8,7,8,8,10,,13,32,6,,8,73,7,8,7,20,7,73,10,,,7,
   ,12,,,9,,13,6,6,6,8,16,6,8,10,,,11,,7,,39,9,,28,13,10,
   ,11,11,9,10,68,11,8,5,8,8,6,,,,22,53,6,6,9,,13,10,10,
   ,8,,6,10,11,,,31,15,10,,7,11,43,16,8,9,11,,4,5,,7,,,6,
   ,7,4,4,7,4,9,4,6,6,10,10,6,6,,6,7,6,,13,8,,67,7,7,
   13,74,7,13,5,,6,,,9,8,7,5,3,5,5,7,4,5,5,,5,6,6,7,
   7,6,6,6,4,5,4,6,6,6,6,5,5,4,8,7,,,10,7,,7,5,10,6,
   9,7,,8,8,7,8,,,7,9,,6,7,20,73,7,73,20,8,,6,8,,,,,,,
   10,5,,7,,6,10,,6,11,8,,,11,16,11,,10,19,28,,9,9,11,35,
   10,10,,,,9,8,7,4,6,5,11,4,7,7,10,6,6,10,7,6,7,7,7,
   4,7,7,7,7,7,7,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,8,4,7,6,10,6,11,7,9,6,,9,27,10,156,,,
   8,42,14,8,24,8,,9,8,27,7,8,6,10,10,6,6,12,,,,11,14,,,,
   ,,,,,,7,9,8,,,,7,4,27,8,7,7,10,8,11,7,,14,,,,,,,,,6,,9,,
   ,,,4,,5,,7,10,7,,8,7,8,,,,8,13,7,7,67,7,13,74,,32,13,
   7,,5,6,6,,5,5,,6,6,7,8,7,5,4,6,6,6,5,4,5,4,6,6,6,
   ,156,,9,7,,9,,11,,,10,9,8,8,8,24,8,14,42,27,,,,,7,8,5,
   ,10,,11,,,,20,7,73,8,7,6,8,,73,13,32,7,7,142,,,39,16,,,
   ,,9,9,,,,8,7,,,,,,10,7,6,12,,7,8,9,11,7,4,7,7,7,4,7,
   7,7,7,7,7,,10,,,,14,14,,16,11,7,,10,15,8,31,43,14,10,
   18,,10,,,8,,,21,7,7,84,7,7,7,84,34,21,7,34,10,8,10,
   53,22,13,9,11,11,16,43,10,7,,,31,15,8,,8,13,,16,10,68,
   ,11,11,28,10,13,11,9,,9,10,,,,35,10,,9,9,10,28,19,10,
   11,,11,10,12,142,14,10,15,31,8,7,10,,18,16,11,43,7,7,,
   ,6,9,,,,,,,,,6,,,,9,7,,,,,,,8,,,8,,7,,,,,9,9,,5,18,33,20,
   5,7,4,7,25,28,20,40,18,21,6,4,5,4,28,14,18,5,4,21,
   40,20,20,5,6,4,7,20,19,23,19,4,5,7,40,17,19,40,7,4,
   4,4,5,4,18,40,20,7,4,20,21,40,7,33,18,19,20,18,17,5,
   7,4,4,4,3,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,
   ,6,,9,,,,8,,,9,9,42,42,9,9,9,42,19,9,19,9,42,3,4,4,
   4,4,4,4,5,6,7,4,4,5,,6,6,5,8,,,4,4,6,5,7,6,,4,,,6,
   7,,9,8,6,10,10,6,8,8,10,6,8,6,8,10,4,4,4,4,4,4,6,
   6,6,4,4,6,6,4,6,6,6,,,4,4,6,6,,4,6,4,6,6,6,6,,,,
   10,10,10,10,10,10,10,10,10,10,10,10,6,6,7,6,7,5,,8,
   6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,42,42,9,9,
   9,42,19,9,19,9,42,5,5,4,7,7,6,,4,5,6,11,6,,6,,,,4,
   5,6,4,7,5,6,5,6,6,7,7,,7,,42,16,12,31,9,10,67,7,8,
   8,7,67,5,5,5,4,7,7,4,7,7,6,4,5,,6,,,4,5,8,6,11,6,
   6,5,11,6,,5,,,7,31,12,67,7,10,7,67,8,9,8,31,12,7,6,
   7,,6,5,5,4,7,5,5,8,8,,,5,6,7,7,,5,11,7,7,,7,,,12,
   12,8,31,39,39,8,30,12,7,11,6,39,39,5,7,,5,5,5,4,6,
   4,7,7,6,,,4,7,6,7,9,4,11,6,6,,6,,,,8,7,67,67,10,7,
   31,12,8,10,7,40,16,7,7,,7,6,7,,6,,7,,,,5,5,7,4,8,5,
   7,6,7,8,8,5,,9,,39,39,12,30,30,39,39,6,8,10,8,31,9,
   10,6,4,4,10,6,9,5,9,,,4,7,5,4,7,4,9,7,5,9,5,9,,7,,
   7,,12,46,7,46,12,7,9,5,7,,7,6,8,5,8,6,6,7,10,,,6,,
   6,6,56,6,6,,9,,9,,,,11,9,,205,16,8,,23,30,49,7,,,,5,9,
   9,,,6,,,,4,6,7,4,11,7,7,6,6,8,10,8,,13,,47,34,13,,17,
   ,111,6,9,15,11,41,5,7,,6,,6,11,,,5,5,6,4,9,4,6,5,8,
   8,6,4,,9,8,10,67,12,9,31,42,16,7,7,39,8,16,7,8,5,6,
   ,7,,,7,6,11,7,,6,7,6,,7,,6,,,6,30,12,39,8,39,8,31,
   10,30,12,12,14,9,6,10,9,10,,,6,4,10,4,12,6,5,4,6,5,
   6,4,,12,8,46,12,12,7,46,7,,5,7,88,9,12,,,10,,,,8,7,9,
   5,12,6,8,7,10,9,8,7,,11,,24,81,23,21,39,,95,9,9,130,
   11,95,,6,,,,5,5,6,4,11,4,6,5,7,6,6,7,,6,,31,19,11,
   20,20,31,19,7,9,19,6,19,7,9,,,5,7,7,4,11,5,6,5,9,7,
   9,4,,13,53,,111,13,17,,47,34,6,9,,11,23,8,,,,6,6,6,,
   11,6,7,,9,,9,,,7,,23,205,8,16,9,,12,18,13,73,23,,,6,6,
   8,5,11,6,10,8,10,8,9,7,,9,,,95,23,39,21,24,81,9,9,
   11,8,205,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,
   7,,6,8,5,,6,,5,,9,7,9,12,16,8,42,8,16,39,31,31,9,12,
   7,7,,5,,7,7,,7,11,,,,8,39,31,11,8,12,14,12,39,6,11,
   31,6,,,7,8,,9,,8,,29,8,,23,141,9,26,8,63,,57,,23,23,,
   6,6,7,9,10,9,10,,,8,7,12,,9,7,9,12,88,46,5,46,12,,,,,
   18,,,,,,47,63,,,,12,75,,,,,,7,5,,6,,5,,17,8,20,11,19,9,
   31,6,19,19,20,19,13,12,,9,,9,,,57,,8,81,142,,9,16,23,
   28,66,7,16,,7,,7,,,,,8,,,67,8,27,14,101,67,6,30,,8,6,7,
   ,,7,105,23,81,8,66,9,142,,29,28,16,23,8,9,,,18,8,205,
   81,24,9,39,23,,24,9,,95,7,,,10,73,23,,9,49,8,205,,21,
   30,,23,,19,,11,23,34,47,9,17,13,,104,6,,111,,,,,,,,,,,,,,,
   12,,,,11,41,,,,,13,,43,,,23,,15,,,,,9,14,,39,43,70,24,15,
   32,6,20,24,26,27,,40,43,32,,14,39,30,27,,39,39,43,,48,
   40,14,32,,20,24,43,24,19,6,15,32,70,40,34,70,10,6,18,
   39,12,6,34,70,40,19,18,48,43,,10,26,28,23,27,37,52,12,
   19,39,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,
   12,,,8,,,9,,84,8,8,84,19,19,8,19,19,19,19,8,4,4,4,6,
   4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,10,10,,,
   ,8,8,8,8,19,19,8,24,19,24,19,8,6,6,7,6,7,5,,8,6,7,
   5,,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,42,42,9,9,9,42,
   19,9,19,9,42,4,4,4,4,4,6,,3,4,5,5,5,6,6,,7,,4,4,,4,
   ,7,,7,,4,,,,12,,23,7,9,21,5,6,21,15,7,11,6,23,4,4,4,
   4,,,4,4,4,4,4,8,,6,7,,3,4,,5,,5,,7,,7,,6,,,12,21,9,
   21,9,6,6,23,11,5,11,19,8,4,4,4,,11,4,5,4,5,5,6,7,
   7,10,,4,4,,8,,6,,8,,7,11,,,,,22,9,22,22,4,16,22,16,9,
   11,9,9,4,4,,6,4,4,4,7,4,6,6,5,,,4,4,,4,,4,,6,,,6,6,,
   ,7,9,21,23,7,6,19,8,11,6,15,23,8,4,11,,4,4,4,7,4,,
   11,6,,,4,5,,4,,5,,7,,9,9,6,,,13,22,22,22,9,16,9,9,11,
   4,16,15,9,11,11,5,4,4,,5,7,6,7,,,4,8,,4,,6,,8,,7,6,
   7,,8,,8,40,8,40,7,36,13,16,6,16,8,34,,6,9,6,9,7,6,
   6,12,,,6,7,,,,8,,10,,,12,,,,,12,,,14,10,18,14,23,8,28,
   53,15,6,6,7,7,8,,,,11,,6,8,,6,,,,,,8,12,12,,15,,,14,12,
   ,10,15,63,28,9,23,14,27,4,4,,5,,6,6,,,4,4,,4,,4,,7,,,
   6,6,,8,11,7,23,8,8,19,23,8,15,6,67,7,7,4,9,5,11,,6,,
   ,4,4,,4,,4,,7,,,7,8,,,6,9,22,9,6,9,15,9,16,16,19,19,
   6,7,5,,10,10,7,,5,4,,4,,5,,8,,4,,6,,10,8,40,8,13,8,
   36,8,34,16,7,67,7,12,,,11,,,,,,,4,,6,,10,,,6,,,14,16,13,
   46,11,,,,15,20,,61,8,,7,8,,,,7,6,,6,,8,,7,,6,8,,,8,,23,
   23,7,10,10,10,15,22,11,30,5,30,6,7,,,7,,,6,,6,,9,,9,
   11,6,,52,16,12,58,12,11,,,15,31,10,31,22,12,7,21,,6,6,,
   ,,6,,9,,8,,12,,,15,35,46,,16,13,16,,31,,31,90,11,11,,6,
   6,,6,,9,,,,6,,6,,15,,,11,16,,10,14,35,89,12,31,8,40,,7,,
   ,7,,6,,9,,,9,,,,,11,,,,,,14,23,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,4,,5,,7,,8,6,6,,11,8,8,8,8,8,23,7,7,67,19,67,5,9,
   ,4,,5,,8,,,8,7,,15,15,6,9,9,9,15,19,6,19,9,16,9,9,,,,
   ,,,,,,,,,,,,,,,,,,,,,,5,,8,,9,10,10,,,10,8,13,34,12,8,7,
   12,67,28,15,33,8,,,,,,,,,,,,,,,,,,,,,,,,7,,6,,11,,11,,10,7,
   15,27,10,5,30,30,10,27,12,27,,,,,,,,,,,,,,,,,,,,,,8,12,,,11,
   ,12,10,10,,10,8,39,,190,,8,,,,,,,,,,,,,,,,,,,,9,7,,,15,10,
   137,46,13,,,11,22,11,20,,15,,,,15,63,17,,12,8,10,,42,13,
   23,18,14,,,,14,15,14,,9,10,12,,16,28,15,63,,,,,,,,,,,,,,,,,,
   ,11,8,,,,,43,,52,,,11,,13,,,99,,43,13,,22,19,25,24,6,22,
   18,10,41,26,35,25,22,17,9,6,18,9,44,35,46,22,9,17,25,
   41,30,18,9,6,10,24,19,44,21,18,6,22,18,30,33,18,16,4,
   6,9,19,4,33,18,30,30,6,41,17,25,16,,46,31,45,26,23,
   19,30,9,4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,
   ,6,,9,,,,8,,,9,8,24,24,8,19,19,24,8,19,8,19,24,6,6,
   5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,
   10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,5,5,8,,4,4,7,
   ,7,7,8,,8,,4,4,8,6,9,7,,7,,,7,7,8,7,,35,8,7,35,7,
   13,32,7,13,13,7,74,4,4,4,4,7,7,4,5,5,,4,8,,,9,,4,4,
   7,7,8,7,,6,,,,8,,,6,35,7,32,7,13,7,74,13,7,7,67,7,5,
   3,5,,6,4,6,5,,6,6,6,6,7,8,4,3,6,5,7,4,,5,,,6,,6,7,
   7,6,6,5,5,4,6,6,6,6,4,5,5,4,5,,8,4,4,4,,4,10,10,6,
   ,8,4,5,6,5,7,4,,5,,,7,8,6,,,7,32,74,7,7,67,7,7,13,
   13,,6,5,6,,5,3,5,,4,,5,6,6,6,4,6,6,5,6,6,,5,,,,5,8,
   7,8,5,5,6,6,6,5,5,4,4,6,6,6,10,9,7,5,6,,7,8,7,8,,
   10,6,5,8,5,9,5,,5,,,5,,,,,8,34,8,85,7,32,13,7,8,8,6,
   ,7,7,,5,,,,9,11,,13,4,5,6,,10,4,,7,,,,,8,,10,8,,42,10,
   8,24,12,8,,8,27,16,8,5,,,10,,10,,14,157,6,9,6,8,32,,,
   10,,,9,10,,,,63,11,11,,12,10,36,10,26,9,9,26,4,5,,7,,
   6,8,,8,4,4,,4,,4,,6,,,4,6,,7,8,7,74,7,7,67,,6,13,7,,
   13,8,5,,6,5,,9,7,8,5,3,6,5,7,4,,5,,,5,9,7,7,6,6,6,
   5,5,5,6,6,6,6,4,4,5,,7,10,,10,9,,7,5,,6,,7,,8,,,,8,,,
   ,85,8,13,21,32,6,,8,7,73,7,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,7,12,,11,9,7,4,9,5,11,4,,7,,,4,,6,4,6,7,7,5,7,7,
   7,7,7,7,7,4,7,10,8,,45,,,,7,16,12,,7,,,9,6,,13,19,30,
   35,9,13,,28,13,10,10,,11,12,6,,,8,5,8,8,16,6,,9,,,,,
   22,53,12,28,14,31,25,15,10,,7,10,11,43,13,,,8,5,11,8,
   17,9,,11,,,8,,,8,157,,15,20,63,20,9,18,9,12,10,10,46,6,
   ,8,16,7,8,6,,9,,,8,18,,,,,,,,,,9,,7,,,,,6,17,10,10,10,,
   9,,,68,12,,,,,,,,,9,,6,7,,231,,4,,5,,7,,7,,,6,,,7,8,7,7,
   6,7,,13,8,,67,67,7,7,,5,8,6,,5,,,9,6,8,7,8,5,5,6,6,
   6,4,5,4,5,6,6,6,8,,,,11,,,,11,,,,30,10,11,22,,10,19,
   28,68,,9,17,,7,,5,,,10,10,7,,10,21,13,,21,6,7,20,73,
   32,7,73,8,10,,,,,,,,,,,7,,,,,,,,,,,,7,,,,9,9,8,9,7,5,7,7,
   7,4,7,7,7,7,7,7,,,,,,,,,,,,,,,,,,,,,,,8,,,8,,22,8,21,,7,
   7,21,34,34,7,7,84,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,49,7,
   ,8,,8,42,14,9,8,24,12,30,13,235,11,9,11,63,26,12,11,,
   19,10,10,36,7,6,,,,,,,,,,,7,,7,,,,8,,,,,,6,,7,,,9,,8,,,231,
   ,9,6,,5,58,,23,6,7,6,7,23,24,30,26,42,18,7,6,5,5,
   28,20,54,5,5,18,33,20,18,5,7,6,7,23,58,24,17,6,6,7,
   40,18,21,40,6,4,6,5,4,4,21,40,18,7,6,20,19,33,6,40,
   20,19,14,18,18,4,7,5,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,
   6,7,10,5,9,6,8,9,8,,,,,,,19,9,9,19,42,42,9,9,42,9,
   42,9,5,5,4,7,7,6,,4,5,6,,6,,5,,9,,4,5,6,4,7,5,5,5,
   4,6,8,8,,,,31,9,8,39,16,16,42,8,12,9,12,31,5,5,5,4,
   8,8,4,7,7,6,4,6,,6,9,,4,5,11,6,8,6,4,5,,6,,6,,,9,
   39,8,42,7,16,12,31,9,16,10,67,7,7,6,7,,7,5,5,4,7,5,
   6,7,7,,,5,6,6,7,,5,11,7,6,,7,,,,,6,11,12,12,14,31,8,
   11,31,8,39,39,5,7,,6,5,5,4,6,4,7,7,6,,,4,7,6,7,8,4,
   ,6,5,,6,11,,,9,7,40,31,8,12,67,7,10,16,7,67,10,7,7,,
   7,6,7,,6,,6,11,,,5,5,7,4,6,5,6,6,5,8,8,7,,,,12,12,
   8,10,31,39,39,8,14,30,12,30,10,9,6,4,4,9,6,6,4,6,,,
   4,7,5,4,8,4,10,7,4,6,5,6,,,,5,46,9,88,12,,7,9,12,7,
   12,46,8,6,8,5,8,6,9,7,9,,,6,,8,9,18,6,9,,8,,9,,,,18,
   9,,39,,23,81,9,24,95,8,205,24,11,7,6,6,,,9,,,,6,7,10,
   5,7,7,7,7,6,9,10,9,,,,28,16,9,,142,81,66,8,23,105,23,
   29,5,7,,6,,5,8,,,5,5,6,4,7,4,5,5,7,7,6,6,,,11,8,31,
   7,8,67,67,10,7,12,31,12,9,7,8,5,7,,7,9,,7,6,,7,,6,
   5,6,,7,,7,,,8,10,8,39,6,39,12,30,30,31,39,39,8,6,6,
   9,10,10,12,,6,4,10,4,8,6,4,4,9,5,9,5,,,12,88,9,7,5,
   ,12,46,7,12,46,12,7,,,9,,,,7,7,9,5,10,6,7,7,10,9,8,
   9,,,,30,,8,,205,,49,9,23,73,23,21,11,5,,17,,5,5,6,4,8,
   4,5,5,7,6,6,7,,,,19,13,6,19,19,19,31,9,12,20,11,20,
   7,6,,,6,8,8,5,7,6,9,7,6,7,10,6,,,,13,73,9,12,,205,
   16,8,23,,23,18,7,13,,,5,9,9,53,,4,5,,6,,6,,,11,,11,47,
   6,34,13,,17,23,,111,9,29,,6,7,8,5,8,6,8,8,7,6,9,7,,,,
   ,23,8,,63,141,26,9,23,,23,57,,7,12,9,7,12,6,19,,13,,
   11,57,,,,13,,,,,,41,11,43,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,
   6,7,5,,6,11,6,,,7,8,7,10,7,67,12,9,31,67,42,16,8,8,
   7,12,5,,7,6,,7,11,,,,6,39,30,7,12,39,8,39,39,8,31,11,
   9,,,7,8,,10,,10,,,11,11,8,24,9,81,23,21,39,205,,95,9,,
   6,9,7,10,9,10,9,,,7,5,7,46,7,12,12,7,46,,7,,9,,,,,11,,
   ,,,,9,14,,,,23,15,,,,,,7,5,,6,,6,,,11,19,6,31,7,19,11,
   20,20,19,31,19,9,,8,,7,,,,,6,,17,,13,34,9,47,111,11,23,
   104,6,,7,,,,,6,30,27,101,14,,8,67,,8,,67,7,9,7,,,11,15,
   11,,6,111,13,17,,41,47,34,9,8,6,,,56,7,,,30,23,205,8,
   16,,9,,49,8,,,12,130,11,,9,95,23,39,21,95,24,81,9,,,,7,
   16,16,28,23,142,9,,,8,81,66,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,
   75,,,,,47,63,,12,34,26,48,14,10,6,19,24,30,27,70,28,43,
   32,6,15,39,26,27,37,12,39,43,70,24,40,15,32,6,19,48,
   34,24,23,6,14,10,,40,43,,32,,18,39,39,,43,,40,20,18,24,
   43,70,32,70,40,19,27,,52,39,20,39,8,8,5,6,6,,,4,5,5,,
   5,7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,103,13,9,47,13,9,
   53,9,9,6,23,,8,8,8,6,,,5,6,6,,5,8,,9,,,4,5,8,5,7,5,
   8,7,8,,,9,,,,47,9,53,8,9,23,,6,13,7,,23,6,4,6,,8,5,
   6,4,,6,5,9,9,9,10,5,4,4,7,10,4,6,7,,,,,4,10,10,7,7,
   7,7,6,7,7,7,7,4,6,6,8,6,,9,8,8,6,,5,11,11,6,,8,5,
   6,6,6,10,5,8,5,9,,,8,8,,10,8,53,,7,23,,23,7,9,8,53,
   9,6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,,5,6,,,6,10,9,
   10,7,7,7,7,7,6,6,4,6,7,7,7,,11,5,4,4,,5,7,6,7,,7,
   6,7,4,4,8,4,10,7,6,,,,7,,,13,109,7,,6,50,8,7,9,13,8,
   50,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,6,,11,,41,,8,,,6,
   11,,,9,8,,,11,,15,,,16,10,,,25,130,10,11,10,23,28,8,6,,
   5,,8,8,,,8,8,9,6,,5,9,7,,,,8,,,7,7,,23,6,,53,9,8,23,
   47,9,13,6,,6,7,,9,9,10,6,4,7,6,10,4,6,5,,,,,9,9,6,
   7,7,6,4,6,7,7,7,7,7,7,6,,5,,,,9,,5,4,,4,,5,6,5,,,,6,
   ,9,,,7,8,13,50,8,50,13,6,,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,7,8,6,7,7,8,
   8,7,8,7,6,7,11,7,223,14,,9,9,6,29,9,6,,11,,,6,,17,
   13,20,65,10,9,,58,13,25,24,,12,12,9,17,,7,5,7,7,13,6,
   6,,,,,6,14,223,29,,12,58,25,13,10,,9,12,20,65,24,11,,7,
   4,7,4,,6,8,7,,,,10,27,7,79,,7,10,56,19,12,14,8,8,12,
   8,42,9,9,10,7,,10,6,18,9,15,,,12,,,,10,,,,,,,,10,,,,,4,
   27,7,7,7,7,8,,,,13,,,,,7,,,204,10,,,7,,,,8,,6,,5,,5,,,,7,
   ,9,10,6,23,9,9,53,9,13,47,,103,13,9,9,6,10,6,,7,8,,,
   6,10,9,10,4,6,7,7,7,7,6,7,6,7,7,7,7,79,,10,7,,,,8,,
   11,,12,8,12,8,14,10,19,56,42,,7,8,,5,,7,11,,,10,7,,8,
   13,8,50,7,8,7,6,,50,13,109,9,7,,,,,,,,,,7,,,,,10,,,,,,,,
   5,6,,,5,7,7,8,7,6,8,7,8,6,7,7,7,7,8,8,,11,,,,13,12,
   ,10,25,,,10,16,11,,130,,14,,9,,,,8,9,,8,24,9,50,9,9,9,
   50,117,8,24,117,,,,,41,11,10,23,25,10,130,10,,,28,,16,11,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,18,,,14,16,,11,,10,,,10,25,
   130,9,7,,,10,,,,,,160,,7,7,10,,,,,,,,,,10,,10,,,10,,,,,,,7,,
   ,7,26,26,27,6,7,4,7,19,26,25,87,37,28,7,6,6,6,26,
   35,43,7,6,28,87,27,26,6,7,6,7,27,26,23,25,4,6,7,87,
   26,26,87,7,6,5,6,7,6,26,87,26,7,5,27,28,87,7,26,37,
   25,25,43,27,7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,
   4,5,4,4,4,4,4,,,4,,,,4,22,22,4,4,,4,4,4,22,22,4,4,4,
   ,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,22,
   22,4,4,,4,4,4,22,22,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,
   3,3,3,3,3,,4,4,3,,,16,16,16,16,3,15,16,3,3,3,15,16,
   3,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,
   22,22,4,,4,22,22,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,
   3,4,4,5,4,3,4,4,4,5,5,,22,22,4,,4,22,22,4,4,4,4,,,
   3,4,4,4,4,5,3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,26,,25,23,
   4,7,,5,4,4,25,23,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,
   3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,16,15,3,16,16,16,
   15,3,3,15,3,16,4,4,4,3,,,4,,3,2,3,3,4,3,3,3,,3,4,
   4,4,4,,16,3,4,15,4,3,16,3,3,4,4,15,,3,5,5,,5,,4,3,
   5,3,5,4,4,4,4,3,4,4,,4,,,5,4,22,22,5,,5,5,22,4,22,,
   ,5,,,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,7,4,23,25,,26,4,
   5,25,4,23,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,
   4,22,22,5,,5,5,22,4,22,4,,,,3,4,4,3,4,4,5,4,3,4,4,
   4,,5,,22,25,4,23,,25,22,4,4,7,5,,,5,,3,3,4,4,5,4,4,
   4,,4,,,5,24,,41,4,15,22,5,5,,5,4,5,15,22,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,18,5,5,,,,23,,21,,17,,
   23,4,4,19,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,4,,3,4,4,
   ,3,,15,3,3,15,15,3,15,16,15,16,3,15,4,3,4,4,,4,3,,
   4,4,4,4,,15,4,3,16,3,4,15,4,4,3,3,16,4,,,3,,,4,,,,5,
   ,22,4,5,,7,4,22,25,25,,4,26,,4,4,4,4,4,6,6,3,,,16,
   3,15,16,3,3,16,15,16,3,16,15,,24,,,4,,,,,,23,4,23,,19,
   4,23,,,31,19,,,3,4,4,,,5,5,,22,4,5,,5,4,22,22,22,5,5,,
   ,4,,,,5,5,,22,5,5,,5,5,22,15,15,4,4,26,4,4,,,5,5,,
   22,4,5,,5,4,22,22,22,5,5,,3,4,4,18,4,,32,4,4,15,12,
   3,18,,6,12,4,15,4,4,4,,,16,12,6,28,4,12,16,4,4,3,,
   16,3,5,,,79,5,,55,4,4,55,,9,5,9,79,5,,,79,5,,55,4,4,
   55,,9,5,9,79,4,,,23,4,23,,19,,31,19,,4,23,,,21,,23,4,
   19,,19,17,4,,23,,,,,,,,,,,,,22,71,16,117,16,,16,22,44,44,,
   16,71,11,4,16,3,4,10,10,55,22,4,10,55,10,11,3,4,16,
   22,44,,44,117,16,16,,9,40,10,14,4,3,16,22,4,3,11,14,
   71,22,16,117,71,16,4,16,11,117,10,9,40,4,22,22,4,4,4,,
   ,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,22,
   22,4,4,,4,4,4,22,22,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,
   4,4,4,3,4,,,4,5,,5,22,22,,4,4,22,22,4,4,4,,4,4,,,4,
   4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,22,22,,4,
   4,22,22,4,4,4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,3,3,3,3,
   4,3,3,4,,4,3,,,16,16,16,16,3,16,15,3,3,3,16,15,3,4,
   4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,4,9,79,
   5,4,5,136,9,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,
   55,,55,,4,9,79,5,4,5,136,9,4,4,,3,,,3,,,3,3,3,3,3,3,
   3,2,4,4,,3,,,3,15,16,16,3,16,16,16,3,3,15,16,3,3,4,
   4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,22,4,22,4,,
   4,4,22,22,4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,
   4,22,4,22,4,,4,4,22,22,4,,,,,,,3,3,3,3,4,3,3,3,4,4,,
   4,17,,4,32,6,16,4,12,,18,3,4,12,16,4,3,,,4,,3,2,3,3,
   4,3,3,3,4,3,,4,4,,4,18,4,15,4,4,4,18,4,4,4,15,4,,4,
   ,,3,4,4,4,4,4,4,3,5,3,,4,,,5,22,25,23,4,,25,23,4,4,
   7,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,
   3,5,,24,,5,22,15,5,4,47,4,5,5,22,15,,3,4,4,4,4,4,4,
   3,5,24,,5,,,,23,,,23,31,,23,4,4,19,,19,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,3,,4,,4,3,3,,3,,3,,,3,15,3,15,3,15,3,16,16,16,
   16,15,3,4,4,4,4,,3,3,,,3,4,,4,15,4,16,3,3,4,15,4,4,
   3,16,3,,,,4,4,,5,,5,,,5,22,4,,5,7,4,23,25,25,,26,4,,
   3,4,4,5,5,,5,5,,5,22,4,,5,5,4,22,22,22,5,,5,,18,,,5,,
   ,,,,23,4,,21,19,4,23,,,17,,18,4,4,5,5,,5,5,,5,22,4,,
   5,5,4,22,22,22,5,,5,,3,,,,4,,,16,4,16,,3,4,15,12,12,
   4,18,6,3,3,,,3,,,16,3,16,15,3,3,15,16,16,3,15,16,4,,
   4,,,4,,5,22,4,25,4,23,,7,25,22,4,,4,5,,5,22,15,41,4,
   4,15,22,5,5,5,,5,,,,,,,,,,,,,,,,,4,,,,5,22,25,4,4,26,,7,
   4,22,25,,4,,21,23,4,,21,,17,18,,23,4,,,,,,,,,,,,,,,21,23,,
   4,20,,20,19,4,23,,22,,55,44,16,,16,22,117,,159,55,9,10,
   4,16,3,4,12,159,10,22,22,71,16,117,40,16,,16,4,13,71,
   12,11,3,16,4,16,71,11,9,4,16,3,22,4,3,10,55,9,22,16,
   44,,55,4,9,40,11,11,67,12,22,4,22,4,3,,5,4,4,3,5,4,
   4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,22,22,4,,4,4,
   4,4,22,22,4,,,3,3,3,3,3,,4,4,6,6,2,3,3,3,4,3,3,3,
   3,4,4,,4,6,6,4,4,4,4,3,4,4,3,3,3,4,4,,5,4,4,3,5,
   4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,22,22,4,,4,
   4,4,4,22,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,,,
   ,7,,3,3,4,4,5,4,4,4,4,5,3,,4,,,30,5,,,4,5,30,4,4,
   4,8,8,4,3,,4,,4,4,,4,3,3,3,3,4,2,3,3,4,4,3,,,4,4,
   3,16,4,4,15,16,3,3,3,15,4,4,4,,3,4,,,6,6,4,3,4,4,
   6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,
   4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,4,4,16,3,4,4,15,
   3,16,3,3,15,4,4,,,,,,6,4,3,4,4,6,3,4,4,3,5,4,,18,5,
   5,5,7,5,5,12,,4,4,5,12,5,5,4,,,6,6,4,3,4,4,6,3,4,
   4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,20,6,3,
   3,3,3,4,3,3,3,4,4,4,,,6,6,4,12,4,4,,12,4,3,3,6,6,
   6,3,6,,4,3,4,4,6,4,4,4,,4,,,6,25,25,,5,16,16,6,5,,
   5,5,6,16,16,6,,4,3,4,4,6,4,4,4,,4,,,6,25,25,,5,16,
   16,6,5,,5,5,6,16,16,6,4,6,4,5,6,4,7,5,6,,5,,,,,5,,,,
   18,,5,5,5,20,,,4,4,6,5,6,6,5,5,6,5,,,,,,,5,,,20,5,,5,
   5,22,,,3,,4,,3,4,4,,3,3,,,4,4,3,3,4,4,15,3,3,16,16,
   15,4,4,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,
   3,4,4,4,20,,4,4,,3,,,,6,6,4,3,6,6,6,3,4,12,12,,4,4,
   ,4,,3,5,5,5,,4,,,4,4,22,22,4,4,4,,,4,22,22,6,,,,7,7,,
   ,,,5,5,,,20,5,5,,,18,,,4,4,3,3,,,4,6,6,4,3,6,6,4,3,
   4,4,4,4,6,6,,5,,5,,4,,,4,5,,,4,5,4,30,30,4,8,8,5,5,
   5,,4,,,4,4,22,22,4,4,4,,,4,22,22,4,4,,18,5,5,5,5,5,
   5,12,4,4,,7,12,5,5,4,,4,,,4,30,8,8,4,30,4,5,5,4,,,,
   4,,,30,4,,,4,4,30,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,20,20,4,
   4,,20,18,16,18,,4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,,4,20,
   20,11,4,6,4,4,11,22,22,20,20,10,6,4,4,4,11,20,20,3,
   4,22,22,43,22,3,4,4,4,22,22,43,22,3,4,4,9,10,10,9,
   3,3,3,4,4,4,10,22,22,4,4,11,20,20,6,9,22,22,10,22,
   22,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,
   5,,5,22,22,,4,4,22,22,4,4,4,,4,,5,4,4,3,5,4,4,4,4,,
   5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,22,22,4,,4,4,4,4,22,
   22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,,,,3,4,4,
   4,4,4,4,3,4,,6,5,5,,,25,23,23,,4,22,25,4,4,5,,7,3,4,
   ,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,22,4,22,,4,
   4,4,22,22,4,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,
   ,22,4,22,,4,4,4,22,22,4,4,3,6,6,4,,,3,3,4,3,3,3,3,
   2,4,,4,3,,,3,16,15,16,3,16,16,16,3,3,16,15,3,,,,,,5,
   4,4,4,4,5,3,4,3,6,,4,5,24,,5,4,47,22,5,15,,5,5,4,
   15,22,5,4,4,,,4,3,3,3,3,4,2,3,3,4,,3,4,4,,4,4,18,
   15,4,4,18,4,4,4,4,15,4,3,4,,,4,4,4,4,5,4,4,3,,,,4,,
   ,5,9,79,55,4,,55,,4,5,9,79,5,4,,,4,4,4,4,5,4,4,3,,,
   ,4,,,5,9,79,55,4,,55,,4,5,9,79,5,,,3,3,3,3,4,3,3,3,
   4,,4,4,4,,18,,18,16,12,4,32,6,4,3,4,15,12,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,24,5,,,,,23,,31,23,23,,
   4,4,23,,21,4,,4,,3,4,3,,,3,3,,,3,3,15,15,3,16,16,3,
   16,16,16,16,3,4,3,,4,,4,5,,5,5,5,,5,4,22,,4,4,22,4,
   22,22,4,,4,4,18,,4,3,,,,3,,,4,4,15,32,4,6,16,4,12,12,
   ,16,3,,4,,4,5,,5,5,5,,5,4,22,,4,4,22,4,22,22,4,,4,4,
   ,,,,5,,,,,4,23,,23,21,23,4,,,31,,23,4,3,3,,,3,4,,4,4,
   15,18,4,4,15,4,4,4,4,18,4,,5,,5,,5,,,4,23,26,,4,22,
   4,25,25,5,,7,3,,3,,3,,,3,16,15,16,3,15,3,16,16,3,16,
   16,,4,4,,,4,5,,22,4,25,23,4,,7,25,23,4,,,,,,,,,,,,,,,,,,
   4,5,,5,15,22,,5,5,22,15,5,5,4,47,4,4,,,5,,22,25,4,
   26,4,,7,4,23,25,,4,23,,23,4,,,23,31,21,,23,4,,,,,,,,,,,,,
   ,31,,23,,4,,21,23,23,4,23,,22,71,16,13,16,4,3,4,10,
   44,10,16,71,71,,16,16,22,44,,55,22,22,,55,44,71,16,,16,
   4,44,10,10,13,3,16,4,55,9,10,16,4,16,3,22,22,16,71,
   16,71,4,3,13,71,16,4,16,71,13,10,55,9,22,4,22,5,,4,
   3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,22,22,4,
   ,4,22,22,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,4,
   3,4,,,,5,,7,,,30,5,4,8,8,4,4,4,30,5,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,
   5,5,22,22,4,4,,22,22,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,
   3,4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,
   4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,22,22,4,4,,
   22,22,4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,
   8,8,4,5,30,,,4,4,30,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,
   3,3,3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,,5,8,8,30,4,5,,
   ,4,4,5,30,4,,,3,4,4,3,4,4,5,4,3,4,4,4,7,5,,,,4,30,
   5,8,8,4,4,5,4,30,3,4,4,5,4,4,4,5,4,6,25,25,6,,,,,,,,
   ,,,4,4,,,,4,4,5,4,4,4,5,4,6,25,25,6,,,,,,,,,,,4,4,,,,4,
   ,3,,4,4,3,,4,4,3,,4,4,4,4,3,3,16,4,4,15,15,16,3,3,
   ,4,4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,
   18,,6,4,,,,4,,6,6,5,5,5,5,7,5,5,12,12,,4,4,,4,4,3,
   4,6,6,4,4,,4,4,4,16,3,3,4,4,15,15,3,16,3,4,18,,,6,
   6,,,,,4,4,20,20,18,4,4,,,16,20,18,,4,4,,,4,6,6,6,4,4,
   5,5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,,4,5,5,12,12,
   5,5,7,3,4,4,,4,4,,4,4,3,16,3,4,4,15,15,3,3,16,4,4,
   3,20,6,4,6,6,4,3,12,4,4,,6,12,4,3,3,4,6,,6,16,16,,
   5,5,16,16,6,6,5,,5,4,6,,6,16,16,,5,5,16,16,6,6,5,,
   5,4,6,20,6,6,4,12,3,4,4,,6,3,4,12,6,6,,,5,5,,,,18,
   20,,5,5,6,,,,5,5,,,20,18,5,,5,,,5,,5,,,22,20,5,5,,3,
   20,20,22,4,4,3,4,43,22,22,20,20,22,4,4,3,4,43,22,22,
   4,4,20,20,11,10,4,6,4,4,22,22,11,11,4,4,6,20,20,10,
   9,6,4,4,3,4,3,22,22,20,4,3,22,22,20,3,9,10,11,10,9,
   10,4,4,4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,6,,
   6,,5,,,6,,51,29,5,,6,6,6,5,51,29,5,4,6,6,5,,6,,,,4,
   5,6,4,5,6,6,5,4,5,6,5,7,7,,51,29,6,,6,29,51,5,5,6,
   6,,4,4,,3,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,4,
   22,22,,5,5,5,22,4,22,3,6,4,4,,4,,4,3,3,3,3,4,2,4,3,
   ,4,3,4,4,4,,3,16,4,15,4,16,3,3,3,4,4,15,6,4,6,4,6,
   ,,3,3,4,2,3,3,4,3,3,3,3,3,,3,,15,16,3,16,16,15,16,
   3,3,16,3,15,,,6,,,7,6,5,6,4,7,4,6,5,6,5,4,5,,5,,6,,
   5,29,51,,6,6,6,51,5,29,,4,,,5,4,4,4,3,5,3,5,4,4,4,
   3,4,,4,,5,,4,22,22,,5,5,5,22,4,22,4,3,,,4,4,4,3,5,
   4,5,4,4,4,4,4,,5,,,55,4,55,,79,9,5,4,9,5,79,4,,,3,
   3,3,3,4,3,4,3,,4,,4,4,18,,6,28,12,16,4,16,,3,4,4,
   12,15,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,55,4,55,,79,9,
   5,4,9,5,79,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,
   5,18,5,,,,,23,21,,19,23,,4,4,20,20,,4,,3,,3,6,4,,4,3,
   4,,3,,3,15,3,15,16,15,3,16,15,16,3,16,4,4,,4,,3,4,,4,
   ,5,5,,4,22,4,,4,22,4,22,22,4,4,,3,18,,6,4,,4,,4,,4,,
   4,15,4,32,6,15,4,12,12,,3,16,,3,6,4,4,6,4,6,3,,,3,
   16,16,15,3,16,3,15,16,3,16,16,4,,,,,4,,,,,4,23,21,,18,
   23,4,,,17,21,,6,4,3,4,,4,4,4,,4,15,4,18,4,15,4,4,4,
   4,4,18,,6,,6,,7,7,,5,29,6,,6,29,5,51,51,6,6,,4,,4,,
   5,5,,4,22,4,,4,22,4,22,22,4,4,,4,3,4,18,4,,4,32,4,
   15,12,18,3,,6,12,4,16,4,3,5,,,5,79,9,79,5,55,4,,9,4,
   ,55,4,4,,,12,16,,18,3,16,12,4,4,4,6,32,5,,,5,79,9,
   79,5,55,4,,9,4,,55,4,,21,,4,23,,,18,17,19,,4,23,,23,,,
   23,4,,19,19,31,4,,23,,,,,,,,,,,,,22,9,55,11,16,4,3,4,12,
   13,71,55,,40,,16,16,22,117,71,16,22,4,159,10,12,10,3,
   4,16,22,,159,117,44,16,16,,67,12,11,9,4,3,16,22,22,16,
   40,55,,4,3,11,9,55,4,9,10,44,11,16,71,4,22,22,4,4,4,
   4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,55,,55,,4,9,79,5,4,
   5,136,9,,4,,5,,3,5,,5,4,4,4,4,5,3,4,3,,,4,,,24,5,5,,
   15,5,22,41,4,4,5,22,15,5,4,3,,,,,,6,4,4,4,4,6,3,4,4,
   ,,4,,25,25,6,5,,16,6,16,,5,5,5,16,16,6,4,4,6,6,6,,,
   3,3,4,3,4,3,3,3,4,,4,,,17,4,16,,12,4,16,6,28,4,3,
   16,12,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,25,25,6,5,,16,6,
   16,,5,5,5,16,16,6,5,6,,,6,4,3,4,4,6,3,4,4,,,4,,5,
   18,5,5,,12,5,5,9,6,6,5,5,12,5,,5,,,4,4,4,4,5,4,4,3,
   ,,,,,117,7,,,39,5,,32,8,4,5,9,71,7,,,,4,4,4,4,5,4,4,
   4,,,,,,,,48,,28,24,24,48,,5,5,22,28,24,,,4,3,4,4,6,4,
   4,4,,,,,6,44,26,,,36,17,6,9,,6,4,6,30,17,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,4,4,6,5,6,6,5,5,6,,71,,,,,,,,35,20,10,,6,5,22,
   ,,4,,4,,3,4,4,,,3,,,18,4,3,,12,4,16,6,4,28,16,16,12,
   4,4,,,4,,5,5,,5,,5,,7,4,,30,5,4,8,4,8,,4,30,5,4,32,,
   4,4,,,,,,18,6,4,,22,6,6,6,6,22,12,,12,4,,4,3,,5,,5,,5,
   ,,4,,55,,4,9,5,79,55,5,79,9,6,,,,,7,,,,,5,,,43,23,10,6,
   ,,30,,,4,4,3,,,,4,22,6,4,,14,6,4,6,6,6,4,4,14,6,,5,,
   5,,5,,,4,,55,,4,9,5,79,55,5,79,9,5,,5,,4,,,4,,28,23,
   4,7,5,,26,4,28,23,,4,,44,26,6,5,,17,6,30,9,5,,7,45,
   17,6,,,,,,,,,,,,,,,,,,,5,,,42,,,,5,9,50,7,5,4,20,8,,,,,,,,,,,
   ,,,,,25,5,23,,16,5,,29,18,28,21,,16,5,,,,,17,18,,,,,24,,,
   28,,,,5,,,,28,5,,,,39,14,12,8,,4,4,11,28,14,,,,,,,,,,,,16,
   60,34,27,34,11,31,12,5,117,,52,17,4,12,5,22,12,10,10,
   4,11,4,8,8,8,17,115,,6,4,12,67,73,,15,43,81,12,28,17,
   16,5,,4,,,5,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,,25,22,
   4,,23,22,25,4,4,,5,7,4,4,4,,,,6,20,3,3,3,3,4,3,3,3,
   ,4,4,4,6,6,,12,4,4,,4,4,12,3,3,6,6,6,3,,,5,,,,4,4,
   5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,55,4,5,136,5,9,,
   ,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,55,4,
   5,136,5,9,,5,,7,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,49,7,
   4,,,7,49,5,5,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,
   4,5,4,4,4,,,,,7,71,,32,8,39,,5,,,5,4,7,50,9,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,5,6,26,9,7,,,,,,31,,43,,,
   5,5,,,,17,18,25,18,25,25,25,24,36,44,,117,,,,,,,,,17,,18,
   24,,,,4,,3,,4,4,4,,4,4,4,,4,,12,4,3,,18,4,12,15,15,
   32,4,6,,4,5,,,5,4,,3,5,6,6,,12,5,4,,4,5,12,5,5,5,5,
   7,4,44,,,,,,,,,6,,17,6,5,,7,6,17,45,36,,5,9,,4,4,4,4,
   6,6,6,4,,,12,4,18,,3,4,12,15,16,4,32,6,25,25,,,6,9,,,,
   ,16,5,23,,25,5,16,,,32,22,35,3,,4,,,,6,6,,16,6,5,,5,
   6,16,16,16,6,6,12,,4,,,,6,6,,16,6,5,,5,6,16,16,16,6,
   6,12,4,5,6,,5,5,,15,5,5,,5,5,15,22,22,4,4,47,4,4,4,
   36,6,,22,6,4,,12,4,12,,6,22,6,6,,5,6,,,45,17,9,,5,17,
   30,6,6,5,,7,,6,,,31,6,,,4,6,31,6,6,5,9,9,5,,,50,7,,,
   5,5,42,,9,4,8,32,6,,,43,5,,,,,34,20,,6,10,,,,,,5,37,,
   19,34,6,,10,,,,,,,,,,,,,,39,,54,20,31,11,16,27,50,65,14,,
   17,5,20,4,5,52,66,75,,4,17,42,11,11,4,7,8,,,,,,,,,21,
   50,12,11,7,4,8,,5,4,66,52,189,16,11,74,43,62,4,17,10,
   19,12,17,14,6,8,8,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,
   ,,4,4,,22,4,22,,4,4,4,22,22,4,,4,,5,5,,,4,4,5,3,4,
   4,4,3,4,4,4,3,,5,5,22,22,4,4,,22,22,4,4,,4,4,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,
   4,,5,,4,22,22,,5,5,5,22,4,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   4,,,4,4,4,4,5,3,4,3,,,,4,,,4,7,,25,4,23,26,,4,5,22,
   25,4,,,4,4,4,3,5,3,5,4,4,4,3,4,,4,,,26,4,25,23,,7,
   5,4,22,4,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,5,3,4,4,4,3,5,
   5,17,4,,,,,23,21,17,,23,,4,4,,21,18,3,,4,,4,,4,,,4,4,,
   5,5,4,22,4,4,,22,4,22,22,,4,4,,4,,4,,4,,,4,4,,5,5,4,
   22,4,4,,22,4,22,22,,4,4,4,24,,3,4,,,,4,,5,5,5,22,4,
   4,47,22,5,15,15,,5,5,,3,4,3,6,6,4,4,,,3,3,16,16,3,
   15,16,3,16,15,16,16,3,4,,,,,4,,,,,4,23,20,20,,23,4,,,,
   21,19,4,3,4,4,,3,,4,4,4,15,4,4,18,15,4,4,4,18,4,4,,,
   ,4,,,5,,4,22,4,,26,22,4,25,25,,5,7,4,4,3,,,3,,3,15,
   3,16,15,16,3,15,16,16,3,16,3,4,4,,,5,5,136,9,5,79,
   55,4,,9,55,,4,4,4,,,5,5,136,9,5,79,55,4,,9,55,,4,3,,,
   4,12,16,,3,18,16,12,4,4,32,6,4,,4,18,4,18,4,12,15,
   16,3,,6,16,4,12,,,,,,,,,,,,,,,4,19,,,4,23,,31,23,19,23,,
   4,17,,4,,23,,19,21,18,23,4,,22,10,9,44,16,4,3,4,117,
   12,11,55,40,,,16,16,22,,159,67,4,22,71,16,13,9,16,4,3,
   22,117,11,12,11,16,3,4,16,71,71,55,,16,16,22,22,16,,
   55,40,4,3,44,10,9,4,55,9,11,159,10,12,22,22,4,4,4,5,
   ,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,22,4,22,4,,4,4,
   22,22,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,25,25,6,5,,16,6,
   16,,5,5,5,16,16,6,4,,,6,6,4,3,4,4,6,3,4,4,,4,4,,4,
   4,4,5,5,4,4,4,5,5,5,5,4,4,4,,4,,7,4,4,4,4,5,3,4,
   3,,6,5,4,,,4,5,30,,4,,30,5,4,4,8,8,4,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,6,,4,3,4,4,6,3,4,4,,4,5,6,5,5,18,,4,5,12,5,
   5,7,5,4,5,5,12,6,5,6,5,5,6,4,6,4,,,5,6,,,,5,,,20,,,
   5,5,5,,,18,5,4,7,5,6,6,4,4,,5,,6,,,,,5,,18,,5,,5,5,,,
   20,4,,3,,4,4,4,,5,5,5,,,4,4,4,22,4,22,4,4,,,22,22,4,
   4,4,6,3,,3,,,3,3,6,6,4,3,4,4,3,4,4,3,4,4,4,4,3,,,,
   4,4,,5,,5,,,4,5,4,8,4,8,4,5,30,30,,,4,,4,4,4,,5,5,5,
   ,,4,4,4,22,4,22,4,4,,,22,22,4,6,20,,,7,7,,,,,5,5,,22,
   ,5,5,,,,,20,3,3,,3,,3,6,6,4,4,3,6,4,6,3,4,4,4,6,6,
   4,,,,3,,6,6,,3,4,4,,4,4,3,12,12,6,6,6,,3,3,,4,4,,3,
   3,4,15,4,3,3,16,16,4,4,15,,,,,,,,,,,,,,,,,,,4,4,,,4,4,
   30,8,4,8,30,4,5,5,,,4,4,,,4,30,4,,4,,4,30,5,5,8,8,
   4,5,5,18,5,5,5,12,5,4,4,,7,5,5,12,3,4,,,,4,,,,,,,,4,
   4,,,,4,,,,,,,,4,16,20,4,,4,20,18,20,18,4,4,,4,22,9,22,
   4,6,4,4,43,43,10,22,10,22,6,4,4,4,22,22,9,4,3,20,
   20,22,20,4,4,3,4,11,10,11,11,3,3,3,20,20,22,20,4,4,
   3,4,4,4,20,20,10,4,4,22,22,9,6,22,22,11,22,22,10,3,
   4,4,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,55,,
   55,4,5,136,5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,
   ,5,4,22,22,5,,5,5,22,4,22,6,6,,,5,6,6,4,5,5,6,4,5,
   6,5,4,,7,7,29,51,6,6,,51,29,5,5,,6,6,6,7,,5,4,6,6,
   7,5,4,4,,6,,6,,,5,,6,51,5,29,6,,6,6,29,51,5,7,,5,4,
   6,4,7,5,6,6,5,4,5,6,,5,,,6,5,51,29,6,,6,6,29,5,51,,
   4,4,5,3,4,4,4,3,5,17,5,4,,,,23,,21,19,,,23,4,4,,19,
   17,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,22,4,
   5,5,,4,22,22,22,,5,5,6,3,4,4,,3,4,,4,3,,4,4,15,4,3,
   3,16,4,15,4,4,16,3,3,6,,,6,6,,6,,6,,7,7,29,5,6,6,,
   5,29,51,51,,6,6,,4,3,3,6,4,6,4,,,3,16,3,15,3,16,3,
   16,16,15,15,16,3,,18,,,4,,,,,,23,4,21,27,,4,23,,,,19,21,
   4,4,,4,,4,,5,5,22,4,5,5,,4,22,22,22,,5,5,,4,,4,,,4,,
   15,4,3,,16,4,15,12,12,18,4,6,4,3,4,,,3,,15,3,3,15,
   16,3,16,15,16,15,3,16,4,3,4,,,5,136,5,,4,55,4,55,,9,
   79,9,5,4,3,,,4,16,12,6,4,28,12,16,4,4,16,,3,4,,,5,
   136,5,,4,55,4,55,,9,79,9,5,,4,18,18,4,4,12,15,3,16,,
   6,15,4,12,,,,,,,,,,,,,,,4,,19,,4,23,21,,19,17,23,,4,,19,4,
   ,23,21,,27,21,23,4,,22,159,67,,16,,16,22,,39,65,10,12,
   159,4,16,3,4,39,10,9,4,22,9,55,11,12,16,4,3,22,11,
   40,11,10,16,3,4,55,,40,67,,16,16,22,4,3,159,10,12,22,
   16,,159,67,4,67,12,10,65,9,10,22,22,4,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,6,3,4,4,,,,
   ,25,44,6,9,,36,6,17,,,4,6,17,45,6,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,5,6,5,36,6,,,,
   ,10,26,,,,,5,6,,21,39,,,4,,4,3,,,,4,,,5,,5,9,4,,55,,4,
   55,79,79,5,9,,4,,4,,5,3,,4,5,,5,7,4,8,4,5,30,,4,,8,
   30,4,5,4,71,,,,,,,,,5,,7,9,4,8,32,,5,39,71,,5,,,3,4,4,
   6,6,4,6,18,,4,4,6,16,4,12,,3,18,32,12,16,4,6,,,,,6,,,,
   ,6,10,24,,,,5,,,,27,35,4,4,4,4,,4,22,4,6,6,6,4,6,14,
   ,4,4,6,14,4,6,,,,4,,,5,,5,9,4,,55,,4,55,79,79,5,9,6,
   5,4,,,4,,5,7,4,23,28,,4,26,,28,4,23,,4,,,9,9,5,9,6,
   6,31,,4,,9,31,6,6,4,5,71,,7,4,20,9,7,50,,5,,8,42,,5,
   4,36,,6,14,6,,4,12,,12,4,6,14,6,6,44,6,26,6,9,6,17,
   30,,4,,,50,6,17,25,,,,18,17,,,,,,,24,,5,24,32,,5,16,,19,
   19,32,16,,5,,,5,,,,34,34,,,5,,8,10,52,27,,,4,6,74,13,
   132,25,95,60,,8,8,8,,14,75,5,16,,10,12,12,11,4,4,,,15,
   15,53,12,4,5,,34,39,34,31,11,12,,,,,,,4,4,30,10,14,,42,
   12,17,52,17,66,16,,5,4,,,7,4,4,4,3,5,3,5,4,4,4,3,4,
   ,4,,7,49,4,,,49,7,5,5,8,4,8,,6,,4,3,4,4,6,3,4,4,,4,
   ,,5,18,5,9,6,12,5,5,5,,5,6,5,12,5,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,6,5,6,5,4,6,4,7,5,6,22,4,6,,,,6,,20,,,,6,6,6,,
   20,,5,4,7,4,6,6,5,5,6,4,22,6,,,,,6,20,,,6,,6,6,,24,,
   4,,4,,4,,3,,4,4,,,4,,5,5,4,22,22,5,5,,,22,4,22,4,3,
   6,3,,4,4,,3,4,6,4,6,4,6,3,4,4,6,4,6,6,4,3,4,4,,,6,
   ,,4,,,,4,,7,5,4,8,8,5,7,49,49,,4,,,3,4,4,6,4,4,6,4,
   ,4,4,4,15,4,4,4,4,18,18,4,15,4,6,,,,6,6,,,,,6,6,24,,
   ,6,6,,,,20,,4,4,4,3,,4,6,4,6,6,4,4,6,6,4,6,6,6,6,
   4,6,,,,4,,,4,,5,7,4,,,7,5,49,49,8,4,8,,4,4,,,4,,5,5,
   4,22,22,5,5,,,22,4,22,4,4,3,25,6,25,6,6,6,16,16,5,5,
   ,12,16,6,16,3,4,6,,6,4,14,6,6,6,14,4,6,6,4,,4,4,6,
   ,6,14,4,,4,4,4,14,6,6,6,6,6,25,6,25,6,6,6,16,16,5,
   5,,12,16,6,16,4,3,,,4,,,,,,,,4,,4,18,22,,4,4,22,18,18,
   18,4,,4,,,4,,,,,,,,4,,6,11,28,28,4,9,4,6,28,12,28,10,
   59,59,9,4,4,6,28,11,28,4,4,11,10,12,11,3,3,3,3,28,
   59,28,28,4,3,4,28,59,28,28,4,3,4,6,6,4,59,10,59,6,
   4,28,11,28,9,28,11,28,59,10,59,4,3,4,4,,,4,4,4,4,5,
   4,4,3,,,,4,,,5,9,79,55,4,,55,,4,5,9,79,5,,,4,4,4,3,
   5,4,5,4,4,4,4,4,,5,,,55,4,55,,79,9,5,4,9,5,79,,24,
   25,25,18,25,18,25,18,71,,44,20,,,,17,,,,,,,24,18,,,,5,6,
   6,4,5,5,6,4,7,,25,6,,,,,,31,43,,,,5,5,,,,,,4,,5,,4,,3,
   5,4,,5,5,5,15,5,5,,15,5,22,22,47,4,4,3,4,25,,,4,,,,4,
   ,6,6,6,16,5,5,,16,6,16,16,,5,5,4,25,,,4,,,,4,,6,6,6,
   16,5,5,,16,6,16,16,,5,5,,4,4,3,6,6,6,4,,,4,4,12,16,
   3,,12,4,16,15,6,32,4,5,44,,,,6,,,,,5,16,20,21,,16,5,,,
   47,20,19,,4,5,6,,4,,6,6,5,12,5,5,,12,5,5,5,9,6,6,,,,,
   ,,6,,6,17,4,,,17,6,36,45,,6,9,4,4,4,,,4,,4,12,3,16,,
   12,4,15,15,6,4,32,,5,4,,,5,7,50,,5,,39,5,,9,32,8,4,,
   4,,,5,22,28,42,5,,28,24,24,24,48,,5,4,,,6,17,45,,4,,
   36,17,6,6,9,,6,,6,36,6,22,4,12,,12,4,,6,6,6,22,,,,,,,,,
   ,,,,,,6,,,,5,,,35,20,34,10,,6,55,,5,,,,,22,20,10,6,,,17,
   21,,20,5,4,5,73,81,,42,50,,31,20,11,16,,52,27,4,,39,
   14,12,12,8,,4,,54,17,13,14,8,4,,,,,,,,,,16,11,60,34,77,
   5,4,117,,73,4,25,12,12,14,17,12,8,8,6,6,,4,3,4,4,6,
   4,4,4,,4,,,6,25,25,,5,16,16,6,5,,5,5,6,16,16,,5,6,5,
   5,6,4,6,4,,117,,6,,,,10,,,20,35,,,5,6,,,30,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,4,,,,5,4,4,,5,,5,,,4,7,5,25,4,22,4,,26,,23,
   25,4,4,4,6,4,,3,,,,3,6,20,4,6,6,12,3,4,4,,4,6,4,12,
   3,3,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,55,79,,55,4,,,4,4,,
   5,,5,,,5,9,5,79,5,9,4,,55,79,,55,4,,32,,,7,,,,,,10,6,,
   22,,5,,,,63,,20,4,4,,5,,5,7,,5,8,4,49,5,7,4,,,8,7,49,
   5,,,,,,6,20,,6,6,12,,4,4,,12,22,6,22,6,,3,,,4,18,,6,4,
   12,15,4,3,,16,28,4,12,16,,,,,,,,,,,,,,,,,,,,4,,,5,9,71,32,
   4,8,39,,5,7,,,5,,,,,,,,,,,,,,,,,6,25,44,,6,17,36,6,4,,,9,
   6,17,45,,5,,,,5,,31,,49,,,,5,25,,,,24,,,,,,17,,18,41,20,
   16,,5,20,,21,19,5,16,,8,60,22,117,8,,8,8,73,,14,34,12,
   106,,,4,6,81,52,15,16,,39,,54,77,20,31,11,5,12,,13,12,
   4,11,4,14,,17,73,5,20,4,,4,4,17,42,12,,,,,,,25,50,14,
   106,27,12,,5,16,,5,6,5,4,6,4,7,5,6,20,5,5,,,,,,26,,,,
   10,6,5,35,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,,,4,5,3,,4,
   ,,4,4,25,22,5,7,,26,23,4,25,4,3,6,4,,4,4,,4,4,6,4,
   20,,4,3,12,4,6,6,6,4,4,3,12,4,,,,3,,4,,,,5,,,4,5,79,
   9,5,9,79,55,,4,55,,4,4,4,6,4,6,6,4,,18,,3,15,12,4,
   4,6,32,18,4,16,12,,71,,,6,,,,,,,5,23,,34,6,10,,,,26,,,,
   5,4,,6,7,5,,,4,5,49,7,4,8,8,,7,5,49,,,,,,,5,,,5,5,,,
   7,9,71,39,8,4,32,,4,,,,5,,,4,5,79,9,5,9,79,55,,4,55,
   4,5,,26,6,44,,5,6,45,17,5,7,,9,17,6,36,4,4,6,,32,,
   12,6,22,6,22,6,6,4,4,,12,,7,,71,,5,,39,5,4,32,8,,7,
   9,71,,,,,5,22,28,22,5,48,,27,24,22,28,5,,,34,5,,,,,,37,,
   5,,25,,21,,16,5,22,47,24,33,5,,16,,,24,,,,,,,17,18,,,,,,,,,
   ,,,,10,34,15,,8,4,4,15,12,28,16,5,10,25,13,12,4,4,11,
   ,27,60,50,65,20,11,31,52,95,131,16,5,4,20,8,6,4,66,
   17,43,8,8,73,17,115,,52,10,27,17,17,59,5,,16,4,4,5,4,
   4,4,5,4,6,25,25,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,5,,,,4,
   ,19,19,,,4,23,23,,21,17,25,,3,4,,,,,5,,,,,4,,,,,,4,,,,,,
   5,25,,,5,,44,,5,,,,5,,22,24,47,,5,16,16,,21,29,,4,,5,7,
   ,5,7,,,,4,,,19,19,,4,23,23,23,,31,4,,,,,5,,,,,4,,,,,,4,,,,
   ,,6,4,4,18,,4,,,,4,,22,18,18,,4,4,4,18,22,18,,,,6,,,,,
   5,,31,,28,,5,,,,,,5,,4,,,,,4,,19,,17,,4,23,23,19,21,,,5,
   6,,,,6,,37,19,,,5,,10,,,34,25,,,,,24,,,,,,18,17,,,,,5,,,,16,
   ,,19,19,,16,5,5,24,32,32,,,,6,,43,,19,,5,,10,20,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,41,45,74,,5,3,4,59,95,,,,,,,,,,,
   ,,,,88,95,58,,,,,,76,59,62,,,,,,118,44,,,,,,,,,,4,3,62,58,
   44,5,45,41,74,76,88,118,,,,4,,5,,,5,5,,4,,5,,,,,4,19,27,
   ,4,,23,23,,23,19,6,4,4,4,,4,4,,18,4,,,,,4,20,16,18,4,
   ,4,4,20,20,18,,,,,,,6,,,,,,,5,,,,5,,,,,34,37,,,5,5,7,5,,
   7,,,,,4,,17,18,4,,23,23,21,,19,3,25,,,5,,,,,,,4,,,,4,,,,,,
   ,25,,,5,,,,,,,4,,,,4,,,,,,,,5,,44,,,,,,5,25,,23,5,,16,16,
   20,24,32,5,4,,,,,,,4,19,,21,4,,23,23,27,21,,5,,6,,,,,6,,
   34,,5,,,10,,43,20,25,5,,,,,16,29,28,18,16,,5,5,23,,21,,,,
   ,,24,,,,18,,17,,,,,,,,,6,,,20,5,,,10,23,38,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,88,118,76,5,,3,4,67,41,45,,,41,
   ,50,107,,,,,74,,74,194,,,,45,,43,143,,,,,4,3,77,61,154,,,,,
   ,5,61,77,59,50,55,43,,,,,4,,4,,4,,,4,4,,5,5,4,22,4,4,
   ,22,4,22,22,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,
   4,4,4,22,4,22,4,4,,,22,22,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,
   4,,5,5,22,4,5,5,,4,22,22,22,,5,5,,,,4,,,5,,5,9,4,,55,
   ,4,55,79,79,5,9,,4,4,,,4,,5,5,4,22,22,5,5,,,22,4,22,,
   ,,,,,,,,,,,,,,,,,4,4,,,5,4,25,7,5,,25,4,23,23,26,,4,4,,,
   5,25,4,,4,26,4,25,23,23,,7,5,,5,24,4,4,5,15,22,5,5,,
   26,22,5,15,,,,,,,,,,,,,,,4,19,19,,4,23,21,17,,,23,,4,27,
   19,4,,23,23,19,,,23,4,,4,11,14,117,3,4,16,22,44,10,10,
   14,11,71,4,3,16,22,44,10,9,4,22,10,9,44,71,16,4,3,
   22,10,10,44,117,16,3,4,55,40,,16,,16,16,4,22,16,71,16,
   11,22,16,117,11,14,,16,71,117,,55,40,22,22,4,4,25,,,4,,,
   ,4,,6,6,6,16,5,5,,16,6,16,16,,5,5,,4,,4,5,,5,5,5,,
   5,4,22,,4,4,22,4,22,22,4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,
   4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,5,5,,4,22,4,,4,22,4,22,22,4,4,,,4,4,,7,5,4,
   8,5,4,30,,4,,8,30,5,4,,,,,,,,,,,,,,,,,,4,6,,6,12,5,,4,4,
   5,12,5,5,5,7,5,5,7,,4,8,5,30,4,,4,,8,4,5,30,6,6,22,
   ,5,5,,,20,,,,5,5,6,20,,,5,5,,18,,,5,,5,18,,5,,5,,20,,,
   5,5,,4,10,9,11,3,3,3,4,11,11,10,22,22,20,4,3,4,3,
   22,20,20,4,4,22,9,22,22,4,6,4,4,43,10,43,22,4,4,6,
   22,10,22,20,6,4,4,4,3,4,20,20,22,4,3,11,10,9,4,20,
   20,22,22,20,20,4,4,4,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,
   55,79,,55,4,,,,,26,,,,,,17,18,,,,24,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,5,,24,22,5,,48,24,22,28,28,,5,27,,4,,,,5,,,4,5,79,
   9,5,9,79,55,,4,55,,,,,,,,,,,,,,,,,,,,4,,,6,6,30,9,6,,36,
   6,17,17,,,4,,,,,,,,,,,,,,,,,,7,71,8,4,7,71,9,5,,,32,,5,39,
   ,,,,,,,,,,,,,,6,35,19,,6,10,26,,,,,,5,,26,6,,10,23,34,,,,5,
   ,5,66,52,73,4,5,20,,,15,17,17,10,17,4,4,11,16,,12,15,
   6,8,10,52,27,43,,,4,8,13,131,50,42,,4,,25,95,60,115,,
   8,8,5,16,11,,10,12,,20,,15,16,31,,34,65,,28,59,,,4,,,,,,,
   ,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,5,22,4,,5,5,4,22,22,22,5,
   ,5,,5,,5,,5,,,4,,55,,4,9,5,79,55,5,79,9,5,5,5,,4,,,
   4,4,22,22,4,4,4,,,4,22,22,6,6,6,,,5,6,6,29,5,51,6,6,
   ,,51,29,5,6,6,7,,7,5,51,,6,6,51,5,29,29,6,,6,6,7,,
   7,51,5,,6,6,5,51,29,29,6,,6,5,,,6,6,29,51,5,6,6,,,5,
   29,51,,4,20,20,23,4,,21,19,,,,23,4,,,,,,,,,,,,,,17,21,23,,
   4,21,18,,,4,23,,4,40,9,11,3,4,16,22,12,117,11,55,10,
   9,4,3,16,22,13,71,16,22,22,159,67,,,16,,16,4,12,11,
   117,44,3,16,4,10,12,159,55,4,16,3,4,22,16,9,55,10,22,
   16,11,40,9,,55,,44,71,16,71,22,4,22,25,,,5,,,,,,,4,,,,4,,
   ,,,,,,,,26,,,,,24,,,,,17,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,6,,,,,5,,,,,,5,,,28,,28,,,,,,5,,34,34,5,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,77,61,59,3,5,,,74,50,
   43,61,77,154,5,3,,,74,41,45,,,41,55,,,,,,,67,50,,,,,,45,
   43,,,,,,4,,,,88,76,,,,107,143,,,,,,,,,,,,4,,,,6,6,,16,6,5,,
   5,6,16,16,16,6,6,12,4,4,,,5,5,,22,4,5,,5,4,22,22,22,
   5,5,,4,,4,,7,5,8,4,7,5,49,4,,,8,49,7,5,,4,6,,6,5,
   12,9,6,6,12,5,5,5,5,,5,,,,,,,,,,,,,,,,,5,7,,8,4,7,49,5,
   4,,,8,5,7,49,6,6,,24,6,6,,20,,,,,6,6,6,,20,,6,6,20,,,,
   6,,6,,20,6,,6,24,,,,6,6,,4,59,28,28,3,4,4,3,28,28,59,
   10,11,11,3,3,3,4,12,11,10,6,6,11,28,28,59,4,9,4,6,
   12,28,28,28,4,4,9,10,59,59,28,9,4,4,4,4,3,11,10,11,
   3,4,28,59,28,4,28,59,28,28,28,59,6,6,6,,,,,,,,,,,,,,,,,,,,
   ,4,,117,7,,4,8,5,,42,,5,,32,50,7,9,,,,,,,,,,,,,,,,,,,6,,,
   50,6,,,4,6,30,17,17,6,9,,,,,,,,,,,,,,,,,6,,23,38,5,,,,20,,,
   ,6,10,,20,,,,5,43,19,,,6,,10,,,,,,,,,,,,,5,12,,11,4,4,11,
   16,12,12,17,25,,17,5,4,20,,81,,107,,4,17,10,54,50,4,,8,
   ,,,,,,,,14,11,39,42,,4,8,5,,20,,73,93,16,11,12,12,15,
   31,34,77,,52,27,,6,8,8,4,4,,24,5,,4,4,5,22,15,5,5,,
   47,15,5,22,4,,5,,,4,28,7,,5,28,4,23,23,4,,26,,5,,,28,
   4,,26,4,4,28,23,23,5,7,,,,,,,,,,,,,,,,,4,,27,21,4,23,,19,
   21,,,,4,23,,19,21,,23,4,19,17,,,4,,23,,,,,,,,,,,,,4,12,67,
   10,3,4,16,22,11,11,40,10,159,12,4,3,16,22,11,9,55,22,
   4,10,9,39,159,3,4,16,22,39,65,,,16,16,,9,10,65,67,4,
   3,16,4,22,16,12,10,159,22,16,10,12,67,,67,159,,40,55,,
   4,22,22,4,4,,,5,5,136,9,5,79,55,4,,9,55,,4,4,,,5,136,
   5,,4,55,4,55,,9,79,9,5,25,6,25,6,6,6,16,16,5,5,,12,
   16,6,16,,25,,,17,18,,,,,,,,24,5,,,,5,,31,43,,,,,5,32,22,5,
   ,16,23,25,,35,16,5,,6,66,17,74,4,7,,8,27,52,12,52,10,
   43,7,4,,8,50,66,17,5,,17,21,,189,20,5,4,16,11,12,,19,
   11,4,4,42,50,,62,31,20,11,4,,8,39,14,11,,8,54,17,11,,,,
   ,65,75,14,,16,5,4,6,,6,16,16,,5,5,16,16,6,6,5,,5,5,,
   ,5,79,9,79,5,55,4,,9,4,,55,,6,22,,10,6,,,20,35,,,,5,,,,
   ,,,,,,,,,,30,,10,,6,,23,43,,5,,,16,17,15,12,11,4,4,5,11,
   ,12,115,43,67,31,11,12,,28,,28,8,8,60,22,117,149,8,,8,
   6,27,10,52,81,4,,,34,12,106,73,,,4,16,,12,39,,34,5,4,
   12,,10,5,14,,17,14,,17,,4,,5,,,79,5,,55,4,4,55,,9,5,9,
   79,,6,,21,,5,,26,,,39,,10,6,,,,,,,,,,,,,,,27,,,5,24,,,35,6,
   10,,16,,42,30,11,31,12,,74,,52,,12,10,4,11,4,5,13,14,
   17,,,,,,,,,,4,12,39,15,17,4,8,,10,34,15,14,,8,4,16,5,4,
   10,25,12,,12,27,60,34,5,52,95,53,132,75,66,8,6,8,5,
   25,20,24,5,16,,25,23,,32,,5,16,,,,,,5,31,28,,,5,,,,,17,,
   18,,,,,24,,,6,106,34,12,4,,,8,12,81,52,73,77,12,,4,,8,
   12,106,27,,5,17,14,,93,4,5,20,16,54,39,,,11,20,31,10,
   11,,15,4,4,11,4,,8,12,25,50,,8,11,17,42,,,,,17,107,,5,
   16,,4,,,,4,,,,,,,,4,,,4,,,,,,,,4,,,77,61,,,,,,,67,50,61,77,,,
   ,,,,41,55,4,,41,45,74,154,,5,3,,50,43,74,59,,3,5,,,,,,,,,
   ,,,88,107,,,,76,143,,,,,,45,43,,,4,,,,,4,,,,,4,,,,,45,62,,,,
   ,59,,76,,41,58,,,,,95,,88,,,,,,,,,,4,95,,59,74,3,,5,88,
   118,76,44,5,,3,,,,41,,58,,,74,,44,,45,,62,118,,,,4,,,118,,
   194,,,,,74,74,,88,,107,,,,,50,41,,,4,41,45,67,76,3,5,,,,,,,
   ,,,55,43,50,143,5,3,,,,,77,61,,,,59,154,,,61,77,,43,45,,
   4,,,20,20,22,4,4,3,4,43,22,22,20,22,28,21,16,59,16,
   22,16,28,24,22,24,28,24,24,22,24,22,16,28,43,19,18,4,
   3,3,16,24,28,4,4,43,22,21,4,24,16,16,28,28,59,43,28,
   22,20,22,21,28,24,22,24,21,28,59,22,16,16,22,16,28,21,
   22,16,28,20,22,16,18,4,4,4,22,21,22,3,3,19,16,28,4,
   24,28,24,22,20,20,22,28,20,4,22,22,43,22,3,4,4,20,20,
   22,20,4,4,3,20,22,16,28,21,16,28,18,24,22,28,22,24,
   22,19,28,22,16,4,3,4,28,59,28,28,4,3,4,22,43,19,16,
   24,22,28,18,16,28,21,43,24,16,43,16,24,22,3,4,4,20,
   22,28,21,28,18,59,18,22,16,18,21,22,16,18,21,28,18,4,
   4,3,4,3,22,22,20,4,20,20,22,16,28,16,20,59,22,4,28,
   59,28,18,18,18,22,28,20,22,22,22,22,28,22,22,59,22,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,20,,,20,,,20,,,
   ,,20,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,20,,,
   20,20,20,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,18,18,
   18,18,18,18,18,18,18,18,18,18,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,18,18,18,18,18,18,
   18,18,18,18,18,18,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,86,86,,44,44,86,44,44,44,44,86,4,
   4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,4,6,,6,
   ,8,12,8,,,,,,,,86,,,86,86,86,,44,86,44,86,,6,6,6,8,10,
   10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,
   ,,,,,,138,138,,,138,,138,,4,6,4,4,4,8,4,6,6,4,6,6,,,6,
   6,8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,44,86,86,44,,,86,86,
   ,86,,86,6,6,6,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,
   ,8,,16,,16,,,,,,,,138,,,138,,,,138,,138,,,8,10,10,8,4,12,
   12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,,8,28,8,,,,,,,,,,,
   ,,,,,,,,,4,6,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,,4,6,,6,
   ,8,,8,,,,,,,,44,44,44,44,86,86,44,,86,,86,44,6,10,4,8,
   8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,,138,138,,
   ,,138,,,,,138,8,4,12,12,4,12,12,,,12,12,8,,8,,,,,,4,12,,
   12,,8,,8,,,28,28,,,,,,,,,,,,,,,,6,16,16,6,16,16,,,16,16,10,
   ,10,,,,,,6,16,,16,,10,,10,,,,,,,,,,,,,,,,,,,,4,4,2,4,4,,,4,
   4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,18,18,18,18,18,
   18,18,18,18,18,18,18,4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,
   ,6,8,6,,,,,,,,,,,,20,,,20,20,20,,,4,4,4,,,6,6,6,8,6,,,,,
   ,4,6,,6,,6,8,6,,,,,,,,,,,,20,,,20,20,20,,,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,18,18,18,18,18,18,
   18,18,18,18,18,18,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,
   ,,,,,,,20,,,20,20,20,,,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,
   ,,,,,,,,20,,,20,20,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,
   ,,,20,,,20,,,20,,,,,20,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,20,
   ,,20,,,20,,,,,20,,4,8,8,,,,4,6,,6,,4,,4,,,,,,,,,22,22,,,
   22,,,,,22,,,,,,,,4,,,,,,4,,,,,,,,,,64,64,,,,36,,,,,36,8,8,,,,
   4,6,,6,,4,,4,,,,,,,,,22,22,,,22,,,,,22,,4,,,,4,,,,,8,,8,,,,,
   ,,,72,,,72,,,,72,,72,,,,,,4,,,,,8,,8,,,,,,,,72,,,72,,,,72,,
   72,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,,,,18,18,18,18,18,18,
   18,18,18,18,18,18,,4,,6,,6,,,8,8,,,,20,,,20,,,20,,,,,20,,,
   ,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,20,,,20,,,20,,,,,20,,,,,,,,
   ,,,,,,,,,,,,,,,,4,,,,,,,,,22,22,,,22,,,,,22,,,,,,,,,,,64,64,,,,
   36,,,,,36,,,,,,,,,22,22,,,22,,,,,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,4,,,,,,,,40,64,,,40,,64,,,,,,,,,40,64,,,40,,64,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,18,,,,,,,,,18,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,18,,,,,,,,18,,,,,,18,,18,,,,,,,,,3,6,6,9,,6,9,,12,,,6,
   6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,
   ,6,,6,,6,,,,,,,,,27,27,27,,27,,27,27,,27,27,6,6,9,,6,9,
   ,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,
   ,,,,3,3,,6,,6,,6,,,,,,,,,27,27,27,,27,,27,27,,27,27,5,5,
   ,4,7,10,7,12,,5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,5,,,
   3,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,19,,25,19,,26,
   19,6,24,26,6,17,5,,5,5,12,8,,,5,5,5,5,5,10,5,5,10,
   9,3,4,4,5,5,5,,,3,5,5,,5,,,,,,5,5,,6,8,7,,7,5,5,,,,,,
   26,19,25,,19,19,,25,6,19,6,25,,7,8,,7,,,10,10,10,10,
   10,10,10,10,10,16,4,7,7,7,10,10,,,4,7,10,,10,,,,,,5,5,
   6,4,6,5,6,5,8,8,,,,,,,,,26,26,,,5,5,,10,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,,5,5,5,5,5,10,
   5,5,10,9,3,5,5,4,5,5,6,,3,4,5,,5,,6,,,,4,4,,4,,5,,5,
   ,,5,5,,8,,19,26,6,17,25,,19,25,6,,24,19,,7,,,10,10,10,
   10,10,10,10,10,10,16,4,5,5,5,6,6,6,,4,5,6,,6,,6,,,,
   7,7,,4,,10,,10,,,,,,6,,,,5,,,28,28,,10,,5,,,,,,27,,,,,,,,,6,
   ,,,,,,,6,,,,,,,,,,,,7,,,,7,,,,,,,,,,,11,42,70,,254,,,,,,,,9,9,
   14,9,14,10,9,14,10,11,6,9,9,7,8,8,10,,6,7,8,,8,,10,,,
   ,7,7,10,6,11,9,10,9,10,10,8,8,,,,,,8,,,,,8,22,,22,,,,,,
   18,,,,,,,6,,,,,,7,,6,,,,,,7,,,,,,,,,,,,,,,,,,,70,44,,,151,,,,11,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,
   5,4,6,7,7,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,6,4,
   14,8,6,8,,,,,,8,,77,31,7,77,24,22,37,10,10,22,10,31,5,
   5,5,5,4,5,5,5,3,5,5,5,6,6,,,3,5,6,,6,,,,,,5,5,6,4,,
   8,6,8,6,6,,,,,,31,77,18,24,24,31,77,10,7,24,7,77,5,5,
   5,6,8,7,8,4,5,5,5,10,10,,,4,5,10,,10,,,,,,5,5,,6,9,7,
   ,7,8,8,,,,,,112,112,22,,165,64,,8,9,66,9,112,5,5,5,5,
   5,5,3,5,5,5,6,6,9,,3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,
   ,6,6,,14,,22,37,7,24,77,77,31,7,18,37,18,24,5,5,5,5,
   4,4,5,5,5,10,10,,,4,5,10,,10,,,,,,5,5,9,6,,7,9,7,11,
   11,11,11,,9,,64,,22,165,,112,112,9,22,165,22,,7,7,6,7,
   4,6,6,6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,10,6,7,6,
   10,10,8,8,,10,,,,15,204,204,,,8,9,196,9,,5,5,7,3,5,5,
   5,6,6,6,,3,5,6,,6,,6,,,,5,5,,4,,8,,8,,,,,,14,,24,24,
   10,23,31,37,22,18,7,77,7,24,5,8,4,5,5,5,10,10,9,,4,
   5,10,,10,,9,,,,5,5,,6,,7,,7,,,8,8,,12,,66,165,9,66,112,
   ,64,22,22,,22,165,7,4,6,6,6,12,12,7,,4,6,12,,12,,7,,,
   ,6,6,7,4,8,6,7,6,8,8,10,10,,,,,204,9,196,,,,9,15,204,
   15,204,4,9,9,9,8,8,,,4,9,8,,8,,,,,,9,9,10,6,,8,10,8,,,
   ,,,,,140,,35,61,,70,70,10,35,61,35,,3,3,3,4,4,3,,2,3,
   4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,18,18,3,17,
   17,18,18,3,3,18,3,17,3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,
   4,5,4,4,4,5,5,,,,,,,19,25,25,17,19,,4,4,19,25,25,5,5,
   5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,19,25,25,
   17,19,,4,4,19,25,25,5,5,,,3,3,5,,5,,,,,,4,4,4,4,5,3,
   4,3,,,5,5,,,,19,,25,17,25,,19,4,4,26,26,17,4,6,,4,5,4,
   ,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,
   ,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,
   ,,,6,6,,5,,,3,,6,,6,,3,,,,4,4,4,4,5,4,4,4,,,,,,,,54,,
   46,25,25,54,,5,5,27,46,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   3,4,,4,,3,,,,3,3,3,2,3,3,3,3,3,3,3,3,,3,,18,18,3,
   17,17,18,18,3,3,18,3,17,5,,5,,,,,,4,4,4,4,5,3,4,3,,,
   5,5,,,,19,,25,17,25,,19,4,4,26,26,17,,4,,6,,,,5,5,6,4,
   6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,
   ,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,
   54,,46,25,25,54,,5,5,27,46,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,,,5,
   5,,5,,19,26,4,19,,26,19,26,26,,4,19,,4,,5,,5,,,5,5,,5,
   ,19,26,4,19,,26,19,26,26,,4,19,4,,,3,,,,,,,5,,27,27,5,,
   48,27,27,46,46,,5,27,,4,4,4,6,6,6,6,,,,18,18,18,18,
   18,18,18,18,18,18,18,18,,,,,,,,,,,27,27,23,,,27,27,,,,27,,
   ,3,5,5,,,,5,,26,19,5,,21,19,26,26,26,21,5,,,,,,,,5,,27,
   27,5,,48,27,27,46,46,,5,27,5,5,,,,5,,26,19,5,,21,19,
   26,26,26,21,5,,3,5,5,,,,33,137,9,37,80,71,19,,9,71,,
   21,5,5,,,,33,137,9,37,80,71,19,,9,71,,21,3,,,,80,19,,
   71,19,21,71,,9,33,9,80,,,,80,19,,71,19,21,71,,9,33,9,
   80,,,,,,,,,,,,,,,,,,,26,26,,,23,21,27,,26,,,,,,,,,,,,,,72,19,,,
   ,19,26,,79,,59,,,,,19,26,,191,,25,25,72,59,13,12,19,5,
   18,,,,79,118,,18,,19,,72,59,,18,,,26,19,,59,,26,19,,72,
   19,5,59,12,118,191,11,46,26,,25,6,6,9,,6,9,,12,,,6,6,
   6,6,6,9,6,6,9,12,3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,
   ,6,,6,,,,,,,,,27,27,27,,27,,27,27,,27,27,5,5,,4,7,,7,,,
   5,5,5,5,5,10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,6,,,
   8,,3,5,,5,,5,5,5,,6,,,,,,,24,,25,19,6,25,17,19,19,26,
   6,5,,5,5,,8,,12,5,5,5,5,5,10,5,5,10,9,5,3,5,5,5,6,
   5,5,4,5,5,,7,,,,,,3,4,,5,,5,,7,,,,,,,8,19,6,19,25,,25,
   19,,25,26,19,6,,7,8,,7,,,10,10,10,10,10,10,10,10,10,
   16,7,4,7,5,5,4,,,5,6,6,,10,6,,,6,,4,5,,6,,6,,10,,6,,,,
   ,,,5,28,,28,5,,,,,,10,12,,,,,,,18,,,,,,,,,,6,,,,,,,,,,,,7,,,,,
   6,,,,,,,,,7,,,,,,,,,,,,151,,,70,44,11,5,,7,,10,5,5,5,5,5,
   10,5,5,10,9,4,3,4,4,4,4,,,5,5,5,5,5,,,6,8,,3,5,,5,,
   5,5,5,,,,6,,,,26,6,26,6,19,25,,19,17,19,,24,,7,,,10,10,
   10,10,10,10,10,10,10,16,5,4,5,7,7,4,8,8,7,10,10,,5,,
   ,6,,,4,7,,10,,10,,5,,,,6,,,6,,10,,5,,,26,28,,,,5,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,14,9,14,10,
   9,14,10,11,7,6,7,7,7,6,10,10,9,8,8,8,9,10,,10,,,6,9,
   ,8,,8,8,9,,10,,10,,,11,,22,,8,,8,,,,,,22,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,,6,,,,,,,,,,,,,,7,,,
   6,,,,,,,,,,,7,,,,,,,,254,11,70,42,,,,,5,5,4,5,5,4,6,7,7,
   5,3,5,5,5,4,,,5,6,6,,8,6,,,14,,3,5,,6,,6,,8,,6,,,,,,
   77,7,37,18,22,10,31,23,24,24,24,7,5,5,5,5,4,5,5,5,
   5,3,5,5,5,4,,,5,6,6,6,8,9,,9,14,,3,5,,6,,6,6,8,,9,,
   9,,,8,37,18,77,7,31,7,77,24,24,23,37,18,5,5,5,6,8,7,
   8,5,4,5,5,5,6,,,5,10,10,8,7,9,,,12,,4,5,,10,,10,8,7,
   ,9,,,,,,,22,,22,64,9,112,66,165,66,165,22,5,5,5,5,5,5,
   5,3,5,5,5,4,6,6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,,6,,,,
   24,7,31,10,77,18,24,24,77,31,77,7,5,5,5,5,4,5,4,5,
   5,5,6,11,11,5,10,10,11,7,,,9,9,,4,5,,10,,10,11,7,,,,9,
   ,,,165,22,112,9,112,22,,165,,64,,22,7,7,6,7,6,4,6,6,
   6,4,8,8,6,12,12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,
   8,204,15,,9,,9,,196,204,,204,15,5,5,7,5,3,5,5,5,4,,,
   5,6,6,,8,9,,6,8,,3,5,,6,,6,,8,,9,,6,,,14,22,10,22,10,
   37,7,24,77,31,77,31,10,5,8,5,4,5,5,5,6,8,8,5,10,10,
   ,7,,,,,,4,5,,10,,10,,7,,,,,,,9,66,9,64,8,,22,165,,112,
   112,112,9,7,6,4,6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,
   4,6,,12,,12,8,6,,7,,7,,,10,196,9,,8,,15,204,204,,,,9,9,
   4,9,9,9,6,,,9,8,8,,8,,,10,,,4,9,,8,,8,,8,,,,10,,,,61,
   35,70,10,70,35,,61,,140,,35,3,3,4,4,4,,,3,5,5,5,5,4,,
   ,5,,3,3,,5,,5,5,5,,4,,,,,,,4,26,26,19,4,,19,19,19,26,
   26,3,3,3,2,3,3,3,4,4,3,3,3,,3,3,,2,3,,4,,4,3,3,,3,
   ,3,,,3,18,3,18,3,18,3,17,17,17,18,18,3,4,4,4,,,3,5,
   5,5,5,4,,,5,,3,3,,5,,5,5,5,,4,,,,,,,4,26,26,19,4,,19,
   19,19,26,26,3,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,
   ,5,26,26,,4,19,25,25,19,17,19,,4,4,,,5,5,5,5,3,,,4,,,
   3,5,,5,,5,5,3,,,,4,,,5,26,26,,4,19,25,25,19,17,19,,4,
   6,6,4,4,4,6,4,4,,4,,,2,4,,4,,4,6,4,,4,,4,,,,18,18,
   18,18,18,18,18,18,18,18,18,18,3,5,5,5,5,5,,,,,,3,5,,5,
   ,5,5,5,,,,,,,,71,,71,,19,9,80,37,21,37,137,9,5,5,5,5,
   5,,,,,,3,5,,5,,5,5,5,,,,,,,,71,,71,,19,9,80,37,21,37,
   137,9,5,5,,4,,,4,,,3,3,,5,,5,,4,,,,4,,,5,19,25,19,4,,
   25,17,25,25,,19,4,4,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,
   ,6,,5,,6,,5,,,,,,6,5,5,6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,
   6,,5,,6,,5,,,,,,6,,,,,,,3,,,5,,5,3,,,,,,,,,33,9,21,,71,,
   21,71,80,80,19,9,4,,,5,,3,4,,5,,5,,3,,4,,,,,,21,5,19,
   26,26,5,21,,,26,19,26,,4,,,3,,,6,,6,,4,,3,,4,,,5,27,46,
   54,5,,46,25,25,25,54,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,
   ,6,,6,,,,4,,3,,,,,5,27,46,27,5,48,,27,27,27,46,,3,,,6,,
   6,,5,,,,5,,,,27,,,23,,,26,26,26,,,21,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,3,,4,,4,3,3,,3,,3,,,3,18,3,18,3,18,3,17,17,17,18,
   18,3,,5,,5,,4,,,,4,,,5,19,25,19,4,,25,17,25,25,,19,4,,,,
   ,,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,
   ,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,33,9,21,
   ,71,,21,71,80,80,19,9,,4,,,,,,21,5,19,26,26,5,21,,,26,
   19,26,,,,,,,,,,,,,,,,,,,,4,,,5,27,46,54,5,,46,25,25,25,54,,
   5,,,,,,,,,,,,,,,,,,,,,5,27,46,27,5,48,,27,27,27,46,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,27,27,,27,23,,,,27,27,,26,,59,,19,,,,,,191,
   59,12,72,5,18,18,25,79,191,11,26,,72,19,,,,,19,26,13,
   72,79,118,19,19,5,59,,,19,,,19,25,25,18,72,59,12,,,,,59,
   ,19,,118,,,46,,26,26,8,8,,6,7,,7,,,8,8,7,8,7,10,8,7,
   10,20,5,5,4,6,6,6,,,5,6,6,9,6,10,,,,,5,4,10,6,,6,,6,
   9,,,,,,,26,,,,25,32,26,32,,26,34,34,8,,8,8,,10,,,8,8,7,
   8,7,10,8,7,10,20,5,5,4,10,7,10,,,5,7,4,,7,,,,,,5,4,,
   10,,7,,10,,,,,,,,26,32,,,26,,26,,32,26,32,32,11,7,4,11,
   7,6,6,8,8,6,8,6,9,8,6,9,8,5,5,4,6,4,6,,5,8,6,6,,
   6,8,,,12,8,8,4,8,6,12,4,,6,,,5,,12,8,8,6,8,6,6,8,8,
   6,8,8,8,6,6,,6,6,,,,,,11,,10,,,9,,16,,,5,,5,,,6,,8,8,,
   8,,,,,,,5,,,,5,,,,,6,,,,,49,,,,,,49,,,,,,8,,7,,,8,8,7,8,7,
   10,8,7,10,20,5,5,4,6,6,6,,9,5,6,6,,6,,10,10,,,5,4,,
   6,,6,,6,,,9,,,,,26,34,32,32,26,,25,,34,26,,,6,7,11,11,
   8,8,6,8,6,9,8,6,9,8,8,8,4,6,6,6,,,5,4,6,5,4,,8,8,
   8,12,5,4,,6,8,6,,6,5,,,,8,12,12,8,6,8,8,6,6,8,6,6,
   6,8,8,,,,,34,9,,13,,,9,,16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,
   ,,,,,,,,,49,,,,,,49,,,,,,,,12,12,10,12,10,8,12,10,8,10,6,
   6,4,4,6,4,,7,6,6,4,7,6,10,10,10,,8,6,4,10,4,,6,,4,
   7,,7,,8,,,19,,,,6,,6,,,19,,,6,,,9,,10,,,11,,16,,,5,,8,,,,,
   5,8,6,5,,,,,,,5,,,,8,,,6,,,,,,,,,,,49,,,,,49,,,,,9,34,13,,,
   9,,16,,,5,,8,,,,,9,8,,9,,,,,,,5,,,,8,,,,,,,,,,,,,,49,,,,,49,,
   ,5,5,8,7,7,8,4,9,9,5,5,4,10,7,10,,,5,7,4,12,7,8,,,,
   ,5,4,8,10,,7,,10,12,,,,,,,20,16,44,44,27,27,18,27,16,
   28,16,16,5,5,5,8,8,7,7,7,5,5,4,10,7,10,,,5,7,4,12,
   7,9,,,,,5,4,9,10,,7,,10,12,,,,,,,18,44,44,44,18,16,20,
   16,44,28,44,44,7,4,7,4,5,7,5,5,5,3,5,6,5,,,5,6,6,
   9,6,6,,,11,10,5,3,6,5,11,6,,5,9,,,,10,11,11,7,8,8,8,
   7,9,7,9,8,7,8,8,5,7,5,5,8,7,5,5,4,10,7,10,,12,5,
   7,4,,7,,9,9,,,5,4,,10,,7,,10,,,12,,,,,28,44,16,16,20,
   44,18,44,44,18,44,44,7,7,4,7,6,5,5,3,5,6,5,,6,5,6,
   6,6,6,,,,10,8,5,3,,5,10,6,,5,6,,6,,8,10,10,7,8,8,8,
   7,8,7,8,8,7,8,8,9,7,10,9,8,8,6,8,9,8,,10,8,9,6,
   10,9,11,10,10,,,8,6,11,8,,9,,8,10,,10,,,,,12,,,,12,67,
   18,67,,10,,,5,7,9,5,5,4,10,7,10,,12,5,7,4,,7,,8,8,,,
   5,4,,10,,7,,10,,,12,,,,,28,16,27,27,18,44,27,44,16,20,
   16,16,7,5,5,5,3,5,6,5,,9,5,6,6,,6,,6,6,11,10,5,3,,
   5,11,6,,5,,,9,,10,11,11,7,8,9,9,7,8,7,8,8,7,8,8,9,
   8,8,6,8,9,8,,10,8,9,6,10,9,10,11,11,,,8,6,10,8,,9,,
   8,10,,10,,,,,10,,67,67,18,,12,,,12,,,10,10,4,9,6,9,,,10,
   6,4,,6,9,9,9,17,12,10,4,9,9,17,6,,9,,,,,12,17,17,8,
   10,12,12,8,12,8,12,10,8,10,10,3,3,5,5,5,,,3,4,4,4,
   4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,26,26,4,5,,5,5,
   4,26,26,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,
   4,,,,4,,,,5,26,26,4,5,,5,5,4,26,26,4,3,4,,3,3,3,2,3,
   3,3,3,3,6,4,3,2,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,
   4,3,4,4,3,4,4,5,4,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,5,,,4,3,4,4,3,,5,5,8,
   8,4,3,,5,8,3,,5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,
   7,,6,5,5,4,6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,
   ,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,4,,,,
   9,,4,3,,6,9,,,6,4,,3,,6,,,31,6,,,4,6,31,6,6,5,9,9,5,
   4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,,7,7,4,26,5,5,,26,4,
   26,26,,5,5,4,,3,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,
   5,7,5,5,5,7,5,7,7,5,5,5,4,4,6,6,6,6,,4,2,6,4,6,4,
   ,4,4,,4,,,6,6,18,4,4,4,18,4,18,4,4,18,4,4,,,,,,6,,3,
   ,6,,4,,6,3,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,5,,,9,
   6,5,3,5,5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,
   5,5,5,5,32,8,,3,3,5,32,,,5,,,,,,9,9,6,17,7,7,,17,6,
   17,17,,7,7,3,9,,5,3,5,5,9,5,,5,,,,,8,32,32,,7,17,17,
   6,7,,7,7,6,17,17,9,,5,3,5,5,9,5,,5,,,,,8,32,32,,7,
   17,17,6,7,,7,7,6,17,17,8,,6,32,,6,8,,,,,9,,,,,7,,,,,,7,,
   ,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,,,22,6,,6,6,22,,,3,,5,,4,
   ,5,,,4,,,7,7,4,26,5,5,,26,4,26,26,,5,5,3,4,6,3,,4,3,
   ,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,32,,,5,,,,,,9,
   9,6,17,7,7,,17,6,17,17,,7,7,,5,,4,6,,6,,6,,,5,,,,5,,5,
   ,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,5,4,,,,6,9,9,5,5,7,7,5,
   5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,,6,,6,,6,,,5,,,,5,,5,,,5,,
   ,,4,,,9,9,5,9,6,6,31,,4,,9,31,6,6,,,,,,,,,,,,,,,,,,,6,,,
   31,6,,,4,6,31,6,6,5,9,9,,,,,,,,,,,,,,,,8,8,22,,6,6,,,22,,
   ,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,7,,,5,38,38,11,5,6,5,5,
   11,26,26,,,38,8,5,8,4,26,,,4,5,,38,,,5,8,8,5,,38,,,5,
   8,8,38,12,38,38,6,5,5,5,4,8,38,,,5,5,11,38,38,8,38,,
   ,26,,,5,5,4,3,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,4,4,
   6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,25,25,,,,
   25,25,25,25,4,4,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,
   4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,25,
   25,,,,25,25,25,25,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,18,18,
   18,18,18,18,18,18,18,18,18,18,,3,5,,6,6,7,6,7,6,6,7,
   6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,
   7,,,,,,25,25,25,4,4,4,,25,25,25,,,,,8,,8,,,,11,,11,5,,5,
   5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,8,6,8,,13,14,7,,,,56,56,
   26,26,26,13,13,23,113,,,,5,,6,6,7,6,7,6,6,7,6,9,4,6,
   4,4,6,4,,,6,4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,25,
   25,25,4,4,4,,25,25,25,,8,,,8,11,14,,8,7,11,5,,,5,5,,,,
   8,9,8,,8,9,9,,,,,5,,6,,6,8,6,6,8,,,,,,26,26,56,56,113,,
   ,,26,23,13,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,4,5,5,4,4,7,7,4,4,5,4,5,5,,,4,5,5,9,7,8,7,,
   15,,4,5,,5,,7,,7,11,11,8,,,13,,76,23,31,76,22,8,7,9,
   24,8,9,6,4,4,4,4,4,5,5,7,4,4,5,4,5,5,,,4,5,5,7,7,
   8,,,,,4,5,11,5,,7,8,7,,,,,,,,31,76,76,36,31,7,18,8,23,
   9,6,18,5,4,5,4,8,6,8,4,5,6,4,6,6,,,5,6,12,11,7,13,,
   ,,,4,6,,6,,7,,12,,14,,,,,,,67,,67,73,10,16,7,38,7,7,9,
   4,5,4,4,4,7,4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,,5,,7,
   8,7,11,,7,7,,,,22,31,36,24,76,18,6,7,76,6,18,7,5,5,
   4,5,8,4,5,6,4,6,6,,,5,6,12,,7,,,,,,4,6,14,6,,7,13,
   12,20,18,14,14,,,,73,,67,38,,16,9,10,67,7,9,16,7,6,8,
   7,4,10,8,4,8,8,,,10,8,7,18,7,,,,,,4,8,19,8,,7,12,7,
   13,,12,11,,14,,55,,,54,55,8,18,7,54,8,9,18,4,5,7,4,4,
   5,4,5,5,,,4,5,5,,7,7,7,,13,,4,5,,5,,7,,7,,11,,9,,15,,
   24,22,24,22,36,6,9,18,31,18,7,8,5,8,4,5,6,4,6,6,,,
   5,6,12,,7,14,14,,,,4,6,18,6,,7,,12,,,14,16,,,,43,73,38,
   43,67,9,7,16,,9,16,10,7,4,10,8,4,8,8,,,10,8,7,,7,12,
   11,,14,,4,8,,8,,7,,7,18,,16,12,,,,119,55,54,162,,18,9,8,
   ,9,18,8,6,9,11,6,11,8,,,9,11,10,,10,,,,16,,6,11,,8,,
   10,,10,,,,21,,16,,,,,,,10,9,7,,9,9,10,4,4,2,4,4,,,3,3,
   4,4,4,4,4,,5,,2,3,5,3,,4,4,4,5,5,4,4,,5,,18,17,17,
   18,17,4,17,4,17,4,4,17,4,4,4,4,,,4,5,5,5,5,6,,,8,,
   3,4,6,5,,5,5,5,6,6,,,,,,,24,,25,18,6,25,5,18,5,25,6,
   4,4,4,,,4,5,5,6,5,5,,,,,3,4,6,5,,5,6,5,6,6,,,,,,25,
   24,,,18,23,25,5,18,3,4,4,4,4,,,4,4,4,4,4,4,4,,,,2,4,
   5,4,,4,4,4,5,,4,4,,,,17,18,18,17,17,17,4,4,17,4,17,
   4,4,,,5,4,5,6,5,,6,,,,3,5,6,4,,5,6,5,6,8,8,6,,,,,,
   25,25,18,4,4,3,18,5,23,25,,,5,4,5,6,5,,5,,,,3,5,6,4,
   ,5,6,5,6,8,6,8,,8,,25,,25,,18,25,6,5,18,5,6,25,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   5,,5,,,,,,4,4,6,4,,5,6,5,,,5,5,,8,,18,,25,18,,25,5,6,
   24,25,6,5,5,,5,,,,,,4,4,6,4,,5,5,5,,8,6,6,,,,18,25,,
   18,,25,5,23,24,4,4,3,,4,7,7,,6,,4,5,,5,,4,,4,8,7,8,
   7,,6,,,20,20,,,4,19,6,,19,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,
   ,,6,,44,47,45,,,,7,18,72,13,5,6,7,7,,8,,4,5,,5,,4,,4,
   8,7,7,8,,6,,,20,20,,,5,7,7,,5,4,5,4,,71,,4,8,8,6,,7,
   9,7,,6,9,8,,12,,53,,72,51,,17,6,7,,9,9,,,40,,4,6,8,8,
   ,7,8,7,,5,,,,,,53,72,,51,,18,,7,,6,13,5,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,5,,7,8,,6,10,6,,,10,10,,,,29,,,,,,7,7,29,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,5,4,4,,5,,17,17,17,17,
   18,4,4,17,18,17,4,4,8,4,,5,,5,8,,6,6,,,,18,,25,18,24,
   4,3,4,,23,25,5,8,,,6,,,11,,9,,11,,,33,33,53,97,5,7,23,,
   ,7,,,5,,5,,,6,6,,,,18,25,,18,24,6,5,25,,6,25,5,,,,,,,,,,,
   ,,,,,,,,,,,,,4,7,7,,7,,8,,,20,20,,,4,5,5,,7,5,7,,8,,9,,,,
   ,44,47,45,,72,6,7,17,,9,,10,7,7,7,,,6,,,20,20,,,4,6,
   19,,6,4,19,,8,8,,,,33,47,,33,,11,8,,162,23,7,5,8,8,,,,
   37,,97,37,,23,5,7,,11,,7,4,,,,,,,72,25,7,17,6,26,10,9,
   9,,,,72,,,,25,7,18,,26,5,6,13,,,,,,,,,,,,,,,,,,,29,29,,,,,7,
   ,7,,,,,,,,,,,,,,,18,,18,25,18,,70,70,70,18,,,25,18,18,,70,
   70,55,,,70,55,70,,18,25,18,,70,70,70,,18,18,25,55,44,
   70,18,25,18,18,4,4,18,12,18,12,5,18,11,12,18,25,18,
   12,11,70,55,44,4,5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,
   12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,
   25,25,,,,25,25,25,25,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,
   4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,
   25,25,25,,,,4,25,25,25,,4,,5,4,4,6,4,6,9,4,6,9,12,4,
   4,4,4,6,6,7,,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,
   25,25,25,,,,4,25,25,25,,,,,8,11,8,,,,,,11,8,,5,6,9,,8,
   6,5,5,8,,6,,,7,,,,,9,6,,8,,8,,,,,,,,23,13,26,26,26,56,
   113,56,13,,,,,,4,4,6,4,6,4,4,6,4,6,4,4,4,4,4,4,6,6,
   4,4,6,,4,,,6,,,4,4,6,4,,4,,6,6,6,,,,,,18,18,18,18,18,
   18,18,18,18,18,18,18,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,8,,8,,,,11,,11,,5,,6,5,6,,,,9,8,,8,,,9,,,8,5,
   7,,,6,,8,6,8,,,,,,,,56,56,113,26,26,26,,23,13,13,4,4,4,
   5,5,4,4,7,7,4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,7,5,15,
   7,,10,,9,,,,,,18,6,36,76,24,22,31,24,9,9,8,7,4,4,4,4,
   4,5,5,7,4,4,5,4,5,5,,8,4,5,5,,7,,,7,,,4,5,9,5,,7,,
   10,8,7,,,15,,13,7,18,76,31,36,31,76,22,6,8,7,18,5,4,
   5,4,8,6,8,5,4,6,5,6,12,,,4,6,6,,7,,,,,,5,6,16,12,16,
   7,,7,,11,,,16,,,16,9,67,,38,73,,43,7,7,10,16,4,5,4,4,
   4,7,4,4,5,4,5,5,7,8,4,5,5,,7,,,9,,15,4,5,7,5,13,7,
   ,10,8,,,,,,,8,7,31,22,76,76,23,31,18,7,18,6,5,5,4,5,
   8,5,4,6,5,6,12,,13,4,6,6,,7,,,11,,,5,6,11,12,14,7,,
   7,13,,,,,,14,10,16,,73,67,,67,73,9,10,16,9,7,6,8,7,10,
   4,8,10,8,7,,,4,8,8,,7,,,18,,,10,8,11,7,,7,,8,12,18,,,,
   ,16,8,18,,55,54,55,,119,9,7,8,18,4,5,7,4,4,5,4,5,5,
   9,,4,5,5,,7,,,7,,,4,5,,5,,7,,10,,,,,,,15,9,8,22,24,31,
   36,24,76,7,18,6,9,5,8,5,4,6,5,6,12,11,,4,6,6,,7,,,
   16,,16,5,6,,12,,7,,7,,,,,,,16,7,10,73,43,,67,38,,16,16,
   9,7,7,10,4,8,10,8,7,18,12,4,8,8,,7,,,11,,,10,8,18,7,
   16,7,,8,,,,,,,,7,8,55,119,,,54,55,18,8,18,9,9,6,11,9,
   11,10,,,6,11,8,,10,,,26,,15,9,11,26,10,16,10,,10,,,,,15,
   ,16,7,10,,,,,,,9,7,10,9,4,4,4,5,5,,,3,4,5,,5,,,,,,4,4,
   ,6,8,7,,7,5,5,,,7,,,25,5,25,,18,18,,25,6,5,6,25,4,4,
   4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,5,4,,4,4,4,,,5,,5,
   17,4,18,17,17,17,18,17,4,4,17,4,5,4,5,,,3,5,4,,5,,,,,
   ,4,4,6,7,,6,,7,6,6,,,4,,,25,5,,,18,18,25,25,23,3,4,
   4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,6,,,,8,,7,
   6,25,,18,25,,24,18,5,6,25,5,5,6,,4,4,4,,5,,,6,,,4,5,
   6,5,4,5,,4,5,,,,,,7,4,4,25,18,25,,,18,3,23,25,5,7,7,
   4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,4,19,20,,,,20,,
   6,6,4,19,4,4,,5,,7,,,,,40,5,6,,,10,,,8,9,,,,6,,,18,,,,
   51,53,72,39,7,5,13,6,4,5,,,7,,,,,71,5,6,,,10,,,8,8,9,,,
   ,,,17,6,72,,51,53,,39,7,10,7,10,4,4,,4,,,4,,5,4,4,4,
   4,5,4,,4,4,4,,,,,5,4,17,17,17,18,18,17,17,4,17,4,4,4,
   ,5,,,6,,,5,4,6,5,7,5,,4,,6,,,,,4,23,25,,18,,25,24,18,
   5,4,4,3,,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,7,25,6,25,18,,
   25,,18,5,25,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,
   6,14,6,,7,,,,,9,,9,5,7,20,,,,20,,7,5,4,5,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,38,7,,7,,,,,,,
   ,,7,45,,,44,47,118,19,6,5,13,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,
   ,8,9,9,,8,,6,,,,,,,7,,,,29,,29,7,,,,4,,5,,5,,7,,,,,,,8,
   5,6,18,25,,25,18,,25,25,5,6,,5,,5,,7,,,,,,,,3,4,18,25,
   25,,18,,4,25,5,23,,,,,7,,,,,,,38,6,5,44,118,47,45,,,13,,
   7,19,,4,,7,7,7,,,6,,8,6,4,,,20,20,,,19,4,19,6,9,,,,,,,,,
   ,7,7,,,,29,29,,,,,,,7,7,7,,,8,,14,5,4,,,20,20,,,5,5,7,
   7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,19,,19,19,19,,,6,6,,4,,
   ,71,,10,10,7,53,39,,72,51,,10,17,6,7,,,36,,10,5,13,53,
   39,72,,51,,6,18,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,29,29,,,,
   ,,,7,7,,,,,,,,,,,,,,,,29,,29,,,,,7,7,,4,70,55,70,18,25,18,
   5,11,12,12,55,44,70,25,18,18,4,12,12,10,,,,18,,44,18,
   25,18,,,,,115,18,18,25,18,,,55,25,18,18,,,18,70,55,44,,
   18,70,70,55,25,55,44,115,12,10,13,4,5,4,5,6,6,5,,,,,
   10,,10,13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,9,6,,,,8,10,,
   ,10,9,,,,,41,41,,,,41,41,41,41,5,5,5,4,,3,,,6,6,7,6,
   7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,
   6,7,6,,,7,,,,,25,25,4,4,4,25,25,25,25,,,,6,4,6,6,4,4,
   4,4,4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,,6,6,4,
   4,,4,6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,,,
   ,9,,10,,,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,,,8,,,,10,,,
   ,,,41,41,5,5,5,41,41,41,41,,,,,,6,6,7,6,7,6,6,7,6,9,
   4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,,
   25,25,4,4,4,25,25,25,25,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,,,
   ,6,6,,9,,,,,,,6,,,,6,9,6,6,9,,,,,,,,48,48,48,,,,,48,48,
   48,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,6,
   6,9,,,,,,,,48,48,48,,,,,48,48,48,5,5,4,7,7,4,6,7,7,5,
   5,6,5,4,8,,,5,6,8,,9,10,,,20,,5,4,11,8,20,6,11,10,,
   10,,,,,,19,9,21,22,28,9,19,28,28,10,10,24,5,5,5,4,4,
   7,7,6,5,5,6,5,4,8,,,5,6,8,,9,,,,,,5,4,10,8,,6,10,10,
   ,13,,,,,,19,19,22,21,21,19,19,9,9,10,24,22,7,6,7,6,4,
   5,4,7,7,6,7,4,7,,,7,6,7,,12,8,,,10,10,7,4,6,7,10,4,
   6,6,16,9,,,8,9,9,6,7,7,7,7,7,6,7,7,6,7,7,5,7,5,5,
   4,6,5,5,6,5,4,8,,10,5,6,8,,9,,,,,20,5,4,13,8,20,6,,
   10,12,,13,,,,,9,19,21,28,22,19,9,19,19,24,22,24,7,7,6,
   7,8,7,7,6,7,4,7,,8,7,6,7,,12,,,,10,10,7,4,9,7,9,4,
   8,6,14,7,7,,6,8,9,7,6,7,7,7,6,7,7,7,7,7,7,7,5,4,
   7,7,7,6,7,7,8,,10,7,6,8,,9,10,,,,,7,7,10,8,,6,11,8,,,
   ,,,15,15,34,34,,45,45,34,34,10,10,9,24,23,5,7,7,5,5,
   6,5,4,8,,11,5,6,8,,9,13,,,20,,5,4,,8,,6,,10,,7,11,,,,,
   28,9,28,28,21,9,28,19,19,22,24,10,7,4,7,7,6,7,4,7,,
   6,7,6,7,,12,7,,,9,10,7,4,7,7,9,4,,6,,,9,,8,6,8,7,7,
   7,6,7,7,7,6,6,7,7,7,7,7,7,6,7,7,8,,11,7,6,8,,9,,,,,
   ,7,7,,8,,6,10,8,,13,13,,,,,10,34,45,10,,34,10,34,34,
   24,23,24,8,8,8,8,4,7,,8,8,8,7,,18,8,,,10,9,8,4,8,7,
   10,4,8,7,,,,,9,12,11,7,7,8,11,8,7,7,7,7,11,8,8,5,5,
   4,4,4,,,4,6,8,,8,5,,,5,,4,3,5,4,5,4,4,4,6,4,,,8,,,,
   4,24,25,6,4,,4,4,24,6,25,5,4,4,4,,,4,5,5,,8,5,,,5,,
   4,3,5,4,5,4,4,4,6,4,,,,,,,4,25,24,6,4,,4,4,24,25,6,
   5,4,5,,5,6,6,6,,6,6,,,8,8,6,4,6,5,8,4,5,5,,5,5,,6,
   5,5,6,6,5,5,6,6,6,6,6,6,5,5,4,5,,5,5,5,4,,8,,,,,5,
   4,4,4,4,5,3,5,4,6,,4,,8,,8,4,,25,6,24,,4,4,4,6,25,
   24,4,,,4,4,4,,6,,,,6,6,3,3,3,3,4,3,3,3,5,4,4,,6,6,
   6,4,4,4,4,4,4,4,3,3,4,4,4,,5,8,6,4,,8,,,,,5,4,4,4,
   4,5,3,5,4,6,,4,,,8,,4,,6,25,24,,4,4,4,6,24,25,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,6,,,8,,,,7,,4,3,5,4,5,4,4,4,
   6,5,5,,,,,31,5,,,8,5,31,4,4,7,7,8,5,4,,8,,,,,5,4,4,
   4,4,5,3,5,4,7,7,4,,,8,,4,,24,6,25,,4,4,4,25,6,24,5,
   ,6,5,,,8,8,5,4,5,5,8,4,6,6,,5,5,,5,5,6,6,6,5,6,5,
   6,6,6,6,5,5,6,,8,5,,,5,,4,3,5,4,5,4,4,4,7,4,7,,,,8,
   ,4,6,24,25,4,,4,4,25,24,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,
   ,,12,12,8,6,8,8,12,6,8,8,,8,8,,8,8,8,9,9,8,8,8,9,
   9,9,9,8,8,8,,,,7,4,4,4,4,5,3,5,4,7,6,5,,,12,12,5,
   31,,8,,31,5,4,4,8,8,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,6,5,6,5,5,6,4,7,5,9,,5,,,,,5,,,,,,5,5,5,
   ,,,5,4,7,5,6,6,5,5,9,5,,,,,,,5,,,,5,,5,5,,,,4,,5,,4,,
   8,,5,5,,,,8,4,4,6,24,25,4,4,,,25,24,6,4,4,6,3,,4,6,,
   3,,6,6,6,3,4,4,4,4,4,3,4,4,4,4,4,,,,6,,,5,,,,,,5,4,
   8,8,8,4,5,31,31,,,8,,4,,5,,5,5,,,,,4,4,25,24,6,4,4,,,
   24,25,6,6,,,,7,7,,,,,5,5,,,,5,5,,,,,,4,4,6,3,,,6,6,6,
   4,3,6,6,6,3,4,4,4,6,6,6,,,,5,,,,,4,5,8,,,5,4,31,31,
   8,8,8,,5,5,,8,,,4,4,24,25,6,4,4,,,24,6,25,7,7,,113,
   45,56,7,7,26,31,79,7,7,,,79,26,46,4,,,,12,4,31,8,8,7,
   31,4,5,5,,,,,12,,,31,4,,,,4,31,5,5,7,8,8,,,,,,,,,,,,,,,,
   5,8,,,6,,,,,,,,,6,5,,,,,6,,,,,,,6,,,,,6,,,,,,6,,4,37,37,25,
   4,3,4,4,43,25,37,37,25,37,3,4,4,4,25,37,37,5,5,37,
   37,25,25,4,4,4,8,25,37,43,43,4,4,4,37,25,37,37,4,4,
   4,4,4,4,25,37,37,4,4,43,25,37,3,37,37,25,37,37,25,5,
   8,5,,,5,,,,8,8,,11,7,8,,14,11,,8,5,5,9,6,8,6,,5,8,,
   6,9,9,,,,5,,,,,8,,6,,,,8,,,,23,13,,,,56,113,56,13,26,26,
   26,3,,,,,9,6,,9,,,6,,9,,,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,
   9,,6,,,,9,,,,48,48,,,,48,48,48,48,,,,,,,,9,6,,9,,,6,,9,,,
   6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,48,48,,,,48,
   48,48,48,,,,,,,9,11,,,8,10,,8,10,,6,5,6,,5,8,,,5,8,,6,,
   8,,,,8,9,,,,8,10,8,10,11,11,10,,,,56,56,,,,13,13,23,113,
   26,26,26,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,10,,10,7,13,,8,,,13,,
   ,8,,,,,9,12,11,,,,,,26,15,,,,,,,83,,,,,83,44,49,12,8,20,,
   6,,7,7,9,7,,,8,14,8,15,,,,8,,,9,9,,,228,,14,8,,,,10,,,,
   21,,,,,,46,120,,,,62,120,75,62,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,6,,7,,14,8,,8,,,9,,8,15,,9,,,,,228,15,
   8,17,,,10,13,,26,16,18,23,,,,62,120,,,,46,120,95,46,,8,,
   10,8,,10,,10,12,10,,15,,,,12,15,,,,,,,,11,10,17,,,12,18,
   12,19,16,14,19,,,,45,74,,,,45,74,,77,8,12,19,,,10,,13,,
   13,10,21,20,10,,22,15,,15,10,,,190,,,,,,,,,,,,,,,,,,140,,,,,,
   75,110,38,10,12,9,7,,12,7,12,7,,14,10,,7,,,11,9,,,,,,7,
   13,,,8,,,,,,24,,,,81,40,,,,55,40,35,55,,11,11,,,15,16,17,,
   15,,11,,18,11,,,11,19,,,,17,18,,,167,16,,21,26,27,,,,,,95,,
   ,,,,157,,,28,51,11,,,10,,11,16,,9,,10,,,10,8,,,,,,11,,,,
   10,13,,,,,,,,,97,97,,,,164,97,71,164,10,10,10,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,6,5,5,,6,6,,6,5,,,40,,6,5,
   4,,71,,,,8,7,,,,,,63,14,,,,25,98,58,51,5,26,7,6,5,6,,4,
   ,6,6,,6,5,,,22,,6,5,,,,4,4,,8,7,5,,,,,39,14,,,,14,39,
   39,39,4,5,5,5,6,,5,,,6,,6,5,5,,,40,,,6,,117,6,7,6,,,
   7,8,,,,25,98,,,,63,14,62,77,7,26,5,,7,,,5,,,6,,7,,,,5,
   5,6,,20,5,6,5,8,8,8,8,,,,47,47,,,,47,47,13,13,,5,,8,5,
   ,6,,,,,8,,,71,6,5,7,,22,6,7,5,10,9,7,9,,,,62,63,,,,98,
   77,25,14,7,5,26,5,,,8,,8,7,,,,51,,,6,,,,,,,,,,,,,25,,,,,
   47,84,,,7,17,7,,5,,,5,,7,,28,55,5,4,6,,20,4,4,4,8,7,
   6,6,,,,45,17,,,,17,37,13,13,,6,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,6,,6,4,,,,22,,6,7,,,6,7,6,,,7,8,,,,14,39,,,,39,14,
   39,39,5,5,4,,,5,8,,71,,6,5,7,,36,6,7,6,9,7,9,10,,,,
   98,77,,,,62,63,14,15,26,5,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   5,8,,,,6,5,7,,24,6,7,6,10,7,7,10,,,,51,51,,,,51,51,15,
   15,5,4,5,5,,55,28,4,5,5,,19,5,6,5,6,7,7,8,,,,17,37,,,
   ,45,17,13,13,6,6,,,51,,,6,,,,,,,,,,,,,,47,84,,,,25,,,,7,
   17,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,71,,57,,,22,32,20,,,23,27,,,
   ,55,,,,,,71,71,48,,,,36,20,,,,,,117,39,37,,,,,,,71,,,,55,,
   55,117,,,,,,,,6,,6,,5,7,8,,,,25,58,,,,62,14,63,163,26,7,
   5,5,,,5,,5,,,6,7,,,,13,47,,,,47,13,47,47,,,5,,,,,,,,,,,,,
   64,19,,,,35,99,,,,28,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,71,117,,,
   ,55,55,,,,,,4,,8,7,,,,,,40,14,,,,14,40,40,40,6,10,10,,,,
   5,,,,,40,19,,,,19,40,,,,10,10,8,7,,,,,,58,25,,,,14,51,63,
   98,5,7,26,,9,10,,,,27,,,,,,19,,215,32,9,6,8,9,,,,26,,,,,,
   15,70,189,,,7,,,,,,15,,,,15,,49,49,7,,,,,,,27,,,,18,,,134,
   6,9,32,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,47,,,,31,41,31,40,
   22,22,37,,,,41,21,31,47,52,23,20,,,,,,,,,,,,,,,,,,,,,,,,,47,
   47,21,37,19,23,40,31,24,20,32,41,20,37,22,32,32,20,5,
   5,5,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,4,
   4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,25,25,25,,,,4,25,
   25,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,
   6,7,6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,
   4,,4,,6,7,6,,,7,,,,,25,25,4,4,4,25,25,25,25,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,11,8,,,,,,11,,6,
   9,5,5,8,13,,,,6,14,8,,8,6,,,5,5,,,,6,7,8,,,8,6,,,,,,
   13,23,13,26,26,26,,56,56,113,4,4,4,5,5,4,4,7,7,4,4,
   5,4,5,5,11,,4,5,5,,7,7,7,,15,,4,5,,5,,7,9,7,,,,,,13,,
   18,7,6,18,9,24,36,22,8,24,22,31,4,4,4,4,4,5,5,7,4,
   4,5,4,5,5,,11,4,5,5,7,7,,,,,,4,5,,5,,7,7,7,,,,8,,,,6,
   18,18,7,6,36,76,24,7,22,31,76,5,4,5,4,8,6,8,4,5,6,
   4,6,6,,,5,6,12,14,7,14,14,18,,,4,6,,6,,7,16,12,,,,,,,,
   9,16,9,16,7,38,67,43,10,43,73,,4,5,4,4,4,7,4,4,5,4,
   5,5,,,4,5,5,,7,,8,11,,,4,5,,5,,7,,7,,,7,8,,,,9,6,7,8,
   18,76,31,36,18,31,76,23,5,5,4,5,8,4,5,6,4,6,6,18,
   20,5,6,12,14,7,,,14,,,4,6,,6,,7,14,12,,,,13,,,,7,9,16,
   10,9,67,,38,16,73,,67,7,6,8,7,4,10,8,4,8,8,,18,10,8,
   7,16,7,11,12,,,,4,8,,8,,7,12,7,,,,,,14,,9,18,18,8,9,54,
   ,162,8,119,55,,4,5,7,4,4,5,4,5,5,11,11,4,5,5,8,7,
   7,8,,13,,4,5,,5,,7,,7,,,9,,,15,,8,9,8,9,7,31,22,76,6,
   76,23,24,5,8,4,5,6,4,6,6,14,,5,6,12,,7,,13,,,,4,6,,6,
   ,7,,12,,,11,,,,,7,7,10,7,16,,73,67,9,,67,38,7,4,10,8,
   4,8,8,,13,10,8,7,12,7,,,19,14,,4,8,,8,,7,11,7,,,18,12,
   ,,,8,9,8,7,18,,55,54,18,55,,54,6,9,11,6,11,8,,,9,11,
   10,,10,,,,16,,6,11,,8,,10,21,10,,,,,,16,,9,9,10,7,9,,,,
   10,,,,4,4,2,4,4,5,,3,3,4,4,4,4,4,,5,,2,3,,3,,4,4,4,,
   ,4,4,,5,,17,4,4,17,4,17,18,17,4,17,17,18,4,4,4,4,,,
   4,5,5,5,5,,,6,8,,3,4,,5,,5,5,5,,,,6,,,,25,6,25,6,5,
   25,,18,5,18,,24,4,4,4,,8,4,5,5,6,5,6,8,8,,,3,4,,5,,
   5,6,5,,,6,,,,,25,25,4,4,3,25,24,18,5,18,,,4,4,,5,4,4,
   4,4,4,4,4,5,,,2,4,,4,,4,4,4,,,4,4,,,,4,17,17,4,4,18,
   17,17,4,17,18,17,4,8,,5,4,5,6,5,,,6,,,3,5,,4,,5,6,5,,
   ,,5,,,,4,4,25,25,5,,,18,3,18,25,24,,,5,4,5,6,5,8,6,8,
   ,,3,5,,4,,5,6,5,,,5,,,8,,6,25,6,25,5,,24,18,5,18,25,,
   ,6,8,7,8,7,5,6,11,,,5,6,,8,,7,8,7,,,9,,,,,11,,23,7,
   5,97,,37,7,37,,,6,6,8,8,7,,,,,,5,6,,6,,8,8,7,,,9,8,,,,
   23,7,11,,8,,,37,5,37,47,162,4,5,,5,,6,6,,,4,4,,4,,5,,
   5,,,5,5,,8,,5,25,6,5,25,,18,25,6,,24,18,5,8,5,6,,6,,,
   4,4,,4,,5,6,5,,,6,6,,,,5,23,4,3,4,24,18,25,25,,,18,8,
   4,7,7,,6,,4,5,,5,,4,7,4,,,,,,6,,19,4,4,6,19,20,,,6,,
   20,,,,9,,,,4,,,6,,7,4,7,,,8,9,,10,,10,9,7,6,17,,25,72,
   9,,,26,7,7,,8,,4,5,,5,,4,7,4,,,,,,6,,7,5,4,5,5,20,,,7,
   ,20,,4,8,,,4,,,5,,7,,7,,,,8,,40,,6,13,18,7,,,,51,5,53,
   72,,8,12,,4,5,,,,7,8,7,,,,9,,71,,9,9,17,7,6,72,,51,,53,
   ,,11,,5,6,,6,,,9,,,,5,6,,7,,,7,5,23,7,33,97,53,,,33,,,
   5,,,8,,6,,6,,,6,,,,,7,,,,,,29,29,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,,4,,4,4,4,,,4,4,,5,,4,4,4,4,17,17,17,18,17,18,17,
   17,,4,,5,,5,,,6,6,,,,3,4,23,5,25,,18,,4,25,24,18,,,,,,,,,
   ,,,,,,,,,,,,,,,,,5,8,5,,,6,6,,,,5,6,25,5,6,24,18,,25,25,,
   18,,,,,,,,,,,,,,,,,,,,,,,8,4,,,,,,8,,5,4,5,7,7,20,,,5,,20,,,,
   ,,,,10,,5,6,7,,18,,25,,13,72,,26,,,,,,6,,6,4,4,19,6,20,,
   ,19,,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,13,5,,18,7,45,,
   ,6,44,47,72,,10,,9,,6,17,7,45,72,,10,44,47,,,,,,,,,,,,,,,,
   ,,,,7,7,,,,,29,,29,,,,,,,,,,,,,4,12,18,11,18,25,18,5,70,
   70,70,18,12,12,25,18,18,4,70,70,55,4,4,70,55,70,12,
   18,25,18,5,70,70,70,11,18,18,25,55,44,70,18,25,18,18,,
   ,18,,18,,,18,,,18,25,18,,,70,55,44,,,,,,,,9,6,,9,,,6,,9,,
   ,6,6,6,,9,6,,6,6,,6,,,,,,,6,,,,9,,6,,,,9,,,,48,48,,,,48,
   48,48,48,,,,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,
   4,7,7,6,,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,25,25,25,4,4,4,,
   25,25,25,6,17,,9,,10,,,10,13,8,9,,6,,8,,10,,,6,,9,8,,5,
   ,,,,8,,,,12,,,5,,,10,,,,5,5,41,41,41,,,,5,41,41,41,,,9,,
   10,,,9,,16,,,6,,8,,10,,,6,,,8,,10,5,,,9,8,,,,12,,,,,,,,,,,,
   41,41,41,5,5,5,,41,41,41,5,5,4,7,7,4,6,7,7,5,5,4,
   5,6,8,7,,5,4,8,11,6,,13,,,,5,6,,8,,9,,10,11,,,,,20,,
   22,24,9,19,28,28,21,28,10,28,9,19,5,5,5,4,4,7,7,6,
   5,5,4,5,6,8,,12,5,4,8,13,6,,,13,,,5,6,,8,,9,,10,10,,,
   ,20,,20,24,22,19,19,9,21,22,28,24,9,19,19,7,6,7,6,4,
   5,4,7,7,4,7,6,7,,,7,4,7,9,4,,7,7,6,8,7,6,,7,8,12,,
   6,6,,,,10,9,9,7,7,7,6,7,7,7,6,7,7,7,6,5,7,5,5,4,
   6,5,5,4,5,6,8,13,,5,4,8,,6,,,10,,,5,6,,8,,9,,10,,,,10,
   ,,,10,24,19,9,19,22,21,21,22,19,19,9,7,7,6,7,8,7,7,
   4,7,6,7,7,14,7,4,7,7,4,,,9,8,6,7,6,,7,9,12,,6,8,,,
   8,10,10,9,7,7,6,7,7,7,7,7,7,7,6,7,7,5,4,7,7,7,7,
   7,6,8,13,,7,7,8,13,6,,,,,,7,6,,8,,9,,8,11,,,10,,,,24,
   23,34,34,10,45,,10,24,10,34,34,5,7,7,5,5,4,5,6,8,10,
   ,5,4,8,,6,,10,11,,,5,6,,8,,9,,10,,,,11,,20,20,10,10,9,
   28,19,21,28,22,24,19,9,28,7,4,7,7,4,7,6,7,9,16,7,4,
   7,,4,,8,6,9,8,7,6,,7,9,12,,6,,,,6,10,10,10,6,7,7,7,
   6,7,7,7,7,6,7,7,7,7,7,7,7,6,8,,,7,7,8,,6,,10,10,15,
   ,7,6,,8,15,9,,8,10,,,11,,,,9,24,34,10,34,,45,45,23,34,
   34,10,8,8,4,8,8,7,,,8,4,7,,4,,8,8,12,9,8,8,,7,11,18,
   ,7,8,,,8,9,10,10,11,8,7,7,7,8,8,11,8,7,7,7,4,4,4,
   5,5,5,,4,3,4,5,4,,4,,,,4,6,,4,8,8,,8,4,,,,5,5,,25,
   24,4,,4,6,25,24,6,4,4,,4,5,5,4,7,7,4,4,4,4,3,,,4,8,
   ,4,6,,8,,8,,4,5,,,5,5,,5,25,6,,4,4,24,25,6,24,4,,4,
   4,4,4,,6,3,3,3,3,3,,4,4,6,6,3,4,,4,6,6,,4,3,,,,4,
   6,6,4,4,4,4,3,4,4,4,4,3,4,4,5,4,,6,4,4,4,4,3,,,4,
   ,8,4,5,,5,8,8,,4,5,,,5,5,,5,6,25,,4,4,25,24,6,24,4,
   ,4,5,5,,5,4,5,5,4,,5,5,5,5,6,6,,6,6,6,,6,6,,,6,8,
   8,8,5,5,6,6,6,5,5,6,6,6,6,6,5,,4,3,4,5,4,,4,,,,4,
   5,,4,,8,,5,4,,,,5,5,,24,25,4,,4,25,6,24,6,4,4,,7,4,
   4,4,4,3,,6,5,,,4,5,,,12,8,,5,5,,,,5,,7,,,31,5,4,8,7,
   8,,4,31,5,6,5,7,7,6,,7,,45,113,6,,,6,56,,,,6,,,,9,9,,
   79,26,7,,7,26,79,31,46,7,7,,4,5,,4,,5,5,,,5,5,,4,,8,,
   4,,,,4,,5,5,24,25,4,4,,25,6,24,6,,4,4,4,4,3,,,3,6,6,
   4,4,,4,6,6,,3,,,,3,6,6,4,4,4,4,3,4,4,4,4,4,4,4,3,
   7,4,,5,5,,,8,6,,4,8,8,,4,,,,4,,5,5,25,24,4,4,,6,25,
   24,6,,4,4,,,5,,,12,,5,,4,,8,,5,5,,,5,,5,7,7,8,4,5,31,,
   ,,8,31,4,5,,3,,6,6,4,4,,3,6,6,,4,4,,,4,6,4,6,6,6,
   3,4,4,6,6,6,6,4,3,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,12,,5,
   6,,,12,8,,4,,,,5,7,,5,8,8,31,4,5,,,8,8,5,31,4,,,5,6,,
   4,,8,,,5,,,6,7,5,,,,4,31,5,8,8,8,8,5,4,31,5,,5,,8,5,
   8,,,,,,,,,,,,,,,,6,,6,,,,8,6,,,8,8,,8,,,,,,,,,,,,,6,,,6,,,,5,
   ,4,,8,,4,,,,4,,5,5,24,6,4,4,,24,6,25,25,,4,4,,5,5,6,
   ,5,5,,,5,8,8,8,6,5,6,6,6,5,6,5,5,6,6,6,,,,,,,,,,,,,,,,
   ,,,,,,,,,,8,,4,5,,,5,5,,5,6,24,,4,4,6,24,25,25,4,,4,8,,
   ,,,,,,,,,6,,,,,6,,,,,,,8,8,,,8,12,12,12,8,8,9,9,9,8,8,
   8,8,9,9,9,,,,,,,,,,,,,,,,,,,,,4,,,,5,5,,24,6,4,,4,24,6,
   25,25,4,4,,,,4,,7,5,7,7,5,4,31,,8,,8,31,5,4,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,5,7,,8,8,5,31,4,8,,,8,4,5,31,6,6,,,
   5,5,,,,,,,5,5,6,,,,5,5,,,,,5,,5,,,5,,5,,,,,5,5,,5,25,37,
   43,4,4,4,8,43,25,37,37,37,25,4,4,4,5,25,37,37,4,4,
   37,37,25,37,4,3,4,4,25,37,43,25,4,4,3,37,25,37,37,3,
   4,4,5,5,4,37,37,25,8,4,25,37,37,4,37,25,43,37,37,25,
   4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,9,9,,,,,10,13,,22,,,,,,10,22,16,19,15,16,,,,,
   ,10,10,12,,22,12,18,,31,,,,,,,75,38,10,13,105,53,,84,,,,,
   6,,,8,,8,12,,7,,7,,,,10,7,17,18,11,13,,26,209,,,7,10,,,
   8,11,,,15,,,,,,55,35,,11,,78,35,81,78,,,,9,,,,,10,13,,,10,
   10,,19,12,,22,12,,,,,20,,,,,10,16,190,22,,,,,30,,,,,,105,
   13,27,38,75,84,,53,,,,,,6,,6,,,7,13,10,,,17,13,7,,,8,,,,,,
   ,10,8,,,7,17,14,,12,,19,,,,40,45,9,,9,45,45,40,45,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,8,12,,7,10,7,,18,11,,7,,,11,13,,17,,,,
   7,9,17,,8,,,,,,24,,,,81,78,,,,35,78,55,35,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,10,,12,,6,,,,,12,,,8,11,,,,,,6,7,,
   ,12,,16,,,,24,,,,59,49,10,8,10,49,49,59,49,,,,,,,,,,,6,6,
   6,8,6,4,,,71,,,5,5,6,36,6,7,6,,,9,9,,,,63,62,7,26,5,
   58,163,25,14,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,
   6,6,6,8,6,,,,,,,5,5,6,22,6,7,6,,4,7,,,,,39,39,5,5,4,
   39,39,14,14,,,,,,,5,6,6,6,8,6,,,,,117,,5,5,5,40,6,7,6,,
   ,6,,,,,62,63,26,7,5,98,77,25,14,,,,,,,5,5,5,7,5,,,,,,,
   5,4,5,20,5,6,5,,8,8,6,,,,47,47,,,5,47,47,13,13,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,10,10,10,8,,,,,,,7,8,9,43,
   10,9,8,,,11,,,,,,,32,9,6,134,,27,17,,,,7,7,9,9,7,,,,,,,
   6,7,6,41,8,8,7,,,,,,,,,70,,,7,116,,26,15,,,,6,5,,,,,,,22,,
   ,4,6,71,6,5,,,,7,,,,,25,98,5,7,26,63,14,62,77,,,,,10,
   6,7,,8,22,,,5,5,,,4,7,6,,7,,8,,,,39,14,5,4,5,14,39,
   39,39,,,,9,6,7,,8,20,,,5,5,,117,,6,6,,7,,8,,,,63,14,7,
   5,26,25,98,58,51,,,,,,,,,31,,,6,10,,10,,,,,12,,,,,27,134,
   6,9,32,,17,,,,,,7,,,,24,,6,4,6,,6,,,,7,7,,,,,15,51,4,5,
   5,51,15,51,51,,,,,,,,,5,5,7,51,7,,7,,,10,10,,,,64,,7,31,,
   ,164,35,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,5,8,,8,,5,,,
   11,,,,,,,7,17,7,,27,84,29,,,,,,,19,40,,22,,71,,,41,,,,,71,,,
   ,,,48,55,71,,,,,20,28,71,,,23,36,,,,56,,,,,55,,,,117,,71,
   55,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,5,,5,,,,,6,,,,,13,47,5,,,47,
   13,47,47,,,,,55,,7,5,,6,,7,,,,17,13,,6,6,13,17,45,31,,,,,
   ,9,6,,7,5,8,,,,58,25,26,5,7,14,51,63,98,,,,,,,,32,,,,,,
   55,55,,,,71,117,,,,,,8,6,,7,,8,,,,40,14,10,6,10,14,40,
   40,40,,,,,,,11,,,,,26,116,7,,,70,15,,,,,,,7,7,,,,,14,62,5,
   26,7,77,15,98,63,,,,,,,,,,,,,,,,,,,,,,8,,,,,40,,10,10,,,40,
   19,19,,,,9,,,,,26,,8,,15,,81,124,,,,,,,127,,7,17,7,,25,,47,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,47,37,19,22,31,41,31,
   40,,,,19,37,23,41,21,31,47,,,,5,5,23,32,22,20,,,,5,52,
   32,22,24,,,,20,20,37,32,,,,47,47,21,,,,40,31,,,,41,,,,,,,,,,
   ,10,,,9,,8,,11,8,10,8,,9,6,5,,11,10,6,,8,11,8,8,,,,,,
   5,,5,,6,10,8,,8,,10,,,,26,26,13,23,13,,,,26,56,56,113,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,5,6,6,5,
   6,5,5,6,7,8,6,8,4,16,,7,8,8,15,7,,13,,,,6,8,15,4,,
   7,15,10,,20,,,,,,,56,8,18,8,10,7,8,113,113,168,55,8,8,
   8,6,5,6,6,7,6,7,8,6,8,4,,17,7,8,8,13,7,,,,,13,6,8,
   20,4,,7,,10,16,,,,,,18,55,,18,7,8,7,18,10,56,168,55,,6,
   4,6,6,7,4,7,8,7,6,8,6,6,,,7,6,8,13,7,14,,15,,,8,6,
   19,6,,7,17,6,17,,,,,,,74,38,7,10,10,28,10,30,46,84,,74,
   8,6,8,8,6,7,6,7,8,6,8,4,,16,7,8,8,,7,,,20,,,6,8,,4,
   18,7,,10,17,,13,,13,,,168,55,7,10,18,18,8,7,,55,,56,6,
   6,4,6,5,8,7,6,8,6,6,15,,7,6,8,,7,,,,,,8,6,,6,,7,14,
   6,,15,,14,,,,,74,10,28,7,10,7,28,38,,74,38,5,4,4,5,7,
   8,7,7,7,4,8,10,8,7,8,9,7,10,9,10,,,7,7,11,4,,7,9,
   6,9,10,9,10,,,15,29,112,19,8,10,8,19,6,32,34,29,112,
   8,6,5,6,7,8,6,8,4,20,,7,8,8,,7,13,,15,,,6,8,,4,,7,,
   10,,16,15,15,,,,113,168,10,8,7,8,8,18,55,,56,113,6,7,
   8,7,6,8,6,6,,17,7,6,8,,7,,14,19,,,8,6,15,6,,7,,6,,,
   13,17,,,,84,,28,30,10,7,10,10,74,74,38,46,5,7,8,7,7,
   7,4,10,9,8,7,8,9,7,9,10,11,,,7,7,10,4,15,7,10,6,10,
   8,9,9,,,,34,29,8,6,19,19,10,8,112,29,112,32,6,8,8,6,
   8,4,,,8,8,7,,8,18,18,20,,12,6,8,20,4,15,8,20,7,,,,20,
   12,,15,,154,7,7,8,7,8,7,158,,154,158,5,5,4,4,4,6,,6,
   4,7,,7,,6,,,,4,4,6,3,7,5,6,5,6,6,8,8,8,,,,25,5,25,
   6,6,25,5,18,25,18,,5,5,5,4,8,8,6,7,7,7,6,7,,7,,,6,
   5,,4,8,4,7,5,,7,,7,8,,6,,20,19,4,6,4,19,6,,,,20,4,4,
   4,,6,5,5,4,6,5,6,8,8,,7,4,4,6,4,,5,8,4,6,,6,,4,,,
   18,25,4,4,3,25,5,23,25,18,,,5,4,,6,5,5,4,6,5,8,8,6,
   ,7,4,4,6,4,8,5,,4,6,,6,,7,,8,18,,25,6,5,25,5,6,25,
   18,,24,4,6,,7,4,7,8,6,,6,,,,4,5,6,3,4,5,6,4,6,8,8,
   6,,,,,,5,25,23,4,4,3,18,25,18,25,5,5,4,3,4,5,4,6,5,
   6,,5,3,4,5,2,5,4,5,4,5,6,5,6,5,,,17,18,4,17,4,17,
   4,4,17,17,17,18,8,7,8,5,8,7,10,10,9,,10,6,,8,6,,7,
   6,8,10,,9,,7,,14,19,,19,8,5,,6,11,78,37,,,,6,6,6,,,9,,,
   ,6,6,9,5,7,8,8,6,6,10,7,9,,,,,,6,,78,7,15,5,37,78,
   37,54,5,7,,4,,7,,,8,5,5,7,4,6,6,7,5,8,8,7,7,,,8,,,
   4,6,19,19,6,4,20,,20,,7,8,5,6,,6,,,4,4,,4,,6,6,4,,6,
   8,6,,,4,25,18,4,3,4,5,23,25,25,,,18,6,7,10,10,10,,,7,
   4,10,4,8,7,5,4,6,5,6,5,,,8,,19,6,6,,6,,6,19,,19,19,,
   ,10,,,,8,6,10,5,10,7,8,6,7,9,6,10,,,,135,61,5,7,15,,
   20,6,37,,37,,,7,,,14,5,5,7,4,8,6,7,5,8,7,7,8,9,,9,,,
   4,5,5,7,7,5,20,,20,,8,6,,,6,8,8,5,7,7,10,6,9,10,10,
   8,,,,,,6,78,,15,7,5,37,54,37,78,8,,,,6,6,6,,,8,6,,10,,
   10,,,7,54,37,15,5,7,6,,78,78,,,37,,,6,6,8,5,10,7,9,8,
   9,8,10,10,14,,130,,78,5,19,8,11,,7,37,54,37,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,8,4,14,5,9,9,7,7,,7,,10,,,,,29,,,,7,,7,29,,
   ,,5,,4,,7,8,5,,6,,6,,,7,25,18,6,5,25,5,6,25,,,25,18,
   8,4,,5,,4,6,,6,8,7,,,18,,25,23,5,4,3,4,,18,25,24,6,
   130,,10,8,,9,,9,,,10,54,37,11,7,,5,8,19,,,78,37,,4,6,
   4,5,5,5,5,5,,5,17,17,17,4,4,4,4,17,18,17,18,17,9,,,,
   14,,,,,,29,29,,,,7,7,,,,,,8,5,,7,,7,14,,8,,20,7,5,7,4,
   5,5,,,,20,,9,,10,,10,,,19,,78,,6,7,5,15,,37,78,,6,8,6,,
   7,,,18,25,6,25,5,6,5,25,,18,25,,8,6,8,,,7,78,33,7,5,
   15,6,78,,54,,,33,8,6,10,,,37,,,11,6,19,5,8,,19,,78,8,,,
   10,,33,,6,20,5,15,7,,135,61,33,7,,,37,78,7,15,5,78,6,,
   ,19,,,,9,,,7,7,,,,,,,29,29,,,,,,,,,,,,,,,,7,,7,,,,,29,29,,,
   44,55,115,18,25,18,,,,,55,70,44,25,18,18,,,,18,4,4,12,
   10,12,70,18,25,18,5,12,12,11,70,18,18,25,10,13,12,55,
   25,18,18,4,4,18,44,55,70,5,18,115,44,55,25,55,70,70,,
   18,,,,,,,6,9,9,,,6,,9,,,6,6,6,,,,,6,6,,9,,,,,,,6,,,,6,9,
   6,6,9,,,,,,,,48,48,48,,,,,48,48,48,,,,,,,7,10,10,,,,13,22,,
   ,,13,10,15,,,,10,,,,,,,21,,15,,,10,20,,,,190,,38,10,,75,,,,
   ,12,,140,110,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   9,6,9,,7,8,7,,,7,12,7,,,,12,7,,,8,,9,13,,,,7,,,,11,24,,
   10,14,,,,,,,11,55,35,40,,,,11,81,40,55,,9,,,,,9,,12,10,,,
   15,26,10,7,13,,,,8,11,,,,,,13,,,,,8,,,,,,,12,8,,44,83,,,,
   20,,83,49,,,6,,7,15,,8,,8,,16,26,14,8,15,18,10,,,17,,,,
   8,,,,9,23,,9,,,13,228,,,,8,46,95,120,,,,,62,120,46,,9,,,
   17,,18,17,18,,27,26,15,,11,,16,19,11,,,,,16,,15,,,,21,11,,
   ,,,,167,28,51,,,157,,,,11,95,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,7,14,,8,14,8,,21,,,8,,,10,,9,,,,,8,,15,,9,,,,,
   ,,,228,,,,62,75,120,,,,,46,120,62,10,11,,10,10,12,,16,19,
   10,,15,14,12,,,17,,,,12,,15,,,19,12,,,,18,,,,8,12,45,,74,,,
   ,19,45,74,77,,,11,,10,,,,,11,,,10,,8,,,,,10,,16,,10,,,9,,,
   13,,,,10,10,164,71,97,,,,10,97,97,164,,,,,,5,,6,5,6,7,6,
   ,4,,,,,6,,6,,6,8,6,5,,,,40,71,,26,7,62,63,14,,,,5,25,
   58,163,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,5,6,
   5,6,5,5,,,,5,,5,,5,7,5,4,,,,20,,,,,47,47,13,,,,5,13,47,
   47,,,,,5,5,6,7,6,5,5,6,,,,6,,6,,6,8,6,5,,,7,40,,117,
   7,26,63,62,14,,,,5,25,98,77,,,,6,5,6,7,6,,4,7,,,,6,,6,
   ,6,8,6,5,,,7,22,,,5,5,39,39,14,,,,4,14,39,39,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,7,8,7,,7,,,,,7,,9,,7,9,7,7,,
   ,,41,,,,,,70,15,,,,7,26,,189,8,8,9,9,8,,6,,,,,8,,10,,10,
   10,8,8,,,,43,,,32,9,,,19,,,,6,27,,215,5,6,,,,5,4,,,,,,6,,
   6,,,5,5,,,,40,71,5,26,25,58,98,,,,7,63,14,51,,8,5,7,,6,
   ,,,5,,,,6,8,5,,7,,6,,,20,,5,47,13,47,,,,,47,47,13,9,6,
   8,5,7,,,,6,,,,,10,6,,8,,7,,71,36,26,5,62,14,63,,,,7,98,
   77,15,,,7,,,,,5,,7,,7,,,6,,,5,,23,,7,,15,49,,,,,,,15,49,,
   5,,,,,4,,6,,6,,,4,,,4,,22,,6,10,14,40,40,,,,10,40,14,40,
   5,,,,,,,8,,8,,,7,,,,,51,,7,17,25,,,,,,7,47,84,,5,,,,5,,,,
   5,8,5,,7,,6,28,55,19,6,6,45,13,17,,,,,17,37,13,,,,,,7,,
   7,,,6,6,,,,57,,,28,35,,99,,,,7,64,19,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,4,,,
   4,,22,,4,5,14,39,39,,,,5,39,14,39,,,,,,,,,,,,,,,,,,,,,,,,,,,
   9,5,5,8,,7,71,,22,7,5,98,25,77,,,,26,62,63,14,,,,,,,,,,,,
   ,,,,,,,,,,,10,6,5,8,,7,,,24,5,4,51,15,51,,,,5,51,51,15,,
   6,,,,,29,,6,9,18,,,,,,32,,27,134,4,,,,117,20,,5,7,14,63,
   51,,,,26,58,25,98,5,,4,55,28,20,,6,17,13,37,,,,6,45,17,
   13,,,51,,,7,17,47,,84,,,,7,25,,,,,,,,,,,,,,,,,,,,32,,,10,19,,
   40,,,,10,40,19,,,,,,55,55,,,,,,,71,117,,,,,71,71,,,,,55,,48,,
   ,55,,55,,,,,71,117,,5,37,19,24,,,,5,22,52,32,19,37,20,,,
   ,5,22,23,32,47,47,,,,23,31,41,21,40,,,,22,31,31,41,,,,
   32,41,21,31,,,,,,,,,,,,,,,,37,20,20,47,40,47,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,,,,,10,,,,10,22,16,,,,
   10,12,30,22,,,10,,,13,,20,,,,,,12,19,,,,,190,,,75,,84,13,
   38,27,,,105,53,,6,,,8,,8,,,7,10,7,17,,,,7,,,8,,13,9,,,
   12,7,17,,,11,24,,11,18,,,,,,,,35,55,78,,,,,81,78,35,9,,,,,
   10,,10,10,,22,12,31,,,,16,,22,,16,10,,,13,22,,,,15,,18,,,
   19,12,,,,,,105,,53,38,13,10,,,75,84,,,6,,6,,13,10,13,7,,
   12,,,10,,,7,,,8,,,,7,,,,8,19,14,17,,,17,,,,,,45,40,45,9,9,
   ,,40,45,45,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,10,7,,7,,15,,,7,17,,
   8,,13,10,,,12,7,26,,,11,,,,,18,11,,209,,,,78,81,35,,,11,,
   55,35,78,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,12,,,,,
   6,,,12,,11,7,,,10,12,,,,8,24,16,,,,,,,,,,49,59,49,10,10,8,
   ,59,49,49,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,6,6,,,,
   5,5,7,6,,,4,,,6,6,,,,,,,7,8,,5,22,,71,,,63,62,14,5,26,
   7,,25,98,77,5,5,5,,,,5,5,6,5,,5,5,,,5,5,6,,,6,,,6,7,,
   ,20,,,,,47,47,13,5,,,,13,47,47,6,5,,,,,6,6,6,,,5,,,,,,,,
   6,,6,5,,8,7,117,,40,,,98,25,77,26,5,7,,62,63,14,,7,,,5,
   ,,4,,7,5,,,6,6,8,,,6,8,6,7,10,10,7,,22,,,,14,39,39,5,
   5,4,,39,14,39,7,,,5,,5,,,7,,,,6,6,8,,,6,8,6,6,9,10,9,
   71,40,,,,14,63,51,26,7,5,,58,25,98,,,8,7,8,7,,,6,,,,4,,,
   ,7,,7,,,,,,,32,,,,19,40,10,,10,,40,,19,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,8,5,,,4,,,,6,,,
   ,5,6,5,,,7,6,,,20,,,47,13,47,,5,,,47,47,13,,,,7,5,,,6,
   6,8,,,6,8,6,9,10,9,6,,22,117,,,25,58,98,7,26,5,,63,
   14,51,,,10,,,,9,7,11,,,7,9,7,,11,12,11,,41,,,,15,81,,,,8,
   ,,26,124,,7,,,,6,6,8,,,6,8,6,8,10,10,8,,22,,,,14,40,
   40,10,10,6,,40,14,40,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,,4,,,,,
   7,10,7,,,,,,,51,,,,35,164,7,,31,,64,,19,,,5,5,5,,,4,7,5,
   7,8,6,7,28,20,55,,,13,45,17,,6,6,,17,13,31,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,9,6,,,8,7,,71,36,,
   ,58,25,163,7,5,26,,63,62,14,,,,6,,6,,,8,7,,,22,,,39,14,
   39,5,4,5,,39,39,14,,,,,5,,,,,,,,,,,84,27,7,7,17,,,,29,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,8,,,24,,,,,51,51,15,
   4,5,5,,15,51,51,,,,,,56,,,,,,,25,7,7,17,,127,,47,7,8,,,
   36,71,,,,77,98,15,5,7,26,,14,62,63,,9,8,,,41,,,116,26,,,
   7,,,,70,15,10,9,,,43,,,134,27,,32,6,9,,,,17,,31,,,,,,,17,
   6,32,9,,27,134,,23,,,,,70,,15,7,,,,26,116,,,,,,117,71,,,,,,
   ,55,55,,,,,55,48,,,,,71,,71,,,71,,117,,,,,55,55,,,,,,,,,,,,,,,
   ,,,,,,,,47,47,23,20,52,,31,41,21,40,22,37,22,,31,31,41,
   32,20,32,,41,21,31,5,5,,37,19,20,5,,22,23,32,,19,37,24,
   ,,,47,40,47,3,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,
   9,11,,,9,,4,4,,6,,9,,12,,8,,,,,,22,22,22,22,8,8,22,84,
   8,84,8,22,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,
   11,,,9,,4,4,,6,,9,,12,,8,,,,,,22,22,22,22,8,8,22,84,8,
   84,8,22,4,4,3,3,3,3,4,4,4,4,4,4,6,,4,4,4,,4,,6,,,,
   4,4,7,4,,4,8,6,8,,6,,,,,12,16,16,12,12,12,16,10,12,
   10,12,16,3,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,
   4,6,8,7,,6,10,9,10,10,8,,,9,,27,22,22,27,8,8,22,8,8,
   8,8,22,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,6,,,,,,4,6,
   8,7,,6,10,9,10,10,8,,,9,,27,22,22,27,8,8,22,8,8,8,8,
   22,3,4,4,4,4,4,4,4,4,8,,4,4,4,8,4,7,7,,,,4,4,,4,,4,
   ,6,,8,8,,,,,12,10,10,12,10,10,10,12,10,12,10,10,4,4,
   4,4,4,4,4,4,8,,4,4,4,,4,7,5,,9,,4,4,7,4,9,4,,6,,,8,
   ,,10,,12,5,5,12,8,8,5,8,8,8,8,5,3,6,6,7,6,7,5,,,6,
   7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,,,,,,,23,9,9,23,57,
   57,9,9,57,9,57,9,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,
   10,5,9,6,8,9,8,,,,,,,23,9,9,23,57,57,9,9,57,9,57,9,
   4,4,4,4,4,8,,3,4,5,6,5,6,7,,11,,4,4,6,4,8,7,6,7,
   6,6,,,,7,,77,5,7,77,7,8,36,8,9,8,8,31,4,4,4,4,,,4,
   4,4,6,4,6,,,8,,3,4,6,5,11,5,6,7,6,6,,,,,,77,7,36,18,
   8,8,31,8,7,7,23,6,4,4,4,,,4,5,4,8,5,6,,,15,,4,4,6,
   8,15,6,7,8,8,7,,,,,,19,9,22,22,6,9,18,9,9,6,9,9,4,4,
   ,,4,4,4,6,4,6,6,,,,4,4,5,4,7,4,6,6,6,,7,,,,,18,23,
   31,13,8,23,6,7,8,9,22,6,4,,,4,4,4,7,4,,11,,,,4,5,6,
   4,6,5,8,7,6,9,9,,,,,22,22,18,19,9,9,9,6,6,9,27,19,9,
   ,5,4,4,10,5,,6,,,,4,8,6,4,10,6,10,8,6,,4,,,7,,18,51,
   7,112,12,34,8,12,8,8,13,36,,7,9,4,9,6,8,9,,,,4,7,6,
   7,15,6,7,8,8,,,,,,,23,,,31,11,60,,13,15,10,137,11,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,,5,,8,,,,4,4,6,4,12,4,6,7,,
   ,4,,,7,,13,31,6,13,23,22,6,9,8,22,9,5,4,9,5,11,,,,,
   4,4,6,4,13,4,6,7,,11,7,,,,,19,18,9,13,9,27,19,9,9,
   26,26,4,,5,10,,,10,,5,4,10,4,8,5,6,8,7,6,7,,,7,,112,
   7,8,19,34,13,36,8,12,50,8,7,,,11,,,,,11,,6,15,8,,12,
   12,12,6,,,9,,27,18,10,50,,,8,12,14,63,17,13,6,6,,11,,
   7,6,9,6,,8,11,7,,8,6,,,6,,33,12,5,31,31,15,10,33,33,
   10,7,10,6,,,,6,7,7,6,15,8,12,9,,6,11,,,21,,37,129,16,
   37,,,13,16,11,39,53,,,68,,6,6,7,7,16,7,6,9,,6,,,,,,37,
   27,,37,15,12,,11,12,12,70,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,
   ,15,8,,8,,11,15,,14,,,,,57,,,,,,8,11,52,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,4,,4,,5,,7,,6,5,,,7,,13,6,6,18,22,9,5,22,23,
   23,7,7,7,4,,5,,8,11,,5,,,10,,13,9,19,19,27,26,4,26,9,
   27,9,9,7,,,6,,,12,,,,11,,37,8,14,89,39,16,10,,40,,11,12,
   ,5,7,8,11,11,,,,,,19,8,36,19,13,8,7,50,34,8,50,6,,,,,,
   16,,,,,57,13,,,,11,13,,,,,,,7,8,7,,,,,,31,5,10,26,15,7,
   10,10,31,29,29,11,,12,,,,,,,33,15,10,,12,14,9,,63,14,15,
   16,,10,10,,,9,,,8,8,,45,10,10,,,12,10,190,,7,,,11,,27,
   18,15,33,63,12,10,,27,,14,9,9,,,,,33,53,18,27,14,,10,
   14,15,12,,8,,,,,66,8,,23,15,11,,,,13,60,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,26,14,,,,,11,,8,,,,,,,,,,,,,22,33,,41,26,19,26,
   31,41,49,57,34,46,22,9,4,6,9,42,36,34,22,9,22,34,26,
   30,6,9,4,31,41,33,49,31,26,26,19,29,30,19,29,28,6,6,
   9,26,6,19,29,30,10,6,26,22,34,28,29,25,21,35,128,37,
   26,10,9,4,4,4,3,4,4,4,4,4,4,4,4,6,,,4,4,6,8,9,11,,
   ,9,,4,4,,6,,9,,12,,8,,,,,,22,22,22,22,8,8,22,84,8,84,
   8,22,3,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,9,
   4,4,8,6,,9,11,12,11,,,11,9,,,8,22,22,8,22,22,22,8,22,
   8,22,22,4,4,4,4,3,4,4,4,4,4,6,,11,4,4,6,,9,,,8,,9,
   4,4,8,6,,9,11,12,11,,,11,9,,,8,22,22,8,22,22,22,8,22,
   8,22,22,3,3,3,3,4,4,4,4,4,6,,8,4,4,6,5,4,8,,5,,,4,
   4,6,6,,4,7,6,7,5,,8,,,,10,12,12,10,10,10,12,10,10,10,
   10,12,4,4,3,4,4,4,4,4,4,,8,4,4,4,6,4,6,,7,,,4,4,,4,
   ,4,,6,,6,,8,,,,10,12,12,10,16,16,12,12,16,12,16,12,3,
   4,4,4,6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,
   8,,,9,8,27,27,8,22,22,27,8,22,8,22,27,4,4,4,6,4,6,7,
   ,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,8,27,27,
   8,22,22,27,8,22,8,22,27,4,4,5,4,5,4,,6,4,5,4,,4,8,,
   8,7,9,4,5,6,4,,4,5,6,5,,,6,9,,8,10,12,12,10,7,7,12,
   9,7,9,7,12,4,4,4,4,4,,,3,4,5,6,5,5,,,7,,4,4,6,4,,
   7,6,7,5,5,,,7,,,31,13,18,23,6,5,77,9,6,7,7,77,4,4,
   4,4,,,4,4,4,5,4,8,,7,12,,3,4,6,5,,5,5,7,6,7,,8,11,,
   7,36,18,77,7,5,7,77,7,6,8,36,18,4,4,4,,,4,5,4,8,5,
   4,,,13,,4,4,6,8,,6,6,8,6,10,,,6,,,18,19,22,22,4,9,19,
   9,19,6,22,22,4,4,,8,4,4,4,7,4,,,5,,12,4,4,6,4,,4,6,
   6,6,,,5,8,,7,7,77,77,5,7,36,18,8,5,8,31,13,4,,,4,4,
   4,10,4,,,10,,,4,5,8,4,,5,6,7,6,,,4,15,,10,22,22,19,9,
   9,22,22,6,4,9,18,19,,9,5,4,4,11,5,7,,7,,8,4,8,6,4,,
   6,10,8,6,7,,7,10,,,7,112,18,51,6,51,18,8,7,12,7,112,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,7,8,,,,17,,4,5,8,4,
   ,10,10,10,6,8,,,15,,,,31,23,,12,12,66,10,8,13,11,46,4,
   4,,5,,,6,,7,4,4,6,4,,4,6,7,6,6,,4,,,7,5,77,18,6,23,
   31,13,8,7,23,6,13,4,,5,,,8,,13,4,4,7,4,,4,6,7,,11,,5,
   ,,4,9,19,22,4,22,18,19,9,9,9,9,13,7,5,9,,11,8,,5,4,
   10,4,,5,6,8,,6,,4,,,8,51,18,18,6,51,7,112,12,6,34,8,
   19,,,,,,13,6,11,6,6,,8,6,,12,11,,8,,,18,12,37,37,16,,,
   45,12,27,70,10,45,8,,,,,7,6,11,6,,8,9,7,10,8,,10,12,,
   12,12,33,14,7,7,12,33,33,11,31,5,31,,7,,17,7,9,9,4,,
   6,11,8,8,9,,4,,,11,12,66,23,12,,,31,11,8,60,,28,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,13,,8,6,,6,,,11,,,,,9,,,,,45,37,,16,12,
   37,,27,12,9,168,,8,,,10,,8,,13,59,,,,,,,9,,,,,,68,12,13,,,
   ,11,6,,8,,,11,,16,10,,,,,,,68,,,,9,,62,9,,,,4,,4,,5,6,7,
   ,8,,7,,,7,6,18,13,6,31,6,13,23,23,22,6,18,9,4,,5,,8,
   11,,,7,,,10,4,22,19,19,18,9,13,9,22,27,19,19,,,,6,,,11,,
   ,,,19,15,33,27,18,18,10,50,,53,,8,42,,5,,8,10,,,,10,,8,
   6,18,112,7,7,8,19,34,33,13,36,19,,,,,,,,,,,,,,,,,,,,,,,10,
   7,6,6,,10,11,,12,7,14,33,11,12,5,31,31,7,15,10,26,,12,
   ,,,,,,8,37,37,,16,13,38,,129,53,,48,11,9,,,15,,,10,26,
   26,173,10,8,,,173,45,8,,6,,10,,,8,14,89,37,8,129,16,37,
   ,41,,13,38,,7,68,,11,9,168,37,12,27,,37,15,,12,,45,,,,,,,
   ,,,,,,,,,,12,,,,28,31,,8,12,23,,32,10,12,66,,12,,128,57,
   13,,,,,,,8,57,,,,,,,,,,,,,,,,26,,9,,,,,11,9,,22,33,34,33,4,
   19,6,7,26,32,57,,46,33,19,,26,22,49,57,,22,22,33,,41,
   46,26,19,,7,33,33,42,24,6,4,19,34,46,22,34,9,4,16,22,
   9,4,22,34,46,31,16,41,33,,9,29,30,31,36,34,50,9,31,
   22,4,3,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,4,6,
   10,7,9,6,8,9,8,,,,,,,8,22,22,8,27,27,22,8,27,8,27,22,
   4,3,3,3,3,4,4,4,4,4,4,,,4,4,4,8,8,,,8,6,6,4,4,6,
   4,6,8,7,4,7,8,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,
   4,3,4,4,4,6,4,6,7,,,4,6,7,,6,,8,10,,,4,6,10,7,9,6,
   8,9,8,,,,,,,8,22,22,8,27,27,22,8,27,8,27,22,4,3,4,4,
   4,4,4,4,4,,,4,4,4,8,4,5,7,7,10,,4,4,,4,,4,,6,,8,,,,
   9,9,8,8,8,8,5,5,8,12,5,12,5,8,4,3,6,6,5,6,5,6,,,
   6,5,6,,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,
   7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,5,,,4,4,5,6,6,5,6,
   6,9,,4,4,8,5,8,6,7,4,7,6,,,,,7,6,8,8,6,12,12,8,6,
   12,6,12,8,6,6,5,6,5,6,,,6,5,6,,5,,,8,10,8,6,5,8,6,
   10,5,,6,,,,,8,10,10,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,
   5,5,,,4,4,7,6,7,8,,,7,,4,4,8,6,8,7,,7,6,4,,,,,,67,7,
   16,,8,6,,7,7,7,7,67,4,4,4,4,,,4,5,5,4,4,6,,,7,,4,4,
   8,7,8,7,6,6,8,7,,,8,,,,16,,16,6,7,67,7,8,7,74,7,5,
   3,5,,,4,6,5,9,6,5,,,7,8,4,3,5,5,8,4,6,5,9,5,,,6,8,
   8,6,6,4,4,5,6,6,6,6,5,5,5,4,5,,,4,4,4,7,4,10,10,6,
   ,6,4,5,6,5,,4,8,5,8,,,,8,,7,16,,67,7,7,74,7,7,6,7,
   38,16,5,,,5,3,5,5,4,,5,6,7,7,4,6,9,5,6,6,9,5,5,,,,
   8,7,7,4,4,6,6,6,5,5,5,5,6,6,6,,,7,5,6,10,7,8,7,8,
   ,7,6,5,8,5,10,5,10,5,8,,,,10,7,,7,73,7,73,24,,6,25,
   8,25,16,38,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,4,5,,7,,8,7,,,4,4,,4,6,4,8,6,7,7,,,,9,
   8,7,67,7,16,74,38,16,7,7,43,7,7,5,,6,5,,6,7,8,5,3,
   6,5,8,4,5,5,,6,,,6,6,6,6,6,5,4,5,6,6,6,6,5,5,4,,7,
   ,10,,,,7,5,10,6,,7,8,8,,5,,,,9,,73,7,6,8,,16,38,25,
   24,85,8,7,,,9,,,,7,6,8,5,,4,7,8,9,,,,89,8,,8,24,8,14,
   42,,,8,12,49,7,9,6,12,,8,9,7,4,9,5,9,4,9,7,,4,,,10,
   6,10,7,7,4,7,7,7,7,7,7,7,5,7,10,8,61,26,8,6,6,7,
   12,12,,9,10,9,,,,,16,11,43,10,7,,31,19,33,13,28,14,10,,
   13,,7,6,8,8,19,7,6,7,,,,,53,,19,,11,35,13,13,9,,13,12,
   40,35,10,,,8,6,11,8,,9,11,11,6,6,,,17,19,,,9,13,35,24,
   11,,22,17,40,10,68,7,7,7,8,,7,4,13,8,,,,,,,,6,,,,,,,8,7,
   ,,,8,6,,,6,6,35,,,8,,,,,,,7,,,,,,,,,,,4,,5,,7,7,7,,8,,,,
   8,9,16,7,16,7,38,7,7,43,74,43,8,16,6,5,7,6,,5,6,,,,
   8,7,7,4,5,6,6,6,5,4,5,5,6,6,6,8,157,,,11,,11,,,,,17,
   10,10,9,9,18,20,25,63,46,,15,12,,7,,5,9,10,,,10,,9,8,
   6,38,7,16,8,7,85,,8,46,8,6,,,,10,,,,,,9,6,,,,9,8,,,,,,,
   7,10,,,,9,11,11,7,4,7,7,7,5,7,7,7,7,7,7,,10,,,,12,18,
   ,10,10,12,,11,11,26,63,36,11,9,19,10,7,,,9,9,,7,7,7,
   43,25,25,7,,84,26,8,43,7,,,157,14,37,9,9,10,10,36,11,
   12,,26,63,11,26,,,13,,10,8,36,24,8,12,42,8,10,20,8,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,10,,,9,6,,,,,,,,7,8,,,,,9,,,,,,,7,
   ,,,,,,,,,,7,,4,21,40,21,5,6,6,7,23,28,23,40,27,23,7,4,
   6,5,24,24,34,4,5,23,40,23,18,6,7,4,7,21,21,24,20,6,
   5,6,54,18,58,54,7,6,6,5,5,6,58,54,18,7,6,23,23,40,7,
   ,42,21,40,54,20,5,7,5,4,4,4,4,3,4,4,4,4,4,6,,11,4,
   4,6,,9,,,8,,9,4,4,8,6,,9,11,12,11,,,11,9,,,8,22,22,8,
   22,22,22,8,22,8,22,22,4,4,3,4,4,4,6,4,6,7,,,4,6,7,,
   6,,8,10,,,4,6,10,7,9,6,8,9,8,,,,,,,8,22,22,8,27,27,
   22,8,27,8,27,22,3,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,
   ,4,4,,6,,9,,12,,,8,,,9,,84,8,8,84,22,22,8,22,22,22,
   22,8,4,4,4,4,4,4,4,6,8,,4,4,6,,9,,11,,,,4,4,,6,,9,,
   12,,,8,,,9,,84,8,8,84,22,22,8,22,22,22,22,8,3,4,4,4,
   4,4,6,5,7,4,4,6,,4,,8,6,,,4,4,5,6,,4,8,6,8,,5,7,,,,
   10,10,10,10,12,12,10,10,12,10,12,10,4,4,5,4,5,4,,5,
   4,5,4,,4,,8,6,,9,4,5,8,4,8,4,6,6,6,,,5,9,7,,9,7,7,
   9,12,12,7,10,12,10,12,7,4,4,4,4,4,8,,3,4,5,,5,,7,,,,
   4,4,8,4,7,7,7,7,4,,6,6,11,8,,22,6,6,23,13,13,31,6,
   18,6,18,23,4,4,4,4,6,6,4,4,4,,4,,,6,,,3,4,6,5,7,5,
   4,7,5,,,6,7,,,23,6,31,8,13,18,23,6,13,5,77,7,4,4,4,,
   11,4,5,4,,5,,9,9,,,4,4,6,8,10,6,7,8,5,,11,,6,,,27,
   19,9,9,13,19,18,19,19,4,22,22,4,4,,6,4,4,4,,4,,,6,,
   8,4,4,5,4,7,4,5,6,8,,7,6,12,,,8,31,36,8,18,77,7,5,
   13,7,77,5,4,11,,4,4,4,,4,,,7,,,4,5,8,4,4,5,5,7,4,,,
   6,13,,,9,9,18,9,19,22,22,4,13,9,19,9,,10,5,4,4,,5,,4,
   ,,10,4,8,6,4,8,6,,8,4,,6,,8,10,,13,36,8,34,19,112,7,
   7,19,6,18,33,6,7,,6,,6,,9,11,,68,5,10,,7,11,8,7,9,8,
   ,11,,10,,,12,,,15,37,37,27,12,45,9,168,,6,6,,,6,,8,,,,
   5,6,,6,8,10,10,11,6,,12,12,16,59,,,13,16,,37,37,129,8,
   38,14,89,41,4,4,,5,,8,6,,11,4,4,7,4,7,4,8,7,,,5,5,,
   12,,8,36,7,7,77,77,5,7,18,36,18,6,4,,5,,,8,,15,4,4,
   10,4,10,4,4,7,,,10,6,,,,9,18,22,6,22,19,9,9,19,22,22,
   4,,5,,9,10,,,5,4,11,4,8,5,4,8,7,,7,6,,8,,34,8,7,12,
   112,18,51,6,19,51,18,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,
   11,7,6,,6,12,8,10,7,10,,8,10,,8,,15,10,5,31,31,33,12,
   11,26,7,14,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,5,4,7,7,11,
   8,4,8,,,,11,17,,,60,,,11,31,23,,12,28,12,66,8,,,6,6,,6,
   19,11,,,8,,6,6,,,,,8,10,,50,27,18,18,42,15,33,53,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,7,6,,10,12,12,12,15,15,,,,,,,,8,,,,57,,
   13,57,,,,4,,4,,5,,7,,,6,6,,7,,7,7,5,9,77,18,6,23,77,
   31,13,6,,4,,5,,8,,,8,6,,13,,6,22,9,9,19,22,4,22,22,
   18,19,19,7,,,9,,,,,11,,13,,12,9,12,,37,37,16,,168,,45,27,
   ,5,7,8,9,,11,10,8,,,12,7,51,8,18,18,6,51,112,7,112,
   7,12,,,,,18,,,,,11,9,,,,26,9,,,,,,10,7,8,,,9,,,,31,5,12,
   33,33,14,7,7,31,12,33,11,,,,8,,,,,10,12,12,,23,31,8,,66,
   ,28,32,10,,,,,13,,45,8,8,,,26,10,173,,10,26,173,,7,10,,
   17,,13,11,12,10,66,23,12,,46,,31,8,,,,,,,,,,,,,,,,,,6,13,,,
   70,10,,12,45,37,,16,45,12,37,27,11,,,53,,13,,38,37,16,,
   48,8,37,129,,,,,9,62,,,,,,,68,9,,,,,12,68,,,,,9,,13,,,,,,,,,,
   ,,,9,22,29,41,26,9,6,31,26,49,36,34,30,33,19,4,4,22,
   32,57,34,9,22,33,34,33,46,4,19,4,31,41,22,42,31,6,26,
   9,,46,33,,19,,16,22,22,,33,,46,7,16,33,33,34,19,34,46,
   24,57,,50,22,7,22,4,3,4,4,4,4,6,4,6,7,8,,4,6,7,10,
   6,,,,,,4,6,8,7,,6,10,9,10,10,8,,,9,,27,22,22,27,8,8,
   22,8,8,8,8,22,4,3,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,
   8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,22,22,8,27,22,
   27,22,8,4,3,4,4,4,4,4,4,8,7,4,4,4,,8,,,6,6,6,4,4,
   8,4,6,8,,4,,,8,7,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,
   4,4,6,4,6,7,10,10,4,6,7,8,6,,,8,9,,4,6,,7,,6,,9,,8,
   10,10,,,,8,8,8,8,22,22,8,27,22,27,22,8,4,4,6,4,6,4,,
   7,4,6,4,,4,,,8,6,6,4,6,8,4,6,4,7,4,7,,,7,6,6,6,5,
   6,6,5,6,6,6,5,6,5,6,6,4,4,4,5,5,8,,4,4,7,7,7,,,,,,
   4,4,8,6,,7,8,7,6,6,10,10,7,8,,38,16,7,74,16,7,67,7,
   7,8,16,,4,4,4,4,10,10,4,5,5,6,4,,,7,6,,4,4,6,7,7,
   7,6,6,8,,,6,7,,9,74,7,67,7,7,16,,8,16,6,,16,5,3,5,,
   5,4,6,5,6,6,,,,8,7,4,3,4,5,7,4,6,5,6,6,5,,4,6,6,
   6,6,5,5,4,6,6,6,6,5,4,4,4,5,,6,4,4,4,,4,,,4,,7,4,
   5,4,5,8,4,8,5,6,,,8,7,,8,7,67,,6,16,,16,6,7,7,67,7,
   5,5,,5,3,5,6,4,,,5,7,7,4,6,9,5,6,6,6,5,5,,,5,7,8,
   7,5,5,6,6,6,4,4,5,4,6,6,6,10,,7,5,6,,7,,,,,,6,5,6,
   5,,5,11,5,,8,7,8,8,10,,16,38,6,,8,73,7,8,7,24,7,73,
   10,,,7,,12,,,9,,13,6,6,6,8,16,6,8,10,,,11,,7,,46,9,,
   35,13,13,,11,11,9,10,68,11,8,5,8,8,6,,,,26,61,6,6,9,,
   13,10,10,,8,,6,10,11,,,31,19,10,,7,11,43,20,8,9,11,,4,
   5,,7,,,6,,7,4,4,7,4,9,4,6,6,10,10,6,6,,6,7,6,,16,8,
   ,67,7,7,16,74,7,16,5,,6,,,9,8,7,5,3,5,5,7,4,5,5,,
   5,6,6,7,7,6,6,6,4,5,4,6,6,6,6,5,5,4,8,7,,,10,7,,
   7,5,10,6,9,7,,8,8,7,8,,,7,9,,6,7,24,73,7,73,24,8,,
   6,8,,,,,,,10,5,,7,,6,10,,6,11,8,,,11,16,11,,13,24,35,,
   9,9,11,35,10,10,,,,9,8,7,4,6,5,11,4,7,7,10,6,6,10,
   7,6,7,7,7,4,7,7,7,7,7,7,7,4,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,4,7,6,10,6,11,7,9,6,,9,
   31,10,156,,,8,42,14,8,24,8,,9,8,36,7,8,6,10,10,6,6,
   12,,,,11,14,,,,,,,,,,7,9,8,,,,7,4,31,8,7,7,10,8,11,7,,
   14,,,,,,,,,6,,9,,,,,4,,5,,7,10,7,,8,7,8,,,,8,16,7,7,67,
   7,16,74,,38,16,7,,5,6,6,,5,5,,6,6,7,8,7,5,4,6,6,6,
   5,4,5,4,6,6,6,,156,,9,7,,9,,11,,,10,9,8,8,8,24,8,14,
   42,36,,,,,7,8,5,,10,,11,,,,24,7,73,8,7,6,8,,73,16,38,
   7,7,142,,,46,16,,,,,9,9,,,,8,7,,,,,,10,7,6,12,,7,8,9,
   11,7,4,7,7,7,4,7,7,7,7,7,7,,10,,,,14,14,,20,11,7,,
   10,19,8,31,43,14,10,18,,10,,,8,,,25,7,7,84,7,7,7,84,
   43,25,7,43,10,8,10,61,26,13,9,11,11,20,43,10,7,,,31,
   19,8,,8,13,,16,10,68,,11,11,35,13,13,11,9,,9,10,,,,35,
   10,,9,9,13,35,24,10,11,,11,10,12,142,14,10,19,31,8,7,
   10,,18,20,11,43,7,7,,,6,9,,,,,,,,,6,,,,9,7,,,,,,,8,,,8,,7,
   ,,,,9,9,,5,23,54,21,5,7,4,7,29,28,24,40,18,21,6,4,5,
   4,28,23,34,5,4,21,40,21,27,5,6,4,7,21,23,23,20,4,5,
   7,40,27,23,40,7,4,4,4,5,4,23,40,27,7,4,21,21,40,7,
   54,18,20,24,34,18,5,7,4,4,4,3,6,6,7,6,7,5,,8,6,7,5,
   ,6,7,8,10,,,6,7,,5,,6,,9,,,,8,,,9,9,57,57,9,9,9,57,
   23,9,23,9,57,3,4,4,4,4,4,4,5,6,7,4,4,5,,6,6,5,8,,,
   4,4,6,5,7,6,,4,,,6,7,,9,8,6,12,12,6,8,8,12,6,8,6,
   8,12,4,4,4,4,4,4,6,6,6,4,4,6,6,4,6,6,6,,,4,4,6,6,
   ,4,6,4,6,6,6,6,,,,10,12,12,10,12,12,12,10,12,10,12,
   12,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,,9,,,,
   8,,,9,9,57,57,9,9,9,57,23,9,23,9,57,5,5,4,7,7,6,,4,
   5,6,11,6,,6,,,,4,5,6,4,7,5,6,5,6,6,7,7,,7,,42,19,
   14,48,9,10,112,7,8,8,7,112,5,5,5,4,7,7,4,7,7,6,4,5,
   ,6,,,4,5,8,6,11,6,6,5,11,6,,5,,,7,48,14,112,7,10,7,
   112,8,9,8,48,14,7,6,7,,6,5,5,4,7,5,5,8,8,,,5,6,7,7,
   ,5,11,7,7,,7,,,12,12,8,31,46,46,8,33,14,7,11,6,46,
   46,5,7,,5,5,5,4,6,4,7,7,6,,,4,7,6,7,9,4,11,6,6,,6,,
   ,,8,7,112,112,10,7,48,14,8,10,7,42,19,7,7,,7,6,7,,6,
   ,7,,,,5,5,7,4,8,5,7,6,7,8,8,5,,9,,46,46,14,33,33,
   46,46,6,8,10,8,31,9,10,6,4,4,10,6,9,5,9,,,4,7,5,4,
   7,4,9,7,5,9,5,9,,7,,7,,14,46,7,46,14,7,9,5,7,,7,6,
   8,5,8,6,6,7,10,,,6,,6,6,63,6,6,,9,,9,,,,11,9,,205,16,
   8,,27,35,49,7,,,,5,9,9,,,6,,,,4,6,7,4,11,7,7,6,6,8,
   10,8,,13,,47,34,15,,19,,126,6,9,15,11,48,5,7,,6,,6,11,,
   ,5,5,6,4,9,4,6,5,8,8,6,4,,9,8,10,112,14,9,48,42,
   19,7,7,39,8,19,7,8,5,6,,7,,,7,6,11,7,,6,7,6,,7,,6,,,
   6,33,14,46,8,46,8,31,10,33,12,12,16,9,6,10,9,10,,,6,
   4,10,4,12,6,5,4,6,5,6,4,,12,8,46,14,14,7,46,7,,5,7,
   105,9,14,,,10,,,,8,7,9,5,12,6,8,7,10,9,8,7,,11,,34,
   98,27,21,55,,172,9,9,130,11,100,,6,,,,5,5,6,4,11,4,6,
   5,7,6,6,7,,6,,31,23,13,28,28,31,23,7,9,22,6,22,7,9,,
   ,5,7,7,4,11,5,6,5,9,7,9,4,,13,61,,126,15,19,,47,34,
   6,9,,11,27,8,,,,6,6,6,,11,6,7,,9,,9,,,7,,27,205,8,16,
   9,,12,18,13,73,27,,,6,6,8,5,11,6,10,8,10,8,9,7,,9,,,
   172,27,55,21,34,98,9,9,11,8,205,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,8,5,,6,,5,,9,7,9,14,19,8,
   42,8,19,39,48,34,9,14,7,7,,5,,7,7,,7,11,,,,8,46,31,
   11,8,12,16,12,46,6,11,31,6,,,7,8,,9,,8,,29,8,,27,141,
   9,26,8,78,,94,,29,27,,6,6,7,9,10,9,10,,,8,7,14,,9,7,
   9,14,105,46,5,46,14,,,,,18,,,,,,66,68,,,,12,89,,,,,,7,5,,
   6,,5,,17,8,28,13,23,9,31,6,22,22,28,23,13,14,,9,,9,,,
   71,,8,84,142,,9,16,27,70,66,7,16,,7,,7,,,,,8,,,126,8,
   31,16,101,126,6,34,,8,6,7,,,7,105,27,84,8,66,9,142,,
   29,70,16,27,8,9,,,18,8,205,98,34,9,55,27,,24,9,,172,7,,
   ,10,73,27,,9,49,8,205,,21,35,,27,,19,,11,27,34,47,9,
   19,15,,104,6,,126,,,,,,,,,,,,,,,12,,,,11,57,,,,,13,,57,,,26,,
   15,,,,,9,14,,46,52,70,24,20,34,6,28,24,26,30,,69,52,34,
   ,16,46,35,30,,46,46,52,,48,69,16,34,,28,24,52,24,22,6,
   20,34,70,69,48,70,10,6,24,46,12,6,48,70,69,22,24,48,
   52,,10,26,33,23,27,37,59,12,22,46,4,4,4,4,4,4,4,6,8,
   ,4,4,6,,9,,11,,,,4,4,,6,,9,,12,,,8,,,9,,84,8,8,84,22,
   22,8,22,22,22,22,8,4,4,4,6,4,6,7,10,10,4,6,7,8,6,,,
   8,9,,4,6,,7,,6,,9,,8,10,10,,,,8,8,8,8,22,22,8,27,22,
   27,22,8,6,6,7,6,7,5,,8,6,7,5,,6,7,8,10,,,6,7,,5,,6,
   ,9,,,,8,,,9,9,57,57,9,9,9,57,23,9,23,9,57,4,4,4,4,
   4,6,,3,4,5,5,5,6,6,,7,,4,4,,4,,7,,7,,4,,,,12,,23,7,
   9,22,5,6,22,18,7,13,6,23,4,4,4,4,,,4,4,4,4,4,8,,6,
   7,,3,4,,5,,5,,7,,7,,6,,,12,22,9,22,9,6,6,23,13,5,13,
   31,8,4,4,4,,11,4,5,4,5,5,6,7,7,10,,4,4,,8,,6,,8,,7,
   11,,,,,27,9,26,26,4,19,27,19,9,13,9,9,4,4,,6,4,4,4,
   7,4,6,6,5,,,4,4,,4,,4,,6,,,6,6,,,7,9,22,23,7,6,31,8,
   13,6,18,23,8,4,11,,4,4,4,7,4,,11,6,,,4,5,,4,,5,,7,,
   9,9,6,,,13,26,26,27,9,19,9,9,13,4,19,18,9,11,11,5,4,
   4,,5,7,6,7,,,4,8,,4,,6,,8,,7,6,7,,8,,8,50,8,50,7,36,
   13,19,6,19,8,34,,6,9,6,9,7,6,6,12,,,6,7,,,,8,,10,,,12,
   ,,,,12,,,14,10,18,14,27,8,33,53,15,6,6,7,7,8,,,,11,,6,
   8,,6,,,,,,8,12,12,,15,,,14,12,,10,15,63,33,9,27,18,27,
   4,4,,5,,6,6,,,4,4,,4,,4,,7,,,6,6,,8,11,7,23,8,8,31,
   36,8,18,6,77,7,7,4,9,5,11,,6,,,4,4,,4,,4,,7,,,7,8,,,
   6,9,27,9,6,9,18,9,19,19,22,22,6,7,5,,10,10,7,,5,4,,
   4,,5,,8,,4,,6,,10,8,50,8,13,8,36,8,34,19,7,112,7,12,,
   ,11,,,,,,,4,,6,,10,,,6,,,14,16,13,60,11,,,,15,23,,66,8,,
   7,8,,,,7,6,,6,,8,,7,,6,8,,,8,,29,29,7,10,10,10,15,26,
   11,31,5,31,6,7,,,7,,,6,,6,,9,,9,11,6,,68,16,12,70,12,
   11,,,15,37,10,37,27,12,7,21,,6,6,,,,6,,9,,8,,12,,,15,
   39,53,,16,13,16,,37,,37,129,11,11,,6,6,,6,,9,,,,6,,6,,
   15,,,11,16,,10,14,39,89,12,37,8,40,,7,,,7,,6,,9,,,9,,,,,
   11,,,,,,14,26,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,5,,7,,8,6,
   6,,11,8,8,8,8,8,36,7,7,77,31,77,5,9,,4,,5,,8,,,8,7,,
   15,15,6,9,9,9,18,22,6,22,9,19,9,9,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,,8,,9,10,10,,,10,8,13,34,12,8,7,12,112,36,18,51,8,,
   ,,,,,,,,,,,,,,,,,,,,,,7,,6,,11,,11,,10,7,15,33,10,5,31,31,
   10,33,12,33,,,,,,,,,,,,,,,,,,,,,,8,12,,,11,,12,10,10,,10,8,
   45,,190,,8,,,,,,,,,,,,,,,,,,,,9,7,,,15,10,137,60,13,,,11,31,
   11,23,,15,,,,15,63,17,,12,8,10,,50,13,27,18,14,,,,14,15,
   14,,9,10,12,,16,33,15,63,,,,,,,,,,,,,,,,,,,11,8,,,,,57,,52,,
   ,11,,13,,,128,,57,13,,26,19,29,26,6,28,26,10,41,42,35,
   29,25,22,9,6,26,9,49,36,128,26,9,22,29,41,30,26,9,6,
   10,26,19,49,21,26,6,28,34,30,33,34,19,4,6,9,22,4,33,
   34,30,31,6,41,22,29,19,,46,31,57,34,37,22,31,9,4,4,4,
   6,4,6,7,,8,4,6,7,,6,8,,10,,,4,6,10,7,,6,,9,,,,8,,,9,
   8,27,27,8,22,22,27,8,22,8,22,27,6,6,5,6,5,6,,,6,5,6,
   ,5,,,8,10,8,6,5,8,6,10,5,,6,,,,,8,10,10,7,7,7,7,7,
   7,7,7,7,7,7,7,4,4,4,5,5,8,,4,4,7,,7,7,8,,8,,4,4,
   8,6,9,7,,7,,,7,7,8,7,,43,8,7,43,7,16,38,7,16,16,7,
   74,4,4,4,4,7,7,4,5,5,,4,8,,,9,,4,4,7,7,8,7,,6,,,,8,,
   ,6,43,7,38,7,16,7,74,16,7,7,67,7,5,3,5,,6,4,6,5,,
   6,6,6,6,7,8,4,3,6,5,7,4,,5,,,6,,6,7,7,6,6,5,5,4,
   6,6,6,6,4,5,5,4,5,,8,4,4,4,,4,10,10,6,,8,4,5,6,5,
   7,4,,5,,,7,8,6,,,7,38,74,7,7,67,7,7,16,16,,6,5,6,,5,
   3,5,,4,,5,6,6,6,4,6,6,5,6,6,,5,,,,5,8,7,8,5,5,6,6,
   6,5,5,4,4,6,6,6,10,9,7,5,6,,7,8,7,8,,10,6,5,8,5,
   9,5,,5,,,5,,,,,8,46,8,85,7,38,16,7,8,8,6,,7,7,,5,,,,
   9,11,,13,4,5,6,,10,4,,7,,,,,8,,10,8,,42,10,8,24,12,8,,
   8,36,20,8,5,,,10,,10,,14,157,6,9,6,8,37,,,10,,,9,10,,,,
   63,11,11,,12,10,36,10,26,9,9,26,4,5,,7,,6,8,,8,4,4,,
   4,,4,,6,,,4,6,,7,8,7,74,7,7,67,,6,16,7,,16,8,5,,6,5,
   ,9,7,8,5,3,6,5,7,4,,5,,,5,9,7,7,6,6,6,5,5,5,6,6,
   6,6,4,4,5,,7,10,,10,9,,7,5,,6,,7,,8,,,,8,,,,85,8,16,
   25,38,6,,8,7,73,7,24,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,12,,
   11,9,7,4,9,5,11,4,,7,,,4,,6,4,6,7,7,5,7,7,7,7,7,7,
   7,4,7,10,8,,53,,,,7,19,12,,7,,,9,6,,13,19,40,35,9,13,,
   35,13,13,10,,11,12,6,,,8,5,8,8,16,6,,9,,,,,26,61,12,
   28,14,31,33,19,10,,7,10,11,43,13,,,8,5,11,8,17,9,,11,,
   ,8,,,8,157,,15,20,63,25,9,18,9,12,10,10,46,6,,8,19,7,
   8,6,,9,,,8,18,,,,,,,,,,9,,7,,,,,6,17,10,10,10,,9,,,89,12,,
   ,,,,,,,9,,6,7,,,,4,,5,,7,,7,,,6,,,7,8,7,7,6,7,,16,8,,
   67,67,7,7,,5,8,6,,5,,,9,6,8,7,8,5,5,6,6,6,4,5,4,5,
   6,6,6,8,,,,11,,,,11,,,,40,10,11,22,,13,24,35,68,,9,17,,
   7,,5,,,10,10,7,,10,25,16,,25,6,7,24,73,38,7,73,8,10,,,,
   ,,,,,,,7,,,,,,,,,,,,7,,,,9,9,8,9,7,5,7,7,7,4,7,7,7,7,
   7,7,,,,,,,,,,,,,,,,,,,,,,,8,,,8,,26,8,25,,7,7,25,43,43,7,
   7,84,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,49,7,,8,,8,42,14,
   9,8,24,12,35,13,,11,9,11,63,26,12,11,,19,10,10,36,7,6,
   ,,,,,,,,,,7,,7,,,,8,,,,,,6,,7,,,9,,8,,,,,9,6,,5,58,,23,6,
   7,6,7,23,24,40,54,42,23,7,6,5,5,28,24,54,5,5,23,54,
   21,18,5,7,6,7,23,58,24,21,6,6,7,40,18,21,40,6,4,6,
   5,4,4,21,40,18,7,6,21,23,54,6,40,27,20,23,34,20,4,7,
   5,6,6,7,6,7,5,,,6,7,5,,6,8,7,,,,6,7,10,5,9,6,8,9,8,
   ,,,,,,23,9,9,23,57,57,9,9,57,9,57,9,5,5,4,7,7,6,,4,
   5,6,,6,,5,,9,,4,5,6,4,7,5,5,5,4,6,8,8,,,,34,9,8,39,
   19,19,42,8,14,9,14,48,5,5,5,4,8,8,4,7,7,6,4,6,,6,9,
   ,4,5,11,6,8,6,4,5,,6,,6,,,9,39,8,42,7,19,14,48,9,
   19,10,112,7,7,6,7,,7,5,5,4,7,5,6,7,7,,,5,6,6,7,,5,
   11,7,6,,7,,,,,6,11,12,12,16,31,8,11,31,8,46,46,5,7,,
   6,5,5,4,6,4,7,7,6,,,4,7,6,7,8,4,,6,5,,6,11,,,9,7,
   42,48,8,14,112,7,10,19,7,112,10,7,7,,7,6,7,,6,,6,11,,
   ,5,5,7,4,6,5,6,6,5,8,8,7,,,,12,12,8,10,31,46,46,8,
   16,33,14,33,10,9,6,4,4,9,6,6,4,6,,,4,7,5,4,8,4,10,
   7,4,6,5,6,,,,5,46,9,105,14,,7,9,14,7,14,46,8,6,8,5,
   8,6,9,7,9,,,6,,8,9,18,6,9,,8,,9,,,,18,9,,55,,27,98,9,
   34,172,8,205,24,11,7,6,6,,,9,,,,6,7,10,5,7,7,7,7,6,
   9,10,9,,,,70,16,9,,142,84,66,8,27,105,27,29,5,7,,6,,5,
   8,,,5,5,6,4,7,4,5,5,7,7,6,6,,,11,8,48,7,8,112,112,
   10,7,14,48,14,9,7,8,5,7,,7,9,,7,6,,7,,6,5,6,,7,,7,,,
   8,10,8,46,6,46,14,33,33,31,46,46,8,6,6,9,10,10,12,,
   6,4,10,4,8,6,4,4,9,5,9,5,,,12,105,9,7,5,,14,46,7,
   14,46,14,7,,,9,,,,7,7,9,5,10,6,7,7,10,9,8,9,,,,35,,8,
   ,205,,49,9,27,73,27,21,11,5,,17,,5,5,6,4,8,4,5,5,7,
   6,6,7,,,,23,13,6,22,22,23,31,9,14,28,13,28,7,6,,,6,8,
   8,5,7,6,9,7,6,7,10,6,,,,13,73,9,12,,205,16,8,27,,27,
   18,7,13,,,5,9,9,61,,4,5,,6,,6,,,11,,11,47,6,34,15,,19,
   27,,126,9,29,,6,7,8,5,8,6,8,8,7,6,9,7,,,,,29,8,,78,
   141,26,9,27,,27,94,,7,12,9,7,12,6,19,,13,,11,71,,,,13,,,
   ,,,57,11,57,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,,6,7,5,,6,11,
   6,,,7,8,7,10,7,112,14,9,48,112,42,19,8,8,7,12,5,,7,6,
   ,7,11,,,,6,46,33,7,14,46,8,46,46,8,31,11,9,,,7,8,,10,
   ,10,,,11,11,8,34,9,98,27,21,55,205,,172,9,,6,9,7,10,
   9,10,9,,,7,5,7,46,7,14,14,7,46,,7,,9,,,,,11,,,,,,9,14,,,
   ,26,15,,,,,,7,5,,6,,6,,,11,22,6,31,7,23,13,28,28,22,
   31,23,9,,8,,7,,,,,6,,19,,15,34,9,47,126,11,27,104,6,,7,,
   ,,,6,34,31,101,16,,8,126,,8,,126,7,9,7,,,11,15,11,,6,
   126,15,19,,48,47,34,9,8,6,,,63,7,,,35,27,205,8,16,,9,,
   49,8,,,12,130,11,,9,172,27,55,21,100,34,98,9,,,,7,16,
   16,70,27,142,9,,,8,84,66,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,12,,89,,,
   ,,66,68,,12,48,26,48,16,10,6,22,24,35,27,70,33,52,34,
   6,20,46,26,30,37,12,46,52,70,24,69,20,34,6,22,48,48,
   24,23,6,16,10,,69,52,,34,,24,46,46,,52,,69,28,24,24,52,
   70,34,70,69,22,30,,59,46,28,46,8,8,5,6,6,,,4,5,5,,5,
   7,,,9,,5,5,7,6,10,5,7,5,8,,,,,9,,120,16,9,47,16,9,53,
   9,9,6,28,,8,8,8,6,,,5,6,6,,5,8,,9,,,4,5,8,5,7,5,8,
   7,8,,,9,,,,47,9,53,8,9,28,,6,16,7,,28,6,4,6,,8,5,6,4,
   ,6,5,9,9,9,10,5,4,4,7,10,4,6,7,,,,,4,10,10,7,7,7,
   7,6,7,7,7,7,4,6,6,8,6,,9,8,8,6,,5,11,11,6,,8,5,6,
   6,6,10,5,8,5,9,,,8,8,,10,8,53,,7,28,,28,7,9,8,53,9,
   6,,,6,4,6,,4,,7,7,9,9,5,6,9,4,6,6,,5,6,,,6,10,9,10,
   7,7,7,7,7,6,6,4,6,7,7,7,,11,5,4,4,,5,7,6,7,,7,6,
   7,4,4,8,4,10,7,6,,,,7,,,16,131,7,,6,50,8,7,9,16,8,50,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,6,,,6,,11,,48,,8,,,6,11,
   ,,9,8,,,11,,15,,,16,10,,,32,130,10,11,10,23,28,8,6,,5,,
   8,8,,,8,8,9,6,,5,9,7,,,,8,,,7,7,,28,6,,53,9,8,28,47,
   9,16,6,,6,7,,9,9,10,6,4,7,6,10,4,6,5,,,,,9,9,6,7,7,
   6,4,6,7,7,7,7,7,7,6,,5,,,,9,,5,4,,4,,5,6,5,,,,6,,9,,
   ,7,8,16,50,8,50,16,6,,7,6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   6,9,,7,7,5,4,6,4,8,3,5,5,,,,,7,6,7,7,8,6,7,7,8,8,
   7,8,7,6,7,11,7,,14,,9,9,6,34,9,6,,11,,,6,,17,13,25,
   79,10,9,,94,13,26,24,,12,12,9,17,,7,5,7,7,13,6,6,,,,,
   6,14,,34,,12,94,26,13,10,,9,12,25,79,24,11,,7,4,7,4,,
   6,8,7,,,,10,31,7,79,,7,13,56,23,12,14,8,8,12,8,42,9,
   9,10,7,,10,6,18,9,15,,,12,,,,10,,,,,,,,10,,,,,4,31,7,7,
   7,7,8,,,,13,,,,,7,,,,10,,,7,,,,8,,6,,5,,5,,,,7,,9,10,6,
   28,9,9,53,9,16,47,,120,16,9,9,6,10,6,,7,8,,,6,10,9,
   10,4,6,7,7,7,7,6,7,6,7,7,7,7,79,,10,7,,,,8,,11,,12,
   8,12,8,14,13,23,56,42,,7,8,,5,,7,11,,,10,7,,8,16,8,
   50,7,8,7,6,,50,16,131,9,7,,,,,,,,,,7,,,,,10,,,,,,,,5,6,,,
   5,7,7,8,7,6,8,7,8,6,7,7,7,7,8,8,,11,,,,13,12,,10,32,
   ,,10,16,11,,130,,14,,9,,,,8,9,,8,29,9,50,9,9,9,50,138,
   8,29,138,,,,,48,11,10,23,32,10,130,10,,,28,,16,11,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,7,18,,,14,16,,11,,10,,,10,32,130,9,7,
   ,,10,,,,,,,,7,7,10,,,,,,,,,,10,,10,,,10,,,,,,,7,,,7,26,26,
   27,6,7,4,7,19,26,39,87,37,28,7,6,6,6,26,35,55,7,6,
   28,87,27,28,6,7,6,7,27,26,23,25,4,6,7,87,28,26,87,7,
   6,5,6,7,6,26,87,28,7,5,27,28,87,7,26,37,25,39,55,37,
   7,7,6,3,4,4,4,,,3,4,4,4,4,4,,,5,,3,3,4,4,5,4,4,4,
   4,4,,,4,,,,4,25,25,4,4,,4,4,4,25,25,4,4,4,,,3,4,4,4,
   4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,25,25,4,4,,4,
   4,4,25,25,4,4,,,3,3,3,3,3,4,4,,,,2,3,3,3,3,3,3,3,3,
   ,4,4,3,,,17,17,17,17,3,18,17,3,3,3,18,17,3,5,,4,3,
   4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,25,25,4,,
   4,25,25,4,4,4,4,,5,,4,3,4,5,4,,4,,,,3,4,4,3,4,4,5,
   4,3,4,4,4,5,5,,25,25,4,,4,25,25,4,4,4,4,,,3,4,4,4,
   4,5,3,,,,3,3,4,4,5,4,4,4,4,,,,4,,,29,,41,25,4,7,,5,
   4,4,41,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,
   3,3,2,3,3,3,3,3,3,3,3,,3,,18,18,3,17,17,18,18,3,3,
   18,3,17,4,4,4,3,,,4,,3,2,3,3,4,3,3,3,,3,4,4,4,4,,
   18,3,4,17,4,3,18,3,3,4,4,17,,3,5,5,,5,,4,3,5,3,5,
   4,4,4,4,3,4,4,,4,,,5,4,25,25,5,,5,5,25,4,25,,,5,,,,
   4,3,5,3,5,4,4,4,4,3,4,4,,4,,,7,4,25,41,,26,4,5,41,
   4,25,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,4,,4,,,5,4,25,
   25,5,,5,5,25,4,25,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,,5,,
   26,41,4,29,,41,26,4,4,7,5,,,5,,3,3,4,4,5,4,4,4,,4,,,
   5,27,,53,4,16,25,5,5,,5,4,5,16,25,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,3,4,4,3,4,4,5,4,4,19,5,5,,,,26,,23,,19,,26,4,4,
   23,22,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,3,,4,4,4,,3,4,4,,3,,18,
   3,3,18,18,3,18,18,18,18,3,18,4,3,4,4,,4,3,,4,4,4,4,
   ,17,4,3,18,3,4,17,4,4,3,3,18,4,,,3,,,4,,,,5,,26,4,5,
   ,7,4,26,41,41,,4,26,,4,4,4,4,4,6,6,3,,,17,3,18,18,
   3,3,17,18,17,3,18,18,,27,,,4,,,,,,26,4,23,,25,4,26,,,
   35,27,,,3,4,4,,,5,5,,25,4,5,,5,4,25,25,25,5,5,,,4,,,,
   5,5,,25,5,5,,5,5,25,16,16,4,4,26,4,4,,,5,5,,25,4,5,,
   5,4,25,25,25,5,5,,3,4,4,20,4,,32,4,4,18,12,3,18,,6,
   12,4,18,4,4,4,,,17,12,6,36,4,12,17,4,4,3,,20,3,5,,,
   79,5,,70,4,4,70,,9,5,9,79,5,,,79,5,,70,4,4,70,,9,5,
   9,79,4,,,23,4,26,,27,,35,25,,4,26,,,23,,26,4,22,,23,19,
   4,,26,,,,,,,,,,,,,25,71,18,117,18,,18,25,70,70,,16,71,11,
   4,18,3,4,10,12,55,25,4,12,55,10,11,3,4,18,25,70,,70,
   117,18,18,,10,44,12,18,4,3,18,25,4,3,11,18,71,25,18,
   117,71,18,4,18,11,117,12,10,44,4,25,25,4,4,4,,,3,4,4,
   4,4,4,,,5,,3,3,4,4,5,4,4,4,4,4,,,4,,,,4,25,25,4,4,,
   4,4,4,25,25,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,
   4,,,4,5,,5,25,25,,4,4,25,25,4,4,4,,4,4,,,4,4,4,4,3,,
   ,4,,,3,4,4,4,4,4,4,3,4,,,4,5,,5,25,25,,4,4,25,25,4,
   4,4,,4,6,6,3,3,3,4,3,4,,4,,,2,3,3,3,3,3,4,3,3,4,,
   4,3,,,18,18,18,17,3,17,18,3,3,3,17,18,3,4,4,4,4,4,,,,
   ,,3,4,4,4,5,4,4,4,4,,,,5,,,70,,70,,4,9,79,5,4,5,136,
   9,4,4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,70,,70,,4,
   9,79,5,4,5,136,9,4,4,,3,,,3,,,3,3,3,3,3,3,3,2,4,4,,
   3,,,3,18,17,17,3,17,17,17,3,3,18,17,3,3,4,4,5,,5,5,,
   4,3,5,4,5,4,3,3,,4,,4,,,4,,4,25,4,25,4,,4,4,25,25,
   4,4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,25,4,25,
   4,,4,4,25,25,4,,,,,,,3,3,3,3,4,3,3,3,4,4,,4,20,,4,
   32,6,17,4,12,,20,3,4,12,17,4,3,,,4,,3,2,3,3,4,3,3,
   3,4,3,,4,4,,4,20,4,17,4,4,4,20,4,4,4,17,4,,4,,,3,4,
   4,4,4,4,4,3,5,3,,4,,,5,26,41,29,4,,41,25,4,4,7,,5,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,3,3,4,4,5,4,4,4,5,4,,3,5,,
   27,,5,25,16,5,4,47,4,5,5,25,16,,3,4,4,4,4,4,4,3,5,
   27,,5,,,,26,,,23,31,,26,4,4,25,,21,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   3,,4,,4,3,3,,3,,3,,,3,18,3,18,3,18,3,17,17,17,18,18,
   3,4,4,4,4,,3,3,,,3,4,,4,17,4,18,3,3,4,17,4,4,3,18,
   3,,,,4,4,,5,,5,,,5,26,4,,5,7,4,25,41,41,,26,4,,3,4,4,
   5,5,,5,5,,5,25,4,,5,5,4,25,25,25,5,,5,,20,,,5,,,,,,26,
   4,,21,23,4,26,,,19,,23,4,4,5,5,,5,5,,5,25,4,,5,5,4,
   25,25,25,5,,5,,3,,,,4,,,17,4,20,,3,4,18,12,12,4,18,6,
   3,3,,,3,,,18,3,18,18,3,3,18,17,18,3,18,18,4,,4,,,4,,
   5,26,4,41,4,29,,7,41,26,4,,4,5,,5,25,16,53,4,4,16,
   25,5,5,5,,5,,,,,,,,,,,,,,,,,4,,,,5,26,41,4,4,26,,7,4,26,
   41,,4,,21,26,4,,23,,19,21,,26,4,,,,,,,,,,,,,,,22,26,,4,20,
   ,20,21,4,26,,25,,55,70,18,,18,25,117,,190,55,12,12,4,
   18,3,4,12,190,11,25,25,71,18,117,44,18,,18,4,13,71,12,
   11,3,18,4,16,71,11,10,4,18,3,25,4,3,12,55,12,25,18,
   70,,55,4,10,44,11,15,88,14,25,4,25,4,3,,5,4,4,3,5,4,
   4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,25,25,4,,4,4,
   4,4,25,25,4,,,3,3,3,3,3,,4,4,6,6,2,3,3,3,4,3,3,3,
   3,4,4,,4,6,6,4,4,4,4,3,4,4,3,3,3,4,4,,5,4,4,3,5,
   4,4,4,4,,5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,25,25,4,,4,
   4,4,4,25,25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,4,4,,,
   ,7,,3,3,4,4,5,4,4,4,4,5,3,,4,,,30,5,,,4,5,30,4,4,
   4,8,8,4,3,,4,,4,4,,4,3,3,3,3,4,2,3,3,4,4,3,,,4,4,
   3,18,4,4,17,18,3,3,3,17,4,4,4,,3,4,,,6,6,4,3,4,4,
   6,3,4,4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,
   4,6,6,4,,3,2,4,3,4,3,3,3,4,3,4,,,4,4,18,3,4,4,17,
   3,18,3,3,17,4,4,,,,,,6,4,3,4,4,6,3,4,4,3,5,4,,20,5,
   5,5,7,5,5,12,,4,4,5,12,5,5,4,,,6,6,4,3,4,4,6,3,4,
   4,,4,4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,4,4,22,6,3,
   3,3,3,4,3,3,3,4,4,4,,,6,6,4,12,4,4,,12,4,3,3,6,6,
   6,3,6,,4,3,4,4,6,4,4,4,,4,,,6,28,28,,5,16,16,6,5,,
   5,5,6,16,16,6,,4,3,4,4,6,4,4,4,,4,,,6,28,28,,5,16,
   16,6,5,,5,5,6,16,16,6,4,6,4,5,6,4,7,5,6,,5,,,,,5,,,,
   20,,5,5,5,21,,,4,4,6,5,6,6,5,5,6,5,,,,,,,5,,,21,5,,5,
   5,22,,,3,,4,,3,4,4,,3,3,,,4,4,3,3,4,4,17,3,3,18,18,
   17,4,4,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,4,
   3,4,4,4,22,,4,4,,3,,,,6,6,4,3,6,6,6,3,4,12,12,,4,4,
   ,4,,3,5,5,5,,4,,,4,4,25,25,4,4,4,,,4,25,25,6,,,,7,7,,
   ,,,5,5,,,21,5,5,,,20,,,4,4,3,3,,,4,6,6,4,3,6,6,4,3,
   4,4,4,4,6,6,,5,,5,,4,,,4,5,,,4,5,4,30,30,4,8,8,5,5,
   5,,4,,,4,4,25,25,4,4,4,,,4,25,25,4,4,,20,5,5,5,5,5,
   5,12,4,4,,7,12,5,5,4,,4,,,4,30,8,8,4,30,4,5,5,4,,,,
   4,,,30,4,,,4,4,30,5,5,4,8,8,,,,,,,,,,,,,,,,4,4,20,20,4,
   4,,22,22,18,22,,4,4,3,,,,,4,,,,,4,,,,,,,4,,,,,4,,,4,37,
   37,11,4,6,4,4,11,25,25,37,37,12,6,4,4,4,11,37,37,3,
   4,25,37,43,25,3,4,4,4,25,37,43,25,3,4,4,10,12,12,10,
   3,3,3,4,4,4,12,37,37,4,4,11,37,37,6,10,25,25,12,37,
   37,4,4,3,4,,,4,4,4,4,3,,,4,,,3,4,4,4,4,4,4,3,4,,,4,
   5,,5,25,25,,4,4,25,25,4,4,4,,4,,5,4,4,3,5,4,4,4,4,,
   5,3,4,3,4,5,3,5,4,4,,4,,4,,,4,,25,25,4,,4,4,4,4,25,
   25,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,3,,,,,,3,4,4,
   4,4,4,4,3,4,,6,5,5,,,41,25,29,,4,26,41,4,4,5,,7,3,4,
   ,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,,25,4,25,,4,
   4,4,25,25,4,4,,4,,,4,,5,4,4,4,4,5,3,4,3,,,4,4,,,4,4,
   ,25,4,25,,4,4,4,25,25,4,4,3,6,6,4,,,3,3,4,3,3,3,3,
   2,4,,4,3,,,3,17,18,18,3,17,18,18,3,3,17,18,3,,,,,,5,
   4,4,4,4,5,3,4,3,6,,4,5,27,,5,4,47,25,5,16,,5,5,4,
   16,25,5,4,4,,,4,3,3,3,3,4,2,3,3,4,,3,4,4,,4,4,20,
   17,4,4,20,4,4,4,4,17,4,3,4,,,4,4,4,4,5,4,4,3,,,,4,,
   ,5,9,79,70,4,,70,,4,5,9,79,5,4,,,4,4,4,4,5,4,4,3,,,
   ,4,,,5,9,79,70,4,,70,,4,5,9,79,5,,,3,3,3,3,4,3,3,3,
   4,,4,4,4,,19,,20,17,12,4,32,6,4,3,4,18,12,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,3,4,4,4,4,4,4,3,5,,27,5,,,,,26,,31,23,26,,
   4,4,23,,21,4,,4,,3,4,3,,,3,3,,,3,3,18,18,3,17,17,3,
   18,17,18,17,3,4,3,,4,,4,5,,5,5,5,,5,4,25,,4,4,25,4,
   25,25,4,,4,4,20,,4,3,,,,3,,,4,4,18,32,4,6,17,4,12,12,
   ,20,3,,4,,4,5,,5,5,5,,5,4,25,,4,4,25,4,25,25,4,,4,4,
   ,,,,5,,,,,4,26,,23,21,26,4,,,35,,23,4,3,3,,,3,4,,4,4,
   17,20,4,4,17,4,4,4,4,20,4,,5,,5,,5,,,4,25,26,,4,26,
   4,41,41,5,,7,3,,3,,3,,,3,18,18,17,3,18,3,17,17,3,18,
   18,,4,4,,,4,5,,26,4,41,29,4,,7,41,25,4,,,,,,,,,,,,,,,,,,
   4,5,,5,16,25,,5,5,25,16,5,5,4,47,4,4,,,5,,26,41,4,
   26,4,,7,4,25,41,,4,23,,26,4,,,23,35,21,,26,4,,,,,,,,,,,,,
   ,31,,26,,4,,21,23,23,4,26,,25,71,16,13,18,4,3,4,10,
   70,12,18,71,71,,18,18,25,70,,55,25,25,,55,70,71,18,,18,
   4,70,12,10,13,3,18,4,55,12,12,16,4,18,3,25,25,18,71,
   18,71,4,3,13,71,16,4,18,71,13,12,55,12,25,4,25,5,,4,
   3,4,5,4,,4,,,,3,4,4,3,4,4,5,4,3,4,4,4,5,5,,25,25,4,
   ,4,25,25,4,4,4,4,,,4,4,4,4,3,,6,5,,,3,4,4,4,4,4,4,
   3,4,,,,5,,7,,,30,5,4,8,8,4,4,4,30,5,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,4,3,,4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,
   5,5,25,25,4,4,,25,25,4,4,,4,4,4,4,3,,,3,6,6,3,3,3,
   3,4,3,3,2,,4,4,3,6,6,4,4,4,4,3,4,4,4,3,3,4,4,3,,
   4,,5,5,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,5,25,25,4,4,,
   25,25,4,4,,4,4,,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,5,7,
   8,8,4,5,30,,,4,4,30,4,5,,3,,6,6,3,3,3,2,4,3,3,3,3,
   3,3,3,6,4,6,6,6,3,4,4,6,6,4,4,4,3,4,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,,,3,4,4,4,4,4,4,3,,,,4,7,,5,8,8,30,4,5,,
   ,4,4,5,30,4,,,3,4,4,3,4,4,5,4,3,4,4,4,7,5,,,,4,30,
   5,8,8,4,4,5,4,30,3,4,4,5,4,4,4,5,4,6,28,28,6,,,,,,,,
   ,,,4,4,,,,4,4,5,4,4,4,5,4,6,28,28,6,,,,,,,,,,,4,4,,,,4,
   ,3,,4,4,3,,4,4,3,,4,4,4,4,3,3,18,4,4,17,17,18,3,3,
   ,4,4,3,,4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,4,
   20,,6,4,,,,4,,6,6,5,5,5,5,7,5,5,12,12,,4,4,,4,4,3,
   4,6,6,4,4,,4,4,4,18,3,3,4,4,17,17,3,18,3,4,20,,,6,
   6,,,,,4,4,20,20,22,4,4,,,18,22,22,,4,4,,,4,6,6,6,4,4,
   5,5,5,4,4,4,4,5,5,5,,4,,,,6,6,,5,5,4,,4,5,5,12,12,
   5,5,7,3,4,4,,4,4,,4,4,3,18,3,4,4,17,17,3,3,18,4,4,
   3,22,6,4,6,6,4,3,12,4,4,,6,12,4,3,3,4,6,,6,16,16,,
   5,5,16,16,6,6,5,,5,4,6,,6,16,16,,5,5,16,16,6,6,5,,
   5,4,6,22,6,6,4,12,3,4,4,,6,3,4,12,6,6,,,5,5,,,,20,
   21,,5,5,6,,,,5,5,,,21,20,5,,5,,,5,,5,,,22,21,5,5,,3,
   37,37,25,4,4,3,4,43,25,37,37,37,25,4,4,3,4,43,25,37,
   4,4,37,37,11,12,4,6,4,4,25,25,11,11,4,4,6,37,37,12,
   10,6,4,4,3,4,3,25,37,37,4,3,25,37,37,3,10,12,11,12,
   10,12,4,4,4,6,5,6,4,6,5,5,6,5,,7,4,5,4,6,7,4,6,5,
   6,,6,,5,,,6,,51,33,5,,6,6,6,5,51,33,5,4,6,6,5,,6,,,,
   4,5,6,4,5,6,6,5,4,5,6,5,7,7,,51,33,6,,6,33,51,5,5,
   6,6,,4,4,,3,,4,,,5,4,4,4,3,5,3,5,4,4,4,3,4,,4,,5,,
   4,25,25,,5,5,5,25,4,25,3,6,4,4,,4,,4,3,3,3,3,4,2,
   4,3,,4,3,4,4,4,,3,18,4,17,4,18,3,3,3,4,4,17,6,4,6,
   4,6,,,3,3,4,2,3,3,4,3,3,3,3,3,,3,,18,18,3,18,18,18,
   18,3,3,17,3,18,,,6,,,7,6,5,6,4,7,4,6,5,6,5,4,5,,5,,
   6,,5,33,51,,6,6,6,51,5,33,,4,,,5,4,4,4,3,5,3,5,4,4,
   4,3,4,,4,,5,,4,25,25,,5,5,5,25,4,25,4,3,,,4,4,4,3,
   5,4,5,4,4,4,4,4,,5,,,70,4,70,,79,9,5,4,9,5,79,4,,,
   3,3,3,3,4,3,4,3,,4,,4,4,20,,6,36,12,17,4,20,,3,4,4,
   12,18,,,4,4,4,3,5,4,5,4,4,4,4,4,,5,,,70,4,70,,79,9,
   5,4,9,5,79,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,4,3,4,4,5,4,4,
   5,20,5,,,,,26,22,,21,26,,4,4,20,20,,4,,3,,3,6,4,,4,3,
   4,,3,,3,18,3,18,17,18,3,18,18,18,3,17,4,4,,4,,3,4,,4,
   ,5,5,,4,25,4,,4,25,4,25,25,4,4,,3,20,,6,4,,4,,4,,4,,
   4,18,4,32,6,18,4,12,12,,3,20,,3,6,4,4,6,4,6,3,,,3,
   17,17,18,3,17,3,18,18,3,18,17,4,,,,,4,,,,,4,26,21,,21,
   26,4,,,19,23,,6,4,3,4,,4,4,4,,4,17,4,20,4,17,4,4,4,
   4,4,20,,6,,6,,7,7,,5,33,6,,6,33,5,51,51,6,6,,4,,4,,
   5,5,,4,25,4,,4,25,4,25,25,4,4,,4,3,4,20,4,,4,32,4,
   18,12,18,3,,6,12,4,17,4,3,5,,,5,79,9,79,5,70,4,,9,4,
   ,70,4,4,,,12,17,,18,3,17,12,4,4,4,6,32,5,,,5,79,9,
   79,5,70,4,,9,4,,70,4,,21,,4,26,,,23,19,23,,4,26,,23,,,
   26,4,,21,25,35,4,,26,,,,,,,,,,,,,25,12,55,11,18,4,3,4,
   12,13,71,55,,44,,18,18,25,117,71,18,25,4,190,11,12,12,
   3,4,18,25,,190,117,70,18,18,,88,14,15,10,4,3,18,25,25,
   18,44,55,,4,3,11,12,55,4,10,12,70,11,18,71,4,25,25,4,
   4,4,4,4,,,,,,3,4,4,4,5,4,4,4,4,,,,5,,,70,,70,,4,9,79,
   5,4,5,136,9,,4,,5,,3,5,,5,4,4,4,4,5,3,4,3,,,4,,,27,
   5,5,,16,5,25,53,4,4,5,25,16,5,4,3,,,,,,6,4,4,4,4,6,
   3,4,4,,,4,,28,28,6,5,,16,6,16,,5,5,5,16,16,6,4,4,6,
   6,6,,,3,3,4,3,4,3,3,3,4,,4,,,20,4,20,,12,4,17,6,36,
   4,3,17,12,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,28,28,6,5,,
   16,6,16,,5,5,5,16,16,6,5,6,,,6,4,3,4,4,6,3,4,4,,,4,
   ,5,20,5,5,,12,5,5,9,6,6,5,5,12,5,,5,,,4,4,4,4,5,4,
   4,3,,,,,,117,7,,,49,5,,35,8,4,5,9,96,7,,,,4,4,4,4,5,
   4,4,4,,,,,,,,54,,46,25,25,54,,5,5,27,46,25,,,4,3,4,4,
   6,4,4,4,,,,,6,55,28,,,36,17,6,9,,6,4,6,30,17,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,4,4,6,5,6,6,5,5,6,,88,,,,,,,,39,25,10,,6,
   5,22,,,4,,4,,3,4,4,,,3,,,19,4,3,,12,4,17,6,4,36,20,
   18,12,4,4,,,4,,5,5,,5,,5,,7,4,,30,5,4,8,4,8,,4,30,5,
   4,40,,4,4,,,,,,22,6,4,,24,6,6,6,6,24,12,,12,4,,4,3,,5,
   ,5,,5,,,4,,70,,4,9,5,79,70,5,79,9,6,,,,,7,,,,,5,,,43,
   23,10,6,,,38,,,4,4,3,,,,4,24,6,4,,14,6,4,6,6,6,4,4,
   14,6,,5,,5,,5,,,4,,70,,4,9,5,79,70,5,79,9,5,,5,,4,,,4,
   ,28,25,4,7,5,,29,4,28,26,,4,,55,28,6,5,,17,6,30,9,5,
   ,7,45,17,6,,,,,,,,,,,,,,,,,,,5,,,42,,,,5,9,75,7,5,4,20,8,,
   ,,,,,,,,,,,,,,28,5,25,,17,5,,32,26,36,22,,17,5,,,,,19,20,,,
   ,,27,,,31,,,,5,,,,31,5,,,,39,15,12,8,,4,4,13,39,18,,,,,,,,
   ,,,,16,88,34,32,34,12,31,14,5,155,,60,17,4,14,5,28,12,
   13,11,4,12,4,8,8,8,17,115,,6,4,12,93,85,,19,62,107,
   12,35,18,16,5,,4,,,5,,5,,,,4,4,5,3,4,4,4,3,4,4,4,3,,
   5,,41,26,4,,29,26,41,4,4,,5,7,4,4,4,,,,6,22,3,3,3,3,
   4,3,3,3,,4,4,4,6,6,,12,4,4,,4,4,12,3,3,6,6,6,3,,,5,
   ,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,70,,70,4,5,
   136,5,9,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,,
   70,,70,4,5,136,5,9,,5,,7,,4,3,5,3,5,4,4,4,4,3,4,4,,
   4,,49,7,4,,,7,49,5,5,8,4,8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   3,4,4,4,5,4,4,4,,,,,7,88,,35,8,49,,5,,,5,4,7,75,9,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,6,4,5,6,6,5,6,28,9,7,,,,,,37,
   ,55,,,5,5,,,,20,20,29,19,28,28,28,27,36,55,,117,,,,,,,,,
   19,,20,27,,,,4,,3,,4,4,4,,4,4,4,,4,,12,4,3,,18,4,12,
   18,18,36,4,6,,4,5,,,5,4,,3,5,6,6,,12,5,4,,4,5,12,5,
   5,5,5,7,4,55,,,,,,,,,6,,17,6,5,,7,6,17,45,36,,5,9,,4,
   4,4,4,6,6,6,4,,,12,4,18,,3,4,12,18,17,4,36,6,28,28,,
   ,6,9,,,,,17,5,25,,25,5,17,,,36,23,35,3,,4,,,,6,6,,16,
   6,5,,5,6,16,16,16,6,6,12,,4,,,,6,6,,16,6,5,,5,6,16,
   16,16,6,6,12,4,5,6,,5,5,,16,5,5,,5,5,16,25,25,4,4,
   53,4,4,4,40,6,,24,6,4,,12,4,12,,6,24,6,6,,5,6,,,45,
   17,9,,5,17,30,6,6,5,,7,,6,,,31,6,,,4,6,31,6,6,5,9,9,
   5,,,75,7,,,5,5,42,,9,4,8,35,6,,,43,5,,,,,38,25,,6,10,,,,
   ,,5,43,,25,38,6,,10,,,,,,,,,,,,,,39,,54,24,31,12,16,32,
   53,78,15,,17,5,24,4,5,60,83,91,,4,17,42,13,12,4,7,8,,,
   ,,,,,,27,59,15,12,7,4,8,,5,4,82,63,191,16,12,74,43,82,
   4,19,13,21,12,19,19,6,8,8,4,,4,,,4,,5,4,4,4,4,5,3,
   4,3,,,4,4,,,4,4,,25,4,25,,4,4,4,25,25,4,,4,,5,5,,,4,
   4,5,3,4,4,4,3,4,4,4,3,,5,5,25,25,4,4,,25,25,4,4,,
   4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,5,4,4,4,3,5,3,5,4,
   4,4,3,4,,4,,5,,4,25,25,,5,5,5,25,4,25,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,4,,,4,4,4,4,5,3,4,3,,,,4,,,4,7,,41,4,25,29,,
   4,5,26,41,4,,,4,4,4,3,5,3,5,4,4,4,3,4,,4,,,26,4,41,
   25,,7,5,4,26,4,41,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,5,3,4,4,
   4,3,5,5,20,4,,,,,26,23,19,,26,,4,4,,21,21,3,,4,,4,,4,,
   ,4,4,,5,5,4,25,4,4,,25,4,25,25,,4,4,,4,,4,,4,,,4,4,,
   5,5,4,25,4,4,,25,4,25,25,,4,4,4,27,,3,4,,,,4,,5,5,5,
   25,4,4,47,25,5,16,16,,5,5,,3,4,3,6,6,4,4,,,3,3,17,
   17,3,18,18,3,17,18,17,18,3,4,,,,,4,,,,,4,26,20,20,,26,
   4,,,,22,21,4,3,4,4,,3,,4,4,4,17,4,4,20,17,4,4,4,20,
   4,4,,,,4,,,5,,4,26,4,,26,26,4,41,41,,5,7,4,4,3,,,3,,
   3,18,3,17,18,18,3,18,18,18,3,18,3,4,4,,,5,5,136,9,5,
   79,70,4,,9,70,,4,4,4,,,5,5,136,9,5,79,70,4,,9,70,,4,
   3,,,4,12,17,,3,18,17,12,4,4,32,6,4,,4,20,4,18,4,12,
   18,20,3,,6,17,4,12,,,,,,,,,,,,,,,4,25,,,4,26,,31,23,21,26,
   ,4,19,,4,,26,,23,21,23,26,4,,25,12,10,70,18,4,3,4,
   117,12,15,55,44,,,18,18,25,,190,88,4,25,71,16,13,12,18,
   4,3,25,117,11,12,11,18,3,4,18,71,71,55,,18,18,25,25,
   18,,55,44,4,3,70,12,10,4,55,12,11,190,11,14,25,25,4,
   4,4,5,,5,5,,4,3,5,4,5,4,3,3,,4,,4,,,4,,4,25,4,25,4,
   ,4,4,25,25,4,,,,,,6,4,4,4,4,6,3,4,4,,,4,,28,28,6,5,,
   16,6,16,,5,5,5,16,16,6,4,,,6,6,4,3,4,4,6,3,4,4,,4,
   4,,4,4,4,5,5,4,4,4,5,5,5,5,4,4,4,,4,,7,4,4,4,4,5,
   3,4,3,,6,5,4,,,4,5,30,,4,,30,5,4,4,8,8,4,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,6,,4,3,4,4,6,3,4,4,,4,5,6,5,5,20,,4,5,
   12,5,5,7,5,4,5,5,12,6,5,6,5,5,6,4,6,4,,,5,6,,,,5,,,
   21,,,5,5,5,,,20,5,4,7,5,6,6,4,4,,5,,6,,,,,5,,20,,5,,
   5,5,,,21,4,,3,,4,4,4,,5,5,5,,,4,4,4,25,4,25,4,4,,,
   25,25,4,4,4,6,3,,3,,,3,3,6,6,4,3,4,4,3,4,4,3,4,4,
   4,4,3,,,,4,4,,5,,5,,,4,5,4,8,4,8,4,5,30,30,,,4,,4,4,
   4,,5,5,5,,,4,4,4,25,4,25,4,4,,,25,25,4,6,22,,,7,7,,,,
   ,5,5,,22,,5,5,,,,,21,3,3,,3,,3,6,6,4,4,3,6,4,6,3,4,
   4,4,6,6,4,,,,3,,6,6,,3,4,4,,4,4,3,12,12,6,6,6,,3,3,
   ,4,4,,3,3,4,17,4,3,3,18,18,4,4,17,,,,,,,,,,,,,,,,,,,4,4,
   ,,4,4,30,8,4,8,30,4,5,5,,,4,4,,,4,30,4,,4,,4,30,5,
   5,8,8,4,5,5,20,5,5,5,12,5,4,4,,7,5,5,12,3,4,,,,4,,,,
   ,,,,4,4,,,,4,,,,,,,,4,18,22,4,,4,20,22,20,22,4,4,,4,25,
   10,25,4,6,4,4,43,43,12,37,12,37,6,4,4,4,25,25,10,4,
   3,37,37,25,37,4,4,3,4,11,12,11,11,3,3,3,37,37,25,37,
   4,4,3,4,4,4,37,37,12,4,4,25,25,10,6,37,37,11,37,37,
   12,3,4,4,,,5,,,,4,4,5,3,5,4,4,4,4,4,4,4,,5,,79,9,4,
   ,70,,70,4,5,136,5,9,5,5,,5,,4,3,5,3,5,4,4,4,4,3,4,
   4,,4,,,5,4,25,25,5,,5,5,25,4,25,6,6,,,5,6,6,4,5,5,
   6,4,5,6,5,4,,7,7,33,51,6,6,,51,33,5,5,,6,6,6,7,,5,
   4,6,6,7,5,4,4,,6,,6,,,5,,6,51,5,33,6,,6,6,33,51,5,7,
   ,5,4,6,4,7,5,6,6,5,4,5,6,,5,,,6,5,51,33,6,,6,6,33,
   5,51,,4,4,5,3,4,4,4,3,5,20,5,4,,,,26,,22,21,,,26,4,4,
   ,23,19,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,3,4,4,,4,,4,,5,5,
   25,4,5,5,,4,25,25,25,,5,5,6,3,4,4,,3,4,,4,3,,4,4,
   17,4,3,3,18,4,17,4,4,18,3,3,6,,,6,6,,6,,6,,7,7,33,
   5,6,6,,5,33,51,51,,6,6,,4,3,3,6,4,6,4,,,3,17,3,18,
   3,18,3,18,18,18,18,18,3,,20,,,4,,,,,,26,4,23,27,,4,26,,,
   ,22,25,4,4,,4,,4,,5,5,25,4,5,5,,4,25,25,25,,5,5,,4,,
   4,,,4,,18,4,3,,20,4,18,12,12,18,4,6,4,3,4,,,3,,18,3,
   3,18,18,3,18,18,18,18,3,18,4,3,4,,,5,136,5,,4,70,4,
   70,,9,79,9,5,4,3,,,4,17,12,6,4,36,12,17,4,4,20,,3,4,,
   ,5,136,5,,4,70,4,70,,9,79,9,5,,4,20,18,4,4,12,18,3,
   20,,6,18,4,12,,,,,,,,,,,,,,,4,,23,,4,26,22,,21,19,26,,4,,
   22,4,,26,23,,27,25,26,4,,25,190,88,,18,,18,25,,62,65,
   11,14,190,4,18,3,4,62,11,10,4,25,12,55,11,14,18,4,3,
   25,11,44,11,10,18,3,4,55,,44,88,,18,18,25,4,3,190,11,
   14,25,18,,190,88,4,88,14,10,65,10,11,25,25,4,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,4,6,3,
   4,4,,,,,29,48,6,9,,36,6,17,,,4,6,17,45,6,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,4,7,4,6,6,5,5,6,5,
   36,6,,,,,10,26,,,,,5,6,,21,51,,,4,,4,3,,,,4,,,5,,5,9,4,,
   70,,4,70,79,79,5,9,,4,,4,,5,3,,4,5,,5,7,4,8,4,5,30,,
   4,,8,30,4,5,4,88,,,,,,,,,5,,7,9,4,8,35,,5,49,96,,5,,,
   3,4,4,6,6,4,6,19,,4,4,6,17,4,12,,3,20,32,12,18,4,6,,
   ,,,6,,,,,6,10,24,,,,5,,,,27,41,4,4,4,4,,4,24,4,6,6,6,
   4,6,14,,4,4,6,14,4,6,,,,4,,,5,,5,9,4,,70,,4,70,79,79,
   5,9,6,5,4,,,4,,5,7,4,25,28,,4,26,,28,4,26,,4,,,9,9,
   5,9,6,6,31,,4,,9,31,6,6,4,5,88,,7,4,20,9,7,75,,5,,
   8,42,,5,4,36,,6,14,6,,4,12,,12,4,6,14,6,6,55,6,29,6,
   9,6,17,30,,4,,,50,6,17,28,,,,20,19,,,,,,,27,,5,24,32,,5,
   17,,21,22,32,17,,5,,,5,,,,34,34,,,5,,8,13,64,32,,,4,6,
   74,14,132,25,119,88,,8,8,8,,19,91,5,16,,11,12,12,12,4,
   4,,,16,15,59,14,4,5,,34,39,34,31,12,14,,,,,,,4,4,34,13,
   14,,42,13,18,52,17,83,16,,5,4,,,7,4,4,4,3,5,3,5,4,4,
   4,3,4,,4,,7,49,4,,,49,7,5,5,8,4,8,,6,,4,3,4,4,6,3,
   4,4,,4,,,5,20,5,9,6,12,5,5,5,,5,6,5,12,5,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,6,5,6,5,4,6,4,7,5,6,24,4,6,,,,6,,26,,,,6,
   6,6,,26,,5,4,7,4,6,6,5,5,6,4,24,6,,,,,6,26,,,6,,6,6,
   ,24,,4,,4,,4,,3,,4,4,,,4,,5,5,4,25,25,5,5,,,25,4,25,
   4,3,6,3,,4,4,,3,4,6,4,6,4,6,3,4,4,6,4,6,6,4,3,4,
   4,,,6,,,4,,,,4,,7,5,4,8,8,5,7,49,49,,4,,,3,4,4,6,4,
   4,6,4,,4,4,4,17,4,4,4,4,20,20,4,17,4,6,,,,6,6,,,,,6,
   6,24,,,6,6,,,,26,,4,4,4,3,,4,6,4,6,6,4,4,6,6,4,6,6,
   6,6,4,6,,,,4,,,4,,5,7,4,,,7,5,49,49,8,4,8,,4,4,,,4,,
   5,5,4,25,25,5,5,,,25,4,25,4,4,3,28,6,28,6,6,6,16,
   16,5,5,,12,16,6,16,3,4,6,,6,4,14,6,6,6,14,4,6,6,4,,
   4,4,6,,6,14,4,,4,4,4,14,6,6,6,6,6,28,6,28,6,6,6,
   16,16,5,5,,12,16,6,16,4,3,,,4,,,,,,,,4,,4,24,22,,4,4,
   22,20,24,20,4,,4,,,4,,,,,,,,4,,6,13,28,28,4,9,4,6,31,
   12,31,11,59,59,9,4,4,6,28,13,28,4,4,13,11,12,13,3,3,
   3,3,28,59,31,28,4,3,4,28,59,31,28,4,3,4,6,6,4,59,
   11,59,6,4,28,13,28,9,31,13,31,59,11,59,4,3,4,4,,,4,
   4,4,4,5,4,4,3,,,,4,,,5,9,79,70,4,,70,,4,5,9,79,5,,,
   4,4,4,3,5,4,5,4,4,4,4,4,,5,,,70,4,70,,79,9,5,4,9,
   5,79,,27,28,28,20,28,20,29,20,88,,48,22,,,,19,,,,,,,27,
   20,,,,5,6,6,4,5,5,6,4,7,,29,6,,,,,,37,55,,,,5,5,,,,,,4,
   ,5,,4,,3,5,4,,5,5,5,16,5,5,,16,5,25,25,53,4,4,3,4,
   28,,,4,,,,4,,6,6,6,16,5,5,,16,6,16,16,,5,5,4,28,,,4,,,
   ,4,,6,6,6,16,5,5,,16,6,16,16,,5,5,,4,4,3,6,6,6,4,,,
   4,4,12,20,3,,12,4,17,18,6,36,4,5,55,,,,6,,,,,5,17,21,
   29,,17,5,,,53,22,26,,4,5,6,,4,,6,6,5,12,5,5,,12,5,5,
   5,9,6,6,,,,,,,6,,6,17,4,,,17,6,36,45,,6,9,4,4,4,,,4,,
   4,12,3,20,,12,4,18,18,6,4,36,,5,4,,,5,7,75,,5,,49,5,,
   9,35,8,4,,4,,,5,27,46,54,5,,46,25,25,25,54,,5,4,,,6,
   17,45,,4,,36,17,6,6,9,,6,,6,40,6,24,4,12,,12,4,,6,6,
   6,24,,,,,,,,,,,,,,,6,,,,5,,,39,25,38,10,,6,71,,5,,,,,22,27,
   10,6,,,17,27,,24,5,4,5,83,107,,42,59,,31,24,12,16,,52,
   35,4,,39,15,12,13,8,,4,,54,17,14,14,8,4,,,,,,,,,,16,12,
   88,34,77,5,4,155,,85,4,28,12,12,19,19,12,8,8,6,6,,4,
   3,4,4,6,4,4,4,,4,,,6,28,28,,5,16,16,6,5,,5,5,6,16,
   16,,5,6,5,5,6,4,6,4,,117,,6,,,,10,,,25,39,,,5,6,,,38,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,4,,,,5,4,4,,5,,5,,,4,7,5,41,4,26,4,
   ,29,,26,41,4,4,4,6,4,,3,,,,3,6,22,4,6,6,12,3,4,4,,
   4,6,4,12,3,3,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,70,79,,
   70,4,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,70,79,,70,4,,40,,,
   7,,,,,,10,6,,22,,5,,,,71,,27,4,4,,5,,5,7,,5,8,4,49,5,
   7,4,,,8,7,49,5,,,,,,6,22,,6,6,12,,4,4,,12,24,6,24,6,,
   3,,,4,20,,6,4,12,18,4,3,,20,36,4,12,18,,,,,,,,,,,,,,,,,,,,
   4,,,5,9,96,35,4,8,49,,5,7,,,5,,,,,,,,,,,,,,,,,6,29,55,,6,
   17,36,6,4,,,9,6,17,45,,5,,,,5,,37,,55,,,,5,28,,,,27,,,,,,
   19,,20,53,22,17,,5,21,,29,26,5,17,,8,88,28,155,8,,8,8,
   83,,19,34,12,106,,,4,6,107,52,19,16,,39,,54,77,24,31,
   12,5,12,,14,12,4,12,4,15,,17,85,5,24,4,,4,4,17,42,13,,
   ,,,,,27,59,14,106,35,12,,5,16,,5,6,5,4,6,4,7,5,6,22,
   5,5,,,,,,26,,,,10,6,5,47,24,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,
   5,,,,4,5,3,,4,,,4,4,41,26,5,7,,26,26,4,41,4,3,6,4,,
   4,4,,4,4,6,4,22,,4,3,12,4,6,6,6,4,4,3,12,4,,,,3,,4,,
   ,,5,,,4,5,79,9,5,9,79,70,,4,70,,4,4,4,6,4,6,6,4,,20,
   ,3,18,12,4,4,6,32,20,4,18,12,,88,,,6,,,,,,,5,23,,47,6,
   10,,,,26,,,,5,4,,6,7,5,,,4,5,49,7,4,8,8,,7,5,49,,,,,,,
   5,,,5,5,,,7,9,96,49,8,4,35,,4,,,,5,,,4,5,79,9,5,9,79,
   70,,4,70,4,5,,29,6,55,,5,6,45,17,5,7,,9,17,6,36,4,4,
   6,,40,,12,6,24,6,24,6,6,4,4,,12,,7,,88,,5,,49,5,4,35,
   8,,7,9,96,,,,,5,27,46,27,5,48,,27,27,27,46,5,,,37,5,,,,,
   ,37,,5,,28,,25,,17,5,22,47,24,37,5,,17,,,27,,,,,,,19,20,,
   ,,,,,,,,,,,11,34,16,,8,4,4,18,12,35,16,5,13,25,14,12,4,
   4,12,,32,88,53,66,24,12,31,64,119,132,17,5,4,24,8,6,
   4,82,17,62,8,8,83,17,115,,63,13,45,21,19,59,5,,16,4,
   4,5,4,4,4,5,4,6,28,28,6,,,,,,,,,,,4,4,,,,,,5,,4,,5,,,4,
   5,,,,4,,22,23,,,4,26,26,,23,19,28,,3,4,,,,,5,,,,,4,,,,,,4,
   ,,,,,5,28,,,5,,55,,5,,,,5,,22,24,47,,5,17,17,,25,37,,4,,
   5,7,,5,7,,,,4,,,25,21,,4,26,26,23,,31,4,,,,,5,,,,,4,,,,,,
   4,,,,,,6,4,4,20,,4,,,,4,,22,24,20,,4,4,4,24,22,20,,,,6,,
   ,,,5,,40,,31,,5,,,,,,5,,4,,,,,4,,23,,19,,4,26,26,21,22,,,
   5,6,,,,6,,43,25,,,5,,10,,,34,28,,,,,27,,,,,,20,19,,,,,5,,,,
   17,,,22,19,,17,5,5,24,32,32,,,,6,,43,,23,,5,,10,21,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,57,51,80,,5,3,4,67,126,,,,,,,
   ,,,,,,,,100,126,76,,,,,,80,67,62,,,,,,118,74,,,,,,,,,,4,3,
   62,76,,5,51,57,,80,100,118,,,,4,,5,,,5,5,,4,,5,,,,,4,27,
   35,,4,,26,26,,23,25,6,4,4,4,,4,4,,20,4,,,,,4,22,18,22,
   4,,4,4,20,20,22,,,,,,,6,,,,,,,5,,,,5,,,,,37,37,,,5,5,7,5,
   ,7,,,,,4,,19,23,4,,26,26,21,,23,3,28,,,5,,,,,,,4,,,,4,,,,,
   ,,28,,,5,,,,,,,4,,,,4,,,,,,,,5,,55,,,,,,5,25,,23,5,,17,17,
   20,28,32,5,4,,,,,,,4,22,,25,4,,26,26,27,23,,5,,6,,,,,6,,
   34,,5,,,10,,43,25,28,5,,,,,17,32,36,26,17,,5,5,25,,22,,,,
   ,,27,,,,20,,19,,,,,,,,,6,,,23,5,,,10,23,38,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,100,118,80,5,,3,4,67,48,51,,,
   57,,55,107,,,,,,,80,194,,,,51,,74,143,,,,,4,3,98,75,155,,,,,
   ,5,75,98,67,50,55,74,,,,,4,,4,,4,,,4,4,,5,5,4,25,4,4,
   ,25,4,25,25,,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,,5,5,5,,,
   4,4,4,25,4,25,4,4,,,25,25,4,,,,,,,,,,,,,,,,,,,,,,,4,4,,4,,
   4,,5,5,25,4,5,5,,4,25,25,25,,5,5,,,,4,,,5,,5,9,4,,70,
   ,4,70,79,79,5,9,,4,4,,,4,,5,5,4,25,25,5,5,,,25,4,25,,
   ,,,,,,,,,,,,,,,,,4,4,,,5,4,41,7,5,,41,4,25,25,26,,4,4,,,
   5,41,4,,4,26,4,41,25,25,,7,5,,5,27,4,4,5,16,25,5,5,,
   26,25,5,16,,,,,,,,,,,,,,,4,23,22,,4,26,23,19,,,26,,4,35,
   27,4,,26,23,25,,,26,4,,4,11,18,117,3,4,18,25,70,10,12,
   18,11,71,4,3,18,25,70,12,10,4,25,12,10,70,71,18,4,3,
   25,10,12,70,117,18,3,4,55,44,,18,,18,18,4,25,18,71,16,
   11,25,18,117,11,18,,18,71,117,,55,44,25,25,4,4,28,,,4,,,
   ,4,,6,6,6,16,5,5,,16,6,16,16,,5,5,,4,,4,5,,5,5,5,,
   5,4,25,,4,4,25,4,25,25,4,,4,4,,,,,5,,,,,4,,,,,,4,,,,,,,
   4,4,,,4,6,6,6,4,4,5,5,5,4,4,4,4,5,5,5,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,5,5,,4,25,4,,4,25,4,25,25,4,4,,,4,4,,7,5,4,
   8,5,4,30,,4,,8,30,5,4,,,,,,,,,,,,,,,,,,4,6,,6,12,5,,4,4,
   5,12,5,5,5,7,5,5,7,,4,8,5,30,4,,4,,8,4,5,30,6,6,22,
   ,5,5,,,21,,,,5,5,6,21,,,5,5,,20,,,5,,5,20,,5,,5,,21,,,
   5,5,,4,12,10,11,3,3,3,4,11,11,12,37,25,37,4,3,4,3,
   25,37,37,4,4,25,10,25,37,4,6,4,4,43,12,43,25,4,4,6,
   37,12,37,37,6,4,4,4,3,4,37,37,25,4,3,11,12,10,4,37,
   37,25,25,37,37,4,4,4,,,4,4,,5,,5,,,5,9,5,79,5,9,4,,
   70,79,,70,4,,,,,28,,,,,,19,20,,,,27,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,5,,27,27,5,,48,27,27,46,46,,5,27,,4,,,,5,,,4,5,79,
   9,5,9,79,70,,4,70,,,,,,,,,,,,,,,,,,,,4,,,6,6,30,9,6,,36,
   6,17,17,,,4,,,,,,,,,,,,,,,,,,7,88,8,4,7,96,9,5,,,35,,5,49,
   ,,,,,,,,,,,,,,6,47,24,,6,10,26,,,,,,5,,26,6,,10,23,47,,,,5,
   ,5,82,63,83,4,5,24,,,18,21,17,13,17,4,4,12,16,,12,19,
   6,8,13,64,32,62,,,4,8,14,132,53,45,,4,,25,119,88,115,,
   8,8,5,16,12,,11,12,,24,,16,17,31,,34,66,,35,59,,,4,,,,,,,
   ,,,,,,,,,,,,,,,,4,4,5,5,,5,5,,5,25,4,,5,5,4,25,25,25,5,
   ,5,,5,,5,,5,,,4,,70,,4,9,5,79,70,5,79,9,5,5,5,,4,,,
   4,4,25,25,4,4,4,,,4,25,25,6,6,6,,,5,6,6,33,5,51,6,6,
   ,,51,33,5,6,6,7,,7,5,51,,6,6,51,5,33,33,6,,6,6,7,,
   7,51,5,,6,6,5,51,33,33,6,,6,5,,,6,6,33,51,5,6,6,,,5,
   33,51,,4,20,20,26,4,,22,21,,,,26,4,,,,,,,,,,,,,,19,23,26,,
   4,21,21,,,4,26,,4,44,10,11,3,4,18,25,12,117,11,55,12,
   12,4,3,18,25,13,71,16,25,25,190,88,,,18,,18,4,12,15,
   117,70,3,18,4,11,14,190,55,4,18,3,4,25,18,12,55,12,
   25,18,11,44,10,,55,,70,71,18,71,25,4,25,28,,,5,,,,,,,4,,,
   ,4,,,,,,,,,,28,,,,,27,,,,,19,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,6,,,,,5,,,,,,5,,,28,,31,,,,,,5,,34,34,5,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,98,75,67,3,5,,,,
   55,74,75,98,155,5,3,,,80,57,51,,,48,55,,,,,,,67,50,,,,,,
   51,74,,,,,,4,,,,100,80,,,,107,143,,,,,,,,,,,,4,,,,6,6,,16,6,
   5,,5,6,16,16,16,6,6,12,4,4,,,5,5,,25,4,5,,5,4,25,25,
   25,5,5,,4,,4,,7,5,8,4,7,5,49,4,,,8,49,7,5,,4,6,,6,
   5,12,9,6,6,12,5,5,5,5,,5,,,,,,,,,,,,,,,,,5,7,,8,4,7,49,
   5,4,,,8,5,7,49,6,6,,24,6,6,,26,,,,,6,6,6,,26,,6,6,26,,
   ,,6,,6,,26,6,,6,24,,,,6,6,,4,59,28,28,3,4,4,3,31,28,
   59,11,13,13,3,3,3,4,12,13,11,6,6,13,28,28,59,4,9,4,
   6,12,31,31,28,4,4,9,11,59,59,28,9,4,4,4,4,3,13,11,
   13,3,4,28,59,28,4,28,59,28,31,28,59,6,6,6,,,,,,,,,,,,,,,,
   ,,,,,4,,117,7,,4,8,5,,42,,5,,35,75,7,9,,,,,,,,,,,,,,,,,,,6,
   ,,50,6,,,4,6,30,17,17,6,9,,,,,,,,,,,,,,,,,6,,23,38,5,,,,
   23,,,,6,10,,21,,,,5,43,23,,,6,,10,,,,,,,,,,,,,5,15,,13,4,
   4,12,16,12,13,22,25,,17,5,4,24,,107,,123,,4,17,12,54,
   59,4,,8,,,,,,,,,15,12,39,42,,4,8,5,,24,,85,101,16,12,13,
   15,15,31,34,77,,52,35,,6,8,8,4,4,,27,5,,4,4,5,25,16,
   5,5,,47,16,5,25,4,,5,,,4,28,7,,5,28,4,25,25,4,,26,,5,,
   ,28,4,,26,4,4,28,25,25,5,7,,,,,,,,,,,,,,,,,4,,27,23,4,26,
   ,22,25,,,,4,26,,21,22,,26,4,23,19,,,4,,26,,,,,,,,,,,,,4,
   14,88,10,3,4,18,25,11,11,44,11,190,14,4,3,18,25,11,
   12,55,25,4,11,10,62,190,3,4,18,25,62,65,,,18,18,,10,
   11,65,88,4,3,18,4,25,18,14,11,190,25,18,10,14,88,,88,
   190,,44,55,,4,25,25,4,4,,,5,5,136,9,5,79,70,4,,9,70,,
   4,4,,,5,136,5,,4,70,4,70,,9,79,9,5,28,6,28,6,6,6,16,
   16,5,5,,12,16,6,16,,28,,,19,20,,,,,,,,27,5,,,,5,,37,55,,,,
   ,5,32,23,5,,17,25,25,,35,17,5,,6,82,17,74,4,7,,8,32,
   60,12,63,13,43,7,4,,8,53,83,17,5,,17,27,,191,24,5,4,
   16,13,15,,21,12,4,4,42,59,,82,31,24,12,4,,8,39,15,12,,
   8,54,17,12,,,,,78,91,19,,16,5,4,6,,6,16,16,,5,5,16,16,
   6,6,5,,5,5,,,5,79,9,79,5,70,4,,9,4,,70,,6,22,,10,6,,,
   25,35,,,,5,,,,,,,,,,,,,,38,,10,,6,,23,43,,5,,,16,17,19,12,
   12,4,4,5,13,,12,115,62,93,31,12,14,,39,,35,8,8,88,28,
   155,149,8,,8,6,32,13,60,107,4,,,34,12,106,85,,,4,16,,
   14,39,,34,5,4,12,,11,5,14,,17,18,,18,,4,,5,,,79,5,,70,
   4,4,70,,9,5,9,79,,6,,21,,5,,26,,,51,,10,6,,,,,,,,,,,,,,,
   27,,,5,24,,,41,6,10,,16,,42,34,12,31,14,,74,,52,,13,13,
   4,12,4,5,14,19,17,,,,,,,,,,4,12,39,15,18,4,8,,10,34,16,
   14,,8,4,16,5,4,13,25,12,,14,32,88,34,5,64,119,59,132,
   91,83,8,6,8,5,28,20,28,5,17,,25,23,,32,,5,17,,,,,,5,
   40,31,,,5,,,,,19,,20,,,,,27,,,6,106,34,13,4,,,8,12,107,
   52,85,77,15,,4,,8,13,106,35,,5,17,15,,101,4,5,24,16,
   54,39,,,12,24,31,12,12,,15,4,4,12,4,,8,15,25,59,,8,13,
   17,42,,,,,22,123,,5,16,,4,,,,4,,,,,,,,4,,,4,,,,,,,,4,,,98,
   75,,,,,,,67,50,75,98,,,,,,,48,55,4,,57,51,80,155,,5,3,,
   55,74,,67,,3,5,,,,,,,,,,,,100,107,,,,80,143,,,,,,51,74,,,4,,,
   ,,4,,,,,4,,,,,51,62,,,,,67,,80,,57,76,,,,,126,,100,,,,,,,,,,
   4,126,,67,80,3,,5,100,118,80,74,5,,3,,,,57,,76,,,,,,,51,,
   62,118,,,,4,,,118,,194,,,,,80,,,100,,107,,,,,55,57,,,4,48,
   51,67,80,3,5,,,,,,,,,,55,74,50,143,5,3,,,,,98,75,,,,67,
   155,,,75,98,,74,51,,4,,,37,37,25,4,4,3,4,43,25,37,37,
   25,28,37,22,59,22,25,20,28,28,37,28,28,28,28,37,28,25,
   22,28,43,19,18,4,3,3,22,28,28,4,4,43,25,37,4,28,22,
   22,31,28,59,43,31,25,37,37,37,28,28,37,28,37,28,59,25,
   20,22,25,22,28,37,37,20,28,37,25,20,21,4,4,4,25,37,
   37,3,3,19,20,28,4,28,28,28,25,37,37,25,28,37,4,25,37,
   43,25,3,4,4,37,37,25,37,4,4,3,37,25,20,28,37,20,28,
   21,28,37,28,25,28,25,19,28,37,20,4,3,4,28,59,31,28,4,
   3,4,25,43,19,22,28,25,31,18,22,28,37,43,28,22,43,22,
   28,25,3,4,4,37,37,28,37,28,21,59,21,25,20,21,37,37,
   20,18,37,28,21,4,4,3,4,3,25,37,37,4,37,37,25,20,28,
   20,37,59,37,4,28,59,28,18,21,21,25,28,37,37,37,25,37,
   31,25,37,59,37,4 ],
 [ 6,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,6,6,4,
   6,6,,,4,4,6,,6,,,,,,4,4,,4,,6,,6,,,8,8,,,,22,,,22,,,22,,,
   ,,22,6,4,8,8,,4,8,,8,,,6,6,8,6,8,12,6,8,12,16,4,4,
   4,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,22,,,
   22,22,22,,,6,12,12,,6,12,,12,,,12,12,18,12,18,24,12,18,
   24,30,6,6,6,6,6,6,,,6,6,6,,6,,,,,,6,6,,6,,6,,6,,,,,,,,,,
   ,,,,,,,,,,4,4,,2,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,
   4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,20,20,
   20,20,20,20,20,20,20,20,20,20,4,,4,4,,4,,,8,8,12,8,
   12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,
   ,12,,12,,,,,,,,,,,,,,,,,,,,,4,4,,4,,,8,8,12,8,12,16,8,12,
   16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,4,,4,,,4,4,4,4,4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,
   4,4,4,4,,,,2,4,,4,,4,4,4,,,4,4,,,,20,20,20,20,20,20,
   20,20,20,20,20,20,,4,,,8,8,12,8,12,16,8,12,16,20,4,8,
   8,4,8,8,,,8,8,12,,12,,,,,,4,8,,8,,12,,12,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,8,12,
   8,12,16,8,12,16,20,4,8,8,4,8,8,,,8,8,12,,12,,,,,,4,8,
   ,8,,12,,12,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,4,4,6,6,6,6,8,8,8,4,6,6,4,6,6,,,6,6,8,,8,12,12,,,
   ,4,6,,6,,8,,8,,,,,,,,,138,138,,48,62,138,62,48,62,62,
   138,4,4,4,4,6,6,6,8,4,6,6,4,6,6,,,6,6,8,12,8,,,,,,
   4,6,,6,,8,12,8,,,,,,,,138,,,138,138,138,,62,138,62,138,,
   6,6,6,8,10,10,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,
   8,,16,,16,,,,,,,,,,,,170,170,,,170,,170,,4,6,4,4,4,8,4,6,
   6,4,6,6,,,6,6,8,,8,,,,,,4,6,,6,,8,,8,,,12,12,,,,48,138,
   138,48,,,138,138,,138,,138,6,6,6,6,10,4,8,8,4,8,8,,,8,
   8,16,,16,,,,,,4,8,,8,,16,,16,,,,,,,,170,,,170,,,,170,,170,,,
   8,10,10,8,4,12,12,4,12,12,,,12,12,8,28,8,,,,,,4,12,,12,
   ,8,28,8,,,,,,,,,,,,,,,,,,,,4,6,8,4,6,6,4,6,6,,,6,6,8,,
   8,12,12,,,,4,6,,6,,8,,8,,,,,,,,62,62,62,62,138,138,48,,
   138,,138,48,6,10,4,8,8,4,8,8,,,8,8,16,,16,,,,,,4,8,,8,
   ,16,,16,,,,,,,,,170,170,,,,170,,,,,170,8,4,12,12,4,12,12,,
   ,12,12,8,,8,,,,,,4,12,,12,,8,,8,,,28,28,,,,,,,,,,,,,,,,6,
   16,16,6,16,16,,,16,16,10,,10,,,,,,6,16,,16,,10,,10,,,,,,,,,
   ,,,,,,,,,,,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,
   ,,4,4,,,,20,20,20,20,20,20,20,20,20,20,20,20,4,4,4,4,,
   ,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,22,,,22,22,22,,
   ,4,4,4,,,6,6,6,8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,22,,,
   22,22,22,,,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,,4,4,4,,,4,
   4,,,,20,20,20,20,20,20,20,20,20,20,20,20,4,,,6,6,6,8,
   6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,22,,,22,22,22,,,,,6,6,6,
   8,6,,,,,,4,6,,6,,6,8,6,,,,,,,,,,,,22,,,22,22,22,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,6,,
   6,,,,,,4,4,,4,,6,,6,,,8,8,,,,22,,,22,,,22,,,,,22,6,,6,,,,,
   ,4,4,,4,,6,,6,,,8,8,,,,22,,,22,,,22,,,,,22,,4,8,8,,,,4,
   6,,6,,4,,4,,,,,,,,,24,24,,,24,,,,,24,,,,,,,,4,,,,,,4,,,,,,,,,,
   80,80,,,,44,,,,,44,8,8,,,,4,6,,6,,4,,4,,,,,,,,,24,24,,,24,,
   ,,,24,,4,,,,4,,,,,8,,8,,,,,,,,72,,,72,,,,80,,80,,,,,,4,,,,,8,
   ,8,,,,,,,,72,,,72,,,,80,,80,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,4,4,4,,,4,4,
   ,,,20,20,20,20,20,20,20,20,20,20,20,20,,4,,6,,6,,,8,8,,
   ,,22,,,22,,,22,,,,,22,,,,,,,,,,,,,,,,,,,,,,,,,,6,,6,,,8,8,,,,
   22,,,22,,,22,,,,,22,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,,24,24,,,24,,
   ,,,24,,,,,,,,,,,80,80,,,,44,,,,,44,,,,,,,,,24,24,,,24,,,,,24,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,,,,,,,44,80,,,44,,80,,,,,,,,,
   44,80,,,44,,80,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,20,,,,,,,,
   ,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,20,,,,,,,,20,,,,,,20,,20,,,,,,,,,
   3,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,3,3,6,6,
   6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,30,30,30,,30,,30,
   30,,30,30,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,3,
   3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,30,30,30,
   ,30,,30,30,,30,30,5,5,,4,7,10,7,12,,5,5,5,5,5,10,5,
   5,10,9,3,5,5,4,5,5,,,3,4,5,,5,,,,,,4,4,6,4,,5,6,5,,,
   5,5,,8,,21,,27,21,,29,19,6,28,28,6,21,5,,5,5,12,8,,,
   5,5,5,5,5,10,5,5,10,9,3,4,4,5,5,5,,,3,5,5,,5,,,,,,
   5,5,,6,8,7,,7,5,5,,,,,,29,19,27,,21,21,,27,6,19,6,29,,
   7,8,,7,,,10,10,10,10,10,10,10,10,10,16,4,7,7,7,10,10,,
   ,4,7,10,,10,,,,,,5,5,6,4,6,5,6,5,8,8,,,,,,,,,31,31,,,
   5,5,,10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,5,,7,,,5,5,5,5,5,10,5,5,10,9,3,5,5,4,5,5,6,,3,4,
   5,,5,,6,,,,4,4,,4,,5,,5,,,5,5,,8,,21,28,6,21,29,,21,
   28,6,,28,21,,7,,,10,10,10,10,10,10,10,10,10,16,4,5,5,
   5,6,6,6,,4,5,6,,6,,6,,,,7,7,,4,,10,,10,,,,,,6,,,,5,,,
   31,29,,10,,5,,,,,,27,,,,,,,,,6,,,,,,,,6,,,,,,,,,,,,7,,,,7,,,,,,,
   ,,,,11,49,87,,254,,,,,,,,9,9,14,9,14,10,9,14,10,11,6,9,
   9,7,8,8,10,,6,7,8,,8,,10,,,,7,7,10,6,11,9,10,9,10,
   10,8,8,,,,,,8,,,,,8,24,,24,,,,,,18,,,,,,,6,,,,,,7,,6,,,,,,7,,
   ,,,,,,,,,,,,,,,,,87,47,,,186,,,,11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,5,5,4,5,5,4,6,7,7,3,5,5,5,6,6,
   9,,3,5,6,,6,,9,,,,5,5,6,4,14,8,6,8,,,,,,8,,77,31,7,
   77,24,31,37,10,10,26,10,31,5,5,5,5,4,5,5,5,3,5,5,5,
   6,6,,,3,5,6,,6,,,,,,5,5,6,4,,8,6,8,6,6,,,,,,31,77,21,
   37,37,31,77,10,7,24,7,77,5,5,5,6,8,7,8,4,5,5,5,10,
   10,,,4,5,10,,10,,,,,,5,5,,6,9,7,,7,8,8,,,,,,153,153,29,,
   235,115,,8,9,106,9,125,5,5,5,5,5,5,3,5,5,5,6,6,9,,
   3,5,6,,6,,9,,,,5,5,9,4,8,8,9,8,,,6,6,,14,,31,37,7,
   24,77,77,31,7,21,37,21,37,5,5,5,5,4,4,5,5,5,10,10,,,
   4,5,10,,10,,,,,,5,5,9,6,,7,9,7,11,11,11,11,,9,,115,,
   29,235,,153,153,9,29,235,29,,7,7,6,7,4,6,6,6,12,12,7,
   ,4,6,12,,12,,7,,,,6,6,7,4,10,6,7,6,10,10,8,8,,10,,,,
   17,207,207,,,8,9,,9,,5,5,7,3,5,5,5,6,6,6,,3,5,6,,6,,
   6,,,,5,5,,4,,8,,8,,,,,,14,,24,24,10,31,31,37,26,21,7,
   77,7,24,5,8,4,5,5,5,10,10,9,,4,5,10,,10,,9,,,,5,5,,6,
   ,7,,7,,,8,8,,12,,106,235,9,74,125,,115,29,29,,29,235,7,
   4,6,6,6,12,12,7,,4,6,12,,12,,7,,,,6,6,7,4,8,6,7,6,
   8,8,10,10,,,,,207,9,,,,,9,17,207,17,207,4,9,9,9,8,8,,,
   4,9,8,,8,,,,,,9,9,10,6,,8,10,8,,,,,,,,140,,41,65,,79,79,
   10,41,65,41,,3,3,3,4,4,3,,2,3,4,,4,,3,,,,3,3,3,2,3,
   3,3,3,3,3,3,3,,3,,20,19,3,20,20,20,19,3,3,19,3,20,
   3,5,5,5,,,3,5,5,,5,,,,,,3,3,4,4,5,4,4,4,5,5,,,,,,,21,
   29,29,21,21,,4,4,19,29,29,5,5,5,,,3,5,5,,5,,,,,,3,3,
   4,4,5,4,4,4,5,5,,,,,,,21,29,29,21,21,,4,4,19,29,29,5,
   5,,,3,3,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,21,,29,21,
   29,,21,4,4,28,28,21,4,6,,4,5,4,,4,,6,,,,5,5,6,4,6,5,
   6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,6,,4,5,4,,4,,6,,,,5,
   5,6,4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,3,,6,,6,,
   3,,,,4,4,4,4,5,4,4,4,,,,,,,,60,,46,30,30,60,,5,5,28,
   46,30,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,4,,4,,3,,,,3,3,3,
   2,3,3,3,3,3,3,3,3,,3,,20,19,3,20,20,20,19,3,3,19,3,
   20,5,,5,,,,,,4,4,4,4,5,3,4,3,,,5,5,,,,21,,29,21,29,,
   21,4,4,28,28,21,,4,,6,,,,5,5,6,4,6,5,6,5,5,5,5,5,,6,
   ,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,,,,5,5,6,
   4,6,5,6,5,5,5,5,5,,6,,,,5,,,,,6,6,,5,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,4,4,4,4,5,4,4,4,,,,,,,,60,,46,30,30,60,,5,
   5,28,46,30,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,5,,5,,,5,5,,5,,21,28,4,21,,
   29,19,29,28,,4,21,,4,,5,,5,,,5,5,,5,,21,28,4,21,,29,
   19,29,28,,4,21,4,,,3,,,,,,,5,,30,28,5,,60,30,28,46,46,,
   5,33,,4,4,4,6,6,6,6,,,,20,20,20,20,20,20,20,20,20,20,
   20,20,,,,,,,,,,,30,29,27,,,30,29,,,,27,,,3,5,5,,,,5,,29,
   19,5,,23,21,28,28,29,23,5,,,,,,,,5,,30,28,5,,60,30,28,
   46,46,,5,33,5,5,,,,5,,29,19,5,,23,21,28,28,29,23,5,,3,
   5,5,,,,41,137,9,37,98,71,23,,9,71,,21,5,5,,,,41,137,9,
   37,98,71,23,,9,71,,21,3,,,,98,23,,71,23,21,71,,9,41,9,
   98,,,,98,23,,71,23,21,71,,9,41,9,98,,,,,,,,,,,,,,,,,,,30,30,
   ,,31,23,29,,30,,,,,,,,,,,,,,115,21,,,,21,29,,79,,63,,,,,20,
   28,,191,,29,29,115,63,13,12,20,5,21,,,,79,118,,21,,21,,
   115,63,,21,,,29,21,,63,,28,20,,115,21,5,63,12,118,191,
   12,63,28,,29,6,6,9,,6,9,,12,,,6,6,6,6,6,9,6,6,9,12,
   3,3,3,6,6,6,,,3,6,6,,6,,,,,,3,3,,6,,6,,6,,,,,,,,,30,30,
   30,,30,,30,30,,30,30,5,5,,4,7,,7,,,5,5,5,5,5,10,5,5,
   10,9,4,3,4,4,4,4,,,5,5,5,5,5,6,,,8,,3,5,,5,,5,5,5,,
   6,,,,,,,28,,28,21,6,29,21,21,21,28,6,5,,5,5,,8,,12,5,
   5,5,5,5,10,5,5,10,9,5,3,5,5,5,6,5,5,4,5,5,,7,,,,,,
   3,4,,5,,5,,7,,,,,,,8,19,6,21,27,,27,21,,29,29,19,6,,7,
   8,,7,,,10,10,10,10,10,10,10,10,10,16,7,4,7,5,5,4,,,5,
   6,6,,10,6,,,6,,4,5,,6,,6,,10,,6,,,,,,,5,29,,29,5,,,,,,
   10,12,,,,,,,18,,,,,,,,,,6,,,,,,,,,,,,7,,,,,6,,,,,,,,,7,,,,,,,,,,,
   ,186,,,87,47,11,5,,7,,10,5,5,5,5,5,10,5,5,10,9,4,3,
   4,4,4,4,,,5,5,5,5,5,,,6,8,,3,5,,5,,5,5,5,,,,6,,,,28,
   6,28,6,19,27,,21,21,21,,28,,7,,,10,10,10,10,10,10,10,
   10,10,16,5,4,5,7,7,4,8,8,7,10,10,,5,,,6,,,4,7,,10,,
   10,,5,,,,6,,,6,,10,,5,,,31,31,,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,9,14,9,14,10,9,14,10,11,7,
   6,7,7,7,6,10,10,9,8,8,8,9,10,,10,,,6,9,,8,,8,8,9,,
   10,,10,,,11,,24,,8,,8,,,,,,24,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,27,,,,,,,,6,,,,,,,,,,,,,,7,,,6,,,,,,,,,,,7,,
   ,,,,,,254,11,87,49,,,,,5,5,4,5,5,4,6,7,7,5,3,5,5,5,4,
   ,,5,6,6,,8,6,,,14,,3,5,,6,,6,,8,,6,,,,,,77,7,37,21,26,
   10,31,31,24,24,24,7,5,5,5,5,4,5,5,5,5,3,5,5,5,4,,,
   5,6,6,6,8,9,,9,14,,3,5,,6,,6,6,8,,9,,9,,,8,37,21,77,
   7,31,7,77,24,37,31,37,21,5,5,5,6,8,7,8,5,4,5,5,5,6,
   ,,5,10,10,8,7,9,,,12,,4,5,,10,,10,8,7,,9,,,,,,,29,,29,
   115,9,125,74,235,106,235,29,5,5,5,5,5,5,5,3,5,5,5,4,
   6,6,5,6,6,,8,,,6,,,3,5,,6,,6,,8,,,,6,,,,24,7,31,10,77,
   21,37,37,77,31,77,7,5,5,5,5,4,5,4,5,5,5,6,11,11,5,
   10,10,11,7,,,9,9,,4,5,,10,,10,11,7,,,,9,,,,235,29,153,
   9,153,29,,235,,115,,29,7,7,6,7,6,4,6,6,6,4,8,8,6,12,
   12,10,6,7,,7,,,4,6,,12,,12,10,6,,7,,7,,,8,207,17,,9,,9,
   ,,207,,207,17,5,5,7,5,3,5,5,5,4,,,5,6,6,,8,9,,6,8,,
   3,5,,6,,6,,8,,9,,6,,,14,26,10,31,10,37,7,24,77,31,77,
   31,10,5,8,5,4,5,5,5,6,8,8,5,10,10,,7,,,,,,4,5,,10,,
   10,,7,,,,,,,9,106,9,115,8,,29,235,,125,153,153,9,7,6,4,
   6,6,6,4,10,10,6,12,12,8,6,7,,7,10,,4,6,,12,,12,8,6,,
   7,,7,,,10,,9,,8,,17,207,207,,,,9,9,4,9,9,9,6,,,9,8,8,,
   8,,,10,,,4,9,,8,,8,,8,,,,10,,,,65,41,79,10,79,41,,65,,
   140,,41,3,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,3,,5,,5,5,5,,
   4,,,,,,,4,28,28,19,4,,21,21,21,28,28,3,3,3,2,3,3,3,4,
   4,3,3,3,,3,3,,2,3,,4,,4,3,3,,3,,3,,,3,19,3,19,3,19,
   3,20,20,20,20,19,3,4,4,4,,,3,5,5,5,5,4,,,5,,3,3,,5,,
   5,5,5,,4,,,,,,,4,28,28,19,4,,21,21,21,28,28,3,4,,,5,5,
   5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,5,28,28,,4,21,29,29,
   21,21,21,,4,4,,,5,5,5,5,3,,,4,,,3,5,,5,,5,5,3,,,,4,,,
   5,28,28,,4,21,29,29,21,21,21,,4,6,6,4,4,4,6,4,4,,4,,
   ,2,4,,4,,4,6,4,,4,,4,,,,20,20,20,20,20,20,20,20,20,
   20,20,20,3,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,,,,,,71,,71,,
   23,9,98,37,21,41,137,9,5,5,5,5,5,,,,,,3,5,,5,,5,5,5,,,
   ,,,,,71,,71,,23,9,98,37,21,41,137,9,5,5,,4,,,4,,,3,3,,
   5,,5,,4,,,,4,,,5,19,29,21,4,,29,21,29,29,,21,4,4,5,5,
   6,,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,5,5,6,
   ,6,6,,4,5,,4,,4,5,5,,6,,6,,,6,,5,,6,,5,,,,,,6,,,,,,,3,,
   ,5,,5,3,,,,,,,,,41,9,21,,71,,23,71,98,98,23,9,4,,,5,,3,
   4,,5,,5,,3,,4,,,,,,23,5,21,28,28,5,23,,,29,19,29,,4,,,3,
   ,,6,,6,,4,,3,,4,,,5,28,46,54,5,,46,30,30,30,60,,5,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,5,,3,4,,6,,6,,,,4,,3,,,,,5,28,46,28,
   5,60,,33,30,28,46,,3,,,6,,6,,5,,,,5,,,,29,,,31,,,30,30,
   30,,,23,,,,,,,,,,,,,,,,,,,,,,,,,,,,3,,4,,4,3,3,,3,,3,,,3,19,
   3,19,3,19,3,20,20,20,20,19,3,,5,,5,,4,,,,4,,,5,19,29,
   21,4,,29,21,29,29,,21,4,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,5,,6,,
   6,,,6,,5,,6,,5,,,,,,6,,,,,,,,,,,,,,,,,,,,,,,5,5,,6,,6,,,6,,5,
   ,6,,5,,,,,,6,,,,,,,,,41,9,21,,71,,23,71,98,98,23,9,,4,,,,,
   ,23,5,21,28,28,5,23,,,29,19,29,,,,,,,,,,,,,,,,,,,,4,,,5,
   28,46,54,5,,46,30,30,30,60,,5,,,,,,,,,,,,,,,,,,,,,5,28,46,
   28,5,60,,33,30,28,46,,,,,,,,,,,,,,,,,,,,,,,,,,,,,27,29,,29,27,
   ,,,30,29,,28,,63,,20,,,,,,191,63,12,115,5,21,21,29,79,
   191,12,28,,115,21,,,,,20,28,13,115,79,118,21,20,5,63,,,
   21,,,20,29,29,21,115,63,12,,,,,63,,21,,118,,,63,,29,28,8,
   8,,6,7,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,6,6,,,5,
   6,6,9,6,10,,,,,5,4,10,6,,6,,6,9,,,,,,,29,,,,29,38,26,38,
   ,29,38,38,8,,8,8,,10,,,8,8,7,8,7,10,8,7,10,20,5,5,
   4,10,7,10,,,5,7,4,,7,,,,,,5,4,,10,,7,,10,,,,,,,,29,38,,,
   29,,29,,38,29,38,38,11,7,4,11,7,6,6,8,8,6,8,6,9,8,
   6,9,8,5,5,4,6,4,6,,5,8,6,6,,6,8,,,12,8,8,4,8,6,12,
   4,,6,,,5,,12,8,8,6,8,6,6,8,8,6,8,8,8,6,6,,6,6,,,,,,
   11,,10,,,9,,16,,,5,,5,,,6,,8,8,,8,,,,,,,5,,,,5,,,,,6,,,,,
   79,,,,,,79,,,,,,8,,7,,,8,8,7,8,7,10,8,7,10,20,5,5,4,6,
   6,6,,9,5,6,6,,6,,10,10,,,5,4,,6,,6,,6,,,9,,,,,29,38,
   38,38,26,,29,,38,29,,,6,7,11,11,8,8,6,8,6,9,8,6,9,8,
   8,8,4,6,6,6,,,5,4,6,5,4,,8,8,8,12,5,4,,6,8,6,,6,5,,
   ,,8,12,12,8,6,8,8,6,6,8,6,6,6,8,8,,,,,34,9,,13,,,9,,
   16,,,5,,9,,,,,8,8,,8,,,,,,,5,,,,9,,,,,,,,,,79,,,,,,79,,,,,,,,
   12,12,10,12,10,8,12,10,8,10,6,6,4,4,6,4,,7,6,6,4,7,
   6,10,10,10,,8,6,4,10,4,,6,,4,7,,7,,8,,,21,,,,6,,6,,,21,
   ,,6,,,9,,10,,,11,,16,,,5,,8,,,,,5,8,6,5,,,,,,,5,,,,8,,,6,,
   ,,,,,,,,,79,,,,,79,,,,,9,34,13,,,9,,16,,,5,,8,,,,,9,8,,9,,,,
   ,,,5,,,,8,,,,,,,,,,,,,,79,,,,,79,,,5,5,8,7,7,8,4,9,9,5,
   5,4,10,7,10,,,5,7,4,12,7,8,,,,,5,4,8,10,,7,,10,12,,,,,,
   ,23,16,48,48,28,27,21,27,16,28,16,16,5,5,5,8,8,7,7,
   7,5,5,4,10,7,10,,,5,7,4,12,7,9,,,,,5,4,9,10,,7,,10,
   12,,,,,,,21,48,48,48,21,16,23,16,48,28,48,48,7,4,7,4,
   5,7,5,5,5,3,5,6,5,,,5,6,6,9,6,6,,,11,10,5,3,6,5,
   11,6,,5,9,,,,10,11,11,7,8,8,8,7,9,7,9,8,7,8,8,5,7,
   5,5,8,7,5,5,4,10,7,10,,12,5,7,4,,7,,9,9,,,5,4,,10,,
   7,,10,,,12,,,,,28,48,16,16,23,48,21,48,48,21,48,48,7,7,
   4,7,6,5,5,3,5,6,5,,6,5,6,6,6,6,,,,10,8,5,3,,5,10,6,
   ,5,6,,6,,8,10,10,7,8,8,8,7,8,7,8,8,7,8,8,9,7,10,
   9,8,8,6,8,9,8,,10,8,9,6,10,9,11,10,10,,,8,6,11,8,,9,
   ,8,10,,10,,,,,12,,,,12,74,20,74,,10,,,5,7,9,5,5,4,10,
   7,10,,12,5,7,4,,7,,8,8,,,5,4,,10,,7,,10,,,12,,,,,28,16,
   27,27,21,48,28,48,16,23,16,16,7,5,5,5,3,5,6,5,,9,5,
   6,6,,6,,6,6,11,10,5,3,,5,11,6,,5,,,9,,10,11,11,7,8,
   9,9,7,8,7,8,8,7,8,8,9,8,8,6,8,9,8,,10,8,9,6,10,9,
   10,11,11,,,8,6,10,8,,9,,8,10,,10,,,,,10,,74,74,20,,12,,,
   12,,,10,10,4,9,6,9,,,10,6,4,,6,9,9,9,17,12,10,4,9,9,
   17,6,,9,,,,,12,17,17,8,10,12,12,8,12,8,12,10,8,10,10,
   3,3,5,5,5,,,3,4,4,4,4,5,,,7,,3,3,5,5,7,5,,5,4,,,,4,,
   ,,5,29,29,4,5,,5,5,4,29,29,3,5,5,5,,,3,4,4,4,4,5,,,
   7,,3,3,5,5,7,5,,5,4,,,,4,,,,5,29,29,4,5,,5,5,4,29,
   29,4,3,4,,3,3,3,2,3,3,3,3,3,6,4,3,2,3,4,6,3,,4,3,
   ,3,,4,6,6,3,4,4,4,3,4,3,4,4,3,4,4,5,4,,6,5,5,4,
   6,5,5,5,5,,6,5,4,5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,
   5,,,4,3,4,4,3,,5,5,8,8,4,3,,5,8,3,,5,4,,,,6,9,9,5,
   5,7,7,5,5,5,5,5,5,7,7,,6,5,5,4,6,5,5,5,5,,6,5,4,
   5,4,,5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,4,4,4,4,4,,,,9,,4,3,,6,9,,,6,4,,3,,6,,,49,6,
   ,,4,6,49,6,6,5,9,9,5,4,,5,,5,5,,4,3,3,,5,,4,,5,,,4,,
   ,7,7,4,29,5,5,,29,4,29,29,,5,5,4,,3,5,,,9,6,5,3,5,
   5,9,3,,5,,,4,,8,8,8,5,7,5,5,5,7,5,7,7,5,5,5,4,4,
   6,6,6,6,,4,2,6,4,6,4,,4,4,,4,,,6,6,20,4,4,4,20,4,
   20,4,4,20,4,4,,,,,,6,,3,,6,,4,,6,3,,4,,,9,9,5,9,6,6,
   49,,4,,9,49,6,6,5,,,9,6,5,3,5,5,9,3,,5,,,4,,8,8,8,
   5,7,5,5,5,7,5,7,7,5,5,5,5,5,35,8,,3,3,5,35,,,5,,,,,
   ,9,9,6,20,7,7,,20,6,20,20,,7,7,3,9,,5,3,5,5,9,5,,5,
   ,,,,8,35,35,,7,20,20,6,7,,7,7,6,20,20,9,,5,3,5,5,9,
   5,,5,,,,,8,35,35,,7,20,20,6,7,,7,7,6,20,20,8,,6,35,,
   6,8,,,,,9,,,,,7,,,,,,7,,,,,,4,4,8,6,8,8,,6,6,,,,,,,,6,,,
   26,6,,6,6,24,,,3,,5,,4,,5,,,4,,,7,7,4,29,5,5,,29,4,
   29,29,,5,5,3,4,6,3,,4,3,,3,,4,6,6,3,4,4,4,3,4,3,4,
   4,3,4,4,5,35,,,5,,,,,,9,9,6,20,7,7,,20,6,20,20,,7,7,,
   5,,4,6,,6,,6,,,5,,,,5,,5,,,5,,,8,,,,,9,,,,,7,,,,,,7,,,,,,,
   5,4,,,,6,9,9,5,5,7,7,5,5,5,5,5,5,7,7,,,,,,,,,,,,,,,,,,,,
   ,6,,6,,6,,,5,,,,5,,5,,,5,,,,4,,,9,9,5,9,6,6,49,,4,,9,
   49,6,6,,,,,,,,,,,,,,,,,,,6,,,49,6,,,4,6,49,6,6,5,9,9,,,,,,,
   ,,,,,,,,,8,8,24,,6,6,,,26,,,,6,6,6,,,,,7,,,,,7,,,,,,,7,,,,,
   7,,,5,44,44,13,5,6,5,5,13,35,35,,,44,8,5,8,4,35,,,4,
   5,,44,,,5,8,8,5,,44,,,5,8,8,44,12,44,44,6,5,5,5,4,8,
   44,,,5,5,13,44,44,8,44,,,35,,,5,5,4,3,,4,4,5,4,,,4,4,
   6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,4,7,
   6,,6,,7,,7,,,,,,28,28,,,,28,28,28,28,4,4,4,,4,4,5,4,,,
   4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,,,4,6,6,,9,,,,,,4,
   4,7,6,,6,,7,,7,,,,,,28,28,,,,28,28,28,28,4,4,4,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,,4,,,4,4,4,4,
   4,4,4,4,4,6,2,4,4,2,4,4,,,4,4,4,4,4,4,4,,,,2,4,,4,
   ,4,4,4,,,4,4,,,,20,20,20,20,20,20,20,20,20,20,20,20,,
   3,5,,6,6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,
   ,7,,,,4,6,,4,,9,,6,8,,,7,,,,,,28,28,28,4,4,4,,28,28,28,
   ,,,,8,,8,,,,11,,11,5,,5,5,,,,,6,5,6,8,6,8,,,,,,9,6,8,,
   8,6,8,,13,14,7,,,,71,71,29,29,29,15,15,27,113,,,,5,,6,
   6,7,6,7,6,6,7,6,9,4,6,4,4,6,4,,,6,4,7,7,6,,7,,,,4,
   6,,4,,9,,6,8,,,7,,,,,,28,28,28,4,4,4,,28,28,28,,8,,,8,
   11,14,,8,7,11,5,,,5,5,,,,8,9,8,,8,9,9,,,,,5,,6,,6,8,
   6,6,8,,,,,,29,29,71,71,113,,,,29,27,15,15,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,4,4,5,5,4,4,7,7,4,4,
   5,4,5,5,,,4,5,5,9,7,8,7,,15,,4,5,,5,,7,,7,11,11,8,,,
   13,,76,36,31,76,26,8,7,9,24,8,9,6,4,4,4,4,4,5,5,7,
   4,4,5,4,5,5,,,4,5,5,7,7,8,,,,,4,5,11,5,,7,8,7,,,,,,,,
   31,76,76,36,31,7,21,8,36,9,6,21,5,4,5,4,8,6,8,4,5,
   6,4,6,6,,,5,6,12,11,7,13,,,,,4,6,,6,,7,,12,,14,,,,,,,
   110,,110,124,10,19,7,43,7,7,9,4,5,4,4,4,7,4,4,5,4,
   5,5,,,4,5,5,,7,,,,,,4,5,,5,,7,8,7,11,,7,7,,,,26,31,36,
   24,76,21,6,7,76,6,21,7,5,5,4,5,8,4,5,6,4,6,6,,,5,
   6,12,,7,,,,,,4,6,14,6,,7,13,12,20,18,14,14,,,,124,,110,
   43,,19,9,10,110,7,9,19,7,6,8,7,4,10,8,4,8,8,,,10,8,
   7,18,7,,,,,,4,8,19,8,,7,12,7,13,,12,11,,14,,70,,,62,70,
   8,21,7,62,8,9,21,4,5,7,4,4,5,4,5,5,,,4,5,5,,7,7,7,
   ,13,,4,5,,5,,7,,7,,11,,9,,15,,24,28,24,28,36,6,9,21,
   31,21,7,8,5,8,4,5,6,4,6,6,,,5,6,12,,7,14,14,,,,4,6,
   18,6,,7,,12,,,14,16,,,,61,124,52,61,110,9,7,19,,9,19,
   10,7,4,10,8,4,8,8,,,10,8,7,,7,12,11,,14,,4,8,,8,,7,,
   7,18,,16,12,,,,119,70,62,181,,21,9,8,,9,21,8,6,9,11,6,
   11,8,,,9,11,10,,10,,,,16,,6,11,,8,,10,,10,,,,21,,16,,,,,,,
   10,9,7,,9,9,10,4,4,2,4,4,,,3,3,4,4,4,4,4,,5,,2,3,
   5,3,,4,4,4,5,5,4,4,,5,,20,19,19,20,19,4,19,4,19,4,
   4,19,4,4,4,4,,,4,5,5,5,5,6,,,8,,3,4,6,5,,5,5,5,6,6,
   ,,,,,,28,,28,20,6,28,5,20,5,28,6,4,4,4,,,4,5,5,6,5,5,
   ,,,,3,4,6,5,,5,6,5,6,6,,,,,,28,28,,,20,28,26,5,20,3,
   4,4,4,4,,,4,4,4,4,4,4,4,,,,2,4,5,4,,4,4,4,5,,4,4,,,
   ,19,20,20,19,19,19,4,4,19,4,19,4,4,,,5,4,5,6,5,,6,,,
   ,3,5,6,4,,5,6,5,6,8,8,6,,,,,,28,28,20,4,4,3,20,5,
   28,26,,,5,4,5,6,5,,5,,,,3,5,6,4,,5,6,5,6,8,6,8,,8,,
   28,,28,,20,28,6,5,20,5,6,28,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,5,,5,,,,,,4,4,6,4,,5,
   6,5,,,5,5,,8,,20,,27,20,,28,5,6,28,28,6,5,5,,5,,,,,,4,
   4,6,4,,5,5,5,,8,6,6,,,,20,27,,20,,28,5,28,28,4,4,3,,
   4,7,7,,6,,4,5,,5,,4,,4,8,7,8,7,,6,,,22,22,,,4,21,6,,
   21,4,6,,,,,,,4,6,5,5,,,4,,9,9,8,,,6,,44,59,57,,,,7,18,
   89,15,5,6,7,7,,8,,4,5,,5,,4,,4,8,7,7,8,,6,,,22,22,,,
   5,7,7,,5,4,5,4,,71,,4,8,8,6,,7,9,7,,6,9,8,,12,,53,,
   89,51,,19,6,7,,9,9,,,44,,4,6,8,8,,7,8,7,,5,,,,,,53,89,
   ,51,,18,,7,,6,15,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,5,,7,8,,6,
   10,6,,,10,10,,,,32,,,,,,7,7,32,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,4,
   ,4,,4,4,4,,5,4,4,,5,,19,19,19,19,20,4,4,19,20,19,4,
   4,8,4,,5,,5,8,,6,6,,,,20,,27,20,28,4,3,4,,28,28,5,8,,
   ,6,,,11,,9,,11,,,41,41,59,120,5,7,27,,,7,,,5,,5,,,6,6,,,
   ,20,27,,20,28,6,5,28,,6,28,5,,,,,,,,,,,,,,,,,,,,,,,,4,7,7,
   ,7,,8,,,22,22,,,4,5,5,,7,5,7,,8,,9,,,,,44,59,57,,89,6,
   7,19,,9,,10,7,7,7,,,6,,,22,22,,,4,6,21,,6,4,21,,8,8,,,
   ,41,59,,41,,11,8,,162,27,7,5,8,8,,,,37,,120,37,,27,5,7,
   ,11,,7,4,,,,,,,89,31,7,19,6,32,10,9,9,,,,89,,,,31,7,18,
   ,32,5,6,15,,,,,,,,,,,,,,,,,,,32,32,,,,,7,,7,,,,,,,,,,,,,,,20,,
   20,28,20,,70,70,113,20,,,28,20,20,,70,113,55,,,113,55,70,
   ,20,28,20,,70,113,70,,20,20,28,55,44,113,20,28,20,20,
   4,4,20,12,20,12,5,20,13,12,20,28,20,12,13,113,55,44,
   4,5,4,,4,4,5,4,,,4,4,6,4,6,9,4,6,9,12,4,4,6,4,4,6,
   ,,4,6,6,,9,,,,,,4,4,7,6,,6,,7,,7,,,,,,28,28,,,,28,28,
   28,28,4,4,4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
   ,,,,,3,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,,
   4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,28,28,28,,,,4,
   28,28,28,,4,,5,4,4,6,4,6,9,4,6,9,12,4,4,4,4,6,6,7,
   ,4,4,6,,6,,,7,,,4,6,,6,,9,,7,,,,,,,,4,4,28,28,28,,,,4,
   28,28,28,,,,,8,11,8,,,,,,11,8,,5,6,9,,8,6,5,5,8,,6,,,7,
   ,,,,9,6,,8,,8,,,,,,,,27,15,29,29,29,71,113,71,15,,,,,,4,
   4,6,4,6,4,4,6,4,6,4,4,4,4,4,4,6,6,4,4,6,,4,,,6,,,
   4,4,6,4,,4,,6,6,6,,,,,,20,20,20,20,20,20,20,20,20,20,
   20,20,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,,8,,
   ,,11,,11,,5,,6,5,6,,,,9,8,,8,,,9,,,8,5,7,,,6,,8,6,8,,,,
   ,,,,71,71,113,29,29,29,,27,15,15,4,4,4,5,5,4,4,7,7,
   4,4,5,4,5,5,,,4,5,5,,7,,,,,,4,5,7,5,15,7,,10,,9,,,,,,
   21,6,36,76,24,26,31,24,9,9,8,7,4,4,4,4,4,5,5,7,4,
   4,5,4,5,5,,8,4,5,5,,7,,,7,,,4,5,9,5,,7,,10,8,7,,,15,
   ,13,7,21,76,31,36,31,76,26,6,8,7,21,5,4,5,4,8,6,8,
   5,4,6,5,6,12,,,4,6,6,,7,,,,,,5,6,16,12,16,7,,7,,11,,,
   16,,,19,9,110,,43,124,,46,7,7,10,19,4,5,4,4,4,7,4,4,
   5,4,5,5,7,8,4,5,5,,7,,,9,,15,4,5,7,5,13,7,,10,8,,,,,,
   ,8,7,31,26,76,76,36,31,21,7,21,6,5,5,4,5,8,5,4,6,
   5,6,12,,13,4,6,6,,7,,,11,,,5,6,11,12,14,7,,7,13,,,,,,
   14,10,19,,124,110,,110,124,9,10,19,9,7,6,8,7,10,4,8,
   10,8,7,,,4,8,8,,7,,,18,,,10,8,11,7,,7,,8,12,18,,,,,16,
   8,21,,70,62,70,,119,9,7,8,21,4,5,7,4,4,5,4,5,5,9,,
   4,5,5,,7,,,7,,,4,5,,5,,7,,10,,,,,,,15,9,8,26,24,31,36,
   24,76,7,21,6,9,5,8,5,4,6,5,6,12,11,,4,6,6,,7,,,16,,
   16,5,6,,12,,7,,7,,,,,,,16,7,10,124,46,,110,43,,19,19,9,
   7,7,10,4,8,10,8,7,18,12,4,8,8,,7,,,11,,,10,8,18,7,
   16,7,,8,,,,,,,,7,8,70,119,,,62,70,21,8,21,9,9,6,11,9,
   11,10,,,6,11,8,,10,,,26,,15,9,11,26,10,16,10,,10,,,,,15,
   ,16,7,10,,,,,,,9,7,10,9,4,4,4,5,5,,,3,4,5,,5,,,,,,4,4,
   ,6,8,7,,7,5,5,,,7,,,28,5,27,,20,20,,27,6,5,6,28,4,4,
   4,4,4,4,2,4,4,,4,,,4,,,3,3,4,4,5,4,,4,4,4,,,5,,5,
   19,4,20,19,19,19,20,19,4,4,19,4,5,4,5,,,3,5,4,,5,,,,,
   ,4,4,6,7,,6,,7,6,6,,,4,,,28,5,,,20,20,27,27,28,3,4,
   4,4,5,,6,4,4,4,,5,,,5,,8,4,5,5,5,7,5,,4,6,,,,8,,7,
   6,28,,20,28,,28,20,5,6,28,5,5,6,,4,4,4,,5,,,6,,,4,5,
   6,5,4,5,,4,5,,,,,,7,4,4,28,20,28,,,20,3,28,26,5,7,7,
   4,5,5,,4,,,,,6,6,7,7,6,8,6,,7,,,,,8,,,4,21,22,,,,22,,
   6,6,4,21,4,4,,5,,7,,,,,44,5,6,,,10,,,8,9,,,,6,,,18,,,,
   51,53,89,49,7,5,15,6,4,5,,,7,,,,,71,5,6,,,10,,,8,8,9,,,
   ,,,19,6,89,,51,53,,49,7,10,7,10,4,4,,4,,,4,,5,4,4,4,
   4,5,4,,4,4,4,,,,,5,4,19,19,19,20,20,19,19,4,19,4,4,4,
   ,5,,,6,,,5,4,6,5,7,5,,4,,6,,,,,4,28,26,,20,,28,28,20,
   5,4,4,3,,5,,,6,,,5,4,6,5,7,5,,4,,5,,,,,7,28,6,28,20,,
   28,,20,5,28,6,5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8,7,6,7,
   6,14,6,,7,,,,,9,,9,5,7,22,,,,22,,7,5,4,5,,,,,,,,,,,,,,,,,,,
   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,6,7,7,46,7,,7,,,,,,,
   ,,7,57,,,44,59,118,19,6,5,15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,4,
   ,8,9,9,,8,,6,,,,,,,7,,,,32,,32,7,,,,4,,5,,5,,7,,,,,,,8,
   5,6,20,27,,27,20,,28,28,5,6,,5,,5,,7,,,,,,,,3,4,20,27,
   27,,20,,4,28,5,28,,,,,7,,,,,,,46,6,5,49,118,59,57,,,15,,
   7,19,,4,,7,7,7,,,6,,8,6,4,,,22,22,,,21,4,21,6,9,,,,,,,,,
   ,7,7,,,,32,32,,,,,,,7,7,7,,,8,,14,5,4,,,22,22,,,5,5,7,
   7,,,,,,,,,,,,,,,,,,,,,8,8,,,8,,,6,6,21,,21,21,21,,,6,6,,4,,
   ,71,,10,10,7,53,49,,89,51,,10,19,6,7,,,44,,10,5,15,53,
   49,89,,51,,6,18,,7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,9,,,32,32,,,,
   ,,,7,7,,,,,,,,,,,,,,,,32,,32,,,,,7,7,,4,113,55,70,20,28,
   20,5,13,14,12,55,44,113,28,20,20,4,14,12,11,,,,20,,44,
   20,28,20,,,,,115,20,20,28,20,,,55,28,20,20,,,20,113,55,
   44,,20,70,113,55,28,55,44,115,12,11,13,4,5,4,5,6,6,5,,
   ,,,10,,10,13,17,9,,8,,,8,,6,,,5,,8,,,12,5,,,,,9,6,,,,8,
   10,,,10,9,,,,,65,65,,,,65,65,65,65,5,5,5,4,,3,,,6,6,7,
   6,7,6,6,7,6,9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,
   ,6,7,6,,,7,,,,,28,28,4,4,4,28,28,28,28,,,,6,4,6,6,4,
   4,4,4,4,8,4,4,8,4,4,4,4,4,4,4,,6,4,4,4,,6,,,,6,6,
   4,4,,4,6,6,,4,6,,,,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,,,
   ,,,9,,10,,,9,,16,9,,8,,6,,,,,8,,,12,10,,,,,,6,5,,,8,,,,10,
   ,,,,,65,65,5,5,5,65,65,65,65,,,,,,6,6,7,6,7,6,6,7,6,
   9,4,6,6,4,4,4,,8,6,6,7,,9,7,,,,,4,4,,4,,6,7,6,,,7,,,,
   ,28,28,4,4,4,28,28,28,28,,,,3,,,6,9,9,,,6,,9,,,6,6,6,,
   ,,,6,6,,9,,,,,,,6,,,,6,9