#############################################################################
##
#W  3ctsgrp-permgroupgens.g          GAP4 Package `RCWA'          Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing permutation
##  representations of finite groups on respected partitions.
##
##  The list 'permgroupgens' below satisfies
##
##  permgroupgens[i] = GeneratorsOfGroup(ActionOnRespectedPartition(grps[i]))
##
##  for all i in [1..52394] such that grps[i] is finite.
##
#############################################################################

local  perms, permgroupgenspos, result, i;

perms :=
[(1,2),(2,3),(1,3),(3,4),(1,4),(2,4),(4,5),(1,5),(3,5),(2,5),
 (2,3)(5,6),(3,4)(7,8),(3,4)(6,7),(2,3)(6,7),( 2,3)( 6,7)(10,11),
 ( 3,4)( 7,8)(11,12),( 1,4)( 5,8)( 9,12),( 1,2)( 5,6)( 9,10),
 (2,4)(6,8),(4,5)(8,9),(1,2)(4,5),(1,6)(4,7),(5,6)(7,8),(2,5)(4,6),
 (3,5)(7,9),( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18)
  (19,20)(21,22)(23,24)(25,26)(27,28)(29,30),(4,5)(7,8),(4,5)(6,7),
 (2,6)(5,7),( 1,2)( 3,4)( 5,6)( 7,8)( 9,10),(2,4)(5,7),(2,3)(4,5),
 (1,2)(3,4)(5,6),(1,6),(5,6),(1,3)(4,6),(2,6),(4,6),(2,6)(4,7),
 (2,5)(6,9),( 5,6)( 7,8)( 9,10),(1,6)(3,7),(3,4)(5,6)(7,8),(3,6),
 ( 4,5)( 8,9)(12,13)(16,17)(20,21)(24,25),
 ( 5,6)( 9,10)(13,14)(17,18)(21,22)(25,26),( 2,8)( 4,10)( 6,12),
 ( 3,8)( 5,9)( 7,10),( 1,2)( 5,6)( 9,10)(13,14)(17,18)(21,22)(25,26)
  (29,30)(33,34)(37,38)(41,42)(45,46)(49,50)(53,54)(57,58),
 ( 4,5)(10,11)(16,17)(22,23)(28,29),( 3,4)( 7,8)(11,12)(15,16)(19,20)
  (23,24)(27,28)(31,32)(35,36)(39,40)(43,44)(47,48)(51,52)(55,56)(59,60),
 ( 1,4)( 5,8)( 9,12)(13,16)(17,20)(21,24)(25,28)(29,32)(33,36)(37,40)
  (41,44)(45,48)(49,52)(53,56)(57,60),( 1,6)( 7,12)(13,18)(19,24)(25,30),
 ( 3,4)( 9,10)(15,16)(21,22)(27,28),( 2,3)( 6,7)(10,11)(14,15)(18,19)
  (22,23)(26,27)(30,31)(34,35)(38,39)(42,43)(46,47)(50,51)(54,55)(58,59),
 ( 2,3)( 8,9)(14,15)(20,21)(26,27),( 1,2)( 7,8)(13,14)(19,20)(25,26),
 ( 5,6)(11,12)(17,18)(23,24)(29,30),(3,6)(5,7),(1,5)(3,7),
 ( 2,8)( 4,9)( 6,10),(3,4)(8,9),(1,6)(3,7)(5,8),(4,5)(6,7)(8,9),
 ( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)(11,12),(1,5)(2,6),
 ( 3,4)( 7,8)(11,12)(15,16)(19,20),(1,5)(2,7)(3,9),(1,5)(3,6),
 ( 2,3)( 6,7)(10,11)(14,15)(18,19),( 1,2)( 5,6)( 9,10)(13,14)(17,18),
 ( 1,4)( 5,8)( 9,12)(13,16)(17,20),( 2,3)( 5,6)( 8,9)(11,12),
 (2,3)(7,8),( 2,4)( 6,8)(10,12),( 1,2)( 4,5)( 7,8)(10,11),
 ( 1,3)( 5,7)( 9,11),( 3,5)( 9,11)(15,17)(21,23)(27,29),
 ( 4,6)(10,12)(16,18)(22,24)(28,30),( 2,6)( 8,12)(14,18)(20,24)(26,30),
 ( 1,3)( 7,9)(13,15)(19,21)(25,27),( 2,4)( 8,10)(14,16)(20,22)(26,28),
 ( 1,5)( 7,11)(13,17)(19,23)(25,29),( 3,9)( 5,10)( 7,11),
 ( 4,5)( 9,10)(14,15)(19,20)(24,25)(29,30),
 ( 2,5)( 7,10)(12,15)(17,20)(22,25)(27,30),
 ( 3,5)( 8,10)(13,15)(18,20)(23,25)(28,30),( 4,9)( 6,10)( 8,11),
 ( 2,3)( 7,8)(12,13)(17,18)(22,23)(27,28),
 ( 1,3)( 6,8)(11,13)(16,18)(21,23)(26,28),
 ( 1,4)( 6,9)(11,14)(16,19)(21,24)(26,29),
 ( 2,4)( 7,9)(12,14)(17,19)(22,24)(27,29),
 ( 1,2)( 6,7)(11,12)(16,17)(21,22)(26,27),
 ( 1,5)( 6,10)(11,15)(16,20)(21,25)(26,30),
 ( 3,4)( 8,9)(13,14)(18,19)(23,24)(28,29),(3,5)(6,8),
 ( 3,4)( 6,7)( 9,10),( 1,3)( 4,6)( 7,9)(10,12),( 2,5)( 7,10),
 ( 1,4)( 7,10),( 1,6)( 7,12),( 3,4)( 9,10),( 3,6)( 9,12),
 ( 1,3)( 4,6)( 7,9)(10,12)(13,15)(16,18)(19,21)(22,24)(25,27)(28,30),
 (2,3)(8,9),( 2,3)( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)
  (29,30),( 4,5)(10,11),( 1,2)( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)
  (22,23)(25,26)(28,29),( 5,6)(11,12),(1,2)(7,8),( 2,5)( 8,11),
 ( 7,8)( 9,10)(11,12),( 4,5)( 9,10),(2,4)(7,9),
 ( 6,7)(10,11)(14,15)(18,19)(22,23)(26,27),
 ( 2,12)( 4,15)( 6,18)( 8,21)(10,24),( 2,11)( 4,14)( 6,17)( 8,20)(10,23),
 ( 2,13)( 4,16)( 6,19)( 8,22)(10,25),( 1,13)( 3,16)( 5,19)( 7,22)( 9,25),
 ( 1,11)( 3,14)( 5,17)( 7,20)( 9,23),( 1,12)( 3,15)( 5,18)( 7,21)( 9,24),
 (1,2)(5,6),( 8,9)(10,11)(12,13),(1,6)(2,7)(4,8),(1,2)(6,7),
 (1,6)(3,7)(4,8),(2,5)(4,7),(1,3)(7,9),( 4,6)(10,12),(1,5)(2,7),
 ( 1,5)( 7,11),( 2,6)( 8,12),( 2,4)( 8,10),(2,7)(4,8)(6,9),
 ( 3,5)( 9,11),( 2,11)( 3,12)( 4,13)( 5,14)( 6,15)( 7,16),( 3,5)( 8,10),
 (1,3)(5,7),(2,3)(4,5)(6,7),( 4,10)( 6,11)( 9,12),( 2,10)( 5,11)( 8,12),
 ( 2,10)( 5,11)( 7,12),(2,5)(3,7),( 9,10)(11,12)(13,14),(2,5)(3,6),
 (1,4)(2,6)(3,8),( 3,10)( 6,11)( 9,12),(2,6)(4,8),(1,6)(3,8),
 ( 2,9)( 4,11)( 6,13),( 3,8)( 5,10)( 7,12),( 3,9)( 5,11)( 7,13),
 ( 1,3)( 4,6)( 7,9)(10,12)(13,15),( 2,3)( 5,6)( 8,9)(11,12)(14,15),
 ( 1,2)( 4,5)( 7,8)(10,11)(13,14),(1,2)(3,4),(1,5)(4,7),(5,6)(8,9),
 (1,4)(6,9),(1,4)(2,6),(1,2)(3,4)(5,6)(7,8),
 ( 4,7)( 8,11)(12,15)(16,19)(20,23)(24,27),( 4,5)( 7,8)(10,11),
 ( 8,9)(12,13)(16,17)(20,21)(24,25),(1,7)(3,8)(5,9),
 ( 6,7)(10,11)(14,15)(18,19)(22,23),( 6,9)(10,13)(14,17)(18,21)(22,25),
 ( 4,5)( 9,10)(12,13)(17,18)(22,23),( 7,8)(11,12)(15,16)(19,20)(23,24),
 ( 2,3)( 7,8)(14,15)(19,20)(24,25),( 1,2)( 6,7)(14,15)(19,20)(24,25),
 ( 1,2)( 6,7)(13,14)(18,19)(23,24),( 3,5)( 8,10)(11,13)(16,18)(21,23),
 ( 2,4)( 6,8)(10,12)(14,16)(18,20),( 6,7)( 8,9)(10,11)(12,13)(14,15)
  (16,17)(18,19)(20,21)(22,23)(24,25),( 3,9)( 5,10)( 8,11),
 ( 1,3)( 6,8)(13,15)(18,20)(23,25),( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)
  (11,12)(13,14)(15,16)(17,18)(19,20),( 3,4)( 8,9)(11,12)(16,17)(21,22),
 (2,5)(3,6)(4,7),( 4,5)( 9,10)(11,12)(16,17)(21,22),
 ( 1,3)( 5,7)( 9,11)(13,15)(17,19),(2,6)(4,7)(5,8),(2,6)(3,7)(5,8),
 (4,6)(7,9),(1,6)(4,8),( 2,5)( 7,10)(12,15)(17,20),(1,3)(6,8),
 ( 2,4)( 7,9)(12,14)(17,19),(3,5)(4,6),( 1,4)( 6,9)(11,14)(16,19),
 ( 1,5)( 6,10)(11,15)(16,20),( 3,5)( 8,10)(13,15)(18,20),
 ( 1,3)( 6,8)(11,13)(16,18),( 3,4)( 8,9)(13,14)(18,19),
 ( 1,2)( 6,7)(11,12)(16,17),( 4,5)( 9,10)(14,15)(19,20),(2,4)(3,6),
 ( 2,3)( 7,8)(12,13)(17,18),(12,13)(15,16)(18,19)(21,22)(24,25),
 (11,12)(14,15)(17,18)(20,21)(23,24),( 6,7)( 9,10)(12,13)(15,16)(18,19),
 ( 6,8)( 9,11)(12,14)(15,17)(18,20),(11,13)(14,16)(17,19)(20,22)(23,25),
 ( 7,8)(10,11)(13,14)(16,17)(19,20),( 1,6)( 2,9)( 3,12)( 4,15)( 5,18),
 ( 1,7)( 2,10)( 3,13)( 4,16)( 5,19),( 1,8)( 2,11)( 3,14)( 4,17)( 5,20),
 ( 3,11)( 6,12)(10,13),( 1,11)( 5,12)( 8,13),( 1,5)( 6,10),
 ( 2,7)( 4,9)( 6,11),( 1,2)( 4,5)( 6,7)( 9,10),(2,4)(5,6)(8,9),
 ( 4,5)( 7,9)(10,12)(17,19)(20,22),( 2,3)( 6,8)(13,15)(16,18)(23,25),
 ( 4,5)( 6,8)( 9,11)(16,18)(19,21),( 2,9)( 4,10)( 7,11),
 ( 1,2)( 9,11)(12,14)(19,21)(22,24),( 3,4)( 6,8)(13,15)(16,18)(23,25),
 ( 1,2)(10,12)(13,15)(20,22)(23,25),( 2,4)( 6,7)( 9,11),
 ( 3,6)( 9,12)(15,18)(21,24)(27,30),( 1,4)( 7,10)(13,16)(19,22)(25,28),
 ( 2,5)( 8,11)(14,17)(20,23)(26,29),( 3,5)( 6,8)( 9,11),(2,3)(5,6)(7,9),
 ( 7,9)(11,13)(15,17)(19,21)(23,25),(2,3)(5,6)(8,9),
 ( 2,4)( 7,9)(12,14)(17,19)(22,24)(27,29)(32,34)(37,39)(42,44)(47,49)
  (52,54)(57,59),( 3,4)( 8,9)(13,14)(18,19)(23,24)(28,29)(33,34)(38,39)
  (43,44)(48,49)(53,54)(58,59),( 1,4)( 6,9)(11,14)(16,19)(21,24)(26,29)
  (31,34)(36,39)(41,44)(46,49)(51,54)(56,59),
 ( 3,5)( 8,10)(13,15)(18,20)(23,25)(28,30)(33,35)(38,40)(43,45)(48,50)
  (53,55)(58,60),( 2,10)( 4,11)( 5,12)( 7,13),(2,3)(4,5)(7,8),
 ( 4,5)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(39,40)(44,45)(49,50)
  (54,55)(59,60),( 1,8)( 2,12)( 3,16)( 4,20)( 5,24),
 ( 2,3)( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)(42,43)(47,48)
  (52,53)(57,58),( 1,7)( 2,11)( 3,15)( 4,19)( 5,23),
 ( 1,2)( 6,7)(11,12)(16,17)(21,22)(26,27)(31,32)(36,37)(41,42)(46,47)
  (51,52)(56,57),( 1,5)( 6,10)(11,15)(16,20)(21,25)(26,30)(31,35)(36,40)
  (41,45)(46,50)(51,55)(56,60),(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)
  (28,29)(31,32)(34,35)(37,38),( 1,9)( 2,13)( 3,17)( 4,21)( 5,25),
 ( 2,5)( 7,10)(12,15)(17,20)(22,25)(27,30)(32,35)(37,40)(42,45)(47,50)
  (52,55)(57,60),( 1,6)( 2,10)( 3,14)( 4,18)( 5,22),
 ( 9,10)(12,13)(15,16)(18,19)(21,22)(24,25)(27,28)(30,31)(33,34)(36,37),
 (1,4)(5,8),( 9,11)(12,14)(15,17)(18,20)(21,23)(24,26)(27,29)(30,32)(33,35)
  (36,38),( 1,3)( 6,8)(11,13)(16,18)(21,23)(26,28)(31,33)(36,38)(41,43)
  (46,48)(51,53)(56,58),( 6,8)(10,12)(14,16)(18,20)(22,24),
 ( 1,8)( 3,10)( 5,12),( 3,9)( 6,10)( 8,11),(3,4)(5,7)(8,9),(1,5)(4,6),
 ( 1,7)( 3,9)( 5,11),(1,6)(2,7)(3,8),( 4,6)( 9,11)(13,14)(16,18)(21,23)
  (25,26),( 5,6)( 8,10)(13,15)(17,18)(20,22)(25,27),(2,3)(5,6)(7,8),
 ( 1,6)( 2,8)( 3,10),( 2,9)( 5,10)( 7,11),(3,7)(5,8)(6,9),(1,4)(3,6),
 ( 3,6)( 9,12)(15,18)(21,24)(27,30)(33,36)(39,42)(45,48)(51,54)(57,60),
 ( 2,9)( 5,10)( 8,11),( 1,6)( 7,12)(13,18)(19,24)(25,30)(31,36)(37,42)
  (43,48)(49,54)(55,60),( 2,3)( 8,9)(14,15)(20,21)(26,27)(32,33)(38,39)
  (44,45)(50,51)(56,57),( 3,4)( 9,10)(15,16)(21,22)(27,28)(33,34)(39,40)
  (45,46)(51,52)(57,58),( 2,3)( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)
  (23,24)(26,27)(29,30)(32,33)(35,36)(38,39)(41,42)(44,45)(47,48)(50,51)
  (53,54)(56,57)(59,60),( 5,6)(11,12)(17,18)(23,24)(29,30)(35,36)(41,42)
  (47,48)(53,54)(59,60),( 4,5)(10,11)(16,17)(22,23)(28,29)(34,35)(40,41)
  (46,47)(52,53)(58,59),( 2,5)( 8,11)(14,17)(20,23)(26,29)(32,35)(38,41)
  (44,47)(50,53)(56,59),( 1,4)( 7,10)(13,16)(19,22)(25,28)(31,34)(37,40)
  (43,46)(49,52)(55,58),( 1,3)( 4,6)( 7,9)(10,12)(13,15)(16,18)(19,21)
  (22,24)(25,27)(28,30)(31,33)(34,36)(37,39)(40,42)(43,45)(46,48)(49,51)
  (52,54)(55,57)(58,60),( 1,2)( 7,8)(13,14)(19,20)(25,26)(31,32)(37,38)
  (43,44)(49,50)(55,56),( 1,2)( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)
  (22,23)(25,26)(28,29)(31,32)(34,35)(37,38)(40,41)(43,44)(46,47)(49,50)
  (52,53)(55,56)(58,59),(3,4)(5,6),( 3,6)( 7,10),(1,4)(3,5),
 ( 2,7)( 4,8)( 5,9)( 6,10),( 1,7)( 3,8)( 5,9)( 6,10),
 ( 1,9)( 4,10)( 6,11),( 1,9)( 4,10)( 7,11),( 2,10)( 4,11)( 7,12),
 ( 3,10)( 5,11)( 8,12),( 3,11)( 6,12)( 8,13)( 9,14)(10,15),
 ( 4,11)( 7,12)( 8,13)( 9,14)(10,15),( 1,12)( 3,13)( 5,14)( 7,15),
 ( 2,12)( 4,13)( 6,14)( 8,15),( 4,10)( 7,11)( 9,12),
 (18,19)(20,21)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33)(34,35)(36,37)
  (38,39)(40,41)(42,43)(44,45)(46,47),( 3,10)( 6,11)( 8,12),
 ( 3,4)( 6,7)( 8,10),( 2,11)( 5,12)( 8,13)( 9,14)(10,15),
 ( 2,3)( 4,5)( 7,8)( 9,10),( 3,6)( 8,11),( 3,5)( 6,7)( 9,10),
 ( 2,3)( 7,8)(12,13),( 2,3)( 9,10)(14,15)(19,20),
 ( 1,2)( 8,9)(13,14)(18,19),( 2,11)( 4,13)( 6,15)( 8,17)(10,19),
 ( 4,5)( 7,8)(12,13)(17,18),( 1,12)( 3,14)( 5,16)( 7,18)( 9,20),
 ( 3,4)( 6,7)(11,12)(16,17),(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,2)( 9,10)(14,15)(19,20),( 2,12)( 4,14)( 6,16)( 8,18)(10,20),
 ( 4,5)( 6,7)(11,12)(16,17),( 1,11)( 3,13)( 5,15)( 7,17)( 9,19),
 ( 1,3)( 8,10)(13,15)(18,20),( 3,5)( 6,8)(11,13)(16,18),
 ( 1,17)( 2,19)( 3,21)( 4,23)( 5,25)( 6,27)( 7,29)( 8,31)( 9,33)(10,35)
  (11,37)(12,39)(13,41)(14,43)(15,45),( 9,11)(12,14)(15,17)(18,20)(21,23)
  (24,26)(27,29)(38,40)(41,43)(44,46)(47,49)(50,52)(53,55)(56,58)(59,61)
  (62,64)(65,67)(68,70)(71,73),( 3,9)( 4,10)( 5,11)( 6,12)( 7,13)( 8,14),
 ( 1,3)( 6,8)(11,13),(10,12)(13,15)(16,18)(19,21)(22,24)(25,27)(28,30)
  (38,40)(41,43)(44,46)(47,49)(50,52)(53,55)(56,58)(59,61)(62,64)(65,67)
  (68,70)(71,73),(1,5)(2,7)(4,9),( 9,10)(12,13)(15,16)(18,19)(21,22)
  (24,25)(27,28)(38,39)(41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(59,60)
  (62,63)(65,66)(68,69)(71,72),(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)
  (28,29)(38,39)(41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(59,60)(62,63)
  (65,66)(68,69)(71,72),( 1,6)( 3,8)( 4,10),
 (11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(39,40)(42,43)(45,46)
  (48,49)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67)(69,70)(72,73),
 (2,3)(4,6)(7,8),(1,5)(3,7)(4,9),( 1,16)( 2,18)( 3,20)( 4,22)( 5,24)( 6,26)
  ( 7,28)( 8,30)( 9,32)(10,34)(11,36)(12,38)(13,40)(14,42)(15,44),
 ( 1,6)( 2,8)( 4,10),(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)
  (39,40)(42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67)
  (69,70)(72,73),( 5,6)( 9,10),(1,2)(4,5)(7,8),(1,2)(3,5),
 ( 4,6)( 8,10)(12,14)(16,18)(20,22)(24,26),( 2,5)( 7,10)(12,15),
 ( 2,7)( 3,8)( 5,9)( 6,10),( 3,5)( 7,9)(11,13)(15,17)(19,21)(23,25),
 ( 1,4)( 6,9)(11,14),(3,4)(6,8),( 2,4)( 7,9)(12,14),
 (1,2)(3,4)(6,7)(8,9),( 1,7)( 4,8)( 5,9)( 6,10),( 1,5)( 6,10)(11,15),
 ( 2,3)( 5,7)( 8,10),( 3,4)( 7,8)(11,12)(15,16)(19,20)(23,24),
 ( 4,5)( 9,10)(14,15),( 3,4)( 8,9)(13,14),(1,3)(4,5),
 ( 3,5)( 8,10)(13,15),( 2,4)( 5,7)( 8,10),( 1,2)( 6,7)(11,12),
 ( 9,10)(11,12)(13,14)(15,16),(3,5)(7,8),
 ( 1,6)( 2,8)( 3,10)( 4,12)( 5,14),( 6,7)( 8,9)(10,11)(12,13)(14,15),
 ( 4,6)( 8,10),( 2,4)( 5,7)( 9,10),( 1,7)( 2,9)( 3,11)( 4,13)( 5,15),
 (2,4)(3,7),( 1,11)( 4,12)( 8,13),( 2,11)( 5,12)( 8,13),
 ( 3,11)( 7,12)(10,13),(2,4)(7,8),( 3,4)( 9,10)(11,12),
 ( 3,11)( 6,12)( 9,13),( 2,3)( 5,6)( 8,9)(10,11)(12,13),( 1,6)( 2,11),
 (1,5)(2,9),(1,3)(2,8),( 3,4)( 6,7)( 8,9)(10,11)(12,13),
 ( 5,6)(10,11),( 3,4)( 6,8)( 9,11),(3,7)(4,8)(6,9),(2,5)(6,8),
 (3,5)(8,9),( 6,7)( 8,9)(10,11)(12,13),
 (10,11)(12,13)(14,15)(16,17)(18,19),( 6,7)( 8,9)(10,11)(12,13)(14,15)
  (16,17)(18,19)(20,21)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33)(34,35),
 ( 7,8)( 9,10)(13,14)(15,16),( 3,13)( 6,14)( 7,15)( 9,16)(11,17),
 ( 1,12)( 2,13)( 4,14)( 5,15)( 6,16)( 8,17),(1,7)(3,8)(4,9),
 ( 1,12)( 2,13)( 3,14)( 4,15)( 5,16)( 6,17),
 ( 6,21)( 7,22)( 8,23)( 9,24)(10,25)(11,26)(12,27)(13,28)(14,29)(15,30)
  (16,31)(17,32)(18,33)(19,34)(20,35),(16,17)(18,19)(20,21)(22,23)(24,25)
  (26,27)(28,29)(30,31)(32,33)(34,35)(36,37)(38,39),
 ( 1,13)( 4,14)( 8,15)(10,16)(12,17),( 1,12)( 3,13)( 4,14)( 5,15)( 7,16)
  ( 8,17),( 3,6)( 7,10)(11,14)(15,18)(19,22)(23,26),
 ( 2,10)( 3,11)( 5,12)( 6,13),( 4,7)( 6,8)( 9,13)(11,14),
 ( 3,10)( 4,11)( 6,12)( 7,13),( 2,13)( 5,14)( 7,15)( 9,16)(11,17),
 (2,4)(5,8),( 2,12)( 3,13)( 4,14)( 5,15)( 6,16)(10,17)(11,18),
 (1,7)(2,8)(4,9),(11,12)(13,14)(15,16)(17,18)(19,20)(21,22)(23,24)(25,26)
  (27,28)(29,30)(31,32)(33,34)(35,36)(37,38)(39,40),
 ( 3,7)( 5,8)(10,13)(12,14),( 2,13)( 5,14)( 8,15)(10,16)(12,17),
 ( 4,5)( 7,9)(12,14)(16,17)(19,21)(24,26),
 ( 6,8)(10,11)(13,15)(18,20)(22,23)(25,27),
 ( 4,6)( 8,9)(11,13)(16,18)(20,21)(23,25),
 ( 5,7)(10,12)(14,15)(17,19)(22,24)(26,27),( 2,6)( 7,11),(1,4)(2,7),
 (3,4)(7,9),(1,4)(2,5),(1,2)(5,6)(8,9),( 2,9)( 5,11)( 8,13),
 ( 2,11)( 6,12)( 9,13),( 3,10)( 5,12)( 8,14),( 2,10)( 5,12)( 8,14),
 ( 1,9)( 4,11)( 7,13),( 3,5)( 6,8)(10,11),( 1,10)( 4,12)( 7,14),
 (1,5)(2,8),(1,3)(2,6),( 4,11)( 7,12)(10,13),( 2,11)( 5,12)( 9,13),
 ( 1,10)( 4,12)( 6,14),( 3,8)( 5,9)( 6,10),( 1,9)( 4,11)( 6,13),
 ( 1,11)( 4,12)( 7,13),( 3,9)( 5,11)( 8,13),
 ( 5,7)( 9,10)(12,14)(17,19)(21,22)(24,26),
 ( 1,2)( 4,5)( 8,9)(11,12)(14,15),(2,6)(3,9),
 ( 1,10)( 4,12)( 5,14)( 8,16),(3,5)(4,7),( 1,3)( 8,10)(13,14)(18,19),
 (2,5)(6,8)(7,9),( 4,6)( 7,9)(11,12)(16,17),
 (16,17)(18,19)(20,21)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33)(34,35)
  (36,37)(38,39)(40,41)(42,43)(44,45),( 1,9)( 4,11)( 5,13)( 8,15),
 ( 2,4)( 5,7)(14,15)(19,20),( 1,3)( 4,6)(14,15)(19,20),(1,4)(2,6)(3,7),
 ( 2,3)( 5,6)( 7,8)(10,11)(13,14),( 1,4)( 5,12)( 8,13),(2,5)(3,8),
 ( 1,6)( 2,12)( 5,13),(3,4)(6,7)(8,9),( 5,7)( 8,10)(11,12)(16,17),
 ( 4,5)( 8,10),( 1,3)( 8,10)(12,13)(17,18),
 (14,15)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27)(36,37)(38,39)(40,41)
  (42,43)(44,45)(46,47)(48,49)(50,51)(52,53)(54,55)(56,57)(58,59),
 ( 2,3)( 5,6)( 7,8)(10,11),( 1,2)( 4,5)(11,12)(14,15),( 4,6)( 9,11),
 ( 4,5)( 7,8)( 9,10)(12,13),(2,4)(6,7),(4,7)(5,8)(6,9),
 ( 3,10)( 5,11)( 7,12)( 9,13),( 3,5)( 6,9)( 7,10)( 8,11),
 ( 2,12)( 6,13)( 9,14)(10,15)(11,16),( 1,9)( 3,10)( 6,11),
 ( 5,7)(10,12)(15,17)(19,22)(24,27),( 5,8)(10,13)(15,17)(20,22)(25,27),
 (2,3)(6,8),( 3,8)( 4,9)( 6,10),( 4,5)( 6,9)( 7,10)( 8,11),
 ( 2,10)( 4,11)( 6,12)( 8,13),( 2,5)( 6,9)( 7,10)( 8,11),(2,7)(5,8)(6,9),
 ( 1,3)( 4,11)( 6,12),( 4,8)( 5,9)( 7,10),
 ( 4,12)( 8,13)( 9,14)(10,15)(11,16),( 4,7)( 9,11)(14,16)(19,21)(23,26),
 ( 4,5)( 6,7)( 8,9)(10,11),( 1,12)( 5,13)( 9,14)(10,15)(11,16),
 ( 4,6)( 9,11)(14,16)(18,21)(23,26),(1,2)(3,4)(6,7),
 ( 5,8)(11,13)(15,17)(20,23)(25,27),( 3,12)( 7,13)( 9,14)(10,15)(11,16),
 (2,6)(3,7)(4,8),(2,6)(3,8),( 4,7)( 9,12)(14,16)(19,21)(24,26),
 ( 1,10)( 3,11)( 4,12)( 6,13)( 7,14)( 9,15),(2,4)(5,6)(7,8),
 ( 4,6)( 8,11)(14,16)(18,20)(23,26),( 1,5)( 6,9)( 7,10)( 8,11),
 ( 5,8)(10,12)(15,17)(20,22)(24,27),(3,5)(6,9),
 ( 4,5)( 9,10)(14,15)(19,20)(24,25),(3,6)(7,9),( 5,6)( 9,10)(11,12),
 (3,4)(5,7),( 2,11)( 4,12)( 6,13)( 8,14),( 2,8)( 6,9)(11,14)(13,15),
 ( 4,5)( 8,9)(13,14)(17,18)(21,22)(26,27),( 2,8)( 4,9)(11,14)(13,15),
 ( 1,13)( 4,14)( 7,15)( 9,16)(11,17),( 2,10)( 4,12)( 6,13)( 9,15),
 ( 6,7)(11,12)(16,17)(21,22)(26,27),( 3,8)( 7,9)(10,14)(12,15),
 ( 3,13)( 6,14)( 8,15)(10,16)(12,17),( 5,6)(10,11)(14,15)(18,19)(23,24)
  (27,28),(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)(35,36)(38,39)(41,42)
  (44,45),( 2,8)( 5,9)( 6,10),(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)
  (34,35)(37,38)(40,41)(43,44),( 3,4)( 8,9)(12,13)(16,17)(21,22)(25,26),
 ( 3,8)( 4,9)( 7,10),( 5,6)( 9,10)(14,15)(18,19)(22,23)(27,28),
 ( 1,11)( 3,12)( 5,13)( 7,14),( 4,5)( 9,10)(13,14)(17,18)(22,23)(26,27),
 ( 3,4)( 7,8)(12,13)(16,17)(20,21)(25,26),( 1,10)( 4,12)( 6,13)( 8,15),
 (14,15)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27)(39,40)(41,42)(43,44)
  (45,46)(47,48)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62),
 (16,18)(19,21)(22,24)(25,27)(28,30)(31,33)(34,36)(37,39)(40,42)(43,45),
 ( 5,8)( 7,9)(10,14)(12,15),(1,6)(2,8),( 2,3)( 5,6)(11,12)(14,15),
 (3,4)(5,6)(8,9),( 2,3)( 5,6)( 7,8)( 9,10)(11,12),
 ( 3,7)( 4,8)( 5,9)( 6,10),(1,4)(2,8),( 1,4)( 5,7)(11,12)(14,15),
 ( 2,7)( 5,9)(10,14)(11,17),( 2,4)( 5,6)( 7,8)( 9,10),(1,5)(2,6)(3,8),
 ( 1,7)( 2,8)( 5,9)( 6,10),( 4,5)( 8,9)(11,12)(15,16)(18,19)(22,23),
 (2,4)(6,9),(1,5)(6,8)(7,9),(2,4)(3,5),( 4,5)( 6,8)( 9,10),
 ( 3,6)( 7,9)(10,11)(13,14),( 3,8)( 5,9)(11,14)(13,15),
 ( 3,5)( 6,9)(10,11)(13,14),( 1,3)( 4,7)(11,12)(14,15),
 ( 2,6)( 5,8)(10,12)(11,15),(1,3)(2,7),( 1,3)( 5,9)( 6,11),
 (3,6)(4,8),( 1,4)( 5,10)( 6,12),( 1,8)( 2,9)( 5,10)( 7,11),
 ( 3,10)( 5,11)( 6,12)( 8,15)(13,18)(16,19),( 4,8)( 7,9)(10,12)(11,13),
 ( 4,5)( 7,8)(10,11)(13,14),( 2,8)( 3,9)( 4,10)( 6,11),
 ( 2,10)( 4,11)( 7,14)( 9,17)(13,18)(16,19),( 1,3)( 5,6)( 7,8)( 9,10),
 (2,7)(4,8)(5,9),( 4,8)( 6,9)(10,14)(12,15),( 1,3)( 6,9)(11,12)(14,15),
 ( 3,8)( 6,9)(10,12)(11,13),( 1,4)( 7,9)(10,11)(13,14),
 ( 2,3)( 4,5)(14,15)(17,18)(20,21),( 4,10)( 7,11)( 8,12)( 9,14)(13,16)
  (15,17),(2,7)(3,8)(4,9),( 2,10)( 5,11)( 8,13)( 9,15)(12,16)(14,17),
 ( 3,4)( 6,7)(11,12),(3,5)(6,7),( 4,5)( 9,10)(14,15)(19,20)(23,24),
 ( 7,8)(11,12)(16,17)(21,22)(26,27),(1,4)(5,9),
 ( 1,2)( 7,8)(10,11)(13,14),( 1,2)( 8,9)(13,14),(2,5)(7,9),
 ( 4,5)( 9,10)(14,15)(18,19)(23,24),( 3,4)( 6,7)(11,12)(14,15),
 (1,5)(6,9),( 2,8)( 3,9)( 6,10),( 2,3)( 9,10)(14,15),(1,4)(2,5)(3,7),
 ( 1,8)( 2,12)( 5,13),( 4,5)(10,11)(14,15)(19,20)(24,25),
 ( 2,3)( 7,8)(10,11)(13,14),( 3,4)( 6,7)(10,11)(13,14),(2,7)(3,8)(5,9),
 ( 1,7)( 2,11),( 1,5)( 2,10)( 4,12),( 1,2)( 5,12)( 8,13),
 ( 4,6)( 9,10),( 4,8)( 6,9)( 7,10),( 4,5)( 8,9)(14,15)(18,19)(23,24),
 (2,7)(3,8)(6,9),( 7,8)(12,13)(16,17)(22,23)(26,27),
 ( 1,2)( 6,7)(10,11)(13,14),(4,5)(7,9),
 ( 1,2)( 3,4)(15,16)(18,19)(21,22),( 1,6)( 2,10),( 1,5)( 2,10),
 (1,4)(2,9),(1,2)(4,5)(6,7),( 6,7)(11,12)(16,17)(20,21)(26,27),
 ( 7,8)(12,13)(16,17)(21,22)(26,27),( 4,7)( 9,12)(14,17)(18,22)(23,27),
 ( 5,7)(10,11)(14,16)(18,20)(22,24)(27,28)(31,33)(35,37)(39,41)(44,45)
  (48,50)(52,54),( 3,4)( 5,6)( 9,10)(11,12),
 ( 4,5)( 8,9)(12,13)(16,17),( 4,6)( 9,11)(13,16)(18,21)(23,25),
 ( 1,3)( 5,6)( 8,10),( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)(11,12)(13,14)
  (15,16),( 2,8)( 4,9)( 5,10)( 6,11)( 7,12),
 ( 4,7)( 9,11)(13,15)(17,20)(21,24)(26,28)(30,32)(34,37)(38,41)(43,45)
  (47,49)(51,54),( 2,10)( 3,11)( 5,12)( 6,13)( 7,14)( 9,15),
 ( 9,39)(11,41)(13,43)(15,44)(17,45)(19,46)(21,48)(23,50)(25,51)(27,52)
  (29,53)(31,55)(33,57)(35,58)(37,59),( 4,7)( 9,11)(13,16)(19,21)(23,25),
 ( 1,2)( 9,10)(14,15),( 2,10)( 3,11)( 4,12)( 5,13)( 6,14)( 7,15),
 ( 2,6)( 3,10)( 4,12),( 2,9)( 4,11)( 6,14)( 7,17)(12,19)(15,21),
 ( 5,6)( 9,10)(12,13)(16,17)(19,20)(23,24),
 ( 3,4)( 8,9)(11,12)(16,17)(19,20)(24,25),
 ( 5,7)( 9,12)(15,17)(19,21)(24,27),( 1,2)( 3,5)( 6,7)( 8,10),
 ( 2,10)( 5,12)( 6,13)( 9,15),( 4,5)( 9,10)(11,12)(13,14),
 ( 4,5)( 7,8)(12,13),( 3,9)( 5,10)( 7,12)( 8,14)(11,15)(13,16),
 ( 3,6)( 7,11)(12,15)(16,19)(20,24)(25,28),
 ( 3,4)( 7,8)(11,12)(16,17)(20,21)(24,25),
 ( 1,3)( 5,7)( 9,10)(11,12)(13,14),( 2,6)( 3,8)( 4,10),
 ( 1,4)( 5,11)( 7,13),( 3,6)( 7,10)(11,15)(16,19)(20,23)(24,28),
 ( 2,6)( 5,8)(10,13)(11,15),( 2,8)( 6,9)(10,14)(12,15),( 5,6)( 9,11),
 ( 1,2)( 4,5)( 7,8)(10,11)(13,14)(17,18)(20,21)(23,24)(26,27)(29,30)
  (32,33)(35,36)(38,39)(41,42)(44,45),( 1,2)( 4,5)( 7,8)( 9,10)(11,12),
 ( 6,14)( 8,16)( 9,17)(10,19)(12,20)(13,22),
 (10,39)(12,40)(14,41)(16,43)(18,45)(20,46)(22,47)(24,48)(26,50)(28,52)
  (30,53)(32,54)(34,55)(36,57)(38,59),( 8,9)(10,11)(12,13)(15,16)(18,19)
  (20,21),( 4,7)(10,12)(14,16)(19,22)(24,26),
 ( 5,6)( 9,10)(13,14)(18,19)(22,23)(26,27),( 1,8)( 3,9)( 5,10)( 7,11),
 ( 4,5)( 7,8)(10,11)(13,14)(16,17),( 9,39)(11,40)(13,42)(15,44)(17,45)
  (19,46)(21,47)(23,49)(25,51)(27,52)(29,53)(31,54)(33,56)(35,58)(37,59),
 (10,39)(12,41)(14,43)(16,44)(18,45)(20,46)(22,48)(24,50)(26,51)(28,52)
  (30,53)(32,55)(34,57)(36,58)(38,59),( 5,7)(10,11)(15,16)(20,21)(24,26),
 ( 4,6)( 9,10)(12,14)(17,18)(20,22)(25,26),
 ( 5,6)( 8,9)(11,12)(14,15)(17,18),( 3,5)( 6,8)(11,13),
 ( 4,6)( 8,10)(13,14)(17,19)(21,23)(25,27)(30,31)(34,36)(38,40)(42,44)
  (47,48)(51,53),( 5,7)(11,12)(15,16)(20,22)(25,26),
 ( 1,3)( 8,10)(13,15),( 4,8)( 9,13)(14,17)(19,22)(24,27),
 ( 3,9)( 5,11)( 6,13)( 7,16)(14,19)(17,21),
 ( 2,12)( 3,13)( 4,14)( 6,15)( 7,16)( 8,17),
 ( 5,7)(10,12)(14,17)(19,22)(24,26),( 4,7)( 8,12)(14,17)(18,21)(23,27),
 ( 2,7)( 3,9)( 5,11),( 2,8)( 4,10)( 6,13)( 7,16)(12,18)(15,20),
 (1,2)(5,6)(7,8),( 5,6)( 9,10)(14,15)(18,19)(22,23)(26,27)(31,32)(35,36)
  (39,40)(43,44)(48,49)(52,53),( 2,10)( 4,11)( 5,12)( 6,13)( 8,14)( 9,15),
 ( 4,6)( 8,11)(13,16)(18,20)(23,25),( 1,4)( 3,10)( 5,11)( 7,12)( 9,13),
 ( 2,4)( 6,8)( 9,10)(11,12)(13,14),( 4,6)( 7,9)(10,12)(13,15)(16,18),
 ( 6,7)( 8,9)(13,14)(16,17),( 2,8)( 3,9)( 4,10)( 5,11)( 6,12)( 7,13),
 ( 5,7)( 9,12)(14,17)(19,21)(24,26),( 1,7)( 2,10)( 4,11)( 6,12)( 8,13),
 ( 3,8)( 7,9)(11,14)(13,15),( 4,8)(10,13)(14,17)(19,23)(24,27),
 ( 1,2)( 7,8)(10,11)(12,13),( 5,6)( 8,9)(12,13)(15,16)(19,20)(22,23),
 ( 1,3)( 4,5)( 6,8)( 9,10),( 1,12)( 2,14)( 3,15)( 4,17)( 5,18)( 6,20),
 ( 2,9)( 4,10)( 6,11),( 4,5)( 9,10)(12,13)(17,18)(20,21)(25,26),
 ( 6,8)(10,13)(15,18)(20,22)(25,27),( 4,5)( 7,8)( 9,10)(12,13)(14,15)
  (16,17)(19,20)(21,22)(24,25)(26,27),( 5,7)(10,12)(15,16)(20,21)(25,26),
 ( 4,5)( 8,9)(12,13)(17,18)(21,22)(25,26),
 ( 4,5)( 8,9)(12,13)(17,18)(21,22)(25,26)(29,30)(34,35)(38,39)(42,43)
  (46,47)(51,52),( 4,5)( 6,7)( 8,9)(11,12)(14,15)(16,17)(18,19)(20,21)
  (23,24)(26,27),( 4,8)( 9,12)(14,17)(19,22)(23,27),
 ( 2,3)( 8,9)(11,12)(13,14),( 1,8)( 4,9)( 5,10)( 6,11)( 7,12),
 ( 1,8)( 3,9)( 4,10)( 6,11),( 2,3)(10,11)(12,13),
 (10,39)(12,40)(14,42)(16,44)(18,45)(20,46)(22,47)(24,49)(26,51)(28,52)
  (30,53)(32,54)(34,56)(36,58)(38,59),( 4,5)( 7,8)(10,11)(12,13)(14,15)
  (16,17)(19,20)(22,23)(24,25)(26,27),( 4,5)( 7,8)( 9,10)(11,12)(14,15)
  (16,17)(19,20)(21,22)(23,24)(26,27),( 6,7)(11,12)(15,16)(19,20)(23,24)
  (28,29)(32,33)(36,37)(40,41)(45,46)(49,50)(53,54),(2,5)(3,7)(4,9),
 ( 2,5)( 3,9)( 4,11),( 5,6)(10,11)(15,16)(19,21)(24,26),
 ( 3,4)( 7,9)(11,12)(15,17)(19,20)(23,25),
 ( 5,6)( 9,11)(15,16)(19,20)(24,26),( 3,6)( 8,10)(11,14)(16,18)(19,22)
  (24,26),( 1,10)( 4,12)( 6,13)( 9,15),( 3,9)( 5,10)( 6,11)( 8,12),
 ( 7,9)(10,12)(13,15),( 3,8)( 4,9)( 5,10)( 6,11)( 7,12),
 ( 6,8)(11,13)(15,18)(20,23)(25,27),(2,3)(5,7),
 ( 2,3)( 8,9)(11,12)(14,15),( 2,3)( 5,6)( 8,9)(11,12)(14,15)(16,17)
  (19,20)(22,23)(25,26)(28,29)(31,32)(34,35)(37,38)(40,41)(43,44),
 ( 1,12)( 2,13)( 3,14)( 5,15)( 6,16)( 7,17),
 ( 6,7)(10,11)(14,15)(19,20)(23,24)(27,28),( 6,7)( 8,9)(12,13)(15,16),
 ( 4,5)( 6,7)(11,12),(1,7)(2,8)(3,9),( 5,6)( 8,9)(10,11)(13,14),
 ( 4,9)( 6,10)( 7,11)( 8,13)(12,15)(14,16),
 ( 3,7)( 8,11)(12,15)(16,20)(21,24)(25,28),
 ( 3,8)( 5,10)( 6,12)( 7,15)(14,18)(17,20),
 ( 6,8)(10,12)(15,18)(20,22)(24,27),( 1,10)( 4,12)( 5,13)( 8,15),
 ( 8,9)(10,11)(13,14)(16,17)(18,19)(20,21),
 ( 3,5)( 7,10)(11,13)(15,18)(19,21)(23,26),
 ( 6,14)( 7,16)( 9,17)(10,19)(11,20)(13,22),
 ( 4,5)( 6,7)( 9,10)(11,12)(14,15)(16,17)(18,19)(21,22)(23,24)(26,27),
 ( 1,3)( 4,10)( 6,12),( 9,39)(11,40)(13,41)(15,43)(17,45)(19,46)(21,47)
  (23,48)(25,50)(27,52)(29,53)(31,54)(33,55)(35,57)(37,59),
 ( 1,2)(14,15)(16,17)(18,19)(20,21)(22,23)(24,25),( 2,7)( 4,9)( 5,11),
 (1,4)(6,8),( 1,5)( 4,12)( 8,13),( 1,3)( 4,10)( 6,11),
 ( 1,3)( 4,12)( 7,13),( 1,5)( 2,12)( 6,13),( 1,7)( 3,12)( 6,13),
 ( 2,3)(14,15)(16,17)(18,19)(20,21)(22,23)(24,25),(1,3)(5,8),
 ( 5,6)( 9,10)(13,14)(17,18),( 1,4)( 6,11)( 8,12)(10,13),
 ( 2,7)( 4,10)( 6,13),( 2,8)( 5,9)( 7,10),( 2,9)( 3,10)( 6,11),
 ( 3,8)( 6,9)( 7,10),( 3,5)( 7,9)(11,13)(15,17),
 ( 1,10)( 3,12)( 5,14)( 7,16),( 3,4)( 5,6)( 8,9)(10,11),
 ( 4,14)( 6,17)( 8,18)( 9,21)(11,22)(13,25),( 2,9)( 4,11)( 6,13)( 8,15),
 (1,6)(5,8)(7,9),( 5,6)(10,11)(15,16)(20,21)(25,26),(1,3)(4,6)(7,9),
 ( 1,9)( 3,12)( 5,15),( 6,7)(11,12)(15,16)(20,21)(25,26),
 ( 1,2)( 4,5)(11,12)(14,15)(16,17),( 2,6)( 5,7)( 9,13)(11,15),
 ( 4,5)( 6,7)( 9,10)(11,12),( 1,10)( 4,12)( 7,14)( 8,16)( 9,18),
 ( 5,6)( 8,9)(10,11)(12,13)(15,16),( 1,11)( 4,13)( 7,15)( 8,17)( 9,19),
 (4,6)(5,8)(7,9),( 2,4)( 6,11)( 8,12)(10,13),( 5,7)(10,11)(12,13),
 ( 2,9)( 4,12)( 6,15),(3,5)(6,8)(7,9),( 1,4)( 5,10)( 7,11),
 ( 2,4)( 5,11)( 7,12)( 9,13),( 4,6)( 8,10)(12,14)(16,18),(1,3)(5,6)(7,8),
 ( 1,7)( 3,10)( 5,13),( 1,5)( 2,11)( 4,13),( 3,4)( 7,8)(11,12)(15,16),
 ( 3,11)( 6,13)( 7,15)( 8,17)( 9,19),( 1,4)( 5,12)( 7,14),
 ( 3,5)(10,11)(12,13),( 3,10)( 5,11)( 7,13)( 9,17)(14,18)(16,19),
 ( 3,10)( 6,12)( 7,14)( 8,16)( 9,18),( 2,10)( 4,11)( 6,12)( 8,16)(13,18)
  (15,19),( 1,5)( 2,9)( 4,11),( 2,8)( 4,9)( 7,10),(3,6)(7,8),
 ( 4,6)(10,11)(12,13),( 1,3)( 6,8)(11,13)(18,20)(23,25)(28,30)(33,35)
  (38,40)(43,45),( 1,4)( 3,12)( 7,13),( 2,10)( 4,12)( 7,14),
 ( 1,9)( 3,11)( 6,13),( 1,3)( 5,10)( 7,12),
 ( 5,6)( 9,10)(12,13)(15,16)(19,20)(22,23)(26,27)(29,30)(32,33)(36,37)
  (39,40)(43,44)(46,47)(49,50)(53,54),( 2,9)( 5,11)( 7,13),
 ( 4,5)( 7,8)(11,12)(15,16)(18,19)(21,22)(24,25)(28,29)(32,33)(35,36)
  (38,39)(41,42)(45,46)(49,50)(52,53),( 4,5)( 7,8)(11,12)(14,15)(18,19)
  (21,22)(24,25)(28,29)(31,32)(35,36)(38,39)(41,42)(45,46)(48,49)(52,53),
 ( 2,6)( 5,7)( 8,14)(10,16),( 1,5)( 2,8)( 3,10)( 7,11),
 ( 4,19)( 5,20)( 6,22)( 7,23)( 8,25)( 9,26)(10,27)(11,29)(12,30)(13,32)
  (14,33)(15,34)(16,36)(17,37)(18,39),( 5,6)(10,11)(14,15)(19,20)(24,25),
 ( 1,4)( 2,7)( 5,10)( 9,11),( 4,5)( 9,10)(14,15)(16,17)(21,22)(26,27)
  (31,32)(36,37)(41,42),( 6,19)( 7,20)( 9,22)(10,23)(11,24)(12,26)(14,27)
  (15,29)(17,30)(18,31),( 1,2)( 4,11)( 6,12),
 ( 2,7)( 5,9)(10,14)(11,16),( 5,6)( 9,10)(12,13)(16,17)(19,20)(22,23)
  (26,27)(29,30)(33,34)(36,37)(39,40)(43,44)(46,47)(50,51)(53,54),
 ( 1,3)( 2,5)( 6,10)( 9,11),( 2,9)( 4,11)( 7,13),
 ( 1,5)( 2,9)( 4,10)( 7,11),( 6,19)( 8,20)( 9,22)(11,23)(12,25)(13,26)
  (14,27)(16,29)(17,30)(18,32),( 9,40)(11,41)(13,42)(15,43)(17,45)(19,47)
  (21,48)(23,49)(25,50)(27,52)(29,54)(31,55)(33,56)(35,57)(37,59),
 ( 2,8)( 5,9)(10,14)(12,15),( 9,39)(11,41)(13,42)(15,43)(17,44)(19,46)
  (21,48)(23,49)(25,50)(27,51)(29,53)(31,55)(33,56)(35,57)(37,58),
 ( 1,9)( 3,11)( 5,13)( 7,15),( 6,19)( 7,21)( 8,22)(10,24)(11,25)(12,26)
  (13,28)(15,29)(16,31)(18,32),( 2,10)( 5,12)( 7,14),
 ( 8,9)(11,13)(15,16)(17,19)(21,23),( 6,20)( 7,21)( 9,22)(10,24)(12,25)
  (13,27)(14,28)(15,29)(17,31)(18,32),( 3,4)( 5,6)( 9,10)(13,14),
 (10,40)(12,41)(14,42)(16,43)(18,45)(20,47)(22,48)(24,49)(26,50)(28,52)
  (30,54)(32,55)(34,56)(36,57)(38,59),( 3,11)( 6,13)( 7,14)( 8,15)( 9,16),
 ( 1,10)( 2,11)( 4,12)( 5,13)( 7,14)( 8,15),( 1,3)( 4,6)(11,12)(15,16),
 ( 4,5)( 9,10)(14,15)(17,18)(22,23)(27,28)(32,33)(37,38)(42,43),
 ( 4,5)( 8,9)(12,13)(15,16)(18,19)(21,22)(25,26)(29,30)(32,33)(35,36)
  (38,39)(42,43)(46,47)(49,50)(52,53),( 1,3)( 2,8)( 4,10)( 7,11),
 ( 1,7)( 2,9)( 3,10)( 6,11),( 1,6)( 2,9)( 4,10)( 7,11),
 ( 3,5)( 8,10)(13,15)(16,18)(21,23)(26,28)(31,33)(36,38)(41,43),
 ( 4,19)( 5,21)( 6,22)( 7,24)( 8,25)( 9,26)(10,28)(11,29)(12,31)(13,32)
  (14,33)(15,35)(16,36)(17,38)(18,39),( 1,2)( 6,7)(11,12)(19,20)(24,25)
  (29,30)(34,35)(39,40)(44,45),( 2,6)( 3,7)( 8,14)(10,17),
 ( 1,8)( 2,9)( 4,10)( 6,11),( 4,5)( 8,9)(11,12)(14,15)(18,19)(21,22)
  (25,26)(28,29)(31,32)(35,36)(38,39)(42,43)(45,46)(48,49)(52,53),
 ( 2,3)( 7,8)(12,13)(19,20)(24,25)(29,30)(34,35)(39,40)(44,45),
 ( 2,8)( 3,9)( 5,10)( 7,11),( 5,6)( 8,9)(11,12)(15,16)(19,20)(22,23)
  (25,26)(28,29)(32,33)(36,37)(39,40)(42,43)(45,46)(49,50)(53,54),
 ( 3,4)( 8,9)(14,15)(19,20)(24,25),( 3,4)( 5,6)(11,12)(15,16),
 (11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)(35,36)(38,39)
  (41,42)(44,45)(47,48)(50,51)(53,54),( 1,2)( 7,8)( 9,10)(13,14),
 ( 5,6)( 8,9)(12,13)(15,16)(19,20)(22,23)(25,26)(29,30)(32,33)(36,37)
  (39,40)(42,43)(46,47)(49,50)(53,54),( 1,2)( 6,7)(11,12)(18,19)(23,24)
  (28,29)(33,34)(38,39)(43,44),(3,4)(5,8),
 (10,39)(12,41)(14,42)(16,43)(18,44)(20,46)(22,48)(24,49)(26,50)(28,51)
  (30,53)(32,55)(34,56)(36,57)(38,58),( 2,10)( 3,11)( 5,12)( 6,13)( 8,14)
  ( 9,15),( 5,8)(10,12)(15,16)(19,21)(23,26),( 3,9)( 6,11)( 8,13),
 ( 4,6)( 5,7)( 9,12)(11,15),( 2,6)( 3,10)( 5,11),
 ( 3,4)( 8,9)(13,14)(16,17)(21,22)(26,27)(31,32)(36,37)(41,42),
 ( 1,10)( 3,12)( 6,14),( 4,5)( 8,9)(11,12)(15,16)(18,19)(21,22)(25,26)
  (28,29)(32,33)(35,36)(38,39)(42,43)(45,46)(49,50)(52,53),
 ( 2,10)( 4,11)( 7,15)( 9,17)(13,18)(16,19),
 ( 4,5)( 9,10)(13,14)(18,19)(22,23)(27,28),
 ( 2,3)( 7,8)(11,12)(16,17)(20,21)(25,26),( 1,2)( 7,8)(11,12)(15,16),
 ( 1,6)( 3,12)( 7,13),(1,3)(2,5),( 6,7)( 9,10)(12,13)(15,16)(18,19)
  (21,22)(24,25)(27,28)(30,31)(33,34)(36,37)(39,40)(42,43)(45,46)(48,49),
 ( 1,3)( 2,7)( 5,10)( 8,11),( 8,10)(12,14)(15,16)(18,20)(22,23),
 ( 5,6)( 8,9)(12,13)(16,17)(19,20)(22,23)(25,26)(29,30)(33,34)(36,37)
  (39,40)(42,43)(46,47)(50,51)(53,54),( 3,5)( 6,8)( 9,10)(13,14),
 ( 3,4)( 5,11)( 7,12)( 9,13),( 1,3)( 2,6)( 5,10)( 8,11),
 ( 2,10)( 4,12)( 6,14)( 8,16),( 3,10)( 5,11)( 6,12)( 8,14)(13,18)(16,19),
 ( 4,8)( 7,9)(11,14)(13,15),( 1,4)( 2,9)( 5,10)( 8,11),
 ( 3,10)( 6,12)( 8,14),(12,13)(15,16)(18,19)(21,22)(24,25)(27,28)(30,31)
  (33,34)(36,37)(39,40)(42,43)(45,46)(48,49)(51,52)(54,55),
 ( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35)
  (37,38)(40,41)(43,44)(46,47)(49,50),( 1,10)( 3,12)( 5,13)( 7,15),
 ( 2,24)( 4,26)( 6,27)( 8,28)(11,30)(13,31)(16,33)(18,34)(20,35)(22,37),
 ( 6,12)( 7,15)( 8,16)( 9,19)(10,20)(11,23),
 ( 4,5)( 8,10)(13,15)(17,18)(21,23)(26,28),
 ( 6,7)( 9,10)(12,13)(15,16)(18,19)(21,22)(24,25)(27,28)(30,31)(33,34),
 ( 4,6)( 8,10)(15,18)(19,22)(24,25)(28,29)(31,32)(35,36),
 ( 2,3)( 6,7)( 9,10)(11,12)(13,14)(15,16),( 5,7)(11,12)(13,14),
 ( 1,7)( 2,9)( 4,11)( 5,13),( 8,9)(10,11)(12,13)(16,17)(18,19)(20,21),
 ( 2,6)( 3,8)( 4,10)( 5,12),( 1,12)( 2,15)( 3,18)( 4,21)( 5,24)( 6,27)
  ( 7,30)( 8,33)( 9,36)(10,39),( 2,8)( 4,11)( 6,14),
 ( 2,11)( 4,12)( 7,14)( 9,15),( 1,6)( 3,8)( 4,10)( 5,12),
 ( 2,10)( 5,11)(12,18)(13,19)(14,20)(15,21)(16,22)(17,23),
 ( 1,3)( 5,10)( 8,11),( 1,7)( 2,11)( 5,12),( 3,4)( 6,8)( 9,10)(11,12),
 ( 2,11)( 5,13)( 7,15)( 8,17)( 9,19),( 5,8)( 9,12)(17,19)(21,23)(24,25)
  (27,28)(31,32)(34,35),( 2,4)(10,11)(12,13),
 ( 3,7)( 5,8)( 9,13)(11,14),( 2,11)( 3,13)( 4,14)( 5,16)( 6,17)( 9,18)
  (10,19),( 9,10)(12,13)(20,21)(23,24)(26,27)(29,30)(32,33)(35,36)(38,39)
  (41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(59,60)(62,63)(65,66)(68,69)
  (71,72)(74,75)(77,78)(80,81)(83,84)(86,87)(89,90),
 ( 3,4)( 6,7)( 9,10)(12,13),( 9,11)(12,14)(20,22)(23,25)(26,28)(29,31)
  (32,34)(35,37)(38,40)(41,43)(44,46)(47,49)(50,52)(53,55)(56,58)(59,61)
  (62,64)(65,67)(68,70)(71,73)(74,76)(77,79)(80,82)(83,85)(86,88)(89,91),
 ( 2,3)( 9,10)(11,12)(13,14)(15,16),( 3,8)( 5,9)(10,12)(11,13),
 ( 4,7)( 5,9)(10,13)(11,16),(2,6)(4,9),(4,6)(8,9),
 ( 4,5)( 9,10)(14,15)(18,19)(23,24)(28,29),
 ( 4,6)( 8,10)(13,15)(17,19)(21,23)(26,28),
 ( 2,10)( 5,12)( 7,14)( 8,16)( 9,18),(12,13)(14,15)(26,27)(28,29)(30,31)
  (32,33)(34,35)(36,37)(38,39)(40,41)(42,43)(44,45)(46,47)(48,49)(50,51)
  (52,53)(54,55)(56,57)(58,59)(60,61)(62,63)(64,65)(66,67)(68,69)(70,71)
  (72,73),( 2,10)( 5,12)( 7,13)( 9,15),( 7,8)(10,11)(13,14),
 ( 5,7)( 9,11)(16,19)(20,23)(24,25)(28,29)(31,32)(35,36),( 1,7)( 3,10),
 ( 1,24)( 3,25)( 6,27)( 8,28)(10,29)(12,31)(15,32)(17,34)(20,35)(22,36),
 (1,6)(3,9),( 7,9)(10,12)(13,15)(16,18)(19,21),
 ( 1,10)( 4,11)(12,18)(13,19)(14,20)(15,21)(16,22)(17,23),
 ( 2,4)( 9,12)(13,16)(21,23)(25,26)(28,29)(32,33)(35,36),(1,5)(3,8),
 (10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(35,36)(38,39)(41,42)
  (44,45)(47,48)(50,51)(53,54)(57,58)(61,62)(65,66)(69,70)(73,74),
 ( 4,8)( 6,9)(10,12)(11,13),( 1,4)( 5,10)( 8,11),( 1,4)( 2,10)( 5,12),
 ( 3,5)( 8,10)(12,14)(16,18)(21,23)(25,27),( 1,4)( 5,9)( 7,10),
 ( 4,7)( 6,8)(10,13)(12,14),( 1,10)( 4,12)(11,17)(13,18)(14,19)(15,20)
  (16,21),( 1,13)( 2,16)( 3,19)( 4,22)( 5,25)( 6,28)( 7,31)( 8,34)( 9,37)
  (10,40),( 2,5)( 6,9)(14,16)(18,20)(25,26)(29,30)(32,33)(36,37),
 ( 3,5)( 8,10)(13,14)(16,18)(21,23)(26,27),( 2,3)( 4,5)( 7,8)(10,11),
 ( 1,24)( 4,25)( 6,27)( 9,28)(11,30)(13,31)(15,32)(18,34)(20,35)(22,37),
 (10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(35,36)(38,39)(41,42)
  (44,45)(47,48)(50,51)(54,55)(58,59)(62,63)(66,67)(70,71)(74,75),
 (2,5)(4,8),( 2,8)( 4,10)( 7,11),( 3,11)( 6,13)(10,17)(12,18)(14,19)
  (15,20)(16,21),( 1,7)( 2,12)( 4,14),( 1,2)( 5,10)( 7,12),
 ( 2,4)(11,12)(13,14),( 1,11)( 3,12)( 6,14)( 8,15),
 ( 3,5)( 7,10)(12,15)(16,18)(20,23)(25,28),(2,3)(4,6)(8,9),
 ( 1,3)( 4,10)( 7,12),( 1,11)( 2,14)( 3,17)( 4,20)( 5,23)( 6,26)( 7,29)
  ( 8,32)( 9,35)(10,38),( 2,24)( 4,26)( 6,27)( 9,29)(11,30)(13,31)(15,33)
  (18,34)(20,36)(23,37),( 1,7)( 2,11)( 4,13),
 ( 4,5)( 8,9)(13,14)(17,18)(22,23),( 5,8)( 7,9)(10,12)(11,13),
 ( 6,8)( 9,11)(12,14)(15,17)(18,20)(21,23)(24,26)(27,29)(30,32)(33,35),
 ( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
  (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36)(37,38)(39,40)
  (41,42)(43,44)(45,46)(47,48),(10,11)(13,14)(21,22)(24,25)(27,28)(30,31)
  (33,34)(36,37)(39,40)(42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(60,61)
  (63,64)(66,67)(69,70)(72,73)(75,76)(78,79)(81,82)(84,85)(87,88)(90,91),
 ( 4,5)( 6,7)( 8,9)(10,11)(12,13)(14,15)(16,17),
 (12,13)(14,15)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27)(28,29),
 ( 2,7)( 4,9)( 6,10),( 1,3)( 6,10)( 9,11),( 2,7)( 4,10),
 ( 2,10)( 4,11)( 7,13)( 9,14),( 3,10)( 6,11)(12,18)(13,19)(14,20)(15,21)
  (16,22)(17,23),( 1,4)( 9,11)(13,15)(20,23)(24,25)(28,29)(31,32)(35,36),
 ( 1,3)( 5,7)(12,15)(16,19)(26,27)(29,30)(33,34)(36,37),
 ( 2,11)( 3,12)( 4,14)( 5,15)( 6,17)( 9,18)(10,19),
 ( 3,6)( 7,10)(11,14)(15,18),( 1,7)( 3,9)( 4,11)( 5,13),
 ( 1,2)( 5,11)( 7,13),( 3,6)( 8,11)(13,15)(16,19)(21,24)(26,28),
 ( 2,3)( 7,8)(12,13)(16,17)(21,22)(26,27),( 1,3)( 6,8)(10,11)(14,15),
 (2,3)(5,7)(8,9),(10,12)(13,15)(16,18)(19,21)(22,24)(25,27)(28,30)(35,37)
  (38,40)(41,43)(44,46)(47,49)(50,52)(54,56)(58,60)(62,64)(66,68)(70,72)
  (74,76),(1,5)(2,7)(3,8),( 1,2)( 5,6)( 8,9)(11,12),
 ( 1,3)( 8,11)(12,15)(20,22)(25,26)(28,29)(32,33)(35,36),
 ( 1,10)( 3,12)( 5,13)( 8,15),( 1,4)( 9,11)(13,15)(20,23)(25,26)(29,30)
  (32,33)(36,37),( 1,4)( 5,8)(13,15)(17,19)(25,26)(29,30)(32,33)(36,37),
 (11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(36,37)(39,40)(42,43)
  (45,46)(48,49)(51,52)(54,55)(58,59)(62,63)(66,67)(70,71)(74,75),
 ( 5,6)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,8)( 3,11)( 5,14),(10,12)(13,15)(16,18)(19,21)(22,24)(25,27)(28,30)
  (35,37)(38,40)(41,43)(44,46)(47,49)(50,52)(53,55)(57,59)(61,63)(65,67)
  (69,71)(73,75),( 4,7)( 8,11)(16,18)(20,22)(24,25)(27,28)(31,32)(34,35),
 ( 2,6)( 3,8)(10,13)(11,16),( 2,3)( 6,7)( 8,9)(10,11)(12,13)(14,15)
  (16,17),( 4,10)( 5,12)( 6,13)( 7,15)( 8,16)( 9,18),
 ( 2,25)( 4,26)( 7,27)( 9,29)(12,30)(14,32)(16,33)(18,34)(21,36)(23,37),
 ( 3,10)( 5,12)( 7,13)( 9,15),( 1,10)( 3,11)( 6,13)( 8,14),
 (11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(36,37)(39,40)(42,43)
  (45,46)(48,49)(51,52)(55,56)(59,60)(63,64)(67,68)(71,72)(75,76),
 ( 3,4)( 5,6)( 7,8)( 9,10)(11,12)(13,14)(15,16),
 ( 2,4)( 6,8)(13,16)(17,20)(26,27)(29,30)(33,34)(36,37),
 ( 2,7)( 3,9)( 4,11)( 5,13),( 4,5)( 8,9)(13,14)(18,19)(23,24),
 ( 1,13)( 2,14)( 3,15)( 4,16)( 5,17)( 6,18),( 1,3)( 4,11)( 6,13),
 ( 1,6)( 2,8)( 4,10)( 5,12),( 3,7)( 4,9)( 6,11),
 ( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35),
 ( 3,5)( 7,8)( 9,10)(11,12),( 1,2)( 4,5)(15,16)(18,19)(21,22),
 ( 1,6)( 2,11)( 4,13),( 4,7)( 8,12)(13,17)(18,22)(23,27),
 ( 1,4)( 5,11)( 7,12)( 9,13),( 1,4)( 5,11)( 7,12),
 ( 2,3)(12,13)(14,15)(17,18)(19,20)(22,23)(24,25),( 1,5)( 2,10)( 4,11),
 ( 1,2)( 6,7)(11,12)(15,16)(20,21),( 2,5)(10,11)(12,13),
 ( 4,5)( 9,10)(13,14)(18,19)(22,23),( 5,6)( 9,10)(14,15)(19,20)(23,24),
 ( 4,5)( 9,10)(13,14)(19,20)(23,24),( 3,4)( 9,10)(14,15)(17,18)(21,22),
 ( 5,6)(10,11)(15,16)(19,20)(24,25),( 2,3)( 8,9)(12,13),
 ( 3,4)(10,11)(12,13),( 1,6)( 2,10)( 4,11),( 2,9)( 3,11)( 6,13)( 7,15),
 ( 2,10)( 3,12)( 6,14)( 7,16),( 1,2)( 3,4)(11,12)(15,16),
 ( 3,10)( 5,11)( 7,12)( 9,16)(14,18)(17,19),(2,6)(4,8)(5,9),
 ( 4,8)( 6,9)(11,14)(13,15),( 3,4)( 6,7)(10,11),
 ( 7,8)(11,12)(17,18)(21,22)(26,27),( 5,6)(11,12)(15,16)(20,21)(25,26),
 (2,3)(4,5)(6,8),( 5,6)(10,11)(15,16)(19,20)(25,26),
 ( 3,4)( 6,11)( 8,12)(10,13),( 2,3)( 8,9)(10,11)(13,14)(15,16),
 ( 3,8)( 5,9)(10,14)(12,15),( 1,2)( 4,10)( 6,12),( 1,3)( 5,10)( 7,11),
 ( 1,3)( 4,9)( 6,10),( 4,8)( 9,13)(14,18)(19,23)(24,27),
 ( 4,8)( 9,13)(14,17)(18,23)(24,27),( 7,8)(11,12)(16,17)(21,22)(25,26),
 ( 1,5)( 6,9)(10,13)(14,18)(19,23),( 1,2)( 4,5)(14,15)(17,18)(20,21),
 ( 1,4)( 2,7)( 3,10),( 2,10)( 5,12)( 7,14)( 8,15)( 9,16),
 ( 5,6)( 7,8)( 9,10)(13,14),( 5,6)( 9,10)(14,15)(19,20)(24,25),
 ( 3,4)( 8,9)(12,13)(17,18)(22,23),( 1,6)( 2,9)( 3,12),(1,3)(6,7),
 ( 4,7)( 8,13)(14,17)(18,22)(23,27),( 2,10)( 4,11)( 6,13)( 8,17)(12,18)
  (15,19),( 3,7)( 4,9)( 6,10),( 1,5)( 6,10)(11,14)(15,18)(19,23),
 ( 6,8)(11,12)(16,17)(21,22)(25,27),( 1,2)( 7,10)(14,17)(21,24),
 ( 1,4)( 5,7)(11,12)(14,15)(16,17),( 1,10)( 3,12)( 5,13)( 6,15)( 9,17)
  (11,18)(14,19)(16,20),( 5,6)(11,12)(16,17)(21,22)(26,27)(31,32)(36,37)
  (39,40)(42,43)(46,47)(49,50)(53,54)(56,57),( 2,7)( 3,10)( 5,11),
 (10,11)(13,14)(16,17)(18,19)(22,23)(24,25)(28,29)(41,42)(44,45)(47,48)
  (50,51)(53,54)(56,57)(59,60)(63,64)(65,66)(69,70)(71,72)(75,76),
 ( 4,5)( 7,8)(10,11)(14,15)(18,19)(21,22)(24,25)(27,28)(31,32)(35,36)
  (38,39)(41,42)(44,45)(48,49)(52,53),( 4,20)( 5,21)( 6,22)( 7,24)( 8,25)
  ( 9,27)(10,28)(11,29)(12,31)(13,32)(14,34)(15,35)(16,36)(17,38)(18,39),
 ( 6,7)( 9,10)(13,14)(17,18)(20,21)(24,25),
 ( 5,6)(10,11)(14,16)(19,21)(24,26),( 4,6)( 9,12)(14,16)(18,21)(24,26),
 ( 1,3)( 4,10)( 5,12),( 3,8)( 4,10)( 6,12),
 ( 2,10)( 3,11)( 4,12)( 6,13)( 7,14)( 8,15),
 ( 3,5)( 9,10)(13,15)(18,19)(23,25),( 4,6)( 8,9)(12,14)(16,17)(20,22)
  (24,25),( 4,7)( 8,10)(12,15)(16,18)(20,23)(24,26),
 ( 6,7)(12,13)(16,17)(22,23)(27,28),( 5,7)( 9,11)(13,15)(18,19)(22,24)
  (26,28)(30,32)(35,36)(39,41)(43,45)(47,49)(52,53),
 ( 5,6)(11,12)(16,17)(21,22)(27,28),( 7,8)(11,12)(16,18)(21,22)(25,27),
 ( 2,4)( 9,12)(13,16)(21,23)(25,26)(30,31)(33,34)(37,38)(39,40)(42,43)
  (44,45)(47,48),( 4,5)( 9,10)(13,14)(18,19)(23,24),(1,3)(4,6)(8,9),
 ( 1,7)( 3,10)( 6,11),( 5,6)(10,11)(14,16)(19,21)(24,25),
 ( 1,7)( 2,12)( 5,13),( 5,6)( 9,11)(14,16)(19,21)(24,26)(29,31)(34,36)
  (39,40)(44,45)(46,47)(51,52)(53,54)(58,59),
 ( 4,5)( 7,8)(11,12)(14,15)(18,19)(21,22),
 ( 5,6)( 9,10)(13,14)(16,17)(20,21)(24,25),
 ( 6,8)(11,12)(15,17)(19,22)(23,26),( 4,5)( 9,10)(12,13)(17,18),
 ( 1,10)( 2,12)( 5,13)( 7,15),( 6,7)(10,11)(14,15)(17,18)(21,22)(25,26),
 ( 4,5)( 7,8)(10,11)(14,15)(17,18)(21,22)(24,25)(27,28)(31,32)(34,35)
  (38,39)(41,42)(44,45)(48,49)(51,52),( 8,9)(10,11)(12,14)(16,17)(18,19)
  (20,21),( 2,3)( 6,7)(11,12)(15,16)(20,21)(24,25),
 ( 1,10)( 4,12)( 5,14)( 7,15)( 9,17)(11,18)(13,19)(16,20),
 ( 4,5)( 8,9)(11,12)(15,16)(18,19)(22,23)(25,26)(29,30)(32,33)(36,37)
  (39,40)(43,44),( 7,8)( 9,11)(14,16)(19,21)(24,26)(29,31)(34,36)(40,41)
  (42,43)(47,48)(49,50)(54,55)(56,57),( 3,7)( 6,9)(11,13)(12,15),
 ( 2,3)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(41,42)(44,45)(48,49)
  (51,52)(55,56)(58,59),( 2,5)( 6,9)(14,16)(18,20)(25,26)(29,30)(32,33)
  (35,36)(38,39)(41,42),( 3,10)( 7,12)( 9,14)(11,15)(13,16),
 ( 3,9)( 5,11)( 6,13)( 7,17)(14,19)(16,21),
 ( 2,5)( 6,10)(11,15)(16,19)(20,24)(25,29),
 ( 9,39)(11,41)(13,42)(15,43)(17,45)(19,46)(21,48)(23,49)(25,50)(27,52)
  (29,53)(31,55)(33,56)(35,57)(37,59),( 5,7)(10,13)(15,17)(19,22)(25,27),
 ( 1,10)( 4,11)( 8,13)(12,15)(14,16),( 1,5)( 6,9)(10,14)(15,18)(19,23),
 ( 4,6)( 9,10)(14,15)(19,20)(23,25),( 1,5)( 2,8)( 3,11),
 ( 2,3)( 7,8)(11,14)(18,21)(22,25)(26,29)(33,36)(37,40)(41,44)(48,51)
  (52,55),(11,12)(14,15)(17,18)(19,20)(22,23)(24,25)(26,27)(37,38)(39,40)
  (43,44)(45,46)(47,48)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67)(69,70),
 ( 3,9)( 8,10)(11,13)(12,14),( 1,3)( 5,11)( 7,12),
 ( 2,8)( 5,10)(11,14)(12,16),( 6,15)( 8,16)( 9,18)(10,19)(12,21)(13,22),
 ( 4,5)( 6,8)( 9,10)(11,13)(14,15)(16,17)(18,20)(21,22)(23,25)(26,27),
 ( 4,7)( 8,11)(12,14)(15,17)(18,20)(21,24)(25,28)(29,31)(32,34)(35,37)
  (38,41)(42,45)(46,48)(49,51)(52,54),( 7,11)( 8,16)(13,34)(19,35)(23,36)
  (29,37)(30,43)(31,45)(32,52)(33,54)(38,56)(41,59)(44,62)(47,65)(50,68)
  (53,71)(58,74)(60,75)(64,76)(66,77)(70,78)(72,79),
 ( 9,10)(13,14)(15,16)(19,20)(21,22)(24,25)(27,28)(42,43)(45,46)(48,49)
  (51,52)(54,55)(57,58)(59,60)(63,64)(65,66)(69,70)(71,72)(75,76),
 ( 4,6)(10,11)(14,16)(19,20)(24,26),( 5,11)( 6,13)( 7,14)( 8,16)( 9,17)
  (10,19),( 3,8)( 6,10)(11,14)(12,16),( 4,5)( 8,9)(11,12)(15,16)(21,22)
  (26,27)(31,32)(36,37)(41,42)(46,47),( 1,24)( 3,26)( 5,27)( 6,29)( 9,30)
  (10,32)(12,33)(14,35)(15,36)(18,37)(19,38)(21,40)(23,41)(25,42)(28,43)
  (31,45)(34,46)(39,48)(44,50)(47,51)(49,52),
 ( 4,5)( 8,10)(12,14)(16,18)(21,22)(25,27)(29,31)(33,35)(38,39)(42,44)
  (46,48)(50,52),( 3,5)( 6,9)(10,11)(12,13)(15,16),
 ( 6,7)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)(39,40)(42,43)(46,47)
  (49,50)(53,54)(56,57),( 7,8)(11,12)(15,16)(20,21)(24,25)(28,29)(31,32)
  (35,36)(39,40)(44,45)(48,49)(52,53),( 6,7)( 9,10)(13,14)(16,17)(20,21)
  (23,24),( 4,5)( 7,8)(11,12),( 5,7)( 8,12)( 9,13)(10,14)(11,15),
 ( 2,3)( 8,9)(10,11)(13,14),( 7,13)( 8,29)(10,34)(16,35)(20,36)(26,37)
  (30,43)(31,45)(32,52)(33,54)(38,56)(41,59)(44,62)(47,65)(50,68)(53,71)
  (58,74)(60,75)(64,76)(66,77)(70,78)(72,79),(4,5)(6,8),
 ( 4,5)( 7,8)(10,11)(12,14)(15,17)(18,19)(21,22)(24,25)(26,28)(29,31)
  (32,33)(35,36)(38,39)(40,42)(43,45),( 2,7)( 4,10)( 6,11),
 ( 4,6)( 8,9)(10,11),( 5,7)( 9,12)(13,16)(18,20)(22,24)(26,29)(30,33)
  (35,37)(39,41)(43,46)(47,50)(52,54),( 4,5)( 7,8)( 9,10)(11,12)(13,14),
 ( 3,4)( 8,9)(11,14)(15,18)(22,25)(26,29)(30,33)(37,40)(41,44)(45,48)
  (52,55),( 3,5)( 7,9)(10,11)(13,15)(17,18),
 ( 1,4)( 9,11)(13,15)(20,23)(25,26)(30,31)(34,35)(36,37)(40,41)(42,43)
  (44,45)(47,48),( 5,8)( 9,12)(14,16)(19,20)(23,25),
 ( 6,7)(10,11)(13,14)(17,18)(21,22)(24,25),
 ( 2,10)( 4,11)( 7,13)( 9,15)(12,18)(14,19),
 ( 1,3)(14,15)(16,17)(18,19)(20,21)(22,23)(24,25),
 ( 2,3)( 4,6)( 7,8)( 9,11),( 4,6)( 8,10)(12,15)(16,19)(21,23)(25,27)
  (29,32)(33,36)(38,40)(42,44)(46,49)(50,53),( 4,6)( 7,9)(10,12),
 ( 4,5)( 7,8)(12,13)(15,16)(20,21)(23,24),
 ( 4,5)( 6,7)( 8,10)(11,13)(14,15)(16,17)(18,19)(20,22)(23,25)(26,27),
 ( 1,2)( 4,13)( 6,14),( 4,7)( 9,12)(13,17)(18,22)(23,26),
 ( 4,6)( 9,10)(13,14)(17,18)(21,23),( 1,10)( 2,12)( 5,14)( 6,15)( 8,17)
  (11,18)(13,19)(16,20),( 4,6)( 7,8)( 9,10)(11,12)(13,15)(16,18)(19,20)
  (21,22)(23,24)(25,27),( 1,24)( 3,25)( 5,27)( 6,28)( 9,29)(10,30)(12,32)
  (14,33)(15,35)(18,36)(19,38)(21,39)(23,41)(26,43)(31,45)(34,46)(37,48)
  (40,49)(42,50)(44,51)(47,52),( 7,8)(10,12)(13,15)(16,18)(20,21)(22,24)
  (26,28)(30,31)(32,34)(36,37)(39,40)(42,44)(45,46)(48,50)(52,54),
 ( 7,9)(10,11)(13,14)(16,18)(19,21)(23,25)(26,28)(30,31)(33,34)(35,37)
  (38,40)(42,43)(45,47)(49,50)(52,54),( 1,2)( 6,7)(10,11)(15,16)(19,20),
 ( 4,5)( 8,10)(12,14)(17,18)(21,22),( 5,6)( 9,10)(12,13)(16,17)(19,20)
  (23,24)(26,27)(30,31)(33,34)(37,38)(40,41)(44,45),
 (11,12)(14,15)(16,17)(19,20)(21,22)(23,24)(26,27)(37,38)(39,40)(43,44)
  (45,46)(47,48)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67)(69,70),
 ( 5,6)( 9,10)(12,13)(16,17)(18,19)(23,24)(28,29)(33,34)(38,39)(43,44),
 ( 3,7)( 6,8)( 9,11)(10,13),( 7,14)( 8,18)( 9,27)(11,33)(15,34)(17,35)
  (24,36)(30,37)(31,45)(32,54)(38,56)(41,59)(44,62)(47,65)(50,68)(53,71)
  (60,74)(66,75)(72,76),( 7,8)(10,11)(13,15)(16,18)(20,22)(23,25)(27,28)
  (30,31)(32,34)(35,37)(39,40)(42,44)(46,47)(49,51)(52,54),
 ( 3,5)( 8,10)(13,14)(18,19)(22,24),( 1,12)( 2,13)( 3,15)( 4,16)( 5,18)
  ( 6,19),( 3,10)( 4,11)( 5,12)( 7,13)( 8,14)( 9,15),
 ( 4,6)( 8,10)(12,14)(17,18)(21,23)(25,27)(29,31)(34,35)(38,40)(42,44)
  (46,48)(51,52),( 3,5)( 6,9)(11,13)(14,17)(19,21)(22,25),
 ( 7,9)(11,13)(14,16)(18,19)(21,22)(23,25)(26,28)(30,31)(33,35)(37,38)
  (40,42)(43,45)(46,47)(49,50)(52,54),( 5,6)( 7,8)(12,13)(17,18)(22,23)
  (25,26),( 5,8)(10,12)(14,17)(20,22)(24,26),
 ( 3,6)( 4,7)( 8,12)(10,15),( 3,4)( 8,10)(12,14)(18,19)(22,24),
 ( 2,3)( 6,8)(11,13)(16,18)(24,25)(29,30)(34,35),
 ( 1,2)( 9,10)(14,15)(19,20)(22,23)(25,26),
 ( 5,6)(10,11)(14,15)(18,19)(22,23)(27,28)(31,32)(35,36)(39,40)(44,45)
  (48,49)(52,53),( 1,10)( 4,11)( 6,13)( 9,14),( 2,8)( 4,10)( 5,12),
 ( 1,11)( 2,12)( 5,14)( 7,15),( 2,11)( 6,13)( 9,14)(10,15)(12,16),
 ( 3,5)( 8,10)(13,15)(18,19)(23,24),( 5,6)( 9,10)(14,15)(19,20)(24,25)
  (29,30)(34,35)(40,41)(44,45)(47,48)(51,52)(54,55)(58,59),
 ( 5,6)( 7,8)( 9,10)(12,13)(14,15)(17,18)(19,20)(21,22)(24,25)(26,27),
 ( 4,7)( 8,12)(13,17)(18,21)(23,26),( 6,7)(11,12)(16,17)(21,22)(25,26),
 ( 4,6)( 9,10)(13,15)(19,20)(23,24),( 1,2)( 8,10)(13,15)(18,20)(23,24)
  (28,29)(33,34),( 1,6)( 2,9)( 3,12)( 4,14)( 5,17),
 ( 3,4)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)(39,40)(43,44)(46,47)
  (50,51)(53,54)(57,58),( 4,6)( 9,11)(14,15)(19,20)(24,25),
 ( 3,4)( 7,8)(12,13)(17,18)(21,22),( 6,7)(11,12)(16,17)(22,23)(27,28),
 ( 1,5)( 2,13)( 4,14),( 2,6)( 4,9)( 5,11),
 ( 3,6)( 8,11)(13,16)(18,21)(22,26),( 1,3)( 5,11)( 8,12),
 ( 2,6)( 7,11)(12,15)(16,20)(21,25)(26,29),
 ( 5,8)(10,13)(14,18)(19,23)(24,27),( 4,5)( 6,8)(11,13)(16,18)(22,23)
  (27,28)(32,33),( 2,7)( 3,9)(10,15)(11,17),
 ( 6,7)( 8,9)(12,14)(15,16),( 5,6)( 7,8)(10,11)(12,13)(14,15)(17,18)
  (19,20)(22,23)(24,25)(26,27),( 6,7)( 9,10)(12,13)(16,17)(19,20)(23,24)
  (26,27)(29,30)(33,34)(36,37)(40,41)(43,44)(46,47)(50,51)(53,54),
 ( 4,6)( 7,10)(11,13)(14,16)(17,20)(21,23)(24,27)(28,30)(31,33)(34,37)
  (38,40)(41,44)(45,47)(48,50)(51,54),( 4,6)( 8,10)(13,14)(17,18)(21,22),
 ( 1,7)( 2,10)( 3,12)( 4,15)( 5,18),( 1,10)( 3,12)( 7,14)(11,15)(13,16),
 ( 9,10)(12,13)(14,16)(17,18)(20,22)(23,25)(26,28)(30,31)(32,34)(35,36)
  (38,39)(40,42)(44,45)(47,48)(50,52),( 5,7)(10,11)(15,17)(19,21)(25,26),
 ( 5,6)( 8,9)(12,13)(15,16)(18,19)(22,23)(25,26)(29,30)(32,33)(35,36)
  (39,40)(42,43)(46,47)(49,50)(52,53),( 5,6)( 9,10)(13,14)(17,18)(22,23)
  (26,27)(30,31)(34,35)(39,40)(43,44)(47,48)(51,52),
 ( 4,5)( 8,10)(14,15)(18,19)(23,25),( 4,5)( 6,7)( 8,10)(11,12)(13,15)
  (16,17)(18,19)(20,22)(23,24)(25,27),( 6,7)( 8,9)(13,14)(15,17),
 ( 3,4)( 8,10)(13,15)(18,20)(21,22)(26,27)(31,32),
 ( 4,5)( 6,8)( 9,11)(12,13)(14,15)(16,17)(18,20)(21,23)(24,25)(26,27),
 ( 5,6)( 7,8)( 9,10)(11,12)(14,15)(17,18)(19,20)(21,22)(23,24)(26,27),
 ( 4,7)( 8,12)( 9,13)(10,14)(11,15),( 7,8)(12,13)(16,18)(21,23)(26,27),
 ( 4,7)( 8,11)(12,15)(17,19)(21,24),( 1,6)( 2,11)( 4,12),
 ( 3,7)( 8,11)(13,16)(18,21)(23,26),( 5,8)( 9,12)(14,16)(18,20)(22,25)
  (26,29)(31,33)(35,37)(39,42)(43,46)(48,50)(52,54),
 ( 7,9)( 8,25)(12,34)(18,35)(22,36)(28,37)(30,39)(31,41)(32,48)(33,50)
  (40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(59,75)(63,76)(65,77)
  (69,78)(71,79),( 4,5)( 6,8)( 9,10)(11,12)(13,15)(16,17)(18,20)(21,22)
  (23,24)(25,27),( 7,17)( 8,21)( 9,30)(12,33)(14,34)(18,35)(20,36)(27,37)
  (31,45)(32,54)(38,56)(41,59)(44,62)(47,65)(50,68)(53,71)(60,74)(66,75)
  (72,76),( 4,8)( 9,12)(13,17)(18,22)(23,27),
 ( 2,9)( 4,11)( 6,14)( 7,17)(13,19)(15,21),
 ( 6,7)( 9,10)(12,13)(15,16)(19,20)(23,24)(26,27)(29,30)(32,33)(36,37)
  (40,41)(43,44)(46,47)(49,50)(53,54),( 6,7)(10,11)(14,15)(19,20)(23,24)
  (27,28)(31,32)(36,37)(40,41)(44,45)(48,49)(53,54),
 ( 4,6)( 7,9)(10,11)(13,14)(16,17)(18,20)(21,23)(24,25)(27,28)(30,31)
  (32,34)(35,37)(38,39)(41,42)(44,45),( 5,6)( 9,10)(13,14)(16,17)(19,20)
  (22,23)(26,27)(30,31)(33,34)(36,37)(39,40)(43,44)(47,48)(50,51)(53,54),
 ( 3,7)( 9,11)(13,17)(18,21)(23,26),( 1,24)( 3,25)( 5,27)( 6,28)( 8,30)
  (10,31)(11,32)(14,34)(15,36)(17,37)(19,38)(20,40)(23,42)(26,43)(29,44)
  (33,45)(35,46)(39,47)(41,48),( 4,5)( 7,9)(12,13)(15,17)(20,21)(23,25),
 ( 2,4)( 6,9)( 8,10),( 7,8)(12,13)(17,18)(19,20)(23,24)(26,27)(30,31)
  (33,34)(37,38),( 4,5)( 9,10)(11,14)(15,18)(19,22)(26,29)(30,33)(34,37)
  (41,44)(45,48)(49,52),( 1,2)( 4,11)( 7,12),
 ( 5,9)( 8,10)(11,15)(13,16),( 7,10)(12,15)(16,18)(20,22)(24,26)(28,30)
  (31,34)(36,39)(40,42)(44,46)(48,50)(52,54),
 ( 1,2)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)(40,41)(43,44)(47,48)
  (50,51)(54,55)(57,58),( 2,10)( 5,11)( 6,13)( 9,14),
 ( 1,4)( 9,11)(13,15)(20,23)(24,25)(28,29)(30,31)(34,35)(39,40)(43,44)
  (46,47)(48,49),( 1,2)( 9,12)(13,16)(17,20)(24,27)(28,31)(32,35)(39,42)
  (43,46)(47,50),( 6,7)(10,11)(14,16)(18,20)(23,24),
 ( 4,5)( 8,9)(11,12)(14,15)(17,18)(21,22)(25,26)(28,29)(31,32)(34,35)
  (38,39)(42,43)(45,46)(48,49)(51,52),( 4,6)( 7,10)(12,14)(15,18)(20,22)
  (23,26),( 2,7)( 5,9)(11,13)(12,15),( 6,8)( 9,11)(12,14)(15,17)(18,20)
  (21,23)(24,26)(27,29)(30,32)(33,35)(36,38)(39,41)(42,44)(45,47)(48,50),
 ( 1,24)( 4,26)( 5,28)( 7,29)( 9,30)(10,32)(13,34)(14,35)(16,36)(18,38)
  (19,39)(21,41)(23,42)(25,43)(27,44)(31,45)(33,46)(37,47)(40,48),
 ( 7,9)(10,12)(14,15)(17,19)(21,22)(24,26)(27,29)(30,31)(33,34)(36,38)
  (39,41)(43,45)(46,48)(50,51)(53,54),( 7,8)( 9,10)(14,15)(19,20)(24,25)
  (29,30)(34,35)(40,41)(43,44)(47,48)(50,51)(54,55)(57,58),
 ( 7,13)( 8,22)( 9,26)(10,33)(16,34)(23,35)(25,36)(29,37)(31,39)(32,48)
  (40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(63,75)(69,76),
 ( 4,5)( 9,10)(14,15)(18,20)(23,25),( 1,24)( 3,26)( 4,27)( 7,28)( 8,29)
  (10,31)(12,32)(13,33)(15,35)(17,36)(18,38)(21,39)(22,41)(25,42)(30,44)
  (34,46)(37,47)(40,49)(43,50)(45,51)(48,52),( 1,6)( 2,13)( 4,14),
 ( 3,5)( 7,8)(10,11)(13,15)(16,18),( 7,19)( 8,21)( 9,22)(10,23)(12,25)
  (13,26)(15,28)(16,29)(17,30)(18,32),( 6,7)(11,12)(15,17)(20,22)(25,26),
 ( 4,8)( 9,13)(14,17)(18,22)(23,27),( 3,6)( 4,7)( 9,14)(11,17),
 ( 4,5)( 6,7)( 8,9)(11,12)(13,14)(16,17)(18,19)(20,21)(23,24)(25,26),
 ( 6,7)(10,11)(14,15)(18,19)(23,24)(27,28)(31,32)(35,36)(40,41)(44,45)
  (48,49)(52,53),( 1,5)( 4,11)( 7,13),( 1,2)(11,13)(16,18)(21,23)(26,28)
  (31,33)(36,38)(41,42)(43,44)(48,49)(50,51)(55,56)(57,58),
 ( 6,7)(11,12)(16,17)(21,22)(27,28),( 5,6)( 9,11)(13,15)(17,19)(22,23)
  (26,28)(30,32)(34,36)(39,40)(43,45)(47,49)(51,53),
 ( 3,4)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(41,42)(44,45)(48,49)
  (51,52)(55,56)(58,59),( 5,7)( 9,11)(14,15)(18,20)(22,24)(26,28)(31,32)
  (35,37)(39,41)(43,45)(48,49)(52,54),( 1,2)( 7,8)(11,12),
 ( 2,7)( 4,11)( 6,12),( 2,10)( 3,12)( 6,13)( 8,15),( 1,3)( 5,11)( 7,13),
 (3,7)(4,8)(5,9),( 4,5)( 9,10)(14,15)(20,21)(24,25)(27,28)(31,32)(34,35)
  (38,39),( 3,10)( 5,11)( 6,12)( 8,14)(13,18)(15,19),
 ( 4,5)( 8,9)(13,14)(17,18)(21,22)(25,26)(30,31)(34,35)(38,39)(42,43)
  (47,48)(51,52),( 4,5)( 9,10)(13,15)(18,20)(23,24),
 ( 1,6)( 2,9)( 4,10),( 2,3)( 5,6)( 9,10)(11,12)(14,15)(17,18)(19,20)
  (21,22),( 3,4)( 6,7)(11,12)(14,15)(19,20)(22,23),
 ( 2,7)( 4,10)( 8,11),( 6,7)(10,11)(15,17)(20,21)(24,26),
 ( 4,9)( 5,10)( 8,11),( 3,4)(10,11)(15,16)(20,21)(25,26)(30,31)(35,36)
  (41,42)(44,45)(48,49)(51,52)(55,56)(58,59),
 ( 4,5)( 8,9)(12,13)(16,17)(21,22)(25,26)(29,30)(33,34)(38,39)(42,43)
  (46,47)(50,51),( 4,7)( 8,11)(13,15)(17,19)(21,24)(25,28)(30,32)(34,36)
  (38,41)(42,45)(47,49)(51,53),( 3,7)( 5,9)( 6,11),
 ( 5,7)( 6,8)( 9,11)(10,13),( 8,9)(11,12)(14,15),
 ( 5,6)(10,11)(15,16)(20,21)(25,26)(30,31)(35,36)(40,41)(44,45)(47,48)
  (51,52)(54,55)(58,59),( 2,3)( 7,8)(11,12)(16,17)(21,22)(25,26),
 ( 6,7)(11,12)(16,17)(20,22)(25,27),( 1,4)( 7,9)(10,11)(13,14)(15,16),
 ( 3,6)( 7,9)(11,14)(15,17)(19,22)(23,25),
 ( 6,7)(10,12)(14,16)(18,20)(23,24)(27,29)(31,33)(35,37)(40,41)(44,46)
  (48,50)(52,54),(1,2)(5,7),( 4,7)( 8,11),
 ( 6,7)(11,12)(16,17)(20,21)(25,26),( 6,8)(12,13)(16,17)(21,23)(26,27),
 (12,13)(14,15)(16,17)(19,20)(21,22)(24,25)(27,28)(37,38)(41,42)(43,44)
  (45,46)(49,50)(51,52)(53,54)(56,57)(59,60)(62,63)(65,66)(68,69),
 ( 1,9)( 4,10)(12,15)(14,16),( 4,6)( 8,10)(15,18)(19,22)(24,25)(27,28)
  (30,31)(33,34)(36,37)(40,41),( 5,6)(10,11)(14,15)(19,20)(24,25)(28,29),
 ( 6,7)(10,11)(15,16)(20,21)(25,26),( 4,8)( 9,12)(13,17)(19,22)(23,26),
 ( 3,10)( 5,12)( 9,14)(11,15)(13,16),( 1,2)( 4,5)( 9,10)(11,12)(13,14)
  (16,17)(19,20)(21,22),( 6,7)(11,13)(16,17)(20,22)(26,27),
 ( 2,10)( 4,12)( 5,13)( 8,15)( 9,17)(11,18)(14,19)(16,20),
 ( 1,3)( 5,12)( 8,13),( 4,5)( 8,9)(14,15)(19,20)(24,25),
 ( 4,7)( 9,11)(13,16)(17,20)(21,24),( 3,6)( 8,11)(12,16)(18,20)(22,26),
 ( 2,5)( 6,10)( 9,11),( 5,7)( 9,11)(13,15)(16,18)(20,22)(24,26),
 ( 7,9)(10,12)(13,15)(16,18),( 8,9)(11,12)(14,15)(17,18),
 ( 9,11)(13,14)(15,17)(18,19)(21,22)(23,25)(27,28)(30,31)(33,35)(36,37)
  (39,40)(41,43)(44,45)(47,49)(50,52),( 4,6)( 8,10)(11,13)(15,17)(18,20)
  (22,24)(25,27)(29,31)(32,34)(36,38)(39,41)(43,45),
 ( 3,4)( 7,8)(13,14)(15,16)(21,22),( 2,10)( 4,12)( 7,13)( 8,15),
 ( 1,2)(11,12)(16,17)(21,22)(26,27)(31,32)(36,37)(40,41)(43,44)(47,48)
  (50,51)(54,55)(57,58),( 4,19)( 5,20)( 6,22)( 7,23)( 8,24)( 9,26)(10,27)
  (11,29)(12,30)(13,31)(14,33)(15,34)(16,36)(17,37)(18,38),
 ( 5,6)( 7,8)(10,11)(12,13),( 4,5)( 8,10)(13,15)(18,19)(23,24),
 ( 2,3)( 6,9)(13,16)(17,20)(21,24)(28,31)(32,35)(36,39)(43,46)(47,50),
 ( 1,2)( 6,7)(14,17)(18,21)(22,25)(29,32)(33,36)(37,40)(44,47)(48,51)
  (52,55),( 1,3)( 4,13)( 6,14),( 2,3)( 9,11)(14,16)(19,21)(24,26)(29,31)
  (34,36)(42,43)(44,45)(49,50)(51,52)(56,57)(58,59),
 ( 7,13)( 8,15)( 9,16)(10,18)(11,19)(12,21),( 2,6)( 3,11)( 5,12),
 ( 3,5)( 7,8)(11,13)(15,16)(19,21)(23,24),
 ( 1,10)( 4,12)( 7,14)( 8,15)( 9,16),( 5,6)( 8,9)(10,11)(13,14)(17,18)
  (20,21),( 5,8)( 9,12)(14,18)(19,22)(23,27),
 ( 9,11)(12,14)(16,17)(18,20)(21,22)(24,25)(26,28)(30,31)(33,34)(36,38)
  (39,40)(42,43)(44,46)(47,48)(50,52),( 8,9)(12,13)(17,18)(21,22)(25,26)
  (28,29)(32,33)(36,37)(41,42)(45,46)(49,50)(52,53),
 ( 2,10)( 4,11)( 7,13)( 8,14),( 4,6)( 9,10)(13,15)(17,19)(21,23)(26,27)
  (30,32)(34,36)(38,40)(43,44)(47,49)(51,53),( 2,3)( 4,7)(11,14)(18,21),
 ( 2,6)( 5,7)( 8,14)(10,15),( 4,8)( 9,13)(14,18)(19,22)(23,27),
 ( 1,20)( 2,21)( 3,23)( 4,25)( 5,26)( 6,27)( 7,29)( 8,31)( 9,32)(18,33)
  (19,34),( 2,8)( 3,10)( 5,12),( 5,6)( 8,9)(10,11)(12,13),
 ( 1,4)( 2,11)( 5,13),( 6,7)(11,13)(16,18)(21,23)(26,28)(31,33)(36,38)
  (39,40)(41,42)(46,47)(48,49)(53,54)(55,56),( 3,10)( 5,12)( 8,13)( 9,15),
 ( 3,4)( 9,10)(14,15)(19,20)(24,25),( 2,6)( 5,7)( 9,14)(11,15),
 (11,13)(14,16)(17,19)(20,22)(23,25)(26,28)(29,31)(32,34)(35,37)(38,40)
  (41,43)(44,46)(47,49)(50,52)(53,55),( 5,7)( 9,11)(13,16)(17,20)(22,24)
  (26,28)(30,33)(34,37)(39,41)(43,45)(47,50)(51,54),
 (13,14)(15,16)(18,19)(20,21)(23,24)(25,26)(27,28)(29,30)(32,33)(34,35)
  (37,38)(39,40),( 2,24)( 3,26)( 6,27)( 7,29)( 9,30)(11,32)(12,33)(14,34)
  (16,36)(17,37)(20,38)(21,39)(23,41)(25,42)(28,44)(31,45)(35,47)(40,49)
  (43,50)(46,51)(48,52),( 7,8)(12,13)(17,18)(21,22)(26,27),
 ( 5,7)(10,11)(14,15)(18,19)(22,24),( 3,4)(11,13)(16,18)(21,23)(26,28)
  (31,33)(36,38)(39,40)(44,45)(46,47)(51,52)(53,54)(58,59),
 ( 7,8)(12,13)(16,17)(20,21)(23,24)(27,28)(31,32)(36,37)(40,41)(44,45)
  (47,48)(51,52),( 7,10)( 8,19)( 9,23)(13,33)(20,34)(22,35)(26,36)(28,37)
  (31,39)(32,48)(40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(63,75)
  (69,76),( 4,19)( 5,21)( 6,22)( 7,23)( 8,25)( 9,26)(10,28)(11,29)(12,30)
  (13,32)(14,33)(15,35)(16,36)(17,37)(18,39),( 3,10)( 5,11)( 8,13)( 9,14),
 ( 1,2)( 8,9)(11,12)(13,14)(16,17)(19,20),( 2,7)( 5,9)(10,13)(11,16),
 ( 2,6)( 7,10)(11,15)(16,20)(21,24)(25,29),
 ( 4,7)( 8,11)(13,15)(17,20)(21,24),( 9,10)(13,14)(16,17)(20,21)(24,25)
  (29,30)(33,34)(37,38)(40,41)(44,45)(48,49)(53,54),
 ( 3,4)( 8,9)(14,15)(18,19)(24,25),( 1,3)( 8,11)(12,15)(20,22)(25,26)
  (27,28)(31,32)(34,35)(39,40)(43,44)(46,47)(48,49),
 ( 1,2)( 3,4)(14,15)(17,18)(20,21),( 7,8)(12,13)(17,18)(22,23)(26,27),
 ( 7,9)(11,13)(15,16)(17,19)(21,22)(24,25)(27,29)(30,31)(33,35)(37,39)
  (40,41)(43,45)(46,48)(49,51)(53,54),( 2,8)( 4,10)( 6,12)( 7,16)(13,18)
  (15,20),( 1,11)( 4,12)( 6,14)( 9,15),( 2,4)( 3,8)( 5,10),
 ( 5,6)( 9,10)(14,15)(18,19)(23,24)(27,28),
 ( 4,5)( 7,8)( 9,10)(11,12)(13,14)(16,17)(19,20)(21,22)(23,24)(25,26),
 ( 2,4)( 5,6)( 7,9)(10,11),( 3,4)( 6,9)(10,13)(17,20)(21,24)(25,28)
  (32,35)(36,39)(40,43)(47,50),( 5,6)( 9,10)(13,14)(18,19)(22,23)(26,27)
  (30,31)(35,36)(39,40)(43,44)(47,48)(52,53),( 1,5)( 4,12)( 7,14),
 ( 4,5)( 7,8)(10,11)(14,15)(17,18)(20,21),( 1,2)( 4,10)( 6,11),
 ( 5,7)(10,11),( 8,9)(11,12)(15,16)(19,20)(24,25)(28,29)(32,33)(35,36)
  (39,40)(43,44)(48,49)(52,53),( 4,5)( 9,10)(15,16)(20,21)(25,26),
 ( 6,19)( 8,20)( 9,22)(10,23)(11,25)(13,26)(14,27)(15,29)(16,30)(18,32),
 ( 4,6)( 7,8)( 9,11)(12,13)(14,15)(16,18)(19,20)(21,23)(24,25)(26,27),
 ( 4,8)( 9,12)(13,18)(19,22)(23,27),( 4,5)( 9,11)(14,15)(18,20)(24,25),
 ( 3,4)( 6,8)(10,11)(12,14)(16,18),( 6,7)(10,12)(15,17)(20,21)(25,26),
 ( 6,8)(11,13)(16,17)(21,22)(26,27),( 7,8)(10,11)(13,14)(16,17),
 ( 5,6)( 8,9)(13,14)(16,17)(21,22)(24,25),
 ( 7,9)(11,13)(15,17)(19,21)(22,25)(27,30)(31,33)(35,37)(39,41)(43,45)
  (46,49)(51,54),( 1,5)( 4,10)( 8,11),( 4,6)( 7,10)(11,13)(14,17)(18,20)
  (21,23)(24,27)(28,30)(31,34)(35,37)(38,40)(41,44)(45,47)(48,51)(52,54),
 ( 4,5)( 7,8)(11,12)(14,15)(17,18)(21,22)(24,25)(28,29)(31,32)(34,35)
  (38,39)(41,42)(45,46)(48,49)(51,52),( 4,6)( 8,10)(11,13)(15,17)(18,20)
  (22,24),( 5,8)( 9,13)(14,18)(19,22)(24,27),
 ( 2,6)( 5,8)(10,13)(11,16),( 4,6)( 7,9)(10,13)(14,16)(17,20)(21,23)
  (24,26)(27,30)(31,33)(34,37)(38,40)(41,43)(44,47)(48,50)(51,54),
 ( 7,22)( 8,27)( 9,34)(15,35)(19,36)(25,37)(30,39)(31,41)(32,48)(33,50)
  (40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(59,75)(63,76)(65,77)
  (69,78)(71,79),( 5,6)( 9,11)(14,16)(19,20)(24,25),
 ( 4,6)( 7,8)(10,11)(13,14)(15,17)(18,20)(21,22)(24,25)(27,28)(29,31)
  (32,34)(35,36)(38,39)(41,42)(43,45),( 2,9)( 5,10)( 6,11),
 ( 1,3)( 6,9)(11,12)(13,14)(16,17),( 2,7)( 3,11)( 5,12),
 ( 9,11)(13,14)(16,17)(19,21)(22,23)(25,26)(27,29)(30,31)(33,35)(36,38)
  (39,41)(43,44)(45,47)(48,49)(51,52),( 6,7)(10,11)(14,15)(18,20)(22,24),
 ( 4,6)( 7,9)(10,12)(13,16)(17,20)(21,23)(24,26)(27,29)(30,33)(34,37)
  (38,40)(41,43)(44,46)(47,50)(51,54),( 2,9)( 7,10)(11,13)(12,14),
 ( 4,6)( 5,8)(10,12)(11,14),( 4,6)( 8,11)(12,15)(17,19)(21,23)(25,28)
  (29,32)(34,36)(38,40)(42,45)(46,49)(51,53),
 ( 9,11)(12,13)(15,17)(19,20)(21,23),( 5,6)( 8,9)(12,13)(15,16)(19,20)
  (22,23)(26,27)(29,30)(33,34)(36,37)(40,41)(43,44),
 ( 8,9)(10,11)(12,13)(15,17)(18,19)(20,21),
 ( 6,7)(10,11)(15,16)(19,20)(23,24)(27,28)(32,33)(36,37)(40,41)(44,45)
  (49,50)(53,54),( 1,2)( 4,5)(11,12)(13,14),
 ( 3,4)( 9,10)(14,15)(19,20)(25,26),( 7,8)(11,12)(15,16)(19,20)(24,25)
  (28,29)(32,33)(36,37)(41,42)(45,46)(49,50)(53,54),
 ( 5,6)( 8,9)(11,12)(15,16)(18,19)(22,23)(25,26)(28,29)(32,33)(35,36)
  (39,40)(42,43)(45,46)(49,50)(52,53),( 1,5)( 2,11)( 4,12),
 ( 4,5)( 6,9)(10,13)(14,17)(21,24)(25,28)(29,32)(36,39)(40,43)(44,47),
 ( 8,10)(11,12)(14,16)(18,19)(20,22),( 4,5)( 7,9)(10,11)(12,14)(16,17)
  (18,19)(21,23)(24,25)(26,28)(30,31)(32,33)(35,37)(38,39)(40,42)(44,45),
 ( 5,6)(10,11)(15,16)(20,21)(24,25),( 7,8)(11,13)(16,18)(21,22)(26,27),
 ( 1,4)( 2,6)( 8,11)( 9,12)(10,13),( 6,14)( 7,15)( 9,17)(10,18)(11,20)
  (13,21),( 6,7)( 9,10)(13,14)(16,17)(19,20)(23,24)(26,27)(30,31)(33,34)
  (36,37)(40,41)(43,44)(47,48)(50,51)(53,54),(2,4)(5,6),
 ( 2,3)( 7,8)(11,12)(14,15)(16,17)(19,20),
 ( 1,2)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)(41,42)(44,45)(48,49)
  (51,52)(55,56)(58,59),( 4,5)( 6,7)( 9,10)(11,12)(13,14)(16,17)(18,19)
  (21,22)(23,24)(25,26),( 3,7)( 6,8)( 9,12)(10,13),
 ( 1,10)( 5,12)( 7,14)(11,15)(13,16),( 2,3)( 6,7)(11,12)(16,17)(20,21)
  (25,26),( 6,19)( 7,21)( 8,22)( 9,23)(11,25)(12,26)(14,28)(15,29)(16,30)
  (17,32),( 5,7)(10,11)(14,16)(20,21)(24,25),
 ( 6,7)( 8,9)(12,13)(14,16),( 5,6)(12,13)(17,18)(22,23)(27,28)(32,33)
  (37,38)(39,40)(42,43)(46,47)(49,50)(53,54)(56,57),( 1,6)( 2,10)( 4,12),
 ( 3,10)( 6,11)( 8,13)( 9,15)(12,16)(14,17),
 ( 7,9)(11,12)(14,16)(18,19)(21,23)(24,26)(27,28)(30,31)(33,35)(36,38)
  (40,42)(43,45)(47,48)(50,51)(52,54),( 2,3)( 6,7)(11,12)(16,17)(20,21),
 ( 2,11)( 3,12)( 6,14)( 8,15),( 4,7)( 8,10)(11,14)(15,17)(18,20)(21,24)
  (25,27)(28,31)(32,34)(35,37)(38,41)(42,44)(45,48)(49,51)(52,54),
 ( 6,7)( 8,9)(13,15)(16,17),( 6,8)(10,12)(14,16)(19,20)(23,25)(27,29)
  (31,33)(36,37)(40,42)(44,46)(48,50)(53,54),
 ( 4,7)( 8,10)(11,13)(14,17)(18,20)(21,24)(25,27)(28,30)(31,34)(35,37)
  (38,41)(42,44)(45,47)(48,51)(52,54),(12,13)(15,16)(17,18)(19,20)(22,23)
  (24,25)(27,28)(37,38)(41,42)(43,44)(45,46)(49,50)(51,52)(53,54)(56,57)
  (59,60)(62,63)(65,66)(68,69),( 5,7)(10,11)(15,16)(19,21)(24,26),
 ( 3,10)( 6,11)( 8,12)( 9,14)(13,16)(15,17),
 ( 7,8)(10,11)(15,16)(20,21)(25,26)(30,31)(35,36)(40,41)(43,44)(47,48)
  (50,51)(54,55)(57,58),( 4,5)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38)
  (39,40)(43,44)(46,47)(50,51)(53,54)(57,58),
 ( 1,16)( 3,17)( 4,18)( 6,19)( 7,20)( 9,21)(10,22)(12,23)(13,24)(15,25),
 ( 5,6)( 9,10)(14,15)(19,20)(23,24)(28,29),
 ( 5,6)( 8,10)(13,14)(16,18)(21,22)(24,26),
 ( 6,7)( 9,10)(14,15)(17,18)(22,23)(25,26),
 ( 4,5)( 9,10)(13,14)(17,18)(21,22)(26,27)(30,31)(34,35)(38,39)(43,44)
  (47,48)(51,52),(10,39)(12,41)(14,42)(16,43)(18,45)(20,46)(22,48)(24,49)
  (26,50)(28,52)(30,53)(32,55)(34,56)(36,57)(38,59),
 ( 4,6)( 7,8)( 9,10)(11,13)(14,15)(16,18)(19,20)(21,22)(23,25)(26,27),
 ( 3,8)( 5,10)( 6,12)( 7,15)(14,18)(16,20),
 ( 4,7)( 8,10)(11,13)(14,16)(17,20)(21,24)(25,27)(28,30)(31,33)(34,37)
  (38,41)(42,44)(45,47)(48,50)(51,54),( 1,11)( 4,12)( 5,14)( 8,15),
 ( 8,9)(12,13)(16,17)(21,22)(25,26)(29,30)(32,33)(36,37)(40,41)(45,46)
  (49,50)(53,54),( 4,5)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(40,41)
  (44,45)(47,48)(51,52)(54,55)(58,59),( 1,2)( 7,8)(11,12)(14,15),
 ( 5,7)( 9,11)(14,17)(19,21)(23,26),( 1,13)( 2,14)( 3,16)( 4,17)( 5,19)
  ( 6,20),( 3,5)( 6,8)(10,11)(13,14)(16,18),
 ( 7,9)(11,12)(14,15)(16,18)(19,21)(23,24)(26,28)(30,31)(33,35)(36,38)
  (39,40)(42,43)(45,47)(48,50)(52,54),( 6,7)(10,11)(15,16)(20,21)(24,25),
 ( 1,2)( 4,5)(10,11)(14,15),( 3,4)(11,12)(16,17)(21,22)(26,27)(31,32)
  (36,37)(39,40)(43,44)(46,47)(50,51)(53,54)(57,58),
 ( 7,8)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(39,40)(42,43)(46,47)
  (49,50)(53,54)(56,57),( 6,19)( 8,21)( 9,22)(10,24)(11,25)(13,26)(14,28)
  (15,29)(16,31)(18,32),( 1,5)( 6,10)( 7,12)( 8,14),
 ( 1,8)( 2,10)( 3,11)( 5,12)( 7,13),( 1,10)( 4,13)( 6,15)(11,16)(14,17),
 ( 1,2)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26),
 ( 1,10)( 3,12)( 5,13)( 7,15)( 9,17)(11,18)(14,19)(16,20),
 ( 1,4)( 3,9)( 5,11)( 7,12)(10,14)(13,15),( 3,4)(11,12)(13,14)(15,16),
 ( 1,6)( 2,9)( 5,11)( 7,13)(10,14)(12,15),( 1,3)( 4,10)( 7,11),
 ( 1,4)( 3,11)( 6,13),( 5,6)( 9,10)(13,14)(16,17)(21,22),
 ( 1,6)( 2,8)( 3,9)( 5,11),( 1,4)( 3,11)( 6,12),
 ( 1,4)( 3,9)( 5,11)( 8,13)(10,14)(12,15),
 ( 1,5)( 2,8)( 4,15)( 9,18)(11,20)(13,21)(14,22)(16,23)(17,24)(19,25),
 ( 1,3)( 2,6)( 4,8)(10,13)(12,14),( 5,7)( 9,10)(13,15)(18,20)(22,23)
  (26,27)(30,31),( 3,6)( 9,11)(12,16)(17,18)(19,22)(24,25)(30,31),
 ( 2,8)( 4,11)( 6,14)( 9,15)(12,16),( 3,8)( 5,11)( 7,14)(10,15)(13,16),
 ( 1,2)( 4,7)( 6,11)( 8,15)(10,16)(12,17)(14,18),
 ( 1,5)( 3,9)( 6,11)( 8,13)(10,14)(12,15),( 3,7)( 6,8)( 9,12)(10,14),
 ( 1,2)( 4,5)(11,12)(15,16),( 5,6)( 7,8)(11,12)(15,16)(21,22)(26,27)
  (30,31),( 4,5)(10,11)(12,13),( 1,10)( 3,12)( 5,14)( 7,15)( 9,17)(11,18)
  (13,19)(16,20),( 1,2)( 5,6)(10,11)(14,15)(19,20),
 ( 3,5)( 6,10)( 7,12)( 8,14),( 4,11)( 5,12)( 6,14)( 7,15)( 8,17)( 9,18),
 ( 1,4)( 3,8)( 5,11)( 9,14)(10,15)(12,16)(13,17),
 ( 2,9)( 4,10)( 7,13)( 8,14),( 2,8)( 4,9)( 6,11),
 ( 2,10)( 3,11)( 5,13)( 7,14)( 9,16)(12,18)(15,19)(17,20),
 ( 3,7)( 4,8)( 9,12)(10,14),( 1,4)( 2,8)( 5,10)( 7,12),
 ( 4,5)( 8,9)(13,14)(16,17)(21,22),( 1,11)( 2,12)( 5,15)( 7,16),
 ( 5,6)( 9,10)(14,15)(18,19)(20,21)(23,24)(26,27),( 1,5)( 2,9)( 4,10),
 ( 2,10)( 4,12)( 6,14)( 7,15)( 9,17)(11,18)(13,19)(16,20),(3,6)(5,8)(7,9),
 ( 5,15)( 6,17)( 9,18)(10,20)(11,21)(14,23),( 1,9)( 4,12)( 6,13)( 8,16),
 ( 1,2)(12,13)(14,15)(17,18)(19,20)(22,23)(24,25),( 6,7)( 9,10)(11,12),
 ( 4,5)( 8,9)(14,15)(18,19)(22,23)(26,27)(30,31),
 ( 1,4)( 6,12)( 7,13)( 8,14)( 9,15)(10,16)(11,17),
 ( 5,6)( 7,8)(11,12)(16,17)(20,21)(26,27)(29,30),
 ( 4,5)( 7,8)(10,11)(12,13)(15,16),( 2,3)( 4,5)(11,12)(15,16),
 ( 3,4)( 8,9)(13,14)(17,18)(22,23),( 3,4)( 6,9)( 7,11)( 8,13),
 ( 4,5)( 6,7)( 9,10)(13,14),( 1,5)( 6,9)(10,14)(15,19)(20,23),
 ( 3,6)( 7,8)( 9,13)(14,16)(19,22)(26,27)(32,33),
 ( 1,3)( 2,7)( 4,9)( 6,11),( 4,8)( 5,9)(10,12)(11,14),
 ( 4,5)( 7,9)(12,14)(17,18)(20,22)(24,25)(28,29),
 ( 1,4)( 6,9)( 7,11)( 8,13),( 2,6)( 4,9)( 5,10),
 ( 1,5)( 4,10)( 6,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 1,10)( 3,12)( 5,14)( 6,15)( 8,17)(11,18)(13,19)(16,20),
 ( 2,3)( 6,7)(10,11)(15,16)(20,21),( 1,6)( 3,10)( 5,11)( 7,13)( 9,14)
  (12,15),( 1,11)( 3,13)( 5,14)( 7,16)( 8,17)(10,18)(12,19)(15,20),
 (2,6)(5,8)(7,9),( 1,2)( 8,9)(12,13),( 1,4)( 5,9)(10,13)(14,18)(19,23),
 ( 1,2)( 7,8)(11,12)(13,14)(16,17),( 1,8)( 2,11)( 3,14)( 5,15)( 7,17)
  (12,20)(16,22)(18,23)(19,24)(21,25),( 2,6)( 4,8)( 5,10),
 ( 5,6)(11,12)(15,16)(19,20)(21,22)(24,25)(28,29),( 1,6)( 3,11)( 5,12),
 ( 1,3)( 2,7)( 4,10)( 6,12),( 1,4)( 2,7)( 6,12)( 8,13)(10,14),
 ( 4,10)( 5,11)( 6,13)( 7,14)( 8,16)( 9,17),( 1,5)( 2,8)( 4,9)( 6,11),
 ( 1,5)( 6,10)(11,14)(15,19)(20,23),( 3,6)( 7,9)(10,12)(13,15)(16,18),
 ( 1,4)( 5,9)(10,14)(15,18)(19,23),( 1,3)( 2,5)( 6,10)( 8,12),
 ( 1,5)( 2,9)( 4,11)( 7,13)(10,14)(12,15),(3,6)(4,7),
 ( 1,6)( 3,10)( 5,11)( 7,12)( 9,13),( 1,9)( 3,12)( 5,13)( 8,16),
 ( 1,3)( 4,10)( 6,11)( 8,12)( 9,13),(2,6)(3,7),
 ( 4,14)( 6,17)( 7,18)( 9,21)(11,22)(12,25),( 1,6)( 3,9)( 5,10),
 ( 1,4)( 2,7)( 6,10)( 9,11),( 5,14)( 6,17)( 8,18)(10,21)(11,22)(13,25),
 ( 3,9)( 5,11)( 8,14)(10,16)(13,17),( 1,5)( 2,10)( 4,11)( 6,12)( 8,13),
 ( 3,4)( 8,9)(13,14)(17,18)(21,22),( 1,5)( 2,8)( 3,10)( 6,11),
 ( 2,3)( 5,6)(11,12)(14,15)(16,17),( 3,5)( 9,10)(12,13),
 ( 1,4)( 2,8)( 5,9)( 7,11),( 2,3)( 7,8)(12,13)(16,17)(21,22),
 ( 4,6)( 5,7)( 8,12)(10,14),( 1,6)( 3,10)( 5,11),( 4,5)( 6,7)(10,11),
 ( 1,3)( 2,6)( 5,10)( 7,12),( 1,6)( 2,10)( 4,14)( 7,15)( 9,16)(11,17)
  (13,18),( 3,4)( 6,7)( 9,10)(13,14),( 1,2)( 5,6)( 9,10)(13,14),
 ( 2,3)( 8,9)(13,14)(16,17)(20,21),( 5,15)( 8,17)( 9,18)(10,20)(13,21)
  (14,23),( 1,3)( 2,6)( 5,9)( 8,11),( 1,4)( 7,9)(10,12)(13,15)(16,18)
  ,( 4,5)( 7,8)(15,16)(18,19)(22,23)(24,25)(28,29)(30,31),
 ( 2,10)( 4,12)( 5,13)( 7,15)( 9,17)(11,18)(14,19)(16,20),
 ( 1,10)( 3,12)( 4,13)( 6,15)( 8,17)(11,18)(14,19)(16,20),
 ( 1,2)( 4,5)(10,11)(13,14),( 4,5)( 8,9)(12,13)(18,19)(22,23)(24,25)
  (28,29),( 9,10)(11,13)(14,15)(17,19)(21,22)(24,25),
 ( 5,6)(10,11)(14,15)(17,18)(20,21)(23,24)(26,27)(30,31)(33,34),
 ( 8,9)(10,11)(12,13)(14,15),( 1,2)( 4,10)( 5,12),
 ( 2,11)( 4,12)( 7,13)( 9,14),( 1,7)( 3,10)( 6,12),( 1,9)( 3,11)( 7,13),
 ( 1,6)( 5,9)( 8,10),( 4,6)( 9,11)(13,14)(16,17)(18,19)(21,22)(23,24)
  (26,27),( 4,5)( 8,9)(12,13)(15,16)(20,21),
 ( 7,11)( 8,14)( 9,21)(10,24)(22,33)(27,35)(29,37)(30,40)(31,45)(32,48)
  (38,54)(42,57)(44,60)(46,63)(50,66)(52,69)(53,71)(59,73)(65,75),
 ( 3,6)( 4,8)(10,12)(11,15),( 2,3)( 6,7)(17,18)(21,22)(26,27)(28,29)
  (32,33)(34,35),( 3,5)( 8,10)(13,15)(17,19)(22,24)(27,29),
 ( 2,3)( 5,6)(10,11)(12,13)(14,15)(16,17)(18,19),
 ( 6,8)(12,14)(17,18)(21,23)(27,29)(32,34)(37,38)(42,44)(48,49)(52,54),
 ( 1,7)( 3,8)( 4,9)( 6,12)(10,15)(13,16),( 2,8)( 4,10)(11,14)(12,16),
 ( 5,12)( 6,15)( 7,17)( 8,20)( 9,22)(10,25),
 ( 2,7)( 4,10)( 5,11)( 6,12)( 8,13)( 9,14),
 ( 5,7)(10,12)(14,16)(17,19)(20,22)(23,25)(26,28)(30,32)(33,35),
 ( 7,8)(11,12)(14,15)(16,17)(23,24)(26,27)(30,31)(33,34)(59,60)(61,62)
  (63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)(79,80)(81,82),
 ( 9,10)(12,14)(15,17)(19,20)(21,22)(23,24),
 ( 1,7)( 3,10)( 6,14)( 9,17)(13,19),( 7,15)( 8,19)( 9,22)(10,29)(11,33)
  (12,36)(13,41)(21,43)(23,45)(30,47)(32,49)(40,51),(3,5)(6,7)(8,9),
 ( 2,3)(10,11)(13,14)(18,19)(21,22),( 4,7)( 6,9)(11,13)(12,15),
 ( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)
  (34,35)(36,37)(39,40)(41,42)(44,45)(46,47)(48,49)(51,52)(53,54)(56,57)
  (58,59)(60,61)(63,64)(65,66)(68,69),( 4,7)( 6,8)( 9,12)(10,13),
 ( 2,3)( 5,6)(10,11)(12,13)(14,15)(16,17)(18,19)(20,21),
 ( 1,8)( 3,12)( 6,13),( 4,5)( 9,10)(12,14)(17,18)(21,23),
 ( 5,7)( 9,11)(13,15)(18,20)(22,24)(26,28),
 ( 4,5)( 8,9)(10,11)(12,13)(14,15),( 1,2)( 6,7)(11,12)(16,17)(20,21),
 ( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)
  (34,35)(37,38)(39,40)(41,42)(44,45)(46,47)(49,50)(51,52)(53,54)(56,57)
  (58,59)(61,62)(63,64)(65,66)(68,69),( 2,3)( 6,7)(17,18)(21,22)(25,26)
  (27,28)(31,32)(33,34),( 1,2)( 6,7)(10,11)(15,16)(20,21),
 ( 7,8)( 9,11)(12,14)(15,17)(18,20)(22,23)(24,26)(28,29)(30,31)(32,33)
  (41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(60,61)(62,64)(66,67)(68,70)
  (72,73)(74,76),( 2,4)( 8,10)(13,15)(16,18)(20,22),
 ( 5,7)( 9,11)(12,14)(16,18)(19,21),( 1,5)( 6,9)( 8,10),
 ( 4,7)( 8,10)(12,15)(17,20)(21,23)(25,28),
 (11,12)(14,16)(21,23)(24,26)(33,34)(35,36)(37,39)(40,41)(45,47)(48,49)
  (54,55)(57,58)(60,61)(63,64)(66,67)(69,70)(71,72)(73,74)(75,76),
 ( 7,13)( 8,20)( 9,23)(10,27)(19,34)(24,36)(29,39)(30,41)(31,47)(32,49)
  (38,55)(42,58)(44,61)(46,64)(50,67)(52,70)(53,72)(59,74)(65,76),
 ( 1,9)( 2,11)( 5,13)( 8,14)(10,15)(12,16),
 ( 3,9)( 5,11)( 6,13)( 7,17)(14,19)(15,21),
 ( 7,15)( 8,18)( 9,25)(10,28)(12,34)(17,36)(29,41)(30,44)(31,49)(32,52)
  (37,54)(39,57)(43,60)(45,63)(47,66)(51,69)(58,72)(64,74)(70,76),
 ( 2,3)( 5,7)(10,12)(13,15)(18,20),( 7,16)( 9,34)(12,35)(15,36)(18,37)
  (22,38)(24,39)(28,40)(30,49)(32,58)(41,59)(44,63)(47,65)(50,69)(53,71)
  (56,75)(60,77)(62,78)(66,79)(68,80)(72,81)(74,82),
 ( 6,17)( 7,20)( 8,23)( 9,26)(10,29)(11,32)(12,35)(13,38)(14,41)(15,44),
 ( 1,6)( 2,9)( 3,11)( 4,14)( 5,16),( 1,6)( 3,10)( 4,12),
 ( 1,2)(10,11)(13,14)(18,19)(21,22),( 6,18)( 7,21)( 8,24)( 9,27)(10,30)
  (11,33)(12,36)(13,39)(14,42)(15,45),( 3,4)( 8,9)(12,13)(17,18)(22,23)
  (26,27),( 1,4)( 6,9)( 8,10),( 4,6)(10,11)(14,16)(20,21)(25,27)(30,31)
  (35,37)(40,42)(45,47)(50,52),( 3,5)( 6,7)( 8,9)(11,12),
 ( 4,7)( 9,12)(13,15)(17,20)(22,25)(26,28),
 ( 8,9)(12,14)(17,18)(21,23)(26,27)(30,32)(35,36)(39,41)(44,45)(48,50),
 ( 1,6)( 5,10)( 9,11),(14,15)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27)
  (28,29)(30,31)(32,33)(34,35)(36,37),( 2,4)( 7,8)(11,13)(16,17)(20,22),
 ( 1,4)( 3,10)( 6,12),( 6,8)(11,13)(17,18)(21,23)(27,28)(32,34)(37,38)
  (42,44)(47,49)(52,54),( 5,6)(11,12)(13,14)(15,16),
 ( 2,8)( 7,9)(10,12)(11,14),( 1,24)( 3,26)( 5,27)( 8,29)(10,30)(12,31)
  (14,33)(17,34)(19,36)(22,37),( 1,3)( 4,7)(10,12)(14,16),
 ( 4,8)(10,14)(15,18)(20,23)(25,29)(31,34)(35,38)(40,44)(46,49)(51,54),
 ( 5,6)( 9,10)(14,15)(18,19)(22,23)(25,26)(29,30),
 ( 5,7)( 8,10)(11,13)(16,18)(19,21),( 1,6)( 2,9)( 5,12),
 ( 5,6)( 8,9)(11,12)(16,17)(19,20),( 4,13)( 6,17)( 7,18)( 9,22)(11,23)
  (12,27),( 3,6)( 4,8)(10,13)(11,16),( 1,2)(12,13)(16,17)(20,21)(24,25)
  (26,27)(30,31)(32,33),( 2,5)( 3,11)( 6,12),
 ( 1,9)( 4,13)( 6,16)(10,18)(14,20),( 2,3)( 6,7)(11,12),
 ( 6,7)(10,12)(16,18)(21,23)(26,27)(31,33)(37,38)(41,43)(46,48)(52,54),
 ( 6,13)( 7,14)( 8,17)( 9,18)(10,21)(11,22),
 ( 6,7)(11,12)(15,16)(19,20)(23,24),( 3,4)(11,12)(13,14),(3,6)(4,7)(5,8),
 ( 1,7)( 3,10)( 5,11),( 5,6)( 8,9)(13,15)(18,20)(23,25),
 ( 3,4)( 7,9)(11,12)(15,17),( 4,7)( 9,13)(15,18)(20,23)(24,28)(30,34)
  (35,38)(40,43)(45,49)(51,54),( 1,3)( 4,9)( 7,12),
 ( 2,4)( 6,8)(10,12)(15,17)(20,22),( 3,5)( 7,9)(11,14)(16,18)(20,22)
  (24,27),( 3,4)( 9,10)(11,12)(13,14)(15,16),
 ( 8,22)(10,34)(14,35)(16,36)(20,37)(23,38)(26,39)(29,40)(31,41)(33,50)
  (43,60)(46,64)(49,66)(52,70)(55,72)(58,76)(61,77)(63,78)(67,79)(69,80)
  (73,81)(75,82),( 3,4)( 6,7)( 9,10)(11,12),
 ( 3,4)( 7,8)(11,12)(21,22)(25,26)(28,29)(33,34)(36,37)(39,40)(42,43),
 ( 4,5)( 9,10)(14,15)(17,18)(22,23),( 6,8)(11,12)(15,17)(20,21)(24,26)
  (29,30)(33,35)(38,39)(42,44)(47,48),( 5,6)( 8,9)(11,12)(14,15)(24,25)
  (26,27)(30,31)(32,33),( 3,4)( 8,9)(13,14)(16,17)(21,22),
 ( 3,5)( 7,9)(12,14)(16,18)(20,22)(25,27),
 ( 4,7)( 9,13)(14,18)(20,23)(24,28)(30,33)(35,38)(40,43)(45,48)(50,54),
 ( 2,3)(10,11)(13,14)(17,18)(20,21),( 3,9)( 4,10)( 6,11)( 7,12),
 ( 1,4)( 2,7)( 5,10)( 8,12),( 2,3)( 4,5)( 6,7)( 8,9)(12,14)(15,16),
 ( 4,9)( 8,10)(11,13)(12,14),( 6,8)(11,13)(16,18)(21,23)(26,28)(31,33)
  (34,36)(39,41)(43,44)(46,48)(51,53)(55,56)(58,60)(63,65)(67,68),
 ( 1,4)( 5,7)(10,12)(14,16),(2,3)(4,7),
 ( 7,14)( 8,16)( 9,17)(11,19)(12,20)(13,22),
 ( 7,17)( 8,20)( 9,24)(10,31)(11,34)(12,38)(13,42)(21,44)(23,46)(30,48)
  (32,50)(40,52),( 3,4)( 8,9)(11,12)(16,17),
 ( 1,2)(11,12)(15,16)(19,20)(24,25)(27,28)(30,31)(33,34)(38,39)(41,42),
 ( 6,7)(11,12)(13,14),( 1,3)( 6,12)( 7,13)( 8,14)( 9,15)(10,16)(11,17),
 ( 1,8)( 3,10)( 6,11),( 1,6)( 2,8)( 3,11)( 4,13)( 5,16),
 ( 1,2)( 5,6)( 9,10)(14,15)(19,20),( 3,5)( 4,9)(10,13)(11,14)(12,15),
 (13,15)(16,18)(23,25)(27,28)(33,34)(35,36)(40,41)(42,44)(48,49)(50,52)
  (53,54)(56,57)(59,60)(62,63)(65,66)(68,69)(71,72)(73,74)(75,76),
 ( 2,4)( 6,10)( 9,11),( 1,2)( 5,11)( 8,12),
 ( 1,13)( 2,17)( 3,22)( 4,26)( 5,31)( 6,35)( 7,40)( 8,44)( 9,49)(10,53),
 ( 2,5)( 9,10)(11,12)(13,14),( 4,6)( 9,10)(14,16)(20,21)(24,26)(29,31)
  (35,37)(40,41)(44,46)(50,52),( 2,4)( 7,9)(12,14)(16,18)(21,23)(26,28),
 ( 1,4)( 2,7)( 3,9)( 6,11),( 1,4)( 5,8)( 9,13)(14,18)(19,23),
 ( 1,3)( 9,11)(12,14)(16,18)(19,21),( 2,3)( 6,7)( 8,9)(10,11)(12,13)
  (14,15),( 5,8)( 9,10)(11,12)(13,14),( 5,6)(10,11)(12,13),
 ( 4,5)( 8,9)(12,13)(16,17)(20,21),(12,13)(15,16)(18,19)(20,21)(23,24)
  (26,27)(28,29)(31,32)(34,35)(36,37)(39,40)(42,43),
 ( 6,7)( 9,10)(12,13)(14,15)(17,18),( 1,3)( 5,9)( 7,11),
 ( 1,24)( 4,26)( 6,27)( 8,29)(10,30)(13,31)(15,33)(17,34)(19,36)(22,37),
 ( 3,5)( 7,10)(11,13)(15,18),( 3,5)( 8,10)(13,15)(16,18)(21,23),
 ( 1,4)( 2,10)( 3,12),( 2,4)(12,13)(14,15)(16,17),( 3,6)( 4,9)( 7,10),
 ( 3,9)( 5,12)( 8,15)(11,16)(14,17),( 4,7)( 9,11)(13,15)(17,20)(22,24)
  (26,28),( 3,4)( 5,7)( 9,10)(12,13),( 6,7)( 9,10)(11,13)(16,18)(21,23)
  ,( 1,2)( 5,6)( 7,8)( 9,10),( 1,24)( 3,26)( 5,27)( 7,28)(10,30)(12,31)
  (15,33)(17,34)(19,35)(21,37),( 1,5)( 3,11)( 7,12),
 ( 3,5)( 7,8)(11,13)(16,18)(20,21)(24,26),
 ( 4,6)( 8,10)(12,15)(17,19)(21,23)(25,28),
 ( 8,9)(13,14)(18,19)(23,24)(28,29)(32,33)(37,38)(42,43)(47,48)(52,53),
 ( 6,9)(10,11)(12,13),( 2,6)( 5,7)( 8,11)( 9,15),
 ( 6,9)(11,14)(15,18)(20,23)(24,27)(29,32)(33,36)(38,41)(42,45)(47,50),
 ( 3,4)( 5,6)( 7,8)( 9,10),( 5,6)( 8,9)(12,13)(15,16)(22,23)(24,25)
  (27,28)(31,32)(59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)
  (75,76)(77,78)(79,80)(81,82),( 6,8)( 9,10)(11,13)(14,15)(16,18),
 ( 3,4)( 6,8)(11,13)(16,17)(19,21)(24,26),
 ( 7,12)( 8,16)( 9,23)(10,26)(22,34)(27,36)(29,39)(30,41)(31,47)(32,49)
  (38,55)(42,58)(44,61)(46,64)(50,67)(52,70)(53,72)(59,74)(65,76),
 ( 4,6)( 9,11)(13,15)(17,19)(22,24)(26,28),
 ( 4,15)( 5,17)( 8,19)( 9,21)(10,23)(13,25),
 ( 6,8)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 2,3)(11,12)(13,14)(15,16),( 7,11)( 8,18)( 9,21)(10,26)(19,33)(24,35)
  (29,37)(30,40)(31,45)(32,48)(38,54)(42,57)(44,60)(46,63)(50,66)(52,69)
  (53,71)(59,73)(65,75),( 4,6)( 8,10)(12,14)(15,17)(20,22),
 ( 2,8)( 5,9)(10,16)(11,17)(12,18)(13,19)(14,20)(15,21),
 ( 5,7)( 9,10)(13,15)(18,20)(22,23)(26,28),
 ( 1,3)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,2)( 3,10)( 5,13)( 6,14)( 9,15)(12,16),( 1,4)( 5,10)( 6,11),
 ( 2,3)( 5,6)( 9,10)(13,14),( 3,5)( 8,10)(12,14)(17,19)(22,24)(26,28),
 ( 4,6)( 8,10)(12,14)(17,19)(21,23)(25,27),( 2,8)( 7,9)(10,13)(11,15),
 ( 3,5)( 8,9)(11,13)(16,18)(21,22)(24,26),
 ( 2,3)( 4,5)( 6,7)( 9,10)(12,13),( 2,11)( 5,14)( 8,15)(10,16)(13,17),
 ( 3,5)( 7,10)(12,14)(16,18)(20,23)(25,27),( 1,3)( 4,8)( 6,10),
 ( 5,6)(11,12)(13,14),( 4,5)( 9,10)(14,15)(18,19)(22,23),
 ( 3,5)(12,13)(14,15)(16,17),( 7,13)( 8,16)( 9,23)(10,27)(12,33)(17,35)
  (29,40)(30,42)(31,48)(32,50)(37,53)(39,56)(43,59)(45,62)(47,65)(51,68)
  (58,71)(64,73)(70,75),( 3,4)( 7,8)(11,12)(22,23)(27,28)(29,30)(33,34)
  (35,36),( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)
  (31,32)(34,35)(37,38)(39,40)(42,43)(44,45)(46,47)(49,50)(51,52)(54,55)
  (56,57)(58,59)(61,62)(63,64)(66,67)(68,69),( 5,6)( 7,8)( 9,10)(11,12),
 ( 1,4)( 5,9)(10,13)(11,14)(12,15),( 1,4)( 2,9)( 5,11),
 ( 4,5)( 7,9)(12,14)(15,17)(20,22),( 2,3)( 8,9)(14,15)(19,20)(25,26),
 ( 4,6)( 9,11)(14,15)(17,19)(22,24)(27,28),( 8,9)(11,12)(13,14)(16,17),
 ( 4,5)( 9,10)(14,15)(19,20)(24,25)(29,30)(36,37)(40,41)(44,45)(48,49)
  (52,53)(56,57)(60,61)(64,65)(68,69),( 2,6)( 3,9)( 5,11),
 ( 4,14)( 7,16)( 8,18)( 9,20)(12,22)(13,24),
 ( 1,7)( 4,10)( 5,11)( 6,12)( 8,13)( 9,14),
 ( 3,4)( 7,8)(12,13)(17,18)(21,22)(26,27),
 ( 5,6)( 8,9)(12,13)(16,17)(21,22)(26,27)(30,31),
 ( 2,4)( 5,8)( 9,11)(13,15),( 3,4)(11,12)(13,14)(16,17)(18,19)(21,22)
  (23,24),( 5,7)(10,11)(13,15)(18,20)(23,24)(26,28),
 ( 3,4)( 7,8)(12,13)(17,18)(22,23),( 3,13)( 6,17)( 7,18)( 8,22)(11,23)
  (12,27),( 1,2)( 4,12)( 7,13),( 4,8)( 5,9)( 6,10)( 7,13)(11,14)(12,15)
  ,( 5,6)( 9,10)(12,13)(14,15)(19,20),( 3,5)(11,12)(13,14),
 ( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)
  (34,35)(36,37)(38,39)(41,42)(43,44)(46,47)(48,49)(50,51)(53,54)(55,56)
  (58,59)(60,61)(62,63)(65,66)(67,68),( 1,2)(10,11)(13,14),
 ( 1,5)( 2,12)( 4,13),( 5,6)( 9,10)(12,13)(16,17)(20,21)(23,24),
 ( 4,6)( 9,11)(13,14)(17,19)(22,24)(26,27),
 ( 5,7)(10,12)(14,15)(18,20)(23,25)(27,28),
 ( 3,8)( 6,9)(10,16)(11,17)(12,18)(13,19)(14,20)(15,21),
 ( 1,8)( 2,10)( 5,12),( 5,9)(10,11)(12,13),
 ( 1,4)( 2,8)( 5,11)( 7,14)(10,15)(13,16),
 ( 3,5)( 8,10)(12,13)(16,18)(21,23)(25,26),
 ( 1,11)( 2,13)( 3,15)( 4,17)( 5,19)( 6,21),
 ( 2,11)( 5,13)(10,17)(12,18)(14,19)(15,20)(16,21),
 ( 3,11)( 4,12)( 5,13)( 6,14)( 7,15)( 8,16)( 9,17)(10,18),
 ( 2,11)( 5,12)( 7,13)(10,14),( 2,7)( 4,9)(11,13)(12,15),
 ( 6,7)( 9,10)(12,13),( 1,25)( 3,26)( 5,27)( 8,29)(10,30)(13,32)(15,33)
  (17,34)(19,36)(22,37),( 6,7)(10,11)(13,14)(17,18)(20,21),
 ( 1,6)( 4,10)( 8,11),( 4,7)( 9,11)(12,15)(17,20)(22,24)(25,28),
 ( 4,7)( 9,11)(12,16)(17,19)(21,24),( 2,6)( 5,7)( 8,12)( 9,16),
 ( 3,8)( 5,10)(11,14)(12,16),( 1,3)(10,12)(13,15)(18,20)(21,23),
 ( 5,19)( 8,20)(10,21)(11,23)(12,25)(13,26)(14,28)(15,30)(16,31)(17,33)
  (18,35),( 3,4)( 7,8)(12,13)(16,17)(21,22),
 ( 3,13)( 4,17)( 7,18)( 8,22)( 9,23)(12,27),
 ( 6,8)(11,13)(16,18)(21,23)(27,28)(31,33)(37,38)(42,44)(47,48)(52,54),
 ( 4,12)( 7,13)( 8,14)( 9,15)(10,16)(11,17),
 ( 3,4)( 7,9)(12,14)(16,17)(20,22)(25,27),( 1,5)( 3,9)( 4,11),
 ( 1,19)( 2,20)( 3,21)( 4,23)( 5,25)( 6,26)( 7,27)( 8,28)( 9,30)(10,32),
 ( 2,9)( 4,11)( 6,13)( 7,17)(14,19)(15,21),
 ( 5,7)(10,12)(13,14)(16,17)(18,19)(21,22)(23,24)(26,27),
 ( 1,14)( 2,19)( 3,23)( 4,28)( 5,32)( 6,37)( 7,41)( 8,46)( 9,50)(10,55),
 ( 2,3)(11,12)(13,14)(15,16)(17,18)(19,20)(26,27)(28,29)(30,31),
 ( 2,4)( 7,9)(11,13)(15,17)(20,22),( 2,4)( 6,9)( 7,11)( 8,13),
 ( 5,6)( 8,9)(12,13)(17,18)(21,22)(24,25)(27,28)(31,32)(34,35),
 ( 1,5)( 6,10)( 9,11),( 3,5)( 7,9)(12,14)(17,19)(21,23)(26,28),
 ( 1,7)( 2,10)( 3,13)( 4,15)( 5,18),( 1,4)( 3,11)( 6,12)( 8,13)( 9,14)
  (10,15),( 3,5)( 6,9)(11,14)(16,18)(19,22)(24,27),
 ( 6,7)( 9,10)(13,14)(18,19)(22,23)(25,26)(28,29)(32,33)(35,36),
 ( 1,3)( 2,7)( 5,9)( 8,11),( 1,5)( 4,10)( 7,11),
 ( 4,9)( 5,10)( 7,11)( 8,12),( 2,3)( 4,5)( 6,7)( 8,9)(13,14)(15,17),
 ( 1,5)( 2,8)( 4,11)( 7,14)( 9,15)(12,16),
 (11,13)(18,20)(21,23)(26,27)(33,34)(35,36)(37,39)(40,41)(45,47)(48,49)
  (54,55)(57,58)(60,61)(63,64)(66,67)(69,70)(71,72)(73,74)(75,76),
 ( 2,3)( 7,8)(11,12)(16,17)(21,22),( 3,7)( 5,9)(11,13)(12,15),
 ( 2,8)( 4,9)(10,13)(11,15),( 3,9)( 7,10)(11,13)(12,14),
 ( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)
  (34,35)(37,38)(39,40)(41,42)(44,45)(46,47)(49,50)(51,52)(53,54)(56,57)
  (58,59)(61,62)(63,64)(65,66)(68,69),( 7,13)( 8,18)( 9,21)(10,28)(15,34)
  (20,36)(29,41)(30,44)(31,49)(32,52)(37,54)(39,57)(43,60)(45,63)(47,66)
  (51,69)(58,72)(64,74)(70,76),( 4,6)(10,12)(15,17)(20,21)(25,27)(31,32)
  (35,37)(40,42)(46,48)(51,52),( 3,4)( 8,9)(13,14)(17,18)(22,23)(27,28),
 ( 1,8)( 3,11)( 5,14)( 6,17),( 2,6)( 3,11)( 5,13),
 ( 1,25)( 3,26)( 6,27)( 8,29)(11,30)(13,32)(15,33)(17,34)(20,36)(22,37),
 ( 5,11)( 6,14)( 7,16)( 8,19)( 9,21)(10,24),
 ( 1,7)( 2,9)( 3,12)( 4,15)( 5,17),( 1,19)( 2,20)( 3,22)( 4,24)( 5,25)
  ( 6,26)( 7,27)( 8,29)( 9,31)(10,32),( 6,7)(11,13)(16,18)(21,23)(26,28)
  (31,33)(37,38)(41,43)(47,48)(52,54),( 2,9)( 5,12)( 6,15)( 8,18)(11,21),
 ( 3,6)( 5,8)(10,14)(12,16),( 1,8)( 3,11)( 6,12),
 ( 1,2)( 6,7)( 9,10)(12,13),( 2,5)( 3,10)( 6,11),
 ( 4,5)(11,12)(13,14)(15,16),( 7,12)( 8,16)( 9,19)(10,26)(15,33)(20,35)
  (29,40)(30,42)(31,48)(32,50)(37,53)(39,56)(43,59)(45,62)(47,65)(51,68)
  (58,71)(64,73)(70,75),( 3,6)( 8,11)(12,14)(16,19)(21,24)(25,27),
 ( 1,8)( 2,10)( 3,13)( 4,15)( 5,18),( 6,7)(10,11)(12,13),
 ( 6,7)( 9,10)(14,15)(17,18)(20,21)(24,25)(28,29),
 ( 2,24)( 5,25)( 7,27)(10,28)(12,30)(14,31)(16,32)(19,34)(21,35)(23,37),
 ( 4,8)(10,13)(15,18)(20,23)(25,28)(30,34)(35,38)(40,44)(45,49)(51,54),
 ( 1,2)( 3,4)( 5,6)( 8,9)(12,13)(16,17)(20,21),( 1,2)( 5,10)( 8,12),
 ( 1,2)( 4,5)(10,11)(12,13)(14,15)(16,17)(18,19),( 3,5)( 8,9)(10,11),
 ( 4,6)(10,11)(15,17)(20,21)(25,27)(30,32)(35,37)(40,42)(45,47)(51,52),
 ( 4,5)( 9,10)(11,12),( 2,5)( 6,8)( 9,11)(13,15),
 ( 3,6)( 8,10)(12,14)(16,19)(21,23)(25,27),
 ( 5,6)( 8,9)(13,14)(16,17)(19,20)(23,24)(27,28),( 1,6)( 2,11)( 5,13),
 ( 1,6)( 2,11)( 5,12)( 8,13)( 9,14)(10,15),
 ( 4,8)(10,13)(14,18)(20,23)(25,28)(30,33)(35,38)(40,44)(45,48)(50,54),
 ( 1,8)( 2,11)( 5,12),( 1,10)( 2,12)( 3,14)( 4,16)( 5,18)( 6,20),
 ( 1,10)( 2,12)( 3,13)( 6,14)( 9,15)(11,16),
 ( 5,7)( 8,10)(13,15)(16,18)(19,21)(23,25)(27,29),( 1,2)( 4,9)( 6,10),
 ( 2,3)( 4,5)(15,16)(18,19)(21,22),( 2,7)( 4,9)(11,15)(13,17),
 ( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20)(21,22)(23,24),
 (4,6)(7,8),( 3,24)( 5,25)( 8,27)(10,28)(12,30)(14,31)(17,32)(19,34)(21,35)
  (23,37),( 4,5)( 9,10)(13,15)(18,20)(23,25),
 ( 7,22)( 9,34)(12,35)(15,36)(18,37)(21,38)(24,39)(27,40)(30,41)(32,50)
  (42,60)(45,64)(48,66)(51,70)(54,72)(57,76)(59,77)(62,78)(65,79)(68,80)
  (71,81)(74,82),( 2,3)( 5,9)( 6,11),( 1,4)( 2,8)( 3,10)( 6,12),
 ( 5,7)( 9,11)(12,14)(16,18)(20,22)(23,25),( 1,5)( 2,7)( 3,9)( 6,11),
 ( 2,6)( 4,10)( 8,11),( 9,11)(12,13)(15,16)(18,20)(21,22)(23,24),
 ( 2,24)( 5,25)( 7,27)( 9,28)(11,29)(14,31)(16,32)(19,34)(21,35)(23,36),
 ( 2,4)( 6,7)( 9,10),( 4,6)( 8,11)(13,15)(17,19)(21,24)(26,28),
 ( 1,7)( 4,10)( 6,13)( 8,16)(11,19),( 4,5)( 7,9)(12,14)(17,18)(20,22)
  (25,27),( 4,15)( 6,16)( 8,19)( 9,20)(11,23)(13,24),
 ( 1,9)( 2,12)( 3,13)( 4,16)( 5,17)( 7,20),( 3,4)( 6,7)(11,12)(15,16),
 ( 3,14)( 5,16)( 7,19)( 8,21)(10,24)(12,26),
 ( 6,16)( 7,19)( 8,22)( 9,25)(10,28)(11,31)(12,34)(13,37)(14,40)(15,43),
 ( 4,6)( 9,11)(15,17)(20,21)(24,26)(30,32)(35,37)(40,41)(45,47)(51,52),
 ( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
  (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36)(37,38)(39,40)
  (41,42)(43,44)(45,46)(47,48)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)
  (61,62)(63,64)(65,66)(67,68)(69,70)(71,72),
 ( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)
  (34,35)(37,38)(40,41)(42,43)(44,45)(46,47)(49,50)(52,53)(54,55)(56,57)
  (58,59)(61,62)(64,65)(66,67)(68,69),( 1,3)( 2,5)( 8,11)( 9,12)(10,13),
 ( 2,4)( 5,7)( 9,10)(13,14),( 3,8)( 5,10)( 6,12)( 7,16)(14,18)(15,20),
 ( 2,10)( 5,11)( 7,13)( 8,16)( 9,19),( 7,8)(11,12)(13,14)(17,18),
 ( 1,24)( 3,26)( 5,27)( 7,29)(10,30)(12,31)(14,33)(16,34)(19,36)(21,37),
 ( 2,3)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(26,27),
 ( 1,4)( 2,6)( 5,10)( 8,12),( 4,5)( 7,8)(10,11)(14,15),
 ( 1,5)( 4,11)( 6,13),( 1,5)( 2,8)( 4,10)( 6,12),
 ( 2,11)( 5,13)( 7,14)( 8,15)( 9,16),( 2,4)( 3,10)( 5,12),
 ( 3,6)( 7,9)(11,14)(16,19)(20,22)(24,27),
 ( 1,5)( 3,11)( 6,12)( 8,13)( 9,14)(10,15),
 ( 1,10)( 4,11)( 7,13)( 8,16)( 9,19),( 1,19)( 2,21)( 3,23)( 4,24)( 5,25)
  ( 6,26)( 7,28)( 8,30)( 9,31)(10,32),( 4,5)( 9,10)(13,14)(18,19)(23,24)
  (27,28),( 2,3)( 4,5)( 7,8)(10,11)(12,13),
 ( 5,6)(10,11)(15,16)(19,20)(23,24),( 1,5)( 2,8)( 3,10),
 ( 1,9)( 4,10)( 7,13)(11,16)(14,17),( 2,3)( 7,8)(11,12)(14,15),
 ( 2,24)( 5,26)( 7,27)( 9,29)(11,30)(14,31)(16,33)(18,34)(20,36)(23,37),
 ( 2,7)( 3,10)( 6,11),( 2,6)(10,11)(12,13),
 ( 6,7)(11,12)(15,16)(18,19)(21,22)(24,25)(27,28)(31,32)(34,35),
 ( 1,6)( 2,12)( 4,13),( 4,6)( 8,9)(12,14)(17,19)(21,22)(25,27),
 ( 6,7)(11,13)(17,18)(21,23)(26,28)(32,34)(37,38)(41,43)(47,49)(52,54),
 ( 1,6)( 2,9)( 3,11),( 2,4)( 6,8)(10,11)(13,15)(17,19),
 ( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)
  (35,36)(37,38)(40,41)(42,43)(44,45)(47,48)(49,50)(52,53)(54,55)(56,57)
  (59,60)(61,62)(64,65)(66,67)(68,69),( 3,7)( 4,10)( 5,11)( 6,12)( 8,13)
  ( 9,14),( 1,6)( 3,7)( 4,11)( 5,12),( 2,4)( 5,10)( 6,12),
 ( 3,4)( 8,9)(12,13),(15,16)(17,18)(19,20)(21,22)(23,24)(25,26)(27,28)
  (33,34)(35,36)(37,38)(39,40)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52)
  (53,54)(55,56),( 2,5)( 6,9)( 8,10),( 5,7)(10,11)(14,16)(18,19)(23,24)
  ,( 3,4)( 7,8)( 9,10)(11,12),( 5,6)( 9,10)(12,13)(16,17)(19,20),
 ( 3,4)( 6,7)( 8,9)(11,12),( 1,5)( 2,8)( 3,10)( 6,12),
 ( 1,6)( 2,12)( 5,14),( 1,2)( 4,12)( 6,13),
 ( 1,11)( 2,16)( 3,20)( 4,25)( 5,29)( 6,34)( 7,38)( 8,43)( 9,47)(10,52),
 ( 4,6)( 7,9)(10,12)(13,15),( 1,9)( 4,12)( 6,15)(10,16)(13,17),
 ( 2,3)( 5,11)( 7,12),( 3,13)( 4,17)( 6,18)( 8,22)( 9,23)(11,27),
 ( 6,7)( 9,10)(12,13)(17,18)(20,21),( 7,8)(10,11)(14,15)(18,19)(21,22)
  (25,26),( 1,5)( 2,11)( 3,13),( 1,24)( 4,25)( 6,27)( 8,28)(10,30)(13,31)
  (15,32)(17,34)(19,35)(22,37),( 7,8)( 9,10)(11,12)(13,14),
 ( 2,9)( 6,10)(11,13)(12,14),( 4,7)( 9,12)(14,18)(20,23)(24,27)(29,33)
  (35,38)(40,43)(44,48)(50,54),( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)
  (22,23)(25,26)(28,29)(31,32)(34,35)(36,37)(38,39)(41,42)(44,45)(46,47)
  (48,49)(50,51)(53,54)(56,57)(58,59)(60,61)(62,63)(65,66)(68,69),
 ( 1,6)( 2,9)( 3,11)( 4,14)( 5,17),(1,3)(4,5)(6,8),
 ( 1,3)( 4,11)( 7,12)( 8,13)( 9,14)(10,15),( 4,8)( 6,10)(11,14)(12,16),
 ( 1,3)( 4,11)( 5,13),( 1,2)( 9,10)(12,13)(16,17)(19,20),
 ( 6,7)(11,12)(16,17)(21,22)(26,27)(31,32)(34,35)(38,39)(42,43)(46,47)
  (50,51)(54,55)(58,59)(62,63)(66,67),( 4,5)( 9,10)(14,15)(19,20)(24,25)
  (29,30)(35,36)(39,40)(43,44)(47,48)(51,52)(55,56)(59,60)(63,64)(67,68),
 ( 2,5)( 6,10)( 7,12)( 8,14),( 1,6)( 2,12)( 4,14),
 ( 3,5)( 8,10)(13,14)(16,17)(18,19)(21,22)(23,24)(26,27),
 ( 3,10)( 6,11)( 7,13)( 8,16)( 9,19),( 2,24)( 5,25)( 7,27)( 9,28)(11,30)
  (14,31)(16,32)(18,34)(20,35)(23,37),( 1,10)( 4,11)( 7,14)( 8,17)( 9,20),
 ( 3,7)( 4,9)(10,14)(11,17),( 4,6)( 9,11)(14,16)(19,21)(24,26)(29,31)
  (35,36)(38,40)(43,45)(47,48)(50,52)(55,57)(59,60)(62,64)(67,69),
 ( 9,11)(13,14)(16,17)(18,20)(21,22)(23,24),
 ( 3,5)( 7,9)(11,13)(16,18)(20,22)(24,26),
 ( 4,8)( 7,9)(10,16)(11,17)(12,18)(13,19)(14,20)(15,21),
 ( 3,7)( 5,9)(10,15)(12,17),( 4,6)( 9,10)(12,14)(17,19)(22,23)(25,27),
 ( 3,6)( 8,10)(11,14)(16,19)(21,23)(24,27),
 ( 2,10)( 5,12)(11,17)(13,18)(14,19)(15,20)(16,21),
 ( 5,9)( 8,10)(11,13)(12,14),(3,4)(5,6)(7,9),
 ( 5,6)(11,12)(16,17)(22,23)(28,29),( 1,5)( 3,10)( 7,12),
 ( 5,6)(10,11)(14,15)(18,19)(21,22)(24,25)(28,29),
 ( 2,9)( 5,10)(11,13)(12,14),( 2,3)( 6,7)( 9,10)(12,13)(28,29)(30,31)
  (32,33)(34,35)(60,61)(62,63)(64,65),( 6,14)( 7,16)( 8,17)(10,19)(11,20)
  (12,22),( 2,3)( 5,10)( 7,11),( 4,6)( 9,11)(14,16)(20,21)(24,26)(30,31)
  (35,37)(40,41)(45,47)(50,52),( 2,8)( 4,10)( 6,12)( 7,16)(14,18)(15,20),
 ( 2,7)( 4,9)( 5,10),( 3,8)( 5,10)( 6,12),( 1,11)( 4,12)( 6,13)( 9,14),
 ( 1,2)( 4,5)(10,11)(12,13)(14,15)(16,17)(18,19)(20,21),
 ( 4,9)( 6,10)(11,13)(12,14),( 3,10)( 6,11)( 7,12)( 8,15)( 9,18),
 ( 4,5)(11,12)(13,14),( 4,6)( 9,10)(12,14)(17,18),
 ( 1,7)( 2,10)( 5,13)(11,16)(14,19),( 1,8)( 2,11)( 4,14)( 6,17),
 ( 9,11)(13,14)(15,17)(18,19)(20,21)(23,24),
 ( 1,5)( 6,10)(11,15)(16,19)(20,23),( 2,3)( 5,6)( 7,8)( 9,10),
 ( 7,8)( 9,10)(12,14)(15,16)(18,20)(21,23)(24,26)(27,29)(30,31)(32,33)
  (42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(59,61)(62,63)(65,67)(68,69)
  (71,73)(74,75),( 5,6)( 8,9)(11,12)(16,17)(19,20)(23,24)(27,28),
 ( 1,5)( 4,11)( 7,12),( 2,24)( 4,25)( 7,27)( 9,28)(11,29)(13,31)(16,32)
  (18,34)(21,35)(23,36),( 3,7)( 4,9)(10,13)(11,16),
 ( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33)(35,36)(39,40)(43,44)(47,48)
  (51,52)(55,56)(59,60)(63,64)(67,68),( 3,24)( 5,26)( 7,27)( 9,28)(12,30)
  (14,31)(17,33)(19,34)(21,35)(23,37),( 1,2)( 3,11)( 5,12),
 ( 1,7)( 3,11)( 5,12),( 1,3)( 4,11)( 7,13),( 2,4)(10,11)(14,15),
 ( 5,11)( 6,15)( 7,16)( 8,20)( 9,21)(10,25),( 2,6)( 3,10)( 7,11),
 ( 2,3)(11,12)(14,15)(19,20)(22,23),( 2,4)( 7,9)(12,14)(16,18)(20,22),
 ( 5,7)( 8,10)(11,13)(16,18)(19,21)(23,25)(27,29),( 1,2)( 4,10)( 8,12),
 ( 2,3)(11,12)(13,14),( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33)(34,35)
  (38,39)(42,43)(46,47)(50,51)(54,55)(58,59)(62,63)(66,67),
 ( 6,7)( 9,10)(12,13)(17,18)(20,21)(24,25)(28,29),
 ( 5,6)(10,11)(15,16)(20,21)(25,26)(30,31)(36,37)(40,41)(44,45)(48,49)
  (52,53)(56,57)(60,61)(64,65)(68,69),( 5,6)( 9,10)(12,13)(17,18)(20,21),
 ( 6,8)( 9,11)(13,15)(17,19)(20,22)(24,26),
 (12,13)(16,18)(19,21)(26,28)(33,34)(35,36)(40,41)(42,44)(48,49)(50,52)
  (53,54)(56,57)(59,60)(62,63)(65,66)(68,69)(71,72)(73,74)(75,76),
 ( 3,6)( 8,10)(11,14)(16,18),( 4,5)( 8,9)(12,13)(17,18)(21,22)(25,26)
  (29,30),( 1,5)( 3,12)( 7,13),( 5,7)( 8,10)(12,14)(17,19)(21,23)(24,26)
  (27,29)(31,33)(34,36),( 5,6)( 8,10)(13,15)(18,19)(21,23)(26,28),
 ( 5,8)( 7,9)(10,12)(11,14),( 1,6)( 4,11)( 8,13),
 ( 2,8)( 7,9)(10,13)(11,14),( 1,3)( 4,12)( 6,13),
 ( 2,9)( 4,12)( 5,13)( 6,16)( 7,17)( 8,20),( 4,6)(11,12)(13,14),
 ( 4,5)( 8,9)(13,14)(18,19)(22,23)(27,28),( 5,7)( 8,9)(10,12),
 ( 3,10)( 6,11)( 8,12)( 9,15)(13,16)(14,17),
 ( 8,16)(11,34)(14,35)(17,36)(20,37)(23,38)(26,39)(29,40)(31,49)(33,58)
  (42,59)(45,63)(48,65)(51,69)(54,71)(57,75)(61,77)(64,78)(67,79)(70,80)
  (73,81)(76,82),( 1,5)( 4,9)( 6,11),( 4,5)( 7,8)( 9,10)(12,13)(14,15)
  (17,18)(19,20)(22,23)(24,25)(26,27)(28,29)(30,31),
 ( 6,7)( 9,10)(11,12)(14,15)(17,18),(15,17)(19,20)(22,24)(29,31)(33,34)
  (36,38)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52),
 ( 1,8)( 2,11)( 3,13)( 4,16)( 5,18),( 1,3)( 2,6)( 5,9)( 7,11),
 ( 1,9)( 3,12)( 6,15)(11,18)(14,21),( 3,7)( 5,8)( 9,12)(10,13),
 ( 2,6)( 4,8)(11,14)(13,16),( 4,6)( 7,10)(12,15)(17,19)(20,23)(25,28),
 ( 3,4)( 9,10)(14,15)(16,17)(19,20),( 2,8)( 4,9)( 5,11),
 ( 4,5)( 8,9)(12,13)(16,17)(19,20)(23,24),
 ( 1,4)( 2,10)( 5,22)( 7,23)( 9,26)(13,27)(14,28)(16,31)(19,32)(20,35)
  (25,36)(30,37)(34,38),( 4,5)( 9,10)(14,15)(20,21)(25,26),
 ( 2,8)( 4,9)( 6,14)( 7,17)(11,19)(15,21),
 (12,14)(15,16)(17,18)(19,20)(21,22)(23,25)(34,36)(37,39)(40,42)(43,45)
  (46,48)(49,51)(52,54)(55,56)(57,58)(59,61)(62,63)(64,65)(66,68)(69,70)
  (71,72),( 2,9)( 5,11)( 7,13)( 8,15)(14,17)(16,18),
 ( 5,6)( 7,9)(10,12)(13,14)(16,17)(19,20)(21,23)(24,26)(27,28)(30,31)
  (33,34)(35,37)(38,40)(41,42)(44,45),( 2,5)( 9,10)(12,13),
 ( 2,9)( 5,11)( 8,14)(12,16)(15,17),( 4,6)( 8,10)(13,15)(17,18)(20,22)
  (24,25)(29,30),(12,14)(15,16)(17,18)(19,20)(21,22)(23,25)(34,36)(37,39)
  (40,42)(43,45)(46,48)(49,51)(52,53)(54,55)(56,58)(59,60)(61,62)(63,65)
  (66,67)(68,69)(70,72),( 2,3)( 6,9)( 8,11),
 ( 2,4)( 6,8)(14,15)(21,23)(25,26)(28,29)(32,33)(35,36)(39,40)(42,43),
 ( 1,5)( 4,10)( 7,13),( 1,2)(13,14)(16,18)(20,22)(24,26)(28,29)(35,36)
  (38,40)(42,44)(46,48)(50,51),( 1,8)( 2,12)( 6,18)(11,20)(13,23)(15,24)
  (17,27),( 4,6)( 7,8)(10,12)(15,17)(19,20)(22,24),
 ( 9,10)(14,15)(19,20)(24,25)(28,29)(33,34)(38,39)(43,44)(48,49)(52,53),
 ( 4,5)( 9,10)(11,12)(16,17)(21,22)(26,27)(31,32)(36,37),
 ( 6,7)(11,12)(16,17)(19,20)(22,23)(26,27)(29,30)(33,34)(36,37),
 ( 3,5)( 6,7)( 9,11)(13,14)(15,17),( 1,24)( 2,25)( 4,27)( 6,29)( 7,30)
  ( 8,31)(10,32)(11,34)(13,36)(14,37)(15,38)(17,39)(19,41)(20,43)(22,44),
 ( 1,3)( 2,10)( 4,23)( 9,26)(12,28)(14,29)(16,31)(18,33)(20,34)(22,35)
  (24,36)(25,37)(27,38)(30,39)(32,40),( 1,4)( 2,8)( 3,16)( 9,25)(19,27)
  (23,29)(26,30)(28,31),( 1,4)( 5,11)( 9,12),
 ( 1,8)( 3,10)( 6,14)( 7,17)(11,22)(16,25),
 ( 4,6)( 9,10)(14,15)(18,20)(23,25),(2,5)(3,8)(4,9),
 ( 6,7)(11,12)(15,16)(20,21)(23,24)(25,26)(29,30)(31,32),
 ( 2,3)( 6,7)(10,11)(14,15),( 2,8)( 4,11)( 5,15)( 7,19)(13,21)(18,24),
 ( 1,6)( 3,15)( 5,16)( 7,18)( 9,19)(11,20)(13,22)(14,23)(17,24)(21,25),
 ( 1,11)( 2,14)( 5,18)( 7,20)(12,22)(17,25),
 ( 1,9)( 2,21)( 3,22)( 6,25)( 8,26)(11,29)(13,30)(15,31)(17,34)(19,35)
  (23,36)(27,37)(32,38),( 1,9)( 4,12)( 5,13)( 7,16),
 (10,11)(15,16)(19,20)(23,24)(27,28)(32,33)(37,38)(41,42)(45,46)(49,50),
 ( 7,8)(12,13)(15,16)(19,20)(23,24),( 6,7)(11,12)(13,14)(18,19)(23,24),
 ( 5,6)(11,12)(16,17)(21,22)(26,27),( 4,5)( 8,9)(11,12)(15,16)(21,22)
  (26,27)(28,29),( 4,6)( 7,8)(10,12)(14,15)(16,18),
 ( 4,5)( 7,8)(11,12)(17,18)(21,22)(26,27)(28,29),
 ( 1,4)( 2,8)( 3,15)( 9,23)(18,26)(21,29)(24,31)(27,33),
 ( 3,4)( 7,9)(10,11)(14,16),( 2,24)( 4,25)( 5,26)( 7,28)( 9,30)(10,31)
  (12,32)(14,33)(15,35)(16,37)(18,38)(19,39)(21,40)(22,42)(23,44),
 ( 6,7)(10,11)(14,15)(17,18)(21,22)(24,25),
 ( 7,16)( 8,25)( 9,29)(11,33)(17,34)(31,39)(32,48)(35,53)(37,56)(38,57)
  (40,60)(41,61)(43,64)(44,65)(46,68)(47,69)(49,72)(50,73)(52,76)(59,77)
  (67,78)(75,79),( 2,24)( 4,25)( 5,27)( 7,29)( 9,30)(10,31)(11,32)(13,34)
  (14,36)(16,37)(17,38)(18,39)(20,41)(22,43)(23,44),
 ( 5,6)(10,11)(13,15)(16,17)(18,20)(21,22)(23,25)(26,27),
 ( 1,3)( 2,12)( 4,14)( 6,17)( 8,18)( 9,21)(11,22)(15,23)(19,24),
 ( 2,9)( 5,10)( 8,13)(12,16)(15,17),( 5,16)( 6,17)( 9,19)(10,20)(11,22)
  (14,23),( 7,9)(10,12)(13,15)(17,18)(19,21)(23,25)(27,28)(29,31)(33,34)
  (36,37)(39,41)(42,43)(45,47)(49,51)(52,53),
 ( 5,7)(11,13)(16,18)(20,21)(22,24)(25,27)(28,29)(31,32)(34,35),
 ( 2,8)( 4,15)( 5,22)( 9,24)(13,26)(17,28)(21,30)(25,31)(29,32),
 ( 1,24)( 3,26)( 5,27)( 6,28)( 8,30)( 9,31)(10,33)(12,34)(14,35)(15,37)
  (17,38)(19,40)(20,41)(21,42)(23,44),( 4,6)( 7,9)(11,13)(14,16)(18,20)
  (21,23),( 1,24)( 2,26)( 4,27)( 5,28)( 6,29)( 8,31)(10,33)(11,34)(13,35)
  (15,36)(16,38)(18,40)(20,41)(21,42)(22,43),
 ( 3,4)( 9,11)(13,14)(20,21)(23,25)(27,29)(31,33)(35,36)(42,43)(45,47)
  (49,51),( 1,6)( 2,8)( 3,11)( 4,14)( 5,16),
 ( 1,6)(12,19)(15,20)(16,29)(17,38)(18,47)(22,57)(24,61)(28,63)(30,67)
  (34,69)(36,73)(40,75)(42,79)(46,81)(48,85)(52,87)(54,91)(59,92)(62,93)
  (71,94)(74,95)(83,96)(86,97),( 2,3)(12,13)(16,17)(18,19)(20,21)(23,24),
 ( 5,6)(10,11)(14,15)(17,18)(23,24)(29,30)(33,34)(53,54)(58,59)(61,62)
  (64,65)(67,68)(70,71)(73,74)(76,77),( 7,16)( 8,20)( 9,28)(10,33)(17,34)
  (19,35)(23,36)(25,37)(31,39)(32,48)(40,58)(43,61)(46,64)(49,67)(52,70)
  (55,73)(57,74)(63,75)(69,76),( 3,4)( 7,8)(11,12)(16,17)(21,22),
 ( 1,4)( 5,10)( 9,12),( 1,2)( 4,5)( 7,8)( 9,10)(12,13),
 ( 3,8)( 6,11)(12,14)(13,15),( 3,8)( 5,9)( 6,10)( 7,13)(12,18)(16,20),
 ( 7,10)(11,13)(15,17)(19,21)(23,25)(26,29)(31,34)(35,37)(39,41)(43,45)
  (47,49)(50,53),( 8,9)(11,14)(15,16)(17,19)(22,23),(1,2)(3,4)(5,6)(8,9),
 ( 3,11)( 4,14)( 6,18)( 8,20)(10,21)(13,24)(15,25),( 4,5)( 6,7)( 9,10),
 ( 5,6)( 8,9)(11,12)(14,15)(18,19)(22,23)(25,26)(28,29)(31,32)(35,36)
  (39,40)(42,43)(45,46)(48,49)(52,53),( 4,5)( 7,8)(12,13)(17,18)(20,21),
 ( 7,8)(11,12)(16,17)(21,22)(26,27)(31,32)(35,36)(40,41)(45,46)(50,51),
 ( 6,20)( 7,21)( 8,22)(10,24)(11,25)(13,27)(14,28)(15,29)(16,31)(18,32),
 ( 4,5)( 7,8)(11,12)(14,15)(20,21)(25,26)(30,31)(35,36)(40,41)(45,46),
 ( 5,6)(10,11)(13,14)(15,17)(18,19)(20,22)(23,24)(25,27),
 ( 1,2)( 9,11)(16,17)(20,21)(23,24)(27,28)(30,31),
 ( 1,2)( 7,8)(12,13)(15,16)(18,19)(21,22),
 ( 2,3)( 9,11)(12,14)(17,19)(20,22),( 6,7)( 9,12)(13,15)(16,19)(20,23)
  (27,30)(31,34)(35,37)(38,41)(42,45)(49,52),( 1,6)( 2,11)( 7,12),
 ( 4,5)( 7,9)(14,15)(16,18)(21,23)(25,26)(27,28),
 ( 3,4)( 7,9)(12,14)(17,19)(22,23),( 1,10)( 4,15)( 6,18)( 7,21)( 9,23)
  (16,24),( 3,4)( 8,9)(13,14)(19,20)(24,25),
 ( 5,6)( 9,10)(15,16)(19,20)(22,23)(25,26)(27,28),
 ( 1,4)( 2,8)( 3,17)(10,25)(14,27)(24,29)(26,30)(28,31),
 ( 1,2)(11,12)(13,14)(18,19)(20,21),( 4,5)( 8,9)(12,13)(15,16)(19,20)
  (22,23),( 7,8)(11,12)(14,15)(18,19)(22,23)(27,28)(31,32)(35,36)(38,39)
  (42,43)(46,47)(51,52),( 4,5)( 9,10)(15,16)(19,20)(25,26),
 ( 1,2)(10,11)(16,18)(19,20)(23,24)(26,27)(30,31),
 ( 5,7)(10,12)(14,16)(18,21)(23,25),( 4,5)( 9,10)(14,15)(21,22)(24,25)
  (28,29)(31,32)(35,36)(38,39),( 2,12)( 3,13)( 4,15)( 5,16)( 6,17)( 9,18)
  (10,19),( 1,4)( 6,10)( 8,12),( 7,8)(10,11)(13,15)(17,19)(21,23)(25,26)
  (32,33)(35,37)(39,41)(43,45)(47,48),( 1,4)( 3,10)( 6,11),
 ( 4,20)( 5,23)( 7,26)( 8,29)(10,32)(11,35)(12,38)(14,41)(15,44)(17,47),
 ( 3,9)( 6,10)(11,15)(13,16),( 2,3)( 4,5)(11,12)(18,19),
 ( 4,7)( 8,11)(14,17)(18,21)(22,24)(25,26)(27,28),
 ( 2,3)( 9,12)(16,19)(20,23)(24,26)(27,30)(31,34)(38,41)(42,45)(46,48)
  (49,52),( 7,9)( 8,17)(12,34)(14,35)(18,36)(20,37)(30,41)(31,46)(32,50)
  (33,55)(39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(59,74)(61,75)(65,76)
  (67,77)(71,78)(73,79),( 5,6)( 7,8)( 9,10)(13,14)(15,16),
 ( 1,2)(12,13)(15,16)(18,19)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33),
 ( 8,10)(12,14)(15,18)(20,23)(24,26)(28,30)(32,34)(36,38)(39,42)(44,47)
  (48,50)(52,54),( 3,9)( 5,12)( 7,13)( 8,16),
 ( 4,19)( 6,22)( 7,25)( 9,28)(10,31)(11,34)(13,37)(14,40)(16,43)(17,46),
 ( 5,6)( 8,10)(14,16)(19,21)(22,24)(25,27)(28,29)(31,32)(34,35),
 ( 1,3)( 8,10)(11,12)(14,16)(17,18),( 4,8)(12,15)(16,19)(20,23)(24,25)
  (26,27)(31,32)(33,34)(38,39)(40,41),( 2,10)( 5,13)( 8,15)( 9,16)(12,17),
 ( 3,13)( 5,16)( 6,19)( 8,20)(10,21)(12,24)(14,25),
 ( 4,5)( 7,8)(11,12)(14,15)(18,19)(22,23),
 ( 5,12)( 6,13)( 7,15)( 8,16)( 9,18)(10,19),
 ( 5,6)(10,12)(14,16)(20,21)(24,26),( 1,2)( 8,9)(14,16)(21,22)(24,25)
  (28,29)(31,32),( 1,3)( 4,9)( 5,10),( 1,7)( 2,15)( 3,24)( 6,26)(11,27)
  (17,28)(21,29),( 4,5)( 8,9)(10,11)(14,15)(19,20)(26,27)(29,30),
 ( 9,10)(14,15)(19,20)(23,24)(27,28)(31,32)(36,37)(41,42)(45,46)(49,50),
 ( 7,14)( 8,19)(11,34)(16,35)(22,36)(26,37)(30,43)(31,45)(32,52)(33,54)
  (38,56)(41,59)(44,62)(47,65)(50,68)(53,71)(58,74)(60,75)(64,76)(66,77)
  (70,78)(72,79),( 1,3)( 5,7)( 9,11)(17,18)(26,27)(29,30)(33,34)(36,37)
  (40,41)(43,44),( 1,2)(12,13)(16,17)(20,21)(25,26)(27,28)(30,31)(32,33)
  (37,38)(39,40),( 4,5)( 7,9)(14,15)(19,20)(22,23)(26,27)(29,30),
 ( 1,4)( 6,10)( 8,14)( 9,15),( 6,7)(12,13)(16,17)(19,20)(23,24)(25,26)
  (27,28),( 4,6)( 8,9)(10,12)(13,15)(17,19)(20,22)(23,25)(28,30),
 ( 3,4)(10,11)(16,18)(19,20)(23,24)(26,27)(30,31),
 ( 1,5)( 2,9)( 3,17)(10,25)(20,27)(24,29)(26,30)(28,31),
 ( 2,10)( 7,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 4,6)( 8,10)(12,14)(20,21)(24,25)(28,29)(31,32)(35,36)(38,39)(42,43),
 ( 7,8)(11,12)(16,17)(20,21)(24,25)(27,28)(31,32)(35,36)(40,41)(44,45)
  (48,49)(51,52),( 6,7)( 9,10)(12,14)(17,19)(22,24),
 ( 2,8)( 4,10)( 5,12)( 6,14),( 4,5)( 8,10)(13,15)(18,20)(23,24),
 ( 1,4)( 6,10)( 7,11)( 8,12),( 3,9)( 5,11)( 8,16)(10,17)(12,18)(14,20)
  (19,22)(21,23),( 1,2)(14,15)(17,19)(21,23)(25,27)(29,30)(36,37)(39,41)
  (43,45)(47,49)(51,52),( 1,8)( 2,13)( 3,21)( 5,26)(12,27)(17,28)(23,29),
 (13,14)(16,17)(18,19)(21,22)(23,24)(25,26)(27,28)(30,31)(32,33)(35,36)
  (37,38)(39,40),( 4,5)( 9,10)(13,14)(18,19),
 ( 4,5)( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33),
 ( 3,4)( 8,9)(11,12)(16,17)(20,21),( 1,7)( 2,19)( 3,23)( 6,25)( 9,26)
  (18,28)(27,30)(29,31),( 3,9)( 4,11)( 7,13)( 8,15),
 ( 2,3)( 5,6)(11,12)(15,16),( 2,6)( 5,7)( 9,14)(11,17),
 ( 1,24)( 2,26)( 4,28)( 5,29)( 7,30)( 8,31)( 9,33)(11,35)(13,36)(14,37)
  (16,38)(18,40)(19,42)(21,43)(23,44),( 3,4)( 7,8)(11,12)(13,14)(17,18),
 ( 7,11)( 8,19)( 9,28)(14,33)(20,34)(31,39)(32,48)(35,53)(37,56)(38,57)
  (40,60)(41,61)(43,64)(44,65)(46,68)(47,69)(49,72)(50,73)(52,76)(59,77)
  (67,78)(75,79),( 6,7)( 9,10)(11,12)(15,16)(21,22)(24,25),
 ( 2,24)( 3,26)( 5,27)( 6,28)( 7,29)( 9,31)(11,33)(12,34)(14,35)(16,36)
  (17,38)(19,40)(21,41)(22,42)(23,43),( 2,3)( 7,8)(14,15)(19,20)(24,25)
  (29,30)(34,35)(39,40),( 9,10)(11,13)(14,16)(18,19)(20,22)(23,24)(26,28)
  (29,31)(32,33)(35,36)(38,40)(41,42)(44,45)(46,48)(50,51),
 ( 1,2)( 3,10)( 6,12)( 7,13)( 9,14)(11,15),
 ( 3,6)( 7,11)(13,15)(17,21)(22,25),( 1,2)( 3,10)( 6,12),(2,6)(3,8)(5,9),
 (10,11)(13,14)(15,16)(19,20)(21,22)(25,26)(28,29)(41,42)(44,45)(47,48)
  (50,51)(53,54)(56,57)(59,60)(63,64)(65,66)(69,70)(71,72)(75,76),
 (10,11)(12,14)(16,17)(19,20)(22,24)(25,26)(28,29)(30,32)(33,34)(36,38)
  (39,41)(42,44)(46,47)(48,50)(51,52),( 3,9)( 6,11)( 7,13)( 8,16)(15,19)
  (18,21),( 2,24)( 3,26)( 4,28)( 6,29)( 7,30)( 9,31)(10,33)(11,35)(13,36)
  (15,37)(16,38)(18,40)(20,42)(21,43)(23,44),
 ( 3,9)( 6,10)( 7,11)( 8,13)(12,18)(14,20),( 3,10)( 4,12)( 7,14)( 8,16),
 ( 8,10)(11,13)(15,17)(18,20)(22,23)(25,26)(27,29)(30,32)(34,35)(37,39)
  (41,42)(44,46)(47,49)(50,51)(53,54),( 2,9)( 5,11)( 7,14)( 8,16)(13,17)
  (15,18),( 8,9)(10,12)(14,16)(18,19)(20,22)(24,25)(27,28)(30,32)(33,34)
  (36,38)(40,42)(43,44)(46,48)(49,51)(52,54),
 ( 8,9)(10,12)(14,16)(17,18)(20,22),( 9,10)(11,13)(15,16)(18,19)(21,23)
  (24,25)(27,28)(29,31)(32,33)(35,37)(38,40)(41,43)(45,46)(47,49)(50,51),
 (12,13)(14,15)(16,17)(18,20)(21,22)(23,24)(31,32)(33,34)(35,36)(37,39)
  (40,41)(42,43)(44,45)(46,48)(49,51)(52,54)(57,59)(60,62)(63,65)(68,70),
 ( 2,4)( 6,8)(10,12)(18,19)(26,27)(29,30)(33,34)(36,37)(40,41)(43,44),
 ( 2,3)( 6,7)(11,12)(16,17)(19,20)(22,23),( 1,2)( 7,8)(10,11)(14,15),
 ( 1,2)(13,14)(16,17)(19,20)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 9,10)(11,13)(14,15)(17,18)(19,21)(23,24)(26,27)(29,31)(32,33)(35,36)
  (37,39)(40,41)(43,45)(46,48)(49,51),( 4,7)( 8,11)(12,15)(16,17)(21,22),
 ( 4,6)( 9,11)(14,16)(19,20)(24,25),( 2,3)( 5,6)(10,11)(15,16)(19,20)
  (23,24),( 2,12)( 4,17)( 6,19)( 9,20)(10,23)(13,24)(15,27),
 ( 4,6)( 7,9)(10,12)(14,15)(17,18),( 4,6)( 8,10)(11,12)(14,16)(19,21)
  (23,24),( 1,4)( 7,8)( 9,10)(13,14),( 1,5)( 2,13)( 3,22)( 6,25)(16,27)
  (20,29)(26,30)(28,31),( 2,9)( 7,10)(12,15)(14,16),
 ( 3,4)( 8,9)(13,14)(18,19)(24,25),( 9,11)(12,13)(15,17)(18,20)(21,22)
  (24,25)(27,29)(30,31)(33,34)(35,37)(39,40)(42,43)(44,46)(47,49)(51,52),
 ( 1,9)( 2,13)( 3,19)( 5,26)(14,27)(17,28)(25,29),
 ( 2,9)( 5,12)( 7,15)(11,16)(14,17),( 2,9)( 4,14)( 5,16)( 7,22)(13,23)
  (20,24),( 1,5)( 2,7)( 4,11)( 8,13)(10,14),
 ( 3,7)( 6,10)(12,14)(13,15),( 2,14)( 4,21)( 7,22)( 8,23)(12,25)(16,27)
  (20,29)(24,31)(28,32),( 2,9)( 4,13)( 5,16)(12,22)(14,23)(17,26)(19,27),
 ( 1,24)( 3,25)( 5,26)( 6,28)( 8,30)(10,31)(11,32)(13,33)(15,35)(16,37)
  (17,38)(19,39)(20,40)(22,42)(23,44),( 4,7)( 9,12)(13,16)(18,21)(22,24)
  (25,27)(28,30)(31,33),( 1,4)( 5,8)( 9,12)(19,20)(24,25),
 ( 1,4)( 8,11)(12,15)(17,18)(22,23),( 3,4)( 7,8)(13,14)(18,19)(23,24),
 ( 1,4)( 2,13)( 3,21)( 7,26)(11,27)(17,28)(22,29),
 ( 2,24)( 3,25)( 5,27)( 7,28)( 8,30)( 9,31)(11,32)(12,34)(14,35)(16,37)
  (17,38)(19,39)(20,41)(21,42)(23,44),(10,11)(14,15)(18,19)(21,22)(25,26)
  (29,30)(34,35)(38,39)(42,43)(45,46)(49,50)(53,54),
 ( 1,2)( 4,10)( 5,11)( 7,12)( 9,13),(11,12)(14,15)(17,18)(20,21)(22,23)
  (25,26)(27,28)(37,38)(39,40)(43,44)(45,46)(47,48)(51,52)(54,55)(57,58)
  (60,61)(63,64)(66,67)(69,70),( 1,4)( 2,12)( 3,17)( 6,24)(11,26)(16,28)
  (21,30),( 6,7)( 9,10)(13,14)(19,20)(25,26)(28,29)(31,32)(34,35),
 ( 4,5)( 8,10)(13,14)(18,20)(22,24),( 1,6)( 3,11)( 5,13),
 ( 2,9)( 5,10)( 7,12)( 8,14)(11,17)(13,19),
 ( 6,7)(11,12)(16,17)(19,20)(23,24)(26,27)(30,31)(33,34)(37,38),
 ( 3,4)(10,12)(14,16)(18,20)(25,26)(29,30)(32,33)(36,37)(39,40)(43,44),
 ( 4,5)( 8,9)(11,12)(15,16)(20,21)(25,26)(30,31)(35,36)(40,41)(45,46),
 ( 1,4)(10,12)(13,15)(17,19)(20,22)(23,25),
 ( 3,8)( 9,12)(13,18)(19,23)(24,28),( 7,13)( 8,22)( 9,26)(14,33)(29,34)
  (31,39)(32,48)(35,53)(37,56)(38,57)(40,60)(41,61)(43,64)(44,65)(46,68)
  (47,69)(49,72)(50,73)(52,76)(59,77)(67,78)(75,79),
 ( 9,10)(13,14)(17,18)(20,21)(24,25)(28,29)(33,34)(37,38)(41,42)(44,45)
  (48,49)(52,53),( 1,2)( 9,11)(16,17)(20,21)(24,25)(27,28)(31,32),
 ( 2,7)( 5,8)( 9,12)(10,15),( 2,3)( 7,8)(11,12)(16,17),
 (13,14)(15,16)(17,18)(20,21)(22,23)(25,26)(27,28)(29,30)(31,32)(34,35)
  (36,37)(39,40),( 3,5)( 6,8)( 9,11)(13,14)(16,17),
 ( 9,10)(11,12)(14,17)(18,19)(20,22),( 2,3)( 5,6)( 8,10),
 ( 3,13)( 4,17)( 6,19)( 8,20)(10,23)(12,24)(14,27),
 ( 7,18)( 8,26)( 9,30)(17,33)(23,34)(31,39)(32,48)(35,53)(37,56)(38,57)
  (40,60)(41,61)(43,64)(44,65)(46,68)(47,69)(49,72)(50,73)(52,76)(54,77)
  (62,78)(70,79),( 1,4)( 2,7)( 3,9)( 5,11),
 ( 2,3)( 7,8)(12,13)(16,17)(20,21),( 2,8)( 4,16)( 6,20)(10,22)(15,25)
  (17,29)(21,32)(24,35)(28,36)(31,37)(34,38),
 ( 6,7)(10,12)(15,17)(20,22)(25,26),( 5,7)( 8,9)(11,12),
 ( 1,2)( 4,6)( 8,10),( 1,2)(10,11)(13,14)(17,18)(20,21)(23,24),
 ( 4,6)( 7,9)(10,11)(13,15)(16,17),( 1,6)( 5,11)(10,12),
 ( 7,8)(10,13)(15,16)(17,19)(22,24),( 2,3)( 9,10)(14,15)(19,20)(24,25)
  (29,30)(34,35),( 1,8)( 3,16)( 7,20)( 9,24)(14,27)(18,29)(21,30)(25,31)
  (28,34)(32,37)(35,38),( 1,8)( 3,14)( 4,16)( 6,21)(10,23)(17,24),
 ( 4,5)( 7,8)(11,12)(15,16)(20,21)(26,27)(31,32),
 ( 3,5)( 6,12)( 7,13)( 8,14)( 9,15),( 9,10)(11,13)(14,15)(17,19)(20,22)
  (23,25)(27,28)(29,31)(32,33)(35,36)(37,39)(41,42)(44,45)(47,49)(50,51),
 ( 3,4)( 9,10)(16,17)(19,21)(23,25)(27,29)(31,32)(38,39)(41,43)(45,47)
  (49,51),( 4,6)( 7,9)(11,13)(14,16)(18,20)(21,23)(25,27)(28,30)(32,34)
  (35,37)(39,41)(42,44),( 4,5)( 7,9)(14,16)(18,20)(22,23)(24,25)(26,27)
  (28,29),( 2,9)( 4,11)( 7,13)(10,14)(12,15),
 ( 7,14)( 8,18)( 9,27)(11,33)(26,34)(31,39)(32,48)(35,53)(37,56)(38,57)
  (40,60)(41,61)(43,64)(44,65)(46,68)(47,69)(49,72)(50,73)(52,76)(54,77)
  (62,78)(70,79),( 1,8)( 2,13)( 3,21)( 4,25)(10,27)(20,29)(26,30)(28,31),
 ( 5,7)(12,13)(14,16)(19,21)(23,24)(25,26)(27,28),
 ( 5,6)(10,11)(12,13)(15,16)(19,20),( 6,7)(12,13)(17,18)(22,23)(27,28),
 ( 6,7)( 8,10)(11,12)(13,15)(16,18),( 6,7)(11,12)(14,15)(18,19)(22,23),
 ( 3,6)( 4,8)(13,16)(15,17)(18,20)(19,21),
 ( 3,4)(10,12)(14,15)(21,22)(24,26)(28,30)(32,34)(36,37)(43,44)(46,48)
  (50,52),( 4,6)(11,12)(13,15)(18,20)(22,23)(25,26)(27,28),
 ( 1,7)( 2,10)( 4,11)( 6,12)( 9,13),( 1,3)( 6,8)(13,15)(18,20)(23,25)
  (28,30)(33,35)(38,40),( 2,3)( 6,7)(11,12)(16,17)(21,22),
 ( 4,5)( 7,8)(12,13)(16,18)(21,23)(26,28)(31,33)(36,38)(41,43),
 ( 4,7)(10,13)(14,17)(18,20)(21,24)(25,26)(27,28),
 ( 1,9)( 2,12)( 4,15)( 7,20)(14,23)(21,24),
 ( 2,11)( 4,18)( 5,22)( 9,24)(13,26)(17,28)(21,30)(23,31)(27,32),
 ( 6,8)( 9,11)(12,13)(14,16)(17,18),( 9,39)(11,41)(13,42)(15,44)(17,45)
  (19,46)(21,48)(23,49)(25,51)(27,52)(29,53)(31,55)(33,56)(35,58)(37,59),
 ( 1,11)( 3,19)( 6,20)(10,21)(12,25)(17,28)(22,30)(26,31)(29,34)(32,37)
  (35,38),( 2,3)( 7,8)(12,13)(15,16)(18,19)(21,22),
 ( 4,5)( 9,11)(13,15)(17,18)(24,25)(27,29)(31,33)(35,37)(39,40)(46,47)
  (49,51),(10,11)(13,15)(16,17)(19,20)(21,23)(25,26)(28,29)(30,32)(33,35)
  (37,38)(39,41)(42,43)(45,47)(48,50)(51,52),
 ( 1,24)( 2,26)( 3,28)( 5,29)( 6,30)( 8,31)( 9,33)(10,35)(12,36)(14,37)
  (15,38)(17,40)(19,42)(20,43)(22,44),( 5,6)( 9,11)(13,15)(17,18)(24,25)
  (27,29)(31,33)(35,37)(39,40)(46,47)(49,51),
 ( 2,12)( 3,13)( 4,16)( 5,17)( 8,19)( 9,21)(10,22)(14,23)(18,24)(20,25),
 ( 3,6)( 7,12)(13,17)(18,22)(23,28),( 1,17)( 3,19)( 4,20)( 6,22)( 7,23)
  ( 9,24)(10,26)(12,27)(13,29)(16,30),( 4,5)( 7,8)(13,15)(19,20)(23,24)
  (26,27)(30,31),( 1,8)( 3,11)( 7,12),( 5,7)(10,12)(13,14)(19,21)(23,24)
  (26,27)(28,29),(10,11)(13,14)(15,17)(18,20)(22,23)(24,26)(27,28)(30,32)
  (33,35)(36,37)(39,40)(42,44)(45,46)(48,49)(50,52),
 ( 4,5)( 9,10)(14,15)(20,21)(23,24)(27,28)(30,31)(34,35)(37,38),
 ( 4,5)( 9,10)(14,15)(20,21)(24,25),( 7,11)( 8,15)( 9,24)(23,33)(29,34)
  (31,39)(32,48)(35,53)(37,56)(38,57)(40,60)(41,61)(43,64)(44,65)(46,68)
  (47,69)(49,72)(50,73)(52,76)(54,77)(62,78)(70,79),
 ( 1,3)( 2,9)( 4,11)( 7,13)(10,15)(12,17),
 ( 3,4)( 6,8)(13,14)(20,21)(24,25)(27,28)(31,32),
 ( 1,2)(11,12)(14,15)(16,17)(19,20),( 1,9)( 2,14)( 3,22)( 6,24)(11,26)
  (16,28)(21,30),( 1,6)( 3,13)( 5,14),( 1,21)( 2,22)( 3,23)( 4,25)( 5,27)
  ( 6,28)( 7,29)( 8,30)( 9,32)(18,33)(19,34),
 ( 8,9)(11,13)(14,16)(17,18)(20,21)(23,25)(26,28)(30,32)(33,35)(37,38)
  (40,41)(42,44)(45,47)(49,50)(52,54),( 5,6)( 9,11)(14,15)(19,21)(23,25),
 ( 1,2)(11,12)(14,15)(18,19)(21,22)(24,25),
 ( 8,10)(11,13)(14,15)(17,18)(20,22)(23,25)(27,29)(30,32)(34,35)(37,38)
  (39,41)(42,44)(46,47)(49,51)(53,54),( 4,5)(10,11)(15,16)(20,21)(25,26),
 ( 6,8)(10,12)(14,17)(19,21)(23,25),( 1,2)(11,12)(14,15),
 ( 2,5)( 4,13)( 7,21)(12,24)(14,28)(18,29)(20,32)(23,35)(27,36)(31,37)
  (34,38),( 2,6)( 9,19)(15,20)(16,29)(17,38)(18,47)(22,57)(24,61)(28,63)
  (30,67)(34,69)(36,73)(40,75)(42,79)(46,81)(48,85)(52,87)(54,91)(59,92)
  (62,93)(71,94)(74,95)(83,96)(86,97),( 1,2)(11,12)(15,16)(18,19)(20,21)
  (23,24),( 7,13)( 8,18)( 9,22)(10,33)(15,34)(16,35)(21,36)(25,37)(31,46)
  (32,55)(39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(61,74)(67,75)(73,76),
 ( 6,15)( 7,16)( 9,18)(10,19)(11,21)(13,22),
 ( 1,9)( 3,13)( 4,17)( 6,20)(10,23)(15,26),
 ( 8,9)(12,13)(15,16)(18,19)(21,22)(27,28)(33,34)(36,37),
 ( 2,8)( 4,10)( 6,15)(12,20)(14,23)(17,24)(18,27),( 1,2)( 7,8)(10,11),
 ( 2,7)( 4,8)( 6,10),( 1,11)( 2,19)( 3,24)( 5,26)( 9,27)(15,28)(20,29),
 ( 1,3)( 2,6)( 5,9)(10,13)(12,14),( 9,10)(12,13)(15,17)(18,19)(21,22)
  (23,25)(26,27)(29,31)(32,34)(35,37)(39,40)(41,43)(44,45)(47,48)(49,51),
 ( 1,2)( 9,10)(15,17)(21,22)(24,25)(28,29)(31,32),
 ( 1,5)( 2,13)( 3,18)( 6,25)(11,27)(16,29)(21,31),
 ( 2,8)( 5,11)(12,14)(13,15),( 4,7)( 8,12)(13,16)(18,21)(23,26),
 ( 1,9)( 3,12)( 4,15)( 6,16)( 8,19)(11,20)(14,21)(18,22),
 ( 1,5)( 2,7)( 3,9)(10,13)(11,15),( 6,7)(10,12)(15,16)(20,22)(24,26),
 ( 4,7)( 9,12)(13,17)(18,21)(23,26),( 1,11)( 2,18)( 3,22)( 5,24)( 8,27)
  (17,30)(26,32)(29,34),( 5,6)( 9,10)(15,16)(20,21)(25,26),
 (1,2)(3,4)(5,6)(7,9),( 6,7)(11,12)(17,18)(21,22)(27,28),
 ( 1,3)( 2,5)( 6,9)(10,13)(12,14),( 3,7)( 6,8)( 9,12)(10,15),
 ( 3,7)( 6,8)( 9,13)(10,16),( 1,9)( 3,12)( 5,13)( 6,16)( 8,19)(10,20)
  (14,21)(17,22),( 1,20)( 2,21)( 3,22)( 4,24)( 5,26)( 6,27)( 7,28)( 8,29)
  ( 9,32)(18,33)(19,34),( 1,3)( 2,5)( 7,10)( 8,12)( 9,14),
 ( 1,20)( 2,21)( 3,22)( 4,23)( 5,25)( 6,27)( 7,28)( 8,29)( 9,30)(10,32),
 ( 1,9)( 3,12)( 6,17)( 7,21)(11,23)(18,24),
 ( 2,10)( 4,11)( 6,14)( 8,17)(12,18)(15,19),
 ( 6,7)( 9,10)(12,13)(16,17)(21,22)(24,25),
 ( 3,5)( 7,9)(13,14)(17,19)(22,23),( 1,4)( 2,13)( 6,24)( 9,26)(12,28)
  (16,30)(19,32)(21,34),( 5,6)(10,11)(14,15)(17,18)(23,24)(29,30)(33,34)
  (54,55)(59,60)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 5,6)( 8,9)(16,17)(19,20)(23,24)(25,26)(29,30)(31,32),
 ( 1,24)( 3,26)( 4,27)( 5,28)( 7,30)( 9,31)(10,33)(12,34)(14,35)(15,37)
  (16,38)(18,40)(19,41)(21,42)(23,44),( 1,2)(10,11)(16,18)(20,21)(24,25)
  (27,28)(31,32),( 7,10)( 8,15)( 9,19)(12,33)(13,34)(18,35)(22,36)(28,37)
  (31,46)(32,55)(39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(61,74)(67,75)
  (73,76),( 4,5)(10,11)(15,16)(20,21)(26,27),
 ( 4,5)( 8,9)(12,13)(17,18)(20,21)(24,25)(29,30),( 1,5)( 3,11)( 6,13),
 (2,5)(6,7),( 1,3)( 4,11)( 8,12),(2,4)(6,7)(8,9),
 ( 1,2)(10,11)(13,14)(15,16)(18,19),( 1,2)( 8,9)(13,14)(18,20)(23,25)
  (28,30)(33,35)(38,40)(43,45),( 4,5)( 7,8)(11,12)(14,15)(18,19)(21,22)
  (24,25),( 2,11)( 4,19)( 6,20)(10,21)(12,25)(17,28)(22,30)(26,31)(29,34)
  (32,37)(35,38),( 3,4)( 8,9)(11,12)(14,15)(17,18),
 ( 1,3)(10,12)(14,16),( 7,18)( 8,22)( 9,27)(15,33)(19,34)(24,35)(25,36)
  (30,37)(31,38)(32,47)(39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(56,74)
  (62,75)(68,76),( 4,5)( 8,9)(10,11)(14,15)(17,18),
 ( 3,6)(10,11)(12,13),( 4,5)( 7,8)(11,12)(14,15)(21,22)(26,27)(31,32)
  (36,37)(41,42)(46,47),( 1,6)( 2,18)( 3,23)( 7,26)(16,28)(19,29)(25,30)
  (27,31),( 4,5)(10,11)(14,15)(17,18)(21,22)(25,26)(27,28),
 ( 1,5)( 2,10)( 3,16)( 9,25)(18,28)(21,30)(24,32)(27,34),
 ( 3,4)( 8,9)(12,13)(14,15),( 6,7)( 9,10)(13,14)(16,17)(20,21)(24,25),
 ( 1,8)( 3,15)( 5,22)( 9,24)(13,26)(17,28)(21,30)(25,31)(29,32),
 (10,11)(15,16)(20,21)(24,25)(29,30)(34,35)(39,40)(44,45)(48,49)(53,54),
 ( 1,10)( 2,11)( 6,12),( 3,4)( 8,9)(12,13)(17,18)(20,21),
 ( 6,7)(12,13)(16,17)(20,21)(22,23)(24,25)(28,29),
 ( 1,6)( 2,15)( 3,23)( 8,25)(12,27)(22,29)(26,30)(28,31),
 (10,11)(12,14)(15,16)(18,20)(21,23)(24,26)(28,29)(30,32)(33,34)(36,37)
  (38,40)(42,43)(45,46)(48,50)(51,52),( 4,5)( 8,9)(11,12)(13,14)(17,18),
 ( 1,2)( 6,11)(10,12),( 8,9)(10,12)(13,15)(17,18)(20,22)(24,25)(27,29)
  (30,32)(33,34)(36,37)(39,41)(42,44)(46,48)(49,51)(53,54),
 (11,12)(15,16)(19,20)(23,24)(28,29)(33,34)(37,38)(41,42)(45,46)(50,51),
 ( 7,8)(10,12)(13,14)(16,18)(20,22)(23,24)(26,28)(29,31)(32,34)(36,37)
  (38,40)(42,44)(46,47)(48,50)(52,53),( 1,4)( 2,9)( 3,17)( 8,26)(13,27)
  (19,28)(23,29),( 6,7)( 9,10)(13,14)(19,20)(23,24)(26,27)(28,29),
 ( 4,5)(10,11)(14,15)(20,21)(25,26),(1,2)(4,5)(6,7)(8,9),
 ( 8,9)(11,13)(14,15)(17,19)(21,23)(24,25)(27,29)(30,32)(33,35)(37,38)
  (39,41)(43,45)(47,48)(49,51)(53,54),( 2,4)( 6,8)(14,15)(21,23)(26,27)
  (29,30)(33,34)(36,37)(40,41)(43,44),( 4,7)( 8,11)(12,15)(16,19)(21,23),
 ( 1,20)( 2,23)( 3,24)( 4,25)( 5,26)( 6,28)( 7,30)( 8,31)( 9,32)(18,33)
  (19,34),( 4,5)( 8,10)(15,16)(19,20)(22,23)(26,27)(29,30),
 ( 7,9)(10,12)(14,15)(17,18)(19,21)(22,24)(26,27)(29,31)(33,34)(36,38)
  (39,41)(42,43)(45,46)(48,50)(51,53),( 1,24)( 3,26)( 4,27)( 6,28)( 7,29)
  ( 8,31)(10,33)(12,34)(13,35)(15,36)(17,38)(18,40)(20,41)(22,42)(23,43),
 ( 1,11)( 2,13)( 4,17)( 7,22)(14,23)(21,24),
 ( 1,6)( 2,12)( 3,22)( 7,23)( 9,26)(11,27)(15,28)(16,31)(19,32)(21,35)
  (24,36)(29,37)(33,38),( 4,6)(10,12)(15,17)(19,20)(22,24)(25,27)(28,29)
  (31,32)(34,35),( 7,8)(11,12)(17,18)(22,23)(27,28),
 ( 1,2)( 9,10)(11,12)(15,16)(17,18),( 9,40)(11,41)(13,43)(15,44)(17,45)
  (19,47)(21,48)(23,50)(25,51)(27,52)(29,54)(31,55)(33,57)(35,58)(37,59),
 ( 6,19)( 7,21)( 8,22)( 9,24)(11,25)(12,26)(13,28)(14,29)(16,31)(17,32),
 ( 1,7)( 2,13)( 3,23)( 9,25)(12,27)(18,29)(20,31),( 1,4)(11,12)(14,15),
 ( 2,16)( 3,17)( 5,18)( 6,19)( 8,20)( 9,21)(11,22)(12,23)(14,24)(15,25),
 ( 4,5)( 7,8)( 9,10)(12,13)(16,17),( 2,9)( 5,12)( 6,13)( 8,16),
 ( 4,6)( 7,8)( 9,11)(13,14)(15,16)(18,20)(21,22)(23,25)(27,28)(29,30)
  (32,34)(35,36)(37,39)(41,42)(43,44),( 1,5)( 4,11)( 8,13),
 ( 1,5)( 4,11)( 9,12),( 1,24)( 3,25)( 5,27)( 6,29)( 7,30)( 9,31)(10,32)
  (12,34)(13,36)(14,37)(16,38)(18,39)(19,41)(21,43)(23,44),
 ( 3,7)( 4,9)(12,16)(14,17)(18,20)(19,21),
 ( 3,4)( 8,9)(13,14)(19,20)(23,24),( 1,3)( 8,9)(10,12)(14,15)(16,18),
 ( 1,24)( 3,25)( 5,26)( 6,28)( 8,30)(10,31)(11,32)(12,33)(14,35)(15,37)
  (17,38)(18,39)(19,40)(21,42)(23,44),( 1,6)( 2,11)( 3,22)( 9,24)(12,26)
  (18,28)(20,30),( 1,2)( 3,10)( 5,11)( 7,12)( 8,13),
 ( 2,6)( 3,8)( 5,10),( 7,11)( 8,15)( 9,24)(12,33)(14,34)(21,35)(27,36)
  (29,37)(31,45)(32,54)(38,56)(41,59)(44,62)(47,65)(50,68)(53,71)(60,74)
  (66,75)(72,76),( 4,5)( 7,8)(10,12)(13,15)(16,18),
 ( 4,6)( 7,8)(10,12)(15,17)(19,20)(21,23),
 ( 1,2)( 6,7)(11,12)(15,16)(19,20)(23,24),
 ( 1,10)( 2,15)( 3,16)( 5,18)( 7,19)( 9,20)(11,22)(13,23)(17,24)(21,25),
 ( 3,4)( 6,7)( 9,11)(12,14)(15,17),( 5,6)( 8,10)(13,15)(17,19)(20,22)
  (23,24)(28,29),( 2,7)( 4,9)( 5,11)( 6,13),( 1,5)( 4,10)( 8,13),
 (10,11)(13,14)(16,17)(19,20)(21,22)(25,26)(27,28)(41,42)(44,45)(47,48)
  (50,51)(53,54)(56,57)(59,60)(63,64)(65,66)(69,70)(71,72)(75,76),
 ( 1,5)( 2,9)( 3,21)(10,26)(19,28)(22,29)(25,30)(27,31),
 ( 4,5)( 7,8)( 9,11)(12,14)(15,16)(18,19)(21,22)(23,25)(26,28)(29,30)
  (32,33)(35,36)(37,39)(40,42)(43,44),( 1,24)( 3,26)( 5,28)( 6,29)( 7,30)
  ( 9,31)(10,33)(12,35)(13,36)(14,37)(16,38)(18,40)(19,42)(21,43)(23,44),
 ( 3,8)( 9,13)(14,18)(19,23)(24,28),( 4,7)( 9,10)(11,12),
 ( 7,10)( 8,14)( 9,22)(17,33)(23,34)(31,39)(32,48)(35,53)(37,56)(38,57)
  (40,60)(41,61)(43,64)(44,65)(46,68)(47,69)(49,72)(50,73)(52,76)(59,77)
  (67,78)(75,79),( 1,9)( 3,14)( 6,21)(10,22)(12,23)(17,24)(18,25),
 ( 1,9)( 4,11)( 8,12),( 1,5)( 2,14)( 3,22)( 8,26)(12,27)(18,28)(23,29),
 ( 2,3)(10,11)(16,17)(18,19)(21,22)(24,25),
 ( 2,6)( 3,7)(13,16)(15,17)(18,20)(19,21),
 ( 1,10)( 2,14)( 5,19)( 7,22)(13,23)(20,24),
 ( 8,9)(12,13)(17,18)(22,23)(27,28)(32,33)(36,37)(41,42)(46,47)(51,52),
 ( 4,5)( 7,8)(10,11)(13,14)(17,18)(21,22)(24,25)(27,28)(30,31)(34,35)
  (38,39)(41,42)(44,45)(47,48)(51,52),( 3,4)( 9,12)(13,16)(20,23)(24,27)
  (28,30)(31,34)(35,38)(42,45)(46,49)(50,52),( 1,7)( 4,11)( 5,13)( 6,17),
 ( 1,2)( 8,10)(12,14)(16,18)(25,26)(29,30)(32,33)(36,37)(39,40)(43,44),
 ( 1,11)( 2,19)( 3,23)( 4,25)( 8,27)(18,29)(26,30)(28,31),
 ( 5,6)( 8,10)(13,14)(17,18)(21,23)(25,26)(29,30),
 ( 4,14)( 7,16)( 8,17)( 9,19)(12,20)(13,22),
 ( 4,5)( 6,7)(12,14)(20,21)(23,24)(27,28)(30,31),( 3,5)(10,12)(14,16),
 ( 1,4)( 8,12)(16,19)(20,23)(25,26)(27,28)(32,33)(34,35)(39,40)(41,42),
 ( 5,6)( 8,10)(15,16)(17,19)(22,24)(25,26)(27,28),
 ( 1,3)( 2,5)( 6,9)( 8,11),( 6,14)( 8,15)( 9,17)(10,18)(12,20)(13,21),
 ( 4,6)( 9,11)(15,17)(19,20)(23,24)(25,27)(28,30)(32,33)(35,36),
 ( 5,7)( 9,11)(14,15)(18,19)(22,23),( 4,19)( 5,22)( 7,25)( 8,28)(10,31)
  (11,34)(12,37)(14,40)(15,43)(17,46),( 1,2)( 6,7)(13,14)(18,19)(23,24)
  (28,29)(33,34)(38,39),( 5,7)( 9,11)(15,16)(19,21)(24,25),
 ( 2,7)( 5,10)(12,14)(13,15),( 4,7)( 8,12)(14,16)(18,22)(23,26),
 ( 6,7)(11,12)(17,18)(22,23)(27,28),( 2,3)( 9,11)(13,15)(17,19)(25,26)
  (29,30)(32,33)(36,37)(39,40)(43,44),( 5,6)( 9,10)(12,13)(16,17),
 ( 5,6)( 9,10)(12,13)(16,17)(20,21)(24,25),
 ( 5,6)( 8,9)(13,14)(17,18)(21,22)(25,26)(30,31),
 ( 1,2)(10,12)(17,18)(20,21)(23,24)(27,28)(30,31),
 ( 1,21)( 2,22)( 3,23)( 4,24)( 5,26)( 6,28)( 7,29)( 8,30)( 9,32)(18,33)
  (19,34),( 1,9)( 3,10)( 4,11)( 6,12)( 8,13),
 ( 2,3)( 7,9)(12,14)(15,17)(20,22),( 3,9)( 6,10)(12,15)(14,16),
 ( 3,7)( 5,8)( 6,10),( 2,8)( 4,9)(10,14)(12,15),
 ( 1,7)( 2,11)( 3,13)( 6,17),( 1,25)( 3,26)( 4,28)( 6,29)( 8,30)( 9,32)
  (11,33)(12,35)(13,36)(15,37)(17,39)(18,40)(20,42)(22,43)(23,44),
 ( 6,7)(10,11)(13,14)(16,17)(19,20)(23,24)(27,28)(30,31)(33,34)(36,37)
  (40,41)(44,45)(47,48)(50,51)(53,54),( 9,10)(12,13)(16,17)(20,21)(25,26)
  (29,30)(33,34)(36,37)(40,41)(44,45)(49,50)(53,54),
 ( 7,19)( 8,20)(10,22)(11,23)(12,25)(13,26)(15,27)(16,29)(17,30)(18,32),
 ( 4,5)( 9,10)(13,14)(18,19)(23,24)(25,26)(29,30)(31,32),
 ( 4,5)( 7,8)(11,12)(14,15)(18,19)(21,22)(25,26)(28,29)(32,33)(35,36)
  (39,40)(42,43),( 5,6)( 8,9)(10,11)(16,17)(23,24)(26,27),
 ( 1,4)( 2,6)( 7,11)( 8,14)(12,15)(13,16),
 ( 1,2)( 8,9)(13,14)(18,19)(23,24)(28,29)(33,34),
 ( 5,6)(10,11)(16,17)(20,21)(26,27),( 5,7)( 8,9)(11,13)(16,18)(20,21)
  (23,25),( 3,6)(11,19)(15,28)(16,37)(17,46)(18,55)(21,56)(23,60)(27,62)
  (29,66)(33,68)(35,72)(39,74)(41,78)(45,80)(47,84)(51,86)(53,90)(61,92)
  (64,93)(73,94)(76,95)(85,96)(88,97),( 1,2)(12,13)(15,16)(18,19)(20,21)
  (22,23)(24,25)(26,27)(28,29),( 6,7)( 9,10)(13,14)(16,17)(18,19)(23,24)
  (28,29)(33,34)(38,39)(43,44),( 5,8)( 9,11)(12,13)(15,17)(18,20),
 ( 1,6)( 5,11)( 9,13),( 4,5)( 7,9)(12,14)(18,20)(23,24)(25,27)(28,30)
  (32,33)(35,36),( 8,9)(10,13)(15,16)(17,18)(21,23),
 ( 7,16)( 8,25)( 9,29)(11,33)(13,34)(19,35)(26,36)(28,37)(31,39)(32,48)
  (40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(63,75)(69,76),
 ( 2,7)( 3,9)( 4,10)( 6,12),( 5,6)(10,12)(14,16)(18,20)(22,23)(29,30)
  (32,34)(36,38)(40,42)(44,45)(51,52),( 1,4)( 3,13)( 6,14),
 ( 5,6)(10,12)(14,16)(18,19)(25,26)(28,30)(32,34)(36,38)(40,41)(47,48)
  (50,52),( 2,3)( 7,8)(12,13)(17,18)(21,22),
 ( 3,5)( 8,10)(11,13)(16,18)(21,23)(26,28)(31,33)(36,38),
 ( 3,12)( 5,17)( 7,19)( 8,22)( 9,23)(14,24)(16,25),
 ( 8,9)(12,14)(15,16)(17,20)(22,23),( 1,4)( 3,11)( 7,13),
 ( 3,5)( 6,10)( 7,11)( 8,12),( 1,3)( 4,9)( 6,11),
 ( 4,5)( 6,8)(13,14)(20,21)(24,25)(27,28)(31,32),
 ( 7,14)( 8,27)( 9,34)(11,35)(15,36)(17,37)(30,41)(31,46)(32,50)(33,55)
  (39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(59,74)(61,75)(65,76)(67,77)
  (71,78)(73,79),( 4,5)( 6,8)(13,14)(19,20)(23,24)(26,27)(30,31),
 ( 4,5)( 6,10)( 7,11)( 8,12)( 9,13),( 5,6)( 8,10)(13,15)(16,17)(22,24)
  (26,27)(28,29),( 1,2)(10,11)(14,15),( 8,10)(11,13)(15,16)(18,19)(20,22)
  (23,25)(27,28)(30,32)(34,35)(37,39)(40,42)(43,44)(46,47)(49,51)(52,54),
 ( 1,8)( 2,16)( 3,21)( 6,26)(12,27)(17,28)(24,29),
 ( 1,6)( 2,8)( 3,10)( 5,12),( 1,10)( 2,16)( 3,20)( 4,26)(12,27)(15,28)
  (24,29),( 1,5)( 2,9)( 3,15)(10,26)(13,27)(21,28)(23,29),
 ( 1,10)( 2,16)( 3,21)( 5,23)( 8,25)(17,28)(26,31)(29,33),
 ( 1,7)( 3,9)( 4,10)( 5,12),( 1,5)( 4,18)( 8,22)(10,24)(14,26)(17,28)
  (19,30)(23,31)(27,32),( 1,8)( 2,12)( 3,18)( 4,26)(13,27)(16,28)(24,29),
 ( 1,4)( 2,9)( 5,11)( 8,13)(10,14)(12,15),
 ( 1,2)( 4,5)( 6,7)( 9,10)(12,13),( 4,5)( 8,9)(11,12)(15,16),
 ( 6,7)(13,15)(17,19)(21,23)(24,25)(27,28)(31,32)(34,35)(38,39)(41,42),
 ( 4,6)( 9,11)(12,13)(18,20)(22,23)(26,27)(28,29),
 ( 3,4)( 6,8)( 9,11)(12,14)(16,17),( 1,2)( 3,13)( 5,14),
 ( 2,8)( 4,10)( 6,12)( 7,14)(13,19)(15,21),
 ( 1,7)( 2,9)( 3,10)( 5,13)( 6,14),( 1,14)( 2,20)( 3,24)( 6,26)( 8,27)
  (16,28)(19,29),( 3,5)( 6,8)(11,13)(16,18)(21,23)(26,28)(31,33),
 ( 1,24)( 3,25)( 5,27)( 6,29)( 8,30)(10,31)(11,32)(12,34)(14,36)(15,37)
  (17,38)(18,39)(19,41)(21,43)(23,44),( 2,3)( 6,7)(13,14)(20,21),
 ( 1,14)( 2,20)( 4,22)( 5,25)( 8,26)(10,29)(11,30)(15,31)(17,34)(19,35)
  (23,36)(27,37)(32,38),( 8,9)(12,13)(16,17)(19,20)(23,24)(27,28)(32,33)
  (36,37)(40,41)(43,44)(47,48)(51,52),( 4,5)( 7,8)(13,15)(20,21)(23,24)
  (27,28)(30,31),( 1,4)( 6,8)( 9,11)(13,15),
 ( 3,6)( 7,11)(12,15)(17,20)(22,25),( 9,10)(12,14)(15,17)(18,19)(21,22)
  (24,26)(27,28)(30,31)(32,34)(36,37)(39,40)(41,43)(44,46)(48,49)(50,52),
 ( 1,2)( 3,4)( 6,7)( 9,10)(12,13)(16,17)(20,21)(24,25),
 ( 1,2)( 3,10)( 5,11),( 1,8)( 2,12)( 3,14)( 6,18),
 ( 3,9)( 6,12)( 8,15)(10,16)(13,17),( 1,2)( 3,9)( 4,10)( 6,13)( 7,14),
 ( 5,6)( 8,9)(11,12),( 2,5)( 3,8)( 9,14)(10,15),
 ( 5,6)( 8,9)(12,14)(17,19)(22,24),( 5,11)( 6,12)( 7,14)( 8,15)( 9,17)
  (10,18),( 3,8)( 6,9)(10,14)(12,15),( 2,3)(11,12)(14,15)(18,19)(21,22)
  ,( 1,11)( 2,16)( 3,24)( 4,25)(14,27)(20,29)(26,30)(28,31),
 ( 1,8)( 2,16)( 3,21)( 4,25)( 9,27)(14,29)(19,31),
 (13,14)(15,16)(17,18)(19,20)(21,22)(23,24)(33,34)(36,37)(38,39)(40,41)
  (42,43)(45,46)(47,48)(49,50)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67),
 ( 5,6)( 8,9)(12,13)(15,16)(18,19)(23,24)(28,29)(33,34)(38,39)(43,44),
 ( 4,14)( 5,16)( 8,17)( 9,19)(10,20)(13,22),
 ( 1,5)( 2,8)( 4,10)( 9,14)(11,15)(12,16)(13,17),
 ( 1,8)( 3,9)( 4,10)( 7,12)(11,14)(13,15),
 ( 3,4)( 7,8)(11,12)(22,23)(26,27)(28,29)(33,34)(35,36)(38,39)(40,41),
 ( 2,4)( 6,7)( 8,10),( 8,10)(11,12)(14,16)(17,19)(20,22)(24,25)(26,28)
  (30,32)(34,35)(36,38)(40,41)(43,44)(46,48)(49,50)(52,54),
 ( 7,8)(10,11)(13,14)(15,16)(18,19),( 2,8)( 5,15)( 7,20)(11,22)(12,23)
  (17,24)(19,25),( 7,9)(11,13)(15,16)(18,20)(22,24),
 ( 2,10)( 4,13)( 6,14)( 8,15)(11,16),( 2,9)( 7,10)(11,15)(13,16),
 ( 6,8)(10,12)(14,16)(22,23)(24,25)(28,29)(31,32)(35,36)(38,39)(42,43),
 ( 4,5)( 7,8)(10,11)(13,14)(17,18),( 4,5)( 9,10)(12,13)(16,17)(20,21),
 ( 4,8)( 5,9)( 6,11)( 7,13)(10,14)(12,15),
 ( 1,9)( 3,13)( 6,18)( 7,22)(10,23)(17,24),
 ( 1,8)( 4,21)( 7,22)( 9,24)(12,26)(16,28)(18,30)(25,31)(29,32),
 ( 8,9)(11,12)(14,16)(17,18)(20,22)(24,26)(27,28)(30,32)(33,35)(36,38)
  (40,41)(42,44)(46,48)(50,51)(52,54),( 1,2)( 9,10)(16,17)(23,24),
 ( 1,12)( 2,21)( 4,23)( 6,25)( 9,27)(13,29)(16,31)(19,33),
 ( 1,4)( 2,14)( 3,20)( 7,24)( 9,26)(15,28)(18,30),
 ( 4,6)( 7,10)(11,14)(15,17)(18,20)(21,23)(24,27)(28,31)(32,34)(35,37)
  (38,40)(41,44)(45,48)(49,51)(52,54),( 3,5)( 7,9)(11,13)(19,20)(26,27)
  (29,30)(33,34)(36,37)(40,41)(43,44),( 6,7)( 8,9)(11,12)(15,16)(19,20),
 ( 1,2)( 8,10)(15,16)(20,21)(24,25)(27,28)(31,32),
 ( 1,12)( 2,20)( 3,25)( 6,26)(10,27)(16,28)(21,29),
 ( 4,5)( 8,9)(13,14)(17,18)(20,21)(24,25),
 (12,13)(15,16)(17,18)(19,20)(21,22)(23,24)(33,34)(35,36)(37,38)(40,41)
  (42,43)(44,45)(46,47)(49,50)(52,53)(55,56)(58,59)(61,62)(64,65)(67,68),
 ( 6,7)(10,11)(12,13)(14,15),( 4,5)( 7,9)(10,12)(13,15)(17,18),
 ( 5,6)( 9,10)(12,13)(16,17)(19,20)(24,25)(29,30)(34,35)(39,40)(44,45),
 ( 1,4)( 5,8)(12,16)(20,23)(26,27)(28,29)(33,34)(35,36)(40,41)(42,43),
 ( 1,4)( 2,13)( 5,14)( 7,15)( 8,18)(10,19)(12,22)(17,23)(21,24),
 ( 1,12)( 2,18)( 3,22)( 5,25)( 8,26)( 9,29)(13,30)(15,31)(17,34)(21,35)
  (24,36)(28,37)(33,38),( 1,5)( 2,17)( 3,22)( 6,26)(15,28)(18,29)(25,30)
  (27,31),( 1,2)( 4,5)( 7,8)(10,11)(13,14)(16,17)(20,21)(24,25),
 ( 1,7)( 2,15)( 3,20)( 4,24)( 9,26)(14,28)(19,30),
 ( 2,5)( 7,9)(10,12)(13,15)(16,18),( 1,3)( 2,6)( 5,12)( 8,13)(10,14),
 ( 1,2)(12,15)(16,19)(20,22)(23,26)(27,30)(34,37)(38,41)(42,44)(45,48)
  (49,52),( 1,2)( 6,7)(14,15)(19,20)(24,25)(29,30)(34,35)(39,40),
 ( 1,25)( 2,26)( 4,27)( 6,28)( 7,30)( 9,32)(11,33)(12,34)(14,35)(16,37)
  (17,39)(18,40)(20,41)(21,42)(23,44),( 3,7)( 8,12)(13,17)(18,23)(24,28),
 ( 5,6)(10,11)(15,16)(21,22)(26,27),( 1,3)( 9,10)(16,18)(20,22)(25,26)
  (28,29)(32,33)(35,36)(39,40)(42,43),( 2,9)( 4,12)( 7,15)(10,16)(13,17),
 ( 1,5)( 2,10)( 3,22)( 9,25)(12,26)(21,28)(27,30)(29,31),
 ( 5,6)(13,14)(16,17)(19,20)(22,23)(24,25)(28,29)(30,31),
 ( 1,7)( 3,11)( 8,12),( 1,13)( 2,20)( 3,22)( 5,23)( 7,25)( 9,27)(11,28)
  (14,30)(19,33)(24,35)(26,36)(29,37)(31,38)(32,39)(34,40),
 ( 1,2)( 8,9)(13,14)(16,17)(20,21),( 2,10)( 4,11)( 8,13)( 9,15)(12,18)
  (14,19),( 1,4)( 2,11)( 5,23)(10,26)(13,28)(15,29)(17,31)(19,33)(21,34)
  (22,35)(24,36)(25,37)(27,38)(30,39)(32,40),( 1,4)( 2,11)( 5,12),
 ( 1,10)( 2,11)( 3,14)( 5,15)( 7,18)( 8,19),
 ( 5,8)( 9,11)(13,15)(16,18)(20,22)(23,25),
 ( 4,7)( 8,11)(12,14)(15,18)(19,21)(22,25),
 ( 3,8)( 5,9)( 7,12)(11,15)(14,16),( 2,3)(12,13)(15,16)(18,19)(21,22)
  (23,24)(25,26)(27,28)(29,30),( 1,9)( 2,12)( 4,13)( 6,16),
 ( 3,4)( 8,9)(12,14)(17,19)(22,24),( 4,6)( 9,10)(13,14)(17,19)(21,22)
  (25,26)(29,30),( 4,18)( 5,21)( 7,24)( 8,27)(10,30)(11,33)(12,36)(14,39)
  (15,42)(17,45),( 1,9)( 3,11)( 6,14)(10,16)(13,17),
 ( 5,8)( 9,10)(12,13),( 1,8)( 2,12)( 5,17)( 7,21)(13,23)(20,24),
 (12,14)(15,17)(18,19)(20,21)(22,23)(24,25)(34,36)(37,39)(40,42)(43,45)
  (46,48)(49,51)(52,53)(54,55)(56,58)(59,60)(61,62)(63,65)(66,67)(68,69)
  (70,72),( 4,5)( 9,10)(14,15)(16,17)(19,20),
 ( 1,7)( 2,15)( 3,24)( 8,25)(18,27)(22,29)(26,30)(28,31),
 ( 1,3)( 7,9)(12,14),( 1,4)( 2,10)( 5,11)( 7,12)( 9,13),
 ( 1,4)( 2,10)( 5,11),( 1,5)( 2,10)( 6,12),( 3,8)( 6,9)(11,14)(13,15),
 ( 5,7)( 8,10)(12,14)(15,17)(19,21)(22,24)(26,28)(29,31)(33,35)(36,38)
  (40,42)(43,45),( 1,2)( 4,5)(10,11)(14,15)(17,18),
 ( 5,7)( 8,10)(12,14)(15,17)(19,21)(22,24),
 ( 2,3)(11,12)(14,15)(17,18)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33),
 ( 1,8)( 2,16)( 3,25)( 7,26)(12,27)(18,28)(22,29),
 ( 1,7)( 2,12)( 3,20)( 8,25)(13,27)(18,29)(23,31),
 ( 1,9)( 2,11)( 5,13)( 6,15),( 3,8)( 9,13)(14,18)(19,24)(25,28),
 ( 4,6)( 7,9)(11,13)(16,18)(20,21)(26,27)(31,32),(2,3)(4,5)(7,9),
 ( 4,5)( 6,7)(10,11)(15,16)(19,20)(26,27)(29,30),
 ( 2,8)( 4,10)( 5,14)(13,20)(15,23)(17,24)(19,27),
 ( 5,6)( 9,11)(12,15)(16,19)(23,26)(27,30)(31,33)(34,37)(38,41)(45,48)
  (49,52),(10,11)(12,13)(16,17)(18,19)(21,22)(24,25)(27,28)(42,43)(45,46)
  (48,49)(51,52)(54,55)(57,58)(59,60)(63,64)(65,66)(69,70)(71,72)(75,76),
 ( 3,4)(10,12)(17,18)(19,20)(22,23)(26,27)(29,30),
 ( 1,20)( 2,22)( 3,23)( 4,24)( 5,26)( 6,28)( 7,29)( 8,30)( 9,31)(18,33)
  (19,34),( 7,8)(11,13)(15,18)(19,22)(24,26),
 ( 4,20)( 6,23)( 7,26)( 9,29)(10,32)(11,35)(13,38)(14,41)(16,44)(17,47),
 ( 5,8)(10,11)(13,14),( 2,3)( 6,7)(12,14)(21,22)(24,25)(28,29)(31,32),
 ( 1,8)( 3,11)( 6,16)( 7,20)(10,23)(17,24),
 ( 4,6)( 7,8)( 9,11)(13,14)(15,17),( 7,8)(10,11)(12,14)(15,17)(19,20)
  (22,24)(26,27)(29,31)(32,34)(35,36)(38,39)(41,43)(44,46)(48,50)(51,53),
 ( 3,4)( 6,8)( 9,10),( 2,6)(14,19)(15,28)(16,37)(17,46)(18,55)(21,56)
  (23,60)(27,62)(29,66)(33,68)(35,72)(39,74)(41,78)(45,80)(47,84)(51,86)
  (53,90)(61,92)(64,93)(73,94)(76,95)(85,96)(88,97),( 1,5)( 2,9)( 6,12),
 ( 7,11)( 8,24)(21,34)(23,35)(27,36)(29,37)(30,38)(31,43)(32,47)(33,52)
  (39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(56,74)(58,75)(62,76)(64,77)
  (68,78)(70,79),( 1,2)( 7,8)(11,12)(18,19),
 ( 4,5)(11,12)(14,16)(17,19)(22,23)(27,28)(30,32)(34,36)(39,40)(47,48)
  (59,61)(62,64)(65,67)(68,70)(71,73)(74,76)(77,78)(79,80)(81,82),
 ( 1,6)( 2,11)( 3,23)(10,25)(13,26)(22,28)(27,30)(29,31),
 ( 2,8)( 4,10)( 9,16)(11,17)(13,19)(15,21)(18,22)(20,23),
 ( 6,12)( 7,13)( 8,14)( 9,15)(10,16)(11,17),
 ( 3,4)(11,12)(14,15)(17,18)(20,21)(22,23)(24,25)(26,27)(28,29),
 ( 5,6)( 7,8)(10,12)(13,14)(15,17)(19,20)(21,22)(24,26)(27,28)(29,31)
  (33,34)(35,36)(38,40)(41,42)(43,45),( 1,4)( 2,13)( 3,21)( 6,25)(10,27)
  (20,29)(26,30)(28,31),( 4,5)( 7,8)( 9,10)(13,14),
 ( 8,10)(11,14)(16,19)(20,22)(24,26)(28,30)(32,34)(35,38)(40,43)(44,46)
  (48,50)(52,54),( 3,5)( 8,9)(10,12)(15,16),
 ( 2,10)( 3,11)( 6,13)( 7,14),( 5,6)( 9,11)(14,16)(19,21)(24,25),
 ( 1,7)( 2,15)( 3,20)( 8,25)(18,27)(24,29)(26,30)(28,31),
 ( 3,4)( 8,9)(12,13)(17,18)(21,22),( 2,8)( 4,9)( 6,13)( 7,17)(12,19)
  (16,21),( 2,9)( 4,12)( 5,13)( 8,16),( 5,7)( 9,12)(13,16)(18,20)(23,24)
  ,( 4,5)( 8,9)(13,14)(18,19)(22,23),( 7,10)( 8,26)(13,34)(17,35)(23,36)
  (28,37)(30,43)(31,45)(32,52)(33,54)(38,56)(41,59)(44,62)(47,65)(50,68)
  (53,71)(58,74)(60,75)(64,76)(66,77)(70,78)(72,79),
 ( 1,5)( 2,16)( 3,21)( 7,25)( 9,27)(15,29)(18,31),
 ( 5,7)( 9,11)(13,15)(21,22)(24,25)(28,29)(31,32)(35,36)(38,39)(42,43),
 ( 6,7)(10,12)(14,16)(19,20)(23,24),( 3,5)( 7,8)(10,12)(13,14)(16,18),
 ( 5,6)( 8,10)(13,15)(19,21)(23,24)(25,27)(28,30)(32,33)(35,36),
 ( 5,6)( 8,9)(12,13)(15,16)(20,21),( 5,7)(10,12)(15,16)(20,21)(24,26),
 ( 5,6)( 8,9)(12,13)(15,16)(21,22)(26,27)(31,32)(36,37)(41,42)(46,47),
 ( 1,10)( 2,12)( 5,14)( 6,16),( 4,6)( 8,10)(14,15)(18,20)(23,24),
 ( 3,7)( 5,8)( 9,12)(10,14),( 2,6)( 3,7)(10,13)(11,15),
 ( 5,6)(12,14)(16,18)(20,22)(24,25)(27,28)(31,32)(34,35)(38,39)(41,42),
 ( 2,4)(10,11)(17,19)(21,23)(25,26)(28,29)(32,33)(35,36)(39,40)(42,43),
 ( 1,20)( 2,22)( 3,23)( 4,24)( 5,25)( 6,27)( 7,29)( 8,30)( 9,31)(18,33)
  (19,34),( 4,5)( 6,7)(11,12)(16,17)(21,22)(26,27)(31,32),
 ( 7,8)(12,13)(16,17)(21,22)(26,27)(31,32)(36,37)(40,41)(45,46)(50,51),
 ( 3,8)( 5,9)( 6,10)( 7,14)(11,18)(15,20),
 ( 1,17)( 4,18)( 5,20)( 7,21)( 8,23)(10,24)(11,25)(13,27)(14,28)(16,30),
 ( 1,4)( 2,7)( 5,11)( 8,13)(10,14),(2,4)(5,8)(6,9),
 ( 3,6)( 8,11)(13,16)(17,21)(22,25),( 7,8)( 9,10)(12,13)(14,15)(17,18),
 ( 5,6)( 9,10)(12,13)(15,16)(18,19)(22,23)(26,27)(29,30)(32,33)(35,36)
  (39,40)(43,44)(46,47)(49,50)(52,53),( 4,5)( 8,9)(12,13)(15,16)(17,18),
 ( 1,2)( 6,7)(10,11)(14,15)(19,20),( 1,4)( 5,11)( 7,13)( 8,14)( 9,15)
  (10,16)(12,17),( 5,6)( 7,8)(11,12)(15,16)(18,19),
 ( 1,12)( 2,20)( 3,24)( 5,25)( 9,27)(19,29)(26,30)(28,31),
 ( 1,9)( 3,12)( 5,13)( 6,16)( 7,17)( 8,20),
 ( 4,5)( 7,9)(10,12)(15,17)(18,20),( 7,9)(11,12)(13,15)(17,18)(20,21)
  (23,25)(26,27)(29,31)(33,35)(36,37)(39,41)(42,44)(45,47)(49,50)(51,53),
 ( 5,7)( 9,11)(16,18)(20,21)(24,25)(26,27)(28,29)(30,31),
 ( 1,6)( 2,11)( 3,19)(10,26)(15,27)(21,28)(25,29),
 ( 7,9)(11,13)(14,17)(19,22)(23,25)(27,29)(31,33)(35,37)(38,41)(43,46)
  (47,49)(51,53),( 2,11)( 3,12)( 4,13)( 5,15)( 6,16)( 9,18)(10,19),
 ( 2,9)( 3,11)( 5,12)( 6,14),( 1,4)( 2,13)( 5,14),
 ( 4,6)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 4,6)( 8,9)(11,13)(16,18)(20,21)(22,24),
 ( 1,5)( 3,12)( 6,23)(10,25)(14,27)(18,29)(19,30)(24,31)(28,32),
 ( 2,7)( 5,8)( 9,13)(10,16),( 5,6)(10,11)(15,16)(21,22)(25,26),
 ( 9,10)(12,13)(14,16)(18,19)(21,22)(24,26)(27,28)(30,31)(32,34)(35,36)
  (38,40)(41,43)(44,46)(48,49)(50,52),( 1,4)( 2,6)( 3,8)(10,12)(11,14),
 ( 5,15)( 8,16)( 9,18)(10,19)(13,21)(14,22),
 ( 1,2)(12,13)(15,17)(19,21)(23,25)(27,28)(34,35)(37,39)(41,43)(45,47)
  (49,50),( 1,9)( 2,12)( 3,13)( 4,16)( 6,17)( 8,20),
 ( 1,4)(10,12)(13,15)(17,18)(19,21),( 7,8)(10,11)(14,15)(18,19)(23,24)
  (27,28)(31,32)(34,35)(38,39)(42,43)(47,48)(51,52),
 ( 3,7)( 8,11)(13,16)(17,21)(23,25),( 1,10)( 5,16)( 7,19)(11,20)(13,21)
  (15,24)(17,25),( 1,2)( 8,9)(13,14)(18,19)(22,23)(25,26),
 ( 2,6)( 5,7)( 8,12)(10,15),( 2,9)( 4,11)( 6,15)( 8,18)(13,20)(17,23),
 ( 4,7)( 8,11)(12,15)(19,23)(24,25)(29,30)(31,32)(36,37)(38,39)(43,44),
 ( 2,3)( 9,10)(14,15)(16,18)(21,23)(26,28)(31,33)(36,38)(41,43),
 ( 2,10)( 3,12)( 4,13)( 5,16)( 8,18)( 9,20)(14,22)(17,23)(19,24)(21,25),
 ( 5,6)( 9,10)(13,14)(16,17)(20,21)(23,24),
 ( 1,10)( 2,11)( 4,14)( 6,15)( 7,18)( 8,19),( 1,3)(10,11)(14,15),
 ( 4,5)( 8,9)(10,11)(16,17)(23,24)(26,27),
 ( 6,7)( 9,10)(13,14)(16,17)(20,21)(23,24)(27,28)(30,31)(34,35)(37,38)
  (41,42)(44,45),( 1,9)( 2,10)( 4,11)( 6,12)( 7,13),
 ( 2,3)(11,12)(13,14)(16,17)(18,19),( 1,4)( 5,8)( 9,12)(16,20)(27,28)
  (29,30)(34,35)(36,37)(41,42)(43,44),( 4,6)( 9,11)(15,17)(19,21)(23,25),
 ( 6,7)( 8,9)(11,12),( 1,10)( 2,18)( 3,23)( 4,26)( 8,27)(14,28)(19,29),
 ( 1,4)( 6,12)(10,13)(11,14),( 7,8)(10,12)(13,15)(17,19)(20,22)(24,25)
  (27,28)(29,31)(32,34)(36,37)(39,41)(43,44)(46,48)(49,51)(52,53),
 ( 4,18)( 6,21)( 7,24)( 9,27)(10,30)(11,33)(13,36)(14,39)(16,42)(17,45),
 ( 1,6)( 2,9)( 5,11)( 8,13)(10,14)(12,15),
 ( 1,11)( 4,14)( 7,15)( 9,16)(12,17),( 6,7)( 9,10)(12,13)(16,17)(19,20),
 ( 2,7)( 5,9)(10,12)(11,14),( 3,4)( 9,10)(13,14)(16,17)(18,19),
 ( 7,8)(11,12)(15,16)(18,19)(22,23)(26,27)(31,32)(35,36)(39,40)(42,43)
  (46,47)(50,51),( 1,24)( 2,25)( 4,26)( 6,28)( 7,29)( 9,31)(11,32)(12,33)
  (13,35)(15,36)(16,38)(18,39)(20,40)(21,42)(23,43),
 ( 1,16)( 2,17)( 4,18)( 5,19)( 7,20)( 8,21)(10,22)(11,23)(13,24)(14,25),
 ( 1,24)( 3,26)( 4,27)( 5,29)( 7,30)( 8,31)(10,33)(12,34)(13,36)(15,37)
  (16,38)(17,40)(19,41)(21,43)(22,44),( 3,9)( 5,11)( 6,13)( 7,15)(12,18)
  (14,20),(12,13)(14,15)(16,17)(18,20)(21,22)(23,24)(31,33)(34,35)(36,37)
  (38,39)(40,42)(43,44)(45,46)(47,48)(49,51)(54,56)(57,59)(60,62)(65,67)
  (68,70),( 1,4)( 2,12)( 3,17)( 8,25)(14,27)(24,29)(26,30)(28,31),
 ( 3,5)( 8,9)(13,15)(17,19)(23,24),( 7,8)(10,12)(14,15)(17,19)(20,22)
  (23,24)(26,27)(29,31)(32,34)(36,38)(39,41)(43,44)(46,47)(48,50)(51,53),
 ( 2,3)( 9,10)(16,17)(19,21)(23,25)(27,29)(31,32)(38,39)(41,43)(45,47)
  (49,51),(1,3)(4,5)(6,7)(8,9),( 1,2)( 9,10)(14,15)(19,20)(24,25)(29,30)
  (34,35),( 1,8)( 2,11)( 4,14)(13,22)(15,23)(17,26)(19,27),
 ( 1,11)( 2,20)( 3,24)( 4,25)(14,27)(18,29)(26,30)(28,31),
 ( 1,3)( 5,7)(13,14)(20,22)(25,26)(28,29)(32,33)(35,36)(39,40)(42,43),
 ( 1,6)( 2,8)( 5,10)( 7,12)( 9,14)(11,16),
 ( 1,14)( 2,22)( 4,24)( 6,26)( 9,28)(13,30)(16,32)(19,34),
 ( 9,39)(11,40)(13,42)(15,43)(17,45)(19,46)(21,47)(23,49)(25,50)(27,52)
  (29,53)(31,54)(33,56)(35,57)(37,59),( 3,4)( 8,9)(13,14)(18,19)(23,24),
 ( 1,3)( 8,10)(13,15)(18,20)(23,25)(28,30)(33,35),
 ( 6,7)(10,11)(13,14)(17,18)(23,24)(26,27)(28,29),
 ( 1,4)( 2,8)( 3,20)( 9,26)(18,28)(21,29)(25,30)(27,31),
 ( 7,12)( 8,20)( 9,24)(15,33)(17,34)(21,35)(23,36)(30,37)(31,45)(32,54)
  (38,56)(41,59)(44,62)(47,65)(50,68)(53,71)(60,74)(66,75)(72,76),
 ( 1,24)( 3,25)( 5,28)( 7,29)( 9,30)(11,33)(13,34)(14,35)(16,36)(18,37)
  (19,40)(21,41)(23,42)(26,43)(27,44)(31,45)(32,46)(38,47)(39,48),
 ( 3,9)( 5,10)( 7,11)( 8,14)(12,15)(13,16),
 ( 4,5)( 9,10)(14,15)(19,20)(25,26),( 1,9)( 3,12)( 4,13)( 7,16),
 ( 1,3)( 2,15)( 5,22)( 7,23)( 9,26)(11,27)(13,28)(16,31)(18,32)(21,35)
  (25,36)(30,37)(34,38),( 2,10)( 3,11)( 4,14)( 5,15)( 8,18)( 9,20)(13,22)
  (17,23)(19,24)(21,25),( 1,24)( 3,25)( 5,26)( 6,29)( 8,30)(10,31)(11,32)
  (13,33)(15,36)(17,37)(19,38)(21,41)(23,42)(27,43)(28,44)(34,45)(35,46)
  (39,47)(40,48),( 5,6)(11,12)(15,16)(21,22)(26,27),
 ( 4,8)( 5,9)(12,16)(14,17)(18,20)(19,21),
 ( 4,6)( 7,10)(11,14)(17,20)(21,24)(26,27)(28,29),
 ( 1,4)( 2,7)( 5,8)(10,13)(12,14),( 2,8)( 5,9)(11,14)(13,15),
 ( 1,6)( 2,11)( 3,19)( 8,24)(13,26)(18,28)(23,30),
 ( 5,6)( 9,10)(13,14)(17,19)(21,23),(11,12)(15,16)(19,20)(24,25)(29,30)
  (33,34)(37,38)(41,42)(46,47)(51,52),( 7,9)(10,12)(13,14)(16,17)(19,21)
  (22,24)(26,28)(29,31)(33,34)(36,37)(38,40)(41,43)(45,46)(48,50)(52,53),
 ( 3,10)( 6,13)( 8,15)(11,16)(14,17),(10,12)(13,14)(16,17)(18,20)(21,22)
  (24,26)(27,29)(30,32)(34,35)(36,38)(39,40)(42,43)(44,46)(48,49)(51,52),
 (11,12)(14,15)(17,18)(19,20)(22,23)(26,27)(29,30)(35,36)(39,40)(41,42)
  (43,44)(47,48)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62),
 ( 8,10)(13,14)(15,16)(18,21)(22,23),( 1,4)( 2,8)( 5,11),
 ( 2,5)(11,12)(14,15),( 4,5)(10,12)(14,15)(21,22)(24,26)(28,30)(32,34)
  (36,37)(43,44)(46,48)(50,52),( 3,5)( 8,9)(13,14)(17,19)(22,24),
 ( 5,15)( 7,17)( 9,18)(10,20)(12,21)(14,23),
 ( 4,5)( 6,7)(10,11)(14,15)(20,21)(26,27)(30,31),
 ( 5,7)( 9,11)(13,14)(18,19)(22,24)(25,27)(29,30)(36,37)(40,41)(48,49)
  (59,61)(62,64)(65,67)(68,70)(71,73)(74,76)(77,78)(79,80)(81,82),
 ( 3,7)( 8,12)(13,17)(18,22)(23,28),( 6,7)(10,11)(13,14)(17,18)(20,21)
  (24,25),( 7,19)( 8,24)(12,34)(16,35)(22,36)(27,37)(30,39)(31,41)(32,48)
  (33,50)(40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(59,75)(63,76)
  (65,77)(69,78)(71,79),( 3,4)( 5,7)( 9,10),
 (11,12)(13,14)(16,17)(18,19)(21,22)(24,25)(27,28)(37,38)(41,42)(43,44)
  (45,46)(49,50)(51,52)(53,54)(56,57)(59,60)(62,63)(65,66)(68,69),
 ( 7,9)(12,14)(15,16)(18,21)(23,24),( 2,3)( 6,8)(13,14)(20,21)(24,25)
  (27,28)(31,32),( 1,3)( 4,5)(14,15)(17,18)(20,21),
 ( 7,8)( 9,10)(12,14)(16,18)(20,22)(24,25)(31,32)(34,36)(38,40)(42,44)
  (46,47),( 3,4)( 7,8)(12,13)(16,17)(21,22)(25,26),
 ( 1,11)( 3,18)( 5,22)( 9,24)(13,26)(17,28)(21,30)(23,31)(27,32),
 ( 1,5)( 2,10)( 3,18)( 9,26)(14,27)(20,28)(24,29),
 ( 5,7)(10,11)(12,13)(16,17)(19,20),( 3,8)( 4,9)( 6,11),
 ( 8,10)(12,14)(16,18)(19,22)(24,27)(28,30)(32,34)(36,38)(40,42)(43,46)
  (48,51)(52,54),( 4,5)( 9,10)(13,15)(16,17)(18,20)(21,22)(23,25)(26,27),
 ( 2,4)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 4,8)( 5,9)( 6,10)( 7,12)(11,14)(13,15),( 1,2)( 4,11)( 6,13),
 ( 5,6)(12,13)(15,16)(18,20)(23,24)(28,29)(31,33)(35,37)(39,40)(47,48)
  (60,61)(63,64)(66,67)(69,70)(72,73)(75,76)(77,78)(79,80)(81,82),
 ( 7,8)(12,13)(17,18)(19,20)(22,23)(26,27)(29,30)(33,34)(36,37),
 ( 7,8)( 9,10)(12,13)(16,17)(21,22)(24,25),
 (10,11)(15,16)(20,21)(25,26)(29,30)(34,35)(39,40)(44,45)(49,50)(53,54),
 ( 5,7)( 9,12)(13,16)(17,20)(21,24),( 1,2)( 5,6)(10,11)(15,16)(19,20),
 ( 7,9)(11,12)(14,16)(18,20)(21,23),( 6,7)(10,11)(12,13)(15,16)(17,18),
 ( 3,9)( 6,11)( 8,13)(10,14)(12,15),( 9,10)(13,14)(18,19)(22,23)(26,27)
  (29,30)(33,34)(37,38)(42,43)(46,47)(50,51)(53,54),
 ( 1,8)( 2,20)( 3,24)( 7,25)(10,26)(19,28)(27,30)(29,31),
 ( 1,11)( 2,17)( 3,21)( 5,26)(13,27)(16,28)(25,29),
 ( 6,7)(10,11)(12,13)(15,16)(19,20),( 3,10)( 6,12)( 7,14)( 8,16)(13,17)
  (15,18),( 5,6)( 8,9)(13,14)(18,19)(22,23)(25,26),
 ( 3,5)( 7,8)( 9,11)(13,15)(16,17),( 6,7)(10,11)(15,16)(19,20)(21,22)
  (23,24)(26,27),( 5,7)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 4,5)( 6,7)(10,11)(13,14)(17,18)(23,24)(28,29)(31,32),
 ( 5,6)(10,11)(15,16)(21,22)(24,25)(28,29)(31,32)(35,36)(38,39),
 ( 6,8)(11,13)(14,16)(18,20)(22,24),( 1,2)(10,11)(16,17)(18,19)(21,22)
  (24,25),( 3,5)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,7)( 3,9)( 4,10)( 6,12),(1,2)(3,5)(7,9),( 2,7)( 5,8)(10,14)(12,15),
 ( 4,7)( 8,10)(11,14)(15,18)(21,24)(26,27)(28,29),( 1,7)( 2,11)( 6,13),
 ( 2,3)( 7,8)(12,13)(15,16)(20,21),(10,39)(12,41)(14,42)(16,44)(18,45)
  (20,46)(22,48)(24,49)(26,51)(28,52)(30,53)(32,55)(34,56)(36,58)(38,59),
 ( 1,7)( 2,11)( 6,12),( 5,6)( 8,9)(12,13)(15,16),
 ( 1,14)( 2,21)( 4,22)( 6,23)( 8,25)(10,27)(12,28)(15,30)(20,33)(24,35)
  (26,36)(29,37)(31,38)(32,39)(34,40),( 4,5)( 6,8)(10,12)(13,14)(16,18),
 ( 6,7)(10,11)(13,14)(18,19)(23,24),( 5,6)(10,11)(16,17)(21,22)(26,27),
 ( 2,7)( 3,9)( 4,11)( 6,13),( 6,7)(11,12)(16,17)(22,23)(26,27),
 ( 7,12)( 8,28)(10,34)(15,35)(21,36)(25,37)(30,39)(31,41)(32,48)(33,50)
  (40,58)(43,61)(46,64)(49,67)(52,70)(55,73)(57,74)(59,75)(63,76)(65,77)
  (69,78)(71,79),( 4,6)( 9,11)(14,15)(19,20)(23,25),
 ( 4,5)( 8,9)(12,14)(16,18)(21,22),( 1,5)( 9,12)(13,16)(17,20)(24,25)
  (29,30)(31,32)(36,37)(38,39)(43,44),( 1,3)( 2,11)( 6,23)( 9,25)(12,27)
  (16,29)(19,31)(21,33),( 2,4)( 7,9)(11,12)(13,15)(17,18),
 ( 5,6)( 9,10)(12,13)(16,17)(18,19)(20,21)(23,24)(28,29),
 ( 2,8)( 3,10)( 4,12)( 6,14),( 1,3)( 2,5)( 7,11)( 8,14)(12,15)(13,16),
 ( 2,8)( 5,9)(10,14)(11,15)(12,16)(13,17),
 ( 4,13)( 6,16)( 7,19)( 8,20)(10,21)(12,24)(14,25),
 ( 3,10)( 6,12)( 7,14)( 8,17)(15,20)(18,22),
 ( 7,9)(11,13)(15,17)(18,21)(23,26)(27,29)(31,33)(35,37)(39,41)(42,45)
  (47,50)(51,53),( 4,5)( 9,10)(13,14)(17,18)(22,23),
 ( 7,9)(11,12)(14,16)(17,19)(20,21)(23,24)(26,28)(29,31)(33,35)(36,38)
  (40,41)(43,44)(45,47)(48,50)(52,53),( 3,4)( 9,10)(12,13),
 ( 3,10)( 6,12)( 7,13)( 8,15)(14,17)(16,18),( 1,2)( 7,8)(14,15)(21,22),
 ( 3,7)( 8,13)(14,17)(18,23)(24,28),( 7,8)(11,12)(14,16)(18,20)(22,24)
  (26,27)(33,34)(36,38)(40,42)(44,46)(48,49),
 ( 3,4)( 9,10)(13,14)(19,20)(24,25),( 1,4)( 5,9)( 6,11),
 (12,13)(14,15)(16,18)(19,20)(21,22)(23,24)(31,32)(33,34)(35,36)(37,39)
  (40,41)(42,43)(44,45)(46,48)(49,51)(52,54)(57,59)(60,62)(63,65)(68,70),
 ( 3,4)(10,11)(17,18)(20,22)(24,26)(28,30)(32,33)(39,40)(42,44)(46,48)
  (50,52),( 7,21)( 8,25)( 9,30)(12,33)(18,34)(22,35)(27,36)(28,37)(31,38)
  (32,47)(39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(56,74)(62,75)(68,76),
 ( 1,10)( 3,12)( 5,17)(13,22)(15,23)(20,24)(21,25),
 (10,39)(12,40)(14,41)(16,43)(18,44)(20,46)(22,47)(24,48)(26,50)(28,51)
  (30,53)(32,54)(34,55)(36,57)(38,58),(12,13)(14,15)(16,17)(18,19)(20,21)
  (22,23)(33,34)(35,36)(37,38)(40,41)(42,43)(44,45)(46,47)(49,50)(52,53)
  (55,56)(58,59)(61,62)(64,65)(67,68),( 2,3)(10,11)(16,18)(19,20)(23,24)
  (26,27)(30,31),( 6,7)(11,12)(15,16)(17,18)(21,22)(23,24)(26,27),
 ( 8,9)(12,13)(15,16)(19,20)(23,24)(28,29)(32,33)(36,37)(39,40)(43,44)
  (47,48)(52,53),( 2,25)( 3,26)( 4,27)( 6,28)( 8,30)( 9,32)(11,33)(13,34)
  (14,35)(16,37)(18,39)(19,40)(20,41)(22,42)(23,44),
 ( 4,7)( 8,10)(11,14)(15,17)(18,21)(22,25),
 ( 1,4)( 2,6)( 7,11)( 8,13)( 9,15),( 1,19)( 2,21)( 3,22)( 4,23)( 5,24)
  ( 6,26)( 7,28)( 8,29)( 9,30)(10,31),( 7,8)( 9,12)(13,16)(17,19)(20,23)
  (24,27)(31,34)(35,38)(39,41)(42,45)(46,49),
 ( 9,39)(11,40)(13,41)(15,43)(17,44)(19,46)(21,47)(23,48)(25,50)(27,51)
  (29,53)(31,54)(33,55)(35,57)(37,58),( 1,8)( 3,11)( 7,17)(10,22)(12,23)
  (14,26)(16,27),( 1,4)( 5,9)( 6,10),( 2,8)( 3,9)( 5,10),
 ( 9,11)(12,13)(15,16)(17,19)(21,22)(24,25)(26,28)(29,31)(33,34)(35,37)
  (38,39)(41,43)(44,46)(47,48)(50,51),( 4,6)( 5,7)( 8,11)( 9,15),
 ( 6,7)(10,11)(16,17)(22,23)(25,26)(29,30)(34,35)(51,52)(56,57)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78),( 2,11)( 3,14)( 4,15)( 5,17)( 8,19)
  ( 9,21)(10,22)(13,23)(18,24)(20,25),( 7,8)(10,11)(13,14)(17,18)(20,21)
  (24,25)(32,33)(37,38)(41,42)(46,47),( 1,5)( 6,11)(10,12),
 (10,12)(13,15)(16,18)(20,21)(22,24)(25,26)(28,29)(30,32)(34,35)(37,38)
  (40,42)(43,44)(46,47)(48,50)(51,52),( 6,7)(10,11)(16,17)(22,23)(25,26)
  (29,30)(34,35)(52,53)(57,58)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 7,8)(12,13)(17,18)(20,21)(23,24)(27,28)(30,31)(34,35)(37,38),
 ( 3,10)( 5,11)( 7,12)( 9,15)(14,18)(17,19),
 ( 4,5)( 9,10)(13,14)(15,17)(18,19)(20,22)(23,24)(25,27),
 ( 4,5)( 9,10)(12,13)(17,18)(22,23)(27,28)(32,33)(37,38),
 ( 1,8)( 4,13)( 6,17)( 7,19)( 9,23)(16,24),
 ( 2,9)( 6,15)( 7,19)(10,20)(12,23)(14,24)(16,27),
 ( 4,5)( 9,10)(13,14)(16,17)(20,21),( 1,9)( 2,13)( 5,18)( 7,21)(12,23)
  (19,24),( 4,5)( 8,9)(13,14)(17,18)(22,23)(26,27),
 ( 3,7)( 8,12)(13,18)(19,23)(24,28),( 7,8)(10,11)(14,15)(17,18)(21,22)
  (24,25),( 2,3)(11,12)(15,16)(18,19)(20,21)(23,24),
 (12,13)(14,15)(16,18)(19,20)(21,22)(23,24)(31,33)(34,35)(36,37)(38,39)
  (40,42)(43,44)(45,46)(47,48)(49,51)(54,56)(57,59)(60,62)(65,67)(68,70),
 ( 4,5)( 7,8)(11,12)(14,15)(17,18)(20,21)(23,24),
 ( 4,6)( 8,10)(11,13)(14,15)(17,19)(22,24)(27,29)(30,32),
 ( 2,11)( 3,12)( 5,13)( 6,14)( 7,15)( 8,16),( 7,8)( 9,10)(12,13),
 ( 7,8)(12,13)(17,18)(23,24)(27,28),( 7,12)( 8,21)( 9,29)(20,33)(26,34)
  (31,39)(32,48)(35,53)(37,56)(38,57)(40,60)(41,61)(43,64)(44,65)(46,68)
  (47,69)(49,72)(50,73)(52,76)(54,77)(62,78)(70,79),
 ( 8,9)(11,13)(15,16)(18,20)(21,23)(24,25)(27,28)(30,32)(33,35)(37,39)
  (40,42)(44,45)(47,48)(49,51)(52,54),(12,13)(14,15)(16,17)(18,19)(20,21)
  (23,24)(33,34)(36,37)(38,39)(40,41)(42,43)(45,46)(47,48)(49,50)(51,52)
  (54,55)(57,58)(60,61)(63,64)(66,67),( 5,6)( 8,9)(12,13)(15,16)(19,20)
  (23,24),( 9,10)(14,15)(18,19)(22,23)(25,26)(29,30)(33,34)(38,39)(42,43)
  (46,47)(49,50)(53,54),( 9,11)(12,13)(14,17)(19,20)(21,22),
 ( 4,6)( 8,12)(13,16)(18,21)(22,26),( 2,3)(10,12)(17,18)(19,20)(22,23)
  (26,27)(29,30),( 4,5)(11,13)(15,17)(19,21)(24,25)(27,28)(31,32)(34,35)
  (38,39)(41,42),( 4,5)( 8,9)(14,15)(18,19)(21,22)(25,26)(27,28),
 ( 3,4)( 8,9)(11,12)(16,17)(21,22)(26,27)(31,32)(36,37),
 ( 4,6)( 7,9)(10,13)(14,17)(18,20)(21,23)(24,26)(27,30)(31,34)(35,37)
  (38,40)(41,43)(44,47)(48,51)(52,54),( 6,9)(10,11)(13,14),
 ( 4,5)( 9,10)(12,13)(15,16)(18,19),( 7,9)(10,13)(15,18)(19,21)(23,25)
  (27,29)(31,33)(34,37)(39,42)(43,45)(47,49)(51,53),
 ( 1,24)( 3,25)( 4,26)( 6,28)( 8,30)( 9,31)(11,32)(13,33)(14,35)(15,37)
  (17,38)(18,39)(20,40)(21,42)(22,44),( 6,7)(10,11)(16,17)(20,21)(23,24)
  (25,26)(27,28),( 2,5)( 3,10)(11,13)(12,14),
 ( 7,9)(10,11)(13,15)(17,19)(20,21)(23,25)(26,28)(29,31)(33,34)(35,37)
  (39,41)(43,44)(45,47)(49,50)(52,53),( 6,7)(10,11)(16,17)(21,22)(26,27),
 ( 1,8)( 2,10)( 3,13)( 4,16)( 5,18),( 9,10)(12,13)(16,17)(18,19)(22,23)
  (24,25)(27,28)(42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(59,60)(63,64)
  (65,66)(69,70)(71,72)(75,76),( 5,6)( 8,9)(12,13)(18,19)(22,23)(26,27)
  (28,29),( 8,9)(13,14)(17,18)(21,22)(24,25)(28,29)(32,33)(37,38)(41,42)
  (45,46)(48,49)(52,53),( 5,6)( 9,11)(13,15)(17,19)(21,22)(28,29)(31,33)
  (35,37)(39,41)(43,44)(50,51),( 1,3)( 9,10)(16,18)(20,22)(24,25)(27,28)
  (31,32)(34,35)(38,39)(41,42),( 6,7)( 9,10)(13,14)(16,17)(19,20)(24,25)
  (29,30)(34,35)(39,40)(44,45),( 7,8)(12,13)(17,18)(22,23)(27,28),
 ( 7,21)( 8,29)(18,34)(20,35)(24,36)(26,37)(30,38)(31,43)(32,47)(33,52)
  (39,57)(42,60)(45,63)(48,66)(51,69)(54,72)(56,74)(58,75)(62,76)(64,77)
  (68,78)(70,79),( 8,10)(11,12)(14,17)(19,20)(21,23),
 ( 1,4)( 2,7)( 6,10)( 8,12),( 6,8)(10,11)(14,15),
 ( 5,6)(10,11)(15,16)(20,21)(24,25)(27,28)(31,32)(34,35)(38,39),
 ( 2,4)( 5,7)(10,12),( 9,11)(12,13)(15,17)(18,20)(21,23)(25,26)(27,29)
  (30,31)(33,34)(35,37)(39,40)(42,43)(45,47)(48,49)(51,52),
 ( 6,7)(10,12)(14,16)(18,20)(22,23)(29,30)(32,34)(36,38)(40,42)(44,45)
  (51,52),( 1,10)( 2,15)( 3,23)( 6,25)(11,27)(16,29)(21,31),
 ( 4,9)( 6,10)( 7,11)( 8,14)(12,15)(13,16),( 1,4)( 2,9)( 5,10),
 ( 1,25)( 2,26)( 3,27)( 5,28)( 7,30)( 8,32)(10,33)(12,34)(13,35)(15,37)
  (17,39)(18,40)(19,41)(21,42)(22,44),(1,2)(3,4)(5,7),
 ( 4,6)( 8,10)(12,13)(17,18)(21,23)(25,26)(28,29)(35,36)(40,41)(48,49)
  (59,60)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78)(79,80)(81,82),
 ( 2,6)( 3,7)( 8,12)( 9,16),( 1,6)( 3,10)( 5,12),
 ( 1,9)( 4,11)( 7,14)(12,16)(15,17),( 4,5)( 7,9)(12,14)(15,16)(21,23)
  (26,27)(28,29),(10,40)(12,41)(14,43)(16,44)(18,45)(20,47)(22,48)(24,50)
  (26,51)(28,52)(30,54)(32,55)(34,57)(36,58)(38,59),
 ( 3,4)( 7,8)(11,12)(14,15)(19,20),( 4,5)( 8,9)(14,16)(19,20)(23,24)
  (26,27)(30,31),( 1,9)( 3,12)( 6,15)(11,16)(14,17),
 ( 2,4)( 5,6)( 8,10),( 3,7)( 8,13)(14,18)(19,23)(24,28),
 ( 6,7)( 9,10)(15,16)(19,20)(22,23)(26,27)(32,33)(37,38)(41,42)(46,47),
 ( 3,7)( 8,12)(13,18)(19,22)(23,28),( 1,9)( 4,11)( 7,14)( 8,17)(13,19)
  (16,21),( 8,11)(12,14)(16,18)(20,22)(24,26)(27,30)(32,35)(36,38)(40,42)
  (44,46)(48,50)(51,54),(12,13)(14,15)(16,17)(18,19)(20,22)(23,25)(34,36)
  (37,39)(40,42)(43,45)(46,48)(49,51)(52,54)(55,56)(57,58)(59,61)(62,63)
  (64,65)(66,68)(69,70)(71,72),( 2,8)( 3,11)( 5,14)(13,22)(15,23)(17,26)
  (19,27),( 1,8)( 4,12)( 5,14)( 6,18),( 3,10)( 5,11)( 6,12)( 7,14)(13,18)
  (15,19),(12,13)(14,15)(17,18)(19,20)(21,22)(24,25)(27,28)(37,38)(39,40)
  (43,44)(45,46)(47,48)(51,52)(54,55)(57,58)(60,61)(63,64)(66,67)(69,70),
 ( 8,10)(11,13)(15,17)(19,20)(22,24),( 1,10)( 4,12)( 7,15)( 8,18)(13,20)
  (16,22),( 6,8)(10,13)(15,17)(19,21)(24,26),
 ( 4,6)( 8,9)(11,13)(16,18)(20,22)(25,26)(30,31),
 ( 3,4)( 6,7)(12,14)(21,22)(24,25)(28,29)(31,32),
 ( 4,7)( 8,10)(11,13)(14,16)(17,19)(20,23),
 ( 5,7)( 9,10)(12,14)(17,19)(21,22)(23,25),( 4,8)( 7,9)(10,14)(12,15),
 ( 2,6)( 3,7)( 9,15)(11,17),( 7,8)( 9,10)(13,14)(16,17)(20,21)(23,24),
 ( 4,7)( 9,12)(14,17)(18,22)(23,26),( 1,10)( 4,13)( 7,15)( 9,16)(12,17),
 ( 6,19)( 8,20)( 9,22)(10,23)(11,24)(13,26)(14,27)(16,29)(17,30)(18,31),
 ( 1,2)( 4,5)(11,12)(15,16)(18,19),( 1,3)( 5,8)(10,12)(14,16),
 ( 1,5)( 3,13)( 7,21)(12,24)(14,28)(18,29)(20,32)(23,35)(27,36)(31,37)
  (34,38),( 4,5)( 9,10)(12,13)(14,15)(19,20),
 ( 5,6)( 8,10)(13,15)(17,18)(19,21)(23,25),
 ( 5,7)(10,12)(15,17)(20,21)(25,26),( 5,6)(10,11)(14,15)(18,19)(21,22)
  (23,24)(28,29),(10,39)(12,40)(14,42)(16,43)(18,45)(20,46)(22,47)(24,49)
  (26,50)(28,52)(30,53)(32,54)(34,56)(36,57)(38,59),
 ( 9,11)(13,14)(15,17)(19,21)(22,23),( 2,11)( 3,12)( 4,13)( 5,14)( 7,15)
  ( 8,16),( 3,4)( 6,7)(11,12)(16,17)(21,22)(26,27)(31,32),
 ( 3,4)( 6,7)(11,12)(16,17)(19,20),(11,12)(14,15)(18,19)(21,22)(23,24)
  (26,27)(29,30)(35,36)(37,38)(41,42)(43,44)(45,46)(49,50)(51,52)(53,54)
  (55,56)(57,58)(59,60)(61,62),( 3,4)( 6,7)(11,12)(18,20)(23,25)(28,30)
  (33,35)(38,40)(43,45),( 5,8)( 7,9)(11,14)(13,15),
 ( 1,4)( 5,8)(12,15)(18,19)(23,24),( 3,6)( 8,11)(12,16)(17,20)(22,25),
 (11,12)(14,15)(17,18)(19,20)(21,22)(24,25)(26,27)(37,38)(41,42)(43,44)
  (45,46)(49,50)(51,52)(53,54)(56,57)(59,60)(62,63)(65,66)(68,69),
 ( 5,6)(10,11)(15,16)(20,21)(26,27),( 4,5)( 7,8)(11,12)(13,14)(17,19),
 ( 4,5)( 7,8)(10,11)(18,19)(23,24)(25,26)(29,30)(31,32),
 ( 4,5)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18),( 2,3)( 6,8)( 7,11),
 (3,6)(4,8)(5,9),( 1,2)(11,12)(14,15)(17,18)(21,22)(23,24)(25,26)(27,28)
  (29,30)(31,32),( 3,6)( 4,8)( 9,12)(10,16),
 ( 9,31)(12,34)(13,35)(15,36)(17,38)(19,39)(21,40)(24,41)(26,43)(29,44)
  (45,58)(46,60)(49,62)(50,64)(51,65)(52,66)(55,68)(56,69)(57,71)(72,74)
  (73,76),( 1,2)( 3,4)( 5,6)( 9,10)(13,14)(17,18)(21,22),
 ( 1,21)( 2,22)( 3,23)( 4,25)( 5,27)( 6,28)( 7,30)( 8,32)(17,33)(18,34)
  (19,35)(20,36),( 4,6)( 8,10)(12,14)(21,23)(25,26)(28,30)(33,35)(52,53)
  (56,57)(60,62)(63,65)(66,68)(69,71)(72,74)(75,77),
 ( 1,3)( 4,5)( 6,8)( 9,11)(12,13),( 5,6)(10,11)(14,15)(17,18)(24,25)
  (27,28)(31,32)(45,46)(54,55)(58,59)(60,61)(63,64)(65,66)(68,69)(70,71)
  (73,74)(75,76)(78,79)(80,81)(83,84)(85,86),
 ( 3,5)( 7,10)(11,13)(14,17)(19,21)(23,25)(27,29)(32,34),
 ( 3,5)( 7,10)(11,13)(14,17)(19,21)(23,25)(28,30)(32,34),
 (11,13)(15,16)(19,21)(22,24)(33,34)(35,36)(40,41)(42,44)(48,49)(50,52)
  (53,54)(56,57)(59,60)(62,63)(65,66)(68,69)(71,72)(73,74)(75,76),
 ( 1,3)( 2,5)( 6,10)( 8,12)( 9,14),( 1,7)( 2,10)( 4,13)( 6,16),
 ( 4,34)( 7,35)( 9,36)(16,37)(25,38)(28,39)(31,40)(41,59)(42,60)(44,64)
  (45,65)(46,69)(48,70)(49,74)(50,75)(52,79)(53,80)(54,84)(56,85)(61,87)
  (63,88)(71,89)(73,90)(81,91)(83,92),( 1,4)( 3,9)( 6,10),
 ( 1,3)( 8,9)(11,12)(14,15)(16,17)(18,19),
 ( 5,7)(10,12)(14,16)(19,21)(24,26),( 4,7)(11,14)(15,17)(18,20)(22,25)
  (27,30)(31,34)(35,37)(38,39)(43,44)(47,48)(60,62)(63,65)(66,68)(69,71)
  (72,74)(75,77),( 4,37)( 6,39)( 9,40)(12,41)(15,42)(18,44)(21,45)(25,46)
  (28,48)(31,49)(34,50)(51,61)(52,64)(55,67)(56,70)(57,73)(60,76)(65,79)
  (71,80)(77,81),( 1,11)( 2,14)( 5,17)( 7,19)(12,21)(16,24),
 ( 5,6)(10,11)(14,15)(17,18)(20,21)(23,24)(26,27)(31,32),
 ( 5,6)(10,11)(13,14)(16,17)(19,20)(22,23)(26,27),( 1,5)( 3,8)( 4,10),
 ( 5,36)( 8,37)(12,38)(15,39)(22,40)(32,41)(35,42)(43,59)(45,62)(46,63)
  (47,66)(49,67)(50,70)(51,71)(53,74)(54,75)(55,78)(57,79)(58,82)(64,83)
  (65,84)(72,85)(73,86)(80,87)(81,88),( 3,5)( 8,9)(12,14)(17,19)(22,23)
  (26,28),( 7,29)( 10,30)( 14,31)( 19,32)( 21,33)( 24,34)( 27,35)
  ( 38,50)( 39,54)( 41,55)( 42,59)( 45,60)( 46,62)( 49,66)( 51,79)
  ( 53,80)( 58,81)( 63,82)( 65,83)( 69,86)( 70,89)( 72,92)( 75,95)
  ( 76,98)( 78,101)( 84,102)( 87,104)( 90,106)( 93,108)( 96,110)( 99,112)
  (103,114)(107,115)(111,116),( 2,11)( 4,17)( 6,19)( 8,23)(13,24)(16,25)
  (22,26),( 1,5)( 2,9)( 4,11)( 7,13),( 2,3)( 5,6)(10,11)(14,15)(17,18)
  (20,21),( 2,5)( 6,10)( 7,11)( 8,12),( 6,7)(16,17)(20,21)(29,30)(31,32)
  (35,36)(40,41)(44,45)(50,51)(52,53)(55,56)(58,59)(61,62)(63,64)(66,67)
  (69,70)(71,72)(73,74)(75,76),( 1,2)( 3,9)( 5,10),
 ( 1,9)( 2,11)( 4,13)( 6,14)(10,15)(12,16),
 ( 4,5)( 9,10)(12,14)(17,18)(21,23)(25,26)(30,31)(33,35)(38,39)(42,44),
 ( 6,8)(12,14)(17,19)(22,23)(27,29)(33,34)(37,39)(42,44)(48,50)(53,54),
 ( 6, 7)( 12,13)( 19,20)( 26,27)( 41,42)( 46,47)( 49,50)( 53,54)
  ( 57,58)( 59,60)( 62,63)( 66,67)( 68,69)( 72,73)( 74,75)( 79,80)
  ( 87,88)( 90,91)( 93,94)( 96,97)( 99,100)(102,103)(104,105)(107,108)
  (110,111)(113,114)(116,117)(119,120),( 2,3)( 6,7)(10,11)(20,21)(25,26)
  (28,29)(33,34)(37,38)(40,41)(44,45)(48,49)(51,52),
 ( 4,5)( 9,10)(15,16)(20,21)(26,27),( 4,6)( 9,10)(13,15)(18,20)(23,24)
  (27,29),( 2,24)( 4,26)( 6,27)( 8,28)(10,31)(11,32)(13,33)(15,34)(16,35)
  (18,38)(20,39)(21,40)(23,41)(25,43)(29,45)(30,46)(36,48)(37,49)(42,50)
  (44,51)(47,52),( 4,5)(11,12)(14,15)(17,18)(21,22)(27,28)(30,31)(34,35)
  (36,37),( 1,7)( 2,9)( 4,11)( 6,12)( 8,14),
 ( 5,6)(10,12)(16,17)(20,22)(25,27)(31,33)(36,37)(40,42)(46,48)(51,53),
 ( 1,3)( 5,7)(10,12)(15,16)(19,21),( 1,3)( 6,8)(11,13)(15,17)(19,21),
 ( 1,4)( 3,10)( 7,12),( 2,3)( 6,7)(11,12)(14,15)(17,18)(20,21),
 ( 1,2)( 3,4)( 5,6)( 9,10)(12,13)(17,18)(19,20),
 ( 2,10)( 4,17)( 6,21)( 8,23)(12,24)(16,25)(20,26),
 ( 2,8)( 4,9)( 6,10)( 7,15)(11,18)(14,20),( 1,6)( 5,10)( 8,11),
 ( 4,11)( 6,13)( 7,14)( 8,16)( 9,17)(10,19),
 ( 4,5)( 7,8)(14,15)(19,20)(21,22)(23,24),
 ( 8,9)(10,12)(15,17)(18,19)(21,24),( 7, 9)( 14,16)( 19,20)( 23,24)
  ( 25,27)( 37,38)( 39,40)( 44,45)( 47,49)( 52,53)( 57,58)( 64,65)
  ( 67,69)( 70,71)( 73,75)( 76,77)( 84,85)( 87,88)( 90,91)( 93,94)
  ( 96,97)( 99,100),( 1,2)( 3,4)( 5,6)(10,11)(13,14)(19,20)(22,23),
 ( 1,10)( 3,13)( 6,17)( 8,20)(11,22)(16,24),
 ( 2,3)( 6,7)(10,11)(21,22)(26,27)(28,29)(33,34)(37,38)(39,40)(42,43)
  (45,46)(47,48),( 2,3)( 5,7)( 9,11)(13,14)(16,18)(19,20)(22,23)(24,25)
  (26,27)(29,30)(31,32)(34,35)(36,37)(38,39)(41,42)(43,44)(46,47)(48,49)
  (50,51)(53,54),( 6,7)( 9,10)(12,13)(15,16)(19,20),
 ( 1,11)( 3,14)( 6,17)( 8,19)(12,22)(16,25),
 ( 1,24)( 3,27)( 5,28)( 7,29)( 9,31)(11,32)(13,33)(14,34)(16,35)(18,38)
  (19,39)(21,40)(23,41)(25,42)(26,43)(30,45)(36,47)(37,48)(44,50)(46,51)
  (49,52),( 5,6)(10,12)(15,17)(20,22)(25,27)(30,32)(36,37)(40,42)(46,47)
  (51,53),( 1,8)( 2,13)( 3,20)( 5,22)( 9,26)(14,28)(18,32),
 ( 5,7)(10,12)(15,17)(19,21)(23,25),( 2,7)( 4,14)( 6,18)( 9,23)(13,24)
  (17,25)(21,26),( 4,5)( 6,7)( 8,9)(12,13)(14,15),
 ( 1,3)( 2,6)( 5,9)(10,12)(11,13),( 2,3)( 5,8)( 9,12)(17,20)(21,24),
 ( 4,6)( 7,9)(10,12)(15,17)(19,20)(25,26)(31,32),
 ( 1,5)( 2,13)( 3,18)( 7,24)(12,26)(17,28)(22,30),
 ( 1,2)( 3,4)( 5,6)( 9,11)(15,17)(18,20)(21,23)(24,26),
 ( 1,2)( 5,8)(11,12)(15,16),( 1,2)( 5,6)(16,17)(20,21)(25,26)(27,28)
  (31,32)(33,34),( 4,14)( 7,15)( 8,17)( 9,18)(12,20)(13,21),
 ( 1,9)( 3,10)( 5,12)( 6,13)( 8,15)(11,16)(14,17),( 1,3)( 4,10)( 8,12),
 ( 4,5)( 8,9)(12,13)(18,19)(22,23)(25,26)(28,29),
 (13,15)(16,17)(18,19)(20,22)(23,25)(26,27)(31,33)(34,35)(36,37)(38,39)
  (40,42)(43,44)(45,46)(47,48)(49,50)(51,52)(53,54)(56,57)(58,59)(60,61),
 ( 4,5)( 7,9)(12,13)(15,16)(19,21)(25,26)(30,31)(34,35),
 ( 1,2)( 8,9)(15,16)(19,21)(28,29)(31,33)(35,36)(39,40)(42,43)(45,46)
  (49,50)(52,53),( 1,7)( 2,9)( 4,11)( 6,13)(10,14)(12,15),
 ( 4,6)( 8,10)(13,15)(18,20)(22,24)(27,29),( 1,3)( 4,6)(10,12)(13,15),
 ( 1,4)( 8,17)(11,26)(12,29)(15,38)(19,41)(20,42)(27,45)(28,46)(35,49)
  (36,50),( 4, 6)( 12,13)( 14,17)( 21,23)( 25,26)( 29,31)( 42,43)
  ( 47,48)( 50,51)( 54,55)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 70,71)( 82,83)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105),
 ( 1,3)( 4,6)(11,13)(14,17)(22,24)(26,28)(33,36)(37,39)(47,48)(51,52)
  (55,56)(59,60)(64,65)(68,69)(72,73)(76,77),
 ( 4,20)( 5,24)( 7,25)( 9,26)(10,27)(12,30)(13,32)(16,33)(18,34)(21,35)
  (28,36),( 1,2)(10,11)(13,14)(17,18)(21,22)(25,26),
 ( 4,7)(11,12)(13,14),( 4,21)( 7,22)( 8,23)(10,26)(12,27)(14,28)(15,29)
  (17,31)(20,32)(25,33)(30,35),( 3,6)( 4,8)(10,13)(11,15),
 ( 3,5)( 6,9)(11,13)(14,17),( 1,4)( 6,9)(10,13)(15,18)(20,23),
 ( 2,3)( 6,7)(11,12)(15,16)(19,20)(23,24),
 ( 2,7)(10,17)(11,21)(23,30)(25,32)(26,36)(27,41)(28,45)(33,51)(34,53)
  (37,56)(39,59)(42,62)(43,64)(46,67)(48,70)(54,72)(60,74)(68,76),
 ( 1,3)( 8,11)( 9,12)(10,13),( 6,7)(11,12)(15,16)(20,21)(23,24)(31,32),
 ( 2,4)(10,12)(14,16)(17,19)(20,22)(24,26),
 ( 3,11)( 5,13)( 7,15)( 9,16)(18,20)(19,26),( 1,5)( 2,9)( 4,11)( 6,13),
 ( 2,4)(10,12)(14,15)(18,20)(22,23),( 1,10)( 3,17)( 5,21)( 7,23)(11,24)
  (15,25)(19,26),( 1,2)(10,11)(14,15)(19,20)(23,24),
 ( 1,7)( 3,10)( 4,13)( 6,16),( 2,3)( 5,8)(10,12)(17,20)(22,24),
 ( 5,6)( 8,10)(13,14)(16,18),( 4,21)( 6,22)( 8,25)(10,26)(11,27)(13,28)
  (16,31)(17,32)(20,33)(24,34)(30,35),( 5,32)( 8,33)(16,34)(23,35)(26,36)
  (29,37)(38,59)(39,60)(41,62)(42,65)(43,67)(46,70)(47,72)(48,75)(49,76)
  (51,78)(52,81)(53,83)(56,86)(57,88)(63,90)(64,91)(73,92)(74,93)(84,94)
  (85,95),( 3,5)( 8,10)(13,15)(20,22)(27,28)(35,36)(40,41),
 ( 3,11)( 5,12)( 7,14)( 9,16)(18,21)(19,27),
 ( 1,8)( 3,11)( 6,15)( 9,18)(13,20),( 2,6)( 5,7)( 9,13)(11,14),
 ( 5,37)( 8,39)(10,40)(13,41)(16,42)(19,44)(22,45)(27,46)(29,48)(33,49)
  (36,50)(51,61)(53,64)(55,67)(56,70)(58,73)(60,76)(66,79)(72,80)(78,81),
 ( 1,4)( 5,12)( 7,13)( 8,14)( 9,15)(10,16)(11,17),
 ( 4, 6)( 11,14)( 17,19)( 21,22)( 25,28)( 38,39)( 41,43)( 44,45)
  ( 46,48)( 49,51)( 54,55)( 56,58)( 60,61)( 63,64)( 65,67)( 69,70)
  ( 71,73)( 74,76)( 79,81)( 86,88)( 89,91)( 92,94)( 95,97)( 98,100)
  (101,103)(105,106)(108,109)(111,112)(114,115)(117,118)(120,121),
 ( 2,4)( 6,8)(11,13)(16,18)(20,22),( 4,6)( 9,11)(13,15)(18,20)(23,25)
  (27,29),( 1,4)( 2,10)( 3,14)( 5,20)( 9,23)(13,26)(16,28)(19,31)(21,33)
  (24,35)(29,37),( 2,3)( 6,7)(10,11)(19,20)(25,26)(27,28)(32,33)(38,39)
  (41,42),( 4,7)( 8,10)(12,14)(17,19)(23,25)(30,32),
 ( 1,8)( 3,14)( 5,22)( 9,23)(12,24)(17,25)(19,26),
 ( 4,5)( 6,8)(11,13)(15,17)(20,22),(1,5)(3,8)(4,9),
 ( 2,3)( 5,6)( 9,10)(11,12)(28,29)(30,31)(32,33)(34,35)(62,63)(64,65)
  (66,67),( 3,6)( 4,9)( 5,10),( 1,8)( 3,12)( 5,20)(10,21)(13,22)(18,25)
  (23,28)(26,29),( 4,7)( 6,8)( 9,13)(11,15),
 (13,15)(17,18)(20,22)(27,29)(31,32)(34,36)(41,42)(43,44)(45,46)(47,48)
  (49,50)(51,52),( 1,6)( 2,9)( 4,11),( 1,4)( 2,8)( 3,10)( 6,13)( 7,15)
  (11,18)(16,21)(19,23),( 4,6)(10,11)(17,18)(19,20)(23,24)(27,28)(31,32)
  (35,36)(39,40)(43,44)(47,48)(51,52),( 1,8)( 3,9)( 4,12)( 5,13)( 7,16)
  (11,17)(15,18),( 2,6)( 3,7)( 4,10)( 5,12),
 ( 1,2)( 3,5)( 6,8)( 9,10)(11,13),( 1,5)( 2,9)( 3,18)(10,24)(16,27)
  (19,30)(22,33)(25,36),( 1,3)( 4,8)( 5,10),
 ( 9,25)( 11,28)( 12,29)( 14,30)( 15,32)( 18,33)( 21,35)( 24,36)
  ( 37,50)( 40,52)( 41,56)( 42,59)( 43,61)( 46,63)( 47,65)( 48,69)
  ( 54,72)( 62,73)( 67,74)( 70,77)( 71,85)( 78,92)( 82,95)( 86,98)
  ( 89,101)( 91,102)( 93,107)( 96,108)(104,111)(106,118)(112,124)(113,125)
  (115,128)(120,129)(131,137)(133,141),( 1,4)( 2,9)( 3,11),
 ( 3,6)( 4,7)( 8,13)( 9,17),( 7,13)( 8,16)( 9,23)(10,26)(11,33)(24,35)
  (29,37)(30,40)(31,45)(32,48)(38,54)(42,57)(44,60)(46,63)(50,66)(52,69)
  (53,71)(59,73)(65,75),( 1,6)( 2,8)( 3,12)( 5,15)( 9,18)(10,20)(14,22)
  (17,24),( 9,10)(11,13)(15,16)(17,19)(20,21)(23,24),
 ( 4,21)( 6,22)( 8,25)( 9,26)(11,27)(14,28)(15,31)(18,32)(19,33)(24,34)
  (30,35),( 6,8)(12,13)(16,18)(22,23)(27,29)(32,33)(37,39)(42,44)(47,49)
  (52,54),( 5,7)( 8,9)(10,11),( 9,11)(14,16)(18,20)(22,25)(27,29)(31,33)
  (36,38)(40,42)(44,47)(49,51),( 2,5)( 8,11)(13,15)(16,19)(21,23),
 ( 4,7)( 8,12)(13,17)(18,19)(20,24),( 1,5)( 2,13)( 3,19)( 8,23)(11,25)
  (20,28)(26,31)(29,33),( 2,4)( 5,9)( 6,10),
 ( 1,3)( 4,5)(15,16)(18,19)(21,22),( 2,4)( 5,10)( 7,11),
 ( 1,2)( 8,10)(13,15)(16,18)(20,22)(23,24)(28,29)(31,33)(34,36)(38,39)
  (43,44)(45,47)(49,51),( 3,7)( 6,13)( 8,14)( 9,15)(10,16)(11,17)(12,19)
  (18,21)(20,22),( 4,5)( 9,10)(16,17)(21,22)(26,27)(33,34),
 ( 9,28)( 12,29)( 14,30)( 17,31)( 21,32)( 24,33)( 27,34)( 35,51)
  ( 38,55)( 39,56)( 42,60)( 45,61)( 47,63)( 50,67)( 53,80)( 57,81)
  ( 58,82)( 62,83)( 65,84)( 68,87)( 70,90)( 71,93)( 74,96)( 76,99)
  ( 77,102)( 86,103)( 89,105)( 92,107)( 95,109)( 98,111)(101,113)(106,115)
  (110,116)(114,117),( 1,2)(10,11)(13,14)(17,18)(20,21),
 ( 1,4)( 5,11)( 6,12)( 7,15)( 8,16)(13,19)(14,20)(17,21)(18,22),
 (10,11)(15,16)(19,20)(25,26)(29,30)(34,35)(39,40)(43,44)(49,50)(53,54),
 ( 3,4)(13,14)(17,18)(21,22)(24,25)(27,28)(30,31)(33,34),
 ( 5, 8)( 13,14)( 15,16)( 21,22)( 30,31)( 34,35)( 36,37)( 40,41)
  ( 42,43)( 44,45)( 51,52)( 55,56)( 57,58)( 61,62)( 65,66)( 67,68)
  ( 71,72)( 75,76)( 77,78)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)(113,114)(117,118)(123,124)(125,126)(127,128)(129,130)
  (131,132)(133,134)(135,136)(139,140)(141,142)(143,144)(145,146)(147,148)
  (149,150),( 4,5)( 8,9)(12,13)(16,17)(18,19),
 ( 9,10)(12,14)(15,16)(18,19)(20,22)(23,25),( 2,5)( 3,8)( 4,10),
 ( 6,43)( 9,45)( 14,46)( 19,48)( 21,49)( 24,50)( 27,52)( 29,54)
  ( 31,55)( 32,58)( 33,60)( 34,62)( 36,63)( 37,66)( 38,68)( 40,69)
  ( 41,72)( 42,74)( 44,76)( 57,86)( 59,89)( 61,91)( 65,94)( 67,96)
  ( 71,97)( 73,100)( 75,102)( 78,103)( 81,104)( 83,106)( 84,108)( 85,110)
  ( 87,111)( 90,112)( 92,113)( 95,114)( 98,115)(101,116)(105,117)(107,118)
  (109,119),(11,13)(15,16)(17,18)(19,20)(22,24)(25,27)(28,29)(30,31)(33,34)
  (35,36)(38,40)(45,47)(48,49)(55,56)(58,59),
 (14,15)(17,18)(19,20)(22,23)(24,25)(26,27)(28,29)(31,32)(33,34)(36,37)
  (38,39)(40,41),( 1,2)( 3,9)( 5,10)( 7,12)( 8,13),
 ( 4,5)( 6,7)( 9,10)(16,17),( 7,9)(13,14)(17,19)(22,24)(28,30)(33,34)
  (37,39)(43,45)(48,50)(53,54),( 1,2)( 9,11)(12,14)(15,16)(18,20)(21,22)
  (25,26)(28,30)(31,33)(35,36)(40,41)(42,44)(48,49)(50,52)(55,56)(62,63)
  (64,66)(67,68)(71,72)(77,78)(85,86),( 1,2)( 5,7)( 9,10)(11,12),
 ( 6,7)(12,13)(17,18)(23,24)(28,29),( 1,4)( 2,9)( 3,15)( 8,23)(13,26)
  (17,28)(21,31),( 5,7)( 8,12)(13,15)(17,20)(21,24),
 ( 2,7)( 3,8)( 9,15)(11,18),( 1,6)( 2,8)( 3,9)(10,12)(11,13),
 ( 4,5)( 7,8)(12,13)(15,16),( 3,4)( 7,8)(11,12)(22,23)(27,28)(29,30)
  (34,35)(38,39)(40,41)(42,43)(45,46)(47,48),
 ( 1,2)( 4,5)( 6,7)( 9,10)(12,13)(14,15)(17,18)(19,20)(22,23)(25,26)
  (27,28)(30,31)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(56,57)(59,60)
  (62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)
  (92,93)(94,95),( 8,9)(10,11)(13,15)(16,17)(18,19)(20,21),
 ( 1,10)( 3,13)( 6,15)( 7,19)(12,22)(16,25),
 ( 2,4)( 6,8)(11,13)(16,18)(20,22)(25,27),( 3,5)( 7,8)(10,11),
 ( 4,6)(10,12)(15,16)(19,21)(25,27)(30,32)(35,36)(40,42)(46,47)(50,52),
 ( 1,23)( 3,24)( 5,28)( 6,29)( 8,30)(10,34)(12,35)(13,36)(15,37)(17,38)
  (18,42)(20,43)(22,44)(25,45)(27,46)(31,47)(33,48)(39,49)(41,50),
 ( 4,5)( 7,8)(10,11)(13,14)(17,18)(21,22),
 ( 5,6)( 9,10)(13,14)(15,16)(18,19),( 1,9)( 2,12)( 4,15)( 6,18),
 ( 3,6)(10,18)(11,22)(12,29)(25,31)(26,35)(27,40)(28,44)(33,50)(34,52)
  (37,55)(39,58)(42,61)(43,63)(46,66)(48,69)(54,71)(60,73)(68,75),
 ( 4,6)( 7,9)(10,11)(12,14)(15,17)(18,19)(20,21)(22,23)(24,25)(26,27)
  (28,29)(30,31)(32,33)(34,35),( 4,6)( 9,10)(13,14)(16,18)(22,23)(28,29),
 ( 5,7)(11,12)(15,17)(21,22)(26,28)(31,32)(36,38)(41,43)(46,48)(51,53),
 ( 6,24)( 8,25)( 11,26)( 15,27)( 23,28)( 29,51)( 31,54)( 34,58)
  ( 35,60)( 36,63)( 38,64)( 39,67)( 41,69)( 44,72)( 45,73)( 46,76)
  ( 48,77)( 49,79)( 55,88)( 57,89)( 65,90)( 66,91)( 74,92)( 75,93)
  ( 82,99)( 85,109)( 96,119)(100,123)(103,124)(106,128)(110,129)(115,133),
 ( 1,2)(10,11)(13,14)(16,17)(20,21)(24,25)(26,27)(28,29)(34,35)(37,38)
  (40,41)(43,44)(46,47)(49,50)(53,54)(57,58)(60,61)(64,65)(67,68)(71,72),
 (14,15)(16,17)(18,19)(21,22)(23,24)(26,27)(28,29)(30,31)(32,33)(35,36)
  (37,38)(40,41),(1,3)(4,6)(7,8),( 1,5)( 3,9)( 4,10),
 ( 10,37)( 11,40)( 14,41)( 16,42)( 18,43)( 19,46)( 22,47)( 24,48)
  ( 25,49)( 28,51)( 29,53)( 30,55)( 32,58)( 33,60)( 35,64)( 36,68)
  ( 39,70)( 45,71)( 50,75)( 52,79)( 56,80)( 59,81)( 61,83)( 63,87)
  ( 65,88)( 67,89)( 69,90)( 72,94)( 73,97)( 74,100)( 77,103)( 78,104)
  ( 85,105)( 86,106)( 92,110)( 93,112)( 95,114)( 96,115)( 98,117)(101,119)
  (102,121)(107,123)(108,127)(111,130)(113,131)(118,132)(120,133)(124,134)
  (125,136)(128,138)(129,140)(137,142)(141,143),
 ( 3,4)( 8,9)(12,13)(16,17)(20,21),( 1,10)( 3,18)( 5,20)( 8,21)(11,22)
  (16,25)(23,28)(26,29),( 6,8)(10,11)(12,13),( 1,4)( 3,12)( 6,14),
 ( 6,7)(10,11)(13,14)(20,21)(23,24)(27,28)(30,31)(45,46)(54,55)(58,59)
  (60,61)(63,64)(65,66)(68,69)(70,71)(73,74)(75,76)(78,79)(80,81)(83,84)
  (85,86),( 7, 8)( 11,12)( 16,17)( 19,20)( 22,23)( 35,36)( 39,40)
  ( 43,44)( 45,46)( 47,48)( 51,52)( 54,55)( 56,57)( 59,60)( 61,62)
  ( 63,64)( 66,67)( 72,73)( 78,79)( 86,87)( 89,90)( 92,93)( 95,96)
  ( 98,99)(101,102)(103,104)(105,106)(107,108)(109,110)(111,112)(113,114),
 ( 5,8)(10,13)(14,18)(20,24)(25,28)(30,33)(35,39)(41,44)(45,48)(50,54),
 ( 1,2)( 3,4)( 5,6)( 8,9)(13,14)(17,18)(22,23),
 ( 6,7)(11,12)(14,15)(17,18)(20,21)(23,24)(27,28),( 1,6)( 2,9)( 5,10),
 ( 1,11)( 3,14)( 6,17)( 8,20)(13,22)(18,24),( 1,4)( 5,10)( 7,12),
 ( 3,5)( 8,9)(12,14)(17,19)(21,23),( 3,4)( 8,9)(14,15)(19,20)(25,26),
 ( 3,4)( 7,8)(11,12)(21,22)(26,27)(29,30)(33,34)(36,37),
 ( 1,7)( 2,10)( 4,13)( 5,16),( 4, 5)( 8, 9)( 16,17)( 20,21)( 24,25)
  ( 31,32)( 43,44)( 48,49)( 50,51)( 54,55)( 56,57)( 58,59)( 61,62)
  ( 64,65)( 66,67)( 68,69)( 73,74)( 80,81)( 82,83)( 84,85)( 86,87)
  ( 89,90)( 91,92)( 93,94)( 95,96)( 99,100)(102,103)(105,106)(109,110)
  (112,113)(115,116),( 1,5)( 2,9)( 3,16)(10,23)(19,26)(22,29)(24,31)
  (27,33),( 2,10)( 4,14)( 6,18)( 8,21)(13,24)(19,27)(23,28)(26,29),
 ( 3,4)( 8,9)(13,14)(17,18)(20,21)(24,25),
 ( 5,21)( 6,22)( 9,23)(10,26)(13,27)(15,28)(16,29)(18,32)(20,33)(24,34)
  (30,35),( 2,4)( 6,8)(10,11)(13,15)(17,18)(19,20)(21,22)(23,24)(26,27)
  (28,29)(31,32)(33,34)(35,36)(38,39)(40,41)(43,44)(45,46)(47,48)(50,51)
  (52,53),( 2,8)( 4,10)( 6,13)( 7,16)(12,18)(14,20),(1,2)(3,4)(6,8),
 ( 3,4)( 7,8)(10,11)(21,22)(24,25)(27,28)(30,31),
 ( 1,4)( 2,11)( 3,15)( 6,22)( 9,24)(12,25)(16,27)(21,29)(23,30)(26,31)
  (28,32),( 1,3)( 6,8)( 9,11)(14,17)(18,20)(23,26)(27,29)(32,35)(36,38)
  (41,43)(45,46)(49,50)(52,53)(55,56)(58,59)(62,63)(66,67)(69,70)(72,73)
  (75,76),( 5,6)( 9,10)(13,15)(17,19)(23,24)(30,31),
 ( 6,33)( 8,34)(11,35)(21,36)(26,37)(29,38)(32,39)(40,59)(41,62)(44,64)
  (45,67)(46,69)(48,72)(49,74)(50,77)(53,79)(54,82)(55,84)(57,87)(60,88)
  (61,89)(70,90)(71,91)(80,92)(81,93),( 1,3)( 8,10)(11,13)(18,20)(21,24)
  (29,31)(33,35)(40,43)(46,47)(51,52)(55,56)(59,60)(63,64)(68,69)(72,73)
  (76,77),( 5,6)( 8,9)(11,12)(15,16)(21,22)(25,26),
 ( 1,7)( 3,9)( 6,13)(10,17)(14,19),( 8,9)(10,11)(13,14)(15,16),
 ( 4,7)( 8,10)(11,13)(14,16)(17,20),( 3,5)( 6,8)(11,13)(14,16)(19,21)
  (22,25)(28,30)(31,34)(37,39)(40,43)(44,45)(48,49)(52,53)(55,56)(58,59)
  (61,62)(65,66)(69,70)(72,73)(75,76),( 1,7)( 2,9)( 3,10)( 6,13),
 ( 6,7)(10,11)(13,14)(18,19),( 6,8)(11,12)(13,14)(18,20)(23,24),
 ( 1,2)( 3,10)( 5,11)( 7,13)( 8,14),( 1,7)( 2,9)( 3,10)( 6,12),
 ( 3,4)( 9,10)(15,16)(18,20)(23,25)(31,32)(33,35)(38,39)(42,44)(45,46)
  (48,50)(53,55)(56,57)(59,61),( 1,6)( 2,11)( 3,20)(10,22)(13,25)(19,28)
  (27,31)(30,34),( 3,4)( 9,10)(15,16)(20,21)(26,27),
 ( 4,15)( 5,16)( 8,18)( 9,19)(10,21)(13,22),
 ( 5,20)( 6,21)( 9,23)(10,26)(14,27)(15,29)(17,32)(19,33)(22,34)(24,35)
  (28,36)(30,37),( 4,7)( 8,10)(12,14)(16,19)(24,25)(29,30),
 ( 2,3)(10,11)(13,14),( 1,4)( 5,11)( 8,13),
 ( 1,2)( 5,6)( 9,10)(11,12)(13,14)(15,16),( 1,4)( 5,10)( 6,13),
 ( 4,29)( 9,33)( 13,36)( 15,39)( 18,43)( 22,46)( 24,55)( 25,65)
  ( 26,73)( 27,74)( 28,79)( 32,86)( 37,87)( 42,89)( 45,90)( 48,91)
  ( 50,100)( 51,101)( 54,102)( 57,103)( 60,104)( 61,105)( 64,106)( 67,108)
  ( 68,109)( 71,110)( 72,111)( 75,112)( 78,113)( 81,114)( 84,115)( 85,116)
  ( 88,117)( 92,120)( 93,121)( 94,123)( 95,124)( 96,126)( 97,128)( 98,129)
  ( 99,130)(107,131)(118,135)(119,136)(122,137)(125,138)(127,139)(132,140)
  (133,141)(134,142),( 2,6)( 8,16)( 9,19)(12,28)(13,31)(21,42)(22,43)
  (29,46)(30,47)(37,50)(38,51),( 8,9)(12,14)(20,21)(29,30)(31,32)(34,35)
  (37,39)(43,44)(46,48)(51,53)(54,56)(57,59)(60,62)(63,65)(66,68)(69,70)
  (71,72)(73,74),( 1,2)( 3,4)( 5,6)( 9,10)(11,12)(16,17)(19,20),
 ( 1,4)( 3,10)( 7,13)( 8,14)( 9,15)(11,16)(12,17),
 (12,14)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34),
 ( 2,12)( 4,16)( 6,22)( 9,23)(13,24)(17,25)(21,26),
 ( 3,4)( 5,6)(13,14)(16,17)(19,20),( 2,3)( 6,7)(11,12)(15,16),
 ( 2,9)( 3,10)( 5,12)(11,15)(13,16),( 1,3)( 6,9)(10,12)(15,18)(19,21)
  (24,26)(27,29)(32,34)(35,37)(40,43)(45,46)(48,49)(51,52)(55,56)(59,60)
  (62,63)(65,66)(68,69)(72,73)(76,77),( 4,34)( 7,35)( 10,36)( 14,37)
  ( 18,38)( 22,39)( 27,40)( 30,41)( 43,59)( 44,60)( 48,63)( 51,65)
  ( 52,66)( 55,69)( 57,70)( 64,80)( 68,81)( 72,82)( 73,84)( 74,86)
  ( 76,88)( 77,90)( 78,92)( 83,95)( 85,97)( 87,99)( 89,101)( 91,103)
  ( 93,105)( 94,106)( 98,107)(102,108),( 7,28)( 10,29)( 11,30)( 15,31)
  ( 18,32)( 21,33)( 25,34)( 27,35)( 38,57)( 40,58)( 43,61)( 48,63)
  ( 49,64)( 51,67)( 55,68)( 62,82)( 66,83)( 70,84)( 72,86)( 74,88)
  ( 76,90)( 78,92)( 80,94)( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)
  ( 95,107)( 96,108)(100,109)(104,110),( 2,3)( 7,8)(11,12),
 ( 2,7)( 3,10)( 4,13)( 6,16),( 4,5)( 8,9)(11,12)(16,17)(19,20),
 ( 1,9)( 2,12)( 4,15)( 5,16)( 7,19)(10,20)(13,21)(17,22),
 ( 4,5)( 6,7)( 8,9)(11,12)(13,14)(16,17)(19,20)(22,23)(25,26)(27,28)
  (29,30)(31,32)(33,34)(35,36)(37,38),( 2,22)( 4,23)( 5,26)( 7,29)( 9,30)
  (10,31)(11,32)(14,36)(15,37)(16,38)(18,41)(20,44)(21,45)(25,46)(27,48)
  (34,49)(35,51)(40,52)(42,54),( 1,7)( 2,12)( 3,18)( 5,23)(11,25)(16,28)
  (20,30),( 1,7)( 2,12)( 3,17)( 5,22)( 9,25)(13,27)(16,30)(19,32)(21,34)
  (24,36)(29,38),( 8,10)(12,15)(18,19)(22,23)(26,29)(35,36)(38,40)(41,42)
  (44,45)(47,49)(50,51)(52,54)(57,59)(62,64)(69,71)(74,76)(79,81),
 ( 1,3)( 2,6)( 7,11)( 9,12)(10,13),( 1,11)( 3,12)( 5,13)( 6,14)( 8,15)
  (10,16),( 4,6)( 9,11)(14,15)(18,20)(23,25)(27,29)(31,33)(36,38)(41,42)
  (45,47)(50,52)(54,56),( 2,5)( 6,10)( 7,12),
 ( 2,7)( 4,8)(10,14)(12,16),( 4,6)( 8,10)(17,18)(20,21)(22,24)(25,26)
  (27,28)(29,31)(32,33),( 1,10)( 4,13)( 5,16)( 7,19)(11,22)(15,25),
 ( 1,3)( 9,11)(14,15)(17,19)(20,21)(23,25),
 ( 3,6)( 7,11)( 8,12)( 9,13)(14,16)(15,18),( 4,5)( 7,9)(12,13)(15,17),
 ( 3,7)( 4,8)(10,15)(12,18),( 3,8)( 4,9)(10,13)(11,15),
 ( 6,8)(10,11)(13,14)(17,18)(20,21)(24,25)(28,29),
 ( 2,9)( 4,13)( 6,17)(10,21)(16,24)(20,27)(23,28)(26,29),
 (14,15)(16,17)(19,20)(22,23)(24,25)(26,27)(28,29)(30,31)(33,34)(36,37)
  (38,39)(40,41),( 5,6)( 8,9)(10,11)(12,13)(14,15)(17,18)(19,20),
 ( 1,7)( 6,8)( 9,13)(11,16),( 5,6)( 7,8)(10,11)(12,13)(15,16)(17,18)
  (20,21)(22,23)(24,25)(26,27)(28,29)(30,31),
 ( 5,6)( 8,9)(12,14)(16,17)(19,20)(23,25),( 3,4)( 6,7)( 8,9)(12,13),
 ( 2,3)(10,11)(14,15)(19,20)(25,26)(31,32),( 2,3)(10,11)(14,15),
 ( 5,6)( 8,9)(12,13)(14,15)(21,22)(24,25)(28,29)(44,45)(53,54)(58,59)
  (61,62)(63,64)(66,67)(68,69)(71,72)(73,74)(76,77)(78,79)(81,82)(83,84)
  (86,87),( 5, 6)( 12,13)( 16,17)( 20,21)( 28,29)( 32,33)( 43,44)
  ( 45,46)( 50,51)( 53,54)( 55,56)( 58,59)( 61,62)( 63,64)( 65,66)
  ( 71,72)( 76,77)( 79,80)( 81,82)( 83,84)( 85,86)( 88,89)( 90,91)
  ( 92,93)( 94,95)( 97,98)(100,101)(103,104)(107,108)(110,111)(113,114),
 ( 3,14)( 4,17)( 6,19)( 8,22)( 9,24)(11,27),
 ( 2,3)( 7,9)(12,14)(17,19)(22,24)(27,29)(32,34)(40,42)(43,45)(49,51)
  (52,54)(58,60)(61,63),( 5,6)( 8,9)(11,12)(14,15)(19,20)(24,25)(28,29),
 ( 1,3)( 4,9)(10,12)(11,13),( 1,4)( 3,9)( 6,11),( 1,4)( 7,9)(11,13),
 ( 3,8)(10,16)(11,20)(13,30)(25,35)(26,39)(27,44)(28,48)(31,50)(33,53)
  (36,56)(37,58)(40,61)(42,64)(45,67)(46,69)(51,72)(59,74)(65,76),
 ( 1,44)( 4,46)( 6,48)( 8,50)(10,52)(12,54)(14,55)(16,57)(18,58)(20,60)
  (22,61)(24,63)(26,65)(29,67)(31,69)(33,71)(35,72)(38,74)(40,75)(42,77),
 (10,11)(12,13)(16,17)(20,21)(22,23)(25,26)(28,29)(31,32)(35,36)(38,39)
  (42,43)(45,46)(50,51)(56,57)(59,60)(64,65)(67,68)(76,77)(84,85)(90,91),
 ( 1,4)( 2,11)( 3,16)( 6,23)(10,26)(15,28)(21,31),
 ( 4,5)( 9,12)(14,15)(17,20)(22,23)(27,30)(32,33)(35,38)(40,41)(43,46)
  (48,49)(51,54)(57,60)(63,66),( 5,6)( 9,10)(14,15)(19,20)(24,25)(28,29)
  (32,33)(36,37)(41,42)(46,47)(51,52)(55,56),
 (12,13)(16,17)(20,21)(24,25)(29,30)(34,35)(38,39)(42,43)(46,47)(51,52),
 ( 1,7)( 3,10)( 4,13)( 5,16),( 3,8)( 5,9)( 6,11)( 7,14)(13,18)(17,20),
 ( 1,2)( 7,10)(11,14)(19,22)(23,26),( 8,9)(13,14)(21,22)(24,25)(26,27)
  (28,29)(30,31),( 1,2)( 5,6)(16,17)(20,21)(23,24)(26,27)(29,30),
 ( 2,3)( 5,6)( 8,9)(10,11)(13,14)(40,41)(43,44)(46,47),
 ( 2,3)( 6,7)(10,11)(14,15)(27,28)(29,30)(34,35)(36,37)(40,41)(43,44)
  (46,47)(48,49),( 1,9)( 2,12)( 4,14)( 7,17),( 2,4)( 6,10)( 8,12),
 ( 1,2)( 3,4)( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)
  (29,30)(32,33)(35,36)(37,38)(43,44)(46,47)(52,53)(55,56)(61,62),
 ( 4,8)( 9,12)(14,18)(19,23)(25,28)(29,33)(35,38)(40,43)(45,48)(50,53),
 ( 4,8)( 9,12)(14,17)(19,23)(25,28)(29,32)(34,38)(40,43)(45,48)(49,53),
 ( 2,7)( 4,10)( 6,14)(11,22)(17,25)(20,27)(23,28)(26,29),
 ( 9,10)(15,17)(20,21)(23,24)(25,27)(28,30)(31,32)(33,34),
 ( 1,4)( 5,6)(11,12)(15,16),( 3,9)( 4,10)( 7,12)( 8,13),
 ( 3,9)( 4,10)( 7,11),( 4,8)( 9,11)(12,14),
 ( 1,3)( 4,9)( 6,11)( 8,13)(10,14)(12,15),
 ( 4,5)( 7,9)(13,14)(19,20)(22,24)(27,29)(40,41)(44,46)(50,51)(54,56)
  (61,63)(66,68)(71,73)(77,79)(82,84)(87,89),
 ( 2,7)( 8,13)(14,18)(19,24)(25,29),( 4,8)( 9,10)(11,15)(16,20)(21,24),
 ( 5,8)(10,13)(15,18)(20,23)(25,29)(30,33)(35,39)(40,44)(46,49)(50,54),
 (15,17)(18,20)(23,24)(26,28)(33,34)(35,36)(37,39)(40,41)(45,47)(48,49)
  (54,55)(57,58)(60,61)(63,64)(66,67)(69,70)(71,72)(73,74)(75,76),
 ( 3,4)( 8,9)(12,13)(20,21)(27,28)(33,34),( 6,7)( 9,10)(13,14),
 ( 2,4)( 8,10)(13,15)(16,18)(21,23),( 1,7)( 3,9)( 4,12),
 ( 1,2)( 3,4)( 5,6)( 9,10)(12,13)(18,19)(21,22),
 ( 1,8)( 3,12)( 6,16)( 9,18)(13,20),( 4, 6)( 7, 8)( 13,15)( 19,21)
  ( 23,24)( 30,32)( 42,43)( 46,47)( 51,52)( 55,57)( 58,60)( 65,67)
  ( 70,71)( 75,76)( 85,87)( 94,96)( 97,99)(100,102)(103,105)(107,109)
  (110,112)(113,115),( 2,10)( 4,14)( 5,16)( 8,19)(13,22)(17,25),
 ( 1,2)( 5,7)(10,11)(14,15),( 4,5)( 8,9)(17,18)(23,24)(26,27)(29,30)
  (32,33)(35,36),( 1,4)( 8,9)(14,15)(17,20)(24,25)(27,30)(32,33)(35,38)
  (40,41)(43,46)(48,49)(51,54)(57,60)(63,66),
 ( 5,7)( 8,10)(13,15)(17,19)(21,23)(24,26)(27,29)(30,32)(33,35),
 ( 2,3)( 5,6)(10,11)(15,16)(18,19)(21,22),
 ( 1,2)(10,11)(12,13)(19,20)(21,22),( 1,3)( 6,8)(17,19)(24,25)(27,28)
  (32,33)(38,39)(41,42),( 4,7)(10,17)(11,22)(16,29)(20,31)(25,34)(26,37)
  (27,43)(28,46)(36,51)(38,54)(41,57)(45,60)(47,63)(50,66)(52,69)(58,71)
  (64,73),(10,11)(12,13)(16,17)(21,22)(24,25)(27,28)(31,32)(35,36)(39,40)
  (42,43)(45,46)(50,51),( 5,38)( 8,40)(11,41)(13,42)(19,43)(22,44)(25,45)
  (28,46)(31,48)(34,49)(37,50)(51,59)(52,62)(54,65)(55,68)(56,71)(58,74)
  (60,78)(66,80)(72,82),( 4,8)(13,17)(18,21)(22,23)(24,26)(28,30)(32,33)
  (34,35),( 4,20)( 6,23)( 7,26)( 8,29)(10,32)(11,35)(13,38)(14,41)(15,44)
  (17,47),( 3,5)( 6,8)(10,12)(14,15)(17,19),
 ( 7,28)( 10,29)( 13,30)( 17,31)( 20,32)( 22,33)( 25,34)( 35,51)
  ( 38,55)( 40,57)( 43,58)( 46,62)( 47,63)( 50,67)( 53,80)( 56,81)
  ( 60,82)( 61,83)( 65,84)( 70,85)( 71,88)( 73,91)( 76,94)( 77,97)
  ( 79,100)( 86,104)( 89,106)( 92,108)( 95,110)( 98,112)(101,114)(103,115)
  (107,116)(111,117),( 1,2)( 5,6)( 8,9)(10,11)(13,14)(41,42)(44,45)
  (47,48),( 1,9)( 2,15)( 3,19)( 4,24)(10,27)(13,29)(22,32),
 ( 2,3)( 5,6)(11,12)(16,17)(20,21),( 1,23)( 3,24)( 5,25)( 6,29)( 8,30)
  (10,31)(11,32)(13,33)(15,37)(18,38)(20,42)(22,43)(26,44)(27,45)(28,46)
  (34,47)(35,48)(36,49)(39,50)(40,51)(41,52),
 ( 1,9)( 4,13)( 7,16)(11,17)(15,18),( 2,3)( 6,7)(16,17)(20,21)(24,25)
  (27,28)(30,31)(33,34),( 2,4)( 7,8)(11,13)(16,18)(21,22)(25,27),
 ( 1,2)( 3,4)( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)
  (29,30)(32,33)(35,36)(40,41)(43,44)(49,50)(52,53)(58,59)(61,62),
 ( 7,8)(16,17)(20,21)(22,23)(25,26)(28,29)(31,32)(34,35),
 ( 1,7)( 3,8)( 4,11)( 9,12)(10,13),( 1,9)( 3,15)( 5,22)( 8,23)(12,24)
  (16,25)(19,26),( 1,4)( 6,8)(10,12)(14,17)(19,22),
 ( 7,11)( 8,14)( 9,21)(10,25)(15,33)(28,35)(29,40)(30,42)(31,48)(32,50)
  (37,53)(39,56)(43,59)(45,62)(47,65)(51,68)(58,71)(64,73)(70,75),
 ( 5, 8)( 13,14)( 15,16)( 21,22)( 32,33)( 36,37)( 38,39)( 42,43)
  ( 44,45)( 46,47)( 49,50)( 53,54)( 57,58)( 59,60)( 63,64)( 67,68)
  ( 71,72)( 75,76)( 77,78)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)(113,114)(117,118)(123,124)(125,126)(127,128)(129,130)
  (131,132)(133,134)(135,136)(139,140)(141,142)(143,144)(145,146)(147,148)
  (149,150),( 4,7)( 5,8)(10,13)(12,16),
 ( 1,2)( 6,7)(11,12)(14,15)(18,19)(22,23),
 ( 1,8)( 3,10)( 6,13)(11,17)(14,20),( 5,7)( 9,10)(13,14),
 ( 1,7)( 3,8)( 5,10)( 6,11),( 2,4)(10,12)(14,15)(18,19)(21,22),
 ( 1,2)( 6,7)(11,12)(15,16)(19,20),( 6,17)( 8,18)( 9,21)(11,22)(12,23)
  (13,24)(15,27)(16,30)(19,33)(25,36)(28,37)(31,38)(34,39),
 ( 5,6)( 7,9)(11,13)(16,17)(23,24)(26,27)(29,30)(32,33),
 ( 5,6)( 8,9)(12,13)(14,15),( 4,8)(10,13)(15,18)(19,23)(25,29)(30,33)
  (35,38)(40,44)(46,49)(50,53),( 2,3)( 6,7)(11,12)(15,16)(20,21),
 ( 5,29)( 7,30)( 9,31)( 11,33)( 14,34)( 17,35)( 19,37)( 22,38)
  ( 24,39)( 26,40)( 28,42)( 45,58)( 52,72)( 56,83)( 64,84)( 70,85)
  ( 76,87)( 77,90)( 78,93)( 79,96)( 80,98)( 81,101)( 89,106)( 95,108)
  (100,110),( 5,6)( 7,8)( 9,10)(11,12)(14,15)(17,18)(19,20)(22,23)(24,25)
  (26,27)(28,29)(30,31)(32,33),( 1,2)( 3,4)( 5,6)(10,11)(13,14)(18,19)
  (20,21),( 2,4)( 8,9)(11,12),( 6,15)( 8,17)( 9,18)(11,20)(13,21)(14,23)
  ,( 6,33)( 8,34)(11,35)(20,36)(25,37)(28,38)(32,39)(41,58)(42,62)(43,63)
  (46,67)(47,68)(48,72)(50,73)(51,77)(52,78)(55,82)(56,83)(57,87)(59,88)
  (61,89)(69,90)(71,91)(79,92)(81,93),( 1,7)( 3,9)( 5,17)(10,23)(15,26)
  (18,27)(21,28)(24,29),( 2,3)( 7,8)( 9,10)(11,12)(13,14)(15,16)(17,18),
 ( 2,5)( 4,8)( 6,11),( 1,11)( 3,12)( 5,14)( 7,16)(18,26)(19,32),
 ( 4, 6)( 8,28)( 25,29)( 27,37)( 30,49)( 33,52)( 34,53)( 36,55)
  ( 39,58)( 40,59)( 42,61)( 44,63)( 46,65)( 48,78)( 54,81)( 60,82)
  ( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)( 80,98)( 83,102)
  ( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)( 96,122)( 97,123)
  ( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)(114,137)(124,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,151)(141,153)
  (143,155)(145,157)(147,159)(149,161)(154,163)(158,164)(162,165),
 ( 3,8)( 4,10)( 6,12)( 7,14),( 2,4)( 6,7)( 9,10)(13,14),
 ( 4,5)( 9,10)(15,16)(21,22)(26,27),( 4,20)( 7,21)( 8,22)(11,26)(13,27)
  (15,28)(17,32)(19,33)(23,34)(24,35)(29,36)(30,37),
 ( 4,5)( 9,10)(16,17)(20,21)(24,25),( 2,10)( 4,12)( 6,18)( 8,23)(14,24)
  (17,25)(22,26),( 4,7)( 9,13)(14,17)(19,23)(24,28)(30,33)(34,38)(40,43)
  (45,48)(50,53),( 9,10)(14,15)(19,20)(24,25)(29,30)(33,34)(38,39)(43,44)
  (48,49)(53,54),( 4,5)(12,13)(15,16)(18,19)(21,22)(23,24)(27,28)(29,30),
 ( 1,23)( 3,24)( 5,25)( 6,29)( 8,30)(10,31)(11,32)(13,33)(15,37)(17,38)
  (18,39)(20,43)(22,44)(26,45)(28,46)(34,47)(36,48)(40,49)(42,50),
 ( 1,24)( 3,25)( 5,26)( 6,27)( 8,30)(10,31)(11,32)(13,33)(15,34)(17,36)
  (19,37)(21,38)(23,41)(28,43)(29,44)(35,46)(39,48)(40,49)(42,50)(45,51)
  (47,52),( 2,7)( 5,10)( 6,13)( 8,16)(11,19),( 3,5)(10,11)(14,15),
 ( 4,7)( 8,12)(14,17)(19,22)(24,27)(29,32)(34,38)(39,42)(44,48)(49,53),
 ( 1,2)( 4,5)( 9,10)(16,17)(20,21)(24,25),( 2,3)( 5,7)(11,12)(15,16),
 ( 6,7)(10,11)(17,18)(21,22)(24,25)(29,30)(43,44)(47,48)(51,52)(55,56)
  (57,58)(62,63)(67,68)(72,73)(77,78)(82,83),
 ( 1,2)( 6,7)(13,14)(18,19)(26,27)(32,33),
 ( 4,36)( 8,37)(11,38)(18,39)(28,40)(31,41)(33,42)(43,59)(45,62)(46,63)
  (47,66)(49,67)(50,70)(51,71)(53,74)(54,75)(55,78)(57,79)(58,82)(64,83)
  (65,84)(72,85)(73,86)(80,87)(81,88),( 1,8)( 4,11)( 7,15)( 9,17)(13,18),
 ( 2,4)(10,12)(14,15)(17,18)(20,21),(14,15)(17,18)(20,21)(22,23)(24,25)
  (26,27)(28,29)(31,32)(34,35)(36,37)(38,39)(40,41),
 ( 5,7)( 8,10)(12,14)(16,18)(19,21)(23,25),
 ( 5,6)( 7,8)(10,11)(13,14)(15,16)(17,18)(19,20)(22,23)(24,25)(26,27)
  (28,29)(30,31)(32,33),( 1,3)( 6,8)(11,13)(25,26)(28,29)(33,34)(35,36),
 ( 3,6)( 8,10),( 5,6)(12,13)(17,18)(22,23)(27,28)(30,31)(40,41)(45,46)
  (49,50)(54,55)(60,61)(65,66)(70,71)(75,76)(80,81)(85,86),
 ( 1,4)( 7,9)(10,12)(15,17)(18,20)(23,25)(26,29)(32,34)(35,38)(41,43)
  (44,45)(48,49)(52,53)(55,56)(58,59)(61,62)(65,66)(69,70)(72,73)(75,76),
 ( 1,7)( 3,8)( 6,11)( 9,12)(10,13),( 3,4)( 7,8)(10,11)(13,14)(16,17)
  (22,23)(28,29)(31,32),( 1,8)( 3,11)( 4,12)( 5,15)( 7,16)( 9,17)(13,18),
 ( 7,10)(11,16)(17,20)(24,25)(26,27)(28,29)(30,31),
 ( 3,4)( 5,7)( 9,10)(11,12),( 4,12)( 5,13)( 6,15)( 7,16)(10,18)(11,19),
 ( 5,6)( 8,9)(10,11)(14,15)(18,19),( 1,5)( 2,11)( 6,13),
 ( 4,6)( 9,10)(13,15)(17,18)(21,23),( 1,2)( 4,9)( 8,12),
 ( 2,3)( 7,8)(12,13)(14,15)(18,19)(22,23),
 ( 7,19)( 9,34)(12,35)(15,36)(18,37)(21,38)(24,39)(27,40)(30,41)(32,50)
  (42,60)(45,64)(48,66)(51,70)(54,72)(57,76)(59,77)(62,78)(65,79)(68,80)
  (71,81)(74,82),( 1,2)( 3,4)( 5,6)( 8,10)(12,13)(16,18)(19,21),
 ( 5,7)(11,13)(16,17)(20,22)(26,28)(31,33)(36,37)(41,43)(47,48)(51,53),
 ( 1,2)( 4,7)(12,15)(16,19)(24,27),( 2,4)( 7,8)(10,11)(14,15),
 ( 2,5)( 7,10)(12,15)(16,19)(21,24),( 2,7)( 3,9)( 4,11)( 5,13)( 6,15),
 ( 5,6)(10,11)(16,17)(22,23)(27,28),( 7,8)(13,14)(17,18)(22,23)(27,28)
  (31,32)(37,38)(41,42)(46,47)(51,52),( 4,5)( 8,9)(10,11)(17,18)(20,21)
  (24,25)(30,31)(44,45)(53,54)(58,59)(61,62)(63,64)(66,67)(68,69)(71,72)
  (73,74)(76,77)(78,79)(81,82)(83,84)(86,87),
 ( 3,4)( 8,9)(12,13)(15,16)(18,19)(22,23)(26,27)(31,32),
 ( 2,5)( 7,10)(12,15)(17,19)(21,23),( 4,6)( 8,10)(12,14)(15,17)(19,20)
  (22,24)(26,28)(30,31)(33,35)(37,39)(41,42)(44,46)(47,49)(51,53)(55,57),
 ( 3,4)( 8,9)(12,13)(16,17)(19,20),( 1,2)( 4,6)( 9,10)(11,12),
 ( 6,7)( 9,10)(13,14)(17,18)(21,22),( 3,5)( 8,10)(11,12),
 ( 1,24)( 2,25)( 4,28)( 6,29)( 8,30)(10,32)(12,33)(14,34)(15,35)(17,36)
  (19,39)(20,40)(22,41)(26,42)(27,43)(31,45)(37,47)(38,48)(44,50)(46,51)
  (49,52),( 7,15)( 8,17)( 9,18)(12,20)(13,21)(14,23),
 ( 4,5)( 9,10)(14,15)(16,17)(21,22),( 7,15)( 8,16)( 9,18)(11,19)(12,21)
  (13,22),( 6,7)(10,11)(13,14),( 1,8)( 3,12)( 5,19)( 9,23)(13,24)(17,25)
  (21,26),( 7,29)( 10,30)( 12,31)( 17,32)( 21,33)( 24,34)( 26,35)
  ( 36,50)( 39,54)( 40,56)( 43,57)( 44,61)( 46,62)( 47,66)( 51,79)
  ( 53,80)( 58,81)( 63,82)( 65,83)( 67,84)( 69,87)( 70,90)( 73,93)
  ( 75,96)( 76,99)( 86,103)( 89,105)( 92,107)( 95,109)( 98,111)(101,113)
  (104,114)(108,115)(112,116),( 3,4)( 5,6)(10,11)(15,16)(18,19)(21,22),
 ( 2,10)( 5,11)( 8,12)( 9,15)(13,16)(14,17),
 ( 1,10)( 3,14)( 5,18)( 7,21)(11,24)(17,27)(22,28)(25,29),
 ( 1,2)( 7,8)(10,11)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 4,5)( 8,9)(11,12)(15,16)(18,19)(21,22)(24,25),
 ( 3,8)( 7,9)(10,13)(11,14),( 6,7)( 9,10)(12,13)(14,15)(21,22)(23,24)
  (27,28)(31,32)(58,59)(60,61)(63,64)(65,66)(68,69)(70,71)(73,74)(75,76)
  (78,79)(80,81)(83,84)(85,86),( 1,7)( 2,12)( 3,19)( 8,25)(13,27)(17,30)
  (21,32),( 3,4)( 8,10)(14,15)(21,22)(25,26)(29,30)(33,34)(37,38)(41,42)
  (45,46)(49,50)(53,54),( 1,5)( 2,9)( 3,15)(10,25)(13,27)(19,30)(20,32),
 ( 2,7)( 3,8)(10,14)(12,16),( 2,3)( 7,8)(13,14)(16,17)(22,23),
 ( 1,4)( 6,9)(11,14)(16,18)(20,22),( 2,3)( 7,8)(13,14)(18,19)(24,25),
 ( 4,8)(12,15)(19,23)(24,25)(26,27)(28,29)(30,31),
 (11,31)(14,32)(16,33)(18,36)(20,37)(22,38)(24,40)(27,41)(29,42)(43,55)
  (44,57)(47,58)(48,62)(49,63)(50,66)(53,68)(54,70)(59,73)(65,74)(71,77)
  (72,82)(75,83)(78,84)(79,85)(81,86)(87,89)(88,90),
 ( 5,6)( 7,8)(18,20)(22,23)(25,27)(32,34)(36,37)(39,41),
 ( 2,9)( 3,13)( 6,15)( 8,18)(12,20)(16,23),
 ( 1,2)( 7,8)(11,12)(13,14)(16,17)(19,20),
 ( 4,16)( 5,17)( 8,20)( 9,21)(10,24)(13,25),
 ( 2,6)(11,22)(14,30)(17,31)(21,32)(25,33)(27,39)(29,48)(35,52)(38,56)
  (41,59)(44,63)(47,66)(50,70)(54,73)(58,74)(61,75)(65,76)(68,77)(72,78),
 ( 1,24)( 3,25)( 4,26)( 6,29)( 8,30)( 9,31)(11,32)(13,33)(15,35)(17,36)
  (19,37)(21,40)(22,41)(27,43)(28,44)(34,46)(38,48)(39,49)(42,50)(45,51)
  (47,52),( 7,8)(15,16)(20,21)(24,25)(26,27)(28,29)(30,31),
 ( 1,23)( 3,24)( 5,25)( 6,29)( 8,30)(10,31)(11,32)(13,33)(15,37)(16,38)
  (18,39)(20,43)(22,44)(26,45)(28,46)(34,47)(36,48)(40,49)(42,50),
 ( 1,3)( 4,6)( 7,8)( 9,11)(12,14),( 2,12)( 3,13)( 4,16)( 5,17)( 8,19)
  ( 9,21)(10,22)(15,23)(18,24)(20,25),( 6, 7)( 9,10)( 16,17)( 18,19)
  ( 32,33)( 38,39)( 48,49)( 50,51)( 52,53)( 54,55)( 56,57)( 58,59)
  ( 61,62)( 63,64)( 65,66)( 68,69)( 70,71)( 72,73)( 74,75)( 76,77)
  ( 78,79)( 80,81)( 82,83)( 87,88)( 90,91)(106,107)(114,115)(119,120)
  (124,125)(127,128),( 7,8)(11,13)(17,18)(22,24)(27,28)(32,34)(37,39)
  (42,44)(47,49)(52,54),( 4,7)(10,12)(14,17)(20,22)(23,25)(26,27)(28,30)
  (31,32)(33,34)(35,36)(37,38),( 1,9)( 4,12)( 5,14)( 7,18)(11,20)(15,23),
 ( 5,20)( 6,21)( 9,23)(10,26)(12,27)(14,28)(15,30)(17,33)(19,34)(24,35)
  (31,36),( 2,5)(10,24)(11,27)(14,36)(15,39)(17,40)(18,41)(25,44)(26,45)
  (33,48)(34,49),( 4,6)( 8,10)(13,15)(17,19)(20,22)(24,26),
 ( 5,6)( 9,10)(14,15)(17,19)(22,24)(28,30),
 ( 1,6)( 2,11)( 3,20)( 9,23)(12,26)(18,29)(27,32)(30,35),
 ( 2,9)( 3,11)( 5,13)( 6,15),( 1,7)( 2,12)( 3,23)(10,25)(13,27)(18,29)
  (21,31),( 4,15)( 6,16)( 7,19)( 9,20)(11,23)(12,24),
 ( 4,5)( 8,9)(12,13)(16,17)(19,20)(24,25),
 ( 1,17)( 3,18)( 5,20)( 6,21)( 7,22)( 9,24)(11,25)(12,27)(14,28)(16,29),
 ( 1,24)( 4,27)( 8,28)( 9,29)(12,30)(14,33)(17,34)(19,35)(22,36)(25,37)
  (31,38),( 1,7)( 2,12)( 3,21)(10,23)(13,26)(19,29)(27,32)(30,35),
 ( 1,3)( 2,7)( 6,11)( 9,12)(10,13),( 2,9)( 3,10)( 5,13)( 7,14)( 8,17)
  (11,20)(15,21)(18,22),( 1,2)( 6,7)(11,12)(15,16),
 ( 1,8)( 3,9)( 4,10)( 6,13)( 7,14)(11,17)(15,18),
 ( 3,4)( 8,9)(13,14)(15,17)(18,19)(20,22)(23,24)(25,27),
 ( 8,19)(11,34)(13,35)(17,36)(20,37)(23,38)(26,39)(28,40)(31,41)(33,50)
  (43,60)(46,64)(49,66)(52,70)(55,72)(58,76)(61,77)(63,78)(67,79)(69,80)
  (73,81)(75,82),( 4,5)( 8,9)(11,12)(15,16)(21,22)(25,26),
 ( 4,5)( 9,10)(15,16)(19,20)(23,24),( 5,7)( 8,11)(12,14)(15,17)(18,21)
  (23,25)(27,29),( 2,5)( 4,9)(10,13)(11,14)(12,15),
 ( 2,4)(10,11)(12,13)(14,15)(16,17)(18,19)(23,24)(27,28),
 ( 1,3)( 6,8)( 9,12)(15,17)(18,21)(24,26)(27,30)(33,35)(36,38)(41,43)
  (45,46)(48,49)(51,52)(54,55)(58,59)(62,63)(65,66)(68,69)(71,72)(75,76),
 ( 3,10)( 5,12)( 7,14)( 8,15)( 9,16),( 1,2)( 4,5)( 8,9)(14,15)(20,21)
  (23,24)(26,27)(29,30),( 4, 6)( 8,28)( 25,29)( 27,39)( 30,49)
  ( 32,51)( 35,54)( 36,55)( 38,57)( 41,60)( 42,61)( 44,63)( 46,65)
  ( 48,78)( 56,81)( 62,82)( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)
  ( 77,95)( 80,98)( 83,102)( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)
  ( 93,119)( 96,122)( 97,123)( 99,125)(101,127)(103,129)(105,131)(107,133)
  (109,135)(114,137)(124,138)(126,140)(128,142)(130,144)(132,146)(134,148)
  (136,150)(139,151)(141,153)(143,155)(145,157)(147,159)(149,161)(154,163)
  (158,164)(162,165),( 7,9)(11,13)(15,16)(17,18)(19,20),
 ( 1,24)( 4,25)( 6,26)( 9,29)(13,30)(14,31)(17,32)(19,35)(22,36)(27,37)
  (33,38),( 5,6)( 9,10)(11,12)(18,19)(20,21),
 ( 5,6)( 8,10)(13,14)(17,19)(21,22),( 5,7)( 9,11)(14,16)(17,19)(20,22)
  (23,25)(26,28)(31,33)(34,36),( 4,5)(12,14)(16,18)(20,21)(22,24)(25,26)
  (27,28)(29,31)(32,33),( 5,7)( 9,11)(14,16)(19,20)(23,25)(28,30)(32,34)
  (36,38)(41,43)(46,47)(50,52)(55,57),( 4,20)( 7,21)( 9,24)(11,25)(13,26)
  (15,30)(16,31)(19,32)(22,34)(23,35)(27,37)(28,38),
 ( 7,10)(11,12)(15,16)(19,20)(21,24),( 1,3)( 9,11)(12,14)(17,19)(20,22),
 ( 2,9)( 4,14)( 6,16)( 8,20)(12,22)(18,23),
 ( 4,5)(12,13)(15,16)(18,19)(22,23)(27,28)(29,30)(33,34)(35,36),
 ( 1,8)( 4,12)( 6,15)(10,17)(14,19),(14,15)(16,17)(18,19)(21,22)(24,25)
  (26,27)(28,29)(30,31)(32,33)(35,36)(38,39)(40,41),
 ( 4,6)( 8,9)(10,12)(13,15)(18,20)(21,23)(32,33)(44,45)(46,47)(48,49)
  (53,54)(55,56)(74,75)(78,79),( 4,5)( 9,10)(17,18)(21,22)(26,27)(33,34),
 ( 4,36)( 7,37)(17,38)(24,39)(27,40)(31,41)(34,42)(43,59)(44,62)(46,63)
  (47,66)(48,67)(50,70)(51,71)(52,74)(54,75)(55,78)(56,79)(58,82)(60,83)
  (61,84)(68,85)(69,86)(76,87)(77,88),( 6,11)( 7,12)( 8,15)( 9,16)(10,17)
  (13,18)(14,19),( 4,5)(10,12)(14,16)(18,20)(22,23)(26,27)(29,30)(34,35),
 ( 1,7)( 6,8)( 9,15)(11,16),( 1,4)( 2,13)( 3,18)( 7,22)( 9,24)(16,28)
  (27,32)(31,34),( 1,7)( 6,8)(10,15)(12,16),
 ( 1,11)( 4,14)( 6,17)( 8,19)(10,22)(15,24),
 ( 3,4)( 7,8)(18,19)(22,23)(26,27)(28,29)(32,33)(34,35),
 ( 2,4)(15,17)(19,21)(23,24)(25,27)(28,29)(32,33)(34,35)(38,39)(40,42)
  (43,44)(46,47)(49,50)(52,53),( 6, 8)( 10,11)( 14,15)( 16,18)
  ( 19,21)( 23,25)( 26,28)( 29,31)( 32,33)( 34,35)( 36,38)( 39,41)
  ( 42,44)( 45,46)( 47,49)( 51,52)( 53,55)( 57,59)( 60,62)( 63,65)
  ( 67,68)( 69,70)( 72,73)( 74,75)( 76,77)( 78,79)( 80,81)( 82,83)
  ( 84,85)( 86,87)( 88,90)( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)
  (101,102)(103,104)(105,106)(107,109)(110,111)(112,113)(114,115)(116,117)
  (118,119)(120,121)(122,124)(125,126)(127,128)(129,131)(133,134)(135,136)
  (138,140)(141,143)(145,146)(147,148)(150,152)(153,155)(156,157)(158,159)
  (160,162)(163,164)(165,166)(167,169)(170,171)(172,173)(174,176)(177,179)
  (180,181)(182,183)(184,186)(187,188)(189,190)(191,193)(194,195)(196,197)
  (198,200)(201,203)(204,205)(206,207)(208,210)(211,212)(213,214)(215,217)
  (218,219)(220,221)(222,224)(225,226)(227,228)(229,231)(232,233)(234,235)
  (236,238)(239,240)(241,242)(243,244)(245,246)(247,248)(249,250)(251,252)
  (253,254)(255,256)(257,258)(259,260)(261,262)(263,264)(265,266)(267,268)
  (269,270)(271,272)(273,274)(275,276)(277,278)(279,280)(281,282)(283,284)
  (285,286)(287,288)(289,290)(291,292)(293,294)(295,296)(297,298)(299,300)
  (301,302)(303,304)(305,306)(307,308)(309,310)(311,313)(314,316)(317,319)
  (320,322)(323,325)(326,328)(329,331)(332,334)(335,337)(338,340)(341,343)
  (344,346)(347,348)(349,350)(351,352)(353,354)(355,356)(357,358),
 ( 4,35)( 6,38)( 8,40)(10,42)(12,45)(14,47)(16,50)(18,52)(20,54)(22,57)
  (24,59)(26,62)(28,64)(30,66)(32,69),( 5,6)( 8,9)(10,11)(13,14)(15,16),
 ( 1,2)( 6,7)(14,15)(18,19)(25,26)(32,33),
 ( 2,9)( 3,10)( 5,12)( 7,13)( 8,15)(11,16)(14,17),
 ( 1,2)( 4,5)( 7,8)(11,12)(14,15)(41,42)(44,45)(47,48),
 ( 1,3)( 6,9)( 8,11),( 1,10)( 2,12)( 4,13)( 6,14)( 9,15)(11,16),
 ( 5,7)( 8,10)(13,15)(16,18)(21,23)(25,27),
 ( 1,7)(10,25)(13,30)(16,31)(19,32)(23,33)(26,39)(28,48)(34,52)(37,56)
  (40,59)(43,63)(46,66)(49,70)(53,73)(57,74)(60,75)(64,76)(67,77)(71,78),
 ( 8,9)(13,14)(17,18)(22,23)(27,28)(32,33)(37,38)(41,42)(46,47)(51,52),
 ( 4,12)( 6,16)( 7,17)( 8,21)(10,22)(11,26),
 ( 4,5)( 8,9)(10,11)(12,13)(14,15)(40,41)(42,43)(44,45)(46,47)(48,49)
  (50,51),( 4,12)( 6,14)( 7,15)( 8,17)(10,18)(11,20),
 ( 1,3)(10,12)(13,15)(17,19)(21,23)(25,27),
 ( 6,7)(12,14)(18,19)(29,30)(31,32)(35,37)(39,40)(44,46)(48,49)(51,53)
  (54,56)(57,59)(60,62)(63,65)(66,68)(69,70)(71,72)(73,74),
 ( 1,4)( 9,15)(10,16)(11,17)(14,20)(18,21)(19,22),
 ( 1,2)( 5,6)(14,15)(18,19)(24,25)(26,27)(31,32)(33,34),
 ( 1,2)( 3,4)( 5,6)( 8,10)(13,15)(17,19)(22,24),
 ( 4,6)( 8,10)(12,15)(16,19)(23,24)(29,30),
 ( 7,33)( 9,34)( 11,35)( 25,36)( 28,37)( 30,38)( 39,46)( 40,49)
  ( 41,51)( 42,54)( 43,56)( 44,59)( 45,61)( 52,72)( 62,74)( 63,76)
  ( 64,77)( 65,80)( 66,83)( 67,86)( 68,88)( 69,89)( 70,92)( 71,95)
  ( 73,97)( 75,98)( 78,100)( 79,101)( 81,102)( 82,104)( 84,105)( 85,107)
  ( 87,108)( 90,110)( 91,111)( 93,112)( 94,114)( 96,115)(103,117)(109,118)
  (116,119),( 7, 9)( 12,13)( 15,17)( 20,21)( 24,25)( 37,38)( 39,41)
  ( 42,44)( 47,49)( 53,54)( 58,59)( 65,66)( 69,70)( 71,73)( 75,76)
  ( 77,79)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101),
 ( 5, 6)( 13,14)( 17,18)( 24,25)( 26,27)( 30,31)( 33,34)( 37,38)
  ( 39,40)( 49,50)( 51,52)( 55,56)( 59,60)( 65,66)( 70,71)( 77,78)
  ( 80,81)( 84,85)( 88,89)( 92,93)( 95,96)( 99,100)(103,104)(107,108)
  (111,112)(114,115)(118,119)(122,123)(126,127)(130,131)(138,139)(142,143)
  (150,151)(154,155)(157,158)(161,162)(164,165)(168,169)(171,172)(175,176)
  (178,179)(181,182)(185,186)(188,189)(192,193)(195,196)(199,200)(202,203)
  (205,206)(209,210)(212,213)(216,217)(219,220)(223,224)(226,227)(230,231)
  (233,234)(237,238)(240,241)(264,265)(268,269)(272,273)(276,277)(280,281)
  (284,285)(288,289)(292,293)(296,297)(300,301)(304,305)(308,309)(312,313)
  (315,316)(318,319)(321,322)(324,325)(327,328)(330,331)(333,334)(336,337)
  (339,340)(342,343)(345,346),( 7,9)(12,13)(16,18)(22,24)(27,29)(32,33)
  (37,39)(43,44)(47,49)(52,54),( 4,6)( 8,9)(13,14)(16,18)(21,22),
 ( 7,9)(12,13)(16,17)(21,22)(25,27)(29,31)(40,41)(44,46)(49,50)(53,55)
  (60,62)(65,67)(70,72)(75,77)(80,82)(85,87),
 ( 3,4)( 5,6)( 8,9)(10,11)(12,13)(15,16)(18,19)(21,22)(24,25)(27,28),
 ( 6, 8)( 11,12)( 14,16)( 20,23)( 24,25)( 31,33)( 44,45)( 48,49)
  ( 51,52)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)
  ( 70,71)( 82,83)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)( 94,95)
  ( 96,97)( 98,99)(100,101)(102,103)(104,105),
 ( 6,8)(11,12)(14,15)(17,19)(22,23)(25,26),
 ( 4,5)(15,16)(20,21)(23,25)(26,28)(30,32)(33,35),
 ( 3,7)(10,15)(11,19)(13,29)(25,34)(26,38)(27,43)(28,47)(31,49)(33,52)
  (36,55)(37,57)(40,60)(42,63)(45,66)(46,68)(51,71)(59,73)(65,75),
 ( 1,8)( 2,14)( 3,18)( 4,23)(10,26)(13,28)(22,31),
 ( 2,3)( 5,6)( 9,10)(11,12)(13,14)(17,18)(19,20)(21,22),
 ( 5,7)( 9,10)(13,15)(17,18)(22,23)(26,27),
 ( 5,44)( 8,46)( 11,47)( 13,48)( 18,50)( 23,51)( 26,53)( 29,55)
  ( 30,57)( 31,60)( 33,61)( 34,63)( 35,66)( 37,67)( 38,69)( 39,71)
  ( 40,74)( 42,75)( 52,82)( 54,86)( 56,88)( 58,91)( 62,92)( 64,94)
  ( 68,97)( 70,99)( 72,102)( 77,103)( 80,104)( 83,105)( 84,107)( 85,109)
  ( 87,111)( 90,112)( 93,113)( 96,114)( 98,115)(101,116)(106,117)(108,118)
  (110,119),( 6,8)(11,12)(16,18)(22,23)(26,28)(31,33)(37,39)(42,43)(46,48)
  (52,54),( 1,4)( 6,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 3,6)( 4,8)( 5,14)(10,16)(11,18)(12,20)(13,22),
 ( 2,11)( 5,14)( 7,17)( 8,20)(10,22)(15,24),
 ( 3,4)( 7,8)(10,12)(15,16)(19,20),( 6,7)(10,11)(14,15)(16,17)(21,22),
 (10,31)(11,33)(14,34)(16,35)(18,38)(20,39)(22,40)(23,41)(25,43)(27,45)
  (28,46)(30,47)(50,62)(51,63)(56,65)(57,66)(61,71)(64,73)(67,75),
 ( 3,6)( 4,8)( 9,11)(10,12),( 1,2)( 9,11)(12,14)(16,18)(19,20)(24,25)
  (27,29)(30,32)(34,35)(39,40)(41,43)(45,47)(48,50),
 ( 9,26)( 13,30)( 16,31)( 17,34)( 21,37)( 22,38)( 23,43)( 24,53)
  ( 25,66)( 27,71)( 29,74)( 32,77)( 36,80)( 39,88)( 41,90)( 44,92)
  ( 46,94)( 48,96)( 50,98)( 51,99)( 54,101)( 56,103)( 58,106)( 59,107)
  ( 61,109)( 63,111)( 67,113)( 68,114)( 70,117)( 73,119)( 76,121)( 79,123)
  ( 82,124)( 83,127)( 84,129)( 85,132)( 86,134)( 87,137)( 89,139)( 91,141)
  ( 93,142)( 95,143)( 97,145)(100,146)(102,147)(104,149)(108,150)(110,151)
  (112,153)(115,154)(125,155)(128,156)(130,157)(133,158)(135,159)(138,160)
  (140,162)(144,164)(148,166)(152,168),( 3,4)( 5,6)(10,11),
 ( 1,2)( 3,4)( 5,6)( 9,10)(14,15)(17,18)(21,22)(24,25),(1,3)(4,8)(5,9),
 ( 2,9)( 4,10)( 6,12)( 7,14)( 8,16),( 6,7)(10,11)(14,15)(18,20)(22,24)
  (27,28)(31,32)(35,36)(39,41)(43,45),( 8,9)(10,11)(12,13)(14,16)(18,19)
  (20,21),(11,12)(17,18)(21,22)(23,24)(25,26)(28,29)(30,31),
 ( 3,6)( 4,7)( 8,10)( 9,14),( 2,9)( 4,10)( 6,11)( 7,13)( 8,15),
 ( 1,3)( 4,7)(10,12)(13,16)(19,21)(22,24)(27,29)(30,32)(35,37)(38,41)
  (45,46)(48,49)(52,53)(56,57)(59,60)(62,63)(65,66)(69,70)(73,74)(76,77),
 ( 1,6)( 2,8)( 5,11)( 9,12)(10,13),( 1,6)( 2,8)( 4,9)( 7,11),
 ( 2,9)( 4,10)(11,13)(12,14),( 6,33)( 9,34)( 13,35)( 14,36)( 17,37)
  ( 22,38)( 25,39)( 32,40)( 41,55)( 44,59)( 45,60)( 48,64)( 49,65)
  ( 51,67)( 54,71)( 61,80)( 66,81)( 72,84)( 74,87)( 75,90)( 76,93)
  ( 78,96)( 79,99)( 83,100)( 86,102)( 89,104)( 92,106)( 95,108)( 98,110)
  (103,112)(107,113)(111,114),( 1,23)( 3,24)( 5,28)( 8,29)(10,33)(12,34)
  (13,35)(15,36)(17,37)(18,41)(20,42)(22,43)(25,44)(26,45)(27,46)(30,47)
  (31,48)(32,49)(38,50)(39,51)(40,52),( 4,6)( 9,11)(13,15)(16,19)(22,24)
  (29,31),( 3,4)(10,11)(14,15)(17,18),( 2,4)( 6,8)(11,13),
 ( 1,2)( 3,10)( 4,11)( 6,13)( 8,14),( 1,9)( 4,13)( 6,16)( 7,18)(10,21)
  (15,23),( 7,8)( 9,12)(15,16)(17,18)(21,24),
 ( 1,6)( 2,7)( 4,11)( 5,13),( 4,5)( 7,8)( 9,10)(13,14)(18,19)(21,22),
 ( 2,3)(10,11)(13,14)(18,19)(21,22)(25,26),
 ( 5,6)( 8,9)(11,12)(18,19)(23,24)(26,27)(29,30)(32,33),
 ( 1,3)( 4,6)( 9,11)(12,15)(18,20)(21,24)(27,29)(30,33)(36,38)(39,41)
  (46,47)(49,50)(52,53)(55,56)(59,60)(63,64)(66,67)(69,70)(72,73)(76,77),
 ( 9,12)(13,16)(17,21)(22,26)(27,30)(31,34)(35,38)(39,43)(44,48)(49,52),
 ( 1,4)( 5,11)( 8,12),( 1,11)( 3,15)( 5,22)( 8,23)(12,24)(16,25)(20,26),
 ( 2,3)( 5,6)(15,16)(20,21)(23,24)(26,27)(32,33)(36,37)(43,44)(47,48),
 ( 1,2)( 9,10)(13,14)(17,18)(21,22),( 3,4)(10,11)(15,16)(18,19),
 ( 1,11)( 3,15)( 5,16)( 7,20)( 8,21)(10,22)(12,23)(14,24)(17,25)(19,26),
 ( 4,5)( 7,8)(10,11)(12,13)(15,16)(17,18)(19,20)(21,22)(23,24)(25,26)
  (28,29)(31,32)(33,34)(35,36)(37,38),( 4,7)(11,13)(14,16)(17,19)(21,24)
  (27,30)(31,34)(35,37)(38,39)(43,44)(47,48)(60,62)(63,65)(66,68)(69,71)
  (72,74)(75,77),( 1,7)( 2,9)( 4,10)( 6,12),
 ( 4,5)( 9,10)(12,14)(15,17)(18,20)(21,23)(24,26)(27,29),
 ( 1,2)( 3,9)( 6,11)( 8,13),( 2,24)( 4,25)( 5,26)( 7,29)( 9,30)(10,31)
  (12,32)(14,33)(16,35)(18,36)(20,37)(22,40)(23,41)(27,43)(28,44)(34,46)
  (38,48)(39,49)(42,50)(45,51)(47,52),( 4,7)( 6,8)( 9,11)(10,13),
 ( 5,6)( 8,9)(12,13)(15,16)(18,20)(23,24)(27,28),( 1,7)( 2,8)( 3,10),
 ( 4,5)(11,12)(16,17)(20,21)(23,24)(31,32),
 ( 4,6)( 8,10)(13,14)(19,20)(22,23)(25,26)(28,29)(31,32),
 ( 4, 6)( 11,12)( 13,16)( 20,22)( 24,25)( 29,32)( 41,42)( 46,47)
  ( 48,49)( 53,54)( 57,58)( 59,60)( 62,63)( 64,65)( 66,67)( 69,70)
  ( 71,72)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)
  ( 97,98)( 99,100)(101,102)(103,104)(105,106),
 ( 1,2)( 3,4)(12,14)(17,18)(21,22)(23,24)(28,29)(33,34)(35,36)(39,40)
  (43,45),( 2,10)( 4,14)( 6,16)( 8,19)(13,21)(17,24),
 ( 9,10)(12,13)(15,17)(18,20)(21,22)(23,24),
 ( 1,5)( 2,14)( 3,19)( 6,24)(12,27)(15,30)(22,33)(25,36),
 ( 5,10)( 6,12)( 7,14)( 8,15)( 9,17)(28,30)(29,33)(31,35)(32,36)(34,37),
 ( 3,10)( 5,12)( 7,13)( 8,16)(14,17)(15,18),
 ( 2,4)( 6,7)( 9,11)(13,15)(16,18),( 2,24)( 5,25)( 6,28)(10,29)(13,30)
  (15,31)(18,34)(20,35)(23,36)(27,37)(33,38),( 3,7)( 5,8)(10,14)(12,16),
 ( 2,24)( 5,25)( 7,28)(10,29)(11,30)(15,31)(18,34)(20,35)(23,36)(27,37)
  (33,38),( 5,6)( 8,9)(12,13)(16,17)(19,20)(23,24),
 (10,13)(15,17)(20,22)(24,26)(28,30)(32,35)(37,39)(42,44)(46,48)(50,52),
 ( 1,6)( 3,9)( 5,11),( 1,2)( 4,5)( 9,10)(11,12)(13,14)(17,18)(19,20)
  (21,22),( 7,8)(11,12)(14,15)(21,22)(23,24)(27,28)(30,31)(43,44)(52,53)
  (58,59)(61,62)(63,64)(66,67)(68,69)(71,72)(73,74)(76,77)(78,79)(81,82)
  (83,84)(86,87),(14,15)(16,17)(18,19)(20,21)(23,24)(26,27)(28,29)(30,31)
  (32,33)(34,35)(37,38)(40,41),( 1,3)( 9,11)(12,14)(17,19)(20,22)(24,26),
 ( 1,5)( 2,7)( 4,9)(10,13)(11,15),( 7,8)(11,12)(14,15)(21,22)(25,26)
  (29,30)(39,40)(44,45)(49,50)(54,55)(58,59)(62,63)(64,65)(67,68)(69,70)
  (72,73)(74,75)(78,79)(80,81)(83,84)(85,86)(88,89),
 ( 2,4)( 5,9)(11,14)(16,18)(20,22),( 2,4)(11,12)(13,14)(15,16),
 ( 6,7)(10,12)(16,17)(21,23)(26,27)(31,33)(36,38)(41,43)(46,48)(51,53),
 ( 9,10)(14,15)(22,23)(24,25)(26,27)(28,29)(30,31),
 ( 4,13)( 5,15)( 6,17)( 7,23)( 8,26)( 9,28)(10,33)(11,37)(14,38)(16,39)
  (19,40)(20,41)(21,42)(24,46)(25,47)(27,48)(30,49)(31,50)(35,53)(36,54)
  (43,55)(44,56)(45,57)(51,59)(52,60)(58,62)(61,63),
 ( 1,3)( 2,5)( 6,9)(10,12)(11,13),( 9,31)(12,32)(14,33)(17,34)(19,36)
  (22,37)(24,38)(26,41)(28,42)(30,43)(45,59)(46,60)(47,62)(48,63)(51,64)
  (52,66)(53,67)(54,70)(57,71)(73,76)(74,78),
 ( 9,30)(10,32)(12,33)(13,34)(15,35)(17,37)(19,38)(21,39)(23,41)(25,43)
  (26,44)(28,45)(48,61)(49,62)(54,68)(55,69)(59,73)(64,75)(66,77),
 ( 1,2)( 6,7)(13,14)(18,19)(26,27)(33,34),
 ( 6,7)( 9,10)(12,13)(16,17)(20,21),( 7,10)(12,13)(14,16)(19,21)(22,23),
 ( 7,22)( 12,23)( 18,24)( 21,25)( 26,40)( 27,44)( 28,48)( 29,49)
  ( 32,53)( 33,57)( 34,59)( 35,63)( 37,68)( 43,82)( 46,83)( 52,84)
  ( 56,85)( 62,86)( 66,87)( 70,88)( 71,91)( 72,93)( 73,95)( 74,99)
  ( 75,101)( 76,103)( 77,106)( 78,108)( 79,110)( 80,112)( 81,114)( 89,124)
  ( 94,127)(100,129)(104,132)(109,134)(113,137)(116,141)(118,145)(120,149)
  (122,153),( 1,3)( 5,8)( 7,11),( 1,6)( 4,11)( 7,13),
 ( 5,7)(10,11)(15,17)(20,22)(25,27)(30,32)(35,37)(41,42)(45,47)(51,52),
 ( 5,15)( 6,16)( 8,19)(10,20)(11,23)(13,24),
 ( 1,12)( 2,17)( 3,21)( 4,26)( 5,30)( 6,35)( 7,39)( 8,44)( 9,48)(10,53),
 ( 2,3)( 7,8)(11,12)(16,17)(20,21),( 1,2)( 4,9)( 6,11)( 8,13),
 ( 3,8)( 5,10)( 6,11),( 1,10)( 2,12)( 3,13)( 7,14)( 9,15)(11,16),
 ( 3,4)( 5,7)( 8,9)(10,11)(12,13),(2,4)(5,6)(7,9),
 ( 4,21)( 6,23)( 8,25)(10,26)(12,27)(14,29)(17,31)(18,32)(20,33)(24,34)
  (30,35),( 1,3)( 5,7)( 9,12)(14,17)(19,22),
 ( 1,3)( 5,7)( 9,11)(13,14)(16,17)(19,20)(21,22)(23,24)(26,27)(29,30)
  (31,32)(33,34)(35,36)(38,39)(41,42)(43,44)(45,46)(47,48)(50,51)(53,54),
 ( 4,21)( 6,22)( 7,23)(10,25)(12,27)(14,28)(16,29)(18,31)(20,33)(24,34)
  (30,35),( 6,7)( 8,9)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 4,6)( 9,10)(13,15)(17,18)(20,21),( 8,9)(13,14)(18,19)(22,23)(28,29)
  (32,33)(37,38)(42,43)(46,47)(52,53),( 4,5)(14,16)(17,19)(22,24)(25,27)
  (28,29)(31,33)(43,44)(45,46)(50,51)(52,53)(54,55)(72,73)(76,77),
 ( 5,8)( 9,11)(12,15)(16,19)(20,22)(23,26),( 3,9)( 4,11)( 6,13)( 7,15),
 ( 4,5)( 9,10)(13,14)(21,22)(26,27)(29,30)(33,34)(52,53)(56,57)(60,61)
  (63,64)(66,67)(69,70)(72,73)(75,76),( 1,4)( 5,7)(12,14)(15,17)(22,24)
  (25,28)(33,35)(37,39)(46,47)(51,52)(55,56)(59,60)(63,64)(68,69)(72,73)
  (76,77),( 7,17)( 8,20)( 9,24)(10,28)(16,34)(21,36)(29,39)(30,41)(31,47)
  (32,49)(38,55)(42,58)(44,61)(46,64)(50,67)(52,70)(53,72)(59,74)(65,76),
 ( 5, 6)( 8, 9)( 14,15)( 30,31)( 34,35)( 39,40)( 42,43)( 44,45)
  ( 47,48)( 50,51)( 53,54)( 55,56)( 58,59)( 80,81)( 82,83)( 84,85)
  ( 86,87)( 88,89)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107)(110,111)(112,113)(114,115)(116,117)(118,119)(134,135)
  (136,137)(138,139)(140,141)(142,143)(144,145)(146,147)(148,149)(150,151)
  (152,153)(154,155)(156,157)(158,159)(160,161)(162,163)(164,165)(166,167)
  (168,169)(170,171)(172,173)(174,175)(185,186)(188,189)(192,193)(195,196)
  (199,200)(202,203),( 5,6)(10,11)(16,17)(21,22)(27,28),
 ( 4,6)( 7,9)(10,11)(12,13)(14,15)(16,18)(19,20)(21,22)(23,24)(25,27)
  (28,30)(31,32)(33,34),( 4,6)( 9,10)(13,14)(17,18)(21,23)(25,27)(30,31)
  (34,35)(38,39)(42,44),( 4,6)( 7,9)(10,11)(13,14)(16,17),
 ( 4,6)( 9,10)(13,14),( 1,6)( 5,10)( 7,12),
 ( 2,8)( 4,12)( 6,20)(11,21)(14,22)(19,25)(24,28)(27,29),
 ( 7,8)(10,12)(13,15)(16,17)(19,20),( 4,21)( 7,22)( 9,24)(10,25)(12,26)
  (14,27)(16,30)(17,31)(20,32)(23,34)(28,36),
 ( 5,6)( 8,9)(15,16)(18,19)(22,23)(25,26)(29,30)(32,33),
 ( 5,33)( 8,34)(11,35)(14,36)(19,37)(29,38)(32,39)(40,58)(42,61)(43,63)
  (44,66)(47,68)(48,71)(49,73)(51,76)(52,78)(53,81)(56,83)(57,86)(64,88)
  (65,89)(74,90)(75,91)(84,92)(85,93),( 2,3)( 5,6)( 9,10)(12,13)(28,29)
  (30,31)(32,33)(34,35)(60,61)(62,63)(64,65),
 ( 5,6)( 8,9)(16,18)(20,21)(23,25)(30,32)(34,35)(37,39),
 ( 1,6)( 2,9)( 5,11),( 1,2)( 7,8)( 9,10)(12,13),
 ( 1,2)(10,11)(14,15)(17,18),( 6,7)( 9,11)(13,14)(16,17)(20,21)(24,25)
  (28,29),( 2,8)( 4,11)( 5,13)( 7,17)( 9,21)(12,22)(14,23)(16,24)(18,25)
  (20,26),( 4,20)( 5,23)( 7,26)( 8,29)( 9,32)(11,35)(12,38)(14,41)(15,44)
  (16,47),( 3,4)(14,15)(18,19)(22,23)(25,26)(27,28)(31,32)(33,34),
 ( 1,9)( 2,11)( 4,12)( 6,14)( 7,15)(10,16)(13,17),
 ( 1,3)( 7,8)(14,15)(20,21)(24,25)(28,29)(32,33)(36,37)(40,41)(44,45)
  (48,49)(52,53),( 2,6)( 8,11)(14,15)(16,17),
 ( 1,2)( 3,4)( 5,6)(10,11)(13,14)(18,19)(23,24)(26,27),
 ( 1,13)( 2,15)( 3,16)( 4,18)( 5,21)( 6,24)( 7,26)( 8,28)( 9,31)(10,35)
  (11,38)(12,39)(20,44)(22,45)(23,46)(32,51)(34,52)(36,53),
 ( 2,4)( 8,9)(11,12)(14,16)(19,20),( 4,6)( 7,9)(12,14)(16,17)(19,21)
  (23,24)(29,30),( 1,2)(10,11)(17,18)(19,20)(21,22)(23,24),
 ( 3,5)( 6,8)( 9,11)(13,15)(18,20)(24,26)(29,31)(32,34),
 ( 7,13)( 8,16)( 9,21)(10,24)(18,34)(23,36)(29,41)(30,44)(31,49)(32,52)
  (37,54)(39,57)(43,60)(45,63)(47,66)(51,69)(58,72)(64,74)(70,76),
 ( 1,13)( 2,15)( 4,17)( 6,19)( 8,20)(11,21)(14,22)(16,23)(18,24),
 ( 4,5)( 9,10)(14,15)(19,20)(23,24)(27,28)(31,32)(36,37)(41,42)(46,47)
  (50,51)(54,55),( 5,6)( 9,11)(12,14),( 3,4)( 7,8)(11,12)(14,15)(19,20)
  (23,24)(27,28)(32,33),( 2,3)( 4,5)( 7,8)( 9,10)(13,14)(16,17)(19,20)
  (22,23)(25,26)(28,29),( 2,10)( 3,12)( 4,15)( 5,16)( 8,19)( 9,21)(11,22)
  (14,23)(18,24)(20,25),( 4,8)(15,19)(20,23)(24,25)(26,27)(28,29)(30,31),
 ( 3,5)( 6,8)(11,14)(15,17)(20,23)(24,26)(29,32)(33,35)(38,40)(41,43)
  (44,45)(48,49)(51,52)(54,55)(57,58)(61,62)(65,66)(68,69)(71,72)(74,75),
 ( 2,4)( 6,8)(13,16)(17,19)(24,26)(27,29)(34,36)(37,40)(46,47)(50,51)
  (55,56)(59,60)(63,64)(67,68)(72,73)(76,77),
 (12,15)(16,17)(18,19)(20,22)(23,25)(26,28)(29,31)(32,34)(35,37)(38,39)
  (40,41)(42,45),( 4,20)( 6,22)( 8,25)( 9,26)(11,27)(13,29)(16,32)(17,33)
  (19,34)(24,35)(31,36),( 2,4)( 9,10)(15,17)(19,21)(23,24)(28,29)(33,34)
  (37,38)(40,41),( 1,3)( 5,6)( 8,10)(12,14)(16,17)(19,20)(22,23)(24,25)
  (26,27)(29,30)(31,32)(34,35)(36,37)(38,39)(41,42)(43,44)(46,47)(48,49)
  (50,51)(53,54),( 7,8)(10,11)(12,13)(15,16)(18,19)(21,22)(23,24)(26,27)
  (28,29)(31,33)(34,35)(36,38)(40,41)(45,46)(49,50)(56,57)(60,61),
 ( 1,8)( 3,10)( 4,12)( 5,13)( 6,15)( 7,17),
 ( 2,3)( 6,7)(16,17)(20,21)(24,25)(27,28)(31,32)(34,35),
 ( 1,21)( 2,23)( 3,25)( 4,26)( 5,28)( 6,30)( 7,31)( 8,32)(17,33)(18,34)
  (19,35)(20,36),( 2,8)( 4,10)(12,14)(13,15),
 ( 2,3)( 6,7)(16,17)(21,22)(24,25)(27,28)(30,31),
 ( 3,5)( 6,7)( 8,9)(12,13)(14,15),( 5,31)( 9,35)( 12,38)( 14,41)
  ( 19,45)( 23,48)( 24,52)( 25,62)( 26,71)( 27,74)( 28,78)( 29,81)
  ( 30,82)( 34,84)( 40,85)( 44,87)( 51,94)( 53,97)( 54,98)( 57,99)
  ( 58,102)( 61,103)( 63,105)( 66,106)( 67,108)( 70,109)( 72,112)( 76,113)
  ( 77,115)( 79,116)( 83,117)( 86,118)( 88,120)( 89,122)( 90,125)( 91,127)
  ( 92,130)( 93,132)( 96,134)(101,136)(111,138)(119,139)(121,140)(123,141)
  (124,142)(126,143)(128,144)(129,145)(131,146)(133,147)(135,148)(137,149),
 ( 6, 7)( 9,10)( 11,12)( 17,18)( 19,20)( 23,24)( 25,26)( 32,33)
  ( 38,39)( 46,47)( 49,50)( 53,54)( 59,60)( 63,64)( 69,70)( 73,74)
  ( 79,80)( 99,100)(101,102)(103,104)(105,106)(107,108)(109,110)(111,112)
  (115,116)(119,120)(121,122)(151,152)(153,154)(155,156)(157,158)(159,160)
  (161,162),( 4,20)( 6,21)( 8,25)(10,26)(11,27)(12,28)(15,32)(16,33)(19,34)
  (24,35)(31,36),( 2,4)(10,12)(14,16)(18,19)(20,22)(24,25),
 ( 4,6)( 7,8)(10,11)(13,14)(15,17),( 4,6)( 7,8)(10,11)(13,14)(15,16)
  (17,18),( 1,2)(11,12)(14,15)(17,18)(22,23)(24,25)(26,27)(28,29)(30,31)
  (32,33),( 2,3)( 7,10)(11,14)(18,21)(23,26),
 ( 2,8)( 4,9)( 6,12)(10,15)(13,16),( 9,10)(12,13)(14,17)(18,19)(21,22)
  (24,25),( 5,6)( 9,11)(15,16)(17,18)(21,23),
 ( 5,6)( 9,11)(15,16)(20,22)(25,26)(30,32)(35,37)(40,42)(45,47)(50,52),
 ( 3,4)( 7,8)(11,12)(21,22)(26,27)(29,30)(34,35)(38,39)(41,42)(44,45)
  (48,49)(51,52),( 4,5)( 7,8)(15,16)(18,19)(21,22)(23,24)(27,28)(29,30),
 ( 1,9)( 3,14)( 5,16)( 7,20)(11,22)(17,23),( 2,7)( 4,9)(12,14)(13,15),
 ( 2,5)( 4,9)( 6,10),( 3,5)( 7,9)(10,13)(15,17)(19,21),
 ( 3,10)( 5,12)( 6,13)( 9,15)(11,16),( 2,10)( 4,14)( 6,16)( 8,21)(13,22)
  (19,23),( 1,2)(11,12)(15,16)(19,20)(23,24)(26,27)(29,30)(32,33),
 ( 1,20)( 2,22)( 3,23)( 4,25)( 5,26)( 6,28)( 7,29)( 8,30)( 9,32)(18,33)
  (19,34),( 4,20)( 7,21)( 8,22)(10,26)(12,27)(14,28)(16,31)(19,32)(24,33)
  (25,34)(29,36)(30,37),( 1,3)( 6,8)( 9,11)(12,14),
 ( 1,20)( 2,22)( 3,23)( 4,24)( 5,26)( 6,27)( 7,29)( 8,30)( 9,32)(18,33)
  (19,34),( 1,3)( 6,8)( 9,11)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 (14,16)(17,18)(19,20)(21,22)(23,24)(25,27)(28,30)(31,32)(33,34)(35,36)
  (37,38)(39,41),( 1,9)( 3,12)( 4,15)( 5,18),
 ( 1,2)(11,12)(15,16)(19,20)(24,25)(27,28)(29,30)(32,33)(37,38)(40,41),
 ( 3,7)( 5,8)(11,14)(15,17)(16,18),( 2,7)( 4,8)( 9,13)(10,16),
 ( 1,2)( 6,7)(12,13)(17,18)(20,21)(23,24),
 ( 6,7)(18,19)(22,23)(29,30)(31,32)(35,36)(40,41)(44,45)(50,51)(52,53)
  (55,56)(58,59)(61,62)(63,64)(66,67)(69,70)(71,72)(73,74)(75,76),
 ( 5,7)( 8,10)(11,13)(15,17)(21,23)(25,27),
 ( 5,6)( 7,8)( 9,10)(16,17)(23,24)(25,26),
 ( 5,17)( 6,19)( 9,20)(12,22)(13,23)(16,25),
 ( 1,20)( 2,21)( 3,23)( 4,24)( 5,25)( 6,26)( 7,28)( 8,30)( 9,31)(18,33)
  (19,35),( 2,3)( 7,8)(10,11)(14,15),( 1,8)( 2,10)( 4,12)( 7,14),
 ( 1,2)( 5,6)(10,11)(15,16)(18,19)(21,22),
 (14,15)(16,17)(19,20)(21,22)(24,25)(26,27)(28,29)(30,31)(33,34)(35,36)
  (38,39)(40,41),( 1,4)( 8,11)(14,16)(20,21)(23,25)(28,30)(32,33)(35,37)
  (40,42)(44,45)(47,49)(52,54),( 3,5)( 7,9)(12,13)(16,18)(21,23),
 ( 3,6)( 8,10)(12,15)(16,18)(20,23),( 5,6)( 8,9)(13,14)(16,17),
 ( 8, 9)( 13,14)( 16,17)( 19,20)( 23,24)( 27,28)( 37,38)( 41,42)
  ( 48,49)( 50,51)( 53,54)( 55,56)( 57,58)( 60,61)( 62,63)( 65,66)
  ( 71,72)( 77,78)( 84,85)( 87,88)( 90,91)( 93,94)( 96,97)( 99,100)
  (102,103)(104,105)(106,107)(108,109)(110,111)(112,113),
 ( 7,10)(12,13)(16,17)(20,22)(24,26)(29,32)(39,40)(44,45)(47,49)(52,54)
  (57,59)(63,64)(65,66)(68,69)(70,71)(73,75)(76,78)(82,84)(85,87)(88,90)
  (94,96),( 1,2)( 4,10)( 7,12),( 1,9)( 3,12)( 6,15)( 7,19)(11,21)(16,23)
  ,( 6,7)(11,12)(17,18)(23,24)(28,29),( 1,7)( 2,11)( 3,15)( 4,19),
 ( 11,12)( 14,15)( 17,18)( 22,23)( 26,27)( 37,38)( 39,40)( 41,42)
  ( 45,46)( 49,50)( 51,52)( 54,55)( 56,57)( 58,59)( 61,62)( 63,64)
  ( 66,67)( 68,69)( 74,75)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(105,106)(107,108)(109,110)(111,112)(113,114),
 ( 3,7)( 8,11)( 9,12)(10,13)(14,16)(15,17),( 1,4)( 2,12)( 5,13),
 ( 5,6)( 8,9)(13,14)(18,19)(24,25)(31,32),
 ( 2,3)(11,12)(16,17)(19,20)(22,23)(25,26),
 ( 1,12)( 2,16)( 3,21)( 4,25)( 5,30)( 6,34)( 7,39)( 8,43)( 9,48)(10,52),
 ( 3,5)( 7,8)(10,11)(12,14)(15,17)(18,20)(21,22)(23,24)(25,26)(27,28)
  (29,30)(31,32)(33,34),( 4,5)( 8,10)(15,16)(23,25)(26,28)(29,30)(31,32)
  (33,34),( 3,5)( 7,8)(10,11)(13,15)(18,20)(24,25)(29,30)(33,34),
 ( 1,5)( 2,11)( 6,12),(10,11)(14,15)(19,20)(24,25)(28,29)(32,33)(36,37)
  (41,42)(46,47)(50,51),( 1,2)( 6,7)(17,18)(24,26)(27,29)(31,33)(34,36),
 ( 1,2)( 3,4)( 5,6)( 8,10)(12,14)(16,18)(20,22),
 ( 9,11)(14,16)(19,21)(23,24)(25,26)(30,31)(33,34),
 (17,19)(21,22)(24,26)(31,33)(35,36)(38,40)(41,42)(43,44)(45,46)(47,48)
  (49,50)(51,52),( 1,5)( 2,10)( 3,18)( 6,20)( 8,22)(13,25)(14,27)(17,30)
  (24,33)(29,35)(32,37),( 6,9)(10,11)(12,16)(17,18)(19,22),
 ( 1,2)( 4,7)(12,14)(16,19)(24,26),( 1,9)( 3,11)( 5,12)( 6,14)( 8,15)
  (10,16)(13,17),( 2,10)( 5,13)( 7,14)( 9,16)(18,22)(19,27),
 ( 1,4)( 9,12)(13,15)(18,20)(21,23)(24,26),
 ( 3,4)( 8,9)(12,13)(15,16)(18,19)(22,23)(25,26)(30,31),
 ( 4,6)( 8,10)(12,14)(15,17)(19,21)(23,25)(26,28)(30,31)(33,35)(37,39)
  (41,42)(44,46)(48,50)(52,53)(55,57),( 1,3)( 7,12)( 9,13)(11,14),
 ( 2,7)( 3,9)( 5,12),(10,11)(15,16)(20,21)(24,25)(28,29)(32,33)(37,38)
  (42,43)(46,47)(50,51),( 1,2)(12,13)(16,17)(20,21)(25,26)(27,28)(31,32)
  (33,34),( 6,7)(12,13)(16,17)(20,21)(23,24)(25,26)(28,29),
 ( 4,18)( 6,21)( 7,24)( 8,27)(10,30)(11,33)(13,36)(14,39)(15,42)(17,45),
 ( 1,4)( 9,11)(12,15)(17,19)(20,22)(24,26),
 ( 4,6)( 8,10)(12,14)(16,18)(22,24)(28,30)(33,35)(52,53)(56,57)(59,61)
  (62,64)(65,67)(68,70)(71,73)(74,76),( 4,21)( 7,22)( 9,24)(11,26)(13,27)
  (15,28)(17,30)(18,32)(20,33)(23,34)(29,35),
 ( 2,3)( 7,8)(12,13)(19,20)(23,24)(25,26),
 ( 1,2)(10,11)(14,15)(17,18)(20,21)(24,25),
 ( 3,6)( 4,8)( 5,10)(12,16)(13,18)(14,20)(15,22),( 2,7)( 3,8)( 5,10),
 ( 1,4)( 2,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 1,3)( 7,8)(11,12)(18,19),( 3,4)( 8,9)(12,13)(20,21)(27,28)(35,36)
  (42,43),( 1,10)( 3,14)( 5,16)( 7,21)(12,22)(18,23),
 ( 2,5)( 7,9)(11,14)(16,18)(20,23),( 1,5)( 8,16)( 9,19)(12,28)(13,31)
  (21,42)(22,43)(29,46)(30,47)(37,50)(38,51),
 ( 5,6)( 9,10)(13,14)(17,18)(23,24)(29,30)(34,35)(52,53)(56,57)(60,61)
  (63,64)(66,67)(69,70)(72,73)(75,76),( 1,2)( 7,8)(10,11)(13,14)(17,18)
  (21,22),( 5,6)(14,15)(19,20)(23,24)(26,27)(29,30)(32,33)(35,36),
 ( 6,7)( 9,10)(14,15)(17,18)(22,23)(26,27),
 ( 1,10)( 3,13)( 5,17)( 7,19)(11,22)(15,25),
 ( 4,5)(10,11)(16,17)(21,22)(27,28),( 5,6)( 9,10)(13,14)(18,19)(22,23)
  (24,25)(28,29),( 1,3)( 8,10)(11,14)(19,21)(23,25)(30,33)(34,36)(41,43)
  (46,47)(50,51)(54,55)(58,59)(63,64)(67,68)(71,72)(75,76),
 ( 1,24)( 3,26)( 5,27)( 7,28)( 9,31)(10,32)(12,33)(14,34)(15,35)(17,38)
  (19,39)(20,40)(22,41)(25,43)(29,45)(30,46)(36,48)(37,49)(42,50)(44,51)
  (47,52),( 6,7)( 9,10)(14,15)(18,19)(22,23)(25,26),
 ( 7,8)(11,13)(15,17)(18,19)(21,22)(24,25)(27,28)(30,31),
 ( 1,7)( 2,13)( 3,21)( 6,25)(15,28)(18,30)(24,32)(27,34),
 ( 1,2)( 3,11)( 5,13),( 4,5)( 8,9)(11,12)(18,19)(21,22)(25,26)(30,31)
  (42,43)(51,52)(59,60)(61,62)(64,65)(66,67)(69,70)(71,72)(74,75)(76,77)
  (79,80)(81,82)(84,85)(86,87),( 5,21)( 7,22)( 9,23)(10,24)(13,27)(14,28)
  (17,29)(19,30)(20,33)(25,34)(31,35),( 9,10)(13,14)(17,18)(21,22)(24,25)
  (28,29)(30,31)(35,36)(37,38)(42,43)(44,45)(47,48),
 ( 1,9)( 2,10)( 4,11)( 5,13)( 7,14)( 8,15),
 ( 8,11)(13,15)(17,19)(22,24)(27,30)(32,35)(37,39)(41,43)(46,48)(51,54),
 ( 5, 6)( 16,17)( 20,21)( 24,25)( 26,27)( 30,31)( 33,34)( 37,38)
  ( 39,40)( 43,44)( 48,49)( 54,55)( 58,59)( 62,63)( 64,65)( 77,78)
  ( 81,82)( 85,86)( 89,90)( 93,94)( 96,97)(100,101)(104,105)(108,109)
  (112,113)(115,116)(119,120)(123,124)(127,128)(130,131)(138,139)(142,143)
  (150,151)(153,154)(156,157)(160,161)(163,164)(167,168)(170,171)(174,175)
  (177,178)(180,181)(184,185)(187,188)(191,192)(194,195)(198,199)(202,203)
  (205,206)(209,210)(212,213)(216,217)(219,220)(223,224)(226,227)(230,231)
  (233,234)(237,238)(240,241)(264,265)(268,269)(272,273)(276,277)(280,281)
  (284,285)(288,289)(292,293)(296,297)(300,301)(304,305)(308,309)(311,312)
  (314,315)(317,318)(320,321)(323,324)(326,327)(329,330)(332,333)(335,336)
  (338,339)(341,342)(344,345),( 4,5)( 8,9)(12,13)(14,15)(17,18),
 ( 1,9)( 4,13)( 6,15)( 8,17)(12,19),( 8,11)(14,16)(18,21)(23,25)(28,30)
  (32,35)(38,40)(42,45)(47,49)(52,54),( 1,9)( 4,12)( 5,15)( 7,18)(10,21)
  (14,24),( 3,4)( 8,9)(13,14)(20,21)(27,28)(33,34),
 ( 1,3)( 2,9)( 4,11)( 6,12)( 8,14),( 4,7)( 8,10)(12,15)(16,18),
 ( 4,5)(11,12)(14,15)(17,18)(20,21)(23,24)(27,28)(30,31),
 ( 3,18)( 6,19)( 9,21)(10,22)(13,24)(16,25),
 ( 1,9)( 4,12)( 6,15)( 8,18)(11,21),( 9,33)( 11,34)( 14,35)( 28,36)
  ( 30,37)( 32,38)( 39,46)( 40,48)( 41,51)( 42,53)( 43,56)( 44,58)
  ( 45,61)( 55,72)( 62,74)( 63,77)( 64,80)( 65,81)( 66,83)( 67,86)
  ( 68,89)( 69,92)( 70,93)( 71,95)( 73,98)( 75,99)( 76,101)( 78,102)
  ( 79,103)( 82,105)( 84,106)( 85,108)( 87,109)( 88,111)( 90,112)( 91,113)
  ( 94,115)( 96,116)( 97,117)(104,118)(110,119),
 ( 1,4)( 2,8)( 3,14)(10,24)(13,26)(19,29)(20,31),
 ( 1,2)( 4,5)( 7,8)(10,11)(13,14)(15,16)(19,20)(23,24),
 ( 4,7)( 8,10)(13,15)(17,19)(23,25)(30,32),
 ( 7,8)(11,12)(13,14)(18,19)(25,26)(29,30)(48,49)(54,55)(56,57)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78)(80,81),
 ( 7,9)(11,13)(14,16)(18,20)(21,23)(28,30)(32,34)(39,41)(44,46)(47,48)
  (49,50)(51,52)(55,57)(58,59)(60,61)(62,64),
 ( 2,3)( 8,9)(10,11)(13,14)(15,16)(17,18)(19,20),
 ( 2,7)( 4,9)( 6,17)(11,23)(16,26)(19,27)(22,28)(25,29),
 ( 1,7)( 2,9)( 5,11),( 1,6)( 2,11)( 3,16)( 4,20)( 7,22)(10,25)(14,27)
  (18,30)(23,33)(28,35)(31,37),( 4,33)( 8,34)(11,35)(16,36)(25,37)(28,38)
  (30,39)(40,58)(41,62)(42,63)(45,67)(46,68)(47,72)(49,73)(50,77)(51,78)
  (54,82)(55,83)(56,87)(64,88)(66,89)(74,90)(76,91)(84,92)(86,93),
 ( 1,24)( 4,25)( 6,28)( 9,29)(13,30)(14,31)(17,34)(19,35)(22,36)(26,37)
  (32,38),( 1,7)( 2,12)( 3,19)( 8,26)(13,27)(17,30)(22,31),
 ( 5,6)( 9,11)(16,17)(23,25)(26,28)(29,30)(31,32)(33,34),
 ( 3,4)( 7,8)(11,12)(22,23)(26,27)(28,29)(32,33)(34,35),
 ( 8,9)(12,13)(17,18)(20,21)(23,24)(27,28)(31,32)(35,36)(38,39)(41,42)
  (46,47)(50,51),( 7,8)(11,12)(14,15)(18,19)(22,23)(25,26),
 ( 5,7)( 8,11)(12,15)(16,18)(19,22)(23,26),
 ( 7,8)(11,12)(14,15)(18,19)(20,21)(24,25)(37,38)(40,41)(43,44)(47,48)
  (51,52)(54,55)(71,72)(74,75)(77,78)(80,81),
 ( 6,38)( 9,39)(12,40)(15,42)(18,43)(19,44)(21,45)(24,47)(29,48)(32,49)
  (35,50)(52,62)(54,65)(55,68)(56,71)(58,74)(59,77)(63,78)(69,79)(75,80),
 ( 2,4)( 5,11)( 7,12),( 2,3)( 8,9)(13,14)(19,20)(25,26),
 ( 9,31)(11,32)(12,33)(14,35)(16,37)(17,38)(19,39)(21,40)(23,43)(25,44)
  (28,45)(29,47)(51,62)(52,63)(57,65)(58,66)(61,70)(64,72)(67,74),
 ( 4,5)( 8,9)(12,13)(17,18)(22,23),( 2,4)( 5,10)( 6,11),
 ( 4,6)( 8,10)(15,18)(19,21)(26,28)(29,31)(36,38)(39,42)(44,45)(48,49)
  (52,53)(57,58)(61,62)(65,66)(69,70)(74,75),
 ( 5,18)( 6,21)( 7,24)( 9,27)(10,30)(12,33)(13,36)(14,39)(16,42)(17,45),
 ( 1,2)( 8,10)(12,13)(17,18)(19,21)(23,25)(26,28)(31,33)(34,36)(38,40)
  (41,42)(46,47)(49,51),( 5,7)( 8,10)(11,13)(14,16)(19,21)(24,26)(28,30),
 ( 4,20)( 7,21)( 9,24)(11,26)(12,27)(14,28)(16,31)(17,33)(19,34)(22,35)
  (29,36),( 7, 9)( 11,13)( 18,20)( 23,24)( 27,28)( 37,38)( 39,40)
  ( 44,45)( 47,49)( 52,53)( 57,58)( 64,65)( 67,69)( 70,71)( 73,75)
  ( 76,77)( 84,85)( 87,88)( 90,91)( 93,94)( 96,97)( 99,100),
 ( 1,4)( 2,15)( 3,20)( 6,24)( 9,26)(14,28)(17,30),
 ( 8,10)(12,14)(17,19)(22,25)(27,30)(32,34)(36,38)(41,43)(46,49)(51,54),
 ( 3,15)( 4,18)( 8,19)( 9,22)(10,23)(14,26),( 1,9)( 3,12)( 5,15)( 6,18),
 ( 8,9)(11,12)(14,15)(17,18)(20,21)(22,23)(26,27)(28,29),
 ( 2,14)( 4,20)( 6,22)( 9,23)(11,24)(16,25)(19,26),
 ( 4,5)( 9,10)(20,21)(24,26)(27,29)(32,34)(37,39)(40,42),
 ( 1,8)( 4,12)( 7,16)(11,17)(15,18),( 3,5)(11,12)(13,14)(15,16),
 ( 7, 8)( 11,12)( 15,17)( 22,24)( 26,28)( 36,38)( 40,41)( 45,46)
  ( 47,48)( 51,52)( 58,59)( 63,64)( 68,69)( 70,72)( 74,75)( 76,78)
  ( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101),
 ( 7,10)( 12,13)( 14,17)( 20,22)( 25,26)( 35,36)( 39,40)( 42,43)
  ( 45,47)( 49,51)( 58,60)( 61,63)( 66,68)( 70,71)( 72,74)( 76,77)
  ( 80,82)( 90,92)(102,104)(105,107)(108,110)(113,115)(116,118)(119,121),
 ( 1,4)( 2,13)( 3,18)( 6,23)(12,26)(15,29)(22,32)(25,35),
 ( 1,8)( 4,11)( 6,13)( 7,16),( 1,3)( 5,9)( 6,10),
 ( 1,8)( 2,17)( 3,21)( 6,23)( 9,26)(15,29)(27,32)(30,35),
 ( 2,7)( 5,9)(12,16)(14,17)(18,20)(19,21),(1,5)(2,6)(3,7),
 ( 3,5)(14,16)(19,21)(24,25)(29,30)(32,33)(36,37)(39,40),
 ( 2,5)( 6,8)(10,12),( 4,19)( 6,20)( 7,23)( 9,26)(11,27)(13,30)(15,33)
  (18,34)(24,35)(25,36)(31,37)(32,38),( 4,5)( 8,10)(14,16)(19,21)(24,25)
  (29,31)(35,36)(39,41)(44,46)(50,52),( 1,5)( 3,12)( 7,14),
 ( 1,4)( 8,9)(10,12)(13,14)(15,16)(17,18)(19,20),
 ( 4,5)( 6,9)(10,12)(13,15)(17,20),( 1,11)( 2,16)( 3,23)( 6,24)(12,27)
  (17,28)(21,31),( 2,3)( 5,6)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23),
 ( 2,9)( 4,11)( 5,15)( 8,18)(14,22)(19,24),( 1,3)( 4,11)( 7,12),
 ( 1,7)( 2,11)( 5,13),( 1,3)(10,12)(13,15)(17,19)(20,22),
 ( 5,6)( 8,9)(10,11),( 1,19)( 2,21)( 3,22)( 4,23)( 5,25)( 6,26)( 7,28)
  ( 8,29)( 9,30)(10,32),( 6,7)(12,13)(14,16)(18,20)(21,22)(23,24)(27,28)
  (30,31),( 3,4)( 9,10)(14,15)(18,19)(23,24),
 ( 4,6)( 8,9)(12,14)(16,17),( 1,5)( 3,10)( 6,12),
 ( 1,3)(10,12)(15,17)(18,20)(21,23)(24,26),
 ( 3,4)( 9,10)(14,15)(20,21)(25,26),( 1,5)( 3,10)( 7,12)( 8,14)( 9,16)
  (11,17)(13,18)(15,19),( 3,4)( 9,10)(14,15)(20,21)(26,27),
 ( 1,3)(10,11)(13,14),( 1,2)( 5,13)( 6,14)( 7,17)( 8,18)(11,19)(12,20)
  (15,21)(16,22),( 1,2)( 5,13)( 6,15)( 7,17)( 8,18)(11,19)(12,20)(14,21)
  (16,22),( 1,15)( 2,19)( 3,24)( 4,28)( 5,33)( 6,37)( 7,42)( 8,46)( 9,51)
  (10,55),( 1,8)( 2,14)( 3,19)( 6,25)(10,27)(15,30)(21,32),
 ( 2,3)( 9,10)(14,15)(19,20)(25,26)(31,32),
 ( 4,7)( 9,11)(13,15)(16,18)(21,22)(28,29),
 ( 3,4)( 5,6)( 8,9)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 1,2)( 3,4)( 5,6)( 8,9)(11,12)(17,18)(20,21),
 ( 1,3)( 4,9)( 6,12),( 5,6)(10,12)(15,16)(20,22)(25,27)(30,32)(35,37)
  (40,42)(46,47)(50,52),( 3,4)( 5,6)(10,11)(12,13)(14,15),
 ( 2,7)( 8,12)(13,18)(19,24)(25,29),( 7,8)(10,12)(13,14)(15,17)(19,20)
  (21,22)(24,25)(26,27)(29,30)(32,33)(35,36)(37,38)(40,41)(46,47)(50,51)
  (57,58)(61,62),( 1,3)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 2,4)( 6,8)(10,13)(15,18)(20,23),( 1,11)( 2,14)( 4,15)( 6,18)( 7,19)
  (10,20)(13,21)(17,22),( 2,13)( 4,16)( 6,19)( 7,22)( 9,25)(11,28),
 ( 1,8)( 2,13)( 3,21)( 5,24)(10,26)(15,28)(20,30),
 ( 4, 5)( 8, 9)( 16,17)( 19,20)( 23,24)( 30,31)( 41,42)( 45,46)
  ( 49,50)( 51,52)( 55,56)( 58,59)( 60,61)( 63,64)( 65,66)( 67,68)
  ( 70,71)( 83,84)( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111),
 ( 1,24)( 3,27)( 5,28)( 7,29)( 9,32)(11,33)(12,34)(14,35)(16,36)(17,39)
  (19,40)(21,41)(22,42)(25,43)(26,44)(30,45)(31,46)(37,47)(38,48),
 ( 1,9)( 2,11)( 5,15)( 6,17),( 3,6)( 4,8)(12,16)(15,17)(18,20)(19,21),
 ( 6,7)(10,11)(14,15)(17,18)(22,23),( 1,2)( 5,7)(10,11)(13,14),
 ( 7,8)(11,12)(17,18)(21,22)(26,27)(31,32)(35,36)(41,42)(45,46)(50,51),
 ( 2,7)(11,25)(14,30)(17,31)(20,32)(24,33)(27,39)(29,48)(35,52)(38,56)
  (41,59)(44,63)(47,66)(50,70)(54,73)(58,74)(61,75)(65,76)(68,77)(72,78),
 ( 5,38)( 8,40)(11,41)(13,42)(18,43)(19,45)(21,46)(24,47)(28,48)(31,50)
  (34,51)(52,61)(54,64)(55,67)(56,70)(58,73)(59,76)(63,78)(69,79)(75,80),
 ( 3,4)( 6,9)(12,14)(17,18)(21,22),( 7,8)(11,12)(17,18)(23,24)(26,27)
  (30,31)(35,36)(52,53)(57,58)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 7,28)( 9,29)( 13,30)( 16,31)( 19,32)( 23,33)( 24,34)( 27,35)
  ( 36,57)( 40,58)( 42,61)( 43,62)( 48,64)( 51,67)( 53,68)( 59,82)
  ( 63,83)( 71,85)( 73,87)( 75,89)( 77,91)( 79,93)( 81,95)( 84,96)
  ( 86,98)( 88,100)( 90,102)( 92,104)( 94,106)( 99,108)(103,109)(107,110),
 ( 4,10)( 6,12)( 8,13)( 9,14)(11,15),( 9,25)( 12,26)( 15,28)( 18,29)
  ( 19,31)( 21,32)( 22,33)( 24,36)( 37,49)( 38,53)( 39,55)( 42,57)
  ( 43,59)( 44,62)( 45,66)( 48,68)( 51,72)( 56,73)( 64,74)( 70,81)
  ( 71,89)( 75,92)( 77,93)( 80,96)( 84,99)( 88,102)( 98,107)(101,108)
  (103,112)(105,119)(110,122)(115,123)(117,126)(118,127)(130,134)(132,138),
 ( 2,6)(10,16)(11,20)(23,29)(25,31)(26,35)(27,40)(28,44)(33,50)(34,52)
  (37,55)(39,58)(42,61)(43,63)(46,66)(48,69)(54,71)(60,73)(68,75),
 ( 5,11)( 6,14)( 7,16)( 9,17)(10,20)(23,26)(24,28)(25,30),
 ( 2,6)( 3,9)( 4,11),( 1,9)( 2,15)( 3,20)( 4,23)( 7,25)(16,28)(26,31)
  (29,33),( 1,2)( 3,11)( 6,13),( 5,6)( 8,9)(11,12)(16,17)(21,22)(24,25)
  ,( 1,2)( 9,10)(12,13)(17,18)(20,21),( 2,6)( 3,9)( 7,11),
 (10,31)(13,32)(15,34)(18,35)(20,36)(22,37)(24,39)(26,40)(27,41)(30,44)
  (45,58)(46,60)(47,61)(50,63)(51,64)(52,65)(53,67)(56,69)(57,71)(72,76)
  (73,78),( 1,11)( 3,17)( 5,19)( 7,23)(12,24)(15,25)(21,26),
 ( 1,2)( 5,6)( 8,9)(12,13),( 2,9)( 5,11)( 6,12)( 8,14),
 ( 1,7)( 2,9)( 4,12),( 7,8)( 9,11)(12,14)(15,17)(19,20)(21,23)(25,26)
  (27,29)(30,31)(32,33)(41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(60,61)
  (62,64)(66,67)(68,70)(72,73)(74,76),( 1,2)( 9,10)(13,14)(17,18)(20,21),
 ( 7,8)( 9,11)(12,14),( 1,8)( 2,12)( 5,15)(11,17)(14,20),
 ( 1,5)( 4,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 4,5)( 7,8)(10,11)(12,14)(15,17),( 1,6)( 3,12)( 5,13),
 ( 7,8)( 9,11)(12,13)(15,17)(18,20)(21,23)(24,26)(27,28)(30,31)(32,33)
  (42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(59,61)(62,63)(65,67)(68,69)
  (71,73)(74,75),( 3,4)( 6,7)( 8,9)(10,11),
 ( 6,7)( 8,11)( 9,12)(10,13)(14,16)(15,17),
 ( 2,3)(10,11)(14,15)(19,20)(25,26)(32,33)(40,41),
 ( 7,27)( 10,28)( 22,29)( 25,30)( 31,50)( 32,52)( 33,55)( 34,56)
  ( 35,57)( 36,60)( 40,61)( 41,64)( 42,65)( 43,68)( 44,69)( 45,70)
  ( 46,73)( 48,74)( 53,83)( 54,84)( 62,85)( 63,86)( 71,87)( 72,88)
  ( 75,90)( 77,93)( 78,97)( 80,102)( 91,109)( 94,110)( 98,111)(100,112)
  (103,113)(114,118)(116,119),( 1,5)(10,12)(13,15),
 ( 3,4)( 7,8)(11,12)(21,22)(26,27)(29,30)(32,33)(35,36),
 ( 2,24)( 4,25)( 5,26)( 7,27)( 9,30)(10,31)(12,32)(14,33)(15,34)(17,37)
  (19,38)(21,39)(23,41)(28,42)(29,43)(35,45)(36,46)(40,48)(44,50)(47,51)
  (49,52),( 1,2)( 9,10)(14,15)(17,18),(1,2)(3,5)(6,8),
 ( 4,14)( 5,17)( 8,18)( 9,21)(10,22)(13,25),
 ( 2,9)( 3,10)( 5,12)(11,16)(13,17),( 1,3)( 2,6)( 5,10)( 7,11),
 ( 3,4)( 7,8)(11,12)(21,22)(26,27)(29,30)(34,35)(39,40)(42,43)(44,45)
  (47,48)(49,50),( 5,7)( 9,11)(13,14)(19,20)(23,25)(28,29)(35,36)(39,40)
  (43,44)(48,49)(53,55)(58,60)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 1,2)( 9,10)(14,15)(19,20)(24,25)(31,32)(39,40),
 ( 3,10)( 5,12)( 6,13)( 9,16)(11,17),( 2,24)( 5,27)( 6,28)(10,29)(13,30)
  (15,33)(18,34)(20,35)(23,36)(26,37)(32,38),
 ( 4,9)(10,14)(11,21)(19,30)(23,32)(25,35)(26,39)(27,44)(28,48)(36,53)
  (38,56)(41,59)(45,62)(47,65)(50,68)(52,70)(58,72)(64,74),
 ( 5,6)(10,11)(14,15)(20,21)(26,27)(29,30)(33,34)(52,53)(57,58)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78),( 1,14)( 3,20)( 5,22)( 8,23)(10,24)
  (15,25)(18,26),( 4,5)( 9,10)(12,13)(16,17)(20,21)(24,25)(29,30)(33,34),
 ( 5,7)(10,12)(16,17)(20,22)(26,27)(31,33)(36,37)(41,43)(46,48)(51,53),
 ( 1,9)( 2,13)( 3,19)( 4,21)( 7,24)(10,26)(14,29)(18,32)(23,34)(28,36)
  (31,38),( 1,11)( 3,12)( 6,15)( 8,17)(18,24)(19,30),
 ( 1,3)( 2,5)( 4,10)( 7,12),( 2,4)( 5,9)(10,13)(11,14)(12,15),
 ( 2,5)( 6,10)( 7,11),( 6,7)(10,12)(15,16)(19,21)(24,25)(28,30)(33,34)
  (37,39)(42,43)(46,48),( 2,7)( 4,8)(10,14)(15,17)(16,18),
 ( 6,7)( 8,9)(11,12)(14,15)(16,17),( 4,14)( 7,15)( 8,18)( 9,19)(12,22)
  (13,23),( 4,7)( 8,12)(14,18)(19,22)(24,27)(29,33)(35,38)(39,42)(44,48)
  (50,53),( 3,10)( 5,11)( 7,12)( 9,15)(13,18)(14,19),
 ( 3,7)( 6,8)( 9,14)(11,15),( 5,7)( 9,11)(14,15)(19,20)(23,24)(27,29)
  (42,44)(47,48)(51,53)(56,57)(58,60)(63,65)(68,70)(73,75)(78,80)(83,85),
 ( 1,3)( 5,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 1,7)( 3,12)( 5,14),( 3,5)(11,12)(15,16),
 ( 1,22)( 2,25)( 3,28)( 6,29)( 7,32)( 8,35)(10,36)(12,37)(13,38)(15,41)
  (17,44)(18,45)(20,46)(24,47)(26,48)(31,49)(33,50)(40,51)(42,52),
 (12,13)(15,16)(17,18)(20,21)(23,24)(25,26)(28,29)(31,32)(33,34)(36,37)
  (39,40)(41,42),( 7,8)(10,11)(14,15)(16,17)(21,22)(23,24)(27,28)(39,40)
  (48,49)(52,53)(55,56)(57,58)(60,61)(62,63)(67,68)(69,70)(72,73)(74,75)
  (77,78)(79,80)(84,85),( 4,5)( 9,10)(13,14)(16,17)(22,23)(28,29)(32,33)
  (53,54)(58,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 1,11)( 4,13)( 5,17)( 7,19)(10,22)(14,25),
 ( 3,10)( 6,12)( 7,14)( 8,15)( 9,16),( 4,6)( 9,10)(11,12),
 ( 1,8)( 2,17)( 3,21)( 7,23)( 9,26)(16,30)(27,33)(31,35),
 ( 4,5)( 7,9)(10,11)(12,14)(16,17),( 4,5)(12,13)(17,18)(24,25)(26,27)
  (28,29)(30,31),( 6,7)( 9,10)(12,13)(17,18)(22,23)(25,26),
 ( 7,35)(10,36)(13,37)(21,38)(29,39)(31,40)(34,41)(42,61)(43,62)(46,65)
  (47,66)(48,69)(50,70)(51,73)(52,74)(55,77)(56,78)(57,81)(59,82)(63,84)
  (64,85)(71,86)(72,87)(79,88)(80,89),( 1,6)( 2,10)( 5,12),
 ( 9,11)(13,14)(15,16)(18,20)(21,22),( 6,26)( 8,27)( 10,28)( 13,29)
  ( 16,30)( 21,31)( 23,32)( 35,59)( 39,60)( 41,61)( 44,64)( 49,66)
  ( 50,67)( 54,70)( 57,71)( 65,86)( 69,87)( 73,88)( 74,90)( 76,92)
  ( 78,93)( 80,95)( 81,97)( 82,99)( 84,100)( 89,105)( 91,107)( 94,109)
  ( 96,111)( 98,113)(101,115)(104,116)(108,117)(112,118),
 ( 2,6)( 5,8)(10,13)(11,14),( 1,2)( 3,4)( 5,6)( 7,8)(13,14)(16,17)
  (21,22),( 2,8)( 3,9)(10,13)(11,15),( 1,2)( 3,4)( 5,6)( 8,10)(11,13)
  (16,17)(19,21),( 2,6)( 5,7)( 8,13)( 9,16),
 ( 1,4)( 5,7)(10,12)(13,15)(18,20)(21,23)(26,29)(30,32)(35,38)(39,41)
  (45,46)(49,50)(53,54)(56,57)(59,60)(62,63)(66,67)(70,71)(73,74)(76,77),
 ( 2,9)( 4,11)( 6,15)( 7,17)(12,19)(14,21),
 ( 4,6)( 7,9)(10,12)(14,16)(19,21)(24,26)(29,31)(32,34),
 ( 3,4)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 7,19)(10,34)(12,35)(15,36)(18,37)(21,38)(25,39)(27,40)(30,49)(32,58)
  (41,59)(44,63)(47,65)(50,69)(53,71)(56,75)(60,77)(62,78)(66,79)(68,80)
  (72,81)(74,82),( 3,9)( 4,11)( 6,12)( 8,14),
 ( 1,9)( 2,12)( 4,15)( 7,18)(14,21)(19,23),
 ( 1,2)(10,11)(13,14)(16,17)(19,20)(23,24)(26,27)(28,29)(34,35)(37,38)
  (40,41)(43,44)(46,47)(49,50)(53,54)(57,58)(60,61)(64,65)(67,68)(71,72),
 ( 1,2)( 3,4)( 5,6)( 8,9)(10,11)(15,16)(18,19),
 ( 6,7)(11,13)(16,17)(21,23)(26,28)(31,33)(36,38)(41,43)(47,48)(51,53),
 ( 4,5)( 6,8)(10,12)(15,17)(18,20),( 1,2)( 3,4)( 5,6)( 8,9)(11,12)
  (14,15)(17,18)(20,21)(23,24)(26,27)(29,30)(32,33)(35,36)(37,38)(41,42)
  (46,47)(50,51)(55,56)(59,60),( 1,9)( 2,12)( 5,15)(11,18)(14,21),
 ( 7,8)(13,14)(17,18)(29,30)(34,35)(38,39)(43,44)(47,48)(49,50)(52,53)
  (55,56)(57,58)(60,61)(63,64)(66,67)(68,69)(71,72)(73,74)(75,76),
 ( 4,5)( 7,8)(11,12)(15,16)(20,21)(26,27)(30,31),
 ( 1,13)( 2,17)( 3,22)( 4,25)( 9,40)(10,41)(11,42)(12,43)(14,45)(16,47)
  (18,48)(21,50)(23,51)(26,53)(28,55)(29,56)(32,58)(33,59)(44,63)(46,64)
  (49,65)(52,66)(54,67)(57,68),( 1,2)( 3,4)( 5,6)( 8,9)(11,12)(16,17)
  (23,24)(26,27),( 4,5)( 8,9)(10,11)(22,23)(25,26)(28,29)(31,32),
 ( 2,3)(12,13)(16,17)(20,21)(24,25)(27,28)(31,32)(36,37)(39,40)(44,45)
  (47,48)(51,52),( 3,4)( 7,8)( 9,10)(11,12)(13,14)(15,16),
 ( 1,2)( 3,4)( 5,6)( 8,9)(13,14)(16,17)(21,22)(24,25),
 ( 2,6)( 7,10)( 8,12)( 9,13)(11,14),( 11,12)( 15,16)( 19,20)( 29,30)
  ( 33,34)( 44,45)( 46,47)( 48,49)( 51,52)( 54,55)( 56,57)( 58,59)
  ( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)( 70,71)( 75,76)( 82,83)
  ( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)
  (100,101)(102,103)(104,105),( 5,8)(10,13)(15,19)(20,23)(25,29)(30,34)
  (36,39)(40,44)(46,49)(51,54),( 5,8)(10,13)(15,18)(20,24)(25,28)(30,34)
  (35,39)(41,44)(45,49)(51,54),( 2,6)( 8,17)(11,26)(12,29)(15,38)(19,41)
  (20,42)(27,45)(28,46)(35,49)(36,50),( 4,8)(10,18)(11,24)(16,30)(20,32)
  (25,35)(26,39)(27,44)(28,48)(36,53)(38,56)(41,59)(45,62)(47,65)(50,68)
  (52,70)(58,72)(64,74),( 1,2)( 3,4)( 5,6)( 9,10)(12,13)(17,18)(23,24)
  (26,27),( 1,3)( 5,7)(12,13)(18,20)(23,24)(28,29)(33,34)(37,38)(40,41),
 ( 2,9)( 4,10)( 5,12)( 7,16)(13,20)(17,22),
 ( 1,6)( 2,13)( 3,20)( 7,24)( 9,26)(16,30)(18,32),
 ( 1,4)( 6,9)(11,14)(15,18)(20,23),( 9,10)(11,12)(13,14)(15,16)(17,18)
  (20,21)(22,23)(24,25)(27,29)(30,31)(32,34)(36,37)(38,39)(40,41)(43,44),
 ( 3,4)( 7,8)(10,11)(14,15)(17,18)(20,21)(23,24),
 ( 3,5)( 6,9)(12,14)(15,18)(21,23)(24,26)(29,31)(32,34)(37,39)(40,43)
  (44,45)(47,48)(50,51)(54,55)(58,59)(61,62)(64,65)(67,68)(71,72)(75,76),
 ( 4,6)(10,12)(14,15)(19,20)(24,25),( 7,13)( 8,17)( 9,20)(10,27)(11,31)
  (12,34)(19,41)(21,43)(28,45)(30,47)(38,49)(39,51),
 ( 1,2)( 3,4)( 5,6)(10,11)(15,16)(18,19)(21,22)(24,25),
 ( 3,5)( 6,8)( 9,11)(12,14),( 7,13)( 8,16)( 9,23)(10,26)(15,34)(28,36)
  (29,41)(30,44)(31,49)(32,52)(37,54)(39,57)(43,60)(45,63)(47,66)(51,69)
  (58,72)(64,74)(70,76),( 7, 8)( 15,16)( 19,20)( 22,23)( 27,28)
  ( 34,35)( 36,37)( 41,42)( 43,44)( 45,46)( 50,51)( 52,53)( 54,55)
  ( 59,60)( 62,63)( 64,65)( 66,67)( 72,73)( 81,82)( 83,84)( 85,86)
  ( 87,88)( 91,92)( 93,94)( 95,96)( 97,98)(103,104)(106,107)(109,110)
  (114,115)(117,118)(120,121),( 2,10)( 3,14)( 6,17)( 8,20)(13,22)(18,24),
 ( 2,3)( 7,8)(13,14)(19,20)(24,25),( 4,5)( 6,7)( 8,9)(11,12)(14,15)
  (16,17)(20,21)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33),
 ( 6,7)( 9,10)(14,15)(20,21)(23,24)(25,26)(28,29)(33,34)(44,45)(49,50)
  (51,52)(71,72)(76,77),( 1,13)( 2,14)( 4,16)( 5,19)( 7,20)( 8,22)(10,25)
  (11,26)(15,27)(17,28)(21,29)(23,30),( 1,2)( 3,4)( 6,7)( 8,9)(10,11)
  (12,13)(15,16)(17,18),( 5,32)( 9,35)( 12,39)( 14,42)( 18,45)
  ( 23,49)( 24,55)( 25,60)( 26,61)( 27,69)( 28,79)( 30,85)( 33,86)
  ( 36,87)( 41,89)( 46,90)( 50,99)( 53,100)( 56,101)( 59,102)( 62,103)
  ( 63,104)( 66,105)( 67,106)( 70,108)( 73,109)( 74,110)( 77,111)( 80,112)
  ( 83,113)( 84,114)( 88,116)( 91,117)( 92,118)( 93,119)( 94,121)( 95,123)
  ( 96,124)( 97,126)( 98,127)(107,130)(115,131)(120,135)(122,136)(125,137)
  (128,138)(129,139)(132,140)(133,141)(134,142),
 ( 6,7)( 9,10)(11,12)(15,16)(19,20),( 1,6)(10,12)(11,18)(16,29)(20,31)
  (25,35)(26,39)(27,44)(28,48)(33,51)(36,54)(38,57)(42,60)(45,63)(47,66)
  (55,69)(61,71)(67,73),( 7,8)(10,11)(12,14)(16,17)(19,20)(22,23)(25,27)
  (28,29)(31,32)(34,35)(36,38)(39,41)(44,45)(46,48)(49,51)(56,57)(59,61)
  (65,67)(68,70),( 2,10)( 3,11)( 4,14)( 5,15)( 8,18)( 9,20)(12,22)(17,23)
  (19,24)(21,25),( 1,2)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(27,28),
 ( 4,6)(10,11)(14,16)(19,21)(25,27)(30,31)(34,36)(40,42)(45,47)(50,51),
 ( 1,5)( 9,12)(13,16),( 2,5)( 3,9)( 6,10),
 ( 7, 8)( 16,17)( 20,21)( 24,25)( 26,27)( 30,31)( 33,34)( 37,38)
  ( 39,40)( 42,43)( 47,48)( 53,54)( 57,58)( 61,62)( 63,64)( 77,78)
  ( 81,82)( 85,86)( 89,90)( 92,93)( 96,97)(100,101)(104,105)(108,109)
  (111,112)(115,116)(119,120)(123,124)(126,127)(130,131)(138,139)(142,143)
  (150,151)(153,154)(157,158)(160,161)(164,165)(167,168)(171,172)(174,175)
  (177,178)(181,182)(184,185)(188,189)(191,192)(195,196)(198,199)(202,203)
  (205,206)(209,210)(212,213)(216,217)(219,220)(223,224)(226,227)(230,231)
  (233,234)(237,238)(240,241)(264,265)(268,269)(272,273)(276,277)(280,281)
  (284,285)(288,289)(292,293)(296,297)(300,301)(304,305)(308,309)(311,312)
  (314,315)(317,318)(320,321)(323,324)(326,327)(329,330)(332,333)(335,336)
  (338,339)(341,342)(344,345),( 1,13)( 3,15)( 5,17)( 6,19)( 8,20)(11,21)
  (14,22)(16,23)(18,24),( 4,7)( 5,8)( 9,12)(10,14),
 ( 5,6)(11,12)(16,17)(22,23)(27,28),( 4,7)( 5,8)( 9,11)(10,13),
 ( 2,4)(10,12)(13,15)(18,20)(21,23),( 7,8)(17,18)(22,24)(29,30)(31,32)
  (34,35)(37,39)(43,44)(46,48)(51,53)(54,56)(57,59)(60,62)(63,65)(66,68)
  (69,70)(71,72)(73,74),( 4,5)( 7,8)(14,15)(17,18)(21,22)(24,25)(27,28)
  (30,31),( 4,20)( 6,21)( 8,24)( 9,26)(13,27)(14,30)(17,32)(18,33)(23,34)
  (25,35)(29,36)(31,37),( 5,7)( 6,8)( 9,13)(11,15),
 ( 5,7)( 6,8)( 9,14)(12,15),( 1,7)( 2,12)( 3,21)( 9,25)(16,29)(18,31)
  (22,33)(26,35),( 1,6)( 2,11)( 3,17)(10,25)(19,28)(22,30)(24,32)(27,34),
 ( 8,37)(10,38)(12,41)(14,44)(16,45)(18,46)(20,47)(22,50)(24,53)(26,54)
  (28,55)(30,56)(32,59)(34,62)(36,63),( 5,6)( 7,9)(12,13)(14,16),
 ( 4,6)( 7,8)(11,12)(13,15)(16,18)(19,20)(21,22)(23,24),
 (13,14)(16,17)(18,19)(21,22)(24,25)(26,27)(29,30)(32,33)(34,35)(37,38)
  (40,41)(42,43),( 2,22)( 3,23)( 5,25)( 7,26)( 8,29)( 9,31)(11,32)(12,34)
  (14,35)(16,38)(17,40)(19,41)(20,42)(28,47)(30,48)(37,50)(39,51)(44,53)
  (45,54),( 4,37)( 7,39)( 9,40)(12,41)(15,42)(18,44)(21,45)(26,46)(28,48)
  (32,49)(35,50)(52,61)(54,64)(55,67)(57,70)(59,73)(60,76)(63,79)(69,80)
  (75,81),( 4,6)( 9,11)(14,16)(19,21)(25,26)(29,31)(35,36)(40,42)(45,46)
  (50,52),( 2,3)( 6,8)(11,13)(16,17)(20,22)(25,27),
 ( 5,7)( 8,11)( 9,12)(10,13)(14,16)(15,17),( 3,7)( 5,8)( 9,13)(11,15),
 ( 1,3)( 2,6)( 5,9)( 7,10),( 4,20)( 7,21)( 8,24)( 9,25)(11,26)(13,27)
  (15,31)(16,32)(19,33)(22,35)(28,37),( 5,7)( 8,11)(16,18)(20,22)(27,30)
  (31,33)(38,40)(41,43)(44,45)(48,49)(52,53)(56,57)(61,62)(65,66)(69,70)
  (73,74),( 7,10)(11,14)(16,19)(20,23)(25,28)(29,32)(34,37)(38,41)(43,46)
  (47,50),( 2,22)( 4,23)( 5,24)( 7,27)( 9,30)(10,31)(12,32)(14,33)(15,36)
  (16,39)(19,40)(20,43)(21,46)(26,47)(28,48)(35,49)(37,50)(42,51)(44,52),
 ( 4,7)( 8,12)(13,16)(17,21)(22,25),( 8,33)( 11,34)( 13,35)( 15,36)
  ( 29,37)( 32,38)( 39,46)( 40,49)( 41,51)( 42,54)( 43,56)( 44,59)
  ( 45,61)( 52,72)( 62,74)( 63,76)( 64,77)( 65,80)( 66,83)( 67,86)
  ( 68,88)( 69,89)( 70,92)( 71,95)( 73,97)( 75,98)( 78,100)( 79,101)
  ( 81,102)( 82,104)( 84,105)( 85,107)( 87,108)( 90,110)( 91,111)( 93,112)
  ( 94,114)( 96,115)(103,117)(109,118)(116,119),
 ( 5,6)(12,13)(14,16)(18,20)(23,24)(28,29)(31,33)(35,37)(38,39)(43,44)
  (48,49)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76),
 ( 4,5)( 8,10)(11,13)(16,18)(20,22),( 6,14)( 7,15)( 8,17)(10,18)(11,20)
  (12,21),( 6,37)( 9,38)(12,39)(15,41)(19,42)(22,43)(25,45)(28,46)(31,47)
  (34,48)(36,50)(51,63)(54,66)(55,69)(56,72)(59,75)(60,78)(62,79)(68,80)
  (74,81),( 2,4)( 7,9)(11,13)(16,18)(21,23)(25,27),
 ( 4,5)( 9,10)(16,17)(21,22)(26,27),( 1,7)( 4,9)( 5,10)( 6,12),
 ( 6,7)( 9,10)(12,13)(15,16)(23,24)(27,28)(31,32)(47,48)(56,57)(60,61)
  (62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)
  (82,83),( 1,8)( 2,10)( 3,11)( 5,13)( 6,14),( 2,5)( 6,10),
 ( 1,2)( 4,11)( 7,13),( 1,8)( 2,10)( 4,12)( 6,14),
 ( 2,4)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 4,5)( 8,10)(12,14)(17,18)(21,22)(25,26)(29,31)(33,35)(38,39)(42,43),
 ( 1,8)( 4,12)( 7,13),( 8,29)( 11,30)( 14,31)( 16,32)( 21,33)
  ( 25,34)( 28,35)( 36,50)( 39,54)( 40,56)( 43,57)( 44,61)( 46,62)
  ( 47,66)( 51,79)( 53,80)( 58,81)( 63,82)( 65,83)( 67,84)( 69,87)
  ( 70,90)( 73,93)( 75,96)( 76,99)( 86,103)( 89,105)( 92,107)( 95,109)
  ( 98,111)(101,113)(104,114)(108,115)(112,116),
 ( 5,6)(12,13)(16,18)(21,22)(27,28)(30,32)(34,36)(38,39)(43,44)(47,48)
  (52,54)(57,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 1,11)( 4,14)( 6,17)( 7,20)(10,22)(15,24),
 ( 4,5)( 8,10)(13,15)(18,19)(22,24)(27,29),
 ( 7,8)(10,11)(14,15)(17,18)(19,20),( 1,7)( 6,8)(10,15)(12,18),
 ( 5,7)( 8,10)(12,14)(15,17)(20,22)(24,26),
 ( 1,9)( 3,12)( 6,16)( 8,19)(13,21)(18,23),
 ( 5,6)( 9,10)(12,13)(17,18)(20,21)(23,24)(27,28)(32,33),
 ( 6,7)(11,12)(19,20)(24,25)(26,27)(28,29)(30,31),
 ( 1,2)( 4,9)( 5,10)( 7,12)( 8,13),( 5,6)( 8,9)(13,14)(18,19)(23,24)
  (30,31)(42,43)(47,48)(51,52)(56,57)(59,60)(64,65)(69,70)(74,75)(79,80)
  (84,85),( 1,2)( 3,4)( 5,6)( 7,8)(12,13)(18,19),
 ( 1,4)( 2,12)( 3,16)( 6,21)( 9,24)(10,26)(15,29)(17,31)(20,33)(23,35)
  (28,37),( 2,3)( 4,7)( 9,12)(16,19)(20,23),
 ( 1,2)( 4,9)( 6,11)( 8,13)(10,14)(12,15),( 6,9)( 8,10)(11,13)(12,14),
 ( 1,4)( 2,11)( 3,16)( 6,24)(10,27)(15,28)(21,31),
 ( 4,5)( 8,9)(10,12)(13,14)(15,17)(18,20)(21,22)(23,24),
 ( 2,3)( 4,7)(11,14),( 4,19)( 7,20)( 9,23)(11,26)(13,27)(15,30)(16,33)
  (18,34)(21,35)(22,36)(28,37)(29,38),( 6,7)( 8,9)(14,16)(18,19)(21,23)
  (28,30)(32,33)(35,37),( 1,4)( 9,15)(10,16)(11,17)(13,19)(18,21)(20,22),
 ( 4,6)( 8,10)(11,12)(17,18)(23,24)(26,27)(30,31)(32,33),
 ( 4,5)( 8,9)(10,11)(14,16)(18,19),( 6,7)(12,13)(15,17)(18,20)(22,23)
  (28,29)(31,33)(34,36)(38,39),( 5,6)( 9,10)(13,14)(15,16)(22,23)(24,25)
  (27,28)(30,31)(57,58)(59,60)(62,63)(64,65)(67,68)(69,70)(72,73)(74,75)
  (77,78)(79,80)(82,83)(84,85),( 1,4)( 2,11)( 6,13),
 ( 3,4)( 8,9)(12,14)(15,17)(18,20)(21,23)(24,26)(27,29),
 ( 2,10)( 5,13)( 7,15)( 9,17)(18,21)(19,27),
 (11,12)(15,16)(18,19)(20,21)(23,24)(26,27)(28,29)(35,36)(37,38)(41,42)
  (43,44)(45,46)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62),
 ( 1,9)( 3,11)( 6,14)( 8,17)(12,20)(16,23),
 ( 4,7)( 8,11)(12,14)(16,19)(20,22),(10,11)(15,16)(19,20)(24,25)(29,30)
  (34,35)(39,40)(43,44)(48,49)(53,54),( 4,34)( 6,37)( 8,39)(10,41)(12,44)
  (14,46)(16,49)(18,51)(20,53)(22,56)(24,58)(26,61)(28,63)(30,65)(32,68),
 ( 3,5)( 8,11)(15,18)(19,21)(24,26)(28,29)(31,33)(36,38)(40,41)(43,45)
  (48,50)(52,53),( 2,7)( 3,9)(10,14)(11,17),
 ( 4,11)( 5,13)( 6,14)( 7,16)( 8,17)(10,19),
 (10,11)(16,18)(21,22)(23,24)(25,27)(28,30)(31,32)(33,34),
 ( 3,4)( 8,9)(12,13)(17,18)(21,22)(25,26),
 ( 1,9)( 3,10)( 4,12)( 6,13)( 8,15)(11,16)(14,17),( 1,4)( 2,10)( 6,12),
 ( 2,6)( 7,10),( 2,3)( 4,5)( 6,7)( 8,9)(11,12),
 ( 6,8)( 7,9)(10,12)(11,14),( 1,6)( 2,14)( 3,19)( 7,25)(12,27)(17,29)
  (22,31),( 7,9)(10,12)(13,14)(16,17)(19,20)(21,23)(25,26)(28,29)(31,32)
  (34,36)(37,38)(40,41)(44,46)(48,49)(54,56)(57,59)(60,61)(64,66)(67,69),
 ( 3,5)( 8,10)(12,14)(17,18)(21,23),( 2,4)( 6,8)(10,12)(17,18)(24,25)
  (29,30)(32,33)(36,37),( 1,8)( 3,12)( 5,13)( 7,17)( 9,21)(11,22)(14,23)
  (16,24)(18,25)(20,26),( 3,9)( 5,11)( 6,13)( 7,16)(15,19)(17,21),
 ( 2,3)( 4,5)( 6,7)(10,11)(13,14),( 5,6)( 9,10)(13,14)(17,18)(23,24)
  (29,30)(34,35)(53,54)(57,58)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76),
 ( 4,5)(10,11)(15,16)(21,22)(27,28),( 1,7)( 2,14)( 3,19)( 5,23)( 9,25)
  (13,28)(18,30),( 7,8)(11,14)(15,16)(17,20)(23,24),
 ( 7,9)(10,12)(14,15)(17,18)(20,21),( 4,5)( 6,7)( 8,10)(11,13)(14,15)
  (16,17)(19,21)(22,23)(24,25)(26,27)(28,29)(30,31),
 ( 5,7)( 9,11)(12,15)(17,20)(22,25),( 2,7)( 4,14)( 6,20)(10,23)(13,24)
  (17,25)(21,26),( 1,10)( 3,13)( 6,16)( 7,20)(12,21)(17,23),
 ( 9,10)(13,14)(17,18)(21,22)(23,24)(26,27)(29,30)(32,33)(37,38)(40,41),
 ( 2,9)( 3,13)( 6,16)( 8,19)(12,22)(17,24),
 ( 1,2)( 9,10)(12,14)(15,17)(19,20)(23,24)(25,27)(29,30)(31,33)(34,36)
  (39,40)(41,43)(44,45)(51,52)(55,57)(58,59)(63,65)(66,67)(77,78)(85,86)
  (91,92),( 5,6)( 8,9)(11,12)(15,16)(20,21)(25,26)(30,31)(34,35),
 ( 2,5)( 8,10)(11,13)(14,17)(19,21),( 5,6)(15,16)(22,24)(29,30)(31,32)
  (35,37)(39,40)(44,46)(48,49)(51,53)(54,56)(57,59)(60,62)(63,65)(66,68)
  (69,70)(71,72)(73,74),( 6,7)(13,14)(18,19)(20,21)(24,25)(32,33)(48,49)
  (54,55)(56,57)(62,63)(64,65)(67,68)(70,71)(73,74)(76,77)(79,80),
 ( 1,3)( 8,10)(13,15)(18,20)(25,26)(30,31)(38,39),
 ( 5,6)( 9,10)(13,14)(20,21)(23,24)(27,28)(40,41)(45,46)(50,51)(55,56)
  (58,59)(61,62)(63,64)(66,67)(68,69)(72,73)(74,75)(77,78)(79,80)(82,83)
  (84,85)(88,89),( 5,20)( 6,23)( 7,26)( 9,29)(10,32)(12,35)(13,38)(14,41)
  (16,44)(17,47),( 3,5)( 8,10)(13,14)(17,19)(22,24)(27,28),
 ( 5,6)( 9,10)(13,14),( 1,4)( 2,8)( 3,17)( 9,23)(16,27)(18,30)(22,32)
  (26,34),( 2,9)( 3,11)( 4,13)( 5,15)( 6,17)( 7,19),
 ( 3,5)( 8,10)(14,16)(19,21)(24,26),( 3,7)( 4,8)( 9,13)(11,16),
 ( 4,6)( 8,10)(13,15)(16,18)(21,23),( 4,6)( 8,10)(13,15)(16,19)(22,24)
  (29,31),( 1,2)( 7,8)(12,13),( 6,8)( 9,10)(12,13),
 ( 3,7)( 4,8)(13,14)(15,17)(16,18),( 5,6)( 9,10)(14,15)(17,18)(20,21)
  (23,24)(26,27)(31,32)(34,35),( 2,7)( 4,9)( 5,12),
 ( 1,3)( 2,7)( 4,9)(10,12)(11,13),( 1,3)( 8,9)(14,16)(18,20)(22,23)
  (27,28)(32,33)(37,38)(40,41),( 4,7)( 8,10)(15,17)(18,20)(25,27)(28,31)
  (36,38)(40,42)(44,45)(48,49)(53,54)(57,58)(61,62)(65,66)(70,71)(74,75),
 ( 4,25)( 6,28)( 23,29)( 27,38)( 31,50)( 33,52)( 35,54)( 36,55)
  ( 39,58)( 41,60)( 42,61)( 45,64)( 47,66)( 48,69)( 53,81)( 59,82)
  ( 67,85)( 70,88)( 71,89)( 74,92)( 75,93)( 77,95)( 80,98)( 83,101)
  ( 84,107)( 86,112)( 87,113)( 90,116)( 91,117)( 94,120)( 96,122)( 97,123)
  (100,126)(102,128)(104,130)(106,132)(108,134)(110,136)(111,137)(121,138)
  (125,139)(127,141)(129,143)(131,145)(133,147)(135,149)(140,152)(142,154)
  (144,156)(146,158)(148,160)(150,162)(151,163)(155,164)(159,165),
 ( 6,7)(10,11)(15,16)(18,19)(21,22)(24,25)(27,28)(32,33)(35,36),
 ( 6,8)(10,12)(13,15)(17,19)(21,23)(24,26),
 ( 4,5)( 8,9)(12,13)(16,17)(21,22)(25,26),
 ( 1,3)( 2,6)( 4,8)(10,12)(11,14),( 4,6)( 8,10)(13,14)(17,18)(23,24)
  (30,31),( 3,17)( 6,18)( 9,20)(10,21)(13,23)(16,24),
 ( 1,4)( 2,8)( 5,9)(10,12)(11,13),( 9,10)(12,13)(14,15)(16,17)(19,21)
  (22,23)(24,26)(28,29)(30,31)(32,33)(35,36)(37,38)(39,40)(41,42)(43,44),
 ( 1,5)( 2,8)( 4,9)(10,12)(11,13),( 5,6)( 9,10)(14,15)(18,19),
 ( 1,2)( 9,10)(14,15)(19,20)(24,25)(29,30)(34,35)(38,39)(43,44)(47,48)
  (52,53)(56,57)(61,62),( 3,6)( 7,9)(12,14)(15,17)(20,22)(23,25)(28,31)
  (32,34)(37,40)(41,43)(44,45)(47,48)(51,52)(55,56)(58,59)(61,62)(64,65)
  (68,69)(72,73)(75,76),( 5,6)( 8,10)(13,14)(15,16)(19,20),
 (11,12)(13,14)(16,17)(18,19)(20,22)(23,25)(27,28)(29,30)(31,32)(34,36)
  (42,43)(44,46)(51,53)(57,58)(60,61),( 9,10)(14,15)(18,19)(22,23)(26,27)
  (31,32)(36,37)(40,41)(44,45)(48,49),( 2,3)( 8,9)(13,14),
 ( 1,2)( 8,10)(12,14)(15,16)(20,21)(23,25)(26,28)(30,31)(35,36)(37,39)
  (41,43)(44,46)(49,51),( 1,24)( 4,25)( 6,26)( 9,27)(11,30)(14,31)(18,32)
  (19,33)(22,36)(28,37)(34,38),( 3,4)(11,13)(23,24)(25,26)(27,28)(29,30)
  (31,32)(33,34),( 6,7)(10,12)(14,15)(19,20)(22,24),
 ( 5,6)( 9,10)(14,15)(19,20)(25,26)(30,31)(42,43)(48,49)(51,52)(56,57)
  (63,64)(68,69)(73,74)(77,78)(83,84)(86,87)(89,90)(92,93)(95,96)(98,99),
 ( 1,2)( 6,7)(11,12)(19,20)(26,27)(34,35)(40,41),
 ( 4,5)( 9,10)(16,17)(21,22)(26,27)(32,33),
 ( 1,2)( 4,5)( 9,10)(11,12)(13,14),( 9,10)(14,15)(19,20)(23,24)(29,30)
  (33,34)(38,39)(43,44)(47,48)(53,54),( 9,10)(14,15)(19,20)(23,24)(28,29)
  (33,34)(38,39)(43,44)(47,48)(52,53),( 1,2)( 6,7)(12,13)(16,17)(20,21)
  (24,25),( 4,5)( 7,8)(10,11)(14,15)(19,20)(24,25)(29,30)(32,33),
 ( 2,7)( 5,10)( 6,14)( 8,17)(11,20),( 5,6)( 7,8)( 9,10)(16,17),
 ( 1,7)( 2,12)( 5,14),( 6,36)( 8,37)(11,38)(21,39)(28,40)(31,41)(35,42)
  (43,59)(44,62)(46,63)(47,66)(48,67)(50,70)(51,71)(52,74)(54,75)(55,78)
  (56,79)(58,82)(60,83)(61,84)(68,85)(69,86)(76,87)(77,88),
 ( 4,7)( 9,12)(14,18)(19,22)(24,28)(29,33)(35,38)(39,43)(45,48)(50,53),
 ( 1,11)( 2,17)( 3,22)( 5,24)( 9,27)(13,29)(18,32),
 ( 4,13)( 5,14)( 8,16)( 9,17)(10,19)(11,20),
 ( 1,5)( 2,12)( 3,17)( 7,23)(11,27)(16,29)(20,33),
 ( 1,3)( 9,10)(12,14)(17,18)(20,22),( 4,5)( 8,9)(13,14)(17,18),
 ( 8,10)(13,15)(20,21)(22,23)(26,27)(28,29)(32,33),
 ( 4,6)( 8,9)(11,13)(15,17)(19,20)(22,24)(26,28)(30,31)(33,35)(36,38)
  (40,42)(44,46)(47,49)(51,53)(55,57),( 1,7)( 2,11)( 3,17)( 4,23)(13,26)
  (16,28)(22,31),( 4,7)( 9,12)(14,16)(18,20)(22,25)(27,30)(31,34)(36,39)
  (41,43)(45,47)(49,52)(54,57),( 4,7)( 9,12)(15,19)(23,25)(26,27)(28,30)
  (31,32),( 1,4)( 2,7)( 8,11)( 9,12)(10,13),
 ( 2,8)(10,14)(11,18)(24,30)(25,35)(26,39)(27,44)(28,48)(31,50)(33,53)
  (36,56)(37,58)(40,61)(42,64)(45,67)(46,69)(51,72)(59,74)(65,76),
 ( 1,3)( 6,8)(11,12)(15,17)(20,21),( 3,4)( 5,7)( 8,10)(11,13)(14,15)
  (17,18)(20,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34),
 ( 2,3)( 5,6)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)(28,29),
 ( 2,7)( 5,8)( 9,13)(10,14),( 3,4)( 5,7)( 8,10)(13,15)(16,18),
 ( 1,6)( 2,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 1,2)( 8,9)(13,14)(16,17)(19,20)(22,23),
 ( 4,6)( 8,9)(11,12)(15,16)(18,20),( 5,14)( 7,17)( 8,18)(10,21)(12,22)
  (13,25),( 2,5)( 7,11)(12,14)(16,18)(20,22),
 ( 1,3)(10,12)(14,16)(17,19)(20,22)(24,26),
 ( 7,8)(11,12)(15,16)(19,20)(23,24)(28,29)(31,32)(36,37)(39,40)(44,45)
  (46,47)(49,50),( 3,4)( 9,10)(14,15)(17,18)(22,23),
 ( 1,3)( 4,10)( 5,11),( 4,5)(14,16)(20,21)(24,25)(26,27)(28,29)(30,31),
 ( 6,7)(10,11)(13,14)(18,19)(21,22),( 1,11)( 2,15)( 3,20)( 4,24)( 5,29)
  ( 6,33)( 7,38)( 8,42)( 9,47)(10,51),( 4,7)( 9,11)(13,16)(17,20)(21,24)
  (25,28)(30,32)(34,37)(38,41)(42,45),( 1,2)( 3,4)( 5,6)( 8,10)(14,16)
  (19,20)(22,23)(25,26),( 4,6)( 8,9)(13,14)(16,18)(21,22)(24,25),
 ( 1,4)( 2,5)( 7,11)( 8,14)(12,15)(13,16),
 ( 6,34)( 9,35)( 12,36)( 14,37)( 17,38)( 23,39)( 26,40)( 33,41)
  ( 43,54)( 45,57)( 46,59)( 48,61)( 50,64)( 52,67)( 62,78)( 68,80)
  ( 70,83)( 71,85)( 72,87)( 73,89)( 75,92)( 76,94)( 77,96)( 81,97)
  ( 82,99)( 84,102)( 86,105)( 90,107)( 91,109)( 93,112)( 95,115)(103,117)
  (110,118)(116,119),( 1,7)( 2,10)( 3,15)(17,35)(20,36)(23,37)(27,38)
  (32,39)(41,48)(44,49)(46,50),( 5,7)( 9,10)(12,13)(16,18)(20,21)(23,24),
 ( 4,6)( 8,9)(13,14)(17,18)(23,25)(29,31),
 ( 8,9)(11,12)(19,20)(22,23)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)
  (61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)(79,80)
  (81,82)(83,84)(85,86)(87,88)(89,90)(91,92)(93,94)(95,96),
 ( 4,21)( 7,22)( 8,23)(11,26)(13,27)(14,28)(16,29)(18,32)(20,33)(24,34)
  (30,35),( 1,4)( 3,12)( 6,13),( 1,2)( 5,9)( 7,12),
 ( 7, 9)( 13,14)( 15,17)( 20,22)( 36,38)( 39,41)( 42,43)( 44,45)
  ( 46,48)( 50,51)( 52,53)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)
  ( 66,67)( 68,69)( 73,75)( 79,81)( 84,85)( 86,87)( 88,89)( 90,91)
  ( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107),
 ( 8,9)(10,12)(13,15)(17,18)(20,21),( 1,3)(11,12)(14,15),
 ( 1,4)( 3,10)( 6,13),( 2,7)( 8,12)(13,18)(19,23)(24,29),
 ( 6,7)(10,11)(14,16)(18,20)(23,24)(27,28)(31,32)(35,37)(39,41)(44,45),
 ( 7,14)( 8,18)( 9,25)(10,28)(11,34)(24,36)(29,39)(30,41)(31,47)(32,49)
  (38,55)(42,58)(44,61)(46,64)(50,67)(52,70)(53,72)(59,74)(65,76),
 ( 2,4)( 8,10)(13,15)(19,20)(24,26),(11,12)(15,16)(20,21)(25,26)(29,30)
  (33,34)(37,38)(42,43)(47,48)(51,52),( 3,4)(10,12)(13,15),
 ( 1,5)( 8,15)(10,16)(12,17)(14,18),( 1,2)(10,11)(15,16)(18,19)(21,22)
  (24,25),( 1,2)( 5,7)(10,12)(15,16)(19,21),
 ( 5,6)( 8,9)(11,12)(14,15)(24,25)(26,27)(31,32)(33,34),
 ( 6,34)( 16,35)( 20,36)( 24,37)( 28,38)( 30,39)( 33,40)( 42,58)
  ( 43,59)( 45,61)( 46,63)( 48,64)( 50,66)( 52,68)( 53,70)( 55,71)
  ( 60,81)( 65,82)( 73,84)( 75,86)( 76,88)( 77,90)( 79,92)( 80,94)
  ( 83,95)( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 98,107)(102,108)
  (106,109),( 2,7)(10,13)(11,17)(24,29)(25,34)(26,38)(27,43)(28,47)(31,49)
  (33,52)(36,55)(37,57)(40,60)(42,63)(45,66)(46,68)(51,71)(59,73)(65,75),
 ( 4,5)( 7,8)( 9,10)(11,12),( 1,9)( 2,16)( 3,21)( 5,24)(10,26)(14,28)
  (19,30),( 1,11)( 2,13)( 4,16)( 7,20)(14,22)(19,24),
 ( 6,8)(12,13)(16,18)(21,23)(27,29)(32,33)(36,38)(42,44)(47,49)(52,53),
 ( 5,6)( 8,9)(11,12)(15,16)(18,19),( 1,8)( 2,12)( 3,18)( 4,24)(13,27)
  (16,29)(22,32),(13,14)(15,16)(17,18)(20,21)(22,23)(25,26)(27,28)(29,30)
  (31,32)(33,34)(44,45)(46,47)(49,50)(52,53)(54,55)(57,58),
 ( 2,9)( 3,12)( 4,15)( 6,18),( 4,5)( 7,8)( 9,10)(12,13)(15,16)(17,18)
  (19,20)(22,23)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36)(37,38),
 ( 3,11)( 5,13)( 7,14)( 8,15)( 9,16),( 4,6)( 9,11)(13,15)(16,18)(19,21)
  (22,24)(25,27)(30,32),( 4,5)( 9,11)(14,16)(19,21)(24,26)(29,31)(34,36)
  (37,39)(40,42)(46,48)(49,51)(55,57)(58,60),( 3,11)( 5,12)( 8,13)(10,14),
 ( 1,7)( 2,9)( 3,10)( 5,11)( 6,12),( 5,7)(10,12)(13,15)(16,18)(19,21)
  (22,24)(26,28),( 3,4)( 6,8)(10,11)(14,15),
 ( 2,3)(10,11)(13,14)(16,17)(22,23)(24,25)(27,28)(29,30)(32,33)(34,35),
 ( 4,5)( 9,11)(15,16)(19,20)(23,24)(27,28)(31,32)(35,36)(39,40)(43,44)
  (47,48)(51,52),( 5,6)( 8,9)(11,12)(18,19)(22,23)(25,26)(31,32)(34,35)
  (36,37),( 2,4)( 6,8)(13,14)(19,21)(24,25)(29,30)(34,35)(37,38)(40,41),
 ( 4,6)( 9,11)(13,15),( 2,3)(10,11)(14,15)(17,18)(20,21)(24,25),
 ( 5,7)(10,12)(14,16)(18,20)(22,24),( 8, 9)( 10,11)( 18,19)( 21,22)
  ( 30,31)( 35,36)( 45,46)( 50,51)( 54,55)( 56,57)( 58,59)( 60,61)
  ( 63,64)( 65,66)( 67,68)( 69,70)( 72,73)( 75,76)( 77,78)( 79,80)
  ( 83,84)( 86,87)( 94,95)( 96,97)( 99,100)(103,104)(106,107)(109,110)
  (113,114)(121,122)(126,127)(131,132)(135,136)(137,138),
 ( 6,32)( 9,33)(12,34)(19,35)(27,36)(30,37)(38,59)(39,61)(42,64)(43,66)
  (44,69)(46,71)(47,72)(48,75)(49,77)(52,80)(53,82)(54,85)(56,87)(57,88)
  (62,90)(63,91)(73,92)(74,93)(83,94)(84,95),
 ( 1,9)( 2,14)( 3,22)( 5,25)(10,27)(15,29)(20,31),
 ( 4,6)( 9,11)(13,14)(16,17)(19,21)(23,24)(27,28)(32,33),
 ( 5,7)(10,12)(14,15)(16,17)(19,20)(21,22)(24,25)(26,27),
 ( 7, 8)( 12,13)( 14,15)( 20,21)( 33,34)( 39,40)( 41,42)( 44,45)
  ( 46,47)( 48,49)( 51,52)( 54,55)( 56,57)( 59,60)( 61,62)( 63,64)
  ( 65,66)( 68,69)( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 99,100)
  (101,102)(103,104)(105,106)(107,108)(109,110)(111,112)(114,115)(116,117)
  (118,119)(120,121)(122,123)(126,127)(131,132)(136,137)(161,162)(163,164)
  (165,166)(167,168),( 12,14)( 17,19)( 20,21)( 25,27)( 38,39)( 40,41)
  ( 43,45)( 46,47)( 48,49)( 50,52)( 53,55)( 56,57)( 58,59)( 60,61)
  ( 62,63)( 64,65)( 66,67)( 68,69)( 70,72)( 76,78)( 84,85)( 86,87)
  ( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107),( 2,10)( 4,18)( 6,20)( 9,21)(12,22)(17,25)(24,28)
  (27,29),( 3,9)( 6,10)( 7,11),( 7,11)(12,15)(16,20)(21,25)(26,30)(31,35)
  (36,39)(40,44)(45,49)(50,54),( 2,4)(10,12)(14,15)(19,20)(22,23)(25,26),
 ( 1,11)( 3,13)( 5,17)( 8,20)(14,22)(19,24),
 ( 4,5)( 9,10)(12,13)(14,15)(17,18)(23,24)(28,29)(31,32)(46,47)(48,49)
  (53,54)(72,73)(77,78),( 1,11)( 3,13)( 5,15)( 7,16)(18,25)(19,31),
 ( 4,6)( 9,11)(14,16)(18,19)(22,23)(25,27)(28,30)(32,33)(36,37),
 ( 1,2)( 4,5)( 7,8)(11,12)(14,15),( 8,9)(11,13)(15,16)(17,18)(20,22)
  (24,25)(28,30)(37,39)(40,41)(45,47)(48,49),( 4,9)( 7,10)( 8,11),
 ( 2,3)( 4,5)(19,20)(21,22)(23,24),( 1,4)( 2,8)( 7,11)( 9,12)(10,13),
 ( 1,4)( 5,9)( 8,10),( 2,3)( 6,8)(11,12)(15,17)(20,22),
 ( 1,7)( 2,8)( 5,10)( 6,12),( 2,4)( 6,7)( 9,11)(13,14)(16,18)(19,20)
  (21,22)(24,25)(26,27)(29,30)(31,32)(33,34)(36,37)(38,39)(41,42)(43,44)
  (45,46)(48,49)(50,51)(53,54),( 5,10)( 6,12)( 7,13)( 8,15)( 9,17)(28,31)
  (29,34)(30,35)(32,36)(33,37),( 5,7)(10,12)(16,18)(22,24)(26,28)(30,32)
  (34,36)(51,52)(55,56)(59,61)(62,64)(65,67)(68,70)(71,73)(74,76),
 ( 5,6)( 9,10)(11,12)(16,17)(22,23)(26,27)(31,33)(39,40)(46,47),
 ( 9,11)(12,13)(15,17)(18,19)(21,22)(24,25),
 ( 1,9)( 2,13)( 3,20)( 4,22)( 7,24)(10,25)(14,27)(19,29)(23,30)(26,31)
  (28,32),( 1,3)( 2,6)( 8,11)( 9,12)(10,13),
 ( 2,9)( 4,15)( 6,22)(10,23)(13,24)(18,25)(21,26),
 ( 2,8)( 3,10)( 4,12)( 5,14)( 6,16)( 7,18),
 ( 2,8)( 3,10)( 4,12)( 5,14)( 6,16),( 2,24)( 5,25)( 7,26)(10,29)(11,30)
  (15,31)(18,32)(20,35)(23,36)(28,37)(34,38),
 ( 5, 7)( 10,11)( 13,15)( 16,18)( 19,20)( 23,25)( 26,28)( 29,30)
  ( 31,32)( 33,35)( 36,38)( 39,41)( 43,44)( 45,46)( 48,50)( 51,53)
  ( 54,56)( 58,60)( 61,62)( 64,66)( 67,68)( 69,71)( 72,73)( 74,75)
  ( 76,77)( 78,79)( 80,82)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)
  ( 93,94)( 95,97)( 98,99)(100,101)(102,103)(104,105)(106,107)(108,109)
  (110,111)(112,113)(114,116)(117,118)(119,120)(121,122)(123,124)(125,126)
  (127,128)(129,131)(133,134)(135,136)(138,140)(141,143)(145,146)(147,148)
  (150,152)(153,155)(156,157)(158,159)(160,162)(163,164)(165,166)(167,169)
  (170,171)(172,173)(174,176)(177,179)(180,181)(182,183)(184,186)(187,188)
  (189,190)(191,193)(194,195)(196,197)(198,200)(201,202)(203,204)(205,207)
  (208,209)(210,211)(212,214)(215,216)(217,218)(219,221)(222,223)(224,225)
  (226,228)(229,230)(231,232)(233,235)(236,237)(238,239)(240,242)(243,244)
  (245,246)(247,248)(249,250)(251,252)(253,254)(255,256)(257,258)(259,260)
  (261,262)(263,264)(265,266)(267,268)(269,270)(271,272)(273,274)(275,276)
  (277,278)(279,280)(281,282)(283,284)(285,286)(287,288)(289,290)(291,292)
  (293,294)(295,296)(297,298)(299,300)(301,302)(303,304)(305,306)(307,308)
  (309,310)(311,313)(314,316)(317,319)(320,322)(323,325)(326,328)(329,331)
  (332,334)(335,337)(338,340)(341,343)(344,346)(347,348)(349,350)(351,352)
  (353,354)(355,356)(357,358),( 1,20)( 2,21)( 3,23)( 4,25)( 5,26)( 6,27)
  ( 7,28)( 8,30)( 9,31)(18,32)(19,34),( 1,3)( 5,11)( 8,13),
 ( 1,4)( 2,7)( 5,10)( 9,12)(11,13),( 4,6)( 9,11)(15,16)(19,21)(25,26)
  (30,32)(35,36)(40,42)(45,47)(50,52),( 1,5)( 6,10)( 8,11),
 ( 5,7)(10,11)(14,16)(18,19)(23,24)(26,28)(31,32)(35,37)(39,40)(44,45),
 ( 5,9)(10,13)(15,18)(20,24)(26,29)(30,33)(35,39)(41,44)(46,49)(50,54),
 ( 1,9)( 2,13)( 5,15)( 7,18)(12,20)(16,23),
 ( 1,11)( 4,14)( 5,18)( 7,20)(10,21)(15,23),
 ( 3,6)( 8,10)(12,15)(16,18)(19,21),( 6,7)( 8,9)(12,13)(15,16)(18,20),
 ( 5,6)( 8,9)(13,14)(16,17)(21,22)(25,26),
 ( 5,6)( 8,9)(13,14)(17,18)(21,22)(24,25)(27,28)(30,31)(33,34),
 ( 5,7)(10,11)(14,15),( 9,11)(13,15)(18,19)(22,23)(25,28)(29,32)(39,40)
  (44,45)(48,50)(53,55)(58,60)(62,63)(64,65)(67,68)(69,70)(73,75)(79,81)
  (82,84)(85,87)(91,93)(94,96),( 1,4)( 5,8)(12,16)(24,25)(26,27)(28,30)
  (33,34)(35,36)(37,39)(42,43)(44,45)(46,47)(49,50)(52,53),
 ( 7,8)( 9,10)(14,15)(19,20)(23,24),( 1,2)( 4,5)(10,11)(16,17)(20,21)
  (24,25),( 2,7)( 5,8)( 9,14)(11,15),( 1,7)( 3,11)( 5,12)( 8,13)( 9,14)
  (10,15),( 5,8)( 9,12)(14,18)(20,23)(25,28)(29,33)(35,39)(40,43)(45,48)
  (50,54),( 2,3)(11,12)(15,16)(19,20)(24,25)(29,30)(31,32)(36,37)(39,40),
 ( 1,7)( 3,11)( 6,13),( 5,7)(10,11)(18,19)(20,21)(22,23)(25,26)(27,28)
  (30,31)(33,34)(35,36)(37,38),( 1,7)( 3,11)( 6,12),
 ( 1,3)( 5,7)( 9,11)(13,15),( 7,19)( 8,22)( 9,26)(10,33)(11,36)(12,40)
  (14,42)(15,44)(23,46)(25,48)(32,50)(34,52),( 2,8)( 3,9)(10,12)(11,13),
 ( 1,5)( 6,10)(14,18)(19,23)(26,27)(32,33),
 ( 1,8)( 2,9)( 4,10)( 6,12)( 7,13),( 2,6)( 5,7)( 8,13)(10,14),
 ( 5,8)( 9,11)(12,14)(15,18)(19,21)(23,25)(27,29),
 ( 1,2)( 5,6)(14,15)(21,22)(24,25)(27,28)(31,32),
 ( 3,4)( 7,9)(11,12)(14,16)(19,20)(23,24)(28,29)(32,33),
 ( 2,11)( 4,15)( 6,22)( 9,23)(13,24)(17,25)(21,26),
 ( 2,4)( 7,8)(10,11)(13,14),( 4,18)( 5,21)( 7,24)( 8,27)( 9,30)(11,33)
  (12,36)(14,39)(15,42)(16,45),( 5, 6)( 7, 8)( 11,12)( 13,14)
  ( 19,20)( 21,22)( 24,25)( 36,37)( 42,43)( 46,47)( 49,50)( 53,54)
  ( 59,60)( 63,64)( 67,68)( 73,74)( 77,78)( 99,100)(101,102)(103,104)
  (105,106)(107,108)(109,110)(113,114)(115,116)(119,120)(123,124)(151,152)
  (153,154)(155,156)(157,158)(159,160)(161,162),
 ( 1,7)( 3,10)( 5,13)( 6,16),( 5,7)(11,12)(16,18)(21,22)(26,28)(31,33)
  (36,38)(41,43)(46,48)(52,53),( 3,9)( 4,10)( 6,11)( 8,15)(14,19)(18,21),
 (3,5)(4,8)(6,9),( 1,2)( 3,4)( 5,6)( 8,9)(11,12)(14,15)(17,18)(20,21)
  (23,24)(26,27)(29,30)(32,33)(35,36)(39,40)(42,43)(48,49)(51,52)(57,58)
  (60,61),( 1,5)( 2,10)( 3,13)(19,35)(24,36)(28,37)(31,38)(34,39)(41,48)
  (43,49)(46,50),( 1,2)( 7,9)(12,14)(16,17)(19,20)(22,23),
 ( 2,8)( 4,12)( 6,19)(10,23)(14,24)(18,25)(22,26),
 ( 7,15)( 8,18)( 9,22)(10,29)(11,32)(12,36)(19,42)(21,44)(28,46)(30,48)
  (38,50)(39,52),( 3,4)(13,14)(17,18)(21,22)(24,25)(27,28)(31,32)(34,35),
 (13,14)(15,17)(18,20)(21,22)(23,24)(25,27)(31,32)(33,34)(35,36)(37,39)
  (40,41)(42,43)(44,45)(46,48)(50,51)(52,53)(54,55)(57,58)(59,60)(61,62),
 ( 1,7)( 3,10)( 6,13)(11,16)(14,19),(13,14)(15,16)(17,18)(19,20)(21,22)
  (23,24)(25,26)(28,29)(30,31)(32,33)(34,35)(42,43)(45,46),
 ( 2,4)( 8,10)(12,14)(17,19)(21,23)(25,27),( 1,2)( 6,10)( 9,12),
 ( 5,7)( 9,10)(13,14)(18,19)(23,25)(29,31),
 ( 4,7)( 8,11)(13,15)(17,19)(23,24)(29,30),
 ( 4,6)( 7,9)(11,13)(15,18)(24,25)(31,32),
 ( 2,3)(13,14)(17,18)(21,22)(25,26)(27,28)(31,32)(36,37)(38,39)(43,44)
  (45,46)(48,49),( 4,34)( 7,35)( 9,36)( 13,37)( 17,38)( 21,39)
  ( 31,40)( 42,58)( 44,59)( 45,61)( 47,63)( 49,65)( 51,66)( 52,68)
  ( 54,70)( 55,71)( 64,81)( 69,82)( 73,83)( 74,85)( 76,87)( 77,89)
  ( 78,91)( 80,93)( 84,96)( 86,98)( 88,100)( 90,102)( 92,104)( 94,106)
  ( 95,107)( 99,108)(103,109),( 1,10)( 3,14)( 6,17)( 7,20)(11,22)(16,24),
 ( 4,8)(10,12)(11,20)(19,29)(23,31)(25,34)(26,37)(27,43)(28,46)(36,51)
  (38,54)(41,57)(45,60)(47,63)(50,66)(52,69)(58,71)(64,73),
 ( 4,5)( 9,10)(14,15)(18,19)(21,22)(25,26),
 ( 4,8)(10,13)(14,17)(19,23)(25,28)(30,33)(34,38)(40,44)(45,48)(50,53),
 ( 6,7)( 9,11)(14,15)(18,20)(22,23),( 1,9)( 2,11)( 5,13),
 ( 1,7)( 3,9)( 5,15)(10,23)(13,24)(18,25)(20,26),
 ( 4,8)(11,14)(16,19)(23,25)(26,27)(28,30)(31,32),
 ( 1,5)( 2,9)( 3,12)( 6,14)( 7,17)(11,20)(16,22)(19,24),
 ( 1,3)( 8,10)(11,14)(19,21)(23,25)(30,33)(34,36)(41,43)(45,46)(49,50)
  (53,54)(57,58)(62,63)(66,67)(70,71)(74,75),
 ( 2,7)( 4,15)( 6,21)(10,23)(12,24)(17,25)(20,26),
 ( 2,7)( 3,8)(10,14)(13,15),( 1,23)( 3,24)( 5,28)( 7,29)( 8,30)(10,34)
  (12,35)(13,36)(15,37)(17,38)(18,42)(20,43)(22,44)(25,45)(27,46)(31,47)
  (33,48)(39,49)(41,50),( 1,10)( 3,13)( 6,15)( 8,18)(12,22)(16,25),
 ( 1,4)( 6,9)(11,13)(15,18)(20,23),( 2,4)( 9,11)(12,13),
 ( 2,6)(11,15)(13,30)(17,31)(21,32)(24,33)(27,37)(29,46)(36,54)(39,58)
  (42,61)(45,65)(48,68)(51,72)(53,73)(57,74)(60,75)(64,76)(67,77)(71,78),
 ( 1,6)(10,15)(12,30)(16,31)(20,32)(23,33)(26,37)(28,46)(35,54)(38,58)
  (41,61)(44,65)(47,68)(50,72)(52,73)(56,74)(59,75)(63,76)(66,77)(70,78),
 ( 3,4)( 7,8)(11,12)(15,16)(26,27)(29,30)(34,35)(37,38)(42,43)(45,46)
  (48,49)(50,51),( 1,8)( 3,11)( 7,13),
 ( 5, 7)( 13,14)( 16,18)( 22,24)( 29,30)( 31,33)( 42,43)( 47,48)
  ( 51,52)( 53,55)( 60,62)( 63,65)( 69,70)( 74,75)( 79,81)( 88,90)
  ( 98,100)(101,103)(104,106)(108,110)(111,113)(114,116),
 ( 1,4)( 6,8)( 9,11)(12,14),( 6,19)( 9,20)(10,21)(11,23)(13,25)(14,27)
  (16,29)(17,31)(22,33)(24,34)(26,35)(28,36)(30,37)(32,38),
 (13,14)(15,16)(18,19)(21,22)(23,24)(26,27)(29,30)(31,32)(34,35)(37,38)
  (39,40)(42,43),( 4,6)( 7,8)( 9,10)(11,12),
 ( 1,4)( 6,8)(10,13)(15,17)(19,22),( 4,6)( 7,8)( 9,10)(16,17),
 ( 4,38)( 7,40)( 9,41)(12,42)(17,43)(21,44)(23,45)(27,46)(29,48)(33,49)
  (36,50)(51,60)(52,63)(54,66)(55,69)(56,72)(58,75)(59,78)(65,80)(71,82),
 ( 5,6)( 7,10)( 8,11)( 9,12)(14,18)(15,20),( 7,8)(10,11)(12,13)(15,16),
 ( 6, 7)( 9,10)( 11,12)( 17,18)( 19,20)( 23,24)( 25,26)( 30,31)
  ( 34,35)( 40,41)( 51,52)( 55,56)( 61,62)( 65,66)( 69,70)( 73,74)
  ( 79,80)( 99,100)(101,102)(103,104)(105,106)(107,108)(109,110)(111,112)
  (115,116)(119,120)(121,122)(151,152)(153,154)(155,156)(157,158)(159,160)
  (161,162),( 6,17)( 7,20)( 9,23)(10,24)(11,25)(13,26)(14,29)(16,30)(19,31)
  (22,32)(28,35)(34,38)(37,39),( 1,2)( 6,7)(11,12)(14,15)(18,19),
 ( 7,11)(12,16)(17,21)(22,25)(26,30)(31,35)(36,40)(41,45)(46,49)(50,54),
 ( 7,11)(12,16)(17,20)(21,25)(26,30)(31,35)(36,40)(41,44)(45,49)(50,54),
 ( 4,5)(11,12)(15,17)(20,21)(26,27)(29,31)(33,35)(38,39)(43,44)(47,48)
  (51,53)(56,58)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 1,6)( 2,11)( 3,18)( 8,25)(13,27)(17,29)(22,31),( 2,5)(11,12)(13,14),
 ( 3,17)( 6,19)( 9,20)(10,22)(13,23)(16,25),( 4,7)( 6,8)( 9,11)(10,14),
 ( 7,8)(10,11)(13,15)(18,19)(21,22)(24,26),
 ( 4,6)(11,13)(16,17)(20,21)(25,26)(29,31)(40,41)(44,46)(49,50)(53,55)
  (60,62)(65,67)(70,72)(75,77)(80,82)(85,87),
 ( 1,10)( 2,14)( 3,21)( 4,22)( 9,24)(13,26)(16,27)(19,29)(23,30)(25,31)
  (28,32),( 6,7)( 9,10)(12,13)(14,15)(21,22)(23,24)(27,28)(31,32)(57,58)
  (60,61)(62,63)(65,66)(67,68)(70,71)(72,73)(75,76)(77,78)(80,81)(82,83)
  (85,86),( 4,7)( 6,8)(12,14)(15,17)(16,18),
 ( 1,5)( 2,8)( 4,9)( 6,10),( 5,7)(10,12)(15,17)(21,22)(25,27)(31,32)
  (36,38)(41,42)(46,48)(51,53),( 3,4)( 6,7)( 9,10)(13,14)(18,19)(24,25)
  (29,30)(32,33),( 5,7)( 9,11)(13,14)(19,20)(23,24)(25,27)(29,30)(36,37)
  (39,40)(44,45)(49,50)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76),
 ( 2,3)( 8,9)(13,14)(16,17)(21,22),( 2,10)( 4,13)( 5,16)( 8,19)(14,21)
  (18,24),( 1,9)( 3,13)( 5,17)( 8,21)(14,24)(19,27)(22,28)(25,29),
 ( 6,14)( 7,17)( 8,18)(11,21)(12,22)(13,25),
 ( 7,10)(11,14)(16,17)(20,21)(24,26)(28,30)(39,40)(44,45)(47,49)(52,54)
  (57,59)(63,64)(65,66)(68,69)(70,71)(73,75)(76,78)(82,84)(85,87)(88,90)
  (94,96),( 1,4)( 2,7)( 3,11)( 5,13)( 9,16)(10,19)(14,21)(17,23),
 ( 1,7)( 4,11)( 6,15)(10,17)(14,19),( 2,10)( 4,13)( 7,15)( 8,19)(12,22)
  (16,25),( 4,20)( 7,21)( 8,22)(11,26)(12,27)(13,28)(15,29)(17,33)(19,34)
  (23,35)(30,36),( 1,9)( 3,12)( 4,15)( 6,18),
 ( 1,5)( 2,13)( 3,18)( 6,22)( 9,25)(10,27)(15,30)(17,32)(20,34)(23,36)
  (28,38),( 1,7)( 3,15)( 5,21)( 9,23)(11,24)(16,25)(19,26),
 ( 5,6)( 9,10)(12,13)(15,17)(19,20)(23,24)(27,28),
 ( 7,10)(11,13)(15,16)(19,20)(22,24),( 1,11)( 3,12)( 6,13)( 8,14),
 ( 5,7)( 8,10)(11,13)(15,17)(18,20),( 4,19)( 5,22)( 7,25)( 8,28)( 9,31)
  (11,34)(12,37)(14,40)(15,43)(16,46),( 7,8)(10,11)(13,14)(17,18),
 ( 1,20)( 2,21)( 3,22)( 4,24)( 5,26)( 6,27)( 7,28)( 8,30)( 9,32)(18,33)
  (19,34),( 7,10)(12,15)(18,20)(23,25)(27,29)(31,34)(36,39)(42,44)(47,49)
  (51,53),( 1,8)( 4,12)( 7,16)( 9,17)(13,18),
 ( 7,8)(10,11)(13,14)(18,19)(21,22)(28,29),
 ( 1,5)( 2,12)( 3,17)( 6,25)(10,27)(15,29)(21,31),
 ( 4,5)( 8,10)(12,13)(15,17)(20,21)(24,25)(28,29)(33,34),
 ( 1,5)( 2,12)( 3,16)( 6,22)(11,24)(15,26)(18,27)(21,29)(23,30)(25,31)
  (28,32),( 2,10)( 4,11)( 5,13)( 8,14),( 5,6)( 9,10)(12,13)(16,17)(22,23)
  (26,27),( 2,8)( 7,11)( 9,12)(10,13),( 4,5)( 8,10)(13,15)(19,21)(24,25)
  (28,30)(34,36)(39,41)(44,45)(49,51),( 1,5)( 2,12)( 6,14),
 ( 5, 6)( 12,13)( 16,17)( 19,20)( 27,28)( 31,32)( 43,44)( 45,46)
  ( 49,50)( 53,54)( 55,56)( 58,59)( 60,61)( 62,63)( 65,66)( 67,68)
  ( 70,71)( 82,83)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111),
 ( 6,7)( 9,10)(12,13)(16,17)(22,23)(26,27),
 ( 1,9)( 2,12)( 3,16)( 4,19)( 5,22)( 6,26)( 7,31)( 8,36)(11,41)(14,42)
  (18,46)(20,47)(23,50)(25,51)(27,52)(30,53)(33,57)(35,58)(38,61)(39,62)
  (43,63)(49,64)(54,65)(60,66),( 4,5)( 8,10)(14,15)(16,17)(20,22),
 ( 1,4)( 8,9)(10,12)(13,14)(15,17),( 1,10)( 2,12)( 3,13)( 5,14)( 9,15)
  (11,16),( 4,6)( 8,10)(11,13)(15,17),( 4,5)( 6,8)( 9,11)(12,13)(14,16)
  (17,19)(20,21)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33)(34,35),
 ( 2,7)( 3,12)( 4,23)( 6,24)( 9,25)(11,26),
 ( 2,3)( 4,7)(11,14)(16,19)(23,26),( 1,9)( 3,11)( 4,12)( 6,14)( 8,15)
  (10,16)(13,17),( 4,5)(10,11)(12,13)(14,15),
 ( 3,8)( 5,10)(12,14)(13,15),( 2,3)( 4,7)(12,15)(16,19)(24,27),
 ( 8,26)( 10,27)( 15,28)( 18,29)( 21,30)( 23,31)( 25,32)( 33,59)
  ( 36,60)( 40,63)( 41,64)( 46,66)( 49,69)( 51,70)( 55,71)( 61,86)
  ( 65,87)( 74,89)( 76,90)( 77,92)( 78,94)( 80,96)( 82,97)( 84,99)
  ( 85,101)( 88,104)( 91,106)( 93,108)( 95,110)( 98,112)(100,114)(107,116)
  (111,117)(115,118),( 1,10)( 2,12)( 5,13)( 7,14)( 9,15)(11,16),
 ( 1,4)( 9,15)(10,16)(12,18)(14,20)(17,21)(19,22),
 ( 4,5)(10,11)(13,14)(17,18)(21,22),( 4,5)( 6,8)( 9,10)(16,17),
 ( 9,10)( 13,15)( 18,21)( 22,23)( 25,28)( 34,36)( 38,39)( 41,42)
  ( 45,46)( 50,52)( 53,55)( 62,64)( 66,67)( 69,71)( 72,73)( 75,77)
  ( 87,89)( 97,99)(100,102)(103,105)(106,108)(111,113)(114,116)(117,119),
 ( 1,3)( 4,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 4,6)( 8,9)(12,13)(16,17)(20,21),(1,2)(4,6)(8,9),
 ( 1,2)( 7,9)(11,14)(19,21)(23,26),( 3,8)( 5,9)(10,13)(11,15),
 ( 3,5)( 8,10)(11,13)(14,16)(17,19),( 2,9)( 4,11)( 6,12)( 7,14),
 ( 4,7)( 9,11)(13,15)(16,19)(22,23)(27,28),
 ( 4,5)( 8,9)(14,15)(24,25)(26,27)(29,30)(31,32),
 ( 8,9)(14,15)(18,19)(23,24)(26,27)(28,29)(31,32),
 ( 1,6)( 2,15)( 3,20)( 7,24)(13,27)(16,30)(22,33)(25,36),
 ( 4,5)(10,11)(14,15)(18,19)(22,23),( 2,10)( 5,11)( 7,14)( 8,17)( 9,20),
 ( 3,5)( 8,10)(12,14)(17,19)(21,23)(25,27),
 ( 2,10)( 5,11)( 7,12)( 8,15)( 9,18),( 2,7)( 3,8)( 5,11)( 9,12)(10,13),
 ( 7,9)(10,12)(13,14)(16,17)(19,20),( 1,5)( 7,10)( 8,11)( 9,12),
 ( 1,2)( 6,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 5,6)(13,14)(19,20)(22,24)(25,27)(29,30)(35,36)(38,40)(41,43),
 ( 1,5)(10,12)(13,30)(17,31)(20,32)(23,33)(26,37)(28,46)(35,54)(38,58)
  (41,61)(44,65)(47,68)(50,72)(52,73)(56,74)(59,75)(63,76)(66,77)(70,78),
 ( 3,5)( 6,9)(11,13)(14,16)(18,21)(24,26)(29,31)(33,35),
 ( 2,3)( 6,7)(11,12)(15,16)(18,19)(21,22),
 ( 9,10)( 13,14)( 17,19)( 21,22)( 25,27)( 36,38)( 41,43)( 44,46)
  ( 47,48)( 52,53)( 59,60)( 64,65)( 68,70)( 71,72)( 74,76)( 77,78)
  ( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)(101,102),
 ( 8,19)(11,34)(14,35)(17,36)(20,37)(23,38)(26,39)(29,40)(31,49)(33,58)
  (42,59)(45,63)(48,65)(51,69)(54,71)(57,75)(61,77)(64,78)(67,79)(70,80)
  (73,81)(76,82),( 4,5)(10,11)(15,16)(21,22)(26,27),
 ( 3,5)( 8,10)(13,15)(17,19)(20,22)(24,26),
 ( 4,17)( 5,18)( 6,20)( 7,21)( 8,22)( 9,23)(10,25)(11,26)(12,27)(13,29)
  (14,30)(15,32)(16,33)(35,40)(36,42)(37,44)(38,45)(39,47)(48,51)(49,52)
  (50,53),( 8,9)(12,13)(15,16)(17,18)(19,20),
 ( 1,5)( 2,9)( 3,13)( 4,17),( 2,9)( 4,10)( 6,12)(11,14)(13,15),
 ( 7,8)(11,12)(17,18)(23,24)(26,27)(28,29)(31,32),
 ( 5,38)( 8,40)(10,41)(13,42)(18,43)(22,44)(24,45)(28,46)(30,48)(34,49)
  (37,50)(51,60)(52,63)(53,66)(55,69)(56,72)(57,75)(62,78)(68,80)(74,82),
 ( 2,7)( 4,15)( 6,19)( 9,23)(14,26)(17,27)(22,28)(25,29),
 ( 6,7)( 9,10)(14,15)(18,19)(22,23)(25,26)(28,29)(31,32)(34,35),
 ( 1,2)( 3,12)( 6,13),( 2,9)( 3,12)( 5,15)( 6,16)( 8,19)(10,20)(13,21)
  (17,22),( 1,10)( 3,13)( 6,15)( 8,18)(12,20)(16,23),
 ( 3,5)( 8,10)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26),
 ( 5,7)( 9,11)(12,14)(17,19)(20,22),( 5, 6)( 16,17)( 20,21)( 24,25)
  ( 26,27)( 30,31)( 33,34)( 37,38)( 39,40)( 42,43)( 47,48)( 53,54)
  ( 57,58)( 61,62)( 63,64)( 77,78)( 81,82)( 85,86)( 89,90)( 92,93)
  ( 96,97)(100,101)(104,105)(108,109)(111,112)(115,116)(119,120)(123,124)
  (126,127)(130,131)(138,139)(142,143)(150,151)(153,154)(157,158)(160,161)
  (164,165)(167,168)(171,172)(174,175)(177,178)(181,182)(184,185)(188,189)
  (191,192)(195,196)(198,199)(202,203)(205,206)(209,210)(212,213)(216,217)
  (219,220)(223,224)(226,227)(230,231)(233,234)(237,238)(240,241)(264,265)
  (268,269)(272,273)(276,277)(280,281)(284,285)(288,289)(292,293)(296,297)
  (300,301)(304,305)(308,309)(311,312)(314,315)(317,318)(320,321)(323,324)
  (326,327)(329,330)(332,333)(335,336)(338,339)(341,342)(344,345),
 ( 4,7)( 8,10)(11,13)(15,17)(18,21),( 1,4)( 2,8)( 3,19)(10,24)(13,26)
  (18,28)(21,30),( 3,7)( 4,9)(12,16)(15,17)(18,20)(19,21),
 ( 4,7)( 8,10)(11,12)(13,15)(16,17),(11,13)(14,16)(21,23)(25,26)(33,34)
  (35,36)(40,41)(42,44)(48,49)(50,52)(53,54)(56,57)(59,60)(62,63)(65,66)
  (68,69)(71,72)(73,74)(75,76),( 5,7)( 9,11)(13,15)(17,19)(23,25)(29,31)
  (34,36)(53,54)(57,58)(59,61)(62,64)(65,67)(68,70)(71,73)(74,76),
 ( 1,4)( 2,8)( 3,17)(10,23)(16,26)(19,29)(22,32)(25,35),
 ( 6, 7)( 13,14)( 20,21)( 26,27)( 40,41)( 43,44)( 48,49)( 53,54)
  ( 57,58)( 59,60)( 63,64)( 66,67)( 68,69)( 72,73)( 77,78)( 82,83)
  ( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)(101,102)(105,106)(108,109)
  (111,112)(114,115)(117,118)(120,121),( 4,5)(11,12)(14,15)(17,18)(20,21)
  (23,24)(26,27)(29,30),( 4,5)(11,12)(14,15)(17,19)(22,23)(27,28)(30,32)
  (34,36)(39,40)(47,48)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76)(77,78)
  (79,80)(81,82),( 1,9)( 4,12)( 6,16)( 8,18)(10,21)(15,23),
 ( 4,5)(11,12)(14,15)(17,18)(21,22)(26,27)(29,30)(33,34)(36,37),
 ( 3,4)( 6,7)( 8,9)(10,11)(12,13)(14,15)(16,17)(18,19),
 ( 4,7)( 8,10)(13,15)(16,19)(21,23)(24,26),
 ( 1,9)( 4,12)( 6,14)( 8,17)(11,20),( 5,6)( 8,10)(13,15)(16,18)(19,21)
  (23,24)(29,30),( 2,9)( 5,10)( 6,12)( 8,13),
 (10,30)(12,31)(13,32)(15,34)(17,36)(19,37)(21,38)(23,40)(25,41)(26,42)
  (28,43)(29,45)(48,58)(49,59)(54,65)(55,66)(61,72)(63,74)(68,76),
 ( 3,4)(10,11)(15,16)(20,21)(25,26)(30,31)(35,36)(38,39)(42,43)(47,48)
  (51,52)(56,57)(60,61),( 5,6)( 9,10)(16,17)(21,22)(26,27)(31,32)(40,41)
  (45,46)(49,50)(54,55)(60,61)(65,66)(70,71)(75,76)(80,81)(85,86),
 ( 2,7)( 4,9)( 6,15)(11,23)(14,24)(19,25)(21,26),
 ( 2,9)( 3,10)( 5,14)( 7,18)(11,20)(15,22),
 ( 4,5)( 6,7)(10,11)(13,14)(18,19)(23,24)(26,27)(28,29),
 ( 4,5)(11,12)(16,18)(20,21)(24,25)(28,29)(32,33)(36,37)(40,41)(44,45)
  (48,49)(52,53),( 5,6)( 8,10)(13,15)(18,20)(22,23)(25,27)(28,30)(32,33)
  (36,37),( 1,5)( 2,8)( 4,10),( 1,8)( 2,11)( 4,14)( 5,17),
 ( 4,33)( 11,34)( 14,35)( 19,36)( 22,37)( 23,38)( 27,39)( 30,40)
  ( 41,55)( 44,59)( 46,61)( 47,62)( 50,66)( 51,67)( 54,71)( 60,80)
  ( 65,81)( 72,82)( 73,85)( 75,88)( 76,91)( 77,94)( 79,97)( 83,101)
  ( 86,103)( 89,105)( 92,107)( 95,109)( 98,111)(100,112)(104,113)(108,114),
 ( 1,2)( 4,5)( 7,8)(22,23)(25,26)(28,29)(34,35)(38,39)(43,44)(47,48),
 ( 5,6)( 8,9)(12,13)(15,16)(20,21)(24,25),
 ( 1,3)( 4,5)( 7,8)( 9,10)(12,13)(15,16)(19,20)(23,24),
 ( 1,2)( 8,11)(13,15)(20,23)(25,27),( 7,8)(11,12)(14,15)(18,19)(22,23)
  (26,27)(30,31)(34,35)(39,40)(44,45)(49,50)(54,55)(58,59)(61,62)(65,66)
  (68,69),( 1,5)( 2,8)( 6,11)( 9,12)(10,13),
 ( 1,7)( 2,8)( 5,11)( 9,12)(10,13),( 6,30)( 9,31)( 15,32)( 18,33)
  ( 22,34)( 24,35)( 26,36)( 29,37)( 38,55)( 39,56)( 43,61)( 45,62)
  ( 47,65)( 50,70)( 51,71)( 57,84)( 63,85)( 74,88)( 75,91)( 77,94)
  ( 79,97)( 80,100)( 82,103)( 86,104)( 89,107)( 92,110)( 95,113)( 98,116)
  (101,119)(108,122)(114,123)(120,124),( 6,7)( 8,9)(10,11),
 ( 1,2)( 3,5)(15,16)(18,19)(21,22),( 1,6)( 2,11)( 5,12),
 ( 2,7)( 4,8)( 9,14)(10,17),( 5,6)( 9,10)(14,15)(19,20)(24,25)(31,32)
  (39,40),( 1,5)( 2,7)( 3,9)(10,12)(11,13),
 ( 4,5)( 8,9)(12,13)(20,21)(24,25)(27,28)(30,31),( 1,5)( 6,11)( 9,13),
 ( 6,7)( 9,10)(12,13)(15,16)(20,21)(25,26)(29,30),
 ( 1,7)( 3,14)( 5,20)( 8,23)(11,24)(16,25)(19,26),
 ( 4,5)( 7,8)(10,11)(14,15)(19,20)(25,26)(30,31)(33,34),
 ( 1,7)( 3,14)( 5,18)( 8,23)(12,24)(16,25)(20,26),
 ( 1,7)( 3,13)( 5,17)( 8,23)(12,24)(16,25)(20,26),
 ( 4,6)( 7,10)(11,14)(17,20)(22,24)(25,27)(28,30)(34,37)(41,42)(45,46)
  (50,51)(60,62)(63,65)(66,68)(69,71)(72,74)(75,77),
 ( 4,5)(12,13)(16,17)(18,19)(23,24)(30,31)(48,49)(54,55)(56,57)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78)(80,81),
 ( 2,3)( 5,7)(12,15)(17,19)(24,27),( 1,5)( 2,7)( 8,11)( 9,12)(10,13),
 ( 1,6)( 2,10)( 3,14)( 4,18),( 4,6)( 8,9)(11,13)(14,16)(18,20)(22,24)
  (26,28)(30,31)(33,35)(36,38)(40,41)(43,45)(47,49)(51,53)(55,57),
 ( 5,15)( 6,17)( 8,18)(10,20)(11,21)(13,23),
 ( 1,3)( 9,10)(12,14)(17,18)(20,21)(24,25),
 ( 2,9)( 4,12)( 5,13)( 7,16)( 8,19)(11,20)(15,21)(18,22),
 ( 4,5)( 8,9)(13,14)(18,19)(20,21),( 1,5)(10,15)(11,22)(13,29)(17,31)
  (25,35)(26,39)(27,44)(28,48)(33,51)(36,54)(38,57)(42,60)(45,63)(47,66)
  (55,69)(61,71)(67,73),( 9,10)( 15,16)( 18,19)( 30,31)( 34,35)
  ( 39,40)( 42,43)( 44,45)( 47,48)( 50,51)( 53,54)( 55,56)( 58,59)
  ( 80,81)( 82,83)( 84,85)( 86,87)( 88,89)( 92,93)( 94,95)( 96,97)
  ( 98,99)(100,101)(102,103)(104,105)(106,107)(110,111)(112,113)(114,115)
  (116,117)(118,119)(134,135)(136,137)(138,139)(140,141)(142,143)(144,145)
  (146,147)(148,149)(150,151)(152,153)(154,155)(156,157)(158,159)(160,161)
  (162,163)(164,165)(166,167)(168,169)(170,171)(172,173)(174,175)(183,184)
  (186,187)(190,191)(193,194)(197,198)(200,201),
 ( 8,10)(13,14)(17,19)(22,23)(26,28)(31,32)(35,37)(40,41)(44,46)(49,50),
 ( 2,19)( 5,21)( 8,22)(11,24)(14,25)(17,27),
 ( 3,4)( 9,10)(13,14)(18,19)(22,23)(26,27),( 3,4)( 5,8)( 9,10)(13,14),
 ( 4,5)( 7,9)(10,11)(13,15),( 5,7)( 9,10)(11,12),
 ( 1,2)( 8,9)(13,15)(21,22)(25,26)(29,30)(33,34)(37,38)(41,42)(45,46)
  (49,50)(53,54),( 6,27)( 9,28)( 12,29)( 23,30)( 25,31)( 32,58)
  ( 35,59)( 36,62)( 38,63)( 39,66)( 41,67)( 43,68)( 44,71)( 47,72)
  ( 48,75)( 49,76)( 52,79)( 54,80)( 56,81)( 60,93)( 61,94)( 69,95)
  ( 70,96)( 77,97)( 78,98)( 83,100)( 87,103)( 88,105)( 92,108),
 ( 4,7)( 9,11)(12,16)(17,19)(21,24)(25,28)(30,32)(33,37)(38,40)(42,45),
 ( 4,6)( 8,9)(11,12)(14,15)(17,19),( 2,3)( 5,6)( 8,10)(12,14)(16,18)
  (19,20)(22,23)(25,26)(27,28)(29,30)(31,32)(34,35)(37,38)(39,40)(41,42)
  (43,44)(46,47)(49,50)(51,52)(53,54),( 7,9)(12,14)(16,19)(21,23)(26,29)
  (31,33)(36,38)(40,43)(45,47)(50,53),( 1,8)( 2,15)( 3,20)( 4,24)( 9,27)
  (13,28)(18,31),( 1,3)( 4,10)( 5,11)( 7,12)( 8,13),
 ( 1,10)( 5,14)( 7,16)(11,17)(15,18),( 1,5)( 3,10)( 6,12)( 8,14),
 ( 1,8)( 2,15)( 3,20)( 5,24)(10,25)(14,28)(19,29),
 ( 9,29)( 11,30)( 14,31)( 18,32)( 23,33)( 25,34)( 28,35)( 38,50)
  ( 39,54)( 41,55)( 42,59)( 45,60)( 46,62)( 49,66)( 51,79)( 53,80)
  ( 58,81)( 63,82)( 65,83)( 69,86)( 70,89)( 72,92)( 75,95)( 76,98)
  ( 78,101)( 84,102)( 87,104)( 90,106)( 93,108)( 96,110)( 99,112)(103,114)
  (107,115)(111,116),( 7,9)(12,13)(16,18)(21,22)(25,27)(30,31)(34,36)
  (39,40)(43,45)(48,49),( 7,17)( 8,21)( 9,24)(10,31)(11,35)(12,38)(14,41)
  (15,43)(23,45)(25,47)(32,49)(34,51),( 1,10)( 2,11)( 4,14)( 5,15)( 7,16)
  ( 9,17)(13,18),( 2,7)( 6,8)( 9,12)(10,13),
 ( 6,8)(11,13)(17,19)(23,25)(27,29)(31,33)(35,37)(52,53)(56,57)(59,61)
  (62,64)(65,67)(68,70)(71,73)(74,76),( 2,8)( 4,14)( 6,22)(10,23)(13,24)
  (18,25)(20,26),( 3,7)(10,19)(11,23)(12,30)(25,32)(26,36)(27,41)(28,45)
  (33,51)(34,53)(37,56)(39,59)(42,62)(43,64)(46,67)(48,70)(54,72)(60,74)
  (68,76),( 1,13)( 2,18)( 9,37)(10,38)(12,42)(14,46)(15,47)(17,48)(19,49)
  (20,50)(23,53)(24,54)(25,56)(27,60)(29,61)(30,62)(31,64)(33,68)(34,69)
  (36,70)(39,71)(40,72)(41,73)(43,74)(44,75)(45,76)(51,79)(52,80)(55,81)
  (57,82)(58,83)(59,84)(63,87)(65,88)(66,89)(67,90)(77,93)(78,94)(85,95)
  (86,96)(91,97)(92,98),( 3,5)( 4,8)( 6,10),
 ( 4,6)( 9,10)(14,16)(19,21)(24,26)(29,31)(34,36)(40,41)(44,46)(50,51),
 ( 5,8)(10,14)(15,18)(20,24)(25,29)(31,34)(35,39)(41,44)(46,49)(51,54),
 ( 6,7)(11,12)(13,14)(17,18)(21,22),( 6,8)(11,12)(16,18)(21,23)(26,28)
  (31,33)(36,38)(42,43)(46,48)(52,53),( 6,8)(11,12)(15,17)(21,23)(26,28)
  (31,32)(36,38)(42,43)(46,48)(51,53),( 2,9)( 4,11)( 7,14)( 8,17)(12,21)
  (16,24),( 2,4)( 6,8)( 9,11)(13,15)(17,18),
 ( 5,7)( 9,10)(13,14)(17,19)(24,25)(30,31),
 ( 2,13)( 4,17)( 6,20)( 9,21)(12,23)(18,26)(24,28)(27,29),
 ( 5,6)( 9,10)(13,14)(17,18)(20,21)(23,24)(28,29)(33,34)(42,43)(46,47)
  (51,52)(55,56),( 1,10)( 2,17)( 3,21)( 4,24)( 7,27)(16,30)(26,32)(29,34),
 ( 6,7)( 8,9)(12,13)(15,16)(20,21)(23,24)(26,27)(28,29),
 ( 4,5)( 6,7)( 9,10)(21,22)(23,24),( 4,5)( 9,10)(14,15)(17,18)(20,21)
  (24,25)(29,30)(32,33)(44,45)(48,49)(52,53)(56,57),
 ( 6,7)(11,12)(14,15)(18,19)(20,21)(22,23)(24,25)(27,28),
 ( 2,6)( 8,11)(13,17)(19,22)(24,28),( 7,9)(14,16)(18,20)(25,27)(28,30)
  (32,34)(35,37)(39,41)(43,45)(46,47)(48,49)(50,52)(55,56)(57,58)(59,60)
  (61,63),( 2,9)( 4,10)( 6,13)( 8,17)(12,19)(16,21),
 ( 3,4)( 7,8)(10,11)(13,14)(16,17)(20,21),
 ( 1,10)( 2,16)( 3,20)( 4,25)(12,27)(15,29)(23,31),
 ( 9,10)(11,13)(15,16)(17,18)(20,22),( 6,7)(10,11)(14,15)(18,19)(21,22)
  (25,26)(29,30)(33,34),( 8, 9)( 12,13)( 15,16)( 18,19)( 20,21)
  ( 25,26)( 27,28)( 31,32)( 46,47)( 48,49)( 51,52)( 53,54)( 56,57)
  ( 58,59)( 73,74)( 77,78)( 79,80)( 82,83)( 85,86)( 89,90)( 91,92)
  ( 94,95)( 98,99)(102,103)(105,106)(108,109)(112,113)(115,116),
 ( 6,7)( 9,10)(14,15)(18,19)(21,22)(24,25)(29,30)(34,35)(44,45)(48,49)
  (52,53)(56,57),( 4,9)( 7,10)(11,13)(12,14),( 1,4)( 2,9)( 5,12),
 ( 6,7)( 9,10)(14,15)(17,18),( 4,17)( 6,19)( 8,20)(11,22)(13,23)(15,25),
 ( 5,6)( 8,9)(11,12)(15,16)(20,21)(25,26)(30,31)(33,34),
 ( 5,38)( 8,39)(12,40)(14,42)(18,43)(20,44)(24,45)(29,46)(32,47)(34,48)
  (37,50)(51,60)(53,63)(54,66)(55,69)(57,72)(58,75)(64,77)(70,79)(76,81),
 ( 5,6)(10,11)(13,14)(17,18),( 3,6)( 5,7)( 8,11)( 9,12),
 ( 3,4)( 6,8)(10,12)(13,15)(17,19),( 1,3)( 4,6)( 7,9)(10,12)(15,18)
  (21,24),( 9,20)( 11,22)( 12,23)( 16,25)( 17,26)( 28,38)( 30,44)
  ( 34,53)( 40,73)( 45,74)( 46,75)( 48,76)( 52,77)( 56,78)( 60,79)
  ( 62,83)( 64,89)( 65,91)( 66,97)( 68,103)( 70,109)( 71,111)( 72,117)
  ( 80,134)( 82,136)( 86,138)( 94,140)( 96,142)(100,144)(106,146)(110,148)
  (114,150)(120,153)(122,155)(123,157)(124,159)(125,161)(126,163)(127,165)
  (128,167)(129,169)(130,171)(131,173)(133,175)(139,176)(145,177)(151,178)
  (154,185)(158,188)(162,192)(166,195)(170,199)(174,202)(186,204)(189,205)
  (193,206)(196,207)(200,208)(203,209),( 5,6)(10,11)(13,14)(18,19)(23,24),
 ( 8,9)(10,11)(14,15)(16,17),( 5,6)(10,11)(14,16)(17,18)(24,26)(29,31)
  (33,34)(39,40)(42,44)(46,47)(48,50)(53,55)(57,58)(59,61),
 ( 3,4)(10,11)(14,15)(18,19)(22,23),( 5,6)( 8,9)(11,12)(18,19)(22,23)
  (25,26)(30,31)(34,35)(37,38),( 9,12)(13,17)(18,22)(23,26)(27,30)(31,34)
  (35,39)(40,44)(45,48)(49,52),( 1,2)( 9,10)(13,14)(16,17)(19,20),
 ( 5,37)( 8,38)(12,39)(14,41)(19,42)(22,43)(25,45)(28,46)(31,47)(33,48)
  (36,50)(51,63)(52,66)(54,69)(56,72)(57,75)(59,78)(64,79)(70,80)(76,81),
 ( 5,6)( 8,9)(11,12)(19,20)(23,24)(25,26)(30,31)(33,34)(35,36),
 ( 5,6)( 8,9)(11,12)(19,20)(24,25)(26,27)(30,31)(32,33),
 ( 7,8)(12,14)(17,18)(22,24)(27,29)(32,34)(37,39)(42,44)(48,49)(52,54),
 ( 6,7)(10,11)(14,15)(22,23)(25,26)(28,29)(31,32)(44,45)(53,54)(60,61)
  (62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)
  (82,83),( 7,8)( 9,11)(12,13)(15,17)(18,19)(21,23)(24,26)(27,29)(30,31)
  (32,33)(42,43)(45,46)(48,49)(51,52)(54,55)(57,58)(59,61)(62,63)(65,67)
  (68,69)(71,73)(74,75),( 3,4)(10,11)(15,16)(20,21)(25,26)(30,31)(35,36)
  (37,38)(42,43)(46,47)(51,52)(55,56)(60,61),
 ( 1,2)(11,12)(14,15)(17,18)(21,22)(23,24)(26,27)(28,29)(31,32)(33,34),
 ( 5,6)( 9,11)(14,16)(20,22)(25,26)(29,31)(35,37)(40,42)(45,46)(50,52),
 ( 1,4)( 9,11)(13,15)(20,23)(24,26)(31,33)(34,36)(41,43)(44,45)(48,49)
  (52,53)(57,58)(61,62)(65,66)(69,70)(74,75),
 ( 4,6)( 7,10)(12,15)(16,18)(22,24)(30,32),( 2,5)( 3,7)( 9,13)(10,17),
 ( 4,9)( 6,11)(12,14)(13,15),( 4,6)( 9,11)(14,16)(18,19)(21,23)(24,26)
  (28,29)(32,33)(36,37),( 3,6)( 7,9)(10,12)(13,16)(18,21)(24,26)(29,31)
  (33,35),( 4,5)( 7,8)(10,11)(13,14)(15,16)(18,19)(21,22)(24,25)(26,27)
  (29,30)(31,32)(34,35)(37,38)(40,41)(42,43)(45,46)(48,49)(51,52)(53,54)
  (56,57),( 1,5)( 2,8)( 4,10)( 6,11),( 5,20)( 7,21)(10,22)(11,24)(13,27)
  (14,28)(16,29)(18,30)(19,34)(26,35)(33,36),
 ( 5,10)( 6,13)( 7,14)( 8,16)( 9,19)(20,25)(21,29),( 1,5)( 4,9)( 8,11),
 ( 4,7)( 8,9)(10,11)(12,13)(14,15)(16,18)(19,20),
 ( 5,7)( 9,11)(13,14)(18,19)(22,24)(26,27)(29,30)(36,37)(40,41)(48,49)
  (59,60)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78)(79,80)(81,82),
 ( 4,21)( 6,22)( 7,24)( 9,26)(11,27)(13,28)(15,30)(17,32)(20,33)(25,34)
  (31,35),( 4,5)( 9,10)(12,13)(15,16)(25,26)(32,33),
 ( 1,2)( 3,5)(14,15)(17,18)(20,21),( 1,2)(11,12)(15,16)(19,20)(23,24)
  (26,27)(30,31)(35,36)(38,39)(44,45)(47,48)(51,52),
 ( 1,2)(11,12)(15,16)(19,20)(23,24)(26,27)(31,32)(36,37)(39,40)(45,46)
  (47,48)(50,51),( 2,8)( 5,12)( 6,13)(11,17)(16,18),
 ( 1,3)( 6,8)(10,12)(14,16)(19,21),( 1,3)( 6,8)(10,12)(13,15),
 ( 1,4)( 5,8)( 7,10),( 2,4)( 7,10)(12,13)(16,17)(20,21),
 ( 2,8)( 3,11)( 5,14)( 6,17),( 3,6)( 8,11)(12,14)(15,17)(18,21)(22,24)
  (26,28)(31,33),( 5,7)(10,11)(12,13)(17,19)(22,23),
 ( 5,6)( 8,9)(12,13)(17,18)(21,22),( 1,2)( 4,11)( 6,12)( 8,13)( 9,14)
  (10,15),( 3,4)( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33)(39,40)(44,45)
  (48,49)(53,54)(57,58)(62,63),( 5,6)(12,13)(15,16)(18,19)(21,22)(23,24)
  (27,28)(29,30),( 8,30)(10,31)(13,32)(27,33)(34,53)(35,55)(36,58)(37,60)
  (38,63)(40,65)(41,66)(42,67)(43,70)(44,72)(45,75)(46,77)(47,80)(49,82)
  (50,83)(51,84)(56,86)(57,87)(59,88)(68,89)(69,90)(71,91)(78,92)(79,93)
  (81,94),( 5,6)(12,13)(15,16)(18,19)(21,22)(23,24)(28,29)(30,31),
 ( 5,9)(10,14)(16,19)(20,24)(26,29)(31,34)(36,39)(41,44)(46,50)(51,54),
 ( 4,5)( 9,10)(13,14)(16,18)(22,24)(28,30),
 ( 4,5)( 9,10)(13,14)(16,17)(19,20)(22,23)(25,26)(30,31),
 ( 9,11)(13,15)(17,19)(22,24)(26,29)(31,33)(35,37)(39,41)(44,46)(48,51),
 ( 4,5)( 9,10)(13,14)(16,17)(19,20)(23,24)(26,27)(31,32),
 ( 2,11)( 3,12)( 4,15)( 5,17)( 8,18)( 9,20)(13,22)(16,23)(19,24)(21,25),
 ( 5,7)(10,11)(14,15)(18,19)(22,24)(26,28)(31,32)(35,36)(39,40)(43,45),
 ( 1,3)( 5,9)( 6,12),( 2,44)( 4,46)( 6,47)( 9,49)(11,50)(13,52)(15,54)
  (18,56)(20,58)(22,60)(24,61)(26,63)(28,64)(30,66)(32,67)(34,69)(36,71)
  (38,73)(40,75)(43,77),( 3,5)( 8,9)(11,12)(15,17)(19,20)(22,23)(26,27)
  (31,32),( 4,5)( 9,10)(13,14)(17,18)(20,21)(24,25)(28,29),
 ( 1,11)( 4,13)( 7,14)( 8,15)( 9,16),( 7,9)(11,12)(15,16)(18,20)(21,24),
 ( 2,3)(11,12)(15,16)(18,19)(21,22)(25,26),
 ( 2,3)( 6,7)(10,11)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 2,4)( 7,9)(12,13)(16,18)(21,22),
 ( 2,11)( 3,12)( 6,16)( 8,17)(13,18),( 8, 9)( 11,12)( 15,16)( 19,20)
  ( 22,23)( 25,26)( 36,37)( 43,44)( 47,48)( 50,51)( 53,54)( 55,56)
  ( 58,59)( 60,61)( 62,63)( 65,66)( 67,68)( 73,74)( 85,86)( 88,89)
  ( 91,92)( 94,95)( 97,98)(100,101)(102,103)(104,105)(106,107)(108,109)
  (110,111)(112,113),( 4,5)( 8,10)(14,15)(19,21)(24,25)(29,31)(34,36)
  (39,41)(44,46)(49,51),( 1,2)(10,11)(12,13)(16,17)(20,21)(23,24)(26,27)
  (28,29)(35,36)(38,39)(41,42)(44,45)(47,48)(50,51)(52,53)(56,57)(59,60)
  (63,64)(66,67)(70,71),( 1,8)( 2,9)( 4,11)( 6,13)(10,14)(12,15),
 ( 4, 5)( 8, 9)( 18,19)( 22,23)( 26,27)( 43,44)( 46,47)( 49,50)
  ( 51,52)( 53,54)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 73,74)( 78,79)( 82,83)( 84,85)( 86,87)( 88,89)( 90,91)
  ( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105),
 ( 7, 8)( 13,14)( 15,16)( 20,21)( 29,30)( 38,39)( 41,42)( 43,44)
  ( 45,46)( 47,48)( 50,51)( 52,53)( 55,56)( 58,59)( 60,61)( 62,63)
  ( 65,66)( 67,68)( 88,89)( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)
  (101,102)(103,104)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117)
  (118,119)(120,121)(122,123)(125,126)(130,131)(135,136)(161,162)(163,164)
  (165,166)(167,168),( 6,9)(10,13)(15,18)(19,22)(24,27)(28,31)(33,36)
  (37,40)(42,45)(46,49),( 5,6)(10,11)(16,17)(20,21)(24,25),
 ( 3,4)( 5,7)(10,11)(12,13)(14,15),( 1,3)( 6,7)(10,12)(14,16)(19,21),
 (10,12)(15,17)(19,21)(23,25)(27,30)(32,34)(37,39)(41,43)(45,47)(49,52),
 ( 1,13)( 2,18)( 3,22)( 4,27)( 5,31)( 6,36)( 7,40)( 8,45)( 9,49)(10,54),
 ( 2,8)( 4,16)( 6,20)(10,23)(15,26)(18,27)(22,28)(25,29),
 ( 3,5)( 7,8)(11,13)(15,16),( 2,13)( 3,14)( 5,17)( 6,19)( 8,20)( 9,23)
  (11,25)(12,26)(16,27)(18,28)(22,29)(24,30),
 ( 1,2)( 7,9)(10,12)(15,17)(18,20),( 9,10)(11,14)(15,16)(18,19)(20,21)
  (23,24),( 1,3)( 7,15)( 9,16)(11,17)(13,18),
 ( 1,2)(10,11)(13,14)(17,18)(20,21)(23,24)(26,27)(28,29)(35,36)(38,39)
  (41,42)(44,45)(47,48)(50,51)(52,53)(56,57)(59,60)(63,64)(66,67)(70,71),
 ( 6,9)(11,13)(16,19)(20,21)(22,24)(25,26)(27,29)(30,32)(33,34)(35,36)
  (37,38),( 4,11)( 5,13)( 6,14)( 7,16)( 8,17)( 9,19),
 ( 9,10)(13,14)(15,16)(19,20)(22,23)(26,27)(36,37)(39,40)(43,44)(47,48)
  (50,51)(53,54)(70,71)(73,74)(76,77)(79,80),
 ( 4,5)( 6,8)(10,11)(12,13)(14,16)(17,19)(20,21)(22,23)(24,25)(26,27)
  (28,29)(30,31),( 9,10)( 13,14)( 15,16)( 20,21)( 25,26)( 37,38)
  ( 47,48)( 50,51)( 52,53)( 54,55)( 57,58)( 59,60)( 61,62)( 63,64)
  ( 65,66)( 67,68)( 70,71)( 72,73)( 76,77)( 79,80)( 81,82)( 89,90)
  ( 91,92)( 94,95)( 96,97)( 98,99)(100,101)(103,104)(105,106)(107,108)
  (114,115)(116,117),( 5,8)(10,14)(16,19)(20,23)(25,29)(31,34)(36,39)
  (40,44)(46,50)(51,54),( 1,6)( 5,9)( 7,11),
 ( 9,10)(13,14)(16,17)(19,20)(24,25)(28,29)(30,31)(34,35)(39,40)(42,43)
  (45,46)(49,50),( 5,33)( 8,34)(12,35)(15,36)(20,37)(29,38)(32,39)(40,58)
  (41,62)(42,63)(45,67)(46,68)(47,72)(49,73)(50,77)(51,78)(54,82)(55,83)
  (56,87)(64,88)(66,89)(74,90)(76,91)(84,92)(86,93),
 ( 9,10)(11,13)(14,15)(17,18)(20,22)(23,25),
 ( 5,6)( 8,9)(15,16)(20,21)(25,26)(29,30)(34,35)(39,40),
 ( 6,34)( 9,35)(12,36)(21,37)(28,38)(30,39)(33,40)(41,58)(43,59)(44,63)
  (45,64)(47,68)(48,69)(49,73)(51,74)(52,78)(53,79)(55,83)(56,84)(60,87)
  (62,88)(70,89)(72,90)(80,91)(82,92),( 3,4)( 7,8)(16,17)(20,21)(25,26)
  (27,28)(32,33)(34,35),( 1,12)( 2,18)( 3,22)( 6,24)( 7,26)(13,29)(16,31),
 ( 4,25)( 6,28)( 23,29)( 27,40)( 31,50)( 33,52)( 35,54)( 37,56)
  ( 38,57)( 41,60)( 43,62)( 44,63)( 47,66)( 48,69)( 55,81)( 61,82)
  ( 67,85)( 70,88)( 71,89)( 74,92)( 75,93)( 77,95)( 80,98)( 83,101)
  ( 84,107)( 86,112)( 87,113)( 90,116)( 91,117)( 94,120)( 96,122)( 97,123)
  (100,126)(102,128)(104,130)(106,132)(108,134)(110,136)(111,137)(121,138)
  (125,139)(127,141)(129,143)(131,145)(133,147)(135,149)(140,152)(142,154)
  (144,156)(146,158)(148,160)(150,162)(151,163)(155,164)(159,165),
 ( 4,6)( 8,10)(13,14)(17,18)(21,22)(25,27)(29,31)(34,35)(38,39)(42,43),
 ( 8,9)(12,13)(16,17)(20,21)(24,25)(28,29)(30,31)(35,36)(37,38)(42,43)
  (44,45)(47,48),( 3,8)( 7,9)(10,13)(11,15),
 (10,11)(12,13)(15,17)(18,20)(21,22)(23,24),
 ( 6,7)( 9,11)(14,15)(17,18)(20,22)(25,26),
 ( 4,20)( 5,23)( 9,25)(10,26)(13,29)(14,31)(16,32)(18,33)(22,34)(24,35)
  (28,36)(30,37),( 3,4)(14,15)(18,19)(22,23)(25,26)(27,28)(31,32)(36,37)
  (38,39)(43,44)(45,46)(48,49),( 7,8)(10,12)(14,16)(17,18)(20,21)(24,25)
  (27,28)(31,32),( 1,9)( 2,11)( 6,13)( 8,14)(10,15)(12,16),
 ( 4,5)( 6,7)( 8,10)(11,12)(13,14)(15,16)(17,19)(20,22)(23,25)(26,28)
  (29,30)(31,32)(33,34),(1,2)(3,5)(6,7),
 ( 1,2)( 4,5)( 8,9)(11,12)(14,15)(17,18)(20,21)(23,24),
 ( 1,2)(11,12)(15,16)(19,20)(23,24)(26,27)(30,31)(33,34),
 ( 1,27)( 2,32)( 9,37)(11,38)(12,39)(14,43)(15,45)(16,46)(18,47)(20,51)
  (21,53)(22,54)(25,57)(26,58)(28,59)(30,60)(31,61)(33,65)(35,69)(36,70)
  (40,73)(41,74)(42,75)(44,76)(48,79)(49,80)(50,81)(52,82)(55,83)(56,84)
  (62,87)(63,88)(64,89)(66,90)(67,91)(68,92)(71,93)(72,94)(77,95)(78,96)
  (85,97)(86,98),( 4,5)( 9,10)(12,13)(16,17)(18,19)(22,23)(24,25)(27,28),
 ( 2,7)( 4,13)( 6,17)(10,23)(14,24)(18,25)(22,26),
 ( 5,6)( 9,10)(13,14)(18,19)(23,24)(33,34)(40,41)(45,46)(50,51)(53,54)
  (57,58)(59,60)(61,62)(63,64)(65,66)(68,69)(70,71)(72,73)(74,75)(76,77)
  (78,79)(81,82)(84,85)(89,90),( 1,3)( 5,7)(18,20)(23,24)(25,27)(28,29)
  (32,33)(34,35)(38,39)(40,42)(43,44)(47,48)(50,51)(53,54),
 ( 2,3)( 6,7)(12,13)(16,17)(19,20)(22,23),
 ( 6,7)(11,12)(15,16)(19,20)(22,23)(24,25)(28,29),
 ( 5,6)(11,12)(15,16)(18,19)(25,26)(27,28)(31,32)(43,44)(52,53)(58,59)
  (61,62)(63,64)(66,67)(68,69)(71,72)(73,74)(76,77)(78,79)(81,82)(83,84)
  (86,87),( 3,5)( 6,8)(11,13)(16,18)(19,21),
 (13,14)(15,16)(18,19)(20,21)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)
  (44,45)(46,47)(49,50)(52,53)(54,55)(57,58),
 ( 3,4)( 7,8)(11,12)(15,16)(27,28)(29,30)(34,35)(36,37)(40,41)(43,44)
  (46,47)(48,49),( 1,13)( 3,17)( 5,20)( 7,21)(10,23)(16,26)(22,28)(25,29),
 ( 5, 8)( 12,13)( 15,17)( 21,24)( 25,26)( 31,33)( 43,44)( 48,49)
  ( 50,51)( 55,56)( 57,58)( 59,60)( 62,63)( 64,65)( 66,67)( 69,70)
  ( 71,72)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)
  ( 97,98)( 99,100)(101,102)(103,104)(105,106),
 ( 1,8)( 3,10)( 4,12)( 5,14)( 6,16),( 1,3)( 5,6)( 8,10)(12,13)(15,17)
  (19,20)(22,23)(24,25)(27,28)(29,30)(31,32)(34,35)(36,37)(39,40)(41,42)
  (43,44)(46,47)(48,49)(51,52)(53,54),( 2,3)( 6,7)(16,17)(20,21)(25,26)
  (28,29)(32,33)(35,36),( 3,5)( 6,7)( 8,9)(10,12)(13,15)(16,17)(18,19)
  (20,21)(22,23),( 4, 6)( 10,11)( 14,15)( 16,18)( 19,21)( 23,25)
  ( 26,28)( 29,31)( 32,33)( 34,35)( 36,38)( 39,41)( 43,45)( 46,47)
  ( 48,50)( 52,53)( 54,56)( 58,60)( 61,63)( 64,66)( 68,69)( 70,71)
  ( 72,73)( 74,75)( 76,77)( 78,79)( 80,81)( 82,83)( 84,85)( 86,87)
  ( 88,89)( 90,91)( 92,94)( 95,96)( 97,98)( 99,100)(101,102)(103,104)
  (105,106)(107,108)(109,110)(111,113)(114,115)(116,117)(118,119)(120,121)
  (122,123)(124,125)(126,128)(129,131)(133,134)(135,136)(138,140)(141,143)
  (145,146)(147,148)(150,152)(153,155)(156,158)(159,160)(161,162)(163,165)
  (166,167)(168,169)(170,172)(173,174)(175,176)(177,179)(180,182)(183,184)
  (185,186)(187,189)(190,191)(192,193)(194,196)(197,198)(199,200)(201,203)
  (204,205)(206,207)(208,210)(211,212)(213,214)(215,217)(218,219)(220,221)
  (222,224)(225,226)(227,228)(229,231)(232,233)(234,235)(236,238)(239,240)
  (241,242)(243,244)(245,246)(247,248)(249,250)(251,252)(253,254)(255,256)
  (257,258)(259,260)(261,262)(263,264)(265,266)(267,268)(269,270)(271,272)
  (273,274)(275,276)(277,278)(279,280)(281,282)(283,284)(285,286)(287,288)
  (289,290)(291,292)(293,294)(295,296)(297,298)(299,300)(301,302)(303,304)
  (305,306)(307,308)(309,310)(311,313)(314,316)(317,319)(320,322)(323,325)
  (326,328)(329,331)(332,334)(335,337)(338,340)(341,343)(344,346)(347,348)
  (349,350)(351,352)(353,354)(355,356)(357,358),
 ( 4, 6)( 10,11)( 14,15)( 16,18)( 19,21)( 23,25)( 26,28)( 29,31)
  ( 32,33)( 34,35)( 36,38)( 39,41)( 42,44)( 45,46)( 47,49)( 51,52)
  ( 53,55)( 57,59)( 60,62)( 63,65)( 67,68)( 69,70)( 72,73)( 74,75)
  ( 76,77)( 78,79)( 80,81)( 82,83)( 84,85)( 86,87)( 88,90)( 91,92)
  ( 93,94)( 95,96)( 97,98)( 99,100)(101,102)(103,104)(105,106)(107,109)
  (110,111)(112,113)(114,115)(116,117)(118,119)(120,121)(122,124)(125,126)
  (127,128)(129,131)(133,134)(135,136)(138,140)(141,143)(145,146)(147,148)
  (150,152)(153,155)(156,157)(158,159)(160,162)(163,164)(165,166)(167,169)
  (170,171)(172,173)(174,176)(177,179)(180,181)(182,183)(184,186)(187,188)
  (189,190)(191,193)(194,195)(196,197)(198,200)(201,203)(204,205)(206,207)
  (208,210)(211,212)(213,214)(215,217)(218,219)(220,221)(222,224)(225,226)
  (227,228)(229,231)(232,233)(234,235)(236,238)(239,240)(241,242)(243,244)
  (245,246)(247,248)(249,250)(251,252)(253,254)(255,256)(257,258)(259,260)
  (261,262)(263,264)(265,266)(267,268)(269,270)(271,272)(273,274)(275,276)
  (277,278)(279,280)(281,282)(283,284)(285,286)(287,288)(289,290)(291,292)
  (293,294)(295,296)(297,298)(299,300)(301,302)(303,304)(305,306)(307,308)
  (309,310)(311,313)(314,316)(317,319)(320,322)(323,325)(326,328)(329,331)
  (332,334)(335,337)(338,340)(341,343)(344,346)(347,348)(349,350)(351,352)
  (353,354)(355,356)(357,358),( 4,9)( 5,11)( 7,12)( 8,14),
 ( 1,3)( 5,6)(10,11)(14,15),( 4,6)(10,11)(15,17)(20,22)(26,28),
 ( 3,5)( 6,7)(10,12)(13,14),( 7, 8)( 11,12)( 13,14)( 18,19)( 20,21)
  ( 23,24)( 26,27)( 30,31)( 48,49)( 50,51)( 53,54)( 55,56)( 58,59)
  ( 60,61)( 74,75)( 77,78)( 79,80)( 83,84)( 86,87)( 89,90)( 91,92)
  ( 95,96)( 97,98)(100,101)(104,105)(107,108)(110,111)(114,115),
 ( 1,6)( 2,14)( 3,21)( 8,24)(11,27)(20,30)(26,32)(29,34),
 ( 1,5)( 2,10)( 6,23)( 8,24)(11,25)(13,26),
 ( 4,7)( 8,11)( 9,12)(10,13)(14,16)(15,17),
 ( 1,4)( 2,12)( 3,19)( 7,24)(11,26)(16,28)(20,30),
 ( 4,12)( 5,16)( 7,17)( 8,21)( 9,22)(11,26),
 ( 7,11)(14,17)(19,22)(23,24)(25,27)(28,29)(30,32),
 ( 3,9)( 6,10)(11,13)(12,14),( 1,2)(11,12)(14,15)(20,21)(24,25)(30,31)
  (33,34)(36,37)(41,42)(45,46),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)
  (34,35)(37,38)(40,41)(43,44),( 1,2)( 5,6)( 9,10)(13,14)(27,28)(29,30)
  (34,35)(36,37)(39,40)(41,42),( 5,20)( 7,21)( 9,22)(10,24)(13,27)(14,28)
  (18,30)(19,33)(23,34)(25,35)(29,36)(31,37),
 ( 5,7)( 9,11)(13,14)(17,19)(21,22),(1,3)(4,5)(6,7),
 ( 6,7)(12,14)(15,17)(19,20)(25,26)(28,30)(31,33)(35,36)(41,42),
 ( 4,7)( 8,11)(12,15)(17,19)(21,24)(25,28)(29,32)(33,36)(38,40)(42,45),
 ( 1,8)( 2,15)( 3,23)( 7,25)(11,27)(16,29)(20,31),
 ( 4,29)( 6,31)( 8,32)( 10,33)( 13,34)( 15,36)( 18,37)( 21,38)
  ( 23,40)( 25,41)( 27,42)( 44,57)( 51,71)( 59,83)( 65,84)( 73,85)
  ( 77,87)( 78,90)( 79,92)( 80,95)( 81,98)( 82,101)( 88,105)( 93,107)
  ( 99,109),( 4,6)( 8,10)(11,13)(16,18)(19,21),
 ( 1,2)( 9,10)(14,15)(22,23)(24,25),( 5,6)( 8,9)(12,13)(15,16)(22,23)
  (25,26)(29,30)(42,43)(51,52)(59,60)(61,62)(64,65)(66,67)(69,70)(71,72)
  (74,75)(76,77)(79,80)(81,82)(84,85)(86,87),( 4,6)( 5,8)(10,12)(11,15),
 ( 6,7)( 8,9)(10,11)(16,17)(18,19)(20,21)(22,23),
 ( 3,4)( 7,8)(12,13)(16,17),( 7,8)(11,12)(14,15)(19,20)(27,28)(31,32)
  (36,37)(54,55)(58,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 3,5)( 7,9)(11,13)(16,18)(21,23),( 1,3)( 5,12)( 7,14),
 ( 2,3)( 4,6)( 8,11)(16,18)(20,23),( 2,4)( 7,9)( 8,11)(10,13)(12,14),
 ( 7,8)( 9,10)(12,13)(15,16)(17,18),( 1,2)( 3,4)( 5,6)( 7,9)(12,14)
  (16,18)(21,23),( 3,4)( 6,7)(11,12)(14,15)(18,19)(24,25)(29,30)(33,34),
 ( 5,9)( 7,10)(11,13)(12,14),( 4,6)( 7,10)(11,14)(16,19)(21,23)(24,26)
  (27,30)(34,37)(41,42)(45,46)(50,51)(60,62)(63,65)(66,68)(69,71)(72,74)
  (75,77),( 2,5)( 6,9)(11,14)(16,19)(20,23),
 ( 2,10)( 4,12)( 7,15)( 9,16)(18,22)(19,28),
 ( 9,10)(12,13)(15,16)(18,19)(22,23)(28,29)(31,32)(34,35)(41,42)(45,46),
 ( 1,5)( 2,12)( 3,19)( 7,23)( 9,25)(16,29)(18,31),
 ( 5,7)( 8,10)(11,13)(16,18)(21,23)(24,26),
 ( 4,7)( 8,12)(17,21)(23,25)(27,29)(30,31)(32,33)(34,35),
 ( 2,8)( 6,9)(10,12)(11,14),( 7,8)(12,13)(14,15)(18,19)(22,23),
 ( 5,6)(10,11)(14,15)(17,18)(20,21)(25,26)(30,31)(34,35)(44,45)(48,49)
  (52,53)(56,57),( 4,5)( 7,8)(14,15)(17,18)(21,22)(24,25)(28,29)(31,32),
 ( 1,8)( 3,10)( 7,14)( 9,17)(13,18),( 4,38)( 7,39)(11,40)(13,42)(17,43)
  (19,44)(23,45)(28,46)(31,47)(33,48)(36,50)(52,60)(53,63)(54,66)(56,69)
  (57,72)(58,75)(61,77)(67,79)(73,81),( 1,9)( 3,12)( 6,15)( 8,18)(11,21)
  (16,23),( 1,3)( 6,8)(11,12)(15,17)(19,21),
 ( 1,19)( 2,23)( 3,28)( 4,31)( 9,40)(10,41)(11,42)(12,43)(13,44)(16,46)
  (17,47)(20,49)(22,51)(24,52)(27,54)(29,55)(32,57)(34,59)(45,63)(48,64)
  (50,65)(53,66)(56,67)(58,68),( 6,7)(11,12)(20,21)(22,23)(25,26)(28,29)
  (31,32)(34,35),( 7,10)(13,14)(15,16)(19,22)(23,24),
 ( 5,6)(12,13)(19,20)(23,24)(25,26)(29,30)(31,32),( 1,7)( 3,11)( 5,13),
 ( 8,27)( 11,28)( 23,29)( 26,30)( 32,50)( 34,51)( 35,54)( 36,55)
  ( 37,56)( 38,59)( 39,60)( 40,63)( 44,64)( 45,67)( 46,68)( 47,69)
  ( 48,72)( 49,74)( 52,83)( 53,84)( 61,85)( 62,86)( 70,87)( 71,88)
  ( 77,91)( 79,96)( 80,100)( 82,103)( 90,109)( 93,110)( 95,111)( 99,112)
  (102,113)(115,118)(117,119),( 2,4)( 6,8)(10,12)(24,25)(26,28)(29,30)
  (33,34)(35,37)(38,39)(40,41)(42,44)(45,46),
 ( 3,9)( 5,11)( 7,13)( 8,16)(14,17)(15,18),
 ( 1,11)( 3,13)( 5,14)( 8,17)(18,24)(19,29),
 ( 2,3)( 8,9)(13,14)(19,20)(24,25),( 2,9)( 7,12)( 8,15)(10,16)(11,17)
  (13,18)(14,19),( 6,8)(11,13)(15,16)(21,22)(26,28)(30,31)(39,41)(44,45)
  (49,51)(54,55)(58,60)(63,65)(68,70)(74,76)(79,81)(84,86),
 ( 4,5)( 8,9)(14,15)(17,18)(23,24),( 4,5)( 6,8)( 9,10)(11,12),
 ( 2,3)( 7,8)(12,13)(16,17)(19,20)(22,23),
 ( 4,35)( 10,36)( 13,37)( 19,38)( 22,39)( 24,40)( 29,41)( 32,42)
  ( 43,56)( 45,59)( 47,61)( 50,62)( 52,65)( 53,66)( 55,69)( 60,80)
  ( 64,81)( 72,82)( 73,84)( 74,86)( 77,88)( 78,90)( 79,92)( 83,95)
  ( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 94,106)( 98,107)(102,108),
 (1,4)(2,5)(3,6),( 2,6)( 5,7)( 8,11)( 9,14),
 ( 1,3)(10,11)(12,13)(14,15)(16,17)(18,19)(24,25)(28,29),
 ( 4,34)( 11,35)( 14,36)( 20,37)( 23,38)( 25,39)( 28,40)( 31,41)
  ( 42,53)( 44,56)( 46,59)( 48,61)( 49,63)( 51,66)( 58,78)( 68,79)
  ( 69,81)( 70,83)( 72,86)( 73,88)( 74,90)( 75,92)( 77,95)( 80,98)
  ( 82,101)( 84,104)( 85,106)( 89,108)( 91,111)( 93,114)( 94,116)( 97,117)
  (103,118)(110,119),( 1,2)( 4,6)( 8,9)(11,13)(15,17)(20,21)(22,23)
  (25,26)(27,28)(29,30)(32,33)(34,35)(37,38)(39,40)(41,42)(44,45)(46,47)
  (49,50)(51,52)(53,54),( 6,7)( 9,10)(13,14)(16,17)(21,22)(25,26),
 ( 7,33)( 10,34)( 24,35)( 26,36)( 28,37)( 31,38)( 39,46)( 40,48)
  ( 41,51)( 42,53)( 43,56)( 44,58)( 45,61)( 55,72)( 62,74)( 63,77)
  ( 64,80)( 65,81)( 66,83)( 67,86)( 68,89)( 69,92)( 70,93)( 71,95)
  ( 73,98)( 75,99)( 76,101)( 78,102)( 79,103)( 82,105)( 84,106)( 85,108)
  ( 87,109)( 88,111)( 90,112)( 91,113)( 94,115)( 96,116)( 97,117)(104,118)
  (110,119),( 5,6)(10,11)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35),
 ( 7,9)(12,13)(17,19)(22,24)(27,29)(32,34)(37,39)(43,44)(47,49)(53,54),
 ( 2,6)( 7,12)(13,17)(18,23)(24,29),( 3,4)( 7,9)(12,13)(16,18)(21,23),
 ( 6,7)( 9,10)(13,14)(17,18)(22,23)(26,27)(30,31),
 ( 1,18)( 3,19)( 5,20)( 6,22)( 8,23)(10,25)(11,26)(12,27)(14,29)(16,30),
 ( 4,8)( 9,11)(13,17)(19,21)(22,26),( 1,2)(12,13)(17,18)(23,25)(28,30)
  (31,33)(36,38)(39,41),( 3,5)( 8,10)(12,14)(16,18)(21,23),
 ( 3,4)( 8,9)(12,13)(17,18),( 2,9)( 4,12)( 5,15)( 8,18)(13,20)(17,23),
 ( 3,15)( 7,16)( 8,19)( 9,20)(13,23)(14,24),
 ( 5,15)( 6,17)( 7,18)(10,20)(11,21)(12,23),
 ( 4,6)( 8,9)(11,13)(15,17)(19,21)(23,25)(26,28)(30,31)(33,35)(36,38)
  (40,42)(44,46)(48,50)(52,53)(55,57),( 1,7)( 2,11)( 3,17)( 4,24)(12,26)
  (15,28)(23,30),( 3,17)( 6,19)( 7,20)(10,22)(13,23)(14,25),
 ( 1,7)( 3,9)( 4,11)( 5,13)( 6,15),( 3,8)( 7,9)(10,12)(11,14),
 ( 1,4)(10,24)(11,27)(14,36)(15,39)(17,40)(18,41)(25,44)(26,45)(33,48)
  (34,49),( 1,4)( 6,9)( 7,11),( 8,9)(12,13)(14,15)(19,20)(21,22)(25,26)
  (28,29)(36,37)(45,46)(52,53)(57,58)(59,60)(62,63)(64,65)(67,68)(69,70)
  (74,75)(76,77)(79,80)(81,82)(84,85),( 5,10)( 6,13)( 7,15)( 8,16)( 9,19)
  (20,23)(21,27),( 1,9)( 2,11)( 5,13)( 7,14)(10,15)(12,16),
 ( 2,3)( 8,9)(12,13)(17,18)(21,22)(25,26),
 ( 5, 6)( 10,11)( 14,15)( 18,19)( 22,23)( 27,28)( 31,32)( 35,36)
  ( 40,41)( 43,44)( 49,50)( 57,58)( 59,60)( 65,66)( 71,72)( 73,74)
  ( 86,87)( 88,90)( 92,93)( 94,96)( 97,98)( 99,101)(105,106)(107,108)
  (109,110),( 1,2)( 5,6)(11,12)(16,17)(20,21)(24,25),
 ( 1,5)( 6,10)(14,18)(19,23)(27,28)(33,34),
 ( 4,5)( 9,10)(13,14)(18,19)(22,23)(26,27),( 4,6)(11,12)(13,14)(15,16),
 ( 2,3)( 5,6)(10,11)(16,17)(20,21)(24,25),( 1,2)( 3,12)( 5,13),
 ( 3,7)( 4,9)( 5,11)(12,17)(13,19)(14,21)(15,23),
 ( 4,7)( 8,10)(11,14)(16,18)(19,22),( 2,9)( 3,12)( 5,15)( 8,18)(14,21)
  (19,23),( 7,8)(11,13)(16,18)(22,24)(27,28)(31,33)(37,39)(42,44)(47,48)
  (52,54),( 4,5)( 6,7)( 9,10)(11,12)(14,15)(16,17)(19,20)(21,22)(24,25)
  (26,27)(28,29)(30,31),(1,4)(5,8)(6,9),
 ( 7,8)(11,13)(16,17)(20,22)(25,26)(29,31)(34,35)(38,40)(43,44)(47,49),
 ( 4,6)( 8,10)(12,13)(18,19)(22,24)(27,28)(34,35)(39,40)(43,44)(48,49)
  (52,53)(57,58)(61,63)(64,66)(67,69)(70,72)(73,75)(76,78),
 ( 2,3)( 4,5)( 7,8)(11,12)(14,15)(40,41)(43,44)(46,47),
 ( 4,7)( 8,10)(12,15)(16,18)(21,23)(25,27),
 ( 1,10)( 3,12)( 5,14)( 8,17)(18,25)(19,31),
 ( 2,3)( 4,5)( 9,10)(11,12)(13,14),( 6,7)(10,11)(14,15)(19,20)(24,25),
 ( 2,24)( 3,25)( 5,26)( 7,27)( 8,30)(10,31)(12,32)(13,33)(15,34)(17,37)
  (19,38)(21,39)(23,42)(28,43)(29,44)(35,45)(36,46)(40,47)(41,48),
 ( 1,11)( 3,15)( 4,17)( 6,20)( 8,21)(10,22)(12,23)(14,24)(16,25)(19,26),
 ( 3,9)( 5,10)(11,13)(12,14),( 4,7)(10,11)(12,13),
 ( 3,4)( 8,9)(13,14)(21,22)(28,29)(36,37)(43,44),
 ( 3,17)( 4,18)( 8,21)( 9,22)(10,25)(14,26),
 ( 4,7)( 8,11)(13,15)(17,20)(21,24)(25,28)(29,32)(34,36)(38,41)(42,45),
 ( 5,6)( 7,8)(11,12)(16,17)(20,21),( 4,6)( 8,10)(12,14)(16,18)(20,21)
  (23,25)(26,28)(30,31)(33,35)(37,39)(41,43)(45,47)(48,50)(52,53)(55,57),
 ( 4,6)( 8,10)(13,15),( 4,33)( 7,34)(16,35)(21,36)(24,37)(28,38)(31,39)
  (41,58)(42,62)(43,63)(46,67)(47,68)(48,72)(50,73)(51,77)(52,78)(55,82)
  (56,83)(57,87)(59,88)(61,89)(69,90)(71,91)(79,92)(81,93),
 ( 1,2)( 3,4)( 5,6)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)
  (28,29)(31,32)(34,35)(39,40)(42,43)(48,49)(51,52)(57,58)(60,61),
 ( 3,4)( 8,9)(15,17)(20,22)(25,27),( 5,6)( 8,10)(13,15)(18,20)(21,23)
  (24,26)(28,29)(32,33)(36,37),( 5,19)( 6,22)( 7,25)( 9,28)(10,31)(12,34)
  (13,37)(14,40)(16,43)(17,46),( 1,9)( 4,11)( 5,12)( 8,14),
 ( 2,7)( 4,9)( 6,12),( 9,30)(11,31)(14,32)(16,34)(18,35)(20,36)(22,39)
  (24,40)(27,41)(43,55)(44,57)(47,59)(48,62)(49,63)(50,67)(53,68)(54,70)
  (60,73)(66,74)(71,75)(72,80)(76,83)(78,84)(79,85)(82,86)(87,89)(88,90),
 ( 5,7)(10,12)(15,17)(20,22)(26,27)(30,32)(36,37)(41,43)(46,47)(51,53),
 ( 2,4)( 7,9)(12,13)(16,18)(21,23)(26,27),
 ( 2,9)( 4,11)( 5,15)( 8,17)(14,20)(18,23),( 2,7)( 3,8)( 9,13)(11,14),
 ( 4,7)( 8,9)(10,12),( 3,10)( 5,13)( 7,14)( 9,15)(12,16),
 ( 4,7)( 9,11)(12,14)(15,18)(19,20),( 4,37)( 7,38)(11,39)(13,41)(18,42)
  (21,43)(24,45)(27,46)(30,47)(32,48)(35,50)(51,63)(53,66)(55,69)(56,72)
  (58,75)(60,78)(61,79)(67,80)(73,81),( 1,5)( 2,14)( 3,19)( 7,23)(13,26)
  (16,29)(22,32)(25,35),( 9,11)(12,14)(16,17)(19,20)(21,22)(23,24),
 ( 2,3)( 7,8)( 9,10)(13,14),( 4,14)( 7,17)( 8,18)( 9,21)(12,22)(13,25),
 ( 14,29)( 19,30)( 22,31)( 23,32)( 26,33)( 34,48)( 36,51)( 38,54)
  ( 39,56)( 41,57)( 42,58)( 43,60)( 45,63)( 46,65)( 53,78)( 55,79)
  ( 66,80)( 67,81)( 68,83)( 69,85)( 71,88)( 72,90)( 73,91)( 74,93)
  ( 75,95)( 77,98)( 82,101)( 84,104)( 86,107)( 87,109)( 89,110)( 92,112)
  ( 94,115)( 96,118)( 97,120)( 99,121)(100,122)(102,123)(106,124)(108,125)
  (114,126)(116,127),( 2,3)( 5,6)( 8,9)(10,11)(12,13)(14,15)(16,17)
  (18,19),( 6,8)(11,13)(16,17)(21,23)(27,28)(31,33)(36,38)(42,44)(47,48)
  (51,53),( 1,4)( 9,12)(13,15)(17,20)(21,23),
 ( 1,2)( 5,6)( 9,10)(19,20)(25,26)(28,29)(31,32)(34,35),
 ( 3,4)( 7,8)(12,13)(17,18)(22,23)(27,28)(32,33)(39,40)(43,44)(48,49)
  (52,53)(57,58)(61,62),( 9,10)(12,13)(15,16)(18,19)(21,22)(23,24)(27,28)
  (29,30),( 4,6)( 9,11)(14,15)(19,21)(25,26)(29,31)(34,36)(40,42)(45,46)
  (49,51),( 1,7)( 3,15)( 5,19)( 8,23)(13,26)(16,27)(21,28)(24,29),
 ( 2,3)(11,12)(13,14)(16,17)(18,19)(21,22)(23,24),( 1,3)( 5,11)( 9,13),
 ( 5,6)( 9,10)(15,16)(19,20)(23,24)(26,27)(29,30),
 ( 4,5)( 8,9)(13,14)(17,18)(21,22)(26,27)(30,31),
 ( 7,38)(10,39)(13,41)(17,42)(20,43)(22,44)(23,46)(28,47)(30,48)(33,49)
  (36,51)(52,61)(53,64)(55,67)(56,70)(57,73)(59,76)(62,78)(68,79)(74,80),
 ( 1,16)( 2,19)( 3,24)( 4,28)( 9,40)(10,41)(11,42)(12,43)(13,44)(15,46)
  (18,48)(20,49)(23,51)(25,52)(27,54)(30,56)(31,57)(34,59)(45,63)(47,64)
  (50,65)(53,66)(55,67)(58,68),( 1,8)( 2,19)( 3,23)( 6,25)( 9,27)(14,29)
  (17,31),(13,14)(16,18)(23,25)(26,28)(33,34)(35,36)(37,39)(40,41)(45,47)
  (48,49)(54,55)(57,58)(60,61)(63,64)(66,67)(69,70)(71,72)(73,74)(75,76),
 ( 5,6)(11,12)(17,18)(22,23)(28,29),( 6,7)(11,12)(15,16)(20,21)(24,25),
 ( 5,9)(11,14)(16,19)(20,24)(26,30)(31,34)(36,39)(41,45)(47,50)(51,54),
 ( 4,8)( 6,9)(10,12)(11,14),( 5,6)( 9,10)(14,15)(17,18)(22,23),
 ( 1,3)( 4,12)( 6,14),( 4,30)( 7,31)( 9,32)( 11,33)( 15,34)
  ( 18,35)( 24,36)( 27,37)( 39,55)( 40,56)( 43,61)( 45,64)( 47,65)
  ( 51,70)( 52,71)( 63,84)( 69,85)( 75,86)( 77,89)( 78,92)( 80,95)
  ( 82,98)( 83,101)( 88,106)( 91,109)( 94,112)( 97,115)(100,118)(103,121)
  (105,122)(111,123)(117,124),( 4,6)( 8,9)(11,13)(16,17)(19,21),
 ( 5,6)( 8,9)(13,14)(18,19)(23,24)(28,29)(33,34)(38,39)(43,44)(47,48)
  (52,53)(56,57)(61,62),( 2,3)( 5,6)( 7,8)(10,11)(12,13)(15,16)(18,19)
  (21,22)(24,25)(27,28),( 5, 6)( 8, 9)( 16,17)( 18,19)( 32,33)
  ( 42,43)( 47,48)( 50,51)( 52,53)( 54,55)( 57,58)( 60,61)( 62,63)
  ( 64,65)( 66,67)( 69,70)( 71,72)( 73,74)( 75,76)( 79,80)( 81,82)
  ( 84,85)( 96,97)(100,101)(103,104)(106,107)(110,111)(113,114)(115,116)
  (120,121)(125,126)(130,131)(134,135)(136,137),
 ( 8,9)(13,14)(17,18)(21,22)(25,26)(29,30)(33,34)(36,37)(40,41)(43,44)
  (46,47)(50,51)(55,56)(60,61)(65,66)(68,69),
 ( 2,4)( 8,10)(13,14)(16,18)(21,22),( 5,7)(12,13)(20,21)(23,25)(26,28)
  (29,30)(31,32)(33,34),(2,4)(3,8)(5,9),
 ( 6,10)(14,17)(18,21)(22,23)(24,25)(28,30)(31,32)(33,34)(37,39)(40,41)
  (42,43)(47,48)(50,51)(53,54),( 4,5)(10,12)(15,17)(22,23)(26,27)(28,29)
  (32,33),( 1,20)( 2,22)( 3,24)( 4,25)( 5,26)( 6,28)( 7,30)( 8,31)( 9,32)
  (18,33)(19,34),( 1,5)( 3,11)( 7,13),( 4,5)( 8,9)(14,16)(20,21)(24,25)
  (30,31)(35,36)(44,45)(51,52),( 7,34)( 10,35)( 15,36)( 19,37)
  ( 23,38)( 27,39)( 30,40)( 33,41)( 42,59)( 44,60)( 47,63)( 48,64)
  ( 51,66)( 55,69)( 56,70)( 61,80)( 65,81)( 73,83)( 74,85)( 75,87)
  ( 77,89)( 78,91)( 79,93)( 82,94)( 84,96)( 86,98)( 88,100)( 90,102)
  ( 92,104)( 97,106)(101,107)(105,108),( 4,5)(13,14)(18,19)(23,24)(26,27)
  (29,30)(32,33)(35,36),( 5,13)( 6,17)( 7,18)(10,22)(11,23)(12,27),
 ( 6,7)(11,13)(16,17)(19,21)(23,24)(25,26)(28,30)(36,37)(38,40)(44,45)
  (46,48),( 4,5)( 7,8)( 9,10)(12,13)(15,16)(18,19)(20,21)(23,24)(26,27)
  (29,30)(31,32)(34,35)(36,37)(39,40)(42,43)(45,46)(47,48)(50,51)(53,54)
  (56,57),( 2,6)( 3,9)( 5,10),( 1,2)( 3,11)( 6,12),
 ( 1,4)( 9,12)(13,15)(16,18)(19,21),( 1,8)( 3,16)( 5,20)( 9,23)(14,26)
  (17,27)(21,28)(24,29),( 2,3)(12,13)(15,16)(18,19)(22,23)(24,25)(26,27)
  (28,29)(30,31)(32,33),( 1,2)(12,13)(16,17)(20,21)(24,25)(26,27)(30,31)
  (35,36)(37,38)(43,44)(45,46)(48,49),( 3,4)( 7,9)(12,14)(17,18)(21,23)
  (26,28),( 6,7)(10,11)(13,14)(19,20)(25,26)(29,30)(34,35)(53,54)(58,59)
  (61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 4,18)( 5,19)( 6,21)( 7,22)( 8,24)( 9,25)(10,26)(11,28)(12,29)(13,30)
  (14,31)(15,33)(16,34)(35,40)(36,42)(37,43)(38,45)(39,47)(48,51)(49,52)
  (50,53),( 2,6)( 7,12)(13,18)(19,23)(24,29),
 ( 3,7)(10,13)(14,15)(16,17),( 2,5)( 7,10)(12,14)(16,18)(20,23),
 ( 1,2)( 4,5)( 6,7)( 8,9)(10,11)(13,14)(15,16)(17,18)(19,20)(22,23),
 ( 8,9)(14,15)(18,19)(23,24)(28,29)(32,33)(38,39)(42,43)(47,48)(52,53),
 ( 1,2)(10,12)(13,15),( 1,22)( 2,25)( 3,30)( 4,34)( 9,40)(10,41)(11,42)
  (12,43)(14,44)(15,45)(18,47)(19,48)(21,50)(24,52)(26,53)(29,55)(31,56)
  (33,58)(46,63)(49,64)(51,65)(54,66)(57,67)(59,68),
 ( 4,21)( 5,24)( 7,25)(10,26)(11,27)(14,30)(15,31)(17,32)(19,33)(23,34)
  (29,35),( 2,7)( 3,8)( 4,9)( 5,11),( 9,12)(14,16)(18,20)(22,24)(27,29)
  (31,34)(36,38)(40,42)(44,46)(49,51),( 7,22)( 10,23)( 16,24)( 21,25)
  ( 26,39)( 28,44)( 29,48)( 30,50)( 31,54)( 34,58)( 35,59)( 36,63)
  ( 37,67)( 41,82)( 45,83)( 51,84)( 55,85)( 61,86)( 64,87)( 70,89)
  ( 71,91)( 72,93)( 73,95)( 74,97)( 75,100)( 76,102)( 77,104)( 78,108)
  ( 79,110)( 80,112)( 81,115)( 90,125)( 94,128)( 99,130)(103,133)(109,135)
  (114,138)(117,140)(119,144)(121,148)(123,152),
 ( 7,11)(12,15)(16,21)(22,25)(26,30)(31,35)(36,39)(40,45)(46,49)(50,54),
 ( 4,5)( 9,10)(14,15)(17,18)(22,23)(29,30),
 (13,14)(15,16)(17,18)(19,20)(22,23)(24,25)(26,27)(28,29)(30,31)(32,33)
  (34,35)(41,42)(44,45),(13,14)(15,16)(17,18)(19,20)(21,22)(24,25)(26,27)
  (29,30)(31,32)(33,34)(45,46)(48,49)(50,51)(53,54)(56,57)(58,59),
 (13,14)(15,16)(17,18)(19,20)(21,22)(23,24)(26,27)(28,29)(31,32)(33,34)
  (45,46)(48,49)(50,51)(53,54)(56,57)(58,59),
 ( 3,5)( 8,9)(12,14)(17,19)(22,23),( 4,14)( 5,17)( 6,18)( 9,21)(10,22)
  (11,25),( 5,7)(10,12)(15,17)(20,22)(25,27)(31,32)(35,37)(41,42)(46,48)
  (51,52),( 9,11)(12,14)(16,17)(18,19)(21,22)(23,24),
 ( 2,6)( 5,8)(13,16)(15,17)(18,20)(19,21),
 ( 7, 8)( 12,13)( 15,16)( 19,20)( 27,28)( 35,36)( 37,38)( 39,40)
  ( 44,45)( 46,47)( 48,49)( 50,51)( 53,54)( 58,59)( 60,61)( 62,63)
  ( 70,71)( 76,77)( 81,82)( 83,84)( 85,86)( 87,88)( 91,92)( 93,94)
  ( 95,96)( 97,98)(100,101)(103,104)(106,107)(111,112)(114,115)(117,118),
 ( 1,6)( 3,10)( 7,12),( 4,6)( 8,9)(11,12)(15,16)(17,18),
 ( 4,24)( 7,25)( 9,26)( 12,27)( 20,28)( 29,50)( 30,53)( 31,56)
  ( 34,59)( 36,63)( 37,66)( 38,67)( 40,70)( 41,73)( 43,74)( 44,77)
  ( 46,80)( 47,83)( 48,84)( 57,92)( 58,93)( 62,94)( 71,95)( 72,96)
  ( 81,97)( 82,98)(107,122)(115,129)(120,132)(125,133)(128,134),
 ( 4,24)( 12,25)( 16,26)( 19,27)( 21,28)( 29,51)( 30,53)( 32,54)
  ( 33,57)( 34,58)( 37,61)( 39,63)( 40,66)( 42,67)( 43,70)( 44,72)
  ( 47,76)( 49,79)( 55,88)( 56,89)( 64,90)( 65,91)( 73,92)( 75,93)
  ( 83,101)( 86,111)( 95,119)(100,123)(104,124)(107,128)(110,129)(114,133),
 ( 1,12)( 3,16)( 5,22)( 7,23)(11,24)(15,25)(19,26),
 ( 4,10)( 7,11)( 8,12)( 9,15)(13,16)(14,17),
 ( 6,8)(12,13)(17,19)(22,23)(27,29)(32,34)(37,39)(42,44)(47,49)(53,54),
 ( 1,8)( 2,12)( 3,16)( 4,20),( 4,20)( 7,21)( 8,22)(10,26)(12,27)(14,28)
  (15,29)(16,32)(19,33)(25,34)(31,36),( 1,13)( 2,18)( 3,23)( 4,27)( 5,30)
  ( 6,33)( 7,37)( 8,40)(10,41)(11,42)(14,45)(16,46)(19,50)(22,51)(24,52)
  (26,53)(29,56)(31,57)(35,61)(38,62)(43,63)(49,64)(54,65)(60,66),
 ( 5,6)(10,11)(16,17)(21,22)(26,27)(30,31)(43,44)(46,47)(52,53)(57,58)
  (62,63)(69,70)(73,74)(77,78)(82,83)(85,86)(88,89)(91,92)(94,95)(97,98),
 ( 5,11)( 6,14)( 7,15)( 8,17)(10,20)(21,25)(22,28),
 ( 2,3)(10,11)(13,14)(16,17)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32),
 ( 4,5)( 9,11)(14,15)(19,21)(24,26)(29,31)(34,36)(39,41)(45,46)(49,51),
 ( 5,11)( 6,14)( 8,15)( 9,17)(10,20)(23,27)(24,29)(25,31),
 ( 4,5)( 7,8)( 9,10)(16,17)(23,24)(25,26),
 ( 1,4)( 5,11)( 6,12)( 7,14)( 8,16)(13,19)(15,20)(17,21)(18,22),
 ( 4,7)( 5,8)( 9,14)(15,17)(16,18),( 1,2)( 3,4)( 6,7)( 9,10)(12,13)
  (17,18)(21,22)(25,26),( 4,20)( 6,21)( 7,22)(10,25)(12,27)(14,28)(15,29)
  (17,32)(19,34)(23,35)(30,36),( 2,24)( 3,25)( 5,28)( 7,29)( 9,30)(11,32)
  (13,33)(15,34)(16,35)(18,36)(20,39)(21,40)(23,41)(26,42)(27,43)(31,45)
  (37,47)(38,48)(44,50)(46,51)(49,52),( 4,20)( 6,21)( 7,23)( 9,26)(11,27)
  (12,28)(14,30)(16,33)(19,34)(25,35)(32,36),
 ( 1,2)( 6,7)(11,12)(14,15)(17,18)(20,21),(2,3)(4,6),
 ( 4,7)( 8,11)(13,15)(16,20)(21,23),( 5,6)( 7,8)(11,12)(15,16)(19,20),
 ( 4,33)( 7,34)(10,35)(15,36)(25,37)(28,38)(30,39)(40,58)(42,61)(43,63)
  (44,66)(47,68)(48,71)(49,73)(51,76)(52,78)(53,81)(56,83)(57,86)(64,88)
  (65,89)(74,90)(75,91)(84,92)(85,93),( 9,10)( 12,13)( 15,16)( 19,20)
  ( 23,24)( 26,27)( 37,38)( 41,42)( 48,49)( 50,51)( 53,54)( 55,56)
  ( 57,58)( 60,61)( 62,63)( 65,66)( 71,72)( 77,78)( 84,85)( 87,88)
  ( 90,91)( 93,94)( 96,97)( 99,100)(102,103)(104,105)(106,107)(108,109)
  (110,111)(112,113),( 1,2)( 6,7)(11,12)(15,16)(18,19)(21,22),
 (10,11)(14,15)(18,19)(22,23)(24,25)(26,27)(29,30)(31,32)(36,37)(38,39),
 (2,5)(3,7)(4,8),( 1,8)( 2,11)( 3,14)( 4,17)( 5,20)( 6,23),
 ( 1,2)( 3,5)( 6,8)(10,12)(13,15),(10,11)(14,15)(18,19)(23,24)(28,29)
  (32,33)(36,37)(40,41)(45,46)(50,51),( 1,3)( 5,8)(10,12)(13,15),
 ( 1,2)( 3,4)( 5,6)( 7,8)(12,13)(15,16)(21,22),
 ( 4,12)( 5,14)( 7,15)( 8,17)( 9,18)(11,20),
 ( 7,10)(13,14)(17,18)(21,24)(26,28)(34,35)(36,38)(40,41)(43,44)(45,47)
  (49,50)(56,58)(61,63)(66,68)(73,75)(78,80)(83,85),
 ( 4,20)( 5,23)( 7,25)( 9,26)(10,27)(13,30)(14,32)(16,33)(18,34)(22,35)
  (29,36),( 4,6)( 8,10)(11,13)(15,17)(21,23)(25,27),
 ( 4, 5)( 9,10)( 13,14)( 17,18)( 21,22)( 26,27)( 30,31)( 35,36)
  ( 39,40)( 46,47)( 52,53)( 55,56)( 57,58)( 63,64)( 69,70)( 71,72)
  ( 87,89)( 90,91)( 92,94)( 95,96)( 98,100)(101,102)(105,106)(107,108)
  (109,110),( 1,24)( 4,25)( 6,26)( 9,29)(11,30)(14,31)(18,32)(19,35)(22,36)
  (27,37)(33,38),( 1,7)(10,14)(11,19)(16,30)(20,32)(25,37)(26,40)(27,46)
  (28,49)(33,53)(36,56)(38,59)(42,62)(45,65)(47,68)(55,70)(61,72)(67,74),
 ( 8,10)( 11,12)( 15,16)( 19,21)( 26,28)( 36,38)( 40,41)( 45,46)
  ( 47,48)( 51,52)( 58,59)( 63,64)( 68,69)( 70,72)( 74,75)( 76,78)
  ( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101),
 ( 2,3)( 7,8)( 9,10)(13,14)(16,17),( 4,6)( 8,10)(11,12)(17,18)(22,23)
  (26,27)(30,31)(33,34),( 5,7)(10,12)(16,18)(21,22)(25,27)(31,33)(36,38)
  (41,42)(46,48)(52,53),( 6,14)( 7,16)( 8,17)(11,19)(12,20)(13,22),
 ( 4,19)( 7,20)(11,22)(12,24)(14,26)(15,28)(17,30)(18,32)(21,33)(23,34)
  (25,35)(27,36)(29,37)(31,38),( 9,10)(11,12)(14,15)(16,17),
 ( 1,2)( 6,7)( 9,10)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 9,29)( 12,30)( 13,31)( 16,32)( 21,33)( 35,48)( 36,50)
  ( 38,53)( 39,55)( 40,56)( 42,57)( 43,59)( 45,62)( 47,65)( 58,78)
  ( 60,79)( 66,81)( 68,84)( 69,86)( 70,88)( 71,89)( 72,91)( 74,94)
  ( 75,96)( 76,98)( 77,99)( 80,100)( 82,101)( 83,103)( 85,106)( 87,109)
  ( 90,111)( 92,112)( 93,114)( 95,117)( 97,120)(105,122)(107,123)(113,124)
  (115,125)(119,126)(121,127),( 2,4)( 6,10)( 7,11)( 8,12),
 ( 1,8)( 2,10)( 3,12)( 4,13)( 5,15)( 7,17),
 ( 1,2)( 3,4)( 5,6)( 7,9)(10,12)(16,18)(22,24)(25,27),
 ( 2,5)( 6,10)( 8,11),( 4,5)( 7,8)(10,11)(13,14)(24,25)(26,27)(30,31)
  (32,33),( 1,8)( 2,10)( 3,11)( 4,13)( 6,15)( 7,16),
 ( 5,6)(10,11)(15,16)(18,19)(23,24)(30,31),
 ( 4,5)( 9,10)(13,14)(15,16)(19,20),( 2,24)( 5,25)( 7,26)(10,27)(12,30)
  (15,31)(16,32)(20,33)(23,36)(29,37)(35,38),
 ( 5,9)(10,13)(15,19)(20,24)(26,29)(30,34)(36,39)(41,44)(46,49)(51,54),
 ( 3,6)( 8,10)(11,13)(15,18)(19,21)(22,24)(26,28)(31,33),
 ( 1,14)( 2,18)( 3,23)( 4,27)( 5,32)( 6,36)( 7,41)( 8,45)( 9,50)(10,54),
 ( 5,6)( 9,11)(13,14)(16,17)(20,22)(24,25),
 ( 7,9)(11,14)(16,19)(22,24)(27,29)(31,33)(35,38)(40,43)(46,48)(51,53),
 ( 1,8)( 4,11)( 7,12),( 1,2)( 9,10)(13,14)(18,19)(21,22)(24,25),
 ( 8,9)(13,14)(16,17)(19,20)(23,24)(27,28)(31,32)(34,35)(37,38)(42,43)
  (46,47)(48,49),( 9,32)(11,33)(13,34)(15,37)(17,38)(20,39)(22,41)(25,42)
  (27,43)(30,44)(45,59)(48,60)(49,63)(50,64)(51,66)(54,67)(55,68)(56,70)
  (57,71)(73,75)(74,77),( 1,2)( 3,4)( 5,6)( 7,8)(11,13)(17,19)(22,23)
  (25,26),( 3,4)(11,12)(16,17)(21,22)(26,27)(32,33)(40,41),
 ( 1,22)( 2,23)( 4,26)( 6,29)( 7,30)( 8,31)(11,35)(12,36)(13,37)(15,38)
  (17,41)(18,44)(20,45)(25,46)(27,48)(32,49)(33,51)(40,52)(42,54),
 ( 1,9)( 2,11)( 4,13)( 8,14)(10,15)(12,16),
 ( 4,6)( 8,9)(11,13)(16,18)(19,21)(25,26)(31,32),
 ( 2,10)( 4,11)( 6,12)( 8,15)(13,18)(14,19),
 ( 3,4)( 8,9)(14,15)(20,21)(25,26),( 6,39)( 9,40)(12,41)(17,42)(20,44)
  (22,45)(23,46)(26,47)(29,49)(32,50)(35,51)(52,60)(53,63)(55,66)(56,69)
  (57,72)(59,75)(62,78)(68,79)(74,80),( 4,14)( 5,16)( 6,17)( 9,19)(10,20)
  (11,22),( 4,5)( 7,8)(10,11)(13,14)(16,17)(19,20)(21,22)(24,25)(26,27)
  (29,30)(31,32)(34,35)(37,38)(40,41)(43,44)(46,47)(48,49)(51,52)(53,54)
  (56,57),( 4,14)( 5,17)( 7,18)( 9,21)(10,22)(12,25),
 ( 8, 9)( 11,12)( 15,16)( 17,18)( 22,23)( 24,25)( 27,28)( 30,31)
  ( 48,49)( 50,51)( 53,54)( 55,56)( 58,59)( 60,61)( 74,75)( 77,78)
  ( 79,80)( 83,84)( 86,87)( 89,90)( 91,92)( 95,96)( 97,98)(100,101)
  (104,105)(107,108)(110,111)(114,115),( 1,2)( 8,11)(12,15)(20,23)(24,27),
 ( 2,9)( 4,11)( 5,12)( 8,14),( 4,6)( 8,9)(11,12),
 ( 5,35)( 7,38)( 9,40)(11,42)(13,45)(15,47)(17,50)(19,52)(21,54)(23,57)
  (25,59)(27,62)(29,64)(31,66)(33,69),( 2,5)( 7,10)(11,14)(16,19),
 ( 4,8)( 9,13)(15,18)(19,23)(25,28)(30,33)(35,38)(40,43)(45,49)(50,53),
 ( 5, 8)( 11,12)( 14,16)( 19,22)( 27,29)( 39,41)( 42,44)( 45,46)
  ( 47,49)( 51,52)( 53,55)( 56,57)( 59,61)( 62,63)( 65,66)( 68,70)
  ( 71,72)( 76,78)( 81,83)( 86,88)( 89,91)( 92,94)( 95,97)( 98,100)
  (101,103)(104,105)(107,108)(110,111)(113,114)(116,117)(119,120),
 ( 6,8)(11,13)(16,18)(22,23)(26,28)(32,33)(37,39)(42,43)(47,49)(52,54),
 ( 7,9)(12,14)(17,19)(22,24)(27,29)(33,34)(37,39)(43,44)(48,50)(53,54),
 ( 5,6)(11,12)(15,16)(19,20)(22,23)(25,26)(28,29),
 ( 3,9)( 5,10)( 6,11)( 7,13)( 8,15),( 1,4)( 2,10)( 3,15)( 7,22)(11,26)
  (16,28)(20,32),( 1,9)( 3,11)( 6,14)( 7,17)(12,21)(16,24),
 ( 5, 6)( 7, 8)( 11,12)( 13,14)( 19,20)( 21,22)( 24,25)( 30,31)
  ( 38,39)( 44,45)( 51,52)( 55,56)( 61,62)( 65,66)( 67,68)( 73,74)
  ( 77,78)( 99,100)(101,102)(103,104)(105,106)(107,108)(109,110)(113,114)
  (115,116)(119,120)(123,124)(151,152)(153,154)(155,156)(157,158)(159,160)
  (161,162),( 4,5)( 6,8)(10,12)(13,14),
 ( 6,7)(11,13)(22,23)(24,25)(26,27)(28,29)(30,31),
 ( 7, 8)( 13,14)( 17,18)( 24,25)( 26,27)( 30,31)( 33,34)( 37,38)
  ( 39,40)( 49,50)( 51,52)( 55,56)( 59,60)( 65,66)( 70,71)( 77,78)
  ( 80,81)( 84,85)( 88,89)( 92,93)( 95,96)( 99,100)(103,104)(107,108)
  (111,112)(114,115)(118,119)(122,123)(126,127)(130,131)(138,139)(142,143)
  (150,151)(154,155)(157,158)(161,162)(164,165)(168,169)(171,172)(175,176)
  (178,179)(181,182)(185,186)(188,189)(192,193)(195,196)(199,200)(202,203)
  (205,206)(209,210)(212,213)(216,217)(219,220)(223,224)(226,227)(230,231)
  (233,234)(237,238)(240,241)(264,265)(268,269)(272,273)(276,277)(280,281)
  (284,285)(288,289)(292,293)(296,297)(300,301)(304,305)(308,309)(312,313)
  (315,316)(318,319)(321,322)(324,325)(327,328)(330,331)(333,334)(336,337)
  (339,340)(342,343)(345,346),( 1,7)( 2,16)( 3,20)( 6,22)( 9,25)(15,28)
  (27,31)(30,34),( 5,6)( 8,9)(15,16)(18,19)(22,23)(25,26)(28,29)(31,32),
 ( 6, 7)( 11,12)( 13,15)( 17,18)( 34,35)( 40,42)( 43,44)( 45,46)
  ( 48,49)( 53,54)( 55,56)( 58,59)( 61,62)( 63,64)( 65,66)( 67,68)
  ( 69,70)( 71,72)( 77,79)( 83,85)( 88,89)( 90,91)( 93,94)( 95,96)
  ( 97,98)(100,101)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115),
 ( 7,15)( 8,18)( 9,23)(10,26)(16,33)(21,35)(29,37)(30,40)(31,45)(32,48)
  (38,54)(42,57)(44,60)(46,63)(50,66)(52,69)(53,71)(59,73)(65,75),
 ( 4,5)(12,13)(16,18)(21,22)(24,25)(26,27)(29,30)(31,32)(33,34)(35,36)
  (37,38),( 5,7)( 9,11)(16,19)(20,22)(27,29)(30,32)(37,39)(40,43)(44,45)
  (48,49)(52,53)(57,58)(61,62)(65,66)(69,70)(74,75),
 ( 2,8)( 6,9)(10,13)(11,15),( 4,7)( 8,11)(13,17)(19,22)(24,27)(28,32)
  (34,38)(39,42)(44,47)(49,53),( 3,5)(12,13)(14,15)(16,17)(18,19)(20,21)
  (22,23),( 2,8)( 4,9)( 6,13)( 7,16)(10,19)(14,21),
 ( 4,7)( 8,12)(19,23)(24,25)(26,27)(28,29)(30,31),
 ( 5,20)( 7,21)( 9,22)(10,24)(13,27)(14,28)(16,29)(18,31)(19,34)(25,35)
  (32,36),( 4,33)( 7,34)(17,35)(22,36)(25,37)(28,38)(31,39)(40,59)(41,62)
  (44,64)(45,67)(46,69)(48,72)(49,74)(50,77)(53,79)(54,82)(55,84)(57,87)
  (60,88)(61,89)(70,90)(71,91)(80,92)(81,93),
 ( 7,8)(10,12)(14,16)(17,18)(19,20),( 9,10)(12,13)(14,16)(18,19)(20,22)
  (23,25),( 5,6)(11,12)(13,15)(17,19)(20,21)(23,24)(27,28)(31,32),
 ( 4,6)( 7,10)(12,14)(15,18),( 5,7)(10,11)(15,16)(19,20)(23,25)(30,32)
  (42,44)(47,48)(51,53)(56,57)(58,60)(63,65)(68,70)(73,75)(78,80)(83,85),
 ( 7,21)( 8,22)( 12,24)( 13,25)( 15,27)( 31,45)( 35,54)( 37,60)
  ( 38,73)( 42,74)( 46,75)( 50,76)( 52,77)( 53,78)( 58,79)( 61,82)
  ( 62,88)( 63,90)( 65,96)( 67,102)( 68,108)( 69,110)( 71,116)( 85,135)
  ( 89,137)( 93,139)( 99,141)(103,143)(105,145)(113,147)(117,149)(119,151)
  (120,152)(122,154)(123,156)(124,158)(125,160)(126,162)(127,164)(128,166)
  (129,168)(130,170)(131,172)(133,174)(134,176)(140,177)(146,178)(153,184)
  (157,187)(161,191)(165,194)(169,198)(173,201)(183,204)(186,205)(190,206)
  (193,207)(197,208)(200,209),( 2,11)( 3,12)( 4,13)( 6,14)( 7,15)( 8,16),
 ( 4,35)( 7,36)( 9,37)(17,38)(25,39)(28,40)(31,41)(42,61)(44,62)(45,65)
  (46,66)(49,69)(50,70)(51,73)(53,74)(54,77)(55,78)(58,81)(59,82)(63,84)
  (64,85)(71,86)(72,87)(79,88)(80,89),( 2,3)( 4,7)( 8,11)(16,19)(20,23),
 ( 1,14)( 2,15)( 3,18)( 4,22)( 5,25)( 6,27)( 7,29)( 8,32)( 9,35)(10,37)
  (11,38)(12,40)(17,43)(19,44)(21,45)(30,50)(31,51)(33,52),
 ( 1,4)( 5,7)(10,13)(14,16)(19,22)(23,25)(28,30)(31,33)(36,38)(39,41)
  (45,46)(48,49)(51,52)(55,56)(59,60)(62,63)(65,66)(68,69)(72,73)(76,77),
 ( 3,6)( 7,9)(11,13)(15,17)(19,21),( 3,6)( 7,9)(11,14)(15,17),
 ( 3,7)( 8,11)(12,15),( 4,5)( 8,9)(11,12)(18,19)(20,21)(23,24)(27,28)
  (33,34)(59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)
  (77,78)(79,80)(81,82),( 1,5)( 9,13)(14,18)(19,23)(25,26)(31,32),
 ( 7,26)( 11,29)( 12,32)( 15,33)( 19,37)( 22,41)( 23,54)( 24,64)
  ( 25,69)( 27,71)( 31,74)( 34,77)( 36,80)( 39,89)( 40,90)( 44,92)
  ( 46,94)( 48,96)( 49,97)( 51,100)( 53,102)( 56,104)( 57,105)( 59,107)
  ( 61,109)( 63,111)( 66,113)( 68,115)( 72,116)( 75,118)( 78,120)( 81,122)
  ( 82,125)( 83,128)( 84,130)( 85,133)( 86,135)( 87,138)( 88,139)( 91,140)
  ( 93,142)( 95,143)( 99,144)(101,146)(103,147)(106,148)(108,150)(110,151)
  (112,152)(114,154)(124,155)(127,156)(129,157)(132,158)(134,159)(137,160)
  (141,161)(145,163)(149,165)(153,167),( 7,8)(11,12)(18,19)(23,24)(25,26)
  (29,30)(48,49)(54,55)(56,57)(62,63)(64,65)(67,68)(70,71)(73,74)(76,77)
  (79,80),( 8,13)(11,34)(14,35)(17,36)(20,37)(23,38)(26,39)(29,40)(31,49)
  (33,58)(42,59)(45,63)(48,65)(51,69)(54,71)(57,75)(61,77)(64,78)(67,79)
  (70,80)(73,81)(76,82),( 2,3)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 4,6)( 8,10)(12,13)(18,19)(22,24)(27,28)(34,35)(39,40)(43,44)(48,49)
  (52,54)(57,59)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 1,10)( 2,15)( 3,22)( 5,24)(11,27)(16,29)(20,32),
 ( 6,7)(11,12)(15,16)(19,20)(22,23)(25,26)(29,30),
 ( 1,10)( 2,15)( 3,22)( 6,24)(12,26)(17,28)(21,30),
 ( 4,6)( 8,10)(13,16)(18,21)(23,26),( 1,10)( 2,15)( 3,21)( 5,23)( 9,27)
  (14,29)(18,33),( 1,5)( 4,10)( 6,12)( 8,14),
 ( 8, 9)( 10,11)( 17,18)( 20,21)( 29,30)( 39,40)( 45,46)( 51,52)
  ( 53,54)( 55,56)( 57,58)( 59,60)( 61,62)( 63,64)( 65,66)( 68,69)
  ( 70,71)( 72,73)( 75,76)( 77,78)( 79,80)( 81,82)( 83,84)( 85,86)
  ( 88,89)( 99,100)(107,108)(119,120)(122,123)(127,128),
 ( 5,6)( 8,9)(11,12)(18,19)(23,24)(26,27)(30,31)(33,34),
 ( 2,3)( 6,7)(16,17)(20,21)(25,26)(28,29)(31,32)(34,35),
 ( 4,5)( 9,10)(14,15)(19,20)(26,27)(30,31)(42,43)(47,48)(51,52)(56,57)
  (59,60)(64,65)(69,70)(74,75)(79,80)(84,85),
 ( 1,4)( 9,11)(12,15)(17,19)(20,23),( 4,5)( 7,8)(11,12)(15,16)(21,22)
  (26,27)(29,30),( 3,5)( 8,10)(12,14)(15,17)(18,20)(22,24)(25,27)(30,32),
 ( 13,14)( 16,18)( 19,20)( 24,25)( 34,35)( 36,37)( 41,42)( 44,45)
  ( 46,47)( 48,50)( 55,56)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 71,72)( 73,75)( 79,81)( 88,89)( 91,92)( 93,94)( 95,96)
  ( 98,99)(100,101)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115),
 ( 1,7)( 3,12)( 6,14),( 2,7)( 5,9)(10,13)(11,14),
 ( 9,10)(13,14)(18,19)(23,24)(27,28)(33,34)(37,38)(42,43)(47,48)(51,52),
 ( 4,7)( 9,12)(14,17)(19,23)(24,27)(29,33)(34,38)(40,43)(44,48)(50,53),
 ( 1,4)( 2,7)( 6,10)( 9,12)(11,13),( 4,14)( 5,19)( 6,21)( 7,24)( 8,30)
  ( 9,32)(10,34)(11,37)(12,38)(16,41)(17,42)(20,43)(22,44)(23,45)(26,49)
  (27,50)(28,51)(31,52)(33,53)(36,54)(39,56)(40,57)(46,59)(47,60)(48,61)
  (55,62)(58,63),( 1,4)( 2,12)( 3,17)( 7,24)(13,27)(18,28)(22,31),
 ( 4,5)( 8,9)(12,13)(16,17)(21,22)(25,26)(29,30)(33,34),
 ( 2,5)(11,12)(14,30)(18,31)(21,32)(24,33)(27,37)(29,46)(36,54)(39,58)
  (42,61)(45,65)(48,68)(51,72)(53,73)(57,74)(60,75)(64,76)(67,77)(71,78),
 ( 5,8)( 9,12)(13,15)(16,19)(20,23)(24,26),( 2,3)( 7,8)(11,12)(15,16),
 ( 2,3)(11,12)(14,15),( 2,5)( 6,8)(13,15)(16,18)(23,25)(26,29)(34,36)
  (38,40)(46,47)(51,52)(55,56)(59,60)(63,64)(68,69)(72,73)(76,77),
 ( 4,30)( 8,33)( 13,37)( 15,40)( 18,43)( 22,47)( 24,52)( 25,56)
  ( 26,59)( 27,68)( 28,78)( 34,81)( 38,83)( 44,84)( 48,86)( 49,87)
  ( 51,94)( 53,95)( 54,97)( 58,98)( 60,101)( 63,102)( 64,104)( 67,105)
  ( 69,107)( 72,108)( 73,111)( 76,112)( 77,113)( 79,116)( 82,117)( 85,118)
  ( 88,120)( 89,122)( 90,125)( 91,127)( 92,130)( 93,132)( 99,134)(109,136)
  (114,138)(119,139)(121,140)(123,141)(124,142)(126,143)(128,144)(129,145)
  (131,146)(133,147)(135,148)(137,149),( 3,8)( 5,10)( 6,12)( 7,14)(15,18)
  (17,20),( 6,7)(10,11)(15,16)(19,20)(24,25),
 ( 2,6)( 3,7)( 9,13)(11,15),( 5,7)(10,12)(15,16)(20,22)(26,27)(30,32)
  (35,37)(41,43)(46,47)(50,52),( 1,5)( 4,9)( 6,10),
 ( 3,13)( 4,17)( 5,18)( 8,22)( 9,23)(10,27),
 ( 9,30)(23,31)(26,32)(28,33)(34,53)(35,54)(36,55)(38,57)(39,60)(40,62)
  (41,65)(42,67)(43,70)(44,71)(45,72)(47,74)(48,77)(49,79)(50,82)(51,84)
  (56,86)(58,87)(59,88)(66,89)(68,90)(69,91)(78,92)(80,93)(81,94),
 ( 4,5)(10,11)(13,15)(17,19)(21,22)(25,26)(28,29)(32,33),
 ( 6,8)(11,13)(16,18)(21,23)(26,28)(32,33)(36,38)(42,43)(47,49)(52,53),
 ( 4,5)( 8,9)(10,11)(13,14)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27)
  (28,29)(30,31)(32,33),( 1,24)( 3,25)( 4,26)( 6,27)( 8,30)( 9,31)(11,32)
  (13,33)(14,34)(16,37)(18,38)(20,39)(22,41)(28,42)(29,43)(35,45)(36,46)
  (40,48)(44,50)(47,51)(49,52),( 7,8)(15,16)(19,20)(29,30)(34,35)(38,39)
  (43,44)(47,48)(49,50)(52,53)(55,56)(57,58)(60,61)(63,64)(66,67)(68,69)
  (71,72)(73,74)(75,76),( 4,16)( 6,17)( 8,19)(10,20)(12,22)(14,23),
 ( 5,6)( 8,9)(12,13)(16,17)(22,23)(26,27)(29,30),
 ( 1,9)( 3,12)( 4,13)( 6,16)( 7,19)(11,20)(15,21)(18,22),
 ( 7,25)( 9,34)(12,35)(15,36)(18,37)(21,38)(24,39)(27,40)(30,41)(32,50)
  (42,60)(45,64)(48,66)(51,70)(54,72)(57,76)(59,77)(62,78)(65,79)(68,80)
  (71,81)(74,82),( 5,6)( 9,10)(13,14)(15,16)(22,23)(24,25)(27,28)(30,31)
  (57,58)(60,61)(62,63)(65,66)(67,68)(70,71)(72,73)(75,76)(77,78)(80,81)
  (82,83)(85,86),(12,13)(14,15)(17,18)(20,21)(22,23)(25,26)(28,29)(30,31)
  (33,34)(36,37)(38,39)(41,42),( 1,2)( 3,4)( 5,6)( 7,9)(11,13)(15,17)
  (19,21),( 1,5)( 2,12)( 3,20)( 6,23)(15,26)(18,29)(24,31)(27,33),
 ( 1,9)( 3,12)( 5,14)( 7,18)(11,21)(15,24),
 ( 7,10)(12,15)(18,22)(23,24)(25,27)(28,29)(30,32),
 ( 4,6)( 8,9)(10,12)(14,15),( 8,9)(11,12)(14,15)(17,18)(20,21)(22,23)
  (27,28)(29,30),( 2,11)( 3,13)( 5,16)( 8,20)(14,22)(19,24),
 ( 3,4)( 9,10)(13,14)(15,16)(20,21),( 5,7)(10,11)(15,17)(21,22)(25,27)
  (30,32)(36,38)(41,42)(45,47)(51,53),( 4,38)( 7,39)(10,40)(13,42)(16,43)
  (19,44)(22,45)(28,46)(30,47)(33,48)(36,50)(51,61)(53,64)(54,67)(55,70)
  (57,73)(58,76)(63,77)(69,79)(75,81),( 4,7)( 9,12)(14,17)(19,22)(24,28)
  (29,32)(34,38)(39,43)(45,48)(49,53),( 4,20)( 6,21)( 8,24)( 9,26)(11,27)
  (13,28)(14,31)(17,33)(18,34)(23,35)(30,36),( 4,7)( 6,8)( 9,12)(10,15),
 ( 7,8)(11,12)(15,16)(18,19)(23,24)(26,27)(31,32)(41,42)(44,45)(47,48)
  (51,52)(54,55)(74,75)(78,79),( 4,5)( 9,10)(14,15)(17,18)(20,21)(24,25)
  (28,29)(32,33)(45,46)(49,50)(54,55)(58,59),
 ( 4,5)( 8,9)(13,14)(18,19)(21,22)(24,25)(28,29)(33,34)(44,45)(48,49)
  (52,53)(56,57),( 1,7)( 3,11)( 5,19)( 9,21)(12,22)(17,25)(23,28)(26,29),
 ( 5,6)( 9,10)(12,13)(17,18)(20,21)(24,25),
 ( 7,10)(13,15)(17,19)(22,23)(26,27)(29,32)(39,40)(44,45)(48,50)(53,55)
  (58,60)(62,63)(64,65)(67,68)(69,70)(73,75)(79,81)(82,84)(85,87)(91,93)
  (94,96),( 1,2)( 3,4)( 5,6)( 7,8)(11,12)(17,18),
 ( 1,5)( 6,10)(11,15)(19,23)(28,29)(34,35),
 ( 3,4)(10,11)(14,15)(18,19)(21,22)(25,26),
 ( 4,5)( 7,8)(10,11)(13,14)(15,16)(18,19)(20,21)(23,24)(26,27)(29,30)
  (31,32)(34,35)(37,38)(40,41)(42,43)(45,46)(47,48)(50,51)(53,54)(56,57),
 ( 7,8)(12,13)(17,18)(22,23)(27,28)(31,32)(36,37)(41,42)(46,47)(51,52),
 ( 5,6)( 9,10)(14,15)(18,19)(21,22)(25,26),
 ( 1,7)( 2,12)( 3,19)( 9,24)(14,27)(18,28)(23,31),
 ( 4,6)( 9,11)(14,16)(19,21)(24,26),( 2,9)( 6,11)( 7,13)( 8,15)(10,17)
  (12,19)(14,21),( 7,8)(12,13)(15,16)(19,20)(26,27)(30,31)(41,42)(45,46)
  (49,50)(53,54)(60,61)(65,66)(70,71)(75,76)(80,81)(85,86),
 ( 1,2)( 4,5)( 6,7)(10,11)(13,14),( 4,5)( 7,8)( 9,10)(12,13)(14,15)
  (17,18)(20,21)(23,24)(26,27)(29,30)(31,32)(34,35)(36,37)(39,40)(41,42)
  (44,45)(47,48)(50,51)(53,54)(56,57),( 1,10)( 2,15)( 3,23)( 5,24)( 9,27)
  (14,28)(20,31),( 1,2)( 6,7)(20,21)(22,23)(24,25),
 ( 3,9)( 5,10)( 6,12)( 7,14)( 8,16),( 5,6)(13,14)(18,19)(24,25)(26,27)
  (28,29)(30,31),( 4,5)(10,11)(14,16)(18,20)(22,23)(25,26)(28,29)(31,32),
 ( 1,7)( 3,10)( 5,14)( 9,22)(15,25)(18,27)(21,28)(24,29),
 ( 9,37)( 11,38)( 14,39)( 15,42)( 17,43)( 19,44)( 22,45)( 23,48)
  ( 25,50)( 26,54)( 28,58)( 29,60)( 31,63)( 32,65)( 33,67)( 36,69)
  ( 40,70)( 46,71)( 49,76)( 51,77)( 53,78)( 55,79)( 57,83)( 59,85)
  ( 62,86)( 66,87)( 68,91)( 72,94)( 73,97)( 74,100)( 80,103)( 81,104)
  ( 88,105)( 89,106)( 92,109)( 93,111)( 96,113)( 98,115)( 99,116)(101,118)
  (102,120)(107,124)(108,128)(110,130)(112,131)(117,132)(119,133)(122,135)
  (123,137)(126,139)(127,141)(134,142)(138,143),
 (10,11)(13,14)(15,17)(18,19)(20,22)(23,25),
 ( 2,3)( 4,6)( 7,8)(10,11)(12,13),( 7, 9)( 10,11)( 13,15)( 16,18)
  ( 19,20)( 23,25)( 26,28)( 29,30)( 31,32)( 33,35)( 36,38)( 39,41)
  ( 43,44)( 45,46)( 48,50)( 51,53)( 54,56)( 58,60)( 61,62)( 64,66)
  ( 67,68)( 69,71)( 72,73)( 74,75)( 76,77)( 78,79)( 80,82)( 83,84)
  ( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 95,97)( 98,99)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111)(112,113)(114,116)(117,118)
  (119,120)(121,122)(123,124)(125,126)(127,128)(129,131)(133,134)(135,136)
  (138,140)(141,143)(145,146)(147,148)(150,152)(153,155)(156,157)(158,159)
  (160,162)(163,164)(165,166)(167,169)(170,171)(172,173)(174,176)(177,179)
  (180,181)(182,183)(184,186)(187,188)(189,190)(191,193)(194,195)(196,197)
  (198,200)(201,202)(203,204)(205,207)(208,209)(210,211)(212,214)(215,216)
  (217,218)(219,221)(222,223)(224,225)(226,228)(229,230)(231,232)(233,235)
  (236,237)(238,239)(240,242)(243,244)(245,246)(247,248)(249,250)(251,252)
  (253,254)(255,256)(257,258)(259,260)(261,262)(263,264)(265,266)(267,268)
  (269,270)(271,272)(273,274)(275,276)(277,278)(279,280)(281,282)(283,284)
  (285,286)(287,288)(289,290)(291,292)(293,294)(295,296)(297,298)(299,300)
  (301,302)(303,304)(305,306)(307,308)(309,310)(311,313)(314,316)(317,319)
  (320,322)(323,325)(326,328)(329,331)(332,334)(335,337)(338,340)(341,343)
  (344,346)(347,348)(349,350)(351,352)(353,354)(355,356)(357,358),
 ( 6,7)(11,12)(13,15)(16,17)(18,20)(21,22)(23,25)(26,27),
 ( 8,25)(11,34)(13,35)(17,36)(19,37)(23,38)(26,39)(29,40)(31,41)(33,50)
  (43,60)(46,64)(49,66)(52,70)(55,72)(58,76)(61,77)(63,78)(67,79)(69,80)
  (73,81)(75,82),( 5,6)(13,14)(19,21)(23,24)(25,27)(28,30)(31,32)(33,34),
 ( 1,5)( 6,10)( 7,12),( 4,5)( 7,8)(11,12)(15,16)(20,21)(25,26)(29,30),
 ( 9,10)(13,14)(16,17)(19,20)(22,23)(24,25)(28,29)(32,33)(34,35)(39,40)
  (42,43)(47,48)(50,51)(56,57)(61,62)(64,65)(68,69)(72,73)(78,79)(86,87),
 ( 1,8)( 2,10)( 6,13),( 5,6)(10,11)(13,14)(17,18)(21,22)(25,26),
 ( 3,4)(11,12)(15,16)(18,19)(21,22)(25,26),
 ( 9,10)(13,14)(18,19)(23,24)(27,28)(31,32)(35,36)(40,41)(45,46)(49,50),
 ( 3,15)( 7,18)( 8,19)( 9,22)(13,23)(14,26),(2,6)(4,7)(5,9),
 ( 4,20)( 6,21)( 8,25)(10,26)(12,27)(15,31)(16,32)(19,33)(23,34)(24,35)
  (29,36)(30,37),( 5,6)( 7,9)(11,13)(15,16)(22,23)(26,27)(29,30)(33,34),
 ( 4,8)( 6,10)(12,14)(13,15),( 9,10)( 15,16)( 17,18)( 23,26)( 32,33)
  ( 34,35)( 36,37)( 40,41)( 42,43)( 46,47)( 49,50)( 53,54)( 57,58)
  ( 59,60)( 63,64)( 69,70)( 71,72)( 75,76)( 79,80)( 85,86)( 87,88)
  ( 89,90)( 91,92)( 93,94)( 95,96)( 97,98)(111,112)(117,118)(121,122)
  (125,126)(127,128)(129,130)(131,132)(133,134)(135,136)(139,140)(141,142)
  (143,144)(145,146)(147,148)(149,150),(10,12)(14,17)(19,21)(23,25)(28,30)
  (32,34)(36,39)(41,43)(45,47)(50,52),( 1,2)( 3,4)( 5,6)( 7,8)(10,11)
  (13,14)(16,17)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35)(40,41)(44,45)
  (49,50)(53,54)(58,59)(62,63),( 5,8)( 9,13)(15,18)(20,23)(25,28)(30,33)
  (35,39)(40,43)(45,49)(50,54),( 4,5)( 6,7)( 8,9)(11,12)(14,15)(16,17)
  (19,20)(21,22)(23,24)(25,26)(28,29)(31,32)(33,34)(35,36)(37,38),
 ( 4,8)( 5,9)(10,13)(11,15),( 7,10)(13,15)(18,20)(22,24)(26,29)(31,34)
  (37,39)(42,44)(46,48)(50,53),( 4,6)( 9,11)(14,16)(19,21)(24,26)(30,31)
  (34,36)(40,41)(45,47)(50,51),( 3,4)( 6,7)(11,12)(16,17)(19,20)(22,23),
 ( 3,4)( 6,7)( 9,10)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 1,10)( 3,12)( 5,15)( 8,18)(14,21)(19,23),
 ( 6,7)(10,11)(14,15)(19,20)(24,25)(29,30)(33,34)(37,38)(41,42)(46,47)
  (51,52)(56,57),( 1,2)( 6,7)(10,11)(14,15),
 ( 6,8)(11,13)(15,16)(18,20)(27,29)(31,33)(35,37)(54,55)(58,59)(60,62)
  (63,65)(66,68)(69,71)(72,74)(75,77),( 7, 8)( 12,13)( 17,18)( 19,20)
  ( 23,24)( 32,33)( 42,43)( 51,52)( 53,54)( 56,57)( 58,59)( 60,61)
  ( 62,63)( 64,65)( 66,67)( 69,70)( 71,72)( 73,74)( 75,76)( 77,78)
  ( 80,81)( 89,90)( 92,93)( 94,95)( 96,97)( 98,99)(101,102)(103,104)
  (105,106)(107,108)(114,115)(116,117),( 3,8)( 5,9)( 6,12)( 7,17)(13,19)
  (16,21),( 2,9)( 5,13)( 7,16)( 8,18)(10,21)(15,23),
 ( 1,8)( 2,10)( 3,11)( 5,13)( 7,14),( 8, 9)( 11,12)( 14,15)( 16,17)
  ( 21,22)( 23,24)( 27,28)( 30,31)( 46,47)( 48,49)( 51,52)( 53,54)
  ( 56,57)( 58,59)( 73,74)( 77,78)( 79,80)( 82,83)( 85,86)( 89,90)
  ( 91,92)( 94,95)( 98,99)(102,103)(105,106)(108,109)(112,113)(115,116),
 ( 5,6)(16,17)(19,21)(22,24)(26,27)(32,33)(35,37)(38,40)(42,43),
 ( 2,9)( 3,12)( 6,15)( 8,19)(13,21)(18,23),
 (12,13)(14,15)(17,18)(20,21)(22,23)(25,26)(29,30)(35,36)(39,40)(41,42)
  (43,44)(47,48)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62),
 ( 4,6)( 9,11)(14,15)(18,20)(23,25)(28,29),
 ( 4,5)( 7,8)(10,11)(17,18)(23,24)(25,26)(29,30)(31,32),
 ( 5,8)( 6,9)(10,12)(11,14),( 1,2)( 3,4)( 5,6)( 7,8)(10,11)(13,14)
  (16,17)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35)(38,39)(44,45)(47,48)
  (53,54)(56,57)(62,63),( 7,11)( 8,15)( 9,19)(10,22)(18,33)(23,35)(29,40)
  (30,42)(31,48)(32,50)(37,53)(39,56)(43,59)(45,62)(47,65)(51,68)(58,71)
  (64,73)(70,75),( 7, 8)( 11,12)( 15,16)( 18,19)( 21,22)( 26,27)
  ( 36,37)( 43,44)( 47,48)( 50,51)( 53,54)( 55,56)( 58,59)( 60,61)
  ( 62,63)( 65,66)( 67,68)( 73,74)( 85,86)( 88,89)( 91,92)( 94,95)
  ( 97,98)(100,101)(102,103)(104,105)(106,107)(108,109)(110,111)(112,113),
 ( 7, 8)( 13,14)( 17,18)( 24,25)( 26,27)( 30,31)( 33,34)( 37,38)
  ( 39,40)( 48,49)( 50,51)( 54,55)( 58,59)( 64,65)( 69,70)( 76,77)
  ( 80,81)( 84,85)( 88,89)( 91,92)( 95,96)( 99,100)(103,104)(107,108)
  (110,111)(114,115)(118,119)(122,123)(126,127)(130,131)(138,139)(142,143)
  (150,151)(154,155)(158,159)(161,162)(165,166)(168,169)(172,173)(175,176)
  (178,179)(182,183)(185,186)(189,190)(192,193)(196,197)(199,200)(202,203)
  (205,206)(209,210)(212,213)(216,217)(219,220)(223,224)(226,227)(230,231)
  (233,234)(237,238)(240,241)(264,265)(268,269)(272,273)(276,277)(280,281)
  (284,285)(288,289)(292,293)(296,297)(300,301)(304,305)(308,309)(312,313)
  (315,316)(318,319)(321,322)(324,325)(327,328)(330,331)(333,334)(336,337)
  (339,340)(342,343)(345,346),( 3,4)(11,12)(14,15)(19,20)(22,23),
 ( 1,5)( 2,10)( 3,19)( 9,22)(12,25)(18,28)(27,31)(30,34),
 ( 3,7)( 4,9)( 5,15)(10,17)(11,19)(12,21)(13,23),
 ( 2,25)( 3,26)( 5,27)( 6,29)( 8,32)(10,33)(11,35)(13,36)(14,38)(15,41)
  (17,42)(19,44)(20,45)(22,46)(23,47)(28,49)(30,50)(37,52)(39,53),
 ( 7,24)( 15,25)( 18,26)( 20,27)( 23,28)( 30,50)( 31,51)( 32,54)
  ( 34,57)( 35,60)( 37,61)( 38,64)( 40,67)( 41,68)( 42,71)( 44,75)
  ( 47,78)( 48,81)( 49,84)( 52,92)( 53,93)( 62,94)( 63,95)( 72,96)
  ( 76,97)( 77,98)( 99,118)(107,125)(119,132)(122,133)(127,134),
 ( 1,2)( 3,4)( 5,6)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23)(25,26)
  (28,29)(31,32)(34,35)(38,39)(41,42)(47,48)(50,51)(56,57)(59,60),
 ( 4,6)(10,11)(14,15),(10,12)(14,16)(18,21)(23,25)(27,29)(32,34)(36,38)
  (40,43)(45,47)(49,51),( 6,8)( 9,11)(13,15),
 ( 1,10)( 3,12)( 5,18)( 7,23)(13,24)(16,25)(21,26),
 ( 1,8)( 2,10)( 5,14)( 6,16),( 2,11)( 3,14)( 6,17)( 8,19)(12,21)(16,24),
 ( 1,11)( 2,17)( 3,21)( 6,23)( 7,25)(13,28)(16,30),
 ( 7,37)( 9,38)(11,41)(13,44)(15,45)(17,46)(19,47)(21,50)(23,53)(25,54)
  (27,55)(29,56)(31,59)(33,62)(35,63),( 5,9)( 6,10)( 7,14)( 8,15)(11,17)
  (12,19)(13,20)(16,21)(18,22),( 1,2)( 5,6)(10,11)(15,16)(19,20)(23,24),
 ( 5,9)( 6,10)( 7,12)( 8,14)(11,18)(13,20)(15,22),
 ( 4,21)( 6,24)( 8,25)(10,26)(11,27)(13,29)(14,31)(17,32)(19,33)(22,34)
  (28,35),(10,12)(14,16)(18,20)(22,23)(24,26)(27,28)(29,30)(31,33)(34,35)
  (38,39)(40,42)(43,44),( 1,8)( 2,10)( 6,12),
 ( 7, 9)( 10,11)( 13,15)( 16,18)( 19,20)( 23,25)( 26,28)( 29,30)
  ( 31,32)( 33,35)( 36,38)( 39,41)( 42,43)( 44,45)( 47,49)( 50,52)
  ( 53,55)( 57,59)( 60,61)( 63,65)( 66,67)( 68,70)( 72,73)( 74,75)
  ( 76,78)( 79,80)( 81,82)( 83,84)( 85,86)( 87,88)( 89,90)( 91,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107)(108,109)
  (110,112)(113,114)(115,116)(117,118)(119,120)(121,122)(123,124)(125,126)
  (127,128)(129,131)(133,134)(135,136)(138,140)(141,143)(145,146)(147,148)
  (150,152)(153,154)(155,156)(157,159)(160,161)(162,163)(164,166)(167,168)
  (169,170)(171,173)(174,176)(177,178)(179,180)(181,183)(184,185)(186,187)
  (188,190)(191,192)(193,194)(195,197)(198,200)(201,202)(203,204)(205,207)
  (208,209)(210,211)(212,214)(215,216)(217,218)(219,221)(222,223)(224,225)
  (226,228)(229,230)(231,232)(233,235)(236,237)(238,239)(240,242)(243,244)
  (245,246)(247,248)(249,250)(251,252)(253,254)(255,256)(257,258)(259,260)
  (261,262)(263,264)(265,266)(267,268)(269,270)(271,272)(273,274)(275,276)
  (277,278)(279,280)(281,282)(283,284)(285,286)(287,288)(289,290)(291,292)
  (293,294)(295,296)(297,298)(299,300)(301,302)(303,304)(305,306)(307,308)
  (309,310)(311,313)(314,316)(317,319)(320,322)(323,325)(326,328)(329,331)
  (332,334)(335,337)(338,340)(341,343)(344,346)(347,348)(349,350)(351,352)
  (353,354)(355,356)(357,358),( 5,6)(12,13)(16,18)(21,22)(27,28)(30,32)
  (34,36)(38,39)(43,44)(47,48)(53,54)(58,59)(61,63)(64,66)(67,69)(70,72)
  (73,75)(76,78),( 3,4)( 7,8)(11,12)(21,22)(25,26)(28,29)(33,34)(36,37)
  (38,39)(41,42),( 5,6)(10,11)(15,16)(18,20)(24,26),
 ( 1,7)( 2,11)( 3,19)( 6,21)( 8,23)(13,26)(14,28)(17,31)(24,34)(29,36)
  (32,38),( 6,7)(11,12)(13,15)(18,20)(23,25),
 ( 2,9)( 3,12)( 5,15)( 6,18),( 7,8)(12,13)(17,18)(21,22)(25,26)(34,35)
  (37,38)(42,43)(47,48)(54,55)(57,58)(60,61)(62,63)(64,65)(66,67)(68,69)
  (70,71)(73,74)(75,76)(77,78)(79,80)(81,82)(85,86)(90,91),
 ( 1,4)( 9,12)(13,15)(17,19)(20,22),( 6,35)( 9,36)( 14,37)( 16,38)
  ( 19,39)( 25,40)( 28,41)( 34,42)( 43,56)( 45,59)( 46,60)( 48,63)
  ( 51,64)( 53,66)( 55,69)( 61,80)( 65,81)( 70,83)( 71,85)( 72,87)
  ( 75,89)( 76,91)( 77,93)( 82,94)( 84,96)( 86,98)( 88,100)( 90,102)
  ( 92,104)( 97,106)(101,107)(105,108),( 4,5)( 9,11)(14,16)(19,21)(24,26)
  (29,31)(35,36)(39,41)(45,46)(50,52),( 4,6)( 8,10)(12,13)(18,19)(21,22)
  (25,26)(28,29)(32,33),( 5,6)( 8,9)(10,11)(12,13)(14,15),
 ( 4,5)( 7,8)(10,11)(17,18)(23,24)(25,26)(30,31)(32,33),
 ( 1,2)( 5,6)( 9,10)(19,20)(25,26)(28,29)(32,33)(35,36),
 ( 4,5)(11,12)(13,14)(17,18)(20,22)(24,25)(32,34)(37,38)(43,44)(46,47)
  (50,51)(53,54),( 2,8)( 3,10)( 5,12)( 6,14),
 ( 4,5)(11,12)(14,16)(17,18)(21,22)(27,28)(30,32)(34,36)(39,40)(44,45)
  (49,50)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 5,7)(10,11)(14,16)(20,22)(25,27)(30,31)(35,37)(41,42)(45,47)(50,52),
 ( 9,11)(12,13)(15,16)(18,19)(20,22),( 2,3)(11,12)(14,15)(18,19)(22,23)
  (26,27),( 6,8)(10,11)(13,14),( 1,2)( 3,4)( 5,6)( 7,8)(11,12)(15,16)
  (19,20),( 1,2)( 5,6)( 9,10)(20,21)(26,27)(28,29)(33,34)(37,38)(39,40)
  (42,43)(45,46)(47,48),( 3,7)( 6,8)(10,14)(12,15),
 ( 1,9)( 2,10)( 4,12)( 5,14)( 6,15)( 7,17),
 ( 6,7)(11,12)(17,18)(23,24)(27,28)(31,32)(35,36)(52,53)(56,57)(59,60)
  (62,63)(65,66)(68,69)(71,72)(74,75),( 3,5)( 6,7)( 9,10)(11,12),
 ( 8,10)(13,15)(18,21)(23,26)(28,30)(32,34)(37,39)(42,45)(47,50)(52,54),
 ( 1,2)( 5,6)( 9,10)(20,21)(26,27)(28,29)(32,33)(34,35),
 ( 6,27)( 8,28)( 19,29)( 22,30)( 25,31)( 32,58)( 34,59)( 36,60)
  ( 39,63)( 40,64)( 41,67)( 44,68)( 45,71)( 47,72)( 49,73)( 50,76)
  ( 52,77)( 53,80)( 56,81)( 61,93)( 62,94)( 69,95)( 70,96)( 78,97)
  ( 79,98)( 83,99)( 87,102)( 88,104)( 92,107),
 ( 5,6)( 8,9)(10,11)(12,13)(14,15)(40,41)(42,43)(44,45)(46,47)(48,49)
  (50,51),( 1,2)( 9,10)(12,13)(17,18)(20,21)(24,25),
 ( 7,8)(10,11)(12,14)(15,17)(18,20)(21,23)(25,26)(27,29)(30,31)(32,33)
  (41,42)(44,45)(47,48)(50,51)(53,54)(56,57)(60,61)(62,64)(66,67)(68,70)
  (72,73)(74,76),( 3,7)( 6,8)(10,13)(11,14),
 ( 3,7)( 4,9)(10,12)(11,14),( 4,5)( 7,8)( 9,10)(12,13)(15,16)(18,19)
  (21,22)(24,25)(26,27)(29,30)(31,32)(34,35)(36,37)(39,40)(42,43)(45,46)
  (48,49)(51,52)(53,54)(56,57),( 1,2)( 7,10)(14,17),
 ( 7,8)(12,13)(17,18)(21,22)(26,27)(31,32)(36,37)(41,42)(45,46)(50,51),
 ( 5,6)(11,12)(15,16)(18,19)(20,21)(27,28)(30,31)(34,35)(59,60)(61,62)
  (63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)(79,80)(81,82),
 ( 1,8)( 2,9)( 3,10)( 5,12)( 7,13),( 1,5)( 4,10)( 6,13),
 ( 2,8)( 6,9)(10,13)(11,14),( 1,2)( 6,7)( 9,10)(13,14),
 ( 4,19)( 6,22)( 7,25)( 8,28)(10,31)(11,34)(13,37)(14,40)(15,43)(17,46),
 ( 4,13)( 6,16)( 7,18)( 9,21)(11,23)(12,26),
 ( 9,10)( 15,16)( 17,18)( 23,26)( 30,31)( 32,33)( 34,35)( 38,39)
  ( 40,41)( 44,45)( 51,52)( 55,56)( 57,58)( 61,62)( 65,66)( 69,70)
  ( 71,72)( 75,76)( 79,80)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)(111,112)(117,118)(121,122)(125,126)(127,128)(129,130)
  (131,132)(133,134)(135,136)(139,140)(141,142)(143,144)(145,146)(147,148)
  (149,150),( 5,6)(10,11)(13,14)(18,19)(21,22)(25,26)(29,30)(42,43)(45,46)
  (49,50)(52,53)(55,56)(74,75)(78,79),( 4,5)( 7,8)(12,13)(17,18)(23,24)
  (30,31),( 4,6)( 8,10)(12,13)(17,18)(21,23)(25,27)(28,29)(35,36)(40,41)
  (45,46)(50,51)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 1,4)( 2,7)( 6,11)( 8,13)( 9,15),( 2,7)( 4,11)( 6,19)(10,21)(13,22)
  (18,25)(24,28)(27,29),( 2,6)( 4,8)( 5,11),
 ( 2,3)( 4,5)( 7,8)(10,11)(13,14),( 3,4)( 8,9)(13,14)(17,18)(28,29)
  (36,37)(43,44),( 6,7)(11,12)(17,18)(22,23)(28,29),
 ( 3,6)( 8,10)(11,12),( 5,21)( 7,22)(10,23)(11,25)(13,27)(14,28)(16,29)
  (18,30)(20,33)(26,34)(32,35),( 1,6)(10,22)(13,30)(16,31)(20,32)(24,33)
  (26,39)(28,48)(34,52)(37,56)(40,59)(43,63)(46,66)(49,70)(53,73)(57,74)
  (60,75)(64,76)(67,77)(71,78),( 7,13)( 9,34)(12,35)(15,36)(19,37)(21,38)
  (25,39)(27,40)(30,49)(32,58)(41,59)(44,63)(47,65)(50,69)(53,71)(56,75)
  (60,77)(62,78)(66,79)(68,80)(72,81)(74,82),( 1,5)( 4,11)( 8,12),
 ( 1,4)( 5,8)(10,13)(15,18)(19,22),( 5,34)( 7,37)( 9,39)(11,41)(13,44)
  (15,46)(17,49)(19,51)(21,53)(23,56)(25,58)(27,61)(29,63)(31,65)(33,68),
 ( 1,6)(10,16)(11,24)(13,30)(17,32)(25,37)(26,40)(27,46)(28,49)(33,53)
  (36,56)(38,59)(42,62)(45,65)(47,68)(55,70)(61,72)(67,74),
 ( 2,3)( 5,6)(10,11),( 1,11)( 2,13)( 3,17)( 4,31)( 5,35)
  ( 36,46)( 39,58)( 40,59)( 44,62)( 45,63)( 49,66)( 52,68)( 53,69)
  ( 55,77)( 56,83)( 72,85)( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)
  ( 86,103)( 89,104)( 92,106)( 95,107)( 98,109)(101,110),
 ( 1,10)( 2,15)( 3,23)( 5,25)(11,27)(16,28)(21,30),
 ( 1,4)( 6,9)(11,14)(18,20)(25,26)(34,35)(41,42),
 ( 1,15)( 2,16)( 4,17)( 5,19)( 7,20)( 8,22)( 9,23)(10,24)(12,26)(13,27),
 ( 1,9)( 2,10)( 3,11)( 5,12)( 6,14)( 8,15),
 ( 1,23)( 3,24)( 4,26)( 6,29)( 8,30)( 9,31)(12,33)(14,35)(16,36)(18,38)
  (20,41)(21,42)(25,43)(27,45)(28,46)(32,47)(34,49)(37,50)(39,52)(40,53)
  (44,54)(48,55)(51,56),( 1,2)( 4,5)( 9,10)(12,13)(19,20)(30,31)(33,34)
  (39,40)(42,43)(44,45)(47,48)(49,50)(52,53)(54,55)(56,57)(61,62)(64,65)
  (66,67)(69,70)(71,72)(75,76)(81,82)(83,84)(86,87)(88,89),
 ( 1,7)( 2,9)( 3,13)( 4,18)(10,23)(17,30)(33,41)(35,42)(37,43)(39,44),
 ( 1,24)( 4,25)( 8,27)( 9,28)(12,29)(14,30)(17,33)(19,34)(22,35)(26,37)
  (31,39),( 1,22)( 4,23)( 6,26)( 9,29)(11,30)(14,31)(17,36)(20,37)(25,38)
  (28,39)(33,40)(35,41),( 1,3)(14,16)(18,19)(21,23)(28,29)(38,39)(40,41)
  (42,44)(46,47)(49,50)(53,54)(55,56)(59,60)(61,62)(63,65)(67,68)(71,72)
  (75,76)(77,78),( 1,29)( 2,30)( 4,33)( 5,34)( 7,35)( 8,37)(10,38)(11,39)
  (13,41)(14,42)(16,43)(20,47)(21,48)(25,51)(26,53)(31,55)(32,56)(36,58)
  (40,60)(49,62)(54,63)(57,64)(59,65)(61,66),
 ( 1,23)( 2,26)( 4,27)( 5,28)( 7,29)( 8,32)( 9,34)(11,35)(13,36)(14,37)
  (16,40)(18,42)(19,43)(21,44)(25,46)(31,48)(39,50),
 ( 1,4)( 3,10)(12,16)(13,17)(14,18),( 1,7)( 2,14)( 3,21)( 6,22)( 9,23)
  (12,25)(15,26)(20,28)(24,30)(27,31)(29,32),
 ( 1,5)( 9,15)(10,16)(12,18)(14,20)(17,21)(19,22),
 ( 1,15)( 4,27)( 5,34)( 7,36)( 9,40)(11,43)(13,46)(18,48)(22,50)(25,51)
  (28,54)(29,57)(32,58)(38,63)(41,64)(44,68)(52,73)(55,77)(61,82)(66,86)
  (70,87)(75,91)(79,92)(84,93)(89,94),( 1,23)( 2,26)( 5,27)( 7,29)( 9,32)
  (10,33)(12,34)(14,36)(15,38)(16,41)(18,42)(19,43)(21,45)(24,46)(25,47)
  (30,49)(31,50)(39,52)(40,53),( 1,9)( 2,10)( 3,11)( 4,12)( 6,14)( 7,15),
 ( 1,8)( 3,11)( 5,16)(10,23)(17,25)(20,26)(22,27)(24,28),
 ( 1,9)( 4,28)( 8,40)(10,41)(13,44)(16,49)(19,51)(20,52)(23,58)(24,59)
  (27,62)(32,67)(34,69)(35,70)(37,73)(45,76)(47,77)(53,78)(55,79)(63,82)
  (65,83)(71,84)(74,85)(80,88)(86,91)(89,92),
 ( 1,9)( 2,10)( 4,13)( 6,15)( 8,16)(12,18)(14,20)(17,21)(19,22),
 ( 1,13)( 2,14)( 3,16)( 4,18)( 5,20)( 6,24)( 7,26)( 8,29)( 9,31)(10,35)
  (11,37)(12,39)(19,44)(21,45)(23,46)(32,51)(34,52)(36,53),
 ( 1,9)( 2,13)( 3,18)( 4,28)(35,47)(36,51)(37,62)(38,66)(39,69)(43,70)
  (44,72)(48,74)(49,75)(53,76)(54,78)(58,80)(59,81)(63,82)(64,84)(68,86),
 ( 1,11)( 2,18)( 4,26)( 7,39)(12,45)(15,46)(19,47)(21,49)(23,50)(27,52)
  (30,54)(33,55)(36,56)(40,57)(43,59)(51,61)(58,63),
 ( 1,4)( 2,9)( 3,13)( 7,24)(12,25),( 2,27)( 5,29)( 8,31)( 9,32)(11,33)
  (12,34)(14,36)(15,37)(17,42)(18,43)(20,46)(21,49)(22,50)(23,51)(25,54)
  (26,55)(28,57)(30,58)(35,60)(38,63)(40,66)(44,70)(45,71)(47,72)(52,74)
  (53,77)(56,78)(59,79)(61,82)(64,85)(67,86)(69,87)(73,88)(75,89)(80,90)
  (83,91),( 1, 9)( 2,24)( 3,46)( 6,48)( 11,50)( 14,51)( 17,52)
  ( 25,55)( 28,56)( 33,61)( 37,63)( 39,67)( 43,69)( 45,73)( 47,75)
  ( 49,77)( 53,80)( 58,90)( 59,92)( 62,94)( 64,95)( 65,97)( 68,99)
  ( 70,100)( 71,102)( 78,103)( 82,104)( 83,105)( 85,107)( 87,109)(106,111)
  (108,112)(110,113),( 1,2)( 8,9)(13,14)(18,19)(29,30)(37,38)(43,44)
  (46,47)(50,51),( 1,2)(11,12)(15,16)(19,20)(24,25)(29,30)(32,33)(36,37)
  (38,39),( 1, 7)( 2,12)( 3,15)( 4,26)( 31,42)( 32,53)( 33,61)
  ( 38,63)( 40,64)( 45,66)( 48,67)( 50,68)( 55,69)( 57,73)( 58,80)
  ( 59,85)( 60,92)( 70,96)( 74,99)( 78,102)( 82,105)( 86,108)( 90,111)
  ( 95,112)( 98,114)(101,115)(104,117)(107,118)(110,120),
 ( 1,2)(11,13)(14,15)(20,22)(23,24),( 1,2)( 3,4)( 6,7)( 8,9)(10,11)
  (12,13)(15,16)(17,18)(19,20)(21,22)(24,25)(27,28)(30,31)(39,40)(41,42)
  (43,44)(45,46)(47,48)(49,50)(51,52)(53,54)(55,56)(58,59)(60,61)(79,80)
  (81,82)(83,84)(86,87)(88,89)(90,91),( 1,9)( 2,10)( 4,13)( 5,15)( 7,16)
  (11,18)(14,20)(17,21)(19,22),( 1,6)( 2,10)( 3,17)( 5,22)(12,28)(15,30)
  (21,33)(27,36),( 1,8)( 2,13)( 3,15)( 4,31)(35,50)(36,53)(37,65)(38,68)
  (41,69)(42,71)(46,73)(47,74)(51,75)(52,77)(56,79)(57,80)(61,81)(62,83)
  (66,85)(67,86),( 1,7)( 2,14)( 3,21)( 4,26)( 5,29)( 6,35)( 9,41)(12,43)
  (15,44)(18,46)(20,47)(22,49)(25,51)(27,52)(30,54)(32,55)(34,56)(38,58)
  (40,60)(42,62)(45,63)(48,65)(50,66)(53,68)(57,69)(59,71)(61,72)(64,75)
  (67,76)(70,78)(73,79)(74,80)(77,82)(81,84)(83,85),
 ( 1,44)( 3,46)( 5,48)( 7,50)( 9,51)(11,53)(13,54)(15,56)(18,57)(20,59)
  (22,61)(24,63)(27,65)(29,67)(31,68)(33,70)(36,71)(38,73)(40,74)(42,76),
 ( 1,5)( 3,7)( 8,21)(10,22)(12,23)(16,26)(25,29)(28,30),
 ( 1,12)( 2,13)( 4,15)( 5,18)( 9,21)(10,23)(14,24)(16,25)(17,26)(19,28)
  (20,30)(22,32)(27,34)(29,35)(31,36)(33,37),
 ( 1,44)( 3,46)( 5,48)( 7,50)( 9,52)(11,54)(13,55)(15,57)(17,58)(19,60)
  (21,61)(24,63)(26,65)(28,67)(30,69)(33,71)(35,72)(37,74)(39,75)(42,77),
 ( 1,15)( 4,28)( 6,41)( 7,42)(11,43)(13,45)(16,48)(19,49)(24,53)(29,54)
  (31,56)(33,59)(34,60)(36,63)(38,65)(44,66)(46,67)(55,68)(57,69),
 ( 1,15)( 2,16)( 4,17)( 6,20)( 7,21)( 9,23)(10,24)(12,25)(14,26)(19,28)
  (22,30)(27,31)(29,32),( 1,7)( 4,9)( 5,13),
 ( 1,2)( 8,10)(13,15)(18,20)(29,31)(37,39)(43,45)(46,48)(50,52),
 ( 1,2)(14,15)(18,19)(20,21)(23,24)(25,26)(31,32)(35,36)(39,40)(41,42)
  (46,47)(51,52)(55,56)(57,58)(59,60),( 1,9)( 2,13)( 3,19)( 6,20)(10,24)
  (18,29)(23,33)(35,39)(37,40),( 1,22)( 4,23)( 6,26)( 9,29)(12,30)(15,31)
  (17,34)(20,35)(24,36)(27,37)(32,40)(38,43)(41,44),
 ( 1,42)( 4,43)( 7,46)( 8,48)(11,49)(13,51)(16,54)(17,57)(20,58)(22,60)
  (25,61)(28,64)(29,66)(32,68)(35,71)(37,74)(40,75)(44,77)(52,79)(55,80)
  (62,82)(69,84)(72,85),( 1,4)( 2,20)( 3,36)( 6,45)( 8,46)( 9,48)(12,49)
  (13,51)(16,53)(19,54)(21,55)(23,57)(25,58)(28,60)(31,61)(33,62)(35,64)
  (38,65)(40,67)(41,69)(44,70)(47,71)(50,72)(52,74)(56,75)(59,76)(63,78)
  (66,79)(68,81)(73,82)(77,83)(80,84),( 1,22)( 4,25)( 6,27)( 9,29)(11,30)
  (13,33)(16,35)(18,36)(20,38)(23,39)(31,40),
 ( 1,22)( 4,25)( 6,28)( 9,29)(12,30)(15,33)(17,34)(20,35)(24,36)(27,37)
  (32,40)(39,43)(42,44),( 1,22)( 3,23)( 5,24)( 6,29)( 8,30)(10,31)(11,32)
  (13,33)(15,38)(16,39)(17,40)(19,45)(21,46)(25,47)(28,48)(34,49)(37,50)
  (41,51)(44,52),(1,4)(3,8)(5,9),( 1,2)( 4,8)( 6,11)( 9,14)(10,15)
  (12,16)(13,17),( 1,8)( 3,11)( 5,13)( 6,16),
 ( 1,10)( 2,13)( 3,18)( 4,22)( 9,24)(14,26)(16,27)(21,29)(23,30)(25,31)
  (28,32),( 1,24)( 5,27)( 7,28)( 9,29)(11,30)(14,32)(16,34)(19,35)(21,36)
  (25,37)(31,38),( 1,12)( 2,21)( 3,27)( 4,36)( 6,37)( 8,39)
  ( 9,41)( 11,42)( 13,43)( 15,47)( 17,49)( 19,50)( 22,54)( 28,56)
  ( 44,77)( 46,78)( 48,79)( 55,84)( 57,85)( 80,102)( 86,103),
 ( 1,23)( 3,24)( 4,25)( 6,27)( 8,30)( 9,31)(11,32)(13,33)(14,35)(16,38)
  (17,39)(19,40)(21,42)(28,43)(29,45)(36,47)(37,49)(41,52)(46,54)(50,55)
  (53,56),( 1,7)( 2,12)( 3,15)( 4,28)(32,44)(33,48)(34,59)(35,63)(37,66)
  (40,68)(42,71)(45,74)(47,75)(50,77)(52,80)(55,83)(57,84)(60,86)(62,89)
  (65,92),( 1,20)( 2,21)( 3,23)( 4,25)( 5,27)( 6,28)( 7,29)( 8,31)(16,34)
  (17,35)(18,37)(19,38),( 1, 6)( 2,10)( 3,17)( 4,35)( 5,39)
  ( 9,43)( 12,44)( 15,47)( 16,48)( 23,54)( 25,57)( 27,58)( 40,84)
  ( 42,85)( 46,87)( 52,88)( 56,90)( 60,97)( 64,98)( 69,99)( 73,101)
  ( 77,102)( 81,103)( 86,105)( 89,106),( 1,9)( 3,12)( 4,14)( 6,17)(13,22)
  (19,24),( 2,22)( 5,25)( 7,27)(10,29)(12,30)(14,33)(17,35)(21,37)(24,38)
  (28,39)(32,40)(36,41),( 1, 7)( 3, 9)( 6,20)( 8,32)( 10,36)
  ( 12,38)( 14,41)( 17,43)( 18,47)( 21,49)( 23,50)( 25,53)( 33,77)
  ( 34,78)( 39,79)( 44,80)( 45,81)( 51,82)( 55,88)( 58,91)( 66,93)
  ( 69,96)( 73,97)( 90,109)( 95,110),( 1,10)( 4,14)( 6,16)( 8,17)(12,18),
 (1,6)(4,7)(5,8),( 1,11)( 2,18)( 3,26)( 4,34)( 5,41)( 7,44)( 9,46)(12,47)
  (14,48)(16,49)(19,51)(22,53)(24,54)(27,55)(30,56)(32,58)(35,60)(38,61)
  (40,62)(42,63),( 1,22)( 3,25)( 5,26)( 6,29)( 8,30)( 9,33)(11,34)(13,37)
  (14,38)(16,39)(17,40)(19,43)(21,44)(24,45)(28,46)(32,49)(36,50)(42,53)
  (48,56)(52,57)(55,58),( 1,11)( 2,14)( 3,18)( 4,23)( 5,26)
  ( 6,31)( 8,35)( 10,36)( 15,40)( 17,42)( 20,47)( 22,49)( 30,54)
  ( 32,56)( 34,58)( 37,59)( 38,61)( 39,62)( 41,64)( 43,65)( 46,67)
  ( 48,69)( 50,72)( 51,73)( 53,76)( 55,78)( 57,81)( 60,83)( 63,85)
  ( 66,86)( 68,88)( 71,89)( 74,91)( 75,92)( 77,94)( 80,95)( 82,97)
  ( 84,99)( 87,101)( 90,104)( 93,105)( 96,107)( 98,108)(100,109)(102,111)
  (103,113)(106,116)(110,118)(112,119)(114,121)(115,122)(117,124)(120,125)
  (123,126),( 1,41)( 2,45)( 5,46)( 8,47)( 9,50)(12,53)(14,55)(17,56)(20,58)
  (21,62)(24,63)(27,64)(29,67)(32,70)(33,72)(36,73)(38,75)(44,76)(49,78)
  (52,79)(61,81)(66,83)(69,84),( 2,41)( 5,43)( 6,44)( 9,48)(12,50)(13,51)
  (16,53)(18,56)(21,59)(22,60)(25,62)(27,63)(30,67)(33,69)(34,70)(37,72)
  (40,75)(45,76)(54,77)(57,79)(64,81)(73,83)(80,85)(84,86),
 ( 1,17)( 3,18)( 5,21)( 6,22)( 9,23)(12,25)(13,26)(15,27)(20,43)(24,44)
  (32,48)(36,50)(40,53),( 1,24)( 3,25)( 6,27)(10,28)(12,29)(14,30)(16,32)
  (19,34)(21,35)(26,37)(31,39),( 1,4)( 5,11)(12,16)(13,17)(14,18),
 ( 1,9)( 2,14)( 3,21)( 5,24)(11,25)(16,28)(20,29),
 ( 1,9)( 3,10)( 5,11)( 8,12),( 1,39)( 3,40)( 6,42)( 8,46)( 10,49)
  ( 11,50)( 15,53)( 17,54)( 22,56)( 24,60)( 27,63)( 28,64)( 31,65)
  ( 34,69)( 36,70)( 45,74)( 47,75)( 52,80)( 59,84)( 61,85)( 68,90)
  ( 71,93)( 72,94)( 77,97)( 78,98)( 81,101)( 82,102)( 87,105)( 88,106),
 ( 1,9)( 2,11)( 3,14)( 5,16)( 7,19)(10,22)(15,24)(18,26),
 ( 1,24)( 3,26)( 4,28)( 5,29)( 6,31)( 8,32)( 9,34)(11,35)(12,37)(13,38)
  (14,40)(15,45)(18,51)(20,54)(22,59)(23,62)(25,65)(30,66)(36,67)(44,78)
  (50,80)(58,82),( 1,11)( 2,18)( 3,26)( 4,33)( 6,36)( 9,37)
  ( 10,38)( 13,42)( 14,43)( 17,45)( 19,48)( 21,49)( 22,52)( 25,56)
  ( 27,58)( 30,61)( 32,62)( 34,63)( 35,66)( 39,69)( 41,70)( 44,73)
  ( 46,74)( 47,77)( 50,81)( 53,83)( 55,85)( 57,86)( 59,87)( 60,88)
  ( 64,91)( 67,93)( 72,94)( 75,96)( 78,98)( 80,100)( 82,101)( 84,102)
  ( 89,106)( 90,108)( 92,109)( 95,111)( 97,112)( 99,113)(103,117)(105,118)
  (107,119)(110,121)(114,125)(116,126)(120,129)(122,132)(124,133)(128,134)
  (131,135),( 1,9)( 2,12)( 4,15)( 7,19)(14,22)(20,23),
 ( 1,2)(10,11)(13,14)(15,16)(20,21)(22,23)(25,26)(27,28)(30,31)(32,33)
  (34,35),( 1,7)( 2,13)( 4,17)(10,22)(14,24)(18,25)(21,27),
 ( 1,6)( 2,10)( 3,16)( 7,24)(15,30)(19,32)(23,33)(29,35),
 ( 1,9)( 2,16)( 3,21)( 5,23)( 7,24)(11,25)(13,26)(17,27)(20,28),
 ( 1, 6)( 2,12)( 3,27)( 7,35)( 9,38)( 10,39)( 14,43)( 16,44)
  ( 19,49)( 21,50)( 23,52)( 25,56)( 37,84)( 45,86)( 48,87)( 53,90)
  ( 57,91)( 62,98)( 66,99)( 70,100)( 74,101)( 78,103)( 82,104)( 85,106)
  ( 88,108),( 1,2)( 4,5)( 6,7)( 9,10)(12,13)(14,15)(17,18)(19,20)(23,24)
  (25,26)(31,32)(33,34)(39,40)(42,43),( 1, 5)( 8,11)( 12,15)( 20,23)
  ( 27,30)( 31,33)( 36,38)( 41,43)( 44,46)( 48,50)( 51,54)( 57,59)
  ( 60,62)( 66,68)( 71,73)( 75,77)( 78,80)( 81,83)( 86,88)( 92,94)
  ( 95,97)( 98,100)(101,103),( 1,9)( 2,10)( 4,14)( 6,15)( 7,18)(11,22)
  (16,24)(19,26),( 1,2)( 7,8)(10,11)(15,16)(17,18)(22,23)(25,26)(31,32)
  (38,39)(41,42)(44,45)(50,51)(54,55)(56,57)(58,59)(61,62)(67,68)(71,72)
  (73,74)(76,77)(79,80)(81,82)(84,85),( 1,42)( 4,43)( 6,45)( 9,46)(10,48)
  (13,51)(15,54)(18,55)(21,56)(22,60)(25,62)(28,63)(30,65)(33,68)(34,71)
  (37,72)(40,73)(49,77)(52,78)(57,80)(66,82)(69,83)(74,85),
 ( 1,9)( 4,17)( 6,21)( 8,25)(10,48)(12,49)(13,50)(15,53)(18,54)(22,55)
  (23,56)(26,59)(28,60)(31,62)(37,66)(42,68)(51,71)(57,72),
 ( 1,4)(10,11)(18,19)(22,23)(25,26)(29,30)(32,33)(35,36)(38,39)(45,46)
  (47,48)(52,53)(54,55)(56,57)(58,59)(61,62)(64,65),
 ( 1,2)( 5,7)(10,12)(15,17)(19,21),( 1,2)( 5,6)( 7,8)(10,11)(13,14)
  (17,18)(19,20),( 1,11)( 3,19)( 6,37)( 8,39)(14,43)(15,44)(18,46)(20,47)
  (23,50)(26,52)(29,55)(32,57)(34,58)(41,61)(48,64)(51,66)(54,69)(60,72)
  (63,74)(67,76)(71,78)(73,80)(75,83)(79,86)(81,89)(84,91)(87,93),
 ( 1,24)( 3,26)( 5,27)( 7,29)( 9,32)(10,33)(12,34)(14,35)(15,37)(17,40)
  (19,41)(20,42)(22,43)(25,45)(30,47)(31,48)(38,50)(39,51)(44,52)(46,53)
  (49,54),( 1,15)( 2,22)( 3,27)( 5,34)( 7,35)( 9,39)( 11,41)
  ( 14,46)( 17,47)( 20,50)( 21,52)( 38,81)( 42,82)( 45,84)( 49,85)
  ( 53,86)( 56,88)( 58,96)( 62,98)( 66,100)( 70,102)( 74,104)( 78,106)
  ( 95,113)( 97,114)( 99,115)(101,116)(103,117)(105,118),
 ( 1,3)( 5,7)( 9,11)(16,17)(25,27)(29,30)(33,35)(36,37)(40,42)(44,45),
 ( 1,23)( 4,24)( 6,25)( 9,29)(11,30)(14,31)(17,32)(18,36)(21,37)(26,38)
  (33,39),( 1,8)( 2,28)( 3,38)( 4,42)( 7,44)( 9,47)(11,48)(13,49)(16,52)
  (18,54)(20,57)(22,59)(24,60)(27,63)(30,65)(32,68)(33,69)(35,71)(37,72)
  (40,75)(43,77)(46,78)(50,79)(53,81)(56,82)(58,83)(61,84)(64,86)(67,87)
  (70,88)(73,89)(76,90)(80,91)(85,92),( 1,3)( 5,7)( 9,11)(17,18)(25,26)
  (28,30)(33,34)(36,38)(41,42)(43,45),( 1,8)( 3,19)( 5,32)( 6,35)( 7,38)
  (10,42)(12,43)(14,45)(16,47)(18,48)(22,51)(23,54)(27,56)(28,58)(31,60)
  (41,67)(44,70)(53,77)(57,81),( 1, 8)( 2,23)( 4,48)( 7,49)
  ( 12,51)( 15,53)( 18,54)( 26,56)( 29,58)( 30,59)( 32,63)( 35,65)
  ( 37,69)( 41,71)( 43,75)( 50,79)( 52,80)( 57,84)( 61,89)( 62,91)
  ( 64,92)( 67,94)( 68,96)( 70,97)( 73,99)( 74,101)( 76,102)( 81,104)
  ( 85,105),( 1,5)( 3,9)( 6,21)( 8,22)(12,23)(16,26)(18,29),
 ( 1,7)( 3,9)( 6,21)(10,22)(11,23)(13,24)(17,25),
 ( 1,22)( 3,25)( 5,28)( 6,29)( 7,30)(10,34)(11,35)(12,36)(14,37)(16,40)
  (17,43)(19,44)(21,45)(24,46)(26,48)(31,49)(32,51)(39,52)(41,54),
 ( 1,3)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(26,28),
 ( 1,15)( 2,18)( 3,24)( 4,28)( 5,35)( 6,38)( 8,39)( 9,40)(11,42)(13,45)
  (16,49)(19,50)(21,51)(26,53)(29,54)(31,55)(33,59)(36,60)(41,62)(44,63)
  (46,64)(47,65)(48,67)(52,70)(56,71)(57,72)(58,74)(61,77)(66,78)(69,79)
  (73,80)(76,81),( 1,11)( 2,19)( 3,23)( 4,29)( 5,35)( 6,38)
  ( 8,39)( 10,41)( 12,42)( 16,44)( 17,47)( 20,48)( 22,51)( 27,52)
  ( 31,54)( 34,56)( 36,59)( 40,60)( 43,62)( 45,65)( 46,66)( 49,68)
  ( 50,71)( 53,72)( 55,73)( 57,74)( 58,77)( 61,78)( 63,79)( 64,80)
  ( 67,82)( 69,85)( 70,86)( 75,89)( 76,90)( 81,92)( 83,93)( 84,94)
  ( 87,96)( 88,98)( 91,100)( 95,102)( 97,103)( 99,104)(101,105),
 ( 1, 9)( 2,20)( 3,23)( 4,28)( 31,36)( 32,47)( 34,61)( 39,62)
  ( 41,63)( 44,64)( 49,66)( 51,67)( 56,69)( 57,71)( 58,78)( 59,83)
  ( 60,90)( 73,94)( 77,97)( 81,100)( 85,103)( 89,106)( 93,109)( 95,112)
  ( 98,114)(101,115)(104,117)(107,118)(110,120),
 ( 1, 7)( 2,10)( 3,14)( 4,21)( 5,27)( 32,37)( 35,57)( 36,59)
  ( 41,61)( 44,65)( 45,66)( 50,69)( 51,70)( 54,78)( 55,87)( 71,89)
  ( 74,92)( 77,95)( 80,98)( 83,101)( 86,104)( 91,109)( 94,111)( 97,115)
  (100,117)(103,121)(106,123),( 1,8)( 3,12)( 4,16)( 6,20)( 9,21)(11,22)
  (13,23)(15,24)(17,25)(19,26),( 1,40)( 2,41)( 5,43)( 7,45)
  ( 10,48)( 11,49)( 13,51)( 15,52)( 18,57)( 21,60)( 23,61)( 26,63)
  ( 27,65)( 30,68)( 33,70)( 36,73)( 46,75)( 53,77)( 56,79)( 66,82)
  ( 72,85)( 76,87)( 80,90)( 83,93)( 86,96)( 88,99)( 91,100)( 94,101)
  ( 97,102),( 1,2)( 4,5)( 7,8)(10,11)(12,13),
 ( 1,9)( 3,10)( 6,13)( 8,14),( 1,6)( 2,9)(16,28)(19,30)(23,35)(24,41)
  (25,45)(26,51)(32,52)(34,54)(38,56)(42,59)(44,61)(48,64)(53,76)(57,77)
  (62,78),( 1,9)( 2,17)( 3,28)( 5,37)( 7,39)(11,42)(12,44)(14,46)(16,48)
  (18,50)(20,52)(21,54)(22,57)(24,59)(25,61)(35,88)(36,90)(47,91)(49,93),
 ( 1,9)( 3,10)( 5,13)( 7,15)(18,24)(20,29),
 ( 1,45)( 3,46)( 6,48)( 8,50)(10,52)(12,54)(14,56)(16,57)(18,59)(20,60)
  (22,62)(24,63)(26,65)(28,67)(31,69)(33,71)(35,73)(37,74)(40,76)(42,77),
 ( 1, 2)( 5, 6)( 7, 8)( 10,11)( 12,13)( 16,17)( 18,19)( 21,22)
  ( 30,31)( 33,34)( 35,36)( 38,39)( 40,41)( 43,44)( 45,46)( 48,49)
  ( 50,51)( 53,54)( 55,56)( 58,59)( 60,61)( 63,64)( 65,66)( 68,69)
  ( 71,72)( 73,74)( 77,78)( 79,80)( 83,84)( 85,86)( 89,90)( 91,92)
  ( 95,96)( 97,98)(101,102)(103,104),( 1,17)( 4,19)( 6,25)( 7,27)( 9,29)
  (12,33)(13,37)(16,39)(21,41)(24,43)(31,45)(36,47),
 ( 1,3)( 8,9)(11,12)(13,14)(16,17)(19,20)(21,22)(23,24)(25,26),
 ( 1,23)( 3,24)( 4,25)( 6,26)( 8,30)( 9,31)(11,32)(13,33)(14,34)(16,38)
  (18,39)(19,40)(21,42)(27,43)(29,44)(35,47)(37,48)(41,51)(45,54)(49,55)
  (52,56),( 1,10)( 2,14)( 3,18)( 5,19)( 8,21)(15,27)(22,34)(28,37),
 ( 1,10)( 3,13)( 6,17)( 8,20)(12,22)(18,24),
 ( 1,15)( 6,17)( 7,19)( 11,22)( 14,24)( 18,38)( 21,39)( 23,40)
  ( 26,41)( 28,44)( 29,45)( 31,49)( 33,52)( 35,54)( 37,58)( 43,65)
  ( 48,67)( 51,68)( 57,71)( 66,86)( 70,88)( 74,90)( 77,91)( 82,95)
  ( 87,100)( 89,101)( 94,104)(107,113)(109,115),
 ( 1,8)( 3,9)( 5,11)( 7,13)(10,14)(12,15),
 ( 1,12)( 3,20)( 4,28)( 6,35)(11,45)(16,46)(19,47)(23,49)(25,50)(27,52)
  (31,53)(34,54)(38,55)(41,57)(44,59)(51,60)(58,61),
 ( 1,10)( 2,14)( 3,16)( 4,24)( 5,28)( 6,33)( 7,36)( 9,37)(11,41)(13,44)
  (18,47)(21,50)(22,53)(25,56)(27,57)(29,60)(31,61)(34,62)(40,63)(42,64)
  (43,67)(45,68)(49,69)(51,70)(52,73)(54,74)(58,75)(65,77)(71,79),
 ( 1,7)( 2,13)( 3,24)( 9,26)(12,27)(19,29)(21,30),
 ( 1,2)( 3,4)( 6,8)( 9,10)(11,13)(14,15)(16,17)(18,19)(20,21)(22,23)
  (24,25)(26,28)(35,36)(37,38)(39,40)(41,42)(43,44)(45,46)(49,50)(51,52)
  (53,54)(55,56)(57,58)(59,60),( 1,42)( 4,43)( 5,47)( 8,48)(11,49)(12,51)
  (15,54)(17,57)(20,58)(21,60)(24,61)(26,65)(29,66)(32,67)(33,69)(36,73)
  (39,74)(44,76)(52,78)(55,80)(62,82)(70,84)(71,86),
 ( 1,4)( 2,9)( 3,14)( 7,20)(10,26)(15,28)(18,34),
 ( 1,11)( 2,17)( 3,24)( 4,28)( 5,31)( 32,49)( 35,56)( 36,57)
  ( 41,60)( 42,61)( 45,65)( 50,67)( 51,69)( 54,72)( 55,81)( 73,91)
  ( 76,94)( 79,97)( 82,100)( 85,103)( 88,106)( 89,108)( 92,110)( 95,114)
  ( 98,116)(101,120)(104,122),( 1,9)( 3,11)( 5,13)( 6,15)( 8,17)(10,27)
  (12,28)(14,29)(19,32)(22,34)(25,36),( 1,3)( 5,7)( 9,11)(16,17)(25,27)
  (29,30)(32,34)(35,36),( 1,29)( 2,30)( 4,33)( 5,34)( 6,35)( 8,36)( 9,37)
  (11,39)(12,40)(14,41)(15,43)(17,46)(23,49)(24,50)(28,52)(31,54)(32,55)
  (38,57)(42,59)(48,63)(51,66)(53,67)(56,68)(58,69),
 ( 2,10)( 3,13)( 4,14)( 5,16)( 8,18)( 9,20)(12,22)(17,23)(19,24)(21,25),
 ( 1,2)( 4,5)( 8,9)(20,21)(24,25)(27,28)(31,32)(45,46)(47,48)(49,50)
  (56,57)(62,63)(64,65)(66,67)(74,75)(77,78)(79,80)(82,83)(84,85),
 ( 1,12)( 2,23)( 4,47)( 7,48)( 11,51)( 15,52)( 18,53)( 20,54)
  ( 25,57)( 27,58)( 32,60)( 36,64)( 38,65)( 42,69)( 46,73)( 49,75)
  ( 56,79)( 59,82)( 61,90)( 62,92)( 66,94)( 67,96)( 70,98)( 71,100)
  ( 76,101)( 80,102)( 83,103)( 85,104)( 87,105),
 ( 1,17)( 4,18)( 5,19)( 8,21)( 9,23)(11,24)(14,25)(16,27)(22,39)(26,41)
  (30,45)(48,60)(53,64)(59,68)(63,70)(67,71),
 ( 1,6)( 2,10)( 3,23)( 4,28)(29,42)(30,46)(31,60)(32,64)(33,69)(38,72)
  (39,73)(44,76)(45,78)(50,81)(51,82)(56,85)(57,87)(62,90)(63,91)(68,94),
 ( 1,8)( 2,14)( 3,19)( 5,21)( 6,24)(10,25)(11,28)(15,29)(18,32),
 ( 1,27)( 3,29)( 6,30)( 7,32)(10,33)(12,34)(13,35)(16,37)(17,43)(18,45)
  (19,47)(20,48)(21,52)(22,53)(23,54)(24,56)(25,57)(26,59)(38,60)(39,62)
  (40,65)(41,67)(42,70)(44,72)(50,73)(51,75)(63,76)(64,78)(68,79)(69,81),
 ( 1, 8)( 2,14)( 3,16)( 4,21)( 5,28)( 35,44)( 36,59)( 41,61)
  ( 42,62)( 47,64)( 50,65)( 51,66)( 56,67)( 57,76)( 58,85)( 68,87)
  ( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 88,104)( 91,106)( 94,107)
  ( 97,109)(100,110)(103,112),( 1,13)( 2,14)( 3,17)( 4,21)( 5,24)( 6,26)
  ( 7,28)( 8,31)( 9,34)(10,36)(11,37)(12,39)(16,43)(18,44)(20,45)(29,50)
  (30,51)(32,52),( 1,22)( 3,25)( 5,28)( 6,29)( 8,30)( 9,33)(11,36)(12,37)
  (14,38)(16,41)(17,44)(19,45)(21,46)(23,47)(27,48)(31,49)(35,50)(39,51)
  (43,52),( 1,2)( 8,9)(14,15)(18,20)(27,28)(30,32)(34,35)(38,39)(42,43)
  (45,46)(49,50)(52,53),( 1,23)( 2,25)( 4,28)( 5,29)( 7,30)( 8,31)(10,34)
  (12,35)(13,36)(15,37)(17,39)(18,42)(20,43)(22,44)(27,45)(33,47)(41,49),
 ( 1,17)( 3,18)( 4,20)( 6,21)( 7,22)( 9,24)(10,25)(13,27)(14,28)(16,29),
 ( 1,3)( 2,8)( 4,11)( 9,14)(10,16)(12,18)(15,20)(17,22),
 ( 1,13)( 3,14)( 4,16)( 6,17)( 8,18)( 9,20)(10,21)(12,24)(15,25)(19,28)
  (22,31)(26,32)(29,33),( 1,3)(11,12)(13,14)(15,16)(17,18)(19,20)(26,27)
  (28,29)(30,31),( 1,23)( 3,25)( 5,28)( 8,29)(11,30)(13,32)(16,35)(18,36)
  (21,37)(26,38)(33,39),( 1,5)( 2,8)( 3,10)( 9,23)(12,25),
 ( 1,11)( 3,15)( 5,19)( 8,27)(10,43)(13,46)(14,47)(18,48)(21,49)(23,52)
  (24,53)(26,54)(29,55)(37,62)(41,69)(45,73)(51,74)(57,77)(65,80),
 ( 1,17)( 2,26)( 3,29)( 4,33)( 9,38)(10,40)(11,41)(12,43)(13,44)(16,46)
  (18,48)(21,50)(22,51)(25,53)(27,55)(30,57)(32,59)(39,64)(42,66)(45,67)
  (49,68)(52,69)(56,70)(58,71)(63,72)(65,73),
 ( 1,2)( 7,8)( 9,10)(13,14)(15,16)(17,18),
 ( 1,7)( 2,14)( 3,28)( 4,31)(34,44)(35,47)(36,59)(37,62)(40,68)(41,70)
  (45,73)(46,74)(50,75)(51,77)(55,80)(56,81)(60,82)(61,84)(65,87)(66,88),
 ( 1,8)( 2,22)( 3,25)( 4,30)(34,39)(35,42)(36,54)(37,57)(40,70)(41,71)
  (45,72)(46,74)(50,77)(51,78)(55,79)(56,81)(60,84)(61,85)(65,86)(66,88),
 (1,5)(3,7)(4,8),( 1,13)( 4,15)( 6,17)( 7,19)( 8,20)(10,22)(11,23)(14,24)
  (16,25)(18,26)(21,27),( 1,28)( 3,29)( 4,30)( 5,31)( 7,34)( 8,35)(10,36)
  (11,38)(13,39)(14,40)(16,42)(20,45)(21,48)(25,50)(32,52)(33,53)(37,55)
  (41,57)(47,63)(49,64)(51,69)(54,72)(56,73)(58,74)(60,75)(62,76)(66,77)
  (68,78)(71,79),( 1,8)( 3,11)( 4,12)( 5,15)( 7,16)(10,17)(14,18),
 ( 1,28)( 3,29)( 4,31)( 7,33)( 9,34)(11,35)(12,37)(15,38)(17,44)(18,45)
  (19,46)(20,48)(21,50)(22,52)(23,53)(24,54)(25,56)(26,57)(27,59)(39,60)
  (40,61)(41,64)(42,65)(47,69)(63,72)(67,73)(68,74)(70,75)(71,76),
 ( 1,7)( 4,15)( 6,20)(11,22)(17,24)(19,26)(23,27)(25,28),
 ( 1,5)( 8,11)(12,15)(16,19)(23,25)(29,31)(35,36)(37,39)(43,44)(45,46)
  (47,48)(49,50),( 1,13)( 4,15)( 5,16)( 7,18)( 9,20)(10,21)(12,23)(14,24)
  (17,25)(19,26)(22,27),(1,3)(4,8),( 1,7)( 2,9)( 3,15)( 4,24)( 5,29)
  ( 6,37)(10,43)(12,44)(14,46)(16,47)(19,48)(21,51)(22,52)(25,53)(28,54)
  (31,55)(34,57)(36,58)(38,61)(40,62)(42,63)(45,64)(49,65)(50,66)(56,67)
  (59,68)(60,69),( 1,15)(10,19)(12,21)(20,41)(25,42)(26,45)(27,46)(28,47)
  (30,48)(31,51)(32,52)(33,54)(34,55)(36,56)(37,59)(38,60)(39,62)(40,63)
  (43,67)(44,69)(49,70)(50,72)(53,73)(57,75)(58,77)(61,78)(64,81)(65,83)
  (66,85)(80,86)(82,88)(84,90),( 1,22)( 3,24)( 4,26)( 7,27)( 9,29)(11,31)
  (12,32)(14,34)(16,36)(17,38)(20,40)(23,43)(25,46)(28,47)(30,50)(33,51)
  (35,52)(37,53)(39,56)(41,57)(42,58)(44,59)(45,60)(48,61)(49,62)(54,63)
  (55,64),( 1,3)(14,16)(18,20)(22,23)(24,26)(27,28)(31,32)(33,34)(37,38)
  (39,41)(42,43)(46,47)(49,50)(52,53),( 1, 7)( 2, 9)( 3,13)( 4,19)
  ( 5,23)( 6,29)( 12,37)( 14,38)( 22,44)( 25,46)( 31,52)( 33,55)
  ( 34,56)( 35,57)( 36,60)( 39,61)( 40,64)( 41,65)( 42,66)( 43,67)
  ( 45,68)( 47,71)( 48,72)( 49,73)( 50,75)( 51,76)( 53,77)( 54,80)
  ( 58,82)( 59,83)( 62,85)( 63,88)( 69,92)( 70,93)( 74,95)( 78,98)
  ( 79,99)( 81,100)( 84,101)( 86,102)( 87,103)( 89,104)( 90,105)( 91,106)
  ( 94,108)( 96,109)( 97,110)(107,115)(111,118)(112,119)(113,121)(114,122)
  (116,124)(117,125)(120,127)(123,128)(126,129),
 ( 1,10)( 2,16)( 5,24)( 7,30)(11,37)(14,40)(17,43)(18,46)(21,47)(25,50)
  (27,51)(31,55)(33,56)(38,59)(41,61)(45,66)(54,76)(64,82)(67,84)(74,85)
  (77,87),( 1,22)( 4,25)( 7,26)( 9,29)(12,30)(14,33)(17,34)(20,37)(24,38)
  (28,39)(32,40)(36,41),( 2,14)( 3,17)( 6,27)( 8,33)( 9,34)
  ( 12,37)( 16,40)( 18,42)( 21,44)( 24,45)( 26,49)( 28,51)( 31,52)
  ( 36,60)( 43,68)( 46,71)( 55,79)( 57,80)( 65,85)( 74,93)( 83,98)
  ( 88,102)( 91,103)( 96,105)(100,107),( 1,14)( 3,17)( 5,19)( 6,20)( 8,23)
  (12,26)(15,45)(18,46)(21,47)(25,48)(29,50)(33,53)(36,56)(40,58)(43,61)
  (63,72)(66,74)(69,76),( 1,12)( 2,27)( 3,39)( 5,40)( 7,41)
  ( 9,44)( 11,45)( 14,46)( 16,50)( 17,54)( 20,55)( 22,58)( 23,59)
  ( 26,60)( 28,64)( 30,68)( 34,69)( 36,73)( 38,77)( 43,78)( 47,79)
  ( 49,80)( 51,83)( 52,84)( 57,85)( 61,86)( 63,87)( 65,90)( 66,91)
  ( 70,92)( 72,93)( 74,96)( 75,97)( 82,98)( 89,99)( 95,100),
 ( 1,2)( 4,5)( 9,11)(12,14)(15,16)(17,19)(20,22)(24,25)(26,28)(29,30)
  (32,34)(35,37)(38,39)(40,42)(43,45)(47,48)(49,51)(52,53),
 ( 1,32)( 4,35)( 6,38)( 9,42)( 13,44)( 14,47)( 16,51)( 19,53)
  ( 20,56)( 23,60)( 26,64)( 27,67)( 31,73)( 33,75)( 37,79)( 39,82)
  ( 46,84)( 48,85)( 55,89)( 57,92)( 61,93)( 66,96)( 69,98)( 70,99)
  ( 76,100)( 81,103)( 86,104)( 91,107)( 94,109)(101,111)(105,113),
 ( 1, 2)( 3, 4)( 5, 6)( 8, 9)( 11,12)( 13,14)( 16,17)( 18,19)
  ( 20,21)( 22,23)( 24,25)( 33,34)( 35,36)( 37,38)( 40,41)( 42,43)
  ( 45,46)( 47,48)( 49,50)( 52,53)( 54,55)( 57,58)( 61,62)( 65,66)
  ( 69,70)( 73,74)( 77,78)( 81,82)( 85,86)( 89,90)( 93,94)( 97,98)
  (101,102),( 1,7)( 2,12)( 3,14)( 4,30)(35,47)(36,50)(37,62)(38,65)(39,70)
  (43,72)(44,73)(48,74)(49,76)(53,78)(54,79)(58,80)(59,82)(63,84)(64,85)
  (68,86),( 1,13)( 2,18)( 3,20)( 4,22)( 5,24)( 6,26)( 7,29)( 8,32)( 9,33)
  (10,35)(11,37)(12,38)(14,40)(16,43)(25,47)(27,50)(30,51)(42,56)(49,58),
 ( 1,16)( 2,23)( 3,27)( 4,34)( 6,35)( 8,37)( 10,41)( 15,46)
  ( 17,47)( 20,51)( 22,52)( 36,81)( 40,82)( 43,83)( 48,85)( 50,86)
  ( 54,87)( 58,96)( 62,98)( 66,100)( 70,102)( 74,104)( 78,106)( 95,113)
  ( 97,114)( 99,115)(101,116)(103,117)(105,118),
 ( 1,12)( 2,15)( 3,18)( 4,23)( 5,26)( 6,29)( 7,31)( 8,34)( 9,37)(10,41)
  (14,42)(16,44)(20,46)(21,49)(25,51)(27,53)(33,55)(35,58)(39,60)(47,61)
  (48,63)(56,64)(57,66),( 1,15)( 2,18)( 3,21)( 4,29)( 5,33)
  ( 36,45)( 39,57)( 40,58)( 42,61)( 46,63)( 47,66)( 51,68)( 52,69)
  ( 54,71)( 55,80)( 72,89)( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)
  ( 88,102)( 90,103)( 92,106)( 94,107)( 96,110)( 98,111),
 ( 1,10)( 2,13)( 3,16)( 4,20)( 5,23)( 6,26)( 7,31)( 8,36)(11,42)(15,46)
  (17,47)(19,48)(22,50)(24,51)(28,52)(33,54)(34,55)(37,57)(39,58)(41,59)
  (45,60)(49,63)(56,66)(62,67)(65,68),( 1,11)( 2,14)( 3,20)( 4,23)( 5,28)
  ( 6,31)( 7,36)( 8,39)( 9,41)(13,42)(15,45)(17,47)(19,49)(21,50)(25,51)
  (27,54)(30,56)(33,58)(34,60)(38,61)(43,63)(46,64)(52,66)(57,67),
 ( 1,2)( 4,11)( 7,12)( 8,13)( 9,14)(10,15),
 ( 1,4)( 8,11)(12,15)(17,20)(21,24),( 1,12)( 4,25)( 6,34)( 8,41)( 9,45)
  (13,48)(16,49)(19,50)(22,51)(26,52)(30,55)(32,56)(35,57)(38,58)(42,59)
  (47,60)(54,61),( 1,4)( 2,8)( 3,14)(10,24)(13,26)(18,30)(19,32),
 ( 1, 9)( 3,15)( 6,25)( 7,28)( 11,35)( 14,36)( 16,38)( 18,42)
  ( 21,43)( 24,45)( 26,47)( 30,50)( 33,53)( 41,61)( 44,64)( 51,72)
  ( 58,79)( 67,87)( 75,92)( 77,93)( 81,95)( 84,96)( 89,100)( 98,107)
  (102,109),( 1, 8)( 2,13)( 3,25)( 4,29)( 5,35)( 6,37)( 10,39)
  ( 12,40)( 14,41)( 18,42)( 20,45)( 22,48)( 24,50)( 26,52)( 28,54)
  ( 32,57)( 34,58)( 38,60)( 43,65)( 44,68)( 46,70)( 49,73)( 51,76)
  ( 53,77)( 55,78)( 56,79)( 59,80)( 61,81)( 63,84)( 64,85)( 66,86)
  ( 69,89)( 71,92)( 72,93)( 74,94)( 75,95)( 82,98)( 83,99)( 87,102)
  ( 88,103)( 90,104)( 91,105)( 96,106)( 97,107)(100,108)(101,109),
 ( 1,26)( 4,29)( 7,31)( 9,34)( 11,36)( 13,38)( 15,43)( 16,46)
  ( 17,48)( 18,50)( 19,52)( 20,54)( 22,57)( 23,59)( 24,60)( 27,61)
  ( 28,62)( 32,63)( 35,64)( 37,65)( 39,67)( 40,68)( 41,70)( 42,71)
  ( 45,73)( 47,74)( 49,76)( 51,78)( 53,80)( 56,82)( 58,83)( 66,87)
  ( 69,96)( 72,99)( 75,100)( 77,101)( 79,102)( 81,103)( 84,104)( 86,111)
  ( 89,112)( 91,113)( 93,114)( 95,115)( 98,116)(105,117)(106,118)(107,119)
  (108,120)(109,121)(110,122),( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)(10,31)
  (11,32)(13,33)(15,34)(18,36)(20,37)(22,41)(27,44)(28,45)(29,46)(35,49)
  (38,52)(39,53)(40,54)(42,55)(43,56)(47,57)(48,58)(50,59)(51,60),
 ( 1,14)( 2,16)( 3,17)( 4,19)( 5,22)( 6,25)( 7,27)( 8,29)( 9,32)(10,36)
  (11,39)(12,40)(21,44)(23,45)(24,46)(33,51)(35,52)(37,53),
 ( 1,4)( 3,10)( 6,11)( 8,12),( 1,23)( 3,24)( 6,25)( 8,29)(11,30)(15,31)
  (18,35)(20,36)(27,37)(28,38)(33,39)(34,40),
 ( 1,3)(14,16)(18,20)(23,24)(25,27)(28,29)(31,33)(34,35)(38,39)(40,42)
  (43,44)(47,48)(50,51)(53,54),( 1,17)( 2,25)( 3,35)( 4,42)
  ( 6,45)( 9,46)( 12,48)( 14,51)( 16,54)( 18,55)( 21,57)( 23,58)
  ( 26,60)( 28,63)( 30,65)( 31,68)( 33,69)( 36,71)( 40,73)( 41,74)
  ( 44,76)( 47,77)( 50,78)( 53,80)( 56,82)( 59,83)( 62,85)( 64,87)
  ( 67,89)( 70,91)( 72,93)( 75,96)( 79,98)( 81,100)( 84,102)( 88,104)
  ( 90,106)( 92,108)( 95,110)( 97,113)( 99,115)(103,117)(105,119)(109,120)
  (112,121)(116,122),( 1,8)( 2,13)( 3,16)( 4,30)(34,48)(35,51)(36,63)
  (37,66)(39,68)(40,70)(44,71)(45,72)(49,75)(50,77)(54,78)(55,79)(59,82)
  (60,84)(64,85)(65,86),( 1,8)( 3,9)( 4,10)( 5,11)( 7,14)(13,19)(16,20)
  (18,21),( 1,4)( 2,9)( 3,12)(19,35)(22,36)(25,37)(29,38)(34,39)(41,48)
  (44,49)(46,50),( 1,6)( 2,8)( 4,11)( 9,14)(10,15)(12,16)(13,17),
 ( 1,39)( 4,40)( 7,45)(10,47)(12,49)(13,52)(16,53)(18,55)(21,56)(22,60)
  (24,64)(26,67)(29,69)(32,71)(34,74)(37,75)(41,77)(44,79)(50,80)(57,82)
  (61,86)(63,87)(72,88)(78,91)(83,94),( 1,12)( 3,23)( 6,36)( 7,38)(10,40)
  (13,44)(15,45)(17,50)(18,51)(21,52)(25,54)(27,58)(30,59)(32,63)(34,64)
  (42,67)(48,70)(56,73)(61,75),( 1, 4)( 2,26)( 5,48)( 8,50)
  ( 11,51)( 13,52)( 18,55)( 23,56)( 27,58)( 32,60)( 34,64)( 37,66)
  ( 39,70)( 43,72)( 45,76)( 47,78)( 54,82)( 57,85)( 59,89)( 61,91)
  ( 63,93)( 65,94)( 67,96)( 69,98)( 71,99)( 73,101)( 75,103)( 79,104)
  ( 83,105),( 1,11)( 2,13)( 4,17)( 6,19)(14,22)(21,23),
 ( 2,23)( 5,27)( 9,28)(12,29)(14,33)(17,34)(19,35)(22,36)(25,37)(26,38)
  (31,39)(32,40),( 1,11)( 3,23)( 5,31)( 7,37)( 9,41)(13,43)(16,45)(18,48)
  (21,50)(25,51)(30,54)(33,57)(35,58)(39,62)(47,63)(56,66)(60,69)(65,70)
  (68,71),( 1,30)( 2,31)( 3,33)( 5,35)( 6,37)( 8,40)( 9,41)(10,43)(11,52)
  (12,54)(15,55)(17,57)(18,58)(19,60)(20,61)(21,63)(24,65)(26,67)(27,68)
  (28,70)(32,72)(36,74)(42,76),( 1, 7)( 2,22)( 3,47)( 6,48)
  ( 11,50)( 14,52)( 17,53)( 25,55)( 28,57)( 31,61)( 34,63)( 36,67)
  ( 40,69)( 42,73)( 46,75)( 49,79)( 51,80)( 56,84)( 59,89)( 60,91)
  ( 62,92)( 65,94)( 66,96)( 68,97)( 71,99)( 72,101)( 74,102)( 81,104)
  ( 85,105),( 1,3)( 9,15)(10,16)(12,18)(14,20)(17,21)(19,22),
 ( 1,6)( 2,11)( 4,12)( 8,13)( 9,14)(10,15),
 ( 1,9)( 3,11)( 5,14)( 7,15)(18,23)(20,27),
 ( 1,37)( 5,41)( 6,44)( 9,46)(12,47)(13,49)(16,52)(18,53)(21,57)(22,60)
  (24,62)(26,65)(28,67)(29,68)(31,71)(33,73)(36,76)(40,77)(42,80)(56,83)
  (58,86)(63,88)(78,91)(84,93),( 1,10)( 2,24)( 3,27)( 4,32)(34,43)(35,47)
  (36,58)(37,62)(39,69)(41,70)(44,71)(46,74)(49,76)(51,77)(54,78)(56,81)
  (59,83)(61,84)(64,85)(66,88),( 1, 4)( 2,16)( 3,26)( 5,38)
  ( 7,40)( 9,41)( 10,42)( 12,43)( 13,46)( 17,50)( 19,51)( 21,53)
  ( 23,55)( 28,59)( 44,76)( 47,77)( 48,80)( 56,83)( 57,86)( 78,101)
  ( 84,102),( 1,14)( 3,17)( 6,19)( 8,22)(10,24)(12,26)(16,45)(21,46)(23,47)
  (28,50)(32,53)(35,55)(39,58)(42,60)(49,70)(52,71)(57,72)(61,74)(64,76)
  (67,78),( 1,2)( 3,4)( 5,7)( 8,9)(10,11)(12,13)(14,15)(16,17)(18,19)
  (20,22)(23,24)(25,27)(37,38)(39,40)(41,42)(43,44)(45,46)(47,48)(51,52)
  (53,54)(55,56)(57,58)(59,60)(61,62),( 1,10)( 2,21)( 5,48)( 9,51)
  ( 13,52)( 16,53)( 23,55)( 25,56)( 28,57)( 30,59)( 31,60)( 34,64)
  ( 36,65)( 40,69)( 42,70)( 46,74)( 49,76)( 50,78)( 61,88)( 62,90)
  ( 66,92)( 67,94)( 71,96)( 72,98)( 79,99)( 80,100)( 83,102)(101,104)
  (103,105),( 1, 8)( 4,17)( 5,22)( 7,32)( 11,36)( 12,38)( 13,40)
  ( 16,43)( 18,46)( 19,48)( 21,49)( 24,50)( 33,70)( 34,72)( 35,73)
  ( 39,76)( 41,77)( 44,78)( 45,79)( 51,82)( 52,83)( 74,101)( 80,103),
 ( 1, 9)( 2,24)( 3,47)( 6,49)( 14,51)( 17,52)( 20,54)( 25,56)
  ( 28,57)( 33,60)( 35,64)( 39,66)( 41,70)( 44,72)( 46,76)( 48,78)
  ( 53,82)( 55,83)( 59,90)( 61,91)( 62,93)( 65,95)( 67,96)( 68,98)
  ( 71,100)( 73,101)( 74,103)( 77,104)( 81,105),
 ( 1,7)( 2,12)( 6,24)( 9,26)(11,29)(16,32)(18,33)(20,34)(27,37),
 ( 1, 6)( 2,10)( 3,16)( 4,19)( 5,22)( 36,46)( 38,57)( 40,60)
  ( 43,62)( 45,64)( 48,66)( 51,67)( 53,70)( 55,77)( 56,83)( 72,84)
  ( 74,87)( 76,90)( 78,93)( 80,96)( 82,99)( 85,102)( 88,104)( 91,105)
  ( 94,107)( 97,108)(100,110),( 1,10)( 3,17)( 5,25)( 8,36)(11,40)(14,41)
  (18,42)(21,46)(22,48)(27,52)(30,53)(32,54)(35,58)(38,62)(43,63)(49,65)
  (55,66)(59,68),( 2,14)( 4,20)( 6,25)(10,36)(16,41)(19,42)(21,45)(22,46)
  (26,49)(29,54)(31,55)(33,57)(35,58)(37,59)(40,62)(44,64)(47,66)(51,70)
  (53,71)(56,72)(61,75)(68,78),( 1,4)( 9,12)(17,18)(21,22)(23,24)(27,28)
  (31,32)(34,35)(38,39)(42,43)(46,47)(48,49)(52,53)(56,57)(58,59),
 ( 1,7)( 2,16)( 3,21)( 4,27)( 5,30)( 6,35)( 8,41)( 9,42)(11,43)(13,46)
  (15,47)(18,50)(20,52)(23,55)(24,56)(26,57)(29,58)(31,61)(33,62)(37,64)
  (40,65)(44,66)(49,67)(51,70)(54,71)(59,72)(63,75)(69,76)(74,77),
 ( 1,32)( 5,33)( 8,34)( 13,35)( 23,36)( 26,37)( 29,38)( 40,61)
  ( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)( 51,79)( 52,84)( 53,85)
  ( 57,90)( 58,91)( 59,96)( 68,97)( 71,98)( 80,99)( 83,100)( 92,101)
  ( 95,102),( 1,3)(11,12)(13,14)(15,16)(17,18)(19,20)(23,24)(25,27),
 ( 1, 8)( 2,14)( 3,16)( 4,21)( 5,28)( 35,47)( 38,59)( 39,60)
  ( 44,62)( 45,63)( 50,65)( 53,66)( 54,67)( 57,76)( 58,85)( 68,87)
  ( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 88,104)( 91,106)( 94,107)
  ( 97,109)(100,110)(103,112),( 1,41)( 5,45)( 8,46)(10,48)(14,52)(17,53)
  (19,55)(22,57)(26,59)(29,61)(32,64)(34,67)(38,69)(43,71)(44,73)(47,74)
  (51,77)(54,78)(56,79)(58,81)(60,82)(63,85)(66,86)(68,87)(70,88)(72,89)
  (76,91)(80,92)(84,94)(90,95)(93,96),( 1,13)( 2,16)( 3,20)( 4,22)
  ( 5,28)( 6,31)( 8,34)( 11,39)( 14,45)( 17,46)( 23,49)( 25,51)
  ( 29,56)( 32,58)( 33,59)( 35,61)( 37,62)( 40,65)( 41,67)( 42,70)
  ( 44,72)( 47,75)( 48,76)( 52,79)( 53,81)( 54,84)( 55,87)( 57,88)
  ( 60,89)( 63,90)( 64,91)( 66,92)( 68,94)( 71,95)( 73,96)( 77,98)
  ( 78,99)( 80,100)( 82,102)( 85,103)( 93,105)( 97,106)(101,107)(104,108),
 ( 1,13)( 2,16)( 3,19)( 4,23)( 5,26)( 6,29)( 7,34)( 8,39)( 9,42)(11,43)
  (14,44)(18,48)(20,49)(22,50)(25,52)(27,53)(31,54)(36,56)(37,57)(40,59)
  (47,60)(51,63)(58,66)(62,67)(65,68),( 1,22)( 3,23)( 5,26)( 6,27)( 8,28)
  ( 9,29)(11,32)(13,33)(14,36)(16,37)(17,40)(19,41)(21,44)(24,47)(30,50)
  (34,51)(38,54)(42,55)(45,56)(48,57)(52,58),
 ( 1,23)( 3,24)( 4,27)( 6,29)( 8,30)( 9,32)(11,33)(12,37)(15,39)(16,40)
  (18,43)(20,45)(21,46)(26,47)(28,48)(35,49)(36,50)(42,51)(44,52),
 ( 1,13)( 2,16)( 3,17)( 5,19)( 6,20)( 8,23)( 9,24)(11,26)(14,27)(18,28)
  (21,29)(25,30),( 1,8)( 3,12)( 5,13)( 6,17)( 7,18)(11,22)(16,24)(20,26),
 ( 1,23)( 3,24)( 6,25)( 8,26)(11,30)(13,31)(16,32)(20,35)(27,36)(28,37)
  (33,39)(38,41)(40,42),( 1,13)( 4,19)( 5,23)( 8,25)( 9,29)(12,33)(16,35)
  (18,39)(21,43)(28,47)(31,51)(37,55)(42,57)(45,61)(50,63)(53,67)(59,69)
  (65,71),( 1,8)( 2,13)( 3,16)( 4,30)(34,46)(35,49)(36,61)(37,64)(38,68)
  (42,69)(43,70)(47,73)(48,75)(52,76)(53,77)(57,80)(58,82)(62,83)(63,84)
  (67,87),( 1,7)( 2,9)(11,17)(15,32)(19,34)(29,44)(31,50)(39,51)(41,53)
  (43,55)(45,57)(47,59)(49,61)(54,64)(58,66)(62,68),
 ( 1,20)( 2,23)( 3,26)( 4,28)( 5,30)( 6,32)( 7,35)( 8,38)(10,40)(11,42)
  (12,44)(14,47)(15,50)(16,52)(18,54),( 1,17)( 2,21)( 3,23)( 4,29)
  ( 5,33)( 36,45)( 38,59)( 39,60)( 42,62)( 46,65)( 47,66)( 51,69)
  ( 52,70)( 55,72)( 56,78)( 73,85)( 75,88)( 77,91)( 79,94)( 81,97)
  ( 83,100)( 84,102)( 87,103)( 90,105)( 93,106)( 96,108)( 99,109),
 ( 1,5)( 2,14)( 3,22)( 7,24)(11,25)(18,28)(21,29),
 ( 1,6)( 2,8)( 4,11)( 5,22)( 9,24),( 1,20)( 2,22)( 3,25)( 4,27)( 6,29)
  ( 7,32)( 8,34)( 9,37)(10,39)(11,41)(13,44)(14,46)(15,49)(17,51)(18,53),
 ( 1,2)( 3,4)(13,14)(15,16)(19,20)(23,25)(26,28)(31,32)(35,36)(37,38)
  (42,43),( 1,9)( 3,11)( 5,14)( 7,15)(18,24)(20,28),
 ( 1,8)( 2,15)( 3,23)( 4,31)( 5,38)( 7,45)( 9,46)(11,47)(14,48)(17,50)
  (19,52)(22,53)(25,54)(27,55)(30,57)(33,59)(35,60)(37,61)(40,62)(42,64),
 ( 1,4)(10,11)(14,15)(18,19),( 1,4)( 2,11)( 3,15)( 5,21)(10,23)(14,25)
  (17,27)(20,29)(22,31)(24,33)(28,35),( 1,37)( 4,38)( 6,41)( 9,43)(10,46)
  (12,47)(14,51)(16,54)(17,56)(19,59)(21,61)(24,62)(25,65)(29,66)(30,70)
  (33,73)(36,77)(50,80)(52,83)(57,84)(69,86)(71,89)(75,90),
 ( 1,9)( 4,17)( 6,22)( 8,26)(11,43)(13,44)(14,45)(16,46)(19,49)(21,50)
  (24,51)(25,52)(29,54)(33,61)(38,68)(48,72)(53,74)(55,78)(64,81),
 ( 1,12)( 3,18)( 6,38)( 8,42)(13,44)(16,46)(19,48)(21,52)(23,53)(27,54)
  (30,55)(32,56)(34,58)(36,62)(39,63)(45,64)(49,66)(59,69)(67,71)(70,72),
 ( 1,4)(11,13)(17,20)(21,24)(27,29)(31,32)(37,38)(39,41)(43,45)(48,49)
  (54,56)(58,59)(61,62)(63,65)(69,70)(74,75)(77,79)(82,84)(85,87)(88,90),
 ( 2,10)( 3,13)( 6,17)( 8,20)(12,22)(18,24),
 ( 1,5)( 6,9)(13,17)(18,21)(25,27)(32,34)(41,43),
 ( 1,9)( 2,12)( 4,13)( 7,16),( 1,10)( 2,13)( 3,18)( 4,21)( 5,26)( 6,29)
  ( 7,33)( 8,36)(11,39)(15,40)(16,42)(19,44)(22,48)(24,51)(28,52)(32,53)
  (34,56)(38,57)(43,58)(46,59)(47,61)(50,63)(55,67)(62,71)(65,72)(66,74)
  (69,76)(70,78)(75,80)(79,81),( 1,2)( 4,6)( 8,10)(12,14),
 ( 1,10)( 4,16)( 6,19)( 7,22)( 9,24)(13,25)(17,27),
 ( 1,12)( 2,14)( 3,17)( 4,21)( 5,27)( 6,29)( 7,39)( 8,41)( 9,42)(11,46)
  (16,47)(18,49)(20,51)(22,52)(24,54)(26,55)(30,59)(33,60)(35,62)(36,64)
  (38,65)(44,66)(48,67)(57,68)(61,69),( 2,30)( 4,31)( 5,32)( 8,33)( 9,35)
  (11,37)(14,38)(15,39)(17,42)(18,43)(19,46)(20,47)(21,48)(22,49)(23,51)
  (24,53)(25,56)(26,57)(27,58)(28,59)(40,61)(41,64)(52,67)(62,68)(63,69)
  (65,70)(66,71),( 1, 9)( 3,17)( 6,23)( 7,30)( 8,32)( 10,33)
  ( 12,34)( 13,37)( 14,40)( 15,41)( 18,45)( 19,46)( 21,49)( 36,73)
  ( 39,74)( 42,78)( 43,79)( 48,81)( 50,84)( 51,85)( 77,103)( 83,105),
 ( 1,7)( 2,10)( 3,15)(16,33)(20,35)(24,37)(27,38)(30,40)(42,52)(45,53)
  (49,54),( 1,7)( 3,8)( 4,11)( 6,13)(10,19)(12,21)(15,22)(16,23)(18,24)
  (20,25),( 1,5)( 9,12)(14,17)(19,20),
 ( 1, 6)( 2,11)( 3,20)( 4,26)( 5,31)( 35,48)( 38,57)( 39,59)
  ( 43,62)( 44,64)( 46,65)( 50,69)( 51,71)( 53,73)( 54,82)( 75,92)
  ( 78,94)( 81,96)( 84,98)( 87,100)( 90,102)( 91,103)( 93,105)( 95,106)
  ( 97,108)( 99,109)(101,111),( 1,2)(17,18)(21,22)(25,26)(29,30)(35,36)
  (38,39)(42,43)(45,46)(47,48)(49,50)(53,54)(55,56)(60,61)(62,63)(65,66)
  (67,68),( 1,21)( 2,22)( 3,24)( 4,25)( 5,26)( 6,27)( 7,29)( 8,30)( 9,31)
  (18,33)(19,35),( 1,31)( 2,33)( 4,34)( 5,35)( 7,37)( 8,38)(10,39)(11,40)
  (12,42)(14,43)(15,45)(18,46)(21,47)(25,49)(28,50)(32,52)(36,54)(41,56)
  (44,58)(48,59)(51,60)(53,61)(55,62)(57,63),
 ( 1,8)( 3,10)( 6,18)(11,23)(13,24)(17,26)(19,27),
 ( 1,2)( 7,8)(13,14)(15,16)(19,20)(23,24),
 ( 2,9)( 3,11)( 5,13)(10,15)(12,16),( 1,3)( 4,9)( 7,11),
 ( 1,11)( 3,13)( 4,15)( 6,17)( 8,18)(12,25)(14,26)(16,27)(20,28)(22,29)
  (24,30),( 1,14)( 2,16)( 3,18)( 4,22)( 5,24)( 6,27)( 7,29)( 8,33)( 9,35)
  (10,37)(11,39)(12,40)(17,43)(19,44)(21,45)(30,50)(32,51)(34,52),
 ( 1,22)( 3,23)( 5,24)( 6,27)( 8,30)(10,31)(11,32)(13,35)(14,38)(16,39)
  (17,40)(19,43)(21,46)(25,47)(29,48)(33,49)(37,50)(41,51)(45,52),
 ( 1,7)( 2,10)( 4,13)( 5,14)( 9,15)(12,16),
 ( 1,12)( 2,13)( 4,15)( 5,17)( 7,18)(11,25)(14,26)(16,27)(19,28)(21,29)
  (23,30),( 1,4)( 2,9)( 3,12)( 6,19)(13,24)(16,30)(27,39)(32,42)(35,44),
 ( 1,23)( 3,24)( 4,25)( 6,27)( 8,30)( 9,31)(11,32)(13,33)(14,35)(15,38)
  (17,39)(18,40)(20,41)(21,44)(28,45)(36,47)(42,49),( 1,4)( 2,8)( 5,10),
 ( 1, 6)( 2,13)( 3,17)( 4,23)( 5,30)( 8,36)( 10,38)( 12,40)
  ( 14,43)( 16,45)( 20,52)( 22,54)( 27,57)( 29,60)( 32,61)( 33,63)
  ( 35,65)( 37,66)( 39,67)( 42,69)( 44,71)( 46,73)( 47,76)( 48,77)
  ( 49,79)( 51,81)( 55,83)( 56,85)( 58,87)( 59,90)( 64,92)( 68,93)
  ( 70,94)( 72,95)( 75,97)( 80,99)( 82,100)( 84,101)( 86,102)( 89,104)
  ( 91,105)( 96,106)( 98,107)(103,108),( 1,20)( 2,23)( 6,28)( 9,29)(10,32)
  (12,35)(15,38)(17,39)(22,40)(25,41)(31,42)(34,43),
 ( 1,13)( 2,15)( 3,16)( 4,18)( 5,21)( 6,23)( 7,26)( 8,29)( 9,31)(10,35)
  (11,38)(12,39)(20,43)(22,45)(24,46)(32,49)(34,51)(37,52),
 ( 1,13)( 2,15)( 4,17)( 5,18)( 7,20)( 8,23)(10,24)(11,25)(14,27)(19,29)
  (21,30)(26,31)(28,32),( 1,13)( 2,15)( 4,16)( 5,17)( 7,19)( 8,22)(10,23)
  (11,24)(14,27)(18,30)(20,31)(25,32)(28,33),
 ( 1,2)( 7,8)(10,11)(15,16)(17,18)(22,23)(25,26)(31,32)(38,39)(42,43)
  (45,46)(51,52)(53,54)(56,57)(59,60)(62,63)(68,69)(70,71)(73,74)(75,76)
  (78,79)(82,83),( 1,2)( 3,4)(13,15)(16,18)(21,22)(25,26)(27,28)(32,33)
  (37,38)(39,40)(43,44),( 1,4)( 6,9)(11,14)(16,18)(28,29)(37,38)(43,44),
 ( 1,12)( 3,18)( 5,26)( 8,33)( 11,36)( 14,37)( 17,40)( 20,42)
  ( 21,43)( 25,49)( 29,50)( 30,51)( 34,55)( 39,60)( 44,65)( 45,66)
  ( 63,78)( 67,83)( 68,84)( 74,86)( 81,89)( 85,94)( 87,98)( 92,100)
  ( 96,102),( 1,8)( 3,9)( 6,10)(11,20)(14,22)(16,24),
 ( 1,5)( 4,8)(14,25)(16,26)(18,32)(20,38)(22,44)(29,53)(33,57)(37,61)
  (41,65)(45,69)(49,73)(50,74)(56,77)(58,78)(64,81)(66,82)(72,85),
 ( 1,12)( 2,28)( 3,44)( 4,45)( 7,46)( 8,48)(10,50)(13,51)(15,53)(17,54)
  (20,55)(23,57)(25,58)(27,60)(29,61)(32,62)(35,64)(36,66)(39,67)(40,69)
  (42,70)(47,71)(49,73)(52,74)(56,76)(59,77)(63,78)(65,80)(68,81)(72,82)
  (75,83)(79,84),( 2,9)( 4,20)( 7,21)(12,23)(13,25)(15,27)(16,29)(18,31)
  (19,33),( 1,10)( 4,18)( 5,22)( 7,27)(11,45)(13,46)(15,49)(19,50)(20,51)
  (23,52)(25,55)(28,56)(30,57)(33,59)(38,63)(47,72)(53,73)(70,78)(75,79)
  (77,80),( 1,2)( 8,10)(12,14)(16,18)(24,25)(29,30)(32,33)(37,38)(40,41)
  (44,45),( 1,12)( 2,15)( 3,16)( 4,22)( 5,25)(11,38)(13,42)(14,45)(18,46)
  (19,49)(21,52)(24,53)(26,58)(28,59)(29,61)(33,66)(35,69)(37,70)(39,73)
  (41,74)(43,75)(47,76)(50,77)(54,78)(56,79)(60,80)(62,81)(67,82)(71,83),
 ( 2,14)( 3,15)( 6,20)( 7,21)( 8,26)(11,27),
 ( 1,11)( 2,15)( 3,19)( 4,21)( 5,24)( 6,29)( 7,30)( 8,35)( 9,38)(12,40)
  (13,41)(17,43)(18,44)(22,46)(26,48)(28,49)(31,51)(33,54)(37,58)(52,67)
  (57,68)(59,69)(62,70)(63,71)(66,72),( 1,2)( 8,10)(14,15)(18,19)(24,25)
  (28,30)(31,33)(34,36),( 1,16)( 2,22)( 4,36)( 6,37)( 8,38)
  ( 9,39)( 14,44)( 18,47)( 20,48)( 23,49)( 27,54)( 28,57)( 40,74)
  ( 41,77)( 42,78)( 45,80)( 50,82)( 51,84)( 55,86)( 60,94)( 62,97)
  ( 66,102)( 70,105)( 79,107)( 85,109)(110,127)(112,128)(114,129)(116,130)
  (118,131)(120,132),( 1,23)( 2,25)( 3,28)( 5,29)( 6,30)( 8,31)( 9,34)
  (11,35)(13,36)(14,37)(16,39)(18,42)(19,43)(21,44)(26,45)(32,47)(40,49),
 ( 1,7)( 2,9)( 4,11)( 5,13)( 8,16)(12,18)(15,20)(17,21)(19,22),
 ( 1,20)( 2,21)( 3,23)( 4,24)( 5,25)( 6,27)( 7,28)( 8,30)( 9,31)(10,32),
 ( 1, 8)( 2,22)( 3,31)( 5,42)( 7,45)( 9,47)( 12,48)( 14,50)
  ( 17,52)( 18,55)( 20,57)( 23,58)( 26,59)( 27,61)( 29,64)( 32,65)
  ( 34,68)( 36,70)( 38,71)( 41,73)( 44,74)( 46,76)( 51,77)( 54,78)
  ( 56,80)( 62,81)( 63,83)( 67,85)( 69,87)( 72,89)( 75,92)( 79,95)
  ( 84,97)( 86,99)( 90,101)( 93,102)( 96,103)(100,104),
 ( 1,16)( 2,22)( 3,25)( 4,32)( 9,38)(10,40)(11,41)(12,43)(14,44)(15,45)
  (18,47)(19,48)(21,51)(26,53)(28,54)(29,55)(31,58)(39,63)(42,65)(46,67)
  (49,68)(52,69)(56,70)(59,71)(64,72)(66,73),
 ( 1,16)( 2,21)( 3,26)( 4,29)( 9,41)(10,43)(11,44)(12,46)(13,47)(15,49)
  (18,50)(19,51)(23,52)(24,53)(27,55)(28,56)(31,57)(32,58)(35,59)(42,60)
  (45,61),( 2,14)( 4,19)( 5,23)( 7,28)(10,48)(13,49)(16,51)(18,53)(21,54)
  (25,55)(27,57)(29,59)(30,60)(34,62)(41,64)(50,66)(56,67)(61,77)(63,78)
  (65,79),( 1,6)( 2,11)( 3,19)( 8,25)(13,27)(18,28)(23,30),
 ( 1,26)( 3,28)( 4,29)( 5,31)( 7,33)( 8,34)(10,36)(11,37)(13,46)(14,47)
  (15,49)(17,51)(18,54)(19,55)(20,57)(21,59)(22,61)(23,62)(24,64)(25,66)
  (27,68)(32,70)(35,72),( 1,4)( 8,11)(13,16)(18,21)(25,26)(31,32)(39,40),
 ( 1,26)( 2,27)( 4,29)( 5,31)( 6,33)( 7,35)( 8,37)( 9,39)(11,40)(12,42)
  (13,44)(15,49)(19,53)(20,55)(21,59)(23,61)(25,65)(28,67)(34,68)(41,69),
 ( 1,12)( 4,23)( 7,33)( 9,37)( 11,39)( 13,40)( 15,42)( 17,43)
  ( 19,47)( 20,48)( 22,49)( 24,53)( 36,68)( 38,72)( 41,74)( 46,75)
  ( 52,79)( 54,80)( 57,84)( 60,89)( 66,96)( 71,102)( 73,104)( 78,106)
  ( 85,121)( 87,123)( 90,124)( 94,125)( 97,126)(100,127)(103,131)(105,132),
 ( 1,3)( 5,7)(11,12)(23,24)(28,29)(30,31)(32,33)(34,35),
 ( 1,12)( 2,13)( 3,16)( 4,20)( 5,23)( 6,25)( 7,28)( 8,31)( 9,33)(10,36)
  (17,42)(18,43)(22,47)(26,52)(30,55)(34,57)(38,60)(41,61)(44,63)(46,64)
  (50,68)(51,69)(54,70)(56,71)(59,74)(65,76)(67,77)(72,79),
 ( 1,14)( 2,16)( 3,17)( 4,20)( 5,24)( 6,26)( 7,29)( 8,32)( 9,34)(10,37)
  (11,39)(12,40)(18,43)(21,44)(23,46)(31,49)(33,50)(35,52),
 ( 1,11)( 3,13)( 4,15)( 6,17)( 8,19)(10,22)(12,24)(14,25)(16,26),
 ( 1,7)( 2,9)( 5,10),( 1, 7)( 2, 9)( 10,37)( 11,40)( 12,41)
  ( 14,42)( 17,45)( 20,46)( 21,50)( 22,51)( 24,52)( 26,53)( 34,69)
  ( 38,71)( 43,73)( 47,75)( 48,76)( 54,79)( 56,82)( 60,87)( 63,90)
  ( 65,95)( 70,100)( 74,102)( 77,104)(101,120)(103,121)(106,122)(108,123)
  (110,124)(112,127)(114,128)(126,137)(134,138)(136,139),
 ( 1,13)( 4,20)( 6,25)( 8,30)(10,45)(12,46)(15,49)(16,50)(19,51)(22,52)
  (24,55)(27,56)(29,57)(33,59)(42,69)(48,73)(54,74)(61,76)(67,78),
 ( 1,11)( 2,16)( 3,24)( 6,25)(12,27)(17,28)(22,30),
 ( 1,4)( 7,9)( 8,11)(10,13)(12,14),( 1,9)( 3,11)( 4,12)( 5,13)( 6,14)
  ( 8,15),( 1,10)( 2,14)( 3,18)( 4,20)( 5,23)( 6,28)( 7,29)( 8,34)( 9,37)
  (11,40)(12,41)(16,43)(17,44)(21,46)(25,48)(27,49)(30,51)(32,54)(36,58)
  (52,67)(57,68)(59,69)(62,70)(63,71)(66,72),
 ( 1,4)( 7,9)(10,11)(13,14)(16,17)(20,21),
 ( 1,7)( 2,14)( 3,19)( 5,22)( 9,24)(11,25)(15,27)(18,28)(21,30),
 ( 1,10)( 2,14)( 3,17)( 4,18)( 5,23)( 6,25)( 7,28)( 8,31)( 9,33)(12,36)
  (13,37)(20,44)(22,45)(26,49)(30,54)(34,56)(38,60)(39,61)(43,63)(46,66)
  (50,67)(51,68)(55,70)(57,73)(62,74)(65,75)(69,76)(72,78),
 ( 1,22)( 3,25)( 4,28)( 6,29)( 8,30)( 9,33)(11,36)(12,37)(14,38)(16,41)
  (17,42)(19,45)(21,46)(23,47)(26,48)(31,49)(34,50)(39,51)(43,52),
 ( 1,11)( 2,16)( 3,21)( 4,24)( 5,27)( 6,31)( 7,34)( 8,37)(10,42)(13,44)
  (14,45)(19,47)(23,48)(25,49)(28,51)(30,52)(32,53)(36,57)(39,58)(41,59)
  (43,60)(50,63)(54,66)(61,67)(64,68),( 1,9)( 5,13)( 7,15)(16,22)(17,24)
  (18,28)(19,30),( 1,5)( 2,10)( 3,20)( 6,22)( 8,23)(13,25)(14,26)(19,28)
  (24,30)(27,31)(29,32),( 1,2)(10,11)(13,14)(15,16)(18,19)(20,21)(22,23)
  (24,25)(26,27),( 1,6)( 2,26)( 3,36)( 5,43)( 7,46)( 9,47)(11,48)(14,51)
  (16,53)(18,56)(20,58)(22,59)(25,62)(28,64)(30,67)(31,68)(33,70)(35,71)
  (38,74)(40,75)(42,77)(45,78)(49,79)(52,81)(55,82)(57,83)(60,84)(63,86)
  (66,87)(69,88)(72,89)(76,90)(80,91)(85,92),
 ( 1,7)( 2,21)( 3,28)( 4,33)(34,43)(35,46)(36,58)(37,61)(39,68)(40,69)
  (44,72)(45,74)(49,75)(50,76)(54,79)(55,81)(59,82)(60,83)(64,86)(65,88),
 ( 1,9)( 2,12)( 4,15)( 7,19)(13,22)(18,24),
 ( 1,36)( 4,39)( 6,40)( 9,42)( 12,44)( 14,48)( 16,51)( 20,52)
  ( 22,55)( 26,57)( 27,59)( 29,63)( 32,66)( 33,68)( 34,71)( 38,73)
  ( 45,76)( 46,78)( 54,82)( 60,85)( 61,87)( 74,91)( 75,94)( 79,96)
  ( 80,99)( 83,101)( 84,104)( 88,106)( 89,109),
 ( 1,2)( 4,5)( 8,9)(20,21)(24,25)(27,28)(37,38)(45,46)(47,48)(49,50)
  (54,55)(62,63)(64,65)(66,67)(71,72)(74,75)(78,79)(82,83),
 ( 1,12)( 2,15)( 3,18)( 5,19)( 6,20)( 7,21)( 9,24)(10,25)(13,26)(16,27)
  (22,30)(28,33)(31,34),( 1,10)( 4,17)( 5,20)( 8,32)( 9,33)
  ( 11,35)( 12,37)( 14,40)( 18,44)( 23,48)( 24,51)( 25,52)( 36,71)
  ( 38,72)( 39,74)( 41,75)( 42,76)( 46,79)( 47,80)( 49,81)( 50,82)
  ( 77,102)( 83,104),( 1,10)( 2,21)( 5,47)( 9,50)( 13,51)( 16,52)
  ( 18,53)( 23,56)( 25,57)( 30,59)( 31,60)( 35,64)( 37,65)( 41,69)
  ( 45,73)( 48,75)( 55,79)( 58,82)( 61,90)( 62,92)( 66,94)( 67,96)
  ( 70,98)( 71,100)( 76,101)( 80,102)( 83,103)( 85,104)( 87,105),
 ( 1,24)( 2,25)( 3,26)( 5,27)( 7,30)( 8,32)(10,33)(12,34)(13,35)(15,38)
  (17,40)(18,41)(20,42)(21,45)(28,46)(36,47)(43,48),
 ( 1,7)( 3,10)( 5,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 1,10)( 2,13)( 3,16)( 4,30)( 5,34)( 36,46)( 38,57)( 40,60)
  ( 43,62)( 45,64)( 48,66)( 51,67)( 53,70)( 55,77)( 56,83)( 72,84)
  ( 74,87)( 76,90)( 78,93)( 80,96)( 82,99)( 85,102)( 88,104)( 91,105)
  ( 94,107)( 97,108)(100,110),( 1,7)( 3,10)( 5,11)( 8,12),
 ( 1,2)( 4,6)( 9,10)(11,12)(14,15)(16,17),
 ( 1, 9)( 2,20)( 3,23)( 4,28)( 31,33)( 32,44)( 36,61)( 38,62)
  ( 41,63)( 46,65)( 48,66)( 53,68)( 55,69)( 57,71)( 58,78)( 59,83)
  ( 60,90)( 73,94)( 77,97)( 81,100)( 85,103)( 89,106)( 93,109)( 95,112)
  ( 98,114)(101,115)(104,117)(107,118)(110,120),
 ( 1,2)( 4,6)(10,11)(13,14),( 1,4)( 9,12)(19,20)(24,25)(27,28)(33,34)
  (36,37)(38,39)(40,41)(43,44)(45,46)(50,51)(52,53)(54,55)(57,59)(60,61)
  (62,63)(65,66)(67,68)(70,71)(73,74)(76,77)(79,80),
 ( 2,9)( 4,11)( 7,15)( 8,18)(12,22)(17,24),
 ( 1, 9)( 2,19)( 3,27)( 4,41)( 8,43)( 11,45)( 13,46)( 14,49)
  ( 16,51)( 18,54)( 21,56)( 23,57)( 26,59)( 28,60)( 30,63)( 32,66)
  ( 35,68)( 38,69)( 40,72)( 42,75)( 44,77)( 47,79)( 50,81)( 52,83)
  ( 55,85)( 58,86)( 61,88)( 64,90)( 67,91)( 70,92)( 73,94)( 76,95)
  ( 78,97)( 80,99)( 84,101)( 87,103)( 89,105)( 93,107)( 98,109)(100,111)
  (104,113)(106,115)(108,118)(112,120)(116,121)(119,122),
 ( 1, 8)( 2,14)( 3,16)( 4,20)( 5,34)( 36,46)( 39,58)( 40,59)
  ( 44,62)( 45,63)( 49,66)( 52,68)( 53,69)( 55,77)( 56,83)( 72,85)
  ( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)( 86,103)( 89,104)( 92,106)
  ( 95,107)( 98,109)(101,110),( 1,3)( 4,9)( 6,10)( 8,12)(11,14)(13,15),
 ( 1, 8)( 2,14)( 4,22)( 9,35)( 15,39)( 16,41)( 18,44)( 20,47)
  ( 23,50)( 25,51)( 28,53)( 30,55)( 36,58)( 42,62)( 45,66)( 49,71)
  ( 52,75)( 56,79)( 59,81)( 67,85)( 69,87)( 73,92)( 83,99)( 88,102)
  ( 90,104)( 94,107)( 96,110)( 98,113)(105,118)(108,122)(111,126)(115,131)
  (120,135)(123,137)(127,139)(129,141)(133,145)(142,151)(146,153),
 ( 1,39)( 3,41)( 5,44)( 8,46)(11,47)(13,51)(16,55)(17,58)(20,59)(23,60)
  (26,62)(28,63)(29,67)(32,71)(34,74)(37,75)(42,76)(48,78)(52,82)(54,83)
  (64,85)(68,89)(70,90)(80,91)(87,92),( 1,23)( 3,24)( 6,27)( 9,28)(11,29)
  (13,30)(15,33)(18,35)(20,36)(26,38)(32,40),
 ( 1, 6)( 2,14)( 3,18)( 4,22)( 5,25)( 8,34)( 9,36)( 12,37)
  ( 15,41)( 17,42)( 21,45)( 23,46)( 26,50)( 30,56)( 31,57)( 33,59)
  ( 35,60)( 39,66)( 40,68)( 43,70)( 44,71)( 47,77)( 48,79)( 52,81)
  ( 54,82)( 55,84)( 58,86)( 61,87)( 62,89)( 65,91)( 67,92)( 69,93)
  ( 72,94)( 73,96)( 76,98)( 78,99)( 80,100)( 83,101)( 85,102)( 88,103)
  ( 90,104)( 95,105)( 97,106),( 1,4)( 9,11)(13,15),( 1,3)( 7,8)(11,12),
 ( 1,2)( 5,7)( 9,10)(21,22)(27,28)(34,35)(40,41)(46,47)(48,49)(52,53)
  (54,55)(57,58)(59,60)(62,63)(64,65),( 1,11)( 2,13)( 3,18)( 4,20)
  ( 5,23)( 6,26)( 7,30)( 8,32)( 9,34)( 15,39)( 16,41)( 25,46)
  ( 28,48)( 35,54)( 36,55)( 37,57)( 38,59)( 42,62)( 43,65)( 44,67)
  ( 45,68)( 47,69)( 50,73)( 51,75)( 52,76)( 53,78)( 60,80)( 61,82)
  ( 63,83)( 64,85)( 71,88)( 72,90)( 79,94)( 86,97)( 87,99)( 91,101)
  ( 92,103)( 93,104)( 95,105)( 96,106)(100,108)(107,110)(109,111),
 ( 1,17)( 2,22)( 3,26)( 4,29)( 9,39)(10,40)(11,42)(12,43)(13,44)(16,47)
  (18,48)(21,50)(23,51)(25,54)(28,56)(30,57)(33,59)(38,63)(41,65)(45,67)
  (49,68)(52,69)(55,70)(58,71)(64,72)(66,73),( 1,7)( 2,10)( 4,12)( 5,13),
 ( 2,28)( 5,29)( 6,31)( 8,32)(10,33)(13,35)(14,37)(16,38)(17,43)(18,45)
  (19,46)(20,48)(21,49)(22,50)(23,52)(24,54)(25,56)(26,57)(27,58)(39,63)
  (40,64)(41,67)(42,68)(55,69)(60,72)(61,73)(65,74)(70,75)(71,76),
 ( 1,8)( 3,12)( 9,15)(11,18)(13,21)(16,23)(19,25),
 ( 1,12)( 3,24)( 5,34)( 6,36)( 9,37)(11,40)(13,42)(19,46)(20,47)(22,48)
  (25,50)(26,52)(28,53)(30,57)(32,58)(38,63)(44,69)(51,77)(54,83),
 ( 1,10)( 2,14)( 3,17)( 4,21)( 29,34)( 30,45)( 31,48)( 32,59)
  ( 37,62)( 39,64)( 44,67)( 46,69)( 50,70)( 55,73)( 57,82)( 58,91)
  ( 75,95)( 78,99)( 81,103)( 84,107)( 87,111)( 90,115)( 92,116)( 96,118)
  (100,119)(104,121)(108,122)(112,124),( 1,7)( 2,11)( 5,12)( 8,13)( 9,14)
  (10,15),( 2,9)( 4,10)( 6,12)(11,15)(13,16),
 ( 1,44)( 4,46)( 6,47)( 8,49)(10,50)(13,52)(15,54)(17,56)(19,58)(22,60)
  (24,61)(26,63)(28,64)(30,66)(32,67)(34,69)(36,71)(38,73)(40,75)(42,77),
 ( 1,11)( 2,16)( 3,20)( 4,26)( 5,40)( 7,41)( 9,43)(13,44)(15,46)(17,48)
  (19,50)(21,52)(23,53)(24,54)(28,55)(31,57)(33,59)(34,61)(36,63)(37,64)
  (39,65)(42,66)(45,67)(47,69)(51,70)(56,71)(58,73)(62,74)(68,75)(72,76),
 ( 1,42)( 4,46)( 5,47)( 8,48)(11,52)(13,53)(16,55)(17,56)(20,58)(23,62)
  (24,63)(27,65)(29,66)(32,70)(33,71)(36,73)(38,74)(43,76)(44,78)(49,80)
  (59,82)(60,84)(67,86),( 1,9)( 2,15)( 3,22)( 4,29)( 5,32)( 7,35)(11,38)
  (12,39)(14,41)(17,43)(19,44)(24,49)(26,51)(30,54)(34,59)(36,60)(37,62)
  (40,65)(42,67)(45,68)(46,71)(47,72)(48,74)(50,76)(52,79)(53,81)(55,82)
  (57,85)(58,86)(61,88)(63,89)(66,90)(69,91)(70,92)(73,93)(75,94)(77,95)
  (80,96)(83,97)(84,98)(87,99),( 1,7)( 2,9)( 3,13)( 4,24)(10,25),
 ( 2,12)( 3,17)( 6,18)( 7,23)( 8,24)(11,29),
 ( 1,6)( 2,8)( 7,21)(10,22)(14,23)(18,26)(20,29),
 ( 1,9)( 4,15)( 5,21)( 8,22)(12,24)(16,25)(18,27),
 ( 1,7)( 2,17)( 3,37)( 5,42)( 8,45)(10,46)(12,48)(13,49)(15,52)(18,54)
  (21,57)(23,58)(25,60)(27,63)(29,65)(32,68)(34,69)(36,70)(38,73)(41,75)
  (44,76)(47,77)(50,78)(53,79)(56,81)(59,82)(61,83)(64,84)(67,86)(71,87)
  (74,88)(80,90)(85,91)(89,92),( 1,3)( 4,6)( 7,9)(10,12)(14,16)(19,22),
 ( 1,8)( 2,14)( 3,20)( 4,27)( 5,34)( 6,40)( 9,41)(11,42)(13,45)(16,46)
  (19,49)(21,51)(24,52)(26,53)(28,56)(31,57)(32,58)(35,59)(37,61)(39,62)
  (43,63)(44,64)(47,65)(50,66)(54,69)(55,70)(60,71)(67,74)(72,75),
 ( 1,10)( 2,13)( 3,18)( 4,21)( 9,23)(14,26)(16,27)(20,30)(22,32)(24,34)
  (28,36),( 1,8)( 4,16)( 5,20)( 9,22)(11,23)(17,25)(24,28)(26,30),
 ( 2,38)( 5,42)( 7,44)( 9,45)(10,48)(13,52)(15,56)(18,57)(19,59)(21,60)
  (24,63)(27,64)(30,68)(31,72)(34,73)(36,75)(40,76)(49,77)(51,79)(55,81)
  (62,84)(65,85)(67,87)(71,89),( 1,12)( 2,14)( 3,18)( 4,24)( 5,29)( 6,35)
  ( 7,38)( 9,39)(11,40)(15,44)(17,46)(20,49)(21,51)(23,52)(27,54)(31,57)
  (34,59)(36,60)(41,62)(43,63)(45,64)(48,65)(50,67)(53,71)(55,72)(58,74)
  (61,78)(66,79)(68,80)(70,81)(73,82)(75,83)(77,84),
 ( 1,3)( 8,9)(10,12)(13,14)(15,17)(18,20)(21,22)(23,24)(25,26),
 ( 1,3)( 4,6)( 7,8)( 9,11)(12,13),( 1,17)( 3,19)( 6,20)( 8,21)( 9,23)
  (11,25)(14,26)(16,27)(18,40)(24,41)(35,51)(44,61)(48,62)(53,65)(57,66),
 ( 1,11)( 3,16)( 6,24)( 7,28)(10,48)(13,49)(15,50)(18,53)(20,54)(22,55)
  (23,56)(27,58)(30,59)(33,60)(40,64)(52,67)(57,69)(63,74)(66,76),
 ( 1,17)( 3,19)( 6,20)( 8,21)( 9,23)(12,25)(13,26)(16,27)(18,40)(22,42)
  (36,57)(43,60)(49,64)(54,68)(61,70)(65,71),
 ( 1,2)( 4,5)( 7,8)(10,11)(12,13)(15,16)(17,18)(20,21)(23,24)(25,26)
  (30,31)(37,38)(39,40)(47,48)(50,51)(54,55),
 ( 1,13)( 3,14)( 4,17)( 5,18)( 7,19)( 9,22)(10,23)(12,25)(16,26)(21,28)
  (24,30)(27,31)(29,32),( 1,12)( 4,26)( 6,35)( 8,37)(10,41)(13,46)(17,47)
  (20,50)(22,55)(24,56)(27,59)(30,61)(33,62)(39,63)(42,66)(44,68)(48,69)
  (51,72)(53,74)(57,75)(64,77)(70,79),( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)
  (10,31)(11,32)(13,33)(15,34)(16,36)(18,37)(20,38)(22,42)(27,45)(29,46)
  (35,49)(39,52)(41,53)(44,54)(48,55)(51,56),
 ( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)(10,31)(11,32)(13,33)(15,34)(17,37)
  (18,38)(20,39)(22,43)(27,45)(29,46)(35,48)(40,50)(42,51)(44,52)(47,53)
  (49,54),( 1,23)( 3,24)( 4,26)( 6,29)( 8,30)( 9,31)(11,32)(12,34)(14,36)
  (16,37)(18,39)(20,42)(21,43)(27,45)(28,46)(35,48)(40,50)(41,51)(44,52)
  (47,53)(49,54),( 1,18)( 4,19)( 7,20)( 8,23)(10,24)(12,25)(14,26)(16,27)
  (17,44)(22,45)(40,51)(47,60)(50,61)(54,63)(56,64)(59,66),
 ( 1, 9)( 2,14)( 3,20)( 4,27)( 5,33)( 35,37)( 36,56)( 40,59)
  ( 43,61)( 44,63)( 48,67)( 49,69)( 53,72)( 54,78)( 55,84)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 87,104)( 90,106)( 93,108)
  ( 96,110)( 99,112)(102,114),( 1,7)( 2,9)( 5,10)(12,19)(14,21)(16,23),
 ( 1,21)( 3,22)( 4,24)( 6,26)( 7,27)( 8,28)(10,30)(11,32)(13,33)(14,34)
  (16,37)(19,54)(23,65)(25,66)(29,67)(31,68)(35,69)(36,70)(38,72)(41,73)
  (45,76)(47,77)(50,78)(55,81)(57,82)(60,83)(63,86),
 ( 1,10)( 3,11)( 5,14)( 8,18)(13,22)(19,24),
 ( 1,8)( 3,9)( 4,10)( 5,11)( 7,14)(12,19)(15,20)(17,21),
 ( 1,2)( 9,10)(14,16)(17,19)(22,23)(25,27)(30,31),
 ( 1,9)( 2,14)( 3,20)( 5,21)(10,24)(12,27)(15,29)(26,37)(33,40),
 ( 1,3)( 4,5)( 6,8)( 9,10)(11,13)(14,15)(17,18)(20,21)(25,26)(28,29)
  (34,35)(37,38)(43,44)(46,47),( 1,2)( 3,4)(11,12)(14,16)(19,20)(23,25)
  (27,28)(31,33)(37,38)(39,40)(44,46),( 1,28)( 3,30)( 5,31)( 6,32)( 9,34)
  (10,35)(13,37)(15,38)(17,43)(18,45)(19,46)(20,48)(21,49)(22,52)(23,53)
  (24,55)(25,56)(26,58)(27,60)(39,62)(40,64)(41,66)(42,68)(50,69)(57,70)
  (61,71)(65,72),( 1,9)( 4,17)( 5,21)( 7,25)(11,47)(14,48)(16,51)(19,52)
  (20,53)(24,54)(27,57)(29,58)(31,60)(37,65)(50,69)(56,70)(59,73)(63,75)
  (64,76)(68,78)(74,81)(77,82),( 2,9)( 4,10)( 6,12)(11,16)(13,17),
 ( 1,8)( 3,9)( 5,11)( 6,12),( 1,2)( 6,7)(11,12)(16,17)(29,30)(36,37),
 ( 1,11)( 2,13)( 4,14)( 6,16)( 7,21)( 8,22)( 9,25)(18,28)(20,30)(26,32)
  (27,34),( 1,7)( 2,12)( 3,18)( 5,20)( 8,26)(13,28)(16,34),
 ( 1,2)( 4,5)( 8,9)(11,12)(16,18)(21,23),
 ( 1,2)( 4,5)( 8,9)(11,12)(22,23)(29,30)(32,33)(39,40)(43,44)(45,46)
  (48,49)(50,51)(53,54)(55,56)(59,60)(64,65)(66,67)(69,70)(71,72)(74,75)
  (78,79)(81,82)(83,84)(85,86)(88,89)(90,91),
 ( 1,24)( 4,25)( 6,26)( 9,28)(11,30)(14,31)(18,32)(20,34)(22,36)(27,37)
  (33,38),( 1, 9)( 2,13)( 3,20)( 5,35)( 7,36)( 8,40)( 12,44)
  ( 15,45)( 18,48)( 19,49)( 26,55)( 28,58)( 41,84)( 43,85)( 47,87)
  ( 53,88)( 57,90)( 60,97)( 64,98)( 69,99)( 73,101)( 77,102)( 81,103)
  ( 86,105)( 89,106),( 1, 8)( 2,10)( 3,15)( 4,25)( 26,43)( 27,47)
  ( 28,61)( 29,65)( 32,67)( 33,71)( 38,72)( 39,77)( 44,79)( 45,83)
  ( 50,84)( 51,89)( 56,91)( 57,95)( 62,96)( 63,101),
 ( 1,14)( 3,16)( 4,17)( 5,19)( 7,20)(10,21)(13,22)(15,23)(18,24),
 ( 2,11)( 3,16)( 6,33)( 9,36)( 13,38)( 15,41)( 17,42)( 18,44)
  ( 21,47)( 22,49)( 24,51)( 26,54)( 35,78)( 37,79)( 40,81)( 43,82)
  ( 46,83)( 48,84)( 53,86)( 55,87)( 56,93)( 60,96)( 62,97)( 67,100)
  ( 71,103)( 73,104),( 1,23)( 4,24)( 6,25)( 9,29)(11,30)(14,31)(15,32)
  (18,35)(21,36)(28,37)(34,39),( 1,7)( 3,10)( 5,16)(12,21)(18,23)(20,26)
  (22,28)(24,30),( 1,9)( 2,25)( 3,27)( 4,32)(35,44)(36,47)(37,59)(38,62)
  (40,69)(41,71)(45,72)(46,73)(50,75)(51,77)(55,78)(56,79)(60,81)(61,83)
  (65,84)(66,85),( 1,7)( 2,10)( 3,15)( 4,18)( 8,23)(22,34)(29,39)(33,41)
  (37,44)(38,45)(40,47)(43,49),( 1,23)( 2,26)( 4,27)( 6,28)( 8,32)( 9,33)
  (11,34)(13,35)(14,36)(16,40)(18,41)(19,42)(21,43)(24,45)(29,47)(31,48)
  (37,50)(39,51)(44,52)(46,53)(49,54),( 1, 7)( 2,12)( 4,20)( 10,30)
  ( 11,32)( 13,33)( 15,34)( 16,37)( 17,40)( 18,41)( 21,45)( 22,46)
  ( 24,49)( 36,73)( 39,74)( 42,78)( 43,79)( 48,81)( 50,84)( 51,85)
  ( 77,103)( 83,105),( 1, 6)( 2,10)( 3,18)( 4,21)( 5,24)( 36,45)
  ( 38,56)( 39,57)( 43,59)( 44,62)( 48,64)( 50,67)( 51,68)( 54,77)
  ( 55,86)( 70,88)( 73,90)( 76,92)( 79,94)( 82,96)( 85,98)( 89,100)
  ( 91,101)( 93,104)( 95,105)( 97,108)( 99,109),
 ( 1,7)( 4,9)(12,18)(13,20)(15,21)(17,23)(19,25)(22,26)(24,27),
 ( 1,7)( 4,8)( 6,10)(12,17)(15,23)(19,28)(21,30),
 ( 2,22)( 5,23)( 7,26)(10,27)(13,28)(16,31)(18,34)(21,35)(25,38)(30,41)
  (33,42)(37,43)(40,44),( 1,26)( 2,28)( 4,30)( 5,31)( 6,33)( 7,36)( 8,37)
  ( 9,39)(11,41)(12,43)(13,44)(16,52)(18,54)(19,58)(20,60)(23,64)(25,66)
  (29,67)(35,68)(42,69),( 1,10)( 2,13)( 3,15)( 4,16)( 7,19)( 8,21)( 9,25)
  (18,29)(23,31)(26,33)(27,35),( 1,26)( 2,28)( 3,29)( 4,31)( 5,33)( 7,35)
  ( 8,37)( 9,39)(10,41)(12,42)(13,44)(15,52)(16,54)(18,57)(19,59)(23,62)
  (25,64)(30,68)(36,69)(43,70),( 1,23)( 2,24)( 4,28)( 6,29)( 7,30)( 9,32)
  (11,33)(13,34)(14,35)(16,36)(18,40)(19,41)(21,42)(25,43)(27,44)(31,47)
  (37,50)(39,51)(45,54)(48,55)(52,56),( 1,6)( 2,10)( 3,16)( 8,21)(12,26)
  (15,30)(19,33)(25,35),( 1,7)( 2,9)( 4,11)( 6,12),
 ( 1, 9)( 2,14)( 3,20)( 4,27)( 5,33)( 35,40)( 38,56)( 39,57)
  ( 43,60)( 46,62)( 47,64)( 51,68)( 52,70)( 54,78)( 55,84)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 87,104)( 90,106)( 93,108)
  ( 96,110)( 99,112)(102,114),( 2,9)( 4,11)( 8,16)(10,17)(12,19)(15,21)
  (18,22)(20,23),( 1,6)( 2,8)( 3,12)( 4,23)( 9,25),
 ( 2,9)( 4,11)( 8,15)(16,23)(17,25)(18,29)(19,31),
 ( 1,6)( 2,8)( 3,12)( 9,24)(14,25),( 1, 7)( 2,14)( 3,27)( 8,37)
  ( 10,38)( 13,42)( 15,43)( 20,48)( 22,52)( 24,54)( 26,55)( 35,82)
  ( 39,83)( 41,84)( 46,86)( 49,87)( 53,88)( 57,95)( 61,97)( 65,99)
  ( 69,101)( 73,103)( 77,105)( 96,113)( 98,114)(100,115)(102,116)(104,117)
  (106,118),( 1,8)( 4,10)(11,18)(13,20)(15,21)(17,23)(19,27)(22,28)(24,29)
  (25,30)(26,31),( 2,37)( 5,40)( 6,42)( 8,45)(10,46)(12,50)(13,53)(15,55)
  (17,58)(20,60)(21,61)(25,65)(26,66)(29,70)(32,73)(33,76)(36,78)(49,79)
  (51,81)(56,83)(69,85)(71,87)(74,89),( 1,2)( 4,5)(10,11)(17,18)(20,21)
  (26,27)(29,30)(34,35)(36,37)(42,43)(44,45)(47,48)(53,54)(55,56)(58,59)
  (60,61)(62,63)(64,65)(68,69)(71,72)(79,80)(81,82)(88,89)(91,92),
 ( 1,11)( 2,16)( 3,23)( 4,26)( 5,35)( 6,39)( 8,42)(10,43)(13,44)(14,45)
  (18,48)(19,49)(21,50)(25,52)(28,53)(30,54)(32,55)(36,57)(38,58)(41,61)
  (46,62)(47,64)(51,66)(56,67)(59,70)(60,71)(63,72)(65,73)(68,74)(69,75),
 ( 1,15)( 2,24)( 3,33)( 4,43)( 6,45)( 9,47)(11,48)(14,49)(16,53)(18,54)
  (20,55)(23,57)(26,58)(28,59)(30,63)(32,64)(34,66)(36,67)(40,68)(42,72)
  (44,73)(46,75)(50,77)(52,78)(56,80)(60,82)(62,83)(65,84)(69,86)(71,87)
  (74,88)(76,90)(79,91)(81,93)(85,95)(89,96)(92,97)(94,98),
 ( 1, 9)( 3,14)( 6,28)( 12,33)( 19,42)( 21,46)( 25,56)( 27,65)
  ( 29,70)( 32,73)( 34,74)( 37,76)( 40,79)( 41,80)( 43,81)( 45,82)
  ( 48,89)( 50,92)( 51,93)( 53,96)( 55,97)( 58,99)( 59,101)( 61,104)
  ( 62,105)( 64,108)( 68,110)( 69,112)( 71,114)( 72,115)( 77,116)( 78,117)
  ( 91,134)( 95,136)(103,137)(107,139)(120,144)(123,146)(125,148)(128,150)
  (131,152)(133,154)(143,161)(145,162)(147,163)(149,164)(151,165)(153,166),
 ( 1,13)( 4,17)( 5,21)( 8,23)( 9,27)(12,33)(16,37)(19,41)(26,45)(29,49)
  (31,53)(36,55)(39,59)(44,61)(47,65)(52,67)(58,69)(64,71),
 ( 1,3)(10,13)(16,17)(18,21)(22,23)(25,26),
 ( 1,19)( 2,22)( 3,24)( 4,26)( 5,29)( 7,31)( 8,34)( 9,36)(11,38)(12,41)
  (13,43)(14,46)(15,48)(16,50)(18,53),( 1,37)( 4,40)( 7,42)( 9,43)(12,46)
  (13,48)(16,52)(19,54)(21,55)(22,58)(23,59)(26,63)(28,64)(29,67)(33,71)
  (35,73)(38,74)(41,78)(50,80)(51,83)(56,85)(62,89)(69,91)(70,94),
 ( 1,9)( 2,12)( 3,15)( 4,18)( 5,21)( 6,24),
 ( 1,8)( 2,9)( 4,10)( 5,12)( 6,14)(11,19)(15,20)(17,21),
 ( 1,2)(12,13)(15,17)(19,20)(22,24)(26,27)(32,33)(37,38)(42,43)(48,49)
  (51,52)(56,57)(58,59),( 2,11)( 4,17)( 5,22)( 8,30)( 9,34)
  ( 12,35)( 15,39)( 18,40)( 21,43)( 26,46)( 28,47)( 31,50)( 38,57)
  ( 41,62)( 45,67)( 51,75)( 56,78)( 60,82)( 65,86)( 70,91)( 74,92)
  ( 76,93)( 81,97)( 85,99)( 90,103)(102,111)(108,113),
 ( 2,9)( 4,11)( 5,12)(10,15)(13,16),( 1,3)( 5,7)( 9,11)(16,17)(24,26)
  (28,30)(33,35)(36,38)(41,43)(44,46),( 1,2)( 4,5)(15,16)(22,23)(25,26)
  (30,31)(33,34)(39,40)(41,42)(44,45)(46,47)(49,50)(55,56)(57,58)(60,61)
  (62,63)(65,66)(67,68)(70,71)(75,76)(78,79)(80,81)(83,84)(85,86)(88,89)
  (91,92)(94,95),( 1, 6)( 2,18)( 3,23)( 5,36)( 7,38)( 9,40)
  ( 10,41)( 12,43)( 14,47)( 16,48)( 20,50)( 25,51)( 26,55)( 28,57)
  ( 42,73)( 44,76)( 45,77)( 52,82)( 53,83)( 78,102)( 84,104),
 ( 1,15)( 2,21)( 3,26)( 4,36)( 6,37)( 8,40)( 10,42)( 14,45)
  ( 17,47)( 19,48)( 28,53)( 39,68)( 44,71)( 51,76)( 52,78)( 56,82)
  ( 60,86)( 65,96)( 69,103)( 70,104)( 74,105)( 75,106)( 81,121)( 85,122)
  ( 88,124)( 95,125)( 98,127)(108,132)(111,134)(113,136)(115,138)(118,140)
  (120,142)(123,143)(126,144)(131,145)(133,146)(135,147)(137,148)(139,149)
  (141,150),( 1, 2)( 9,10)( 15,16)( 24,25)( 28,29)( 40,41)( 44,45)
  ( 46,47)( 50,51)( 54,55)( 56,57)( 60,61)( 63,64)( 65,66)( 69,70)
  ( 71,72)( 75,76)( 80,81)( 86,87)( 91,92)( 94,95)( 97,98)(100,101)
  (103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)(125,126),
 ( 1, 6)( 2,10)( 3,24)( 4,28)( 5,30)( 36,45)( 38,59)( 39,60)
  ( 42,62)( 46,65)( 47,66)( 51,69)( 52,70)( 55,72)( 56,78)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 84,102)( 87,103)( 90,105)
  ( 93,106)( 96,108)( 99,109),( 1,23)( 3,24)( 5,25)( 6,28)( 8,30)(10,31)
  (11,32)(13,35)(14,37)(16,38)(17,39)(18,40)(20,43)(22,45)(26,46)(33,47)
  (41,48),( 1,8)( 2,14)( 3,19)( 4,25)( 5,31)( 6,37)( 9,38)(11,41)(13,43)
  (15,44)(18,45)(20,48)(21,49)(24,52)(26,54)(29,57)(32,58)(34,61)(36,62)
  (40,64)(42,67)(46,69)(47,70)(51,72)(53,75)(56,76)(59,78)(60,79)(66,80)
  (74,81),( 2,9)( 4,11)( 6,13)(12,16)(15,17),
 ( 1,6)( 2,9)( 4,11)( 8,13)(10,14)(12,15),
 ( 1,6)( 2,9)( 4,11)( 8,12)(10,13)(14,16)(15,17),
 ( 1,32)( 5,33)( 8,34)( 12,35)( 13,36)( 17,37)( 21,38)( 24,39)
  ( 40,56)( 43,61)( 44,62)( 47,67)( 48,68)( 50,71)( 53,76)( 63,89)
  ( 69,90)( 77,93)( 81,96)( 82,99)( 83,102)( 87,105)( 88,108)( 92,109)
  ( 95,112)( 98,115)(101,118)(104,121)(107,124)(113,127)(119,128)(125,129),
 ( 1,23)( 3,25)( 4,26)( 5,29)( 7,30)( 8,31)(10,33)(12,34)(13,37)(15,38)
  (16,40)(18,41)(20,44)(21,45)(27,46)(35,47)(42,48),
 ( 2,9)( 4,11)( 6,12)(16,24)(17,26)(18,30)(19,32),
 ( 1,32)( 5,33)( 13,34)( 16,35)( 20,36)( 24,37)( 25,38)( 29,39)
  ( 42,56)( 45,61)( 47,64)( 48,65)( 51,70)( 52,71)( 55,76)( 63,89)
  ( 69,90)( 77,91)( 78,94)( 82,97)( 83,100)( 84,103)( 88,106)( 92,111)
  ( 95,114)( 98,117)(101,120)(104,123)(107,126)(110,127)(116,128)(122,129),
 ( 1,11)( 2,14)( 3,19)( 4,20)( 5,25)( 6,28)( 7,30)( 8,34)( 9,38)(12,39)
  (16,43)(18,46)(21,48)(23,49)(27,51)(31,53)(32,54)(36,56)(37,57)(40,59)
  (45,60)(61,69)(64,70)(65,71)(68,72),( 1,22)( 3,23)( 5,26)( 6,29)( 8,30)
  (10,31)(11,32)(12,35)(15,37)(16,38)(17,41)(19,44)(21,45)(25,47)(27,48)
  (34,50)(36,51)(40,53)(42,54),( 1,31)( 2,33)( 4,34)( 5,36)( 7,37)( 8,38)
  (10,40)(11,41)(13,42)(14,43)(15,45)(19,46)(23,48)(26,49)(30,51)(32,52)
  (35,53)(39,55)(44,57)(47,59)(50,60)(54,61)(56,62)(58,63),
 ( 1,4)( 6,10)( 7,12)( 8,14)( 9,16)(11,18)(13,20)(15,22)(17,23)(19,24)
  (21,25),( 1,13)( 2,16)( 3,17)( 4,22)( 5,24)( 6,27)( 7,30)( 8,32)( 9,35)
  (11,36)(12,37)(19,44)(21,45)(25,49)(29,54)(33,56)(38,60)(39,61)(43,63)
  (46,66)(50,67)(51,68)(55,70)(57,73)(62,74)(65,75)(69,76)(72,78),
 ( 1,8)( 2,11)( 3,16)( 4,20)( 5,28)( 6,30)( 7,34)(10,37)(13,38)(15,39)
  (17,42)(19,43)(22,46)(23,49)(26,52)(31,55)(33,58)(35,62)(41,64)(45,65)
  (47,66)(48,69)(50,70)(54,71)(56,72)(57,75)(59,76)(68,78)(74,80),
 ( 1,21)( 2,22)( 4,24)( 5,25)( 7,26)( 8,28)( 10,29)( 11,31)
  ( 13,32)( 14,34)( 15,35)( 20,59)( 23,61)( 27,63)( 30,64)( 33,66)
  ( 37,70)( 41,75)( 43,76)( 47,81)( 49,82)( 52,84)( 56,89)( 58,90)
  ( 60,91)( 62,92)( 65,93)( 67,107)( 71,109)( 74,111)( 77,112)( 80,114)
  ( 85,115)( 88,117)( 95,120)( 99,123)(104,126),
 ( 1,7)( 2,12)( 3,20)( 8,26)(13,27)(18,29)(23,30),
 ( 1,12)( 4,19)( 6,24)( 8,29)( 9,48)(11,49)(14,52)(15,53)(18,54)(21,55)
  (23,58)(26,59)(28,60)(34,61)(37,64)(44,67)(51,68)(57,69),
 ( 1,2)( 9,10)(13,14)(19,20)(23,24)(26,27),
 ( 1,23)( 3,24)( 4,25)( 6,29)( 8,30)( 9,31)(11,32)(13,33)(14,36)(16,37)
  (18,38)(20,42)(21,43)(26,45)(28,46)(34,48)(39,50)(41,51)(44,52)(47,53)
  (49,54),( 1,23)( 3,24)( 4,25)( 6,29)( 8,30)( 9,31)(11,32)(13,33)(15,35)
  (16,36)(18,37)(20,41)(21,42)(26,45)(28,46)(34,49)(38,52)(40,53)(44,54)
  (48,55)(51,56),( 2,17)( 4,18)( 6,19)( 8,22)( 9,23)(12,24)(15,26)(16,27)
  (21,43)(25,44)(32,46)(49,59)(51,61)(54,65)(56,67)(58,70),
 ( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(14,15)(17,18)(19,20)(22,23)(24,25)
  (27,28)(30,31)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(56,57)(59,60)
  (62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)
  (92,93)(94,95),( 1,12)( 2,13)( 5,15)( 7,16)( 9,20)(10,22)(11,25)(14,26)
  (17,31)(19,32)(21,33)(23,34)(27,35)(29,36),
 ( 1,23)( 3,24)( 4,25)( 6,28)( 8,30)( 9,31)(11,32)(13,33)(15,35)(17,36)
  (18,37)(20,40)(21,42)(26,44)(27,46)(34,48)(38,51)(39,53)(43,54)(47,55)
  (50,56),( 1,7)( 2,11)( 4,18)( 9,32)(10,35)(12,37)(13,38)(14,42)(16,43)
  (19,47)(20,49)(22,50)(23,53)(24,55)(26,56)(36,84)(40,85)(48,86)(52,87),
 ( 1,13)( 2,15)( 3,16)( 4,18)( 5,20)( 6,21)( 7,24)( 8,27)( 9,29)(10,31)
  (11,33)(12,35)(23,44)(26,45)(28,48)(37,52)(39,55)(46,57)(53,59),
 ( 2,8)( 4,10)( 5,21)( 7,22)(15,25)(19,28)(23,29)(26,30),
 ( 1,30)( 2,31)( 4,35)( 5,36)( 7,39)( 8,41)( 9,42)(10,45)(11,53)(12,54)
  (15,56)(17,57)(18,60)(19,61)(20,63)(21,64)(24,67)(26,68)(27,70)(28,71)
  (32,73)(37,74)(43,75),( 1,6)( 9,15)(10,16)(11,17)(13,20)(18,21)(19,22),
 ( 1,9)( 2,10)( 3,12)( 5,14)( 6,15)( 7,17),
 ( 1,6)( 9,14)(10,23)(11,26)(12,34)(16,36)(17,37)(24,38)(25,39)(33,40)
  (42,52)(45,58),( 1,6)( 9,14)(10,22)(11,26)(12,33)(15,35)(23,36)(25,37)
  (30,38)(31,39)(45,60)(50,61)(55,62),( 1,2)(11,14)(15,18)(21,24)(25,27)
  (28,31)(37,40)(41,43)(44,45)(48,49)(51,52)(55,56)(58,59)(62,63),
 ( 1,22)( 4,24)( 6,27)( 9,29)(12,31)(15,34)(17,36)(20,37)(23,38)(26,39)
  (30,40)(33,41),( 1,4)( 3,8)( 6,21)(10,23)(14,25)(17,27)(20,29),
 ( 1,12)( 3,16)( 5,20)( 8,28)( 9,48)(11,49)(14,52)(15,53)(19,54)(22,55)
  (24,58)(25,59)(27,60)(35,63)(40,65)(46,69)(51,71)(57,72),
 ( 1,17)( 2,18)( 5,20)( 8,21)( 9,22)(11,25)(13,26)(15,27)(19,43)(23,44)
  (38,50)(45,60)(47,62)(52,64)(54,67)(56,69),
 ( 1,4)( 5,6)( 8,11)(12,14)(16,19)(20,22)(30,33)(39,41)(42,44)(46,47)
  (48,49)(50,52)(53,55)(56,57)(60,62)(64,65)(66,67)(68,70)(71,72)(73,75)
  (76,77)(79,80)(82,84)(87,89)(90,91)(92,93),
 ( 1,22)( 3,24)( 6,27)( 9,29)(12,31)(14,34)(17,36)(19,37)(25,38)(28,39)
  (32,40)(35,41),( 2,9)( 4,14)( 6,21)( 8,23)(15,25)(18,26)(22,27)(24,28),
 ( 1,22)( 5,24)( 8,26)(10,29)(12,30)(15,32)(17,34)(20,37)(23,38)(27,39)
  (31,40)(35,41),( 1,9)( 2,15)( 3,18)( 4,22)( 5,25)( 6,31)( 7,33)( 8,38)
  (10,40)(12,43)(14,44)(16,47)(21,48)(23,51)(26,52)(28,55)(30,58)(34,59)
  (37,60)(42,61)(45,64)(50,65)(54,68)(56,69)(63,70)(67,71),
 ( 1,9)( 2,15)( 3,19)( 4,21)( 5,27)( 6,30)( 7,33)( 8,35)(10,41)(12,43)
  (14,45)(18,46)(22,50)(24,51)(26,52)(29,54)(31,56)(36,57)(38,61)(39,62)
  (44,63)(48,64)(55,65)(59,66),( 1, 5)( 2,27)( 4,46)( 8,48)
  ( 11,49)( 13,50)( 18,53)( 23,54)( 26,56)( 31,59)( 33,63)( 37,67)
  ( 41,69)( 43,73)( 51,77)( 55,81)( 57,82)( 58,90)( 60,91)( 62,93)
  ( 64,95)( 66,97)( 68,99)( 70,100)( 72,102)( 75,103)( 79,104)( 83,105)
  ( 85,107)( 87,109)(106,111)(108,112)(110,113),
 ( 1,41)( 4,43)( 6,44)( 9,47)(12,49)(13,50)(16,52)(19,56)(21,57)(24,59)
  (25,60)(28,63)(30,66)(33,68)(34,69)(37,71)(40,75)(46,77)(55,79)(62,81)
  (65,83)(74,84)(76,85)(80,86),( 2,8)( 4,10)( 9,16)(11,17)(12,18)(15,21)
  (19,22)(20,23),( 1,9)( 3,16)( 5,24)( 6,29)(12,39)(15,40)(19,41)(23,47)
  (25,48)(28,52)(33,53)(35,57)(38,61)(44,62)(46,63)(51,66)(56,67)(60,70)
  (65,71)(69,72),( 1,12)( 4,26)( 5,33)( 7,40)(11,44)(14,46)(16,47)(19,48)
  (22,51)(25,52)(29,53)(32,54)(36,55)(39,58)(43,59)(49,61)(56,63),
 ( 2,9)( 3,11)( 5,13)( 6,15)( 8,18)(12,20)(16,21)(19,22),
 ( 1,10)( 2,15)( 3,17)( 4,23)( 5,26)( 6,30)( 7,33)( 8,39)(11,40)(14,41)
  (18,42)(20,45)(22,48)(25,49)(27,52)(32,53)(34,56)(36,57)(38,60)(44,61)
  (46,62)(50,65)(55,66)(58,69)(63,70)(67,71),
 ( 2,10)( 3,11)( 5,12)( 6,14)( 8,15)( 9,16)(13,17),
 ( 1,2)( 3,4)( 7,8)(10,11)(12,14)(15,16)(17,18)(19,20)(28,29)(30,31)
  (32,33)(34,35)(37,38)(39,40)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52)
  (53,54)(55,56)(57,58)(59,60)(78,79)(80,81)(82,83)(84,85)(87,88)(89,90)
  (91,92)(93,94),( 1,13)( 3,14)( 4,15)( 6,18)( 7,19)( 8,21)(10,22)(12,23)
  (17,25)(20,28)(24,31)(27,32)(30,33),( 1,23)( 3,25)( 5,26)( 6,27)( 8,30)
  ( 9,31)(10,33)(12,34)(14,35)(15,38)(17,39)(19,41)(20,42)(22,45)(29,46)
  (37,47)(44,48),( 1,22)( 3,23)( 5,26)( 6,27)( 8,30)(10,31)(11,32)(13,35)
  (14,38)(16,39)(18,40)(19,43)(21,46)(25,47)(29,48)(34,49)(37,50)(42,51)
  (45,52),( 1,25)( 2,26)( 4,27)( 6,29)( 7,32)( 9,33)(11,34)(12,35)(14,37)
  (16,40)(17,41)(18,42)(20,43)(21,45)(24,46)(31,47)(39,48),
 ( 1,10)( 2,12)( 3,15)( 4,17)( 6,20)( 8,21)(11,23)(16,25),
 ( 1,7)( 9,16)(10,25)(11,29)(13,35)(18,36)(20,37)(26,38)(28,39)(32,40)
  (33,41)(34,48),( 1,7)( 3,8)( 5,9)(14,22)(16,25)(18,26)(23,27),
 ( 1,13)( 4,20)( 6,25)( 8,30)(10,48)(12,49)(15,52)(16,53)(19,54)(22,55)
  (24,58)(27,59)(29,60)(34,61)(37,64)(44,67)(51,68)(57,69),
 ( 1,9)( 3,14)( 5,19)( 8,27)(11,45)(13,46)(16,47)(18,48)(21,51)(23,52)
  (25,53)(26,54)(30,56)(33,60)(42,70)(50,72)(55,74)(62,76)(69,78),
 ( 1,2)( 3,4)(10,11)(14,15),( 1,23)( 4,27)( 6,28)( 8,29)(10,30)(13,33)
  (15,35)(18,36)(20,37)(25,38)(32,39),( 1,10)( 3,11)( 6,15)( 8,18)(16,24)
  (21,25)(23,26),( 1,44)( 3,46)( 5,47)( 8,49)(10,50)(12,52)(14,54)(17,56)
  (19,58)(21,60)(23,61)(25,63)(27,64)(29,66)(31,67)(33,69)(35,71)(37,73)
  (39,75)(42,77),( 1,11)( 2,21)( 3,26)( 4,30)(35,41)(36,45)(37,56)(38,60)
  (39,69)(43,71)(44,73)(48,74)(49,75)(53,77)(54,79)(58,80)(59,81)(63,83)
  (64,85)(68,86),( 1,10)( 2,14)( 3,18)( 5,20)( 8,23)(15,29)(24,36)(30,39),
 ( 1,17)( 4,19)( 5,23)( 8,27)(10,29)(11,31)(13,37)(16,39)(21,41)(26,43)
  (33,45)(36,47),( 1,17)( 4,18)( 5,20)( 7,22)(10,23)(12,25)(13,27)(16,28)
  (19,40)(24,41)(32,44)(38,58)(47,63)(55,65),
 ( 1,8)( 3,9)( 5,10)( 7,12)(11,15)(13,16)(14,17),
 ( 1,2)( 3,5)( 9,11)(17,18)(20,21),( 1,2)( 3,4)(13,14)(17,18)(19,20)
  (24,25)(29,30)(31,32)(35,36)(39,41)(42,44),
 ( 1,23)( 4,24)( 6,27)( 9,29)(12,30)(14,31)(18,35)(21,36)(25,37)(28,38)
  (32,39)(34,40),( 1,7)( 4,13)( 8,15)( 9,16)(11,19)(17,23)(20,25),
 ( 1,10)( 2,13)( 3,19)( 4,25)( 5,30)( 6,32)( 9,35)( 11,37)
  ( 14,42)( 16,44)( 18,46)( 20,49)( 22,51)( 23,54)( 26,57)( 29,59)
  ( 31,61)( 33,63)( 34,65)( 36,66)( 38,68)( 40,70)( 43,73)( 48,76)
  ( 50,77)( 52,79)( 55,81)( 60,84)( 67,87)( 72,90)( 75,92)( 78,93)
  ( 83,96)( 86,98)( 88,99)( 89,101)( 91,103)( 94,105)( 95,107)( 97,109)
  (102,111)(104,113)(108,115)(110,117),( 2,10)( 4,13)( 7,16)( 8,20)(12,21)
  (17,23),( 1,12)( 2,23)( 3,47)( 8,49)( 10,50)( 15,53)( 17,54)
  ( 20,55)( 24,56)( 28,59)( 32,60)( 36,64)( 40,68)( 42,69)( 46,73)
  ( 48,74)( 51,77)( 58,81)( 62,89)( 63,91)( 66,93)( 67,95)( 71,97)
  ( 72,99)( 76,101)( 80,102)( 84,103)( 86,104)( 88,105),
 ( 1,8)( 4,16)( 5,21)( 9,23)(11,24)(15,26)(17,27),
 ( 1,3)( 6,8)(10,12)(15,17)(20,21),( 1,6)( 5,11)( 9,13)(10,14),
 ( 1,2)(11,12)(15,16)(19,20)(24,25)(28,29)(31,32)(36,37)(39,40),
 ( 1,8)( 2,24)( 3,26)( 4,31)(35,39)(36,42)(37,54)(38,57)(40,69)(41,70)
  (45,72)(46,74)(50,75)(51,76)(55,78)(56,80)(60,81)(61,82)(65,84)(66,86),
 ( 1,17)( 7,19)( 11,21)( 14,22)( 20,38)( 23,40)( 24,42)( 26,44)
  ( 27,46)( 28,47)( 29,48)( 30,50)( 33,53)( 34,55)( 35,56)( 37,58)
  ( 39,66)( 41,67)( 45,68)( 51,69)( 54,70)( 59,74)( 61,78)( 62,80)
  ( 64,84)( 71,88)( 73,89)( 75,90)( 77,91)( 79,92)( 81,93)( 83,94)
  ( 85,96)( 86,98)( 87,100)( 95,101)( 97,102)( 99,103),
 ( 1,9)( 2,13)( 3,16)( 4,21)( 5,24)( 6,29)( 7,32)( 8,38)(11,41)(14,42)
  (18,43)(19,45)(22,47)(25,49)(27,52)(31,53)(33,54)(35,56)(37,58)(39,61)
  (46,62)(51,63)(57,65)(60,66),( 2,9)( 4,14)( 6,18)( 8,21)(15,23)(20,26)
  (22,28)(24,30),( 1, 6)( 2,10)( 3,17)( 4,23)( 5,29)( 32,37)
  ( 35,57)( 36,59)( 41,61)( 44,65)( 45,66)( 50,69)( 51,70)( 54,78)
  ( 55,87)( 71,89)( 74,92)( 77,95)( 80,98)( 83,101)( 86,104)( 91,109)
  ( 94,111)( 97,115)(100,117)(103,121)(106,123),
 ( 2,9)( 4,13)( 5,17)( 7,22)(12,23)(15,25)(20,26),
 ( 1,10)( 4,13)( 6,15)( 8,17)(18,21)(19,27),
 ( 2,9)( 4,13)( 6,18)( 7,22)(12,24)(19,26)(23,28)(25,30),
 ( 1, 8)( 2,20)( 3,29)( 4,40)( 7,41)( 9,45)( 11,49)( 15,50)
  ( 17,54)( 19,58)( 22,59)( 24,60)( 26,63)( 28,64)( 31,65)( 33,69)
  ( 34,73)( 37,74)( 39,77)( 42,78)( 44,79)( 46,82)( 47,83)( 51,84)
  ( 53,85)( 55,88)( 56,89)( 62,90)( 66,91)( 68,92)( 70,95)( 71,96)
  ( 76,97)( 81,98)( 87,99)( 94,100),( 1,8)( 4,11)( 5,12)( 6,14),
 ( 1,23)( 5,25)( 8,26)(10,27)(13,31)(15,32)(18,33)(20,34)(24,37)(28,40)
  (29,41)(35,42)(38,43),( 1,4)( 8,11)(19,21)(22,25)(27,29)(30,33)(35,36)
  (37,38)(39,41)(42,43)(44,45)(47,49)(52,53)(54,56)(57,58)(59,61)(62,63)
  (64,65)(67,69)(70,72)(75,76)(77,79)(81,82)(83,85)(86,88)(91,93)(95,97),
 ( 1,3)( 4,6)(11,12)(14,15),( 1,5)( 4,10)(13,19)(17,33)(21,35)(29,41)
  (31,47)(36,48)(38,50)(40,52)(42,54)(44,56)(46,58)(51,61)(55,63)(59,65),
 ( 1,9)( 2,11)( 3,14)( 4,16)( 5,23)( 6,27)( 7,34)( 8,37)(12,42)(17,45)
  (19,46)(21,47)(26,49)(29,52)(31,53)(33,55)(36,56)(38,57)(40,58)(43,60)
  (44,61)(50,63)(51,64)(54,66)(62,68)(65,70),
 ( 1,6)( 5,9)(10,15)(12,33)(18,34)(31,42)(32,50)(35,51)(39,53)(41,55)
  (43,57)(47,59)(49,61)(54,63)(58,64)(62,65),
 ( 1,7)( 3,9)( 4,12)(11,18)(15,20),( 1,2)( 4,10)( 7,11)( 8,13)( 9,15)
  (12,17)(14,18)(16,19),( 1,16)( 4,21)( 7,26)(10,30)(13,35)(18,39)(20,40)
  (23,41)(25,43)(28,45)(32,46)(34,47)(36,49)(38,51)(42,52)(48,53),
 ( 2,10)( 4,11)( 6,14)( 8,16)(17,24)(19,28),
 ( 2,14)( 6,17)( 9,20)(11,21)(13,24)(15,46)(19,48)(22,50)(27,51)(30,53)
  (32,55)(34,56)(36,58)(38,60)(40,61)(43,63)(45,65)(47,66)(49,67),
 ( 2,9)( 4,12)( 6,13)( 7,16),( 1, 8)( 2,15)( 3,40)( 9,41)( 12,42)
  ( 21,43)( 23,44)( 27,45)( 30,53)( 32,54)( 35,62)( 39,70)( 46,92)
  ( 48,95)( 49,96)( 51,99)( 52,100)( 55,102)( 57,105)( 58,106)( 60,109)
  ( 61,110)( 63,112)( 65,115)( 66,116)( 68,119)( 69,120)( 74,124)( 76,127)
  ( 78,129)( 83,131)( 87,132)( 91,133)( 94,134)( 98,136)(104,138)(108,140)
  (114,142)(118,144)(122,146)(126,147),( 1,9)( 3,14)( 5,18)( 8,21)(15,23)
  (20,25)(22,27)(24,29),( 1,22)( 3,27)( 5,28)( 6,29)( 7,32)( 9,33)(11,34)
  (12,35)(14,36)(16,41)(17,42)(19,43)(21,44)(23,45)(26,46)(31,49)(37,52)
  (40,53)(47,56)(50,57)(54,58),( 1,10)( 4,11)( 5,13)( 8,14),
 ( 1,15)( 2,24)( 3,36)( 5,39)( 6,42)( 10,45)( 11,46)( 13,50)
  ( 16,53)( 18,56)( 20,58)( 22,59)( 25,61)( 28,62)( 30,65)( 32,68)
  ( 35,70)( 37,74)( 41,77)( 43,78)( 44,79)( 47,83)( 49,84)( 52,86)
  ( 55,87)( 57,88)( 60,89)( 64,94)( 67,95)( 69,96)( 71,97)( 73,98)
  ( 76,100)( 80,101)( 82,102)( 85,103)( 90,107)( 92,108)( 93,109)( 99,113)
  (104,117)(106,118)(110,119)(112,120)(114,121)(116,122),
 ( 1,12)( 2,15)( 3,22)( 4,26)( 5,33)( 6,35)( 7,38)( 8,40)( 9,42)(11,43)
  (13,44)(16,45)(18,47)(20,48)(23,51)(28,53)(30,54)(32,55)(37,58)(46,61)
  (49,63)(50,64)(56,66)(57,67)(62,69)(65,71),
 ( 1,2)( 6,7)(15,16)(20,21)(24,25)(27,28)(31,32),
 ( 1,9)( 3,11)( 5,15)( 6,17)(14,22)(20,23),
 ( 1,2)(10,11)(13,15)(16,18)(20,21)(25,26)(27,29)(31,33)(34,36)(39,41)
  (42,44)(46,48)(49,50),( 1,4)( 2,11)( 3,15)(10,25)(12,28)(19,32)(22,34)
  (23,37)(31,42)(33,45),( 1,22)( 3,25)( 5,26)( 6,29)( 8,30)( 9,33)(11,34)
  (13,37)(14,38)(16,39)(17,40)(19,43)(21,44)(23,45)(27,46)(31,49)(35,50)
  (41,53)(47,56)(51,57)(54,58),( 1,5)( 2,10)( 3,19)( 6,21)( 8,23)(13,25)
  (14,27)(18,29)(24,31)(28,33)(30,35),( 1,7)( 3,10)( 4,12)( 6,14)( 8,15)
  ( 9,16)(13,19)(17,22)(20,23),( 1,2)(10,11)(13,14)(16,17)(18,19),
 ( 1,12)( 2,15)( 3,18)( 4,20)( 5,23)( 6,26)( 7,31)( 8,34)( 9,37)(10,40)
  (14,42)(16,45)(22,47)(24,49)(28,51)(29,54)(33,56)(35,58)(39,59)(43,61)
  (44,63)(52,64)(53,66),( 1, 6)( 2,18)( 3,27)( 5,41)( 7,45)
  ( 10,47)( 12,50)( 14,53)( 17,54)( 20,56)( 22,57)( 24,59)( 26,62)
  ( 29,65)( 31,69)( 32,70)( 36,73)( 37,76)( 39,77)( 42,79)( 44,80)
  ( 46,81)( 48,82)( 51,83)( 55,88)( 58,89)( 60,90)( 63,91)( 66,93)
  ( 68,94)( 71,98)( 72,99)( 74,100)( 78,104)( 84,108)( 85,109)( 87,110)
  ( 92,114)( 95,115)( 97,116)(101,117)(103,118)(105,119)(107,120)(111,121)
  (113,122),( 1,7)( 4,10)( 5,11)( 6,13),
 ( 2,17)( 3,18)( 5,20)( 8,21)( 9,22)(12,24)(14,25)(15,27)(19,39)(23,41)
  (30,47)(49,63)(55,67)(58,68)(62,70)(66,71),
 ( 2, 8)( 4,14)( 5,19)( 10,33)( 12,34)( 13,35)( 15,39)( 17,42)
  ( 18,43)( 22,45)( 25,48)( 31,66)( 32,67)( 37,70)( 38,71)( 41,73)
  ( 46,76)( 47,77)( 51,81)( 54,87)( 61,93)( 69,99)( 75,100)( 83,119)
  ( 85,122)( 89,124)( 91,126)( 95,129)( 97,131),
 ( 1,2)(10,11)(13,14)(16,17)(21,22)(24,25)(26,27)(29,30)(31,32)(34,35),
 ( 1,6)( 5,11)(12,22)(20,30)(24,31)(28,32)(29,41)(33,51)(37,53)(39,55)
  (42,57)(46,59)(48,61)(50,62)(54,63)(58,64),
 ( 2,11)( 4,13)( 6,15)( 9,16)(12,17),( 1,24)( 2,25)( 3,26)( 4,28)( 5,30)
  ( 7,31)( 8,32)(10,34)(11,36)(13,37)(14,39)(16,44)(18,48)(20,52)(21,56)
  (22,62)(27,64)(33,65)(38,66)(47,81)(55,83)(61,85),
 ( 1,24)( 2,25)( 3,26)( 5,28)( 7,30)( 8,32)(10,33)(12,34)(13,36)(15,38)
  (17,39)(18,40)(20,42)(21,44)(27,46)(35,48)(41,50),
 ( 1,32)( 5,33)( 8,34)( 13,35)( 23,36)( 26,37)( 29,38)( 39,63)
  ( 40,64)( 44,69)( 45,70)( 46,75)( 49,76)( 50,81)( 51,82)( 55,87)
  ( 56,88)( 57,93)( 60,94)( 65,97)( 68,98)( 77,99)( 80,100)( 89,101)
  ( 92,102),( 1,9)( 3,11)( 7,14)(10,16)(13,17),
 ( 1,10)( 3,16)( 6,32)( 8,37)(12,39)(15,42)(18,46)(20,47)(22,51)(27,54)
  (31,57)(34,59)(41,62)(44,63)(49,65)(50,66)(53,70)(56,73)(58,74)(61,78)
  (68,81)(72,83)(76,84)(80,86),( 1,15)( 2,17)( 3,21)( 4,23)(10,29)(11,35)
  (12,40)(13,42)(18,48)(19,51)(22,55)(25,61)(26,62)(27,63)(30,68)(32,70)
  (34,72)(36,74)(38,76)(41,78)(43,79)(45,81)(47,83)(49,84)(52,86)(54,88)
  (56,89)(58,91)(60,93)(67,94)(69,95)(71,96)(73,97)(75,98)(77,99),
 ( 1,11)( 2,14)( 3,18)( 4,21)( 5,26)( 6,29)( 7,34)( 8,37)( 9,39)(13,40)
  (15,43)(19,44)(23,45)(25,48)(28,52)(31,54)(32,56)(36,57)(41,61)(46,65)
  (49,67)(50,69)(53,70)(58,72)(59,74)(62,76)(63,78)(66,79)(71,80)(75,81),
 ( 1,9)( 2,19)( 3,22)( 4,29)( 5,33)( 6,35)( 8,36)(10,38)(12,40)(15,42)
  (17,44)(21,48)(25,51)(26,53)(30,56)(32,58)(37,63)(39,65)(41,67)(43,69)
  (46,72)(49,73)(50,74)(52,76)(54,78)(55,79)(59,82)(60,83)(62,84)(64,85)
  (66,86)(68,87)(70,88)(71,90)(75,91)(77,92)(80,93)(81,95)(89,96)(94,97),
 ( 1, 9)( 2,18)( 3,25)( 4,30)( 5,32)( 35,51)( 38,59)( 39,60)
  ( 44,61)( 45,62)( 48,63)( 53,65)( 54,66)( 57,68)( 58,77)( 70,87)
  ( 73,90)( 76,93)( 79,96)( 82,99)( 85,102)( 86,104)( 89,106)( 92,107)
  ( 95,109)( 98,110)(101,112),( 1,10)( 2,17)( 3,21)( 5,36)( 7,39)
  ( 12,43)( 14,44)( 16,46)( 20,47)( 25,51)( 26,52)( 28,53)( 38,67)
  ( 42,69)( 49,74)( 50,77)( 56,81)( 60,85)( 64,94)( 68,104)( 73,106)
  ( 76,107)( 98,125)(103,130)(105,131)(109,132)(111,135)(113,137)(115,139)
  (118,142)(120,144)(122,146)(124,148),( 1,39)( 2,40)( 5,43)( 8,47)(10,48)
  (12,50)(14,52)(17,57)(20,60)(22,61)(24,64)(26,66)(29,69)(30,70)(31,72)
  (35,76)(41,77)(46,79)(55,81)(56,84)(62,85)(68,87)(74,89)(75,92),
 ( 1,23)( 3,24)( 6,28)(10,29)(13,30)(15,34)(18,35)(20,36)(26,37)(27,38)
  (32,39)(33,40),( 1,2)( 9,10)(13,14)(18,19)(25,26)(32,33),
 ( 1,3)( 7,8)(11,12)(17,18),( 1,5)( 2,9)( 3,26)(28,45)(29,48)(30,51)
  (31,66)(32,69)(33,72)(35,76)(40,78)(42,79)(47,80)(49,82)(54,84)(56,85)
  (61,86)(63,88)(68,90)(70,91)(75,92),( 1,2)(13,14)(15,16)(18,19)(21,22)
  (24,25)(29,30)(33,34),( 1, 9)( 2,17)( 3,20)( 4,23)( 5,35)
  ( 36,45)( 38,56)( 39,57)( 43,59)( 44,62)( 48,64)( 50,67)( 51,68)
  ( 54,77)( 55,86)( 70,88)( 73,90)( 76,92)( 79,94)( 82,96)( 85,98)
  ( 89,100)( 91,101)( 93,104)( 95,105)( 97,108)( 99,109),
 ( 2,9)( 4,10)( 5,11)( 6,12),( 1,7)( 2,10)( 4,12)( 6,13)( 9,14)(11,15),
 ( 1,10)( 2,16)( 3,20)( 4,25)(11,27)(14,28)(23,30),
 ( 1,22)( 3,23)( 6,25)( 8,28)(11,30)(14,32)(17,35)(19,37)(24,38)(27,39)
  (31,40)(34,41),( 1,7)( 2,14)( 3,19)( 5,23)( 9,24)(11,25)(15,26)(18,27)
  (22,28),( 1,24)( 3,26)( 5,27)( 6,29)( 8,31)(10,33)(11,34)(13,35)(15,37)
  (16,39)(17,41)(19,42)(20,43)(22,45)(25,46)(32,47)(40,48),
 ( 1,7)( 2,14)( 3,17)( 6,20)( 8,23)(24,35)(29,38)(32,40)(36,43)(39,46)
  (41,48)(44,50),( 2,9)( 3,14)( 6,20)(11,21)(13,24)(18,26)(23,27)(25,29),
 ( 1,7)( 2,13)( 3,23)( 9,26)(12,27)(18,30)(20,31),
 ( 1,10)( 3,13)( 6,16)( 8,19)(12,21)(17,23),
 ( 1,12)( 3,19)( 6,32)( 8,40)(13,45)(16,47)(20,49)(23,50)(26,51)(29,52)
  (33,54)(35,55)(37,57)(41,58)(44,59)(46,60)(53,61),( 1,2)( 7,8)(11,13),
 ( 1,5)( 2,9)( 3,11)( 8,24)(14,25),( 1,6)( 9,13)(10,16)(11,23)(12,27)
  (18,35)(19,36)(24,37)(26,38)(33,39)(49,60)(54,61)(59,62),
 ( 1,6)( 9,12)(10,23)(11,27)(16,35)(18,36)(24,37)(26,38)(30,39)(31,40)
  (33,42)(34,49),( 1,10)( 3,12)( 4,14)( 7,16),
 ( 1,7)( 2,9)( 3,10)( 5,14)( 8,17)(11,20)(13,21)(15,22)(18,23),
 ( 1,9)( 3,11)( 5,12)( 6,14),( 1,23)( 3,24)( 5,25)( 6,28)( 8,30)(10,31)
  (11,32)(13,33)(15,36)(16,38)(18,39)(19,40)(21,43)(22,45)(27,46)(35,47)
  (42,48),( 1,9)( 2,15)( 3,19)( 4,23)( 5,26)( 6,32)( 7,34)( 8,39)(10,41)
  (12,44)(14,45)(16,48)(18,49)(22,50)(24,53)(27,54)(29,56)(31,59)(35,60)
  (38,61)(43,62)(46,64)(52,65)(57,67),( 1,9)( 3,23)( 6,36)( 7,40)(13,44)
  (16,46)(18,49)(22,50)(26,54)(28,57)(30,58)(31,59)(33,61)(35,64)(42,65)
  (43,68)(52,69)(53,72)(56,73)(67,74)(71,75),
 ( 1,7)( 3,8)( 4,12)( 5,13)( 9,17)(11,18)(14,19)(16,20),
 ( 1,17)( 3,19)( 4,20)( 7,21)( 8,23)(10,24)(13,26)(14,27)(22,40)(30,47)
  (39,58)(46,59)(49,63)(56,65)(57,66)(62,71)(64,72),
 ( 1,2)(11,12)(13,14)(15,16)(17,18)(19,20)(26,27)(28,29)(30,31),
 ( 1,17)( 3,19)( 5,20)( 7,22)( 9,23)(11,25)(13,26)(15,28)(18,40)(24,41)
  (34,52)(44,62)(50,63)(54,65)(60,66),( 1,17)( 3,19)( 6,20)( 8,21)( 9,23)
  (11,25)(14,26)(16,27)(18,40)(24,41)(34,53)(44,61)(48,63)(54,64)(58,66),
 ( 1, 7)( 2,13)( 3,15)( 4,20)( 5,27)( 35,44)( 36,59)( 41,61)
  ( 42,62)( 47,64)( 50,65)( 51,66)( 56,67)( 57,76)( 58,85)( 68,87)
  ( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 88,104)( 91,106)( 94,107)
  ( 97,109)(100,110)(103,112),( 1,14)( 2,18)( 3,20)( 4,25)( 9,30)(10,35)
  (11,41)(13,44)(15,50)(17,51)(22,57)(24,60)(27,63)(28,64)(32,72)(34,74)
  (36,76)(38,78)(40,80)(42,82)(43,83)(45,84)(47,85)(49,86)(52,87)(54,88)
  (56,89)(58,90)(61,91)(71,92)(73,93)(75,94)(77,95)(79,96)(81,97),
 ( 1,5)( 2,8)( 3,12)(28,45)(29,48)(30,51)(31,66)(32,69)(33,72)(35,76)
  (40,78)(42,79)(47,80)(49,82)(54,84)(56,85)(61,86)(63,88)(68,90)(70,91)
  (75,92),( 1,3)( 8,9)(11,12)(13,14)(16,17)(20,21),
 ( 1,17)( 3,18)( 4,20)( 6,21)( 8,23)( 9,24)(11,25)(13,27)(14,28)(15,30),
 ( 1,17)( 3,18)( 5,21)( 6,22)( 9,23)(12,25)(13,26)(15,27)(20,45)(24,46)
  (31,48)(36,51)(41,54),( 1,3)( 8,9)(11,12),
 ( 1,2)(13,15)(16,17)(18,20)(22,23)(24,26)(27,29)(31,33)(35,37),
 ( 1,7)( 8,13)( 9,26)(10,29)(11,42)(16,44)(18,45)(27,46)(28,47)(37,48)
  (39,49),( 1,25)( 2,27)( 4,28)( 5,30)( 7,32)( 8,33)(10,34)(11,36)(12,38)
  (13,39)(14,40)(16,43)(17,49)(18,53)(20,57)(22,61)(26,64)(31,65)(37,66)
  (44,80)(50,82)(58,84),( 1,3)( 6,11)( 7,13)( 8,15)( 9,16)(10,17)(12,19)
  (14,21)(18,23)(20,24)(22,25),( 1,9)( 4,12)( 7,17)(10,20)(14,21)(16,22)
  (19,23),( 1,24)( 4,26)( 6,28)( 8,29)(10,30)(14,31)(17,33)(19,34)(22,35)
  (27,36)(32,38),( 1,12)( 6,19)(13,40)(16,41)(20,43)(23,44)(27,46)(28,49)
  (29,51)(30,53)(32,55)(33,58)(34,60)(35,62)(37,64)(38,67)(39,70)(48,75)
  (50,76)(52,77)(54,78)(57,79)(59,80)(61,81)(63,82)(66,83)(68,84)(69,85)
  (71,86)(72,87)(73,88)(74,89),( 1, 7)( 2,12)( 3,19)( 4,28)
  ( 5,34)( 35,41)( 38,60)( 39,61)( 44,63)( 47,64)( 48,65)( 53,66)
  ( 54,67)( 57,76)( 58,85)( 68,87)( 71,90)( 74,93)( 77,96)( 80,99)
  ( 83,102)( 88,104)( 91,106)( 94,107)( 97,109)(100,110)(103,112),
 ( 1,9)( 3,14)( 5,19)( 8,26)(10,45)(12,46)(15,47)(17,50)(20,51)(23,52)
  (24,53)(27,56)(29,57)(33,61)(42,71)(48,73)(54,74)(63,75)(69,77),
 ( 1,28)( 3,30)( 4,31)( 6,32)( 7,34)( 9,35)(10,36)(12,39)(13,40)(14,41)
  (16,42)(19,46)(23,48)(24,51)(29,53)(33,55)(37,57)(38,58)(45,65)(47,70)
  (49,71)(52,72)(54,73)(56,74)(59,75)(61,76)(63,77)(66,78)(68,79),
 ( 1,11)( 2,32)( 3,41)( 4,43)( 6,44)( 8,48)(10,49)(12,51)(14,52)(18,53)
  (20,57)(21,58)(23,60)(26,62)(28,63)(31,64)(33,68)(35,69)(37,70)(40,72)
  (45,74)(47,75)(50,76)(54,78)(56,79)(59,80)(61,82)(65,84)(67,85)(71,87)
  (73,89)(77,91)(81,92)(83,94)(86,95)(88,96)(90,97)(93,98),
 ( 1,3)( 6,9)(10,12)(15,18)(20,21)(23,24)(26,27),
 ( 1,17)( 4,20)( 6,21)( 7,22)( 9,23)(12,26)(14,27)(15,28)(18,41)(24,42)
  (30,46)(34,53)(51,62)(60,64),( 1, 9)( 3,14)( 6,25)( 10,35)
  ( 11,36)( 13,37)( 15,38)( 16,41)( 18,45)( 21,46)( 23,50)( 31,68)
  ( 39,71)( 42,72)( 43,73)( 47,77)( 48,78)( 51,79)( 53,85)( 61,90)
  ( 64,97)( 69,99)( 74,101)( 82,118)( 84,121)( 87,122)( 89,123)( 92,126)
  ( 94,127),( 1,7)( 4,15)( 5,20)( 8,23)(10,24)(14,26)(16,27),
 ( 2, 8)( 5,19)( 6,26)( 7,32)( 9,36)( 11,38)( 13,41)( 16,43)
  ( 17,47)( 20,49)( 22,50)( 24,53)( 33,77)( 34,78)( 39,79)( 44,80)
  ( 45,81)( 51,82)( 55,88)( 58,91)( 66,93)( 69,96)( 73,97)( 90,109)
  ( 95,110),( 2,10)( 4,13)( 5,16)( 8,20)(14,21)(19,23),
 ( 1,2)( 8,11)(19,20)(22,23)(26,27)(29,30)(31,32)(36,37)(39,40)(43,44)
  (45,46)(50,51)(52,53)(57,58)(59,60)(61,62)(64,65),
 ( 1,12)( 2,33)( 3,42)( 5,43)( 7,44)( 9,48)(11,49)(13,51)(15,52)(19,53)
  (21,57)(22,58)(24,60)(27,62)(29,63)(32,64)(34,68)(36,69)(38,70)(41,72)
  (45,74)(47,75)(50,76)(54,78)(56,79)(59,80)(61,82)(65,84)(67,85)(71,87)
  (73,89)(77,91)(81,92)(83,94)(86,95)(88,96)(90,97)(93,98),
 ( 1,5)( 2,7)( 3,12)(14,26)(17,29)(24,35)(27,37)(31,40)(33,42)(36,44)
  (41,47)(43,49),( 2,41)( 5,43)( 6,44)( 9,48)(11,49)(14,51)(15,52)(18,56)
  (21,58)(22,59)(25,61)(27,62)(30,66)(33,67)(34,68)(37,72)(40,74)(47,75)
  (54,77)(55,79)(65,81)(70,83)(71,85),( 1,5)( 2,7)( 3,11)( 8,23)(13,25),
 ( 1,9)( 5,12)( 7,14)(10,16)(13,17),( 2, 9)( 4,15)( 5,21)( 7,33)
  ( 10,34)( 11,37)( 13,38)( 14,39)( 16,43)( 19,46)( 20,47)( 23,50)
  ( 25,51)( 30,72)( 31,76)( 32,77)( 35,79)( 41,82)( 42,83)( 48,85)
  ( 78,103)( 84,105),( 1,24)( 5,26)( 8,27)(10,29)(13,30)(15,32)(17,33)
  (19,34)(22,36)(25,37)(31,38),( 1,9)(10,14)(11,17)(12,28)(13,31)(19,42)
  (21,43)(29,44)(30,45)(38,46)(40,47),( 1, 9)( 6,34)( 8,36)( 11,37)
  ( 14,41)( 15,42)( 16,43)( 19,46)( 20,48)( 22,50)( 24,54)( 25,55)
  ( 26,56)( 33,83)( 35,84)( 39,86)( 40,87)( 45,88)( 47,89)( 52,91)
  ( 53,92)( 57,99)( 61,101)( 65,102)( 70,104)( 74,106)( 78,107),
 ( 2,8)( 5,10)( 7,13)( 9,16)(12,18),( 1,7)( 4,10)( 6,12)( 8,16)(11,19),
 ( 1,27)( 3,28)( 4,31)( 6,32)( 7,33)(10,35)(13,36)(16,38)(17,43)(19,46)
  (20,48)(21,50)(22,51)(24,52)(25,54)(26,58)(29,59)(30,60)(34,61)(37,62)
  (40,63)(42,66)(45,69)(47,70)(49,71)(53,72)(56,73)(57,74)(65,75)(68,76),
 ( 1,10)( 2,13)( 3,17)( 4,18)( 5,21)( 6,25)( 7,27)( 8,29)( 9,34)(12,38)
  (15,40)(20,45)(24,47)(28,51)(32,56)(33,57)(36,59)(39,62)(42,64)(44,65)
  (48,66)(50,67)(53,69)(55,70)(60,71)(63,72)(68,77)(73,82)(78,83),
 ( 1,9)( 3,12)( 5,16)( 7,20)( 8,21)(11,22)(13,23)(15,24)(17,25)(19,26),
 ( 1,20)( 2,21)( 3,23)( 4,24)( 5,25)( 6,26)( 7,28)( 8,29)( 9,31)(18,32)
  (19,34),( 1,27)( 4,29)( 7,31)( 8,32)(10,33)(11,34)(13,36)(14,37)(17,42)
  (18,43)(20,46)(21,49)(22,50)(23,51)(25,54)(26,55)(28,57)(30,58)(35,60)
  (38,63)(40,66)(44,70)(45,71)(47,72)(52,74)(53,77)(56,78)(59,79)(61,82)
  (64,85)(67,86)(69,87)(73,88)(75,89)(80,90)(83,91),
 ( 1,7)( 4,8)( 6,9)(12,18)(14,20)(17,22),
 ( 1,7)( 5,24)( 6,36)( 8,37)(10,38)(11,39)(12,42)(14,43)(16,46)(17,49)
  (18,50)(19,51)(20,53)(21,54)(22,57)(23,58)(33,86)(35,87)(45,89)(48,90),
 ( 1,3)( 9,11)(19,20)(22,23)(26,27)(29,30)(32,33)(36,37)(40,41)(42,43)
  (47,48)(50,51)(52,53)(54,55)(57,58),( 1,20)( 2,21)( 3,22)( 4,24)( 5,25)
  ( 6,26)( 7,27)( 8,29)( 9,31)(18,33)(19,35),
 ( 1,2)( 6,7)(13,14)(18,19)(25,26)(31,32),
 ( 1,10)( 2,13)( 4,14)( 6,18)( 7,19)( 9,21)(12,23)(17,25),
 ( 2,15)( 4,23)( 7,33)( 8,39)(10,40)(13,41)(17,42)(19,46)(21,47)(26,52)
  (29,53)(31,54)(34,58)(37,62)(44,63)(50,64)(56,66)(60,67),
 ( 1,10)( 3,15)( 5,19)( 6,23)(11,43)(13,44)(16,47)(20,48)(21,49)(24,50)
  (26,53)(29,54)(33,58)(38,65)(45,71)(51,72)(60,76)(61,77)(66,79)(69,81)
  (78,87)(82,88),( 1,5)( 2,10)( 7,12)( 8,13)( 9,14)(11,15)(16,19)(17,20)
  (18,21),( 1,4)( 8,10)(12,14)(18,21)(22,23)(27,29)(30,31)(35,37)(41,43)
  (46,47)(50,51)(53,54),( 1,11)( 2,17)( 4,26)( 7,42)(12,43)(18,46)(20,48)
  (22,52)(24,53)(27,54)(31,55)(34,58)(36,60)(38,64)(40,65)(44,66)(49,67)
  (56,68)(61,69),( 1,10)( 2,12)( 3,15)( 4,19)( 5,24)( 6,26)( 7,31)( 8,33)
  ( 9,35)(17,40)(21,46)(22,48)(27,52)(29,53)(37,58)(38,59)(39,60)(41,61)
  (42,64)(43,66)(45,68)(47,71)(49,72)(50,73)(54,75)(55,76)(57,79)(63,83)
  (65,86)(67,87)(69,88)(77,91)(78,92)(80,93)(81,96)(82,97)(84,98),
 ( 1,5)( 2,6)(15,25)(17,31)(19,37)(21,43)(23,49)(28,52)(32,56)(36,60)
  (40,64)(44,68)(48,72)(51,74)(57,77)(59,78)(65,81)(67,82)(73,85),
 ( 1,7)( 8,12)( 9,15)(10,28)(11,31)(18,44)(20,45)(29,46)(30,47)(39,48)
  (41,49),( 1,5)( 2,11)( 3,15)( 6,22)(14,28)(18,32)(23,34)(29,36),
 ( 1,19)( 2,23)( 9,39)(10,40)(13,41)(14,42)(15,43)(17,44)(18,48)(20,50)
  (21,51)(22,52)(25,53)(26,54)(27,55)(29,56)(30,60)(32,62)(33,63)(34,64)
  (36,66)(38,68)(45,69)(46,70)(47,71)(49,72)(57,75)(58,76)(59,77)(61,78)
  (65,81)(67,82)(73,85)(74,86)(79,87)(80,88)(83,89)(84,90),
 ( 1,3)( 9,10)(16,18)(20,22)(25,26)(28,29)(31,32)(34,35),
 ( 1, 2)( 4, 5)( 10,11)( 17,18)( 22,23)( 25,26)( 30,31)( 33,34)
  ( 39,40)( 41,42)( 44,45)( 47,48)( 52,53)( 54,55)( 57,58)( 59,60)
  ( 63,64)( 67,68)( 70,71)( 73,74)( 77,78)( 81,82)( 84,85)( 87,88)
  ( 91,92)( 95,96)( 99,100),( 1,8)( 2,9)( 4,11)( 5,13)( 7,15)(10,17)
  (14,18),( 1,10)( 2,12)( 4,14)( 6,16),( 1,8)( 2,16)( 3,20)( 6,22)( 9,26)
  (14,29)(27,32)(30,36),( 2,9)( 4,11)( 5,14)( 7,17)(15,22)(20,24),
 ( 1,5)( 3,11)( 6,12),( 1,8)(11,16)(12,19)(14,28)(15,31)(21,40)(22,42)
  (29,43)(30,45)(37,46)(38,48),( 1,6)( 2,9)( 3,14)( 4,27)( 5,34)( 8,40)
  (11,41)(13,42)(15,44)(17,46)(18,48)(20,50)(22,52)(25,54)(28,55)(30,57)
  (31,59)(35,62)(37,64)(39,65)(43,66)(47,68)(49,69)(51,70)(53,72)(56,73)
  (60,75)(61,76)(63,78)(67,79)(71,80)(74,81)(77,82),
 ( 2,7)( 3,10)( 4,12)( 6,13)( 9,15)(11,18)(14,21)(17,22)(20,23),
 ( 1,5)( 3,10)( 4,23)( 9,24)(16,25)(19,26)(22,27),
 ( 1,11)( 2,15)( 3,22)( 4,36)( 6,37)( 7,38)( 12,42)( 16,43)
  ( 18,45)( 20,46)( 25,50)( 27,53)( 39,69)( 40,72)( 47,77)( 51,79)
  ( 56,89)( 60,98)( 64,102)( 70,103)( 73,104)( 78,106)( 85,122)(105,130)
  (107,131)(108,133)(110,135)(113,138)(115,140)(117,142)(119,145)(123,147)
  (125,149),( 1, 7)( 2,21)( 3,25)( 4,27)( 5,33)( 36,45)( 38,59)
  ( 39,60)( 42,62)( 46,65)( 47,66)( 51,69)( 52,70)( 55,72)( 56,78)
  ( 73,85)( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 84,102)( 87,103)
  ( 90,105)( 93,106)( 96,108)( 99,109),( 1,7)( 2,10)( 3,24)( 4,31)(34,43)
  (35,46)(36,58)(37,61)(39,68)(40,69)(44,72)(45,74)(49,75)(50,76)(54,79)
  (55,81)(59,82)(60,83)(64,86)(65,88),( 1,10)( 6,25)( 8,31)(13,37)(15,40)
  (17,41)(19,42)(23,47)(24,48)(26,49)(28,52)(29,53)(35,58)(36,59)(38,60)
  (43,63)(45,64)(50,67)(56,71)(65,75)(70,77)(72,78)(74,79)(76,80),
 ( 2,31)( 3,33)( 5,34)( 6,36)( 7,37)( 9,38)(10,39)(12,41)(13,42)(15,43)
  (16,45)(19,47)(22,48)(26,50)(29,51)(32,52)(35,54)(40,56)(44,58)(46,59)
  (49,60)(53,61)(55,62)(57,63),( 1,4)( 2,5)( 7,12)( 9,13)(11,14),
 ( 2,31)( 3,32)( 4,34)( 6,35)( 7,37)( 9,38)(10,40)(12,41)(13,42)(15,44)
  (16,45)(17,46)(21,48)(24,49)(28,51)(33,52)(36,54)(39,55)(43,57)(47,59)
  (50,60)(53,61)(56,62)(58,63),( 1, 8)( 2,14)( 3,20)( 4,27)
  ( 5,31)( 32,49)( 35,56)( 36,57)( 41,60)( 42,61)( 45,65)( 50,67)
  ( 51,69)( 54,72)( 55,81)( 73,91)( 76,94)( 79,97)( 82,100)( 85,103)
  ( 88,106)( 89,108)( 92,110)( 95,114)( 98,116)(101,120)(104,122),
 ( 1,24)( 2,25)( 3,26)( 4,29)( 6,30)( 7,31)( 9,32)(10,35)(11,36)(12,37)
  (14,40)(15,47)(17,50)(19,55)(20,58)(21,61)(22,64)(27,67)(33,68)(38,69),
 ( 1,24)( 2,25)( 3,26)( 5,27)( 7,30)( 8,33)(10,34)(12,35)(13,36)(15,39)
  (17,42)(18,43)(19,44)(20,45)(21,48),( 2,7)( 6,8)(10,14)(13,15),
 ( 1,15)( 2,19)( 3,21)( 4,26)(29,34)(30,38)(31,52)(32,56)(35,71)(36,72)
  (41,75)(42,77)(47,80)(48,81)(53,84)(54,86)(59,89)(60,90)(65,93)(66,95),
 ( 1,2)( 7,9)(14,16),( 1,15)( 2,18)( 3,25)( 4,27)( 5,33)( 6,36)( 8,37)
  ( 9,38)(11,40)(14,43)(16,47)(19,50)(21,51)(23,53)(29,54)(31,57)(34,58)
  (39,60)(41,61)(44,62)(45,64)(46,66)(49,68)(52,72)(55,73)(56,75)(59,81)
  (63,82)(65,83)(69,84)(71,85)(74,86)(76,87)(78,88)(80,89),
 ( 1,5)( 3,9)(13,24)(16,33)(26,35)(29,38)(31,44)(37,49)(39,51)(41,53)
  (43,55)(45,57)(47,59)(50,61)(54,63)(58,65),
 ( 2,7)( 8,22)(11,24)(13,25)(14,26)(16,27)(17,28)(19,29)(20,30),
 ( 1,10)( 2,17)( 3,24)( 4,30)( 5,37)( 6,40)( 9,43)(11,45)(15,47)(18,48)
  (20,50)(22,51)(25,53)(27,55)(28,57)(31,58)(33,60)(36,61)(38,63)(41,64)
  (42,65)(44,66)(46,68)(49,69)(52,70)(54,71)(56,73)(59,74)(62,76)(67,77)
  (72,79)(75,81)(78,82)(80,83),( 1,22)( 3,23)( 5,26)( 6,29)( 7,30)(10,32)
  (11,35)(12,36)(14,37)(16,38)(17,41)(19,44)(21,45)(25,46)(27,47)(31,49)
  (33,50)(40,52)(42,53),( 1,3)( 5,7)(10,12)(16,17)(19,20)(22,23),
 ( 1,7)( 2,15)( 3,17)( 6,20)( 8,23)(14,29)(24,35)(30,39),
 ( 1,4)( 2,8)( 3,12)( 7,23)(14,29)(17,31)(22,33)(28,36),
 ( 1,28)( 2,29)( 3,32)( 5,33)( 6,35)( 8,36)( 9,39)(10,41)(11,42)(12,45)
  (13,46)(14,52)(16,54)(18,57)(22,59)(23,62)(24,64)(30,66)(37,67)(43,68),
 ( 1,5)( 3,8)(10,13)(12,14),( 1,15)( 2,16)( 3,17)( 5,19)( 6,20)( 8,22)
  ( 9,23)(10,24)(11,26)(13,27),( 1,5)( 3,8)(13,27)(21,35)(25,37)(28,42)
  (30,48)(39,51)(41,53)(43,55)(45,57)(47,59)(49,61)(52,63)(56,65)(60,67),
 ( 1,5)( 3,8)(13,16)(18,33)(22,35)(29,38)(31,44)(37,49)(39,51)(41,53)
  (43,55)(45,57)(47,59)(50,61)(54,63)(58,65),
 ( 2,17)( 4,18)( 6,20)( 8,21)(10,22)(12,23)(14,25)(16,26)(19,38)(24,40)
  (33,50)(36,57)(43,60)(52,65),( 1,2)(13,14)(16,18)(19,21)(23,25)(30,32)
  (34,36)(38,39)(42,43)(47,48)(49,51)(53,54)(57,59)(64,65)(68,69),
 ( 1,3)( 7,8)(16,17)(21,22)(23,24),( 1, 9)( 4,22)( 7,34)( 11,36)
  ( 14,38)( 15,40)( 17,43)( 19,45)( 21,47)( 23,48)( 25,49)( 26,51)
  ( 27,54)( 35,80)( 37,81)( 42,83)( 46,84)( 53,86)( 61,94)( 65,95)
  ( 69,96)( 74,97)( 78,98)( 82,99)( 85,100)( 92,102)(103,109)(105,110),
 ( 1,4)(10,14)(18,21)(23,25)(26,27)(30,32)(33,34)(35,36)(38,39)(40,41),
 ( 1,23)( 3,24)( 4,25)( 6,27)( 8,30)( 9,31)(11,32)(13,33)(14,35)(15,38)
  (17,39)(18,40)(20,41)(21,45)(29,46)(37,47)(44,48),
 ( 1, 8)( 2,12)( 3,20)( 4,23)( 5,26)( 36,45)( 38,56)( 39,57)
  ( 43,59)( 44,62)( 48,64)( 50,67)( 51,68)( 54,77)( 55,86)( 70,88)
  ( 73,90)( 76,92)( 79,94)( 82,96)( 85,98)( 89,100)( 91,101)( 93,104)
  ( 95,105)( 97,108)( 99,109),( 2,7)(11,21)(12,24)(13,27)(15,32)(19,34)
  (22,36)(25,37)(26,38)(28,39)(30,45)(51,63)(55,65)(59,67),
 ( 1,3)( 4,7)( 9,11)(12,15)(17,18)(19,22)(26,29)(38,40)(44,45)(46,48)
  (49,50)(51,52)(53,54)(56,58)(60,62)(65,66)(67,69)(70,71)(72,73)(74,76)
  (77,79)(80,81)(82,84)(85,87)(88,90)(91,92)(93,95),
 ( 2,6)( 3,11)( 5,23)( 8,24)(10,25)(13,26),
 ( 1,2)( 5,6)( 7,8)(10,11)(12,13)(15,16)(19,20)(23,24),
 ( 1,8)( 2,12)( 3,18)( 5,25)(14,27)(17,28)(24,30),
 ( 1, 9)( 2,15)( 3,22)( 4,28)( 5,33)( 35,37)( 36,56)( 40,59)
  ( 43,61)( 44,63)( 48,67)( 49,69)( 53,72)( 54,78)( 55,84)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 87,104)( 90,106)( 93,108)
  ( 96,110)( 99,112)(102,114),( 1,5)( 4,11)( 6,12),
 ( 2,12)( 3,15)( 4,19)( 5,22)( 6,23)( 7,27)( 8,30)(14,42)(16,44)(17,45)
  (21,47)(24,49)(25,50)(29,52)(31,53)(35,54)(36,55)(37,57)(38,58)(39,60)
  (40,61)(41,63)(43,64)(46,65)(48,66)(51,67)(56,69)(59,71)(62,73)(68,74)
  (70,75)(72,76),( 1,2)(14,15)(19,20)(23,24)(25,26)(29,30)(31,32)(34,35)
  (36,37)(39,40)(41,42)(47,48)(50,51)(53,54),
 ( 1,41)( 3,43)( 7,45)(10,46)(14,48)(17,51)(19,54)(23,56)(26,57)(28,61)
  (31,63)(35,65)(38,69)(42,70)(44,73)(47,74)(50,75)(53,77)(55,78)(59,82)
  (60,83)(62,84)(64,85)(68,87)(72,89)(76,90)(80,92)(81,93)(86,94)(88,95)
  (91,96),( 1, 2)( 4, 5)( 6, 7)( 11,12)( 14,15)( 17,18)( 20,21)
  ( 22,23)( 24,25)( 32,33)( 34,35)( 36,37)( 38,39)( 40,41)( 42,43)
  ( 47,48)( 49,50)( 51,52)( 53,54)( 55,56)( 57,58)( 59,60)( 64,65)
  ( 67,68)( 69,70)( 73,74)( 76,77)( 80,81)( 82,83)( 86,87)( 88,89)
  ( 92,93)( 95,96)( 99,100)(101,102),( 1,12)( 3,16)(15,39)(19,41)(22,42)
  (25,44)(26,45)(27,48)(28,50)(29,52)(31,53)(32,56)(33,58)(34,60)(35,63)
  (36,65)(37,67)(46,75)(47,76)(49,78)(51,79)(54,81)(55,82)(57,84)(59,85)
  (61,87)(62,88)(64,90)(66,91)(68,92)(70,93)(72,94),
 ( 1,6)(11,18)(12,21)(16,32)(20,34)(28,41)(29,42)(30,48)(31,49)(36,50)
  (38,52)(40,54)(43,56)(45,58)(47,60)(53,62)(57,64)(61,66),
 ( 1,13)( 3,17)( 5,21)( 8,29)(10,43)(12,44)(15,47)(16,48)(20,49)(23,50)
  (25,53)(26,54)(28,55)(34,59)(39,64)(46,72)(52,73)(71,80)(77,83)(79,85),
 ( 1,6)( 2,7)( 4,10)( 5,12),( 1,5)( 2,9)(10,14)(12,15),
 ( 1, 8)( 2,12)( 3,14)( 4,19)( 26,43)( 27,47)( 28,61)( 29,65)
  ( 32,67)( 33,71)( 38,72)( 39,77)( 44,79)( 45,83)( 50,84)( 51,89)
  ( 56,91)( 57,95)( 62,96)( 63,101),( 2,9)( 5,11)( 6,12)( 8,15)(10,18),
 ( 1,2)( 5,6)( 8,9)(13,14),( 1,23)( 3,24)( 5,25)( 6,28)( 8,30)(10,31)
  (11,32)(13,33)(15,36)(16,37)(18,38)(19,39)(21,42)(22,44)(26,46)(34,48)
  (40,50),( 1,41)( 4,43)( 7,47)( 8,48)(11,49)(14,53)(16,54)(19,56)(20,57)
  (23,59)(26,63)(27,64)(30,66)(32,67)(35,71)(36,72)(39,74)(44,76)(45,78)
  (50,80)(60,82)(61,84)(68,86),( 1,10)( 3,12)( 5,14)(11,16)(15,17),
 ( 1,23)( 3,24)( 5,25)( 6,27)( 8,30)(10,31)(11,32)(13,33)(15,35)(16,38)
  (17,39)(19,40)(20,41)(22,45)(28,46)(36,47)(43,48),
 ( 1,9)( 2,14)( 3,24)( 4,33)( 6,36)( 7,38)(10,41)(12,43)(13,45)(16,48)
  (18,51)(21,54)(22,56)(25,58)(27,60)(40,89)(44,90)(53,92)(57,93),
 ( 1,2)( 3,10)( 7,12)( 8,13)( 9,14)(11,15)(16,19)(17,20)(18,21),
 ( 1,5)( 4,10)( 7,11)( 9,12),( 1,14)( 2,17)( 3,22)( 4,26)( 9,34)(10,38)
  (11,41)(12,43)(15,49)(18,52)(21,56)(25,62)(27,63)(28,64)(31,72)(33,74)
  (35,76)(37,78)(40,80)(42,82)(44,83)(46,84)(48,85)(50,86)(53,87)(55,88)
  (57,89)(59,90)(61,91)(71,92)(73,93)(75,94)(77,95)(79,96)(81,97),
 ( 1,23)( 3,25)( 5,26)( 6,27)( 8,30)( 9,32)(11,33)(13,34)(14,35)(16,38)
  (18,40)(19,41)(21,42)(24,44)(28,47)(29,49)(36,51)(37,53)(43,54)(46,55)
  (50,56),( 1,22)( 2,23)( 3,25)( 4,27)( 5,29)( 6,30)( 7,32)( 9,34)(10,36)
  (12,37)(15,45)(16,49)(18,54)(19,58)(21,64)(26,67)(28,68)(33,70)(35,71)
  (38,73)(39,74)(47,86)(56,89)(63,92),( 1,12)( 4,20)( 6,25)( 8,30)( 9,45)
  (13,47)(14,48)(16,49)(18,50)(21,53)(23,54)(26,55)(28,56)(33,58)(42,68)
  (46,73)(51,75)(59,77)(66,79),( 1, 6)( 2,11)( 3,17)( 4,36)
  ( 13,41)( 15,42)( 18,44)( 22,47)( 24,49)( 26,52)( 28,53)( 37,69)
  ( 38,71)( 45,76)( 50,79)( 56,87)( 61,97)( 65,101)( 72,103)( 73,104)
  ( 77,105)( 78,106)( 85,121)( 88,123)( 95,124)( 98,126)(102,127)(107,131)
  (109,133)(112,135)(114,137)(116,139)(119,141)(122,143)(125,144)(132,145)
  (134,146)(136,147)(138,148)(140,149)(142,150),
 ( 1,14)( 2,16)( 3,19)( 4,22)( 5,24)( 6,27)( 7,31)( 8,34)( 9,35)(11,36)
  (13,38)(17,40)(21,43)(25,48)(29,52)(30,53)(39,61)(41,62)(44,63)(45,64)
  (49,68)(51,69)(54,71)(57,72)(60,74)(65,76)(67,77)(73,79),
 ( 1,5)( 4,9)( 6,21)( 8,22)(12,25)(14,26)(18,29),
 ( 1,8)( 2,11)( 3,15)( 4,16)( 6,20)( 9,22)(12,24)(17,26),
 ( 1,2)( 3,5)( 6,8)( 9,11)(17,19)(24,26),
 ( 1,14)( 2,16)( 3,17)( 4,19)( 6,20)( 7,21)( 8,23)( 9,24)(11,26)(12,27),
 ( 1,5)( 4,9)( 6,12)( 8,13)(10,15)(11,17)(14,18)(16,19),
 ( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)(35,36)(37,38)(39,40),
 ( 1,28)( 3,29)( 4,32)( 6,33)( 7,34)( 9,37)(10,38)(12,39)(13,42)(15,43)
  (16,44)(20,49)(24,52)(25,55)(30,56)(31,57)(35,58)(36,59)(40,60)(41,61)
  (47,62)(50,63)(53,64),( 1, 7)( 4,20)( 9,35)( 12,37)( 13,39)
  ( 15,42)( 17,44)( 19,46)( 21,47)( 23,48)( 24,50)( 25,53)( 27,55)
  ( 34,80)( 36,81)( 41,83)( 45,84)( 52,86)( 61,94)( 65,95)( 69,96)
  ( 74,97)( 78,98)( 82,99)( 85,100)( 92,102)(103,109)(105,110),
 ( 1,24)( 4,25)( 6,27)( 9,29)(13,30)(15,31)(17,33)(19,35)(22,36)(26,37)
  (32,38),( 2, 8)( 5,24)( 7,33)( 9,34)( 10,36)( 13,39)( 16,41)
  ( 18,43)( 21,46)( 32,71)( 35,74)( 37,76)( 38,77)( 42,82)( 44,84)
  ( 45,85)( 48,92)( 50,94)( 52,96)( 54,98)( 56,102)( 58,104)( 60,106)
  ( 62,108)( 64,110)( 66,114)( 68,116)( 69,118)( 72,119)( 73,120)( 78,121)
  ( 80,122)( 81,123)(101,130)(113,132),( 1,11)( 2,20)( 3,24)( 4,33)( 5,39)
  ( 6,41)( 7,42)( 9,45)(13,46)(15,49)(17,50)(18,51)(21,52)(26,53)(28,54)
  (30,55)(32,58)(34,59)(36,60)(38,61)(43,62)(44,63)(47,64)(48,67)(56,68)
  (57,71)(65,72)(66,73)(69,74)(70,75),( 1,4)( 2,7)( 3,14)(13,25)(15,28)
  (19,32)(24,35)(31,40)(34,43)(38,46)(42,48)(45,50),
 ( 1,11)( 3,13)( 6,15)( 8,16)( 9,19)(10,23)(12,25)(14,26)(18,31)(20,32)
  (22,33)(24,34)(28,35)(30,36),( 1,24)( 4,25)( 6,26)( 9,28)(11,30)(13,31)
  (15,32)(19,33)(22,35)(29,36)(34,38),( 1,5)( 4,9)(11,16)(14,29)(19,30)
  (27,38)(28,44)(31,45)(33,48)(37,51)(39,54)(41,57)(43,59)(49,67)(55,68)
  (60,69),( 2,24)( 5,26)( 9,27)(11,28)(13,29)(15,31)(18,33)(20,34)(23,35)
  (25,37)(30,39),( 1,6)( 3,9)( 4,10)( 5,15)( 7,18)(11,21)(13,22)(16,23)
  (19,24),( 1,7)( 2,8)( 5,10)( 9,15)(11,18),
 ( 1,23)( 4,24)( 6,26)( 9,29)(13,30)(15,31)(18,35)(21,36)(25,37)(28,38)
  (32,39)(34,40),( 1, 8)( 2,10)( 3,15)( 4,22)( 5,31)( 35,41)
  ( 38,60)( 39,61)( 44,63)( 47,64)( 48,65)( 53,66)( 54,67)( 57,76)
  ( 58,85)( 68,87)( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 88,104)
  ( 91,106)( 94,107)( 97,109)(100,110)(103,112),
 ( 1, 5)( 6,30)( 9,31)( 10,32)( 13,35)( 14,38)( 15,40)( 20,46)
  ( 25,50)( 28,57)( 33,66)( 34,67)( 37,70)( 43,74)( 45,77)( 47,87)
  ( 49,90)( 53,94)( 55,97)( 56,98)( 60,103)( 62,104)( 68,108)( 69,109)
  ( 73,111)( 75,113)( 76,114)( 78,115)( 80,119)( 83,123)( 86,128)( 89,131)
  ( 92,135)( 96,139)(101,143)(102,146)(106,156)(110,157)(117,158)(118,161)
  (121,163)(122,166)(125,168)(126,171)(127,173)(130,175)(133,177)(134,178)
  (137,180)(141,182)(142,183)(145,185)(148,187)(174,191)(176,192)(179,193)
  (181,194)(184,195)(186,196),( 1,2)( 9,10)(16,17)(18,19)(22,23)(24,25),
 ( 1,3)( 9,11)(12,15)(18,19)(23,24)(26,27),
 ( 2,9)( 4,14)( 6,20)(10,21)(12,24)(18,26)(23,27)(25,29),
 ( 1,11)( 2,18)( 3,22)( 4,26)(33,37)(34,41)(35,52)(36,56)(39,67)(40,68)
  (44,72)(45,74)(49,75)(50,76)(54,80)(55,82)(59,83)(60,84)(64,88)(65,90),
 ( 2,38)( 4,39)( 7,43)( 8,46)(12,48)(13,49)(16,52)(19,54)(20,55)(23,59)
  (25,62)(28,64)(29,67)(31,69)(33,70)(35,73)(36,75)(42,77)(44,80)(58,82)
  (60,85)(65,88)(78,91)(83,94),( 1,5)( 2,7)( 4,10)( 8,12)( 9,14),
 ( 1,3)( 9,11)(14,16)(19,21)(24,26)(30,32)(38,40),
 ( 1,5)( 2,7)( 4,9)(10,13)(11,14),( 1,8)( 2,22)( 3,25)( 4,30)(34,41)
  (35,44)(36,56)(37,59)(38,69)(42,72)(43,73)(47,74)(48,76)(52,79)(53,80)
  (57,81)(58,83)(62,86)(63,87)(67,88),( 1,3)( 9,11)(19,20)(22,23)(26,27)
  (29,30)(31,32)(35,36)(39,40)(44,45)(46,47)(49,50)(53,54)(55,56)(57,58),
 ( 2,24)( 6,27)( 8,28)(10,29)(12,30)(15,32)(17,34)(20,35)(22,36)(25,37)
  (31,38),( 1,23)( 2,25)( 4,26)( 5,27)( 6,28)( 8,31)(10,33)(11,34)(13,35)
  (15,36)(16,39)(18,41)(20,42)(21,43)(29,46)(37,47)(44,48),
 ( 2,38)( 7,40)( 9,43)( 11,45)( 14,46)( 17,48)( 18,50)( 20,53)
  ( 24,56)( 26,57)( 27,60)( 29,62)( 32,65)( 34,66)( 36,68)( 37,71)
  ( 39,74)( 44,78)( 49,81)( 51,84)( 55,87)( 61,91)( 70,94)( 75,97)
  ( 80,100)( 88,103)( 93,106)( 96,109)( 99,112)(102,115),
 ( 1,3)( 9,10)(11,12)(13,14)(15,16)(17,18),
 ( 1,40)( 3,43)( 6,45)( 9,47)( 11,50)( 17,51)( 19,55)( 22,59)
  ( 25,60)( 27,62)( 31,66)( 34,67)( 37,69)( 42,71)( 44,72)( 46,74)
  ( 49,77)( 53,79)( 54,80)( 58,83)( 61,84)( 63,86)( 65,89)( 68,90)
  ( 73,93)( 78,94)( 82,96)( 85,97)( 92,99)( 95,100)( 98,101),
 ( 2,28)( 3,31)( 6,32)( 7,34)( 9,35)(11,36)(13,37)(15,39)(17,42)(18,44)
  (19,48)(20,49)(21,50)(22,51)(23,52)(24,54)(25,55)(26,57)(27,58)(40,64)
  (41,67)(43,68)(46,69)(47,70)(59,74)(60,75)(61,76)(62,78)(65,79)(66,80)
  (71,82)(72,84),( 1,9)( 2,12)( 3,20)( 4,27)( 5,32)( 7,40)(10,42)(13,43)
  (15,45)(17,47)(19,48)(21,50)(23,51)(24,52)(26,54)(29,57)(31,58)(34,60)
  (36,62)(38,64)(39,65)(41,66)(46,69)(49,70)(53,71)(56,74)(61,75)(63,76)
  (68,77)(73,78),( 2,11)( 3,12)( 4,14)( 5,15)( 6,16)( 9,18)(10,19),
 ( 1,25)( 2,30)( 9,38)(11,42)(13,43)(14,44)(15,46)(17,50)(18,51)(20,52)
  (21,53)(22,54)(24,58)(26,62)(27,63)(29,64)(31,65)(32,66)(35,69)(36,70)
  (37,71)(39,72)(40,73)(41,74)(45,77)(47,78)(48,79)(49,80)(55,83)(56,84)
  (57,85)(59,86)(60,87)(61,88)(67,91)(68,92)(75,93)(76,94)(81,95)(82,96)
  (89,97)(90,98),( 1,6)( 2,10)( 4,21)( 8,23)(13,25)(16,27)(19,29),
 ( 1,3)( 5,8)(10,13)(15,18)(19,22),( 1,4)( 2,6)( 3,11)(13,26)(16,29)
  (24,35)(27,37)(31,40)(33,42)(36,44)(41,47)(43,49),
 ( 1,6)( 2,10)( 4,12)( 7,14)( 8,16)(13,17)(15,18),
 ( 1,7)( 2,11)( 3,15)( 5,22)(12,27)(17,31)(28,38)(32,40)(35,41),
 ( 1,2)( 4,5)(10,11)(17,18)(22,23)(25,26)(30,31)(33,34)(39,40)(42,43)
  (44,45)(47,48)(52,53)(55,56)(58,59)(60,61)(63,64)(67,68)(70,71)(74,75)
  (77,78)(79,80)(85,86)(87,88),( 1,9)( 2,12)( 3,15)( 4,19)( 5,23)( 6,26)
  ( 7,35)(10,41)(14,45)(16,46)(18,47)(20,50)(22,51)(24,52)(28,53)(31,55)
  (32,56)(34,59)(36,60)(38,61)(40,62)(44,63)(48,66)(57,69)(65,70)(68,71),
 ( 1,7)(10,15)(11,26)(12,29)(13,40)(17,42)(19,43)(27,44)(28,45)(36,46)
  (38,47),( 1,15)( 2,25)( 3,28)( 4,37)( 6,39)( 8,40)( 9,41)
  ( 11,42)( 12,45)( 16,49)( 18,50)( 20,52)( 22,54)( 27,58)( 43,76)
  ( 46,77)( 47,80)( 55,83)( 56,86)( 78,101)( 84,102),
 ( 1,37)( 4,40)( 6,42)( 8,45)( 9,46)(11,48)(13,51)(15,53)(16,56)(19,60)
  (21,61)(24,64)(25,66)(28,67)(31,69)(32,72)(36,76)(50,79)(55,81)(57,84)
  (71,87)(73,90)(83,92)(89,94),( 1,3)( 5,7)( 8,10)(21,23)(25,27)(32,33)
  (41,43)(45,46)(48,49)(51,53)(56,58)(59,61)(64,65)(66,68)(69,71)(74,75)
  (76,77)(80,82)(83,84)(88,89)(90,91)(94,95)(98,99),
 ( 1,8)( 2,9)( 4,11)( 6,12),( 1,7)( 3,11)(12,15)(23,32)(27,34)(28,39)
  (30,45)(36,48)(38,50)(40,52)(42,54)(44,56)(46,58)(49,60)(53,62)(57,64),
 ( 2,11)( 4,18)( 6,27)( 7,34)(12,45)(15,46)(19,47)(23,48)(25,50)(28,52)
  (31,53)(35,54)(38,55)(41,56)(44,59)(51,60)(58,61),
 ( 1,6)( 4,10)( 9,12)(11,13),( 1,6)( 4,10)(12,16)(13,17)(14,18),
 ( 1,13)( 2,18)( 3,27)( 4,30)( 9,38)(10,40)(11,41)(12,43)(14,44)(17,46)
  (19,48)(22,50)(23,51)(26,53)(28,55)(31,57)(33,59)(39,64)(42,66)(45,67)
  (49,68)(52,69)(56,70)(58,71)(63,72)(65,73),
 ( 1,11)( 2,16)( 3,18)( 4,20)( 5,24)( 6,27)( 7,28)( 8,32)( 9,35)(12,37)
  (13,38)(17,43)(21,47)(25,49)(30,54)(33,56)(39,59)(41,60)(44,62)(46,63)
  (50,64)(52,65)(55,67)(58,70)(61,74)(66,79)(69,80)(73,81)(78,82),
 ( 1,7)( 3,10)( 4,11)( 5,14)( 8,17)(12,19)(15,20)(16,21)(18,22),
 ( 2,11)( 4,16)( 6,20)( 8,21)(10,23)(17,25)(24,27)(26,29),
 ( 1,3)( 5,7)( 9,11)(17,18)(25,26)(28,30)(32,33)(34,36),
 ( 1,32)( 3,33)( 8,34)( 12,35)( 17,36)( 25,37)( 29,38)( 41,63)
  ( 44,64)( 47,66)( 50,68)( 53,70)( 55,71)( 56,73)( 59,75)( 60,76)
  ( 69,92)( 74,93)( 78,94)( 79,96)( 82,98)( 85,100)( 86,102)( 89,104)
  ( 95,107)( 97,109)( 99,111)(101,113)(103,115)(105,117)(106,118)(110,119)
  (114,120),( 1,13)( 2,18)( 3,20)( 4,24)( 9,31)(10,37)(11,42)(14,45)(16,48)
  (21,54)(23,55)(25,61)(27,63)(28,64)(30,71)(32,73)(34,75)(36,77)(38,79)
  (40,81)(44,83)(47,84)(49,85)(51,86)(53,87)(56,88)(58,89)(60,90)(62,91)
  (72,92)(74,93)(76,94)(78,95)(80,96)(82,97),
 ( 1,5)( 6,9)(12,16)(17,21)(25,28)(32,34)(40,43),
 ( 1,15)( 2,20)( 3,23)( 4,26)( 9,31)(10,34)(11,38)(12,43)(16,49)(19,53)
  (22,56)(25,62)(27,63)(28,64)(30,71)(32,73)(35,75)(37,77)(39,79)(41,81)
  (44,83)(46,84)(48,85)(50,86)(52,87)(55,88)(57,89)(59,90)(61,91)(72,92)
  (74,93)(76,94)(78,95)(80,96)(82,97),( 2,30)( 4,31)( 5,32)( 8,33)( 9,35)
  (11,37)(14,38)(15,39)(17,42)(18,44)(19,47)(20,48)(21,49)(22,50)(23,52)
  (24,53)(25,57)(26,58)(27,59)(28,60)(40,63)(41,65)(43,66)(56,67)(62,68)
  (64,69),( 1,22)( 3,23)( 4,26)( 6,28)( 8,30)(11,33)(12,35)(13,37)(15,38)
  (16,39)(18,42)(19,44)(20,46)(24,47)(25,48)(31,49)(32,50)(40,51)(41,52),
 ( 1,6)( 5,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 2,29)( 3,31)( 5,32)( 6,33)( 8,35)( 9,36)(11,37)(12,38)(13,39)(15,42)
  (16,43)(17,46)(21,48)(22,49)(28,52)(30,53)(34,55)(40,57)(41,58)(47,62)
  (50,65)(54,67)(56,68)(59,69),( 1,9)( 2,11)( 3,16)( 4,18)( 5,24)( 6,27)
  ( 7,31)( 8,35)(12,41)(15,42)(19,43)(21,46)(23,48)(26,49)(28,52)(32,53)
  (34,54)(36,57)(38,58)(40,61)(45,62)(50,64)(56,65)(59,67),
 ( 1,7)( 3,10)( 6,20)( 9,22)(11,24)(14,26)(17,28),
 ( 1,22)( 3,23)( 5,28)( 6,29)( 7,30)( 9,35)(11,36)(12,37)(14,38)(16,39)
  (17,44)(19,45)(21,46)(24,47)(27,48)(31,49)(34,50)(40,51)(43,52),
 ( 1,2)( 5,10)(12,17)(14,18)(16,19),( 1,6)( 2,9)( 5,11)( 8,13)(10,15)
  (12,17)(14,18)(16,19),( 1,5)( 3,8)( 6,21)( 9,23)(13,25)(16,27)(19,29),
 ( 1,5)( 3,8)( 7,20)( 9,22)(11,24)(21,26)(23,27),
 ( 1,11)( 3,14)( 6,18)( 8,20)(12,22)(17,24),
 ( 1,5)( 7,10)( 8,12)( 9,13)(11,14),( 1,2)( 3,4)( 5,6)( 9,11)(13,15)
  (18,20)(22,24),( 1,8)( 3,12)( 5,16)( 7,19)( 9,21)(11,22)(13,23)(15,24)
  (17,25)(20,26),( 1,9)( 2,11)( 4,14)( 7,18)(13,22)(19,24),
 ( 1,22)( 3,23)( 5,24)( 6,27)( 8,30)(10,31)(11,32)(12,33)(15,37)(16,38)
  (17,39)(19,42)(21,45)(26,46)(28,48)(35,49)(36,51)(41,52)(43,54),
 ( 1,15)( 3,18)( 5,19)( 8,22)(12,25)(17,46)(20,48)(24,50)(26,51)(28,53)
  (31,55)(33,56)(35,58)(37,60)(39,61)(41,63)(44,65)(47,66)(49,67),
 ( 1, 8)( 2,13)( 3,19)( 4,28)( 5,33)( 35,38)( 36,56)( 40,60)
  ( 42,61)( 43,63)( 47,66)( 48,68)( 52,72)( 53,81)( 54,90)( 73,91)
  ( 76,93)( 79,95)( 82,97)( 85,99)( 88,101)( 92,103)( 94,105)( 96,106)
  ( 98,108)(100,109)(102,111),( 2,7)(10,16)(12,22)(13,25)(14,32)(18,34)
  (23,36)(24,37)(27,38)(28,40)(30,46)(52,63)(56,65)(60,67),
 ( 1,5)( 3,7)( 6,21)( 9,22)(13,23)(19,28)(24,29)(26,30),
 ( 2,7)(10,14)(12,20)(13,23)(16,33)(21,35)(22,36)(25,37)(26,38)(28,40)
  (30,46)(52,63)(56,65)(60,67),( 1,5)( 8,11)(12,15)(16,19)(22,24)(27,29)
  (30,32)(35,37),( 1,8)( 3,11)( 4,13)( 6,15)( 9,16)(10,17)(14,19)(18,21)
  (20,22),( 2,23)( 5,27)( 7,28)( 9,29)(11,30)(14,33)(16,35)(19,36)(21,37)
  (25,38)(32,39),( 1,22)( 4,27)( 7,28)( 9,29)(12,32)(14,35)(17,36)(19,37)
  (23,38)(25,39)(30,40)(33,41),( 1,8)( 3,11)( 4,12)( 5,13)( 7,14)( 9,15)
  (16,20)(18,21),( 1,5)( 9,29)(13,30)(15,31)(21,32)(25,33)(27,36)(28,47)
  (35,55)(38,57)(39,58)(42,61)(46,63)(48,65)(51,67)(52,68)(56,76)(62,77)
  (66,78)(80,90)(84,92)(87,94),( 2,23)( 5,26)( 8,27)(10,28)(12,29)(14,32)
  (17,34)(19,35)(22,36)(25,38)(31,40),( 1,5)( 9,18)(10,21)(13,30)(14,33)
  (16,40)(23,43)(24,44)(31,47)(32,48)(39,51),
 ( 1,5)( 9,17)(10,21)(11,24)(19,29)(27,30)(28,36)(31,45)(33,47)(35,51)
  (37,54)(40,58)(42,60)(44,65)(48,66)(50,67)(55,68)(57,69)(61,70),
 ( 1,5)( 9,15)(10,18)(11,22)(20,29)(27,36)(28,42)(30,45)(32,47)(35,51)
  (37,54)(39,58)(41,60)(44,65)(48,66)(50,67)(55,68)(57,69)(61,70),
 ( 1,2)( 9,10)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23)(27,28)(29,30),
 ( 2,6)(10,14)(11,17)(12,20)(15,32)(16,33)(19,34)(22,36)(26,38)(29,44)
  (31,50)(54,64)(58,66)(62,68),( 1,3)( 5,7)(18,20)(23,24)(25,27)(28,29)
  (30,31)(32,34)(35,36),( 1,23)( 3,24)( 5,26)( 6,29)( 8,30)(10,31)(11,32)
  (12,34)(14,37)(15,38)(17,39)(18,41)(20,44)(22,45)(27,46)(35,47)(42,48),
 ( 1,9)( 2,15)( 3,19)( 4,25)( 5,29)( 6,31)( 8,38)(10,39)(13,41)(17,44)
  (20,46)(22,47)(23,49)(26,52)(28,54)(32,59)(34,60)(36,61)(37,62)(40,66)
  (43,69)(45,70)(48,74)(50,77)(53,78)(55,79)(58,80)(63,81)(65,82)(67,83)
  (71,84)(73,85)(75,86),( 1,9)( 2,10)( 4,12)( 6,13)( 7,15)(11,16)(14,17),
 ( 1,22)( 4,23)( 6,24)( 9,27)(11,30)(14,31)(17,32)(20,35)(26,36)(29,37)
  (34,40)(39,43)(42,44),( 2,9)( 5,12)( 8,15)(11,16)(14,17),
 ( 2,8)( 4,10)( 7,14)(12,17)(16,18),( 1,9)( 2,10)( 5,11)( 7,12),
 ( 1,13)( 3,16)( 4,17)( 5,19)( 7,20)( 9,21)(10,23)(12,24)(15,25)(18,28)
  (22,31)(27,32)(30,33),( 1,13)( 3,15)( 4,17)( 5,18)( 9,20)(12,21)(14,22)
  (16,23)(19,24),( 1,2)( 3,4)( 6,7)( 9,10)(12,13)(15,16)(19,20)(23,24),
 ( 2,12)( 3,13)( 5,15)( 8,19)(10,20)(11,21)(14,23)(16,24)(17,25)(18,27)
  (22,29)(26,30)(28,31),( 1,13)( 3,15)( 5,17)( 7,18)( 9,20)(10,21)(12,23)
  (14,24)(16,25)(19,26)(22,27),( 1,29)( 4,30)( 7,31)(10,32)(11,34)(13,35)
  (14,36)(16,39)(17,42)(18,43)(19,46)(20,47)(21,48)(22,50)(23,51)(24,52)
  (25,56)(26,57)(27,58)(28,60)(40,63)(41,65)(54,66)(61,67)(62,68)(64,69),
 ( 1,21)( 2,22)( 3,24)( 4,26)( 5,27)( 6,28)( 7,30)( 8,31)(17,32)(18,33)
  (19,35)(20,36),( 1, 5)( 2,19)( 3,26)( 4,36)( 7,38)( 9,42)
  ( 11,43)( 16,48)( 17,50)( 21,53)( 23,54)( 25,57)( 37,84)( 41,85)
  ( 45,88)( 49,89)( 56,91)( 60,98)( 64,99)( 68,101)( 72,102)( 76,103)
  ( 80,104)( 87,105)( 90,107),( 1, 3)( 5, 6)( 11,14)( 21,23)( 27,30)
  ( 31,34)( 41,42)( 44,45)( 46,48)( 51,52)( 54,56)( 58,59)( 61,63)
  ( 65,67)( 69,70)( 72,74)( 75,77)( 79,80)( 82,84)( 89,90)( 98,100)
  (101,103)(104,106),( 2,23)( 4,24)( 5,25)( 7,26)( 9,30)(10,31)(12,32)
  (14,33)(15,34)(17,38)(19,39)(22,42)(27,43)(28,44)(29,45)(35,47)(36,48)
  (37,49)(40,51)(41,52)(46,54)(50,55)(53,56),
 ( 1,7)( 3,8)( 5,11)( 9,14)(10,15)(12,16)(13,17),
 ( 1, 9)( 2,14)( 3,20)( 4,29)( 5,34)( 35,40)( 37,56)( 38,58)
  ( 42,62)( 44,63)( 45,65)( 49,68)( 50,70)( 53,81)( 54,90)( 73,91)
  ( 76,93)( 79,95)( 82,97)( 85,99)( 88,101)( 92,103)( 94,105)( 96,106)
  ( 98,108)(100,109)(102,111),( 2,6)( 3,8)(13,16)(15,17)(18,20)(19,21),
 ( 1,9)( 3,14)( 5,19)( 6,23)(11,45)(13,46)(16,47)(18,50)(21,51)(22,52)
  (26,53)(28,56)(30,57)(38,66)(43,70)(49,72)(55,73)(59,74)(75,79)(77,80),
 ( 1,2)(11,12)(14,15)(18,19)(21,22),( 1,3)( 6,11)( 9,14)(10,15),
 ( 1,13)( 4,24)( 6,26)( 8,31)( 10,34)( 12,35)( 15,37)( 16,41)
  ( 19,43)( 21,46)( 23,48)( 25,52)( 33,77)( 39,78)( 40,79)( 45,80)
  ( 50,81)( 51,82)( 57,89)( 61,90)( 64,93)( 72,95)( 75,98)( 91,109)
  ( 96,110),( 1,8)( 3,9)( 4,11)( 5,14)( 7,15)(10,18)(12,21)(16,22)(19,23)
  ,( 2,22)( 3,24)( 5,27)( 7,28)( 10,39)( 12,44)( 13,49)( 14,52)
  ( 17,58)( 18,61)( 21,66)( 25,70)( 29,75)( 30,78)( 31,81)( 32,84)
  ( 33,89)( 34,92)( 35,95)( 36,100)( 37,101)( 38,102)( 40,104)( 42,107)
  ( 45,110)( 47,112)( 48,113)( 50,115)( 53,118)( 54,119)( 56,122)( 59,125)
  ( 62,128)( 63,131)( 64,134)( 67,135)( 71,136)( 73,137)( 76,138)( 77,139)
  ( 79,141)( 80,142)( 82,144)( 83,145)( 85,147)( 87,149)( 88,150)( 90,152)
  ( 91,153)( 93,155)( 94,156)( 96,158)( 98,160)( 99,161)(103,163)(105,164)
  (106,165)(108,166)(109,167)(114,168)(116,169)(117,170)(120,171)(121,172)
  (123,173)(124,174)(126,175)(127,176)(129,177)(130,178)(132,180)(133,181)
  (140,183)(143,184)(146,185)(151,186)(154,187)(157,188)(162,189)(179,190)
  (182,191),( 1,5)(11,14)(15,19)(21,24)(25,27)(29,32)(33,35)(37,40)(41,43)
  ,( 1,5)(11,14)(15,19)(21,24)(25,27)(29,32)(33,35),
 ( 1,17)( 4,22)( 7,26)(10,31)(13,35)(18,39)(20,40)(23,42)(25,44)(27,45)
  (29,46)(33,47)(36,49)(38,50)(43,51)(48,53),
 ( 1,11)( 3,13)( 5,14)( 8,17)(18,25)(19,31),
 ( 1, 7)( 2,12)( 3,18)( 4,25)( 5,31)( 35,52)( 36,56)( 40,59)
  ( 41,61)( 45,65)( 46,67)( 49,69)( 53,72)( 54,73)( 55,79)( 74,87)
  ( 76,90)( 78,93)( 80,96)( 82,99)( 84,102)( 85,103)( 88,105)( 91,107)
  ( 94,109)( 97,111)(100,113),( 1,7)( 2,8)( 5,11)( 6,12),
 ( 2,5)( 4,8)( 6,21)( 9,23)(13,25)(16,27)(19,29),
 ( 2,22)( 4,24)( 7,26)(10,27)(13,29)(15,32)(18,34)(20,35)(23,37)(28,40)
  (31,42)(36,43)(39,44),( 1, 4)( 2,21)( 3,28)( 5,33)( 7,34)
  ( 9,37)( 10,38)( 12,41)( 15,45)( 17,48)( 18,49)( 20,50)( 22,53)
  ( 25,55)( 26,56)( 29,58)( 30,62)( 32,63)( 35,65)( 36,66)( 39,67)
  ( 42,70)( 44,71)( 46,74)( 47,77)( 51,79)( 52,80)( 54,83)( 57,84)
  ( 59,87)( 61,92)( 64,95)( 69,96)( 72,97)( 75,100)( 78,103)( 82,106)
  ( 85,107)( 88,110)( 91,111)( 94,114)( 99,115)(102,118)(105,119)(109,120)
  (113,121)(117,122),( 2,5)( 4,8)( 7,20)(10,22)(12,24)(15,26)(18,28),
 ( 1,8)( 3,9)( 6,12)(10,17)(13,20),( 2,22)( 4,23)( 5,24)( 7,27)( 9,30)
  (10,31)(12,32)(14,33)(15,36)(16,39)(17,40)(18,41)(19,42)(20,45)(21,48),
 ( 1,20)( 2,22)( 3,23)( 4,24)( 5,25)( 6,27)( 7,29)( 8,30)( 9,31)(18,33)
  (19,35),( 1,5)( 2,13)( 3,18)( 6,26)(11,27)(16,29)(22,30),
 ( 1,8)( 4,21)( 6,32)(10,39)(12,40)(14,44)(17,45)(19,49)(23,51)(26,52)
  (27,53)(29,58)(31,59)(34,63)(37,65)(42,67)(47,69)(55,72)(61,75),
 ( 1,4)( 2,16)( 3,21)( 6,25)( 9,27)(15,28)(18,30),
 ( 1,4)( 2,15)( 3,23)( 7,35)( 8,37)(10,39)(11,42)(12,44)(14,46)(16,48)
  (18,50)(20,52)(21,54)(25,57)(27,59)(47,88)(49,90)(60,91)(61,93),
 ( 1, 4)( 2,15)( 3,22)( 6,38)( 8,39)( 10,40)( 12,43)( 13,44)
  ( 16,47)( 18,49)( 20,51)( 23,52)( 24,54)( 28,57)( 36,75)( 45,80)
  ( 46,81)( 55,86)( 56,87)( 77,102)( 83,103),
 ( 1,4)( 2,15)( 3,21)( 7,25)( 9,26)(16,28)(19,29),
 ( 1,38)( 4,40)( 6,41)( 9,44)(12,45)(14,46)(16,49)(17,53)(20,57)(22,58)
  (25,60)(26,61)(28,64)(31,65)(34,69)(37,73)(43,75)(50,78)(52,80)(56,81)
  (63,85)(68,87)(72,88)(82,92)(89,95),( 1,11)( 4,27)( 6,33)( 9,39)(12,41)
  (16,44)(21,47)(23,51)(25,52)(28,56)(31,59)(35,61)(37,64)(40,68)(42,69)
  (45,72)(48,76)(49,77)(54,79)(57,80)(62,81)(66,83)(70,84)(74,86),
 ( 1,2)(11,12)(15,16)(19,20)(29,30)(32,33)(35,36)(39,40)(41,42)(45,46)
  (50,51)(52,53)(57,58)(62,63)(65,66)(67,68)(69,70),
 ( 1,23)( 4,24)( 7,27)( 8,28)(11,29)(13,30)(16,34)(18,35)(21,36)(25,38)
  (31,40),( 1,12)( 2,20)( 3,26)( 4,35)( 5,37)( 7,39)( 8,42)( 9,44)(11,46)
  (13,48)(15,50)(17,52)(18,54)(22,57)(24,59)(47,88)(49,90)(60,91)(61,93),
 ( 1,3)( 6,8)(11,13)(16,17)(19,20)(22,23),
 ( 1,14)( 4,20)( 5,24)( 8,26)( 9,30)(12,34)(16,36)(18,40)(21,44)(28,48)
  (31,52)(37,56)(42,58)(45,62)(50,64)(53,68)(59,70)(65,72),
 ( 1,4)( 2,14)( 3,18)( 6,22)( 8,23)(11,25)(12,26)(17,28)(19,29),
 ( 1,10)( 2,13)( 3,15)( 4,19)( 5,23)( 6,26)( 7,28)( 8,33)(12,35)(14,37)
  (17,41)(20,48)(22,49)(24,51)(31,59)(32,60)(36,62)(38,63)(42,66)(43,68)
  (46,71)(47,72)(53,75)(54,77)(57,80)(58,81)(64,83)(67,84)(69,85)(73,87)
  (76,88)(78,89)(82,91)(86,93)(90,95),( 1,2)( 3,4)( 5,6)( 7,8)( 9,10)
  (11,12)(13,14)(15,16)(18,19)(21,22)(24,25)(26,27)(28,29)(38,39)(40,41)
  (42,43)(44,45)(46,47)(48,49)(50,51)(54,55)(56,57)(58,59)(60,61)(62,63)
  (64,65)(66,67),( 1,9)( 3,12)( 6,20)(11,22)(13,23)(18,25)(24,28)(26,30),
 ( 1,2)( 3,4)( 7,8)(10,11)(12,14)(15,16)(17,18)(19,20)(28,29)(30,31)
  (32,33)(35,36)(37,38)(39,40)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52)
  (53,54)(55,56)(57,58)(59,60)(78,79)(80,81)(82,83)(84,85)(87,88)(89,90)
  (91,92)(93,94),( 1,4)( 5,8)(11,13)(15,16)(21,24)(31,33)(39,40)(46,47)
  (49,50)(51,53)(56,57)(62,64)(66,67)(69,70)(71,73)(75,77)(78,80)(81,83)
  (84,86)(88,90),( 1,4)( 8,10)(11,12)(13,15)(16,17),
 ( 1,10)( 2,12)( 3,16)( 4,19)( 5,22)( 6,24)( 7,29)( 8,31)
  ( 14,39)( 17,41)( 26,46)( 27,48)( 33,53)( 34,54)( 35,56)( 36,57)
  ( 37,59)( 40,63)( 42,64)( 43,65)( 44,67)( 45,70)( 49,73)( 50,75)
  ( 51,77)( 52,78)( 60,82)( 61,84)( 68,87)( 69,89)( 71,90)( 72,92)
  ( 79,94)( 80,95)( 81,97)( 85,99)( 86,101)( 93,104)( 98,106)(102,108)
  (103,109)(105,110)(107,111),( 1,9)( 2,12)( 3,16)( 4,25)( 5,31)( 6,37)
  ( 7,40)(11,42)(14,43)(17,45)(19,47)(20,49)(22,50)(24,53)(28,54)(30,55)
  (33,57)(36,59)(38,62)(41,63)(44,64)(48,66)(51,67)(52,69)(56,70)(60,71)
  (61,73)(65,74)(68,76)(72,78)(75,79)(77,80),
 ( 1,22)( 2,23)( 4,26)( 6,29)( 7,30)( 8,31)( 9,32)(10,35)(11,38)(12,39)
  (13,40)(15,41)(17,44)(18,47)(20,48),( 1,20)( 3,22)( 4,24)( 5,27)( 7,30)
  ( 8,32)( 9,34)(11,36)(12,39)(13,42)(14,44)(15,46)(16,48)(17,51)(18,54),
 ( 1,8)( 4,10)( 7,16)(13,20)(15,22)(18,24)(19,25)(21,26)(23,27),
 ( 1,5)( 2,11)( 3,16)( 7,21)(10,27)(15,29)(18,35),
 ( 1,16)( 4,21)( 7,25)(10,30)(13,35)(17,39)(19,41)(23,42)(26,43)(28,45)
  (31,47)(33,48)(36,49)(38,50)(40,52)(46,53),
 ( 1,12)( 2,17)( 3,20)( 6,21)(11,25)(13,27)(16,30)(23,35)(29,38),
 ( 1,3)( 9,10)(16,18)(20,22)(24,25)(29,30)(32,33)(36,37)(38,39),
 ( 1,2)( 8,9)(13,14)(15,16)(18,19)(21,22),
 ( 1, 4)( 5, 7)( 9,12)( 13,15)( 19,21)( 29,32)( 37,39)( 41,42)
  ( 43,45)( 47,48)( 49,50)( 51,53)( 54,55)( 56,57)( 58,59)( 61,63)
  ( 65,66)( 67,68)( 70,71)( 72,73)( 75,76)( 77,79)( 81,82)( 83,84)
  ( 86,87)( 88,89)( 92,93)( 94,96)( 98,99)(100,102),
 ( 1,25)( 3,26)( 5,27)( 7,28)( 8,31)(10,32)(11,34)(12,35)(14,36)(16,39)
  (17,40)(19,42)(21,43)(22,44)(24,45)(30,47)(38,49),
 ( 1,7)(10,17)(12,26)(13,29)(15,38)(19,40)(20,42)(27,43)(28,45)(35,46)
  (36,48),( 2, 7)( 3,12)( 10,35)( 13,37)( 15,38)( 18,43)( 21,45)
  ( 23,46)( 26,56)( 28,64)( 30,72)( 33,73)( 34,74)( 39,77)( 42,78)
  ( 44,79)( 47,82)( 48,90)( 50,92)( 52,95)( 54,97)( 57,99)( 59,100)
  ( 61,102)( 65,105)( 67,107)( 68,108)( 70,110)( 75,112)( 80,114)( 83,116)
  ( 93,128)(103,130)(113,132)(115,133),( 1,8)( 9,15)(10,17)(11,18)(12,19)
  (13,21)(14,22),( 1, 2)( 12,13)( 15,17)( 18,19)( 32,33)( 37,38)
  ( 39,40)( 43,44)( 48,49)( 50,51)( 52,53)( 55,56)( 57,58)( 60,61)
  ( 63,64)( 65,66)( 69,70)( 71,72)( 73,74)( 76,77)( 80,81)( 83,84)
  ( 86,87)( 88,89)( 91,92)( 97,98)(101,102),
 ( 1,19)( 2,21)( 3,22)( 4,24)( 5,25)( 6,26)( 7,28)( 8,29)( 9,31)(10,32),
 ( 2,18)( 9,19)( 15,20)( 21,38)( 22,40)( 23,41)( 24,42)( 25,44)
  ( 26,45)( 27,47)( 28,49)( 29,50)( 30,51)( 31,53)( 32,55)( 33,56)
  ( 34,57)( 35,59)( 36,67)( 37,68)( 60,73)( 61,74)( 62,77)( 63,81)
  ( 64,82)( 65,87)( 66,88)( 70,94)( 71,96)( 72,97)( 76,99)( 78,100)
  ( 79,101)( 80,102)( 84,104)( 85,105)( 86,106)( 90,108)( 91,110)( 92,113)
  ( 93,116)( 95,118)(109,119)(111,121)(112,122)(114,124)(115,125)(117,127)
  (120,128)(123,129)(126,130),( 2,5)( 7,10)( 8,12)( 9,13)(11,14),
 ( 1,6)( 4,8)( 5,12),( 1,19)( 2,21)( 4,23)( 5,26)( 6,28)( 8,31)( 9,33)
  (10,35)(11,38)(12,40)(13,43)(15,45)(16,47)(17,50)(18,52),
 ( 1,4)( 2,11)( 5,12)( 8,13)( 9,14)(10,15),
 ( 2,5)( 7,10)(11,14)(16,18)(20,23),( 1, 7)( 2,19)( 3,21)( 4,24)
  ( 5,30)( 33,41)( 35,55)( 37,57)( 39,58)( 42,64)( 44,66)( 47,72)
  ( 49,74)( 51,75)( 52,84)( 76,94)( 79,96)( 82,98)( 85,100)( 88,102)
  ( 91,104)( 93,105)( 95,109)( 97,110)( 99,114)(101,115)(103,119),
 ( 1,9)( 3,11)( 6,15)( 7,18)(12,22)(17,24),
 ( 1,9)( 3,11)( 6,15)( 8,18)(12,21)(17,23),
 ( 1,8)( 3,17)( 5,29)( 9,40)(13,43)(16,45)(20,49)(22,51)(23,53)(26,54)
  (32,57)(35,61)(37,63)(38,65)(41,66)(46,67)(48,69)(55,70)(58,71)(60,73),
 ( 2,6)( 7,20)( 9,21)(10,22)(13,23)(14,26)(17,27)(19,30)(24,31)(28,32),
 ( 1,12)( 2,14)( 3,18)( 4,21)( 5,26)( 6,28)( 7,32)( 8,34)
  ( 10,37)( 17,43)( 19,45)( 23,49)( 25,52)( 31,55)( 35,56)( 36,58)
  ( 39,59)( 40,60)( 41,62)( 42,64)( 46,68)( 47,70)( 48,71)( 50,73)
  ( 53,74)( 54,76)( 65,82)( 66,84)( 67,85)( 72,87)( 77,89)( 78,91)
  ( 79,93)( 80,95)( 81,96)( 86,98)( 88,99)( 92,101)( 97,103)(100,104)
  (102,105),( 1,12)( 2,14)( 3,18)( 4,24)( 5,28)( 6,34)( 7,37)( 9,38)(11,39)
  (15,44)(17,46)(20,49)(21,51)(23,52)(26,54)(30,57)(33,59)(35,60)(40,62)
  (43,63)(45,64)(48,65)(50,68)(53,72)(55,73)(58,76)(61,80)(67,81)(69,82)
  (71,83)(75,84)(77,85)(79,86),( 1, 7)( 2,16)( 3,23)( 6,41)
  ( 9,43)( 11,45)( 13,46)( 15,49)( 17,50)( 19,54)( 22,56)( 25,58)
  ( 27,59)( 28,62)( 30,63)( 32,67)( 34,69)( 37,71)( 40,73)( 44,74)
  ( 48,75)( 51,76)( 52,79)( 53,80)( 57,83)( 61,84)( 64,85)( 65,88)
  ( 66,89)( 70,92)( 72,93)( 78,96)( 81,97)( 82,100)( 87,101)( 90,102)
  ( 91,105)( 94,106)( 95,109)( 99,110)(104,111)(108,112),
 ( 1,18)( 2,24)( 4,33)( 8,42)(10,43)(14,45)(19,47)(22,50)(25,51)(27,52)
  (29,53)(34,55)(37,58)(39,62)(41,63)(46,65)(56,68)(59,70)(66,71)(69,72),
 ( 1,7)( 2,16)( 3,20)( 4,24)( 5,31)( 6,35)( 9,40)(10,41)(13,44)(14,47)
  (19,50)(21,51)(26,54)(29,56)(34,59)(36,62)(43,65)(48,68)(53,70)(58,73)
  (63,76)(66,78)(71,80)(74,82),( 1,18)( 2,19)( 5,20)( 6,21)( 9,23)(10,25)
  (12,26)(15,27)(22,40)(34,52)(38,56)(43,59)(53,63)(54,64)(58,66)(60,71)
  (65,72),( 1,22)( 3,23)( 4,24)( 6,25)( 8,30)( 9,31)(11,32)(13,33)(14,34)
  (16,39)(18,40)(19,41)(20,44)(26,45)(29,46)(35,49)(38,50)(43,53)(47,56)
  (51,57)(54,58),( 1,3)( 5,7)(10,12)(15,17)(28,30)(36,38)(43,45),
 ( 1,8)( 3,13)( 6,21)( 9,22)(11,24)(17,26)(23,27)(25,28),
 ( 1, 8)( 3,13)( 11,32)( 18,41)( 20,45)( 21,46)( 25,55)( 27,64)
  ( 28,70)( 31,73)( 33,74)( 36,76)( 39,79)( 40,80)( 42,81)( 44,82)
  ( 47,89)( 49,92)( 50,93)( 52,96)( 54,97)( 57,99)( 58,101)( 60,104)
  ( 61,105)( 63,108)( 67,110)( 68,112)( 71,114)( 72,115)( 77,116)( 78,117)
  ( 91,134)( 95,136)(103,137)(107,139)(120,144)(123,146)(125,148)(128,150)
  (131,152)(133,154)(143,161)(145,162)(147,163)(149,164)(151,165)(153,166),
 ( 1, 2)( 4, 5)( 6, 7)( 8, 9)( 10,11)( 13,14)( 16,17)( 19,20)
  ( 24,25)( 32,33)( 37,38)( 39,40)( 41,42)( 43,44)( 45,46)( 47,48)
  ( 49,50)( 54,55)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 67,68)
  ( 69,70)( 73,74)( 76,77)( 80,81)( 82,83)( 86,87)( 88,89)( 92,93)
  ( 95,96)( 99,100)(101,102),( 1,4)( 2,10)(12,16)(13,17)(14,18),
 ( 1,5)( 2,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 2,17)( 4,18)( 5,19)( 7,21)(10,22)(12,23)(13,24)(15,26)(20,39)(25,41)
  (31,48)(37,59)(50,64)(57,69),( 1, 7)( 2,14)( 3,31)( 5,32)
  ( 6,36)( 9,38)( 10,39)( 13,41)( 15,44)( 17,45)( 18,46)( 20,49)
  ( 23,53)( 25,56)( 26,57)( 28,60)( 30,61)( 33,63)( 35,68)( 37,71)
  ( 40,72)( 42,75)( 43,76)( 47,78)( 48,81)( 50,84)( 52,85)( 55,88)
  ( 58,89)( 59,90)( 62,92)( 64,93)( 67,94)( 70,97)( 73,98)( 77,101)
  ( 80,104)( 83,107)( 86,108)( 91,109)( 95,112)( 99,113)(102,114)(105,117)
  (110,118)(115,121)(119,122),( 1, 4)( 2, 9)( 3,16)( 10,38)( 11,40)
  ( 14,43)( 17,44)( 20,49)( 22,51)( 24,55)( 26,56)( 34,81)( 37,83)
  ( 41,84)( 45,85)( 48,87)( 52,88)( 59,95)( 63,97)( 67,99)( 71,101)
  ( 75,103)( 79,105)( 96,113)( 98,114)(100,115)(102,116)(104,117)(106,118),
 ( 2,17)( 4,18)( 5,19)( 8,21)(11,22)(12,23)(14,26)(16,27)(20,45)(24,46)
  (31,48)(36,51)(41,54),( 2,7)( 3,8)( 6,10),
 ( 2,5)( 7,9)(13,16)(18,21)(27,28)(33,34)(42,43),
 ( 2,5)( 7,9)(14,17)(19,22)(26,28)(31,33)(38,40),
 ( 1,6)( 8,18)(11,25)(12,30)(15,37)(20,40)(23,43)(28,44)(31,47)(36,48)
  (39,51),( 2,5)( 7,8)( 9,12)(13,16)(18,21),
 ( 1,4)( 2,9)( 3,12)(18,35)(23,36)(27,37)(30,38)(33,39)(41,48)(43,49)
  (46,50),( 2,7)( 3,8)( 9,12)(13,15)(14,16),
 ( 1, 6)( 2,12)( 3,27)( 7,36)( 9,39)( 10,40)( 14,44)( 16,45)
  ( 19,50)( 21,51)( 23,53)( 25,57)( 38,84)( 46,86)( 49,87)( 54,90)
  ( 58,91)( 59,98)( 64,99)( 68,100)( 72,101)( 76,102)( 80,104)( 85,106)
  ( 88,108),( 2,5)( 8,21)( 9,24)(10,37)(11,40)(13,44)(22,45)(23,46)(32,47)
  (34,48)(43,49),( 1,12)( 3,19)( 5,28)( 8,41)(11,45)(15,46)(18,47)(21,48)
  (23,49)(27,52)(31,53)(34,54)(37,55)(40,56)(44,59)(50,60)(57,61),
 ( 1,12)( 3,19)( 6,32)( 7,41)(11,45)(15,48)(18,49)(22,50)(25,51)(28,52)
  (31,55)(34,56)(36,57)(40,58)(44,59)(46,60)(53,61),
 ( 1,4)(10,11)(18,19)(22,23)(25,26)(29,30)(31,32)(34,35)(40,41)(43,44)
  (45,46)(50,51)(52,53)(57,58)(59,60)(62,63)(65,66),
 ( 1,2)(14,15)(17,18)(19,20)(23,24)(30,31)(34,35)(38,39)(40,41)(45,46)
  (48,49)(50,51)(53,54)(55,56)(57,58)(59,60)(63,64)(65,66)(67,68),
 ( 1, 2)( 4, 5)( 6, 7)( 10,11)( 12,13)( 15,16)( 17,18)( 21,22)
  ( 30,31)( 33,34)( 35,36)( 38,39)( 40,41)( 43,44)( 45,46)( 48,49)
  ( 50,51)( 53,54)( 55,56)( 58,59)( 60,61)( 63,64)( 65,66)( 68,69)
  ( 71,72)( 73,74)( 77,78)( 79,80)( 83,84)( 85,86)( 89,90)( 91,92)
  ( 95,96)( 97,98)(101,102)(103,104),( 1,5)( 9,15)(10,16)(11,17)(13,19)
  (18,21)(20,22),( 1,12)( 3,16)( 5,21)( 8,29)( 9,47)(13,49)(14,50)(17,51)
  (19,52)(22,55)(24,56)(25,57)(27,58)(39,62)(45,66)(48,68)(53,70)(64,78)
  (74,81)(76,83),( 2,7)( 4,11)( 5,19)( 9,20)(15,23)(17,26)(21,29)(24,30),
 ( 2,7)( 4,11)( 5,12)( 6,14)( 8,15)(10,16)(13,19)(18,22)(21,23),
 ( 1,5)( 2,9)( 4,10)( 6,12)(11,14)(13,15),
 ( 1,12)( 3,15)( 4,16)( 5,17)( 7,18)( 8,21)(10,22)(11,23)(14,26)(20,29)
  (25,32)(28,33)(31,34),( 1,11)( 3,17)( 6,37)( 7,42)(12,45)(13,46)(15,47)
  (18,48)(20,52)(22,54)(26,55)(31,56)(33,57)(35,61)(38,63)(49,66)(53,67)
  (58,70)(62,71),( 2,23)( 5,24)( 7,25)(10,29)(14,30)(17,31)(19,35)(22,36)
  (27,37)(28,38)(33,39)(34,40),( 1,17)( 3,19)( 4,20)( 6,22)( 8,23)( 9,24)
  (10,26)(12,27)(14,29)(15,30),( 2,7)( 4,11)(14,28)(22,31)(26,32)(29,36)
  (30,42)(33,45)(35,47)(37,49)(39,51)(41,53)(43,55)(46,57)(50,58)(54,59),
 ( 1,2)(16,18)(19,21)(22,23)(27,28)(29,31)(32,34)(36,38)(41,42)(43,44)
  (48,49)(50,51)(58,59)(66,67)(68,69)(70,71),
 ( 2,7)( 4,10)( 5,13)(12,18)(15,20),( 1, 7)( 2,13)( 3,16)( 4,25)
  ( 5,35)( 8,36)( 10,38)( 15,40)( 17,42)( 19,45)( 20,47)( 23,49)
  ( 26,54)( 28,55)( 30,56)( 32,57)( 34,59)( 37,63)( 39,64)( 41,65)
  ( 43,67)( 46,69)( 48,75)( 50,76)( 51,77)( 53,79)( 58,81)( 60,84)
  ( 62,86)( 66,87)( 68,88)( 70,90)( 72,91)( 74,93)( 78,94)( 80,95)
  ( 82,97)( 85,98)( 89,99)( 92,100)( 96,101),
 ( 1,9)( 4,12)( 5,14)( 6,17),( 1,3)( 8,9)(11,12)(13,14)(16,17)(18,19),
 ( 1,2)( 4,5)( 7,8)(10,11)(12,13)(14,15)(16,17)(19,20)(21,22)(23,24)
  (25,26)(28,29)(30,31)(39,40)(41,42)(44,45)(46,47)(48,49)(50,51)(52,53)
  (54,55)(56,57)(58,59)(60,61)(78,79)(80,81)(82,83)(85,86)(87,88)(89,90),
 ( 1,7)( 2,13)( 4,27)(11,40)(17,44)(20,46)(22,49)(26,50)(30,54)(32,57)
  (34,58)(35,59)(37,61)(39,64)(42,65)(43,68)(52,69)(53,72)(56,73)(67,74)
  (71,75),( 2,15)( 3,17)( 7,18)( 9,20)(10,21)(13,24)(16,39)(19,42)(22,45)
  (26,48)(30,52)(32,54)(35,59)(37,61)(40,62)(43,63)(49,71)(55,74),
 ( 1,4)( 2,8)( 3,14)(10,26)(13,27)(20,29)(22,30),
 ( 2,15)( 4,24)( 5,31)( 8,44)( 9,45)(12,46)(16,47)(20,48)(22,50)(25,52)
  (28,53)(32,54)(35,55)(38,56)(41,59)(51,60)(58,61),
 ( 1,7)( 2,12)( 3,22)( 9,26)(17,30)(19,31)(23,32)(27,33),
 ( 1,4)( 2,8)( 3,13)( 7,24)(12,25),( 1,5)( 2,17)( 3,22)( 7,25)(10,27)
  (16,28)(19,30),( 2,5)(10,11)(14,15),( 1,2)( 4,5)( 7,8)(10,11)(13,14)
  (17,18)(21,22)(25,26),( 1,17)( 3,18)( 5,19)( 6,20)( 9,22)(12,23)(13,24)
  (15,27)(21,43)(25,44)(31,46)(35,49)(39,51),
 ( 1,3)( 2,6)( 4,9)(11,14)(12,15)(13,16),
 ( 1,24)( 4,26)( 6,27)(10,29)(13,30)(15,32)(18,33)(20,34)(22,36)(25,37)
  (31,38),( 1,2)( 4,5)( 7,8)(10,11)(16,17)(27,28)(30,31),
 ( 1,17)( 3,18)( 6,19)( 7,22)( 9,23)(11,24)(14,25)(15,28)(20,40)(26,41)
  (30,44)(47,60)(53,62)(57,68)(59,71)(65,75)(70,77),
 ( 1,2)( 7,8)(16,17)(21,22)(23,24),( 1,20)( 2,23)( 3,25)( 4,27)( 5,30)
  ( 7,32)( 8,35)( 9,37)(11,39)(12,42)(13,44)(14,47)(15,49)(16,51)(18,54),
 ( 1,5)( 2,14)( 3,35)( 6,43)( 9,45)(11,46)(13,47)(15,51)(18,52)(20,53)
  (23,55)(25,57)(26,58)(28,62)(32,63)(34,64)(36,66)(38,67)(40,71)(42,72)
  (44,73)(48,75)(50,76)(54,78)(56,80)(59,81)(61,82)(65,84)(68,85)(70,86)
  (74,88)(77,89)(79,91)(83,92)(87,94)(90,96)(93,97)(95,98),
 ( 1,13)( 4,18)( 7,24)(10,31)(12,35)(15,40)(17,41)(20,42)(22,43)(27,47)
  (30,49)(33,50)(34,51)(38,54)(45,56)(52,58),
 ( 2,5)( 4,9)(13,26)(14,33)(18,35)(29,38)(31,44)(37,49)(39,51)(41,53)
  (43,55)(45,57)(47,59)(50,61)(54,63)(58,65),
 ( 2,7)( 4,8)( 5,12)(11,17)(14,20),( 1,9)( 4,10)( 5,12)( 8,13),
 ( 1,11)( 2,20)( 3,25)( 4,29)( 5,34)( 35,38)( 36,56)( 40,60)
  ( 42,61)( 43,63)( 47,66)( 48,68)( 52,72)( 53,81)( 54,90)( 73,91)
  ( 76,93)( 79,95)( 82,97)( 85,99)( 88,101)( 92,103)( 94,105)( 96,106)
  ( 98,108)(100,109)(102,111),( 1,7)( 2,12)( 3,18)( 4,21)( 5,26)( 6,31)
  ( 8,38)(10,41)(13,43)(15,44)(17,47)(20,49)(22,51)(25,53)(27,56)(30,58)
  (35,59)(36,61)(40,62)(42,63)(45,64)(48,65)(50,68)(52,70)(55,72)(57,73)
  (60,75)(66,77)(69,78)(71,81)(74,82)(76,85)(79,86)(83,87),
 ( 1,4)( 2,7)( 3,13)( 6,16)(10,18)(12,19)(15,20)(17,21),
 ( 1,4)( 2,7)( 3,12)( 9,23)(11,25)(17,30)(26,35)(31,37),
 ( 2,14)( 3,16)( 4,17)( 5,19)( 7,20)( 8,21)( 9,23)(10,24)(12,26)(13,27),
 ( 1,4)( 2,7)( 3,10)( 6,15)(11,17)(12,19)(14,21)(16,23),
 ( 2,4)( 5,10)( 7,12),( 1, 7)( 2,12)( 3,15)( 4,26)( 31,45)
  ( 32,56)( 34,61)( 36,62)( 41,64)( 43,65)( 48,67)( 51,68)( 53,69)
  ( 57,73)( 58,80)( 59,85)( 60,92)( 70,96)( 74,99)( 78,102)( 82,105)
  ( 86,108)( 90,111)( 95,112)( 98,114)(101,115)(104,117)(107,118)(110,120),
 ( 1,11)( 2,18)( 3,24)( 4,37)( 6,38)( 8,41)( 13,43)( 15,44)
  ( 17,47)( 20,48)( 21,51)( 23,53)( 40,68)( 45,71)( 50,73)( 54,76)
  ( 55,77)( 58,83)( 62,89)( 64,95)( 69,97)( 74,98)( 80,117)( 82,119)
  ( 86,121)( 88,123)( 92,125)( 94,127),( 1,7)( 2,12)( 3,15)( 4,22)( 9,24)
  (11,25)(16,27)(21,29)(23,30)(26,31)(28,32),
 ( 1,11)( 2,18)( 3,24)( 4,29)( 5,34)( 35,37)( 36,56)( 40,59)
  ( 43,61)( 44,63)( 48,67)( 49,69)( 53,72)( 54,78)( 55,84)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 87,104)( 90,106)( 93,108)
  ( 96,110)( 99,112)(102,114),( 1,4)( 2,15)( 3,20)( 6,24)( 9,27)(14,28)
  (17,31),( 2,10)( 4,12)( 6,14)( 9,17)(18,25)(19,31),
 ( 1,4)( 2,7)( 5,10)( 8,12)( 9,13),( 1,8)( 4,12)( 6,15)( 7,16)(11,18),
 ( 1,4)( 2,7)( 5,10)( 8,11),( 1,2)( 4,5)( 9,10)(12,13)(20,23)(34,37)
  (43,44)(46,47)(49,50),( 1,4)( 2,14)( 3,19)( 7,23)( 9,24)(17,28)(27,32)
  (31,33),( 1,11)( 2,17)( 3,28)( 4,43)( 7,45)( 10,47)( 14,48)
  ( 19,49)( 22,50)( 25,51)( 27,52)( 33,59)( 41,69)( 44,70)( 46,73)
  ( 54,89)( 56,92)( 60,94)( 62,97)( 64,99)( 66,102)( 74,103)( 75,104)
  ( 78,106)( 80,109)( 83,111)( 86,113)(105,114)(107,115),(1,4)(2,7)(5,9),
 ( 1,10)( 2,13)( 3,15)( 4,18)( 5,21)( 6,23)( 7,28)( 8,29)( 9,32)(12,38)
  (16,40)(20,45)(24,49)(26,50)(33,57)(34,58)(37,59)(39,62)(43,64)(44,65)
  (48,66)(51,69)(55,71)(56,72)(60,74)(63,76)(67,77)(70,78),
 ( 1, 7)( 2,11)( 3,25)( 4,29)( 5,31)( 36,48)( 37,57)( 41,61)
  ( 42,62)( 45,64)( 49,67)( 50,68)( 54,71)( 55,72)( 56,78)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 84,102)( 87,103)( 90,105)
  ( 93,106)( 96,108)( 99,109),( 1,12)( 2,19)( 3,22)( 4,26)( 5,33)( 6,36)
  ( 7,39)( 8,43)( 9,44)(15,47)(17,48)(21,49)(23,50)(25,51)(28,55)(29,56)
  (31,57)(35,58)(37,59)(41,60)(45,62)(46,63)(52,65)(53,66)(54,67)(61,68)
  (64,69),( 1,26)( 5,27)( 13,28)( 16,29)( 20,30)( 23,31)( 34,68)
  ( 36,69)( 39,72)( 42,75)( 43,76)( 46,81)( 48,82)( 51,87)( 53,88)
  ( 56,91)( 59,94)( 60,95)( 63,100)( 65,101)( 67,104)( 70,105)( 80,106)
  ( 83,107)( 93,108)( 96,109),( 1,16)( 2,17)( 3,19)( 4,20)( 5,22)( 6,23)
  ( 7,24)( 8,26)( 9,28)(10,29)(11,31)(12,33)(13,34)(14,36)(15,38),
 ( 1,16)( 2,17)( 3,19)( 4,21)( 5,22)( 6,23)( 7,25)( 8,26)( 9,28)(10,29)
  (11,30)(12,32)(13,34)(14,35)(15,37),( 1,26)( 5,27)( 13,28)( 16,29)
  ( 20,30)( 23,31)( 33,66)( 36,71)( 38,72)( 41,75)( 44,78)( 45,79)
  ( 48,84)( 50,85)( 53,90)( 55,91)( 58,94)( 61,97)( 62,98)( 65,103)
  ( 70,104)( 73,105)( 83,106)( 86,107)( 96,108)( 99,109),
 ( 1,12)( 2,18)( 3,21)( 4,26)( 5,32)( 6,38)( 7,39)( 9,41)(13,43)(15,45)
  (17,46)(20,49)(22,50)(25,52)(27,54)(28,55)(31,57)(33,58)(36,60)(40,61)
  (42,63)(48,65)(51,68)(53,69)(56,71)(59,72)(62,74)(67,77)(70,78)(73,82)
  (75,85)(79,88)(81,90)(84,92)(87,94),( 1,3)( 9,10)(15,17)(19,21)(23,24)
  (26,28)(31,32)(34,36)(38,39)(41,43),( 1,7)( 2,11)( 3,17)( 4,22)(13,26)
  (16,28)(21,32),( 1,3)( 9,10)(15,17)(19,21)(24,25)(26,28)(30,31)(33,35),
 ( 1,12)( 2,18)( 4,36)( 6,37)( 7,40)( 11,45)( 14,46)( 16,47)
  ( 20,50)( 25,55)( 26,56)( 28,57)( 39,73)( 43,75)( 44,77)( 49,79)
  ( 52,81)( 53,82)( 54,85)( 60,89)( 64,92)( 68,97)( 70,100)( 74,106)
  ( 80,108)(111,127)(113,128)(115,129)(117,130)(119,131)(121,132),
 ( 1,16)( 6,19)( 9,21)(18,41)(23,42)(24,43)(25,46)(26,47)(28,48)(29,49)
  (30,52)(31,53)(32,55)(34,56)(35,57)(36,60)(37,61)(38,63)(40,64)(45,68)
  (51,70)(54,72)(59,74)(62,76)(65,79)(66,81)(67,83)(78,84)(80,86)(82,88),
 ( 1,9)( 3,11)( 4,13)( 5,14)( 8,26)(10,27)(12,28)(15,29)(18,32)(21,34)
  (25,36),( 1,8)( 2,9)( 4,12)( 6,13),( 2,7)( 3,13)( 6,19)(10,22)(12,24)
  (16,25)(20,27),( 2,13)( 3,18)( 5,23)( 7,27)( 9,45)(11,46)(14,47)(16,48)
  (19,51)(21,52)(24,53)(28,54)(29,57)(39,69)(44,72)(49,73)(55,74)(61,75)
  (68,77),( 2,4)( 5,6)( 7,9)(12,14),
 ( 2,36)( 5,39)( 7,40)( 8,42)( 10,46)( 13,48)( 15,52)( 17,55)
  ( 19,59)( 21,60)( 23,63)( 24,64)( 28,66)( 30,69)( 35,73)( 44,74)
  ( 51,76)( 53,80)( 56,84)( 57,85)( 70,89)( 71,90)( 78,91)( 81,93)
  ( 82,97)( 86,99)( 87,103)( 95,104)(101,105),
 ( 1,7)( 2,11)( 5,14)(10,17)(13,20),( 1,8)( 2,15)( 3,21)( 4,28)( 5,35)
  ( 7,40)( 9,42)(12,43)(14,45)(17,46)(18,48)(20,50)(23,52)(25,53)(27,55)
  (30,56)(34,58)(36,60)(39,63)(41,64)(44,66)(47,67)(49,69)(51,70)(54,71)
  (57,72)(59,74)(61,75)(62,76)(65,77)(68,79)(73,81)(78,82)(80,83),
 ( 1,5)( 3,11)( 7,12)( 8,13)( 9,14)(10,15),
 ( 1,10)( 5,21)( 6,25)(11,37)(16,41)(18,43)(20,45)(22,46)(24,47)(26,49)
  (29,52)(31,54)(32,56)(34,58)(36,59)(38,61)(63,72)(64,74)(65,75)(66,76)
  (68,77)(69,79)(70,80)(71,81)(82,84)(83,85),
 ( 1,11)( 2,16)( 3,19)( 4,24)( 5,28)( 6,31)( 7,34)( 10,37)
  ( 12,39)( 20,44)( 22,46)( 25,51)( 27,53)( 32,57)( 35,58)( 36,59)
  ( 38,62)( 40,64)( 42,67)( 43,68)( 45,71)( 47,73)( 50,75)( 52,76)
  ( 54,78)( 55,79)( 56,81)( 60,83)( 63,84)( 65,86)( 66,87)( 69,89)
  ( 72,90)( 74,92)( 77,93)( 80,95)( 82,97)( 85,99)( 88,100)( 91,103)
  ( 94,105)( 96,107)( 98,109)(101,112)(102,114)(104,116)(106,117)(108,118)
  (110,120)(111,121)(113,123)(115,124)(119,125)(122,126),
 ( 1,5)( 3,10)( 6,23)(11,24)(15,25)(18,26)(21,27),
 ( 1,15)( 2,22)( 3,26)( 5,35)( 7,36)( 9,39)( 16,45)( 17,46)
  ( 20,49)( 23,50)( 27,54)( 28,58)( 37,84)( 41,86)( 47,87)( 51,89)
  ( 53,90)( 61,98)( 65,99)( 69,100)( 73,102)( 78,103)( 82,104)( 85,105)
  ( 88,106),( 1,15)( 2,21)( 3,36)( 5,37)( 7,38)( 8,39)( 13,44)
  ( 17,47)( 19,48)( 22,49)( 26,54)( 27,57)( 40,74)( 41,77)( 42,78)
  ( 45,80)( 50,82)( 51,84)( 55,86)( 60,94)( 62,97)( 66,102)( 70,105)
  ( 79,107)( 85,109)(110,127)(112,128)(114,129)(116,130)(118,131)(120,132),
 ( 1,8)( 2,14)( 3,21)( 4,28)( 5,34)( 6,40)( 9,41)(11,42)(13,44)(16,45)
  (17,46)(20,47)(22,50)(24,51)(27,52)(29,54)(32,57)(35,58)(37,61)(39,62)
  (43,65)(48,66)(49,67)(53,70)(56,71)(59,72)(60,73)(64,74)(69,75),
 ( 1,11)( 2,15)( 3,21)( 4,27)( 5,34)( 7,38)( 8,40)( 12,41)
  ( 14,44)( 17,45)( 18,47)( 20,48)( 23,51)( 25,53)( 29,55)( 31,56)
  ( 35,57)( 37,60)( 39,62)( 42,64)( 43,66)( 46,67)( 49,70)( 50,72)
  ( 54,73)( 58,74)( 59,76)( 63,77)( 65,79)( 68,81)( 69,83)( 71,84)
  ( 75,87)( 80,90)( 82,92)( 85,94)( 86,96)( 88,97)( 89,99)( 93,100)
  ( 95,102)( 98,105)(103,107)(106,108),( 1, 8)( 2,14)( 3,21)( 9,40)
  ( 11,42)( 12,45)( 15,46)( 17,49)( 19,50)( 24,52)( 26,55)( 28,56)
  ( 38,67)( 39,68)( 43,71)( 48,73)( 53,76)( 59,80)( 61,86)( 65,92)
  ( 70,97)( 75,98)( 81,118)( 83,120)( 87,122)( 89,124)( 93,126)( 95,128),
 ( 1,11)( 2,15)( 3,19)( 4,26)(33,47)(34,51)(35,62)(36,66)(38,67)(39,69)
  (43,73)(44,74)(48,75)(49,77)(53,81)(54,82)(58,83)(59,85)(63,89)(64,90),
 ( 1,7)( 2,10)( 3,16)( 4,26)( 5,35)( 8,39)(11,41)(13,43)(14,45)(15,47)
  (17,49)(19,50)(21,52)(23,57)(25,59)(27,61)(29,63)(31,65)(33,67)(34,68)
  (36,70)(38,73)(42,74)(46,76)(48,77)(54,78)(56,79)(60,80)(64,82)(66,83)
  (72,84)(75,85)(81,88)(87,91)(90,92),( 1,12)( 2,14)( 3,19)( 4,21)
  ( 5,24)( 6,27)( 7,31)( 8,33)( 9,34)( 15,39)( 17,42)( 25,46)
  ( 29,49)( 35,54)( 36,56)( 37,57)( 38,59)( 41,62)( 43,65)( 44,67)
  ( 45,68)( 47,70)( 50,73)( 51,75)( 52,76)( 53,78)( 60,80)( 61,82)
  ( 63,83)( 64,85)( 71,88)( 72,90)( 79,94)( 86,97)( 87,99)( 91,101)
  ( 92,103)( 93,104)( 95,105)( 96,106)(100,108)(107,110)(109,111),
 ( 1,11)( 2,15)( 3,18)( 4,22)( 5,28)( 6,31)( 7,36)( 8,39)(10,40)(12,44)
  (14,46)(20,48)(23,49)(25,53)(26,55)(29,57)(32,59)(34,60)(37,61)(43,62)
  (45,64)(47,65)(52,66)(54,68)(56,69),( 1,4)( 2,5)(12,24)(22,36)(26,38)
  (28,39)(30,45)(40,52)(42,54)(44,56)(46,58)(48,60)(50,62)(51,63)(55,65)
  (59,67),( 2,4)( 6,9)(10,13)(15,18)(20,23),
 ( 1,11)( 2,15)( 6,26)(13,38)(17,40)(19,42)(21,43)(22,45)(23,47)(27,50)
  (29,52)(32,55)(34,56)(35,58)(48,65)(49,67)(59,71)(60,73)(62,74)(63,75)
  (64,77)(68,79)(70,80)(78,83)(81,84)(82,85),
 ( 1,2)( 5,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 2,4)( 6,9)(11,14)(19,22)(28,29)(36,37)(43,44),
 ( 1,11)( 2,14)( 3,20)( 4,23)( 5,27)( 6,30)( 7,35)( 8,38)( 9,40)(13,41)
  (15,44)(17,47)(19,49)(21,50)(24,51)(26,54)(29,56)(32,59)(33,61)(37,62)
  (42,64)(46,65)(52,67)(58,68),( 1,2)( 4,5)( 6,8)(10,11)(14,15)(18,19),
 ( 2,29)( 3,30)( 6,31)( 8,33)( 9,35)(12,36)(13,37)(15,38)(17,43)(18,44)
  (19,45)(20,46)(21,50)(22,51)(23,53)(24,54)(25,55)(26,56)(27,59)(28,61)
  (40,62)(41,64)(47,66)(60,67)(63,68)(65,69),
 ( 1,11)( 2,14)( 3,18)( 4,22)( 5,25)( 6,28)( 7,31)( 8,34)
  ( 15,40)( 19,43)( 21,45)( 24,48)( 26,50)( 32,54)( 35,55)( 36,56)
  ( 37,59)( 39,62)( 41,64)( 42,65)( 44,66)( 46,71)( 49,72)( 52,73)
  ( 53,75)( 57,78)( 60,79)( 61,80)( 67,86)( 69,87)( 70,88)( 76,92)
  ( 77,93)( 82,95)( 83,96)( 84,98)( 85,99)( 90,101)( 91,102),
 ( 1,11)( 2,14)( 3,17)( 4,24)( 5,28)( 6,31)( 7,38)( 9,43)(13,44)(15,45)
  (19,46)(21,47)(22,48)(25,52)(27,53)(29,54)(33,55)(35,56)(41,59)(42,60)
  (49,61)(50,62)(51,63)(57,65)(58,66)(64,68)(67,69),
 ( 1,5)( 3,8)( 7,19)( 9,21)(11,23)(20,26)(22,27),
 ( 1,2)( 5,8)(10,11)(14,15),( 1,11)( 2,14)( 3,17)( 4,19)( 5,23)( 6,28)
  ( 7,30)( 8,35)( 9,39)(12,40)(16,43)(20,44)(21,45)(25,47)(27,52)(31,54)
  (33,55)(37,56)(38,57)(41,61)(48,64)(51,66)(60,68)(63,70),
 ( 1,11)( 2,14)( 3,16)( 4,28)( 5,32)( 33,43)( 35,53)( 37,55)
  ( 40,61)( 42,63)( 45,69)( 47,70)( 49,72)( 51,83)( 52,92)( 76,93)
  ( 79,95)( 82,97)( 85,99)( 88,101)( 91,103)( 94,105)( 96,109)( 98,110)
  (100,114)(102,115)(104,119),( 1,2)( 5,7)( 8,10)(12,15)(16,18)(21,24)
  (29,31)(33,36)(39,40)(44,45)(46,48)(49,51)(52,53)(55,57)(60,61)(63,64)
  (65,67)(68,69)(70,72)(73,75)(77,79)(82,83)(85,87)(89,91)(93,94),
 ( 1,45)( 3,47)( 5,48)( 7,50)( 9,51)(12,53)(14,54)(16,56)(18,58)(21,60)
  (23,62)(25,64)(27,65)(30,67)(32,68)(34,70)(36,71)(38,73)(40,75)(42,77),
 ( 1,4)( 3,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 2,13)( 4,15)( 6,17)( 7,18)( 9,20)(10,21)(12,23)(14,24)(16,25)(19,26)
  (22,27),( 2,4)( 6,8)(10,12)(17,18)(25,26)(29,30)(33,34)(39,40)(43,44)
  (45,46)(47,48)(49,50),( 1,4)( 2,9)( 3,13)( 8,23)(12,28)(16,31)(20,33)
  (26,36),( 2,4)( 6,8)(10,12)(18,19)(25,26)(28,30)(33,34)(36,38)(41,42)
  (43,45),( 1,44)( 3,46)( 5,47)( 7,49)(10,50)(12,52)(14,54)(16,56)(19,58)
  (21,60)(23,61)(25,63)(27,64)(29,66)(31,67)(33,69)(35,71)(37,73)(39,75)
  (41,77),( 1,11)( 2,13)( 4,17)( 5,19)( 7,20)( 8,23)( 9,25)(12,26)(15,27)
  (16,29)(21,31)(22,33)(28,35)(32,36),( 2,4)( 6,8)(10,12)(18,19)(26,27)
  (29,30)(33,34)(35,36),( 1,3)(14,16)(19,20)(23,24)(26,27)(28,29)(33,34)
  (36,37)(39,40)(41,42)(44,45)(46,47)(51,52)(53,54)(58,59)(62,63)(66,67),
 ( 1,7)( 2,9)( 3,25)( 4,32)(35,45)(36,48)(37,60)(38,63)(41,70)(42,71)
  (46,72)(47,74)(51,76)(52,77)(56,78)(57,80)(61,82)(62,83)(66,84)(67,86),
 ( 2,12)( 3,21)( 6,34)( 8,41)( 9,45)(13,46)(17,47)(19,48)(22,49)(25,52)
  (28,53)(31,54)(35,55)(38,56)(42,59)(51,60)(58,61),
 ( 1,7)( 2,9)( 3,15)( 4,24)( 5,28)( 6,37)(10,42)(12,43)(14,44)(16,45)
  (18,48)(20,49)(22,50)(27,51)(30,52)(31,53)(33,54)(35,57)(39,58)(41,61)
  (46,62)(47,65)(55,66)(56,69)(59,70)(60,71)(63,72)(64,73)(67,74)(68,75),
 ( 1,7)( 2,9)( 3,15)( 4,23)( 5,28)( 6,35)(10,40)(12,41)(14,43)(16,44)
  (19,46)(21,49)(22,50)(24,53)(27,54)(30,55)(33,57)(34,58)(36,61)(37,62)
  (39,65)(42,66)(47,67)(48,68)(56,70)(59,71)(60,72),
 ( 2,4)( 6,8)(11,13)(15,16)(18,19)(21,22),
 ( 1,4)( 3,8)( 5,11)( 9,13)(10,15)(12,17)(14,18)(16,19),
 ( 1,42)( 4,43)( 5,45)( 8,48)(10,51)(13,52)(16,53)(17,57)(20,59)(23,60)
  (25,62)(28,65)(29,68)(32,69)(35,70)(36,74)(39,75)(46,77)(49,78)(54,80)
  (63,82)(66,83)(71,85),( 1,4)( 3,8)( 6,10),
 ( 1,11)( 3,18)( 5,27)( 8,40)(10,45)(14,46)(17,47)(20,48)(22,49)(26,52)
  (30,53)(33,54)(36,55)(39,56)(43,59)(50,60)(57,61),
 ( 2,4)( 6,8)(11,13)(16,18)(28,30)(36,38)(43,45),
 ( 1,4)( 3,7)(13,26)(14,32)(18,34)(29,41)(31,47)(40,52)(42,54)(44,56)
  (46,58)(48,60)(50,62)(53,64)(57,66)(61,68),
 ( 1,6)(10,14)(12,20)(13,23)(16,33)(21,35)(22,36)(25,37)(26,38)(28,40)
  (30,46)(52,63)(56,65)(60,67),( 1,6)( 2,7)( 4,12)( 5,13),
 ( 1,41)( 4,44)( 7,46)( 8,47)(11,49)(14,53)(16,54)(19,56)(20,57)(23,60)
  (25,63)(28,65)(29,66)(32,68)(35,72)(36,73)(39,75)(43,77)(52,79)(59,81)
  (62,83)(71,84)(76,85)(80,86),( 1,41)( 4,43)( 5,44)( 8,48)(10,49)(13,51)
  (14,52)(17,56)(20,58)(21,59)(24,61)(26,62)(29,66)(32,67)(33,68)(36,72)
  (39,74)(47,75)(54,77)(55,79)(65,81)(70,83)(71,85),
 ( 1,41)( 4,43)( 5,44)( 8,48)(11,50)(12,51)(15,53)(17,56)(20,59)(21,60)
  (24,62)(26,63)(29,67)(32,69)(33,70)(36,72)(39,75)(45,76)(54,77)(57,79)
  (64,81)(73,83)(80,85)(84,86),( 1,9)( 2,15)( 3,18)( 4,21)( 5,23)( 6,27)
  ( 7,29)( 8,33)(10,35)(12,38)(14,39)(16,42)(24,48)(30,53)(37,57)(40,60)
  (43,62)(44,64)(45,65)(46,68)(47,69)(50,71)(51,72)(52,74)(54,75)(55,78)
  (56,79)(59,80)(61,81)(66,83)(76,86)(82,88)(84,89)(85,90)(87,91),
 ( 1,41)( 4,43)( 5,44)( 8,46)(10,49)(13,52)(16,54)(17,55)(20,58)(23,60)
  (25,61)(28,63)(29,66)(32,69)(35,71)(36,72)(39,76)(47,77)(50,79)(56,80)
  (64,81)(67,83)(73,84),( 2,12)( 3,13)( 5,15)( 6,17)( 8,19)(11,22)(14,24)
  (16,25)(18,26),( 1,41)( 4,43)( 6,44)( 9,48)(10,49)(13,51)(16,54)(17,57)
  (20,59)(22,60)(25,62)(28,65)(29,66)(32,68)(35,71)(37,74)(40,76)(47,77)
  (53,78)(56,80)(64,81)(70,82)(73,84),( 2,4)( 6,8)(13,14)(20,22)(24,26)
  (28,29)(31,33)(34,35),( 1,8)( 2,11)( 3,25)( 4,32)(34,43)(35,47)(36,58)
  (37,62)(39,68)(41,71)(44,72)(46,73)(49,75)(51,78)(54,79)(56,80)(59,82)
  (61,85)(64,86)(66,87),( 1,2)( 5,6)( 9,11)(12,14),
 ( 2,12)( 4,17)( 5,22)( 7,26)( 9,44)(11,45)(14,46)(16,47)(19,49)(21,51)
  (24,52)(28,53)(30,55)(39,68)(42,74)(48,75)(54,76)(59,77)(69,79),
 ( 2,4)( 6,8)(13,14)(20,22)(25,27)(31,33)(35,36)(37,38)(39,40),
 ( 1,9)( 2,14)( 3,21)( 5,24)(11,26)(16,28)(20,30),
 ( 1,2)( 9,10)(13,14)(18,19)(24,25)(31,32)(39,40),
 ( 1,3)( 8,9)(14,16)(18,20)(22,24)(26,28)(30,32)(34,36)(38,40)(42,44),
 ( 1,39)( 2,41)( 5,42)( 7,45)(10,49)(11,53)(13,54)(16,56)(19,57)(22,58)
  (23,61)(26,65)(28,69)(31,70)(34,72)(36,75)(46,76)(48,77)(52,81)(62,83)
  (64,84)(68,88)(74,90)(79,91)(86,92),( 1,11)( 3,13)( 4,15)( 6,17)( 7,19)
  ( 9,22)(12,24)(14,25)(16,26),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(28,29)
  (34,35)(36,37)(40,41)(42,43),( 2,12)( 4,16)( 6,21)( 7,26)(10,45)(11,48)
  (15,49)(18,50)(20,51)(23,54)(25,55)(28,56)(30,57)(31,58)(36,61)(47,73)
  (53,74)(62,76)(69,78),( 1,4)( 5,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)
  (16,19),( 2,4)( 6,8)(14,15)(21,23)(25,26)(28,29)(32,33)(34,35),
 ( 1,39)( 3,40)( 6,42)( 8,44)(10,48)(12,51)(17,52)(19,55)(21,56)(24,58)
  (27,62)(28,65)(30,68)(34,71)(36,73)(43,76)(45,77)(47,80)(57,84)(59,85)
  (61,88)(67,91)(72,92)(75,94)(81,95)(83,97)(89,98),
 ( 1,9)( 2,14)( 3,18)( 4,23)(12,27)(21,31)(26,32)(30,33),
 ( 1,38)( 2,42)( 5,44)( 8,45)( 12,49)( 14,51)( 17,52)( 20,56)
  ( 22,60)( 28,61)( 30,64)( 33,66)( 36,68)( 43,73)( 46,74)( 48,77)
  ( 50,79)( 53,80)( 57,83)( 58,84)( 62,86)( 65,89)( 67,91)( 69,92)
  ( 71,93)( 78,95)( 81,96)( 85,98)( 90,99)( 94,100)( 97,101),
 ( 1,6)( 2,11)( 3,14)( 4,28)(34,43)(35,46)(36,58)(37,61)(39,68)(40,69)
  (44,72)(45,74)(49,75)(50,76)(54,79)(55,81)(59,82)(60,83)(64,86)(65,88),
 ( 1,9)( 4,11)( 7,13)( 8,17)(15,19)(16,21),
 ( 1,6)( 2,11)( 3,14)(13,25)(17,30)(19,31)(26,36)(32,41)(33,42)(37,45)
  (43,49)(46,51),( 1,23)( 4,25)( 6,28)( 8,29)(10,30)(13,31)(16,34)(18,35)
  (21,36)(26,37)(32,39),( 1,38)( 3,40)( 5,43)( 7,44)( 8,46)(11,49)(13,51)
  (16,54)(17,58)(20,60)(23,62)(24,65)(28,66)(29,68)(32,71)(34,75)(36,76)
  (48,78)(53,80)(55,82)(70,85)(72,87)(84,90)(89,92),
 ( 1,14)( 3,21)( 5,30)( 8,43)(10,46)(13,47)(17,48)(20,49)(23,50)(25,51)
  (29,54)(33,55)(36,56)(39,57)(42,58)(52,60)(59,61),
 ( 2,12)( 5,20)( 7,24)( 8,29)( 9,42)(11,43)(14,45)(17,46)(19,47)(21,48)
  (23,50)(26,52)(28,53)(32,56)(35,62)(44,74)(49,76)(60,80)(71,84),
 ( 1,4)( 5,9)(10,14)(23,26)(27,29)(33,35)(36,38),
 ( 1,9)( 2,13)( 3,20)( 4,22)( 7,24)(10,26)(14,28)(19,30)(23,32)(27,34)
  (29,36),(1,5)(4,8)(6,9),( 2,6)( 4,10)( 7,21)( 9,22)(13,23)(15,26)
  (19,29),( 1, 8)( 2,10)( 3,15)( 4,22)( 5,31)( 35,44)( 36,59)
  ( 41,61)( 42,62)( 47,64)( 50,65)( 51,66)( 56,67)( 57,76)( 58,85)
  ( 68,87)( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 88,104)( 91,106)
  ( 94,107)( 97,109)(100,110)(103,112),( 1,38)( 4,42)( 6,44)( 12,46)
  ( 14,50)( 17,51)( 20,53)( 22,56)( 23,58)( 26,60)( 29,64)( 33,66)
  ( 35,68)( 39,69)( 41,70)( 43,73)( 47,76)( 48,77)( 52,82)( 54,83)
  ( 57,84)( 59,87)( 65,90)( 67,93)( 71,94)( 78,95)( 80,96)( 85,99)
  ( 91,100)( 97,103)(101,104),( 2,11)( 3,16)( 6,25)( 7,31)( 9,35)
  ( 12,36)( 14,37)( 15,39)( 17,42)( 20,45)( 21,47)( 22,49)( 33,70)
  ( 34,71)( 40,74)( 41,75)( 44,76)( 46,77)( 50,80)( 51,81)( 52,83)
  ( 73,102)( 79,104),( 1,5)( 6,20)( 8,21)(11,22)(12,23)(15,26)(17,27)
  (18,30)(24,31)(28,32),( 1,38)( 4,40)( 6,42)( 9,45)( 10,46)
  ( 12,48)( 14,49)( 17,54)( 20,57)( 22,58)( 25,60)( 26,62)( 29,65)
  ( 32,67)( 35,70)( 37,73)( 43,75)( 50,77)( 53,79)( 63,82)( 69,85)
  ( 76,87)( 80,90)( 83,93)( 86,96)( 88,99)( 91,100)( 94,101)( 97,102),
 ( 2,14)( 4,22)( 5,27)( 8,37)(10,39)(13,40)(17,41)(21,47)(23,48)(26,52)
  (31,53)(33,57)(36,61)(44,62)(46,63)(51,66)(56,67)(60,70)(65,71)(69,72),
 ( 1, 6)( 2,10)( 3,22)( 4,24)( 5,27)( 33,41)( 35,55)( 37,57)
  ( 39,58)( 42,64)( 44,66)( 47,72)( 49,74)( 51,75)( 52,84)( 76,94)
  ( 79,96)( 82,98)( 85,100)( 88,102)( 91,104)( 93,105)( 95,109)( 97,110)
  ( 99,114)(101,115)(103,119),( 1,9)( 2,13)( 3,17)( 4,19)( 7,22)(14,28)
  (23,36)(29,39),( 1,11)( 2,18)( 3,22)( 4,25)( 5,31)( 32,46)
  ( 33,56)( 38,59)( 39,60)( 42,64)( 47,66)( 48,68)( 53,70)( 54,72)
  ( 55,81)( 73,91)( 76,94)( 79,97)( 82,100)( 85,103)( 88,106)( 89,108)
  ( 92,110)( 95,114)( 98,116)(101,120)(104,122),
 ( 1,9)( 2,13)( 3,16)( 4,21)( 5,24)( 6,28)( 7,31)( 8,37)(11,40)(14,41)
  (18,42)(19,44)(22,47)(25,49)(27,52)(30,53)(32,54)(34,56)(36,59)(38,62)
  (45,63)(51,64)(57,66)(61,67),( 1,9)( 2,13)( 4,17)( 6,22)(10,43)(14,45)
  (15,46)(18,47)(20,48)(23,51)(25,52)(26,53)(28,54)(34,58)(39,65)(44,73)
  (49,75)(62,80)(71,83),( 1,11)( 2,17)( 3,28)( 4,44)( 7,47)
  ( 10,48)( 16,49)( 19,52)( 22,53)( 24,54)( 27,56)( 32,62)( 37,68)
  ( 41,74)( 45,76)( 46,78)( 50,81)( 57,91)( 59,93)( 63,95)( 65,97)
  ( 69,99)( 71,101)( 79,102)( 83,103),( 1,6)( 3,8)(10,25)(14,33)(29,34)
  (31,38)(32,46)(36,52)(39,54)(42,56)(44,58)(47,60)(50,62)(53,63)(57,64)
  (61,65),( 1,37)( 2,40)( 4,42)( 6,45)( 8,46)( 9,50)(11,53)(13,55)(16,58)
  (17,60)(21,62)(22,65)(25,66)(28,70)(29,72)(32,75)(34,77)(49,78)(51,81)
  (56,82)(69,85)(73,88)(83,91)(89,92),( 1,8)( 2,21)( 3,24)( 4,29)(32,38)
  (33,42)(34,53)(35,57)(36,66)(39,69)(41,72)(44,74)(46,75)(49,78)(51,81)
  (54,83)(56,84)(59,87)(61,90)(64,92),( 1,37)( 2,40)( 4,42)( 8,45)(10,48)
  (11,51)(14,55)(17,57)(19,58)(21,61)(26,62)(28,65)(30,69)(32,71)(35,73)
  (41,74)(46,75)(52,78)(54,81)(56,82)(66,86)(68,89)(70,90)(77,93)(83,94)
  (85,96)(91,97),( 1,11)( 2,17)( 3,21)( 4,27)( 5,31)( 6,33)
  ( 7,34)( 9,37)( 15,43)( 18,45)( 26,51)( 28,52)( 35,57)( 36,60)
  ( 38,61)( 39,62)( 40,64)( 41,65)( 42,66)( 44,69)( 46,70)( 47,71)
  ( 48,72)( 49,73)( 50,76)( 53,77)( 54,80)( 55,81)( 56,82)( 58,83)
  ( 59,84)( 63,87)( 67,89)( 68,90)( 74,94)( 75,97)( 78,99)( 79,100)
  ( 85,103)( 86,104)( 88,105)( 91,107)( 92,108)( 93,109)( 95,110)( 96,111)
  ( 98,112)(101,114)(102,115)(106,118)(113,121)(116,123)(117,124)(119,126)
  (120,127)(122,128)(125,129),( 1,10)( 2,12)( 3,17)( 4,24)( 5,33)
  ( 35,44)( 36,59)( 41,61)( 42,62)( 47,64)( 50,65)( 51,66)( 56,67)
  ( 57,76)( 58,85)( 68,87)( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)
  ( 88,104)( 91,106)( 94,107)( 97,109)(100,110)(103,112),
 ( 1,37)( 3,40)( 7,44)( 8,46)( 9,47)(12,50)(14,52)(16,55)(18,56)(21,59)
  (24,64)(26,66)(28,68)(30,69)(33,73)(36,76)(41,77)(42,80)(48,82)(54,84)
  (60,85)(61,88)(70,90)(75,92),( 1,37)( 3,40)( 8,42)(10,44)(13,48)(16,51)
  (18,55)(22,57)(23,59)(25,62)(29,64)(30,67)(34,71)(39,72)(41,75)(43,76)
  (47,78)(53,80)(54,83)(56,84)(58,87)(61,88)(63,89)(69,92)(70,95)(74,96)
  (79,97)(86,98)(91,99),( 1, 9)( 2,12)( 3,23)( 4,30)( 31,42)
  ( 32,53)( 33,61)( 38,63)( 40,64)( 45,66)( 48,67)( 50,68)( 55,69)
  ( 57,73)( 58,80)( 59,85)( 60,92)( 70,96)( 74,99)( 78,102)( 82,105)
  ( 86,108)( 90,111)( 95,112)( 98,114)(101,115)(104,117)(107,118)(110,120),
 ( 1,22)( 2,25)( 5,27)( 6,28)( 7,31)( 9,34)(11,35)(12,36)(14,37)(16,40)
  (17,43)(19,44)(21,45)(24,47)(26,48)(30,50)(32,51)(39,53)(41,54),
 ( 1,3)( 5,8)( 9,12)(14,17)(19,22),( 1,2)( 5,6)(11,12)(15,16)(17,18),
 ( 1,3)( 5,8)(10,12)(13,15)(17,19),( 2,7)( 5,8)( 6,9)(12,18)(14,22)
  (16,27)(20,29),( 1,5)( 2,11)( 3,14)( 6,15)( 8,16)(12,18)(17,20)(19,21),
 ( 1,4)( 2,6)( 3,10)( 7,23)(14,31)(15,32)(20,35)(28,38),
 ( 1,9)( 3,11)( 4,13)( 6,15)( 8,18)(10,20)(14,21)(17,22),
 ( 2,7)( 5,8)( 9,13)(10,15),( 1,6)( 4,10)( 7,21)( 9,22)(12,23)(18,28)
  (25,29)(27,30),( 1, 9)( 2,12)( 3,15)( 4,18)( 5,21)( 6,25)
  ( 7,29)( 8,32)( 11,35)( 17,39)( 19,41)( 22,44)( 24,46)( 28,49)
  ( 36,55)( 37,57)( 40,58)( 43,59)( 45,64)( 47,65)( 48,66)( 50,68)
  ( 52,71)( 53,74)( 54,75)( 60,79)( 61,80)( 63,81)( 69,87)( 70,88)
  ( 73,89)( 76,93)( 77,94)( 82,96)( 83,97)( 84,99)( 85,100)( 90,102)
  ( 91,103),( 2,23)( 3,24)( 5,27)( 7,29)( 9,30)(11,32)(12,34)(14,35)(15,36)
  (17,37)(19,40)(20,42)(22,43)(25,44)(26,45)(31,47)(38,49)(39,50)(46,52)
  (48,53)(51,54),( 1, 4)( 5, 7)( 9,12)( 13,15)( 19,21)( 29,32)
  ( 37,39)( 43,44)( 45,46)( 47,49)( 50,51)( 53,55)( 58,59)( 60,61)
  ( 62,64)( 65,66)( 67,69)( 70,71)( 72,73)( 74,75)( 77,78)( 79,80)
  ( 81,82)( 83,84)( 86,87)( 88,89)( 90,92)( 93,94)( 95,97)( 98,99)
  (100,102)(103,104)(105,107)(108,109),( 1,9)( 2,12)( 3,15)( 4,17)( 6,18)
  ( 8,19)(11,20)(14,21),( 1,8)( 2,9)( 4,11)(12,20)(15,22)(17,23),
 ( 1,4)( 5,7)(10,13)(18,20)(22,25)(26,27)(30,32)(33,35)(38,39)(40,42)
  (43,45)(46,47)(50,52)(54,56)(57,59)(60,61)(63,65)(67,68)(71,73)(74,76)
  (79,80)(82,84)(87,88)(90,91)(93,94)(96,97),
 ( 1,37)( 4,39)( 6,42)( 9,44)(10,47)(13,48)(16,51)(17,53)(21,55)(22,58)
  (25,60)(27,63)(29,67)(30,68)(32,71)(34,73)(36,76)(41,80)(46,83)(57,87)
  (62,90)(64,91)(77,92)(84,93),( 1,4)( 5,7)(10,12)(14,16)(17,19),
 ( 1,7)( 3,10)( 4,13)( 6,15)( 9,16)(12,18)(14,20)(17,21)(19,22),
 ( 2,8)( 4,21)( 7,23)(12,25)(13,26)(15,27)(16,28)(18,29)(19,30),
 ( 2,8)( 4,18)( 5,21)( 7,31)( 9,32)(12,33)(13,36)(15,39)(17,42)(19,43)
  (20,44)(22,47)(23,49)(24,52)(26,55)(34,83)(37,85)(45,86)(48,88),
 ( 1,22)( 3,24)( 4,25)( 6,26)( 7,27)( 8,29)( 10,30)( 11,32)
  ( 13,33)( 14,35)( 16,36)( 18,47)( 21,56)( 23,61)( 28,63)( 31,65)
  ( 34,66)( 38,71)( 42,74)( 45,76)( 49,79)( 52,81)( 55,83)( 59,86)
  ( 62,88)( 64,89)( 67,90)( 75,102)( 82,104)( 87,106),
 ( 1, 6)( 5,25)( 7,37)( 8,40)( 9,41)( 11,42)( 14,45)( 17,46)
  ( 18,50)( 19,51)( 21,52)( 23,53)( 34,69)( 38,71)( 43,73)( 47,75)
  ( 48,76)( 54,79)( 56,82)( 60,87)( 63,90)( 65,95)( 70,100)( 74,102)
  ( 77,104)(101,120)(103,121)(106,122)(108,123)(110,124)(112,127)(114,128)
  (126,137)(134,138)(136,139),( 2,11)( 4,15)( 6,20)( 7,25)( 9,45)(10,48)
  (14,49)(17,50)(19,51)(22,54)(24,55)(27,56)(29,57)(34,60)(43,72)(47,73)
  (53,74)(61,76)(68,78),( 1,34)( 2,38)(10,39)(11,40)(12,41)(14,42)(15,46)
  (17,48)(18,49)(19,50)(21,52)(23,54)(24,55)(25,56)(28,57)(29,58)(30,59)
  (32,60)(33,64)(35,66)(36,67)(37,68)(43,69)(44,70)(45,71)(47,72)(51,75)
  (53,76)(61,79)(62,80)(63,81)(65,82)(73,85)(74,86)(77,87)(78,88)(83,89)
  (84,90),( 1,7)( 2,10)( 3,16)( 4,18)( 5,25)( 6,28)( 9,38)(12,39)(14,42)
  (20,43)(22,45)(24,46)(27,49)(29,53)(32,56)(34,58)(35,59)(37,60)(40,66)
  (41,68)(44,69)(47,73)(50,75)(51,77)(52,79)(55,80)(57,81)(61,82)(63,83)
  (65,84)(67,85)(70,86)(72,87)(76,88)(78,89),
 ( 1,10)( 2,21)( 6,48)( 8,49)( 13,52)( 15,53)( 18,54)( 22,55)
  ( 26,58)( 29,59)( 31,60)( 35,64)( 39,68)( 41,69)( 45,73)( 47,74)
  ( 50,77)( 57,81)( 62,89)( 63,91)( 66,93)( 67,95)( 71,97)( 72,99)
  ( 76,101)( 80,102)( 84,103)( 86,104)( 88,105),
 ( 1,7)( 3,10)( 5,13)( 6,15)( 8,17)( 9,18)(11,20)(12,21),
 ( 1,10)( 2,19)( 5,32)( 7,39)(11,45)(15,46)(17,47)(20,48)(23,51)(26,52)
  (29,53)(33,54)(36,55)(40,58)(43,59)(50,60)(57,61),
 ( 2,11)( 4,13)( 6,14)( 9,17)(18,24)(19,30),
 ( 1,32)( 5,38)( 6,41)( 9,45)( 12,49)( 13,52)( 16,54)( 18,58)
  ( 19,61)( 23,63)( 26,67)( 28,70)( 31,73)( 35,74)( 36,75)( 39,77)
  ( 44,80)( 48,81)( 50,84)( 57,88)( 59,89)( 66,91)( 68,94)( 72,98)
  ( 79,100)( 82,102)( 87,105)( 92,106)( 97,109)(104,110)(108,112),
 ( 1,22)( 3,23)( 4,24)( 6,29)( 8,30)( 9,31)(11,32)(13,33)(14,36)(15,37)
  (17,38)(19,43)(20,44)(25,47)(28,48)(34,51)(39,54)(42,55)(46,56)(50,57)
  (53,58),( 1,4)( 6,11)( 7,13)( 8,15)( 9,17)(10,18)(12,19)(14,20)(16,21),
 ( 2,7)( 8,15)( 9,18)(10,31)(11,34)(12,44)(21,45)(23,46)(32,47)(33,48)
  (42,49),( 1,13)( 2,16)( 3,21)( 4,26)( 9,43)(10,44)(11,46)(12,47)(14,48)
  (15,49)(18,50)(19,51)(23,52)(24,53)(27,54)(29,55)(30,56)(33,57)(34,58)
  (42,59)(45,60),( 1,7)( 3,10)( 6,14)(11,18)(15,20),
 ( 1,32)( 11,33)( 16,34)( 19,35)( 23,36)( 26,37)( 29,38)( 40,61)
  ( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)( 51,79)( 52,84)( 53,85)
  ( 57,90)( 58,91)( 59,96)( 62,97)( 65,98)( 74,99)( 77,100)( 86,101)
  ( 89,102),( 2,11)( 5,24)( 6,35)( 7,38)( 8,40)( 10,41)( 12,42)
  ( 14,44)( 16,46)( 18,49)( 19,51)( 22,53)( 26,55)( 36,80)( 43,82)
  ( 47,83)( 52,85)( 54,86)( 57,92)( 61,93)( 66,94)( 70,95)( 74,96)
  ( 81,99)( 84,100)( 98,106)(103,109)(105,110),
 ( 2,11)( 5,15)( 7,18)( 8,21)(10,22)(16,23),
 ( 2,11)( 5,15)( 7,18)( 8,20)(10,21)(16,23),
 ( 1,7)( 3,9)( 4,12)( 6,15)( 8,16)(10,18)(13,20)(17,21)(19,22),
 ( 1,8)( 3,12)( 5,13)( 6,17)( 7,20)(10,21)(15,23)(18,25),
 ( 2,23)( 4,24)( 7,25)( 9,29)(12,30)(16,31)(19,35)(21,36)(26,37)(27,38)
  (32,39)(33,40),( 1,13)( 2,15)( 3,19)( 4,23)( 5,25)( 6,27)( 7,29)( 8,33)
  ( 9,35)(10,36)(11,38)(12,40)(16,42)(18,43)(20,44)(28,49)(30,50)(32,51),
 ( 1,22)( 3,23)( 6,26)( 9,27)(12,28)(14,31)(17,34)(19,35)(24,38)(29,41)
  (32,42)(36,43)(39,44),( 1,2)(10,11)(15,16)(19,20)(21,22)(23,24),
 ( 2,4)( 6,8)(10,12)(18,19)(25,26)(28,30)(33,34)(35,37),
 ( 1,4)( 6,9)(11,14)(15,18)(20,22),( 1,7)( 3,9)( 4,11)( 6,14)( 8,17)
  (12,19)(13,20)(16,21)(18,22),( 1,31)( 3,32)( 5,34)( 8,35)( 9,37)(11,39)
  (14,40)(15,41)(17,42)(18,43)(20,44)(21,45)(23,48)(24,49)(25,50)(27,51)
  (28,52)(30,55)(33,57)(36,59)(38,60)(46,62)(47,63)(53,65)(54,66)(56,67)
  (58,68)(61,69)(64,70),( 1,31)( 4,34)( 5,35)( 7,36)(10,37)(11,38)(13,40)
  (15,42)(17,43)(19,44)(20,47)(22,48)(23,49)(24,50)(26,51)(27,54)(29,55)
  (30,56)(32,57)(33,58)(39,59)(41,60)(45,61)(46,62)(52,63)(53,64),
 ( 2,6)( 9,13)(10,20)(11,24)(12,30)(14,34)(19,35)(28,36)(31,37)(39,50)
  (42,57)(46,60)(52,61)(56,62),( 1,30)( 2,32)( 3,33)( 5,36)( 6,38)( 8,40)
  ( 9,42)(10,43)(11,51)(12,53)(13,54)(15,56)(18,58)(19,60)(20,61)(21,63)
  (22,64)(24,66)(27,67)(28,69)(31,71)(37,73)(41,75),
 ( 2,11)( 6,14)( 9,15)(10,16)(12,17)(13,18),
 ( 2,4)( 8,9)(12,13)(16,18)(22,24)(27,28)(30,31),
 ( 2,4)( 8,9)(13,15)(18,20)(24,26),( 2,10)( 3,15)( 6,24)( 8,33)
  ( 11,34)( 13,35)( 14,37)( 16,40)( 19,43)( 20,45)( 21,47)( 25,51)
  ( 31,70)( 32,71)( 38,74)( 39,75)( 42,76)( 44,77)( 48,80)( 49,81)
  ( 50,83)( 73,102)( 79,104),( 1,10)( 2,15)( 3,25)( 4,37)( 6,39)
  ( 8,40)( 11,42)( 12,45)( 14,46)( 16,49)( 18,50)( 20,52)( 21,54)
  ( 26,56)( 47,76)( 48,79)( 57,82)( 58,85)( 59,86)( 75,101)( 81,102),
 ( 1,4)( 6,9)(11,14)(18,21)(27,28)(39,40)(43,44)(47,48)(50,51),
 ( 2, 4)( 9,11)( 12,15)( 20,22)( 27,30)( 39,41)( 43,45)( 48,50)
  ( 51,53)( 57,59)( 62,63)( 64,65)( 67,68)( 69,70)( 71,72)( 74,75)
  ( 76,77)( 81,83)( 88,90)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117),
 ( 2,10)( 3,12)( 4,16)( 5,18)( 6,20)( 7,22)( 8,24)(11,37)(14,40)(17,43)
  (19,45)(23,49)(26,53)(29,54)(30,59)(31,60)(32,64)(33,69)(34,70)(36,71)
  (41,72)(44,73)(47,74)(50,75)(55,79)(57,81)(58,82)(61,83)(63,85)(65,86)
  (67,88)(68,89)(76,91)(77,93)(78,95)(90,96)(92,97)(94,98),
 ( 1,7)( 3,9)( 6,11),( 1,22)( 4,23)( 6,25)( 9,28)(11,30)(14,31)(17,33)
  (20,35)(24,36)(27,38)(32,41)(37,43)(40,44),
 ( 1,13)( 3,21)( 6,34)( 8,41)( 9,45)(12,46)(16,47)(18,49)(20,50)(24,52)
  (27,53)(30,54)(33,55)(37,57)(40,59)(51,60)(58,61),
 ( 1,13)( 3,20)( 5,29)( 8,42)( 9,46)(12,47)(16,48)(19,49)(22,50)(24,51)
  (28,54)(32,55)(35,56)(38,57)(41,58)(52,60)(59,61),
 ( 1,29)( 3,30)( 4,31)( 6,33)( 7,34)(10,35)(13,37)(16,39)(17,42)(20,44)
  (21,45)(22,46)(23,48)(26,50)(27,51)(28,53)(32,56)(36,58)(38,59)(40,60)
  (41,62)(43,64)(47,67)(49,69)(52,70)(54,72)(55,73)(57,74)(61,75)(63,77)
  (65,79)(66,80)(68,81)(71,82)(76,83)(78,84),
 ( 1,29)( 3,30)( 5,33)( 6,34)( 9,35)(10,36)(13,37)(15,39)(17,42)(18,43)
  (19,45)(20,48)(21,49)(22,50)(23,52)(24,53)(25,56)(26,57)(27,59)(28,61)
  (40,62)(41,64)(44,66)(58,67)(63,68)(65,69),
 ( 1,4)( 6,8)( 9,12)(14,15)(16,19)(23,26)(34,36)(37,39)(43,44)(45,47)
  (48,49)(50,51)(52,53)(55,57)(59,61)(64,65)(66,68)(69,70)(71,72)(74,76)
  (77,79)(80,81)(82,84)(85,87)(88,90)(91,92)(93,95),
 ( 1,29)( 4,31)( 5,32)( 8,34)( 9,35)(11,36)(13,38)(15,39)(17,42)(18,44)
  (19,45)(20,46)(21,48)(22,49)(23,51)(24,52)(25,53)(26,55)(27,57)(28,59)
  (40,62)(41,66)(56,68)(60,69)(63,70)(64,71)(67,72),
 ( 1,7)( 3,8)( 4,11)( 6,15)( 9,17)(12,19)(14,20)(16,21)(18,22),
 ( 1,29)( 4,31)( 7,32)(10,34)(11,35)(13,36)(14,39)(16,40)(17,43)(18,45)
  (19,46)(22,48)(23,49)(24,51)(25,53)(28,54)(30,55)(33,56)(37,57)(38,58)
  (41,61)(42,64)(44,65)(47,67)(50,68)(52,70)(59,72)(60,73)(62,75)(63,76)
  (66,77)(69,78)(71,79)(74,80),( 1,8)( 3,10)( 5,21)( 7,22)(13,23)(15,24)
  (19,25),( 1,29)( 4,30)( 7,31)( 8,32)(10,35)(11,36)(13,37)(14,39)(17,42)
  (18,45)(19,46)(20,47)(21,49)(22,50)(23,51)(24,55)(25,56)(26,57)(27,59)
  (28,60)(40,62)(41,65)(53,67)(61,68)(63,69)(64,70)(66,71),
 ( 1,8)( 3,10)( 5,11)( 6,13),( 1,2)( 3,4)( 6,7)(11,12)(15,16)(18,19),
 ( 1,8)( 3,10)( 5,11)( 6,12)( 9,13)(14,16)(15,17),
 ( 2,23)( 6,26)( 7,27)(11,29)(14,32)(16,34)(19,35)(21,36)(24,37)(30,39)
  (33,41)(38,42)(40,43),( 1,10)( 2,15)( 3,17)( 4,20)( 5,24)( 6,26)( 7,29)
  ( 8,32)( 9,35)(12,38)(14,39)(18,43)(22,47)(23,48)(27,50)(31,54)(36,56)
  (40,58)(44,60)(46,61)(49,65)(51,66)(55,68)(57,71)(64,72)(70,74),
 ( 1,2)( 3,4)( 7,8)(10,11)(20,21)(26,27)(29,30),
 ( 1,8)( 2,11)( 3,17)(10,24)(14,29)(18,31)(22,33)(25,37)(32,42)(34,45),
 ( 2,10)( 4,19)( 5,28)( 8,44)( 9,47)(14,48)(18,51)(21,52)(23,53)(25,54)
  (27,55)(33,58)(37,61)(39,62)(41,63)(43,64)(50,65)(60,66),
 ( 1,28)( 2,30)( 5,31)( 6,32)( 9,33)(11,34)(13,37)(15,38)(17,44)(18,45)
  (19,46)(20,48)(21,50)(22,51)(23,52)(24,55)(25,56)(26,58)(27,59)(39,62)
  (40,63)(41,66)(42,67)(57,69)(60,72)(64,73)(68,74)(70,75)(71,76),
 ( 1,13)( 4,26)( 6,35)( 8,42)(10,45)(14,48)(17,49)(20,50)(23,51)(27,52)
  (31,55)(33,56)(36,57)(39,58)(43,59)(47,60)(54,61),
 ( 1,21)( 3,24)( 4,25)( 6,26)( 7,28)( 9,30)(10,31)(11,32)(13,34)(14,36)
  (16,37)(18,48)(22,65)(23,66)(27,67)(29,68)(33,69)(35,70)(39,72)(42,75)
  (45,76)(47,77)(52,80)(55,81)(57,82)(61,85)(64,86),
 ( 1,28)( 2,29)( 4,30)( 5,31)( 7,33)( 8,34)(10,35)(11,37)(13,38)(14,39)
  (16,42)(19,46)(20,47)(24,52)(32,56)(36,58)(40,60)(41,61)(45,62)(49,64)
  (51,66)(54,68)(55,69)(57,70)(59,71)(63,72)(65,73)(67,74),
 ( 1,28)( 3,31)( 4,32)( 6,33)( 7,35)( 9,36)(10,37)(12,39)(13,40)(15,41)
  (16,42)(20,47)(24,52)(25,53)(29,55)(30,56)(34,58)(38,60)(45,62)(48,64)
  (50,66)(54,68)(57,69)(59,70)(61,71)(63,72)(65,73)(67,74),
 ( 1,28)( 3,30)( 4,31)( 5,33)( 6,35)( 7,37)( 8,38)( 9,40)(10,42)(11,44)
  (12,45)(14,49)(16,53)(18,55)(20,59)(21,61)(22,65)(26,67)(32,68)(39,69),
 ( 2,10)( 4,15)( 5,19)( 7,24)( 9,48)(11,50)(13,52)(17,53)(20,54)(22,56)
  (25,58)(28,59)(36,61)(43,63)(47,65)(51,66)(57,67)(60,77)(62,78)(64,79),
 ( 1,7)( 3,8)( 9,18)(11,19)(13,21)(15,22),
 ( 1,4)( 7,9)(10,13)(16,18)(19,20)(22,23)(25,26),
 ( 1,38)( 2,41)( 4,42)( 6,46)( 9,49)(10,51)(14,52)(15,55)(18,57)(21,59)
  (22,63)(25,66)(27,68)(30,71)(31,73)(33,74)(35,77)(45,80)(47,82)(62,85)
  (64,87)(69,89)(78,91)(83,93),( 2,4)(10,12)(18,19)(21,22)(25,26)(28,29)
  (32,33)(35,36)(38,39)(41,42)(44,45)(46,47),
 ( 2,4)(10,12)(18,19)(22,23)(25,26)(29,30)(32,33)(37,38)(39,40)(43,44)
  (47,48)(50,51)(52,53)(54,55)(57,58),( 2,4)(10,12)(19,20)(22,23)(25,26)
  (28,29)(31,32)(34,35)(36,37)(38,39)(40,41)(44,45)(47,48)(49,50)(53,55)
  (57,58)(59,60)(62,63),( 1,28)( 3,29)( 4,30)( 6,32)( 7,33)( 9,34)(10,36)
  (12,37)(13,38)(15,41)(16,42)(18,46)(19,47)(23,52)(31,56)(35,58)(39,60)
  (40,61)(45,62)(49,64)(51,66)(54,68)(55,69)(57,70)(59,71)(63,72)(65,73)
  (67,74),( 1,28)( 4,29)( 6,31)( 8,32)( 9,34)(12,35)(14,37)(16,38)(17,41)
  (18,42)(19,44)(20,45)(21,48)(22,50)(23,51)(24,52)(25,53)(26,54)(27,55)
  (40,61)(46,67)(47,68)(57,69)(58,70)(59,74)(62,75)(63,76)(64,77)(65,78)
  (66,80)(71,82)(72,84),( 1,2)( 6,7)(11,12)(18,19)(26,27)(33,34),
 ( 1,7)( 4,13)( 5,18)( 9,21)(14,23)(16,26)(22,28)(24,30),
 ( 1,27)( 2,29)( 3,31)( 5,32)( 6,34)( 7,36)( 8,38)( 9,40)(10,42)(12,44)
  (13,45)(14,50)(16,54)(18,56)(19,60)(20,62)(24,66)(30,67)(37,68)(43,69),
 ( 1,8)( 4,26)( 6,34)(11,41)(13,42)(16,44)(19,47)(22,49)(25,52)(27,53)
  (30,55)(31,56)(37,60)(39,62)(45,65)(48,68)(51,70)(58,73)(61,76)(63,78)
  (67,80)(71,82)(75,84)(77,87)(81,90)(86,92)(89,94),
 ( 1,12)( 2,23)( 3,48)( 5,50)( 8,51)( 10,52)( 17,54)( 20,55)
  ( 24,56)( 28,59)( 32,60)( 36,64)( 38,65)( 42,69)( 44,70)( 47,74)
  ( 57,80)( 58,82)( 62,87)( 63,89)( 67,91)( 68,93)( 72,95)( 73,97)
  ( 75,100)( 78,102)( 79,103)( 99,104)(101,105),
 ( 1,2)( 6,7)(11,12)(18,19)(27,28)(35,36)(40,41),
 ( 1,27)( 2,28)( 3,29)( 5,32)( 6,33)( 7,34)( 9,37)(10,38)(13,48)(14,50)
  (15,52)(16,54)(17,57)(18,59)(20,61)(21,63)(22,66)(23,68)(24,69)(25,71)
  (30,72)(35,73)(39,74),( 1,4)( 7,8)(10,11),
 ( 1,27)( 2,28)( 4,31)( 5,32)( 7,35)( 8,37)( 9,38)(10,39)(11,42)(13,44)
  (16,49)(18,52)(22,55)(24,57)(25,60)(29,62)(30,64)(33,65)(34,67)(40,68)
  (41,70)(51,71)(54,73)(59,75),( 2,10)( 4,12)( 6,15)( 8,16)(17,24)(19,29),
 ( 1,3)( 5,11)( 7,12)( 8,13)( 9,14)(10,15),
 ( 1,4)( 8,13)( 9,14)(10,15)(12,16),( 1,4)( 8,12)(15,18)(19,22)(24,25)
  (26,28)(32,33)(34,36)(39,40)(41,43),( 2,10)( 4,12)( 6,13)( 9,16)(11,17),
 ( 1,4)( 8,12)(16,19)(20,23)(25,26)(27,28)(32,33)(36,37)(38,39),
 ( 1,27)( 3,28)( 4,30)( 5,33)( 6,34)( 7,35)( 9,37)(10,40)(12,41)(13,44)
  (15,49)(17,52)(20,54)(22,57)(25,60)(31,61)(32,62)(38,64)(39,65)(42,67)
  (43,68)(51,74)(56,76)(59,78),( 1,2)( 6,7)(12,13)(22,23)(25,26)(29,30)
  (31,32),( 1,27)( 4,29)( 5,30)( 7,31)(10,32)(11,34)(14,35)(16,37)(17,42)
  (18,44)(19,45)(20,47)(21,48)(22,49)(23,53)(24,54)(25,56)(26,58)(38,62)
  (39,64)(40,67)(41,69)(50,70)(51,72)(57,73)(59,75)(60,76)(61,78)(65,79)
  (66,81),( 1,12)( 2,19)( 3,24)( 4,26)( 5,32)( 35,48)( 36,59)
  ( 41,60)( 42,61)( 45,62)( 50,64)( 51,65)( 56,67)( 57,68)( 58,77)
  ( 70,87)( 73,90)( 76,93)( 79,96)( 82,99)( 85,102)( 86,104)( 89,106)
  ( 92,107)( 95,109)( 98,110)(101,112),( 1,2)( 4,10)( 5,14),
 ( 2,10)( 4,12)( 7,14)( 8,15)( 9,16),( 1,4)( 8,11)(13,16)(18,21)(24,25)
  (36,37)(45,46)(48,49)(52,53),( 2,4)(13,15)(18,20)(23,24)(26,27)(31,32)
  (38,39)(41,42),( 2,10)( 4,12)( 8,15)(11,16)(14,17),
 ( 2,4)(13,15)(18,20)(24,25)(26,27)(31,32)(34,35),
 ( 1,9)( 3,12)( 6,16)( 8,19)(11,21)(17,23),
 ( 1,2)( 6,7)(13,14)(21,22)(24,25)(28,29)(31,32),
 ( 1,12)( 2,18)( 3,21)( 4,26)( 5,33)( 6,40)( 7,41)( 9,43)(13,45)(15,46)
  (17,47)(20,49)(22,50)(25,52)(27,54)(29,55)(32,57)(35,58)(38,60)(42,61)
  (44,63)(48,64)(51,66)(53,67)(56,69)(59,70)(62,72)(65,74)(68,75)(71,78)
  (73,80)(76,82)(77,83)(79,84)(81,85),( 2,4)(15,17)(19,21)(23,24)(25,27)
  (28,29)(30,31)(32,34)(35,36),( 1,4)( 2,12)( 3,17)( 6,22)(11,25)(14,29)
  (21,33)(24,37),( 2,4)( 5,7)(18,20)(22,24)(29,30)(35,37)(41,43)(44,46)
  (47,48)(51,53)(57,59)(60,62)(64,65)(66,67)(71,73)(75,76)(79,80)(82,83)
  (86,87)(89,90)(92,93)(95,96),( 1,9)( 2,12)( 3,15)( 4,20)( 5,23)( 6,26)
  ( 7,32)(11,39)(13,41)(17,43)(18,44)(21,49)(22,50)(24,52)(28,55)(29,57)
  (34,61)(35,62)(36,63)(40,64)(45,67)(46,68)(48,69)(51,72)(56,73)(59,75)
  (60,76)(70,80)(77,82),( 1,2)( 4,5)(10,11)(17,18)(20,21),
 ( 1,37)( 4,40)( 6,44)( 7,46)(11,47)(13,51)(15,52)(18,55)(21,58)(23,62)
  (26,64)(27,65)(30,68)(33,72)(35,73)(36,76)(42,78)(43,81)(50,82)(60,83)
  (61,86)(66,87)(71,89)(79,90)(84,92),( 1,8)( 5,13)( 9,14)(11,15),
 ( 1,19)( 2,22)( 3,25)( 4,31)( 5,35)( 36,45)( 38,58)( 40,61)
  ( 43,62)( 46,64)( 48,66)( 51,68)( 53,71)( 55,72)( 56,78)( 73,86)
  ( 75,89)( 77,92)( 79,95)( 81,98)( 83,101)( 85,102)( 88,104)( 91,105)
  ( 94,107)( 97,108)(100,110),( 1,9)( 3,11)( 4,12)( 6,14)( 7,15)(10,16)
  (13,17),( 1, 8)( 7,31)( 9,35)( 10,36)( 12,38)( 15,39)( 18,40)
  ( 20,42)( 21,43)( 22,45)( 25,46)( 32,72)( 34,75)( 37,78)( 41,83)
  ( 44,86)( 47,95)( 49,97)( 51,99)( 53,101)( 56,105)( 58,107)( 60,109)
  ( 62,111)( 64,113)( 67,117)( 69,119)( 71,120)( 74,121)( 76,122)( 80,123)
  ( 82,124)( 84,125)(102,133)(114,135),( 2,10)( 4,11)( 7,14)( 9,16)(18,23)
  (19,28),( 1,12)( 2,15)( 3,18)( 4,30)( 5,34)( 36,45)( 38,56)
  ( 39,57)( 43,59)( 44,62)( 48,64)( 50,67)( 51,68)( 54,77)( 55,86)
  ( 70,88)( 73,90)( 76,92)( 79,94)( 82,96)( 85,98)( 89,100)( 91,101)
  ( 93,104)( 95,105)( 97,108)( 99,109),( 2,5)( 7,12)( 8,13)(10,14),
 ( 1,25)( 4,26)( 6,27)( 9,28)(11,29)(14,32)(16,33)(19,34)(23,35)(30,37)
  (36,38),( 1,4)( 9,15)(10,19)(11,30)(12,35)(16,36)(18,37)(24,38)(26,39)
  (32,40)(33,44)(34,51),( 2,5)( 7,10)( 8,11)( 9,12),
 ( 1, 6)( 2,20)( 3,24)( 4,26)( 5,32)( 36,45)( 38,59)( 39,60)
  ( 42,62)( 46,65)( 47,66)( 51,69)( 52,70)( 55,72)( 56,78)( 73,85)
  ( 75,88)( 77,91)( 79,94)( 81,97)( 83,100)( 84,102)( 87,103)( 90,105)
  ( 93,106)( 96,108)( 99,109),( 1,10)( 2,11)( 3,14)( 4,18)( 5,21)( 6,23)
  ( 7,26)( 8,29)( 9,31)(15,41)(16,42)(20,46)(24,51)(28,54)(32,56)(34,58)
  (37,60)(40,61)(43,63)(45,64)(49,68)(50,69)(53,70)(55,71)(59,74)(65,76)
  (67,77)(72,79),( 1,24)( 2,27)( 4,28)( 6,30)( 8,33)(10,34)(11,35)(13,36)
  (15,38)(16,41)(18,42)(20,43)(21,44)(25,45)(26,46)(31,47)(32,48)(39,49)
  (40,50),( 1,24)( 2,27)( 6,28)( 9,29)(11,30)(14,33)(16,34)(19,35)(21,36)
  (26,37)(32,38),( 1,4)( 2,11)( 6,12)( 8,13)( 9,14)(10,15),
 ( 1,4)( 2,10)( 3,17)( 8,24)(13,28)(16,31)(21,33)(27,35),
 ( 2,4)( 7,8)(10,11),( 1, 6)( 2,17)( 3,23)( 7,44)( 10,46)
  ( 12,47)( 15,48)( 18,51)( 24,52)( 27,53)( 30,56)( 33,57)( 37,63)
  ( 42,69)( 50,77)( 54,80)( 55,82)( 60,90)( 62,92)( 66,94)( 68,96)
  ( 72,98)( 74,100)( 75,102)( 79,103),( 1, 7)( 2,17)( 3,22)( 6,40)
  ( 11,42)( 12,44)( 14,46)( 16,47)( 18,50)( 20,51)( 21,54)( 24,56)
  ( 26,57)( 28,59)( 37,74)( 38,75)( 39,78)( 48,81)( 49,84)( 79,101)
  ( 85,102),( 1,4)( 9,12)(14,17)(23,25)(28,30)(33,35)(37,39)(41,42)(44,45)
  (48,49)(54,55),( 2,3)( 4,6)( 9,11)(14,16)(18,20)(22,24),
 ( 1,4)( 2,10)( 3,13)( 6,20)( 9,26)(16,31)(23,33)(37,42)(40,44),
 ( 1, 6)( 2,16)( 3,21)( 5,40)( 10,42)( 11,44)( 13,46)( 15,47)
  ( 17,50)( 19,51)( 20,54)( 23,56)( 25,57)( 27,59)( 37,74)( 38,75)
  ( 39,78)( 48,81)( 49,84)( 79,101)( 85,102),
 ( 1,2)( 7,9)(14,15)(17,18)(20,21)(23,24)(25,26),
 ( 1,7)( 3,10)( 6,18)( 9,22)(11,23)(16,25)(24,28)(26,30),
 ( 1,2)( 7,9)(15,16)(19,20)(22,23)(26,27),
 ( 1,12)( 2,14)( 3,15)( 4,17)( 5,20)( 6,23)( 7,27)( 8,29)( 9,30)(10,40)
  (19,44)(21,45)(22,47)(24,48)(26,49)(33,53)(35,54)(36,56)(38,57)(39,58),
 ( 1,5)( 2,10)( 6,23)( 9,26)(11,28)(16,32)(19,33)(24,36)(30,39),
 ( 2, 3)( 4, 5)( 6, 7)( 8, 9)( 10,11)( 13,14)( 15,16)( 18,19)
  ( 21,22)( 23,24)( 25,26)( 32,33)( 34,35)( 37,38)( 39,40)( 41,42)
  ( 44,45)( 46,47)( 49,50)( 51,52)( 53,54)( 57,58)( 61,62)( 65,66)
  ( 69,70)( 73,74)( 77,78)( 81,82)( 85,86)( 89,90)( 93,94)( 97,98)
  (101,102),( 1,12)( 2,14)( 4,16)( 5,17)( 8,21)(11,23)(13,24)(15,25)(18,26)
  ,( 1,7)( 2,15)( 3,19)( 6,21)( 9,25)(14,28)(27,31)(30,35),
 ( 1,24)( 2,25)( 4,26)( 6,27)( 7,30)( 9,32)(11,33)(12,34)(14,35)(16,38)
  (17,39)(19,40)(20,41)(22,44)(28,46)(36,48)(42,50),
 ( 1,24)( 3,27)( 4,28)( 5,29)( 6,32)( 8,33)( 9,34)(11,35)(12,38)(13,39)
  (14,40)(16,47)(17,50)(18,53)(19,56)(21,61)(23,64)(26,67)(31,68)(37,69),
 ( 1, 6)( 2,14)( 3,17)( 4,20)( 5,32)( 36,45)( 38,56)( 39,57)
  ( 43,59)( 44,62)( 48,64)( 50,67)( 51,68)( 54,77)( 55,86)( 70,88)
  ( 73,90)( 76,92)( 79,94)( 82,96)( 85,98)( 89,100)( 91,101)( 93,104)
  ( 95,105)( 97,108)( 99,109),( 1,4)( 9,10)(12,14)(17,20)(21,24)(28,30)
  (38,39)(41,43)(47,49)(51,52)(54,55)(57,59)(64,65)(68,70)(72,74)(75,76)
  (79,80)(84,85)(87,89)(90,92)(93,95),( 2,5)( 7,9)(11,14)(16,18),
 ( 1,6)( 2,13)( 3,20)( 5,22)( 8,23)(11,25)(14,26)(19,28)(24,30)(27,31)
  (29,32),( 1,6)( 2,13)( 3,19)( 7,21)(10,24)(15,28)(25,35)(31,37),
 ( 1,6)( 2,13)( 3,18)( 7,26)(11,27)(16,30)(22,31),
 ( 1,24)( 3,26)( 5,28)( 7,29)(11,30)(14,32)(16,34)(19,35)(21,36)(27,37)
  (33,38),( 1,6)( 2,13)( 3,18)( 7,25)(11,27)(16,29)(22,31),
 ( 1,4)( 2,9)( 3,12)(18,33)(21,35)(24,36)(28,38)(32,40)(43,52)(47,53)
  (50,54),( 2,5)( 7,8)(10,12)(15,16)(17,18)(20,21)(22,23),
 ( 1,4)(10,12)(13,15)(17,19)(20,22)(23,24),
 ( 1,10)( 3,13)( 6,17)( 8,18)(12,20)(21,25)(23,26),
 ( 1,4)( 2,9)( 5,11)( 7,13)(10,14)(12,15),
 ( 1,9)( 4,17)( 6,22)( 8,26)(11,47)(13,48)(14,49)(16,50)(19,53)(21,54)
  (24,55)(25,56)(29,58)(31,59)(37,63)(52,67)(57,69)(61,73)(75,80)(77,82),
 ( 2,17)( 8,18)( 15,19)( 21,36)( 22,38)( 23,39)( 24,40)( 25,42)
  ( 26,44)( 27,45)( 28,46)( 29,48)( 30,50)( 31,51)( 32,53)( 33,54)
  ( 34,55)( 35,57)( 58,68)( 59,69)( 60,72)( 61,73)( 62,78)( 63,79)
  ( 64,83)( 65,86)( 66,87)( 70,94)( 74,96)( 75,97)( 76,98)( 80,100)
  ( 81,101)( 82,102)( 84,103)( 88,105)( 89,106)( 90,108)( 91,110)( 92,113)
  ( 93,116)(107,118)(109,119)(111,121)(112,122)(114,124)(115,125)(117,127)
  (120,128)(123,129)(126,130),( 1,6)( 2,12)( 3,19)( 5,22)( 7,23)(10,26)
  (13,27)(18,29)(24,32)(28,34)(30,36),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)
  (16,17)(18,19)(22,23)(24,25)(28,29),( 1,9)( 4,17)( 6,20)(11,22)(16,24)
  (18,25)(21,27)(23,29),( 1, 7)( 2,13)( 3,20)( 4,26)( 5,31)
  ( 35,52)( 36,56)( 40,59)( 41,61)( 45,65)( 46,67)( 49,69)( 53,72)
  ( 54,73)( 55,79)( 74,87)( 76,90)( 78,93)( 80,96)( 82,99)( 84,102)
  ( 85,103)( 88,105)( 91,107)( 94,109)( 97,111)(100,113),
 ( 1,12)( 3,16)( 5,21)( 8,29)( 9,43)(13,45)(14,46)(17,47)(19,48)(22,51)
  (24,52)(25,53)(27,54)(34,58)(39,65)(44,73)(49,75)(62,80)(71,83),
 ( 1,4)( 2,9)(13,28)(16,30)(25,40)(26,50)(33,52)(36,55)(37,56)(39,58)
  (42,61)(43,62)(47,64)(49,66)(57,74)(63,75)(67,76)(80,89)(84,91)(87,93),
 ( 1,7)( 2,13)( 3,19)( 4,25)( 5,30)( 6,36)( 8,38)(10,39)(12,42)(15,43)
  (18,46)(20,48)(23,51)(24,52)(26,55)(29,56)(31,57)(33,59)(35,62)(40,63)
  (41,64)(44,66)(47,67)(49,70)(53,72)(54,73)(58,75)(60,78)(68,80)(76,81),
 ( 1,5)( 2,9)( 6,11),( 1,17)( 3,19)( 5,20)( 7,22)( 9,23)(11,25)(13,26)
  (15,28)(18,40)(24,41)(32,47)(39,60)(48,63)(57,65),( 1,5)( 2,9)( 6,10),
 ( 1,12)( 3,14)( 4,16)( 6,18)( 9,21)(11,22)(13,23)(15,24)(17,25),
 ( 1,5)( 2,9)( 7,21)(11,23)(13,25)(16,27)(19,29),
 ( 2,15)( 3,19)( 5,26)( 7,32)( 9,35)(12,37)(14,39)(17,41)(18,42)(21,46)
  (25,49)(29,52)(31,53)(36,57)(38,61)(44,67)(45,70)(56,77)(63,83)(66,85)
  (74,91),( 1,5)( 2,9)(15,25)(17,31)(19,37)(21,43)(23,49)(26,50)(30,54)
  (34,58)(38,62)(42,66)(46,70)(51,74)(57,77)(59,78)(65,81)(67,82)(73,85),
 ( 1,12)( 3,13)( 4,16)( 6,17)( 7,18)( 8,19)(10,22)(11,25)(14,28)(20,31)
  (23,32)(26,33)(29,34),( 2,15)( 3,19)( 5,23)( 7,28)( 9,43)(12,44)(14,47)
  (17,48)(18,49)(22,50)(25,53)(27,54)(34,60)(39,67)(46,71)(52,72)(56,76)
  (59,78)(64,80)(65,81)(75,87)(79,88),( 2,9)( 3,11)( 5,13)( 6,15)( 7,16)
  (10,18)(14,20)(17,21)(19,22),( 2,3)( 4,5)( 9,10)(12,13)(22,25)(36,39)
  (42,43)(45,46)(48,49),( 1,10)( 3,12)( 5,13)( 7,15)(18,25)(19,31),
 ( 1,3)( 2,8)(18,28)(21,30)(25,33)(26,43)(34,53)(36,55)(40,57)(41,58)
  (44,61)(46,63)(47,64)(50,67)(52,74)(56,75)(62,76)(77,88)(80,90)(84,92),
 ( 2,3)( 4,5)( 9,10)(15,16)(18,19)(21,22),
 ( 1,24)( 3,25)( 6,26)( 8,29)(11,30)(12,31)(16,32)(19,35)(21,36)(28,37)
  (34,38),( 2,9)( 3,11)( 5,12)( 7,14)( 8,15)(10,16)(13,17),
 ( 1,4)( 2,8)( 3,13)(10,26)(18,30)(20,31)(23,32)(27,33),
 ( 1,24)( 3,25)( 6,26)( 8,27)(11,30)(13,32)(16,33)(19,34)(21,37)(29,38)
  (36,39),( 1,10)( 3,12)( 7,15)(11,16)(14,17),
 ( 2,15)( 4,18)( 9,22)(11,24)(13,25)(16,46)(17,47)(21,48)(26,50)(29,52)
  (31,53)(33,56)(36,58)(37,59)(39,62)(42,64)(44,65)(54,70)(60,71)(66,72),
 ( 1,6)( 2,11)( 3,17)( 8,21)(10,25)(24,34)(26,37)(29,40)(36,44)(39,47),
 ( 1,2)( 7,8)(14,15)(19,20)(22,23)(27,28)(30,31)(35,36)(39,40)(42,43)
  (44,45)(48,49)(52,53)(55,56)(58,59)(60,61)(63,64)(67,68)(72,73)(74,75)
  (78,79)(81,82)(85,86)(88,89)(91,92)(94,95),
 ( 1, 6)( 2,11)( 3,15)( 4,20)( 5,29)( 35,50)( 36,55)( 40,59)
  ( 41,61)( 45,64)( 46,66)( 48,67)( 52,71)( 53,73)( 54,82)( 75,92)
  ( 78,94)( 81,96)( 84,98)( 87,100)( 90,102)( 91,103)( 93,105)( 95,106)
  ( 97,108)( 99,109)(101,111),( 1,7)( 2,12)( 3,19)( 4,23)( 8,24)(11,25)
  (15,26)(17,27)(21,28),( 1,17)( 3,18)( 6,19)( 7,22)( 9,23)(11,24)(14,25)
  (15,28)(20,41)(26,42)(33,47)(37,52)(44,59)(50,62),
 ( 1,10)( 3,11)( 5,13)( 8,16)(18,24)(19,29),
 ( 2,4)(10,12)(18,19)(20,21)(23,24)(28,29)(30,31)(34,35)(37,38)(42,43)
  (44,45)(47,49)(52,53)(54,55)(59,60)(61,62)(63,64)(66,67)(74,75)(81,82)
  (86,87),( 1,2)( 7,8)(18,19)(20,21)(22,23),
 ( 2,41)( 4,42)( 7,46)( 8,47)(11,49)(14,52)(15,55)(18,57)(20,58)(23,60)
  (26,63)(27,64)(30,66)(33,69)(35,72)(38,74)(39,75)(45,77)(51,78)(54,80)
  (62,81)(68,82)(71,84),( 2,4)( 3,6)(12,24)(22,36)(26,38)(28,39)(30,45)
  (40,52)(42,54)(44,56)(46,58)(48,60)(50,62)(51,63)(55,65)(59,67),
 ( 2,9)( 3,10)( 6,12)( 7,13),( 1,10)( 4,23)( 6,30)( 9,36)( 12,40)
  ( 19,43)( 20,45)( 22,48)( 25,52)( 27,53)( 29,54)( 33,57)( 34,59)
  ( 38,64)( 39,65)( 41,68)( 44,71)( 47,73)( 51,76)( 58,82)( 63,85)
  ( 67,88)( 79,96)( 91,104)( 95,106)( 98,110)(101,113)(103,115)(109,119)
  (112,122),( 2,9)( 4,23)( 5,31)( 8,40)(10,44)(12,47)(14,48)(15,49)(19,53)
  (21,54)(24,55)(27,59)(33,60)(37,64)(39,65)(50,68)(51,69)(61,72)(62,73),
 ( 1,10)( 4,20)( 5,25)( 7,33)(11,39)(14,43)(16,47)(21,48)(24,52)(26,53)
  (30,59)(34,60)(37,61)(40,62)(44,65)(49,66)(54,69)(56,70)(63,71)(67,72),
 ( 1,10)( 4,18)( 5,22)( 7,27)(11,48)(13,49)(15,52)(19,53)(20,54)(23,55)
  (25,58)(28,59)(30,60)(33,61)(37,64)(43,67)(50,68)(56,69),
 ( 1,3)( 2,6)( 5,9)(10,13)(11,14),( 1,10)( 4,18)( 5,22)( 7,27)(11,45)
  (13,46)(15,49)(19,50)(20,51)(23,52)(25,55)(28,56)(30,57)(32,58)(41,69)
  (47,73)(53,74)(62,76)(68,78),( 2,9)( 4,18)( 7,32)(11,37)(14,38)(17,40)
  (20,43)(22,44)(24,49)(27,52)(31,53)(34,58)(36,62)(42,64)(46,65)(48,67)
  (51,70)(55,71)(57,73)(60,76)(69,78)(75,80),
 ( 1,3)( 2,6)( 7,20)(10,23)(17,29)(22,33)(27,38)(28,40)(31,41)(32,43)
  (35,44)(37,46)(39,47),( 1,4)( 2,7)( 3,9)( 5,10),
 ( 1,3)( 2,6)(13,28)(16,30)(23,32)(24,38)(25,42)(26,48)(35,53)(39,56)
  (41,58)(45,61)(49,63)(51,65)(55,76)(60,77)(64,78),
 ( 2,3)( 5,7)( 8,9)(11,12)(13,14)(16,17),
 ( 1,27)( 3,29)( 4,31)( 5,33)( 6,34)( 7,36)( 8,38)( 9,40)(10,41)(11,43)
  (12,45)(14,50)(16,52)(19,56)(21,58)(22,62)(24,64)(26,67)(32,68)(39,69),
 ( 1,8)( 2,24)( 3,26)( 4,31)(35,42)(36,45)(37,57)(38,60)(39,69)(43,70)
  (44,71)(48,73)(49,75)(53,76)(54,77)(58,79)(59,81)(63,82)(64,83)(68,85),
 ( 1,23)( 2,26)( 4,27)( 5,28)( 7,30)( 9,33)(10,34)(12,35)(14,36)(15,38)
  (17,41)(19,42)(20,43)(21,44)(24,46)(31,47)(39,48),
 ( 2,3)( 5,7)(10,12)(14,16)(18,20)(22,24),
 ( 1,3)( 2,5)( 6,10)( 8,12)( 9,13),( 2,3)( 5,7)(10,12)(15,16)(18,19)
  (21,22),( 2,3)( 5,7)(10,11),( 1,6)( 2,10)( 3,17)( 9,20)(11,23)(25,33)
  (26,36)(29,38)(37,42)(39,45),( 1,3)( 2,5)( 6,9)(10,13)(11,15),
 ( 2,14)( 4,19)( 6,23)( 7,27)(10,48)(11,49)(13,50)(16,53)(18,54)(21,55)
  (22,56)(26,58)(29,59)(30,60)(36,63)(42,66)(52,69)(57,71),
 ( 1,10)( 4,13)( 6,14)( 8,16)(18,21)(19,26),
 ( 1,3)( 2,5)( 7,12)( 8,14)(11,15)(13,16),
 ( 1,3)( 2,5)( 7,11)( 8,12)(13,15)(14,16),
 ( 1,23)( 2,24)( 4,28)( 6,29)( 9,31)(11,32)(13,33)(14,34)(16,35)(18,39)
  (19,40)(21,41)(25,42)(26,43)(27,44)(30,47)(36,50)(37,51)(38,52)(45,55)
  (46,56)(48,57)(49,58)(53,59)(54,60),( 1,23)( 2,24)( 4,28)( 6,29)( 8,30)
  ( 9,32)(11,33)(13,34)(14,35)(16,36)(18,40)(19,41)(21,42)(25,43)(27,44)
  (31,47)(37,50)(39,51)(45,54)(48,55)(52,56),
 ( 1,2)( 8,9)(12,13)(14,15)(16,17)(18,19),
 ( 1,2)( 8,9)(12,13)(14,15)(21,22)(23,24)(26,28)(29,30)(32,34)(41,42)
  (43,44),( 1,23)( 2,24)( 4,27)( 6,29)( 7,30)( 9,31)(10,34)(12,36)(13,37)
  (14,38)(16,39)(18,42)(19,44)(21,45)(26,46)(33,47)(41,48),
 ( 1,23)( 2,24)( 4,27)( 6,29)( 8,30)(10,32)(11,34)(13,35)(14,36)(16,37)
  (18,40)(19,42)(21,43)(25,44)(26,45)(31,47)(38,49)(39,50)(46,52)(48,53)
  (51,54),( 1,6)( 2,10)( 4,21)( 8,23)(14,25)(17,27)(20,29),
 ( 1,4)( 8,10)(12,14)(18,21)(23,24)(29,30)(34,36)(37,38)(42,44)(45,47)
  (48,50)(52,54),( 1, 4)( 8,10)( 17,20)( 25,26)( 28,30)( 33,36)
  ( 38,40)( 41,43)( 44,45)( 50,51)( 54,56)( 58,59)( 61,63)( 67,68)
  ( 72,73)( 75,77)( 78,79)( 82,83)( 85,87)( 89,91)( 92,93)( 96,98)
  (100,102),( 1,8)( 5,15)( 9,16)(11,18)(12,19)(14,21),
 ( 1,9)( 3,11)( 4,13)( 6,15)( 7,16)(10,17)(14,18),
 ( 1,7)( 2,11)( 3,15)( 5,19)(10,23)(17,28)(22,33)(36,41)(39,42),
 ( 1,23)( 3,27)( 4,28)( 6,29)( 8,33)(10,34)(11,35)(13,36)(15,37)(16,41)
  (18,42)(20,43)(21,44)(24,45)(26,46)(30,47)(32,48)(38,49)(40,50),
 ( 1,23)( 3,27)( 5,28)( 6,29)( 8,33)(10,34)(11,35)(13,36)(15,37)(16,41)
  (18,42)(20,43)(21,44)(24,45)(26,46)(30,47)(32,48)(38,49)(40,50),
 ( 2,13)( 3,18)( 6,26)( 8,30)( 9,45)(11,46)(14,47)(16,48)(19,51)(21,52)
  (23,53)(27,54)(28,57)(33,61)(38,66)(49,73)(55,74)(64,76)(71,78),
 ( 1,23)( 3,27)( 5,28)( 6,29)( 8,31)(10,32)(12,33)(13,34)(15,35)(17,39)
  (18,40)(20,41)(22,42)(24,43)(26,44)(30,47)(36,50)(38,51)(45,54)(48,55)
  (52,56),( 2,13)( 3,17)( 4,21)( 5,22)( 6,29)( 7,32)( 8,36)(14,43)(15,44)
  (19,45)(20,46)(23,47)(24,48)(27,49)(28,50)(30,51)(34,52)(35,53)(37,54)
  (38,55)(39,57)(40,58)(41,60)(42,61)(56,63)(59,64)(62,65),
 ( 2,13)( 3,17)( 4,20)( 5,27)( 6,28)( 7,32)( 8,36)(14,43)(15,44)(19,45)
  (21,46)(22,47)(25,48)(26,49)(29,50)(30,51)(34,52)(35,53)(37,55)(38,56)
  (39,58)(40,59)(41,61)(42,62)(54,63)(57,64)(60,65),
 ( 2,32)( 5,33)( 7,34)( 12,35)( 16,36)( 21,37)( 29,38)( 39,62)
  ( 43,65)( 46,66)( 49,68)( 52,70)( 55,72)( 57,73)( 58,75)( 61,77)
  ( 71,92)( 76,93)( 78,94)( 79,96)( 82,98)( 85,100)( 86,102)( 89,104)
  ( 95,107)( 97,109)( 99,111)(101,113)(103,115)(105,117)(106,118)(110,119)
  (114,120),( 1, 6)( 2, 9)( 3,17)( 5,36)( 8,41)( 11,42)( 13,43)
  ( 15,46)( 22,52)( 23,53)( 26,56)( 28,57)( 38,84)( 40,86)( 45,87)
  ( 49,88)( 51,90)( 55,91)( 60,98)( 64,99)( 68,101)( 72,102)( 76,103)
  ( 80,105),( 1,23)( 3,27)( 6,28)( 8,32)(10,33)(11,34)(13,35)(15,36)(16,40)
  (18,41)(20,42)(21,43)(24,44)(25,45)(26,46)(29,47)(30,48)(31,49)(37,50)
  (38,51)(39,52),( 1,4)( 2,6)(10,25)(20,28)(23,32)(24,42)(33,52)(37,54)
  (39,56)(43,58)(47,61)(49,63)(51,80)(55,81)(60,82)(65,83)(68,85)(70,87)
  (73,89)(76,91)(78,93),( 1,7)( 2,10)( 3,25)( 4,29)( 5,33)( 6,39)( 9,43)
  (12,44)(14,46)(15,48)(17,49)(22,52)(24,53)(26,54)(28,55)(30,57)(32,59)
  (36,61)(38,62)(41,63)(42,64)(45,66)(47,67)(50,68)(51,69)(56,71)(58,72)
  (60,73)(65,74)(70,75),( 2,4)( 6,20)( 9,21)(11,22)(13,24)(14,26)(16,28)
  (17,30)(19,32),( 1,23)( 3,26)( 4,27)( 6,28)( 7,29)( 9,32)(11,33)(12,34)
  (14,35)(16,37)(17,40)(19,41)(21,42)(22,43)(25,45)(31,47)(39,49),
 ( 1,2)( 8,9)(13,14)(18,19)(25,26)(30,31),
 ( 1,10)( 6,22)( 8,27)(12,35)(13,38)(15,39)(16,44)(19,47)(21,48)(23,52)
  (24,54)(28,58)(31,60)(34,61)(41,64)(43,65)(46,68)(49,71)(57,73)(62,77)
  (67,80)(69,82)(75,85),( 2,9)( 4,11)( 6,13)( 7,15),
 ( 1,9)( 2,25)( 3,27)( 4,32)(35,42)(36,45)(37,57)(38,60)(39,69)(43,70)
  (44,71)(48,73)(49,75)(53,76)(54,77)(58,79)(59,81)(63,82)(64,83)(68,85),
 ( 1,23)( 3,26)( 5,28)( 7,29)( 8,32)(10,34)(11,35)(13,36)(15,37)(16,40)
  (18,42)(20,43)(21,44)(24,45)(25,46)(30,47)(31,48)(38,49)(39,50),
 ( 1,23)( 3,26)( 5,27)( 6,28)( 8,29)( 9,32)(11,33)(13,34)(14,36)(16,37)
  (18,40)(19,41)(20,42)(22,44)(24,46)(30,48)(38,50),
 ( 1,23)( 3,26)( 5,27)( 7,29)( 8,30)( 9,33)(11,34)(13,35)(14,37)(16,38)
  (18,41)(19,42)(20,43)(22,45)(24,46)(31,47)(39,48),
 ( 1,6)( 2,9)( 4,10)( 5,13)( 8,16)(12,19)(15,22)(18,23)(21,24),
 ( 2,9)( 4,11)( 6,12)(10,14)(13,15),( 2,3)( 5,6)( 8,9)(13,14),
 ( 1,23)( 3,25)( 4,26)( 5,28)( 7,30)( 8,31)(10,33)(12,34)(13,36)(15,38)
  (16,39)(18,40)(20,42)(21,44)(29,46)(37,48)(43,50),
 ( 2,4)( 6,9)(11,13)(15,18),( 1,7)( 2,10)( 3,13)( 4,16)( 5,19)( 6,22),
 ( 1,23)( 3,25)( 4,26)( 6,27)( 7,29)( 8,31)(10,33)(12,34)(13,35)(15,37)
  (17,39)(18,41)(20,42)(22,44)(28,46)(36,47)(43,48),
 ( 1,23)( 3,25)( 5,28)( 6,29)( 7,30)( 9,31)(10,33)(12,36)(13,37)(15,38)
  (17,40)(18,43)(20,44)(22,45)(27,46)(35,47)(42,48),
 ( 1,23)( 3,25)( 5,28)( 7,29)(10,30)(13,32)(15,35)(18,36)(20,37)(26,38)
  (33,39),( 1, 9)( 2,18)( 3,25)( 4,30)( 5,32)( 35,48)( 36,59)
  ( 41,60)( 42,61)( 45,62)( 50,64)( 51,65)( 56,67)( 57,68)( 58,77)
  ( 70,87)( 73,90)( 76,93)( 79,96)( 82,99)( 85,102)( 86,104)( 89,106)
  ( 92,107)( 95,109)( 98,110)(101,112),( 2,3)( 5,6)( 9,10)(12,13)(17,18)
  (23,24)(27,28)(30,31),( 2,3)( 5,6)( 9,10)(12,13)(23,24)(30,31)(33,34)
  (37,38)(42,43)(46,47)(48,49)(51,52)(53,54)(56,57)(58,59)(62,63)(67,68)
  (69,70)(72,73)(74,75)(78,79)(81,82)(83,84)(85,86)(88,89)(90,91),
 ( 1,3)( 4,9)( 7,11)( 8,13)(10,15)(12,17)(14,18)(16,19),
 ( 2,3)( 5,6)( 9,10)(12,13),( 1,3)( 4,9)( 7,10),
 ( 1,9)( 2,17)( 3,22)( 5,25)(10,27)(15,28)(20,30),
 ( 1,3)( 4,9)(10,13)(11,14),( 1,23)( 3,24)( 4,25)( 6,29)( 8,30)( 9,31)
  (11,32)(13,33)(16,35)(18,36)(20,40)(21,41)(26,44)(27,45)(28,46)(34,49)
  (37,52)(38,53)(39,54)(42,55)(43,56)(47,57)(48,58)(50,59)(51,60),
 ( 1,23)( 3,24)( 4,25)( 6,28)( 7,29)( 8,30)(10,31)(11,32)(13,34)(14,35)
  (16,36)(18,50)(22,58)(26,60)(27,61)(33,63)(37,65)(39,71)(42,73)(45,76)
  (49,78)(52,80)(55,82)(57,84)(59,85)(62,86)(64,87)(72,95)(77,97)(81,99),
 ( 1, 9)( 2,16)( 3,25)( 4,31)( 35,53)( 36,57)( 37,59)( 41,61)
  ( 42,62)( 46,64)( 47,65)( 49,66)( 50,68)( 54,70)( 55,72)( 56,81)
  ( 73,91)( 76,93)( 79,96)( 82,98)( 85,101)( 88,103)( 89,104)( 90,106)
  ( 92,107)( 94,108)( 95,110)( 97,111)( 99,112)(100,114)(102,115),
 ( 2,3)( 5,6)(10,11)(12,13)(17,18)(20,21)(26,27)(29,30)(36,37)(42,43)
  (48,49)(50,51)(52,53)(55,56)(58,59)(64,65)(67,68)(69,70)(71,72)(74,75)
  (77,78)(81,82),( 1,3)( 4,8)( 9,12)(13,15)(14,16),
 ( 2,3)( 5,6)(10,11)(13,14)(20,21)(31,32)(34,35)(37,38)(42,43)(45,46)
  (47,48)(50,51)(52,53)(55,56)(57,58)(59,60)(64,65)(67,68)(69,70)(72,73)
  (74,75)(81,82)(83,84)(86,87)(88,89),( 1,2)( 9,11)(17,19)(23,25)(26,27)
  (28,29)(30,31)(32,33)(34,35)(36,37),( 1,23)( 3,24)( 4,25)( 6,26)( 8,30)
  ( 9,31)(11,32)(13,33)(14,34)(16,38)(18,39)(20,40)(21,43)(27,44)(29,45)
  (35,47)(37,48)(42,50)(46,52)(49,53)(51,54),
 ( 1, 9)( 2,15)( 3,36)( 4,39)( 8,44)( 11,45)( 13,46)( 17,49)
  ( 22,54)( 23,55)( 25,56)( 27,57)( 38,73)( 42,75)( 43,77)( 48,79)
  ( 51,81)( 52,82)( 53,85)( 60,89)( 64,92)( 68,97)( 70,100)( 74,106)
  ( 80,108)(111,127)(113,128)(115,129)(117,130)(119,131)(121,132),
 ( 1,6)( 2,8)( 5,11),( 1,2)( 9,10)(11,12)(15,16)(19,20),
 ( 1,2)( 9,10)(11,12)(18,19)(23,24)(26,27),
 ( 1, 9)( 2,15)( 3,21)( 5,34)( 7,38)( 11,42)( 13,45)( 17,46)
  ( 18,50)( 20,52)( 25,57)( 27,58)( 37,83)( 40,84)( 44,85)( 49,86)
  ( 53,87)( 56,88)( 60,95)( 64,97)( 68,99)( 72,101)( 76,103)( 80,105),
 ( 2,4)( 6,8)(11,13)(16,18)(21,23),( 1,7)( 2,9)( 3,12)( 4,14)( 5,17),
 ( 1,23)( 3,24)( 5,27)( 6,29)( 8,30)(10,31)(11,32)(13,36)(14,37)(16,38)
  (17,39)(18,42)(20,44)(22,45)(26,46)(34,47)(41,48),
 ( 1,2)( 9,10)(12,13)(16,17)(23,24)(25,26)(28,29)(30,31)(33,34)(37,38)
  (39,40),( 1,41)( 4,45)( 5,47)( 8,48)(11,49)(13,53)(16,54)(17,56)(20,57)
  (22,60)(25,63)(26,65)(29,66)(32,67)(33,71)(36,72)(38,74)(43,75)(44,77)
  (52,79)(59,81)(62,83)(70,85),( 1,11)( 3,17)( 5,25)( 7,37)( 9,41)(13,45)
  (15,46)(18,49)(23,52)(27,53)(30,55)(32,58)(35,60)(39,62)(43,63)(47,66)
  (56,69)(64,70)(67,71),( 1,9)( 2,15)( 3,19)( 4,24)(10,27)(13,28)(22,31),
 ( 1,3)( 4,6)( 7,9)(10,12)(16,19)(22,24),( 2,9)( 5,11)( 6,13)( 8,15),
 ( 1,11)( 3,16)( 5,21)( 8,28)( 9,48)(12,49)(14,50)(17,51)(19,54)(22,55)
  (25,56)(26,57)(29,60)(36,61)(43,64)(46,67)(52,68)(58,69),
 ( 2,3)( 5,6)(12,13)(15,16)(18,19),( 1,23)( 3,24)( 5,25)( 6,27)( 8,30)
  (10,31)(11,32)(12,33)(14,35)(15,38)(17,39)(18,40)(20,42)(22,45)(28,46)
  (36,47)(43,48),( 2,3)( 5,6)(13,14)(17,18)(28,29)(36,37)(43,44)(46,47)
  (48,49)(50,51)(52,53)(54,55)(57,58)(59,60)(71,72)(74,75)(76,77)(78,79)
  (80,81)(83,84)(85,86)(88,89)(90,91)(92,93)(94,95)(97,98),
 ( 1,3)( 4,6)( 8,9)(10,12)(15,17)(26,28)(29,31),
 ( 2,4)( 6,8)(13,14)(20,22)(24,26)(28,29)(31,33)(35,36),
 ( 2,3)( 5,6)(15,16)(19,20)(22,23)(26,27)(38,39)(44,45)(47,48)(53,54)
  (55,56)(57,58)(63,64)(66,67)(71,72)(73,74)(79,80)(83,84),
 ( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)(10,31)(11,32)(13,33)(15,34)(16,37)
  (18,38)(20,39)(22,43)(27,45)(29,46)(35,48)(40,50)(42,51)(44,52)(47,53)
  (49,54),( 2,3)( 5,6)(16,17)(23,24)(26,27)(31,32)(34,35)(39,40)(41,42)
  (44,45)(46,47)(49,50)(54,55)(56,57)(58,59)(61,62)(63,64)(66,67)(68,69)
  (71,72)(76,77)(78,79)(80,81)(83,84)(85,86),
 ( 1,41)( 5,43)( 7,46)(10,49)(13,51)(17,53)(20,55)(22,57)(25,58)(29,62)
  (31,64)(34,65)(38,69)(42,70)(44,71)(47,72)(50,75)(52,76)(54,78)(56,79)
  (59,80)(63,83)(66,84)(67,86)(73,88)(77,90)(81,91)(85,93)(87,94)(89,95)
  (92,96),( 2,4)( 6,8)(14,15)(20,22)(24,25)(27,29)(32,33)(34,36),
 ( 2,4)( 6,8)(14,15)(20,22)(24,25)(27,29)(32,33)(35,37)(41,43)(45,46)
  (47,48)(49,50),( 1,2)( 9,10)(13,14)(18,19)(25,26)(31,32)(39,40),
 ( 1, 9)( 2,14)( 3,20)( 4,29)( 5,34)( 35,38)( 36,56)( 40,60)
  ( 42,61)( 43,63)( 47,66)( 48,68)( 52,72)( 53,81)( 54,90)( 73,91)
  ( 76,93)( 79,95)( 82,97)( 85,99)( 88,101)( 92,103)( 94,105)( 96,106)
  ( 98,108)(100,109)(102,111),( 2,9)( 5,10)( 7,11)( 8,14)(12,18)(13,19),
 ( 1,3)( 4,6)(19,20)(22,23)(24,25)(27,28)(31,32)(34,35)(37,38)(42,43)
  (47,48)(51,52)(54,55)(58,59)(61,62)(65,66),
 ( 1,3)( 4,6)(20,21)(22,23)(26,27)(29,30)(33,34)(37,38)(41,42)(44,45)
  (47,48)(50,51)(52,53)(55,56)(57,58)(60,61)(64,65)(67,68)(70,71)(75,76)
  (79,80),( 2,3)( 6,9)(15,18)(19,21)(27,30)(31,34)(37,40)(41,43)(44,45)
  (47,48)(51,52)(54,55)(58,59)(61,62),( 1,2)( 9,10)(14,16)(19,21),
 ( 1,6)( 3,10)( 5,16)( 8,18)(14,20),( 1,39)( 4,40)( 5,44)( 8,48)(11,49)
  (14,52)(16,53)(17,55)(20,56)(22,60)(25,64)(26,67)(28,68)(30,70)(33,74)
  (36,75)(41,78)(45,80)(47,82)(50,83)(57,86)(61,88)(63,90)(72,91),
 ( 1,24)( 4,25)( 6,27)( 8,29)(10,30)(14,31)(17,33)(19,35)(22,36)(28,37)
  (34,38),( 1,39)( 5,41)( 7,44)( 10,46)( 13,48)( 15,52)( 20,57)
  ( 22,59)( 25,60)( 29,64)( 30,65)( 34,69)( 36,71)( 40,72)( 42,74)
  ( 45,75)( 47,77)( 49,78)( 50,80)( 58,82)( 61,84)( 66,85)( 67,87)
  ( 70,89)( 76,92)( 79,95)( 81,97)( 86,98)( 88,100)( 96,101)( 99,104),
 ( 1,7)( 2,8)( 4,10)( 6,12),( 1,4)( 5,9)( 7,11),
 ( 1,14)( 2,15)( 4,16)( 5,19)( 7,20)( 8,21)( 9,22)(11,25)(12,26)(17,29)
  (23,32)(27,33)(30,34),( 1,38)( 3,41)( 6,44)( 9,46)( 12,49)
  ( 13,51)( 16,53)( 18,54)( 21,57)( 24,62)( 26,63)( 28,65)( 29,66)
  ( 32,69)( 34,71)( 37,73)( 42,75)( 48,78)( 58,81)( 61,83)( 68,85)
  ( 74,89)( 77,92)( 80,95)( 84,98)( 88,99)( 91,100)( 94,101)( 97,102),
 ( 2,24)( 5,26)( 6,27)(10,32)(13,35)(15,36)(18,37)(20,38)(23,40)(28,41)
  (31,43)(34,44)(39,45)(42,46),( 1,23)( 4,24)( 6,28)( 9,29)(12,30)(13,31)
  (16,35)(18,36)(21,37)(25,38)(32,39),( 1,8)( 2,11)( 5,15)(10,18)(14,20),
 ( 1,6)( 3,9)( 4,11)( 8,23)(12,25),( 1,3)( 4,5)(12,13)(19,20),
 ( 1,2)( 5,6)( 9,10)(18,19)(25,26)(27,28)(32,33)(38,39)(41,42),
 ( 1,23)( 4,24)( 6,26)( 9,29)(11,30)(13,31)(15,32)(18,36)(21,37)(27,38)
  (34,39),( 1,3)( 4,5)(14,15)(21,22),( 2,3)( 6,7)( 8,10)(11,13)(15,17)
  (18,20)(21,22)(23,25)(26,27)(28,30)(31,32)(33,35)(36,38)(40,42)(43,45)
  (46,47)(48,50)(51,52)(53,55),( 1,6)( 3,9)( 7,21)(10,23)(12,25)(15,27)
  (18,29),( 1,23)( 2,27)( 4,28)( 5,29)( 7,30)( 8,33)( 9,35)(11,36)(13,37)
  (14,38)(16,41)(18,43)(19,44)(21,45)(24,46)(31,47)(39,48),
 ( 2,11)( 3,15)( 6,23)( 8,28)( 9,45)(12,46)(16,48)(17,49)(19,50)(21,51)
  (24,54)(26,55)(29,56)(37,62)(42,69)(47,72)(52,74)(58,75)(64,78),
 ( 1,38)( 4,40)( 5,41)( 8,45)(11,49)(14,50)(16,53)(17,54)(20,56)(22,57)
  (25,61)(26,65)(28,68)(30,69)(33,70)(36,73)(42,76)(46,77)(51,79)(58,83)
  (62,84)(64,86)(71,89)(75,92)(82,95),( 1,6)( 3,9)(12,27)(22,30)(28,35)
  (29,44)(31,49)(34,51)(36,53)(39,55)(40,56)(43,58)(45,60)(48,62)(50,63)
  (54,64)(59,65),( 1,38)( 4,39)( 6,42)( 9,46)(10,50)(12,51)(15,53)(18,54)
  (21,55)(22,58)(25,62)(27,66)(30,67)(33,69)(35,72)(37,74)(43,76)(45,77)
  (49,81)(59,83)(61,84)(65,88)(71,90)(79,91)(86,92),
 ( 1,2)( 9,10)(20,21)(25,26)(27,28)(30,31)(34,35)(38,39)(40,41)(42,43)
  (46,47)(49,50)(53,54)(57,58)(59,60)(61,62)(63,64)(65,66)(67,68)(69,70)
  (71,72)(73,74)(75,76)(79,80)(82,83),( 1,6)( 3,8)( 5,10),
 ( 1,6)( 3,8)( 7,21)(10,22)(11,23)(15,24)(25,29)(27,30),
 ( 2,8)( 3,10)( 5,21)( 7,22)(12,25)(14,26)(18,29),
 ( 1,23)( 5,25)( 7,27)(10,29)(12,31)(14,33)(18,35)(20,37)(24,38)(28,39)
  (32,40)(36,41),( 2,8)( 3,10)( 5,13)(11,18)(14,21),
 ( 2,3)( 6,7)( 9,10)(13,14)(17,18)(20,21),
 ( 1,3)( 5,10)(11,17)(13,18)(15,19),( 1,37)( 3,40)( 4,42)( 6,45)( 8,46)
  (10,48)(11,51)(14,53)(16,56)(19,60)(20,61)(23,63)(26,66)(27,67)(31,69)
  (32,72)(35,76)(50,78)(55,81)(57,84)(71,86)(73,89)(83,91)(88,94),
 ( 1,4)( 5,8)(10,13)(15,17)(19,22),( 1,7)( 3,11)( 4,14)( 6,15)( 8,16)
  (10,17)(13,19)(18,21)(20,22),( 1,2)(10,12)(17,19)(20,21)(23,24)(26,27),
 ( 1,9)( 2,12)( 3,17)( 5,19)( 8,25)(15,30)(22,33)(37,42)(40,44),
 ( 1,2)(10,12)(17,18)(24,26)(28,30)(32,33)(35,36)(39,40)(43,44)(48,49)
  (51,52)(55,57)(60,61)(64,65)(68,69)(71,72)(73,74)(75,76)(77,78)(81,82),
 ( 1,2)(10,12)(17,18)(24,26)(28,30)(33,34)(35,36)(39,40)(41,42)(46,47)
  (48,49)(52,53)(57,58)(60,61)(66,67)(68,69),
 ( 1,11)( 2,16)( 3,26)( 5,38)( 7,40)( 9,41)( 12,43)( 13,46)
  ( 15,47)( 17,50)( 19,51)( 21,53)( 22,55)( 27,57)( 37,74)( 48,77)
  ( 49,80)( 58,83)( 59,86)( 76,101)( 82,102),
 ( 1,23)( 2,24)( 4,26)( 6,28)( 7,29)( 9,31)(11,33)(12,35)(14,36)(15,38)
  (17,39)(19,41)(20,43)(22,44)(25,46)(32,47)(40,48),( 1,3)( 4,11)( 5,15),
 ( 1,4)( 2,6)( 3,8)( 9,13)(11,14),( 1,2)(10,11)(12,13)(14,15)(16,17)
  (18,19)(22,23)(26,27),( 1,13)( 2,20)( 3,25)( 4,28)( 5,34)( 6,40)( 8,41)
  (11,43)(14,44)(17,46)(19,47)(21,49)(24,51)(26,52)(29,54)(31,55)(33,56)
  (37,58)(39,60)(42,62)(45,63)(48,65)(50,66)(53,68)(57,69)(59,71)(61,72)
  (64,75)(67,76)(70,78)(73,79)(74,80)(77,82)(81,84)(83,85),
 ( 1,13)( 2,20)( 3,25)( 4,27)( 5,33)( 35,48)( 36,59)( 41,60)
  ( 42,61)( 45,62)( 50,64)( 51,65)( 56,67)( 57,68)( 58,77)( 70,87)
  ( 73,90)( 76,93)( 79,96)( 82,99)( 85,102)( 86,104)( 89,106)( 92,107)
  ( 95,109)( 98,110)(101,112),( 1,11)( 6,28)( 8,34)(13,41)(14,42)(16,43)
  (17,44)(20,47)(24,50)(27,51)(29,52)(31,53)(35,55)(38,58)(40,59)(46,62)
  (48,63)(54,66)(56,67)(61,69)(65,71),( 1,22)( 3,27)( 4,28)( 5,29)( 7,34)
  ( 9,35)(10,36)(12,37)(14,38)(15,43)(17,44)(19,45)(20,46)(23,47)(26,48)
  (30,49)(33,50)(39,51)(42,52),( 2,3)( 6,7)(10,11)(14,15)(25,26)(29,30)
  (34,35)(38,39)(43,44)(46,47)(50,51)(53,54),
 ( 1,37)( 4,39)( 5,42)( 8,45)(11,49)(12,50)(16,54)(17,55)(20,57)(22,60)
  (24,62)(25,65)(27,69)(29,70)(31,73)(32,75)(35,78)(41,80)(44,82)(46,84)
  (59,86)(64,88)(66,90),( 1, 2)( 10,11)( 12,13)( 21,22)( 27,28)
  ( 32,33)( 41,42)( 43,44)( 45,46)( 47,48)( 49,50)( 51,52)( 54,55)
  ( 58,59)( 66,67)( 69,70)( 71,72)( 73,74)( 87,88)( 89,90)( 91,92)
  ( 95,96)(104,105)(113,114)(115,116),( 1,22)( 3,25)( 4,27)( 7,28)( 8,31)
  (10,33)(12,34)(13,36)(14,37)(16,40)(17,42)(19,43)(21,45)(24,46)(26,48)
  (30,49)(32,51)(39,52)(41,54),( 1,22)( 3,25)( 4,26)( 6,27)( 7,28)( 9,31)
  (11,32)(12,33)(14,36)(16,37)(17,40)(19,41)(20,44)(23,45)(29,48)(34,51)
  (38,52)(42,55)(46,56)(49,57)(53,58),( 1,3)( 5,7)( 9,11)(16,17)(18,19),
 ( 1,37)( 5,41)( 7,44)( 11,45)( 12,48)( 14,49)( 17,51)( 18,55)
  ( 19,57)( 21,61)( 24,64)( 26,65)( 29,66)( 32,69)( 34,70)( 38,72)
  ( 39,74)( 47,80)( 52,82)( 54,84)( 58,88)( 59,91)( 68,95)( 75,97)
  ( 76,100)( 85,102)( 86,105),( 2,11)( 4,16)( 6,20)( 8,22)(10,23)(17,25)
  (24,28)(26,30),( 1,37)( 6,42)( 8,46)(12,48)(13,49)(15,53)(17,54)(20,57)
  (22,59)(23,62)(25,66)(28,68)(31,69)(32,70)(35,74)(39,75)(40,76)(41,78)
  (43,79)(50,82)(56,85)(58,86)(61,88)(63,89)(71,92),
 ( 1,7)( 3,10)( 5,21)( 8,23)(13,25)(16,27)(19,29),
 ( 1,22)( 3,24)( 4,25)( 6,26)( 7,29)( 8,31)(10,33)(12,34)(13,35)(15,38)
  (17,40)(20,41)(21,44)(27,47)(28,48)(36,50)(37,51)(42,53)(43,54),
 ( 2,3)( 6,7)(10,11)(14,15)(27,28)(29,30)(34,35)(36,37)(38,39),
 ( 1,22)( 3,24)( 5,25)( 6,27)( 8,30)( 9,31)(10,33)(12,34)(14,36)(15,39)
  (18,40)(19,42)(21,45)(26,46)(28,48)(35,49)(37,51)(41,52)(43,54),
 ( 2,3)( 6,7)(10,11)(14,15)(27,28)(29,30)(35,36)(37,38)(41,42)(45,46)
  (49,50)(52,53),( 1,22)( 3,24)( 6,26)( 9,27)(12,29)(14,32)(17,34)(19,35)
  (23,37)(28,40)(31,42)(36,43)(39,44),( 1,32)( 4,33)( 8,34)( 11,35)
  ( 16,36)( 26,37)( 29,38)( 40,61)( 41,66)( 42,67)( 46,72)( 47,73)
  ( 48,78)( 51,79)( 52,84)( 53,85)( 57,90)( 58,91)( 59,96)( 68,97)
  ( 71,98)( 80,99)( 83,100)( 92,101)( 95,102),
 ( 1,9)( 2,11)( 3,16)( 4,19)( 5,23)( 6,26)( 7,32)( 8,34)(12,39)(14,42)
  (15,44)(17,47)(22,48)(24,51)(27,53)(29,56)(31,59)(35,60)(38,61)(41,62)
  (45,65)(50,66)(55,69)(57,70)(64,71)(68,72),
 ( 1,22)( 3,23)( 4,26)( 6,27)( 7,28)( 9,31)(10,32)(12,33)(13,36)(15,37)
  (16,38)(18,47)(24,59)(25,60)(29,61)(30,62)(34,63)(35,64)(40,68)(43,74)
  (45,76)(49,78)(51,80)(54,82)(57,84)(66,88)(70,91)(72,94),
 ( 1,4)( 6,12)( 7,14)( 8,16)( 9,17)(10,18)(11,19)(13,20)(15,21),
 ( 2,23)( 4,24)( 5,25)( 7,27)( 9,30)(10,31)(12,32)(14,33)(15,35)(16,38)
  (18,39)(19,40)(21,41)(22,45)(29,46)(37,47)(44,48),
 ( 1,22)( 3,23)( 4,24)( 6,27)( 8,30)( 9,31)(11,32)(13,33)(14,38)(16,39)
  (17,40)(19,41)(20,46)(25,47)(29,48)(34,49)(37,50)(42,51)(45,52),
 ( 1,9)( 2,11)( 3,15)( 4,28)(29,45)(30,49)(31,63)(32,67)(35,69)(36,71)
  (41,74)(42,75)(47,78)(48,80)(53,83)(54,84)(59,87)(60,89)(65,92)(66,93),
 ( 1,3)( 5,7)(10,12)(15,17)(20,22),( 1,6)( 5,9)( 7,10),
 ( 2,3)( 6,7)(10,11)(20,21)(26,27)(28,29)(34,35)(39,40)(41,42)(44,45)
  (47,48)(49,50),( 1,22)( 3,23)( 5,26)( 6,27)( 8,30)(10,31)(11,32)(13,35)
  (14,38)(16,39)(18,40)(19,43)(21,46)(24,47)(28,48)(33,49)(36,50)(41,51)
  (44,52),( 1,6)( 5,9)(10,23)(20,33)(26,34)(31,35)(32,43)(36,52)(38,54)
  (42,56)(44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 1,6)( 5,9)(10,18)(15,33)(21,34)(31,42)(32,50)(35,51)(39,53)(41,55)
  (43,57)(47,59)(49,61)(54,63)(58,64)(62,65),
 ( 2,3)( 6,7)(10,11)(21,22)(27,28)(34,35)(41,42)(49,50)(51,52)(53,54)
  (55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 1,31)( 2,32)( 4,34)( 6,36)( 8,37)(11,40)(12,41)(14,42)(18,43)(19,44)
  (20,45)(22,46)(23,49)(25,50)(26,51)(27,52)(29,53)(30,56)(33,57)(35,58)
  (38,59)(39,60)(47,61)(48,62)(54,63)(55,64),
 ( 1,6)( 7,22)(10,24)(12,25)(14,26)(15,27)(17,28)(18,29)(20,30),
 ( 2,23)( 4,24)( 7,25)( 9,27)(12,30)(14,31)(16,32)(18,33)(21,37)(28,38)
  (35,39),( 1,13)( 2,15)( 3,18)( 4,21)( 5,27)( 6,29)( 7,33)( 8,39)( 9,41)
  (10,42)(12,46)(17,47)(19,49)(22,51)(24,52)(26,53)(30,57)(34,58)(36,60)
  (38,62)(44,63)(48,64)(55,65)(59,66),( 2,8)( 4,11)(12,25)(19,32)(23,34)
  (28,39)(30,45)(36,48)(38,50)(40,52)(42,54)(44,56)(46,58)(49,60)(53,62)
  (57,64),( 1, 3)( 5, 7)( 12,13)( 19,21)( 32,34)( 36,38)( 40,41)
  ( 44,45)( 49,51)( 53,55)( 57,58)( 61,62)( 66,68)( 69,71)( 72,74)
  ( 76,78)( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 95,97)( 98,100)
  (101,103),( 1, 3)( 5, 7)( 12,13)( 19,21)( 34,36)( 38,40)( 42,43)
  ( 46,47)( 51,53)( 55,57)( 59,60)( 63,64)( 66,68)( 69,71)( 72,74)
  ( 75,77)( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 94,96)( 98,100)
  (101,103),( 1,6)( 9,22)(10,25)(11,32)(12,35)(14,36)(15,37)(23,38)(24,39)
  (29,40)(30,41),( 1,6)( 9,15)(10,24)(11,28)(12,35)(17,36)(19,37)(25,38)
  (27,39)(31,40)(33,41)(34,48),( 1,22)( 3,23)( 6,25)(10,26)(12,27)(14,30)
  (17,33)(19,34)(24,38)(28,42)(29,43)(35,44)(39,45),
 ( 1,22)( 3,23)( 6,24)( 8,26)(11,29)(15,31)(16,32)(20,35)(25,37)(28,39)
  (34,41)(38,42)(40,43),( 1,3)( 5,7)(13,14)(19,21)(24,25)(28,29)(32,33)
  (36,37)(39,40)(43,44),( 1,22)( 4,27)( 7,28)(10,29)(12,32)(15,35)(17,36)
  (20,37)(24,38)(26,39)(31,40)(34,41),( 1,22)( 4,26)( 6,27)( 8,29)(11,30)
  (13,33)(15,35)(17,36)(20,38)(23,39)(31,40),
 ( 1,3)( 5,7)(13,14)(20,22)(25,26)(28,29)(33,34)(36,37)(38,39),
 ( 1,3)( 5,7)(14,15)(20,21)(24,25)(26,27)(31,32),
 ( 1,3)( 5,7)(15,17)(19,20)(23,24)(26,28)(29,31),
 ( 1,3)( 5,7)(15,17)(19,20)(24,25)(27,28)(29,30),
 ( 1,22)( 4,24)( 6,25)(10,29)(13,30)(15,32)(17,33)(20,37)(23,38)(27,39)
  (31,40)(35,41),( 1,3)( 5,7)(18,20)(21,23)(25,27)(32,33)(40,41)(42,43)
  (45,47)(48,50)(51,53)(54,55)(59,60)(61,62)(64,66)(67,69)(71,73)(75,76),
 ( 1,2)( 3,4)( 6,7)( 8,9)(11,12)(13,14)(16,17)(19,20)(26,27)(28,29)
  (35,36)(37,38)(42,43)(44,45),( 1,7)( 3,9)( 6,10),
 ( 1,3)( 5,7)(18,20)(23,24)(25,27)(28,29)(32,33)(36,37)(38,39)(40,41)
  (42,43),( 2, 3)( 6, 7)( 13,14)( 17,18)( 22,23)( 32,33)( 39,40)
  ( 42,43)( 49,50)( 53,54)( 56,57)( 62,63)( 65,66)( 68,69)( 72,73)
  ( 75,76)( 78,79)( 82,83)( 85,86)( 88,89)( 91,92)( 95,96)( 99,100)
  (103,104),( 1,9)( 2,10)( 4,11)( 5,12)( 6,13)( 7,15),
 ( 2,3)( 6,7)(13,14),( 2,8)( 4,10)( 7,12)( 9,14)(11,16),
 ( 1,21)( 2,28)( 3,37)( 4,41)( 7,43)( 10,45)( 12,47)( 14,51)
  ( 16,52)( 17,55)( 19,56)( 22,58)( 25,60)( 27,64)( 29,65)( 31,68)
  ( 33,69)( 35,71)( 38,73)( 42,76)( 44,77)( 48,80)( 49,81)( 50,84)
  ( 53,85)( 57,86)( 61,89)( 62,90)( 63,93)( 66,94)( 70,95)( 74,96)
  ( 75,99)( 78,100)( 79,103)( 82,104)( 87,105)( 88,108)( 91,109)( 97,110)
  (101,111)(106,112),( 1,21)( 2,26)( 3,37)( 5,38)( 7,41)( 9,44)
  ( 14,47)( 15,48)( 17,51)( 19,52)( 22,53)( 23,56)( 27,58)( 40,74)
  ( 42,75)( 50,80)( 54,82)( 61,87)( 65,93)( 72,98)( 76,103)( 78,104)
  ( 83,106)( 89,120)( 91,121)( 94,123)( 96,124)( 99,125)(101,127)(105,131)
  (107,132),( 1,21)( 2,23)( 3,26)( 4,28)( 6,30)( 7,33)( 8,35)( 9,38)(10,40)
  (11,42)(13,45)(14,47)(15,50)(17,52)(18,54),
 ( 2,23)( 5,24)( 8,27)( 9,28)(12,29)(14,30)(17,34)(19,35)(22,36)(25,38)
  (31,40),( 1,29)( 4,30)( 7,32)( 8,33)(10,34)(11,36)(13,37)(14,38)(17,42)
  (18,43)(19,45)(20,46)(21,47)(22,49)(23,50)(24,52)(25,54)(26,55)(27,56)
  (28,58)(40,59)(41,63)(51,67)(61,69)(62,71)(65,73)(66,75),
 ( 2,4)( 9,10)(16,18)(20,22)(25,26)(31,32)(34,35)(39,40)(42,43)(45,46)
  (47,48)(49,50),( 1,4)( 6,8)(12,15)(17,20)(26,27)(32,33)(41,42),
 ( 1,3)( 5,6)( 8,9)(11,12),( 1,9)( 3,14)( 4,19)( 6,23)(11,51)(13,52)
  (16,53)(18,55)(21,57)(25,58)(27,59)(28,61)(30,63)(36,64)(43,65)(49,66)
  (54,67)(60,68),( 1,28)( 2,31)( 5,32)( 6,34)( 8,35)(10,36)(12,37)(14,39)
  (17,42)(18,44)(19,48)(20,49)(21,50)(22,51)(23,52)(24,54)(25,55)(26,57)
  (27,58)(40,64)(41,67)(43,68)(46,69)(47,70)(59,74)(60,75)(61,76)(62,78)
  (65,79)(66,80)(71,82)(72,84),( 1,7)( 3,8)( 5,11)( 6,12),
 ( 1,21)( 2,22)( 3,23)( 4,25)( 5,26)( 6,27)( 7,29)( 8,31)(17,32)(18,34)
  (19,35)(20,37),( 2,8)( 4,9)( 6,13)( 7,16)(10,18)(14,20),
 ( 2,8)( 4,9)( 6,12)( 7,17)(11,19)(15,21),
 ( 1,10)( 2,14)( 3,22)( 4,25)( 5,32)( 6,37)( 8,41)(11,43)(13,45)(16,47)
  (18,49)(20,51)(23,52)(27,54)(28,56)(30,58)(34,59)(35,60)(38,62)(40,63)
  (42,64)(46,65)(48,66)(50,67)(53,69)(57,70)(61,71)(68,73)(72,74),
 ( 1,9)( 3,14)( 5,19)( 8,27)(11,48)(13,49)(16,50)(18,51)(21,54)(23,55)
  (25,56)(26,57)(30,59)(34,60)(41,63)(45,64)(53,66)(58,68),
 ( 1,3)( 6,11)( 7,12)( 8,13)( 9,14)(10,15)(16,19)(17,20)(18,21),
 ( 1,21)( 4,26)( 7,27)(10,30)(12,33)(15,36)(19,37)(22,39)(25,40)(28,41)
  (31,42)(35,43)(38,44),( 1,5)( 2,16)( 3,21)( 7,24)(10,26)(15,28)(18,30),
 ( 1,20)( 2,25)( 4,36)( 6,39)( 8,42)( 13,45)( 14,46)( 16,49)
  ( 18,50)( 21,51)( 22,54)( 26,56)( 28,58)( 38,74)( 40,75)( 48,80)
  ( 52,82)( 61,87)( 65,93)( 72,98)( 76,103)( 78,104)( 83,106)( 89,120)
  ( 91,121)( 94,123)( 96,124)( 99,125)(101,127)(105,131)(107,132),
 ( 1,3)( 6,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 1,5)( 2,15)( 3,20)( 7,23)(10,25)(17,29)(27,32)(31,33),
 ( 2,3)( 7,9)(13,14)(19,21),( 1,5)( 2,14)( 3,22)( 7,25)(11,26)(18,28)
  (21,29),( 2,3)( 7,9)(14,15)(16,18)(23,24),( 1,3)( 6,9)(11,14),
 ( 1,9)( 3,13)( 5,19)(11,23)(14,24)(18,26)(21,27),
 ( 1,5)( 2,14)( 3,19)( 6,22)(10,24)(11,26)(16,28)(18,30)(21,32)(23,34)
  (27,36),( 1,20)( 2,22)( 3,23)( 4,25)( 5,26)( 6,27)( 7,28)( 8,30)( 9,31)
  (18,33)(19,35),( 1,9)( 3,13)( 6,21)( 7,26)(11,47)(12,50)(16,51)(18,52)
  (20,53)(23,56)(25,57)(28,58)(30,59)(36,64)(43,69)(49,70)(55,71)(61,74)
  (66,75),( 2,10)( 4,13)( 7,17)( 8,20)(12,21)(18,23),
 ( 1,27)( 2,29)( 4,30)( 5,32)( 6,34)( 7,36)( 9,38)(10,40)(11,42)(12,43)
  (13,45)(14,52)(16,54)(20,57)(21,59)(23,62)(24,64)(28,68)(35,69)(41,70),
 ( 2,3)( 7,8)( 9,10)(14,15)(17,18)(23,24)(26,27)(33,34)(39,40)(42,43)
  (46,47)(48,49)(50,51)(52,53)(55,56)(57,58)(63,64)(66,67)(68,69)(75,76)
  (77,78)(85,86)(90,91)(93,94),( 1,20)( 2,22)( 4,24)( 5,27)( 6,29)( 8,32)
  ( 9,34)(10,36)(11,39)(12,41)(13,44)(15,46)(16,48)(17,51)(18,53),
 ( 1,9)( 3,12)( 4,15)( 6,18)(14,22)(20,23),
 ( 2,3)( 7,8)(10,11)(12,13)(28,29)(30,31)(32,33)(34,35)(60,61)(62,63)
  (64,65),( 1,5)( 2,13)( 3,18)( 7,25)(12,27)(17,28)(23,30),
 ( 1,20)( 2,21)( 3,24)( 4,25)( 5,26)( 6,27)( 7,29)( 8,31)( 9,32)(18,33)
  (19,34),( 1,3)( 6,8)(11,13)(15,17)(20,21),
 ( 1,20)( 2,21)( 3,23)( 4,25)( 5,26)( 6,27)( 7,28)( 8,31)( 9,32)(18,33)
  (19,34),( 2,3)( 7,8)(10,11)(14,15)(17,18)(19,20),
 ( 2,3)( 7,8)(10,11)(14,15)(17,18)(28,29)(35,36)(37,38)(42,43)(46,47)
  (48,49)(51,52)(53,54)(56,57)(58,59)(61,62)(66,67)(68,69)(71,72)(74,75)
  (76,77)(81,82)(83,84)(87,88)(89,90),( 1,2)(11,12)(15,16)(25,26)(29,30)
  (32,33)(34,35)(37,38)(43,44)(47,48)(49,50)(53,54)(55,56)(62,63)(64,65)
  (68,69)(70,71),( 1,2)(11,12)(15,16)(25,26)(29,30)(32,33)(35,36)(39,40)
  (41,42)(45,46)(50,51)(52,53)(56,57)(58,59)(70,71)(72,73)(74,75),
 ( 1,20)( 2,21)( 3,22)( 4,24)( 5,26)( 6,28)( 7,30)( 8,32)(16,34)(17,35)
  (18,36)(19,37),( 1,3)( 6,8)(11,13)(17,19)(25,26)(32,34)(36,38)(40,41)
  (45,46)(48,49)(51,52)(53,54),( 1, 7)( 5,26)( 9,35)( 11,36)
  ( 13,37)( 14,38)( 15,42)( 18,43)( 21,46)( 23,47)( 24,48)( 25,51)
  ( 34,69)( 40,72)( 41,73)( 45,75)( 50,77)( 54,79)( 58,86)( 60,91)
  ( 63,94)( 67,99)( 71,100)( 74,102)( 78,104)(101,120)(103,121)(105,122)
  (107,123)(109,126)(111,127)(113,128)(124,133)(134,138)(136,139),
 ( 1,20)( 2,21)( 3,22)( 4,24)( 5,25)( 6,27)( 7,28)( 8,29)( 9,30)(18,33)
  (19,35),( 1,3)( 6,8)(11,13)(18,20)(26,27)(34,35)(39,40),
 ( 1,3)( 6,8)(11,13)(18,20)(27,28)(35,36)(39,40),
 ( 1,9)( 3,12)( 6,18)(11,22)(15,24)(19,25)(21,27),
 ( 1,3)( 6,8)(11,13)(18,19)(25,27)(29,31)(33,35)(40,41)(43,44)(46,47)
  (50,51),( 1,26)( 4,27)( 8,28)( 16,29)( 19,30)( 23,31)( 33,66)
  ( 36,71)( 38,72)( 41,75)( 44,78)( 45,79)( 48,84)( 50,85)( 53,90)
  ( 55,91)( 58,94)( 61,97)( 62,98)( 65,103)( 70,104)( 73,105)( 83,106)
  ( 86,107)( 96,108)( 99,109),( 1,10)( 2,12)( 3,16)( 4,30)( 5,34)
  ( 36,43)( 37,57)( 41,60)( 42,61)( 46,64)( 49,66)( 50,67)( 54,71)
  ( 55,77)( 56,83)( 72,85)( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)
  ( 86,103)( 89,104)( 92,106)( 95,107)( 98,109)(101,110),
 ( 1,4)( 8,10)(12,14)(18,21)(22,24)(28,29)(30,32)(36,37)(42,43)(46,48)
  (50,52)(53,55),( 1,2)(11,12)(22,23)(28,29)(31,32)(37,38)(40,41)(43,44)
  (45,46)(49,50)(51,52)(55,56)(57,58)(61,62)(63,64)(65,66)(67,69)(72,73)
  (74,75)(76,77)(80,81)(84,85)(87,88),( 1,4)( 8,10)(12,14)(18,21)(23,25)
  (29,31)(35,36)(37,39)(43,44)(46,47)(49,50)(53,54),
 ( 1,2)(11,12)(22,23)(28,29)(32,33)(36,37)(39,40)(42,43)(45,46)(48,49)
  (50,51)(54,55)(56,57)(59,60)(62,63)(64,65)(67,68)(73,74)(76,77),
 ( 1,2)( 3,4)( 5,6)( 7,8)(11,12)(18,19),
 ( 1,22)( 2,23)( 4,24)( 6,27)( 7,28)( 9,31)(11,32)(12,33)(13,36)(14,37)
  (15,40)(17,41)(19,42)(20,45)(21,46),( 2,18)( 3,24)( 5,33)( 8,42)(10,43)
  (14,45)(19,47)(22,50)(25,51)(27,52)(29,53)(34,55)(37,58)(39,62)(41,63)
  (46,65)(56,68)(59,70)(66,71)(69,72),( 2,8)(11,18)(12,21)(14,30)(15,33)
  (16,41)(23,42)(24,44)(31,45)(32,47)(39,48),
 ( 1,4)( 2,11)( 3,17)( 5,22)(10,24)(12,26)(15,28)(18,30)(21,32)(23,34)
  (27,36),( 1,10)( 2,12)( 4,17)(13,22)(15,24)(21,26)(23,27)(25,28),
 ( 1,4)( 8,9)(11,12),( 1,19)( 2,22)( 3,25)( 4,27)( 5,29)( 6,31)( 7,34)
  ( 8,37)(10,39)(11,41)(12,43)(14,46)(15,49)(16,51)(18,53),
 ( 1,5)( 2,10)( 3,23)( 4,27)(29,37)(30,41)(31,55)(32,59)(33,70)(38,73)
  (39,74)(44,77)(45,79)(50,82)(51,83)(56,86)(57,88)(62,91)(63,92)(68,95),
 ( 1, 6)( 2,28)( 5,47)( 9,49)( 14,50)( 19,53)( 21,54)( 24,55)
  ( 27,57)( 31,60)( 33,64)( 37,66)( 39,70)( 42,72)( 44,76)( 48,78)
  ( 51,81)( 58,85)( 59,90)( 61,91)( 63,93)( 65,95)( 67,96)( 69,98)
  ( 71,100)( 73,101)( 75,103)( 80,104)( 84,105),
 ( 1,9)( 3,11)( 5,15)( 6,16)(14,22)(19,24),
 ( 2,3)( 7,8)(12,13)(14,15)(20,21),( 1,3)( 6,8)(17,18)(20,21)(22,23)
  (27,28)(29,30),( 1,2)(12,13)(15,16)(18,20)(22,24)(30,32)(34,36)(38,39)
  (43,44)(46,47)(49,51)(54,55)(58,60)(63,64)(66,67),
 ( 1,9)( 3,11)( 5,13)( 7,16)(18,24)(20,29),
 ( 1,5)( 2,10)( 3,17)( 4,33)(35,44)(36,47)(37,59)(38,62)(40,69)(41,71)
  (45,72)(46,73)(50,75)(51,77)(55,78)(56,79)(60,81)(61,83)(65,84)(66,85),
 ( 1,9)( 3,11)( 5,13)(12,16)(15,17),( 1,19)( 2,20)( 3,22)( 4,23)( 5,25)
  ( 6,26)( 7,27)( 8,29)( 9,30)(10,32),( 1, 2)( 12,13)( 15,16)( 18,19)
  ( 32,33)( 37,38)( 40,41)( 43,44)( 48,49)( 50,51)( 52,53)( 55,56)
  ( 58,59)( 60,61)( 63,64)( 66,67)( 69,70)( 71,72)( 74,75)( 77,78)
  ( 81,82)( 84,85)( 86,87)( 89,90)( 91,92)( 98,99)(102,103),
 ( 1,5)( 2,10)( 3,16)( 6,21)( 9,24)(13,25)(14,28)(18,29)(19,32),
 ( 1,19)( 3,22)( 4,24)( 5,27)( 6,29)( 7,31)( 8,34)(10,36)(11,39)(12,41)
  (13,43)(14,46)(15,48)(17,51)(18,53),( 2,10)( 5,13)( 7,14)( 9,16)(18,21)
  (19,27),( 1,5)( 2,10)( 3,14)( 6,24)(11,25),
 ( 1,19)( 4,21)( 7,22)(10,24)(13,25)(16,27),
 ( 1, 6)( 2,16)( 3,25)( 4,28)( 5,34)( 7,36)( 9,38)( 11,39)
  ( 13,40)( 15,41)( 18,46)( 21,48)( 22,50)( 24,53)( 26,55)( 31,57)
  ( 33,59)( 37,62)( 42,64)( 44,66)( 45,67)( 47,68)( 49,74)( 52,76)
  ( 54,78)( 56,79)( 58,80)( 61,84)( 63,86)( 65,87)( 69,88)( 71,90)
  ( 73,91)( 75,93)( 77,94)( 81,95)( 83,97)( 85,98)( 89,99)( 92,100)
  ( 96,101),( 1,18)( 2,28)( 3,37)( 4,38)( 5,40)( 7,41)( 9,43)
  ( 10,44)( 12,47)( 13,49)( 15,51)( 17,52)( 19,54)( 21,56)( 23,57)
  ( 45,79)( 48,81)( 50,82)( 59,86)( 60,87)( 80,104)( 85,106),
 ( 1,3)( 7,11)(10,14)(12,15)(13,16),( 1,10)( 3,17)( 6,30)( 7,34)
  ( 11,37)( 13,38)( 15,39)( 18,43)( 20,46)( 21,48)( 28,51)( 31,55)
  ( 40,63)( 44,66)( 47,68)( 50,71)( 52,74)( 53,75)( 57,80)( 60,82)
  ( 72,90)( 76,93)( 81,96)( 83,98)( 87,100)(101,110)(103,112)(106,115)
  (113,120)(116,123),( 1,9)( 3,10)( 4,13)(15,20)(17,21)(19,22),
 ( 1,18)( 3,19)( 5,20)( 7,21)( 9,22)(10,25)(13,26)(16,27)(23,44)(28,45)
  (32,47)(48,60)(51,61)(53,62)(56,64)(58,65),
 ( 2,5)( 7,10)(14,16)(18,21)(25,26)(34,35)(40,41),
 ( 2,3)( 7,8)(12,13)(17,18)(28,29)(36,37)(41,42),
 ( 1,9)( 3,10)( 4,11)( 6,13)( 8,14)(12,16)(15,17),
 ( 1,10)( 3,15)( 5,20)( 8,27)(11,45)(13,46)(16,47)(18,50)(21,51)(24,52)
  (25,53)(28,56)(30,57)(38,65)(43,68)(48,72)(54,73)(59,74)(76,79)(78,80),
 ( 1,18)( 4,23)( 7,28)(10,32)(13,37)(17,39)(20,40)(22,41)(25,43)(27,45)
  (30,46)(34,47)(36,49)(38,51)(42,52)(48,53),
 ( 1,18)( 4,20)( 5,24)( 8,28)(10,30)(11,32)(13,38)(16,40)(21,42)(26,44)
  (33,46)(36,48),( 1,18)( 4,20)( 6,26)( 7,28)( 9,30)(12,34)(13,38)(16,40)
  (21,42)(24,44)(31,46)(36,48),( 2,3)( 7,8)(12,13)(19,20)(27,28)(39,40)
  (43,44)(47,48)(50,51),( 1,18)( 4,19)( 7,20)( 11,22)( 21,38)
  ( 24,41)( 25,43)( 26,44)( 28,46)( 29,49)( 30,50)( 31,51)( 32,53)
  ( 35,54)( 36,56)( 37,57)( 39,66)( 45,67)( 47,68)( 52,69)( 58,70)
  ( 59,72)( 61,76)( 63,80)( 64,81)( 71,88)( 73,89)( 75,90)( 77,91)
  ( 79,92)( 82,93)( 84,94)( 85,95)( 86,97)( 87,99)( 96,101)( 98,102)
  (100,103),( 2,3)( 7,8)(12,13)(20,21)(26,27)(34,35)(41,42),
 ( 1,3)( 7,8)(13,15)(19,21)(23,24)(26,27)(29,30),
 ( 1,9)( 4,22)( 5,29)( 7,38)(12,45)(15,48)(18,49)(21,50)(25,51)(28,52)
  (31,54)(33,56)(37,57)(41,58)(44,59)(46,60)(53,61),
 ( 2,3)( 7,8)(12,13)(22,23)(25,26)(29,30)(31,32),
 ( 1,3)( 8,20)( 9,23)(12,32)(13,35)(21,42)(22,43)(29,46)(30,47)(37,50)
  (38,51),( 1,24)( 3,26)( 5,28)( 9,29)(12,30)(14,32)(17,34)(19,35)(22,36)
  (27,37)(33,38),( 1,10)( 3,13)( 5,15)( 6,17)( 8,19)(11,20)(14,21)(18,22),
 ( 1,9)( 4,17)( 5,21)( 7,25)(11,46)(14,47)(16,50)(19,51)(20,52)(24,53)
  (27,56)(29,57)(32,59)(37,64)(41,66)(49,70)(55,71)(58,78)(63,79)(65,80),
 ( 1,4)(10,12)(13,15)(17,19)(20,22),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)
  (14,15)(17,18)(20,21)(26,27)(28,29)(35,36)(37,38)(42,43)(47,48)(51,52)
  (54,55),( 2,17)( 8,18)(11,19)(14,21)(20,40)(22,41)(23,43)(24,44)(27,46)
  (28,47)(29,49)(32,51)(33,53)(34,55)(37,57)(38,58)(42,66)(48,68)(52,70)
  (54,72)(59,74)(60,76)(61,78)(62,80)(63,82)(64,84)(69,85)(73,87)(75,88)
  (77,90)(79,91)(81,93)(83,94)(86,95)(89,96)(92,97),
 ( 1,10)( 3,13)( 6,16)( 8,19)(12,22)(17,24),
 ( 2,7)( 4,14)( 6,19)( 8,22)(11,23)(16,25)(18,26),
 ( 1,17)( 2,19)( 3,20)( 5,21)( 7,23)( 8,24)(10,26)(12,27)(13,28)(15,30),
 ( 1,2)(14,15)(18,19)(23,24)(25,26)(28,29)(30,31)(33,34)(35,36)(39,40)
  (42,43)(45,46)(48,49)(51,52)(53,54)(57,58)(65,66)(69,70)(71,72),
 ( 1,24)( 3,25)( 4,27)( 6,29)( 8,30)( 9,32)(11,33)(12,35)(14,37)(16,39)
  (17,40)(19,42)(21,44)(22,45)(28,46)(36,47)(43,48),
 ( 1, 6)( 2,12)( 3,15)( 4,19)( 5,26)( 32,40)( 33,56)( 38,58)
  ( 39,60)( 44,62)( 47,66)( 48,67)( 53,70)( 54,78)( 55,87)( 71,89)
  ( 74,92)( 77,95)( 80,98)( 83,101)( 86,104)( 91,109)( 94,111)( 97,115)
  (100,117)(103,121)(106,123),( 1,17)( 2,18)( 4,19)( 7,22)( 9,23)(10,24)
  (12,25)(15,28)(21,40)(27,41)(31,43)(45,59)(48,60)(53,63)(56,64),
 ( 1,17)( 2,18)( 5,20)( 7,21)( 9,22)(10,23)(13,25)(15,26)(19,38)(24,40)
  (30,47)(45,61)(53,64)(56,67)(59,75)(69,80)(73,83),
 ( 1, 2)( 4, 5)( 7, 8)( 9,10)( 11,12)( 13,14)( 16,17)( 20,21)
  ( 23,24)( 25,26)( 28,29)( 30,31)( 41,42)( 43,44)( 46,47)( 49,50)
  ( 52,53)( 54,55)( 57,58)( 59,60)( 62,63)( 66,67)( 68,69)( 72,73)
  ( 74,75)( 78,79)( 81,82)( 84,85)( 87,88)( 92,93)( 95,96)( 98,99)
  (101,102)(104,105)(107,108)(109,110)(112,113)(115,116)(118,119)(121,122)
  (124,125),( 1,17)( 3,19)( 4,21)( 6,22)( 9,23)(11,25)(12,27)(14,28)(20,40)
  (26,41)(33,54)(38,61)(45,62)(55,64),( 1,7)( 2,13)( 3,19)( 4,22)( 5,27)
  ( 6,34)( 8,41)(10,43)(14,45)(16,46)(18,47)(21,49)(23,50)(26,52)(28,54)
  (30,55)(33,57)(36,58)(39,60)(42,61)(44,63)(48,64)(51,66)(53,67)(56,69)
  (59,70)(62,72)(65,74)(68,75)(71,78)(73,80)(76,82)(77,83)(79,84)(81,85),
 ( 1,6)( 2,11)( 3,23)( 9,25)(12,27)(18,28)(21,30),
 ( 1,7)( 2,13)( 3,17)( 4,22)( 9,26)(12,28)(21,32),
 ( 1,6)( 2,11)( 3,22)( 9,25)(12,27)(17,29)(20,31),
 ( 1, 3)( 8,10)( 16,17)( 22,24)( 35,36)( 39,40)( 42,44)( 46,48)
  ( 52,53)( 56,57)( 59,61)( 63,65)( 66,68)( 69,71)( 72,74)( 76,78)
  ( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 95,97)( 98,100)(101,103),
 ( 2,3)( 7,8)(15,16)(24,25)(28,29)(33,34)(36,37)(41,42)(44,45),
 ( 1, 6)( 2,11)( 3,20)( 4,26)( 5,31)( 35,50)( 36,55)( 40,59)
  ( 41,61)( 45,64)( 46,66)( 48,67)( 52,71)( 53,73)( 54,82)( 75,92)
  ( 78,94)( 81,96)( 84,98)( 87,100)( 90,102)( 91,103)( 93,105)( 95,106)
  ( 97,108)( 99,109)(101,111),( 1,3)( 8,9)(10,11)(13,14)(15,16)(18,19)
  (21,22)(23,24)(25,26),( 2,3)( 8,10)(11,13)(18,19)(20,23),
 ( 2,3)( 8,10)(12,14)(16,18)(23,25)(27,29)(31,33)(36,38)(40,42)(44,46),
 ( 2,45)( 4,47)( 6,49)( 8,50)(10,52)(12,53)(15,55)(17,56)(19,58)(21,60)
  (24,62)(26,64)(28,66)(30,67)(33,69)(35,70)(37,72)(39,73)(41,75)(43,77),
 ( 1,17)( 3,18)( 5,21)( 6,22)( 9,23)(11,24)(13,27)(14,28)(20,40)(26,41)
  (31,46)(38,55)(47,62)(53,64),( 1,9)( 4,12)( 6,15)(11,16)(14,17),
 ( 1,3)( 8,9)(12,13),( 1,17)( 3,18)( 5,21)( 7,22)( 8,23)(11,24)(14,26)
  (15,27)(20,45)(32,49)(37,51)(42,54)(48,61)(50,62)(53,63),
 ( 1,3)( 8,9)(14,16)(18,20)(21,23)(34,36)(40,41)(43,45)(47,49)(50,52)
  (54,55)(56,57)(61,62)(63,65)(66,68)(69,71)(73,74)(75,76),
 ( 2,3)( 8,9)(10,11)(12,13)(17,18)(19,20),
 ( 1,17)( 3,18)( 5,20)( 7,21)( 9,22)(11,23)(13,25)(15,26)(19,39)(24,41)
  (28,44)(31,51)(49,64)(58,69),( 1,5)( 2,8)( 4,11)( 6,23)(10,25),
 ( 1,17)( 3,18)( 6,21)( 8,22)( 9,23)(11,24)(14,27)(16,28)(19,40)(25,41)
  (38,59)(45,62)(48,63)(54,65)(57,66),( 1,2)( 4,5)( 7,8)(10,11)(15,16)
  (21,22),( 1,10)( 3,11)( 5,13)( 8,16)(18,25)(19,31),
 ( 2,4)( 3,10)( 5,11),( 2,15)( 9,18)(11,21)(19,41)(22,42)(24,45)(25,47)
  (26,48)(27,50)(29,52)(31,54)(32,56)(33,57)(34,59)(36,61)(38,63)(39,65)
  (43,75)(44,77)(49,78)(51,80)(53,81)(58,82)(60,84)(62,85)(66,86)(67,87)
  (69,89)(70,90)(72,92)(73,93)(88,95)(91,96)(94,97),
 ( 1,3)( 8,9)(15,17)(19,21)(23,24)(27,28)(30,31)(34,35)(38,39)(42,43),
 ( 2,3)( 8,9)(12,13)(16,17)(19,20)(21,22)(24,25)(28,29)(30,31),
 ( 2,9)( 3,10)( 5,11)( 6,13)( 8,14)(12,16)(15,17),
 ( 1,6)( 2,11)( 3,14)( 4,21)( 8,24)(10,25)(15,28)(20,30)(23,31)(27,33)
  (29,35),( 1,3)( 8,9)(15,17)(19,21)(24,26)(30,32)(34,35)(38,40)(42,43)
  (45,46)(47,48)(49,50),( 1,3)( 8,9)(15,17)(19,21)(24,25)(28,29)(31,32)
  (35,36)(39,40)(43,44),( 1,17)( 4,19)( 5,20)( 7,21)( 9,22)(11,25)(13,26)
  (14,27)(18,44)(23,46)(30,48)(37,52)(41,53),
 ( 1,17)( 4,19)( 5,20)( 7,21)( 9,22)(12,24)(13,25)(15,26)(18,40)(23,42)
  (29,45)(37,56)(47,65)(53,68),( 1,17)( 4,19)( 5,20)( 7,21)( 9,22)(12,24)
  (13,25)(15,26)(18,39)(23,41)(30,44)(34,51)(48,64)(55,68),
 ( 2,7)( 4,8)( 6,9)(10,20)(16,25)(21,26)(23,27),
 ( 1,3)( 9,15)(10,16)(11,17)(13,19)(18,21)(20,22),
 ( 2,3)( 8,9)(14,15)(17,18)(23,24),( 1,9)( 5,11)( 6,13)( 7,15)( 8,17)
  (10,18)(12,19)(14,21)(16,23)(20,25)(22,26)(24,27),
 ( 2,3)( 5,8)(12,15)(16,19)(23,26),( 1,17)( 4,18)( 5,19)( 7,22)( 9,23)
  (12,24)(13,25)(15,28)(20,41)(26,42)(32,48)(36,52)(44,61)(51,63),
 ( 1,5)( 2,7)( 3,8)(11,14)(12,15)(13,16),
 ( 2,38)( 3,42)( 7,47)( 9,48)(14,52)(16,53)(19,55)(20,59)(23,62)(26,65)
  (28,66)(29,70)(31,71)(34,74)(36,75)(41,77)(43,78)(44,81)(45,82)(58,84)
  (60,85)(61,88)(63,89)(69,91)(80,93)(87,95),
 ( 1,23)( 2,26)( 4,27)( 5,28)( 7,31)( 8,32)(10,33)(11,36)(13,37)(14,38)
  (15,39)(19,46)(21,55)(24,60)(25,61)(29,62)(30,63)(34,64)(35,65)(42,73)
  (45,74)(48,77)(51,78)(53,81)(58,82),( 1,17)( 4,18)( 6,19)( 7,21)(10,23)
  (11,24)(14,25)(15,26)(22,40)(29,43)(33,47)(41,59)(45,61)(46,62)(56,66)
  (60,71)(65,72),( 1,5)( 2,7)( 4,10)( 8,22)(12,24),
 ( 2, 3)( 8, 9)( 20,21)( 25,26)( 27,29)( 30,31)( 40,42)( 45,47)
  ( 48,50)( 52,54)( 57,59)( 61,62)( 65,67)( 68,69)( 70,72)( 73,74)
  ( 76,77)( 78,79)( 81,82)( 83,84)( 85,86)( 87,89)( 90,91)( 92,93)
  ( 94,96)( 97,98)(102,103)(106,107)(111,112)(116,117)(119,120)(125,126)
  (127,128),( 1,17)( 8,19)( 11,20)( 22,37)( 23,39)( 24,40)( 25,41)
  ( 26,43)( 27,44)( 28,46)( 29,48)( 30,50)( 31,51)( 32,53)( 33,54)
  ( 34,57)( 35,58)( 36,60)( 47,68)( 49,69)( 56,70)( 61,72)( 62,73)
  ( 63,77)( 64,78)( 65,80)( 66,84)( 67,85)( 71,91)( 74,92)( 75,93)
  ( 76,94)( 79,95)( 81,96)( 82,97)( 83,98)( 86,99)( 87,100)( 88,101)
  ( 89,103)( 90,105)(102,107)(104,108)(106,109),
 ( 2,3)( 9,12)(13,14)(19,21)(22,24),( 1,16)( 2,23)( 5,40)( 8,41)
  ( 10,42)( 19,43)( 22,44)( 26,45)( 28,46)( 32,54)( 35,62)( 37,63)
  ( 47,93)( 48,94)( 50,97)( 51,98)( 53,101)( 55,103)( 56,104)( 58,107)
  ( 59,108)( 61,111)( 64,113)( 65,114)( 67,117)( 68,118)( 70,121)( 72,123)
  ( 74,125)( 76,128)( 80,131)( 84,132)( 88,133)( 95,135)( 99,137)(105,139)
  (109,141)(115,143)(119,145)(126,146)(130,147),
 ( 2,38)( 5,40)( 6,42)( 8,45)(10,46)(13,47)(16,51)(18,55)(21,58)(22,59)
  (25,61)(28,65)(31,66)(33,70)(34,74)(37,77)(43,79)(48,80)(52,81)(54,83)
  (63,85)(67,86)(71,87)(73,89),( 1,5)( 2,7)( 6,11)( 8,13)(10,14),
 ( 1,5)( 2,7)( 8,21)(10,22)(14,23)(20,28)(25,29)(27,30),
 ( 1,16)( 2,19)( 3,28)( 4,33)( 9,38)(10,40)(11,41)(12,43)(13,44)(15,46)
  (18,48)(20,50)(23,52)(24,53)(27,55)(29,57)(32,59)(39,63)(42,65)(45,67)
  (47,68)(51,69)(54,70)(58,71)(64,72)(66,73),
 ( 1,8)( 2,20)( 3,24)( 6,25)( 9,27)(15,28)(18,30),
 ( 2,37)( 4,40)( 5,42)( 7,45)( 9,46)(11,48)(12,51)(15,53)(17,56)(20,60)
  (21,61)(24,63)(27,66)(28,67)(32,69)(33,72)(36,76)(50,78)(55,81)(57,84)
  (71,86)(73,89)(83,91)(88,94),( 1,16)( 2,18)( 3,20)( 4,21)( 5,23)( 6,25)
  ( 7,26)( 8,28)( 9,30)(10,31)(11,32)(12,34)(13,35)(14,37)(15,38),
 ( 1,8)( 2,18)( 3,20)( 4,26)( 5,30)( 6,33)( 7,35)( 9,40)(11,41)(12,43)
  (14,45)(17,46)(21,50)(23,51)(25,53)(27,54)(29,56)(31,58)(36,59)(38,63)
  (39,64)(44,66)(48,67)(57,68)(61,69),( 1,6)( 2,10)( 3,12)( 4,24)( 9,25),
 ( 1,3)( 9,10)(12,13)(14,15)(17,18)(19,20)(22,23),
 ( 1,3)( 9,10)(13,15)(18,20)(24,26)(36,38)(44,46)(47,49)(51,53),
 ( 1,5)( 2,6)( 7,11)( 8,13)(12,15)(14,16),
 ( 1, 8)( 2,17)( 3,20)( 4,24)( 5,30)( 6,35)( 10,38)( 11,39)
  ( 15,42)( 19,46)( 21,47)( 25,51)( 27,52)( 28,54)( 32,55)( 36,57)
  ( 37,58)( 40,60)( 41,62)( 44,65)( 45,67)( 48,71)( 49,72)( 50,74)
  ( 53,76)( 56,78)( 59,80)( 61,82)( 63,83)( 64,84)( 66,86)( 69,89)
  ( 70,91)( 73,95)( 75,96)( 77,98)( 79,100)( 81,101)( 85,102)( 87,103)
  ( 88,104)( 90,106)( 93,109)( 94,111)( 97,114)( 99,115)(105,118)(107,119)
  (108,120)(110,122)(113,125)(117,129)(121,131)(123,132)(124,133)(126,135)
  (127,136)(128,137)(130,139)(134,140)(138,141),
 ( 2,8)( 9,15)(10,17)(11,18)(12,19)(13,21)(14,22),
 ( 1,9)( 3,12)( 6,14)(10,16)(13,18),( 1,8)( 2,16)( 3,21)( 4,25)( 9,27)
  (14,28)(19,30),( 1,15)( 2,29)( 3,37)( 4,41)( 6,43)( 8,45)(10,47)(11,48)
  (14,53)(17,54)(19,56)(20,58)(23,60)(25,61)(28,64)(30,66)(32,68)(34,70)
  (36,71)(39,76)(42,77)(46,78)(49,81)(51,82)(55,83)(59,84)(62,87)(65,88)
  (69,89)(72,92)(74,93)(79,94)(85,95)(90,96),
 ( 2,3)( 9,10)(11,12)(14,15)(17,18)(19,20),
 ( 1,15)( 2,25)( 3,36)( 4,39)( 5,41)( 6,42)( 8,44)(10,46)(12,47)(13,48)
  (17,50)(18,53)(20,54)(22,55)(24,56)(26,58)(28,59)(32,60)(33,62)(35,65)
  (37,66)(43,67)(45,68)(49,70)(51,71)(52,72)(57,73)(61,75)(63,76)(64,77)
  (69,78)(74,79),( 2,7)( 5,8)( 9,13)(11,14)(15,19)(16,20)(17,21)(18,22),
 ( 2,3)( 9,10)(13,14)(17,18)(21,22)(33,34)(36,37)(40,41)(42,43)(46,47)
  (51,52)(53,54)(58,59)(62,63)(65,66)(67,68)(69,70),
 ( 2,3)( 9,10)(13,14)(17,18)(27,28)(32,33)(38,39)(41,42)(43,44)(47,48)
  (49,50)(53,54)(55,56)(59,60)(61,62)(67,68)(75,76)(77,78),
 ( 2,3)( 9,10)(13,14)(17,18)(27,28)(33,34)(36,37)(40,41)(42,43)(46,47)
  (50,51)(52,53)(56,57)(58,59)(70,71)(72,73)(74,75),
 ( 1,23)( 3,27)( 5,28)( 8,30)(10,31)(12,32)(13,33)(15,34)(17,38)(18,39)
  (20,40)(22,41)(24,42)(25,43)(26,44)(29,47)(35,50)(36,51)(37,52)(45,55)
  (46,56)(48,57)(49,58)(53,59)(54,60),( 1,15)( 2,24)( 3,29)( 4,33)( 9,39)
  (10,41)(11,42)(12,44)(14,45)(16,46)(19,48)(20,49)(23,51)(25,52)(28,54)
  (30,55)(32,57)(40,62)(43,64)(47,66)(50,67)(53,68)(56,69)(58,70)(63,71)
  (65,72),( 1,15)( 2,23)( 3,26)( 4,36)( 6,37)( 9,40)( 10,41)
  ( 17,47)( 19,50)( 21,51)( 24,52)( 27,57)( 38,84)( 42,85)( 44,87)
  ( 48,88)( 53,89)( 55,91)( 62,98)( 66,100)( 70,101)( 74,102)( 78,104)
  ( 82,105),( 1,15)( 2,22)( 3,27)( 5,35)( 7,36)( 9,40)( 11,42)
  ( 14,47)( 17,48)( 20,51)( 21,53)( 34,81)( 39,82)( 43,83)( 46,85)
  ( 50,86)( 54,87)( 60,96)( 64,98)( 68,100)( 72,102)( 76,104)( 80,106)
  ( 95,113)( 97,114)( 99,115)(101,116)(103,117)(105,118),
 ( 1,2)( 8,9)(13,14)(18,19)(24,25)(30,31),
 ( 1,8)( 2,15)( 3,19)( 4,28)( 5,31)( 6,38)( 9,41)(11,42)(13,44)(16,45)
  (18,47)(21,48)(23,49)(26,51)(30,53)(32,54)(34,56)(35,58)(40,60)(43,61)
  (46,63)(50,64)(52,65)(55,68)(57,69)(59,70)(62,73)(66,75)(67,76)(71,78)
  (72,79)(74,81)(77,83)(80,84)(82,85),( 1,3)(10,12)(15,16)(18,19)(20,21)
  (23,24),( 2,3)( 9,10)(14,16)(17,18)(21,23)(27,29)(32,33)(35,36),
 ( 1,3)(10,11)(12,13)(14,15)(16,17)(18,19)(23,25)(27,29),
 ( 1,15)( 2,21)( 4,30)( 7,42)(11,44)(16,46)(19,49)(22,50)(24,51)(26,52)
  (31,54)(34,57)(36,61)(38,62)(40,63)(45,65)(55,68)(58,70)(66,71)(69,72),
 ( 1,5)( 3,10)(12,17)(14,18)(16,19),( 1,15)( 2,20)( 3,24)( 4,34)( 9,40)
  (10,41)(11,42)(12,43)(14,44)(16,45)(19,47)(21,48)(23,50)(26,52)(27,53)
  (30,55)(31,56)(33,58)(46,63)(49,64)(51,65)(54,66)(57,67)(59,68),
 ( 2,7)( 6,8)(10,14)(12,15),( 1,15)( 2,20)( 9,37)(10,38)(13,41)(14,42)
  (16,43)(18,44)(19,45)(21,49)(23,53)(24,54)(25,55)(27,56)(28,57)(30,61)
  (31,63)(32,64)(34,65)(36,69)(39,71)(40,72)(46,75)(47,76)(48,77)(50,78)
  (51,79)(52,80)(58,83)(59,84)(60,85)(62,86)(66,89)(67,90)(68,91)(70,92)
  (73,93)(74,94)(81,95)(82,96)(87,97)(88,98),
 ( 1,8)( 2,14)( 3,18)( 4,23)( 9,27)(12,29)(21,33),
 ( 1,15)( 2,19)( 3,22)( 4,24)(10,32)(11,36)(12,40)(13,45)(16,48)(17,51)
  (21,54)(23,57)(26,62)(27,64)(28,66)(31,70)(33,71)(35,72)(37,73)(39,74)
  (41,75)(43,76)(47,77)(50,78)(53,79)(56,80)(59,81)(61,82)(63,83)(65,84),
 ( 1,8)( 2,14)( 3,18)( 4,22)( 5,37)( 6,40)( 9,41)(11,42)(15,44)(17,46)
  (19,48)(21,49)(23,50)(25,51)(30,54)(32,55)(33,57)(35,59)(38,60)(43,63)
  (45,64)(47,65)(52,67)(53,68)(56,69)(58,70)(61,72)(62,73)(66,74)(71,75),
 ( 1,3)(11,12)(13,14)(15,16)(17,18)(19,20)(23,25)(26,27),
 ( 2,3)( 9,10)(14,15)(19,20)(25,26)(32,33),
 ( 2,3)( 9,10)(14,15)(19,20)(25,26)(37,38)(45,46)(48,49)(52,53),
 ( 2,3)( 9,10)(14,15)(19,20)(29,30)(35,36)(38,39),
 ( 1,15)( 2,17)( 3,21)( 4,23)(10,30)(11,35)(12,41)(13,42)(16,48)(19,52)
  (20,55)(25,61)(26,62)(27,63)(29,67)(32,69)(34,71)(36,73)(38,75)(40,77)
  (43,79)(45,81)(47,83)(49,84)(51,86)(54,88)(56,89)(58,91)(60,93)(68,94)
  (70,95)(72,96)(74,97)(76,98)(78,99),( 2,3)( 9,10)(14,15)(20,21)(22,23),
 ( 1,15)( 2,17)( 3,20)( 4,24)(10,35)(11,39)(12,43)(13,45)(16,50)(18,53)
  (22,56)(23,59)(26,62)(27,63)(28,65)(32,70)(34,71)(36,72)(38,73)(40,74)
  (42,75)(44,76)(46,77)(48,78)(51,79)(54,80)(57,81)(60,82)(64,83)(66,84),
 ( 1,15)( 2,17)( 6,19)( 11,23)( 12,24)( 18,39)( 21,40)( 22,41)
  ( 25,43)( 27,46)( 28,48)( 30,50)( 32,52)( 33,54)( 35,57)( 37,59)
  ( 45,66)( 56,69)( 72,86)( 75,89)( 77,91)( 79,93)( 81,95)( 84,98)
  ( 85,105)( 88,106)( 90,107)( 92,108)( 94,109)( 97,110),
 ( 2,28)( 3,29)( 4,30)( 6,31)( 7,34)( 9,35)(10,36)(12,39)(13,40)(15,41)
  (16,44)(19,46)(20,47)(25,52)(32,55)(33,56)(37,57)(38,58)(42,59)(43,60)
  (48,64)(50,65)(53,66),( 2,7)( 9,15)(10,19)(11,24)(12,28)(13,34)(25,35)
  (27,36)(32,37)(39,47)(42,54)(45,60)(49,61)(56,62),
 ( 1,3)(14,16)(17,18)(20,21)(24,25)(29,30)(32,33)(37,38)(39,40)(41,42)
  (44,45)(49,50)(51,52)(56,57)(58,59)(62,63)(66,67),
 ( 2,3)( 9,10)(15,16)(18,20)(21,23)(30,32)(34,36)(39,40)(44,45)(46,47)
  (50,51)(52,53),( 2,28)( 4,30)( 6,31)( 8,32)(10,33)(11,35)(14,36)(15,39)
  (17,41)(18,42)(19,44)(20,45)(21,47)(22,48)(23,49)(24,50)(25,51)(26,55)
  (27,57)(40,61)(52,67)(53,68)(56,69)(58,70)(59,73)(60,74)(63,75)(64,77)
  (65,78)(66,79)(71,81)(72,83),( 1,3)(14,16)(18,20)(25,26)(31,33)(35,37)
  (38,40)(41,43)(44,45)(48,50)(54,56)(57,59)(61,62)(63,64)(68,70)(75,76)
  (79,80)(82,83)(86,87)(89,90)(92,93)(95,96),
 ( 1,15)( 3,17)( 5,19)( 7,21)( 8,23)(12,26)(18,46)(20,48)(25,50)(28,51)
  (31,53)(35,55)(38,57)(40,59)(43,61)(47,63)(49,64),
 ( 1,3)(14,16)(18,19)(20,21)(24,25)(29,30)(33,34)(36,37)(39,40)(41,42)
  (44,45)(47,48)(50,51)(53,54)(58,59)(62,63)(66,67),
 ( 2,3)( 9,10)(15,16)(18,19)(23,24)(25,26)(30,31)(33,34)(39,40)(41,42)
  (43,44)(46,47)(48,49)(54,55)(57,58)(60,61)(63,64)(65,66)(71,72)(74,75)
  (78,79)(82,83),( 1,15)( 4,25)( 7,33)(10,38)(14,41)(16,43)(19,45)(21,46)
  (24,47)(27,48)(28,50)(31,52)(35,53)(37,54)(40,55)(44,56)(51,57),
 ( 1,15)( 4,19)( 7,24)(10,26)(16,34)(17,36)(20,38)(21,42)(23,43)(25,46)
  (27,48)(28,50)(30,53)(31,56)(39,58)(44,60)(51,62)(54,64),
 ( 1,15)( 4,17)( 8,20)( 9,22)( 14,24)( 16,38)( 18,39)( 21,40)
  ( 25,43)( 27,47)( 29,49)( 31,52)( 33,56)( 34,57)( 36,60)( 44,68)
  ( 50,71)( 53,72)( 58,74)( 65,86)( 69,88)( 73,90)( 78,95)( 83,99)
  ( 87,100)( 89,101)( 96,109)(104,114)(106,116),
 ( 2,7)(11,16)(12,19)(13,22)(14,32)(17,33)(18,34)(21,35)(24,37)(29,44)
  (31,50)(54,64)(58,66)(62,68),( 2, 3)( 9,10)( 17,18)( 26,27)
  ( 30,31)( 33,34)( 35,36)( 39,40)( 41,42)( 45,46)( 47,48)( 50,51)
  ( 52,53)( 56,58)( 61,62)( 64,65)( 75,76)( 79,80)( 81,82)( 84,85)
  ( 87,88)( 89,90)( 93,95)( 97,98)(100,101)(109,110)(112,114)(116,117)
  (119,121)(123,125)(127,129)(134,136)(138,140),
 ( 1,14)( 2,23)( 3,37)( 4,42)( 7,44)( 9,45)( 11,47)( 13,50)
  ( 16,51)( 18,54)( 19,56)( 22,57)( 25,58)( 27,60)( 28,63)( 31,65)
  ( 33,67)( 36,68)( 38,70)( 40,73)( 43,75)( 46,77)( 48,79)( 52,81)
  ( 53,83)( 59,84)( 61,86)( 64,87)( 69,88)( 71,90)( 74,91)( 78,93)
  ( 80,95)( 85,97)( 89,100)( 92,102)( 96,103)( 99,104),
 ( 1, 8)( 2,12)( 3,18)( 4,20)( 5,24)( 36,46)( 39,58)( 40,59)
  ( 44,62)( 45,63)( 49,66)( 52,68)( 53,69)( 55,77)( 56,83)( 72,85)
  ( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)( 86,103)( 89,104)( 92,106)
  ( 95,107)( 98,109)(101,110),( 2,26)( 5,27)( 13,28)( 17,29)( 20,30)
  ( 23,31)( 32,66)( 35,71)( 36,72)( 39,75)( 42,78)( 44,79)( 47,84)
  ( 49,85)( 52,90)( 53,91)( 56,94)( 59,97)( 61,98)( 64,103)( 70,104)
  ( 73,105)( 83,106)( 86,107)( 96,108)( 99,109),
 ( 1,14)( 2,22)( 3,25)( 5,35)( 8,38)( 9,39)( 16,45)( 18,48)
  ( 20,49)( 23,50)( 26,55)( 28,58)( 36,84)( 40,85)( 42,87)( 46,88)
  ( 51,89)( 53,91)( 61,98)( 65,100)( 69,101)( 73,102)( 77,104)( 81,105),
 ( 1,5)( 4,11)( 7,13)( 8,14)( 9,15)(10,16)(12,17),
 ( 1,6)( 2,8)( 7,21)(10,22)(12,23)(16,25)(26,29)(28,30),
 ( 1,14)( 2,21)( 3,24)( 4,30)( 9,38)(10,40)(11,41)(12,43)(15,45)(17,48)
  (18,49)(20,50)(25,52)(27,55)(28,56)(31,58)(32,59)(39,64)(42,66)(44,67)
  (47,68)(51,69)(54,70)(57,71)(63,72)(65,73),
 ( 2,25)( 4,27)( 6,29)( 8,32)( 11,34)( 14,37)( 15,42)( 16,43)
  ( 17,45)( 19,48)( 20,50)( 21,52)( 22,54)( 23,56)( 24,59)( 26,61)
  ( 28,62)( 31,63)( 35,64)( 36,65)( 39,66)( 40,68)( 41,69)( 44,72)
  ( 46,73)( 49,75)( 51,77)( 53,79)( 55,81)( 57,82)( 60,84)( 67,87)
  ( 70,96)( 71,99)( 74,100)( 76,101)( 78,102)( 80,103)( 83,104)( 85,111)
  ( 88,112)( 90,113)( 92,114)( 94,115)( 97,116)(105,117)(106,118)(107,119)
  (108,120)(109,121)(110,122),( 2,6)( 3,9)( 4,10),
 ( 1,23)( 3,24)( 5,26)( 6,29)( 7,30)( 9,31)(10,32)(12,36)(13,37)(15,38)
  (17,39)(18,41)(20,44)(22,45)(27,46)(34,47)(42,48),
 ( 2,3)( 5,6)(11,12)(15,16)(18,19),( 1,5)( 4,11)(13,24)(17,31)(19,37)
  (21,43)(23,49)(28,52)(32,56)(36,60)(40,64)(44,68)(48,72)(51,74)(57,77)
  (59,78)(65,81)(67,82)(73,85),( 2,6)( 3,9)(10,14)(11,15),
 ( 1,5)( 4,11)(14,25)(16,26)(18,32)(20,38)(22,44)(27,51)(31,55)(35,59)
  (39,63)(43,67)(47,71)(50,74)(56,77)(58,78)(64,81)(66,82)(72,85),
 ( 2,3)( 5,6)(11,12)(18,19)(23,24)(26,27)(31,32)(34,35)(39,40)(42,43)
  (44,45)(47,48)(52,53)(55,56)(58,59)(60,61)(63,64)(67,68)(70,71)(74,75)
  (77,78)(79,80)(85,86)(87,88),( 1,14)( 2,19)( 3,24)( 4,27)( 5,30)( 6,34)
  ( 7,37)( 8,40)( 9,42)(11,43)(13,44)(16,46)(17,47)(22,49)(26,50)(28,51)
  (31,53)(33,54)(35,55)(39,59)(45,60)(52,63)(56,66)(61,67)(64,68),
 ( 1, 9)( 2,15)( 3,17)( 4,21)( 5,35)( 36,46)( 39,58)( 40,59)
  ( 44,62)( 45,63)( 49,66)( 52,68)( 53,69)( 55,77)( 56,83)( 72,85)
  ( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)( 86,103)( 89,104)( 92,106)
  ( 95,107)( 98,109)(101,110),( 1,14)( 2,19)( 3,21)( 4,25)( 26,30)
  ( 27,34)( 28,48)( 29,52)( 32,66)( 33,71)( 38,72)( 39,76)( 44,78)
  ( 45,83)( 50,84)( 51,88)( 56,90)( 57,95)( 62,96)( 63,100),
 ( 1,14)( 2,18)( 3,22)( 4,25)( 5,31)( 6,33)( 7,38)( 8,40)( 9,41)(11,44)
  (13,45)(15,48)(17,49)(21,50)(23,53)(26,54)(28,56)(30,59)(34,60)(37,61)
  (43,62)(46,64)(52,65)(57,67),( 1,6)( 2,7)(12,21)(19,30)(23,31)(28,40)
  (29,49)(33,50)(35,52)(39,54)(42,56)(44,58)(48,60)(53,62)(57,63)(61,64),
 ( 1,14)( 2,18)( 3,21)( 4,24)( 5,30)( 6,32)( 7,37)( 8,39)( 9,40)(11,43)
  (13,45)(15,48)(17,49)(20,50)(22,53)(25,54)(27,57)(29,60)(33,61)(36,62)
  (42,63)(46,65)(52,66)(58,68),( 2,24)( 4,26)( 6,27)( 8,29)(11,30)(13,31)
  (17,32)(20,34)(22,35)(28,37)(33,39),( 2,3)(10,11)(14,15)(17,18),
 ( 1,8)( 2,11)( 3,19)( 4,26)( 5,31)( 6,40)( 9,42)(12,43)(14,45)(16,47)
  (18,48)(20,50)(22,51)(23,52)(25,54)(28,57)(30,58)(33,60)(35,62)(37,64)
  (38,65)(41,66)(46,69)(49,70)(53,71)(56,74)(61,75)(63,76)(68,77)(73,78),
 ( 1,2)( 9,10)(13,14)(18,19)(24,25)(30,31),
 ( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)(10,31)(11,32)(13,33)(15,34)(18,37)
  (20,38)(22,42)(27,44)(28,45)(29,46)(35,48)(36,49)(39,51)(40,52)(41,53)
  (43,54)(47,55)(50,56),( 2,6)( 3,8)(12,24)(17,28)(19,34)(21,40)(23,46)
  (29,53)(33,57)(37,61)(41,65)(45,69)(49,73)(52,75)(54,76)(60,79)(62,80)
  (68,83)(70,84),( 1,14)( 2,16)( 3,20)( 4,22)( 5,24)( 6,26)( 7,27)( 8,30)
  ( 9,33)(10,34)(11,36)(12,38)(13,39)(17,42)(18,43)(29,48)(32,49),
 ( 1,5)( 4,10)(13,17)(15,33)(19,35)(29,41)(31,47)(36,48)(38,50)(40,52)
  (42,54)(44,56)(46,58)(51,61)(55,63)(59,65),
 ( 1,2)( 3,9)( 6,11)( 8,13)(10,15)(12,17)(14,18)(16,19),
 ( 2,3)(10,11)(15,16)(17,18)(21,22)(27,28)(30,31),
 ( 1,5)( 4,9)( 6,21)( 8,22)(13,23)(19,28)(24,29)(26,30),
 ( 2,3)(10,11)(15,16)(20,21)(24,25)(30,31)(38,39),
 ( 2,3)(10,11)(15,16)(20,21)(24,25)(31,32),
 ( 1,3)( 4,5)( 6,8)( 9,10)(12,13)(15,16)(17,19)(20,21)(24,25)(27,28)
  (33,34)(36,37)(42,43)(45,46),( 1,2)( 5,6)( 9,10)(13,14)(27,28)(29,30)
  (34,35)(36,37)(38,39),( 1,23)( 4,27)( 8,28)(11,29)(13,33)(16,34)(18,35)
  (21,36)(24,37)(25,38)(30,39)(31,40),( 1,11)( 3,13)( 5,14)( 7,16)(18,26)
  (19,31),( 1,14)( 2,15)( 4,17)( 5,19)( 8,20)( 9,22)(11,24)(12,25)(16,26)
  (18,27)(21,28)(23,29),( 1,6)( 3,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)
  (16,19),( 1, 9)( 2,13)( 3,25)( 4,28)( 5,31)( 36,47)( 37,56)
  ( 41,58)( 42,59)( 44,62)( 48,64)( 49,67)( 53,69)( 54,71)( 55,80)
  ( 72,89)( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)( 88,102)( 90,103)
  ( 92,106)( 94,107)( 96,110)( 98,111),( 2,4)( 6,7)( 8,9)(10,11)(13,14)
  (15,16),( 2,3)(10,11)(18,19)(20,21)(24,25)(26,27)(31,32)(35,36)(38,39)
  (43,44)(47,48)(50,51)(53,54)(56,57)(59,60)(67,68)(70,71),
 ( 2,3)(10,11)(18,19)(21,22)(24,25)(27,28)(30,31)(35,36)(38,39)(44,45)
  (48,49)(53,54)(57,58)(59,60)(63,64)(67,68)(69,70)(71,72)(73,74)(75,76),
 ( 1,5)( 4,8)( 6,11)( 7,13)( 9,15)(10,17)(14,19)(16,21),
 ( 1,14)( 3,20)( 5,24)( 8,30)(11,36)(16,41)(19,44)(23,45)(26,46)(28,47)
  (33,50)(35,51)(38,52)(40,53)(43,54)(49,55),( 1,2)( 3,5)(14,15)(19,20),
 ( 1,2)( 3,5)(14,15)(21,22),( 2,6)( 4,10)(13,14)(16,33)(20,35)(29,38)
  (31,44)(37,49)(39,51)(41,53)(43,55)(45,57)(47,59)(50,61)(54,63)(58,65),
 ( 2,3)(10,11)(19,20)(24,25)(27,28)(30,31)(36,37)(38,39)(40,41)(44,45)
  (47,48)(49,50)(53,54)(56,57)(58,59)(60,61)(63,64)(65,66)(68,69)(70,71)
  (73,74)(76,77)(79,80),( 2,3)(11,13)(24,26)(28,29)(31,33)(38,39)(40,41)
  (43,44)(45,46)(47,49)(51,52)(55,56)(59,60)(61,63)(65,66)(71,72)(77,78)
  (79,80)(83,84)(85,86)(87,88)(91,92),( 1,11)( 4,30)( 5,35)( 7,37)(12,42)
  (15,45)(16,46)(19,52)(20,53)(23,55)(26,60)(29,63)(31,64)(39,70)(41,71)
  (49,74)(51,75)(57,76)(59,77)(67,80)(69,83)(73,86)(79,89)(82,90)(85,91)
  (88,92),( 1,6)( 3,9)(10,15)(23,36)(27,38)(28,42)(30,48)(39,51)(41,53)
  (43,55)(45,57)(47,59)(49,61)(52,63)(56,65)(60,67),
 ( 1,23)( 4,24)( 6,25)( 9,29)(13,30)(16,31)(18,35)(21,36)(26,37)(27,38)
  (32,39)(33,40),( 1,4)( 5,8)( 9,12)(15,19)(25,27)(28,30)(34,36)(37,39)
  (43,45)(46,48),( 2,3)( 6,7)( 8,9)(11,12)(15,16)(20,21),
 ( 1,23)( 4,24)( 6,25)( 9,26)(11,30)(14,31)(18,32)(21,36)(27,37)(28,38)
  (33,39)(34,40),( 2,8)( 3,10)( 4,12)( 6,14)( 7,16)(11,17)(15,18),
 ( 1,7)( 3,13)( 5,18)( 9,21)(15,23)(17,26)(22,28)(24,30),
 ( 1,2)(10,12)(13,15)(16,18)(21,23)(24,26)(27,29)(30,31)(34,35)(37,39)
  (40,42)(44,45)(48,49),( 2,6)( 4,8)( 9,13)(11,14),
 ( 2,3)(11,12)(14,15)(17,18)(19,20)(21,22)(24,25)(28,29)(32,33),
 ( 1,14)( 4,23)( 5,29)( 7,32)( 8,35)( 10,37)( 11,40)( 13,44)
  ( 18,47)( 22,48)( 25,52)( 26,54)( 28,55)( 34,60)( 39,64)( 41,68)
  ( 43,71)( 51,78)( 53,82)( 67,93)( 74,97)( 81,101)( 86,104),
 ( 1,8)( 2,10)( 5,13)( 6,15)( 9,16)(11,17)(12,18)(14,19),
 ( 1,9)( 2,13)( 5,16)( 7,19)(12,22)(17,24),
 ( 2,3)( 6,7)( 9,10)(13,14)(25,26)(29,30)(32,33)(46,47)(48,49)(50,51)
  (54,55)(57,58)(63,64)(65,66)(67,68)(71,72)(74,75),
 ( 1,9)( 2,13)(10,39)(11,40)(12,41)(14,43)(15,47)(17,48)(18,49)(19,50)
  (22,51)(23,52)(24,53)(26,55)(28,57)(29,58)(30,59)(32,61)(33,65)(35,66)
  (36,67)(37,68)(42,71)(44,72)(45,73)(46,74)(54,77)(56,78)(60,81)(62,82)
  (63,83)(64,84)(69,85)(70,86)(75,87)(76,88)(79,89)(80,90),
 ( 2,4)( 7,9)(12,14)(17,18)(21,23),( 1,37)( 3,39)( 5,43)( 6,46)(10,47)
  (12,51)(17,52)(19,54)(22,58)(23,61)(26,65)(29,66)(31,70)(32,71)(34,74)
  (42,76)(44,79)(50,80)(57,82)(59,85)(62,86)(63,89)(69,90)(75,91)(77,94)
  (81,95)(83,98),( 1,11)( 4,13)( 6,15)( 7,17)( 8,21)( 9,24)(12,25)(14,26)
  (16,31)(18,32)(20,33)(22,34)(27,35)(29,36),
 ( 1,7)( 3,11)( 5,22)( 9,24)(12,26)(15,28)(18,30),
 ( 1, 9)( 2,12)( 3,16)( 4,21)( 5,24)( 6,29)( 8,34)( 13,38)
  ( 15,40)( 18,45)( 20,47)( 28,52)( 30,54)( 33,57)( 35,58)( 36,60)
  ( 37,61)( 39,63)( 41,64)( 44,66)( 46,68)( 48,71)( 49,72)( 51,75)
  ( 53,77)( 55,80)( 56,81)( 59,83)( 62,85)( 65,86)( 67,88)( 70,89)
  ( 73,91)( 74,92)( 76,94)( 79,95)( 82,97)( 84,99)( 87,101)( 90,104)
  ( 93,105)( 96,107)( 98,108)(100,109)(102,111)(103,113)(106,116)(110,118)
  (112,119)(114,121)(115,122)(117,124)(120,125)(123,126),
 ( 2,3)( 9,11)(16,17)(21,22)(25,26)(31,32)(33,34)(35,36),
 ( 1,3)( 9,10)(15,17)(19,21)(24,25)(27,29)(31,32)(34,36),
 ( 1, 9)( 2,12)( 3,15)( 4,20)( 5,26)( 6,33)( 11,35)( 13,37)
  ( 16,38)( 18,42)( 21,45)( 23,47)( 27,53)( 30,54)( 32,55)( 34,57)
  ( 36,59)( 39,60)( 41,62)( 43,66)( 44,67)( 46,69)( 48,74)( 51,76)
  ( 52,77)( 56,81)( 58,82)( 61,85)( 63,86)( 65,88)( 68,89)( 70,94)
  ( 73,96)( 75,97)( 78,98)( 80,100)( 83,103)( 87,104)( 90,107)( 93,109)
  ( 95,110)( 99,111)(102,113)(106,115)(108,116)(112,117)(114,118),
 ( 1,8)( 2,9)( 4,12)( 5,13)( 6,14)(10,15)(16,20)(18,21),
 ( 1,37)( 4,40)( 5,43)( 7,47)(11,49)(12,52)(13,54)(16,57)(18,58)(20,61)
  (22,64)(25,68)(28,70)(30,71)(32,74)(34,76)(41,79)(42,81)(50,82)(56,84)
  (62,85)(63,87)(72,88)(78,90),( 2,4)( 7,9)(12,13)(20,21)(24,25)(26,27)
  (31,32),( 1,22)( 2,23)( 4,24)( 6,26)( 7,29)( 9,31)(11,32)(12,33)(13,35)
  (15,38)(17,40)(19,42)(21,45)(27,47)(28,48)(36,49)(37,50)(43,51)(44,52),
 ( 1,2)( 3,4)( 5,6)( 7,8)(12,13)(19,20),
 ( 1,13)( 2,20)( 3,24)( 4,28)(33,39)(34,43)(35,54)(36,58)(37,67)(41,68)
  (42,69)(46,73)(47,75)(51,76)(52,77)(56,81)(57,83)(61,84)(62,85)(66,89),
 ( 2,3)( 6,7)(10,11)(14,15)(26,27)(28,29)(33,34)(38,39)(41,42),
 ( 1,13)( 2,20)( 5,40)( 7,41)( 16,42)( 19,43)( 25,44)( 26,45)
  ( 30,53)( 33,61)( 35,62)( 38,70)( 46,93)( 47,94)( 49,97)( 50,98)
  ( 52,101)( 54,103)( 55,104)( 57,107)( 58,108)( 60,111)( 63,113)( 64,114)
  ( 66,117)( 67,118)( 69,121)( 72,123)( 74,125)( 76,128)( 80,131)( 84,132)
  ( 88,133)( 95,135)( 99,137)(105,139)(109,141)(115,143)(119,145)(126,146)
  (130,147),( 2,23)( 3,24)( 5,25)( 7,27)( 8,30)(10,31)(12,32)(13,33)(15,35)
  (16,38)(18,39)(20,41)(22,44)(28,45)(29,46)(36,47)(37,48)(42,49)(43,50),
 ( 1,13)( 2,19)( 3,23)( 6,24)( 8,25)(14,28)(17,29),
 ( 1,2)( 3,4)( 5,6)( 8,10)(12,14)(17,19)(21,23),
 ( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(34,35)(37,38)(41,42)(44,45)
  (48,49)(51,52),( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(34,35)(37,38)
  (41,42)(45,46)(49,50)(52,53),( 1,3)( 5,7)( 9,11)(16,17)(25,27)(29,30)
  (32,34)(36,37),( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(35,36)(37,38)
  (39,40),( 1,8)( 3,21)( 5,32)( 9,37)(12,39)(13,41)(17,43)(18,46)(22,49)
  (24,50)(26,52)(28,54)(30,55)(33,59)(34,62)(40,66)(44,70)(53,77)(56,80),
 ( 1,13)( 2,18)( 3,21)( 4,25)( 5,29)( 6,32)( 7,36)( 8,39)( 9,41)(10,42)
  (12,44)(14,46)(16,48)(22,50)(24,51)(26,53)(28,55)(30,57)(34,60)(37,61)
  (45,63)(47,64)(54,66)(56,67),( 1, 2)( 3, 4)( 5, 6)( 8, 9)
  ( 11,12)( 13,14)( 15,16)( 17,18)( 20,21)( 24,25)( 27,28)( 29,30)
  ( 41,42)( 43,44)( 46,47)( 49,50)( 52,53)( 54,55)( 57,58)( 59,60)
  ( 62,63)( 66,67)( 68,69)( 72,73)( 74,75)( 78,79)( 81,82)( 84,85)
  ( 87,88)( 92,93)( 95,96)( 98,99)(101,102)(104,105)(107,108)(109,110)
  (112,113)(115,116)(118,119)(121,122)(124,125),
 ( 2,3)(12,13)(14,15)(19,20)(21,22),( 1,2)( 3,4)( 5,6)( 8,9)(11,12)
  (14,15)(16,17)(18,19)(20,21)(23,24)(25,26)(27,28)(29,30)(39,40)(41,42)
  (43,44)(46,47)(48,49)(50,51)(52,53)(54,55)(56,57)(58,59)(60,61)(78,79)
  (80,81)(82,83)(85,86)(87,88)(89,90),( 2,8)( 4,13)( 5,16)(12,22)(14,24)
  (20,26)(23,28)(25,30),( 2,11)( 4,13)( 6,14)( 9,17)(18,25)(19,30),
 ( 1, 8)( 3,15)( 6,28)( 9,35)( 11,36)( 13,37)( 16,41)( 18,44)
  ( 19,46)( 26,49)( 29,53)( 32,56)( 38,62)( 42,65)( 45,67)( 48,70)
  ( 50,73)( 51,74)( 55,79)( 59,82)( 71,90)( 75,93)( 80,96)( 83,98)
  ( 87,100)(101,110)(103,112)(106,115)(113,120)(116,123),
 ( 2,8)( 4,12)( 5,13)( 6,16)( 7,20)(10,22)(15,24)(18,26),
 ( 2,4)( 7,8)(21,22)(24,25)(27,28)(31,32)(34,35)(38,39)(43,44)(45,46)
  (48,49)(52,53)(54,55)(57,58)(62,63)(65,66)(68,69)(71,72)(82,83)(84,85)
  (86,87)(88,89)(90,91)(92,93),( 1,5)( 7,20)(10,21)(11,23)(13,25)(14,27)
  (16,29)(17,31)(19,33),( 1,5)( 7,19)( 9,21)(11,23)(14,25)(16,27)(18,28)
  (20,29)(22,30)(24,32)(26,33),( 1,13)( 2,17)( 3,20)( 4,22)(10,32)(11,36)
  (12,40)(14,47)(15,50)(19,53)(21,56)(24,61)(25,62)(27,64)(28,66)(31,70)
  (33,71)(35,72)(37,73)(39,74)(41,75)(43,76)(46,77)(49,78)(52,79)(55,80)
  (58,81)(60,82)(63,83)(65,84),( 1,2)( 3,4)( 5,6)( 8,9)(12,13)(17,18)
  (21,22),( 1,13)( 2,16)( 3,21)( 4,25)( 5,32)( 6,35)( 8,36)( 9,38)(11,41)
  (14,46)(17,47)(19,48)(23,50)(26,51)(28,52)(30,57)(33,58)(37,60)(39,63)
  (42,64)(44,66)(45,69)(49,72)(53,73)(55,75)(56,78)(59,81)(62,82)(65,83)
  (67,86)(71,87)(74,88)(76,91)(80,92)(85,93)(90,94),
 ( 2,3)(12,13)(17,18)(19,20)(21,22)(23,24),
 ( 1,2)( 3,4)( 5,6)( 8,9)(14,15)(17,18)(23,24),
 ( 2,3)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26),
 ( 1, 5)( 8,30)( 13,36)( 14,38)( 15,41)( 18,44)( 19,45)( 22,46)
  ( 25,52)( 28,59)( 31,63)( 33,66)( 39,70)( 42,73)( 43,74)( 47,86)
  ( 49,87)( 53,92)( 54,93)( 56,96)( 60,100)( 62,103)( 64,106)( 65,107)
  ( 67,109)( 71,111)( 72,112)( 79,118)( 82,122)( 84,126)( 88,130)( 89,133)
  ( 94,137)( 98,141)(101,145)(104,148)(110,156)(114,157)(115,159)(116,162)
  (119,164)(120,167)(123,169)(124,172)(128,173)(131,175)(134,177)(135,178)
  (139,180)(142,182)(143,183)(146,185)(149,187)(174,191)(176,192)(179,193)
  (181,194)(184,195)(186,196),( 1,22)( 3,23)( 5,26)( 6,27)( 8,28)( 9,29)
  (11,32)(13,33)(14,36)(16,37)(17,40)(19,41)(21,44)(25,47)(31,50)(35,51)
  (39,54)(43,55)(46,56)(49,57)(53,58),( 1,13)( 2,15)( 3,22)( 4,23)(10,31)
  (11,37)(12,38)(14,43)(17,49)(18,52)(21,56)(24,61)(26,62)(27,63)(30,68)
  (32,70)(34,72)(36,74)(39,76)(41,78)(42,79)(44,80)(46,82)(48,84)(50,85)
  (53,87)(55,89)(57,90)(59,92)(67,94)(69,95)(71,96)(73,97)(75,98)(77,99),
 ( 1,8)( 3,12)( 5,13)( 6,16)( 7,20)( 9,22)(14,24)(17,26),
 ( 1,13)( 2,15)( 3,21)( 4,24)( 5,28)( 6,31)( 7,36)( 8,38)( 9,39)(12,40)
  (16,41)(18,44)(20,47)(23,49)(25,52)(30,53)(32,56)(33,58)(35,61)(43,62)
  (45,63)(50,66)(55,67)(59,70)(64,71)(68,72),
 ( 1,13)( 2,15)( 3,18)( 4,21)( 5,24)( 6,27)( 7,32)( 8,34)( 9,37)(11,38)
  (12,41)(16,43)(20,45)(25,49)(29,53)(31,54)(35,56)(42,61)(44,62)(46,64)
  (50,67)(52,68)(55,69)(57,71)(60,72)(66,73),
 ( 2,23)( 4,24)( 7,25)( 9,26)(12,30)(14,31)(17,32)(20,33)(21,37)(27,38)
  (34,39),( 1,13)( 2,15)( 3,17)( 4,18)( 5,20)( 6,24)( 7,26)( 8,28)( 9,30)
  (10,34)(11,38)(12,40)(21,45)(23,46)(25,47)(33,52)(35,53)(37,54),
 ( 2, 3)( 13,14)( 21,22)( 30,31)( 32,33)( 34,35)( 37,38)( 39,40)
  ( 43,44)( 48,49)( 50,51)( 52,53)( 54,55)( 57,58)( 59,60)( 61,62)
  ( 67,68)( 69,70)( 71,72)( 73,74)( 75,76)( 77,78)( 80,81)( 82,83)
  ( 84,85)( 86,87)( 88,89)( 90,91)( 93,94)( 95,96)( 97,98)( 99,100)
  (101,102)(103,104)(108,109)(110,111)(112,113)(114,115)(119,120)(123,124)
  (127,128)(131,132),( 1,5)( 8,11)(12,15)(16,19)(23,25)(28,29)(30,32)
  (36,37)(38,40)(44,45),( 2,6)( 9,13)(10,20)(11,25)(12,31)(14,36)(19,37)
  (22,38)(28,39)(34,40)(43,51)(46,57),( 2,3)(14,15)(18,19)(21,22)(25,26)
  (35,36)(38,39)(43,44)(45,46)(50,51)(53,54)(58,59)(60,61)(62,63)(66,67)
  (70,71)(78,79)(80,81)(86,87),( 1,2)( 3,4)( 5,6)(10,11)(14,15)(19,20)
  (23,24),( 1,13)( 2,15)( 4,17)( 5,18)( 7,20)(10,23)(12,24)(14,25)(16,26),
 ( 1,5)( 9,18)(10,21)(11,27)(12,31)(19,34)(20,35)(23,36)(25,37)(32,38)
  (50,59)(53,60)(58,61),( 2,3)(15,16)(18,19)(20,21)(24,25)(31,32)(35,36)
  (39,40)(41,42)(45,46)(48,49)(50,51)(53,54)(55,56)(57,58)(59,60)(63,64)
  (65,66)(67,68),( 2,3)(15,16)(19,20)(21,22)(24,25)(26,27)(30,31)(32,33)
  (36,37)(40,41)(48,49)(53,54)(56,57)(58,59)(60,61),
 ( 1,13)( 2,14)( 3,16)( 4,19)( 5,21)( 6,24)( 7,27)( 8,29)( 9,33)(10,36)
  (11,37)(12,39)(18,43)(20,45)(22,46)(30,49)(32,51)(35,52),
 ( 1,2)( 3,4)( 6,7)( 8,9)(10,11)(12,14)(15,16)(18,19)(28,29)(30,31)
  (32,33)(34,35)(36,37)(38,39)(40,41)(42,43)(44,45)(46,47)(48,49)(50,51)
  (53,54)(55,56)(57,58)(59,60)(79,80)(81,82)(83,84)(85,86)(88,89)(90,91)
  (92,93)(94,95),( 2,3)(16,17)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32),
 ( 1,13)( 2,14)( 4,16)( 5,18)( 7,20)( 8,21)(10,22)(11,24)(15,25)(19,27)
  (23,30)(26,32)(29,33),( 1,13)( 2,14)( 4,16)( 5,17)( 7,20)( 9,21)(10,22)
  (11,25)(15,26)(18,28)(23,30)(27,31)(29,32),
 ( 1,22)( 4,23)( 6,26)( 9,27)(12,28)(15,31)(17,34)(20,35)(25,38)(30,41)
  (33,42)(37,43)(40,44),( 1,8)( 3,11)( 6,14)( 9,16)(17,21)(19,22),
 ( 1, 2)( 3, 4)( 6, 7)( 8, 9)( 11,12)( 15,16)( 18,19)( 20,21)
  ( 22,23)( 24,25)( 27,28)( 30,31)( 40,41)( 42,43)( 45,46)( 48,49)
  ( 51,52)( 53,54)( 57,58)( 59,60)( 63,64)( 65,66)( 69,70)( 72,73)
  ( 74,75)( 77,78)( 80,81)( 83,84)( 86,87)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)
  (125,126),( 1,2)( 3,4)( 6,7)( 8,9)(11,12),
 ( 1, 2)( 3, 4)( 6, 7)( 9,10)( 11,12)( 13,14)( 15,16)( 18,19)
  ( 22,23)( 25,26)( 27,28)( 30,31)( 41,42)( 43,44)( 46,47)( 49,50)
  ( 52,53)( 54,55)( 57,58)( 59,60)( 62,63)( 66,67)( 68,69)( 72,73)
  ( 74,75)( 78,79)( 81,82)( 84,85)( 87,88)( 92,93)( 95,96)( 98,99)
  (101,102)(104,105)(107,108)(109,110)(112,113)(115,116)(118,119)(121,122)
  (124,125),( 2,23)( 5,24)( 7,25)(10,28)(13,29)(15,30)(17,31)(19,34)(22,36)
  (27,38)(33,40),( 1,5)( 9,12)(13,16)(22,23)(26,28)(29,30)(31,32)(35,36)
  (37,38),( 1,5)( 9,12)(13,16)(22,23)(26,27)(28,29)(30,31)(34,35)(36,37),
 ( 1,2)( 3,4)( 6,7)( 9,10)(12,13)(14,15)(17,18)(19,20)(24,25)(26,27)
  (31,32)(38,39)(40,41)(47,48)(50,51)(54,55),
 ( 2,5)( 3,9)( 7,22)(11,24)(12,26)(15,28)(18,30),
 ( 1,13)( 3,15)( 4,16)( 6,19)( 8,20)( 9,21)(10,24)(12,25)(14,26)(17,28)
  (22,30)(27,31)(29,32),( 1,21)( 2,23)( 3,24)( 4,25)( 5,27)( 6,29)( 7,31)
  ( 8,32)(16,33)(17,34)(18,36)(19,37),( 1, 9)( 3,15)( 6,25)( 7,29)
  ( 11,35)( 14,36)( 17,38)( 18,41)( 21,43)( 24,45)( 26,47)( 30,50)
  ( 33,53)( 40,61)( 44,64)( 51,72)( 57,79)( 66,87)( 74,92)( 76,93)
  ( 80,95)( 83,96)( 88,100)( 97,107)(101,109),
 ( 1,5)( 9,11)(14,16)(18,20),( 1,13)( 3,15)( 6,17)( 8,18)( 9,19)(11,21)
  (12,22)(14,24)(16,25)(20,26)(23,27),( 1,5)(10,29)(14,30)(20,31)(22,32)
  (26,33)(27,40)(28,51)(35,55)(36,56)(39,58)(41,60)(45,62)(48,65)(49,66)
  (52,68)(57,76)(61,77)(67,78)(81,91)(84,93)(88,95),
 ( 2,23)( 6,25)( 8,27)(11,29)(13,31)(15,33)(19,35)(21,37)(24,38)(28,39)
  (32,40)(36,41),( 3,37)( 5,40)( 6,41)( 8,45)(11,46)(14,50)(15,53)(18,57)
  (20,59)(25,60)(27,64)(31,65)(32,68)(34,72)(36,74)(42,75)(48,76)(49,79)
  (52,80)(54,83)(61,85)(67,86)(69,89)(82,91)(84,94)(88,95)(90,98),
 ( 1,13)( 4,27)( 5,34)( 7,41)( 9,44)(12,45)(15,47)(17,48)(20,49)(23,52)
  (26,53)(30,54)(33,55)(37,56)(40,59)(50,61)(57,63),
 ( 1,13)( 4,27)( 5,33)( 9,41)(12,42)(15,43)(17,46)(21,50)(26,51)(30,52)
  (32,55)(37,59)(38,60)(40,63)(45,64)(47,67)(49,68)(54,69)(56,72)(58,73),
 ( 1,21)( 2,22)( 3,23)( 4,24)( 5,26)( 6,27)( 7,29)( 8,30)( 9,31)(18,32)
  (19,34),( 1,2)( 3,4)(10,12)(15,16)(19,21)(23,24)(27,29)(33,34)(35,36)
  (40,42)(45,46),( 3,32)( 5,33)( 7,34)( 9,36)(12,38)(14,39)(16,40)(19,42)
  (24,43)(26,44)(29,46)(49,63)(54,68)(58,72)(62,84)(67,86)(71,88)(74,89)
  (76,91)(77,93)(78,95)(80,97)(81,99),( 1,2)( 3,4)(10,11)(12,13)(14,15)
  (16,17)(19,20)(21,22)(23,24),( 1,13)( 4,21)( 6,33)( 7,35)
  ( 9,36)( 10,37)( 11,39)( 12,42)( 16,45)( 17,47)( 18,49)( 20,51)
  ( 24,55)( 25,57)( 38,74)( 41,75)( 43,76)( 44,79)( 52,81)( 53,82)
  ( 54,85)( 78,102)( 84,103),( 3,32)( 6,33)( 9,34)( 19,35)( 24,36)
  ( 27,37)( 31,38)( 39,63)( 42,64)( 43,69)( 44,70)( 48,75)( 49,76)
  ( 50,81)( 53,82)( 54,87)( 55,88)( 59,93)( 60,94)( 65,97)( 68,98)
  ( 77,99)( 80,100)( 89,101)( 92,102),( 1,2)( 3,4)(11,13)(17,18)(19,20)
  (24,26)(29,30)(32,34)(37,38)(41,43)(45,46),
 ( 1,13)( 4,18)( 7,26)( 8,29)(10,35)(15,41)(17,42)(21,44)(25,47)(28,48)
  (33,50)(38,53)(40,54)(43,55)(46,56)(49,57)(52,58),
 ( 1,8)( 3,9)( 5,12)( 7,15)(10,16)(11,17)(13,18)(14,19),
 ( 2,22)( 4,24)( 6,26)(10,27)(12,28)(15,30)(17,32)(19,33)(25,36)(31,39)
  (35,42)(38,43)(41,44),( 3,32)( 6,33)( 10,34)( 18,35)( 21,36)
  ( 25,37)( 29,38)( 30,39)( 42,56)( 45,61)( 47,64)( 48,65)( 51,70)
  ( 52,71)( 55,76)( 63,89)( 69,90)( 77,91)( 78,94)( 82,97)( 83,100)
  ( 84,103)( 88,106)( 92,111)( 95,114)( 98,117)(101,120)(104,123)(107,126)
  (110,127)(116,128)(122,129),( 1,2)( 3,4)(12,13)(16,17)(20,22)(23,25)
  (28,29)(32,33)(34,35)(39,40)(44,45),( 1,2)( 3,4)(12,13)(17,18)(22,23)
  (24,25)(28,29)(32,34)(35,37)(40,41)(44,45),
 ( 3,32)( 7,33)( 10,34)( 12,35)( 17,36)( 21,37)( 26,38)( 39,62)
  ( 43,65)( 46,66)( 49,68)( 52,70)( 55,72)( 57,73)( 58,75)( 61,77)
  ( 71,92)( 76,93)( 78,94)( 79,96)( 82,98)( 85,100)( 86,102)( 89,104)
  ( 95,107)( 97,109)( 99,111)(101,113)(103,115)(105,117)(106,118)(110,119)
  (114,120),( 3,32)( 7,33)( 10,34)( 14,35)( 15,36)( 19,37)( 23,38)
  ( 26,39)( 40,56)( 43,61)( 44,62)( 47,67)( 48,68)( 50,71)( 53,76)
  ( 63,89)( 69,90)( 77,93)( 81,96)( 82,99)( 83,102)( 87,105)( 88,108)
  ( 92,109)( 95,112)( 98,115)(101,118)(104,121)(107,124)(113,127)(119,128)
  (125,129),( 3,32)( 7,33)( 15,34)( 20,35)( 24,36)( 29,37)( 31,38)
  ( 40,63)( 41,64)( 44,66)( 45,68)( 47,69)( 50,71)( 53,73)( 56,75)
  ( 59,76)( 65,92)( 70,93)( 80,95)( 83,97)( 84,99)( 87,101)( 90,103)
  ( 91,105)( 94,106)( 96,108)( 98,110)(100,112)(102,114)(104,116)(109,118)
  (113,119)(117,120),( 1, 4)( 2,19)( 3,25)( 6,35)( 8,39)( 10,41)
  ( 12,42)( 15,47)( 17,48)( 21,52)( 22,53)( 24,56)( 34,84)( 38,85)
  ( 43,88)( 46,89)( 54,91)( 62,98)( 66,100)( 70,101)( 74,102)( 78,103)
  ( 83,104)( 87,105)( 90,107),( 1,9)( 3,13)( 6,21)( 7,26)(11,45)(12,48)
  (16,49)(18,50)(20,51)(23,54)(25,55)(28,56)(30,57)(37,64)(42,69)(47,73)
  (53,74)(59,75)(66,77),( 1,2)( 3,4)(14,15)(19,20)(21,22)(25,26)(29,31)
  (32,34)(37,38)(41,42)(43,44),( 2,5)( 6,20)( 8,21)(10,22)(13,24)(14,26)
  (16,28)(19,30)(25,31)(29,32),( 1,2)( 3,4)(14,15)(21,22),
 ( 1,12)( 2,23)( 4,48)( 7,49)( 11,52)( 15,53)( 18,54)( 25,56)
  ( 27,57)( 30,58)( 32,60)( 35,64)( 37,65)( 41,69)( 43,70)( 47,74)
  ( 50,76)( 51,78)( 61,88)( 62,90)( 66,92)( 67,94)( 71,96)( 72,98)
  ( 79,99)( 80,100)( 83,102)(101,104)(103,105),
 ( 1,2)( 3,4)(19,20)(21,22)(23,24),( 3,30)( 5,32)( 8,34)( 10,35)
  ( 13,36)( 15,38)( 18,40)( 21,41)( 23,43)( 25,45)( 27,46)( 48,61)
  ( 52,67)( 56,73)( 62,86)( 68,87)( 74,88)( 78,90)( 79,92)( 81,95)
  ( 82,97)( 83,100)( 85,102),( 1,12)( 2,21)( 3,27)( 4,35)( 6,37)( 7,39)
  ( 8,42)(10,44)(11,46)(15,49)(17,51)(20,54)(22,56)(24,58)(26,60)(41,88)
  (45,90)(53,91)(57,93),( 3,30)( 5,31)( 7,32)( 12,34)( 14,35)
  ( 16,36)( 18,38)( 21,40)( 22,41)( 25,42)( 27,44)( 49,60)( 54,66)
  ( 57,72)( 58,84)( 62,86)( 68,88)( 74,89)( 76,91)( 78,93)( 79,96)
  ( 81,98)( 82,101),( 1,12)( 2,21)( 5,47)( 8,48)( 10,49)( 13,53)
  ( 16,54)( 19,55)( 26,59)( 29,60)( 33,64)( 34,65)( 38,69)( 40,70)
  ( 44,74)( 45,75)( 51,80)( 52,81)( 58,88)( 62,94)( 63,96)( 67,98)
  ( 68,100)( 72,102)( 73,104)( 78,106)( 83,107)( 86,108)( 90,109),
 ( 1,12)( 2,20)( 3,27)( 4,35)( 5,43)( 6,44)( 9,46)(11,48)(13,49)(16,50)
  (18,51)(21,53)(23,55)(25,56)(28,57)(31,58)(33,60)(36,62)(39,63)(41,64),
 ( 2,22)( 5,23)( 7,26)( 9,29)(13,30)(16,33)(18,36)(21,37)(27,38)(28,39)
  (34,40)(35,41),( 1,8)( 4,12)( 6,15)(10,17)(14,18),
 ( 1,12)( 2,20)( 3,25)( 4,34)( 5,40)( 6,42)( 7,43)( 9,44)(11,45)(13,48)
  (15,49)(18,51)(21,52)(24,53)(27,54)(28,55)(30,58)(33,59)(35,60)(37,62)
  (39,63)(46,64)(47,65)(50,66)(56,67)(57,68)(61,69),
 ( 3,29)( 6,32)( 9,33)(10,35)(12,36)(13,37)(15,38)(16,40)(17,43)(18,44)
  (19,45)(20,47)(21,49)(22,50)(23,52)(24,54)(25,55)(26,56)(27,58)(28,59)
  (41,61)(42,63)(46,65)(53,66)(62,67)(64,68),
 ( 1,12)( 2,19)( 3,27)( 4,34)( 5,42)( 6,44)( 8,45)(11,47)(14,49)(16,50)
  (18,51)(21,52)(23,54)(26,56)(28,57)(30,58)(33,59)(36,61)(38,63)(41,64),
 ( 1,2)( 4,11)(12,16)(13,17)(14,18),( 2,22)( 5,23)( 8,28)(11,29)(13,30)
  (16,33)(18,36)(21,37)(24,38)(26,39)(31,40)(34,41),
 ( 1,8)( 4,11)( 6,14)(13,20)(17,21)(19,22),
 ( 1,2)( 4,10)( 6,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 2,21)( 4,23)( 5,25)( 8,26)(10,28)(11,30)(13,32)(15,35)(17,37)(19,39)
  (22,40),( 1,20)( 2,21)( 4,24)( 6,27)( 8,30)(10,32)(12,35)(13,38)(15,40)
  (16,43)(18,46)(22,47)(23,48)(26,50)(28,51)(31,53)(34,55)(36,56)(39,58)
  (42,60)(44,61)(49,63)(52,64)(54,65)(57,66)(59,67)(62,68),
 ( 1,3)( 6,8)(11,13)(19,21)(27,29)(35,37)(42,44),
 ( 1,20)( 3,23)( 4,25)( 5,27)( 6,30)( 7,32)( 8,35)(10,37)(11,39)(12,42)
  (14,44)(15,47)(16,49)(17,51)(18,54),( 1,8)( 4,10)( 6,13)( 9,16)(11,18),
 ( 3,26)( 6,27)( 8,29)( 10,31)( 14,32)( 17,34)( 20,35)( 22,36)
  ( 24,38)( 45,80)( 49,81)( 50,82)( 54,84)( 58,85)( 59,86)( 62,88)
  ( 66,89)( 67,90)( 71,93)( 72,97)( 73,101)( 74,103)( 75,107)( 76,111)
  ( 77,113)( 78,117)( 79,121)(122,135)(123,137)(125,139)(126,141)(128,143)
  (130,145),( 3,26)( 6,27)( 9,28)( 13,29)( 21,30)( 24,31)( 33,66)
  ( 36,71)( 38,72)( 41,75)( 44,78)( 45,79)( 48,84)( 50,85)( 53,90)
  ( 55,91)( 58,94)( 61,97)( 62,98)( 65,103)( 70,104)( 73,105)( 83,106)
  ( 86,107)( 96,108)( 99,109),( 1,13)( 2,21)( 3,27)( 4,32)( 35,54)
  ( 36,59)( 38,60)( 41,62)( 42,63)( 45,65)( 47,67)( 48,68)( 51,70)
  ( 53,71)( 56,73)( 57,74)( 58,80)( 75,87)( 77,90)( 79,93)( 81,96)
  ( 83,99)( 85,102)( 86,104)( 89,105)( 92,107)( 95,108)( 98,110)(101,111),
 ( 1,8)( 5,25)( 9,34)(10,35)(11,38)(12,39)(13,41)(14,42)(15,43)(16,46)
  (18,49)(20,50)(21,53)(22,54)(24,55)(26,56)(44,87)(47,88)(57,90)(59,91),
 ( 1,5)( 2,11)( 3,15)( 6,20)( 9,24)(13,29)(25,37)(31,39),
 ( 1,2)( 4,9)( 5,10)( 7,11)(12,15)(13,16)(14,17),
 ( 1,3)( 6,8)(12,13)(22,23)(24,25)(29,30)(31,32),
 ( 1,2)(12,13)(14,16)(18,19)(21,22)(27,28)(38,39)(41,43)(44,46)(47,48)
  (52,53)(54,55)(58,59)(61,62)(65,67)(68,70)(74,76)(77,78)(80,81)(84,85)
  (88,89)(90,91)(93,94)(95,96)(98,99),( 2,7)( 3,12)( 6,20)(11,22)(13,23)
  (17,25)(19,26),( 1,12)( 2,16)( 3,19)( 4,23)( 29,40)( 30,43)
  ( 31,54)( 33,59)( 38,62)( 42,63)( 44,65)( 49,68)( 51,70)( 56,73)
  ( 57,74)( 58,83)( 75,92)( 78,96)( 81,100)( 84,104)( 87,108)( 90,112)
  ( 95,116)( 99,118)(103,119)(107,121)(111,122)(115,124),
 ( 1,2)( 4,9)( 6,11),( 2,7)( 3,11)( 6,19)(10,22)(16,24)(18,25)(21,27)
  (23,29),( 1,2)( 4,9)( 7,11)( 8,13)(10,15)(12,17)(14,18)(16,19),
 ( 3,24)( 5,25)( 8,26)(10,29)(13,30)(17,31)(18,32)(21,35)(23,36)(27,37)
  (33,38),( 1,12)( 2,15)( 3,18)( 4,23)( 9,34)(10,38)(11,41)(13,43)(16,49)
  (19,52)(22,56)(26,62)(27,63)(28,64)(31,72)(33,74)(35,76)(37,78)(40,80)
  (42,82)(44,83)(46,84)(48,85)(50,86)(53,87)(55,88)(57,89)(59,90)(61,91)
  (71,92)(73,93)(75,94)(77,95)(79,96)(81,97),
 ( 1,12)( 2,15)( 3,18)( 4,22)( 5,26)( 6,29)( 7,38)( 8,41)(10,42)(13,43)
  (17,47)(19,48)(21,49)(23,52)(25,53)(27,54)(31,55)(34,57)(35,58)(37,61)
  (39,62)(46,63)(50,66)(59,69)(65,70)(68,71),
 ( 3,24)( 5,25)( 8,26)(10,27)(13,30)(15,31)(18,32)(19,33)(23,35)(29,36)
  (34,38),( 1,12)( 2,15)( 3,18)( 4,21)( 5,24)( 6,26)( 7,30)( 8,33)( 9,35)
  (10,38)(14,40)(19,42)(23,46)(27,48)(28,49)(32,53)(36,57)(39,58)(41,61)
  (45,63)(47,64)(50,68)(52,69)(56,71)(59,73)(65,75),
 ( 1,12)( 2,15)( 3,18)( 4,21)( 5,23)( 6,27)( 7,30)( 8,32)( 9,37)(11,39)
  (16,41)(20,45)(24,47)(25,48)(29,52)(33,56)(35,57)(38,58)(40,61)(44,63)
  (46,64)(49,68)(51,69)(55,71)(59,73)(65,75),
 ( 3,23)( 4,27)( 7,28)(10,29)(12,30)(15,34)(17,35)(20,36)(22,37)(26,38)
  (33,39),( 1,12)( 2,15)( 3,18)( 4,19)( 5,25)(11,41)(13,42)(14,46)(17,48)
  (20,49)(21,51)(24,55)(26,57)(28,60)(29,62)(32,65)(34,67)(36,69)(38,71)
  (40,73)(44,74)(47,76)(52,77)(54,79)(58,80)(59,81)(61,82)(68,83)(72,84),
 ( 1,7)( 2,17)( 3,22)( 4,34)( 6,36)( 9,38)(10,40)(13,43)(15,46)(18,49)
  (19,51)(21,53)(24,56)(25,58)(27,61)(37,90)(41,91)(50,93)(54,94),
 ( 1,2)( 4,6)( 8,10)(13,15),( 1,7)( 2,17)( 3,22)( 4,28)( 5,31)( 6,36)
  ( 8,41)(10,42)(12,43)(14,46)(16,47)(19,50)(21,52)(24,54)(25,55)(27,56)
  (30,57)(32,60)(34,61)(38,63)(40,64)(44,65)(49,66)(51,69)(53,70)(58,71)
  (62,74)(68,75)(73,76),( 3,23)( 5,24)( 8,25)(10,29)(13,30)(17,31)(20,35)
  (22,36)(26,37)(27,38)(32,39)(33,40),( 1, 7)( 2,16)( 3,23)( 4,28)
  ( 5,30)( 35,48)( 36,59)( 41,60)( 42,61)( 45,62)( 50,64)( 51,65)
  ( 56,67)( 57,68)( 58,77)( 70,87)( 73,90)( 76,93)( 79,96)( 82,99)
  ( 85,102)( 86,104)( 89,106)( 92,107)( 95,109)( 98,110)(101,112),
 ( 1,2)( 4,6)( 9,11)(16,17)(20,21)(24,25),
 ( 3,23)( 5,24)( 8,25)(10,27)(13,30)(15,31)(17,32)(19,33)(22,37)(28,38)
  (35,39),( 1,12)( 2,14)( 3,18)( 4,20)( 5,24)( 6,26)( 7,31)
  ( 8,33)( 11,37)( 17,42)( 22,44)( 28,49)( 30,52)( 34,53)( 35,54)
  ( 36,56)( 38,59)( 39,61)( 40,64)( 43,66)( 45,69)( 46,71)( 47,72)
  ( 48,74)( 50,77)( 57,79)( 58,81)( 62,83)( 63,85)( 67,88)( 68,90)
  ( 75,95)( 78,96)( 82,98)( 86,100)( 87,102)( 91,104)( 92,105)( 93,106)
  ( 94,108)( 97,109)( 99,110)(103,112)(111,114)(113,115),
 ( 1,2)(12,13)(17,19)(23,24)(29,30)(34,35)(37,39)(41,42)(44,45)(46,47)
  (51,52)(53,54)(56,57)(60,61)(62,63),( 1,12)( 2,14)( 3,17)( 4,20)( 5,22)
  ( 6,27)( 7,28)( 8,31)( 9,35)(11,38)(15,40)(19,45)(23,49)(25,50)(32,57)
  (33,58)(37,59)(39,62)(43,64)(44,65)(48,66)(51,69)(55,71)(56,72)(60,74)
  (63,76)(67,77)(70,78),( 1,2)( 4,5)( 6,8)( 9,10)(11,13)(14,15)(16,18)
  (19,20)(23,24)(29,30)(32,33)(38,39)(41,42)(47,48),
 ( 2,7)( 3,8)( 4,9)( 6,11),( 1,12)( 2,14)( 3,17)( 4,20)( 5,22)( 6,25)
  ( 7,29)( 8,32)( 9,33)(11,37)(15,39)(19,42)(23,47)(27,51)(28,52)(35,58)
  (38,61)(40,62)(43,63)(44,64)(48,68)(50,69)(53,71)(56,72)(60,74)(65,76)
  (67,77)(73,79),( 1,2)( 4,5)( 6,7)( 8,9)(10,11)(13,14)(15,16)(17,18),
 ( 1,2)(12,13)(19,20)(22,23)(27,28)(30,31)(34,35)(37,38)(39,40)(42,43)
  (44,45)(47,48)(53,54)(55,56)(58,59)(60,61)(63,64)(65,66)(68,69)(73,74)
  (78,79)(80,81)(83,84)(85,86)(88,89)(91,92)(94,95),
 ( 1,2)( 4,5)( 6,7)( 8,9)(11,12)(13,14)(15,16)(17,18)(20,21)(22,23)
  (24,25)(26,27)(29,30)(39,40)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52)
  (53,54)(55,56)(58,59)(60,61)(79,80)(81,82)(83,84)(86,87)(88,89)(90,91),
 ( 2,5)( 7,9)( 8,11)(10,13)(12,14),( 1,2)( 4,5)( 6,7)( 8,9)(11,12),
 ( 3,22)( 5,23)( 8,26)(10,29)(13,30)(16,31)(19,34)(21,35)(25,36)(28,37)
  (33,40)(39,43)(42,44),( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(13,14)(15,16)
  (18,19)(20,21)(22,23),( 1, 2)( 4, 5)( 6, 7)( 9,10)( 11,12)
  ( 13,14)( 16,17)( 19,20)( 21,22)( 23,24)( 25,26)( 28,29)( 41,42)
  ( 43,44)( 46,47)( 49,50)( 52,53)( 54,55)( 57,58)( 59,60)( 62,63)
  ( 66,67)( 68,69)( 72,73)( 74,75)( 78,79)( 81,82)( 84,85)( 87,88)
  ( 92,93)( 95,96)( 98,99)(101,102)(104,105)(107,108)(109,110)(112,113)
  (115,116)(118,119)(121,122)(124,125),( 1,12)( 2,13)( 4,16)( 5,19)( 6,20)
  ( 8,21)( 9,24)(10,27)(14,28)(17,29)(22,30)(25,31),
 ( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(14,15)(17,18)(19,20)(22,23)(24,25)
  (27,28)(29,30)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(56,57)(59,60)
  (62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)
  (92,93)(94,95),( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(14,15)(17,18)(19,20)
  (22,23)(24,25)(27,28)(29,30)(40,41)(43,44)(46,47)(48,49)(51,52)(54,55)
  (57,58)(59,60)(61,62)(65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)
  (85,86)(89,90)(91,92)(95,96),( 3,21)( 5,30)( 6,36)( 7,42)( 9,44)(11,48)
  (16,50)(20,52)(23,53)(25,55)(27,59)(29,60)(35,62)(40,64)(43,65)(47,66)
  (49,67)(54,68)(58,69)(61,70),( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(14,15)
  (17,18)(20,21)(25,26)(27,28)(34,35)(36,37)(41,42)(43,44),
 ( 1,17)( 2,20)( 3,23)( 4,31)( 5,35)( 36,45)( 39,57)( 40,58)
  ( 42,61)( 46,63)( 47,66)( 51,68)( 52,69)( 54,71)( 55,80)( 72,89)
  ( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)( 88,102)( 90,103)( 92,106)
  ( 94,107)( 96,110)( 98,111),( 1,2)( 4,5)( 6,7)( 9,10)(11,12),
 ( 1,12)( 3,21)( 6,41)( 7,43)(13,45)(15,46)(17,50)(19,52)(22,53)(26,55)
  (31,57)(33,61)(35,63)(37,64)(44,65)(47,66)(51,67)(56,68)(58,69)(62,70),
 ( 3,20)( 5,21)( 8,24)(10,27)(11,30)(14,31)(18,36)(19,39)(25,40)(28,41)
  (34,42)(37,43),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)(15,16)(17,18)(20,21)
  (22,23)(25,26)(28,29)(30,31)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)
  (56,57)(59,60)(62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)
  (86,87)(88,89)(92,93)(94,95),( 1,5)( 2,9)( 3,11)( 8,24)(13,26),
 ( 1, 2)( 4, 5)( 6, 7)( 9,10)( 13,14)( 16,17)( 18,19)( 20,21)
  ( 22,23)( 25,26)( 28,29)( 30,31)( 40,41)( 42,43)( 45,46)( 48,49)
  ( 51,52)( 53,54)( 57,58)( 59,60)( 63,64)( 65,66)( 69,70)( 72,73)
  ( 74,75)( 77,78)( 80,81)( 83,84)( 86,87)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)
  (125,126),( 3,19)( 6,24)( 9,29)(12,33)(15,38)(16,40)(18,41)(21,42)(23,43)
  (26,45)(28,47)(31,48)(35,49)(37,51)(44,52)(50,53),
 ( 1,2)( 4,5)( 6,7)(10,11)(13,14)(17,18),
 ( 1,17)( 2,18)( 4,20)( 5,21)( 7,22)( 8,24)(11,25)(12,27)(14,28)(15,29),
 ( 1,3)( 8,10)(12,13)(14,15)(16,17)(19,20)(21,22),
 ( 1,4)( 2,9)( 8,23)(13,24)(15,25)(18,26)(21,27),
 ( 1,2)( 4,5)( 6,7)(10,11)(22,23)(26,27)(29,30),
 ( 1,2)( 4,5)( 7,8)( 9,11)(12,13)(14,16)(17,18)(19,21)(23,24)(26,27)
  (32,33)(35,36)(41,42)(44,45),( 1,7)( 2,13)( 3,19)( 4,24)( 5,27)( 6,33)
  ( 9,39)(12,41)(14,42)(17,44)(18,45)(20,47)(23,49)(25,50)(28,53)(30,54)
  (32,56)(36,58)(38,60)(40,62)(43,63)(46,65)(48,66)(51,69)(57,71)(59,73)
  (61,74)(64,78)(67,79)(72,82)(75,83)(77,85)(81,88)(86,91)(89,93),
 ( 2,3)( 7,8)(14,15)(20,21)(22,23)(26,27)(29,30),
 ( 2,7)( 4,11)(12,17)(15,32)(25,34)(28,39)(30,45)(36,48)(38,50)(40,52)
  (42,54)(44,56)(46,58)(49,60)(53,62)(57,64),
 ( 2,3)( 7,8)(14,15)(21,22)(25,26)(28,29)(31,32),
 ( 1,3)( 8,10)(14,15)(17,18)(20,21)(22,23)(24,25),
 ( 3,18)( 5,19)( 8,21)(10,22)(12,24)(15,25),
 ( 1,7)( 2,13)( 3,17)( 4,20)( 8,23)(16,29)(24,35)(30,37),
 ( 2,3)( 7,8)(17,18)(20,21)(23,24)(27,28)(30,31),
 ( 1,4)( 2,8)( 3,16)(10,22)(15,25)(18,29)(21,33)(24,37),
 ( 2,15)( 3,18)( 4,23)( 5,25)( 6,27)( 7,32)( 8,34)(13,43)(16,44)(17,45)
  (20,46)(21,47)(24,48)(26,49)(29,50)(30,51)(33,52)(36,53)(37,54)(38,55)
  (39,57)(40,58)(41,60)(42,61)(56,63)(59,64)(62,65),
 ( 3,17)( 4,18)( 6,21)( 8,22)(11,23)(12,24)(14,27)(16,28)(19,40)(25,41)
  (30,42)(37,51)(44,61)(50,63),( 3,17)( 4,18)( 6,19)( 8,22)(10,23)(12,24)
  (13,25)(16,27)(21,43)(26,45)(29,47)(33,48)(40,52),
 ( 1,2)( 4,5)( 7,8)(10,11)(12,13)(15,16)(17,18)(20,21)(24,25)(26,27)
  (31,32)(33,34)(40,41)(42,43),( 2, 5)( 10,12)( 17,20)( 21,23)
  ( 28,30)( 39,41)( 45,47)( 48,50)( 53,55)( 57,59)( 62,63)( 65,66)
  ( 67,68)( 69,70)( 72,73)( 74,75)( 76,77)( 79,81)( 86,88)( 94,95)
  ( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107)(108,109)(110,111)
  (112,113)(114,115)(116,117),( 1,7)( 2,12)( 3,23)(10,24)(13,27)(18,28)
  (21,31),( 1,12)( 4,23)( 6,31)( 8,38)(10,40)(13,44)(16,48)(18,49)(21,50)
  (26,54)(27,56)(30,60)(34,61)(37,62)(43,63)(47,65)(53,66)(59,68),
 ( 3,17)( 5,18)( 6,20)( 8,22)(11,23)(13,24)(14,26)(16,28)(19,40)(25,41)
  (30,42)(35,49)(48,63)(58,65),( 1,12)( 4,20)( 5,25)( 7,31)
  ( 11,36)( 14,39)( 16,40)( 21,43)( 24,46)( 27,47)( 30,51)( 33,52)
  ( 35,55)( 41,63)( 45,68)( 48,73)( 54,80)( 56,81)( 60,82)( 65,87)
  ( 70,91)( 74,95)( 83,101)( 88,105)( 92,107)( 96,109)(102,111),
 ( 1,4)( 2,8)( 3,12)( 7,22)(14,28)(17,31)(21,33)(27,36),
 ( 3,17)( 6,23)(10,30)(13,33)(15,34)(16,36)(19,38)(21,41)(22,42)(25,46)
  (27,48)(28,50)(31,53)(32,56)(40,58)(45,60)(52,62)(55,64),
 ( 1,2)( 4,5)( 7,8)(10,11)(13,14)(17,18),( 1,2)( 7,8)(14,15)(20,21),
 ( 2,15)( 5,28)( 7,36)( 8,44)( 9,45)(12,47)(16,49)(19,50)(22,51)(25,52)
  (29,54)(31,55)(33,57)(37,58)(40,59)(46,60)(53,61),
 ( 1,10)( 3,11)( 5,13)( 7,15)(18,26)(19,32),( 2,3)( 4,5)(14,15)(19,20),
 ( 1,12)( 7,17)( 13,32)( 16,34)( 18,36)( 20,37)( 23,46)( 24,51)
  ( 26,54)( 28,61)( 29,62)( 30,63)( 33,64)( 39,77)( 40,80)( 42,82)
  ( 43,83)( 44,85)( 45,86)( 48,88)( 49,91)( 52,93)( 53,94)( 56,96)
  ( 57,97)( 58,99)( 59,100)( 66,103)( 67,106)( 68,109)( 69,113)( 71,115)
  ( 72,121)( 73,124)( 75,126)( 78,130)( 79,131)( 89,133)( 90,134)(102,138)
  (105,143)(108,146)(112,149)(118,154)(120,157)(123,160)(141,177)(152,180),
 ( 3,17)( 6,18)( 10,20)( 16,22)( 19,38)( 23,39)( 25,41)( 26,42)
  ( 27,44)( 30,47)( 31,49)( 32,50)( 33,51)( 34,53)( 36,55)( 37,57)
  ( 43,66)( 46,67)( 52,68)( 56,69)( 58,70)( 60,71)( 62,75)( 63,77)
  ( 65,81)( 72,88)( 74,89)( 76,90)( 78,91)( 80,92)( 82,93)( 84,94)
  ( 85,95)( 86,97)( 87,99)( 96,101)( 98,102)(100,103),
 ( 1,17)( 4,30)( 5,39)( 7,42)( 9,44)(11,47)(12,48)(14,51)(16,53)(21,54)
  (26,58)(29,59)(32,62)(34,64)(38,65)(50,66)(52,67)(61,68)(63,69),
 ( 1,3)( 8,9)(15,17)(19,21)(24,26)(27,28)(31,33)(35,36),
 ( 1,11)( 2,25)( 3,28)( 4,33)(34,44)(35,47)(36,59)(37,62)(40,68)(41,70)
  (45,73)(46,74)(50,75)(51,77)(55,80)(56,81)(60,82)(61,84)(65,87)(66,88),
 ( 1, 2)( 4, 5)( 8, 9)( 11,12)( 13,14)( 15,16)( 17,18)( 20,21)
  ( 23,24)( 25,26)( 27,28)( 30,31)( 40,41)( 42,43)( 45,46)( 48,49)
  ( 51,52)( 53,54)( 57,58)( 59,60)( 63,64)( 65,66)( 69,70)( 72,73)
  ( 74,75)( 77,78)( 80,81)( 83,84)( 86,87)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)
  (125,126),( 1, 7)( 2,12)( 3,18)( 4,24)( 5,27)( 6,33)( 8,35)
  ( 11,37)( 14,40)( 15,43)( 17,45)( 19,48)( 21,50)( 23,52)( 26,57)
  ( 28,59)( 31,62)( 34,65)( 39,68)( 42,70)( 44,72)( 46,73)( 51,76)
  ( 54,79)( 56,81)( 58,83)( 60,84)( 61,86)( 63,87)( 66,89)( 71,92)
  ( 74,93)( 77,95)( 82,98)( 88,100)( 90,102)( 91,104)( 94,106)( 96,108)
  ( 97,110)( 99,112)(101,114)(105,116)(107,118),
 ( 2,4)( 5,18)( 7,19)(10,21)(12,23)(13,26)(15,28)(17,31)(24,36)(29,38),
 ( 3,16)( 5,27)( 6,36)( 7,41)( 9,42)(11,45)(12,49)(14,50)(17,51)(18,54)
  (22,55)(24,56)(28,62)(31,63)(33,64)(37,67)(52,68)(65,69),
 ( 3,16)( 5,25)( 6,34)( 8,37)( 10,39)( 11,40)( 12,43)( 14,45)
  ( 15,47)( 17,48)( 19,51)( 20,52)( 21,54)( 24,56)( 33,73)( 35,74)
  ( 44,76)( 46,79)( 49,80)( 55,82)( 57,85)( 75,102)( 81,103),
 ( 1,11)( 2,20)( 4,31)(10,41)(14,44)(16,45)(19,46)(23,52)(25,53)(29,54)
  (30,57)(33,58)(35,59)(36,63)(38,66)(40,67)(43,68)(56,69),
 ( 1,2)( 4,5)( 8,9)(17,18)(20,21),( 1,2)( 4,5)( 8,9)(20,21)(24,25)
  (27,28)(31,32)(44,45)(46,47)(48,49)(53,54)(59,60)(61,62)(68,69)(74,75)
  (76,77)(82,83)(84,85)(86,87)(88,89)(91,92),
 ( 3,16)( 5,20)( 6,25)( 8,30)( 9,51)(11,53)(12,55)(14,56)(18,57)(21,59)
  (23,61)(26,62)(28,63)(32,64)(38,65)(45,66)(54,67)(60,68),
 ( 3,16)( 5,20)( 6,25)( 8,30)( 9,43)(11,45)(12,47)(14,48)(18,49)(21,51)
  (23,53)(26,54)(28,55)(32,57)(35,65)(46,75)(52,76)(64,78)(73,80),
 ( 3,16)( 6,28)( 7,29)( 12,32)( 19,37)( 21,40)( 24,48)( 27,56)
  ( 31,65)( 33,68)( 35,70)( 36,71)( 39,82)( 41,85)( 42,88)( 45,90)
  ( 46,93)( 47,96)( 49,99)( 50,102)( 52,105)( 54,108)( 55,110)( 57,113)
  ( 58,116)( 60,119)( 61,120)( 62,121)( 63,122)( 67,127)( 69,128)( 72,132)
  ( 80,152)( 84,154)( 86,156)( 92,158)( 94,160)( 98,162)(100,164)(104,166)
  (106,168)(112,170)(114,172)(118,174)(123,179)(124,180)(129,181)(130,182)
  (135,183)(137,184)(139,187)(141,190)(143,191)(145,194)(147,197)(149,198)
  (151,201)(186,210)(189,211)(193,212)(196,213)(200,214)(203,215),
 ( 1,7)( 2,12)( 3,15)(18,36)(20,37)(24,38)(26,39)(30,40)(33,41),
 ( 3,15)( 4,19)( 6,25)( 7,31)( 9,32)( 11,35)( 12,36)( 16,39)
  ( 17,41)( 20,43)( 21,45)( 23,46)( 33,76)( 37,77)( 40,79)( 47,80)
  ( 49,82)( 52,90)( 57,93)( 61,95)( 65,99)( 70,102)( 78,106)( 81,108)
  ( 97,115)(104,117),( 1,11)( 2,18)( 3,22)( 4,36)( 6,37)( 8,40)
  ( 13,44)( 15,45)( 17,47)( 21,48)( 26,52)( 27,53)( 39,67)( 43,69)
  ( 50,74)( 51,77)( 56,81)( 60,85)( 64,94)( 68,104)( 73,106)( 76,107)
  ( 98,125)(103,130)(105,131)(109,132)(111,135)(113,137)(115,139)(118,142)
  (120,144)(122,146)(124,148),( 3,15)( 4,19)( 6,23)( 8,28)( 9,43)(12,44)
  (14,47)(17,48)(18,49)(22,50)(25,53)(27,54)(34,60)(39,67)(46,71)(52,72)
  (56,76)(59,78)(64,80)(65,81)(75,87)(79,88),
 ( 1,2)( 4,5)( 9,10)(12,13)(14,15)(16,17)(19,20)(21,22)(23,24),
 ( 1,2)( 4,5)( 9,10)(12,13)(18,19)(25,26)(30,31)(33,34)(40,41)(42,43)
  (45,46)(47,48)(50,51)(54,55)(58,59)(61,62)(63,64)(66,67)(70,71)(73,74)
  (77,78)(81,82)(84,85)(88,89),( 3,15)( 4,16)( 8,19)( 9,20)(10,23)(14,24),
 ( 3,15)( 4,16)( 9,20)( 13,22)( 14,24)( 17,39)( 18,40)( 21,41)
  ( 26,43)( 28,45)( 30,48)( 31,50)( 33,52)( 35,54)( 36,56)( 38,59)
  ( 46,67)( 57,70)( 71,85)( 74,88)( 76,90)( 78,92)( 80,94)( 83,97)
  ( 86,105)( 89,106)( 91,107)( 93,108)( 95,109)( 98,110),
 ( 2,14)( 4,20)( 9,35)(10,36)(16,41)(17,42)(19,45)(21,46)(22,47)(26,52)
  (28,53)(30,54)(32,57)(38,61)(44,65)(49,68)(51,69)(56,72)(58,73)(60,74)
  (62,75)(67,77)(76,79)(78,80),( 1,2)( 4,5)( 9,10)(12,13),
 ( 1,2)( 4,5)( 9,10)(14,16)(17,19)(20,22)(27,29)(31,33),
 ( 1,4)( 2,7)( 5,8)(10,12)(11,14),( 1,2)( 4,5)( 9,10)(25,26)(30,31)
  (35,36)(39,40)(41,42)(43,44)(47,48)(49,50),
 ( 1,11)( 2,17)( 3,21)( 6,23)( 7,25)(12,29)(15,31),
 ( 1,2)( 4,5)(10,11)(12,13)(14,15)(16,17)(19,20)(21,22)(23,24),
 ( 1,16)( 2,17)( 3,19)( 4,21)( 5,22)( 6,24)( 7,26)( 8,27)( 9,29)(10,31)
  (11,32)(12,33)(13,35)(14,36)(15,38),( 1,5)( 2,6)( 3,8)( 9,13)(11,14),
 ( 1,11)( 2,17)( 3,20)( 4,25)( 5,28)( 6,33)( 7,36)( 8,40)(10,41)(12,44)
  (14,46)(16,48)(18,49)(22,50)(24,53)(27,55)(30,57)(31,59)(35,60)(38,61)
  (42,63)(45,64)(51,66)(56,67),( 1,11)( 2,17)( 3,20)( 4,23)( 5,28)( 6,31)
  ( 7,34)( 8,36)( 9,37)(14,41)(15,43)(19,46)(21,48)(22,49)(25,54)(26,55)
  (30,57)(32,59)(38,65)(39,66)(42,68)(47,69)(50,72)(52,73)(53,74)(58,77)
  (62,78)(64,79)(71,81),( 2,14)( 5,15)( 6,20)( 7,21)(10,26)(11,27),
 ( 1,2)( 4,5)(10,11)(15,16)(19,20)(23,24),
 ( 1,12)( 2,18)( 3,21)( 4,26)( 5,27)(11,33)(13,42)(14,43)(17,46)(19,49)
  (22,52)(24,53)(25,54)(28,60)(29,62)(32,66)(34,67)(36,70)(38,71)(40,74)
  (45,75)(48,76)(51,77)(56,78)(58,79)(59,80)(61,81)(69,82)(73,83),
 ( 1,2)( 4,5)(10,11)(16,17)(18,19),( 1,11)( 2,16)( 3,26)( 5,37)
  ( 7,39)( 9,40)( 12,42)( 13,45)( 15,46)( 17,49)( 19,50)( 21,52)
  ( 22,54)( 27,56)( 47,76)( 48,79)( 57,82)( 58,85)( 59,86)( 75,101)
  ( 81,102),( 3,14)( 5,19)( 6,23)( 8,28)( 9,49)(10,50)(12,52)(16,53)(18,54)
  (20,55)(22,57)(25,59)(27,60)(31,62)(36,64)(43,66)(51,68)(56,70),
 ( 1,11)( 2,16)( 3,24)( 5,25)(10,27)(15,28)(21,30),
 ( 3,14)( 5,18)( 6,23)( 8,28)( 9,42)(10,44)(12,46)(16,47)(19,48)(21,50)
  (24,52)(26,53)(29,54)(38,70)(45,75)(51,76)(56,77)(60,79)(65,80)(69,82),
 ( 3,14)( 5,17)( 8,23)( 9,26)(11,46)(15,47)(16,48)(20,49)(24,50)(25,51)
  (30,52)(31,55)(34,58)(36,59)(37,62)(40,65)(41,66)(42,69)(45,72),
 ( 3,14)( 5,17)(12,20)(16,40)(22,42)(23,44)(25,46)(27,48)(28,50)(29,51)
  (30,53)(32,55)(34,57)(35,59)(36,60)(37,62)(39,65)(45,75)(47,76)(49,78)
  (54,79)(56,80)(58,82)(63,83)(64,85)(67,87)(68,88)(70,90)(71,91)(73,93)
  (74,94)(86,95)(89,96)(92,97),( 1,11)( 2,16)( 3,21)( 4,24)( 5,30)( 6,35)
  ( 7,39)(12,40)(15,42)(17,45)(20,47)(22,49)(25,51)(27,54)(29,55)(32,57)
  (34,60)(37,61)(38,63)(41,65)(43,66)(46,68)(48,70)(50,73)(53,74)(56,75)
  (58,76)(62,77)(64,80)(67,81)(69,84)(72,85)(79,86)(83,87),
 ( 1,4)( 2,6)( 5,10)( 9,13)(12,14),( 1,15)( 2,24)( 3,33)( 5,43)( 6,44)
  ( 8,48)(12,49)(14,50)(16,52)(18,53)(20,57)(22,58)(25,59)(28,61)(30,62)
  (32,63)(34,67)(37,68)(39,69)(42,71)(45,73)(47,74)(51,76)(54,77)(56,78)
  (60,80)(64,82)(66,83)(70,85)(72,87)(75,88)(79,90)(81,92)(84,93)(86,95)
  (89,96)(91,97)(94,98),( 2,13)( 3,17)( 5,23)( 7,31)( 9,34)
  ( 10,35)( 14,38)( 15,40)( 18,42)( 19,44)( 21,45)( 25,49)( 32,76)
  ( 36,77)( 39,79)( 46,80)( 48,82)( 52,90)( 57,93)( 61,95)( 65,99)
  ( 70,102)( 78,106)( 81,108)( 97,115)(104,117),
 ( 2,13)( 3,17)( 6,27)( 8,33)( 9,34)( 12,37)( 16,40)( 18,42)
  ( 21,44)( 24,46)( 25,49)( 28,51)( 31,52)( 36,60)( 43,68)( 47,71)
  ( 56,79)( 58,80)( 66,85)( 75,93)( 84,98)( 89,102)( 92,103)( 97,105)
  (101,107),( 1,4)( 2,6)( 7,11)( 8,12)(10,13),
 ( 1,3)(10,12)(14,16)(17,19),( 2,4)( 6,21)( 8,24)(11,27)(13,29)(15,32)
  (17,34)(18,35)(20,36)(25,38)(30,40),( 3,13)( 4,16)( 6,19)( 8,22)( 9,25)
  (11,28),( 3,13)( 4,16)( 7,22)( 9,25)(14,45)(15,46)(19,47)(23,48)(24,49)
  (28,50)(29,51)(32,53)(34,56)(36,59)(38,62)(39,64)(42,66)(44,69)(71,77)
  (73,78)(75,79),( 1,2)( 4,5)(17,18)(20,21)(26,27)(28,29)(31,32)(33,34)
  (36,37)(38,39)(42,43)(46,47)(49,50)(51,52)(55,56)(57,58),
 ( 1,7)( 2,10)( 3,17)( 4,21)( 5,26)( 6,29)( 9,37)(12,38)(14,43)(16,44)
  (19,45)(23,47)(25,48)(28,49)(31,54)(33,57)(34,59)(36,60)(39,63)(40,66)
  (42,68)(46,69)(50,72)(51,75)(53,77)(56,78)(58,81)(61,82)(65,83)(67,86)
  (70,87)(74,88)(76,91)(79,92)(84,93)(89,94),( 2,4)( 6,10)( 8,11),
 ( 3,13)( 5,16)( 6,19)( 7,22)(12,24)(14,25)(21,27)(23,29),
 ( 1, 7)( 2,10)( 3,16)( 4,18)( 5,22)( 6,25)( 9,33)( 13,38)
  ( 15,40)( 21,43)( 24,44)( 27,50)( 30,55)( 32,58)( 34,59)( 35,62)
  ( 36,65)( 37,67)( 41,70)( 42,71)( 45,74)( 47,76)( 48,79)( 49,81)
  ( 52,84)( 54,85)( 56,87)( 57,88)( 61,90)( 64,91)( 66,93)( 68,94)
  ( 69,95)( 73,97)( 75,98)( 78,99)( 80,101)( 82,102)( 83,103)( 86,104)
  ( 89,105)( 92,106)( 96,107)(100,108),( 2,13)( 4,21)( 5,26)( 8,35)( 9,36)
  (14,39)(18,41)(19,44)(24,45)(27,48)(29,49)(31,50)(34,53)(38,59)(46,67)
  (52,75)(56,76)(58,79)(63,81)(65,82)(72,85)(80,91)(84,95),
 ( 1,11)( 2,15)( 3,18)( 4,20)( 5,24)( 6,27)( 7,29)( 8,33)( 9,36)(12,38)
  (16,40)(21,44)(22,46)(25,48)(30,51)(34,54)(37,56)(42,59)(43,61)(47,64)
  (49,66)(52,67)(55,70)(57,72)(58,73)(63,76)(69,79)(74,82)(75,83)(78,85)
  (84,88)(86,90),( 1,11)( 2,15)( 3,18)( 4,19)( 5,23)( 6,26)( 7,28)( 8,33)
  ( 9,35)(12,37)(16,39)(21,43)(24,48)(29,52)(30,53)(34,56)(36,59)(41,61)
  (44,62)(46,63)(49,67)(51,68)(54,69)(57,70)(60,73)(64,77)(66,78)(72,81)
  (76,82),( 1, 7)( 2,10)( 3,14)( 4,21)( 5,27)( 32,40)( 33,56)
  ( 38,58)( 39,60)( 44,62)( 47,66)( 48,67)( 53,70)( 54,78)( 55,87)
  ( 71,89)( 74,92)( 77,95)( 80,98)( 83,101)( 86,104)( 91,109)( 94,111)
  ( 97,115)(100,117)(103,121)(106,123),( 3,12)( 4,16)( 6,24)( 20,30)
  ( 27,50)( 28,57)( 32,71)( 33,73)( 34,76)( 35,78)( 36,80)( 37,85)
  ( 38,87)( 39,91)( 40,93)( 41,96)( 42,101)( 43,103)( 44,106)( 45,108)
  ( 46,109)( 47,111)( 52,116)( 53,117)( 56,120)( 59,124)( 61,134)( 64,144)
  ( 66,151)( 67,153)( 69,154)( 70,156)( 74,161)( 75,163)( 81,166)( 82,168)
  ( 83,169)( 84,171)( 88,174)( 89,176)( 94,181)( 95,183)( 98,184)( 99,186)
  (104,189)(105,191)(112,200)(113,201)(115,203)(118,205)(119,206)(122,209)
  (123,211)(127,214)(128,216)(131,219)(132,221)(133,223)(137,226)(138,228)
  (140,231)(141,233)(143,235)(147,238)(148,240)(150,243)(158,245)(159,247)
  (164,249)(165,251)(172,253)(173,255)(178,256)(179,258)(187,260)(188,262)
  (192,263)(193,265)(204,278)(208,279)(213,280)(218,282)(225,284)(230,286)
  (237,288)(242,290),( 3,12)( 4,13)( 5,15)( 6,16)( 7,17)( 8,19)
  ( 9,22)( 11,31)( 14,35)( 18,41)( 21,45)( 25,50)( 26,53)( 27,57)
  ( 28,59)( 29,62)( 30,64)( 32,66)( 34,67)( 36,69)( 38,71)( 40,72)
  ( 42,74)( 44,75)( 46,77)( 48,79)( 52,84)( 54,86)( 56,88)( 58,90)
  ( 61,92)( 63,94)( 80,95)( 81,96)( 82,97)( 83,98)( 85,99)( 87,100)
  ( 89,101)( 91,102)( 93,103),( 3,12)( 5,20)( 6,25)( 8,32)( 10,35)
  ( 11,36)( 14,40)( 15,41)( 16,44)( 17,47)( 19,48)( 21,49)( 22,51)
  ( 30,72)( 31,73)( 33,76)( 38,78)( 39,79)( 42,83)( 45,84)( 74,104)
  ( 80,106),( 1,2)( 5,10)(11,14)(12,15),
 ( 2,13)( 4,17)( 5,21)( 8,29)( 9,46)(11,47)(14,50)(18,51)(19,52)(22,53)
  (24,56)(27,57)(34,61)(38,63)(43,68)(48,70)(54,71)(62,78)(64,79)(69,80),
 ( 1,2)( 5,9)( 8,10),( 1,2)( 5,9)(11,14)(13,15),
 ( 3,12)( 5,14)( 7,16)( 9,17)(18,20)(19,26),
 ( 1,7)( 2,10)( 3,12)( 4,15)( 5,17),( 3,12)( 5,13)( 7,15)( 9,17)(18,21)
  (19,27),( 1,7)( 2,10)( 4,14)( 5,16)( 9,17)(11,18)(13,19)(15,20),
 ( 3,12)( 6,13)( 8,15)(10,17)(11,19)(14,22)(16,24),
 ( 2,13)( 4,15)( 5,16)( 7,19)( 8,20)(10,22)(11,23)(12,26)(14,27)(18,28)
  (21,29)(25,30),( 2,4)( 6,8)(10,12)(17,18)(24,25)(29,30)(33,34)(38,39)
  (42,43)(47,48),( 3,11)( 4,16)( 6,34)( 9,37)( 13,39)( 15,42)
  ( 17,43)( 18,45)( 21,48)( 22,50)( 24,52)( 26,55)( 33,78)( 36,79)
  ( 38,80)( 41,82)( 44,83)( 47,84)( 49,85)( 54,87)( 58,93)( 62,96)
  ( 64,97)( 69,100)( 73,103)( 75,104),( 1,2)( 5,7)(10,12)(15,17)(19,21)
  (23,25),( 3,11)( 4,12)( 5,14)( 6,17)( 7,18)( 8,22)( 9,24)(20,28)(25,30)
  (26,32)(27,34),( 1,11)( 2,13)( 3,17)( 4,21)( 5,27)( 6,30)( 7,33)( 8,35)
  ( 9,37)(18,44)(23,48)(25,51)(29,53)(31,54)(38,57)(39,58)(40,59)(41,60)
  (42,62)(43,63)(46,65)(47,67)(49,68)(50,69)(52,71)(55,74)(56,76)(64,79)
  (72,84)(73,85)(77,88)(78,89)(80,90)(81,92)(82,93)(83,94)(86,95)(87,96)
  (91,97),( 2,4)( 6,8)(10,12)(18,19)(26,27)(29,30)(32,33)(35,36),
 ( 3,11)( 5,31)( 7,33)( 8,38)( 10,39)( 12,41)( 13,43)( 14,44)
  ( 16,45)( 17,48)( 18,52)( 20,53)( 21,54)( 22,57)( 24,59)( 32,77)
  ( 35,79)( 36,80)( 40,83)( 47,85)( 49,86)( 56,89)( 82,106)( 88,107),
 ( 1,44)( 3,45)( 6,47)( 8,48)(10,50)(12,52)(15,54)(17,56)(19,58)(21,59)
  (23,61)(25,62)(27,64)(29,65)(31,67)(33,69)(35,71)(37,73)(40,75)(42,76),
 ( 1,4)( 3,9)(11,19)(17,33)(21,35)(29,44)(31,50)(39,51)(41,53)(43,55)
  (45,57)(47,59)(49,61)(54,64)(58,66)(62,68),
 ( 1,4)( 3,9)(11,17)(15,32)(19,34)(29,44)(31,50)(39,51)(41,53)(43,55)
  (45,57)(47,59)(49,61)(54,64)(58,66)(62,68),
 ( 1,43)( 4,44)( 7,45)( 8,48)(11,51)(13,53)(16,54)(19,56)(20,60)(23,61)
  (26,62)(28,65)(31,68)(32,70)(35,71)(37,73)(40,74)(42,76)(47,78)(50,79)
  (59,81)(64,83)(67,84),( 3,11)( 5,14)( 6,17)( 8,20)( 9,22)(16,23),
 ( 3,11)( 5,14)( 6,16)( 8,17)(13,19),( 1,2)( 5,6)( 7,8)(10,11)(12,13)
  (16,17)(19,20),( 3,11)( 5,13)( 7,15)( 9,16)(12,17),
 ( 1,2)( 5,6)( 7,8)(10,11)(14,15)(19,20),
 ( 2,4)( 6,8)(11,13)(16,18)(21,22),( 1,11)( 3,18)( 5,27)( 6,34)(12,45)
  (15,46)(19,47)(23,48)(25,50)(28,52)(31,53)(35,54)(38,55)(41,56)(44,59)
  (51,60)(58,61),( 1,2)( 5,6)( 8,10)(12,13)(14,16)(17,18)(20,22)(23,25)
  (26,27)(28,30)(31,33)(35,36)(37,39)(40,41)(43,45)(46,48)(49,50)(51,53),
 ( 1,8)( 2,12)( 3,15)( 4,19)( 9,23)(18,31)(28,38)(33,40)(36,41),
 ( 1,41)( 4,45)( 7,47)( 8,48)(11,50)(13,53)(16,56)(17,57)(20,59)(22,60)
  (25,64)(28,66)(29,67)(32,69)(35,72)(37,73)(40,75)(42,76)(51,77)(54,79)
  (61,81)(70,83)(80,85)(84,86),( 1,41)( 4,45)( 8,47)(11,49)(13,53)(16,54)
  (20,56)(22,59)(25,62)(29,64)(32,65)(36,67)(38,69)(42,70)(46,72)(48,73)
  (50,74)(51,75)(55,79)(57,80)(60,82)(63,83)(66,84)(68,87)(71,88)(76,89)
  (77,90)(81,92)(85,93)(91,95)(94,96),( 1,2)( 5,6)( 8,9)(12,13)(22,23)
  (25,26)(29,30)(45,46)(48,49)(54,55)(56,57)(63,64)(66,67)(70,71)(72,73)
  (75,76)(79,80)(81,82)(85,86),( 2,4)( 6,8)(13,14)(19,21)(23,25)(26,28)
  (40,41)(43,45)(49,51)(53,54)(55,56)(60,61)(63,65)(69,70)(71,72)(74,76)
  (78,80)(81,83)(84,86)(87,89)(90,92)(93,95)(96,98),
 ( 2,4)( 6,8)(13,14)(19,21)(23,24)(28,29)(31,32)(35,36),
 ( 1,11)( 3,16)( 4,21)( 6,25)(10,42)(13,43)(15,44)(18,46)(20,48)(23,49)
  (27,50)(29,52)(30,54)(34,59)(45,75)(51,76)(60,77)(64,79)(69,80)(73,82),
 ( 1,7)( 2,9)( 4,12)(10,18)(15,20),( 1,11)( 3,16)( 5,21)( 8,28)( 9,45)
  (12,46)(14,47)(17,48)(19,51)(22,52)(25,53)(26,54)(29,57)(38,67)(43,70)
  (49,72)(55,73)(61,74)(76,79)(78,80),( 1,2)( 5,6)( 8,9)(18,19)(22,23)
  (25,26)(29,30)(44,45)(47,48)(52,53)(54,55)(56,57)(62,63)(65,66)(70,71)
  (72,73)(79,80)(85,86),( 1,11)( 3,16)( 6,24)( 7,28)(10,45)(13,46)(15,47)
  (18,50)(20,51)(22,52)(23,53)(27,55)(30,56)(33,58)(38,65)(49,71)(54,73)
  (63,77)(69,80),( 3,11)( 7,14)( 8,16)( 9,18)(10,19)(12,21)(13,23),
 ( 3,11)( 7,13)( 8,14)( 9,15)(10,16)(12,17),
 ( 1,11)( 3,15)( 5,19)( 8,27)(10,48)(13,51)(14,52)(18,53)(21,54)(23,57)
  (24,58)(26,59)(29,60)(33,63)(38,65)(44,69)(50,71)(56,72),
 ( 1,14)( 2,17)( 3,21)( 4,25)( 5,33)( 6,34)( 8,36)( 9,37)
  ( 13,43)( 16,47)( 18,48)( 22,51)( 24,52)( 27,56)( 30,57)( 31,59)
  ( 35,60)( 38,62)( 39,64)( 41,65)( 45,67)( 46,69)( 49,75)( 50,76)
  ( 53,78)( 54,80)( 58,86)( 61,87)( 63,88)( 66,89)( 68,90)( 70,91)
  ( 73,93)( 74,95)( 77,96)( 79,97)( 81,98)( 84,100)( 85,102)( 92,103)
  ( 94,104)( 99,105)(101,106),( 1,2)( 5,6)( 9,10)(13,14)(16,17)(21,22)
  (24,25),( 3,10)( 4,13)( 6,15)( 7,16)(11,18),
 ( 3,10)( 4,12)( 5,15)( 6,18)( 7,19)( 8,21)( 9,22)(11,33)(14,37)(17,43)
  (20,47)(27,52)(28,54)(29,57)(30,59)(31,62)(32,66)(34,67)(36,68)(38,69)
  (40,70)(42,71)(44,72)(46,73)(48,74)(50,75)(53,80)(56,82)(58,84)(61,86)
  (63,88)(65,90)(76,91)(77,92)(78,93)(79,94)(81,95)(83,96)(85,97)(87,98)
  (89,99),( 1,4)( 5,10)( 7,12)( 8,13)( 9,15)(11,17)(14,18)(16,19),
 ( 2,4)( 6,8)(14,15)(20,22)(25,26)(28,30)(34,36)(37,38)(39,40),
 ( 1,39)( 2,40)( 5,42)( 7,45)(10,47)(11,50)(14,51)(17,54)(18,56)(22,58)
  (23,61)(26,63)(28,66)(30,70)(31,71)(33,74)(35,76)(44,80)(49,83)(60,87)
  (65,90)(67,91)(77,92)(84,93),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)
  (33,34)(36,37)(39,40),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)(33,34)
  (36,37),( 1,11)( 3,13)( 4,15)( 6,17)( 9,24)(12,25)(14,26)(16,27)(18,28)
  (20,29)(22,30),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)(34,35)(37,38)
  (39,40),( 1,7)( 2,8)( 4,11)( 6,13)( 9,14)(10,15)(16,22)(17,23)(19,24)
  (20,25),( 1,4)( 5,10)(11,14)(12,15),
 ( 1, 8)( 2,11)( 4,16)( 12,35)( 13,36)( 15,37)( 17,38)( 18,41)
  ( 20,45)( 23,46)( 25,50)( 31,68)( 39,71)( 42,72)( 43,73)( 47,77)
  ( 48,78)( 51,79)( 53,85)( 61,90)( 64,97)( 69,99)( 74,101)( 82,118)
  ( 84,121)( 87,122)( 89,123)( 92,126)( 94,127),
 ( 2,4)( 6,8)(19,21)(23,24)(25,27)(28,29)(32,33)(34,36)(38,39)(40,42)
  (43,44)(46,47)(49,50)(52,53),( 1,5)( 4,9)( 8,10),
 ( 1,14)( 2,15)( 4,17)( 5,18)( 6,20)( 7,21)( 9,22)(10,24)(11,25)(12,27),
 ( 1,8)( 2,11)( 4,12)( 5,15)( 6,16)( 9,19)(13,22)(17,23)(20,24),
 ( 1,11)( 3,13)( 6,16)( 8,17)(18,23)(19,28),( 1,2)( 5,6)( 9,10)(14,15),
 ( 1,11)( 3,12)( 4,15)( 7,16),( 1,38)( 4,43)( 5,44)( 7,46)( 10,50)
  ( 13,51)( 15,53)( 21,56)( 23,59)( 26,61)( 29,63)( 31,66)( 35,68)
  ( 40,70)( 42,72)( 45,73)( 47,77)( 49,79)( 52,80)( 58,81)( 60,82)
  ( 62,86)( 65,88)( 67,89)( 69,92)( 75,94)( 76,98)( 84,100)( 85,104)
  ( 93,107)( 99,110),( 1,38)( 4,42)( 5,45)( 6,48)( 10,49)( 12,52)
  ( 13,53)( 16,55)( 19,58)( 21,61)( 23,64)( 25,65)( 28,66)( 31,69)
  ( 33,70)( 35,72)( 43,73)( 44,76)( 51,80)( 59,82)( 60,85)( 68,89)
  ( 74,92)( 78,95)( 83,98)( 87,101),( 1,7)( 2,8)( 5,10)( 9,17)(11,18),
 ( 3,10)( 5,12)( 7,13)( 9,14)(11,15),( 1,2)( 5,6)( 9,10)(19,20)(25,26)
  (27,28)(33,34)(37,38)(39,40)(43,44)(47,48)(50,51),
 ( 1,38)( 4,41)( 5,45)( 7,49)(10,50)(13,54)(16,56)(17,57)(20,60)(22,64)
  (25,68)(28,69)(30,70)(32,73)(33,75)(36,77)(42,78)(44,80)(48,81)(52,82)
  (61,84)(63,86)(67,87)(72,88),( 1,23)( 4,24)( 6,25)( 9,26)(11,30)(14,31)
  (17,32)(18,33)(21,37)(27,38)(34,39),( 1,8)( 2,10)( 3,12)( 5,14)( 6,16)
  ( 9,19)(13,22)(17,23)(20,24),( 1,14)( 3,16)( 8,20)(10,22)(12,24)(15,46)
  (17,47)(21,48)(28,49)(30,52)(32,53)(35,55)(37,58)(39,59)(42,61)(44,64)
  (45,65)(51,70)(57,71)(63,72),( 1,6)( 3,9)(11,24)(15,30)(26,31)(28,34)
  (29,38)(33,43)(35,45)(37,50)(39,53)(41,56)(44,63)(49,64)(55,65)(60,68)
  (62,72),( 1,2)( 5,6)( 9,10)(19,20)(26,27)(28,29)(33,34)(38,39)(40,41)
  (44,45)(48,49)(51,52),( 1,4)( 5,8)( 9,12)(16,20)(26,27)(28,30)(34,35)
  (36,38)(42,44)(45,46)(47,48)(49,50),( 1,4)( 5,8)( 9,12)(16,20)(27,28)
  (29,30)(33,34)(35,36),( 2,3)( 6,7)( 8,9)(12,13)(22,24)(26,27)(28,30)
  (32,33)(34,35)(41,42)(43,44),( 2,4)( 7,9)(12,14)(15,16)(18,19)(21,22),
 ( 1,7)( 3,13)( 5,17)( 9,19)(15,21),( 1,37)( 2,41)( 5,44)( 8,45)(10,47)
  (11,51)(13,54)(16,56)(18,59)(20,60)(21,64)(25,65)(27,67)(32,71)(34,74)
  (40,75)(50,76)(52,79)(55,81)(57,84)(63,85)(70,87)(72,90)(80,91)(82,94)
  (86,95)(88,98),( 1,7)( 3,13)( 6,29)( 9,37)(12,40)(15,44)(17,45)(19,49)
  (24,52)(28,55)(31,57)(35,60)(39,62)(42,63)(47,65)(48,66)(51,70)(54,73)
  (56,74)(59,78)(68,81)(72,83)(76,84)(80,86),
 ( 1,4)( 5,8)( 9,11)(15,19)(27,28)(29,30)(34,35)(36,37)(42,43)(44,45),
 ( 1,14)( 4,19)( 7,27)(10,36)(15,41)(17,42)(20,43)(23,45)(25,47)(28,48)
  (31,49)(32,50)(35,52)(38,54)(40,55)(44,56)(51,57),
 ( 2,11)( 3,12)( 4,15)( 5,17)( 8,19)( 9,21)(13,22)(16,23)(18,24)(20,25),
 ( 1,2)( 5,6)(10,11)(15,16)(28,29)(36,37)(43,44),
 ( 1, 6)( 4,22)( 9,31)( 12,34)( 14,36)( 17,38)( 20,41)( 21,43)
  ( 23,44)( 32,69)( 33,70)( 35,72)( 39,77)( 40,78)( 42,80)( 45,83)
  ( 47,93)( 49,95)( 51,99)( 53,101)( 55,103)( 57,105)( 59,107)( 61,111)
  ( 63,113)( 65,115)( 67,117)( 73,118)( 74,119)( 76,120)( 81,121)( 82,122)
  ( 85,123)( 96,131)(108,133),( 1, 6)( 4,19)( 8,35)( 11,37)( 12,39)
  ( 14,42)( 16,44)( 18,46)( 20,47)( 22,48)( 23,50)( 24,53)( 26,55)
  ( 34,80)( 36,81)( 41,83)( 45,84)( 52,86)( 61,94)( 65,95)( 69,96)
  ( 74,97)( 78,98)( 82,99)( 85,100)( 92,102)(103,109)(105,110),
 ( 1, 6)( 4,17)( 9,28)( 10,29)( 12,33)( 19,42)( 23,52)( 25,61)
  ( 30,71)( 32,72)( 34,73)( 35,74)( 38,77)( 41,79)( 43,80)( 46,83)
  ( 48,90)( 49,92)( 53,94)( 55,97)( 56,98)( 58,101)( 59,103)( 62,105)
  ( 64,106)( 66,109)( 67,110)( 69,113)( 75,114)( 76,115)( 81,116)( 82,117)
  ( 95,134)( 99,136)(107,137)(111,139)(118,143)(120,145)(123,147)(126,149)
  (128,151)(131,153)(144,161)(146,162)(148,163)(150,164)(152,165)(154,166),
 ( 1,22)( 2,25)( 4,26)( 5,29)( 7,31)( 8,32)( 9,33)(10,36)(11,38)(13,39)
  (14,45)(15,51)(17,56)(19,60)(21,65)(23,69)(24,70)(27,72)(28,73)(34,75)
  (35,76)(46,82)(52,85)(61,88),( 1,37)( 3,39)( 7,43)( 8,44)
  ( 12,48)( 15,49)( 17,51)( 22,56)( 24,60)( 27,62)( 30,64)( 32,67)
  ( 36,69)( 38,74)( 41,76)( 42,78)( 47,79)( 50,81)( 58,83)( 59,85)
  ( 61,86)( 63,88)( 66,89)( 68,91)( 75,92)( 77,94)( 82,95)( 84,97)
  ( 87,100)( 93,103)( 96,106),( 1,7)( 2,11)( 3,16)( 4,26)(32,46)(33,50)
  (34,61)(35,65)(38,66)(39,70)(43,71)(44,73)(48,75)(49,79)(53,80)(54,82)
  (58,84)(59,88)(63,89)(64,91),( 2,3)( 6,7)(10,11)(12,13)(20,21)(23,24)
  (27,28)(47,48)(58,59)(61,62)(65,66)(67,68)(71,72)(73,74)(77,78)(79,80)
  (83,84)(85,86)(89,90)(91,92)(95,96),( 1,8)( 2,9)( 4,12)( 5,13)( 6,16)
  (10,17)(14,18),( 2,8)( 3,9)( 5,11)( 6,12),
 ( 1,22)( 2,23)( 4,24)( 5,27)( 7,28)( 8,29)(10,32)(11,33)(13,34)(14,37)
  (16,38)(20,52)(25,59)(26,60)(30,61)(31,62)(35,63)(36,64)(39,69)(42,73)
  (45,75)(48,77)(50,79)(54,81)(56,83)(65,86)(67,89)(71,92),
 ( 1,3)( 5,8)(11,13)(15,17)(28,29)(34,35)(39,40)(43,44)(46,48)(51,52)
  (54,56)(60,62)(67,68)(70,71)(72,73)(75,76)(78,79)(80,81)(82,83)(84,85)
  (86,87)(88,89)(90,91),( 2,23)( 3,24)( 5,28)( 7,29)(10,31)(12,32)(14,33)
  (15,34)(17,35)(19,39)(20,40)(22,41)(25,42)(26,43)(27,44)(30,47)(36,50)
  (37,51)(38,52)(45,55)(46,56)(48,57)(49,58)(53,59)(54,60),
 ( 2,11)( 4,20)( 6,31)( 8,35)( 10,37)( 12,39)( 13,40)( 15,43)
  ( 18,47)( 21,48)( 23,51)( 32,69)( 33,70)( 38,73)( 41,75)( 44,77)
  ( 45,78)( 49,81)( 50,82)( 52,84)( 55,89)( 59,93)( 63,101)( 65,105)
  ( 71,111)( 79,112)(114,129)(116,131)(118,133)(120,135)(122,137)(124,139),
 ( 1,2)( 5,6)(12,13)(16,17)(19,20),( 1,4)( 5,7)(10,13)(14,16)(20,21)
  (23,24)(26,27),( 2,4)( 7,9)(15,16)(19,21)(25,27)(33,35)(38,40),
 ( 1,10)( 2,26)( 5,39)( 7,40)( 9,42)( 11,44)( 13,45)( 15,47)
  ( 16,49)( 18,52)( 19,53)( 21,55)( 23,56)( 24,58)( 25,59)( 36,76)
  ( 37,77)( 46,81)( 48,82)( 51,84)( 78,103)( 83,105),
 ( 1,10)( 2,25)( 4,48)( 7,50)( 15,52)( 18,53)( 21,55)( 26,57)
  ( 29,58)( 30,60)( 34,62)( 36,66)( 40,68)( 42,72)( 45,74)( 49,78)
  ( 54,82)( 56,83)( 61,90)( 63,91)( 64,93)( 67,95)( 69,96)( 70,98)
  ( 73,100)( 75,101)( 76,103)( 77,104)( 81,105),
 ( 1,10)( 2,25)( 4,47)( 7,49)( 12,51)( 15,52)( 18,53)( 26,56)
  ( 29,57)( 30,59)( 34,63)( 38,65)( 40,69)( 44,71)( 48,75)( 50,77)
  ( 54,80)( 60,90)( 61,92)( 64,94)( 66,95)( 67,97)( 70,99)( 72,100)
  ( 73,102)( 78,103)( 82,104)( 83,105)( 85,107)( 87,109)(106,111)(108,112)
  (110,113),( 1,37)( 4,38)( 7,42)( 9,45)( 14,46)( 16,48)( 19,51)
  ( 23,53)( 24,55)( 28,57)( 30,61)( 31,64)( 35,68)( 39,70)( 41,71)
  ( 43,75)( 47,79)( 52,80)( 54,81)( 56,85)( 58,88)( 59,89)( 65,93)
  ( 69,94)( 72,95)( 73,96)( 82,99)( 83,100)( 90,103)( 97,104)(101,105),
 ( 1,4)( 5,7)(11,15)(19,22)(26,27)(32,33)(34,35)(40,41)(42,43)(45,46)
  (47,48)(49,50),( 1,4)( 5,7)(11,15)(19,21)(25,26)(31,32)(33,34)(36,37)
  (39,40),( 1,10)( 2,24)( 3,27)( 4,32)(34,41)(35,44)(36,56)(37,59)(38,69)
  (42,72)(43,73)(47,74)(48,76)(52,79)(53,80)(57,81)(58,83)(62,86)(63,87)
  (67,88),( 2,4)( 7,8)(10,11)(13,14)(16,17)(20,21),
 ( 1,10)( 2,21)( 3,37)( 5,38)( 7,39)( 8,40)( 11,43)( 13,46)
  ( 15,48)( 17,49)( 18,51)( 19,52)( 24,55)( 26,58)( 28,60)( 44,78)
  ( 45,79)( 56,83)( 57,84)( 59,86)( 77,103)( 82,105),
 ( 1,10)( 2,21)( 3,36)( 5,38)( 7,41)( 12,44)( 13,45)( 14,47)
  ( 16,48)( 18,50)( 20,53)( 23,56)( 24,57)( 26,58)( 28,59)( 37,77)
  ( 39,79)( 40,80)( 51,84)( 52,85)( 81,104)( 86,106),
 ( 3,9)( 4,11)(12,20)(18,32)(22,34)(28,36)(30,42)(37,49)(39,51)(41,53)
  (43,55)(45,57)(47,59)(48,60)(52,62)(56,64),
 ( 1,4)( 5,6)( 8,11)(12,14)(16,19)(20,22)(30,33)(39,41)(44,45)(46,47)
  (48,50)(51,52)(53,55)(56,57)(60,62)(64,65)(66,67)(68,70)(71,72)(73,74)
  (75,77)(78,80)(82,83)(85,87)(88,90)(92,93),
 ( 1,32)( 4,34)( 8,38)( 9,41)( 11,43)( 14,49)( 15,50)( 18,52)
  ( 21,54)( 22,56)( 26,58)( 27,61)( 30,65)( 33,67)( 35,72)( 40,74)
  ( 45,82)( 46,85)( 51,87)( 60,95)( 62,98)( 69,100)( 70,102)( 76,104)
  ( 77,106)( 79,107)( 84,109)( 89,115)( 90,117)( 92,118)( 97,120)(111,126)
  (112,128)(122,130)(123,132),( 1,6)( 5,11)(12,18)(16,30)(20,31)(28,40)
  (29,49)(33,50)(35,52)(39,54)(42,56)(44,58)(48,60)(53,62)(57,63)(61,64),
 ( 1,10)( 2,19)( 3,22)( 4,26)( 5,30)( 6,33)( 7,36)( 9,41)(11,42)(13,45)
  (14,46)(17,48)(21,49)(23,50)(25,51)(27,54)(29,55)(31,56)(35,60)(38,61)
  (40,62)(44,63)(53,66)(57,69)(64,70)(67,71),
 ( 1,2)( 5,6)(16,17)(21,22)(26,27)(29,30)(32,33)(34,35),
 ( 1,22)( 3,23)( 4,25)( 6,26)( 7,28)( 9,29)( 10,31)( 11,32)
  ( 13,33)( 14,34)( 16,36)( 17,41)( 20,50)( 24,62)( 27,63)( 30,65)
  ( 35,67)( 38,72)( 42,75)( 45,77)( 48,79)( 52,82)( 55,84)( 59,87)
  ( 61,88)( 64,89)( 66,90)( 71,101)( 76,103)( 83,105),
 ( 1,10)( 2,18)( 3,25)( 4,33)( 6,34)( 9,37)( 11,39)( 14,43)
  ( 15,46)( 17,47)( 19,50)( 22,52)( 23,53)( 26,57)( 27,58)( 30,59)
  ( 32,62)( 35,64)( 36,65)( 38,66)( 40,67)( 42,69)( 45,71)( 48,75)
  ( 49,78)( 51,79)( 54,82)( 56,83)( 60,86)( 61,89)( 63,90)( 68,94)
  ( 70,95)( 72,96)( 74,98)( 77,100)( 80,102)( 85,103)( 88,105)( 91,107)
  ( 93,108)( 97,112)( 99,113)(101,114)(104,116)(106,117)(109,119)(111,120)
  (115,124)(118,126)(121,127)(123,128)(125,131)(129,134)(132,135),
 ( 1,2)( 5,6)(23,25)(26,27)(32,33)(34,35)(38,40)(41,42)(50,51)(52,53)
  (54,55)(57,58)(59,60)(61,62)(64,65)(66,67)(68,69)(82,83)(84,85)(86,87)
  (88,89)(90,91)(92,93),( 1,4)( 6,11)( 7,13)( 8,15)( 9,16)(10,17)(12,19)
  (14,21)(18,23)(20,24)(22,25),( 2,4)( 8,11)(12,15)(18,20)(22,23)(28,31)
  (38,40)(43,44)(49,51)(53,54)(56,58)(60,62)(66,68)(70,71)(73,74)(75,77)
  (78,79)(82,83)(87,88)(90,91)(92,93),( 1,2)( 6,11)( 7,13)( 8,15)( 9,17)
  (10,18)(12,19)(14,20)(16,21),( 1,4)( 6,11)(12,16)(13,17)(14,18),
 ( 2,4)( 8,11)(13,16)(18,21)(26,27)(33,34)(42,43),
 ( 1,31)( 2,33)( 5,34)( 7,36)( 9,37)(11,38)(12,39)(15,40)(18,42)(19,43)
  (20,44)(22,47)(23,48)(25,49)(26,50)(27,51)(29,54)(30,55)(32,56)(35,58)
  (41,60)(45,61)(46,62)(52,64)(53,65)(57,67)(59,68)(63,69)(66,70),
 ( 1,31)( 2,32)( 4,34)( 5,36)( 7,37)( 8,38)(10,41)(11,42)(13,43)(14,45)
  (16,47)(18,48)(21,49)(25,50)(28,51)(33,52)(35,53)(39,54)(40,55)(44,56)
  (46,57),( 2, 3)( 13,14)( 16,17)( 20,21)( 23,24)( 28,29)( 31,32)
  ( 38,39)( 40,41)( 42,43)( 47,48)( 50,51)( 52,53)( 54,55)( 57,58)
  ( 59,60)( 61,62)( 66,67)( 68,69)( 70,71)( 72,73)( 75,76)( 82,83)
  ( 87,88)( 93,94)( 96,97)( 98,99)(101,102)(104,105),
 ( 1,10)( 2,16)( 3,23)( 4,27)( 5,30)( 32,46)( 33,56)( 38,59)
  ( 39,60)( 42,64)( 47,66)( 48,68)( 53,70)( 54,72)( 55,81)( 73,91)
  ( 76,94)( 79,97)( 82,100)( 85,103)( 88,106)( 89,108)( 92,110)( 95,114)
  ( 98,116)(101,120)(104,122),( 2,11)( 5,14)( 8,15)( 9,18)(12,21)(17,22)
  (20,23),( 1,10)( 2,16)( 3,22)( 4,34)( 6,35)( 11,40)( 13,42)
  ( 14,46)( 18,47)( 20,50)( 24,54)( 26,58)( 36,83)( 39,84)( 43,85)
  ( 48,86)( 52,87)( 55,88)( 61,96)( 65,98)( 69,100)( 73,102)( 77,104)
  ( 81,106),( 1,31)( 3,32)( 4,34)( 6,35)( 7,37)( 9,38)(10,40)(11,41)(13,42)
  (14,43)(16,45)(18,47)(21,48)(25,50)(28,51)(33,53)(36,54)(39,56)(44,58)
  (46,59)(49,60)(52,61)(55,62)(57,63),( 1,31)( 3,33)( 5,35)( 8,36)( 9,37)
  (11,38)(14,39)(15,41)(17,42)(18,43)(20,46)(21,47)(23,48)(24,49)(25,50)
  (27,53)(28,54)(30,55)(32,56)(34,57)(40,59)(44,61)(45,62)(51,64)(52,65)
  (58,67)(60,68)(63,69)(66,70),( 1,7)( 3,9)( 4,11)( 6,14)( 8,17)(12,20)
  (13,21)(16,22)(19,23),( 2,4)( 8,9)(10,12)(13,14)(15,17)(18,19)(21,22)
  (23,24)(25,26),( 1,2)( 6,8)(12,14)(17,18)(20,21)(23,24),
 ( 1,31)( 3,32)( 6,33)( 7,35)( 9,36)(11,38)(13,40)(16,41)(17,43)(18,44)
  (20,45)(21,46)(22,47)(24,50)(25,51)(27,52)(28,53)(29,54)(34,56)(37,58)
  (39,59)(42,61)(48,63)(49,64)(55,66)(57,67)(60,68)(62,69)(65,70),
 ( 1,4)( 6,9)(11,14)(16,19)(28,29)(36,37)(41,42),
 ( 1,31)( 4,32)( 6,34)( 8,36)(10,37)(11,39)(14,40)(16,41)(18,43)(19,44)
  (20,45)(22,46)(23,47)(25,50)(26,51)(27,52)(29,53)(30,54)(33,57)(35,58)
  (38,60)(42,61)(48,63)(49,64)(55,66)(56,67)(59,68)(62,69)(65,70),
 ( 1,4)( 6,9)(11,14)(16,18)(20,23),( 1,10)( 2,16)( 4,36)( 5,39)
  ( 9,44)( 12,45)( 14,46)( 18,49)( 23,54)( 24,55)( 26,56)( 28,57)
  ( 38,73)( 42,75)( 43,77)( 48,79)( 51,81)( 52,82)( 53,85)( 60,89)
  ( 64,92)( 68,97)( 70,100)( 74,106)( 80,108)(111,127)(113,128)(115,129)
  (117,130)(119,131)(121,132),( 1,10)( 2,16)( 4,25)(11,43)(17,45)(19,46)
  (21,50)(23,52)(26,53)(30,55)(35,57)(37,61)(39,63)(41,64)(44,65)(47,66)
  (51,67)(56,68)(58,69)(62,70),( 1,2)( 6,7)( 8,9)(11,12)(20,23)(34,37)
  (43,44)(46,47)(49,50),( 1,7)( 3,9)( 5,10),
 ( 1,2)( 6,7)( 8,9)(13,14)(16,17)(22,23)(25,26)(32,33)(38,39)(41,42)
  (47,48)(49,50)(51,52)(54,55)(57,58)(63,64)(66,67)(68,69)(70,71)(73,74)
  (77,78)(81,82),( 1,10)( 2,15)( 3,23)( 4,26)( 5,33)( 6,37)( 8,40)(12,42)
  (13,43)(17,45)(18,46)(20,48)(21,50)(25,53)(28,54)(30,55)(34,56)(36,57)
  (39,59)(41,60)(44,61)(47,63)(51,65)(52,66)(58,70)(62,74)(64,75)(67,77)
  (69,79)(71,80)(73,82)(76,83)(78,84)(81,86)(85,88)(87,89),
 ( 1,2)( 6,7)( 8,9)(15,16)(20,22)(33,35)(39,40)(43,44)(46,47)(50,51)
  (53,54),( 1,7)( 3,9)( 6,11)( 8,13)(10,15)(12,17)(14,18)(16,19),
 ( 2,23)( 5,24)( 7,25)(10,29)(12,30)(15,31)(16,32)(19,35)(22,36)(28,37)
  (34,39),( 1,7)( 3,9)( 6,10)(11,17)(14,23)(19,27)(21,29),
 ( 2,10)( 3,12)( 5,14)( 7,16),( 1,7)( 3,9)(11,27)(20,30)(24,31)(28,35)
  (29,39)(32,43)(34,45)(36,50)(38,53)(40,56)(44,63)(54,64)(59,66)(61,70)
  (68,75)(72,78),( 1,4)( 6,8)( 9,12)(14,15)(16,19)(23,26)(34,36)(37,39)
  (41,43)(46,47)(48,49)(50,51)(52,54)(55,56)(57,58)(60,62)(65,66)(67,69)
  (70,71)(72,73)(76,78)(80,81)(82,84)(86,87)(88,90)(91,93)(95,97),
 ( 1,10)( 2,15)( 3,22)( 5,24)(11,26)(16,28)(20,30),
 ( 1,7)( 3,8)( 4,11)( 5,12)( 9,16)(13,18)(15,20)(17,21)(19,22),
 ( 1,4)( 6,8)( 9,11)(13,15)(16,18),( 1,29)( 4,31)( 7,33)(10,34)(11,35)
  (13,37)(14,38)(16,39)(17,43)(18,45)(19,46)(22,48)(23,50)(24,51)(25,52)
  (28,54)(30,55)(32,56)(36,58)(40,61)(41,63)(42,64)(44,66)(47,67)(49,69)
  (53,72)(57,73)(59,74)(60,76)(62,78)(65,79)(68,80)(70,81)(71,82)(75,83)
  (77,84),( 1,4)( 6,8)(10,13)(15,18)(20,23),
 ( 1,7)( 3,8)( 4,10)( 5,11),( 1,2)( 3,4)( 6,7)( 9,10)(17,18)(24,25),
 ( 2,23)( 5,24)( 9,27)(12,28)(14,29)(17,33)(19,34)(22,35)(26,37)(31,39)
  (32,40)(36,41)(38,42),( 1,10)( 2,15)( 3,17)( 4,23)( 5,26)( 6,30)( 7,34)
  ( 8,40)(11,41)(14,42)(18,43)(20,46)(22,48)(25,49)(27,52)(31,53)(33,54)
  (35,57)(37,58)(39,61)(45,62)(50,64)(56,65)(59,67),
 ( 1,2)( 6,7)(10,11)(15,16)(28,29)(37,38)(43,44),
 ( 1,10)( 2,15)( 3,17)( 4,23)( 5,26)( 6,30)( 7,33)( 8,38)(11,39)(14,40)
  (18,41)(20,44)(22,47)(25,49)(27,52)(32,53)(34,56)(35,58)(37,61)(43,62)
  (45,63)(50,66)(55,67)(59,70)(64,71)(68,72),
 ( 3,9)( 6,11)( 7,13)( 8,15)(10,17)(12,19)(14,21),
 ( 1,28)( 2,30)( 4,31)( 5,32)( 7,35)( 8,36)( 9,37)(11,38)(12,39)(14,41)
  (15,42)(20,50)(21,51)(26,53)(29,55)(33,57)(34,58)(40,60)(44,62)(46,64)
  (49,65)(54,66)(56,67)(59,68)(61,69)(63,70),
 ( 1,28)( 2,30)( 5,31)( 6,34)( 9,35)(11,37)(13,38)(15,39)(17,42)(18,46)
  (19,47)(20,49)(21,52)(22,54)(23,55)(24,56)(25,57)(26,58)(27,60)(40,61)
  (41,64)(44,67)(45,68)(50,69)(51,70)(62,71)(63,72)(65,73)(66,74),
 ( 1,10)( 2,15)( 4,20)( 6,21)(11,24)(13,27)(16,29)(26,37)(33,40),
 ( 1,2)( 3,4)( 9,10)(17,18)(21,22)(25,26),
 ( 1,28)( 2,29)( 4,32)( 5,33)( 7,34)( 8,36)(10,37)(11,38)(13,40)(14,41)
  (16,42)(21,47)(25,52)(26,53)(30,55)(31,56)(35,58)(39,60)(45,62)(48,64)
  (50,66)(54,68)(57,69)(59,70)(61,71)(63,72)(65,73)(67,74),
 ( 2,10)( 4,16)( 5,20)( 8,31)( 12,35)( 14,36)( 15,38)( 18,40)
  ( 19,42)( 23,45)( 24,46)( 26,49)( 32,75)( 34,77)( 41,78)( 44,80)
  ( 48,81)( 54,91)( 59,94)( 63,98)( 67,100)( 72,103)( 76,105)( 79,107)
  ( 89,114)( 96,116),( 2,4)(10,12)(15,17)(18,20),
 ( 1,4)( 7,9)( 8,12)(10,13)(11,14),( 2,4)(10,12)(15,17)(20,22)(24,26)
  (31,33)(39,41),( 2,4)(10,12)(15,17)(23,24)(27,28)(31,32)(35,36),
 ( 1,10)( 2,14)( 3,21)( 5,36)( 6,37)( 11,41)( 15,42)( 17,44)
  ( 19,45)( 24,49)( 26,52)( 28,53)( 38,69)( 39,72)( 46,77)( 50,79)
  ( 56,89)( 60,98)( 64,102)( 70,103)( 73,104)( 78,106)( 85,122)(105,130)
  (107,131)(108,133)(110,135)(113,138)(115,140)(117,142)(119,145)(123,147)
  (125,149),( 1,10)( 2,14)( 3,21)( 5,22)( 8,24)(11,25)(15,27)(20,29)(23,30)
  (26,31)(28,32),( 1,10)( 2,14)( 3,19)( 4,21)( 5,26)( 6,30)( 7,32)( 8,35)
  ( 9,38)(11,41)(12,42)(16,43)(18,44)(22,46)(24,51)(28,53)(29,54)(33,55)
  (37,58)(47,59)(50,61)(57,64)(62,67)(65,69),
 ( 1,2)( 6,7)(11,12)(16,17)(28,29)(34,35),
 ( 1,2)( 6,7)(11,12)(16,17)(28,29)(36,37)(42,43),
 ( 3,9)(10,17)(11,20)(12,31)(13,34)(15,42)(22,43)(24,44)(32,45)(33,46)
  (41,47),( 3,8)( 4,21)( 7,23)(12,25)(13,26)(15,27)(16,28)(18,29)(19,30),
 ( 3,8)( 4,11)(13,24)(16,27)(18,33)(20,39)(22,45)(28,52)(32,56)(36,60)
  (40,64)(44,68)(48,72)(53,75)(55,76)(61,79)(63,80)(69,83)(71,84),
 ( 1,27)( 2,30)( 4,31)( 5,34)( 7,36)( 8,37)( 9,38)(10,41)(11,43)(13,44)
  (15,48)(18,51)(20,54)(23,56)(25,59)(28,62)(29,63)(32,65)(33,66)(39,68)
  (40,69)(49,73)(52,75)(57,77),( 1,10)( 2,14)( 3,16)( 4,20)( 5,22)( 6,25)
  ( 7,28)( 8,34)(13,38)(19,43)(27,49)(29,52)(31,53)(33,56)(35,57)(36,58)
  (37,61)(39,62)(40,64)(41,65)(44,67)(45,68)(46,71)(47,72)(48,74)(51,76)
  (54,79)(60,81)(70,84)(75,86)(77,87)(80,88)(82,89)(83,90)(85,91),
 ( 3,32)( 11,33)( 16,34)( 20,35)( 25,36)( 27,37)( 30,38)( 40,63)
  ( 41,64)( 44,66)( 45,68)( 47,69)( 50,71)( 53,73)( 56,75)( 59,76)
  ( 65,92)( 70,93)( 80,95)( 83,97)( 84,99)( 87,101)( 90,103)( 91,105)
  ( 94,106)( 96,108)( 98,110)(100,112)(102,114)(104,116)(109,118)(113,119)
  (117,120),( 1,2)( 6,7)(11,12)(18,19)(27,28)(33,34),
 ( 1,10)( 2,13)( 3,19)( 4,21)( 5,24)( 6,27)( 7,30)( 8,33)(12,36)(14,39)
  (16,41)(18,43)(26,50)(32,55)(35,57)(37,59)(40,61)(44,63)(45,65)(46,67)
  (47,69)(48,71)(51,72)(52,73)(53,75)(54,77)(56,79)(60,80)(62,81)(66,83)
  (76,86)(82,88)(84,89)(85,90)(87,91),( 1,7)( 4,11)( 6,14)( 9,17)(13,19),
 ( 1,10)( 2,13)( 3,18)( 4,21)( 5,26)( 6,29)( 7,35)( 8,38)(11,41)(15,42)
  (16,44)(19,46)(22,48)(24,51)(28,52)(30,53)(32,55)(34,57)(36,60)(40,61)
  (45,62)(50,63)(56,65)(59,66),( 1,2)( 6,7)(11,12)(19,20)(26,27)(33,34),
 ( 1,27)( 2,28)( 4,30)( 5,31)( 7,33)( 8,35)( 9,36)(11,38)(12,46)(13,48)
  (14,50)(15,51)(16,53)(17,55)(18,57)(19,58)(20,61)(22,63)(23,65)(24,66)
  (29,69)(32,71)(37,73),( 1,10)( 2,13)( 3,18)( 4,19)( 5,24)( 6,27)( 7,29)
  ( 8,33)( 9,37)(11,39)(15,43)(17,46)(20,48)(22,49)(26,51)(30,53)(31,54)
  (35,56)(36,57)(40,59)(45,60)(61,69)(64,70)(65,71)(68,72),
 ( 3,8)( 4,9)( 6,11)(10,13)(12,14),( 1,10)( 2,13)( 3,17)( 4,20)( 5,24)
  ( 6,28)( 7,31)( 8,36)(12,41)(15,42)(19,45)(21,47)(23,49)(25,51)(27,52)
  (33,54)(35,56)(37,58)(39,60)(40,61)(46,62)(48,63)(55,65)(57,66),
 ( 1,10)( 2,13)( 3,17)( 4,19)( 5,22)( 6,26)( 7,28)( 8,31)( 9,35)(12,38)
  (16,41)(21,44)(24,46)(25,48)(30,52)(34,54)(37,56)(40,59)(43,60)(45,62)
  (49,65)(50,67)(55,70)(57,72)(63,75)(68,78)(69,79)(73,82)(76,84)(77,85)
  (81,87)(83,89),( 3,8)( 4,9)( 6,10)( 7,13)(11,17)(12,18),
 ( 1,2)( 6,7)(12,13)(17,18)(21,22)(25,26),
 ( 2,10)( 4,12)( 7,15)( 9,17)(18,23)(19,28),
 ( 3,8)( 4,9)(10,15)(12,33)(18,34)(31,42)(32,50)(35,51)(39,53)(41,55)
  (43,57)(47,59)(49,61)(54,63)(58,64)(62,65),( 2,4)(11,12)(14,15),
 ( 1,10)( 2,13)( 3,15)( 4,20)( 5,23)( 6,26)( 7,29)( 8,32)( 9,34)(12,40)
  (16,42)(18,43)(22,47)(27,51)(31,53)(35,55)(36,58)(39,59)(41,61)(44,62)
  (46,63)(50,66)(52,68)(54,69)(64,72)(70,73),
 ( 3,8)( 5,20)( 7,21)(10,22)(12,25)(15,26)(16,29)(19,30)(24,31)(28,32),
 ( 3,8)( 5,20)( 7,21)(11,23)(13,25)(14,27)(17,29)(18,30)(22,31)(26,32),
 ( 3,8)( 5,18)( 7,19)(11,21)(13,23)(14,26)(16,28)(17,30)(20,32)(25,34),
 ( 2,4)(13,15)(18,20)(23,24)(28,29)(31,32)(36,37)(39,40),
 ( 1,2)( 6,7)(13,14)(18,19)(26,27)(31,32)(39,40),
 ( 1,8)( 4,11)( 9,17)(13,20)(14,21)(16,22)(19,23),
 ( 1,4)( 8,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,2)( 6,7)(13,14)(19,20)(22,23)(27,28)(30,31)(35,36)(38,39)(42,43)
  (45,46)(47,48)(50,51)(54,55)(57,58)(61,62)(64,65)(66,67)(70,71)(75,76)
  (78,79)(82,83)(84,85)(88,89),( 3,8)( 5,11)(12,13)(18,30)(28,35)(29,44)
  (31,49)(34,51)(36,53)(39,55)(40,56)(43,58)(45,60)(48,62)(52,63)(57,64)
  (61,65),( 1,2)( 6,7)(13,14)(21,22)(25,26)(28,29)(31,32),
 ( 3,8)( 5,10)( 6,12)( 7,15)(13,18)(14,20),
 ( 2,10)( 4,11)( 6,13)( 9,15)(12,18)(14,19),
 ( 2,19)( 5,20)( 8,22)(11,23)(14,25)(17,26),
 ( 1,2)( 6,7)(14,15)(18,19)(26,27)(33,34)(41,42),
 ( 2,5)( 6,7)(10,12)(13,15)(17,20)(21,23)(26,29)(34,36)(37,39)(42,43)
  (45,47)(49,50)(51,53)(55,56)(58,60)(63,64)(67,69)(71,72)(74,75)(78,79)
  (80,82)(83,84)(86,87)(88,90)(91,92),( 1,4)( 2,11)( 3,18)( 5,23)(10,25)
  (13,26)(16,28)(19,29)(22,30)(24,31)(27,32),
 ( 2,5)( 7,20)( 9,21)(10,22)(13,23)(14,26)(16,27)(19,30)(25,31)(29,32),
 ( 1,2)( 6,7)(14,15)(21,22)(25,26)(28,29)(31,32),
 ( 1,2)( 6,7)(15,16)(19,20)(23,25)(26,27)(35,37)(39,40)(44,45)(47,48)
  (51,52)(54,55),( 1,8)(10,14)(11,17)(12,26)(13,29)(19,39)(20,40)(27,43)
  (28,44)(35,47)(36,48),( 1,2)( 6,7)(17,18)(19,20)(22,23)(26,27)(29,30),
 ( 1, 6)( 2,28)( 5,47)( 9,49)( 14,50)( 19,53)( 21,54)( 24,55)
  ( 27,57)( 31,59)( 33,63)( 37,65)( 39,69)( 42,71)( 44,75)( 48,77)
  ( 51,80)( 58,84)( 60,89)( 62,91)( 64,93)( 66,94)( 68,96)( 70,98)
  ( 72,99)( 74,101)( 76,103)( 79,104)( 83,105),
 ( 1,10)( 2,12)( 5,14)( 7,16),( 1,6)( 2,22)( 3,29)( 4,34)(35,45)(36,48)
  (37,60)(38,63)(41,70)(42,71)(46,72)(47,74)(51,76)(52,77)(56,78)(57,80)
  (61,82)(62,83)(66,84)(67,86),( 1,10)( 2,11)( 3,15)( 5,16)( 7,20)( 8,21)
  (12,23)(17,25),( 2,10)( 5,21)( 8,32)( 15,41)( 17,45)( 18,46)
  ( 24,55)( 26,64)( 28,70)( 31,73)( 33,74)( 36,76)( 39,79)( 40,80)
  ( 42,81)( 44,82)( 47,89)( 49,92)( 50,93)( 52,96)( 54,97)( 57,99)
  ( 58,101)( 60,104)( 61,105)( 63,108)( 67,110)( 68,112)( 71,114)( 72,115)
  ( 77,116)( 78,117)( 91,134)( 95,136)(103,137)(107,139)(120,144)(123,146)
  (125,148)(128,150)(131,152)(133,154)(143,161)(145,162)(147,163)(149,164)
  (151,165)(153,166),( 3,8)( 5,9)( 6,11)( 7,12),
 ( 1,2)( 7,10)(13,16)(23,24)(26,27)(29,30),
 ( 2,10)( 5,14)( 7,17)( 8,20)(11,21)(16,23),
 ( 3,23)( 5,24)( 8,28)(12,29)(15,30)(17,34)(20,35)(22,36)(25,37)(26,38)
  (31,39)(32,40),( 1,24)( 2,26)( 4,27)( 6,29)( 7,31)( 9,33)(11,34)(12,35)
  (14,37)(16,39)(17,41)(18,42)(20,43)(21,45)(25,46)(32,47)(40,48),
 ( 1,4)( 9,12)(14,17)(19,21)(24,25)(31,32)(39,40),
 ( 2,3)( 4,6)( 8,10)(14,15)(17,18),( 1,6)( 2,17)( 3,21)( 4,26)( 5,37)
  ( 7,39)( 9,42)(12,45)(14,47)(16,48)(18,50)(20,52)(23,55)(25,56)(27,57)
  (31,58)(33,60)(34,62)(36,63)(40,64)(41,65)(43,66)(46,67)(49,70)(51,72)
  (53,73)(54,74)(59,77)(61,79)(68,80)(71,81)(75,82)(78,83),
 ( 1,10)( 2,11)( 5,14)( 7,15),( 1,4)( 9,12)(14,17)(23,25)(29,31)(34,35)
  (37,38)(40,41),( 1,4)( 9,12)(17,18)(21,22)(23,24)(27,28)(31,32)(34,35)
  (38,39)(42,43)(46,48)(49,50)(52,53)(56,57)(58,59),
 ( 2,3)( 4,6)(10,12)(16,17)(19,20)(22,23),( 2,3)( 4,6)(11,13),
 ( 1,2)( 7,9)(14,15)(19,21),( 1,24)( 2,25)( 4,26)( 6,28)( 7,30)( 9,32)
  (11,33)(12,34)(14,36)(16,39)(17,40)(19,41)(20,43)(22,45)(27,46)(35,47)
  (42,48),( 1, 4)( 9,11)( 13,16)( 17,18)( 21,23)( 24,26)( 28,31)
  ( 32,34)( 37,39)( 42,43)( 47,48)( 49,51)( 52,53)( 54,56)( 59,60)
  ( 63,65)( 67,68)( 69,71)( 72,73)( 76,77)( 79,81)( 82,83)( 85,87)
  ( 89,90)( 92,94)( 95,97)( 98,100)(101,103)(104,106)(107,109)(110,112)
  (113,115),( 1,10)( 3,15)( 4,19)( 6,24)(11,41)(13,42)(16,44)(18,46)(20,47)
  (22,48)(26,49)(28,51)(29,52)(34,57)(37,66)(45,74)(50,76)(63,81)(72,86),
 ( 1,4)( 2,10)( 7,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 1,6)( 2,14)( 3,19)( 7,26)(12,27)(17,29)(23,30),
 ( 1,2)( 7,8)( 9,10)(12,13)(14,15)(16,17),
 ( 1,10)( 3,15)( 5,19)( 6,23)(11,46)(13,47)(16,50)(20,51)(21,52)(24,53)
  (26,56)(29,57)(35,61)(39,63)(44,68)(48,70)(54,71)(62,78)(64,79)(69,80),
 ( 3,8)( 7,14)( 9,16)(10,18)(11,19)(12,21)(13,23),
 ( 2,3)( 4,5)( 6,7)( 9,10)(11,12)(15,16)(19,20)(23,24),
 ( 2,3)( 4,5)( 6,7)( 9,10)(12,13)(15,16)(17,18)(19,20)(21,22)(23,24)
  (25,26)(27,28)(29,30)(36,37)(38,39)(40,41)(42,43)(44,45)(46,47)(48,49)
  (52,53)(54,55)(56,57)(58,59)(60,61)(62,63)(64,65),
 ( 1,10)( 3,14)( 5,16)( 7,19)(12,21)(22,25)(24,26),
 ( 2,10)( 6,13)( 8,15)(11,16)(14,17),( 2,10)( 6,13)( 9,15)(11,16)(12,17)
  (14,18),( 1,4)(10,14)(15,19)(22,24)(25,27)(31,33)(34,37),
 ( 2, 3)( 4, 5)( 7, 8)( 9,10)( 11,12)( 13,14)( 16,17)( 19,20)
  ( 22,23)( 32,33)( 34,35)( 39,40)( 41,42)( 43,44)( 45,46)( 47,48)
  ( 49,50)( 51,52)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 70,71)( 72,73)( 76,77)( 79,80)( 83,84)( 85,86)( 89,90)( 91,92)
  ( 95,96)( 98,99)(102,103),( 1,2)( 4,5)( 6,7)( 9,10)(11,12)(14,15)
  (17,18)(20,21)(26,27)(28,29)(35,36)(40,41)(42,43)(45,46)(49,50)(52,53),
 ( 2, 9)( 3,15)( 6,24)( 10,34)( 12,35)( 13,37)( 16,41)( 20,42)
  ( 25,45)( 27,49)( 28,52)( 30,54)( 31,57)( 36,64)( 38,68)( 46,75)
  ( 48,78)( 50,82)( 55,86)( 60,89)( 65,92)( 72,96)( 79,100),
 ( 1,2)( 7,8)(10,11)(15,16)(17,18)(22,23)(25,26)(31,32)(34,35)(41,42)
  (43,44)(49,50)(51,52)(53,54)(55,56)(58,59)(62,63)(65,66)(67,68)(73,74)
  (81,82)(86,87)(88,89)(91,92),( 3,8)(10,16)(12,22)(13,25)(14,32)(18,34)
  (23,36)(24,37)(27,38)(28,40)(30,46)(52,63)(56,65)(60,67),
 ( 1,12)( 3,20)( 6,30)( 7,36)(10,40)(14,41)(16,45)(18,46)(23,51)(26,52)
  (28,53)(31,57)(34,61)(38,62)(43,63)(49,64)(55,66)(59,67),
 ( 3,19)( 4,26)( 6,35)( 8,42)( 9,45)(12,48)(15,49)(18,50)(22,51)(25,52)
  (28,54)(30,56)(34,57)(38,58)(41,59)(46,60)(53,61),
 ( 1,4)(10,11)(18,19)(22,23)(25,26)(29,30)(31,32)(34,35)(39,40)(41,42)
  (45,46)(47,48)(52,53)(54,55),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)(15,16)
  (18,19)(20,21)(25,26)(27,28)(34,35)(39,40)(41,42)(45,46)(49,50)(52,53),
 ( 3,7)( 4,9)( 5,21)( 8,22)(15,26)(19,28)(23,29)(25,30),
 ( 2,3)( 4,5)( 7,8)( 9,10)(12,13),( 3,19)( 6,21)( 9,22)(12,24)(15,25)
  (18,27),( 1,4)(12,14)(15,18)(20,22)(23,26)(28,29)(30,33)(37,38)(39,41)
  (42,43)(44,45)(47,49)(52,53)(54,56)(57,59)(60,61)(62,63)(65,67)(68,70)
  (73,74)(75,77)(78,80)(83,85)(87,88)(90,91)(92,93),
 ( 1,2)( 7,8)(11,12)(14,15)(22,23)(24,25)(28,29)(43,44)(54,55)(61,62)
  (65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)(91,92)
  (95,96),( 1,7)( 2,13)( 3,19)( 4,26)( 5,33)( 6,39)( 8,41)(10,42)(12,45)
  (15,46)(18,49)(20,51)(23,52)(25,53)(27,56)(30,57)(31,58)(34,59)(36,61)
  (38,62)(43,63)(44,64)(47,65)(50,66)(54,69)(55,70)(60,71)(67,74)(72,75),
 ( 1,17)( 3,21)( 6,28)( 9,34)(12,39)(14,41)(18,44)(19,45)(22,46)(25,48)
  (30,52)(32,53)(35,54)(37,55)(43,57)(50,59),
 ( 1,4)( 2,8)( 3,20)(10,25)(13,27)(19,28)(22,30),
 ( 1,4)( 2,8)( 3,19)(10,24)(13,27)(18,28)(21,31),
 ( 1,12)( 3,14)( 4,16)( 6,18)( 7,21)( 9,22)(13,23)(15,24)(17,25),
 ( 1,2)( 4,5)( 7,8)( 9,10)(12,13)(14,15)(17,18)(20,21)(22,23)(25,26)
  (27,28)(30,31)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(56,57)(59,60)
  (62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)
  (92,93)(94,95),( 1,2)( 7,8)(12,13)(14,15)(17,18)(20,21),
 ( 2,9)( 3,11)( 4,12)( 5,13)( 7,14)( 8,15),
 ( 1,7)( 2,13)( 3,17)( 4,20)( 8,22)(16,28)(23,35)(29,37),
 ( 1,10)( 3,12)( 5,14)( 8,16),( 1,2)( 7,8)(12,13)(19,20),
 ( 1,2)( 7,8)(12,13)(21,22)(23,24),( 1,24)( 3,25)( 6,28)(10,29)(11,30)
  (14,31)(16,34)(19,35)(21,36)(26,37)(32,38),
 ( 1,2)( 7,8)(13,15)(25,26)(29,30)(31,32)(33,34)(35,36),
 ( 3,7)( 4,8)(13,16)(15,17)(18,20)(19,21),
 ( 2,3)( 4,5)( 9,10)(16,17)(20,21)(24,25),( 2,3)( 4,5)( 9,10)(16,17),
 ( 1,10)( 3,12)( 6,15)( 8,16)(18,22)(19,28),
 ( 1,2)( 7,8)(14,15)(17,18)(23,24)(26,27)(31,32)(33,34)(38,39)(41,42)
  (43,44)(46,47)(52,53)(54,55)(57,58)(59,60)(61,62)(63,64)(67,68)(71,72)
  (79,80)(81,82)(88,89)(91,92),( 1,2)( 7,8)(14,15)(17,18)(23,24)(26,27)
  (31,32)(33,34)(38,39)(41,42)(44,45)(46,47)(50,51)(56,57)(59,60)(62,63)
  (64,65)(68,69)(72,73)(75,76)(77,78)(81,82)(83,84),
 ( 2,9)( 3,10)( 4,11)( 5,12)( 7,14)( 8,15),
 ( 1, 2)( 7, 8)( 14,15)( 19,20)( 22,23)( 27,28)( 30,31)( 35,36)
  ( 38,39)( 40,41)( 43,44)( 46,47)( 51,52)( 53,54)( 56,57)( 58,59)
  ( 62,63)( 66,67)( 70,71)( 73,74)( 77,78)( 81,82)( 84,85)( 87,88)
  ( 91,92)( 95,96)( 99,100),( 1,3)( 2,6)( 4,10)( 7,12),
 ( 2, 3)( 4, 5)( 13,14)( 17,18)( 29,30)( 34,35)( 42,43)( 46,47)
  ( 49,50)( 51,52)( 53,54)( 55,56)( 57,58)( 59,60)( 65,66)( 67,68)
  ( 69,70)( 72,73)( 86,87)( 88,89)( 94,95)( 98,99)(108,109)(113,114)
  (115,116),( 3,17)( 6,19)( 9,20)(15,21)(18,39)(22,41)(23,42)(26,44)(27,46)
  (28,48)(31,50)(32,52)(33,53)(36,55)(37,56)(38,58)(45,65)(47,67)(51,69)
  (57,71)(59,73)(60,75)(61,77)(62,79)(63,81)(64,83)(68,85)(74,86)(76,87)
  (78,89)(80,90)(82,92)(84,93)(88,95)(91,96)(94,97),
 ( 2,41)( 3,45)( 6,46)( 9,47)(10,50)(13,53)(15,55)(18,56)(21,58)(22,62)
  (25,63)(28,64)(30,67)(33,70)(34,72)(37,73)(39,75)(44,76)(49,78)(52,79)
  (61,81)(66,83)(69,84),( 1,2)( 7,8)(14,15),
 ( 3,7)( 5,8)( 9,14)(10,17),( 1,2)( 7,8)(17,20)(25,26)(29,30)(31,32)
  (33,34)(35,36),( 3,7)( 5,8)( 9,13)(10,17),
 ( 1,3)( 2,6)( 5,10)( 8,12)(13,15)(14,16),
 ( 1,10)( 4,30)( 6,36)( 9,42)(12,43)(14,47)(16,49)(18,50)(21,51)(25,52)
  (27,53)(29,57)(32,59)(35,61)(40,63)(46,65)(56,68)(60,70)(64,71)(67,72),
 ( 1,6)( 2,11)( 3,12)( 5,15)( 8,16)(10,17)(14,20)(19,23)(22,24),
 ( 2,3)( 5,10)(11,13)(12,14),( 3,7)( 5,8)( 9,12)(13,15)(14,16),
 ( 1,3)( 2,6)( 5,9)(10,13)(11,15),( 1,2)( 8,10)(12,14)(15,17)(20,22)
  (23,25)(27,29)(30,31)(35,36)(38,40)(41,43)(45,46)(50,51),
 ( 1,10)( 4,18)( 5,22)( 7,27)(11,47)(13,48)(15,51)(19,52)(20,53)(23,54)
  (25,57)(28,58)(30,59)(32,60)(41,67)(49,70)(55,71)(62,74)(66,75),
 ( 1,2)( 8,10)(12,14)(16,18)(24,25)(28,30)(32,33)(36,38)(40,41)(43,45),
 ( 3,7)( 5,8)(10,14)(13,15),( 1,10)( 4,18)( 6,33)( 7,35)( 11,39)
  ( 13,41)( 14,43)( 15,45)( 19,48)( 20,51)( 21,53)( 22,54)( 24,55)
  ( 25,57)( 36,73)( 37,76)( 38,77)( 46,79)( 47,82)( 49,83)( 52,84)
  ( 74,102)( 80,103),( 1,10)( 4,18)( 6,22)( 8,26)(11,43)(13,44)(14,45)
  (16,48)(19,49)(23,50)(24,51)(27,54)(29,55)(31,57)(35,64)(46,73)(52,74)
  (61,79)(69,82),( 3,7)( 5,8)(10,12)(11,13),
 ( 1,10)( 4,18)( 6,20)( 9,22)(11,23)(15,25)(17,26),
 ( 3,7)( 5,8)(11,12)(13,15)(14,16),( 1,10)( 4,17)( 6,25)( 8,31)
  ( 9,35)( 13,39)( 14,40)( 18,41)( 22,47)( 23,48)( 26,50)( 29,53)
  ( 32,54)( 45,66)( 46,67)( 51,72)( 58,78)( 64,80)( 65,81)( 69,86)
  ( 77,88)( 79,92)( 83,97)( 90,100)( 94,102),
 ( 3,7)( 6,13)( 9,15)(11,18)(12,19)(14,21)(17,23),
 ( 1,2)( 8,10)(14,15)(20,22),( 1,2)( 8,10)(15,17),
 ( 1,2)( 8,10)(15,16)(18,19)(21,22)(23,24)(25,26),
 ( 1,10)( 4,13)( 5,16)( 7,19)(11,21)(15,23),
 ( 1,2)( 8,9)(10,11)(12,13)(14,15)(17,18),
 ( 2,9)( 4,13)( 6,18)( 7,21)(12,24)(19,26)(23,27)(25,29),
 ( 1,10)( 4,13)( 6,14)( 8,16)(18,22)(19,28),
 ( 1,2)( 8,9)(11,12)(13,14)(15,16)(18,19),
 ( 1, 6)( 2,10)( 3,15)( 4,24)( 5,30)( 35,50)( 36,55)( 40,59)
  ( 41,61)( 45,64)( 46,66)( 48,67)( 52,71)( 53,73)( 54,82)( 75,92)
  ( 78,94)( 81,96)( 84,98)( 87,100)( 90,102)( 91,103)( 93,105)( 95,106)
  ( 97,108)( 99,109)(101,111),( 2, 3)( 5, 7)( 12,13)( 21,23)( 34,36)
  ( 40,41)( 46,47)( 48,49)( 50,52)( 57,58)( 62,63)( 64,65)( 66,68)
  ( 70,71)( 73,74)( 75,76)( 77,78)( 79,80)( 82,83)( 84,85)( 86,87)
  ( 88,89)( 91,92)( 94,95)( 97,98)(100,101),
 ( 1,10)( 4,12)( 5,15)( 6,17)( 7,19)( 8,20)( 9,24)(22,28)(25,30)(26,32)
  (27,34),( 2,14)( 5,22)( 6,33)( 7,34)( 8,36)( 10,37)( 11,38)
  ( 12,40)( 13,43)( 17,46)( 18,48)( 19,50)( 21,52)( 25,56)( 39,74)
  ( 42,75)( 44,76)( 45,79)( 53,81)( 54,82)( 55,85)( 78,102)( 84,103),
 ( 1,2)( 8,9)(11,12)(17,18)(20,21)(25,26)(27,28)(32,33)(35,36)(42,43)
  (44,45)(47,48)(51,52)(54,55)(56,57)(58,59)(60,61)(66,67)(68,69)(70,71)
  (75,76)(83,84)(90,91)(93,94),( 3,7)( 6,8)(11,14)(13,15),
 ( 3,7)( 8,15)( 9,18)(10,31)(11,34)(12,44)(21,45)(23,46)(32,47)(33,48)
  (42,49),( 3,7)( 8,15)(10,16)(11,18)(12,19)(13,20)(14,22),
 ( 2,9)( 4,12)( 6,14)( 8,16)(10,18),( 1,10)( 4,12)( 7,14)( 8,18)(15,20)
  (16,22),( 1,2)( 8,9)(12,13)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 1,23)( 2,24)( 4,25)( 6,27)( 7,28)( 9,31)(11,32)(12,33)(13,35)(15,36)
  (16,39)(18,40)(20,41)(22,42)(29,46)(37,48)(43,50),
 ( 1,23)( 3,27)( 4,28)( 6,29)( 7,30)( 8,33)(10,35)(12,36)(13,37)(15,38)
  (17,41)(18,43)(20,44)(22,45)(25,46)(32,47)(40,48),
 ( 1,2)( 8,9)(13,14)(15,17)(19,21)(22,24)(27,29)(30,32)(34,36)(37,38)
  (42,43)(45,47)(48,50),( 3,7)( 8,12)(13,16)(17,21)(22,24)(28,31)(37,40),
 ( 1,2)( 8,9)(13,14)(16,18)(19,21)(23,24)(28,29)(30,32)(34,36)(37,39)
  (42,44)(45,47)(49,51),( 1,2)( 8,9)(13,14)(16,17)(19,20)(21,22)(23,24),
 ( 1,6)( 2,10)( 9,36)(11,37)(13,38)(14,39)(15,42)(17,43)(19,46)(20,49)
  (21,50)(22,51)(23,53)(24,54)(25,57)(26,58)(33,86)(35,87)(45,89)(48,90),
 ( 3,14)( 6,16)( 7,19)( 8,21)(11,24)(12,26),
 ( 1,2)( 8,9)(13,14)(17,18)(22,23),( 1,3)( 4,10)( 5,13),
 ( 3,7)( 8,10)(12,14)(17,19),( 2,4)( 6,22)( 7,24)( 9,26)(12,29)(14,31)
  (16,34)(19,35)(21,36)(27,38)(32,40),( 1,6)( 2,9)( 3,12)( 4,16)( 8,17)
  (10,19)(14,20),( 1,10)( 6,31)( 9,32)( 11,36)( 12,37)( 14,39)
  ( 17,40)( 20,41)( 22,43)( 23,44)( 24,46)( 33,72)( 35,75)( 38,78)
  ( 42,83)( 45,86)( 47,95)( 49,97)( 51,99)( 53,101)( 56,105)( 58,107)
  ( 60,109)( 62,111)( 64,113)( 67,117)( 69,119)( 71,120)( 74,121)( 76,122)
  ( 80,123)( 82,124)( 84,125)(102,133)(114,135),
 ( 1,2)( 8,9)(13,14)(18,19)(24,25)(31,32),
 ( 1,10)( 6,27)( 8,33)(12,41)(13,42)(15,43)(16,44)(19,47)(23,50)(26,51)
  (28,52)(30,53)(34,55)(37,58)(40,59)(46,62)(48,63)(54,66)(56,67)(61,69)
  (65,71),( 2,9)( 4,11)( 6,13)( 7,15)(12,19)(14,20),
 ( 1,2)( 8,9)(13,14)(18,19)(25,26)(31,32)(39,40),
 ( 1,23)( 3,26)( 5,28)( 7,30)( 9,33)(10,35)(11,36)(13,37)(15,39)(16,42)
  (18,44)(20,45)(21,46)(24,47)(25,48)(31,49)(32,50)(40,51)(41,52),
 ( 1,2)( 8,9)(13,14)(18,19)(25,26)(32,33),
 ( 1,2)( 8,9)(13,14)(18,19)(29,30)(35,36)(38,39),
 ( 3,7)(10,20)(11,27)(12,34)(13,41)(16,42)(22,43)(25,44)(31,45)(35,46)
  (40,47),( 1,23)( 3,26)( 6,27)( 9,28)(11,30)(14,33)(16,34)(19,35)(21,36)
  (24,38)(31,39),( 1, 9)( 2,21)( 3,24)( 4,27)( 5,35)( 36,45)
  ( 39,57)( 40,58)( 42,61)( 46,63)( 47,66)( 51,68)( 52,69)( 54,71)
  ( 55,80)( 72,89)( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)( 88,102)
  ( 90,103)( 92,106)( 94,107)( 96,110)( 98,111),
 ( 3,7)(10,17)(11,24)(12,31)(13,38)(14,42)(18,43)(23,44)(27,45)(33,46)
  (36,47),( 1,2)( 8,9)(14,15)(17,18)(22,23)(25,26)(30,31)(33,34)(39,40)
  (41,42)(43,44)(48,49)(51,52)(55,56)(57,58)(60,61)(63,64)(68,69)(71,72)
  (75,76)(78,79)(81,82)(85,86)(87,88)(90,91)(93,94)(96,97),
 ( 3,7)(10,13)(14,17)(18,21)(22,24)(25,27)(31,33)(34,36)(40,42)(43,45),
 ( 1,23)( 3,25)( 4,26)( 5,27)( 7,30)( 9,31)(10,33)(12,34)(14,35)(15,38)
  (17,39)(18,40)(20,41)(22,44)(29,45)(37,47)(43,49),
 ( 1,9)( 2,19)( 3,39)( 5,42)( 7,43)(10,46)(12,47)(14,49)(15,50)(17,53)
  (20,55)(23,58)(25,59)(27,61)(29,64)(31,66)(34,69)(36,70)(38,71)(40,74)
  (45,76)(48,77)(51,78)(54,79)(57,81)(60,82)(62,83)(65,84)(68,86)(72,87)
  (75,88)(80,90)(85,91)(89,92),( 1, 2)( 8, 9)( 19,20)( 22,23)
  ( 26,27)( 29,30)( 34,35)( 37,38)( 39,40)( 41,42)( 43,44)( 46,47)
  ( 48,49)( 50,51)( 54,55)( 56,57)( 59,60)( 63,64)( 67,68)( 74,75)
  ( 77,78)( 80,81)( 82,83)( 87,88)( 90,91)( 92,93)( 97,98)(101,102),
 ( 1,2)( 8,9)(19,20)(22,23)(26,27)(29,30)(34,35)(37,38)(39,40)(42,43)
  (44,45)(46,47)(50,51)(54,55)(56,57)(59,60)(61,62)(64,65)(66,67)(70,71)
  (75,76)(78,79)(82,83)(84,85)(89,90),( 2,3)( 5,6)( 9,10)(12,13)(16,17)
  (26,27)(28,29)(30,31)(32,33)(35,36)(37,38),
 ( 1,2)( 9,15)(10,16)(12,17)(14,20)(18,21)(19,22),
 ( 1, 9)( 2,18)( 4,45)( 11,49)( 14,50)( 17,51)( 20,55)( 22,56)
  ( 25,57)( 28,60)( 32,64)( 34,65)( 38,69)( 39,70)( 43,74)( 46,77)
  ( 52,84)( 53,85)( 59,90)( 61,95)( 62,97)( 66,99)( 67,101)( 71,103)
  ( 72,105)( 75,106)( 79,107)( 82,108)( 87,109),
 ( 1,9)( 2,18)( 5,31)(10,42)(14,43)(16,45)(19,48)(22,49)(27,53)(32,54)
  (34,56)(36,59)(37,60)(39,63)(41,65)(44,66)(46,67)(55,68)(57,69),
 ( 1,2)( 9,11)(12,15)(21,24)(25,27)(28,31)(34,37)(38,41)(45,46)(49,50)
  (52,53)(56,57)(59,60)(63,64),( 1,9)( 2,17)( 3,25)( 4,32)( 5,40)( 7,44)
  (10,45)(13,46)(15,48)(18,50)(21,51)(23,52)(26,53)(29,55)(31,57)(33,58)
  (36,59)(38,60)(41,62)(43,64),( 1,3)( 4,9)(10,14)(11,15),
 ( 1,2)( 9,11)(12,14)(16,17)(21,22)(23,25)(27,29)(30,32)(35,37)(38,40)
  (42,44)(45,46)(50,51),( 1,2)( 9,11)(12,14)(17,19)(20,22)(24,26)(27,28)
  (32,33)(35,37)(38,40)(42,43)(47,48)(49,51),
 ( 1,9)( 2,17)( 4,25)( 7,38)(13,45)(16,46)(20,47)(22,49)(24,50)(28,52)
  (31,53)(34,54)(37,55)(41,57)(44,59)(51,60)(58,61),
 ( 1,23)( 3,24)( 4,25)( 6,28)( 8,30)( 9,31)(11,32)(13,33)(14,37)(16,38)
  (17,39)(19,40)(20,43)(21,45)(26,46)(34,47)(41,48),
 ( 1,2)( 9,11)(13,14)(15,17)(18,20)(21,22)(25,26)(27,29)(30,32)(33,34)
  (37,38)(40,42)(46,48)(49,50)(58,60)(61,62)(69,70)(73,74)(79,80),
 ( 1,9)( 2,16)( 3,24)( 4,31)( 5,39)( 8,44)(11,46)(13,48)(15,49)(18,50)
  (20,51)(23,53)(25,55)(27,56)(30,57)(33,58)(35,60)(38,62)(41,63)(43,64),
 ( 1, 9)( 2,16)( 3,22)( 4,28)( 5,32)( 6,38)( 8,41)( 12,42)
  ( 14,43)( 18,45)( 20,47)( 23,50)( 25,51)( 26,53)( 29,54)( 31,57)
  ( 35,58)( 36,60)( 39,61)( 40,63)( 44,64)( 48,65)( 49,67)( 52,70)
  ( 55,71)( 56,73)( 59,75)( 62,79)( 66,82)( 68,83)( 69,85)( 72,87)
  ( 74,89)( 77,90)( 78,92)( 80,93)( 81,95)( 84,97)( 86,99)( 91,101)
  ( 94,104)( 96,106)(100,107)(103,108),( 1,3)( 4,7)( 9,11)(12,15)(17,18)
  (19,22)(26,29)(38,40)(42,44)(47,48)(49,51)(52,54)(55,56)(57,58)(60,62)
  (65,66)(67,68)(69,71)(72,73)(74,75)(76,77)(79,81)(83,84)(86,88)(90,91)
  (92,93)(94,95),( 1,9)( 2,16)( 3,19)( 4,28)( 5,32)( 6,39)( 7,41)(12,43)
  (13,45)(15,47)(17,48)(21,50)(24,52)(26,53)(29,54)(31,56)(34,57)(36,59)
  (38,60)(42,62)(44,63)(46,64)(49,67)(51,68)(55,69)(58,71)(61,72)(65,74)
  (66,75)(70,77)(73,79)(76,81)(78,83)(80,84)(82,85),
 ( 1, 3)( 4, 7)( 9,11)( 12,15)( 19,22)( 30,32)( 37,39)( 42,43)
  ( 44,46)( 47,48)( 49,50)( 52,54)( 55,56)( 58,60)( 62,63)( 64,66)
  ( 67,68)( 69,70)( 71,72)( 73,74)( 75,76)( 77,79)( 80,81)( 82,83)
  ( 86,87)( 88,89)( 90,91)( 92,93)( 96,97)( 98,100)(101,102)(103,105),
 ( 1,23)( 3,24)( 4,25)( 6,26)( 8,30)( 9,31)(11,32)(13,33)(14,34)(16,38)
  (18,39)(21,42)(27,43)(28,44)(29,45)(35,47)(36,48)(37,49)(40,51)(41,52)
  (46,54)(50,55)(53,56),( 2,9)( 4,10)( 7,12)( 8,14)(11,17)(13,19),
 ( 3,6)( 4,7)( 9,13)(11,15),( 2,3)( 5,6)(10,11)(17,18)(23,24)(26,27)
  (31,32)(34,35)(39,40)(43,44)(46,47)(48,49)(51,52)(55,56)(58,59)(62,63)
  (65,66)(67,68)(71,72)(76,77)(78,79)(82,83)(84,85)(88,89),
 ( 1,9)( 2,15)( 3,21)( 4,30)( 5,34)( 6,37)( 8,40)(10,43)(13,45)(16,47)
  (18,48)(22,49)(24,52)(26,53)(27,55)(29,57)(32,59)(35,60)(39,62)(41,63)
  (42,65)(46,66)(50,67)(51,69)(54,70)(58,72)(61,73)(64,74)(68,76)(71,78)
  (75,79)(77,80),( 2,9)( 5,13)( 7,16)( 8,18)(10,22)(15,24),
 ( 1, 9)( 2,15)( 3,21)( 5,34)( 10,39)( 12,41)( 13,45)( 17,46)
  ( 19,49)( 23,53)( 25,57)( 27,58)( 35,83)( 38,84)( 42,85)( 47,86)
  ( 51,87)( 54,88)( 61,96)( 65,98)( 69,100)( 73,102)( 77,104)( 81,106),
 ( 1,23)( 3,24)( 5,27)( 6,28)( 8,29)( 9,30)(11,33)(12,35)(13,36)(15,37)
  (17,38)(18,41)(20,43)(22,44)(25,46)(31,48)(39,50),
 ( 1,2)( 5,6)( 8,9)(10,11)(13,14)(16,17)(19,20),
 ( 1,2)( 9,10)(12,13)(16,17)(25,26)(27,28)(29,30),
 ( 2,9)( 5,12)( 7,13)( 8,16),( 3,6)( 5,7)(10,13)(14,16)(15,17),
 ( 1,2)( 9,10)(12,13)(18,19)(20,21),( 1,2)( 9,10)(12,13)(18,19)(21,22),
 ( 1,2)( 9,10)(12,13)(21,22)(26,27)(34,35)(42,43)(44,45)(47,48)(49,50)
  (51,52)(53,54)(55,56)(58,59)(71,72)(74,75)(76,77)(78,79)(80,81)(83,84)
  (85,86)(88,89)(90,91)(92,93)(94,95)(97,98),
 ( 2,3)( 5,6)(12,13)(23,24)(26,27)(30,31)(33,34)(38,39)(40,41)(43,44)
  (45,46)(47,48)(51,52)(55,56)(57,58)(60,61)(62,63)(65,66)(67,68)(71,72)
  (76,77)(78,79)(82,83)(84,85)(89,90),( 1,2)( 9,10)(13,14)(16,18)(19,21)
  (23,24)(25,27)(28,30)(31,32)(34,36)(39,40)(46,47)(48,50)(51,52)(58,59)
  (60,62)(66,67)(68,70)(73,74)(81,82)(87,88),
 ( 1,9)( 2,15)( 5,25)( 7,33)(11,40)(14,44)(17,48)(19,49)(22,50)(27,55)
  (29,56)(31,60)(35,61)(38,62)(42,64)(46,65)(52,67)(58,68),
 ( 1,23)( 3,24)( 5,25)( 6,27)( 8,30)(10,31)(11,32)(12,33)(14,35)(15,38)
  (17,39)(18,40)(20,42)(22,45)(29,46)(37,47)(44,48),
 ( 1, 9)( 2,14)( 3,26)( 4,36)( 6,38)( 7,42)( 12,43)( 16,45)
  ( 18,46)( 20,50)( 22,52)( 23,53)( 25,55)( 27,57)( 40,72)( 41,73)
  ( 48,78)( 49,79)( 51,82)( 71,103)( 77,105),
 ( 3,6)( 7,10)( 8,12)( 9,13)(11,14),( 1,9)( 2,14)( 3,22)( 4,25)( 5,32)
  ( 6,36)( 7,40)(11,42)(12,43)(16,45)(17,46)(19,48)(20,50)(24,53)(27,54)
  (29,55)(33,56)(35,57)(38,59)(41,60)(44,61)(47,63)(51,65)(52,66)(58,70)
  (62,74)(64,75)(67,77)(69,79)(71,80)(73,82)(76,83)(78,84)(81,86)(85,88)
  (87,89),( 1,2)( 5,6)( 9,10)(11,12)(19,20)(22,23)(26,27)(44,45)(55,56)
  (61,62)(65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)
  (91,92)(95,96),( 1,23)( 3,24)( 5,25)( 6,26)( 8,30)(10,31)(11,32)(13,33)
  (15,34)(17,36)(18,37)(20,38)(22,42)(27,45)(29,46)(35,49)(39,52)(41,53)
  (44,54)(48,55)(51,56),( 3,6)( 7,10)(11,14)(16,19)(20,23),
 ( 2,3)( 6,9)(11,14)(18,21)(22,25),( 1,2)( 9,10)(13,14)(18,19)(25,26)
  (31,32),( 1,23)( 3,24)( 6,28)(10,29)(13,30)(15,34)(18,35)(20,36)(25,37)
  (26,38)(31,39)(32,40),( 3,6)( 7,10)(12,15)(16,19),
 ( 3,6)( 7,10)(13,15)(17,18)(23,26)(33,35)(37,39)(42,43)(48,50)(51,52)
  (53,55)(58,59)(64,66)(68,69)(71,72)(73,75)(78,79)(81,83)(85,86)(88,90),
 ( 3, 6)( 7,10)( 14,16)( 23,26)( 31,32)( 34,36)( 38,39)( 41,43)
  ( 45,47)( 49,50)( 52,54)( 56,57)( 60,62)( 63,64)( 66,67)( 73,74)
  ( 79,81)( 83,84)( 86,88)( 89,91)( 92,94)(101,103)(104,106),
 ( 1,9)( 2,14)( 3,20)( 4,23)( 5,28)( 6,33)( 7,38)(10,39)(12,42)(15,44)
  (17,45)(19,48)(22,50)(24,52)(27,54)(29,57)(32,59)(37,60)(41,62)(43,63)
  (46,64)(49,65)(51,68)(53,70)(56,72)(58,73)(61,75)(66,77)(69,78)(71,81)
  (74,82)(76,85)(79,86)(83,87),( 2,3)( 6,8)( 9,10)(11,13)(14,16)(18,20)
  (21,23)(24,25)(26,28)(29,30)(31,33)(34,35)(36,38)(39,41)(43,45)(46,48)
  (49,50)(51,53)(54,55),( 3,10)( 4,11)( 6,13)( 9,15)(12,16),
 ( 1,23)( 4,27)( 6,28)(10,29)(13,32)(15,34)(18,35)(20,36)(24,37)(26,38)
  (30,39)(33,40),( 1,11)( 3,13)( 5,14)( 6,16)( 7,18)( 8,21)( 9,22)(23,29)
  (25,31)(26,33)(27,35),( 1,3)( 4,5)( 6,7)( 8,9)(10,12)(13,14)(15,16)
  (17,18),( 3,10)( 5,28)( 7,29)( 14,34)( 19,37)( 20,43)( 23,51)
  ( 26,59)( 30,62)( 31,63)( 33,65)( 35,68)( 39,80)( 41,83)( 42,86)
  ( 44,89)( 45,91)( 47,94)( 49,97)( 50,100)( 52,103)( 53,106)( 54,109)
  ( 57,111)( 58,114)( 60,117)( 61,121)( 64,125)( 66,126)( 70,131)( 71,132)
  ( 72,133)( 81,153)( 85,155)( 87,157)( 93,159)( 95,161)( 99,163)(101,165)
  (105,167)(107,169)(113,171)(115,173)(119,175)(123,179)(124,180)(129,181)
  (130,182)(134,185)(136,188)(138,189)(140,192)(142,195)(144,196)(146,199)
  (148,202)(150,203)(183,210)(186,211)(190,212)(193,213)(197,214)(200,215),
 ( 1,2)( 5,6)( 9,10)(13,14)(27,28)(29,30)(35,36)(37,38)(41,42)(43,44),
 ( 1,7)( 2,8)( 4,9)( 5,11),( 1,23)( 4,24)( 6,28)( 9,29)(10,30)(13,31)
  (16,35)(18,36)(21,37)(27,38)(34,39),( 1,3)( 4,5)( 7,8)(10,11)(14,15)
  (18,19),( 1,6)( 3,9)( 4,12)( 7,22)(11,24),
 ( 1,9)( 2,13)( 3,20)( 4,23)( 5,31)( 6,36)( 7,40)(10,42)(12,43)(16,44)
  (18,45)(21,46)(25,49)(26,51)(28,53)(29,54)(33,56)(34,57)(38,59)(41,63)
  (47,67)(48,68)(52,70)(55,72)(58,73)(60,74)(62,76)(64,77)(66,79)(69,81)
  (71,82)(75,84)(78,86)(80,87)(83,88)(85,89),
 ( 1,2)( 9,10)(14,15)(23,24)(29,30)(34,35)(38,39)(42,43)(46,47)(49,50)
  (53,54),( 1,2)( 9,10)(15,17)(20,22),( 3,6)( 7,8)(10,11)(13,14)(16,17)
  (19,20)(22,23),( 3,6)( 7,8)(10,11),( 1,2)( 9,10)(15,16)(20,21)(22,23)
  (26,27)(28,29),( 1,3)( 4,5)(19,20)(21,22)(23,24),
 ( 1,7)( 3,20)( 6,33)(10,42)(12,44)(14,47)(15,48)(17,51)(19,53)(24,54)
  (29,58)(32,59)(35,62)(37,64)(41,65)(50,66)(52,67)(61,68)(63,69),
 ( 1,38)( 4,40)( 5,42)( 7,45)( 9,46)(12,47)(15,51)(17,55)(20,58)(21,59)
  (24,61)(27,65)(30,66)(32,70)(33,74)(36,77)(43,79)(48,80)(52,81)(54,83)
  (63,85)(67,86)(71,87)(73,89),( 1,11)( 4,31)( 6,37)(10,42)(13,44)(15,48)
  (17,49)(22,50)(26,51)(28,53)(30,57)(33,58)(35,59)(36,60)(41,63)(43,64)
  (47,65)(52,68)(56,69),( 1,2)( 9,10)(17,18)(19,20)(23,24)(25,26)(31,32)
  (33,34)(37,38)(39,40)(45,46)(48,49)(53,54)(55,56),
 ( 1,2)( 9,10)(18,19)(23,24)(29,30)(33,34)(36,37)(38,39)(40,41)(43,44)
  (45,46)(49,50)(51,52)(53,54)(56,57)(59,60)(62,63)(65,66)(68,69)(70,71)
  (74,75)(76,77)(81,82)(84,85),( 1,2)( 9,10)(19,20)(21,22)(25,26)(27,28)
  (29,30)(32,33)(36,37)(42,43)(46,47)(49,50)(52,53)(56,57)(58,59)(64,65)
  (69,70),( 1,9)( 2,13)( 3,16)( 4,21)( 5,24)( 6,29)( 7,32)( 8,36)(11,39)
  (14,40)(18,41)(19,43)(22,45)(25,49)(27,52)(31,53)(35,54)(37,57)(44,58)
  (47,59)(48,61)(51,63)(56,67)(62,71)(65,72)(66,74)(69,76)(70,78)(75,80)
  (79,81),( 3,6)( 8,11)(13,16),( 1,23)( 5,26)( 7,28)( 9,29)(13,30)(15,32)
  (18,34)(20,35)(24,36)(27,38)(33,41)(39,43)(42,44),
 ( 3,6)( 8,11)(14,17)(19,22)(24,27),( 1,9)( 2,13)( 4,17)(11,22)(14,24)
  (19,25)(21,27),( 1,9)( 2,13)( 5,21)( 7,26)(10,48)(14,50)(15,51)(17,52)
  (19,53)(22,56)(24,57)(27,58)(29,59)(37,62)(44,66)(49,68)(54,70)(60,73)
  (63,75),( 1,22)( 2,27)( 3,32)( 4,35)( 9,42)(10,43)(11,45)(12,46)(14,48)
  (15,49)(18,50)(19,51)(21,52)(24,53)(25,54)(29,55)(30,56)(33,57)(34,58)
  (44,59)(47,60),( 1,23)( 5,24)( 9,25)( 10,26)( 14,27)( 18,28)
  ( 19,29)( 32,70)( 34,75)( 39,76)( 40,81)( 45,82)( 47,87)( 52,88)
  ( 54,93)( 59,94)( 60,99)( 65,100)( 67,105)( 71,106)( 80,107)( 83,108)
  ( 92,109)( 95,110)(104,111),( 1,2)(10,12)(13,14)(17,19)(20,21),
 ( 1,4)( 5,8)(11,15)(19,22)(25,27)(28,29)(32,34)(35,36)(40,42)(43,44),
 ( 1,2)( 5,6)(10,11)(17,18)(27,28)(35,36),
 ( 2,4)( 7,9)(12,14)(17,18)(28,30)(36,38)(42,44),
 ( 2,4)( 7,9)(12,14)(19,21)(27,28)(38,39)(42,43)(47,48)(50,51),
 ( 2,3)( 6,7)(10,11)(12,13)(20,21)(23,24)(27,28)(44,45)(55,56)(61,62)
  (65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)(91,92)
  (95,96),( 1,9)( 2,12)( 3,16)( 4,19)( 5,23)( 6,27)( 7,30)( 8,35)(11,41)
  (14,42)(18,45)(20,47)(22,49)(24,51)(26,52)(32,54)(34,56)(36,58)(38,60)
  (39,61)(46,62)(48,63)(55,65)(57,66),( 1,37)( 3,39)( 7,42)( 9,45)(10,48)
  (13,52)(16,54)(18,55)(20,58)(25,59)(27,62)(29,66)(31,68)(34,70)(36,71)
  (38,74)(43,75)(49,78)(51,81)(53,82)(63,86)(65,89)(67,90)(77,93)(83,94)
  (85,96)(91,97),( 1,5)( 6,10)(11,14)(15,18)(28,30)(34,36),
 ( 1,13)( 2,22)( 3,25)( 4,29)( 5,33)( 6,36)( 7,39)( 8,41)(10,42)(12,43)
  (14,44)(16,47)(17,48)(20,50)(24,51)(26,52)(28,53)(30,56)(32,57)(34,58)
  (38,62)(46,63)(55,66)(59,69)(64,70)(67,71),
 ( 2,3)(11,12)(15,16)(19,20)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32)
  (33,34)(35,36),( 1,8)( 2,9)( 4,12)( 5,13)( 7,16)(11,19)(15,22)(18,23)
  (21,24),( 1,2)( 5,6)(11,12)(22,23)(27,28)(30,31)(32,33)(34,35),
 ( 1,2)(10,11)(12,13)(14,15)(16,17)(18,19)(23,24)(27,28),
 ( 1,2)(10,11)(12,13)(16,17)(19,20),( 1,9)( 2,12)( 3,15)( 4,18)( 5,21)
  ( 6,24)( 7,26)( 8,32)(13,37)(19,42)(27,49)(29,51)(31,53)(33,56)(35,57)
  (36,58)(38,60)(39,62)(40,64)(41,65)(44,66)(45,68)(46,70)(47,72)(48,74)
  (52,76)(55,78)(61,81)(71,84)(75,86)(77,87)(80,88)(82,89)(83,90)(85,91),
 ( 1,2)(10,11)(12,13)(16,17)(20,21),( 3,6)( 9,11)(13,14)(15,16),
 ( 3,6)( 9,11)(14,15)(16,17),( 3,6)( 9,10)(12,15)(16,19)(21,22)(23,24),
 ( 3,6)( 9,10)(12,14)(15,17)(19,20),( 3,6)( 9,10)(13,14),
 ( 3,6)(10,20)(11,23)(12,32)(13,35)(14,38)(21,41)(22,42)(29,45)(30,46)
  (37,49),( 1,2)(10,11)(13,14)(15,16)(20,21)(22,23)(25,26)(27,28)(30,31)
  (35,36)(37,38),( 3,6)(10,17)(12,26)(13,29)(15,38)(19,40)(20,42)(27,43)
  (28,45)(35,46)(36,48),( 1,2)(10,11)(13,14)(16,17)(19,20)(21,22)(24,25)
  (28,29)(32,33),( 1,9)( 2,12)( 4,14)( 6,18)(15,22)(20,24),
 ( 3,6)(11,12)(13,14)(15,16),( 1,2)(10,11)(13,14)(16,17)(21,22)(23,24)
  (25,26)(27,28)(29,30)(31,32),( 3,5)( 4,9)( 6,10),
 ( 1,10)( 2,20)( 3,25)( 4,29)(32,36)(33,40)(34,51)(35,55)(37,67)(38,69)
  (42,70)(43,74)(47,76)(48,78)(52,79)(53,83)(57,85)(58,87)(62,88)(63,92),
 ( 1,3)( 5,7)( 9,11)(17,18)(26,27)(29,30)(33,34)(35,36),
 ( 1,9)( 2,11)( 3,17)( 4,20)( 5,24)( 6,27)( 7,33)( 8,35)(12,40)(14,43)
  (16,44)(18,47)(23,48)(25,51)(28,52)(30,55)(32,58)(36,59)(39,60)(42,61)
  (45,64)(50,65)(54,68)(56,69)(63,70)(67,71),
 ( 1,10)( 2,18)( 3,25)( 4,33)( 5,40)( 6,44)( 8,45)(11,46)(14,48)(16,50)
  (19,51)(22,52)(24,53)(26,55)(29,57)(31,58)(34,59)(36,60)(38,62)(41,64),
 ( 3,5)( 4,7)( 9,11)(10,14),( 1,3)( 5,7)( 9,10)(12,13),
 ( 1,3)( 5,7)(10,12)(15,17)(19,21),( 1,2)(10,11)(13,14)(19,20)(21,22)
  (23,24)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36),
 ( 2,3)( 6,7)(10,11)(20,21)(26,27)(28,29)(33,34)(38,39)(40,41)(44,45)
  (48,49)(51,52),( 1,9)( 2,11)( 3,15)( 4,21)( 5,25)( 6,31)( 8,37)(12,42)
  (14,44)(17,47)(18,49)(20,50)(23,52)(27,55)(30,57)(32,58)(34,60)(36,61)
  (38,62)(41,63)(43,64)(46,65)(48,68)(51,72)(53,73)(56,76)(59,80)(67,81)
  (69,82)(71,83)(75,84)(77,85)(79,86),( 2,3)( 6,7)(10,11)(21,22)(26,27)
  (28,29)(32,33)(34,35),( 1,3)( 5,7)(10,11)(13,14),
 ( 1,3)( 5,7)(11,13)(15,16)(17,18),( 1,2)(10,11)(14,15)(18,19)(22,23)
  (26,27)(31,32)(36,37)(40,41)(46,47)(49,50)(53,54),
 ( 1,2)(10,11)(14,15)(18,19)(23,24)(27,28)(30,31)(34,35)(39,40)(43,44),
 ( 1,3)( 5,7)(12,13)(18,20)(22,24)(35,37)(39,41)(43,44)(47,48)(49,50)
  (52,54)(55,57)(61,63)(65,66)(68,69)(71,73)(79,80)(81,83)(86,88)(90,91)
  (93,94),( 1,3)( 5,7)(12,13)(18,20)(23,24)(28,29)(32,33)(37,38)(41,42)
  (46,47),( 2,23)( 4,24)( 7,25)( 9,26)(12,30)(14,31)(17,32)(18,33)(21,36)
  (29,37)(35,39),( 1,22)( 3,23)( 5,24)( 6,25)( 8,30)(10,31)(11,32)(13,33)
  (15,34)(16,37)(17,38)(19,39)(21,44)(26,47)(29,48)(35,51)(40,54)(43,55)
  (46,56)(50,57)(53,58),( 3, 5)( 6, 9)( 11,13)( 14,16)( 19,20)
  ( 21,24)( 26,28)( 33,36)( 37,38)( 40,42)( 45,46)( 49,51)( 52,53)
  ( 54,56)( 57,58)( 62,63)( 66,68)( 70,71)( 73,75)( 77,78)( 79,81)
  ( 83,84)( 87,88)( 89,91)( 92,94)( 95,97)( 98,100)(101,103)(104,106)
  (107,109)(110,112)(113,115),( 3,5)( 6,9)(12,14)(15,18)(19,20)(22,23)
  (25,26),( 1,22)( 3,23)( 6,25)( 8,28)(10,29)(13,31)(15,33)(18,36)(20,37)
  (27,39)(35,40),( 1,3)( 5,7)(13,14)(19,21)(24,25)(27,29)(32,33)(35,37)
  (39,40)(42,44),( 3, 5)( 6, 9)( 13,16)( 21,24)( 25,28)( 31,35)
  ( 36,38)( 42,45)( 46,48)( 50,51)( 53,55)( 57,60)( 61,63)( 65,66)
  ( 69,71)( 73,75)( 78,80)( 82,84)( 87,89)( 90,92)( 95,97)(100,102)
  (105,107),( 1,2)(10,11)(16,17)(20,21)(22,23)(25,26),
 ( 1,2)(10,11)(17,19)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 1,9)( 2,11)(13,15)(17,33)(27,35)(29,41)(31,47)(36,48)(38,50)(40,52)
  (42,54)(44,56)(46,58)(51,61)(55,63)(59,65),
 ( 1,2)(10,11)(17,18)(19,20)(23,24)(26,27)(28,29)(31,32),
 ( 1, 2)( 10,11)( 18,19)( 25,26)( 31,32)( 36,37)( 38,39)( 42,43)
  ( 44,45)( 48,50)( 52,53)( 54,55)( 60,61)( 62,63)( 65,66)( 68,69)
  ( 72,73)( 74,75)( 76,77)( 79,80)( 84,85)( 87,88)( 91,92)( 94,95)
  ( 96,98)( 99,100)(102,103)(104,105)(106,108)(113,114)(115,116)(119,121)
  (123,125)(128,129)(130,131),( 1, 2)( 10,11)( 18,19)( 29,30)( 35,36)
  ( 37,38)( 39,40)( 42,43)( 44,45)( 46,47)( 48,49)( 53,54)( 57,58)
  ( 59,60)( 62,63)( 64,65)( 66,67)( 68,69)( 70,71)( 73,74)( 75,76)
  ( 77,78)( 79,80)( 81,82)( 83,84)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 99,100)(103,104)(108,109)(110,111)(112,113)(114,115)
  (119,120)(121,122)(123,124)(125,126)(129,130),
 ( 3,5)( 6,8)( 9,10)(12,13),( 1,9)( 2,10)( 4,14)(11,18)(15,20),
 ( 3,5)( 6,8)(10,12)(13,15)(18,19)(21,22)(24,25),
 ( 1,2)(11,13)(15,17)(19,21)(27,28)(33,34)(37,38)(40,41)(44,45)(47,48)
  (50,51)(53,54)(55,56)(58,60)(63,64)(66,67)(68,69)(72,73),
 ( 2,10)( 3,12)( 4,15)( 5,16)( 8,18)( 9,20)(11,22)(14,23)(19,24)(21,25),
 ( 1,9)( 2,10)( 4,12)( 5,13)( 7,15)(11,16)(14,17),
 ( 1,2)(11,12)(13,15)(16,18)(19,21)(24,26)(27,29)(30,32)(33,34)(37,38)
  (40,42)(43,45)(47,48),( 1,2)(11,12)(13,15)(18,20)(22,23)(27,28)(31,33)
  (39,40)(45,47)(49,51)(54,56)(58,60)(61,62)(63,64)(66,67)(72,73)(77,78)
  (79,80),( 1,22)( 4,23)( 6,24)( 9,27)(11,30)(14,31)(17,32)(20,37)(25,38)
  (28,39)(33,40)(35,41),( 1,2)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)
  (26,27),( 1,3)( 5,6)( 8,10)(12,14)(16,18)(22,24)(28,30)(32,34),
 ( 1,2)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(28,29),
 ( 3,5)( 6,8)(17,18)(21,22)(24,25)(28,29)(34,35)(36,37)(38,39)(43,44)
  (45,46)(52,53)(54,55)(56,58)(59,60)(61,62)(64,65)(75,76)(79,80)(81,82)
  (83,84),( 1,2)(11,12)(13,14)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27),
 ( 1,9)( 3,16)( 6,30)( 7,37)(12,44)(15,45)(18,47)(20,48)(23,49)(26,52)
  (29,53)(33,54)(36,55)(40,56)(43,59)(50,61)(57,63),
 ( 1,10)( 2,15)( 3,18)( 4,24)( 5,29)( 6,39)( 8,40)(12,42)(14,43)(16,46)
  (19,47)(21,48)(22,49)(25,51)(27,53)(30,56)(32,57)(34,60)(36,61)(38,62)
  (41,64)(45,67)(50,68)(52,69)(54,72)(59,73)(63,74)(65,75)(70,76),
 ( 1,10)( 2,15)( 3,18)( 4,24)( 5,29)( 6,38)( 8,39)(12,41)(14,42)(16,45)
  (19,46)(21,47)(22,48)(25,51)(27,53)(30,56)(32,57)(34,60)(36,61)(37,62)
  (40,65)(44,68)(49,69)(52,70)(54,73)(59,74)(63,75)(66,76)(71,77),
 ( 1, 5)( 2,21)( 6,37)( 7,38)( 8,40)( 10,41)( 12,43)( 13,44)
  ( 15,47)( 16,49)( 18,51)( 20,52)( 22,54)( 24,56)( 26,57)( 45,79)
  ( 48,81)( 50,82)( 59,86)( 60,87)( 80,104)( 85,106),
 ( 1,2)(11,12)(14,15)(16,17)(20,21)(22,23)(24,25)(27,28)(29,30)(32,33)
  (34,35),( 1,2)(11,12)(14,15)(17,18)(19,20)(21,22)(24,25)(28,29)(32,33),
 ( 2,3)( 6,7)(18,19)(22,23)(25,26)(29,30)(39,40)(43,44)(45,46)(47,48)
  (54,55)(60,61)(62,63)(64,65)(72,73)(77,78)(79,80)(82,83)(84,85),
 ( 1,3)( 5,6)(11,12)(16,17)(27,28)(33,34)(39,40)(45,46)(51,52)(54,55)
  (59,60)(62,63)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)(82,83)
  (84,85)(86,87)(88,89),( 1,9)( 3,14)( 4,18)( 6,23)(10,41)(12,43)(16,44)
  (19,45)(21,47)(24,49)(27,50)(29,51)(36,63)(42,71)(48,72)(55,76)(59,78)
  (62,79)(65,83)(69,85)(75,88)(77,89)(82,90)(84,91),
 ( 1,3)( 6,12)( 7,14)( 8,16)( 9,17)(10,18)(11,19)(13,20)(15,21),
 ( 1,9)( 3,14)( 5,21)(10,23)(12,24)(17,26)(20,27),
 ( 1,9)( 3,14)( 5,19)( 6,23)(11,48)(13,49)(16,50)(18,53)(21,54)(22,55)
  (26,56)(28,59)(30,60)(36,61)(42,64)(46,67)(52,68)(58,69),
 ( 2,3)( 7,9)(10,14)(18,21)(22,23)(24,27)(32,36)(37,39)(40,42)(45,48)
  (55,58)(59,60)(64,65)(67,68),( 1,2)(11,12)(14,15)(18,19)(30,31)(34,35)
  (37,38)(41,42)(44,45)(49,50)(51,52)(53,54)(61,62)(66,67)(68,69)(70,71)
  (78,79)(82,83),( 2,3)( 7,9)(10,12)(18,21)(22,23)(31,35)(36,38)(39,41)
  (47,48)(49,50)(53,54)(56,57)(58,59)(62,63)(72,73)(74,75),
 ( 1,3)( 6,11)( 9,13)(10,14),( 1, 5)( 2,15)( 3,20)( 4,22)( 26,30)
  ( 27,34)( 28,48)( 29,52)( 32,66)( 33,71)( 38,72)( 39,76)( 44,78)
  ( 45,83)( 50,84)( 51,88)( 56,90)( 57,95)( 62,96)( 63,100),
 ( 1,9)( 3,14)( 5,18)( 8,21)(15,23)(20,26)(22,28)(24,30),
 ( 2,3)( 7,9)(13,15)(16,18)(22,24),( 1,2)(11,12)(15,16)(17,19)(20,22)
  (23,25)(28,30)(31,33)(34,36)(37,38)(41,42)(44,46)(47,49),( 3,5)( 7,10),
 ( 1,2)(11,12)(15,16)(18,19)(22,23)(34,35)(38,39)(41,42)(44,45)(50,51)
  (52,53)(54,55)(60,61)(63,64)(68,69)(70,71)(79,80)(83,84),
 ( 1,2)(11,12)(15,16)(18,19)(22,23)(34,35)(38,39)(43,44)(51,52)(53,54)
  (55,56)(61,62)(68,69)(70,71)(72,73)(76,77)(78,79)(81,82)(83,84),
 ( 3,5)( 7,9)(10,12)(14,16)(17,18)(20,21)(23,24),
 ( 1,2)(11,12)(15,16)(19,20)(23,24)(26,27)(29,30)(34,35)(37,38)(44,45)
  (47,48)(52,53),( 1,9)( 3,13)( 5,18)( 7,21)(12,24)(19,26)(23,27)(25,29),
 ( 1,5)( 2,13)( 3,22)( 6,26)( 9,27)(16,30)(20,31),
 ( 1,4)( 7,9)(11,12)(17,20)(27,29)(33,36)(39,40)(43,45)(47,48)(50,51)
  (52,54)(57,58)(63,65)(67,68)(70,71)(72,74)(76,78)(81,83)(87,89),
 ( 2,8)( 5,12)(19,26)(20,28)(21,30)(22,31)(23,33)(24,35)(25,37)(39,41)
  (40,42),( 1,2)(11,12)(15,16)(19,20)(23,24)(32,33)(34,35)(37,38)(43,44)
  (48,49)(50,51)(54,55)(56,57)(61,62)(63,64)(69,70)(75,76)(77,78),
 ( 1,20)( 2,22)( 4,25)( 5,27)( 6,30)( 7,32)( 8,34)( 9,37)(11,39)(12,42)
  (13,44)(14,46)(15,49)(16,51)(18,54),( 1,5)( 2,13)( 3,18)( 6,23)(11,26)
  (14,30)(21,34)(24,38),( 3,5)( 7,9)(11,13)(18,19)(24,25)(29,30)(32,33)
  (36,37),( 1,20)( 2,21)( 3,24)( 4,27)( 5,29)( 6,30)( 8,35)(10,39)(11,42)
  (12,54)(15,61)(17,68)(22,73)(23,74)(25,75)(31,76)(32,77)(33,78)(37,79)
  (38,80)(40,81)(43,82)(44,84)(45,86)(46,88)(48,90)(49,92),
 ( 3,5)( 7,9)(11,13)(18,19)(25,27)(29,30)(33,35)(39,41)(43,44)(45,46)
  (47,48)(49,50),( 3,5)( 7,9)(11,13)(18,19)(25,26)(29,30)(33,34)(37,38)
  (40,41)(44,45),( 1,9)( 3,12)( 4,13)( 6,16),
 ( 1,2)(11,12)(15,16)(19,20)(29,30)(32,33)(34,35)(37,38)(43,44)(47,48)
  (49,50)(54,55)(60,61)(62,63)(68,69)(71,72)(73,74)(75,76)(78,79),
 ( 3,5)( 7,9)(11,13)(19,20)(26,27)(29,30)(32,33)(35,36),
 ( 1,3)( 6,8)(11,13)(16,18)(28,29)(36,37)(40,41),
 ( 2,3)( 7,8)(10,11)(14,15)(17,18)(28,29)(35,36)(38,39)(43,44)(47,48)
  (49,50)(52,53)(54,55)(57,58)(59,60)(63,64)(67,68)(69,70)(71,72)(74,75)
  (76,77)(78,79)(83,84)(85,86)(89,90),( 1,9)( 3,12)( 5,14)( 6,17)( 7,19)
  (10,21)(13,23)(18,25),( 1,3)( 6,8)(11,13)(16,17)(20,22),
 ( 1,3)( 6,8)(11,13)(18,20)(22,24)(26,28)(34,35)(41,42)(44,45)(47,48)
  (50,51),( 1,2)(11,12)(16,17)(19,20)(21,22)(23,24),
 ( 1,20)( 2,21)( 3,22)( 4,24)( 5,26)( 6,27)( 7,28)( 8,29)( 9,31)(18,32)
  (19,34),( 1,2)(11,12)(17,18)(19,20)(23,24)(26,27)(28,29)(31,32),
 ( 2,3)( 7,8)(10,11)(15,16)(18,19)(24,25)(31,32)(36,37)(39,40)(44,45)
  (48,49)(50,51)(53,54)(57,58)(60,61)(64,65)(67,68)(69,70)(72,73)(76,77)
  (78,79)(82,83)(84,85)(88,89),( 1,2)(11,12)(17,18)(21,22)(28,29)(32,33)
  (37,38)(40,41)(45,46)(48,49)(55,56)(58,59)(61,62)(65,66)(68,69)(72,73)
  (75,76)(78,79)(85,86)(88,89),( 2,4)(13,15)(18,20)(24,25)(29,30)(32,33)
  (36,37)(39,40),( 1,2)(11,12)(18,20)(22,24)(31,32)(35,36)(39,40)(42,43)
  (45,46)(48,49)(51,52)(54,55)(58,59)(62,63)(64,65)(68,69)(73,74)(75,76)
  (77,78)(80,81)(82,83)(84,85)(86,87)(92,93)(94,95)(96,97)(98,99),
 ( 1,2)(11,12)(18,20)(22,24)(32,33)(34,35)(39,40)(41,42)(45,46)(49,50)
  (52,53)(55,56)(58,59)(60,61)(62,63)(64,65)(69,70)(72,73)(75,76),
 ( 1,3)( 6,8)(11,13)(21,22)(28,30)(32,34)(36,38)(39,40)(42,43)(45,46)
  (48,49),( 2,3)( 7,8)(11,12)(14,15)(20,21),
 ( 1,2)(11,12)(22,23)(28,29)(32,33)(35,36)(37,38)(40,41)(44,45)(46,47)
  (50,51)(52,53)(55,56)(58,60)(61,62)(63,64)(65,66)(69,70)(77,78)(81,82),
 ( 3,5)( 7,9)(20,22)(23,25)(27,29)(34,35)(38,39)(43,44)(45,46)(48,50)
  (51,53)(59,60)(61,62)(64,66)(67,69)(72,74)(77,79)(80,81)(84,86)(87,88),
 ( 2,8)(10,16)(11,19)(12,28)(13,31)(14,38)(21,41)(22,42)(29,45)(30,46)
  (37,49),( 1,2)(12,15)(17,20)(21,22)(25,26)(31,32)(33,34)(35,36),
 ( 1,19)( 2,23)( 3,26)(28,37)(29,40)(30,43)(31,58)(32,61)(33,64)(34,77)
  (39,78)(41,79)(46,81)(48,83)(53,84)(55,85)(60,87)(62,89)(67,90)(69,91)
  (74,93),( 1,2)(12,13)(14,16)(17,18)(19,21)(22,23)(24,26),
 ( 1,4)( 8,9)(11,12)(13,14)(16,17)(18,19)(21,22),
 ( 2,3)( 7,8)(11,12)(16,17)(28,29)(36,37)(43,44),
 ( 1,2)(12,13)(14,15)(16,17)(18,19)(20,21)(22,23),
 ( 1,3)( 6,8)(14,15)(17,18)(20,21)(22,23)(24,25),
 ( 1,19)( 2,22)( 4,26)( 6,31)( 7,32)( 8,34)( 9,37)(10,40)(11,41)(13,52)
  (15,59)(18,66)(21,73)(23,74)(24,75)(28,76)(29,77)(30,78)(36,79)(38,80)
  (39,81)(43,83)(44,85)(46,87)(47,89)(48,91)(49,93),
 ( 1,3)( 6,8)(15,16)(19,20)(24,25)(26,27)(31,32),
 ( 3,5)( 7,8)(10,11)(13,14)(16,17)(20,21),
 ( 3,5)( 7,8)(10,11)(15,16)(17,18)(20,21)(22,23),
 ( 1,2)(12,13)(15,16)(18,20)(22,24)(29,31)(33,35)(37,38)(42,43)(46,47)
  (49,51)(54,55)(59,61)(64,65)(67,68),( 3,5)( 7,8)(11,14)(15,17)(23,24)
  (26,27),( 1,3)( 6,7)(10,12)(15,17)(20,22),
 ( 2,7)( 3,10)(15,25)(16,27)(18,33)(20,39)(22,45)(28,52)(32,56)(36,60)
  (40,64)(44,68)(48,72)(53,75)(55,76)(61,79)(63,80)(69,83)(71,84),
 ( 1,2)(12,13)(15,16)(18,19)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 3,5)( 7,8)(11,12),( 1,2)(12,13)(16,18)(25,27)(29,31)(33,34)(35,37)
  (38,39)(41,42)(44,45)(46,47)(49,50)(53,55)(58,59)(62,63)(65,66)(68,69)
  (72,73)(77,78),( 3,5)( 7,8)(13,16)(23,25)(29,32)(33,36)(38,39)(43,45)
  (47,48)(51,53)(56,57)(62,64)(66,67)(69,70)(71,73)(75,77)(80,81)(82,84)
  (86,87)(88,90),( 1, 2)( 12,13)( 16,18)( 28,30)( 32,33)( 35,36)
  ( 38,39)( 41,42)( 45,46)( 47,48)( 49,51)( 54,55)( 57,58)( 59,60)
  ( 62,63)( 65,66)( 67,68)( 69,70)( 72,73)( 76,77)( 79,80)( 83,84)
  ( 86,87)( 88,89)( 93,94)(100,101)(106,107),
 ( 1,19)( 3,22)( 5,24)( 8,28)( 11,40)( 13,47)( 14,48)( 15,52)
  ( 17,57)( 18,62)( 20,66)( 25,71)( 29,75)( 31,80)( 33,82)( 34,84)
  ( 35,86)( 36,89)( 37,91)( 38,93)( 39,96)( 41,97)( 42,99)( 43,101)
  ( 44,102)( 45,105)( 49,106)( 50,108)( 51,110)( 53,111)( 54,113)( 55,115)
  ( 56,116)( 58,119)( 59,121)( 60,123)( 61,124)( 63,126)( 64,128)( 67,129)
  ( 68,130)( 72,131)( 73,132)( 77,133)( 78,134)( 81,135)( 83,136)( 85,137)
  ( 87,138)( 90,139)( 92,140)( 94,141)( 98,142)(100,143)(103,144)(104,145)
  (107,146)(109,147)(112,148)(114,149)(117,150)(118,151)(120,152)(122,153)
  (125,154)(127,155),( 1,19)( 3,21)( 4,23)( 5,26)( 7,29)( 8,31)( 9,33)
  (11,35)(12,38)(13,41)(14,43)(15,45)(16,47)(17,50)(18,53),
 ( 2,3)( 7,8)(12,13)(16,17)(28,29)(36,37)(43,44),
 ( 3,5)( 8,10)(11,13)(14,15)(16,18)(19,20)(21,22)(23,24)(25,26),
 ( 1,2)(12,13)(16,17)(20,21)(25,26)(30,31)(32,33)(36,37)(38,39),
 ( 1,18)( 2,19)( 4,20)( 5,22)( 8,23)( 9,25)(11,26)(12,27)(14,29)(15,30),
 ( 1,3)( 7,10)(11,14)(18,20)(24,25)(26,28)(32,33)(35,37)(41,43)(47,48)
  (51,52)(54,55),( 1,18)( 3,19)( 4,20)( 7,22)( 8,23)(10,25)(11,26)(13,27)
  (14,29)(16,30),( 1,3)( 7,9)(12,14)(15,16)(18,19)(21,22),
 ( 1,9)( 3,10)( 4,12)( 6,13)( 7,14)(11,16)(15,17),
 ( 1,18)( 3,19)( 6,20)( 8,22)( 9,24)(11,25)(14,26)(16,28)(21,40)(27,41)
  (34,49)(44,61)(48,63)(54,64)(58,66),( 1,3)( 7,9)(13,14)(16,17)(19,20)
  (22,23)(24,25),( 3, 5)( 8,10)( 12,14)( 17,19)( 21,22)( 26,28)
  ( 33,34)( 39,40)( 44,45)( 47,48)( 52,53)( 60,61)( 63,64)( 66,67)
  ( 69,70)( 72,73)( 75,76)( 89,90)( 92,93)( 94,95)( 97,98)( 99,100)
  (102,103),( 3, 5)( 8,10)( 12,14)( 17,19)( 21,22)( 26,28)( 37,38)
  ( 43,44)( 46,47)( 52,53)( 60,61)( 63,64)( 66,67)( 69,70)( 72,73)
  ( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 96,97)( 98,99)
  (101,102)(105,106)(107,108)(109,110),( 1,2)(13,15)(17,18)(19,21)(22,23)
  (27,28)(30,31)(41,42)(46,47)(50,51)(52,53)(54,55)(56,57)(58,59)(60,61)
  (65,66)(69,70)(80,81)(84,85),( 1,2)(13,15)(17,18)(19,21)(23,24)(25,26)
  (28,30)(32,34)(36,38),( 3,5)( 8,10)(12,14)(20,22)(27,29)(35,37)(41,43),
 ( 3,5)( 8,10)(12,14),( 1,2)(13,14)(16,18)(19,21)(23,25)(30,32)(33,35)
  (37,38)(41,42)(46,47)(49,51)(53,54)(58,60)(65,66)(69,70),
 ( 1,17)( 2,24)( 3,27)( 4,35)( 9,41)(10,42)(11,44)(12,45)(14,47)(15,48)
  (18,49)(19,50)(22,52)(23,53)(26,54)(28,55)(30,56)(33,58)(34,59)(43,60)
  (46,61),( 3,5)( 8,10)(13,15)(16,18)(20,22)(28,29)(35,37)(40,41)(43,44)
  (48,49)(51,52)(53,54),( 1,2)(13,14)(16,18)(20,21)(25,26)(31,32)(36,38)
  (42,43)(46,47)(49,50)(51,52)(56,57)(58,59)(60,61)(62,63),
 ( 2,9)( 3,18)( 6,31)(10,42)(14,43)(16,45)(19,48)(22,49)(27,53)(32,54)
  (34,56)(36,59)(37,60)(39,63)(41,65)(44,66)(46,67)(55,68)(57,69),
 ( 1,9)( 4,17)( 5,21)( 7,29)(10,37)(16,39)(19,41)(20,42)(22,45)(24,49)
  (28,50)(31,54)(34,55)(38,57)(43,63)(44,67)(48,69)(56,78)(59,80)(62,82)
  (66,84),( 1,2)(13,14)(17,18)(20,21)(24,25)(34,35)(37,38)(42,43)(44,45)
  (49,50)(52,53)(58,59)(60,61)(62,63)(68,69)(71,72)(76,77)(80,81),
 ( 1,9)( 4,17)( 5,21)( 7,25)(11,43)(14,44)(16,47)(19,48)(20,49)(24,50)
  (27,53)(29,54)(35,60)(40,67)(46,71)(52,72)(56,76)(59,78)(64,80)(65,81)
  (75,87)(79,88),( 3,8)(10,14)(12,20)(13,23)(16,33)(21,35)(22,36)(25,37)
  (26,38)(28,40)(30,46)(52,63)(56,65)(60,67),
 ( 1, 2)( 7, 8)( 10,11)( 15,16)( 18,19)( 23,24)( 26,27)( 31,32)
  ( 38,39)( 40,41)( 45,46)( 47,48)( 51,52)( 53,54)( 56,57)( 60,61)
  ( 63,64)( 66,67)( 72,73)( 74,75)( 81,82)( 83,84)( 88,89)( 91,92)
  ( 94,95)( 97,98)(100,101)(103,104)(106,107)(109,110),
 ( 1, 5)( 2, 9)( 3,11)( 4,16)( 26,43)( 27,47)( 28,61)( 29,65)
  ( 32,67)( 33,71)( 38,72)( 39,77)( 44,79)( 45,83)( 50,84)( 51,89)
  ( 56,91)( 57,95)( 62,96)( 63,101),( 1,17)( 2,19)( 3,20)( 5,22)( 7,23)
  ( 8,24)(10,26)(12,27)(13,29)(15,30),( 3,5)( 8,10)(13,15)(18,19)(28,30)
  (36,38)(41,43),( 3,5)( 8,10)(13,15)(19,21)(23,25)(27,29)(35,36)(39,40)
  (43,44)(46,47)(49,50),( 1,24)( 3,26)( 7,27)(10,28)(12,30)(15,32)(17,33)
  (20,34)(22,35)(25,37)(31,38),( 1,2)(14,15)(19,20)(23,24)(25,26)(28,29)
  (30,31)(34,35)(38,39)(45,46)(48,49)(50,51)(53,54)(56,57)(58,59)(60,61)
  (62,63)(64,65)(66,67),( 3,5)( 8,10)(13,15)(20,22)(28,29)(39,40)(42,43)
  (47,48)(50,51),( 1,2)(14,15)(20,22)(24,26)(28,30)(32,33)(35,36)(39,40)
  (42,43)(45,46)(48,49)(51,52)(56,57)(60,61)(64,65)(68,69)(72,73)(77,79)
  (81,83),( 2,16)( 4,18)(12,23)(17,41)(21,43)(24,45)(25,48)(26,49)(27,51)
  (29,52)(30,53)(31,56)(32,57)(33,59)(35,60)(36,62)(37,63)(38,65)(40,66)
  (47,70)(50,71)(55,72)(58,73)(61,74)(64,75)(67,76)(68,78)(69,80),
 ( 1,9)( 4,14)( 6,17)( 7,18)(10,21)(16,23),
 ( 1,2)(15,16)(17,18)(19,20)(22,23)(25,26)(29,30)(33,34)(36,37),
 ( 1, 6)( 2,11)( 3,36)( 5,38)( 9,40)( 10,43)( 13,44)( 15,45)
  ( 17,48)( 18,49)( 23,52)( 25,55)( 27,58)( 42,76)( 46,78)( 54,83)
  ( 56,84)( 60,91)( 67,96)( 71,102)( 75,104)( 80,106)( 82,107)( 88,120)
  ( 90,122)( 93,123)( 95,124)( 98,126)(100,127)(103,131)(105,132),
 ( 1, 2)( 15,16)( 23,24)( 25,26)( 29,30)( 32,33)( 34,35)( 39,40)
  ( 41,42)( 45,46)( 47,48)( 50,51)( 52,53)( 55,56)( 61,62)( 63,64)
  ( 65,66)( 77,78)( 79,80)( 81,82)( 86,87)( 89,90)( 91,92)( 98,99)
  (102,103)(111,112)(116,117),( 1, 2)( 15,16)( 23,24)( 26,27)( 32,33)
  ( 34,35)( 36,37)( 41,42)( 49,50)( 51,52)( 58,59)( 60,61)( 64,66)
  ( 67,68)( 69,70)( 71,72)( 73,74)( 77,78)( 79,80)( 83,84)( 86,87)
  ( 88,89)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)(105,106)
  (107,108)(109,110)(111,112)(113,114)(118,119)(120,121)(122,123)(124,125)
  (127,128)(129,130)(138,139)(141,142),( 1, 2)( 15,16)( 23,24)( 27,28)
  ( 30,31)( 32,33)( 36,37)( 41,42)( 46,48)( 49,50)( 51,53)( 56,57)
  ( 59,60)( 61,62)( 65,66)( 67,68)( 70,71)( 72,73)( 75,76)( 77,78)
  ( 82,83)( 84,85)( 87,88)( 91,92)( 94,95)( 96,97)(102,103)(108,109)
  (111,112)(114,115),( 3,5)( 8,10)(13,14)(20,22)(27,29)(39,41)(43,45)
  (47,49)(50,52),( 1,2)(16,17)(19,20)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 1,2)(17,18)(21,22)(25,26)(29,30)(32,33)(38,39)(41,42)(43,44)(45,46)
  (47,48)(51,52)(53,54)(59,60)(65,66)(67,68)(74,75)(76,77),
 ( 1,2)(17,18)(21,22)(25,26)(29,30)(33,34)(36,37)(38,39)(41,42)(45,46)
  (47,48)(51,52)(53,54)(58,59)(62,63)(65,66)(71,72),
 ( 3, 5)( 8,10)( 15,16)( 22,24)( 38,39)( 42,43)( 44,46)( 48,50)
  ( 52,53)( 57,58)( 59,60)( 61,62)( 63,64)( 66,67)( 68,69)( 70,71)
  ( 72,73)( 74,75)( 78,79)( 90,91)( 92,93)( 95,96)( 97,98)( 99,100)
  (101,102)(103,104)(105,106)(107,108)(109,110)(111,112)(113,114)(115,116)
  (117,118),( 2,3)( 8,10)(12,14)(16,18)(23,24)(28,29)(31,32)(36,37),
 ( 2,3)( 8,10)(12,14)(16,18)(24,26)(28,29)(31,33)(36,37)(39,41)(44,45),
 ( 1,3)( 8,9)(11,12)(14,15)(17,18)(19,20)(22,23),
 ( 2,7)( 4,9)( 5,21)( 8,22)(16,27)(20,28)(24,29)(26,30),
 ( 1,5)( 2,8)( 3,10)( 9,22)(13,23),( 1,9)( 4,12)( 6,13)( 8,16)(11,19),
 ( 2,44)( 4,46)( 6,48)( 8,49)(10,51)(12,52)(15,54)(17,55)(19,57)(21,59)
  (24,61)(26,63)(28,65)(30,66)(33,68)(35,69)(37,71)(39,72)(41,74)(43,76),
 ( 1,9)( 4,12)( 6,13)(11,16)(15,17),( 1,17)( 3,18)( 5,19)( 6,22)( 9,23)
  (12,24)(13,27)(15,28)(20,44)(25,45)(32,46)(36,50)(40,52),
 ( 1,3)( 8,9)(14,16)(18,20)(23,24)(28,29)(33,34)(37,38)(40,41),
 ( 2,15)( 4,17)( 9,21)(11,22)(13,25)(16,46)(20,47)(23,48)(26,49)(28,52)
  (30,53)(33,55)(35,58)(37,59)(39,61)(41,64)(43,65)(51,70)(57,71)(63,72),
 ( 3,7)( 5,9)(12,14)(13,15),( 3,17)( 6,18)( 7,20)(10,21)(13,23)(14,24),
 ( 1,5)( 2,8)( 4,10)( 9,13)(11,15)(12,17)(14,18)(16,19),
 ( 1,3)( 8,9)(15,17)(19,21)(23,25)(29,31)(33,34)(37,38)(39,40),
 ( 2,41)( 3,43)( 6,44)( 8,47)(11,50)(14,52)(15,54)(18,57)(21,58)(23,60)
  (26,61)(27,64)(30,67)(32,69)(35,70)(36,72)(39,75)(46,76)(49,77)(56,79)
  (63,81)(66,82)(74,84),( 2,41)( 4,43)( 7,44)( 8,48)(11,49)(14,50)(15,52)
  (18,55)(20,58)(23,59)(24,61)(27,62)(29,66)(32,67)(35,68)(36,70)(39,74)
  (45,76)(53,78)(56,80)(63,82)(71,84)(72,86),
 ( 2,41)( 4,43)( 7,44)( 8,46)(11,49)(13,52)(16,53)(19,54)(20,58)(23,60)
  (26,61)(28,63)(31,66)(32,69)(35,70)(38,71)(39,75)(47,77)(50,78)(55,80)
  (64,82)(67,83)(72,85),( 3,5)( 9,10)(11,12),
 ( 2,41)( 4,42)( 7,44)( 8,45)(11,49)(13,50)(16,52)(17,53)(20,57)(23,59)
  (24,60)(27,62)(29,63)(32,67)(35,68)(36,69)(39,73)(48,75)(55,77)(56,79)
  (66,81)(71,83)(72,85),( 1,17)( 4,19)( 5,21)( 7,22)(10,23)(12,25)(13,26)
  (16,27)(20,39)(24,41)(30,46)(33,53)(52,64)(59,68),
 ( 1,3)( 8,9)(16,17)(19,20)(23,24)(26,27),
 ( 1,3)( 9,22)(10,25)(13,34)(14,37)(16,40)(23,43)(24,44)(31,47)(32,48)
  (39,51),( 1,3)( 9,15)(10,19)(11,28)(12,35)(16,36)(18,37)(24,38)(26,39)
  (31,40)(33,46)(34,53),( 3, 5)( 9,10)( 13,14)( 17,18)( 21,22)
  ( 27,28)( 33,34)( 38,39)( 44,45)( 47,48)( 54,55)( 59,61)( 62,63)
  ( 65,67)( 68,69)( 71,73)( 74,75)( 89,90)( 92,93)( 94,95)( 97,98)
  ( 99,100)(102,103),( 3, 5)( 9,10)( 13,14)( 17,18)( 21,22)( 27,28)
  ( 33,34)( 38,39)( 44,45)( 47,48)( 54,55)( 60,62)( 63,64)( 66,68)
  ( 69,70)( 72,74)( 75,76)( 89,90)( 91,92)( 94,95)( 96,97)( 99,100)
  (101,102),( 1,9)( 5,12)(10,15)(11,16)(13,17)(14,18),
 ( 2,41)( 5,42)( 8,46)( 9,48)(12,49)(15,50)(17,54)(20,55)(21,57)(24,58)
  (26,61)(29,64)(30,66)(33,67)(36,68)(37,72)(40,73)(44,75)(45,77)(53,79)
  (60,81)(63,83)(71,85),( 1,9)( 5,11)( 6,12)( 7,14)( 8,16)(10,18)(13,20)
  (15,22)(17,24)(19,25)(21,26)(23,27),( 1,3)( 9,12)(18,20)(21,22)(23,24)
  (25,26)(27,28)(29,30),( 1,17)( 4,18)( 5,19)( 7,21)(10,22)(12,23)(13,25)
  (16,27)(20,40)(24,42)(33,50)(36,57)(44,61)(51,65),
 ( 2,38)( 4,41)( 7,43)(10,44)(12,48)(15,52)(16,55)(19,56)(22,57)(25,59)
  (27,60)(28,64)(31,68)(33,71)(36,72)(37,74)(39,76)(45,78)(49,82)(51,83)
  (61,85)(65,89)(67,90)(80,91)(87,92),( 3,5)(10,12)(15,17)(20,22)(25,26)
  (36,37)(45,46)(48,49)(53,54),( 2,38)( 4,40)( 7,41)( 8,45)(11,49)(14,50)
  (17,53)(19,54)(20,56)(23,57)(25,61)(28,65)(29,68)(31,69)(33,71)(36,75)
  (42,78)(46,80)(48,82)(51,83)(58,86)(62,88)(64,90)(73,91),
 ( 3, 5)( 10,12)( 18,19)( 24,26)( 36,37)( 38,39)( 43,44)( 46,48)
  ( 50,52)( 53,54)( 57,58)( 61,62)( 63,64)( 65,66)( 67,68)( 69,70)
  ( 72,73)( 74,75)( 84,85)( 90,91)( 92,93)( 94,95)( 96,97)( 99,100)
  (101,102)(103,104)(105,106)(107,108)(109,110)(111,112)(113,114)(115,116)
  (117,118),( 3,5)(10,11)(12,13)(14,15)(16,17)(19,21)(22,23)(24,25)(28,29)
  (30,31)(32,33)(34,35),( 1, 8)( 2,23)( 4,47)( 7,48)( 15,51)
  ( 18,52)( 21,53)( 26,55)( 29,57)( 30,58)( 32,62)( 36,64)( 38,68)
  ( 42,70)( 50,76)( 54,79)( 56,81)( 60,89)( 61,91)( 63,92)( 66,94)
  ( 67,96)( 69,97)( 72,99)( 73,101)( 74,103)( 78,104)( 84,106)( 86,108)
  ( 88,110)(105,111)(107,112)(109,113),( 2,38)( 5,41)( 8,43)( 11,46)
  ( 12,48)( 15,50)( 17,51)( 20,54)( 23,59)( 25,60)( 27,62)( 28,63)
  ( 31,66)( 33,68)( 36,70)( 37,71)( 39,75)( 45,78)( 55,81)( 58,83)
  ( 65,85)( 74,89)( 77,92)( 80,95)( 84,98)( 88,99)( 91,100)( 94,101)
  ( 97,102),( 1,3)( 9,11)(18,19)(22,23)(25,26)(29,30)(32,33)(34,35)(39,40)
  (43,44)(46,47)(49,50)(53,54)(55,56)(57,58),
 ( 2,3)( 9,12)(16,17)(21,22)(25,26)(31,32)(33,34)(35,36),
 ( 2,3)( 9,12)(19,20)(22,23)(26,27)(29,30)(34,35)(36,37)(39,40)(42,43)
  (47,48)(49,50)(54,55)(56,57)(59,60)(61,62)(64,65),
 ( 2,38)( 6,42)( 7,45)( 9,49)( 13,51)( 14,53)( 18,55)( 21,58)
  ( 23,60)( 28,61)( 30,64)( 33,68)( 36,69)( 37,70)( 41,71)( 47,75)
  ( 48,76)( 50,79)( 52,83)( 54,84)( 59,85)( 63,89)( 65,93)( 67,94)
  ( 74,95)( 81,98)( 82,99)( 91,102)( 92,103)( 97,104)(101,105),
 ( 3,5)(11,12)(14,15),( 2,3)( 9,11)(13,15)(17,19)(24,25)(28,30)(32,33)
  (36,38)(40,41)(43,45),( 3,5)(12,15)(20,21)(23,25)(28,31)(32,35)(37,39)
  (41,43)(44,45)(47,48)(50,52)(57,58)(61,63)(64,65)(66,68)(73,74)(78,80)
  (82,83)(85,87)(89,90),( 1,2)( 8,9)(11,12)(17,18)(20,21)(25,26)(27,28)
  (32,33)(35,36)(42,43)(45,46)(48,49)(54,55)(57,58)(60,61)(63,64)(65,66)
  (71,72)(74,75)(76,77)(78,79)(81,82)(83,84),
 ( 1,16)( 2,18)( 3,19)( 4,21)( 5,22)( 6,23)( 7,25)( 8,27)( 9,28)(10,30)
  (11,32)(12,33)(13,35)(14,37)(15,38),( 2,37)( 4,39)( 6,40)( 9,43)
  ( 12,44)( 14,45)( 16,48)( 18,51)( 21,54)( 24,56)( 25,57)( 27,60)
  ( 31,61)( 32,64)( 33,67)( 36,71)( 41,74)( 49,78)( 50,81)( 58,83)
  ( 65,87)( 66,90)( 76,92)( 80,95)( 85,98)( 89,101),
 ( 2,37)( 4,39)( 8,43)( 9,46)(11,47)(14,51)(15,52)(16,55)(18,56)(21,58)
  (24,62)(25,64)(28,67)(30,68)(33,70)(36,73)(40,75)(41,78)(48,80)(54,84)
  (59,86)(60,89)(69,91)(72,95),( 2,3)( 9,11)(15,17)(18,21)(22,24)(27,29)
  (32,35)(38,40)(41,44)(47,48)(51,52)(55,56)(58,59),
 ( 2,7)( 5,8)( 6,9)(10,18)(12,20)(19,26)(24,27),
 ( 2,37)( 5,41)( 6,42)( 9,43)(12,45)(14,49)(15,52)(17,54)(20,57)(22,58)
  (24,62)(25,63)(29,65)(31,69)(36,74)(40,77)(48,80)(50,81)(53,83)(55,84)
  (61,87)(68,90)(70,91)(71,93)(72,94),( 3,4)( 5,8)( 9,10)(12,13),
 ( 1,3)( 9,10)(15,17)(19,21)(24,25)(28,29)(32,33)(35,36)(39,40)(43,44),
 ( 1,3)( 9,10)(16,18)(20,22)(24,25)(27,28)(32,33)(36,37)(38,39),
 ( 1,8)( 2,16)( 3,21)( 5,25)(10,26)(15,28)(20,29),
 ( 2,3)( 9,10)(12,13)(15,16)(18,19)(21,22)(23,24),
 ( 1,3)( 9,10)(16,18)(20,22)(25,26)(27,28)(31,32)(34,35),
 ( 2,36)( 4,37)( 7,40)( 10,41)( 12,42)( 15,45)( 17,49)( 18,51)
  ( 19,55)( 22,57)( 24,58)( 25,61)( 29,62)( 31,65)( 35,69)( 38,71)
  ( 47,75)( 48,78)( 52,82)( 54,84)( 59,86)( 67,92)( 68,94)( 80,96)
  ( 81,99)( 90,101)( 91,104),( 3,4)( 5,7)( 9,11)(14,15)(18,19)(23,24)
  (25,26),( 2,32)( 3,33)( 7,34)( 11,35)( 14,36)( 22,37)( 26,38)
  ( 29,39)( 40,56)( 43,61)( 44,62)( 47,67)( 48,68)( 50,71)( 53,76)
  ( 63,89)( 69,90)( 77,93)( 81,96)( 82,99)( 83,102)( 87,105)( 88,108)
  ( 92,109)( 95,112)( 98,115)(101,118)(104,121)(107,124)(113,127)(119,128)
  (125,129),( 2,32)( 5,36)( 6,39)( 10,41)( 11,43)( 14,45)( 17,47)
  ( 18,48)( 21,54)( 23,56)( 24,59)( 28,63)( 31,65)( 35,66)( 37,69)
  ( 46,77)( 51,79)( 52,82)( 57,90)( 62,92)( 64,97)( 67,103)( 72,105)
  ( 74,106)( 75,108)( 80,114)( 85,116)( 87,117)( 88,119)( 94,121)( 95,123)
  (100,125)(101,127)(111,129)(112,131),( 1,8)( 2,15)( 3,22)( 4,28)( 5,35)
  ( 7,41)( 9,43)(13,45)(16,46)(18,48)(20,49)(23,51)(25,53)(26,55)(29,56)
  (31,58)(34,59)(36,61)(38,62)(40,64)(42,65)(44,67)(47,68)(50,69)(52,70)
  (54,72)(57,73)(60,75)(63,76)(66,77)(71,79)(74,81)(78,82)(80,83),
 ( 3,4)( 5,7)(10,12)(15,16)(18,19)(21,22),
 ( 2,32)( 5,33)( 7,34)( 12,35)( 16,36)( 21,37)( 29,38)( 41,63)
  ( 44,64)( 47,66)( 50,68)( 53,70)( 55,71)( 56,73)( 59,75)( 60,76)
  ( 69,92)( 74,93)( 78,94)( 79,96)( 82,98)( 85,100)( 86,102)( 89,104)
  ( 95,107)( 97,109)( 99,111)(101,113)(103,115)(105,117)(106,118)(110,119)
  (114,120),( 1,8)( 2,15)( 3,20)( 4,23)( 5,31)( 6,36)( 9,39)(12,42)(17,45)
  (19,49)(24,52)(28,54)(29,58)(33,61)(35,62)(38,65)(41,68)(44,70)(48,73)
  (50,74)(53,77)(57,80)(59,81)(66,83)(71,85)(78,87),
 ( 2,3)( 9,10)(13,14)(24,25)(32,33)(35,36)(39,40)(44,45)(47,48)(49,50)
  (53,54)(55,56)(59,60)(61,62)(63,64)(66,67)(68,69)(72,73)(74,75)(76,77),
 ( 1, 8)( 2,14)( 3,23)( 4,30)( 35,37)( 36,57)( 40,59)( 41,61)
  ( 43,62)( 44,63)( 48,65)( 49,66)( 53,68)( 54,70)( 55,78)( 56,87)
  ( 71,89)( 74,91)( 77,94)( 80,96)( 83,99)( 86,101)( 90,104)( 92,105)
  ( 93,107)( 95,108)( 97,109)( 98,111)(100,112)(102,113)(103,115),
 ( 2,31)( 3,33)( 4,34)( 6,35)( 7,36)( 9,38)(10,39)(12,40)(13,42)(15,43)
  (16,45)(17,46)(21,48)(24,49)(28,51)(32,53)(37,55)(41,57)(44,58)(47,59)
  (50,60)(52,61)(54,62)(56,63),( 3,4)( 5,6)( 7,8)(10,11)(13,14)(16,17)
  (18,19),( 2,31)( 3,33)( 6,34)( 8,35)( 9,36)(12,37)(14,39)(16,41)(17,42)
  (19,43)(20,44)(22,47)(23,48)(24,49)(26,50)(27,51)(29,54)(30,55)(32,57)
  (38,59)(40,60)(45,62)(46,63)(52,65)(53,66)(56,67)(58,68)(61,69)(64,70),
 ( 1,15)( 2,20)( 3,30)( 4,33)( 9,42)(10,43)(11,45)(12,46)(13,47)(17,48)
  (18,50)(21,51)(23,52)(24,53)(27,54)(28,56)(31,57)(32,58)(35,59)(41,60)
  (44,61),( 2,31)( 3,32)( 6,33)( 8,35)( 9,37)(12,38)(14,40)(16,41)(17,42)
  (19,45)(20,46)(22,47)(23,48)(24,49)(26,52)(27,53)(29,54)(30,55)(34,56)
  (36,57)(39,59)(43,61)(44,62)(50,64)(51,65)(58,67)(60,68)(63,69)(66,70),
 ( 2,3)( 9,10)(14,15)(18,19)(23,24),( 3,4)( 5,6)( 8,9)(10,11)(12,13)
  (16,17)(18,19)(22,23)(24,25)(28,29),( 3,4)( 5,6)( 8,9)(10,11)(13,14)
  (15,16)(19,20)(21,22)(25,26)(27,28),( 2,30)( 5,31)( 8,33)( 9,34)(11,35)
  (12,38)(14,39)(15,40)(17,43)(18,46)(19,47)(22,49)(23,50)(24,54)(25,55)
  (28,56)(29,57)(32,58)(36,59)(37,60)(41,62)(42,64)(44,65)(45,66)(48,67)
  (51,68)(52,69)(53,70)(61,71)(63,72),( 1,3)(11,14)(18,21)(22,23)(25,28)
  (29,31)(33,36)(38,39)(40,41)(42,44)(45,46)(49,51)(53,54)(55,56)(57,59)
  (60,61)(62,63)(64,65)(68,70)(72,74)(75,77)(78,79)(81,83)(84,85)(87,89)
  (92,94)(96,98),( 2,29)( 3,30)( 5,32)( 6,33)( 9,34)(12,36)(15,38)(16,39)
  (17,42)(20,44)(21,45)(22,46)(23,48)(26,50)(27,51)(28,53)(31,56)(35,58)
  (37,59)(40,60)(41,62)(43,64)(47,67)(49,69)(52,70)(54,72)(55,73)(57,74)
  (61,75)(63,77)(65,79)(66,80)(68,81)(71,82)(76,83)(78,84),
 ( 3,4)( 5,6)( 8,9)(12,13),( 1, 8)( 2,14)( 3,17)( 4,19)( 5,31)
  ( 33,43)( 35,53)( 37,55)( 40,61)( 42,63)( 45,69)( 47,70)( 49,72)
  ( 51,83)( 52,92)( 76,93)( 79,95)( 82,97)( 85,99)( 88,101)( 91,103)
  ( 94,105)( 96,109)( 98,110)(100,114)(102,115)(104,119),
 ( 2,29)( 3,30)( 5,31)( 7,33)(10,34)(11,35)(13,36)(15,38)(17,40)(18,43)
  (19,45)(20,47)(21,50)(22,51)(23,53)(24,54)(25,56)(26,58)(27,59)(39,64)
  (41,67)(42,68)(48,70)(49,71)(60,75)(61,76)(62,77)(63,79)(65,80)(66,81)
  (73,83)(74,84),( 3,4)( 5,6)( 9,10)(12,13)(28,29)(30,31)(32,33)(34,35)
  (60,61)(62,63)(64,65),( 2,29)( 3,30)( 6,31)( 8,33)( 9,35)(12,36)(13,37)
  (15,38)(17,43)(18,44)(19,45)(20,46)(21,49)(22,51)(23,53)(24,54)(25,55)
  (26,56)(27,59)(28,60)(40,63)(41,66)(50,67)(61,68)(62,69)(64,70)(65,71),
 ( 1,8)( 2,14)( 4,23)( 9,42)(15,45)(17,47)(19,51)(21,52)(24,53)(28,54)
  (31,57)(33,59)(35,63)(37,64)(39,65)(43,66)(48,67)(55,68)(60,69),
 ( 2,29)( 4,30)( 6,32)( 8,33)( 9,34)(12,36)(13,37)(16,39)(17,42)(18,44)
  (19,46)(20,48)(21,49)(22,50)(23,52)(24,53)(25,55)(26,56)(27,57)(28,59)
  (40,61)(41,65)(45,68)(60,69)(63,70)(64,71)(67,72),
 ( 3,4)( 5,6)(10,11)(13,14)(19,20)(22,23)(29,30)(35,36)(38,39)(41,42)
  (45,46)(49,50)(51,52)(54,55)(57,58)(63,64)(67,68)(69,70)(72,73)(77,78)
  (79,80)(83,84)(85,86),( 1,15)( 2,16)( 3,18)( 4,20)( 5,21)( 6,24)( 7,27)
  ( 8,28)( 9,30)(10,32)(11,34)(12,38)(13,40)(22,45)(25,46)(36,51)(37,52),
 ( 1,8)( 2,13)( 3,21)( 4,24)( 5,29)( 6,36)( 9,39)(11,40)(15,43)(16,47)
  (20,49)(25,52)(27,56)(32,59)(35,62)(42,65)(44,66)(48,69)(51,72)(53,73)
  (57,76)(60,78)(63,81)(68,84)(75,86)(80,88),
 ( 2,28)( 3,29)( 5,30)( 6,32)( 9,33)(12,34)(15,35)(16,36)(17,42)(18,43)
  (19,45)(20,46)(21,49)(22,51)(23,52)(24,54)(25,55)(26,56)(38,61)(39,62)
  (40,66)(41,67)(47,71)(48,72)(58,74)(59,75)(63,77)(64,78)(68,80)(69,81),
 ( 2,3)( 9,10)(15,16)(18,20)(22,23)(25,27)(29,30)(35,36)(40,41)(48,49)
  (51,52)(56,57)(58,59),( 3,4)( 5,6)(11,12)(15,16)(18,19),
 ( 2,28)( 4,29)( 6,32)( 8,33)(11,34)(12,35)(15,36)(16,38)(17,43)(18,44)
  (19,46)(20,47)(21,50)(22,51)(23,52)(24,54)(25,56)(26,57)(27,58)(39,61)
  (40,62)(41,65)(42,66)(45,69)(60,72)(64,73)(68,74)(70,75)(71,76),
 ( 2,28)( 4,29)( 6,30)( 8,32)(11,33)(12,36)(15,37)(16,39)(17,42)(18,44)
  (19,45)(20,46)(21,47)(22,48)(23,50)(24,53)(25,55)(26,56)(27,60)(40,63)
  (41,66)(51,67)(52,68)(57,69)(58,70)(61,71)(62,72)(64,73)(65,74),
 ( 2,28)( 4,29)( 7,31)( 8,32)(11,34)(12,35)(14,36)(16,38)(17,43)(18,45)
  (19,47)(20,48)(21,50)(22,51)(23,54)(24,55)(25,57)(26,58)(27,60)(39,61)
  (40,63)(41,65)(42,67)(46,69)(53,70)(64,71)(68,72),
 ( 3,4)( 5,6)(17,20)(22,23)(25,28)(36,39)(41,44)(46,49),
 ( 1,8)( 2,13)( 3,15)( 4,31)(35,47)(36,50)(37,62)(38,65)(39,70)(43,72)
  (44,73)(48,74)(49,76)(53,78)(54,79)(58,80)(59,82)(63,84)(64,85)(68,86),
 ( 1,8)( 2,13)( 7,24)(10,26)(12,29)(17,32)(19,33)(20,34)(27,37),
 ( 3,4)( 6,10)( 7,11)( 8,12),( 2,26)( 3,28)( 4,30)( 5,31)( 6,33)( 7,35)
  ( 8,37)( 9,38)(10,40)(11,42)(13,44)(15,51)(17,53)(18,57)(20,59)(23,63)
  (25,65)(32,67)(39,68)(45,69),( 1, 3)( 14,16)( 24,25)( 30,32)
  ( 34,35)( 38,39)( 41,43)( 44,45)( 46,47)( 51,52)( 57,59)( 60,61)
  ( 62,63)( 68,69)( 74,75)( 76,77)( 78,79)( 80,81)( 83,84)( 85,86)
  ( 87,88)( 89,90)( 92,93)( 95,96)( 98,99)(101,102),
 ( 1, 3)( 14,16)( 24,25)( 30,32)( 34,35)( 38,39)( 41,42)( 43,44)
  ( 50,51)( 54,55)( 58,59)( 60,61)( 64,65)( 70,72)( 73,74)( 75,76)
  ( 77,78)( 80,82)( 83,84)( 86,87)( 88,89)( 90,91)( 92,93)( 95,96)
  ( 98,99)(101,102)(105,106)(108,109)(111,112)(114,115),
 ( 2,26)( 5,28)( 8,30)( 10,32)( 12,35)( 14,37)( 15,41)( 16,42)
  ( 17,45)( 19,46)( 20,48)( 21,51)( 22,54)( 23,55)( 24,59)( 25,61)
  ( 29,62)( 33,63)( 34,64)( 38,66)( 39,67)( 40,70)( 43,75)( 44,76)
  ( 47,77)( 49,79)( 52,80)( 53,81)( 56,82)( 57,84)( 60,85)( 65,91)
  ( 68,92)( 69,93)( 71,94)( 72,97)( 74,98)( 78,102)( 83,103)( 86,105)
  ( 88,107)( 90,108)( 95,110)( 96,111)( 99,112)(100,113)(101,115)(104,117)
  (106,118)(109,119)(114,120)(116,121),( 3,4)( 6,8)( 9,12)(15,18)(19,22)
  (28,30)(31,34)(40,43)(46,47)(49,50)(53,54)(56,57)(60,61)(63,64),
 ( 1,8)( 2,12)( 3,18)( 5,24)(14,27)(17,28)(23,31),
 ( 1,8)( 2,12)( 3,17)( 5,23)(14,27)(22,31)(24,32)(28,33),
 ( 1,8)( 2,12)( 3,17)( 5,20)( 9,23)(13,28)(25,36)(31,39),
 ( 2,3)(10,11)(12,13)(15,16)(20,21)(23,24)(25,26)(28,29)(30,31)(35,36)
  (37,38),( 3,4)( 6,8)( 9,10)(11,13)(14,15)(16,18)(19,21)(23,25)(26,28)
  (29,30)(31,33)(34,35)(36,38)(39,40)(41,43)(44,46)(48,50)(51,53)(54,55),
 ( 3,6)( 5,7)( 8,12)(14,17)(15,18),( 1,2)( 3,11)( 6,12)( 8,13)( 9,14)
  (10,15),( 1,8)( 2,12)( 3,15)( 4,16)( 6,20)(10,21)(13,23)(18,25),
 ( 1,14)( 2,20)( 3,21)( 4,24)( 5,27)(11,32)(13,43)(15,45)(18,49)(19,51)
  (22,52)(25,54)(26,58)(28,59)(29,61)(33,65)(35,67)(37,69)(39,71)(41,73)
  (42,74)(46,75)(48,77)(53,78)(56,80)(60,81)(62,82)(66,83)(70,84),
 ( 1,8)( 2,12)( 3,15)( 5,16)( 7,20)(11,21)(14,23)(19,25),
 ( 2,24)( 3,26)( 5,27)( 7,29)( 8,31)(10,33)(12,34)(13,35)(15,37)(17,39)
  (18,41)(19,42)(21,43)(22,45)(25,46)(32,47)(40,48),
 ( 3,4)( 6,8)(12,13)(14,15)(19,20)(29,31)(35,37)(42,44)(52,53)(54,55)
  (57,58)(59,60)(62,63)(64,65),( 1, 8)( 2,12)( 4,19)( 6,35)
  ( 15,38)( 17,41)( 20,42)( 24,47)( 28,50)( 30,51)( 32,54)( 34,55)
  ( 39,59)( 45,67)( 48,70)( 49,73)( 52,75)( 61,83)( 65,87)( 68,90)
  ( 69,93)( 72,95)( 77,99)( 80,101)( 85,105)( 88,108)( 89,111)( 92,113)
  (102,118)(103,121)(106,122)(107,125)(110,127)(120,132)(124,136),
 ( 1,5)( 4,10)( 6,12)( 8,13)( 9,14)(11,15),
 ( 2,3)(10,11)(13,14)(22,23)(26,27)(34,35)(43,44)(45,46)(48,49)(50,51)
  (52,53)(54,55)(56,57)(59,60)(71,72)(74,75)(76,77)(78,79)(80,81)(83,84)
  (85,86)(88,89)(90,91)(92,93)(94,95)(97,98),( 1,2)( 3,10)( 6,11)( 8,12),
 ( 1,5)( 4,10)( 7,12),( 1,2)( 3,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)
  (15,19),( 3,4)( 6,7)( 8,9)(10,12)(13,14)(16,18)(19,21)(22,23)(24,26)
  (27,29)(31,32)(33,35)(36,37)(39,41)(42,44)(45,46)(47,49)(50,52),
 ( 1,8)( 2,11)( 3,25)( 4,32)(34,43)(35,46)(36,58)(37,61)(39,68)(40,69)
  (44,72)(45,74)(49,75)(50,76)(54,79)(55,81)(59,82)(60,83)(64,86)(65,88),
 ( 1,2)( 3,9)( 5,11)( 7,13)(10,14)(12,15),
 ( 1,5)( 4,10)(12,16)(13,17)(14,18),( 1,14)( 2,17)( 3,20)(10,26)(13,29)
  (18,33)(21,34)(22,36)(27,41)(35,46)(37,47)(39,49)(42,50),
 ( 2,24)( 4,26)( 8,27)(11,28)(13,30)(16,32)(18,33)(21,34)(23,35)(25,37)
  (31,38),( 2,24)( 4,25)( 5,27)( 7,29)( 8,31)( 9,32)(10,34)(11,36)(12,38)
  (13,39)(14,43)(16,49)(17,53)(19,58)(20,62)(22,66)(23,67)(26,69)(28,70)
  (33,72)(35,73)(44,88)(51,91)(60,94),( 1,8)( 2,11)( 3,16)(17,35)(22,36)
  (26,37)(29,38)(32,39)(41,48)(43,49)(46,50),
 ( 1,8)( 2,11)( 3,16)(18,35)(21,36)(24,37)(28,38)(33,39)(41,48)(44,49)
  (46,50),( 1,2)( 3,6)(11,12)(15,16),( 1,8)( 2,11)( 3,15)( 5,16)( 7,20)
  (10,22)(13,24)(18,26),( 2,24)( 4,25)( 7,28)( 8,29)(12,30)(15,31)(17,34)
  (20,35)(22,36)(27,37)(33,38),( 1,9)( 2,14)( 3,19)( 5,21)( 8,27)(13,29)
  (16,35),( 1,14)( 2,16)( 3,17)( 5,18)( 6,20)( 8,21)( 9,23)(10,24)(11,25)
  (13,27),( 1,9)( 2,14)( 3,17)( 4,21)( 5,24)( 6,30)( 7,32)( 8,37)(10,39)
  (12,42)(13,44)(15,47)(20,48)(22,51)(25,53)(27,56)(29,59)(33,60)(36,61)
  (41,62)(45,65)(50,66)(55,69)(57,70)(64,71)(68,72),
 ( 1,2)( 3,5)( 6,7)( 8,10)(11,12)(14,15)(16,18)(19,20)(25,26)(29,30)
  (34,35)(38,39)(43,44)(47,48),( 2,24)( 4,25)( 7,26)( 9,27)(12,30)(14,32)
  (17,33)(20,34)(22,37)(29,38)(36,39),( 1,23)( 4,26)( 6,27)( 8,31)( 9,32)
  (11,33)(13,34)(14,35)(16,39)(18,40)(19,41)(21,42)(24,44)(25,45)(28,47)
  (29,48)(30,49)(36,51)(37,52)(38,53)(43,54)(46,55)(50,56),
 ( 1,3)( 4,5)( 7,9)(10,12)(20,22)(25,27)(28,30),
 ( 1,2)( 3,5)( 8,10)(13,15),( 1,8)( 2,11)( 4,14)(13,22)(15,23)(20,25)
  (24,28)(26,30),( 3,4)( 6,7)(10,11)(13,14)(18,19)(21,22)(28,29)(39,40)
  (44,45)(47,48)(49,50)(52,53)(54,55)(57,58)(59,60)(63,64)(68,69)(70,71)
  (73,74)(75,76)(78,79)(80,81)(82,83)(86,87)(88,89)(91,92)(93,94),
 ( 1,14)( 3,20)( 5,28)( 7,40)( 9,42)(12,43)(16,47)(18,48)(21,51)(26,54)
  (30,55)(33,57)(35,60)(38,62)(45,63)(49,66)(58,69)(64,70)(67,71),
 ( 2,24)( 5,26)( 7,27)( 9,28)(11,30)(14,31)(16,33)(19,34)(23,36)(29,37)
  (35,38),( 3,4)( 6,7)(10,11)(14,15)(17,18)(20,21),
 ( 3,4)( 6,7)(10,11)(18,19)(22,23)(24,25)(30,31)(35,36)(38,39),
 ( 1,14)( 3,17)( 5,18)(10,22)(12,24)(16,46)(19,47)(23,48)(28,50)(30,51)
  (32,54)(34,56)(36,57)(38,60)(41,62)(43,63)(45,66)(52,70)(58,71)(64,72),
 ( 2,24)( 5,25)( 7,27)( 9,29)(11,30)(15,31)(18,33)(20,35)(23,36)(28,37)
  (34,38),( 1,8)( 2,10)( 3,14)( 4,27)(29,42)(30,46)(31,60)(32,64)(33,69)
  (38,72)(39,73)(44,76)(45,78)(50,81)(51,82)(56,85)(57,87)(62,90)(63,91)
  (68,94),( 3,6)( 8,12)(14,17)(19,23)(24,28),
 ( 1,8)( 2,10)( 3,12)( 4,13)( 5,15)( 6,17),
 ( 1,9)( 2,13)( 3,17)( 4,24)(33,45)(34,49)(35,60)(36,64)(37,68)(41,72)
  (42,73)(46,74)(47,76)(51,80)(52,81)(56,82)(57,84)(61,88)(62,89)(66,90),
 ( 2,24)( 5,25)( 7,26)(10,29)(12,30)(15,31)(16,32)(20,34)(23,35)(28,36)
  (33,38),( 1,14)( 3,15)( 4,17)( 5,18)( 6,19)( 8,21)( 9,22)(11,24)(12,25)
  (13,26),( 1,5)( 6,10)( 7,12)( 8,14)( 9,16)(11,18)(13,20)(15,22)(17,23)
  (19,24)(21,25),( 1,14)( 3,15)( 5,17)( 7,18)( 9,20)(10,21)(12,23)(13,24)
  (16,25)(19,26)(22,27),( 1,14)( 3,15)( 5,17)(10,21)(12,24)(18,46)(22,47)
  (23,48)(27,50)(29,51)(32,53)(34,56)(35,57)(38,59)(40,62)(42,63)(45,65)
  (49,70)(55,71)(61,72),( 2,8)( 3,10)( 4,12)( 6,13)( 7,14)(11,15)(17,20)
  (19,21),( 1,14)( 4,30)( 6,36)( 8,38)(12,41)(15,43)(19,46)(24,49)(26,53)
  (28,54)(31,58)(34,61)(39,64)(42,68)(44,69)(47,72)(50,76)(51,77)(56,79)
  (59,80)(62,81)(66,83)(70,84)(74,86),( 1,8)( 2,10)( 4,12)( 5,14)( 6,16)
  ( 9,17)(13,18),( 3,4)( 6,7)(11,12)(14,15)(19,20)(26,27)(32,33)(35,36)
  (38,39)(42,43)(45,46)(49,50)(52,53)(54,55)(57,58)(60,61)(65,66)(68,69)
  (70,71)(73,74)(79,80)(81,82)(87,88)(89,90),
 ( 1,14)( 4,20)( 6,26)( 7,29)(10,37)(15,41)(17,42)(22,45)(27,47)(30,48)
  (34,51)(38,53)(40,54)(43,55)(46,56)(49,57)(52,58),
 ( 2,3)(11,12)(14,15)(17,18)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32),
 ( 2,23)( 3,26)( 5,27)( 6,28)( 8,30)(10,33)(11,34)(13,35)(15,36)(16,38)
  (18,41)(20,42)(21,43)(22,44)(25,46)(32,47)(40,48),
 ( 1,2)(10,12)(13,14)(17,18)(20,22)(23,25)(27,28)(31,32)(33,35)(36,38)
  (39,41)(44,46)(47,49),( 1,22)( 2,25)( 3,28)( 4,29)( 5,30)( 6,31)( 7,34)
  ( 8,37)(10,38)(12,39)(13,40)(15,43)(17,46)(18,47)(20,48),
 ( 1,2)(10,12)(15,17)(21,22),( 3,6)( 8,10)(12,15)(17,19),
 ( 1,37)( 3,39)( 5,40)( 8,43)( 10,45)( 11,48)( 13,49)( 17,52)
  ( 19,55)( 20,57)( 23,59)( 26,60)( 28,62)( 30,65)( 35,67)( 44,69)
  ( 50,73)( 54,76)( 56,79)( 61,82)( 66,86)( 68,89)( 72,92)( 80,95)
  ( 85,98)( 90,101)( 93,104)( 96,107)( 99,110)(102,113),
 ( 2,3)( 6,7)(10,11)(12,13)(20,21)(23,24)(27,28)(46,47)(57,58)(62,63)
  (64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)(92,93)
  (94,95),( 3,6)( 8,10)(12,14),( 1,2)(10,11)(12,14)(15,17)(18,19)(21,23)
  (24,25)(28,29)(30,32)(33,35)(36,37)(43,44)(45,47)(51,53)(61,62)(63,65)
  (73,74)(77,78)(83,84),( 1,6)( 4,11)(12,22)(20,32)(24,34)(28,36)(30,42)
  (37,49)(39,51)(41,53)(43,55)(45,57)(47,59)(48,60)(52,62)(56,64),
 ( 1,22)( 2,23)( 4,25)( 6,28)( 7,29)(10,31)(11,35)(13,36)(14,38)(16,39)
  (18,41)(19,44)(21,45)(24,47)(26,48)(32,49)(33,50)(40,51)(42,52),
 ( 1,37)( 4,41)( 7,44)( 8,45)(11,47)(13,51)(16,54)(19,57)(21,58)(23,62)
  (27,63)(28,65)(30,69)(33,72)(34,74)(35,77)(38,78)(43,80)(48,81)(49,84)
  (59,85)(66,86)(67,89)(83,91)(88,93),( 3,6)( 9,18)(10,22)(11,27)(12,31)
  (14,34)(19,35)(21,36)(33,37)(39,49)(42,56)(47,60)(54,61)(58,62),
 ( 2,3)(11,12)(16,17)(19,20)(21,22)(23,24),
 ( 3,4)( 6,7)(13,14)(24,25)(27,28)(31,32)(34,35)(38,39)(40,41)(43,44)
  (45,46)(50,51)(54,55)(56,57)(59,60)(61,62)(64,65)(66,67)(70,71)(75,76)
  (77,78)(79,80)(82,83)(84,85)(86,87)(89,90),
 ( 3, 4)( 6, 7)( 14,15)( 18,19)( 39,40)( 42,43)( 44,45)( 49,50)
  ( 51,52)( 54,55)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 70,71)( 76,77)( 89,90)( 91,92)( 95,96)( 98,99)(100,101)
  (103,104)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117)(118,119)
  (120,121),( 2,23)( 3,24)( 5,27)( 7,28)( 8,30)(10,31)(11,34)(13,35)(15,37)
  (16,38)(18,39)(19,42)(20,43)(22,45)(26,46)(33,47)(41,48),
 ( 3, 4)( 6, 7)( 15,16)( 23,24)( 34,35)( 36,37)( 39,40)( 43,44)
  ( 45,46)( 48,49)( 50,51)( 52,53)( 54,55)( 57,58)( 61,62)( 63,64)
  ( 65,66)( 68,69)( 70,71)( 72,73)( 74,75)( 76,77)( 78,79)( 80,81)
  ( 83,84)( 86,87)( 88,89)( 90,91)( 95,96)( 97,98)(102,103)(106,107)
  (108,109)(110,111)(112,113),( 1,13)( 2,19)( 3,36)( 5,37)( 6,38)
  ( 11,43)( 15,46)( 17,47)( 20,48)( 24,53)( 25,56)( 27,57)( 39,74)
  ( 40,77)( 41,78)( 44,80)( 49,82)( 50,84)( 54,86)( 60,94)( 62,97)
  ( 66,102)( 70,105)( 79,107)( 85,109)(110,127)(112,128)(114,129)(116,130)
  (118,131)(120,132),( 1,13)( 2,19)( 3,25)( 5,34)( 7,35)( 9,36)
  ( 11,40)( 15,44)( 17,47)( 21,48)( 22,52)( 24,54)( 39,83)( 42,84)
  ( 46,85)( 51,86)( 55,87)( 58,88)( 60,95)( 64,97)( 68,99)( 72,101)
  ( 76,103)( 80,105),( 2,23)( 3,24)( 5,25)( 7,26)( 8,30)(10,31)(12,32)
  (13,33)(15,34)(17,38)(18,39)(20,40)(22,44)(27,45)(29,46)(35,47)(37,48)
  (41,49)(43,50),( 2,3)(12,13)(14,16)(17,18)(19,21)(22,23)(24,26),
 ( 1,8)( 2,9)( 5,12)( 6,13),( 1,8)( 2,9)( 5,10)(12,18)(14,22)(20,28)
  (24,30),( 1,8)( 2,9)( 5,10),( 1,2)( 3,4)( 5,6)( 8,9)(10,11)(12,13)
  (14,15)(17,18),( 1,8)( 3,20)( 5,28)( 7,34)(10,41)(13,43)(15,46)(18,48)
  (22,49)(27,52)(30,55)(32,56)(36,60)(39,61)(45,63)(54,66)(58,69)(65,70)
  (68,71),( 2,23)( 4,24)( 5,26)( 7,29)( 9,30)(10,31)(11,32)(13,34)(14,37)
  (16,38)(17,39)(19,41)(21,44)(22,45)(27,46)(35,47)(42,48),
 ( 2,23)( 4,24)( 5,26)( 7,29)( 9,30)(10,31)(11,32)(13,34)(14,37)(16,38)
  (17,39)(19,41)(21,44)(22,45)(28,46)(36,47)(43,48),
 ( 2,23)( 4,24)( 5,26)( 7,29)( 9,30)(10,31)(12,32)(13,34)(15,36)(17,37)
  (19,39)(21,42)(22,43)(27,45)(28,46)(35,48)(40,50)(41,51)(44,52)(47,53)
  (49,54),( 1,22)( 3,24)( 7,26)( 9,28)(11,30)(14,32)(16,34)(20,36)(23,38)
  (27,39)(31,40)(35,41),( 1,5)( 6,9)(15,19)(23,25)(26,29)(31,33)(34,37),
 ( 2,6)( 7,17)( 9,18)(10,20)(12,22)(13,26)(15,28)(16,32)(23,34)(29,36),
 ( 1,2)(10,11)(13,14)(17,18)(21,22)(23,24),(1,5)(6,8),
 ( 2,23)( 4,24)( 5,25)( 7,28)( 9,30)(10,31)(12,32)(14,33)(15,36)(17,37)
  (18,38)(20,39)(21,42)(22,44)(27,46)(35,48)(41,50),
 ( 3,4)( 7,9)(24,25)(26,28)(31,32)(33,35)(38,39)(40,41)(42,43)(45,46)
  (49,50)(51,52)(54,55)(58,59)(60,61)(64,65)(66,67)(69,70)(72,73)(76,77)
  (80,81)(83,84)(86,87)(89,90)(92,93),( 1,8)( 3,14)( 6,34)( 9,44)(10,45)
  (12,46)(15,47)(17,51)(19,53)(23,54)(28,55)(30,56)(32,60)(35,62)(39,63)
  (48,66)(52,67)(57,70)(61,71),( 1, 8)( 3,13)( 6,24)( 9,35)
  ( 10,36)( 12,37)( 14,38)( 15,41)( 17,45)( 20,46)( 22,50)( 31,68)
  ( 39,71)( 42,72)( 43,73)( 47,77)( 48,78)( 51,79)( 53,85)( 61,90)
  ( 64,97)( 69,99)( 74,101)( 82,118)( 84,121)( 87,122)( 89,123)( 92,126)
  ( 94,127),( 2,23)( 4,24)( 5,25)( 7,26)( 9,30)(10,31)(12,32)(14,33)(15,34)
  (17,38)(19,39)(20,40)(22,43)(27,44)(29,45)(35,47)(37,48)(42,50)(46,52)
  (49,53)(51,54),( 2,23)( 4,24)( 5,25)( 7,26)( 9,30)(10,31)(12,32)(14,33)
  (15,34)(17,38)(19,39)(21,40)(22,43)(27,44)(29,45)(35,47)(37,48)(42,50)
  (46,52)(49,53)(51,54),( 3,4)( 7,8)( 9,10)(12,13)(16,17),
 ( 2,23)( 4,24)( 7,28)( 8,29)(11,30)(14,31)(16,35)(19,36)(21,37)(27,38)
  (34,39),( 2,3)(13,14)(16,17)(19,20)(21,22)(23,24)(25,26)(27,28)(29,30),
 ( 2,23)( 4,24)( 7,27)( 9,29)(12,31)(14,32)(16,35)(19,37)(21,38)(25,39)
  (33,40),( 2,23)( 4,24)( 7,25)( 9,29)(12,30)(15,31)(16,32)(19,36)(21,37)
  (26,38)(33,39),( 1,13)( 2,15)( 3,21)( 4,24)( 5,28)( 6,31)( 7,37)( 8,39)
  ( 9,40)(12,41)(16,42)(18,45)(20,48)(23,49)(25,52)(30,53)(32,56)(34,57)
  (36,60)(44,61)(46,62)(50,65)(55,66)(58,69)(63,70)(67,71),
 ( 2,23)( 4,24)( 7,25)( 9,28)(12,30)(15,31)(17,32)(21,36)(26,37)(29,38)
  (33,39)(35,40),( 2,3)(13,14)(18,19)(23,25)(26,28)(30,32)(33,35),
 ( 1,5)( 8,13)(10,14)(11,15)(12,16),( 1,2)( 3,4)( 5,6)( 9,10)(13,14)
  (18,19)(22,23),( 1,8)( 3,12)( 9,16)(10,17)(13,19)(14,20),
 ( 2,23)( 4,24)( 7,25)( 9,26)(12,30)(14,31)(17,32)(21,34)(28,35)(29,36)
  (33,39)(38,42)(41,43),( 2,3)(14,15)(18,19)(21,22)(25,26)(35,36)(38,39)
  (42,43)(44,45)(49,50)(52,53)(58,59)(60,61)(62,63)(68,69)(71,72)(76,77)
  (80,81),( 3,4)( 7,8)(10,11)(14,15)(18,19)(21,22)(24,25),
 ( 3,4)( 7,8)(10,11)(14,15)(26,27)(30,31)(33,34)(46,47)(48,49)(50,51)
  (54,55)(57,58)(63,64)(65,66)(67,68)(71,72)(74,75),
 ( 2,23)( 5,26)( 6,27)( 9,28)(11,29)(14,33)(16,34)(19,35)(21,36)(24,38)
  (30,40),( 1,8)( 3,11)( 4,12)( 5,13)( 7,14)(10,15)(17,20)(19,21),
 ( 3,4)( 7,8)(10,11)(21,22)(24,25)(29,30)(32,33)(34,35),
 ( 1,8)( 3,11)( 5,15)(13,20)(16,21)(18,22),
 ( 2,23)( 5,24)( 6,28)( 9,29)(12,30)(14,31)(17,35)(19,36)(22,37)(27,38)
  (34,39),( 1,8)( 3,11)( 5,14)( 7,15)( 9,16)(10,17)(12,18)(13,19),
 ( 2,23)( 5,24)( 7,28)(10,29)(14,30)(17,34)(19,35)(22,36)(26,37)(27,38)
  (32,39)(33,40),( 2,23)( 5,24)( 7,27)(10,29)(13,30)(15,31)(17,34)(19,36)
  (22,37)(26,38)(33,39),( 1,8)( 3,11)( 6,15)( 9,17)(13,19),
 ( 2,3)(17,18)(21,22)(24,25)(26,27)(29,30)(32,33)(34,35)(36,37)(39,40)
  (42,43),( 2,3)(17,18)(21,22)(24,25)(26,27)(29,30)(32,33)(34,35)(37,38)
  (40,41)(42,43)(44,45)(47,48)(50,51)(52,53)(55,56)(57,58)(60,61),
 ( 2,23)( 5,24)( 7,25)(10,29)(12,30)(15,31)(19,33)(22,34)(27,35)(28,36)
  (32,39)(38,42)(41,43),( 2,23)( 5,24)( 7,25)(10,29)(13,30)(14,31)(17,32)
  (19,36)(22,37)(26,38)(33,39),( 3,4)( 7,8)(11,12)(15,16)(27,28)(29,30)
  (33,34)(35,36),( 3,41)( 5,43)( 8,44)( 9,46)(12,49)(14,52)(17,53)(20,54)
  (21,58)(24,60)(27,61)(29,63)(32,66)(33,69)(36,70)(39,71)(40,75)(47,77)
  (50,78)(55,80)(64,82)(67,83)(72,85),( 1,2)( 3,4)( 6,7)( 9,10)(11,12)
  (14,15)(16,17)(19,20)(22,23)(24,25)(27,28)(29,30)(39,40)(42,43)(45,46)
  (48,49)(50,51)(53,54)(56,57)(59,60)(62,63)(64,65)(68,69)(70,71)(74,75)
  (76,77)(80,81)(82,83)(86,87)(88,89)(92,93)(94,95),
 ( 1,2)( 3,4)( 6,7)( 9,10)(11,12)(14,15)(16,17)(19,20)(23,24)(28,29)
  (31,32)(37,38)(40,41)(45,46),( 2,23)( 5,24)( 7,25)(10,26)(12,30)(15,31)
  (19,32)(22,36)(28,37)(29,38)(34,39)(35,40),
 ( 3,41)( 6,45)(10,47)(13,49)(15,53)(18,54)(22,56)(24,59)(27,62)(31,64)
  (34,65)(38,67)(40,69)(42,70)(46,72)(48,73)(50,74)(51,75)(55,79)(57,80)
  (60,82)(63,83)(66,84)(68,87)(71,88)(76,89)(77,90)(81,92)(85,93)(91,95)
  (94,96),( 1,8)( 3,10)( 4,11)( 5,13),( 1,5)( 2,22)( 3,26)(28,37)(29,40)
  (30,43)(31,58)(32,61)(33,64)(34,77)(39,78)(41,79)(46,81)(48,83)(53,84)
  (55,85)(60,87)(62,89)(67,90)(69,91)(74,93),
 ( 3,39)( 5,41)( 7,44)( 9,45)(12,47)(15,51)(17,54)(19,57)(21,58)(24,61)
  (25,63)(26,66)(30,68)(32,72)(33,75)(36,78)(37,79)(43,81)(52,82)(53,84)
  (59,85)(65,87)(73,88)(74,90),( 3,38)( 5,40)( 8,41)( 9,45)(12,49)(15,50)
  (18,53)(20,54)(21,56)(24,57)(26,61)(29,65)(30,68)(32,69)(34,71)(37,75)
  (42,78)(46,80)(48,82)(51,83)(58,86)(62,88)(64,90)(73,91),
 ( 2,23)( 6,27)( 8,28)(11,29)(14,31)(16,34)(19,35)(21,36)(24,37)(26,38)
  (30,39)(33,40),( 3,38)( 5,39)( 8,42)( 9,46)(11,50)(14,51)(17,55)(20,57)
  (21,58)(24,61)(26,65)(29,69)(32,70)(34,71)(36,74)(37,76)(43,78)(45,80)
  (49,81)(53,82)(62,84)(64,86)(68,87)(73,88),
 ( 3,38)( 7,40)( 9,43)( 12,45)( 15,47)( 17,50)( 23,53)( 25,55)
  ( 28,56)( 31,60)( 33,62)( 34,63)( 37,68)( 39,69)( 41,70)( 44,72)
  ( 46,76)( 48,77)( 54,78)( 57,79)( 59,81)( 61,85)( 64,86)( 66,88)
  ( 73,90)( 74,94)( 82,96)( 83,100)( 89,102)( 95,105)(101,108),
 ( 3,4)( 7,8)(11,12)(21,22)(25,26)(28,29)(32,33)(36,37)(39,40),
 ( 1,13)( 3,14)( 4,15)( 6,17)( 7,18)( 9,21)(11,22)(12,23)(16,26)(19,28)
  (24,30)(27,31)(29,32),( 1,2)( 3,4)( 9,10)(17,18)(20,21),
 ( 3,37)( 6,40)( 8,43)(10,45)(15,48)(17,51)(19,52)(21,55)(24,58)(26,62)
  (27,64)(29,66)(33,67)(35,69)(36,72)(38,73)(42,77)(44,80)(47,81)(53,84)
  (59,88)(61,89)(63,92)(68,93)(76,96)(87,97),
 ( 3,37)( 7,41)( 8,44)(12,46)(14,49)(15,51)(19,53)(21,57)(24,60)(27,64)
  (29,66)(34,68)(36,71)(38,72)(39,75)(45,78)(47,79)(50,80)(52,83)(54,84)
  (55,87)(61,89)(65,91)(67,92)(69,95)(76,96)(81,97)(88,98)(93,99),
 ( 1,8)( 3,9)( 4,12)( 6,13)( 7,16)(10,17)(14,18),
 ( 1,8)( 3,9)( 4,12)( 6,13)( 7,14)(11,17)(16,18),
 ( 2,22)( 3,24)( 4,26)( 6,29)( 7,30)( 9,31)(10,33)(11,35)(14,38)(16,40)
  (18,42)(19,45)(21,46)(27,47)(28,48)(36,49)(37,50)(43,51)(44,52),
 ( 3,4)( 7,8)(11,12)(21,22)(26,27)(29,30)(34,35)(38,39)(41,42)(43,44)
  (47,48)(50,51),( 2,22)( 3,23)( 5,28)( 7,29)( 8,30)( 9,33)(11,34)(13,35)
  (14,36)(16,37)(18,42)(19,43)(21,44)(24,45)(27,46)(32,49)(38,52)(41,53)
  (47,56)(50,57)(54,58),( 3,32)( 6,33)( 9,34)( 19,35)( 24,36)
  ( 27,37)( 31,38)( 40,61)( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)
  ( 51,79)( 52,84)( 53,85)( 57,90)( 58,91)( 59,96)( 62,97)( 65,98)
  ( 74,99)( 77,100)( 86,101)( 89,102),( 1,2)( 3,4)(11,12)(15,17)(21,22)
  (23,24)(28,30)(33,34)(36,38)(41,42)(45,47),
 ( 1,13)( 4,18)( 7,26)(10,35)(14,41)(16,42)(19,43)(22,45)(24,47)(27,48)
  (30,49)(31,50)(34,52)(37,54)(39,55)(44,56)(51,57),
 ( 3,4)( 7,8)(11,12)(22,23)(26,27)(28,29)(33,34)(36,37)(38,39),
 ( 1,8)( 3,9)( 5,11)( 6,13),( 2,22)( 4,24)( 6,25)( 9,27)(11,30)(13,31)
  (16,33)(18,35)(21,38)(29,39)(37,40),( 3,4)( 7,8)(11,12)(23,24)(27,28)
  (34,35)(41,42)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62)(63,64)
  (65,66),( 2,22)( 4,24)( 8,26)(10,28)(12,30)(15,32)(17,34)(21,36)(23,38)
  (27,39)(31,40)(35,41),( 2,22)( 4,23)( 5,26)( 7,29)( 9,30)(10,31)(11,32)
  (12,35)(13,38)(14,39)(15,40)(16,41)(18,44)(20,47)(21,48),
 ( 1,2)( 3,4)(13,14)(20,21),( 3,4)( 7,8)(12,13)(14,15)(25,26)(27,28)
  (29,30),( 3,4)( 7,8)(12,13)(15,16)(18,19)(21,22),
 ( 1,2)( 3,4)(14,15)(19,20),( 2,22)( 4,23)( 7,25)( 9,27)(13,28)(15,29)
  (17,31)(21,34)(24,37)(30,40)(33,42)(36,43)(39,44),
 ( 2,22)( 4,23)( 7,24)( 9,26)(12,29)(14,31)(17,32)(20,34)(25,36)(28,38)
  (33,41)(37,43)(40,44),( 1, 8)( 4,19)( 6,24)( 10,32)( 12,36)
  ( 15,37)( 17,41)( 18,44)( 20,45)( 22,46)( 23,47)( 31,68)( 34,69)
  ( 35,70)( 39,74)( 40,75)( 43,76)( 51,79)( 55,81)( 58,88)( 66,93)
  ( 73,98)( 78,100)( 84,118)( 86,119)( 89,122)( 91,123)( 94,124)( 96,127),
 ( 2,22)( 5,26)( 7,27)( 9,29)(12,30)(16,34)(18,35)(21,37)(24,38)(28,39)
  (32,40)(36,41),( 3,4)( 7,8)(12,13)(17,18)(21,22)(27,28)(29,30),
 ( 2,22)( 5,25)( 8,26)(10,29)(13,30)(15,33)(18,34)(21,37)(23,38)(27,39)
  (31,40)(35,41),( 2,22)( 5,25)( 8,26)(11,27)(13,30)(16,33)(18,34)(21,35)
  (23,38)(28,41)(31,42)(36,43)(39,44),( 1,12)( 2,20)( 3,28)( 4,35)( 5,43)
  ( 6,45)( 8,46)(11,47)(14,48)(16,50)(19,52)(22,53)(24,54)(27,55)(30,57)
  (32,59)(34,60)(37,61)(39,62)(42,64),( 3,29)( 4,31)( 6,32)( 7,33)( 9,36)
  (10,37)(13,38)(16,39)(17,42)(18,43)(19,45)(20,46)(21,47)(22,51)(23,52)
  (24,53)(25,55)(26,56)(27,57)(28,60)(40,62)(41,65)(49,67)(61,68)(63,69)
  (64,70)(66,71),( 3,29)( 4,30)( 6,32)( 7,33)( 9,34)(10,35)(13,37)(16,39)
  (17,42)(18,43)(21,45)(22,48)(23,49)(24,50)(27,52)(28,54)(31,56)(36,58)
  (38,59)(40,61)(41,63)(44,65)(46,66)(47,67)(51,69)(53,70)(55,72)(57,73)
  (60,74)(62,75)(64,76)(68,77)(71,78),( 2,22)( 5,23)( 7,26)(10,29)(13,30)
  (16,31)(18,34)(21,35)(24,36)(27,37)(32,40)(38,43)(41,44),
 ( 3,4)( 7,8)(13,15)(16,17)(22,24),( 1,4)( 2,13)( 3,34)( 5,43)( 8,45)
  (10,46)(12,47)(14,51)(17,52)(19,53)(22,55)(24,57)(25,58)(27,62)(31,63)
  (33,64)(35,66)(37,67)(39,71)(41,72)(44,73)(48,75)(50,76)(54,78)(56,80)
  (59,81)(61,82)(65,84)(68,85)(70,86)(74,88)(77,89)(79,91)(83,92)(87,94)
  (90,96)(93,97)(95,98),( 2,22)( 5,23)( 7,24)(10,27)(12,30)(15,31)(18,32)
  (21,37)(25,38)(28,39)(33,40)(35,41),( 3,29)( 8,30)( 9,31)( 13,32)
  ( 19,33)( 20,34)( 26,35)( 37,58)( 38,59)( 40,62)( 41,63)( 47,66)
  ( 48,67)( 50,69)( 52,72)( 64,87)( 68,88)( 74,91)( 76,94)( 78,96)
  ( 80,99)( 83,101)( 84,103)( 86,105)( 90,110)( 93,112)( 95,114)( 98,116)
  (102,118)(104,120)(107,122)(109,123)(113,124)(117,125)(121,126),
 ( 3,4)( 7,8)(14,15)(16,17)(23,24),( 2,21)( 3,22)( 4,24)( 6,25)
  ( 7,27)( 9,28)( 10,30)( 12,31)( 13,32)( 15,34)( 16,35)( 17,36)
  ( 23,60)( 26,62)( 29,63)( 33,65)( 37,70)( 39,71)( 43,76)( 46,78)
  ( 48,79)( 52,84)( 54,85)( 58,90)( 61,91)( 64,92)( 66,93)( 69,95)
  ( 72,109)( 75,111)( 80,112)( 83,114)( 86,115)( 89,117)( 98,120)(103,123)
  (107,126),( 3,28)( 5,30)( 7,31)( 9,32)(11,33)(12,35)(15,36)(16,39)(17,41)
  (18,42)(19,44)(20,45)(21,47)(22,48)(23,49)(24,50)(25,51)(26,55)(27,57)
  (40,61)(52,67)(53,68)(56,69)(58,70)(59,73)(60,74)(63,75)(64,77)(65,78)
  (66,79)(71,81)(72,83),( 1,9)( 3,12)( 6,16)( 7,19)(11,21)(17,23),
 ( 1,2)( 4,10)( 6,11)( 9,12),( 1,8)( 4,11)(13,24)(17,31)(19,37)(21,43)
  (23,49)(26,50)(30,54)(34,58)(38,62)(42,66)(46,70)(51,74)(57,77)(59,78)
  (65,81)(67,82)(73,85),( 2,20)( 5,21)( 7,22)(10,25)(14,30)(15,31)(18,33)
  (23,38)(26,39)(29,41)(34,42)(37,44)(40,45)(43,46),
 ( 2,20)( 5,21)( 8,23)(11,24)(14,26)(17,27),
 ( 2,19)( 3,26)( 5,35)( 7,42)( 9,45)(12,48)(15,49)(18,50)(22,51)(25,52)
  (28,54)(30,56)(34,57)(38,58)(41,59)(46,60)(53,61),
 ( 2,19)( 3,25)( 5,34)( 7,42)( 9,43)(11,44)(15,47)(20,48)(21,49)(23,53)
  (26,55)(28,56)(30,57)(35,60)(40,62)(50,64)(54,65)(63,68)(66,71)(69,72),
 ( 3,26)( 6,27)( 10,28)( 13,29)( 21,30)( 25,31)( 32,66)( 35,71)
  ( 36,72)( 39,75)( 42,78)( 44,79)( 47,84)( 49,85)( 52,90)( 53,91)
  ( 56,94)( 59,97)( 61,98)( 64,103)( 70,104)( 73,105)( 83,106)( 86,107)
  ( 96,108)( 99,109),( 1, 8)( 5,30)( 9,31)( 12,32)( 13,33)( 16,36)
  ( 17,39)( 18,41)( 26,50)( 29,57)( 34,66)( 35,67)( 38,70)( 44,74)
  ( 46,77)( 47,87)( 49,90)( 53,94)( 55,97)( 56,98)( 60,103)( 62,104)
  ( 68,108)( 69,109)( 73,111)( 75,113)( 76,114)( 78,115)( 80,119)( 83,123)
  ( 86,128)( 89,131)( 92,135)( 96,139)(101,143)(102,146)(106,156)(110,157)
  (117,158)(118,161)(121,163)(122,166)(125,168)(126,171)(127,173)(130,175)
  (133,177)(134,178)(137,180)(141,182)(142,183)(145,185)(148,187)(174,191)
  (176,192)(179,193)(181,194)(184,195)(186,196),
 ( 3,4)( 8,10)(11,12)(19,21)(25,27)(29,30)(34,35)(38,40)(43,44)(45,47)
  (51,52)(55,56)(60,61)(64,66)(67,69),( 1,2)( 4,9)( 5,10)( 8,12)(11,14)
  (13,15),( 1,2)(12,13)(14,16)(18,20)(22,23)(29,30)(34,36)(42,43)(45,47)
  (48,50)(51,52)(54,56)(57,59)(60,61)(63,64)(67,68),
 ( 1,8)( 5,11)( 9,13)(10,14),( 1,8)( 6,12)( 9,15)(11,17)(13,19)(16,20)
  (18,21),( 2,18)( 4,24)( 5,26)( 7,28)(10,32)(11,36)(14,38)(15,40)(19,42)
  (22,44)(29,46)(34,48),( 1,12)( 2,15)( 3,19)( 4,22)( 5,27)
  ( 6,33)( 8,34)( 14,38)( 18,42)( 20,44)( 24,50)( 26,52)( 30,54)
  ( 32,56)( 35,58)( 37,60)( 39,62)( 40,64)( 41,66)( 43,68)( 45,71)
  ( 46,72)( 49,75)( 51,76)( 53,77)( 55,79)( 57,81)( 59,82)( 61,83)
  ( 63,85)( 65,87)( 67,90)( 70,92)( 73,93)( 74,94)( 78,96)( 80,98)
  ( 84,101)( 86,104)( 89,106)( 91,107)( 95,110)( 97,111)( 99,114)(100,116)
  (103,118)(105,119)(108,121)(109,123)(113,126)(115,128)(117,130)(120,132)
  (122,134)(124,137)(125,138)(127,139)(129,142)(131,143)(133,146)(136,148)
  (141,150)(145,152)(147,153)(149,154)(151,155),
 ( 2,18)( 5,27)( 8,35)(11,40)(13,41)(15,42)(17,44)(20,46)(24,47)(25,48)
  (28,49)(30,51)(32,53)(36,54)(38,55)(43,56)(50,57),
 ( 2,18)( 5,19)( 6,20)( 9,22)(11,23)(12,25)(15,26)(16,27)(24,39)(28,41)
  (32,48)(42,60)(46,61)(49,63)(57,65)(62,73)(66,74),
 ( 3, 4)( 8, 9)( 11,13)( 17,18)( 21,22)( 23,25)( 27,28)( 32,33)
  ( 38,39)( 48,49)( 54,56)( 63,64)( 68,69)( 72,73)( 83,84)( 85,86)
  ( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)( 97,98)( 99,100),
 ( 1, 7)( 2,22)( 3,46)( 6,47)( 14,50)( 17,51)( 20,52)( 25,54)
  ( 28,56)( 31,60)( 35,62)( 37,66)( 41,68)( 45,72)( 49,76)( 53,79)
  ( 55,81)( 58,89)( 59,91)( 61,92)( 64,94)( 65,96)( 67,97)( 70,99)
  ( 71,101)( 74,103)( 78,104)( 84,106)( 86,108)( 88,110)(105,111)(107,112)
  (109,113),( 2,17)( 3,20)( 6,21)( 8,22)(10,23)(11,26)(14,27)(16,28)(19,40)
  (25,41)(38,52)(43,61)(49,63)(55,65)(57,68)(66,76)(71,78),
 ( 1,7)( 2,21)( 3,27)( 4,31)( 5,36)( 8,41)(10,42)(11,43)(13,45)(14,47)
  (16,49)(19,51)(23,52)(24,53)(26,54)(28,56)(30,58)(32,60)(34,62)(38,63)
  (40,65)(44,66)(48,67)(50,69)(55,70)(59,71)(61,73)(64,74)(68,75)(72,76),
 ( 2,17)( 3,19)( 5,20)( 8,22)( 9,23)(12,24)(14,26)(15,27)(21,40)(25,42)
  (36,55)(44,60)(47,61)(53,65)(62,70)(66,71),
 ( 2,17)( 3,19)( 6,21)( 7,25)(10,29)(12,31)(13,33)(15,39)(23,41)(28,43)
  (35,45)(38,47),( 2,17)( 3,18)( 5,20)( 6,21)( 8,22)( 9,24)(12,25)(13,27)
  (15,28)(16,29),( 1,7)( 2,18)( 3,23)( 4,27)( 5,38)( 8,39)(10,40)(11,42)
  (13,44)(17,45)(19,46)(21,47)(24,50)(26,52)(28,54)(30,55)(32,57)(35,60)
  (37,63)(41,64)(43,66)(48,69)(49,70)(51,71)(53,73)(56,76)(59,77)(61,78)
  (62,79)(65,80)(68,81)(72,82)(75,83),( 3,4)( 8,9)(11,12)(20,21)(23,24)
  (27,28)(30,31),( 1,12)( 2,15)( 4,18)( 5,19)( 6,20)( 8,21)( 9,24)(11,25)
  (14,26)(17,27)(23,30)(29,33)(32,34),( 2,17)( 3,18)( 6,20)( 8,21)(10,22)
  (11,23)(14,25)(16,26)(19,38)(24,40)(30,47)(45,61)(53,64)(56,67)(59,75)
  (69,80)(73,83),( 3,23)( 5,24)( 8,25)(10,29)(13,30)(17,31)(20,35)(22,36)
  (27,37)(28,38)(33,39)(34,40),( 2,17)( 4,29)( 6,38)( 8,40)( 9,42)(11,44)
  (14,48)(20,51)(23,52)(24,54)(26,56)(30,60)(33,62)(37,65)(45,66)(47,68)
  (50,69)(57,70)(59,72)(64,73),( 2,17)( 4,26)( 5,31)( 7,39)(11,41)(15,45)
  (20,47)(22,50)(24,51)(27,55)(29,56)(33,60)(37,64)(40,67)(43,68)(48,69)
  (52,72)(53,73)(58,74)(62,75)(65,76)(70,77),
 ( 2,17)( 4,23)( 5,25)( 7,27)(10,31)(11,35)(14,37)(15,39)(19,41)(22,43)
  (29,45)(34,47),( 3,23)( 5,24)( 8,25)(10,26)(13,30)(15,31)(18,32)(19,33)
  (22,36)(29,37)(35,39),( 1,12)( 2,14)( 3,17)( 4,21)( 5,23)( 6,26)( 7,29)
  ( 8,32)( 9,35)(11,38)(15,42)(19,46)(20,47)(24,49)(28,53)(33,55)(37,57)
  (39,58)(43,60)(45,61)(48,65)(50,66)(54,68)(56,71)(64,72)(70,74),
 ( 1,7)( 2,15)( 3,29)( 5,41)( 8,46)(10,47)(12,49)(14,51)(16,53)(19,56)
  (21,57)(24,59)(25,61)(27,63)(30,64)(33,69)(34,70)(36,72)(38,74)(40,76)
  (43,77)(45,78)(48,81)(52,82)(55,83)(58,86)(62,87)(66,88)(68,89)(71,92)
  (75,93)(80,94)(85,95)(91,96),( 3,23)( 6,27)( 8,29)( 10,32)
  ( 11,40)( 12,45)( 14,50)( 15,54)( 16,55)( 18,62)( 20,65)( 22,70)
  ( 26,74)( 31,79)( 33,81)( 34,84)( 35,86)( 36,88)( 37,91)( 38,93)
  ( 39,95)( 41,97)( 42,98)( 43,100)( 44,102)( 46,105)( 47,106)( 48,108)
  ( 49,110)( 51,111)( 52,113)( 53,115)( 57,116)( 58,119)( 59,120)( 60,122)
  ( 61,124)( 63,125)( 64,127)( 67,129)( 68,130)( 72,131)( 73,132)( 77,133)
  ( 78,134)( 83,135)( 85,136)( 87,137)( 90,138)( 92,139)( 94,140)( 96,141)
  ( 99,142)(101,143)(103,144)(104,145)(107,146)(109,147)(112,148)(114,149)
  (117,150)(118,151)(121,152)(123,153)(126,154)(128,155),
 ( 2,17)( 4,19)( 5,20)( 7,21)(10,22)(12,24)(13,25)(15,26)(18,38)(23,40)
  (27,42)(33,53)(44,60)(51,65),( 1,7)( 2,15)( 3,22)( 4,30)( 5,37)( 8,44)
  (11,45)(13,47)(16,49)(19,50)(21,51)(23,52)(26,54)(28,56)(31,57)(33,58)
  (35,59)(38,61)(41,63)(43,64),( 3,22)( 5,32)( 6,33)( 7,34)
  ( 9,38)( 11,40)( 12,42)( 15,45)( 16,46)( 17,47)( 20,51)( 23,52)
  ( 25,54)( 35,83)( 36,84)( 41,86)( 43,87)( 48,88)( 49,89)( 53,91)
  ( 55,92)( 61,100)( 65,101)( 69,103)( 74,105)( 78,106)( 82,108),
 ( 2,17)( 4,18)( 5,21)( 8,22)(11,23)(12,26)(14,27)(16,28)(20,44)(25,45)
  (32,48)(36,50)(40,54),( 1,12)( 2,13)( 3,18)( 4,21)( 5,27)(11,40)(14,46)
  (15,47)(17,48)(20,51)(22,54)(25,57)(26,58)(28,59)(29,61)(33,66)(35,69)
  (37,70)(39,73)(41,74)(42,75)(44,76)(49,77)(52,78)(55,79)(60,80)(62,81)
  (67,82)(71,83),( 3,4)( 8,9)(12,13)(20,21)(23,24)(26,27)(30,31),
 ( 2,17)( 4,18)( 5,19)( 8,21)(10,22)(12,23)(13,24)(16,26)(20,39)(25,41)
  (28,45)(36,56)(48,63)(54,66),( 1,7)( 2,14)( 3,30)( 4,32)(35,44)(36,47)
  (37,59)(38,62)(40,69)(41,71)(45,72)(46,73)(50,75)(51,77)(55,78)(56,79)
  (60,81)(61,83)(65,84)(66,85),( 3,4)( 8,9)(12,13)(20,21)(28,29)(36,37)
  (43,44),( 2,17)( 4,18)( 5,19)( 8,21)(11,22)(12,23)(14,26)(16,27)(20,43)
  (24,44)(30,46)(34,49)(38,51),( 3,4)( 8,9)(13,16)(18,21)(23,26)(34,37)
  (39,40)(42,45),( 3,4)( 8,9)(13,15)(22,23)(24,26)(28,30)(33,34)(37,38)
  (41,43)(48,50)(51,52)(56,57)(58,59),( 1, 7)( 2,14)( 3,20)( 4,25)
  ( 5,28)( 6,31)( 8,35)( 10,36)( 13,37)( 17,43)( 19,45)( 22,48)
  ( 24,52)( 27,53)( 29,55)( 34,57)( 38,61)( 39,62)( 42,64)( 44,69)
  ( 46,71)( 47,72)( 49,76)( 51,78)( 54,79)( 56,81)( 58,82)( 60,84)
  ( 63,85)( 65,86)( 68,88)( 70,93)( 73,94)( 75,96)( 77,97)( 80,100)
  ( 83,101)( 87,102)( 89,103)( 92,105)( 95,108)( 99,109)(104,112)(106,113)
  (110,115)(114,117)(116,118),( 1, 7)( 2,14)( 3,20)( 4,24)( 5,31)
  ( 8,32)( 10,35)( 15,38)( 17,40)( 21,47)( 23,49)( 25,52)( 27,54)
  ( 29,56)( 33,61)( 34,64)( 36,66)( 37,68)( 41,70)( 43,72)( 44,74)
  ( 45,75)( 46,78)( 48,80)( 50,82)( 53,84)( 55,85)( 57,86)( 59,88)
  ( 60,90)( 62,91)( 65,93)( 67,94)( 69,95)( 71,96)( 76,98)( 79,100)
  ( 81,101)( 83,102)( 87,103)( 92,105)( 97,106)( 99,107)(104,108),
 ( 2,17)( 5,30)( 6,39)( 7,42)( 9,44)(11,47)(12,48)(14,51)(16,53)(21,54)
  (26,58)(29,59)(32,62)(34,64)(38,65)(50,66)(52,67)(61,68)(63,69),
 ( 2,17)( 5,20)( 7,21)( 8,22)(10,23)(13,26)(15,27)(16,28)(18,40)(24,41)
  (37,57)(44,61)(47,62)(52,65)(55,66),( 2,17)( 5,18)( 7,19)( 8,21)(11,23)
  (12,24)(15,25)(16,26)(22,40)(29,43)(33,47)(41,59)(45,61)(46,62)(56,66)
  (60,71)(65,72),( 2,17)( 5,18)( 9,20)( 15,22)( 19,38)( 23,39)
  ( 25,41)( 26,42)( 27,44)( 30,47)( 31,49)( 32,50)( 33,51)( 34,53)
  ( 36,55)( 37,57)( 43,66)( 46,67)( 52,68)( 56,69)( 58,70)( 60,71)
  ( 62,75)( 63,77)( 65,81)( 72,88)( 74,89)( 76,90)( 78,91)( 80,92)
  ( 82,93)( 84,94)( 85,95)( 86,97)( 87,99)( 96,101)( 98,102)(100,103),
 ( 1, 7)( 2,14)( 5,25)( 9,31)( 11,34)( 13,35)( 16,37)( 17,41)
  ( 20,43)( 22,46)( 24,48)( 26,52)( 33,77)( 39,78)( 40,79)( 45,80)
  ( 50,81)( 51,82)( 57,89)( 61,90)( 64,93)( 72,95)( 75,98)( 91,109)
  ( 96,110),( 1, 7)( 2,14)( 8,40)( 11,41)( 20,42)( 22,43)( 25,44)
  ( 27,45)( 30,53)( 32,54)( 35,62)( 39,70)( 46,92)( 48,95)( 49,96)
  ( 51,99)( 52,100)( 55,102)( 57,105)( 58,106)( 60,109)( 61,110)( 63,112)
  ( 65,115)( 66,116)( 68,119)( 69,120)( 74,124)( 76,127)( 78,129)( 83,131)
  ( 87,132)( 91,133)( 94,134)( 98,136)(104,138)(108,140)(114,142)(118,144)
  (122,146)(126,147),( 3,4)( 8,9)(13,14)(17,18)(23,24)(25,26),
 ( 3,4)( 8,9)(13,14)(17,18)(28,29)(35,36),
 ( 2,16)( 3,20)( 5,25)( 7,30)( 9,48)(11,49)(13,52)(17,53)(18,54)(21,55)
  (23,58)(26,59)(28,60)(32,61)(36,64)(42,67)(50,68)(56,69),
 ( 1,9)( 4,17)( 6,21)( 8,25)(10,43)(12,44)(13,45)(15,48)(18,49)(22,50)
  (23,51)(26,54)(28,55)(33,63)(38,68)(46,72)(52,73)(56,77)(78,84)(80,86),
 ( 1,7)( 2,13)( 3,20)( 4,27)( 5,33)( 6,39)( 8,41)(10,42)(12,44)(15,45)
  (16,46)(19,47)(21,50)(23,51)(26,52)(28,54)(31,57)(34,58)(36,61)(38,62)
  (43,65)(48,66)(49,67)(53,70)(56,71)(59,72)(60,73)(64,74)(69,75),
 ( 1,2)( 4,5)( 6,7)(10,11)(17,18)(22,23),
 ( 1, 7)( 2,13)( 3,20)( 4,26)( 5,31)( 35,49)( 37,58)( 38,60)
  ( 42,64)( 43,66)( 46,68)( 50,71)( 51,72)( 54,73)( 55,79)( 74,87)
  ( 76,90)( 78,93)( 80,96)( 82,99)( 84,102)( 85,103)( 88,105)( 91,107)
  ( 94,109)( 97,111)(100,113),( 1,3)( 8,10)(13,15)(18,20)(24,25)(35,36)
  (45,46)(48,49)(53,54),( 1,12)( 3,16)( 5,20)( 8,28)( 9,43)(11,44)(14,47)
  (15,48)(19,49)(22,50)(24,53)(25,54)(27,55)(37,64)(41,71)(46,73)(52,74)
  (59,77)(67,80),( 3,18)( 5,26)( 6,32)( 10,35)( 12,37)( 15,39)
  ( 17,40)( 20,43)( 22,46)( 24,49)( 25,51)( 31,55)( 34,57)( 38,61)
  ( 41,65)( 45,70)( 48,74)( 54,78)( 63,84)( 67,89)( 69,91)( 77,95)
  ( 80,97)( 82,100)( 86,103)( 88,105)( 93,108)( 99,113)(102,117)(109,122)
  (112,125)(115,127)(120,131)(124,136)(129,141)(133,145)(135,147)(140,149)
  (144,151),( 2,3)( 7,8)(14,15)(20,21)(23,24)(28,29)(31,32)(36,37)(38,39)
  (42,43)(45,46)(47,48)(50,51)(54,55)(57,58)(61,62)(64,65)(66,67)(70,71)
  (75,76)(78,79)(82,83)(84,85)(88,89),( 2,16)( 6,28)( 7,29)( 12,32)
  ( 19,37)( 21,40)( 24,48)( 27,56)( 31,65)( 33,68)( 35,70)( 36,71)
  ( 39,82)( 41,85)( 42,88)( 45,90)( 46,93)( 47,96)( 49,99)( 50,102)
  ( 52,105)( 54,108)( 55,110)( 57,113)( 58,116)( 60,119)( 61,120)( 62,121)
  ( 63,122)( 67,127)( 69,128)( 72,132)( 80,152)( 84,154)( 86,156)( 92,158)
  ( 94,160)( 98,162)(100,164)(104,166)(106,168)(112,170)(114,172)(118,174)
  (123,179)(124,180)(129,181)(130,182)(135,183)(137,184)(139,187)(141,190)
  (143,191)(145,194)(147,197)(149,198)(151,201)(186,210)(189,211)(193,212)
  (196,213)(200,214)(203,215),( 1,2)( 4,5)( 7,8)( 9,10)(12,13)(14,15)
  (17,18)(19,20)(23,24)(28,29)(30,31)(37,38)(39,40)(45,46)(48,49)(52,53),
 ( 1, 7)( 2,13)( 3,17)( 4,29)( 5,34)( 8,37)( 10,38)( 14,41)
  ( 16,43)( 18,45)( 20,47)( 22,50)( 24,53)( 28,54)( 30,55)( 32,56)
  ( 36,58)( 39,59)( 40,60)( 42,61)( 44,62)( 46,65)( 49,68)( 51,70)
  ( 52,73)( 57,78)( 63,80)( 64,81)( 66,82)( 67,83)( 69,86)( 72,89)
  ( 74,90)( 75,91)( 77,94)( 79,95)( 84,96)( 85,97)( 87,98)( 88,99)
  ( 92,102)( 93,103)(100,106)(101,107)(104,108)(105,109),
 ( 3,4)( 8,9)(13,14)(20,21)(23,24)(26,27)(30,31),
 ( 1,12)( 3,14)( 5,16)( 7,17)(15,45)(20,50)(21,51)(24,54)(25,56)(27,57)
  (28,58)(30,61)(33,63)(35,64)(36,65)(39,68)(42,70)(46,71)(49,72)(53,82)
  (55,84)(60,86)(62,88)(67,90)(69,92),( 1,2)( 4,5)( 7,8)( 9,10)(19,20)
  (24,25),( 3,4)( 8,9)(13,14)(20,21)(27,28)(35,36)(41,42),
 ( 3,4)( 8,9)(13,14)(20,21)(27,28)(37,38)(40,41),
 ( 2,15)( 3,17)( 4,22)( 5,24)( 6,26)( 7,31)( 8,34)(13,43)(16,44)(19,45)
  (20,46)(23,47)(25,48)(28,49)(29,50)(32,51)(33,52)(36,53)(37,55)(38,56)
  (39,58)(40,59)(41,61)(42,62)(54,63)(57,64)(60,65),
 ( 3,4)( 8,9)(13,14)(21,22)(28,29)(35,36),
 ( 3,17)( 4,18)( 7,19)( 8,21)(10,23)(13,24)(15,26)(16,28)(20,40)(25,41)
  (31,45)(47,60)(51,63)(54,64)(58,67),( 3,4)( 8,9)(13,14)(25,27)(28,30)
  (33,35)(37,39)(40,42),( 2,15)( 4,24)( 5,30)( 7,42)( 9,43)(11,47)(14,50)
  (19,52)(21,53)(23,54)(26,55)(29,58)(34,60)(38,62)(40,63)(46,64)(49,66)
  (59,69)(65,71)(68,72),( 3,4)( 8,9)(14,17)(19,20)(22,25)(33,36)(38,41)
  (43,46),( 1, 7)( 2,12)( 3,21)( 4,27)( 5,32)( 35,50)( 36,55)
  ( 40,59)( 41,61)( 45,64)( 46,66)( 48,67)( 52,71)( 53,73)( 54,82)
  ( 75,92)( 78,94)( 81,96)( 84,98)( 87,100)( 90,102)( 91,103)( 93,105)
  ( 95,106)( 97,108)( 99,109)(101,111),( 1,12)( 4,20)( 6,25)( 8,30)( 9,48)
  (13,50)(14,51)(16,52)(18,53)(21,56)(23,57)(26,58)(28,59)(33,61)(37,62)
  (44,65)(49,67)(54,69),( 2,15)( 4,18)( 6,20)(11,23)(13,25)(17,46)(19,47)
  (24,48)(26,49)(28,51)(30,54)(32,55)(35,57)(37,60)(39,61)(42,63)(44,66)
  (53,70)(59,71)(65,72),( 3,4)( 8,9)(14,15)(20,21)(22,23)(26,27)(29,30),
 ( 2,3)( 4,5)(13,14)(16,17)(19,20),( 1,12)( 5,26)( 8,37)( 9,38)(11,41)
  (14,42)(17,44)(19,47)(21,50)(23,53)(27,54)(28,57)(31,58)(34,62)(39,65)
  (43,66)(46,69)(49,71)(55,74)(59,76)(61,78)(68,79)(75,81),
 ( 2,9)( 3,10)( 5,12)( 6,13)( 8,15)(11,16)(14,17),
 ( 3,4)( 8,9)(15,16)(20,21)(22,23)(26,27)(29,30),
 ( 2,15)( 5,18)( 6,19)( 8,21)(12,22)(13,24)(17,39)(20,42)(23,45)(26,46)
  (28,48)(31,53)(33,55)(37,59)(41,62)(44,63)(52,70)(58,73),
 ( 3,4)( 8,9)(15,16)(20,21)(26,27)(33,34),
 ( 1,11)( 2,27)( 3,29)( 4,34)(35,44)(36,47)(37,59)(38,62)(40,69)(41,71)
  (45,72)(46,73)(50,75)(51,77)(55,78)(56,79)(60,81)(61,83)(65,84)(66,85),
 ( 1,11)( 2,25)( 3,37)( 4,39)( 6,40)( 8,42)( 10,45)( 13,48)
  ( 15,52)( 16,53)( 20,56)( 21,59)( 24,62)( 26,66)( 29,68)( 31,71)
  ( 33,74)( 36,75)( 41,77)( 43,78)( 46,79)( 49,81)( 51,82)( 54,86)
  ( 55,87)( 57,88)( 60,89)( 63,91)( 65,92)( 67,93)( 69,94)( 72,95)
  ( 76,100)( 80,104)( 83,105)( 85,106)( 90,110)( 96,114)( 97,115)( 99,116)
  (101,117)(103,118)(107,119)(109,120)(111,121)(113,122),
 ( 1, 7)( 2,12)( 3,18)( 4,26)( 35,38)( 36,59)( 39,61)( 41,62)
  ( 44,64)( 45,65)( 47,67)( 50,69)( 51,70)( 54,72)( 56,73)( 57,79)
  ( 58,85)( 74,87)( 76,90)( 78,93)( 80,96)( 82,99)( 84,102)( 88,105)
  ( 91,106)( 94,108)( 97,109)(100,111)(103,112),
 ( 2,14)( 3,19)( 5,28)( 8,39)(12,43)(16,47)(18,48)(21,52)(23,53)(25,56)
  (30,58)(34,62)(38,64)(41,65)(45,66)(50,67)(51,68)(55,71)(60,72)(63,73)
  (70,76)(75,77),( 1,11)( 2,21)( 3,22)( 4,24)( 5,28)( 6,31)( 7,34)( 8,36)
  ( 9,37)(10,39)(12,42)(13,43)(15,44)(16,46)(18,47)(25,51)(27,52)(29,53)
  (30,55)(32,56),( 3,16)( 4,20)( 6,25)( 8,30)( 9,45)(11,46)(13,49)(17,50)
  (18,51)(21,52)(23,55)(26,56)(28,57)(32,59)(37,63)(47,72)(53,73)(70,78)
  (75,79)(77,80),( 2,14)( 3,17)( 4,21)( 5,22)( 6,25)( 7,29)( 8,32)(13,41)
  (15,42)(19,44)(20,45)(23,47)(27,49)(28,50)(30,52)(35,55)(36,56)(37,58)
  (38,59)(39,61)(40,62)(43,63)(46,64)(48,65)(51,66)(53,67)(54,68)(57,70)
  (60,72)(69,74)(71,75)(73,76),( 2,14)( 3,17)( 4,20)( 5,21)( 6,25)( 7,28)
  ( 8,29)(13,42)(15,43)(19,45)(22,47)(23,48)(27,50)(30,52)(31,53)(35,54)
  (36,56)(37,57)(38,59)(39,60)(40,62)(41,63)(44,64)(46,65)(49,66)(51,67)
  (55,69)(58,71)(61,73)(68,74)(70,75)(72,76),
 ( 3,4)( 9,12)(13,15)(19,21)(22,25)(26,28)(31,33)(36,39)(42,44)(47,48)
  (51,52)(55,56)(58,59),( 3,4)( 9,11)(12,13)(20,22)(25,27)(29,30)(33,34)
  (36,37)(39,41)(44,45)(46,48)(54,55)(61,63)(64,66),
 ( 2,14)( 3,15)( 4,17)( 6,19)( 7,20)(10,21)(13,22)(16,23)(18,24),
 ( 1,7)( 2,12)( 3,15)( 4,28)(32,41)(33,45)(34,56)(35,60)(37,67)(39,70)
  (42,73)(44,74)(47,76)(49,79)(52,82)(54,83)(57,85)(59,88)(62,91)(64,92),
 ( 2,14)( 3,15)( 5,17)( 6,18)( 7,20)( 8,21)(10,22)(11,24)(12,25)(13,27),
 ( 3,4)( 9,11)(13,15)(17,19)(24,26)(28,29)(31,33)(36,37),
 ( 1,2)( 4,5)( 9,11)(13,15),( 2,14)( 4,23)( 5,29)( 8,43)(13,45)(18,48)
  (20,49)(22,50)(25,52)(27,56)(28,57)(33,58)(37,61)(39,62)(41,63)(42,66)
  (51,69)(55,70)(65,71)(68,72),( 1,11)( 2,18)( 3,23)( 4,31)( 5,37)( 6,39)
  ( 7,40)( 9,43)(10,44)(12,47)(13,48)(16,50)(19,51)(22,52)(24,55)(25,56)
  (27,59)(30,61)(32,62)(34,64)(36,65)(45,67)(46,68)(49,69)(57,71)(58,72)
  (63,73),( 1,7)( 2,12)( 3,14)( 4,30)(35,45)(36,48)(37,60)(38,63)(41,70)
  (42,71)(46,72)(47,74)(51,76)(52,77)(56,78)(57,80)(61,82)(62,83)(66,84)
  (67,86),( 1,7)( 2,12)( 3,14)( 4,18)(29,45)(30,49)(31,63)(32,67)(35,69)
  (36,71)(41,74)(42,75)(47,78)(48,80)(53,83)(54,84)(59,87)(60,89)(65,92)
  (66,93),( 1, 7)( 2,12)( 4,36)( 6,38)( 10,40)( 11,43)( 14,44)
  ( 16,45)( 18,48)( 19,49)( 24,52)( 26,55)( 28,58)( 42,76)( 46,78)
  ( 54,83)( 56,84)( 60,91)( 67,96)( 71,102)( 75,104)( 80,106)( 82,107)
  ( 88,120)( 90,122)( 93,123)( 95,124)( 98,126)(100,127)(103,131)(105,132),
 ( 3,4)( 9,11)(18,19)(22,24)(27,29)(32,33)(40,42)(45,47)(48,50),
 ( 1,7)( 2,12)( 4,15)(11,17)(14,21),( 1,4)( 2,7)( 5,9)(11,14)(12,15)
  (13,16),( 3,4)( 9,10)(12,14)(21,22)(24,25)(30,31)(36,37)(44,45)(47,48)
  (52,53)(55,56)(61,62)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)
  (82,83)(84,85)(86,87)(88,89),( 3,4)( 9,10)(12,14)(28,29)(34,35)(39,40)
  (41,42)(43,44)(45,46)(47,48)(50,51)(53,54)(55,56)(58,59)(61,62)(64,65)
  (76,77)(78,79)(80,81),( 3,4)( 9,10)(12,13)(15,16)(17,18)(20,21)(22,23),
 ( 2,14)( 4,19)( 6,23)( 7,27)(10,43)(11,44)(13,45)(16,48)(18,49)(21,50)
  (22,51)(26,53)(29,54)(30,55)(38,67)(47,71)(52,73)(58,77)(65,81),
 ( 3,15)( 5,16)( 7,20)( 8,21)(10,25)(12,26),
 ( 1,7)( 2,11)( 3,22)( 6,23)( 8,24)(13,25)(15,26)(18,27)(20,28),
 ( 1,8)( 2,18)( 3,26)( 4,42)( 7,45)(10,47)(12,50)(13,51)(15,53)(17,54)
  (20,57)(22,58)(25,60)(27,63)(29,64)(31,65)(34,68)(36,70)(38,73)(40,75)
  (43,76)(46,78)(49,79)(52,80)(55,81)(59,83)(62,84)(66,85)(69,87)(72,88)
  (74,89)(77,90)(82,91)(86,92),( 1,7)( 2,11)( 3,18)( 4,21)( 5,31)( 8,39)
  (10,41)(14,44)(15,46)(19,49)(23,53)(25,55)(28,57)(30,59)(32,61)(34,62)
  (35,63)(37,64)(38,65)(42,68)(43,69)(45,71)(47,73)(48,74)(51,75)(54,78)
  (56,80)(58,82)(60,84)(66,85)(67,87)(70,88)(72,89)(76,90)(77,92)(79,93)
  (81,94)(83,95)(86,96)(91,97),( 2,14)( 5,27)( 7,34)( 9,36)
  ( 10,39)( 11,41)( 13,42)( 15,43)( 17,45)( 19,47)( 21,50)( 22,52)
  ( 25,54)( 37,80)( 44,82)( 48,83)( 53,85)( 55,86)( 57,92)( 61,93)
  ( 66,94)( 70,95)( 74,96)( 81,99)( 84,100)( 98,106)(103,109)(105,110),
 ( 1,11)( 2,17)( 3,20)( 4,24)( 5,27)( 6,32)( 7,35)( 8,39)(10,40)(12,43)
  (14,46)(16,48)(18,49)(21,50)(23,53)(26,55)(29,58)(30,60)(34,61)(37,62)
  (41,64)(45,65)(51,67)(57,68),( 3,14)( 4,17)( 6,20)( 8,23)( 9,26)(11,29),
 ( 2,14)( 6,17)( 7,19)( 9,21)(11,23)(13,25)(15,46)(20,48)(22,50)(29,52)
  (32,54)(34,56)(37,58)(41,60)(44,62)(47,63)(49,64),
 ( 3,14)( 4,16)( 7,19)( 8,21)( 9,24)(12,26),
 ( 2,14)( 6,17)( 8,20)( 9,21)(11,23)(13,26)(15,45)(19,46)(22,47)(25,48)
  (28,49)(31,52)(35,54)(38,57)(42,60)(63,71)(66,73)(69,75),
 ( 3,4)( 9,10)(13,14)(17,18)(27,28)(33,34)(36,37)(40,41)(43,44)(46,47)
  (50,51)(52,53)(56,57)(58,59)(70,71)(72,73)(74,75),
 ( 2,13)( 3,22)( 6,35)( 8,42)(10,45)(14,46)(18,47)(20,48)(23,49)(26,52)
  (29,53)(32,54)(36,55)(39,56)(43,59)(51,60)(58,61),
 ( 2,13)( 3,19)( 5,27)( 8,34)( 14,38)( 16,39)( 17,42)( 20,46)
  ( 22,47)( 23,49)( 28,54)( 33,56)( 35,58)( 40,63)( 43,65)( 44,68)
  ( 48,73)( 50,77)( 59,83)( 66,87)( 69,89)( 70,92)( 74,95)( 80,99)
  ( 90,104)( 93,106)(100,110)(107,114)(111,116),
 ( 2,13)( 3,18)( 5,24)( 7,30)( 10,33)( 14,35)( 15,36)( 17,39)
  ( 19,43)( 20,44)( 22,45)( 31,67)( 32,68)( 37,71)( 40,73)( 41,74)
  ( 46,77)( 47,78)( 53,85)( 60,91)( 63,97)( 69,99)( 75,100)( 81,120)
  ( 83,122)( 87,125)( 89,127)( 93,129)( 95,132),
 ( 3,4)( 9,10)(13,14)(24,25)(32,33)(35,36)(39,40)(44,45)(47,48)(49,50)
  (53,54)(55,56)(59,60)(61,62)(63,64)(66,67)(68,69)(72,73)(74,75)(76,77),
 ( 2,13)( 3,18)( 6,26)( 8,30)( 9,47)(11,48)(14,49)(16,50)(19,53)(21,54)
  (23,55)(27,56)(28,59)(34,60)(41,65)(51,70)(57,71)(63,74)(68,75),
 ( 3,4)( 9,10)(14,16)(17,18)(21,23)(27,29)(32,33)(35,36),
 ( 3,14)( 5,15)( 7,19)( 8,20)(10,24)(12,25),
 ( 3,4)( 9,10)(14,15)(16,17)(20,21),( 3,4)( 9,10)(14,15)(16,17)(21,22),
 ( 1,4)( 2,6)( 7,11)( 8,13)(12,15)(14,16),
 ( 1,2)( 4,5)(11,12)(17,18)(20,21)(25,26)(27,28)(32,33)(35,36)(42,43)
  (44,45)(47,48)(49,50)(55,56)(58,59)(61,62)(64,65)(66,67)(72,73)(75,76)
  (78,79)(82,83),( 2,13)( 3,16)( 4,17)( 6,18)( 8,21)( 9,22)(11,24)(12,25)
  (15,26)(20,28)(23,30)(27,31)(29,32),( 2,13)( 3,16)( 6,22)( 8,25)(14,46)
  (15,47)(19,48)(23,49)(24,50)(28,51)(29,52)(32,55)(33,58)(34,59)(37,62)
  (38,65)(40,66)(43,69)(44,72),( 2,13)( 3,15)( 4,16)( 6,18)( 9,20)(12,21)
  (14,22)(17,23)(19,24),( 2,13)( 3,15)( 5,16)( 6,17)( 8,19)( 9,21)(11,23)
  (12,24)(14,26)(18,29)(22,31)(27,32)(30,33),
 ( 1, 7)( 2,10)( 3,18)( 4,35)( 6,38)( 9,43)( 12,44)( 14,45)
  ( 16,48)( 23,54)( 24,55)( 27,58)( 40,84)( 42,86)( 47,87)( 51,88)
  ( 53,90)( 57,91)( 61,98)( 65,99)( 69,101)( 73,102)( 77,103)( 81,105),
 ( 1,2)( 4,5)(18,19)(20,21)(24,25)(31,32)(33,34)(36,37)(38,39)(41,42)
  (43,44)(48,49)(50,51)(53,54),( 1,2)( 4,5)(21,22)(26,27)(30,31)(32,33)
  (35,36)(37,38)(39,40)(42,43)(47,48)(49,50)(51,52)(53,54)(55,56)(58,59)
  (60,61)(70,71)(73,74),( 2,13)( 3,14)( 5,15)( 6,18)( 8,20)( 9,21)(11,23)
  (12,25)(17,26)(19,27)(24,29)(28,31)(30,32),
 ( 2,13)( 3,14)( 5,15)( 6,18)( 8,20)( 9,21)(11,22)(12,24)(17,25)(19,26)
  (23,29)(28,32)(31,33),( 1,4)( 2,5)(11,19)(17,33)(21,35)(29,44)(31,50)
  (39,51)(41,53)(43,55)(45,57)(47,59)(49,61)(54,64)(58,66)(62,68),
 ( 3,4)( 9,10)(15,16)(18,20)(22,23)(25,27)(29,30)(35,36)(40,41)(48,49)
  (51,52)(56,57)(58,59),( 2,13)( 4,19)( 6,28)( 8,40)(10,42)(12,46)(17,47)
  (20,50)(23,52)(24,53)(27,55)(31,59)(34,60)(36,63)(39,65)(45,66)(49,67)
  (58,68)(62,69),( 2,13)( 4,19)( 7,27)( 8,33)(10,35)(12,36)(16,40)(18,41)
  (22,44)(25,45)(26,48)(29,52)(32,55)(38,61)(46,71)(51,75)(54,77)(60,80)
  (63,82)(70,83)(73,85),( 2,13)( 4,19)( 7,27)( 8,33)(10,35)(12,36)(16,40)
  (18,41)(22,44)(25,45)(26,48)(29,51)(32,54)(37,60)(46,70)(50,75)(53,77)
  (59,80)(62,82)(69,83)(72,85),( 2,13)( 4,18)( 7,26)( 8,30)(10,48)(12,49)
  (15,50)(17,51)(20,54)(22,55)(24,56)(25,57)(29,59)(34,60)(41,64)(53,67)
  (58,69)(63,74)(66,76),( 1,7)( 2,10)( 3,14)( 4,19)(13,27)(18,31)(22,33)
  (35,41)(38,42),( 1,7)( 2,10)( 3,14)( 4,19)(13,26)(18,30)(21,33)(29,36),
 ( 3,12)( 5,16)( 7,21)( 8,26)(10,45)(11,48)(15,49)(18,50)(20,51)(23,54)
  (25,55)(28,56)(30,57)(31,58)(36,61)(47,73)(53,74)(62,76)(69,78),
 ( 3,12)( 5,15)( 6,18)( 8,21)(10,22)(16,23),
 ( 1,7)( 2,10)( 3,13)( 5,14)( 6,16)(11,18)(17,20)(19,22),
 ( 2,13)( 4,17)( 5,21)( 8,29)( 9,42)(11,43)(14,46)(18,47)(19,48)(22,49)
  (24,52)(27,53)(37,61)(40,67)(44,70)(50,71)(55,76)(62,79)(63,80)(69,83)
  (77,90)(81,91),( 3,12)( 5,14)( 7,15)( 9,17)(18,21)(19,27),
 ( 2,13)( 4,16)( 5,19)( 7,22)( 9,25)(10,28),
 ( 2,4)( 6,8)(10,12)(14,15)(17,18)(20,21),
 ( 3,4)(10,13)(19,20)(22,23)(26,27)(29,30)(33,34)(35,36)(37,38)(40,41)
  (43,44)(45,46)(50,51)(52,53),( 1,45)( 3,47)( 5,49)( 7,50)( 9,52)(11,53)
  (14,55)(16,56)(18,58)(20,60)(23,62)(25,64)(27,66)(29,67)(32,69)(34,70)
  (36,72)(38,73)(40,75)(42,77),( 3,4)(10,12)(14,16)(18,20)(23,24)(26,27)
  (30,31)(34,35)(38,39)(42,43),( 3,4)(10,12)(14,16)(18,20)(24,25)(29,30)
  (32,33)(37,38)(40,41)(44,45),( 2,13)( 4,15)( 6,16)( 7,18)( 9,20)(10,21)
  (12,23)(14,24)(17,25)(19,26)(22,27),( 2,13)( 5,26)( 6,34)( 8,36)
  ( 9,39)( 10,41)( 12,42)( 14,43)( 16,45)( 18,47)( 20,50)( 21,52)
  ( 24,54)( 37,80)( 44,82)( 48,83)( 53,85)( 55,86)( 57,92)( 61,93)
  ( 66,94)( 70,95)( 74,96)( 81,99)( 84,100)( 98,106)(103,109)(105,110),
 ( 2,13)( 5,26)( 7,34)( 8,41)( 9,44)(12,46)(16,47)(19,48)(22,49)(25,51)
  (29,53)(31,54)(33,56)(37,57)(40,58)(45,60)(52,62),
 ( 3,11)( 4,12)( 5,13)( 6,14)( 7,15)( 8,16),
 ( 2,13)( 5,18)( 8,26)(11,35)(15,41)(17,42)(21,43)(23,45)(25,47)(28,48)
  (29,49)(33,50)(36,52)(38,54)(40,55)(46,56)(53,57),
 ( 1,2)( 5,7)(11,13)(16,17)(19,20)(22,23),
 ( 1,2)( 5,7)(11,13)(17,18)(20,21)(23,24),
 ( 2,13)( 6,30)( 7,33)( 9,37)( 12,41)( 14,43)( 17,44)( 19,47)
  ( 20,49)( 22,53)( 25,57)( 26,58)( 27,62)( 31,65)( 34,69)( 38,72)
  ( 45,77)( 48,78)( 50,82)( 54,85)( 59,89)( 66,93)( 73,97)( 79,101)
  ( 86,105)( 90,107)( 94,109)( 96,110)( 98,112)(102,114)(104,115)(106,116)
  (108,117)(111,118)(113,119),( 3,4)(10,11)(12,13)(15,16)(21,22)(23,24)
  (26,27)(28,29)(30,31)(32,33)(34,35),( 2,12)( 3,18)( 6,28)( 8,36)(10,40)
  (14,41)(17,45)(20,49)(22,50)(25,51)(30,56)(32,57)(34,61)(38,62)(43,64)
  (47,65)(53,67)(59,68),( 2,12)( 3,18)( 6,26)( 8,32)( 9,35)(13,37)(16,40)
  (19,44)(20,47)(23,48)(27,51)(29,52)(33,56)(38,60)(41,62)(46,66)(54,76)
  (64,82)(67,84)(74,85)(77,87),( 2,12)( 3,17)( 5,20)( 8,21)(13,23)(15,26)
  (22,28)(24,30),( 3,4)(10,11)(13,14)(17,18)(20,22)(23,25)(32,34)(36,38)
  (44,45)(46,47)(50,51)(52,53),( 3,4)(10,11)(13,14)(19,20)(22,23)(27,28)
  (29,30)(34,35)(37,38)(41,42)(44,45)(47,48)(50,51)(56,57)(59,60)(62,63)
  (65,66)(67,68)(73,74)(76,77)(78,79)(81,82)(83,84),
 ( 2,12)( 3,15)( 4,18)( 5,22)( 6,23)( 7,26)( 8,30)(14,41)(16,42)(20,44)
  (21,45)(24,47)(28,49)(29,50)(31,52)(35,55)(36,56)(37,58)(38,59)(39,61)
  (40,62)(43,63)(46,64)(48,65)(51,66)(53,67)(54,68)(57,70)(60,72)(69,74)
  (71,75)(73,76),( 2,12)( 3,15)( 4,18)( 6,19)( 7,20)( 8,23)(10,26)(11,27)
  (14,28)(17,29)(22,30)(25,31),( 2,12)( 3,15)( 5,25)( 7,31)( 9,34)(10,37)
  (11,39)(13,42)(14,43)(16,44)(18,47)(20,50)(21,53)(24,54)(26,55)(38,83)
  (41,85)(49,86)(52,88),( 2,12)( 3,15)( 6,22)( 7,31)( 8,32)
  ( 9,35)( 14,39)( 18,43)( 20,46)( 21,48)( 23,50)( 24,51)( 33,71)
  ( 34,72)( 36,73)( 37,74)( 41,77)( 42,78)( 44,79)( 45,81)( 47,82)
  ( 70,101)( 76,103),( 2,12)( 3,14)( 7,17)( 8,20)(10,22)(11,23)(13,25)
  (15,27)(16,29)(18,31)(19,32)(21,33)(24,34)(26,35)(28,36)(30,37),
 ( 1,2)( 5,6)( 8,9)(11,12)(14,15)(16,17)(18,19),
 ( 2, 4)( 6, 8)( 13,15)( 21,22)( 35,36)( 39,40)( 42,44)( 46,48)
  ( 52,53)( 56,57)( 59,61)( 63,65)( 66,68)( 69,71)( 72,74)( 76,78)
  ( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 95,97)( 98,100)(101,103),
 ( 3,11)( 6,13)( 7,14)( 8,16)(15,21)(17,23)(19,25)(22,26)(24,27),
 ( 1,11)( 3,17)( 6,25)( 7,31)(10,35)(14,39)(16,40)(20,43)(23,44)(24,47)
  (27,51)(30,54)(34,56)(37,60)(45,70)(50,74)(53,76)(59,80)(62,82)(69,83)
  (72,85),( 1,7)( 2,9)( 4,12)( 5,14)( 8,17)(11,18)(13,19)(16,20),
 ( 3,11)( 6,12)( 8,17)(10,18)(13,19)(14,20)(15,21)(16,22),
 ( 2,12)( 3,13)( 5,16)( 6,17)( 7,18)( 9,19)(10,22)(11,25)(15,28)(21,31)
  (24,32)(27,33)(30,34),( 3,4)(10,11)(14,15)(19,20)(23,24),
 ( 3,4)(10,11)(14,15),( 2,12)( 4,22)( 6,33)( 7,34)( 10,36)
  ( 13,40)( 16,41)( 20,43)( 23,47)( 25,49)( 26,51)( 30,54)( 35,59)
  ( 38,63)( 45,70)( 48,74)( 52,78)( 53,81)( 58,84)( 61,86)( 62,89)
  ( 66,91)( 69,94)( 75,96)( 90,107)( 99,112)(103,114)(110,117)(111,120)
  (113,123)(116,126),( 1,7)( 2,9)( 4,11)( 5,12)(13,17)(14,18)(15,19)
  (16,20),( 3,4)(10,11)(15,16)(18,19)(23,24)(26,27)(31,32)(34,35)(39,40)
  (41,42)(45,46)(49,50)(52,53)(55,56)(57,58)(60,61)(64,65)(69,70)(72,73)
  (74,75)(78,79)(81,82)(85,86)(88,89)(91,92)(94,95),
 ( 2,12)( 4,17)( 5,21)( 8,29)( 9,48)(11,49)(14,50)(16,53)(19,54)(20,55)
  (24,56)(26,59)(28,60)(35,61)(41,64)(45,67)(52,68)(58,69),
 ( 2,12)( 4,17)( 5,21)( 8,29)( 9,47)(11,48)(14,49)(16,52)(19,53)(20,54)
  (24,55)(26,58)(28,59)(36,62)(45,69)(51,70)(57,71)(63,74)(67,75),
 ( 1,7)( 2,9)( 4,10)( 5,12),( 1,7)( 2,9)( 4,10)( 6,12)(11,15)(13,16)
  (14,17),( 2,4)( 6,8)(14,15)(20,22)(25,26)(28,30)(33,34)(36,38)(40,41)
  (43,45),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(28,29)(33,34)(38,39)(41,42),
 ( 3,10)( 4,12)( 6,13)( 9,15)(11,16),( 3,4)(10,11)(15,16)(20,21)(25,26)
  (32,33),( 2,12)( 4,16)( 6,17)( 7,20)( 9,21)(15,23),
 ( 2,12)( 4,15)( 5,18)( 7,21)( 9,24)(10,27),
 ( 2,12)( 4,15)( 5,18)( 7,20)( 9,21)(14,23),
 ( 2,12)( 4,15)( 6,18)( 7,21)( 9,24)(11,27),
 ( 3,10)( 4,11)( 6,12)( 7,14)( 8,16)( 9,18)(13,20)(15,22)(17,24)(19,25)
  (21,26)(23,27),( 2,12)( 4,14)( 5,17)( 7,19)( 9,20)(13,22),
 ( 3,10)( 4,11)(12,24)(16,26)(18,32)(20,38)(22,44)(27,51)(31,55)(35,59)
  (39,63)(43,67)(47,71)(50,74)(56,77)(58,78)(64,81)(66,82)(72,85),
 ( 1,2)( 3,5)( 6,7)( 9,10)(12,13)(14,16)(17,18)(19,21)(24,25)(27,28)
  (33,34)(36,37)(42,43)(45,46),( 2,24)( 4,25)( 7,26)( 9,27)(12,30)(14,31)
  (17,32)(21,33)(22,36)(28,37)(34,38),( 1,7)( 2,8)( 4,10)( 6,11),
 ( 2,12)( 5,20)( 7,25)( 8,30)( 9,42)(11,44)(13,46)(15,47)(18,48)(21,50)
  (23,52)(26,53)(28,54)(39,70)(45,74)(51,75)(56,76)(60,78)(64,80)(68,82),
 ( 2,12)( 5,20)( 7,24)( 8,29)( 9,51)(11,52)(14,54)(17,55)(19,56)(21,57)
  (23,59)(26,61)(28,62)(33,63)(39,64)(46,65)(53,67)(58,69),
 ( 3,4)(11,13)(16,19)(22,24)(25,28)(29,31)(35,37)(38,41)(42,44)(45,46)
  (48,49)(52,53)(56,57),( 1,11)( 3,12)( 4,13)( 6,14)( 8,15)( 9,16),
 ( 2,12)( 5,17)( 8,27)(13,41)(15,42)(18,43)(21,44)(23,46)(26,48)(28,50)
  (30,51)(32,52)(35,53)(37,55)(39,57)(40,59)(47,60)(56,61),
 ( 1,38)( 4,42)( 6,44)( 8,45)( 9,48)(12,52)(14,56)(17,57)(18,59)(20,60)
  (23,63)(26,64)(29,68)(30,72)(33,73)(35,75)(40,76)(49,77)(51,79)(55,81)
  (62,84)(65,85)(67,87)(71,89),( 2,11)( 3,17)( 5,23)( 7,30)
  ( 9,31)( 12,34)( 13,35)( 16,38)( 18,42)( 19,43)( 21,44)( 22,47)
  ( 25,48)( 33,72)( 39,74)( 40,75)( 46,78)( 49,80)( 50,81)( 51,85)
  ( 73,104)( 79,106),( 3,4)(11,12)(13,14)(15,16)(17,18)(19,20)(23,24)
  (27,28),( 1,7)( 2,8)( 5,9)(15,23)(17,25)(19,26)(24,27),
 ( 3,4)( 6,7)(10,11)(22,23)(26,27)(29,30)(39,40)(46,47)(48,49)(50,51)
  (55,56)(63,64)(65,66)(67,68)(72,73)(75,76)(78,79)(82,83),
 ( 1,7)( 2,8)( 6,11)( 9,12)(10,13),( 3,4)( 6,7)(11,12)(13,14)(18,19)
  (21,22)(27,28)(30,31)(37,38)(41,42)(44,45)(50,51)(52,53)(54,55)(57,58)
  (60,61)(66,67)(69,70)(71,72)(73,74)(77,78)(81,82),
 ( 1, 7)( 3,18)( 5,28)( 10,35)( 14,38)( 15,40)( 17,42)( 20,46)
  ( 24,48)( 27,49)( 30,53)( 33,55)( 36,56)( 37,59)( 41,63)( 44,67)
  ( 51,74)( 54,78)( 62,86)( 68,88)( 71,91)( 75,93)( 76,96)( 79,98)
  ( 83,101)( 92,106)(102,113)(103,116)(110,119)(117,122)(120,125),
 ( 3,4)(11,12)(13,14)(16,17)(18,19)(20,21)(22,23)(24,25)(26,27),
 ( 1,2)( 5,6)( 9,10)(19,20)(26,27)(28,29)(34,35)(39,40)(41,42)(44,45)
  (47,48)(49,50),( 2,11)( 3,14)( 5,19)( 7,21)(13,23)(15,25)(22,27)(24,29),
 ( 1,38)( 4,39)( 7,43)( 9,45)( 15,47)( 17,51)( 20,52)( 23,54)
  ( 25,57)( 26,59)( 29,61)( 32,65)( 36,67)( 40,69)( 42,70)( 44,73)
  ( 48,76)( 49,77)( 53,82)( 55,83)( 58,84)( 60,87)( 66,90)( 68,93)
  ( 71,94)( 78,95)( 80,96)( 85,99)( 91,100)( 97,103)(101,104),
 ( 1,11)( 4,19)( 5,24)( 7,29)( 9,45)(10,48)(14,49)(16,50)(18,51)(21,54)
  (23,55)(26,56)(28,57)(32,61)(41,69)(47,72)(53,73)(68,78)(75,79)(77,80),
 ( 2,11)( 3,13)( 4,16)( 6,17)( 7,19)( 9,23)(10,25)(14,27)(15,29)(20,31)
  (21,33)(24,34)(28,35)(32,36),( 1,11)( 4,19)( 6,23)( 8,27)( 9,43)(12,44)
  (14,45)(15,46)(17,49)(20,50)(24,51)(25,52)(28,55)(31,59)(35,66)(47,73)
  (53,74)(63,79)(71,82),( 2,4)( 7,9)(12,14)(16,18)(21,22),
 ( 3,4)(11,12)(15,17)(20,22)(25,26)(33,35)(38,40)(41,43)(46,48),
 ( 1,11)( 4,15)( 6,18)( 8,19)(10,21)(16,23),
 ( 1,37)( 2,40)( 4,41)( 7,45)( 10,46)( 11,47)( 14,50)( 16,54)
  ( 21,56)( 23,57)( 27,60)( 28,61)( 30,64)( 32,68)( 35,70)( 42,71)
  ( 49,76)( 51,77)( 58,81)( 63,86)( 65,87)( 73,91)( 74,92)( 79,95)
  ( 80,96)( 83,99)( 84,100)( 89,103)( 90,104),
 ( 3,4)(11,12)(15,16)(18,19)(22,23)(26,27)(29,30),
 ( 1,14)( 7,19)( 8,21)(10,23)(12,25)(15,47)(16,48)(20,49)(22,50)(29,51)
  (30,53)(33,55)(35,56)(36,58)(39,60)(42,61)(43,63)(46,65),
 ( 1,7)( 3,12)( 8,23)(13,24)(14,25)(17,26)(20,27),
 ( 3,4)(11,12)(15,16)(19,20)(29,30)(31,32)(35,36)(38,39)(42,43)(45,46)
  (51,52)(53,54)(57,58)(59,60)(70,71)(72,73)(74,75),
 ( 1,9)( 2,12)( 3,17)( 4,20)( 5,26)( 6,30)( 7,33)( 8,37)(11,40)(14,41)
  (16,42)(19,44)(22,46)(23,48)(25,52)(28,53)(34,55)(36,57)(38,61)(45,62)
  (47,63)(49,65)(54,66)(56,67)(58,69),( 3,10)( 6,12)( 7,13)( 8,16)(14,17)
  (15,18),( 2,11)( 3,12)( 4,13)( 5,14)( 6,15)( 8,16),
 ( 1,13)( 2,22)( 3,31)( 4,43)( 6,47)(10,48)(12,49)(14,51)(16,52)(18,56)
  (20,57)(23,58)(26,60)(28,61)(30,62)(32,66)(35,67)(37,68)(40,70)(42,72)
  (44,73)(46,74)(50,76)(53,77)(55,78)(59,80)(63,82)(65,83)(69,85)(71,87)
  (75,88)(79,90)(81,92)(84,93)(86,95)(89,96)(91,97)(94,98),
 ( 1,2)( 3,4)( 5,6)( 7,8)(11,12)(16,17)(20,21),
 ( 1,8)( 2,9)( 4,12)( 5,13)( 6,16)(10,19)(14,22)(17,23)(20,24),
 ( 1,2)(10,11)(12,13)(14,15)(16,17)(18,19)(21,22)(23,24)(28,29)(30,31)
  (32,33)(34,35),( 2,23)( 3,24)( 5,28)( 7,29)( 8,30)(10,32)(12,33)(14,34)
  (15,35)(17,36)(19,40)(20,41)(22,42)(25,43)(27,44)(31,47)(37,50)(39,51)
  (45,54)(48,55)(52,56),( 3, 4)( 11,12)( 17,18)( 26,27)( 30,31)
  ( 40,41)( 44,45)( 46,47)( 50,51)( 54,55)( 56,57)( 60,61)( 63,64)
  ( 65,66)( 69,70)( 71,72)( 75,76)( 80,81)( 86,87)( 91,92)( 94,95)
  ( 97,98)(100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)
  (122,123)(125,126),( 2,4)( 7,9)(13,15)(18,20)(24,25),
 ( 3,4)(11,12)(19,20)(21,22)(25,26)(27,28)(29,30)(31,32)(34,35)(45,46)
  (48,49)(53,54)(56,57)(61,62)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76),
 ( 2,11)( 4,18)( 5,25)( 8,39)(12,44)(15,47)(19,48)(22,49)(26,50)(29,51)
  (32,54)(35,55)(37,56)(40,58)(43,59)(46,60)(53,62),
 ( 3,4)(11,12)(19,20)(24,25)(30,31)(34,35)(38,39)(42,43)(45,46)(48,49)
  (52,53),( 3,4)(11,12)(22,23)(28,29)(30,31)(33,34)(35,36)(38,39)(44,45)
  (46,47)(50,51)(52,53)(59,60)(61,62)(64,65)(68,69)(70,71)(76,77)(78,79)
  (80,81)(83,84)(85,86),( 3,4)(11,12)(22,23)(28,29)(30,31)(34,35)(36,37)
  (39,40)(42,43)(45,46)(49,50)(51,52)(55,56)(57,58)(63,64)(65,66)(69,70),
 ( 3,4)(12,14)(25,27)(29,30)(32,34)(37,38)(41,42)(43,44)(46,47)(48,49)
  (50,52)(54,55)(58,59)(62,63)(64,66)(68,69)(77,78)(79,80)(83,84)(85,86)
  (87,88)(91,92),( 2,11)( 4,17)( 6,24)( 7,28)(12,36)(14,37)(18,40)(22,43)
  (25,47)(26,48)(29,50)(31,52)(34,54)(44,60)(45,63)(51,69)(53,73)(56,76)
  (64,82)(67,84)(74,90),( 1, 2)( 5, 6)( 14,15)( 20,21)( 28,29)
  ( 40,41)( 44,45)( 48,49)( 50,51)( 54,55)( 56,57)( 60,61)( 62,63)
  ( 66,67)( 68,69)( 71,72)( 75,76)( 78,79)( 84,85)( 92,93)( 95,96)
  ( 98,99)(101,102)(104,105)(107,108)(109,110)(112,113)(115,116)(118,119)
  (121,122)(124,125),( 1,7)( 3,10)( 4,12)( 5,23)( 9,25),
 ( 3,4)(12,13)(15,16)(18,19)(20,21)(22,23)(24,25)(26,27)(28,29),
 ( 3,4)(12,13)(15,16)(19,20)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32)
  (33,34)(35,36),( 1,7)( 3,10)( 5,21)( 8,23)(12,25)(15,27)(18,29),
 ( 3,4)(12,13)(16,17)(20,21)(23,24)(27,28)(32,33)(37,38)(41,42)(46,47)
  (49,50)(53,54),( 2,11)( 4,14)( 5,16)( 7,19)( 9,21)(15,23),
 ( 3,9)( 4,11)(13,24)(16,29)(18,35)(20,41)(22,47)(26,50)(30,54)(34,58)
  (38,62)(42,66)(46,70)(53,75)(55,76)(61,79)(63,80)(69,83)(71,84),
 ( 1,2)( 5,6)(16,17)(20,21)(25,26)(28,29)(32,33)(34,35),
 ( 3,4)(12,13)(18,19)(21,23)(25,26)(28,30)(32,33)(37,38)(42,44)(45,46)
  (51,52)(53,54)(58,59),( 3,4)(13,14)(16,17)(20,21)(32,33)(36,37)(39,40)
  (42,43)(45,46)(50,51)(52,53)(54,55)(62,63)(67,68)(69,70)(71,72)(78,79)
  (82,83),( 3, 4)( 13,14)( 16,17)( 24,25)( 37,38)( 41,42)( 44,45)
  ( 47,48)( 51,52)( 53,54)( 57,58)( 59,60)( 61,62)( 63,64)( 65,66)
  ( 67,68)( 70,71)( 72,73)( 75,76)( 89,90)( 91,92)( 94,95)( 96,97)
  ( 99,100)(101,102)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115)
  (116,117)(118,119),( 3,4)(13,14)(17,18)(21,22)(24,25)(26,27)(31,32)
  (36,37)(38,39)(44,45)(47,48)(51,52),( 2,11)( 4,12)( 5,15)( 8,16)(18,21)
  (20,22),( 2,11)( 4,12)( 5,13)( 6,14)( 7,15)( 8,16),
 ( 2,4)( 8,18)(11,25)(12,30)(15,37)(16,40)(19,43)(24,44)(27,47)(32,48)
  (35,51),( 1,10)( 2,17)( 3,28)( 4,37)( 8,40)( 9,42)( 12,43)
  ( 14,45)( 16,47)( 19,50)( 20,51)( 22,54)( 24,55)( 26,56)( 38,75)
  ( 39,76)( 48,81)( 49,82)( 58,87)( 79,102)( 85,103),
 ( 3,4)(13,14)(17,18)(21,22)(24,25)(27,28)(31,32)(36,37)(39,40)(44,45)
  (47,48)(51,52),( 1,10)( 2,17)( 3,23)( 4,30)( 5,37)( 7,41)( 9,42)(11,44)
  (14,45)(16,47)(19,48)(20,50)(22,52)(25,54)(27,55)(29,57)(32,58)(36,60)
  (38,62)(40,64)(43,65)(46,67)(49,68)(51,70)(53,71)(56,72)(59,73)(61,75)
  (63,76)(66,77)(69,79)(74,81)(78,82)(80,83),
 ( 3,4)(13,14)(17,18)(21,22)(25,26)(27,28)(31,32)(37,38)(39,40)(45,46)
  (48,49)(52,53),( 1,2)( 6,10)( 7,12)( 8,14)( 9,16)(11,18)(13,20)(15,22)
  (17,23)(19,24)(21,25),( 3,4)(13,14)(17,18)(28,29)(30,31)(33,34)(36,37)
  (40,41)(42,43)(45,46)(50,51)(52,53)(57,58)(60,61)(63,64)(66,67)(69,70)
  (71,72),( 1,7)( 3,9)( 4,12)( 6,13)( 8,14)(10,16)(15,22)(17,23)(19,24)
  (20,25),( 2,11)( 5,14)( 7,16)( 9,17)(18,22)(19,27),
 ( 2,11)( 5,14)( 7,16)( 9,17)(18,21)(19,27),
 ( 3,4)(14,16)(19,21)(22,24)(27,29)(36,37)(40,42)(45,47)(50,51),
 ( 1,7)( 3,9)( 4,11)( 5,13)( 8,16)(12,19)(15,22)(18,23)(21,24),
 ( 1,10)( 2,16)( 3,21)( 4,24)( 5,30)( 6,31)( 8,34)( 11,38)
  ( 13,41)( 15,45)( 18,46)( 20,49)( 23,52)( 25,55)( 27,57)( 28,60)
  ( 33,61)( 35,64)( 36,65)( 37,68)( 40,69)( 42,72)( 44,75)( 47,77)
  ( 50,78)( 51,81)( 54,82)( 56,85)( 58,89)( 62,91)( 66,94)( 71,95)
  ( 73,98)( 79,101)( 84,102)( 86,105)( 88,107)( 93,109)( 96,111)(100,113)
  (103,115),( 1,31)( 3,32)( 4,34)( 6,36)( 7,37)( 8,38)(10,40)(11,42)(13,43)
  (14,44)(16,47)(18,48)(22,49)(25,50)(29,51)(33,52)(35,53)(39,54)(41,55)
  (45,56)(46,57),( 3, 4)( 14,15)( 18,19)( 26,27)( 37,38)( 39,40)
  ( 42,43)( 44,45)( 49,50)( 51,52)( 54,55)( 59,60)( 61,62)( 63,64)
  ( 65,66)( 67,68)( 69,70)( 71,72)( 82,83)( 90,91)( 93,94)( 95,96)
  ( 98,99)(102,103)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115)
  (116,117)(118,119)(120,121),( 3,4)(16,17)(20,21)(24,25)(28,29)(32,33)
  (34,35)(37,38)(43,44)(45,46)(47,48)(51,52)(53,54)(61,62)(63,64)(68,69)
  (70,71),( 1,2)( 6,8)(12,13)(18,19),( 3,4)(16,17)(23,25)(27,29)(32,33)
  (35,36)(39,40)(42,43)(47,48)(50,51)(53,54)(56,57)(59,60)(62,63)(65,66)
  (67,69)(71,72)(74,75)(76,77)(78,79)(81,82)(83,84)(86,87),
 ( 1,10)( 2,16)( 3,20)( 4,22)( 5,28)( 6,31)( 7,34)( 8,36)(11,41)(13,43)
  (15,45)(19,46)(23,50)(25,51)(27,52)(30,54)(32,56)(37,57)(39,61)(40,62)
  (44,63)(48,64)(55,65)(59,66),( 1,10)( 2,16)( 3,20)( 6,22)( 7,24)(12,28)
  (15,30),( 3,4)(17,18)(21,22)(27,28)(30,31)(34,35)(38,39)(41,42)(44,45)
  (47,48)(52,53)(54,55)(61,62)(63,64)(65,66)(67,68)(69,70)(73,74)(75,76)
  (77,78)(80,81)(82,83),( 1,7)( 3,9)( 5,12)( 6,13)( 8,16)(10,18)(14,20)
  (17,21)(19,22),( 1,7)( 3,9)( 5,12)( 6,13)(10,20)(11,21)(15,22)(16,23)
  (18,24)(19,25),( 4,43)( 7,45)( 12,46)( 17,48)( 19,49)( 22,50)
  ( 25,52)( 30,54)( 31,57)( 32,59)( 33,61)( 35,62)( 36,65)( 37,67)
  ( 39,68)( 40,71)( 41,73)( 42,75)( 44,76)( 56,86)( 58,89)( 60,91)
  ( 64,94)( 66,96)( 70,97)( 72,100)( 74,102)( 78,103)( 81,104)( 83,106)
  ( 84,108)( 85,110)( 87,111)( 90,112)( 92,113)( 95,114)( 98,115)(101,116)
  (105,117)(107,118)(109,119),( 4,42)( 7,43)( 11,46)( 14,47)( 17,48)
  ( 19,49)( 24,52)( 30,54)( 31,56)( 32,57)( 33,60)( 35,61)( 36,63)
  ( 37,64)( 38,67)( 39,69)( 40,70)( 41,73)( 53,80)( 55,88)( 58,90)
  ( 59,91)( 62,94)( 65,96)( 66,97)( 68,100)( 71,102)( 72,103)( 75,105)
  ( 78,106)( 82,107)( 84,108)( 86,109)( 87,110)( 89,112)( 93,114)( 95,116)
  ( 99,118)(101,120),( 4,42)( 8,45)( 11,46)( 14,47)( 16,48)( 21,51)
  ( 26,53)( 29,55)( 30,56)( 31,59)( 33,60)( 34,62)( 35,63)( 36,66)
  ( 37,68)( 38,69)( 39,72)( 41,73)( 52,80)( 54,88)( 57,90)( 58,91)
  ( 61,94)( 64,96)( 65,97)( 67,100)( 70,102)( 71,103)( 75,105)( 78,106)
  ( 82,107)( 84,108)( 86,109)( 87,110)( 89,112)( 93,114)( 95,116)( 99,118)
  (101,120),( 4,42)( 9,44)( 14,47)( 16,48)( 19,49)( 22,50)( 26,53)
  ( 29,54)( 30,57)( 31,58)( 32,60)( 33,63)( 34,64)( 35,66)( 37,67)
  ( 38,70)( 39,71)( 40,73)( 43,74)( 55,88)( 56,89)( 59,91)( 61,94)
  ( 62,95)( 65,97)( 68,100)( 69,101)( 72,103)( 76,105)( 79,106)( 81,107)
  ( 83,108)( 85,109)( 90,111)( 92,113)( 96,115)( 98,117)(102,119)(104,121),
 ( 4,40)( 5,43)( 8,44)( 14,47)( 17,48)( 23,52)( 26,53)( 27,56)
  ( 28,57)( 29,59)( 31,60)( 32,63)( 33,64)( 34,66)( 36,67)( 37,70)
  ( 38,72)( 45,77)( 50,83)( 54,92)( 55,93)( 58,95)( 61,98)( 62,99)
  ( 65,101)( 68,104)( 69,105)( 71,107)( 74,110)( 78,111)( 81,113)( 86,114)
  ( 88,115)( 89,116)( 90,117)( 94,119)( 96,121)(100,123)(102,125)(106,127)
  (108,129),( 1,29)( 3,32)( 4,33)( 6,34)( 7,36)(10,37)(13,38)(16,39)(17,43)
  (18,45)(19,46)(20,47)(21,51)(22,52)(23,53)(24,55)(25,56)(26,57)(27,60)
  (28,61)(40,62)(41,64)(42,66)(49,67)(63,68)(65,69),
 ( 1,29)( 3,32)( 4,33)( 6,34)( 7,36)(10,37)(13,38)(16,39)(17,42)(18,44)
  (19,46)(20,47)(21,49)(22,50)(23,51)(24,52)(25,54)(26,55)(27,57)(28,58)
  (40,61)(41,65)(43,67)(59,69)(60,71)(63,73)(64,75),
 ( 1,29)( 3,30)( 4,33)( 6,34)( 7,35)(10,37)(13,38)(16,40)(17,43)(20,44)
  (21,46)(22,48)(23,49)(26,51)(27,52)(28,54)(31,55)(32,56)(36,57)(39,58)
  (41,59)(42,62)(45,65)(47,67)(50,68)(53,70)(60,71)(61,72)(63,74)(64,75)
  (66,77)(69,78)(73,79)(76,80),( 4,39)( 6,40)( 9,41)(14,42)(18,43)(20,44)
  (24,45)(26,47)(30,48)(33,49)(35,50)(51,60)(52,63)(54,66)(55,69)(56,72)
  (58,75)(59,78)(65,80)(71,82),( 1,10)( 2,15)( 3,22)( 5,24)(11,27)(16,28)
  (20,31),( 1,7)( 3,9)(11,14)(13,15),( 2,10)( 3,11)( 4,15)( 6,16)( 7,17)
  ( 9,18)(12,19)(14,20),( 4,38)( 6,39)( 9,40)(13,42)(16,43)(19,44)(22,46)
  (27,47)(30,48)(33,49)(35,51)(52,60)(53,63)(55,66)(56,69)(57,72)(59,75)
  (64,78)(70,79)(76,80),( 2,10)( 3,11)( 4,14)( 6,15)( 7,16)( 9,18)(13,20)
  (17,21)(19,22),( 2,10)( 3,11)( 4,13)( 6,15)( 7,16)( 9,27)(12,28)(14,29)
  (17,31)(21,33)(24,35),( 2,4)( 9,10)(16,18)(20,22)(24,26)(30,32)(34,35)
  (37,38)(39,40),( 1,13)( 3,15)( 4,16)( 6,18)( 7,20)( 9,22)(10,23)(12,25)
  (14,27)(17,28)(21,29)(24,30),( 1,7)( 3,8)( 4,10)( 6,14)( 9,17)(11,20)
  (13,21)(16,22)(19,23),( 1,7)( 3,8)( 4,10)( 6,12),
 ( 4,38)( 7,40)(10,41)(12,42)(17,43)(19,45)(23,46)(27,47)(30,49)(33,50)
  (36,51)(52,62)(54,65)(55,68)(56,71)(58,74)(59,77)(64,78)(70,79)(76,80),
 ( 1,7)( 3,8)( 4,9)( 6,11),( 4,38)( 7,40)(10,41)(13,42)(18,43)(21,44)
  (24,45)(29,46)(32,48)(34,49)(35,50)(51,61)(52,64)(54,67)(55,70)(56,73)
  (58,76)(60,77)(66,79)(72,81),( 1,7)( 3,8)( 5,11)( 6,12)(10,17)(13,19)
  (15,20)(16,21)(18,22),( 4,38)( 7,39)(10,40)(13,42)(16,43)(19,44)(22,45)
  (28,46)(30,47)(33,48)(36,50)(52,61)(53,64)(54,67)(56,70)(57,73)(58,76)
  (60,77)(66,79)(72,81),( 4,38)( 7,39)(10,40)(15,41)(18,42)(21,43)(26,44)
  (29,46)(31,47)(32,48)(35,49)(51,61)(52,64)(54,67)(55,70)(56,73)(58,76)
  (60,77)(66,79)(72,81),( 1,4)( 6,7)( 9,12)(22,24)(26,27)(33,34)(39,40)
  (49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 2,10)( 4,17)( 6,24)( 7,29)(12,41)(15,42)(19,46)(23,48)(26,51)(28,52)
  (31,53)(34,57)(38,59)(40,62)(44,63)(50,64)(55,65)(61,66),
 ( 1,2)( 6,7)(11,12)(15,16)(28,29)(36,37)(42,43),
 ( 4,38)(10,39)(13,40)(16,41)(19,42)(22,44)(25,45)(28,46)(30,47)(33,49)
  (36,50)(51,59)(52,62)(54,65)(55,68)(56,71)(58,74)(60,78)(66,80)(72,82),
 ( 1,7)( 3,8)( 5,9)(14,20)(16,23)(18,26)(21,27),
 ( 1,10)( 2,14)( 3,21)( 4,24)( 5,29)( 6,34)( 8,38)(11,40)(13,42)(16,45)
  (17,48)(19,51)(22,52)(26,54)(27,56)(31,59)(32,61)(35,64)(37,65)(39,66)
  (43,67)(46,68)(47,69)(49,70)(53,72)(57,73)(60,74)(62,75)(71,77)(76,78),
 ( 4,37)( 6,38)( 9,39)(14,41)(16,42)(18,43)(23,44)(25,46)(29,47)(33,48)
  (49,59)(51,63)(52,67)(53,71)(55,75)(56,79)(57,81)(62,82)(65,83)(70,84)
  (73,85)(78,86),( 2,10)( 4,15)( 6,19)( 7,23)(11,46)(13,47)(16,50)(20,51)
  (21,52)(24,53)(26,56)(29,57)(35,61)(39,63)(44,68)(48,70)(54,71)(62,78)
  (64,79)(69,80),( 1,7)( 4,27)( 6,36)(11,42)(13,43)(15,45)(17,49)(22,51)
  (26,53)(29,54)(31,56)(33,60)(35,61)(41,63)(44,65)(48,66)(50,67)(55,68)
  (59,69)(62,70),( 1,7)( 4,23)( 5,30)(10,38)(11,39)(14,43)(16,44)(19,45)
  (22,49)(24,50)(27,54)(33,58)(37,62)(40,63)(46,68)(48,70)(51,71)(57,76)
  (59,77)(61,79)(67,80)(75,81),( 2,10)( 4,14)( 5,15)( 8,20)(13,22)(18,24),
 ( 1, 7)( 4,18)( 6,23)( 9,32)( 11,36)( 14,37)( 16,41)( 17,44)
  ( 19,45)( 21,46)( 22,47)( 31,68)( 34,69)( 35,70)( 39,74)( 40,75)
  ( 43,76)( 51,79)( 55,81)( 58,88)( 66,93)( 73,98)( 78,100)( 84,118)
  ( 86,119)( 89,122)( 91,123)( 94,124)( 96,127),
 ( 1, 7)( 4,16)( 5,21)( 10,34)( 11,36)( 12,38)( 15,41)( 17,44)
  ( 18,46)( 20,47)( 23,48)( 25,52)( 31,70)( 32,72)( 33,73)( 37,76)
  ( 39,77)( 42,78)( 43,79)( 49,82)( 50,83)( 74,101)( 80,103),
 ( 4,37)( 7,38)( 9,40)(12,41)(15,42)(18,43)(21,45)(24,46)(28,47)(31,49)
  (34,50)(51,61)(52,64)(55,67)(56,70)(57,73)(60,76)(65,79)(71,80)(77,81),
 ( 4,37)( 7,38)(10,39)(13,41)(16,42)(21,43)(23,45)(27,46)(30,47)(32,48)
  (35,50)(52,61)(54,64)(55,67)(57,70)(59,73)(60,76)(63,79)(69,80)(75,81),
 ( 3,8)( 4,10)( 5,21)( 7,22)(11,23)(17,28)(24,29)(26,30),
 ( 2,10)( 4,13)( 5,15)( 7,18)(14,22)(20,24),
 ( 1,7)( 4,13)( 5,18)( 9,21)(14,23)(17,26)(22,28)(24,30),
 ( 4,36)( 6,38)( 9,39)(12,40)(17,41)(20,42)(22,43)(26,44)(28,46)(31,47)
  (48,58)(49,62)(51,66)(52,70)(53,74)(55,78)(57,81)(60,82)(65,84)(68,85)
  (73,87)(76,88),( 4,36)( 6,37)( 8,39)(11,40)(13,41)(21,42)(24,43)(28,44)
  (31,46)(34,47)(48,59)(50,63)(51,67)(52,71)(54,75)(55,79)(60,80)(61,82)
  (68,83)(69,85)(76,86)(77,88),( 1,27)( 2,28)( 3,30)( 5,32)( 6,34)( 7,35)
  ( 8,38)( 9,40)(10,41)(12,43)(13,45)(14,49)(16,51)(19,55)(20,57)(21,61)
  (23,63)(29,67)(36,68)(42,69),( 4,36)( 6,37)( 9,38)(13,40)(20,41)(22,43)
  (27,44)(29,45)(32,46)(33,48)(49,59)(50,63)(52,67)(53,71)(54,75)(56,79)
  (57,81)(58,82)(65,83)(66,84)(73,85)(74,86),
 ( 1,7)( 4,11)( 9,17)(13,19)(14,20)(16,21)(18,22),
 ( 4,36)( 7,38)(10,39)(12,40)(20,41)(23,42)(26,43)(29,45)(32,46)(34,47)
  (48,59)(49,63)(51,67)(52,71)(53,75)(55,79)(56,80)(57,82)(64,83)(65,85)
  (72,86)(73,88),( 1,2)( 6,7)(11,12)(22,23)(25,26)(29,30)(31,32),
 ( 4,36)( 7,38)(10,39)(13,40)(21,41)(23,42)(26,43)(29,45)(31,46)(33,47)
  (49,56)(50,60)(51,64)(53,68)(54,72)(55,76)(58,80)(59,82)(66,83)(67,85)
  (74,86)(75,88),( 4,36)( 7,38)(11,39)(13,40)(16,42)(21,43)(24,44)(27,45)
  (30,46)(33,47)(48,59)(49,63)(50,67)(52,71)(53,75)(54,79)(57,80)(60,81)
  (65,83)(68,84)(73,86)(76,87),( 4,36)( 7,37)(10,38)(12,39)(14,41)(17,42)
  (20,43)(24,44)(29,46)(33,47)(49,60)(50,64)(52,68)(53,72)(54,76)(56,80)
  (61,81)(62,82)(69,83)(70,84)(77,85)(78,86),
 ( 4,36)( 7,37)(10,38)(13,39)(18,40)(21,42)(23,43)(27,44)(30,46)(33,47)
  (49,56)(50,60)(51,64)(53,68)(54,72)(55,76)(59,81)(62,82)(67,84)(70,85)
  (75,87)(78,88),( 2,10)( 4,12)( 6,13)( 9,15)(11,16),
 ( 1,27)( 3,28)( 4,29)( 6,31)( 7,32)(10,33)(13,35)(16,37)(17,42)(19,45)
  (20,46)(21,47)(22,49)(24,52)(25,53)(26,54)(30,57)(34,59)(36,60)(39,62)
  (41,66)(44,70)(48,72)(51,74)(55,76)(56,77)(58,78)(61,79)(64,81)(65,82)
  (68,84)(69,85)(71,86)(73,87)(75,88)(80,89)(83,90),
 ( 4,36)( 7,37)(11,38)(14,39)(21,40)(31,41)(34,42)(43,59)(45,62)(46,63)
  (47,66)(49,67)(50,70)(51,71)(53,74)(54,75)(55,78)(57,79)(58,82)(64,83)
  (65,84)(72,85)(73,86)(80,87)(81,88),( 2,10)( 4,12)( 7,15)( 9,16)(18,23)
  (19,29),( 1,7)( 4,8)( 9,15)(10,17)(12,19)(18,22)(20,24),
 ( 2,10)( 4,12)( 7,14)( 8,16)(13,17)(15,18),
 ( 4,36)( 8,37)(10,39)(14,40)(16,41)(19,43)(24,44)(27,45)(29,46)(33,48)
  (49,60)(51,64)(52,68)(53,72)(55,76)(56,80)(57,81)(62,82)(65,83)(70,84)
  (73,85)(78,86),( 1,7)( 5,11)( 9,12)(10,13),
 ( 1,2)( 6,7)(13,14)(18,19)(25,26)(32,33),
 ( 4,36)( 8,37)(11,38)(18,39)(28,40)(31,41)(33,42)(44,60)(45,61)(46,64)
  (48,65)(49,68)(50,69)(52,72)(53,73)(54,76)(56,77)(57,80)(58,81)(62,83)
  (63,84)(70,85)(71,86)(78,87)(79,88),( 1,10)( 2,12)( 3,17)( 4,19)( 5,24)
  ( 6,28)( 7,31)( 8,33)(14,37)(16,38)(21,42)(22,44)(26,50)(34,55)(35,56)
  (36,57)(40,59)(41,60)(43,61)(45,64)(47,66)(48,68)(49,71)(51,72)(52,73)
  (53,74)(63,78)(65,79)(67,80)(69,83)(75,87)(82,91)(84,92)(85,93)(86,96)
  (88,97)(89,98),( 1,10)( 2,12)( 3,17)( 4,19)( 5,22)( 6,26)( 7,27)( 8,30)
  ( 9,34)(11,38)(15,41)(16,42)(21,46)(24,51)(29,55)(33,57)(37,59)(40,60)
  (43,61)(45,62)(48,66)(50,67)(53,68)(58,70)(63,73)(65,74)(69,78)(75,82)
  (79,83),( 4,35)( 6,38)( 8,41)(10,43)(12,45)(14,47)(16,50)(18,53)(20,55)
  (22,57)(24,59)(26,62)(28,65)(30,67)(32,69),
 ( 1, 7)( 8,30)( 11,31)( 12,32)( 15,35)( 16,38)( 17,40)( 22,46)
  ( 25,50)( 28,57)( 33,66)( 34,67)( 37,70)( 43,74)( 45,77)( 47,87)
  ( 49,90)( 53,94)( 55,97)( 56,98)( 60,103)( 62,104)( 68,108)( 69,109)
  ( 73,111)( 75,113)( 76,114)( 78,115)( 80,119)( 83,123)( 86,128)( 89,131)
  ( 92,135)( 96,139)(101,143)(102,146)(106,156)(110,157)(117,158)(118,161)
  (121,163)(122,166)(125,168)(126,171)(127,173)(130,175)(133,177)(134,178)
  (137,180)(141,182)(142,183)(145,185)(148,187)(174,191)(176,192)(179,193)
  (181,194)(184,195)(186,196),( 1,7)( 8,22)(11,24)(13,25)(14,26)(16,27)
  (17,28)(19,29)(20,30),( 4,35)( 6,37)( 8,40)(10,42)(12,45)(14,47)(16,49)
  (18,52)(20,54)(22,57)(24,59)(26,61)(28,64)(30,66)(32,69),
 ( 4,35)( 6,37)( 8,40)(10,42)(12,44)(14,47)(16,49)(18,52)(20,54)(22,56)
  (24,59)(26,61)(28,64)(30,66)(32,68),(2,3)(4,8)(5,9),
 ( 1,7)( 9,16)(10,18)(11,20)(12,21)(13,23)(14,24)(15,26)(17,30)(27,31)
  (28,33)(29,35)(32,37)(34,38)(36,39),( 1,7)( 9,15)(10,16)(11,18)(12,19)
  (13,20)(14,22),( 2,18)( 3,20)( 6,22)( 7,26)(10,30)(12,32)(13,34)(15,40)
  (23,42)(28,44)(35,46)(38,48),( 1,2)( 6,7)(14,15)(20,21)(24,25)(27,28)
  (31,32),( 2,10)( 4,11)( 7,14)( 8,15),
 ( 4,35)( 7,36)( 10,37)( 15,38)( 17,39)( 20,40)( 26,41)( 29,42)
  ( 43,56)( 45,59)( 46,60)( 48,63)( 51,64)( 53,66)( 55,69)( 61,80)
  ( 65,81)( 70,83)( 71,85)( 72,87)( 75,89)( 76,91)( 77,93)( 82,94)
  ( 84,96)( 86,98)( 88,100)( 90,102)( 92,104)( 97,106)(101,107)(105,108),
 ( 3,8)( 5,10)( 9,16)(11,17)(12,18)(15,20)(19,22)(21,23),
 ( 4,35)( 7,36)( 13,37)( 16,38)( 22,39)( 25,40)( 27,41)( 32,42)
  ( 43,56)( 45,59)( 47,61)( 50,62)( 52,65)( 53,66)( 55,69)( 60,80)
  ( 64,81)( 72,82)( 73,84)( 74,86)( 77,88)( 78,90)( 79,92)( 83,95)
  ( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 94,106)( 98,107)(102,108),
 ( 4,35)( 8,37)(11,38)(14,39)(17,41)(21,42)(24,43)(26,45)(30,46)(32,47)
  (48,61)(49,65)(50,69)(53,73)(54,77)(55,81)(58,82)(63,83)(66,84)(71,85)
  (74,86)(79,87),( 4,35)( 8,36)(10,38)(13,39)(17,40)(20,42)(23,43)(26,44)
  (30,46)(33,47)(50,58)(51,62)(52,66)(55,70)(56,74)(57,78)(60,82)(65,83)
  (68,84)(73,85)(76,86)(81,87),( 4,35)( 8,36)(11,37)(13,38)(21,39)(29,40)
  (32,41)(42,60)(43,63)(45,64)(46,67)(47,68)(50,71)(51,72)(52,75)(54,76)
  (55,79)(56,80)(59,83)(65,84)(66,85)(73,86)(74,87)(81,88)(82,89),
 ( 1,6)( 2,20)( 3,26)( 4,30)( 5,35)( 7,41)( 9,42)(10,43)(12,45)(13,47)
  (15,49)(18,51)(22,52)(23,53)(25,54)(27,56)(29,58)(31,60)(33,62)(37,63)
  (39,65)(44,66)(48,67)(50,69)(55,70)(59,71)(61,73)(64,74)(68,75)(72,76),
 ( 1,2)( 7,10)(11,14)(18,20)(23,24)(26,27)(31,32)(35,36)(40,41)(47,48)
  (53,54)(57,58),( 4,35)( 9,36)(13,38)(19,39)(21,40)(24,42)(28,43)(32,44)
  (46,61)(47,63)(48,65)(50,67)(51,69)(52,71)(54,73)(55,75)(56,77)(58,79)
  (59,81)(60,83)(64,85)(72,86)(80,87),( 1,6)( 2,19)( 3,23)( 4,25)(29,37)
  (30,41)(31,55)(32,59)(33,70)(38,73)(39,74)(44,77)(45,79)(50,82)(51,83)
  (56,86)(57,88)(62,91)(63,92)(68,95),( 2,10)( 5,18)( 6,33)( 7,35)
  ( 11,39)( 13,41)( 14,43)( 15,45)( 19,48)( 20,51)( 21,53)( 22,54)
  ( 24,55)( 25,57)( 36,73)( 37,76)( 38,77)( 46,79)( 47,82)( 49,83)
  ( 52,84)( 74,102)( 80,103),( 1, 6)( 2,18)( 3,21)( 4,24)( 5,32)
  ( 36,45)( 39,57)( 40,58)( 42,61)( 46,63)( 47,66)( 51,68)( 52,69)
  ( 54,71)( 55,80)( 72,89)( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)
  ( 88,102)( 90,103)( 92,106)( 94,107)( 96,110)( 98,111),
 ( 2,10)( 5,13)( 7,15)(11,16)(14,17),( 1,10)( 2,11)( 4,14)( 6,15)( 7,16)
  ( 9,17)(12,19)(18,21)(20,22),( 1, 6)( 2,17)( 3,23)( 7,44)
  ( 9,45)( 12,46)( 15,47)( 20,48)( 24,49)( 27,51)( 30,53)( 32,54)
  ( 40,64)( 50,75)( 52,78)( 57,88)( 59,91)( 61,93)( 63,96)( 67,98)
  ( 69,101)( 70,104)( 73,106)( 74,107)( 80,108)( 83,110)( 86,112)(103,114)
  (105,115),( 4,34)( 6,37)( 8,40)(10,42)(12,44)(14,46)(16,49)(18,52)(20,54)
  (22,56)(24,58)(26,61)(28,64)(30,66)(32,68),
 ( 4,34)( 6,37)( 8,39)(10,42)(12,44)(14,46)(16,49)(18,51)(20,54)(22,56)
  (24,58)(26,61)(28,63)(30,66)(32,68),( 1, 6)( 2,16)( 3,28)( 4,37)
  ( 9,41)( 11,43)( 13,45)( 15,46)( 19,50)( 20,53)( 22,54)( 23,55)
  ( 25,56)( 27,58)( 39,74)( 40,77)( 48,80)( 49,83)( 52,84)( 76,101)
  ( 82,102),( 4,34)( 6,36)( 8,39)(10,41)(12,44)(14,46)(16,48)(18,51)(20,53)
  (22,56)(24,58)(26,60)(28,63)(30,65)(32,68),
 ( 3,8)( 6,12)( 7,13)( 9,14)(10,15)(11,16)(17,19)(18,20),
 ( 3,8)( 6,11)( 7,13)( 9,14)(10,15)(12,16)(17,19)(18,20),
 ( 4,34)( 6,36)( 8,37)(10,38)(13,39)(17,41)(19,42)(22,43)(25,44)(28,45)
  (31,46)(48,65)(50,68)(54,71)(56,74)(58,77)(62,80)(66,81)(72,83)(78,85),
 ( 3,8)( 6,10)( 7,12)( 9,14)(11,16),( 1,24)( 2,25)( 4,26)( 6,29)( 7,32)
  ( 9,33)(11,34)(12,35)(14,38)(16,41)(17,42)(19,43)(20,46)(23,47)(27,48)
  (31,49)(36,50)(40,51)(44,52),( 1,6)( 2,14)( 3,22)( 4,29)( 5,37)( 8,44)
  (10,45)(13,46)(16,48)(18,50)(21,51)(24,52)(26,53)(28,55)(31,57)(33,58)
  (36,59)(38,60)(40,62)(43,64),( 1,6)( 2,14)( 3,21)( 4,29)( 5,37)( 7,44)
  (10,46)(12,47)(15,48)(17,49)(19,51)(22,53)(25,54)(27,55)(30,56)(33,58)
  (35,60)(38,61)(41,62)(43,63),( 4,34)( 6,35)( 9,37)(13,38)(16,39)(19,41)
  (22,42)(24,43)(27,44)(28,46)(30,47)(48,66)(50,69)(53,72)(56,75)(58,78)
  (61,81)(64,82)(70,83)(76,84),( 4,34)( 6,35)( 10,36)( 14,37)
  ( 18,38)( 28,39)( 31,40)( 42,58)( 44,59)( 45,61)( 47,63)( 49,65)
  ( 51,66)( 52,68)( 54,70)( 55,71)( 64,81)( 69,82)( 73,83)( 74,85)
  ( 76,87)( 77,89)( 78,91)( 80,93)( 84,96)( 86,98)( 88,100)( 90,102)
  ( 92,104)( 94,106)( 95,107)( 99,108)(103,109),
 ( 4,34)( 7,36)(10,37)(12,38)(16,39)(19,41)(22,42)(23,43)(25,44)(28,46)
  (30,47)(50,64)(52,67)(54,70)(58,73)(60,76)(62,79)(65,82)(71,83)(77,84),
 ( 4,34)( 7,35)( 9,37)(11,38)(13,39)(16,40)(20,42)(22,43)(25,44)(28,45)
  (31,46)(48,65)(50,68)(54,71)(56,74)(58,77)(62,80)(66,81)(72,83)(78,85),
 ( 1,2)( 7,8)( 9,10)(13,14)(15,16)(21,22)(25,26)(27,28),
 ( 1,6)( 2,13)( 3,27)( 4,30)(34,44)(35,47)(36,59)(37,62)(40,68)(41,70)
  (45,73)(46,74)(50,75)(51,77)(55,80)(56,81)(60,82)(61,84)(65,87)(66,88),
 ( 1,6)( 2,13)( 3,27)( 4,30)(34,43)(35,47)(36,58)(37,62)(39,69)(41,70)
  (44,71)(46,74)(49,76)(51,77)(54,78)(56,81)(59,83)(61,84)(64,85)(66,88),
 ( 2,10)( 6,23)(11,34)(14,35)(15,39)(18,40)(19,45)(22,48)(25,50)(28,52)
  (30,56)(32,59)(33,61)(38,62)(41,65)(43,66)(44,70)(47,71)(51,74)(54,75)
  (55,79)(58,80)(69,84)(78,88)(83,92)(87,94)(91,96)(93,97)(95,98),
 ( 4,34)( 7,35)( 9,36)(16,37)(25,38)(28,39)(31,40)(41,57)(43,61)(44,62)
  (45,66)(47,67)(48,71)(49,72)(51,76)(52,77)(53,81)(55,82)(56,86)(58,87)
  (60,88)(68,89)(70,90)(78,91)(80,92),( 2,10)( 7,14)( 9,15)(11,17)(13,19)
  (16,20)(18,21),( 4,34)( 7,35)( 10,36)( 11,37)( 15,38)( 20,39)
  ( 23,40)( 30,41)( 42,58)( 45,61)( 47,62)( 50,65)( 51,66)( 55,68)
  ( 57,71)( 63,80)( 67,81)( 72,83)( 73,85)( 75,87)( 76,89)( 77,91)
  ( 79,93)( 82,94)( 84,96)( 86,98)( 88,100)( 90,102)( 92,104)( 97,106)
  (101,107)(105,108),( 2, 3)( 4, 5)( 7, 8)( 9,10)( 11,12)( 13,14)
  ( 16,17)( 19,20)( 22,23)( 32,33)( 37,38)( 39,40)( 41,42)( 43,44)
  ( 45,46)( 47,48)( 49,50)( 54,55)( 56,57)( 58,59)( 60,61)( 62,63)
  ( 64,65)( 67,68)( 69,70)( 73,74)( 76,77)( 80,81)( 82,83)( 86,87)
  ( 88,89)( 92,93)( 95,96)( 99,100)(101,102),
 ( 2,3)( 4,5)( 7,8)( 9,10)(12,13)(14,15)(17,18)(20,21)(22,23)(25,26)
  (27,28)(30,31)(39,40)(41,42)(44,45)(47,48)(50,51)(52,53)(55,56)(58,59)
  (61,62)(65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)
  (91,92)(95,96),( 4,34)( 7,35)(10,36)(14,38)(17,39)(20,40)(22,41)(23,43)
  (26,44)(29,45)(32,46)(50,66)(52,69)(55,72)(58,75)(60,78)(63,81)(65,82)
  (71,83)(77,84),( 2,9)( 3,14)( 6,20)(10,21)(13,24)(18,26)(23,27)(25,29),
 ( 4,34)( 7,35)( 11,36)( 15,37)( 19,38)( 24,39)( 27,40)( 31,41)
  ( 43,59)( 44,60)( 48,63)( 51,65)( 52,66)( 55,69)( 57,70)( 64,80)
  ( 68,81)( 72,82)( 73,84)( 74,86)( 76,88)( 77,90)( 78,92)( 83,95)
  ( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 94,106)( 98,107)(102,108),
 ( 2,9)( 3,13)( 5,14)( 7,16)(10,19),( 1,2)( 7,8)(10,11)(17,18)(23,24)
  (26,27)(31,32)(33,34)(38,39)(41,42)(44,45)(46,47)(49,50)(52,53)(56,57)
  (59,60)(62,63)(64,65)(68,69)(72,73)(77,78)(83,84),
 ( 3,7)( 4,9)( 5,21)( 8,22)(11,23)(13,26)(17,29),
 ( 2, 9)( 3,13)( 19,28)( 23,44)( 24,47)( 25,54)( 29,66)( 30,68)
  ( 31,71)( 32,73)( 33,78)( 34,81)( 35,83)( 36,87)( 37,89)( 38,94)
  ( 39,96)( 40,98)( 41,101)( 42,103)( 48,110)( 51,113)( 52,114)( 57,119)
  ( 58,121)( 60,128)( 63,138)( 65,148)( 69,153)( 70,155)( 75,158)( 76,160)
  ( 79,161)( 80,163)( 85,168)( 86,170)( 90,173)( 91,175)( 92,176)( 93,178)
  ( 99,181)(100,183)(104,188)(105,190)(107,191)(108,193)(111,202)(112,203)
  (115,205)(117,207)(118,208)(122,210)(124,213)(125,215)(129,218)(131,220)
  (132,222)(134,225)(135,227)(139,230)(140,232)(141,234)(144,237)(145,239)
  (149,242)(150,244)(151,245)(152,247)(156,248)(157,250)(165,252)(166,254)
  (171,255)(172,257)(179,259)(180,261)(185,263)(186,265)(200,278)(204,279)
  (211,281)(216,283)(223,285)(228,287)(235,289)(240,291),
 ( 1, 6)( 2,12)( 3,18)( 7,38)( 9,40)( 10,44)( 14,45)( 16,48)
  ( 20,52)( 22,56)( 24,57)( 26,58)( 34,83)( 37,84)( 41,85)( 46,86)
  ( 50,87)( 53,88)( 61,96)( 65,98)( 69,100)( 73,102)( 77,104)( 81,106),
 ( 1,6)( 2,12)( 3,18)( 9,24)(13,28)(15,31)(20,33)(27,36),
 ( 1, 6)( 2,12)( 3,15)( 4,20)( 5,26)( 8,31)( 9,34)( 11,36)
  ( 13,39)( 16,42)( 18,45)( 21,46)( 23,50)( 25,53)( 28,57)( 30,60)
  ( 33,61)( 35,65)( 37,68)( 40,69)( 41,72)( 44,73)( 47,75)( 49,78)
  ( 51,81)( 54,82)( 55,85)( 56,86)( 58,89)( 62,90)( 64,92)( 66,95)
  ( 71,96)( 77,99)( 79,102)( 84,103)( 88,106)( 94,108)( 97,110)(101,112)
  (104,114),( 2,9)( 3,12)( 5,15)( 7,16)(10,18),
 ( 3,18)( 4,19)( 6,21)( 8,24)(11,25)(13,26)(15,30)(20,34)(23,36)(29,42)
  (33,45)(38,48)(40,49)(41,50)(43,51)(44,52)(46,53)(47,54),
 ( 2,9)( 3,12)( 5,14)( 8,18)(13,22)(19,24),
 ( 1,3)( 2,15)( 4,21)(11,27)(14,30)(19,33)(22,34)(23,36)(28,41)(35,46)
  (37,47)(39,49)(42,50),( 3,18)( 5,25)( 6,33)( 8,41)( 9,45)(12,47)(15,49)
  (19,50)(22,51)(26,52)(28,54)(30,55)(34,57)(37,58)(42,59)(46,60)(53,61),
 ( 1, 3)( 2,13)( 8,39)( 10,40)( 12,42)( 14,44)( 16,45)( 18,47)
  ( 19,49)( 21,52)( 22,53)( 24,55)( 26,56)( 27,58)( 28,59)( 36,76)
  ( 37,77)( 46,81)( 48,82)( 51,84)( 78,103)( 83,105),
 ( 2,9)( 3,12)( 6,14)( 8,18)(17,24)(20,25)(22,26),
 ( 4,33)( 6,34)( 8,36)(11,37)(13,38)(16,39)(18,41)(22,42)(24,43)(27,45)
  (29,46)(48,66)(50,69)(54,72)(57,75)(59,78)(63,81)(68,83)(74,84)(80,85),
 ( 4,33)( 6,34)( 11,35)( 14,36)( 18,37)( 23,38)( 26,39)( 30,40)
  ( 43,59)( 45,60)( 49,63)( 52,65)( 53,66)( 56,69)( 57,70)( 64,82)
  ( 68,83)( 72,84)( 73,86)( 75,88)( 77,90)( 78,92)( 80,94)( 85,97)
  ( 87,99)( 89,101)( 91,103)( 93,105)( 95,107)( 96,108)(100,109)(104,110),
 ( 1,6)( 2,11)( 3,21)( 9,25)(16,29)(19,31)(23,32)(27,33),
 ( 2,9)( 3,11)( 5,14)( 6,16)( 7,17)(10,18)(12,19)(15,20),
 ( 4,33)( 7,34)( 9,35)(16,36)(23,37)(26,38)(29,39)(40,58)(41,62)(42,63)
  (44,67)(45,68)(46,72)(49,73)(50,77)(51,78)(53,82)(54,83)(55,87)(64,88)
  (66,89)(74,90)(76,91)(84,92)(86,93),( 4,33)( 7,34)( 9,35)(16,36)(23,37)
  (26,38)(29,39)(40,58)(42,62)(43,63)(44,67)(47,68)(48,72)(49,73)(51,77)
  (52,78)(53,82)(56,83)(57,87)(59,88)(61,89)(69,90)(71,91)(79,92)(81,93),
 ( 4,33)( 7,34)(10,36)(12,37)(18,38)(21,40)(28,41)(30,43)(46,62)(47,65)
  (48,66)(50,69)(51,70)(52,73)(55,74)(56,77)(57,78)(59,81)(60,82)(61,85)
  (68,86)(76,87)(84,88),( 4,33)( 7,34)( 10,35)( 11,36)( 15,37)
  ( 19,38)( 22,39)( 29,40)( 41,54)( 43,58)( 44,59)( 46,63)( 47,64)
  ( 49,67)( 51,71)( 60,82)( 65,83)( 72,85)( 75,87)( 76,89)( 77,91)
  ( 80,93)( 81,95)( 84,96)( 86,99)( 88,102)( 90,105)( 92,108)( 94,111)
  (100,114)(106,115)(112,116),( 2,9)( 3,11)( 5,13)(10,16)(12,17),
 ( 4,33)( 7,34)(10,35)(15,36)(25,37)(28,38)(30,39)(40,59)(41,61)(42,64)
  (45,66)(46,69)(47,71)(49,74)(50,76)(51,79)(54,81)(55,84)(56,86)(62,88)
  (63,89)(72,90)(73,91)(82,92)(83,93),( 3,7)( 5,11)(10,14)(12,18)(13,21)
  (17,22)(20,24),( 1,10)( 3,12)( 6,15)( 8,17)(18,23)(19,28),
 ( 1,6)( 2,11)( 3,19)(10,21)(13,25)(18,28)(27,31)(30,35),
 ( 1,6)( 2,11)( 3,18)( 4,22)( 7,24)(10,25)(14,27)(16,28)(20,30),
 ( 2,3)( 4,5)(11,12),( 4,33)( 8,34)(11,35)(13,36)(20,37)(27,38)(30,39)
  (40,58)(41,62)(42,63)(44,67)(45,68)(46,72)(49,73)(50,77)(51,78)(53,82)
  (54,83)(55,87)(64,88)(66,89)(74,90)(76,91)(84,92)(86,93),
 ( 1,10)( 3,11)( 4,13)( 6,14)( 7,15)( 9,16)(12,17),
 ( 3,7)( 5,9)(11,12)(15,30)(19,31)(28,34)(29,38)(33,44)(35,47)(37,50)
  (39,55)(41,57)(46,63)(56,64)(60,68)(62,72)(66,76)(70,79),
 ( 3,4)( 8,9)(15,16)(19,20)(22,23)(26,27)(29,30),
 ( 2,9)( 3,10)( 5,12)( 6,13)( 7,14)( 8,15),
 ( 4,33)( 8,34)( 15,35)( 18,36)( 22,37)( 26,38)( 27,39)( 30,40)
  ( 43,54)( 45,58)( 47,61)( 48,62)( 50,66)( 51,67)( 53,71)( 60,82)
  ( 65,83)( 72,84)( 73,86)( 76,88)( 77,90)( 78,92)( 81,94)( 85,98)
  ( 87,101)( 89,104)( 91,107)( 93,110)( 95,113)( 97,114)(103,115)(109,116),
 ( 1,6)( 2,11)( 3,14)( 4,28)(34,46)(35,49)(36,61)(37,64)(38,68)(42,69)
  (43,70)(47,73)(48,75)(52,76)(53,77)(57,80)(58,82)(62,83)(63,84)(67,87),
 ( 1,6)( 2,11)( 3,14)( 4,28)(34,45)(35,49)(36,60)(37,64)(38,68)(41,70)
  (43,73)(46,74)(48,75)(51,77)(53,80)(56,81)(58,82)(61,84)(63,87)(66,88),
 ( 1,6)( 2,11)( 3,14)( 4,28)(34,43)(35,47)(36,58)(37,62)(39,68)(41,71)
  (44,72)(46,73)(49,75)(51,78)(54,79)(56,80)(59,82)(61,85)(64,86)(66,87),
 ( 4,33)(11,34)(18,35)(20,36)(23,37)(27,38)(30,39)(42,58)(43,62)(44,63)
  (46,67)(47,68)(48,72)(51,73)(52,77)(53,78)(55,82)(56,83)(57,87)(59,88)
  (61,89)(69,90)(71,91)(79,92)(81,93),( 2,9)( 3,10)( 6,13)( 7,15)( 8,17)
  (11,18)(12,19)(14,21)(16,23)(20,25)(22,26)(24,27),
 ( 1,24)( 4,25)( 6,26)( 9,29)(11,30)(14,31)(15,32)(19,34)(22,35)(28,36)
  (33,38),( 1,6)( 2,11)( 3,12)( 4,15)( 7,16)( 9,17)(13,20)(18,23)(21,24),
 ( 4,32)( 6,33)(11,35)(13,37)(15,38)(17,39)(20,41)(22,43)(25,44)(27,45)
  (30,47)(50,63)(54,68)(58,73)(61,84)(66,85)(71,86)(75,87)(77,89)(80,91)
  (81,93)(82,95)(83,97),( 1,2)( 8,10)(11,12)(16,17)(19,21)(22,24)(26,27)
  (31,32)(33,35)(37,39)(40,42)(45,47)(48,50),
 ( 2,9)( 4,20)( 7,21)(11,23)(13,25)(14,27)(16,29)(17,31)(19,33),
 ( 4,32)( 7,33)( 13,34)( 17,35)( 20,36)( 25,37)( 28,38)( 41,59)
  ( 43,62)( 44,63)( 47,65)( 50,66)( 53,69)( 54,70)( 57,72)( 58,74)
  ( 60,83)( 64,84)( 76,86)( 77,88)( 78,90)( 80,92)( 81,94)( 82,96)
  ( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 95,107)(100,109)(104,110)
  (108,111),( 2, 9)( 4,18)( 6,33)( 8,36)( 11,37)( 14,41)( 16,44)
  ( 17,45)( 19,47)( 21,49)( 23,53)( 32,68)( 34,70)( 35,71)( 39,74)
  ( 40,75)( 43,77)( 46,79)( 51,82)( 52,83)( 56,92)( 58,96)( 62,104)
  ( 66,108)( 73,111)( 81,112)(113,128)(115,130)(117,132)(119,134)(121,136)
  (123,138),( 4,32)( 7,33)(14,34)(22,35)(25,36)(29,37)(38,58)(41,61)(42,63)
  (43,66)(45,68)(46,69)(47,72)(48,74)(51,77)(52,79)(53,82)(55,84)(56,85)
  (57,88)(59,90)(60,91)(70,92)(71,93)(80,94)(81,95),
 ( 4,32)( 8,33)(11,34)(16,35)(26,36)(29,37)(38,60)(39,61)(42,65)(43,66)
  (44,70)(45,71)(47,72)(48,76)(49,77)(52,81)(53,82)(54,86)(55,87)(57,88)
  (62,90)(64,91)(73,92)(75,93)(83,94)(85,95),
 ( 1,10)( 4,18)( 6,22)( 8,26)(11,48)(13,49)(14,50)(16,53)(19,54)(23,55)
  (24,56)(27,59)(29,60)(31,62)(37,66)(42,68)(51,71)(57,72),
 ( 2,9)( 4,15)( 6,19)( 7,22)(10,23)(14,25)(17,26),
 ( 4,32)( 10,35)( 16,38)( 19,41)( 20,42)( 25,47)( 26,49)( 27,54)
  ( 28,56)( 29,62)( 30,63)( 31,69)( 40,74)( 46,79)( 48,81)( 51,86)
  ( 52,88)( 53,89)( 55,91)( 58,94)( 59,96)( 60,99)( 61,101)( 65,104)
  ( 66,106)( 67,109)( 68,111)( 70,112)( 73,113)( 77,122)( 78,128)( 82,132)
  ( 83,134)( 84,135)( 85,137)( 92,138)( 93,140)( 97,141)( 98,143)(102,144)
  (103,146)(107,147)(108,149)(114,153)(115,154)(116,156)(117,157)(118,159)
  (119,160)(120,161)(121,163)(123,164)(124,165)(125,167)(126,168)(127,170)
  (129,171)(130,172)(131,174)(150,175)(151,178)(152,181)(176,184)(177,185)
  (179,186)(180,187)(182,188)(183,189),( 4,32)(14,33)(19,34)(22,35)(26,36)
  (29,37)(38,58)(39,62)(40,63)(43,67)(44,68)(45,72)(47,73)(48,74)(49,78)
  (50,79)(53,83)(54,84)(55,88)(57,89)(59,90)(61,91)(69,92)(71,93)(80,94)
  (82,95),( 4,31)( 6,33)( 8,34)(13,36)(15,38)(17,39)(19,40)(22,42)(24,44)
  (27,45)(29,46)(51,63)(55,68)(59,73)(61,84)(66,85)(71,86)(75,87)(77,89)
  (80,91)(81,93)(82,95)(83,97),( 2,9)( 4,14)( 6,19)( 7,23)(11,48)(13,49)
  (16,50)(18,53)(21,54)(22,55)(26,56)(28,59)(30,60)(36,61)(42,64)(46,67)
  (52,68)(58,69),( 2,9)( 4,14)( 6,19)( 7,23)(11,45)(13,46)(16,47)(18,50)
  (21,51)(22,52)(26,53)(28,56)(30,57)(38,66)(43,70)(49,72)(55,73)(59,74)
  (75,79)(77,80),( 4,31)( 7,33)( 9,34)(12,35)(14,37)(17,39)(19,40)(21,41)
  (23,43)(28,45)(30,46)(49,61)(53,66)(57,71)(63,84)(68,85)(73,86)(75,88)
  (76,90)(77,92)(78,94)(81,96)(83,98),( 4,31)( 7,33)( 9,34)( 12,35)
  ( 15,36)( 18,38)( 21,39)( 24,40)( 26,42)( 29,43)( 46,61)( 51,67)
  ( 55,73)( 58,84)( 59,85)( 64,86)( 65,87)( 70,88)( 71,89)( 75,90)
  ( 77,92)( 79,94)( 80,96)( 82,98)( 83,100),
 ( 4,31)( 7,33)( 9,34)( 14,35)( 17,37)( 19,38)( 21,39)( 24,41)
  ( 26,43)( 28,44)( 30,45)( 48,61)( 52,65)( 57,70)( 62,83)( 66,85)
  ( 71,87)( 75,90)( 76,92)( 78,94)( 79,96)( 80,98)( 82,100),
 ( 4,31)( 7,33)( 10,34)( 12,35)( 14,36)( 19,37)( 21,38)( 24,39)
  ( 26,41)( 29,42)( 43,55)( 50,65)( 56,79)( 59,81)( 60,82)( 63,84)
  ( 66,85)( 69,87)( 70,89)( 71,92)( 72,94)( 73,97)( 76,99)( 77,102)
  ( 90,109)( 95,111)(100,113),( 4,31)( 8,35)( 13,40)( 15,41)( 18,45)
  ( 22,49)( 24,55)( 25,60)( 26,61)( 27,71)( 28,82)( 29,84)( 32,85)
  ( 34,87)( 38,88)( 42,89)( 44,91)( 50,101)( 53,102)( 56,103)( 59,104)
  ( 62,106)( 63,107)( 66,108)( 67,109)( 70,110)( 72,111)( 73,112)( 76,113)
  ( 77,115)( 80,116)( 81,117)( 83,118)( 92,120)( 93,121)( 94,123)( 95,125)
  ( 96,126)( 97,128)( 98,130)( 99,131)(100,133)(105,134)(114,135),
 ( 4,31)( 8,32)( 12,33)( 15,34)( 18,35)( 24,36)( 28,37)( 38,52)
  ( 39,55)( 41,58)( 42,59)( 44,64)( 45,65)( 47,68)( 48,69)( 51,74)
  ( 66,83)( 72,84)( 75,85)( 77,88)( 78,91)( 79,94)( 81,97)( 82,100)
  ( 86,105)( 89,108)( 92,111)( 95,114)( 98,117)(101,120)(103,121)(109,122)
  (115,123),( 1,6)( 2,10)( 3,16)( 7,23)(15,29)(19,32)(22,33)(28,35),
 ( 2,9)( 4,13)( 7,14)( 8,17)(10,21)(15,23)(18,25),
 ( 1,10)( 4,12)( 5,15)( 6,17)( 7,19)( 8,21)( 9,24)(20,29)(23,31)(26,33)
  (27,35),( 2,9)( 4,12)( 5,15)( 8,18)(13,21)(17,23),
 ( 2,3)( 5,7)(16,18)(23,24)(26,27)(29,30),
 ( 1, 6)( 2,10)( 3,13)( 4,19)( 5,25)( 9,35)( 11,37)( 14,42)
  ( 16,43)( 21,48)( 22,51)( 24,53)( 27,60)( 29,62)( 31,63)( 32,65)
  ( 34,67)( 36,69)( 38,70)( 39,72)( 40,73)( 45,75)( 46,77)( 50,80)
  ( 52,82)( 54,83)( 55,85)( 56,86)( 59,88)( 61,89)( 64,90)( 66,92)
  ( 68,93)( 71,94)( 74,96)( 76,98)( 79,100)( 81,101)( 84,102)( 87,104)
  ( 91,106)( 95,108)( 99,111)(103,113),( 1,6)( 2,10)( 3,12)( 4,24)( 9,26),
 ( 4,30)( 6,31)( 8,32)( 11,33)( 13,35)( 16,36)( 19,37)( 21,39)
  ( 23,40)( 25,41)( 27,42)( 44,56)( 51,70)( 58,83)( 64,84)( 72,85)
  ( 77,87)( 78,90)( 79,92)( 80,95)( 81,98)( 82,101)( 88,105)( 93,107)
  ( 99,109),( 4,30)( 7,32)( 9,34)( 11,35)( 14,36)( 17,38)( 19,39)
  ( 22,40)( 24,42)( 26,44)( 29,45)( 47,61)( 52,65)( 55,71)( 62,84)
  ( 66,86)( 72,88)( 74,89)( 75,92)( 76,94)( 78,96)( 79,98)( 80,101),
 ( 1,23)( 2,24)( 4,26)( 5,29)( 6,30)( 7,31)( 8,33)(10,36)(11,37)(13,40)
  (14,44)(16,49)(18,53)(19,58)(20,63)(27,65)(28,67)(34,68)(35,70)(38,71)
  (39,73)(47,83)(56,87)(61,91),( 1,6)( 2,10)( 4,13)(11,16)(14,20),
 ( 2,9)( 4,12)( 6,14)( 8,16)(17,24)(19,29),
 ( 4,30)( 7,31)( 12,32)( 13,33)( 20,34)( 23,35)( 29,36)( 37,41)
  ( 39,43)( 44,61)( 45,63)( 47,69)( 48,75)( 49,81)( 51,87)( 52,93)
  ( 53,99)( 55,105)( 56,111)( 57,117)( 59,123)( 60,129)( 65,134)( 66,135)
  ( 68,137)( 77,139)( 78,140)( 80,142)( 89,144)( 90,145)( 92,147)(101,149)
  (102,150)(104,152)(113,154)(114,155)(116,157)(125,159)(126,160)(128,162)
  (136,164)(143,165)(146,166)(153,167)(156,168)(163,169),
 ( 2,9)( 4,12)( 7,16)(10,17)(14,18),( 1,6)( 2,10)( 4,11)( 7,12),
 ( 2,9)( 4,12)( 7,14)(11,16)(13,18),( 4,30)( 10,31)( 13,32)( 20,33)
  ( 21,34)( 26,35)( 29,36)( 38,42)( 40,44)( 41,61)( 45,66)( 46,72)
  ( 48,78)( 49,84)( 50,90)( 52,96)( 53,102)( 54,108)( 56,114)( 57,120)
  ( 58,126)( 60,132)( 67,135)( 69,137)( 70,138)( 79,140)( 81,142)( 82,143)
  ( 91,145)( 93,147)( 94,148)(103,150)(105,152)(106,153)(115,155)(117,157)
  (118,158)(127,160)(129,162)(130,163)(134,164)(141,165)(144,166)(151,167)
  (154,168)(161,169),( 1,6)( 2,10)( 5,11)( 8,12),
 ( 4,29)( 5,31)( 8,32)( 10,33)( 12,34)( 14,36)( 18,37)( 20,38)
  ( 22,40)( 25,41)( 27,42)( 43,58)( 51,72)( 56,81)( 64,82)( 70,83)
  ( 75,85)( 76,88)( 77,91)( 78,94)( 79,96)( 80,99)( 86,106)( 92,108)
  ( 97,110),( 1,23)( 3,27)( 5,28)( 7,29)( 8,31)(10,32)(12,33)(13,34)(15,35)
  (17,39)(18,40)(20,41)(22,42)(24,43)(26,44)(30,47)(36,50)(38,51)(45,54)
  (48,55)(52,56),( 2,9)( 4,11)( 5,12)( 7,14)( 8,15)(10,16)(13,17),
 ( 3,7)( 8,10)(12,15),( 2,9)( 4,11)( 5,12)(10,16)(13,17),
 ( 4,29)( 6,30)( 8,31)( 10,33)( 12,34)( 14,35)( 17,36)( 20,37)
  ( 22,38)( 25,39)( 27,41)( 44,58)( 50,65)( 52,71)( 57,82)( 64,84)
  ( 70,86)( 74,87)( 75,89)( 76,93)( 77,95)( 78,99)( 79,101),
 ( 1, 6)( 2, 9)( 3,13)( 4,20)( 5,26)( 32,37)( 35,57)( 36,59)
  ( 41,61)( 44,65)( 45,66)( 50,69)( 51,70)( 54,78)( 55,87)( 71,89)
  ( 74,92)( 77,95)( 80,98)( 83,101)( 86,104)( 91,109)( 94,111)( 97,115)
  (100,117)(103,121)(106,123),( 3,7)( 9,17)(10,23)(11,28)(12,35)(14,36)
  (20,37)(26,38)(29,39)(34,40)(41,49)(44,55),
 ( 4,29)( 6,30)( 9,31)( 11,33)( 13,34)( 15,35)( 17,36)( 19,38)
  ( 21,39)( 23,40)( 26,41)( 43,56)( 47,64)( 51,72)( 61,85)( 69,87)
  ( 76,89)( 78,91)( 79,93)( 80,96)( 81,98)( 82,101)( 83,103),
 ( 1,6)( 2,9)( 3,12)( 4,15)( 8,16)(10,18)(14,19),
 ( 3,7)( 9,16)(10,19)(11,26)(12,29)(13,36)(21,37)(27,38)(28,39)(35,40)
  (41,49)(44,55),( 4,29)( 7,30)( 9,31)( 11,32)( 14,33)( 17,34)
  ( 23,35)( 26,36)( 38,61)( 42,62)( 44,65)( 48,67)( 51,68)( 57,71)
  ( 59,72)( 66,87)( 70,88)( 75,89)( 78,91)( 79,93)( 81,95)( 84,97)
  ( 85,99)( 90,104)( 92,106)( 94,108)( 96,110)( 98,112)(100,114)(103,115)
  (107,116)(111,117),( 1,2)( 8,9)(13,14)(18,19)(25,26)(31,32),
 ( 4,29)( 7,30)( 9,31)( 13,32)( 16,33)( 19,34)( 23,35)( 26,36)
  ( 38,61)( 43,62)( 47,65)( 51,67)( 53,68)( 56,71)( 59,72)( 66,87)
  ( 70,88)( 74,89)( 75,91)( 78,93)( 81,95)( 82,97)( 84,99)( 90,104)
  ( 92,106)( 94,108)( 96,110)( 98,112)(100,114)(103,115)(107,116)(111,117),
 ( 4,29)( 7,30)( 9,31)( 15,32)( 18,33)( 23,34)( 26,35)( 38,60)
  ( 40,61)( 44,62)( 48,65)( 51,67)( 52,68)( 53,70)( 57,72)( 58,73)
  ( 66,88)( 71,89)( 75,90)( 76,92)( 80,94)( 82,96)( 83,98)( 86,100)
  ( 91,105)( 93,107)( 95,109)( 97,111)( 99,113)(101,115)(104,116)(108,117)
  (112,118),( 4,29)( 7,30)( 11,31)( 16,32)( 21,33)( 23,34)( 26,35)
  ( 36,61)( 41,64)( 43,65)( 46,67)( 51,70)( 54,71)( 57,72)( 60,75)
  ( 62,88)( 66,89)( 78,91)( 79,93)( 80,95)( 83,97)( 85,98)( 86,100)
  ( 87,102)( 90,107)( 92,109)( 94,111)( 96,113)( 99,115)(101,117)(104,119)
  (106,120)(110,121)(114,122)(118,123),( 2,9)( 4,11)( 6,12)( 7,15)(13,19)
  (14,21),( 4,29)( 7,30)( 12,31)( 15,32)( 21,33)( 24,34)( 26,35)
  ( 37,59)( 39,60)( 42,61)( 45,64)( 49,65)( 53,68)( 56,69)( 67,85)
  ( 71,86)( 72,88)( 74,91)( 75,92)( 78,93)( 79,95)( 80,97)( 81,99)
  ( 84,100)( 87,107)( 89,109)( 90,110)( 94,112)( 96,114)( 98,116)(101,118)
  (103,120)(105,122)(106,123)(111,124)(115,125)(119,126)(121,127),
 ( 4,29)( 7,30)( 14,31)( 21,32)( 24,33)( 27,34)( 38,59)( 39,62)
  ( 41,63)( 42,66)( 43,67)( 46,68)( 47,71)( 51,72)( 52,75)( 53,76)
  ( 54,79)( 56,80)( 57,83)( 60,91)( 61,92)( 69,93)( 70,94)( 77,95)
  ( 78,96)( 86,100)( 89,104),( 4,29)( 8,32)( 13,36)( 15,39)( 18,42)
  ( 22,46)( 24,50)( 25,54)( 26,57)( 27,66)( 28,76)( 33,81)( 37,83)
  ( 43,84)( 47,86)( 48,87)( 51,94)( 52,96)( 56,97)( 58,100)( 61,101)
  ( 62,103)( 65,104)( 67,106)( 70,107)( 71,110)( 74,111)( 75,112)( 77,115)
  ( 80,116)( 82,117)( 85,118)( 88,120)( 89,122)( 90,125)( 91,127)( 92,130)
  ( 93,132)( 98,134)(108,136)(113,138)(119,139)(121,140)(123,141)(124,142)
  (126,143)(128,144)(129,145)(131,146)(133,147)(135,148)(137,149),
 ( 4,29)( 8,30)( 9,31)( 15,32)( 18,33)( 26,34)( 27,35)( 37,59)
  ( 40,62)( 41,63)( 43,66)( 47,67)( 52,69)( 53,70)( 55,73)( 64,85)
  ( 68,86)( 76,88)( 77,90)( 78,92)( 79,95)( 81,97)( 83,100)( 84,102)
  ( 89,108)( 91,110)( 94,112)( 96,114)( 99,116)(101,118)(105,122)(107,126)
  (111,128)(115,129)(119,130),( 1, 9)( 2,20)( 4,48)( 8,51)( 12,52)
  ( 15,53)( 22,55)( 24,56)( 27,57)( 29,59)( 31,60)( 34,64)( 36,65)
  ( 40,69)( 42,70)( 46,74)( 49,76)( 50,78)( 61,88)( 62,90)( 66,92)
  ( 67,94)( 71,96)( 72,98)( 79,99)( 80,100)( 83,102)(101,104)(103,105),
 ( 2,9)( 4,11)( 7,14)(10,16)(13,17),( 2,9)( 4,11)( 7,13)( 8,16)(14,17)
  (15,18),( 2,9)( 4,11)( 7,13)( 8,15),( 1,2)( 8,9)(19,20)(22,23)(26,27)
  (29,30)(34,35)(38,39)(40,41)(43,44)(46,47)(48,49)(53,54)(56,57)(58,59)
  (61,62)(63,64)(66,67)(68,69)(72,73)(77,78)(79,80)(81,82)(85,86)(87,88),
 ( 4,29)( 9,36)( 11,39)( 14,40)( 18,45)( 20,49)( 24,51)( 25,56)
  ( 26,66)( 27,75)( 28,80)( 30,81)( 32,82)( 37,84)( 41,85)( 43,86)
  ( 47,88)( 52,95)( 55,97)( 57,98)( 60,100)( 61,102)( 62,104)( 65,106)
  ( 67,107)( 70,109)( 71,110)( 74,112)( 76,114)( 79,116)( 89,118)( 90,120)
  ( 91,123)( 92,125)( 93,128)( 94,130)( 96,132)( 99,133)(103,135)(105,136)
  (108,137)(111,138)(113,140)(115,141)(117,142)(121,143)(122,144)(126,145)
  (127,146)(131,147),( 4,29)( 9,34)( 11,36)( 14,39)( 18,42)( 20,45)
  ( 24,48)( 25,52)( 26,62)( 27,71)( 28,78)( 31,79)( 35,81)( 37,82)
  ( 41,84)( 46,85)( 49,94)( 50,95)( 54,97)( 55,98)( 58,100)( 59,101)
  ( 60,103)( 64,105)( 65,106)( 68,108)( 69,109)( 73,111)( 74,113)( 77,115)
  ( 83,117)( 86,119)( 87,120)( 88,122)( 89,125)( 90,127)( 91,130)( 92,132)
  (102,135)(112,136)(121,137)(123,140)(124,141)(126,143)(128,146)(129,147)
  (131,149)(133,152)(134,153)(138,156)(142,158)(144,160)(148,162)(150,164)
  (154,166),( 2,9)( 4,11)( 8,16)(10,17)(12,18)(14,21)(19,22)(20,23),
 ( 4,29)( 9,30)(17,31)(18,32)(21,33)(25,34)(35,62)(36,65)(38,66)(40,69)
  (41,70)(43,72)(45,74)(47,75)(49,78)(51,79)(55,82)(56,83)(58,85)(60,87)
  (63,94)(64,95)(71,96)(73,97)(80,98)(81,99),( 2,9)( 4,10)( 5,12)( 6,13),
 ( 1,9)( 2,17)( 3,24)( 4,32)( 5,40)( 6,44)( 8,46)(11,48)(13,49)(16,50)
  (18,51)(20,53)(23,55)(26,56)(28,57)(31,58)(34,60)(36,62)(39,63)(42,64),
 ( 2,9)( 4,10)( 5,12)(11,16)(13,17),( 2,9)( 4,10)( 5,12)(11,15)(13,16),
 ( 4,28)( 6,29)( 8,31)( 11,33)( 13,34)( 16,36)( 23,38)( 25,40)
  ( 45,60)( 46,62)( 52,66)( 53,68)( 55,72)( 56,74)( 59,91)( 65,92)
  ( 71,93)( 76,94)( 77,96)( 78,97)( 79,99)( 80,100)( 81,102)( 83,103)
  ( 84,105)( 86,106)( 87,108)( 88,109)( 89,111),
 ( 1, 9)( 2,16)( 3,27)( 7,38)( 8,40)( 11,41)( 13,43)( 15,45)
  ( 18,48)( 19,49)( 21,52)( 23,53)( 25,54)( 28,58)( 36,75)( 37,76)
  ( 46,81)( 47,82)( 56,87)( 79,102)( 85,103),
 ( 4,28)( 7,29)( 10,30)( 18,31)( 23,32)( 26,33)( 35,59)( 36,62)
  ( 37,63)( 38,66)( 40,67)( 43,70)( 47,71)( 48,74)( 50,75)( 51,78)
  ( 52,79)( 55,82)( 64,89)( 65,90)( 72,91)( 73,92)( 80,93)( 81,94)
  ( 95,107)( 97,108)( 99,109)(101,110)(103,111)(105,112),
 ( 2,9)( 4,10)( 6,12)( 7,13),( 4,28)( 7,29)( 15,30)( 19,31)( 22,32)
  ( 24,33)( 34,60)( 35,61)( 37,62)( 38,65)( 41,66)( 42,69)( 46,70)
  ( 47,73)( 48,74)( 49,77)( 52,78)( 55,81)( 58,82)( 63,92)( 64,93)
  ( 71,94)( 72,95)( 79,96)( 80,97)( 89,103)(105,109)(107,110),
 ( 4,28)( 7,29)( 15,30)( 19,31)( 22,32)( 24,33)( 34,59)( 36,60)
  ( 37,63)( 40,64)( 41,67)( 45,68)( 46,71)( 47,72)( 48,75)( 51,76)
  ( 54,79)( 57,80)( 58,83)( 61,92)( 62,93)( 69,94)( 70,95)( 77,96)
  ( 78,97)( 89,102)(105,109)(107,110),( 2,3)( 5,6)(10,11)(14,15)(18,19)
  (22,23),( 1,2)( 9,10)(11,13)(15,17)(18,20)(23,25)(26,28)(30,32)(33,34)
  (38,39)(41,43)(44,46)(48,49),( 1,2)( 9,10)(11,12)(15,17)(18,19),
 ( 1,23)( 3,24)( 4,25)( 6,26)( 8,29)( 9,31)(11,32)(13,33)(14,34)(16,37)
  (18,39)(20,40)(22,42)(27,44)(28,45)(35,47)(36,48)(41,50)(46,52)(49,53)
  (51,54),( 4,28)( 12,29)( 13,30)( 17,31)( 21,32)( 22,33)( 27,34)
  ( 39,63)( 41,66)( 43,68)( 44,69)( 49,70)( 55,73)( 56,74)( 58,77)
  ( 59,78)( 67,87)( 72,88)( 80,89)( 81,91)( 82,93)( 84,95)( 85,97)
  ( 86,99)( 90,102)( 92,104)( 94,106)( 96,108)( 98,110)(100,112)(101,113)
  (105,114)(109,115),( 3,6)( 4,7)(10,29)(12,33)(26,34)(31,35)(32,43)
  (36,52)(38,54)(42,56)(44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 1,6)( 2,8)( 5,10)( 9,14)(11,16)(12,17)(13,18)(15,19),
 ( 3,6)( 5,21)( 7,24)(10,27)(12,29)(14,32)(16,34)(18,35)(20,36)(25,38)
  (30,40),( 4,27)( 6,29)( 9,30)( 11,31)( 16,32)( 18,33)( 20,34)
  ( 22,36)( 24,37)( 25,38)( 40,51)( 48,68)( 53,83)( 54,85)( 60,86)
  ( 61,88)( 70,89)( 71,91)( 77,93)( 78,96)( 79,98)( 80,101)( 81,104)
  ( 82,107)( 94,112)( 99,115)(105,118),( 1,6)( 2,8)(10,15)(17,33)(27,38)
  (29,44)(31,50)(39,51)(41,53)(43,55)(45,57)(47,59)(49,61)(54,64)(58,66)
  (62,68),( 1, 6)( 2, 8)( 11,25)( 21,45)( 24,58)( 26,60)( 29,64)
  ( 30,80)( 31,81)( 32,83)( 33,84)( 34,86)( 36,89)( 37,91)( 38,92)
  ( 40,94)( 41,95)( 42,97)( 43,99)( 46,102)( 47,104)( 49,105)( 50,107)
  ( 51,108)( 52,110)( 53,113)( 54,115)( 61,118)( 65,120)( 67,122)( 68,123)
  ( 70,127)( 72,132)( 73,136)( 75,142)( 76,146)( 78,151)( 87,157)( 88,159)
  (100,165)(101,167)(111,173)(112,175)(116,181)(119,184)(121,185)(125,189)
  (129,192)(130,194)(134,197)(139,200)(140,202)(144,205)(148,208)(149,210)
  (153,211)(154,213)(155,214)(156,216)(160,217)(161,219)(163,220)(164,222)
  (168,224)(170,226)(171,227)(172,229)(180,245)(183,246)(187,248)(190,250)
  (195,252)(198,254)(203,256)(206,258),( 1,6)( 2,8)(12,26)(22,29)(23,37)
  (24,47)(30,50)(32,52)(36,55)(40,57)(42,59)(46,61)(53,80)(58,81)(62,82)
  (65,84)(67,86)(70,88)(73,90)(75,92)(78,94),
 ( 1,23)( 3,24)( 5,26)( 6,29)( 8,30)(10,31)(11,32)(12,34)(14,37)(15,38)
  (17,39)(18,40)(20,43)(22,44)(28,45)(36,47)(42,49),
 ( 4,27)( 6,28)( 9,29)( 12,31)( 16,32)( 18,34)( 20,36)( 23,37)
  ( 25,39)( 47,81)( 48,82)( 52,83)( 55,85)( 56,86)( 60,87)( 64,89)
  ( 65,90)( 69,91)( 71,92)( 72,96)( 73,100)( 74,102)( 75,106)( 76,110)
  ( 77,112)( 78,116)( 79,120)(122,134)(124,136)(126,138)(127,140)(129,142)
  (130,144),( 4,27)( 7,29)( 9,30)( 11,31)( 14,32)( 16,34)( 18,35)
  ( 21,36)( 23,38)( 25,39)( 42,57)( 48,67)( 50,76)( 54,86)( 55,87)
  ( 62,88)( 65,89)( 71,90)( 74,91)( 79,92)( 80,94)( 81,97)( 82,99)
  ( 83,102)( 84,104),( 4,27)( 7,28)( 9,29)( 11,31)( 15,32)( 18,34)
  ( 22,35)( 24,36)( 38,53)( 40,55)( 43,60)( 44,62)( 46,66)( 47,68)
  ( 52,85)( 59,86)( 65,87)( 70,88)( 71,90)( 72,91)( 73,93)( 76,97)
  ( 77,99)( 78,100)( 79,102)( 80,106)( 81,108)( 82,109)( 83,111),
 ( 4,27)( 8,31)( 9,35)( 10,37)( 17,45)( 22,54)( 23,58)( 24,60)
  ( 25,67)( 28,68)( 32,70)( 36,73)( 38,74)( 41,77)( 46,80)( 47,84)
  ( 48,85)( 50,86)( 51,90)( 52,91)( 55,97)( 57,98)( 59,102)( 61,106)
  ( 62,107)( 65,110)( 66,114)( 71,117)( 75,118)( 78,119)( 81,120)( 82,127)
  ( 88,146)( 92,147)( 93,148)( 95,149)(100,150)(104,151)(108,152)(109,153)
  (112,154)(116,155)(121,162)(123,164)(125,166)(128,168)(130,170)(132,172)
  (134,174)(136,176)(138,178)(140,180)(142,182)(144,184)(156,186)(157,187)
  (158,188)(159,189)(160,190)(161,191)(163,192)(165,193)(167,194)(169,195)
  (171,196)(173,197)(175,198)(177,199)(179,200)(181,201)(183,202)(185,203),
 ( 1,2)( 9,10)(13,14)(15,17)(18,20)(21,22)(25,26)(27,29)(30,32)(33,34)
  (36,38)(45,46)(47,49)(57,58)(59,61)(65,67)(73,74)(79,80)(83,84),
 (1,6)(2,7)(5,8),( 1,6)( 2,7)(10,26)(23,33)(29,34)(31,35)(32,43)(36,52)
  (38,54)(42,56)(44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 1,6)( 2,7)(10,18)(15,33)(21,34)(31,42)(32,50)(35,51)(39,53)(41,55)
  (43,57)(47,59)(49,61)(54,63)(58,64)(62,65),
 ( 2,9)( 5,11)( 7,13)(10,14)(12,15),( 1,6)( 3,16)( 5,28)( 8,36)(10,37)
  (12,41)(14,42)(15,44)(18,46)(20,47)(21,48)(27,52)(29,54)(31,57)(34,58)
  (40,64)(43,70)(50,78)(56,84),( 2,9)( 5,11)( 7,12)( 8,13)(10,15),
 ( 1,3)( 4,6)(10,12)(14,16),( 1,9)( 2,14)( 3,22)( 5,25)(11,26)(16,28)
  (21,29),( 2,9)( 5,10)( 6,13)( 8,14),( 3,6)( 7,10)(11,14)(17,21)(22,24)
  (27,29)(30,32)(35,37),( 1,23)( 3,24)( 6,28)( 9,29)(10,30)(13,31)(15,35)
  (18,36)(20,37)(25,38)(32,39),( 3,6)( 7,10)(11,12)(13,16)(17,20),
 ( 4,25)( 6,26)( 10,27)( 13,28)( 18,29)( 20,30)( 23,31)( 34,47)
  ( 38,52)( 41,56)( 43,59)( 45,65)( 48,73)( 50,74)( 55,75)( 62,76)
  ( 66,81)( 67,83)( 69,88)( 70,93)( 71,98)( 72,100)( 80,106)( 82,110)
  ( 84,112)( 87,114)( 92,117)( 94,119)( 97,121)( 99,124)(101,126)(111,146)
  (118,147)(125,148)(128,149)(131,154)(134,162)(137,167)(140,175)(143,180)
  (150,188)(155,189)(163,191)(168,192)(176,194)(181,195),
 ( 4,25)( 6,26)( 11,27)( 14,28)( 18,29)( 20,30)( 22,31)( 33,48)
  ( 34,51)( 37,55)( 39,59)( 40,60)( 44,66)( 45,67)( 58,77)( 65,78)
  ( 70,82)( 71,84)( 72,92)( 73,97)( 75,102)( 76,107)( 80,114)( 83,116)
  ( 85,118)( 90,119)( 93,121)( 95,123)( 98,125)(103,127)(105,129)(108,131)
  (115,150)(120,151)(126,152)(155,176)(158,177)(162,179)(166,180)(169,182)
  (173,183),( 1,6)( 3,11)( 7,23)(12,24)(14,25)(17,26)(20,27),
 ( 1,6)( 3,11)( 7,23)(12,24)(15,25)(18,26)(21,27),
 ( 3,6)( 7,9)( 8,12)(10,13)(11,14),( 2, 9)( 6,34)( 8,36)( 11,37)
  ( 14,41)( 15,42)( 16,43)( 19,46)( 20,48)( 22,50)( 24,54)( 25,55)
  ( 26,56)( 33,83)( 35,84)( 39,86)( 40,87)( 45,88)( 47,89)( 52,91)
  ( 53,92)( 57,99)( 61,101)( 65,102)( 70,104)( 74,106)( 78,107),
 ( 1,2)( 9,10)(14,15)(18,19)(21,22)(26,27)(29,30),
 ( 1,23)( 4,27)( 7,28)( 8,29)(11,30)(13,34)(16,35)(18,36)(21,37)(24,38)
  (31,39),( 1,2)( 9,10)(14,15)(18,19)(23,24),
 ( 1,7)( 2,8)( 4,10)( 5,11),( 2,12)( 5,29)( 6,32)( 8,35)( 10,37)
  ( 11,39)( 14,42)( 17,46)( 19,48)( 20,51)( 23,55)( 28,58)( 34,64)
  ( 41,68)( 44,70)( 45,72)( 47,75)( 50,80)( 54,82)( 56,84)( 57,86)
  ( 59,89)( 63,91)( 74,96)( 79,98)( 88,103),
 ( 2,9)( 7,13)( 8,15)(10,16)(11,17)(12,18)(14,19),
 ( 1,9)( 2,13)( 3,22)( 4,28)( 5,34)( 6,39)( 8,41)(11,42)(14,44)(16,46)
  (17,48)(19,49)(21,52)(25,53)(27,54)(30,56)(33,58)(35,61)(37,62)(40,63)
  (43,64)(47,66)(50,67)(51,69)(55,70)(59,71)(60,73)(65,74)(68,76)(72,78)
  (75,79)(77,80),( 1,2)( 9,10)(14,15)(19,20)(24,25)(31,32),
 ( 1,3)( 4,5)(10,12)(17,18)(20,21),( 4,24)( 12,25)( 16,26)( 19,27)
  ( 21,28)( 29,50)( 30,53)( 31,55)( 33,58)( 34,59)( 35,62)( 39,64)
  ( 40,67)( 42,68)( 43,69)( 44,72)( 45,74)( 46,77)( 56,89)( 57,90)
  ( 65,91)( 66,92)( 75,93)( 76,94)( 82,98)( 86,108)( 96,117)(100,121)
  (103,122)(106,126)(112,127)(115,131),( 2,9)(10,14)(11,17)(12,28)(13,31)
  (19,42)(21,43)(29,44)(30,45)(38,46)(40,47),
 ( 2,8)( 3,15)( 6,27)(10,37)(13,38)(14,41)(17,44)(20,45)(24,47)(29,49)
  (31,52)(33,55)(35,59)(40,64)(43,68)(51,73)(54,77)(57,78)(62,82)(66,83)
  (71,87)(75,88)(80,92)(85,93)(90,94),( 1,6)( 3,9)( 4,10),
 ( 1,6)( 3,9)( 5,11)( 8,13)(10,14)(12,15),( 2,8)( 3,11)( 4,13)( 7,16),
 ( 3,6)( 8,12)(13,17)(19,22)(24,28),( 2,8)( 3,11)( 4,12)( 6,15)( 7,16)
  (10,17)(14,18),( 2,11)( 3,15)( 5,19)( 8,23)(13,24)(16,26)(21,27),
 ( 1,6)( 3,9)( 7,10),( 2,8)( 3,10)( 4,13)( 5,22)( 9,23),
 ( 4,22)( 6,23)( 8,24)(10,25)(11,26)(14,29)(15,30)(18,31)(20,32)(27,34)
  (33,35),( 4,22)( 6,23)( 9,24)(10,25)(13,28)(14,29)(16,30)(18,31)(20,32)
  (21,34)(27,35),( 2,8)( 3,10)( 4,12)( 5,13)( 6,15)( 7,17),
 ( 4,22)( 7,24)( 9,26)(12,28)(14,31)(17,32)(18,33)(20,34)(21,36)(25,37)
  (27,39)(30,40)(35,41)(38,42),( 1,9)( 2,13)( 4,17)( 6,22)(10,48)(14,50)
  (15,51)(18,52)(20,53)(23,56)(25,57)(26,58)(28,59)(34,62)(40,65)(46,68)
  (49,70)(54,72),( 4,22)( 8,30)( 9,34)( 10,35)( 13,39)( 15,43)
  ( 16,45)( 18,48)( 21,49)( 23,51)( 26,55)( 28,59)( 29,62)( 33,63)
  ( 38,67)( 42,70)( 44,74)( 47,75)( 54,80)( 58,83)( 61,87)( 66,90)
  ( 73,94)( 79,98)( 86,102)( 91,106)( 93,107)( 97,109)( 99,111)(101,112)
  (105,114)(108,116)(110,117)(113,118)(115,119),
 ( 4,22)( 10,23)( 13,24)( 16,25)( 26,48)( 28,49)( 29,51)( 30,52)
  ( 32,53)( 36,56)( 38,58)( 39,60)( 40,62)( 41,63)( 43,66)( 46,67)
  ( 54,82)( 69,88)( 71,93)( 72,95)( 75,100)( 76,104)( 78,109)( 79,112)
  ( 81,116)( 83,121)( 87,123)( 89,125)( 94,128)( 96,130)( 99,132)(101,134)
  (103,136)(105,138)(111,140)(113,142)(115,144)(126,156)(129,157)(135,158)
  (137,159)(143,160)(145,161),( 4,22)( 10,23)( 13,24)( 16,25)( 26,48)
  ( 29,49)( 31,52)( 32,53)( 33,55)( 34,57)( 36,59)( 40,62)( 42,63)
  ( 43,64)( 44,66)( 46,67)( 61,82)( 68,83)( 70,87)( 71,90)( 73,95)
  ( 74,99)( 77,104)( 78,106)( 80,111)( 84,122)( 86,124)( 88,126)( 94,128)
  ( 96,130)( 98,132)(100,134)(103,136)(105,138)(110,141)(112,143)(116,145)
  (121,156)(123,157)(129,158)(131,159)(137,160)(140,161),
 ( 2,3)( 6,7)( 9,10)(13,14)(19,20)(24,25)(27,28)(30,31),
 ( 4,22)( 12,28)( 20,29)( 27,43)( 30,49)( 33,52)( 34,53)( 36,55)
  ( 39,58)( 40,59)( 42,61)( 44,63)( 46,65)( 48,74)( 50,81)( 64,82)
  ( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)( 80,98)( 83,100)
  ( 84,106)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)( 96,122)( 97,123)
  ( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)(116,137)(120,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,151)(141,153)
  (143,155)(145,157)(147,159)(149,161)(152,163)(156,164)(160,165),
 ( 2,8)( 3,10)( 6,14)( 9,17)(13,19),( 1,37)( 3,40)( 5,42)( 7,45)( 8,46)
  (10,50)(12,53)(15,55)(16,58)(20,60)(21,62)(24,65)(27,66)(28,69)(31,71)
  (33,74)(36,76)(49,77)(51,78)(56,81)(67,85)(72,88)(84,92)(91,93),
 ( 1,2)(10,12)(13,14)(19,21)(22,23),( 2,8)( 3,10)(15,25)(16,29)(18,35)
  (20,41)(22,47)(26,50)(30,54)(34,58)(38,62)(42,66)(46,70)(53,75)(55,76)
  (61,79)(63,80)(69,83)(71,84),( 1,7)( 3,11)( 4,13)( 6,14)( 8,15)(10,16)
  (12,19)(17,22)(20,23),( 3,6)( 8,10)(12,14)(16,19),
 ( 1,6)( 4,12)(10,13)(11,14),( 1,2)( 5,6)(11,12)(15,16)(19,20)(23,24),
 ( 1,6)( 4,11)( 7,12)( 8,13)( 9,14)(10,15)(16,19)(17,20)(18,21),
 ( 1,2)(10,11)(12,14)(15,17)(18,19)(22,23)(24,26)(28,29)(30,32)(33,35)
  (36,37)(42,44)(45,46)(54,56)(60,62)(63,64)(69,70)(75,76)(79,80),
 ( 2,23)( 3,24)( 4,25)( 6,26)( 7,29)( 9,30)(10,31)(12,34)(13,35)(15,36)
  (16,39)(18,45)(20,54)(27,60)(28,61)(32,62)(33,63)(37,64)(38,65)(42,71)
  (47,72)(49,75)(52,76)(55,79)(58,80),( 3,4)(11,12)(17,18)(20,22)(24,25)
  (27,29)(31,32)(36,37)(41,43)(45,46)(51,52)(53,54)(58,59),
 ( 1,6)( 4,10)( 5,21)( 8,22)(12,24)(18,28)(25,29)(27,30),
 ( 2,8)( 3,9)( 5,10)( 7,12),( 1,6)( 4,10)( 7,21)( 9,22)(13,23)(15,24)
  (19,25),( 1,6)( 4,10)( 7,21)( 9,22)(13,23)(17,26)(19,27),
 ( 1,6)( 4,10)( 7,12)( 8,14)( 9,16)(11,17)(13,18)(15,19),
 ( 1,6)( 4,10)( 8,14)( 9,15),( 4,21)( 6,22)( 7,23)(10,26)(11,27)(14,28)
  (16,29)(17,32)(19,33)(24,34)(30,35),( 2,8)( 3,9)(10,12)(15,33)(29,34)
  (31,42)(32,50)(35,51)(39,53)(41,55)(43,57)(47,59)(49,61)(54,63)(58,64)
  (62,65),( 2,8)( 3,9)(11,17)(15,32)(19,34)(29,44)(31,50)(39,51)(41,53)
  (43,55)(45,57)(47,59)(49,61)(54,64)(58,66)(62,68),
 ( 1,6)( 4,9)(12,16)(21,30)(28,35)(29,44)(31,49)(34,51)(36,53)(39,55)
  (40,56)(43,58)(45,60)(48,62)(52,63)(57,64)(61,65),
 ( 2,8)( 4,22)( 9,24)(13,25)(14,26)(16,27)(17,28)(19,29)(20,30),
 ( 4,21)( 6,22)( 8,24)(10,25)(12,26)(14,27)(15,29)(17,31)(18,32)(23,34)
  (28,36),( 4,21)( 6,22)( 8,23)( 9,24)(12,27)(13,28)(16,29)(18,30)(19,33)
  (25,34)(31,35),( 4,21)( 6,22)( 8,23)(10,26)(11,27)(13,28)(16,29)(17,32)
  (20,33)(25,34)(31,35),( 4,21)( 6,22)( 8,23)(10,24)(11,25)(14,29)(15,30)
  (18,31)(19,32)(26,35)(33,36),( 1,6)( 5,11)( 7,12)( 8,13)( 9,14)(10,15)
  (16,19)(17,20)(18,21),( 4,21)( 7,24)( 9,25)(10,26)(12,27)(14,30)(16,31)
  (17,32)(20,33)(22,34)(28,35),( 2, 8)( 4,14)( 5,18)( 10,34)
  ( 12,35)( 13,37)( 16,39)( 17,41)( 21,44)( 22,45)( 24,48)( 26,49)
  ( 31,75)( 33,77)( 40,78)( 43,80)( 47,81)( 54,91)( 59,94)( 63,98)
  ( 67,100)( 72,103)( 76,105)( 79,107)( 89,114)( 96,116),
 ( 4,21)( 7,22)( 8,25)(11,26)(13,27)(14,28)(16,31)(18,32)(20,33)(23,34)
  (29,35),( 4,21)( 7,22)( 8,24)(10,26)(11,27)(13,28)(15,29)(17,32)(19,33)
  (25,34)(31,35),( 2,8)( 4,12)( 5,16)( 7,20)( 9,21)(11,22)(13,23)(15,24)
  (17,25)(19,26),( 2,8)( 4,12)( 5,13)( 6,17)( 7,20)(11,21)(16,23)(19,25),
 ( 4,21)( 7,22)( 8,23)(10,24)(12,27)(14,28)(15,29)(17,30)(20,33)(26,34)
  (32,35),( 1,9)( 2,11)( 3,16)( 4,18)( 5,24)( 6,27)( 7,30)( 8,34)(12,40)
  (15,41)(19,42)(21,45)(23,48)(26,49)(28,52)(31,53)(33,54)(35,57)(37,59)
  (39,62)(44,63)(50,65)(56,66)(60,68),( 1, 9)( 2,11)( 3,16)( 4,18)
  ( 5,22)( 6,24)( 7,28)( 8,30)( 12,34)( 14,37)( 20,42)( 25,44)
  ( 31,49)( 36,53)( 38,56)( 39,58)( 40,59)( 41,61)( 43,64)( 46,66)
  ( 47,69)( 48,71)( 50,74)( 51,76)( 52,77)( 55,78)( 62,83)( 63,85)
  ( 67,88)( 68,90)( 72,92)( 73,94)( 79,96)( 80,98)( 81,99)( 82,100)
  ( 86,102)( 87,104)( 91,106)( 95,108)(101,110)(105,112)(107,113)(109,114)
  (111,115),( 2,8)( 4,12)( 6,19)(10,20)(14,21)(16,24)(23,29)(26,30),
 ( 1,9)( 2,11)( 3,15)( 4,21)( 5,26)( 6,32)( 8,38)(12,42)(14,44)(17,47)
  (18,49)(20,50)(24,52)(28,55)(31,57)(33,58)(35,60)(37,61)(39,62)(41,63)
  (43,64)(46,65)(48,67)(51,71)(53,72)(56,74)(59,78)(66,79)(68,80)(70,81)
  (73,82)(75,83)(77,84),( 2,8)( 4,12)(14,15)(17,31)(21,32)(29,35)(30,41)
  (34,46)(36,48)(38,50)(40,52)(42,54)(44,56)(47,57)(51,58)(55,59),
 ( 1, 9)( 2,11)( 3,15)( 4,18)( 5,21)( 6,23)( 7,28)( 8,30)
  ( 13,38)( 17,41)( 25,45)( 27,48)( 33,53)( 34,54)( 35,56)( 36,57)
  ( 37,59)( 40,62)( 42,64)( 43,65)( 44,67)( 46,70)( 49,73)( 50,75)
  ( 51,76)( 52,78)( 60,82)( 61,84)( 68,87)( 69,89)( 71,90)( 72,92)
  ( 79,94)( 80,95)( 81,97)( 85,99)( 86,101)( 93,104)( 98,106)(102,108)
  (103,109)(105,110)(107,111),( 1,6)( 5,9)(10,26)(23,33)(29,34)(31,35)
  (32,43)(36,52)(38,54)(42,56)(44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 2,8)( 4,11)( 5,15)( 7,19)(10,23),( 4,20)( 5,24)( 9,35)(11,36)(13,38)
  (14,40)(16,42)(19,45)(21,47)(23,48)(25,49)(27,51)(29,53)(34,57)(56,68)
  (58,70)(59,71)(60,72)(61,74)(63,75)(64,76)(65,77)(66,79)(80,83)(81,84)
  (82,85),( 2,8)( 4,11)( 5,13)( 6,16)( 7,18)(12,22)(17,24)(20,26),
 ( 1,2)(10,11)(14,15)(19,20)(23,24)(25,26),
 ( 1,3)( 5,7)(12,13)(18,20)(22,24)(35,37)(41,43)(47,48)(49,50)(52,54)
  (55,57)(61,63)(66,67)(68,70)(71,73)(74,75)(77,78)(81,82)(84,85)(88,89)
  (91,92)(94,95),( 2,3)( 6,7)(11,12)(14,15)(18,19)(22,23),
 ( 1,22)( 3,23)( 5,24)( 6,27)( 8,30)(10,31)(11,32)(13,33)(15,36)(16,39)
  (17,40)(20,42)(21,45)(26,46)(28,47)(35,49)(37,50)(41,52)(43,53),
 ( 4,20)( 5,22)( 7,24)( 9,26)(12,27)(14,29)(17,31)(18,32)(23,33)(25,34)
  (28,36)(30,37),( 4,20)( 5,22)( 9,24)(10,25)(12,27)(14,30)(16,31)(17,32)
  (21,34)(23,35)(26,37)(28,38),( 2,8)( 4,11)(12,14)(24,30)(28,35)(29,44)
  (31,49)(34,51)(36,53)(39,55)(40,56)(43,58)(45,60)(48,62)(50,63)(54,64)
  (59,65),( 2,8)( 4,11)(12,13)(18,30)(28,35)(29,44)(31,49)(34,51)(36,53)
  (39,55)(40,56)(43,58)(45,60)(48,62)(52,63)(57,64)(61,65),
 ( 1,6)( 9,17)(10,24)(11,30)(12,36)(14,37)(19,38)(22,39)(28,40)(31,41)
  (35,42),( 4,20)( 5,21)( 8,25)( 9,26)(10,27)(12,28)(14,32)(16,33)(17,34)
  (22,35)(29,36),( 1,6)( 9,15)(10,18)(11,25)(12,29)(16,35)(17,36)(24,37)
  (31,38)(33,39)(46,60)(52,61)(57,62),( 4,20)( 5,21)( 8,23)( 9,25)(13,26)
  (15,28)(17,30)(18,31)(22,33)(24,35)(27,36)(29,38),
 ( 1,6)( 9,14)(10,25)(11,29)(12,35)(18,36)(20,37)(26,38)(28,39)(32,40)
  (33,43)(34,50),( 2,8)( 4,10)( 6,21)( 9,22)(12,23)(18,28)(25,29)(27,30),
 ( 4,20)( 6,31)( 7,33)( 8,34)( 10,36)( 13,37)( 16,38)( 18,40)
  ( 19,41)( 21,45)( 24,46)( 32,72)( 35,75)( 39,80)( 42,83)( 44,86)
  ( 48,94)( 50,96)( 53,100)( 55,102)( 57,104)( 59,106)( 61,108)( 64,112)
  ( 66,114)( 68,116)( 70,118)( 74,120)( 76,121)( 78,122)( 82,123)( 84,124)
  ( 87,125)( 99,132)(111,134),( 1,6)( 9,14)(10,22)(11,26)(12,32)(16,34)
  (18,35)(23,36)(25,37)(40,50)(43,57)(48,60)(54,61)(58,62),
 ( 1,6)( 9,14)(10,22)(11,25)(12,35)(16,37)(18,38)(23,39)(24,40)(31,41)
  (33,42),( 2,8)( 4,10)( 6,13)(12,16)(14,18),
 ( 4,20)( 6,23)( 8,24)( 9,26)(12,27)(13,30)(15,31)(16,32)(18,34)(22,35)
  (29,36),( 2,3)( 6,7)(12,13)(15,16)(18,19)(21,22)(23,24),
 ( 1,6)(10,15)(11,20)(12,23)(17,33)(18,34)(21,35)(22,36)(27,38)(29,43)
  (31,49)(53,64)(57,66)(61,68),( 4,20)( 6,22)( 7,25)( 9,26)(11,27)(12,28)
  (14,31)(16,32)(19,33)(24,34)(30,36),( 4,20)( 6,22)( 7,23)(10,24)(11,27)
  (13,28)(15,30)(17,31)(19,34)(25,35)(32,36),( 2,8)( 4,10)( 6,11)( 7,12),
 ( 2,8)( 4,10)( 6,11),( 4,20)( 6,22)( 8,23)(11,26)(13,27)(14,29)(17,30)
  (19,32)(21,33)(24,34)(28,36)(35,38)(37,39),
 ( 4,20)( 6,22)( 9,24)(11,26)(14,28)(15,30)(17,31)(18,32)(21,34)(23,35)
  (27,36)(29,37),( 4,20)( 6,22)( 9,24)(11,25)(13,27)(14,29)(16,31)(17,32)
  (21,33)(23,35)(26,36)(28,38),( 4,20)( 6,22)( 9,23)(10,25)(12,26)(15,29)
  (17,30)(19,32)(24,34)(28,36)(31,37)(33,38)(35,39),
 ( 1,2)(11,12)(13,14)(16,17)(18,19)(21,22)(23,24),
 ( 4,38)( 7,40)( 9,41)(12,42)(15,43)(18,45)(21,46)(24,47)(27,48)(33,49)
  (35,50)(51,61)(53,64)(54,67)(55,70)(57,73)(58,76)(63,77)(69,79)(75,81),
 ( 1, 5)( 2,27)( 6,47)( 9,49)( 14,50)( 19,53)( 21,54)( 24,55)
  ( 28,57)( 32,58)( 34,62)( 38,64)( 42,68)( 44,72)( 46,74)( 48,75)
  ( 52,79)( 59,89)( 61,91)( 63,92)( 65,94)( 67,96)( 69,98)( 71,100)
  ( 73,101)( 77,103)( 81,104)( 84,106)( 86,108)( 88,110)(105,111)(107,112)
  (109,113),( 1,3)( 5,6)( 8,9)(11,12)(13,14)(16,17),
 ( 4,20)( 6,21)( 7,22)(10,23)(11,27)(14,28)(15,29)(16,30)(18,34)(24,35)
  (31,36),( 4,20)( 6,21)( 7,22)(10,23)(11,27)(14,28)(16,29)(18,33)(24,34)
  (25,35)(30,36)(31,37),( 1,2)(11,12)(14,15)(17,18)(20,21)(22,23)(24,25)
  (26,27)(28,29),( 1,9)( 3,14)( 4,19)( 6,23)(11,43)(13,44)(16,45)(18,47)
  (21,49)(25,50)(27,51)(28,53)(30,55)(38,65)(41,73)(46,75)(52,76)(57,77)
  (66,79),( 1,3)( 5,6)(11,12)(24,25)(29,30)(35,36)(41,42)(43,44)(46,47)
  (49,50)(52,53)(55,56)(57,58)(60,61)(63,64)(65,66)(76,77)(78,79)(80,81),
 ( 1,2)(11,12)(14,15)(17,18)(21,22)(24,25)(26,27)(29,30)(31,32)(34,35),
 ( 4,20)( 6,21)( 8,24)( 9,25)(11,26)(13,27)(14,30)(16,32)(17,33)(22,35)
  (28,37),( 4,20)( 6,21)( 8,24)(10,25)(11,26)(13,27)(16,30)(17,31)(23,34)
  (29,36)(32,37)(33,38)(35,39),( 3,5)( 7,19)( 9,21)(11,23)(14,25)(16,27)
  (18,28)(20,29)(22,30)(24,32)(26,33),( 1, 5)( 2,16)( 3,24)( 4,30)
  ( 35,54)( 36,59)( 38,60)( 41,62)( 42,63)( 45,65)( 47,67)( 48,68)
  ( 51,70)( 53,71)( 56,73)( 57,74)( 58,80)( 75,87)( 77,90)( 79,93)
  ( 81,96)( 83,99)( 85,102)( 86,104)( 89,105)( 92,107)( 95,108)( 98,110)
  (101,111),( 1,2)(11,12)(14,15)(18,19)(30,31)(34,35)(37,38)(42,43)(45,46)
  (49,50)(51,52)(53,54)(59,60)(62,63)(66,67)(68,69)(70,71),
 ( 1,9)( 3,14)( 5,19)( 8,26)(10,48)(12,49)(15,50)(17,53)(20,54)(23,55)
  (24,56)(27,59)(29,60)(34,61)(41,64)(44,67)(51,68)(57,69),
 ( 1,2)(11,12)(14,15)(20,21)(23,24),( 4,20)( 7,24)( 8,25)( 9,26)(11,27)
  (13,31)(15,32)(16,33)(19,34)(21,35)(28,36),( 3,5)( 7,10)(12,14)(16,19),
 ( 4,20)( 7,23)( 9,24)(11,25)(13,28)(16,30)(17,31)(19,32)(22,34)(27,36)
  (29,37)(33,38)(35,39),( 4,20)( 7,23)(10,24)(12,25)(14,29)(16,30)(18,31)
  (19,32)(21,35)(26,36)(27,38)(33,39)(34,40)(37,42)(41,44)(43,45),
 ( 2, 8)( 5,28)( 12,33)( 17,36)( 18,37)( 20,42)( 23,50)( 26,58)
  ( 29,62)( 30,63)( 32,65)( 34,68)( 38,80)( 40,83)( 41,86)( 43,89)
  ( 44,91)( 46,94)( 48,97)( 49,100)( 51,103)( 52,106)( 53,109)( 56,111)
  ( 57,114)( 59,117)( 61,121)( 64,125)( 66,126)( 70,131)( 71,132)( 72,133)
  ( 81,153)( 85,155)( 87,157)( 93,159)( 95,161)( 99,163)(101,165)(105,167)
  (107,169)(113,171)(115,173)(119,175)(123,179)(124,180)(129,181)(130,182)
  (134,185)(136,188)(138,189)(140,192)(142,195)(144,196)(146,199)(148,202)
  (150,203)(183,210)(186,211)(190,212)(193,213)(197,214)(200,215),
 ( 4,20)( 7,21)( 8,25)(11,26)(12,27)(13,28)(15,32)(17,33)(19,34)(22,35)
  (29,36),( 4,20)( 7,21)( 8,25)(11,26)(13,27)(15,31)(17,32)(19,33)(22,34)
  (23,35)(28,36)(29,37),( 2, 8)( 5,19)( 7,34)( 9,38)( 11,39)
  ( 12,40)( 14,44)( 16,45)( 18,47)( 20,48)( 22,50)( 24,54)( 33,68)
  ( 35,69)( 41,73)( 46,74)( 49,76)( 51,80)( 56,87)( 62,94)( 65,99)
  ( 70,102)( 75,104)( 77,106)( 83,121)( 86,122)( 89,123)( 93,124)( 96,125)
  ( 98,127)(103,131)(105,132),( 2,8)( 5,18)( 7,19)( 9,20)(11,23)(13,25)
  (14,28)(16,30)(22,35)(27,37),( 2,3)( 7,8)( 9,10)(13,14)(21,22)(24,26)
  (28,29)(30,32)(34,35)(41,42)(43,44),( 1,2)(11,12)(15,16)(19,20)(23,24)
  (26,27)(30,31)(35,36)(38,39)(45,46)(48,49)(52,53),
 ( 1,9)( 3,13)( 6,21)( 7,26)(11,45)(12,48)(16,49)(18,50)(20,51)(23,54)
  (25,55)(28,56)(30,57)(33,61)(42,69)(47,72)(53,73)(68,78)(75,79)(77,80),
 ( 4,20)( 7,21)( 8,22)(10,23)(12,27)(14,28)(15,29)(16,30)(19,34)(26,35)
  (33,36),( 2,8)( 5,11)(12,24)(19,30)(28,35)(29,44)(31,49)(34,51)(36,53)
  (39,55)(40,56)(43,58)(45,60)(48,62)(50,63)(54,64)(59,65),
 ( 2,3)( 7,8)( 9,10)(14,15)(17,18)(23,24)(30,31)(33,34)(39,40)(42,43)
  (46,47)(50,51)(52,53)(55,56)(58,59)(62,63)(65,66)(68,69)(70,71)(73,74)
  (77,78)(83,84),( 2,8)( 5,10)( 6,12)( 9,14)(11,16),
 ( 1,2)(11,12)(15,16)(19,20)(24,25)(27,28)(31,32)(34,35),
 ( 2,8)( 5,10)( 6,11)( 7,17)( 9,18),( 4,20)( 7,21)( 9,23)(10,24)(12,25)
  (14,26)(16,29)(19,30)(22,33)(27,35)(31,37)(36,40)(38,41)(39,42),
 ( 1,2)(11,12)(15,16)(19,20)(24,25)(30,31)(33,34)(37,38)(39,40),
 ( 1, 5)( 2,12)( 3,26)( 6,36)( 8,39)( 10,40)( 14,43)( 15,45)
  ( 20,50)( 22,51)( 24,55)( 27,57)( 37,84)( 44,86)( 48,87)( 52,90)
  ( 56,91)( 59,98)( 64,99)( 68,100)( 72,101)( 76,102)( 80,104)( 85,106)
  ( 88,108),( 1, 5)( 2,12)( 3,26)( 6,35)( 8,38)( 10,39)( 14,42)
  ( 15,44)( 20,49)( 22,50)( 24,54)( 27,56)( 36,84)( 43,86)( 47,87)
  ( 51,90)( 55,91)( 62,98)( 66,99)( 70,100)( 74,101)( 78,103)( 82,104)
  ( 85,106)( 88,108),( 1,2)(11,12)(15,16)(25,26)(29,30)(31,32)(37,38)
  (40,41)(42,43)(47,48)(49,50)(53,54)(55,56)(59,60)(61,62)(67,68)(75,76)
  (77,78),( 3,5)( 7,9)(11,13)(24,25)(26,28)(29,30)(33,34)(35,37)(38,39)
  (41,43)(44,45)(47,48)(50,51)(53,54),( 2,3)( 7,8)(10,11)(14,15)(23,24)
  (26,27)(28,29)(31,32)(33,34)(37,38)(39,40),
 ( 1,2)(11,12)(15,16)(25,26)(29,30)(33,34)(36,37)(42,43)(45,46)(49,50)
  (51,52)(55,56)(57,58)(60,61)(63,64)(65,66)(67,68),
 ( 2,3)( 7,8)(10,11)(15,16)(18,19)(23,24)(26,27)(32,33)(38,39)(42,43)
  (44,45)(49,50)(52,53)(54,55)(58,59)(61,62)(65,66)(68,69)(73,74)(75,76)
  (78,79)(81,82)(85,86)(87,88)(91,92)(95,96)(98,99),
 ( 2,3)( 7,8)(10,11)(15,16)(18,19)(23,24)(30,31)(36,37)(38,39)(43,44)
  (47,48)(50,51)(52,53)(55,56)(58,59)(62,63)(66,67)(68,69)(71,72)(75,76)
  (78,79)(82,83)(85,86)(89,90)(92,93)(95,96),
 ( 3,5)( 7,9)(12,14)(17,19)(21,23),( 2, 3)( 7, 8)( 10,11)( 15,16)
  ( 18,19)( 23,24)( 30,31)( 36,37)( 39,40)( 43,44)( 47,48)( 49,50)
  ( 52,53)( 54,55)( 59,60)( 62,63)( 65,66)( 67,68)( 70,71)( 74,75)
  ( 77,78)( 80,81)( 84,85)( 88,89)( 91,92)( 96,97)(100,101),
 ( 3,5)( 7,9)(12,14)(17,19)(28,30)(36,38)(43,45),
 ( 1,20)( 2,21)( 3,22)( 4,24)( 5,25)( 6,26)( 7,27)( 8,29)( 9,30)(18,32)
  (19,34),( 2,3)( 7,8)(11,12)(13,14)(15,16)(22,23)(25,26),
 ( 2,8)( 7,15)( 9,16)(10,18)(11,20)(12,21)(13,23),
 ( 1, 5)( 2,12)( 6,40)( 9,41)( 18,42)( 20,43)( 23,44)( 28,52)
  ( 30,53)( 33,61)( 37,69)( 39,70)( 45,92)( 47,95)( 48,96)( 50,99)
  ( 51,100)( 54,102)( 56,105)( 57,106)( 59,109)( 60,110)( 62,112)( 64,115)
  ( 65,116)( 67,119)( 68,120)( 74,124)( 76,127)( 78,129)( 83,131)( 87,132)
  ( 91,133)( 94,134)( 98,136)(104,138)(108,140)(114,142)(118,144)(122,146)
  (126,147),( 1,2)(11,12)(22,23)(28,29)(31,32)(34,35)(38,39)(43,44)(47,48)
  (49,50)(53,54)(55,56)(59,60)(61,62)(63,64)(66,67)(68,69)(72,73)(74,75)
  (76,77),( 3,5)( 7,9)(14,15)(20,22)(24,26)(27,29)(38,39)(43,44)(46,48)
  (52,54)(56,57)(58,59)(63,64)(66,68)(72,73)(74,76)(78,80)(81,83)(84,86)
  (87,89)(90,92)(93,95)(96,98),( 1, 5)( 2,11)( 3,20)( 4,38)
  ( 10,40)( 13,44)( 15,45)( 17,47)( 19,51)( 21,52)( 23,53)( 24,55)
  ( 26,57)( 28,58)( 37,77)( 39,78)( 46,83)( 48,84)( 50,85)( 76,102)
  ( 82,103),( 1,5)( 2,11)( 3,20)( 6,36)( 8,38)(10,40)(12,42)(15,45)(17,47)
  (21,50)(22,52)(24,54)(25,57)(26,59)(28,61)(39,88)(43,90)(51,91)(55,93),
 ( 4,19)( 6,20)( 8,24)(10,25)(12,26)(15,30)(18,32)(22,34)(23,35)(28,37)
  (29,38)(31,39)(33,40)(36,41),( 4,19)( 6,20)( 8,24)(10,25)(13,26)(16,29)
  (17,31)(22,32)(23,34)(28,35)(30,38)(33,40)(36,42)(37,43)(39,44)(41,45),
 ( 1,2)(12,14)(15,16)(17,19)(20,21)(22,24)(25,26),
 ( 4,19)( 7,21)( 8,22)(11,26)(12,27)(15,29)(17,32)(20,33)(23,34)(24,35)
  (28,37)(30,38)(36,40)(39,41),( 4,19)( 7,21)(10,25)(12,26)(14,27)(16,31)
  (18,32)(20,33)(22,34)(23,35)(28,37)(29,38)(36,40)(39,41),
 ( 3,5)( 7,8)(10,12)(23,25)(33,34)(41,42)(44,46)(47,48)(51,52)(55,56)
  (58,60)(61,62)(63,64)(66,67)(68,69)(72,73)(74,75)(78,79)(80,81)(82,83)
  (86,87)(88,89),( 4,19)( 7,20)( 8,23)(10,26)(11,27)(13,28)(15,32)(17,33)
  (24,34)(25,36)(30,37)(31,39),( 4,19)( 7,20)( 8,21)(10,24)(11,27)(13,28)
  (15,30)(17,33)(25,34)(26,35)(31,37)(32,38),( 1,9)( 3,11)( 4,12)( 6,14),
 ( 3,5)( 7,8)(10,11)(13,14)(16,17)(18,19),
 ( 4,19)( 7,20)( 9,21)(11,24)(13,26)(15,27)(16,30)(18,33)(22,35)(23,36)
  (28,38)(29,39),( 4,19)( 7,20)(10,22)(11,23)(12,25)(13,27)(14,28)(15,30)
  (16,32)(17,33)(18,35),( 2,7)( 3,10)( 5,11)(14,20)(16,21)(18,22),
 ( 4,19)( 7,20)(10,21)(11,23)(13,25)(14,27)(16,29)(17,31)(22,33)(24,34)
  (26,35)(28,36)(30,37)(32,38),( 1,2)(12,13)(15,16)(18,20)(22,24)(32,34)
  (36,37)(41,42)(44,45)(46,47)(49,51)(54,56)(60,61)(63,64)(65,66)(67,68)
  (69,70)(73,74)(77,78),( 4,19)( 8,30)( 9,34)(10,36)(11,38)(13,39)(16,42)
  (18,44)(22,47)(23,49)(24,51)(26,52)(28,54)(32,56)(45,62)(46,64)(59,71)
  (61,72)(65,74)(66,76)(67,77)(69,78)(70,80)(73,81)(82,84)(83,85),
 ( 4,19)( 8,21)( 9,22)(11,24)(13,27)(14,30)(17,31)(18,33)(20,34)(23,36)
  (25,37)(29,40)(39,45)(42,46)(44,47),( 1,5)( 2,10)( 3,17)( 4,31)(34,44)
  (35,47)(36,59)(37,62)(40,68)(41,70)(45,73)(46,74)(50,75)(51,77)(55,80)
  (56,81)(60,82)(61,84)(65,87)(66,88),( 1,19)( 2,20)( 3,21)( 4,23)( 5,24)
  ( 6,26)( 7,27)( 8,28)( 9,30)(10,31),( 1, 5)( 2,10)( 3,17)( 11,38)
  ( 12,40)( 15,43)( 18,44)( 21,49)( 23,51)( 25,55)( 27,56)( 34,81)
  ( 37,83)( 41,84)( 45,85)( 48,87)( 52,88)( 59,95)( 63,97)( 67,99)
  ( 71,101)( 75,103)( 79,105)( 96,113)( 98,114)(100,115)(102,116)(104,117)
  (106,118),( 4,18)( 5,20)( 8,22)(10,25)(13,27)(14,28)(16,29)(19,31)(21,32)
  (24,35)(33,40)(34,41)(37,44)(39,47)(42,48)(43,49)(45,50)(46,51),
 ( 3,5)( 8,21)( 9,24)(10,37)(11,40)(13,44)(22,45)(23,46)(32,47)(34,48)
  (43,49),( 2,7)( 3,9)( 5,13)( 6,16)( 8,17)(10,18)(12,19)(14,20),
 ( 1,9)( 3,11)( 6,14)(10,17)(13,20),( 1,5)( 2,10)( 3,13)( 4,27)(34,43)
  (35,46)(36,58)(37,61)(39,68)(40,69)(44,72)(45,74)(49,75)(50,76)(54,79)
  (55,81)(59,82)(60,83)(64,86)(65,88),( 4,18)( 6,23)( 8,29)(10,36)(12,38)
  (14,39)(17,44)(21,47)(22,48)(24,51)(27,52)(33,57)(34,58)(37,60)(40,61)
  (42,62)(46,66)(49,68)(53,70)(56,73)(64,75)(71,78),
 ( 1,2)(12,13)(17,19)(23,24)(28,29)(31,33)(35,36)(38,40)(42,43)(45,46)
  (47,48)(52,53)(54,55),( 3,5)( 8,10)(11,12)(21,22)(23,24)(28,29)(30,31),
 ( 1,2)(12,13)(17,18)(20,21)(22,23)(25,26),
 ( 1,9)( 3,10)( 4,12)( 6,13)( 7,14)( 8,15),
 ( 4,18)( 6,20)( 7,22)( 9,23)(12,27)(14,29)(17,30)(21,33)(25,36)(26,37)
  (28,39)(32,41)(35,44)(40,47)(43,49)(46,51)(48,52)(50,53),
 ( 2,7)( 3,8)( 5,12)( 6,15)( 9,16)(11,17)(14,19)(18,21)(20,22),
 ( 1,9)( 3,10)( 4,11)( 5,12)( 6,13)( 8,15),
 ( 4,18)( 6,20)( 9,21)(11,24)(14,27)(15,29)(17,30)(25,36)(26,38)(28,39)
  (32,41)(34,44)(35,46)(37,47)(40,48)(42,49)(43,50)(45,51),
 ( 2,7)( 3,8)( 5,10)( 6,12),( 4,18)( 7,19)( 8,22)(10,25)(12,27)(13,28)
  (17,30)(20,32)(24,35)(26,36)(29,38)(31,39)(33,41)(42,46)(44,47),
 ( 4,18)( 7,19)( 9,21)(12,25)(14,26)(15,28)(17,30)(20,31)(22,33)(23,34)
  (27,37)(35,42)(38,45)(40,47)(43,49)(46,51)(48,52)(50,53),
 ( 4,17)( 5,22)( 6,25)( 7,28)( 8,34)(10,35)(11,36)(12,37)(13,39)(15,41)
  (18,42)(19,43)(20,45)(23,46)(24,48)(26,50)(29,51)(30,52)(32,55)(33,57)
  (38,58)(40,59)(44,62)(47,63)(49,64)(53,67)(54,68)(56,69)(60,70)(61,71)
  (65,72)(66,73),( 2,7)( 3,8)( 6,11)( 9,12)(10,13),
 ( 4,17)( 5,19)( 6,20)( 7,22)( 8,23)( 9,25)(10,26)(11,27)(12,29)(13,30)
  (14,31)(15,32)(16,34)(35,40)(36,42)(37,43)(38,45)(39,47)(48,51)(49,52)
  (50,53),( 3,5)( 8,10)(13,15)(16,18)(20,22)(24,26)(32,33)(41,42)(44,45)
  (47,48)(50,51),( 1,5)( 2,9)( 3,17)(10,23)(15,26)(18,30)(21,34)(24,38),
 ( 2,7)( 3,8)( 9,13)(10,14),( 1,9)( 4,18)( 5,23)( 7,31)(10,38)(13,41)
  (15,42)(17,43)(20,46)(25,47)(26,50)(30,52)(35,55)(39,56)(45,64)(53,72)
  (59,77)(66,80)(68,81)(73,83)(75,86)(78,87)(82,91),
 ( 1,5)( 2,9)( 3,15)(10,25)(13,27)(18,31)(19,33),
 ( 4,17)( 5,18)( 6,19)( 7,21)( 8,22)( 9,23)(10,25)(11,26)(12,28)(13,29)
  (14,31)(15,32)(33,41)(34,43)(35,44)(36,46)(37,47)(38,48)(39,50)(40,51)
  (52,55)(53,56)(54,57),( 1,2)(13,14)(17,18)(20,21)(30,31)(34,35)(37,38)
  (43,44)(45,46)(49,50)(52,53)(59,60)(61,62)(67,68)(70,71)(75,76)(79,80)
  (81,82)(85,86),( 1,2)(13,14)(18,20)(24,25)(29,30)(32,34)(36,37)(39,41)
  (43,44)(45,46)(47,48)(52,53)(54,55),( 1,9)( 4,17)( 5,21)( 7,25)(11,42)
  (14,43)(16,46)(19,47)(20,48)(24,49)(27,52)(29,53)(31,56)(34,62)(45,70)
  (51,71)(54,76)(60,79)(61,80)(68,83)(78,90)(82,91),
 ( 1,9)( 4,17)( 5,20)( 8,22)(10,23)(15,25)(24,28)(26,30),
 ( 4,17)(11,19)(14,20)(21,38)(22,40)(23,41)(24,43)(25,44)(26,46)(27,49)
  (28,50)(29,51)(30,53)(31,54)(32,56)(33,58)(34,59)(35,60)(36,62)(37,63)
  (48,71)(65,73)(66,74)(67,78)(68,79)(69,83)(70,84)(72,87)(75,88)(76,89)
  (77,90)(80,91)(81,92)(82,93)(85,94)(86,95),
 ( 4,17)( 19,28)( 23,29)( 27,38)( 31,49)( 33,52)( 34,54)( 36,56)
  ( 39,57)( 40,60)( 43,61)( 45,64)( 46,66)( 48,73)( 55,81)( 59,82)
  ( 68,85)( 70,88)( 72,90)( 74,91)( 76,94)( 78,95)( 80,98)( 83,99)
  ( 84,105)( 86,112)( 87,114)( 89,116)( 92,118)( 93,120)( 96,122)( 97,124)
  (100,125)(102,127)(104,129)(106,131)(108,133)(110,135)(115,137)(119,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,152)(141,154)
  (143,156)(145,158)(147,160)(149,162)(151,163)(155,164)(159,165),
 ( 4,16)( 5,18)( 8,19)(10,21)(11,22)(14,24),
 ( 3,5)( 8,10)(13,15)(19,20)(26,28)(30,32)(34,36)(39,40)(42,43)(45,46)
  (48,49),( 2, 7)( 4,12)( 5,18)( 10,34)( 15,37)( 17,40)( 19,41)
  ( 21,43)( 23,47)( 25,50)( 31,66)( 32,67)( 33,69)( 36,72)( 39,73)
  ( 42,74)( 46,78)( 49,79)( 53,86)( 55,91)( 63,100)( 70,101)( 71,102)
  ( 76,103)( 77,104)( 89,123)( 98,125)(105,129)(107,130)(110,131)(114,133)
  (116,134)(118,135),( 4,16)( 5,17)( 8,19)(10,20)(11,22)(14,23),
 ( 4,16)( 6,18)( 8,19)(10,21)(12,22)(14,24),
 ( 2,7)( 4,11)( 6,20)( 8,22)(10,24)(21,26)(23,27),
 ( 1,9)( 4,14)( 5,15)( 7,19)(11,21)(16,23),
 ( 2,7)( 4,11)( 6,14)( 9,16)(18,21)(20,22),
 ( 4,16)( 7,17)( 8,20)( 9,21)(12,24)(13,25),
 ( 4,15)( 5,18)( 6,19)(10,22)(11,23)(12,26),
 ( 4,15)( 5,17)( 6,19)( 9,21)(10,23)(11,25),
 ( 2,7)( 4,10)( 5,15)(12,21)(14,24)(19,26)(23,27)(25,29),
 ( 4,15)( 5,17)( 7,18)( 9,20)(11,21)(13,23),
 ( 2,7)( 4,10)( 5,11)( 6,14)( 9,17)(13,20)(15,21)(16,22)(18,23)(19,24),
 ( 4,15)( 5,16)( 7,20)( 8,21)( 9,25)(11,26),
 ( 1,5)( 2,8)( 3,13)(19,36)(22,37)(26,38)(28,39)(32,40)(34,41),
 ( 4,15)( 6,17)( 8,18)( 9,20)(11,21)(13,23),
 ( 3,5)( 8,10)(16,17)(19,20)(21,22)(26,27)(28,29),
 ( 3,5)( 8,10)(16,17)(20,22)(25,27)(33,35)(38,40),
 ( 2,45)( 4,47)( 6,48)( 8,50)(11,51)(13,53)(15,54)(17,56)(20,58)(22,60)
  (24,62)(26,64)(29,65)(31,67)(33,68)(35,70)(37,71)(39,73)(41,75)(43,77),
 ( 2,3)( 8,10)(12,14)(16,18)(24,25)(30,31)(35,36)(38,39)(43,44)(45,46)
  (47,48)(49,50),( 2,3)( 8,10)(15,16)(18,19)(21,22)(23,24)(25,26),
 ( 4,15)( 6,16)( 8,18)(10,19)(12,21)(14,22),
 ( 4,15)( 7,16)( 8,18)( 9,19)(12,21)(13,22),( 1,5)( 2,8)( 3,9)( 6,11),
 ( 2,44)( 4,45)( 7,47)( 9,48)(11,50)(13,52)(16,54)(18,56)(20,58)(22,59)
  (24,61)(26,62)(28,64)(30,65)(32,67)(34,69)(36,71)(38,73)(41,75)(43,76),
 ( 1,9)( 4,12)( 7,15)(10,16)(13,17),( 1,3)( 8,9)(14,16)(18,20)(31,33)
  (34,36)(38,40)(44,45)(46,47)(49,51)(52,54)(58,60)(63,64)(65,67)(68,70)
  (74,75)(77,78)(81,82)(84,85)(88,89)(91,92)(94,95),
 ( 1, 6)( 2,11)( 3,16)( 4,22)( 5,29)( 35,52)( 36,56)( 40,59)
  ( 41,61)( 45,65)( 46,67)( 49,69)( 53,72)( 54,73)( 55,79)( 74,87)
  ( 76,90)( 78,93)( 80,96)( 82,99)( 84,102)( 85,103)( 88,105)( 91,107)
  ( 94,109)( 97,111)(100,113),( 1,17)( 3,18)( 6,20)( 8,21)( 9,22)(12,24)
  (13,26)(16,27)(19,40)(23,41)(29,45)(33,51)(48,63)(59,66),
 ( 1,3)( 8,9)(15,17)(19,21)(23,25)(27,28)(30,32)(34,35)(38,40)(42,43),
 ( 3,5)( 9,12)(13,16)(19,21)(23,24)(29,32)(37,39)(41,43)(46,47)(52,54)
  (56,57)(59,61)(63,65)(69,71)(73,74)(76,77)(78,79)(82,83)(87,88)(90,91)
  (92,93),( 2,7)( 4,9)(10,13)(24,33)(29,34)(31,39)(32,47)(35,51)(38,53)
  (41,55)(43,57)(46,59)(49,61)(52,63)(56,64)(60,65),
 ( 4,14)( 5,15)( 6,19)( 7,21)( 8,23)( 9,27)(10,30)(11,34)(13,36)(16,40)
  (17,41)(20,42)(22,43)(24,45)(25,46)(29,50)(31,52)(32,54)(35,55)(38,57)
  (39,59)(44,60)(48,62)(49,64)(51,65)(53,66)(56,67)(58,68)(61,69)(63,70),
 ( 4,14)( 5,15)( 7,17)( 9,18)(11,20)(13,21),( 1,5)( 2,8)( 4,9)( 7,11),
 ( 4,14)( 5,15)( 8,17)( 9,18)(10,20)(13,21),
 ( 2,41)( 5,45)( 6,47)( 9,48)(12,49)(14,53)(17,54)(18,56)(21,57)(23,60)
  (26,63)(27,65)(30,66)(33,67)(34,71)(37,72)(39,74)(43,75)(44,77)(52,79)
  (59,81)(62,83)(70,85),( 2,41)( 5,45)( 6,46)( 9,48)(12,51)(13,54)(16,56)
  (18,57)(21,59)(24,62)(25,63)(28,65)(31,68)(33,71)(36,73)(37,74)(40,76)
  (44,77)(50,78)(53,80)(61,81)(67,82)(70,84),
 ( 1,5)( 2,8)(14,25)(17,30)(19,36)(21,42)(23,48)(27,51)(31,55)(35,59)
  (39,63)(43,67)(47,71)(52,75)(54,76)(60,79)(62,80)(68,83)(70,84),
 ( 2,41)( 5,44)( 8,46)( 9,47)(12,49)(15,53)(17,54)(20,56)(21,57)(24,60)
  (26,63)(29,65)(30,66)(33,68)(36,72)(37,73)(40,75)(43,77)(52,79)(59,81)
  (62,83)(71,84)(76,85)(80,86),( 4,14)( 6,15)( 8,18)( 9,19)(11,22)(13,23),
 ( 2,7)( 4,8)( 6,9)(11,20)(13,23)(22,26)(25,27),
 ( 2,41)( 5,43)( 8,47)( 9,48)(12,49)(15,53)(17,54)(20,56)(21,57)(24,59)
  (27,63)(28,64)(31,66)(33,67)(36,71)(37,72)(40,74)(44,76)(45,78)(50,80)
  (60,82)(61,84)(68,86),( 2,41)( 5,42)( 6,46)( 9,47)(12,48)(13,51)(16,54)
  (18,56)(21,57)(24,59)(25,63)(28,64)(31,65)(33,68)(36,71)(37,73)(40,74)
  (45,76)(50,78)(53,79)(62,81)(67,83)(70,84),
 ( 1,17)( 4,18)( 5,20)( 8,22)( 9,23)(11,24)(14,26)(16,27)(21,40)(25,41)
  (34,51)(38,57)(43,61)(54,64),( 2,40)( 5,42)( 8,44)( 10,47)
  ( 16,48)( 18,52)( 21,56)( 24,57)( 26,59)( 30,63)( 33,64)( 36,66)
  ( 37,70)( 39,71)( 41,72)( 43,74)( 46,77)( 50,79)( 51,80)( 55,83)
  ( 58,84)( 60,86)( 62,89)( 65,90)( 73,93)( 78,94)( 82,96)( 85,97)
  ( 92,99)( 95,100)( 98,101),( 2,39)( 6,41)( 9,45)( 12,47)( 13,49)
  ( 15,52)( 18,54)( 21,55)( 23,59)( 29,61)( 31,63)( 34,67)( 37,68)
  ( 38,69)( 40,72)( 46,75)( 48,78)( 51,79)( 53,80)( 57,85)( 58,86)
  ( 62,89)( 64,92)( 66,93)( 71,96)( 77,97)( 82,100)( 84,101)( 91,102)
  ( 95,103)( 99,104),( 2,3)( 8,9)(18,19)(23,24)(27,28)(34,35)(38,39)
  (41,42)(44,45)(47,48)(53,54)(56,57)(60,61)(63,64)(68,69)(71,72)(77,78)
  (81,82)(87,88)(92,93)(96,97),( 1,5)( 2,7)( 4,11)( 6,21)(10,22),
 ( 4,14)( 10,18)( 13,35)( 16,37)( 17,39)( 19,41)( 20,42)( 21,43)
  ( 22,47)( 24,48)( 25,51)( 26,52)( 28,57)( 30,59)( 31,60)( 33,63)
  ( 36,64)( 44,83)( 46,85)( 49,87)( 53,90)( 56,92)( 58,94)( 61,96)
  ( 66,99)( 67,101)( 68,103)( 69,104)( 71,107)( 72,109)( 73,112)( 75,114)
  ( 76,117)( 77,118)( 78,121)( 80,123)( 82,126)( 89,128),
 ( 2,7)( 4,8)(10,13)(11,15),( 2,7)( 5,11)( 6,14)( 8,16)(12,18),
 ( 4,13)( 5,16)( 6,18)( 8,21)( 9,23)(10,26),
 ( 2,7)( 5,10)( 6,14)( 8,16)(11,19),( 2,38)( 5,41)( 8,42)(10,43)(12,46)
  (13,50)(16,54)(18,55)(21,57)(22,58)(24,61)(27,62)(30,66)(33,70)(34,71)
  (37,73)(40,75)(47,78)(49,80)(53,81)(60,85)(65,87)(69,88)(82,92)(89,95),
 ( 3,5)(11,13)(18,19)(22,23)(25,26)(29,30)(31,32)(34,35)(37,38)(39,40)
  (42,43)(45,46),( 2,7)( 5,10)( 9,15)(12,18)(13,21)(16,22)(19,23),
 ( 4,13)( 5,14)( 6,16)( 8,17)( 9,19)(10,20),
 ( 4,13)( 5,14)( 6,16)( 9,17)(10,19)(11,20),
 ( 2,37)( 3,40)( 4,42)( 7,45)( 9,49)(10,51)(14,52)(16,56)(18,57)(21,60)
  (24,63)(26,67)(29,69)(30,70)(33,73)(36,77)(47,78)(48,81)(55,82)(65,83)
  (66,86)(71,87)(76,89)(79,90)(84,92),( 1,5)( 2,7)(13,21)(19,33)(23,35)
  (29,41)(31,47)(36,48)(38,50)(40,52)(42,54)(44,56)(46,58)(51,61)(55,63)
  (59,65),( 1,16)( 2,18)( 3,19)( 4,21)( 5,23)( 6,24)( 7,26)( 8,28)( 9,29)
  (10,30)(11,32)(12,33)(13,35)(14,36)(15,37),
 ( 1,5)( 2,7)(14,25)(17,28)(19,34)(21,40)(23,46)(29,53)(33,57)(37,61)
  (41,65)(45,69)(49,73)(52,75)(54,76)(60,79)(62,80)(68,83)(70,84),
 ( 4,13)( 6,14)( 7,16)( 8,17)(10,19)(11,20),
 ( 4,12)( 5,19)( 6,23)( 7,26)( 8,31)( 9,32)(11,34)(13,38)(14,40)(15,42)
  (18,44)(20,45)(22,46)(25,49)(27,51)(28,53)(29,55)(33,56)(35,57)(36,58)
  (37,60)(39,61)(41,63)(43,65)(47,66)(48,68)(50,69)(52,71)(54,74)(59,76)
  (62,77)(64,78)(67,80)(70,81)(72,82)(73,83)(75,84)(79,85),
 ( 2,7)( 5,8)( 6,11),( 1,3)( 9,10)(15,17)(19,21)(23,24)(26,28)(32,34)
  (37,38)(39,40),( 4,12)( 5,15)( 6,17)( 8,20)( 9,22)(10,25),
 ( 4,12)( 5,14)( 6,15)( 7,17)( 8,18)(11,20),
 ( 4,12)( 5,14)( 7,17)( 8,19)( 9,22)(11,24),
 ( 2,37)( 5,39)( 7,41)( 9,45)(11,48)(16,49)(18,52)(20,53)(23,55)(26,59)
  (27,62)(29,65)(33,68)(35,70)(36,73)(40,76)(42,77)(44,80)(54,84)(56,85)
  (58,88)(64,91)(69,92)(75,94)(81,95)(83,97)(89,98),
 ( 4,12)( 5,13)( 6,22)( 23,27)( 24,37)( 25,39)( 26,47)( 29,53)
  ( 30,54)( 35,57)( 36,60)( 41,63)( 44,67)( 45,68)( 48,73)( 49,78)
  ( 50,82)( 51,87)( 71,90)( 74,93)( 77,96)( 80,99)( 83,102)( 86,105)
  ( 91,108)( 94,109)( 97,113)(100,114)(103,118)(106,119),
 ( 4,12)( 5,13)( 6,15)( 7,16)( 8,18)(10,19),
 ( 1, 8)( 2,16)( 3,20)( 4,26)( 5,32)( 7,39)( 9,40)( 13,42)
  ( 14,45)( 17,46)( 19,49)( 24,50)( 28,52)( 31,54)( 33,57)( 35,58)
  ( 37,59)( 38,60)( 41,62)( 43,65)( 44,66)( 47,68)( 48,71)( 51,72)
  ( 53,73)( 55,74)( 56,77)( 61,78)( 63,79)( 64,80)( 67,82)( 69,85)
  ( 70,86)( 75,89)( 76,90)( 81,92)( 83,93)( 84,94)( 87,96)( 88,98)
  ( 91,100)( 95,102)( 97,103)( 99,104)(101,105),
 ( 4,12)( 5,13)( 6,15)( 9,16)(10,18)(11,19),
 ( 4,12)( 5,13)( 7,15)( 8,16)( 9,18)(11,19),( 2,7)( 5,8)( 9,12)(10,14),
 ( 4,12)( 6,15)( 7,17)( 8,20)(10,22)(11,25),
 ( 2,7)( 6,21)(11,23)(12,25)(13,26)(15,27)(16,28)(18,29)(19,30),
 ( 2,7)( 6,14)( 8,16)(10,18)(11,19)(13,21),( 2,7)( 6,11)( 9,12)(10,13),
 ( 2,7)( 6,11)(10,14)(12,15)(13,16),( 2,7)( 6,8)( 9,14)(11,16),
 ( 2,32)( 10,33)( 13,34)( 17,35)( 21,36)( 22,37)( 26,38)( 29,39)
  ( 42,56)( 45,61)( 47,64)( 48,65)( 51,70)( 52,71)( 55,76)( 63,89)
  ( 69,90)( 77,91)( 78,94)( 82,97)( 83,100)( 84,103)( 88,106)( 92,111)
  ( 95,114)( 98,117)(101,120)(104,123)(107,126)(110,127)(116,128)(122,129),
 ( 1,5)( 3,10)( 6,11)( 9,12),( 1,5)( 3,10)( 7,13)( 8,14)( 9,15)(11,16)
  (12,17),( 2,7)( 6,8)( 9,12)(10,14),( 3,4)( 5,6)( 7,8)(11,12),
 ( 2,7)( 6,8)( 9,11)(10,13),( 1, 8)( 2,14)( 3,20)( 4,24)( 5,32)
  ( 7,38)( 9,41)( 12,43)( 16,45)( 21,46)( 23,49)( 26,50)( 27,53)
  ( 31,55)( 33,56)( 35,58)( 37,59)( 39,60)( 40,63)( 42,64)( 44,65)
  ( 47,66)( 48,69)( 51,71)( 52,72)( 54,75)( 57,77)( 61,79)( 62,80)
  ( 67,83)( 68,84)( 70,87)( 73,89)( 74,90)( 76,91)( 78,93)( 81,95)
  ( 82,97)( 85,99)( 86,100)( 88,101)( 92,102)( 94,103)( 96,104)( 98,105),
 ( 4,11)( 5,15)( 6,17)( 7,22)( 8,25)( 9,30)(10,31)(13,34)(14,35)(16,39)
  (18,40)(20,41)(21,43)(23,45)(26,49)(28,50)(29,51)(32,54)(36,56)(37,57)
  (42,59)(44,60)(46,61)(47,62)(52,64)(53,65)(55,66)(58,67)(63,68),
 ( 4,11)( 5,15)(16,22)(17,26)(18,29)(19,32)(20,35)(23,38)(27,39)(33,40)
  (36,42)(37,44),( 1,5)( 3,9)( 6,20)( 8,22)(10,24)(21,26)(23,27),
 ( 3,4)( 5,6)( 8,9)(11,12)(13,14)(18,19),( 1,5)( 3,9)( 6,11),
 ( 1,5)( 3,9)( 7,19)(11,20)(15,23)(17,26)(21,29)(24,30),
 ( 4,11)( 6,13)( 7,14)( 8,15)( 9,16),( 4,11)( 6,13)( 8,15)( 9,16)(12,17),
 ( 2,7)( 8,15)( 9,16)(10,18)(11,20)(12,21)(13,23),
 ( 2,7)( 8,14)( 9,16)(10,17)(11,19)(12,21)(13,22),
 ( 4,11)( 7,14)( 8,15)( 9,17)(10,19)(12,20)(13,22),
 ( 4,11)( 7,13)( 8,15)( 9,16)(10,17)(12,18)(14,19),
 ( 1,5)( 3,8)( 7,12)( 9,14)(10,16)(11,17)(13,18)(15,19),
 ( 3,4)( 5,6)(10,11)(13,14)(19,20)(26,27)(29,30)(35,36)(38,39)(41,42)
  (45,46)(49,50)(51,52)(54,55)(57,58)(61,62)(64,65)(67,68)(69,70)(72,73)
  (77,78)(83,84),( 4,11)( 8,14)( 9,15)(10,16)(12,17)(13,18),
 ( 2,7)( 9,15)(10,16)(11,18)(12,19)(13,20)(14,22),
 ( 2,7)(10,20)(11,23)(14,32)(15,35)(17,40)(18,41)(25,44)(26,45)(33,48)
  (34,49),( 2,7)(10,17)(11,24)(12,31)(13,38)(19,42)(22,43)(28,44)(32,45)
  (37,46)(41,47),( 4,10)( 5,14)( 6,17)( 7,21)( 8,26)( 9,32)(11,35)(12,37)
  (16,39)(18,40)(20,43)(23,44)(24,47)(25,49)(27,50)(29,52)(31,53)(33,54)
  (34,57)(36,58)(38,59)(41,60)(42,63)(45,65)(46,66)(48,69)(51,71)(55,73)
  (56,74)(61,77)(62,78)(64,81)(67,83)(68,84)(70,85)(72,87)(75,89)(76,91)
  (79,93)(80,94)(82,95)(86,96)(88,97)(90,98)(92,99),
 ( 4,10)( 5,14)( 6,17)(18,24)(19,26)(20,29)(21,31)(22,34)(35,38)(36,40),
 ( 2,7)(10,14)(11,21)(12,28)(13,35)(15,42)(20,43)(24,44)(30,45)(33,46)
  (39,47),( 4,10)( 5,12)( 6,22)( 7,26)( 8,29)( 9,33)(11,37)(13,38)(15,40)
  (16,42)(17,43)(20,46)(21,47)(23,48)(25,49)(27,51)(28,53)(31,55)(32,56)
  (35,57)(36,58)(39,60)(41,61)(44,62)(45,63)(50,65)(52,66)(54,67)(59,68)
  (64,69),( 1,5)( 3,7)( 8,21)(10,22)(12,23)(16,24)(18,25),
 ( 1,5)( 3,7)(12,24)(13,28)(26,31)(27,37)(30,44)(32,46)(34,50)(36,53)
  (38,57)(41,59)(45,64)(52,65)(58,66)(67,80)(69,82)(71,85)(73,87)(75,90)
  (77,92),( 4,10)( 5,11)(12,19)(17,30)(21,31)(28,32)(29,41)(33,51)(37,53)
  (39,55)(42,57)(46,59)(48,61)(50,62)(54,63)(58,64),
 ( 4,10)( 6,12)( 7,13)( 8,16)(14,17)(15,18),
 ( 4,10)( 6,12)( 8,14)( 9,16)(13,17),( 1,8)( 2,12)( 3,18)( 4,23)(13,27)
  (16,29)(21,33),( 4,10)( 6,11)( 8,13)( 9,14)(12,15),
 ( 2,6)( 3,10)( 4,22)( 8,24)(13,26)(16,28)(19,30),
 ( 4,10)( 7,28)( 12,29)( 27,39)( 30,49)( 32,51)( 35,54)( 36,55)
  ( 38,57)( 41,60)( 42,61)( 44,63)( 46,65)( 48,78)( 56,81)( 62,82)
  ( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)( 80,98)( 83,102)
  ( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)( 96,122)( 97,123)
  ( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)(114,137)(124,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,151)(141,153)
  (143,155)(145,157)(147,159)(149,161)(154,163)(158,164)(162,165),
 ( 4,10)( 7,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 1,14)( 2,21)( 3,26)( 4,34)( 6,35)( 8,39)( 10,41)( 13,46)
  ( 16,47)( 19,50)( 20,52)( 38,81)( 42,82)( 45,84)( 49,85)( 53,86)
  ( 56,88)( 58,96)( 62,98)( 66,100)( 70,102)( 74,104)( 78,106)( 95,113)
  ( 97,114)( 99,115)(101,116)(103,117)(105,118),
 ( 2,25)( 4,28)( 7,29)( 9,33)(11,34)(14,38)(15,46)(16,47)(17,50)(18,51)
  (19,53)(20,56)(21,57)(23,58)(24,60)(27,64)(31,65)(32,66)(36,67)(37,68)
  (39,69)(41,70)(42,72)(44,73)(45,75)(48,76)(49,77)(52,78)(54,79)(55,80)
  (59,81)(61,82)(62,83)(63,84)(71,85)(74,86),
 ( 1,5)( 4,11)( 7,12)( 8,13)( 9,14)(10,15),
 ( 4,10)( 8,28)( 26,29)( 27,39)( 31,49)( 32,51)( 34,54)( 37,55)
  ( 38,58)( 41,59)( 43,61)( 44,63)( 46,66)( 48,74)( 56,81)( 60,82)
  ( 67,85)( 69,88)( 71,89)( 73,92)( 75,93)( 77,95)( 79,98)( 83,104)
  ( 84,110)( 86,111)( 87,113)( 90,115)( 91,117)( 94,119)( 96,121)( 97,123)
  ( 99,126)(101,128)(103,130)(105,132)(107,134)(109,136)(116,137)(120,138)
  (125,139)(127,141)(129,143)(131,145)(133,147)(135,149)(140,151)(142,153)
  (144,155)(146,157)(148,159)(150,161)(154,163)(158,164)(162,165),
 ( 1,8)( 2,12)( 3,15)( 4,20)( 9,24)(18,31)(21,34)(29,37),
 ( 2,25)( 4,26)( 7,27)( 9,28)(12,30)(14,32)(17,33)(21,34)(23,36)(29,37)
  (35,38),( 2,24)( 3,27)( 7,28)(10,29)(12,30)(15,33)(17,34)(20,35)(22,36)
  (26,37)(32,38),( 4, 9)( 5,16)( 6,21)( 25,35)( 26,42)( 27,44)
  ( 28,49)( 31,54)( 32,56)( 37,58)( 40,61)( 41,62)( 46,65)( 47,66)
  ( 50,69)( 51,73)( 52,78)( 53,82)( 68,87)( 71,90)( 74,93)( 77,96)
  ( 80,99)( 83,102)( 88,105)( 91,106)( 94,109)( 97,110)(100,113)(103,114),
 ( 1,14)( 2,19)( 3,26)( 4,34)( 5,37)( 7,40)( 8,41)(10,43)(12,45)(15,47)
  (17,48)(20,51)(22,53)(23,54)(25,55)(27,57)(29,58)(31,60)(33,62)(36,63)
  (39,65)(42,66)(44,67)(49,68)(52,71)(56,72)(59,73)(64,76)(69,77)(74,78),
 ( 2,6)( 3,9)(12,24)(17,30)(19,36)(21,42)(23,48)(27,51)(31,55)(35,59)
  (39,63)(43,67)(47,71)(52,75)(54,76)(60,79)(62,80)(68,83)(70,84),
 ( 3,4)( 6,8)(12,13)(18,20)(24,26)(29,30)(32,33)(35,36),
 ( 2,24)( 3,25)( 4,26)( 6,27)( 8,30)( 9,32)(11,33)(13,34)(14,35)(16,38)
  (18,40)(19,41)(21,42)(22,45)(29,46)(37,47)(44,48),
 ( 4,9)( 5,13)( 6,17)(18,23)(19,26)(20,28)(21,31)(22,33)(35,37)(36,39),
 ( 4,9)( 5,13)( 6,16)(18,24)(19,27)(20,29)(21,32)(22,34)(35,38)(36,40),
 ( 2,3)(10,11)(14,15)(16,17)(21,22)(27,28)(29,30),
 ( 2,24)( 4,26)( 6,28)(10,29)(13,30)(15,32)(18,34)(20,35)(23,36)(27,37)
  (33,38),( 2,6)( 3,8)( 9,15)(10,18),( 2,6)( 3,8)( 9,14)(10,18),
 ( 3, 4)( 6, 7)( 8, 9)( 10,11)( 12,13)( 15,16)( 18,19)( 20,21)
  ( 22,23)( 25,26)( 27,28)( 30,31)( 40,41)( 42,43)( 45,46)( 48,49)
  ( 51,52)( 53,54)( 57,58)( 59,60)( 63,64)( 65,66)( 69,70)( 72,73)
  ( 74,75)( 77,78)( 80,81)( 83,84)( 86,87)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)
  (125,126),( 2,6)( 3,8)(11,23)(21,30)(26,31)(28,32)(29,36)(33,44)(35,48)
  (37,51)(39,55)(41,57)(43,63)(47,64)(54,65)(60,68)(62,72),
 ( 4,9)( 6,20)( 8,21)(11,22)(12,25)(14,26)(17,29)(18,30)(24,31)(28,32),
 ( 4,9)( 6,13)( 7,15)( 8,16)(11,18)(12,19),
 ( 4,9)( 6,13)( 7,14)( 8,15)(10,17)(11,19)(12,20)(16,21)(18,22),
 ( 4,9)( 6,11)( 7,13)( 8,15)(14,17)(16,18),( 2,6)( 3,7)( 4,11)( 5,13),
 ( 3,4)( 6,7)( 9,10)(11,12)(14,15)(21,22),( 2,6)( 3,7)( 4,10)( 5,11),
 ( 1,5)( 4,9)( 6,12)( 8,14)(10,15)(11,17)(13,18)(16,19),
 ( 4,9)( 6,10)( 7,11)( 8,13)(12,18)(14,20),
 ( 2,24)( 4,25)( 7,27)(11,28)(13,29)(16,30)(18,32)(20,33)(22,35)(26,36)
  (31,38),( 1,14)( 2,15)( 3,18)( 4,22)( 5,24)( 6,27)( 7,30)( 8,32)( 9,35)
  (10,37)(11,38)(12,40)(16,43)(19,44)(21,46)(29,49)(31,50)(33,52),
 ( 1,8)( 2,11)( 3,12)( 5,15)( 6,16)( 9,17)(13,18),( 1,5)( 4,9)( 7,12),
 ( 1,9)( 2,14)( 4,19)( 7,27)(11,51)(13,52)(16,53)(18,55)(21,57)(24,58)
  (26,59)(28,61)(30,63)(35,64)(42,65)(48,66)(54,67)(60,68),
 ( 2,6)( 3,7)(10,26)(23,33)(29,34)(31,35)(32,43)(36,52)(38,54)(42,56)
  (44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 1,14)( 2,15)( 4,17)( 5,18)( 6,19)( 7,21)( 9,22)(10,24)(12,25)(13,26),
 ( 1,5)( 4,9)(11,21)(18,29)(23,30)(27,31)(28,37)(32,47)(34,49)(36,52)
  (38,55)(42,58)(44,61)(46,67)(51,68)(57,69),
 ( 1,5)( 4,9)(11,18)(16,29)(21,30)(27,38)(28,44)(31,46)(33,49)(37,52)
  (39,55)(41,58)(43,60)(50,67)(56,68)(61,69),
 ( 2,6)( 4,19)( 7,23)( 9,25)(11,28)(13,30)(16,33)(20,35)(22,36)(27,37)
  (32,39),( 2,6)( 4,18)( 8,23)(10,26)(12,28)(15,31)(17,33)(19,35)(21,36)
  (25,37)(30,39),( 2, 6)( 4,15)( 7,35)( 10,37)( 11,39)( 12,40)
  ( 14,43)( 16,44)( 17,46)( 19,48)( 20,51)( 21,52)( 23,54)( 25,57)
  ( 33,73)( 34,74)( 36,77)( 42,79)( 45,80)( 47,83)( 56,85)( 78,102)
  ( 84,103),( 4,8)( 5,20)( 7,21)(10,24)(12,25)(15,28)(16,29)(19,30)(23,31)
  (27,32),( 3,4)( 6,7)(10,11)(20,21)(23,24)(27,28)(39,40)(44,45)(47,48)
  (53,54)(55,56)(62,63)(65,66)(69,70)(71,72)(75,76)(79,80)(81,82)(85,86),
 ( 4,8)( 5,9)( 6,12)( 7,13)(10,14)(11,15),
 ( 2,6)( 4,10)(14,27)(15,31)(19,32)(29,35)(30,41)(34,46)(36,48)(38,50)
  (40,52)(42,54)(44,56)(47,57)(51,58)(55,59),
 ( 2,6)( 4,9)( 5,20)( 8,22)(12,24)(15,26)(18,28),
 ( 1,5)( 6,12)( 7,14)( 8,16)( 9,17)(10,18)(11,19)(13,20)(15,21),
 ( 1,5)( 6,11)( 7,13)( 8,15)( 9,17)(10,18)(12,19)(14,20)(16,21),
 ( 3,4)( 6,7)(11,12)(13,14)(18,19)(21,22)(27,28)(30,31)(37,38)(42,43)
  (48,49)(50,51)(53,54)(56,57)(59,60)(65,66)(68,69)(71,72)(74,75)(77,78)
  (79,80)(82,83)(84,85),( 3,4)( 6,7)(11,12)(13,14)(18,19)(21,22)(27,28)
  (34,35)(37,38)(42,43)(48,49)(50,51)(53,54)(56,57)(59,60)(65,66)(67,68)
  (70,71)(72,73)(75,76)(78,79)(82,83),( 2,6)( 4,9)(12,26)(16,30)(28,35)
  (29,44)(31,49)(34,51)(36,53)(39,55)(40,56)(43,58)(45,60)(48,62)(52,63)
  (57,64)(61,65),( 4,8)( 5,9)(10,23)(20,33)(26,34)(31,35)(32,43)(36,52)
  (38,54)(42,56)(44,58)(46,60)(50,62)(51,63)(55,64)(59,65),
 ( 2,6)( 4,8)( 5,21)( 9,22)(14,23)(18,24)(20,25),
 ( 1,14)( 4,34)( 6,40)( 9,42)(13,43)(16,45)(18,49)(20,50)(25,51)(29,52)
  (31,54)(33,58)(36,59)(38,60)(39,61)(44,64)(48,65)(53,68)(57,69),
 ( 2,3)(11,12)(14,15)(16,17)(19,20),( 1,5)( 6,10)( 7,11),
 ( 4,8)( 6,12)( 7,14)( 9,17)(11,20)(16,22)(19,24),
 ( 2,3)(11,12)(14,15)(17,18)(20,21)(22,23)(24,25)(26,27)(28,29),
 ( 1,8)( 2,10)( 4,11)( 7,12),( 2,3)(11,12)(14,15)(17,18)(21,22)(24,25)
  (26,27)(29,30)(31,32)(34,35),( 2,8)( 3,10)( 6,13)( 7,15)( 9,16)(11,17)
  (12,18)(14,19),( 1,2)( 3,4)( 5,6)( 7,8)(10,11)(12,13)(15,16)(17,18)
  (19,20)(21,22),( 2,3)(11,12)(14,15)(18,19)(21,22)(27,28)(29,30),
 ( 4,21)( 5,22)( 7,23)( 8,25)(11,27)(13,29)(16,31)(18,33)(24,34)(26,35)
  (30,36)(32,37),( 1,2)( 5,6)(10,11)(25,26)(28,29)(31,32)(34,35)(38,39)
  (44,45)(47,48)(50,51)(57,58)(61,62),( 1,13)( 2,23)( 3,27)( 4,32)( 9,40)
  (10,41)(11,42)(12,43)(14,45)(16,47)(17,48)(20,50)(21,51)(24,53)(26,55)
  (28,56)(31,58)(33,59)(44,63)(46,64)(49,65)(52,66)(54,67)(57,68),
 ( 2,8)( 3,9)( 5,12)( 6,13)( 7,16)(11,17)(15,18),
 ( 1,8)( 2,9)( 4,13)(10,17)(14,20),( 2,23)( 3,25)( 5,26)( 6,27)( 7,28)
  ( 9,31)(11,33)(12,34)(14,35)(16,36)(17,39)(19,41)(21,42)(22,43)(29,46)
  (37,47)(44,48),( 1,2)(10,11)(12,14)(19,20)(21,23),
 ( 4,21)( 6,23)( 7,24)( 9,25)(11,27)(13,30)(14,31)(17,32)(18,33)(22,35)
  (28,37),( 1,5)( 6,10)(11,14)(24,26)(27,29)(32,34)(35,37),
 ( 2,23)( 3,24)( 5,28)( 7,29)( 9,30)(10,33)(12,34)(14,35)(15,36)(17,37)
  (19,41)(20,42)(22,43)(25,44)(27,45)(32,47)(38,49)(40,50)(46,52)(48,53)
  (51,54),( 1,5)( 6,10)(13,16)(17,21)(24,27)(33,35)(39,42),
 ( 1,5)( 6,10)(13,16)(17,21)(24,27)(37,39)(41,43),
 ( 1,2)( 3,4)( 5,6)( 7,8)(13,14)(16,17)(22,23),
 ( 4,8)( 9,13)(14,17)(18,21)(22,25)(26,30)(31,35)(36,40)(41,44)(45,48)
  (49,52)(53,57),( 2,23)( 3,24)( 5,26)( 6,27)( 8,28)( 9,29)(10,30)(12,33)
  (13,34)(15,35)(16,37)(18,41)(20,51)(25,59)(31,61)(32,62)(36,64)(39,71)
  (43,73)(45,75)(49,77)(52,79)(54,81)(57,83)(60,85)(63,86)(65,87)(72,95)
  (76,97)(82,99),( 3,4)( 6,7)(16,17)(20,21)(23,24)(27,28)(39,40)(44,45)
  (48,49)(50,51)(52,53)(57,58)(60,61)(65,66)(67,68)(70,71)(76,77)(78,79)
  (86,87),( 4,8)( 9,13)(14,16)(18,20)(21,24)(25,28)(29,32)(33,35)(44,45)
  (48,50)(52,53)(56,58),( 2,23)( 3,24)( 5,25)( 7,26)( 8,30)(10,31)(12,32)
  (13,33)(15,34)(17,38)(19,39)(20,40)(22,44)(27,45)(29,46)(35,47)(37,48)
  (41,49)(43,50),( 2,6)( 5,7)( 8,12)(10,14),
 ( 2,23)( 3,24)( 5,25)( 7,26)( 8,29)(10,31)(12,32)(13,33)(15,34)(17,37)
  (19,39)(21,40)(22,43)(27,45)(28,46)(35,47)(36,48)(41,49)(42,50),
 ( 1,13)( 2,18)( 3,23)( 4,26)( 5,32)( 6,37)( 8,38)( 9,40)(14,41)(17,43)
  (19,46)(22,48)(24,50)(27,52)(29,55)(31,56)(34,58)(36,61)(39,63)(42,65)
  (44,66)(47,68)(49,70)(51,73)(54,74)(57,75)(59,76)(62,77)(64,80)(67,81)
  (69,84)(72,85)(79,86)(83,87),( 2,23)( 4,25)( 5,26)( 7,27)( 9,31)(10,32)
  (12,33)(14,34)(15,35)(17,39)(19,40)(20,41)(22,42)(24,45)(28,48)(30,49)
  (36,52)(38,53)(44,54)(47,55)(51,56),( 2,23)( 4,25)( 6,26)( 7,27)( 9,30)
  (10,32)(12,33)(14,34)(15,35)(17,38)(19,40)(20,41)(22,42)(24,44)(28,47)
  (29,49)(36,51)(37,53)(43,54)(46,55)(50,56),
 ( 1,5)( 6,9)(12,16)(17,21)(25,28)(32,35),
 ( 4,8)( 9,12)(13,15)(16,19)(21,24)(25,28)(29,32)(50,51)(54,55)(57,59)
  (61,63)(65,67)(69,71)(73,75)(77,79),( 1,5)( 6,9)(12,16)(17,21)(29,32)
  (35,37)(39,41),( 4,8)( 9,12)(14,18)(19,22)(24,26)(28,30),
 ( 1,5)( 6,9)(15,19)(23,25)(26,29)(31,33)(34,37)(39,41)(42,45),
 ( 2,23)( 4,24)( 5,25)( 7,29)( 9,30)(10,31)(12,32)(14,33)(15,35)(17,36)
  (19,37)(21,41)(22,42)(26,45)(28,46)(34,49)(38,52)(40,53)(44,54)(48,55)
  (51,56),( 2,23)( 4,24)( 5,25)( 7,29)( 9,30)(10,31)(12,32)(14,33)(16,35)
  (17,36)(19,37)(21,41)(22,42)(26,45)(28,46)(34,49)(38,52)(40,53)(44,54)
  (48,55)(51,56),( 1, 2)( 3, 4)( 5, 6)( 8, 9)( 11,12)( 14,15)
  ( 19,20)( 21,22)( 24,25)( 32,33)( 37,38)( 39,40)( 41,42)( 43,44)
  ( 45,46)( 47,48)( 49,50)( 54,55)( 56,57)( 58,59)( 60,61)( 62,63)
  ( 64,65)( 67,68)( 69,70)( 73,74)( 76,77)( 80,81)( 82,83)( 86,87)
  ( 88,89)( 92,93)( 95,96)( 99,100)(101,102),
 ( 4,8)( 9,11)(12,14)(15,20)(21,24),( 4,8)( 9,11)(12,14)(16,20)(21,24),
 ( 2,6)( 7,11)(13,16)(18,22)(24,27),( 1,5)( 7,12)( 8,13)(10,14),
 ( 1,5)( 7,11)( 8,12)(10,13),( 4,8)( 9,11)(13,15),
 ( 4, 8)( 9,11)( 16,19)( 20,24)( 25,27)( 45,46)( 49,50)( 53,54)
  ( 57,58)( 62,64)( 65,67)( 68,70)( 71,73)( 74,76)( 77,79)( 80,82)
  ( 83,85)( 86,88)( 89,91)( 92,94)( 95,97)( 98,100)(101,103)(104,106)
  (107,109)(110,112)(113,115)(116,118)(119,121)(122,124)(125,127)(128,130)
  (131,133),( 2,6)( 8,20)(11,27)(12,32)(15,39)(17,41)(22,42)(25,45)(30,46)
  (33,49)(38,50),( 2,23)( 4,24)( 7,28)(11,29)(14,30)(16,34)(19,35)(21,36)
  (26,37)(27,38)(32,39)(33,40),( 4,8)( 9,10)(12,14),
 ( 1,5)( 8,24)( 9,27)(10,40)(11,43)(14,44)(16,45)(25,46)(26,47)(35,48)
  (37,49),( 3,4)( 7,8)(10,11)(12,13)(14,15)(17,18),
 ( 1,5)( 8,17)(11,26)(12,29)(15,38)(19,41)(20,42)(27,45)(28,46)(35,49)
  (36,50),( 3,4)( 7,8)(10,11)(12,13)(15,16)(17,18),
 ( 2,3)(13,14)(18,19)(23,25)(28,30)(31,33)(36,38)(39,41),
 ( 3,4)( 7,8)(10,11)(13,14)(16,17)(19,20)(22,23),
 ( 1,5)( 8,12)( 9,13)(11,14),( 2,6)( 9,18)(10,21)(13,30)(14,33)(16,40)
  (23,43)(24,44)(31,47)(32,48)(39,51),( 2,23)( 5,27)( 6,28)( 9,29)(12,30)
  (14,34)(17,35)(19,36)(22,37)(26,38)(33,39),
 ( 4,8)(10,12)(16,19)(23,27)(35,36)(38,40)(43,44)(46,48)(49,51)(52,54)
  (57,59)(60,62)(65,67)(68,70)(73,75)(76,78)(81,83)(84,86)(89,91)(92,94),
 ( 4,8)(11,14)(16,19)(20,23)(24,26)(28,30),
 ( 1, 5)( 8,11)( 12,15)( 20,23)( 27,30)( 31,33)( 36,38)( 41,42)
  ( 44,46)( 47,50)( 52,54)( 56,57)( 59,61)( 62,65)( 69,71)( 72,74)
  ( 77,79)( 81,83)( 86,88)( 92,94)( 97,99)(102,104)(107,109),
 ( 2,6)( 9,11)(12,13),( 2,6)(10,24)(11,27)(14,36)(15,39)(17,40)(18,41)
  (25,44)(26,45)(33,48)(34,49),( 2,6)(10,19)(11,22)(12,25)(17,33)(20,35)
  (23,36)(24,37)(27,38)(28,39)(30,45)(51,63)(55,65)(59,67),
 ( 2,6)(10,18)(11,21)(13,27)(15,32)(16,33)(19,34)(20,35)(25,37)(29,43)
  (31,49)(53,64)(57,66)(61,68),( 4,8)(12,14)(15,18)(19,22)(23,24)(25,26)
  (31,32)(33,34)(38,39)(40,41),( 2,6)(10,16)(11,19)(13,25)(14,32)(17,33)
  (18,34)(23,36)(27,38)(29,43)(31,49)(53,64)(57,66)(61,68),
 ( 4,8)(14,17)(18,21)(22,23)(24,25)(26,28)(30,31)(32,33)(34,36),
 ( 1,2)( 3,4)( 6,7)( 8,9)(11,12)(13,14)(16,17)(19,20)(21,22)(24,25)
  (26,27)(29,30)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(56,57)(59,60)
  (62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)(82,83)(86,87)(88,89)
  (92,93)(94,95),( 2,23)( 5,24)( 7,25)(10,29)(11,30)(14,31)(17,32)(19,36)
  (22,37)(28,38)(35,39),( 3,4)( 7,8)(11,12)(15,16)(26,27)(29,30)(34,35)
  (37,38)(39,40),( 1,5)( 9,12)(13,16)(17,20)(23,24)(28,30)(31,32)(36,38)
  (39,40)(43,45),( 1,5)( 9,12)(13,16)(17,20)(24,25)(28,29)(30,31)(35,36),
 ( 1,5)( 9,12)(13,16)(17,20)(24,25)(29,30)(31,32)(35,36),
 ( 2,23)( 5,24)( 7,25)(10,28)(12,30)(15,31)(18,32)(20,35)(22,37)(27,38)
  (34,39),( 3,4)( 7,8)(11,12)(15,16)(27,28)(29,30)(35,36)(37,38)(41,42)
  (45,46)(49,50)(52,53),( 1,8)( 3,11)(10,15)(12,17)(14,19)(16,20)(18,21),
 ( 2,5)( 3,9)( 4,10),( 2,23)( 5,24)( 8,28)(10,29)(12,30)(14,31)(17,34)
  (19,36)(22,37)(26,38)(33,39),( 4,7)( 5,8)( 9,13)(11,15),
 ( 3,4)( 7,8)(11,12)(16,17)(25,26)(27,28)(29,30),
 ( 2,23)( 5,24)( 9,28)(11,29)(14,30)(17,32)(19,35)(22,36)(25,37)(27,38)
  (31,39)(34,40),( 3, 4)( 7, 8)( 11,12)( 19,20)( 25,26)( 40,41)
  ( 44,45)( 46,47)( 50,51)( 54,55)( 56,57)( 60,61)( 63,64)( 65,66)
  ( 69,70)( 71,72)( 75,76)( 80,81)( 86,87)( 91,92)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(110,111)(113,114)(116,117)(119,120)(122,123)
  (125,126),( 2,5)( 3,8)( 6,11),( 3,4)( 7,8)(11,12)(20,21)(25,26)
  (29,30)(34,35)(39,40)(43,44)(46,47)(50,51)(53,54),
 ( 2,23)( 6,26)( 9,27)(11,28)(14,32)(16,33)(19,34)(21,35)(25,37)(30,39)
  (31,40)(36,41)(38,42),( 1,5)(10,18)(11,21)(13,27)(15,32)(16,33)(19,34)
  (20,35)(25,37)(29,43)(31,49)(53,64)(57,66)(61,68),
 ( 2,23)( 6,25)( 9,26)(11,27)(14,31)(16,32)(19,33)(21,34)(24,37)(28,40)
  (29,41)(35,42)(38,43),( 1,8)( 3,9)( 4,12)( 5,13)( 7,16)(10,17)(14,18),
 ( 2,22)( 3,27)( 5,28)( 6,29)( 8,30)( 9,35)(11,36)(13,37)(14,38)(16,41)
  (18,44)(19,45)(21,46)(23,47)(26,48)(31,49)(34,50)(39,51)(43,52),
 ( 2,22)( 3,25)( 4,26)( 6,27)( 8,32)( 9,33)(11,34)(13,35)(14,36)(16,41)
  (18,42)(19,43)(21,44)(23,47)(28,50)(31,51)(37,54)(40,55)(46,56)(49,57)
  (53,58),( 1,5)(10,12)(14,16),( 1,5)(10,12)(14,15),
 ( 1,5)(11,24)(12,27)(14,36)(15,39)(17,40)(18,42)(25,43)(26,45)(33,46)
  (34,48),( 1,5)(11,21)(12,24)(22,33)(26,35)(28,36)(29,37)(30,43)(31,44)
  (38,51)(40,53)(42,55)(45,57)(47,59)(49,61)(50,63)(54,65)(58,67),
 ( 4,7)( 6,8)(10,12)(11,13),( 4,7)( 6,8)(11,12)(13,15)(14,16),
 ( 2,22)( 3,23)( 5,24)( 7,25)( 8,30)(10,31)(12,32)(13,33)(15,34)(17,39)
  (18,40)(19,41)(21,46)(26,47)(29,48)(35,49)(38,50)(42,51)(45,52),
 ( 1,5)(11,14)(15,18)(22,23)(24,26)(28,29)(30,31)(32,34)(37,38),
 ( 1, 5)( 12,14)( 22,25)( 26,28)( 32,33)( 34,36)( 37,40)( 41,42)
  ( 45,48)( 49,51)( 52,54)( 55,58)( 59,60)( 61,63)( 64,66)( 68,70)
  ( 71,73)( 76,78)( 79,81)( 86,88)( 89,91)( 93,94)(100,101)(104,105),
 ( 4,7)( 8,13)(14,16)(17,19)(20,24),( 4,7)( 8,12)( 9,15)(10,28)(11,31)
  (18,44)(20,45)(29,46)(30,47)(39,48)(41,49),
 ( 1, 4)( 2,26)( 5,48)( 8,50)( 11,51)( 13,52)( 18,55)( 23,56)
  ( 27,58)( 32,59)( 34,63)( 37,65)( 39,69)( 43,71)( 45,75)( 47,77)
  ( 54,81)( 57,84)( 60,89)( 62,91)( 64,92)( 66,94)( 68,96)( 70,97)
  ( 72,99)( 74,101)( 76,102)( 78,104)( 82,105),
 ( 2,5)( 4,8)( 7,20)(10,22)(11,24)(14,26)(17,28),
 ( 4,7)( 8,12)(13,17)(18,22)(23,26)(27,30)(31,34)(35,39)(40,44)(45,49)
  (50,53)(54,57),( 3,4)( 7,8)(12,13)(14,15)(18,19),
 ( 2,5)( 4,7)( 8,21)(10,22)(12,23)(16,24)(18,25),
 ( 1, 4)( 2,17)( 3,24)( 5,35)( 7,36)( 9,38)( 11,42)( 16,47)
  ( 18,48)( 21,52)( 23,53)( 37,81)( 41,82)( 44,83)( 49,85)( 51,86)
  ( 55,87)( 60,96)( 64,98)( 68,100)( 72,102)( 76,104)( 80,106)( 95,113)
  ( 97,114)( 99,115)(101,116)(103,117)(105,118),
 ( 1, 8)( 4,25)( 9,34)( 14,37)( 17,41)( 18,44)( 20,46)( 23,50)
  ( 26,53)( 27,55)( 29,57)( 31,60)( 33,62)( 35,65)( 36,67)( 38,69)
  ( 42,71)( 45,76)( 47,79)( 48,81)( 51,83)( 58,87)( 63,92)( 72,97)
  ( 77,99)( 88,104),( 4,7)( 8,12)(13,16)(17,20)(22,24),
 ( 2,5)( 6,18)( 8,19)(10,21)(12,23)(13,26)(15,28)(17,31)(24,33)(29,35),
 ( 4,7)( 8,12)(13,16)(20,23)(24,27)(28,31)(32,35)(50,51)(54,55)(57,59)
  (61,63)(65,67)(69,71)(73,75)(77,79),( 4,7)( 8,12)(13,16)(20,23)(24,27)
  (28,31)(32,34)(48,49)(52,53)(57,59)(61,63)(65,67)(69,71)(73,75)(77,79),
 ( 4,7)( 8,12)(13,15)(16,19)(21,23),( 4,7)( 8,12)(13,15)(16,18)(20,24),
 ( 4,7)( 8,12)(13,15)(16,18)(21,24)(28,31)(32,34)(50,51)(54,55)(58,60)
  (62,64)(66,68)(70,72)(74,76)(78,80),( 1,4)( 2,15)( 3,19)( 6,23)( 8,24)
  (11,25)(13,26)(18,27)(20,28),( 1,8)( 4,12)( 5,14)( 9,17)(13,19),
 ( 3,4)( 7,8)(12,13)(17,18)(29,30)(37,38)(44,45),
 ( 1,4)( 2,14)( 3,20)( 7,24)( 9,25)(15,28)(18,29),
 ( 4,7)( 8,12)(14,17)(18,20)(22,25),( 2,5)( 6,9)(11,14)(15,18),
 ( 4,7)( 8,12)(14,16)(17,19)(20,24),( 2,5)( 6,9)(11,14)(16,19)(21,23),
 ( 2,5)( 6,9)(12,14)(16,17)(22,25)(32,34)(39,40)(45,47)(48,49)(50,52)
  (55,56)(61,63)(65,66)(68,69)(70,72)(74,76)(78,79)(81,83)(85,86)(88,90),
 ( 2,5)( 6,9)(13,15)(17,19)(23,25)(29,30)(32,34)(37,38)(40,42)(45,46),
 ( 2,21)( 4,28)( 5,32)( 6,36)( 8,37)( 10,40)( 12,41)( 16,44)
  ( 20,49)( 23,50)( 25,53)( 34,56)( 39,61)( 42,63)( 43,66)( 46,69)
  ( 52,77)( 59,81)( 64,85)( 67,87)( 68,90)( 71,93)( 75,97)( 88,105)
  ( 91,107)( 92,110)( 95,113)(100,117)(108,121)(111,123)(112,126)(115,127)
  (116,130)(124,134)(128,138),( 1,12)( 2,18)( 3,22)( 4,28)( 5,32)( 6,34)
  ( 7,37)( 9,38)(11,40)(13,41)(16,43)(20,46)(23,48)(25,49)(26,51)(29,54)
  (31,56)(35,61)(39,62)(42,66)(45,69)(47,70)(50,74)(52,77)(55,78)(57,79)
  (60,80)(63,81)(65,82)(67,83)(71,84)(73,85)(75,86),
 ( 2,20)( 3,25)( 5,32)( 7,39)( 9,41)(11,44)(15,46)(18,50)(21,51)(23,52)
  (26,55)(30,57)(34,61)(37,62)(42,63)(48,64)(53,65)(59,66),
 ( 2,20)( 4,23)( 5,26)( 7,28)( 8,31)(10,34)(12,36)(14,39)(16,42)(18,45)
  (19,46)(22,48)(24,49)(27,51)(30,53)(32,54)(35,56)(38,58)(40,59)(43,61)
  (44,62)(47,63)(50,64)(52,65)(55,66)(57,67)(60,68),
 ( 4,7)( 8,11)(12,16)(17,21)(22,24)(28,30),
 ( 1,4)( 2,12)( 3,17)( 6,25)(11,27)(16,28)(22,30),
 ( 4,7)( 8,11)(12,16)(17,20)(24,27)(28,31)(32,35)(50,51)(54,55)(57,59)
  (61,63)(65,67)(69,71)(73,75)(77,79),( 2,5)( 6,8)(11,14)(19,21)(23,26)
  (27,28)(31,33)(34,36)(37,39)(41,42)(43,45)(46,48)(49,50)(53,55)(57,59)
  (60,62)(63,64)(66,68)(70,71)(74,76)(79,80)(82,84)(87,88)(90,91)(93,94)
  (96,97),( 2,19)( 4,28)( 6,34)( 8,40)(11,42)(13,45)(16,46)(20,50)(23,52)
  (24,53)(27,55)(30,58)(35,59)(37,63)(39,65)(43,66)(47,67)(56,68)(60,69),
 ( 2, 5)( 6, 8)( 16,19)( 23,26)( 27,28)( 30,33)( 34,36)( 37,39)
  ( 41,42)( 43,44)( 45,47)( 48,49)( 51,53)( 55,56)( 57,58)( 59,61)
  ( 62,63)( 67,69)( 71,72)( 73,74)( 77,78)( 79,80)( 81,82)( 83,84)
  ( 87,88)( 89,90)( 91,93)( 95,97)( 99,101)(103,105),
 ( 4,7)( 8,11)(12,15)(16,19)(21,23)(25,28)(29,32)(33,36)(37,40)(42,44),
 ( 3,4)( 8,10)(12,14)(16,17)(21,22)(25,26)(29,30)(32,33),
 ( 4,7)( 8,11)(12,15)(16,19)(23,26)(27,31)(32,35)(50,51)(54,55)(58,60)
  (62,64)(66,68)(70,72)(74,76)(78,80),( 4,7)( 8,11)(12,15)(16,18)(19,20),
 ( 4,7)( 8,11)(12,15)(16,17)(18,20),( 2,5)( 7,20)(10,21)(11,22)(12,24)
  (14,26)(15,28)(17,30)(18,32),( 2,18)( 5,31)( 7,33)( 8,36)
  ( 9,37)( 11,38)( 12,42)( 13,45)( 15,46)( 16,47)( 17,49)( 19,51)
  ( 21,52)( 22,57)( 24,59)( 34,77)( 41,80)( 43,81)( 50,83)( 54,86)
  ( 55,87)( 58,89)( 78,106)( 84,107),( 1,4)( 2,11)( 3,15)( 5,22)(10,24)
  (14,26)(17,27)(20,29)(23,30)(25,31)(28,32),
 ( 4,7)( 8,11)(12,15)(18,22)(23,24)(28,30)(31,32)(36,38)(39,40)(43,45),
 ( 4,7)( 8,11)(12,15)(18,22)(23,24)(28,30)(31,32)(36,38)(42,44)(45,46)
  (47,48)(49,50),( 4,7)( 8,11)(12,15)(19,23)(24,25)(28,29)(30,31)(35,36),
 ( 4,7)( 8,11)(12,15)(19,23)(24,25)(29,30)(31,32)(35,36),
 ( 2,5)( 7,10)( 9,12)(11,13),( 4,7)( 8,11)(12,15)(19,22)(23,27)(28,31)
  (32,35)(50,51)(54,55)(58,60)(62,64)(66,68)(70,72)(74,76)(78,80),
 ( 4,7)( 8,11)(12,15)(20,23)(24,26)(27,30)(31,34)(49,50)(53,54)(58,60)
  (62,64)(66,68)(70,72)(74,76)(78,80),( 2,5)( 7,10)(12,15)(16,19)(20,21),
 ( 4,7)( 8,11)(12,14)(15,18)(19,20)(21,24)(25,28)(30,34)(47,48)(49,50)
  (55,56)(57,58),( 2,5)( 7,10)(12,15)(16,19)(21,23),
 ( 2,17)( 3,18)( 5,19)( 8,22)(10,23)(11,24)(13,25)(16,28)(21,41)(27,42)
  (35,50)(39,57)(43,61)(52,63),( 4,7)( 8,11)(12,14)(15,16)(17,20),
 ( 2,17)( 3,18)( 6,20)( 9,21)(10,22)(12,23)(14,26)(16,27)(24,45)(30,46)
  (35,49)(40,51)(47,61)(50,62)(52,63),( 1,4)( 2,10)( 3,14)( 5,22)(13,27)
  (17,31)(28,36)(32,38)(34,39),( 2,5)( 7,10)(12,15)(19,22)(27,28)(35,36)
  (41,42),( 2,5)( 7,10)(12,15)(19,22)(28,29)(40,41)(43,44)(47,48)(50,51),
 ( 2,17)( 4,21)( 5,24)( 6,26)( 7,29)( 8,31)(10,32)(12,33)(15,34)(18,36)
  (19,38)(20,39)(23,40)(25,41)(28,42)(30,43)(35,44)(37,45),
 ( 1,12)( 2,14)( 3,17)( 4,21)( 5,25)( 6,27)( 7,30)( 8,33)( 9,34)(16,42)
  (18,44)(20,45)(23,52)(26,56)(28,58)(32,60)(35,62)(36,63)(39,66)(40,68)
  (46,71)(47,72)(50,75)(51,77)(55,80)(57,81)(61,83)(65,85)(67,86)(70,87)
  (74,89)(76,90)(79,91)(84,93)(88,95),( 2,5)( 7,10)(12,14)(16,19)(29,30)
  (37,38)(43,44),( 2,17)( 4,19)( 5,20)( 7,21)( 9,23)(10,24)(12,26)(14,27)
  (15,28)(16,30),( 2,5)( 7,10)(14,16)(18,21)(24,25)(33,34)(39,40),
 ( 4,7)( 8,11)(13,15)(16,18)(21,23),( 2,5)( 7,10)(15,18)(24,26)(30,32)
  (33,35)(36,38)(39,41),( 2,5)( 7,10)(15,17)(19,22)(25,27)(32,34)(37,39),
 ( 2,17)( 4,18)( 5,20)( 7,21)( 9,23)(10,24)(12,25)(14,27)(15,28)(16,30),
 ( 4,7)( 8,11)(13,15)(17,19)(22,24),( 4,7)( 8,11)(13,15)(17,19)(22,23)
  (28,29),( 2,5)( 7,9)(11,14)(16,19)(20,23),
 ( 1, 4)( 2, 9)( 3,16)( 10,37)( 11,39)( 14,42)( 17,43)( 20,48)
  ( 22,50)( 24,54)( 26,55)( 36,82)( 40,83)( 44,84)( 47,86)( 51,87)
  ( 56,88)( 57,95)( 61,97)( 65,99)( 69,101)( 73,103)( 77,105)( 96,113)
  ( 98,114)(100,115)(102,116)(104,117)(106,118),
 ( 4,7)( 8,11)(14,17)(20,21)(23,26)(30,33)(35,36)(39,40)(44,45)(49,50)
  (52,54)(57,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 4,7)( 8,11)(14,17)(21,23)(24,27)(31,33)(38,39)(45,46)(56,57)(58,59)
  (60,61)(62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)
  (81,82)(84,85)(87,88),( 4,7)( 8,11)(14,17)(21,22)(23,26)(30,32)(39,40)
  (44,45)(47,48)(57,58)(59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)
  (73,74)(75,76)(77,78)(79,80),( 4,7)( 8,11)(14,17)(22,25)(26,27)(36,37)
  (40,41)(43,44)(45,46)(47,49)(50,51)(53,54)(55,57)(58,59)(63,64)(67,68)
  (71,72)(75,76)(79,80)(83,84),( 4,7)( 8,11)(16,19)(20,22)(23,26)(27,30)
  (32,35)(49,50)(53,54)(58,60)(62,64)(66,68)(70,72)(74,76)(78,80),
 ( 2,5)( 7,8)(10,13)(15,17)(31,32)(37,38)(44,45)(49,50)(51,52)(53,54)
  (55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 2,5)( 7,8)(10,13)(23,25)(27,28)(34,35)(40,41)(49,50)(51,52)(53,54)
  (55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 4,7)( 8,11)(17,21)(22,23)(26,28)(29,30)(31,32)(34,36)(37,38),
 ( 4,7)( 8,11)(18,19)(20,23)(28,31)(36,37)(39,40)(43,44)(46,47)(48,50)
  (51,52)(54,55)(56,58)(59,60)(61,62)(65,66)(69,70)(73,74)(77,78)(81,82),
 ( 2,5)( 8,17)(11,26)(12,29)(15,38)(19,41)(20,42)(27,45)(28,46)(35,49)
  (36,50),( 2,5)( 8,14)( 9,15)(10,16)(13,19)(17,20)(18,21),
 ( 2,5)( 8,14)( 9,15)(11,17)(13,19)(16,20)(18,21),
 ( 4,7)( 8,10)(11,14)(15,18)(21,23)(25,26)(29,30),
 ( 3,19)( 6,24)( 9,28)(12,33)(15,38)(16,39)(18,41)(20,43)(22,44)(26,45)
  (29,47)(31,49)(34,50)(36,51)(42,52)(48,53),
 ( 3,19)( 6,23)( 9,28)(12,32)(15,37)(16,39)(18,40)(21,42)(25,43)(27,44)
  (29,45)(31,47)(34,49)(36,50)(41,52)(46,54),
 ( 1,4)( 2,9)( 6,11)( 8,13)(10,14)(12,15),
 ( 2,16)( 3,19)( 4,22)( 5,23)( 6,27)( 7,30)( 8,31)(12,41)(15,43)(17,44)
  (21,46)(24,48)(25,49)(29,51)(32,53)(35,54)(36,55)(37,57)(38,58)(39,60)
  (40,61)(42,63)(45,64)(47,65)(50,66)(52,67)(56,69)(59,71)(62,73)(68,74)
  (70,75)(72,76),( 2,5)( 8,10)(12,13)(14,15)(16,17)(19,20)(21,22),
 ( 2,5)( 8,10)(13,14)(16,17),( 2,16)( 4,22)( 6,27)(11,36)(12,37)(18,42)
  (21,43)(23,46)(24,47)(28,50)(31,55)(33,56)(35,58)(38,59)(41,62)(45,64)
  (48,66)(52,70)(54,71)(57,72)(61,75)(68,78),
 ( 3,4)( 8,9)(13,14)(18,19)(28,29)(36,37)(41,42),
 ( 2,16)( 5,24)( 8,31)(11,39)(13,41)(15,42)(18,43)(19,45)(22,47)(26,48)
  (27,49)(30,50)(32,52)(35,54)(38,55)(46,56)(53,57),
 ( 2,5)( 9,12)(14,17)(19,22)(26,27)(32,33)(40,41),
 ( 1, 7)( 2,13)( 3,18)( 4,21)( 5,25)( 6,28)( 8,34)( 10,36)
  ( 14,38)( 16,40)( 20,46)( 22,48)( 26,52)( 32,56)( 35,57)( 37,59)
  ( 39,60)( 41,61)( 44,64)( 45,65)( 47,68)( 49,70)( 50,72)( 51,74)
  ( 53,76)( 55,78)( 58,80)( 62,82)( 63,83)( 66,84)( 69,86)( 71,89)
  ( 73,91)( 75,93)( 77,94)( 79,95)( 81,97)( 85,100)( 87,101)( 90,103)
  ( 92,106)( 96,109)( 98,112)( 99,114)(102,116)(104,117)(107,119)(108,121)
  (110,124)(111,125)(113,128)(115,130)(118,132)(120,134)(122,136)(126,138)
  (129,140)(131,143)(133,144)(135,147)(137,148)(139,149)(141,150)(145,152)
  (151,154)(153,155),( 2,5)( 9,12)(14,16)(18,20),
 ( 2,5)( 9,11)(14,16)(19,20),( 2,15)( 3,19)( 5,25)( 7,31)( 9,32)
  ( 11,35)( 12,36)( 16,39)( 17,41)( 20,43)( 21,45)( 23,46)( 33,76)
  ( 37,77)( 40,79)( 47,80)( 49,82)( 52,90)( 57,93)( 61,95)( 65,99)
  ( 70,102)( 78,106)( 81,108)( 97,115)(104,117),
 ( 2,15)( 3,19)( 5,23)( 7,28)( 9,46)(12,47)(14,50)(17,51)(18,52)(22,53)
  (25,56)(27,57)(31,59)(36,64)(40,66)(49,70)(55,71)(58,78)(63,79)(65,80),
 ( 4,7)( 8,10)(12,15)(18,20)(22,24),( 1, 4)( 2, 8)( 3,15)( 9,38)
  ( 11,39)( 14,43)( 16,44)( 21,49)( 23,53)( 25,55)( 27,56)( 36,82)
  ( 40,83)( 42,84)( 47,86)( 50,87)( 54,88)( 59,95)( 63,97)( 67,99)
  ( 71,101)( 75,103)( 79,105)( 96,113)( 98,114)(100,115)(102,116)(104,117)
  (106,118),( 2,5)(10,21)(11,24)(12,35)(13,38)(14,42)(22,43)(23,44)(31,45)
  (33,46)(40,47),( 1,4)( 2,8)( 3,14)(10,26)(13,27)(19,30)(21,31),
 ( 2,5)(10,12)(14,16),( 4,7)( 8,10)(13,16)(17,19)(20,23)(24,27)(32,35)
  (51,52)(55,56)(58,60)(62,64)(66,68)(70,72)(74,76)(78,80),
 ( 2, 5)( 10,12)( 17,20)( 21,23)( 28,30)( 41,43)( 47,49)( 50,52)
  ( 55,57)( 59,61)( 62,63)( 64,65)( 67,68)( 69,70)( 71,72)( 74,75)
  ( 76,77)( 79,81)( 86,88)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117),
 ( 4,7)( 8,10)(13,15)(17,20)(22,25)(28,30)(40,42)(45,46)(50,52)(55,56)
  (59,60)(64,65)(69,70)(75,76)(80,81)(85,86),
 ( 2,5)(10,11)(13,15)(18,21)(22,25)(29,31)(38,39)(41,43)(47,49)(51,52)
  (54,55)(57,59)(64,65)(68,70)(72,74)(75,76)(79,80)(84,85)(87,89)(90,92)
  (93,95),( 4,7)( 8,10)(13,15)(19,22)(25,26)(29,30),
 ( 2,5)(11,12)(13,14)(15,16),( 4,7)( 8,9)(10,13)(14,17)(19,20),
 ( 1,7)( 2,12)( 3,20)(10,22)(13,26)(18,29)(27,32)(30,36),
 ( 1,7)( 2,12)( 3,20)( 9,25)(14,27)(19,28)(24,30),
 ( 4,7)( 8,9)(10,13)(15,17)(18,20),( 4,7)( 8,9)(10,13)(15,16)(18,21),
 ( 4,7)( 8,9)(10,12)(13,16)(17,20),( 4,7)( 8,9)(10,12)(13,14)(15,17),
 ( 2,14)( 3,21)( 6,37)( 7,38)(11,42)(17,46)(20,50)(22,51)(25,55)(28,56)
  (30,57)(33,61)(34,62)(39,63)(41,65)(43,66)(49,71)(52,72)(54,74)(60,79)
  (67,80)(75,81),( 1,4)( 2,8)( 6,12)( 9,13)(10,14)(11,16)(15,18)(17,19),
 ( 1,4)( 2,8)( 6,11)( 9,14)(10,15)(12,16)(13,17),
 ( 4,7)( 8,9)(11,14)(15,17)(19,22)(23,25)(33,36)(37,39)(40,41)(44,46)
  (47,49)(51,52)(53,54)(55,57)(58,60)(61,62)(65,67)(69,70)(71,72)(73,75)
  (76,77)(79,80)(82,84)(87,89)(90,91)(92,93),
 ( 1,7)( 2,12)( 3,18)( 4,24)( 5,33)( 6,37)( 9,40)(11,41)(13,44)(16,46)
  (19,48)(21,49)(25,50)(27,53)(29,54)(30,56)(32,58)(35,60)(38,61)(42,63)
  (43,65)(47,66)(51,67)(52,69)(55,70)(59,72)(62,73)(64,74)(68,76)(71,78)
  (75,79)(77,80),( 2,14)( 3,18)( 4,21)( 5,22)( 6,26)( 7,29)( 8,32)(13,42)
  (15,44)(16,45)(20,47)(23,49)(24,50)(28,52)(30,53)(35,54)(36,55)(37,57)
  (38,58)(39,60)(40,61)(41,63)(43,64)(46,65)(48,66)(51,67)(56,69)(59,71)
  (62,73)(68,74)(70,75)(72,76),( 4,7)( 8,9)(13,15)(16,18)(21,24)(25,27)
  (29,30)(32,34)(59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)
  (75,76)(77,78)(79,80)(81,82),( 4, 7)( 9,28)( 25,29)( 27,46)
  ( 31,50)( 32,51)( 35,54)( 37,56)( 39,58)( 41,60)( 43,62)( 44,63)
  ( 47,66)( 48,69)( 55,81)( 59,82)( 67,85)( 70,88)( 71,89)( 74,92)
  ( 75,93)( 77,95)( 80,98)( 83,101)( 84,107)( 86,112)( 87,113)( 90,116)
  ( 91,117)( 94,120)( 96,122)( 97,123)(100,126)(102,128)(104,130)(106,132)
  (108,134)(110,136)(115,137)(119,138)(125,139)(127,141)(129,143)(131,145)
  (133,147)(135,149)(140,152)(142,154)(144,156)(146,158)(148,160)(150,162)
  (153,163)(157,164)(161,165),( 4,7)( 9,20)(10,24)(11,31)(12,34)(14,35)
  (21,36)(23,37)(28,38)(29,39)(44,60)(49,61)(54,62),
 ( 4,7)( 9,18)(10,22)(11,29)(12,32)(14,35)(16,36)(23,37)(30,38)(31,39)
  (46,60)(51,61)(57,62),( 4,7)( 9,14)(10,22)(11,25)(12,34)(15,36)(23,37)
  (24,38)(31,39)(32,40)(42,48)(45,54),( 4,7)( 9,14)(10,21)(11,25)(12,33)
  (16,35)(17,36)(22,37)(24,38)(32,39)(48,60)(53,61)(58,62),
 ( 4,7)( 9,14)(10,20)(11,24)(12,32)(21,34)(23,35)(28,36)(30,37)(38,46)
  (41,53)(45,60)(49,61)(55,62),( 4,7)( 9,13)(10,16)(11,23)(12,26)(18,36)
  (19,37)(24,38)(25,39)(33,40)(34,41),( 2,14)( 3,15)( 6,17)( 7,18)( 9,20)
  (10,21)(12,23)(13,24)(16,25)(19,26)(22,27),( 1,4)( 2,7)( 3,9)( 6,10),
 ( 3,4)( 9,11)(13,15)(17,19)(25,26)(28,29)(32,33)(36,37)(40,41)(44,45),
 ( 1,4)( 2,7)( 5,10)( 8,12)( 9,14),( 2,4)( 5,8)( 9,11)(12,14)(16,18),
 ( 4,7)( 9,12)(13,16)(17,19)(20,23)(28,31)(32,35)(51,52)(55,56)(57,59)
  (61,63)(65,67)(69,71)(73,75)(77,79),( 2,4)( 5,8)(10,13),
 ( 2, 4)( 5, 8)( 10,11)( 12,15)( 19,22)( 30,32)( 33,36)( 37,39)
  ( 41,43)( 47,48)( 49,51)( 52,53)( 54,55)( 57,59)( 61,62)( 63,65)
  ( 66,67)( 68,69)( 71,72)( 73,74)( 77,78)( 79,80)( 81,82)( 83,84)
  ( 87,88)( 89,90)( 92,94)( 96,98)(100,102)(104,106),
 ( 1,2)( 4,5)( 9,10)(12,13)(22,25)(36,39)(43,44)(46,47)(49,50),
 ( 2,4)( 5,7)( 8,10)(11,12)(13,15)(20,22),( 2,4)( 5,7)( 8,10)(12,14),
 ( 4,7)( 9,12)(13,15)(17,19)(23,26)(29,30)(42,43)(46,48)(51,52)(55,57)
  (59,60)(64,65)(69,70)(74,75)(79,80)(84,85),( 2,4)( 5,7)( 8,9)(12,14),
 ( 1, 7)( 2,11)( 3,25)( 4,28)( 5,31)( 36,45)( 38,58)( 40,61)
  ( 43,62)( 46,64)( 48,66)( 51,68)( 53,71)( 55,72)( 56,78)( 73,86)
  ( 75,89)( 77,92)( 79,95)( 81,98)( 83,101)( 85,102)( 88,104)( 91,105)
  ( 94,107)( 97,108)(100,110),( 1, 7)( 2,11)( 3,23)( 4,26)( 5,29)
  ( 36,45)( 39,57)( 40,58)( 42,61)( 46,63)( 47,66)( 51,68)( 52,69)
  ( 54,71)( 55,80)( 72,89)( 75,91)( 78,93)( 81,95)( 84,97)( 87,99)
  ( 88,102)( 90,103)( 92,106)( 94,107)( 96,110)( 98,111),
 ( 3,15)( 6,16)( 7,20)( 8,21)(11,25)(12,26),
 ( 1,7)( 2,11)( 3,21)( 6,23)( 8,24)(13,26)(14,27)(17,29)(19,30),
 ( 1,4)( 2,7)( 6,10)( 8,11),( 3, 4)( 9,10)( 13,14)( 17,18)( 21,22)
  ( 26,28)( 31,32)( 41,42)( 50,51)( 56,57)( 58,59)( 60,62)( 64,66)
  ( 68,69)( 70,72)( 83,84)( 85,86)( 87,88)( 90,91)( 92,93)( 94,95)
  ( 96,97)( 99,100)(101,102)(105,106)(107,108)(109,110),
 ( 2,14)( 5,22)( 8,29)(11,37)(15,41)(18,42)(21,44)(23,46)(26,47)(27,48)
  (31,49)(34,51)(35,53)(38,54)(40,55)(43,56)(50,57),
 ( 3,4)( 9,10)(13,14)(17,18)(27,28)(32,33)(38,39)(41,42)(43,44)(47,48)
  (49,50)(53,54)(55,56)(59,60)(61,62)(67,68)(75,76)(77,78),
 ( 3,4)( 9,10)(13,14)(17,18)(27,28)(32,33)(38,39)(41,42)(43,44)(47,48)
  (49,50)(53,54)(55,56)(59,60)(62,63)(66,67)(68,69),
 ( 1,4)( 2,6)( 3,14)( 7,21)(13,27)(15,30)(20,35)(26,39),
 ( 4,7)( 9,12)(15,17)(19,21)(23,25),( 2,4)( 5,7)(18,19)(21,22)(25,26)
  (31,32)(33,34)(35,36)(37,38)(42,43)(49,50)(51,52)(53,54)(57,58)(59,60)
  (61,62)(64,65),( 2,4)( 5,7)(19,20)(22,23)(26,27)(29,30)(31,32)(37,38)
  (39,40)(41,42)(47,48)(49,50)(52,53)(55,56)(58,59)(62,63)(66,67),
 ( 4,7)( 9,12)(16,18)(19,22)(26,29)(32,35)(37,38)(44,45)(56,57)(58,59)
  (60,61)(62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)
  (81,82)(84,85)(87,88),( 4,7)( 9,12)(16,18)(21,23)(26,27)(30,31),
 ( 4,7)( 9,12)(17,20)(22,24)(26,28)(30,32)(34,36),
 ( 1,4)( 2,6)( 5,10)( 8,13)(11,14),( 2,13)( 3,18)( 6,26)( 8,30)( 9,45)
  (11,46)(14,47)(16,48)(19,51)(21,52)(23,53)(27,54)(28,57)(33,60)(42,68)
  (49,72)(55,73)(61,74)(75,79)(77,80),( 4,7)( 9,11)(12,15)(16,17)(18,21),
 ( 4,7)( 9,11)(12,15)(17,21)(22,25),( 3,4)( 9,10)(14,15)(17,19)(21,22)
  (27,28)(30,31)(34,35)(37,38),( 3, 4)( 9,10)( 14,15)( 17,19)
  ( 22,24)( 29,30)( 38,39)( 42,44)( 45,47)( 49,51)( 53,54)( 55,56)
  ( 60,61)( 62,64)( 66,67)( 69,70)( 72,74)( 76,77)( 78,79)( 82,83)
  ( 84,85)( 86,87)( 90,91)( 92,93)( 95,96)( 98,99)(101,102),
 ( 4,7)( 9,11)(12,14)(15,17)(20,22)(24,25)(26,28)(32,33),
 ( 4,7)( 9,11)(12,14)(15,17)(20,22)(25,26)(27,29)(33,34),
 ( 4, 7)( 9,11)( 12,13)( 14,17)( 18,20)( 21,22)( 23,25)( 26,29)
  ( 30,32)( 33,35)( 36,38)( 41,43)( 44,45)( 47,49)( 50,52)( 53,54)
  ( 59,61)( 62,63)( 64,66)( 67,68)( 72,73)( 81,82)( 84,86)( 90,91)
  ( 92,94)( 95,96)( 97,98)( 99,101)(103,104)(105,107)(109,111)(112,114)
  (116,118),( 4,7)( 9,11)(12,13)(14,16)(19,21)(24,25)(26,28)(31,32),
 ( 4,7)( 9,11)(13,16)(17,20)(21,25),( 1,7)( 2,10)( 3,17)( 4,21)( 5,27)
  ( 6,30)( 9,40)(12,41)(14,45)(16,46)(19,47)(24,49)(26,50)(29,51)(32,55)
  (34,58)(36,60)(37,61)(39,62)(42,65)(43,67)(44,68)(48,69)(52,72)(53,74)
  (54,75)(56,76)(59,77)(63,78)(66,79)(70,80)(73,81),
 ( 2,13)( 3,14)( 5,16)( 6,18)( 7,19)(10,21)(12,24)(15,25)(17,26),
 ( 4,7)( 9,11)(13,16)(17,19)(20,24),( 4,7)( 9,11)(13,16)(18,21)(23,24)
  (29,30)(37,38),( 3,13)( 5,14)( 6,16)( 8,17)(10,19)(12,20),
 ( 4,7)( 9,11)(13,16)(19,21)(25,26)(29,30),
 ( 4,7)( 9,11)(13,15)(16,19)(21,22)(27,28),( 2,4)( 6,9)(10,12)(11,13),
 ( 2,4)( 6,9)(11,14)(16,19)(20,23),( 4,7)( 9,11)(13,15)(16,18)(22,23)
  (28,29),( 2,4)( 6,9)(11,13)(15,18)(20,23),
 ( 4,7)( 9,11)(13,15)(17,20)(22,25)(26,29)(31,34)(36,38)(40,42)(44,47)
  (49,52)(53,56),( 2,13)( 4,17)( 5,21)( 8,29)( 9,47)(11,48)(14,51)(18,52)
  (19,53)(22,54)(24,57)(27,58)(39,62)(45,67)(49,69)(55,70)(59,73)(63,75)
  (64,76)(68,78)(74,81)(77,82),( 3,4)( 9,10)(17,19)(22,24)(26,27)(30,31)
  (33,34)(36,38)(39,41)(42,43)(44,46)(52,53)(61,63)(64,66),
 ( 3,12)( 5,15)( 6,17)( 8,20)(10,21)(16,23),
 ( 2,4)( 6,8)( 9,11)(22,24)(26,28)(33,34)(41,43)(44,46)(48,49)(51,53)
  (57,59)(60,62)(64,65)(66,67)(71,72)(73,75)(76,77)(80,81)(84,85)(88,89),
 ( 4,7)( 9,11)(13,14)(17,19)(21,24)(25,27)(29,31)(50,51)(54,55)(57,58)
  (61,62)(65,66)(69,70)(73,74)(77,78),( 4,7)( 9,11)(14,17)(19,21)(25,26)
  (29,30),( 1,2)( 5,7)( 8,10)(12,15)(16,18)(21,24)(29,31)(33,36)(38,39)
  (42,44)(46,48)(49,51)(52,53)(55,57)(60,61)(64,66)(67,69)(70,72)(73,74)
  (76,78)(80,81)(83,84)(86,87)(89,90),( 4,7)( 9,11)(14,16)(18,20)(22,25),
 ( 1,7)( 2,10)( 4,14)( 5,15)( 8,17)(11,19)(13,20)(16,21)(18,22),
 ( 4, 7)( 9,11)( 14,15)( 16,18)( 20,22)( 24,26)( 27,30)( 31,34)
  ( 36,37)( 42,44)( 49,51)( 52,54)( 60,62)( 63,64)( 65,67)( 72,73)
  ( 75,76)( 79,80)( 82,84)( 86,87)( 88,90)( 91,93)( 94,96)( 98,100),
 ( 4,7)( 9,11)(15,18)(20,21)(22,24)(26,28)(31,33)(44,45)(54,55)(59,60)
  (64,65)(69,70)(74,75)(78,79)(83,84)(86,87)(89,90)(94,95)(97,98),
 ( 4, 7)( 9,11)( 16,19)( 22,24)( 26,27)( 39,40)( 42,44)( 45,46)
  ( 47,49)( 50,52)( 53,55)( 57,58)( 59,61)( 63,64)( 66,67)( 68,70)
  ( 72,73)( 74,76)( 79,81)( 86,88)( 89,91)( 92,94)( 95,97)( 98,100)
  (101,103)(105,106)(108,109)(111,112)(114,115)(117,118)(120,121),
 ( 4,7)( 9,11)(16,18)(20,22)(24,26)(28,30)(32,34)(49,50)(53,54)(58,59)
  (62,63)(66,67)(70,71)(74,75)(78,79),( 4, 7)( 9,11)( 16,17)( 18,21)
  ( 25,27)( 29,30)( 43,44)( 48,49)( 50,51)( 55,56)( 57,58)( 59,60)
  ( 61,62)( 64,65)( 66,67)( 68,69)( 71,72)( 83,84)( 85,86)( 87,88)
  ( 89,90)( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)(101,102)(103,104)
  (105,106),( 1,44)( 3,46)( 5,48)( 7,49)( 9,51)(11,52)(14,54)(16,55)(18,57)
  (20,59)(23,61)(25,63)(27,65)(29,66)(32,68)(34,69)(36,71)(38,72)(40,74)
  (42,76),( 4,7)( 9,10)(12,15)(16,17)(18,21),
 ( 4,7)( 9,10)(12,14)(17,18)(21,23),( 1,4)( 3,9)( 7,10),
 ( 4,7)( 9,10)(13,14)(17,18),( 4,7)( 9,10)(13,14)(18,19),
 ( 1,4)( 3,9)(12,24)(22,36)(26,38)(28,39)(30,45)(40,52)(42,54)(44,56)
  (46,58)(48,60)(50,62)(51,63)(55,65)(59,67),
 ( 1,42)( 2,43)( 5,47)( 8,49)( 9,50)(12,52)(14,55)(17,58)(18,59)(21,61)
  (23,62)(26,66)(29,68)(30,69)(33,71)(36,74)(38,75)(44,76)(53,77)(56,79)
  (63,81)(72,83)(80,85)(84,86),( 4,7)(10,15)(11,26)(12,29)(13,40)(17,42)
  (19,43)(27,44)(28,45)(36,46)(38,47),( 4, 7)( 10,14)( 23,26)( 39,42)
  ( 51,54)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)
  ( 70,71)( 72,73)( 74,75)( 76,77)( 78,79)( 80,81)( 82,83)( 84,85)
  ( 86,87)( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)
  (102,103),( 1,4)( 3,8)( 5,11)( 9,13)(10,15)(12,16)(14,18)(17,19),
 ( 4,7)(10,13)(14,17)(18,20)(21,24)(25,26)(28,29),
 ( 4,7)(10,13)(16,17)(19,22)(26,29)(31,32)(33,36)(38,39)(43,44)(48,49)
  (52,54)(57,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 4,7)(10,13)(17,20)(21,23)(27,30)(32,35)(38,39)(45,46)(56,57)(58,59)
  (60,61)(62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)
  (80,81)(83,84)(86,87),( 2,4)( 6,8)(11,13)(19,21)(27,29)(35,37)(41,43),
 ( 4,7)(10,13)(18,21)(22,23)(30,33)(35,36)(39,40)(42,43)(45,46)(47,49)
  (50,51)(53,54)(55,57)(58,59)(63,64)(67,68)(71,72)(75,76)(79,80)(83,84),
 ( 4,7)(10,12)(13,15)(16,18)(20,21)(25,27)(28,29)(32,34),
 ( 1,4)( 5,19)( 8,23)(10,25)(12,28)(14,30)(17,33)(20,35)(22,36)(27,37)
  (32,39),( 3,4)(10,11)(14,15)(18,19)(22,23)(33,34)(36,37)(40,41)(44,45)
  (46,47)(51,52)(53,54)(58,59)(66,67)(68,69)(70,71)(72,73)(74,75),
 ( 4,7)(10,12)(13,15)(16,17)(20,21)(25,26)(27,28)(31,32),
 ( 4,7)(10,12)(13,14)(16,17),( 2,4)( 6,8)(13,14)(19,21)(23,24)(28,29)
  (33,34)(37,38)(40,41),( 1,41)( 4,43)( 6,46)( 9,49)(12,51)(13,52)(16,55)
  (19,57)(21,58)(24,60)(25,63)(28,66)(31,68)(32,69)(35,73)(37,74)(40,76)
  (44,77)(47,79)(53,80)(61,81)(64,83)(70,84),
 ( 4,7)(10,12)(14,15)(19,22)(24,26)(27,29)(33,34)(44,45)(53,54)(59,60)
  (61,62)(63,64)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(79,80)(81,82)
  (83,84),( 4,7)(10,12)(15,18)(19,21)(23,24)(26,28)(36,38)(40,41)(46,48)
  (50,51)(56,57)(59,61)(63,64)(66,68)(69,70)(72,74)(75,76)(78,80)(82,83)
  (85,87)(88,89)(91,93),( 4, 7)( 10,12)( 18,19)( 20,23)( 28,29)
  ( 43,44)( 46,47)( 49,50)( 51,52)( 54,55)( 56,57)( 58,59)( 60,61)
  ( 62,63)( 64,65)( 66,67)( 68,69)( 73,74)( 79,80)( 84,85)( 86,87)
  ( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107),( 1,41)( 4,42)( 6,45)( 9,48)(12,50)(13,52)(16,55)
  (19,56)(21,58)(24,59)(25,62)(28,65)(30,67)(33,68)(34,70)(37,73)(40,74)
  (44,76)(47,77)(54,79)(61,81)(64,82)(72,84),
 ( 1,41)( 4,42)( 7,46)(11,48)(14,50)(16,54)(19,55)(23,57)(25,60)(28,63)
  (32,65)(35,66)(39,68)(43,70)(47,72)(49,73)(51,74)(52,75)(56,79)(58,80)
  (61,82)(64,83)(67,84)(69,87)(71,88)(76,89)(77,90)(81,92)(85,93)(91,95)
  (94,96),( 4,7)(10,11)(14,17)(21,23)(25,27)(28,31)(40,42)(45,46)(49,51)
  (54,55)(60,61)(65,66)(70,71)(75,76)(80,81)(85,86),
 ( 2,4)( 6,8)(14,15)(20,22)(24,25)(27,29)(31,32)(33,35),
 ( 4,7)(11,14)(15,17)(21,24)(26,29)(30,33)(36,37)(43,44)(56,57)(58,59)
  (60,61)(62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)
  (80,81)(83,84)(86,87),( 4,7)(11,14)(19,22)(25,28)(29,32)(35,36)(40,41)
  (45,46)(48,50)(53,55)(58,59)(60,61)(62,63)(64,65)(66,67)(68,69)(70,71)
  (72,73)(74,75)(76,77)(78,79)(80,81),( 1,39)( 2,41)( 4,44)( 6,45)( 9,46)
  (12,50)(14,54)(17,57)(18,58)(21,60)(24,64)(27,65)(29,69)(30,73)(33,76)
  (35,77)(42,79)(47,80)(51,81)(53,83)(62,85)(66,86)(70,87)(72,89),
 ( 4,7)(11,13)(16,18)(19,22)(25,26)(29,30),
 ( 4,7)(11,13)(16,18)(20,22)(24,26)(28,30),
 ( 2,4)( 6,8)(14,15)(20,22)(25,26)(29,30)(33,34)(37,38)(40,41)(44,45),
 ( 2,4)( 6,8)(14,15)(21,23)(25,26)(28,29)(31,32)(34,35),
 ( 4, 7)( 11,12)( 14,16)( 20,23)( 24,25)( 30,32)( 41,42)( 46,47)
  ( 48,49)( 53,54)( 57,58)( 60,61)( 62,63)( 64,65)( 67,68)( 69,70)
  ( 71,72)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)
  ( 97,98)( 99,100)(101,102)(103,104)(105,106),( 1,4)( 5,10)( 8,13),
 ( 1,39)( 4,41)( 7,42)( 11,46)( 13,48)( 16,49)( 19,53)( 21,57)
  ( 27,58)( 29,61)( 32,63)( 35,65)( 37,68)( 40,73)( 43,74)( 45,77)
  ( 47,79)( 50,80)( 54,83)( 55,84)( 59,86)( 62,89)( 64,91)( 66,92)
  ( 71,93)( 78,95)( 81,96)( 85,98)( 90,99)( 94,100)( 97,101),
 ( 2,4)( 6,8)(14,15)(21,23)(26,27)(29,30)(34,35)(36,37)(38,39),
 ( 2,4)( 6,8)(14,15)(21,23)(26,27)(31,32)(34,35)(36,37)(38,39),
 ( 2,4)( 6,8)(19,21)(22,24)(26,28)(33,34)(40,41)(42,43)(45,47)(48,50)
  (56,57)(58,59)(61,63)(64,66)(69,71)(73,74)(77,79)(80,81)(84,86)(87,88),
 ( 2,24)( 4,25)( 7,26)( 9,27)(12,30)(14,31)(17,32)(18,33)(22,35)(29,36)
  (34,38),( 2,4)( 6,8)(19,21)(24,25)(26,28)(29,30)(33,34)(35,36)(39,40)
  (41,43)(44,45)(47,48)(50,51)(53,54),( 1,38)( 2,41)( 4,42)( 7,46)(10,49)
  (11,50)(14,52)(16,56)(19,59)(22,62)(24,63)(26,67)(30,68)(31,70)(33,74)
  (36,77)(43,78)(48,80)(53,81)(54,84)(64,85)(71,86)(72,89)(83,91)(88,93),
 ( 1,38)( 2,40)( 4,43)( 6,44)( 8,46)( 9,49)(12,51)(14,54)(17,58)(18,59)
  (21,61)(24,64)(25,65)(29,67)(30,70)(33,74)(35,75)(48,78)(53,81)(55,84)
  (69,86)(71,89)(83,91)(88,94),( 4,7)(15,17)(18,21)(23,25)(26,29)(31,32)
  (33,36)(37,38)(39,40)(41,43)(44,45)(46,47)(49,51)(54,55)(56,58)(59,60)
  (61,63)(64,65)(66,67)(70,72)(76,77)(79,81)(82,84)(86,87)(89,91)(92,94),
 ( 4, 7)( 15,17)( 21,23)( 24,27)( 29,31)( 32,35)( 36,37)( 38,40)
  ( 41,42)( 43,45)( 46,47)( 48,49)( 52,54)( 56,57)( 58,60)( 61,62)
  ( 63,64)( 68,70)( 72,73)( 74,75)( 77,78)( 79,80)( 81,82)( 83,84)
  ( 86,87)( 88,89)( 90,91)( 92,94)( 95,96)( 97,99)(100,101)(102,104)
  (105,106)(107,109),( 1,38)( 3,39)( 5,43)( 8,46)( 9,48)(13,49)(14,52)
  (17,54)(20,56)(21,60)(24,63)(26,65)(29,68)(30,70)(32,71)(34,74)(36,76)
  (42,80)(44,82)(59,85)(61,87)(66,89)(78,91)(83,93),
 ( 2,4)( 6,7)( 9,11)(13,15)(17,18)(20,21),( 1,4)( 5,9)(10,12)(11,13),
 ( 1,4)( 5,9)(11,14)(12,15)(13,16),( 1,4)( 5,9)(13,16)(17,21)(25,27)
  (34,36)(41,43),( 3,4)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(26,27),
 ( 2,4)( 7,10)(12,14)(21,23)(24,25)(29,30)(35,36)(43,45)(49,51)(53,54)
  (57,59)(61,62)(67,68)(70,71)(73,74)(75,76)(78,79)(80,81)(82,83)(84,85)
  (86,87)(88,89)(90,91),( 4,6)( 5,7)( 8,10)( 9,14),
 ( 1,38)( 4,41)( 5,43)( 8,47)(11,48)(12,51)(16,53)(17,55)(20,58)(22,60)
  (24,63)(25,67)(27,68)(29,71)(31,73)(32,76)(35,77)(40,80)(44,83)(57,86)
  (62,87)(64,90)(79,91)(85,92),( 2,4)( 7,10)(13,15)(16,19)(22,24),
 ( 4,6)( 7,10)( 8,12)( 9,13)(14,17)(15,19),
 ( 4,6)( 7,10)( 8,11)( 9,13)(14,17)(15,19),
 ( 4,6)( 7,10)(11,14)(15,18)(19,21)(23,25)(26,30)(31,35)(43,45)(48,49)
  (51,53)(56,57),( 2,4)( 7,9)(11,13)(16,17)(20,22),
 ( 1,38)( 4,39)( 6,42)( 9,44)(12,46)(14,49)(16,53)(17,57)(20,58)(22,60)
  (25,61)(26,64)(28,66)(31,68)(34,73)(37,74)(41,76)(50,77)(52,78)(56,82)
  (63,84)(69,85)(72,87)(81,89)(86,92),( 4,6)( 7,10)(11,14)(16,18)(24,25)
  (30,31),( 1,38)( 5,42)( 6,45)( 8,46)(11,50)(12,51)(13,54)(15,55)(18,57)
  (21,61)(22,63)(25,66)(27,67)(30,69)(33,72)(35,73)(39,75)(40,78)(47,80)
  (53,84)(58,86)(59,89)(68,91)(71,95),( 2,11)( 3,13)( 4,14)( 5,17)( 8,19)
  ( 9,21)(10,22)(15,23)(18,24)(20,25),( 4,6)( 7,10)(11,14)(20,22)(23,25)
  (26,29)(39,40)(44,45)(56,57)(58,59)(60,61)(62,63)(64,65)(66,67)(68,69)
  (70,71)(72,73)(74,75)(76,77)(78,79)(81,82)(84,85)(87,88),
 ( 2,4)( 7,9)(12,14)(17,19)(21,23),( 1,37)( 2,40)( 4,42)( 8,43)(10,45)
  (11,47)(13,51)(16,54)(18,57)(20,58)(22,61)(27,64)(29,66)(31,69)(34,72)
  (41,75)(46,76)(48,79)(50,80)(56,84)(62,87)(65,88)(67,91)(71,95)(81,96)
  (92,97),( 1,4)( 5,8)(10,13)(15,18)(20,22),
 ( 2,4)( 7,9)(12,14)(17,19)(28,29)(36,37)(40,41),
 ( 1, 4)( 5, 8)( 11,15)( 18,20)( 21,24)( 28,31)( 38,40)( 43,46)
  ( 47,49)( 51,53)( 54,56)( 59,61)( 63,66)( 68,70)( 71,73)( 75,77)
  ( 80,82)( 84,85)( 86,88)( 90,92)( 94,95)( 96,98)(101,103),
 ( 4,6)( 7,10)(11,13)(16,18)(24,26)(31,33),
 ( 2,8)( 3,9)( 4,10)( 6,13)( 7,14)(12,19)(16,20)(18,21),
 ( 4,6)( 7,10)(11,12)(15,18)(23,24)(26,27),
 ( 1,4)( 5,8)(12,16)(20,23)(26,27)(31,32)(33,34)(36,37)(38,39),
 ( 2,4)( 7,9)(12,14)(20,21)(26,28)(34,36)(44,46)(48,50)(51,53),
 ( 2,4)( 7,9)(12,14)(25,26)(28,29)(33,34)(35,36),
 ( 4,8)( 9,16)(10,20)(11,23)(18,29)(27,30)(28,36)(31,45)(33,47)(35,51)
  (37,54)(40,58)(42,60)(44,65)(48,66)(50,67)(55,68)(57,69)(61,70),
 ( 1,5)( 6,10)(11,14)(15,18)(28,30)(37,39)(44,46),
 ( 1,4)( 5,8)(14,18)(24,26)(27,28)(29,30)(32,34)(35,36)(37,38),
 ( 1,4)( 5,8)(14,18)(24,26)(27,28)(29,30)(32,33)(34,35)(36,37)(40,42)
  (43,44)(45,46),( 4,6)( 7,9)(10,13)(14,16)(17,19),
 ( 4,6)( 7,9)(10,13)(15,18)(24,26)(32,34),
 ( 2,4)( 7,9)(13,14)(16,17)(19,20)(22,23)(24,25),
 ( 1,37)( 4,40)( 7,44)( 9,45)(11,47)(13,49)(16,54)(19,57)(21,58)(23,61)
  (25,63)(28,66)(29,67)(30,69)(34,73)(36,76)(38,77)(43,79)(52,81)(53,84)
  (59,85)(65,87)(71,89)(72,92),( 4,6)( 7,9)(10,12)(13,16)(17,18)(20,22)
  (23,24)(25,28)(29,31)(32,33)(36,38)(39,41)(42,44)(47,48)(52,53)(59,60)
  (63,64)(68,69)(72,73)(75,76)(79,80),( 2,4)( 7,9)(15,16)(20,21)(25,26)
  (27,28)(32,33)(34,35),( 2,4)( 7,9)(18,20)(24,25)(27,28)(32,33)(34,35),
 ( 2,4)( 7,9)(18,20)(24,25)(27,28)(32,33)(38,39)(41,42),
 ( 2,11)( 4,17)( 6,20)( 7,21)( 9,24)(15,26)(23,27)(25,29),
 ( 2,4)( 7,9)(18,20)(25,26)(30,31)(33,34)(36,37)(39,40),
 ( 4,6)( 7,9)(10,12)(15,18)(24,25)(26,27)(30,31)(32,33),
 ( 2,4)( 7,8)( 9,10)(11,12)(14,15)(17,18)(20,21)(24,25),
 ( 4,6)( 7,9)(10,12)(15,16)(17,19)(20,23)(24,25)(26,28)(30,31)(32,35)
  (36,38)(39,41)(42,44)(46,47)(51,52)(55,56)(62,63)(67,68)(72,73)(76,77)
  (79,80),( 1,36)( 6,40)( 8,43)( 12,45)( 13,46)( 15,49)( 17,50)
  ( 19,54)( 21,57)( 23,61)( 26,63)( 28,67)( 29,69)( 31,70)( 34,73)
  ( 38,74)( 39,75)( 52,79)( 53,80)( 56,84)( 58,88)( 65,90)( 77,91)
  ( 78,95)( 82,97)( 83,101)( 86,103)( 93,104)( 99,105),
 ( 1, 4)( 5, 7)( 15,18)( 22,25)( 26,27)( 29,32)( 33,35)( 38,39)
  ( 40,41)( 42,44)( 45,46)( 48,50)( 52,53)( 54,55)( 56,58)( 59,60)
  ( 64,66)( 68,70)( 71,72)( 73,74)( 77,78)( 79,80)( 81,82)( 83,84)
  ( 87,88)( 89,90)( 91,93)( 95,97)( 99,101)(103,105),
 ( 4,6)( 7,9)(10,11)(12,14)(15,18),( 2,4)( 7,8)(11,13)(15,17)(20,22),
 ( 1,4)( 5,6)( 9,11)(12,14)(16,19)(20,22)(25,28)(33,35)(39,40)(42,44)
  (46,47)(48,50)(52,53)(55,57)(60,61)(64,66)(68,69)(71,72)(74,76)(78,79)
  (80,82)(83,84)(86,87)(88,90)(91,92),( 1,4)( 5,6)(11,12)(14,15),
 ( 1,32)( 4,33)( 14,34)( 19,35)( 22,36)( 26,37)( 29,38)( 40,61)
  ( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)( 51,79)( 52,84)( 53,85)
  ( 57,90)( 58,91)( 59,96)( 62,97)( 65,98)( 74,99)( 77,100)( 86,101)
  ( 89,102),( 1,4)( 6,20)( 9,21)(11,23)(13,25)(14,27)(16,29)(17,31)(19,33)
  ,( 2,4)( 7,8)(14,16)(19,21)(26,28)(31,33)(39,41),
 ( 4,6)( 7,9)(10,11)(14,15)(16,19),( 3,4)(13,14)(17,18)(21,22)(24,25)
  (27,28)(30,31)(35,36)(38,39)(44,45)(47,48)(52,53),
 ( 4,6)( 7,9)(11,14)(17,19)(22,24)(28,30)(31,32)(34,35)(36,37),
 ( 4,6)( 7,9)(11,13)(14,16)(17,18)(20,21)(23,24),
 ( 2,4)( 8,11)(12,15)(19,21)(23,25)(29,31)(33,34)(38,40)(41,42)(45,46)
  (48,49)(52,53),( 2,4)( 8,11)(12,15)(20,21)(23,24)(28,29)(32,33)(37,38)
  (40,41)(43,44)(47,48)(53,54),( 3,4)(13,14)(17,18)(28,29)(30,31)(32,33)
  (38,39)(41,42)(45,46)(47,48)(52,53)(55,56)(58,59)(60,61)(65,66)(67,68)
  (71,72)(73,74)(77,78)(79,80)(81,82)(83,84),
 ( 2,4)( 8,10)(11,12)(13,15)(16,18)(19,20)(21,22)(23,24)(25,26),
 ( 3, 4)( 13,14)( 18,19)( 22,23)( 29,30)( 33,34)( 38,39)( 41,42)
  ( 47,48)( 50,51)( 54,55)( 61,62)( 64,65)( 69,70)( 72,73)( 75,76)
  ( 78,79)( 82,83)( 85,86)( 88,89)( 93,94)( 97,98)(101,102)(105,106),
 ( 1,31)( 2,32)( 4,34)( 5,35)( 7,36)( 8,38)(10,39)(11,41)(13,42)(14,44)
  (15,45)(19,46)(23,48)(26,49)(30,51)(33,53)(37,55)(40,56)(43,58)(47,59)
  (50,60)(52,61)(54,62)(57,63),( 4,6)( 7,9)(11,13)(15,17)(18,20)(22,24)
  (26,28)(29,31)(33,34)(36,38)(40,42)(44,45)(47,49)(51,53)(55,56),
 ( 1,31)( 3,34)( 4,35)( 6,36)( 7,38)( 9,40)(10,41)(11,42)(13,44)(14,46)
  (16,47)(18,48)(22,49)(25,50)(29,51)(32,52)(33,53)(37,54)(39,55)(43,56)
  (45,57),( 1,10)( 2,16)( 3,22)( 4,25)( 5,29)( 6,30)( 8,32)
  ( 11,39)( 13,41)( 14,44)( 19,49)( 21,50)( 24,55)( 26,57)( 31,63)
  ( 33,64)( 36,66)( 37,67)( 38,69)( 40,70)( 42,72)( 46,75)( 47,77)
  ( 52,79)( 53,80)( 54,82)( 56,83)( 58,85)( 60,87)( 61,89)( 65,91)
  ( 68,93)( 71,94)( 73,95)( 76,97)( 78,99)( 81,101)( 84,102)( 86,103)
  ( 88,105)( 92,108)( 96,110)(100,113)(104,115),
 ( 2,11)( 5,13)( 6,14)( 7,18)( 8,20)(10,24)(12,25)(15,26)(17,31)(19,32)
  (21,33)(23,34)(28,35)(30,36),( 2,4)( 8,10)(14,15)(17,18)(20,21)(22,23)
  (24,25),( 4,6)( 7,9)(11,12)(14,16)(17,19)(21,23)(25,27)(29,31)(33,34)
  (36,38)(39,41)(43,44)(46,48)(50,52)(54,56),
 ( 4,6)( 7,9)(11,12)(14,16)(18,20)(22,24)(26,28)(29,31)(33,34)(36,38)
  (39,41)(43,45)(47,49)(51,53)(55,56),( 2,4)( 8,9)(11,12)(13,14)(15,16)
  (18,19),( 2,4)( 8,9)(11,12)(13,14)(16,17)(19,20)(21,22)(23,24)(25,26),
 ( 4,6)( 7,9)(12,15)(18,20)(23,24)(28,29)(30,31)(33,34)(35,36),
 ( 2,4)( 8,9)(11,12)(14,15)(16,17)(19,20)(21,22)(23,24)(25,26),
 ( 4,6)( 7,9)(12,13)(16,17)(18,19),( 4,6)( 7,9)(12,13)(16,17)(20,22)
  (24,25)(28,30)(36,38)(42,44)(46,48)(49,51)(53,54)(56,58)(60,62)(63,65)
  (67,68)(69,71)(72,74)(76,77)(81,83)(88,90)(94,96),
 ( 4,6)( 7,9)(13,15)(16,18)(20,22)(23,25)(28,29)(31,33)(59,60)(61,62)
  (63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)(79,80)(81,82),
 ( 1,29)( 2,32)( 3,33)( 4,35)( 6,38)( 7,39)( 9,43)(10,44)(11,53)(12,54)
  (13,56)(15,57)(18,60)(19,61)(20,63)(21,64)(22,67)(24,68)(27,70)(28,71)
  (31,73)(37,74)(42,75),( 1,29)( 2,31)( 4,32)( 5,33)( 7,34)( 8,36)(11,37)
  (14,40)(17,44)(18,45)(19,47)(20,48)(21,49)(22,51)(23,53)(24,54)(25,56)
  (26,58)(27,59)(28,60)(41,62)(42,64)(50,65)(57,66)(61,67)(63,68),
 ( 2,4)( 9,12)(15,17)(18,21)(23,25)(26,28)(31,32)(33,36)(37,39)(41,42)
  (44,45)(47,49)(52,53)(56,58)(60,61)(63,65)(66,67)(69,71)(73,74)(77,78)
  (79,81)(82,83)(85,86)(87,89)(90,91),( 4,6)( 7,9)(17,18)(21,22)(24,25)
  (28,29)(34,35)(36,37)(38,39)(43,44)(45,46)(52,53)(54,55)(56,58)(59,60)
  (61,62)(64,65)(75,76)(79,80)(81,82)(83,84),
 ( 1,29)( 2,30)( 5,32)( 8,34)(11,35)(12,36)(14,38)(15,39)(17,43)(18,45)
  (19,46)(22,48)(23,50)(24,51)(25,52)(28,54)(31,55)(33,56)(37,58)(40,61)
  (41,63)(42,64)(44,66)(47,67)(49,69)(53,72)(57,73)(59,74)(60,76)(62,78)
  (65,79)(68,80)(70,81)(71,82)(75,83)(77,84),
 ( 4,40)( 7,42)( 11,44)( 17,48)( 20,49)( 23,52)( 26,54)( 27,57)
  ( 28,59)( 30,60)( 31,62)( 32,65)( 33,67)( 35,68)( 36,70)( 37,73)
  ( 39,75)( 43,77)( 50,86)( 56,94)( 58,96)( 61,98)( 64,99)( 66,101)
  ( 69,103)( 72,104)( 74,106)( 76,108)( 78,109)( 81,110)( 84,111)( 88,112)
  ( 91,113)( 92,114)( 93,115)( 95,116)( 97,117)(100,118)(102,119)(105,120)
  (107,121),( 4,40)( 7,42)( 12,43)( 16,45)( 18,46)( 21,47)( 24,49)
  ( 27,50)( 28,51)( 30,56)( 31,58)( 32,60)( 33,64)( 34,66)( 35,68)
  ( 36,69)( 38,74)( 41,77)( 52,93)( 53,94)( 57,97)( 61,99)( 65,102)
  ( 70,104)( 71,105)( 75,108)( 79,110)( 82,111)( 84,112)( 86,114)( 87,115)
  ( 89,117)( 90,118)( 92,120)( 95,121)( 98,122)(100,123)(103,124)(106,125)
  (109,126)(113,127)(116,128)(119,129),( 4,40)( 10,44)( 13,45)( 19,48)
  ( 22,49)( 23,52)( 26,54)( 27,57)( 29,58)( 30,60)( 31,61)( 32,64)
  ( 34,65)( 35,67)( 36,68)( 37,71)( 39,72)( 42,77)( 47,83)( 53,92)
  ( 55,94)( 56,95)( 59,98)( 62,100)( 63,101)( 66,104)( 69,106)( 70,107)
  ( 74,109)( 79,110)( 82,112)( 86,113)( 88,115)( 89,116)( 90,117)( 91,118)
  ( 93,120)( 97,122)( 99,124)(103,126)(105,128),
 ( 1,4)( 6,9)(14,16)(18,21)(25,27)(32,34)(37,39),
 ( 4,39)( 7,41)( 9,42)( 12,44)( 15,45)( 18,46)( 21,47)( 27,50)
  ( 29,52)( 30,55)( 31,58)( 32,62)( 33,65)( 34,67)( 36,69)( 37,72)
  ( 38,75)( 51,92)( 54,95)( 57,97)( 61,100)( 64,102)( 68,103)( 71,106)
  ( 74,108)( 79,109)( 82,110)( 83,111)( 85,113)( 86,114)( 88,116)( 89,117)
  ( 91,119)( 93,120)( 94,121)( 96,122)( 98,123)( 99,124)(101,125)(104,126)
  (105,127)(107,128)(112,129)(115,130)(118,131),
 ( 2,4)( 9,10)(12,13)(14,15)(16,17)(19,20)(21,22),
 ( 2,4)( 9,10)(15,17)(19,21)(22,24)(35,37)(40,41)(43,45)(47,49)(50,52)
  (54,55)(56,57)(61,62)(63,65)(66,68)(69,71)(73,74)(75,76),
 ( 1,29)( 3,30)( 5,32)( 8,33)( 9,35)(11,36)(13,38)(16,39)(17,44)(18,45)
  (19,46)(20,47)(21,48)(22,49)(23,51)(24,54)(25,55)(26,57)(27,58)(40,64)
  (41,67)(42,68)(52,69)(53,70)(59,73)(60,75)(61,76)(62,77)(63,78)(66,79)
  (71,81)(72,83),( 4,38)( 6,39)( 9,40)(13,42)(16,43)(19,44)(22,46)(27,47)
  (30,48)(33,49)(35,51)(52,60)(54,63)(55,66)(56,69)(58,72)(59,75)(61,78)
  (67,79)(73,80),( 1,4)( 6,8)(10,13)(14,17)(19,22),
 ( 4,38)( 6,39)(12,40)(15,41)(18,42)(21,43)(24,45)(27,46)(30,47)(32,48)
  (35,50)(51,59)(52,62)(54,65)(55,68)(56,71)(58,74)(60,78)(66,80)(72,82),
 ( 4,6)( 7,8)( 9,10)(14,15),( 2,4)( 9,10)(16,18)(20,22)(24,25)(28,29)
  (31,32)(35,36)(39,40)(43,44),( 4,6)( 7,8)(10,13)(14,15)(20,22)(25,27)
  (29,30)(32,34)(45,46)(47,48)(53,54)(55,56),
 ( 2, 4)( 9,10)( 16,18)( 23,25)( 32,34)( 36,38)( 40,41)( 44,45)
  ( 49,51)( 53,55)( 57,58)( 61,62)( 66,68)( 69,71)( 72,74)( 76,78)
  ( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 95,97)( 98,100)(101,103),
 ( 1,29)( 4,30)( 7,31)(10,32)(11,34)(13,35)(14,36)(16,39)(17,42)(18,43)
  (19,45)(20,46)(21,48)(22,49)(23,50)(24,51)(25,53)(26,54)(27,56)(28,58)
  (40,60)(41,64)(57,68)(61,70)(62,72)(65,74)(66,76),
 ( 1,28)( 2,31)( 4,32)( 5,33)( 7,36)( 8,37)(10,38)(11,41)(13,42)(14,43)
  (15,44)(19,48)(24,53)(25,54)(29,55)(30,56)(34,57)(35,58)(39,59)(40,60)
  (47,64)(50,65)(52,66),( 1,4)( 6,8)(13,16)(19,21)(22,25)(27,29)(30,32)
  (35,36)(37,39)(40,41)(42,44)(45,46)(48,49)(52,54)(56,57)(58,60)(61,63)
  (64,65)(69,70)(74,75)(77,79)(81,83)(85,86)(89,91)(93,95),
 ( 1,4)( 6,8)(13,16)(19,21)(22,25)(27,29)(30,32)(35,36)(37,39)(41,42)
  (43,45)(46,48)(49,51)(54,55)(58,60)(62,63)(64,66)(67,69)(71,73)(76,77)
  (79,80)(82,83)(85,86)(88,89),( 2,4)(10,12)(14,16),
 ( 1,4)( 6,7)( 9,12)(14,16)(30,31)(36,37)(43,44)(49,50)(51,52)(53,54)
  (55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 4,6)( 7,8)(10,11)(13,14)(15,16)(18,19),
 ( 1,4)( 7,11)(12,16)(17,21)(24,27)(31,34)(40,43),
 ( 1,28)( 2,29)( 4,30)( 5,33)( 7,34)( 8,35)(10,38)(11,39)(13,40)(14,43)
  (16,44)(19,47)(20,50)(24,53)(31,56)(32,57)(36,58)(37,59)(41,60)(42,61)
  (49,62)(52,63)(55,64),( 4,6)( 7,8)(11,13)(14,15),
 ( 2,10)( 4,15)( 5,20)( 8,28)(11,45)(13,46)(16,47)(18,48)(21,51)(23,52)
  (25,53)(29,54)(30,57)(34,60)(43,68)(49,72)(55,73)(61,74)(75,79)(77,80),
 ( 4,6)( 7,8)(12,14)(16,18)(19,22)(24,25)(27,29)(39,40)(48,49)(55,57)
  (60,61)(62,64)(66,67)(68,70)(72,73)(74,76)(79,80)(81,83)(85,86)(87,89)
  (91,92),( 4,6)( 7,8)(12,14)(18,20)(22,23)(25,27)(38,39)(42,43)(53,54)
  (62,63)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(78,79)(80,81)(82,83)
  (84,85)(86,87)(88,89)(91,92),( 2,4)(10,12)(15,17),
 ( 4,6)( 7,8)(13,14)(16,18)(20,21)(23,24)(28,29)(37,38)(39,40)(41,42),
 ( 4,6)( 7,8)(13,14)(16,18)(21,22)(24,25)(29,30)(33,34)(36,37),
 ( 4,6)( 7,8)(13,14)(16,18)(21,22)(24,25)(29,30)(34,35)(37,38),
 ( 4,6)( 7,8)(13,14)(16,18)(21,22)(25,26)(31,32)(34,35)(36,37),
 ( 2,4)(10,11)(12,13)(14,15)(16,17)(18,19)(20,21)(22,24)(28,29)(30,31)
  (32,33)(34,35),( 2,4)(10,11)(12,13)(14,15)(16,17)(18,19)(22,24)(26,28),
 ( 1,4)( 7,9)(11,12)(14,15)(17,18)(19,20)(22,23),
 ( 1, 4)( 7, 9)( 11,12)( 17,20)( 27,29)( 33,36)( 38,39)( 43,45)
  ( 47,48)( 50,52)( 55,56)( 61,62)( 63,65)( 66,68)( 71,72)( 73,75)
  ( 77,79)( 81,82)( 85,86)( 87,89)( 91,92)( 96,98)(100,102),
 ( 1,27)( 2,29)( 3,32)( 4,33)( 6,34)( 7,36)( 9,39)(10,41)(11,44)(13,45)
  (14,52)(16,54)(20,56)(22,58)(24,60)(25,62)(30,65)(31,66)(37,67)(38,68)
  (42,69)(43,70),( 4, 6)( 8,28)( 25,29)( 27,35)( 31,50)( 32,51)
  ( 34,53)( 37,56)( 38,57)( 40,59)( 42,61)( 44,63)( 46,65)( 48,78)
  ( 52,81)( 58,82)( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)
  ( 80,98)( 83,102)( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)
  ( 96,122)( 97,123)( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)
  (114,137)(124,138)(126,140)(128,142)(130,144)(132,146)(134,148)(136,150)
  (139,151)(141,153)(143,155)(145,157)(147,159)(149,161)(154,163)(158,164)
  (162,165),( 1, 4)( 7, 9)( 14,16)( 17,20)( 25,27)( 41,43)( 45,47)
  ( 50,52)( 53,55)( 59,61)( 62,63)( 64,65)( 66,67)( 69,70)( 71,72)
  ( 73,74)( 76,77)( 81,83)( 88,90)( 94,95)( 96,97)( 98,99)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117),
 ( 3,8)( 4,10)( 7,12)( 9,14)(11,16),( 1,4)( 7,8)(10,11)(14,15)(16,17)
  (19,20)(22,23),( 2,4)(11,14)(19,20)(22,24)(27,30)(31,34)(38,40)(41,42)
  (44,45)(47,49)(54,55)(58,60)(61,62)(63,65)(70,71)(74,76)(78,80)(82,83)
  (85,87)(89,90),( 2,4)(11,13)(14,17)(20,21)(22,23)(25,26),
 ( 4,36)( 7,38)(10,39)(13,40)(15,41)(17,43)(20,44)(23,45)(27,46)(32,48)
  (49,60)(50,64)(52,68)(53,72)(54,76)(56,80)(61,81)(62,82)(69,83)(70,84)
  (77,85)(78,86),( 1,27)( 3,29)( 4,32)( 5,33)( 6,34)( 7,36)( 9,39)(10,40)
  (12,43)(13,44)(15,50)(16,53)(18,55)(22,58)(24,61)(30,62)(31,64)(37,65)
  (38,67)(41,68)(42,70)(51,72)(56,74)(59,76),
 ( 2,4)(11,12)(13,14)(15,16)(17,18)(19,20)(23,25)(26,27),
 ( 2,4)(11,12)(13,14)(15,16)(17,18)(19,20)(24,26)(27,28),
 ( 1,27)( 3,28)( 4,31)( 5,33)( 7,36)( 8,38)(10,39)(11,40)(12,43)(13,45)
  (15,51)(16,53)(18,55)(20,57)(24,59)(26,61)(29,65)(30,66)(34,67)(35,68)
  (41,69)(42,70),( 2,4)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(27,28),
 ( 1,4)( 8,12)(16,18)(19,22)(24,25)(26,27)(32,33)(34,35)(40,41)(45,46)
  (47,48)(49,50),( 1,4)( 8,12)(18,21)(23,24)(25,26)(27,29)(32,33)(34,36)
  (38,39)(40,41),( 1,4)( 8,11)(12,15)(16,17)(18,21),
 ( 4,6)( 8,11)(13,14)(16,17)(20,23),( 1,27)( 4,29)( 7,31)(10,32)(11,33)
  (13,35)(14,36)(16,37)(17,43)(18,44)(19,45)(21,48)(22,50)(23,51)(24,52)
  (26,55)(28,56)(30,57)(34,59)(38,63)(40,67)(42,69)(46,71)(49,73)(53,75)
  (58,77)(60,78)(61,79)(64,81)(65,82)(68,84)(70,85)(72,86)(74,87)(76,88)
  (80,89)(83,90),( 1,27)( 4,29)( 7,30)(10,32)(11,33)(13,34)(14,37)(16,38)
  (17,43)(18,47)(19,49)(21,50)(22,51)(23,53)(24,55)(26,58)(28,59)(31,60)
  (35,61)(36,62)(39,65)(41,68)(44,69)(45,70)(48,71)(52,72)(54,73)(56,74)
  (63,75)(66,76),( 2,4)(12,13)(18,20)(22,23)(25,27)(38,39)(40,41)(43,44)
  (49,50)(51,52)(53,54)(55,56)(59,60)(61,62)(65,66)(70,71)(72,73)(74,75)
  (81,82)(89,90),( 4,6)( 8,11)(14,15)(17,18)(20,23),
 ( 4,6)( 8,11)(15,17)(20,22)(25,27)(29,31),
 ( 4, 6)( 8,11)( 15,17)( 23,26)( 29,30)( 40,42)( 44,46)( 48,50)
  ( 51,53)( 54,55)( 57,58)( 62,63)( 67,68)( 70,71)( 74,75)( 78,79)
  ( 97,98)(100,101)(103,104)(106,107)(109,110)(112,113),
 ( 4, 6)( 8,11)( 15,16)( 18,20)( 24,27)( 28,29)( 43,44)( 48,49)
  ( 50,51)( 55,56)( 57,58)( 59,60)( 62,63)( 64,65)( 66,67)( 69,70)
  ( 71,72)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)
  ( 97,98)( 99,100)(101,102)(103,104)(105,106),
 ( 2, 4)( 13,15)( 30,32)( 34,35)( 37,39)( 40,42)( 44,45)( 47,49)
  ( 50,52)( 54,55)( 57,59)( 60,62)( 64,65)( 67,69)( 70,72)( 73,75)
  ( 76,78)( 79,81)( 82,84)( 85,87)( 88,90)( 91,93)( 94,96)( 97,99)
  (100,102)(103,105),( 2,4)(15,17)(18,20)(22,24)(29,30)(35,37)(39,40)
  (41,42)(44,46)(47,49)(50,52)(53,54)(58,59)(60,61)(63,65)(66,68)(70,72)
  (74,75),( 4,6)( 8,10)(11,13)(14,17)(18,20),
 ( 4,6)( 8,10)(11,13)(14,16)(19,21)(23,24)(26,27)(28,29),
 ( 2,4)(15,17)(19,21)(23,24)(27,28)(29,31)(32,33)(35,36)(37,38)(39,40)
  (41,42),( 4,35)( 6,37)( 8,39)(10,42)(12,45)(14,47)(16,49)(18,51)(20,54)
  (22,57)(24,59)(26,61)(28,63)(30,66)(32,69),
 ( 4,6)( 8,10)(11,13)(14,15)(18,20)(23,24)(27,28)(29,30),
 ( 1,4)( 8,10)(17,20)(25,26)(28,30)(33,36)(38,40)(42,44)(45,46)(48,49)
  (51,53)(58,59)(62,64)(65,66)(68,69)(75,76)(78,80)(82,84)(85,87)(88,90),
 ( 1,7)( 9,13)(10,16)(11,23)(12,27)(18,35)(19,36)(24,37)(26,38)(33,39)
  (49,60)(54,61)(59,62),( 4,35)( 7,36)( 9,37)(17,38)(25,39)(28,40)(31,41)
  (42,60)(43,63)(45,64)(46,67)(47,68)(50,71)(51,72)(52,75)(54,76)(55,79)
  (56,80)(59,83)(65,84)(66,85)(73,86)(74,87)(81,88)(82,89),
 ( 2,3)( 4,7)( 9,12)(25,26)(29,30)(31,32)(33,34)(35,36),
 ( 2,3)( 4,7)(11,14)(15,18)(22,25),( 4,35)( 7,36)( 12,37)( 14,38)
  ( 17,39)( 23,40)( 26,41)( 32,42)( 43,56)( 45,59)( 46,60)( 48,63)
  ( 51,64)( 53,66)( 55,69)( 61,80)( 65,81)( 70,83)( 71,85)( 72,87)
  ( 75,89)( 76,91)( 77,93)( 82,94)( 84,96)( 86,98)( 88,100)( 90,102)
  ( 92,104)( 97,106)(101,107)(105,108),( 1,4)( 9,22)(10,25)(13,34)(14,37)
  (16,40)(23,43)(24,44)(31,47)(32,48)(39,51),
 ( 1,25)( 3,26)( 6,27)( 8,28)(11,30)(13,32)(16,33)(20,34)(22,36)(29,37)
  (35,38),( 1,25)( 4,29)( 6,30)( 8,34)(11,35)(13,38)(15,47)(16,49)(18,50)
  (19,51)(20,54)(21,56)(22,57)(23,60)(24,61)(26,64)(27,65)(31,66)(32,67)
  (36,68)(39,69)(40,71)(42,72)(43,74)(45,75)(46,76)(48,77)(52,78)(53,79)
  (55,80)(58,81)(59,82)(62,83)(63,84)(70,85)(73,86),
 ( 2,3)( 4,7)(16,17)(21,22)(25,26)(31,32)(33,34)(35,36),
 ( 4,35)( 8,36)( 11,37)( 14,38)( 15,39)( 19,40)( 25,41)( 28,42)
  ( 43,52)( 45,56)( 46,57)( 48,61)( 49,62)( 51,66)( 58,77)( 67,80)
  ( 68,81)( 70,85)( 71,88)( 72,91)( 73,92)( 75,96)( 76,99)( 79,100)
  ( 82,102)( 84,103)( 87,105)( 90,107)( 93,109)( 95,110)( 98,112)(104,114)
  (108,115)(113,116),( 2,10)( 5,32)( 7,35)( 9,37)( 12,38)( 15,42)
  ( 16,43)( 17,44)( 20,47)( 21,49)( 23,51)( 25,55)( 26,56)( 34,83)
  ( 36,84)( 40,86)( 41,87)( 46,88)( 48,89)( 53,91)( 54,92)( 59,99)
  ( 63,101)( 67,102)( 72,104)( 76,106)( 80,107),
 ( 1,24)( 2,28)( 9,39)(11,41)(13,43)(14,44)(15,45)(17,47)(18,51)(20,52)
  (21,53)(22,54)(25,55)(26,56)(27,57)(29,59)(30,63)(32,64)(33,65)(34,66)
  (37,67)(38,68)(40,71)(42,72)(46,75)(48,76)(49,77)(50,78)(58,81)(60,82)
  (61,83)(62,84)(69,85)(70,86)(73,87)(74,88)(79,89)(80,90),
 ( 1,4)( 9,14)(10,24)(11,27)(12,35)(16,37)(18,38)(25,39)(26,40)(31,41)
  (33,42),( 1,4)( 9,13)(10,19)(11,25)(12,32)(14,37)(18,38)(21,39)(27,40)
  (30,41)(35,42),( 4,35)(11,36)(21,37)(24,38)(29,39)(31,40)(41,59)(42,62)
  (43,63)(45,65)(46,67)(48,68)(49,71)(50,72)(51,75)(52,76)(54,78)(55,80)
  (57,81)(58,84)(60,85)(61,86)(69,87)(70,88)(77,89)(79,90),
 ( 1,24)( 2,26)( 3,27)( 4,29)( 6,30)( 7,32)( 9,33)(10,35)(11,36)(12,38)
  (14,40)(15,45)(16,48)(18,53)(20,56)(23,62)(28,65)(34,66)(39,67)(49,79)
  (57,81)(63,83),( 4,34)( 5,36)( 7,38)( 11,41)( 15,44)( 17,45)
  ( 23,49)( 25,55)( 26,56)( 27,60)( 28,63)( 29,68)( 30,69)( 31,71)
  ( 39,74)( 40,75)( 48,79)( 50,82)( 53,84)( 54,87)( 59,91)( 61,94)
  ( 65,97)( 67,99)( 76,104)( 80,105)( 81,116)( 83,125)( 86,127)( 89,129)
  ( 90,130)( 93,132)( 96,134)( 98,135)(101,137)(103,139)(106,146)(108,149)
  (110,152)(112,153)(114,156)(117,159)(119,160)(121,163)(123,166)(126,167)
  (128,168)(131,169)(133,170)(136,171)(138,172)(140,173)(141,174)(142,175)
  (143,176)(144,177)(145,178)(147,179)(150,180)(154,181)(157,182)(161,183)
  (164,184),( 4,6)( 8,10)(12,15)(18,20)(22,23),
 ( 4,6)( 8,10)(12,14)(15,18)(19,22),( 1,24)( 2,25)( 3,28)( 5,29)( 7,30)
  ( 8,33)( 9,34)(10,37)(11,38)(13,39)(15,42)(16,43)(18,46)(20,47)(21,48),
 ( 4,6)( 8,10)(12,14)(15,17)(19,20)(22,24)(25,27)(29,31)(33,35)(37,39)
  (41,42)(44,46)(47,49)(51,52)(54,56),( 2,3)( 4,6)( 9,11)(15,17)(19,21)
  (23,25),( 4,34)( 6,36)( 8,38)(10,41)(12,44)(14,46)(16,48)(18,50)(20,53)
  (22,56)(24,58)(26,60)(28,62)(30,65)(32,68),
 ( 4,6)( 8,10)(12,14)(16,19)(21,23)(24,26)(29,31)(50,52)(55,57)(59,60)
  (63,64)(67,68)(71,72)(75,76)(79,80),( 4,6)( 8,10)(12,14)(16,18)(19,21)
  (23,24)(26,28)(29,31)(33,35)(37,39)(41,43)(45,46)(48,50)(51,53)(55,56),
 ( 2,3)( 4,6)(13,14)(16,17)(19,20),( 1,10)( 3,15)( 4,19)( 6,24)(11,49)
  (13,50)(16,52)(18,54)(20,55)(22,56)(26,57)(28,59)(29,60)(35,61)(42,63)
  (47,65)(53,67)(58,69),( 1, 4)( 9,11)( 13,16)( 17,18)( 21,23)
  ( 24,26)( 28,31)( 32,34)( 37,39)( 40,42)( 43,44)( 46,48)( 50,52)
  ( 54,55)( 56,58)( 59,60)( 62,64)( 67,69)( 71,72)( 75,76)( 79,80)
  ( 84,85)( 88,89)( 91,93)( 94,96)( 97,99)(100,102),
 ( 4,6)( 8,10)(12,14)(16,18)(23,25)(27,30)(32,34)(50,51)(54,55)(58,59)
  (62,63)(66,67)(70,71)(74,75)(78,79),( 2,3)( 4,5)( 6,7)( 8,9)(11,12)
  (13,14)(15,16)(17,18)(20,21)(23,24)(26,27)(28,29)(30,31)(39,40)(41,42)
  (43,44)(45,46)(47,48)(49,50)(51,52)(53,54)(56,57)(58,59)(60,61)(79,80)
  (81,82)(83,84)(86,87)(88,89)(90,91),( 1,24)( 2,25)( 4,26)( 6,27)( 7,30)
  ( 9,32)(11,33)(12,34)(14,35)(16,38)(17,40)(19,41)(20,42)(22,45)(29,46)
  (37,47)(44,48),( 4,6)( 8,10)(12,14)(17,19)(21,22)(25,26)(29,30),
 ( 4,6)( 8,10)(12,14)(17,19)(22,23)(26,28)(31,33)(35,37)(39,41)(44,46)
  (49,50)(53,55),( 4,34)( 7,35)( 9,37)(12,38)(15,39)(19,41)(22,42)(25,43)
  (27,44)(28,46)(31,47)(50,66)(52,69)(55,72)(58,75)(60,78)(63,81)(65,82)
  (71,83)(77,84),( 4,6)( 8,10)(12,14)(19,20)(22,24)(26,28)(30,32)(35,37)
  (39,41)(43,45),( 4,6)( 8,10)(12,14)(19,20)(22,23)(27,28)(30,31)(35,36),
 ( 1,4)( 9,10)(12,14)(17,20)(21,24)(28,30)(38,39)(43,44)(46,48)(50,52)
  (54,55)(57,59)(63,64)(67,69)(70,71)(72,74)(77,78)(80,82)(84,86)(90,91)
  (92,94),( 1,4)( 9,10)(14,15)(18,19),( 4,34)( 7,35)( 9,36)(16,37)(25,38)
  (28,39)(31,40)(42,57)(43,61)(44,62)(46,66)(47,67)(48,71)(50,72)(51,76)
  (52,77)(54,81)(55,82)(56,86)(63,87)(65,88)(73,89)(75,90)(83,91)(85,92),
 ( 4,6)( 8,10)(12,14)(19,20)(23,24)(28,29)(31,32)(36,37)(38,39)(43,44),
 ( 4,34)( 7,35)(10,36)(12,37)(16,39)(19,40)(21,41)(23,42)(25,44)(28,45)
  (31,46)(47,63)(51,66)(53,69)(55,72)(59,75)(61,78)(65,82)(71,84)(77,86),
 ( 4,34)( 7,35)(10,36)(12,37)(19,38)(28,39)(31,40)(42,57)(43,61)(44,62)
  (46,66)(47,67)(48,71)(50,72)(51,76)(52,77)(54,81)(55,82)(56,86)(63,87)
  (65,88)(73,89)(75,90)(83,91)(85,92),( 4,6)( 8,10)(12,14)(20,21)(24,25)
  (28,29)(31,32)(34,35),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)(14,15)(17,18)
  (20,21)(22,23)(25,26)(27,28)(30,31)(39,40)(42,43)(45,46)(48,49)(50,51)
  (53,54)(56,57)(59,60)(62,63)(64,65)(68,69)(70,71)(74,75)(76,77)(80,81)
  (82,83)(86,87)(88,89)(92,93)(94,95),( 2,3)( 4,5)( 7,8)( 9,10)(12,13)
  (14,15)(17,18)(20,21)(22,23)(25,26)(27,28)(30,31)(40,41)(42,43)(45,46)
  (48,49)(51,52)(53,54)(56,57)(59,60)(62,63)(64,65)(68,69)(70,71)(74,75)
  (76,77)(80,81)(82,83)(86,87)(88,89)(92,93)(94,95),
 ( 4,6)( 8,10)(12,13)(15,18)(19,21)(23,25)(29,30)(42,43)(51,52)(55,56)
  (58,60)(61,62)(64,66)(67,68)(71,73)(74,75)(77,79)(80,81)(83,85)(86,87)
  (90,92),( 4,6)( 8,10)(12,13)(15,17)(18,20)(22,24)(26,28)(29,31)(33,35)
  (37,39)(40,42)(44,45)(47,49)(51,53)(55,56),
 ( 2,3)( 4,5)( 7,8)( 9,10)(12,13)(15,16)(17,18)(20,21)(25,26)(28,29)
  (34,35)(36,37)(42,43)(44,45),( 4,6)( 8,10)(12,13)(15,17)(19,21)(23,24)
  (26,28)(29,31)(33,35)(37,39)(40,42)(44,46)(48,50)(51,53)(55,56),
 ( 4,6)( 8,10)(12,13)(15,17)(20,22)(27,28)(29,32)(34,35)(45,46)(47,48)
  (53,54)(55,56),( 4,6)( 8,10)(12,13)(15,17)(21,23)(27,28)(42,43)(53,54)
  (57,58)(62,63)(64,65)(66,67)(68,69)(70,71)(73,74)(75,76)(77,78)(79,80)
  (81,82)(83,84)(86,87)(89,90)(92,93),( 2,3)( 4,5)( 7,8)( 9,10)(13,14)
  (15,16)(19,20)(21,22)(25,26)(27,28),( 4,6)( 8,10)(12,13)(16,17)(25,26)
  (31,32),( 1, 6)( 2,12)( 3,14)( 4,18)( 5,32)( 36,46)( 39,58)
  ( 40,59)( 44,62)( 45,63)( 49,66)( 52,68)( 53,69)( 55,77)( 56,83)
  ( 72,85)( 74,88)( 76,91)( 78,94)( 80,97)( 82,100)( 86,103)( 89,104)
  ( 92,106)( 95,107)( 98,109)(101,110),( 2,9)( 3,12)( 5,14)( 7,17),
 ( 4,34)( 11,35)( 14,36)( 19,37)( 23,38)( 24,39)( 27,40)( 30,41)
  ( 42,58)( 44,61)( 48,63)( 49,64)( 52,67)( 54,68)( 57,71)( 62,80)
  ( 66,81)( 72,82)( 74,84)( 75,86)( 76,88)( 78,90)( 79,92)( 83,95)
  ( 85,97)( 87,99)( 89,101)( 91,103)( 93,105)( 94,106)( 98,107)(102,108),
 ( 2,9)( 3,12)( 5,13)( 7,17)(14,22)(20,24),( 2,9)( 3,12)( 5,13)( 7,16),
 ( 4,33)( 6,34)( 7,35)(10,36)(12,38)(15,39)(18,40)(20,41)(25,43)(28,44)
  (31,45)(49,66)(53,69)(55,72)(58,75)(62,78)(64,81)(70,83)(76,84)(82,85),
 ( 4,6)( 8,10)(12,13)(18,19)(22,23)(28,29)(32,33)(34,35)(36,37),
 ( 2,3)( 4,5)( 7,8)(12,13),( 2,9)( 3,11)( 4,12)( 6,14),
 ( 4,33)( 7,34)( 9,35)( 10,36)( 13,37)( 19,38)( 22,39)( 29,40)
  ( 42,55)( 44,58)( 46,60)( 48,63)( 50,65)( 52,67)( 54,70)( 61,80)
  ( 66,81)( 72,83)( 73,86)( 75,89)( 76,92)( 77,95)( 79,98)( 82,100)
  ( 85,102)( 88,104)( 91,106)( 94,108)( 97,110)(103,112)(107,113)(111,114),
 ( 2,3)( 4,5)( 9,10)(12,13)(14,15)(16,17)(19,20)(21,22)(23,24),
 ( 2,3)( 4,5)( 9,10)(12,13)(18,21)(32,35)(42,43)(45,46)(48,49),
 ( 4,6)( 8,10)(13,15)(17,18)(20,22)(24,25)(28,29),
 ( 1,24)( 3,25)( 6,28)( 7,29)(11,30)(14,31)(16,34)(19,35)(21,36)(27,37)
  (33,38),( 2,3)( 4,5)( 9,10)(14,15),( 4,6)( 8,10)(13,15)(18,20)(22,23)
  (25,27)(34,36)(54,55)(58,59)(60,62)(63,65)(66,68)(69,71)(72,74)(75,77),
 ( 4,6)( 8,10)(13,15)(18,20)(22,23)(26,27)(29,30),
 ( 4,33)( 7,34)(11,35)(14,36)(19,37)(28,38)(31,39)(40,58)(41,62)(42,63)
  (45,67)(46,68)(47,72)(49,73)(50,77)(51,78)(54,82)(55,83)(56,87)(64,88)
  (66,89)(74,90)(76,91)(84,92)(86,93),( 1,24)( 3,25)( 6,26)( 8,28)(11,29)
  (15,31)(17,32)(20,34)(22,35)(27,37)(33,38),
 ( 4,6)( 8,10)(13,14)(16,17)(21,22),( 1,2)( 7,8)(14,15)(17,18)(23,24)
  (26,27)(31,32)(33,34)(38,39)(42,43)(45,46)(47,48)(49,50)(52,53)(58,59)
  (61,62)(64,65)(66,67)(68,69)(74,75)(78,79)(82,83),
 ( 4,6)( 8,10)(13,14)(17,19)(21,23)(26,28)(50,51)(53,55)(59,60)(62,64)
  (65,67)(68,70)(71,73)(74,76)(77,79)(80,82),( 2,9)( 3,10)( 4,11)( 6,12),
 ( 2,3)( 4,5)(12,13)(19,20),( 4,6)( 8,10)(13,14)(17,18)(22,23)(29,30),
 ( 4,6)( 8,10)(13,14)(17,18)(22,23),( 1,24)( 4,25)( 6,28)( 9,29)(10,30)
  (14,31)(17,34)(19,35)(22,36)(27,37)(33,38),
 ( 4,6)( 8,10)(13,14)(18,19)(22,23)(26,28)(42,44)(47,48)(51,53)(56,57)
  (58,60)(63,65)(68,70)(73,75)(78,80)(83,85),
 ( 1,3)( 2,6)( 5,11)( 8,13)( 9,15),( 4,6)( 8,10)(13,14)(19,20)(23,24)
  (28,29)(31,32)(33,34)(35,36),( 1,24)( 4,25)( 6,27)( 9,29)(11,30)(13,31)
  (15,32)(19,35)(22,36)(28,37)(34,38),( 4,6)( 8,10)(14,17)(20,21)(24,27)
  (29,32)(42,43)(46,48)(51,52)(55,57)(59,60)(64,65)(69,70)(74,75)(79,80)
  (84,85),( 4,32)( 5,36)( 8,37)( 14,39)( 20,44)( 25,46)( 26,49)
  ( 27,53)( 28,54)( 29,60)( 30,61)( 31,63)( 38,68)( 47,78)( 48,79)
  ( 51,85)( 52,86)( 56,90)( 57,91)( 58,95)( 59,96)( 64,102)( 65,103)
  ( 69,104)( 72,105)( 73,107)( 74,109)( 75,116)( 76,123)( 80,129)( 81,130)
  ( 82,132)( 83,133)( 87,135)( 88,136)( 92,138)( 93,139)( 97,141)( 98,142)
  ( 99,144)(100,145)(106,152)(108,153)(110,157)(111,158)(112,160)(113,161)
  (114,165)(115,166)(117,170)(118,171)(119,173)(120,174)(121,178)(122,179)
  (124,183)(125,184)(126,186)(127,187)(146,190)(147,193)(148,196)(149,198)
  (150,199)(154,201)(155,202)(162,204)(163,205)(167,207)(168,208)(175,210)
  (176,211)(180,213)(181,214)(188,215)(189,216)(191,217)(192,218)(194,219)
  (195,220),( 4,6)( 8,10)(14,16)(19,21)(22,23)(25,27)(29,31)(33,34)(38,40)
  (41,42)(44,46)(50,51)(54,56)(60,61)(64,65)(67,69)(73,74)(78,79)(83,84)
  (89,90),( 4, 6)( 8,10)( 14,15)( 16,18)( 21,23)( 25,26)( 40,41)
  ( 43,44)( 46,47)( 50,51)( 52,53)( 56,58)( 59,60)( 62,64)( 66,68)
  ( 69,70)( 72,74)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101)
  (103,105)(106,108)(109,111)(112,114)(115,117)(118,120),
 ( 1,6)( 2,11)( 4,23)( 7,24)( 9,25)(12,26),( 2,3)( 5,9)( 6,10),
 ( 2,3)( 5,8)( 9,14)(10,15),( 2,3)( 5,8)( 9,12)(16,19)(21,24),
 ( 1,24)( 4,25)( 6,26)( 9,27)(11,28)(14,32)(16,33)(19,34)(22,35)(29,38)
  (36,39),( 4, 6)( 8,10)( 15,17)( 20,22)( 28,29)( 35,36)( 42,43)
  ( 47,49)( 51,52)( 53,54)( 56,57)( 58,59)( 60,61)( 63,64)( 65,66)
  ( 68,69)( 70,71)( 73,74)( 75,76)( 84,85)( 87,88)( 90,91)( 93,95)
  ( 96,97)( 98,100)(101,102)(104,106)(107,108)(112,113)(115,116)(118,119),
 ( 4, 6)( 8,10)( 15,16)( 18,20)( 23,25)( 26,27)( 39,40)( 43,44)
  ( 46,47)( 49,50)( 53,54)( 55,57)( 59,60)( 61,63)( 65,67)( 69,70)
  ( 71,73)( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)(101,102)(103,105)
  (106,108)(109,111)(112,114)(115,117)(118,120),
 ( 1,24)( 5,26)( 6,27)( 9,28)(11,29)(14,32)(16,33)(19,34)(21,35)(25,37)
  (30,39),( 4, 6)( 8,10)( 16,17)( 19,21)( 25,27)( 32,33)( 42,43)
  ( 47,48)( 51,52)( 53,55)( 60,62)( 63,65)( 69,70)( 74,75)( 79,81)
  ( 88,90)( 98,100)(101,103)(104,106)(108,110)(111,113)(114,116),
 ( 4,6)( 8,10)(16,17)(21,22)(23,24)(26,27)(29,30)(32,33)(36,37)(38,39)
  (40,41)(43,44),( 4,6)( 8,10)(17,19)(21,22)(24,26)(29,31)(34,36)(52,53)
  (56,57)(60,62)(63,65)(66,68)(69,71)(72,74)(75,77),
 ( 1,3)( 2,5)( 4,9)(10,13)(12,14),( 4,6)( 8,10)(17,18)(21,22)(23,25)
  (27,28)(29,31)(32,33)(34,35)(37,38),( 2,3)( 5,7)(10,12)(15,16)(18,19)
  (20,21),( 4,6)( 8,9)(10,13)(15,16)(18,20)(22,24)(31,33)(45,46)(47,48)
  (52,53)(54,55)(56,57)(73,74)(77,78),( 4,6)( 8,9)(10,12)(13,15)(16,17)
  (18,20)(21,22)(23,24)(25,26),( 1,23)( 2,25)( 4,28)( 5,29)( 7,30)( 8,32)
  (10,35)(12,36)(13,37)(15,38)(17,40)(18,43)(20,44)(22,45)(26,46)(33,47)
  (41,48),( 2,3)( 5,7)(11,13)(16,17)(19,20)(22,23),
 ( 1,23)( 2,25)( 4,27)( 6,28)( 7,29)( 9,31)(10,33)(12,35)(13,36)(14,37)
  (16,39)(18,41)(19,43)(21,44)(24,46)(30,48)(38,50),
 ( 1,23)( 2,25)( 4,26)( 5,27)( 6,29)( 8,31)(10,33)(11,34)(13,35)(15,37)
  (16,39)(18,41)(20,42)(21,44)(28,46)(36,47)(43,48),( 2,3)( 5,7)(12,14),
 ( 2,9)( 4,13)(14,16)(24,31)(28,32)(29,36)(30,42)(33,45)(35,47)(37,49)
  (39,51)(41,53)(43,55)(46,57)(50,58)(54,59),
 ( 4,6)( 8,9)(11,13)(14,16)(18,20)(22,24)(25,27)(29,31)(33,35)(36,38)
  (40,41)(43,45)(47,49)(51,52)(54,56),( 2,3)( 5,7)(15,17)(25,26)(29,30)
  (31,32)(33,34)(35,36),( 4,6)( 8,9)(11,13)(14,16)(18,19)(21,23)(25,27)
  (29,31)(33,35)(36,38)(40,41)(43,45)(46,48)(50,52)(54,56),
 ( 1,23)( 2,24)( 4,27)( 6,29)( 7,30)( 9,31)(10,34)(12,36)(13,37)(14,38)
  (16,39)(18,42)(19,44)(21,45)(25,46)(32,47)(40,48),
 ( 1,3)( 2,4)( 7,12)( 8,14)(11,15)(13,16),
 ( 2,3)( 5,6)( 7,8)( 9,10)(11,12)(14,15)(16,17)(18,19)(20,21)(23,24)
  (25,26)(27,28)(30,31)(39,40)(41,42)(44,45)(46,47)(48,49)(50,51)(52,53)
  (54,55)(56,57)(58,59)(60,61)(78,79)(80,81)(82,83)(85,86)(87,88)(89,90),
 ( 2,9)( 4,12)( 6,14)( 8,18)(16,23)(20,25)(22,26),
 ( 4,30)( 7,31)( 9,32)( 11,33)( 15,34)( 18,35)( 24,36)( 27,37)
  ( 38,53)( 40,58)( 41,59)( 44,64)( 46,67)( 48,68)( 52,73)( 66,84)
  ( 72,85)( 75,86)( 77,89)( 78,92)( 80,95)( 82,98)( 83,101)( 88,106)
  ( 91,109)( 94,112)( 97,115)(100,118)(103,121)(105,122)(111,123)(117,124),
 ( 1,23)( 2,24)( 4,26)( 5,27)( 7,28)( 8,29)( 9,30)(11,33)(12,34)(14,35)
  (15,37)(18,41)(20,51)(25,59)(31,61)(32,62)(36,64)(39,71)(43,73)(45,75)
  (49,77)(52,79)(54,81)(57,83)(60,85)(63,86)(65,87)(72,95)(76,97)(82,99),
 ( 2,3)( 5,6)( 7,8)(10,11)(12,13)(15,16)(18,19)(20,21)(22,23)(27,28)
  (30,31)(36,37)(39,40)(44,45),( 2,3)( 5,6)( 7,8)(10,11)(12,13)(15,16)
  (18,19)(20,21)(23,24)(25,26)(28,29)(30,31)(39,40)(42,43)(45,46)(48,49)
  (50,51)(53,54)(56,57)(59,60)(62,63)(64,65)(68,69)(70,71)(74,75)(76,77)
  (80,81)(82,83)(86,87)(88,89)(92,93)(94,95),
 ( 4,6)( 8,9)(11,13)(24,26)(34,35)(38,39)(44,45)(47,49)(50,51)(54,55)
  (58,59)(61,63)(64,65)(66,67)(69,70)(71,72)(74,75)(78,79)(80,81)(82,83)
  (86,87)(88,89),( 2,3)( 5,6)( 7,8)(10,11)(12,13),
 ( 1,3)( 4,11)( 7,13)( 8,14)( 9,15)(10,16)(12,17),
 ( 1,23)( 3,27)( 5,28)( 6,29)( 8,32)(10,33)(12,34)(13,35)(15,36)(17,40)
  (18,41)(20,42)(22,43)(24,44)(26,45)(31,47)(37,49)(39,50)(46,52)(48,53)
  (51,54),( 4,6)( 8,9)(11,12)(14,15)(17,18)(19,20)(22,23),
 ( 2,9)( 4,11)( 5,14)( 7,16)(15,22)(19,24),
 ( 2,3)( 5,6)( 7,8)(11,12)(18,19)(23,24),
 ( 1,6)( 2,9)( 3,20)( 4,30)( 8,41)(10,42)(12,45)(13,47)(17,48)(19,49)
  (21,51)(23,52)(25,53)(27,54)(28,57)(32,59)(33,60)(35,61)(37,63)(39,65)
  (40,66)(43,67)(44,68)(46,69)(50,71)(55,72)(56,73)(58,74)(62,76)(64,77)
  (70,78)(75,79),( 4, 6)( 8, 9)( 12,15)( 21,23)( 27,30)( 40,41)
  ( 42,44)( 45,47)( 49,51)( 53,55)( 58,59)( 61,62)( 66,67)( 71,72)
  ( 76,77)( 80,81)( 96,97)( 99,100)(102,103)(105,106)(108,109)(111,112),
 ( 2,3)( 5,6)( 8,10)(12,14),( 1,23)( 3,26)( 4,27)( 6,30)( 7,32)( 8,33)
  ( 9,34)(10,37)(12,39)(13,40)(16,43)(17,48)(18,53)(20,57)(22,62)(24,65)
  (25,67)(28,68)(29,70)(35,71)(36,73)(45,84)(50,88)(59,92),
 ( 4,29)( 6,30)( 8,31)( 12,32)( 15,33)( 21,34)( 24,35)( 37,60)
  ( 39,61)( 42,64)( 44,65)( 47,67)( 50,68)( 55,71)( 56,72)( 57,74)
  ( 66,88)( 70,89)( 77,90)( 79,92)( 80,94)( 83,96)( 85,98)( 86,100)
  ( 91,105)( 93,107)( 95,109)( 97,111)( 99,113)(101,115)(104,116)(108,117)
  (112,118),( 1,23)( 3,26)( 4,27)( 6,28)( 7,30)( 9,33)(11,34)(12,35)(14,36)
  (16,38)(17,41)(19,42)(21,43)(22,44)(24,46)(31,47)(39,48),
 ( 2,3)( 5,6)( 8,9)(10,11)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26)
  (30,31)(32,33)(39,40)(41,42),( 1,23)( 3,26)( 4,27)( 6,28)( 8,32)( 9,33)
  (11,34)(13,35)(14,36)(16,40)(18,41)(19,42)(21,43)(24,45)(29,47)(31,48)
  (37,50)(39,51)(44,52)(46,53)(49,54),( 1,23)( 3,26)( 5,28)( 6,29)( 8,30)
  ( 9,33)(11,35)(12,36)(13,37)(15,38)(17,41)(18,43)(20,44)(22,45)(24,46)
  (31,47)(39,48),( 4,29)( 7,30)( 9,31)( 12,32)( 15,33)( 17,34)
  ( 19,35)( 21,37)( 23,38)( 25,39)( 27,40)( 42,55)( 44,61)( 50,68)
  ( 56,81)( 62,83)( 69,85)( 75,90)( 76,92)( 77,96)( 78,98)( 79,102)
  ( 80,104),( 1,3)( 4,10)( 7,12)( 8,13)( 9,14)(11,16)(15,18)(17,19),
 ( 1,3)( 4,10)( 7,12)( 8,13)( 9,14)(11,15)(16,19)(17,20)(18,21),
 ( 2,3)( 5,6)( 8,9)(11,12)(17,18)(23,24),
 ( 1,3)( 4,10)( 7,11)( 8,13)( 9,15)(12,17)(14,18)(16,19),
 ( 1,3)( 4,10)( 7,11)( 9,12),( 1,23)( 3,25)( 4,27)( 6,28)( 7,29)( 9,32)
  (11,34)(12,35)(14,36)(16,38)(17,40)(19,42)(21,43)(22,44)(26,46)(33,47)
  (41,48),( 4,6)( 8,9)(13,14)(19,21)(25,26)(29,30),
 ( 1,3)( 4,10)(11,14)(12,15),( 1,23)( 3,25)( 4,26)( 5,27)( 7,30)( 9,31)
  (10,33)(12,34)(14,35)(15,38)(16,39)(18,41)(20,42)(22,45)(29,46)(37,47)
  (44,48),( 4,6)( 8,9)(14,15)(16,18)(20,21)(26,27)(30,31)(34,35)(36,37),
 ( 2,3)( 5,6)( 9,10)(11,12)(16,17)(26,27)(29,30),
 ( 1,3)( 4,9)( 6,11)( 8,12)(10,13)(14,16)(15,17),
 ( 2,3)( 5,6)( 9,10)(12,13)(16,18)(21,23),
 ( 4,6)( 8,9)(15,16)(17,19)(21,23)(26,27)(31,32)(34,36)(39,40)(44,45)
  (49,50)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76),
 ( 4,6)( 8,9)(15,16)(19,21)(24,25)(30,31)(33,35)(39,40)(44,45)(48,49)
  (52,54)(57,59)(61,62)(64,65)(67,68)(70,71)(73,74)(76,77),
 ( 4,6)( 8,9)(15,16)(19,21)(24,25)(30,31)(33,35)(39,40)(44,45)(48,49)
  (53,54)(58,59)(61,63)(64,66)(67,69)(70,72)(73,75)(76,78),
 ( 4,6)( 8,9)(16,18)(20,22)(29,30)(35,36)(40,41)(45,46)(49,50)(51,52)
  (53,55)(57,58)(59,60)(61,63)(64,66)(67,69)(70,72)(73,75)(76,78)(79,81),
 ( 4,6)( 8,9)(16,18)(27,28)(34,35)(38,39)(43,44)(48,49)(50,51)(52,53)
  (54,55)(57,58)(59,60)(61,62)(63,64)(65,66)(68,69)(71,72)(74,75)(77,78)
  (80,81),( 4,6)( 8,9)(17,19)(21,23)(29,30)(35,36)(39,40)(44,45)(48,49)
  (50,51)(53,55)(56,57)(58,59)(61,63)(65,66)(68,69)(71,72)(74,75)(77,78)
  (80,81),( 2,3)( 5,6)( 9,10)(14,15)(17,18),
 ( 2,3)( 5,6)( 9,10)(15,16)(17,18)(21,22)(24,25),
 ( 2,3)( 5,6)( 9,10)(19,20)(22,23)(26,27)(38,39)(44,45)(47,48)(53,54)
  (55,56)(62,63)(65,66)(69,70)(71,72)(75,76)(79,80)(81,82)(85,86),
 ( 4,6)( 9,12)(13,16)(17,19)(20,23)(25,26)(29,30),
 ( 4,6)( 9,12)(13,15)(16,18)(21,23),( 4,6)( 9,12)(14,16)(17,19)(21,22)
  (23,25)(29,31)(34,35)(36,37),( 2,3)( 5,6)(10,11)(13,14)(19,20)(26,27)
  (31,32)(34,35)(38,39)(43,44)(45,46)(48,49)(50,51)(53,54)(57,58)(61,62)
  (64,65)(66,67)(69,70)(73,74)(77,78)(81,82)(84,85)(88,89),
 ( 4,6)( 9,12)(15,17)(18,20)(22,23)(24,25)(29,30)(33,34)(35,36),
 ( 3,6)( 4,7)( 8,12)(10,14),( 4,6)( 9,11)(12,14)(15,16)(18,19)(20,22)
  (24,25)(34,36)(38,39)(41,43)(45,46)(48,50)(52,53)(55,57)(59,60)(62,64)
  (66,67)(69,71)(73,74)(76,77)(80,81)(82,83)(86,87)(88,89)(92,93),
 ( 4,6)( 9,11)(12,14)(16,19)(20,23),( 1, 3)( 4, 7)( 9,10)( 11,14)
  ( 18,21)( 29,31)( 32,35)( 38,40)( 44,45)( 46,48)( 49,50)( 51,52)
  ( 54,56)( 58,59)( 60,62)( 63,64)( 65,66)( 68,70)( 71,72)( 73,74)
  ( 77,78)( 79,80)( 81,82)( 83,84)( 87,88)( 89,90)( 92,94)( 96,98)
  (100,102)(104,106),( 2,3)( 5,6)(10,11)(15,16),
 ( 1,3)( 4,7)(10,12)(13,16)(20,21)(23,24)(26,27),
 ( 4,6)( 9,11)(12,14)(16,18),( 2,9)( 5,18)( 7,20)(11,22)(13,24)(16,26)
  (19,28)(21,29)(23,31)(25,32)(27,34),( 1,23)( 3,24)( 5,27)( 6,29)( 8,30)
  ( 9,31)(11,34)(12,36)(13,37)(15,38)(17,39)(18,42)(20,44)(22,45)(26,46)
  (33,47)(41,48),( 2,3)( 5,6)(11,12)(14,15)(19,20)(21,22)(26,27)(29,30)
  (35,36)(42,43)(45,46)(51,52)(55,56)(57,58)(59,60)(62,63)(68,69)(72,73)
  (74,75)(76,77)(79,80)(81,82)(84,85),( 2,3)( 5,6)(11,12)(14,15)(21,22)
  (27,28)(30,31)(35,36)(37,38)(42,43)(45,46)(47,48)(50,51)(53,54)(57,58)
  (60,61)(63,64)(65,66)(69,70)(73,74)(77,78)(83,84),
 ( 4,6)( 9,11)(13,15)(16,17)(19,22)(26,28)(30,33)(49,50)(53,54)(58,59)
  (63,64)(68,69)(73,74)(79,80)(82,83)(87,88)(90,91)(93,94)(98,99),
 ( 4,6)( 9,11)(13,15)(17,20)(21,24),( 4, 6)( 9,11)( 13,15)( 17,19)
  ( 21,23)( 26,28)( 29,30)( 34,35)( 38,39)( 44,46)( 55,57)( 59,60)
  ( 65,66)( 69,71)( 73,74)( 80,82)( 86,87)( 88,90)( 92,93)( 94,96)
  ( 97,98)( 99,101)(103,104)(105,106)(107,108)(109,110)(111,112),
 ( 4, 6)( 9,11)( 13,15)( 17,19)( 21,23)( 26,28)( 32,33)( 36,37)
  ( 41,42)( 49,51)( 53,54)( 56,58)( 61,62)( 67,68)( 70,72)( 75,77)
  ( 87,89)( 90,91)( 92,94)( 95,96)( 98,100)(101,102)(103,104)(105,106)
  (107,108)(109,110)(111,112),( 2,3)( 5,6)(11,12)(18,19)(21,22)(27,28)
  (30,31)(35,36)(37,38)(42,43)(45,46)(47,48)(51,52)(57,58)(60,61)(63,64)
  (65,66)(69,70)(73,74)(75,76)(77,78)(81,82)(83,84),
 ( 4,6)( 9,11)(13,15)(17,19)(22,24)(27,28)(31,33)(36,38)(40,42)(44,46)
  (49,51)(54,55),( 4,6)( 9,11)(13,15)(17,19)(23,25)(29,30)(47,48)(51,52)
  (55,56)(59,60)(61,63)(65,67)(69,71)(73,75)(77,79)(81,83),
 ( 4, 6)( 9,11)( 13,15)( 18,20)( 22,23)( 27,29)( 34,35)( 40,41)
  ( 45,46)( 48,49)( 53,54)( 59,60)( 62,63)( 65,66)( 68,69)( 71,72)
  ( 74,75)( 89,90)( 92,93)( 94,95)( 97,98)( 99,100)(102,103),
 ( 4, 6)( 9,11)( 13,15)( 18,20)( 22,23)( 27,29)( 38,39)( 44,45)
  ( 47,48)( 53,54)( 58,59)( 62,63)( 65,66)( 68,69)( 71,72)( 83,84)
  ( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)( 96,97)( 98,99)(101,102)
  (105,106)(107,108)(109,110),( 2,3)( 5,6)(15,16)(19,20)(22,23)(26,27)
  (38,39)(43,44)(46,47)(51,52)(53,54)(55,56)(61,62)(64,65)(69,70)(71,72)
  (79,80)(85,86),( 2,3)( 5,6)(15,16)(19,20)(22,23)(26,27)(38,39)(43,44)
  (47,48)(49,50)(51,52)(56,57)(59,60)(64,65)(66,67)(70,71)(76,77)(78,79)
  (86,87),( 4,6)( 9,11)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26),
 ( 1,3)( 4,6)( 9,10)(11,14)(16,18)(23,26)(29,31)(32,35)(39,40)(42,44)
  (46,47)(48,50)(51,53)(55,57)(60,61)(62,64)(65,67)(68,69)(71,73)(75,76)
  (78,79)(82,84)(86,87)(90,92)(94,95)(97,98),
 ( 4,6)( 9,11)(13,14)(16,18)(24,26)(28,30)(32,34)(52,53)(57,58)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78),( 4,25)( 5,26)( 9,27)( 12,28)
  ( 18,29)( 19,30)( 22,31)( 32,51)( 34,54)( 37,59)( 39,60)( 42,66)
  ( 44,67)( 46,70)( 58,83)( 65,84)( 72,87)( 73,89)( 76,96)( 77,100)
  ( 79,105)( 82,109)( 88,117)( 90,119)( 92,120)( 97,122)( 98,124)(101,126)
  (106,128)(107,130)(110,132)(112,133)(116,140)(121,141)(127,142)(143,160)
  (145,161)(148,163)(151,164)(153,166)(156,167),
 ( 1,3)( 4,6)(10,12)(15,16),( 4,6)( 9,11)(13,14)(16,17)(21,23)(26,28),
 ( 3,6)( 7,10)(11,14)(18,22)(23,25)(28,29)(30,32)(36,37)(38,40)(44,45),
 ( 2,3)( 6,9)(12,15)(16,19)(25,27)(28,31)(37,40)(41,43)(45,46)(48,49)
  (52,53)(55,56)(59,60)(62,63),( 2,3)( 6,9)(12,15)(16,18)(19,22)(28,31)
  (32,34)(40,43)(46,47)(49,50)(53,54)(56,57)(60,61)(63,64),
 ( 4,6)( 9,11)(14,17)(20,22)(25,27)(29,31),
 ( 2,3)( 6,9)(13,15)(16,18)(23,24),( 4,6)( 9,11)(14,16)(18,20)(23,25)
  (30,32)(38,40),( 1,23)( 3,24)( 6,25)( 8,26)(11,30)(13,31)(16,32)(19,33)
  (20,37)(27,38)(34,39),( 4,6)( 9,11)(14,16)(18,19)(21,23)(25,26)(28,29),
 ( 2,3)( 6,8)(10,12)(15,17)(20,22),( 1, 9)( 2,14)( 3,17)( 4,22)
  ( 5,26)( 6,29)( 8,35)( 10,37)( 18,42)( 20,44)( 23,49)( 25,51)
  ( 30,55)( 32,56)( 34,58)( 36,61)( 38,63)( 40,66)( 41,67)( 43,70)
  ( 45,72)( 48,74)( 50,75)( 52,77)( 53,78)( 54,80)( 57,81)( 59,83)
  ( 62,84)( 64,86)( 65,87)( 68,89)( 71,90)( 73,92)( 76,93)( 79,95)
  ( 82,97)( 85,99)( 88,100)( 91,103)( 94,105)( 96,107)( 98,109)(101,112)
  (102,114)(104,116)(106,117)(108,118)(110,120)(111,121)(113,123)(115,124)
  (119,125)(122,126),( 2,3)( 6,8)(11,13)(14,15)(18,19)(22,23),
 ( 4,7)(13,14)(17,18)(20,21)(24,25)(27,28)(32,33)(35,36)(37,38)(39,40)
  (46,47)(48,49)(53,54)(55,56),( 1,23)( 4,26)( 5,27)( 8,28)(10,29)(13,33)
  (15,34)(18,35)(20,36)(24,38)(30,40),( 4,6)( 9,11)(14,16)(19,21)(24,25)
  (28,29)(36,37),( 3,6)( 7,9)(12,15)(16,18)(19,20)(22,23)(25,26),
 ( 1,23)( 4,25)( 7,26)( 9,28)(12,31)(14,33)(17,34)(19,35)(24,37)(29,40)
  (32,42)(38,43)(41,44),( 2,3)( 6,8)(12,14)(16,17)(19,20)(22,23),
 ( 2,3)( 6,8)(12,13)(18,20)(24,26)(29,30)(32,33)(35,36),
 ( 1,23)( 4,24)( 6,28)( 9,29)(13,30)(16,34)(18,35)(21,36)(25,37)(26,38)
  (31,39)(32,40),( 2,3)( 6,8)(13,14)(15,18)(22,24),
 ( 1,23)( 4,24)( 6,26)( 8,29)(10,30)(13,31)(16,33)(18,36)(21,37)(27,38)
  (34,39),( 1,3)( 4,5)(14,15)(19,20),( 4,6)( 9,11)(14,15)(17,18)(21,23)
  (27,29),( 4,6)( 9,11)(14,15)(18,20)(22,23)(25,26)(28,29),
 ( 2,3)( 6,7)( 8,10)(11,12)(13,15)(16,18)(20,21)(22,24)(25,26)(28,30)
  (31,33)(34,35)(36,38)(39,41)(43,44)(45,47)(48,49)(51,53),
 ( 1,23)( 4,24)( 6,25)( 9,29)(11,30)(14,31)(18,34)(21,35)(26,36)(27,37)
  (32,39)(38,41)(40,42),( 1,23)( 4,24)( 6,25)( 9,29)(12,30)(13,31)(16,32)
  (18,36)(21,37)(26,38)(33,39),( 2, 3)( 6, 7)( 8, 9)( 11,13)
  ( 14,15)( 16,18)( 20,22)( 23,25)( 26,27)( 28,30)( 32,34)( 35,37)
  ( 38,39)( 40,41)( 43,45)( 46,48)( 49,51)( 52,53)( 54,55)( 56,58)
  ( 59,60)( 61,63)( 64,66)( 67,68)( 70,72)( 73,74)( 75,76)( 77,79)
  ( 80,81)( 83,85)( 87,89)( 90,91)( 93,95)( 96,98)(100,102)(103,105)
  (106,107)(108,109)(110,111)(112,113)(114,115),
 ( 1,23)( 4,24)( 6,25)( 9,27)(11,30)(13,31)(15,32)(18,33)(21,36)(28,37)
  (34,39),( 4,6)( 9,11)(15,18)(20,23)(24,25)(28,29),
 ( 2,3)( 6,7)( 8,9)(11,12)(16,19)(30,33)(42,43)(45,46)(48,49),
 ( 1,23)( 4,24)( 7,28)( 9,29)(13,30)(16,33)(18,35)(21,36)(25,37)(27,38)
  (31,39)(34,40),( 4,6)( 9,11)(15,17)(20,22)(26,27),
 ( 1,23)( 4,24)( 8,26)(11,27)(13,28)(16,32)(18,33)(21,34)(25,37)(29,40)
  (30,41)(35,42)(38,43),( 1,3)( 5,10)( 7,13)( 8,14)( 9,15)(11,16)(12,17),
 ( 1,23)( 5,26)( 8,27)(10,28)(13,32)(15,33)(18,34)(20,35)(25,37)(30,39)
  (31,40)(36,41)(38,42),( 4,6)( 9,11)(15,16)(20,22)(26,28)(30,32)(45,46)
  (49,50)(53,54)(57,58)(62,64)(66,68)(70,72)(74,76)(78,80)(82,84),
 ( 4, 6)( 9,11)( 16,18)( 19,21)( 25,27)( 42,44)( 45,47)( 48,50)
  ( 51,53)( 55,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)
  ( 70,71)( 74,76)( 79,81)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107),
 ( 2,3)( 6,7)( 9,10)(13,14)(23,24)(26,27)(30,31)(45,46)(48,49)(54,55)
  (56,57)(63,64)(66,67)(70,71)(72,73)(75,76)(79,80)(81,82)(85,86),
 ( 4, 6)( 9,11)( 17,19)( 23,25)( 26,28)( 42,44)( 46,48)( 49,51)
  ( 52,54)( 55,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)
  ( 70,71)( 72,74)( 77,79)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107),
 ( 2,3)( 6,7)( 9,10)(13,14),( 2,3)( 6,7)( 9,10)(14,15)(17,18)(24,25)
  (35,36)(39,40)(43,44)(45,46)(47,48)(49,50)(52,53)(54,55)(56,57)(61,62)
  (63,64)(65,66)(68,69)(70,71)(74,75)(79,80)(81,82)(86,87)(91,92)(93,94),
 ( 4,6)( 7,10)(11,13)(17,19)(25,26)(31,32),
 ( 1,22)( 2,25)( 3,26)( 4,27)( 5,28)( 7,31)( 9,34)(10,35)(12,36)(14,37)
  (15,40)(17,43)(19,44)(20,45)(21,46),( 2,3)( 6,7)( 9,10)(19,20)(23,24)
  (26,27)(30,31)(44,45)(47,48)(52,53)(54,55)(56,57)(62,63)(65,66)(70,71)
  (72,73)(79,80)(85,86),( 4,6)( 9,10)(12,14)(15,16)(17,18),
 ( 4,6)( 9,10)(12,14)(15,16)(18,19)(20,22)(23,25)(35,36)(38,40)(42,43)
  (45,47)(49,50)(52,54)(56,57)(59,61)(63,64)(66,68)(70,71)(73,75)(76,77)
  (80,81)(82,83)(86,87)(88,89)(92,93),( 4,6)( 9,10)(12,14)(17,19)(21,22)
  (26,27)(30,31),( 1,6)( 4,11)(12,24)(22,32)(26,34)(28,36)(30,42)(37,49)
  (39,51)(41,53)(43,55)(45,57)(47,59)(48,60)(52,62)(56,64),
 ( 1,3)( 5,8)(10,12)(14,17)(19,22),( 2,3)( 6,7)(10,11)(14,15)(17,18)
  (20,21),( 2,3)( 6,7)(10,11)(14,15)(17,18)(22,23)(25,26),
 ( 4,6)( 9,10)(12,14)(18,19)(24,25)(27,29)(41,42)(45,47)(51,52)(55,57)
  (58,60)(64,66)(69,71)(74,76)(80,82)(85,87),
 ( 1,3)( 5,7)( 8,10)(21,23)(25,27)(32,33)(41,43)(44,46)(48,49)(51,53)
  (57,59)(60,62)(64,65)(66,67)(71,72)(73,75)(76,77)(80,81)(84,85)(88,89),
 ( 4,6)( 9,10)(13,16)(17,19)(22,23)(25,26),
 ( 4,6)( 9,10)(13,15)(17,19)(21,24),( 1,22)( 3,25)( 4,28)( 6,29)( 8,30)
  ( 9,33)(11,36)(12,37)(14,38)(16,41)(17,42)(19,45)(21,46)(24,47)(27,48)
  (32,49)(35,50)(40,51)(44,52),( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)
  (33,34)(36,37)(39,40),( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(33,34)
  (36,37),( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(34,35)(37,38)(39,40),
 ( 4,6)( 9,10)(13,15)(18,20)(22,24)(26,28)(31,33)(36,37)(40,42)(45,47)
  (49,51)(53,55),( 4,6)( 9,10)(13,15)(18,20)(22,23)(26,27)(29,30),
 ( 2,3)( 6,7)(10,11)(14,15)(26,27)(29,30)(34,35)(37,38)(42,43)(45,46)
  (48,49)(50,51),( 4,6)( 9,10)(13,15)(19,20)(21,22),
 ( 1,3)( 5,7)( 9,11)(16,17)(25,26)(31,32)(33,34)(36,37)(39,40),
 ( 4,6)( 9,10)(13,14)(16,18)(21,22)(28,29),
 ( 1,3)( 5,7)( 9,11)(17,18)(25,26)(28,30)(33,34)(35,37),
 ( 4,6)( 9,10)(13,14)(17,19)(20,22)(24,26)(32,34)(37,38)(40,42)(44,45)
  (47,49)(50,52)(54,56)(59,60)(62,64)(65,67)(68,69)(71,73)(74,76)(80,82)
  (87,89)(93,95),( 1,3)( 5,7)( 9,11)(17,18)(25,26)(29,30)(33,34)(37,38)
  (43,44)(45,46)(47,48)(49,50),( 1,3)( 5,7)( 9,11)(17,18)(26,27)(29,30)
  (32,33)(35,36),( 2,3)( 6,7)(10,11)(15,16)(29,30)(36,37)(43,44)(49,50)
  (51,52)(53,54)(55,56)(57,58)(59,60)(61,62)(63,64)(65,66),
 ( 2,3)( 6,7)(10,11)(16,17)(18,19),( 1,22)( 3,23)( 4,25)( 5,28)( 6,29)
  ( 7,30)( 9,32)(10,35)(12,36)(13,39)(14,46)(16,51)(18,55)(20,60)(21,66)
  (26,68)(27,69)(33,71)(34,72)(37,74)(38,75)(50,84)(59,87)(65,90),
 ( 2,3)( 6,7)(10,11)(20,21)(25,26)(28,29)(31,32)(34,35),
 ( 2,3)( 6,7)(10,11)(20,21)(25,26)(28,29)(33,34)(36,37)(39,40)(43,44)
  (48,49)(51,52),( 4,6)( 9,10)(14,15)(18,19)(22,24),
 ( 2,3)( 6,7)(10,11)(20,21)(25,26)(28,29)(34,35)(37,38)(39,40),
 ( 4,6)( 9,10)(15,17)(19,20)(22,23)(26,27)(29,30)(33,34)(35,36)(37,38)
  (39,40),( 4,6)( 9,10)(15,16)(17,19)(21,22)(26,27)(29,30)(33,34)(35,36),
 ( 4,6)( 9,10)(15,16)(17,19)(22,23)(24,25)(28,29)(31,32),
 ( 2,3)( 6,7)(10,11)(21,22)(26,27)(28,29)(33,34)(36,37)(38,39),
 ( 4, 6)( 10,28)( 26,29)( 27,33)( 30,49)( 32,51)( 35,54)( 36,55)
  ( 38,57)( 40,59)( 42,61)( 44,63)( 47,66)( 48,78)( 58,81)( 62,82)
  ( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)( 80,98)( 83,102)
  ( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)( 96,122)( 97,123)
  ( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)(116,137)(120,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,151)(141,153)
  (143,155)(145,157)(147,159)(149,161)(152,163)(156,164)(160,165),
 ( 4, 6)( 10,28)( 26,29)( 27,31)( 30,49)( 33,52)( 34,53)( 36,55)
  ( 38,57)( 40,59)( 42,61)( 45,64)( 46,65)( 48,78)( 56,81)( 60,82)
  ( 67,85)( 70,88)( 72,90)( 73,91)( 76,94)( 77,95)( 80,98)( 83,102)
  ( 84,108)( 86,112)( 87,113)( 89,115)( 92,118)( 93,119)( 96,122)( 97,123)
  ( 99,125)(101,127)(103,129)(105,131)(107,133)(109,135)(116,137)(120,138)
  (126,140)(128,142)(130,144)(132,146)(134,148)(136,150)(139,151)(141,153)
  (143,155)(145,157)(147,159)(149,161)(152,163)(156,164)(160,165),
 ( 4,6)(10,22)(11,25)(12,34)(13,37)(15,39)(16,40)(23,43)(24,44)(31,47)
  (32,48),( 2,8)( 4,11)( 5,13)( 7,15)(10,18),
 ( 4,6)(10,13)(14,15)(19,22)(25,28)(29,32)(37,38)(42,43)(47,48)(57,58)
  (59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)
  (79,80),( 3, 5)( 6, 9)( 11,13)( 14,16)( 19,20)( 21,24)( 26,28)
  ( 33,36)( 37,38)( 40,42)( 45,47)( 49,50)( 51,53)( 54,55)( 57,59)
  ( 61,63)( 65,66)( 67,69)( 70,72)( 74,75)( 78,79)( 83,84)( 87,88)
  ( 91,93)( 94,96)( 97,99)(100,102),( 4,6)(10,13)(15,16)(17,19)(21,23)
  (26,28)(30,33)(44,45)(54,55)(59,60)(64,65)(69,70)(74,75)(78,79)(83,84)
  (86,87)(89,90)(94,95)(97,98),( 4, 6)( 10,13)( 16,19)( 20,22)
  ( 24,26)( 27,30)( 31,34)( 36,37)( 39,40)( 41,43)( 46,47)( 50,51)
  ( 53,55)( 58,59)( 61,62)( 64,65)( 67,69)( 72,73)( 78,79)( 81,82)
  ( 87,88)( 92,93)( 97,98)(104,105)(108,109)(114,115),
 ( 4,6)(10,12)(13,16)(17,19)(21,22)(27,28),
 ( 1,3)( 5,7)(13,14)(19,21)(24,25)(27,29)(31,32)(33,35),
 ( 4,6)(10,12)(13,15)(18,20)(21,24)(28,30)(44,46)(48,49)(54,56)(58,59)
  (60,61)(62,63)(64,65)(66,67)(68,69)(70,71)(73,74)(75,76)(77,78)(79,80)
  (81,82)(83,84),( 1,3)( 5,7)(13,14)(19,21)(24,25)(27,29)(33,35)(37,38)
  (39,40),( 1,3)( 5,7)(13,14)(19,21)(24,25)(27,28)(32,33)(35,36)(41,42)
  (45,46)(47,48)(49,50),( 4,6)(10,12)(15,17)(18,20)(22,25)(27,29)(31,33)
  (48,50)(53,55)(59,60)(63,64)(67,68)(71,72)(75,76)(79,80),
 ( 1,3)( 5,7)(13,14)(20,22)(25,26)(28,29)(31,32)(34,35),
 ( 2,3)( 6,7)(11,12)(16,17)(29,30)(37,38)(44,45),
 ( 2,3)( 6,7)(11,12)(18,19)(26,27)(33,34),
 ( 2,3)( 6,7)(11,12)(19,20)(28,29)(36,37)(42,43),
 ( 4,6)(10,12)(16,18)(21,22)(24,26)(34,36)(38,39)(42,43)(49,51)(55,56)
  (62,63)(64,65)(67,68)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)(83,84)
  (85,86)(87,88)(90,91)(93,94),( 2,3)( 6,7)(12,14)(17,19),
 ( 1,3)( 5,7)(15,16)(24,25)(26,27)(29,30)(31,32)(33,34)(36,37)(40,41)
  (42,43)(45,46),( 2,3)( 6,7)(12,13)(15,16)(17,18),
 ( 1,22)( 4,23)( 6,26)( 9,29)(13,30)(15,33)(17,36)(20,37)(24,38)(25,39)
  (31,40)(32,41),( 4,6)(10,11)(12,13)(16,18)(20,21)(24,26),
 ( 2,3)( 6,7)(12,13)(16,17)(19,20)(27,28)(29,30)(43,44)(54,55)(61,62)
  (65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)(91,92)
  (95,96),( 4,6)(10,11)(13,15)(17,19)(21,22)(23,25)(28,30)(34,36)(38,40)
  (43,44)(48,50)(52,53)(56,57)(61,63)(66,67)(71,73)(75,76)(80,81)(86,87)
  (91,92),( 4,6)(10,11)(13,15)(17,18)(19,21)(28,30)(44,46)(50,51)(52,54)
  (55,57)(62,64)(67,69)(73,74)(77,78)(82,84)(85,87)(88,90)(91,93)(94,96)
  (97,99),( 4, 6)( 10,11)( 13,15)( 18,20)( 22,24)( 27,29)( 31,32)
  ( 36,37)( 42,43)( 52,53)( 57,58)( 59,60)( 62,63)( 65,66)( 68,69)
  ( 71,72)( 74,75)( 89,90)( 92,93)( 94,95)( 97,98)( 99,100)(102,103),
 ( 2, 3)( 6, 7)( 14,15)( 20,21)( 29,30)( 40,41)( 44,45)( 46,47)
  ( 50,51)( 54,55)( 56,57)( 60,61)( 63,64)( 65,66)( 69,70)( 71,72)
  ( 75,76)( 80,81)( 86,87)( 91,92)( 94,95)( 97,98)(100,101)(103,104)
  (106,107)(110,111)(113,114)(116,117)(119,120)(122,123)(125,126),
 ( 2,3)( 6,7)(14,15)(21,22)(24,25)(27,28)(31,32),
 ( 1,3)( 5,6)( 8,10)(12,14)(18,20)(22,24)(26,28)(30,32),
 ( 1,3)( 5,6)( 8,10)(12,14),( 3,5)( 6,7)( 8,10)(11,13)(14,16),
 ( 1,3)( 5,6)( 8,10)(13,15),( 2,8)( 4,9)( 5,11)( 6,12),
 ( 2,3)( 6,7)(16,17)(21,22)(26,27)(29,30)(32,33)(34,35),
 ( 4, 6)( 10,11)( 14,15)( 18,19)( 22,23)( 28,29)( 33,34)( 43,44)
  ( 46,47)( 52,53)( 59,61)( 62,63)( 65,67)( 69,71)( 72,73)( 83,84)
  ( 85,86)( 87,88)( 89,90)( 91,92)( 94,95)( 96,97)( 98,99)(100,101)
  (105,106)(107,108)(109,110),( 1, 5)( 2,19)( 3,26)( 4,35)( 7,37)
  ( 9,41)( 11,42)( 16,47)( 17,49)( 21,52)( 23,53)( 25,56)( 36,84)
  ( 40,85)( 44,88)( 48,89)( 55,91)( 62,98)( 66,100)( 70,101)( 74,102)
  ( 78,103)( 83,104)( 87,105)( 90,107),( 4,6)(10,11)(15,17)(19,21)(22,24)
  (27,28)(38,39)(42,43)(54,55)(62,63)(64,65)(66,67)(69,70)(71,72)(73,74)
  (75,76)(77,78)(79,80)(82,83)(84,85)(86,87)(89,90)(92,93),
 ( 2,3)( 6,7)(18,19)(22,23)(25,26)(29,30)(39,40)(45,46)(47,48)(52,53)
  (55,56)(61,62)(63,64)(65,66)(71,72)(74,75)(76,77)(80,81),
 ( 2,3)( 6,7)(18,19)(22,23)(25,26)(35,36)(39,40)(43,44)(45,46)(47,48)
  (52,53)(60,61)(62,63)(64,65)(69,70)(72,73)(78,79)(82,83),
 ( 4,6)(10,11)(17,19)(21,23)(31,32)(36,37)(41,42)(45,46)(48,50)(52,53)
  (54,55)(56,58)(60,61)(62,63)(64,65)(67,68)(70,71)(73,74)(76,77)(79,80),
 ( 4,6)(10,11)(17,19)(21,23)(31,32)(39,40)(44,45)(47,49)(51,52)(53,54)
  (55,57)(59,60)(61,62)(63,64)(66,67)(69,70)(72,73)(75,76)(78,79)(81,82)
  (83,84)(85,86),( 1,3)( 6,11)( 7,13)( 8,15)( 9,17)(10,18)(12,19)(14,20)
  (16,21),( 4, 6)( 10,11)( 17,18)( 21,22)( 29,30)( 38,39)( 45,46)
  ( 48,49)( 51,52)( 54,55)( 57,58)( 60,61)( 62,63)( 65,66)( 68,69)
  ( 82,83)( 86,87)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117)
  (118,119)(120,121)(134,135)(136,137)(138,139)(140,141)(142,143)(144,145),
 ( 2, 3)( 7, 9)( 10,12)( 15,18)( 19,20)( 25,29)( 31,33)( 38,39)
  ( 44,46)( 49,50)( 51,52)( 54,55)( 57,60)( 64,65)( 71,72)( 83,84)
  ( 89,90)( 94,97)( 99,100)(103,104)(107,108)(110,111)(114,115)(123,124)
  (126,127),( 4, 6)( 11,14)( 17,19)( 21,22)( 25,28)( 39,40)( 42,44)
  ( 45,46)( 47,49)( 50,52)( 53,55)( 57,58)( 59,61)( 63,64)( 66,67)
  ( 68,70)( 72,73)( 74,76)( 79,81)( 86,88)( 89,91)( 92,94)( 95,97)
  ( 98,100)(101,103)(105,106)(108,109)(111,112)(114,115)(117,118)(120,121),
 ( 2,8)( 4,9)( 7,11)(10,15)(12,17),( 1,21)( 5,22)( 8,25)(10,28)(13,31)
  (16,32)(19,37)(20,39)(23,40)(27,41)(30,42)(33,43)(36,44),
 ( 2,3)( 7,9)(12,14)(18,19),( 4, 6)( 11,13)( 19,20)( 25,27)( 37,38)
  ( 40,41)( 43,44)( 47,48)( 50,52)( 54,55)( 56,57)( 60,61)( 62,63)
  ( 64,65)( 66,67)( 68,69)( 70,71)( 72,73)( 74,76)( 80,82)( 89,90)
  ( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)(103,104)(105,106)(107,108)
  (109,110)(111,112)(113,114),( 4, 6)( 11,13)( 19,20)( 25,27)( 38,39)
  ( 41,42)( 44,45)( 48,49)( 51,53)( 55,56)( 57,58)( 60,61)( 62,63)
  ( 64,65)( 66,67)( 68,69)( 70,71)( 72,73)( 75,77)( 81,83)( 89,90)
  ( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)(103,104)(105,106)(107,108)
  (109,110)(111,112)(113,114),( 2,3)( 7,9)(13,14)(19,20)(23,25)(26,28)
  (29,31),( 4, 6)( 11,12)( 13,16)( 20,22)( 24,25)( 29,32)( 43,44)
  ( 48,49)( 50,51)( 55,56)( 57,58)( 59,60)( 61,62)( 64,65)( 66,67)
  ( 68,69)( 71,72)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)( 99,100)(101,102)(103,104)(105,106),
 ( 2,3)( 7,9)(14,15)(17,18)(20,21)(23,24)(25,26),
 ( 2,3)( 7,9)(16,19)(20,21)(22,24)(29,33)(34,36)(37,39)(41,42)(44,47)
  (53,54)(56,59)(61,62)(67,68)(71,72),( 1,20)( 2,22)( 3,24)( 4,25)( 5,26)
  ( 6,27)( 7,29)( 8,30)( 9,31)(18,32)(19,34),
 ( 1, 3)( 6, 9)( 14,16)( 21,24)( 25,27)( 41,43)( 47,49)( 50,52)
  ( 55,57)( 59,61)( 62,63)( 64,65)( 67,68)( 69,70)( 71,72)( 74,75)
  ( 76,77)( 79,81)( 86,88)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117),
 ( 2,8)( 5,12)( 6,15)( 9,17)(13,19),( 4,6)(11,12)(14,15)(18,19)(21,22)
  (25,26),( 2,3)( 7,8)( 9,10)(14,15)(17,18)(23,24)(26,27)(33,34)(39,40)
  (41,42)(47,48)(49,50)(51,52)(54,55)(57,58)(63,64)(66,67)(68,69)(70,71)
  (73,74)(77,78)(81,82),( 4, 6)( 11,12)( 16,18)( 32,33)( 36,37)
  ( 38,39)( 43,44)( 47,49)( 50,51)( 52,53)( 54,56)( 57,58)( 59,60)
  ( 61,62)( 64,65)( 66,67)( 68,69)( 80,81)( 82,83)( 84,85)( 87,88)
  ( 90,91)( 92,93)( 95,96)( 97,98)(100,101)(102,103)(105,106)(107,108)
  (110,111)(115,116)(117,118)(120,121)(124,125)(126,127)(130,131)(133,134)
  (136,137)(139,140)(142,143)(145,146)(148,149)(155,156)(158,159)(162,163)
  (166,167)(169,170)(173,174),( 2,3)( 7,8)( 9,10)(14,15)(17,18)(23,24)
  (26,27)(33,34)(39,40)(42,43)(46,47)(50,51)(52,53)(55,56)(58,59)(64,65)
  (68,69)(70,71)(73,74)(77,78)(79,80)(83,84)(85,86),
 ( 4,6)(11,12)(16,17)(19,21)(25,26)(29,30),
 ( 4, 6)( 11,12)( 18,20)( 25,27)( 38,39)( 40,41)( 43,45)( 47,48)
  ( 51,52)( 54,55)( 57,58)( 60,61)( 62,63)( 64,65)( 66,67)( 68,69)
  ( 70,71)( 72,73)( 77,79)( 83,85)( 89,90)( 91,92)( 93,94)( 95,96)
  ( 97,98)( 99,100)(103,104)(105,106)(107,108)(109,110)(111,112)(113,114),
 ( 2,3)( 7,8)(10,11)(12,13)(38,39)(40,41)(42,43)(44,45)(46,47)(48,49),
 ( 2,3)( 7,8)(10,11)(13,15)(16,18)(19,21)(24,26)(28,30),
 ( 2,3)( 7,8)(10,11)(13,14)(16,17)(19,20),
 ( 1,3)( 6,8)(11,13)(16,18)(20,22),( 4, 6)( 12,13)( 19,21)( 28,29)
  ( 31,32)( 35,36)( 37,38)( 39,40)( 42,43)( 46,48)( 52,53)( 58,59)
  ( 65,66)( 71,72)( 73,74)( 75,76)( 77,78)( 79,80)( 81,82)( 83,84)
  ( 89,90)( 92,93)( 95,96)( 98,99)(101,102)(104,105)(107,108)(110,111)
  (113,114)(115,116)(118,119)(125,126)(128,129)(131,132)(134,135)(137,138)
  (140,141),( 4,6)(13,16)(21,22)(24,26)(29,32)(33,36)(37,39)(41,43)(44,45)
  (47,48)(50,52)(57,58)(61,63)(64,65)(67,68)(74,75)(78,80)(82,84)(85,87)
  (88,90),( 2, 3)( 7, 8)( 10,11)( 14,15)( 17,18)( 28,29)( 35,36)
  ( 38,39)( 42,43)( 46,47)( 49,50)( 51,52)( 55,56)( 57,58)( 59,60)
  ( 62,63)( 64,65)( 66,67)( 68,69)( 71,72)( 73,74)( 76,77)( 81,82)
  ( 83,84)( 86,87)( 89,90)( 96,97)(100,101),
 ( 3,5)( 7,9)(12,15)(16,18)(21,24),( 4,6)(13,15)(17,19)(21,22)(24,27)
  (28,29)(31,33)(42,43)(44,45)(46,47)(51,52)(53,54)(73,74)(77,78),
 ( 1,2)(11,12)(15,16),( 4, 6)( 13,15)( 20,21)( 34,35)( 39,40)
  ( 43,44)( 46,47)( 48,49)( 52,53)( 54,55)( 57,58)( 60,61)( 63,64)
  ( 69,70)( 75,76)( 78,79)( 80,81)( 83,84)( 85,86)( 88,89)( 90,91)
  ( 92,93)( 95,96)( 98,99)(100,101)(102,103)(104,105)(107,108)(109,110)
  (112,113)(114,115)(117,118)(119,120)(121,122)(124,125)(126,127)(128,129)
  (130,131)(133,134)(135,136)(138,139)(141,142)(144,145)(146,147)(149,150)
  (152,153)(158,159)(160,162)(164,166)(168,169)(170,172)(174,176)(178,179)
  (180,182)(184,186)(188,189)(191,192)(194,195)(196,197)(198,199)(200,201)
  (202,203)(204,205)(206,207)(208,209)(210,211),
 ( 4,6)(13,14)(15,17)(19,20)(21,23)(25,26)(27,29)(30,31)(34,35)(37,38),
 ( 2,3)( 7,8)(10,11)(15,16)(18,19)(23,24)(30,31)(36,37)(39,40)(43,44)
  (46,47)(50,51)(53,54)(55,56)(58,59)(61,62)(66,67)(69,70)(71,72)(74,75)
  (79,80)(81,82)(87,88)(89,90),( 4, 6)( 13,14)( 16,18)( 22,23)
  ( 38,39)( 40,41)( 46,47)( 48,49)( 53,54)( 56,57)( 58,59)( 60,61)
  ( 62,63)( 64,65)( 66,67)( 69,70)( 73,74)( 79,80)( 81,82)( 86,87)
  ( 89,90)( 91,92)( 93,94)( 96,97)( 98,99)(100,101)(102,103)(104,105)
  (106,107)(108,109)(110,111)(112,113)(115,116)(117,118)(119,120)(121,122),
 ( 1,2)(11,12)(17,18)(21,22)(28,29)(32,33)(37,38)(40,41)(42,43)(47,48)
  (50,51)(55,56)(58,59)(61,62)(65,66)(68,69)(75,76)(82,83)(87,88),
 ( 3,5)( 7,9)(12,13)(20,21)(25,26)(27,28)(31,32),
 ( 4, 6)( 14,15)( 17,19)( 23,25)( 26,28)( 43,44)( 45,47)( 49,50)
  ( 51,52)( 54,55)( 56,57)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 72,73)( 78,79)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105)(106,107),
 ( 2,3)( 7,8)(11,12)(14,15)(16,17)(19,20)(21,22)(23,24),
 ( 1,20)( 3,23)( 4,25)( 5,28)( 6,30)( 7,32)( 8,35)(10,37)(11,40)(12,42)
  (13,44)(14,47)(15,49)(17,52)(18,54),( 2,3)( 7,8)(11,12)(14,15)(17,18)
  (19,20)(21,22)(23,24)(27,28)(29,30),( 4,5)( 6,10)(16,18)(21,25)(34,35)
  (37,39)(42,43)(45,47)(51,53)(54,56)(59,61)(62,64)(67,69)(70,72)(75,77)
  (78,80)(83,85)(86,88)(91,93)(94,96),( 1,20)( 3,21)( 6,24)( 7,27)(11,30)
  (14,32)(15,35)(17,38)(23,39)(26,40)(31,42)(34,43),
 ( 1,19)( 2,27)( 3,37)( 5,42)( 7,44)( 9,47)(11,49)(14,52)(16,53)(18,54)
  (20,57)(23,59)(25,60)(28,63)(30,64)(32,66)(33,67)(35,70)(38,72)(41,75)
  (43,76)(45,77)(48,78)(51,80)(55,81)(58,82)(62,84)(65,85)(68,86)(71,87)
  (74,89)(79,90)(83,91)(88,92),( 1,19)( 2,24)( 3,36)( 5,39)
  ( 7,42)( 12,45)( 13,46)( 15,49)( 17,50)( 20,51)( 21,54)( 25,56)
  ( 27,58)( 38,74)( 40,75)( 48,80)( 52,82)( 61,87)( 65,93)( 72,98)
  ( 76,103)( 78,104)( 83,106)( 89,120)( 91,121)( 94,123)( 96,124)( 99,125)
  (101,127)(105,131)(107,132),( 4,19)( 6,20)( 8,21)(10,25)(12,26)(15,27)
  (18,30)(23,32)(24,34)(29,35)(31,38)(33,40)(36,42)(37,43)(39,44)(41,45),
 ( 1,3)( 6,8)(11,12)(23,24)(25,26)(30,31)(32,33)(34,35),
 ( 4,5)( 6,8)( 9,12)(18,21)(22,24)(25,28)(31,34)(35,38)(45,46)(49,50)
  (52,53)(56,57)(59,60)(63,64),( 1,19)( 2,22)( 3,27)( 4,32)( 9,41)(10,43)
  (11,44)(12,46)(13,47)(16,48)(17,49)(20,50)(21,51)(24,53)(25,54)(29,55)
  (30,56)(33,57)(35,59)(42,60)(45,61),( 4,5)( 6,8)( 9,11)(12,13)(14,16)
  (17,18)(19,21)(22,23)(24,26)(27,29)(31,33)(34,36)(37,38)(39,41)(42,43)
  (44,46)(47,48)(49,51)(52,54),( 1,3)( 6,8)(14,16)(19,21)(25,27)(32,34)
  (40,42),( 2,3)( 7,8)(11,12)(19,20)(27,28)(35,36)(42,43),
 ( 4,19)( 7,20)( 9,23)(11,24)(13,25)(15,29)(16,30)(21,33)(22,34)(26,36)
  (27,37)(31,39)(38,42)(40,43)(41,44),( 4,5)( 6,8)( 9,11)(16,17)(18,21),
 ( 4,5)( 6,8)( 9,10)(11,13)(14,15)(16,18)(19,20)(21,23)(24,26)(28,30)
  (31,33)(34,35)(36,38)(39,40)(41,43)(44,45)(46,48)(49,51)(53,55),
 ( 2,3)( 7,8)(12,13)(15,16)(17,18)(21,22)(23,24),
 ( 2,3)( 7,8)(12,13)(15,16)(18,19)(21,22)(23,24),
 ( 1,19)( 2,21)( 4,24)( 5,26)( 6,29)( 7,31)( 8,33)( 9,36)(11,38)(12,41)
  (13,43)(14,45)(15,48)(16,50)(18,53),( 4,5)( 6,8)( 9,10)(14,15),
 ( 1,3)( 6,7)(13,15)(18,20)(26,28)(31,33)(39,41),
 ( 1,3)( 6,7)(16,17)(21,22)(23,24)(28,29)(32,33)(34,35),
 ( 3,5)( 7,8)(12,13)(18,19)(22,23)(25,26)(31,32)(36,37)(39,40),
 ( 1,3)( 6,7)(19,20)(25,26)(27,28)(30,31)(34,35)(37,38)(41,42)(49,50)
  (52,53)(54,55)(57,58)(60,61)(62,63)(65,66)(68,69)(71,72)(73,74)(75,76),
 ( 1,3)( 6,7)(23,24)(26,27)(30,31)(33,34)(37,38)(40,41)(42,43)(45,46)
  (47,48)(49,51)(54,55)(56,57)(58,60)(62,63)(64,66)(69,70)(72,73)(75,76)
  (83,84)(86,87)(89,90),( 1,19)( 3,22)( 4,24)( 5,26)( 6,29)( 7,31)( 8,34)
  (10,36)(11,38)(12,41)(14,43)(15,46)(16,48)(17,50)(18,53),
 ( 2,3)( 7,8)(12,13)(16,17)(28,29)(35,36),( 1,3)( 7,13)( 9,14)(11,15),
 ( 4,5)( 6,8)(10,12)(15,16)(23,24)(26,27)(29,30)(32,33),
 ( 1,3)( 7,11)( 9,12)(10,13),( 4,5)( 6,8)(10,11)(12,14)(15,17)(20,22)
  (23,25)(45,46)(47,48)(49,50)(54,55)(56,57)(74,75)(78,79),
 ( 1,3)( 7,11)(15,17)(18,21)(23,24)(25,26)(31,32)(38,39)(41,42),
 ( 2,3)( 7,8)(12,13)(17,18)(25,26)(27,28)(29,30),
 ( 4,18)( 6,21)( 8,24)(10,25)(11,26)(12,29)(16,33)(19,34)(23,36)(27,37)
  (31,39)(32,40)(35,41)(38,42),( 2,3)( 7,8)(12,13)(17,18)(28,29)(34,35),
 ( 4,5)( 6,8)(11,12)(13,15),( 4,18)( 6,20)( 9,23)(10,24)(13,28)(14,29)
  (16,32)(21,34)(26,37)(27,38)(30,39)(33,41)(35,43)(36,44)(40,45)(42,46),
 ( 4,5)( 6,8)(12,13)(17,18)(23,24)(27,29)(31,33)(34,36),
 ( 4,5)( 6,8)(12,13)(18,19)(22,24)(26,27)(30,32),
 ( 1,3)( 7,8)(10,11)(12,13)(14,15)(17,18)(20,21)(23,24),
 ( 1,3)( 7,8)(10,11),( 4,5)( 6,8)(13,14)(21,22)(23,24)(26,27)(29,30)
  (31,32)(34,35),( 2,3)( 7,8)(12,13)(20,21)(23,24)(26,27)(30,31),
 ( 4,5)( 6,8)(16,18)(20,21)(22,23)(25,27)(28,29)(32,34)(36,38),
 ( 2,3)( 7,8)(12,13)(20,21)(28,29)(35,36),
 ( 2,3)( 7,8)(12,13)(20,21)(28,29)(36,37)(42,43),
 ( 4,5)( 6,7)( 8,11)(15,17)(18,20),( 2,3)( 7,8)(12,13)(25,27)(28,30)
  (33,35)(37,39)(40,42),( 1,17)( 2,20)( 3,24)( 4,29)( 9,38)(10,39)(11,41)
  (12,42)(13,44)(16,46)(18,47)(21,49)(23,52)(25,53)(28,55)(30,56)(33,59)
  (40,64)(43,66)(45,67)(48,68)(51,69)(54,70)(58,71)(63,72)(65,73),
 ( 1,3)( 8,14)( 9,15)(10,16)(13,19)(17,20)(18,21),
 ( 1,5)( 2,9)( 3,14)( 6,24)(11,25),( 1,17)( 2,19)( 3,22)( 4,26)(10,35)
  (11,39)(12,43)(14,45)(15,46)(18,51)(20,54)(24,57)(25,60)(27,63)(28,65)
  (32,70)(34,71)(36,72)(38,73)(40,74)(42,75)(44,76)(47,77)(49,78)(52,79)
  (55,80)(58,81)(61,82)(64,83)(66,84),( 1,5)( 2,9)( 3,13)( 8,23)(15,29)
  (18,32)(22,33)(28,36),( 1,3)( 8,11)(14,16)(17,20)(22,24)(25,27)(30,31)
  (32,35)(38,39)(41,42)(44,46)(49,50)(53,55)(57,58)(60,62)(63,64)(66,68)
  (70,71)(74,76)(77,78)(79,81)(82,83)(85,86)(87,89)(90,91),
 ( 1,17)( 2,19)( 3,20)( 4,22)( 5,24)( 6,25)( 7,26)( 8,28)( 9,29)(10,31)
  (11,32)(12,33)(13,35)(14,37)(15,38),( 2,3)( 7,8)(14,15)(16,17)(23,24),
 ( 1,3)( 8,10)(11,13)(16,19)(24,26)(40,42)(45,47)(49,51)(56,58)(61,63)
  (65,67)(68,69)(70,71)(72,73)(75,76)(77,78)(79,80)(82,83)(84,85)(86,87)
  (89,90)(91,92)(93,94),( 1,17)( 2,19)( 4,21)( 7,22)( 9,24)(10,26)(13,27)
  (14,28)(20,40)(25,41)(37,56)(43,60)(47,63)(50,64)(54,67),
 ( 1,17)( 2,18)( 3,19)( 4,21)( 5,22)( 6,24)( 7,25)( 8,26)( 9,28)(10,30)
  (11,31)(12,33)(13,35)(14,36)(15,38),( 2,3)( 7,8)(14,15)(19,20)(25,26)
  (34,35)(41,42),( 2,3)( 7,8)(14,15)(19,20)(26,27)(32,33),
 ( 2,3)( 7,8)(14,15)(19,20)(26,27)(33,34)(42,43),
 ( 2,3)( 7,8)(14,15)(19,20)(26,27)(33,34),
 ( 1,17)( 2,18)( 5,19)( 6,21)( 8,22)(11,24)(12,25)(15,26)(20,39)(34,51)
  (38,58)(42,61)(50,63)(53,65)(57,66)(60,73)(64,74),
 ( 4,5)( 6,7)( 9,10)(11,12)(14,15)(16,17)(19,20)(22,23)(25,26)(28,29)
  (31,32)(33,34)(36,37)(38,39)(41,42)(43,44)(46,47)(49,50)(52,53)(55,56),
 ( 4,5)( 6,7)( 9,10)(11,12)(14,15)(17,18)(20,21)(22,23)(25,26)(28,29)
  (31,32)(33,34)(36,37)(38,39)(41,42)(44,45)(47,48)(49,50)(52,53)(55,56),
 ( 4,5)( 6,7)( 9,10)(11,12)(14,15)(17,18)(20,21)(23,24)(26,27)(28,29)
  (31,32)(33,34)(36,37)(38,39)(41,42)(44,45)(47,48)(50,51)(53,54)(55,56),
 ( 2,3)( 7,8)(15,16)(19,20)(25,26)(33,34)(40,41),
 ( 2,3)( 7,8)(15,16)(20,21)(24,25)(27,28)(31,32),
 ( 4,5)( 6,7)( 9,10)(12,13)(15,16)(17,18)(20,21)(22,23)(25,26)(28,29)
  (31,32)(33,34)(36,37)(39,40)(42,43)(44,45)(47,48)(49,50)(52,53)(55,56),
 ( 4,5)( 6,7)( 9,10)(12,13)(15,16)(17,18)(20,21)(23,24)(26,27)(28,29)
  (31,32)(33,34)(36,37)(39,40)(42,43)(44,45)(47,48)(50,51)(53,54)(55,56),
 ( 4,5)( 6,7)( 9,10)(12,13)(15,16)(18,19)(21,22)(23,24)(26,27)(28,29)
  (31,32)(33,34)(36,37)(39,40)(42,43)(45,46)(48,49)(50,51)(53,54)(55,56),
 ( 4,5)( 6,7)( 9,10)(12,13)(22,23)(25,26)(31,32)(35,36)(38,39),
 ( 4,5)( 6,7)( 9,10)(13,14)(16,17)(19,20)(22,23)(28,29)(30,31)(33,34)
  (35,36)(39,40)(44,45)(47,48)(50,51)(56,57)(59,60)(61,62)(67,68)(71,72)
  (79,80)(84,85)(88,89),( 4,15)( 6,17)(13,22)(16,41)(23,42)(24,43)(26,46)
  (27,48)(29,50)(30,51)(31,52)(33,55)(34,57)(36,59)(37,60)(38,62)(40,64)
  (44,74)(47,75)(49,76)(53,77)(56,78)(58,79)(61,80)(63,81)(65,82)(67,85)
  (68,86)(70,89)(71,90)(73,93)(83,94)(87,95)(91,96),
 ( 4,5)( 6,7)( 9,10)(13,14)(20,21)(24,25)(27,28)(32,33)(39,40)(45,46)
  (48,49)(51,52)(55,56)(58,59)(61,62)(67,68)(70,71)(76,77)(81,82)(85,86),
 ( 2,45)( 4,46)( 7,48)( 9,50)(11,52)(13,54)(15,56)(17,57)(19,59)(21,60)
  (23,62)(25,63)(27,65)(29,67)(32,69)(34,71)(36,73)(38,74)(41,76)(43,77),
 ( 4,15)( 6,16)( 8,18)(10,19)(12,21)(13,22),
 ( 4,5)( 6,7)( 9,10)(15,16)(20,21)(23,24)(27,28)(32,33)(46,47)(48,49)
  (53,54)(72,73)(77,78),( 2,3)( 8,10)(15,16)(19,20)(22,23)(26,27),
 ( 4,5)( 6,7)( 9,10)(17,18)(22,23)(24,25)(28,29)(30,31),
 ( 4,5)( 6,7)( 9,10)(21,22)(23,24)(25,26)(29,30)(34,35)(36,37)(38,39)
  (43,44)(45,46),( 4,14)( 5,17)( 6,21)( 7,23)( 8,25)( 9,29)(10,30)(12,34)
  (13,36)(15,38)(19,42)(20,43)(22,45)(24,46)(27,47)(28,48)(31,52)(33,54)
  (35,55)(37,56)(39,57)(40,59)(44,61)(49,62)(50,64)(53,66)(58,67)(60,68)
  (63,69)(65,70),( 2,3)( 8,9)(10,11)(13,14)(17,18)(20,21),
 ( 1,9)( 4,11)( 6,14)(10,16)(12,18),( 1,17)( 3,18)( 6,20)( 7,21)( 9,22)
  (11,23)(14,25)(15,26)(19,39)(24,41)(34,50)(44,63)(52,66)(57,69)(60,77)
  (71,82)(75,85),( 1,9)( 4,11)( 6,13)( 8,15),
 ( 2,7)( 4,9)(10,14)(25,28)(26,33)(27,39)(29,44)(32,46)(34,50)(36,53)
  (38,57)(40,59)(45,64)(51,65)(58,66)(68,80)(70,82)(72,85)(74,87)(76,90)
  (78,92),( 2,3)( 8,9)(12,13)(15,16)(23,24)(25,26)(28,29)(30,31)(33,34)
  (37,38)(39,40),( 4,5)( 6,7)(10,11)(13,14)(18,19)(23,24)(27,28)(29,30),
 ( 1,3)( 8,9)(15,17)(19,21)(24,26)(27,28)(30,32)(34,35),
 ( 4,5)( 6,7)(10,11)(14,15)(18,19),( 2,3)( 8,9)(13,14)(15,16)(18,19)
  (20,21)(22,23),( 2,3)( 8,9)(13,14)(16,17)(19,20)(21,22)(23,24),
 ( 1,3)( 8,9)(15,16)(18,19)(22,23)(25,26),
 ( 4,5)( 6,7)(11,12)(13,14)(18,20)(31,33)(37,38)(42,43)(45,46)(49,50)
  (52,53),( 4,5)( 6,7)(11,12)(14,15)(20,21)(23,24)(30,31)(36,37)(39,40)
  (41,42)(45,46)(47,48)(49,50)(51,52)(54,55)(56,57)(62,63)(65,66)(67,68)
  (75,76)(77,78)(85,86)(90,91)(93,94),( 4,5)( 6,7)(11,12)(14,15)(20,21)
  (23,24)(30,31)(36,37)(39,40)(41,42)(45,46)(49,50)(51,52)(54,55)(57,58)
  (63,64)(67,68)(69,70)(72,73)(77,78)(79,80)(83,84)(85,86),
 ( 4,5)( 6,7)(11,12)(14,15)(20,21)(27,28)(30,31)(36,37)(39,40)(41,42)
  (45,46)(49,50)(51,52)(54,55)(57,58)(61,62)(64,65)(67,68)(69,70)(72,73)
  (77,78)(83,84),( 4,5)( 6,7)(11,12)(16,17)(18,19),
 ( 1,17)( 4,18)( 5,20)( 7,22)(10,23)(12,25)(13,27)(16,28)(21,40)(26,41)
  (30,45)(36,59)(48,62)(56,64),( 3,5)(10,24)(11,27)(13,36)(14,39)(17,40)
  (18,42)(25,43)(26,45)(33,46)(34,48),( 1,3)( 9,12)(13,14)(17,18)(19,21),
 ( 2,7)( 4,8)( 9,13)(11,15),( 3,5)(10,12)(15,17)(20,22)(25,26)(29,30)
  (37,38),( 4,5)( 6,7)(13,14)(16,17)(20,21)(23,24)(26,27)(29,30),
 ( 2,3)( 8,9)(18,19)(23,24)(27,28)(34,35)(38,39)(41,42)(44,45)(51,52)
  (56,57)(59,60)(62,63)(65,66)(70,71)(74,75)(78,79)(83,84)(85,86)(89,90)
  (94,95),( 1,17)( 4,18)( 7,20)(13,22)(21,40)(23,41)(26,43)(27,44)(28,47)
  (31,49)(32,50)(33,52)(36,54)(37,56)(38,57)(39,59)(42,66)(46,67)(48,68)
  (53,69)(55,70)(60,71)(61,72)(62,75)(63,76)(64,79)(65,80)(73,83)(74,84)
  (77,85)(78,86)(81,87)(82,88),( 4, 5)( 7,28)( 23,29)( 27,46)
  ( 31,50)( 32,51)( 35,54)( 37,56)( 39,58)( 41,60)( 43,62)( 44,63)
  ( 47,66)( 48,69)( 55,81)( 59,82)( 67,85)( 70,88)( 71,89)( 74,92)
  ( 75,93)( 77,95)( 80,98)( 83,101)( 84,107)( 86,112)( 87,113)( 90,116)
  ( 91,117)( 94,120)( 96,122)( 97,123)(100,126)(102,128)(104,130)(106,132)
  (108,134)(110,136)(115,137)(119,138)(125,139)(127,141)(129,143)(131,145)
  (133,147)(135,149)(140,152)(142,154)(144,156)(146,158)(148,160)(150,162)
  (153,163)(157,164)(161,165),( 1,3)( 9,11)(13,15)(18,20)(24,26)(30,32)
  (38,40),( 4,5)( 7,10)(11,12)(17,19)(20,22),
 ( 2,3)( 9,12)(15,18)(22,23)(25,26)(28,29),
 ( 1,5)( 2,7)( 6,21)( 9,22)(14,24)(20,28)(25,29)(27,30),
 ( 4,5)( 7,10)(14,17)(19,20)(23,26)(29,32)(33,36)(37,38)(42,43)(47,48)
  (52,54)(57,59)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 4,5)( 7,9)(10,13)(14,16)(20,23)(25,26)(27,30)(31,34)(41,42)(49,50)
  (59,61)(62,64)(65,67)(68,70)(71,73)(74,76)(77,78)(79,80)(81,82),
 ( 1, 3)( 9,11)( 19,20)( 22,23)( 26,27)( 30,31)( 32,33)( 37,38)
  ( 40,41)( 43,44)( 46,47)( 49,50)( 52,53)( 55,56)( 58,59)( 60,61)
  ( 62,63)( 65,66)( 67,68)( 71,72)( 74,75)( 77,78)( 80,81)( 85,86)
  ( 88,89)( 95,96)( 99,100)(104,105),( 2,3)( 9,11)(12,14)(18,20)(21,23),
 ( 4,5)( 7,9)(10,12)(13,17)(25,26)(27,30)(36,38)(39,41)(44,45)(46,47)
  (49,50)(53,54)(55,56)(70,71)(72,73)(74,75),
 ( 1,3)( 9,10)(11,12)(14,15)(16,17),( 2,3)( 9,11)(13,15)(17,19)(25,26)
  (28,29)(31,32)(35,36),( 4,5)( 7,9)(10,12)(15,17)(19,21),
 ( 4,5)( 7,9)(10,12)(15,16)(20,21)(23,25)(27,29)(31,32)(44,45)(49,50)
  (59,61)(62,64)(65,67)(68,70)(71,73)(74,76)(77,78)(79,80)(81,82),
 ( 2,3)( 9,11)(14,16)(19,21)(29,31)(37,39)(43,45)(46,48)(50,52),
 ( 4,5)( 7,9)(10,12)(16,18)(19,21),( 2,3)( 9,11)(15,16)(18,19),
 ( 4, 5)( 7, 9)( 10,11)( 12,15)( 16,18)( 19,21)( 22,24)( 25,28)
  ( 29,32)( 33,34)( 35,37)( 38,40)( 44,46)( 49,51)( 53,55)( 57,59)
  ( 62,64)( 66,68)( 70,72)( 74,76)( 78,80)( 82,84)( 87,89)( 91,93)
  ( 97,99)(101,103)(106,108),( 2,3)( 9,10)(11,14)(18,20)(21,23),
 ( 2,3)( 9,10)(11,12)(13,14)(15,16)(17,18)(19,20),
 ( 1,16)( 5,18)( 10,22)( 11,23)( 14,24)( 17,39)( 20,40)( 21,41)
  ( 25,42)( 27,45)( 28,47)( 30,49)( 32,51)( 33,53)( 35,56)( 37,58)
  ( 44,66)( 55,69)( 72,86)( 75,89)( 77,91)( 79,93)( 81,95)( 84,98)
  ( 85,105)( 88,106)( 90,107)( 92,108)( 94,109)( 97,110),
 ( 4,5)( 7,9)(10,11)(13,14)(16,19)(25,26)(30,33)(45,46)(47,48)(49,50)
  (54,55)(72,73)(74,75)(78,79)(80,81),( 4,5)( 7,9)(10,11)(14,15)(20,21)
  (23,25)(27,29)(31,32)(41,42)(46,47)(50,51)(61,62)(64,65)(67,68)(70,71)
  (73,74)(76,77),( 2,3)( 9,10)(13,14)(17,18)(21,22)(32,33)(38,39)(41,42)
  (43,44)(48,49)(50,51)(55,56)(58,59)(61,62)(66,67)(68,69)(72,73)(74,75),
 ( 4,5)( 7,9)(11,13)(15,16)(21,22)(25,27)(30,31)(40,41)(44,45)(49,50)
  (53,55)(58,60)(62,63)(65,66)(68,69)(71,72)(74,75)(77,78),
 ( 4,5)( 7,9)(11,13)(16,18)(19,21),( 4,5)( 7,9)(11,13)(16,17)(23,24)
  (30,31),( 2,3)( 9,10)(13,14)(18,19)(22,23),
 ( 2,3)( 9,10)(13,14)(18,19)(28,29)(34,35)(39,40)(42,43)(47,48)(50,51)
  (54,55)(57,58)(63,64)(66,67)(69,70)(72,73)(77,78)(83,84)(87,88)(92,93)
  (96,97),( 2,3)( 9,10)(13,14)(18,19)(28,29)(34,35)(39,40)(44,45)(47,48)
  (50,51)(53,54)(58,59)(65,66)(68,69)(71,72)(74,75)(79,80)(83,84)(85,86)
  (90,91)(94,95),( 2,3)( 9,10)(13,14)(19,20)(21,22)(27,28)(29,30),
 ( 2,3)( 9,10)(13,14)(19,20)(23,24)(25,26),( 2,7)( 6,8)( 9,14)(11,15),
 ( 1,15)( 2,21)( 3,42)( 6,44)( 12,47)( 16,48)( 18,50)( 19,51)
  ( 24,54)( 30,58)( 32,61)( 35,64)( 37,67)( 39,70)( 41,73)( 43,75)
  ( 49,82)( 53,85)( 55,90)( 57,95)( 59,98)( 63,101)( 65,104)( 69,107)
  ( 71,110)( 77,112)( 78,113)( 84,114)( 86,115),
 ( 4,5)( 7,9)(12,14)(16,17)(20,22)(25,26)(29,30),
 ( 4,5)( 7,9)(12,14)(17,19)(21,23)(25,26)(28,29),
 ( 1,3)(10,11)(12,13)(14,15)(16,17)(18,19)(24,26)(28,30),
 ( 2,3)( 9,10)(14,15)(18,20)(27,29)(31,33)(36,38)(39,40)(42,43)(45,46)
  (47,48)(50,51)(54,56)(59,60)(63,64)(66,67)(69,70)(73,74)(78,79),
 ( 2,3)( 9,10)(14,15)(18,20)(27,29)(31,33)(36,37)(39,40)(42,43)(45,46)
  (47,48)(49,50)(53,55)(58,59)(62,63)(66,67)(68,69)(72,73)(78,79),
 ( 4,5)( 7,9)(12,14)(17,18)(23,25)(28,30),
 ( 1,3)(10,11)(16,17)(18,19)(23,24)(26,27)(29,30)(32,33),
 ( 1,3)(10,11)(21,22)(29,30)(32,33)(34,35)(37,38)(41,42)(44,45)(46,47)
  (48,49)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62),
 ( 1,3)(11,14)(18,21)(22,23)(25,28)(29,31)(33,36)(38,39)(40,41)(42,44)
  (45,46)(49,51)(53,55)(57,58)(59,60)(61,62)(63,65)(66,67)(71,73)(74,76)
  (77,78)(79,81)(82,84)(85,87)(88,89)(90,92)(93,95),
 ( 2,3)( 9,10)(14,15)(19,20)(25,26)(31,32)(39,40),
 ( 1,15)( 2,18)( 3,28)( 4,33)( 9,41)(10,42)(11,44)(12,45)(13,47)(16,48)
  (17,49)(20,50)(21,52)(24,53)(25,54)(27,55)(30,56)(31,58)(35,59)(43,60)
  (46,61),( 4,5)( 7,9)(12,13)(17,18)(30,31)(36,37)(43,44)(47,48)(49,50)
  (51,52)(53,54)(56,57)(58,59)(61,62)(63,64),
 ( 4,5)( 7,9)(13,15)(16,18)(22,24),( 4,5)( 7,9)(13,15)(17,18)(22,23),
 ( 1,3)(11,12)(13,14)(15,16)(17,18)(19,20)(24,25)(27,28),
 ( 4,5)( 7,9)(13,14)(19,20)(22,24)(27,29)(41,42)(45,47)(51,52)(55,57)
  (58,60)(64,66)(69,71)(74,76)(80,82)(85,87),
 ( 4,5)( 7,9)(13,14)(21,23)(25,27)(37,38)(42,43)(46,47)(48,50)(51,52)
  (53,54)(56,58)(59,60)(61,62)(64,66)(67,69)(70,72)(73,75)(76,78)(79,81),
 ( 1,3)(11,12)(15,16),( 1,15)( 2,16)( 3,23)( 4,25)(10,32)(11,33)(12,39)
  (14,42)(17,47)(20,51)(21,54)(24,60)(26,62)(27,63)(29,67)(31,69)(34,71)
  (36,73)(38,75)(40,77)(44,80)(46,82)(48,83)(50,85)(53,87)(55,88)(57,90)
  (59,92)(61,93)(68,94)(70,95)(72,96)(74,97)(76,98)(78,99),
 ( 1,3)(14,16)(17,19)(21,23)(28,29)(34,36)(39,40)(41,42)(44,46)(47,49)
  (50,52)(53,54)(58,59)(60,61)(63,65)(66,68)(70,72)(74,75),
 ( 2,3)( 9,10)(15,16)(18,20)(21,23)(25,27)(33,35)(37,39)(43,44)(47,48)
  (49,51)(54,55)(58,60)(63,64)(66,67),( 4,5)( 7,9)(14,15)(24,26)(35,36)
  (40,41)(45,46)(47,48)(49,50)(51,52)(53,54)(56,57)(58,59)(60,61)(62,63)
  (66,67)(69,70)(72,73)(75,76)(78,79)(81,82),
 ( 4,5)( 7,9)(15,17)(19,21)(23,24)(25,26)(27,28)(29,30),
 ( 2,3)( 9,10)(15,16)(18,19)(21,23)(25,27)(32,34)(36,38)(43,44)(47,48)
  (50,52)(55,56)(60,62)(64,65)(67,68),( 1,3)(14,16)(18,20)(25,26)(31,33)
  (35,37)(40,42)(44,45)(47,48)(50,52)(56,58)(59,61)(63,64)(65,66)(69,70)
  (72,74)(76,78)(81,83)(84,85)(89,90)(92,93),
 ( 2,3)( 9,10)(15,16)(18,19)(21,23)(25,27)(35,37)(42,43)(45,46)(47,48)
  (50,52)(55,57)(60,61)(63,64)(65,66)(67,68)(69,70)(73,74)(77,78),
 ( 4,5)( 7,8)( 9,11)(12,14)(15,16),( 1,3)(14,16)(18,19)(21,23)(28,29)
  (38,39)(42,43)(47,48)(49,50)(53,54)(55,56)(57,59)(61,62)(68,69)(70,71)
  (73,74)(75,76)(77,78)(81,82)(84,85)(86,87)(89,90)(93,94),
 ( 1,3)(14,16)(18,19)(21,22)(23,24)(26,27)(29,30)(35,36)(37,38)(43,44)
  (47,48)(49,50)(52,53)(55,56)(57,58),( 1,3)(14,16)(18,19)(21,22)(23,24)
  (26,27)(30,31)(32,33)(38,39)(45,46)(47,48)(50,51)(53,54)(55,56)(59,60),
 ( 1,15)( 4,16)( 5,17)( 10,21)( 14,23)( 18,39)( 19,40)( 22,41)
  ( 26,44)( 28,46)( 30,49)( 31,51)( 33,53)( 35,55)( 36,57)( 38,60)
  ( 47,67)( 58,70)( 71,85)( 74,88)( 76,90)( 78,92)( 80,94)( 83,97)
  ( 86,105)( 89,106)( 91,107)( 93,108)( 95,109)( 98,110),
 ( 4,5)( 7,8)( 9,10)(11,12)(14,15)(16,17),
 ( 2,3)(10,12)(13,15)(19,22)(23,24),( 2,3)(10,12)(13,15)(19,21)(22,24),
 ( 1,14)( 2,23)( 3,35)( 4,40)( 6,43)( 9,44)( 10,48)( 12,52)
  ( 15,53)( 17,54)( 19,57)( 21,58)( 24,59)( 26,63)( 28,67)( 32,68)
  ( 34,72)( 36,76)( 39,77)( 41,78)( 46,79)( 47,80)( 49,83)( 51,84)
  ( 55,85)( 61,86)( 62,87)( 64,90)( 66,91)( 70,92)( 71,93)( 73,96)
  ( 75,97)( 81,98)( 88,99)( 94,100),( 4,5)( 7,8)( 9,10)(12,13)(14,15)
  (17,18)(19,20)(22,23)(25,26)(28,29)(31,32)(34,35)(36,37)(39,40)(41,42)
  (44,45)(46,47)(49,50)(52,53)(55,56),( 2,3)(10,11)(12,14)(19,20)(21,23),
 ( 2,25)( 3,26)( 5,27)( 7,29)( 8,32)(10,33)(12,34)(13,35)(15,37)(17,40)
  (18,41)(19,42)(21,43)(22,45)(24,46)(31,47)(39,48),
 ( 1,5)( 4,11)( 7,12)( 8,13)( 9,14)(10,15)(16,19)(17,20)(18,21),
 ( 4,5)( 7,8)( 9,10)(12,13)(15,16)(18,19)(20,21)(23,24)(25,26)(28,29)
  (31,32)(34,35)(36,37)(39,40)(42,43)(45,46)(47,48)(50,51)(52,53)(55,56),
 ( 2,3)(10,11)(12,13)(17,18)(25,26)(27,28)(29,30),
 ( 1,14)( 2,20)( 3,30)( 4,44)( 7,46)( 9,47)( 12,48)( 15,51)
  ( 21,52)( 24,53)( 27,56)( 32,57)( 36,63)( 41,69)( 50,77)( 54,80)
  ( 55,82)( 60,90)( 62,92)( 66,94)( 68,96)( 72,98)( 74,100)( 75,102)
  ( 79,103),( 2,3)(10,11)(13,14)(16,17)(19,20)(21,22)(24,25)(28,29)(32,33)
  ,( 4,9)( 5,18)( 7,20)(11,22)(13,24)(16,26)(19,28)(21,29)(23,31)(25,32)
  (27,34),( 2,3)(10,11)(13,14)(16,17)(21,22)(24,25)(26,27)(29,30)(31,32)
  (34,35),( 2,6)( 3,9)(10,13)(11,14),( 1,2)( 3,10)( 5,12),
 ( 4,5)( 7,8)( 9,10)(13,14)(18,19)(23,24)(27,28)(29,30),
 ( 2,6)( 3,8)( 4,11)( 5,14)( 9,18)(12,19)(15,20)(17,21),
 ( 1,14)( 2,19)( 3,22)( 4,26)( 5,30)( 6,33)( 7,37)( 8,40)(10,41)(11,42)
  (13,44)(15,46)(17,48)(23,50)(25,51)(27,53)(29,55)(31,57)(35,60)(38,61)
  (45,63)(47,64)(54,66)(56,67),( 4,5)( 7,8)( 9,10)(16,17)(23,24)(26,27)
  (29,30)(32,33)(40,41)(42,43),( 3,4)( 6,7)( 8,10)(11,12)(13,15)(16,18)
  (20,22)(23,25)(26,27)(28,30)(31,32)(33,35)(36,37)(38,40)(41,43)(45,47)
  (48,50)(51,52)(53,55),( 4, 9)( 5,10)( 6,19)( 23,34)( 24,36)
  ( 25,44)( 26,45)( 27,52)( 32,55)( 33,58)( 38,61)( 41,65)( 42,66)
  ( 47,70)( 48,73)( 49,78)( 50,82)( 51,87)( 71,90)( 74,93)( 77,96)
  ( 80,99)( 83,102)( 86,105)( 91,108)( 94,109)( 97,113)(100,114)(103,118)
  (106,119),( 4,5)( 7,8)(10,12)(14,15)(17,18),
 ( 4,5)( 7,8)(10,12)(15,16)(17,18),( 1,14)( 2,17)( 3,23)( 4,24)( 5,27)
  (11,35)(13,42)(15,47)(18,48)(20,51)(21,54)(25,55)(26,58)(28,60)(29,62)
  (32,66)(34,67)(36,70)(38,71)(40,74)(44,75)(46,76)(50,77)(53,78)(57,79)
  (59,80)(61,81)(69,82)(73,83),( 1,2)( 3,9)( 5,11)( 7,12)(10,13)(14,16)
  (15,17),( 2,3)(10,11)(14,15)(19,20)(23,24),( 1,2)( 3,9)( 5,11),
 ( 4,5)( 7,8)(10,11)(12,13)(15,16)(17,18)(20,21)(22,23)(25,26)(28,29)
  (31,32)(34,35)(37,38)(39,40)(42,43)(44,45)(47,48)(49,50)(52,53)(55,56),
 ( 1,14)( 2,16)( 3,19)( 4,22)( 5,28)( 6,30)( 7,34)( 8,40)(10,41)(11,42)
  (13,46)(18,47)(20,49)(23,51)(25,52)(27,53)(31,57)(35,58)(37,60)(39,62)
  (44,63)(48,64)(55,65)(59,66),( 4,5)( 7,8)(10,11)(12,13)(15,16)(18,19)
  (21,22)(23,24)(26,27)(28,29)(31,32)(34,35)(37,38)(39,40)(42,43)(45,46)
  (48,49)(50,51)(53,54)(55,56),( 4,5)( 7,8)(10,11)(12,13)(15,16)(18,19),
 ( 2,3)(10,11)(15,16)(19,20)(21,22)(25,26)(28,29),
 ( 4,5)( 7,8)(10,11)(12,13)(16,17)(18,19),
 ( 4,5)( 7,8)(10,11)(13,14)(15,16)(18,19)(20,21)(23,24)(25,26)(28,29)
  (31,32)(34,35)(37,38)(40,41)(42,43)(45,46)(47,48)(50,51)(52,53)(55,56),
 ( 1,14)( 2,16)( 3,17)( 5,19)( 6,20)( 7,21)( 8,23)(10,24)(11,26)(13,27),
 ( 2,24)( 4,25)( 7,26)( 9,29)(12,30)(16,31)(17,32)(20,35)(22,36)(27,37)
  (33,38),( 1,2)( 3,5)( 6,7)( 8,10)(11,13),
 ( 2,3)(10,11)(16,18)(24,25)(26,27)(29,30)(32,33)(35,36)(39,40)(45,46)
  (48,49)(51,52)(58,59)(62,63),( 4,9)( 7,12)( 8,14)(10,16)(11,17)(13,18)
  (15,19),( 2,3)(10,11)(16,17)(21,22)(23,24)(26,27)(28,29),
 ( 2,3)(10,11)(17,18)(19,20)(21,22)(23,24),
 ( 2,3)(10,11)(18,19)(20,21)(24,25)(26,27)(30,31)(33,34)(36,37)(45,46)
  (48,49)(50,51)(54,55)(57,58)(59,60),( 4,5)( 7,8)(10,11)(13,14)(16,17)
  (19,20),( 4,5)( 7,8)(10,11)(13,14)(16,17)(20,21),
 ( 1,2)( 3,5)(13,14)(20,21),( 2,3)(10,11)(18,19)(23,24)(27,28)(31,32)
  (35,36)(41,42)(47,48)(51,52)(54,55),( 2,3)(10,11)(18,19)(23,24)(29,30)
  (33,34)(36,37)(38,39)(40,41)(43,44)(45,46)(49,50)(51,52)(53,54)(56,57)
  (59,60)(62,63)(65,66)(68,69)(70,71)(74,75)(76,77)(81,82)(84,85),
 ( 2,3)(10,11)(18,19)(24,25)(30,31)(34,35)(38,39)(42,43)(45,46)(48,49)
  (52,53),( 2,3)(10,11)(19,20)(21,22)(25,26)(27,28)(30,31)(33,34)(37,38)
  (42,43)(46,47)(49,50)(52,53)(56,57)(58,59)(64,65)(69,70),
 ( 4,5)( 7,8)(10,11)(13,14)(23,24)(25,26)(31,32)(34,35)(36,37),
 ( 4,5)( 7,8)(10,11)(13,14)(23,24)(26,27)(30,31)(33,34),
 ( 1,14)( 3,16)( 4,17)( 5,18)( 6,20)( 8,21)( 9,23)(11,24)(12,25)(13,27),
 ( 1,14)( 3,16)( 4,17)( 6,19)( 7,21)( 9,23)(10,24)(12,26)(15,27)(18,28)
  (22,29)(25,30),( 1,2)( 3,4)( 5,6)( 7,9)(10,11)(12,13)(14,15)(16,18),
 ( 2,6)( 4,9)(12,27)(22,30)(28,35)(29,44)(31,49)(34,51)(36,53)(39,55)
  (40,56)(43,58)(45,60)(48,62)(50,63)(54,64)(59,65),
 ( 1,2)( 3,4)( 5,6)( 7,9)(11,13)(16,18)(20,22),
 ( 1,14)( 3,15)( 4,17)( 6,18)( 7,20)( 8,21)( 9,22)(11,24)(12,25)(13,27),
 ( 1,2)( 3,4)( 5,6)( 7,9)(13,15)(16,18)(22,24),
 ( 2,3)(11,12)(13,14)(17,18)(19,20),( 2,24)( 5,25)( 9,28)(11,29)(13,30)
  (15,31)(18,33)(20,35)(23,36)(26,37)(32,38),
 ( 4,5)( 7,8)(10,11)(16,17)(19,20),( 4,5)( 7,8)(10,11)(16,17)(20,21)
  (23,24)(29,30)(43,44)(46,47)(49,50)(52,53)(54,55)(74,75)(78,79),
 ( 2,3)(11,12)(14,15)(17,18)(19,20),( 4,5)( 7,8)(10,11)(17,18)(21,22)
  (24,25)(29,30)(35,36)(38,39),( 4,5)( 7,8)(10,11)(17,18)(22,23)(24,25)
  (29,30)(34,35)(37,38),( 1,14)( 4,17)( 8,24)(11,30)(15,35)(16,38)(19,41)
  (20,43)(22,45)(25,49)(26,50)(28,53)(31,55)(32,57)(36,59)(39,61)(46,63)
  (51,65),( 1,8)( 2,10)( 5,12)( 6,13)( 9,14)(11,15),
 ( 1,5)( 6,10)(11,15)(18,21)(25,28)(34,37)(41,44),
 ( 2,3)( 6,7)( 9,10)(14,15)(17,18)(24,25)(35,36)(39,40)(44,45)(47,48)
  (49,50)(52,53)(54,55)(57,58)(59,60)(65,66)(68,69)(70,71)(73,74)(75,76)
  (77,78)(80,81)(82,83)(85,86)(87,88)(90,91)(93,94),
 ( 1,5)( 6,10)(11,15)(19,23)(27,28)(34,35)(39,40),
 ( 1,13)( 2,23)( 3,29)( 4,32)( 5,36)( 6,37)( 8,39)(10,41)(12,43)(14,45)
  (16,47)(18,52)(20,54)(22,55)(24,57)(25,59)(26,61)(28,63)(31,65)(34,69)
  (38,70)(40,71)(44,73)(48,74)(50,75)(56,76)(58,77)(62,79)(66,80)(68,83)
  (72,86)(78,89)(81,90)(84,91)(87,92),( 2,3)(11,12)(14,15)(20,21)(23,24),
 ( 4,5)( 7,8)(11,12)(13,14)(16,17)(18,19)(24,25)(27,28)(30,31)(33,34)
  (37,38)(40,41)(46,47)(50,51)(56,57)(58,59)(61,62)(67,68)(70,71)(73,74)
  (76,77)(80,81)(85,86),( 1,13)( 2,22)( 3,31)( 4,44)( 7,46)( 9,47)(12,48)
  (14,52)(16,53)(18,54)(21,56)(24,57)(26,58)(28,62)(30,63)(32,65)(34,66)
  (38,67)(40,71)(41,72)(43,73)(45,75)(49,77)(51,78)(55,80)(59,82)(61,83)
  (64,84)(68,86)(70,87)(74,88)(76,90)(79,91)(81,93)(85,95)(89,96)(92,97)
  (94,98),( 4,5)( 7,8)(11,12)(13,14)(20,21)(23,24)(27,28)(44,45)(53,54)
  (58,59)(61,62)(63,64)(66,67)(68,69)(71,72)(73,74)(76,77)(78,79)(81,82)
  (83,84)(86,87),( 4,5)( 7,8)(11,12)(13,14)(21,22)(23,24)(26,27)(30,31)
  (59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)
  (79,80)(81,82),( 4,5)( 7,8)(11,12)(14,15)(16,17)(18,19),
 ( 1,13)( 2,21)( 3,24)( 4,31)( 9,42)(10,43)(11,45)(12,46)(14,47)(15,48)
  (18,50)(20,51)(22,52)(25,53)(26,54)(29,56)(30,57)(33,58)(34,59)(41,60)
  (44,61),( 4,5)( 7,8)(11,12)(14,15)(17,18)(20,21)(26,27)(28,29)(31,32)
  (33,34)(37,38)(40,41)(43,44)(46,47)(49,50)(55,56)(58,59)(60,61)(66,67)
  (70,71)(79,80)(84,85)(88,89),( 4,5)( 7,8)(11,12)(14,15)(17,18)(20,21),
 ( 2,3)(11,12)(16,17)(19,20),( 2, 3)( 11,12)( 17,18)( 25,26)( 29,30)
  ( 40,41)( 44,45)( 48,49)( 50,51)( 54,55)( 56,57)( 60,61)( 62,63)
  ( 66,67)( 68,69)( 71,72)( 75,76)( 78,79)( 84,85)( 92,93)( 95,96)
  ( 98,99)(101,102)(104,105)(107,108)(109,110)(112,113)(115,116)(118,119)
  (121,122)(124,125),( 2,3)(11,12)(18,19)(20,21)(22,23)(24,25),
 ( 2,3)(11,12)(19,20)(27,28)(31,32)(34,35)(37,38)(40,41)(43,44)(46,47)
  (48,49)(50,51)(52,53)(56,57)(58,60)(63,64)(66,67)(70,71)(74,76)(81,82)
  (85,86)(88,89)(92,93)(96,97)(98,99),( 2,3)(12,14)(15,16)(17,19)(20,21)
  (22,24)(25,26),( 2,3)(12,14)(16,18)(20,22)(28,29)(32,33)(36,37)(38,39)
  (41,42)(43,44)(47,48)(50,51)(53,54)(58,59)(63,64)(67,69)(72,73),
 ( 4,5)( 7,8)(11,12)(14,15)(19,20),( 1,13)( 2,18)( 3,25)( 4,33)( 5,36)
  ( 6,40)( 7,41)( 9,43)(11,45)(14,47)(16,48)(19,51)(21,53)(22,54)(24,55)
  (26,57)(28,58)(30,60)(32,62)(35,63)(38,65)(42,66)(44,67)(49,68)(52,71)
  (56,72)(59,73)(64,76)(69,77)(74,78),( 2,23)( 4,26)( 7,27)(10,28)(12,30)
  (15,33)(17,34)(20,35)(22,36)(24,38)(31,39),
 ( 1,2)( 3,4)( 5,6)( 8,9)(10,11)(12,13)(14,15)(17,18)(19,20)(22,23),
 ( 2,3)(12,13)(14,15)(18,19)(21,22)(23,24),
 ( 1,13)( 2,18)( 3,22)( 6,23)( 8,24)(16,28)(27,32)(31,33),
 ( 2,3)(12,13)(14,15)(19,20)(21,22)(27,28)(29,30),
 ( 4,5)( 7,8)(11,12)(15,16)(19,20)(21,22)(24,25)(27,28)(29,30)(33,34)
  (36,37)(38,39)(44,45)(46,47)(50,51)(53,54)(55,56)(63,64)(65,66)(71,72)
  (80,81)(85,86)(88,89)(90,91)(93,94),( 2,3)(12,13)(15,16)(18,19)(20,21)
  (22,23)(24,25)(26,27)(28,29),( 1,13)( 2,18)( 4,23)( 6,27)( 9,45)(11,46)
  (14,47)(16,48)(19,51)(21,52)(24,53)(28,54)(29,57)(39,69)(44,72)(49,73)
  (55,74)(61,75)(68,77),( 2,6)( 7,18)( 9,19)(10,21)(11,23)(13,25)(14,28)
  (16,30)(26,33)(31,35),( 4,8)( 9,11)(12,15)(16,19)(20,23)(24,26)(28,30)
  (31,35)(43,45)(48,49)(51,53)(56,57),( 1, 8)( 3,14)( 4,18)( 10,34)
  ( 12,35)( 13,37)( 16,39)( 17,41)( 21,44)( 22,45)( 24,48)( 26,49)
  ( 31,75)( 33,77)( 40,78)( 43,80)( 47,81)( 54,91)( 59,94)( 63,98)
  ( 67,100)( 72,103)( 76,105)( 79,107)( 89,114)( 96,116),
 ( 2,3)(12,13)(16,17)(20,21)(24,25)(26,27)(31,32)(36,37)(38,39)(44,45)
  (47,48)(51,52),( 2,3)(12,13)(16,17)(20,21)(24,25)(26,27)(31,32)(37,38)
  (39,40)(45,46)(47,48)(50,51),( 1,13)( 2,17)( 3,20)( 4,29)( 9,38)(10,40)
  (11,41)(12,43)(14,44)(16,46)(19,48)(21,50)(24,52)(25,53)(28,55)(30,57)
  (33,59)(39,63)(42,65)(45,67)(47,68)(51,69)(54,70)(58,71)(64,72)(66,73),
 ( 2,3)(12,13)(16,17)(20,21)(24,25)(27,28)(30,31)(35,36)(38,39)(44,45)
  (47,48)(52,53),( 4,5)( 7,8)(11,12)(16,17)(20,21),
 ( 2,3)(12,13)(16,17)(20,21)(24,25)(30,31)(33,34)(37,38)(39,40),
 ( 4,5)( 7,8)(11,12)(17,18)(25,26)(32,33),
 ( 2,3)(12,13)(19,21)(23,25)(33,34)(35,36)(40,41)(42,43)(46,47)(48,49)
  (51,52)(54,55)(57,58)(60,61)(62,63)(64,65)(69,70)(72,73)(75,76),
 ( 4, 5)( 7, 8)( 11,12)( 19,20)( 22,23)( 26,27)( 41,42)( 45,46)
  ( 49,50)( 51,52)( 55,56)( 58,59)( 60,61)( 63,64)( 65,66)( 67,68)
  ( 70,71)( 83,84)( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111),
 ( 4, 5)( 7, 8)( 11,12)( 19,20)( 23,24)( 27,28)( 43,44)( 48,49)
  ( 50,51)( 54,55)( 56,57)( 58,59)( 61,62)( 64,65)( 66,67)( 68,69)
  ( 73,74)( 80,81)( 82,83)( 84,85)( 86,87)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 99,100)(102,103)(105,106)(109,110)(112,113)(115,116),
 ( 4, 5)( 7, 8)( 11,12)( 25,26)( 39,40)( 42,43)( 44,45)( 46,47)
  ( 50,51)( 52,53)( 54,55)( 57,58)( 59,60)( 61,62)( 64,65)( 66,67)
  ( 68,69)( 71,72)( 73,74)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)( 99,100)(101,102)(103,104)(105,106)(107,108),
 ( 2,3)(13,14)(17,18)(21,22)(25,26)(27,28)(31,32)(33,34),
 ( 4,5)( 7,8)(12,14)(17,19)(22,23)(28,29)(32,34)(35,37),
 ( 2,3)(13,14)(17,18)(21,22)(25,26)(30,31)(32,33)(36,37)(38,39),
 ( 3,4)( 7,8)(10,11)(12,13)(15,16),( 2,6)( 9,19)(10,22)(11,29)(12,32)
  (13,36)(20,37)(21,38)(27,39)(35,40)(43,51)(46,57),
 ( 2,3)(13,14)(20,21)(23,24)(28,29)(31,32)(35,36)(37,38)(39,40)(42,43)
  (44,45)(47,48)(53,54)(55,56)(58,59)(60,61)(63,64)(65,66)(68,69)(73,74)
  (78,79)(80,81)(83,84)(85,86)(88,89)(91,92)(94,95),
 ( 4,5)( 7,8)(12,13)(15,16)(20,21)(23,24)(29,30)(36,37)(39,40)(42,43)
  (47,48)(50,51)(53,54)(55,56)(59,60)(62,63)(67,68)(69,70)(71,72)(74,75)
  (78,79)(81,82)(84,85)(88,89)(91,92)(94,95)(97,98),
 ( 2,6)( 9,17)(10,21)(11,26)(12,30)(13,34)(18,35)(20,36)(32,37)(39,49)
  (42,56)(47,60)(54,61)(58,62),( 4,5)( 7,8)(12,13)(15,16)(20,21)(27,28)
  (33,34)(36,37)(38,39)(42,43)(45,46)(49,50)(52,53)(54,55)(57,58)(60,61)
  (65,66)(68,69)(70,71)(73,74)(79,80)(81,82)(87,88)(89,90),
 ( 4, 5)( 7, 8)( 12,13)( 15,16)( 20,21)( 27,28)( 33,34)( 36,37)
  ( 38,39)( 42,43)( 46,47)( 48,49)( 51,52)( 53,54)( 58,59)( 61,62)
  ( 64,65)( 66,67)( 70,71)( 74,75)( 77,78)( 80,81)( 84,85)( 88,89)
  ( 91,92)( 96,97)(100,101),( 2,3)(14,15)(18,19)(21,22)(25,26)(35,36)
  (38,39)(43,44)(45,46)(50,51)(53,54)(59,60)(61,62)(63,64)(68,69)(71,72)
  (75,76)(81,82),( 2,3)(14,15)(18,19)(21,22)(31,32)(35,36)(38,39)(43,44)
  (45,46)(49,50)(52,53)(59,60)(61,62)(67,68)(70,71)(75,76)(79,80)(81,82)
  (85,86),( 2,3)(15,16)(18,19)(20,21)(24,25)(30,31)(32,33)(35,36)(37,38)
  (40,41)(42,43)(48,49)(51,52)(54,55),( 4, 5)( 7, 8)( 12,13)( 16,17)
  ( 20,21)( 24,25)( 32,33)( 40,41)( 42,43)( 48,49)( 58,59)( 65,66)
  ( 71,72)( 81,82)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)( 93,94)
  ( 95,96)( 97,98)( 99,100)(101,102)(103,104)(110,111)(112,113)(114,115)
  (116,117)(118,119)(120,121),( 4,5)( 7,8)(12,13)(16,17)(21,22),
 ( 1,2)( 3,4)( 6,7)( 8,9)(10,11)(12,14)(15,16)(18,19)(28,29)(30,31)
  (32,33)(34,35)(36,37)(38,39)(40,41)(42,43)(44,45)(46,47)(48,49)(50,51)
  (52,53)(55,56)(57,58)(59,60)(79,80)(81,82)(83,84)(85,86)(88,89)(90,91)
  (92,93)(94,95),( 2,3)(15,16)(20,21)(24,25)(26,27)(29,30)(31,32)(35,36)
  (39,40)(45,46)(48,49)(50,51)(53,54)(56,57)(58,59)(60,61)(62,63)(64,65)
  (66,67),( 4,5)( 7,8)(12,13)(17,18)(22,23)(29,30)(42,43)(47,48)(51,52)
  (56,57)(59,60)(64,65)(69,70)(74,75)(79,80)(84,85),
 ( 1,2)( 3,4)( 6,7)( 8,9)(10,11)(12,13)(15,16)(17,18)(19,20)(21,22)
  (24,25)(27,28)(30,31)(39,40)(41,42)(43,44)(45,46)(47,48)(49,50)(51,52)
  (53,54)(56,57)(58,59)(60,61)(79,80)(81,82)(83,84)(86,87)(88,89)(90,91),
 ( 1,5)( 9,13)(14,18)(19,23)(26,27)(31,32)(38,39),
 ( 4,5)( 7,8)(12,13)(18,19)(22,23)(29,30)(46,47)(50,51)(55,56)(59,60)
  (63,64)(67,68)(71,72)(75,76)(79,80)(83,84),
 ( 4,5)( 7,8)(12,13)(19,20)(23,24)(25,26)(28,29)(32,33)(39,40)(44,45)
  (47,48)(53,54)(56,57)(61,62)(64,65)(67,68)(71,72)(73,74)(77,78)(83,84),
 ( 4,5)( 7,8)(12,13)(19,20)(25,26)(28,29)(33,34)(36,37)(39,40)(42,43)
  (46,47)(49,50)(51,52)(54,55)(58,59)(62,63)(65,66)(67,68)(70,71)(72,73)
  (77,78)(81,82)(84,85)(88,89),( 3,44)( 5,46)( 7,48)( 9,50)(11,52)(13,54)
  (15,55)(17,57)(19,58)(21,60)(23,61)(25,63)(28,65)(30,67)(32,69)(34,71)
  (37,72)(39,74)(41,75)(43,77),( 1,13)( 3,17)( 5,21)( 8,29)(10,48)(12,49)
  (15,52)(16,53)(20,54)(23,55)(25,58)(26,59)(28,60)(35,63)(40,65)(46,69)
  (51,71)(57,72),( 1,5)( 9,12)(13,16)(22,23)(26,28)(29,30)(31,32)(35,37)
  (38,39)(41,43)(44,45)(46,47)(49,50)(52,53),
 ( 4,7)( 5,9)(12,16)(14,17)(18,20)(19,21),
 ( 3,41)( 5,42)( 8,45)(11,47)(12,48)(15,50)(18,54)(20,55)(23,57)(24,58)
  (27,61)(29,64)(32,66)(33,67)(36,69)(39,73)(40,74)(44,77)(53,79)(60,81)
  (63,83)(72,84)(76,85)(80,86),( 3,41)( 5,42)( 8,44)( 9,45)(12,49)(14,50)
  (17,52)(18,53)(21,57)(24,59)(25,60)(28,62)(30,63)(33,67)(36,68)(37,69)
  (40,73)(48,75)(55,77)(56,79)(66,81)(71,83)(72,85),
 ( 4,5)( 7,8)(13,14)(16,17)(20,21),( 3,41)( 7,45)(10,46)(12,48)(16,52)
  (19,53)(21,55)(24,57)(28,59)(31,61)(34,64)(36,67)(40,69)(43,71)(44,73)
  (47,74)(51,77)(54,78)(56,79)(58,81)(60,82)(63,85)(66,86)(68,87)(70,88)
  (72,89)(76,91)(80,92)(84,94)(90,95)(93,96),
 ( 3,41)( 7,43)( 9,46)(12,49)(15,51)(19,53)(22,55)(24,57)(27,58)(31,62)
  (33,64)(36,65)(40,69)(42,70)(44,71)(47,72)(50,75)(52,76)(54,78)(56,79)
  (59,80)(63,83)(66,84)(67,86)(73,88)(77,90)(81,91)(85,93)(87,94)(89,95)
  (92,96),( 4,5)( 7,8)(13,14)(17,18)(23,24)(30,31),
 ( 4,5)( 7,8)(13,14)(17,18)(25,26)(27,28)(29,30),
 ( 3,38)( 5,40)( 9,42)( 12,46)( 15,48)( 16,50)( 18,53)( 21,55)
  ( 24,56)( 26,60)( 32,62)( 34,64)( 37,68)( 39,69)( 41,72)( 47,75)
  ( 49,78)( 52,79)( 54,80)( 58,85)( 59,86)( 63,89)( 65,92)( 67,93)
  ( 71,96)( 77,97)( 82,100)( 84,101)( 91,102)( 95,103)( 99,104),
 ( 2,5)( 3,8)( 9,13)(11,14),( 4,5)( 7,8)(14,15)(16,17)(23,24),
 ( 4, 5)( 7, 8)( 14,15)( 17,18)( 20,21)( 28,29)( 42,43)( 46,47)
  ( 49,50)( 54,55)( 56,57)( 59,60)( 62,63)( 64,65)( 67,68)( 69,70)
  ( 72,73)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)( 94,95)( 97,98)
  (100,101)(103,104)(106,107)(109,110)(112,113),
 ( 1,13)( 4,33)( 6,39)( 8,42)(12,43)(15,44)(17,48)(19,50)(21,51)(24,52)
  (28,53)(30,54)(32,58)(35,60)(38,62)(47,65)(57,68)(61,70)(64,71)(67,72),
 ( 1,2)( 3,4)( 8,9)(12,13),( 2,5)( 3,7)( 8,21)(10,22)(13,23)(17,26)
  (19,27),( 4,5)( 7,8)(14,15)(17,18)(22,23)(25,26)(28,29)(31,32),
 ( 4,5)( 7,8)(14,15)(17,18)(22,23)(25,26)(29,30)(32,33),
 ( 3,32)( 5,33)(10,35)(12,37)(14,38)(16,39)(19,41)(21,43)(24,44)(26,45)
  (29,47)(50,63)(54,68)(58,73)(61,84)(66,85)(71,86)(75,87)(77,89)(80,91)
  (81,93)(82,95)(83,97),( 1,2)( 3,4)(10,11)(13,14),
 ( 4,5)( 7,8)(14,15)(25,26)(28,29)(32,33)(35,36)(38,39)(41,42)(43,44)
  (46,47)(48,49)(53,54)(57,58)(59,60)(62,63)(64,65)(67,68)(69,70)(73,74)
  (77,78)(79,80)(82,83)(84,85)(86,87)(89,90),
 ( 3,32)( 6,33)( 9,34)( 19,35)( 24,36)( 27,37)( 31,38)( 39,61)
  ( 40,66)( 43,67)( 44,72)( 45,73)( 49,78)( 50,79)( 51,84)( 54,85)
  ( 55,90)( 56,91)( 60,96)( 68,97)( 71,98)( 80,99)( 83,100)( 92,101)
  ( 95,102),( 1,5)(11,14)(15,18)(22,23)(24,26)(28,29)(30,31)(32,34)(36,37)
  ,( 3,32)( 6,33)( 10,34)( 11,35)( 15,36)( 19,37)( 22,38)( 30,39)
  ( 40,56)( 43,61)( 44,62)( 47,67)( 48,68)( 50,71)( 53,76)( 63,89)
  ( 69,90)( 77,93)( 81,96)( 82,99)( 83,102)( 87,105)( 88,108)( 92,109)
  ( 95,112)( 98,115)(101,118)(104,121)(107,124)(113,127)(119,128)(125,129),
 ( 3,32)( 6,33)( 10,34)( 13,35)( 18,36)( 28,37)( 31,38)( 40,61)
  ( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)( 51,79)( 52,84)( 53,85)
  ( 57,90)( 58,91)( 59,96)( 68,97)( 71,98)( 80,99)( 83,100)( 92,101)
  ( 95,102),( 4,5)( 7,8)(15,16)(18,19)(23,24)(25,26)(29,30)(31,32),
 ( 3,32)( 6,33)( 16,34)( 21,35)( 24,36)( 28,37)( 31,38)( 40,61)
  ( 41,66)( 42,67)( 46,72)( 47,73)( 48,78)( 51,79)( 52,84)( 53,85)
  ( 57,90)( 58,91)( 59,96)( 62,97)( 65,98)( 74,99)( 77,100)( 86,101)
  ( 89,102),( 3,32)( 7,33)( 8,34)( 12,35)( 16,36)( 19,37)( 27,38)
  ( 31,39)( 40,56)( 43,61)( 44,62)( 47,67)( 48,68)( 50,71)( 53,76)
  ( 63,89)( 69,90)( 77,93)( 81,96)( 82,99)( 83,102)( 87,105)( 88,108)
  ( 92,109)( 95,112)( 98,115)(101,118)(104,121)(107,124)(113,127)(119,128)
  (125,129),( 4,5)( 7,8)(16,17)(21,22)(23,24)(26,27)(28,29)(32,33)(37,38)
  (41,42)(44,45)(47,48),( 4, 5)( 7, 8)( 16,17)( 33,34)( 36,37)
  ( 41,42)( 43,44)( 48,49)( 50,51)( 52,53)( 55,56)( 58,59)( 61,62)
  ( 63,64)( 65,66)( 69,70)( 76,77)( 84,85)( 86,87)( 88,89)( 90,91)
  ( 93,94)( 95,96)( 97,98)( 99,100)(101,102)(103,104)(105,106)(108,109)
  (110,111)(112,113)(116,117)(118,119)(122,123)(124,125)(126,127)(129,130)
  (131,132)(135,136)(138,139)(140,141)(142,143)(145,146)(147,148)(149,150)
  (152,153),( 4, 5)( 7, 8)( 17,18)( 21,22)( 37,38)( 39,40)( 43,44)
  ( 48,49)( 50,51)( 55,56)( 57,58)( 59,60)( 61,62)( 64,65)( 66,67)
  ( 70,71)( 75,76)( 81,82)( 83,84)( 85,86)( 87,88)( 89,90)( 91,92)
  ( 93,94)( 95,96)( 97,98)( 99,100)(101,102)(107,108)(110,111)(112,113)
  (114,115)(117,118)(119,120)(123,124)(126,127)(131,132)(133,134)(135,136)
  (137,138)(139,140)(141,142),( 3,32)( 11,33)( 16,34)( 20,35)( 25,36)
  ( 27,37)( 30,38)( 39,62)( 42,64)( 43,66)( 45,67)( 48,69)( 51,71)
  ( 54,73)( 57,74)( 61,77)( 63,92)( 68,93)( 80,95)( 83,97)( 84,99)
  ( 87,101)( 90,103)( 91,105)( 94,106)( 96,108)( 98,110)(100,112)(102,114)
  (104,116)(109,118)(113,119)(117,120),( 4,5)( 8,24)( 9,27)(10,40)(11,43)
  (14,44)(16,45)(25,46)(26,47)(35,48)(37,49),
 ( 3,31)( 5,33)( 7,34)( 9,35)(11,37)(14,39)(16,40)(18,41)(21,43)(26,44)
  (28,45)(50,63)(55,68)(59,72)(62,84)(67,86)(71,88)(74,89)(76,91)(77,93)
  (78,95)(80,97)(81,99),( 3,31)( 5,32)( 6,33)( 9,36)(11,37)(13,39)(15,41)
  (16,42)(17,43)(18,46)(20,47)(21,48)(22,49)(24,50)(25,53)(27,54)(28,55)
  (29,56)(34,57)(35,58)(38,59)(40,60)(44,61)(45,62)(51,63)(52,64),
 ( 3,31)( 6,33)( 8,34)(11,35)(13,37)(16,39)(18,40)(20,41)(22,43)(27,45)
  (29,46)(49,61)(53,66)(57,71)(63,84)(68,85)(73,86)(75,88)(76,90)(77,92)
  (78,94)(81,96)(83,98),( 3,30)( 4,31)( 6,32)( 7,34)( 9,35)(10,36)(13,38)
  (16,39)(17,42)(18,44)(19,45)(20,46)(21,48)(22,50)(23,51)(24,53)(25,54)
  (26,55)(27,57)(28,58)(40,62)(41,66)(49,68)(59,70)(60,72)(63,74)(64,76),
 ( 3,30)( 5,32)( 8,34)( 10,35)( 13,36)( 15,38)( 18,40)( 21,41)
  ( 23,43)( 25,45)( 27,46)( 48,62)( 52,68)( 56,74)( 63,86)( 69,87)
  ( 75,88)( 77,89)( 79,92)( 80,94)( 82,97)( 83,99)( 84,102),
 ( 4,5)( 8,10)(11,13)(16,17)(18,19),( 3,30)( 5,32)( 8,33)( 12,35)
  ( 14,37)( 16,38)( 18,39)( 21,41)( 23,43)( 25,44)( 27,45)( 49,64)
  ( 54,70)( 58,76)( 59,86)( 65,87)( 71,88)( 77,90)( 78,93)( 81,95)
  ( 82,98)( 83,100)( 85,103),( 4,5)( 8,10)(11,13)(17,19)(20,22),
 ( 3,30)( 6,31)( 8,33)( 10,35)( 13,36)( 15,37)( 18,39)( 21,40)
  ( 23,41)( 25,43)( 28,45)( 48,61)( 51,67)( 56,71)( 60,83)( 66,85)
  ( 70,87)( 74,90)( 77,92)( 78,95)( 79,97)( 81,99)( 82,101),
 ( 3,30)( 6,31)( 8,33)( 10,35)( 13,36)( 15,37)( 18,39)( 21,40)
  ( 23,41)( 25,43)( 28,45)( 48,60)( 51,66)( 56,70)( 59,83)( 65,85)
  ( 69,87)( 76,90)( 77,93)( 78,95)( 80,97)( 81,99)( 82,102),
 ( 4, 5)( 8,10)( 12,14)( 16,18)( 39,40)( 41,42)( 43,44)( 45,46)
  ( 48,49)( 50,51)( 52,53)( 55,56)( 57,58)( 59,60)( 61,62)( 82,83)
  ( 84,85)( 87,88)( 90,91)( 93,94)( 95,96)( 98,99)(101,102)(103,104)
  (106,107)(109,110)(117,118)(120,121)(122,123)(125,126)(128,129)(130,131)
  (133,134)(136,137)(138,139)(141,142)(144,145)(146,147)(179,180)(182,183)
  (185,186)(188,189)(191,192)(194,195)(197,198)(200,201)(203,204)(206,207)
  (209,210)(212,213)(215,216)(217,218)(219,220)(221,222)(223,224)(225,226)
  (227,228)(229,230)(231,232)(233,234)(235,236)(237,238),
 ( 4,5)( 8,10)(12,14)(16,17)(22,23)(29,30),
 ( 3,29)( 4,30)( 12,31)( 15,32)( 21,33)( 22,34)( 26,35)( 39,59)
  ( 41,62)( 42,63)( 47,65)( 51,66)( 53,69)( 54,70)( 57,73)( 64,85)
  ( 68,86)( 74,87)( 75,89)( 77,92)( 79,94)( 80,97)( 81,99)( 82,101)
  ( 88,109)( 90,111)( 93,113)( 95,115)( 98,117)(100,119)(103,121)(105,125)
  (108,128)(112,129)(116,130),( 4,5)( 8,10)(12,14)(17,19)(24,26)(28,30)
  (50,51)(53,55)(59,60)(62,64)(65,67)(68,70)(71,73)(74,76)(77,79)(80,82),
 ( 3,29)( 6,30)( 10,31)( 11,32)( 17,33)( 20,34)( 28,35)( 39,59)
  ( 42,62)( 43,63)( 45,66)( 49,67)( 54,69)( 55,70)( 57,73)( 64,85)
  ( 68,86)( 76,88)( 77,90)( 78,92)( 79,95)( 81,97)( 83,100)( 84,102)
  ( 89,108)( 91,110)( 94,112)( 96,114)( 99,116)(101,118)(105,122)(107,126)
  (111,128)(115,129)(119,130),( 3,29)( 6,30)( 12,31)( 13,32)( 19,33)
  ( 23,34)( 24,35)( 41,58)( 43,61)( 45,63)( 46,64)( 52,67)( 53,68)
  ( 55,71)( 56,72)( 62,87)( 66,88)( 73,89)( 75,91)( 76,93)( 79,95)
  ( 81,98)( 83,100)( 85,103)( 90,111)( 92,113)( 96,115)( 99,117)(101,119)
  (104,121)(106,122)(108,123)(110,124)(114,125)(118,126),
 ( 4,5)( 8,10)(12,14)(18,19)(21,23)(24,26)(29,31)(38,39)(42,43)(46,47)
  (49,50)(55,56)(59,60)(62,63),( 1,12)( 2,19)( 3,24)( 4,26)
  ( 5,32)( 35,45)( 38,59)( 39,60)( 42,61)( 47,63)( 48,64)( 53,66)
  ( 54,67)( 57,68)( 58,77)( 70,87)( 73,90)( 76,93)( 79,96)( 82,99)
  ( 85,102)( 86,104)( 89,106)( 92,107)( 95,109)( 98,110)(101,112),
 ( 1,12)( 2,19)( 3,23)( 4,35)( 6,38)( 13,44)( 14,45)( 17,48)
  ( 20,49)( 24,53)( 25,57)( 27,58)( 36,84)( 40,86)( 46,87)( 50,89)
  ( 52,90)( 61,98)( 65,99)( 69,100)( 73,102)( 78,103)( 82,104)( 85,105)
  ( 88,106),( 3,4)( 7,8)(15,16)(20,21)(27,28)(34,35)(42,43),
 ( 1,12)( 2,18)( 3,23)( 4,29)( 5,33)( 6,35)( 7,38)( 9,39)(11,41)(13,42)
  (16,44)(20,47)(24,49)(26,50)(27,52)(30,55)(32,57)(36,61)(40,62)(43,66)
  (46,68)(48,69)(51,73)(53,75)(56,76)(58,77)(60,78)(63,79)(65,80)(67,81)
  (70,82)(72,83)(74,84),( 3,27)( 4,28)( 6,30)( 7,31)( 9,32)(10,33)(13,35)
  (16,37)(17,42)(18,43)(20,46)(21,47)(22,48)(23,51)(25,54)(26,55)(29,56)
  (34,58)(36,59)(39,61)(41,64)(44,67)(45,70)(50,72)(52,73)(53,74)(57,78)
  (60,79)(63,80)(66,83)(69,86)(71,87)(75,88)(77,89)(82,90)(85,91),
 ( 3,27)( 5,28)( 8,29)( 11,31)( 15,32)( 17,34)( 19,36)( 22,37)
  ( 24,39)( 47,81)( 48,82)( 52,83)( 55,85)( 56,86)( 60,87)( 64,89)
  ( 65,90)( 69,91)( 71,92)( 72,96)( 73,100)( 74,102)( 75,106)( 76,110)
  ( 77,112)( 78,116)( 79,120)(122,134)(124,136)(126,138)(127,140)(129,142)
  (130,144),( 1,2)( 4,10)( 7,12)( 8,13)( 9,14)(11,15)(16,19)(17,20)(18,21)
  ,( 4,5)( 8,10)(13,15)(20,21)(25,26)(29,30),
 ( 4,5)( 8,10)(13,15)(22,23)(26,28)(31,33)(36,37)(44,46)(49,51),
 ( 1,2)( 4,10)( 7,11),( 4,5)( 8,10)(13,14)(18,19)(21,23)(27,29)(36,37)
  (38,40)(42,43)(47,48)(51,52)(56,58)(59,60)(63,65)(66,68),
 ( 1,12)( 2,18)( 4,27)( 8,42)(13,44)(19,46)(21,47)(23,51)(25,53)(28,54)
  (32,56)(37,58)(39,62)(41,64)(45,65)(48,66)(52,67)(57,68)(59,69)(63,70),
 ( 3,25)( 5,34)( 6,40)( 9,42)(11,43)(13,44)(15,48)(17,50)(20,53)(24,54)
  (27,55)(29,56)(31,60)(33,62)(39,65)(47,66)(52,67)(59,68)(64,69),
 ( 3,24)( 4,27)( 8,28)(11,29)(13,30)(16,33)(18,34)(21,35)(23,36)(26,37)
  (32,38),( 1,2)( 4,9)( 6,11)( 7,13)( 8,15)(14,17)(16,18),
 ( 1,12)( 2,16)( 3,21)( 4,24)( 9,31)(10,34)(11,38)(13,43)(17,49)(20,53)
  (23,56)(26,62)(27,63)(28,64)(30,71)(32,73)(35,75)(37,77)(39,79)(41,81)
  (44,83)(46,84)(48,85)(50,86)(52,87)(55,88)(57,89)(59,90)(61,91)(72,92)
  (74,93)(76,94)(78,95)(80,96)(82,97),( 3,24)( 5,25)( 8,28)(12,29)(13,30)
  (16,31)(18,34)(21,35)(23,36)(26,37)(32,38),
 ( 3,24)( 5,25)( 8,27)(10,29)(12,30)(14,31)(18,32)(21,34)(23,35)(28,36)
  (33,38),( 4,5)( 8,9)(10,13)(14,17)(18,20)(21,25)(27,30)(40,42)(44,45)
  (47,49)(50,52)(56,58)(77,78)(81,82),( 3,24)( 5,25)( 8,26)(10,29)(13,30)
  (14,31)(18,32)(21,35)(23,36)(28,37)(34,38),
 ( 4, 5)( 8, 9)( 10,11)( 12,13)( 14,15)( 17,18)( 20,21)( 22,23)
  ( 25,26)( 27,28)( 31,32)( 33,34)( 35,36)( 38,39)( 40,41)( 43,44)
  ( 45,46)( 47,48)( 50,51)( 52,53)( 56,57)( 58,59)( 60,61)( 64,65)
  ( 66,67)( 71,72)( 75,76)( 77,78)( 81,82)( 84,85)( 88,89)( 91,92)
  ( 96,97)( 99,100)(102,103)(104,105)(107,108)(110,111)(113,114)(115,116)
  (119,120)(121,122)(123,124)(127,128)(130,131),
 ( 1,2)( 4,8)( 5,9)( 7,12)(10,15)(13,16),
 ( 1,2)( 4,8)( 5,9)( 7,11)(13,17)(14,18)(15,19)(16,20),
 ( 4, 5)( 8, 9)( 10,11)( 13,14)( 15,16)( 18,19)( 21,22)( 23,24)
  ( 25,26)( 27,28)( 31,32)( 34,35)( 36,37)( 38,39)( 42,43)( 44,45)
  ( 47,48)( 49,50)( 51,52)( 54,55)( 56,57)( 59,60)( 61,62)( 63,64)
  ( 67,68)( 70,71)( 74,75)( 76,77)( 80,81)( 85,86)( 87,88)( 91,92)
  ( 93,94)( 96,97)( 99,100)(104,105)(109,110)(111,112)(114,115)(117,118)
  (121,122)(123,124)(125,126)(129,130)(132,133),
 ( 3,24)( 5,25)( 8,26)(10,27)(13,30)(15,31)(18,32)(22,33)(23,36)(28,37)
  (34,38),( 1,2)( 4,7)( 8,10)(12,15)(16,18)(26,29)(33,36)(39,41)(42,44)
  (46,47)(48,49)(50,52)(53,54)(55,57)(58,59)(62,64)(66,67)(68,69)(70,72)
  (73,74)(77,79)(80,82)(83,84)(86,88)(89,90)(92,94)(96,98),
 ( 4, 5)( 8, 9)( 10,11)( 14,15)( 16,17)( 18,19)( 21,22)( 24,25)
  ( 26,27)( 28,29)( 30,31)( 32,33)( 34,35)( 36,37)( 39,40)( 41,42)
  ( 44,45)( 47,48)( 50,51)( 52,53)( 54,55)( 57,58)( 60,61)( 64,65)
  ( 69,70)( 72,73)( 74,75)( 78,79)( 81,82)( 85,86)( 87,88)( 91,92)
  ( 93,94)( 99,100)(101,102)(105,106)(109,110)(113,114)(117,118),
 ( 3,23)( 5,32)( 6,38)( 7,42)( 9,43)(11,45)(13,49)(18,51)(22,53)(25,54)
  (27,56)(29,60)(31,61)(37,63)(44,65)(48,66)(50,67)(55,68)(59,69)(62,70),
 ( 4,5)( 8,9)(10,11)(14,15)(19,20)(23,24)(26,27)(28,29),
 ( 3,23)( 5,24)( 8,26)(10,29)(12,30)(14,31)(17,32)(20,35)(22,36)(27,37)
  (33,39),( 3,23)( 5,24)( 8,25)(10,29)(13,30)(14,31)(17,32)(20,36)(22,37)
  (28,38)(35,39),( 4,5)( 8,9)(10,11)(17,18)(19,20)(22,23)(25,26)(30,31)
  (57,58)(60,61)(62,63)(65,66)(67,68)(70,71)(72,73)(75,76)(77,78)(80,81)
  (82,83)(85,86),( 4,5)( 8,9)(10,11)(17,18)(20,21)(23,24)(26,27)(32,33)
  (59,60)(61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)
  (79,80)(81,82),( 3,23)( 5,24)( 8,25)(10,28)(13,30)(16,31)(18,32)(20,35)
  (22,37)(27,38)(34,39),( 4,5)( 8,9)(10,11)(21,22)(24,25)(27,28)(30,31),
 ( 3,23)( 5,24)( 8,25)(10,27)(13,30)(17,31)(19,32)(22,36)(26,37)(29,38)
  (33,39)(35,40),( 2,5)( 7,10)(12,14)(16,19)(21,23),(1,2)(4,6),
 ( 3,23)( 5,24)( 8,25)(10,26)(13,30)(15,31)(18,32)(22,34)(28,35)(29,36)
  (33,39)(38,42)(41,43),( 4, 5)( 8, 9)( 11,13)( 14,15)( 18,19)
  ( 23,25)( 27,28)( 35,36)( 41,42)( 46,47)( 58,59)( 60,61)( 65,66)
  ( 70,71)( 79,80)( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)( 97,98)
  ( 99,100)(101,102),( 3,23)( 7,26)(10,27)(12,28)(15,32)(17,33)(20,34)
  (22,35)(25,37)(30,39)(31,40)(36,41)(38,42),
 ( 3,22)( 5,34)( 6,35)( 9,36)( 11,38)( 13,40)( 20,44)( 21,46)
  ( 26,48)( 27,49)( 31,54)( 32,56)( 37,64)( 39,65)( 43,68)( 45,69)
  ( 52,81)( 55,83)( 58,85)( 60,90)( 61,91)( 62,95)( 63,96)( 67,101)
  ( 70,103)( 73,107)( 75,113)( 76,119)( 78,123)( 79,126)( 84,130)( 86,133)
  ( 88,135)( 92,139)( 98,145)(100,148)(102,149)(104,152)(105,154)(109,157)
  (111,159)(115,163)(117,165)(122,167)(124,170)(128,172)(129,174)(131,177)
  (136,179)(138,181)(144,189)(147,190)(168,198)(175,200),
 ( 4,5)( 8,9)(11,12)(14,16)(18,19),( 3,22)( 5,31)( 6,37)( 8,42)(10,43)
  (12,47)(14,49)(17,52)(21,53)(24,54)(26,55)(28,59)(30,61)(36,64)(41,65)
  (46,66)(51,67)(58,68)(63,69),( 1, 2)( 4, 5)( 6, 7)( 8, 9)
  ( 11,12)( 14,15)( 16,17)( 18,19)( 20,21)( 23,24)( 27,28)( 30,31)
  ( 41,42)( 43,44)( 46,47)( 49,50)( 52,53)( 54,55)( 57,58)( 59,60)
  ( 62,63)( 66,67)( 68,69)( 72,73)( 74,75)( 78,79)( 81,82)( 84,85)
  ( 87,88)( 92,93)( 95,96)( 98,99)(101,102)(104,105)(107,108)(109,110)
  (112,113)(115,116)(118,119)(121,122)(124,125),
 ( 3,22)( 5,23)( 8,26)(10,29)(12,30)(16,31)(19,33)(21,34)(27,35)(28,36)
  (32,40)(39,44)(43,45),( 4,5)( 8,9)(11,12)(15,16)(17,18)(20,21)(23,24),
 ( 3,22)( 5,23)( 8,25)(10,28)(13,30)(16,32)(19,35)(21,37)(24,38)(27,39)
  (31,40)(34,41),( 3,22)( 5,23)( 8,25)(10,28)(13,30)(16,31)(19,33)(21,35)
  (26,36)(29,38)(34,41)(39,43)(42,44),( 1,2)( 4,5)( 6,7)( 9,10)(11,12)
  (14,15)(17,18)(19,20)(22,23)(24,25)(27,28)(29,30)(39,40)(42,43)(45,46)
  (47,48)(50,51)(53,54)(56,57)(58,59)(62,63)(64,65)(68,69)(70,71)(74,75)
  (76,77)(80,81)(82,83)(86,87)(88,89)(92,93)(94,95),
 ( 3,22)( 5,23)( 8,24)(10,26)(13,29)(15,31)(18,32)(21,34)(25,36)(28,38)
  (33,41)(37,43)(40,44),( 3,21)( 5,32)( 6,33)( 8,37)( 10,39)
  ( 11,41)( 14,44)( 15,45)( 16,46)( 19,50)( 22,51)( 24,53)( 26,56)
  ( 34,83)( 35,84)( 40,86)( 42,87)( 47,88)( 48,89)( 52,91)( 54,92)
  ( 59,100)( 63,101)( 67,103)( 72,105)( 76,106)( 80,108),
 ( 4,5)( 8,9)(11,12)(15,16)(19,20)(25,26)(29,30)(32,33)(43,44)(46,47)
  (52,53)(55,56),( 3,21)( 5,22)( 7,25)( 8,27)( 11,38)( 12,41)
  ( 15,47)( 16,50)( 17,55)( 19,60)( 20,65)( 24,70)( 28,74)( 30,76)
  ( 31,81)( 32,84)( 33,87)( 34,92)( 35,95)( 36,98)( 37,101)( 40,104)
  ( 43,107)( 45,110)( 46,111)( 49,114)( 51,116)( 52,117)( 54,119)( 57,122)
  ( 59,125)( 61,127)( 62,128)( 63,129)( 64,132)( 67,135)( 69,136)( 73,137)
  ( 77,139)( 78,140)( 80,142)( 82,144)( 83,145)( 85,147)( 86,148)( 88,150)
  ( 89,151)( 91,153)( 93,155)( 94,156)( 96,158)( 97,159)( 99,161)(100,162)
  (102,163)(103,164)(105,165)(106,166)(108,167)(109,168)(112,169)(113,170)
  (115,171)(120,172)(121,173)(123,174)(124,175)(126,176)(130,178)(131,179)
  (133,181)(134,182)(138,183)(143,184)(146,185)(149,186)(154,187)(157,188)
  (160,189)(177,190)(180,191),( 3,21)( 5,22)( 7,23)(10,25)(12,28)(14,30)
  (17,31)(24,35)(26,36)(29,38)(32,39)(33,40)(34,41)(37,42),
 ( 3,20)( 5,23)( 6,26)( 9,28)(13,31)(14,34)(17,37)(19,38)(24,40)(27,41)
  (32,43)(35,44),( 3,20)( 5,21)( 7,24)(10,26)(12,27)(16,31)(19,33)(23,35)
  (25,36)(29,38)(30,39)(32,40)(34,41)(37,42),
 ( 4,5)( 8,9)(11,12)(15,16)(27,28)(31,32)(34,35)(41,42)(48,49)(50,51)
  (52,53)(56,57)(59,60)(65,66)(67,68)(69,70)(73,74),
 ( 1,2)( 4,5)( 6,7)( 9,10)(12,13)(14,15)(17,18)(20,21)(25,26)(28,29)
  (33,34)(36,37)(41,42)(44,45),( 4, 5)( 8, 9)( 11,12)( 16,17)
  ( 19,20)( 22,23)( 25,26)( 28,29)( 31,32)( 35,36)( 37,38)( 40,41)
  ( 43,44)( 45,46)( 50,51)( 53,54)( 55,56)( 61,62)( 66,67)( 68,69)
  ( 83,84)( 89,90)( 92,93)( 95,96)( 99,100),
 ( 3,19)( 5,33)( 6,39)( 7,40)( 9,43)(11,45)(12,46)(14,47)(16,50)(20,54)
  (24,55)(26,58)(29,60)(35,64)(48,65)(51,66)(52,69)(61,70)(62,73)(67,74)
  (71,75),( 4,5)( 8,9)(11,12)(16,17)(21,22)(26,27)(42,43)(47,48)(51,52)
  (56,57)(59,60)(64,65)(69,70)(74,75)(79,80)(84,85),
 ( 3,4)( 8,9)(13,14)(18,19)(22,23),( 4,5)( 8,9)(11,12)(16,17)(22,23)
  (26,27)(46,47)(50,51)(55,56)(59,60)(63,64)(67,68)(71,72)(75,76)(79,80)
  (83,84),( 4,5)( 8,9)(11,12)(17,18)(20,21),
 ( 3,18)( 4,23)( 6,31)( 8,38)( 9,39)(12,43)(14,47)(19,48)(22,52)(24,53)
  (28,59)(32,60)(35,61)(40,62)(44,65)(49,66)(54,69)(56,70)(63,71)(67,72),
 ( 3,18)( 4,23)( 7,32)( 9,33)( 12,35)( 15,40)( 17,41)( 20,43)
  ( 25,48)( 27,56)( 29,64)( 31,74)( 34,77)( 36,78)( 39,79)( 44,82)
  ( 45,83)( 50,91)( 52,93)( 53,94)( 55,96)( 59,99)( 61,101)( 63,102)
  ( 66,104)( 68,106)( 70,109)( 72,111)( 73,112)( 76,114)( 81,116)( 98,129)
  (108,131)(113,132)(115,133),( 4,5)( 8,9)(11,12)(19,20)(21,22)(25,26)
  (29,30)(40,41)(51,52)(61,62)(65,66)(67,68)(71,72)(73,74)(77,78)(79,80)
  (83,84)(85,86)(89,90)(91,92)(95,96),( 3,18)( 5,27)( 6,33)( 8,42)(10,43)
  (12,44)(14,48)(17,51)(22,53)(24,54)(26,55)(29,56)(32,59)(37,61)(41,63)
  (47,64)(50,66)(60,69)(65,71)(68,72),( 2,5)( 9,12)(14,17)(19,22)(25,26)
  (37,38)(45,46)(48,49)(52,53),( 4,5)( 8,9)(12,14)(16,18)(21,22)(25,26)
  (29,30)(33,35)(37,39)(42,43),( 3,18)( 5,24)( 6,27)( 9,35)(12,40)(13,41)
  (15,42)(20,45)(25,47)(28,48)(32,51)(36,53)(38,54)(43,55)(46,56)(49,57)
  (52,58),( 3,18)( 5,20)( 7,23)(10,24)(12,25)(14,29)(17,31)(19,34)(22,36)
  (28,42)(33,45)(38,48)(40,49)(41,50)(43,51)(44,52)(46,53)(47,54),
 ( 4,5)( 8,9)(12,13)(14,15)(21,22)(23,24)(26,27)(29,30)(57,58)(60,61)
  (62,63)(65,66)(67,68)(70,71)(72,73)(75,76)(77,78)(80,81)(82,83)(85,86),
 ( 1,2)( 4,5)( 7,8)( 9,10)(12,13)(15,16)(17,18)(20,21)(23,24)(26,27)
  (31,32)(34,35)(39,40)(42,43),( 3,18)( 6,24)( 9,30)(11,34)(13,40)(14,41)
  (16,42)(19,43)(21,44)(26,47)(28,48)(31,49)(35,50)(38,53)(45,54)(51,55),
 ( 3,18)( 6,20)( 8,24)(10,25)(13,26)(15,29)(17,31)(21,32)(27,38)(30,40)
  (33,43)(34,44)(36,45)(41,48)(46,51)(47,52)(49,53)(50,54),
 ( 1,2)( 4,5)( 7,8)(10,11)(12,13)(14,15)(16,17)(19,20)(21,22)(23,24)
  (25,26)(28,29)(30,31)(39,40)(41,42)(43,44)(46,47)(48,49)(50,51)(52,53)
  (54,55)(56,57)(58,59)(60,61)(78,79)(80,81)(82,83)(85,86)(87,88)(89,90),
 ( 4,5)( 8,9)(12,13)(15,16)(25,26)(27,28)(29,30),
 ( 4,5)( 8,9)(12,13)(16,18)(20,22),( 3,17)( 4,18)( 7,20)( 9,21)(10,23)
  (13,24)(14,25)(16,27)(22,40)(28,41)(37,52)(42,59)(43,60)(50,62)(53,66)
  (61,71)(63,72),( 4,5)( 8,9)(12,13)(16,17)(19,20)(22,23)(25,26)(28,29)
  (31,32)(35,36)(37,38)(41,42)(44,45)(46,47)(50,51)(53,54)(55,56)(59,60)
  (64,65)(67,68)(69,70)(73,74)(79,80)(85,86)(92,93),
 ( 1,12)( 4,25)( 6,32)( 8,35)( 11,38)( 14,42)( 21,45)( 22,47)
  ( 24,50)( 27,54)( 29,55)( 31,56)( 36,60)( 40,65)( 41,66)( 43,69)
  ( 46,72)( 49,74)( 53,77)( 59,82)( 64,85)( 68,88)( 80,96)( 91,104)
  ( 95,106)( 98,110)(101,113)(103,115)(109,119)(112,122),
 ( 3,17)( 5,19)(14,23)(18,41)(24,42)(25,43)(26,45)(27,46)(28,49)(30,50)
  (31,51)(32,53)(33,54)(34,57)(36,58)(37,59)(38,60)(39,63)(44,68)(47,69)
  (48,71)(52,73)(55,74)(56,76)(61,77)(62,79)(64,80)(65,82)(66,84)(81,87)
  (83,89)(85,91),( 4, 5)( 8, 9)( 12,13)( 16,17)( 20,21)( 23,24)
  ( 27,28)( 34,35)( 37,38)( 44,45)( 47,48)( 54,55)( 58,59)( 61,62)
  ( 66,67)( 70,71)( 75,76)( 80,81)( 83,84)( 89,90)( 93,94)( 97,98)
  (103,104)(111,112)(115,116)(118,119),( 3,17)( 6,26)( 9,34)(12,39)(13,41)
  (15,42)(18,44)(21,46)(22,47)(25,48)(28,49)(30,51)(33,53)(36,54)(38,55)
  (45,56)(52,57),( 3,17)( 6,23)( 9,30)(11,34)(12,39)(14,40)(16,41)(19,42)
  (21,43)(26,47)(29,49)(32,50)(33,51)(37,54)(45,56)(52,58),
 ( 4, 5)( 8, 9)( 12,13)( 16,17)( 21,22)( 24,25)( 35,36)( 40,41)
  ( 45,46)( 51,52)( 54,55)( 60,61)( 67,68)( 81,82)( 83,84)( 85,86)
  ( 87,88)( 89,90)( 91,92)( 93,94)( 95,96)( 97,98)( 99,100)(101,102)
  (103,104)(110,111)(112,113)(114,115)(116,117)(118,119)(120,121),
 ( 3,17)( 6,22)( 9,26)(12,31)(15,36)(16,39)(18,41)(20,43)(24,44)(27,45)
  (29,47)(32,49)(34,50)(37,51)(42,52)(48,53),
 ( 1,12)( 4,19)( 6,24)( 8,29)( 9,45)(11,46)(14,49)(15,50)(18,51)(21,52)
  (23,55)(26,56)(28,57)(32,61)(37,64)(48,72)(54,73)(70,78)(74,79)(76,80),
 ( 1,2)( 4,5)( 7,8)(10,11)(14,15)(17,18),
 ( 4,5)( 8,9)(12,13)(16,17)(21,22)(26,27)(31,32)(35,36)(39,40)(43,44)
  (48,49)(53,54),( 4,5)( 8,9)(12,13)(16,17)(21,22)(27,28)(32,33)(49,50)
  (53,54)(57,58)(61,62)(65,66)(69,70)(73,74)(77,78),
 ( 4,5)( 8,9)(12,13)(16,17)(23,24)(28,29)(31,32)(35,36),
 ( 4,5)( 8,9)(12,13)(16,17)(24,25)(29,30)(31,32)(35,36),
 ( 3,17)( 6,18)(13,20)(21,39)(22,40)(23,42)(24,43)(25,44)(26,46)(27,48)
  (28,49)(29,51)(30,52)(31,53)(32,56)(33,58)(34,59)(35,61)(36,62)(37,64)
  (54,71)(65,74)(66,75)(67,79)(68,80)(69,84)(70,85)(72,87)(73,88)(76,89)
  (77,90)(78,91)(81,92)(82,93)(83,94)(86,95),
 ( 3,17)( 7,31)( 9,36)(12,40)(15,41)(16,44)(20,45)(22,48)(24,51)(26,54)
  (29,56)(32,57)(34,60)(35,61)(37,63)(39,65)(43,67)(49,70)(52,72)(55,75)
  (59,76)(66,80)(73,82),( 3,17)( 7,18)( 8,21)( 9,22)(13,25)(14,26),
 ( 3,16)( 4,21)( 6,34)( 8,37)( 10,39)( 11,41)( 14,44)( 15,46)
  ( 17,47)( 19,50)( 23,52)( 26,55)( 33,78)( 35,79)( 40,81)( 42,82)
  ( 45,83)( 48,84)( 51,86)( 53,87)( 60,95)( 62,96)( 66,99)( 71,102)
  ( 73,103)( 77,106),( 1, 4)( 2, 7)( 3,17)( 5,38)( 10,42)( 12,44)
  ( 14,46)( 16,47)( 20,51)( 21,54)( 23,55)( 24,56)( 26,57)( 28,59)
  ( 40,74)( 41,77)( 49,80)( 50,83)( 53,84)( 76,101)( 82,102),
 ( 4,5)( 8,9)(12,13)(17,18)(21,22),( 4,5)( 8,9)(12,13)(17,18)(22,23)
  (27,28)(31,32)(35,36)(39,40)(44,45)(49,50)(54,55),
 ( 4,5)( 8,9)(12,13)(17,18)(22,23)(28,29)(42,43)(48,49)(51,52)(56,57)
  (63,64)(68,69)(73,74)(77,78)(83,84)(86,87)(89,90)(92,93)(95,96)(98,99),
 ( 3,16)( 5,21)( 6,24)( 7,32)( 9,36)( 12,37)( 14,41)( 15,44)
  ( 17,45)( 19,46)( 20,47)( 31,68)( 34,69)( 35,70)( 39,74)( 40,75)
  ( 43,76)( 51,79)( 55,81)( 58,88)( 66,93)( 73,98)( 78,100)( 84,118)
  ( 86,119)( 89,122)( 91,123)( 94,124)( 96,127),
 ( 3,16)( 5,21)( 7,25)( 8,29)(10,48)(12,49)(13,50)(15,51)(18,54)(20,55)
  (23,56)(24,57)(28,59)(31,60)(37,63)(43,66)(53,69)(58,71),
 ( 3,16)( 5,21)( 7,25)( 8,29)(10,43)(12,44)(13,45)(15,46)(18,49)(20,50)
  (23,51)(24,52)(28,54)(33,61)(38,68)(48,72)(53,74)(55,78)(64,81),
 ( 4, 5)( 8, 9)( 12,13)( 18,19)( 23,24)( 26,27)( 42,43)( 46,47)
  ( 50,51)( 52,53)( 55,56)( 57,58)( 60,61)( 62,63)( 65,66)( 67,68)
  ( 69,70)( 82,83)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111),
 ( 4,5)( 8,9)(12,13)(18,19)(24,25)(29,30)(34,35)(52,53)(56,57)(60,61)
  (63,64)(66,67)(69,70)(72,73)(75,76),( 4,5)( 8,9)(12,13)(19,20)(22,23)
  (26,27)(39,40)(44,45)(49,50)(54,55)(58,59)(60,61)(63,64)(65,66)(69,70)
  (71,72)(74,75)(76,77)(79,80)(81,82)(85,86)(87,88),
 ( 3,16)( 6,24)( 7,27)( 9,33)(12,39)(13,41)(15,42)(19,44)(23,47)(26,48)
  (31,50)(36,53)(38,54)(43,55)(46,56)(49,57)(52,58),
 ( 4,5)( 8,9)(12,13)(20,21)(23,24)(26,27)(29,30)(43,44)(52,53)(60,61)
  (62,63)(64,65)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)
  (82,83),( 3,15)( 4,19)( 6,23)( 8,28)( 9,46)(12,47)(14,50)(17,51)(18,52)
  (22,53)(25,56)(27,57)(31,59)(36,64)(40,66)(49,70)(55,71)(58,78)(63,79)
  (65,80),( 4, 5)( 8, 9)( 12,13)( 20,21)( 24,25)( 27,28)( 42,43)
  ( 47,48)( 51,52)( 55,56)( 58,59)( 60,61)( 62,63)( 64,65)( 66,67)
  ( 68,69)( 70,71)( 82,83)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 98,99)(100,101)(102,103)(104,105),
 ( 4, 5)( 8, 9)( 12,13)( 20,21)( 26,27)( 41,42)( 44,45)( 47,48)
  ( 49,50)( 52,53)( 54,55)( 57,58)( 59,60)( 62,63)( 64,65)( 67,68)
  ( 70,71)( 73,74)( 78,79)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 99,100)(102,103)(105,106)(108,109)(111,112),
 ( 3,15)( 4,16)( 7,20)( 8,21)( 9,25)(12,26),
 ( 4,5)( 8,9)(13,15)(17,18)(22,24)(27,29),
 ( 4, 5)( 8, 9)( 13,14)( 16,17)( 21,22)( 25,26)( 32,33)( 36,37)
  ( 41,42)( 47,48)( 53,54)( 55,56)( 61,62)( 67,68)( 69,70)( 85,86)
  ( 88,89)( 90,91)( 93,94)( 96,97)( 99,100)(101,102)(103,104)(105,106)
  (107,108)(109,110)(112,113)(116,117)(120,121),
 ( 3,15)( 5,24)( 6,30)( 7,42)( 9,43)(11,47)(14,50)(19,52)(21,53)(23,54)
  (26,55)(29,58)(34,60)(38,62)(40,63)(46,64)(49,66)(59,69)(65,71)(68,72),
 ( 3,15)( 5,22)( 6,26)( 7,31)( 9,32)(10,34)(11,37)(13,38)(14,40)(17,44)
  (19,45)(20,49)(21,50)(23,52)(24,55)(35,84)(39,85)(47,86)(51,87),
 ( 3,15)( 5,20)( 6,24)( 8,29)( 9,49)(11,50)(14,51)(17,53)(19,55)(22,56)
  (26,57)(28,59)(31,60)(35,62)(42,64)(52,66)(58,67)(61,77)(63,78)(65,79),
 ( 1,11)( 2,17)( 3,23)( 4,27)( 5,35)( 6,38)( 8,39)( 10,40)
  ( 12,43)( 15,45)( 19,47)( 24,48)( 26,51)( 29,52)( 30,55)( 34,57)
  ( 36,58)( 41,60)( 42,63)( 44,64)( 46,65)( 49,66)( 50,69)( 53,71)
  ( 54,72)( 56,75)( 59,77)( 61,79)( 62,80)( 67,83)( 68,84)( 70,87)
  ( 73,89)( 74,90)( 76,91)( 78,93)( 81,95)( 82,97)( 85,99)( 86,100)
  ( 88,101)( 92,102)( 94,103)( 96,104)( 98,105),
 ( 3,15)( 5,17)( 9,19)(18,41)(21,43)(22,44)(23,45)(25,48)(26,49)(28,52)
  (29,53)(30,54)(32,57)(33,58)(35,61)(36,63)(37,64)(39,67)(46,77)(51,78)
  (55,79)(60,80)(66,81)(68,82)(69,83)(71,85)(72,86)(74,88)(75,89)(84,91)
  (87,92)(90,93),( 4,5)( 8,9)(13,14)(17,18)(21,22)(28,29)(33,34)(50,51)
  (54,55)(58,59)(62,63)(66,67)(70,71)(74,75)(78,79),
 ( 2,14)( 4,16)( 6,18)( 8,21)(11,23)(13,26)(17,45)(19,46)(24,47)(29,48)
  (32,50)(36,53)(39,55)(43,58)(51,70)(56,71)(59,72)(63,73)(66,75)(69,77),
 ( 4, 5)( 8, 9)( 13,14)( 17,18)( 22,23)( 28,29)( 42,43)( 46,47)
  ( 52,53)( 56,57)( 59,60)( 64,65)( 69,70)( 75,76)( 80,81)( 96,97)
  ( 99,100)(102,103)(105,106)(108,109)(111,112),
 ( 1,2)( 4,5)(10,11)(13,14)(18,19)(20,21)(25,26)(28,29)(34,35)(42,43)
  (45,46)(51,52)(55,56)(57,58)(59,60)(62,63)(68,69)(72,73)(74,75)(76,77)
  (79,80)(81,82)(84,85),( 1,2)( 4,5)(10,11)(13,14)(20,21)(26,27)(29,30)
  (34,35)(36,37)(42,43)(45,46)(47,48)(50,51)(53,54)(57,58)(60,61)(63,64)
  (65,66)(69,70)(73,74)(77,78)(83,84),( 3,15)(11,20)(13,22)(17,42)(21,44)
  (24,45)(26,46)(27,48)(28,49)(29,51)(31,52)(32,54)(33,55)(34,58)(35,59)
  (37,60)(38,62)(39,63)(40,66)(47,70)(50,71)(53,72)(56,73)(61,74)(64,75)
  (67,77)(68,79)(69,81),( 4,5)( 8,9)(13,14)(18,19)(21,22)(24,25)(28,29)
  (33,34)(43,44)(47,48)(51,52)(55,56),( 2,4)( 5,7)(18,20)(22,24)(29,30)
  (35,37)(40,42)(43,45)(47,48)(50,52)(56,58)(59,61)(63,64)(65,66)(70,71)
  (72,74)(76,77)(80,81)(84,85)(88,89),( 4,5)( 8,9)(13,14)(18,19)(21,22)
  (24,25)(28,29)(33,34)(45,46)(49,50)(53,54)(57,58),
 ( 3,14)( 4,15)( 7,19)( 8,20)( 9,24)(12,25),
 ( 3,14)( 5,19)( 6,28)( 7,29)( 9,33)( 16,42)( 22,52)( 24,61)
  ( 30,71)( 32,72)( 34,73)( 35,74)( 38,77)( 41,79)( 43,80)( 46,83)
  ( 48,90)( 49,92)( 53,94)( 55,97)( 56,98)( 58,101)( 59,103)( 62,105)
  ( 64,106)( 66,109)( 67,110)( 69,113)( 75,114)( 76,115)( 81,116)( 82,117)
  ( 95,134)( 99,136)(107,137)(111,139)(118,143)(120,145)(123,147)(126,149)
  (128,151)(131,153)(144,161)(146,162)(148,163)(150,164)(152,165)(154,166),
 ( 4,5)( 8,9)(13,14)(18,19)(23,24)(26,27)(30,31)(32,33)(40,41)(42,43)
  (45,46),( 1,2)( 4,5)(10,11)(17,18)(20,21)(26,27)(29,30)(34,35)(36,37)
  (42,43)(45,46)(47,48)(51,52)(57,58)(60,61)(63,64)(65,66)(69,70)(73,74)
  (75,76)(77,78)(81,82)(83,84),( 4,5)( 8,9)(13,14)(18,19)(24,25)(29,30)
  (42,43)(48,49)(51,52)(56,57)(63,64)(68,69)(73,74)(77,78)(83,84)(86,87)
  (89,90)(92,93)(95,96)(98,99),( 4,5)( 8,9)(13,14)(18,19)(24,25)(30,31)
  (34,35)(52,53)(56,57)(59,60)(62,63)(65,66)(68,69)(71,72)(74,75),
 ( 4,5)( 8,9)(13,14)(18,19)(26,27)(30,31)(50,51)(52,53)(58,59)(60,61)
  (63,64)(66,67)(69,70)(72,73)(75,76)(78,79),
 ( 4,5)( 8,9)(13,14)(19,20)(21,22)(25,26)(28,29)(33,34)(41,42)(44,45)
  (46,47),( 4,5)( 8,9)(13,14)(19,20)(24,25)(27,28)(31,32)(33,34)(40,41)
  (42,43)(45,46),( 4,5)( 8,9)(13,14)(19,20)(24,25)(29,30)(43,44)(46,47)
  (52,53)(57,58)(62,63)(69,70)(73,74)(77,78)(82,83)(85,86)(88,89)(91,92)
  (94,95)(97,98),( 3,14)( 6,15)( 7,19)( 8,20)(11,24)(12,25),
 ( 2,4)( 5,6)(10,12)(15,16)(18,19),( 4,5)( 8,9)(14,15)(17,18)(20,21),
 ( 1,11)( 2,16)( 3,19)( 6,22)(12,27)(14,29)(21,33)(26,35),
 ( 1,11)( 2,16)( 3,18)( 4,22)( 26,30)( 27,34)( 28,48)( 29,52)
  ( 32,66)( 33,71)( 38,72)( 39,76)( 44,78)( 45,83)( 50,84)( 51,88)
  ( 56,90)( 57,95)( 62,96)( 63,100),( 4,5)( 8,9)(14,15)(18,19)(21,22)
  (25,26),( 4,5)( 8,9)(14,15)(18,19)(22,23)(24,25),
 ( 3,13)( 4,15)( 6,19)( 8,21)(10,22)(16,23),
 ( 1,4)( 2,5)( 7,12)( 8,14)(11,15)(13,16),
 ( 3,13)( 5,18)( 6,28)( 8,32)( 15,41)( 21,46)( 22,51)( 24,60)
  ( 29,71)( 31,72)( 33,73)( 34,74)( 37,77)( 40,79)( 42,80)( 45,83)
  ( 47,90)( 48,92)( 52,94)( 54,97)( 55,98)( 57,101)( 58,103)( 61,105)
  ( 63,106)( 65,109)( 66,110)( 68,113)( 75,114)( 76,115)( 81,116)( 82,117)
  ( 95,134)( 99,136)(107,137)(111,139)(118,143)(120,145)(123,147)(126,149)
  (128,151)(131,153)(144,161)(146,162)(148,163)(150,164)(152,165)(154,166),
 ( 4, 5)( 8, 9)( 14,15)( 19,20)( 22,23)( 29,30)( 42,43)( 46,47)
  ( 50,51)( 52,53)( 55,56)( 57,58)( 60,61)( 62,63)( 65,66)( 67,68)
  ( 69,70)( 82,83)( 85,86)( 88,89)( 91,92)( 94,95)( 97,98)(100,101)
  (102,103)(104,105)(106,107)(108,109)(110,111),
 ( 2,13)( 4,21)( 5,27)( 7,34)( 12,36)( 17,41)( 18,43)( 20,44)
  ( 23,48)( 24,51)( 26,52)( 32,56)( 40,61)( 42,65)( 46,70)( 47,73)
  ( 50,75)( 55,80)( 58,83)( 64,87)( 68,90)( 69,93)( 72,95)( 79,99)
  ( 82,102)( 89,106)( 92,108)(101,112)(105,114),
 ( 4,5)( 8,9)(14,15)(19,20)(25,26)(29,30),
 ( 4,5)( 8,9)(14,15)(20,21)(23,24)(27,28)(32,33)(51,52)(56,57)(62,63)
  (65,66)(68,69)(71,72)(74,75)(77,78),( 4,5)( 8,9)(14,15)(20,21)(25,26)
  (30,31)(34,35)(52,53)(56,57)(60,61)(63,64)(66,67)(69,70)(72,73)(75,76),
 ( 1,11)( 2,15)( 3,17)( 6,19)( 7,20)(14,28)(23,36)(31,39),
 ( 4,5)( 8,9)(15,16)(17,18)(20,21)(26,27)(36,37)(43,44)(49,50)(59,60)
  (61,62)(63,64)(65,66)(68,69)(70,71)(72,73)(74,75)(76,77)(78,79)(80,81)
  (82,83)(86,87)(89,90),( 4,5)( 8,9)(15,16)(18,19)(22,23)(28,29)(39,40)
  (44,45)(49,50)(54,55)(58,59)(60,61)(63,64)(65,66)(69,70)(71,72)(74,75)
  (76,77)(79,80)(81,82)(85,86)(87,88),( 4, 5)( 8, 9)( 15,16)( 18,19)
  ( 22,23)( 30,31)( 43,44)( 47,48)( 51,52)( 56,57)( 58,59)( 60,61)
  ( 62,63)( 64,65)( 66,67)( 68,69)( 70,71)( 82,83)( 84,85)( 86,87)
  ( 88,89)( 90,91)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105),( 4, 5)( 8, 9)( 15,16)( 18,19)( 23,24)( 29,30)( 42,43)
  ( 44,45)( 48,49)( 52,53)( 56,57)( 58,59)( 60,61)( 63,64)( 65,66)
  ( 68,69)( 70,71)( 83,84)( 86,87)( 89,90)( 92,93)( 95,96)( 98,99)
  (100,101)(102,103)(104,105)(106,107)(108,109)(110,111),
 ( 2,4)( 6,8)( 9,11)(10,12),( 4,7)( 9,11)(13,15),
 ( 4,5)( 8,9)(15,16)(19,20)(25,26)(35,36)(38,39)(45,46)(48,49)(52,53)
  (55,56)(58,59)(63,64)(66,67)(71,72)(73,74)(76,77)(79,80)(84,85),
 ( 4, 5)( 8, 9)( 15,16)( 20,22)( 33,34)( 38,39)( 45,46)( 48,49)
  ( 51,52)( 53,54)( 56,57)( 59,60)( 62,63)( 65,66)( 68,69)( 80,81)
  ( 84,85)( 88,89)( 92,93)( 94,95)( 96,97)( 98,99)(100,101)(102,103)
  (104,105)(106,107)(108,109)(110,111)(112,113)(114,115)(116,117)(118,119)
  (120,121)(134,135)(136,137)(138,139)(140,141)(142,143)(144,145),
 ( 4,5)( 8,9)(15,16)(20,21)(23,24)(28,29)(32,33)(34,35),
 ( 4,5)( 8,9)(15,16)(20,21)(25,26)(30,31)(40,41)(45,46)(49,50)(54,55)
  (60,61)(65,66)(70,71)(75,76)(80,81)(85,86),
 ( 3,12)( 5,13)( 7,15)(16,20)(17,22)(18,26)(19,28),
 ( 4,5)( 8,9)(16,17)(19,20)(22,23)(27,28)(31,32)(35,36)(39,40)(43,44)
  (45,46)(49,50)(53,54)(55,56)(60,61)(64,65)(66,67)(72,73),
 ( 1,2)( 5,7)( 9,11)(14,16)(19,21),( 1,11)( 2,14)( 5,18)( 7,20)(12,21)
  (17,23),( 4,5)( 8,9)(16,17)(21,22)(26,27)(30,31)(48,49)(50,51)(56,57)
  (58,59)(64,65)(67,68)(70,71)(73,74)(76,77)(79,80),
 ( 4,5)( 8,9)(16,17)(21,22)(26,27)(32,33),
 ( 4,5)( 8,9)(16,17)(21,22)(26,27)(33,34),
 ( 4,5)( 8,9)(16,17)(21,22)(26,27)(34,35)(41,42),
 ( 4,5)( 8,9)(16,17)(21,22)(27,28)(34,35),
 ( 4, 5)( 8, 9)( 16,17)( 22,23)( 29,30)( 41,42)( 44,45)( 47,48)
  ( 49,50)( 52,53)( 54,55)( 57,58)( 59,60)( 62,63)( 64,65)( 67,68)
  ( 70,71)( 73,74)( 78,79)( 84,85)( 86,87)( 88,89)( 90,91)( 92,93)
  ( 94,95)( 96,97)( 99,100)(102,103)(105,106)(108,109)(111,112),
 ( 3,11)( 5,16)( 6,18)( 7,22)(13,24)(15,26)(23,27)(25,28),
 ( 3,11)( 5,15)( 6,21)( 7,22)(10,24)(14,25)(18,27),
 ( 3,11)( 5,15)( 6,19)( 7,22)( 9,24)(14,25)(17,27),
 ( 1,11)( 2,13)( 4,16)( 7,20)(14,21)(19,23),
 ( 4,5)( 9,11)(12,14)(16,19)(23,24)(26,28)(31,34)(45,46)(54,55)(59,60)
  (61,62)(63,64)(66,67)(68,69)(70,71)(72,73)(74,75)(76,77)(79,80)(81,82)
  (83,84),( 4,5)( 9,11)(12,14)(17,20)(21,23)(26,27)(31,33)(46,47)(56,57)
  (61,62)(63,64)(65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(77,78)(79,80)
  (81,82)(83,84),( 3,11)( 5,13)( 7,17)( 8,19)( 9,22)(16,23),
 ( 4,5)( 9,11)(13,15)(16,19)(21,22)(24,26)(28,30)(39,40)(48,49)(55,57)
  (60,61)(62,64)(66,67)(68,70)(72,73)(74,76)(79,80)(81,83)(85,86)(87,89)
  (91,92),( 4,5)( 9,11)(13,15)(17,18)(21,22)(25,26)(29,30)(32,33),
 ( 1,2)( 5,6)( 7,8)(15,16)(18,19)(22,23)(28,29)(44,45)(55,56)(61,62)
  (65,66)(67,68)(71,72)(73,74)(77,78)(79,80)(83,84)(85,86)(89,90)(91,92)
  (95,96),( 3,11)( 5,13)( 7,14)( 9,16)(18,20)(19,25),
 ( 4,5)( 9,11)(13,14)(16,17)(21,22),( 3,11)( 5,12)( 8,15)( 9,16)(13,17),
 ( 1,11)( 3,18)( 6,31)( 7,40)(10,45)(14,48)(17,49)(21,50)(24,51)(27,52)
  (30,55)(33,56)(35,57)(39,58)(43,59)(46,60)(53,61),
 ( 3,11)( 6,15)( 8,16)( 9,17)(13,19)(18,21)(20,22),
 ( 4,7)(10,12)(13,15)(16,18)(21,22)(26,27)(28,29)(32,33),
 ( 4,5)( 9,11)(14,15)(22,24)(27,29)(30,32)(35,37)(44,45)(48,50),
 ( 4,5)( 9,11)(15,17)(19,20)(22,24)(26,28)(38,39)(42,43)(53,54)(62,63)
  (65,66)(67,68)(69,70)(71,72)(73,74)(75,76)(78,79)(80,81)(82,83)(84,85)
  (86,87)(88,89)(91,92),( 1,2)( 5,6)( 8,9)(13,14)(16,17)(23,24)(34,35)
  (39,40)(44,45)(47,48)(49,50)(52,53)(54,55)(57,58)(59,60)(65,66)(68,69)
  (70,71)(73,74)(75,76)(77,78)(80,81)(82,83)(85,86)(87,88)(90,91)(93,94),
 ( 4,5)( 9,11)(18,19)(22,24)(27,29)(32,33)(40,42)(45,47)(48,50),
 ( 1,2)( 5,6)( 8,9)(16,17)(19,20),( 4,5)( 9,10)(11,12)(13,14)(16,17)
  (18,19)(20,21)(22,23),( 1,2)( 5,6)( 8,9)(18,19)(22,23)(25,26)(29,30)
  (44,45)(48,49)(50,51)(52,53)(57,58)(60,61)(65,66)(67,68)(70,71)(76,77)
  (78,79)(86,87),( 4,5)( 9,10)(11,12)(14,15)(16,17)(18,19)(20,21)(22,23)
  (27,28)(29,30),( 4,5)( 9,10)(11,12)(14,15)(18,19)(20,21)(23,24)(26,27)
  (28,29)(32,33)(36,37)(40,41)(44,45)(50,51)(52,53)(60,61)(62,63)(65,66)
  (69,70)(71,72)(74,75)(79,80)(89,90)(92,93)(94,95),
 ( 4,5)( 9,10)(11,12)(14,15)(18,19),( 3,10)( 4,14)( 5,17)( 6,19)( 7,20)
  ( 8,22)( 9,24)(11,32)(12,35)(15,41)(18,45)(21,46)(23,51)(27,53)(28,54)
  (29,59)(30,60)(31,65)(34,68)(38,69)(40,70)(44,71)(48,72)(50,73)(52,77)
  (55,78)(56,79)(58,81)(61,82)(62,83)(64,85)(66,86)(74,88)(75,90)(76,92)
  (89,94)(91,95)(93,96),( 3,10)( 4,13)( 5,15)( 6,16)( 7,17)
  ( 8,19)( 9,20)( 11,34)( 14,38)( 18,44)( 21,48)( 25,51)( 26,54)
  ( 27,56)( 28,60)( 29,63)( 31,64)( 33,66)( 35,68)( 37,69)( 39,71)
  ( 41,72)( 43,74)( 45,76)( 47,77)( 49,79)( 50,83)( 52,85)( 55,87)
  ( 57,89)( 59,91)( 61,93)( 80,95)( 81,96)( 82,97)( 84,98)( 86,99)
  ( 88,100)( 90,101)( 92,102)( 94,103),( 4,5)( 9,10)(11,12)(20,21)(23,24)
  (27,28)(30,31),( 4,5)( 9,10)(11,12)(21,22)(24,25)(28,29)(31,32),
 ( 1,2)( 5,6)( 9,10)(13,14)(25,26)(29,30)(34,35)(38,39)(41,42)(45,46),
 ( 3,10)( 4,12)( 6,13)( 9,16)(11,17),( 4,5)( 9,10)(12,14)(16,17)(19,21),
 ( 4,5)( 9,10)(12,14)(16,17)(21,23)(26,28),
 ( 3,10)( 4,11)( 5,13)( 6,14)( 7,17)( 8,20)( 9,22)(12,36)(15,40)(18,46)
  (21,50)(27,55)(28,58)(29,60)(30,63)(31,65)(33,66)(35,67)(37,68)(39,69)
  (41,70)(43,71)(45,72)(47,73)(49,74)(51,75)(52,79)(54,81)(56,83)(59,85)
  (61,87)(64,89)(76,91)(77,92)(78,93)(80,94)(82,95)(84,96)(86,97)(88,98)
  (90,99),( 1,2)( 5,6)( 9,10)(13,14)(26,27)(29,30)(34,35)(37,38)(39,40)
  (42,43),( 3,10)( 4,11)( 6,13)( 9,16)(12,17),
 ( 4,5)( 9,10)(12,13)(14,15)(18,19)(21,22)(23,24)(27,28),
 ( 4,5)( 9,10)(12,13)(14,15)(18,19)(23,24)(28,29)(44,45)(46,47)(50,51)
  (52,53),( 1,2)( 5,6)( 9,10)(13,14)(27,28)(29,30)(33,34)(35,36),
 ( 4,5)( 9,10)(12,13)(15,17)(21,22),( 4,5)( 9,10)(12,13)(15,16)(17,18)
  (24,25)(26,27)(30,31)(57,58)(60,61)(62,63)(65,66)(67,68)(70,71)(72,73)
  (75,76)(77,78)(80,81)(82,83)(85,86),( 3,10)( 5,20)( 8,21)(11,22)(13,24)
  (14,26)(16,28)(17,30)(19,32),( 4, 5)( 9,10)( 12,13)( 15,16)
  ( 19,20)( 21,22)( 24,25)( 27,28)( 29,30)( 36,37)( 40,41)( 42,43)
  ( 46,47)( 48,49)( 51,52)( 54,55)( 56,57)( 63,64)( 66,67)( 68,69)
  ( 70,71)( 72,73)( 75,76)( 79,80)( 81,82)( 89,90)( 91,92)(103,104)
  (105,106)(109,110)(111,112)(113,114)(115,116),
 ( 4,5)( 9,10)(12,13)(15,16)(19,20)(23,24)(27,28)(30,31)(44,45)(48,49)
  (53,54)(57,58),( 4,5)( 9,10)(12,13)(15,16)(21,22)(25,26)(28,29)(43,44)
  (46,47)(49,50)(52,53)(54,55)(74,75)(78,79),
 ( 1,2)( 5,6)( 9,10)(16,17)(18,19),( 1,2)( 5,6)( 9,10)(18,19)(24,25)
  (28,29)(33,34)(38,39)(42,43)(46,47)(50,51)(53,54),
 ( 1, 2)( 5, 6)( 9,10)( 18,19)( 24,25)( 40,41)( 44,45)( 48,49)
  ( 50,51)( 54,55)( 56,57)( 60,61)( 62,63)( 66,67)( 68,69)( 71,72)
  ( 75,76)( 78,79)( 84,85)( 92,93)( 95,96)( 98,99)(101,102)(104,105)
  (107,108)(109,110)(112,113)(115,116)(118,119)(121,122)(124,125),
 ( 1,2)( 5,6)( 9,10)(18,19)(25,26)(27,28)(32,33)(34,35),
 ( 4,5)( 9,10)(12,13)(16,17)(21,22),( 4,5)( 9,10)(12,13)(16,17)(23,24)
  (27,28)(43,44)(47,48)(51,52)(55,56)(58,59)(63,64)(68,69)(73,74)(78,79)
  (83,84),( 2,11)( 3,15)( 5,19)( 7,24)( 9,48)(12,49)(16,51)(17,52)(20,53)
  (22,54)(25,57)(27,58)(28,59)(35,62)(41,65)(47,68)(50,70)(55,72),
 ( 1,11)( 3,12)( 6,15)( 8,16),( 1,2)( 5,6)( 9,10)(19,20)(25,26)(28,29)
  (33,34)(36,37)(39,40)(43,44)(48,49)(51,52),
 ( 1,2)( 5,6)( 9,10)(19,20)(25,26)(28,29)(33,34)(37,38)(40,41)(44,45)
  (48,49)(51,52),( 1,2)( 5,6)( 9,10)(19,20)(25,26)(28,29)(33,34)(38,39)
  (41,42)(44,45)(47,48)(49,50),( 4,5)( 9,10)(13,15)(17,19)(20,21)(27,28)
  (30,32)(34,36)(38,39)(43,44)(48,49)(61,62)(64,65)(67,68)(70,71)(73,74)
  (76,77),( 3,10)( 5,11)( 6,12)( 9,14)(13,18)(15,19),
 ( 1,11)( 4,24)( 6,33)( 8,40)(12,46)(15,47)(18,48)(21,49)(25,50)(29,53)
  (31,54)(34,55)(37,56)(41,57)(44,58)(45,60)(52,61),
 ( 1,11)( 4,19)( 5,24)( 7,29)( 9,47)(10,50)(14,51)(16,52)(18,53)(21,56)
  (23,57)(26,58)(28,59)(35,64)(42,69)(49,70)(55,71)(61,74)(66,75),
 ( 4,5)( 9,10)(13,14)(15,16)(18,19)(21,22)(38,39)(41,42)(44,45)(50,51)
  (54,55)(59,60)(63,64),( 1,11)( 4,19)( 6,23)( 8,27)( 9,48)(12,49)(14,50)
  (15,51)(17,54)(20,55)(24,56)(25,57)(28,60)(33,62)(39,66)(44,68)(52,71)
  (58,72),( 1,4)( 5,8)( 9,12)(25,26)(27,28)(29,30)(34,35)(36,37)(38,39)
  (41,42)(43,44)(45,46),( 1,11)( 4,18)( 6,23)( 8,28)(10,48)(13,51)(14,52)
  (17,53)(20,54)(22,57)(25,58)(27,59)(30,60)(32,61)(35,64)(42,67)(50,68)
  (56,69),( 1,11)( 4,18)( 6,23)( 8,28)(10,45)(13,48)(14,49)(17,50)(20,51)
  (22,54)(25,55)(27,56)(30,57)(32,59)(37,62)(47,72)(53,73)(68,78)(74,79)
  (76,80),( 3,10)( 6,13)( 7,15)( 8,16)(12,19)(17,22)(20,23),
 ( 1,11)( 4,15)( 6,17)( 7,20)(10,21)(16,23),
 ( 3,10)( 6,12)( 7,14)( 8,18)(15,20)(16,22),
 ( 1,2)( 5,6)(10,11)(16,17)(20,21)(24,25),
 ( 4, 5)( 9,10)( 13,14)( 16,17)( 25,26)( 41,42)( 44,45)( 53,54)
  ( 56,57)( 59,60)( 61,62)( 63,64)( 65,66)( 67,68)( 69,70)( 71,72)
  ( 73,74)( 75,76)( 77,78)( 79,80)( 81,82)( 95,96)( 97,98)( 99,100)
  (101,102)(103,104)(105,106),( 1,2)( 5,6)(10,11)(17,18)(28,29)(36,37),
 ( 1,2)( 5,6)(10,11)(18,19)(27,28)(35,36)(42,43),
 ( 3,10)( 6,12)( 7,14)(13,18)(15,21)(16,22)(19,24)(23,26)(25,27),
 ( 4,5)( 9,10)(13,14)(17,18)(20,21)(25,26)(31,32)(42,43)(45,46)(49,50)
  (51,52)(56,57)(74,75)(79,80),( 4,5)( 9,10)(13,14)(17,18)(20,21),
 ( 1,7)( 3,11)( 5,16)(10,22)(17,24)(19,25)(21,27)(23,29),
 ( 2,11)( 3,12)( 5,13)( 7,14)( 8,15)(10,16),
 ( 1,2)( 5,6)(11,12)(21,22)(26,27)(30,31)(39,40)(42,43)(45,46)(48,49)
  (53,54)(56,57)(61,62)(63,64)(66,67)(70,71)(73,74)(79,80)(86,87),
 ( 1,2)( 5,6)(11,12)(21,22)(26,27)(30,31)(39,40)(42,43)(45,46)(52,53)
  (57,58)(60,61)(63,64)(66,67)(71,72)(74,75)(78,79)(83,84)(85,86)(89,90)
  (94,95),( 4,5)( 9,10)(13,14)(17,18)(22,23)(27,28)(42,43)(48,49)(51,52)
  (56,57)(63,64)(68,69)(73,74)(77,78)(83,84)(86,87)(89,90)(92,93)(95,96)
  (98,99),( 1,2)( 5,6)(12,13)(15,16)(17,18),
 ( 4,5)( 9,10)(13,14)(18,19)(22,23)(25,26)(28,29)(31,32)(34,35),
 ( 1,11)( 7,31)( 10,32)( 12,36)( 13,37)( 15,39)( 18,40)( 21,41)
  ( 23,43)( 24,44)( 25,46)( 33,72)( 35,75)( 38,78)( 42,83)( 45,86)
  ( 47,95)( 49,97)( 51,99)( 53,101)( 56,105)( 58,107)( 60,109)( 62,111)
  ( 64,113)( 67,117)( 69,119)( 71,120)( 74,121)( 76,122)( 80,123)( 82,124)
  ( 84,125)(102,133)(114,135),( 1,11)( 7,15)( 12,33)( 13,35)( 16,37)
  ( 20,42)( 21,43)( 23,45)( 25,50)( 26,51)( 27,54)( 29,55)( 30,59)
  ( 31,60)( 32,61)( 36,63)( 39,64)( 41,81)( 44,83)( 46,85)( 49,87)
  ( 53,90)( 56,92)( 58,94)( 65,98)( 67,100)( 68,103)( 69,104)( 70,107)
  ( 72,109)( 73,112)( 74,114)( 76,117)( 77,118)( 78,120)( 79,122)( 88,125)
  ( 95,127),( 1,2)( 5,6)(13,14)(18,19)(25,26)(32,33),
 ( 1,2)( 5,6)(13,14)(18,19)(26,27)(33,34)(41,42),
 ( 1,2)( 5,6)(13,14)(18,19)(26,27)(33,34),
 ( 2,4)( 7,9)(18,20)(25,26)(28,29)(33,34)(38,39)(41,42),
 ( 3,9)( 4,20)( 7,21)(11,22)(13,24)(14,26)(16,28)(17,30)(19,32),
 ( 1,10)( 2,24)( 3,27)( 4,32)(34,41)(35,45)(36,56)(37,60)(39,68)(42,69)
  (44,72)(47,74)(49,75)(52,76)(54,79)(57,81)(59,82)(62,83)(64,86)(67,88),
 ( 1,2)( 5,6)(15,16)(18,19)(22,23)(34,35)(38,39)(44,45)(47,48)(52,53)
  (54,55)(56,57)(64,65)(69,70)(71,72)(73,74)(78,79)(82,83),
 ( 1,10)( 2,21)( 3,49)( 6,50)( 8,51)( 15,53)( 18,54)( 22,55)
  ( 26,58)( 29,59)( 31,60)( 35,64)( 37,65)( 41,69)( 43,70)( 46,74)
  ( 56,80)( 57,82)( 62,87)( 63,89)( 67,91)( 68,93)( 72,95)( 73,97)
  ( 75,100)( 78,102)( 79,103)( 99,104)(101,105),
 ( 1,2)( 5,6)(15,16)(19,20)(24,25)(27,28)(31,32)(34,35),
 ( 1,2)( 5,6)(16,17)(18,19)(23,24)(27,28)(29,30),
 ( 4,5)( 9,10)(13,14)(21,22)(27,28)(33,34),
 ( 4,5)( 9,10)(13,14)(21,22)(27,28)(34,35),( 3,9)( 4,10)( 5,12)( 7,13),
 ( 1,2)( 5,6)(16,17)(21,22)(23,24)(27,28)(30,31),
 ( 1,2)( 5,6)(16,17)(21,22)(24,25)(27,28)(30,31),( 4,5)( 9,10)(13,14),
 ( 1,2)( 5,6)(17,18)(19,20)(23,24)(27,28)(30,31),
 ( 1,2)( 5,6)(17,18)(21,22)(24,25)(28,29)(38,39)(43,44)(45,46)(50,51)
  (53,54)(59,60)(61,62)(63,64)(69,70)(72,73)(76,77)(80,81),
 ( 3,9)( 5,21)( 8,23)(12,25)(14,26)(15,27)(17,28)(18,29)(20,30),
 ( 1,10)( 2,17)( 3,30)( 4,35)( 5,38)( 7,39)( 9,41)(13,44)(14,46)(16,48)
  (19,49)(22,51)(24,53)(26,55)(27,57)(29,59)(31,61)(33,62)(36,63)(40,65)
  (42,67)(43,68)(47,70)(50,71)(52,73)(54,74)(56,75)(60,77)(64,78)(66,79)
  (69,80)(72,81)(76,82),( 1,2)( 6,12)( 7,14)( 8,16)( 9,17)(10,18)(11,19)
  (13,20)(15,21),( 3,9)( 5,13)( 6,14)( 8,16)(12,18),
 ( 1,2)( 6,11)( 7,13)( 8,15)( 9,16)(10,17)(12,19)(14,21)(18,23)(20,24)
  (22,25),( 4,6)( 7,9)(11,13)(14,16)(19,21)(23,24)(26,27)(28,29),
 ( 3,9)( 5,12)( 8,15)(10,16)(13,17),( 4,6)( 7,9)(11,13)(15,18)(23,24)
  (29,30),( 1,10)( 2,16)( 3,23)( 4,27)( 5,30)( 32,49)( 35,56)
  ( 36,57)( 41,60)( 42,61)( 45,65)( 50,67)( 51,69)( 54,72)( 55,81)
  ( 73,91)( 76,94)( 79,97)( 82,100)( 85,103)( 88,106)( 89,108)( 92,110)
  ( 95,114)( 98,116)(101,120)(104,122),( 1,2)( 6,8)(10,12)(13,15)(16,17)
  (18,20)(21,22)(23,25)(26,27)(28,30)(31,33)(35,37)(38,40)(41,42)(43,45)
  (46,47)(48,50)(51,52)(53,55),( 1,10)( 2,16)( 3,22)( 4,34)
  ( 6,35)( 8,39)( 12,43)( 14,46)( 18,47)( 19,51)( 21,53)( 26,58)
  ( 38,83)( 41,84)( 45,85)( 50,86)( 54,87)( 57,88)( 60,95)( 64,97)
  ( 68,99)( 72,101)( 76,103)( 80,105),( 1,2)(