/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public abstract class Box {
    public static boolean DEBUG = false;
    protected Color foreground;
    protected Color background;
    private Color prevColor;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float depth = 0.0f;
    protected float shift = 0.0f;
    protected int type = -1;
    protected LinkedList<Box> children = new LinkedList();
    protected Box parent;
    protected Box elderParent;
    protected Color markForDEBUG;

    public void add(Box box) {
        this.children.add(box);
        box.parent = this;
        box.elderParent = this.elderParent;
    }

    public void add(int n, Box box) {
        this.children.add(n, box);
        box.parent = this;
        box.elderParent = this.elderParent;
    }

    protected Box() {
        this(null, null);
    }

    protected Box(Color color, Color color2) {
        this.foreground = color;
        this.background = color2;
    }

    public void setParent(Box box) {
        this.parent = box;
    }

    public Box getParent() {
        return this.parent;
    }

    public void setElderParent(Box box) {
        this.elderParent = box;
    }

    public Box getElderParent() {
        return this.elderParent;
    }

    public float getWidth() {
        return this.width;
    }

    public void negWidth() {
        this.width = -this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getShift() {
        return this.shift;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public void setDepth(float f) {
        this.depth = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setShift(float f) {
        this.shift = f;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public abstract int getLastFontId();

    protected void startDraw(Graphics2D graphics2D, float f, float f2) {
        this.prevColor = graphics2D.getColor();
        if (this.background != null) {
            graphics2D.setColor(this.background);
        }
        if (this.foreground == null) {
            graphics2D.setColor(this.prevColor);
        } else {
            graphics2D.setColor(this.foreground);
        }
        this.drawDebug(graphics2D, f, f2);
    }

    protected void drawDebug(Graphics2D graphics2D, float f, float f2, boolean bl) {
        if (DEBUG) {
            Color color;
            Stroke stroke = graphics2D.getStroke();
            if (this.markForDEBUG != null) {
                color = graphics2D.getColor();
                graphics2D.setColor(this.markForDEBUG);
                graphics2D.fill(new Rectangle2D.Float(f, f2 - this.height, this.width, this.height + this.depth));
                graphics2D.setColor(color);
            }
            graphics2D.setStroke(new BasicStroke((float)Math.abs(1.0 / graphics2D.getTransform().getScaleX()), 0, 0));
            if (this.width < 0.0f) {
                f += this.width;
                this.width = -this.width;
            }
            graphics2D.draw(new Rectangle2D.Float(f, f2 - this.height, this.width, this.height + this.depth));
            if (bl) {
                color = graphics2D.getColor();
                graphics2D.setColor(Color.RED);
                if (this.depth > 0.0f) {
                    graphics2D.fill(new Rectangle2D.Float(f, f2, this.width, this.depth));
                    graphics2D.setColor(color);
                    graphics2D.draw(new Rectangle2D.Float(f, f2, this.width, this.depth));
                } else if (this.depth < 0.0f) {
                    graphics2D.fill(new Rectangle2D.Float(f, f2 + this.depth, this.width, -this.depth));
                    graphics2D.setColor(color);
                    graphics2D.draw(new Rectangle2D.Float(f, f2 + this.depth, this.width, -this.depth));
                } else {
                    graphics2D.setColor(color);
                }
            }
            graphics2D.setStroke(stroke);
        }
    }

    protected void drawDebug(Graphics2D graphics2D, float f, float f2) {
        if (DEBUG) {
            this.drawDebug(graphics2D, f, f2, true);
        }
    }

    protected void endDraw(Graphics2D graphics2D) {
        graphics2D.setColor(this.prevColor);
    }
}

