/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.plugins.BuildConfigurationRule;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.plugins.UploadRule;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";
    public static final String UPLOAD_ARCHIVES_TASK_NAME = "uploadArchives";
    public static final String UPLOAD_GROUP = "upload";
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurationActionContainer configurationActionContainer;

    @Inject
    public BasePlugin(ProjectPublicationRegistry publicationRegistry, ProjectConfigurationActionContainer configurationActionContainer) {
        this.publicationRegistry = publicationRegistry;
        this.configurationActionContainer = configurationActionContainer;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        BasePluginConvention convention = new BasePluginConvention(project);
        project.getConvention().getPlugins().put("base", convention);
        this.configureBuildConfigurationRule(project);
        this.configureUploadRules(project);
        this.configureUploadArchivesTask();
        this.configureArchiveDefaults(project, convention);
        this.configureConfigurations(project);
        this.configureAssemble((ProjectInternal)project);
    }

    private void configureArchiveDefaults(final Project project, final BasePluginConvention pluginConvention) {
        project.getTasks().withType(AbstractArchiveTask.class, (Action)new Action<AbstractArchiveTask>(){

            public void execute(AbstractArchiveTask task) {
                ConventionMapping taskConventionMapping = task.getConventionMapping();
                Callable<File> destinationDir = task instanceof Jar ? new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return pluginConvention.getLibsDir();
                    }
                } : new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return pluginConvention.getDistsDir();
                    }
                };
                taskConventionMapping.map("destinationDir", (Callable)destinationDir);
                taskConventionMapping.map("version", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return project.getVersion() == "unspecified" ? null : project.getVersion().toString();
                    }
                });
                taskConventionMapping.map("baseName", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return pluginConvention.getArchivesBaseName();
                    }
                });
            }
        });
    }

    private void configureBuildConfigurationRule(Project project) {
        project.getTasks().addRule((Rule)new BuildConfigurationRule(project.getConfigurations(), project.getTasks()));
    }

    private void configureUploadRules(Project project) {
        project.getTasks().addRule((Rule)new UploadRule(project));
    }

    private void configureUploadArchivesTask() {
        this.configurationActionContainer.add((Action)new Action<Project>(){

            public void execute(Project project) {
                boolean hasIvyRepo;
                Upload uploadArchives = (Upload)((Object)project.getTasks().withType(Upload.class).findByName(BasePlugin.UPLOAD_ARCHIVES_TASK_NAME));
                if (uploadArchives == null) {
                    return;
                }
                boolean bl = hasIvyRepo = !uploadArchives.getRepositories().withType(IvyArtifactRepository.class).isEmpty();
                if (!hasIvyRepo) {
                    return;
                }
                ConfigurationInternal configuration = (ConfigurationInternal)uploadArchives.getConfiguration();
                ModuleInternal module = configuration.getModule();
                DefaultModuleVersionIdentifier publicationId = new DefaultModuleVersionIdentifier(module.getGroup(), module.getName(), module.getVersion());
                BasePlugin.this.publicationRegistry.registerPublication(module.getProjectPath(), (ProjectPublication)new DefaultProjectPublication((ModuleVersionIdentifier)publicationId));
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        project.setProperty("status", (Object)"integration");
        Configuration archivesConfiguration = ((Configuration)configurations.create("archives")).setDescription("Configuration for archive artifacts.");
        ((Configuration)configurations.create("default")).setDescription("Configuration for default artifacts.");
        final DefaultArtifactPublicationSet defaultArtifacts = (DefaultArtifactPublicationSet)project.getExtensions().create("defaultArtifacts", DefaultArtifactPublicationSet.class, new Object[]{archivesConfiguration.getArtifacts()});
        configurations.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                configuration.getArtifacts().all((Action)new Action<PublishArtifact>(){

                    public void execute(PublishArtifact artifact) {
                        defaultArtifacts.addCandidate(artifact);
                    }
                });
            }
        });
    }

    private void configureAssemble(ProjectInternal project) {
        project.getTasks().getByName(ASSEMBLE_TASK_NAME).dependsOn(new Object[]{project.getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies()});
    }
}

