/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultModelRegistration
implements ModelRegistration {
    private final ModelPath path;
    private final ModelRuleDescriptor descriptor;
    private final boolean service;
    private final boolean ephemeral;
    private final boolean hidden;
    private final ListMultimap<ModelActionRole, ? extends ModelAction> actions;

    public DefaultModelRegistration(ModelPath path, ModelRuleDescriptor descriptor, boolean service, boolean ephemeral, boolean hidden, Multimap<ModelActionRole, ? extends ModelAction> actions) {
        this.path = path;
        this.descriptor = descriptor;
        this.service = service;
        this.ephemeral = ephemeral;
        this.hidden = hidden;
        this.actions = ImmutableListMultimap.copyOf(actions);
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ListMultimap<ModelActionRole, ? extends ModelAction> getActions() {
        return this.actions;
    }

    @Override
    public Set<? extends ModelReference<?>> getInputs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModelAction action : this.actions.values()) {
            builder.addAll(action.getInputs());
        }
        return builder.build();
    }

    @Override
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Override
    public boolean isService() {
        return this.service;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

