/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractedModelRegistration
implements ExtractedModelRule {
    private final ModelRegistration registration;

    public ExtractedModelRegistration(ModelRegistration registration) {
        this.registration = registration;
    }

    @Override
    public void apply(ModelRegistry modelRegistry, ModelPath scope) {
        if (!scope.equals(ModelPath.ROOT)) {
            throw new InvalidModelRuleDeclarationException(String.format("Rule %s cannot be applied at the scope of model element %s as creation rules cannot be used when applying rule sources to particular elements", this.registration.getDescriptor(), scope));
        }
        modelRegistry.register(this.registration);
    }

    public List<Class<?>> getRuleDependencies() {
        return ImmutableList.of();
    }
}

