/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessorExtractionContext {
    private final Collection<Method> declaringMethods;
    private final Method mostSpecificDeclaration;
    private final String mostSpecificSignature;
    private final boolean declaredInManagedType;
    private final boolean declaredAsAbstract;
    private final Map<Class<? extends Annotation>, Annotation> annotations;

    public PropertyAccessorExtractionContext(Iterable<Method> declaringMethods) {
        Method mostSpecificDeclaration = ModelSchemaUtils.findMostSpecificMethod(declaringMethods);
        this.declaringMethods = ImmutableList.copyOf(declaringMethods);
        this.mostSpecificDeclaration = mostSpecificDeclaration;
        this.mostSpecificSignature = AsmClassGeneratorUtils.signature(mostSpecificDeclaration);
        this.declaredInManagedType = ModelSchemaUtils.isMethodDeclaredInManagedType(declaringMethods);
        this.declaredAsAbstract = Modifier.isAbstract(this.mostSpecificDeclaration.getModifiers());
        this.annotations = this.collectAnnotations(declaringMethods);
    }

    private Map<Class<? extends Annotation>, Annotation> collectAnnotations(Iterable<Method> methods) {
        LinkedHashMap annotations = Maps.newLinkedHashMap();
        for (Method method : methods) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (annotations.containsKey(annotation.annotationType())) continue;
                annotations.put(annotation.annotationType(), annotation);
            }
        }
        return Collections.unmodifiableMap(annotations);
    }

    public Collection<Method> getDeclaringMethods() {
        return this.declaringMethods;
    }

    public Method getMostSpecificDeclaration() {
        return this.mostSpecificDeclaration;
    }

    public String getMostSpecificSignature() {
        return this.mostSpecificSignature;
    }

    public boolean isDeclaredInManagedType() {
        return this.declaredInManagedType;
    }

    public boolean isDeclaredAsAbstract() {
        return this.declaredAsAbstract;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)Cast.uncheckedCast((Object)this.annotations.get(annotationType)));
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    public List<Method> getGetters() {
        List<Object> getters;
        if (this.mostSpecificDeclaration.getReturnType() == Boolean.TYPE) {
            getters = Lists.newArrayList();
            for (Method getter : this.declaringMethods) {
                if (Proxy.isProxyClass(getter.getDeclaringClass())) continue;
                getters.add(getter);
            }
        } else {
            getters = Collections.singletonList(this.mostSpecificDeclaration);
        }
        return getters;
    }
}

