/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ScalarCollectionStrategy
implements ModelSchemaExtractionStrategy {
    public static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(List.class), ModelType.of(Set.class));

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        ModelType<?> firstVariableType;
        ModelType<T> type = extractionContext.getType();
        Class<T> rawClass = type.getRawClass();
        ModelType<T> rawCollectionType = ModelType.of(rawClass);
        List<ModelType<?>> typeVariables = type.getTypeVariables();
        if (TYPES.contains(rawCollectionType) && typeVariables.size() > 0 && ScalarTypes.isScalarType(firstVariableType = typeVariables.get(0))) {
            extractionContext.found(this.createSchema(extractionContext, type, firstVariableType));
        }
    }

    private <T, E> ScalarCollectionSchema<T, E> createSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<T> type, ModelType<E> elementType) {
        final ScalarCollectionSchema<T, E> schema = new ScalarCollectionSchema<T, E>(type, elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

