/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelReferenceNode
extends ModelNodeInternal {
    private ModelNodeInternal target;
    private final MutableModelNode parent;

    public ModelReferenceNode(ModelRegistration registration, MutableModelNode parent) {
        super(registration);
        this.parent = parent;
    }

    @Override
    public void setTarget(ModelNode target) {
        if (!this.isMutable()) {
            throw new IllegalStateException(String.format("Cannot set target for model element '%s' as this element is not mutable.", this.getPath()));
        }
        this.target = (ModelNodeInternal)target;
    }

    public ModelNodeInternal getTarget() {
        return this.target;
    }

    @Override
    public boolean canBeViewedAs(ModelType<?> type) {
        return this.target != null && this.target.canBeViewedAs(type);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> implicitDependencies) {
        if (this.target == null) {
            return InstanceModelView.of(this.getPath(), type, null);
        }
        return new ModelViewWrapper<T>(this.getPath(), this.target.asMutable(type, ruleDescriptor, implicitDependencies));
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, @Nullable ModelRuleDescriptor ruleDescriptor) {
        if (this.target == null) {
            return InstanceModelView.of(this.getPath(), type, null);
        }
        return new ModelViewWrapper<T>(this.getPath(), this.target.asImmutable(type, ruleDescriptor));
    }

    @Override
    public ModelPromise getPromise() {
        return this.target == null ? super.getPromise() : this.target.getPromise();
    }

    @Override
    public ModelAdapter getAdapter() {
        return this.target == null ? super.getAdapter() : this.target.getAdapter();
    }

    @Override
    public void addLink(ModelRegistration registration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addReference(ModelRegistration registration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLink(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToSelf(ModelActionRole type, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToAllLinks(ModelActionRole type, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToAllLinksTransitive(ModelActionRole type, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToLink(ModelActionRole type, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToLink(String name, Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToLinks(ModelType<?> type, Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToAllLinksTransitive(ModelType<?> type, Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToSelf(Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLinkCount(ModelType<?> type) {
        return this.target == null ? 0 : this.target.getLinkCount(type);
    }

    @Override
    public Set<String> getLinkNames(ModelType<?> type) {
        return this.target == null ? Collections.emptySet() : this.target.getLinkNames(type);
    }

    @Override
    @Nullable
    public ModelNodeInternal getLink(String name) {
        return this.target == null ? null : this.target.getLink(name);
    }

    @Override
    public Iterable<? extends ModelNodeInternal> getLinks() {
        return this.target == null ? Collections.emptyList() : this.target.getLinks();
    }

    @Override
    public Iterable<? extends MutableModelNode> getLinks(ModelType<?> type) {
        return this.target == null ? Collections.emptyList() : this.target.getLinks(type);
    }

    @Override
    public int getLinkCount() {
        return this.target == null ? 0 : this.target.getLinkCount();
    }

    @Override
    public boolean hasLink(String name, ModelType<?> type) {
        return this.target != null && this.target.hasLink(name, type);
    }

    @Override
    public boolean hasLink(String name) {
        return this.target != null && this.target.hasLink(name);
    }

    @Override
    public <T> T getPrivateData(ModelType<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setPrivateData(Class<? super T> type, T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setPrivateData(ModelType<? super T> type, T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPrivateData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getPrivateData(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void resetPrivateData() {
    }

    @Override
    public void ensureUsable() {
        if (this.target != null) {
            this.target.ensureUsable();
        }
    }

    @Override
    public void ensureAtLeast(ModelNode.State state) {
        if (this.target != null) {
            this.target.ensureAtLeast(state);
        }
    }

    @Override
    public MutableModelNode getParent() {
        return this.parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelViewWrapper<T>
    implements ModelView<T> {
        private final ModelView<? extends T> view;
        private final ModelPath path;

        public ModelViewWrapper(ModelPath path, ModelView<? extends T> view) {
            this.path = path;
            this.view = view;
        }

        @Override
        public ModelPath getPath() {
            return this.path;
        }

        @Override
        public ModelType<T> getType() {
            return (ModelType)Cast.uncheckedCast(this.view.getType());
        }

        @Override
        public T getInstance() {
            return this.view.getInstance();
        }

        @Override
        public void close() {
            this.view.close();
        }
    }
}

