/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.resolve;

import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.platform.base.DependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentSourceSetResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier libraryBinaryIdentifier;
    private final LanguageSourceSet sourceSet;
    private final ResolutionStrategyInternal resolutionStrategy = new DefaultResolutionStrategy();
    private final VariantsMetaData variants;
    private final Iterable<DependencySpec> dependencies;

    public DependentSourceSetResolveContext(LibraryBinaryIdentifier libraryBinaryIdentifier, LanguageSourceSet sourceSet, VariantsMetaData variants, Iterable<DependencySpec> dependencies) {
        this.libraryBinaryIdentifier = libraryBinaryIdentifier;
        this.sourceSet = sourceSet;
        this.variants = variants;
        this.dependencies = dependencies;
    }

    public String getName() {
        return "API";
    }

    public String getDisplayName() {
        return this.sourceSet.getDisplayName();
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public ComponentResolveMetaData toRootComponentMetaData() {
        return DefaultLibraryLocalComponentMetaData.newDefaultLibraryLocalComponentMetadata(this.libraryBinaryIdentifier, this.sourceSet.getBuildDependencies(), this.dependencies, this.libraryBinaryIdentifier.getProjectPath());
    }
}

