/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.basic;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.basic.ObjectSocketWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server<P extends Protocol, O extends ServerObserver> {
    private final Logger logger = Logging.getLogger(Server.class);
    private ServerSocket serverSocket;
    private boolean isServerRunning;
    private boolean hasRequestedShutdown;
    private ObjectSocketWrapper clientSocket;
    protected P protocol;
    private Thread communicationThread;
    private int port;
    protected ObserverLord<O> observerLord = new ObserverLord();

    public Server(P protocol) {
        this.protocol = protocol;
        protocol.initialize((Server)this);
    }

    public int getPort() {
        return this.port;
    }

    public boolean start() {
        this.port = this.connect();
        if (this.port == -1) {
            return false;
        }
        this.communicationThread = new Thread(new Runnable(){

            public void run() {
                Server.this.listenForConnections();
            }
        });
        this.communicationThread.start();
        this.communicationsStarted();
        return true;
    }

    protected void communicationsStarted() {
    }

    private int connect() {
        try {
            this.serverSocket = new ServerSocket(0);
            return this.serverSocket.getLocalPort();
        }
        catch (IOException e) {
            this.logger.error("Could not listen on port: " + this.port, (Throwable)e);
            return -1;
        }
    }

    private void listenForConnections() {
        int consecutiveFailures = 0;
        while (!this.hasRequestedShutdown) {
            Socket socket = null;
            try {
                this.serverSocket.setSoTimeout(2000);
                socket = this.serverSocket.accept();
                this.clientSocket = new ObjectSocketWrapper(socket);
                this.protocol.connectionAccepted();
                consecutiveFailures = 0;
                this.serverSocket.setSoTimeout(0);
                this.processCommunications();
                this.clientSocket.close();
            }
            catch (IOException e) {
                if (++consecutiveFailures >= 20) {
                    this.requestShutdown();
                }
                if (consecutiveFailures <= 8) continue;
                this.logger.error("Accept failed (" + consecutiveFailures + ").");
            }
            catch (Throwable t) {
                this.logger.error("Listening for connections", t);
                this.requestShutdown();
            }
        }
        this.isServerRunning = false;
        this.stop();
        this.notifyServerExited();
    }

    private void processCommunications() {
        boolean hasClientStopped = false;
        int failureCount = 0;
        while (!hasClientStopped && this.protocol.continueConnection() && !this.hasRequestedShutdown) {
            Object object = this.clientSocket.readObject();
            if (object == null) {
                if (this.hasRequestedShutdown) continue;
                this.protocol.readFailureOccurred();
                if (++failureCount != 3) continue;
                hasClientStopped = true;
                this.protocol.clientCommunicationStopped();
                continue;
            }
            failureCount = 0;
            if (object instanceof String) {
                this.protocol.messageReceived(new MessageObject("?", object.toString(), null));
                continue;
            }
            if (!(object instanceof MessageObject)) continue;
            this.protocol.messageReceived((MessageObject)object);
        }
    }

    public void requestShutdown() {
        this.hasRequestedShutdown = true;
    }

    public boolean isServerRunning() {
        return this.isServerRunning;
    }

    public void sendMessage(String messageType, String message) {
        this.clientSocket.sendObject(new MessageObject(messageType, message, null));
    }

    public void sendMessage(String messageType, String message, Serializable data) {
        this.clientSocket.sendObject(new MessageObject(messageType, message, data));
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.logger.error("Closing socket", (Throwable)e);
        }
    }

    private void notifyServerExited() {
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<O>(){

            @Override
            public void notify(ServerObserver observer) {
                observer.serverExited();
            }
        });
    }

    public void addServerObserver(O observer, boolean inEventQueue) {
        this.observerLord.addObserver(observer, inEventQueue);
    }

    public void removeServerObserver(O observer) {
        this.observerLord.removeObserver(observer);
    }

    public static interface ServerObserver {
        public void serverExited();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Protocol<S extends Server> {
        public void initialize(S var1);

        public void connectionAccepted();

        public boolean continueConnection();

        public void messageReceived(MessageObject var1);

        public void clientCommunicationStopped();

        public void readFailureOccurred();
    }
}

