/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.CompositeNotationParser;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.internal.typeconversion.ValueAwareNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionNotationParserFactory {
    public ValueAwareNotationParser<Object> toComposite(Class<?> targetType) throws OptionValidationException {
        assert (targetType != null) : "resultingType cannot be null";
        ArrayList parsers = new ArrayList();
        if (targetType == Void.TYPE) {
            parsers.add(new UnsupportedNotationParser());
        }
        if (targetType.isAssignableFrom(String.class)) {
            parsers.add(new NoDescriptionValuesJustReturningParser());
        }
        if (targetType.isEnum()) {
            parsers.add(new EnumFromCharSequenceNotationParser<Enum>(targetType.asSubclass(Enum.class)));
        }
        if (parsers.isEmpty()) {
            throw new OptionValidationException(String.format("Don't know how to convert strings to type '%s'.", targetType.getName()));
        }
        return new ValueAwareCompositeNotationParser(parsers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueAwareCompositeNotationParser<T>
    extends CompositeNotationParser<CharSequence, T>
    implements ValueAwareNotationParser<T> {
        private final Collection<ValueAwareNotationParser<? extends T>> delegates;

        public ValueAwareCompositeNotationParser(Collection<ValueAwareNotationParser<? extends T>> delegates) {
            super(delegates);
            this.delegates = delegates;
        }

        @Override
        public void describeValues(Collection<String> collector) {
            for (ValueAwareNotationParser<T> delegate : this.delegates) {
                delegate.describeValues(collector);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoDescriptionValuesJustReturningParser
    implements ValueAwareNotationParser<String> {
        private NoDescriptionValuesJustReturningParser() {
        }

        @Override
        public String parseNotation(CharSequence notation) {
            return notation.toString();
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of String or CharSequence.");
        }

        @Override
        public void describeValues(Collection<String> collector) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnsupportedNotationParser
    implements ValueAwareNotationParser<Object> {
        private UnsupportedNotationParser() {
        }

        @Override
        public Object parseNotation(CharSequence notation) throws UnsupportedNotationException, TypeConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
        }

        @Override
        public void describeValues(Collection<String> collector) {
        }
    }
}

