/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolver {
    public boolean tryFindUnqualifiedTaskCheaply(String name, ProjectInternal project) {
        for (Project project1 : project.getAllprojects()) {
            if (!project1.getTasks().getNames().contains(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TaskSelectionResult selectWithName(final String taskName, final ProjectInternal project, boolean includeSubProjects) {
        if (includeSubProjects) {
            LinkedHashSet tasks = Sets.newLinkedHashSet();
            new MultiProjectTaskSelectionResult(taskName, project).collectTasks(tasks);
            if (!tasks.isEmpty()) {
                return new FixedTaskSelectionResult(tasks);
            }
        } else if (TaskNameResolver.hasTask(taskName, project)) {
            return new TaskSelectionResult(){

                @Override
                public void collectTasks(Collection<? super Task> tasks) {
                    tasks.add(TaskNameResolver.getExistingTask(project, taskName));
                }
            };
        }
        return null;
    }

    public Map<String, TaskSelectionResult> selectAll(ProjectInternal project, boolean includeSubProjects) {
        LinkedHashMap selected = Maps.newLinkedHashMap();
        if (includeSubProjects) {
            LinkedHashSet taskNames = Sets.newLinkedHashSet();
            this.collectTaskNames(project, taskNames);
            for (String taskName : taskNames) {
                selected.put(taskName, new MultiProjectTaskSelectionResult(taskName, project));
            }
        } else {
            for (String taskName : TaskNameResolver.getTaskNames(project)) {
                selected.put(taskName, new SingleProjectTaskSelectionResult(taskName, project.getTasks()));
            }
        }
        return selected;
    }

    private static ModelNode selfClose(ModelRegistry modelRegistry, ModelPath modelPath) {
        return modelRegistry.atStateOrLater(modelPath, ModelNode.State.SelfClosed);
    }

    private static ModelNode selfClosedTasksNode(ProjectInternal project) {
        ModelNode modelNode;
        ModelRegistry modelRegistry = project.getModelRegistry();
        try {
            project.fireDeferredConfiguration();
            modelNode = TaskNameResolver.selfClose(modelRegistry, TaskContainerInternal.MODEL_PATH);
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project), e);
        }
        return modelNode;
    }

    private static Set<String> getTaskNames(ProjectInternal project) {
        return TaskNameResolver.selfClosedTasksNode(project).getLinkNames(TaskContainerInternal.TASK_MODEL_TYPE);
    }

    private static boolean hasTask(String taskName, ProjectInternal project) {
        return TaskNameResolver.selfClosedTasksNode(project).hasLink(taskName, TaskContainerInternal.TASK_MODEL_TYPE) || project.getTasks().findByName(taskName) != null;
    }

    private static TaskInternal getExistingTask(ProjectInternal project, String taskName) {
        ModelRegistry modelRegistry = project.getModelRegistry();
        ModelPath path = TaskContainerInternal.MODEL_PATH.child(taskName);
        try {
            if (modelRegistry.node(path) == null) {
                return (TaskInternal)project.getTasks().getByName(taskName);
            }
            return (TaskInternal)modelRegistry.realize(path, TaskContainerInternal.TASK_MODEL_TYPE);
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project), e);
        }
    }

    private void collectTaskNames(ProjectInternal project, Set<String> result) {
        result.addAll(TaskNameResolver.getTaskNames(project));
        for (Project subProject : project.getChildProjects().values()) {
            this.collectTaskNames((ProjectInternal)subProject, result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final ProjectInternal project;
        private final String taskName;

        MultiProjectTaskSelectionResult(String taskName, ProjectInternal project) {
            this.project = project;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            this.collect(this.project, tasks);
        }

        private void collect(ProjectInternal project, Collection<? super Task> tasks) {
            if (TaskNameResolver.hasTask(this.taskName, project)) {
                TaskInternal task = TaskNameResolver.getExistingTask(project, this.taskName);
                tasks.add(task);
                if (task.getImpliesSubProjects()) {
                    return;
                }
            }
            for (Project subProject : project.getChildProjects().values()) {
                this.collect((ProjectInternal)subProject, tasks);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final TaskContainer taskContainer;
        private final String taskName;

        SingleProjectTaskSelectionResult(String taskName, TaskContainer tasksContainer) {
            this.taskContainer = tasksContainer;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.add((Task)this.taskContainer.getByName(this.taskName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedTaskSelectionResult
    implements TaskSelectionResult {
        private final Collection<Task> tasks;

        FixedTaskSelectionResult(Collection<Task> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.addAll(this.tasks);
        }
    }
}

