/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.platform.base.internal.toolchain.ArgWriter;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsFileArgsWriter
implements Action<List<String>> {
    private final Transformer<ArgWriter, PrintWriter> argWriterFactory;
    private final File tempDir;

    public OptionsFileArgsWriter(Transformer<ArgWriter, PrintWriter> argWriterFactory, File tempDir) {
        this.argWriterFactory = argWriterFactory;
        this.tempDir = tempDir;
    }

    public void execute(List<String> args) {
        ArrayList originalArgs = Lists.newArrayList(args);
        args.clear();
        args.addAll(this.transformArgs(originalArgs, this.tempDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> transformArgs(List<String> originalArgs, File tempDir) {
        GFileUtils.mkdirs((File)tempDir);
        File optionsFile = new File(tempDir, "options.txt");
        try {
            PrintWriter writer = new PrintWriter(optionsFile);
            try {
                ArgWriter argWriter = (ArgWriter)this.argWriterFactory.transform((Object)writer);
                argWriter.args(originalArgs);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not write compiler options file '%s'.", optionsFile.getAbsolutePath()), (Throwable)e);
        }
        return Arrays.asList(String.format("@%s", optionsFile.getAbsolutePath()));
    }
}

