/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.testkit.jarjar.com.google.common.collect.ImmutableList;
import org.gradle.testkit.jarjar.org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.testkit.jarjar.org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.testkit.jarjar.org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.testkit.jarjar.org.gradle.internal.reflect.JavaMethod;
import org.gradle.testkit.jarjar.org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private static final JavaMethod<ClassLoader, Package[]> GET_PACKAGES_METHOD = JavaReflectionUtil.method(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
    private static final JavaMethod<ClassLoader, Package> GET_PACKAGE_METHOD = JavaReflectionUtil.method(ClassLoader.class, Package.class, "getPackage", new Class[]{String.class});
    private final List<ClassLoader> parents;

    public MultiParentClassLoader(ClassLoader ... parents) {
        this(Arrays.asList(parents));
    }

    public MultiParentClassLoader(Collection<? extends ClassLoader> parents) {
        super(null);
        this.parents = new CopyOnWriteArrayList<ClassLoader>(parents);
    }

    public void addParent(ClassLoader parent) {
        this.parents.add(parent);
    }

    public List<ClassLoader> getParents() {
        return ImmutableList.copyOf(this.parents);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec());
        for (ClassLoader parent : this.parents) {
            visitor.visitParent(parent);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("%s not found.", name));
    }

    @Override
    protected Package getPackage(String name) {
        for (ClassLoader parent : this.parents) {
            Package p = GET_PACKAGE_METHOD.invoke(parent, name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    protected Package[] getPackages() {
        LinkedHashSet<Package> packages = new LinkedHashSet<Package>();
        for (ClassLoader parent : this.parents) {
            Package[] parentPackages = GET_PACKAGES_METHOD.invoke(parent, new Object[0]);
            packages.addAll(Arrays.asList(parentPackages));
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader parent : this.parents) {
            URL resource = parent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader parent : this.parents) {
            Enumeration<URL> parentResources = parent.getResources(name);
            while (parentResources.hasMoreElements()) {
                resources.add(parentResources.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiParentClassLoader)) {
            return false;
        }
        MultiParentClassLoader that = (MultiParentClassLoader)o;
        return this.parents.equals(that.parents);
    }

    public int hashCode() {
        return this.parents.hashCode();
    }

    public static class Spec
    extends ClassLoaderSpec {
        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(Spec.class);
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    }
}

