/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Transformers;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

class RepositoryChainArtifactResolver
implements ArtifactResolver {
    private final Map<String, ModuleComponentRepository> repositories = new LinkedHashMap<String, ModuleComponentRepository>();

    RepositoryChainArtifactResolver() {
    }

    void add(ModuleComponentRepository repository) {
        this.repositories.put(repository.getId(), repository);
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSource());
        ComponentResolveMetaData unpackedComponent = this.unpackSource(component);
        sourceRepository.getLocalAccess().resolveModuleArtifacts(unpackedComponent, artifactType, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveModuleArtifacts(unpackedComponent, artifactType, result);
        }
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage usage, BuildableArtifactSetResolveResult result) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSource());
        ComponentResolveMetaData unpackedComponent = this.unpackSource(component);
        sourceRepository.getLocalAccess().resolveModuleArtifacts(unpackedComponent, usage, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveModuleArtifacts(unpackedComponent, usage, result);
        }
    }

    public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource source, BuildableArtifactResolveResult result) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(source);
        ModuleSource unpackedSource = this.unpackSource(source);
        sourceRepository.getLocalAccess().resolveArtifact(artifact, unpackedSource, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifact(artifact, unpackedSource, result);
        }
    }

    private ModuleComponentRepository findSourceRepository(ModuleSource originalSource) {
        ModuleComponentRepository moduleVersionRepository = this.repositories.get(this.repositorySource(originalSource).getRepositoryId());
        if (moduleVersionRepository == null) {
            throw new IllegalStateException("Attempting to resolve artifacts from invalid repository");
        }
        return moduleVersionRepository;
    }

    private RepositoryChainModuleSource repositorySource(ModuleSource original) {
        return (RepositoryChainModuleSource)Transformers.cast(RepositoryChainModuleSource.class).transform((Object)original);
    }

    private ModuleSource unpackSource(ModuleSource original) {
        return this.repositorySource(original).getDelegate();
    }

    private ComponentResolveMetaData unpackSource(ComponentResolveMetaData component) {
        return component.withSource(this.repositorySource(component.getSource()).getDelegate());
    }
}

