/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.tasks.JavaScriptMinify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayJavaScriptPlugin
extends RuleSource {
    @LanguageType
    void registerJavascript(LanguageTypeBuilder<JavaScriptSourceSet> builder) {
        builder.setLanguageName("javaScript");
        builder.defaultImplementation(DefaultJavaScriptSourceSet.class);
    }

    @Mutate
    void createJavascriptSourceSets(ModelMap<PlayApplicationSpec> components) {
        components.afterEach((Action)new Action<PlayApplicationSpec>(){

            public void execute(PlayApplicationSpec playComponent) {
                playComponent.getSources().create("javaScript", JavaScriptSourceSet.class, (Action)new Action<JavaScriptSourceSet>(){

                    public void execute(JavaScriptSourceSet javaScriptSourceSet) {
                        javaScriptSourceSet.getSource().srcDir((Object)"app/assets");
                        javaScriptSourceSet.getSource().include(new String[]{"**/*.js"});
                    }
                });
            }
        });
    }

    @BinaryTasks
    void createJavaScriptTasks(ModelMap<Task> tasks, PlayApplicationBinarySpecInternal binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
        for (JavaScriptSourceSet javaScriptSourceSet : binary.getInputs().withType(JavaScriptSourceSet.class)) {
            if (!((LanguageSourceSetInternal)javaScriptSourceSet).getMayHaveSources()) continue;
            this.createJavaScriptMinifyTask(tasks, javaScriptSourceSet, binary, buildDir);
        }
        for (JavaScriptSourceSet javaScriptSourceSet : binary.getGeneratedJavaScript().values()) {
            this.createJavaScriptMinifyTask(tasks, javaScriptSourceSet, binary, buildDir);
        }
    }

    private void createJavaScriptMinifyTask(ModelMap<Task> tasks, final JavaScriptSourceSet javaScriptSourceSet, final PlayApplicationBinarySpecInternal binary, @Path(value="buildDir") File buildDir) {
        String minifyTaskName = binary.getTasks().taskName("minify", javaScriptSourceSet.getName());
        final File minifyOutputDirectory = new File(buildDir, String.format("%s/src/%s", binary.getProjectScopedName(), minifyTaskName));
        tasks.create(minifyTaskName, JavaScriptMinify.class, (Action)new Action<JavaScriptMinify>(){

            public void execute(JavaScriptMinify javaScriptMinify) {
                javaScriptMinify.setDescription("Minifies javascript for the " + javaScriptSourceSet.getDisplayName() + ".");
                javaScriptMinify.setSource(javaScriptSourceSet.getSource());
                javaScriptMinify.setDestinationDir(minifyOutputDirectory);
                javaScriptMinify.setPlayPlatform(binary.getTargetPlatform());
                binary.getAssets().builtBy(new Object[]{javaScriptMinify});
                binary.getAssets().addAssetDir(minifyOutputDirectory);
                javaScriptMinify.dependsOn(new Object[]{javaScriptSourceSet.getBuildDependencies()});
            }
        });
    }
}

