/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api;

import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.jvm.tasks.api.internal.ApiClassExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ApiJar
extends DefaultTask {
    private Set<String> exportedPackages;
    private File runtimeClassesDir;
    private File destinationDir;
    private String archiveName;
    private File apiClassesDir;

    @Input
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public void setExportedPackages(Set<String> exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public File getApiClassesDir() {
        return this.apiClassesDir;
    }

    public void setApiClassesDir(File apiClassesDir) {
        this.apiClassesDir = apiClassesDir;
    }

    @InputDirectory
    @SkipWhenEmpty
    public File getRuntimeClassesDir() {
        return this.runtimeClassesDir;
    }

    public void setRuntimeClassesDir(File runtimeClassesDir) {
        this.runtimeClassesDir = runtimeClassesDir;
    }

    @Input
    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    @TaskAction
    public void createApiJar(IncrementalTaskInputs inputs) throws Exception {
        File archivePath = new File(this.destinationDir, this.archiveName);
        if (!inputs.isIncremental()) {
            FileUtils.deleteQuietly((File)archivePath);
            FileUtils.deleteDirectory((File)this.apiClassesDir);
        }
        this.destinationDir.mkdirs();
        this.apiClassesDir.mkdirs();
        final ApiClassExtractor apiClassExtractor = new ApiClassExtractor(this.exportedPackages);
        final AtomicBoolean updated = new AtomicBoolean();
        final HashMap apiClasses = Maps.newHashMap();
        inputs.outOfDate((Action)new ErroringAction<InputFileDetails>(){

            protected void doExecute(InputFileDetails inputFileDetails) throws Exception {
                updated.set(true);
                File originalClassFile = inputFileDetails.getFile();
                if (!apiClassExtractor.shouldExtractApiClassFrom(originalClassFile)) {
                    return;
                }
                final byte[] apiClassBytes = apiClassExtractor.extractApiClassFrom(originalClassFile);
                apiClasses.put(originalClassFile, apiClassBytes);
                File apiClassFile = ApiJar.this.apiClassFileFor(originalClassFile);
                apiClassFile.getParentFile().mkdirs();
                IoActions.withResource((Closeable)new FileOutputStream(apiClassFile), (Action)new ErroringAction<OutputStream>(){

                    protected void doExecute(OutputStream outputStream) throws Exception {
                        outputStream.write(apiClassBytes);
                    }
                });
            }
        });
        inputs.removed((Action)new ErroringAction<InputFileDetails>(){

            protected void doExecute(InputFileDetails removedOriginalClassFile) throws Exception {
                updated.set(true);
                ApiJar.this.deleteApiClassFileFor(removedOriginalClassFile.getFile());
            }
        });
        if (updated.get()) {
            IoActions.withResource((Closeable)new JarOutputStream(new BufferedOutputStream(new FileOutputStream(archivePath), 65536)), (Action)new ErroringAction<JarOutputStream>(){
                private final SortedMap<String, File> sortedFiles = Maps.newTreeMap();

                private void writeEntries(JarOutputStream jos) throws Exception {
                    for (Map.Entry<String, File> entry : this.sortedFiles.entrySet()) {
                        JarEntry je = new JarEntry(entry.getKey());
                        je.setTime(0L);
                        File originalClassFile = entry.getValue();
                        byte[] apiClassBytes = (byte[])apiClasses.get(originalClassFile);
                        if (apiClassBytes == null) {
                            apiClassBytes = FileUtils.readFileToByteArray((File)originalClassFile);
                        }
                        je.setSize(apiClassBytes.length);
                        jos.putNextEntry(je);
                        jos.write(apiClassBytes);
                        jos.closeEntry();
                    }
                }

                private void collectFiles(String relativePath, File f) throws Exception {
                    String path;
                    String string = path = "".equals(relativePath) ? f.getName() : relativePath + "/" + f.getName();
                    if (f.isFile()) {
                        this.sortedFiles.put(path, f);
                    } else if (f.isDirectory()) {
                        for (File file : f.listFiles()) {
                            String root = relativePath == null ? "" : path;
                            this.collectFiles(root, file);
                        }
                    }
                }

                protected void doExecute(JarOutputStream jos) throws Exception {
                    this.writeManifest(jos);
                    this.collectFiles(null, ApiJar.this.apiClassesDir);
                    this.writeEntries(jos);
                    jos.close();
                }

                private void writeManifest(JarOutputStream jos) throws IOException {
                    JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
                    je.setTime(0L);
                    jos.putNextEntry(je);
                    jos.write("Manifest-Version: 1.0\n".getBytes());
                    jos.closeEntry();
                }
            });
        }
    }

    private File apiClassFileFor(File originalClassFile) {
        StringBuilder sb = new StringBuilder(originalClassFile.getName());
        File cur = originalClassFile.getParentFile();
        while (!cur.equals(this.runtimeClassesDir)) {
            sb.insert(0, cur.getName() + File.separator);
            cur = cur.getParentFile();
        }
        return new File(this.apiClassesDir, sb.toString());
    }

    private void deleteApiClassFileFor(File originalClassFile) {
        File apiClassFile = this.apiClassFileFor(originalClassFile);
        if (apiClassFile.exists()) {
            FileUtils.deleteQuietly((File)apiClassFile);
        }
    }
}

