/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.gradle.jvm.tasks.api.internal.ApiMemberSelector;
import org.gradle.jvm.tasks.api.internal.MethodStubbingApiMemberAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Set<String> exportedPackages;
    private final boolean apiIncludesPackagePrivateMembers;

    public ApiClassExtractor(Set<String> exportedPackages) {
        this.exportedPackages = exportedPackages;
        this.apiIncludesPackagePrivateMembers = exportedPackages.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldExtractApiClassFrom(File originalClassFile) throws IOException {
        if (!originalClassFile.getName().endsWith(".class")) {
            return false;
        }
        FileInputStream inputStream = new FileInputStream(originalClassFile);
        try {
            boolean bl = this.shouldExtractApiClassFrom(new ClassReader((InputStream)inputStream));
            return bl;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    boolean shouldExtractApiClassFrom(ClassReader originalClassReader) {
        final AtomicBoolean shouldExtract = new AtomicBoolean();
        originalClassReader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                String originalClassName = ApiClassExtractor.convertAsmInternalNameToClassName(name);
                shouldExtract.set(ApiClassExtractor.this.isApiClassExtractionCandidate(access, originalClassName));
            }
        }, 7);
        return shouldExtract.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] extractApiClassFrom(File originalClassFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(originalClassFile);
        try {
            ClassReader classReader = new ClassReader((InputStream)inputStream);
            byte[] byArray = this.extractApiClassFrom(classReader);
            return byArray;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    byte[] extractApiClassFrom(ClassReader originalClassReader) {
        ClassWriter apiClassWriter = new ClassWriter(1);
        originalClassReader.accept((ClassVisitor)new ApiMemberSelector(new MethodStubbingApiMemberAdapter(apiClassWriter), this.apiIncludesPackagePrivateMembers), 6);
        return apiClassWriter.toByteArray();
    }

    private boolean isApiClassExtractionCandidate(int access, String candidateClassName) {
        if (ApiClassExtractor.isLocalClass(candidateClassName)) {
            return false;
        }
        if (!ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        if (this.exportedPackages.isEmpty()) {
            return true;
        }
        return this.exportedPackages.contains(ApiClassExtractor.packageNameOf(candidateClassName));
    }

    private static String convertAsmInternalNameToClassName(String internalName) {
        return internalName.replace('/', '.');
    }

    private static String packageNameOf(String className) {
        return className.indexOf(46) > 0 ? className.substring(0, className.lastIndexOf(46)) : "";
    }

    private static boolean isLocalClass(String className) {
        return LOCAL_CLASS_PATTERN.matcher(className).matches();
    }
}

