/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.visitors.CodeShrinker;
import jadx.core.utils.InsnList;
import java.util.HashMap;
import java.util.Map;

public class TernaryMod {
    private TernaryMod() {
    }

    static boolean makeTernaryInsn(MethodNode mth, IfRegion ifRegion) {
        if (ifRegion.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        IContainer thenRegion = ifRegion.getThenRegion();
        IContainer elseRegion = ifRegion.getElseRegion();
        if (thenRegion == null || elseRegion == null) {
            return false;
        }
        BlockNode tb = TernaryMod.getTernaryInsnBlock(thenRegion);
        BlockNode eb = TernaryMod.getTernaryInsnBlock(elseRegion);
        if (tb == null || eb == null) {
            return false;
        }
        BlockNode header = ifRegion.getHeader();
        InsnNode t = tb.getInstructions().get(0);
        InsnNode e = eb.getInstructions().get(0);
        if (t.getSourceLine() != e.getSourceLine() && (t.getSourceLine() != 0 && e.getSourceLine() != 0 ? !TernaryMod.checkLineStats(t, e) : TernaryMod.containsTernary(t) || TernaryMod.containsTernary(e))) {
            return false;
        }
        if (t.getResult() != null && e.getResult() != null) {
            RegisterArg resArg;
            PhiInsn phi = t.getResult().getSVar().getUsedInPhi();
            if (phi == null || !t.getResult().equalRegisterAndType(e.getResult())) {
                return false;
            }
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb, t);
            InsnList.remove(eb, e);
            if (phi.getArgsCount() == 2) {
                resArg = phi.getResult();
            } else {
                resArg = t.getResult();
                phi.removeArg(e.getResult());
            }
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), resArg, InsnArg.wrapArg(t), InsnArg.wrapArg(e));
            ternInsn.setSourceLine(t.getSourceLine());
            header.getInstructions().clear();
            header.getInstructions().add(ternInsn);
            CodeShrinker.shrinkMethod(mth);
            return true;
        }
        if (!mth.getReturnType().equals(ArgType.VOID) && t.getType() == InsnType.RETURN && e.getType() == InsnType.RETURN) {
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb, t);
            InsnList.remove(eb, e);
            tb.remove(AFlag.RETURN);
            eb.remove(AFlag.RETURN);
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), null, t.getArg(0), e.getArg(0));
            ternInsn.setSourceLine(t.getSourceLine());
            InsnNode retInsn = new InsnNode(InsnType.RETURN, 1);
            retInsn.addArg(InsnArg.wrapArg(ternInsn));
            header.getInstructions().clear();
            header.getInstructions().add(retInsn);
            header.add(AFlag.RETURN);
            CodeShrinker.shrinkMethod(mth);
            return true;
        }
        return false;
    }

    private static BlockNode getTernaryInsnBlock(IContainer thenRegion) {
        BlockNode block;
        IContainer container;
        Region r;
        if (thenRegion instanceof Region && (r = (Region)thenRegion).getSubBlocks().size() == 1 && (container = r.getSubBlocks().get(0)) instanceof BlockNode && (block = (BlockNode)container).getInstructions().size() == 1) {
            return block;
        }
        return null;
    }

    private static boolean containsTernary(InsnNode insn) {
        if (insn.getType() == InsnType.TERNARY) {
            return true;
        }
        for (int i = 0; i < insn.getArgsCount(); ++i) {
            InsnNode wrapInsn;
            InsnArg arg = insn.getArg(i);
            if (!arg.isInsnWrap() || !TernaryMod.containsTernary(wrapInsn = ((InsnWrapArg)arg).getWrapInsn())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLineStats(InsnNode t, InsnNode e) {
        if (t.getResult() == null || e.getResult() == null) {
            return false;
        }
        PhiInsn tPhi = t.getResult().getSVar().getUsedInPhi();
        PhiInsn ePhi = e.getResult().getSVar().getUsedInPhi();
        if (tPhi == null || ePhi == null || tPhi != ePhi) {
            return false;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(tPhi.getArgsCount());
        for (InsnArg insnArg : tPhi.getArguments()) {
            int sourceLine;
            InsnNode assignInsn;
            if (!insnArg.isRegister() || (assignInsn = ((RegisterArg)insnArg).getAssignInsn()) == null || (sourceLine = assignInsn.getSourceLine()) == 0) continue;
            Integer count = (Integer)map.get(sourceLine);
            if (count != null) {
                map.put(sourceLine, count + 1);
                continue;
            }
            map.put(sourceLine, 1);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() < 2) continue;
            return true;
        }
        return false;
    }
}

