/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.PolyhedronStereoSorter;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesStereo {
    int chiralClass = Integer.MIN_VALUE;
    int chiralOrder = Integer.MIN_VALUE;
    int atomCount;
    private String details;
    private SmilesSearch search;
    private Node[] jmolAtoms;
    private String directives;
    static final int STEREOCHEMISTRY_SQUARE_PLANAR = 8;
    static final int STEREOCHEMISTRY_OCTAHEDRAL = 6;
    static final int STEREOCHEMISTRY_TRIGONAL_BIPYRAMIDAL = 5;
    static final int STEREOCHEMISTRY_TETRAHEDRAL = 4;
    static final int STEREOCHEMISTRY_TRIGONAL_PYRAMIDAL = 3;
    static final int STEREOCHEMISTRY_ALLENE = 2;
    static final int STEREOCHEMISTRY_POLYHEDRAL = 1;
    static final int STEREOCHEMISTRY_DEFAULT = 0;
    private int[][] polyhedralOrders;
    private boolean isNot;
    private PolyhedronStereoSorter sorter;

    private static int getChiralityClass(String string) {
        return ("0;PH;AL;33;TH;TP;OH;77;SP;".indexOf(string) + 1) / 3;
    }

    public static SmilesStereo newStereo(SmilesStereo smilesStereo) throws InvalidSmilesException {
        return smilesStereo == null ? new SmilesStereo(0, 0, 0, null, null) : new SmilesStereo(smilesStereo.chiralClass, smilesStereo.chiralOrder, smilesStereo.atomCount, smilesStereo.details, smilesStereo.directives);
    }

    SmilesStereo(int n, int n2, int n3, String string, String string2) throws InvalidSmilesException {
        this.chiralClass = n;
        this.chiralOrder = n2;
        this.atomCount = n3;
        this.details = string;
        this.directives = string2;
        if (n == 1) {
            this.getPolyhedralOrders();
        }
    }

    private void getPolyhedralOrders() throws InvalidSmilesException {
        this.polyhedralOrders = AU.newInt2((int)this.atomCount);
        int[][] nArray = this.polyhedralOrders;
        if (this.details == null) {
            return;
        }
        int[] nArray2 = new int[this.details.length()];
        int[] nArray3 = new int[1];
        String string = null;
        int n = 0;
        String string2 = this.details + "/";
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        do {
            char c = string2.charAt(n4);
            switch (c) {
                case '!': {
                    this.isNot = true;
                    ++n4;
                    break;
                }
                case '.': 
                case '/': {
                    n = n5;
                    if (n >= this.atomCount) {
                        string = "Too many descriptors";
                        break;
                    }
                    nArray[n5] = new int[n2];
                    int[] nArray4 = nArray[n5];
                    while (--n2 >= 0) {
                        nArray4[n2] = nArray2[n2];
                    }
                    n2 = 0;
                    if (Logger.debugging) {
                        Logger.info((String)PT.toJSON((String)("@PH" + this.atomCount + "[" + n5 + "]"), (Object)nArray4));
                    }
                    n4 = c == '/' ? Integer.MAX_VALUE : ++n4;
                    ++n5;
                    break;
                }
                default: {
                    n4 = SmilesParser.getRingNumber(string2, n4, c, nArray3);
                    int n6 = n2++;
                    int n7 = nArray3[0] - 1;
                    nArray2[n6] = n7;
                    n = n7;
                    if (n == n5) {
                        string = "Atom cannot connect to itself";
                        break;
                    }
                    if (n < 0 || n >= this.atomCount) {
                        string = "Connection number outside of range (1-" + this.atomCount + ")";
                        break;
                    }
                    if (n2 < this.atomCount) break;
                    string = "Too many connections indicated";
                }
            }
            if (string == null) continue;
            string = string + ": " + string2.substring(0, n4) + "<<";
            throw new InvalidSmilesException(string);
        } while (n4 < n3);
    }

    public int getChiralClass() {
        return this.chiralClass;
    }

    public void setChiralClass(int n) {
        this.chiralClass = n;
    }

    public int getChiralOrder() {
        return this.chiralOrder;
    }

    public void setChiralOrder(int n) {
        this.chiralOrder = n;
    }

    public void fixStereo(SmilesAtom smilesAtom) throws InvalidSmilesException {
        int n = Math.max(smilesAtom.missingHydrogenCount, 0) + smilesAtom.getBondCount();
        switch (this.chiralClass) {
            case 0: {
                switch (n) {
                    case 2: {
                        this.chiralClass = 2;
                        break;
                    }
                    case 3: {
                        this.chiralClass = 3;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.chiralClass = n;
                    }
                }
                break;
            }
            case 8: {
                if (n == 4) break;
                smilesAtom.stereo = null;
                break;
            }
            case 1: {
                if (n == 0 || n == this.atomCount) break;
                smilesAtom.stereo = null;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (n == this.chiralClass) break;
                smilesAtom.stereo = null;
            }
        }
        if (smilesAtom.stereo == null) {
            throw new InvalidSmilesException("Incorrect number of bonds for stereochemistry descriptor");
        }
    }

    private boolean setSmilesCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesAtom smilesAtom3, Node[] nodeArray) {
        Node node;
        if (smilesAtom.stereo == null) {
            return false;
        }
        int n = smilesAtom.stereo.chiralClass;
        int n2 = smilesAtom.stereo.chiralOrder;
        node = n == 2 || n == 3 ? (node = this.jmolAtoms[smilesAtom3.getMatchingAtomIndex()]) : null;
        smilesAtom.set(0.0f, 0.0f, 0.0f);
        smilesAtom = (SmilesAtom)this.jmolAtoms[smilesAtom2.getMatchingAtomIndex()];
        smilesAtom.set(0.0f, 0.0f, 0.0f);
        int[] nArray = this.search.getMappedAtoms((Node)smilesAtom, node, nodeArray);
        switch (n) {
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (n2 == 2) {
                    int n3 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n3;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, -1.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, -1.0f);
                nodeArray[nArray[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, -1.0f, 0.0f);
                        nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                int n4 = nArray.length;
                if (n2 == 2) {
                    int n5 = nArray[0];
                    nArray[0] = nArray[n4 - 1];
                    nArray[n4 - 1] = n5;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[n4 - 1]].set(0.0f, 0.0f, -1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, 0.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                if (n4 != 6) break;
                nodeArray[nArray[4]].set(0.0f, -1.0f, 0.0f);
            }
        }
        return true;
    }

    private void getX(SmilesAtom smilesAtom, Node[] nodeArray, int n, boolean bl, boolean bl2) {
        V3 v3;
        boolean bl3;
        Node node = this.getJmolAtom(smilesAtom.getMatchingAtomIndex());
        boolean bl4 = bl3 = smilesAtom.isFirst || n == 3;
        if (bl) {
            int n2;
            if (this.search.isSmarts) {
                v3 = node.getEdges();
                for (n2 = 0; n2 < ((Edge[])v3).length; ++n2) {
                    Node node2;
                    if (v3[n2].getCovalentOrder() == 2 || (node2 = this.jmolAtoms[node.getBondedAtomIndex(n2)]) == nodeArray[n - 1]) continue;
                    nodeArray[n] = node2;
                    break;
                }
            }
            if (nodeArray[n] == null) {
                v3 = new V3();
                n2 = 0;
                for (int i = 0; i < 4; ++i) {
                    if (nodeArray[i] == null) continue;
                    ++n2;
                    v3.sub((T3)((P3)nodeArray[i]));
                }
                if (v3.length() == 0.0f) {
                    v3.setT((T3)((P3)nodeArray[4]));
                    bl3 = false;
                } else {
                    v3.scaleAdd2((float)(n2 + 1), (T3)((P3)this.getJmolAtom(smilesAtom.getMatchingAtomIndex())), (T3)v3);
                    bl3 = this.search.isSmilesFind || bl3;
                }
                nodeArray[n] = new SmilesAtom().setIndex(-1);
                ((P3)nodeArray[n]).setT((T3)v3);
            }
        }
        if (nodeArray[n] == null) {
            nodeArray[n] = this.search.getHydrogens(node, null);
            if (bl2) {
                bl3 = true;
            }
        }
        if (nodeArray[n] != null && bl3) {
            v3 = nodeArray[n];
            nodeArray[n] = nodeArray[n - 1];
            nodeArray[n - 1] = v3;
        }
    }

    private Node getJmolAtom(int n) {
        return n < 0 || n >= this.jmolAtoms.length ? null : this.jmolAtoms[n];
    }

    void sortBondsByStereo(Node node, Node node2, T3 t3, Edge[] edgeArray, V3 v3) {
        if (edgeArray.length < 2 || !(node instanceof T3)) {
            return;
        }
        if (node2 == null) {
            node2 = edgeArray[0].getOtherAtomNode(node);
        }
        Object[][] objectArray = new Object[edgeArray.length][0];
        if (this.sorter == null) {
            this.sorter = new PolyhedronStereoSorter();
        }
        v3.sub2((T3)node2, t3);
        this.sorter.setRef(v3);
        int n = edgeArray.length;
        while (--n >= 0) {
            float f;
            Node node3 = edgeArray[n].getOtherAtomNode(node);
            float f2 = node3 == node2 ? 0.0f : (f = this.sorter.isAligned((T3)node3, t3, (T3)node2) ? -999.0f : Measure.computeTorsion((T3)((T3)node), (T3)((T3)node2), (T3)t3, (T3)((T3)node3), (boolean)true));
            if (edgeArray.length > 2) {
                f += 360.0f;
            }
            objectArray[n] = new Object[]{edgeArray[n], Float.valueOf(f), node3};
        }
        Arrays.sort(objectArray, this.sorter);
        if (Logger.debugging) {
            Logger.info((String)Escape.e((Object)objectArray));
        }
        n = edgeArray.length;
        while (--n >= 0) {
            edgeArray[n] = (Edge)objectArray[n][0];
        }
    }

    public boolean checkStereoChemistry(SmilesSearch smilesSearch, VTemp vTemp) {
        this.search = smilesSearch;
        this.jmolAtoms = this.search.jmolAtoms;
        boolean bl = smilesSearch.isSmilesFind;
        boolean bl2 = smilesSearch.invertStereochemistry;
        if (Logger.debugging) {
            Logger.debug((String)"checking sstereochemistry...");
        }
        block9: for (int i = 0; i < smilesSearch.ac; ++i) {
            SmilesAtom smilesAtom = smilesSearch.patternAtoms[i];
            if (smilesAtom.stereo == null) continue;
            boolean bl3 = smilesAtom.not != bl2;
            Node node = null;
            Node node2 = null;
            Node node3 = null;
            Node node4 = null;
            Node node5 = null;
            Node node6 = null;
            SmilesAtom smilesAtom2 = null;
            SmilesAtom smilesAtom3 = null;
            SmilesAtom smilesAtom4 = null;
            Node node7 = smilesAtom.getMatchingAtom();
            if (bl) {
                smilesAtom4 = (SmilesAtom)node7;
            }
            int n = Math.max(smilesAtom.missingHydrogenCount, 0);
            int n2 = smilesAtom.stereo.chiralOrder;
            int n3 = smilesAtom.stereo.chiralClass;
            if (bl && smilesAtom4.getChiralClass() != n3) {
                return false;
            }
            if (Logger.debugging) {
                Logger.debug((String)("...type " + n3 + " for pattern atom " + (Object)((Object)smilesAtom) + " " + node7));
            }
            switch (n3) {
                case 1: {
                    if (smilesAtom.stereo.isNot) {
                        boolean bl4 = bl3 = !bl3;
                    }
                    if (n > 1 || smilesAtom.bondCount == 0 || bl) continue block9;
                    SmilesBond[] smilesBondArray = smilesAtom.bonds;
                    int n4 = -1;
                    if (n == 1) {
                        int n5 = n4 = smilesAtom.isFirst ? 0 : 1;
                        if (smilesAtom.getBondCount() != 3) {
                            return false;
                        }
                        vTemp.vA.set(0.0f, 0.0f, 0.0f);
                        for (int j = 0; j < 3; ++j) {
                            vTemp.vA.add((T3)smilesBondArray[j].getOtherAtom(smilesAtom4).getMatchingAtom());
                        }
                        vTemp.vA.scale(0.3333f);
                        vTemp.vA.sub2((T3)node7, (T3)vTemp.vA);
                        vTemp.vA.add((T3)node7);
                    }
                    int[][] nArray = smilesAtom.stereo.polyhedralOrders;
                    int n6 = nArray.length;
                    while (--n6 >= 0) {
                        int[] nArray2 = nArray[n6];
                        if (nArray2 == null || nArray2.length < 2) continue;
                        int n7 = n6 > n4 ? n6 - n : n6;
                        V3 v3 = n6 == n4 ? vTemp.vA : (T3)smilesBondArray[n7].getOtherAtom(smilesAtom).getMatchingAtom();
                        float f = bl3 ? Float.MAX_VALUE : 0.0f;
                        V3 v32 = null;
                        for (int j = 0; j < nArray2.length; ++j) {
                            V3 v33;
                            n7 = nArray2[j];
                            if (n7 == n4) {
                                v33 = vTemp.vA;
                            } else {
                                if (n7 > n4) {
                                    --n7;
                                }
                                v33 = (T3)smilesBondArray[n7].getOtherAtom(smilesAtom).getMatchingAtom();
                            }
                            if (j == 0) {
                                v32 = v33;
                                continue;
                            }
                            float f2 = Measure.computeTorsion((T3)v33, (T3)v3, (T3)((T3)node7), (T3)v32, (boolean)true);
                            if (Float.isNaN(f2)) {
                                f2 = 180.0f;
                            }
                            if (nArray2.length == 2) {
                                return f2 < 0.0f != bl3;
                            }
                            if (f2 < 0.0f) {
                                f2 += 360.0f;
                            }
                            if (f2 < f != bl3) {
                                return false;
                            }
                            f = f2;
                        }
                    }
                    continue block9;
                }
                case 2: {
                    int n8;
                    int n6 = 1;
                    if (n6 != 0) {
                        smilesAtom2 = smilesAtom.getBond(0).getOtherAtom(smilesAtom);
                        smilesAtom3 = smilesAtom.getBond(1).getOtherAtom(smilesAtom);
                        if (smilesAtom2 == null || smilesAtom3 == null) continue block9;
                        SmilesAtom smilesAtom5 = smilesAtom;
                        SmilesAtom smilesAtom6 = smilesAtom;
                        while (smilesAtom2.getBondCount() == 2 && smilesAtom3.getBondCount() == 2 && smilesAtom2.getValence() == 4 && smilesAtom3.getValence() == 4) {
                            SmilesBond smilesBond = smilesAtom2.getBondNotTo(smilesAtom5, true);
                            smilesAtom5 = smilesAtom2;
                            smilesAtom2 = smilesBond.getOtherAtom(smilesAtom2);
                            smilesBond = smilesAtom3.getBondNotTo(smilesAtom6, true);
                            smilesAtom6 = smilesAtom3;
                            smilesAtom3 = smilesBond.getOtherAtom(smilesAtom3);
                        }
                        smilesAtom = smilesAtom2;
                    }
                    Node[] nodeArray = new Node[6];
                    nodeArray[4] = new SmilesAtom().setIndex(604);
                    int n9 = smilesAtom.getBondCount();
                    for (n8 = 0; n8 < n9; ++n8) {
                        smilesAtom2 = smilesAtom.bonds[n8].getOtherAtom(smilesAtom);
                        if (smilesAtom.bonds[n8].matchingBond.getCovalentOrder() == 2) {
                            if (smilesAtom3 != null) continue;
                            smilesAtom3 = smilesAtom2;
                            continue;
                        }
                        if (nodeArray[0] == null) {
                            nodeArray[0] = smilesAtom2.getMatchingAtom();
                            continue;
                        }
                        nodeArray[1] = smilesAtom2.getMatchingAtom();
                    }
                    if (smilesAtom3 == null || (n9 = smilesAtom3.getBondCount()) < 2 || n9 > 3) continue block9;
                    for (n8 = 0; n8 < n9; ++n8) {
                        smilesAtom2 = smilesAtom3.bonds[n8].getOtherAtom(smilesAtom3);
                        if (smilesAtom3.bonds[n8].matchingBond.getCovalentOrder() == 2) continue;
                        if (nodeArray[2] == null) {
                            nodeArray[2] = smilesAtom2.getMatchingAtom();
                            continue;
                        }
                        nodeArray[3] = smilesAtom2.getMatchingAtom();
                    }
                    if (bl) {
                        if (nodeArray[1] == null) {
                            this.getX(smilesAtom, nodeArray, 1, false, n6 != 0);
                        }
                        if (nodeArray[3] == null) {
                            this.getX(smilesAtom3, nodeArray, 3, false, false);
                        }
                        if (!this.setSmilesCoordinates(smilesAtom4, smilesAtom, smilesAtom3, nodeArray)) {
                            return false;
                        }
                    }
                    if (nodeArray[1] == null) {
                        this.getX(smilesAtom, nodeArray, 1, true, false);
                    }
                    if (nodeArray[3] == null) {
                        this.getX(smilesAtom3, nodeArray, 3, true, false);
                    }
                    if (SmilesStereo.checkStereochemistryAll(smilesAtom.not != bl2, node7, n3, n2, nodeArray[0], nodeArray[1], nodeArray[2], nodeArray[3], null, null, vTemp)) continue block9;
                    return false;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    node = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(0));
                    switch (n) {
                        case 0: {
                            node2 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(1));
                            break;
                        }
                        case 1: {
                            node2 = smilesSearch.getHydrogens(smilesAtom.getMatchingAtom(), null);
                            if (!smilesAtom.isFirst) break;
                            Node node8 = node2;
                            node2 = node;
                            node = node8;
                            break;
                        }
                        default: {
                            continue block9;
                        }
                    }
                    node3 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(2 - n));
                    node4 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(3 - n));
                    node5 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(4 - n));
                    node6 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(5 - n));
                    if (bl && !this.setSmilesCoordinates(smilesAtom4, smilesAtom, smilesAtom3, new Node[]{node, node2, node3, node4, node5, node6})) {
                        return false;
                    }
                    if (SmilesStereo.checkStereochemistryAll(bl3, node7, n3, n2, node, node2, node3, node4, node5, node6, vTemp)) continue block9;
                    return false;
                }
            }
        }
        return true;
    }

    static String getStereoFlag(Node node, Node[] nodeArray, int n, VTemp vTemp) {
        Node node2 = nodeArray[0];
        Node node3 = nodeArray[1];
        Node node4 = nodeArray[2];
        Node node5 = nodeArray[3];
        Node node6 = nodeArray[4];
        Node node7 = nodeArray[5];
        int n2 = 4;
        switch (n) {
            default: {
                return SmilesStereo.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (node4 == null || node5 == null) {
            return "";
        }
        float f = SmilesAromatic.getNormalThroughPoints(node2, node3, node4, vTemp.vTemp, vTemp.vA, vTemp.vB);
        if (Math.abs(SmilesStereo.distanceToPlane(vTemp.vTemp, f, (P3)node5)) < 0.2f) {
            n2 = 8;
            if (SmilesStereo.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP1";
            }
            if (SmilesStereo.checkStereochemistryAll(false, node, n2, 2, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP2";
            }
            if (SmilesStereo.checkStereochemistryAll(false, node, n2, 3, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP3";
            }
        } else {
            return SmilesStereo.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp) ? "@" : "@@";
        }
        return "";
    }

    static boolean checkStereochemistryAll(boolean bl, Node node, int n, int n2, Node node2, Node node3, Node node4, Node node5, Node node6, Node node7, VTemp vTemp) {
        switch (n) {
            default: {
                return true;
            }
            case 1: {
                return true;
            }
            case 3: {
                return bl == (SmilesStereo.getHandedness(node3, node4, node, node2, vTemp) != n2);
            }
            case 2: 
            case 4: {
                return bl == (SmilesStereo.getHandedness(node3, node4, node5, node2, vTemp) != n2);
            }
            case 5: {
                return bl == (!SmilesStereo.isDiaxial(node, node, node6, node2, vTemp, -0.95f) || SmilesStereo.getHandedness(node3, node4, node5, node2, vTemp) != n2);
            }
            case 6: {
                if (bl != !SmilesStereo.isDiaxial(node, node, node7, node2, vTemp, -0.95f)) {
                    return false;
                }
                SmilesStereo.getPlaneNormals(node3, node4, node5, node6, vTemp);
                if (bl != (vTemp.vNorm1.dot((T3)vTemp.vNorm2) < 0.0f || vTemp.vNorm2.dot((T3)vTemp.vNorm3) < 0.0f)) {
                    return false;
                }
                vTemp.vNorm2.sub2((T3)((P3)node), (T3)((P3)node2));
                return bl == ((vTemp.vNorm1.dot((T3)vTemp.vNorm2) < 0.0f ? 2 : 1) == n2);
            }
            case 8: 
        }
        SmilesStereo.getPlaneNormals(node2, node3, node4, node5, vTemp);
        return vTemp.vNorm1.dot((T3)vTemp.vNorm2) < 0.0f ? bl == (n2 != 3) : (vTemp.vNorm2.dot((T3)vTemp.vNorm3) < 0.0f ? bl == (n2 != 2) : bl == (n2 != 1));
    }

    static boolean isDiaxial(Node node, Node node2, Node node3, Node node4, VTemp vTemp, float f) {
        vTemp.vA.sub2((T3)((P3)node), (T3)((P3)node3));
        vTemp.vB.sub2((T3)((P3)node2), (T3)((P3)node4));
        vTemp.vA.normalize();
        vTemp.vB.normalize();
        return vTemp.vA.dot((T3)vTemp.vB) < f;
    }

    private static int getHandedness(Node node, Node node2, Node node3, Node node4, VTemp vTemp) {
        float f = SmilesAromatic.getNormalThroughPoints(node, node2, node3, vTemp.vTemp, vTemp.vA, vTemp.vB);
        return SmilesStereo.distanceToPlane(vTemp.vTemp, f, (P3)node4) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(Node node, Node node2, Node node3, Node node4, VTemp vTemp) {
        SmilesAromatic.getNormalThroughPoints(node, node2, node3, vTemp.vNorm1, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(node2, node3, node4, vTemp.vNorm2, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(node3, node4, node, vTemp.vNorm3, vTemp.vTemp1, vTemp.vTemp2);
    }

    static float distanceToPlane(V3 v3, float f, P3 p3) {
        return v3 == null ? Float.NaN : (v3.x * p3.x + v3.y * p3.y + v3.z * p3.z + f) / (float)Math.sqrt(v3.x * v3.x + v3.y * v3.y + v3.z * v3.z);
    }

    static int checkChirality(String string, int n, SmilesAtom smilesAtom) throws InvalidSmilesException {
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        int n4 = string.length();
        String string2 = null;
        String string3 = null;
        int n5 = 0;
        n2 = 0;
        n3 = 1;
        boolean bl = false;
        if (++n < n4) {
            char c = string.charAt(n);
            switch (c) {
                case '@': {
                    n3 = 2;
                    ++n;
                    break;
                }
                case 'H': {
                    break;
                }
                case 'P': {
                    bl = true;
                }
                case 'A': 
                case 'O': 
                case 'S': 
                case 'T': {
                    n2 = n + 1 < n4 ? SmilesStereo.getChiralityClass(string.substring(n, n + 2)) : -1;
                    n += 2;
                    break;
                }
                default: {
                    n3 = PT.isDigit((char)c) ? 1 : -1;
                }
            }
            if (n3 == 1 || bl) {
                int n6;
                for (n6 = n; n6 < n4 && PT.isDigit((char)string.charAt(n6)); ++n6) {
                }
                if (n6 > n) {
                    try {
                        int n7 = Integer.parseInt(string.substring(n, n6));
                        if (bl) {
                            n5 = n7;
                            if (n6 < n4 && string.charAt(n6) == '(') {
                                string2 = SmilesParser.getSubPattern(string, n6, '(');
                                n6 += string2.length() + 2;
                            }
                            if (n6 < n4 && string.charAt(n6) == '/') {
                                string3 = SmilesParser.getSubPattern(string, n6, '/');
                                n6 += string3.length() + 2;
                            }
                        } else {
                            n3 = n7;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = -1;
                    }
                    n = n6;
                }
            }
            if (n3 < 1 || n2 < 0) {
                throw new InvalidSmilesException("Invalid stereochemistry descriptor");
            }
        }
        smilesAtom.stereo = new SmilesStereo(n2, n3, n5, string2, string3);
        if (SmilesParser.getChar(string, n) == '?') {
            Logger.info((String)"Ignoring '?' in stereochemistry");
            ++n;
        }
        return n;
    }
}

