/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.api.MinimizerInterface;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.MinimizationThread;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.minimize.forcefield.ForceFieldUFF;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public class Minimizer
implements MinimizerInterface {
    public Viewer vwr;
    public Atom[] atoms;
    public Bond[] bonds;
    public int rawBondCount;
    public MinAtom[] minAtoms;
    public MinBond[] minBonds;
    public MinAngle[] minAngles;
    public MinTorsion[] minTorsions;
    public MinPosition[] minPositions;
    public BS bsMinFixed;
    private int ac;
    private int bondCount;
    private int[] atomMap;
    public double[] partialCharges;
    private int steps = 50;
    private double crit = 0.001;
    public String units = "kJ/mol";
    private ForceField pFF;
    private String ff = "UFF";
    private BS bsTaint;
    private BS bsSelected;
    public BS bsAtoms;
    private BS bsFixedDefault;
    private BS bsFixed;
    public Lst<Object[]> constraints;
    private boolean isSilent;
    private Map<String, Object[]> constraintMap;
    private int elemnoMax;
    private boolean minimizationOn;
    private MinimizationThread minimizationThread;
    double[][] coordSaved;

    @Override
    public MinimizerInterface setProperty(String string, Object object) {
        switch ("ff        cancel    clear     constraintfixed     stop      vwr    ".indexOf(string)) {
            case 0: {
                if (this.ff.equals(object)) break;
                this.setProperty("clear", null);
                this.ff = (String)object;
                break;
            }
            case 10: {
                this.stopMinimization(false);
                break;
            }
            case 20: {
                if (this.minAtoms == null) break;
                this.stopMinimization(false);
                this.clear();
                break;
            }
            case 30: {
                this.addConstraint((Object[])object);
                break;
            }
            case 40: {
                this.bsFixedDefault = (BS)object;
                break;
            }
            case 50: {
                this.stopMinimization(true);
                break;
            }
            case 60: {
                this.vwr = (Viewer)object;
            }
        }
        return this;
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string.equals("log")) {
            return this.pFF == null ? "" : this.pFF.getLogData();
        }
        return null;
    }

    private void addConstraint(Object[] objectArray) {
        String string;
        Object[] objectArray2;
        if (objectArray == null) {
            return;
        }
        int[] nArray = (int[])objectArray[0];
        int n = nArray[0];
        if (n == 0) {
            this.constraints = null;
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Lst();
            this.constraintMap = new Hashtable<String, Object[]>();
        }
        if (nArray[1] > nArray[n]) {
            AU.swapInt(nArray, 1, n);
            if (n == 4) {
                AU.swapInt(nArray, 2, 3);
            }
        }
        if ((objectArray2 = this.constraintMap.get(string = Escape.eAI(nArray))) != null) {
            objectArray2[2] = objectArray[2];
            return;
        }
        this.constraintMap.put(string, objectArray);
        this.constraints.addLast(objectArray);
    }

    private void clear() {
        this.setMinimizationOn(false);
        this.ac = 0;
        this.bondCount = 0;
        this.atoms = null;
        this.bonds = null;
        this.rawBondCount = 0;
        this.minAtoms = null;
        this.minBonds = null;
        this.minAngles = null;
        this.minTorsions = null;
        this.partialCharges = null;
        this.coordSaved = null;
        this.atomMap = null;
        this.bsTaint = null;
        this.bsAtoms = null;
        this.bsFixed = null;
        this.bsFixedDefault = null;
        this.bsMinFixed = null;
        this.bsSelected = null;
        this.constraints = null;
        this.constraintMap = null;
        this.pFF = null;
    }

    @Override
    public boolean minimize(int n, double d, BS bS, BS bS2, boolean bl, boolean bl2, String string) throws JmolAsyncException {
        Object object;
        this.isSilent = bl2 || this.vwr.getBooleanProperty("minimizationSilent");
        this.setEnergyUnits();
        if (n == Integer.MAX_VALUE && (object = this.vwr.getP("minimizationSteps")) != null && object instanceof Integer) {
            n = (Integer)object;
        }
        this.steps = n;
        if (!bl && this.bsFixedDefault != null) {
            bS2.and(this.bsFixedDefault);
        }
        if (d <= 0.0 && (object = this.vwr.getP("minimizationCriterion")) != null && object instanceof Float) {
            d = ((Float)object).floatValue();
        }
        this.crit = Math.max(d, 1.0E-4);
        if (this.minimizationOn) {
            return false;
        }
        ForceField forceField = this.pFF;
        this.getForceField(string);
        if (this.pFF == null) {
            Logger.error(GT.o(GT._("Could not get class for force field {0}"), string));
            return false;
        }
        Logger.info("minimize: initializing " + this.pFF.name + " (steps = " + n + " criterion = " + d + ") ...");
        if (bS.nextSetBit(0) < 0) {
            Logger.error(GT._("No atoms selected -- nothing to do!"));
            return false;
        }
        this.atoms = this.vwr.ms.at;
        this.bsAtoms = BSUtil.copy(bS);
        int n2 = this.bsAtoms.nextSetBit(0);
        while (n2 >= 0) {
            if (this.atoms[n2].getElementNumber() == 0) {
                this.bsAtoms.clear(n2);
            }
            n2 = this.bsAtoms.nextSetBit(n2 + 1);
        }
        if (bS2 != null) {
            this.bsAtoms.or(bS2);
        }
        this.ac = this.bsAtoms.cardinality();
        n2 = BSUtil.areEqual(bS, this.bsSelected) ? 1 : 0;
        this.bsSelected = bS;
        if (forceField != null && this.pFF != forceField) {
            n2 = 0;
        }
        if (n2 == 0) {
            this.pFF.clear();
        }
        if (!(n2 != 0 && BSUtil.areEqual(bS2, this.bsFixed) || this.setupMinimization())) {
            this.clear();
            return false;
        }
        if (n > 0) {
            this.bsTaint = BSUtil.copy(this.bsAtoms);
            BSUtil.andNot(this.bsTaint, bS2);
            this.vwr.ms.setTaintedAtoms(this.bsTaint, (byte)2);
        }
        if (bS2 != null) {
            this.bsFixed = bS2;
        }
        this.setAtomPositions();
        if (this.constraints != null) {
            int n3 = this.constraints.size();
            block1: while (--n3 >= 0) {
                Object[] objectArray = (Object[])this.constraints.get(n3);
                int[] nArray = (int[])objectArray[0];
                int[] nArray2 = (int[])objectArray[1];
                int n4 = nArray[0] = Math.abs(nArray[0]);
                for (int i = 1; i <= n4; ++i) {
                    if (n <= 0 || !this.bsAtoms.get(nArray[i])) {
                        nArray[0] = -n4;
                        continue block1;
                    }
                    nArray2[i - 1] = this.atomMap[nArray[i]];
                }
            }
        }
        this.pFF.setConstraints(this);
        if (n <= 0) {
            this.getEnergyOnly();
        } else if (this.isSilent || !this.vwr.useMinimizationThread()) {
            this.minimizeWithoutThread();
        } else {
            this.setMinimizationOn(true);
        }
        return true;
    }

    private void setEnergyUnits() {
        String string = this.vwr.g.energyUnits;
        this.units = string.equalsIgnoreCase("kcal") ? "kcal" : "kJ";
    }

    private boolean setupMinimization() throws JmolAsyncException {
        this.coordSaved = null;
        this.atomMap = new int[this.atoms.length];
        this.minAtoms = new MinAtom[this.ac];
        this.elemnoMax = 0;
        BS bS = new BS();
        int n = this.bsAtoms.nextSetBit(0);
        int n2 = 0;
        while (n >= 0) {
            Atom atom = this.atoms[n];
            this.atomMap[n] = n2;
            int n3 = this.atoms[n].getElementNumber();
            this.elemnoMax = Math.max(this.elemnoMax, n3);
            bS.set(n3);
            this.minAtoms[n2] = new MinAtom(n2, atom, new double[]{atom.x, atom.y, atom.z}, this.ac);
            this.minAtoms[n2].sType = atom.getAtomName();
            n = this.bsAtoms.nextSetBit(n + 1);
            ++n2;
        }
        Logger.info(GT.i(GT._("{0} atoms will be minimized."), this.ac));
        Logger.info("minimize: getting bonds...");
        this.bonds = this.vwr.ms.bo;
        this.rawBondCount = this.vwr.ms.bondCount;
        this.getBonds();
        Logger.info("minimize: getting angles...");
        this.getAngles();
        Logger.info("minimize: getting torsions...");
        this.getTorsions();
        return this.setModel(bS);
    }

    private boolean setModel(BS bS) throws JmolAsyncException {
        if (!this.pFF.setModel(bS, this.elemnoMax)) {
            Logger.error(GT.o(GT._("could not setup force field {0}"), this.ff));
            if (this.ff.equals("MMFF")) {
                this.getForceField("UFF");
                return this.setModel(bS);
            }
            return false;
        }
        return true;
    }

    private void setAtomPositions() {
        int n;
        for (n = 0; n < this.ac; ++n) {
            this.minAtoms[n].set();
        }
        this.bsMinFixed = null;
        if (this.bsFixed != null) {
            this.bsMinFixed = new BS();
            n = this.bsAtoms.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (this.bsFixed.get(n)) {
                    this.bsMinFixed.set(n2);
                }
                n = this.bsAtoms.nextSetBit(n + 1);
                ++n2;
            }
        }
    }

    private void getBonds() {
        int n;
        Object object;
        int n2;
        Lst<MinBond> lst = new Lst<MinBond>();
        this.bondCount = 0;
        block5: for (n2 = 0; n2 < this.rawBondCount; ++n2) {
            int n3;
            object = this.bonds[n2];
            int n4 = ((Bond)object).atom1.i;
            if (!this.bsAtoms.get(n4) || !this.bsAtoms.get(n3 = ((Bond)object).atom2.i)) continue;
            if (n3 < n4) {
                n = n4;
                n4 = n3;
                n3 = n;
            }
            n = ((Bond)object).getCovalentOrder();
            switch (n) {
                case 0: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 515: {
                    n = 5;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            lst.addLast(new MinBond(n2, this.bondCount++, this.atomMap[n4], this.atomMap[n3], n, 0, null));
        }
        this.minBonds = new MinBond[this.bondCount];
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.minBonds[n2] = (MinBond)lst.get(n2);
            object = this.minBonds[n2];
            n = ((MinBond)object).data[0];
            int n5 = ((MinBond)object).data[1];
            this.minAtoms[n].addBond((MinBond)object, n5);
            this.minAtoms[n5].addBond((MinBond)object, n);
        }
        for (n2 = 0; n2 < this.ac; ++n2) {
            this.minAtoms[n2].getBondedAtomIndexes();
        }
    }

    public void getAngles() {
        Lst<MinAngle> lst = new Lst<MinAngle>();
        for (int i = 0; i < this.bondCount; ++i) {
            int n;
            int n2;
            int[] nArray;
            MinBond minBond = this.minBonds[i];
            int n3 = minBond.data[0];
            int n4 = minBond.data[1];
            if (this.minAtoms[n4].nBonds > 1) {
                nArray = this.minAtoms[n4].getBondedAtomIndexes();
                n2 = nArray.length;
                while (--n2 >= 0) {
                    n = nArray[n2];
                    if (n <= n3) continue;
                    lst.addLast(new MinAngle(new int[]{n3, n4, n, i, this.minAtoms[n4].getBondIndex(n2)}));
                    this.minAtoms[n3].bsVdw.clear(n);
                }
            }
            if (this.minAtoms[n3].nBonds <= 1) continue;
            nArray = this.minAtoms[n3].getBondedAtomIndexes();
            n2 = nArray.length;
            while (--n2 >= 0) {
                n = nArray[n2];
                if (n >= n4 || n <= n3) continue;
                lst.addLast(new MinAngle(new int[]{n, n3, n4, this.minAtoms[n3].getBondIndex(n2), i}));
                this.minAtoms[n].bsVdw.clear(n4);
            }
        }
        this.minAngles = lst.toArray(new MinAngle[lst.size()]);
        Logger.info(this.minAngles.length + " angles");
    }

    public void getTorsions() {
        Lst<MinTorsion> lst = new Lst<MinTorsion>();
        int n = this.minAngles.length;
        while (--n >= 0) {
            int n2;
            int n3;
            int[] nArray;
            int[] nArray2 = this.minAngles[n].data;
            int n4 = nArray2[0];
            int n5 = nArray2[2];
            int n6 = nArray2[1];
            if (n5 > n6 && this.minAtoms[n5].nBonds > 1) {
                nArray = this.minAtoms[n5].getBondedAtomIndexes();
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    if (n2 == n4 || n2 == n6) continue;
                    lst.addLast(new MinTorsion(new int[]{n4, n6, n5, n2, nArray2[3], nArray2[4], this.minAtoms[n5].getBondIndex(n3)}));
                    this.minAtoms[Math.min((int)n4, (int)n2)].bs14.set(Math.max(n4, n2));
                }
            }
            if (n4 <= n6 || this.minAtoms[n4].nBonds == 1) continue;
            nArray = this.minAtoms[n4].getBondedAtomIndexes();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (n2 == n5 || n2 == n6) continue;
                lst.addLast(new MinTorsion(new int[]{n5, n6, n4, n2, nArray2[4], nArray2[3], this.minAtoms[n4].getBondIndex(n3)}));
                this.minAtoms[Math.min((int)n5, (int)n2)].bs14.set(Math.max(n5, n2));
            }
        }
        this.minTorsions = lst.toArray(new MinTorsion[lst.size()]);
        Logger.info(this.minTorsions.length + " torsions");
    }

    public ForceField getForceField(String string) throws JmolAsyncException {
        if (string.startsWith("MMFF")) {
            string = "MMFF";
        }
        if (this.pFF == null || !string.equals(this.ff)) {
            if (string.equals("UFF")) {
                this.pFF = new ForceFieldUFF(this);
            } else if (string.equals("MMFF")) {
                this.pFF = new ForceFieldMMFF(this);
            } else {
                this.pFF = new ForceFieldUFF(this);
                string = "UFF";
            }
            this.ff = string;
            this.vwr.setStringProperty("_minimizationForceField", string);
        }
        return this.pFF;
    }

    @Override
    public boolean minimizationOn() {
        return this.minimizationOn;
    }

    @Override
    public JmolThread getThread() {
        return this.minimizationThread;
    }

    private void setMinimizationOn(boolean bl) {
        this.minimizationOn = bl;
        if (!bl) {
            if (this.minimizationThread != null) {
                this.minimizationThread = null;
            }
            return;
        }
        if (this.minimizationThread == null) {
            this.minimizationThread = new MinimizationThread();
            this.minimizationThread.setManager(this, this.vwr, null);
            this.minimizationThread.start();
        }
    }

    private void getEnergyOnly() {
        if (this.pFF == null || this.vwr == null) {
            return;
        }
        this.pFF.steepestDescentInitialize(this.steps, this.crit);
        this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
        this.reportEnergy();
        this.vwr.setStringProperty("_minimizationStatus", "calculate");
        this.vwr.notifyMinimizationStatus();
    }

    private void reportEnergy() {
        this.vwr.setFloatProperty("_minimizationEnergy", this.pFF.toUserUnits(this.pFF.getEnergy()));
    }

    @Override
    public boolean startMinimization() {
        try {
            Logger.info("minimizer: startMinimization");
            this.vwr.setIntProperty("_minimizationStep", 0);
            this.vwr.setStringProperty("_minimizationStatus", "starting");
            this.vwr.setFloatProperty("_minimizationEnergy", 0.0f);
            this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
            this.vwr.notifyMinimizationStatus();
            this.vwr.stm.saveCoordinates("minimize", this.bsTaint);
            this.pFF.steepestDescentInitialize(this.steps, this.crit);
            this.reportEnergy();
            this.saveCoordinates();
        }
        catch (Exception exception) {
            Logger.error("minimization error vwr=" + this.vwr + " pFF = " + this.pFF);
            return false;
        }
        this.minimizationOn = true;
        return true;
    }

    @Override
    public boolean stepMinimization() {
        if (!this.minimizationOn) {
            return false;
        }
        boolean bl = !this.isSilent && this.vwr.getBooleanProperty("minimizationRefresh");
        this.vwr.setStringProperty("_minimizationStatus", "running");
        boolean bl2 = this.pFF.steepestDescentTakeNSteps(1);
        int n = this.pFF.getCurrentStep();
        this.vwr.setIntProperty("_minimizationStep", n);
        this.reportEnergy();
        this.vwr.setFloatProperty("_minimizationEnergyDiff", this.pFF.toUserUnits(this.pFF.getEnergyDiff()));
        this.vwr.notifyMinimizationStatus();
        if (bl) {
            this.updateAtomXYZ();
            this.vwr.refresh(3, "minimization step " + n);
        }
        return bl2;
    }

    @Override
    public void endMinimization() {
        this.updateAtomXYZ();
        this.setMinimizationOn(false);
        boolean bl = this.pFF.detectExplosion();
        if (bl) {
            this.restoreCoordinates();
        }
        this.vwr.setIntProperty("_minimizationStep", this.pFF.getCurrentStep());
        this.reportEnergy();
        this.vwr.setStringProperty("_minimizationStatus", bl ? "failed" : "done");
        this.vwr.notifyMinimizationStatus();
        this.vwr.refresh(3, "Minimizer:done" + (bl ? " EXPLODED" : "OK"));
        Logger.info("minimizer: endMinimization");
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.ac][3];
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        if (this.coordSaved == null) {
            return;
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
        this.updateAtomXYZ();
    }

    public void stopMinimization(boolean bl) {
        if (!this.minimizationOn) {
            return;
        }
        this.setMinimizationOn(false);
        if (bl) {
            this.endMinimization();
        } else {
            this.restoreCoordinates();
        }
    }

    void updateAtomXYZ() {
        if (this.steps <= 0) {
            return;
        }
        for (int i = 0; i < this.ac; ++i) {
            MinAtom minAtom = this.minAtoms[i];
            Atom atom = minAtom.atom;
            atom.x = (float)minAtom.coord[0];
            atom.y = (float)minAtom.coord[1];
            atom.z = (float)minAtom.coord[2];
        }
        this.vwr.refreshMeasures(false);
    }

    private void minimizeWithoutThread() {
        if (!this.startMinimization()) {
            return;
        }
        while (this.stepMinimization()) {
        }
        this.endMinimization();
    }

    public void report(String string, boolean bl) {
        if (this.isSilent) {
            Logger.info(string);
        } else if (bl) {
            this.vwr.showString(string, false);
        } else {
            this.vwr.scriptEcho(string);
        }
    }

    @Override
    public void calculatePartialCharges(Bond[] bondArray, int n, Atom[] atomArray, BS bS) throws JmolAsyncException {
        ForceFieldMMFF forceFieldMMFF = new ForceFieldMMFF(this);
        forceFieldMMFF.setArrays(atomArray, bS, bondArray, n, true, true);
        this.vwr.setAtomProperty(bS, 1086326785, 0, 0.0f, null, null, forceFieldMMFF.getAtomTypeDescriptions());
        this.vwr.setAtomProperty(bS, 1111492619, 0, 0.0f, null, forceFieldMMFF.getPartialCharges(), null);
    }
}

