/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.AU;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Logger;

class VolumeDataReader
extends SurfaceReader {
    protected int dataType;
    protected boolean precalculateVoxelData;
    protected boolean allowMapData;
    protected P3 point;
    protected float ptsPerAngstrom;
    protected int maxGrid;
    protected boolean useOriginStepsPoints;

    VolumeDataReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initVDR(surfaceGenerator);
    }

    protected void initVDR(SurfaceGenerator surfaceGenerator) {
        this.initSR(surfaceGenerator);
        this.useOriginStepsPoints = this.params.origin != null && this.params.points != null && this.params.steps != null;
        this.dataType = this.params.dataType;
        this.precalculateVoxelData = true;
        this.allowMapData = true;
    }

    void setup(boolean bl) {
        this.jvxlFileHeaderBuffer = new SB().append("volume data read from file\n\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        this.initializeVolumetricData();
        return true;
    }

    @Override
    protected boolean readVolumeData(boolean bl) {
        try {
            this.readSurfaceData(bl);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        return true;
    }

    protected void readVoxelDataIndividually(boolean bl) throws Exception {
        if (bl && !this.allowMapData) {
            return;
        }
        if (!bl || this.volumeData.sr != null) {
            this.voxelData = null;
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            return;
        }
        this.newVoxelDataCube();
        for (int i = 0; i < this.nPointsX; ++i) {
            float[][] fArray = AU.newFloat2(this.nPointsY);
            this.voxelData[i] = fArray;
            int n = 0;
            for (int j = 0; j < this.nPointsY; ++j) {
                fArray[j] = new float[this.nPointsZ];
                float[] fArray2 = fArray[j];
                int n2 = 0;
                while (n2 < this.nPointsZ) {
                    fArray2[n2] = this.getValue(i, j, n2, n);
                    ++n2;
                    ++n;
                }
            }
        }
    }

    protected void setVolumeData() {
    }

    protected boolean setVolumeDataParams() {
        if (this.params.volumeData != null) {
            this.setVolumeDataV(this.params.volumeData);
            return true;
        }
        if (!this.useOriginStepsPoints) {
            return false;
        }
        this.volumetricOrigin.setT(this.params.origin);
        this.volumetricVectors[0].set(this.params.steps.x, 0.0f, 0.0f);
        this.volumetricVectors[1].set(0.0f, this.params.steps.y, 0.0f);
        this.volumetricVectors[2].set(0.0f, 0.0f, this.params.steps.z);
        this.voxelCounts[0] = (int)this.params.points.x;
        this.voxelCounts[1] = (int)this.params.points.y;
        this.voxelCounts[2] = (int)this.params.points.z;
        if (this.voxelCounts[0] < 1 || this.voxelCounts[1] < 1 || this.voxelCounts[2] < 1) {
            return false;
        }
        this.showGridInfo();
        return true;
    }

    protected void showGridInfo() {
        Logger.info("grid origin  = " + this.params.origin);
        Logger.info("grid steps   = " + this.params.steps);
        Logger.info("grid points  = " + this.params.points);
        this.ptTemp.x = this.params.steps.x * this.params.points.x;
        this.ptTemp.y = this.params.steps.y * this.params.points.y;
        this.ptTemp.z = this.params.steps.z * this.params.points.z;
        Logger.info("grid lengths = " + this.ptTemp);
        this.ptTemp.add(this.params.origin);
        Logger.info("grid max xyz = " + this.ptTemp);
    }

    protected int setVoxelRange(int n, float f, float f2, float f3, int n2, float f4) {
        int n3;
        if (f >= f2) {
            f = -10.0f;
            f2 = 10.0f;
        }
        float f5 = f2 - f;
        float f6 = this.params.resolution;
        if (f6 != Float.MAX_VALUE) {
            f3 = f6;
        }
        if ((n3 = (int)Math.floor(f5 * f3) + 1) > n2) {
            if ((this.dataType & 0x100) > 0) {
                if (f6 == Float.MAX_VALUE) {
                    if (!this.isQuiet) {
                        Logger.info("Maximum number of voxels for index=" + n + " exceeded (" + n3 + ") -- set to " + n2);
                    }
                    n3 = n2;
                } else if (!this.isQuiet) {
                    Logger.info("Warning -- high number of grid points: " + n3);
                }
            } else if (f6 == Float.MAX_VALUE) {
                n3 = n2;
            }
        }
        if (n3 == 1) {
            n3 = 2;
        }
        if ((f3 = (float)(n3 - 1) / f5) < f4) {
            f3 = f4;
            n3 = (int)Math.floor(f3 * f5 + 1.0f);
            f3 = (float)(n3 - 1) / f5;
        }
        float f7 = this.volumeData.volumetricVectorLengths[n] = 1.0f / f3;
        this.voxelCounts[n] = n3;
        if (!this.isQuiet) {
            Logger.info("isosurface resolution for axis " + (n + 1) + " set to " + f3 + " points/Angstrom; " + this.voxelCounts[n] + " voxels");
        }
        switch (n) {
            case 0: {
                this.volumetricVectors[0].set(f7, 0.0f, 0.0f);
                this.volumetricOrigin.x = f;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, f7, 0.0f);
                this.volumetricOrigin.y = f;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, f7);
                this.volumetricOrigin.z = f;
                if (this.isEccentric) {
                    this.eccentricityMatrix.rotate(this.volumetricOrigin);
                }
                if (this.center == null || Float.isNaN(this.center.x)) break;
                this.volumetricOrigin.add(this.center);
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.rotate(this.volumetricVectors[n]);
        }
        return this.voxelCounts[n];
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        this.readSurfaceDataVDR(bl);
    }

    protected void readSurfaceDataVDR(boolean bl) throws Exception {
        if (this.isProgressive && !bl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            return;
        }
        if (this.precalculateVoxelData) {
            this.generateCube();
        } else {
            this.readVoxelDataIndividually(bl);
        }
    }

    protected void generateCube() {
        Logger.info("data type: user volumeData");
        Logger.info("voxel grid origin:" + this.volumetricOrigin);
        for (int i = 0; i < 3; ++i) {
            Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
        }
        Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
    }

    @Override
    protected void closeReader() {
    }
}

