/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class WMTSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String URL_GET_ENCODING_PARAMS = "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER={layer}&STYLE={style}&FORMAT={format}&tileMatrixSet={TileMatrixSet}&tileMatrix={TileMatrix}&tileRow={TileRow}&tileCol={TileCol}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}"};
    private static final String OWS_NS_URL = "http://www.opengis.net/ows/1.1";
    private static final String WMTS_NS_URL = "http://www.opengis.net/wmts/1.0";
    private static final String XLINK_NS_URL = "http://www.w3.org/1999/xlink";
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private Collection<Layer> layers;
    private Layer currentLayer;
    private TileMatrixSet currentTileMatrixSet;
    private double crsScale;
    private TransferMode transferMode;

    public WMTSTileSource(ImageryInfo imageryInfo) throws IOException {
        super(imageryInfo);
        this.baseUrl = WMTSTileSource.normalizeCapabilitiesUrl(this.handleTemplate(imageryInfo.getUrl()));
        this.layers = this.getCapabilities();
        if (this.layers.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("No layers defined by getCapabilities document: {0}", imageryInfo.getUrl()));
        }
    }

    private Layer userSelectLayer(Collection<Layer> collection) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        Layer layer = null;
        SelectLayerDialog selectLayerDialog = new SelectLayerDialog(collection);
        if (selectLayerDialog.showDialog().getValue() == 1) {
            layer = selectLayerDialog.getSelectedLayer();
        }
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("No layer selected", new Object[0]));
        }
        return layer;
    }

    private String handleTemplate(String string) {
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private Collection<Layer> getCapabilities() throws IOException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newFactory();
        InputStream inputStream = new CachedFile(this.baseUrl).setHttpHeaders(this.headers).setMaxAge(604800L).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getInputStream();
        try {
            byte[] byArray = Utils.readBytesFromStream(inputStream);
            if (byArray == null || byArray.length == 0) {
                throw new IllegalArgumentException("Could not read data from: " + this.baseUrl);
            }
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new ByteArrayInputStream(byArray));
            Collection<Layer> collection = null;
            int n = xMLStreamReader.getEventType();
            while (xMLStreamReader.hasNext()) {
                if (n == 1) {
                    if (new QName(OWS_NS_URL, "OperationsMetadata").equals(xMLStreamReader.getName())) {
                        this.parseOperationMetadata(xMLStreamReader);
                    }
                    if (new QName(WMTS_NS_URL, "Contents").equals(xMLStreamReader.getName())) {
                        collection = WMTSTileSource.parseContents(xMLStreamReader);
                    }
                }
                n = xMLStreamReader.next();
            }
            return collection;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private static Collection<Layer> parseContents(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(WMTS_NS_URL, "Contents").equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (new QName(WMTS_NS_URL, "Layer").equals(xMLStreamReader.getName())) {
                    arrayList.add(WMTSTileSource.parseLayer(xMLStreamReader));
                }
                if (new QName(WMTS_NS_URL, "TileMatrixSet").equals(xMLStreamReader.getName())) {
                    TileMatrixSet tileMatrixSet = WMTSTileSource.parseTileMatrixSet(xMLStreamReader);
                    concurrentHashMap.put(tileMatrixSet.identifier, tileMatrixSet);
                }
            }
            n = xMLStreamReader.next();
        }
        ArrayList<Layer> arrayList2 = new ArrayList<Layer>();
        for (Layer layer : arrayList) {
            for (String string : layer.tileMatrixSetLinks) {
                Layer layer2 = new Layer(layer);
                layer2.tileMatrixSet = (TileMatrixSet)concurrentHashMap.get(string);
                arrayList2.add(layer2);
            }
        }
        return arrayList2;
    }

    private static Layer parseLayer(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Layer layer = new Layer();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(WMTS_NS_URL, "Layer").equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (new QName(WMTS_NS_URL, "Format").equals(xMLStreamReader.getName())) {
                    layer.format = xMLStreamReader.getElementText();
                }
                if (new QName(OWS_NS_URL, "Identifier").equals(xMLStreamReader.getName())) {
                    layer.name = xMLStreamReader.getElementText();
                }
                if (new QName(WMTS_NS_URL, "ResourceURL").equals(xMLStreamReader.getName()) && "tile".equals(xMLStreamReader.getAttributeValue("", "resourceType"))) {
                    layer.baseUrl = xMLStreamReader.getAttributeValue("", "template");
                }
                if (new QName(WMTS_NS_URL, "Style").equals(xMLStreamReader.getName()) && "true".equals(xMLStreamReader.getAttributeValue("", "isDefault")) && WMTSTileSource.moveReaderToTag(xMLStreamReader, new QName[]{new QName(OWS_NS_URL, "Identifier")})) {
                    layer.style = xMLStreamReader.getElementText();
                }
                if (new QName(WMTS_NS_URL, "TileMatrixSetLink").equals(xMLStreamReader.getName())) {
                    layer.tileMatrixSetLinks.add(WMTSTileSource.praseTileMatrixSetLink(xMLStreamReader));
                }
            }
            n = xMLStreamReader.next();
        }
        if (layer.style == null) {
            layer.style = "";
        }
        return layer;
    }

    private static String praseTileMatrixSetLink(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = null;
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(WMTS_NS_URL, "TileMatrixSetLink").equals(xMLStreamReader.getName()))) {
            if (n == 1 && new QName(WMTS_NS_URL, "TileMatrixSet").equals(xMLStreamReader.getName())) {
                string = xMLStreamReader.getElementText();
            }
            n = xMLStreamReader.next();
        }
        return string;
    }

    private static TileMatrixSet parseTileMatrixSet(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        TileMatrixSet tileMatrixSet = new TileMatrixSet();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(WMTS_NS_URL, "TileMatrixSet").equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (new QName(OWS_NS_URL, "Identifier").equals(xMLStreamReader.getName())) {
                    tileMatrixSet.identifier = xMLStreamReader.getElementText();
                }
                if (new QName(OWS_NS_URL, "SupportedCRS").equals(xMLStreamReader.getName())) {
                    tileMatrixSet.crs = WMTSTileSource.crsToCode(xMLStreamReader.getElementText());
                }
                if (new QName(WMTS_NS_URL, "TileMatrix").equals(xMLStreamReader.getName())) {
                    tileMatrixSet.tileMatrix.add(WMTSTileSource.parseTileMatrix(xMLStreamReader, tileMatrixSet.crs));
                }
            }
            n = xMLStreamReader.next();
        }
        return tileMatrixSet;
    }

    private static TileMatrix parseTileMatrix(XMLStreamReader xMLStreamReader, String string) throws XMLStreamException {
        Projection projection = Projections.getProjectionByCode(string);
        TileMatrix tileMatrix = new TileMatrix();
        if (projection == null) {
            projection = Main.getProjection();
        }
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(WMTS_NS_URL, "TileMatrix").equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (new QName(OWS_NS_URL, "Identifier").equals(xMLStreamReader.getName())) {
                    tileMatrix.identifier = xMLStreamReader.getElementText();
                }
                if (new QName(WMTS_NS_URL, "ScaleDenominator").equals(xMLStreamReader.getName())) {
                    tileMatrix.scaleDenominator = Double.parseDouble(xMLStreamReader.getElementText());
                }
                if (new QName(WMTS_NS_URL, "TopLeftCorner").equals(xMLStreamReader.getName())) {
                    String[] stringArray = xMLStreamReader.getElementText().split(" ");
                    if (projection.switchXY()) {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
                    } else {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                    }
                }
                if (new QName(WMTS_NS_URL, "TileHeight").equals(xMLStreamReader.getName())) {
                    tileMatrix.tileHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (new QName(WMTS_NS_URL, "TileWidth").equals(xMLStreamReader.getName())) {
                    tileMatrix.tileWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (new QName(WMTS_NS_URL, "MatrixHeight").equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (new QName(WMTS_NS_URL, "MatrixWidth").equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
            }
            n = xMLStreamReader.next();
        }
        if (tileMatrix.tileHeight != tileMatrix.tileWidth) {
            throw new AssertionError((Object)I18n.tr("Only square tiles are supported. {0}x{1} returned by server for TileMatrix identifier {2}", tileMatrix.tileHeight, tileMatrix.tileWidth, tileMatrix.identifier));
        }
        return tileMatrix;
    }

    private void parseOperationMetadata(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !new QName(OWS_NS_URL, "OperationsMetadata").equals(xMLStreamReader.getName()))) {
            if (n == 1 && new QName(OWS_NS_URL, "Operation").equals(xMLStreamReader.getName()) && "GetTile".equals(xMLStreamReader.getAttributeValue("", "name")) && WMTSTileSource.moveReaderToTag(xMLStreamReader, new QName[]{new QName(OWS_NS_URL, "DCP"), new QName(OWS_NS_URL, "HTTP"), new QName(OWS_NS_URL, "Get")})) {
                this.baseUrl = xMLStreamReader.getAttributeValue(XLINK_NS_URL, "href");
                this.transferMode = WMTSTileSource.getTransferMode(xMLStreamReader);
            }
            n = xMLStreamReader.next();
        }
    }

    private static TransferMode getTransferMode(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        QName qName = new QName(OWS_NS_URL, "Get");
        Utils.ensure(qName.equals(xMLStreamReader.getName()), "WMTS Parser state invalid. Expected element %s, got %s", qName, xMLStreamReader.getName());
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !qName.equals(xMLStreamReader.getName()))) {
            if (n == 1 && new QName(OWS_NS_URL, "Constraint").equals(xMLStreamReader.getName()) && "GetEncoding".equals(xMLStreamReader.getAttributeValue("", "name"))) {
                WMTSTileSource.moveReaderToTag(xMLStreamReader, new QName[]{new QName(OWS_NS_URL, "AllowedValues"), new QName(OWS_NS_URL, "Value")});
                return TransferMode.fromString(xMLStreamReader.getElementText());
            }
            n = xMLStreamReader.next();
        }
        return null;
    }

    private static boolean moveReaderToTag(XMLStreamReader xMLStreamReader, QName[] qNameArray) throws XMLStreamException {
        QName qName = xMLStreamReader.getName();
        int n = 0;
        QName qName2 = qNameArray[n];
        QName qName3 = null;
        QName qName4 = null;
        int n2 = 0;
        while (xMLStreamReader.hasNext() && (n2 != 2 || !qName.equals(xMLStreamReader.getName()))) {
            if (n2 == 2 && qName4 != null && qName4.equals(xMLStreamReader.getName())) {
                qName4 = null;
            }
            if (qName4 == null) {
                if (n2 == 1) {
                    if (qName2.equals(xMLStreamReader.getName())) {
                        if (++n >= qNameArray.length) {
                            return true;
                        }
                        qName3 = qName2;
                        qName2 = qNameArray[n];
                    } else {
                        qName4 = xMLStreamReader.getName();
                    }
                }
                if (n2 == 2 && qName3 != null && qName3.equals(xMLStreamReader.getName())) {
                    qName2 = qName3;
                    qName3 = --n >= 0 ? qNameArray[n] : null;
                }
            }
            n2 = xMLStreamReader.next();
        }
        return false;
    }

    private static String normalizeCapabilitiesUrl(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
        return uRL2.toExternalForm();
    }

    private static String crsToCode(String string) {
        if (string.startsWith("urn:ogc:def:crs:")) {
            return string.replaceFirst("urn:ogc:def:crs:([^:]*):.*:(.*)$", "$1:$2");
        }
        return string;
    }

    public void initProjection(Projection projection) {
        Layer layer;
        Collection<Layer> collection;
        String string = null;
        if (this.currentLayer != null) {
            string = this.currentLayer.name;
        }
        if (!(collection = this.getLayers(string, projection.toCode())).isEmpty() && (layer = this.userSelectLayer(collection)) != null) {
            this.currentTileMatrixSet = layer.tileMatrixSet;
            this.currentLayer = layer;
        }
        this.crsScale = (double)this.getTileSize() * 2.8E-4 / projection.getMetersPerUnit();
    }

    private Collection<Layer> getLayers(String string, String string2) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (string != null && !string.equals(layer.name) || string2 != null && !string2.equals(layer.tileMatrixSet.crs)) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    @Override
    public int getDefaultTileSize() {
        return this.getTileSize();
    }

    @Override
    public int getTileSize() {
        TileMatrix tileMatrix = this.getTileMatrix(1);
        if (tileMatrix == null) {
            return 1;
        }
        return tileMatrix.tileHeight;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string;
        if (this.currentLayer == null) {
            return "";
        }
        if (this.currentLayer.baseUrl != null && this.transferMode == null) {
            string = this.currentLayer.baseUrl;
        } else {
            switch (this.transferMode) {
                case KVP: {
                    string = this.baseUrl + URL_GET_ENCODING_PARAMS;
                    break;
                }
                case REST: {
                    string = this.currentLayer.baseUrl;
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return "";
        }
        return string.replaceAll("\\{layer\\}", this.currentLayer.name).replaceAll("\\{format\\}", this.currentLayer.format).replaceAll("\\{TileMatrixSet\\}", this.currentTileMatrixSet.identifier).replaceAll("\\{TileMatrix\\}", tileMatrix.identifier).replaceAll("\\{TileRow\\}", Integer.toString(n3)).replaceAll("\\{TileCol\\}", Integer.toString(n2)).replaceAll("(?i)\\{style\\}", this.currentLayer.style);
    }

    private TileMatrix getTileMatrix(int n) {
        if (n > this.getMaxZoom()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        return this.currentTileMatrixSet.tileMatrix.toArray(new TileMatrix[0])[n - 1];
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return Main.getProjection().getWorldBoundsLatLon().getCenter().toCoordinate();
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        return Main.getProjection().eastNorth2latlon(eastNorth).toCoordinate();
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileXY(0.0, 0.0);
        }
        Projection projection = Main.getProjection();
        EastNorth eastNorth = projection.latlon2eastNorth(new LatLon(d, d2));
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        return new TileXY((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3, (tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.getTileXMax(n, Main.getProjection());
    }

    @Override
    public int getTileXMin(int n) {
        return 0;
    }

    @Override
    public int getTileYMax(int n) {
        return this.getTileYMax(n, Main.getProjection());
    }

    @Override
    public int getTileYMin(int n) {
        return 0;
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new Point(0, 0);
        }
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3), (int)Math.round((tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public Coordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public Coordinate xyToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return new Coordinate(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        Projection projection = Main.getProjection();
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        LatLon latLon = projection.eastNorth2latlon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getMaxZoom() {
        if (this.currentTileMatrixSet != null) {
            return this.currentTileMatrixSet.tileMatrix.size();
        }
        return 0;
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    public Set<String> getSupportedProjections() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.currentLayer == null) {
            for (Layer layer : this.layers) {
                hashSet.add(layer.tileMatrixSet.crs);
            }
        } else {
            for (Layer layer : this.layers) {
                if (!this.currentLayer.name.equals(layer.name)) continue;
                hashSet.add(layer.tileMatrixSet.crs);
            }
        }
        return hashSet;
    }

    private int getTileYMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixHeight != -1) {
            return tileMatrix.matrixHeight;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.north() - eastNorth.north()) / d);
    }

    private int getTileXMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixWidth != -1) {
            return tileMatrix.matrixWidth;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.east() - eastNorth.east()) / d);
    }

    private static final class SelectLayerDialog
    extends ExtendedDialog {
        private final Layer[] layers;
        private final JTable list;

        SelectLayerDialog(Collection<Layer> collection) {
            super(Main.parent, I18n.tr("Select WMTS layer", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.layers = collection.toArray(new Layer[0]);
            this.list = new JTable(new AbstractTableModel(){

                @Override
                public Object getValueAt(int n, int n2) {
                    switch (n2) {
                        case 0: {
                            return SelectLayerDialog.this.layers[n].name;
                        }
                        case 1: {
                            return SelectLayerDialog.this.layers[n].tileMatrixSet.crs;
                        }
                        case 2: {
                            return SelectLayerDialog.this.layers[n].tileMatrixSet.identifier;
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public int getRowCount() {
                    return SelectLayerDialog.this.layers.length;
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return I18n.tr("Layer name", new Object[0]);
                        }
                        case 1: {
                            return I18n.tr("Projection", new Object[0]);
                        }
                        case 2: {
                            return I18n.tr("Matrix set identifier", new Object[0]);
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            });
            this.list.setSelectionMode(0);
            this.list.setRowSelectionAllowed(true);
            this.list.setColumnSelectionAllowed(false);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JScrollPane(this.list), GBC.eol().fill());
            this.setContent(jPanel);
        }

        public Layer getSelectedLayer() {
            int n = this.list.getSelectedRow();
            if (n < 0) {
                return null;
            }
            return this.layers[n];
        }
    }

    private static enum TransferMode {
        KVP("KVP"),
        REST("RESTful");

        private final String typeString;

        private TransferMode(String string2) {
            this.typeString = string2;
        }

        private String getTypeString() {
            return this.typeString;
        }

        private static TransferMode fromString(String string) {
            for (TransferMode transferMode : TransferMode.values()) {
                if (!transferMode.getTypeString().equals(string)) continue;
                return transferMode;
            }
            return null;
        }
    }

    private static class Layer {
        private String format;
        private String name;
        private TileMatrixSet tileMatrixSet;
        private String baseUrl;
        private String style;
        public Collection<String> tileMatrixSetLinks = new ArrayList<String>();

        Layer(Layer layer) {
            if (layer != null) {
                this.format = layer.format;
                this.name = layer.name;
                this.baseUrl = layer.baseUrl;
                this.style = layer.style;
                this.tileMatrixSet = new TileMatrixSet(layer.tileMatrixSet);
            }
        }

        Layer() {
        }
    }

    private static class TileMatrixSet {
        SortedSet<TileMatrix> tileMatrix = new TreeSet<TileMatrix>(new Comparator<TileMatrix>(){

            @Override
            public int compare(TileMatrix tileMatrix, TileMatrix tileMatrix2) {
                return -1 * Double.compare(tileMatrix.scaleDenominator, tileMatrix2.scaleDenominator);
            }
        });
        private String crs;
        private String identifier;

        TileMatrixSet(TileMatrixSet tileMatrixSet) {
            if (tileMatrixSet != null) {
                this.tileMatrix = new TreeSet<TileMatrix>(tileMatrixSet.tileMatrix);
                this.crs = tileMatrixSet.crs;
                this.identifier = tileMatrixSet.identifier;
            }
        }

        TileMatrixSet() {
        }
    }

    private static class TileMatrix {
        private String identifier;
        private double scaleDenominator;
        private EastNorth topLeftCorner;
        private int tileWidth;
        private int tileHeight;
        private int matrixWidth = -1;
        private int matrixHeight = -1;

        private TileMatrix() {
        }
    }
}

