/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

public final class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainOsmApiInitializationException(osmApiInitializationException), I18n.tr("Error", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#OsmApiInitializationException"));
    }

    public static void explainChangesetClosedException(ChangesetClosedException changesetClosedException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainChangesetClosedException(changesetClosedException), I18n.tr("Error", new Object[0]), 0, HelpUtil.ht("/Action/Upload#ChangesetClosed"));
    }

    public static void explainPreconditionFailed(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainPreconditionFailed(osmApiException), I18n.tr("Precondition violation", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#OsmApiException"));
    }

    public static void explainGeneric(Exception exception) {
        Main.error(exception);
        BugReportExceptionHandler.handleException(exception);
    }

    public static void explainSecurityException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainSecurityException(osmTransferException), I18n.tr("Security exception", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#SecurityException"));
    }

    public static void explainNestedSocketException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedSocketException(osmTransferException), I18n.tr("Network exception", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#NestedSocketException"));
    }

    public static void explainNestedIOException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIOException(osmTransferException), I18n.tr("IO Exception", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#NestedIOException"));
    }

    public static void explainNestedIllegalDataException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIllegalDataException(osmTransferException), I18n.tr("Illegal Data", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#IllegalDataException"));
    }

    public static void explainNestedOfflineAccessException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainOfflineAccessException(osmTransferException), I18n.tr("Offline mode", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#OfflineAccessException"));
    }

    public static void explainNestedInvocationTargetException(Exception exception) {
        InvocationTargetException invocationTargetException = ExceptionUtil.getNestedException(exception, InvocationTargetException.class);
        if (invocationTargetException != null) {
            BugReportExceptionHandler.handleException(invocationTargetException);
            return;
        }
    }

    public static void explainInternalServerError(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainInternalServerError(osmTransferException), I18n.tr("Internal Server Error", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#InternalServerError"));
    }

    public static void explainBadRequest(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainBadRequest(osmApiException), I18n.tr("Bad Request", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#BadRequest"));
    }

    public static void explainNotFound(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNotFound(osmApiException), I18n.tr("Not Found", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#NotFound"));
    }

    public static void explainConflict(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainConflict(osmApiException), I18n.tr("Conflict", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#Conflict"));
    }

    public static void explainAuthenticationFailed(OsmApiException osmApiException) {
        String string = OsmApi.isUsingOAuth() ? ExceptionUtil.explainFailedOAuthAuthentication(osmApiException) : ExceptionUtil.explainFailedBasicAuthentication(osmApiException);
        HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Authentication Failed", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainAuthorizationFailed(OsmApiException osmApiException) {
        String string;
        Matcher matcher;
        String string2 = osmApiException.getAccessedUrl();
        Pattern pattern = Pattern.compile("https?://.*/api/0.6/(node|way|relation)/(\\d+)/(\\d+)");
        if (string2 != null && (matcher = pattern.matcher(string2)).matches()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = matcher.group(3);
            string = I18n.tr("Access to redacted version ''{0}'' of {1} {2} is forbidden.", string5, I18n.tr(string3, new Object[0]), string4);
        } else {
            string = OsmApi.isUsingOAuth() ? ExceptionUtil.explainFailedOAuthAuthorisation(osmApiException) : ExceptionUtil.explainFailedAuthorisation(osmApiException);
        }
        HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Authorisation Failed", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#AuthorizationFailed"));
    }

    public static void explainClientTimeout(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(osmApiException), I18n.tr("Client Time Out", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#ClientTimeOut"));
    }

    public static void explainBandwidthLimitExceeded(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainBandwidthLimitExceeded(osmApiException), I18n.tr("Bandwidth Limit Exceeded", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#BandwidthLimit"));
    }

    public static void explainGenericHttpException(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(osmApiException), I18n.tr("Communication with OSM server failed", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#GenericCommunicationError"));
    }

    public static void explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException missingOAuthAccessTokenException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainMissingOAuthAccessTokenException(missingOAuthAccessTokenException), I18n.tr("Authentication failed", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#MissingOAuthAccessToken"));
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedUnknownHostException(osmTransferException), I18n.tr("Unknown host", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#UnknownHost"));
    }

    public static void explainOsmTransferException(OsmTransferException osmTransferException) {
        if (ExceptionUtil.getNestedException(osmTransferException, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(osmTransferException);
            return;
        }
        if (ExceptionUtil.getNestedException(osmTransferException, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(osmTransferException);
            return;
        }
        if (ExceptionUtil.getNestedException(osmTransferException, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(osmTransferException);
            return;
        }
        if (ExceptionUtil.getNestedException(osmTransferException, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(osmTransferException);
            return;
        }
        if (ExceptionUtil.getNestedException(osmTransferException, IllegalDataException.class) != null) {
            ExceptionDialogUtil.explainNestedIllegalDataException(osmTransferException);
            return;
        }
        if (ExceptionUtil.getNestedException(osmTransferException, OfflineAccessException.class) != null) {
            ExceptionDialogUtil.explainNestedOfflineAccessException(osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof ChangesetClosedException) {
            ExceptionDialogUtil.explainChangesetClosedException((ChangesetClosedException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof MissingOAuthAccessTokenException) {
            ExceptionDialogUtil.explainMissingOAuthAccessTokenException((MissingOAuthAccessTokenException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)osmTransferException;
            switch (osmApiException.getResponseCode()) {
                case 412: {
                    ExceptionDialogUtil.explainPreconditionFailed(osmApiException);
                    return;
                }
                case 410: {
                    ExceptionDialogUtil.explainGoneForUnknownPrimitive(osmApiException);
                    return;
                }
                case 500: {
                    ExceptionDialogUtil.explainInternalServerError(osmApiException);
                    return;
                }
                case 400: {
                    ExceptionDialogUtil.explainBadRequest(osmApiException);
                    return;
                }
                case 404: {
                    ExceptionDialogUtil.explainNotFound(osmApiException);
                    return;
                }
                case 409: {
                    ExceptionDialogUtil.explainConflict(osmApiException);
                    return;
                }
                case 401: {
                    ExceptionDialogUtil.explainAuthenticationFailed(osmApiException);
                    return;
                }
                case 403: {
                    ExceptionDialogUtil.explainAuthorizationFailed(osmApiException);
                    return;
                }
                case 408: {
                    ExceptionDialogUtil.explainClientTimeout(osmApiException);
                    return;
                }
                case 509: {
                    ExceptionDialogUtil.explainBandwidthLimitExceeded(osmApiException);
                    return;
                }
            }
            ExceptionDialogUtil.explainGenericHttpException(osmApiException);
            return;
        }
        ExceptionDialogUtil.explainGeneric(osmTransferException);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainGoneForUnknownPrimitive(osmApiException), I18n.tr("Object deleted", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#GoneForUnknownPrimitive"));
    }

    public static void explainException(Exception exception) {
        if (ExceptionUtil.getNestedException(exception, InvocationTargetException.class) != null) {
            ExceptionDialogUtil.explainNestedInvocationTargetException(exception);
            return;
        }
        if (exception instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)exception);
            return;
        }
        ExceptionDialogUtil.explainGeneric(exception);
    }
}

