/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.util.Objects;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractAuthorizationUI
extends VerticallyScrollablePanel {
    public static final String ACCESS_TOKEN_PROP = AbstractAuthorizationUI.class.getName() + ".accessToken";
    private String apiUrl;
    private final AdvancedOAuthPropertiesPanel pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel();
    private transient OAuthToken accessToken;

    protected void fireAccessTokenChanged(OAuthToken oAuthToken, OAuthToken oAuthToken2) {
        this.firePropertyChange(ACCESS_TOKEN_PROP, oAuthToken, oAuthToken2);
    }

    public AbstractAuthorizationUI(String string) {
        this.setApiUrl(string);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String string) {
        this.apiUrl = string;
        this.pnlAdvancedProperties.setApiUrl(string);
    }

    protected AdvancedOAuthPropertiesPanel getAdvancedPropertiesPanel() {
        return this.pnlAdvancedProperties;
    }

    public OAuthParameters getOAuthParameters() {
        return this.pnlAdvancedProperties.getAdvancedParameters();
    }

    public OAuthToken getAccessToken() {
        return this.accessToken;
    }

    protected void setAccessToken(OAuthToken oAuthToken) {
        OAuthToken oAuthToken2 = this.accessToken;
        this.accessToken = oAuthToken;
        if (oAuthToken2 == null ^ this.accessToken == null) {
            this.fireAccessTokenChanged(oAuthToken2, this.accessToken);
        } else if (!(oAuthToken2 == null && this.accessToken == null || Objects.equals(oAuthToken2, this.accessToken))) {
            this.fireAccessTokenChanged(oAuthToken2, this.accessToken);
        }
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public abstract boolean isSaveAccessTokenToPreferences();

    public void initFromPreferences(Preferences preferences) {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        this.pnlAdvancedProperties.initFromPreferences(preferences);
    }
}

