/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.BaseLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Shape;

public abstract class Location
implements BaseLocation {
    protected static IncompatibleLocationException incompatibleLocation() throws IncompatibleLocationException {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IncompatibleLocationException();
    }

    protected static FinalLocationException finalLocation() throws FinalLocationException {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new FinalLocationException();
    }

    @Override
    public final Object get(DynamicObject store, Shape shape) {
        return this.get(store, Location.checkShape(store, shape));
    }

    @Override
    public Object get(DynamicObject store, boolean condition) {
        return this.getInternal(store);
    }

    @Override
    public void set(DynamicObject store, Object value, Shape shape) throws IncompatibleLocationException, FinalLocationException {
        this.setInternal(store, value);
    }

    @Override
    public final void set(DynamicObject store, Object value, Shape oldShape, Shape newShape) throws IncompatibleLocationException {
        if (this.canStore(value)) {
            store.setShapeAndGrow(oldShape, newShape);
            try {
                this.setInternal(store, value);
            }
            catch (IncompatibleLocationException ex) {
                throw new IllegalStateException();
            }
        } else {
            throw Location.incompatibleLocation();
        }
    }

    @Override
    public final void set(DynamicObject store, Object value) throws IncompatibleLocationException, FinalLocationException {
        this.set(store, value, null);
    }

    protected abstract Object getInternal(DynamicObject var1);

    protected abstract void setInternal(DynamicObject var1, Object var2) throws IncompatibleLocationException;

    public boolean canSet(DynamicObject store, Object value) {
        return this.canStore(value);
    }

    public boolean canStore(Object value) {
        return true;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    protected static boolean checkShape(DynamicObject store, Shape shape) {
        return store.getShape() == shape;
    }
}

