/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.Runtime;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.DefaultValueNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.ffi.LibCClockGetTime;
import org.jruby.truffle.runtime.ffi.TimeSpec;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.signal.Signal;
import org.jruby.truffle.runtime.signal.SignalOperations;

@CoreClass(name="Process")
public abstract class ProcessNodes {
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_REALTIME = 2;
    public static final int CLOCK_THREAD_CPUTIME = 3;
    public static final int CLOCK_MONOTONIC_RAW = 4;

    @CoreMethod(names={"pid"}, onSingleton=true)
    public static abstract class PidNode
    extends CoreMethodArrayArgumentsNode {
        public PidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int pid() {
            return this.posix().getpid();
        }
    }

    @CoreMethod(names={"kill"}, onSingleton=true, required=2)
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(signalName)"})
        public int kill(DynamicObject signalName, int pid) {
            int self = this.posix().getpid();
            if (self == pid) {
                return this.raise(Layouts.SYMBOL.getString(signalName));
            }
            throw new UnsupportedOperationException();
        }

        @CompilerDirectives.TruffleBoundary
        private int raise(String signalName) {
            Signal signal = new Signal(signalName);
            try {
                SignalOperations.raise(signal);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
            return 1;
        }
    }

    @CoreMethod(names={"clock_gettime"}, onSingleton=true, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="clock_id"), @NodeChild(type=RubyNode.class, value="unit")})
    public static abstract class ClockGetTimeNode
    extends CoreMethodNode {
        public static final int CLOCK_THREAD_CPUTIME_ID = 3;
        public static final int CLOCK_MONOTONIC_RAW_ID = 4;
        private final DynamicObject floatSecondSymbol = this.getContext().getSymbol("float_second");
        private final DynamicObject nanosecondSymbol = this.getContext().getSymbol("nanosecond");

        public ClockGetTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"unit"})
        public RubyNode coerceUnit(RubyNode unit) {
            return DefaultValueNodeGen.create(this.getContext(), this.getSourceSection(), this.floatSecondSymbol, unit);
        }

        @Specialization(guards={"isMonotonic(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_monotonic(int clock_id, DynamicObject unit) {
            long time = System.nanoTime();
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isRealtime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_realtime(int clock_id, DynamicObject unit) {
            long time = System.currentTimeMillis() * 1000000L;
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isThreadCPUTime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_thread_cputime(int clock_id, DynamicObject unit) {
            return this.clock_gettime_clock_id(3, unit);
        }

        @Specialization(guards={"isMonotonicRaw(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_monotonic_raw(int clock_id, DynamicObject unit) {
            return this.clock_gettime_clock_id(4, unit);
        }

        @CompilerDirectives.TruffleBoundary
        private Object clock_gettime_clock_id(int clock_id, DynamicObject unit) {
            TimeSpec timeSpec;
            LibCClockGetTime libCClockGetTime = this.getContext().getLibCClockGetTime();
            int r = libCClockGetTime.clock_gettime(clock_id, timeSpec = new TimeSpec(Runtime.getRuntime((Object)libCClockGetTime)));
            if (r != 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().systemCallError("clock_gettime failed: " + r, this));
            }
            long nanos = timeSpec.getTVsec() * 1000000000L + timeSpec.getTVnsec();
            return this.timeToUnit(nanos, unit);
        }

        private Object timeToUnit(long time, DynamicObject unit) {
            assert (RubyGuards.isRubySymbol(unit));
            if (unit == this.nanosecondSymbol) {
                return time;
            }
            if (unit == this.floatSecondSymbol) {
                return (double)time / 1.0E9;
            }
            throw new UnsupportedOperationException(Layouts.SYMBOL.getString(unit));
        }

        protected static boolean isMonotonic(int clock_id) {
            return clock_id == 1;
        }

        protected static boolean isRealtime(int clock_id) {
            return clock_id == 2;
        }

        protected static boolean isThreadCPUTime(int clock_id) {
            return clock_id == 3;
        }

        protected static boolean isMonotonicRaw(int clock_id) {
            return clock_id == 4;
        }
    }
}

