/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.PGPUtil;

public class JcaPGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public PublicKey getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = this.helper.createKeyFactory("RSA");
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("DSA");
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(elGamalPublicBCPGKey.getY(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("ElGamal");
                    return keyFactory.generatePublic(dHPublicKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    X9ECParameters x9ECParameters = PGPUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID());
                    org.bouncycastle.math.ec.ECPoint eCPoint = PGPUtil.decodePoint(eCDHPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve());
                    ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(eCDHPublicBCPGKey.getCurveOID(), x9ECParameters));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDH");
                    return keyFactory.generatePublic(eCPublicKeySpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey eCDSAPublicBCPGKey = (ECDSAPublicBCPGKey)publicKeyPacket.getKey();
                    X9ECParameters x9ECParameters = PGPUtil.getX9Parameters(eCDSAPublicBCPGKey.getCurveOID());
                    org.bouncycastle.math.ec.ECPoint eCPoint = PGPUtil.decodePoint(eCDSAPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve());
                    ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(eCDSAPublicBCPGKey.getCurveOID(), x9ECParameters));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDSA");
                    return keyFactory.generatePublic(eCPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        void var5_15;
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(dHParameterSpec.getP(), dHParameterSpec.getG(), dHPublicKey.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else {
            if (!(publicKey instanceof ECPublicKey)) throw new PGPException("unknown key class");
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)subjectPublicKeyInfo.getAlgorithm().getParameters());
            X9ECParameters x9ECParameters = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), (ASN1OctetString)dEROctetString);
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
                if (pGPKdfParameters == null) {
                    pGPKdfParameters = new PGPKdfParameters(8, 7);
                }
                ECDHPublicBCPGKey eCDHPublicBCPGKey = new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
                return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), this.fingerPrintCalculator);
            } else {
                if (n != 19) throw new PGPException("unknown EC algorithm");
                ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
            }
        }
        return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, null, publicKey, date);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey();
        }
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    KeyFactory keyFactory = this.helper.createKeyFactory("RSA");
                    return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("DSA");
                    return keyFactory.generatePrivate(dSAPrivateKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.getECParameterSpec(eCDHPublicBCPGKey.getCurveOID()));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDH");
                    return keyFactory.generatePrivate(eCPrivateKeySpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey eCDSAPublicBCPGKey = (ECDSAPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.getECParameterSpec(eCDSAPublicBCPGKey.getCurveOID()));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDSA");
                    return keyFactory.generatePrivate(eCPrivateKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(elGamalSecretBCPGKey.getX(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("ElGamal");
                    return keyFactory.generatePrivate(dHPrivateKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        BCPGObject bCPGObject;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKey.getX());
                break;
            }
            case 16: 
            case 20: {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                bCPGObject = new ElGamalSecretBCPGKey(dHPrivateKey.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                bCPGObject = new ECSecretBCPGKey(eCPrivateKey.getS());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException {
        return this.getECParameterSpec(aSN1ObjectIdentifier, PGPUtil.getX9Parameters(aSN1ObjectIdentifier));
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParameters x9ECParameters) throws InvalidParameterSpecException, NoSuchProviderException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
        algorithmParameters.init(new ECGenParameterSpec(ECNamedCurveTable.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier)));
        return algorithmParameters.getParameterSpec(ECParameterSpec.class);
    }
}

