/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.mix.listeners;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.listeners.AbstractRunButtonActionListener;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.commons.business.WorkExecutor;
import org.pdfsam.guiclient.commons.business.WorkThread;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.mix.GUI.MixMainGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunButtonActionListener
extends AbstractRunButtonActionListener {
    private static final Logger log = Logger.getLogger((String)RunButtonActionListener.class.getPackage().getName());
    private MixMainGUI panel;

    public RunButtonActionListener(MixMainGUI panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (WorkExecutor.getInstance().getRunningThreads() > 0 || this.panel.getSelectionPanel().isAdding()) {
            DialogUtility.showWarningAddingDocument((Component)((Object)this.panel));
            return;
        }
        PdfSelectionTableItem[] items = this.panel.getSelectionPanel().getTableRows();
        if (items == null || items.length != 2) {
            DialogUtility.showWarningNoDocsSelected((Component)((Object)this.panel), (int)2);
            return;
        }
        if (StringUtils.isEmpty((String)this.panel.getDestinationTextField().getText())) {
            DialogUtility.showWarningNoDestinationSelected((Component)((Object)this.panel), (int)0);
            return;
        }
        LinkedList<String> args = new LinkedList<String>();
        try {
            String secondStep;
            File destFile;
            int chosenOpt;
            if (this.panel.getOverwriteCheckbox().isSelected() && Configuration.getInstance().isAskOverwriteConfirmation()) {
                int dialogRet = DialogUtility.askForOverwriteConfirmation((Component)((Object)this.panel));
                if (1 == dialogRet) {
                    this.panel.getOverwriteCheckbox().setSelected(false);
                } else if (2 == dialogRet) {
                    return;
                }
            }
            args.addAll(this.getInputFilesArguments(items));
            String destination = "";
            RunButtonActionListener.ensurePdfExtensionOnTextField((JTextField)this.panel.getDestinationTextField());
            File destinationDir = new File(this.panel.getDestinationTextField().getText());
            File parent = destinationDir.getParentFile();
            if (parent == null || !parent.exists()) {
                String suggestedDir = this.getSuggestedOutputFile(items[items.length - 1], destinationDir.getName());
                chosenOpt = DialogUtility.showConfirmOuputLocationDialog((Component)((Object)this.panel), (String)suggestedDir);
                if (0 == chosenOpt) {
                    this.panel.getDestinationTextField().setText(suggestedDir);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            File file = destFile = (destination = this.panel.getDestinationTextField().getText()) != null ? new File(destination) : null;
            if (destFile != null && destFile.exists() && !this.panel.getOverwriteCheckbox().isSelected()) {
                chosenOpt = DialogUtility.askForOverwriteOutputFileDialog((Component)((Object)this.panel), (String)destFile.getName());
                if (0 == chosenOpt) {
                    this.panel.getOverwriteCheckbox().setSelected(true);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            args.add("-o");
            args.add(destination);
            String step = this.panel.getStepTextField().getText();
            if (StringUtils.isNotEmpty((String)step)) {
                args.add("-step");
                args.add(step);
            }
            if (StringUtils.isNotEmpty((String)(secondStep = this.panel.getSecondStepTextField().getText()))) {
                args.add("-secondstep");
                args.add(secondStep);
            }
            if (this.panel.getOverwriteCheckbox().isSelected()) {
                args.add("-overwrite");
            }
            if (this.panel.getOutputCompressedCheck().isSelected()) {
                args.add("-compressed");
            }
            if (this.panel.getReverseFirstCheckbox().isSelected()) {
                args.add("-reversefirst");
            }
            if (this.panel.getReverseSecondCheckbox().isSelected()) {
                args.add("-reversesecond");
            }
            args.add("-pdfversion");
            args.add(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId());
            args.add("mix");
            String[] myStringArray = args.toArray(new String[args.size()]);
            WorkExecutor.getInstance().execute((Runnable)new WorkThread(myStringArray));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
            SoundPlayer.getInstance().playErrorSound();
        }
    }

    private List<String> getInputFilesArguments(PdfSelectionTableItem[] items) {
        LinkedList<String> retList = new LinkedList<String>();
        retList.add("-f1");
        String f1 = items[0].getInputFile().getAbsolutePath();
        if (items[0].getPassword() != null && items[0].getPassword().length() > 0) {
            log.debug((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found a password for first file."));
            f1 = f1 + ":" + items[0].getPassword();
        }
        retList.add(f1);
        retList.add("-f2");
        String f2 = items[1].getInputFile().getAbsolutePath();
        if (items[1].getPassword() != null && items[1].getPassword().length() > 0) {
            log.debug((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found a password for second file."));
            f2 = f2 + ":" + items[1].getPassword();
        }
        retList.add(f2);
        return retList;
    }
}

