/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class DateTimeParam
extends AbstractParameter {
    private static final String sDateFmt = Strings.get("DateTimeParam.dateFormat");
    private static final String sTimeFmt = "HH:mm:ss:SSS";
    private static final String sTimeFmtDisplay = "HH:mm[:ss[:SSS]]";
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat(sDateFmt + " " + "HH:mm:ss:SSS");
    private static final DecimalFormat secondFmt = new DecimalFormat("00");
    private static final DecimalFormat msFmt = new DecimalFormat("000");
    private Date date = null;
    private int defaultSeconds = 0;
    private int defaultMilliSeconds = 0;

    public DateTimeParam(String tag, String desc) {
        this(tag, desc, true, false, false);
    }

    public DateTimeParam(String tag, String desc, boolean optional) {
        this(tag, desc, optional, false, false);
    }

    public DateTimeParam(String tag, String desc, boolean optional, boolean multiValued) {
        this(tag, desc, optional, multiValued, false);
    }

    public DateTimeParam(String tag, String desc, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sDateFmt + " " + sTimeFmtDisplay);
    }

    public DateTimeParam(String tag, String desc, Date[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public DateTimeParam(String tag, String desc, Date[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public DateTimeParam(String tag, String desc, Date[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public DateTimeParam(String tag, String desc, Date[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAcceptableDates(acceptableValues);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sDateFmt + " " + sTimeFmtDisplay);
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        try {
            this.stringToDate(val);
        }
        catch (ParseException e) {
            throw new CmdLineException(Strings.get("DateTimeParam.invalidDate", new Object[]{this.getTag(), sDateFmt + " " + sTimeFmtDisplay}));
        }
    }

    public Date getDate() {
        String sVal = this.getValue();
        Date date = null;
        if (sVal != null) {
            try {
                date = this.stringToDate(sVal);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return date;
    }

    public Date[] getDates() {
        Collection sVals = this.getValues();
        Date[] dates = new Date[sVals.size()];
        int i = 0;
        Iterator itr = sVals.iterator();
        while (itr.hasNext()) {
            try {
                dates[i] = this.stringToDate((String)itr.next());
                ++i;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return dates;
    }

    public void setDefaultSeconds(int defaultSeconds) {
        this.defaultSeconds = defaultSeconds;
    }

    public int getDefaultSeconds() {
        return this.defaultSeconds;
    }

    public void setDefaultMilliSeconds(int defaultMilliSeconds) {
        this.defaultMilliSeconds = defaultMilliSeconds;
    }

    public int getDefaultMilliSeconds() {
        return this.defaultMilliSeconds;
    }

    public static String getParseFormat() {
        return dateFmt.toLocalizedPattern();
    }

    public void setAcceptableDates(Date[] dates) {
        String[] sDates = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            sDates[i] = dateFmt.format(dates[i]);
        }
        super.setAcceptableValues(sDates);
    }

    public Date[] getAcceptableDates() {
        String[] sVals = this.getAcceptableValues();
        if (sVals == null) {
            return null;
        }
        Date[] dates = new Date[sVals.length];
        for (int i = 0; i < sVals.length; ++i) {
            try {
                dates[i] = this.stringToDate(sVals[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dates;
    }

    public void setAcceptableDates(Collection vals) {
        String[] sVals = new String[vals.size()];
        int i = 0;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            this.date = (Date)itr.next();
            sVals[i] = dateFmt.format(this.date);
            ++i;
        }
        super.setAcceptableValues(sVals);
    }

    public void setAcceptableValues(Collection vals) {
        throw new UnsupportedOperationException();
    }

    public void setAcceptableValues(String[] vals) {
        throw new UnsupportedOperationException();
    }

    private Date stringToDate(String val) throws ParseException {
        if (val.length() == sDateFmt.length() + 6) {
            val = val + ":" + secondFmt.format(this.defaultSeconds);
        }
        if (val.length() == sDateFmt.length() + 9) {
            val = val + ":" + msFmt.format(this.defaultMilliSeconds);
        }
        return dateFmt.parse(val);
    }
}

