/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class DecryptParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = -8763522845338987001L;
    public static final String F_ARG = "f";
    public static final String P_ARG = "p";
    public static final String O_ARG = "o";
    private File outputFile;
    private PdfFile[] inputFileList;
    private String outputFilesPrefix = "";

    public DecryptParsedCommand() {
    }

    public DecryptParsedCommand(PdfFile[] inputFileList, File outputFile, String outputFilesPrefix) {
        this.inputFileList = inputFileList;
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public DecryptParsedCommand(PdfFile[] inputFileList, File outputFile, String outputFilesPrefix, boolean overwrite, boolean compress, File logFile, char outputPdfVersion) {
        super(overwrite, compress, logFile, outputPdfVersion);
        this.inputFileList = inputFileList;
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public DecryptParsedCommand(PdfFile[] inputFileList, File outputFile, String outputFilesPrefix, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.inputFileList = inputFileList;
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public PdfFile[] getInputFileList() {
        return this.inputFileList;
    }

    public void setInputFileList(PdfFile[] inputFileList) {
        this.inputFileList = inputFileList;
    }

    public String getOutputFilesPrefix() {
        return this.outputFilesPrefix;
    }

    public void setOutputFilesPrefix(String outputFilesPrefix) {
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public String getCommand() {
        return "decrypt";
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        if (this.inputFileList != null) {
            for (int i = 0; i < this.inputFileList.length; ++i) {
                retVal.append(this.inputFileList[i] == null ? "" : "[inputFileList[" + i + "]=" + this.inputFileList[i].getFile().getAbsolutePath() + "]");
            }
        }
        retVal.append("[outputFilesPrefix=" + this.outputFilesPrefix + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

