/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.BooleanParam;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class SlideShowCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Set slide show options.";
    private final List slideshowOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "pdf output file: if it doesn't exist it's created, if it exists it must be writeable", 65535, false, false), new PdfFileParam("f", "input pdf file to set the slide show options", 65519, false, false), new StringParam("p", "prefix for the output files name", true), new StringParam("t", "slideshow transition effect definition", 12, 50, true, true), new StringParam("dt", "slideshow default transition effect definition", 10, 50, true, false), new FileParam("l", "xml file containing all the transitions effects definitions", 65515, true, false), new BooleanParam("fullscreen", "open the document in fullscreen mode")));
    private static final String SLIDE_SHOW_HELP_TEXT = "Set slide show options for the pdf document. \nYou must specify '-f /home/user/infile.pdf' option to set the input file you want to set transitions (use filename:password if the file is password protected).\nYou must specify '-o /home/user/out.pdf' to set the output file.\n'-t transition' to set the slide show transition options. Syntax: transitiontype:transitiondurationinsec:pagedisplaydurationinsec:pagenumber.\nPossible transitiontype values { blindh, blindv, wipeb2t, glitterd, dissolve, inwardbox, glitterl2r, wipel2r, outwardbox, wiper2l, splithin, splithout, splitvin, splitvout, glittert2b, wipet2b} \nExample: blindv:1:3:57 uses a 1 second long vertical blind to display page number 57 for 3 seconds\n'-dt defaulttransition' to set the slide show default transition used for every pages except those specified with '-t'\nSyntax: transitiontype:transitiondurationinsec:pagedisplaydurationinsec.\nExample: blindv:1:3 uses a 1 second long vertical blind to display pages for 3 seconds\n'-l /tmp/transitions.xml' a xml file containing all the transitions effects definitions \nExample: <transitions defaulttype=\"transitiontype\" defaulttduration=\"transitiondurationinsec\" defaultduration=\"pagedisplaydurationinsec\"><transition type=\"transitiontype\" tduration=\"transitiondurationinsec\" duration=\"pagedisplaydurationinsec\" pagenumber=\"number\" /></transitions>\n'-fullscreen' open the document in full screen mode\n";
    private static final String SLIDE_SHOW_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp/out.pdf -fullscreen -dt dissolve:1:5 -t wipel2r:1:5:20 -t wiper2l:1:5:21 -overwrite slideshow\n";
    private final List slideshowArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[slideshow]}", new String[]{"slideshow"}, false)));

    public Collection getArguments() {
        return this.slideshowArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return SLIDE_SHOW_EXAMPLE;
    }

    public Collection getOptions() {
        return this.slideshowOptions;
    }

    public String getHelpMessage() {
        return SLIDE_SHOW_HELP_TEXT;
    }
}

