/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.console.business.dto.Bounds;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.ConcatParsedCommand;
import org.pdfsam.console.business.pdf.bookmarks.BookmarksProcessor;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.business.pdf.writers.PdfCopyFieldsConcatenator;
import org.pdfsam.console.business.pdf.writers.PdfSimpleConcatenator;
import org.pdfsam.console.business.pdf.writers.interfaces.PdfConcatenator;
import org.pdfsam.console.exceptions.console.ConcatException;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ValidationException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class ConcatCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(ConcatCmdExecutor.class.getPackage().getName());
    private static final String FILESET_NODE = "fileset";
    private static final String FILE_NODE = "file";
    private PdfReader pdfReader = null;
    private PdfConcatenator pdfWriter = null;
    private PdfStamper rotationStamper = null;
    private PdfReader rotationReader = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof ConcatParsedCommand) {
            ConcatParsedCommand inputCommand = (ConcatParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            PdfFile[] fileList = inputCommand.getInputFileList();
            if (fileList == null || fileList.length <= 0) {
                File listFile = inputCommand.getInputCvsOrXmlFile();
                if (listFile != null && listFile.exists()) {
                    fileList = this.parseListFile(listFile);
                } else if (inputCommand.getInputDirectory() != null) {
                    fileList = this.getPdfFiles(inputCommand.getInputDirectory());
                }
            }
            if (fileList == null || fileList.length <= 0) {
                throw new ConcatException(7);
            }
            int pageOffset = 0;
            ArrayList master = new ArrayList();
            Document pdfDocument = null;
            int totalProcessedPages = 0;
            try {
                Object[] pageSelections = inputCommand.getPageSelections();
                File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                int length = ArrayUtils.getLength((Object)pageSelections);
                for (int i = 0; i < fileList.length; ++i) {
                    String currentPageSelection = "all";
                    int currentDocumentPages = 0;
                    if (!ArrayUtils.isEmpty((Object[])pageSelections) && i <= length) {
                        currentPageSelection = ((String)pageSelections[i]).toLowerCase();
                    }
                    String[] selectionGroups = StringUtils.split((String)currentPageSelection, (String)",");
                    this.pdfReader = PdfUtility.readerFor(fileList[i]);
                    this.pdfReader.removeUnusedObjects();
                    this.pdfReader.consolidateNamedDestinations();
                    int pdfNumberOfPages = this.pdfReader.getNumberOfPages();
                    BookmarksProcessor bookmarkProcessor = new BookmarksProcessor(SimpleBookmark.getBookmark((PdfReader)this.pdfReader), pdfNumberOfPages);
                    List boundsList = this.getBounds(pdfNumberOfPages, selectionGroups);
                    ValidationUtility.assertNotIntersectedBoundsList(boundsList);
                    String boundsString = "";
                    Iterator iter = boundsList.iterator();
                    while (iter.hasNext()) {
                        Bounds bounds = (Bounds)iter.next();
                        boundsString = boundsString + (boundsString.length() > 0 ? "," + bounds.toString() : bounds.toString());
                        List bookmarks = bookmarkProcessor.processBookmarks(bounds.getStart(), bounds.getEnd(), pageOffset);
                        if (bookmarks != null) {
                            master.addAll(bookmarks);
                        }
                        int relativeOffset = bounds.getEnd() - bounds.getStart() + 1;
                        currentDocumentPages += relativeOffset;
                        pageOffset += relativeOffset;
                    }
                    LOG.info(fileList[i].getFile().getAbsolutePath() + ": " + currentDocumentPages + " pages to be added.");
                    if (this.pdfWriter == null) {
                        if (inputCommand.isCopyFields()) {
                            this.pdfWriter = new PdfCopyFieldsConcatenator(new FileOutputStream(tmpFile), inputCommand.isCompress());
                            LOG.debug("PdfCopyFieldsConcatenator created.");
                            if (inputCommand.getOutputPdfVersion() != null) {
                                this.pdfWriter.setPdfVersion(inputCommand.getOutputPdfVersion().charValue());
                            }
                            HashMap meta = this.pdfReader.getInfo();
                            meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                        } else {
                            pdfDocument = new Document(this.pdfReader.getPageSizeWithRotation(1));
                            this.pdfWriter = new PdfSimpleConcatenator(pdfDocument, new FileOutputStream(tmpFile), inputCommand.isCompress());
                            LOG.debug("PdfSimpleConcatenator created.");
                            if (inputCommand.getOutputPdfVersion() != null) {
                                this.pdfWriter.setPdfVersion(inputCommand.getOutputPdfVersion().charValue());
                            }
                            pdfDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                            pdfDocument.open();
                        }
                    }
                    this.pdfReader.selectPages(boundsString);
                    this.pdfWriter.addDocument(this.pdfReader);
                    this.pdfReader.close();
                    this.pdfWriter.freeReader(this.pdfReader);
                    totalProcessedPages += currentDocumentPages;
                    LOG.info(currentDocumentPages + " pages processed correctly.");
                    this.setPercentageOfWorkDone((i + 1) * 1000 / fileList.length);
                }
                if (master.size() > 0) {
                    this.pdfWriter.setOutlines(master);
                }
                LOG.info("Total processed pages: " + totalProcessedPages + ".");
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
                if (inputCommand.getRotations() != null && inputCommand.getRotations().length > 0) {
                    LOG.info("Applying pages rotation.");
                    File rotatedTmpFile = this.applyRotations(tmpFile, inputCommand);
                    FileUtility.deleteFile(tmpFile);
                    FileUtility.renameTemporaryFile(rotatedTmpFile, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                } else {
                    FileUtility.renameTemporaryFile(tmpFile, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                }
                LOG.debug("File " + inputCommand.getOutputFile().getCanonicalPath() + " created.");
            }
            catch (ConsoleException consoleException) {
                throw consoleException;
            }
            catch (Exception e) {
                throw new ConcatException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfReader(this.rotationReader);
        this.closePdfStamper(this.rotationStamper);
        if (this.pdfWriter != null) {
            this.pdfWriter.close();
        }
    }

    private File applyRotations(File inputFile, ConcatParsedCommand inputCommand) throws Exception {
        this.rotationReader = new PdfReader(inputFile.getAbsolutePath());
        this.rotationReader.removeUnusedObjects();
        this.rotationReader.consolidateNamedDestinations();
        int pdfNumberOfPages = this.rotationReader.getNumberOfPages();
        PageRotation[] rotations = inputCommand.getRotations();
        if (rotations != null && rotations.length > 0) {
            if (rotations.length > 1) {
                for (int i = 0; i < rotations.length; ++i) {
                    if (pdfNumberOfPages >= rotations[i].getPageNumber() && rotations[i].getPageNumber() > 0) {
                        PdfDictionary dictionary = this.rotationReader.getPageN(rotations[i].getPageNumber());
                        int rotation = (rotations[i].getDegrees() + this.rotationReader.getPageRotation(rotations[i].getPageNumber())) % 360;
                        dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotation));
                        continue;
                    }
                    LOG.warn("Rotation for page " + rotations[i].getPageNumber() + " ignored.");
                }
            } else if (rotations[0].getType() == 3) {
                int pageRotation = rotations[0].getDegrees();
                for (int i = 1; i <= pdfNumberOfPages; ++i) {
                    PdfDictionary dictionary = this.rotationReader.getPageN(i);
                    int rotation = (pageRotation + this.rotationReader.getPageRotation(i)) % 360;
                    dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotation));
                }
            } else if (rotations[0].getType() == 0) {
                if (pdfNumberOfPages >= rotations[0].getPageNumber() && rotations[0].getPageNumber() > 0) {
                    PdfDictionary dictionary = this.rotationReader.getPageN(rotations[0].getPageNumber());
                    int rotation = (rotations[0].getDegrees() + this.rotationReader.getPageRotation(rotations[0].getPageNumber())) % 360;
                    dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotation));
                } else {
                    LOG.warn("Rotation for page " + rotations[0].getPageNumber() + " ignored.");
                }
            } else if (rotations[0].getType() == 1) {
                int pageRotation = rotations[0].getDegrees();
                for (int i = 1; i <= pdfNumberOfPages; i += 2) {
                    PdfDictionary dictionary = this.rotationReader.getPageN(i);
                    int rotation = (pageRotation + this.rotationReader.getPageRotation(i)) % 360;
                    dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotation));
                }
            } else if (rotations[0].getType() == 2) {
                int pageRotation = rotations[0].getDegrees();
                for (int i = 2; i <= pdfNumberOfPages; i += 2) {
                    PdfDictionary dictionary = this.rotationReader.getPageN(i);
                    int rotation = (pageRotation + this.rotationReader.getPageRotation(i)) % 360;
                    dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotation));
                }
            } else {
                LOG.warn("Unable to find the rotation type. " + rotations[0]);
            }
            LOG.info("Pages rotation applied.");
        }
        File rotatedTmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
        Character pdfVersion = inputCommand.getOutputPdfVersion();
        this.rotationStamper = pdfVersion != null ? new PdfStamper(this.rotationReader, (OutputStream)new FileOutputStream(rotatedTmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.rotationReader, (OutputStream)new FileOutputStream(rotatedTmpFile), this.rotationReader.getPdfVersion());
        HashMap meta = this.rotationReader.getInfo();
        meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
        this.setCompressionSettingOnStamper(inputCommand, this.rotationStamper);
        this.rotationStamper.setMoreInfo(meta);
        this.rotationStamper.close();
        this.rotationReader.close();
        return rotatedTmpFile;
    }

    private List getBounds(int pdfNumberOfPages, String[] selections) throws ValidationException, ConcatException {
        ArrayList<Bounds> retVal = new ArrayList<Bounds>();
        for (int i = 0; i < selections.length; ++i) {
            Bounds bounds = this.getBounds(pdfNumberOfPages, selections[i]);
            ValidationUtility.assertValidBounds(bounds, pdfNumberOfPages);
            retVal.add(bounds);
        }
        return retVal;
    }

    private Bounds getBounds(int pdfNumberOfPages, String currentPageSelection) throws ConcatException {
        Bounds retVal = new Bounds(1, pdfNumberOfPages);
        if (!"all".equals(currentPageSelection)) {
            String[] limits = currentPageSelection.split("-");
            try {
                retVal.setStart(Integer.parseInt(limits[0]));
                if (limits.length > 1) {
                    retVal.setEnd(Integer.parseInt(limits[1]));
                } else if (currentPageSelection.indexOf(45) == -1) {
                    retVal.setEnd(Integer.parseInt(limits[0]));
                } else {
                    retVal.setEnd(pdfNumberOfPages);
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConcatException(1, new String[]{"" + currentPageSelection}, nfe);
            }
        }
        return retVal;
    }

    private PdfFile[] parseCsvFile(File inputFile) throws ConcatException {
        ArrayList<PdfFile> retVal = new ArrayList<PdfFile>();
        try {
            LOG.debug("Parsing CSV file " + inputFile.getAbsolutePath());
            BufferedReader bufferReader = new BufferedReader(new FileReader(inputFile));
            String temp = "";
            while ((temp = bufferReader.readLine()) != null) {
                String[] tmpContent = temp.split(",");
                for (int i = 0; i < tmpContent.length; ++i) {
                    if (tmpContent[i].trim().length() <= 0) continue;
                    retVal.add(new PdfFile(tmpContent[i], null));
                }
            }
            bufferReader.close();
        }
        catch (IOException e) {
            throw new ConcatException(4, new String[]{inputFile.getAbsolutePath()}, e);
        }
        return retVal.toArray(new PdfFile[0]);
    }

    private PdfFile[] parseXmlFile(File inputFile) throws ConcatException {
        ArrayList<PdfFile> fileList = new ArrayList<PdfFile>();
        String parentPath = null;
        try {
            LOG.debug("Parsing xml file " + inputFile.getAbsolutePath());
            SAXReader reader = new SAXReader();
            org.dom4j.Document document = reader.read(inputFile);
            List nodes = document.selectNodes("/filelist/*");
            parentPath = inputFile.getParent();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                Node domNode = (Node)iter.next();
                String nodeName = domNode.getName();
                if (FILESET_NODE.equals(nodeName)) {
                    fileList.addAll(this.getFileNodesFromFileset(domNode, parentPath));
                    continue;
                }
                if (FILE_NODE.equals(nodeName)) {
                    fileList.add(this.getPdfFileFromNode(domNode, null));
                    continue;
                }
                LOG.warn("Node type not supported: " + nodeName);
            }
        }
        catch (Exception e) {
            throw new ConcatException(4, new String[]{inputFile.getAbsolutePath()}, e);
        }
        return fileList.toArray(new PdfFile[0]);
    }

    private List getFileNodesFromFileset(Node fileSetNode, String parentDir) throws Exception {
        String parentPath = null;
        Node useCurrentDir = fileSetNode.selectSingleNode("@usecurrentdir");
        Node dir = fileSetNode.selectSingleNode("@dir");
        if (dir != null && dir.getText().trim().length() > 0) {
            parentPath = dir.getText();
        } else if (useCurrentDir != null && Boolean.valueOf(useCurrentDir.getText()).booleanValue()) {
            parentPath = parentDir;
        }
        return this.getPdfFileListFromNode(fileSetNode.selectNodes(FILE_NODE), parentPath);
    }

    private List getPdfFileListFromNode(List fileList, String parentPath) throws Exception {
        ArrayList<PdfFile> retVal = new ArrayList<PdfFile>();
        for (int i = 0; fileList != null && i < fileList.size(); ++i) {
            Node pdfNode = (Node)fileList.get(i);
            retVal.add(this.getPdfFileFromNode(pdfNode, parentPath));
        }
        return retVal;
    }

    private PdfFile getPdfFileFromNode(Node pdfNode, String parentPath) throws Exception {
        PdfFile retVal = null;
        String pwd = null;
        String fileName = null;
        Node fileNode = pdfNode.selectSingleNode("@value");
        if (fileNode == null) {
            throw new ConcatException(4, new String[]{"Empty file name."});
        }
        fileName = fileNode.getText().trim();
        Node pwdNode = pdfNode.selectSingleNode("@password");
        if (pwdNode != null) {
            pwd = pwdNode.getText();
        }
        retVal = parentPath != null && parentPath.length() > 0 ? new PdfFile(new File(parentPath, fileName), pwd) : new PdfFile(fileName, pwd);
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PdfFile[] parseListFile(File listFile) throws ConcatException {
        PdfFile[] retVal = null;
        if (listFile == null || !listFile.exists()) throw new ConcatException(4, new String[]{"Input file doesn't exists."});
        if ("xml".equals(this.getExtension(listFile))) {
            return this.parseXmlFile(listFile);
        }
        if (!"csv".equals(this.getExtension(listFile))) throw new ConcatException(4, new String[]{"Unsupported extension."});
        return this.parseCsvFile(listFile);
    }

    private String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

