/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.platform.cwt.font.FontConverterCwt2Pdf;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StandardFontFactory
implements IFontFactory {
    private static final String BUILTIN_SUFFIX_BOLD = "-Bold";
    private static final String BUILTIN_SUFFIX_BOLDOBLIQUE = "-BoldOblique";
    private static final String BUILTIN_SUFFIX_OBLIQUE = "-Oblique";
    private final List cache = new ArrayList(10);
    private boolean embedNew = true;

    protected PDFont createBuiltinFontAlias(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) {
        String string = this.createBuiltinName(iFontQuery);
        if (!PDFontType1.isBuiltinAlias((String)string)) {
            return null;
        }
        return PDFontType1.createNew((String)string);
    }

    protected PDFont createBuiltinFontStandard(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) {
        String string = this.createBuiltinName(iFontQuery);
        if (!PDFontType1.isBuiltin((String)string)) {
            return null;
        }
        return PDFontType1.createNew((String)string);
    }

    protected String createBuiltinName(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) {
        String string = iFontQuery.getFontName();
        if (string != null) {
            return string;
        }
        String string2 = iFontQuery.getFontFamilyName();
        if (PDFontType1.FONT_Courier.equals(string2) || PDFontType1.FONT_Helvetica.equals(string2)) {
            PDFontStyle pDFontStyle = iFontQuery.getFontStyle();
            if (pDFontStyle == PDFontStyle.BOLD) {
                return String.valueOf(string2) + BUILTIN_SUFFIX_BOLD;
            }
            if (pDFontStyle == PDFontStyle.ITALIC) {
                return String.valueOf(string2) + BUILTIN_SUFFIX_OBLIQUE;
            }
            if (pDFontStyle == PDFontStyle.BOLD_ITALIC) {
                return String.valueOf(string2) + BUILTIN_SUFFIX_BOLDOBLIQUE;
            }
        } else if (PDFontType1.FONT_Times_Roman.equals(string2)) {
            PDFontStyle pDFontStyle = iFontQuery.getFontStyle();
            if (pDFontStyle == PDFontStyle.BOLD) {
                return PDFontType1.FONT_Times_Bold;
            }
            if (pDFontStyle == PDFontStyle.ITALIC) {
                return PDFontType1.FONT_Times_Italic;
            }
            if (pDFontStyle == PDFontStyle.BOLD_ITALIC) {
                return PDFontType1.FONT_Times_BoldItalic;
            }
        }
        return string2;
    }

    protected PDFont createExternalFont(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) throws FontFactoryException {
        de.intarsys.cwt.font.FontQuery fontQuery = new de.intarsys.cwt.font.FontQuery();
        fontQuery.setFontType(iFontQuery.getFontType());
        fontQuery.setFontName(iFontQuery.getFontName());
        fontQuery.setFontFamilyName(iFontQuery.getFontFamilyName());
        fontQuery.setFontStyle(FontStyle.getFontStyle((String)iFontQuery.getFontStyle().getLabel()));
        IFont iFont = FontTools.lookupFont((IFontQuery)fontQuery);
        if (iFont != null) {
            FontConverterCwt2Pdf fontConverterCwt2Pdf = new FontConverterCwt2Pdf(iFont);
            fontConverterCwt2Pdf.setEmbed(this.isEmbedNew());
            return fontConverterCwt2Pdf.getPdFont();
        }
        return null;
    }

    public PDFont getBoldFlavor(PDFont pDFont) throws FontFactoryException {
        PDFontStyle pDFontStyle = pDFont.getLookupFontStyle().getBoldFlavor();
        FontQuery fontQuery = new FontQuery(pDFont);
        fontQuery.setOverrideFontStyle(pDFontStyle);
        PDFont pDFont2 = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        if (pDFont2 == null) {
            pDFont2 = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        }
        return pDFont2 == null ? pDFont : pDFont2;
    }

    protected List getCache() {
        return this.cache;
    }

    public PDFont getFont(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) throws FontFactoryException {
        PDFont pDFont = this.lookupFont(iFontQuery);
        if (pDFont == null) {
            pDFont = this.loadFont(iFontQuery);
        }
        if (pDFont == null) {
            throw new FontFactoryException("can't find font");
        }
        return pDFont;
    }

    public PDFont getItalicFlavor(PDFont pDFont) throws FontFactoryException {
        PDFont pDFont2 = null;
        PDFontStyle pDFontStyle = pDFont.getLookupFontStyle().getItalicFlavor();
        FontQuery fontQuery = new FontQuery(pDFont);
        fontQuery.setOverrideFontStyle(pDFontStyle);
        pDFont2 = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        if (pDFont2 == null) {
            pDFont2 = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        }
        return pDFont2 == null ? pDFont : pDFont2;
    }

    public PDFont getRegularFlavor(PDFont pDFont) throws FontFactoryException {
        PDFont pDFont2 = null;
        PDFontStyle pDFontStyle = PDFontStyle.REGULAR;
        FontQuery fontQuery = new FontQuery(pDFont);
        fontQuery.setOverrideFontStyle(pDFontStyle);
        pDFont2 = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        if (pDFont2 == null) {
            pDFont2 = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)fontQuery);
        }
        return pDFont2 == null ? pDFont : pDFont2;
    }

    public boolean isEmbedNew() {
        return this.embedNew;
    }

    protected boolean isReusable(PDFont pDFont) {
        if (pDFont.isStandardFont()) {
            return true;
        }
        if (pDFont.isSubset()) {
            return false;
        }
        Encoding encoding = pDFont.getEncoding();
        int n = pDFont.getFirstChar();
        while (n < pDFont.getLastChar()) {
            if (encoding.getDecoded(n) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected PDFont loadFont(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) throws FontFactoryException {
        PDFont pDFont = null;
        Object var3_3 = null;
        if ("Builtin".equals(iFontQuery.getFontType())) {
            pDFont = this.createBuiltinFontAlias(iFontQuery);
        } else if ("Type1".equals(iFontQuery.getFontType())) {
            pDFont = this.createBuiltinFontAlias(iFontQuery);
            if (pDFont == null) {
                pDFont = this.createExternalFont(iFontQuery);
            }
        } else if ("TrueType".equals(iFontQuery.getFontType())) {
            pDFont = this.createExternalFont(iFontQuery);
        } else {
            pDFont = this.createBuiltinFontStandard(iFontQuery);
            if (pDFont == null && (pDFont = this.createExternalFont(iFontQuery)) == null) {
                pDFont = this.createBuiltinFontAlias(iFontQuery);
            }
        }
        if (pDFont != null) {
            if (iFontQuery.getEncoding() != null) {
                pDFont.setEncoding(iFontQuery.getEncoding());
            } else if (pDFont.getFontDescriptor().isNonsymbolic()) {
                pDFont.setEncoding((Encoding)WinAnsiEncoding.UNIQUE);
            }
            if (this.isEmbedNew()) {
                try {
                    PlatformFontTools.embedFontFile(pDFont);
                }
                catch (IOException iOException) {
                    throw new FontFactoryException((Throwable)iOException);
                }
            }
            if (iFontQuery.getFontName() != null) {
                if (pDFont.getBaseFont() == null) {
                    pDFont.setBaseFont(iFontQuery.getFontName());
                    pDFont.getFontDescriptor().setFontName(pDFont.getFontName());
                }
                pDFont.setLookupFontName(iFontQuery.getFontName());
            }
            if (iFontQuery.getFontFamilyName() != null) {
                pDFont.setLookupFontFamilyName(iFontQuery.getFontFamilyName());
            }
            if (iFontQuery.getFontStyle() != PDFontStyle.UNDEFINED) {
                pDFont.setLookupFontStyle(iFontQuery.getFontStyle());
            }
            this.registerFont(pDFont);
        }
        return pDFont;
    }

    protected PDFont lookupFont(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery) {
        for (PDFont pDFont : this.getCache()) {
            if (!this.matches(iFontQuery, pDFont)) continue;
            return pDFont;
        }
        return null;
    }

    protected boolean matches(de.intarsys.pdf.font.outlet.IFontQuery iFontQuery, PDFont pDFont) {
        if (iFontQuery.getFontType() != null && !"Any".equals(iFontQuery.getFontType()) && !iFontQuery.getFontType().equals(pDFont.getFontType())) {
            return false;
        }
        if (iFontQuery.getFontName() != null) {
            if (!iFontQuery.getFontName().equals(pDFont.getLookupFontName())) {
                return false;
            }
        } else {
            if (iFontQuery.getFontFamilyName() != null && !iFontQuery.getFontFamilyName().equals(pDFont.getLookupFontFamilyName())) {
                return false;
            }
            if (iFontQuery.getFontStyle() != PDFontStyle.UNDEFINED && pDFont.getLookupFontStyle() != iFontQuery.getFontStyle()) {
                return false;
            }
        }
        return iFontQuery.getEncoding() == null || pDFont.getEncoding() == iFontQuery.getEncoding();
    }

    public void registerFont(PDFont pDFont) {
        this.getCache().add(pDFont);
    }

    public void reset() {
        this.cache.clear();
    }

    public void setEmbedNew(boolean bl) {
        this.embedNew = bl;
    }

    protected FontStyle toFontStyle(PDFontStyle pDFontStyle) {
        return FontStyle.getFontStyle((String)pDFontStyle.getLabel());
    }
}

