/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.image.CwtSwtImage;
import de.intarsys.cwt.swt.image.ISwtImage;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.cwt.swt.image.ImageConverterSwt2Awt;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CwtHybridImage
implements IAwtImage,
ISwtImage {
    private CwtAwtImage awtImage;
    private CwtSwtImage swtImage;

    public CwtHybridImage(BufferedImage bufferedImage) {
        this.awtImage = new CwtAwtImage(bufferedImage);
    }

    public CwtHybridImage(CwtAwtImage cwtAwtImage) {
        this.awtImage = cwtAwtImage;
    }

    public CwtHybridImage(CwtSwtImage cwtSwtImage) {
        this.swtImage = cwtSwtImage;
    }

    public CwtHybridImage(ImageData imageData) {
        this.swtImage = new CwtSwtImage(imageData);
    }

    protected CwtAwtImage createAwtImage() {
        ImageConverterSwt2Awt imageConverterSwt2Awt = new ImageConverterSwt2Awt(this.swtImage.getImageData());
        BufferedImage bufferedImage = imageConverterSwt2Awt.getBufferedImage();
        return new CwtAwtImage(bufferedImage);
    }

    protected CwtSwtImage createSwtImage() {
        ImageConverterAwt2Swt imageConverterAwt2Swt = new ImageConverterAwt2Swt(this.awtImage.getBufferedImage());
        ImageData imageData = imageConverterAwt2Swt.getImageData();
        return new CwtSwtImage(imageData);
    }

    protected void drawFromAwt(CwtAwtGraphicsContext cwtAwtGraphicsContext, float f, float f2) {
        if (this.awtImage == null) {
            this.awtImage = this.createAwtImage();
        }
        cwtAwtGraphicsContext.drawImage(this.awtImage, f, f2);
    }

    @Override
    public void drawFromGraphicsContext(IGraphicsContext iGraphicsContext, float f, float f2) {
        if (iGraphicsContext instanceof CwtSwtGraphicsContext) {
            this.drawFromSwt((CwtSwtGraphicsContext)iGraphicsContext, f, f2);
        } else if (iGraphicsContext instanceof CwtAwtGraphicsContext) {
            this.drawFromAwt((CwtAwtGraphicsContext)iGraphicsContext, f, f2);
        } else {
            throw new IllegalArgumentException("graphicsContext not supported");
        }
    }

    protected void drawFromSwt(CwtSwtGraphicsContext cwtSwtGraphicsContext, float f, float f2) {
        if (this.swtImage == null) {
            try {
                this.swtImage = this.createSwtImage();
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
        CwtSwtGraphicsContext cwtSwtGraphicsContext2 = cwtSwtGraphicsContext;
        cwtSwtGraphicsContext.drawImage(this.swtImage, f, f2);
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.awtImage == null) {
            this.awtImage = this.createAwtImage();
        }
        return this.awtImage.getBufferedImage();
    }

    @Override
    public int getHeight() {
        if (this.swtImage != null) {
            return this.swtImage.getHeight();
        }
        if (this.awtImage != null) {
            return this.awtImage.getHeight();
        }
        return 0;
    }

    @Override
    public Image getImage(Device device) {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage();
        }
        return this.swtImage.getImage(device);
    }

    @Override
    public ImageData getImageData() {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage();
        }
        return this.swtImage.getImageData();
    }

    @Override
    public int getWidth() {
        if (this.swtImage != null) {
            return this.swtImage.getWidth();
        }
        if (this.awtImage != null) {
            return this.awtImage.getWidth();
        }
        return 0;
    }
}

