/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFileLocator
extends CommonLocator {
    private final ZipFile zipFile;
    private final String path;

    public ZipFileLocator(ILocator iLocator, String string) {
        this.zipFile = new ZipFile(iLocator);
        this.path = string;
    }

    protected ZipFileLocator(ZipFile zipFile, String string) {
        this.zipFile = zipFile;
        this.path = string;
    }

    @Override
    public boolean exists() {
        return false;
    }

    protected ZipEntry findEntry(String string) throws IOException {
        for (ZipEntry zipEntry : this.zipFile.getEntries()) {
            if (!zipEntry.getName().equals(this.path)) continue;
            return zipEntry;
        }
        return null;
    }

    @Override
    public ILocator getChild(String string) {
        String string2 = String.valueOf(this.path) + "/" + string;
        return new ZipFileLocator(this, string2);
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        return null;
    }

    @Override
    public Reader getReader(String string) throws IOException {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getTypedName() {
        return null;
    }

    @Override
    public Writer getWriter() throws IOException {
        return null;
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return null;
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }

    static class ZipFile {
        private final ILocator zipLocator;
        private List<ZipEntry> entries;

        public ZipFile(ILocator iLocator) {
            this.zipLocator = iLocator;
        }

        protected List<ZipEntry> createEntries() throws IOException {
            ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
            InputStream inputStream = this.zipLocator.getInputStream();
            try {
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    arrayList.add(zipEntry);
                }
            }
            finally {
                StreamTools.close(inputStream);
            }
            return arrayList;
        }

        protected synchronized List<ZipEntry> getEntries() throws IOException {
            if (this.entries == null) {
                this.entries = this.createEntries();
            }
            return this.entries;
        }
    }
}

