/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.functor.ArgsConfigurationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsConfigurable;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.PACKAGE;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class UIComponent<M extends INotificationSupport, C, T>
implements IUIComponent<M, C, T>,
IArgsConfigurable {
    private C container;
    private final IUIComponent parent;
    private T component;
    private M model;
    private static final Logger Log = PACKAGE.Log;
    private INotificationListener listenModelChange = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            UIComponent.this.modelChanged(event);
        }
    };
    private IArgs configuration;
    private boolean disposed = false;
    private boolean componentCreated = false;

    public UIComponent() {
        this(null);
    }

    public UIComponent(IUIComponent<? extends INotificationSupport, C, T> iUIComponent) {
        this.parent = iUIComponent;
    }

    protected abstract T basicCreateComponent(C var1);

    @Override
    public void configure(IArgs iArgs) throws ArgsConfigurationException {
        this.configuration = iArgs;
    }

    @Override
    public final void createComponent(C c) {
        this.setContainer(c);
        T t = this.basicCreateComponent(c);
        this.setComponent(t);
        this.componentCreated = true;
        this.updateView(null);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.componentCreated = false;
        this.setObservable(null);
    }

    @Override
    public final T getComponent() {
        return this.component;
    }

    public IArgs getConfiguration() {
        return this.configuration;
    }

    protected C getContainer() {
        return this.container;
    }

    @Override
    public synchronized M getObservable() {
        return this.model;
    }

    public IUIComponent getParent() {
        return this.parent;
    }

    protected boolean isComponentCreated() {
        return this.componentCreated;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected void modelChanged(final Event event) {
        if (this.getObservable() == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (UIComponent.this.getObservable() == null) {
                        return;
                    }
                    if (!UIComponent.this.isComponentCreated()) {
                        return;
                    }
                    UIComponent.this.updateView(event);
                }
                catch (Exception exception) {
                    Log.log(Level.WARNING, "unexpeced error in updateView", exception);
                }
            }
        });
    }

    protected void setComponent(T t) {
        this.component = t;
    }

    protected void setComponentCreated(boolean bl) {
        this.componentCreated = bl;
    }

    protected void setContainer(C c) {
        this.container = c;
    }

    @Override
    public synchronized void setObservable(M m) {
        if (this.model == m) {
            return;
        }
        this.basicSetModel(m);
        if (this.model != null) {
            this.modelChanged(new AttributeChangedEvent(this.model, null, null, null));
        }
    }

    protected void basicSetModel(M m) {
        if (this.model != null) {
            this.model.removeNotificationListener(AttributeChangedEvent.ID, this.listenModelChange);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addNotificationListener(AttributeChangedEvent.ID, this.listenModelChange);
        }
    }

    protected void updateView(Event event) {
    }
}

