/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class MoveDownSelectionTableAction
extends AbstractAction {
    private static final long serialVersionUID = -395085278945264519L;
    private JPdfSelectionTable mainTable;

    public MoveDownSelectionTableAction(JPdfSelectionTable mainTable) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Move down"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Move down selected pdf file"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/down.png")));
        this.mainTable = mainTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] selectedRows = this.mainTable.getSelectedRows();
        if (selectedRows.length > 0) {
            ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).moveDownRows(selectedRows);
            if (selectedRows[selectedRows.length - 1] < ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).getRowCount() - 1) {
                this.mainTable.setRowSelectionInterval(selectedRows[0] + 1, selectedRows[selectedRows.length - 1] + 1);
            }
        }
    }
}

