/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.configuration.services.xml;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.pdfsam.console.business.ConsoleServicesFacade;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.guiclient.configuration.services.ConfigurationService;
import org.pdfsam.guiclient.configuration.services.xml.strategy.AbstractXmlConfigStrategy;
import org.pdfsam.guiclient.configuration.services.xml.strategy.BackwardCompatibilityXmlStrategy;
import org.pdfsam.guiclient.configuration.services.xml.strategy.DefaultXmlStrategy;
import org.pdfsam.guiclient.configuration.services.xml.strategy.XmlConfigStrategy;
import org.pdfsam.guiclient.exceptions.ConfigurationException;
import org.pdfsam.guiclient.l10n.LanguageLoader;
import org.pdfsam.guiclient.utils.ThemeUtility;
import org.pdfsam.guiclient.utils.XmlUtility;
import org.pdfsam.i18n.GettextResource;

public class XmlConfigurationService
implements ConfigurationService {
    private static final Logger log = Logger.getLogger(XmlConfigurationService.class.getPackage().getName());
    private static final String VERSION_XPATH = "/pdfsam/@config-version";
    public static final String OLD_CONFIGURATION_FILE_NAME = "config.xml";
    public static final String CONFIGURATION_FILE_NAME = "pdfsam-config.xml";
    public static final int DEFAULT_POOL_SIZE = 3;
    public static final String DEFAULT_CONFIG_DIRECTORY = System.getProperty("user.home") + "/.pdfsam";
    private ResourceBundle i18nResourceBundle;
    private ConsoleServicesFacade consoleServicesFacade;
    private boolean checkForUpdates = true;
    private boolean playSounds = true;
    private boolean askOverwriteConfirmation = true;
    private boolean thumbnailsHighQuality = false;
    private String defaultWorkingDirectory = null;
    private String defaultEnvironment = null;
    private int thumbCreatorPoolSize = 3;
    private String thumbnailsCreatorIdentifier = "";
    private int thumbnailsSize = 190;
    private int loggingLevel;
    private int lookAndFeel = 0;
    private int theme = 0;
    private String language;
    private String pluginAbsolutePath;
    private String configurationFilePath;

    public XmlConfigurationService() throws ConfigurationException {
        this.initializeService();
    }

    private void initializeService() throws ConfigurationException {
        log.info("Loading configuration..");
        File configurationFile = null;
        try {
            configurationFile = this.getConfigurationXmlFile(CONFIGURATION_FILE_NAME);
            if (configurationFile == null && (configurationFile = this.getConfigurationXmlFile(OLD_CONFIGURATION_FILE_NAME)) == null) {
                throw new ConfigurationException("Unable to find configuration file");
            }
            this.configurationFilePath = configurationFile.getAbsolutePath();
            Document document = XmlUtility.parseXmlFile(configurationFile);
            if (document == null) {
                throw new ConfigurationException("Unable to parse xml configuration file.");
            }
            AbstractXmlConfigStrategy strategy = null;
            Node node = document.selectSingleNode(VERSION_XPATH);
            strategy = node != null && "2".equals(node.getText().trim()) ? new DefaultXmlStrategy(document) : new BackwardCompatibilityXmlStrategy(document);
            this.initializeLocale(strategy);
            this.initializeLookAndFeel(strategy);
            this.initializeLoggingLevel(strategy);
            this.initializePoolSize(strategy);
            this.initializeThumbnailsSize(strategy);
            this.defaultWorkingDirectory = strategy.getDefaultWorkingDirectoryValue();
            this.defaultEnvironment = strategy.getDefaultEnvironmentValue();
            this.thumbnailsCreatorIdentifier = strategy.getThumbnailsCreatorIdentifierValue();
            this.checkForUpdates = this.isValidTrueValue(strategy.getCheckForUpdatesValue());
            this.playSounds = this.isValidTrueValue(strategy.getPlaySoundsValue());
            this.pluginAbsolutePath = strategy.getPluginAbsolutePath();
            this.askOverwriteConfirmation = this.isValidTrueValue(strategy.getAskOverwriteConfirmation());
            this.thumbnailsHighQuality = this.isValidTrueValue(strategy.getHighQualityThumbnails());
            log.info("Thumbnails high quality " + Boolean.toString(this.thumbnailsHighQuality));
            this.consoleServicesFacade = new ConsoleServicesFacade();
            strategy.close();
        }
        catch (DocumentException e) {
            throw new ConfigurationException(e);
        }
        catch (UnsupportedEncodingException ue) {
            throw new ConfigurationException(ue);
        }
    }

    private void initializePoolSize(XmlConfigStrategy strategy) {
        String poolSizeString = strategy.getThreadPoolSizeValue();
        if (poolSizeString.length() > 0) {
            this.thumbCreatorPoolSize = Integer.parseInt(poolSizeString);
        }
    }

    private void initializeThumbnailsSize(XmlConfigStrategy strategy) {
        String thumbSize = strategy.getThumbnailsSize();
        if (thumbSize.length() > 0) {
            this.thumbnailsSize = Integer.parseInt(thumbSize);
        }
        log.info("Thumbnails size set to " + this.thumbnailsSize);
    }

    private void initializeLocale(XmlConfigStrategy strategy) {
        log.info("Getting language...");
        this.language = strategy.getLocaleValue();
        if (this.language.length() <= 0) {
            log.warn("Unable to get language ResourceBudle, setting the default language (en_GB).");
            this.language = "en_GB";
        }
        this.i18nResourceBundle = new LanguageLoader(this.language, "org.pdfsam.i18n.resources.Messages").getBundle();
    }

    private void initializeLookAndFeel(XmlConfigStrategy strategy) {
        String themeString;
        log.info(GettextResource.gettext((ResourceBundle)this.i18nResourceBundle, (String)"Setting look and feel..."));
        String lookAndFeelString = strategy.getLookAndFeelValue();
        if (lookAndFeelString.length() > 0) {
            this.lookAndFeel = Integer.parseInt(lookAndFeelString);
        }
        if (ThemeUtility.isPlastic(this.lookAndFeel) && (themeString = strategy.getThemeValue()).length() > 0) {
            this.theme = Integer.parseInt(themeString);
        }
    }

    private void initializeLoggingLevel(XmlConfigStrategy strategy) {
        log.info(GettextResource.gettext((ResourceBundle)this.i18nResourceBundle, (String)"Setting logging level..."));
        String logLev = strategy.getLoggingLevelValue();
        if (logLev != null && logLev.length() > 0) {
            this.loggingLevel = Integer.parseInt(logLev);
        } else {
            log.warn(GettextResource.gettext((ResourceBundle)this.i18nResourceBundle, (String)"Unable to find log level, setting to default level (DEBUG)."));
            this.loggingLevel = 10000;
        }
    }

    private boolean isValidTrueValue(String value) {
        boolean retVal = Boolean.parseBoolean(value);
        if (!retVal) {
            retVal = "1".equals(value);
        }
        return retVal;
    }

    private File getConfigurationXmlFile(String configurationFileName) throws UnsupportedEncodingException, ConfigurationException {
        File retVal = null;
        String configSearchPath = new File(URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParent();
        retVal = this.searchConfigurationFile(configSearchPath, configurationFileName);
        if (retVal == null) {
            log.warn("Unable to find " + configurationFileName + " into " + configSearchPath);
            configSearchPath = System.getProperty("user.dir");
            log.info("Looking for " + configurationFileName + " into " + configSearchPath);
            retVal = this.searchConfigurationFile(configSearchPath, configurationFileName);
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File searchConfigurationFile(String searchPathIfFails, String configurationFileName) throws ConfigurationException {
        File secondaryPath;
        File retVal = new File(DEFAULT_CONFIG_DIRECTORY, configurationFileName);
        if (retVal.exists()) {
            if (retVal.canWrite()) return retVal;
        }
        if (!(secondaryPath = new File(searchPathIfFails, configurationFileName)).exists()) return null;
        if (secondaryPath.canWrite()) return secondaryPath;
        File defaultPath = new File(DEFAULT_CONFIG_DIRECTORY);
        if (!defaultPath.mkdirs()) throw new ConfigurationException("Unable to create " + defaultPath);
        log.info("Copying " + configurationFileName + " from " + secondaryPath.getPath() + " to " + defaultPath.getPath());
        FileUtility.copyFile((File)secondaryPath, (File)retVal);
        return retVal;
    }

    @Override
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Override
    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    @Override
    public boolean isPlaySounds() {
        return this.playSounds;
    }

    @Override
    public void setPlaySounds(boolean playSounds) {
        this.playSounds = playSounds;
    }

    @Override
    public String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    @Override
    public void setDefaultWorkingDirectory(String defaultWorkingDirectory) {
        this.defaultWorkingDirectory = defaultWorkingDirectory;
    }

    @Override
    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    @Override
    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    @Override
    public int getThumbCreatorPoolSize() {
        return this.thumbCreatorPoolSize;
    }

    @Override
    public String getThumbnailsCreatorIdentifier() {
        return this.thumbnailsCreatorIdentifier;
    }

    @Override
    public void setThumbnailsCreatorIdentifier(String thumbnailsCreatorIdentifier) {
        this.thumbnailsCreatorIdentifier = thumbnailsCreatorIdentifier;
    }

    @Override
    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public void setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    @Override
    public ResourceBundle getI18nResourceBundle() {
        return this.i18nResourceBundle;
    }

    @Override
    public ConsoleServicesFacade getConsoleServicesFacade() {
        return this.consoleServicesFacade;
    }

    @Override
    public int getLookAndFeel() {
        return this.lookAndFeel;
    }

    @Override
    public void setLookAndFeel(int lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public int getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(int theme) {
        this.theme = theme;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getConfigurationInformations() {
        return this.configurationFilePath;
    }

    @Override
    public String getPluginAbsolutePath() {
        return this.pluginAbsolutePath;
    }

    @Override
    public boolean isAskOverwriteConfirmation() {
        return this.askOverwriteConfirmation;
    }

    @Override
    public void setAskOverwriteConfirmation(boolean askOverwriteConfirmation) {
        this.askOverwriteConfirmation = askOverwriteConfirmation;
    }

    @Override
    public int getThumbnailSize() {
        return this.thumbnailsSize;
    }

    @Override
    public boolean isHighQualityThumbnils() {
        return this.thumbnailsHighQuality;
    }

    @Override
    public void save() throws IOException {
        File defaultPath = new File(DEFAULT_CONFIG_DIRECTORY);
        if (!defaultPath.exists() || !defaultPath.isDirectory()) {
            defaultPath.mkdirs();
        }
        DefaultXmlStrategy.saveXmlConfigurationFile(new File(defaultPath, CONFIGURATION_FILE_NAME), this);
    }
}

