/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.configuration.services.xml.strategy;

import java.io.File;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pdfsam.guiclient.configuration.services.ConfigurationService;
import org.pdfsam.guiclient.configuration.services.xml.strategy.AbstractXmlConfigStrategy;
import org.pdfsam.guiclient.utils.XmlUtility;

public class DefaultXmlStrategy
extends AbstractXmlConfigStrategy {
    private static final String ROOT_NODE = "/pdfsam";
    private static final String LAF_XPATH = "/settings/laf/@current-laf";
    private static final String THEME_XPATH = "/settings/laf/@current-theme";
    private static final String LANGUAGE_XPATH = "/settings/i18n/@value";
    private static final String LOGGING_LEVEL_XPATH = "/settings/loglevel/@value";
    private static final String DEF_WORKING_DIR_XPATH = "/settings/default_working_path/@value";
    private static final String THUMBNAILS_CREATOR_XPATH = "/settings/thumbnails_creator/@class";
    private static final String CHECK_UPDATES_XPATH = "/settings/checkupdates/@value";
    private static final String PLAYSOUNDS_XPATH = "/settings/playsounds/@value";
    private static final String ASK_OVERWRITE_XPATH = "/settings/overwrite_confirmation/@value";
    private static final String POOL_SIZE_XPATH = "/settings/thumbpoolsize/@value";
    private static final String DEFAULT_ENVIRONMENT_XPATH = "/settings/default_environment/@value";
    private static final String PLUGIN_ABSOLUTE_XPATH = "/settings/plugs_absolute_path/@value";
    private static final String THUMBNAILS_HIGH_QUALITY = "/settings/high_quality_thumbs/@value";
    private static final String THUMBNAILS_SIZE = "/settings/thumbnails_size/@value";

    public DefaultXmlStrategy(Document document) {
        super(document);
    }

    @Override
    public String getCheckForUpdatesValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/checkupdates/@value");
    }

    @Override
    public String getDefaultEnvironmentValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/default_environment/@value");
    }

    @Override
    public String getDefaultWorkingDirectoryValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/default_working_path/@value");
    }

    @Override
    public String getLoggingLevelValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/loglevel/@value");
    }

    @Override
    public String getPlaySoundsValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/playsounds/@value");
    }

    @Override
    public String getThreadPoolSizeValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/thumbpoolsize/@value");
    }

    @Override
    public String getThumbnailsCreatorIdentifierValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/thumbnails_creator/@class");
    }

    @Override
    public String getLookAndFeelValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/laf/@current-laf");
    }

    @Override
    public String getThemeValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/laf/@current-theme");
    }

    @Override
    public String getLocaleValue() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/i18n/@value");
    }

    @Override
    public String getPluginAbsolutePath() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/plugs_absolute_path/@value");
    }

    @Override
    public String getAskOverwriteConfirmation() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/overwrite_confirmation/@value");
    }

    @Override
    public String getHighQualityThumbnails() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/high_quality_thumbs/@value");
    }

    @Override
    public String getThumbnailsSize() {
        return XmlUtility.getXmlValue(this.getDocument(), "/pdfsam/settings/thumbnails_size/@value");
    }

    public static void saveXmlConfigurationFile(File configurationFile, ConfigurationService configuration) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(ROOT_NODE.replaceAll("/", ""));
        root.addAttribute("config-version", "2");
        XmlUtility.processXPath(root, LAF_XPATH, Integer.toString(configuration.getLookAndFeel()));
        XmlUtility.processXPath(root, THEME_XPATH, Integer.toString(configuration.getTheme()));
        XmlUtility.processXPath(root, POOL_SIZE_XPATH, Integer.toString(configuration.getThumbCreatorPoolSize()));
        XmlUtility.processXPath(root, LOGGING_LEVEL_XPATH, Integer.toString(configuration.getLoggingLevel()));
        XmlUtility.processXPath(root, LANGUAGE_XPATH, configuration.getLanguage());
        XmlUtility.processXPath(root, DEF_WORKING_DIR_XPATH, configuration.getDefaultWorkingDirectory());
        XmlUtility.processXPath(root, THUMBNAILS_CREATOR_XPATH, configuration.getThumbnailsCreatorIdentifier());
        XmlUtility.processXPath(root, DEFAULT_ENVIRONMENT_XPATH, configuration.getDefaultEnvironment());
        XmlUtility.processXPath(root, PLUGIN_ABSOLUTE_XPATH, configuration.getPluginAbsolutePath());
        XmlUtility.processXPath(root, CHECK_UPDATES_XPATH, Boolean.toString(configuration.isCheckForUpdates()));
        XmlUtility.processXPath(root, PLAYSOUNDS_XPATH, Boolean.toString(configuration.isPlaySounds()));
        XmlUtility.processXPath(root, ASK_OVERWRITE_XPATH, Boolean.toString(configuration.isAskOverwriteConfirmation()));
        XmlUtility.processXPath(root, THUMBNAILS_HIGH_QUALITY, Boolean.toString(configuration.isHighQualityThumbnils()));
        XmlUtility.processXPath(root, THUMBNAILS_SIZE, Integer.toString(configuration.getThumbnailSize()));
        XmlUtility.writeXmlFile(document, configurationFile);
    }
}

