/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class COSConverter {
    protected static Object basicToJava(COSObject cOSObject, Map map) {
        if (cOSObject instanceof COSArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = ((COSArray)cOSObject).iterator();
            while (iterator.hasNext()) {
                arrayList.add(COSConverter.toJava((COSObject)iterator.next(), map));
            }
            return arrayList;
        }
        if (cOSObject instanceof COSDictionary) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = ((COSDictionary)cOSObject).entryIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                hashMap.put(((COSName)entry.getKey()).stringValue(), COSConverter.toJava((COSObject)entry.getValue(), map));
            }
            return hashMap;
        }
        if (cOSObject instanceof COSObjectProxy) {
            return COSConverter.toJava(((COSObjectProxy)cOSObject).cosGetObject());
        }
        if (cOSObject instanceof COSStream) {
            return ((COSStream)cOSObject).getDecodedBytes();
        }
        if (cOSObject instanceof COSBoolean) {
            return ((COSBoolean)cOSObject).booleanValue();
        }
        if (cOSObject instanceof COSName) {
            return ((COSName)cOSObject).byteValue();
        }
        if (cOSObject instanceof COSNull) {
            return null;
        }
        if (cOSObject instanceof COSFixed) {
            return Float.valueOf(((COSFixed)cOSObject).floatValue());
        }
        if (cOSObject instanceof COSInteger) {
            return ((COSInteger)cOSObject).intValue();
        }
        if (cOSObject instanceof COSString) {
            return ((COSString)cOSObject).stringValue();
        }
        throw new IllegalStateException("can not happen");
    }

    public static COSObject toCos(Object object) {
        COSObject cOSObject = null;
        if (object instanceof String) {
            cOSObject = COSString.create((String)object);
        } else if (object instanceof Integer) {
            cOSObject = COSInteger.create((Integer)object);
        } else if (object instanceof Float) {
            cOSObject = COSFixed.create(((Float)object).floatValue());
        } else if (object instanceof Double) {
            cOSObject = COSFixed.create(((Double)object).floatValue());
        } else if (object instanceof Boolean) {
            cOSObject = COSBoolean.create((Boolean)object);
        } else if (object == null) {
            cOSObject = COSNull.create();
        } else if (object instanceof Map) {
            cOSObject = COSDictionary.create(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = String.valueOf(entry.getKey());
                Object v = entry.getValue();
                ((COSDictionary)cOSObject).put(COSName.create(string), COSConverter.toCos(v));
            }
        } else if (object instanceof List) {
            cOSObject = COSArray.create(((List)object).size());
            for (Object e : (List)object) {
                ((COSArray)cOSObject).add(COSConverter.toCos(e));
            }
        } else if (object instanceof byte[]) {
            cOSObject = COSName.create((byte[])object);
        } else if (object instanceof char[]) {
            cOSObject = COSString.create(new String((char[])object));
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            cOSObject = COSArray.create(fArray.length);
            int n = 0;
            while (n < fArray.length) {
                ((COSArray)cOSObject).add(COSFixed.create(fArray[n]));
                ++n;
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            cOSObject = COSArray.create(dArray.length);
            int n = 0;
            while (n < dArray.length) {
                ((COSArray)cOSObject).add(COSFixed.create(dArray[n]));
                ++n;
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            cOSObject = COSArray.create(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                ((COSArray)cOSObject).add(COSInteger.create(nArray[n]));
                ++n;
            }
        } else if (object instanceof Byte) {
            cOSObject = COSInteger.create(((Byte)object).intValue());
        } else if (object instanceof Short) {
            cOSObject = COSInteger.create(((Short)object).intValue());
        } else if (object instanceof Long) {
            cOSObject = COSInteger.create(((Long)object).intValue());
        } else if (object instanceof InputStream) {
            byte[] byArray;
            cOSObject = COSStream.create(null);
            try {
                byArray = StreamTools.toByteArray((InputStream)((InputStream)object));
            }
            catch (IOException iOException) {
                byArray = new byte[]{};
            }
            ((COSStream)cOSObject).setDecodedBytes(byArray);
        } else if (object instanceof COSObject) {
            cOSObject = (COSObject)object;
        } else {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(object)) + " can not be marshalled to a cos object");
        }
        return cOSObject;
    }

    public static Object toJava(COSObject cOSObject) {
        return COSConverter.toJava(cOSObject, new HashMap());
    }

    public static Object toJava(COSObject cOSObject, Map map) {
        Object object = map.get(cOSObject);
        if (object != null) {
            return object;
        }
        object = COSConverter.basicToJava(cOSObject, map);
        map.put(cOSObject, object);
        return object;
    }

    private COSConverter() {
    }
}

