/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.PNGAveragePrediction;
import de.intarsys.pdf.filter.PNGNonePrediction;
import de.intarsys.pdf.filter.PNGPaethPrediction;
import de.intarsys.pdf.filter.PNGPrediction;
import de.intarsys.pdf.filter.PNGSubPrediction;
import de.intarsys.pdf.filter.PNGUpPrediction;
import java.io.IOException;

public class PNGOptimumPrediction
extends PNGPrediction {
    private PNGPrediction average;
    private PNGPrediction none;
    private PNGPrediction paeth;
    private PNGPrediction sub;
    private PNGPrediction up;

    public PNGOptimumPrediction(COSDictionary cOSDictionary) {
        super(cOSDictionary);
        this.none = new PNGNonePrediction(cOSDictionary);
        this.sub = new PNGSubPrediction(cOSDictionary);
        this.up = new PNGUpPrediction(cOSDictionary);
        this.average = new PNGAveragePrediction(cOSDictionary);
        this.paeth = new PNGPaethPrediction(cOSDictionary);
    }

    @Override
    public void decodeRow(byte[] byArray, int n, byte[] byArray2, int n2) throws IOException {
        PNGPrediction pNGPrediction;
        switch (byArray[n] + 10) {
            case 10: {
                pNGPrediction = this.none;
                break;
            }
            case 11: {
                pNGPrediction = this.sub;
                break;
            }
            case 12: {
                pNGPrediction = this.up;
                break;
            }
            case 13: {
                pNGPrediction = this.average;
                break;
            }
            case 14: {
                pNGPrediction = this.paeth;
                break;
            }
            default: {
                throw new IOException("Unknown predictor function.");
            }
        }
        pNGPrediction.decodeRow(byArray, n, byArray2, n2);
    }
}

