/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.ofont.CMap;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.pobjects.fonts.ofont.OFont;
import org.icepdf.core.util.FontUtil;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
extends org.icepdf.core.pobjects.fonts.Font {
    private static final Logger logger = Logger.getLogger(Font.class.toString());
    private Encoding encoding;
    private String encodingName;
    private Vector widths;
    private Map<Integer, Float> cidWidths;
    private char[] cMap = new char[256];
    private CMap toUnicodeCMap;
    protected AFM afm;
    protected int style;
    private static final java.awt.Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    static final String[][] type1Diff = new String[][]{{"Bookman-Demi", "URWBookmanL-DemiBold", "Arial"}, {"Bookman-DemiItalic", "URWBookmanL-DemiBoldItal", "Arial"}, {"Bookman-Light", "URWBookmanL-Ligh", "Arial"}, {"Bookman-LightItalic", "URWBookmanL-LighItal", "Arial"}, {"Courier", "Nimbus Mono L Regular", "Nimbus Mono L"}, {"Courier-Oblique", "Nimbus Mono L Regular Oblique", "Nimbus Mono L"}, {"Courier-Bold", "Nimbus Mono L Bold", "Nimbus Mono L"}, {"Courier-BoldOblique", "Nimbus Mono L Bold Oblique", "Nimbus Mono L"}, {"AvantGarde-Book", "URWGothicL-Book", "Arial"}, {"AvantGarde-BookOblique", "URWGothicL-BookObli", "Arial"}, {"AvantGarde-Demi", "URWGothicL-Demi", "Arial"}, {"AvantGarde-DemiOblique", "URWGothicL-DemiObli", "Arial"}, {"Helvetica", "Nimbus Sans L Regular", "Nimbus Sans L"}, {"Helvetica-Oblique", "Nimbus Sans L Regular Italic", "Nimbus Sans L"}, {"Helvetica-Bold", "Nimbus Sans L Bold", "Nimbus Sans L"}, {"Helvetica-BoldOblique", "Nimbus Sans L Bold Italic", "Nimbus Sans L"}, {"Helvetica-Narrow", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Narrow-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Palatino-Roman", "URWPalladioL-Roma", "Arial"}, {"Palatino-Italic", "URWPalladioL-Ital", "Arial"}, {"Palatino-Bold", "URWPalladioL-Bold", "Arial"}, {"Palatino-BoldItalic", "URWPalladioL-BoldItal", "Arial"}, {"NewCenturySchlbk-Roman", "CenturySchL-Roma", "Arial"}, {"NewCenturySchlbk-Italic", "CenturySchL-Ital", "Arial"}, {"NewCenturySchlbk-Bold", "CenturySchL-Bold", "Arial"}, {"NewCenturySchlbk-BoldItalic", "CenturySchL-BoldItal", "Arial"}, {"Times-Roman", "Nimbus Roman No9 L Regular", "Nimbus Roman No9 L"}, {"Times-Italic", "Nimbus Roman No9 L Regular Italic", "Nimbus Roman No9 L"}, {"Times-Bold", "Nimbus Roman No9 L Medium", "Nimbus Roman No9 L"}, {"Times-BoldItalic", "Nimbus Roman No9 L Medium Italic", "Nimbus Roman No9 L"}, {"Symbol", "Standard Symbols L", "Standard Symbols L"}, {"ZapfChancery-MediumItalic", "URWChanceryL-MediItal", "Arial"}, {"ZapfDingbats", "Dingbats", "Dingbats"}};

    public Font(Library library, Hashtable entries) {
        super(library, entries);
        for (int i = 0; i < 256; i = (int)((char)(i + 1))) {
            this.cMap[i] = i;
        }
        this.style = FontUtil.guessAWTFontStyle(this.basefont);
        this.basefont = this.cleanFontName(this.basefont);
        if (this.subtype.equals("Type3")) {
            this.basefont = "Symbol";
            this.encoding = Encoding.getSymbol();
        }
        if (this.subtype.equals("Type1")) {
            if (this.basefont.equals("Symbol")) {
                this.encoding = Encoding.getSymbol();
            } else if (this.basefont.equalsIgnoreCase("ZapfDingbats") && this.subtype.equals("Type1")) {
                this.encoding = Encoding.getZapfDingBats();
            } else {
                for (String[] aType1Diff : type1Diff) {
                    if (!this.basefont.equals(aType1Diff[0])) continue;
                    this.encodingName = "standard";
                    this.encoding = Encoding.getStandard();
                    break;
                }
            }
        }
        if (this.subtype.equals("TrueType") && this.basefont.equals("Symbol")) {
            this.encodingName = "winAnsi";
            this.encoding = Encoding.getWinAnsi();
        }
    }

    @Override
    public synchronized void init() {
        block48: {
            AFM a;
            Object fontReference;
            Vector tmp;
            Object desendantFont;
            String name;
            AFM afm;
            Object of;
            Object o;
            Object objectUnicode;
            if (this.inited) {
                return;
            }
            if (this.encoding != null) {
                for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
                    this.cMap[i] = this.encoding.get(i);
                }
            }
            if ((objectUnicode = this.library.getObject(this.entries, "ToUnicode")) != null && objectUnicode instanceof Stream) {
                this.toUnicodeCMap = new CMap(this.library, new Hashtable(), (Stream)objectUnicode);
                this.toUnicodeCMap.init();
            }
            if ((o = this.library.getObject(this.entries, "Encoding")) != null) {
                if (o instanceof Hashtable) {
                    Hashtable encoding = (Hashtable)o;
                    this.setBaseEncoding(this.library.getName(encoding, "BaseEncoding"));
                    Vector differences = (Vector)this.library.getObject(encoding, "Differences");
                    if (differences != null) {
                        int c = 0;
                        for (Object oo : differences) {
                            if (oo instanceof Number) {
                                c = ((Number)oo).intValue();
                                continue;
                            }
                            if (!(oo instanceof Name)) continue;
                            String n = oo.toString();
                            int c1 = Encoding.getUV(n);
                            if (c1 == -1 && n.charAt(0) == 'a') {
                                n = n.substring(1);
                                try {
                                    c1 = Integer.parseInt(n);
                                }
                                catch (Exception ex) {
                                    logger.log(Level.FINE, "Error parings font differences");
                                }
                            }
                            this.cMap[c] = (char)c1;
                            ++c;
                        }
                    }
                } else if (o instanceof Name) {
                    this.setBaseEncoding(((Name)o).getName());
                }
            }
            this.widths = (Vector)this.library.getObject(this.entries, "Widths");
            if (this.widths != null) {
                o = this.library.getObject(this.entries, "FirstChar");
                if (o != null) {
                    this.firstchar = (int)this.library.getFloat(this.entries, "FirstChar");
                }
            } else if (this.library.getObject(this.entries, "W") != null) {
                this.cidWidths = this.calculateCIDWidths();
                this.firstchar = 0;
                this.isAFMFont = false;
            } else {
                this.isAFMFont = false;
            }
            if ((of = this.library.getObject(this.entries, "FontDescriptor")) instanceof FontDescriptor) {
                this.fontDescriptor = (FontDescriptor)of;
                this.fontDescriptor.init();
            }
            if (this.fontDescriptor == null && this.basefont != null && (afm = AFM.AFMs.get(this.basefont.toLowerCase())) != null && afm instanceof AFM) {
                AFM fontMetrix = afm;
                this.fontDescriptor = FontDescriptor.createDescriptor(this.library, fontMetrix);
                this.fontDescriptor.init();
            }
            if (this.fontDescriptor != null && (name = this.fontDescriptor.getFontName()) != null && name.length() > 0) {
                this.basefont = this.cleanFontName(name);
            }
            if (this.fontDescriptor != null && (this.fontDescriptor.getFlags() & 0x40) != 0 && this.encoding == null) {
                this.encodingName = "standard";
                this.encoding = Encoding.getStandard();
            }
            if ((desendantFont = this.library.getObject(this.entries, "DescendantFonts")) != null && (tmp = (Vector)desendantFont).elementAt(0) instanceof Reference && (fontReference = this.library.getObject((Reference)tmp.elementAt(0))) instanceof Font) {
                Font desendant = (Font)fontReference;
                desendant.toUnicodeCMap = this.toUnicodeCMap;
                desendant.init();
                this.cidWidths = desendant.cidWidths;
                if (this.fontDescriptor == null) {
                    this.fontDescriptor = desendant.fontDescriptor;
                    String name2 = this.fontDescriptor.getFontName();
                    if (name2 != null) {
                        this.basefont = this.cleanFontName(name2);
                    }
                }
            }
            if (this.subtype.equals("Type1") && (a = AFM.AFMs.get(this.basefont.toLowerCase())) != null && a.getFontName() != null) {
                this.afm = a;
            }
            if (this.subtype.equals("Type1")) {
                for (String[] aType1Diff : type1Diff) {
                    java.awt.Font f;
                    if (!this.basefont.equals(aType1Diff[0]) || !(f = new java.awt.Font(aType1Diff[1], this.style, 12)).getFamily().equals(aType1Diff[2])) continue;
                    this.basefont = aType1Diff[1];
                    break;
                }
            }
            this.isFontSubstitution = true;
            if (this.fontDescriptor != null && this.fontDescriptor.getEmbeddedFont() != null) {
                this.font = this.fontDescriptor.getEmbeddedFont();
                this.isFontSubstitution = false;
                this.isAFMFont = false;
            }
            if (this.font == null && this.basefont != null) {
                for (java.awt.Font font1 : fonts) {
                    StringTokenizer st = new StringTokenizer(font1.getPSName(), " ", false);
                    String fontName = "";
                    while (st.hasMoreElements()) {
                        fontName = fontName + st.nextElement();
                    }
                    if (!fontName.equalsIgnoreCase(this.basefont)) continue;
                    this.font = new OFont(new java.awt.Font(font1.getFamily(), this.style, 1));
                    this.basefont = font1.getPSName();
                    this.isFontSubstitution = true;
                    break;
                }
            }
            if (this.font == null && this.basefont != null) {
                String fontFamily = FontUtil.guessFamily(this.basefont);
                for (java.awt.Font font1 : fonts) {
                    if (!FontUtil.normalizeString(font1.getFamily()).equalsIgnoreCase(fontFamily)) continue;
                    this.font = new OFont(new java.awt.Font(font1.getFamily(), this.style, 1));
                    this.basefont = font1.getFontName();
                    this.isFontSubstitution = true;
                    break;
                }
            }
            if (this.font == null && this.basefont != null && this.basefont.indexOf("-") != -1) {
                this.font = new OFont(java.awt.Font.decode(this.basefont));
                this.basefont = this.font.getName();
            }
            if (this.font == null) {
                try {
                    this.font = new OFont(java.awt.Font.getFont(this.basefont, new java.awt.Font(this.basefont, this.style, 12)));
                    this.basefont = this.font.getName();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block48;
                    logger.warning("Error creating awt.font for: " + this.entries);
                }
            }
        }
        if (!this.isFontSubstitution && this.font != null && this.font.getName().toLowerCase().indexOf(this.font.getFamily().toLowerCase()) < 0) {
            if (this.font.getName().toLowerCase().indexOf("times new roman") != -1 || this.font.getName().toLowerCase().indexOf("timesnewroman") != -1 || this.font.getName().toLowerCase().indexOf("bodoni") != -1 || this.font.getName().toLowerCase().indexOf("garamond") != -1 || this.font.getName().toLowerCase().indexOf("minion web") != -1 || this.font.getName().toLowerCase().indexOf("stone serif") != -1 || this.font.getName().toLowerCase().indexOf("stoneserif") != -1 || this.font.getName().toLowerCase().indexOf("georgia") != -1 || this.font.getName().toLowerCase().indexOf("bitstream cyberbit") != -1) {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            } else if (this.font.getName().toLowerCase().indexOf("helvetica") != -1 || this.font.getName().toLowerCase().indexOf("arial") != -1 || this.font.getName().toLowerCase().indexOf("trebuchet") != -1 || this.font.getName().toLowerCase().indexOf("avant garde gothic") != -1 || this.font.getName().toLowerCase().indexOf("avantgardegothic") != -1 || this.font.getName().toLowerCase().indexOf("verdana") != -1 || this.font.getName().toLowerCase().indexOf("univers") != -1 || this.font.getName().toLowerCase().indexOf("futura") != -1 || this.font.getName().toLowerCase().indexOf("stone sans") != -1 || this.font.getName().toLowerCase().indexOf("stonesans") != -1 || this.font.getName().toLowerCase().indexOf("gill sans") != -1 || this.font.getName().toLowerCase().indexOf("gillsans") != -1 || this.font.getName().toLowerCase().indexOf("akzidenz") != -1 || this.font.getName().toLowerCase().indexOf("grotesk") != -1) {
                this.font = new OFont(new java.awt.Font("sansserif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "sansserif";
            } else if (this.font.getName().toLowerCase().indexOf("courier") != -1 || this.font.getName().toLowerCase().indexOf("courier new") != -1 || this.font.getName().toLowerCase().indexOf("couriernew") != -1 || this.font.getName().toLowerCase().indexOf("prestige") != -1 || this.font.getName().toLowerCase().indexOf("eversonmono") != -1 || this.font.getName().toLowerCase().indexOf("Everson Mono") != -1) {
                this.font = new OFont(new java.awt.Font("monospaced", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "monospaced";
            } else {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            }
        }
        if (this.font == null) {
            this.font = new OFont(new java.awt.Font("serif", this.style, 12));
            this.basefont = "serif";
        }
        this.setWidth();
        this.font = this.font.deriveFont(this.encoding, this.toUnicodeCMap);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.name + " - " + this.encodingName + " " + this.basefont + " " + this.font.toString() + " " + this.isFontSubstitution);
        }
        this.inited = true;
    }

    private void setBaseEncoding(String baseencoding) {
        if (baseencoding == null) {
            this.encodingName = "none";
            return;
        }
        if (baseencoding.equals("StandardEncoding")) {
            this.encodingName = "StandardEncoding";
            this.encoding = Encoding.getStandard();
        } else if (baseencoding.equals("MacRomanEncoding")) {
            this.encodingName = "MacRomanEncoding";
            this.encoding = Encoding.getMacRoman();
        } else if (baseencoding.equals("WinAnsiEncoding")) {
            this.encodingName = "WinAnsiEncoding";
            this.encoding = Encoding.getWinAnsi();
        } else if (baseencoding.equals("PDFDocEncoding")) {
            this.encodingName = "PDFDocEncoding";
            this.encoding = Encoding.getPDFDoc();
        }
        if (this.encoding != null) {
            for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
                this.cMap[i] = this.encoding.get(i);
            }
        }
    }

    @Override
    public String toString() {
        return "FONT= " + this.encodingName + " " + this.entries.toString();
    }

    private void setWidth() {
        float missingWidth = 0.0f;
        float ascent = 0.0f;
        float descent = 0.0f;
        if (this.fontDescriptor != null && this.fontDescriptor.getMissingWidth() > 0.0f) {
            missingWidth = this.fontDescriptor.getMissingWidth() / 1000.0f;
            ascent = this.fontDescriptor.getAscent() / 1000.0f;
            descent = this.fontDescriptor.getDescent() / 1000.0f;
        }
        if (this.widths != null) {
            float[] newWidth = new float[256 - this.firstchar];
            int max = this.widths.size();
            for (int i = 0; i < max; ++i) {
                if (this.widths.elementAt(i) == null) continue;
                newWidth[i] = ((Number)this.widths.elementAt(i)).floatValue() / 1000.0f;
            }
            this.font = this.font.deriveFont(newWidth, this.firstchar, missingWidth, ascent, descent, this.cMap);
        } else if (this.cidWidths != null) {
            this.font = this.font.deriveFont(this.cidWidths, this.firstchar, missingWidth, ascent, descent, null);
        } else if (this.afm != null) {
            this.font = this.font.deriveFont(this.afm.getWidths(), this.firstchar, missingWidth, ascent, descent, this.cMap);
        }
    }

    private String cleanFontName(String fontName) {
        int index;
        block5: {
            if (fontName.indexOf(43) >= 0) {
                index = fontName.indexOf(43);
                String tmp = fontName.substring(index + 1);
                try {
                    Integer.parseInt(tmp);
                    fontName = fontName.substring(0, index);
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine("error cleaning font base name " + fontName);
                }
            }
        }
        while (fontName.indexOf(43) >= 0) {
            index = fontName.indexOf(43);
            fontName = fontName.substring(index + 1, fontName.length());
        }
        if ((this.subtype.equals("Type0") || this.subtype.equals("Type1") || this.subtype.equals("MMType1") || this.subtype.equals("TrueType")) && fontName != null) {
            fontName = fontName.replace(',', '-');
        }
        return fontName;
    }

    private Map<Integer, Float> calculateCIDWidths() {
        HashMap<Integer, Float> cidWidths = new HashMap<Integer, Float>(75);
        Object o = this.library.getObject(this.entries, "W");
        if (o instanceof Vector) {
            Vector cidWidth = (Vector)o;
            int max = cidWidth.size() - 1;
            for (int i = 0; i < max; ++i) {
                int j;
                int currentChar;
                Object current = cidWidth.get(i);
                Object peek = cidWidth.get(i + 1);
                if (current instanceof Integer && peek instanceof Vector) {
                    currentChar = (Integer)current;
                    Vector subWidth = (Vector)peek;
                    int subMax = subWidth.size();
                    for (j = 0; j < subMax; ++j) {
                        if (subWidth.get(j) instanceof Integer) {
                            cidWidths.put(currentChar + j, Float.valueOf((float)((Integer)subWidth.get(j)).intValue() / 1000.0f));
                            continue;
                        }
                        if (!(subWidth.get(j) instanceof Float)) continue;
                        cidWidths.put(currentChar + j, Float.valueOf(((Float)subWidth.get(j)).floatValue() / 1000.0f));
                    }
                    ++i;
                }
                if (!(current instanceof Integer) || !(peek instanceof Integer)) continue;
                for (j = ((Integer)current).intValue(); j <= (Integer)peek; ++j) {
                    currentChar = j;
                    if (cidWidth.get(i + 2) instanceof Integer) {
                        cidWidths.put(currentChar, Float.valueOf((float)((Integer)cidWidth.get(i + 2)).intValue() / 1000.0f));
                        continue;
                    }
                    if (!(cidWidth.get(i + 2) instanceof Float)) continue;
                    cidWidths.put(currentChar, Float.valueOf(((Float)cidWidth.get(i + 2)).floatValue() / 1000.0f));
                }
                i += 2;
            }
        }
        return cidWidths;
    }
}

